(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2247288,      37326]
NotebookOptionsPosition[   2137900,      35134]
NotebookOutlinePosition[   2233476,      37091]
CellTagsIndexPosition[   2232728,      37061]
WindowTitle->Units: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Units", "SectionInline",ExpressionUUID->
   "a09d8f00-3442-48c9-b988-50d7f04edacb"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 16}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:87",ExpressionUUID->"33a86dff-4102-4065-bf9e-02d383103e9c"],

Cell[TextData[{
 "As soon as you\[CloseCurlyQuote]re dealing with real-world quantities, it\
\[CloseCurlyQuote]s inevitable that you\[CloseCurlyQuote]ll run into ",
 StyleBox["units",
  FontSlant->"Italic"],
 ". In the Wolfram Language, you can enter quantities with units using ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"3778f27d-65b0-43dd-8905-33b2907e89ae"]],
  FontSize->16,ExpressionUUID->"98ff22d8-c6ca-499a-9b52-c5f4ca105239"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"17c39ccc-3376-4708-950a-8d50968a0bc8"],

Cell["Enter a quantity of time in units of hours:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"44a0d236-ba81-40d6-8b04-2a04f44aba51"],

Cell[BoxData[
 NamespaceBox["LinguisticAssistant",
  DynamicModuleBox[{Typeset`query$$ = "2.6 hours", Typeset`boxes$$ = 
   TemplateBox[{"2.6", "\"h\"", "hours", "\"Hours\""}, "Quantity", SyntaxForm -> 
    Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
   Typeset`open$$ = {1}, Typeset`querystate$$ = {
   "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
    0.326123`5.964926422233987, "Messages" -> {}}}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
      Dynamic[Typeset`query$$], 
      Dynamic[Typeset`boxes$$], 
      Dynamic[Typeset`allassumptions$$], 
      Dynamic[Typeset`assumptions$$], 
      Dynamic[Typeset`open$$], 
      Dynamic[Typeset`querystate$$]], StandardForm],
    ImageSizeCache->{84., {9.5, 16.5}},
    TrackedSymbols:>{
     Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
      Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
   DynamicModuleValues:>{},
   UndoTrackedVariables:>{Typeset`open$$}],
  BaseStyle->{"Deploy"},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "Input",
 Deletable->False,ExpressionUUID->"705b4883-51cd-46b3-8fba-e71b46e3e312"],

Cell[BoxData[
 NamespaceBox["LinguisticAssistant",
  DynamicModuleBox[{Typeset`query$$ = "2.6 hours", Typeset`boxes$$ = 
   TemplateBox[{"2.6", "\"h\"", "hours", "\"Hours\""}, "Quantity", SyntaxForm -> 
    Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
   Typeset`open$$ = {1, 2}, Typeset`querystate$$ = {
   "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
    0.326123`5.964926422233987, "Messages" -> {}}}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
      Dynamic[Typeset`query$$], 
      Dynamic[Typeset`boxes$$], 
      Dynamic[Typeset`allassumptions$$], 
      Dynamic[Typeset`assumptions$$], 
      Dynamic[Typeset`open$$], 
      Dynamic[Typeset`querystate$$]], StandardForm],
    ImageSizeCache->{74., {10.5, 16.5}},
    TrackedSymbols:>{
     Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
      Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
   DynamicModuleValues:>{},
   UndoTrackedVariables:>{Typeset`open$$}],
  BaseStyle->{"Deploy"},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "Input",
 Deletable->False,ExpressionUUID->"40658f28-3f2e-4564-ae79-1aac654e9c45"],

Cell["Press the check mark to accept the interpretation: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5174640-be3c-4be4-8e65-2cd8d1337de0"],

Cell[BoxData[
 TemplateBox[{"2.6", "\"h\"", "hours", "\"Hours\""},
  "Quantity"]], "Input",
 Deletable->False,ExpressionUUID->"a4840583-d716-4d1c-9a47-4df98d4d129b"],

Cell[TextData[{
 "You can use ",
 ButtonBox["InputForm",
  BaseStyle->"Link"],
 " to see how the Wolfram Language internally represents this."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f9a7dbde-8b44-4d08-9d2e-a2aab24125bc"],

Cell["Show the internal form of a quantity:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"ddb46d2e-0c30-4cca-928a-d0796c991925"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "2.6 hours", Typeset`boxes$$ = 
    TemplateBox[{"2.6", "\"h\"", "hours", "\"Hours\""}, "Quantity", 
     SyntaxForm -> Mod], Typeset`allassumptions$$ = {}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.381196`6.0326933283084285, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{84., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"d64fd28c-912e-4cf4-8eac-9538d3b3ebca"],

Cell["Quantity[2.6, \"Hours\"]", "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,ExpressionUUID->"5ba03b09-72d7-4fc7-8238-8348a63d8054"]
}, Open  ]],

Cell[TextData[{
 "You can always enter quantities directly like this, or you can use ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"9b704949-e030-4c81-b438-0acaf58e986c"]],
  FontSize->16,ExpressionUUID->"0c0d83cb-db3e-4412-bf35-c951b6f047a5"],
 ", either for the whole thing, or just for the units."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7e951053-417a-412f-92e2-a8e2a25213c2"],

Cell[TextData[{
 "The Wolfram Language knows about ",
 "all the 10,000 or so",
 " common kinds of units. ",
 ButtonBox["UnitConvert",
  BaseStyle->"Link"],
 " converts between them. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"57fe4788-6f20-45bd-aa70-ac5709077652"],

Cell["Convert from hours to minutes:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"2eb94cd5-b7c5-41a1-abf4-a6fb5e6cb81b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   TemplateBox[{"2.6", "\"h\"", "hours", "\"Hours\""},
    "Quantity"], ",", "\"\<Minutes\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"3a6a4646-617f-4a93-8234-1f60b8ee18c2"],

Cell[BoxData[
 TemplateBox[{"156.`", "\"min\"", "minutes", "\"Minutes\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"2dec9fdd-d2d1-4f57-a901-95199515fdeb"]
}, Open  ]],

Cell["\<\
You can do arithmetic with quantities even if they have different units.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"b65081f7-2e1a-42b3-80b5-889b034cf4c0"],

Cell["Add a length in feet to one in centimeters:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"6f91be81-b4eb-4005-8dc0-e212ae8c5d17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "7.5 ft", Typeset`boxes$$ = 
    TemplateBox[{"7.5", "\"ft\"", "feet", "\"Feet\""}, "Quantity", SyntaxForm -> 
     Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.438597`6.093610650276828, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{54., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "+", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "14 cm", Typeset`boxes$$ = 
    TemplateBox[{"14", "\"cm\"", "centimeters", "\"Centimeters\""}, 
     "Quantity", SyntaxForm -> Mod], Typeset`allassumptions$$ = {}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.401785`6.055538712521372, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{62., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"6b02c14f-c90c-4dcf-ab8f-3524d79e37a5"],

Cell[BoxData[
 TemplateBox[{
  "242.60000000000002`", "\"cm\"", "centimeters", "\"Centimeters\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"34a86546-665e-48f8-83ec-f8c67f46ec80"]
}, Open  ]],

Cell["Divide one length by another:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc8c4d22-3074-47cd-8ec6-97b4f9601b2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "7.5 ft", Typeset`boxes$$ = 
    TemplateBox[{"7.5", "\"ft\"", "feet", "\"Feet\""}, "Quantity", SyntaxForm -> 
     Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.438597`6.093610650276828, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{54., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "/", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "14 cm", Typeset`boxes$$ = 
    TemplateBox[{"14", "\"cm\"", "centimeters", "\"Centimeters\""}, 
     "Quantity", SyntaxForm -> Mod], Typeset`allassumptions$$ = {}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.401785`6.055538712521372, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{62., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"f85f5dc0-04f6-4eef-8430-68d32938af25"],

Cell[BoxData["16.32857142857143`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[4]=",ExpressionUUID->"6cb08d11-d83c-499c-8394-7e7bcad8bebe"]
}, Open  ]],

Cell["You can compute with money too. ", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:88", "i:8"},ExpressionUUID->"2b45599c-b0e3-40e2-9dc2-3a55cb6987cb"],

Cell["Use dollars in a computation:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6e6a1e35-ca27-4258-89e3-d8c44ee184b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"7.5", "*", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "$3", Typeset`boxes$$ = 
     TemplateBox[{"3.", 
       RowBox[{
         FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
       "US dollars", "\"USDollars\""}, "QuantityPrefix", SyntaxForm -> Mod], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.346186`5.990854494222849, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{38., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True]}], "+", 
  RowBox[{"2.51", "*", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "$8", Typeset`boxes$$ = 
     TemplateBox[{"8.", 
       RowBox[{
         FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
       "US dollars", "\"USDollars\""}, "QuantityPrefix", SyntaxForm -> Mod], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.35389`6.000413284287829, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{38., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"46ee2d0c-8feb-499b-bc41-7394aba8022a"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox[
    TagBox[
     InterpretationBox["\"42.58\"", 42.58, AutoDelete -> True], 
     NumberForm[#, {Infinity, 2}, 
      ExponentFunction -> (If[-2 <= # <= 12, Null, #]& )]& ], 42.58, 
    Selectable -> False], 
   RowBox[{
     FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars", 
   "\"USDollars\""},
  "QuantityPrefix"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"e5b07da9-1281-459e-9ddb-e6c135ff9b0f"]
}, Open  ]],

Cell["Multiply a price per pound by a weight in kilograms:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"be8f828c-6c05-4ed4-8821-344ae36ee81d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "$15/lb", Typeset`boxes$$ = 
    TemplateBox[{"15", 
      RowBox[{
        FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
      RowBox[{"\"per \"", "\[InvisibleSpace]", "\"pound\""}], 
      "US dollars per pound", 
      FractionBox["\"USDollars\"", "\"Pounds\""]}, "QuantityPrefixUnit", 
     SyntaxForm -> Mod], 
    Typeset`allassumptions$$ = {{
     "type" -> "Unit", "word" -> "/lb", "template" -> 
      "Assuming ${desc1} for \"${word}\". Use ${desc2} instead", "count" -> 
      "2", "Values" -> {{
        "name" -> "USDollarsPerPound", "desc" -> "US dollars per pound", 
         "input" -> "UnitClash_*%2Flb.*USDollarsPerPound--"}, {
        "name" -> "USDollarsPerShortHundredweight", "desc" -> 
         "US dollars per short hundredweight", "input" -> 
         "UnitClash_*%2Flb.*USDollarsPerShortHundredweight--"}}}}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.355452`6.002325955685267, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{62., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "*", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "5.6 kg", Typeset`boxes$$ = 
    TemplateBox[{"5.6", "\"kg\"", "kilograms", "\"Kilograms\""}, "Quantity", 
     SyntaxForm -> Mod], 
    Typeset`allassumptions$$ = {{
     "type" -> "Unit", "word" -> "kg", "template" -> 
      "Assuming ${desc1} for \"${word}\". Use ${desc2} instead", "count" -> 
      "2", "Values" -> {{
        "name" -> "Kilograms", "desc" -> "kilograms", "input" -> 
         "UnitClash_*kg.*Kilograms--"}, {
        "name" -> "KilogramsForce", "desc" -> "kilograms\[Hyphen]force", 
         "input" -> "UnitClash_*kg.*KilogramsForce--"}}}}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.346625`5.991404876081892, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{62., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"8b3e5332-f3dc-4b84-8782-be9f63349b0c"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox[
    TagBox[
     InterpretationBox["\"185.19\"", 185.18830023529716`, AutoDelete -> True],
      NumberForm[#, {Infinity, 2}, 
      ExponentFunction -> (If[-2 <= # <= 12, Null, #]& )]& ], 
    185.18830023529716`, Selectable -> False], 
   RowBox[{
     FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars", 
   "\"USDollars\""},
  "QuantityPrefix"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"898d9137-1a17-4967-ae73-2d8c6db447ec"]
}, Open  ]],

Cell["\<\
You can convert between currencies. The Wolfram Language always knows the \
latest conversion rate.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"b4c500f3-e022-49be-b4b3-95ac3cda6954"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CurrencyConvert", "[", 
  RowBox[{
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "100 euros", Typeset`boxes$$ = 
     TemplateBox[{"100.", 
       RowBox[{
         FormBox["\"\[Euro]\"", TraditionalForm], "\[VeryThinSpace]"}], 
       "euros", "\"Euros\""}, "QuantityPrefix", SyntaxForm -> Mod], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.356251`6.003301085583058, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{88., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True], ",", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "US dollars", Typeset`boxes$$ = 
     TemplateBox[{
       InterpretationBox["\[InvisibleSpace]", 1], 
       RowBox[{
         FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
       "US dollars", "\"USDollars\""}, "QuantityPrefix", SyntaxForm -> Mod], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.380502`6.0319019373533695, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{90., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"eaa1136c-b391-4189-9f6c-58f0dc6819b2"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox[
    TagBox[
     InterpretationBox["\"112.10\"", 112.1, AutoDelete -> True], 
     NumberForm[#, {Infinity, 2}, 
      ExponentFunction -> (If[-2 <= # <= 12, Null, #]& )]& ], 112.1, 
    Selectable -> False], 
   RowBox[{
     FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], "US dollars", 
   "\"USDollars\""},
  "QuantityPrefix"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"b54eedbd-18a8-4550-8a2a-f896f6d7cb65"]
}, Open  ]],

Cell[TextData[{
 "There are many places where units show up. Another example is in angles\
\[LongDash]and this is such a common case that the Wolfram Language lets you \
handle it in a special way. You can enter an angle like 30 degrees either as ",
 Cell[BoxData[
  RowBox[{"30", " "}]], "InlineCodeText",ExpressionUUID->
  "4075d894-b79f-4a05-8443-a56314cd2e28"],
 ButtonBox["Degree",
  BaseStyle->"Link"],
 ", or as ",
 Cell[BoxData[
  RowBox[{"30", 
   ButtonBox["\[Degree]",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/character/Degree"]}]], "InlineCodeText",
  ExpressionUUID->"acc268eb-02f1-4dac-8d4f-1768ddfc299f"],
 ", where the ",
 Cell[BoxData[
  ButtonBox["\[Degree]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Degree"]], "InlineCodeText",
  ExpressionUUID->"12292228-034a-409c-895d-1e5fdfcb8f47"],
 " can be typed as ",
 Cell[BoxData[
  RowBox[{
   TemplateBox[{"esc"},
    "Key0"], " ", "deg", " ", 
   TemplateBox[{"esc"},
    "Key0"]}]], "InlineCodeText",
  FontSize->16,ExpressionUUID->"1e0c5455-4d91-4705-aaa7-89878e0f2f81"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"631c06ee-763d-499a-b601-d7135634489b"],

Cell["Display a string rotated by 30 degrees:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"141907c0-0399-4ad6-87fa-33c510552cef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rotate", "[", 
  RowBox[{"\"\<hello\>\"", ",", 
   RowBox[{"30", "\[Degree]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"e4c97cc5-27fc-435c-b55d-87dcb542cd1e"],

Cell[BoxData[
 RotationBox["\<\"hello\"\>",
  BoxRotation->0.5235987755982988]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"49867dca-bdfe-490e-8720-321378691e6f"]
}, Open  ]],

Cell[TextData[{
 "If you leave off the ",
 ButtonBox["Degree",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Degree"],
 ", the Wolfram Language will assume you\[CloseCurlyQuote]re talking about ",
 StyleBox["radians",
  FontSlant->"Italic"],
 ", which go from 0 to 2\[Pi] (about 6.28) around a circle, rather than \
degrees, which go from 0 to 360."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"3307fc3b-2c12-4d94-9936-44cfa2d66d58"],

Cell["\[Pi]/2 radians is equivalent to 90\[Degree]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"58ce21d6-058d-4500-b787-e703171eaf95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rotate", "[", 
  RowBox[{"\"\<hello\>\"", ",", 
   RowBox[{"Pi", "/", "2"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"f416299a-52ec-44e8-8028-44da7cd44d2b"],

Cell[BoxData[
 RotationBox["\<\"hello\"\>",
  BoxRotation->1.5707963267948966`]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"f55c312f-1caf-41c8-9b9f-afd9eb578e6b"]
}, Open  ]],

Cell["Make a list of rotations in degrees from 0 to 360:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad793073-582e-431c-bde7-74025bed31f0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{"n", ",", 
     RowBox[{"n", " ", "Degree"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "360", ",", "30"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"3e8e012f-c581-4382-9a0a-96a694235038"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RotationBox["0",
    BoxRotation->0.], ",", 
   RotationBox["30",
    BoxRotation->0.5235987755982988], ",", 
   RotationBox["60",
    BoxRotation->1.0471975511965976`], ",", 
   RotationBox["90",
    BoxRotation->1.5707963267948966`], ",", 
   RotationBox["120",
    BoxRotation->2.0943951023931953`], ",", 
   RotationBox["150",
    BoxRotation->2.6179938779914944`], ",", 
   RotationBox["180",
    BoxRotation->3.141592653589793], ",", 
   RotationBox["210",
    BoxRotation->3.6651914291880923`], ",", 
   RotationBox["240",
    BoxRotation->4.1887902047863905`], ",", 
   RotationBox["270",
    BoxRotation->4.71238898038469], ",", 
   RotationBox["300",
    BoxRotation->5.235987755982989], ",", 
   RotationBox["330",
    BoxRotation->5.759586531581287], ",", 
   RotationBox["360",
    BoxRotation->6.283185307179586]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[10]=",ExpressionUUID->"d6859abf-ef8d-4b48-ac3e-a9dcc4d9e616"]
}, Open  ]],

Cell[TextData[{
 "There\[CloseCurlyQuote]s lots to do with angles",
 ". For example, ",
 ButtonBox["AnglePath",
  BaseStyle->"Link"],
 " gives the path you\[CloseCurlyQuote]d follow if you successively turned by \
a sequence of angles."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:89", "i:14"},ExpressionUUID->"9ad8a3c3-dbc8-4540-a506-8a1a4b7e8352"],

Cell["Start off horizontal, then turn three times by 80\[Degree]:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"83d4176a-7c0e-4ed3-affa-c444a1ec1057"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"AnglePath", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Degree]"}], ",", 
      RowBox[{"80", "\[Degree]"}], ",", 
      RowBox[{"80", "\[Degree]"}], ",", 
      RowBox[{"80", "\[Degree]"}]}], "}"}], "]"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"d1284996-b26a-4870-987c-6686f990c180"],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{0, 0}, {1, 0}, {1 + Sin[10 Degree], Cos[10 Degree]}, {
     1 - Cos[20 Degree] + Sin[10 Degree], Cos[10 Degree] + Sin[20 Degree]}, {
     Rational[1, 2] - Cos[20 Degree] + Sin[10 Degree], 
      Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + Sin[20 Degree]}}, {{
     0, 0}, {1, 0}, {1.1736481776669303`, 0.984807753012208}, {
     0.2339555568810219, 1.3268278963378768`}, {-0.2660444431189781, 
     0.46080249255343814`}}]],
  ImageSize->{174.72265625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"98d0190e-c4aa-4185-8ed9-c42d9e5942ce"]
}, Open  ]],

Cell["\<\
Keep turning by 80\[Degree] and you\[CloseCurlyQuote]ll eventually get back \
to where you started:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3d75aadd-8b86-4247-8281-56d20c4958a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"AnglePath", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"80", "\[Degree]"}], ",", "20"}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"00decd3b-dc3e-499d-9524-7e6974c1c6df"],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{0, 0}, {
     Sin[10 Degree], Cos[10 Degree]}, {-Cos[20 Degree] + Sin[10 Degree], 
      Cos[10 Degree] + Sin[20 Degree]}, {
     Rational[-1, 2] - Cos[20 Degree] + Sin[10 Degree], 
      Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + Sin[20 Degree]}, {
     Rational[-1, 2] - Cos[20 Degree] + Cos[40 Degree] + Sin[10 Degree], 
      Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + Sin[20 Degree] - 
      Sin[40 Degree]}, {
     Rational[-1, 2] - Cos[20 Degree] + 2 Cos[40 Degree] + Sin[10 Degree], 
      Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + 
      Sin[20 Degree]}, {-1 - Cos[20 Degree] + 2 Cos[40 Degree] + 
      Sin[10 Degree], Cos[10 Degree] + Sin[20 Degree]}, {-1 - 2 
      Cos[20 Degree] + 2 Cos[40 Degree] + Sin[10 Degree], Cos[
      10 Degree]}, {-1 - 2 Cos[20 Degree] + 2 Cos[40 Degree] + 
      2 Sin[10 Degree], 0}, {(-2) Cos[20 Degree] + 2 Cos[40 Degree] + 
      2 Sin[10 Degree], 0}, {(-2) Cos[20 Degree] + 2 Cos[40 Degree] + 
      3 Sin[10 Degree], Cos[10 Degree]}, {(-3) Cos[20 Degree] + 
      2 Cos[40 Degree] + 3 Sin[10 Degree], Cos[10 Degree] + Sin[20 Degree]}, {
     Rational[-1, 2] - 3 Cos[20 Degree] + 2 Cos[40 Degree] + 3 Sin[10 Degree],
       Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + Sin[20 Degree]}, {
     Rational[-1, 2] - 3 Cos[20 Degree] + 3 Cos[40 Degree] + 3 Sin[10 Degree],
       Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + Sin[20 Degree] - 
      Sin[40 Degree]}, {
     Rational[-1, 2] - 3 Cos[20 Degree] + 4 Cos[40 Degree] + 3 Sin[10 Degree],
       Rational[-1, 2] 3^Rational[1, 2] + Cos[10 Degree] + 
      Sin[20 Degree]}, {-1 - 3 Cos[20 Degree] + 4 Cos[40 Degree] + 
      3 Sin[10 Degree], Cos[10 Degree] + Sin[20 Degree]}, {-1 - 4 
      Cos[20 Degree] + 4 Cos[40 Degree] + 3 Sin[10 Degree], Cos[
      10 Degree]}, {-1 - 4 Cos[20 Degree] + 4 Cos[40 Degree] + 
      4 Sin[10 Degree], 0}, {(-4) Cos[20 Degree] + 4 Cos[40 Degree] + 
      4 Sin[10 Degree], 0}, {(-4) Cos[20 Degree] + 4 Cos[40 Degree] + 
      5 Sin[10 Degree], Cos[10 Degree]}, {(-5) Cos[20 Degree] + 
      4 Cos[40 Degree] + 5 Sin[10 Degree], Cos[10 Degree] + 
      Sin[20 Degree]}}, {{0, 0}, {0.17364817766693033`, 
     0.984807753012208}, {-0.7660444431189781, 
     1.3268278963378768`}, {-1.2660444431189781`, 
     0.46080249255343814`}, {-0.5000000000000001, -0.18198511713310112`}, {
     0.2660444431189779, 0.46080249255343814`}, {-0.2339555568810221, 
     1.3268278963378768`}, {-1.1736481776669305`, 
     0.984807753012208}, {-1.0000000000000002`, 
      0}, {-1.6653345369377348`*^-16, 0}, {0.1736481776669302, 
     0.984807753012208}, {-0.7660444431189782, 
     1.3268278963378768`}, {-1.2660444431189783`, 
     0.46080249255343814`}, {-0.5, -0.18198511713310112`}, {
     0.2660444431189779, 0.46080249255343814`}, {-0.2339555568810221, 
     1.3268278963378768`}, {-1.1736481776669305`, 
     0.984807753012208}, {-1.0000000000000004`, 
      0}, {-3.3306690738754696`*^-16, 0}, {0.17364817766692997`, 
     0.984807753012208}, {-0.7660444431189789, 1.3268278963378768`}}]],
  ImageSize->{174.94140625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"3e3f2445-72e6-4d64-9459-411acee34f4d"]
}, Open  ]],

Cell["\<\
If you keep increasing the angle, you get an interesting pattern:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"8355d45f-9819-483e-951f-6ed4ce93694e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"AnglePath", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"n", "*", "5", "\[Degree]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "200"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"bd30f91b-deaf-4a68-9556-6301a7826e87"],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{0, 0}, {
     Cos[5 Degree], Sin[
      5 Degree]}, {(Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
      Cos[5 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      5 Degree] + Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], -2^Rational[-1, 2] + (Rational[1, 2] 
        2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      5 Degree] + Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] - Cos[
      40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 2 3^Rational[1, 2] + Cos[5 Degree],
       2^Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {-1 - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] - 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[40 Degree] - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {-1 - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] - 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 2 3^Rational[1, 2] + Cos[5 Degree],
       2^Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^Rational[-1, 2] + 
      Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], -2^Rational[-1, 2] + (Rational[-3, 2] 
        2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[1, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 
      Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      Sin[5 Degree]}, {(Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + 
      Cos[5 Degree], (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      Sin[5 Degree]}, {Cos[5 Degree], Sin[5 Degree]}, {0, 0}, {-1, 0}, {-2, 
     0}, {-2 - Cos[5 Degree], -
      Sin[5 Degree]}, {-2 + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[
      5 Degree], (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) - 
      Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[40 Degree] - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[40 Degree] - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - 
      Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 
      2^Rational[-1, 2] - 3^
      Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - 
      Sin[40 Degree], 
      2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 
      2^Rational[-1, 2] + 
      Rational[-3, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - 
      Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 
      2^Rational[-1, 2] + 
      Rational[-3, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-3, 2] 3^Rational[1, 2] - Cos[5 Degree] + Cos[40 Degree] - Sin[
      40 Degree], Rational[-1, 2] + 2^Rational[-1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] - Sin[40 Degree], Rational[-1, 2] + 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - Cos[5 Degree] - Sin[
      40 Degree], Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] - Sin[40 Degree], Rational[-1, 2] - 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree], Rational[-1, 2] - 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 3^Rational[1, 2] - Cos[
      5 Degree], -2^Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {-1 + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {
     Rational[-3, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {
     Rational[-3, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], -1 + Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree]}, {-1 - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree]}, {-1 - 2 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] + Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] + Sin[5 Degree] + Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2 
      3^Rational[1, 2] - 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], (-2^Rational[1, 2]) (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2 
      3^Rational[1, 2] - 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2 
      3^Rational[1, 2] - 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], -1 - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], -1 + Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], -1 + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {-1 + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2])}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 
      3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], -2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] - 2 3^Rational[1, 2] - Cos[
      5 Degree], -2^Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree], Rational[-1, 2] - 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] - Sin[40 Degree], Rational[-1, 2] - 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - Cos[5 Degree] - Sin[
      40 Degree], Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] - Sin[40 Degree], Rational[-1, 2] + 2^Rational[-1, 2] + 
      Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 2^Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2] - 
      Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + Rational[1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-3, 2] 3^Rational[1, 2] - Cos[5 Degree] + Cos[40 Degree] - Sin[
      40 Degree], Rational[-1, 2] + 2^Rational[-1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-3, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-3, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - 
      Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] - 
      3^Rational[
       1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - 
      Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 
      2^Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[5 Degree] - 
      Sin[40 Degree], Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2^Rational[-1, 2] + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + 
      2^Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 
       3^Rational[1, 2]) + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[40 Degree] - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - Cos[
      40 Degree] - Sin[5 Degree]}, {-2 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 
      Rational[-1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - Sin[
      5 Degree]}, {-2 + (Rational[-1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[
      5 Degree], (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) - 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {-2 - Cos[
      5 Degree], -Sin[5 Degree]}, {-2, 0}, {-1, 0}, {0, 0}, {
     Cos[5 Degree], Sin[
      5 Degree]}, {(Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
      Cos[
       5 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) + 
      Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree]}, {
     Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[1, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      5 Degree] + Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], -2^Rational[-1, 2] + (Rational[1, 2] 
        2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[
      5 Degree] + Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + 
      Rational[3, 2] 
       3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) + Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], 
      Rational[1, 2] - 2^
      Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
      Cos[40 Degree] + Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^
      Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] - Cos[
      40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 2 3^Rational[1, 2] + Cos[5 Degree],
       2^Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {-1 - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] - 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[40 Degree] - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[5 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[5 Degree] - Cos[
      40 Degree] - Sin[5 Degree] - Sin[40 Degree]}, {-1 + 2 3^Rational[1, 2] + 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) - Cos[5 Degree] + 
      Cos[40 Degree] - Sin[40 Degree], 1 + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {-1 + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] + Cos[40 Degree] - Sin[40 Degree], 
      1 + Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree] - Sin[40 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 
       3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree] - Sin[40 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Cos[40 Degree] - Sin[
      5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 1 + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) - Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) - Sin[5 Degree]}, {
     Rational[-1, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {-1 - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] - 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]), 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2])}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 
      2 3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
        3^Rational[1, 2]) + Cos[5 Degree], 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
        2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + 2 3^Rational[1, 2] + Cos[5 Degree],
       2^Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] + 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] + Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] + 
      Sin[40 Degree], Rational[1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] + Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] + 
      Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree]}, {
     Rational[-3, 2] - 2^Rational[-1, 2] + Rational[3, 2] 3^Rational[1, 2] + 
      Cos[5 Degree] - Cos[40 Degree] + Sin[40 Degree], Rational[1, 2] - 2^
      Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}, {-1 - 2^Rational[-1, 2] + 
      Rational[3, 2] 3^Rational[1, 2] + Cos[5 Degree] - Cos[40 Degree] + 
      Sin[40 Degree], Rational[1, 2] - 2^Rational[-1, 2] - 
      2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
      2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + Cos[40 Degree] + 
      Sin[5 Degree] + Sin[40 Degree]}}, {{0, 0}, {0.9961946980917455, 
     0.08715574274765817}, {1.9621205243808137`, 0.3459747878501789}, {
     2.8281459281652523`, 0.8459747878501789}, {3.4709335378517916`, 
     1.6120192309691568`}, {3.729752582954313, 2.577945057258225}, {
     3.4709335378517916`, 3.543870883547293}, {2.7048890947328137`, 
     4.186658493233832}, {1.7048890947328137`, 4.186658493233832}, {
     0.9977823135462661, 3.479551712047285}, {1.0849380562939244`, 
     2.4833570139555396`}, {1.9509634600783627`, 1.9833570139555394`}, {
     2.8169888638628016`, 2.4833570139555396`}, {2.7298331211151434`, 
     3.479551712047285}, {1.7639072948260752`, 3.7383707571498057`}, {
     1.2639072948260752`, 2.872345353365367}, {2.029951737945053, 
     2.2295577436788276`}, {2.737058519131601, 2.936664524865375}, {
     2.029951737945053, 3.6437713060519226`}, {1.3871641282585139`, 
     2.8777268629329447`}, {2.2531895320429522`, 2.3777268629329447`}, {
     2.5120085771454734`, 3.343652689222013}, {1.5158138790537277`, 
     3.256496946474355}, {2.0158138790537277`, 2.3904715426899164`}, {
     2.5158138790537277`, 3.256496946474355}, {1.5196191809619821`, 
     3.1693412037266966`}, {2.22672596214853, 2.462234422540149}, {
     2.22672596214853, 3.462234422540149}, {1.5839383524619903`, 
     2.6961899794211712`}, {2.5498641787510588`, 2.955009024523692}, {
     1.5839383524619903`, 3.2138280696262127`}, {2.3499827955809685`, 
     2.5710404599396735`}, {1.8499827955809685`, 3.4370658637241127`}, {
     2.108801840683489, 2.471140037435044}, {2.0216460979358306`, 
     3.4673347355267894`}, {2.0216460979358306`, 2.4673347355267894`}, {
     2.0216460979358306`, 3.4673347355267894`}, {2.108801840683489, 
     2.471140037435044}, {1.8499827955809685`, 3.4370658637241127`}, {
     2.3499827955809685`, 2.5710404599396735`}, {1.5839383524619903`, 
     3.2138280696262127`}, {2.5498641787510588`, 2.955009024523692}, {
     1.5839383524619903`, 2.6961899794211717`}, {2.22672596214853, 
     3.4622344225401496`}, {2.22672596214853, 2.4622344225401496`}, {
     1.5196191809619821`, 3.169341203726697}, {2.5158138790537277`, 
     3.256496946474355}, {2.0158138790537277`, 2.3904715426899164`}, {
     1.5158138790537277`, 3.256496946474355}, {2.5120085771454734`, 
     3.3436526892220138`}, {2.2531895320429522`, 2.377726862932945}, {
     1.3871641282585139`, 2.877726862932945}, {2.029951737945053, 
     3.643771306051923}, {2.737058519131601, 2.9366645248653755`}, {
     2.029951737945053, 2.229557743678828}, {1.2639072948260752`, 
     2.8723453533653673`}, {1.7639072948260752`, 3.7383707571498057`}, {
     2.7298331211151434`, 3.479551712047285}, {2.8169888638628016`, 
     2.4833570139555396`}, {1.9509634600783627`, 1.9833570139555396`}, {
     1.0849380562939244`, 2.4833570139555396`}, {0.9977823135462661, 
     3.479551712047285}, {1.7048890947328137`, 4.186658493233832}, {
     2.7048890947328137`, 4.186658493233832}, {3.4709335378517916`, 
     3.543870883547293}, {3.729752582954313, 2.577945057258225}, {
     3.4709335378517916`, 1.612019230969157}, {2.8281459281652523`, 
     0.845974787850179}, {1.9621205243808137`, 0.345974787850179}, {
     0.9961946980917455, 0.08715574274765817}, {0, 0}, {-1, 0}, {-2, 
     0}, {-2.9961946980917453`, -0.08715574274765817}, {-3.962120524380814, \
-0.3459747878501789}, {-4.828145928165252, -0.8459747878501789}, \
{-5.470933537851791, -1.6120192309691568`}, {-5.729752582954312, \
-2.577945057258225}, {-5.470933537851791, -3.543870883547293}, \
{-4.704889094732813, -4.186658493233832}, {-3.7048890947328137`, \
-4.186658493233832}, {-2.997782313546266, -3.479551712047285}, \
{-3.084938056293924, -2.4833570139555396`}, {-3.9509634600783627`, \
-1.9833570139555394`}, {-4.816988863862802, -2.4833570139555396`}, \
{-4.729833121115144, -3.479551712047285}, {-3.7639072948260752`, \
-3.7383707571498057`}, {-3.2639072948260752`, -2.872345353365367}, \
{-4.029951737945053, -2.2295577436788276`}, {-4.737058519131601, \
-2.936664524865375}, {-4.029951737945053, -3.6437713060519226`}, \
{-3.387164128258514, -2.8777268629329447`}, {-4.253189532042953, \
-2.3777268629329447`}, {-4.512008577145473, -3.343652689222013}, \
{-3.5158138790537277`, -3.256496946474355}, {-4.015813879053727, \
-2.3904715426899164`}, {-4.515813879053727, -3.256496946474355}, \
{-3.519619180961983, -3.1693412037266966`}, {-4.22672596214853, \
-2.462234422540149}, {-4.22672596214853, -3.462234422540149}, \
{-3.58393835246199, -2.6961899794211712`}, {-4.549864178751059, \
-2.955009024523692}, {-3.58393835246199, -3.2138280696262127`}, \
{-4.349982795580968, -2.5710404599396735`}, {-3.8499827955809685`, \
-3.4370658637241127`}, {-4.108801840683489, -2.471140037435044}, \
{-4.021646097935831, -3.4673347355267894`}, {-4.021646097935831, \
-2.4673347355267894`}, {-4.021646097935831, -3.4673347355267894`}, \
{-4.108801840683489, -2.471140037435044}, {-3.8499827955809685`, \
-3.4370658637241127`}, {-4.349982795580968, -2.5710404599396735`}, \
{-3.58393835246199, -3.2138280696262127`}, {-4.549864178751059, \
-2.955009024523692}, {-3.58393835246199, -2.6961899794211717`}, \
{-4.22672596214853, -3.4622344225401496`}, {-4.22672596214853, \
-2.4622344225401496`}, {-3.519619180961983, -3.169341203726697}, \
{-4.515813879053727, -3.256496946474355}, {-4.015813879053727, \
-2.3904715426899164`}, {-3.5158138790537277`, -3.256496946474355}, \
{-4.512008577145473, -3.3436526892220138`}, {-4.253189532042953, \
-2.377726862932945}, {-3.387164128258514, -2.877726862932945}, \
{-4.029951737945053, -3.643771306051923}, {-4.737058519131601, \
-2.9366645248653755`}, {-4.029951737945053, -2.229557743678828}, \
{-3.2639072948260752`, -2.8723453533653673`}, {-3.7639072948260752`, \
-3.7383707571498057`}, {-4.729833121115144, -3.479551712047285}, \
{-4.816988863862802, -2.4833570139555396`}, {-3.9509634600783627`, \
-1.9833570139555396`}, {-3.084938056293924, -2.4833570139555396`}, \
{-2.997782313546266, -3.479551712047285}, {-3.7048890947328137`, \
-4.186658493233832}, {-4.704889094732813, -4.186658493233832}, \
{-5.470933537851791, -3.543870883547293}, {-5.729752582954312, \
-2.577945057258225}, {-5.470933537851791, -1.612019230969157}, \
{-4.828145928165252, -0.845974787850179}, {-3.962120524380814, \
-0.345974787850179}, {-2.9961946980917453`, -0.08715574274765817}, {-2, 
     0}, {-1, 0}, {0, 0}, {0.9961946980917455, 0.08715574274765817}, {
     1.9621205243808137`, 0.3459747878501789}, {2.8281459281652523`, 
     0.8459747878501789}, {3.4709335378517916`, 1.6120192309691568`}, {
     3.729752582954313, 2.577945057258225}, {3.4709335378517916`, 
     3.543870883547293}, {2.7048890947328137`, 4.186658493233832}, {
     1.7048890947328137`, 4.186658493233832}, {0.9977823135462661, 
     3.479551712047285}, {1.0849380562939244`, 2.4833570139555396`}, {
     1.9509634600783627`, 1.9833570139555394`}, {2.8169888638628016`, 
     2.4833570139555396`}, {2.7298331211151434`, 3.479551712047285}, {
     1.7639072948260752`, 3.7383707571498057`}, {1.2639072948260752`, 
     2.872345353365367}, {2.029951737945053, 2.2295577436788276`}, {
     2.737058519131601, 2.936664524865375}, {2.029951737945053, 
     3.6437713060519226`}, {1.3871641282585139`, 2.8777268629329447`}, {
     2.2531895320429522`, 2.3777268629329447`}, {2.5120085771454734`, 
     3.343652689222013}, {1.5158138790537277`, 3.256496946474355}, {
     2.0158138790537277`, 2.3904715426899164`}, {2.5158138790537277`, 
     3.256496946474355}, {1.5196191809619821`, 3.1693412037266966`}, {
     2.22672596214853, 2.462234422540149}, {2.22672596214853, 
     3.462234422540149}, {1.5839383524619903`, 2.6961899794211712`}, {
     2.5498641787510588`, 2.955009024523692}, {1.5839383524619903`, 
     3.2138280696262127`}, {2.3499827955809685`, 2.5710404599396735`}, {
     1.8499827955809685`, 3.4370658637241127`}, {2.108801840683489, 
     2.471140037435044}, {2.0216460979358306`, 3.4673347355267894`}, {
     2.0216460979358306`, 2.4673347355267894`}, {2.0216460979358306`, 
     3.4673347355267894`}, {2.108801840683489, 2.471140037435044}, {
     1.8499827955809685`, 3.4370658637241127`}, {2.3499827955809685`, 
     2.5710404599396735`}, {1.5839383524619903`, 3.2138280696262127`}, {
     2.5498641787510588`, 2.955009024523692}, {1.5839383524619903`, 
     2.6961899794211717`}, {2.22672596214853, 3.4622344225401496`}, {
     2.22672596214853, 2.4622344225401496`}, {1.5196191809619821`, 
     3.169341203726697}, {2.5158138790537277`, 3.256496946474355}, {
     2.0158138790537277`, 2.3904715426899164`}, {1.5158138790537277`, 
     3.256496946474355}, {2.5120085771454734`, 3.3436526892220138`}, {
     2.2531895320429522`, 2.377726862932945}, {1.3871641282585139`, 
     2.877726862932945}, {2.029951737945053, 3.643771306051923}, {
     2.737058519131601, 2.9366645248653755`}, {2.029951737945053, 
     2.229557743678828}, {1.2639072948260752`, 2.8723453533653673`}, {
     1.7639072948260752`, 3.7383707571498057`}}]],
  ImageSize->{175.12890625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"7db94279-ac57-4d09-9195-a86f2be4d51f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f8786541-892a-46bb-a742-e493aee72e8e"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["UnitConvert",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["quantity", "CodeVariableLrg"], ",", 
      StyleBox["unit", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "convert between units ", "VocabularyText",ExpressionUUID->
     "0018cf03-483f-4115-b9b8-a985887ef211"]},
   {
    RowBox[{
     ButtonBox["CurrencyConvert",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["amount", "CodeVariableLrg"], ",", 
      StyleBox["unit", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "convert between currencies ", "VocabularyText",ExpressionUUID->
     "3cb2ed39-4f3a-416c-86b9-b87fa57f6331"]},
   {
    RowBox[{"30", " ", 
     ButtonBox["Degree",
      BaseStyle->"Link"]}], " ", Cell[
    "angle in degrees ", "VocabularyText",ExpressionUUID->
     "fb0c7727-0273-4d66-b142-0147db12045d"]},
   {
    RowBox[{"30", 
     ButtonBox["\[Degree]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Degree"]}], " ", Cell[TextData[{
     "angle in degrees entered with ",
     Cell[BoxData[
      TemplateBox[{
        StyleBox["esc", FontWeight -> "Plain"]},
       "Key0"]],ExpressionUUID->"b6ad6188-3139-4453-938f-b307a3e7f62e"],
     "\[ThickSpace]deg\[ThickSpace]",
     Cell[BoxData[
      TemplateBox[{
        StyleBox["esc", FontWeight -> "Plain"]},
       "Key0"]],ExpressionUUID->"cb249c88-e7ff-4581-ba1b-9d97983ba1b1"]
    }], "VocabularyText",ExpressionUUID->
     "54656cfa-3c50-409f-8769-4a90641018e5"]},
   {
    RowBox[{
     ButtonBox["Rotate",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["angle", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "rotate on the screen ", "VocabularyText",ExpressionUUID->
     "cc6b4316-8d9b-4d70-8bec-4a2c82368637"]},
   {
    RowBox[{
     ButtonBox["AnglePath",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["angle", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["angle", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "path derived from a sequence of turns ", "VocabularyText",ExpressionUUID->
     "9fb0ad30-9ae6-4552-9200-2c4664ebaa66"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"1de6f638-c75a-4a61-ace3-982031b6fc8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"0aab0134-2f90-405c-9e12-e50e0cbbf172"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"14 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 6 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>NotebookLocate[{"EIWL2-17-units-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9f72b390-ab65-4604-b489-f8b79c0c153d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Convert 4.5 lbs (pounds) to kilograms.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"842f9abd-8386-441b-a487-ae00677db899"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"2.041165665`", "\"kg\"", "kilograms", "\"Kilograms\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "319be874-2127-4769-bf5a-f8042519061f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"2.041165665`", "\"kg\"", "kilograms", "\"Kilograms\""},
           "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"60119036-b4e6-41c8-b7ee-57d674f5e529"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Convert 60.25 mph to kilometers per hour.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4b9aa04f-e2c6-48df-91d3-59112ed12ff8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"96.962976`", 
         RowBox[{
          "\"km\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
           "\"h\""}], "kilometers per hour", 
         FractionBox["\"Kilometers\"", "\"Hours\""]},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "ef205219-8c6f-4a7b-be84-530a3774540c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"96.962976`", 
           
           RowBox[{"\"km\"", "\[InvisibleSpace]", "\"/\"", 
             "\[InvisibleSpace]", "\"h\""}], "kilometers per hour", 
           FractionBox["\"Kilometers\"", "\"Hours\""]}, "Quantity"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e45f1881-69d2-4269-a9f6-fd17c91d7cd8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the height of the Eiffel Tower in miles.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"0f60dc6e-b14f-4753-8bad-55f5368d51a5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"0.2013242662848962`", "\"mi\"", "miles", "\"Miles\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "7583a095-1fc3-4393-86af-d1efc870fa40"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"0.2013242662848962`", "\"mi\"", "miles", "\"Miles\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c890cb20-20ea-4a05-b3a5-d8cf8e8f8c87"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the height of Mount Everest divided by the height of the Eiffel Tower.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fce88bb1-b78c-4cc6-8214-3c8d2c9fefde"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "27.30864197530864`"], "ExerciseOutput",ExpressionUUID->
       "e2866d27-f042-4e98-a386-27b1fba31466"],
      Apply[TextCell, 
       Cell[
        BoxData["27.30864197530864`"], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a138cdeb-8535-4698-b3f1-c8f0fd1b0ac2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the mass of the Earth divided by the mass of the Moon.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2216d66e-e754-4040-8d7f-7f799b54e150"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "81.29974660631749075681431899846638647962`4.995248844409004"], 
       "ExerciseOutput",ExpressionUUID->
       "f9870096-9c92-492f-9d08-cce6e1a7ebc0"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "81.29974660631749075681431899846638647962`4.995248844409004"], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e3c38077-d549-4875-b1d3-de3479143848"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Convert 2500 Japanese yen to US dollars.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8f55a4c9-6f40-44c3-908b-6b1c6a6195e2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"20.`", 
         RowBox[{
           FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
         "US dollars", "\"USDollars\""},
        "QuantityPrefix"]], "ExerciseOutput",ExpressionUUID->
       "5f08efd8-94bb-4986-adc1-80e1eaa261c9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"20.`", 
           RowBox[{
             FormBox["\"$\"", TraditionalForm], "\[VeryThinSpace]"}], 
           "US dollars", "\"USDollars\""}, "QuantityPrefix"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c49145e4-cea6-4674-a593-c0125c64daa3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the total of 35 ounces, 1/4 ton, 45 lbs and 9 stone in kilograms.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"030e983a-4087-454b-8244-12d0be18e3da"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
        "305.352713579375`", "\"kg\"", "kilograms", "\"Kilograms\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "c20c36f9-db8f-49c0-949e-2ff6117d0f60"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
          "305.352713579375`", "\"kg\"", "kilograms", "\"Kilograms\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"89176ab1-1003-409f-8efc-18f9e0e9612b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Get a list of the distances to each planet using the ",
 Cell[BoxData["\<\"DistanceFromEarth\"\>"], "InlineCode",ExpressionUUID->
  "4fb6a8d6-c771-4674-8b24-664bc824b091"],
 " property, and convert all the results to light minutes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a6e0f99c-d23e-4cdd-9a86-8cf7119e49af"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         TemplateBox[{
          "6.161523278336898`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "4.577135291101857`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "0.`", "\"light minutes\"", "light minutes", "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "19.5931757277313`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "51.767418716079064`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "88.49782952561114`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "157.9112226493515`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"], ",", 
         TemplateBox[{
          "242.4219190225964`", "\"light minutes\"", "light minutes", 
           "\"LightMinutes\""},
          "Quantity"]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "ee14e919-207b-4157-afd9-b37502303310"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             
             TemplateBox[{
              "6.161523278336898`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "4.577135291101857`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "0.`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "19.5931757277313`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "51.767418716079064`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "88.49782952561114`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "157.9112226493515`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"], ",", 
             
             TemplateBox[{
              "242.4219190225964`", "\"light minutes\"", "light minutes", 
               "\"LightMinutes\""}, "Quantity"]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f7e995ea-4331-431e-b7ed-55ad584662d8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Rotate the string ",
 Cell[BoxData["\<\"hello\"\>"], "InlineCode",ExpressionUUID->
  "d103414e-d2c0-498e-8134-74dd8ac76690"],
 " by 180\[Degree].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7949b0f0-0df9-4158-bf2d-93eda0d0f65e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RotationBox["\<\"hello\"\>",
        BoxRotation->3.141592653589793]], "ExerciseOutput",ExpressionUUID->
       "c2652aa3-4179-47b9-b5d6-081724772dfe"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RotationBox["\"hello\"", BoxRotation -> 3.141592653589793]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"923a1155-91cd-458c-86dd-f4e525d32b89"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of a size-100 \[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] \
rotated by 0\[Degree] through 360\[Degree] in steps of 30\[Degree].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"82ef06e2-ccf2-4b89-a6ed-e77d710a99b2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->0.], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->0.5235987755982988], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->1.0471975511965976`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->1.5707963267948966`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->2.0943951023931953`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->2.6179938779914944`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->3.141592653589793], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->3.6651914291880923`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->4.1887902047863905`], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->4.71238898038469], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->5.235987755982989], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->5.759586531581287], ",", 
         RotationBox[
          StyleBox["\<\"A\"\>",
           StripOnInput->False,
           FontSize->100],
          BoxRotation->6.283185307179586]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"315089ad-bc2b-470a-81a5-9234398e88f6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 0.], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 0.5235987755982988], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 1.0471975511965976`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 1.5707963267948966`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 2.0943951023931953`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 2.6179938779914944`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 3.141592653589793], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 3.6651914291880923`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 4.1887902047863905`], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 4.71238898038469], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 5.235987755982989], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 5.759586531581287], ",", 
             RotationBox[
              StyleBox["\"A\"", StripOnInput -> False, FontSize -> 100], 
              BoxRotation -> 6.283185307179586]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a669e831-ab14-4f09-b7bb-1c307b0ba64e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " to rotate an image of a cat between 0\[Degree] and 180\[Degree].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"12e0f01a-d7f3-4b73-a31c-e5da8e91fdfa"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`\[Theta]$$ = 0., Typeset`show$$ = 
          True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`\[Theta]$$], 0, 180 Degree}}, Typeset`size$$ = {
          150., {47., 53.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`\[Theta]$32609$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
            "ControllerVariables" :> {
              
              Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$32609$$, 
               0]}, "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Rotate[
              Entity["Species", "Species:FelisCatus"][
              "Image"], $CellContext`\[Theta]$$], 
            "Specifications" :> {{$CellContext`\[Theta]$$, 0, 180 Degree}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{247., {94., 100.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "67e39995-50fe-4585-a291-67371ab617f9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`\[Theta]$$ = 0., Typeset`show$$ = 
             True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
             "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
             Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`\[Theta]$$], 0, 180 Degree}}, 
             Typeset`size$$ = {150., {47., 53.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`\[Theta]$32609$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
              "ControllerVariables" :> {
                
                Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$32609$$, 
                 0]}, "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Rotate[
                Entity["Species", "Species:FelisCatus"][
                "Image"], $CellContext`\[Theta]$$], 
              "Specifications" :> {{$CellContext`\[Theta]$$, 0, 180 Degree}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {95., 102.}}, SingleEvaluation -> True],
             Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"89bf421f-538c-43ba-b4b1-edb12efa68fd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate graphics for a path obtained by turning 0\[Degree], 1\[Degree], 2\
\[Degree], ",
 StyleBox["...",
  FontColor->GrayLevel[0.6]],
 " , 180\[Degree].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"0e036e1d-6ce9-444f-a7e2-983758cac396"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        LineBox[NCache[{{0, 0}, {1, 0}, {1 + Cos[Degree], Sin[Degree]}, {
           1 + Cos[Degree] + Cos[3 Degree], Sin[Degree] + Sin[3 Degree]}, {
           1 + Cos[Degree] + Cos[3 Degree] + Cos[6 Degree], Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree]}, {
           1 + Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree], 
            Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree]}, {
           1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + 
            Cos[10 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
            Sin[10 Degree]}, {
           1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
            Sin[10 Degree] + Sin[21 Degree]}, {
           1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + 
            Cos[28 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
            Sin[10 Degree] + Sin[21 Degree] + Sin[28 Degree]}, {
           1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + Cos[21 Degree] + 
            Cos[28 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree], 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Cos[35 Degree] + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
            Sin[10 Degree] + Sin[21 Degree] + Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] + Sin[24 Degree] + Sin[35 Degree],
             2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            Sin[35 Degree], 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
            Sin[24 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           1 + 2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
            Sin[24 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           Rational[1, 2] + 
            2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
            Sin[24 Degree] + Sin[35 Degree], 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree]}, {
           Rational[1, 2] + 
            2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] + Cos[28 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[28 Degree] + Sin[44 Degree]}, {
           Rational[1, 2] + 
            2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
           Rational[1, 2] + 
            2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[10 Degree] + Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[44 Degree] - Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            Sin[35 Degree], 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[10 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
            Sin[44 Degree]}, {
           Rational[1, 2] + 
            2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree], 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
           Rational[1, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree], 
            Rational[-1, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
           Rational[1, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree] - 
            Sin[39 Degree], Rational[-1, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] - Cos[39 Degree] + 
            Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
            Sin[44 Degree]}, {
           Rational[1, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] + 
            Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
            Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
            Sin[44 Degree]}, {
           Rational[1, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] - 
            Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] - 
            Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 
            Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree],
             Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] - 
            Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + Cos[Degree] - 
            Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
            Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
            2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            Sin[35 Degree] - Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - 
            Sin[39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - 
            Sin[39 Degree] + Sin[44 Degree], Rational[-3, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
            Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - 
            Sin[39 Degree] + Sin[44 Degree], Rational[-3, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree],
             Rational[-3, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
           1 + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree],
             Rational[-3, 2] + 
            2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree],
             Rational[-3, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + 
            Sin[44 Degree], Rational[-3, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - 
            Sin[39 Degree] + Sin[44 Degree], Rational[-3, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
            Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + 
            Sin[44 Degree], Rational[-3, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree],
             Rational[-3, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] - Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
            Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
            Sin[28 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[39 Degree] - 
            2 Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 2 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - 
            Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
            Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 
            2 Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[33 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[-1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 2 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - 
            Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
            Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 2 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - 
            Sin[39 Degree] + Sin[42 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
            Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 2 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - 
            Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
            Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + Cos[28 Degree] - 
            Cos[33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 
            2 Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + Sin[28 Degree] - 
            Sin[33 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
            28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
            Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
            33 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
            Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
            33 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[28 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] + 
            Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
            Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
            Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[42 Degree], Rational[-5, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree],
             Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
            Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[42 Degree] + 
            Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + Cos[21 Degree] - 
            Cos[24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[
            33 Degree] + Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - 
            Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] - 
            Sin[33 Degree] + Sin[42 Degree] + Sin[44 Degree], -3 + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
            Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[24 Degree] - 
            2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 
            Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + 
            Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
            Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[24 Degree] - 
            2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + Sin[42 Degree] + 
            Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + Cos[42 Degree] + 
            Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[24 Degree] - 
            2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + Sin[42 Degree] + 
            Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + Cos[42 Degree] + 
            Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
            Sin[17 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[24 Degree] - 
            2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
            Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + 
            Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
            Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + Sin[42 Degree] + 
            Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
            Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
            2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[42 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[42 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[42 Degree] + Cos[44 Degree] + 
            Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[42 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[42 Degree] + Cos[44 Degree] + 
            Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] + 2 Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
           Rational[5, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[44 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree], Rational[-7, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + 
            2 Sin[39 Degree] + Sin[44 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[35 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - 
            2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
            35 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
            Sin[44 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 2 
            Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
            Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 2 
            Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - 
            Sin[9 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
            Sin[39 Degree], Rational[-7, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - Sin[9 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
            33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
            Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            12 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 
            2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
            12 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 
            2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
            33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
            Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree] + Sin[44 Degree]}, {
           2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
            Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
            Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
            Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
            Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
            Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
            Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
            Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
            Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
            Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
            Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
            Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
            Sin[24 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
            Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
            Sin[24 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
            Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + Cos[33 Degree] + 
            Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
            Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
            Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
            Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
            2 Cos[33 Degree] - 2 Cos[39 Degree] + Cos[42 Degree] - Sin[
            6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[
            24 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            2 Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
            2 Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
            6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[
            24 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
            2 Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
            6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[
            24 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - 
            Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
            Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
            Sin[27 Degree] - Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] + Sin[27 Degree] - Sin[33 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           3 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] + Sin[27 Degree] - Sin[33 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] - Sin[24 Degree] + Sin[27 Degree] - Sin[33 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + Sin[27 Degree] - 
            Sin[33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + Sin[27 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
            Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
            Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] + 
            Cos[39 Degree] - Sin[Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 
            2 Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] + 
            Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] + 
            Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] + 
            2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
            Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] + Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
            Sin[12 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 3^Rational[1, 2] - 
            2^Rational[-1, 2] (-1 + 
             3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
            28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
            28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] - 
            Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[42 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] + 
            Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
            2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree]}, {
           Rational[7, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - 
            Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - 
            Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[3, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[27 Degree] - 
            Sin[35 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
            28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
            44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
            Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[17 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
            Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[17 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
            Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[17 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + 
            Sin[17 Degree] + Sin[27 Degree] - Sin[35 Degree], -4 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[17 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[
            35 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[
            35 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + Sin[6 Degree] + 
            Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
            28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
            Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] - 
            Sin[44 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] - 
            Sin[44 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[
            3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] - 
            Sin[44 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
            Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[35 Degree] - 
            Sin[44 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] - 
            Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 2 
            Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[
            44 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
            Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] - Cos[39 Degree] + 
            2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
            Sin[9 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 2 
            Sin[44 Degree]}, {
           Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree],
             Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - Cos[21 Degree] + Cos[27 Degree] - Cos[44 Degree] - 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
            Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
            Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
            Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] - Sin[
            44 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - Cos[
            44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + 
            Sin[17 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
            28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
            Rational[1, 2] 
             3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], 
            Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - Sin[Degree] + 
            2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - Sin[
            24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], -5 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
              3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - Sin[Degree] + 
            2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - Sin[
            24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
            Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], -5 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - Sin[Degree] + 
            2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - Sin[
            24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
            Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
            Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
            Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], -5 + 
            2^Rational[-1, 2] + 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
            Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
            2 Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
            35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
            6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree], -5 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
            Sin[35 Degree] - 2 Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] - Cos[35 Degree] + 
            2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
            2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
            Sin[17 Degree] + Sin[21 Degree], -5 + 2^Rational[-1, 2] + 
            2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2^Rational[-1, 2] + 
            2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            Sin[21 Degree], -5 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
            3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            Sin[21 Degree], -5 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            Sin[21 Degree], -5 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
            Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
              3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
              2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - 2 Cos[21 Degree] + 
            Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - 2 Cos[21 Degree] + 
            Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
            2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - 2 
            Cos[10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
            Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + 
            Sin[17 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - Sin[3 Degree] - 2 Sin[6 Degree] + 2 Sin[9 Degree] + 
            2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            Cos[3 Degree] + 2 Cos[6 Degree] + 2 Cos[9 Degree] - 2 
            Cos[10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
            Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + 
            Sin[17 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
            Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] + 
            Sin[Degree] - 2 Sin[6 Degree] + 2 Sin[9 Degree] + 
            2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
            2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
            3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
            2 Cos[6 Degree] + 2 Cos[9 Degree] - 2 Cos[10 Degree] + 
            2 Cos[12 Degree] + Cos[17 Degree] - 2 Cos[21 Degree] + 
            Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
            2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
            Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] - 2 
            Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + 2 Sin[21 Degree] - Sin[
            28 Degree], -5 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
            2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] - 2 
            Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + 2 Sin[21 Degree] - Sin[
            28 Degree], -6 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
            2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
           3 + 2 2^Rational[1, 2] - 2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
            Rational[1, 2] (1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
            Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 Cos[27 Degree] - 
            Cos[28 Degree] - 2 Cos[33 Degree] + 2 Cos[44 Degree] - 2 
            Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[10 Degree] + 
            2 Sin[12 Degree] + Sin[17 Degree] + 2 Sin[21 Degree] - Sin[
            28 Degree], -5 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
            2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
            2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
            Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
            2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
              Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
            Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
            2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
            Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
            Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - 
            Sin[28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}}, {{0, 0}, {
           1, 0}, {1.9998476951563913`, 0.01745240643728351}, {
           2.998477229910965, 0.06978836268022734}, {3.9929991252792387`, 
           0.1743168259478808}, {4.977806878291446, 0.3479650036148112}, {
           5.9437327045805155`, 0.6067840487173319}, {6.877313131077717, 
           0.9651519982626322}, {7.760260723936643, 1.434623561048523}, {
           8.56927771831159, 2.022408813340996}, {9.276384499498139, 
           2.7295155945275438`}, {9.849960935849184, 3.5486676388165352`}, {
           10.256697578924985`, 4.462213096459136}, {10.464609269742745`, 
           5.440360697192942}, {10.44715686330546, 6.440208392349334}, {
           10.188337818202939`, 7.406134218638401}, {9.688337818202939, 
           8.27215962242284}, {8.968998017864289, 8.966817992881836}, {
           8.07799149367592, 9.420808492621385}, {7.090303153080782, 
           9.577242957661614}, {6.105495400068575, 9.403594779994684}, {
           5.239469996284137, 8.903594779994684}, {4.610149605234299, 
           8.126448818537714}, {4.317777900511562, 7.170144062574678}, {
           4.4223063637792155`, 6.175622167206405}, {4.9223063637792155`, 
           5.3095967634219665`}, {5.741458408068207, 4.7360203270709205`}, {
           6.729146748663346, 4.579585862030689}, {7.680203264958499, 
           4.888602856405637}, {8.374861635417496, 5.607942656744288}, {
           8.633680680520017, 6.5738684830333565`}, {8.374861635417496, 
           7.539794309322423}, {7.655521835078845, 8.23445267978142}, {
           6.67737423434504, 8.44236437059918}, {5.743793807847838, 
           8.083996421053879}, {5.170217371496792, 7.264844376764888}, {
           5.170217371496792, 6.26484437676489}, {5.758002623789264, 
           5.455827382389941}, {6.7143073797523, 5.163455677667205}, {
           7.647887806249502, 5.521823627212505}, {8.147887806249502, 
           6.387849030996943}, {7.974239628582572, 7.372656784009151}, {
           7.1970936671256, 8.00197717505899}, {6.198464132371026, 
           7.949641218816045}, {5.503805761912028, 7.230301418477394}, {
           5.503805761912028, 6.230301418477394}, {6.210912543098576, 
           5.523194637290846}, {7.210760238254968, 5.54064704372813}, {
           7.8798908446138265`, 6.283791869205524}, {7.775362381346174, 
           7.278313764573797}, {6.956210337057182, 7.851890200924844}, {
           5.990284510768111, 7.593071155822324}, {5.583547867692313, 
           6.679525698179722}, {6.053019430478202, 5.796578105320795}, {
           7.0407077710733414`, 5.640143640280565}, {7.747814552259888, 
           6.347250421467111}, {7.5741663745929575`, 7.332058174479319}, {
           6.660620916950356, 7.73879481755512}, {5.821950349004933, 
           7.194155782540093}, {5.839402755442215, 6.1943080873837015`}, {
           6.705428159226656, 5.6943080873837015`}, {7.571453563011094, 
           6.1943080873837015`}, {7.554001156573809, 7.194155782540093}, {
           6.662994632385443, 7.648146282279639}, {5.853977638010496, 
           7.060361029987167}, {6.0276258156774265`, 6.075553276974959}, {
           6.9935516419664925`, 5.816734231872437}, {7.622872033016329, 
           6.593880193329408}, {7.153400470230439, 7.476827786188336}, {
           6.158878574862166, 7.372299322920682}, {5.9000595297596465`, 
           6.4063734966316135`}, {6.7192115740486384`, 5.832797060280567}, {
           7.528228568423585, 6.420582312573041}, {7.219211574048638, 
           7.371638828868194}, {6.219363878892247, 7.35418642243091}, {
           5.960544833789726, 6.388260596141842}, {6.826570237574165, 
           5.888260596141842}, {7.521228608033163, 6.6076003964804935`}, {
           6.976589573018136, 7.446270964425919}, {6.043009146520934, 
           7.087903014880618}, {6.216657324187865, 6.103095261868409}, {
           7.216657324187865, 6.103095261868409}, {7.373091789228095, 
           7.090783602463548}, {6.416787033265059, 7.383155307186284}, {
           6.010050390189258, 6.469609849543684}, {6.876075793973696, 
           5.9696098495436845`}, {7.449652230324742, 6.7887618938326755`}, {
           6.672506268867771, 7.418082284882513}, {6.003375662508913, 
           6.674937459405119}, {6.722715462847564, 5.980279088946122}, {
           7.4298222440341135`, 6.687385870132669}, {6.722715462847564, 
           7.394492651319216}, {6.0280570923885675`, 6.675152850980565}, {
           6.771201917865961, 6.006022244621707}, {7.400522308915798, 
           6.783168206078678}, {6.581370264626806, 7.356744642429724}, {
           6.081370264626806, 6.490719238645285}, {6.9949157222694085`, 
           6.083982595569484}, {7.287287426992145, 7.04028735153252}, {
           6.299599086397007, 7.196721816572751}, {6.299599086397007, 
           6.196721816572752}, {7.284406839409216, 6.370369994239681}, {
           6.926038889863916, 7.303950420736883}, {6.0873683219184915`, 
           6.7593113857218565`}, {6.8067081222571435`, 6.064653015262858}, {
           7.3067081222571435`, 6.9306784190472985`}, {6.340782295968074, 
           7.1894974641498175`}, {6.358234702405357, 6.1896497689934264`}, {
           7.309291218700511, 6.498666763368375}, {6.721505966408039, 
           7.307683757743321}, {6.147929530056993, 6.48853171345433}, {
           7.113855356346061, 6.229712668351809}, {7.009326893078407, 
           7.224234563720081}, {6.1263793002194795`, 6.754763000934191}, {
           6.903525261676451, 6.125442609884354}, {7.162344306778973, 
           7.091368436173422}, {6.177536553766766, 6.917720258506492}, {
           6.765321806059239, 6.108703264131545}, {7.219312305798784, 
           6.999709788319912}, {6.219464610642394, 6.982257381882629}, {
           6.719464610642394, 6.11623197809819}, {7.219464610642394, 
           6.982257381882629}, {6.219616915486002, 6.964804975445345}, {
           6.764255950501029, 6.126134407499922}, {7.1709925935768295`, 
           7.0396798651425225`}, {6.186184840564621, 6.8660316874755924`}, {
           6.893291621751168, 6.158924906289043}, {7.0497260867914, 
           7.146613246884181}, {6.166778493932472, 6.677141684098291}, {
           7.080323951575073, 6.270405041022492}, {6.821504906472553, 
           7.23633086731156}, {6.247928470121507, 6.417178823022568}, {
           7.24245036548978, 6.521707286290222}, {6.499305540012386, 
           7.190837892649079}, {6.516757946449669, 6.190990197492688}, {
           7.223864727636217, 6.898096978679236}, {6.223864727636217, 
           6.898096978679236}, {6.943204527974868, 6.203438608220239}, {
           6.890868571731924, 7.202068142974812}, {6.2615481806820865`, 
           6.424922181517841}, {7.246355933694294, 6.598570359184771}, {
           6.380330529909856, 7.098570359184771}, {6.738698479455157, 
           6.16498993268757}, {7.031070184177893, 7.121294688650606}, {
           6.222053189802945, 6.533509436358133}, {7.2220531898029465`, 
           6.533509436358133}, {6.402901145513955, 7.107085872709179}, {
           6.761269095059255, 6.173505446211977}, {6.969180785877014, 
           7.151653046945783}, {6.274522415418016, 6.432313246607132}, {
           7.240448241707085, 6.691132291709652}, {6.274522415418016, 
           6.949951336812173}, {6.993862215756668, 6.255292966353176}, {
           6.684845221381721, 7.20634948264833}, {6.52841075634149, 
           6.218661142053191}, {7.101987192692537, 7.037813186342183}, {
           6.235961788908096, 6.537813186342183}, {7.23048368427637, 
           6.642341649609836}, {6.274178928313335, 6.934713354332573}, {
           7.0513248897703065`, 6.305392963282736}, {6.5513248897703065`, 
           7.171418367067175}, {6.724973067437236, 6.186610614054967}, {
           6.881407532477467, 7.174298954650105}, {6.427417032737921, 
           6.283292430461737}, {7.122075403196917, 7.002632230800389}, {
           6.256049999412478, 6.502632230800389}, {7.221975825701546, 
           6.76145127590291}, {6.222128130545154, 6.743998869465627}, {
           7.200275731278959, 6.536087178647867}, {6.28673027363636, 
           6.942823821723667}, {7.105882317925353, 6.369247385372621}, {
           6.398775536738803, 7.076354166559167}, {6.986560789031277, 
           6.26733717218422}, {6.517089226245386, 7.150284765043146}, {
           6.875457175790687, 6.216704338545945}, {6.616638130688165, 
           7.182630164835013}, {6.790286308355095, 6.197822411822806}, {
           6.685757845087442, 7.192344307191078}, {6.738093801330387, 
           6.193714772436504}, {6.720641394893104, 7.193562467592897}, {
           6.720641394893104, 6.193562467592897}, {6.720641394893104, 
           7.193562467592897}}]]]], "ExerciseOutput",ExpressionUUID->
       "9b9ee40d-a94e-4100-bb2f-e7693ebc8783"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          LineBox[
           NCache[{{0, 0}, {1, 0}, {1 + Cos[Degree], 
              Sin[Degree]}, {
             1 + Cos[Degree] + Cos[3 Degree], Sin[Degree] + Sin[3 Degree]}, {
             1 + Cos[Degree] + Cos[3 Degree] + Cos[6 Degree], Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree]}, {
             1 + Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree],
               Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
              Sin[10 Degree]}, {
             1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + 
              Cos[10 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[10 Degree]}, {
             1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree]}, {
             1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + 
              Cos[28 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
              Sin[28 Degree]}, {
             1 + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + Cos[21 Degree] + 
              Cos[28 Degree], (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] + Sin[35 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[35 Degree] + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
              Sin[10 Degree] + Sin[21 Degree] + Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] + Sin[24 Degree] + 
              Sin[35 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
              Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + Sin[35 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + Sin[21 Degree] + 
              Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + Sin[35 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree]}, {
             1 + 2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + Sin[35 Degree], 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] - Sin[Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + Sin[35 Degree], 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] + Cos[28 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[12 Degree] + Sin[24 Degree] + Sin[35 Degree], 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[10 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              Sin[35 Degree], 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[10 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[44 Degree]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[10 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + Sin[35 Degree], 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + 
              Sin[10 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] + Sin[44 Degree]}, {
             Rational[1, 2] + 
              2^Rational[-1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              Sin[35 Degree], 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[44 Degree]}, {
             Rational[1, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              Sin[35 Degree], Rational[-1, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] + 
              Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[44 Degree]}, {
             Rational[1, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] + Cos[24 Degree] + Cos[35 Degree] - 
              Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + Sin[6 Degree] + 
              Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] + Sin[44 Degree]}, {
             Rational[1, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], 
              Rational[-1, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] + Sin[44 Degree]}, {
             Rational[1, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], 
              Rational[-1, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] - Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] + Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], 
              Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] - Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] + Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] - Cos[9 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
              Sin[35 Degree] - Sin[39 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] - Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] + Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[9 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - 
              Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], 
              Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Cos[Degree] - Cos[6 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] + Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree], 
              Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[21 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[21 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[21 Degree] - 
              Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[24 Degree] + Sin[35 Degree] - Sin[
              39 Degree] + Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + Sin[35 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-1, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-3, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] + Cos[35 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-3, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[35 Degree] + 2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] - 
              Cos[27 Degree] + Cos[28 Degree] + Cos[35 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[24 Degree] - Sin[39 Degree] + 
              Sin[44 Degree], Rational[-3, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              2 Sin[44 Degree]}, {
             1 + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[
              39 Degree] + Sin[44 Degree], Rational[-3, 2] + 
              2^Rational[-1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[
              39 Degree] + Sin[44 Degree], Rational[-3, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[12 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + Sin[3 Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - 2 Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] - 
              Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-3, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-3, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[3 Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[44 Degree], 
              Rational[-3, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree], Rational[-3, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] - Sin[35 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[24 Degree] - Sin[39 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              6 Degree] + Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[42 Degree] + 
              2 Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] - Sin[39 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[42 Degree] + 
              2 Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[42 Degree] + 
              2 Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - Cos[39 Degree] + Cos[42 Degree] + 
              2 Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] - Sin[39 Degree] + 
              Sin[42 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] + Sin[28 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[27 Degree] + Cos[28 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] + Sin[28 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[-1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
              Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[
              39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[28 Degree] - Sin[39 Degree] + 
              Sin[42 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
              Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[
              39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - 2 Sin[10 Degree] + Sin[12 Degree] - Sin[
              17 Degree] + Sin[28 Degree] - Sin[39 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[10 Degree] + 
              Cos[12 Degree] - Cos[17 Degree] - Cos[28 Degree] - Cos[
              39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - 2 Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[28 Degree] - Sin[
              39 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              2 Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + 
              Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[28 Degree] - Sin[39 Degree] + 
              Sin[42 Degree], Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] - Cos[39 Degree] + Cos[42 Degree] + 2 Sin[Degree] + 
              Sin[6 Degree] - Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[28 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              28 Degree] + Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[6 Degree] + Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] + Sin[6 Degree] - Sin[9 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - Cos[39 Degree] - 2 
              Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[42 Degree], Rational[-5, 2] + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + 2 Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], 
              Rational[-5, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree], -3 + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] - 
              Sin[17 Degree] + Sin[21 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[42 Degree] + 
              Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[21 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] + 
              Cos[21 Degree] - Cos[24 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] + Cos[35 Degree] - Cos[
              39 Degree] - 2 Cos[44 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + 
              Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[21 Degree] + Sin[24 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] - Sin[35 Degree] + 
              Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[
              24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[17 Degree] - 
              Sin[33 Degree] + Sin[42 Degree] + Sin[44 Degree], -3 + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[3, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[
              24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + 
              Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
              Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[
              24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[33 Degree] + 
              Sin[42 Degree] + Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[12 Degree] - Cos[17 Degree] + Cos[33 Degree] + 
              Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] + Cos[17 Degree] - Cos[
              24 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              33 Degree] + Sin[42 Degree] + Sin[44 Degree], -3 + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              33 Degree] + Sin[42 Degree] + Sin[44 Degree], -3 + 
              2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] + 
              Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[42 Degree] + 
              Sin[44 Degree], -3 + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[42 Degree] + Sin[44 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[42 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[42 Degree] + 
              Sin[44 Degree], Rational[-7, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[42 Degree] + 
              Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] - Sin[35 Degree] + Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[42 Degree] + 
              Sin[44 Degree], Rational[-7, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[42 Degree] + 
              Cos[44 Degree] + Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + 
              Sin[24 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] - Sin[35 Degree] + 2 Sin[39 Degree] + 
              2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - 2 Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[44 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] + 2 Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[44 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
             Rational[5, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[44 Degree], 
              Rational[-7, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[44 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[44 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree], Rational[-7, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] + Sin[44 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] + Cos[42 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[
              17 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
              Sin[44 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] + 
              Cos[35 Degree] - 2 Cos[39 Degree] + Cos[42 Degree] - Cos[
              44 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[
              17 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
              Sin[39 Degree], Rational[-7, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] - Sin[
              35 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
              Sin[44 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - Cos[24 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[9 Degree] + Sin[12 Degree] - Sin[17 Degree] - Sin[
              24 Degree] - Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree], 
              Rational[-7, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + Sin[24 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[17 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[17 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] - Sin[9 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] - 
              Sin[9 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              12 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 
              2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-7, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
              Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] - Cos[
              12 Degree] - 2 Cos[27 Degree] + Cos[28 Degree] - Cos[33 Degree] - 
              2 Cos[39 Degree] + Cos[42 Degree] - Cos[44 Degree] - Sin[
              Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - Sin[
              33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree] + 
              Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree] + Sin[44 Degree]}, {
             2 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Sin[Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[10 Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] + Sin[28 Degree] - 2 Sin[33 Degree] + 
              2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Degree] + 
              Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] + 
              Cos[28 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[
              21 Degree] - Sin[24 Degree] - Sin[33 Degree] + Sin[35 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 4] (-1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - 2 Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - 2 Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[35 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - 2 Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
              Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - 2 Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] - Cos[24 Degree] + 
              Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] + Sin[28 Degree] - 2 
              Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] + Cos[28 Degree] - 2 Cos[33 Degree] - 2 
              Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] - Sin[
              33 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] + 
              Sin[28 Degree] - 2 Sin[33 Degree] + 2 Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] - 2 Cos[33 Degree] - 2 Cos[39 Degree] + 
              Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 2 
              Sin[33 Degree] + 2 Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
              Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] + Cos[10 Degree] - Cos[12 Degree] - 2 
              Cos[27 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
              Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + Sin[12 Degree] - 
              Sin[21 Degree] - Sin[24 Degree] - Sin[33 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[10 Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
              Sin[24 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 4] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
              Sin[24 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[33 Degree] + Cos[39 Degree] + Sin[Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
              Cos[Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] - 
              Sin[24 Degree] + Sin[27 Degree] - Sin[33 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + 
              Sin[Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[5, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
              Sin[27 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             3 - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
              Sin[27 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
              Sin[27 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
              Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
              Sin[27 Degree] - Sin[33 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[33 Degree] + Cos[39 Degree] - 
              Sin[Degree] + Sin[12 Degree] + 2 Sin[27 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
              Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] - Sin[24 Degree] + 
              Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] - Cos[
              24 Degree] + Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 2 Cos[33 Degree] - 
              Cos[39 Degree] + Cos[42 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] + Sin[12 Degree] + 
              2 Sin[27 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[7, 2] - 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
              2 Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
              2 Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
              2 Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] - 2 Cos[27 Degree] - 
              Cos[28 Degree] - 2 Cos[33 Degree] - Cos[39 Degree] + 
              Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 3^Rational[1, 2] - 
              2^Rational[-1, 2] (-1 + 
               3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] + 
              Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] + Cos[39 Degree] - Sin[Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] - Cos[10 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[42 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] - Sin[
              35 Degree] + Sin[39 Degree], Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] - 
              Sin[10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[42 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
              Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[42 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + Cos[6 Degree] + 
              2 Cos[9 Degree] + Cos[12 Degree] + Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] + Cos[39 Degree] - Sin[Degree] + 
              Sin[6 Degree] - Sin[10 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree]}, {
             Rational[7, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
              Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] + 
              Cos[39 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
              Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] + 
              Cos[39 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Sin[Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
              Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] + 
              Cos[39 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[
              21 Degree] + Sin[27 Degree] - Sin[35 Degree] + Sin[39 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[6 Degree] + 2 Cos[9 Degree] + Cos[12 Degree] + 
              Cos[21 Degree] + Cos[27 Degree] - Cos[35 Degree] + 
              Cos[39 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] - Sin[
              35 Degree] + Sin[39 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] - Cos[
              35 Degree] + Cos[39 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[
              10 Degree] + Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - 
              Sin[28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[10 Degree] - Cos[12 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] - Sin[21 Degree] + Sin[27 Degree] - Sin[
              35 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] - Sin[10 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[39 Degree] - Sin[
              44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[3, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] - Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[21 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[27 Degree] - 
              Sin[35 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2] + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[17 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[5, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[17 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              39 Degree] + Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[
              6 Degree] + 2 Sin[9 Degree] + Sin[12 Degree] + Sin[17 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[17 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] + Sin[27 Degree] - Sin[
              35 Degree], -4 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[17 Degree] + Cos[27 Degree] - Cos[
              35 Degree] - Sin[Degree] + Sin[6 Degree] + Sin[12 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - Sin[
              44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
              Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
              Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 4] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[35 Degree] - Sin[44 Degree], -4 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[35 Degree] - Cos[44 Degree] - Sin[Degree] + 
              Sin[6 Degree] + Sin[12 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[44 Degree], -4 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
              2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + Sin[6 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
              2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] + Cos[24 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] - Cos[39 Degree] + 2 Cos[44 Degree] + Sin[Degree] - 
              Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] + Sin[39 Degree] - 
              2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] - Cos[39 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              Sin[9 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] + Sin[39 Degree] - 2 Sin[44 Degree]}, {
             Rational[7, 2] + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree] + 
              Sin[27 Degree] - Sin[44 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + Cos[9 Degree] - Cos[10 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree] + Sin[27 Degree] - Sin[44 Degree], 
              Rational[-9, 2] + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[27 Degree] - Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[12 Degree] + Sin[17 Degree] - Sin[24 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree] - Sin[44 Degree], Rational[-9, 2] + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              Cos[44 Degree] - Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + 
              Sin[17 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 2 2^Rational[1, 2] + 
              Rational[1, 2] 
               3^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree], Rational[-9, 2] + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
              Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree], -5 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + (Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + (Rational[3, 2] 2^Rational[-1, 2]) (1 + 
                3^Rational[1, 2]) + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
              Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[
              Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree], -5 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + Sin[17 Degree] - 
              Sin[24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[12 Degree] - Cos[17 Degree] + 
              Cos[24 Degree] - 2 Cos[27 Degree] - Cos[28 Degree] - 2 
              Cos[33 Degree] - Cos[35 Degree] + 2 Cos[44 Degree] + 
              Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 2 Sin[9 Degree] + 
              Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              Sin[21 Degree], -5 + 2^Rational[-1, 2] + 2^Rational[1, 2] + 
              3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[12 Degree] + 
              Sin[17 Degree] - Sin[24 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] + Sin[35 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] + Cos[24 Degree] - 
              2 Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - 
              Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], -5 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] - Sin[
              24 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] + Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] - Cos[
              35 Degree] + 2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - 
              Sin[6 Degree] + 2 Sin[9 Degree] + Sin[10 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + Sin[21 Degree], -5 + 
              2^Rational[-1, 2] + 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] + 
              Sin[35 Degree] - 2 Sin[44 Degree]}, {
             3 + 2^Rational[-1, 2] + 
              2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + Sin[21 Degree], -5 + 2^Rational[-1, 2] + 
              2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + Sin[21 Degree], -5 + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + Sin[21 Degree], -5 + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] - 
              2 Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + Sin[21 Degree] - Sin[28 Degree], -5 + 
              2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - Cos[21 Degree] + 
              Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[17 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 
               2^Rational[1, 2] + (Rational[-3, 2] 2^Rational[-1, 2]) (-1 + 
                3^Rational[1, 2]) + 2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + 2 Sin[21 Degree] - Sin[28 Degree], -5 + 
              2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + (Rational[3, 2] 
                2^Rational[-1, 2]) (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
              Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 
              2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + 2 Sin[21 Degree] - Sin[28 Degree], -5 + 
              2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - Cos[
              10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
              Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 
              2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - Sin[6 Degree] + 
              2 Sin[9 Degree] + 2 Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + 2 Sin[21 Degree] - Sin[28 Degree], -5 + 
              2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + Cos[6 Degree] + 2 Cos[9 Degree] - 2 
              Cos[10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
              Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 
              2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - Sin[3 Degree] - 2 
              Sin[6 Degree] + 2 Sin[9 Degree] + 2 Sin[10 Degree] + 
              2 Sin[12 Degree] + Sin[17 Degree] + 2 Sin[21 Degree] - Sin[
              28 Degree], -5 + 2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              Cos[3 Degree] + 2 Cos[6 Degree] + 2 Cos[9 Degree] - 2 
              Cos[10 Degree] + 2 Cos[12 Degree] + Cos[17 Degree] - 2 
              Cos[21 Degree] + Cos[28 Degree] - 2 Sin[Degree] + 
              2 Sin[6 Degree] + Sin[17 Degree] + 2 Sin[27 Degree] - Sin[
              28 Degree] - 2 Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] + Sin[Degree] - 2 Sin[6 Degree] + 
              2 Sin[9 Degree] + 2 Sin[10 Degree] + 2 Sin[12 Degree] + 
              Sin[17 Degree] + 2 Sin[21 Degree] - Sin[28 Degree], -5 + 
              2 2^Rational[1, 2] + 3^Rational[1, 2] + 
              2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) - Cos[Degree] + 
              2 Cos[6 Degree] + 2 Cos[9 Degree] - 2 Cos[10 Degree] + 
              2 Cos[12 Degree] + Cos[17 Degree] - 2 Cos[21 Degree] + 
              Cos[28 Degree] - 2 Sin[Degree] + 2 Sin[6 Degree] + 
              Sin[17 Degree] + 2 Sin[27 Degree] - Sin[28 Degree] - 2 
              Sin[33 Degree] - 2 Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] - 2 Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
              2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
              Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] - 2 Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              2 Sin[21 Degree] - Sin[28 Degree], -6 + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
              2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
              Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}, {
             3 + 2 2^Rational[1, 2] - 
              2^Rational[1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[-1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
              Rational[1, 2] (1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 
              Cos[Degree] + 2 Cos[6 Degree] - Cos[17 Degree] - 2 
              Cos[27 Degree] - Cos[28 Degree] - 2 Cos[33 Degree] + 
              2 Cos[44 Degree] - 2 Sin[6 Degree] + 2 Sin[9 Degree] + 
              2 Sin[10 Degree] + 2 Sin[12 Degree] + Sin[17 Degree] + 
              2 Sin[21 Degree] - Sin[28 Degree], -5 + 2 2^Rational[1, 2] + 
              3^Rational[1, 2] + 2^Rational[-1, 2] (-1 + 3^Rational[1, 2]) + 
              2^Rational[1, 2] (1 + 3^Rational[1, 2]) + 
              Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[6 Degree] + 
              2 Cos[9 Degree] - 2 Cos[10 Degree] + 2 Cos[12 Degree] + 
              Cos[17 Degree] - 2 Cos[21 Degree] + Cos[28 Degree] - 2 
              Sin[Degree] + 2 Sin[6 Degree] + Sin[17 Degree] + 
              2 Sin[27 Degree] - Sin[28 Degree] - 2 Sin[33 Degree] - 2 
              Sin[44 Degree]}}, {{0, 0}, {1, 0}, {1.9998476951563913`, 
             0.01745240643728351}, {2.998477229910965, 0.06978836268022734}, {
             3.9929991252792387`, 0.1743168259478808}, {4.977806878291446, 
             0.3479650036148112}, {5.9437327045805155`, 0.6067840487173319}, {
             6.877313131077717, 0.9651519982626322}, {7.760260723936643, 
             1.434623561048523}, {8.56927771831159, 2.022408813340996}, {
             9.276384499498139, 2.7295155945275438`}, {9.849960935849184, 
             3.5486676388165352`}, {10.256697578924985`, 4.462213096459136}, {
             10.464609269742745`, 5.440360697192942}, {10.44715686330546, 
             6.440208392349334}, {10.188337818202939`, 7.406134218638401}, {
             9.688337818202939, 8.27215962242284}, {8.968998017864289, 
             8.966817992881836}, {8.07799149367592, 9.420808492621385}, {
             7.090303153080782, 9.577242957661614}, {6.105495400068575, 
             9.403594779994684}, {5.239469996284137, 8.903594779994684}, {
             4.610149605234299, 8.126448818537714}, {4.317777900511562, 
             7.170144062574678}, {4.4223063637792155`, 6.175622167206405}, {
             4.9223063637792155`, 5.3095967634219665`}, {5.741458408068207, 
             4.7360203270709205`}, {6.729146748663346, 4.579585862030689}, {
             7.680203264958499, 4.888602856405637}, {8.374861635417496, 
             5.607942656744288}, {8.633680680520017, 6.5738684830333565`}, {
             8.374861635417496, 7.539794309322423}, {7.655521835078845, 
             8.23445267978142}, {6.67737423434504, 8.44236437059918}, {
             5.743793807847838, 8.083996421053879}, {5.170217371496792, 
             7.264844376764888}, {5.170217371496792, 6.26484437676489}, {
             5.758002623789264, 5.455827382389941}, {6.7143073797523, 
             5.163455677667205}, {7.647887806249502, 5.521823627212505}, {
             8.147887806249502, 6.387849030996943}, {7.974239628582572, 
             7.372656784009151}, {7.1970936671256, 8.00197717505899}, {
             6.198464132371026, 7.949641218816045}, {5.503805761912028, 
             7.230301418477394}, {5.503805761912028, 6.230301418477394}, {
             6.210912543098576, 5.523194637290846}, {7.210760238254968, 
             5.54064704372813}, {7.8798908446138265`, 6.283791869205524}, {
             7.775362381346174, 7.278313764573797}, {6.956210337057182, 
             7.851890200924844}, {5.990284510768111, 7.593071155822324}, {
             5.583547867692313, 6.679525698179722}, {6.053019430478202, 
             5.796578105320795}, {7.0407077710733414`, 5.640143640280565}, {
             7.747814552259888, 6.347250421467111}, {7.5741663745929575`, 
             7.332058174479319}, {6.660620916950356, 7.73879481755512}, {
             5.821950349004933, 7.194155782540093}, {5.839402755442215, 
             6.1943080873837015`}, {6.705428159226656, 5.6943080873837015`}, {
             7.571453563011094, 6.1943080873837015`}, {7.554001156573809, 
             7.194155782540093}, {6.662994632385443, 7.648146282279639}, {
             5.853977638010496, 7.060361029987167}, {6.0276258156774265`, 
             6.075553276974959}, {6.9935516419664925`, 5.816734231872437}, {
             7.622872033016329, 6.593880193329408}, {7.153400470230439, 
             7.476827786188336}, {6.158878574862166, 7.372299322920682}, {
             5.9000595297596465`, 6.4063734966316135`}, {6.7192115740486384`, 
             5.832797060280567}, {7.528228568423585, 6.420582312573041}, {
             7.219211574048638, 7.371638828868194}, {6.219363878892247, 
             7.35418642243091}, {5.960544833789726, 6.388260596141842}, {
             6.826570237574165, 5.888260596141842}, {7.521228608033163, 
             6.6076003964804935`}, {6.976589573018136, 7.446270964425919}, {
             6.043009146520934, 7.087903014880618}, {6.216657324187865, 
             6.103095261868409}, {7.216657324187865, 6.103095261868409}, {
             7.373091789228095, 7.090783602463548}, {6.416787033265059, 
             7.383155307186284}, {6.010050390189258, 6.469609849543684}, {
             6.876075793973696, 5.9696098495436845`}, {7.449652230324742, 
             6.7887618938326755`}, {6.672506268867771, 7.418082284882513}, {
             6.003375662508913, 6.674937459405119}, {6.722715462847564, 
             5.980279088946122}, {7.4298222440341135`, 6.687385870132669}, {
             6.722715462847564, 7.394492651319216}, {6.0280570923885675`, 
             6.675152850980565}, {6.771201917865961, 6.006022244621707}, {
             7.400522308915798, 6.783168206078678}, {6.581370264626806, 
             7.356744642429724}, {6.081370264626806, 6.490719238645285}, {
             6.9949157222694085`, 6.083982595569484}, {7.287287426992145, 
             7.04028735153252}, {6.299599086397007, 7.196721816572751}, {
             6.299599086397007, 6.196721816572752}, {7.284406839409216, 
             6.370369994239681}, {6.926038889863916, 7.303950420736883}, {
             6.0873683219184915`, 6.7593113857218565`}, {6.8067081222571435`, 
             6.064653015262858}, {7.3067081222571435`, 6.9306784190472985`}, {
             6.340782295968074, 7.1894974641498175`}, {6.358234702405357, 
             6.1896497689934264`}, {7.309291218700511, 6.498666763368375}, {
             6.721505966408039, 7.307683757743321}, {6.147929530056993, 
             6.48853171345433}, {7.113855356346061, 6.229712668351809}, {
             7.009326893078407, 7.224234563720081}, {6.1263793002194795`, 
             6.754763000934191}, {6.903525261676451, 6.125442609884354}, {
             7.162344306778973, 7.091368436173422}, {6.177536553766766, 
             6.917720258506492}, {6.765321806059239, 6.108703264131545}, {
             7.219312305798784, 6.999709788319912}, {6.219464610642394, 
             6.982257381882629}, {6.719464610642394, 6.11623197809819}, {
             7.219464610642394, 6.982257381882629}, {6.219616915486002, 
             6.964804975445345}, {6.764255950501029, 6.126134407499922}, {
             7.1709925935768295`, 7.0396798651425225`}, {6.186184840564621, 
             6.8660316874755924`}, {6.893291621751168, 6.158924906289043}, {
             7.0497260867914, 7.146613246884181}, {6.166778493932472, 
             6.677141684098291}, {7.080323951575073, 6.270405041022492}, {
             6.821504906472553, 7.23633086731156}, {6.247928470121507, 
             6.417178823022568}, {7.24245036548978, 6.521707286290222}, {
             6.499305540012386, 7.190837892649079}, {6.516757946449669, 
             6.190990197492688}, {7.223864727636217, 6.898096978679236}, {
             6.223864727636217, 6.898096978679236}, {6.943204527974868, 
             6.203438608220239}, {6.890868571731924, 7.202068142974812}, {
             6.2615481806820865`, 6.424922181517841}, {7.246355933694294, 
             6.598570359184771}, {6.380330529909856, 7.098570359184771}, {
             6.738698479455157, 6.16498993268757}, {7.031070184177893, 
             7.121294688650606}, {6.222053189802945, 6.533509436358133}, {
             7.2220531898029465`, 6.533509436358133}, {6.402901145513955, 
             7.107085872709179}, {6.761269095059255, 6.173505446211977}, {
             6.969180785877014, 7.151653046945783}, {6.274522415418016, 
             6.432313246607132}, {7.240448241707085, 6.691132291709652}, {
             6.274522415418016, 6.949951336812173}, {6.993862215756668, 
             6.255292966353176}, {6.684845221381721, 7.20634948264833}, {
             6.52841075634149, 6.218661142053191}, {7.101987192692537, 
             7.037813186342183}, {6.235961788908096, 6.537813186342183}, {
             7.23048368427637, 6.642341649609836}, {6.274178928313335, 
             6.934713354332573}, {7.0513248897703065`, 6.305392963282736}, {
             6.5513248897703065`, 7.171418367067175}, {6.724973067437236, 
             6.186610614054967}, {6.881407532477467, 7.174298954650105}, {
             6.427417032737921, 6.283292430461737}, {7.122075403196917, 
             7.002632230800389}, {6.256049999412478, 6.502632230800389}, {
             7.221975825701546, 6.76145127590291}, {6.222128130545154, 
             6.743998869465627}, {7.200275731278959, 6.536087178647867}, {
             6.28673027363636, 6.942823821723667}, {7.105882317925353, 
             6.369247385372621}, {6.398775536738803, 7.076354166559167}, {
             6.986560789031277, 6.26733717218422}, {6.517089226245386, 
             7.150284765043146}, {6.875457175790687, 6.216704338545945}, {
             6.616638130688165, 7.182630164835013}, {6.790286308355095, 
             6.197822411822806}, {6.685757845087442, 7.192344307191078}, {
             6.738093801330387, 6.193714772436504}, {6.720641394893104, 
             7.193562467592897}, {6.720641394893104, 6.193562467592897}, {
             6.720641394893104, 7.193562467592897}}]]]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"621d1ac9-e862-4dc2-a6dd-f66bad19416e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of the path obtained by turning a constant angle 100 times, \
controlling the angle from 0\[Degree] to 360\[Degree] with a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"afec2295-d783-46f9-96d2-720d071a4431"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`x$$ = 2.412743157956961, 
          Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
          Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
          Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
          Typeset`specs$$ = {{
            Hold[$CellContext`x$$], 0, 360 Degree}}, Typeset`size$$ = {
          240., {117., 123.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`x$37399$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`x$$, $CellContext`x$37399$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            Graphics[
              Line[
               AnglePath[
                Table[$CellContext`x$$, 100]]]], 
            "Specifications" :> {{$CellContext`x$$, 0, 360 Degree}}, 
            "Options" :> {}, "DefaultOptions" :> {}],
           ImageSizeCache->{285., {164., 170.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "30450141-1509-4907-8897-2ee9b4f22353"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`x$$ = 2.412743157956961, 
             Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
             Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
             Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
             Typeset`specs$$ = {{
                Hold[$CellContext`x$$], 0, 360 Degree}}, 
             Typeset`size$$ = {240., {117., 123.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`x$37399$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`x$$, $CellContext`x$37399$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              Graphics[
                Line[
                 AnglePath[
                  Table[$CellContext`x$$, 100]]]], 
              "Specifications" :> {{$CellContext`x$$, 0, 360 Degree}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {291., {165., 172.}}, SingleEvaluation -> 
             True], Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"866839bc-be64-4776-aec5-3693ca08b32c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of the path obtained by successively turning by the digits of \
2^10000 multiplied by 30\[Degree].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "17.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"13d16776-6254-48df-ad28-f6ece1230bce"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        LineBox[NCache[{{0, 0}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}, {
           Rational[1, 2] + Rational[1, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[5, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], -1 + Rational[-1, 2] 3^Rational[1, 2]}, {
           2, -1 - 3^Rational[1, 2]}, {
           2 + Rational[1, 2] 3^Rational[1, 2], Rational[-3, 2] - 3^
            Rational[1, 2]}, {2, -1 - 3^Rational[1, 2]}, {
           2 + Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2] - 3^
            Rational[1, 2]}, {
           2 + Rational[1, 2] 3^Rational[1, 2], Rational[-3, 2] - 3^
            Rational[1, 2]}, {
           2 + Rational[1, 2] 3^Rational[1, 2], Rational[-5, 2] - 3^
            Rational[1, 2]}, {
           Rational[3, 2] + Rational[1, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[1, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], -3 + Rational[-1, 2] 3^Rational[1, 2]}, {
           1, -3 - 3^Rational[1, 2]}, {
           Rational[1, 2], -3 + Rational[-1, 2] 3^Rational[1, 2]}, {
           0, -3 - 3^Rational[1, 2]}, {
           Rational[-1, 2], -3 + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[1, 2], -3 + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[1, 2], -2 + Rational[-1, 2] 3^Rational[1, 2]}, {
           1, -2 - 3^Rational[1, 2]}, {
           Rational[3, 2], -2 + Rational[-1, 2] 3^Rational[1, 2]}, {1, -2}, {
           1 + Rational[-1, 2] 3^Rational[1, 2], Rational[-3, 2]}, {1, -2}, {
           1 + Rational[1, 2] 3^Rational[1, 2], Rational[-3, 2]}, {1, -2}, {
           1, -1}, {0, -1}, {
           Rational[1, 2] 3^Rational[1, 2], Rational[-3, 2]}, {0, -2}, {
           1, -2}, {2, -2}, {
           Rational[3, 2], -2 + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[1, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], -3 + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[3, 2], -4 + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[5, 2], -4 + Rational[-1, 2] 3^Rational[1, 2]}, {2, -4}, {
           2 + Rational[1, 2] 3^Rational[1, 2], Rational[-7, 2]}, {2, -4}, {
           2, -3}, {1, -3}, {
           1 + Rational[-1, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
           1 + Rational[-1, 2] 3^Rational[1, 2], Rational[-5, 2]}, {1, -3}, {
           1 + Rational[-1, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
           Rational[-1, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
           Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-3, 2]}, {-3^Rational[1, 2], -1}, {-3^
             Rational[1, 2], -2}, {
           Rational[1, 2] - 3^Rational[1, 2], -2 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] - 3^Rational[1, 2], -2 + 
            Rational[1, 2] 3^Rational[1, 2]}, {-3^Rational[1, 2], -2 + 
            3^Rational[1, 2]}, {
           Rational[-3, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            3^Rational[1, 2]}, {
           Rational[-3, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            3^Rational[1, 2]}, {
           Rational[-3, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3^Rational[1, 2]}, {
           Rational[-3, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            3^Rational[1, 2]}, {(-2) 3^Rational[1, 2], -5 + 
            3^Rational[1, 2]}, {
           Rational[1, 2] - 2 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] - 2 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] - 2 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[3, 2] 3^Rational[1, 2]}, {-1 + 
            Rational[-3, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            2 3^Rational[1, 2]}, {-2 + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + 2 3^Rational[1, 2]}, {-2 + 
            Rational[-3, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {-2 - 2 3^Rational[1, 2], -4 + 
            2 3^Rational[1, 2]}, {
           Rational[-3, 2] - 2 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-5, 2] - 2 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {-2 - 2 3^Rational[1, 2], -4 + 
            2 3^Rational[1, 2]}, {-2 + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + 2 3^Rational[1, 2]}, {-2 - 3 
            3^Rational[1, 2], -3 + 2 3^Rational[1, 2]}, {-2 + 
            Rational[-7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {-2 + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + 2 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] - 4 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] - 4 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {-1 + 
            Rational[-7, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            2 3^Rational[1, 2]}, {-1 + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + 2 3^Rational[1, 2]}, {
           Rational[-7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            2 3^Rational[1, 2]}, {(-3) 3^Rational[1, 2], -4 + 
            2 3^Rational[1, 2]}, {
           Rational[1, 2] - 3 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[-7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] - 3 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           1 - 3 3^Rational[1, 2], -4 + 2 3^Rational[1, 2]}, {
           Rational[1, 2] - 3 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {(-3) 3^Rational[1, 2], -4 + 
            2 3^Rational[1, 2]}, {
           Rational[-1, 2] - 3 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {-1 - 3 3^Rational[1, 2], -4 + 
            3^Rational[1, 2]}, {-1 + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + 3^Rational[1, 2]}, {-1 - 3 3^Rational[1, 2], -4 + 
            3^Rational[1, 2]}, {-2 - 3 3^Rational[1, 2], -4 + 
            3^Rational[1, 2]}, {-2 - 3 3^Rational[1, 2], -3 + 
            3^Rational[1, 2]}, {-2 + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + 3^Rational[1, 2]}, {-1 + 
            Rational[-7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            3^Rational[1, 2]}, {-1 + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] - 3 3^Rational[1, 2], -6 + 
            Rational[3, 2] 3^Rational[1, 2]}, {(-3) 3^Rational[1, 2], -6 + 
            2 3^Rational[1, 2]}, {
           Rational[-1, 2] - 3 3^Rational[1, 2], -6 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] - 3 3^Rational[1, 2], -5 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[-7, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            2 3^Rational[1, 2]}, {
           1 + Rational[-7, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            2 3^Rational[1, 2]}, {
           2 + Rational[-7, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            2 3^Rational[1, 2]}, {
           2 + Rational[-7, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           3 + Rational[-7, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            2 3^Rational[1, 2]}, {
           2 + Rational[-7, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            2 3^Rational[1, 2]}, {
           2 - 3 3^Rational[1, 2], -6 + 2 3^Rational[1, 2]}, {
           Rational[5, 2] - 3 3^Rational[1, 2], -6 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           3 + Rational[-7, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            2 3^Rational[1, 2]}, {
           3 - 4 3^Rational[1, 2], -7 + 2 3^Rational[1, 2]}, {
           Rational[5, 2] - 4 3^Rational[1, 2], -7 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-15, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           3 + Rational[-7, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            2 3^Rational[1, 2]}, {
           3 - 4 3^Rational[1, 2], -6 + 2 3^Rational[1, 2]}, {
           Rational[5, 2] - 4 3^Rational[1, 2], -6 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] - 4 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] - 3 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           4 - 3 3^Rational[1, 2], -5 + 2 3^Rational[1, 2]}, {
           4 - 3 3^Rational[1, 2], -6 + 2 3^Rational[1, 2]}, {
           Rational[9, 2] - 3 3^Rational[1, 2], -6 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           5 + Rational[-5, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            3 3^Rational[1, 2]}, {
           5 + Rational[-5, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            3 3^Rational[1, 2]}, {
           5 - 3 3^Rational[1, 2], -7 + 3 3^Rational[1, 2]}, {
           Rational[11, 2] - 3 3^Rational[1, 2], -7 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-15, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           6 + Rational[-7, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            2 3^Rational[1, 2]}, {
           7 + Rational[-7, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            2 3^Rational[1, 2]}, {
           8 + Rational[-7, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            2 3^Rational[1, 2]}, {
           8 + Rational[-7, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            2 3^Rational[1, 2]}, {
           8 + Rational[-7, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            2 3^Rational[1, 2]}, {
           7 + Rational[-7, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[-7, 2] 3^Rational[1, 2], 
            Rational[-15, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] - 3 3^Rational[1, 2], -8 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           6 - 3 3^Rational[1, 2], -8 + 3^Rational[1, 2]}, {
           6 + Rational[-5, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-15, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           5 + Rational[-5, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            3^Rational[1, 2]}, {
           5 + Rational[-5, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-17, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           8 + Rational[-5, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 2 3^Rational[1, 2]}, {
           9 + Rational[-7, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            2 3^Rational[1, 2]}, {
           10 + Rational[-7, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            2 3^Rational[1, 2]}, {
           10 + Rational[-7, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            2 3^Rational[1, 2]}, {
           10 - 3 3^Rational[1, 2], -9 + 2 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 2 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 2 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -10 + 2 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 2 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           Rational[19, 2] - 3 3^Rational[1, 2], -9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           9 + Rational[-5, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           8 + Rational[-5, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -10 + 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -10 + 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -11 + 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -11 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-23, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -12 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -12 + 2 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -13 + 2 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -13 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -13 + 3 3^Rational[1, 2]}, {
           Rational[15, 2] - 3 3^Rational[1, 2], -13 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] - 3 3^Rational[1, 2], -14 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           8 - 3 3^Rational[1, 2], -14 + 4 3^Rational[1, 2]}, {
           Rational[17, 2] - 3 3^Rational[1, 2], -14 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -14 + 5 3^Rational[1, 2]}, {
           Rational[19, 2] - 3 3^Rational[1, 2], -14 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           9 - 3 3^Rational[1, 2], -14 + 5 3^Rational[1, 2]}, {
           9 + Rational[-5, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-27, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           10 + Rational[-5, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            5 3^Rational[1, 2]}, {
           10 - 2 3^Rational[1, 2], -14 + 5 3^Rational[1, 2]}, {
           Rational[19, 2] - 2 3^Rational[1, 2], -14 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           10 + Rational[-3, 2] 3^Rational[1, 2], Rational[-29, 2] + 
            5 3^Rational[1, 2]}, {
           10 + Rational[-3, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-27, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] - 3^Rational[1, 2], -14 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] - 3^Rational[1, 2], -13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           9 - 3^Rational[1, 2], -13 + 5 3^Rational[1, 2]}, {
           Rational[17, 2] - 3^Rational[1, 2], -13 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -13 + 5 3^Rational[1, 2]}, {
           Rational[17, 2] - 3^Rational[1, 2], -13 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           9 - 3^Rational[1, 2], -13 + 4 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -13 + 4 3^Rational[1, 2]}, {
           Rational[17, 2] - 3^Rational[1, 2], -13 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -13 + 4 3^Rational[1, 2]}, {
           Rational[15, 2] - 3^Rational[1, 2], -13 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -13 + 4 3^Rational[1, 2]}, {
           8 + Rational[-1, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            4 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -14 + 4 3^Rational[1, 2]}, {
           Rational[15, 2] - 3^Rational[1, 2], -14 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           7 - 3^Rational[1, 2], -14 + 3 3^Rational[1, 2]}, {
           8 - 3^Rational[1, 2], -14 + 3 3^Rational[1, 2]}, {
           7 - 3^Rational[1, 2], -14 + 3 3^Rational[1, 2]}, {
           Rational[15, 2] - 3^Rational[1, 2], -14 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           9 + Rational[-3, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           8 + Rational[-3, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           8 + Rational[-3, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 2 3^Rational[1, 2], -16 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 2 3^Rational[1, 2], -17 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 2 3^Rational[1, 2], -16 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 2 3^Rational[1, 2], -17 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] - 2 3^Rational[1, 2], -18 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] - 2 3^Rational[1, 2], -18 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] - 2 3^Rational[1, 2], -18 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           7 - 2 3^Rational[1, 2], -18 + 4 3^Rational[1, 2]}, {
           6 - 2 3^Rational[1, 2], -18 + 4 3^Rational[1, 2]}, {
           6 - 2 3^Rational[1, 2], -17 + 4 3^Rational[1, 2]}, {
           6 + Rational[-3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           6 + Rational[-3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            3 3^Rational[1, 2]}, {
           6 - 3^Rational[1, 2], -18 + 3 3^Rational[1, 2]}, {
           6 + Rational[-3, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            3 3^Rational[1, 2]}, {
           6 - 2 3^Rational[1, 2], -19 + 3 3^Rational[1, 2]}, {
           6 + Rational[-5, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[-5, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] - 2 3^Rational[1, 2], -20 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           5 - 2 3^Rational[1, 2], -20 + 4 3^Rational[1, 2]}, {
           5 + Rational[-3, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            4 3^Rational[1, 2]}, {
           5 + Rational[-3, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[-3, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           5 + Rational[-3, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            4 3^Rational[1, 2]}, {
           5 - 3^Rational[1, 2], -19 + 4 3^Rational[1, 2]}, {
           Rational[9, 2] - 3^Rational[1, 2], -19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] - 3^Rational[1, 2], -19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           3 + Rational[-1, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            5 3^Rational[1, 2]}, {
           3 - 3^Rational[1, 2], -20 + 5 3^Rational[1, 2]}, {
           3 + Rational[-3, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            5 3^Rational[1, 2]}, {
           3 - 3^Rational[1, 2], -20 + 5 3^Rational[1, 2]}, {
           3 - 3^Rational[1, 2], -19 + 5 3^Rational[1, 2]}, {
           Rational[5, 2] - 3^Rational[1, 2], -19 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] - 3^Rational[1, 2], -20 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] - 3^Rational[1, 2], -19 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           3 + Rational[-1, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2], -20 + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2], -19 + Rational[13, 2] 3^Rational[1, 2]}, {
           4, -19 + 6 3^Rational[1, 2]}, {
           4 + Rational[1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           5 + Rational[1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            5 3^Rational[1, 2]}, {
           6 + Rational[1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            5 3^Rational[1, 2]}, {6, -18 + 5 3^Rational[1, 2]}, {
           Rational[13, 2], -18 + Rational[9, 2] 3^Rational[1, 2]}, {
           6, -18 + 5 3^Rational[1, 2]}, {
           6 + Rational[1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           6 + Rational[1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {6, -18 + 6 3^Rational[1, 2]}, {
           6, -17 + 6 3^Rational[1, 2]}, {
           6 + Rational[1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {
           6 + 3^Rational[1, 2], -18 + 6 3^Rational[1, 2]}, {
           6 + Rational[1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           8 + Rational[1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {8, -18 + 6 3^Rational[1, 2]}, {
           8 + Rational[-1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           8 + Rational[-1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           7 + Rational[-1, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            6 3^Rational[1, 2]}, {7, -19 + 6 3^Rational[1, 2]}, {
           7 + Rational[-1, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           7 + Rational[-1, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] - 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[-1, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           7 + Rational[-1, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {7, -17 + 6 3^Rational[1, 2]}, {
           Rational[15, 2], -17 + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2], -17 + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           7 + Rational[1, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           7 + Rational[1, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[1, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -17 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -17 + 6 3^Rational[1, 2]}, {
           6 + 3^Rational[1, 2], -17 + 6 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            7 3^Rational[1, 2]}, {
           5 + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           4 + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           4 + 2 3^Rational[1, 2], -18 + 7 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[5, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -19 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[5, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           4 + Rational[5, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            7 3^Rational[1, 2]}, {
           4 + 2 3^Rational[1, 2], -18 + 7 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 3^Rational[1, 2], -17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -17 + 6 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           5 + 2 3^Rational[1, 2], -17 + 6 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -17 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -17 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[5, 2] 3^Rational[1, 2], Rational[-35, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           5 + 2 3^Rational[1, 2], -18 + 5 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           5 + 2 3^Rational[1, 2], -18 + 5 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -17 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -18 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           4 + 2 3^Rational[1, 2], -19 + 5 3^Rational[1, 2]}, {
           4 + Rational[3, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            5 3^Rational[1, 2]}, {
           4 + Rational[3, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            5 3^Rational[1, 2]}, {
           4 + 2 3^Rational[1, 2], -21 + 5 3^Rational[1, 2]}, {
           4 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            5 3^Rational[1, 2]}, {
           4 + Rational[5, 2] 3^Rational[1, 2], Rational[-43, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[5, 2] 3^Rational[1, 2], Rational[-43, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -21 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           5 + 2 3^Rational[1, 2], -21 + 5 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-43, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           5 + Rational[3, 2] 3^Rational[1, 2], Rational[-43, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-43, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-43, 2] + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 3^Rational[1, 2], -22 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[3, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -22 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 2 3^Rational[1, 2], -23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -24 + 5 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-49, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 2 3^Rational[1, 2], -25 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           5 + 2 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-49, 2] + 
            4 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           Rational[13, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           6 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           6 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           7 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           7 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           Rational[13, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           6 + 2 3^Rational[1, 2], -26 + 4 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-51, 2] + 
            4 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-53, 2] + 
            4 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-55, 2] + 
            4 3^Rational[1, 2]}, {
           5 + Rational[3, 2] 3^Rational[1, 2], Rational[-55, 2] + 
            4 3^Rational[1, 2]}, {
           6 + Rational[3, 2] 3^Rational[1, 2], Rational[-55, 2] + 
            4 3^Rational[1, 2]}, {
           7 + Rational[3, 2] 3^Rational[1, 2], Rational[-55, 2] + 
            4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -27 + 4 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -27 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -27 + 4 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -27 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -27 + 4 3^Rational[1, 2]}, {
           7 + Rational[1, 2] 3^Rational[1, 2], Rational[-53, 2] + 
            4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -26 + 4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -25 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           6 + 3^Rational[1, 2], -25 + 5 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -25 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -25 + 5 3^Rational[1, 2]}, {
           Rational[13, 2] + 3^Rational[1, 2], -25 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           7 + Rational[3, 2] 3^Rational[1, 2], Rational[-51, 2] + 
            4 3^Rational[1, 2]}, {
           7 + Rational[3, 2] 3^Rational[1, 2], Rational[-49, 2] + 
            4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           8 + 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           8 + 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           7 + 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           8 + 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           8 + 3^Rational[1, 2], -25 + 4 3^Rational[1, 2]}, {
           8 + Rational[3, 2] 3^Rational[1, 2], Rational[-49, 2] + 
            4 3^Rational[1, 2]}, {
           8 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           Rational[15, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           8 + 2 3^Rational[1, 2], -24 + 4 3^Rational[1, 2]}, {
           8 + 2 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           8 + Rational[3, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-43, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           9 + Rational[3, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           10 + Rational[3, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           10 + 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           10 + Rational[1, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            4 3^Rational[1, 2]}, {
           10 + 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           10 + Rational[3, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3^Rational[1, 2], -23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3^Rational[1, 2], -23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[3, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 2 3^Rational[1, 2], -24 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 2 3^Rational[1, 2], -23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           9 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           11 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           12 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            4 3^Rational[1, 2]}, {
           12 + Rational[5, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            4 3^Rational[1, 2]}, {
           11 + Rational[5, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            4 3^Rational[1, 2]}, {
           11 + 3 3^Rational[1, 2], -23 + 4 3^Rational[1, 2]}, {
           Rational[21, 2] + 3 3^Rational[1, 2], -23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-47, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 3 3^Rational[1, 2], -23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 3 3^Rational[1, 2], -23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3 3^Rational[1, 2], -23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3 3^Rational[1, 2], -22 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           11 + 3 3^Rational[1, 2], -22 + 3 3^Rational[1, 2]}, {
           11 + Rational[5, 2] 3^Rational[1, 2], Rational[-45, 2] + 
            3 3^Rational[1, 2]}, {
           11 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            3 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-47, 2] + 
            3 3^Rational[1, 2]}, {
           10 + 3 3^Rational[1, 2], -23 + 3 3^Rational[1, 2]}, {
           Rational[19, 2] + 3 3^Rational[1, 2], -23 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 3 3^Rational[1, 2], -22 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 3 3^Rational[1, 2], -22 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           8 + 3 3^Rational[1, 2], -22 + 2 3^Rational[1, 2]}, {
           8 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           9 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           8 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           9 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           9 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           10 + 2 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           11 + 2 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           10 + 2 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           9 + 2 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           10 + 2 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[5, 2] 3^Rational[1, 2], 
            Rational[-41, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            3^Rational[1, 2]}, {
           10 + Rational[5, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            3^Rational[1, 2]}, {
           10 + 3 3^Rational[1, 2], -20 + 3^Rational[1, 2]}, {
           10 + Rational[7, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            3^Rational[1, 2]}, {
           10 + 4 3^Rational[1, 2], -19 + 3^Rational[1, 2]}, {
           Rational[19, 2] + 4 3^Rational[1, 2], -19 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-39, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-41, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           9 + Rational[7, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           9 + 4 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           Rational[19, 2] + 4 3^Rational[1, 2], -20 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           10 + 4 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           10 + 4 3^Rational[1, 2], -19 + 2 3^Rational[1, 2]}, {
           11 + 4 3^Rational[1, 2], -19 + 2 3^Rational[1, 2]}, {
           Rational[21, 2] + 4 3^Rational[1, 2], -19 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 4 3^Rational[1, 2], -20 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           10 + 4 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           10 + Rational[9, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            2 3^Rational[1, 2]}, {
           10 + 4 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           10 + Rational[7, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2], 
            Rational[-41, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 3 3^Rational[1, 2], -20 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 3 3^Rational[1, 2], -20 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           11 + 3 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           Rational[23, 2] + 3 3^Rational[1, 2], -20 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           12 + 3 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           12 + Rational[5, 2] 3^Rational[1, 2], Rational[-41, 2] + 
            2 3^Rational[1, 2]}, {
           12 + 3 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           12 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           13 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           13 + Rational[5, 2] 3^Rational[1, 2], Rational[-43, 2] + 
            2 3^Rational[1, 2]}, {
           13 + 3 3^Rational[1, 2], -21 + 2 3^Rational[1, 2]}, {
           13 + 3 3^Rational[1, 2], -20 + 2 3^Rational[1, 2]}, {
           13 + Rational[5, 2] 3^Rational[1, 2], Rational[-39, 2] + 
            2 3^Rational[1, 2]}, {
           13 + 3 3^Rational[1, 2], -19 + 2 3^Rational[1, 2]}, {
           13 + Rational[7, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            2 3^Rational[1, 2]}, {
           13 + 4 3^Rational[1, 2], -18 + 2 3^Rational[1, 2]}, {
           Rational[25, 2] + 4 3^Rational[1, 2], -18 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           13 + Rational[9, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           13 + Rational[9, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            4 3^Rational[1, 2]}, {
           14 + Rational[9, 2] 3^Rational[1, 2], Rational[-37, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-37, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 5 3^Rational[1, 2], -18 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-35, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 5 3^Rational[1, 2], -17 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           13 + 5 3^Rational[1, 2], -17 + 3 3^Rational[1, 2]}, {
           Rational[27, 2] + 5 3^Rational[1, 2], -17 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 5 3^Rational[1, 2], -16 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           13 + 5 3^Rational[1, 2], -16 + 3 3^Rational[1, 2]}, {
           13 + Rational[11, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            3 3^Rational[1, 2]}, {
           13 + 6 3^Rational[1, 2], -15 + 3 3^Rational[1, 2]}, {
           13 + Rational[13, 2] 3^Rational[1, 2], Rational[-29, 2] + 
            3 3^Rational[1, 2]}, {
           13 + Rational[13, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            3 3^Rational[1, 2]}, {
           14 + Rational[13, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           13 + Rational[13, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 7 3^Rational[1, 2], -16 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           12 + Rational[13, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            3 3^Rational[1, 2]}, {
           13 + Rational[13, 2] 3^Rational[1, 2], Rational[-33, 2] + 
            3 3^Rational[1, 2]}, {
           13 + 6 3^Rational[1, 2], -16 + 3 3^Rational[1, 2]}, {
           13 + 6 3^Rational[1, 2], -17 + 3 3^Rational[1, 2]}, {
           13 + 6 3^Rational[1, 2], -16 + 3 3^Rational[1, 2]}, {
           Rational[25, 2] + 6 3^Rational[1, 2], -16 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           12 + 6 3^Rational[1, 2], -16 + 2 3^Rational[1, 2]}, {
           12 + Rational[13, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            2 3^Rational[1, 2]}, {
           11 + Rational[13, 2] 3^Rational[1, 2], Rational[-31, 2] + 
            2 3^Rational[1, 2]}, {
           11 + 7 3^Rational[1, 2], -15 + 2 3^Rational[1, 2]}, {
           Rational[23, 2] + 7 3^Rational[1, 2], -15 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 7 3^Rational[1, 2], -15 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 7 3^Rational[1, 2], -16 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 7 3^Rational[1, 2], -15 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 7 3^Rational[1, 2], -14 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           12 + 7 3^Rational[1, 2], -14 + 2 3^Rational[1, 2]}, {
           Rational[23, 2] + 7 3^Rational[1, 2], -14 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 7 3^Rational[1, 2], -15 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-31, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[-29, 2] + 
            2 3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            2 3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[-29, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-29, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-27, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           15 + Rational[15, 2] 3^Rational[1, 2], Rational[-27, 2] + 
            3^Rational[1, 2]}, {
           15 + 8 3^Rational[1, 2], -13 + 3^Rational[1, 2]}, {
           15 + Rational[15, 2] 3^Rational[1, 2], Rational[-25, 2] + 
            3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           15 + Rational[15, 2] 3^Rational[1, 2], Rational[-25, 2] + 
            3^Rational[1, 2]}, {
           15 + Rational[15, 2] 3^Rational[1, 2], Rational[-23, 2] + 
            3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[-23, 2] + 
            3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[-21, 2] + 
            3^Rational[1, 2]}, {
           14 + 7 3^Rational[1, 2], -10 + 3^Rational[1, 2]}, {
           Rational[29, 2] + 7 3^Rational[1, 2], -10 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 6 3^Rational[1, 2], -9 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           15 + 6 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           15 + Rational[11, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[31, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           16 + 5 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           16 + 5 3^Rational[1, 2], -10 + 3^Rational[1, 2]}, {
           16 + 5 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           17 + 5 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           17 + Rational[11, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-17, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 6 3^Rational[1, 2], -9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-17, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           17 + Rational[13, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           17 + Rational[13, 2] 3^Rational[1, 2], Rational[-15, 2] + 
            3^Rational[1, 2]}, {
           17 + 7 3^Rational[1, 2], -8 + 3^Rational[1, 2]}, {
           17 + Rational[15, 2] 3^Rational[1, 2], Rational[-17, 2] + 
            3^Rational[1, 2]}, {
           17 + 8 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           17 + Rational[15, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           17 + Rational[15, 2] 3^Rational[1, 2], Rational[-21, 2] + 
            3^Rational[1, 2]}, {
           17 + Rational[15, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           18 + Rational[15, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           18 + 7 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], -9 + 3^Rational[1, 2]}, {
           19 + Rational[13, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-17, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           19 + Rational[13, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           19 + Rational[13, 2] 3^Rational[1, 2], Rational[-19, 2] + 
            3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-21, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], -11 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], -11 + 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], -11 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], -11 + 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], -11 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           20 + 7 3^Rational[1, 2], -11}, {
           20 + Rational[15, 2] 3^Rational[1, 2], Rational[-23, 2]}, {
           20 + 7 3^Rational[1, 2], -12}, {
           Rational[41, 2] + 7 3^Rational[1, 2], -12 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           21 + Rational[13, 2] 3^Rational[1, 2], Rational[-25, 2] + 
            3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 7 3^Rational[1, 2], -12 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           22 + Rational[13, 2] 3^Rational[1, 2], Rational[-25, 2]}, {
           23 + Rational[13, 2] 3^Rational[1, 2], Rational[-25, 2]}, {
           23 + 6 3^Rational[1, 2], -12}, {
           Rational[47, 2] + 6 3^Rational[1, 2], -12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           24 + 6 3^Rational[1, 2], -12 - 3^Rational[1, 2]}, {
           25 + 6 3^Rational[1, 2], -12 - 3^Rational[1, 2]}, {
           25 + Rational[11, 2] 3^Rational[1, 2], Rational[-25, 2] - 3^
            Rational[1, 2]}, {
           25 + Rational[11, 2] 3^Rational[1, 2], Rational[-27, 2] - 3^
            Rational[1, 2]}, {
           25 + 5 3^Rational[1, 2], -13 - 3^Rational[1, 2]}, {
           Rational[49, 2] + 5 3^Rational[1, 2], -13 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           25 + 5 3^Rational[1, 2], -13 - 2 3^Rational[1, 2]}, {
           25 + Rational[11, 2] 3^Rational[1, 2], Rational[-25, 2] - 2 
            3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-25, 2] + Rational[-5, 2] 3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-25, 2] - 2 
            3^Rational[1, 2]}, {
           24 + 6 3^Rational[1, 2], -12 - 2 3^Rational[1, 2]}, {
           24 + 6 3^Rational[1, 2], -11 - 2 3^Rational[1, 2]}, {
           Rational[49, 2] + 6 3^Rational[1, 2], -11 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           25 + 6 3^Rational[1, 2], -11 - 3 3^Rational[1, 2]}, {
           25 + Rational[11, 2] 3^Rational[1, 2], Rational[-21, 2] - 3 
            3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-21, 2] - 3 
            3^Rational[1, 2]}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-21, 2] - 3 
            3^Rational[1, 2]}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-23, 2] - 3 
            3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-23, 2] + Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -12 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -11 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -10 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -9 - 2 3^Rational[1, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-17, 2] - 2 
            3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-17, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           21 + Rational[11, 2] 3^Rational[1, 2], Rational[-17, 2] - 3^
            Rational[1, 2]}, {
           21 + 5 3^Rational[1, 2], -9 - 3^Rational[1, 2]}, {
           Rational[41, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -9 - 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-19, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-19, 2] - 3^
            Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -9 - 3^Rational[1, 2]}, {
           23 + Rational[9, 2] 3^Rational[1, 2], Rational[-19, 2] - 3^
            Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -10 - 3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], -10 - 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -10 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -10}, {
           23 + Rational[9, 2] 3^Rational[1, 2], Rational[-19, 2]}, {
           23 + 5 3^Rational[1, 2], -10}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-19, 2]}, {
           23 + 5 3^Rational[1, 2], -9}, {22 + 5 3^Rational[1, 2], -9}, {
           22 + 5 3^Rational[1, 2], -8}, {
           Rational[43, 2] + 5 3^Rational[1, 2], -8 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -8}, {22 + 5 3^Rational[1, 2], -9}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -9 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -9}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-17, 2]}, {
           22 + 6 3^Rational[1, 2], -8}, {21 + 6 3^Rational[1, 2], -8}, {
           21 + Rational[13, 2] 3^Rational[1, 2], Rational[-15, 2]}, {
           21 + 6 3^Rational[1, 2], -7}, {
           21 + Rational[11, 2] 3^Rational[1, 2], Rational[-13, 2]}, {
           21 + 6 3^Rational[1, 2], -7}, {22 + 6 3^Rational[1, 2], -7}, {
           Rational[43, 2] + 6 3^Rational[1, 2], -7 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-13, 2] + 
            3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-13, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 6 3^Rational[1, 2], -6 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           21 + Rational[11, 2] 3^Rational[1, 2], Rational[-11, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-11, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -6 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-11, 2]}, {
           Rational[43, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], 
            Rational[-11, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -4 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -4 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -4 + 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -4 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
           24 + 6 3^Rational[1, 2], -3}, {
           24 + Rational[13, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
           23 + Rational[13, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
           Rational[45, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-5, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           22 + Rational[13, 2] 3^Rational[1, 2], Rational[-5, 2] - 3^
            Rational[1, 2]}, {
           22 + Rational[13, 2] 3^Rational[1, 2], Rational[-3, 2] - 3^
            Rational[1, 2]}, {
           22 + 6 3^Rational[1, 2], -2 - 3^Rational[1, 2]}, {
           Rational[45, 2] + 6 3^Rational[1, 2], -2 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-5, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           22 + Rational[13, 2] 3^Rational[1, 2], Rational[-5, 2] - 2 
            3^Rational[1, 2]}, {
           22 + 6 3^Rational[1, 2], -2 - 2 3^Rational[1, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-5, 2] - 2 
            3^Rational[1, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2] - 2 
            3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 6 3^Rational[1, 2], -4 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 5 3^Rational[1, 2], -4 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -4 - 3^Rational[1, 2]}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[-9, 2] - 3^
            Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -4 - 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] - 3^
            Rational[1, 2]}, {
           23 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] - 3^
            Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] - 3^
            Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], -4 - 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -4 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -4}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2] - 3^
            Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           25 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-7, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-9, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-9, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], -4 + 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -5 + 2 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           23 + 5 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], -5 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           22 + 5 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -6 + 3 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-11, 2] + 
            3 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -5 + 3 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           21 + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {
           21 + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            2 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            2 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -4 + 2 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -3 + 2 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {
           22 + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            2 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -3 + 2 3^Rational[1, 2]}, {
           22 + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {
           22 + 4 3^Rational[1, 2], -3 + 2 3^Rational[1, 2]}, {
           Rational[45, 2] + 4 3^Rational[1, 2], -3 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           23 + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           23 + 4 3^Rational[1, 2], -4 + 3 3^Rational[1, 2]}, {
           Rational[47, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -3 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           24 + 4 3^Rational[1, 2], -3 + 2 3^Rational[1, 2]}, {
           24 + 4 3^Rational[1, 2], -4 + 2 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           25 + 4 3^Rational[1, 2], -4 + 2 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -5 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-9, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -4 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           25 + 4 3^Rational[1, 2], -4 + 3 3^Rational[1, 2]}, {
           25 + 4 3^Rational[1, 2], -3 + 3 3^Rational[1, 2]}, {
           25 + 4 3^Rational[1, 2], -2 + 3 3^Rational[1, 2]}, {
           25 + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], -2 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 4 3^Rational[1, 2], -2 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           25 + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            2 3^Rational[1, 2]}, {
           26 + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            2 3^Rational[1, 2]}, {
           27 + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            2 3^Rational[1, 2]}, {
           27 + Rational[7, 2] 3^Rational[1, 2], Rational[-1, 2] + 
            2 3^Rational[1, 2]}, {
           26 + Rational[7, 2] 3^Rational[1, 2], Rational[-1, 2] + 
            2 3^Rational[1, 2]}, {
           26 + 3 3^Rational[1, 2], -1 + 2 3^Rational[1, 2]}, {
           Rational[53, 2] + 3 3^Rational[1, 2], -1 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 3 3^Rational[1, 2], -1 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           25 + 3 3^Rational[1, 2], -1 + 3^Rational[1, 2]}, {
           Rational[49, 2] + 3 3^Rational[1, 2], -1 + 
            Rational[1, 2] 3^Rational[1, 2]}, {25 + 3 3^Rational[1, 2], -1}, {
           Rational[51, 2] + 3 3^Rational[1, 2], -1 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 3 3^Rational[1, 2], -1 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 3 3^Rational[1, 2], -2 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + 3 3^Rational[1, 2], -2 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-3, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + 3 3^Rational[1, 2], -2 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + 4 3^Rational[1, 2], -3 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           27 + 4 3^Rational[1, 2], -3 - 3^Rational[1, 2]}, {
           27 + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] - 3^
            Rational[1, 2]}, {
           Rational[53, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[-5, 2] + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], -2 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], -2 - 2 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], -2 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           26 + 5 3^Rational[1, 2], -2 - 2 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], -2 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], -2 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-3, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-3, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-3, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-3, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 6 3^Rational[1, 2], -1 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[11, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           27 + Rational[11, 2] 3^Rational[1, 2], Rational[1, 2] - 2 
            3^Rational[1, 2]}, {
           26 + Rational[11, 2] 3^Rational[1, 2], Rational[1, 2] - 2 
            3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[11, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[11, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 6 3^Rational[1, 2], 1 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 6 3^Rational[1, 2], 2 + 
            Rational[-5, 2] 3^Rational[1, 2]}, {
           26 + 6 3^Rational[1, 2], 2 - 2 3^Rational[1, 2]}, {
           26 + 6 3^Rational[1, 2], 1 - 2 3^Rational[1, 2]}, {
           26 + 6 3^Rational[1, 2], 2 - 2 3^Rational[1, 2]}, {
           26 + 6 3^Rational[1, 2], 1 - 2 3^Rational[1, 2]}, {
           26 + 6 3^Rational[1, 2], (-2) 3^Rational[1, 2]}, {
           Rational[51, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           Rational[49, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           Rational[47, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           24 + 6 3^Rational[1, 2], (-2) 3^Rational[1, 2]}, {
           Rational[49, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 6 3^Rational[1, 2], Rational[-3, 2] 
            3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           24 + Rational[11, 2] 3^Rational[1, 2], Rational[-1, 2] - 3^
            Rational[1, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], Rational[-1, 2] 
            3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           23 + Rational[11, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
           23 + 5 3^Rational[1, 2], 0}, {
           Rational[47, 2] + 5 3^Rational[1, 2], Rational[-1, 2] 
            3^Rational[1, 2]}, {24 + 5 3^Rational[1, 2], -3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], Rational[-1, 2] 
            3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           23 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 5 3^Rational[1, 2], 1 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], 1 + 3^Rational[1, 2]}, {
           Rational[49, 2] + 5 3^Rational[1, 2], 1 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           25 + 5 3^Rational[1, 2], 1 + 2 3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], 1 + 2 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            2 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], 1 + 2 3^Rational[1, 2]}, {
           24 + 5 3^Rational[1, 2], 2 + 2 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            2 3^Rational[1, 2]}, {
           24 + 4 3^Rational[1, 2], 2 + 2 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], 2 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           24 + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 4 3^Rational[1, 2], 2 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           25 + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            2 3^Rational[1, 2]}, {
           25 + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           26 + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           25 + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], 3 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           25 + 4 3^Rational[1, 2], 3 + 2 3^Rational[1, 2]}, {
           Rational[51, 2] + 4 3^Rational[1, 2], 3 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 4 3^Rational[1, 2], 4 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 4 3^Rational[1, 2], 3 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 4 3^Rational[1, 2], 3 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[5, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           26 + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            3^Rational[1, 2]}, {
           26 + 5 3^Rational[1, 2], 1 + 3^Rational[1, 2]}, {
           26 + 5 3^Rational[1, 2], 2 + 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], 2 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           26 + 5 3^Rational[1, 2], 2 + 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 2 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[57, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           28 + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[3, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           28 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[9, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           29 + 4 3^Rational[1, 2], 1 + 2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[-1, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[1, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[3, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[5, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[59, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[5, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[59, 2] + Rational[7, 2] 3^Rational[1, 2], Rational[7, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           29 + Rational[7, 2] 3^Rational[1, 2], Rational[7, 2] + 
            2 3^Rational[1, 2]}, {
           29 + 4 3^Rational[1, 2], 4 + 2 3^Rational[1, 2]}, {
           29 + 4 3^Rational[1, 2], 3 + 2 3^Rational[1, 2]}, {
           29 + Rational[9, 2] 3^Rational[1, 2], Rational[7, 2] + 
            2 3^Rational[1, 2]}, {
           29 + Rational[9, 2] 3^Rational[1, 2], Rational[9, 2] + 
            2 3^Rational[1, 2]}, {
           29 + 4 3^Rational[1, 2], 5 + 2 3^Rational[1, 2]}, {
           29 + Rational[9, 2] 3^Rational[1, 2], Rational[9, 2] + 
            2 3^Rational[1, 2]}, {
           30 + Rational[9, 2] 3^Rational[1, 2], Rational[9, 2] + 
            2 3^Rational[1, 2]}, {
           Rational[59, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[9, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[59, 2] + 4 3^Rational[1, 2], 5 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[59, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[11, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[59, 2] + 5 3^Rational[1, 2], 6 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[57, 2] + 5 3^Rational[1, 2], 6 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[57, 2] + 5 3^Rational[1, 2], 7 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[57, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[15, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           28 + Rational[9, 2] 3^Rational[1, 2], Rational[15, 2] + 
            3^Rational[1, 2]}, {
           28 + Rational[9, 2] 3^Rational[1, 2], Rational[17, 2] + 
            3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[17, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + 4 3^Rational[1, 2], 9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[55, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 10 + 3^Rational[1, 2]}, {
           Rational[55, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 10 + 3^Rational[1, 2]}, {
           27 + Rational[9, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 11 + 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 10 + 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 9 + 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], 11 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           27 + 5 3^Rational[1, 2], 9 + 2 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           26 + 5 3^Rational[1, 2], 9 + 2 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + 5 3^Rational[1, 2], 10 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[21, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[21, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[51, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           24 + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[9, 2] 3^Rational[1, 2], Rational[19, 2] + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[1, 2] 3^Rational[1, 2]}, {24 + 5 3^Rational[1, 2], 9}, {
           Rational[47, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 5 3^Rational[1, 2], 9 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 6 3^Rational[1, 2], 10 + 
            Rational[1, 2] 3^Rational[1, 2]}, {22 + 6 3^Rational[1, 2], 10}, {
           23 + 6 3^Rational[1, 2], 10}, {24 + 6 3^Rational[1, 2], 10}, {
           Rational[47, 2] + 6 3^Rational[1, 2], 10 + 
            Rational[1, 2] 3^Rational[1, 2]}, {23 + 6 3^Rational[1, 2], 10}, {
           23 + 6 3^Rational[1, 2], 11}, {22 + 6 3^Rational[1, 2], 11}, {
           22 + Rational[11, 2] 3^Rational[1, 2], Rational[21, 2]}, {
           22 + 6 3^Rational[1, 2], 11}, {22 + 6 3^Rational[1, 2], 12}, {
           21 + 6 3^Rational[1, 2], 12}, {
           21 + Rational[13, 2] 3^Rational[1, 2], Rational[25, 2]}, {
           21 + 6 3^Rational[1, 2], 12}, {
           Rational[43, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[1, 2] 3^Rational[1, 2]}, {21 + 6 3^Rational[1, 2], 12}, {
           Rational[41, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           20 + 6 3^Rational[1, 2], 12}, {
           Rational[39, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           20 + 6 3^Rational[1, 2], 12}, {
           Rational[39, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 6 3^Rational[1, 2], 11 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 6 3^Rational[1, 2], 11 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 6 3^Rational[1, 2], 11 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 6 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           20 + Rational[13, 2] 3^Rational[1, 2], Rational[25, 2] - 3^
            Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[23, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], 12 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           19 + Rational[13, 2] 3^Rational[1, 2], Rational[25, 2] - 3^
            Rational[1, 2]}, {
           19 + 6 3^Rational[1, 2], 13 - 3^Rational[1, 2]}, {
           19 + Rational[13, 2] 3^Rational[1, 2], Rational[27, 2] - 3^
            Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 14 - 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], 14 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           18 + 7 3^Rational[1, 2], 14 - 3^Rational[1, 2]}, {
           18 + 7 3^Rational[1, 2], 13 - 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 13 - 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[27, 2] - 3^
            Rational[1, 2]}, {
           Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[27, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], 14 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], 14 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], 13 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], 13 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 13 - 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[27, 2] - 3^
            Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[27, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[27, 2] - 3^
            Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[29, 2] - 3^
            Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 14 - 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[29, 2] - 3^
            Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[31, 2] - 3^
            Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 16 - 3^Rational[1, 2]}, {
           20 + 7 3^Rational[1, 2], 16 - 3^Rational[1, 2]}, {
           21 + 7 3^Rational[1, 2], 16 - 3^Rational[1, 2]}, {
           22 + 7 3^Rational[1, 2], 16 - 3^Rational[1, 2]}, {
           22 + Rational[13, 2] 3^Rational[1, 2], Rational[33, 2] - 3^
            Rational[1, 2]}, {
           22 + 7 3^Rational[1, 2], 16 - 3^Rational[1, 2]}, {
           Rational[45, 2] + 7 3^Rational[1, 2], 16 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 7 3^Rational[1, 2], 17 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 7 3^Rational[1, 2], 16 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 7 3^Rational[1, 2], 16 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 7 3^Rational[1, 2], 17 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 7 3^Rational[1, 2], 17 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 7 3^Rational[1, 2], 18 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           21 + 7 3^Rational[1, 2], 18 - 3^Rational[1, 2]}, {
           21 + 7 3^Rational[1, 2], 19 - 3^Rational[1, 2]}, {
           Rational[41, 2] + 7 3^Rational[1, 2], 19 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           20 + 7 3^Rational[1, 2], 19 - 2 3^Rational[1, 2]}, {
           Rational[39, 2] + 7 3^Rational[1, 2], 19 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], 19 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           19 + 7 3^Rational[1, 2], 19 - 2 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[37, 2] - 2 
            3^Rational[1, 2]}, {
           18 + Rational[15, 2] 3^Rational[1, 2], Rational[37, 2] - 2 
            3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[-3, 2] 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[37, 2] - 3^
            Rational[1, 2]}, {19 + 8 3^Rational[1, 2], 18 - 3^Rational[1, 2]},
            {18 + 8 3^Rational[1, 2], 18 - 3^Rational[1, 2]}, {
           Rational[35, 2] + 8 3^Rational[1, 2], 18 + 
            Rational[-3, 2] 3^Rational[1, 2]}, {
           17 + 8 3^Rational[1, 2], 18 - 3^Rational[1, 2]}, {
           17 + Rational[15, 2] 3^Rational[1, 2], Rational[37, 2] - 3^
            Rational[1, 2]}, {
           17 + 7 3^Rational[1, 2], 19 - 3^Rational[1, 2]}, {
           Rational[35, 2] + 7 3^Rational[1, 2], 19 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           18 + 7 3^Rational[1, 2], 19 - 3^Rational[1, 2]}, {
           18 + Rational[15, 2] 3^Rational[1, 2], Rational[39, 2] - 3^
            Rational[1, 2]}, {
           18 + Rational[15, 2] 3^Rational[1, 2], Rational[41, 2] - 3^
            Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[41, 2] - 3^
            Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 21 - 3^Rational[1, 2]}, {
           Rational[37, 2] + 8 3^Rational[1, 2], 21 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 8 3^Rational[1, 2], 21 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           18 + Rational[17, 2] 3^Rational[1, 2], Rational[43, 2]}, {
           18 + Rational[17, 2] 3^Rational[1, 2], Rational[41, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 8 3^Rational[1, 2], 21 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[43, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[45, 2]}, {
           Rational[33, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[45, 2] - 3^
            Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[-1, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 9 3^Rational[1, 2], 22 + 
            Rational[-1, 2] 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 22}, {
           Rational[33, 2] + 9 3^Rational[1, 2], 22 + 
            Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[1, 2] 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[43, 2] + 
            3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 20 + 3^Rational[1, 2]}, {
           16 + 10 3^Rational[1, 2], 20 + 3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 20 + 3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 19 + 3^Rational[1, 2]}, {
           18 + 10 3^Rational[1, 2], 19 + 3^Rational[1, 2]}, {
           18 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            2 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 18 + 2 3^Rational[1, 2]}, {
           Rational[35, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           19 + 9 3^Rational[1, 2], 18 + 2 3^Rational[1, 2]}, {
           19 + 9 3^Rational[1, 2], 19 + 2 3^Rational[1, 2]}, {
           Rational[37, 2] + 9 3^Rational[1, 2], 19 + 
            Rational[3, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[3, 2] 3^Rational[1, 2]}, {
           19 + Rational[17, 2] 3^Rational[1, 2], Rational[39, 2] + 
            2 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 20 + 2 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 20 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           20 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[5, 2] 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           20 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           20 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           18 + 8 3^Rational[1, 2], 19 + 3 3^Rational[1, 2]}, {
           Rational[37, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 19 + 4 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 20 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           20 + Rational[17, 2] 3^Rational[1, 2], Rational[39, 2] + 
            4 3^Rational[1, 2]}, {
           20 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            4 3^Rational[1, 2]}, {
           20 + 8 3^Rational[1, 2], 19 + 4 3^Rational[1, 2]}, {
           Rational[39, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 19 + 4 3^Rational[1, 2]}, {
           Rational[37, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 8 3^Rational[1, 2], 19 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           18 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           19 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            6 3^Rational[1, 2]}, {
           19 + Rational[17, 2] 3^Rational[1, 2], Rational[35, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           19 + Rational[17, 2] 3^Rational[1, 2], Rational[33, 2] + 
            6 3^Rational[1, 2]}, {
           19 + 8 3^Rational[1, 2], 17 + 6 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[33, 2] + 
            6 3^Rational[1, 2]}, {
           19 + Rational[15, 2] 3^Rational[1, 2], Rational[31, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 7 3^Rational[1, 2], 15 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 8 3^Rational[1, 2], 16 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + 8 3^Rational[1, 2], 16 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[35, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + 9 3^Rational[1, 2], 17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[35, 2] + 
            7 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            7 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 19 + 7 3^Rational[1, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           16 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            7 3^Rational[1, 2]}, {
           16 + 9 3^Rational[1, 2], 18 + 7 3^Rational[1, 2]}, {
           16 + Rational[17, 2] 3^Rational[1, 2], Rational[35, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[31, 2] + 9 3^Rational[1, 2], 17 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           16 + 9 3^Rational[1, 2], 17 + 8 3^Rational[1, 2]}, {
           16 + Rational[17, 2] 3^Rational[1, 2], Rational[35, 2] + 
            8 3^Rational[1, 2]}, {
           16 + 9 3^Rational[1, 2], 18 + 8 3^Rational[1, 2]}, {
           Rational[33, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 18 + 9 3^Rational[1, 2]}, {
           Rational[35, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 18 + 9 3^Rational[1, 2]}, {
           17 + Rational[17, 2] 3^Rational[1, 2], Rational[37, 2] + 
            9 3^Rational[1, 2]}, {
           17 + 9 3^Rational[1, 2], 18 + 9 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[35, 2] + 
            9 3^Rational[1, 2]}, {
           16 + Rational[19, 2] 3^Rational[1, 2], Rational[35, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + 9 3^Rational[1, 2], 19 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           18 + 9 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           18 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           18 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            8 3^Rational[1, 2]}, {
           19 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            8 3^Rational[1, 2]}, {
           19 + 10 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           Rational[39, 2] + 10 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + 9 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 9 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           19 + 9 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           20 + 9 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           21 + 9 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 9 3^Rational[1, 2], 21 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 10 3^Rational[1, 2], 20 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 10 3^Rational[1, 2], 21 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 21 + 7 3^Rational[1, 2]}, {
           21 + Rational[21, 2] 3^Rational[1, 2], Rational[41, 2] + 
            7 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 19 + 7 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            7 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           20 + 9 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           21 + 9 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           Rational[41, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            8 3^Rational[1, 2]}, {
           21 + 9 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           20 + 9 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           21 + 9 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           Rational[41, 2] + 9 3^Rational[1, 2], 19 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           20 + Rational[19, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           20 + 10 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           20 + 10 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           Rational[39, 2] + 10 3^Rational[1, 2], 20 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            9 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 18 + 9 3^Rational[1, 2]}, {
           21 + Rational[19, 2] 3^Rational[1, 2], Rational[35, 2] + 
            9 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 18 + 9 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 19 + 9 3^Rational[1, 2]}, {
           Rational[43, 2] + 10 3^Rational[1, 2], 19 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 10 3^Rational[1, 2], 19 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           21 + Rational[21, 2] 3^Rational[1, 2], Rational[37, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[37, 2] + 
            9 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[39, 2] + 
            9 3^Rational[1, 2]}, {
           22 + 10 3^Rational[1, 2], 20 + 9 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[41, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[41, 2] + 
            9 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           23 + 10 3^Rational[1, 2], 21 + 9 3^Rational[1, 2]}, {
           23 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            9 3^Rational[1, 2]}, {
           23 + 10 3^Rational[1, 2], 21 + 9 3^Rational[1, 2]}, {
           23 + 10 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[43, 2] + 
            10 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[41, 2] + 
            10 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[41, 2] + 
            11 3^Rational[1, 2]}, {
           24 + 10 3^Rational[1, 2], 21 + 11 3^Rational[1, 2]}, {
           24 + Rational[19, 2] 3^Rational[1, 2], Rational[43, 2] + 
            11 3^Rational[1, 2]}, {
           24 + Rational[19, 2] 3^Rational[1, 2], Rational[41, 2] + 
            11 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 21 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 20 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 19 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 17 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 9 3^Rational[1, 2], 18 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           23 + 9 3^Rational[1, 2], 18 + 12 3^Rational[1, 2]}, {
           23 + Rational[19, 2] 3^Rational[1, 2], Rational[37, 2] + 
            12 3^Rational[1, 2]}, {
           23 + Rational[19, 2] 3^Rational[1, 2], Rational[35, 2] + 
            12 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           23 + Rational[19, 2] 3^Rational[1, 2], Rational[33, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 17 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 16 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           22 + Rational[19, 2] 3^Rational[1, 2], Rational[33, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           22 + Rational[19, 2] 3^Rational[1, 2], Rational[33, 2] + 
            13 3^Rational[1, 2]}, {
           22 + 9 3^Rational[1, 2], 16 + 13 3^Rational[1, 2]}, {
           Rational[45, 2] + 9 3^Rational[1, 2], 16 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           23 + 9 3^Rational[1, 2], 16 + 12 3^Rational[1, 2]}, {
           23 + 9 3^Rational[1, 2], 17 + 12 3^Rational[1, 2]}, {
           23 + Rational[19, 2] 3^Rational[1, 2], Rational[33, 2] + 
            12 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           24 + Rational[19, 2] 3^Rational[1, 2], Rational[33, 2] + 
            13 3^Rational[1, 2]}, {
           24 + Rational[19, 2] 3^Rational[1, 2], Rational[31, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           25 + Rational[19, 2] 3^Rational[1, 2], Rational[31, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + 10 3^Rational[1, 2], 16 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[33, 2] + 
            14 3^Rational[1, 2]}, {
           24 + 11 3^Rational[1, 2], 17 + 14 3^Rational[1, 2]}, {
           Rational[47, 2] + 11 3^Rational[1, 2], 17 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[35, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[35, 2] + 
            14 3^Rational[1, 2]}, {
           24 + Rational[21, 2] 3^Rational[1, 2], Rational[35, 2] + 
            14 3^Rational[1, 2]}, {
           23 + Rational[21, 2] 3^Rational[1, 2], Rational[35, 2] + 
            14 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[35, 2] + 
            14 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[33, 2] + 
            14 3^Rational[1, 2]}, {
           22 + 11 3^Rational[1, 2], 17 + 14 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[35, 2] + 
            14 3^Rational[1, 2]}, {
           22 + 11 3^Rational[1, 2], 18 + 14 3^Rational[1, 2]}, {
           Rational[45, 2] + 11 3^Rational[1, 2], 18 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + 11 3^Rational[1, 2], 17 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 11 3^Rational[1, 2], 17 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[45, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + 11 3^Rational[1, 2], 18 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[47, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           23 + Rational[23, 2] 3^Rational[1, 2], Rational[37, 2] + 
            15 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[37, 2] + 
            15 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[37, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[37, 2] + 
            15 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[39, 2] + 
            15 3^Rational[1, 2]}, {
           21 + 11 3^Rational[1, 2], 20 + 15 3^Rational[1, 2]}, {
           20 + 11 3^Rational[1, 2], 20 + 15 3^Rational[1, 2]}, {
           19 + 11 3^Rational[1, 2], 20 + 15 3^Rational[1, 2]}, {
           19 + Rational[23, 2] 3^Rational[1, 2], Rational[39, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[39, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[45, 2] + 
            14 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            14 3^Rational[1, 2]}, {
           22 + 11 3^Rational[1, 2], 24 + 14 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[49, 2] + 
            14 3^Rational[1, 2]}, {
           22 + Rational[23, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[43, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] + 12 3^Rational[1, 2], 25 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           21 + 12 3^Rational[1, 2], 25 + 14 3^Rational[1, 2]}, {
           21 + 12 3^Rational[1, 2], 24 + 14 3^Rational[1, 2]}, {
           22 + 12 3^Rational[1, 2], 24 + 14 3^Rational[1, 2]}, {
           22 + 12 3^Rational[1, 2], 23 + 14 3^Rational[1, 2]}, {
           Rational[43, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           21 + 12 3^Rational[1, 2], 23 + 14 3^Rational[1, 2]}, {
           21 + Rational[25, 2] 3^Rational[1, 2], Rational[47, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 13 3^Rational[1, 2], 24 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           20 + Rational[25, 2] 3^Rational[1, 2], Rational[49, 2] + 
            14 3^Rational[1, 2]}, {
           20 + 12 3^Rational[1, 2], 25 + 14 3^Rational[1, 2]}, {
           21 + 12 3^Rational[1, 2], 25 + 14 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[49, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 12 3^Rational[1, 2], 25 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[41, 2] + 12 3^Rational[1, 2], 26 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           20 + 12 3^Rational[1, 2], 26 + 13 3^Rational[1, 2]}, {
           20 + 12 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           20 + Rational[23, 2] 3^Rational[1, 2], Rational[53, 2] + 
            13 3^Rational[1, 2]}, {
           21 + Rational[23, 2] 3^Rational[1, 2], Rational[53, 2] + 
            13 3^Rational[1, 2]}, {
           21 + 11 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           21 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           20 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            14 3^Rational[1, 2]}, {
           20 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[41, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           21 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            13 3^Rational[1, 2]}, {
           22 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            13 3^Rational[1, 2]}, {
           22 + 11 3^Rational[1, 2], 26 + 13 3^Rational[1, 2]}, {
           22 + 11 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           21 + 11 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           21 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            13 3^Rational[1, 2]}, {
           21 + 10 3^Rational[1, 2], 26 + 13 3^Rational[1, 2]}, {
           Rational[41, 2] + 10 3^Rational[1, 2], 26 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           20 + 10 3^Rational[1, 2], 26 + 13 3^Rational[1, 2]}, {
           20 + 10 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           19 + 10 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           Rational[37, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 10 3^Rational[1, 2], 26 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[37, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           18 + 10 3^Rational[1, 2], 27 + 13 3^Rational[1, 2]}, {
           Rational[35, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[35, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           17 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            14 3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 26 + 14 3^Rational[1, 2]}, {
           17 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           16 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           15 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            13 3^Rational[1, 2]}, {
           15 + 11 3^Rational[1, 2], 26 + 13 3^Rational[1, 2]}, {
           Rational[29, 2] + 11 3^Rational[1, 2], 26 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[31, 2] + 11 3^Rational[1, 2], 26 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + 11 3^Rational[1, 2], 26 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           17 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            13 3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 25 + 13 3^Rational[1, 2]}, {
           17 + 10 3^Rational[1, 2], 24 + 13 3^Rational[1, 2]}, {
           Rational[33, 2] + 10 3^Rational[1, 2], 24 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[33, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           16 + Rational[19, 2] 3^Rational[1, 2], Rational[47, 2] + 
            14 3^Rational[1, 2]}, {
           17 + Rational[19, 2] 3^Rational[1, 2], Rational[47, 2] + 
            14 3^Rational[1, 2]}, {
           16 + Rational[19, 2] 3^Rational[1, 2], Rational[47, 2] + 
            14 3^Rational[1, 2]}, {
           16 + Rational[19, 2] 3^Rational[1, 2], Rational[45, 2] + 
            14 3^Rational[1, 2]}, {
           16 + 10 3^Rational[1, 2], 23 + 14 3^Rational[1, 2]}, {
           16 + 10 3^Rational[1, 2], 22 + 14 3^Rational[1, 2]}, {
           16 + Rational[21, 2] 3^Rational[1, 2], Rational[43, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           15 + Rational[21, 2] 3^Rational[1, 2], Rational[43, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 10 3^Rational[1, 2], 22 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           13 + Rational[21, 2] 3^Rational[1, 2], Rational[45, 2] + 
            13 3^Rational[1, 2]}, {
           13 + Rational[21, 2] 3^Rational[1, 2], Rational[47, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           13 + Rational[21, 2] 3^Rational[1, 2], Rational[47, 2] + 
            13 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 23 + 13 3^Rational[1, 2]}, {
           Rational[27, 2] + 11 3^Rational[1, 2], 23 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           12 + Rational[23, 2] 3^Rational[1, 2], Rational[43, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           13 + Rational[23, 2] 3^Rational[1, 2], Rational[43, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           13 + Rational[23, 2] 3^Rational[1, 2], Rational[43, 2] + 
            14 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 22 + 14 3^Rational[1, 2]}, {
           13 + Rational[23, 2] 3^Rational[1, 2], Rational[45, 2] + 
            14 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 22 + 14 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 21 + 14 3^Rational[1, 2]}, {
           Rational[27, 2] + 11 3^Rational[1, 2], 21 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 21 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 22 + 13 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 22 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 23 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 23 + 14 3^Rational[1, 2]}, {
           13 + Rational[23, 2] 3^Rational[1, 2], Rational[45, 2] + 
            14 3^Rational[1, 2]}, {
           13 + 12 3^Rational[1, 2], 23 + 14 3^Rational[1, 2]}, {
           Rational[25, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 24 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 11 3^Rational[1, 2], 24 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 11 3^Rational[1, 2], 24 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            14 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            14 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            14 3^Rational[1, 2]}, {
           13 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            14 3^Rational[1, 2]}, {
           13 + 11 3^Rational[1, 2], 27 + 14 3^Rational[1, 2]}, {
           13 + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 11 3^Rational[1, 2], 28 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 11 3^Rational[1, 2], 28 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           14 + 11 3^Rational[1, 2], 28 + 14 3^Rational[1, 2]}, {
           14 + Rational[23, 2] 3^Rational[1, 2], Rational[57, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 11 3^Rational[1, 2], 29 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           15 + 11 3^Rational[1, 2], 29 + 14 3^Rational[1, 2]}, {
           14 + 11 3^Rational[1, 2], 29 + 14 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[57, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           14 + Rational[21, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           14 + 10 3^Rational[1, 2], 29 + 15 3^Rational[1, 2]}, {
           14 + 10 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           15 + 10 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           15 + Rational[21, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[31, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           15 + 10 3^Rational[1, 2], 27 + 15 3^Rational[1, 2]}, {
           15 + Rational[19, 2] 3^Rational[1, 2], Rational[53, 2] + 
            15 3^Rational[1, 2]}, {
           15 + Rational[19, 2] 3^Rational[1, 2], Rational[55, 2] + 
            15 3^Rational[1, 2]}, {
           15 + 9 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           15 + Rational[17, 2] 3^Rational[1, 2], Rational[55, 2] + 
            15 3^Rational[1, 2]}, {
           15 + Rational[17, 2] 3^Rational[1, 2], Rational[53, 2] + 
            15 3^Rational[1, 2]}, {
           14 + Rational[17, 2] 3^Rational[1, 2], Rational[53, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 8 3^Rational[1, 2], 27 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 8 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           15 + 8 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           14 + 8 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           Rational[29, 2] + 8 3^Rational[1, 2], 28 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + Rational[15, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[57, 2] + 
            14 3^Rational[1, 2]}, {
           14 + 8 3^Rational[1, 2], 28 + 14 3^Rational[1, 2]}, {
           14 + 8 3^Rational[1, 2], 29 + 14 3^Rational[1, 2]}, {
           14 + Rational[15, 2] 3^Rational[1, 2], Rational[57, 2] + 
            14 3^Rational[1, 2]}, {
           14 + 8 3^Rational[1, 2], 28 + 14 3^Rational[1, 2]}, {
           14 + Rational[17, 2] 3^Rational[1, 2], Rational[55, 2] + 
            14 3^Rational[1, 2]}, {
           14 + 9 3^Rational[1, 2], 28 + 14 3^Rational[1, 2]}, {
           Rational[27, 2] + 9 3^Rational[1, 2], 28 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 28 + 13 3^Rational[1, 2]}, {
           13 + Rational[17, 2] 3^Rational[1, 2], Rational[57, 2] + 
            13 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 28 + 13 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 29 + 13 3^Rational[1, 2]}, {
           Rational[25, 2] + 9 3^Rational[1, 2], 29 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 9 3^Rational[1, 2], 29 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           14 + 9 3^Rational[1, 2], 29 + 14 3^Rational[1, 2]}, {
           Rational[29, 2] + 9 3^Rational[1, 2], 29 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           Rational[29, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[27, 2] 3^Rational[1, 2]}, {
           14 + 9 3^Rational[1, 2], 30 + 14 3^Rational[1, 2]}, {
           Rational[27, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[29, 2] 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 30 + 15 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 29 + 15 3^Rational[1, 2]}, {
           13 + 9 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           Rational[25, 2] + 9 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 9 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 9 3^Rational[1, 2], 29 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[59, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[59, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 8 3^Rational[1, 2], 29 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[17, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[31, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 8 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           13 + 8 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           Rational[25, 2] + 8 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           12 + 8 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           12 + Rational[17, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           11 + Rational[17, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           10 + Rational[17, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           10 + 9 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           9 + 9 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           Rational[19, 2] + 9 3^Rational[1, 2], 28 + 
            Rational[31, 2] 3^Rational[1, 2]}, {
           9 + 9 3^Rational[1, 2], 28 + 15 3^Rational[1, 2]}, {
           9 + Rational[19, 2] 3^Rational[1, 2], Rational[55, 2] + 
            15 3^Rational[1, 2]}, {
           9 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            15 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[29, 2] 3^Rational[1, 2]}, {
           8 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            14 3^Rational[1, 2]}, {
           8 + Rational[19, 2] 3^Rational[1, 2], Rational[55, 2] + 
            14 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[27, 2] 3^Rational[1, 2]}, {
           9 + Rational[19, 2] 3^Rational[1, 2], Rational[55, 2] + 
            13 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[25, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[25, 2] 3^Rational[1, 2]}, {
           9 + Rational[21, 2] 3^Rational[1, 2], Rational[55, 2] + 
            12 3^Rational[1, 2]}, {
           8 + Rational[21, 2] 3^Rational[1, 2], Rational[55, 2] + 
            12 3^Rational[1, 2]}, {
           8 + 11 3^Rational[1, 2], 28 + 12 3^Rational[1, 2]}, {
           8 + 11 3^Rational[1, 2], 27 + 12 3^Rational[1, 2]}, {
           Rational[17, 2] + 11 3^Rational[1, 2], 27 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 11 3^Rational[1, 2], 27 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 11 3^Rational[1, 2], 28 + 
            Rational[23, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[23, 2] 3^Rational[1, 2]}, {
           9 + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            11 3^Rational[1, 2]}, {
           10 + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            11 3^Rational[1, 2]}, {
           10 + 11 3^Rational[1, 2], 27 + 11 3^Rational[1, 2]}, {
           Rational[21, 2] + 11 3^Rational[1, 2], 27 + 
            Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 10 3^Rational[1, 2], 26 + 
            Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           10 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            10 3^Rational[1, 2]}, {
           10 + 10 3^Rational[1, 2], 26 + 10 3^Rational[1, 2]}, {
           Rational[21, 2] + 10 3^Rational[1, 2], 26 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           11 + 10 3^Rational[1, 2], 26 + 10 3^Rational[1, 2]}, {
           Rational[23, 2] + 10 3^Rational[1, 2], 26 + 
            Rational[21, 2] 3^Rational[1, 2]}, {
           12 + 10 3^Rational[1, 2], 26 + 10 3^Rational[1, 2]}, {
           12 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            10 3^Rational[1, 2]}, {
           12 + 10 3^Rational[1, 2], 27 + 10 3^Rational[1, 2]}, {
           Rational[23, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 10 3^Rational[1, 2], 27 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           12 + Rational[19, 2] 3^Rational[1, 2], Rational[53, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           11 + Rational[19, 2] 3^Rational[1, 2], Rational[53, 2] + 
            10 3^Rational[1, 2]}, {
           11 + 10 3^Rational[1, 2], 26 + 10 3^Rational[1, 2]}, {
           11 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            10 3^Rational[1, 2]}, {
           11 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            10 3^Rational[1, 2]}, {
           10 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            10 3^Rational[1, 2]}, {
           10 + Rational[21, 2] 3^Rational[1, 2], Rational[55, 2] + 
            10 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 10 3^Rational[1, 2], 28 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 10 3^Rational[1, 2], 28 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           9 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            9 3^Rational[1, 2]}, {
           9 + 10 3^Rational[1, 2], 29 + 9 3^Rational[1, 2]}, {
           9 + 10 3^Rational[1, 2], 28 + 9 3^Rational[1, 2]}, {
           Rational[19, 2] + 10 3^Rational[1, 2], 28 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 10 3^Rational[1, 2], 29 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           9 + 10 3^Rational[1, 2], 29 + 9 3^Rational[1, 2]}, {
           Rational[17, 2] + 10 3^Rational[1, 2], 29 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[21, 2] 3^Rational[1, 2], 
            Rational[59, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           8 + Rational[21, 2] 3^Rational[1, 2], Rational[59, 2] + 
            8 3^Rational[1, 2]}, {
           8 + Rational[21, 2] 3^Rational[1, 2], Rational[61, 2] + 
            8 3^Rational[1, 2]}, {
           9 + Rational[21, 2] 3^Rational[1, 2], Rational[61, 2] + 
            8 3^Rational[1, 2]}, {
           9 + 11 3^Rational[1, 2], 31 + 8 3^Rational[1, 2]}, {
           Rational[17, 2] + 11 3^Rational[1, 2], 31 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           8 + 11 3^Rational[1, 2], 32 + 8 3^Rational[1, 2]}, {
           Rational[15, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[63, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 11 3^Rational[1, 2], 33 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 11 3^Rational[1, 2], 32 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           6 + 11 3^Rational[1, 2], 32 + 8 3^Rational[1, 2]}, {
           6 + 11 3^Rational[1, 2], 31 + 8 3^Rational[1, 2]}, {
           6 + Rational[23, 2] 3^Rational[1, 2], Rational[61, 2] + 
            8 3^Rational[1, 2]}, {
           6 + 11 3^Rational[1, 2], 30 + 8 3^Rational[1, 2]}, {
           Rational[11, 2] + 11 3^Rational[1, 2], 30 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[59, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[59, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           6 + Rational[23, 2] 3^Rational[1, 2], Rational[59, 2] + 
            8 3^Rational[1, 2]}, {
           6 + Rational[23, 2] 3^Rational[1, 2], Rational[57, 2] + 
            8 3^Rational[1, 2]}, {
           5 + Rational[23, 2] 3^Rational[1, 2], Rational[57, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[23, 2] 3^Rational[1, 2], 
            Rational[57, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[23, 2] 3^Rational[1, 2], Rational[57, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           4 + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            8 3^Rational[1, 2]}, {
           5 + Rational[23, 2] 3^Rational[1, 2], Rational[55, 2] + 
            8 3^Rational[1, 2]}, {
           5 + Rational[23, 2] 3^Rational[1, 2], Rational[57, 2] + 
            8 3^Rational[1, 2]}, {
           5 + 11 3^Rational[1, 2], 29 + 8 3^Rational[1, 2]}, {
           5 + Rational[21, 2] 3^Rational[1, 2], Rational[59, 2] + 
            8 3^Rational[1, 2]}, {
           5 + 10 3^Rational[1, 2], 29 + 8 3^Rational[1, 2]}, {
           5 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            8 3^Rational[1, 2]}, {
           5 + Rational[19, 2] 3^Rational[1, 2], Rational[59, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[19, 2] 3^Rational[1, 2], Rational[59, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           4 + Rational[19, 2] 3^Rational[1, 2], Rational[59, 2] + 
            8 3^Rational[1, 2]}, {
           4 + Rational[19, 2] 3^Rational[1, 2], Rational[61, 2] + 
            8 3^Rational[1, 2]}, {
           4 + 9 3^Rational[1, 2], 30 + 8 3^Rational[1, 2]}, {
           Rational[7, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           5 + 9 3^Rational[1, 2], 30 + 9 3^Rational[1, 2]}, {
           5 + 9 3^Rational[1, 2], 31 + 9 3^Rational[1, 2]}, {
           Rational[11, 2] + 9 3^Rational[1, 2], 31 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[61, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           6 + 9 3^Rational[1, 2], 30 + 8 3^Rational[1, 2]}, {
           Rational[11, 2] + 9 3^Rational[1, 2], 30 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 9 3^Rational[1, 2], 29 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           6 + 9 3^Rational[1, 2], 29 + 7 3^Rational[1, 2]}, {
           6 + Rational[19, 2] 3^Rational[1, 2], Rational[59, 2] + 
            7 3^Rational[1, 2]}, {
           6 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            7 3^Rational[1, 2]}, {
           5 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            7 3^Rational[1, 2]}, {
           4 + Rational[19, 2] 3^Rational[1, 2], Rational[57, 2] + 
            7 3^Rational[1, 2]}, {
           4 + 10 3^Rational[1, 2], 29 + 7 3^Rational[1, 2]}, {
           Rational[9, 2] + 10 3^Rational[1, 2], 29 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           4 + 10 3^Rational[1, 2], 29 + 8 3^Rational[1, 2]}, {
           3 + 10 3^Rational[1, 2], 29 + 8 3^Rational[1, 2]}, {
           Rational[7, 2] + 10 3^Rational[1, 2], 29 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           3 + 10 3^Rational[1, 2], 29 + 9 3^Rational[1, 2]}, {
           3 + 10 3^Rational[1, 2], 28 + 9 3^Rational[1, 2]}, {
           3 + 10 3^Rational[1, 2], 27 + 9 3^Rational[1, 2]}, {
           2 + 10 3^Rational[1, 2], 27 + 9 3^Rational[1, 2]}, {
           1 + 10 3^Rational[1, 2], 27 + 9 3^Rational[1, 2]}, {
           1 + Rational[21, 2] 3^Rational[1, 2], Rational[53, 2] + 
            9 3^Rational[1, 2]}, {
           1 + 10 3^Rational[1, 2], 26 + 9 3^Rational[1, 2]}, {
           1 + 10 3^Rational[1, 2], 25 + 9 3^Rational[1, 2]}, {
           1 + 10 3^Rational[1, 2], 26 + 9 3^Rational[1, 2]}, {
           1 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            9 3^Rational[1, 2]}, {
           2 + Rational[21, 2] 3^Rational[1, 2], Rational[51, 2] + 
            9 3^Rational[1, 2]}, {
           2 + 10 3^Rational[1, 2], 25 + 9 3^Rational[1, 2]}, {
           2 + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           2 + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[49, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 10 3^Rational[1, 2], 25 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 10 3^Rational[1, 2], 25 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[19, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 10 3^Rational[1, 2], 24 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 10 3^Rational[1, 2], 24 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[47, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           4 + Rational[21, 2] 3^Rational[1, 2], Rational[47, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[21, 2] 3^Rational[1, 2], Rational[47, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 11 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 11 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           4 + 11 3^Rational[1, 2], 24 + 8 3^Rational[1, 2]}, {
           4 + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            8 3^Rational[1, 2]}, {
           4 + 11 3^Rational[1, 2], 24 + 8 3^Rational[1, 2]}, {
           Rational[9, 2] + 11 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[23, 2] 3^Rational[1, 2], Rational[49, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           4 + Rational[23, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           4 + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           4 + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[23, 2] 3^Rational[1, 2], Rational[47, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           2 + 12 3^Rational[1, 2], 23 + 7 3^Rational[1, 2]}, {
           2 + Rational[25, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           2 + 12 3^Rational[1, 2], 23 + 7 3^Rational[1, 2]}, {
           Rational[3, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 12 3^Rational[1, 2], 22 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 12 3^Rational[1, 2], 21 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           2 + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + 13 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           2 + 13 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           2 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           2 + 14 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           2 + Rational[27, 2] 3^Rational[1, 2], Rational[47, 2] + 
            8 3^Rational[1, 2]}, {
           2 + 14 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           3 + 14 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           4 + 14 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           Rational[9, 2] + 14 3^Rational[1, 2], 23 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           5 + 14 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           Rational[9, 2] + 14 3^Rational[1, 2], 23 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[25, 2] 3^Rational[1, 2], Rational[45, 2] + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           4 + Rational[25, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           4 + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           5 + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           5 + 12 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           Rational[11, 2] + 12 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 12 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 12 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 12 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 12 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           6 + 12 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           6 + 12 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           7 + 12 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           8 + 12 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           8 + Rational[25, 2] 3^Rational[1, 2], Rational[41, 2] + 
            8 3^Rational[1, 2]}, {
           8 + 13 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           Rational[17, 2] + 13 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 13 3^Rational[1, 2], 20 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           9 + 13 3^Rational[1, 2], 20 + 9 3^Rational[1, 2]}, {
           Rational[17, 2] + 13 3^Rational[1, 2], 20 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 13 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           8 + 13 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           Rational[15, 2] + 13 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 13 3^Rational[1, 2], 20 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 13 3^Rational[1, 2], 21 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           7 + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           8 + Rational[25, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           8 + Rational[25, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           8 + 12 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           Rational[17, 2] + 12 3^Rational[1, 2], 22 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 12 3^Rational[1, 2], 23 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           8 + 12 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           8 + Rational[25, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           8 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           8 + 14 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           7 + 14 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           7 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           7 + 14 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           7 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           8 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           9 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           9 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           10 + 13 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[25, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 23 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           10 + 14 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {
           10 + 13 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           10 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 13 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           11 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           11 + Rational[27, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           11 + 14 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           10 + 14 3^Rational[1, 2], 22 + 9 3^Rational[1, 2]}, {
           Rational[19, 2] + 14 3^Rational[1, 2], 22 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           9 + 14 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           8 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           8 + 15 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           8 + 15 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           9 + 15 3^Rational[1, 2], 23 + 8 3^Rational[1, 2]}, {
           9 + 15 3^Rational[1, 2], 24 + 8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[49, 2] + 
            8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[47, 2] + 
            8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           8 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           9 + 14 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           9 + 14 3^Rational[1, 2], 22 + 8 3^Rational[1, 2]}, {
           9 + Rational[29, 2] 3^Rational[1, 2], Rational[45, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 14 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           11 + 14 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           Rational[23, 2] + 14 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           12 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           13 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 14 3^Rational[1, 2], 25 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 25 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           13 + 15 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 25 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           13 + Rational[29, 2] 3^Rational[1, 2], Rational[51, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[51, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 14 3^Rational[1, 2], 25 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           13 + 14 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           13 + 14 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           Rational[27, 2] + 14 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           14 + 13 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[51, 2] + 
            7 3^Rational[1, 2]}, {
           14 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           13 + Rational[27, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           13 + 13 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           13 + Rational[27, 2] 3^Rational[1, 2], Rational[51, 2] + 
            7 3^Rational[1, 2]}, {
           13 + 13 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           Rational[27, 2] + 13 3^Rational[1, 2], 25 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           13 + 13 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           12 + 13 3^Rational[1, 2], 25 + 7 3^Rational[1, 2]}, {
           Rational[25, 2] + 13 3^Rational[1, 2], 25 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[27, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 14 3^Rational[1, 2], 24 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           13 + 14 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           13 + 14 3^Rational[1, 2], 23 + 7 3^Rational[1, 2]}, {
           13 + Rational[29, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[47, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 23 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 24 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           13 + 15 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[31, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 24 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[31, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           12 + Rational[31, 2] 3^Rational[1, 2], Rational[49, 2] + 
            7 3^Rational[1, 2]}, {
           12 + Rational[31, 2] 3^Rational[1, 2], Rational[47, 2] + 
            7 3^Rational[1, 2]}, {
           12 + 15 3^Rational[1, 2], 24 + 7 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 24 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 25 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           13 + 15 3^Rational[1, 2], 25 + 6 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 25 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 26 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 15 3^Rational[1, 2], 27 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           14 + 15 3^Rational[1, 2], 27 + 5 3^Rational[1, 2]}, {
           14 + 15 3^Rational[1, 2], 28 + 5 3^Rational[1, 2]}, {
           15 + 15 3^Rational[1, 2], 28 + 5 3^Rational[1, 2]}, {
           16 + 15 3^Rational[1, 2], 28 + 5 3^Rational[1, 2]}, {
           16 + 15 3^Rational[1, 2], 27 + 5 3^Rational[1, 2]}, {
           16 + Rational[29, 2] 3^Rational[1, 2], Rational[55, 2] + 
            5 3^Rational[1, 2]}, {
           15 + Rational[29, 2] 3^Rational[1, 2], Rational[55, 2] + 
            5 3^Rational[1, 2]}, {
           14 + Rational[29, 2] 3^Rational[1, 2], Rational[55, 2] + 
            5 3^Rational[1, 2]}, {
           13 + Rational[29, 2] 3^Rational[1, 2], Rational[55, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[29, 2] 3^Rational[1, 2], 
            Rational[55, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 28 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 27 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 15 3^Rational[1, 2], 27 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           12 + 15 3^Rational[1, 2], 27 + 5 3^Rational[1, 2]}, {
           Rational[25, 2] + 15 3^Rational[1, 2], 27 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           13 + 15 3^Rational[1, 2], 27 + 4 3^Rational[1, 2]}, {
           13 + Rational[31, 2] 3^Rational[1, 2], Rational[53, 2] + 
            4 3^Rational[1, 2]}, {
           12 + Rational[31, 2] 3^Rational[1, 2], Rational[53, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[31, 2] 3^Rational[1, 2], 
            Rational[53, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           12 + Rational[31, 2] 3^Rational[1, 2], Rational[53, 2] + 
            5 3^Rational[1, 2]}, {
           12 + 16 3^Rational[1, 2], 26 + 5 3^Rational[1, 2]}, {
           13 + 16 3^Rational[1, 2], 26 + 5 3^Rational[1, 2]}, {
           13 + 16 3^Rational[1, 2], 25 + 5 3^Rational[1, 2]}, {
           13 + Rational[33, 2] 3^Rational[1, 2], Rational[49, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[33, 2] 3^Rational[1, 2], 
            Rational[49, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 17 3^Rational[1, 2], 25 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 17 3^Rational[1, 2], 25 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 17 3^Rational[1, 2], 24 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 17 3^Rational[1, 2], 24 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           12 + 17 3^Rational[1, 2], 24 + 5 3^Rational[1, 2]}, {
           12 + 17 3^Rational[1, 2], 23 + 5 3^Rational[1, 2]}, {
           12 + Rational[35, 2] 3^Rational[1, 2], Rational[45, 2] + 
            5 3^Rational[1, 2]}, {
           12 + 17 3^Rational[1, 2], 22 + 5 3^Rational[1, 2]}, {
           12 + 17 3^Rational[1, 2], 21 + 5 3^Rational[1, 2]}, {
           12 + Rational[35, 2] 3^Rational[1, 2], Rational[43, 2] + 
            5 3^Rational[1, 2]}, {
           12 + Rational[35, 2] 3^Rational[1, 2], Rational[45, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[35, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 18 3^Rational[1, 2], 23 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 18 3^Rational[1, 2], 23 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           11 + 18 3^Rational[1, 2], 23 + 5 3^Rational[1, 2]}, {
           Rational[23, 2] + 18 3^Rational[1, 2], 23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 18 3^Rational[1, 2], 23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           12 + 18 3^Rational[1, 2], 23 + 4 3^Rational[1, 2]}, {
           12 + Rational[37, 2] 3^Rational[1, 2], Rational[45, 2] + 
            4 3^Rational[1, 2]}, {
           12 + 19 3^Rational[1, 2], 22 + 4 3^Rational[1, 2]}, {
           12 + Rational[39, 2] 3^Rational[1, 2], Rational[45, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           12 + 20 3^Rational[1, 2], 23 + 3 3^Rational[1, 2]}, {
           Rational[25, 2] + 20 3^Rational[1, 2], 23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           13 + 20 3^Rational[1, 2], 23 + 4 3^Rational[1, 2]}, {
           Rational[27, 2] + 20 3^Rational[1, 2], 23 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           14 + 20 3^Rational[1, 2], 23 + 4 3^Rational[1, 2]}, {
           13 + 20 3^Rational[1, 2], 23 + 4 3^Rational[1, 2]}, {
           Rational[27, 2] + 20 3^Rational[1, 2], 23 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           13 + Rational[41, 2] 3^Rational[1, 2], Rational[45, 2] + 
            5 3^Rational[1, 2]}, {
           13 + Rational[41, 2] 3^Rational[1, 2], Rational[43, 2] + 
            5 3^Rational[1, 2]}, {
           13 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           14 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           13 + 20 3^Rational[1, 2], 21 + 4 3^Rational[1, 2]}, {
           Rational[25, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           12 + 20 3^Rational[1, 2], 21 + 5 3^Rational[1, 2]}, {
           12 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 20 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 20 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           11 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 21 3^Rational[1, 2], 21 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           12 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            4 3^Rational[1, 2]}, {
           12 + 21 3^Rational[1, 2], 20 + 4 3^Rational[1, 2]}, {
           Rational[25, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[27, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[35, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 20 3^Rational[1, 2], 17 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           11 + 20 3^Rational[1, 2], 17 + 4 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 17 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[25, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           12 + Rational[39, 2] 3^Rational[1, 2], Rational[33, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 16 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           11 + Rational[41, 2] 3^Rational[1, 2], Rational[33, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + 20 3^Rational[1, 2], 17 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           11 + Rational[41, 2] 3^Rational[1, 2], Rational[33, 2] + 
            3 3^Rational[1, 2]}, {
           11 + 21 3^Rational[1, 2], 16 + 3 3^Rational[1, 2]}, {
           11 + Rational[41, 2] 3^Rational[1, 2], Rational[31, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[29, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           11 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            4 3^Rational[1, 2]}, {
           11 + 20 3^Rational[1, 2], 15 + 4 3^Rational[1, 2]}, {
           10 + 20 3^Rational[1, 2], 15 + 4 3^Rational[1, 2]}, {
           9 + 20 3^Rational[1, 2], 15 + 4 3^Rational[1, 2]}, {
           9 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[29, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 20 3^Rational[1, 2], 14 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 20 3^Rational[1, 2], 15 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[29, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[27, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 20 3^Rational[1, 2], 13 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           8 + 20 3^Rational[1, 2], 13 + 5 3^Rational[1, 2]}, {
           8 + Rational[41, 2] 3^Rational[1, 2], Rational[25, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 21 3^Rational[1, 2], 12 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + 21 3^Rational[1, 2], 13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 21 3^Rational[1, 2], 13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 21 3^Rational[1, 2], 12 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           10 + 21 3^Rational[1, 2], 12 + 5 3^Rational[1, 2]}, {
           10 + Rational[43, 2] 3^Rational[1, 2], Rational[23, 2] + 
            5 3^Rational[1, 2]}, {
           10 + 22 3^Rational[1, 2], 11 + 5 3^Rational[1, 2]}, {
           11 + 22 3^Rational[1, 2], 11 + 5 3^Rational[1, 2]}, {
           Rational[21, 2] + 22 3^Rational[1, 2], 11 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           11 + 22 3^Rational[1, 2], 11 + 5 3^Rational[1, 2]}, {
           10 + 22 3^Rational[1, 2], 11 + 5 3^Rational[1, 2]}, {
           11 + 22 3^Rational[1, 2], 11 + 5 3^Rational[1, 2]}, {
           Rational[21, 2] + 22 3^Rational[1, 2], 11 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           11 + 22 3^Rational[1, 2], 11 + 4 3^Rational[1, 2]}, {
           11 + Rational[45, 2] 3^Rational[1, 2], Rational[21, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           11 + Rational[45, 2] 3^Rational[1, 2], Rational[21, 2] + 
            4 3^Rational[1, 2]}, {
           11 + 23 3^Rational[1, 2], 10 + 4 3^Rational[1, 2]}, {
           11 + Rational[45, 2] 3^Rational[1, 2], Rational[21, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[23, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 22 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 22 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 22 3^Rational[1, 2], 9 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 22 3^Rational[1, 2], 9 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           10 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           9 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            4 3^Rational[1, 2]}, {
           9 + 22 3^Rational[1, 2], 10 + 4 3^Rational[1, 2]}, {
           9 + 22 3^Rational[1, 2], 9 + 4 3^Rational[1, 2]}, {
           9 + Rational[45, 2] 3^Rational[1, 2], Rational[17, 2] + 
            4 3^Rational[1, 2]}, {
           9 + 23 3^Rational[1, 2], 9 + 4 3^Rational[1, 2]}, {
           9 + 23 3^Rational[1, 2], 10 + 4 3^Rational[1, 2]}, {
           8 + 23 3^Rational[1, 2], 10 + 4 3^Rational[1, 2]}, {
           9 + 23 3^Rational[1, 2], 10 + 4 3^Rational[1, 2]}, {
           9 + 23 3^Rational[1, 2], 9 + 4 3^Rational[1, 2]}, {
           8 + 23 3^Rational[1, 2], 9 + 4 3^Rational[1, 2]}, {
           Rational[17, 2] + 23 3^Rational[1, 2], 9 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[17, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 23 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[17, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[21, 2] + 23 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 23 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[47, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[47, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[47, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + 23 3^Rational[1, 2], 10 + 
            Rational[7, 2] 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           9 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            3 3^Rational[1, 2]}, {
           9 + Rational[45, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           9 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            3 3^Rational[1, 2]}, {
           9 + 22 3^Rational[1, 2], 10 + 3 3^Rational[1, 2]}, {
           9 + Rational[43, 2] 3^Rational[1, 2], Rational[19, 2] + 
            3 3^Rational[1, 2]}, {
           9 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[19, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[5, 2] 3^Rational[1, 2]}, {
           9 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           8 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           7 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[19, 2] + 
            3 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           6 + 21 3^Rational[1, 2], 11 + 3 3^Rational[1, 2]}, {
           7 + 21 3^Rational[1, 2], 11 + 3 3^Rational[1, 2]}, {
           7 + Rational[41, 2] 3^Rational[1, 2], Rational[21, 2] + 
            3 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[21, 2] + Rational[7, 2] 3^Rational[1, 2]}, {
           7 + Rational[41, 2] 3^Rational[1, 2], Rational[21, 2] + 
            4 3^Rational[1, 2]}, {
           7 + Rational[41, 2] 3^Rational[1, 2], Rational[19, 2] + 
            4 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 21 3^Rational[1, 2], 9 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[19, 2] + 
            5 3^Rational[1, 2]}, {
           6 + 22 3^Rational[1, 2], 9 + 5 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[17, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[17, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 22 3^Rational[1, 2], 8 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[17, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           6 + Rational[43, 2] 3^Rational[1, 2], Rational[17, 2] + 
            4 3^Rational[1, 2]}, {
           6 + 22 3^Rational[1, 2], 9 + 4 3^Rational[1, 2]}, {
           Rational[11, 2] + 22 3^Rational[1, 2], 9 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 22 3^Rational[1, 2], 9 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 22 3^Rational[1, 2], 9 + 
            Rational[9, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[19, 2] + Rational[9, 2] 3^Rational[1, 2]}, {
           7 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            5 3^Rational[1, 2]}, {
           7 + 23 3^Rational[1, 2], 9 + 5 3^Rational[1, 2]}, {
           7 + Rational[45, 2] 3^Rational[1, 2], Rational[19, 2] + 
            5 3^Rational[1, 2]}, {
           7 + 23 3^Rational[1, 2], 10 + 5 3^Rational[1, 2]}, {
           Rational[15, 2] + 23 3^Rational[1, 2], 10 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 23 3^Rational[1, 2], 11 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[23, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + 23 3^Rational[1, 2], 12 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[15, 2] + Rational[47, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           7 + Rational[47, 2] 3^Rational[1, 2], Rational[25, 2] + 
            5 3^Rational[1, 2]}, {
           7 + 23 3^Rational[1, 2], 13 + 5 3^Rational[1, 2]}, {
           7 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            5 3^Rational[1, 2]}, {
           7 + 23 3^Rational[1, 2], 13 + 5 3^Rational[1, 2]}, {
           7 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           6 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 22 3^Rational[1, 2], 13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[27, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[25, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           5 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            6 3^Rational[1, 2]}, {
           4 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            6 3^Rational[1, 2]}, {
           3 + Rational[45, 2] 3^Rational[1, 2], Rational[25, 2] + 
            6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 12 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 11 + 6 3^Rational[1, 2]}, {
           2 + 22 3^Rational[1, 2], 11 + 6 3^Rational[1, 2]}, {
           Rational[5, 2] + 22 3^Rational[1, 2], 11 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           2 + 22 3^Rational[1, 2], 11 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 11 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 12 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 11 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 12 + 6 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 13 + 6 3^Rational[1, 2]}, {
           Rational[7, 2] + 22 3^Rational[1, 2], 13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           3 + 22 3^Rational[1, 2], 13 + 6 3^Rational[1, 2]}, {
           4 + 22 3^Rational[1, 2], 13 + 6 3^Rational[1, 2]}, {
           4 + Rational[43, 2] 3^Rational[1, 2], Rational[27, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[27, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 22 3^Rational[1, 2], 13 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[27, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           4 + Rational[43, 2] 3^Rational[1, 2], Rational[27, 2] + 
            5 3^Rational[1, 2]}, {
           4 + 21 3^Rational[1, 2], 14 + 5 3^Rational[1, 2]}, {
           4 + Rational[43, 2] 3^Rational[1, 2], Rational[29, 2] + 
            5 3^Rational[1, 2]}, {
           4 + 21 3^Rational[1, 2], 14 + 5 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[27, 2] + 
            5 3^Rational[1, 2]}, {
           5 + Rational[41, 2] 3^Rational[1, 2], Rational[27, 2] + 
            5 3^Rational[1, 2]}, {
           5 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            5 3^Rational[1, 2]}, {
           5 + 20 3^Rational[1, 2], 14 + 5 3^Rational[1, 2]}, {
           5 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            5 3^Rational[1, 2]}, {
           5 + 21 3^Rational[1, 2], 15 + 5 3^Rational[1, 2]}, {
           5 + 21 3^Rational[1, 2], 16 + 5 3^Rational[1, 2]}, {
           5 + Rational[41, 2] 3^Rational[1, 2], Rational[33, 2] + 
            5 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 20 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + 20 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[13, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 21 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 21 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[31, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 21 3^Rational[1, 2], 15 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           5 + 21 3^Rational[1, 2], 15 + 6 3^Rational[1, 2]}, {
           Rational[9, 2] + 21 3^Rational[1, 2], 15 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 21 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 21 3^Rational[1, 2], 16 + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           4 + 21 3^Rational[1, 2], 16 + 6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[31, 2] + 
            6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            6 3^Rational[1, 2]}, {
           4 + 21 3^Rational[1, 2], 15 + 6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            Rational[11, 2] 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            6 3^Rational[1, 2]}, {
           4 + 21 3^Rational[1, 2], 15 + 6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[31, 2] + 
            6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[29, 2] + 
            6 3^Rational[1, 2]}, {
           4 + Rational[41, 2] 3^Rational[1, 2], Rational[31, 2] + 
            6 3^Rational[1, 2]}, {
           5 + Rational[41, 2] 3^Rational[1, 2], Rational[31, 2] + 
            6 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[41, 2] 3^Rational[1, 2], 
            Rational[31, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 20 3^Rational[1, 2], 16 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + Rational[39, 2] 3^Rational[1, 2], 
            Rational[33, 2] + Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[11, 2] + 20 3^Rational[1, 2], 17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           5 + 20 3^Rational[1, 2], 17 + 6 3^Rational[1, 2]}, {
           Rational[9, 2] + 20 3^Rational[1, 2], 17 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 20 3^Rational[1, 2], 18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + Rational[39, 2] 3^Rational[1, 2], Rational[35, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[9, 2] + 20 3^Rational[1, 2], 18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 20 3^Rational[1, 2], 18 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 20 3^Rational[1, 2], 19 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[39, 2] 3^Rational[1, 2], Rational[37, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + Rational[39, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[7, 2] + 19 3^Rational[1, 2], 20 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 19 3^Rational[1, 2], 20 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[39, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + 20 3^Rational[1, 2], 21 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[43, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           3 + Rational[41, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           3 + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            7 3^Rational[1, 2]}, {
           Rational[5, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + 21 3^Rational[1, 2], 19 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[43, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[43, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           21 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           Rational[1, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           1 + 21 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           Rational[1, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[41, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           21 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           Rational[-1, 2] + 21 3^Rational[1, 2], 20 + 
            Rational[13, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[43, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[13, 2] 3^Rational[1, 2]}, {-1 + 
            Rational[43, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {-1 + 22 3^Rational[1, 2], 19 + 
            7 3^Rational[1, 2]}, {
           Rational[-1, 2] + 22 3^Rational[1, 2], 19 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[45, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[45, 2] 3^Rational[1, 2], Rational[37, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           1 + Rational[45, 2] 3^Rational[1, 2], Rational[37, 2] + 
            8 3^Rational[1, 2]}, {
           1 + Rational[45, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[45, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           1 + Rational[45, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[45, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + 23 3^Rational[1, 2], 19 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           1 + 23 3^Rational[1, 2], 19 + 8 3^Rational[1, 2]}, {
           Rational[3, 2] + 23 3^Rational[1, 2], 19 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[3, 2] + Rational[47, 2] 3^Rational[1, 2], Rational[39, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           2 + Rational[47, 2] 3^Rational[1, 2], Rational[39, 2] + 
            7 3^Rational[1, 2]}, {
           2 + 24 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           1 + 24 3^Rational[1, 2], 20 + 7 3^Rational[1, 2]}, {
           1 + 24 3^Rational[1, 2], 21 + 7 3^Rational[1, 2]}, {
           Rational[1, 2] + 24 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[49, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[49, 2] 3^Rational[1, 2], Rational[41, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[49, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           1 + Rational[49, 2] 3^Rational[1, 2], Rational[41, 2] + 
            8 3^Rational[1, 2]}, {
           1 + Rational[49, 2] 3^Rational[1, 2], Rational[43, 2] + 
            8 3^Rational[1, 2]}, {
           1 + 25 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           25 3^Rational[1, 2], 21 + 8 3^Rational[1, 2]}, {
           25 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           1 + 25 3^Rational[1, 2], 20 + 8 3^Rational[1, 2]}, {
           Rational[1, 2] + 25 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + Rational[51, 2] 3^Rational[1, 2], Rational[41, 2] + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[1, 2] + 26 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + 26 3^Rational[1, 2], 21 + 
            Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[51, 2] 3^Rational[1, 2], 
            Rational[41, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + 25 3^Rational[1, 2], 20 + 
            Rational[15, 2] 3^Rational[1, 2]}, {-1 + 25 3^Rational[1, 2], 20 + 
            8 3^Rational[1, 2]}, {-1 + Rational[51, 2] 3^Rational[1, 2], 
            Rational[39, 2] + 8 3^Rational[1, 2]}, {-1 + 26 3^Rational[1, 2], 
            19 + 8 3^Rational[1, 2]}, {-1 + Rational[53, 2] 3^Rational[1, 2], 
            Rational[39, 2] + 8 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[37, 2] + Rational[15, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[15, 2] 3^Rational[1, 2]}, {-2 + 
            Rational[53, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {-2 + 26 3^Rational[1, 2], 19 + 
            8 3^Rational[1, 2]}, {
           Rational[-5, 2] + 26 3^Rational[1, 2], 19 + 
            Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[-5, 2] + Rational[51, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {-2 + 
            Rational[51, 2] 3^Rational[1, 2], Rational[39, 2] + 
            8 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[51, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[17, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + 25 3^Rational[1, 2], 20 + 
            Rational[17, 2] 3^Rational[1, 2]}, {-1 + 25 3^Rational[1, 2], 20 + 
            9 3^Rational[1, 2]}, {-1 + Rational[49, 2] 3^Rational[1, 2], 
            Rational[39, 2] + 9 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[49, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2]}, {-2 + 
            Rational[49, 2] 3^Rational[1, 2], Rational[39, 2] + 
            10 3^Rational[1, 2]}, {-2 + 25 3^Rational[1, 2], 20 + 
            10 3^Rational[1, 2]}, {
           Rational[-3, 2] + 25 3^Rational[1, 2], 20 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[51, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2]}, {-2 + 
            Rational[51, 2] 3^Rational[1, 2], Rational[39, 2] + 
            10 3^Rational[1, 2]}, {-2 + 26 3^Rational[1, 2], 20 + 
            10 3^Rational[1, 2]}, {-2 + 26 3^Rational[1, 2], 19 + 
            10 3^Rational[1, 2]}, {
           Rational[-3, 2] + 26 3^Rational[1, 2], 19 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + 26 3^Rational[1, 2], 20 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[51, 2] 3^Rational[1, 2], 
            Rational[39, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + 26 3^Rational[1, 2], 20 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-5, 2] + 26 3^Rational[1, 2], 20 + 
            Rational[19, 2] 3^Rational[1, 2]}, {-2 + 26 3^Rational[1, 2], 20 + 
            9 3^Rational[1, 2]}, {
           Rational[-3, 2] + 26 3^Rational[1, 2], 20 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-3, 2] + 26 3^Rational[1, 2], 21 + 
            Rational[19, 2] 3^Rational[1, 2]}, {-1 + 26 3^Rational[1, 2], 21 + 
            9 3^Rational[1, 2]}, {-1 + Rational[53, 2] 3^Rational[1, 2], 
            Rational[43, 2] + 9 3^Rational[1, 2]}, {
           Rational[-3, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[19, 2] 3^Rational[1, 2]}, {-1 + 
            Rational[53, 2] 3^Rational[1, 2], Rational[43, 2] + 
            9 3^Rational[1, 2]}, {-1 + 27 3^Rational[1, 2], 22 + 
            9 3^Rational[1, 2]}, {
           Rational[-1, 2] + 27 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + 27 3^Rational[1, 2], 23 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + 27 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           27 3^Rational[1, 2], 22 + 10 3^Rational[1, 2]}, {
           Rational[-1, 2] + 27 3^Rational[1, 2], 22 + 
            Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {-1 + 
            Rational[53, 2] 3^Rational[1, 2], Rational[45, 2] + 
            9 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[45, 2] + Rational[19, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {
           26 3^Rational[1, 2], 23 + 10 3^Rational[1, 2]}, {-1 + 
            26 3^Rational[1, 2], 23 + 10 3^Rational[1, 2]}, {-1 + 
            Rational[51, 2] 3^Rational[1, 2], Rational[45, 2] + 
            10 3^Rational[1, 2]}, {-1 + Rational[51, 2] 3^Rational[1, 2], 
            Rational[43, 2] + 10 3^Rational[1, 2]}, {-1 + 26 3^Rational[1, 2],
             21 + 10 3^Rational[1, 2]}, {-1 + 
            Rational[53, 2] 3^Rational[1, 2], Rational[43, 2] + 
            10 3^Rational[1, 2]}, {-1 + 26 3^Rational[1, 2], 22 + 
            10 3^Rational[1, 2]}, {
           Rational[-1, 2] + 26 3^Rational[1, 2], 22 + 
            Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[-1, 2] + Rational[53, 2] 3^Rational[1, 2], 
            Rational[43, 2] + Rational[21, 2] 3^Rational[1, 2]}, {
           Rational[53, 2] 3^Rational[1, 2], Rational[43, 2] + 
            11 3^Rational[1, 2]}, {
           Rational[53, 2] 3^Rational[1, 2], Rational[41, 2] + 
            11 3^Rational[1, 2]}, {-1 + Rational[53, 2] 3^Rational[1, 2], 
            Rational[41, 2] + 11 3^Rational[1, 2]}, {
           Rational[53, 2] 3^Rational[1, 2], Rational[41, 2] + 
      