(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1135774,      24984]
NotebookOptionsPosition[   1030240,      22861]
NotebookOutlinePosition[   1124834,      24795]
CellTagsIndexPosition[   1124275,      24772]
WindowTitle->Arrays, or Lists of Lists: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Arrays, or Lists of Lists", "SectionInline",ExpressionUUID->
   "4c649283-2ffa-47a5-b4a4-0b79e2306804"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 12}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:57",ExpressionUUID->"71388978-d51d-493d-b5c0-56a82429110d"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ve seen how ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " can be used to make lists. Now let\[CloseCurlyQuote]s see how ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " can be used to create higher-dimensional arrays of values."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"6e51fc33-f2fb-4a21-b6e5-4a496c287607"],

Cell["Make a list of 4 copies of x:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cfdf6939-8264-42e5-b03d-88e69901ef30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", "4"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"0aece11f-d66d-4e79-9e89-566c31a8da1a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"983458ff-8a5b-47e3-8c95-a6fa1d8f1181"]
}, Open  ]],

Cell["\<\
Make a list of 4 copies of a list that contains 5 copies of x:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad6526f5-ce8a-4978-b217-7f79f158ca9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", "4", ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"a25a275a-6bc9-4024-b08c-ff703f6a241b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"03c7c8c1-4ebf-42e9-a3a3-21f5888fd0eb"]
}, Open  ]],

Cell[TextData[{
 "Use ",
 ButtonBox["Grid",
  BaseStyle->"Link"],
 " to display the result in a grid:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"e261fb73-8167-4ca1-a549-1ff18b53b5e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"x", ",", "4", ",", "5"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"91e26ae6-2fae-4218-aa5a-7d79d4e0e5a7"],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"d17fdbfd-a2d1-4a74-89cc-62d15314c7f6"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " with two variables to make a 2D array. The first variable corresponds to \
the row; the second to the column."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eaed9e7d-46c2-4a67-a5c9-51aae4c02c0a"],

Cell["Make an array of colors: red going down, blue going across:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"341e541a-3296-4c2b-b4d3-e2f97a4054fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"r", ",", "0", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "0", ",", "1", ",", ".2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "0", ",", "1", ",", ".2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"11b7cec2-5d14-43e6-91e2-17f2e17aa996"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 0.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 0.2], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 0.4], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0., 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 0.8], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 0.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.2, 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 0.2], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.13333333333333336`],
         
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.2, 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 0.4], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.2, 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.2, 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 0.8], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.2, 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.2, 0, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.13333333333333336`, 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.2, 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.2, 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.2, 0, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 0.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.4, 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 0.2], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.4, 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 0.4], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.4, 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.4, 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 0.8], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.4, 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.4, 0, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.2666666666666667, 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4, 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.4, 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4, 0, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 0.], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 0.2], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 0.4], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 0.8], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.6000000000000001, 0, 1.], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.4000000000000001, 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6000000000000001, 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.6000000000000001, 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6000000000000001, 0, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 0.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.8, 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 0.2], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.8, 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 0.4], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.8, 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.8, 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 0.8], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.8, 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.8, 0, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.5333333333333334, 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8, 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.8, 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8, 0, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 0.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 0.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1., 0, 0.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 0.],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 0.2], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.13333333333333336`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 0.2]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1., 0, 0.2]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 0.2],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 0.4], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.2666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 0.4]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1., 0, 0.4]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 0.4],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 0.6000000000000001], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.4000000000000001],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 0.6000000000000001]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0, 0.6000000000000001]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 0.6000000000000001],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 0.8], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.5333333333333334],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 0.8]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1., 0, 0.8]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 0.8],
      Editable->False,
      Selectable->False], 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666667, 0., 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1., 0, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0, 1.],
      Editable->False,
      Selectable->False]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"84de828e-a9ed-4f44-bee3-d7a262cbb025"]
}, Open  ]],

Cell["Show every array element as its row number:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"79aa09c7-5e9c-4ba2-b452-3d935bbff19b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"i", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"00cea671-ec93-477c-ad0b-c244bfe7f08d"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1", "1", "1"},
    {"2", "2", "2", "2", "2"},
    {"3", "3", "3", "3", "3"},
    {"4", "4", "4", "4", "4"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[5]=",ExpressionUUID->"110f9c42-4d7f-4884-8a47-b07301a75202"]
}, Open  ]],

Cell["Show every array element as its column number:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:58",ExpressionUUID->"fd12511b-1347-4842-a892-ce5d63249a09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"j", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"64009558-7ca4-4a31-967e-e4cb4b43deab"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5"},
    {"1", "2", "3", "4", "5"},
    {"1", "2", "3", "4", "5"},
    {"1", "2", "3", "4", "5"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"f7f5b33d-c961-4ec5-8ce7-9de524c5c8b6"]
}, Open  ]],

Cell["\<\
Generate an array in which each element is the sum of its row and column \
number:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"be20f3d8-d208-4fb1-b493-749000efab43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"e29ebf52-4aef-46b7-aa86-16bcf4b7a700"],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", "3", "4", "5", "6"},
    {"3", "4", "5", "6", "7"},
    {"4", "5", "6", "7", "8"},
    {"5", "6", "7", "8", "9"},
    {"6", "7", "8", "9", "10"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"5adbe0a0-cd83-47bc-90fd-f02ebe8937f6"]
}, Open  ]],

Cell["Generate a multiplication table:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"9d11bcfd-e4d6-483a-a533-1e53022b6b56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "*", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"2aaa9865-c2a6-4afe-9ca9-8bb1617f44b3"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5"},
    {"2", "4", "6", "8", "10"},
    {"3", "6", "9", "12", "15"},
    {"4", "8", "12", "16", "20"},
    {"5", "10", "15", "20", "25"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"8f76dcde-011f-4bb9-a893-8e4a9cdbf7e4"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 " lets you visualize values in an array. Larger values are shown darker."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"768d94cd-437a-42e8-bd04-1e72b882b82d"],

Cell["Visualize a multiplication table:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f4805a48-7c0e-408c-a167-fa82041ed893"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "*", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"fad96b81-427d-4f0c-8fe2-5fec20284ec4"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{20, 15, 10, 5, 0}, {21, 17, 13, 9, 5}, {22, 19, 16, 13, 10}, {
   23, 21, 19, 17, 15}, {24, 23, 22, 21, 20}}, {{0, 0}, {5, 5}}, {0, 25}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{125.18229166666698`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"1487ba52-ba17-43ab-87a7-c4011262bd8d"]
}, Open  ]],

Cell["Generate and plot an array of random values:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"341dd46e-7f17-4dd1-8da7-39759fd2fc25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomInteger", "[", "10", "]"}], ",", "30", ",", "30"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"b7512b5e-a688-4720-9691-0795e137385a"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJwtkslNwDAQRWffikCiJUqgAfq/8Yw4RElsz/ffPr9/vr5NRD7+n7or7ZQr
WS3f29YpH5+9Ok1Wd+css8ZFbMLcVURvzafyxDvVq1ZNVjJS76S9pja0x9Z6
25SVUNtYdi/ZuZYs8fMVYGZrXdylpW1HwqxDjDVLk2QwZPlL82I88+ytQN2O
eeW8Q/FOSxHR8R7x1G2pRYc3InfcWlBc5Vr8ZSU45bfZwNaNOpxHFYZ1NY+L
SzyjYHL4FJHO6ZkpwxtbyDmWLTbVGVozrRhw0/DBjQmBj3sc92GgSrfq5jgb
V3F/oykvgElleyPDIF3uB4qKeUzO+0LhejF52g32inRl92BJvSvtFgTSKdGQ
YlMbfJuB//7Zf2MFtTEMvjNerqZjsRhAXh3ITkEh3HEH3COVnseoIsHLp4Zg
Z1e0IxTjsvCY7lgqmiY8IjqmBuriuniuTjGUaoUhZamXDB4GKCODSkJM1Kg1
MUI4XJSsMfBWQHeqQRrYj29XEE96CChpGQGyX/Rr6QYKG0ctkD4ANLWEhCq5
LlXha+hEcNa5YJxQcJI6GRfRLfyZ26NwY0dzhm4FVjDrF93rz87kQHDRlh2s
Y7socj+OQvGUBhuZXKFocrtl39d50LxTg+Yv6O0TuQ==
   "], {{0, 0}, {30, 30}}, {0, 
   10}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{124.8515625, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[10]=",ExpressionUUID->"6e241da1-9bd8-41b7-b771-4e5d52c91f05"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 " also lets you put colors as values:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:59",ExpressionUUID->"be7a37ff-4bd7-45f7-bb0e-7d6a2570ffdc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomColor", "[", "\[ThinSpace]", "]"}], ",", "30", ",", "30"}],
    "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"51e6f3ba-f76a-4b7f-b6fb-685ae4434f5d"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJwsmnk01O//hidJKkmlUklEkjaVCuGWJJWkUgmVkCjZi4QkSfIpolJRQkiU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   "], {{0, 0}, {30, 30}}, {0, 
   1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{124.703125, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"961f8f7c-86c1-42d5-8308-bdb6cb33d94d"]
}, Open  ]],

Cell[TextData[{
 "Images are ultimately arrays of pixels. Color images make each pixel have \
red, green and blue values. Black-and-white images have pixels with values 0 \
(black) or 1 (white). You can get the actual pixel values using ",
 ButtonBox["ImageData",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"0fa9b983-e70e-4320-bd30-a1eebd55284d"],

Cell["Find the value of pixels in an image of a \[OpenCurlyDoubleQuote]W\
\[CloseCurlyDoubleQuote]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"b51cd31b-360c-417b-ad4c-b4afdbc8131b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImageData", "[", 
  RowBox[{"Binarize", "[", " ", 
   RowBox[{"Rasterize", "[", "\"\<W\>\"", "]"}], " ", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"2a954c1c-2e84-4052-82d5-324999f8990e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"751d891b-2547-4caa-8444-d8cc2ee2f01b"]
}, Open  ]],

Cell[TextData[{
 "Use ",
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 " to visualize the array of values:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"471efa59-6369-441a-b0c5-0130f92abd7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"ImageData", "[", 
   RowBox[{"Binarize", "[", " ", 
    RowBox[{"Rasterize", "[", "\"\<W\>\"", "]"}], " ", "]"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"92d1b21a-f028-4724-b1f5-08c34ee2c09f"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
   0}, {0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0}, {
   0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0,
    1, 0, 0, 1, 1, 0, 0, 1, 0}, {0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0}, {1, 1, 1, 
   0, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, {{0, 0}, {11, 
   12}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{105.60105026901897`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"d7f5dd2f-d015-453f-8720-7007e94e8406"]
}, Open  ]],

Cell[TextData[{
 "The image is of very low resolution, because that\[CloseCurlyQuote]s how ",
 ButtonBox["Rasterize",
  BaseStyle->"Link"],
 " made it in this case. It\[CloseCurlyQuote]s also white-on-black instead of \
black-on-white. That\[CloseCurlyQuote]s because in an image 0 is black and 1 \
is white (like in ",
 ButtonBox["RGBColor",
  BaseStyle->"Link"],
 "), while ",
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 "\[CloseCurlyQuote]s default is to make larger values darker."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:8"},ExpressionUUID->"8cd811ad-4707-4f31-9340-d072373015ea"],

Cell[TextData[{
 "You can do arithmetic with arrays, just like lists. That means it\
\[CloseCurlyQuote]s easy to swap ",
 Cell[BoxData[
 "0"], "InlineCodeText",ExpressionUUID->
  "d25d2bd0-90c2-43bb-a1ac-c5ab2708ca61"],
 " and ",
 Cell[BoxData[
 "1"], "InlineCodeText",ExpressionUUID->
  "5a622052-42c6-4a4e-ab51-c2a73bbdace0"],
 " in this array: Just subtract everything from ",
 Cell[BoxData[
 "1"], "InlineCodeText",ExpressionUUID->
  "a997849c-afdf-4702-8578-338b38552c92"],
 ", so every ",
 Cell[BoxData[
 "0"], "InlineCodeText",ExpressionUUID->
  "17d1b11e-533b-497c-ae29-55da3d5c728a"],
 " becomes ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "\[Minus]", "0"}], "=", "1"}]], "InlineCodeText",
  ExpressionUUID->"d8d7c793-e141-4e84-b254-dbab5e9eb0a1"],
 ", and every ",
 Cell[BoxData[
 "1"], "InlineCodeText",ExpressionUUID->
  "6b7f1022-593b-4656-b149-89fa5316a36a"],
 " becomes ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "\[Minus]", "1"}], "=", "0"}]], "InlineCodeText",
  ExpressionUUID->"20865fdb-3b8e-4a15-a7dc-f741b0f1a689"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:60",ExpressionUUID->"cd84891a-8415-4ce2-b055-3dc7e1a6dbc7"],

Cell["\<\
Find pixel values, then do arithmetic to swap 0 and 1 in the array:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c3ee8300-c1d6-415b-ad16-d706cecc0360"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"ImageData", "[", 
   RowBox[{"Binarize", "[", " ", 
    RowBox[{"Rasterize", "[", "\"\<W\>\"", "]"}], " ", "]"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"a5279e16-31c3-4ae5-91cc-d8c46db89a15"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1",
      ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"0426df92-f6eb-4009-8504-f36ac7722f43"]
}, Open  ]],

Cell["The result is black-on-white:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"858ede2d-5a7f-47b3-b0c9-4872eec33b66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"1", "-", 
   RowBox[{"ImageData", "[", 
    RowBox[{"Binarize", "[", " ", 
     RowBox[{"Rasterize", "[", "\"\<W\>\"", "]"}], " ", "]"}], "]"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"74dbc2aa-a38e-47b6-b18e-46f7df971594"],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 
   1}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1}, {
   1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1}, {1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1}, {1, 1,
    0, 1, 1, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1}, {0, 0, 0, 
   1, 0, 0, 0, 1, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}, {{0, 0}, {11, 
   12}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{101.08542526901897`, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
    Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"4e5f2560-8224-40d9-a0bd-54f85d4a798b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ea547afe-7063-4693-a39e-61cbd4be8d0b"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["x", "CodeVariableLrg"], ",", "4", ",", "5"}], "]"}], " ", 
    Cell["make a 2D array of values ", "VocabularyText",ExpressionUUID->
     "9ec67110-99d3-4c34-859c-57dfd0c0cc3f"]},
   {
    RowBox[{
     ButtonBox["Grid",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["array", "CodeVariableLrg"], "]"}], " ", Cell[
    "lay out values from an array in a grid ", "VocabularyText",
     ExpressionUUID->"3e1b9904-83d3-44ef-ac71-062c7dea213d"]},
   {
    RowBox[{
     ButtonBox["ArrayPlot",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["array", "CodeVariableLrg"], "]"}], " ", Cell[
    "visualize the values in an array ", "VocabularyText",ExpressionUUID->
     "421251f7-f815-4806-a013-14d2b6a6d25e"]},
   {
    RowBox[{
     ButtonBox["ImageData",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["image", "CodeVariableLrg"], "]"}], " ", Cell[
    "get the array of pixel values from an image ", "VocabularyText",
     ExpressionUUID->"dc3965f4-ba29-4f3f-b5e4-8f7b4ba54fb2"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f8b37685-92a7-496e-b87c-0d8ac8d39532"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"7ef4f211-4f84-441d-8ba2-dc4cd794ef63"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"9 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 2 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"85c236eb-b90f-4e76-8460-e37c6042d181"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 12\[Times]12 multiplication table.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9d10d366-cec2-4a77-a094-d15571f74cb0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
          {"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24"},
          {"3", "6", "9", "12", "15", "18", "21", "24", "27", "30", "33", 
           "36"},
          {"4", "8", "12", "16", "20", "24", "28", "32", "36", "40", "44", 
           "48"},
          {"5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", 
           "60"},
          {"6", "12", "18", "24", "30", "36", "42", "48", "54", "60", "66", 
           "72"},
          {"7", "14", "21", "28", "35", "42", "49", "56", "63", "70", "77", 
           "84"},
          {"8", "16", "24", "32", "40", "48", "56", "64", "72", "80", "88", 
           "96"},
          {"9", "18", "27", "36", "45", "54", "63", "72", "81", "90", "99", 
           "108"},
          {"10", "20", "30", "40", "50", "60", "70", "80", "90", "100", "110",
            "120"},
          {"11", "22", "33", "44", "55", "66", "77", "88", "99", "110", "121",
            "132"},
          {"12", "24", "36", "48", "60", "72", "84", "96", "108", "120", 
           "132", "144"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "8a685062-9177-40b0-a709-53357f6a83f0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}, {
            "2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", 
             "24"}, {"3", "6", "9", "12", "15", "18", "21", "24", "27", "30", 
             "33", "36"}, {
            "4", "8", "12", "16", "20", "24", "28", "32", "36", "40", "44", 
             "48"}, {
            "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", 
             "60"}, {"6", "12", "18", "24", "30", "36", "42", "48", "54", 
             "60", "66", "72"}, {
            "7", "14", "21", "28", "35", "42", "49", "56", "63", "70", "77", 
             "84"}, {"8", "16", "24", "32", "40", "48", "56", "64", "72", 
             "80", "88", "96"}, {
            "9", "18", "27", "36", "45", "54", "63", "72", "81", "90", "99", 
             "108"}, {
            "10", "20", "30", "40", "50", "60", "70", "80", "90", "100", 
             "110", "120"}, {
            "11", "22", "33", "44", "55", "66", "77", "88", "99", "110", 
             "121", "132"}, {
            "12", "24", "36", "48", "60", "72", "84", "96", "108", "120", 
             "132", "144"}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f121ecf6-76dc-4a63-9da2-c0d7fcab2037"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 5\[Times]5 multiplication table for Roman numerals.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2c2517a7-edb2-4d57-9cc2-300e077b70d5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"I\"\>", "\<\"II\"\>", "\<\"III\"\>", "\<\"IV\"\>", \
"\<\"V\"\>"},
          {"\<\"II\"\>", "\<\"IV\"\>", "\<\"VI\"\>", "\<\"VIII\"\>", "\<\"X\"\
\>"},
          {"\<\"III\"\>", "\<\"VI\"\>", "\<\"IX\"\>", "\<\"XII\"\>", \
"\<\"XV\"\>"},
          {"\<\"IV\"\>", "\<\"VIII\"\>", "\<\"XII\"\>", "\<\"XVI\"\>", \
"\<\"XX\"\>"},
          {"\<\"V\"\>", "\<\"X\"\>", "\<\"XV\"\>", "\<\"XX\"\>", "\<\"XXV\"\>"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "0aed69d2-36b6-4de6-a0d7-df20306165b6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"\"I\"", "\"II\"", "\"III\"", "\"IV\"", "\"V\""}, {
            "\"II\"", "\"IV\"", "\"VI\"", "\"VIII\"", "\"X\""}, {
            "\"III\"", "\"VI\"", "\"IX\"", "\"XII\"", "\"XV\""}, {
            "\"IV\"", "\"VIII\"", "\"XII\"", "\"XVI\"", "\"XX\""}, {
            "\"V\"", "\"X\"", "\"XV\"", "\"XX\"", "\"XXV\""}}, AutoDelete -> 
           False, GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"144fd045-e389-48b1-b12e-c7c7212b1e2d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10 grid of random colors.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"30ea5f96-02a2-475c-9669-e9d18a0ee2cf"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.2686806675812221, 0.12895891413438165`, 
                  0.48612608778450617`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1791204450541481, 0.0859726094229211, 0.32408405852300415`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.2686806675812221, 0.12895891413438165, \
0.48612608778450617]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.2686806675812221, 0.12895891413438165`, 
                   0.48612608778450617`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.2686806675812221, 0.12895891413438165`, 0.48612608778450617`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.13677350825175116`, 0.35655145450885906`, 
                  0.6175192436750943], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09118233883450078, 0.2377009696725727, 0.4116794957833962],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.13677350825175116, 0.35655145450885906, \
0.6175192436750943]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.13677350825175116`, 0.35655145450885906`, 
                   0.6175192436750943]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.13677350825175116`, 0.35655145450885906`, 0.6175192436750943],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.11603827689374602`, 0.32929455571681876`, 
                  0.35363487796714166`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.07735885126249735, 0.2195297038112125, 0.2357565853114278],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.11603827689374602, 0.32929455571681876, \
0.35363487796714166]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.11603827689374602`, 0.32929455571681876`, 
                   0.35363487796714166`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.11603827689374602`, 0.32929455571681876`, 0.35363487796714166`],
            
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9594661026437363, 0.019174338408860736`, 
                  0.8638303296364533], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6396440684291576, 0.012782892272573825`, 0.5758868864243023],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9594661026437363, 0.019174338408860736, \
0.8638303296364533]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9594661026437363, 0.019174338408860736`, 
                   0.8638303296364533]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9594661026437363, 0.019174338408860736`, 0.8638303296364533],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.0023372194642738986`, 0.5296844684311692, 
                  0.8922657573759605], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.0015581463095159325`, 0.3531229789541128, 
                 0.5948438382506404],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.0023372194642738986, 0.5296844684311692, \
0.8922657573759605]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.0023372194642738986`, 0.5296844684311692, 
                   0.8922657573759605]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.0023372194642738986`, 0.5296844684311692, 0.8922657573759605],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5665018419385066, 0.062398458101144305`, 
                  0.7946395095949659], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3776678946256711, 0.04159897206742954, 0.5297596730633106],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5665018419385066, 0.062398458101144305, \
0.7946395095949659]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5665018419385066, 0.062398458101144305`, 
                   0.7946395095949659]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5665018419385066, 0.062398458101144305`, 0.7946395095949659],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.1485067070533317, 0.878719460198053, 0.5145100781960741], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09900447136888779, 0.5858129734653688, 0.34300671879738276`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.1485067070533317, 0.878719460198053, \
0.5145100781960741]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.1485067070533317, 0.878719460198053, 0.5145100781960741]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.1485067070533317, 0.878719460198053, 0.5145100781960741],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6986641480021518, 0.5277529931464182, 0.9882141989328659], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4657760986681012, 0.3518353287642788, 0.6588094659552439],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6986641480021518, 0.5277529931464182, \
0.9882141989328659]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6986641480021518, 0.5277529931464182, 0.9882141989328659]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6986641480021518, 0.5277529931464182, 0.9882141989328659],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.944470290299775, 0.5535549082540978, 0.5692362328538259], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6296468601998501, 0.3690366055027319, 0.37949082190255057`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.944470290299775, 0.5535549082540978, \
0.5692362328538259]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.944470290299775, 0.5535549082540978, 0.5692362328538259]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.944470290299775, 0.5535549082540978, 0.5692362328538259],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9950288550859498, 0.6305255171534909, 
                  0.14550245342878587`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6633525700573, 0.42035034476899397`, 0.09700163561919059],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9950288550859498, 0.6305255171534909, \
0.14550245342878587]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9950288550859498, 0.6305255171534909, 
                   0.14550245342878587`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9950288550859498, 0.6305255171534909, 0.14550245342878587`],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.47707565384127437`, 0.6249071514987941, 
                  0.25986435733448365`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3180504358941829, 0.41660476766586274`, 
                 0.17324290488965577`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.47707565384127437, 0.6249071514987941, \
0.25986435733448365]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.47707565384127437`, 0.6249071514987941, 
                   0.25986435733448365`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.47707565384127437`, 0.6249071514987941, 0.25986435733448365`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5266744498730003, 0.5410779702989188, 0.4426300266010863], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.35111629991533355`, 0.3607186468659459, 0.2950866844007242],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5266744498730003, 0.5410779702989188, \
0.4426300266010863]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5266744498730003, 0.5410779702989188, 0.4426300266010863]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5266744498730003, 0.5410779702989188, 0.4426300266010863],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6123265547206336, 0.550345301812746, 0.6292907613853804], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.40821770314708905`, 0.366896867875164, 0.4195271742569203],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6123265547206336, 0.550345301812746, \
0.6292907613853804]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6123265547206336, 0.550345301812746, 0.6292907613853804]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6123265547206336, 0.550345301812746, 0.6292907613853804],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.4683869383303483, 0.6376038999964784, 0.9482824036369504], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3122579588868989, 0.42506926666431893`, 0.6321882690913003],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.4683869383303483, 0.6376038999964784, \
0.9482824036369504]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.4683869383303483, 0.6376038999964784, 0.9482824036369504]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.4683869383303483, 0.6376038999964784, 0.9482824036369504],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.38839146046953865`, 0.8865122076516063, 
                  0.8202263600216109], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[
                0.2589276403130258, 0.5910081384344043, 0.5468175733477406],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.38839146046953865, 0.8865122076516063, \
0.8202263600216109]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.38839146046953865`, 0.8865122076516063, 
                   0.8202263600216109]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.38839146046953865`, 0.8865122076516063, 0.8202263600216109],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8773202310413715, 0.6362835701560172, 
                  0.061260404202854835`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.584880154027581, 0.42418904677067815`, 0.04084026946856989],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8773202310413715, 0.6362835701560172, \
0.061260404202854835]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8773202310413715, 0.6362835701560172, 
                   0.061260404202854835`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8773202310413715, 0.6362835701560172, 0.061260404202854835`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5588128127634175, 0.16248971289955483`, 
                  0.5766972867522775], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3725418751756117, 0.10832647526636989`, 0.3844648578348517],
               
               FrameTicks->None,
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5588128127634175, 0.16248971289955483, \
0.5766972867522775]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5588128127634175, 0.16248971289955483`, 
                   0.5766972867522775]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5588128127634175, 0.16248971289955483`, 0.5766972867522775],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8511833587536144, 0.9070126840369901, 0.5390025527475242], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5674555725024096, 0.6046751226913267, 0.35933503516501614`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8511833587536144, 0.9070126840369901, \
0.5390025527475242]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8511833587536144, 0.9070126840369901, 0.5390025527475242]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8511833587536144, 0.9070126840369901, 0.5390025527475242],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7506259318165425, 0.1312350628753729, 
                  0.22332066944383255`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.500417287877695, 0.08749004191691527, 0.14888044629588837`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7506259318165425, 0.1312350628753729, \
0.22332066944383255]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7506259318165425, 0.1312350628753729, 
                   0.22332066944383255`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7506259318165425, 0.1312350628753729, 0.22332066944383255`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9774472795401823, 0.3187932574378307, 0.8399135077139674], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6516315196934549, 0.21252883829188715`, 0.5599423384759783],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9774472795401823, 0.3187932574378307, \
0.8399135077139674]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9774472795401823, 0.3187932574378307, 0.8399135077139674]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9774472795401823, 0.3187932574378307, 0.8399135077139674],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8659711441665874, 0.9337633437155759, 0.8284158906190038], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5773140961110583, 0.6225088958103839, 0.5522772604126692],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8659711441665874, 0.9337633437155759, \
0.8284158906190038]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8659711441665874, 0.9337633437155759, 0.8284158906190038]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8659711441665874, 0.9337633437155759, 0.8284158906190038],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6813528961030477, 0.3116838246899687, 0.5261222571978508], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4542352640686985, 0.20778921645997914`, 
                 0.35074817146523385`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6813528961030477, 0.3116838246899687, \
0.5261222571978508]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6813528961030477, 0.3116838246899687, 0.5261222571978508]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6813528961030477, 0.3116838246899687, 0.5261222571978508],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.24953149181408607`, 0.2700370274755417, 0.939270085452657],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1663543278760574, 0.18002468498369448`, 0.626180056968438],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.24953149181408607, 0.2700370274755417, \
0.939270085452657]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.24953149181408607`, 0.2700370274755417, 
                   0.939270085452657]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.24953149181408607`, 0.2700370274755417, 0.939270085452657],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.39880452764619134`, 0.11304137437881234`, 
                  0.9250643113223389], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2658696850974609, 0.07536091625254157, 0.6167095408815593],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.39880452764619134, 0.11304137437881234, \
0.9250643113223389]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.39880452764619134`, 0.11304137437881234`, 
                   0.9250643113223389]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.39880452764619134`, 0.11304137437881234`, 0.9250643113223389],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.722144192465362, 0.8141731175891291, 0.6054885055942887], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4814294616435747, 0.5427820783927528, 0.4036590037295258],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.722144192465362, 0.8141731175891291, \
0.6054885055942887]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.722144192465362, 0.8141731175891291, 0.6054885055942887]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.722144192465362, 0.8141731175891291, 0.6054885055942887],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.03510491575735286, 0.2251777828508641, 0.3320813121259285],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.023403277171568575`, 0.15011852190057606`, 
                 0.22138754141728567`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.03510491575735286, 0.2251777828508641, \
0.3320813121259285]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.03510491575735286, 0.2251777828508641, 
                   0.3320813121259285]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.03510491575735286, 0.2251777828508641, 0.3320813121259285],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.42071015332635664`, 0.4475373562504277, 
                  0.1139024756021787], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2804734355509044, 0.2983582375002851, 0.0759349837347858],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.42071015332635664, 0.4475373562504277, \
0.1139024756021787]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.42071015332635664`, 0.4475373562504277, 
                   0.1139024756021787]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.42071015332635664`, 0.4475373562504277, 0.1139024756021787],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6693657848721715, 0.3331654119546559, 0.7234594637391647], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.44624385658144766`, 0.22211027463643726`, 
                 0.48230630915944317`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6693657848721715, 0.3331654119546559, \
0.7234594637391647]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6693657848721715, 0.3331654119546559, 0.7234594637391647]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6693657848721715, 0.3331654119546559, 0.7234594637391647],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6959637718843776, 0.6580255185473778, 0.6401273378555634], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.46397584792291846`, 0.4386836790315852, 0.4267515585703756],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6959637718843776, 0.6580255185473778, \
0.6401273378555634]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6959637718843776, 0.6580255185473778, 0.6401273378555634]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6959637718843776, 0.6580255185473778, 0.6401273378555634],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.27801828448704513`, 0.6976038656132033, 
                  0.7682135474962679], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.18534552299136342`, 0.46506924374213554`, 0.512142364997512],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.27801828448704513, 0.6976038656132033, \
0.7682135474962679]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.27801828448704513`, 0.6976038656132033, 
                   0.7682135474962679]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.27801828448704513`, 0.6976038656132033, 0.7682135474962679],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8050936353245965, 0.7795392042384779, 0.05856055453707354],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5367290902163977, 0.519692802825652, 0.03904036969138236],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8050936353245965, 0.7795392042384779, \
0.05856055453707354]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8050936353245965, 0.7795392042384779, 
                   0.05856055453707354]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8050936353245965, 0.7795392042384779, 0.05856055453707354],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.4821543050363186, 0.38700563675037003`, 0.566044551763093],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.32143620335754575`, 0.25800375783358004`, 
                 0.37736303450872866`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.4821543050363186, 0.38700563675037003, \
0.566044551763093]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.4821543050363186, 0.38700563675037003`, 
                   0.566044551763093]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.4821543050363186, 0.38700563675037003`, 0.566044551763093],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5055334911414284, 0.031205725201232104`, 
                  0.47292037006274046`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.33702232742761895`, 0.020803816800821405`, 
                 0.31528024670849364`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5055334911414284, 0.031205725201232104, \
0.47292037006274046]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5055334911414284, 0.031205725201232104`, 
                   0.47292037006274046`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5055334911414284, 0.031205725201232104`, 0.47292037006274046`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8685490235605646, 0.9978119047515683, 0.0844149119888098], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5790326823737098, 0.6652079365010456, 0.05627660799253986],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8685490235605646, 0.9978119047515683, \
0.0844149119888098]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8685490235605646, 0.9978119047515683, 0.0844149119888098]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8685490235605646, 0.9978119047515683, 0.0844149119888098],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.844927124090106, 0.24617321712428142`, 
                  0.19296952872966888`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.563284749393404, 0.1641154780828543, 0.12864635248644593`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.844927124090106, 0.24617321712428142, \
0.19296952872966888]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.844927124090106, 0.24617321712428142`, 
                   0.19296952872966888`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.844927124090106, 0.24617321712428142`, 0.19296952872966888`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6381438817469831, 0.6400271534755568, 0.07726189879053225],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.42542925449798874`, 0.42668476898370455`, 
                 0.0515079325270215],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6381438817469831, 0.6400271534755568, \
0.07726189879053225]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6381438817469831, 0.6400271534755568, 
                   0.07726189879053225]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6381438817469831, 0.6400271534755568, 0.07726189879053225],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.1487035205633498, 0.30422659858404955`, 
                  0.9660415960577498], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09913568037556653, 0.20281773238936637`, 0.6440277307051665],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.1487035205633498, 0.30422659858404955, \
0.9660415960577498]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.1487035205633498, 0.30422659858404955`, 
                   0.9660415960577498]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.1487035205633498, 0.30422659858404955`, 0.9660415960577498],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.21093667672647975`, 0.2847479238675159, 
                  0.8195688125034541], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1406244511509865, 0.18983194924501062`, 0.5463792083356361],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.21093667672647975, 0.2847479238675159, \
0.8195688125034541]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.21093667672647975`, 0.2847479238675159, 
                   0.8195688125034541]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.21093667672647975`, 0.2847479238675159, 0.8195688125034541],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.14108240863163646`, 0.9087990701605684, 
                  0.9538194144329759], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09405493908775764, 0.6058660467737123, 0.635879609621984],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.14108240863163646, 0.9087990701605684, \
0.9538194144329759]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.14108240863163646`, 0.9087990701605684, 
                   0.9538194144329759]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.14108240863163646`, 0.9087990701605684, 0.9538194144329759],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.2768196546892643, 0.15368768179269643`, 
                  0.5382009355115158], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.18454643645950952`, 0.10245845452846429`, 
                 0.3588006236743439],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.2768196546892643, 0.15368768179269643, \
0.5382009355115158]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.2768196546892643, 0.15368768179269643`, 
                   0.5382009355115158]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.2768196546892643, 0.15368768179269643`, 0.5382009355115158],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7736432092485326, 0.9056107663826616, 0.8772484432330501], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5157621394990217, 0.6037405109217744, 0.5848322954887001],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7736432092485326, 0.9056107663826616, \
0.8772484432330501]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7736432092485326, 0.9056107663826616, 0.8772484432330501]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7736432092485326, 0.9056107663826616, 0.8772484432330501],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6177957558372875, 0.7375776492439312, 
                  0.13393939980625924`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.41186383722485836`, 0.4917184328292875, 0.08929293320417284],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6177957558372875, 0.7375776492439312, \
0.13393939980625924]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6177957558372875, 0.7375776492439312, 
                   0.13393939980625924`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6177957558372875, 0.7375776492439312, 0.13393939980625924`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.35214381279151064`, 0.8639526997031575, 
                  0.10865963128715062`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2347625418610071, 0.5759684664687716, 0.07243975419143375],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.35214381279151064, 0.8639526997031575, \
0.10865963128715062]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.35214381279151064`, 0.8639526997031575, 
                   0.10865963128715062`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.35214381279151064`, 0.8639526997031575, 0.10865963128715062`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8699277500813425, 0.04136820346326098, 
                  0.22194391878021413`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5799518333875617, 0.027578802308840654`, 
                 0.14796261252014276`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8699277500813425, 0.04136820346326098, \
0.22194391878021413]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8699277500813425, 0.04136820346326098, 
                   0.22194391878021413`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8699277500813425, 0.04136820346326098, 0.22194391878021413`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.07384686737384416, 0.21033851150129346`, 
                  0.36168497841717784`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.04923124491589611, 0.14022567433419564`, 
                 0.24112331894478523`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.07384686737384416, 0.21033851150129346, \
0.36168497841717784]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.07384686737384416, 0.21033851150129346`, 
                   0.36168497841717784`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.07384686737384416, 0.21033851150129346`, 0.36168497841717784`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.38837684824385565`, 0.17672874225569735`, 
                  0.8804082745658994], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2589178988292371, 0.11781916150379823`, 0.5869388497105996],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.38837684824385565, 0.17672874225569735, \
0.8804082745658994]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.38837684824385565`, 0.17672874225569735`, 
                   0.8804082745658994]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.38837684824385565`, 0.17672874225569735`, 0.8804082745658994],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.42677504026214197`, 0.029970518394615953`, 
                  0.9093689137406216], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.28451669350809466`, 0.019980345596410636`, 
                 0.6062459424937477],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.42677504026214197, 0.029970518394615953, \
0.9093689137406216]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.42677504026214197`, 0.029970518394615953`, 
                   0.9093689137406216]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.42677504026214197`, 0.029970518394615953`, 0.9093689137406216],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.18874454935697726`, 0.7706135696258611, 
                  0.6861689229479895], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[
                0.12582969957131818`, 0.5137423797505741, 0.457445948631993],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.18874454935697726, 0.7706135696258611, \
0.6861689229479895]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.18874454935697726`, 0.7706135696258611, 
                   0.6861689229479895]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.18874454935697726`, 0.7706135696258611, 0.6861689229479895],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.966908041371008, 0.3760517071812599, 0.7877995523073249], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6446053609140054, 0.25070113812083994`, 0.5251997015382166],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.966908041371008, 0.3760517071812599, \
0.7877995523073249]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.966908041371008, 0.3760517071812599, 0.7877995523073249]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.966908041371008, 0.3760517071812599, 0.7877995523073249],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9588642453966669, 0.9527506615610226, 0.6776685624701353], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6392428302644446, 0.6351671077073484, 0.45177904164675686`],
               
               FrameTicks->None,
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9588642453966669, 0.9527506615610226, \
0.6776685624701353]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9588642453966669, 0.9527506615610226, 0.6776685624701353]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9588642453966669, 0.9527506615610226, 0.6776685624701353],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.07205227832990913, 0.2604184840349075, 0.7583535892561375],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.04803485221993942, 0.17361232268993837`, 0.5055690595040917],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.07205227832990913, 0.2604184840349075, \
0.7583535892561375]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.07205227832990913, 0.2604184840349075, 
                   0.7583535892561375]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.07205227832990913, 0.2604184840349075, 0.7583535892561375],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.18261855057037701`, 0.07377077571605728, 
                  0.9094641871448221], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.12174570038025134`, 0.04918051714403819, 0.6063094580965481],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.18261855057037701, 0.07377077571605728, \
0.9094641871448221]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.18261855057037701`, 0.07377077571605728, 
                   0.9094641871448221]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.18261855057037701`, 0.07377077571605728, 0.9094641871448221],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.039346983610691666`, 0.7887535396336063, 
                  0.6381457731138491], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.026231322407127777`, 0.5258356930890709, 
                 0.42543051540923277`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.039346983610691666, 0.7887535396336063, \
0.6381457731138491]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.039346983610691666`, 0.7887535396336063, 
                   0.6381457731138491]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.039346983610691666`, 0.7887535396336063, 0.6381457731138491],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.36225527252229606`, 0.278577547292733, 0.6267700051472707],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.24150351501486406`, 0.185718364861822, 0.41784667009818044`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.36225527252229606, 0.278577547292733, \
0.6267700051472707]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.36225527252229606`, 0.278577547292733, 
                   0.6267700051472707]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.36225527252229606`, 0.278577547292733, 0.6267700051472707],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.4144548264854313, 0.41726057846332854`, 
                  0.09312404235892613], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2763032176569542, 0.2781737189755524, 0.06208269490595075],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.4144548264854313, 0.41726057846332854, \
0.09312404235892613]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.4144548264854313, 0.41726057846332854`, 
                   0.09312404235892613]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.4144548264854313, 0.41726057846332854`, 0.09312404235892613],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5999183979301403, 0.3848496420691847, 
                  0.11890027599057218`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3999455986200936, 0.2565664280461232, 0.07926685066038146],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5999183979301403, 0.3848496420691847, \
0.11890027599057218]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5999183979301403, 0.3848496420691847, 
                   0.11890027599057218`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5999183979301403, 0.3848496420691847, 0.11890027599057218`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.1382923672752192, 0.07817846911591331, 0.6881622733139259],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.0921949115168128, 0.052118979410608876`, 0.4587748488759506],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.1382923672752192, 0.07817846911591331, \
0.6881622733139259]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.1382923672752192, 0.07817846911591331, 
                   0.6881622733139259]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.1382923672752192, 0.07817846911591331, 0.6881622733139259],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.24624063780241556`, 0.1800489249080821, 
                  0.32849770905474385`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1641604252016104, 0.12003261660538808`, 
                 0.21899847270316258`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.24624063780241556, 0.1800489249080821, \
0.32849770905474385]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.24624063780241556`, 0.1800489249080821, 
                   0.32849770905474385`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.24624063780241556`, 0.1800489249080821, 0.32849770905474385`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.4685173932872393, 0.020378229002663284`, 
                  0.01003801403355098], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.31234492885815957`, 0.013585486001775523`, 
                 0.0066920093557006535`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.4685173932872393, 0.020378229002663284, \
0.01003801403355098]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.4685173932872393, 0.020378229002663284`, 
                   0.01003801403355098]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.4685173932872393, 0.020378229002663284`, 0.01003801403355098],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.43787702587474797`, 0.026595013928990996`, 
                  0.9451962960693305], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.291918017249832, 0.017730009285993997`, 0.6301308640462204],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.43787702587474797, 0.026595013928990996, \
0.9451962960693305]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.43787702587474797`, 0.026595013928990996`, 
                   0.9451962960693305]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.43787702587474797`, 0.026595013928990996`, 0.9451962960693305],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.10271256838122578`, 0.23402905207107216`, 
                  0.7124690719183648], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.06847504558748385, 0.15601936804738145`, 
                 0.47497938127890993`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.10271256838122578, 0.23402905207107216, \
0.7124690719183648]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.10271256838122578`, 0.23402905207107216`, 
                   0.7124690719183648]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.10271256838122578`, 0.23402905207107216`, 0.7124690719183648],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.13574716529583064`, 0.3852836779210671, 
                  0.18069233382193683`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09049811019722043, 0.2568557852807114, 0.12046155588129123`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.13574716529583064, 0.3852836779210671, \
0.18069233382193683]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.13574716529583064`, 0.3852836779210671, 
                   0.18069233382193683`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.13574716529583064`, 0.3852836779210671, 0.18069233382193683`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6594655586983071, 0.37226694738568766`, 
                  0.10523044882039057`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.43964370579887146`, 0.2481779649237918, 0.07015363254692705],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6594655586983071, 0.37226694738568766, \
0.10523044882039057]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6594655586983071, 0.37226694738568766`, 
                   0.10523044882039057`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6594655586983071, 0.37226694738568766`, 0.10523044882039057`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.3016018675887575, 0.017367768024978636`, 
                  0.02988417913747421], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.20106791172583835`, 0.011578512016652425`, 
                 0.019922786091649474`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.3016018675887575, 0.017367768024978636, \
0.02988417913747421]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.3016018675887575, 0.017367768024978636`, 
                   0.02988417913747421]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.3016018675887575, 0.017367768024978636`, 0.02988417913747421],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.25744605732933556`, 0.0009363281076462115, 
                  0.4144185993777667], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.17163070488622373`, 0.0006242187384308078, 
                 0.2762790662518445],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.25744605732933556, 0.0009363281076462115, \
0.4144185993777667]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.25744605732933556`, 0.0009363281076462115, 
                   0.4144185993777667]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.25744605732933556`, 0.0009363281076462115, 0.4144185993777667],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6774781282708688, 0.34222154687598816`, 
                  0.9702957136604509], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.45165208551391256`, 0.22814769791732545`, 
                 0.6468638091069673],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6774781282708688, 0.34222154687598816, \
0.9702957136604509]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6774781282708688, 0.34222154687598816`, 
                   0.9702957136604509]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6774781282708688, 0.34222154687598816`, 0.9702957136604509],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.25184011467250755`, 0.1424666032202313, 
                  0.08351853989844327], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.16789340978167172`, 0.0949777354801542, 0.05567902659896218],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.25184011467250755, 0.1424666032202313, \
0.08351853989844327]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.25184011467250755`, 0.1424666032202313, 
                   0.08351853989844327]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.25184011467250755`, 0.1424666032202313, 0.08351853989844327],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9626986817854162, 0.4083796328498486, 0.8311777753095406], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6417991211902775, 0.2722530885665657, 0.5541185168730272],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9626986817854162, 0.4083796328498486, \
0.8311777753095406]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9626986817854162, 0.4083796328498486, 0.8311777753095406]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9626986817854162, 0.4083796328498486, 0.8311777753095406],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6370847928517527, 0.9773515931950683, 0.5706929094966902], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4247231952345018, 0.6515677287967122, 0.3804619396644601],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6370847928517527, 0.9773515931950683, \
0.5706929094966902]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6370847928517527, 0.9773515931950683, 0.5706929094966902]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6370847928517527, 0.9773515931950683, 0.5706929094966902],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8798007371690433, 0.2447981806185593, 0.997782208354512], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5865338247793622, 0.16319878707903954`, 0.6651881389030081],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8798007371690433, 0.2447981806185593, \
0.997782208354512]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8798007371690433, 0.2447981806185593, 0.997782208354512]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8798007371690433, 0.2447981806185593, 0.997782208354512],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.369233553307007, 0.625348557118919, 0.3122090291003854], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.24615570220467137`, 0.41689903807927936`, 
                 0.20813935273359027`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.369233553307007, 0.625348557118919, \
0.3122090291003854]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.369233553307007, 0.625348557118919, 0.3122090291003854]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[0.369233553307007, 0.625348557118919, 0.3122090291003854],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.13515879780744156`, 0.6771272543176945, 
                  0.28193091711950724`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.09010586520496104, 0.4514181695451297, 0.18795394474633817`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.13515879780744156, 0.6771272543176945, \
0.28193091711950724]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.13515879780744156`, 0.6771272543176945, 
                   0.28193091711950724`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.13515879780744156`, 0.6771272543176945, 0.28193091711950724`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9060996386777893, 0.9560202893745733, 0.5085789630160067], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6040664257851929, 0.6373468595830489, 0.33905264201067115`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9060996386777893, 0.9560202893745733, \
0.5085789630160067]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9060996386777893, 0.9560202893745733, 0.5085789630160067]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9060996386777893, 0.9560202893745733, 0.5085789630160067],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7304345932965026, 0.8615882113514635, 0.4099546416922448], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4869563955310018, 0.5743921409009757, 0.2733030944614966],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7304345932965026, 0.8615882113514635, \
0.4099546416922448]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7304345932965026, 0.8615882113514635, 0.4099546416922448]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7304345932965026, 0.8615882113514635, 0.4099546416922448],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6207885604905226, 0.48777259529831696`, 
                  0.5545109977956224], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.41385904032701504`, 0.32518173019887797`, 
                 0.36967399853041494`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6207885604905226, 0.48777259529831696, \
0.5545109977956224]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6207885604905226, 0.48777259529831696`, 
                   0.5545109977956224]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6207885604905226, 0.48777259529831696`, 0.5545109977956224],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.29599824564873267`, 0.8436302159833555, 
                  0.9412135524152723], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1973321637658218, 0.5624201439889037, 0.6274757016101815],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.29599824564873267, 0.8436302159833555, \
0.9412135524152723]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.29599824564873267`, 0.8436302159833555, 
                   0.9412135524152723]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.29599824564873267`, 0.8436302159833555, 0.9412135524152723],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7909121435518047, 0.6208986403466146, 0.9436735191883905], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5272747623678699, 0.41393242689774307`, 0.629115679458927],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7909121435518047, 0.6208986403466146, \
0.9436735191883905]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7909121435518047, 0.6208986403466146, 0.9436735191883905]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7909121435518047, 0.6208986403466146, 0.9436735191883905],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.008032831548657304, 0.2176551315452826, 
                  0.7476538249949745], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.0053552210324382035`, 0.14510342103018842`, 
                 0.498435883329983],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.008032831548657304, 0.2176551315452826, \
0.7476538249949745]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.008032831548657304, 0.2176551315452826, 
                   0.7476538249949745]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.008032831548657304, 0.2176551315452826, 0.7476538249949745],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.2434768809769423, 0.013672225061276855`, 
                  0.8698703822171678], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.16231792065129488`, 0.009114816707517903, 
                 0.5799135881447786],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.2434768809769423, 0.013672225061276855, \
0.8698703822171678]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.2434768809769423, 0.013672225061276855`, 
                   0.8698703822171678]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.2434768809769423, 0.013672225061276855`, 0.8698703822171678],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.3491648958878386, 0.7132746264593937, 0.8641994206447752], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2327765972585591, 0.4755164176395958, 0.5761329470965169],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.3491648958878386, 0.7132746264593937, \
0.8641994206447752]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.3491648958878386, 0.7132746264593937, 0.8641994206447752]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.3491648958878386, 0.7132746264593937, 0.8641994206447752],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.08648992316129767, 0.8603044846284271, 0.3652586767874819],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.057659948774198444`, 0.5735363230856181, 
                 0.24350578452498794`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.08648992316129767, 0.8603044846284271, \
0.3652586767874819]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.08648992316129767, 0.8603044846284271, 
                   0.3652586767874819]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.08648992316129767, 0.8603044846284271, 0.3652586767874819],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.21434416032404568`, 0.560445651410233, 0.9235747344420331],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[
                0.14289610688269713`, 0.37363043427348863`, 
                 0.6157164896280221],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.21434416032404568, 0.560445651410233, \
0.9235747344420331]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.21434416032404568`, 0.560445651410233, 
                   0.9235747344420331]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.21434416032404568`, 0.560445651410233, 0.9235747344420331],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6641969362359714, 0.8844412534660229, 0.7597163627298724], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.44279795749064765`, 0.589627502310682, 0.5064775751532483],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6641969362359714, 0.8844412534660229, \
0.7597163627298724]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6641969362359714, 0.8844412534660229, 0.7597163627298724]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6641969362359714, 0.8844412534660229, 0.7597163627298724],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7835349571323893, 0.7177206084208989, 0.9443621603773193], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5223566380882596, 0.4784804056139326, 0.6295747735848796],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7835349571323893, 0.7177206084208989, \
0.9443621603773193]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7835349571323893, 0.7177206084208989, 0.9443621603773193]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7835349571323893, 0.7177206084208989, 0.9443621603773193],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.4063999909281031, 0.1560001127426507, 0.9791487175568574], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.2709333272854021, 0.10400007516176712`, 0.6527658117045716],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.4063999909281031, 0.1560001127426507, \
0.9791487175568574]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.4063999909281031, 0.1560001127426507, 0.9791487175568574]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.4063999909281031, 0.1560001127426507, 0.9791487175568574],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.1982275401878799, 0.5018874444551371, 0.7126747022344182], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.13215169345858663`, 0.3345916296367581, 
                 0.47511646815627884`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.1982275401878799, 0.5018874444551371, \
0.7126747022344182]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.1982275401878799, 0.5018874444551371, 0.7126747022344182]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.1982275401878799, 0.5018874444551371, 0.7126747022344182],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.46389356907610657`, 0.9899568793510354, 
                  0.18282549555593763`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.3092623793840711, 0.6599712529006903, 0.12188366370395842`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.46389356907610657, 0.9899568793510354, \
0.18282549555593763]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.46389356907610657`, 0.9899568793510354, 
                   0.18282549555593763`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.46389356907610657`, 0.9899568793510354, 0.18282549555593763`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.7965448575036715, 0.2203076940626465, 0.8028855805437274], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5310299050024477, 0.14687179604176434`, 0.5352570536958183],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.7965448575036715, 0.2203076940626465, \
0.8028855805437274]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.7965448575036715, 0.2203076940626465, 0.8028855805437274]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.7965448575036715, 0.2203076940626465, 0.8028855805437274],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9902733343532162, 0.25606104429275356`, 
                  0.3849896405954891], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6601822229021441, 0.17070736286183572`, 0.2566597603969928],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9902733343532162, 0.25606104429275356, \
0.3849896405954891]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9902733343532162, 0.25606104429275356`, 
                   0.3849896405954891]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9902733343532162, 0.25606104429275356`, 0.3849896405954891],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6221007700303403, 0.01765127658624177, 
                  0.22098467649124798`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4147338466868935, 0.01176751772416118, 0.147323117660832],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6221007700303403, 0.01765127658624177, \
0.22098467649124798]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6221007700303403, 0.01765127658624177, 
                   0.22098467649124798`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6221007700303403, 0.01765127658624177, 0.22098467649124798`],
            Editable->False,
            Selectable->False]},
          {
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.8215044522625461, 0.16572454783069857`, 
                  0.8040773618551336], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.5476696348416974, 0.11048303188713238`, 0.5360515745700891],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.8215044522625461, 0.16572454783069857, \
0.8040773618551336]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.8215044522625461, 0.16572454783069857`, 
                   0.8040773618551336]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.8215044522625461, 0.16572454783069857`, 0.8040773618551336],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.24921899792850022`, 0.2759862741314656, 
                  0.9867270641108767], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.16614599861900015`, 0.18399084942097707`, 
                 0.6578180427405845],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.24921899792850022, 0.2759862741314656, \
0.9867270641108767]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.24921899792850022`, 0.2759862741314656, 
                   0.9867270641108767]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.24921899792850022`, 0.2759862741314656, 0.9867270641108767],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.9705600763758861, 0.6579222578247919, 0.09801587123491529],
                  RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6470400509172575, 0.4386148385498613, 0.0653439141566102],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.9705600763758861, 0.6579222578247919, \
0.09801587123491529]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.9705600763758861, 0.6579222578247919, 
                   0.09801587123491529]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.9705600763758861, 0.6579222578247919, 0.09801587123491529],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.5219662481223741, 0.14969988943827683`, 
                  0.21533096883363356`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.34797749874824946`, 0.09979992629218457, 
                 0.14355397922242238`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.5219662481223741, 0.14969988943827683, \
0.21533096883363356]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.5219662481223741, 0.14969988943827683`, 
                   0.21533096883363356`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.5219662481223741, 0.14969988943827683`, 0.21533096883363356`],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.2385598894514005, 0.420472814737084, 0.06616306125117433], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.15903992630093367`, 0.2803152098247227, 
                 0.044108707500782884`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.2385598894514005, 0.420472814737084, \
0.06616306125117433]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.2385598894514005, 0.420472814737084, 0.06616306125117433]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.2385598894514005, 0.420472814737084, 0.06616306125117433],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6189105535277344, 0.492652144492848, 0.2548520338813385], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4126070356851563, 0.328434762995232, 0.16990135592089234`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6189105535277344, 0.492652144492848, \
0.2548520338813385]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6189105535277344, 0.492652144492848, 0.2548520338813385]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6189105535277344, 0.492652144492848, 0.2548520338813385],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.2540039550834856, 0.25090544958492833`, 
                  0.7402121254547946], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.1693359700556571, 0.16727029972328555`, 
                 0.49347475030319643`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.2540039550834856, 0.25090544958492833, \
0.7402121254547946]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.2540039550834856, 0.25090544958492833`, 
                   0.7402121254547946]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.2540039550834856, 0.25090544958492833`, 0.7402121254547946],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.033513046184048045`, 0.1728855219836134, 
                  0.026644850308877865`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.022342030789365364`, 0.11525701465574227`, 
                 0.01776323353925191],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.033513046184048045, 0.1728855219836134, \
0.026644850308877865]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.033513046184048045`, 0.1728855219836134, 
                   0.026644850308877865`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.033513046184048045`, 0.1728855219836134, 0.026644850308877865`],
            
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.6444793017816008, 0.8547066417937763, 0.3474794538334989], 
                 RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.4296528678544006, 0.5698044278625176, 0.23165296922233258`],
               
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.6444793017816008, 0.8547066417937763, \
0.3474794538334989]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.6444793017816008, 0.8547066417937763, 0.3474794538334989]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.6444793017816008, 0.8547066417937763, 0.3474794538334989],
            Editable->False,
            Selectable->False], 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[
                 0.16105684440590573`, 0.0715923354102661, 
                  0.15942531715860908`], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.10737122960393716`, 0.047728223606844075`, 
                 0.10628354477240606`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              
              "RGBColor[0.16105684440590573, 0.0715923354102661, \
0.15942531715860908]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[
                  0.16105684440590573`, 0.0715923354102661, 
                   0.15942531715860908`]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[
            0.16105684440590573`, 0.0715923354102661, 0.15942531715860908`],
            Editable->False,
            Selectable->False]}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "d766b220-6f34-4784-8ccd-21a934f01f61"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.2686806675812221, 0.12895891413438165`, 
                    0.48612608778450617`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1791204450541481, 0.0859726094229211, 
                   0.32408405852300415`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.2686806675812221, 0.12895891413438165, \
0.48612608778450617]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.2686806675812221, 0.12895891413438165`, 
                    0.48612608778450617`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.2686806675812221, 0.12895891413438165`, 0.48612608778450617`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.13677350825175116`, 0.35655145450885906`, 
                    0.6175192436750943], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09118233883450078, 0.2377009696725727, 
                   0.4116794957833962], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.13677350825175116, 0.35655145450885906, \
0.6175192436750943]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.13677350825175116`, 0.35655145450885906`, 
                    0.6175192436750943]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.13677350825175116`, 0.35655145450885906`, 0.6175192436750943],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.11603827689374602`, 0.32929455571681876`, 
                    0.35363487796714166`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.07735885126249735, 0.2195297038112125, 
                   0.2357565853114278], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.11603827689374602, 0.32929455571681876, \
0.35363487796714166]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.11603827689374602`, 0.32929455571681876`, 
                    0.35363487796714166`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.11603827689374602`, 0.32929455571681876`, 
               0.35363487796714166`], Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9594661026437363, 0.019174338408860736`, 
                    0.8638303296364533], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6396440684291576, 0.012782892272573825`, 
                   0.5758868864243023], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9594661026437363, 0.019174338408860736, \
0.8638303296364533]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9594661026437363, 0.019174338408860736`, 
                    0.8638303296364533]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9594661026437363, 0.019174338408860736`, 0.8638303296364533], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.0023372194642738986`, 0.5296844684311692, 
                    0.8922657573759605], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.0015581463095159325`, 0.3531229789541128, 
                   0.5948438382506404], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.0023372194642738986, 0.5296844684311692, \
0.8922657573759605]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.0023372194642738986`, 0.5296844684311692, 
                    0.8922657573759605]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.0023372194642738986`, 0.5296844684311692, 0.8922657573759605],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5665018419385066, 0.062398458101144305`, 
                    0.7946395095949659], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3776678946256711, 0.04159897206742954, 
                   0.5297596730633106], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5665018419385066, 0.062398458101144305, \
0.7946395095949659]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5665018419385066, 0.062398458101144305`, 
                    0.7946395095949659]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5665018419385066, 0.062398458101144305`, 0.7946395095949659], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.1485067070533317, 0.878719460198053, 
                    0.5145100781960741], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09900447136888779, 0.5858129734653688, 
                   0.34300671879738276`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.1485067070533317, 0.878719460198053, \
0.5145100781960741]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.1485067070533317, 0.878719460198053, 
                    0.5145100781960741]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.1485067070533317, 0.878719460198053, 0.5145100781960741], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6986641480021518, 0.5277529931464182, 
                    0.9882141989328659], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4657760986681012, 0.3518353287642788, 0.6588094659552439],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6986641480021518, 0.5277529931464182, \
0.9882141989328659]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6986641480021518, 0.5277529931464182, 
                    0.9882141989328659]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6986641480021518, 0.5277529931464182, 0.9882141989328659], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.944470290299775, 0.5535549082540978, 
                    0.5692362328538259], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6296468601998501, 0.3690366055027319, 
                   0.37949082190255057`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.944470290299775, 0.5535549082540978, \
0.5692362328538259]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.944470290299775, 0.5535549082540978, 
                    0.5692362328538259]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.944470290299775, 0.5535549082540978, 0.5692362328538259], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9950288550859498, 0.6305255171534909, 
                    0.14550245342878587`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6633525700573, 0.42035034476899397`, 0.09700163561919059],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9950288550859498, 0.6305255171534909, \
0.14550245342878587]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9950288550859498, 0.6305255171534909, 
                    0.14550245342878587`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9950288550859498, 0.6305255171534909, 0.14550245342878587`], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.47707565384127437`, 0.6249071514987941, 
                    0.25986435733448365`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3180504358941829, 0.41660476766586274`, 
                   0.17324290488965577`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                
                "RGBColor[0.47707565384127437, 0.6249071514987941, \
0.25986435733448365]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.47707565384127437`, 0.6249071514987941, 
                    0.25986435733448365`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.47707565384127437`, 0.6249071514987941, 0.25986435733448365`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5266744498730003, 0.5410779702989188, 
                    0.4426300266010863], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.35111629991533355`, 0.3607186468659459, 
                   0.2950866844007242], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5266744498730003, 0.5410779702989188, \
0.4426300266010863]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5266744498730003, 0.5410779702989188, 
                    0.4426300266010863]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5266744498730003, 0.5410779702989188, 0.4426300266010863], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6123265547206336, 0.550345301812746, 
                    0.6292907613853804], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.40821770314708905`, 0.366896867875164, 
                   0.4195271742569203], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6123265547206336, 0.550345301812746, \
0.6292907613853804]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6123265547206336, 0.550345301812746, 
                    0.6292907613853804]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6123265547206336, 0.550345301812746, 0.6292907613853804], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.4683869383303483, 0.6376038999964784, 
                    0.9482824036369504], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3122579588868989, 0.42506926666431893`, 
                   0.6321882690913003], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.4683869383303483, 0.6376038999964784, \
0.9482824036369504]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.4683869383303483, 0.6376038999964784, 
                    0.9482824036369504]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.4683869383303483, 0.6376038999964784, 0.9482824036369504], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.38839146046953865`, 0.8865122076516063, 
                    0.8202263600216109], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2589276403130258, 0.5910081384344043, 0.5468175733477406],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.38839146046953865, 0.8865122076516063, \
0.8202263600216109]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.38839146046953865`, 0.8865122076516063, 
                    0.8202263600216109]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.38839146046953865`, 0.8865122076516063, 0.8202263600216109], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8773202310413715, 0.6362835701560172, 
                    0.061260404202854835`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.584880154027581, 0.42418904677067815`, 
                   0.04084026946856989], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8773202310413715, 0.6362835701560172, \
0.061260404202854835]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8773202310413715, 0.6362835701560172, 
                    0.061260404202854835`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8773202310413715, 0.6362835701560172, 0.061260404202854835`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5588128127634175, 0.16248971289955483`, 
                    0.5766972867522775], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3725418751756117, 0.10832647526636989`, 
                   0.3844648578348517], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5588128127634175, 0.16248971289955483, \
0.5766972867522775]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5588128127634175, 0.16248971289955483`, 
                    0.5766972867522775]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5588128127634175, 0.16248971289955483`, 0.5766972867522775], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8511833587536144, 0.9070126840369901, 
                    0.5390025527475242], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5674555725024096, 0.6046751226913267, 
                   0.35933503516501614`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8511833587536144, 0.9070126840369901, \
0.5390025527475242]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8511833587536144, 0.9070126840369901, 
                    0.5390025527475242]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8511833587536144, 0.9070126840369901, 0.5390025527475242], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7506259318165425, 0.1312350628753729, 
                    0.22332066944383255`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.500417287877695, 0.08749004191691527, 
                   0.14888044629588837`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.7506259318165425, 0.1312350628753729, \
0.22332066944383255]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7506259318165425, 0.1312350628753729, 
                    0.22332066944383255`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7506259318165425, 0.1312350628753729, 0.22332066944383255`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9774472795401823, 0.3187932574378307, 
                    0.8399135077139674], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6516315196934549, 0.21252883829188715`, 
                   0.5599423384759783], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9774472795401823, 0.3187932574378307, \
0.8399135077139674]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9774472795401823, 0.3187932574378307, 
                    0.8399135077139674]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9774472795401823, 0.3187932574378307, 0.8399135077139674], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8659711441665874, 0.9337633437155759, 
                    0.8284158906190038], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5773140961110583, 0.6225088958103839, 0.5522772604126692],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8659711441665874, 0.9337633437155759, \
0.8284158906190038]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8659711441665874, 0.9337633437155759, 
                    0.8284158906190038]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8659711441665874, 0.9337633437155759, 0.8284158906190038], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6813528961030477, 0.3116838246899687, 
                    0.5261222571978508], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4542352640686985, 0.20778921645997914`, 
                   0.35074817146523385`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6813528961030477, 0.3116838246899687, \
0.5261222571978508]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6813528961030477, 0.3116838246899687, 
                    0.5261222571978508]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6813528961030477, 0.3116838246899687, 0.5261222571978508], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.24953149181408607`, 0.2700370274755417, 
                    0.939270085452657], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1663543278760574, 0.18002468498369448`, 
                   0.626180056968438], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.24953149181408607, 0.2700370274755417, \
0.939270085452657]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.24953149181408607`, 0.2700370274755417, 
                    0.939270085452657]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.24953149181408607`, 0.2700370274755417, 0.939270085452657], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.39880452764619134`, 0.11304137437881234`, 
                    0.9250643113223389], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2658696850974609, 0.07536091625254157, 
                   0.6167095408815593], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.39880452764619134, 0.11304137437881234, \
0.9250643113223389]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.39880452764619134`, 0.11304137437881234`, 
                    0.9250643113223389]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.39880452764619134`, 0.11304137437881234`, 0.9250643113223389],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.722144192465362, 0.8141731175891291, 
                    0.6054885055942887], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4814294616435747, 0.5427820783927528, 0.4036590037295258],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.722144192465362, 0.8141731175891291, \
0.6054885055942887]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.722144192465362, 0.8141731175891291, 
                    0.6054885055942887]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.722144192465362, 0.8141731175891291, 0.6054885055942887], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.03510491575735286, 0.2251777828508641, 
                    0.3320813121259285], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.023403277171568575`, 0.15011852190057606`, 
                   0.22138754141728567`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.03510491575735286, 0.2251777828508641, \
0.3320813121259285]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.03510491575735286, 0.2251777828508641, 
                    0.3320813121259285]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.03510491575735286, 0.2251777828508641, 0.3320813121259285], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.42071015332635664`, 0.4475373562504277, 
                    0.1139024756021787], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2804734355509044, 0.2983582375002851, 0.0759349837347858],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.42071015332635664, 0.4475373562504277, \
0.1139024756021787]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.42071015332635664`, 0.4475373562504277, 
                    0.1139024756021787]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.42071015332635664`, 0.4475373562504277, 0.1139024756021787], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6693657848721715, 0.3331654119546559, 
                    0.7234594637391647], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.44624385658144766`, 0.22211027463643726`, 
                   0.48230630915944317`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6693657848721715, 0.3331654119546559, \
0.7234594637391647]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6693657848721715, 0.3331654119546559, 
                    0.7234594637391647]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6693657848721715, 0.3331654119546559, 0.7234594637391647], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6959637718843776, 0.6580255185473778, 
                    0.6401273378555634], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.46397584792291846`, 0.4386836790315852, 
                   0.4267515585703756], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6959637718843776, 0.6580255185473778, \
0.6401273378555634]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6959637718843776, 0.6580255185473778, 
                    0.6401273378555634]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6959637718843776, 0.6580255185473778, 0.6401273378555634], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.27801828448704513`, 0.6976038656132033, 
                    0.7682135474962679], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.18534552299136342`, 0.46506924374213554`, 
                   0.512142364997512], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.27801828448704513, 0.6976038656132033, \
0.7682135474962679]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.27801828448704513`, 0.6976038656132033, 
                    0.7682135474962679]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.27801828448704513`, 0.6976038656132033, 0.7682135474962679], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8050936353245965, 0.7795392042384779, 
                    0.05856055453707354], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5367290902163977, 0.519692802825652, 0.03904036969138236],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8050936353245965, 0.7795392042384779, \
0.05856055453707354]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8050936353245965, 0.7795392042384779, 
                    0.05856055453707354]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8050936353245965, 0.7795392042384779, 0.05856055453707354], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.4821543050363186, 0.38700563675037003`, 
                    0.566044551763093], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.32143620335754575`, 0.25800375783358004`, 
                   0.37736303450872866`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.4821543050363186, 0.38700563675037003, \
0.566044551763093]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.4821543050363186, 0.38700563675037003`, 
                    0.566044551763093]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.4821543050363186, 0.38700563675037003`, 0.566044551763093], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5055334911414284, 0.031205725201232104`, 
                    0.47292037006274046`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.33702232742761895`, 0.020803816800821405`, 
                   0.31528024670849364`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5055334911414284, 0.031205725201232104, \
0.47292037006274046]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5055334911414284, 0.031205725201232104`, 
                    0.47292037006274046`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5055334911414284, 0.031205725201232104`, 
               0.47292037006274046`], Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8685490235605646, 0.9978119047515683, 
                    0.0844149119888098], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5790326823737098, 0.6652079365010456, 
                   0.05627660799253986], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8685490235605646, 0.9978119047515683, \
0.0844149119888098]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8685490235605646, 0.9978119047515683, 
                    0.0844149119888098]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8685490235605646, 0.9978119047515683, 0.0844149119888098], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.844927124090106, 0.24617321712428142`, 
                    0.19296952872966888`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.563284749393404, 0.1641154780828543, 
                   0.12864635248644593`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.844927124090106, 0.24617321712428142, \
0.19296952872966888]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.844927124090106, 0.24617321712428142`, 
                    0.19296952872966888`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.844927124090106, 0.24617321712428142`, 0.19296952872966888`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6381438817469831, 0.6400271534755568, 
                    0.07726189879053225], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.42542925449798874`, 0.42668476898370455`, 
                   0.0515079325270215], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6381438817469831, 0.6400271534755568, \
0.07726189879053225]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6381438817469831, 0.6400271534755568, 
                    0.07726189879053225]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6381438817469831, 0.6400271534755568, 0.07726189879053225], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.1487035205633498, 0.30422659858404955`, 
                    0.9660415960577498], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09913568037556653, 0.20281773238936637`, 
                   0.6440277307051665], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.1487035205633498, 0.30422659858404955, \
0.9660415960577498]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.1487035205633498, 0.30422659858404955`, 
                    0.9660415960577498]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.1487035205633498, 0.30422659858404955`, 0.9660415960577498], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.21093667672647975`, 0.2847479238675159, 
                    0.8195688125034541], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1406244511509865, 0.18983194924501062`, 
                   0.5463792083356361], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.21093667672647975, 0.2847479238675159, \
0.8195688125034541]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.21093667672647975`, 0.2847479238675159, 
                    0.8195688125034541]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.21093667672647975`, 0.2847479238675159, 0.8195688125034541], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.14108240863163646`, 0.9087990701605684, 
                    0.9538194144329759], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09405493908775764, 0.6058660467737123, 0.635879609621984],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.14108240863163646, 0.9087990701605684, \
0.9538194144329759]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.14108240863163646`, 0.9087990701605684, 
                    0.9538194144329759]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.14108240863163646`, 0.9087990701605684, 0.9538194144329759], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.2768196546892643, 0.15368768179269643`, 
                    0.5382009355115158], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.18454643645950952`, 0.10245845452846429`, 
                   0.3588006236743439], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.2768196546892643, 0.15368768179269643, \
0.5382009355115158]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.2768196546892643, 0.15368768179269643`, 
                    0.5382009355115158]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.2768196546892643, 0.15368768179269643`, 0.5382009355115158], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7736432092485326, 0.9056107663826616, 
                    0.8772484432330501], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5157621394990217, 0.6037405109217744, 0.5848322954887001],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.7736432092485326, 0.9056107663826616, \
0.8772484432330501]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7736432092485326, 0.9056107663826616, 
                    0.8772484432330501]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7736432092485326, 0.9056107663826616, 0.8772484432330501], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6177957558372875, 0.7375776492439312, 
                    0.13393939980625924`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.41186383722485836`, 0.4917184328292875, 
                   0.08929293320417284], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6177957558372875, 0.7375776492439312, \
0.13393939980625924]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6177957558372875, 0.7375776492439312, 
                    0.13393939980625924`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6177957558372875, 0.7375776492439312, 0.13393939980625924`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.35214381279151064`, 0.8639526997031575, 
                    0.10865963128715062`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2347625418610071, 0.5759684664687716, 
                   0.07243975419143375], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.35214381279151064, 0.8639526997031575, \
0.10865963128715062]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.35214381279151064`, 0.8639526997031575, 
                    0.10865963128715062`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.35214381279151064`, 0.8639526997031575, 0.10865963128715062`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8699277500813425, 0.04136820346326098, 
                    0.22194391878021413`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5799518333875617, 0.027578802308840654`, 
                   0.14796261252014276`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8699277500813425, 0.04136820346326098, \
0.22194391878021413]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8699277500813425, 0.04136820346326098, 
                    0.22194391878021413`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8699277500813425, 0.04136820346326098, 0.22194391878021413`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.07384686737384416, 0.21033851150129346`, 
                    0.36168497841717784`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.04923124491589611, 0.14022567433419564`, 
                   0.24112331894478523`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.07384686737384416, 0.21033851150129346, \
0.36168497841717784]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.07384686737384416, 0.21033851150129346`, 
                    0.36168497841717784`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.07384686737384416, 0.21033851150129346`, 
               0.36168497841717784`], Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.38837684824385565`, 0.17672874225569735`, 
                    0.8804082745658994], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2589178988292371, 0.11781916150379823`, 
                   0.5869388497105996], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.38837684824385565, 0.17672874225569735, \
0.8804082745658994]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.38837684824385565`, 0.17672874225569735`, 
                    0.8804082745658994]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.38837684824385565`, 0.17672874225569735`, 0.8804082745658994],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.42677504026214197`, 0.029970518394615953`, 
                    0.9093689137406216], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.28451669350809466`, 0.019980345596410636`, 
                   0.6062459424937477], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.42677504026214197, 0.029970518394615953, \
0.9093689137406216]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.42677504026214197`, 0.029970518394615953`, 
                    0.9093689137406216]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.42677504026214197`, 0.029970518394615953`, 
               0.9093689137406216], Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.18874454935697726`, 0.7706135696258611, 
                    0.6861689229479895], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.12582969957131818`, 0.5137423797505741, 
                   0.457445948631993], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.18874454935697726, 0.7706135696258611, \
0.6861689229479895]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.18874454935697726`, 0.7706135696258611, 
                    0.6861689229479895]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.18874454935697726`, 0.7706135696258611, 0.6861689229479895], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.966908041371008, 0.3760517071812599, 
                    0.7877995523073249], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6446053609140054, 0.25070113812083994`, 
                   0.5251997015382166], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.966908041371008, 0.3760517071812599, \
0.7877995523073249]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.966908041371008, 0.3760517071812599, 
                    0.7877995523073249]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.966908041371008, 0.3760517071812599, 0.7877995523073249], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9588642453966669, 0.9527506615610226, 
                    0.6776685624701353], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6392428302644446, 0.6351671077073484, 
                   0.45177904164675686`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9588642453966669, 0.9527506615610226, \
0.6776685624701353]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9588642453966669, 0.9527506615610226, 
                    0.6776685624701353]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9588642453966669, 0.9527506615610226, 0.6776685624701353], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.07205227832990913, 0.2604184840349075, 
                    0.7583535892561375], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.04803485221993942, 0.17361232268993837`, 
                   0.5055690595040917], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.07205227832990913, 0.2604184840349075, \
0.7583535892561375]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.07205227832990913, 0.2604184840349075, 
                    0.7583535892561375]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.07205227832990913, 0.2604184840349075, 0.7583535892561375], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.18261855057037701`, 0.07377077571605728, 
                    0.9094641871448221], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.12174570038025134`, 0.04918051714403819, 
                   0.6063094580965481], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.18261855057037701, 0.07377077571605728, \
0.9094641871448221]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.18261855057037701`, 0.07377077571605728, 
                    0.9094641871448221]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.18261855057037701`, 0.07377077571605728, 0.9094641871448221], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.039346983610691666`, 0.7887535396336063, 
                    0.6381457731138491], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.026231322407127777`, 0.5258356930890709, 
                   0.42543051540923277`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.039346983610691666, 0.7887535396336063, \
0.6381457731138491]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.039346983610691666`, 0.7887535396336063, 
                    0.6381457731138491]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.039346983610691666`, 0.7887535396336063, 0.6381457731138491], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.36225527252229606`, 0.278577547292733, 
                    0.6267700051472707], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.24150351501486406`, 0.185718364861822, 
                   0.41784667009818044`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.36225527252229606, 0.278577547292733, \
0.6267700051472707]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.36225527252229606`, 0.278577547292733, 
                    0.6267700051472707]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.36225527252229606`, 0.278577547292733, 0.6267700051472707], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.4144548264854313, 0.41726057846332854`, 
                    0.09312404235892613], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2763032176569542, 0.2781737189755524, 
                   0.06208269490595075], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.4144548264854313, 0.41726057846332854, \
0.09312404235892613]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.4144548264854313, 0.41726057846332854`, 
                    0.09312404235892613]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.4144548264854313, 0.41726057846332854`, 0.09312404235892613], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5999183979301403, 0.3848496420691847, 
                    0.11890027599057218`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3999455986200936, 0.2565664280461232, 
                   0.07926685066038146], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5999183979301403, 0.3848496420691847, \
0.11890027599057218]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5999183979301403, 0.3848496420691847, 
                    0.11890027599057218`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5999183979301403, 0.3848496420691847, 0.11890027599057218`], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.1382923672752192, 0.07817846911591331, 
                    0.6881622733139259], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.0921949115168128, 0.052118979410608876`, 
                   0.4587748488759506], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.1382923672752192, 0.07817846911591331, \
0.6881622733139259]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.1382923672752192, 0.07817846911591331, 
                    0.6881622733139259]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.1382923672752192, 0.07817846911591331, 0.6881622733139259], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.24624063780241556`, 0.1800489249080821, 
                    0.32849770905474385`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1641604252016104, 0.12003261660538808`, 
                   0.21899847270316258`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.24624063780241556, 0.1800489249080821, \
0.32849770905474385]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.24624063780241556`, 0.1800489249080821, 
                    0.32849770905474385`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.24624063780241556`, 0.1800489249080821, 0.32849770905474385`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.4685173932872393, 0.020378229002663284`, 
                    0.01003801403355098], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.31234492885815957`, 0.013585486001775523`, 
                   0.0066920093557006535`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.4685173932872393, 0.020378229002663284, \
0.01003801403355098]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.4685173932872393, 0.020378229002663284`, 
                    0.01003801403355098]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.4685173932872393, 0.020378229002663284`, 0.01003801403355098],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.43787702587474797`, 0.026595013928990996`, 
                    0.9451962960693305], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.291918017249832, 0.017730009285993997`, 
                   0.6301308640462204], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.43787702587474797, 0.026595013928990996, \
0.9451962960693305]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.43787702587474797`, 0.026595013928990996`, 
                    0.9451962960693305]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.43787702587474797`, 0.026595013928990996`, 
               0.9451962960693305], Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.10271256838122578`, 0.23402905207107216`, 
                    0.7124690719183648], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.06847504558748385, 0.15601936804738145`, 
                   0.47497938127890993`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.10271256838122578, 0.23402905207107216, \
0.7124690719183648]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.10271256838122578`, 0.23402905207107216`, 
                    0.7124690719183648]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.10271256838122578`, 0.23402905207107216`, 0.7124690719183648],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.13574716529583064`, 0.3852836779210671, 
                    0.18069233382193683`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09049811019722043, 0.2568557852807114, 
                   0.12046155588129123`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.13574716529583064, 0.3852836779210671, \
0.18069233382193683]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.13574716529583064`, 0.3852836779210671, 
                    0.18069233382193683`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.13574716529583064`, 0.3852836779210671, 0.18069233382193683`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6594655586983071, 0.37226694738568766`, 
                    0.10523044882039057`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.43964370579887146`, 0.2481779649237918, 
                   0.07015363254692705], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                
                "RGBColor[0.6594655586983071, 0.37226694738568766, \
0.10523044882039057]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6594655586983071, 0.37226694738568766`, 
                    0.10523044882039057`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6594655586983071, 0.37226694738568766`, 0.10523044882039057`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.3016018675887575, 0.017367768024978636`, 
                    0.02988417913747421], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.20106791172583835`, 0.011578512016652425`, 
                   0.019922786091649474`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.3016018675887575, 0.017367768024978636, \
0.02988417913747421]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.3016018675887575, 0.017367768024978636`, 
                    0.02988417913747421]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.3016018675887575, 0.017367768024978636`, 0.02988417913747421],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.25744605732933556`, 0.0009363281076462115, 
                    0.4144185993777667], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.17163070488622373`, 0.0006242187384308078, 
                   0.2762790662518445], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.25744605732933556, 0.0009363281076462115, \
0.4144185993777667]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.25744605732933556`, 0.0009363281076462115, 
                    0.4144185993777667]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.25744605732933556`, 0.0009363281076462115, 
               0.4144185993777667], Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6774781282708688, 0.34222154687598816`, 
                    0.9702957136604509], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.45165208551391256`, 0.22814769791732545`, 
                   0.6468638091069673], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6774781282708688, 0.34222154687598816, \
0.9702957136604509]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6774781282708688, 0.34222154687598816`, 
                    0.9702957136604509]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6774781282708688, 0.34222154687598816`, 0.9702957136604509], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.25184011467250755`, 0.1424666032202313, 
                    0.08351853989844327], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.16789340978167172`, 0.0949777354801542, 
                   0.05567902659896218], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.25184011467250755, 0.1424666032202313, \
0.08351853989844327]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.25184011467250755`, 0.1424666032202313, 
                    0.08351853989844327]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.25184011467250755`, 0.1424666032202313, 0.08351853989844327], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9626986817854162, 0.4083796328498486, 
                    0.8311777753095406], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6417991211902775, 0.2722530885665657, 0.5541185168730272],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9626986817854162, 0.4083796328498486, \
0.8311777753095406]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9626986817854162, 0.4083796328498486, 
                    0.8311777753095406]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9626986817854162, 0.4083796328498486, 0.8311777753095406], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6370847928517527, 0.9773515931950683, 
                    0.5706929094966902], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4247231952345018, 0.6515677287967122, 0.3804619396644601],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6370847928517527, 0.9773515931950683, \
0.5706929094966902]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6370847928517527, 0.9773515931950683, 
                    0.5706929094966902]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6370847928517527, 0.9773515931950683, 0.5706929094966902], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8798007371690433, 0.2447981806185593, 
                    0.997782208354512], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5865338247793622, 0.16319878707903954`, 
                   0.6651881389030081], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8798007371690433, 0.2447981806185593, \
0.997782208354512]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8798007371690433, 0.2447981806185593, 
                    0.997782208354512]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8798007371690433, 0.2447981806185593, 0.997782208354512], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.369233553307007, 0.625348557118919, 0.3122090291003854], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.24615570220467137`, 0.41689903807927936`, 
                   0.20813935273359027`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.369233553307007, 0.625348557118919, \
0.3122090291003854]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.369233553307007, 0.625348557118919, 0.3122090291003854]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.369233553307007, 0.625348557118919, 0.3122090291003854], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.13515879780744156`, 0.6771272543176945, 
                    0.28193091711950724`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.09010586520496104, 0.4514181695451297, 
                   0.18795394474633817`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.13515879780744156, 0.6771272543176945, \
0.28193091711950724]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.13515879780744156`, 0.6771272543176945, 
                    0.28193091711950724`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.13515879780744156`, 0.6771272543176945, 0.28193091711950724`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9060996386777893, 0.9560202893745733, 
                    0.5085789630160067], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6040664257851929, 0.6373468595830489, 
                   0.33905264201067115`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9060996386777893, 0.9560202893745733, \
0.5085789630160067]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9060996386777893, 0.9560202893745733, 
                    0.5085789630160067]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9060996386777893, 0.9560202893745733, 0.5085789630160067], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7304345932965026, 0.8615882113514635, 
                    0.4099546416922448], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4869563955310018, 0.5743921409009757, 0.2733030944614966],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.7304345932965026, 0.8615882113514635, \
0.4099546416922448]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7304345932965026, 0.8615882113514635, 
                    0.4099546416922448]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7304345932965026, 0.8615882113514635, 0.4099546416922448], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6207885604905226, 0.48777259529831696`, 
                    0.5545109977956224], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.41385904032701504`, 0.32518173019887797`, 
                   0.36967399853041494`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6207885604905226, 0.48777259529831696, \
0.5545109977956224]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6207885604905226, 0.48777259529831696`, 
                    0.5545109977956224]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6207885604905226, 0.48777259529831696`, 0.5545109977956224], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.29599824564873267`, 0.8436302159833555, 
                    0.9412135524152723], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1973321637658218, 0.5624201439889037, 0.6274757016101815],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.29599824564873267, 0.8436302159833555, \
0.9412135524152723]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.29599824564873267`, 0.8436302159833555, 
                    0.9412135524152723]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.29599824564873267`, 0.8436302159833555, 0.9412135524152723], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7909121435518047, 0.6208986403466146, 
                    0.9436735191883905], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5272747623678699, 0.41393242689774307`, 
                   0.629115679458927], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.7909121435518047, 0.6208986403466146, \
0.9436735191883905]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7909121435518047, 0.6208986403466146, 
                    0.9436735191883905]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7909121435518047, 0.6208986403466146, 0.9436735191883905], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.008032831548657304, 0.2176551315452826, 
                    0.7476538249949745], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.0053552210324382035`, 0.14510342103018842`, 
                   0.498435883329983], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.008032831548657304, 0.2176551315452826, \
0.7476538249949745]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.008032831548657304, 0.2176551315452826, 
                    0.7476538249949745]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.008032831548657304, 0.2176551315452826, 0.7476538249949745], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.2434768809769423, 0.013672225061276855`, 
                    0.8698703822171678], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.16231792065129488`, 0.009114816707517903, 
                   0.5799135881447786], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.2434768809769423, 0.013672225061276855, \
0.8698703822171678]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.2434768809769423, 0.013672225061276855`, 
                    0.8698703822171678]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.2434768809769423, 0.013672225061276855`, 0.8698703822171678], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.3491648958878386, 0.7132746264593937, 
                    0.8641994206447752], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2327765972585591, 0.4755164176395958, 0.5761329470965169],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.3491648958878386, 0.7132746264593937, \
0.8641994206447752]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.3491648958878386, 0.7132746264593937, 
                    0.8641994206447752]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.3491648958878386, 0.7132746264593937, 0.8641994206447752], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.08648992316129767, 0.8603044846284271, 
                    0.3652586767874819], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.057659948774198444`, 0.5735363230856181, 
                   0.24350578452498794`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.08648992316129767, 0.8603044846284271, \
0.3652586767874819]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.08648992316129767, 0.8603044846284271, 
                    0.3652586767874819]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.08648992316129767, 0.8603044846284271, 0.3652586767874819], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.21434416032404568`, 0.560445651410233, 
                    0.9235747344420331], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.14289610688269713`, 0.37363043427348863`, 
                   0.6157164896280221], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.21434416032404568, 0.560445651410233, \
0.9235747344420331]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.21434416032404568`, 0.560445651410233, 
                    0.9235747344420331]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.21434416032404568`, 0.560445651410233, 0.9235747344420331], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6641969362359714, 0.8844412534660229, 
                    0.7597163627298724], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.44279795749064765`, 0.589627502310682, 
                   0.5064775751532483], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6641969362359714, 0.8844412534660229, \
0.7597163627298724]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6641969362359714, 0.8844412534660229, 
                    0.7597163627298724]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6641969362359714, 0.8844412534660229, 0.7597163627298724], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7835349571323893, 0.7177206084208989, 
                    0.9443621603773193], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5223566380882596, 0.4784804056139326, 0.6295747735848796],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.7835349571323893, 0.7177206084208989, \
0.9443621603773193]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7835349571323893, 0.7177206084208989, 
                    0.9443621603773193]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7835349571323893, 0.7177206084208989, 0.9443621603773193], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.4063999909281031, 0.1560001127426507, 
                    0.9791487175568574], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.2709333272854021, 0.10400007516176712`, 
                   0.6527658117045716], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.4063999909281031, 0.1560001127426507, \
0.9791487175568574]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.4063999909281031, 0.1560001127426507, 
                    0.9791487175568574]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.4063999909281031, 0.1560001127426507, 0.9791487175568574], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.1982275401878799, 0.5018874444551371, 
                    0.7126747022344182], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.13215169345858663`, 0.3345916296367581, 
                   0.47511646815627884`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.1982275401878799, 0.5018874444551371, \
0.7126747022344182]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.1982275401878799, 0.5018874444551371, 
                    0.7126747022344182]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.1982275401878799, 0.5018874444551371, 0.7126747022344182], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.46389356907610657`, 0.9899568793510354, 
                    0.18282549555593763`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.3092623793840711, 0.6599712529006903, 
                   0.12188366370395842`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.46389356907610657, 0.9899568793510354, \
0.18282549555593763]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.46389356907610657`, 0.9899568793510354, 
                    0.18282549555593763`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.46389356907610657`, 0.9899568793510354, 0.18282549555593763`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.7965448575036715, 0.2203076940626465, 
                    0.8028855805437274], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5310299050024477, 0.14687179604176434`, 
                   0.5352570536958183], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                
                "RGBColor[0.7965448575036715, 0.2203076940626465, \
0.8028855805437274]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.7965448575036715, 0.2203076940626465, 
                    0.8028855805437274]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.7965448575036715, 0.2203076940626465, 0.8028855805437274], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9902733343532162, 0.25606104429275356`, 
                    0.3849896405954891], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6601822229021441, 0.17070736286183572`, 
                   0.2566597603969928], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9902733343532162, 0.25606104429275356, \
0.3849896405954891]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9902733343532162, 0.25606104429275356`, 
                    0.3849896405954891]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9902733343532162, 0.25606104429275356`, 0.3849896405954891], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6221007700303403, 0.01765127658624177, 
                    0.22098467649124798`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4147338466868935, 0.01176751772416118, 0.147323117660832],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6221007700303403, 0.01765127658624177, \
0.22098467649124798]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6221007700303403, 0.01765127658624177, 
                    0.22098467649124798`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6221007700303403, 0.01765127658624177, 0.22098467649124798`], 
              Editable -> False, Selectable -> False]}, {
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.8215044522625461, 0.16572454783069857`, 
                    0.8040773618551336], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.5476696348416974, 0.11048303188713238`, 
                   0.5360515745700891], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.8215044522625461, 0.16572454783069857, \
0.8040773618551336]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.8215044522625461, 0.16572454783069857`, 
                    0.8040773618551336]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.8215044522625461, 0.16572454783069857`, 0.8040773618551336], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.24921899792850022`, 0.2759862741314656, 
                    0.9867270641108767], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.16614599861900015`, 0.18399084942097707`, 
                   0.6578180427405845], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.24921899792850022, 0.2759862741314656, \
0.9867270641108767]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.24921899792850022`, 0.2759862741314656, 
                    0.9867270641108767]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.24921899792850022`, 0.2759862741314656, 0.9867270641108767], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.9705600763758861, 0.6579222578247919, 
                    0.09801587123491529], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.6470400509172575, 0.4386148385498613, 0.0653439141566102],
                  FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.9705600763758861, 0.6579222578247919, \
0.09801587123491529]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.9705600763758861, 0.6579222578247919, 
                    0.09801587123491529]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.9705600763758861, 0.6579222578247919, 0.09801587123491529], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.5219662481223741, 0.14969988943827683`, 
                    0.21533096883363356`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.34797749874824946`, 0.09979992629218457, 
                   0.14355397922242238`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.5219662481223741, 0.14969988943827683, \
0.21533096883363356]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.5219662481223741, 0.14969988943827683`, 
                    0.21533096883363356`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.5219662481223741, 0.14969988943827683`, 0.21533096883363356`],
               Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.2385598894514005, 0.420472814737084, 
                    0.06616306125117433], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.15903992630093367`, 0.2803152098247227, 
                   0.044108707500782884`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.2385598894514005, 0.420472814737084, \
0.06616306125117433]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.2385598894514005, 0.420472814737084, 
                    0.06616306125117433]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.2385598894514005, 0.420472814737084, 0.06616306125117433], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6189105535277344, 0.492652144492848, 
                    0.2548520338813385], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4126070356851563, 0.328434762995232, 
                   0.16990135592089234`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6189105535277344, 0.492652144492848, \
0.2548520338813385]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6189105535277344, 0.492652144492848, 
                    0.2548520338813385]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6189105535277344, 0.492652144492848, 0.2548520338813385], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.2540039550834856, 0.25090544958492833`, 
                    0.7402121254547946], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.1693359700556571, 0.16727029972328555`, 
                   0.49347475030319643`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.2540039550834856, 0.25090544958492833, \
0.7402121254547946]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.2540039550834856, 0.25090544958492833`, 
                    0.7402121254547946]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.2540039550834856, 0.25090544958492833`, 0.7402121254547946], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.033513046184048045`, 0.1728855219836134, 
                    0.026644850308877865`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.022342030789365364`, 0.11525701465574227`, 
                   0.01776323353925191], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.033513046184048045, 0.1728855219836134, \
0.026644850308877865]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.033513046184048045`, 0.1728855219836134, 
                    0.026644850308877865`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.033513046184048045`, 0.1728855219836134, 
               0.026644850308877865`], Editable -> False, Selectable -> 
              False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.6444793017816008, 0.8547066417937763, 
                    0.3474794538334989], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.4296528678544006, 0.5698044278625176, 
                   0.23165296922233258`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.6444793017816008, 0.8547066417937763, \
0.3474794538334989]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.6444793017816008, 0.8547066417937763, 
                    0.3474794538334989]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.6444793017816008, 0.8547066417937763, 0.3474794538334989], 
              Editable -> False, Selectable -> False], 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}, {{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}, {{
                    RGBColor[
                    0.16105684440590573`, 0.0715923354102661, 
                    0.15942531715860908`], 
                    RectangleBox[{0, -1}, {2, 1}]}}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> 
                 RGBColor[
                  0.10737122960393716`, 0.047728223606844075`, 
                   0.10628354477240606`], FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[0.16105684440590573, 0.0715923354102661, \
0.15942531715860908]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[
                    0.16105684440590573`, 0.0715923354102661, 
                    0.15942531715860908`]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
              0.16105684440590573`, 0.0715923354102661, 0.15942531715860908`],
               Editable -> False, Selectable -> False]}}, AutoDelete -> False,
            GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"832836f2-7701-453f-a18e-0eccf2dfa85c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10 grid of randomly colored random integers between 0 and \
10.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"64c748c5-39d6-48d9-be5b-f236f1a5484c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9461467349525237, 0.9752200744900494, 0.19630670101161773`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9461467349525237, 0.9752200744900494, 0.19630670101161773`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9461467349525237, 0.9752200744900494, 0.19630670101161773`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9461467349525237, 0.9752200744900494, 0.19630670101161773`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9461467349525237, 0.9752200744900494, 0.19630670101161773`]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.24862792604144546`, 0.10752227432523398`, 0.6284978478989733],
            $CellContext`LineColor -> 
            RGBColor[
             0.24862792604144546`, 0.10752227432523398`, 0.6284978478989733],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.24862792604144546`, 0.10752227432523398`, 0.6284978478989733],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.24862792604144546`, 0.10752227432523398`, 0.6284978478989733],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.24862792604144546`, 0.10752227432523398`, 0.6284978478989733]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5577242692112141, 0.34287121714349755`, 0.2552940774745578],
            $CellContext`LineColor -> 
            RGBColor[
             0.5577242692112141, 0.34287121714349755`, 0.2552940774745578],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5577242692112141, 0.34287121714349755`, 0.2552940774745578],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5577242692112141, 0.34287121714349755`, 0.2552940774745578],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5577242692112141, 0.34287121714349755`, 0.2552940774745578]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8911014201279688, 0.667257718702293, 0.3358155219068655],
            $CellContext`LineColor -> 
            RGBColor[
             0.8911014201279688, 0.667257718702293, 0.3358155219068655],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8911014201279688, 0.667257718702293, 0.3358155219068655],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8911014201279688, 0.667257718702293, 0.3358155219068655],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8911014201279688, 0.667257718702293, 0.3358155219068655]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7080697952195558, 0.07689036146549544, 0.8267118890836695],
            $CellContext`LineColor -> 
            RGBColor[
             0.7080697952195558, 0.07689036146549544, 0.8267118890836695],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7080697952195558, 0.07689036146549544, 0.8267118890836695],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7080697952195558, 0.07689036146549544, 0.8267118890836695],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7080697952195558, 0.07689036146549544, 0.8267118890836695]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.027665312825819743`, 0.7425419473198636, 0.00656630187248175],
            $CellContext`LineColor -> 
            RGBColor[
             0.027665312825819743`, 0.7425419473198636, 0.00656630187248175],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.027665312825819743`, 0.7425419473198636, 0.00656630187248175],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.027665312825819743`, 0.7425419473198636, 0.00656630187248175],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.027665312825819743`, 0.7425419473198636, 0.00656630187248175]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.606034112396058, 0.6972735779098382, 0.10138670408872796`],
            $CellContext`LineColor -> 
            RGBColor[
             0.606034112396058, 0.6972735779098382, 0.10138670408872796`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.606034112396058, 0.6972735779098382, 0.10138670408872796`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.606034112396058, 0.6972735779098382, 0.10138670408872796`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.606034112396058, 0.6972735779098382, 0.10138670408872796`]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.27245718157209753`, 0.05781970854035512, 
              0.19546728000367297`],
            $CellContext`LineColor -> 
            RGBColor[
             0.27245718157209753`, 0.05781970854035512, 
              0.19546728000367297`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.27245718157209753`, 0.05781970854035512, 
              0.19546728000367297`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.27245718157209753`, 0.05781970854035512, 
              0.19546728000367297`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.27245718157209753`, 0.05781970854035512, 0.19546728000367297`]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8887562069308925, 0.6480727815008511, 0.4280340962886071],
            $CellContext`LineColor -> 
            RGBColor[
             0.8887562069308925, 0.6480727815008511, 0.4280340962886071],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8887562069308925, 0.6480727815008511, 0.4280340962886071],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8887562069308925, 0.6480727815008511, 0.4280340962886071],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8887562069308925, 0.6480727815008511, 0.4280340962886071]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8178725992446179, 0.6838381891757823, 0.98587469856858],
            $CellContext`LineColor -> 
            RGBColor[0.8178725992446179, 0.6838381891757823, 0.98587469856858],
            $CellContext`FrontFaceColor -> 
            RGBColor[0.8178725992446179, 0.6838381891757823, 0.98587469856858],
            $CellContext`GraphicsColor -> 
            RGBColor[0.8178725992446179, 0.6838381891757823, 0.98587469856858],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8178725992446179, 0.6838381891757823, 0.98587469856858]]},
          {
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.948287583327043, 0.14175505784617415`, 0.00731626581980005],
            $CellContext`LineColor -> 
            RGBColor[
             0.948287583327043, 0.14175505784617415`, 0.00731626581980005],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.948287583327043, 0.14175505784617415`, 0.00731626581980005],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.948287583327043, 0.14175505784617415`, 0.00731626581980005],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.948287583327043, 0.14175505784617415`, 0.00731626581980005]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.46424273235297564`, 0.7221685214118281, 0.8544083499680859],
            $CellContext`LineColor -> 
            RGBColor[
             0.46424273235297564`, 0.7221685214118281, 0.8544083499680859],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.46424273235297564`, 0.7221685214118281, 0.8544083499680859],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.46424273235297564`, 0.7221685214118281, 0.8544083499680859],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.46424273235297564`, 0.7221685214118281, 0.8544083499680859]], 
           StyleBox["6",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.009308639554695963, 0.1937737430459885, 0.3031947935928969],
            $CellContext`LineColor -> 
            RGBColor[
             0.009308639554695963, 0.1937737430459885, 0.3031947935928969],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.009308639554695963, 0.1937737430459885, 0.3031947935928969],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.009308639554695963, 0.1937737430459885, 0.3031947935928969],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.009308639554695963, 0.1937737430459885, 0.3031947935928969]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5126802201898331, 0.3260783135097931, 0.004357349503499641],
            $CellContext`LineColor -> 
            RGBColor[
             0.5126802201898331, 0.3260783135097931, 0.004357349503499641],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5126802201898331, 0.3260783135097931, 0.004357349503499641],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5126802201898331, 0.3260783135097931, 0.004357349503499641],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5126802201898331, 0.3260783135097931, 0.004357349503499641]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9970148325582657, 0.6457158495033748, 0.0034257753873956354`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9970148325582657, 0.6457158495033748, 0.0034257753873956354`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9970148325582657, 0.6457158495033748, 0.0034257753873956354`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9970148325582657, 0.6457158495033748, 0.0034257753873956354`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9970148325582657, 0.6457158495033748, 0.0034257753873956354`]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5324151103899413, 0.41403462759890486`, 0.07569077746572583],
            $CellContext`LineColor -> 
            RGBColor[
             0.5324151103899413, 0.41403462759890486`, 0.07569077746572583],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5324151103899413, 0.41403462759890486`, 0.07569077746572583],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5324151103899413, 0.41403462759890486`, 0.07569077746572583],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5324151103899413, 0.41403462759890486`, 0.07569077746572583]], 
           
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8096045605413051, 0.3489371675588504, 0.33933608231400525`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8096045605413051, 0.3489371675588504, 0.33933608231400525`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8096045605413051, 0.3489371675588504, 0.33933608231400525`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8096045605413051, 0.3489371675588504, 0.33933608231400525`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8096045605413051, 0.3489371675588504, 0.33933608231400525`]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9778447780789905, 0.9716634431212376, 0.5945749667664826],
            $CellContext`LineColor -> 
            RGBColor[
             0.9778447780789905, 0.9716634431212376, 0.5945749667664826],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9778447780789905, 0.9716634431212376, 0.5945749667664826],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9778447780789905, 0.9716634431212376, 0.5945749667664826],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9778447780789905, 0.9716634431212376, 0.5945749667664826]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6594544323034284, 0.2624963496378694, 0.6393244421041806],
            $CellContext`LineColor -> 
            RGBColor[
             0.6594544323034284, 0.2624963496378694, 0.6393244421041806],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6594544323034284, 0.2624963496378694, 0.6393244421041806],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6594544323034284, 0.2624963496378694, 0.6393244421041806],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6594544323034284, 0.2624963496378694, 0.6393244421041806]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5800459142067347, 0.039144998205196346`, 
              0.20068320974760434`],
            $CellContext`LineColor -> 
            RGBColor[
             0.5800459142067347, 0.039144998205196346`, 
              0.20068320974760434`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5800459142067347, 0.039144998205196346`, 
              0.20068320974760434`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5800459142067347, 0.039144998205196346`, 
              0.20068320974760434`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5800459142067347, 0.039144998205196346`, 0.20068320974760434`]]},
          {
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.809456702168398, 0.8613804068894142, 0.0017448064442096012`],
            $CellContext`LineColor -> 
            RGBColor[
             0.809456702168398, 0.8613804068894142, 0.0017448064442096012`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.809456702168398, 0.8613804068894142, 0.0017448064442096012`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.809456702168398, 0.8613804068894142, 0.0017448064442096012`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.809456702168398, 0.8613804068894142, 0.0017448064442096012`]], 
           
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.627497505287832, 0.5392505117413575, 0.43312921294442885`],
            $CellContext`LineColor -> 
            RGBColor[
             0.627497505287832, 0.5392505117413575, 0.43312921294442885`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.627497505287832, 0.5392505117413575, 0.43312921294442885`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.627497505287832, 0.5392505117413575, 0.43312921294442885`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.627497505287832, 0.5392505117413575, 0.43312921294442885`]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.10120063621760655`, 0.25628323420464705`, 0.6339512643839103],
            $CellContext`LineColor -> 
            RGBColor[
             0.10120063621760655`, 0.25628323420464705`, 0.6339512643839103],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.10120063621760655`, 0.25628323420464705`, 0.6339512643839103],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.10120063621760655`, 0.25628323420464705`, 0.6339512643839103],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.10120063621760655`, 0.25628323420464705`, 0.6339512643839103]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7832250203431665, 0.9900380468162264, 0.7581154658055032],
            $CellContext`LineColor -> 
            RGBColor[
             0.7832250203431665, 0.9900380468162264, 0.7581154658055032],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7832250203431665, 0.9900380468162264, 0.7581154658055032],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7832250203431665, 0.9900380468162264, 0.7581154658055032],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7832250203431665, 0.9900380468162264, 0.7581154658055032]], 
           StyleBox["3",
            StripOnInput->False,
            FontColor->RGBColor[
             0.984005422552072, 0.025943636625120448`, 0.7182075726398491],
            $CellContext`LineColor -> 
            RGBColor[
             0.984005422552072, 0.025943636625120448`, 0.7182075726398491],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.984005422552072, 0.025943636625120448`, 0.7182075726398491],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.984005422552072, 0.025943636625120448`, 0.7182075726398491],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.984005422552072, 0.025943636625120448`, 0.7182075726398491]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.0812116328515613, 0.6583948944761258, 0.6472372017186556],
            $CellContext`LineColor -> 
            RGBColor[
             0.0812116328515613, 0.6583948944761258, 0.6472372017186556],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.0812116328515613, 0.6583948944761258, 0.6472372017186556],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.0812116328515613, 0.6583948944761258, 0.6472372017186556],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.0812116328515613, 0.6583948944761258, 0.6472372017186556]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.014674940533907277`, 0.8268676217182933, 0.6804510359737441],
            $CellContext`LineColor -> 
            RGBColor[
             0.014674940533907277`, 0.8268676217182933, 0.6804510359737441],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.014674940533907277`, 0.8268676217182933, 0.6804510359737441],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.014674940533907277`, 0.8268676217182933, 0.6804510359737441],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.014674940533907277`, 0.8268676217182933, 0.6804510359737441]], 
           
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.0406819180326099, 0.43662118686186235`, 0.6736195772935563],
            $CellContext`LineColor -> 
            RGBColor[
             0.0406819180326099, 0.43662118686186235`, 0.6736195772935563],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.0406819180326099, 0.43662118686186235`, 0.6736195772935563],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.0406819180326099, 0.43662118686186235`, 0.6736195772935563],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.0406819180326099, 0.43662118686186235`, 0.6736195772935563]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.25609755740069917`, 0.7406079377913801, 0.9126976796897188],
            $CellContext`LineColor -> 
            RGBColor[
             0.25609755740069917`, 0.7406079377913801, 0.9126976796897188],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.25609755740069917`, 0.7406079377913801, 0.9126976796897188],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.25609755740069917`, 0.7406079377913801, 0.9126976796897188],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.25609755740069917`, 0.7406079377913801, 0.9126976796897188]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9989451027279306, 0.8918995665419438, 0.3253043923332035],
            $CellContext`LineColor -> 
            RGBColor[
             0.9989451027279306, 0.8918995665419438, 0.3253043923332035],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9989451027279306, 0.8918995665419438, 0.3253043923332035],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9989451027279306, 0.8918995665419438, 0.3253043923332035],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9989451027279306, 0.8918995665419438, 0.3253043923332035]]},
          {
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.27365484763105963`, 0.6046137803657607, 0.8638807440074829],
            $CellContext`LineColor -> 
            RGBColor[
             0.27365484763105963`, 0.6046137803657607, 0.8638807440074829],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.27365484763105963`, 0.6046137803657607, 0.8638807440074829],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.27365484763105963`, 0.6046137803657607, 0.8638807440074829],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.27365484763105963`, 0.6046137803657607, 0.8638807440074829]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7140610547451831, 0.030518350727399612`, 0.8082951288449898],
            $CellContext`LineColor -> 
            RGBColor[
             0.7140610547451831, 0.030518350727399612`, 0.8082951288449898],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7140610547451831, 0.030518350727399612`, 0.8082951288449898],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7140610547451831, 0.030518350727399612`, 0.8082951288449898],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7140610547451831, 0.030518350727399612`, 0.8082951288449898]], 
           
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5745494386823653, 0.7384408056471385, 0.2643373081031448],
            $CellContext`LineColor -> 
            RGBColor[
             0.5745494386823653, 0.7384408056471385, 0.2643373081031448],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5745494386823653, 0.7384408056471385, 0.2643373081031448],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5745494386823653, 0.7384408056471385, 0.2643373081031448],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5745494386823653, 0.7384408056471385, 0.2643373081031448]], 
           StyleBox["8",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8667697929441776, 0.9198053148749128, 0.5369963891267786],
            $CellContext`LineColor -> 
            RGBColor[
             0.8667697929441776, 0.9198053148749128, 0.5369963891267786],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8667697929441776, 0.9198053148749128, 0.5369963891267786],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8667697929441776, 0.9198053148749128, 0.5369963891267786],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8667697929441776, 0.9198053148749128, 0.5369963891267786]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6547934542020757, 0.34568757203723344`, 0.1915604303533598],
            $CellContext`LineColor -> 
            RGBColor[
             0.6547934542020757, 0.34568757203723344`, 0.1915604303533598],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6547934542020757, 0.34568757203723344`, 0.1915604303533598],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6547934542020757, 0.34568757203723344`, 0.1915604303533598],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6547934542020757, 0.34568757203723344`, 0.1915604303533598]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.3536845882195143, 0.051291744342369716`, 
              0.22839590801490783`],
            $CellContext`LineColor -> 
            RGBColor[
             0.3536845882195143, 0.051291744342369716`, 
              0.22839590801490783`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3536845882195143, 0.051291744342369716`, 
              0.22839590801490783`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3536845882195143, 0.051291744342369716`, 
              0.22839590801490783`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3536845882195143, 0.051291744342369716`, 0.22839590801490783`]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.42166657491651094`, 0.7802161313198828, 0.5826318538039614],
            $CellContext`LineColor -> 
            RGBColor[
             0.42166657491651094`, 0.7802161313198828, 0.5826318538039614],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.42166657491651094`, 0.7802161313198828, 0.5826318538039614],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.42166657491651094`, 0.7802161313198828, 0.5826318538039614],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.42166657491651094`, 0.7802161313198828, 0.5826318538039614]], 
           StyleBox["8",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.24600378313974613`, 0.7191799874553491, 0.36075513314509],
            $CellContext`LineColor -> 
            RGBColor[
             0.24600378313974613`, 0.7191799874553491, 0.36075513314509],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.24600378313974613`, 0.7191799874553491, 0.36075513314509],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.24600378313974613`, 0.7191799874553491, 0.36075513314509],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.24600378313974613`, 0.7191799874553491, 0.36075513314509]], 
           StyleBox["8",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.04153594448002207, 0.4295960077561829, 0.847024283745778],
            $CellContext`LineColor -> 
            RGBColor[
             0.04153594448002207, 0.4295960077561829, 0.847024283745778],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.04153594448002207, 0.4295960077561829, 0.847024283745778],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.04153594448002207, 0.4295960077561829, 0.847024283745778],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.04153594448002207, 0.4295960077561829, 0.847024283745778]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6720355615791775, 0.43184298014526723`, 0.12285359878468483`],
            $CellContext`LineColor -> 
            RGBColor[
             0.6720355615791775, 0.43184298014526723`, 0.12285359878468483`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6720355615791775, 0.43184298014526723`, 0.12285359878468483`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6720355615791775, 0.43184298014526723`, 0.12285359878468483`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6720355615791775, 0.43184298014526723`, 0.12285359878468483`]]},
          {
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.522446535047915, 0.5474331079194232, 0.47991443778567167`],
            $CellContext`LineColor -> 
            RGBColor[
             0.522446535047915, 0.5474331079194232, 0.47991443778567167`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.522446535047915, 0.5474331079194232, 0.47991443778567167`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.522446535047915, 0.5474331079194232, 0.47991443778567167`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.522446535047915, 0.5474331079194232, 0.47991443778567167`]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8110677449162669, 0.3950293657968842, 0.6055767877474503],
            $CellContext`LineColor -> 
            RGBColor[
             0.8110677449162669, 0.3950293657968842, 0.6055767877474503],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8110677449162669, 0.3950293657968842, 0.6055767877474503],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8110677449162669, 0.3950293657968842, 0.6055767877474503],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8110677449162669, 0.3950293657968842, 0.6055767877474503]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8697449557870209, 0.24307066135409916`, 0.43571293536486344`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8697449557870209, 0.24307066135409916`, 0.43571293536486344`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8697449557870209, 0.24307066135409916`, 0.43571293536486344`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8697449557870209, 0.24307066135409916`, 0.43571293536486344`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8697449557870209, 0.24307066135409916`, 0.43571293536486344`]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.14207115218954725`, 0.027609462042487598`, 
              0.26538200115859434`],
            $CellContext`LineColor -> 
            RGBColor[
             0.14207115218954725`, 0.027609462042487598`, 
              0.26538200115859434`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.14207115218954725`, 0.027609462042487598`, 
              0.26538200115859434`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.14207115218954725`, 0.027609462042487598`, 
              0.26538200115859434`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.14207115218954725`, 0.027609462042487598`, 
              0.26538200115859434`]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8971343715353424, 0.9172966585784836, 0.34560737157623045`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8971343715353424, 0.9172966585784836, 0.34560737157623045`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8971343715353424, 0.9172966585784836, 0.34560737157623045`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8971343715353424, 0.9172966585784836, 0.34560737157623045`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8971343715353424, 0.9172966585784836, 0.34560737157623045`]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9275408690877258, 0.756890095732438, 0.4582415405661542],
            $CellContext`LineColor -> 
            RGBColor[
             0.9275408690877258, 0.756890095732438, 0.4582415405661542],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9275408690877258, 0.756890095732438, 0.4582415405661542],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9275408690877258, 0.756890095732438, 0.4582415405661542],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9275408690877258, 0.756890095732438, 0.4582415405661542]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8811128075486427, 0.6440403427494257, 0.26634002155557956`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8811128075486427, 0.6440403427494257, 0.26634002155557956`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8811128075486427, 0.6440403427494257, 0.26634002155557956`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8811128075486427, 0.6440403427494257, 0.26634002155557956`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8811128075486427, 0.6440403427494257, 0.26634002155557956`]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.4801055603613329, 0.34718962495427186`, 0.8000917595328458],
            $CellContext`LineColor -> 
            RGBColor[
             0.4801055603613329, 0.34718962495427186`, 0.8000917595328458],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4801055603613329, 0.34718962495427186`, 0.8000917595328458],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4801055603613329, 0.34718962495427186`, 0.8000917595328458],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4801055603613329, 0.34718962495427186`, 0.8000917595328458]], 
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.2593665209586269, 0.11701852565272874`, 0.838828303544338],
            $CellContext`LineColor -> 
            RGBColor[
             0.2593665209586269, 0.11701852565272874`, 0.838828303544338],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2593665209586269, 0.11701852565272874`, 0.838828303544338],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2593665209586269, 0.11701852565272874`, 0.838828303544338],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2593665209586269, 0.11701852565272874`, 0.838828303544338]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.24597310847468523`, 0.05421201013519816, 0.4303003765685125],
            $CellContext`LineColor -> 
            RGBColor[
             0.24597310847468523`, 0.05421201013519816, 0.4303003765685125],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.24597310847468523`, 0.05421201013519816, 0.4303003765685125],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.24597310847468523`, 0.05421201013519816, 0.4303003765685125],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.24597310847468523`, 0.05421201013519816, 
              0.4303003765685125]]},
          {
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5552222322113358, 0.8779570216992596, 0.5715574788068376],
            $CellContext`LineColor -> 
            RGBColor[
             0.5552222322113358, 0.8779570216992596, 0.5715574788068376],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5552222322113358, 0.8779570216992596, 0.5715574788068376],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5552222322113358, 0.8779570216992596, 0.5715574788068376],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5552222322113358, 0.8779570216992596, 0.5715574788068376]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.41333836047323524`, 0.9651114898010289, 
              0.025766292499096455`],
            $CellContext`LineColor -> 
            RGBColor[
             0.41333836047323524`, 0.9651114898010289, 
              0.025766292499096455`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.41333836047323524`, 0.9651114898010289, 
              0.025766292499096455`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.41333836047323524`, 0.9651114898010289, 
              0.025766292499096455`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.41333836047323524`, 0.9651114898010289, 0.025766292499096455`]], 
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.2757668263570803, 0.4708435271405127, 0.17221931665505585`],
            $CellContext`LineColor -> 
            RGBColor[
             0.2757668263570803, 0.4708435271405127, 0.17221931665505585`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2757668263570803, 0.4708435271405127, 0.17221931665505585`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2757668263570803, 0.4708435271405127, 0.17221931665505585`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2757668263570803, 0.4708435271405127, 0.17221931665505585`]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9272633727519812, 0.3677940048968156, 0.2633176871475038],
            $CellContext`LineColor -> 
            RGBColor[
             0.9272633727519812, 0.3677940048968156, 0.2633176871475038],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9272633727519812, 0.3677940048968156, 0.2633176871475038],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9272633727519812, 0.3677940048968156, 0.2633176871475038],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9272633727519812, 0.3677940048968156, 0.2633176871475038]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8490240358437848, 0.3793156412678107, 0.7367342472483607],
            $CellContext`LineColor -> 
            RGBColor[
             0.8490240358437848, 0.3793156412678107, 0.7367342472483607],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8490240358437848, 0.3793156412678107, 0.7367342472483607],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8490240358437848, 0.3793156412678107, 0.7367342472483607],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8490240358437848, 0.3793156412678107, 0.7367342472483607]], 
           StyleBox["5",
            StripOnInput->False,
            FontColor->RGBColor[
             0.764011232824358, 0.4620426592484266, 0.06359115748085631],
            $CellContext`LineColor -> 
            RGBColor[
             0.764011232824358, 0.4620426592484266, 0.06359115748085631],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.764011232824358, 0.4620426592484266, 0.06359115748085631],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.764011232824358, 0.4620426592484266, 0.06359115748085631],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.764011232824358, 0.4620426592484266, 0.06359115748085631]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.16965924759224515`, 0.1167639581098534, 0.6149163489817344],
            $CellContext`LineColor -> 
            RGBColor[
             0.16965924759224515`, 0.1167639581098534, 0.6149163489817344],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.16965924759224515`, 0.1167639581098534, 0.6149163489817344],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.16965924759224515`, 0.1167639581098534, 0.6149163489817344],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.16965924759224515`, 0.1167639581098534, 0.6149163489817344]], 
           StyleBox["8",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.1464813808433978, 0.49375914734255955`, 0.5732323241550707],
            $CellContext`LineColor -> 
            RGBColor[
             0.1464813808433978, 0.49375914734255955`, 0.5732323241550707],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.1464813808433978, 0.49375914734255955`, 0.5732323241550707],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.1464813808433978, 0.49375914734255955`, 0.5732323241550707],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.1464813808433978, 0.49375914734255955`, 0.5732323241550707]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5193246130548013, 0.9818127150690881, 0.39080997439317366`],
            $CellContext`LineColor -> 
            RGBColor[
             0.5193246130548013, 0.9818127150690881, 0.39080997439317366`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5193246130548013, 0.9818127150690881, 0.39080997439317366`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5193246130548013, 0.9818127150690881, 0.39080997439317366`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5193246130548013, 0.9818127150690881, 0.39080997439317366`]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.3972094283962493, 0.22599553480358492`, 0.14955155902184702`],
            $CellContext`LineColor -> 
            RGBColor[
             0.3972094283962493, 0.22599553480358492`, 0.14955155902184702`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3972094283962493, 0.22599553480358492`, 0.14955155902184702`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3972094283962493, 0.22599553480358492`, 0.14955155902184702`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3972094283962493, 0.22599553480358492`, 0.14955155902184702`]]},
          {
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.4255610025893479, 0.028838238600754407`, 0.8215318131536475],
            $CellContext`LineColor -> 
            RGBColor[
             0.4255610025893479, 0.028838238600754407`, 0.8215318131536475],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4255610025893479, 0.028838238600754407`, 0.8215318131536475],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4255610025893479, 0.028838238600754407`, 0.8215318131536475],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4255610025893479, 0.028838238600754407`, 0.8215318131536475]], 
           
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.47829917859486293`, 0.3692630472281002, 0.787076034780892],
            $CellContext`LineColor -> 
            RGBColor[
             0.47829917859486293`, 0.3692630472281002, 0.787076034780892],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.47829917859486293`, 0.3692630472281002, 0.787076034780892],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.47829917859486293`, 0.3692630472281002, 0.787076034780892],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.47829917859486293`, 0.3692630472281002, 0.787076034780892]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8135270572353626, 0.9674421000297233, 0.6956662366442121],
            $CellContext`LineColor -> 
            RGBColor[
             0.8135270572353626, 0.9674421000297233, 0.6956662366442121],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8135270572353626, 0.9674421000297233, 0.6956662366442121],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8135270572353626, 0.9674421000297233, 0.6956662366442121],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8135270572353626, 0.9674421000297233, 0.6956662366442121]], 
           StyleBox["6",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5253658393725205, 0.6339916899893867, 0.04488276040604067],
            $CellContext`LineColor -> 
            RGBColor[
             0.5253658393725205, 0.6339916899893867, 0.04488276040604067],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5253658393725205, 0.6339916899893867, 0.04488276040604067],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5253658393725205, 0.6339916899893867, 0.04488276040604067],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5253658393725205, 0.6339916899893867, 0.04488276040604067]], 
           StyleBox["6",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6944170953403732, 0.4739637553473215, 0.3357126174893543],
            $CellContext`LineColor -> 
            RGBColor[
             0.6944170953403732, 0.4739637553473215, 0.3357126174893543],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6944170953403732, 0.4739637553473215, 0.3357126174893543],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6944170953403732, 0.4739637553473215, 0.3357126174893543],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6944170953403732, 0.4739637553473215, 0.3357126174893543]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7006482406140371, 0.44578561844912024`, 0.5276468465249675],
            $CellContext`LineColor -> 
            RGBColor[
             0.7006482406140371, 0.44578561844912024`, 0.5276468465249675],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7006482406140371, 0.44578561844912024`, 0.5276468465249675],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7006482406140371, 0.44578561844912024`, 0.5276468465249675],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7006482406140371, 0.44578561844912024`, 0.5276468465249675]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.2376037044941619, 0.6660728193217682, 0.6882966911786483],
            $CellContext`LineColor -> 
            RGBColor[
             0.2376037044941619, 0.6660728193217682, 0.6882966911786483],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2376037044941619, 0.6660728193217682, 0.6882966911786483],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2376037044941619, 0.6660728193217682, 0.6882966911786483],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2376037044941619, 0.6660728193217682, 0.6882966911786483]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.45179211479788917`, 0.11530364505964963`, 0.11656645908225727`],
            $CellContext`LineColor -> 
            RGBColor[
             0.45179211479788917`, 0.11530364505964963`, 0.11656645908225727`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.45179211479788917`, 0.11530364505964963`, 0.11656645908225727`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.45179211479788917`, 0.11530364505964963`, 0.11656645908225727`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.45179211479788917`, 0.11530364505964963`, 
              0.11656645908225727`]], 
           StyleBox["8",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9966829670058455, 0.6100039695526365, 0.5925615551877714],
            $CellContext`LineColor -> 
            RGBColor[
             0.9966829670058455, 0.6100039695526365, 0.5925615551877714],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9966829670058455, 0.6100039695526365, 0.5925615551877714],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9966829670058455, 0.6100039695526365, 0.5925615551877714],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9966829670058455, 0.6100039695526365, 0.5925615551877714]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.3960605570071172, 0.21554356288569498`, 0.5302856894450105],
            $CellContext`LineColor -> 
            RGBColor[
             0.3960605570071172, 0.21554356288569498`, 0.5302856894450105],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3960605570071172, 0.21554356288569498`, 0.5302856894450105],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3960605570071172, 0.21554356288569498`, 0.5302856894450105],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3960605570071172, 0.21554356288569498`, 0.5302856894450105]]},
          {
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.42402328059466954`, 0.8473902288484125, 0.8437773753067899],
            $CellContext`LineColor -> 
            RGBColor[
             0.42402328059466954`, 0.8473902288484125, 0.8437773753067899],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.42402328059466954`, 0.8473902288484125, 0.8437773753067899],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.42402328059466954`, 0.8473902288484125, 0.8437773753067899],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.42402328059466954`, 0.8473902288484125, 0.8437773753067899]], 
           StyleBox["6",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7910788456341271, 0.6410850968955306, 0.9187183876881484],
            $CellContext`LineColor -> 
            RGBColor[
             0.7910788456341271, 0.6410850968955306, 0.9187183876881484],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7910788456341271, 0.6410850968955306, 0.9187183876881484],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7910788456341271, 0.6410850968955306, 0.9187183876881484],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7910788456341271, 0.6410850968955306, 0.9187183876881484]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6787943611788256, 0.5859709162148194, 0.38871431717150773`],
            $CellContext`LineColor -> 
            RGBColor[
             0.6787943611788256, 0.5859709162148194, 0.38871431717150773`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6787943611788256, 0.5859709162148194, 0.38871431717150773`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6787943611788256, 0.5859709162148194, 0.38871431717150773`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6787943611788256, 0.5859709162148194, 0.38871431717150773`]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.20014649179488786`, 0.6998604454553998, 0.33615035965998685`],
            $CellContext`LineColor -> 
            RGBColor[
             0.20014649179488786`, 0.6998604454553998, 0.33615035965998685`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.20014649179488786`, 0.6998604454553998, 0.33615035965998685`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.20014649179488786`, 0.6998604454553998, 0.33615035965998685`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.20014649179488786`, 0.6998604454553998, 0.33615035965998685`]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8972994800934211, 0.8397406906582436, 0.4376071783370781],
            $CellContext`LineColor -> 
            RGBColor[
             0.8972994800934211, 0.8397406906582436, 0.4376071783370781],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8972994800934211, 0.8397406906582436, 0.4376071783370781],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8972994800934211, 0.8397406906582436, 0.4376071783370781],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8972994800934211, 0.8397406906582436, 0.4376071783370781]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.41273428296083536`, 0.37719143120343146`, 0.5584064725876929],
            $CellContext`LineColor -> 
            RGBColor[
             0.41273428296083536`, 0.37719143120343146`, 0.5584064725876929],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.41273428296083536`, 0.37719143120343146`, 0.5584064725876929],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.41273428296083536`, 0.37719143120343146`, 0.5584064725876929],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.41273428296083536`, 0.37719143120343146`, 0.5584064725876929]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.39243886133259287`, 0.45606347780978207`, 0.7059363218202117],
            $CellContext`LineColor -> 
            RGBColor[
             0.39243886133259287`, 0.45606347780978207`, 0.7059363218202117],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.39243886133259287`, 0.45606347780978207`, 0.7059363218202117],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.39243886133259287`, 0.45606347780978207`, 0.7059363218202117],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.39243886133259287`, 0.45606347780978207`, 0.7059363218202117]], 
           StyleBox["6",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.1974474485088631, 0.1418004478481052, 0.5476393700104751],
            $CellContext`LineColor -> 
            RGBColor[
             0.1974474485088631, 0.1418004478481052, 0.5476393700104751],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.1974474485088631, 0.1418004478481052, 0.5476393700104751],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.1974474485088631, 0.1418004478481052, 0.5476393700104751],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.1974474485088631, 0.1418004478481052, 0.5476393700104751]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.27293700340695715`, 0.6220617386593192, 0.34939502409266154`],
            $CellContext`LineColor -> 
            RGBColor[
             0.27293700340695715`, 0.6220617386593192, 0.34939502409266154`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.27293700340695715`, 0.6220617386593192, 0.34939502409266154`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.27293700340695715`, 0.6220617386593192, 0.34939502409266154`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.27293700340695715`, 0.6220617386593192, 0.34939502409266154`]], 
           StyleBox["10",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8591907346813465, 0.2399347264337912, 0.8596128534349474],
            $CellContext`LineColor -> 
            RGBColor[
             0.8591907346813465, 0.2399347264337912, 0.8596128534349474],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8591907346813465, 0.2399347264337912, 0.8596128534349474],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8591907346813465, 0.2399347264337912, 0.8596128534349474],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8591907346813465, 0.2399347264337912, 0.8596128534349474]]},
          {
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.4741042067179584, 0.8543530538554036, 0.1265691453146056],
            $CellContext`LineColor -> 
            RGBColor[
             0.4741042067179584, 0.8543530538554036, 0.1265691453146056],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4741042067179584, 0.8543530538554036, 0.1265691453146056],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4741042067179584, 0.8543530538554036, 0.1265691453146056],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4741042067179584, 0.8543530538554036, 0.1265691453146056]], 
           StyleBox["5",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7475777566615376, 0.14932363679324845`, 0.16716408849918496`],
            $CellContext`LineColor -> 
            RGBColor[
             0.7475777566615376, 0.14932363679324845`, 0.16716408849918496`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7475777566615376, 0.14932363679324845`, 0.16716408849918496`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7475777566615376, 0.14932363679324845`, 0.16716408849918496`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7475777566615376, 0.14932363679324845`, 0.16716408849918496`]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.6078367528123751, 0.6885948057010287, 0.6239330221034394],
            $CellContext`LineColor -> 
            RGBColor[
             0.6078367528123751, 0.6885948057010287, 0.6239330221034394],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6078367528123751, 0.6885948057010287, 0.6239330221034394],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6078367528123751, 0.6885948057010287, 0.6239330221034394],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6078367528123751, 0.6885948057010287, 0.6239330221034394]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.022588378378586293`, 0.17926303192797532`, 
              0.16646652618014257`],
            $CellContext`LineColor -> 
            RGBColor[
             0.022588378378586293`, 0.17926303192797532`, 
              0.16646652618014257`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.022588378378586293`, 0.17926303192797532`, 
              0.16646652618014257`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.022588378378586293`, 0.17926303192797532`, 
              0.16646652618014257`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.022588378378586293`, 0.17926303192797532`, 
              0.16646652618014257`]], 
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.018790851446688794`, 0.5895644554646078, 0.025323912973879592`],
            $CellContext`LineColor -> 
            RGBColor[
             0.018790851446688794`, 0.5895644554646078, 0.025323912973879592`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.018790851446688794`, 0.5895644554646078, 0.025323912973879592`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.018790851446688794`, 0.5895644554646078, 0.025323912973879592`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.018790851446688794`, 0.5895644554646078, 
              0.025323912973879592`]], 
           StyleBox["2",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8041344085987416, 0.42219172727065635`, 0.6436952187025746],
            $CellContext`LineColor -> 
            RGBColor[
             0.8041344085987416, 0.42219172727065635`, 0.6436952187025746],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8041344085987416, 0.42219172727065635`, 0.6436952187025746],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8041344085987416, 0.42219172727065635`, 0.6436952187025746],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8041344085987416, 0.42219172727065635`, 0.6436952187025746]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.14220027290927262`, 0.4846154428893077, 0.02745469040246018],
            $CellContext`LineColor -> 
            RGBColor[
             0.14220027290927262`, 0.4846154428893077, 0.02745469040246018],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.14220027290927262`, 0.4846154428893077, 0.02745469040246018],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.14220027290927262`, 0.4846154428893077, 0.02745469040246018],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.14220027290927262`, 0.4846154428893077, 0.02745469040246018]], 
           
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.15338912761528545`, 0.18498643049585795`, 0.3148967838039214],
            $CellContext`LineColor -> 
            RGBColor[
             0.15338912761528545`, 0.18498643049585795`, 0.3148967838039214],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.15338912761528545`, 0.18498643049585795`, 0.3148967838039214],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.15338912761528545`, 0.18498643049585795`, 0.3148967838039214],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.15338912761528545`, 0.18498643049585795`, 0.3148967838039214]], 
           StyleBox["7",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.8467085702946355, 0.5761775778282245, 0.926621716336651],
            $CellContext`LineColor -> 
            RGBColor[
             0.8467085702946355, 0.5761775778282245, 0.926621716336651],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8467085702946355, 0.5761775778282245, 0.926621716336651],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8467085702946355, 0.5761775778282245, 0.926621716336651],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8467085702946355, 0.5761775778282245, 0.926621716336651]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.4065254210564555, 0.49281524935183874`, 0.7964432262762404],
            $CellContext`LineColor -> 
            RGBColor[
             0.4065254210564555, 0.49281524935183874`, 0.7964432262762404],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4065254210564555, 0.49281524935183874`, 0.7964432262762404],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4065254210564555, 0.49281524935183874`, 0.7964432262762404],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4065254210564555, 0.49281524935183874`, 0.7964432262762404]]},
          {
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7143449857263597, 0.9584109036971555, 0.051700035041822856`],
            $CellContext`LineColor -> 
            RGBColor[
             0.7143449857263597, 0.9584109036971555, 0.051700035041822856`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7143449857263597, 0.9584109036971555, 0.051700035041822856`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7143449857263597, 0.9584109036971555, 0.051700035041822856`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7143449857263597, 0.9584109036971555, 0.051700035041822856`]], 
           
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.9562802855764438, 0.7266225147604262, 0.7636529463317354],
            $CellContext`LineColor -> 
            RGBColor[
             0.9562802855764438, 0.7266225147604262, 0.7636529463317354],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9562802855764438, 0.7266225147604262, 0.7636529463317354],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9562802855764438, 0.7266225147604262, 0.7636529463317354],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9562802855764438, 0.7266225147604262, 0.7636529463317354]], 
           StyleBox["7",
            StripOnInput->False,
            FontColor->RGBColor[
             0.34075749392844856`, 0.02350593528845346, 0.9484099186573012],
            $CellContext`LineColor -> 
            RGBColor[
             0.34075749392844856`, 0.02350593528845346, 0.9484099186573012],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.34075749392844856`, 0.02350593528845346, 0.9484099186573012],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.34075749392844856`, 0.02350593528845346, 0.9484099186573012],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.34075749392844856`, 0.02350593528845346, 0.9484099186573012]], 
           
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.5016754049095404, 0.1809735017223968, 0.280877501266114],
            $CellContext`LineColor -> 
            RGBColor[
             0.5016754049095404, 0.1809735017223968, 0.280877501266114],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5016754049095404, 0.1809735017223968, 0.280877501266114],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5016754049095404, 0.1809735017223968, 0.280877501266114],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5016754049095404, 0.1809735017223968, 0.280877501266114]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.7631321744028661, 0.43208427282032447`, 0.294834300080439],
            $CellContext`LineColor -> 
            RGBColor[
             0.7631321744028661, 0.43208427282032447`, 0.294834300080439],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7631321744028661, 0.43208427282032447`, 0.294834300080439],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7631321744028661, 0.43208427282032447`, 0.294834300080439],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7631321744028661, 0.43208427282032447`, 0.294834300080439]], 
           StyleBox["1",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.20583660535128567`, 0.9145612270255516, 0.9809229870431186],
            $CellContext`LineColor -> 
            RGBColor[
             0.20583660535128567`, 0.9145612270255516, 0.9809229870431186],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.20583660535128567`, 0.9145612270255516, 0.9809229870431186],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.20583660535128567`, 0.9145612270255516, 0.9809229870431186],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.20583660535128567`, 0.9145612270255516, 0.9809229870431186]], 
           StyleBox["0",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.07744280042317508, 0.4358115718987561, 0.3006358652540213],
            $CellContext`LineColor -> 
            RGBColor[
             0.07744280042317508, 0.4358115718987561, 0.3006358652540213],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.07744280042317508, 0.4358115718987561, 0.3006358652540213],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.07744280042317508, 0.4358115718987561, 0.3006358652540213],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.07744280042317508, 0.4358115718987561, 0.3006358652540213]], 
           StyleBox["9",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.24474366047680896`, 0.22554120003414302`, 
              0.09374315922744358],
            $CellContext`LineColor -> 
            RGBColor[
             0.24474366047680896`, 0.22554120003414302`, 
              0.09374315922744358],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.24474366047680896`, 0.22554120003414302`, 
              0.09374315922744358],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.24474366047680896`, 0.22554120003414302`, 
              0.09374315922744358],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.24474366047680896`, 0.22554120003414302`, 0.09374315922744358]], 
           StyleBox["4",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.42364425622722135`, 0.7756177481578685, 0.7440317600046329],
            $CellContext`LineColor -> 
            RGBColor[
             0.42364425622722135`, 0.7756177481578685, 0.7440317600046329],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.42364425622722135`, 0.7756177481578685, 0.7440317600046329],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.42364425622722135`, 0.7756177481578685, 0.7440317600046329],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.42364425622722135`, 0.7756177481578685, 0.7440317600046329]], 
           StyleBox["3",
            StripOnInput->False,
            
            FontColor->RGBColor[
             0.45394211366550374`, 0.8138082705320957, 
              0.061460883632106666`],
            $CellContext`LineColor -> 
            RGBColor[
             0.45394211366550374`, 0.8138082705320957, 
              0.061460883632106666`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.45394211366550374`, 0.8138082705320957, 
              0.061460883632106666`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.45394211366550374`, 0.8138082705320957, 
              0.061460883632106666`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.45394211366550374`, 0.8138082705320957, 
              0.061460883632106666`]]}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "c8aefe16-9a99-44ab-bb2a-ba9aa5d1537b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9461467349525237, 0.9752200744900494, 
                0.19630670101161773`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9461467349525237, 0.9752200744900494, 
                0.19630670101161773`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9461467349525237, 0.9752200744900494, 0.19630670101161773`], 
              FontColor -> 
              RGBColor[
               0.9461467349525237, 0.9752200744900494, 
                0.19630670101161773`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9461467349525237, 0.9752200744900494, 0.19630670101161773`]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.24862792604144546`, 0.10752227432523398`, 
                0.6284978478989733], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.24862792604144546`, 0.10752227432523398`, 
                0.6284978478989733], $CellContext`GraphicsColor -> 
              RGBColor[
               0.24862792604144546`, 0.10752227432523398`, 
                0.6284978478989733], FontColor -> 
              RGBColor[
               0.24862792604144546`, 0.10752227432523398`, 
                0.6284978478989733], $CellContext`BackFaceColor -> 
              RGBColor[
               0.24862792604144546`, 0.10752227432523398`, 
                0.6284978478989733]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5577242692112141, 0.34287121714349755`, 
                0.2552940774745578], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5577242692112141, 0.34287121714349755`, 
                0.2552940774745578], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5577242692112141, 0.34287121714349755`, 0.2552940774745578], 
              FontColor -> 
              RGBColor[
               0.5577242692112141, 0.34287121714349755`, 
                0.2552940774745578], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5577242692112141, 0.34287121714349755`, 0.2552940774745578]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8911014201279688, 0.667257718702293, 
                0.3358155219068655], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8911014201279688, 0.667257718702293, 
                0.3358155219068655], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8911014201279688, 0.667257718702293, 0.3358155219068655], 
              FontColor -> 
              RGBColor[
               0.8911014201279688, 0.667257718702293, 
                0.3358155219068655], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8911014201279688, 0.667257718702293, 0.3358155219068655]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7080697952195558, 0.07689036146549544, 
                0.8267118890836695], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7080697952195558, 0.07689036146549544, 
                0.8267118890836695], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7080697952195558, 0.07689036146549544, 0.8267118890836695], 
              FontColor -> 
              RGBColor[
               0.7080697952195558, 0.07689036146549544, 
                0.8267118890836695], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7080697952195558, 0.07689036146549544, 0.8267118890836695]], 
             
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.027665312825819743`, 0.7425419473198636, 
                0.00656630187248175], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.027665312825819743`, 0.7425419473198636, 
                0.00656630187248175], $CellContext`GraphicsColor -> 
              RGBColor[
               0.027665312825819743`, 0.7425419473198636, 
                0.00656630187248175], FontColor -> 
              RGBColor[
               0.027665312825819743`, 0.7425419473198636, 
                0.00656630187248175], $CellContext`BackFaceColor -> 
              RGBColor[
               0.027665312825819743`, 0.7425419473198636, 
                0.00656630187248175]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.606034112396058, 0.6972735779098382, 
                0.10138670408872796`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.606034112396058, 0.6972735779098382, 
                0.10138670408872796`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.606034112396058, 0.6972735779098382, 0.10138670408872796`], 
              FontColor -> 
              RGBColor[
               0.606034112396058, 0.6972735779098382, 
                0.10138670408872796`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.606034112396058, 0.6972735779098382, 0.10138670408872796`]], 
             
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.27245718157209753`, 0.05781970854035512, 
                0.19546728000367297`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.27245718157209753`, 0.05781970854035512, 
                0.19546728000367297`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.27245718157209753`, 0.05781970854035512, 
                0.19546728000367297`], FontColor -> 
              RGBColor[
               0.27245718157209753`, 0.05781970854035512, 
                0.19546728000367297`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.27245718157209753`, 0.05781970854035512, 
                0.19546728000367297`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8887562069308925, 0.6480727815008511, 
                0.4280340962886071], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8887562069308925, 0.6480727815008511, 
                0.4280340962886071], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8887562069308925, 0.6480727815008511, 0.4280340962886071], 
              FontColor -> 
              RGBColor[
               0.8887562069308925, 0.6480727815008511, 
                0.4280340962886071], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8887562069308925, 0.6480727815008511, 0.4280340962886071]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8178725992446179, 0.6838381891757823, 
                0.98587469856858], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8178725992446179, 0.6838381891757823, 
                0.98587469856858], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8178725992446179, 0.6838381891757823, 0.98587469856858], 
              FontColor -> 
              RGBColor[
               0.8178725992446179, 0.6838381891757823, 
                0.98587469856858], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8178725992446179, 0.6838381891757823, 0.98587469856858]]}, {
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.948287583327043, 0.14175505784617415`, 
                0.00731626581980005], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.948287583327043, 0.14175505784617415`, 
                0.00731626581980005], $CellContext`GraphicsColor -> 
              RGBColor[
               0.948287583327043, 0.14175505784617415`, 0.00731626581980005], 
              FontColor -> 
              RGBColor[
               0.948287583327043, 0.14175505784617415`, 
                0.00731626581980005], $CellContext`BackFaceColor -> 
              RGBColor[
               0.948287583327043, 0.14175505784617415`, 0.00731626581980005]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.46424273235297564`, 0.7221685214118281, 
                0.8544083499680859], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.46424273235297564`, 0.7221685214118281, 
                0.8544083499680859], $CellContext`GraphicsColor -> 
              RGBColor[
               0.46424273235297564`, 0.7221685214118281, 0.8544083499680859], 
              FontColor -> 
              RGBColor[
               0.46424273235297564`, 0.7221685214118281, 
                0.8544083499680859], $CellContext`BackFaceColor -> 
              RGBColor[
               0.46424273235297564`, 0.7221685214118281, 0.8544083499680859]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.009308639554695963, 0.1937737430459885, 
                0.3031947935928969], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.009308639554695963, 0.1937737430459885, 
                0.3031947935928969], $CellContext`GraphicsColor -> 
              RGBColor[
               0.009308639554695963, 0.1937737430459885, 0.3031947935928969], 
              FontColor -> 
              RGBColor[
               0.009308639554695963, 0.1937737430459885, 
                0.3031947935928969], $CellContext`BackFaceColor -> 
              RGBColor[
               0.009308639554695963, 0.1937737430459885, 0.3031947935928969]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5126802201898331, 0.3260783135097931, 
                0.004357349503499641], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5126802201898331, 0.3260783135097931, 
                0.004357349503499641], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5126802201898331, 0.3260783135097931, 0.004357349503499641], 
              FontColor -> 
              RGBColor[
               0.5126802201898331, 0.3260783135097931, 
                0.004357349503499641], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5126802201898331, 0.3260783135097931, 0.004357349503499641]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9970148325582657, 0.6457158495033748, 
                0.0034257753873956354`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9970148325582657, 0.6457158495033748, 
                0.0034257753873956354`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9970148325582657, 0.6457158495033748, 
                0.0034257753873956354`], FontColor -> 
              RGBColor[
               0.9970148325582657, 0.6457158495033748, 
                0.0034257753873956354`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9970148325582657, 0.6457158495033748, 
                0.0034257753873956354`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5324151103899413, 0.41403462759890486`, 
                0.07569077746572583], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5324151103899413, 0.41403462759890486`, 
                0.07569077746572583], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5324151103899413, 0.41403462759890486`, 0.07569077746572583],
               FontColor -> 
              RGBColor[
               0.5324151103899413, 0.41403462759890486`, 
                0.07569077746572583], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5324151103899413, 0.41403462759890486`, 
                0.07569077746572583]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8096045605413051, 0.3489371675588504, 
                0.33933608231400525`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8096045605413051, 0.3489371675588504, 
                0.33933608231400525`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8096045605413051, 0.3489371675588504, 0.33933608231400525`], 
              FontColor -> 
              RGBColor[
               0.8096045605413051, 0.3489371675588504, 
                0.33933608231400525`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8096045605413051, 0.3489371675588504, 0.33933608231400525`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9778447780789905, 0.9716634431212376, 
                0.5945749667664826], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9778447780789905, 0.9716634431212376, 
                0.5945749667664826], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9778447780789905, 0.9716634431212376, 0.5945749667664826], 
              FontColor -> 
              RGBColor[
               0.9778447780789905, 0.9716634431212376, 
                0.5945749667664826], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9778447780789905, 0.9716634431212376, 0.5945749667664826]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6594544323034284, 0.2624963496378694, 
                0.6393244421041806], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6594544323034284, 0.2624963496378694, 
                0.6393244421041806], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6594544323034284, 0.2624963496378694, 0.6393244421041806], 
              FontColor -> 
              RGBColor[
               0.6594544323034284, 0.2624963496378694, 
                0.6393244421041806], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6594544323034284, 0.2624963496378694, 0.6393244421041806]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5800459142067347, 0.039144998205196346`, 
                0.20068320974760434`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5800459142067347, 0.039144998205196346`, 
                0.20068320974760434`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5800459142067347, 0.039144998205196346`, 
                0.20068320974760434`], FontColor -> 
              RGBColor[
               0.5800459142067347, 0.039144998205196346`, 
                0.20068320974760434`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5800459142067347, 0.039144998205196346`, 
                0.20068320974760434`]]}, {
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.809456702168398, 0.8613804068894142, 
                0.0017448064442096012`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.809456702168398, 0.8613804068894142, 
                0.0017448064442096012`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.809456702168398, 0.8613804068894142, 0.0017448064442096012`],
               FontColor -> 
              RGBColor[
               0.809456702168398, 0.8613804068894142, 
                0.0017448064442096012`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.809456702168398, 0.8613804068894142, 
                0.0017448064442096012`]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.627497505287832, 0.5392505117413575, 
                0.43312921294442885`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.627497505287832, 0.5392505117413575, 
                0.43312921294442885`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.627497505287832, 0.5392505117413575, 0.43312921294442885`], 
              FontColor -> 
              RGBColor[
               0.627497505287832, 0.5392505117413575, 
                0.43312921294442885`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.627497505287832, 0.5392505117413575, 0.43312921294442885`]], 
             
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.10120063621760655`, 0.25628323420464705`, 
                0.6339512643839103], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.10120063621760655`, 0.25628323420464705`, 
                0.6339512643839103], $CellContext`GraphicsColor -> 
              RGBColor[
               0.10120063621760655`, 0.25628323420464705`, 
                0.6339512643839103], FontColor -> 
              RGBColor[
               0.10120063621760655`, 0.25628323420464705`, 
                0.6339512643839103], $CellContext`BackFaceColor -> 
              RGBColor[
               0.10120063621760655`, 0.25628323420464705`, 
                0.6339512643839103]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7832250203431665, 0.9900380468162264, 
                0.7581154658055032], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7832250203431665, 0.9900380468162264, 
                0.7581154658055032], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7832250203431665, 0.9900380468162264, 0.7581154658055032], 
              FontColor -> 
              RGBColor[
               0.7832250203431665, 0.9900380468162264, 
                0.7581154658055032], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7832250203431665, 0.9900380468162264, 0.7581154658055032]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.984005422552072, 0.025943636625120448`, 
                0.7182075726398491], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.984005422552072, 0.025943636625120448`, 
                0.7182075726398491], $CellContext`GraphicsColor -> 
              RGBColor[
               0.984005422552072, 0.025943636625120448`, 0.7182075726398491], 
              FontColor -> 
              RGBColor[
               0.984005422552072, 0.025943636625120448`, 
                0.7182075726398491], $CellContext`BackFaceColor -> 
              RGBColor[
               0.984005422552072, 0.025943636625120448`, 0.7182075726398491]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.0812116328515613, 0.6583948944761258, 
                0.6472372017186556], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.0812116328515613, 0.6583948944761258, 
                0.6472372017186556], $CellContext`GraphicsColor -> 
              RGBColor[
               0.0812116328515613, 0.6583948944761258, 0.6472372017186556], 
              FontColor -> 
              RGBColor[
               0.0812116328515613, 0.6583948944761258, 
                0.6472372017186556], $CellContext`BackFaceColor -> 
              RGBColor[
               0.0812116328515613, 0.6583948944761258, 0.6472372017186556]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.014674940533907277`, 0.8268676217182933, 
                0.6804510359737441], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.014674940533907277`, 0.8268676217182933, 
                0.6804510359737441], $CellContext`GraphicsColor -> 
              RGBColor[
               0.014674940533907277`, 0.8268676217182933, 0.6804510359737441],
               FontColor -> 
              RGBColor[
               0.014674940533907277`, 0.8268676217182933, 
                0.6804510359737441], $CellContext`BackFaceColor -> 
              RGBColor[
               0.014674940533907277`, 0.8268676217182933, 
                0.6804510359737441]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.0406819180326099, 0.43662118686186235`, 
                0.6736195772935563], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.0406819180326099, 0.43662118686186235`, 
                0.6736195772935563], $CellContext`GraphicsColor -> 
              RGBColor[
               0.0406819180326099, 0.43662118686186235`, 0.6736195772935563], 
              FontColor -> 
              RGBColor[
               0.0406819180326099, 0.43662118686186235`, 
                0.6736195772935563], $CellContext`BackFaceColor -> 
              RGBColor[
               0.0406819180326099, 0.43662118686186235`, 0.6736195772935563]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.25609755740069917`, 0.7406079377913801, 
                0.9126976796897188], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.25609755740069917`, 0.7406079377913801, 
                0.9126976796897188], $CellContext`GraphicsColor -> 
              RGBColor[
               0.25609755740069917`, 0.7406079377913801, 0.9126976796897188], 
              FontColor -> 
              RGBColor[
               0.25609755740069917`, 0.7406079377913801, 
                0.9126976796897188], $CellContext`BackFaceColor -> 
              RGBColor[
               0.25609755740069917`, 0.7406079377913801, 0.9126976796897188]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9989451027279306, 0.8918995665419438, 
                0.3253043923332035], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9989451027279306, 0.8918995665419438, 
                0.3253043923332035], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9989451027279306, 0.8918995665419438, 0.3253043923332035], 
              FontColor -> 
              RGBColor[
               0.9989451027279306, 0.8918995665419438, 
                0.3253043923332035], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9989451027279306, 0.8918995665419438, 0.3253043923332035]]}, {
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.27365484763105963`, 0.6046137803657607, 
                0.8638807440074829], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.27365484763105963`, 0.6046137803657607, 
                0.8638807440074829], $CellContext`GraphicsColor -> 
              RGBColor[
               0.27365484763105963`, 0.6046137803657607, 0.8638807440074829], 
              FontColor -> 
              RGBColor[
               0.27365484763105963`, 0.6046137803657607, 
                0.8638807440074829], $CellContext`BackFaceColor -> 
              RGBColor[
               0.27365484763105963`, 0.6046137803657607, 0.8638807440074829]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7140610547451831, 0.030518350727399612`, 
                0.8082951288449898], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7140610547451831, 0.030518350727399612`, 
                0.8082951288449898], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7140610547451831, 0.030518350727399612`, 0.8082951288449898],
               FontColor -> 
              RGBColor[
               0.7140610547451831, 0.030518350727399612`, 
                0.8082951288449898], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7140610547451831, 0.030518350727399612`, 
                0.8082951288449898]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5745494386823653, 0.7384408056471385, 
                0.2643373081031448], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5745494386823653, 0.7384408056471385, 
                0.2643373081031448], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5745494386823653, 0.7384408056471385, 0.2643373081031448], 
              FontColor -> 
              RGBColor[
               0.5745494386823653, 0.7384408056471385, 
                0.2643373081031448], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5745494386823653, 0.7384408056471385, 0.2643373081031448]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8667697929441776, 0.9198053148749128, 
                0.5369963891267786], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8667697929441776, 0.9198053148749128, 
                0.5369963891267786], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8667697929441776, 0.9198053148749128, 0.5369963891267786], 
              FontColor -> 
              RGBColor[
               0.8667697929441776, 0.9198053148749128, 
                0.5369963891267786], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8667697929441776, 0.9198053148749128, 0.5369963891267786]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6547934542020757, 0.34568757203723344`, 
                0.1915604303533598], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6547934542020757, 0.34568757203723344`, 
                0.1915604303533598], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6547934542020757, 0.34568757203723344`, 0.1915604303533598], 
              FontColor -> 
              RGBColor[
               0.6547934542020757, 0.34568757203723344`, 
                0.1915604303533598], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6547934542020757, 0.34568757203723344`, 0.1915604303533598]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3536845882195143, 0.051291744342369716`, 
                0.22839590801490783`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3536845882195143, 0.051291744342369716`, 
                0.22839590801490783`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3536845882195143, 0.051291744342369716`, 
                0.22839590801490783`], FontColor -> 
              RGBColor[
               0.3536845882195143, 0.051291744342369716`, 
                0.22839590801490783`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3536845882195143, 0.051291744342369716`, 
                0.22839590801490783`]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.42166657491651094`, 0.7802161313198828, 
                0.5826318538039614], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.42166657491651094`, 0.7802161313198828, 
                0.5826318538039614], $CellContext`GraphicsColor -> 
              RGBColor[
               0.42166657491651094`, 0.7802161313198828, 0.5826318538039614], 
              FontColor -> 
              RGBColor[
               0.42166657491651094`, 0.7802161313198828, 
                0.5826318538039614], $CellContext`BackFaceColor -> 
              RGBColor[
               0.42166657491651094`, 0.7802161313198828, 0.5826318538039614]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.24600378313974613`, 0.7191799874553491, 
                0.36075513314509], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.24600378313974613`, 0.7191799874553491, 
                0.36075513314509], $CellContext`GraphicsColor -> 
              RGBColor[
               0.24600378313974613`, 0.7191799874553491, 0.36075513314509], 
              FontColor -> 
              RGBColor[
               0.24600378313974613`, 0.7191799874553491, 
                0.36075513314509], $CellContext`BackFaceColor -> 
              RGBColor[
               0.24600378313974613`, 0.7191799874553491, 0.36075513314509]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.04153594448002207, 0.4295960077561829, 
                0.847024283745778], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.04153594448002207, 0.4295960077561829, 
                0.847024283745778], $CellContext`GraphicsColor -> 
              RGBColor[
               0.04153594448002207, 0.4295960077561829, 0.847024283745778], 
              FontColor -> 
              RGBColor[
               0.04153594448002207, 0.4295960077561829, 
                0.847024283745778], $CellContext`BackFaceColor -> 
              RGBColor[
               0.04153594448002207, 0.4295960077561829, 0.847024283745778]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6720355615791775, 0.43184298014526723`, 
                0.12285359878468483`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6720355615791775, 0.43184298014526723`, 
                0.12285359878468483`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6720355615791775, 0.43184298014526723`, 
                0.12285359878468483`], FontColor -> 
              RGBColor[
               0.6720355615791775, 0.43184298014526723`, 
                0.12285359878468483`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6720355615791775, 0.43184298014526723`, 
                0.12285359878468483`]]}, {
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.522446535047915, 0.5474331079194232, 
                0.47991443778567167`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.522446535047915, 0.5474331079194232, 
                0.47991443778567167`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.522446535047915, 0.5474331079194232, 0.47991443778567167`], 
              FontColor -> 
              RGBColor[
               0.522446535047915, 0.5474331079194232, 
                0.47991443778567167`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.522446535047915, 0.5474331079194232, 0.47991443778567167`]], 
             
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8110677449162669, 0.3950293657968842, 
                0.6055767877474503], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8110677449162669, 0.3950293657968842, 
                0.6055767877474503], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8110677449162669, 0.3950293657968842, 0.6055767877474503], 
              FontColor -> 
              RGBColor[
               0.8110677449162669, 0.3950293657968842, 
                0.6055767877474503], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8110677449162669, 0.3950293657968842, 0.6055767877474503]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8697449557870209, 0.24307066135409916`, 
                0.43571293536486344`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8697449557870209, 0.24307066135409916`, 
                0.43571293536486344`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8697449557870209, 0.24307066135409916`, 
                0.43571293536486344`], FontColor -> 
              RGBColor[
               0.8697449557870209, 0.24307066135409916`, 
                0.43571293536486344`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8697449557870209, 0.24307066135409916`, 
                0.43571293536486344`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.14207115218954725`, 0.027609462042487598`, 
                0.26538200115859434`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.14207115218954725`, 0.027609462042487598`, 
                0.26538200115859434`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.14207115218954725`, 0.027609462042487598`, 
                0.26538200115859434`], FontColor -> 
              RGBColor[
               0.14207115218954725`, 0.027609462042487598`, 
                0.26538200115859434`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.14207115218954725`, 0.027609462042487598`, 
                0.26538200115859434`]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8971343715353424, 0.9172966585784836, 
                0.34560737157623045`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8971343715353424, 0.9172966585784836, 
                0.34560737157623045`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8971343715353424, 0.9172966585784836, 0.34560737157623045`], 
              FontColor -> 
              RGBColor[
               0.8971343715353424, 0.9172966585784836, 
                0.34560737157623045`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8971343715353424, 0.9172966585784836, 0.34560737157623045`]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9275408690877258, 0.756890095732438, 
                0.4582415405661542], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9275408690877258, 0.756890095732438, 
                0.4582415405661542], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9275408690877258, 0.756890095732438, 0.4582415405661542], 
              FontColor -> 
              RGBColor[
               0.9275408690877258, 0.756890095732438, 
                0.4582415405661542], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9275408690877258, 0.756890095732438, 0.4582415405661542]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8811128075486427, 0.6440403427494257, 
                0.26634002155557956`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8811128075486427, 0.6440403427494257, 
                0.26634002155557956`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8811128075486427, 0.6440403427494257, 0.26634002155557956`], 
              FontColor -> 
              RGBColor[
               0.8811128075486427, 0.6440403427494257, 
                0.26634002155557956`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8811128075486427, 0.6440403427494257, 0.26634002155557956`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4801055603613329, 0.34718962495427186`, 
                0.8000917595328458], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4801055603613329, 0.34718962495427186`, 
                0.8000917595328458], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4801055603613329, 0.34718962495427186`, 0.8000917595328458], 
              FontColor -> 
              RGBColor[
               0.4801055603613329, 0.34718962495427186`, 
                0.8000917595328458], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4801055603613329, 0.34718962495427186`, 0.8000917595328458]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2593665209586269, 0.11701852565272874`, 
                0.838828303544338], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2593665209586269, 0.11701852565272874`, 
                0.838828303544338], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2593665209586269, 0.11701852565272874`, 0.838828303544338], 
              FontColor -> 
              RGBColor[
               0.2593665209586269, 0.11701852565272874`, 
                0.838828303544338], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2593665209586269, 0.11701852565272874`, 0.838828303544338]], 
             
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.24597310847468523`, 0.05421201013519816, 
                0.4303003765685125], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.24597310847468523`, 0.05421201013519816, 
                0.4303003765685125], $CellContext`GraphicsColor -> 
              RGBColor[
               0.24597310847468523`, 0.05421201013519816, 0.4303003765685125],
               FontColor -> 
              RGBColor[
               0.24597310847468523`, 0.05421201013519816, 
                0.4303003765685125], $CellContext`BackFaceColor -> 
              RGBColor[
               0.24597310847468523`, 0.05421201013519816, 
                0.4303003765685125]]}, {
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5552222322113358, 0.8779570216992596, 
                0.5715574788068376], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5552222322113358, 0.8779570216992596, 
                0.5715574788068376], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5552222322113358, 0.8779570216992596, 0.5715574788068376], 
              FontColor -> 
              RGBColor[
               0.5552222322113358, 0.8779570216992596, 
                0.5715574788068376], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5552222322113358, 0.8779570216992596, 0.5715574788068376]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.41333836047323524`, 0.9651114898010289, 
                0.025766292499096455`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.41333836047323524`, 0.9651114898010289, 
                0.025766292499096455`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.41333836047323524`, 0.9651114898010289, 
                0.025766292499096455`], FontColor -> 
              RGBColor[
               0.41333836047323524`, 0.9651114898010289, 
                0.025766292499096455`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.41333836047323524`, 0.9651114898010289, 
                0.025766292499096455`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2757668263570803, 0.4708435271405127, 
                0.17221931665505585`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2757668263570803, 0.4708435271405127, 
                0.17221931665505585`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2757668263570803, 0.4708435271405127, 0.17221931665505585`], 
              FontColor -> 
              RGBColor[
               0.2757668263570803, 0.4708435271405127, 
                0.17221931665505585`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2757668263570803, 0.4708435271405127, 0.17221931665505585`]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9272633727519812, 0.3677940048968156, 
                0.2633176871475038], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9272633727519812, 0.3677940048968156, 
                0.2633176871475038], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9272633727519812, 0.3677940048968156, 0.2633176871475038], 
              FontColor -> 
              RGBColor[
               0.9272633727519812, 0.3677940048968156, 
                0.2633176871475038], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9272633727519812, 0.3677940048968156, 0.2633176871475038]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8490240358437848, 0.3793156412678107, 
                0.7367342472483607], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8490240358437848, 0.3793156412678107, 
                0.7367342472483607], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8490240358437848, 0.3793156412678107, 0.7367342472483607], 
              FontColor -> 
              RGBColor[
               0.8490240358437848, 0.3793156412678107, 
                0.7367342472483607], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8490240358437848, 0.3793156412678107, 0.7367342472483607]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.764011232824358, 0.4620426592484266, 
                0.06359115748085631], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.764011232824358, 0.4620426592484266, 
                0.06359115748085631], $CellContext`GraphicsColor -> 
              RGBColor[
               0.764011232824358, 0.4620426592484266, 0.06359115748085631], 
              FontColor -> 
              RGBColor[
               0.764011232824358, 0.4620426592484266, 
                0.06359115748085631], $CellContext`BackFaceColor -> 
              RGBColor[
               0.764011232824358, 0.4620426592484266, 0.06359115748085631]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.16965924759224515`, 0.1167639581098534, 
                0.6149163489817344], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.16965924759224515`, 0.1167639581098534, 
                0.6149163489817344], $CellContext`GraphicsColor -> 
              RGBColor[
               0.16965924759224515`, 0.1167639581098534, 0.6149163489817344], 
              FontColor -> 
              RGBColor[
               0.16965924759224515`, 0.1167639581098534, 
                0.6149163489817344], $CellContext`BackFaceColor -> 
              RGBColor[
               0.16965924759224515`, 0.1167639581098534, 0.6149163489817344]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.1464813808433978, 0.49375914734255955`, 
                0.5732323241550707], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.1464813808433978, 0.49375914734255955`, 
                0.5732323241550707], $CellContext`GraphicsColor -> 
              RGBColor[
               0.1464813808433978, 0.49375914734255955`, 0.5732323241550707], 
              FontColor -> 
              RGBColor[
               0.1464813808433978, 0.49375914734255955`, 
                0.5732323241550707], $CellContext`BackFaceColor -> 
              RGBColor[
               0.1464813808433978, 0.49375914734255955`, 0.5732323241550707]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5193246130548013, 0.9818127150690881, 
                0.39080997439317366`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5193246130548013, 0.9818127150690881, 
                0.39080997439317366`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5193246130548013, 0.9818127150690881, 0.39080997439317366`], 
              FontColor -> 
              RGBColor[
               0.5193246130548013, 0.9818127150690881, 
                0.39080997439317366`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5193246130548013, 0.9818127150690881, 0.39080997439317366`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3972094283962493, 0.22599553480358492`, 
                0.14955155902184702`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3972094283962493, 0.22599553480358492`, 
                0.14955155902184702`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3972094283962493, 0.22599553480358492`, 
                0.14955155902184702`], FontColor -> 
              RGBColor[
               0.3972094283962493, 0.22599553480358492`, 
                0.14955155902184702`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3972094283962493, 0.22599553480358492`, 
                0.14955155902184702`]]}, {
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4255610025893479, 0.028838238600754407`, 
                0.8215318131536475], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4255610025893479, 0.028838238600754407`, 
                0.8215318131536475], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4255610025893479, 0.028838238600754407`, 0.8215318131536475],
               FontColor -> 
              RGBColor[
               0.4255610025893479, 0.028838238600754407`, 
                0.8215318131536475], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4255610025893479, 0.028838238600754407`, 
                0.8215318131536475]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.47829917859486293`, 0.3692630472281002, 
                0.787076034780892], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.47829917859486293`, 0.3692630472281002, 
                0.787076034780892], $CellContext`GraphicsColor -> 
              RGBColor[
               0.47829917859486293`, 0.3692630472281002, 0.787076034780892], 
              FontColor -> 
              RGBColor[
               0.47829917859486293`, 0.3692630472281002, 
                0.787076034780892], $CellContext`BackFaceColor -> 
              RGBColor[
               0.47829917859486293`, 0.3692630472281002, 0.787076034780892]], 
             
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8135270572353626, 0.9674421000297233, 
                0.6956662366442121], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8135270572353626, 0.9674421000297233, 
                0.6956662366442121], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8135270572353626, 0.9674421000297233, 0.6956662366442121], 
              FontColor -> 
              RGBColor[
               0.8135270572353626, 0.9674421000297233, 
                0.6956662366442121], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8135270572353626, 0.9674421000297233, 0.6956662366442121]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5253658393725205, 0.6339916899893867, 
                0.04488276040604067], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5253658393725205, 0.6339916899893867, 
                0.04488276040604067], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5253658393725205, 0.6339916899893867, 0.04488276040604067], 
              FontColor -> 
              RGBColor[
               0.5253658393725205, 0.6339916899893867, 
                0.04488276040604067], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5253658393725205, 0.6339916899893867, 0.04488276040604067]], 
             
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6944170953403732, 0.4739637553473215, 
                0.3357126174893543], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6944170953403732, 0.4739637553473215, 
                0.3357126174893543], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6944170953403732, 0.4739637553473215, 0.3357126174893543], 
              FontColor -> 
              RGBColor[
               0.6944170953403732, 0.4739637553473215, 
                0.3357126174893543], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6944170953403732, 0.4739637553473215, 0.3357126174893543]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7006482406140371, 0.44578561844912024`, 
                0.5276468465249675], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7006482406140371, 0.44578561844912024`, 
                0.5276468465249675], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7006482406140371, 0.44578561844912024`, 0.5276468465249675], 
              FontColor -> 
              RGBColor[
               0.7006482406140371, 0.44578561844912024`, 
                0.5276468465249675], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7006482406140371, 0.44578561844912024`, 0.5276468465249675]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2376037044941619, 0.6660728193217682, 
                0.6882966911786483], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2376037044941619, 0.6660728193217682, 
                0.6882966911786483], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2376037044941619, 0.6660728193217682, 0.6882966911786483], 
              FontColor -> 
              RGBColor[
               0.2376037044941619, 0.6660728193217682, 
                0.6882966911786483], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2376037044941619, 0.6660728193217682, 0.6882966911786483]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.45179211479788917`, 0.11530364505964963`, 
                0.11656645908225727`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.45179211479788917`, 0.11530364505964963`, 
                0.11656645908225727`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.45179211479788917`, 0.11530364505964963`, 
                0.11656645908225727`], FontColor -> 
              RGBColor[
               0.45179211479788917`, 0.11530364505964963`, 
                0.11656645908225727`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.45179211479788917`, 0.11530364505964963`, 
                0.11656645908225727`]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9966829670058455, 0.6100039695526365, 
                0.5925615551877714], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9966829670058455, 0.6100039695526365, 
                0.5925615551877714], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9966829670058455, 0.6100039695526365, 0.5925615551877714], 
              FontColor -> 
              RGBColor[
               0.9966829670058455, 0.6100039695526365, 
                0.5925615551877714], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9966829670058455, 0.6100039695526365, 0.5925615551877714]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3960605570071172, 0.21554356288569498`, 
                0.5302856894450105], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3960605570071172, 0.21554356288569498`, 
                0.5302856894450105], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3960605570071172, 0.21554356288569498`, 0.5302856894450105], 
              FontColor -> 
              RGBColor[
               0.3960605570071172, 0.21554356288569498`, 
                0.5302856894450105], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3960605570071172, 0.21554356288569498`, 
                0.5302856894450105]]}, {
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.42402328059466954`, 0.8473902288484125, 
                0.8437773753067899], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.42402328059466954`, 0.8473902288484125, 
                0.8437773753067899], $CellContext`GraphicsColor -> 
              RGBColor[
               0.42402328059466954`, 0.8473902288484125, 0.8437773753067899], 
              FontColor -> 
              RGBColor[
               0.42402328059466954`, 0.8473902288484125, 
                0.8437773753067899], $CellContext`BackFaceColor -> 
              RGBColor[
               0.42402328059466954`, 0.8473902288484125, 0.8437773753067899]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7910788456341271, 0.6410850968955306, 
                0.9187183876881484], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7910788456341271, 0.6410850968955306, 
                0.9187183876881484], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7910788456341271, 0.6410850968955306, 0.9187183876881484], 
              FontColor -> 
              RGBColor[
               0.7910788456341271, 0.6410850968955306, 
                0.9187183876881484], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7910788456341271, 0.6410850968955306, 0.9187183876881484]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6787943611788256, 0.5859709162148194, 
                0.38871431717150773`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6787943611788256, 0.5859709162148194, 
                0.38871431717150773`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6787943611788256, 0.5859709162148194, 0.38871431717150773`], 
              FontColor -> 
              RGBColor[
               0.6787943611788256, 0.5859709162148194, 
                0.38871431717150773`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6787943611788256, 0.5859709162148194, 0.38871431717150773`]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.20014649179488786`, 0.6998604454553998, 
                0.33615035965998685`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.20014649179488786`, 0.6998604454553998, 
                0.33615035965998685`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.20014649179488786`, 0.6998604454553998, 
                0.33615035965998685`], FontColor -> 
              RGBColor[
               0.20014649179488786`, 0.6998604454553998, 
                0.33615035965998685`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.20014649179488786`, 0.6998604454553998, 
                0.33615035965998685`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8972994800934211, 0.8397406906582436, 
                0.4376071783370781], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8972994800934211, 0.8397406906582436, 
                0.4376071783370781], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8972994800934211, 0.8397406906582436, 0.4376071783370781], 
              FontColor -> 
              RGBColor[
               0.8972994800934211, 0.8397406906582436, 
                0.4376071783370781], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8972994800934211, 0.8397406906582436, 0.4376071783370781]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.41273428296083536`, 0.37719143120343146`, 
                0.5584064725876929], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.41273428296083536`, 0.37719143120343146`, 
                0.5584064725876929], $CellContext`GraphicsColor -> 
              RGBColor[
               0.41273428296083536`, 0.37719143120343146`, 
                0.5584064725876929], FontColor -> 
              RGBColor[
               0.41273428296083536`, 0.37719143120343146`, 
                0.5584064725876929], $CellContext`BackFaceColor -> 
              RGBColor[
               0.41273428296083536`, 0.37719143120343146`, 
                0.5584064725876929]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.39243886133259287`, 0.45606347780978207`, 
                0.7059363218202117], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.39243886133259287`, 0.45606347780978207`, 
                0.7059363218202117], $CellContext`GraphicsColor -> 
              RGBColor[
               0.39243886133259287`, 0.45606347780978207`, 
                0.7059363218202117], FontColor -> 
              RGBColor[
               0.39243886133259287`, 0.45606347780978207`, 
                0.7059363218202117], $CellContext`BackFaceColor -> 
              RGBColor[
               0.39243886133259287`, 0.45606347780978207`, 
                0.7059363218202117]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.1974474485088631, 0.1418004478481052, 
                0.5476393700104751], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.1974474485088631, 0.1418004478481052, 
                0.5476393700104751], $CellContext`GraphicsColor -> 
              RGBColor[
               0.1974474485088631, 0.1418004478481052, 0.5476393700104751], 
              FontColor -> 
              RGBColor[
               0.1974474485088631, 0.1418004478481052, 
                0.5476393700104751], $CellContext`BackFaceColor -> 
              RGBColor[
               0.1974474485088631, 0.1418004478481052, 0.5476393700104751]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.27293700340695715`, 0.6220617386593192, 
                0.34939502409266154`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.27293700340695715`, 0.6220617386593192, 
                0.34939502409266154`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.27293700340695715`, 0.6220617386593192, 
                0.34939502409266154`], FontColor -> 
              RGBColor[
               0.27293700340695715`, 0.6220617386593192, 
                0.34939502409266154`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.27293700340695715`, 0.6220617386593192, 
                0.34939502409266154`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8591907346813465, 0.2399347264337912, 
                0.8596128534349474], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8591907346813465, 0.2399347264337912, 
                0.8596128534349474], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8591907346813465, 0.2399347264337912, 0.8596128534349474], 
              FontColor -> 
              RGBColor[
               0.8591907346813465, 0.2399347264337912, 
                0.8596128534349474], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8591907346813465, 0.2399347264337912, 0.8596128534349474]]}, {
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4741042067179584, 0.8543530538554036, 
                0.1265691453146056], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4741042067179584, 0.8543530538554036, 
                0.1265691453146056], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4741042067179584, 0.8543530538554036, 0.1265691453146056], 
              FontColor -> 
              RGBColor[
               0.4741042067179584, 0.8543530538554036, 
                0.1265691453146056], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4741042067179584, 0.8543530538554036, 0.1265691453146056]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7475777566615376, 0.14932363679324845`, 
                0.16716408849918496`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7475777566615376, 0.14932363679324845`, 
                0.16716408849918496`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7475777566615376, 0.14932363679324845`, 
                0.16716408849918496`], FontColor -> 
              RGBColor[
               0.7475777566615376, 0.14932363679324845`, 
                0.16716408849918496`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7475777566615376, 0.14932363679324845`, 
                0.16716408849918496`]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6078367528123751, 0.6885948057010287, 
                0.6239330221034394], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6078367528123751, 0.6885948057010287, 
                0.6239330221034394], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6078367528123751, 0.6885948057010287, 0.6239330221034394], 
              FontColor -> 
              RGBColor[
               0.6078367528123751, 0.6885948057010287, 
                0.6239330221034394], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6078367528123751, 0.6885948057010287, 0.6239330221034394]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.022588378378586293`, 0.17926303192797532`, 
                0.16646652618014257`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.022588378378586293`, 0.17926303192797532`, 
                0.16646652618014257`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.022588378378586293`, 0.17926303192797532`, 
                0.16646652618014257`], FontColor -> 
              RGBColor[
               0.022588378378586293`, 0.17926303192797532`, 
                0.16646652618014257`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.022588378378586293`, 0.17926303192797532`, 
                0.16646652618014257`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.018790851446688794`, 0.5895644554646078, 
                0.025323912973879592`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.018790851446688794`, 0.5895644554646078, 
                0.025323912973879592`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.018790851446688794`, 0.5895644554646078, 
                0.025323912973879592`], FontColor -> 
              RGBColor[
               0.018790851446688794`, 0.5895644554646078, 
                0.025323912973879592`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.018790851446688794`, 0.5895644554646078, 
                0.025323912973879592`]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8041344085987416, 0.42219172727065635`, 
                0.6436952187025746], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8041344085987416, 0.42219172727065635`, 
                0.6436952187025746], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8041344085987416, 0.42219172727065635`, 0.6436952187025746], 
              FontColor -> 
              RGBColor[
               0.8041344085987416, 0.42219172727065635`, 
                0.6436952187025746], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8041344085987416, 0.42219172727065635`, 0.6436952187025746]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.14220027290927262`, 0.4846154428893077, 
                0.02745469040246018], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.14220027290927262`, 0.4846154428893077, 
                0.02745469040246018], $CellContext`GraphicsColor -> 
              RGBColor[
               0.14220027290927262`, 0.4846154428893077, 0.02745469040246018],
               FontColor -> 
              RGBColor[
               0.14220027290927262`, 0.4846154428893077, 
                0.02745469040246018], $CellContext`BackFaceColor -> 
              RGBColor[
               0.14220027290927262`, 0.4846154428893077, 
                0.02745469040246018]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.15338912761528545`, 0.18498643049585795`, 
                0.3148967838039214], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.15338912761528545`, 0.18498643049585795`, 
                0.3148967838039214], $CellContext`GraphicsColor -> 
              RGBColor[
               0.15338912761528545`, 0.18498643049585795`, 
                0.3148967838039214], FontColor -> 
              RGBColor[
               0.15338912761528545`, 0.18498643049585795`, 
                0.3148967838039214], $CellContext`BackFaceColor -> 
              RGBColor[
               0.15338912761528545`, 0.18498643049585795`, 
                0.3148967838039214]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8467085702946355, 0.5761775778282245, 
                0.926621716336651], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8467085702946355, 0.5761775778282245, 
                0.926621716336651], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8467085702946355, 0.5761775778282245, 0.926621716336651], 
              FontColor -> 
              RGBColor[
               0.8467085702946355, 0.5761775778282245, 
                0.926621716336651], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8467085702946355, 0.5761775778282245, 0.926621716336651]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4065254210564555, 0.49281524935183874`, 
                0.7964432262762404], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4065254210564555, 0.49281524935183874`, 
                0.7964432262762404], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4065254210564555, 0.49281524935183874`, 0.7964432262762404], 
              FontColor -> 
              RGBColor[
               0.4065254210564555, 0.49281524935183874`, 
                0.7964432262762404], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4065254210564555, 0.49281524935183874`, 
                0.7964432262762404]]}, {
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7143449857263597, 0.9584109036971555, 
                0.051700035041822856`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7143449857263597, 0.9584109036971555, 
                0.051700035041822856`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7143449857263597, 0.9584109036971555, 0.051700035041822856`],
               FontColor -> 
              RGBColor[
               0.7143449857263597, 0.9584109036971555, 
                0.051700035041822856`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7143449857263597, 0.9584109036971555, 
                0.051700035041822856`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9562802855764438, 0.7266225147604262, 
                0.7636529463317354], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9562802855764438, 0.7266225147604262, 
                0.7636529463317354], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9562802855764438, 0.7266225147604262, 0.7636529463317354], 
              FontColor -> 
              RGBColor[
               0.9562802855764438, 0.7266225147604262, 
                0.7636529463317354], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9562802855764438, 0.7266225147604262, 0.7636529463317354]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.34075749392844856`, 0.02350593528845346, 
                0.9484099186573012], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.34075749392844856`, 0.02350593528845346, 
                0.9484099186573012], $CellContext`GraphicsColor -> 
              RGBColor[
               0.34075749392844856`, 0.02350593528845346, 0.9484099186573012],
               FontColor -> 
              RGBColor[
               0.34075749392844856`, 0.02350593528845346, 
                0.9484099186573012], $CellContext`BackFaceColor -> 
              RGBColor[
               0.34075749392844856`, 0.02350593528845346, 
                0.9484099186573012]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5016754049095404, 0.1809735017223968, 
                0.280877501266114], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5016754049095404, 0.1809735017223968, 
                0.280877501266114], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5016754049095404, 0.1809735017223968, 0.280877501266114], 
              FontColor -> 
              RGBColor[
               0.5016754049095404, 0.1809735017223968, 
                0.280877501266114], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5016754049095404, 0.1809735017223968, 0.280877501266114]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7631321744028661, 0.43208427282032447`, 
                0.294834300080439], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7631321744028661, 0.43208427282032447`, 
                0.294834300080439], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7631321744028661, 0.43208427282032447`, 0.294834300080439], 
              FontColor -> 
              RGBColor[
               0.7631321744028661, 0.43208427282032447`, 
                0.294834300080439], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7631321744028661, 0.43208427282032447`, 0.294834300080439]], 
             
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.20583660535128567`, 0.9145612270255516, 
                0.9809229870431186], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.20583660535128567`, 0.9145612270255516, 
                0.9809229870431186], $CellContext`GraphicsColor -> 
              RGBColor[
               0.20583660535128567`, 0.9145612270255516, 0.9809229870431186], 
              FontColor -> 
              RGBColor[
               0.20583660535128567`, 0.9145612270255516, 
                0.9809229870431186], $CellContext`BackFaceColor -> 
              RGBColor[
               0.20583660535128567`, 0.9145612270255516, 0.9809229870431186]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.07744280042317508, 0.4358115718987561, 
                0.3006358652540213], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.07744280042317508, 0.4358115718987561, 
                0.3006358652540213], $CellContext`GraphicsColor -> 
              RGBColor[
               0.07744280042317508, 0.4358115718987561, 0.3006358652540213], 
              FontColor -> 
              RGBColor[
               0.07744280042317508, 0.4358115718987561, 
                0.3006358652540213], $CellContext`BackFaceColor -> 
              RGBColor[
               0.07744280042317508, 0.4358115718987561, 0.3006358652540213]], 
             
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.24474366047680896`, 0.22554120003414302`, 
                0.09374315922744358], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.24474366047680896`, 0.22554120003414302`, 
                0.09374315922744358], $CellContext`GraphicsColor -> 
              RGBColor[
               0.24474366047680896`, 0.22554120003414302`, 
                0.09374315922744358], FontColor -> 
              RGBColor[
               0.24474366047680896`, 0.22554120003414302`, 
                0.09374315922744358], $CellContext`BackFaceColor -> 
              RGBColor[
               0.24474366047680896`, 0.22554120003414302`, 
                0.09374315922744358]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.42364425622722135`, 0.7756177481578685, 
                0.7440317600046329], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.42364425622722135`, 0.7756177481578685, 
                0.7440317600046329], $CellContext`GraphicsColor -> 
              RGBColor[
               0.42364425622722135`, 0.7756177481578685, 0.7440317600046329], 
              FontColor -> 
              RGBColor[
               0.42364425622722135`, 0.7756177481578685, 
                0.7440317600046329], $CellContext`BackFaceColor -> 
              RGBColor[
               0.42364425622722135`, 0.7756177481578685, 0.7440317600046329]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.45394211366550374`, 0.8138082705320957, 
                0.061460883632106666`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.45394211366550374`, 0.8138082705320957, 
                0.061460883632106666`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.45394211366550374`, 0.8138082705320957, 
                0.061460883632106666`], FontColor -> 
              RGBColor[
               0.45394211366550374`, 0.8138082705320957, 
                0.061460883632106666`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.45394211366550374`, 0.8138082705320957, 
                0.061460883632106666`]]}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0449e284-22e8-4a82-b878-e3e7b7c767f1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a grid of all possible strings consisting of pairs of letters of the \
alphabet (\[OpenCurlyDoubleQuote]aa\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ab\[CloseCurlyDoubleQuote], etc.).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7fe71099-7450-4c46-b8c7-73bba58728c6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"aa\"\>", "\<\"ab\"\>", "\<\"ac\"\>", "\<\"ad\"\>", \
"\<\"ae\"\>", "\<\"af\"\>", "\<\"ag\"\>", "\<\"ah\"\>", "\<\"ai\"\>", "\<\"aj\
\"\>", "\<\"ak\"\>", "\<\"al\"\>", "\<\"am\"\>", "\<\"an\"\>", "\<\"ao\"\>", \
"\<\"ap\"\>", "\<\"aq\"\>", "\<\"ar\"\>", "\<\"as\"\>", "\<\"at\"\>", "\<\"au\
\"\>", "\<\"av\"\>", "\<\"aw\"\>", "\<\"ax\"\>", "\<\"ay\"\>", "\<\"az\"\>"},
          {"\<\"ba\"\>", "\<\"bb\"\>", "\<\"bc\"\>", "\<\"bd\"\>", \
"\<\"be\"\>", "\<\"bf\"\>", "\<\"bg\"\>", "\<\"bh\"\>", "\<\"bi\"\>", "\<\"bj\
\"\>", "\<\"bk\"\>", "\<\"bl\"\>", "\<\"bm\"\>", "\<\"bn\"\>", "\<\"bo\"\>", \
"\<\"bp\"\>", "\<\"bq\"\>", "\<\"br\"\>", "\<\"bs\"\>", "\<\"bt\"\>", "\<\"bu\
\"\>", "\<\"bv\"\>", "\<\"bw\"\>", "\<\"bx\"\>", "\<\"by\"\>", "\<\"bz\"\>"},
          {"\<\"ca\"\>", "\<\"cb\"\>", "\<\"cc\"\>", "\<\"cd\"\>", \
"\<\"ce\"\>", "\<\"cf\"\>", "\<\"cg\"\>", "\<\"ch\"\>", "\<\"ci\"\>", "\<\"cj\
\"\>", "\<\"ck\"\>", "\<\"cl\"\>", "\<\"cm\"\>", "\<\"cn\"\>", "\<\"co\"\>", \
"\<\"cp\"\>", "\<\"cq\"\>", "\<\"cr\"\>", "\<\"cs\"\>", "\<\"ct\"\>", "\<\"cu\
\"\>", "\<\"cv\"\>", "\<\"cw\"\>", "\<\"cx\"\>", "\<\"cy\"\>", "\<\"cz\"\>"},
          {"\<\"da\"\>", "\<\"db\"\>", "\<\"dc\"\>", "\<\"dd\"\>", \
"\<\"de\"\>", "\<\"df\"\>", "\<\"dg\"\>", "\<\"dh\"\>", "\<\"di\"\>", "\<\"dj\
\"\>", "\<\"dk\"\>", "\<\"dl\"\>", "\<\"dm\"\>", "\<\"dn\"\>", "\<\"do\"\>", \
"\<\"dp\"\>", "\<\"dq\"\>", "\<\"dr\"\>", "\<\"ds\"\>", "\<\"dt\"\>", "\<\"du\
\"\>", "\<\"dv\"\>", "\<\"dw\"\>", "\<\"dx\"\>", "\<\"dy\"\>", "\<\"dz\"\>"},
          {"\<\"ea\"\>", "\<\"eb\"\>", "\<\"ec\"\>", "\<\"ed\"\>", \
"\<\"ee\"\>", "\<\"ef\"\>", "\<\"eg\"\>", "\<\"eh\"\>", "\<\"ei\"\>", "\<\"ej\
\"\>", "\<\"ek\"\>", "\<\"el\"\>", "\<\"em\"\>", "\<\"en\"\>", "\<\"eo\"\>", \
"\<\"ep\"\>", "\<\"eq\"\>", "\<\"er\"\>", "\<\"es\"\>", "\<\"et\"\>", "\<\"eu\
\"\>", "\<\"ev\"\>", "\<\"ew\"\>", "\<\"ex\"\>", "\<\"ey\"\>", "\<\"ez\"\>"},
          {"\<\"fa\"\>", "\<\"fb\"\>", "\<\"fc\"\>", "\<\"fd\"\>", \
"\<\"fe\"\>", "\<\"ff\"\>", "\<\"fg\"\>", "\<\"fh\"\>", "\<\"fi\"\>", "\<\"fj\
\"\>", "\<\"fk\"\>", "\<\"fl\"\>", "\<\"fm\"\>", "\<\"fn\"\>", "\<\"fo\"\>", \
"\<\"fp\"\>", "\<\"fq\"\>", "\<\"fr\"\>", "\<\"fs\"\>", "\<\"ft\"\>", "\<\"fu\
\"\>", "\<\"fv\"\>", "\<\"fw\"\>", "\<\"fx\"\>", "\<\"fy\"\>", "\<\"fz\"\>"},
          {"\<\"ga\"\>", "\<\"gb\"\>", "\<\"gc\"\>", "\<\"gd\"\>", \
"\<\"ge\"\>", "\<\"gf\"\>", "\<\"gg\"\>", "\<\"gh\"\>", "\<\"gi\"\>", "\<\"gj\
\"\>", "\<\"gk\"\>", "\<\"gl\"\>", "\<\"gm\"\>", "\<\"gn\"\>", "\<\"go\"\>", \
"\<\"gp\"\>", "\<\"gq\"\>", "\<\"gr\"\>", "\<\"gs\"\>", "\<\"gt\"\>", "\<\"gu\
\"\>", "\<\"gv\"\>", "\<\"gw\"\>", "\<\"gx\"\>", "\<\"gy\"\>", "\<\"gz\"\>"},
          {"\<\"ha\"\>", "\<\"hb\"\>", "\<\"hc\"\>", "\<\"hd\"\>", \
"\<\"he\"\>", "\<\"hf\"\>", "\<\"hg\"\>", "\<\"hh\"\>", "\<\"hi\"\>", "\<\"hj\
\"\>", "\<\"hk\"\>", "\<\"hl\"\>", "\<\"hm\"\>", "\<\"hn\"\>", "\<\"ho\"\>", \
"\<\"hp\"\>", "\<\"hq\"\>", "\<\"hr\"\>", "\<\"hs\"\>", "\<\"ht\"\>", "\<\"hu\
\"\>", "\<\"hv\"\>", "\<\"hw\"\>", "\<\"hx\"\>", "\<\"hy\"\>", "\<\"hz\"\>"},
          {"\<\"ia\"\>", "\<\"ib\"\>", "\<\"ic\"\>", "\<\"id\"\>", \
"\<\"ie\"\>", "\<\"if\"\>", "\<\"ig\"\>", "\<\"ih\"\>", "\<\"ii\"\>", "\<\"ij\
\"\>", "\<\"ik\"\>", "\<\"il\"\>", "\<\"im\"\>", "\<\"in\"\>", "\<\"io\"\>", \
"\<\"ip\"\>", "\<\"iq\"\>", "\<\"ir\"\>", "\<\"is\"\>", "\<\"it\"\>", "\<\"iu\
\"\>", "\<\"iv\"\>", "\<\"iw\"\>", "\<\"ix\"\>", "\<\"iy\"\>", "\<\"iz\"\>"},
          {"\<\"ja\"\>", "\<\"jb\"\>", "\<\"jc\"\>", "\<\"jd\"\>", \
"\<\"je\"\>", "\<\"jf\"\>", "\<\"jg\"\>", "\<\"jh\"\>", "\<\"ji\"\>", "\<\"jj\
\"\>", "\<\"jk\"\>", "\<\"jl\"\>", "\<\"jm\"\>", "\<\"jn\"\>", "\<\"jo\"\>", \
"\<\"jp\"\>", "\<\"jq\"\>", "\<\"jr\"\>", "\<\"js\"\>", "\<\"jt\"\>", "\<\"ju\
\"\>", "\<\"jv\"\>", "\<\"jw\"\>", "\<\"jx\"\>", "\<\"jy\"\>", "\<\"jz\"\>"},
          {"\<\"ka\"\>", "\<\"kb\"\>", "\<\"kc\"\>", "\<\"kd\"\>", \
"\<\"ke\"\>", "\<\"kf\"\>", "\<\"kg\"\>", "\<\"kh\"\>", "\<\"ki\"\>", "\<\"kj\
\"\>", "\<\"kk\"\>", "\<\"kl\"\>", "\<\"km\"\>", "\<\"kn\"\>", "\<\"ko\"\>", \
"\<\"kp\"\>", "\<\"kq\"\>", "\<\"kr\"\>", "\<\"ks\"\>", "\<\"kt\"\>", "\<\"ku\
\"\>", "\<\"kv\"\>", "\<\"kw\"\>", "\<\"kx\"\>", "\<\"ky\"\>", "\<\"kz\"\>"},
          {"\<\"la\"\>", "\<\"lb\"\>", "\<\"lc\"\>", "\<\"ld\"\>", \
"\<\"le\"\>", "\<\"lf\"\>", "\<\"lg\"\>", "\<\"lh\"\>", "\<\"li\"\>", "\<\"lj\
\"\>", "\<\"lk\"\>", "\<\"ll\"\>", "\<\"lm\"\>", "\<\"ln\"\>", "\<\"lo\"\>", \
"\<\"lp\"\>", "\<\"lq\"\>", "\<\"lr\"\>", "\<\"ls\"\>", "\<\"lt\"\>", "\<\"lu\
\"\>", "\<\"lv\"\>", "\<\"lw\"\>", "\<\"lx\"\>", "\<\"ly\"\>", "\<\"lz\"\>"},
          {"\<\"ma\"\>", "\<\"mb\"\>", "\<\"mc\"\>", "\<\"md\"\>", \
"\<\"me\"\>", "\<\"mf\"\>", "\<\"mg\"\>", "\<\"mh\"\>", "\<\"mi\"\>", "\<\"mj\
\"\>", "\<\"mk\"\>", "\<\"ml\"\>", "\<\"mm\"\>", "\<\"mn\"\>", "\<\"mo\"\>", \
"\<\"mp\"\>", "\<\"mq\"\>", "\<\"mr\"\>", "\<\"ms\"\>", "\<\"mt\"\>", "\<\"mu\
\"\>", "\<\"mv\"\>", "\<\"mw\"\>", "\<\"mx\"\>", "\<\"my\"\>", "\<\"mz\"\>"},
          {"\<\"na\"\>", "\<\"nb\"\>", "\<\"nc\"\>", "\<\"nd\"\>", \
"\<\"ne\"\>", "\<\"nf\"\>", "\<\"ng\"\>", "\<\"nh\"\>", "\<\"ni\"\>", "\<\"nj\
\"\>", "\<\"nk\"\>", "\<\"nl\"\>", "\<\"nm\"\>", "\<\"nn\"\>", "\<\"no\"\>", \
"\<\"np\"\>", "\<\"nq\"\>", "\<\"nr\"\>", "\<\"ns\"\>", "\<\"nt\"\>", "\<\"nu\
\"\>", "\<\"nv\"\>", "\<\"nw\"\>", "\<\"nx\"\>", "\<\"ny\"\>", "\<\"nz\"\>"},
          {"\<\"oa\"\>", "\<\"ob\"\>", "\<\"oc\"\>", "\<\"od\"\>", \
"\<\"oe\"\>", "\<\"of\"\>", "\<\"og\"\>", "\<\"oh\"\>", "\<\"oi\"\>", "\<\"oj\
\"\>", "\<\"ok\"\>", "\<\"ol\"\>", "\<\"om\"\>", "\<\"on\"\>", "\<\"oo\"\>", \
"\<\"op\"\>", "\<\"oq\"\>", "\<\"or\"\>", "\<\"os\"\>", "\<\"ot\"\>", "\<\"ou\
\"\>", "\<\"ov\"\>", "\<\"ow\"\>", "\<\"ox\"\>", "\<\"oy\"\>", "\<\"oz\"\>"},
          {"\<\"pa\"\>", "\<\"pb\"\>", "\<\"pc\"\>", "\<\"pd\"\>", \
"\<\"pe\"\>", "\<\"pf\"\>", "\<\"pg\"\>", "\<\"ph\"\>", "\<\"pi\"\>", "\<\"pj\
\"\>", "\<\"pk\"\>", "\<\"pl\"\>", "\<\"pm\"\>", "\<\"pn\"\>", "\<\"po\"\>", \
"\<\"pp\"\>", "\<\"pq\"\>", "\<\"pr\"\>", "\<\"ps\"\>", "\<\"pt\"\>", "\<\"pu\
\"\>", "\<\"pv\"\>", "\<\"pw\"\>", "\<\"px\"\>", "\<\"py\"\>", "\<\"pz\"\>"},
          {"\<\"qa\"\>", "\<\"qb\"\>", "\<\"qc\"\>", "\<\"qd\"\>", \
"\<\"qe\"\>", "\<\"qf\"\>", "\<\"qg\"\>", "\<\"qh\"\>", "\<\"qi\"\>", "\<\"qj\
\"\>", "\<\"qk\"\>", "\<\"ql\"\>", "\<\"qm\"\>", "\<\"qn\"\>", "\<\"qo\"\>", \
"\<\"qp\"\>", "\<\"qq\"\>", "\<\"qr\"\>", "\<\"qs\"\>", "\<\"qt\"\>", "\<\"qu\
\"\>", "\<\"qv\"\>", "\<\"qw\"\>", "\<\"qx\"\>", "\<\"qy\"\>", "\<\"qz\"\>"},
          {"\<\"ra\"\>", "\<\"rb\"\>", "\<\"rc\"\>", "\<\"rd\"\>", \
"\<\"re\"\>", "\<\"rf\"\>", "\<\"rg\"\>", "\<\"rh\"\>", "\<\"ri\"\>", "\<\"rj\
\"\>", "\<\"rk\"\>", "\<\"rl\"\>", "\<\"rm\"\>", "\<\"rn\"\>", "\<\"ro\"\>", \
"\<\"rp\"\>", "\<\"rq\"\>", "\<\"rr\"\>", "\<\"rs\"\>", "\<\"rt\"\>", "\<\"ru\
\"\>", "\<\"rv\"\>", "\<\"rw\"\>", "\<\"rx\"\>", "\<\"ry\"\>", "\<\"rz\"\>"},
          {"\<\"sa\"\>", "\<\"sb\"\>", "\<\"sc\"\>", "\<\"sd\"\>", \
"\<\"se\"\>", "\<\"sf\"\>", "\<\"sg\"\>", "\<\"sh\"\>", "\<\"si\"\>", "\<\"sj\
\"\>", "\<\"sk\"\>", "\<\"sl\"\>", "\<\"sm\"\>", "\<\"sn\"\>", "\<\"so\"\>", \
"\<\"sp\"\>", "\<\"sq\"\>", "\<\"sr\"\>", "\<\"ss\"\>", "\<\"st\"\>", "\<\"su\
\"\>", "\<\"sv\"\>", "\<\"sw\"\>", "\<\"sx\"\>", "\<\"sy\"\>", "\<\"sz\"\>"},
          {"\<\"ta\"\>", "\<\"tb\"\>", "\<\"tc\"\>", "\<\"td\"\>", \
"\<\"te\"\>", "\<\"tf\"\>", "\<\"tg\"\>", "\<\"th\"\>", "\<\"ti\"\>", "\<\"tj\
\"\>", "\<\"tk\"\>", "\<\"tl\"\>", "\<\"tm\"\>", "\<\"tn\"\>", "\<\"to\"\>", \
"\<\"tp\"\>", "\<\"tq\"\>", "\<\"tr\"\>", "\<\"ts\"\>", "\<\"tt\"\>", "\<\"tu\
\"\>", "\<\"tv\"\>", "\<\"tw\"\>", "\<\"tx\"\>", "\<\"ty\"\>", "\<\"tz\"\>"},
          {"\<\"ua\"\>", "\<\"ub\"\>", "\<\"uc\"\>", "\<\"ud\"\>", \
"\<\"ue\"\>", "\<\"uf\"\>", "\<\"ug\"\>", "\<\"uh\"\>", "\<\"ui\"\>", "\<\"uj\
\"\>", "\<\"uk\"\>", "\<\"ul\"\>", "\<\"um\"\>", "\<\"un\"\>", "\<\"uo\"\>", \
"\<\"up\"\>", "\<\"uq\"\>", "\<\"ur\"\>", "\<\"us\"\>", "\<\"ut\"\>", "\<\"uu\
\"\>", "\<\"uv\"\>", "\<\"uw\"\>", "\<\"ux\"\>", "\<\"uy\"\>", "\<\"uz\"\>"},
          {"\<\"va\"\>", "\<\"vb\"\>", "\<\"vc\"\>", "\<\"vd\"\>", \
"\<\"ve\"\>", "\<\"vf\"\>", "\<\"vg\"\>", "\<\"vh\"\>", "\<\"vi\"\>", "\<\"vj\
\"\>", "\<\"vk\"\>", "\<\"vl\"\>", "\<\"vm\"\>", "\<\"vn\"\>", "\<\"vo\"\>", \
"\<\"vp\"\>", "\<\"vq\"\>", "\<\"vr\"\>", "\<\"vs\"\>", "\<\"vt\"\>", "\<\"vu\
\"\>", "\<\"vv\"\>", "\<\"vw\"\>", "\<\"vx\"\>", "\<\"vy\"\>", "\<\"vz\"\>"},
          {"\<\"wa\"\>", "\<\"wb\"\>", "\<\"wc\"\>", "\<\"wd\"\>", \
"\<\"we\"\>", "\<\"wf\"\>", "\<\"wg\"\>", "\<\"wh\"\>", "\<\"wi\"\>", "\<\"wj\
\"\>", "\<\"wk\"\>", "\<\"wl\"\>", "\<\"wm\"\>", "\<\"wn\"\>", "\<\"wo\"\>", \
"\<\"wp\"\>", "\<\"wq\"\>", "\<\"wr\"\>", "\<\"ws\"\>", "\<\"wt\"\>", "\<\"wu\
\"\>", "\<\"wv\"\>", "\<\"ww\"\>", "\<\"wx\"\>", "\<\"wy\"\>", "\<\"wz\"\>"},
          {"\<\"xa\"\>", "\<\"xb\"\>", "\<\"xc\"\>", "\<\"xd\"\>", \
"\<\"xe\"\>", "\<\"xf\"\>", "\<\"xg\"\>", "\<\"xh\"\>", "\<\"xi\"\>", "\<\"xj\
\"\>", "\<\"xk\"\>", "\<\"xl\"\>", "\<\"xm\"\>", "\<\"xn\"\>", "\<\"xo\"\>", \
"\<\"xp\"\>", "\<\"xq\"\>", "\<\"xr\"\>", "\<\"xs\"\>", "\<\"xt\"\>", "\<\"xu\
\"\>", "\<\"xv\"\>", "\<\"xw\"\>", "\<\"xx\"\>", "\<\"xy\"\>", "\<\"xz\"\>"},
          {"\<\"ya\"\>", "\<\"yb\"\>", "\<\"yc\"\>", "\<\"yd\"\>", \
"\<\"ye\"\>", "\<\"yf\"\>", "\<\"yg\"\>", "\<\"yh\"\>", "\<\"yi\"\>", "\<\"yj\
\"\>", "\<\"yk\"\>", "\<\"yl\"\>", "\<\"ym\"\>", "\<\"yn\"\>", "\<\"yo\"\>", \
"\<\"yp\"\>", "\<\"yq\"\>", "\<\"yr\"\>", "\<\"ys\"\>", "\<\"yt\"\>", "\<\"yu\
\"\>", "\<\"yv\"\>", "\<\"yw\"\>", "\<\"yx\"\>", "\<\"yy\"\>", "\<\"yz\"\>"},
          {"\<\"za\"\>", "\<\"zb\"\>", "\<\"zc\"\>", "\<\"zd\"\>", \
"\<\"ze\"\>", "\<\"zf\"\>", "\<\"zg\"\>", "\<\"zh\"\>", "\<\"zi\"\>", "\<\"zj\
\"\>", "\<\"zk\"\>", "\<\"zl\"\>", "\<\"zm\"\>", "\<\"zn\"\>", "\<\"zo\"\>", \
"\<\"zp\"\>", "\<\"zq\"\>", "\<\"zr\"\>", "\<\"zs\"\>", "\<\"zt\"\>", "\<\"zu\
\"\>", "\<\"zv\"\>", "\<\"zw\"\>", "\<\"zx\"\>", "\<\"zy\"\>", "\<\"zz\"\>"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",
       PageWidth:>DirectedInfinity[1],ExpressionUUID->
       "725eca06-6ce1-4fee-94e0-d5d5de3f423f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "\"aa\"", "\"ab\"", "\"ac\"", "\"ad\"", "\"ae\"", "\"af\"", 
             "\"ag\"", "\"ah\"", "\"ai\"", "\"aj\"", "\"ak\"", "\"al\"", 
             "\"am\"", "\"an\"", "\"ao\"", "\"ap\"", "\"aq\"", "\"ar\"", 
             "\"as\"", "\"at\"", "\"au\"", "\"av\"", "\"aw\"", "\"ax\"", 
             "\"ay\"", "\"az\""}, {
            "\"ba\"", "\"bb\"", "\"bc\"", "\"bd\"", "\"be\"", "\"bf\"", 
             "\"bg\"", "\"bh\"", "\"bi\"", "\"bj\"", "\"bk\"", "\"bl\"", 
             "\"bm\"", "\"bn\"", "\"bo\"", "\"bp\"", "\"bq\"", "\"br\"", 
             "\"bs\"", "\"bt\"", "\"bu\"", "\"bv\"", "\"bw\"", "\"bx\"", 
             "\"by\"", "\"bz\""}, {
            "\"ca\"", "\"cb\"", "\"cc\"", "\"cd\"", "\"ce\"", "\"cf\"", 
             "\"cg\"", "\"ch\"", "\"ci\"", "\"cj\"", "\"ck\"", "\"cl\"", 
             "\"cm\"", "\"cn\"", "\"co\"", "\"cp\"", "\"cq\"", "\"cr\"", 
             "\"cs\"", "\"ct\"", "\"cu\"", "\"cv\"", "\"cw\"", "\"cx\"", 
             "\"cy\"", "\"cz\""}, {
            "\"da\"", "\"db\"", "\"dc\"", "\"dd\"", "\"de\"", "\"df\"", 
             "\"dg\"", "\"dh\"", "\"di\"", "\"dj\"", "\"dk\"", "\"dl\"", 
             "\"dm\"", "\"dn\"", "\"do\"", "\"dp\"", "\"dq\"", "\"dr\"", 
             "\"ds\"", "\"dt\"", "\"du\"", "\"dv\"", "\"dw\"", "\"dx\"", 
             "\"dy\"", "\"dz\""}, {
            "\"ea\"", "\"eb\"", "\"ec\"", "\"ed\"", "\"ee\"", "\"ef\"", 
             "\"eg\"", "\"eh\"", "\"ei\"", "\"ej\"", "\"ek\"", "\"el\"", 
             "\"em\"", "\"en\"", "\"eo\"", "\"ep\"", "\"eq\"", "\"er\"", 
             "\"es\"", "\"et\"", "\"eu\"", "\"ev\"", "\"ew\"", "\"ex\"", 
             "\"ey\"", "\"ez\""}, {
            "\"fa\"", "\"fb\"", "\"fc\"", "\"fd\"", "\"fe\"", "\"ff\"", 
             "\"fg\"", "\"fh\"", "\"fi\"", "\"fj\"", "\"fk\"", "\"fl\"", 
             "\"fm\"", "\"fn\"", "\"fo\"", "\"fp\"", "\"fq\"", "\"fr\"", 
             "\"fs\"", "\"ft\"", "\"fu\"", "\"fv\"", "\"fw\"", "\"fx\"", 
             "\"fy\"", "\"fz\""}, {
            "\"ga\"", "\"gb\"", "\"gc\"", "\"gd\"", "\"ge\"", "\"gf\"", 
             "\"gg\"", "\"gh\"", "\"gi\"", "\"gj\"", "\"gk\"", "\"gl\"", 
             "\"gm\"", "\"gn\"", "\"go\"", "\"gp\"", "\"gq\"", "\"gr\"", 
             "\"gs\"", "\"gt\"", "\"gu\"", "\"gv\"", "\"gw\"", "\"gx\"", 
             "\"gy\"", "\"gz\""}, {
            "\"ha\"", "\"hb\"", "\"hc\"", "\"hd\"", "\"he\"", "\"hf\"", 
             "\"hg\"", "\"hh\"", "\"hi\"", "\"hj\"", "\"hk\"", "\"hl\"", 
             "\"hm\"", "\"hn\"", "\"ho\"", "\"hp\"", "\"hq\"", "\"hr\"", 
             "\"hs\"", "\"ht\"", "\"hu\"", "\"hv\"", "\"hw\"", "\"hx\"", 
             "\"hy\"", "\"hz\""}, {
            "\"ia\"", "\"ib\"", "\"ic\"", "\"id\"", "\"ie\"", "\"if\"", 
             "\"ig\"", "\"ih\"", "\"ii\"", "\"ij\"", "\"ik\"", "\"il\"", 
             "\"im\"", "\"in\"", "\"io\"", "\"ip\"", "\"iq\"", "\"ir\"", 
             "\"is\"", "\"it\"", "\"iu\"", "\"iv\"", "\"iw\"", "\"ix\"", 
             "\"iy\"", "\"iz\""}, {
            "\"ja\"", "\"jb\"", "\"jc\"", "\"jd\"", "\"je\"", "\"jf\"", 
             "\"jg\"", "\"jh\"", "\"ji\"", "\"jj\"", "\"jk\"", "\"jl\"", 
             "\"jm\"", "\"jn\"", "\"jo\"", "\"jp\"", "\"jq\"", "\"jr\"", 
             "\"js\"", "\"jt\"", "\"ju\"", "\"jv\"", "\"jw\"", "\"jx\"", 
             "\"jy\"", "\"jz\""}, {
            "\"ka\"", "\"kb\"", "\"kc\"", "\"kd\"", "\"ke\"", "\"kf\"", 
             "\"kg\"", "\"kh\"", "\"ki\"", "\"kj\"", "\"kk\"", "\"kl\"", 
             "\"km\"", "\"kn\"", "\"ko\"", "\"kp\"", "\"kq\"", "\"kr\"", 
             "\"ks\"", "\"kt\"", "\"ku\"", "\"kv\"", "\"kw\"", "\"kx\"", 
             "\"ky\"", "\"kz\""}, {
            "\"la\"", "\"lb\"", "\"lc\"", "\"ld\"", "\"le\"", "\"lf\"", 
             "\"lg\"", "\"lh\"", "\"li\"", "\"lj\"", "\"lk\"", "\"ll\"", 
             "\"lm\"", "\"ln\"", "\"lo\"", "\"lp\"", "\"lq\"", "\"lr\"", 
             "\"ls\"", "\"lt\"", "\"lu\"", "\"lv\"", "\"lw\"", "\"lx\"", 
             "\"ly\"", "\"lz\""}, {
            "\"ma\"", "\"mb\"", "\"mc\"", "\"md\"", "\"me\"", "\"mf\"", 
             "\"mg\"", "\"mh\"", "\"mi\"", "\"mj\"", "\"mk\"", "\"ml\"", 
             "\"mm\"", "\"mn\"", "\"mo\"", "\"mp\"", "\"mq\"", "\"mr\"", 
             "\"ms\"", "\"mt\"", "\"mu\"", "\"mv\"", "\"mw\"", "\"mx\"", 
             "\"my\"", "\"mz\""}, {
            "\"na\"", "\"nb\"", "\"nc\"", "\"nd\"", "\"ne\"", "\"nf\"", 
             "\"ng\"", "\"nh\"", "\"ni\"", "\"nj\"", "\"nk\"", "\"nl\"", 
             "\"nm\"", "\"nn\"", "\"no\"", "\"np\"", "\"nq\"", "\"nr\"", 
             "\"ns\"", "\"nt\"", "\"nu\"", "\"nv\"", "\"nw\"", "\"nx\"", 
             "\"ny\"", "\"nz\""}, {
            "\"oa\"", "\"ob\"", "\"oc\"", "\"od\"", "\"oe\"", "\"of\"", 
             "\"og\"", "\"oh\"", "\"oi\"", "\"oj\"", "\"ok\"", "\"ol\"", 
             "\"om\"", "\"on\"", "\"oo\"", "\"op\"", "\"oq\"", "\"or\"", 
             "\"os\"", "\"ot\"", "\"ou\"", "\"ov\"", "\"ow\"", "\"ox\"", 
             "\"oy\"", "\"oz\""}, {
            "\"pa\"", "\"pb\"", "\"pc\"", "\"pd\"", "\"pe\"", "\"pf\"", 
             "\"pg\"", "\"ph\"", "\"pi\"", "\"pj\"", "\"pk\"", "\"pl\"", 
             "\"pm\"", "\"pn\"", "\"po\"", "\"pp\"", "\"pq\"", "\"pr\"", 
             "\"ps\"", "\"pt\"", "\"pu\"", "\"pv\"", "\"pw\"", "\"px\"", 
             "\"py\"", "\"pz\""}, {
            "\"qa\"", "\"qb\"", "\"qc\"", "\"qd\"", "\"qe\"", "\"qf\"", 
             "\"qg\"", "\"qh\"", "\"qi\"", "\"qj\"", "\"qk\"", "\"ql\"", 
             "\"qm\"", "\"qn\"", "\"qo\"", "\"qp\"", "\"qq\"", "\"qr\"", 
             "\"qs\"", "\"qt\"", "\"qu\"", "\"qv\"", "\"qw\"", "\"qx\"", 
             "\"qy\"", "\"qz\""}, {
            "\"ra\"", "\"rb\"", "\"rc\"", "\"rd\"", "\"re\"", "\"rf\"", 
             "\"rg\"", "\"rh\"", "\"ri\"", "\"rj\"", "\"rk\"", "\"rl\"", 
             "\"rm\"", "\"rn\"", "\"ro\"", "\"rp\"", "\"rq\"", "\"rr\"", 
             "\"rs\"", "\"rt\"", "\"ru\"", "\"rv\"", "\"rw\"", "\"rx\"", 
             "\"ry\"", "\"rz\""}, {
            "\"sa\"", "\"sb\"", "\"sc\"", "\"sd\"", "\"se\"", "\"sf\"", 
             "\"sg\"", "\"sh\"", "\"si\"", "\"sj\"", "\"sk\"", "\"sl\"", 
             "\"sm\"", "\"sn\"", "\"so\"", "\"sp\"", "\"sq\"", "\"sr\"", 
             "\"ss\"", "\"st\"", "\"su\"", "\"sv\"", "\"sw\"", "\"sx\"", 
             "\"sy\"", "\"sz\""}, {
            "\"ta\"", "\"tb\"", "\"tc\"", "\"td\"", "\"te\"", "\"tf\"", 
             "\"tg\"", "\"th\"", "\"ti\"", "\"tj\"", "\"tk\"", "\"tl\"", 
             "\"tm\"", "\"tn\"", "\"to\"", "\"tp\"", "\"tq\"", "\"tr\"", 
             "\"ts\"", "\"tt\"", "\"tu\"", "\"tv\"", "\"tw\"", "\"tx\"", 
             "\"ty\"", "\"tz\""}, {
            "\"ua\"", "\"ub\"", "\"uc\"", "\"ud\"", "\"ue\"", "\"uf\"", 
             "\"ug\"", "\"uh\"", "\"ui\"", "\"uj\"", "\"uk\"", "\"ul\"", 
             "\"um\"", "\"un\"", "\"uo\"", "\"up\"", "\"uq\"", "\"ur\"", 
             "\"us\"", "\"ut\"", "\"uu\"", "\"uv\"", "\"uw\"", "\"ux\"", 
             "\"uy\"", "\"uz\""}, {
            "\"va\"", "\"vb\"", "\"vc\"", "\"vd\"", "\"ve\"", "\"vf\"", 
             "\"vg\"", "\"vh\"", "\"vi\"", "\"vj\"", "\"vk\"", "\"vl\"", 
             "\"vm\"", "\"vn\"", "\"vo\"", "\"vp\"", "\"vq\"", "\"vr\"", 
             "\"vs\"", "\"vt\"", "\"vu\"", "\"vv\"", "\"vw\"", "\"vx\"", 
             "\"vy\"", "\"vz\""}, {
            "\"wa\"", "\"wb\"", "\"wc\"", "\"wd\"", "\"we\"", "\"wf\"", 
             "\"wg\"", "\"wh\"", "\"wi\"", "\"wj\"", "\"wk\"", "\"wl\"", 
             "\"wm\"", "\"wn\"", "\"wo\"", "\"wp\"", "\"wq\"", "\"wr\"", 
             "\"ws\"", "\"wt\"", "\"wu\"", "\"wv\"", "\"ww\"", "\"wx\"", 
             "\"wy\"", "\"wz\""}, {
            "\"xa\"", "\"xb\"", "\"xc\"", "\"xd\"", "\"xe\"", "\"xf\"", 
             "\"xg\"", "\"xh\"", "\"xi\"", "\"xj\"", "\"xk\"", "\"xl\"", 
             "\"xm\"", "\"xn\"", "\"xo\"", "\"xp\"", "\"xq\"", "\"xr\"", 
             "\"xs\"", "\"xt\"", "\"xu\"", "\"xv\"", "\"xw\"", "\"xx\"", 
             "\"xy\"", "\"xz\""}, {
            "\"ya\"", "\"yb\"", "\"yc\"", "\"yd\"", "\"ye\"", "\"yf\"", 
             "\"yg\"", "\"yh\"", "\"yi\"", "\"yj\"", "\"yk\"", "\"yl\"", 
             "\"ym\"", "\"yn\"", "\"yo\"", "\"yp\"", "\"yq\"", "\"yr\"", 
             "\"ys\"", "\"yt\"", "\"yu\"", "\"yv\"", "\"yw\"", "\"yx\"", 
             "\"yy\"", "\"yz\""}, {
            "\"za\"", "\"zb\"", "\"zc\"", "\"zd\"", "\"ze\"", "\"zf\"", 
             "\"zg\"", "\"zh\"", "\"zi\"", "\"zj\"", "\"zk\"", "\"zl\"", 
             "\"zm\"", "\"zn\"", "\"zo\"", "\"zp\"", "\"zq\"", "\"zr\"", 
             "\"zs\"", "\"zt\"", "\"zu\"", "\"zv\"", "\"zw\"", "\"zx\"", 
             "\"zy\"", "\"zz\""}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c8df649d-d282-4568-b745-88309d091581"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Visualize ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"b23d725b-93f0-4b49-b6da-966db8bb14fa"],
 " with a pie chart, number line, line plot and bar chart. Place these in a 2\
\[Times]2 grid.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bb5d54ce-dbcc-43ce-b81a-8e4065118263"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           GraphicsBox[{{}, {}, 
             
             DynamicModuleBox[{DynamicChart`click$37279$37390 = False, 
              DynamicChart`click$37282$37390 = False, 
              DynamicChart`click$37285$37390 = False, 
              DynamicChart`click$37288$37390 = False, 
              DynamicChart`click$37291$37390 = False}, {
               {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
                0.5]}], {{{}, {
                   {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.722713633111154, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-43.46093129764995, \
-1.5857864376269042`}}],
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37279$37390, 
                    FEPrivate`Not[DynamicChart`click$37279$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$37279$37390, {{{1., 0}, {
                    0, 1.}}, {-0.19562952014676113`, 
                    0.041582338163551946`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$37279$37390}]]}, 
                   {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
                    0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    2.722713633111154}]},
                    
                    ImageSizeCache->{{30.88542250393722, 
                    169.4142135623731}, {-100.4142135623731, \
-1.5857864376268935`}}],
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37282$37390, 
                    FEPrivate`Not[DynamicChart`click$37282$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$37282$37390, {{{1., 0}, {
                    0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37282$37390}]]}, 
                   {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.2094395102393194, 
                    1.0471975511965979`}]},
                    
                    ImageSizeCache->{{118.5857864376269, 
                    217.4142135623731}, {-87.55265232567922, 
                    18.373735880877987`}}],
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37285$37390, 
                    FEPrivate`Not[DynamicChart`click$37285$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$37285$37390, {{{1., 0}, {0, 1.}}, {
                    0.1827090915285202, 0.08134732861516007}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37285$37390}]]}, 
                   {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{
                    GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.3038346126325155`, -0.2094395102393194}]},
                    
                    ImageSizeCache->{{54.349248227176474`, 
                    215.31638323281845`}, {-4.4142135623731065`, 
                    94.4142135623731}}],
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37288$37390, 
                    FEPrivate`Not[DynamicChart`click$37288$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$37288$37390, {{{1., 0}, {0, 1.}}, {
                    0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37288$37390}]]}, 
                   {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[
                    0], Opacity[0.5]}], GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.3038346126325155`}]},
                    
                    ImageSizeCache->{{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    69.75611680820292}}],
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37291$37390, 
                    FEPrivate`Not[DynamicChart`click$37291$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                    If[DynamicChart`click$37291$37390, {{{1., 0}, {
                    0, 1.}}, {-0.18270909152852022`, -0.08134732861516002}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$37291$37390}]]}}}, {}}, {}}, {{{
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 1]& ,
                    TagBoxNote->"1"],
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37279$37390, 
                    FEPrivate`Not[DynamicChart`click$37279$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$37279$37390, {{{1., 0}, {
                    0, 1.}}, {-0.19562952014676113`, 
                    0.041582338163551946`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$37279$37390}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 4]& ,
                    TagBoxNote->"4"],
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37282$37390, 
                    FEPrivate`Not[DynamicChart`click$37282$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$37282$37390, {{{1., 0}, {
                    0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37282$37390}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 3]& ,
                    TagBoxNote->"3"],
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37285$37390, 
                    FEPrivate`Not[DynamicChart`click$37285$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$37285$37390, {{{1., 0}, {0, 1.}}, {
                    0.1827090915285202, 0.08134732861516007}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37285$37390}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 5]& ,
                    TagBoxNote->"5"],
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37288$37390, 
                    FEPrivate`Not[DynamicChart`click$37288$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$37288$37390, {{{1., 0}, {0, 1.}}, {
                    0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37288$37390}]], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}},
                    StatusArea[#, 2]& ,
                    TagBoxNote->"2"],
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                    Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37291$37390, 
                    FEPrivate`Not[DynamicChart`click$37291$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                   If[DynamicChart`click$37291$37390, {{{1., 0}, {
                    0, 1.}}, {-0.18270909152852022`, -0.08134732861516002}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$37291$37390}]]}, {}}, {}}},
              DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
            ContentSelectable->False,
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            LabelStyle->{
              GrayLevel[0], FontFamily -> "Arial"},
            PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
            PlotRangePadding->Scaled[0.02]], 
           GraphicsBox[{
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{1, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{4, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{3, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{5, 1}]}, 
             {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
              AbsoluteThickness[1.6], PointBox[{2, 1}]}},
            
            AspectRatio->NCache[
             Rational[1, 10]/GoldenRatio, 0.06180339887498948],
            Axes->{True, False},
            AxesLabel->{None},
            AxesOrigin->{Automatic, Automatic},
            FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
            ImagePadding->All,
            PlotRange->{{1., 5.}, {0, 1}},
            PlotRangePadding->{{
               Scaled[0.1], 
               Scaled[0.1]}, {0, 1}},
            Ticks->{Automatic, Automatic}]},
          {
           GraphicsBox[{{}, {{}, {}, 
              {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
               0.019444444444444445`], AbsoluteThickness[1.6], 
               LineBox[{{1., 1.}, {2., 4.}, {3., 3.}, {4., 5.}, {5., 
                2.}}]}}, {}},
            AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
            Axes->{True, True},
            AxesLabel->{None, None},
            AxesOrigin->{0, 0},
            DisplayFunction->Identity,
            Frame->{{False, False}, {False, False}},
            FrameLabel->{{None, None}, {None, None}},
            FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
            GridLines->{None, None},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            Method->{},
            PlotRange->{{0., 5.}, {0, 5.}},
            PlotRangeClipping->True,
            PlotRangePadding->{{
               Scaled[0.02], 
               Scaled[0.02]}, {
               Scaled[0.02], 
               Scaled[0.05]}},
            Ticks->{Automatic, Automatic}], 
           GraphicsBox[{
             {Opacity[0], PointBox[{0.4451141552511416, 0.}]}, {{}, 
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
               0.6649999999999999], Thickness[Small]}], 
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
                0.6649999999999999], Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.54337899543379, 0.}, {1.45662100456621, 
                    1.}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{13.08114422239484, 53.83341394725397}, {
                    37.418741862761024`, 64.89781741247583}}],
                   StatusArea[#, 1]& ,
                   TagBoxNote->"1"],
                  StyleBox["1", {}, StripOnInput -> False]],
                 Annotation[#, 
                  Style[1, {}], "Tooltip"]& ]}, 
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
                0.6649999999999999], Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.54337899543379, 0.}, {2.45662100456621, 
                    4.}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{57.157379571115584`, 
                    97.9096492959747}, {-43.51848478638338, 
                    64.89781741247583}}],
                   StatusArea[#, 4]& ,
                   TagBoxNote->"4"],
                  StyleBox["4", {}, StripOnInput -> False]],
                 Annotation[#, 
                  Style[4, {}], "Tooltip"]& ]}, 
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
                0.6649999999999999], Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.5433789954337898`, 0.}, {3.45662100456621,
                     3.}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{101.23361491983633`, 
                    141.98588464469546`}, {-16.539409236668575`, 
                    64.89781741247583}}],
                   StatusArea[#, 3]& ,
                   TagBoxNote->"3"],
                  StyleBox["3", {}, StripOnInput -> False]],
                 Annotation[#, 
                  Style[3, {}], "Tooltip"]& ]}, 
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
                0.6649999999999999], Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5433789954337898`, 0.}, {4.45662100456621,
                     5.}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{145.30985026855706`, 
                    186.0621199934162}, {-70.49756033609819, 
                    64.89781741247583}}],
                   StatusArea[#, 5]& ,
                   TagBoxNote->"5"],
                  StyleBox["5", {}, StripOnInput -> False]],
                 Annotation[#, 
                  Style[5, {}], "Tooltip"]& ]}, 
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
                0.6649999999999999], Thickness[Small]}], 
                TagBox[
                 TooltipBox[
                  TagBox[
                   DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.543378995433789, 0.}, {5.456621004566209, 
                    2.}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{189.38608561727779`, 
                    230.1383553421369}, {10.439666313046224`, 
                    64.89781741247583}}],
                   StatusArea[#, 2]& ,
                   TagBoxNote->"2"],
                  StyleBox["2", {}, StripOnInput -> False]],
                 Annotation[#, 
                  Style[2, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
             StyleBox[{
               {Thickness[Tiny], 
                LineBox[{{0.4451141552511416, 0.}, {5.55685114155251, 0.}}], 
                StyleBox[{}, "GraphicsLabel",
                 StripOnInput->False]}, 
               StyleBox[{
                 {Thickness[Tiny], 
                  LineBox[{{0.5433789954337899, 0.}, 
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    0.5433789954337899, 0.}]}], 
                  LineBox[{{5.456621004566209, 0.}, 
                    Offset[{-1.102182119232618*^-15, -6.}, {5.456621004566209,
                     0.}]}], {{}, {}, {}, {}, {}, {}, {}}}, 
                 StyleBox[{}, "GraphicsLabel",
                  StripOnInput->False]}, "GraphicsTicks",
                StripOnInput->False]}, "GraphicsAxes",
              StripOnInput->False,
              Antialiasing->False]},
            AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
            Axes->{False, True},
            AxesLabel->{None, None},
            AxesOrigin->{0.4451141552511416, 0.},
            CoordinatesToolOptions:>{"DisplayFunction" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& )},
            FrameLabel->{{None, None}, {None, None}},
            FrameTicks->{{Automatic, Automatic}, {{{1., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {
                4.999999999999999, 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}, {
                4.999999999999999, 
                 FormBox[
                  InterpretationBox[
                   StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                   Spacer[0]], TraditionalForm], {0.004, 0}}}}},
            GridLines->{None, None},
            GridLinesStyle->Directive[
              GrayLevel[0.5, 0.4]],
            PlotRange->{{All, All}, {All, All}},
            PlotRangePadding->{{
               Scaled[0.02], 
               Scaled[0.02]}, {
               Scaled[0.02], 
               Scaled[0.05]}},
            Ticks->{None, Automatic}]}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "f133e2e3-8117-4d70-b977-264a84087e4a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             GraphicsBox[{{}, {}, 
               
               DynamicModuleBox[{
                DynamicChart`click$37279$37390 = False, 
                 DynamicChart`click$37282$37390 = False, 
                 DynamicChart`click$37285$37390 = False, 
                 DynamicChart`click$37288$37390 = False, 
                 DynamicChart`click$37291$37390 = False}, {{
                  RGBColor[0.5, 0.5, 1.], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], {{{}, {{
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.722713633111154, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    
                    121.41421356237309`}, {-43.46093129764995, \
-1.5857864376269042`}}], StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37279$37390, 
                    FEPrivate`Not[DynamicChart`click$37279$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37279$37390, {{{1., 0}, {
                    0, 1.}}, {-0.19562952014676113`, 
                    0.041582338163551946`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$37279$37390}]]}, {
                    RGBColor[1., 0.544, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                    2.722713633111154}]}, 
                    ImageSizeCache -> {{30.88542250393722, 
                    169.4142135623731}, {-100.4142135623731, \
-1.5857864376268935`}}], StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37282$37390, 
                    FEPrivate`Not[DynamicChart`click$37282$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37282$37390, {{{1., 0}, {
                    0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37282$37390}]]}, {
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.2094395102393194, 
                    1.0471975511965979`}]}, 
                    ImageSizeCache -> {{118.5857864376269, 
                    217.4142135623731}, {-87.55265232567922, 
                    18.373735880877987`}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37285$37390, 
                    FEPrivate`Not[DynamicChart`click$37285$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37285$37390, {{{1., 0}, {0, 1.}}, {
                    0.1827090915285202, 0.08134732861516007}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37285$37390}]]}, {
                    RGBColor[0.6754608, 0.4848, 0.7224792], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.3038346126325155`, -0.2094395102393194}]}, 
                    ImageSizeCache -> {{54.349248227176474`, 
                    215.31638323281845`}, {-4.4142135623731065`, 
                    94.4142135623731}}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37288$37390, 
                    FEPrivate`Not[DynamicChart`click$37288$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37288$37390, {{{1., 0}, {0, 1.}}, {
                    0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37288$37390}]]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.3038346126325155`}]}, 
                    ImageSizeCache -> {{22.585786437626904`, 
                    121.41421356237309`}, {-4.414213562373092, 
                    69.75611680820292}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37291$37390, 
                    FEPrivate`Not[DynamicChart`click$37291$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37291$37390, {{{1., 0}, {
                    0, 1.}}, {-0.18270909152852022`, -0.08134732861516002}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$37291$37390}]]}}}, {}}, {}}, {{{
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
                    StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37279$37390, 
                    FEPrivate`Not[DynamicChart`click$37279$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37279$37390, {{{1., 0}, {
                    0, 1.}}, {-0.19562952014676113`, 
                    0.041582338163551946`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$37279$37390}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
                    StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37282$37390, 
                    FEPrivate`Not[DynamicChart`click$37282$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37282$37390, {{{1., 0}, {
                    0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37282$37390}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
                    StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37285$37390, 
                    FEPrivate`Not[DynamicChart`click$37285$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37285$37390, {{{1., 0}, {0, 1.}}, {
                    0.1827090915285202, 0.08134732861516007}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37285$37390}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 5]& , TagBoxNote -> "5"], 
                    StyleBox["5", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[5, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37288$37390, 
                    FEPrivate`Not[DynamicChart`click$37288$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37288$37390, {{{1., 0}, {0, 1.}}, {
                    0.06180339887498946, -0.19021130325903074`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$37288$37390}]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
                    StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$37291$37390, 
                    FEPrivate`Not[DynamicChart`click$37291$37390]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$37291$37390, {{{1., 0}, {
                    0, 1.}}, {-0.18270909152852022`, -0.08134732861516002}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$37291$37390}]]}, {}}, {}}}, 
                DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
               ContentSelectable -> False, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], LabelStyle -> {
                GrayLevel[0], FontFamily -> "Arial"}, 
              PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
              Scaled[0.02]], 
             GraphicsBox[{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[Medium], 
                AbsoluteThickness[1.6], 
                PointBox[{1, 1}]}, {
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[Medium], 
                AbsoluteThickness[1.6], 
                PointBox[{4, 1}]}, {
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[Medium], 
                AbsoluteThickness[1.6], 
                PointBox[{3, 1}]}, {
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[Medium], 
                AbsoluteThickness[1.6], 
                PointBox[{5, 1}]}, {
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[Medium], 
                AbsoluteThickness[1.6], 
                PointBox[{2, 1}]}}, AspectRatio -> 
              NCache[Rational[1, 10]/GoldenRatio, 0.06180339887498948], 
              Axes -> {True, False}, AxesLabel -> {None}, 
              AxesOrigin -> {Automatic, Automatic}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              ImagePadding -> All, PlotRange -> {{1., 5.}, {0, 1}}, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {0, 1}}, Ticks -> {Automatic, Automatic}]}, {
             GraphicsBox[{{}, {{}, {}, {
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[0.019444444444444445`], 
                 AbsoluteThickness[1.6], 
                 
                 LineBox[{{1., 1.}, {2., 4.}, {3., 3.}, {4., 5.}, {5., 
                  2.}}]}}, {}}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {True, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
              Frame -> {{False, False}, {False, False}}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], Method -> {}, 
              PlotRange -> {{0., 5.}, {0, 5.}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
             GraphicsBox[{{
                Opacity[0], 
                PointBox[{0.4451141552511416, 0.}]}, {{}, {
                 RGBColor[0.982864, 0.7431472, 0.3262672], 
                 EdgeForm[{
                   Opacity[0.6649999999999999], 
                   Thickness[Small]}], {
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.6649999999999999], 
                    Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.54337899543379, 0.}, {1.45662100456621, 
                    1.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{13.08114422239484, 
                    53.83341394725397}, {37.418741862761024`, 
                    64.89781741247583}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                    StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                    Style[1, {}], "Tooltip"]& ]}, {
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.6649999999999999], 
                    Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.54337899543379, 0.}, {2.45662100456621, 
                    4.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{57.157379571115584`, 
                    97.9096492959747}, {-43.51848478638338, 
                    64.89781741247583}}], StatusArea[#, 4]& , TagBoxNote -> 
                    "4"], 
                    StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                    Style[4, {}], "Tooltip"]& ]}, {
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.6649999999999999], 
                    Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.5433789954337898`, 0.}, {3.45662100456621,
                     3.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{101.23361491983633`, 
                    141.98588464469546`}, {-16.539409236668575`, 
                    64.89781741247583}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                    StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                    Style[3, {}], "Tooltip"]& ]}, {
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.6649999999999999], 
                    Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.5433789954337898`, 0.}, {4.45662100456621,
                     5.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{145.30985026855706`, 
                    186.0621199934162}, {-70.49756033609819, 
                    64.89781741247583}}], StatusArea[#, 5]& , TagBoxNote -> 
                    "5"], 
                    StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                    Style[5, {}], "Tooltip"]& ]}, {
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    Opacity[0.6649999999999999], 
                    Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{4.543378995433789, 0.}, {5.456621004566209, 
                    2.}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{189.38608561727779`, 
                    230.1383553421369}, {10.439666313046224`, 
                    64.89781741247583}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                    StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                    Style[2, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
               StyleBox[{{
                  Thickness[Tiny], 
                  LineBox[{{0.4451141552511416, 0.}, {5.55685114155251, 0.}}], 
                  StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
                 StyleBox[{{
                    Thickness[Tiny], 
                    LineBox[{{0.5433789954337899, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {
                    0.5433789954337899, 0.}]}], 
                    LineBox[{{5.456621004566209, 0.}, 
                    
                    Offset[{-1.102182119232618*^-15, -6.}, {5.456621004566209,
                     0.}]}], {{}, {}, {}, {}, {}, {}, {}}}, 
                   StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
                  "GraphicsTicks", StripOnInput -> False]}, "GraphicsAxes", 
                StripOnInput -> False, Antialiasing -> False]}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {False, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.4451141552511416, 0.}, 
              CoordinatesToolOptions :> {"DisplayFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                  Identity[
                   Part[#, 1]], 
                  Identity[
                   Part[#, 2]]}& )}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {{{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {
                  4.999999999999999, 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}, {{1., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}, {
                  4.999999999999999, 
                   FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {None, Automatic}]}}, AutoDelete -> 
           False, GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"36e46624-e0a9-4ccf-91b4-c7825d1dfc8a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of hue values ",
 Cell[BoxData[
  RowBox[{"x", "*", "y"}]], "InlineCode",ExpressionUUID->
  "c0208ca6-e3c4-473f-b2bc-a7ce09db68a3"],
 ", where ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"beec6a1b-26f0-4402-b114-bcdaa67c8cfd"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"7ea19e5a-32dc-4f7e-b0f6-62a359feb6fa"],
 " each run from 0 to 1 in steps of 0.05.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"57c1b51f-94eb-4c23-8bc6-f4d48df4e17a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJztmkFsVFUUhidxYxoXxEjCqtEdYUWUrcyyuKPoihDTGCyshIUL07hggaYr
YOGCGmNIMAES0pBgQiHGlKJQsGIFtSAE2goybaF0IYSl3HOcedzzv2/ew6Xx
JmTg576559333//857x57b1dW95/odForP7nT/q7j5Vmo3SsNDe8kcbVZjn+
h+CXp9K438EPjqSx0CxfZ1bwAzb/Iswv1jlk807L+o5fF3znYBp/Ch7X2Z7N
i3FdF3xPFkd7/YuwzizEu1AZ12S2rwW+PnsOEb9auY+Eb+yZObz7zSsSl+Pz
gr+7f+LR2m1LHXzvUv9Y7ydLsr5t7+C84MPp8v1XNN6XR/vmhj6svI8VW+5n
iWtNuvwVjdf5W8R7NE0b1Xg9Lo139unsvjmKd2/gg8bl8c4Jviptb8+S4HGd
6TRtRuM98fRb+8c03rp82JS2oU/jdVzjXbb7KPibojq8+4GsY/SduiP4pnR5
/zXBV21LhPqmMt49Kaqh7ySuYePfjdo68JLt+8MQV0vW32w8vw3xThX45+m5
H5N1PN5fBG/Z9ipPh7NzVOBxfeID6UP8vnfsfqdlnbcNV9362O6j1cG32r48
lHVet/Xv6X7Zubylemr3+0NlvOO2/lewj6pbX9g5VP5OpuM9sRDiWpb1W/YY
7kK8NwQfMJ6d7+Ae79fKBzsvv9bmQ119oHwRr7PHO3ZZvu+M4bcE93NyD+Yv
d3DK+61M9wr8o+xcPLOP2b49vw6QH/D5dwRfb+e48C9rs3/HeFXPyCcMZPF1
4QPoA+WLuv4h/v+0C7Jc5/7tpuAmZyN3Yf79gOt+kf67Pun5qesDXWdH4P5V
z1z/ldeUF1w3HoR4VWd9PAcfgj5QviD/4J+qy+VxFf/vvuWSXDdv+O+CrzP+
6znx+Ysd3H2d6uZx81Wq/3/ZwVL/TzpQ1w9QXTBr+VHrmKNmWHQfByyfqc6t
yfID84H0gfKF+If2KPWTVF/wvjyx/Z6U6x4bfk3w05mPjPNbgrufLvzTPvPN
ixLXZks4ui+uszd1vj2Hn3QfR549L134YHFMQN7XvPtquu1e1VniQ9QHyhfk
H8hPUn0R682q+/d8fQHy+Izgb4HPp7wf9f8D8P+kA+QHqC7AvGDn7bPK/TgA
PoH4QPpA+SL6B/KTVF9QvVmeR/g+ncffA7/1Pk/Y87kN8zXv77D7X4TvKXTg
xcyvFvGO237reTD2DWle8L7Mb4IfsvUu/Gs+kD5QviD/QH4y1hdtPNab1H8o
70dV9evOgT7r/ZDfo/6ef6r+Rx0gP0B1AflDH/X5QPpQO1+Af/BP9ZNUX1C9
SboR+1H5utXP3fszZ+V66ud430bjpj4P+f/Y/2njTesTFj6J+kJmM3rr84H0
gfIF+Ye6fpLqC6o3qf9A/SjqT+4sPfcan9fv38r1VNdT3qd6n3SA/ECsC/Lv
r+YD6QPlC/IP5CepviDdqNt/oH4U8YT61bmeVNVxZzRvQX3ndZz2Faju+9HO
n/oeqgc/NX7X50PUB8oX5B/IT1J9QfUm9R+IJ9SfRD2p+f4izzs8z/t/p+A8
qs8n/ScdID9AdQHxgfSB8kV5H0n9JNUXVG8STyi/kJ5Qv5ryDr3P6t7X4ufu
PD0J+qx+j/p75AP9U/sAxAfSB8oX5B/8U/0k1RfEk9h/ID3xofU55R16f0H8
ofebPlR/yv9d4OOWN0chv2veJx0gP0B8IH2gfEH+gfwk8YTqTdIT6kdR3iH+
RH9C77PIt9D77u6/f6jS+SMyn/Sf/D/xgfSB8gX5B+IJ1RekJ9R/oLxD/UnK
R6Q/xKv4fjO/L81f8fcP+f0q3xqlo33ev5T5pAPEB9IHyhfEE/KTpCfEH9IZ
6kcRr6hfTbpEfCO9ovfdpGP0e5ju/ZM42s93Hzx35QPpA/GE/APxh+oL4hXp
D/GN+pPEQ3p/QfwkfSPe0u8fiM/0+6ju/iqO//H/Kv4379M1cw==
         "], {{0, 0}, {
         21, 21}}, {0, 1}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "29c53b2f-be7c-45b9-ac5d-6e263e95fd49"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJztmkFsVFUUhidxYxoXxEjCqtEdYUWUrcyyuKPoihDTGCyshIUL07hggaYr
YOGCGmNIMAES0pBgQiHGlKJQsGIFtSAE2goybaF0IYSl3HOcedzzv2/ew6Xx
JmTg576559333//857x57b1dW95/odForP7nT/q7j5Vmo3SsNDe8kcbVZjn+
h+CXp9K438EPjqSx0CxfZ1bwAzb/Iswv1jlk807L+o5fF3znYBp/Ch7X2Z7N
i3FdF3xPFkd7/YuwzizEu1AZ12S2rwW+PnsOEb9auY+Eb+yZObz7zSsSl+Pz
gr+7f+LR2m1LHXzvUv9Y7ydLsr5t7+C84MPp8v1XNN6XR/vmhj6svI8VW+5n
iWtNuvwVjdf5W8R7NE0b1Xg9Lo139unsvjmKd2/gg8bl8c4Jviptb8+S4HGd
6TRtRuM98fRb+8c03rp82JS2oU/jdVzjXbb7KPibojq8+4GsY/SduiP4pnR5
/zXBV21LhPqmMt49Kaqh7ySuYePfjdo68JLt+8MQV0vW32w8vw3xThX45+m5
H5N1PN5fBG/Z9ipPh7NzVOBxfeID6UP8vnfsfqdlnbcNV9362O6j1cG32r48
lHVet/Xv6X7Zubylemr3+0NlvOO2/lewj6pbX9g5VP5OpuM9sRDiWpb1W/YY
7kK8NwQfMJ6d7+Ae79fKBzsvv9bmQ119oHwRr7PHO3ZZvu+M4bcE93NyD+Yv
d3DK+61M9wr8o+xcPLOP2b49vw6QH/D5dwRfb+e48C9rs3/HeFXPyCcMZPF1
4QPoA+WLuv4h/v+0C7Jc5/7tpuAmZyN3Yf79gOt+kf67Pun5qesDXWdH4P5V
z1z/ldeUF1w3HoR4VWd9PAcfgj5QviD/4J+qy+VxFf/vvuWSXDdv+O+CrzP+
6znx+Ysd3H2d6uZx81Wq/3/ZwVL/TzpQ1w9QXTBr+VHrmKNmWHQfByyfqc6t
yfID84H0gfKF+If2KPWTVF/wvjyx/Z6U6x4bfk3w05mPjPNbgrufLvzTPvPN
ixLXZks4ui+uszd1vj2Hn3QfR549L134YHFMQN7XvPtquu1e1VniQ9QHyhfk
H8hPUn0R682q+/d8fQHy+Izgb4HPp7wf9f8D8P+kA+QHqC7AvGDn7bPK/TgA
PoH4QPpA+SL6B/KTVF9QvVmeR/g+ncffA7/1Pk/Y87kN8zXv77D7X4TvKXTg
xcyvFvGO237reTD2DWle8L7Mb4IfsvUu/Gs+kD5QviD/QH4y1hdtPNab1H8o
70dV9evOgT7r/ZDfo/6ef6r+Rx0gP0B1AflDH/X5QPpQO1+Af/BP9ZNUX1C9
SboR+1H5utXP3fszZ+V66ud430bjpj4P+f/Y/2njTesTFj6J+kJmM3rr84H0
gfIF+Ye6fpLqC6o3qf9A/SjqT+4sPfcan9fv38r1VNdT3qd6n3SA/ECsC/Lv
r+YD6QPlC/IP5CepviDdqNt/oH4U8YT61bmeVNVxZzRvQX3ndZz2Faju+9HO
n/oeqgc/NX7X50PUB8oX5B/IT1J9QfUm9R+IJ9SfRD2p+f4izzs8z/t/p+A8
qs8n/ScdID9AdQHxgfSB8kV5H0n9JNUXVG8STyi/kJ5Qv5ryDr3P6t7X4ufu
PD0J+qx+j/p75AP9U/sAxAfSB8oX5B/8U/0k1RfEk9h/ID3xofU55R16f0H8
ofebPlR/yv9d4OOWN0chv2veJx0gP0B8IH2gfEH+gfwk8YTqTdIT6kdR3iH+
RH9C77PIt9D77u6/f6jS+SMyn/Sf/D/xgfSB8gX5B+IJ1RekJ9R/oLxD/UnK
R6Q/xKv4fjO/L81f8fcP+f0q3xqlo33ev5T5pAPEB9IHyhfEE/KTpCfEH9IZ
6kcRr6hfTbpEfCO9ovfdpGP0e5ju/ZM42s93Hzx35QPpA/GE/APxh+oL4hXp
D/GN+pPEQ3p/QfwkfSPe0u8fiM/0+6ju/iqO//H/Kv4379M1cw==
           "], {{0, 0}, {
           21, 21}}, {0, 1}], Frame -> Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9c48e439-9232-40bd-a84b-b63e878d2bc5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of hue values ",
 Cell[BoxData[
  RowBox[{"x", "/", "y"}]], "InlineCode",ExpressionUUID->
  "734171bb-bcbd-433e-be5e-72a2e301fa33"],
 ", where ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"513b9bbc-e0af-4bbd-8757-b728ca2dd161"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"8acd9946-8243-46f7-86a3-7a8288f11076"],
 " each run from 1 to 50 in steps of 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"38ffb8bf-bf20-4cea-8a60-b0add01c2c40"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJytnQ2QXlV5x3emRakfMwtG2daoS4s1FIcubZRUgrsoYnRiZ6NYFgdhpbFG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         "], {{0, 0}, {50, 50}}, {0, 1}],
        
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "9eae82e4-096b-4b2c-a0d0-b740d131df11"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJytnQ2QXlV5x3emRakfMwtG2daoS4s1FIcubZRUgrsoYnRiZ6NYFgdhpbFG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           "], {{0, 0}, {50, 50}}, {0, 
           1}], Frame -> Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"044f980b-010a-4bad-bbc8-bdc4618d7858"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an array plot of the lengths of Roman numeral strings in a \
multiplication table up to 100\[Times]100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"460445e8-93a8-4d70-8254-1a3112b3ded7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJy9mtuW60ZyRNVNEsStUFUAeN79S/6EWX73/7957wB5jmYke83YXpLUYKFw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         "], {{0, 0}, {100, 100}}, {0, 23}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "a5b1b85d-44a5-4ca6-8051-02cfbcbcace8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJy9mtuW60ZyRNVNEsStUFUAeN79S/6EWX73/7957wB5jmYke83YXpLUYKFw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           "], {{0, 0}, {100, 100}}, {0, 
           23}], Frame -> Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e7edb75-691c-4e8c-ba53-d28ed8f6e508"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 20\[Times]20 addition table.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+13.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f9a22316-4105-433b-b8a1-1c8fe9c16df9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
           "14", "15", "16", "17", "18", "19", "20", "21"},
          {"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", 
           "15", "16", "17", "18", "19", "20", "21", "22"},
          {"4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", 
           "16", "17", "18", "19", "20", "21", "22", "23"},
          {"5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", 
           "17", "18", "19", "20", "21", "22", "23", "24"},
          {"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17",
            "18", "19", "20", "21", "22", "23", "24", "25"},
          {"7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", 
           "18", "19", "20", "21", "22", "23", "24", "25", "26"},
          {"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", 
           "19", "20", "21", "22", "23", "24", "25", "26", "27"},
          {"9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
           "20", "21", "22", "23", "24", "25", "26", "27", "28"},
          {"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
           "21", "22", "23", "24", "25", "26", "27", "28", "29"},
          {"11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", 
           "22", "23", "24", "25", "26", "27", "28", "29", "30"},
          {"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", 
           "23", "24", "25", "26", "27", "28", "29", "30", "31"},
          {"13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", 
           "24", "25", "26", "27", "28", "29", "30", "31", "32"},
          {"14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
           "25", "26", "27", "28", "29", "30", "31", "32", "33"},
          {"15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", 
           "26", "27", "28", "29", "30", "31", "32", "33", "34"},
          {"16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", 
           "27", "28", "29", "30", "31", "32", "33", "34", "35"},
          {"17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", 
           "28", "29", "30", "31", "32", "33", "34", "35", "36"},
          {"18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", 
           "29", "30", "31", "32", "33", "34", "35", "36", "37"},
          {"19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", 
           "30", "31", "32", "33", "34", "35", "36", "37", "38"},
          {"20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
           "31", "32", "33", "34", "35", "36", "37", "38", "39"},
          {"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
           "32", "33", "34", "35", "36", "37", "38", "39", "40"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "292c34f5-d8ed-4768-ae45-134dc3a5c93a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
             "14", "15", "16", "17", "18", "19", "20", "21"}, {
            "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", 
             "15", "16", "17", "18", "19", "20", "21", "22"}, {
            "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", 
             "16", "17", "18", "19", "20", "21", "22", "23"}, {
            "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16",
              "17", "18", "19", "20", "21", "22", "23", "24"}, {
            "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", 
             "17", "18", "19", "20", "21", "22", "23", "24", "25"}, {
            "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", 
             "18", "19", "20", "21", "22", "23", "24", "25", "26"}, {
            "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", 
             "19", "20", "21", "22", "23", "24", "25", "26", "27"}, {
            "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
             "20", "21", "22", "23", "24", "25", "26", "27", "28"}, {
            "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
             "21", "22", "23", "24", "25", "26", "27", "28", "29"}, {
            "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", 
             "22", "23", "24", "25", "26", "27", "28", "29", "30"}, {
            "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", 
             "23", "24", "25", "26", "27", "28", "29", "30", "31"}, {
            "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", 
             "24", "25", "26", "27", "28", "29", "30", "31", "32"}, {
            "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", 
             "25", "26", "27", "28", "29", "30", "31", "32", "33"}, {
            "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", 
             "26", "27", "28", "29", "30", "31", "32", "33", "34"}, {
            "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", 
             "27", "28", "29", "30", "31", "32", "33", "34", "35"}, {
            "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", 
             "28", "29", "30", "31", "32", "33", "34", "35", "36"}, {
            "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", 
             "29", "30", "31", "32", "33", "34", "35", "36", "37"}, {
            "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", 
             "30", "31", "32", "33", "34", "35", "36", "37", "38"}, {
            "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
             "31", "32", "33", "34", "35", "36", "37", "38", "39"}, {
            "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
             "32", "33", "34", "35", "36", "37", "38", "39", "40"}}, 
           AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4816bc58-6d8c-42f4-b2f8-e27ab2a3c66d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a 10\[Times]10 grid of randomly colored random integers between 0 and \
10 that have random size up to 32.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+13.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a0765ca3-a4d2-4f90-a569-3642d9a93168"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           StyleBox["6",
            StripOnInput->False,
            FontSize->28,
            
            FontColor->RGBColor[
             0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
            $CellContext`LineColor -> 
            RGBColor[
             0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2527981501804366, 0.051346295724271185`, 0.7047358496269513]], 
           
           StyleBox["9",
            StripOnInput->False,
            FontSize->26,
            
            FontColor->RGBColor[
             0.8186859567431535, 0.6796469190736123, 0.9539039716800006],
            $CellContext`LineColor -> 
            RGBColor[
             0.8186859567431535, 0.6796469190736123, 0.9539039716800006],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8186859567431535, 0.6796469190736123, 0.9539039716800006],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8186859567431535, 0.6796469190736123, 0.9539039716800006],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8186859567431535, 0.6796469190736123, 0.9539039716800006]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->30,
            
            FontColor->RGBColor[
             0.503258301075572, 0.05842253573276168, 0.19630901791408784`],
            $CellContext`LineColor -> 
            RGBColor[
             0.503258301075572, 0.05842253573276168, 0.19630901791408784`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.503258301075572, 0.05842253573276168, 0.19630901791408784`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.503258301075572, 0.05842253573276168, 0.19630901791408784`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.503258301075572, 0.05842253573276168, 0.19630901791408784`]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->15,
            
            FontColor->RGBColor[
             0.921497756122005, 0.6246948249955864, 0.7675015152672202],
            $CellContext`LineColor -> 
            RGBColor[
             0.921497756122005, 0.6246948249955864, 0.7675015152672202],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.921497756122005, 0.6246948249955864, 0.7675015152672202],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.921497756122005, 0.6246948249955864, 0.7675015152672202],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.921497756122005, 0.6246948249955864, 0.7675015152672202]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->4,
            
            FontColor->RGBColor[
             0.49987015615055386`, 0.3301992135098233, 0.4198427570509966],
            $CellContext`LineColor -> 
            RGBColor[
             0.49987015615055386`, 0.3301992135098233, 0.4198427570509966],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.49987015615055386`, 0.3301992135098233, 0.4198427570509966],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.49987015615055386`, 0.3301992135098233, 0.4198427570509966],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.49987015615055386`, 0.3301992135098233, 0.4198427570509966]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->28,
            
            FontColor->RGBColor[
             0.6251236205557267, 0.8954245296169396, 0.71010711398662],
            $CellContext`LineColor -> 
            RGBColor[0.6251236205557267, 0.8954245296169396, 0.71010711398662],
            $CellContext`FrontFaceColor -> 
            RGBColor[0.6251236205557267, 0.8954245296169396, 0.71010711398662],
            $CellContext`GraphicsColor -> 
            RGBColor[0.6251236205557267, 0.8954245296169396, 0.71010711398662],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6251236205557267, 0.8954245296169396, 0.71010711398662]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->27,
            
            FontColor->RGBColor[
             0.2930424341650133, 0.9903716671783811, 0.1404102351951737],
            $CellContext`LineColor -> 
            RGBColor[
             0.2930424341650133, 0.9903716671783811, 0.1404102351951737],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2930424341650133, 0.9903716671783811, 0.1404102351951737],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2930424341650133, 0.9903716671783811, 0.1404102351951737],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2930424341650133, 0.9903716671783811, 0.1404102351951737]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->2,
            
            FontColor->RGBColor[
             0.30673617645187057`, 0.054534109139190434`, 
              0.5286535195398157],
            $CellContext`LineColor -> 
            RGBColor[
             0.30673617645187057`, 0.054534109139190434`, 
              0.5286535195398157],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.30673617645187057`, 0.054534109139190434`, 
              0.5286535195398157],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.30673617645187057`, 0.054534109139190434`, 
              0.5286535195398157],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.30673617645187057`, 0.054534109139190434`, 0.5286535195398157]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.6619902075347164, 0.7746635945806386, 0.0654616924884368],
            $CellContext`LineColor -> 
            RGBColor[
             0.6619902075347164, 0.7746635945806386, 0.0654616924884368],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6619902075347164, 0.7746635945806386, 0.0654616924884368],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6619902075347164, 0.7746635945806386, 0.0654616924884368],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6619902075347164, 0.7746635945806386, 0.0654616924884368]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->25,
            
            FontColor->RGBColor[
             0.7023010850652094, 0.2523846384906363, 0.5960873768481041],
            $CellContext`LineColor -> 
            RGBColor[
             0.7023010850652094, 0.2523846384906363, 0.5960873768481041],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7023010850652094, 0.2523846384906363, 0.5960873768481041],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7023010850652094, 0.2523846384906363, 0.5960873768481041],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7023010850652094, 0.2523846384906363, 0.5960873768481041]]},
          {
           StyleBox["8",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.9898351034570245, 0.17143815351419422`, 0.44706629950594823`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9898351034570245, 0.17143815351419422`, 0.44706629950594823`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9898351034570245, 0.17143815351419422`, 0.44706629950594823`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9898351034570245, 0.17143815351419422`, 0.44706629950594823`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9898351034570245, 0.17143815351419422`, 0.44706629950594823`]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->15,
            
            FontColor->RGBColor[
             0.12059600993776809`, 0.9418663036107549, 0.16795600567108337`],
            $CellContext`LineColor -> 
            RGBColor[
             0.12059600993776809`, 0.9418663036107549, 0.16795600567108337`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.12059600993776809`, 0.9418663036107549, 0.16795600567108337`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.12059600993776809`, 0.9418663036107549, 0.16795600567108337`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.12059600993776809`, 0.9418663036107549, 0.16795600567108337`]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->1,
            
            FontColor->RGBColor[
             0.5061760875552237, 0.8966155738094657, 0.8804817857842184],
            $CellContext`LineColor -> 
            RGBColor[
             0.5061760875552237, 0.8966155738094657, 0.8804817857842184],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5061760875552237, 0.8966155738094657, 0.8804817857842184],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5061760875552237, 0.8966155738094657, 0.8804817857842184],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5061760875552237, 0.8966155738094657, 0.8804817857842184]], 
           StyleBox["8",
            StripOnInput->False,
            FontSize->30,
            
            FontColor->RGBColor[
             0.8722825504573608, 0.8372634776488366, 0.8427061542213237],
            $CellContext`LineColor -> 
            RGBColor[
             0.8722825504573608, 0.8372634776488366, 0.8427061542213237],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8722825504573608, 0.8372634776488366, 0.8427061542213237],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8722825504573608, 0.8372634776488366, 0.8427061542213237],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8722825504573608, 0.8372634776488366, 0.8427061542213237]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->22,
            
            FontColor->RGBColor[
             0.8619772582503522, 0.8840843485326337, 0.8221800988659629],
            $CellContext`LineColor -> 
            RGBColor[
             0.8619772582503522, 0.8840843485326337, 0.8221800988659629],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8619772582503522, 0.8840843485326337, 0.8221800988659629],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8619772582503522, 0.8840843485326337, 0.8221800988659629],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8619772582503522, 0.8840843485326337, 0.8221800988659629]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->10,
            
            FontColor->RGBColor[
             0.23114183487850948`, 0.2681356316356318, 0.956696004968195],
            $CellContext`LineColor -> 
            RGBColor[
             0.23114183487850948`, 0.2681356316356318, 0.956696004968195],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.23114183487850948`, 0.2681356316356318, 0.956696004968195],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.23114183487850948`, 0.2681356316356318, 0.956696004968195],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.23114183487850948`, 0.2681356316356318, 0.956696004968195]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.625353969818822, 0.9393856601561026, 0.06593656070006904],
            $CellContext`LineColor -> 
            RGBColor[
             0.625353969818822, 0.9393856601561026, 0.06593656070006904],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.625353969818822, 0.9393856601561026, 0.06593656070006904],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.625353969818822, 0.9393856601561026, 0.06593656070006904],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.625353969818822, 0.9393856601561026, 0.06593656070006904]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->30,
            
            FontColor->RGBColor[
             0.029318625400041487`, 0.3266361925413823, 0.054019367358514314`],
            $CellContext`LineColor -> 
            RGBColor[
             0.029318625400041487`, 0.3266361925413823, 0.054019367358514314`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.029318625400041487`, 0.3266361925413823, 0.054019367358514314`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.029318625400041487`, 0.3266361925413823, 0.054019367358514314`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.029318625400041487`, 0.3266361925413823, 
              0.054019367358514314`]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->20,
            
            FontColor->RGBColor[
             0.4562550776198575, 0.5810992708524032, 0.2162956578741433],
            $CellContext`LineColor -> 
            RGBColor[
             0.4562550776198575, 0.5810992708524032, 0.2162956578741433],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4562550776198575, 0.5810992708524032, 0.2162956578741433],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4562550776198575, 0.5810992708524032, 0.2162956578741433],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4562550776198575, 0.5810992708524032, 0.2162956578741433]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->12,
            
            FontColor->RGBColor[
             0.551456609354444, 0.9558169470426987, 0.2934195872998968],
            $CellContext`LineColor -> 
            RGBColor[
             0.551456609354444, 0.9558169470426987, 0.2934195872998968],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.551456609354444, 0.9558169470426987, 0.2934195872998968],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.551456609354444, 0.9558169470426987, 0.2934195872998968],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.551456609354444, 0.9558169470426987, 0.2934195872998968]]},
          {
           StyleBox["0",
            StripOnInput->False,
            FontSize->4,
            
            FontColor->RGBColor[
             0.7008785041869177, 0.3240956864067934, 0.8790969634999826],
            $CellContext`LineColor -> 
            RGBColor[
             0.7008785041869177, 0.3240956864067934, 0.8790969634999826],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7008785041869177, 0.3240956864067934, 0.8790969634999826],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7008785041869177, 0.3240956864067934, 0.8790969634999826],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7008785041869177, 0.3240956864067934, 0.8790969634999826]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.23181891963698686`, 0.4819483907158708, 0.48174197039455113`],
            $CellContext`LineColor -> 
            RGBColor[
             0.23181891963698686`, 0.4819483907158708, 0.48174197039455113`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.23181891963698686`, 0.4819483907158708, 0.48174197039455113`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.23181891963698686`, 0.4819483907158708, 0.48174197039455113`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.23181891963698686`, 0.4819483907158708, 0.48174197039455113`]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.3878162591695542, 0.8809154651953834, 0.34660843359808546`],
            $CellContext`LineColor -> 
            RGBColor[
             0.3878162591695542, 0.8809154651953834, 0.34660843359808546`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3878162591695542, 0.8809154651953834, 0.34660843359808546`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3878162591695542, 0.8809154651953834, 0.34660843359808546`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3878162591695542, 0.8809154651953834, 0.34660843359808546`]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->24,
            
            FontColor->RGBColor[
             0.8269293855186073, 0.7434684446767155, 0.7864301187165403],
            $CellContext`LineColor -> 
            RGBColor[
             0.8269293855186073, 0.7434684446767155, 0.7864301187165403],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8269293855186073, 0.7434684446767155, 0.7864301187165403],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8269293855186073, 0.7434684446767155, 0.7864301187165403],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8269293855186073, 0.7434684446767155, 0.7864301187165403]], 
           StyleBox["8",
            StripOnInput->False,
            FontSize->0,
            
            FontColor->RGBColor[
             0.2633799846792557, 0.5036219177969019, 0.8099519487838835],
            $CellContext`LineColor -> 
            RGBColor[
             0.2633799846792557, 0.5036219177969019, 0.8099519487838835],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2633799846792557, 0.5036219177969019, 0.8099519487838835],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2633799846792557, 0.5036219177969019, 0.8099519487838835],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2633799846792557, 0.5036219177969019, 0.8099519487838835]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->6,
            
            FontColor->RGBColor[
             0.835403554254116, 0.34997784933141096`, 0.32982521775949647`],
            $CellContext`LineColor -> 
            RGBColor[
             0.835403554254116, 0.34997784933141096`, 0.32982521775949647`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.835403554254116, 0.34997784933141096`, 0.32982521775949647`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.835403554254116, 0.34997784933141096`, 0.32982521775949647`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.835403554254116, 0.34997784933141096`, 0.32982521775949647`]], 
           
           StyleBox["10",
            StripOnInput->False,
            FontSize->7,
            
            FontColor->RGBColor[
             0.25824128613619846`, 0.16735337824560004`, 0.8414842453712148],
            $CellContext`LineColor -> 
            RGBColor[
             0.25824128613619846`, 0.16735337824560004`, 0.8414842453712148],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.25824128613619846`, 0.16735337824560004`, 0.8414842453712148],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.25824128613619846`, 0.16735337824560004`, 0.8414842453712148],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.25824128613619846`, 0.16735337824560004`, 0.8414842453712148]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->22,
            
            FontColor->RGBColor[
             0.9644221797586698, 0.7228715245597535, 0.027517708444436018`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9644221797586698, 0.7228715245597535, 0.027517708444436018`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9644221797586698, 0.7228715245597535, 0.027517708444436018`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9644221797586698, 0.7228715245597535, 0.027517708444436018`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9644221797586698, 0.7228715245597535, 0.027517708444436018`]], 
           
           StyleBox["10",
            StripOnInput->False,
            FontSize->4,
            
            FontColor->RGBColor[
             0.2953201896614557, 0.030921071629127272`, 0.8543971907972887],
            $CellContext`LineColor -> 
            RGBColor[
             0.2953201896614557, 0.030921071629127272`, 0.8543971907972887],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2953201896614557, 0.030921071629127272`, 0.8543971907972887],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2953201896614557, 0.030921071629127272`, 0.8543971907972887],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2953201896614557, 0.030921071629127272`, 0.8543971907972887]], 
           
           StyleBox["7",
            StripOnInput->False,
            FontSize->7,
            
            FontColor->RGBColor[
             0.8663737777925791, 0.2358741858360318, 0.40022765746453115`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8663737777925791, 0.2358741858360318, 0.40022765746453115`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8663737777925791, 0.2358741858360318, 0.40022765746453115`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8663737777925791, 0.2358741858360318, 0.40022765746453115`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8663737777925791, 0.2358741858360318, 0.40022765746453115`]]},
          {
           StyleBox["4",
            StripOnInput->False,
            FontSize->25,
            
            FontColor->RGBColor[
             0.9615828397701947, 0.3719985929377574, 0.26265233446167513`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9615828397701947, 0.3719985929377574, 0.26265233446167513`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9615828397701947, 0.3719985929377574, 0.26265233446167513`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9615828397701947, 0.3719985929377574, 0.26265233446167513`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9615828397701947, 0.3719985929377574, 0.26265233446167513`]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.13037935965511305`, 0.4291257934229966, 0.3684048088208993],
            $CellContext`LineColor -> 
            RGBColor[
             0.13037935965511305`, 0.4291257934229966, 0.3684048088208993],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.13037935965511305`, 0.4291257934229966, 0.3684048088208993],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.13037935965511305`, 0.4291257934229966, 0.3684048088208993],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.13037935965511305`, 0.4291257934229966, 0.3684048088208993]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->16,
            
            FontColor->RGBColor[
             0.18627831702840614`, 0.834314797539724, 0.852540674354334],
            $CellContext`LineColor -> 
            RGBColor[
             0.18627831702840614`, 0.834314797539724, 0.852540674354334],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.18627831702840614`, 0.834314797539724, 0.852540674354334],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.18627831702840614`, 0.834314797539724, 0.852540674354334],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.18627831702840614`, 0.834314797539724, 0.852540674354334]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->11,
            
            FontColor->RGBColor[
             0.6783423507719846, 0.4619588492232005, 0.4475244280421542],
            $CellContext`LineColor -> 
            RGBColor[
             0.6783423507719846, 0.4619588492232005, 0.4475244280421542],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6783423507719846, 0.4619588492232005, 0.4475244280421542],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6783423507719846, 0.4619588492232005, 0.4475244280421542],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6783423507719846, 0.4619588492232005, 0.4475244280421542]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.635547588708071, 0.8613085335586967, 0.7687380219428834],
            $CellContext`LineColor -> 
            RGBColor[
             0.635547588708071, 0.8613085335586967, 0.7687380219428834],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.635547588708071, 0.8613085335586967, 0.7687380219428834],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.635547588708071, 0.8613085335586967, 0.7687380219428834],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.635547588708071, 0.8613085335586967, 0.7687380219428834]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->21,
            
            FontColor->RGBColor[
             0.28745761194158104`, 0.43673788556139237`, 0.35251959748136974`],
            $CellContext`LineColor -> 
            RGBColor[
             0.28745761194158104`, 0.43673788556139237`, 0.35251959748136974`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.28745761194158104`, 0.43673788556139237`, 0.35251959748136974`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.28745761194158104`, 0.43673788556139237`, 0.35251959748136974`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.28745761194158104`, 0.43673788556139237`, 
              0.35251959748136974`]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->23,
            
            FontColor->RGBColor[
             0.7248519648139398, 0.3292011600212341, 0.2909179799750239],
            $CellContext`LineColor -> 
            RGBColor[
             0.7248519648139398, 0.3292011600212341, 0.2909179799750239],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7248519648139398, 0.3292011600212341, 0.2909179799750239],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7248519648139398, 0.3292011600212341, 0.2909179799750239],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7248519648139398, 0.3292011600212341, 0.2909179799750239]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->29,
            
            FontColor->RGBColor[
             0.7675830715768099, 0.9178050691463946, 0.3822869939964453],
            $CellContext`LineColor -> 
            RGBColor[
             0.7675830715768099, 0.9178050691463946, 0.3822869939964453],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7675830715768099, 0.9178050691463946, 0.3822869939964453],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7675830715768099, 0.9178050691463946, 0.3822869939964453],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7675830715768099, 0.9178050691463946, 0.3822869939964453]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->18,
            
            FontColor->RGBColor[
             0.039223076693792436`, 0.5615704656502034, 0.7717329551040819],
            $CellContext`LineColor -> 
            RGBColor[
             0.039223076693792436`, 0.5615704656502034, 0.7717329551040819],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.039223076693792436`, 0.5615704656502034, 0.7717329551040819],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.039223076693792436`, 0.5615704656502034, 0.7717329551040819],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.039223076693792436`, 0.5615704656502034, 0.7717329551040819]], 
           
           StyleBox["10",
            StripOnInput->False,
            FontSize->21,
            
            FontColor->RGBColor[
             0.8060503306560909, 0.5148988659845668, 0.15961186687379247`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8060503306560909, 0.5148988659845668, 0.15961186687379247`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8060503306560909, 0.5148988659845668, 0.15961186687379247`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8060503306560909, 0.5148988659845668, 0.15961186687379247`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8060503306560909, 0.5148988659845668, 0.15961186687379247`]]},
          {
           StyleBox["0",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.005513133972373518, 0.5857833630680225, 0.8791589135765423],
            $CellContext`LineColor -> 
            RGBColor[
             0.005513133972373518, 0.5857833630680225, 0.8791589135765423],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.005513133972373518, 0.5857833630680225, 0.8791589135765423],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.005513133972373518, 0.5857833630680225, 0.8791589135765423],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.005513133972373518, 0.5857833630680225, 0.8791589135765423]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->21,
            
            FontColor->RGBColor[
             0.8667655134377861, 0.6119154327560528, 0.1429278070352027],
            $CellContext`LineColor -> 
            RGBColor[
             0.8667655134377861, 0.6119154327560528, 0.1429278070352027],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8667655134377861, 0.6119154327560528, 0.1429278070352027],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8667655134377861, 0.6119154327560528, 0.1429278070352027],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8667655134377861, 0.6119154327560528, 0.1429278070352027]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->28,
            
            FontColor->RGBColor[
             0.2916287498608525, 0.8153446155113955, 0.059898649081116195`],
            $CellContext`LineColor -> 
            RGBColor[
             0.2916287498608525, 0.8153446155113955, 0.059898649081116195`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.2916287498608525, 0.8153446155113955, 0.059898649081116195`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.2916287498608525, 0.8153446155113955, 0.059898649081116195`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.2916287498608525, 0.8153446155113955, 0.059898649081116195`]], 
           
           StyleBox["4",
            StripOnInput->False,
            FontSize->1,
            
            FontColor->RGBColor[
             0.06364791069842868, 0.5637390319940896, 0.5202122124210933],
            $CellContext`LineColor -> 
            RGBColor[
             0.06364791069842868, 0.5637390319940896, 0.5202122124210933],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.06364791069842868, 0.5637390319940896, 0.5202122124210933],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.06364791069842868, 0.5637390319940896, 0.5202122124210933],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.06364791069842868, 0.5637390319940896, 0.5202122124210933]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->11,
            
            FontColor->RGBColor[
             0.6513106813257332, 0.8592857959489539, 0.36564913729953274`],
            $CellContext`LineColor -> 
            RGBColor[
             0.6513106813257332, 0.8592857959489539, 0.36564913729953274`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6513106813257332, 0.8592857959489539, 0.36564913729953274`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6513106813257332, 0.8592857959489539, 0.36564913729953274`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6513106813257332, 0.8592857959489539, 0.36564913729953274`]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.8442344684249734, 0.4119498457925306, 0.20549962493398333`],
            $CellContext`LineColor -> 
            RGBColor[
             0.8442344684249734, 0.4119498457925306, 0.20549962493398333`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8442344684249734, 0.4119498457925306, 0.20549962493398333`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8442344684249734, 0.4119498457925306, 0.20549962493398333`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8442344684249734, 0.4119498457925306, 0.20549962493398333`]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.6444121546795252, 0.5856848194428992, 0.5392457942888813],
            $CellContext`LineColor -> 
            RGBColor[
             0.6444121546795252, 0.5856848194428992, 0.5392457942888813],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6444121546795252, 0.5856848194428992, 0.5392457942888813],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6444121546795252, 0.5856848194428992, 0.5392457942888813],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6444121546795252, 0.5856848194428992, 0.5392457942888813]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->16,
            
            FontColor->RGBColor[
             0.7019201369358166, 0.8150904193584265, 0.17801843830517283`],
            $CellContext`LineColor -> 
            RGBColor[
             0.7019201369358166, 0.8150904193584265, 0.17801843830517283`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7019201369358166, 0.8150904193584265, 0.17801843830517283`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7019201369358166, 0.8150904193584265, 0.17801843830517283`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7019201369358166, 0.8150904193584265, 0.17801843830517283`]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->10,
            
            FontColor->RGBColor[
             0.8251927427376597, 0.09974208749731672, 0.9127431834693527],
            $CellContext`LineColor -> 
            RGBColor[
             0.8251927427376597, 0.09974208749731672, 0.9127431834693527],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8251927427376597, 0.09974208749731672, 0.9127431834693527],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8251927427376597, 0.09974208749731672, 0.9127431834693527],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8251927427376597, 0.09974208749731672, 0.9127431834693527]], 
           StyleBox["8",
            StripOnInput->False,
            FontSize->0,
            
            FontColor->RGBColor[
             0.7054181721732131, 0.587766896956228, 0.04478759502712104],
            $CellContext`LineColor -> 
            RGBColor[
             0.7054181721732131, 0.587766896956228, 0.04478759502712104],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7054181721732131, 0.587766896956228, 0.04478759502712104],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7054181721732131, 0.587766896956228, 0.04478759502712104],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7054181721732131, 0.587766896956228, 0.04478759502712104]]},
          {
           StyleBox["1",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.26437178504185277`, 0.48222244786030144`, 0.9980454979890234],
            $CellContext`LineColor -> 
            RGBColor[
             0.26437178504185277`, 0.48222244786030144`, 0.9980454979890234],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.26437178504185277`, 0.48222244786030144`, 0.9980454979890234],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.26437178504185277`, 0.48222244786030144`, 0.9980454979890234],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.26437178504185277`, 0.48222244786030144`, 0.9980454979890234]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->13,
            
            FontColor->RGBColor[
             0.17729943209052923`, 0.026303719773161927`, 
              0.042401949626215796`],
            $CellContext`LineColor -> 
            RGBColor[
             0.17729943209052923`, 0.026303719773161927`, 
              0.042401949626215796`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.17729943209052923`, 0.026303719773161927`, 
              0.042401949626215796`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.17729943209052923`, 0.026303719773161927`, 
              0.042401949626215796`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.17729943209052923`, 0.026303719773161927`, 
              0.042401949626215796`]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->12,
            
            FontColor->RGBColor[
             0.3282504684924046, 0.6094793741963911, 0.11925212993662027`],
            $CellContext`LineColor -> 
            RGBColor[
             0.3282504684924046, 0.6094793741963911, 0.11925212993662027`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3282504684924046, 0.6094793741963911, 0.11925212993662027`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3282504684924046, 0.6094793741963911, 0.11925212993662027`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3282504684924046, 0.6094793741963911, 0.11925212993662027`]], 
           StyleBox["8",
            StripOnInput->False,
            FontSize->23,
            
            FontColor->RGBColor[
             0.6036941440914374, 0.713388653240226, 0.9167811570871334],
            $CellContext`LineColor -> 
            RGBColor[
             0.6036941440914374, 0.713388653240226, 0.9167811570871334],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6036941440914374, 0.713388653240226, 0.9167811570871334],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6036941440914374, 0.713388653240226, 0.9167811570871334],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6036941440914374, 0.713388653240226, 0.9167811570871334]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->32,
            
            FontColor->RGBColor[
             0.30106340029089673`, 0.45970843443912424`, 0.7702723902469113],
            $CellContext`LineColor -> 
            RGBColor[
             0.30106340029089673`, 0.45970843443912424`, 0.7702723902469113],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.30106340029089673`, 0.45970843443912424`, 0.7702723902469113],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.30106340029089673`, 0.45970843443912424`, 0.7702723902469113],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.30106340029089673`, 0.45970843443912424`, 0.7702723902469113]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->6,
            
            FontColor->RGBColor[
             0.5456451879672277, 0.8422277215467933, 0.12837601363247364`],
            $CellContext`LineColor -> 
            RGBColor[
             0.5456451879672277, 0.8422277215467933, 0.12837601363247364`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5456451879672277, 0.8422277215467933, 0.12837601363247364`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5456451879672277, 0.8422277215467933, 0.12837601363247364`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5456451879672277, 0.8422277215467933, 0.12837601363247364`]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->28,
            
            FontColor->RGBColor[
             0.7245705021118218, 0.09892417541793153, 0.17085187604946062`],
            $CellContext`LineColor -> 
            RGBColor[
             0.7245705021118218, 0.09892417541793153, 0.17085187604946062`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7245705021118218, 0.09892417541793153, 0.17085187604946062`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7245705021118218, 0.09892417541793153, 0.17085187604946062`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7245705021118218, 0.09892417541793153, 0.17085187604946062`]], 
           
           StyleBox["1",
            StripOnInput->False,
            FontSize->25,
            
            FontColor->RGBColor[
             0.5617335889490689, 0.4222256319019486, 0.3437230520661403],
            $CellContext`LineColor -> 
            RGBColor[
             0.5617335889490689, 0.4222256319019486, 0.3437230520661403],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5617335889490689, 0.4222256319019486, 0.3437230520661403],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5617335889490689, 0.4222256319019486, 0.3437230520661403],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5617335889490689, 0.4222256319019486, 0.3437230520661403]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->29,
            
            FontColor->RGBColor[
             0.9747932421790846, 0.5309206799878152, 0.5760336596015216],
            $CellContext`LineColor -> 
            RGBColor[
             0.9747932421790846, 0.5309206799878152, 0.5760336596015216],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9747932421790846, 0.5309206799878152, 0.5760336596015216],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9747932421790846, 0.5309206799878152, 0.5760336596015216],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9747932421790846, 0.5309206799878152, 0.5760336596015216]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->27,
            
            FontColor->RGBColor[
             0.09452887817898281, 0.3715250338634115, 0.5827110932377826],
            $CellContext`LineColor -> 
            RGBColor[
             0.09452887817898281, 0.3715250338634115, 0.5827110932377826],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.09452887817898281, 0.3715250338634115, 0.5827110932377826],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.09452887817898281, 0.3715250338634115, 0.5827110932377826],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.09452887817898281, 0.3715250338634115, 0.5827110932377826]]},
          {
           StyleBox["5",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.14969893525992894`, 0.025201200052848316`, 
              0.6621365130693713],
            $CellContext`LineColor -> 
            RGBColor[
             0.14969893525992894`, 0.025201200052848316`, 
              0.6621365130693713],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.14969893525992894`, 0.025201200052848316`, 
              0.6621365130693713],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.14969893525992894`, 0.025201200052848316`, 
              0.6621365130693713],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.14969893525992894`, 0.025201200052848316`, 0.6621365130693713]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->27,
            
            FontColor->RGBColor[
             0.10030370116456089`, 0.5425151801731958, 0.5203834071049269],
            $CellContext`LineColor -> 
            RGBColor[
             0.10030370116456089`, 0.5425151801731958, 0.5203834071049269],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.10030370116456089`, 0.5425151801731958, 0.5203834071049269],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.10030370116456089`, 0.5425151801731958, 0.5203834071049269],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.10030370116456089`, 0.5425151801731958, 0.5203834071049269]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->17,
            
            FontColor->RGBColor[
             0.9803640278006558, 0.3534818919142759, 0.08157038312177622],
            $CellContext`LineColor -> 
            RGBColor[
             0.9803640278006558, 0.3534818919142759, 0.08157038312177622],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9803640278006558, 0.3534818919142759, 0.08157038312177622],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9803640278006558, 0.3534818919142759, 0.08157038312177622],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9803640278006558, 0.3534818919142759, 0.08157038312177622]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->24,
            
            FontColor->RGBColor[
             0.24845479145861837`, 0.04133580558297667, 0.9883774596983335],
            $CellContext`LineColor -> 
            RGBColor[
             0.24845479145861837`, 0.04133580558297667, 0.9883774596983335],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.24845479145861837`, 0.04133580558297667, 0.9883774596983335],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.24845479145861837`, 0.04133580558297667, 0.9883774596983335],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.24845479145861837`, 0.04133580558297667, 0.9883774596983335]], 
           
           StyleBox["2",
            StripOnInput->False,
            FontSize->6,
            
            FontColor->RGBColor[
             0.3433831233910909, 0.35186063155032987`, 0.5971996580348775],
            $CellContext`LineColor -> 
            RGBColor[
             0.3433831233910909, 0.35186063155032987`, 0.5971996580348775],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3433831233910909, 0.35186063155032987`, 0.5971996580348775],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3433831233910909, 0.35186063155032987`, 0.5971996580348775],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3433831233910909, 0.35186063155032987`, 0.5971996580348775]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->22,
            
            FontColor->RGBColor[
             0.1654121671196429, 0.9929827725068261, 0.6576909298127962],
            $CellContext`LineColor -> 
            RGBColor[
             0.1654121671196429, 0.9929827725068261, 0.6576909298127962],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.1654121671196429, 0.9929827725068261, 0.6576909298127962],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.1654121671196429, 0.9929827725068261, 0.6576909298127962],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.1654121671196429, 0.9929827725068261, 0.6576909298127962]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->10,
            
            FontColor->RGBColor[
             0.825016972215417, 0.22133200735359537`, 0.09391592454761932],
            $CellContext`LineColor -> 
            RGBColor[
             0.825016972215417, 0.22133200735359537`, 0.09391592454761932],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.825016972215417, 0.22133200735359537`, 0.09391592454761932],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.825016972215417, 0.22133200735359537`, 0.09391592454761932],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.825016972215417, 0.22133200735359537`, 0.09391592454761932]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->4,
            
            FontColor->RGBColor[
             0.11422481568555032`, 0.4814707210301128, 0.4670970181698648],
            $CellContext`LineColor -> 
            RGBColor[
             0.11422481568555032`, 0.4814707210301128, 0.4670970181698648],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.11422481568555032`, 0.4814707210301128, 0.4670970181698648],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.11422481568555032`, 0.4814707210301128, 0.4670970181698648],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.11422481568555032`, 0.4814707210301128, 0.4670970181698648]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->9,
            
            FontColor->RGBColor[
             0.6210002640565684, 0.42160028102348646`, 0.49584165318383144`],
            $CellContext`LineColor -> 
            RGBColor[
             0.6210002640565684, 0.42160028102348646`, 0.49584165318383144`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6210002640565684, 0.42160028102348646`, 0.49584165318383144`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6210002640565684, 0.42160028102348646`, 0.49584165318383144`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6210002640565684, 0.42160028102348646`, 0.49584165318383144`]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->3,
            
            FontColor->RGBColor[
             0.8288619141408413, 0.10374689658995018`, 0.1388220372367437],
            $CellContext`LineColor -> 
            RGBColor[
             0.8288619141408413, 0.10374689658995018`, 0.1388220372367437],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8288619141408413, 0.10374689658995018`, 0.1388220372367437],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8288619141408413, 0.10374689658995018`, 0.1388220372367437],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8288619141408413, 0.10374689658995018`, 0.1388220372367437]]},
          {
           StyleBox["9",
            StripOnInput->False,
            FontSize->4,
            
            FontColor->RGBColor[
             0.7007244450316727, 0.7464975141037635, 0.13525694095145013`],
            $CellContext`LineColor -> 
            RGBColor[
             0.7007244450316727, 0.7464975141037635, 0.13525694095145013`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7007244450316727, 0.7464975141037635, 0.13525694095145013`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7007244450316727, 0.7464975141037635, 0.13525694095145013`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7007244450316727, 0.7464975141037635, 0.13525694095145013`]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->3,
            
            FontColor->RGBColor[
             0.8343143801912609, 0.7766346508906925, 0.511589765700941],
            $CellContext`LineColor -> 
            RGBColor[
             0.8343143801912609, 0.7766346508906925, 0.511589765700941],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8343143801912609, 0.7766346508906925, 0.511589765700941],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8343143801912609, 0.7766346508906925, 0.511589765700941],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8343143801912609, 0.7766346508906925, 0.511589765700941]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->2,
            
            FontColor->RGBColor[
             0.9217711129849004, 0.9507783621383128, 0.13359501473998314`],
            $CellContext`LineColor -> 
            RGBColor[
             0.9217711129849004, 0.9507783621383128, 0.13359501473998314`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.9217711129849004, 0.9507783621383128, 0.13359501473998314`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.9217711129849004, 0.9507783621383128, 0.13359501473998314`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.9217711129849004, 0.9507783621383128, 0.13359501473998314`]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->20,
            
            FontColor->RGBColor[
             0.45518177752623457`, 0.5729908608470065, 0.27285782057102015`],
            $CellContext`LineColor -> 
            RGBColor[
             0.45518177752623457`, 0.5729908608470065, 0.27285782057102015`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.45518177752623457`, 0.5729908608470065, 0.27285782057102015`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.45518177752623457`, 0.5729908608470065, 0.27285782057102015`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.45518177752623457`, 0.5729908608470065, 0.27285782057102015`]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->17,
            
            FontColor->RGBColor[
             0.6229760701240024, 0.8867280388023944, 0.6186963488216632],
            $CellContext`LineColor -> 
            RGBColor[
             0.6229760701240024, 0.8867280388023944, 0.6186963488216632],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6229760701240024, 0.8867280388023944, 0.6186963488216632],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6229760701240024, 0.8867280388023944, 0.6186963488216632],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6229760701240024, 0.8867280388023944, 0.6186963488216632]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->9,
            
            FontColor->RGBColor[
             0.08453542367789879, 0.1729579941777235, 0.2568597116129956],
            $CellContext`LineColor -> 
            RGBColor[
             0.08453542367789879, 0.1729579941777235, 0.2568597116129956],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.08453542367789879, 0.1729579941777235, 0.2568597116129956],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.08453542367789879, 0.1729579941777235, 0.2568597116129956],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.08453542367789879, 0.1729579941777235, 0.2568597116129956]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->16,
            
            FontColor->RGBColor[
             0.4156713443464741, 0.1466578840134789, 0.9767345511971646],
            $CellContext`LineColor -> 
            RGBColor[
             0.4156713443464741, 0.1466578840134789, 0.9767345511971646],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4156713443464741, 0.1466578840134789, 0.9767345511971646],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4156713443464741, 0.1466578840134789, 0.9767345511971646],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4156713443464741, 0.1466578840134789, 0.9767345511971646]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->19,
            
            FontColor->RGBColor[
             0.5852039239589826, 0.8256229744132322, 0.7723979027675274],
            $CellContext`LineColor -> 
            RGBColor[
             0.5852039239589826, 0.8256229744132322, 0.7723979027675274],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5852039239589826, 0.8256229744132322, 0.7723979027675274],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5852039239589826, 0.8256229744132322, 0.7723979027675274],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5852039239589826, 0.8256229744132322, 0.7723979027675274]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->5,
            
            FontColor->RGBColor[
             0.4818057762663699, 0.6963144820357594, 0.6177441719881731],
            $CellContext`LineColor -> 
            RGBColor[
             0.4818057762663699, 0.6963144820357594, 0.6177441719881731],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4818057762663699, 0.6963144820357594, 0.6177441719881731],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4818057762663699, 0.6963144820357594, 0.6177441719881731],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4818057762663699, 0.6963144820357594, 0.6177441719881731]], 
           StyleBox["1",
            StripOnInput->False,
            FontSize->7,
            
            FontColor->RGBColor[
             0.7188573601050017, 0.7829904574368323, 0.8178056743132298],
            $CellContext`LineColor -> 
            RGBColor[
             0.7188573601050017, 0.7829904574368323, 0.8178056743132298],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7188573601050017, 0.7829904574368323, 0.8178056743132298],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7188573601050017, 0.7829904574368323, 0.8178056743132298],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7188573601050017, 0.7829904574368323, 0.8178056743132298]]},
          {
           StyleBox["10",
            StripOnInput->False,
            FontSize->1,
            
            FontColor->RGBColor[
             0.883955421988688, 0.7358216188527027, 0.7454035348371808],
            $CellContext`LineColor -> 
            RGBColor[
             0.883955421988688, 0.7358216188527027, 0.7454035348371808],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.883955421988688, 0.7358216188527027, 0.7454035348371808],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.883955421988688, 0.7358216188527027, 0.7454035348371808],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.883955421988688, 0.7358216188527027, 0.7454035348371808]], 
           StyleBox["7",
            StripOnInput->False,
            FontSize->12,
            
            FontColor->RGBColor[
             0.7953380235061249, 0.07316538729860977, 0.6088666218672381],
            $CellContext`LineColor -> 
            RGBColor[
             0.7953380235061249, 0.07316538729860977, 0.6088666218672381],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7953380235061249, 0.07316538729860977, 0.6088666218672381],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7953380235061249, 0.07316538729860977, 0.6088666218672381],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7953380235061249, 0.07316538729860977, 0.6088666218672381]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->1,
            
            FontColor->RGBColor[
             0.8539262638840277, 0.5100287604759157, 0.07644624461698468],
            $CellContext`LineColor -> 
            RGBColor[
             0.8539262638840277, 0.5100287604759157, 0.07644624461698468],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8539262638840277, 0.5100287604759157, 0.07644624461698468],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8539262638840277, 0.5100287604759157, 0.07644624461698468],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8539262638840277, 0.5100287604759157, 0.07644624461698468]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->11,
            
            FontColor->RGBColor[
             0.20376458116902652`, 0.6060410509859442, 0.6590842620759105],
            $CellContext`LineColor -> 
            RGBColor[
             0.20376458116902652`, 0.6060410509859442, 0.6590842620759105],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.20376458116902652`, 0.6060410509859442, 0.6590842620759105],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.20376458116902652`, 0.6060410509859442, 0.6590842620759105],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.20376458116902652`, 0.6060410509859442, 0.6590842620759105]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->30,
            
            FontColor->RGBColor[
             0.21412271051274634`, 0.9025805834334508, 0.8611914381825183],
            $CellContext`LineColor -> 
            RGBColor[
             0.21412271051274634`, 0.9025805834334508, 0.8611914381825183],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.21412271051274634`, 0.9025805834334508, 0.8611914381825183],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.21412271051274634`, 0.9025805834334508, 0.8611914381825183],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.21412271051274634`, 0.9025805834334508, 0.8611914381825183]], 
           StyleBox["0",
            StripOnInput->False,
            FontSize->6,
            
            FontColor->RGBColor[
             0.5840560880196994, 0.05457691348378457, 0.8731487215864491],
            $CellContext`LineColor -> 
            RGBColor[
             0.5840560880196994, 0.05457691348378457, 0.8731487215864491],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5840560880196994, 0.05457691348378457, 0.8731487215864491],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5840560880196994, 0.05457691348378457, 0.8731487215864491],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5840560880196994, 0.05457691348378457, 0.8731487215864491]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.8007895850461415, 0.8939943920336992, 0.9148683921879992],
            $CellContext`LineColor -> 
            RGBColor[
             0.8007895850461415, 0.8939943920336992, 0.9148683921879992],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.8007895850461415, 0.8939943920336992, 0.9148683921879992],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.8007895850461415, 0.8939943920336992, 0.9148683921879992],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.8007895850461415, 0.8939943920336992, 0.9148683921879992]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->18,
            
            FontColor->RGBColor[
             0.5819120495339196, 0.19021560708012508`, 0.43083274271140626`],
            $CellContext`LineColor -> 
            RGBColor[
             0.5819120495339196, 0.19021560708012508`, 0.43083274271140626`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5819120495339196, 0.19021560708012508`, 0.43083274271140626`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5819120495339196, 0.19021560708012508`, 0.43083274271140626`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5819120495339196, 0.19021560708012508`, 0.43083274271140626`]], 
           StyleBox["3",
            StripOnInput->False,
            FontSize->10,
            
            FontColor->RGBColor[
             0.5122579200680246, 0.7698976797670001, 0.8348171972766512],
            $CellContext`LineColor -> 
            RGBColor[
             0.5122579200680246, 0.7698976797670001, 0.8348171972766512],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.5122579200680246, 0.7698976797670001, 0.8348171972766512],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.5122579200680246, 0.7698976797670001, 0.8348171972766512],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.5122579200680246, 0.7698976797670001, 0.8348171972766512]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->20,
            
            FontColor->RGBColor[
             0.842727458015998, 0.10990589184529709`, 0.6048144392753179],
            $CellContext`LineColor -> 
            RGBColor[
             0.842727458015998, 0.10990589184529709`, 0.6048144392753179],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.842727458015998, 0.10990589184529709`, 0.6048144392753179],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.842727458015998, 0.10990589184529709`, 0.6048144392753179],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.842727458015998, 0.10990589184529709`, 0.6048144392753179]]},
          {
           StyleBox["8",
            StripOnInput->False,
            FontSize->7,
            
            FontColor->RGBColor[
             0.640723103758277, 0.9542820467754636, 0.06673488028389363],
            $CellContext`LineColor -> 
            RGBColor[
             0.640723103758277, 0.9542820467754636, 0.06673488028389363],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.640723103758277, 0.9542820467754636, 0.06673488028389363],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.640723103758277, 0.9542820467754636, 0.06673488028389363],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.640723103758277, 0.9542820467754636, 0.06673488028389363]], 
           StyleBox["4",
            StripOnInput->False,
            FontSize->30,
            
            FontColor->RGBColor[
             0.11576425340055585`, 0.1367949477881687, 0.6727740368940793],
            $CellContext`LineColor -> 
            RGBColor[
             0.11576425340055585`, 0.1367949477881687, 0.6727740368940793],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.11576425340055585`, 0.1367949477881687, 0.6727740368940793],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.11576425340055585`, 0.1367949477881687, 0.6727740368940793],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.11576425340055585`, 0.1367949477881687, 0.6727740368940793]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->10,
            
            FontColor->RGBColor[
             0.4811815357614613, 0.5598944607723828, 0.6299500837463534],
            $CellContext`LineColor -> 
            RGBColor[
             0.4811815357614613, 0.5598944607723828, 0.6299500837463534],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.4811815357614613, 0.5598944607723828, 0.6299500837463534],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.4811815357614613, 0.5598944607723828, 0.6299500837463534],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.4811815357614613, 0.5598944607723828, 0.6299500837463534]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->1,
            
            FontColor->RGBColor[
             0.6018948013362642, 0.5626573515565365, 0.8080869000810023],
            $CellContext`LineColor -> 
            RGBColor[
             0.6018948013362642, 0.5626573515565365, 0.8080869000810023],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6018948013362642, 0.5626573515565365, 0.8080869000810023],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6018948013362642, 0.5626573515565365, 0.8080869000810023],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6018948013362642, 0.5626573515565365, 0.8080869000810023]], 
           StyleBox["10",
            StripOnInput->False,
            FontSize->29,
            
            FontColor->RGBColor[
             0.7414959341980489, 0.7753886517906312, 0.3077736138114906],
            $CellContext`LineColor -> 
            RGBColor[
             0.7414959341980489, 0.7753886517906312, 0.3077736138114906],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.7414959341980489, 0.7753886517906312, 0.3077736138114906],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.7414959341980489, 0.7753886517906312, 0.3077736138114906],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.7414959341980489, 0.7753886517906312, 0.3077736138114906]], 
           StyleBox["9",
            StripOnInput->False,
            FontSize->14,
            
            FontColor->RGBColor[
             0.6842027856197486, 0.33985505387674486`, 
              0.015172855064281121`],
            $CellContext`LineColor -> 
            RGBColor[
             0.6842027856197486, 0.33985505387674486`, 
              0.015172855064281121`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6842027856197486, 0.33985505387674486`, 
              0.015172855064281121`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6842027856197486, 0.33985505387674486`, 
              0.015172855064281121`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6842027856197486, 0.33985505387674486`, 0.015172855064281121`]], 
           StyleBox["8",
            StripOnInput->False,
            FontSize->15,
            
            FontColor->RGBColor[
             0.12555720585021168`, 0.9626170676540025, 0.47828411202978427`],
            $CellContext`LineColor -> 
            RGBColor[
             0.12555720585021168`, 0.9626170676540025, 0.47828411202978427`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.12555720585021168`, 0.9626170676540025, 0.47828411202978427`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.12555720585021168`, 0.9626170676540025, 0.47828411202978427`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.12555720585021168`, 0.9626170676540025, 0.47828411202978427`]], 
           StyleBox["2",
            StripOnInput->False,
            FontSize->11,
            
            FontColor->RGBColor[
             0.21480380137050759`, 0.21953154169857014`, 0.19208719109994954`],
            $CellContext`LineColor -> 
            RGBColor[
             0.21480380137050759`, 0.21953154169857014`, 0.19208719109994954`],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.21480380137050759`, 0.21953154169857014`, 0.19208719109994954`],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.21480380137050759`, 0.21953154169857014`, 0.19208719109994954`],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.21480380137050759`, 0.21953154169857014`, 
              0.19208719109994954`]], 
           StyleBox["6",
            StripOnInput->False,
            FontSize->27,
            FontColor->RGBColor[
             0.3108017697022778, 0.9463324936066282, 0.3991195333347186],
            $CellContext`LineColor -> 
            RGBColor[
             0.3108017697022778, 0.9463324936066282, 0.3991195333347186],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.3108017697022778, 0.9463324936066282, 0.3991195333347186],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.3108017697022778, 0.9463324936066282, 0.3991195333347186],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.3108017697022778, 0.9463324936066282, 0.3991195333347186]], 
           StyleBox["5",
            StripOnInput->False,
            FontSize->15,
            
            FontColor->RGBColor[
             0.6565647572960256, 0.5745691609258363, 0.4311324194115711],
            $CellContext`LineColor -> 
            RGBColor[
             0.6565647572960256, 0.5745691609258363, 0.4311324194115711],
            $CellContext`FrontFaceColor -> 
            RGBColor[
             0.6565647572960256, 0.5745691609258363, 0.4311324194115711],
            $CellContext`GraphicsColor -> 
            RGBColor[
             0.6565647572960256, 0.5745691609258363, 0.4311324194115711],
            $CellContext`BackFaceColor -> 
            RGBColor[
             0.6565647572960256, 0.5745691609258363, 0.4311324194115711]]}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "e7987587-62c3-4003-8c3e-0870181af302"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2527981501804366, 0.051346295724271185`, 
                0.7047358496269513], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2527981501804366, 0.051346295724271185`, 
                0.7047358496269513], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
               FontSize -> 28, FontColor -> 
              RGBColor[
               0.2527981501804366, 0.051346295724271185`, 0.7047358496269513],
               $CellContext`BackFaceColor -> 
              RGBColor[
               0.2527981501804366, 0.051346295724271185`, 
                0.7047358496269513]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8186859567431535, 0.6796469190736123, 
                0.9539039716800006], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8186859567431535, 0.6796469190736123, 
                0.9539039716800006], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8186859567431535, 0.6796469190736123, 0.9539039716800006], 
              FontSize -> 26, FontColor -> 
              RGBColor[
               0.8186859567431535, 0.6796469190736123, 
                0.9539039716800006], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8186859567431535, 0.6796469190736123, 0.9539039716800006]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.503258301075572, 0.05842253573276168, 
                0.19630901791408784`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.503258301075572, 0.05842253573276168, 
                0.19630901791408784`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.503258301075572, 0.05842253573276168, 0.19630901791408784`], 
              FontSize -> 30, FontColor -> 
              RGBColor[
               0.503258301075572, 0.05842253573276168, 
                0.19630901791408784`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.503258301075572, 0.05842253573276168, 0.19630901791408784`]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.921497756122005, 0.6246948249955864, 
                0.7675015152672202], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.921497756122005, 0.6246948249955864, 
                0.7675015152672202], $CellContext`GraphicsColor -> 
              RGBColor[
               0.921497756122005, 0.6246948249955864, 0.7675015152672202], 
              FontSize -> 15, FontColor -> 
              RGBColor[
               0.921497756122005, 0.6246948249955864, 
                0.7675015152672202], $CellContext`BackFaceColor -> 
              RGBColor[
               0.921497756122005, 0.6246948249955864, 0.7675015152672202]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.49987015615055386`, 0.3301992135098233, 
                0.4198427570509966], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.49987015615055386`, 0.3301992135098233, 
                0.4198427570509966], $CellContext`GraphicsColor -> 
              RGBColor[
               0.49987015615055386`, 0.3301992135098233, 0.4198427570509966], 
              FontSize -> 4, FontColor -> 
              RGBColor[
               0.49987015615055386`, 0.3301992135098233, 
                0.4198427570509966], $CellContext`BackFaceColor -> 
              RGBColor[
               0.49987015615055386`, 0.3301992135098233, 0.4198427570509966]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6251236205557267, 0.8954245296169396, 
                0.71010711398662], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6251236205557267, 0.8954245296169396, 
                0.71010711398662], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6251236205557267, 0.8954245296169396, 0.71010711398662], 
              FontSize -> 28, FontColor -> 
              RGBColor[
               0.6251236205557267, 0.8954245296169396, 
                0.71010711398662], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6251236205557267, 0.8954245296169396, 0.71010711398662]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2930424341650133, 0.9903716671783811, 
                0.1404102351951737], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2930424341650133, 0.9903716671783811, 
                0.1404102351951737], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2930424341650133, 0.9903716671783811, 0.1404102351951737], 
              FontSize -> 27, FontColor -> 
              RGBColor[
               0.2930424341650133, 0.9903716671783811, 
                0.1404102351951737], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2930424341650133, 0.9903716671783811, 0.1404102351951737]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.30673617645187057`, 0.054534109139190434`, 
                0.5286535195398157], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.30673617645187057`, 0.054534109139190434`, 
                0.5286535195398157], $CellContext`GraphicsColor -> 
              RGBColor[
               0.30673617645187057`, 0.054534109139190434`, 
                0.5286535195398157], FontSize -> 2, FontColor -> 
              RGBColor[
               0.30673617645187057`, 0.054534109139190434`, 
                0.5286535195398157], $CellContext`BackFaceColor -> 
              RGBColor[
               0.30673617645187057`, 0.054534109139190434`, 
                0.5286535195398157]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6619902075347164, 0.7746635945806386, 
                0.0654616924884368], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6619902075347164, 0.7746635945806386, 
                0.0654616924884368], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6619902075347164, 0.7746635945806386, 0.0654616924884368], 
              FontSize -> 14, FontColor -> 
              RGBColor[
               0.6619902075347164, 0.7746635945806386, 
                0.0654616924884368], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6619902075347164, 0.7746635945806386, 0.0654616924884368]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7023010850652094, 0.2523846384906363, 
                0.5960873768481041], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7023010850652094, 0.2523846384906363, 
                0.5960873768481041], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7023010850652094, 0.2523846384906363, 0.5960873768481041], 
              FontSize -> 25, FontColor -> 
              RGBColor[
               0.7023010850652094, 0.2523846384906363, 
                0.5960873768481041], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7023010850652094, 0.2523846384906363, 0.5960873768481041]]}, {
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9898351034570245, 0.17143815351419422`, 
                0.44706629950594823`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9898351034570245, 0.17143815351419422`, 
                0.44706629950594823`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9898351034570245, 0.17143815351419422`, 
                0.44706629950594823`], FontSize -> 14, FontColor -> 
              RGBColor[
               0.9898351034570245, 0.17143815351419422`, 
                0.44706629950594823`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9898351034570245, 0.17143815351419422`, 
                0.44706629950594823`]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.12059600993776809`, 0.9418663036107549, 
                0.16795600567108337`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.12059600993776809`, 0.9418663036107549, 
                0.16795600567108337`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.12059600993776809`, 0.9418663036107549, 
                0.16795600567108337`], FontSize -> 15, FontColor -> 
              RGBColor[
               0.12059600993776809`, 0.9418663036107549, 
                0.16795600567108337`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.12059600993776809`, 0.9418663036107549, 
                0.16795600567108337`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5061760875552237, 0.8966155738094657, 
                0.8804817857842184], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5061760875552237, 0.8966155738094657, 
                0.8804817857842184], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5061760875552237, 0.8966155738094657, 0.8804817857842184], 
              FontSize -> 1, FontColor -> 
              RGBColor[
               0.5061760875552237, 0.8966155738094657, 
                0.8804817857842184], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5061760875552237, 0.8966155738094657, 0.8804817857842184]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8722825504573608, 0.8372634776488366, 
                0.8427061542213237], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8722825504573608, 0.8372634776488366, 
                0.8427061542213237], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8722825504573608, 0.8372634776488366, 0.8427061542213237], 
              FontSize -> 30, FontColor -> 
              RGBColor[
               0.8722825504573608, 0.8372634776488366, 
                0.8427061542213237], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8722825504573608, 0.8372634776488366, 0.8427061542213237]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8619772582503522, 0.8840843485326337, 
                0.8221800988659629], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8619772582503522, 0.8840843485326337, 
                0.8221800988659629], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8619772582503522, 0.8840843485326337, 0.8221800988659629], 
              FontSize -> 22, FontColor -> 
              RGBColor[
               0.8619772582503522, 0.8840843485326337, 
                0.8221800988659629], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8619772582503522, 0.8840843485326337, 0.8221800988659629]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.23114183487850948`, 0.2681356316356318, 
                0.956696004968195], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.23114183487850948`, 0.2681356316356318, 
                0.956696004968195], $CellContext`GraphicsColor -> 
              RGBColor[
               0.23114183487850948`, 0.2681356316356318, 0.956696004968195], 
              FontSize -> 10, FontColor -> 
              RGBColor[
               0.23114183487850948`, 0.2681356316356318, 
                0.956696004968195], $CellContext`BackFaceColor -> 
              RGBColor[
               0.23114183487850948`, 0.2681356316356318, 0.956696004968195]], 
             
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.625353969818822, 0.9393856601561026, 
                0.06593656070006904], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.625353969818822, 0.9393856601561026, 
                0.06593656070006904], $CellContext`GraphicsColor -> 
              RGBColor[
               0.625353969818822, 0.9393856601561026, 0.06593656070006904], 
              FontSize -> 14, FontColor -> 
              RGBColor[
               0.625353969818822, 0.9393856601561026, 
                0.06593656070006904], $CellContext`BackFaceColor -> 
              RGBColor[
               0.625353969818822, 0.9393856601561026, 0.06593656070006904]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.029318625400041487`, 0.3266361925413823, 
                0.054019367358514314`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.029318625400041487`, 0.3266361925413823, 
                0.054019367358514314`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.029318625400041487`, 0.3266361925413823, 
                0.054019367358514314`], FontSize -> 30, FontColor -> 
              RGBColor[
               0.029318625400041487`, 0.3266361925413823, 
                0.054019367358514314`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.029318625400041487`, 0.3266361925413823, 
                0.054019367358514314`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.4562550776198575, 0.5810992708524032, 
                0.2162956578741433], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.4562550776198575, 0.5810992708524032, 
                0.2162956578741433], $CellContext`GraphicsColor -> 
              RGBColor[
               0.4562550776198575, 0.5810992708524032, 0.2162956578741433], 
              FontSize -> 20, FontColor -> 
              RGBColor[
               0.4562550776198575, 0.5810992708524032, 
                0.2162956578741433], $CellContext`BackFaceColor -> 
              RGBColor[
               0.4562550776198575, 0.5810992708524032, 0.2162956578741433]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.551456609354444, 0.9558169470426987, 
                0.2934195872998968], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.551456609354444, 0.9558169470426987, 
                0.2934195872998968], $CellContext`GraphicsColor -> 
              RGBColor[
               0.551456609354444, 0.9558169470426987, 0.2934195872998968], 
              FontSize -> 12, FontColor -> 
              RGBColor[
               0.551456609354444, 0.9558169470426987, 
                0.2934195872998968], $CellContext`BackFaceColor -> 
              RGBColor[
               0.551456609354444, 0.9558169470426987, 0.2934195872998968]]}, {
            
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7008785041869177, 0.3240956864067934, 
                0.8790969634999826], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7008785041869177, 0.3240956864067934, 
                0.8790969634999826], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7008785041869177, 0.3240956864067934, 0.8790969634999826], 
              FontSize -> 4, FontColor -> 
              RGBColor[
               0.7008785041869177, 0.3240956864067934, 
                0.8790969634999826], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7008785041869177, 0.3240956864067934, 0.8790969634999826]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.23181891963698686`, 0.4819483907158708, 
                0.48174197039455113`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.23181891963698686`, 0.4819483907158708, 
                0.48174197039455113`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.23181891963698686`, 0.4819483907158708, 
                0.48174197039455113`], FontSize -> 5, FontColor -> 
              RGBColor[
               0.23181891963698686`, 0.4819483907158708, 
                0.48174197039455113`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.23181891963698686`, 0.4819483907158708, 
                0.48174197039455113`]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3878162591695542, 0.8809154651953834, 
                0.34660843359808546`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3878162591695542, 0.8809154651953834, 
                0.34660843359808546`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3878162591695542, 0.8809154651953834, 0.34660843359808546`], 
              FontSize -> 14, FontColor -> 
              RGBColor[
               0.3878162591695542, 0.8809154651953834, 
                0.34660843359808546`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3878162591695542, 0.8809154651953834, 0.34660843359808546`]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8269293855186073, 0.7434684446767155, 
                0.7864301187165403], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8269293855186073, 0.7434684446767155, 
                0.7864301187165403], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8269293855186073, 0.7434684446767155, 0.7864301187165403], 
              FontSize -> 24, FontColor -> 
              RGBColor[
               0.8269293855186073, 0.7434684446767155, 
                0.7864301187165403], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8269293855186073, 0.7434684446767155, 0.7864301187165403]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2633799846792557, 0.5036219177969019, 
                0.8099519487838835], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2633799846792557, 0.5036219177969019, 
                0.8099519487838835], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2633799846792557, 0.5036219177969019, 0.8099519487838835], 
              FontSize -> 0, FontColor -> 
              RGBColor[
               0.2633799846792557, 0.5036219177969019, 
                0.8099519487838835], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2633799846792557, 0.5036219177969019, 0.8099519487838835]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.835403554254116, 0.34997784933141096`, 
                0.32982521775949647`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.835403554254116, 0.34997784933141096`, 
                0.32982521775949647`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.835403554254116, 0.34997784933141096`, 0.32982521775949647`],
               FontSize -> 6, FontColor -> 
              RGBColor[
               0.835403554254116, 0.34997784933141096`, 
                0.32982521775949647`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.835403554254116, 0.34997784933141096`, 
                0.32982521775949647`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.25824128613619846`, 0.16735337824560004`, 
                0.8414842453712148], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.25824128613619846`, 0.16735337824560004`, 
                0.8414842453712148], $CellContext`GraphicsColor -> 
              RGBColor[
               0.25824128613619846`, 0.16735337824560004`, 
                0.8414842453712148], FontSize -> 7, FontColor -> 
              RGBColor[
               0.25824128613619846`, 0.16735337824560004`, 
                0.8414842453712148], $CellContext`BackFaceColor -> 
              RGBColor[
               0.25824128613619846`, 0.16735337824560004`, 
                0.8414842453712148]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9644221797586698, 0.7228715245597535, 
                0.027517708444436018`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9644221797586698, 0.7228715245597535, 
                0.027517708444436018`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9644221797586698, 0.7228715245597535, 0.027517708444436018`],
               FontSize -> 22, FontColor -> 
              RGBColor[
               0.9644221797586698, 0.7228715245597535, 
                0.027517708444436018`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9644221797586698, 0.7228715245597535, 
                0.027517708444436018`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2953201896614557, 0.030921071629127272`, 
                0.8543971907972887], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2953201896614557, 0.030921071629127272`, 
                0.8543971907972887], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2953201896614557, 0.030921071629127272`, 0.8543971907972887],
               FontSize -> 4, FontColor -> 
              RGBColor[
               0.2953201896614557, 0.030921071629127272`, 
                0.8543971907972887], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2953201896614557, 0.030921071629127272`, 
                0.8543971907972887]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8663737777925791, 0.2358741858360318, 
                0.40022765746453115`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8663737777925791, 0.2358741858360318, 
                0.40022765746453115`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8663737777925791, 0.2358741858360318, 0.40022765746453115`], 
              FontSize -> 7, FontColor -> 
              RGBColor[
               0.8663737777925791, 0.2358741858360318, 
                0.40022765746453115`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8663737777925791, 0.2358741858360318, 
                0.40022765746453115`]]}, {
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9615828397701947, 0.3719985929377574, 
                0.26265233446167513`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9615828397701947, 0.3719985929377574, 
                0.26265233446167513`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9615828397701947, 0.3719985929377574, 0.26265233446167513`], 
              FontSize -> 25, FontColor -> 
              RGBColor[
               0.9615828397701947, 0.3719985929377574, 
                0.26265233446167513`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9615828397701947, 0.3719985929377574, 0.26265233446167513`]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.13037935965511305`, 0.4291257934229966, 
                0.3684048088208993], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.13037935965511305`, 0.4291257934229966, 
                0.3684048088208993], $CellContext`GraphicsColor -> 
              RGBColor[
               0.13037935965511305`, 0.4291257934229966, 0.3684048088208993], 
              FontSize -> 5, FontColor -> 
              RGBColor[
               0.13037935965511305`, 0.4291257934229966, 
                0.3684048088208993], $CellContext`BackFaceColor -> 
              RGBColor[
               0.13037935965511305`, 0.4291257934229966, 0.3684048088208993]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.18627831702840614`, 0.834314797539724, 
                0.852540674354334], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.18627831702840614`, 0.834314797539724, 
                0.852540674354334], $CellContext`GraphicsColor -> 
              RGBColor[
               0.18627831702840614`, 0.834314797539724, 0.852540674354334], 
              FontSize -> 16, FontColor -> 
              RGBColor[
               0.18627831702840614`, 0.834314797539724, 
                0.852540674354334], $CellContext`BackFaceColor -> 
              RGBColor[
               0.18627831702840614`, 0.834314797539724, 0.852540674354334]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6783423507719846, 0.4619588492232005, 
                0.4475244280421542], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6783423507719846, 0.4619588492232005, 
                0.4475244280421542], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6783423507719846, 0.4619588492232005, 0.4475244280421542], 
              FontSize -> 11, FontColor -> 
              RGBColor[
               0.6783423507719846, 0.4619588492232005, 
                0.4475244280421542], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6783423507719846, 0.4619588492232005, 0.4475244280421542]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.635547588708071, 0.8613085335586967, 
                0.7687380219428834], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.635547588708071, 0.8613085335586967, 
                0.7687380219428834], $CellContext`GraphicsColor -> 
              RGBColor[
               0.635547588708071, 0.8613085335586967, 0.7687380219428834], 
              FontSize -> 14, FontColor -> 
              RGBColor[
               0.635547588708071, 0.8613085335586967, 
                0.7687380219428834], $CellContext`BackFaceColor -> 
              RGBColor[
               0.635547588708071, 0.8613085335586967, 0.7687380219428834]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.28745761194158104`, 0.43673788556139237`, 
                0.35251959748136974`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.28745761194158104`, 0.43673788556139237`, 
                0.35251959748136974`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.28745761194158104`, 0.43673788556139237`, 
                0.35251959748136974`], FontSize -> 21, FontColor -> 
              RGBColor[
               0.28745761194158104`, 0.43673788556139237`, 
                0.35251959748136974`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.28745761194158104`, 0.43673788556139237`, 
                0.35251959748136974`]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7248519648139398, 0.3292011600212341, 
                0.2909179799750239], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7248519648139398, 0.3292011600212341, 
                0.2909179799750239], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7248519648139398, 0.3292011600212341, 0.2909179799750239], 
              FontSize -> 23, FontColor -> 
              RGBColor[
               0.7248519648139398, 0.3292011600212341, 
                0.2909179799750239], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7248519648139398, 0.3292011600212341, 0.2909179799750239]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7675830715768099, 0.9178050691463946, 
                0.3822869939964453], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7675830715768099, 0.9178050691463946, 
                0.3822869939964453], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7675830715768099, 0.9178050691463946, 0.3822869939964453], 
              FontSize -> 29, FontColor -> 
              RGBColor[
               0.7675830715768099, 0.9178050691463946, 
                0.3822869939964453], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7675830715768099, 0.9178050691463946, 0.3822869939964453]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.039223076693792436`, 0.5615704656502034, 
                0.7717329551040819], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.039223076693792436`, 0.5615704656502034, 
                0.7717329551040819], $CellContext`GraphicsColor -> 
              RGBColor[
               0.039223076693792436`, 0.5615704656502034, 0.7717329551040819],
               FontSize -> 18, FontColor -> 
              RGBColor[
               0.039223076693792436`, 0.5615704656502034, 
                0.7717329551040819], $CellContext`BackFaceColor -> 
              RGBColor[
               0.039223076693792436`, 0.5615704656502034, 
                0.7717329551040819]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8060503306560909, 0.5148988659845668, 
                0.15961186687379247`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8060503306560909, 0.5148988659845668, 
                0.15961186687379247`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8060503306560909, 0.5148988659845668, 0.15961186687379247`], 
              FontSize -> 21, FontColor -> 
              RGBColor[
               0.8060503306560909, 0.5148988659845668, 
                0.15961186687379247`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8060503306560909, 0.5148988659845668, 
                0.15961186687379247`]]}, {
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.005513133972373518, 0.5857833630680225, 
                0.8791589135765423], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.005513133972373518, 0.5857833630680225, 
                0.8791589135765423], $CellContext`GraphicsColor -> 
              RGBColor[
               0.005513133972373518, 0.5857833630680225, 0.8791589135765423], 
              FontSize -> 5, FontColor -> 
              RGBColor[
               0.005513133972373518, 0.5857833630680225, 
                0.8791589135765423], $CellContext`BackFaceColor -> 
              RGBColor[
               0.005513133972373518, 0.5857833630680225, 0.8791589135765423]], 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8667655134377861, 0.6119154327560528, 
                0.1429278070352027], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8667655134377861, 0.6119154327560528, 
                0.1429278070352027], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8667655134377861, 0.6119154327560528, 0.1429278070352027], 
              FontSize -> 21, FontColor -> 
              RGBColor[
               0.8667655134377861, 0.6119154327560528, 
                0.1429278070352027], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8667655134377861, 0.6119154327560528, 0.1429278070352027]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.2916287498608525, 0.8153446155113955, 
                0.059898649081116195`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.2916287498608525, 0.8153446155113955, 
                0.059898649081116195`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.2916287498608525, 0.8153446155113955, 0.059898649081116195`],
               FontSize -> 28, FontColor -> 
              RGBColor[
               0.2916287498608525, 0.8153446155113955, 
                0.059898649081116195`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.2916287498608525, 0.8153446155113955, 
                0.059898649081116195`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.06364791069842868, 0.5637390319940896, 
                0.5202122124210933], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.06364791069842868, 0.5637390319940896, 
                0.5202122124210933], $CellContext`GraphicsColor -> 
              RGBColor[
               0.06364791069842868, 0.5637390319940896, 0.5202122124210933], 
              FontSize -> 1, FontColor -> 
              RGBColor[
               0.06364791069842868, 0.5637390319940896, 
                0.5202122124210933], $CellContext`BackFaceColor -> 
              RGBColor[
               0.06364791069842868, 0.5637390319940896, 0.5202122124210933]], 
             
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6513106813257332, 0.8592857959489539, 
                0.36564913729953274`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6513106813257332, 0.8592857959489539, 
                0.36564913729953274`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6513106813257332, 0.8592857959489539, 0.36564913729953274`], 
              FontSize -> 11, FontColor -> 
              RGBColor[
               0.6513106813257332, 0.8592857959489539, 
                0.36564913729953274`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6513106813257332, 0.8592857959489539, 0.36564913729953274`]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8442344684249734, 0.4119498457925306, 
                0.20549962493398333`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8442344684249734, 0.4119498457925306, 
                0.20549962493398333`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8442344684249734, 0.4119498457925306, 0.20549962493398333`], 
              FontSize -> 5, FontColor -> 
              RGBColor[
               0.8442344684249734, 0.4119498457925306, 
                0.20549962493398333`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8442344684249734, 0.4119498457925306, 0.20549962493398333`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6444121546795252, 0.5856848194428992, 
                0.5392457942888813], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6444121546795252, 0.5856848194428992, 
                0.5392457942888813], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6444121546795252, 0.5856848194428992, 0.5392457942888813], 
              FontSize -> 5, FontColor -> 
              RGBColor[
               0.6444121546795252, 0.5856848194428992, 
                0.5392457942888813], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6444121546795252, 0.5856848194428992, 0.5392457942888813]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7019201369358166, 0.8150904193584265, 
                0.17801843830517283`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7019201369358166, 0.8150904193584265, 
                0.17801843830517283`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7019201369358166, 0.8150904193584265, 0.17801843830517283`], 
              FontSize -> 16, FontColor -> 
              RGBColor[
               0.7019201369358166, 0.8150904193584265, 
                0.17801843830517283`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7019201369358166, 0.8150904193584265, 0.17801843830517283`]], 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.8251927427376597, 0.09974208749731672, 
                0.9127431834693527], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.8251927427376597, 0.09974208749731672, 
                0.9127431834693527], $CellContext`GraphicsColor -> 
              RGBColor[
               0.8251927427376597, 0.09974208749731672, 0.9127431834693527], 
              FontSize -> 10, FontColor -> 
              RGBColor[
               0.8251927427376597, 0.09974208749731672, 
                0.9127431834693527], $CellContext`BackFaceColor -> 
              RGBColor[
               0.8251927427376597, 0.09974208749731672, 0.9127431834693527]], 
             
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7054181721732131, 0.587766896956228, 
                0.04478759502712104], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7054181721732131, 0.587766896956228, 
                0.04478759502712104], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7054181721732131, 0.587766896956228, 0.04478759502712104], 
              FontSize -> 0, FontColor -> 
              RGBColor[
               0.7054181721732131, 0.587766896956228, 
                0.04478759502712104], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7054181721732131, 0.587766896956228, 0.04478759502712104]]}, {
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.26437178504185277`, 0.48222244786030144`, 
                0.9980454979890234], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.26437178504185277`, 0.48222244786030144`, 
                0.9980454979890234], $CellContext`GraphicsColor -> 
              RGBColor[
               0.26437178504185277`, 0.48222244786030144`, 
                0.9980454979890234], FontSize -> 14, FontColor -> 
              RGBColor[
               0.26437178504185277`, 0.48222244786030144`, 
                0.9980454979890234], $CellContext`BackFaceColor -> 
              RGBColor[
               0.26437178504185277`, 0.48222244786030144`, 
                0.9980454979890234]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.17729943209052923`, 0.026303719773161927`, 
                0.042401949626215796`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.17729943209052923`, 0.026303719773161927`, 
                0.042401949626215796`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.17729943209052923`, 0.026303719773161927`, 
                0.042401949626215796`], FontSize -> 13, FontColor -> 
              RGBColor[
               0.17729943209052923`, 0.026303719773161927`, 
                0.042401949626215796`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.17729943209052923`, 0.026303719773161927`, 
                0.042401949626215796`]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3282504684924046, 0.6094793741963911, 
                0.11925212993662027`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3282504684924046, 0.6094793741963911, 
                0.11925212993662027`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3282504684924046, 0.6094793741963911, 0.11925212993662027`], 
              FontSize -> 12, FontColor -> 
              RGBColor[
               0.3282504684924046, 0.6094793741963911, 
                0.11925212993662027`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3282504684924046, 0.6094793741963911, 0.11925212993662027`]], 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.6036941440914374, 0.713388653240226, 
                0.9167811570871334], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.6036941440914374, 0.713388653240226, 
                0.9167811570871334], $CellContext`GraphicsColor -> 
              RGBColor[
               0.6036941440914374, 0.713388653240226, 0.9167811570871334], 
              FontSize -> 23, FontColor -> 
              RGBColor[
               0.6036941440914374, 0.713388653240226, 
                0.9167811570871334], $CellContext`BackFaceColor -> 
              RGBColor[
               0.6036941440914374, 0.713388653240226, 0.9167811570871334]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.30106340029089673`, 0.45970843443912424`, 
                0.7702723902469113], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.30106340029089673`, 0.45970843443912424`, 
                0.7702723902469113], $CellContext`GraphicsColor -> 
              RGBColor[
               0.30106340029089673`, 0.45970843443912424`, 
                0.7702723902469113], FontSize -> 32, FontColor -> 
              RGBColor[
               0.30106340029089673`, 0.45970843443912424`, 
                0.7702723902469113], $CellContext`BackFaceColor -> 
              RGBColor[
               0.30106340029089673`, 0.45970843443912424`, 
                0.7702723902469113]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5456451879672277, 0.8422277215467933, 
                0.12837601363247364`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5456451879672277, 0.8422277215467933, 
                0.12837601363247364`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5456451879672277, 0.8422277215467933, 0.12837601363247364`], 
              FontSize -> 6, FontColor -> 
              RGBColor[
               0.5456451879672277, 0.8422277215467933, 
                0.12837601363247364`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5456451879672277, 0.8422277215467933, 0.12837601363247364`]], 
             StyleBox[
             "9", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.7245705021118218, 0.09892417541793153, 
                0.17085187604946062`], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.7245705021118218, 0.09892417541793153, 
                0.17085187604946062`], $CellContext`GraphicsColor -> 
              RGBColor[
               0.7245705021118218, 0.09892417541793153, 0.17085187604946062`],
               FontSize -> 28, FontColor -> 
              RGBColor[
               0.7245705021118218, 0.09892417541793153, 
                0.17085187604946062`], $CellContext`BackFaceColor -> 
              RGBColor[
               0.7245705021118218, 0.09892417541793153, 
                0.17085187604946062`]], 
             StyleBox[
             "1", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.5617335889490689, 0.4222256319019486, 
                0.3437230520661403], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.5617335889490689, 0.4222256319019486, 
                0.3437230520661403], $CellContext`GraphicsColor -> 
              RGBColor[
               0.5617335889490689, 0.4222256319019486, 0.3437230520661403], 
              FontSize -> 25, FontColor -> 
              RGBColor[
               0.5617335889490689, 0.4222256319019486, 
                0.3437230520661403], $CellContext`BackFaceColor -> 
              RGBColor[
               0.5617335889490689, 0.4222256319019486, 0.3437230520661403]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9747932421790846, 0.5309206799878152, 
                0.5760336596015216], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9747932421790846, 0.5309206799878152, 
                0.5760336596015216], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9747932421790846, 0.5309206799878152, 0.5760336596015216], 
              FontSize -> 29, FontColor -> 
              RGBColor[
               0.9747932421790846, 0.5309206799878152, 
                0.5760336596015216], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9747932421790846, 0.5309206799878152, 0.5760336596015216]], 
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.09452887817898281, 0.3715250338634115, 
                0.5827110932377826], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.09452887817898281, 0.3715250338634115, 
                0.5827110932377826], $CellContext`GraphicsColor -> 
              RGBColor[
               0.09452887817898281, 0.3715250338634115, 0.5827110932377826], 
              FontSize -> 27, FontColor -> 
              RGBColor[
               0.09452887817898281, 0.3715250338634115, 
                0.5827110932377826], $CellContext`BackFaceColor -> 
              RGBColor[
               0.09452887817898281, 0.3715250338634115, 
                0.5827110932377826]]}, {
             StyleBox[
             "5", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.14969893525992894`, 0.025201200052848316`, 
                0.6621365130693713], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.14969893525992894`, 0.025201200052848316`, 
                0.6621365130693713], $CellContext`GraphicsColor -> 
              RGBColor[
               0.14969893525992894`, 0.025201200052848316`, 
                0.6621365130693713], FontSize -> 5, FontColor -> 
              RGBColor[
               0.14969893525992894`, 0.025201200052848316`, 
                0.6621365130693713], $CellContext`BackFaceColor -> 
              RGBColor[
               0.14969893525992894`, 0.025201200052848316`, 
                0.6621365130693713]], 
             StyleBox[
             "0", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.10030370116456089`, 0.5425151801731958, 
                0.5203834071049269], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.10030370116456089`, 0.5425151801731958, 
                0.5203834071049269], $CellContext`GraphicsColor -> 
              RGBColor[
               0.10030370116456089`, 0.5425151801731958, 0.5203834071049269], 
              FontSize -> 27, FontColor -> 
              RGBColor[
               0.10030370116456089`, 0.5425151801731958, 
                0.5203834071049269], $CellContext`BackFaceColor -> 
              RGBColor[
               0.10030370116456089`, 0.5425151801731958, 0.5203834071049269]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.9803640278006558, 0.3534818919142759, 
                0.08157038312177622], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.9803640278006558, 0.3534818919142759, 
                0.08157038312177622], $CellContext`GraphicsColor -> 
              RGBColor[
               0.9803640278006558, 0.3534818919142759, 0.08157038312177622], 
              FontSize -> 17, FontColor -> 
              RGBColor[
               0.9803640278006558, 0.3534818919142759, 
                0.08157038312177622], $CellContext`BackFaceColor -> 
              RGBColor[
               0.9803640278006558, 0.3534818919142759, 0.08157038312177622]], 
             
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.24845479145861837`, 0.04133580558297667, 
                0.9883774596983335], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.24845479145861837`, 0.04133580558297667, 
                0.9883774596983335], $CellContext`GraphicsColor -> 
              RGBColor[
               0.24845479145861837`, 0.04133580558297667, 0.9883774596983335],
               FontSize -> 24, FontColor -> 
              RGBColor[
               0.24845479145861837`, 0.04133580558297667, 
                0.9883774596983335], $CellContext`BackFaceColor -> 
              RGBColor[
               0.24845479145861837`, 0.04133580558297667, 
                0.9883774596983335]], 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.3433831233910909, 0.35186063155032987`, 
                0.5971996580348775], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.3433831233910909, 0.35186063155032987`, 
                0.5971996580348775], $CellContext`GraphicsColor -> 
              RGBColor[
               0.3433831233910909, 0.35186063155032987`, 0.5971996580348775], 
              FontSize -> 6, FontColor -> 
              RGBColor[
               0.3433831233910909, 0.35186063155032987`, 
                0.5971996580348775], $CellContext`BackFaceColor -> 
              RGBColor[
               0.3433831233910909, 0.35186063155032987`, 0.5971996580348775]], 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.1654121671196429, 0.9929827725068261, 
                0.6576909298127962], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.1654121671196429, 0.9929827725068261, 
                0.6576909298127962], $CellContext`GraphicsColor -> 
              RGBColor[
               0.1654121671196429, 0.9929827725068261, 0.6576909298127962], 
              FontSize -> 22, FontColor -> 
              RGBColor[
               0.1654121671196429, 0.9929827725068261, 
                0.6576909298127962], $CellContext`BackFaceColor -> 
              RGBColor[
               0.1654121671196429, 0.9929827725068261, 0.6576909298127962]], 
             StyleBox[
             "3", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.825016972215417, 0.22133200735359537`, 
                0.09391592454761932], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.825016972215417, 0.22133200735359537`, 
                0.09391592454761932], $CellContext`GraphicsColor -> 
              RGBColor[
               0.825016972215417, 0.22133200735359537`, 0.09391592454761932], 
              FontSize -> 10, FontColor -> 
              RGBColor[
               0.825016972215417, 0.22133200735359537`, 
                0.09391592454761932], $CellContext`BackFaceColor -> 
              RGBColor[
               0.825016972215417, 0.22133200735359537`, 0.09391592454761932]], 
             StyleBox[
             "7", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[
               0.11422481568555032`, 0.4814707210301128, 
                0.4670970181698648], $CellContext`FrontFaceColor -> 
              RGBColor[
               0.11422481568555032`, 0.4814707210301128, 
                0.4670970181698648], $CellContext`GraphicsColor -> 
              RGBColor[
               0.11422481568555032`, 0.4814707210301128, 0.4670970181698648], 
              FontSize -> 4, FontColor -> 
              RGBColor[
               0.11422481568555032`, 0.4814707210