(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    548495,      10263]
NotebookOptionsPosition[    479476,       8816]
NotebookOutlinePosition[    538870,      10037]
CellTagsIndexPosition[    538791,      10032]
WindowTitle->Arrays, or Lists of Lists: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Make a 12\[Times]12 multiplication table.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"ddf51b66-08c8-424d-98d6-34035603136c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"58693a64-7a3f-43ba-8618-64ee718bd6a9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztncHr+1xW/6tuXPov+AfYhSuXdunGguKuG8WpuBnLjCDZFmQIuIkLyWKg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            "], {{0, 225}, {306, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{306, 225},
          PlotRange->{{0, 306}, {0, 225}}]], "ExerciseOutput",
         ImageSize->{310, 225},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7efe2cf6-0071-43e0-80d0-4ef42b8fc056"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztncHr+1xW/6tuXPov+AfYhSuXdunGguKuG8WpuBnLjCDZFmQIuIkLyWKg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              "], {{0, 225}, {
              306, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {306, 225}, 
            PlotRange -> {{0, 306}, {0, 225}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8c1c7650-5750-4799-b753-d5202f0e55c7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7997b0a9-0766-4eb8-8e77-729b4da137c0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"20ef7fd0-5e83-430f-9490-27b1b6058fd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"481506c9-d18e-4f40-abbb-d42c1848bf42"],

Cell["Make a 5\[Times]5 multiplication table for Roman numerals.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"289bf582-9e60-4bc8-a3c5-80d64aa07fe0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"85197fa6-8e75-476c-b726-f72f0a0cbd01"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT+v4kYUxa2kSZmvkC9AndZlKqSN0iQ0u8ljlebl6W2kCCmVOyuVOyuN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            "], {{0, 91}, {124, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{124, 91},
          PlotRange->{{0, 124}, {0, 91}}]], "ExerciseOutput",
         ImageSize->{128, 91},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2fd61bbb-9a2f-4361-bd8a-81d28e405a47"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT+v4kYUxa2kSZmvkC9AndZlKqSN0iQ0u8ljlebl6W2kCCmVOyuVOyuN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              "], {{0, 91}, {124, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {124, 91}, 
            PlotRange -> {{0, 124}, {0, 91}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bd70a4ca-ae7b-451c-8dad-f6b77789c4d2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2afab326-4782-4fb2-948b-f8dd6f82b47e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1101183e-7e9d-40a5-b467-78ee2dab58e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3c281862-8a8b-4abf-993d-a67e5fc10b0e"],

Cell["Make a 10\[Times]10 grid of random colors.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"7645a2b1-0cc4-4898-b1f9-23c25c6a4b97"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8d411774-6def-4919-8d1f-e84a21b8c422"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztl0lsVQUUhiu1gsyTQBkFSqWlUhyAIlPbCBVHZNBQkaHI0AGEFmgKqCBS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            "], {{0, 187}, {190, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{190, 187},
          PlotRange->{{0, 190}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{194, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "15e1c0cb-0b5a-487e-be1f-fc2ac5fde6f8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztl0lsVQUUhiu1gsyTQBkFSqWlUhyAIlPbCBVHZNBQkaHI0AGEFmgKqCBS
BEWGAmoVaCmSgkGiCzRORCNxColEo1HRoDGBBTEgIsEgz/pWNznv3HMWb2Fe
vi/ffXn3Jv/u25y+RY9PmtcsKSmpokXTz6TZlXnl5bOrJrdvepm6qKJ4/qK5
j01YtHTu/LnlOUXJTR/fa3o+bHr++x8BAAD43zO4y2RNc9t1dLGmue2cM0rT
3DYk12ia26TClzTN7axW6zXNbeqOhzXNbWVho6a5rZ8xW9PcHihN1YxEyxnX
d5XUWU7/R3ZJneX0nlIodZZzMeWk1FnONet/kzrL2dL+S6mznPRTa6XOct5a
f0XqLOf8pq1SZzlX6wdIKYdywqGcIJRDOZRDOZQTDuUEoZwEKIernKs8JuFX
OQAAAAAAAAAAAAAAQHx5sCRL09wWTr9H09wumFGqaW4nltVrmtv8F5/TNLc7
ylpqmtuZPYs0ze3W2uma5nZ1l3RNc7t/2GbNSLScFXvypc5yqjcukTrLefX5
OqmznMqGP6TOcub8ekLqLOfU3vZSZzkvZNRIneV8f3qD1FnO0b4jpM5yLj/4
rZRyKCccyglCOZRDOZRDOeFQThDKSYByuMq5ymMSfpUDAAAAAAAAAAAAAADE
l5o9mzTN7dKh0zTNbebgOk1ze2enXZrmduXG+Zrm9rr0HE1ze9e9nTTNbfmI
lZrmdvnihZrmNrtyrWYkWs5Pv38tdZbzxgPVUmc5uePOSZ3lzOt1Vuos552v
aqXOcq4fMVXqLKe0vJfUWc7rU9+ROst5s7FB6iyn4K1PpJRDOeFQThDKoRzK
oRzKCYdyglBOApTDVc5VHpPwqxwAAAAAAAAAAAAAACC+bFjXUtPcTsqfpWlu
H0qZqGlutx9sq2lut2T21TS3ZQvbaJrb1Nv3aZrbtCHPaZrbbrV7Nc1tdvdH
NCPRco5/2k7qLGflnC1SZzlrWlRJneX8dLWL1FnOd2NvkTrLaWjoLHWWk37/
X1JnOcMmnJA6y0k7c0HqLKfgpg1SyqGccCgnCOVQDuVQDuWEQzlBKCcByuEq
5yqPSfhVDgAAAAAAAAAAAAAAEF+eqd2haW6Ln+iqaW5H1XTUNLfbm6drmts2
aaM1zW1+752a5nZCyiua5vbGtcs0ze2+3GpNc9uwt0IzEi3n2OlTUmc5u9/v
J3WWU3iyp9RZzs+tRkid5XQaNl3qLGfOzb9IneUsbHFG6ixnyLHDUmc5l2Z9
LnWWc/HCISnlUE44lBOEciiHciiHcsKhnCCUkwDlcJVzlcck/CoHAAAAAAAA
AAAAAACIL62z1mia2z5tXtE0t82ryzTN7ZjsUk1zO76gvaa5nZfXWdPcdmuz
TNPcZvbJ0TS3E5ObaZrbu1PqNSPRcjrmfyR1lpPd6YzUWU7LzxukznKmF9RJ
neWUlHSTOst5uai31FlO/86Hpc5yxg6eInWWU5mSLHWWs7j5eSnlUE44lBOE
ciiHciiHcsKhnCCUkwDlcJVzlcck/CoHAAAAAAAAAAAAAACILx0GVmma2655
fTTN7eKxHTXN7W3JKZrmNitpvKa5rbjjNU1zO6hbW01zu2/cJk1zW7Z/tqa5
3Zl5UDMSLaf7qCNSZzn9iwZLneU0zuwhdZZz37UtpM5y8pNKpM5yDj18Seos
JzftBqmznIsLvpE6y9l7eZvUWc6pMVellEM54VBOEMqhHMqhHMoJh3KCUE4C
lMNVzlUek/CrHAAAAAAAAAAAAAAAIL6MLRmqaW67VgzRNLe1DQ9pmttV28Zr
mtuSyTM0ze2tm+s0zW11SZ2mub1mwFOa5jaj2XZNczuyqkYzEi1nxp6JUmc5
/Q7dJXWWc/rPp6XOct49WSx1lrN71Saps5x7vjsndZbzxe7zUmc5zXKOSp3l
jEn+WeosZ9qRk1LKoZxwKCcI5VAO5VAO5YRDOUEoJwHK4SrnKo9J+FUOAAAA
AAAAAAAAAAAQX9ptG6NpbtNm7tI0t0t2rtE0t+tW1Gua23E99mua235TqzTN
7QONfTTN7foBz2qa28asPE1zW5KcrhmJltPlx0elznKGbz4rdZZz4NePpc5y
Pnv7vNRZzoKBf0ud5dy2+ojUWc7yK9lSZzlf5hyXOsv5J69I6ixnT0qOlHIo
JxzKCUI5lEM5lEM54VBOEMpJgHK4yrnKYxJ+lQMAAAAAAAAAAAAAAMSX53tu
0DS3mdmNmub2tcUdNM3ttNQBmuY2o6CVprktnjJI09wOGvSkprm9rleKprld
tHWkprnt0bqHZiRazonM41JnObnjr0id5VxqTJU6y1mXPlzqLGd0aQeps5zd
T+ZJneXk5X4gdZZzfVZzqbOcfT9MkzrLyeiYIaUcygmHcoJQDuVQDuVQTjiU
E4RyEqAcrnKu8piEX+UAAAAAABDkX3Yxic4=
              "], {{0, 187}, {190, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {190, 187}, 
            PlotRange -> {{0, 190}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1e7a1f54-2559-4448-bca3-eaadcb5d9129"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3d9aa51c-9f9d-43e3-9ef8-48594aea30c3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e72228c9-f450-457f-998f-56d872484a4a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7df24551-6f67-4c63-8e8d-a474353fa59f"],

Cell["\<\
Make a 10\[Times]10 grid of randomly colored random integers between 0 and 10.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"aa148f43-a8f2-443d-b1e5-6cb2a46ee47e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"785a6af2-d7ae-4fe8-84ee-d1d43bc44491"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfQlwG9eVbSY/Y7mcmsRV4181lalx5lc5marvlOwsk/nlfNtDS3ESOy7J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            "], {{0, 187}, {209, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{209, 187},
          PlotRange->{{0, 209}, {0, 187}}]], "ExerciseOutput",
         ImageSize->{213, 187},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "25300295-31d2-48c9-a6ef-3433a356c911"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfQlwG9eVbSY/Y7mcmsRV4181lalx5lc5marvlOwsk/nlfNtDS3ESOy7J
dsayHFkTW5ZlOzTFyJJibXZMWatlWRRFiSYpcxNFijsp7iJIcV8BggBB7PtK
7EADaDS6G/ivsRGWRALvQZ4k8/vUVVcTQi94ffre++67777/9fruF978+te+
9rX37gWbF177Y86ePa8dePF+8Md/5L339q68nW/8Km/vzl079/yf1/8H+PAG
+LcA/jH7kVuBhagunOoPhV23/dfaoM1io0iQELEDhzmYsOu1ElGqWO1QJ0hB
0OKTDbhFAz6rHel40inwur3hlA+C+l6LuGnZaqQyPomXa2hvVPZwvc6MD8G0
mg6epFfrzvyQLx2+wOm63tS/oIF9cDH4gyY5EUz5gbTTJ+G4BCMBdxDphAxI
X5gk1/6Kzk/8yJMQH6WDOT1e+q+VT/5jUur5XoiDtdWvnN2SkypF1XyYq8dB
mXsMDS/pG16KbZdFCqjDnU2qrgeEQLhTocRnAe5GYezDrgdECkUGrKM1p0e+
vo7z9fVDzPaAVpPBIdrB3u+UdXynoovZdiu1ULcdIXXFT/3o59/+0QuPMtuT
PVAPLhIUlOpr3wVi03oSn5lsTe/GPtTX7vPYoFmHa2lxJ7nQQqr1a32Noj4C
TMNpknmxQxs8xIHM32pwkcqnK3dUGkHzkSSdjtu3g6SCJBU9TNu88+yWnSof
7BkYBAUH9Q1lUbr4XP2AdWVQN+LmmGb3SAC7BNw45bwchoQyBVB6gSnAureW
6XQnMRoOAKY1uplmbOetX8fJT8s5l+YQYBrPyRyyMPGTso73oBS0mfMRYNp1
BXN478ENP//2gTWf860g5H3W/gLALoc+TrmQnCGh2waev8kKWNc9El77FLcB
UE7Lo5ZaSK1pra+FyOc9xKV4k4b7o/TDMr6It+gfKyvFaR9IOpCyqi05VR0y
1ON9gLqxPUpXpm942wf9gmKcB4T8OOXCij3Cro0GIvqH/aq06wF5WoPPFeWs
GyqMW0dfD6BfhTONxtfyfl7WdT7+knl7Af2mbJm3fGSh8PmfP3opblCN/YB+
9WKIw6NQm2rftccpR3n639U3tcYUDs4/pa/9DA+tdfBq0LWT6vSUO5eg3LiX
+FGAztgx8Op2AHv6r60fvH39TBFXZkXknrVn/9kt+83QSvIO8E+/rW8ohm4q
3H1jhXKk4EfCG+fdkfgfhq4HlozpHAaGcpxTccrhIzmcrxda07hnDOU6PolT
LjBa0/GdYTOER8dQ7tvn4o/KOf7qt39UzoX06EJi4wrl/I5r7xonxbH/oU2t
+trD8G8uA206yoXpa4wXFzoVIE/F3LlA5lqOtJ55+sr+T2YGern7GaeucRbF
C9a3bMkpbxYhHHkLwq4B4MtZBHC+HINbKLdxhXJElHLmdJTD3bWMIzdZUCIu
WM9h3LkSa5pjQs6rjCM3eHRs4WhFB+POjZkh1BSuuMY4cq+eqi459cK3GXeu
mgup5W6hXNMK5ago5fxfDeUAaHo8EPrIF7pM0F1Ay/kz13KpcCqe+8fKoik/
9IEWDug4jGtQ+6pJBObNoPvQ0wHjiyaQtZYDcLpHCvkHDvBLRiztQMudTqfl
AHzO0eHpQ93Tn8sNHUDLDcJoOQCXYry84KOTBZcnp7qAliv+K9FyqQjTl4CW
C4Yzt3D0yle96q2AclxoylmHj5/dkqdF75RHgc1bAN/aqxCNM+llfDlB7Oiw
ivHljLE/nFfljC8Hc17cWgi0XLsP4piQ+TzQcgtexNvHuZeAlus1Qh5Oyxlf
zhR7ZJSX8eU6Y75RkP8Z48shOUppfTngv/lCpwhaR9KtXsbCdmV+8p73Kp98
mjOrcNu0utL/BIb1yoAR+i5V1a+cfa0qAHtYCmjPuDkaHnEohQGD0KebDwYy
b3zKKfBaR42gizp11WkXeL14zJgKZzu8foX95gPC3qPplQ8ZGMmfLBhxahTW
xs3AsM62p70Dyjd6ffCo3KZdNjfVAcM6CqefSev4n149NSnWqbitu4Bh/UMX
DOGCQZM8oOoEXVQrfx43yUOhmDF91yqSk7ZZc+27hpvzMLfDgPCFgajaSYWC
2SFX40J4BkvG5UKXoX41plUce3ElKHd1CiYql4C2bufZd7KiXGBujz5KuaTY
dO5MD8bdnAeSIThG+Fzm0Zkr5PFPXtC5M3iWZGBqVzQix3h00yWaDN48yjfV
Go3IMR7d8Od2yJeVtM68H43IMR7drst6KA0XEptqkyE4Rux6Rtf5uZ/FP2lr
IGCVBxleamGCcklZO1QSDrvoMKI3ReK4y4vfje7mXxZIbwh3rvqm3hFe3Okk
4JoRDzh9kIekAnO6QOMjH3476KCH8vthI3IsWLBgwYIFCxYsWLBgwYIFCxYs
WLD4K4GXEgooDDagG7Y5fAprQhw4wkgp6dKP9Pc3dg2JrVmENH1Gyc328e52
idyKfpI4vBGTIBKEj20HrdKZjsnhXqnKmNkBZEAhcUsSojDAJyRQYVpP06Zw
GCWXIRXOBdlis0Cx4MjyPDbuzdnaVhE3TYoy1XzA+9DXgQSmYXOPqJYbsv29
SVFKCbjjvZLWr//wuaTUSlBYh4kbT734N0df/JvYtqZbjHCSOAQHwrV/w4gW
rikoK6fknb8/+c7ffxrdllwZzYAEPvWOLbytSXnHBZUUHdaHgiVEQkLUMtQN
p8JQ1VG/oaZ+cw3YdtdBJRd/CeqSXRfu+/GFR34Mtlcr1hqipQZr/fs2Acrh
PGjKXefITi2BlgpTNBDYe3QXbgZM+0TBEM3d+NkVMZKeM7VvO/riqWgWt3f4
T4B1p9AmnzCQ14b7NzGU08NSrrdoz1FTlGeCKxtOvrNBmj6nxqfN3SJsljDD
kyQJkb8TQ1gWIkZjI1N0qJYItiOOUmGa1g01HVUM07RlDfUbWsxo1sY7c/m+
H1eVMExTFD5/4b5XdWnOI8aAloOmHNHQK7vuQPytpKkfaLZTM0gTHr4EL5bI
FMJ4p46+mCPJ6pRiBMqlAuMdzYxyduXWLVrF3RidpkeJYC1aTnZINA2Um8IW
/cMsBvtTCyiZZITgMlBuophfY7wB9jlrp4ziXBTKEd5TwJ7eUJeOa2oFVg3k
aLB3/ouv/zB3RCLvqWmouDYkdt2FxpdX5hx9sQBtYmEcIS4y5QIOo4bXdBnY
1k+vps+N8QmFwJ7uOCg5WqCo7vBC5eQlEfbQ9CJjYUOI7oS9o6t+w0icHKSt
D5VylqY/XLjvXHzqDqls+IooRwdqOfLi+eVptbWYcepUIhid7F28EnPh3vzo
/LanwM4OTna+P2VoB77cF+1Z+HKRbCjnvXGAceSA9CxlcDipUeS+Ji5vXh7u
EDNO3XuOjFOuEsBJIubLVVGoPQgDMKabpxMkC/G21bRWZdj9+RLUwJg+cjnx
/PGxnB9fLllc6wA0yn3pDO4jvbIGE8SrGqNcozJ2iDr/h89tqllCvwH31Oeg
+/B+bTapdwyy0HIAVNDKu/YqYN0MTFNE3DP8rVuU89CciwKnyWbGsCI5OIyW
2zye8AIcAxtqxhfgZxPEtNwjlxIeja7lvh/3r50YTwoYyglhcyxTXi3CcxRQ
zgLRzjhDua0j8fvylTz13PqLAsgbSMA+9QXg265C9I5DErSAoZwJtinwlc46
JSh65++vC9KSllzhiG9+AVBuEY1yACag60gKxYUNyYAvV6eONZxNBny5WRGS
LycGvtxGaexHW28CX25YsJphxSmhgByrAD1Wf90IKRTQGRvH8SnZfo5B5Ao6
Pd6WUWBY5dMY1JtmLgCG9c0rYqud2/oJ0HgVSH4/YeF8Hg2P9I1z1UKuhDdl
yiSR9w7AmYicqoKhHH+E2c94diKv6O9P7jkoUBkxh3bmyvNAy42m67CZT2/h
5V50aCxBg1B9GBjW15ZhXliavEYQE+EwuMUQTXYCyiHa1qj/Vv/HeafNwftj
Tf2GXkT9HvXfLuxqsFl1Y7t+fOG+A7bVvhk1qd4UCfAyfcH9HnflzZWgXK8J
MirHdFrHtiWCcgeuIao49dVNR6OUS0obmocQM6mpos+0KQgrt/XED2OO3Ml3
ftgznn5iI2mYke1dCcrp5iE7PWE9SZQn4nLlJIXeZwrKBK0bmKBc/YYGsQp9
4hMubr18HxOUu3Df8/MK2HncEKBIyktQWYS/Sa/L/d8jk50KejGPF6opwkEf
4fNlkfiNh1FnEHwJZNCP+RGGXG47D+bzuv5bPEwWLFiwYMGCBQsWLFiwYMGC
BQsWLP6bgQz4BW5fQvwa+KCu36qROwIIwWDaKDMKRAmRwRVUT0EIjwRSBang
aBS4n+Yo6XY1DV0ENYagwmzSBjPOXCM9UzZpo0U6hUGN9AUVcrPGn3IVyjcy
KaodlAisUD+dVtmDeiIlDk1Tk1qsSekTIQSnSUMkIP6SkKsNZHjVyq/xFEnJ
ccFwxzpVVnk6D8hNqSf9t29F8Pym6u/kJKUBtgxkDKGweIoaThVJGGnUxqgl
1/WsyGkD1NGKRc7/rK8F8ok2o0wMp3dpvbDlG8KW2DbfklHmlmJw5L7dTUBO
C5MpM67TR5piH963u7VDnxHrVEpnDmcZyAVL8nmHLowsxz7M4Vh73JCss++K
6F/8ktiFq3zVq1V9TWgVMIkNYSBw13EI+jh1RwHlJpUolPv8leoX65ALqidB
03GJ+MILU9QcYkKGUU2un4slhNOnB8h1AzTUmgIK/tGBNkC5zw0ZUU5h6v+G
cDqamhaslQPWTWfCOc2ssOBiN2BXiThOOeMsQ8ImPfj1roOAdeckmTSk3uD9
dNYG2FVljVPObGBI2MEwLXQcsG4apiYjA5KpcBlrPmd+RJ8fWVV3WZWKr2n9
2YyKqRtP542hUM77SU7157KsC6qnnHCRUXHZZswxGJmDpVwUlhfqa89nRjnA
tGQtMadr+hvCzqlMH4J18+6mwjjl6I6LTfcd4cbuVNzXd9/uAXGmOp7YyVku
jVMu3DO7nDPiidkZmdyew3HI0EgRljMqziVf9QsUVwjsqXKbRPemwlLrDcFf
hhDXo1EO070I7Omm9vf2dx4t5Ylt2XIPZ1ScMNtBbisWHpExhnWXBPrYkH4j
BOVWwNV1fkM4kWkybtCYs0K5YMn+ppzG+KG4nHvf7o5MCzaT+CsrlKOrhpZf
SWR143YPsK1z0JlBUbj/FNH/KbKGuQwrFKr1YnPFsqtWzDh1mxywpEOmHGk7
+srVty/M9nJ4bzNOXfNUVhmWQTk1LIBXTF8GQeXEfTmKC09eJMqRASnw5d40
ZZyFfwvljqxQzhulXKYFm2+h3MgK5bAo5fgolDMwKs6Z8VwAcoSv+JoSYgmq
KJAplwqX8ic51Z/MoaRAJ2CeoYZN4bthpkG/tXAEsI7OpABrKhAoF9JvA90H
6SLEq/KXrOVCNxnKBdc27Snp0NTUAqAcBkk5Ss74choEtqQUVMc0PweU46NT
Ltpv5WU3QTFFv5NWRtFNQSo62sT4cuaM+8tB/ZuAb0tzcNOMKDPjy8ljV6F7
GF+OH7tRRd8A48tlGHOgg4wvFy9SHOYwvly8CKxK7mB8OYTX1/tpRP9+ZM0D
zfqv8VQFjoAxGOSqtcCwrl8mMresQatGblzqBD3W/rF5s0buhnkvOj6o/s4r
g1Mqt1WvO58HDOvVXjO6jnLRU1OUFD0iB55Afg+5fpqJyFk99OkhRstBTDIN
KcwmgZoLeqyHFlRis8mY7lZwXLUtGh4psZsEbtOUS68Ipf35IYXcLJjngy7q
wT6NWG42BmPGtKlgxGzVK7ftbnqkKoMV6yJhlT0oMnlBF/W4PCCzB81kzJgu
f6oO2tz+PM7yJj5SL8y+K2K4uvZXyOCITLMSlNN5YV44QtwYDcolZUwJoaYw
vfLQzpWgXOVcVm5Y9pSLGC3Utv5EXK6f6oHR9iH9C9GgXFLOG9LoOoGh5xtR
yiXllCvdUw4aN+9OhuAYKYz2TrldA/FPPp7NKJRP4js5yRAcI6XRxbD4Ukf8
kzG3Hu3td+RHjGkoF0OY9hKU989SB5vEg07sLmRA3zXgRMSJ1lX7cwL3B5ye
u9CMOEG5cPov6HGwYMGCBQsWLFiwYMGCBQsWLFiwYMEiW1AqvU+PpwSAqdDU
or2F51xyQYSe3VyrrNaohV9vOgbb8sisvEO0jF4VOQaacviDigCJniwXsutM
ksVUcdphk0kwjWDRkOni0ZTVrZM7E+K2IaQym638HlnvgEmRZcqWUe7pGLT2
CH1ZnsclHhT1NSvF2tv/S8UzPF2qAFKsTLZPsLhaEfvw6VJl73JGrLOUiLrv
5XWv54HtcAV07pF6aXfRwIaioQ1gWytZgD08CdzfqLSdUjuKwFaHpa96dEeY
qjfXvfzDVGmohlh5WdP08St/9xiQy5nmYOEN08W5k0n5Qgw3XBcc4eU92bNt
6xCzfXKSg8oWmnNV/s08yVNHme03i6FfsySMbb9rzPtu477vgm1vJ++W/9WL
bZ91aAC7qjVxypnFDAmvLwOlFzwJWNfiTP+ueh0D9/IGS5gWNhUudN8rhFu6
gZgrH9hQtcQwTbG4rWjgTR1iGqpGaztlxpmEVpoYVdqKvIjZASQdjCfEm5q3
1b28zQCTmGLgNF76w2uAcvVrV49cAd46W1yg0gF1R9EUdD15gr+1Z9sZLVN7
32WqebJn5yzaMJ3f81SepGCWUbFOofGbedJMc59uPc90R953u9oYpukaf9GY
9x93Sqjxv1WqKI9TLtzboXi6ejmehzyrfbpUJ0v30pECLVBu2tiCA8ZlsB9b
JTxDELYqoNxEsR/o44B9zjLSfBtaobadcpDR8eywRm0768kyaY6UdL38w64O
+KzgiHTf3z1WkynlPLWTxa1u1DJpxCKg3DFDdJ4HLdmKTjkvoNzB+ejDprCn
UCkXkpcC5aaMV9HsBfszt8+SC2HbVyhHVX+h2H4z/h1cv/x0qWouncpyNoq7
703kjpDYGCTlLMo/Fg0UxzM7adU1ZMpFCJe7SGmv85JYAFhYe2+Wo9LOnvy6
l/NtCGfB+bmZUy6kLgD2dLruwkJjhXxKjcNyz351ZNuT/cdG7MbZpWNP9pzX
Ib5oRMVpyTf3qTlqfKpT/c08LcK0UuZuBt9pzDsTf36U4kYmlKteoRwWpdxC
OspZgDFdr028W5QohzdQAjG5Sg2M6VDVSg3t4Q3lS6LMD08FGRwAXlxMLMEs
6zfqBl/+YXvzmtW8VwMU5WhLxWzpWen4hGnqLOPUVQsh1ZRO+QnjxUVlh+QO
HnuG0IxoGC8uKpv7EPtfRmBM95UmbCnOP/LdjrbbJhXeFS23Xp34ln/iXh6P
C9FqjJYbKku4S/rmgQ19y0iTH8h5pe2siyQiYbfLexn4cu5sinpa+kHHga9B
cqKhKJcKQrp3srjWBuE74vYWwLQmq50ktE3T+8F+jwdFu+NqC2BarZwg/YHa
MgXY7zChZLExWm5fUYKv2sG8706Kb0s4pHyML6ePzykbZHy5uPuvmtUxvly6
50aKgS/Hj5erX7YCX04ogPHlHMCX2xxftss/Any5mzYUBRX0VyvtNxPNRFjt
p0w4uqJzDn9U9/KbJrSKueQi48utWgn8FqS8GCHFIUA5BwTlZEuAZiWJK7mL
QNd1AUUzizsBzZI1kUOnQde1ESVXNqQGvty/aWJ+knMQ+HJceWo70Cq9b0lm
BV3Uk7Memd5nDsWMqeKzBZ9t2Z1fqnixL4PpM1H/rXuXwb3sF+3idd8rgZuz
HPXfiqaabX792NSGooEPV62hvSYoAljVsw6CuThFzqtsp6wEenTOUL257vXL
8IzDNYJFyUgt6LEW1k4oBIuWdGpyRFicO9st9DqdmLphHhjW0gk/hHI2a0uA
ZitSSjAyqDJcY/ZNKBWqjbN6oNlOj2DeIK2YNzP7sAY+hqj/1niuzuXU8s99
tzFv75d0fQh7qzQZgmOkPOoyLkzq4p9ctegz+/WE2DhwLxOU6753QQG/HBXu
6CgfYIJyRQPbeC501eTD6pK+nMGnyCa92VS/re738JTD+fuiQbmk1KSrduHH
pKXclaBcpw12ihw5KTyW9OX2C2dRO03hkTZ10pfb1Ya+rlVQ3dyRxwTlGvN+
IdFn+jRxnHT5KLiLkiTuJSDm6NwCGvMRLjz7uYBhgqIw6s+STJ8FKAr3hKA7
qyuggxjuhl5H9w73QXs9IS96Af7kebCA3xnMdnlYFixYsGDBggULFixYsGDB
ggULFixYfEXwmzTKZciq5pTD7pHpU8XvgKxDgzux4RFHzyQmhat3lQCmEIi0
qYnfpG2s53pdY6/QCD0uT1MGPChJFYKCjo3SASdMRQ/ML+91CTh+J1I+QzC4
NGEa4ViWFHejVm0kJON59M5sgvJ+Pmeko2mSr00zkmKaqj525iCQdhnceK6n
rnp+Z2mqLNRlUmkqjrB5VvvEbtUTu9XRrbZoHmroQNF44qF1G4F8upL4rf80
Z2Psw4fWPX8dckIA7vm90fpyqpg8q9X0vgMoc49rfJ9jeJ93ObNmpPXWxo3a
Kxt19czWIoGb/UFZls9snTu4de5P0e2ZcluWIf+5ItlTDy5tOoO62DppKnoq
78lv5T33KLM91mNa47vLwsHm+jOAcv1K2BQCKhykwtGECE/71fmdV10wmdth
86Tm11Wx5WI9RUdUTxzBYEZZtZzmY/lvAnaVJZKFTByGhM3MUK/+CGDdLthc
zVhNeOYg3Pue0fpeAOaNp8w3MWmLa3gfZsuoGQn5CcA0F5MJSroHntde+RPU
aDplsZzYITNEfyGvnH9wK38pi3qOuGIZ8A3IzlLEaqhmThlgWocCkIHqObjv
yW8V69IcoS0+c7AbmnIJUCZwr0vdaxF7bZATVbCUi0L20rqNF+KUI6/nb3wo
pyp2Dknt7ofWvS9BmzoSVlisL1tQpu1Q2Og+b2aU809s09aXxV8KNwfQz2FB
TGzwzsqyo1zwwk+XnvqFIu+nS78tQqQcv/DIk482xl9+4ySg31XxmhnthPRc
FpTz32iZ39mCIWl2ymb1TwzqgG3d1wd9AnzhmRXKYWXrNz5TGJ8mhguqHlq3
bRrpBxG+AqO1gEDJEPDDUe5KcZxy/kn9lY02PbRH57cHlLOG88C2HtUjF70V
VSqAfuNog82/WdqUDeW+dTX+A5zzW7+VV8pd81RZUc4u31m62I42EdVvfZlx
5IAs8+F/7C2Uy1mhHBalHA/lBxlsQMV5EebaRKAoR9uaGUeu46x9+qzuCuPO
2TNO+Ekg1JXLOHJA2hYRyzCSWhvg2/FepqNU94ul35Yi6kpc0cc4cq9WVpZU
Pvctxp2rXHtqczaUW14EHQeDDr1mahh3uktPA9a5dJB67qvQcuQw6Di4Q2h5
PBCUYy5lm7TdPGG5WYVpeoGWs8JrOQAqGJypFgLWTRgQ9DJZ9xvGhfvwjKGs
SLuTcedkVYOI/V+XYr60oOxYQdvk1AjQckVrazlKyfhyKFXNI/6x7vmdDR6U
R5Syvhop1zyx2zILqehIEePLxRO/yT7Gl6uL1wavfZ/x5RAWTvGfM1oP4Yh5
dzHKQTcjrS8DWs7thrpdakWvke4TW+ea5hEUHT1ZZywrNZYVAcrpd/6UoVzd
aLYhF5zbCLRcj3E1BUKYNEr1Uh/osdaPC3QapR3yxl111fPvjiEkCbqP7Fb9
utwjtZI2k6voY6Dl7KrMiYsrBCLhSB3ooh6pnZQIRCY8Zkw3HmsXWRUjr6/b
+FjBJPxNRQKe3xtt9fDBKYqJyAUM3tF9Hr2G2U93ijA2ae44i1n0Qf11AzCs
fb1QNJ85PXdwh5SnCHjtvonyBaDlBtFmA6bcUdSwInZhSOv8B69WTopNKu7g
DmBY/zCyKiUIaXE0KJeUbpiq5gCepqvz+1AoR5vF5tz9MUdO9cT+5QEYbxBf
eGldMgTHyIVo4jev4v34J5vLtEi5skx4BIFypMI1zATlkoKl03VhbM4Ujcgx
Hl13FQF5ScLirDvMizlyB7fy2oaznEoJQFb9YmlnJTLlhPujETnGo9vVhlh4
4b8EYdxPuvx3MX8c97qczruQmv1fA8rvIoPotWeoYMjrDv3l5H1jTo/rLqSz
s2DBggULFixYsGDBggULFixYsGDB4iuBG9epfEY3Qg5y2Cog2wdCPQLKmMX1
nTLpvN6bRTVunzk42uvv6w0q0ao3xUCDwzFpQpRQ9V9Jv0bgUCREk+ngk5Yn
aambH+KhFE0CMKnk10dn+5bg0+5X4HOFHamCPsKKWxeGr9/o7luQrp05iXPN
ZWc154s058F2PABx7xTN+TCw7u3Auj9Etx8SI2hh8LnWV55+/wcvNs4gHR2h
pR2O7Rvs2zfEtu4+Gdp5mOHmdwakryVl2AuRyOOVHLl/dH9SNmQyts8rbX74
wcsP//Qy2L5RCVsGkxhsKfveB+efOcdsv1fBQ2NdgK77OPRGqjTRKClzlGno
yGPf3/nY99+Nbo+cH1t1UD8welZzKZZsJbMC7vVmPsZG0T3vBwpi+cYzRM7b
gRwB/MAVbmgBfAPyVidExftUhDp327fHch0x33HAumLkis/mPQPKNqAn6TBJ
h+HGzLyyo/fP9AqYsuoUkAyOwFTPPXh5aynDtOmi2ocfvCaEIo1f/swH54/N
MwUlnUsD3/vg0jRijiZJxSWyTF/8OHQqXQL5nUGZ+vb96nhsaHX6/DM7H3tm
YRUmae2VKzSj5EDXcZFKNXnIAiTKmYo//MHTx97I//AH21sRKQceHu2L84Pm
F9u3bwsiphn6ja8NmJVoU5ysS/vvl2kgaIoLx4FyG4rNbDOKwH4xlKLyqwHl
jgijP5XSPYNOuSSMNYyKc2R5FgDPxPE1KGd2XgGUi5tvSl2uOd/tg3tg/rBR
RjYeB7YVr4X90Uu9bwD9NmgxtXzygxfRKbeC4JVt9u1nEcf0fctKYE/fmdCe
nNLXyv0OGO75uTPAnh55lV+8a7HlqiuDRTOUzW0PPxhnXIS05sFSLuKpKj7/
vY/rB7W26Rv13/ugXZvd6L6LUXHlSJMbV+CzmWQTLUeBbX2vflUahURAs5WY
b047Bsqj7lw/HOW8LVFHDsg16rZyxGuCtHQCvp2cZlzN+mM/2N6Jlvu9grCx
F/hyrk5UX4506fcMaSoljlG5hnHqRj2ZOzWUYvHoo7yGCsP0VR7j1D1vTZca
zAPG9KfjCU0Qqv7F5edKDVD3q51sZry4qGwZskAdexs8XaE3vsiqDwiANb3E
OHJA6vhrkYEgdOPW3o7lSW1Q1wKv5SLM3ELrOLENsG4YYtowVv8J48J91Fhc
3nriLcade6Wai15JPuKec4Luw4fN2dfjZOAxyl4bMKZdh+CO8I6O779/SZTm
BWS03E9HEl+y//HBy2d5EFYC144CptWrPKTfUn+lEuxft2Sh5sLc06E3uJD+
6x1B4daxz18HrLuZSc5ccPKspkwFceN4SmqU4P3AuhoIRYdPccrLO8vLWwHl
zr71IUO5+gVUyjnmXIBv+WXZ2RZ6xRX1mRWAcqLMKUeuUN0/NQkoJ03TFLgY
+HJVY/HlYCTAlyuH6T9IbgCadSWUpO9T0HXtUGd++C2I9lvPLSMfzyCFDKRw
32Pfr55dpQUo4+DyrJUiAiFGxZ21QCz2MR4E9vTADGX0hDXDxGag5XpotJ46
GTWsEFPjUxFeHnFGwyPY5AKxuBDkz4XgJhHEYT87IN0z79H6COOy6SNgWIcc
ma2dB6ArvX/0aIHVYAyYuZLPgGF91JB2dZyo//bwO3Naq736ncsPP9gJ9b6Z
5ruAZvt0UocRhEJ4k9lfQpwPCKCmDn8caspmzsPY4e/v/NUH01KTx6a9eX4L
0HLdqlXIQKobtIwLx4TmjKNQ1QGCNPcLfP3bcV9u/TUScYlAYGSrj/3grV5E
yhENb9qjlEuKl480Vcpo1B1cCcpZFiDMXMg8Kji1EpRTiDIqsYKJ5597kAnK
PfxgbSf0+pbUWHd90pfL7UaYWrSC7CkXNPHK3/lZzJHb+djP6gbSkCFA+jAK
cSIkFfZ6wt6/nFzoLBEOEiEf0rRpZvTCG/RDLpNI4k7Mj543TxGY14chPrq7
DwrHPC60OfQsWLBgwYIFCxYsWLBgwYIFCxYsWLD4ikDqBB6TNyXqSQbne8x9
jRb5qmWa7gDLomWkU89bhEsGIMO+L4c/aT9lclLLyPUsKL9GJO6YWOzJKqEd
3IfXoJsZkEwM25wI9xJwKtTuzFfyDXpnZbJ2kWzWilx0FdMLhebsS7D4nBGt
JuLKpumoZalatpgQ6a2PUteoeHfdApDaqWTk2l+bsxD78N11whFFRu0mbVg4
uH364K5psD3fmlF2X4ASLuHt83i7ikoOsBBmonM++uE8ftMFH/oPWGqPV38z
KSNpl3xeBYSmo/3AS0kRaSBY5xxquL7nBJC5xYwSq11m8bMNbY83tMW2R0TQ
szb0zYff+6cHgdRPwaWN3QpBZ7j8Uri+ktlOQdS0/zICdb84sfPfknJe9OVm
MHGMlflLgF2t3DjlrByGhBxmxWZ/KWDdrgxSYXz2E9unzzQwTFu6wj24fV6Z
wSMKUBJNiLuIt2sSlCMp7jzeGR1CD2gA6wjYVGhndwNg2kETU8jTOTFSokes
6OnmHgdM+8zBNIlb0lhngxlIcs+NTpdcApRbkGREOZVg4PGGGTOzG2zqB6yb
geWcebCu5r3fAMp18LKgXEjPME0VVbPm6XB5ZQTxfQ00/ebEkStqZlljklpl
GWmsYN1CQ5xy4ZH8hXdzdLGRbHWt+N11UnW6SxNSFVBuvJhuWzaB/bbFDB82
rU3Rcq5Qz3xQFtNtQXJ8Hh+HGl+m3B1As3VoUMu5J+/JNgA026woi1r2Ef3A
nhPzmVEO/FZXooyoSzfzeEP3LIpXIT7xTw82Z0M5XMNQzh5VMBSgXxkq5dzV
/3aiSbqmosLdh1coR7auXzhcGE8kCQp0765bFKZ7hoY+4cHtsnjSBuktgaAc
oVmhHKHH2wWh+DQ0iuLP4z1OGNsa0BUer94ssoh5sxWDvB69H9GxIaRV7Qf2
6DQKZV+TkDNs88KfJ6jog6DcCvjT3Y83TJqhrwceIu+jLCkXCUVuVIYr2yIu
H2NhrwwhngZTHAH29Bfl5/ZUlpeMqu648sktlMtZoZw/SjlxOspJgTHdpUqk
+FB9+dMnGjLMGvoS5bQplAM2XwBLOWNJzIWrvFFQdhXsPLWAVntfWRdz4W5W
FXM+BDtvq2GfJBLlSJcM+HL7BEgzcO8C5SIR7Qij6GKiRVXypKn8N2dOFw6N
3Rg9zTh1lxZu58Jd0XK7FIlv+S5vn27KtBT8qpRD0XJRyk3EUyIVtdXfvDgr
gDg+eU9RykliC8ZENKMHXurvE8OdAoFyAUMu6D70iBDrpWZPOZeQMab2UITy
REbqGV8u+0w0l+jdfztRPXvbbyI9jC8niLVweILx5Qwxb0JXK2V8uXSGhVAC
X25WEOOpwwJ8uS5ppoY16svF+Rn15ZSx/SA1BevLEQzlHhHFta23/+o3Pxnn
wpwgDpKh3O908VfIx//wpc42yKxRSs34cpkv4oYZ9gG+tXPRSwyQQsaXE2ZR
KFjQFL4ykfgjFK5MdCWgQa0wFZPuA5SbT70rSifwyEcMoItaWutQCzxWPGZM
FyrbPU6F7dS6hX0FGUQ8ov7bweNai8PXd3z64PbFDGYZ0UTYR4QdCrxdTtqI
aHSOokXzeLuBUXoO+ZeMbIYwNgPD2l6i91oVCweBxhu0oHUlLFPAsBbW2Zx2
0/BnQOMJNZk3PuFUqJf5Q6DHOnlDZFOo01bMxT3q3Gh4pFJpEhlMszqDCmrN
sAiuFwoVo5Wgx/pF3ahGKLSiuf0GYFXLwoZoErtdyNhWA8qJbh46sfM3LQtK
h0OnqHsbGNYzY6YUbYm7C9YlQ3CMNHAZjSaukMY/2aw1ZeY7+5X6E9uZoNzB
7dwJbSYqbnkxHn+Liyaq6zyh0fgnQSFCv41yc8oSQblrPBQVFwNtG+ckgnLj
HBgVF1QMRINySZmXpNF1orm+x6OUS0qRDka747wT0aBcUpp5qLpuqm3Fl5tF
jMv5dKKL/7kSlGufzXROQ9BLeJwknC0nQ14fgdpNXEE4HAiGs8moJgN+ZyCU
/bQ4kvC6CeKvpaT6XQIVivh8kaydOAoPeDDIZX1ZsGDBggULFixYsGDBggUL
FixYsGDx1SNIBOQYliom2JVBI7TPEnQaCejjAEIO/dLQ0vyY3phNoSnSZBMv
LifEhjJgQxO3LNpLEZjY75GTcCnKAZ1Ua/JlGAqllzXLUkVCNG6EYRfSaR3v
m2u9Pi+xIkbRca9hySBJFT306pZUQOTDsdQZDYRnwG5rd/jMd+CE3CjLlYhT
Za8RZoDSjwtrrDNxsVsxiCdEO6e6i3c0F+9oi267+7mo1Qh9l7pe+nFHUt6G
WvE75OqySPONS/kOd7JYlt+r+iP4JCqFgcwGInR9LW//7iyQGn6GA09E3aHO
N/YmpV8EWfcWk4z/6KEzSbkmQWHd0mju0xVbU+XF0cXMDw+0G+SPy4GYZpPN
hJtelsc+lD+ucKhuf6phig5TYYYqcos8VyIXQwxXhPUd1pkGT3Q4mjLP+aDG
pWnn2PXSMkf0cqr+vc3Fe/WI+ai+y70vvSoUg7eLpEkSkrgh16DT2GRZyncm
6rTSWJNx6Y8Y8657nOJ8ozajIsamyfEvPi0HlGvJNBGJaCroPNwD1DtNUjTk
KCMAdukZwLRmJdNoWOunHAli65FkiCSjieNLM3ufrtgLVToUH7YZj6gBuyz8
OOWCwwwJ7aowU+0esG6fY1U1FPadlIhPLsMkrmCBuRqrznYXlowOSMuyoJz9
XMdLl9OWEFwLlEuc70hQLmD4wKgcjf0q0lFuXCrPeC6F4cPfnb2WKeV8VXs7
mzSIqp00zQHNdm46m5pwXwalyK/Yms9FKBLoVz8uN8cpF3Yckctfjk+c8Tdp
5I9r/as8VpNVlStR6WDoE9K7Z2rcPn/IPO/VCQIBpAmBQc+yRdrfD2xrYzfi
jEJC+Cqwp10HDwx/dIrXIfUhcM/vXKGc3yXNNxviyZk01m5c+iDTpIWg6v3M
Kec3Hwb29NDQuQsj5c1ilROOexiv70cPlY1LDP1VwzV18xJntmPpev7RpyuO
wpTtTQDHlCuUoyzPypWfx1uAFlnkjyu9d26PQKlEXGCBy34JGb1RF84mHfeK
W8COA37qp4/3BePIAZlVo9YdpTWnen/3h9mmG8qOPzBO3Z4Z6Fd/VcpFaLH5
K6Ic5Swv6Dl1bXFsSnyKceo4UPnzmJATc+Hyj7TvegzsXLyZUeXO1WA4WbH1
rRmkovS3UO7lFcpRUcphd2yPoB10HHrhUgQB5TwpNKOkNVapEuVdo0MO+WAB
YJ30jnM0oBCY2djx0jkDVAHayJ9Hy6XCq8/d21m1COFYxCjXGp9ubD7w0Jlt
VchTUCMR1zDoOLRYkewMkpYzObS5EqUc0q2gLEDL2ZxxRyesqrMKRVAzSIMr
T5KSXi/eMaVAU3TkynmI+ecB5czQlIv6cvEeY9SXm4yf2lUN4cuRWsaXk2ao
ZFNWLPAb9wLKwXQAcIZyhePxSQ+By4+d2XBBmfnht0C/dO7pisNLaPN/SR/j
y4li5A87GV/OGqNSoEnL+HJ3emHFRlmu1AS/IA+lqLPODflDTFY0Y2T1q/dO
boe8dUdzabHKuBzwGKX9h4CWE1pQ3rKu0Zd+3Fs847RY3cJLg8Cw/u4GxHxA
iiKcFKG3i/NtdjXYp8MR2t9vXMp3Y54Irbct5ZuNmUy6IXRSrWxuBPRYS7rE
Kqk2rcIY+rzzjYKZBb3XYTbXnQWGtWfMBvXOO04Bw/o6R2J1zzc3A41Xky4P
eQ0sjOY+XVMPr53pgMjnm7CCLqqhyeMX+YJ4zJjKjT0+QuXSPC5XnLmzGpGb
5blyBMoBu7MSl5OK4OJCpFM0Xpcbc+Sai3NnBYiLPmDumY9urATlrhhgFpqk
5ZZ4/C0uzqiuwy2X4p8oujKib1D1YTQol5RrojQE8Jn1F0+uBOXaIYu6RJhO
q3BXIij3UR26igNYmtj7dB085XBM/XgyBMeImc/oOuyqNv7J62b8K0mvDof8
VAixJgNw5HwBny/7JWlI0uciUDqrqyFMeshQtiuxpQUZJDz+bLLeKcyJYfhf
XOo3jZGki7oL4TMWLFiwYMGCBQsWLFiwYMGCBQsWLFjcTWAGn9CySoHX1UH6
JEK7MCESLUJI026S8kR8iSmj0tarAjNN9Xc2tnZOSbJKp0jAKVZzNT7I7D2/
2zEhMnJEDjVEFF8r4zQPNg7KkEbkcfv0UH9L19C0JIOSV6uBogkPlSqoq6RG
IgQumDcNTJoF2jQjLwbb4QOyfwbS6IGtjIct/ezhoe8n5Tkr5JCJlt9S1lZR
dr0CbBsFsFWp43Autqxf/7/vWf+/Y9v8VqQMnBRMDW7+24v3rL8xlfkhhFww
n3uFm3sltpVwMuIAr3vbQ4fXPVSwDmxf74crGEWaxl5+ZPO/PLL5/0a3L382
jTaEQam9kiJ7qugVKGNBlH35ww9m3/pgNj+6/bBlrawgi6vuqu4/AOU6vdCU
kzzz8ESVkFlZnskBhzw6qK5pq6jjM0xTcevK2hoNSK2muPbGPevPGqP3U7sb
sO5sNpoOtzQCvgHZNALBAay3g5s7Gn23g/qzgHWj6RMU/FPPHF73Ujdzlen2
nIcObxbCqBfSNPRsTpEy2mJDn+38l0d2TiPW+goz8xCiUxFwgVtS5PIhaTnK
bn7/Y5kuyrPplvm3PpgXpBktlJyR/XMbNOWsi99/WIK6wnbIMgGUmyQ2mu1d
AvvDJrRMdMyZWGvDOXP2nvW/nkIvKmk8VXrP31Zs21Z6T84glNoJEv64ciCE
o9zcRke64VlcWQKU22CsoK6tB+xfkCEWdXeOF2VBuSRIDVBxkrswXOsRytJT
juYdR6AcxpsA9vRnb3Bz8xYu1DutcNxbFneUtd2MtzJtbUWn3Aq4F399z/rj
RtTDBePbgH7rsRlra+5ZD0e5FTgbGrm5N9MmEilGdj10+HRcIVOKXCTKYVaL
cLxrB7Ctu9uyZBwhAirOk+WS6T5XQCY0HAO2tVSXJjMGjXKkcuGZJ2Y/rdb1
1c8yTt1WC8wJtMCYXp9IkCw01V1RwzfA3cAtt6PtBL7crmuIvhxpawd8OyBk
CFtRcU/OCGRt6ijCJhHw5ZZ60/tyPGBMC0oSPMGrTq57phu2qravbBPjyAG5
MA+blXoLaGOJXc3LMhMn1HyaceSA1MvSkReNcqlwjg1//+HFaYgzMFru+mji
XXBcb6sYREnZS8A1vQ10H3bWo6444q2oYVy4/BuFhYMFmxh3bnPJEmRH0qNZ
BN2Hk/OZPDlGyxUUJtpLs+/wuk9lKO1P4va+i/sB6zpRAgYJ+HBpkd0BVYl+
FVAEPt4hAKy7aVnzbGEh48v5YHVzypxRbHoMUA6mGnzIBny5GnnMAvmkwJcb
Q117K2Kd3gX4tqk4i44DPjJdUjhSUjgIKHd6UylDuQopDOWcmiXAt0MTGWY2
41rgy60fi70hLg7w5cqUUK8LvtJYpPjZRzZ/OoOu6KL9Vnd2aXfUyg+nXO9/
MFuztJqiww0+odJdBXqsVdZRjU+YeTa0Zt/DQ8+csChMAS1v6XVgWJ/QZVjV
Ooao/1Y2xLX7HFNDFWVt3TDpvCvATUPbouGRkiGeYJ43NTOtcGVpIMioYYUw
c5RVvhgNj2hm9G6x3iHUYJ507Rj13x76vFbr0lR9vu6hw/lQWdF972/+l5wz
QxKL02ro/CwPaLl6JbonjN10SkqwbBg3XjH71seSaW3A4/LdbFkAWq5ntfUu
ad6ZaFAuKW2rTDu8HSHt2PyWlaCcbBpax+A2fk0bE5Qra6tbcCC2mKB86z1R
yiXl9EyGi+ysBm9JxT2bxiEo525t5UYplxSlML2TgGkbnznMBOUeOpxz3QDn
EeAmwfE3fxtz5P7lkd9e6FdDHX7rnQDKlWdFuaDdebmYG3Pk3vqAW3/7OiN3
DzSOBTEMPZOcxn1BP559JvpfKSiv0+9Eftgk7nO67mb6fZagiJDHG/qLS4tn
wYIFCxYsWLBgwYIFCxYsWLBgwYJFHF4nJXCHkWOKdBgLwB4dtFISAZkqBmuW
w8ou3fyCxZVVBhQmHtX0dZrEerTDlUFaBxPW1orHmvq6OIiX8/KHO9rbe/m6
LPIxVhBU262mYDb1UayLto6blt5Fb5r0MSdxsNv3d0B4JOKd0yqBr28UN8GV
6pIUYlvu8abKa4WoxXSiEF98+0/rf3n8M/QlgG1t743mPTu671mwneuESyVS
YuRPlkNAzuGZvjjctr0P7H7ugf3Pge32LsjMJVJb9NI/PPHYP/z6V8z22ABi
3aokhLLx3InBvajTKCicc5J//17+/Yei25Pq0TXGINyh2tnAZkA5IRrlcKu/
bxRQLmiDJgyJx8sRSioA/TAhauIRAKG8DvgGpLB8AfEUfu5k3rMzbcyjtza+
Npr3ewfMO6TzU6ccDOW+yJByfu7G3c+9EL3cVOOOB3bnCmAuZx4+BJjWrgLN
R/Z8/JMnHtuDOHUkiqBXBfgGpECBmIxD4b0FggJ99KfPqTfs5W9YTKMvxYO+
v+OjUI4iRkd9o0v44Ci+jFheGtDu4D3eg7XZDBWaW//9l3/atOfSv//yzEVE
ylHyGqDcTLE2sA6CfYkYtuZb+NXl0KXMKIfLrwDlxolfbgjsn4e5HP/znz/x
q/Px9AVTL6DfVSnyG+urnRrMnZk8OTV4SHYXpsh57QXpKRfmDiBRjtYAkzpJ
EqFgFpQzNPq23OPTZME4Vc0eoN/mtOabv/3lcVTKeQYPjeZdiieQU2oeAuXC
9AsZU04xePiB3SWJRHT1WwiUe+yTOOVcoy8/9g+lfES/SK6aBPptAvP1zg3u
zY5y/qBRYW86C2yr5GqaTBo0yhGMSQ0uA3tKBweAYUXLIKA+u8f7XgU64Sht
H+Bbbb8Z7A9s+uWZchnaeWzAmO6rSTgHuOLIs5NtS3CngKEcFxjT/VcSigmv
OPLcRpjL4aqrjCP3ztHKiqO/foxx5yr5KFqOwjSAb6VGhu2dM4OHFNn0RLwd
QsaRA9LsSnceFMpRxARw4SaDUhUhlgHu+WeXCIRMciMBOg4dCuS+KjbwW8aF
q/qs/PrFc4WMO/d2zxBKB5DRcvsuJzS1np/37JIYMu8OVsvt/yLR4vo9u587
LYZL63WpRks/OXTsk88nZjuAlitC0XJE5xzjwl2QiBpkCwWMOzfeas7CpWaK
L1unNK8C1o2lqSMvYHw5CupaFCmVBRdlQYEkKFhiKDchIAzQiXmGHj+wqqiL
AUWY0uDXaq6X11y/CCh3sfDfGcoNjKNQjlIDX26LJVZN2TkKfDmZHNqwMr5c
Zv4Frga+3NbR+OXGgC/3OezlkqfinwdargcqJTsOkqcRNyjEDTJAOWHBFEO5
zmU0yuErvzssKODff8252iuAOymBNVQBeqzTxIidEsCs/JYEumEVFmJb1uOI
bX0ryKhhhbSGSUT9t9FzrZhTrzj37GjeUaj3RxmkFwMU6LEWeGlpkDalbcao
//bAuVatU19x7rkHdn8MFeYgbaNH3jk6IdWq+E07gGE93JF1oiYdNaxoswEi
U7L79woOznmN3qBmTP080HI3VquwEeYORoNySeGTCCQPAcqhdR8kJdiWnLtF
Oaxn0y8La1ApB36GunMyjwnKjea9ptPD3FRUv/0kRS5loLe96q6Nu5mg3AO7
d3RAXY6h3NS+aESO8eje+1x3FzKDidaZwQIVIuWCOPeK+NGYI7eX/2jzMsJa
YP+/gvIF/a7/ulxqyuf0u72ol8NcTheW7XzzuwiK8noJ5F/DggULFixYsGDB
ggULFpH/BzgkE7Y=
              "], {{0, 187}, {209, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {209, 187}, 
            PlotRange -> {{0, 209}, {0, 187}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8858954f-3976-40c3-9f12-77a65e2db953"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd25a6a3-e368-4d4e-a07d-c2c668841189"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7069f45a-000a-4240-8282-f38bf604af35"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f812da1a-609a-4a67-a23c-166e59048b25"],

Cell["\<\
Make a grid of all possible strings consisting of pairs of letters of the \
alphabet (\[OpenCurlyDoubleQuote]aa\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ab\[CloseCurlyDoubleQuote], etc.).\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"8711e540-e23f-4d9f-973c-87892985b14f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fd24cfa0-18c9-4c67-8d49-bac10b5a11e2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvc/L/VzXHxR14tB/wX8gY52ZoaNAxVkmrb4pCtbQCiUDQTLRDESCoEGs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            "], {{0, 491}, {724, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{724, 491},
          PlotRange->{{0, 724}, {0, 491}}]], "ExerciseOutput",
         PageWidth->DirectedInfinity[1],
         ImageSize->{728, 491},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "55a50602-af8a-4809-bcdd-9a031df05e3f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvc/L/VzXHxR14tB/wX8gY52ZoaNAxVkmrb4pCtbQCiUDQTLRDESCoEGs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              "], {{0, 491}, {
              724, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {724, 491}, 
            PlotRange -> {{0, 724}, {0, 491}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a271132d-ef1e-4481-ad17-4f25a22b96b8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b11bc8e9-c2ac-4513-af26-2c37719d53aa"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f61f55f5-1fb4-4b77-8e71-00f97ec54d83"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"eb968c75-c0f2-4fe6-b73f-292f7399cdaa"],

Cell[TextData[{
 "Visualize ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"b23d725b-93f0-4b49-b6da-966db8bb14fa"],
 " with a pie chart, number line, line plot and bar chart. Place these in a 2\
\[Times]2 grid."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"8cefb201-81ae-4083-ad56-0418620e7268"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"54338a06-f126-4955-8366-3b7701d89181"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWlYU0m37997z5f78X6/z/lwWnAWh/O+/U7t2A7t0A7Y3aIgMxvCEOaE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            "], {{0, 311}, {370, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{370, 311},
          PlotRange->{{0, 370}, {0, 311}}]], "ExerciseOutput",
         ImageSize->{374, 311},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "11048d05-9aec-4b1b-b008-42409ca87be8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWlYU0m37997z5f78X6/z/lwWnAWh/O+/U7t2A7t0A7Y3aIgMxvCEOaE
AAGBME+CIqKoCEhExAFljANoQKKi4oAtIioqiBoVZQgQ4FaIclAIJGHvXTs7
6/es9klDsqsqe9WfqlVrV/2Xvac58b//8pe/+P4f9I+5HX+5j4+dYOv/Rf/z
O9eX48x1clzL9XNydvL5h/1/oB/+/X/95S8+6D/V6yEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAMBwGBgbkcnlTU9ONmquXz4rPH91zInVXVoTnwWBiv8Auzc8q1csC/Yte
HxQSR0We6LfoPZfOim9ek6JPoc+iK+BuBAAAOFEoFI8fP75aXlSwN3yPj6XI
amnKzh+PWs8usptWxZl+nTvzvu/sp4K5L4LmtQnN3oSavQ+bj/5tFZqhn6Cf
o9+i91S6TD9nNw19Cn0WXQFdB10NXRNdGV0fdxMBAKCc3t7ehw/ul+TuTw+w
i7T8Kdt6ToWTab33rPZQs8G4RUPx/z0VQ1dA10FXQ9dEV0bXR6WgslCJqFzc
TQcAgEw+ffpUW3UxO9ovynpZrvXsarcZL4PnDcROVUYmNnR9VAoqC5WIykWl
ozqgmuD+MgAA0J+enp5bspqsKJ8Yy38V2Zk+9J/TG72QUiXRZH0xi1DpqA6o
JlmRPnW11ahuuL8eAAB04NWrV2cO746xXZFvMwN1ZyXFwxLtDdUE1eeEzYwY
259RDVE9cX9VAABMxODg4L3bdQdCOLt3LJK6zuiJwjMy0cZQ3VANUT0zhJx7
t2+hmuP+8gAA+AalUllXK03xsTxsNecxf87UQ6+0GaotqjOqOao/rE0DABNA
f+Xv3JAle27LtZ71PHAedpXQz1DNc3fOQq2ov3kdxi0AgJHHj/5MD3I+ZDXn
ZbCh6sloQ63ItJyDWtTU+Aj3VwsARkdHR4d4b9Qey4UP/edgVwNyTeo6Y+s/
p2Xujvr8+TPurxkAjIKBgQHphZJYu5VVnOkGFD/R3ogVpkftZqXtmB5gs/aa
tAr39w0ALOft27cHwjyP2cx+HzYfe/enwk7amPquM60V/DeyUk+zEPM5KWG+
7e3tuL94AGAntZUXYm2W3fScib3vU2RdkQt3LjE56zZPrSpqO2I7099iac2V
y7i/fgBgFd3d3bkpEYes5rB1iKK2ZHPTSPMZoyVFbRe8FwSZz8tOT4InFgGA
FF6+fJnstaOCmIG911NqzwPnWS8xueizYKyqIKvmL0qymBHhZd3W1ob7hgCA
YXP7ek289RL2LfSMNd7a6WmW4wxURpvYabafxZIbtdW4bwsAGCoXigpSdixi
96xHbTVuM5x/NpHyF02sKsgqvObzty6qOH8G980BAAOjv7//YsHhQ1Zzuhn8
LA9ZNhC70HG5aZ7j7EklRW2VfguDzeflZ+2HDH8A0JK+vr6jiaGFdjOZ86wx
pZZraRKwYbqWkqI2KW9RxNZZBxIjkPzivl0AwHSUSmVmFK/IgeWx2RHriJhv
uXhasYeZTqqC7FrAouitpiHeTjBiAYAJ6O3tjfSyi173n9g7O20Wtck07vdJ
grQTmNuK/0yJ4MMOlgAwLqhrHBD5n7Ofjr2n02ZN/Dk2S00u+46/mqylJW6b
mRYTjKaNuG8gADCL/v7+I/HCcw6szZsd17xWm2bs1H+gMmJxf8zMSAyHGAsA
jDA4OChOT7jiMRd7N6fTLhCmbqtNawImX03WSli2zTp//BDszQIAaspPH8+y
nkv1pveMsv7ohbZLTU8Qc0iRFGRInUK3zi09exL3zQQA/Ny8djXVciGT95il
wjK3mQg36baaPKlV+i3kb/3rnbqbuG8pAOCkpaUl3nrJx/AF2Ls5nfY2dL7V
YpMyz/nkqkrt8OYJvB0rXr58ifvGAgAeurq6Ej0tHvPZ/4zPd7Zrg2nSNpIH
KiNW4DwnhLMNjjMDjJDBwcGsxF2XXIwl223E7vvNtltmUuW/kCJVQZZuNTMj
MQL3HQYAurkiKcmxYcMW1rqa60rTI7YzqZOU2uG025Df5lfDRk+AMfH69es4
22UdEcYVTkFWZG/i+YvpNZJWkyewCq/5PMuVb968wX2rAYAOlEplmtDtrs9s
7H2cZuuNXmi9xOQUZy7VkqK2o3azEoI90beN+4YDAOVcLD5TYG90EVpke36b
Fm5OVZB2XIvZNqfs3GncNxwAqOXdu3exdis/i4xu7tMmnGe12ETiTf5q8gR2
yXcBz2rV+/fvcd92AKCQrMRdtR7G9bCP2gLXmaZuJ+GRH13twM4Zh1JjcN92
AKCKe/V3Dtjg7+D02w3uTKcVpld5FK4ma7KagEWC3//26BEcsQqwkIGBgd08
+2eBxvUIodqIFaY59rPolxS1nXSZK/JxgLAtwD5qpVXH7IwxQeWEtYn/elqD
tGMtxmLe1arLuF0AAMikt7c3weP3N6Fm2Ps4zdYVudBqsUmR+zyqdWNiK+aa
hbhthw1YADYhvXyh0MEY5z4JW0yjt2IeqKgteptZjfQKbkcAAHJAfyLjuRZG
OFB5Jpg7wXGEdA9XPMxC3C0hugKwg7Lic2KjjKj4rjFNt8KwmqzJRNvMZNdq
cLsDAJCAv/PvPmuny7zN+mOMaLe3q5zpnJWm2hxHSJud9zCL8LGHXSgBQ6ex
sTFdsLoqZSnXfDqx0rTMbUFnJPsTawdiF9ovMxU7aXscIW0WavFXyF0BDJ3c
gwk3Dvzcf2krsj9z1oTazLJa9kOuw8J2VodZsi1NBL8yIkj7neU6zD6YJMLt
FACgPx8/fozx3aiQmKtVRW1vi35N5S7YseyHpO3zG/ksXBj6EDbfavG0Yq7O
xxHSYNX8RTzLnzs6OnC7BgDoSdVlSVHM0tGSMmI9FVuOh/7dZvW0gI2zr3vP
Y1PIJXKjSfwfTByoqC15+6xLkjLcrgEAepIa5fU0f+24qjJil1OWeJhPd15l
Wu42nwUhlz/959guNan0w/DIj5ZW7GEW6eeE2zUAQB/a2tqS/NdNLCkj1nB0
tdB61s5l03IdFhp0Zgt3lWmmNYNWk8e1wB2L0d3B7SAAoDOSsnOSpPGnP5qs
/cyvuz3mWy77IWnH/McGGHIpdzRxJ+84Qups746Z5cVncTsIAOjM3hifSac/
41pX2ZY84Y+2a0wEwyEXpYGcadgfvdBmiUmBM2nHEVJn5z3MYvgc3A4CALrx
8ePHaJ9f9ZCU0XYxeYn75i8hl65Iph9umPGHSchm5gZpvzOe5fIPHz7gdhMA
0AGZ7NrJyOVTVJWRkEuwKuTywzEGh1zehs63XDytnILjCCmyxB1zZbXXcLsJ
AOjA8ayUO4dWkaIqIyGXZHezHct+2M3IkEvIetPdFkwP0o62Y46zs9IScLsJ
AOhAtMD2/fmNJKrKSMglV/ijzeppgZvm3GRMyOWezyz75SZXqDyOkHS75Lsg
0PkP3G4CANry9u3bJN5UgyoT24WkxW6bp3NWT69gQMjFZYVplh22DST1thDr
5a9fv8btLACgFXV1dYVRKyhVFbXd/xpyETsueLtrPhZJOWtr4k3LcYSkW4Ll
fHSncDsLAGjFudN50jRyQrXaWNup9cnuZpbLfkixnN8UQGvIpSdy4c4lJqdd
aTqOkFw7bDOzMO8obmcBAK04sFvYlPcLbaqiNnXIxXrVtODNc+p8aAq5pG41
iaD3OEISrch9XvIuX9zOAgBaEeG3vbNsM82qMmIXkha7D4dcJO7zu6MoDLm8
Cp5ntcTkgjcjNpDUw67yFvLsN+N2FgCYnPfv3yfxsUnKiN07sirQapb1smnH
nRZSFHIJWGu6d4chrSaPtcCdK+G8VID5NDc3H9q1HruqqK3t1PpEN1XIZY/l
/CcCMkMu1z1mOq0wkfIML0g72qKt//X48WPcLjM0MDBYXP0kMe8G+he9hrIY
WxDNZY1QV1d3Kvpn7Hoy2rrKtuQE/WhDasjFablprgPjNpDU1ZIs512/fp0e
x5gA5J/WYcVqQ6+hLMYWRHNZI0jKSy7t1u1RZdqsImGx6yZVyOXC1EIuYqtp
PNzHEZJiGTtnlJ7H//Ay+sM34qjoNZTF2IJoLmuEQnHmrcyV2AVkArt3ZJXA
cqbt8mn5Tgve6R5y+Rwx33KxyTncxxGSYjkOs/IOp9PjGBPA1j+1MFYhi5wD
cQ9z1mCXjkntVeH6BFfVg0V7LOc36xJyid9iEv2bYQdpR+yky9yMxHB6HGMC
2BoWgLgKWexPFDw/oe0WcNjtc9mmo4F/s141LWTLnFu+cwcmC7k0B8yxXmJy
yddQV5O/sxKuWUKwJ6X+QBCEQfwQewWMp/56kBTm+q6I/OcKqbay+J84G6e7
rZ5+ccKQi88a0/1MOo5wiibxnh/h40DKfdcEA73a0HuloddfD2IC7TtKNmFX
Cf2s/vDKgB0zbZebnHBaIA/7PuRSxZnuusq0mknHEU7RKv0WBnO2k3LfR0MA
wHjo7VGRfGuMibWk2KvC9fGceTuW/ZBmteDp15DLQOxCu6UmxwkD2EBSe1Md
D2RvTqKeAAAVhPla9Ei2YFeGqdtIyCV0y9zbvvMOW0wL2siG1eTRVhOwyNdm
I26XAYBJ2LBu04YN29hkK1du+ec/18z6rzlWPy8N2mSWaT2j0qA2aJrYvHdu
wO0yADAJ1nY+/hFSXkQ1a8wv/MrK1XbO67gJTvsCLcKdNrhu+mmjxc/r3NYv
FW2ZLnaaXcM3YJHxsf4Vt8sAwCQ4uwUFx90OTbrPDkNt+dXc23a188ngshHL
DyzO4OZG26X4/RZsvcZu40/rrVf/4v3rPxN+m2ZY2XFS/iJ/iKsAjMfNMyQw
5gZ2NSDFQhLubt0h/H2p1WhJGWt5AUV7XQ+H74z3NOf9scLCfOk6h7WrAjYu
TLecfsmX0bvuV/kvDHSxwO0ywygaRQSvvpPaQpTtdfFc9XKESNpCbWHy+iJ1
UaJsmYLSktQoGoSEkOovsLPxS6MQhQ0d1BY2Cm//CEH0deyCQIrtsIvd8K/f
TgSWTKwq39lRv5PJzvuDt0e6bORuXrJ524p1LuuXh26emW0/S8qwudIl3wW7
vOxo8w1NdLbKRCo/FTZQ2ymUEiHBFdcrh4Yai5CGlVDZ2VtQi7Lr5UPKlhSC
EDdS3NuHFCWqb5BH8Rc41CDm8bJlcrm8tbVV3qmktrBRhIYn+4ZVYheEqZsN
Z9/Kv29E4xCdJOU7OxFUctArL9ZhD/+PULt1Tht/2mC1ai13w79jzE0KXfAv
UpdwzeKDvWjzDQ10FolE2UXZBOVjFWWjtLJBruoLnfXpqNNTWVpnc8OwlChb
M9GfdYpVpRlpijA9niei+AtUFAkJUWGlTCptaKVaJ78hafcBblAZdk2YohHe
OUv/ti7L7+RUJGWsiQXn9rlniWwSvc0FO1ZabV68zm7NGv+Nf021MMFyQtlp
17lpsaF0uodGlI086mdAX4qS1wkJIlPWTnVBiuaS4fmCiNK5gqKlhCBS2oeU
RTxhPaVzLWUr0mJuilhSIkbtSpG2UlnYNxw+ksfxP41dFqZirrzCxT+uy+Dm
kCspYy2HdzrF5WCIZbTbJm/zpVt/W7bOed3K4M1zD9vMpOd0IbHT7NzMNNp8
YyIUDfSoSmudGPXzbBnlPUL5dX5Qn80lMuspK6dTPBy7kUgKhcM9vp1KYVEq
vrSqoy6TEFI6hfyGonPFDp552JVBb+MGlf70jw27nQ9QLSlj7bBPfrxjmmBb
mON6zqafft3+81r3DUtF5tPzKUvozbSecb4I//4qKmhRlZbKFDTPkg2P3pVK
KsMCquYQMrnqZV0ml5vdQFlJypaGOplMVierjEflSOo7qGvWt42iUiq/p7a2
1t4tA7s46Gc+uy4vWWweZbubfkn5zoYXr3OibJN9fwvaudp205fF678n/2FS
7EHa4vWenWY1NTW0+cZEqJYwKFYVZXP86IdSeIWUrmE0S9B0gVDNgHiZzXTM
7BSFPBG1M6ChocaRRgmzW2gbqQwNPXr0yNEtGbs+6GE8UfWKFTsCLSKwS8pY
O8Y/u8f1cNjOOI8tfr8v/8N86XpH1eK1WcbO6ZW++s+V4mx/evjwIX3OYWwo
FZ2dNPY9esDRqDdv3jhyRNglQlcTRF9fs9aJu4mHXUC0sSzfgiRif/B2kfOv
7psWb9q2Yh1n/fJdm2fmOs7SKdE31G4Nul80ewgA6Aqarjo4C4QJ9diFQnsL
jru9YYvXdwm0hmKqxWvPYzH2qbzfQ2x/cdj47/VWq9Z6bvhX3FaTM64TzZWu
BSzi2W2mNrwAACQRGp7ku8tgUlZUCbTbg/9YthO7PpBiYsG5NLesCOsEL3O+
xYodW5ast/tlNW/jor3bTSu8v1m8LuGaxeFPVgEArcjJzXf2PYldLrS07XYx
eiTQGopl+xfudjkQsiPKdZPXliXmvy9f77zuZ+Gm2UdsZx61myk+monbWQBA
K6qrqx3cD2KXC23MxmXfqr9vmmICraFYQVDpIe/jcY57A7btcljv8ss/VtfW
1uJ2FgDQipaWFkfXaOyKMak5eeUs+3E96Qm0hmI+NvwXL17gdhYA0IqBgQFn
V6bvh6BOoD3geQx778Zi4oAiH2c/dKdwOwsAaEtyygEPQQl26dBk6gTaFM5B
7L0bl6VyMvenZuB2EwDQgYsXLzl4HMKuHuOaKoH2J0Yk0GK0MNvYqqoq3G4C
ADrw6tUrB04EdgEZa0xOoKXT+I5BEFQBDA4f/3DUhbHLyGgbTqB1NJQEWurs
iG9BsG8IbgcBAJ0pOHnayYtBDy+rE2jt1nCwd2rsFmmfdPY0Mx5VBgBdaGxs
dHSLxS4mamNZAu0Uje8Q/OTJE9wOAgA6MzAw4O0bxo+swS4poWxPoNXJcnin
A7iBsKYMGChnzp5z9MzGLik2Lmmr/2EsCbSTWqR9Ikx/AMOlpaXFyRXzrghO
XtnLfiR/B1rDNR97XltbG27XAAD9EUXvxrg5Nod3cvGP6402gXaspbkdSYxO
xu0UADAlbty44eiegkVSuIEli407gXasBdtHoDuC2ykAYEr09vZ6eIXSf+6Y
T+ilJT+Zx9ilYO/IzLEc/1N8DwG6I7idAgCmyvniEkduJp2SwotQJdAGbxdh
78iMsl12MeVl5bjdAQBI4NOnTy7uwsCYm/RIChoXrV7r4LmZj70XM8qO8c/4
OvM6O2k9cg4AqKOw8LSTZxYNkgIJtJoswiHhzKkzuB0BAEjj/fv3Lu4hQXG3
KJUUYUK9+fagbcussXdhppk4oMjXmY/uAm5HAAAyOX2myNGT2uiKhW3Mr//+
HRJox1qYfWzRmSLcLgAAJINm9B5eofzIaxRJirXL3tX/2CSGBNoxluVbwOcG
dnV14XYBACCfixcvOXqkUSEpwwm0xrsD7cQWbB9xpeoK7psPAJTQ19cnDI0h
PdXWlXfypx/XQgLtuJbBzQkLikDfPO6bDwBU8ejRIweXMBJPNoQE2gksP7DY
156PvnPctx0AqOXwkRxn7xxSJMUn9NLif2+BBFpNFuGQkJebh/uGAwDlfPr0
yccvbOpHpvIiqpcvt4AEWk2W6SUO9BFC2htgJNTX1ztwRFOZB6kSaH+BBFqN
diKohO8QfOvWLdy3GgDoIzsnz9nriH6Sokqg3cy1/wUSaDVamEMszH0AY6O7
uzs4JNpDcF5XSVEl0FoEQgLtBJbiejAyNEqhUOC+yQBANy9evOB4hOq6sa2F
bcyGf0ECrUY76lfo58J/+fIl7tsLAHi4du2ao2u09gEWSKCd2PIDi/kOwdXV
1bhvLADgRCzOd3RP1UZSHD2PLvtxfbZfIfbOy1gLsgs7dfIU7lsKAJhRKpV7
0jKcvSfZJ8FVtQPtOkigncBEjgkZ+w7AkRwAgOjq6gqPiHfnn9IkKdwgSKCd
xJJc98dExHZ3d+O+mQDAFORyuSA40j3g7FhJGd6BFhJoJ7JkTsYuQTj6DnHf
RgBgFm/evPHjh1tzDo5NoBXuiMLecxlrKW4HhbxQ9O3hvoEAwEQ+ffrEceeP
jFjUCbReWwKw91zG2m7OgSDfEDg1DAAmAHUQXkCEh+AsJNBOamE2cT6ufjDx
AYBJaW9v5wsi1m/xslhmg73nMtbinfeGBUXAVrQAoCUPHjxIjE6OIpKwd15m
Wozz7lhR3IcPH3DfKAAwJHp7e9P37hc6ivIDi7H3YuYY+jZCHCNTk/bAPrQA
oAdKpbIgvyDAUZjDO429OzPBjvoV8h2DThw/ATtGAsBUuHLlCo8jSHM/gr1T
47V0brY/R3Dt2jXcNwQA2MCzZ88ihJEiIuFEkDE+qoxaHUkkhgVGPH36FPet
AAD20N3dnZ2VLSBCjvgWYO/mdNphn3y+UzBqO+wVCQBUUFtbK/AKinFOMYZB
S0FQabzLXtTeuro63F88ALCZjx8/Zh3OCiCCD7L6+eUMbg5qY+aBQ5CRAgD0
cPfu3VBBWLhzbC7vDHYFINfyAorCiJiwoPB79+7h/poBwLjo6ekpLyvneQii
iOTjgvPY1WDqJhaci3HezXcPLC0p7e3txf0FA4CRgiZEJ/JP8DiCOOc9hqst
+YHFcS6pPFdBwYkCmPIAABNoa2vLy83zdw2IcU4+xj+LXSW0N1RbND7huQYe
y82D3QwAgGnI5fIzp8+gOVEkJyHTS4xdMSa2Iz4nIlzi+B4CVOf29nbcXx4A
ABr5/Pnz5cuXI0Iigzi7ElzSmDYtQoOTBJe9wZywsMDwqqoqeJwHAAyFwcHB
pqYmcZ4YDQbC3KKTXNLzsJ73IQ4oSuEcDHON4nsK8o/nNzY2wrbVAGCgdHd3
37lz51jOMT5XEOominPZe9ArryColB4xOeR9PNY5VegWzvMIyDqcdfv2bVjc
AQDW0N/f//Dhw/Pnz8dHJfhyeGHuUXEue9LcjpCb8SIWnNvrejjGZfcu90g/
Dj86LKa4uPjx48eodNxfAAAAFNLV1fXgwYPS0tKMfQeC/IT+HEGouyjaPSmO
k5pE7N/vkZPtX4jmLBMMadB86ohvAXpnKiczziU1yj0BXYHnGhjgFYiuKZFI
kIJ9/vwZd0MBAMDDp0+f0HCitra2vLw8/3h+WkpaeLAI6YM3x9eX489zFQjc
hXzXIPTCn8NH4xxfV57AJwiNQ9A7c3NykTpdv379yZMnHR0duJsCAADT6evr
6+zs/PDhA1IMNPZAg5yenh6lUom7XgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAbIAgCdxUAAGAVxDC4awEAgMHRURTPVQsIISzsHPULkBQAAPRB
0cAjhLKWdnl7a2urfPQhoKAqAADogaK5iCBElTKpVNbw3ankoCqMoqe3H3cV
tAU8x8hprUwnCJ64RCJOQfOg9NZRvyK+gq1ywFeaXn4Q7KvqVw7grohWgNsY
O0rl11lPRyZBFLUoRn4DjsEQ5B3dHokXrMOKi6uf4K7LaCAiB4xPo5hHpMtU
r+R1XIJbP8o5wDeYgKJPGZxx1Ta8xGf3JZeY8s9dvbhr9BWIyAGa6GhM//oH
J1vaMvo34BvYGRwcTD1Rh0YpF28+v//kLXqRU3ofd6W+ABE5YGIUnZ0K5fc/
hNkxdgou/omUJLf0gfp/E45dt4soeS3vnPhT9AAROVLYuvT/UWe4GzcO4BV4
qbn7EklKXK5sYGBQ/ZOXbz7ZhBen5N/EW7EvQESODFDf77+0lQoDVQG+o+nF
BwdRKT+tsqunb/TPj5y7i6Tm0XM5roqNABE5UgBVAejh3cdujwQJJ65i7GTn
42eFU1TZroPSwcFBLHX7HyAiRwZGqCrgHvSj6O0P3n/FLqKk4em7cd9w9spj
NFypufeK5oqNC0TkpogRqgruKhgdaASSkn8Ticbluuea3tPbp/RMuuiz+1Jf
/5j+zAzAc7QHVAWgmvwLD5GkHCt7MPHbrt55gd52XtpET610BTxHe0BVAEqR
1qsWfRKOXR9Z9NEEGtIEZ1x1jin/xJykuFGA52iPEaoKuAdtPG55by8qDUir
6lb0Tf7uoaEHze+QBGWXMCUpbjTgOdpjhKqCuwrGwruP3W7xEte4ivb3Xdp/
Kkl8wy6ipO3dZ+oqph/gOdoDqgJQQU9vf1C6atHn4TPdslBevf1sG16SfPwG
RRXTG/Ac7QFVAUhnYHAwWXwDzWWqbrVM/u4xZBXfQ5/VVY6oBjxHe4xQVcA9
qEZc0YBkAf2r38c7OhVEdHnIAQYkxY0CPEd72KwqigYhIaz/NpETHINq1AvE
iXnXB6agCeeuNqGLSOtfklixKQKeoz3sVRVFiQg5Aq8BVIVGHj2X20WUCPZV
dSumtHVkb7/SK/kisl7GJMWB52gPW1WlGWmKMD2eJ2LlWGUqwwDqePOhyy1e
ggy9mPrVqoefbi66+njqlyIFdngOPbBSVRQtJQSR0j6kLOIJ6xXf/Iodu2Qk
i2/klj3QMgmEHtDgBA1R0ECFrEePBwcHQw5Iiejyjk7F5O+mHha4DW2wUlXE
6PaLsiWSQiHBTRFL2kd5JQscQ71/GjKPBAlDIg9o7JSYdx1V6eqdFyRe9uFT
VVJc1vl7JF5TKyAiNzVYqSotDXUymaxOVhnP5WZL6jtGTc0N3TdQ/w3af8Ul
phzpiU/KJdTpREdqWl53TP5JKskrVy36HJc8JP3Kycdv2IaXvHpLZ1IcROSm
CitV5SuKQp5o7AwIU2XIoepWC+q/pTWqfel7+5SFlx85iEpRv8M4Iaq6raoS
mpRREe1pHU6KS8yjLymO3RE5emC1qoyDQc+OFX1KbuIFNEQZfYZO+/su9ezD
HceE6M9nqkWfoPQr1J0Xll1yH7XuQfP4G7OQCxMicizY9NUIVQV3FfTnVGUj
6l+yB61jf3Xrz9e+wxOiiMM1z+maEL153+UaV+EWL3n7oZu6Uj519TrHlAsz
rtKQFMeEiBwLuiQLmqAThqsqHz4rHKPKwjKrNb2ht1+JZAdNiGzCVWdhfLc3
LOmgCZdgX5W9qLSx5T2lBSHOS5tIDwWPCxMicizokixogk4Yrqpknq1HPWvS
LozGD0nDz+CgIQTqhhT9fR8YHEw4dp229Ne+fqX37oueSRd7++hJisMZkWNB
l2RBE3TCQOMqL9pVx1vsKajT8v23H7X7pV5GvT78UPWzNvInRLllD9DFT1z4
k/Qra6Lm3itU4tkr2JLiaPMcFnRJFjRBJwxRUhBxuTK7iBKdNipBf99PowlR
pGpClF1yv5O8CdHluueog+8+fpPOp/9QWbsOSonoMlxJcTBWMaom6IQhqsrd
x29U+76W6/MI8JsPXcnHv0yIrtwmYUL08Ok7pG/B+68oKFv00cSfz+SoIUfO
3aW5XDWgKkbVBJ0wOFUZGBwMTL/Cia3o7NZ/sHGn8cuEKAxNiFo/6n2d1/JO
TlyFe4Lk3UcKF30mICX/Jhp6vXzzif6iQVWMqgk6YXBxFfV0o+xa8xSvgyZE
Z6oeqyZEYcVZxff00Kiunj5+WqWDqPTxC8oXfTTR9q4TjZQSjl2nv2iIqxhV
E3TCsCQFzTI8Ei+gYcbotLep8PZDt/poHjQhqrrVov2EaGBgMC5XpjoI7C7m
J49yS1WB4vtP3tJcLoxVjKoJOmFYqlJ4+RHqQdfHS3ubCvWP3/jvGZ4QZVY/
1W5ClFOqSnAtuEjfoo8mPnf1usSUB++/QvN2EKAqRtUEnTAgVXn/qccxsjTi
cA0VF0eDn7NXHjuqJ0Tn733unugInos3VbMwNMhhyJaPJTVPVJvi3tZnU1y9
AVUxqiaMR3tRvPoQbpG09ZuFSAOKqxw8o0p7a3rxgboi3n38MiFyjau4XPd8
XNF40PzONrwkOOOqgqYMtMnp61f6pFzyTLpAZ5UgrmJUTRhLq0REENly9KIy
heAWjn721FAk5XlbBxpFpJ28RUNZd5vQhKgSacuug9LmV9+ImGrRJ7bCI/GC
vAPPoo8mau+3ogqfrmykrUQYqxhVE8bS2d7c2KrSklZpOsEzSFWJya61F5WS
slWjNqAJ0bmrTY5RZTbDCSHqCVFnTx9vr2rRp+klheMlvQnLrHaKKvvwmaak
OFAVo2qCBhQlKTzkCcKib5LHDEJV7jS2T+XkC71BE6I9J+pQ0Zy4iks3n8fm
qBZ9rt17RXM1tKSx5T2q3qEimpLiQFWMqgnj8XW63VHPJbh1owYrzN+3dmBg
ULCvCvVrqh861sT9J2/REEW9iWXh5UdY6qAlSANtwotftNORFAdxFaNqwlga
xVwiXaZ61VHHJXj136oKrlppiXrBpUL2FGMdVBMiadOBM3cYsuijiddyVVJc
XK6MvEtOFOcnr5SJYEGXZEETxqGzMV01+1G5R2blN1mpDFeVnt5+9wSJ/x7S
0t5Yz7Hhp6fvNr0h5WpMiPOzoEuyoAma6OzsVIxZeGS4qhRc/BP1kZsP23BX
xGDo7O5ziS0PTCcnKY4JcX4WdEkWNEEnmBxUkXd0O0SWio5QkvbGYkqvNSMp
rtTrpPjx0Bjnp23fWqq7JNVb4xqhquCugkYyTt9BveMJI5dxmQyaLfqlXvZI
vEDG5gwTxfmnfHGtoEdVKC0CVIUhPGv9aBNWvK/wNu6KGCSyB6qkuFNTXrFi
QpwfVAVUhSyij9Y6iEop3aye3YQfqnaMKnv/qWdKV2FAnB9UxRBVhYHCcvvR
a/SnNp+Cs/+Mh8cvVElxB8/WT/1SmuL8rMlXAVUhFwZKinJggJ9W6RpXwajT
2A2RvQW30CySouOQYKwCqqIJBqrKhRvP0B9ZyfWnuCti8Lx532UvKo3NITEp
7n8AVQFV0QTTVKVb0e8WL+HtrUQjFtx1YQPiCtU58nca20m/MqgKqIommBZX
OXFBlfZW9+dr3BVhCZ09fZy4CsG+qoEBkp81gLgKqIomGCUp7z52O4hKo7Ku
4a4IqyivfYqE+tLN5+ReFsYqoCqaYJSq7D91G/l/8yv9j9IAxtKvHPDfc9kj
QdJD6olFoCqgKppgjqogMUGSgoQFd0VYyI2GNvTdnrxE5t7doCrGrirK1sIv
z7MT2dJvHg9hTlwlMuuaQ2QpruO6WI/oSI1jZKm8Y2pJcaOAuIqRq0qrREhw
xXLlUEdjEUGImkdlNDFEUuoevmbIQRhs5cnLD+gbzjh9h6wLwljFyFVF3iiV
NspVrxR1BMFl2q5NyoEB3t5Kt3hJt4Luo4qNin0nVUlxz9rISYoDVTFyVflK
u5hHcDNlo5OvmaAqFTLVIsXFG89wV4TlvP3QbS8qjcmuJeVqoCqgKopWmYgg
hNmy757nwL5vbVdPn2tcBT+tkvSECmAsxyUPkYDffqR1UhwDInKgKsxUFUWL
ROUVMpVXKJXf6Ar2sYrOfg5MAaThewrqtN8umwkROVAVZqqKJJ4YhZA5cRU0
JncQlUYfJWdMDpAOEyJyoCrMVJUJwKsq5MYPAcrAGZEDVTFEVcElLKSvdQJU
gD0iB6qiZROoM11vGcaxCul5WQDpMCEiB6rChCboBC5VoSKHHCAdJkTkWNAl
WdAEncCiKurn3dzJft4NoBNQFVAVTWCJq1D0bD5AJ5CvAqqiCfolhbp9hAA6
gbEKqIom6FcV6vY8BOgEVAVURRM0qwql+zMDdAKqAqqiCZrjKpSeJQHQCcRV
QFU0QaekNL34QNa5VwB2YKwCqqIJOlUl4nANCWd0AswAVAVURRO0+QZZ54kD
DAFUBVRlSHUQdxHBFX8X0aBndtyvHPBLveyReEEBaW9sAeIqoCqtdWKVE/AK
O7/9OT2OUXqtGQ1UKm+1TP5WwECAsYqxq4qiIZ6XUiQWobEK/arS2d3Hia0I
TL8yMAhpb+wBVMXYVWUYZTMarmBQlWNlD9BA5W7TG6oLAugEVAVUZUgVVxlf
VSidILe/77KLKInLhbQ3AwZjRG6IFV2SBU3QRGcDhrFKb7/y3NUm7TdKBZgG
3ojcECu6JAuaoAlFYyGWuApgwGCNyKlhQZdkQRN0AlQFmBRcETk1LOiSLGiC
TuA9DAgwCCaOyG2leLtUFnRJFjRBJ0BSgEmZOCJHkT+DqjCqCToBqgJMysQR
OVCVSYtgQRN0AlQF0A9QFe2LYEETdPUNEBZAD0Y8B1Rl0iJY0ARdfYMcJwOM
DBiraF8EC5qgn28AgE6AqmhfBAuaoJ9vAIBOgKpoXwQLmqCrb4CwAHoAcRXt
i2BBE3T1DXKcDDAyYKyifREsaIJ+vgEAOgGqon0RLGiCfr4BADoBqqJ9ESxo
gq6+AcIC6AHEVbQvggVN0NU3yHEyKMIQiiCxFBiraF8EC5qgn29M8JOpvM0Q
P8vw6pH+Wf0AVdG+CBY0QT/fmOAnU3mbIX6W4dUj/bP6AaqifREsaII2/gAA
hFbyopBmCoffK6xs+eap5ZErgKpMWgQLmqAT2rkWYKR01GcTRGarYqhVmvnd
htgEjFW0LoIFTdAJUBVgAhqyudzsBtUrZQOP4NaPGq2AqmhfBAuaAABk0ZAt
TJfJh192ZHOFdaAqehXBgiYAAFnUZ/O+qoo8k+B9pyqAsYHJDQFW0S5NIXhF
iqEhRUsJQYialf/zqxEfA2djNwy8v+Mee0ceirrCeLWKirKlnZO/Xx/k9UXc
L0XIFNQUoaZzeHtYyr6rjqJ47pc/OcLvjwzT5lOFDfLRvwBVMRKYdn81HXtH
FspW9AeUVy9XDnU0iAiiqJmKTt+CrpxdLx9StqQQhLiRoqaotpwWUfldDSka
eIRQ1tIub29tbZUrJ//AqI92dio0f4BpXgeQC7Pur+Zj78hCKW+QSBuH/b0z
kyAyG6j4O9/Z3DAsJcpWVEQhVaqiKBERwsx0npCqsYqiuQiNtiplUqmM5K+J
WV4HkA0D7++4x96RXkidWIhEpZ2yAhTNJcPTABEluoXGQ5J4Il46NNQs4okp
mmS1VqajkZC4RCJOQU1JbyXvygz0OoBEGHh/xz32jkyUrSpF4YlbdRrT61TC
1yvXZ3OJzHryC1A0cFVBmxJJYTqXEIolDZQIi3KkHR1o0FXUQlohDPQ6gEQY
eH/HPfaONBSqWAcvWzY8Q1FSoiuqcAShXlyty/yaEkYuyo6GujoZolLMJUSS
+hYqGtIo5hHpMtUreR3323w2ADAsxj32jixaSuJHL6aLqZmfNEvQ3IFQzYB4
mc2UdkZlg5BHmQJ3NKZ/XQLKlrZQVAgAANqiVC2D4K4ECUy8mgMAAAAAAAAA
AAAAAAAAANX8f0na6PM=
              "], {{0, 311}, {370, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {370, 311}, 
            PlotRange -> {{0, 370}, {0, 311}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6bda38b5-2ac7-421c-88be-97ac18ba6964"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3f214159-82b0-499d-809a-27920d3ab22f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"19f01bc8-f7ea-4d72-a34b-ea1fa4009ead"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"bb31ef91-c6c5-444d-8eaf-411524e4b71d"],

Cell[TextData[{
 "Make an array plot of hue values ",
 Cell[BoxData[
  RowBox[{"x", "*", "y"}]], "InlineCode",ExpressionUUID->
  "c0208ca6-e3c4-473f-b2bc-a7ce09db68a3"],
 ", where ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"beec6a1b-26f0-4402-b114-bcdaa67c8cfd"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"7ea19e5a-32dc-4f7e-b0f6-62a359feb6fa"],
 " each run from 0 to 1 in steps of 0.05."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"d9e4b200-d7ab-4277-ad08-e6e49a8ba559"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c9cae5e8-3559-4114-ac52-8766a8def2b0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3EHo1/Udx/GvxtoowUGC/EOEBROJaMQfSQ8WHqyWQtmKMRDGv+bfDeO/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            "], {{0, 359}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "13c45e86-76d0-4b9b-95b0-1070ffdc8699"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3EHo1/Udx/GvxtoowUGC/EOEBROJaMQfSQ8WHqyWQtmKMRDGv+bfDeO/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              "], {{0, 359}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0ae32a49-f6eb-4918-8194-937aa7b31bee"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"05dafcdb-4b2e-4ceb-91d5-19a57bb83239"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"522d4f24-2809-459a-97b4-0e558867c0d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f43a1457-83f9-4af6-8379-39b13e5eaab5"],

Cell[TextData[{
 "Make an array plot of hue values ",
 Cell[BoxData[
  RowBox[{"x", "/", "y"}]], "InlineCode",ExpressionUUID->
  "734171bb-bcbd-433e-be5e-72a2e301fa33"],
 ", where ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"513b9bbc-e0af-4bbd-8757-b728ca2dd161"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"8acd9946-8243-46f7-86a3-7a8288f11076"],
 " each run from 1 to 50 in steps of 1."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"a21c9ce7-3acb-484f-b5c3-0be4d022e679"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d8508e77-f24d-467d-8771-b379a777649f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3VusXVWhh/Fxznk54SJXwdbYLQVtKbgJKYWG2w5YIGitQNNws1QLIk0t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            "], {{0, 359}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f67fb676-fd8e-4238-b878-41d9b92a196d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3VusXVWhh/Fxznk54SJXwdbYLQVtKbgJKYWG2w5YIGitQNNws1QLIk0t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              "], {{0, 359}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8d90c709-48d3-472b-858e-4903bcb8a052"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8d21ca44-f5d2-44a4-8364-93bb48f3c562"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e162a07c-61f3-410f-ac4a-5ef2ec40a976"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1b8896f8-8ef8-4eb6-9801-d5fcdfadc72b"],

Cell["\<\
Make an array plot of the lengths of Roman numeral strings in a \
multiplication table up to 100\[Times]100.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "13.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"509acf86-b2ca-483c-8273-d2d2789a4bc1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"47519d4b-a2f6-4734-a47b-47773372ce73"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb+PXFmSnVuSI2AdWeu3337LXXprlLOCDJq74OzsOkNgdgFB9OmXX37+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            "], {{0, 359}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d521029a-002a-4d52-8f7f-c44f888a47a6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb+PXFmSnVuSI2AdWeu3337LXXprlLOCDJq74OzsOkNgdgFB9OmXX37+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              "], {{0, 
              359}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"86c93e33-2889-4deb-868e-049f92589aa5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["13.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fd7c0384-4c85-4121-9197-7f60874e2768"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5b6a8f5f-907b-41d5-ac94-3ab303f3079e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5ad645a7-34f0-4402-a79d-0bd77b51c90c"],

Cell["Make a 20\[Times]20 addition table.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+13.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"4d9cb6e3-fca0-4d49-b8cd-bcd53dd99a01"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d184ffe0-d292-4ab0-8e9c-3de8d11886f9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnbGLel16gCdJkzL/Qv4B67SWqQY2pJtml+wsab4Mu4Fga7NY2tlNZSUk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            "], {{0, 377}, {470, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{470, 377},
          PlotRange->{{0, 470}, {0, 377}}]], "ExerciseOutput",
         ImageSize->{474, 377},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f4dc6b0c-53b0-4de7-95d4-cec3b125882c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnbGLel16gCdJkzL/Qv4B67SWqQY2pJtml+wsab4Mu4Fga7NY2tlNZSUk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              "], {{0, 377}, {470, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {470, 377}, 
            PlotRange -> {{0, 470}, {0, 377}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6185c61a-67e3-4edc-aced-f0351129ce6d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x13.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"35d77462-392a-4655-a676-a338b8a3fc70"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3f8fb0a7-66d2-4d1f-80b5-6fb8ee66017b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3182ec1a-f2ff-4f3c-87c5-20c37d81401f"],

Cell["\<\
Make a 10\[Times]10 grid of randomly colored random integers between 0 and 10 \
that have random size up to 32.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+13.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"99f968d3-666f-444f-8089-b4adfa5d3b21"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"881e68c6-dfbb-4b23-8c5f-cdb05aacf7aa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnXlwG1ee3zfJVjkVV7KZ2trUzFYyO8nu/pGsPbaz3ti7W9kZ2+N4xjOe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            "], {{0, 271}, {271, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{271, 271},
          PlotRange->{{0, 271}, {0, 271}}]], "ExerciseOutput",
         ImageSize->{275, 271},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b2316f86-f24b-4042-a692-3d418afc9b00"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnXlwG1ee3zfJVjkVV7KZ2trUzFYyO8nu/pGsPbaz3ti7W9kZ2+N4xjOe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              "], {{0, 271}, {271, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {271, 271}, 
            PlotRange -> {{0, 271}, {0, 271}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e136a64f-9352-4eff-aa8b-5b964bd339e4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x13.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3b658249-91da-4e45-9e6a-ade518c55d84"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5720a1b5-b4f2-4147-8fa7-9f8d6760d8a5"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a8bf5181-4db2-409b-8440-49c6a42ed65f"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Arrays, or Lists of Lists: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 13  Arrays, or Lists of Lists", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
13-arrays-or-lists-of-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+13.1", "13.1", "+13.2", "13.2", "13.3", "13.4", "13.5", "13.6", 
         "13.7", "13.8", "13.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+13.1", "13.1", "+13.2", "13.2", "13.3", "13.4", "13.5", "13.6", "13.7",
       "13.8", "13.9"}, "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[36238, 665, 813, 26, 
  70, "Input", "ExpressionUUID" -> "20ef7fd0-5e83-430f-9490-27b1b6058fd9",
   CellTags->"FirstInputCell"],
  Cell[46363, 914, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1101183e-7e9d-40a5-b467-78ee2dab58e9",
   CellTags->"FirstInputCell"],
  Cell[57047, 1174, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e72228c9-f450-457f-998f-56d872484a4a",
   CellTags->"FirstInputCell"],
  Cell[103224, 2017, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7069f45a-000a-4240-8282-f38bf604af35",
   CellTags->"FirstInputCell"],
  Cell[281565, 5026, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f61f55f5-1fb4-4b77-8e71-00f97ec54d83",
   CellTags->"FirstInputCell"],
  Cell[318494, 5719, 813, 26, 
  70, "Input", "ExpressionUUID" -> "19f01bc8-f7ea-4d72-a34b-ea1fa4009ead",
   CellTags->"FirstInputCell"],
  Cell[332700, 6042, 813, 26, 
  70, "Input", "ExpressionUUID" -> "522d4f24-2809-459a-97b4-0e558867c0d1",
   CellTags->"FirstInputCell"],
  Cell[359746, 6575, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e162a07c-61f3-410f-ac4a-5ef2ec40a976",
   CellTags->"FirstInputCell"],
  Cell[402302, 7358, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5b6a8f5f-907b-41d5-ac94-3ab303f3079e",
   CellTags->"FirstInputCell"],
  Cell[430001, 7896, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3f8fb0a7-66d2-4d1f-80b5-6fb8ee66017b",
   CellTags->"FirstInputCell"],
  Cell[478348, 8775, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5720a1b5-b4f2-4147-8fa7-9f8d6760d8a5",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 537254, 9995}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[648, 22, 426, 9, 70, "Exercise", "ExpressionUUID" -> \
"ddf51b66-08c8-424d-98d6-34035603136c",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1099, 35, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"58693a64-7a3f-43ba-8618-64ee718bd6a9"],
Cell[1738, 56, 33893, 584, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8c1c7650-5750-4799-b753-d5202f0e55c7"]
}, Closed]],
Cell[CellGroupData[{
Cell[35668, 645, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"7997b0a9-0766-4eb8-8e77-729b4da137c0"],
Cell[36238, 665, 813, 26, 70, "Input", "ExpressionUUID" -> \
"20ef7fd0-5e83-430f-9490-27b1b6058fd9",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37088, 696, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"481506c9-d18e-4f40-abbb-d42c1848bf42"],
Cell[37375, 707, 443, 9, 70, "Exercise", "ExpressionUUID" -> \
"289bf582-9e60-4bc8-a3c5-80d64aa07fe0",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[37843, 720, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"85197fa6-8e75-476c-b726-f72f0a0cbd01"],
Cell[38482, 741, 7274, 148, 70, "ExerciseOutput", "ExpressionUUID" -> \
"bd70a4ca-ae7b-451c-8dad-f6b77789c4d2"]
}, Closed]],
Cell[CellGroupData[{
Cell[45793, 894, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2afab326-4782-4fb2-948b-f8dd6f82b47e"],
Cell[46363, 914, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1101183e-7e9d-40a5-b467-78ee2dab58e9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47225, 946, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3c281862-8a8b-4abf-993d-a67e5fc10b0e"],
Cell[47512, 957, 475, 10, 70, "Exercise", "ExpressionUUID" -> \
"7645a2b1-0cc4-4898-b1f9-23c25c6a4b97",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[48012, 971, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8d411774-6def-4919-8d1f-e84a21b8c422"],
Cell[48671, 993, 7769, 156, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1e7a1f54-2559-4448-bca3-eaadcb5d9129"]
}, Closed]],
Cell[CellGroupData[{
Cell[56477, 1154, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3d9aa51c-9f9d-43e3-9ef8-48594aea30c3"],
Cell[57047, 1174, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e72228c9-f450-457f-998f-56d872484a4a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57909, 1206, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7df24551-6f67-4c63-8e8d-a474353fa59f"],
Cell[58196, 1217, 519, 12, 70, "Exercise", "ExpressionUUID" -> \
"aa148f43-a8f2-443d-b1e5-6cb2a46ee47e",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[58740, 1233, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"785a6af2-d7ae-4fe8-84ee-d1d43bc44491"],
Cell[59399, 1255, 43218, 737, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8858954f-3976-40c3-9f12-77a65e2db953"]
}, Closed]],
Cell[CellGroupData[{
Cell[102654, 1997, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"dd25a6a3-e368-4d4e-a07d-c2c668841189"],
Cell[103224, 2017, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7069f45a-000a-4240-8282-f38bf604af35",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104086, 2049, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f812da1a-609a-4a67-a23c-166e59048b25"],
Cell[104373, 2060, 589, 13, 70, "Exercise", "ExpressionUUID" -> \
"8711e540-e23f-4d9f-973c-87892985b14f",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[104987, 2077, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"fd24cfa0-18c9-4c67-8d49-bac10b5a11e2"],
Cell[105626, 2098, 175332, 2903, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a271132d-ef1e-4481-ad17-4f25a22b96b8"]
}, Closed]],
Cell[CellGroupData[{
Cell[280995, 5006, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b11bc8e9-c2ac-4513-af26-2c37719d53aa"],
Cell[281565, 5026, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f61f55f5-1fb4-4b77-8e71-00f97ec54d83",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[282427, 5058, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"eb968c75-c0f2-4fe6-b73f-292f7399cdaa"],
Cell[282714, 5069, 677, 17, 70, "Exercise", "ExpressionUUID" -> \
"8cefb201-81ae-4083-ad56-0418620e7268",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[283416, 5090, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"54338a06-f126-4955-8366-3b7701d89181"],
Cell[284055, 5111, 33832, 583, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6bda38b5-2ac7-421c-88be-97ac18ba6964"]
}, Closed]],
Cell[CellGroupData[{
Cell[317924, 5699, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3f214159-82b0-499d-809a-27920d3ab22f"],
Cell[318494, 5719, 813, 26, 70, "Input", "ExpressionUUID" -> \
"19f01bc8-f7ea-4d72-a34b-ea1fa4009ead",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[319356, 5751, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"bb31ef91-c6c5-444d-8eaf-411524e4b71d"],
Cell[319643, 5762, 800, 21, 70, "Exercise", "ExpressionUUID" -> \
"d9e4b200-d7ab-4277-ad08-e6e49a8ba559",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[320468, 5787, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c9cae5e8-3559-4114-ac52-8766a8def2b0"],
Cell[321107, 5808, 10986, 209, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0ae32a49-f6eb-4918-8194-937aa7b31bee"]
}, Closed]],
Cell[CellGroupData[{
Cell[332130, 6022, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"05dafcdb-4b2e-4ceb-91d5-19a57bb83239"],
Cell[332700, 6042, 813, 26, 70, "Input", "ExpressionUUID" -> \
"522d4f24-2809-459a-97b4-0e558867c0d1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[333562, 6074, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f43a1457-83f9-4af6-8379-39b13e5eaab5"],
Cell[333849, 6085, 798, 21, 70, "Exercise", "ExpressionUUID" -> \
"a21c9ce7-3acb-484f-b5c3-0be4d022e679",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[334672, 6110, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d8508e77-f24d-467d-8771-b379a777649f"],
Cell[335311, 6131, 23828, 419, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8d90c709-48d3-472b-858e-4903bcb8a052"]
}, Closed]],
Cell[CellGroupData[{
Cell[359176, 6555, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"8d21ca44-f5d2-44a4-8364-93bb48f3c562"],
Cell[359746, 6575, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e162a07c-61f3-410f-ac4a-5ef2ec40a976",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[360608, 6607, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1b8896f8-8ef8-4eb6-9801-d5fcdfadc72b"],
Cell[360895, 6618, 501, 12, 70, "Exercise", "ExpressionUUID" -> \
"509acf86-b2ca-483c-8273-d2d2789a4bc1",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[361421, 6634, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"47519d4b-a2f6-4734-a47b-47773372ce73"],
Cell[362060, 6655, 39635, 678, 70, "ExerciseOutput", "ExpressionUUID" -> \
"86c93e33-2889-4deb-868e-049f92589aa5"]
}, Closed]],
Cell[CellGroupData[{
Cell[401732, 7338, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"fd7c0384-4c85-4121-9197-7f60874e2768"],
Cell[402302, 7358, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5b6a8f5f-907b-41d5-ac94-3ab303f3079e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[403164, 7390, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5ad645a7-34f0-4402-a79d-0bd77b51c90c"],
Cell[403451, 7401, 421, 9, 70, "Exercise", "ExpressionUUID" -> \
"4d9cb6e3-fca0-4d49-b8cd-bcd53dd99a01",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[403897, 7414, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d184ffe0-d292-4ab0-8e9c-3de8d11886f9"],
Cell[404536, 7435, 24857, 436, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6185c61a-67e3-4edc-aced-f0351129ce6d"]
}, Closed]],
Cell[CellGroupData[{
Cell[429430, 7876, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"35d77462-392a-4655-a676-a338b8a3fc70"],
Cell[430001, 7896, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3f8fb0a7-66d2-4d1f-80b5-6fb8ee66017b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[430863, 7928, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3182ec1a-f2ff-4f3c-87c5-20c37d81401f"],
Cell[431150, 7939, 553, 13, 70, "Exercise", "ExpressionUUID" -> \
"99f968d3-666f-444f-8089-b4adfa5d3b21",
 CounterAssignments->{{"SectionNumber", 13}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[431728, 7956, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"881e68c6-dfbb-4b23-8c5f-cdb05aacf7aa"],
Cell[432387, 7978, 45353, 772, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e136a64f-9352-4eff-aa8b-5b964bd339e4"]
}, Closed]],
Cell[CellGroupData[{
Cell[477777, 8755, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"3b658249-91da-4e45-9e6a-ade518c55d84"],
Cell[478348, 8775, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5720a1b5-b4f2-4147-8fa7-9f8d6760d8a5",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[479188, 8805, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a8bf5181-4db2-409b-8440-49c6a42ed65f"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature YQcSoqqYKl@oLkYc3qYEXlAS *)
