(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1165662,      23388]
NotebookOptionsPosition[   1062899,      21167]
NotebookOutlinePosition[   1127313,      22490]
CellTagsIndexPosition[   1127232,      22485]
WindowTitle->Strings and Text: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Join two copies of the string ",
 Cell[BoxData[
 "\"\<Hello\>\""], "InlineCode",ExpressionUUID->
  "bb54e618-51a5-46dd-9543-e35b898ea299"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"42e323f9-0cf4-4d2e-86f0-3c962878c893"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"20b1d90f-da96-4df7-83d5-1ba9b5a0856a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztla+v2zAQx62NDE7aX7B/IHhoUuBQpDeNlbynNU8jXdU3aSoNCwwLCwoK
KgoKMTIxMSkJCAkJCDAxCMju7CZNu7ittA1M6kmpHPfuc1//uMv7p+8P/itC
yMsb+Hl4/OluNo/bz2/h5cvq5dvzavn10+rH8nm5+fD0GibfwfMRHhz3d7vb
PzRVcl61HYxkJfi++ZtsWXMmZNffBlcsjTJWH99rGkW7prPBmUNIwFoY8hCG
YXuB3VVpFPMjq+NZnNLKKpyHUHpM9jfBexmhC5uER4Q4JnzGFPcIiTgiRewS
J7Y5GpZmj/nPc527i5gQl2vidXgvwcWN+Gz4QaySaqLctSvvwHN6WBPn2Vwm
4kbl53BDi8XRYT9R3opwAdsE5kR5eUn50ZNsE6omymMxalMJRAzKa5Z6JsBd
01pdUj4L18rJIqKMFkVBKcuTNSEehnflFrEBKyuW4TCr1Lxy40n8HRNFikMv
5kY5aPOgjChFNt355LDnap8QTJuX1R4TkqC2KbfBe5nolTuD6ZWhcn3hyQ7U
dnBIDRSPCyFzyo1nVh3OkgYA8fcKlS/IFK7RqFxlPh4jqAW2qnemsmaVW+G/
3T013JYq35JTW1iUG89iuM46l4s1bpzFeFvVkEumi3M2tyi3wu0V2uomQ88a
00TMCNeeJB86Kwvx/gl1oUIVKvcSdcqeVW6FW5TjoqTAjfFCXjVNLdI4LVEM
TvoJ7xAO9yzAY9STuiJqUWAiJ6THZc71lpZh6/bjom7biudxyrqhIeeV6m+B
H3rLmXLP9ANZ5sdTdXxaIyjTU1T2ZYaltchK7bkbPd112gwH5GFvGW8L1tS4
SyILRrYb5JiwKVx8iyDgOvy6dbIFmx6salvzie7hr0mT1Z7S9vWdZav2hKAn
hg7/p/C73e3/t18/8n58
            "], {{0, 19}, {62, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{62, 19},
          PlotRange->{{0, 62}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{66, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "390eb9cf-6d94-485b-b7d9-c0eb1fb962fe"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztla+v2zAQx62NDE7aX7B/IHhoUuBQpDeNlbynNU8jXdU3aSoNCwwLCwoK
KgoKMTIxMSkJCAkJCDAxCMju7CZNu7ittA1M6kmpHPfuc1//uMv7p+8P/itC
yMsb+Hl4/OluNo/bz2/h5cvq5dvzavn10+rH8nm5+fD0GibfwfMRHhz3d7vb
PzRVcl61HYxkJfi++ZtsWXMmZNffBlcsjTJWH99rGkW7prPBmUNIwFoY8hCG
YXuB3VVpFPMjq+NZnNLKKpyHUHpM9jfBexmhC5uER4Q4JnzGFPcIiTgiRewS
J7Y5GpZmj/nPc527i5gQl2vidXgvwcWN+Gz4QaySaqLctSvvwHN6WBPn2Vwm
4kbl53BDi8XRYT9R3opwAdsE5kR5eUn50ZNsE6omymMxalMJRAzKa5Z6JsBd
01pdUj4L18rJIqKMFkVBKcuTNSEehnflFrEBKyuW4TCr1Lxy40n8HRNFikMv
5kY5aPOgjChFNt355LDnap8QTJuX1R4TkqC2KbfBe5nolTuD6ZWhcn3hyQ7U
dnBIDRSPCyFzyo1nVh3OkgYA8fcKlS/IFK7RqFxlPh4jqAW2qnemsmaVW+G/
3T013JYq35JTW1iUG89iuM46l4s1bpzFeFvVkEumi3M2tyi3wu0V2uomQ88a
00TMCNeeJB86Kwvx/gl1oUIVKvcSdcqeVW6FW5TjoqTAjfFCXjVNLdI4LVEM
TvoJ7xAO9yzAY9STuiJqUWAiJ6THZc71lpZh6/bjom7biudxyrqhIeeV6m+B
H3rLmXLP9ANZ5sdTdXxaIyjTU1T2ZYaltchK7bkbPd112gwH5GFvGW8L1tS4
SyILRrYb5JiwKVx8iyDgOvy6dbIFmx6salvzie7hr0mT1Z7S9vWdZav2hKAn
hg7/p/C73e3/t18/8n58
              "], {{0, 19}, {62, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {62, 19}, 
            PlotRange -> {{0, 62}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1c97ee3f-69ec-41ed-93c8-27c65c895c57"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e4e72894-1370-4b8b-91f4-9fd2658eb33f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e53b458f-8531-417f-a505-d71aeb9f3ea8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7e68ff12-c66b-480b-b2fc-77c6de5912d2"],

Cell["Make a single string of the whole alphabet, in uppercase.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"9c2dde74-ae05-44af-a54e-48b807f732a7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cb6872b1-e8d1-4671-97a9-5df9fdee2d05"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK/vrcgVJ61Z2aR/Qf8BdC1yFck2dZjd9LFZ80reNmmwOOS4Sc3UoFCk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            "], {{0, 19}, {207, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{207, 19},
          PlotRange->{{0, 207}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{211, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "81368754-260f-4eb2-95a1-12c16b44a8df"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK/vrcgVJ61Z2aR/Qf8BdC1yFck2dZjd9LFZ80reNmmwOOS4Sc3UoFCk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              "], {{0, 19}, {207, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {207, 19}, 
            PlotRange -> {{0, 207}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3c6ddb67-dff6-4423-b63e-3f8ad1826b2f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7d856e8f-b9f0-416c-9a7f-dfab0e48d50e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"90ef0f13-9498-4ed9-a47c-efb82f5edd48"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c958d39d-7219-4cf8-a8a6-8981d14eefc8"],

Cell["Generate a string of the alphabet in reverse order.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"366e9897-91a3-4127-ae99-f7ea957eb9c5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2b8f5531-97eb-43a4-b6eb-3875073a9b88"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWL+r7cYRFk6TMuC/IP+A6rRbphI4pFNjkyeT5lk8B4JaNUFVUCdCQJWa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            "], {{0, 19}, {173, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{173, 19},
          PlotRange->{{0, 173}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{177, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f844f12b-57b1-46ee-bf3b-47d257589b42"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWL+r7cYRFk6TMuC/IP+A6rRbphI4pFNjkyeT5lk8B4JaNUFVUCdCQJWa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              "], {{0, 19}, {173, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {173, 19}, 
            PlotRange -> {{0, 173}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4e85e3fc-ab2c-4c5f-b8d9-72b5d3fdf5e7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e22dce0b-9555-45a6-967d-1458747bbddc"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7ee15136-490a-48a4-9f15-9733dbe455d9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4e68b3dc-f4d8-4a87-bfb0-796de9080ea3"],

Cell[TextData[{
 "Join 100 copies of the string ",
 Cell[BoxData[
 "\"\<AGCT\>\""], "InlineCode",ExpressionUUID->
  "af15b2ad-9cb8-4bcb-a185-dff7f9d78574"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"a8fdf939-dd09-4247-9f4e-f4a18997129a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"50ac2bb3-bd86-424c-88a1-28c74fd15293"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT2v8sgZQEnSpMxfyB+gTkuZytJG6Wh2lZdVmg3ajRTRuqN0R+eKioqK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            "], {{0, 152}, {498, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{498, 152},
          PlotRange->{{0, 498}, {0, 152}}]], "ExerciseOutput",
         ImageSize->{502, 152},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ed17f0fe-4e20-4c78-b170-a8947259c0e3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT2v8sgZQEnSpMxfyB+gTkuZytJG6Wh2lZdVmg3ajRTRuqN0R+eKioqK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              "], {{0, 152}, {498, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {498, 152}, 
            PlotRange -> {{0, 498}, {0, 152}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f3a1ddcf-9977-45b5-aad7-ff0f8d711fb6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"94f7bb7f-0a42-4ca9-95c2-5613ca76ce1a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2f473eb5-fc7d-4cc6-9585-ae706d97fbc1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"996c4121-7052-4a86-b326-63cdaf83ede6"],

Cell[TextData[{
 "Use ",
 StyleBox["StringTake",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["StringJoin",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Alphabet",
  FontFamily->"Source Sans Pro"],
 " to get ",
 Cell[BoxData[
 "\"\<abcdef\>\""], "InlineCode",ExpressionUUID->
  "9662f5f6-8aff-4482-9228-cbd7cfb7cb53"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"b138d230-db07-4b1a-9646-959e8de347f4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"80598025-3653-4539-b985-d710644b6fcb"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oLAkuNSwKNJVZSF36uZUsl3tVapCwwLNwoKCjBYF
hQSZmJiYBJhsgUGAiUHA1uN8XDa3e9KxSr2REjkz9ryZ98b5ePfzJn6DEHp4
5143t7/xfn+bfH3vPr5tH37cbzffv2x/be43+893b53zg3s+uQfWp1f7J8y2
nKuuf+kxowSX+vnMoqZFSZu2u5KCBQil7Er0uvHMncueOSaLCHmLS3mlNB4i
RPiLoUWOUZCbq3FTuLy7ao1mjZ0JthwjlAsLS2MvlLbYO3tO0FS4grZn522B
Ec7F/CnrMgoGGlBWtQO0qy4m+W7w44TpEUpzOm0OqQBaes3T0DuCKHYV4wm6
E9m4NSA+rSx3I0yw823pDKNdXslWUkiBuQHoQRJyYJIfYB1kGqosvU6ECU6z
OK3UqW99uog2nB0IIIUeum8TqDllrWIUllRZ01YRwOZ1wxcj3GvVNjRDwLMZ
us6mMeua1GVhnaWxiydqKZ4gzlXKkVQ5aW04+A/KnvoeugMy+Eg4mQnvWTHw
gOMYiIPp8lrPY2Zl4Uv6A0OSNkuJdQPV1tM8zmOmqgSdWwTQJgdovkybNceh
6nAJLcZejpAHM2PKaGT+sWvozoXW0B34g2Z9RVbQIB9pVKcFiYOxawOEozBt
pGpZiWFdmKnHMKWtPjqxd4SddA1nIiK1FpXXGuedVwImJMy40vooyrxs7Rra
9USiiZMkCUathVM1CPEYwInoVuqApRRUUzWZHCEo5osEGD9U00jHzbEf7vUC
2m/rus5c+G321kWe/CF62H52sQfP0/ND4GLk1f4n+wuABpBc
            "], {{0, 19}, {
            41, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{41, 19},
          PlotRange->{{0, 41}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{45, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3fc6c5c5-20b2-4f65-9158-b2dd6f9524c3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oLAkuNSwKNJVZSF36uZUsl3tVapCwwLNwoKCjBYF
hQSZmJiYBJhsgUGAiUHA1uN8XDa3e9KxSr2REjkz9ryZ98b5ePfzJn6DEHp4
5143t7/xfn+bfH3vPr5tH37cbzffv2x/be43+893b53zg3s+uQfWp1f7J8y2
nKuuf+kxowSX+vnMoqZFSZu2u5KCBQil7Er0uvHMncueOSaLCHmLS3mlNB4i
RPiLoUWOUZCbq3FTuLy7ao1mjZ0JthwjlAsLS2MvlLbYO3tO0FS4grZn522B
Ec7F/CnrMgoGGlBWtQO0qy4m+W7w44TpEUpzOm0OqQBaes3T0DuCKHYV4wm6
E9m4NSA+rSx3I0yw823pDKNdXslWUkiBuQHoQRJyYJIfYB1kGqosvU6ECU6z
OK3UqW99uog2nB0IIIUeum8TqDllrWIUllRZ01YRwOZ1wxcj3GvVNjRDwLMZ
us6mMeua1GVhnaWxiydqKZ4gzlXKkVQ5aW04+A/KnvoeugMy+Eg4mQnvWTHw
gOMYiIPp8lrPY2Zl4Uv6A0OSNkuJdQPV1tM8zmOmqgSdWwTQJgdovkybNceh
6nAJLcZejpAHM2PKaGT+sWvozoXW0B34g2Z9RVbQIB9pVKcFiYOxawOEozBt
pGpZiWFdmKnHMKWtPjqxd4SddA1nIiK1FpXXGuedVwImJMy40vooyrxs7Rra
9USiiZMkCUathVM1CPEYwInoVuqApRRUUzWZHCEo5osEGD9U00jHzbEf7vUC
2m/rus5c+G321kWe/CF62H52sQfP0/ND4GLk1f4n+wuABpBc
              "], {{0, 19}, {
              41, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {41, 19}, 
            PlotRange -> {{0, 41}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d7bd4894-51b3-4d0c-83b5-c04dff5eb8b7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ff1f98ec-adb1-4f94-bd65-61da4be3d84b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5c7697f5-81d9-4f95-a891-d535ecda2b40"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1345aae2-ffbc-4b11-898e-573d4390bc1e"],

Cell[TextData[{
 "Create a column with increasing numbers of letters from the string ",
 Cell[BoxData[
 "\"\<this is about strings\>\""], "InlineCode",ExpressionUUID->
  "d71800a4-093e-4276-80c1-c59ea8bec8ab"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"4a42d6c5-12b2-436d-985c-f3d88df45ddf"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d5361d90-5587-4461-88c7-2d4c8f325312"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3a2zq+gdwHHamsr+C/0H0LXIKma2UxezO73Zqbll7namExuXqcLholBR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            "], {{0, 395}, {114, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{114, 395},
          PlotRange->{{0, 114}, {0, 395}}]], "ExerciseOutput",
         ImageSize->{118, 395},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1bb447bd-cea8-48e8-91cc-836477ec14b9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3a2zq+gdwHHamsr+C/0H0LXIKma2UxezO73Zqbll7namExuXqcLholBR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              "], {{0, 395}, {114, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {114, 395}, 
            PlotRange -> {{0, 114}, {0, 395}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fa476e13-d6b7-4ae6-98a0-35cc3f3db198"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3773126d-0b53-402a-bfd0-f4f520bcdca1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"28af6916-d339-4e05-b78a-73c2f930e9c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8c617548-5f94-4d5e-8912-e121e01fbaff"],

Cell["\<\
Make a bar chart of the lengths of the words in \[OpenCurlyDoubleQuote]A long \
time ago, in a galaxy far, far away\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"419a5f04-845e-4b7a-8e05-347990eae1b0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9f7e91c9-7803-47a7-96bf-0c14c1e932a2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnTGPIskZhufs5EL/Akv+F06dWLr0Ts6c3Mlb50va0p7VloPOyIiISCYi
ISIhmATJmoCEgICEgABZBEgEBEgELVVLuNm59TZzs6NtVHzz1VfPo7k9jj7N
O1vvV48KWiP+8MM/vnW/ubu7+/nr+o9vv//Xn96///7f3/2u/o+/ZD//9GP2
7m/fZP989+O793/84bf1k/+t//n7V3d358enz+Oce+UqAMCvwRsA0Ba8AQBt
wRsA0Bb3kbf+QQAgGjAGALQFbwBAW/AGAHyGajHuPb2PMZhumhfwBgC8yHE1
cq6zKk/lun5QrKtPl/AGALzIcpB3H1bb9XKxXG12h4Y28AYAvMxqlNd+6A2G
/aI+boz2jUvukjf7EcE0f/3z72/69dZ/P5ssh5nrLz483PVcPj9+uoQrQIB6
a/v/fHejL7xxIzaTjivGZ1sc5pnLFngDZMEbcXJ46GVPr0T6j+vmBbwBAuCN
eCmPx7J6/iTeAAHwhjHwBgiAN4yBN0AAvGEM7sCCAHjDGBgDBMAbxsAbIADe
MAbeAAHwhjHwBgiAN4yBN0AAvGEMvAEC4A1jcB8WBMAbxsAYIADeMAbeAAHw
hjHwBgiAN4yBN0AAvGEMvAEC4A1j4A0QAG8Yg/uwIADeMAbGAAHwhjHwBgiA
N4yBN0AAvGEMvAEC4A1j4A0QAG8Yg/spIADeMAbGAAHwhjHwBgiAN4yBN0AA
vBEnh3H3l8+HdcWo8bHSeAMkwBtRUi5zV8w2u/1uu93umx8SizdAALwRI+V6
7FzncTadzpaHy0t4AwTAGzGyfew7lw8fJsNe/Wqlv21ccpe82Y8IpsEbUVJV
H1+bHO6dG2/K/1/BFSAA3oiR1TB3/dn50X6euWzReGMUb4AAeCNKDqv+x9sp
g+mmeQVvgAB4I17K47Gsnj+JN0AAvGEMvAEC4A1j4A0QAG8YgzuwIADeMAbG
AAHwhjHwBgiAN4yBN0AAvGEMvAEC4A1j4A0QAG8YA2+AAHjDGNyHBQHwhjEw
BgiAN4yBN0AAvGEMvAEC4A1j4A0QAG8YA2+AAHjDGHgDBMAbxuA+LAiAN4yB
MUAAvGEMvAEC4A1j4A0QAG8YA2+AAHjDGHgDBMAbxsAbIADeMAb3YUEAvGEM
jAEC4A1j4A0QAG9ETLksXNH8UOkT3gAR8Ea0lA+dWhL5Em+AOHgjUta1NYp+
N+9w3gB58EaMlJsH53q7UzXOi0V5ccldIvPz1EXf9EsgRWahzIA3vhyZ3fEl
DGsjdAaTyahwWW842TXU8SbnDZkpul2KsUEVAG98OXrWarOcz2az+eyxm2WD
yeJQfbqENxhUAfTsBf3oW6tylHd+/Tol0F+3BXgjNfTtBb1EsVZ4g0EVIIq9
oIQo1gpvMKgCRLEXlBDFWuENBlWAKPaCEqJYqzf5vTa8kRpR7AUlRLFWnDcY
VAGi2AtKiGKt8AaDKkAUe0EJUawV3mBQBYhiLyghirXCGwyqAFHsBSVEsVZ4
g0EVIIq9oIQo1gpvMKgCRLEXlBDFWnEflkEVIIq9oIQo1orzBoMqQBR7QQlR
rBXeYFAFiGIvKCGKtcIbDKoAUewFJUSxVniDQRUgir2ghCjWCm8wqAJEsReU
EMVa4Q0GVYAo9oISolgr7sMyqAJEsReUEMVacd5gUAWIYi8oIYq1whsMqgBR
7AUlRLFWeINBFSCKvaCEKNYKbzCoAkSxF5QQxVrhDQZVgCj2ghKiWCu8waAK
EMVeUEIUa8V9WAZVgCj2ghKiWCvOGwyqAFHsBSVEsVZ4g0EVIIq9oARNa7Ub
d7MPL0c60+3FB8TiDQZVAE17QTt61mo76Tg32NcPHnsuGx0bl/AGgyqAnr2g
Hz1rddytV9uzLbbTvsvxBoMqjZ69oB9la1U+9PLaEsV42XwWbzCoAijbC6rR
tFbVL/8+LDKXzRsHDndJwL/+K5jxRv3gdl8yXcgg1vit65CJUOKN1TBz/dn5
0WGeuXxx6Y0Qc9EOS97Q0K9+aFxDROu5Oq7659co51sq94/r5hW8oTzCBjSu
IeK6uToej2X1/Em8oTzCBjSuISLgXOEN5RE2oHENEQHnCm8oj7ABjWuICDhX
eEN5hA1oXENEwLni92GVR9iAxjVEBJwrzhvKI2xA4xoiAs4V3lAeYQMa1xAR
cK7whvIIG9C4hoiAc4U3lEfYgMY1RAScK7yhPMIGNK4hIuBccT9FeYQNaFxD
RMC54ryhPMIGNK4hIuBc4Q3lETagcQ0RAecKbyiPsAGNa4gIOFd4Q3mEDWhc
Q0TAucIbyiNsQOMaIgLOFd5QHmEDGtcQEXCuuA+rPMIGNK4hIuBccd5QHmED
GtcQEXCu8IbyCBvQuIaIgHOFN5RH2IDGNUQEnCu8oTzCBjSuISLgXOEN5RE2
oHENEQHnCm8oj7ABjWuICDhX3IdVHmEDGtcQEXCuOG8oj7ABjWuICDhXeEN5
hA1oXENE67mqtqNu9vR6ZDDdNK/gDeURNqBxDRFt52o7KVw23Fenw2rsXGfd
+JRYvKE8wgY0riGi7VztV9Ppan9+VM6dyxbHT5fwhvIIG9C4hohr52o3zF12
P2t+KD3eUB5hAxrXEHHFXJXbWce5YnAhjVPjPqzk3VimqFXE7b5k6qZxJRG+
pTfKzeT8jujs/I5oVV2Yg/MGETSeSETb0ifd5pmi4P0NItqOEI0biAhYOt4g
gsYTiQhYOt4ggsYTiQhYOt4ggsYTiQhYOt4ggsYTiQhYOr8PSwSNJxIRsHTO
G0TQeCIRAUvHG0TQeCIRAUvHG0TQeCIRAUvHG0TQeCIRAUvHG0TQeCIRAUvH
G0TQeCIRAUvnPiwRNJ5IRMDSOW8QQeOJRAQsHW8QQeOJRAQsHW8QQeOJRAQs
HW8QQeOJRAQsHW8QQeOJRAQsnfspRNB4IhEBS+e8QQSNJxIRsHS8QQSNJxIR
sHS8QQSNJxIRsHS8QQSNJxIRsHS8QQSNJxIRsHS8QQSNJxIRsHTuwxJB44lE
BCyd8wYRNJ5IRMDS8QYRNJ5IRMDS8QYRNJ5IxHWlH1djlw0Pl0/iDSJoPJGI
K0rfzofndz/z0fHyebxBBI0nEtG69HLZzXvjYac+b+ANIq4ZIRqPP+K60qt1
feR4wRtNnn7sm34xRQojaDyFCH/l+xsve+PZ/ybwYzNFiUR4GtcU4a/zxhJv
ECEa4WlcU4S/yhvlavQl728wRUQET6FxDRH+Km+8CN4ggsYTifB4w3rFNiI8
jWuK8HjDesU2IjyNa4rwQb3x7PdhmSIigqfQuIYIz3nDesU2IjyNa4rweMN6
xTYiPI1rivB4w3rFNiI8jWuK8HjDesU2IjyNa4rweMN6xTYiPI1rivB4w3rF
NiI8jWuK8EG9wX1YIm5dB41riPCcN6xXbCPC07imCI83rFdsI8LTuKYIjzes
V2wjwtO4pgiPN6xXbCPC07imCI83rFdsI8LTuKYIjzesV2wjwtO4pggf1Bvc
hyXi1nXQuIYIz3nDesU2IjyNa4rweMN6xTYiPI1rivB4w3rFNiI8jWuK8HjD
esU2IjyNa4rweMN6xTYiPI1rivBBvcH9FCJuXQeNa4jwnDesV2wjwtO4pgiP
N6xXbCPC07imCI83rFdsI8LTuKYI39ob5fS++PA2RvG4ufiEWLxBBI0nEuFb
euOwGDh3vy1P2+m9y4YHvEEE3kgvwrf0xnKQZYPl+VG1zF22aJw48AYRNJ5I
hG/tjaI/2394eBhkxfzSGwCQMp/zxmKQf/TG/t7l81fPG698HwCImla7ezft
uXxcnk7l5sG5zrp67fvgDQCrtNzdh3E3ezqTjJb7178P3gCwyhW7uzwey+r5
k3gDIB1C7W68AZAOt9vdeAPAKuxuALgp/wN/jl34
            "], {{0, 224}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 224},
          PlotRange->{{0, 360}, {0, 224}}]], "ExerciseOutput",
         ImageSize->{364, 224},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b066a8c0-4f02-4b41-af68-626c5863208a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnTGPIskZhufs5EL/Akv+F06dWLr0Ts6c3Mlb50va0p7VloPOyIiISCYi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              "], {{0, 224}, {360, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 224}, 
            PlotRange -> {{0, 360}, {0, 224}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f34018dc-37f1-43b4-9a28-fea04fa7857d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8d2073df-680e-4bd8-b89d-cdfd04d4b5b5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8bb82d34-3e6e-4c4b-b5a3-7acbd9c7e11a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7450d635-c018-4f6b-8843-eb043e8ff0a2"],

Cell["\<\
Find the string length of the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"4e56235f-2411-4a34-9cbb-7408bc498fe5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c216d9eb-316c-48f6-a67b-a9c22f83f7fd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztU6+L3UAQDq2pLPQvKFRHV3Zl1cKVumfu6MtR8/q4KxyxCxUr162Ligq0
REXFLBRi1sTERMSEwoqImBUr0pnNy0uO9vkWbiDLzs7M982vvL75chU9C4Lg
/gUcV9cP5O7uOv7wEpSPh/vPt4f9p/eHr/vb/d3bm+fw+Aq+N/DhfXqS/1WG
RutusLPihrbMs7yo+vEvrn1d5VlWVI19/O5Mq3UzurM+aFVkWQ64W7dKUFiV
kFdwt00WBqjhEVBl3MbRlpzAK6F4Bsd8Q9cxH1XN6dkm9ursyMruFN9mwYwr
NWgpRdYeDGMdwZWpFW+sCAaicajEijxNWu5mDO1fRg1WUvmCSmANxdwSDhWQ
3S4MiACuURKw6BmhSQCB9SuXBq5YeQhXk4XL+WxpHJOAVisXMz7IIBly1YgW
FF0P5XiKQYYrV18yTG+dmkH3MCqbrkqg6LjDBhvMNhRmrOni7PoCsiLHtO1r
6DrhynU5EMUFJp7Ai2x8N3B2Ry4Fm9uy05sN6fJjsAhN2yXbuRyolNSn8Y4J
OTuGpZkS6ifMhRCMzhPDIdq6SFkc86TQJccRLBtgmwSc0tq4sU1jjPj+88dM
K6TgDNOIYl52VjHoDm+tM01xDP3UUymkFCic4t7RRHXb/cROk+S8bA0mx5Yq
B8jj3TeAAAwPwk9cqvslwlPVfrC4JxtU53tYI2DGIp63fadSXFuuzNnJjy/g
eT1a2yqJ98psMLCHGntoswhpy9ZYawoOGe42XLh+NPFcOT83Ok719EicktHZ
Gkm1/fcmC1u6LJJtOV0Hm9XDdEmcHYZhdBetI1jtBesfjpdgnuRflt8YlINi

            "], {{0, 19}, {36, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{36, 19},
          PlotRange->{{0, 36}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{40, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1cc45f8a-58e0-434c-897f-bd3c7af1d5e6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztU6+L3UAQDq2pLPQvKFRHV3Zl1cKVumfu6MtR8/q4KxyxCxUr162Ligq0
REXFLBRi1sTERMSEwoqImBUr0pnNy0uO9vkWbiDLzs7M982vvL75chU9C4Lg
/gUcV9cP5O7uOv7wEpSPh/vPt4f9p/eHr/vb/d3bm+fw+Aq+N/DhfXqS/1WG
RutusLPihrbMs7yo+vEvrn1d5VlWVI19/O5Mq3UzurM+aFVkWQ64W7dKUFiV
kFdwt00WBqjhEVBl3MbRlpzAK6F4Bsd8Q9cxH1XN6dkm9ursyMruFN9mwYwr
NWgpRdYeDGMdwZWpFW+sCAaicajEijxNWu5mDO1fRg1WUvmCSmANxdwSDhWQ
3S4MiACuURKw6BmhSQCB9SuXBq5YeQhXk4XL+WxpHJOAVisXMz7IIBly1YgW
FF0P5XiKQYYrV18yTG+dmkH3MCqbrkqg6LjDBhvMNhRmrOni7PoCsiLHtO1r
6DrhynU5EMUFJp7Ai2x8N3B2Ry4Fm9uy05sN6fJjsAhN2yXbuRyolNSn8Y4J
OTuGpZkS6ifMhRCMzhPDIdq6SFkc86TQJccRLBtgmwSc0tq4sU1jjPj+88dM
K6TgDNOIYl52VjHoDm+tM01xDP3UUymkFCic4t7RRHXb/cROk+S8bA0mx5Yq
B8jj3TeAAAwPwk9cqvslwlPVfrC4JxtU53tYI2DGIp63fadSXFuuzNnJjy/g
eT1a2yqJ98psMLCHGntoswhpy9ZYawoOGe42XLh+NPFcOT83Ok719EicktHZ
Gkm1/fcmC1u6LJJtOV0Hm9XDdEmcHYZhdBetI1jtBesfjpdgnuRflt8YlINi

              "], {{0, 19}, {36, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {36, 19}, 
            PlotRange -> {{0, 36}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f9e0d90f-98b0-4e07-b91b-5eab6f546582"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b18f14b1-2799-43ba-b02d-cede76a8c1ee"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d8f377e7-5450-4b53-b121-ab83153945ec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3ea9618e-f5d3-4bf8-be25-b8bb2e56d6d7"],

Cell["\<\
Find how many words are in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"56d2e8c9-7344-47f0-8f16-3670741aa27a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc42df85-5043-41ed-9dc5-867856de5e5b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUqFuwzAQtTYyOGl0ZD8QPGo4FKnTWEmrNdVIV7WTptCyQDOzoKKgoqCQ
joSYmIQEmIQEBJgEGGRnJ1njdHBgoE9KZD/fPd+988P8feJdIYS2N/CbzD7x
ZjPzn29h87Lavi1Xi9en1cdiudg8zq+BvIPvHj69bi74U9Sl4DZEWZf5iMuk
OqWoMmfsxFSCx1EUHRJRdRQnGNlwyBdxxtxR/kiKnWFSw7DQM7s2ASdFK6tU
rQBaP3QRcpnUXIumKQII96K6V2R0atJNWFOHGLmUmXJTOMCEWS6oDMjpPhty
FSOQHxd9SB5pOd8HpbZOJav+OknONEUEXXi5GnKSgjF+0m9LXbNDSsldhFPZ
2Ch2+nCoKXwoIORW4aaqSPTOh9BHWx7HCHPr9vbUiYsBW8SQvs/rYVimw3Zt
30ocWhsJJcFuDSvPDxLRxRdJAIx/yK3GYyhzyi1JqSfmx90gS0YJoRR+hASd
5tFoCiPo2T0CGLwoh9oOaTPHc+xM0b0zc1l+MC8LrY+cM5amKe8facMpuD7S
1A7/rlkz3M2oouPXfT67C/4jvgG/qVIV
            "], {{0, 19}, {28, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{28, 19},
          PlotRange->{{0, 28}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{32, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bf52e85a-a90b-40a3-ba2b-549660898a2a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUqFuwzAQtTYyOGl0ZD8QPGo4FKnTWEmrNdVIV7WTptCyQDOzoKKgoqCQ
joSYmIQEmIQEBJgEGGRnJ1njdHBgoE9KZD/fPd+988P8feJdIYS2N/CbzD7x
ZjPzn29h87Lavi1Xi9en1cdiudg8zq+BvIPvHj69bi74U9Sl4DZEWZf5iMuk
OqWoMmfsxFSCx1EUHRJRdRQnGNlwyBdxxtxR/kiKnWFSw7DQM7s2ASdFK6tU
rQBaP3QRcpnUXIumKQII96K6V2R0atJNWFOHGLmUmXJTOMCEWS6oDMjpPhty
FSOQHxd9SB5pOd8HpbZOJav+OknONEUEXXi5GnKSgjF+0m9LXbNDSsldhFPZ
2Ch2+nCoKXwoIORW4aaqSPTOh9BHWx7HCHPr9vbUiYsBW8SQvs/rYVimw3Zt
30ocWhsJJcFuDSvPDxLRxRdJAIx/yK3GYyhzyi1JqSfmx90gS0YJoRR+hASd
5tFoCiPo2T0CGLwoh9oOaTPHc+xM0b0zc1l+MC8LrY+cM5amKe8facMpuD7S
1A7/rlkz3M2oouPXfT67C/4jvgG/qVIV
              "], {{0, 19}, {28, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {28, 19}, 
            PlotRange -> {{0, 28}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6d5d7adb-b74c-4810-b081-ed781bdf91fb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fd4bf173-ba8c-4fb9-8e71-e110cbce8b7f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8fb11e56-71ce-440c-aeb8-7389f80d7087"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3b4eed79-3157-454f-b214-68a62a87b11d"],

Cell["\<\
Find the first sentence in the Wikipedia article about \
\[OpenCurlyDoubleQuote]strings\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"562740bc-f429-43a6-b11b-dc06ffc02a6a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c956e8d0-e133-4336-8125-9803edf47c8a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXTGPrbgVJkmTMn8hbQrqtJSpkHaVjmZXWVZpNmg3UkRLR0lHE1EhRaKi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            "], {{0, 42}, {339, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{339, 42},
          PlotRange->{{0, 339}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{343, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "920cb367-b99c-4514-a061-29994f7b6cc9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXTGPrbgVJkmTMn8hbQrqtJSpkHaVjmZXWVZpNmg3UkRLR0lHE1EhRaKi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              "], {{0, 42}, {339, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {339, 42}, 
            PlotRange -> {{0, 339}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9be7fd6f-b0ab-406f-858e-971286ad20e7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"04f16c2a-6e8f-4ed9-9fa2-f74018c8aaea"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"60901d3f-35d2-43a4-ac46-13a7fefdebc1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"571b47c3-bc25-4baa-bb62-6ab434de26d5"],

Cell["\<\
Make a string from the first letters of all sentences in the Wikipedia \
article about computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"c849d3cf-86a9-4e03-a98b-b9aef5e17a99"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6d8b5674-de12-4dd8-8302-79a0e620ffc0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfc2rtsqW35NkkmH+hYxDHGfqLBkJHQIZOEiatE0IdKSTEMzQ2TOLNCQO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            "], {{0, 152}, {513, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{513, 152},
          PlotRange->{{0, 513}, {0, 152}}]], "ExerciseOutput",
         ImageSize->{517, 152},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "25e41ded-4d0e-4a35-8e6d-e332a1462256"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfc2rtsqW35NkkmH+hYxDHGfqLBkJHQIZOEiatE0IdKSTEMzQ2TOLNCQO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              "], {{0, 152}, {513, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {513, 152}, 
            PlotRange -> {{0, 513}, {0, 152}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"582fc9f3-bfc6-4c24-bb7a-4b464e751a3b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd078108-8d1d-48ad-8333-8fa1904a8744"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a8ba9ee2-9684-49ce-8b0a-f5f4a4cc43d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2b4164d6-fa73-4e48-9953-d9cb1b0b8977"],

Cell[TextData[{
 "Find the maximum word length among English words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "16930a23-8c23-430c-8353-d77ee8128c71"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"4ce6fcc7-8ac0-4949-be45-db033ae00569"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a84e75e8-4df7-42aa-ae89-04f5cadf1818"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkS1vhEAQhietqWqa9Bf0D5yuXVlFck0d5i6FSw0lXJMGew6Jw6FQKBQK
g1qzhgrMCsyaFSswiBV0+MgVWlHbvsludp5M3vnYu/3r1r4AgOMVXtvdO/G8
nf94g8GTc3w5ONbzg/NmHSzvfn+J8BbPNZ7h3f8jtYLmWZpmtJYLViHL8pLL
biKqSjcwaLrdtO57zWJ3wSCuFGbyxAQIxGiT2IgD9K1j2wjpwDT3kfnFVEe1
evanAQCh7aozRGAm3bpfFhKAk5gC3cqGF/FomfFlmm4yhHZSz14shFluvXRU
1ByrrCqjr2AnHItEM5d0GIWE5x3p7stF5v7UfCcKc6wRFaxijFLK5QcSI0i5
VIKXPva+GRZSRQasFVDVlDE5x8QtxbfRf3wd7q/9JecP6hNpT5bo
            "], {{0, 
            19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6b782211-ac30-4599-8c22-b7ed222f58dd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkS1vhEAQhietqWqa9Bf0D5yuXVlFck0d5i6FSw0lXJMGew6Jw6FQKBQK
g1qzhgrMCsyaFSswiBV0+MgVWlHbvsludp5M3vnYu/3r1r4AgOMVXtvdO/G8
nf94g8GTc3w5ONbzg/NmHSzvfn+J8BbPNZ7h3f8jtYLmWZpmtJYLViHL8pLL
biKqSjcwaLrdtO57zWJ3wSCuFGbyxAQIxGiT2IgD9K1j2wjpwDT3kfnFVEe1
evanAQCh7aozRGAm3bpfFhKAk5gC3cqGF/FomfFlmm4yhHZSz14shFluvXRU
1ByrrCqjr2AnHItEM5d0GIWE5x3p7stF5v7UfCcKc6wRFaxijFLK5QcSI0i5
VIKXPva+GRZSRQasFVDVlDE5x8QtxbfRf3wd7q/9JecP6hNpT5bo
              "], {{0, 
              19}, {14, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"da61299d-b3ad-45fe-99e5-c91113db1631"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"12a4f4f3-24c9-469f-825a-32bc9587db4f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a7dc3687-9da4-4df8-b86c-b869ca02ce5f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e4258642-1af3-4e53-9afa-c5c3f1b30bdf"],

Cell[TextData[{
 "Count the number of words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"93531c21-dbad-4d1c-882c-78706e907cb7"],
 " that start with \[OpenCurlyDoubleQuote]q\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"55e66289-8e0e-459a-a4b7-d25b08da08b8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b40062e6-6b4a-42b4-a48c-6b5098c615f7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUS1vwzAQtTYyOGnaD9gfCB4NHKrUaayk1ZpqpKvaSZNpmGFYWFCQUVBQ
SFCJiUlIQIhJgYGJQYB3zkeTqNr2A7Yn2fI7v3e+8z2s3ufeFULocAPbfPnp
7vdL/HwL5GV7eNts169P24/1Zr1/XF1D8A7WPSx7Nv8wquS8UvWZ17LMEpqk
R6G6yAkUExStvKQYNSBH2Sp1QR0baDY0y0+gU0HLBjh5k7nKYn83Ax6y1q5j
YA4RtijuwdHPm4I6GCMIpPKoHoovwBF0dhW6yAlYdxEtEPLFqE/JAngrHYc0
cwe7DJ3BLjIfIfeozlKbHOFs8nMTu2Gh7WVHwsBfNG0uWG+vSwqcVvUPduA8
jX2MSZSyjMDvsb7Py16apNz2zpW5QAZjcaPerSLQ4XT0trbzzCMoCcd5wbnQ
pqC+R5JSVHlsZ0ry07hxt/+WtuzZdJwBU0VCzhTHI7GpbC1j+3eotZRS1b8L
/yy+ANL8+ac=
            "], {{0, 19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c533fc32-4d62-47e8-9207-b122048550c4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUS1vwzAQtTYyOGnaD9gfCB4NHKrUaayk1ZpqpKvaSZNpmGFYWFCQUVBQ
SFCJiUlIQIhJgYGJQYB3zkeTqNr2A7Yn2fI7v3e+8z2s3ufeFULocAPbfPnp
7vdL/HwL5GV7eNts169P24/1Zr1/XF1D8A7WPSx7Nv8wquS8UvWZ17LMEpqk
R6G6yAkUExStvKQYNSBH2Sp1QR0baDY0y0+gU0HLBjh5k7nKYn83Ax6y1q5j
YA4RtijuwdHPm4I6GCMIpPKoHoovwBF0dhW6yAlYdxEtEPLFqE/JAngrHYc0
cwe7DJ3BLjIfIfeozlKbHOFs8nMTu2Gh7WVHwsBfNG0uWG+vSwqcVvUPduA8
jX2MSZSyjMDvsb7Py16apNz2zpW5QAZjcaPerSLQ4XT0trbzzCMoCcd5wbnQ
pqC+R5JSVHlsZ0ry07hxt/+WtuzZdJwBU0VCzhTHI7GpbC1j+3eotZRS1b8L
/yy+ANL8+ac=
              "], {{0, 19}, {21, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c991075a-94e7-4132-b6f1-8f669b064e12"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b858f464-54eb-45bb-8c91-0d4ee1cda9ff"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2eaad816-2419-4597-bba2-9ad2a6d04899"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"17693fdd-d4af-4d3e-af12-7490dfa55d48"],

Cell[TextData[{
 "Make a line plot of the lengths of the first 1000 words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "06926757-191b-428d-8b93-83160805cd78"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"90caae1e-2968-4971-b604-8e6063ee9b9b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"995101a3-6e86-4f2d-aa0f-c429b5fb533b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvdt7VVX2513v2zd9+f4L71/Qt33bl33b7/PeLqoUo9ZPU11aFbtVSguD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            "], {{0, 193}, {303, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{303, 193},
          PlotRange->{{0, 303}, {0, 193}}]], "ExerciseOutput",
         ImageSize->{307, 193},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c3c7768f-ee36-46ea-91a2-ea1a2458d137"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvdt7VVX2513v2zd9+f4L71/Qt33bl33b7/PeLqoUo9ZPU11aFbtVSguD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              "], {{0, 193}, {303, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {303, 193}, 
            PlotRange -> {{0, 303}, {0, 193}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e5aa5013-7a1b-4240-bfd9-4d6d9e933822"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"73a25bce-fc3d-418d-a917-b10c5c3fc078"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7adbded1-1d45-465c-b791-657afbe47068"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a94210d9-f677-4264-b08b-7c1def4403f4"],

Cell[TextData[{
 "Use ",
 StyleBox["StringJoin",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Characters",
  FontFamily->"Source Sans Pro"],
 " to make a word cloud of all letters in the words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "d6fd8ece-0a2b-42f0-8420-411c19440e8c"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}},ExpressionUUID->"d10696bb-2ff5-4470-afff-758cad2d89c9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3b725fa-fa28-4774-ba65-22c479690501"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvVtsW1e6oJmewQDTbwP0S02/DXCe5iGDaqQbjfPQgBFk+nSjgXQ61Y1u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            "], {{0, 363}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 363},
          PlotRange->{{0, 360}, {0, 363}}]], "ExerciseOutput",
         ImageSize->{364, 363},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "17a7ec8f-7e8d-460b-af08-b733e9e46dce"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvVtsW1e6oJmewQDTbwP0S02/DXCe5iGDaqQbjfPQgBFk+nSjgXQ61Y1u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              "], {{0, 363}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 363}, 
            PlotRange -> {{0, 360}, {0, 363}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"642c3127-019d-490e-9d3d-c00f651aeb3c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.15"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1b5a004f-4ad4-4fd7-b0be-e39bfe99ff4b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a850eb55-cb01-45b2-8bf2-be7bd0668adf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"144ed64c-acc9-4ca7-9cd7-b4f71059bd3a"],

Cell[TextData[{
 "Use ",
 StyleBox["StringReverse",
  FontFamily->"Source Sans Pro"],
 " to make a word cloud of the last letters in the words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "b0afc979-afc6-49c3-ad1f-a5bbe49201ba"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.16", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 16}, {
   "WebOnly", 0}},ExpressionUUID->"be1d985b-73d8-4f34-9caa-2a2c02c63ce5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6881b995-f0b1-4466-bb41-ecf0bb192730"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVtsG1ea57O7GGAfF5iX3XlboJ8DzCC7WPRb0Mjsbl6CHs8EDYzHmTE2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            "], {{0, 350}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 350},
          PlotRange->{{0, 360}, {0, 350}}]], "ExerciseOutput",
         ImageSize->{364, 350},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6524b463-ffbc-41e1-8524-9133e288b3b9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVtsG1ea57O7GGAfF5iX3XlboJ8DzCC7WPRb0Mjsbl6CHs8EDYzHmTE2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              "], {{0, 350}, {360, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 350}, 
            PlotRange -> {{0, 360}, {0, 350}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"177efa46-9bfe-463d-832d-43ad83f6c867"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.16"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f2f88419-a9e4-403a-97e1-c5b1cf395aff"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3d7f654a-7a27-44a4-9390-9b289db9b62f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7bc4d258-6ccc-4fee-860f-a65d137dfa53"],

Cell["Find the Roman numerals for the year 1959.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.17", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 17}, {
   "WebOnly", 0}},ExpressionUUID->"1e73eb9c-140f-4cfe-a4c1-fbef328f66fc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eed0d7de-e4a8-4cba-96c2-300b586d37c5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oH/A+GhgUaSrykLudOtTyTbaq1QtDQs0MwsyWhQU
FBJkYhISEhCyJCDAJMAgnbH3K7q7ZlHRPilRPJk3fnkzztfHX/fsAyHk5RPc
7h/+BJvNw/b7Z1j8WL/8fF6vnr6tf6+eV5u7x48Q/AIXhQufpxtuuAqj2gku
q/Ei1JYyFfneHtdDm4uUsYjFSa7317B6vePZ7C1SJN+p/WR7qCar7hjvC6gE
8cmIACe4HE6UbgsBEiiDC9sV+J4Qtk3iEB+4NosszeFI8PNLhMFYqkBSziAz
bp3mQaWwyBqsmbmd4vwgcmyk2znEDadRRli/6LxBtsocaYE11SCUCjNXArGA
a2dDCaK2Bfgw4hfFufUJIaGwDA5ElXoPIqzpKKGoX/X0n6xFJZiPBtU6A05x
mANMiAU4R4seTY5BLd/6rzOaQwuqucuLrGuUQOnISQ/S6jIhFKVkJJSdbQUh
iZMaoJJaYPH55C2yrlLiXMWpU8MsQTSDTgmNU0bDrB3boxLnSdm/reQ91jVK
+ipBQ6BFNN3PEmrvsO+FRStczaGC9tOkPNezZlxkHZWM7ymxLUMJejIVaGGy
OSVQl6A5OC5hesxlzQz7GaW7uusalUc4pPUyC62PS6210gpQw9k7K9E8PE2U
4jj3bhRdxzN/Oqz1x8mPx8Fcq6T7VTjQiDfGLrLqjJFLUPi3+IZq7/PRBzjH
NfqTnOZ2CXYcAOaN2b3hhv+Jvyzge3Q=
            "], {{0, 19}, {46, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{46, 19},
          PlotRange->{{0, 46}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{50, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "359f1455-fb71-456d-9f08-20a377f790e2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVC2P3DAQtVpSWKm/oH/A+GhgUaSrykLudOtTyTbaq1QtDQs0MwsyWhQU
FBJkYhISEhCyJCDAJMAgnbH3K7q7ZlHRPilRPJk3fnkzztfHX/fsAyHk5RPc
7h/+BJvNw/b7Z1j8WL/8fF6vnr6tf6+eV5u7x48Q/AIXhQufpxtuuAqj2gku
q/Ei1JYyFfneHtdDm4uUsYjFSa7317B6vePZ7C1SJN+p/WR7qCar7hjvC6gE
8cmIACe4HE6UbgsBEiiDC9sV+J4Qtk3iEB+4NosszeFI8PNLhMFYqkBSziAz
bp3mQaWwyBqsmbmd4vwgcmyk2znEDadRRli/6LxBtsocaYE11SCUCjNXArGA
a2dDCaK2Bfgw4hfFufUJIaGwDA5ElXoPIqzpKKGoX/X0n6xFJZiPBtU6A05x
mANMiAU4R4seTY5BLd/6rzOaQwuqucuLrGuUQOnISQ/S6jIhFKVkJJSdbQUh
iZMaoJJaYPH55C2yrlLiXMWpU8MsQTSDTgmNU0bDrB3boxLnSdm/reQ91jVK
+ipBQ6BFNN3PEmrvsO+FRStczaGC9tOkPNezZlxkHZWM7ymxLUMJejIVaGGy
OSVQl6A5OC5hesxlzQz7GaW7uusalUc4pPUyC62PS6210gpQw9k7K9E8PE2U
4jj3bhRdxzN/Oqz1x8mPx8Fcq6T7VTjQiDfGLrLqjJFLUPi3+IZq7/PRBzjH
NfqTnOZ2CXYcAOaN2b3hhv+Jvyzge3Q=
              "], {{0, 19}, {46, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {46, 19}, 
            PlotRange -> {{0, 46}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f115f480-9385-4415-90e3-71dba39b7b98"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.17"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b559ff90-e9ec-464f-bef6-27915c784177"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"aaa7e23c-8dcf-484e-864a-9440e6fc24cd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d07b644b-f86e-4fc1-82ae-475656273e0d"],

Cell["\<\
Find the maximum string length of any Roman-numeral year from 1 to 2020.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.18", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 18}, {
   "WebOnly", 0}},ExpressionUUID->"578dce09-4b6f-4d65-832b-c34f73c12bf8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"410673a6-5be7-4b7a-a3e5-cddd6859ca9b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkC9vhDAYxpvNTC1L9gn2BU7PVk6R3DJ35i7jLjOMcEsW7Dkk7lwVCoVC
YaowNTU1FRhMBaITFQj2UrjjtuyP3Z6khPfHw/M+cLN6nq/PEELbC7jMl684
CJbh/RUMD972aeO5j3fei7txg9vVOcBrOJdw+vvun0lLzivdTnPN8yzNciqV
OUKZhsgqKhsLWkZ8C2YDJ3zgXVUkO98BsmcjEWTtxKV9SfYpYXGyXYA1PjhP
W0XgXCRTA8PwJ2erVSULYiMz2X3v1CxGo3wxJX6VOeTWbAefhfd6YrzvyUfQ
milF5VAAl/0TA3+SU9L3SajgvH4TC4ScKJWqqSUNYdksUnavgz4oZrqiBB9n
7NPadD9K60brXzx/UO+ZOqhH
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5653aecf-6451-4ed6-b81a-74285fd38acb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkC9vhDAYxpvNTC1L9gn2BU7PVk6R3DJ35i7jLjOMcEsW7Dkk7lwVCoVC
YaowNTU1FRhMBaITFQj2UrjjtuyP3Z6khPfHw/M+cLN6nq/PEELbC7jMl684
CJbh/RUMD972aeO5j3fei7txg9vVOcBrOJdw+vvun0lLzivdTnPN8yzNciqV
OUKZhsgqKhsLWkZ8C2YDJ3zgXVUkO98BsmcjEWTtxKV9SfYpYXGyXYA1PjhP
W0XgXCRTA8PwJ2erVSULYiMz2X3v1CxGo3wxJX6VOeTWbAefhfd6YrzvyUfQ
milF5VAAl/0TA3+SU9L3SajgvH4TC4ScKJWqqSUNYdksUnavgz4oZrqiBB9n
7NPadD9K60brXzx/UO+ZOqhH
              "], {{0, 19}, {14, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dd07f90f-46d9-4c66-b5d1-0c19d35a6226"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.18"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e3fbaa13-a1b9-423a-b18c-643e1ad0ac61"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"26bb7a2d-fb98-4d33-8f2e-6b704e4832c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b74249c3-2eef-4bd9-a9b8-acd8996bb0df"],

Cell["\<\
Make a word cloud from the first characters of the Roman numerals up to 100.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.19", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 19}, {
   "WebOnly", 0}},ExpressionUUID->"22b03d27-3d95-468b-99a4-889604d40fc8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6f86de60-991b-46f9-9743-b19357fdd148"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztml1rIlcYx0N708t+hUI/QUHoTaG96EVvd+ltYKWpLQtpSAqmuZEUGhfq
UppShoBtGpqVRUtdiDZKYlZQG7NRYoJpMFG7k6zJGseX+DJRRrM9E3dTdeY5
npk5a2nYh5OQDOOZn8f/ed6Ob+m/uPHpa0NDQxNvoF83bhk/GB+/9dXNN9E/
H49OfG4YHfnko9EvRwwj4+/qX0cX30c/76Ef8e9nr+yV0TM2vGmc9c9YAz3D
xPjmghylh5y7bH4T0/uIGcZnsu1XVc1YzySHp93A8KxlW9qh2WAIesSMX/3K
sMEASH43ltcIXWTHoMmZPXVL/cLOnbPQgrtNq6daZraDM/tiZU3QopWPwDXR
IBWMPOYoQIuWjYQpSwUjj4WkQAVaNMFrpSiVBiy8QKJBDVo0/sRESSqZMCiP
xb1zqtCi5eNRClKBd4rBwVJnvrRWwObRJpWGi4E+sjDbfDnUyJqcRYNUMmFw
azsP6Wq616rpXZVSKR8ZgRcaXZmXyty2mNOnXCqwPMzR7ACgRSvNmZVJBfb8
Hi+N3IbQhMy+AqmUM5A8tORL6iyx6ieTChyqZndKA4YWrbZ4t79UspFN4J6V
9eJ/AC0alzaAUomKUuFBeVjC6la6UvjtbdbaNfInFaWz4PL8VdYLhSdmr64K
GmFz93uxc2xB+TwNJxj4oOGL8SqhEXaeDjYujsgObek0PWy072LQvusdBq3p
NDm2kAzF7dag3badeAJlDsLaAgl2IKU19SDDbpaWv10yf7P+58bjR56IeXLJ
vgF4gMYpnJA/H/YD+XT64iwn5IsX3RdbZ7mm5CIhdj4aNE9uXW0gPvXXPQe4
YKW9GE4ejiPgdc/4H3U5va7WlZocl/To4tcSRRFhJx1/WJwn0ON63yOmjkDY
NrAKuEgtIuyCO/HvFdYuXnHEJfeSYTu93ditRgPIfAj8yXy8BoBfru0Ec1Uo
1G3DOf2Htax0+xJh/+3ymr9PXM1W2d3o1EyHEXpvfxzw2A3HZx2cl+9i6me5
BSLbkoXHaBv+vpETycvZe5NLjCcnnQsTK3uHdV8+PmbdoioeiDppK6T48FDu
PlIHmI1uIfL2mLUdSMO/wCXBzERu/BCRDTfF8pQud5tpPVfI8Ll8N01JuGkK
lUK1UpMNFOV5sGQAg7ssuPBwCumEz6TObutyd9wS16ccG7aYCyrQQqkyXAQx
uzJrWX3E6XXcxE2kkLNtKKmlgI0ph9tOA3ODJSh9llC7IzrwnH6qATYfNGPD
zQeDLX2lp4hzBSD3BLheV9HcZhA290sIfqpGbEyrpzvxaBbA1oqatqcmbExA
lPbxqgc70M3K254asOFSC4rg6w5IKm5vRlEmqxob08cLpaCt1ORmIKmYN5W0
d1RiYwIilJe2DZMfjilopqnChkv1MTgvfWG4hq0zTVg/qMCuzYONkRBRmxdX
SpDNoBw77gE7lnbStcK5ILK2vDLs+uEuqExnX3l0Gq7qJDgEUZRKwSFjOgxs
J4GvV+RLCth/Ehw5kWO31m2g14VOAfhj5rsH7ywfy2dEuAZFn44EKTZGjRjH
xT/9CWGvANjos3DBJ4bY/g8ZNuZcz7yJ8bb9sPG1J+bwmgQbtyauQ9yH2R8b
ewIFf1WgPzbm3NPo6tOFIMHGF86WsOxG64MtYHrXBFkEGTb28H16RZqQ98WG
A7GHJGcjxRaTHFAqcvkkzY6rFmyFdn2wuSfUvmAwSOyj5YWznaWSqlHc8tY7
3jT/9FeEvTYQbI3jNE1NY4PEprg1rh+29IDvf4EtPU7VOFScxl57+wf92Irj

            "], {{0, 64}, {61, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{61, 64},
          PlotRange->{{0, 61}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{65, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "df89f7ec-deaa-4818-b19f-9a0ef6746659"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztml1rIlcYx0N708t+hUI/QUHoTaG96EVvd+ltYKWpLQtpSAqmuZEUGhfq
UppShoBtGpqVRUtdiDZKYlZQG7NRYoJpMFG7k6zJGseX+DJRRrM9E3dTdeY5
npk5a2nYh5OQDOOZn8f/ed6Ob+m/uPHpa0NDQxNvoF83bhk/GB+/9dXNN9E/
H49OfG4YHfnko9EvRwwj4+/qX0cX30c/76Ef8e9nr+yV0TM2vGmc9c9YAz3D
xPjmghylh5y7bH4T0/uIGcZnsu1XVc1YzySHp93A8KxlW9qh2WAIesSMX/3K
sMEASH43ltcIXWTHoMmZPXVL/cLOnbPQgrtNq6daZraDM/tiZU3QopWPwDXR
IBWMPOYoQIuWjYQpSwUjj4WkQAVaNMFrpSiVBiy8QKJBDVo0/sRESSqZMCiP
xb1zqtCi5eNRClKBd4rBwVJnvrRWwObRJpWGi4E+sjDbfDnUyJqcRYNUMmFw
azsP6Wq616rpXZVSKR8ZgRcaXZmXyty2mNOnXCqwPMzR7ACgRSvNmZVJBfb8
Hi+N3IbQhMy+AqmUM5A8tORL6iyx6ieTChyqZndKA4YWrbZ4t79UspFN4J6V
9eJ/AC0alzaAUomKUuFBeVjC6la6UvjtbdbaNfInFaWz4PL8VdYLhSdmr64K
GmFz93uxc2xB+TwNJxj4oOGL8SqhEXaeDjYujsgObek0PWy072LQvusdBq3p
NDm2kAzF7dag3badeAJlDsLaAgl2IKU19SDDbpaWv10yf7P+58bjR56IeXLJ
vgF4gMYpnJA/H/YD+XT64iwn5IsX3RdbZ7mm5CIhdj4aNE9uXW0gPvXXPQe4
YKW9GE4ejiPgdc/4H3U5va7WlZocl/To4tcSRRFhJx1/WJwn0ON63yOmjkDY
NrAKuEgtIuyCO/HvFdYuXnHEJfeSYTu93ditRgPIfAj8yXy8BoBfru0Ec1Uo
1G3DOf2Htax0+xJh/+3ymr9PXM1W2d3o1EyHEXpvfxzw2A3HZx2cl+9i6me5
BSLbkoXHaBv+vpETycvZe5NLjCcnnQsTK3uHdV8+PmbdoioeiDppK6T48FDu
PlIHmI1uIfL2mLUdSMO/wCXBzERu/BCRDTfF8pQud5tpPVfI8Ll8N01JuGkK
lUK1UpMNFOV5sGQAg7ssuPBwCumEz6TObutyd9wS16ccG7aYCyrQQqkyXAQx
uzJrWX3E6XXcxE2kkLNtKKmlgI0ph9tOA3ODJSh9llC7IzrwnH6qATYfNGPD
zQeDLX2lp4hzBSD3BLheV9HcZhA290sIfqpGbEyrpzvxaBbA1oqatqcmbExA
lPbxqgc70M3K254asOFSC4rg6w5IKm5vRlEmqxob08cLpaCt1ORmIKmYN5W0
d1RiYwIilJe2DZMfjilopqnChkv1MTgvfWG4hq0zTVg/qMCuzYONkRBRmxdX
SpDNoBw77gE7lnbStcK5ILK2vDLs+uEuqExnX3l0Gq7qJDgEUZRKwSFjOgxs
J4GvV+RLCth/Ehw5kWO31m2g14VOAfhj5rsH7ywfy2dEuAZFn44EKTZGjRjH
xT/9CWGvANjos3DBJ4bY/g8ZNuZcz7yJ8bb9sPG1J+bwmgQbtyauQ9yH2R8b
ewIFf1WgPzbm3NPo6tOFIMHGF86WsOxG64MtYHrXBFkEGTb28H16RZqQ98WG
A7GHJGcjxRaTHFAqcvkkzY6rFmyFdn2wuSfUvmAwSOyj5YWznaWSqlHc8tY7
3jT/9FeEvTYQbI3jNE1NY4PEprg1rh+29IDvf4EtPU7VOFScxl57+wf92Irj

              "], {{0, 64}, {61, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {61, 64}, 
            PlotRange -> {{0, 61}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cc876945-732e-4caa-8ea3-c877af2493b0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.19"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"94c46cd8-38fa-4640-b381-b7a961aded9f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5850a0e8-cb0f-4fc5-9a17-7af1b3b561d7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"43bdcf5c-2b11-4cd0-baf6-31075703b1bf"],

Cell[TextData[{
 "Use ",
 StyleBox["Length",
  FontFamily->"Source Sans Pro"],
 " to find the length of the Russian alphabet."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.20", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 20}, {
   "WebOnly", 0}},ExpressionUUID->"89c81264-22b7-4d7c-be46-fbdadda9a3a8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b26c1e7c-24be-40b4-a56c-4bc2f737c71e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVUKFuhEAQ3bSmqmnSL+gPoGuRVSTX1GHuUrjUUHLXpMHikLhzKBQKtQqz
CkPSYKhYgVmzYsWaFSvoLHCU9g9uktnsvLx582Yedu8b/wohdLyBZ7P9tA+H
bfR8B8VLcHzbB97rU/Dh7b3D4+4awHvIW0jzHy4oFK+rsihx3bEFk6zFBiOU
qwnRrHKQCWt8nYToQTdZuMJQ1oqRiW0rptp0VYmNkF3Loct8J61HIRoBNar+
uRAknpirkAkw3VwtNWctKVwA/Xwmasl7WmWjZEkX4smeHKG0ETPUpDOEwk6t
pwxacZwa1bLXCyZZE8Na9mkcpH47dAvaSS30CuM4msxjuIcVVR0TvC8Tc7D8
+8s15yooF4ySCJqthIMi6LvW2ZKVYmO+J9nZOOiFhK3GKimEXPzNS0kh5d9l
LiF+AD1gltg=
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9164691c-bf4e-4751-9330-4e0a8911092e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVUKFuhEAQ3bSmqmnSL+gPoGuRVSTX1GHuUrjUUHLXpMHikLhzKBQKtQqz
CkPSYKhYgVmzYsWaFSvoLHCU9g9uktnsvLx582Yedu8b/wohdLyBZ7P9tA+H
bfR8B8VLcHzbB97rU/Dh7b3D4+4awHvIW0jzHy4oFK+rsihx3bEFk6zFBiOU
qwnRrHKQCWt8nYToQTdZuMJQ1oqRiW0rptp0VYmNkF3Loct8J61HIRoBNar+
uRAknpirkAkw3VwtNWctKVwA/Xwmasl7WmWjZEkX4smeHKG0ETPUpDOEwk6t
pwxacZwa1bLXCyZZE8Na9mkcpH47dAvaSS30CuM4msxjuIcVVR0TvC8Tc7D8
+8s15yooF4ySCJqthIMi6LvW2ZKVYmO+J9nZOOiFhK3GKimEXPzNS0kh5d9l
LiF+AD1gltg=
              "], {{0, 19}, {14, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8feec1b3-b99a-4172-81cb-c36accfdd0a7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.20"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f17a3e3b-133c-4869-8706-e7f416ea5a94"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c136599f-e001-49e5-8286-e95fec01c9ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a571310c-e335-4511-a7f1-24669e93343d"],

Cell["Generate the uppercase Greek alphabet.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.21", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 21}, {
   "WebOnly", 0}},ExpressionUUID->"13e6afb8-e5be-4394-850f-a03120bee11b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"63b446b5-078c-4fb4-a1b3-25676ca48b74"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz3PpMgRxr7EoSX/Av8BYqeEjpDOckbgO932ycka7VmyOiUjJCMjIiIi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            "], {{0, 19}, {352, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{352, 19},
          PlotRange->{{0, 352}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{356, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6446952c-9de9-453b-9376-7d72fb2a0d9b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz3PpMgRxr7EoSX/Av8BYqeEjpDOckbgO932ycka7VmyOiUjJCMjIiIi
IiJBlkVCggMSAhIcEBCQEBC87qpmGD66m5ndd1Z7EiXtama2prq6Pp76YPaP
P/7je/JbTdN++R376/sf/mV8+vQD/cvv2Zu/fvzl7z9//PDTnz/+88PPHz79
6cfv2Id/YH/+9htNg9dvF1100UUXXXTRRRdddNFFF1100UVfg/rEJbpul+P8
voo9m3rloPzSWPuUOjdyvSCvezHn1ATOndNxKKVBM0kFN4lv227RyTlQpr+R
iWK9ZDwwjk1K7TWnyxj9tBHLtGlSD+tPAmoHWSvVoqtCj1qmYRim7fh5ozDZ
mHrUE5471szcaXPXvWYWILZYyRu1WQBWkph8kcx8xK5br+0ytYFjC20FFqC2
l9RrEYlHfZEFpjZzNoZldt19d8vPbWU8YKt9wMzSxY7YxiELxDAphKKZxehW
X3tnGRSXssA6RJbjpwdztSGYMd6cNZSeTdy4kl4NqY6IppFKGeAsC4jtZO2d
aaxTSuy4FlyuzXzbnR0KgUED/j3+WpZrY1sGro3BazledBM8hMQwLCe/JeBQ
+hpT141nXaba1oBIJPU1fq0wGZNuWoxMA7+hhZXIM5zTQE7ObTqVIDrnuzoo
yvSL89PvMkGsaUfH48cqMhc2QnQUbngi4UPBrrFJOfzE8HKxClWE0nTb9X3P
4SbwpGAy+Lqmu+fn1jFF64fK1O89PNsKlKHIrcS0Wl2Ku5vdSiB/5teTe1hy
tQUWGOvY2tifOcCgoVif52x1dK6pK7y2Zja4g0l4jITC48cahCxxSMt9HA4R
w3sQxi1n8IuZVBBaVcjSXLPjBcan2EbrNdLg7kpWJWyupGERL0xbGe9QWCDM
nW00Vfb67f5qzEnecL+mkQ/713vxZYgX1KnHHEJ4zmWACVOVBJZ2d/pQeMxX
i5p97rJ/JBa7gyMtnIxGiGpvse9UU00cSHtOJY1VAIpCPNi1AmCfkbn6VonQ
Z4vRicvc4oMpC8sZx+i9y5paD2LKFFcvlmiGRNR8LnyNg4NOY3XvNtXgXELY
96jaRxYPAiddPst4dhq+4Igb/wo95Go/QWgrna7M3vqW3FZH506l1BEH5iIg
kBRH+BsrColpPxiJAbu4Xyp5eh89nuFZXeZu4WJPqBhA2VykZgiyBKpy6YWv
zeVpgo7jdtCRSqaH7nbL65th+WsRPrQOKEGWo6cmgbCwZlytAiZwjoGxBHy4
yRhBEytqMQJ9xYyxx4eGqj140grPlALK+G2bstOdrFOf7j+HD60LJjBWxVGk
5yEsTdGlOI65O9c2MdYuYQ09wYegGpoEwMF0RJ3/ljLmXSPouvTUR0x/i5j3
bnaqWF5S12aqCPEBWKmNkVKdqP0wcVt5Oyxo5bZ6CqhX6Hr7AAqcOJUGXiDI
yeyMrA9dvEsRcpJpqghaTea7qYkg+BCoa6jPZjkBpljYqcsqYY4lh9gWBps0
HWZMGFev7/hAjtVwrMIjlBXAPDcbJbu8PleQOrQWrHjrM3ZfmrCi1AHCkFha
w8e5r8NujUOishw8gg88niFmxgBuGUjdiJy6ReyFCHHlwy/zT4J101ViDk5M
urEQv5UoSDCXzXKcyijwAyA/SPoRRjNJUKnwAe5i8mqiF6foMJYWxFTDZUJw
Km/kJbF1s38PuUOL3F/a0R0/IlWXA5LyKUOVJm0eef6dPD8SdtbcVvvYmOS2
OgbMqMIHEyK27Lq2bZsqj3GGlE/3fcF7yDOIeBQY6wgbfzhUWKlnamD2WLLv
XtYLMLWiVe5cPpi5mUpXGAE0D6tVtYAP+64hbhT5jBlstwH4ocHdVCEmsJd9
nYLet7kARyo9qftx7FOULmtpbhlqw7qRUgubVhJ8Uf/QQiDpabe81mLpboXn
FAFc4GRZbizFB+5ES6jeVqaJEzLSPJcJ8YG7uJqGcO7IMSbHjg2Cn4EPXIbJ
1yN2rEaIFnqsuX/GqJOH5ZzvbcLuYUPlSmzYdAy1v+oY9/weIBRWQwgtbLMl
aVJiw6zfiBlYWCDWFW19D/ed8OHugZmsqJQH29xCUOGqbM33cOPUB6iBqvTc
0vZY4gvIf0GJnwnHdgyuSBUV885Qd6M0sCGI/CRxUSsqmndmfCgF+MBjaaqh
23HjykWx6WzOloPVxtaBZATbd/hT5grD4HF8wGq4dGhYJQ3hQkNwulJuGWDF
UFpYLBO6cWGQcMSOd6PKkBsSPDntH0zcglYBX3kpGiG00tKR9rmh2CRzy1dj
nzmMqx4g64Oa9cKeEh+w08g9tFnG4voL54unbfUZ/UPM+4e26wf1YwGcu6WD
/Fq/xwerde7LiA9ZNs5TqxKP+kj75CmGZDccrFO2+nlBX3rE2Oau4cWq5CXh
RmC+6WRGH6Fg6ivQEMeieU7MmnHoGQ1Di8BIxQuXQzatO6gj5yk+TDi8ryd6
VFgCrY/vJ/scd0ieCtxleirCss8MzOR1NBa4dIsOz8yQTvYPtzUCX3npssZp
andWGiPYNYseRryt+gE+uMEYC/vM7cbpyM+FTQmdq4UE8R6mm63WduGTtdhW
T+IDRsL5QgGf3EHWSJvSLfPj+CBpkPaKYrJrluM7OEo6vs8fp0WSVqbBZTVm
8YiZKI2KFbEybeCTiJPUwFg1l5ZnrCOEgXnbzaEgyOFtDREGAZZCPNhrNMBn
GRiNE+x+jfXqjIecG6ZpkiRx4GKDY/q9iFOADwe2AgOGhgnIY5SmIW4MYBki
OZ140cyMFMfMKjvOkff/lhdn6Z0vLTuhTGlYHplZFeCDJ/Hyqm7qInTQhU46
iW53j7fTczvMJt1pxFbaj6sd9AZayBJNKnm4LcDngOdPrIZTTcaKLPhwYJ66
Mo7jZENg2ekhW5kqWz3lCFn1OXDWITeBm95Cgalf/e+/R203/pILXEjwmEDM
PBaxZ61adNP2cr6yOZq3iRFNbg9qeZnjzzflmrwJwUrguyqNXK5C2k19EfAl
B0u+up/e5p2kz/nnaoL9/L5S8PGHxCP+62aptZ/7dIsG8BMLASc8Bdh7cM/W
0MNoczNiMJyfPjdUebfjHAJTxOcWIj2LvZ7IAxPWkRmpTv2VeJ0G2Xo42vJj
vPnSc9ePIdrE0fjEsWPmO73dzDWWhDtOKZk/feP1emAe1z2hVc3ts4A+h0FV
aAE+NeyJdTJfbqunHHFklogtA0HIeP/5t1BbHjkbfJDc623e2lmb+ULO/MZ/
rqDpGzzZ8/NJf/Motss8jf/iRSkchxerVCqz9p1fDfXKMtyS6+cXyOye9mfQ
Zuiih+afy/m4wFec/o4KDDCO7cdeBf+LLv4s8+uEv6OtXqTGSwWeMo99U5T7
yerbcTSjCosZ5+ezhkF8xXDTwuJbCxVr4Sc5Hxf4itNfp8Ap/+vOfUclv4T5
16XGtx8wX1k4w4M8gKFh1TuNeegSovjN89s0tLX0l6Cfw/m4wFec/joFTvlf
d+47KvklzL8uNb79gPnKwhkaJK5tO4Ho/3lcdNFFF1100UUXndP/ASHwrr8=

              "], {{0, 19}, {352, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {352, 19}, 
            PlotRange -> {{0, 352}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9354f202-e611-4f22-b384-5f86dac9da68"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.21"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"097373ad-c022-42a2-9ac8-f90da8a22ffa"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8ce93aa6-af72-4b48-8003-fdfbf9c8d80e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a787f14e-7959-43ff-a6b4-d4c1f9abcdf7"],

Cell["Make a bar chart of the letter numbers in \
\[OpenCurlyDoubleQuote]wolfram\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.22", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 22}, {
   "WebOnly", 0}},ExpressionUUID->"0bcde8b0-c28a-4c9a-ae87-db8641061ecd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"23dab4cf-420a-447b-b678-798b9003bdcf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3T9vI9cZxWElblLmA6TJt3Abd2ltBKlteK+dZgKsgwlcTMdOlSo2U7Fh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            "], {{0, 221}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 221},
          PlotRange->{{0, 360}, {0, 221}}]], "ExerciseOutput",
         ImageSize->{364, 221},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2d0be751-6849-45fe-bc01-2cbf50b81f6a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3T9vI9cZxWElblLmA6TJt3Abd2ltBKlteK+dZgKsgwlcTMdOlSo2U7Fh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              "], {{0, 221}, {360, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 221}, 
            PlotRange -> {{0, 360}, {0, 221}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8e188d4c-ae13-444d-8504-5ff9a12b7654"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.22"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2e81db96-ad4e-41ef-882e-16b08ac07a07"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e854ae90-bd6b-4dbb-b86e-cb4766913a85"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"635498fc-52de-4bea-a0c3-0fd6f8e89f1f"],

Cell[TextData[{
 "Use ",
 StyleBox["FromLetterNumber",
  FontFamily->"Source Sans Pro"],
 " to make a string of 1000 random letters."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.23", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 23}, {
   "WebOnly", 0}},ExpressionUUID->"462e891e-ddff-4c43-9ae1-f4d769632412"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"817ee4b9-85ca-4c53-ad50-369ff523515d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvc/L9U6W2HeTbLLMv5B1QOtsvNAuWQkcAjFoY5ORSRaO8BiCAglGm+Qa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            "], {{0, 328}, {501, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{501, 328},
          PlotRange->{{0, 501}, {0, 328}}]], "ExerciseOutput",
         ImageSize->{505, 328},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3ea6be4d-c9d7-4573-870e-a6622788bde2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvc/L9U6W2HeTbLLMv5B1QOtsvNAuWQkcAjFoY5ORSRaO8BiCAglGm+Qa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              "], {{0, 328}, {501, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {501, 328}, 
            PlotRange -> {{0, 501}, {0, 328}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1ee60ac1-ff9f-4e1a-be74-7a4576285134"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.23"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"aa4db3b6-3ab9-4aa3-9e67-4ab5e0b9b028"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"56c78dba-448e-41d5-9b85-022a691580a3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ea4d18e5-87ab-4e1c-9f85-e9838c249c12"],

Cell["Make a list of 100 random 5-letter strings.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.24", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 24}, {
   "WebOnly", 0}},ExpressionUUID->"cfdee049-4bad-478f-8824-fa7307549572"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d4513e57-1991-4a5e-bea6-6c8cf4258373"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnc3L/Mya11vduPRfcC9Zu5OgG3ERUNxl48tEVDw2M4IEEaRxYcv40ija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            "], {{0, 196}, {471, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{471, 196},
          PlotRange->{{0, 471}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{475, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4ff203d6-235a-4c6f-bd80-8707653d6652"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnc3L/Mya11vduPRfcC9Zu5OgG3ERUNxl48tEVDw2M4IEEaRxYcv40ija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              "], {{0, 196}, {471, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {471, 196}, 
            PlotRange -> {{0, 471}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d3d356d2-8d9d-4c51-9ee3-5308eef74298"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.24"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f5ee7cc0-2265-4155-903c-f3e37ce3418b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"55eb1677-37a9-4287-b786-a5c65b007727"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d01bfe13-589e-40ce-ae2d-8690405cff8a"],

Cell["Transliterate \[OpenCurlyDoubleQuote]wolfram\[CloseCurlyDoubleQuote] \
into Greek.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.25", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 25}, {
   "WebOnly", 0}},ExpressionUUID->"8ffff4c8-a215-4863-b919-9d78612af0d3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"74bad35d-b17f-438e-b0d9-7e61ce3afb9d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVqGO3DAQXbWksFK/oD8QWJUaFkW6qizkTr2cSq7RXaUqNCwwLCwoKCgo
yCTIJCQkJMDEBQYGLjAw2M44TnZvq15P7akquJF2NxnPjN/MvBnt64vPZ/Gz
3W53+wK+zs6/kpub8/T9S3j5cH376er68uO76y+XV5c3by+eg/IVfN7AB5/3
T/Ik/5Xouc4TEpAozpkw91lKlpAwa8Z/hcyJYiGMTZjWTRXBQ1CoX9tayTK0
jsZ783hUsV0CqHLpXsyQ73apWM+MkoILdQJGdgCx4fZuGC0VaDTnpw5Gy5+V
YC9Qqd2z0dqsxmaLC2r3y1OoSD2jRk05AYDUmc5FFOxWKeiGem+mGjRZLzeN
YCVoSFblobfPOu5OdJdHW5C4Grx9X26h47rvMihRqTFyBZret5Anyz6UFIwr
1ieLQ1C6c1kQ9O65soaX0XFbReYMw8JfZ3mLxyWTI8ZvZ9GlniqTY01BZ2NV
h8kTpsG+Qfe8U9bONPcVYHjt3MRQIN8cB2yPHASbcFB6HmiZEGcsZY+O7dpH
M0GJyOBKPuKlYYJf1dKhFnIjWIG5ggpmcNOQQ+xMuO6QNZG9aB03vjv7leqG
YTE9xxzfomapxAIMb4RiHUZDl/CWswGVpV6bONeQWjxZn1dKBcdkk9l6kjgY
tgHYSQeqBbOakQyt8GnqEdNk3yawipvZh5ZdgE58605YTcuJw1CAH+ZNSt9A
O7rasDL0ZVn4gG1Fcuo68u0zeF1AIXM7xVgDQCgBV0KlccDSjnMEGq7csG3s
fPUAfSoGH5sVIfJnSUL1gLb0DgKZkvVLfEDTjNJqXuFLCN6IfxfUjCsxFkgl
AuyVFJFWk9lIAtwzy9WQT10EuLEyJEqCnaLuMa56qXjnopSD2ts5cSSepBya
1DE/bugAa0APOG5JzQRcGi7jJhaShxHxcxUklJtlkLep3JG0B6WLHGR07bx0
4xMjXj2mawCsXs3MYdY2IRXz20DQYlUmLa0Xq7TljuGrdRQugyAoZBHPuJyU
0qcrGJbU0XL6jbCcbEvV0Y5hN0dcIUrr0yhGg/JwDd5skEIptYDlyBwBHk3E
X4jGHgNttvehONpsDxB7d4JWGZqy7vkjANzrvirb8QDI8L4ou4cDBIc6L/r7
/xI8yR/JD3Zex3s=
            "], {{0, 19}, {54, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{54, 19},
          PlotRange->{{0, 54}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{58, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "293924a8-ace8-41e9-b6e9-573dc7ed4c9d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVqGO3DAQXbWksFK/oD8QWJUaFkW6qizkTr2cSq7RXaUqNCwwLCwoKCgo
yCTIJCQkJMDEBQYGLjAw2M44TnZvq15P7akquJF2NxnPjN/MvBnt64vPZ/Gz
3W53+wK+zs6/kpub8/T9S3j5cH376er68uO76y+XV5c3by+eg/IVfN7AB5/3
T/Ik/5Xouc4TEpAozpkw91lKlpAwa8Z/hcyJYiGMTZjWTRXBQ1CoX9tayTK0
jsZ783hUsV0CqHLpXsyQ73apWM+MkoILdQJGdgCx4fZuGC0VaDTnpw5Gy5+V
YC9Qqd2z0dqsxmaLC2r3y1OoSD2jRk05AYDUmc5FFOxWKeiGem+mGjRZLzeN
YCVoSFblobfPOu5OdJdHW5C4Grx9X26h47rvMihRqTFyBZret5Anyz6UFIwr
1ieLQ1C6c1kQ9O65soaX0XFbReYMw8JfZ3mLxyWTI8ZvZ9GlniqTY01BZ2NV
h8kTpsG+Qfe8U9bONPcVYHjt3MRQIN8cB2yPHASbcFB6HmiZEGcsZY+O7dpH
M0GJyOBKPuKlYYJf1dKhFnIjWIG5ggpmcNOQQ+xMuO6QNZG9aB03vjv7leqG
YTE9xxzfomapxAIMb4RiHUZDl/CWswGVpV6bONeQWjxZn1dKBcdkk9l6kjgY
tgHYSQeqBbOakQyt8GnqEdNk3yawipvZh5ZdgE58605YTcuJw1CAH+ZNSt9A
O7rasDL0ZVn4gG1Fcuo68u0zeF1AIXM7xVgDQCgBV0KlccDSjnMEGq7csG3s
fPUAfSoGH5sVIfJnSUL1gLb0DgKZkvVLfEDTjNJqXuFLCN6IfxfUjCsxFkgl
AuyVFJFWk9lIAtwzy9WQT10EuLEyJEqCnaLuMa56qXjnopSD2ts5cSSepBya
1DE/bugAa0APOG5JzQRcGi7jJhaShxHxcxUklJtlkLep3JG0B6WLHGR07bx0
4xMjXj2mawCsXs3MYdY2IRXz20DQYlUmLa0Xq7TljuGrdRQugyAoZBHPuJyU
0qcrGJbU0XL6jbCcbEvV0Y5hN0dcIUrr0yhGg/JwDd5skEIptYDlyBwBHk3E
X4jGHgNttvehONpsDxB7d4JWGZqy7vkjANzrvirb8QDI8L4ou4cDBIc6L/r7
/xI8yR/JD3Zex3s=
              "], {{0, 19}, {54, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {54, 19}, 
            PlotRange -> {{0, 54}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac815109-4c13-4ec5-bff1-249c7a672697"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.25"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d3e33682-8740-4e2e-a9de-41ae014c1926"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0ec17822-58b6-4972-bbbf-e7fa4549b92b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ad544540-5757-461d-b8b6-6a452208ff02"],

Cell["Get the Arabic alphabet and transliterate it into English.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.26", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 26}, {
   "WebOnly", 0}},ExpressionUUID->"ed66f089-ebc0-4419-a551-e3619a3dee17"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"034a21b5-93fb-4177-b328-54bcccb1004d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWy2vtUgSZnbNyE32F+wfQI9tuYpkNuswM9mXyZh3yTubbLCoReJwKBTq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            "], {{0, 19}, {392, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{392, 19},
          PlotRange->{{0, 392}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{396, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "24b01412-cdce-468f-bd03-72a754fb8573"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWy2vtUgSZnbNyE32F+wfQI9tuYpkNuswM9mXyZh3yTubbLCoReJwKBTq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              "], {{0, 19}, {392, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {392, 19}, 
            PlotRange -> {{0, 392}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"37a7e528-ccdd-4757-a777-872b35322f60"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.26"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5a81608b-53ce-44ff-999b-64df8105a123"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f91c8737-e0cb-4a22-b7cd-1c4c720aa29e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9be2095e-d03f-4ed7-b78b-cc865428b904"],

Cell["Make a white-on-black size-200 letter \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.27", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 27}, {
   "WebOnly", 0}},ExpressionUUID->"af781f89-7994-4803-8150-ee7f11e7d383"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3af08667-56fc-409a-b83a-76de4642a061"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb2OIkcUhUd2ByRIJiAhQRYJCQkJTghMhJMJ1jiZiF3tuOXAWJq1sByQ
khIT8wI8Ae/A+1gqd9Pj2ZkxP3Vu12/3+aRd7a52YLqGU33r/pz+/tMfH379
5u7u7ksj++3Dx79+fHr6+PfP32V/+WXx5bd08fj5p8Wfj+nj0w+fvs3+8Z/s
1+/Zr/zPhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEII
IYQQQgghhBBCCCGE1ITmYLbb77Y4u9161PL93QfDZH1UUraznu9vPwyS/la8
iBn7lJ/HjNZoUWYVlTpOO76vwT/JtISiC7YPfd9X4ZvGYFdyETMOi5rrujVa
ll/Fk64T35fikeR+U1bRBbs669qIogtqrOv22IiiC473NdW1MUUX7OYD31fk
g8bQmKILjsu272tyT3uyMruKua67ddN1Y1bqBHieXVozXTeHe82lOWy3uv+1
drrWV3QWEPZmG+11VLMa6RpQdNpP7roz/WXcp0PfV+eK5khbpttB/jymHvBx
PK5qku/pTNe6a7J7yFcRzAI99Bq+L9EBjQftePElsw1FR/tFDXTd0lf0q/tF
a3zQX8ca6BpQtFp3v35dK9Vf/UzX/Wrruqmv6ON6+vorB3Pg7HhYjHxdoQsQ
ba4mb6TZ6D3oL+PbT3LV6N7rRy6H8bsEYoKEPUrNK6vr5lx/fzuThsXCnsOy
orpuTfQVfTZoAZNC1dQ1omiVDppnXgIKezJdn32RuEEUrbYXNjYs7Dksx44v
0jptQNHZ6eVSmqaPhD1KbXrVyvdAya7N/cVdDQx7LmwOsQKJ8Ti9lnvt6p+C
Mg6rCum6PYUilesZbLCLrzq67j0AdZeb+ZkWWN1Oh9XQdWuBhCm3dzMg65tz
XE2cXKZlOoiis1Dntgab2O1a6zVDp48oOrtJ61wxtEtkLIaxN/hgil5PtBKu
SfceWsbjOm5dJ517RNH/y+pcpLPC2n/i1jV26Nin+vfU0RK6z6hFxIMf7SWi
6N0caPVsDlJoGY+b6e0XDRJ0B8MaHuAxkKLkHR9Q9QQv58Htkcsodd1eQncX
PFkNt/bpRVNBkSCNN0p2ZAOPM9nuG52uByl00pAFJFAqOGc5jqtxD4zrNlOZ
3KA0Zs42Jl0nYHJ1Jf6QYAf2jN0wHl0PF5DY9iN5KqsNHTZV3kUQi65BRT93
3wkBN+FrhZ6gQMslVyovOqAbSPbhjyKPCyr6UFpkaJpCN4/kFazkBKUjLoGm
KTJdB36fafTn2AWZmDxtDLA3LXdTcwH4wTA0Bw02m2WsgzZWABV9WJgKPsYr
MO4pFx5YBVW0wZnT5hBLP+a6DjXfM4aytGYnqnAXmvU0zMY9cIMyPd8HeyIF
qWs0q298egV3/9CvoLkD3eTN92bjc+4lD1DmgUMOGx3F+Iz2fh5U/AjX6ez0
yyGzSwVh6XoCKtpWNwjYHJ6xCcdwL6BaJ1xWCEfXzSFoeWezQod2SZlIMZkB
DdhWVvNUWNdQThBGmrCibWdXsPr46TsykKwrCWxiubO+Fw3RssKNpn0HwCaW
Du6MjT5aVvBtpNkYgIp283MH83UZB58GufAx1pU9IJx+9GmkmUzBni5n5ldw
DObRSBM3sZw5s3aBdxtvRpromE8WMDqsfwjMIb0YacLfp+Nxe4GxoQcjTTy5
53qYFO5+NFli06Q9Rn/W7kcq8DSFayNNmYmlSSfb228mejenRpr6JpbR4dBI
04ItbUC4MtK0YksbDns3uhbcAePiuHQQ3+Jlo/iwb6QJmFjGi3UjzcorusCy
kWYdFF1gU9e1UHTB3p6RJl5MjxlbhnuQ5V0FsGOkKTjpx42VzF69FF1gXtcC
RYflVof4jb8w75u9BIGiQ/NYk4QZho00IRPLEwE6CIlukSZ1DU9/h+mP0Z4I
UrnmtibMUfZEmK4OmNNXgTEjTcjEsiBULwLQGrfAzCaPN15a7mAsAerHUmDC
SLOVwkIIeT4UHr5WRow0YU+MQKefXhhhU/MFm5LVYczEsnjL0GZ23tKEh69z
yo1OCG5toXSkXwQfvlblwmDQxLJYRZ/9lprAQ5o58q4PQXgQxeO2ZY9olxpp
YiaWJyJ5mKzoYcTvHkqlCWpieXqnWB6BKutYkAyXYSaWJyJ6cKesNocnCvAh
nbgeSyfKQh9BZz/RoSmuhy418XyLQlMusH9ahI8KEuQKFGak2REoOqySgQaS
qFgB47dJT6DoGG3eJfu/vpEmaHmXI4upvDMU7Y963qeSVNJyFEnA+BbBkGaO
hpEmamJ5IibD2LfgQ5rF9d66DwgUHYvN6VnwIc2cW+l9yU8nbBO/GwiGNHOu
GmmK9op9UFY2MIIhzdNVXymUwO6mKiADFimCIc2cyxqUKDoI25ByCMd8LpSc
UBPLEwffZhcmEDa0nzfSHOFZWl+j3KZBn7j3zDkjTUmhx8MAsh26eJPS6frf
61pWdnQ1XmcfQYNNznvDPUkU6mQozBWSLin1rigvKt1aH2Vyi6BoclqFr/Ee
amJZYKdR3xui9KB6rWvRuTKukoEOktSWerELwx2zVcWeQv4fkkOcetZ1S3Q2
j/8Zu2eQbW75GaST9OeCD2PZRrVAEd1qVUU/VIQQQgghhBBCCCGEEEIIIYQQ
QgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEFIT/gVqIrbR
            "], {{0, 252}, {109, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{109, 252},
          PlotRange->{{0, 109}, {0, 252}}]], "ExerciseOutput",
         ImageSize->{113, 252},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "24846b7e-f2d9-484f-b400-f2043c59f61e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb2OIkcUhUd2ByRIJiAhQRYJCQkJTghMhJMJ1jiZiF3tuOXAWJq1sByQ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              "], {{0, 252}, {
              109, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {109, 252}, 
            PlotRange -> {{0, 109}, {0, 252}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"823509d6-4dc0-4be5-bab4-1e5e1778d95a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.27"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"187fcbe9-4edb-4b68-af68-052f8e0d9693"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"10e1a25f-daf7-417f-95ae-ff12bc805bde"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"052296d4-3a62-4d1a-bccf-9ea9ab577b20"],

Cell[TextData[{
 "Use ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " to make an interactive selector of size-100 characters from the alphabet, \
controlled by a slider."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.28", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 28}, {
   "WebOnly", 0}},ExpressionUUID->"70af4874-ead8-454e-8acc-3352b7f6ae33"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1ede2fce-0a68-43f5-8771-5b5a35da71ca"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3cGLGmkagPFm9zLH/Rf2HjzPKeBxISDMsjcvM2wc9pKVTGAR9iS5NHPy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            "], {{0, 222}, {247, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 21, 40.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{247, 222},
          PlotRange->{{0, 247}, {0, 222}}]], "ExerciseOutput",ExpressionUUID->
         "6605091e-27f1-4075-ae8a-a6d3c6702e6e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3cGLGmkagPFm9zLH/Rf2HjzPKeBxISDMsjcvM2wc9pKVTGAR9iS5NHPy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              "], {{0, 222}, {247, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 21, 40.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {247, 222}, PlotRange -> {{0, 247}, {0, 222}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9915a7b8-2d0e-4879-9618-a4820c1de3fd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.28"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d23b4390-ee9f-40a8-a670-b0dc526f190f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7ff3db40-5a12-4a6f-a8c6-1df071879ca7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"07b47c63-4613-42ce-8158-e9cba076326c"],

Cell[TextData[{
 "Use ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " to make an interactive selector of black-on-white outlines of rasterized \
size-100 characters from the alphabet, controlled by a menu."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.29", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 29}, {
   "WebOnly", 0}},ExpressionUUID->"05388def-8c3b-46e2-a33f-185fb9ceb356"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa8b550a-8bbf-463f-a09f-548b5de55522"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt231wFPUdx/Ed+0dtp62UjnTqw7ToOG01pdpRpDqN0gfHjrYWGKfRohQU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            "], {{0, 220}, {95, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 21, 40.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{95, 220},
          PlotRange->{{0, 95}, {0, 220}}]], "ExerciseOutput",ExpressionUUID->
         "5db14b5a-5a64-4e45-904d-7a43ea6d29aa"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt231wFPUdx/Ed+0dtp62UjnTqw7ToOG01pdpRpDqN0gfHjrYWGKfRohQU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              "], {{0, 220}, {95, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 21, 40.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {95, 220}, PlotRange -> {{0, 95}, {0, 220}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"910cc970-9e42-4de4-b12a-117a659984e7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.29"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4907fa67-f9ae-4002-9bfd-0ce76057d7d4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"01466af1-35ab-434c-852f-a7c287cb2d6c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b66f2dbe-50f8-4c9b-b1a7-5337c8319ad1"],

Cell[TextData[{
 "Use ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " to create a \[OpenCurlyDoubleQuote]vision \
simulator\[CloseCurlyDoubleQuote] that blurs a size-200 letter \
\[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] by an amount from 0 to 50."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "11.30", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 30}, {
   "WebOnly", 0}},ExpressionUUID->"4cd84525-ffb1-4f8c-a0d2-fb11b0b46aa6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"af83b9b7-a001-44c8-a11a-83b4f9f5866b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3bFvW9cVgPHXdunYf6F7wLlTAY4FAhBI0Y1LgoZBl1RIChQCOgleiE7s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            "], {{0, 
            348}, {245, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 21, 41.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{245, 348},
          PlotRange->{{0, 245}, {0, 348}}]], "ExerciseOutput",ExpressionUUID->
         "f28afe52-63c9-410c-90ed-ffccc6bd083f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3bFvW9cVgPHXdunYf6F7wLlTAY4FAhBI0Y1LgoZBl1RIChQCOgleiE7s
xI1LNCmLgDoEDAg2iCZRDBA2CDtMAjoRkrBKmJiyKQVEQMTuodiqtkxK71ze
9969R99vUGSJtsT4M3X4eN99v37tz6/Ufp4kydu/lDevvPrX8ltvvbr5+1/J
L/7w5tt/euPN1//4uzf/8vobr7/1m9d+IR+s/ixJfpD/zt9/Cpg2nU7H4/Hh
4eEQiJ+ULD1L1Yu2v//+e/nlZDL5AYiflCw9S9XS9tHR0aNHj4r+jgDPpGpp
++HDhycnJ0V/L4BnUrW0/fjx46K/ESATj08V/V0AmSBvGEbeMIy8YRh5wzDy
RnROTk4ePHjw0Ucf3Tgl78gvlx7cJm/ERTK+d+/eP18gH3yxcPJGXOSB+izp
R6fOfimfOndj8kZcZBRZlbd86tyNyRtxkWH7LOxnyQflU+duTN6IC3nDMIYT
GMZTSxjGgUHYxss6wA/kDdPIG4aRNwwjbxhG3jCMvGEYecMw8oZhGeU9mUwO
Dw8fPHhw//79u3fvylt5Xz7CNobIUxZ5j0aje/fuffXVVw8fPpxOp0+ePJG3
8r58RD4un/X75YBVvOf9zTffyAO1xLx0p2X5uHxWbuPxKwKr+M1bHpml3uPj
4wv2EpfPym14DEcOPOYtc7XMHqset889hsstmcOR3osrYK9fv37p70qf97e3
my8lLyVJ8o/b3y69gTxz/Pzzz1NeD0JuKbdX3UFcZWdVS65n71/6uxR5v//3
5OXmcNmnPv3001u3br377rufffZZyrzllnL7m8AykpNE9WLe7733XmZ5X/vt
tfeXfkq+GfmW3nnnnaOjo5R5yy3l9kX/X0S4Op3OubwfP89/3n+7tfRTi0fv
Vqv1008/pcxbbim3L/p/IQK16tE7y+Hk2svXlue9cPfuXXmbMu+z2wNpZJ33
pT755JPhcJgyb7ml3N7L18VV8OKRk5zz/vrrr+/fv58yb7ml3N7L1wVW8Xvc
+8MPPzw8PLy0bbmN3JLj3sia31ct5QH59u3bF7+yI5+V2/DQjRx4X3MyGAwW
9S5te9G/3MbjVwRWyWLF4BdffHHz5s07d+58+eWXx8fHT548kbfyvnxEPi6f
9fvlgFUyWu/93XffffzxxzJg37hx4/r16/JW3pePyMe9fy1glUzP1pEnj0dH
R+PxWN7yRBL542Q0GEbeMIy8YRh5wzDyhmHkDcPIG4aRNwwjbxi2NO9/AXFK
mXfKsxKAcJA3DCNvGEbeMIy8YRh5wzDyhmHkDcPIG4aRNwwjbxhG3jCMvGEY
ecMw8oZh5A3DyBuGkTcMI28YRt4wjLxhGHnDMPKGYeQNw8gbhpE3DCNvGEbe
MIy8YRh5wzDyhmHkDcPIG4aRNwwjbxhG3jCMvGEYecMw8oZh5A3DyBuGkTcM
I28YRt4wjLxhGHnDMPKGYeQNw8gbhpE3DCNvGEbeMIy8YRh5wzDyhmHkDcPI
G4aRNwwjbxhG3jCMvGEYecMw8oZh5A3DyBuGkTcMI28YRt4wjLxhGHnDMPKG
YeQNw8gbhpE3DCNvGEbeMIy8YRh5wzDyhmHkDcNs5z3p7VQr1Zpetbq5Py76
u8fabOe9t1lKXNV2BkV/+1iX5bxn/Zpz3KLS5PE7dobzHu831qk7SUrtYdH3
Aeuxm/esvcZkslDb7hd9L7AWs3lPe9U14xblBvNJ1KzmPd6vr1/36XwyK/qu
wJ3RvGe7G+tOJgtV5pOY2czby2SywHwSM5N5jzpeJpOF0i7zSbQs5u1tMlmo
tnpF3yM4Mpj3tOttMlko1UdF3ye4sZf3aG/Lb93z+eSA+SRK5vKe7qz1Svxy
1SbzSZSs5T3pVlImW67V0t6U+SRWxvJOP5lUt/uDnY3UfSc7zCcRspW3YjJp
9mdPD3bS511pdou+d1AzlfdkP/W4UetN5TcMFA/fpS3WD0bHUt7D9mbaVqvb
87qVqwq3B9Oi7yJ0DOU93U59vPvsTBzVUcRKg/kkMnbyHqefTJ55njjulNP3
zXwSGzN5KyaTZPPg/79v3Ez/r0Lmkz7zSUys5D1JP5mUNtvP/s5eS/Eafrmx
X9Q9hAMjeWtmjK2950aM6WA7fd7PP/IjdDbyPthNf4Sv3Dm3gHumOTyYJC3m
k3iYyHvSSj8/Lzk9QXd4sFxnPomGhbzHe+knk6UH95SLDJlPomEgb81kkjR7
kyV/hOrwoMwnS/8QhCf+vDWTSVJbMTjrDg+W652c7yTcRJ/3SDGZJLWdVcv+
+prDg0myMWD9YAxiz1u1qHVjd+XUrDw8uGLIQWAiz1s1VJTaF52TcJD+VU9R
3mI+iUDceY/aqiN6F59xo9wtmfkkAlHnPdhWnFd56Xq/sXJ3lGaX+SR0Mec9
bmgO510+LSvOhpgrbe3lcjfhLuK8h5rJJKn1L58lJrrDJ6n+TBQp3rz7mskk
2dhNU6Jq2hGNLhsQBi3avHWTyeZeqhMRZge7qrxLm8wnQYs079lwVzOZvLBK
cKXhlm57QuaToEWat+5Fxkoz/TGO/brq+WXS4AKBAYsz71FdM5lUW4ot6Ce9
pirv0kb78j8UBYkxb+2ErNtgSn25wMWWKQhRjHmrzo7Un96u3h68znwSqgjz
HtVVzyr1J9eot1BOd9QR+Ysu75lmY8DE7aVz5cuXMt0zn4Qpurx7TdUri24H
7lSnSMzVO2yQHKLY8lYel95ou40NqmXkczXmkxDFlfdMedLBlvODqm5Bi6h2
mU/CE1fe3YZqaKjsuy9ZHale9E/muwMxnwQnqryVk8l/dzl2pBzyLzqRE0WJ
KG/t6ZAXnFmZhnYQkh8WnN8QmojyVk4m5bWHBe3yqrTrEpGbePLWneqrWka1
inZ5lcwnPL8MSix5T/stXWjbimVUK79oT/dF13syC/9iyVv5QFpqD308z1Nu
His228wnAYkkb+VkUm74OkjX2VIeH1zvcA38iiJv7WRSbXm7Rvakq1v+PZ9P
WD8YjCjy7qjOXvB7BWH18m+ZT9ggORQx5K0cgH1f/125exXzSUDCz1t7dpj3
q0+O93W7V2nOXEa2ws9b++TO/7Vvpl3ly/PrvmAKX0LPW31oLosrg0x3tPN3
pcXx7xAEnrf6vPVs9iXWXBN2gfkkCIHnvaecTLLaFU158R2x8b/L1qNAQecd
0J4M6tPTmE9CEHLek25DV1SWZ6xrd9f0sWQR6wo5b+0B561M16PqdjWcqzGf
FC3cvNWTSdar9XT7q5x+Rx4W5WIdweY93ldOJtXMZ92u9vS0Sy5WhcyFmrfu
Ou9JLkcqpn3t6Wl+lp3DWaB5T3vKySSfx0nlulxRbnL8u0Bh5q1e5lFu5FOR
evm3rxMr4CTIvGdt5R6t1aa3Bd4XUx+rnK8fZD4pTIh5T3vap3A7g7yWoKqn
pvx+suBFAeatvXxqkmh38F6HevdvmU92mU8KEl7e6n4cdvBeh3r3b68nx0El
uLz1i6svv9ywX+rdv32e2gyV0PIedbSPjflfek+/vErmE4+nfyK1wPLWnzhw
Go/D73FWcvpquR3bwbPCynvSVT8uxsL3Cc5II6i8HZ61RcTn9hRIJ6S83SaT
aFSYT3IXUN4ORyTiUqqz/2DOwslbf7pufLZze3UVp4LJe7qtPd4dIe9bDOFi
oeRtfjJZUF8BHGsJJO+rMJksMJ/kKYy8r8RkslBp5LpC5ooLIm/9Jjkxy2Kb
OCwXQt4Hu9pLfMTN/yafWCGAvB1WKMUt5xW8V1nxeV+tyWSB+SQnheftMJnk
vcD7YmOXQ5qtfkh3wa6i83aYTDYGYS1NcjnsU65nslEzzik479GeemOFzb1M
vpM1OD01Zj7JQ7F5D3bUYdQDvK7eaM/hFIewRiyjCs173FRPJtXMdvBex7ih
f3pczuZCEnhWkXmP2uoHvVqGO3ivo99yeNk1tCcRBhWYt35D+Ix38F7D7GBH
n3fS7DKfZKu4vMdN9Q/0rHfwXsdwSz9/l7aCe5psTGF5D/WTSdhX+91vOBz/
3sh9F4urpai8+/rJJPBroU56LX3emV3KDacKytvhUEPwV2JSX2F2LsDD+JYU
kvdMfxmmKPaB117r6lT+u2xdIYXk7XAYLYpdstW77p9qBPhClRVF5D2qqyeT
SPbo0+//Ob9vm+2iv2+z8s97drCrLyCWHczcdiLK7mLKV13+eff0k0mlGc3+
CW7nRIe4kMaE3PPWX/w0SbYjOnvL6eyM0kY7htkrPjnn7fTidVxrRyf6dWJJ
qEvFopdz3j31hX3jW/nvsJZG1DuRPL2ISr55Dx0mk+jWRbsc1U/mL8oyn3iX
Z96zgcNkEuOrHi7PL2Q+6TKf+JZn3l39oqNIjwl3nebvLeYT33LM22XJaH0/
yr/xaX/bIe+kthPfT6qw5Zb3dODwNx7vz+sDpy1Bq5zf4FdueTtMJlE/mnW2
XHYnCvZ0pEjllbfLo9lmO+K/60m34ZC3/IuO9edVkPLJ22kWrXSifqV62nO6
EFbIJ9zFJ5+89+v6yaTSivzveba74XJ8MOqfWaHJJW+XyaS2M/B2JwvieJnO
sE8pjUsOeU/7DichlttRHhF8nuMFgyqsH/Qlh7z39WcvJOWGib/hicvuPvP5
JKpFZAHLPm+XE2yrLSMX8D3Qb6J4ev+ZT/zIOm+37RHsXH7dYaO5uXLcR42C
kXXeLq9umLo4tcvumknwm7rEItu8nbb+MHbpXoeT707/L8R+XDQImeY96TUd
/mKNXTjMaRlwwnziRaZ5O627iOvUszRclkqKjfiP/Bcuw7xnfYdXpU1u6u7y
om3CfOJBdnmPndYUmdxS0m1Im7+2NbRyBKkg2eXdbzk8eBvdENjpKXZi9B97
noq+8B+QIfKGYeQNw8gbhpE3DCNvGEbeMIy8YRh5wzDyhmHkDcPIG4aRNwwj
bxhG3jCMvGEYecMw8oZh5A3DyBuGkTcMI28YRt4wjLxhGHnDMPKGYeQNw8gb
hpE3DCNvGEbeMIy8YRh5wzDyhmHkDcPIG4aRNwwjbxhG3jCMvGEYecMw8oZh
5A3DyBuGkTcMI28YRt4wjLxhGHnDMPKGYeQNw8gbhpE3DCNvGEbeMIy8YRh5
wzDyhmHkDcPIG4aRNwwjbxhG3jCMvGEYecMw8oZh5A3DyBuGpcz7gw8++DcQ
G+k2Td6ADeQNw8gbhknbk8nk5OSk6G8E8EyqXrR9fHxc9PcCeCZVS9s//vjj
8Skew2HD4hFbSNtPnz6Vt/JBeSR/DMRPSpaeF20DAGL0H0hmumI=
              "], {{0, 
              348}, {245, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 21, 41.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {245, 348}, PlotRange -> {{0, 245}, {0, 348}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6a0bb8d9-8398-4956-8eb8-3b336fdcea14"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["11.30"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d75ddc35-9677-44c4-98f3-fc7361227e93"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"376c0bf7-56c9-4529-8eb9-a4b0b10b1c9d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"22f9e48a-56cb-43dd-9daf-d693b8db5084"],

Cell["\<\
Generate a string of the alphabet followed by the alphabet written in reverse.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"10ec50b3-372f-45eb-8f21-c10d6b5c354c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f0c9c865-4495-429b-afb4-058e91f96886"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz3PpcYVJkmTMlJ+Qf4AdVrKVEiO0kQ0tmKsNA5yIkW0dJR0dESJqKhQ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            "], {{0, 19}, {346, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{346, 19},
          PlotRange->{{0, 346}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{350, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "82372e3f-7261-44c3-b2dd-a3ce0dd0b563"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz3PpcYVJkmTMlJ+Qf4AdVrKVEiO0kQ0tmKsNA5yIkW0dJR0dESJqKhQ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              "], {{0, 19}, {346, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {346, 19}, 
            PlotRange -> {{0, 346}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5e8763c5-846f-4f0d-a89a-38a49c2ac585"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5df9d640-ffd5-451d-aeb7-e52821398d9a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b04cb668-2004-49e8-b039-f61530c804a4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2af27831-c828-432d-b729-04abf883ba9c"],

Cell["Make a column of a string of the alphabet and its reverse.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"ea41c1fd-bb11-4caf-a879-fa2f4cb609ed"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"59fd81e9-c8ee-461e-afb8-d3e4b6ddc1f1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz3L7bgRNkmTMn8hpHed1mUqw4Z0bnbJeklzY3YDwa2b4Cq4MyHgyk1M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            "], {{0, 35}, {
            173, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{173, 35},
          PlotRange->{{0, 173}, {0, 35}}]], "ExerciseOutput",
         ImageSize->{177, 35},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ad5af13b-7b76-4fd3-89c7-21fcff56ddff"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz3L7bgRNkmTMn8hpHed1mUqw4Z0bnbJeklzY3YDwa2b4Cq4MyHgyk1M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              "], {{0, 35}, {
              173, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {173, 35}, 
            PlotRange -> {{0, 173}, {0, 35}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"61af7d6d-6f68-410b-942c-231d8731dd52"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"12413174-558c-460d-b655-5818e8e988c3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"52c15e55-bd61-4de7-a1cc-1436bb7d93b5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1f07ee78-178b-43c7-9e0d-c615077420ac"],

Cell["\<\
Find how many sentences are in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computer\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"ee95d34d-005e-4127-a549-b8433ff8c076"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"93d01bd6-e055-4933-bea8-bccedaa6a74c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzlka1u5DAUha0uKVxptQ/QFzAuDSwaqdWykFadVCWzo+lKlWmYYVhYUFBQ
kJGJUYilVUgKDEJMDAxMAgy815mZNN0+Qq/kyPl0f849vnr4fZtdIIReLuFz
e/+aHA735O47/PzavTw/7baPN7s/26ft4frhG8AfcH7CiffwxWMyHW+blnWD
XpjTPYtMKDMt0Ft1TNTuTDTfoBh4/m6o8MHLar9iqOptHDI0eJUojJ/LWYJz
Fa+B0wShpHNhqLJN0c3dFYFcwqG6hjGYRn2uz+Cai/+WsCI/lq/CUShP6ym4
MkG4kEc6VClC+bKqM7oXDSCU1adq78yoeDUPbxX0LvF7uebrQbHzMQppT0gW
J4T2w2yeLKNJe1oWeTrzVK50+smwIvJ29AtzWuZgVVLOiVPP6pwQWjHJYaeN
jG2n1cP0oIJ21q+YYeSTIYFHVkESgyfChA/amrGlUV799jeNL9goY7USJImG
G7CryTPaKj2KOhpChYmzQV6Kz2vigoFLYRTV2QyYshc6ihlaujBSy7UYPzlr
nf8gMDhnnZvCxzz7Oe+rxj8EYdM5
            "], {{0, 19}, {21, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{21, 19},
          PlotRange->{{0, 21}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{25, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cf372b26-0102-4050-a2ef-304a3d2f049c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzlka1u5DAUha0uKVxptQ/QFzAuDSwaqdWykFadVCWzo+lKlWmYYVhYUFBQ
kJGJUYilVUgKDEJMDAxMAgy815mZNN0+Qq/kyPl0f849vnr4fZtdIIReLuFz
e/+aHA735O47/PzavTw/7baPN7s/26ft4frhG8AfcH7CiffwxWMyHW+blnWD
XpjTPYtMKDMt0Ft1TNTuTDTfoBh4/m6o8MHLar9iqOptHDI0eJUojJ/LWYJz
Fa+B0wShpHNhqLJN0c3dFYFcwqG6hjGYRn2uz+Cai/+WsCI/lq/CUShP6ym4
MkG4kEc6VClC+bKqM7oXDSCU1adq78yoeDUPbxX0LvF7uebrQbHzMQppT0gW
J4T2w2yeLKNJe1oWeTrzVK50+smwIvJ29AtzWuZgVVLOiVPP6pwQWjHJYaeN
jG2n1cP0oIJ21q+YYeSTIYFHVkESgyfChA/amrGlUV799jeNL9goY7USJImG
G7CryTPaKj2KOhpChYmzQV6Kz2vigoFLYRTV2QyYshc6ihlaujBSy7UYPzlr
nf8gMDhnnZvCxzz7Oe+rxj8EYdM5
              "], {{0, 19}, {21, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {21, 19}, 
            PlotRange -> {{0, 21}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0afa79d1-f5b6-491b-8727-7248f193491d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f536e2e4-a8c4-4c82-b7d4-1c8992ae4bfe"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b81e43e2-9c8c-434f-be38-9ed9c519f603"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"34a55699-b75a-4d78-bb55-6346049da64b"],

Cell["\<\
Join together without spaces, etc. the words in the first sentence in the \
Wikipedia article for \[OpenCurlyDoubleQuote]strings\[CloseCurlyDoubleQuote].\
\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"0f3cd84b-890b-4c5d-817d-d3c8558926c9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a6610a26-6e32-4ebd-a8dc-31d088820a1d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL3LtcgVN0mTMpC/IP+AdVrLkEJISGezS9YlRTayCQRbm2CRws7OykoI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            "], {{0, 19}, {453, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{453, 19},
          PlotRange->{{0, 453}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{457, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c86113fd-f081-44bd-a506-637a83a2444e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL3LtcgVN0mTMpC/IP+AdVrLkEJISGezS9YlRTayCQRbm2CRws7OykoI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              "], {{0, 19}, {453, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {453, 19}, 
            PlotRange -> {{0, 453}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b00247ad-484c-4c9c-b1d8-4da5f4d6e29f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"22074a8f-4482-48fb-abb8-02ef8fe75560"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e82520de-eb24-4d67-bc10-e47c982d35a8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"69816098-0567-4db5-baae-705e73bb12f7"],

Cell["\<\
Find the length of the longest word in the Wikipedia article about computers.\
\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"3f3c9493-aba1-4b9f-bbf6-9f55c866003b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"28b9ef44-6255-4897-ac22-21001787dc94"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVUatuwzAUvdrI0DRpX7AfCB41HKrUaSyk1ZJqJKvSSVNpWGCYWVGQkVFQ
SJFJiElIQEhIgIFJgEF27fSxgmm4R7J9fXzu00/Lz3l4AwCbO9zmi28Sx4vt
6wNe3qLNxyoK3l+ir2AVxM/LWyQfcd3jsvZ4RdCdKDhjXNT9mTT9vmA547Ib
JkJJ5oHFtK9Z7eg2JXCExxsrbnIfIO1c6DxEPsW4XblFizUGXawVcuMESptD
fJECEKENX+NJtSNrGyqsh4t6qwxTJt2oqQckqyZykNS5/+qg5TZPjnVqSs5K
7ZTVSakE5gA/d8TfMXthWyHZcUamsHXuptIa22dYm3HoSt/NgpaVrCohRKOM
ywgJl31jX71kjy6SzuASqVC2u114uM+y1vzzdYNW6jTB68EPcsSQzQ==
            "], {{0, 
            19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e6be1714-ff3b-4bf2-aeb8-3cd73d00ddbb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVUatuwzAUvdrI0DRpX7AfCB41HKrUaSyk1ZJqJKvSSVNpWGCYWVGQkVFQ
SJFJiElIQEhIgIFJgEF27fSxgmm4R7J9fXzu00/Lz3l4AwCbO9zmi28Sx4vt
6wNe3qLNxyoK3l+ir2AVxM/LWyQfcd3jsvZ4RdCdKDhjXNT9mTT9vmA547Ib
JkJJ5oHFtK9Z7eg2JXCExxsrbnIfIO1c6DxEPsW4XblFizUGXawVcuMESptD
fJECEKENX+NJtSNrGyqsh4t6qwxTJt2oqQckqyZykNS5/+qg5TZPjnVqSs5K
7ZTVSakE5gA/d8TfMXthWyHZcUamsHXuptIa22dYm3HoSt/NgpaVrCohRKOM
ywgJl31jX71kjy6SzuASqVC2u114uM+y1vzzdYNW6jTB68EPcsSQzQ==
              "], {{
              0, 19}, {14, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"121550fc-7c9e-4102-89d1-2a3ab6c508b5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2880927c-6b53-4767-874f-9b3248c268eb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e213181a-9e27-48aa-87b9-b4794c8e289c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b74e5d9b-5607-4417-838c-5f43448d668c"],

Cell["Plot the lengths of Roman numerals for numbers up to 2000.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"72479976-33a1-4761-ba02-8b53db8f2856"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bc5ae5c5-ce5a-4191-96c7-dde78f905de8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfdtfFVfaZs/MzVzO7Vx+/8XczuXcfvOb253OaSemI+lOOuTrTkhigjFq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            "], {{0, 178}, {281, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{281, 178},
          PlotRange->{{0, 281}, {0, 178}}]], "ExerciseOutput",
         ImageSize->{285, 178},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "151e9a70-437c-43f8-9806-83408e8490f6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfdtfFVfaZs/MzVzO7Vx+/8XczuXcfvOb253OaSemI+lOOuTrTkhigjFq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              "], {{0, 178}, {281, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {281, 178}, 
            PlotRange -> {{0, 281}, {0, 178}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"11570f0a-997e-49d5-a0ea-0d810fb677b2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"56f87985-eb4e-4235-9374-573de440a0a5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6bc25591-4608-46bd-8f77-e49711cb87f6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f6941718-e77c-4852-a217-43865d7e9d09"],

Cell["Generate a string by joining the Roman numerals up to 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"4ac66799-44f9-4c1a-81ad-e240e20716c4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bd465342-146c-4228-add3-c7dc592a875f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXc+La8l1VpJNlvkXssuq19lqmVWDQzamN7bjNvHCaexA6F3QwkbYMMjx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            "], {{0, 130}, {500, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 130},
          PlotRange->{{0, 500}, {0, 130}}]], "ExerciseOutput",
         ImageSize->{504, 130},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "79cb16a1-c385-439d-aaf2-68d14b618cc7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXc+La8l1VpJNlvkXssuq19lqmVWDQzamN7bjNvHCaexA6F3QwkbYMMjx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              "], {{0, 130}, {500, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 130}, 
            PlotRange -> {{0, 500}, {0, 130}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f404508c-901b-447b-9c4d-c70fa1a8317d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.7"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9c6b8638-a5ab-470b-9919-4fcd6718880b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c1ebc2d9-b808-4de7-80e0-13a117e499aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6a523fb3-6f5d-47ca-8eb5-52bb178dc5a3"],

Cell["\<\
Make a line plot of the successive letter numbers for the concatenation of \
all Roman numerals up to 30.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}},ExpressionUUID->"9dad6c08-5df6-4e44-95f8-1cbdaec284bb"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0fe2e3cd-a938-4809-a4ee-df44566507ac"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfd1/XOWRZnb3Zi/3X9j/Ym73cm9nf3vbTALpQGaimSGDsjNBGWBsCDgJ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            "], {{0, 234}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 234},
          PlotRange->{{0, 360}, {0, 234}}]], "ExerciseOutput",
         ImageSize->{364, 234},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4f3c0696-8ab3-4ad9-b134-407ea5a6276e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfd1/XOWRZnb3Zi/3X9j/Ym73cm9nf3vbTALpQGaimSGDsjNBGWBsCDgJ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              "], {{0, 234}, {360, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 234}, 
            PlotRange -> {{0, 360}, {0, 234}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"41fe31ee-640d-433d-b9d2-6c7461851ca7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.8"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a2a4bf34-2636-4764-832f-84050540a517"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8ca779dd-025e-4364-b314-a7fed59888eb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f87f5082-2501-48ef-876a-8a3586d8778e"],

Cell["\<\
Find the maximum string length of the name of any integer up to 1000.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 9}, {
   "WebOnly", 1}},ExpressionUUID->"8e53454d-046e-4a56-b676-ec9e55c70624"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fab5bf02-abac-4133-9cce-09274103ee1a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzdUKFuwzAQPW1kaJq0L9gPFI8aDlXqNBbSakk1kk3ppCm0zDAsrCjIKCgo
ZMjEJMQkIMQkwMCkwMC7JFPS5A+2J53le37v7nwPu/dNcAUAhxs8NtsvEkXb
+PkOk5fw8LYP/den8NPf+9Hj7hrJe4xbjO7u/hCM4kXOWM5lOxBtXc0hjXW6
YivoMJwfTKIzGZIJq2/j6swDoKovnQVI0q6u/YVziqIrYOdeoLF0D80pAOFm
mkuLBM2FWs4rEgJwvKBNikRcLmS2ydEeZHJiaoYMa+xMpzmOC1520dnJkzdv
gUvh3VdI0s53d1pj62KseFal1y8iLUUlBOe81nYckiRidFbperE7ynX/0sQw
U/4//AD7Qqvn
            "], {{0, 19}, {14, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{14, 19},
          PlotRange->{{0, 14}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{18, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "76f701bd-ca45-44ab-a592-d22fc0523fb1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzdUKFuwzAQPW1kaJq0L9gPFI8aDlXqNBbSakk1kk3ppCm0zDAsrCjIKCgo
ZMjEJMQkIMQkwMCkwMC7JFPS5A+2J53le37v7nwPu/dNcAUAhxs8NtsvEkXb
+PkOk5fw8LYP/den8NPf+9Hj7hrJe4xbjO7u/hCM4kXOWM5lOxBtXc0hjXW6
YivoMJwfTKIzGZIJq2/j6swDoKovnQVI0q6u/YVziqIrYOdeoLF0D80pAOFm
mkuLBM2FWs4rEgJwvKBNikRcLmS2ydEeZHJiaoYMa+xMpzmOC1520dnJkzdv
gUvh3VdI0s53d1pj62KseFal1y8iLUUlBOe81nYckiRidFbperE7ynX/0sQw
U/4//AD7Qqvn
              "], {{0, 19}, {14, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {14, 19}, 
            PlotRange -> {{0, 14}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"da0c8e91-cf72-4385-8337-fd26796d0503"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.9"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d8910fbd-a7bc-458e-9765-6d5eb6f54fb5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1ee10ad6-c7c5-42c4-9a98-1d5a24c7f7d0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"68c563e6-7b07-49c9-9ae1-49ad44fffbd7"],

Cell["\<\
Make a list of uppercase size-20 letters of the alphabet in random colors.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 10}, {
   "WebOnly", 1}},ExpressionUUID->"b8937f30-7cc8-4526-8bc7-8c21d14c89b5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b0866461-8cf4-4192-ab53-fceddc0c26ea"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnGtQG8eWgHV3k6qt+2v/7K/8ubuVH7d8a7lVqdq62Ue5Qt3aJDdFlrWd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            "], {{0, 21}, {457, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{457, 21},
          PlotRange->{{0, 457}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{461, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "23ed5770-8bdf-4f2e-a188-a0a6cf5b2434"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnGtQG8eWgHV3k6qt+2v/7K/8ubuVH7d8a7lVqdq62Ue5Qt3aJDdFlrWd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              "], {{0, 21}, {457,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {457, 21}, 
            PlotRange -> {{0, 457}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3dcbdfc8-b4d0-4a33-ad56-c6b1085032fc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x11.10"], StandardForm],
   ImageSizeCache->{151., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6244d900-99ef-47c3-a8bf-6ce35ec3ec1e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5e9496da-f4c9-4886-8053-2741b97ab7f4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6378a414-1924-4d9b-b548-f8cd9735907e"],

Cell["\<\
Make a list of 100 random 5-letter strings with the Russian alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+11.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 11}, {"ExerciseNumber", 11}, {
   "WebOnly", 1}},ExpressionUUID->"95cd1f0a-542c-43a2-853a-c4edd33265de"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc073854-1e79-4e6f-a61e-a32800ba29d3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvb/L9M7X37dJmpT5F/IPqE6rMpXAIZ0am1gmjSPsQFCrxiidOnUiBBVB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            "], {{0, 244}, {497, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{497, 244},
          PlotRange->{{0, 497}, {0, 244}}]], "ExerciseOutput",
         ImageSize->{501, 244},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b9a534f9-e553-4b67-a454-338522bb2742"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvb/L9M7X37dJmpT5F/IPqE6rMpXAIZ0am1gmjSPsQFCrxiidOnUiBBVB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