(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    229013,       5075]
NotebookOptionsPosition[    127725,       3031]
NotebookOutlinePosition[    221152,       4938]
CellTagsIndexPosition[    220781,       4921]
WindowTitle->Basic Graphics Objects: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Basic Graphics Objects", "SectionInline",ExpressionUUID->
   "5952aa18-c8e0-43a1-a8ee-75c6d0cd734c"],
  $Line = 0; Null]], "Section",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowCellLabel->False,
 CounterAssignments->{{"Section", 7}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{
  "p:29", "i:1"},ExpressionUUID->"d6da2c97-98c1-4c09-b634-6c2036d797cc"],

Cell[TextData[{
 "In the Wolfram Language, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]], "InlineCodeText",
  ExpressionUUID->"28eea18a-ce4a-44cc-8bfb-d7e1d70b0a0e"],
 " represents a circle. To display the circle as graphics, use the function \
",
 ButtonBox["Graphics",
  BaseStyle->"Link"],
 ". ",
 ButtonBox["Later",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-14-coordinates-and-graphics.nb", "circle-x-y"}],
 ", we\[CloseCurlyQuote]ll see how to specify the position and size of a \
circle. But for now, we\[CloseCurlyQuote]re just going to deal with a basic \
circle, which doesn\[CloseCurlyQuote]t need any additional input. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"5820b4aa-42a6-470b-8b30-fd0265552c18"],

Cell["Make graphics of a circle:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b356a480-5624-4e0c-a82a-b82870b4dfcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", " ", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"45401108-2770-4b5d-9cf0-44c860ceea0b"],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  ImageSize->{100.3984375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"d347ea8c-a420-4e31-9b41-e361dd78cf16"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Disk",
  BaseStyle->"Link"],
 " represents a filled-in disk:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"10f5dfb8-4e9b-41c5-998e-57b62bfcab48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", " ", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"f2ab413b-efb4-4949-8b90-3e75c05cea01"],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}],
  ImageSize->{100.36328125, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"26d95492-bc69-4875-bae0-26c80c2a18db"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["RegularPolygon",
  BaseStyle->"Link"],
 " gives a ",
 "regular polygon",
 " with however many sides you specify."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"55b144fb-9d13-49ea-b2ba-d0321394697b"],

Cell["Here\[CloseCurlyQuote]s a pentagon (5-sided regular polygon):", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ebe9fa37-bf88-436f-b8f7-9dfa451a8433"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"RegularPolygon", "[", "5", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"46bd4f5c-e6d0-4afc-982e-a58ef0dd0503"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[
   PolygonBox[
    NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
      1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (-1 + 
        5^Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
      0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
      0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
      0.30901699437494745`}, {-0.5877852522924731, -0.8090169943749475}}]],
   RegularPolygon[5]],
  ImageSize->{100.3984375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"34e6eeb4-a32e-4355-a014-f9b1f8caa3ec"]
}, Open  ]],

Cell["\<\
Make a table of graphics of regular polygons with between 5 and 10 sides:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"38eebc21-80f7-4ff0-972b-466b552ab2d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"RegularPolygon", "[", "n", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "10"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"c57a3dea-368e-4053-8bc8-b6317f2c7aac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
        1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[1, 4] (-1 + 
          5^Rational[1, 2])}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
        0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
        0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
        0.30901699437494745`}, {-0.5877852522924731, -0.8090169943749475}}]],
     RegularPolygon[5]],
    ImageSize->{99.96875, Automatic}], ",", 
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 0}, {
        Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
        Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
        0.5, -0.8660254037844386}, {1, 0}, {0.5, 0.8660254037844386}, {-0.5, 
        0.8660254037844386}, {-1, 0}, {-0.5, -0.8660254037844386}}]],
     RegularPolygon[6]],
    ImageSize->{99.70703125, Automatic}], ",", 
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
        Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
        Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {0, 
        1}, {-Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {-
         Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {-
         Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}}, {{
        0.4338837391175581, -0.9009688679024191}, {
        0.9749279121818236, -0.2225209339563144}, {0.7818314824680298, 
        0.6234898018587335}, {0, 1}, {-0.7818314824680298, 
        0.6234898018587335}, {-0.9749279121818236, -0.2225209339563144}, \
{-0.4338837391175581, -0.9009688679024191}}]],
     RegularPolygon[7]],
    ImageSize->{99.70703125, Automatic}], ",", 
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
        Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
        Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {
        Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
         Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
         Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {-
         Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {-
         Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}}, {{
       0.3826834323650898, -0.9238795325112867}, {
       0.9238795325112867, -0.3826834323650898}, {0.9238795325112867, 
       0.3826834323650898}, {0.3826834323650898, 
       0.9238795325112867}, {-0.3826834323650898, 
       0.9238795325112867}, {-0.9238795325112867, 
       0.3826834323650898}, {-0.9238795325112867, -0.3826834323650898}, \
{-0.3826834323650898, -0.9238795325112867}}]],
     RegularPolygon[8]],
    ImageSize->{100.21875, Automatic}], ",", 
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}, {
        Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
        Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
        Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {0, 
        1}, {-Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {-
         Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
        Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {-
         Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}}, {{
        0.3420201433256687, -0.9396926207859084}, {
        0.8660254037844386, -0.5}, {0.984807753012208, 
        0.17364817766693033`}, {0.6427876096865393, 0.766044443118978}, {0, 
        1}, {-0.6427876096865393, 0.766044443118978}, {-0.984807753012208, 
        0.17364817766693033`}, {-0.8660254037844386, -0.5}, \
{-0.3420201433256687, -0.9396926207859084}}]],
     RegularPolygon[9]],
    ImageSize->{99.83203125, Automatic}], ",", 
   GraphicsBox[
    InterpretationBox[
     PolygonBox[
      NCache[{{Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 0}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[1, 4] (1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
        0.30901699437494745`, -0.9510565162951535}, {
        0.8090169943749475, -0.5877852522924731}, {1, 0}, {0.8090169943749475,
         0.5877852522924731}, {0.30901699437494745`, 
        0.9510565162951535}, {-0.30901699437494745`, 
        0.9510565162951535}, {-0.8090169943749475, 0.5877852522924731}, {-1, 
        0}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.30901699437494745`, -0.9510565162951535}}]],
     RegularPolygon[10]],
    ImageSize->{99.5859375, Automatic}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[4]=",ExpressionUUID->"989360cb-fbb2-45a9-aa2f-94a612528180"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Style",
  BaseStyle->"Link"],
 " works inside ",
 ButtonBox["Graphics",
  BaseStyle->"Link"],
 ", so you can use it to give colors."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:30", "i:6"},ExpressionUUID->"3eed2b0a-e8cb-4c4b-ae80-be4285baf9a8"],

Cell["Here\[CloseCurlyQuote]s an orange pentagon:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1d3b2d66-1203-4390-a057-c7f218521a2a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"RegularPolygon", "[", "5", "]"}], ",", "Orange"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"86f277ec-f257-49dc-92ff-a3f3c05fc12b"],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0], 
   InterpretationBox[
    PolygonBox[
     NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
       1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
        Rational[1, 4] (-1 + 
         5^Rational[1, 2])}, {-(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
       0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
       0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
       0.30901699437494745`}, {-0.5877852522924731, -0.8090169943749475}}]],
    RegularPolygon[5]]},
  ImageSize->{99.8671875, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"2d586b58-b7d0-49fb-b8b9-46bbc4e4fc4e"]
}, Open  ]],

Cell[TextData[{
 "The Wolfram Language works in 3D as well as 2D, with constructs such as ",
 ButtonBox["Sphere",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Cylinder",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Cone",
  BaseStyle->"Link"],
 ". When you have 3D graphics, you can rotate them around interactively to \
see different angles. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"1dd8d28a-ad03-4b60-b154-afebd9c81bbf"],

Cell["Display a sphere in 3D:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"24490059-cdae-4d14-acce-8537ef0c3b23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", "\[ThinSpace]", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"11186c8a-9592-42fa-bb44-406ecfa3ae4f"],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  ImageSize->{130.00584357116065`, 145.},
  ViewPoint->{-3.200530209268464, 1.0848784312232203`, 0.17217772511741364`},
  ViewVertical->{-0.3095037561838348, 
   0.9459007428402892, -0.09736123254297155}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"9c1bfec6-c3f9-403c-b206-83d36fac9aef"]
}, Open  ]],

Cell["A list of a cone and a cylinder:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e2ced2fa-dc0b-4186-ad1c-170f118ffa2d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cone", "[", "\[ThinSpace]", "]"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cylinder", "[", "\[ThinSpace]", "]"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"e9a13030-a843-416e-857c-c7a17e26f5a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[ConeBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->{124.796875, Automatic},
    ViewPoint->{1.2289008638104952`, -2.648056213212283, 1.7110233658818461`},
    
    ViewVertical->{-0.044095757677058006`, -0.13625184077530939`, 
     0.9896923764686814}], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->{125.18359375, Automatic},
    ViewPoint->{-0.5542986335598435, -2.9053184858977223`, 
     1.6437388844748595`},
    ViewVertical->{-0.2969690428695868, -0.09411999555062647, 
     0.9502372409112746}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"1a977b5c-4d8a-4664-aeb1-9574d3faae41"]
}, Open  ]],

Cell["A yellow sphere:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"88cbfa70-7645-457d-809d-96738a79411c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "\[ThinSpace]", "]"}], ",", "Yellow"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"b35431ef-2800-4e09-b86c-4c86e419abd5"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}]},
  ImageSize->{150.203125, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"ed1bb84d-0b8f-4ca7-aa7f-7185b3c9a596"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:31",ExpressionUUID->"0a66cc09-2ba4-4844-9468-ee875b97c52c"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"CodeLink"], "[", " ", "]"}], " ", Cell[
    "specify a circle ", "VocabularyText",ExpressionUUID->
     "afb4c25a-b454-4c41-b174-60f0b1464dd1"]},
   {
    RowBox[{
     ButtonBox["Disk",
      BaseStyle->"CodeLink"], "[", " ", "]"}], " ", Cell[
    "specify a filled\[Hyphen]in disk ", "VocabularyText",ExpressionUUID->
     "5ced393c-d692-4b9c-b52a-9937e6dec807"]},
   {
    RowBox[{
     ButtonBox["RegularPolygon",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["n", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "specify a regular polygon with ",
     Cell[BoxData[
      StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "df2b9cb9-a0fe-4ca2-b7c6-066a9e8ef318"],
     " sides "
    }], "VocabularyText",ExpressionUUID->
     "1956b4bf-3807-4338-8f8c-a8c67bd18490"]},
   {
    RowBox[{
     ButtonBox["Graphics",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["object", "CodeVariableLrg"], "]"}], " ", Cell[
    "display an object as graphics ", "VocabularyText",ExpressionUUID->
     "2a41cf9d-116f-47e3-99c5-2a79118550c3"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Sphere",
       BaseStyle->"CodeLink"], "[", " ", "]"}], ",", " ", 
     RowBox[{
      ButtonBox["Cylinder",
       BaseStyle->"CodeLink"], "[", " ", "]"}], ",", " ", 
     RowBox[{
      ButtonBox["Cone",
       BaseStyle->"CodeLink"], "[", " ", "]"}], ",", " ", 
     StyleBox["...", "GrayPointSix"]}], " ", Cell[
    "specify 3D geometric shapes ", "VocabularyText",ExpressionUUID->
     "21235528-5628-43ca-a02c-59e35aaf72e5"]},
   {
    RowBox[{
     ButtonBox["Graphics3D",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["object", "CodeVariableLrg"], "]"}], " ", Cell[
    "display an object as 3D graphics ", "VocabularyText",ExpressionUUID->
     "52ef2d51-54ef-42af-8a78-a011e10dc4bb"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True}, 
     False}}},ExpressionUUID->"cb5a3ab6-7181-4405-b2b9-ad91045a11e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"832b3699-f612-466c-ab47-f2650fbd754f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 3 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-08-basic-graphics-objects-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bc8c65b9-14dc-4561-b8f3-65d6ee7b44d2"],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["RegularPolygon",
  BaseStyle->"Link"],
 " to draw a triangle.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"1ebf97f5-7926-4979-adf1-45d49e9e3d28"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        InterpretationBox[
         PolygonBox[
          NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, 
            1}, {Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{
            0.8660254037844386, -0.5}, {0, 1}, {-0.8660254037844386, -0.5}}]],
         
         RegularPolygon[3]],
        ImageSize->{100.26953125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"973e21b7-253d-432c-8886-90a7fd82121d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[1, 2] 3^Rational[1, 2], 
               Rational[-1, 2]}, {0, 1}, {Rational[-1, 2] 3^Rational[1, 2], 
               Rational[-1, 2]}}, {{0.8660254037844386, -0.5}, {0, 
              1}, {-0.8660254037844386, -0.5}}]], 
           RegularPolygon[3]], ImageSize -> {100.26953125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"57d76980-c0a3-4a84-a188-9c356a8efaea"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make graphics of a red circle.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"de13ee41-dae5-4750-bd3b-e479f8f6fea3"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        {RGBColor[1, 0, 0], CircleBox[{0, 0}]},
        ImageSize->{100.34375, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "a274ceda-a588-4fb2-a60f-0f42d7c3f780"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[1, 0, 0], 
             CircleBox[{0, 0}]}}}, ImageSize -> {100.34375, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"10eb606d-5307-4e41-afaf-4ec12b08e38e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a red octagon.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bfe60903-4548-4909-85c8-e56ee1ed4f2c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        {RGBColor[1, 0, 0], 
         InterpretationBox[
          PolygonBox[
           NCache[{{Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
             Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
             Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {
             Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
              Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
              Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {-
              Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {-
              Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}}, {{
            0.3826834323650898, -0.9238795325112867}, {
            0.9238795325112867, -0.3826834323650898}, {0.9238795325112867, 
            0.3826834323650898}, {0.3826834323650898, 
            0.9238795325112867}, {-0.3826834323650898, 
            0.9238795325112867}, {-0.9238795325112867, 
            0.3826834323650898}, {-0.9238795325112867, -0.3826834323650898}, \
{-0.3826834323650898, -0.9238795325112867}}]],
          RegularPolygon[8]]},
        ImageSize->{99.63671875, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"a6e51e22-6dda-4eb1-8644-62bc357c7ef9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[1, 0, 0], 
             InterpretationBox[
              PolygonBox[
               NCache[{{
                  Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
                  Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
                  Cos[Rational[1, 8] Pi], 
                  Sin[Rational[1, 8] Pi]}, {
                  Sin[Rational[1, 8] Pi], 
                  Cos[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], 
                  Cos[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], 
                  Sin[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], -
                  Sin[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], -
                  Cos[Rational[1, 8] Pi]}}, {{
                0.3826834323650898, -0.9238795325112867}, {
                0.9238795325112867, -0.3826834323650898}, {0.9238795325112867,
                 0.3826834323650898}, {0.3826834323650898, 
                0.9238795325112867}, {-0.3826834323650898, 
                0.9238795325112867}, {-0.9238795325112867, 
                0.3826834323650898}, {-0.9238795325112867, \
-0.3826834323650898}, {-0.3826834323650898, -0.9238795325112867}}]], 
              RegularPolygon[8]]}}}, ImageSize -> {99.63671875, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1fcf793a-f3f3-4be3-a2d1-df1b375cdd84"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list whose elements are disks with hues varying from 0 to 1 in steps \
of 0.1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6ed19df9-9e88-46ff-a8bf-4c2014b62a79"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          {Hue[0.], DiskBox[{0, 0}]},
          ImageSize->{99.87890625, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.1], DiskBox[{0, 0}]},
          ImageSize->{99.765625, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.2], DiskBox[{0, 0}]},
          ImageSize->{100.06640625, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.30000000000000004`], DiskBox[{0, 0}]},
          ImageSize->{100.44921875, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.4], DiskBox[{0, 0}]},
          ImageSize->{100.2890625, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.5], DiskBox[{0, 0}]},
          ImageSize->{99.7734375, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.6000000000000001], DiskBox[{0, 0}]},
          ImageSize->{99.68359375, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.7000000000000001], DiskBox[{0, 0}]},
          ImageSize->{99.72265625, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.8], DiskBox[{0, 0}]},
          ImageSize->{100.15234375, Automatic}], ",", 
         GraphicsBox[
          {Hue[0.9], DiskBox[{0, 0}]},
          ImageSize->{100.10546875, Automatic}], ",", 
         GraphicsBox[
          {Hue[1.], DiskBox[{0, 0}]},
          ImageSize->{99.890625, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"14a07105-a4e0-4fc4-9c0e-fc2b95a1dff2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{{
                 Hue[0.], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.87890625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.1], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.765625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.2], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {100.06640625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.30000000000000004`], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {100.44921875, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.4], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {100.2890625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.5], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.7734375, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.6000000000000001], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.68359375, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.7000000000000001], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.72265625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.8], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {100.15234375, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[0.9], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {100.10546875, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 Hue[1.], 
                 DiskBox[{0, 0}]}}}, ImageSize -> {99.890625, Automatic}]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cb9c9256-5391-4fce-a2c4-439e99a31d27"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a column of a red and a green triangle.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ad3627c2-5c3f-4b39-befb-ed181e98565f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           GraphicsBox[
            {RGBColor[1, 0, 0], 
             
             InterpretationBox[
              PolygonBox[
               NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0,
                  1}, {Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{
                 0.8660254037844386, -0.5}, {0, 
                 1}, {-0.8660254037844386, -0.5}}]],
              RegularPolygon[3]]},
            ImageSize->{99.625, Automatic}]},
          {
           GraphicsBox[
            {RGBColor[0, 1, 0], 
             
             InterpretationBox[
              PolygonBox[
               NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0,
                  1}, {Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{
                 0.8660254037844386, -0.5}, {0, 
                 1}, {-0.8660254037844386, -0.5}}]],
              RegularPolygon[3]]},
            ImageSize->{99.734375, Automatic}]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "6d96597a-d492-4f0b-af46-e29b3d35047b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             GraphicsBox[{{{
                 RGBColor[1, 0, 0], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{Rational[1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}, {0, 1}, {
                    Rational[-1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}}, {{0.8660254037844386, -0.5}, {0, 
                    1}, {-0.8660254037844386, -0.5}}]], 
                  RegularPolygon[3]]}}}, ImageSize -> {99.625, Automatic}]}, {
            
             GraphicsBox[{{{
                 RGBColor[0, 1, 0], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{Rational[1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}, {0, 1}, {
                    Rational[-1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}}, {{0.8660254037844386, -0.5}, {0, 
                    1}, {-0.8660254037844386, -0.5}}]], 
                  RegularPolygon[3]]}}}, 
              ImageSize -> {99.734375, Automatic}]}}, DefaultBaseStyle -> 
           "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e3982da0-946d-4957-8773-d29d69a25624"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list giving the regular polygons with 5 through 10 sides, with each \
polygon being colored pink.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f4d221ad-3c95-4f06-a394-62818a552ffb"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.8828125, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 
               0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
               Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
               Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
               0.5, -0.8660254037844386}, {1, 0}, {0.5, 
               0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
               0}, {-0.5, -0.8660254037844386}}]],
            RegularPolygon[6]]},
          ImageSize->{99.90234375, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
               Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
               Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {0, 
               1}, {-Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {-
                Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {-
                Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}}, {{
               0.4338837391175581, -0.9009688679024191}, {
               0.9749279121818236, -0.2225209339563144}, {0.7818314824680298, 
               0.6234898018587335}, {0, 1}, {-0.7818314824680298, 
               0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]],
            RegularPolygon[7]]},
          ImageSize->{100.44921875, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
               Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
               Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {
               Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
                Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
                Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {-
                Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {-
                Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}}, {{
              0.3826834323650898, -0.9238795325112867}, {
              0.9238795325112867, -0.3826834323650898}, {0.9238795325112867, 
              0.3826834323650898}, {0.3826834323650898, 
              0.9238795325112867}, {-0.3826834323650898, 
              0.9238795325112867}, {-0.9238795325112867, 
              0.3826834323650898}, {-0.9238795325112867, \
-0.3826834323650898}, {-0.3826834323650898, -0.9238795325112867}}]],
            RegularPolygon[8]]},
          ImageSize->{100.8984375, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}, {
               Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
               Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
               Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {0, 
               1}, {-Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {-
                Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
               Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {-
                Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}}, {{
               0.3420201433256687, -0.9396926207859084}, {
               0.8660254037844386, -0.5}, {0.984807753012208, 
               0.17364817766693033`}, {0.6427876096865393, 
               0.766044443118978}, {0, 1}, {-0.6427876096865393, 
               0.766044443118978}, {-0.984807753012208, 
               0.17364817766693033`}, {-0.8660254037844386, -0.5}, \
{-0.3420201433256687, -0.9396926207859084}}]],
            RegularPolygon[9]]},
          ImageSize->{100.359375, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[1, 0.5, 0.5], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{
               Rational[1, 4] (-1 + 
                 5^Rational[1, 2]), -(Rational[5, 8] + 
                  Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
               Rational[1, 4] (1 + 
                 5^Rational[1, 2]), -(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}, {
               Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
               Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
               Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
               Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 0}, {
               Rational[1, 4] (-1 - 5^
                 Rational[1, 2]), -(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
               Rational[1, 4] (1 - 5^
                 Rational[1, 2]), -(Rational[5, 8] + 
                  Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
               0.30901699437494745`, -0.9510565162951535}, {
               0.8090169943749475, -0.5877852522924731}, {1, 0}, {
               0.8090169943749475, 0.5877852522924731}, {0.30901699437494745`,
                0.9510565162951535}, {-0.30901699437494745`, 
               0.9510565162951535}, {-0.8090169943749475, 
               0.5877852522924731}, {-1, 
               0}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.30901699437494745`, -0.9510565162951535}}]],
            RegularPolygon[10]]},
          ImageSize->{99.79296875, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"2051dc3d-d230-42aa-9683-6080cecee3b3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.8828125, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{
                    Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 
                    0}, {
                    Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
                    Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 
                    0}, {
                    Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
                    0.5, -0.8660254037844386}, {1, 0}, {0.5, 
                    0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
                    0}, {-0.5, -0.8660254037844386}}]], 
                  RegularPolygon[6]]}}}, 
              ImageSize -> {99.90234375, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{
                    Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
                    Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
                    Cos[Rational[3, 14] Pi], 
                    Sin[Rational[3, 14] Pi]}, {0, 
                    1}, {-Cos[Rational[3, 14] Pi], 
                    Sin[Rational[3, 14] Pi]}, {-Cos[Rational[1, 14] Pi], -
                    Sin[Rational[1, 14] Pi]}, {-Sin[Rational[1, 7] Pi], -
                    Cos[Rational[1, 7] Pi]}}, {{
                    0.4338837391175581, -0.9009688679024191}, {
                    0.9749279121818236, -0.2225209339563144}, {
                    0.7818314824680298, 0.6234898018587335}, {0, 
                    1}, {-0.7818314824680298, 
                    0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]], 
                  RegularPolygon[7]]}}}, 
              ImageSize -> {100.44921875, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{
                    Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
                    Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
                    Cos[Rational[1, 8] Pi], 
                    Sin[Rational[1, 8] Pi]}, {
                    Sin[Rational[1, 8] Pi], 
                    Cos[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], 
                    Cos[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], 
                    Sin[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], -
                    Sin[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], -
                    Cos[Rational[1, 8] Pi]}}, {{
                    0.3826834323650898, -0.9238795325112867}, {
                    0.9238795325112867, -0.3826834323650898}, {
                    0.9238795325112867, 0.3826834323650898}, {
                    0.3826834323650898, 
                    0.9238795325112867}, {-0.3826834323650898, 
                    0.9238795325112867}, {-0.9238795325112867, 
                    0.3826834323650898}, {-0.9238795325112867, \
-0.3826834323650898}, {-0.3826834323650898, -0.9238795325112867}}]], 
                  RegularPolygon[8]]}}}, 
              ImageSize -> {100.8984375, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   NCache[{{
                    Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}, {
                    Rational[1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}, {
                    Cos[Rational[1, 18] Pi], 
                    Sin[Rational[1, 18] Pi]}, {
                    Sin[Rational[2, 9] Pi], 
                    Cos[Rational[2, 9] Pi]}, {0, 1}, {-Sin[Rational[2, 9] Pi], 
                    Cos[Rational[2, 9] Pi]}, {-Cos[Rational[1, 18] Pi], 
                    Sin[Rational[1, 18] Pi]}, {
                    Rational[-1, 2] 3^Rational[1, 2], 
                    Rational[-1, 2]}, {-Sin[Rational[1, 9] Pi], -
                    Cos[Rational[1, 9] Pi]}}, {{
                    0.3420201433256687, -0.9396926207859084}, {
                    0.8660254037844386, -0.5}, {0.984807753012208, 
                    0.17364817766693033`}, {0.6427876096865393, 
                    0.766044443118978}, {0, 1}, {-0.6427876096865393, 
                    0.766044443118978}, {-0.984807753012208, 
                    0.17364817766693033`}, {-0.8660254037844386, -0.5}, \
{-0.3420201433256687, -0.9396926207859084}}]], 
                  RegularPolygon[9]]}}}, 
              ImageSize -> {100.359375, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[1, 0.5, 0.5], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                    Rational[1, 4] (1 + 
                    5^Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 
                    0}, {
                    Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                    Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                    Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                    Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 
                    0}, {Rational[1, 4] (-1 - 5^
                    Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                    Rational[1, 4] (1 - 5^
                    Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
                    0.30901699437494745`, -0.9510565162951535}, {
                    0.8090169943749475, -0.5877852522924731}, {1, 0}, {
                    0.8090169943749475, 0.5877852522924731}, {
                    0.30901699437494745`, 
                    0.9510565162951535}, {-0.30901699437494745`, 
                    0.9510565162951535}, {-0.8090169943749475, 
                    0.5877852522924731}, {-1, 
                    0}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.30901699437494745`, -0.9510565162951535}}]], 
                  RegularPolygon[10]]}}}, 
              ImageSize -> {99.79296875, Automatic}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c7527151-a3c7-4df3-9ad4-c4b92bfb645a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graphic of a purple cylinder.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1aeaff63-0851-4f34-8ae4-05c32cca32c7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       Graphics3DBox[
        {RGBColor[0.5, 0, 0.5], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
        ImageSize->{129.88671875, Automatic},
        ViewPoint->{1.3, -2.4, 2.},
        ViewVertical->{0., 0., 1.}]], "ExerciseOutput",ExpressionUUID->
       "f719b24a-7aa8-4fbd-aba8-c0fb49a3cf7f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         Graphics3DBox[{{
            RGBColor[0.5, 0, 0.5], 
            CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}}, 
          ImageSize -> {129.88671875, Automatic}, 
          ViewPoint -> {1.3, -2.4, 2.}, ViewVertical -> {0., 0., 1.}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"91e60fa7-3b17-4f3e-aece-fcd8325f4775"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of polygons with 8, 7, 6, ",
 StyleBox["... ",
  FontColor->GrayLevel[0.6]],
 ", 3 sides, and colored with ",
 ButtonBox["RandomColor",
  BaseStyle->"Link"],
 ", then show them all overlaid with the triangle on top (hint: apply ",
 ButtonBox["Graphics",
  BaseStyle->"Link"],
 " to the list).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "8.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c4c0a21e-7db2-4ce9-a8c3-7223437a0b81"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {RGBColor[
          0.6980891104968034, 0.3015433157806584, 0.021776585991452047`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
              Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
              Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {
              Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
               Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
               Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {-
               Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {-
               Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}}, {{
             0.3826834323650898, -0.9238795325112867}, {
             0.9238795325112867, -0.3826834323650898}, {0.9238795325112867, 
             0.3826834323650898}, {0.3826834323650898, 
             0.9238795325112867}, {-0.3826834323650898, 
             0.9238795325112867}, {-0.9238795325112867, 
             0.3826834323650898}, {-0.9238795325112867, -0.3826834323650898}, \
{-0.3826834323650898, -0.9238795325112867}}]],
           RegularPolygon[8]]}, 
         {RGBColor[
          0.9204834447430632, 0.726198355058379, 0.14477917007761354`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
              Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
              Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {0, 
              1}, {-Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {-
               Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {-
               Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}}, {{
              0.4338837391175581, -0.9009688679024191}, {
              0.9749279121818236, -0.2225209339563144}, {0.7818314824680298, 
              0.6234898018587335}, {0, 1}, {-0.7818314824680298, 
              
              0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]],
           RegularPolygon[7]]}, 
         {RGBColor[
          0.2905042313178894, 0.25113718203540114`, 0.44484628006209004`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 
              0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
              Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
              Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
              0.5, -0.8660254037844386}, {1, 0}, {0.5, 
              0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
              0}, {-0.5, -0.8660254037844386}}]],
           RegularPolygon[6]]}, 
         {RGBColor[
          0.8709229465487689, 0.06624369173373856, 0.15714465968095337`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2], 
               Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
              1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
               Rational[1, 4] (-1 + 
                5^Rational[1, 2])}, {-(Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
              0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
              0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
              0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
           RegularPolygon[5]]}, 
         {RGBColor[
          0.818563827910167, 0.5684199787999562, 0.027168699878193925`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
              2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 2^
               Rational[-1, 2]}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{
             0.7071067811865475, -0.7071067811865475}, {0.7071067811865475, 
             0.7071067811865475}, {-0.7071067811865475, 
             
             0.7071067811865475}, {-0.7071067811865475, \
-0.7071067811865475}}]],
           RegularPolygon[4]]}, 
         {RGBColor[
          0.9317888268057881, 0.004467126778863628, 0.45367393162729686`], 
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, 
              1}, {Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{
              0.8660254037844386, -0.5}, {0, 
              1}, {-0.8660254037844386, -0.5}}]],
           RegularPolygon[3]]}}]], "ExerciseOutput",ExpressionUUID->
       "7268608b-eb89-40cd-861b-d7cad8e4e844"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{
             RGBColor[
             0.6980891104968034, 0.3015433157806584, 0.021776585991452047`], 
             InterpretationBox[
              PolygonBox[
               NCache[{{
                  Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
                  Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
                  Cos[Rational[1, 8] Pi], 
                  Sin[Rational[1, 8] Pi]}, {
                  Sin[Rational[1, 8] Pi], 
                  Cos[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], 
                  Cos[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], 
                  Sin[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], -
                  Sin[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], -
                  Cos[Rational[1, 8] Pi]}}, {{
                0.3826834323650898, -0.9238795325112867}, {
                0.9238795325112867, -0.3826834323650898}, {0.9238795325112867,
                 0.3826834323650898}, {0.3826834323650898, 
                0.9238795325112867}, {-0.3826834323650898, 
                0.9238795325112867}, {-0.9238795325112867, 
                0.3826834323650898}, {-0.9238795325112867, \
-0.3826834323650898}, {-0.3826834323650898, -0.9238795325112867}}]], 
              RegularPolygon[8]]}}, {{
             RGBColor[
             0.9204834447430632, 0.726198355058379, 0.14477917007761354`], 
             InterpretationBox[
              PolygonBox[
               NCache[{{
                  Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
                  Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
                  Cos[Rational[3, 14] Pi], 
                  Sin[Rational[3, 14] Pi]}, {0, 1}, {-Cos[Rational[3, 14] Pi], 
                  Sin[Rational[3, 14] Pi]}, {-Cos[Rational[1, 14] Pi], -
                  Sin[Rational[1, 14] Pi]}, {-Sin[Rational[1, 7] Pi], -
                  Cos[Rational[1, 7] Pi]}}, {{
                 0.4338837391175581, -0.9009688679024191}, {
                 0.9749279121818236, -0.2225209339563144}, {
                 0.7818314824680298, 0.6234898018587335}, {0, 
                 1}, {-0.7818314824680298, 
                 0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]], 
              RegularPolygon[7]]}}, {{
             RGBColor[
             0.2905042313178894, 0.25113718203540114`, 0.44484628006209004`], 
             
             InterpretationBox[
              PolygonBox[
               NCache[{{
                  Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 0}, {
                 
                  Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
                  Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
                  Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
                 0.5, -0.8660254037844386}, {1, 0}, {0.5, 
                 0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
                 0}, {-0.5, -0.8660254037844386}}]], 
              RegularPolygon[6]]}}, {{
             RGBColor[
             0.8709229465487689, 0.06624369173373856, 0.15714465968095337`], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                  Rational[1, 2], 
                  Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                   Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                  Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                 1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 
                  Rational[1, 4] (-1 + 
                   5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                  Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                 0.5877852522924731, -0.8090169943749475}, {
                 0.9510565162951535, 0.30901699437494745`}, {0, 
                 1}, {-0.9510565162951535, 
                 0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
              RegularPolygon[5]]}}, {{
             RGBColor[
             0.818563827910167, 0.5684199787999562, 0.027168699878193925`], 
             InterpretationBox[
              PolygonBox[
               
               NCache[{{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
                 2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 
                  2^Rational[-1, 2]}, {-2^Rational[-1, 2], -2^
                   Rational[-1, 2]}}, {{
                0.7071067811865475, -0.7071067811865475}, {0.7071067811865475,
                 0.7071067811865475}, {-0.7071067811865475, 
                0.7071067811865475}, {-0.7071067811865475, \
-0.7071067811865475}}]], 
              RegularPolygon[4]]}}, {{
             RGBColor[
             0.9317888268057881, 0.004467126778863628, 0.45367393162729686`], 
             
             InterpretationBox[
              PolygonBox[
               NCache[{{Rational[1, 2] 3^Rational[1, 2], 
                  Rational[-1, 2]}, {0, 1}, {Rational[-1, 2] 3^Rational[1, 2], 
                  Rational[-1, 2]}}, {{0.8660254037844386, -0.5}, {0, 
                 1}, {-0.8660254037844386, -0.5}}]], 
              RegularPolygon[3]]}}}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fa1650e1-6a3a-4574-bbae-4e47a9d2cb94"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of 10 regular pentagons with random colors. ",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"31ce6f4f-afda-4ef7-9030-b2d19ba1c1b2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          {RGBColor[
           0.6722448646234545, 0.19318038699405848`, 0.6492761665359046], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.67578125, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.949990755667937, 0.11235487177177972`, 0.8799286798601229], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.69921875, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.081865809423328, 0.5520414328538332, 0.6175577039110456], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.51953125, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.1533939031761904, 0.24776642722399722`, 0.1244339294843082], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.65625, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.10556011716477243`, 0.3281787871874233, 0.4591580705612983], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{100.3046875, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.9456430231893671, 0.20030558886972316`, 0.9602253221082084], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.86328125, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.2215712342407683, 0.14046598000916988`, 0.2408119764878407], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{100.19140625, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.08277332320297148, 0.28226027720379276`, 0.09589607259242361], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.65625, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.08600965894885815, 0.4291889786700891, 0.635097180784925], 
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{99.62109375, Automatic}], ",", 
         GraphicsBox[
          {RGBColor[
           0.10033224807312435`, 0.9792177565036952, 0.4204916474217506], 
           
           InterpretationBox[
            PolygonBox[
             NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
               1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                 Rational[1, 2], 
                Rational[1, 4] (-1 + 
                 5^Rational[1, 2])}, {-(Rational[5, 8] + 
                  Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
               0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
               0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
               0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
            RegularPolygon[5]]},
          ImageSize->{100.25390625, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"8100e8d0-6d27-4900-b607-58dd8a285c56"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{{
                 RGBColor[
                 0.6722448646234545, 0.19318038699405848`, 
                  0.6492761665359046], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.67578125, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.949990755667937, 0.11235487177177972`, 0.8799286798601229], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.69921875, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.081865809423328, 0.5520414328538332, 0.6175577039110456], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.51953125, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.1533939031761904, 0.24776642722399722`, 
                  0.1244339294843082], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, ImageSize -> {99.65625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.10556011716477243`, 0.3281787871874233, 
                  0.4591580705612983], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {100.3046875, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.9456430231893671, 0.20030558886972316`, 
                  0.9602253221082084], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.86328125, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.2215712342407683, 0.14046598000916988`, 
                  0.2408119764878407], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {100.19140625, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.08277332320297148, 0.28226027720379276`, 
                  0.09589607259242361], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, ImageSize -> {99.65625, Automatic}], 
             ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.08600965894885815, 0.4291889786700891, 0.635097180784925], 
                 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {99.62109375, Automatic}], ",", 
             GraphicsBox[{{{
                 RGBColor[
                 0.10033224807312435`, 0.9792177565036952, 
                  0.4204916474217506], 
                 InterpretationBox[
                  PolygonBox[
                   
                   NCache[{{(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                    1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                    Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                    Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                    0.5877852522924731, -0.8090169943749475}, {
                    0.9510565162951535, 0.30901699437494745`}, {0, 
                    1}, {-0.9510565162951535, 
                    0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
                  RegularPolygon[5]]}}}, 
              ImageSize -> {100.25390625, Automatic}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f8e6f622-034e-4015-82f6-4505e97833fb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of a 20-sided regular polygon and a disk.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"90bd60a4-5474-40b3-9281-ef5ccecf63d9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 20] Pi], -Cos[Rational[1, 20] Pi]}, {
              Sin[Rational[3, 20] Pi], -Cos[Rational[3, 20] Pi]}, {
              2^Rational[-1, 2], -2^Rational[-1, 2]}, {
              Cos[Rational[3, 20] Pi], -Sin[Rational[3, 20] Pi]}, {
              Cos[Rational[1, 20] Pi], -Sin[Rational[1, 20] Pi]}, {
              Cos[Rational[1, 20] Pi], Sin[Rational[1, 20] Pi]}, {
              Cos[Rational[3, 20] Pi], Sin[Rational[3, 20] Pi]}, {
              2^Rational[-1, 2], 2^Rational[-1, 2]}, {
              Sin[Rational[3, 20] Pi], Cos[Rational[3, 20] Pi]}, {
              Sin[Rational[1, 20] Pi], Cos[Rational[1, 20] Pi]}, {-
               Sin[Rational[1, 20] Pi], Cos[Rational[1, 20] Pi]}, {-
               Sin[Rational[3, 20] Pi], Cos[
               Rational[3, 20] Pi]}, {-2^Rational[-1, 2], 2^
               Rational[-1, 2]}, {-Cos[Rational[3, 20] Pi], Sin[
               Rational[3, 20] Pi]}, {-Cos[Rational[1, 20] Pi], Sin[
               Rational[1, 20] Pi]}, {-Cos[Rational[1, 20] Pi], -
               Sin[Rational[1, 20] Pi]}, {-Cos[Rational[3, 20] Pi], -
               Sin[Rational[3, 20] Pi]}, {-2^Rational[-1, 2], -2^
                Rational[-1, 2]}, {-Sin[Rational[3, 20] Pi], -
               Cos[Rational[3, 20] Pi]}, {-Sin[Rational[1, 20] Pi], -
               Cos[Rational[1, 20] Pi]}}, CompressedData["
1:eJxTTMoPSmViYGAQAWIQXRq8Ip2b7Yh9zBP9KSqz3+9nuOeircd31z5Xx1ZW
ofnN/jPW9WnzFjyzh9L7oeL2UHX7ofrsoeag8+3R1NujmWePZp89mnswzIXZ
C1MPcxfMPJi7YebC/IXuT5i5aOr3o5m3H82+/Wju2Q8A6FeQQg==
             "]]],
           RegularPolygon[20]],
          ImageSize->{100.18359375, Automatic}], ",", 
         GraphicsBox[DiskBox[{0, 0}],
          ImageSize->{99.66796875, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"7f7c2217-96c8-44b4-89a2-9ded174ae8a3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{
                   Sin[Rational[1, 20] Pi], -Cos[Rational[1, 20] Pi]}, {
                   Sin[Rational[3, 20] Pi], -Cos[Rational[3, 20] Pi]}, {
                  2^Rational[-1, 2], -2^Rational[-1, 2]}, {
                   Cos[Rational[3, 20] Pi], -Sin[Rational[3, 20] Pi]}, {
                   Cos[Rational[1, 20] Pi], -Sin[Rational[1, 20] Pi]}, {
                   Cos[Rational[1, 20] Pi], 
                   Sin[Rational[1, 20] Pi]}, {
                   Cos[Rational[3, 20] Pi], 
                   Sin[Rational[3, 20] Pi]}, {
                  2^Rational[-1, 2], 2^Rational[-1, 2]}, {
                   Sin[Rational[3, 20] Pi], 
                   Cos[Rational[3, 20] Pi]}, {
                   Sin[Rational[1, 20] Pi], 
                   Cos[Rational[1, 20] Pi]}, {-Sin[Rational[1, 20] Pi], 
                   Cos[Rational[1, 20] Pi]}, {-Sin[Rational[3, 20] Pi], 
                   Cos[Rational[3, 20] Pi]}, {-2^Rational[-1, 2], 2^
                   Rational[-1, 2]}, {-Cos[Rational[3, 20] Pi], 
                   Sin[Rational[3, 20] Pi]}, {-Cos[Rational[1, 20] Pi], 
                   Sin[Rational[1, 20] Pi]}, {-Cos[Rational[1, 20] Pi], -
                   Sin[Rational[1, 20] Pi]}, {-Cos[Rational[3, 20] Pi], -
                   Sin[Rational[3, 20] Pi]}, {-2^Rational[-1, 2], -2^
                    Rational[-1, 2]}, {-Sin[Rational[3, 20] Pi], -
                   Cos[Rational[3, 20] Pi]}, {-Sin[Rational[1, 20] Pi], -
                   Cos[Rational[1, 20] Pi]}}, CompressedData["
1:eJxTTMoPSmViYGAQAWIQXRq8Ip2b7Yh9zBP9KSqz3+9nuOeircd31z5Xx1ZW
ofnN/jPW9WnzFjyzh9L7oeL2UHX7ofrsoeag8+3R1NujmWePZp89mnswzIXZ
C1MPcxfMPJi7YebC/IXuT5i5aOr3o5m3H82+/Wju2Q8A6FeQQg==
                 "]]], 
               RegularPolygon[20]], ImageSize -> {100.18359375, Automatic}], 
             ",", 
             GraphicsBox[
              DiskBox[{0, 0}], ImageSize -> {99.66796875, Automatic}]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fc5e55dd-2a84-4f7a-a501-671177da8f15"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of polygons with 10, 9, ... , 3 sides.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+8.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"69d9f286-f78a-4bef-a188-8c140f5f3d3a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{
              Rational[1, 4] (-1 + 
                5^Rational[1, 2]), -(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[1, 4] (1 + 
                5^Rational[1, 2]), -(Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}, {
              Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 0}, {
              Rational[1, 4] (-1 - 5^
                Rational[1, 2]), -(Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
              Rational[1, 4] (1 - 5^
                Rational[1, 2]), -(Rational[5, 8] + 
                 Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
              0.30901699437494745`, -0.9510565162951535}, {
              0.8090169943749475, -0.5877852522924731}, {1, 0}, {
              0.8090169943749475, 0.5877852522924731}, {0.30901699437494745`, 
              0.9510565162951535}, {-0.30901699437494745`, 
              0.9510565162951535}, {-0.8090169943749475, 
              0.5877852522924731}, {-1, 
              0}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.30901699437494745`, -0.9510565162951535}}]],
           RegularPolygon[10]],
          ImageSize->{99.7109375, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}, {
              Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
              Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
              Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {0, 
              1}, {-Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}, {-
               Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
              Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {-
               Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}}, {{
              0.3420201433256687, -0.9396926207859084}, {
              0.8660254037844386, -0.5}, {0.984807753012208, 
              0.17364817766693033`}, {0.6427876096865393, 
              0.766044443118978}, {0, 1}, {-0.6427876096865393, 
              0.766044443118978}, {-0.984807753012208, 
              0.17364817766693033`}, {-0.8660254037844386, -0.5}, \
{-0.3420201433256687, -0.9396926207859084}}]],
           RegularPolygon[9]],
          ImageSize->{99.58203125, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
              Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
              Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {
              Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
               Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {-
               Cos[Rational[1, 8] Pi], Sin[Rational[1, 8] Pi]}, {-
               Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {-
               Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}}, {{
             0.3826834323650898, -0.9238795325112867}, {
             0.9238795325112867, -0.3826834323650898}, {0.9238795325112867, 
             0.3826834323650898}, {0.3826834323650898, 
             0.9238795325112867}, {-0.3826834323650898, 
             0.9238795325112867}, {-0.9238795325112867, 
             0.3826834323650898}, {-0.9238795325112867, -0.3826834323650898}, \
{-0.3826834323650898, -0.9238795325112867}}]],
           RegularPolygon[8]],
          ImageSize->{100.4921875, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
              Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
              Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {0, 
              1}, {-Cos[Rational[3, 14] Pi], Sin[Rational[3, 14] Pi]}, {-
               Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {-
               Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}}, {{
              0.4338837391175581, -0.9009688679024191}, {
              0.9749279121818236, -0.2225209339563144}, {0.7818314824680298, 
              0.6234898018587335}, {0, 1}, {-0.7818314824680298, 
              0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]],
           RegularPolygon[7]],
          ImageSize->{99.75, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 
              0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
              Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 0}, {
              Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
              0.5, -0.8660254037844386}, {1, 0}, {0.5, 
              0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
              0}, {-0.5, -0.8660254037844386}}]],
           RegularPolygon[6]],
          ImageSize->{99.8671875, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
               Rational[1, 2], 
               Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
              1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                Rational[1, 2], 
               Rational[1, 4] (-1 + 
                5^Rational[1, 2])}, {-(Rational[5, 8] + 
                 Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
               Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
              0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
              0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
              0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]],
           RegularPolygon[5]],
          ImageSize->{100.4921875, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
              2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 2^
               Rational[-1, 2]}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{
             0.7071067811865475, -0.7071067811865475}, {0.7071067811865475, 
             0.7071067811865475}, {-0.7071067811865475, 
             0.7071067811865475}, {-0.7071067811865475, \
-0.7071067811865475}}]],
           RegularPolygon[4]],
          ImageSize->{100.39453125, Automatic}], ",", 
         GraphicsBox[
          
          InterpretationBox[
           PolygonBox[
            NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, 
              1}, {Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{
              0.8660254037844386, -0.5}, {0, 
              1}, {-0.8660254037844386, -0.5}}]],
           RegularPolygon[3]],
          ImageSize->{100.0390625, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"2ca2a8ab-54a9-4d6e-9b43-41708e14fdf7"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                
                NCache[{{
                  Rational[1, 4] (-1 + 
                    5^Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                  Rational[1, 4] (1 + 
                    5^Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 
                  0}, {Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                  Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                  Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                  Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-1, 
                  0}, {Rational[1, 4] (-1 - 5^
                    Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
                  Rational[1, 4] (1 - 5^
                    Rational[1, 2]), -(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
                  0.30901699437494745`, -0.9510565162951535}, {
                  0.8090169943749475, -0.5877852522924731}, {1, 0}, {
                  0.8090169943749475, 0.5877852522924731}, {
                  0.30901699437494745`, 
                  0.9510565162951535}, {-0.30901699437494745`, 
                  0.9510565162951535}, {-0.8090169943749475, 
                  0.5877852522924731}, {-1, 
                  0}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.30901699437494745`, -0.9510565162951535}}]], 
               RegularPolygon[10]], ImageSize -> {99.7109375, Automatic}], 
             ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{
                   Sin[Rational[1, 9] Pi], -Cos[Rational[1, 9] Pi]}, {
                  Rational[1, 2] 3^Rational[1, 2], 
                   Rational[-1, 2]}, {
                   Cos[Rational[1, 18] Pi], 
                   Sin[Rational[1, 18] Pi]}, {
                   Sin[Rational[2, 9] Pi], 
                   Cos[Rational[2, 9] Pi]}, {0, 
                  1}, {-Sin[Rational[2, 9] Pi], 
                   Cos[Rational[2, 9] Pi]}, {-Cos[Rational[1, 18] Pi], 
                   Sin[Rational[1, 18] Pi]}, {
                  Rational[-1, 2] 3^Rational[1, 2], 
                   Rational[-1, 2]}, {-Sin[Rational[1, 9] Pi], -
                   Cos[Rational[1, 9] Pi]}}, {{
                  0.3420201433256687, -0.9396926207859084}, {
                  0.8660254037844386, -0.5}, {0.984807753012208, 
                  0.17364817766693033`}, {0.6427876096865393, 
                  0.766044443118978}, {0, 1}, {-0.6427876096865393, 
                  0.766044443118978}, {-0.984807753012208, 
                  0.17364817766693033`}, {-0.8660254037844386, -0.5}, \
{-0.3420201433256687, -0.9396926207859084}}]], 
               RegularPolygon[9]], ImageSize -> {99.58203125, Automatic}], 
             ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{
                   Sin[Rational[1, 8] Pi], -Cos[Rational[1, 8] Pi]}, {
                   Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
                   Cos[Rational[1, 8] Pi], 
                   Sin[Rational[1, 8] Pi]}, {
                   Sin[Rational[1, 8] Pi], 
                   Cos[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], 
                   Cos[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], 
                   Sin[Rational[1, 8] Pi]}, {-Cos[Rational[1, 8] Pi], -
                   Sin[Rational[1, 8] Pi]}, {-Sin[Rational[1, 8] Pi], -
                   Cos[Rational[1, 8] Pi]}}, {{
                 0.3826834323650898, -0.9238795325112867}, {
                 0.9238795325112867, -0.3826834323650898}, {
                 0.9238795325112867, 0.3826834323650898}, {0.3826834323650898,
                  0.9238795325112867}, {-0.3826834323650898, 
                 0.9238795325112867}, {-0.9238795325112867, 
                 0.3826834323650898}, {-0.9238795325112867, \
-0.3826834323650898}, {-0.3826834323650898, -0.9238795325112867}}]], 
               RegularPolygon[8]], ImageSize -> {100.4921875, Automatic}], 
             ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{
                   Sin[Rational[1, 7] Pi], -Cos[Rational[1, 7] Pi]}, {
                   Cos[Rational[1, 14] Pi], -Sin[Rational[1, 14] Pi]}, {
                   Cos[Rational[3, 14] Pi], 
                   Sin[Rational[3, 14] Pi]}, {0, 
                  1}, {-Cos[Rational[3, 14] Pi], 
                   Sin[Rational[3, 14] Pi]}, {-Cos[Rational[1, 14] Pi], -
                   Sin[Rational[1, 14] Pi]}, {-Sin[Rational[1, 7] Pi], -
                   Cos[Rational[1, 7] Pi]}}, {{
                  0.4338837391175581, -0.9009688679024191}, {
                  0.9749279121818236, -0.2225209339563144}, {
                  0.7818314824680298, 0.6234898018587335}, {0, 
                  1}, {-0.7818314824680298, 
                  0.6234898018587335}, {-0.9749279121818236, \
-0.2225209339563144}, {-0.4338837391175581, -0.9009688679024191}}]], 
               RegularPolygon[7]], ImageSize -> {99.75, Automatic}], ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{
                   Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {1, 0}, {
                   Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
                   Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-1, 
                  0}, {
                   Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2]}}, {{
                  0.5, -0.8660254037844386}, {1, 0}, {0.5, 
                  0.8660254037844386}, {-0.5, 0.8660254037844386}, {-1, 
                  0}, {-0.5, -0.8660254037844386}}]], 
               RegularPolygon[6]], ImageSize -> {99.8671875, Automatic}], ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                
                NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
                   Rational[1, 2], 
                   Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
                    Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                   Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
                  1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
                    Rational[1, 2], 
                   Rational[1, 4] (-1 + 
                    5^Rational[1, 2])}, {-(Rational[5, 8] + 
                    Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
                   Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
                  0.5877852522924731, -0.8090169943749475}, {
                  0.9510565162951535, 0.30901699437494745`}, {0, 
                  1}, {-0.9510565162951535, 
                  0.30901699437494745`}, {-0.5877852522924731, \
-0.8090169943749475}}]], 
               RegularPolygon[5]], ImageSize -> {100.4921875, Automatic}], 
             ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                
                NCache[{{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
                  2^Rational[-1, 2], 2^Rational[-1, 2]}, {-2^Rational[-1, 2], 
                   2^Rational[-1, 2]}, {-2^Rational[-1, 2], -2^
                    Rational[-1, 2]}}, {{
                 0.7071067811865475, -0.7071067811865475}, {
                 0.7071067811865475, 
                 0.7071067811865475}, {-0.7071067811865475, 
                 0.7071067811865475}, {-0.7071067811865475, \
-0.7071067811865475}}]], 
               RegularPolygon[4]], ImageSize -> {100.39453125, Automatic}], 
             ",", 
             GraphicsBox[
              InterpretationBox[
               PolygonBox[
                NCache[{{Rational[1, 2] 3^Rational[1, 2], 
                   Rational[-1, 2]}, {0, 1}, {
                  Rational[-1, 2] 3^Rational[1, 2], 
                   Rational[-1, 2]}}, {{0.8660254037844386, -0.5}, {0, 
                  1}, {-0.8660254037844386, -0.5}}]], 
               RegularPolygon[3]], ImageSize -> {100.0390625, Automatic}]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"56aadc35-9d6c-474c-8052-5733d6595cee"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8d188796-0194-48e0-a300-5556752d661d"],

Cell["How can I make graphics with several objects?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"33813904-c76c-4d7d-b9b2-65cbd50db928"],

Cell[TextData[{
 ButtonBox["Section 14",
  BaseStyle->"Hyperlink",
  ButtonData->{
   "EIWL2-14-coordinates-and-graphics.nb", "graphics-with-several-objects"}],
 " will explain. To do so requires understanding ",
 StyleBox["coordinates",
  FontSlant->"Italic"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bebbb661-c0bf-4322-9c46-be638cfc8688"],

Cell[TextData[{
 "Why use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "23e591b1-dfc6-425a-a249-727b0ca70a8f"],
 ", not just ",
 Cell[BoxData[
 "Circle"], "InlineCode",ExpressionUUID->
  "01dd274e-74e8-4384-ba07-b2a1ea697f22"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1179040b-5610-4fe6-922a-9211ce77005e"],

Cell[TextData[{
 "For consistency. As we\[CloseCurlyQuote]ll see in ",
 ButtonBox["Section 14",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-14-coordinates-and-graphics.nb", "circle-x-y"}],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "0de08a4b-0a12-45a4-9b20-132030559fe0"],
 " is actually short for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Circle",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]], "InlineCode",
  ExpressionUUID->"78b9872e-9bde-4e0f-b62b-4d4d7144db81"],
 ", which means a circle of radius 1 and center coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "f85ef828-c3f2-42ce-ab81-0f1744080b3f"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"09ec47dc-1c65-4c39-a140-b25332fd827c"],

Cell["Why isn\[CloseCurlyQuote]t the yellow sphere pure yellow?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3bc2b37-3cec-4c68-afdd-61766f0df17b"],

Cell["\<\
Because the Wolfram Language displays it like an actual 3D object, with \
lighting. If it were pure yellow, you wouldn\[CloseCurlyQuote]t see any 3D \
depth, and it would just look like a 2D disk.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"fd26adcc-2d9b-4b11-abea-84467106dfa1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Note", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e7dd4ae0-c88f-42bf-a001-85fcd1707e27"],

Cell[TextData[{
 "Another way to specify styles for graphics is to give \
\[OpenCurlyDoubleQuote]directives\[CloseCurlyDoubleQuote] in a list, e.g. ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Yellow",
     BaseStyle->"CodeLink"], ",", 
    RowBox[{
     ButtonBox["Disk",
      BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}], ",", 
    ButtonBox["Black",
     BaseStyle->"CodeLink"], ",", 
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"CodeLink"], "[", "\[ThinSpace]", "]"}]}], "}"}]], 
  "InlineCode",ExpressionUUID->"5b56eae1-cf9b-4be4-bbf6-f1530542156a"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bf7bccad-ef24-44e9-837e-dc885637e22c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5dbf1866-07df-40f5-9bfa-45c8107b6e3c"],

Cell[TextData[ButtonBox["Guide to Graphics in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"b54cdd1c-cf94-40f4-bf20-3ec1a9509763"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Basic Graphics Objects: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt
qrwyj6AjcO+ZaN0gLZCZwEMiQVJqSd2qwYvgdBGf/AF4+LFqfvvd37/56y+f
np5++M3pP998+88/fPz47b/+9Hx6+fOHH/72/Yf3f/njh3+8//79x99/96tT
4u9Oz79/8fT066cY9NNLSz++9uPz0+uOPv3n3Zj+40vj083npZktd5IVdJzk
hvT9pHOq78uc9I75rD/KA31n6/z03+dY1lRX64jkQh3LLpevbWI7t6N/Esv/
vdSJDpcOdpr5M74lvk/tt6VPL1VG3j7v79Qedr2XLlevoKDgsTHx8Cud+OTA
XDKM7yfOijnmlB+XC9zvuGfMm+HhqfwR8sjLY54ddbJuw05yesL7Sp2qHtY1
4+F8VjZ4Xajf2/q6Gd/HuUDH6OTvZOM21jHZmm0TsTvH/d531WZOn5o3x3lL
Ys22pnFN87Bezs6CgoLHhFsnMqd1IW1cz26TsrO8nOdSX8bgO+CwZlmHzf2L
OoXbYE08y/2e80AXcDGkbVEuzEXbIAvmA9S/kvuz+aIL5yeJHbTlVHbcQwzT
/BDncT5l6xXuLyh4k4C1Xfb8wZe9Bfcrnr0J949r43H9vV9bl2Oyn2w88Te/
Yx0+DxmiOiddiSyDk2/B/cEGFWPm/GkOeDmavo5zQ5wnaYX7CwreJvy61HGb
cc7uy63g/rEMPLEeg/tl7cxrZa/DpStZ2TOfFTo1Vy5yP88Zk02vGzkTic54
prjx/JDuFWJ501nXXCwS/Wev+9m+aN/Bdrk8dUYVZE1zv7n/4vScHQUFBY8L
f2fpz99PP1v8vob71ROV8efSruxYfj9xojujVuf92cfg/mWdPf88yDp9ed0f
8uXMZJIxroP5zN3ar6Tn6cGOsK5efd6f8S1/3n/6Nzrbirl7sj852yFuk87P
Zfzzmr1VQUHBY2M6+x/HPJnnCddY9yOXjevmkz7kqhut+xPZS9zv1/juvnvc
N3STTv5+R8XCsi+2Y+Joyy67fLijxifxXbhf5uzkeyZ/zt/yt0ADzrXs06RH
fJ7uKI7TnXfh/oKCnwvgDiD67u8W5/1JmZuc92vOndbus9wvd+D+TEq+ZQ3v
wpNTebkTMO5S4b4gZ5dp9xlnPp7/cR7F73v0g9/K4v7Ff4c17VEK9xcUvE2M
vJR828dcpc/m3wL3e05fvsPktW/0jY7n02m9PSS6FP+infHvJlyZ+4352p/h
671AWi5wv/+2R/Y5hfsLCt4icKzD2cpe3xmOZS8484nuIm/E/efqpJXfLkIc
hihdvtnP7YvcuYq/Ww1nM7EM/v5I2y5zzCV3vXJeF/YCg7Yx8kv2LMj9MofI
7/YV7i8oeJOY1vhwxh+e5JvPS+5643vGG3H/mTr9efYi9/vf5+qUHebc6O0P
c4M8e+Mc3rzLDWcvF3C/P6fnuSdno5xX+d/Lm7mnKNxfUPDmodeeBZdjXD+P
sYw5v6CgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoOBr
BxE9n57aPV/aloLr4dSeFbdr9m/CXlmf60fVPXTdGi5mHLvqS9uyhNz45fTm
9LTu3y9jXcFacHu1/NRXktlmnprzXb8ZcQ19Pxdw3K7WTtcG2+bQ30nf4fQc
7zXX3BIuZhy79kryKhl3Kt1K23J6tVK2OX7Bh69mbFv+FkzgeVpg/r9bL5CZ
Q8v5D8n99+S1jP4W43hm3Zvbfivuz/nN6Y7/b/57dCcdwzX6K/T9VqXfgvuj
MYZpBPPluWPRGr9KdkdfyXz8iDxzLzi+5/Ac+d/PHkfQB7bcT+SpOP/huJ+m
PflDcj/Eu7+NZV7PXbn/nrhWf70X97NMGdM1v+M6b8tp0q+T/+/cCh/ISrsG
h1wLj8Yz9wJN5z3C+x3/3KgyY7/g8XeE8vn/z1dAncnP7Rk3xOsrRof9SHiF
6x/gXc4Zxb6dkvuO4v1oT/G6R/JQhvt3w/mNsmuUAbL3Kk/rF50tlNnyv3tV
VvQk8SWDA0HeJba3UFfi2UIbYb2Dtol9HyBf4thr+1a0/Vbpk3bdUYoWZRP0
M8Nu3dai38ntVLmEs9jHAylAvu6zkT4lC9tI+yKx2yt5jZJh6TO5FmQKz6O/
e7DJv4PPOF6cPh1jHweK+4H2S2yUdnT+yzkz1hkobifpmxsK3HNkeysKYy6q
Z8TA25nJrykdv63hK/ogequZmCFqMtZfZI9nHIsSr0bZvKW0H3nZNMW3W5Cx
4bwOftZcRErG0SqXqROt+4146jEkcPZIv+gytmC/ORpp77hOBfk9hfY5gFxs
syPIGYz2OHL5HeftVLqgUXajjcJrggr6j9drxHWO+0XHEWUs2N5COnG5DduB
aVhfbMW4DqT4SNu30PYt1JUz/IEC9+vYNcr3WsVvzu6aYuA4S//+Xcr9PYUx
Vis5EoOR3wxZDZTRvmjewHg+G/51YFevdam4SnsPYOfR6lOUtiv6LmPK4n4d
I91G6HMFaRi33rBdxwPXN6u5aCa/A3nYBtKndH/BdulADtoXjQUK9/g5H1tD
jo59ZdiD+a68tDPOix3EqTb8dn0SuUivtYntdGU8Ry/FWwPyrfEvfjT8/sw2
Hw25so4R3h0otNWg5EgZbCdp43fqfc96fd80bPZtB3Zu4F307SBN0Km6En/x
p9V1Vfk57u8usB25H9dcYheuBSVGnRH7Z1Wvh3o5WzBN+qbEYfTD0O39Vr7X
/C593rJbxoXo92sh8MXkEMtmpa+DNOl/yTyiYq59ETt7CuM8GrOgbwv1RJ81
12xQptgKunCtKjokFr3hp+wVrDbMxUig98IbitcRWp7E6cD5yE/S18W/41MG
lk0q38nG8St9uNV+UeifjREjgV47VUoO1rHGs6uLY1F4sTbigvviDuo74LgU
e5GTxL4NxecoTS52ZLRTLt4cx1YeyLf6jqCH52iVMWKH8Yx4At4PIFfGS63K
1DO6TP6E2O4hntomwbOqJzIP/C7xrzJxneP+s22nzFwDduCYiPq7jrOSl/hu
2ELWe8bvtdwv7Tpn99wYjOKTszmnf6WsJe5vjTTxD/di0RhBG6C+jFVXRniy
ARsaUnMH6MT5Rfw/qvfV3J+xbUfqPG0uTpSO2zV9Zzafy1jjt13ha2/YJnEU
v/ReCetYPjo+30I7aHsiHieY3/l9y++yj+lJ7Q8pPmPRwHVTEjsrzcqnM877
oU6vn5xeupz75dHr/npGV44/8cynA1lZu1V935/Fzpm43or7W5U+GDJ1H/sa
ud/a22q7H5n7BVZfrjL6JCbST/H8we/dDJ1Nzn8rHksxUmm4Lu4hJkvcr+Px
2dxP8ZnPTrfDgq89pAknu7EjXHtYqBP5SBPvH0BOS2EsYhwkrYc4bpRM5H55
RE8H9Vt+pC9k19or4ymoM/lWPMWfjVXH0kvruL/D94zcc7jf2WmdidUzNmXj
BeWlzc2zAlW2hbQk1mfYvsRDuEeMzkUgrp1RJvGdwt5X1iXCI7iX9z5k7OlU
uo69xZ9ipz6vQBuX+BrP2a39eGPo6zKyTF0Z2zXXJby8BKjjoM9PPf/O2a9t
ps/n/tbQoeXdnPspvneQ9brm47Xc731iO7cUjzWpg/OBnKVpXdhOms/ceHHj
WOb/PcVj34/1mZhIu+tvNyIOtmK3Nt6kznwonK/WUEbSJHbjOSyFfdhGyzXi
jW2gY4W6XPmN2GXUqWd04fjvKb3LOpD6bmRNvCjufw7VTFw/l/u17Tnuxz1h
C+W8Hoq/F9zN+C79aU9qH2vE/8i6OoL7UiXb6ZL92pxNObvP5n6ly/nTqnrO
1i3F34HUGTlbKOPHLa3jfvFP4iRjpJmxG2Ng3YNondhXdhS+sSEK/QbHQqPr
WXGbsWlHcDdqlJmLx2rup5iHWq6LY8/Jxn7W5nSQ3YfEhx2F71twnYAxi3y2
dFE6XqSM9IGBfxZdlWGLq79hfXKXKWN7MGIl/nczbZekZeKtgbGaW3MIjmTw
HLwvcr+KF8IaB/Wcj6S+veI0HO/OXpnL+zlZSq7Umf3Gmi7k/hnbTe43/CKr
HKXfkUkc0fdWyfD9GcrgXhfL1Zxfq7x2xnfLbuvs2rLRp62IR2XEQNDMyHG+
JvdCtIL7M3aMZxUz+qJ5PCNno+pY40XfCUXjl87jfjzzIYI7OChzbe7XaJVM
iWVuLb523a8x3skauhyk76CPOA4GsvsFzhsI/J0NXebA6RWpeQnkRnn8c63K
JGlWvvHgPOj0bLUNbJ9LT85+tF7LD8r8XRQu2/Cj71yljt6jJT7SNJYaZccG
5Ro2ZeNFExdI+2bPe5S/FaTVa2ynMOd72y15hj6JWa6MtJfpO5RpQW8utjWX
S3RBf9lQ/O1E5PuS3RT+Fo3ui+Z4UHU3FL5bxnhLDLJxMmwQ+2ScJf3W6pfK
v+z5qOGvtrmy0g0dpk96/KIeVS7X1lK/Ql8N+7LxyOm09BsPyh3HhZJZqXe0
zepDbgwPFP4+hoxpUnWlD1VaF8j2bavjQGHe6Sic0yfraCi7pRV9suC+4H4g
87w/4ygoKHgcUNhb4f2YnMsTLawpztTVa5kUzhH7a+kpuC0o3vc2X9qegoKC
80Hp78Phmr+7si48q5O9hqwdrzbHFNwWFL61rr60LQUFBZeDwt9N7Sl8O1nf
SFdD4XuijtQ3RXP4P6lulfg=
             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Colors and Styles\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Colors and Styles", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-09-interactive-manipulation.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-09-interactive-manipulation.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Interactive Manipulation\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Interactive Manipulation", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->51,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Basic Graphics Objects \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"daeb4d28-529e-4cf4-8cb6-241e521e66e0"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:29"->{
  Cell[667, 24, 484, 13, 93, "Section",ExpressionUUID->"d6da2c97-98c1-4c09-b634-6c2036d797cc",
   CounterAssignments->{{"Section", 7}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:29", "i:1"}]},
 "i:1"->{
  Cell[667, 24, 484, 13, 93, "Section",ExpressionUUID->"d6da2c97-98c1-4c09-b634-6c2036d797cc",
   CounterAssignments->{{"Section", 7}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->{"p:29", "i:1"}]},
 "i:2"->{
  Cell[1154, 39, 846, 22, 116, "Text",ExpressionUUID->"5820b4aa-42a6-470b-8b30-fd0265552c18",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[2646, 86, 243, 8, 37, "CodeCaption",ExpressionUUID->"10f5dfb8-4e9b-41c5-998e-57b62bfcab48",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[3360, 113, 288, 10, 40, "Text",ExpressionUUID->"55b144fb-9d13-49ea-b2ba-d0321394697b",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[5125, 165, 239, 6, 70, "CodeCaption",ExpressionUUID->"38eebc21-80f7-4ff0-972b-466b552ab2d5",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[5709, 185, 6189, 124, 70, "Output",ExpressionUUID->"989360cb-fbb2-45a9-aa2f-94a612528180",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[16884, 470, 358, 10, 70, "Output",ExpressionUUID->"ed1bb84d-0b8f-4ca7-aa7f-7185b3c9a596",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[127362, 3020, 347, 8, 70, "MoreExplore",ExpressionUUID->"b54cdd1c-cf94-40f4-bf20-3ec1a9509763",
   CellTags->"LastCellOfAPage"]},
 "p:30"->{
  Cell[11913, 312, 320, 12, 70, "Text",ExpressionUUID->"3eed2b0a-e8cb-4c4b-ae80-be4285baf9a8",
   CellTags->{"p:30", "i:6"}]},
 "i:6"->{
  Cell[11913, 312, 320, 12, 70, "Text",ExpressionUUID->"3eed2b0a-e8cb-4c4b-ae80-be4285baf9a8",
   CellTags->{"p:30", "i:6"}]},
 "i:7"->{
  Cell[13807, 370, 486, 16, 70, "Text",ExpressionUUID->"1dd8d28a-ad03-4b60-b154-afebd9c81bbf",
   CellTags->"i:7"]},
 "p:31"->{
  Cell[17291, 486, 175, 4, 70, "VocabularySection",ExpressionUUID->"0a66cc09-2ba4-4844-9468-ee875b97c52c",
   CellTags->"p:31"]},
 "i:8"->{
  Cell[22995, 656, 759, 23, 70, "Exercise",ExpressionUUID->"1ebf97f5-7926-4979-adf1-45d49e9e3d28",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[125874, 2968, 357, 8, 70, "Answer",ExpressionUUID->"fd26adcc-2d9b-4b11-abea-84467106dfa1",
   CellTags->"i:9"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:29", 218477, 4871},
 {"i:1", 218730, 4875},
 {"i:2", 218983, 4879},
 {"i:3", 219109, 4882},
 {"i:4", 219240, 4885},
 {"i:5", 219366, 4888},
 {"LastCellOfAPage", 219510, 4891},
 {"p:30", 219965, 4900},
 {"i:6", 220102, 4903},
 {"i:7", 220239, 4906},
 {"p:31", 220367, 4909},
 {"i:8", 220507, 4912},
 {"i:9", 220638, 4915}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[667, 24, 484, 13, 93, "Section",ExpressionUUID->"d6da2c97-98c1-4c09-b634-6c2036d797cc",
 CounterAssignments->{{"Section", 7}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->{"p:29", "i:1"}],
Cell[1154, 39, 846, 22, 116, "Text",ExpressionUUID->"5820b4aa-42a6-470b-8b30-fd0265552c18",
 CellTags->"i:2"],
Cell[2003, 63, 169, 4, 37, "CodeCaption",ExpressionUUID->"b356a480-5624-4e0c-a82a-b82870b4dfcd"],
Cell[CellGroupData[{
Cell[2197, 71, 191, 4, 29, "Input",ExpressionUUID->"45401108-2770-4b5d-9cf0-44c860ceea0b"],
Cell[2391, 77, 240, 6, 121, "Output",ExpressionUUID->"d347ea8c-a420-4e31-9b41-e361dd78cf16",
 Evaluatable->False]
}, Open  ]],
Cell[2646, 86, 243, 8, 37, "CodeCaption",ExpressionUUID->"10f5dfb8-4e9b-41c5-998e-57b62bfcab48",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[2914, 98, 189, 4, 29, "Input",ExpressionUUID->"f2ab413b-efb4-4949-8b90-3e75c05cea01"],
Cell[3106, 104, 239, 6, 121, "Output",ExpressionUUID->"26d95492-bc69-4875-bae0-26c80c2a18db",
 Evaluatable->False]
}, Open  ]],
Cell[3360, 113, 288, 10, 40, "Text",ExpressionUUID->"55b144fb-9d13-49ea-b2ba-d0321394697b",
 CellTags->"i:4"],
Cell[3651, 125, 206, 5, 37, "CodeCaption",ExpressionUUID->"ebe9fa37-bf88-436f-b8f7-9dfa451a8433"],
Cell[CellGroupData[{
Cell[3882, 134, 199, 4, 29, "Input",ExpressionUUID->"46bd4f5c-e6d0-4afc-982e-a58ef0dd0503"],
Cell[4084, 140, 1026, 22, 117, "Output",ExpressionUUID->"34e6eeb4-a32e-4355-a014-f9b1f8caa3ec",
 Evaluatable->False]
}, Open  ]],
Cell[5125, 165, 239, 6, 70, "CodeCaption",ExpressionUUID->"38eebc21-80f7-4ff0-972b-466b552ab2d5",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[5389, 175, 317, 8, 70, "Input",ExpressionUUID->"c57a3dea-368e-4053-8bc8-b6317f2c7aac"],
Cell[5709, 185, 6189, 124, 70, "Output",ExpressionUUID->"989360cb-fbb2-45a9-aa2f-94a612528180",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[11913, 312, 320, 12, 70, "Text",ExpressionUUID->"3eed2b0a-e8cb-4c4b-ae80-be4285baf9a8",
 CellTags->{"p:30", "i:6"}],
Cell[12236, 326, 186, 4, 70, "CodeCaption",ExpressionUUID->"1d3b2d66-1203-4390-a057-c7f218521a2a"],
Cell[CellGroupData[{
Cell[12447, 334, 265, 7, 70, "Input",ExpressionUUID->"86f277ec-f257-49dc-92ff-a3f3c05fc12b"],
Cell[12715, 343, 1077, 24, 70, "Output",ExpressionUUID->"2d586b58-b7d0-49fb-b8b9-46bbc4e4fc4e",
 Evaluatable->False]
}, Open  ]],
Cell[13807, 370, 486, 16, 70, "Text",ExpressionUUID->"1dd8d28a-ad03-4b60-b154-afebd9c81bbf",
 CellTags->"i:7"],
Cell[14296, 388, 166, 4, 70, "CodeCaption",ExpressionUUID->"24490059-cdae-4d14-acce-8537ef0c3b23"],
Cell[CellGroupData[{
Cell[14487, 396, 204, 4, 70, "Input",ExpressionUUID->"11186c8a-9592-42fa-bb44-406ecfa3ae4f"],
Cell[14694, 402, 411, 9, 70, "Output",ExpressionUUID->"9c1bfec6-c3f9-403c-b206-83d36fac9aef",
 Evaluatable->False]
}, Open  ]],
Cell[15120, 414, 175, 4, 70, "CodeCaption",ExpressionUUID->"e2ced2fa-dc0b-4186-ad1c-170f118ffa2d"],
Cell[CellGroupData[{
Cell[15320, 422, 337, 8, 70, "Input",ExpressionUUID->"e9a13030-a843-416e-857c-c7a17e26f5a8"],
Cell[15660, 432, 752, 18, 70, "Output",ExpressionUUID->"1a977b5c-4d8a-4664-aeb1-9574d3faae41",
 Evaluatable->False]
}, Open  ]],
Cell[16427, 453, 159, 4, 70, "CodeCaption",ExpressionUUID->"88cbfa70-7645-457d-809d-96738a79411c"],
Cell[CellGroupData[{
Cell[16611, 461, 270, 7, 70, "Input",ExpressionUUID->"b35431ef-2800-4e09-b86c-4c86e419abd5"],
Cell[16884, 470, 358, 10, 70, "Output",ExpressionUUID->"ed1bb84d-0b8f-4ca7-aa7f-7185b3c9a596",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17291, 486, 175, 4, 70, "VocabularySection",ExpressionUUID->"0a66cc09-2ba4-4844-9468-ee875b97c52c",
 CellTags->"p:31"],
Cell[17469, 492, 2226, 62, 70, "VocabularyTable",ExpressionUUID->"cb5a3ab6-7181-4405-b2b9-ad91045a11e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19732, 559, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"832b3699-f612-466c-ab47-f2650fbd754f"],
Cell[CellGroupData[{
Cell[21537, 609, 1433, 43, 70, "ExerciseSummaryCell",ExpressionUUID->"bc8c65b9-14dc-4561-b8f3-65d6ee7b44d2"],
Cell[CellGroupData[{
Cell[22995, 656, 759, 23, 70, "Exercise",ExpressionUUID->"1ebf97f5-7926-4979-adf1-45d49e9e3d28",
 CellTags->"i:8"],
Cell[23757, 681, 1837, 48, 70, "ExerciseOutput",ExpressionUUID->"57d76980-c0a3-4a84-a188-9c356a8efaea"]
}, Closed]],
Cell[CellGroupData[{
Cell[25631, 734, 694, 20, 70, "Exercise",ExpressionUUID->"de13ee41-dae5-4750-bd3b-e479f8f6fea3"],
Cell[26328, 756, 1302, 37, 70, "ExerciseOutput",ExpressionUUID->"10eb606d-5307-4e41-afaf-4ec12b08e38e"]
}, Closed]],
Cell[CellGroupData[{
Cell[27667, 798, 683, 20, 70, "Exercise",ExpressionUUID->"bfe60903-4548-4909-85c8-e56ee1ed4f2c"],
Cell[28353, 820, 3461, 75, 70, "ExerciseOutput",ExpressionUUID->"1fcf793a-f3f3-4be3-a2d1-df1b375cdd84"]
}, Closed]],
Cell[CellGroupData[{
Cell[31851, 900, 749, 21, 70, "Exercise",ExpressionUUID->"6ed19df9-9e88-46ff-a8bf-4c2014b62a79"],
Cell[32603, 923, 4182, 111, 70, "ExerciseOutput",ExpressionUUID->"cb9c9256-5391-4fce-a2c4-439e99a31d27"]
}, Closed]],
Cell[CellGroupData[{
Cell[36822, 1039, 708, 20, 70, "Exercise",ExpressionUUID->"ad3627c2-5c3f-4b39-befb-ed181e98565f"],
Cell[37533, 1061, 3540, 89, 70, "ExerciseOutput",ExpressionUUID->"e3982da0-946d-4957-8773-d29d69a25624"]
}, Closed]],
Cell[CellGroupData[{
Cell[41110, 1155, 768, 21, 70, "Exercise",ExpressionUUID->"f4d221ad-3c95-4f06-a394-62818a552ffb"],
Cell[41881, 1178, 16356, 318, 70, "ExerciseOutput",ExpressionUUID->"c7527151-a3c7-4df3-9ad4-c4b92bfb645a"]
}, Closed]],
Cell[CellGroupData[{
Cell[58274, 1501, 700, 20, 70, "Exercise",ExpressionUUID->"1aeaff63-0851-4f34-8ae4-05c32cca32c7"],
Cell[58977, 1523, 1508, 41, 70, "ExerciseOutput",ExpressionUUID->"91e60fa7-3b17-4f3e-aece-fcd8325f4775"]
}, Closed]],
Cell[CellGroupData[{
Cell[60522, 1569, 968, 29, 70, "Exercise",ExpressionUUID->"c4c0a21e-7db2-4ce9-a8c3-7223437a0b81"],
Cell[61493, 1600, 11396, 232, 70, "ExerciseOutput",ExpressionUUID->"fa1650e1-6a3a-4574-bbae-4e47a9d2cb94"]
}, Closed]],
Cell[CellGroupData[{
Cell[72926, 1837, 721, 20, 70, "Exercise",ExpressionUUID->"31ce6f4f-afda-4ef7-9030-b2d19ba1c1b2"],
Cell[73650, 1859, 25657, 512, 70, "ExerciseOutput",ExpressionUUID->"f8e6f622-034e-4015-82f6-4505e97833fb"]
}, Closed]],
Cell[CellGroupData[{
Cell[99344, 2376, 718, 20, 70, "Exercise",ExpressionUUID->"90bd60a4-5474-40b3-9281-ef5ccecf63d9"],
Cell[100065, 2398, 4991, 104, 70, "ExerciseOutput",ExpressionUUID->"fc5e55dd-2a84-4f7a-a501-671177da8f15"]
}, Closed]],
Cell[CellGroupData[{
Cell[105093, 2507, 715, 20, 70, "Exercise",ExpressionUUID->"69d9f286-f78a-4bef-a188-8c140f5f3d3a"],
Cell[105811, 2529, 17625, 349, 70, "ExerciseOutput",ExpressionUUID->"56aadc35-9d6c-474c-8052-5733d6595cee"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123497, 2885, 144, 4, 70, "QASection",ExpressionUUID->"8d188796-0194-48e0-a300-5556752d661d"],
Cell[123644, 2891, 185, 4, 70, "Question",ExpressionUUID->"33813904-c76c-4d7d-b9b2-65cbd50db928"],
Cell[123832, 2897, 400, 13, 70, "Answer",ExpressionUUID->"bebbb661-c0bf-4322-9c46-be638cfc8688"],
Cell[124235, 2912, 453, 16, 70, "Question",ExpressionUUID->"1179040b-5610-4fe6-922a-9211ce77005e"],
Cell[124691, 2930, 980, 30, 70, "Answer",ExpressionUUID->"09ec47dc-1c65-4c39-a140-b25332fd827c"],
Cell[125674, 2962, 197, 4, 70, "Question",ExpressionUUID->"b3bc2b37-3cec-4c68-afdd-61766f0df17b"],
Cell[125874, 2968, 357, 8, 70, "Answer",ExpressionUUID->"fd26adcc-2d9b-4b11-abea-84467106dfa1",
 CellTags->"i:9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126268, 2981, 156, 4, 70, "TechNoteSection",ExpressionUUID->"e7dd4ae0-c88f-42bf-a001-85fcd1707e27"],
Cell[126427, 2987, 730, 22, 70, "TechNote",ExpressionUUID->"bf7bccad-ef24-44e9-837e-dc885637e22c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127194, 3014, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"5dbf1866-07df-40f5-9bfa-45c8107b6e3c"],
Cell[127362, 3020, 347, 8, 70, "MoreExplore",ExpressionUUID->"b54cdd1c-cf94-40f4-bf20-3ec1a9509763",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature gLNWkcxrv36WHIkH@SoxaT@0 *)
