(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    256231,       6026]
NotebookOptionsPosition[    182103,       4460]
NotebookOutlinePosition[    242195,       5695]
CellTagsIndexPosition[    242116,       5690]
WindowTitle->First Look at Lists: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " to create the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "InlineCode",
  ExpressionUUID->"3c3c840b-5719-45ed-8bf4-45d2137805f4"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"9debdb06-72b5-410e-aa00-c0546a790a40"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5eac4d41-db0e-49ca-9ce2-18acb4fc7de9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVSGPnjAYbjYzuWS/YH8AucxWTpHcMoe5y47LzI3cLVmwuMq6OhQKhUJh
UDU1NTUIDAaBwFQgbn3bj33cfcB9S7Zk4t4EQuHp26fP+7zl/dX3i/AVQuj+
jbldXP7Ed3eX8ee3ZvDl9v7bze3110+3P65vru8+Xr02L9+Z64O54PnhJV7i
f4mhJKHnRVK74dhI2Y7T3oyx42WR5wVX/R5M97wq8qLkqjuHhhKiHQyJMQsx
DhLeHziMkpmWCUnRTQ9NHiMbhA+biWTuWYy7R7lahU1d5S9gPql39/zAKcA9
ws1UVabB4dkyFBQh6vRrqyyJAMnEJsMmM7OJFcVsFnazquPUldhLGkurIhgh
zMdNerrJnTI+E+6NSn3kUUdCS2C4mK0MRbrN0BAbZg8MnOwvfYDVyS6sI0Zo
HAQewvTAUDKMPOZmgCYzW8tY4GcYHkNQg012TDb2nazzAGyUbRGUUFJUtl0G
ss0aWlZmytBUkaE/V/yPGE5tYVde96EjaJRwsZXQJYlL2GWKEWaHbJOtOykU
sV6ulrPPZDhw2HmwqcyRg+5LCtiiPe2VMbXtFBFKaeI7J1at48Fsj02DSsxD
Ui0ySvCh3F2559AimO6fNXqRE6+fD7rOGGWMQhAfKPlpDQy1Ss0g5aBtAzZx
PtTmJJQ1fIqzWknZaWj92Bg4KX8vp7sqsIVjlZBCcM6bYTqFlcY9Xlypbujb
goA8WaNPYYuYbJWlG9juYA527GUtfPQoqBjNZ+DjHZtdsicoK84JTHciCbwZ
4tGycYs9gS0CTOuncl7l2Mv2PCQ7RQWRZ/BOrMImPQ7Do//TmdkUA0EdzFUc
h2zFyOaogmqhTD7TOH8VpnkaW5uL45uMhGGiVs0xdk239uEfwnRJoihJm2eF
fonz4hfcoF+V
            "], {{0, 19}, {54, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{54, 19},
          PlotRange->{{0, 54}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{58, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3616927f-872f-4442-8839-e4c2a9c7e0f5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVSGPnjAYbjYzuWS/YH8AucxWTpHcMoe5y47LzI3cLVmwuMq6OhQKhUJh
UDU1NTUIDAaBwFQgbn3bj33cfcB9S7Zk4t4EQuHp26fP+7zl/dX3i/AVQuj+
jbldXP7Ed3eX8ee3ZvDl9v7bze3110+3P65vru8+Xr02L9+Z64O54PnhJV7i
f4mhJKHnRVK74dhI2Y7T3oyx42WR5wVX/R5M97wq8qLkqjuHhhKiHQyJMQsx
DhLeHziMkpmWCUnRTQ9NHiMbhA+biWTuWYy7R7lahU1d5S9gPql39/zAKcA9
ws1UVabB4dkyFBQh6vRrqyyJAMnEJsMmM7OJFcVsFnazquPUldhLGkurIhgh
zMdNerrJnTI+E+6NSn3kUUdCS2C4mK0MRbrN0BAbZg8MnOwvfYDVyS6sI0Zo
HAQewvTAUDKMPOZmgCYzW8tY4GcYHkNQg012TDb2nazzAGyUbRGUUFJUtl0G
ss0aWlZmytBUkaE/V/yPGE5tYVde96EjaJRwsZXQJYlL2GWKEWaHbJOtOykU
sV6ulrPPZDhw2HmwqcyRg+5LCtiiPe2VMbXtFBFKaeI7J1at48Fsj02DSsxD
Ui0ySvCh3F2559AimO6fNXqRE6+fD7rOGGWMQhAfKPlpDQy1Ss0g5aBtAzZx
PtTmJJQ1fIqzWknZaWj92Bg4KX8vp7sqsIVjlZBCcM6bYTqFlcY9Xlypbujb
goA8WaNPYYuYbJWlG9juYA527GUtfPQoqBjNZ+DjHZtdsicoK84JTHciCbwZ
4tGycYs9gS0CTOuncl7l2Mv2PCQ7RQWRZ/BOrMImPQ7Do//TmdkUA0EdzFUc
h2zFyOaogmqhTD7TOH8VpnkaW5uL45uMhGGiVs0xdk239uEfwnRJoihJm2eF
fonz4hfcoF+V
              "], {{0, 19}, {54, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {54, 19}, 
            PlotRange -> {{0, 54}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"97753574-7ad6-4bb0-abcf-a21f6852e8b9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.1"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"18ec879d-7c4c-4bda-8765-ef7cfb4455d6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b191c6a2-b070-4b7a-b117-c63d3e7622e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9c08239e-fba9-465d-bb31-cd8a23924859"],

Cell["Make a list of numbers up to 100.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"aafdf490-8e2b-408c-aca4-8c2ad2d07bde"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c0daa25b-6a44-4010-bea9-7241493c2956"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnbGrM8t5xpWkSZl/IX9AVKeMyjQROCTVaWximTSOsANBrcBcBGmUIqgw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            "], {{0, 86}, {498, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{498, 86},
          PlotRange->{{0, 498}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{502, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "03f7d7b5-9dc1-49ef-a9e9-d1b797d3f1de"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnbGrM8t5xpWkSZl/IX9AVKeMyjQROCTVaWximTSOsANBrcBcBGmUIqgw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              "], {{0, 86}, {498,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {498, 86}, 
            PlotRange -> {{0, 498}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a5f90c4e-a21c-49d5-a88f-cc7dfbf29826"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.2"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3e9575a9-d25e-4526-8dd7-6b3b3e20855d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7e2c42b2-c55c-4ebc-a64c-3c0d8f8b9d2e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c9980acc-7674-4765-911b-987ece2e7864"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Reverse",
  FontFamily->"Source Sans Pro"],
 " to create ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]], "InlineCode",
  ExpressionUUID->"79f5d369-dde1-41bc-9213-9f9f7824e0e0"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"e7210382-bc91-4d70-b027-a5c52c4fe74a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"540c4467-7bd9-40d7-b640-4b84fa7e4f20"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVa+PnEAUnrSmskn/gv4DyKZ2ZBXJNecwd+lxqbmSuyYNFjdy3DgUCoVC
YVBjMGPGIDBjECMwIxDbN8PestsF9kSbVNyXQODNx3vfvB/Dx9sfV+EbhNDT
O7hd3fzCj4838df38HL98PT9/uHu25eHn3f3d4+fb9+C8QNcn+Cyz7tXvOJ/
gS5J6HmRMLNFNk2nzeoXpudVkRcll2rL8aB4WeR5wWV/ScPQCtEN4/SchRgH
Ce/H/ZpgMDIhKdTesOPUB4tH+KKvUVV2GQju7pN6XKJpkXtHtCiXa+LaPHYU
RLieIsgyDY4EDA1FiB7yZdp84vusWVFYYi9pnayKYIQwH5biZhCEqH1ObPy1
PHZVlkR206zRB6NMfeTR6d0Iq/A5iCKwZxwEHsJ0WeExdJ2sKQRhel+1neZk
nbZXBBLpkULBMPLYcNjss1phs4vKTmV2B1sKh16JOrfsMNuK7NBQSHWy1bKm
wacKpVMFnnVbRbA9V/GxKyBgXFpPKUaYrXYOCIQtTjh2u4jJbZhteFtQOLpm
I4UkrpcruzKkbgAiQilN/KkTq24rtOlLarNYdIuz4qC5ZQSX8nymEEzMzdio
ZQIPSQWWOmOUMWpBfLvqp/WiQjMfQ6PA8wyeoed2RDC9eNaAH9uHYt6HkSl8
mnJb0NZ2Ez2NMboqC/coY5iapDyoKqEtvLiSSvddQWyys9ac04yqAtcGrGpE
03DOWz2e0+zhIYSorZ44q6UQyq256WAT7XSWJ9g281MxLdtA3kwwqkkCb9+F
sFC2izTBfHQKm+ozGtT3Dx5tht3pLLvzkGz0iU3yM3nOshn04TRZp73Q2zkk
s1WcaFPFccgW+13ZoqJMXBjYv0ozPI1d/zazJSNhmMil//A4qFat/6D/Cc2U
JIqStL2Y6Fe8DL8BWERflQ==
            "], {{0, 19}, {54, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{54, 19},
          PlotRange->{{0, 54}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{58, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1f6a4110-a5e5-4294-9c34-61916c617b17"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVa+PnEAUnrSmskn/gv4DyKZ2ZBXJNecwd+lxqbmSuyYNFjdy3DgUCoVC
YVBjMGPGIDBjECMwIxDbN8PestsF9kSbVNyXQODNx3vfvB/Dx9sfV+EbhNDT
O7hd3fzCj4838df38HL98PT9/uHu25eHn3f3d4+fb9+C8QNcn+Cyz7tXvOJ/
gS5J6HmRMLNFNk2nzeoXpudVkRcll2rL8aB4WeR5wWV/ScPQCtEN4/SchRgH
Ce/H/ZpgMDIhKdTesOPUB4tH+KKvUVV2GQju7pN6XKJpkXtHtCiXa+LaPHYU
RLieIsgyDY4EDA1FiB7yZdp84vusWVFYYi9pnayKYIQwH5biZhCEqH1ObPy1
PHZVlkR206zRB6NMfeTR6d0Iq/A5iCKwZxwEHsJ0WeExdJ2sKQRhel+1neZk
nbZXBBLpkULBMPLYcNjss1phs4vKTmV2B1sKh16JOrfsMNuK7NBQSHWy1bKm
wacKpVMFnnVbRbA9V/GxKyBgXFpPKUaYrXYOCIQtTjh2u4jJbZhteFtQOLpm
I4UkrpcruzKkbgAiQilN/KkTq24rtOlLarNYdIuz4qC5ZQSX8nymEEzMzdio
ZQIPSQWWOmOUMWpBfLvqp/WiQjMfQ6PA8wyeoed2RDC9eNaAH9uHYt6HkSl8
mnJb0NZ2Ez2NMboqC/coY5iapDyoKqEtvLiSSvddQWyys9ac04yqAtcGrGpE
03DOWz2e0+zhIYSorZ44q6UQyq256WAT7XSWJ9g281MxLdtA3kwwqkkCb9+F
sFC2izTBfHQKm+ozGtT3Dx5tht3pLLvzkGz0iU3yM3nOshn04TRZp73Q2zkk
s1WcaFPFccgW+13ZoqJMXBjYv0ozPI1d/zazJSNhmMil//A4qFat/6D/Cc2U
JIqStL2Y6Fe8DL8BWERflQ==
              "], {{0, 19}, {54, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {54, 19}, 
            PlotRange -> {{0, 54}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"720e6900-fd66-4804-a59f-3487249d0511"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.3"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"48292a57-d5ff-4e77-88fe-c059f423c809"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"048e8843-84a6-4b38-a792-077e45afd214"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d37acd2e-d0e5-4f29-8452-2ebf3469b1d3"],

Cell["Make a list of numbers from 1 to 50 in reverse order.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"384e874a-2871-4d41-9307-d4499823a3c7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c69db293-075e-487a-a8cf-4ad0f7b1c6dd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXb2r9FgdjtpY+i/YWkxtm9JqQLGbZhc3i806rIJMm0ZSppEUC1PFZkAZ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            "], {{0, 42}, {
            488, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{488, 42},
          PlotRange->{{0, 488}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{492, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fa414066-4e5a-485f-b39d-2a24d59cd378"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXb2r9FgdjtpY+i/YWkxtm9JqQLGbZhc3i806rIJMm0ZSppEUC1PFZkAZ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              "], {{0, 42}, {
              488, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {488, 42}, 
            PlotRange -> {{0, 488}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f573d4c1-c5c0-4508-9275-46ee1dcae357"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.4"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f15047f1-9f6c-4f0c-ac85-8010f106c03a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6120b9e9-d929-486f-84c7-bb746770bbc2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"11396b22-bf20-4a81-b2d2-6576b666bc7a"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Reverse",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Join",
  FontFamily->"Source Sans Pro"],
 " to create ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "4", ",", "3", ",", "2", ",", 
    "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "d403e8fa-4620-4640-ae86-e2bf8cca75df"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"bbd12395-5c80-4d66-8350-aeac34abef42"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9b6641c4-a66c-425a-80b0-992e5ef64829"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztV6+PnEAUnrSmskn/gv4D6NqRVSTX1GHu0uPSiuvmrkmDxY0cNw6FQqFQ
GNQYzJgxCMwYBAIzArGdGXa77PJj5+7SpMntS9gA+zHvve/N+x58vPl55b8B
ADy+Uz9X17/hw8N18OW9uvh6//j97v722+f7X7d3tw+fbt6qmx/U8UMd+nx7
sYtd7GKv0doM+Y6zYXK47CrG6q5fe6ITNEuTJKW8WYPJhuZpkmaUC5sweFnW
rXwpzNKpZQoGOiKki30IvZA2O346RtT48FEq+m2VBMAYou1i9CxxDGb43SR8
FtaL3B3BXFSs1mNLsYY7iK5nsg6zdGqZgrIJIT3PIm8UQFdiAPBQyzqPw432
T8pF9qpYPY1MXVUh9MKzxetFBp2wMtHnCAIAabe05FZWyRCkS8pFkAXM0qll
CtsFQnjkAgcP15Jp9kZOuELjZfaUx3bf1y1F67TsYEW4ChNIbQLoeQ6AeIU9
S5iN0yelcEoIIxA4ZHhCF2LPpDZZwjPsHazEChuu6EvXCFYknpaGeClAplsB
ZLWIdUkXabGEWTq1T2FKCDeMqZXbKt8o6scyYs1eX6cmwEXRUHmoKg22tOCw
SJDp8CMIIFlQUTuYpdOnpDBDSG8EBKUcGe3M2zXwvLVUF9c7X9xeNhnW2LSe
SngXGZXfIIxx6A6SltfPhVk6fWIKM4RIYuZN3/JQnYT5yDHTbc5Wl2yo1lqI
199XDm8VPYPzc1wWMcGEYG3I1SG5UTGlxRJm6dQ+hd06J4RIHqlHI6obodIK
MeieVC82rNB/BXHBGRNSj+hAqXSY/Y1KitwzfUHykpUlpbRq+yksU4rgBDkX
bVOnSO+XuJJT2DhK05LMnD4TZunUMoV5QnaTggyww8yVpQuODJed+ls7cg5D
mZETlKnvBCZFGXrOHuLgrBqcncBGpvXKjdhLYJZOLVOYJ+R45pr3PbTSqHpz
7sErNgvrZde2R98tL1ntP3HKid79A2zoYuiTWX0VuhlAzM4MkVcDkzQKjF6W
hzsx8v2Qz6pMJypx9tvz9cBkhjabMKrObtCLXexf2h+2mJbw
            "], {{0, 19}, {
            106, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{106, 19},
          PlotRange->{{0, 106}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{110, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bdd86913-4802-48f3-b802-95e69ed2c0aa"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztV6+PnEAUnrSmskn/gv4D6NqRVSTX1GHu0uPSiuvmrkmDxY0cNw6FQqFQ
GNQYzJgxCMwYBAIzArGdGXa77PJj5+7SpMntS9gA+zHvve/N+x58vPl55b8B
ADy+Uz9X17/hw8N18OW9uvh6//j97v722+f7X7d3tw+fbt6qmx/U8UMd+nx7
sYtd7GKv0doM+Y6zYXK47CrG6q5fe6ITNEuTJKW8WYPJhuZpkmaUC5sweFnW
rXwpzNKpZQoGOiKki30IvZA2O346RtT48FEq+m2VBMAYou1i9CxxDGb43SR8
FtaL3B3BXFSs1mNLsYY7iK5nsg6zdGqZgrIJIT3PIm8UQFdiAPBQyzqPw432
T8pF9qpYPY1MXVUh9MKzxetFBp2wMtHnCAIAabe05FZWyRCkS8pFkAXM0qll
CtsFQnjkAgcP15Jp9kZOuELjZfaUx3bf1y1F67TsYEW4ChNIbQLoeQ6AeIU9
S5iN0yelcEoIIxA4ZHhCF2LPpDZZwjPsHazEChuu6EvXCFYknpaGeClAplsB
ZLWIdUkXabGEWTq1T2FKCDeMqZXbKt8o6scyYs1eX6cmwEXRUHmoKg22tOCw
SJDp8CMIIFlQUTuYpdOnpDBDSG8EBKUcGe3M2zXwvLVUF9c7X9xeNhnW2LSe
SngXGZXfIIxx6A6SltfPhVk6fWIKM4RIYuZN3/JQnYT5yDHTbc5Wl2yo1lqI
199XDm8VPYPzc1wWMcGEYG3I1SG5UTGlxRJm6dQ+hd06J4RIHqlHI6obodIK
MeieVC82rNB/BXHBGRNSj+hAqXSY/Y1KitwzfUHykpUlpbRq+yksU4rgBDkX
bVOnSO+XuJJT2DhK05LMnD4TZunUMoV5QnaTggyww8yVpQuODJed+ls7cg5D
mZETlKnvBCZFGXrOHuLgrBqcncBGpvXKjdhLYJZOLVOYJ+R45pr3PbTSqHpz
7sErNgvrZde2R98tL1ntP3HKid79A2zoYuiTWX0VuhlAzM4MkVcDkzQKjF6W
hzsx8v2Qz6pMJypx9tvz9cBkhjabMKrObtCLXexf2h+2mJbw
              "], {{0, 19}, {
              106, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {106, 19}, 
            PlotRange -> {{0, 106}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"20b13f32-a32e-46a6-a11c-a3793a4cf6df"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.5"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e0beb40b-e352-4f3c-8716-9eea6f3fff2a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"57e13358-68f0-400c-a525-e5e1ef9edb61"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4b12ae53-e76c-4935-bc84-7130c16e7500"],

Cell["Plot a list that counts up from 1 to 100, then down to 1.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"2748f13f-aa7b-4ac3-b00b-d3341de66aa8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"59c1ccad-fcf2-4396-85ec-e53803e5ec28"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3b+P81pex/EHaCj5F/gvtqWkXUSLtKu9Z6Ex0l0wonCBlG6q0KTAlRtX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            "], {{0, 225}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 225},
          PlotRange->{{0, 360}, {0, 225}}]], "ExerciseOutput",
         ImageSize->{364, 225},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "179f1a28-359c-4807-978a-0c392ade3252"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3b+P81pex/EHaCj5F/gvtqWkXUSLtKu9Z6Ex0l0wonCBlG6q0KTAlRtX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              "], {{0, 
              225}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 225}, 
            PlotRange -> {{0, 360}, {0, 225}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9187e0c7-06a9-4fe1-b6cb-569372ef928d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.6"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5e956a59-d5b3-4f88-bd13-f5ed8b53bea4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a3e72682-7a50-4dc7-8df0-01c4f8a2c740"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d8da3f81-e552-437c-b662-b3719af09389"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["RandomInteger",
  FontFamily->"Source Sans Pro"],
 " to make a list with a random length ",
 "up to 10",
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"02cf4705-bf56-4972-b2af-f55740f4b447"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e92bd18-2861-4e83-acc6-1653eb8ed064"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzVkaFuwzAQhk8bGdukPcFewHjUcChSp7KSVourkS5KJ02lYYZhZkFBRUVB
IUUhISYmASUlAwEhBgbdOc6aNquGRnaSozvfZ/u/Pw+ztxG7AoDlDX5G0w8a
htPV8x0W48Xydb7wX54W7/7cDx9n17h5j+sWl80P/zXqjDNCAqld2VRS7hrj
8pRROomKT9P1pMBJGd/szaFar6ANXtRt06gsmQAQXnRwGQPE7tZdnkaBh7Ao
6+PDKvGAxK7W0sJNr0ohHZ/AUlAgwgFVOjkebA+X9BxWLYBwXeUBAP2WdBE2
1dpOsVHcTkPyvnMBxi1BLGdqFWES5X3HSKtZ9kNolSCZFHureY3eOM0aHZZb
21qlWyXlXh+HEnrghi49OIu4bAZutD7zE+uGoRCmHewkUSZ25ieoi8T+UxqX
/U7KGYuUvgBnPAiipPrl4b+IL3R4wtg=
            "], {{0, 19}, {15, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{15, 19},
          PlotRange->{{0, 15}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{19, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ad67eaf9-2743-4b71-be6f-781eef874a72"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzVkaFuwzAQhk8bGdukPcFewHjUcChSp7KSVourkS5KJ02lYYZhZkFBRUVB
IUUhISYmASUlAwEhBgbdOc6aNquGRnaSozvfZ/u/Pw+ztxG7AoDlDX5G0w8a
htPV8x0W48Xydb7wX54W7/7cDx9n17h5j+sWl80P/zXqjDNCAqld2VRS7hrj
8pRROomKT9P1pMBJGd/szaFar6ANXtRt06gsmQAQXnRwGQPE7tZdnkaBh7Ao
6+PDKvGAxK7W0sJNr0ohHZ/AUlAgwgFVOjkebA+X9BxWLYBwXeUBAP2WdBE2
1dpOsVHcTkPyvnMBxi1BLGdqFWES5X3HSKtZ9kNolSCZFHureY3eOM0aHZZb
21qlWyXlXh+HEnrghi49OIu4bAZutD7zE+uGoRCmHewkUSZ25ieoi8T+UxqX
/U7KGYuUvgBnPAiipPrl4b+IL3R4wtg=
              "], {{0, 19}, {15, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {15, 19}, 
            PlotRange -> {{0, 15}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d2d25228-7532-47a8-9abf-61f9c895b16a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.7"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ad1fa4a9-a14c-469d-bc39-ae3c398958f9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5b1e1e27-4143-44d4-8c06-d79873c3debe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8aacadb0-2d0d-495e-b8ae-cba69e598b43"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Reverse",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Reverse",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{
     StyleBox["Range",
      FontFamily->"Source Sans Pro"], "[", "10", "]"}], "]"}], "]"}]], 
  "InlineCode",ExpressionUUID->"963a25a2-01f6-4fa2-b2f8-542a8d6d4f3e"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"abc22d3a-10fe-43cb-bb5b-a3b55224e03c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2578de91-bf66-4749-820e-8f6a71ca9e04"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCuTrEYUphITmar8gvwBdCwyiqqbihtzb2W5FbOh9qYqhW1HReFwKBQK
hcKg2mDatGmBwSAQmBYtJud0MzPMTjczyRUxc6p2a3b34zy+82R//PTHh+gb
z/O+fAffPnz8K3h7+5j88j388Ovrl98/v7789vPrny+fX95++vQt/PIH+Pob
vvDz8SlPecpTnvKU/1PmJo18P2bS/LgIxoZF7T2xjLSpq6qmfNqDyYm2dVU3
lI+PuMH7fpil469q5OwifHDhEDoPXYN2+WRHyWlg1zI4kCAjoxAqxLBjERjp
W0RBAHsojXxPr5q6piqrmo3GwlJGQXAgdFoxC8vhWojSelRHUSWelpQ6Dc2s
8jXGfI8rboWpsQ03sDDtdlN+pBnC/ZS64sqMolWCfnHgeLnFlTZeWRZ41+Jn
vU2ZbFNEBqHGx7U9R2rQKM/XHibN4IrRRu/6rPGiFmBB8aY4bKhY+szzMmN6
aEsSI1F570yQKOHpVLcE5BqtWbtIjU3gE6GzosMMqINSJEJUxsUwtxKFtvLA
CwsGirW4NM2a+wQDPc5VmjvqXim5amEFxBva071QUEZajHWmwJJvDWFskfYK
Q1V1AkmKXRm6pXfz7ICfotpExsErPzMgyTBBG8scVGTuBIHf86lDZ5ruM7/C
OrILG1MIKzgcfC+wVzLIBJZyvt+FUBW1rs97Dl0e4FBth9I+BKB2IUFJp6lQ
LHAkqIeaOJF5HBtwoOA7DmzpVXUMgecGzbHyI1NRDMrRX3+PHXHWDyLRq90E
XfvmkZ0Fs0wj66oD1kbpcpphQ3vNMJaha9QgV3oCHuIoIlnJJ3um9DQIOw5D
oijKhs93EjpUMAIi4URNetZELR9oAchksCE1CenK19zdYe+K3iXf1KTEXbOW
MddJgY+zaDGH28n/cILUUGviHeVnHDgNWJdCoyRpMMlFANXk0KYECfwoLZqm
jHDUh9YlafYpepWQA8KCdu+Kwamix6YbgSW+SlgKK0aKUtcOyXNi9mTuWpDH
mwQFlwRp59fdqvTMT2ue6t3Uzi4Nbpkp1v3B2RdnUXJqMsTWlvpbCn1JxGmW
ZSQ0W6h1LtmT6c53nDEmQdXaEiLe51+Po1I4rzPJCwSwSS2iTEJHCNoj0WUk
SUje0Rrb6as7CH7KdbLVzDHrpL1oUAyHJNslfqJ4HQTZ/pF9iRwHuJVS2ZV5
lucZShrq1ig6a4I2d4He3VYSdIx+t/4Fw3fOTOiOBhrowNzXM25qj5yImHHd
urWtDuCM9fAgdskVvarB+VUYFwSeXJFZs6Y2CoqDReCKMDtIwonOOvxTUnbw
2jHqow8Ok4A05zjk2B5MI7c963tKqYBRfwND037S8nGehjoN11q9gW1d1yNO
F/wNTC9TQsU4Db1uR78ZLUahKwj2dc6nqdc3Le5rh1G93PNLId7AxpboOcMW
KUWX6/NjuoXBe0x8IB0fRF+F+hpXNm1Wek3Lk5pNAln1SXdckwU7KDfPXq44
2YfXbwcZDETJNB+XM4/l71C6NW5gcuzNGljfMxphjL2DbeR8SFtgy9AlF7NB
QSeXNnWqH81Dv2MUAwk2CbLAVJdHZ6tRrl/lbmAK5skpUD/K1yl4q81KL9RJ
cTIRZucJur3i9OWT7kw0bLFtpf0bmJLLPF/9V+JrtS2PaFNoVap7sIeMrjHI
OzDAXIEeNgoi9cPbuDheD+uzZtwF59Rfy4ijChblnZvhCftvMJtIWiTe1b6T
tEzh9cL60q2WUYy7/4V6wr4CZhPZpHFMCvHw2/ZTnvIUl/wD3gLYPg==
            "], {{0, 
            19}, {139, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{139, 19},
          PlotRange->{{0, 139}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{143, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "85091a6e-6923-4675-9108-868fb5142db7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCuTrEYUphITmar8gvwBdCwyiqqbihtzb2W5FbOh9qYqhW1HReFwKBQK
hcKg2mDatGmBwSAQmBYtJud0MzPMTjczyRUxc6p2a3b34zy+82R//PTHh+gb
z/O+fAffPnz8K3h7+5j88j388Ovrl98/v7789vPrny+fX95++vQt/PIH+Pob
vvDz8SlPecpTnvKU/1PmJo18P2bS/LgIxoZF7T2xjLSpq6qmfNqDyYm2dVU3
lI+PuMH7fpil469q5OwifHDhEDoPXYN2+WRHyWlg1zI4kCAjoxAqxLBjERjp
W0RBAHsojXxPr5q6piqrmo3GwlJGQXAgdFoxC8vhWojSelRHUSWelpQ6Dc2s
8jXGfI8rboWpsQ03sDDtdlN+pBnC/ZS64sqMolWCfnHgeLnFlTZeWRZ41+Jn
vU2ZbFNEBqHGx7U9R2rQKM/XHibN4IrRRu/6rPGiFmBB8aY4bKhY+szzMmN6
aEsSI1F570yQKOHpVLcE5BqtWbtIjU3gE6GzosMMqINSJEJUxsUwtxKFtvLA
CwsGirW4NM2a+wQDPc5VmjvqXim5amEFxBva071QUEZajHWmwJJvDWFskfYK
Q1V1AkmKXRm6pXfz7ICfotpExsErPzMgyTBBG8scVGTuBIHf86lDZ5ruM7/C
OrILG1MIKzgcfC+wVzLIBJZyvt+FUBW1rs97Dl0e4FBth9I+BKB2IUFJp6lQ
LHAkqIeaOJF5HBtwoOA7DmzpVXUMgecGzbHyI1NRDMrRX3+PHXHWDyLRq90E
XfvmkZ0Fs0wj66oD1kbpcpphQ3vNMJaha9QgV3oCHuIoIlnJJ3um9DQIOw5D
oijKhs93EjpUMAIi4URNetZELR9oAchksCE1CenK19zdYe+K3iXf1KTEXbOW
MddJgY+zaDGH28n/cILUUGviHeVnHDgNWJdCoyRpMMlFANXk0KYECfwoLZqm
jHDUh9YlafYpepWQA8KCdu+Kwamix6YbgSW+SlgKK0aKUtcOyXNi9mTuWpDH
mwQFlwRp59fdqvTMT2ue6t3Uzi4Nbpkp1v3B2RdnUXJqMsTWlvpbCn1JxGmW
ZSQ0W6h1LtmT6c53nDEmQdXaEiLe51+Po1I4rzPJCwSwSS2iTEJHCNoj0WUk
SUje0Rrb6as7CH7KdbLVzDHrpL1oUAyHJNslfqJ4HQTZ/pF9iRwHuJVS2ZV5
lucZShrq1ig6a4I2d4He3VYSdIx+t/4Fw3fOTOiOBhrowNzXM25qj5yImHHd
urWtDuCM9fAgdskVvarB+VUYFwSeXJFZs6Y2CoqDReCKMDtIwonOOvxTUnbw
2jHqow8Ok4A05zjk2B5MI7c963tKqYBRfwND037S8nGehjoN11q9gW1d1yNO
F/wNTC9TQsU4Db1uR78ZLUahKwj2dc6nqdc3Le5rh1G93PNLId7AxpboOcMW
KUWX6/NjuoXBe0x8IB0fRF+F+hpXNm1Wek3Lk5pNAln1SXdckwU7KDfPXq44
2YfXbwcZDETJNB+XM4/l71C6NW5gcuzNGljfMxphjL2DbeR8SFtgy9AlF7NB
QSeXNnWqH81Dv2MUAwk2CbLAVJdHZ6tRrl/lbmAK5skpUD/K1yl4q81KL9RJ
cTIRZucJur3i9OWT7kw0bLFtpf0bmJLLPF/9V+JrtS2PaFNoVap7sIeMrjHI
OzDAXIEeNgoi9cPbuDheD+uzZtwF59Rfy4ijChblnZvhCftvMJtIWiTe1b6T
tEzh9cL60q2WUYy7/4V6wr4CZhPZpHFMCvHw2/ZTnvIUl/wD3gLYPg==
              "], {{
              0, 19}, {139, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {139, 19}, 
            PlotRange -> {{0, 139}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4fe6bb1f-db07-48e1-b2f7-4a55ca0dcb49"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.8"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0ee0c759-699a-497e-b18e-a3df109dbbc5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0b62ee8f-50cb-4d2a-b2b0-7515b0104cd2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1c8ef91f-49c6-46ea-933c-dc76a0fb99b7"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Join",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{
     StyleBox["Join",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"c2fb7ada-5305-4228-be0f-ecd5ad7a275b"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"0e901362-5751-4682-a93d-61454a482650"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"27f1dfd3-d9e3-4f56-9d70-0298b6fefaf6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVi2PnEAYJq2pbNJf0D+Arp1UVZFcU4e5S49LzZXcNWmwuJHjxqFQKBQK
gxozZswYBGYMAjFmBGI7H7sLtwvsJRVn9kkgfDzzfs37vPD57vdN9M7zvOcP
+nRz+xc8Pd0m3z/qmx+Pz78eHu9/fnv8c/9w//Tl7r1++EkfX/VhrndXXHHF
ZQwVjHw/ZsrdypaxTo5bK6QgVVkUJeH9Fk31pC6LsiJcvCYMTmk3qJW3o+Bs
Au/UTuYRAGFK+n2okmGt+giWYty1ReJZQDKs+mOFbznuHBd8xXEdzGgBbDZL
syPI0H1IVt5L5AztAagceZWFsyWSIs9DrhBdnaexMYjpaiJtrldDW2JdE5P0
4q6MogJ+2troawi0ayJXs1Bt4eILMF1LBAMvyJg2bLF/yrPA85GLVTGTyMwJ
15mg9US0zeHQeAOB2xHuaU26SRNQVxuEoe8BtJZIrz1hfrqrTKfnY2fYVPiQ
lIGi4EIiEyjS3HRDALIXrClC07v5Wh7MNIhXdSI31V1JRFLbeWEcRSnK+UEX
3AavLQ9tHetizDvz1YmMXWkDXNaIc68L5rBm0BlJKlOMDHgAr1gb2xT4Ecyq
Ko+MWAIn4tH2JCw5tHKs505emchATB3D1TpPIai+QoZbdudyl5mdCDFECKWB
U0ndXXLd+NM4UtgOgXHgqb5I65ljZjTCNgPsiVE5QNvDd5qkIwPLk1A1OUYY
IwMY2FJnzWIi41QFSYw1W2rFM70mI2ZDW9PCTiNKf0FYY14leaPHttChjDzR
GkyrY1RK1KHtFlxTRikhpB3Gc1qlW9ZPai6GviuhKXbeqnPaPFTbWsxentJK
I4CUtKLvqN1evxImMytw7GjT1FI08F4AUalf23XTWGP4hGVLfUZTgqbhcfT7
qGqdsxPaDMcBu0CTXZNMbkFG+kMw09Sy3xG40Ulmyw7kDSzSRiWH4cVfwv9a
ky+scWx20dFcm4EIL2hRj3jTIl7OLmj/LWiKZIlVKp2e5FCPZ77YuFK0Yu3/
521pqoJxnGbtxd294i3wDwXO6Es=
            "], {{0, 19}, {67, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{67, 19},
          PlotRange->{{0, 67}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{71, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6eb53b36-0cce-4f93-b6dd-005427d6cf54"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVi2PnEAYJq2pbNJf0D+Arp1UVZFcU4e5S49LzZXcNWmwuJHjxqFQKBQK
gxozZswYBGYMAjFmBGI7H7sLtwvsJRVn9kkgfDzzfs37vPD57vdN9M7zvOcP
+nRz+xc8Pd0m3z/qmx+Pz78eHu9/fnv8c/9w//Tl7r1++EkfX/VhrndXXHHF
ZQwVjHw/ZsrdypaxTo5bK6QgVVkUJeH9Fk31pC6LsiJcvCYMTmk3qJW3o+Bs
Au/UTuYRAGFK+n2okmGt+giWYty1ReJZQDKs+mOFbznuHBd8xXEdzGgBbDZL
syPI0H1IVt5L5AztAagceZWFsyWSIs9DrhBdnaexMYjpaiJtrldDW2JdE5P0
4q6MogJ+2troawi0ayJXs1Bt4eILMF1LBAMvyJg2bLF/yrPA85GLVTGTyMwJ
15mg9US0zeHQeAOB2xHuaU26SRNQVxuEoe8BtJZIrz1hfrqrTKfnY2fYVPiQ
lIGi4EIiEyjS3HRDALIXrClC07v5Wh7MNIhXdSI31V1JRFLbeWEcRSnK+UEX
3AavLQ9tHetizDvz1YmMXWkDXNaIc68L5rBm0BlJKlOMDHgAr1gb2xT4Ecyq
Ko+MWAIn4tH2JCw5tHKs505emchATB3D1TpPIai+QoZbdudyl5mdCDFECKWB
U0ndXXLd+NM4UtgOgXHgqb5I65ljZjTCNgPsiVE5QNvDd5qkIwPLk1A1OUYY
IwMY2FJnzWIi41QFSYw1W2rFM70mI2ZDW9PCTiNKf0FYY14leaPHttChjDzR
GkyrY1RK1KHtFlxTRikhpB3Gc1qlW9ZPai6GviuhKXbeqnPaPFTbWsxentJK
I4CUtKLvqN1evxImMytw7GjT1FI08F4AUalf23XTWGP4hGVLfUZTgqbhcfT7
qGqdsxPaDMcBu0CTXZNMbkFG+kMw09Sy3xG40Ulmyw7kDSzSRiWH4cVfwv9a
ky+scWx20dFcm4EIL2hRj3jTIl7OLmj/LWiKZIlVKp2e5FCPZ77YuFK0Yu3/
521pqoJxnGbtxd294i3wDwXO6Es=
              "], {{0, 19}, {67, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {67, 19}, 
            PlotRange -> {{0, 67}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2d3a8588-c0b4-4da1-b6ca-ef57fd430ef2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.9"], StandardForm],
   ImageSizeCache->{134., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"99f13f09-6dea-4bdf-ab6d-95476405031a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cf3087ab-57fd-41e1-bfd3-05fe550e903e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3a82dec4-e2ff-4a64-9306-9af8b8eb49d7"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Join",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Range",
      FontFamily->"Source Sans Pro"], "[", "10", "]"}], ",", 
    RowBox[{
     StyleBox["Join",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["Range",
        FontFamily->"Source Sans Pro"], "[", "10", "]"}], ",", 
      RowBox[{
       StyleBox["Range",
        FontFamily->"Source Sans Pro"], "[", "5", "]"}]}], "]"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"a787c014-2a7a-47a6-a4fd-9e53b4896124"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"65754fe2-a272-484b-9007-cdd6a7c4e9f7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c5abce64-a8d1-41c7-9af3-6850414927ca"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWq+P5DYUTltSWKl/Qf+B4NLAokhXHRtyp25OJdvorlIVahYYZhYUFBQU
FBJkEmJiYhASEhAQYmCw9XMyO5kdOzO7e1JXV39gdXvz2e/H533xe5lfPv71
Lvre87wvP6of7z78E3z+/CH5/Sf1y/v7L39+ur/747f7v+8+3X3+9eMP6j9/
hg++8zz494ODg4ODg4ODg4ODg4ODg8O3j6lOI9+PqVh+nTml/Sz3VswDqauy
rAgb92hiJE1VVjVhwy1usK7rJ2H5VA6MnsB6Gw+oU9/WYJeNZpYYe3qO3sJU
GChRoaoYdiyqjHQNsFQAeyzNfJpeObZ1WZQVHXYtGNcaKE6aJ3DSbKWZiygI
DoiMq6szxZ7nRWk1yAdeJp5GSqy5mmjpa87yMy6ZxXATbmhh2u6m5oFkQPdT
Yvl8zpaNVgTdbOGxYssrTEeDZoF3Dj/rTJuJJgVmEGp+XJmzLHvN8nztYVL3
thhN6V3XLl5U3HrMnDTncNIAni+NZHV+2CyZu8zzsiW2vilQDBvizhoIL9Tq
VBcmVUkgaGMtk0Md+Ihr77VSAbGcCgXBy8W/EBu1Bls48MKcqo01bDtN+vgk
WqupTLHlwSClWHehuYo3NJ/YmajNUAOxTkRlyTeGMDSgfgmhyipR6Y5th+wy
vZu1PfwrqmyROWnObTppXi4NU4n1s8VXQeHPf2OEqUgyeyBqz+l4yZlIuu/h
SmvRLm1IlTLB4eB7gbnUK4zKEmb7tVBlr9JF+JpDpwVMqXIozKVYVUYlQNLq
VEgaWM5Yp471MZkPQ60cyNmOA9v0yipWgeOFzeCERLsXWSfNEU6aV0hDVVHw
19CgLj2mSEFAYncDOQHS66GdFmUeB9qWByiehS0OCpcRr+6HIrTd9EBufcs5
xFGEsoKN5sOmbzJhy9QFJ8+Lmk1XzmRfqkIccStr1PekqGE9yRUz6U1MnYR0
zdfUXsneWXpnvNFOQBe2eyqcNCc4aV4uDdN/8mrniTdQ5La9w82ByL7SDlrq
szaPj92TbcNlk6SGZOSBKreW3SRHgR+leV0XEbQzobHNWuYY4FWCDkALmr0p
C1zq9NXIzoBnwIqw4EaO4IXOMcIYLZ0WtnW/DxdnLDidMe28tXG+WLsHJ80C
J41RGqm7hrRiqR4zNFsjNwYyEag+B2t1OrkgxjoDbmUo0HOuJx1xmmUZCpc+
prHOZ46mW98yZlnOWLk+M3i8f4T0bbCwj3QEy4FARznzIgktIWiPeJuhJEG4
JRU8b/7bR4yTZuuRk2Y1vZVGYF0N5cSgLKJmY5hCF0N3HRwJTC+CbP8Fxkk8
6M6Mp0K0Bc4wzgBpqAtU3hoD2YyU9NjHqKOWyW/XT0BB671IPT5q9YQ5UHtD
BxMSDx0TMUHDZt9tdQCuuB68RLHhLL2yhrtXvrjAYSQU7fXQTpojnDSvkWYp
njmBywOHJmPp/QWnlLbwUVK0jOq3nZIlqgyi+tErMTSH5R7VdLTrCCFc9XEX
NMienzRsmMa+SsO1mF/Qtq7qa4x+IlzQ9BwGET6MfaeLol8PBqPqsYGgumI2
jp1+HQOjHotRPRfCJ8EuaEOD9B2JzkLwFuvJ1XhJk2MbH1DLet6VEGesR8QG
o4b0Ls9EVNGRQ1Z91Bo9cdI4ab6aNOu4Dy+00+RfdKF3hkx1O4LqdadXAxQ/
YekCdUETQ7f0eBp+VvPF2BPaBo8vKQy0uW+Tk9kgJ6NtN3nMs5aj2zEKgQSb
M2agyRZHj1YjrF/CXtCkqurHQP0Ir5e1y92M6VVHPT+aCLPnrXXSOGleIM35
5F+PZNOdWwtcD7al+Dk0KeZpOvsu1Gt3m2/ZTYJVIa/RbjK6xiCu0BTnjHSz
UQWhF3+tLN1Ic9L8b6VhMNZcaUsjEDzWxnMMcB3xCnplpuFoL6O9HU8c7Ra8
ZYdvowmSQ+e1GZUIUqRRhIzfapDzwK9/4dnRXkh7O5442i14yw7fRhN1Gsco
5zd//crBwcHBwcHhW8K/hXNHcg==
            "], {{0, 19}, {341, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{341, 19},
          PlotRange->{{0, 341}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{345, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "26a358ab-fedf-46ee-982d-a5b80c3cea84"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWq+P5DYUTltSWKl/Qf+B4NLAokhXHRtyp25OJdvorlIVahYYZhYUFBQU
FBJkEmJiYhASEhAQYmCw9XMyO5kdOzO7e1JXV39gdXvz2e/H533xe5lfPv71
Lvre87wvP6of7z78E3z+/CH5/Sf1y/v7L39+ur/747f7v+8+3X3+9eMP6j9/
hg++8zz494ODg4ODg4ODg4ODg4ODg8O3j6lOI9+PqVh+nTml/Sz3VswDqauy
rAgb92hiJE1VVjVhwy1usK7rJ2H5VA6MnsB6Gw+oU9/WYJeNZpYYe3qO3sJU
GChRoaoYdiyqjHQNsFQAeyzNfJpeObZ1WZQVHXYtGNcaKE6aJ3DSbKWZiygI
DoiMq6szxZ7nRWk1yAdeJp5GSqy5mmjpa87yMy6ZxXATbmhh2u6m5oFkQPdT
Yvl8zpaNVgTdbOGxYssrTEeDZoF3Dj/rTJuJJgVmEGp+XJmzLHvN8nztYVL3
thhN6V3XLl5U3HrMnDTncNIAni+NZHV+2CyZu8zzsiW2vilQDBvizhoIL9Tq
VBcmVUkgaGMtk0Md+Ihr77VSAbGcCgXBy8W/EBu1Bls48MKcqo01bDtN+vgk
WqupTLHlwSClWHehuYo3NJ/YmajNUAOxTkRlyTeGMDSgfgmhyipR6Y5th+wy
vZu1PfwrqmyROWnObTppXi4NU4n1s8VXQeHPf2OEqUgyeyBqz+l4yZlIuu/h
SmvRLm1IlTLB4eB7gbnUK4zKEmb7tVBlr9JF+JpDpwVMqXIozKVYVUYlQNLq
VEgaWM5Yp471MZkPQ60cyNmOA9v0yipWgeOFzeCERLsXWSfNEU6aV0hDVVHw
19CgLj2mSEFAYncDOQHS66GdFmUeB9qWByiehS0OCpcRr+6HIrTd9EBufcs5
xFGEsoKN5sOmbzJhy9QFJ8+Lmk1XzmRfqkIccStr1PekqGE9yRUz6U1MnYR0
zdfUXsneWXpnvNFOQBe2eyqcNCc4aV4uDdN/8mrniTdQ5La9w82ByL7SDlrq
szaPj92TbcNlk6SGZOSBKreW3SRHgR+leV0XEbQzobHNWuYY4FWCDkALmr0p
C1zq9NXIzoBnwIqw4EaO4IXOMcIYLZ0WtnW/DxdnLDidMe28tXG+WLsHJ80C
J41RGqm7hrRiqR4zNFsjNwYyEag+B2t1OrkgxjoDbmUo0HOuJx1xmmUZCpc+
prHOZ46mW98yZlnOWLk+M3i8f4T0bbCwj3QEy4FARznzIgktIWiPeJuhJEG4
JRU8b/7bR4yTZuuRk2Y1vZVGYF0N5cSgLKJmY5hCF0N3HRwJTC+CbP8Fxkk8
6M6Mp0K0Bc4wzgBpqAtU3hoD2YyU9NjHqKOWyW/XT0BB671IPT5q9YQ5UHtD
BxMSDx0TMUHDZt9tdQCuuB68RLHhLL2yhrtXvrjAYSQU7fXQTpojnDSvkWYp
njmBywOHJmPp/QWnlLbwUVK0jOq3nZIlqgyi+tErMTSH5R7VdLTrCCFc9XEX
NMienzRsmMa+SsO1mF/Qtq7qa4x+IlzQ9BwGET6MfaeLol8PBqPqsYGgumI2
jp1+HQOjHotRPRfCJ8EuaEOD9B2JzkLwFuvJ1XhJk2MbH1DLet6VEGesR8QG
o4b0Ls9EVNGRQ1Z91Bo9cdI4ab6aNOu4Dy+00+RfdKF3hkx1O4LqdadXAxQ/
YekCdUETQ7f0eBp+VvPF2BPaBo8vKQy0uW+Tk9kgJ6NtN3nMs5aj2zEKgQSb
M2agyRZHj1YjrF/CXtCkqurHQP0Ir5e1y92M6VVHPT+aCLPnrXXSOGleIM35
5F+PZNOdWwtcD7al+Dk0KeZpOvsu1Gt3m2/ZTYJVIa/RbjK6xiCu0BTnjHSz
UQWhF3+tLN1Ic9L8b6VhMNZcaUsjEDzWxnMMcB3xCnplpuFoL6O9HU8c7Ra8
ZYdvowmSQ+e1GZUIUqRRhIzfapDzwK9/4dnRXkh7O5442i14yw7fRhN1Gsco
5zd//crBwcHBwcHhW8K/hXNHcg==
              "], {{0, 19}, {341, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {341, 19}, 
            PlotRange -> {{0, 341}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fcb01493-810d-4f08-a424-40b70bbac072"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.10"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e409a571-cfb5-4a12-aed0-3a52d718f89f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a1f86a0d-5706-40e8-be8b-c982dd59d8cf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5629cdb9-dec9-40be-8eff-2b0b7b199c5e"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Reverse",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Join",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["Range",
       FontFamily->"Source Sans Pro"], "[", "20", "]"}], ",", 
     RowBox[{
      StyleBox["Reverse",
       FontFamily->"Source Sans Pro"], "[", 
      RowBox[{
       StyleBox["Range",
        FontFamily->"Source Sans Pro"], "[", "20", "]"}], "]"}]}], "]"}], 
   "]"}]], "InlineCode",ExpressionUUID->
  "d601e59a-c1d1-4fe7-aeb9-124480ac4842"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "3.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"482fade5-ee54-4812-9ca3-3d0fc02d5cc1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a31b3976-b812-4d3a-a1fd-c1059aa2ddb7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa2zrMgVJ4mJzL8QG4GORUZN1abWjdmtPLZiXqjdVKWwOCQOh0KhUCgM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            "], {{0, 42}, {368, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{368, 42},
          PlotRange->{{0, 368}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{372, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ce9f3047-564e-4671-a515-e97b27ae6251"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa2zrMgVJ4mJzL8QG4GORUZN1abWjdmtPLZiXqjdVKWwOCQOh0KhUCgM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              "], {{0, 42}, {368, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {368, 42}, 
            PlotRange -> {{0, 368}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0e3fa91b-e2b4-4c67-b3a2-47931272bdda"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["3.11"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c0a9f192-4a89-4139-96b8-8e2b3c48061b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"288bc299-f413-4bd4-bbb2-5c093f1a8c23"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2f2326d0-53fb-4699-ade8-5c468a7a3955"],

Cell[TextData[{
 "Compute the reverse of the reverse of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "InlineCode",
  ExpressionUUID->"a5dc9c5b-740a-4cfa-a85e-34f22e623f35"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+3.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"c3b25a1b-2a9b-4686-9e30-2f1640687dac"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e55ba26-4797-4204-a967-3d7be5318595"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVSGPnjAYbjYzuWS/YH8AucxWTpHcMoe5y47LzI3cLVmwuMq6OhQKhUJh
UDU1NTUIDAaBwFQgbn3bj33cfcB9S7Zk4t4EQuHp26fP+7zl/dX3i/AVQuj+
jbldXP7Ed3eX8ee3ZvDl9v7bze3110+3P65vru8+Xr02L9+Z64O54PnhJV7i
f4mhJKHnRVK74dhI2Y7T3oyx42WR5wVX/R5M97wq8qLkqjuHhhKiHQyJMQsx
DhLeHziMkpmWCUnRTQ9NHiMbhA+biWTuWYy7R7lahU1d5S9gPql39/zAKcA9
ws1UVabB4dkyFBQh6vRrqyyJAMnEJsMmM7OJFcVsFnazquPUldhLGkurIhgh
zMdNerrJnTI+E+6NSn3kUUdCS2C4mK0MRbrN0BAbZg8MnOwvfYDVyS6sI0Zo
HAQewvTAUDKMPOZmgCYzW8tY4GcYHkNQg012TDb2nazzAGyUbRGUUFJUtl0G
ss0aWlZmytBUkaE/V/yPGE5tYVde96EjaJRwsZXQJYlL2GWKEWaHbJOtOykU
sV6ulrPPZDhw2HmwqcyRg+5LCtiiPe2VMbXtFBFKaeI7J1at48Fsj02DSsxD
Ui0ySvCh3F2559AimO6fNXqRE6+fD7rOGGWMQhAfKPlpDQy1Ss0g5aBtAzZx
PtTmJJQ1fIqzWknZaWj92Bg4KX8vp7sqsIVjlZBCcM6bYTqFlcY9Xlypbujb
goA8WaNPYYuYbJWlG9juYA527GUtfPQoqBjNZ+DjHZtdsicoK84JTHciCbwZ
4tGycYs9gS0CTOuncl7l2Mv2PCQ7RQWRZ/BOrMImPQ7Do//TmdkUA0EdzFUc
h2zFyOaogmqhTD7TOH8VpnkaW5uL45uMhGGiVs0xdk239uEfwnRJoihJm2eF
fonz4hfcoF+V
            "], {{0, 19}, {54, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{54, 19},
          PlotRange->{{0, 54}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{58, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d469cfa5-021b-4b24-8f93-af939ab25f40"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVSGPnjAYbjYzuWS/YH8AucxWTpHcMoe5y47LzI3cLVmwuMq6OhQKhUJh
UDU1NTUIDAaBwFQgbn3bj33cfcB9S7Zk4t4EQuHp26fP+7zl/dX3i/AVQuj+
jbldXP7Ed3eX8ee3ZvDl9v7bze3110+3P65vru8+Xr02L9+Z64O54PnhJV7i
f4mhJKHnRVK74dhI2Y7T3oyx42WR5wVX/R5M97wq8qLkqjuHhhKiHQyJMQsx
DhLeHziMkpmWCUnRTQ9NHiMbhA+biWTuWYy7R7lahU1d5S9gPql39/zAKcA9
ws1UVabB4dkyFBQh6vRrqyyJAMnEJsMmM7OJFcVsFnazquPUldhLGkurIhgh
zMdNerrJnTI+E+6NSn3kUUdCS2C4mK0MRbrN0BAbZg8MnOwvfYDVyS6sI0Zo
HAQewvTAUDKMPOZmgCYzW8tY4GcYHkNQg012TDb2nazzAGyUbRGUUFJUtl0G
ss0aWlZmytBUkaE/V/yPGE5tYVde96EjaJRwsZXQJYlL2GWKEWaHbJOtOykU
sV6ulrPPZDhw2HmwqcyRg+5LCtiiPe2VMbXtFBFKaeI7J1at48Fsj02DSsxD
Ui0ySvCh3F2559AimO6fNXqRE6+fD7rOGGWMQhAfKPlpDQy1Ss0g5aBtAzZx
PtTmJJQ1fIqzWknZaWj92Bg4KX8vp7sqsIVjlZBCcM6bYTqFlcY9Xlypbujb
goA8WaNPYYuYbJWlG9juYA527GUtfPQoqBjNZ+DjHZtdsicoK84JTHciCbwZ
4tGycYs9gS0CTOuncl7l2Mv2PCQ7RQWRZ/BOrMImPQ7Do//TmdkUA0EdzFUc
h2zFyOaogmqhTD7TOH8VpnkaW5uL45uMhGGiVs0xdk239uEfwnRJoihJm2eF
fonz4hfcoF+V
              "], {{0, 19}, {54, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {54, 19}, 
            PlotRange -> {{0, 54}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a6d31739-9ec1-4158-a0f1-02cdd0025193"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x3.1"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"64ecda6e-2a0d-449f-9fd7-f1fa93b78d3d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3e7b9277-f220-40a3-a27c-1d662f5b53b0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c3feced7-5d19-4390-a427-2f7c4f4be758"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Reverse",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Join",
  FontFamily->"Source Sans Pro"],
 " to create the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "4", ",", "3", ",", "2", 
    ",", "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "45171b85-0830-4e0c-92d2-28f2c2d8bf76"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+3.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"8681e51f-624c-44dd-b6d1-305af4e1b7a5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6a5c3fcb-58bc-4211-aa6e-8c8022183a16"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCGP2zAYjTYyOGm/YH8geNRwKNJNYyF32uU0covuJp1KwwzNwoKCgoKC
QoJMQkxMAkJMAgJCDAI62+m1aWunvt2BTcqTWiXty/Pn58+fv/bzza+r4J3j
OI8fxNvV9RN4eLjefPsobr7fP/68u7/98fX+9+3d7cOXm/fiw0/i9SRe8nq7
YsWKFSv+LfQFDFw3JHy6HRpC2mFcemJguMizLMe0W6LxDpd5lheYMpswaF23
PTd8OzJKDqCtiWenZh2b5UwVdebbkAYA+BHudjYOJBYnYABzNm6bbOMoQNwb
oyeZqzjTe5hRLW1kpTejebBaXLYtRpLuQmyaApqEdgD18PdqlrFZzlTgzLeR
Fok/C2CokeOgacnbMo1COX5cG01uUvE0VMsv1ksKa9d4ZAVwo0ZFX0IgbMFm
W3iTTUF6cW2gDDFwvIQIYQWjlI2aZWyWM90afKOJ57houudEmjwbhAo2Mpss
Ruyfi0mP4bJ7O1oVLdIYFLkCfN91ADKZ3ImRYrq8G+zVLGN70UxPfSMiLdx4
ekKu17PhErwGF0w+oEaCGy0UtaFjpMp8WY9SU4BEbiynaFkqV95gy1Cr/e+H
QRChlHZGt63UrGPb4+JMz32jylih3DdlKFZoXrusTR7bXAVorFTTHp9gEpxE
NoUMPwEOiA1qYxMBN4BJUaSBLJGe9tCwVbOL7UR2caYa30ZVtWBOoarrZb9E
1qPHMgf8yzkw8q5Akpu35+k3JOoECiFCKPKmOlq2l4auXP3R/GK1xdj2w9nN
VOMbj9WROfY0EhdRORuYyNpCFiU7LM8BgJYbuEP/NBKgt4VXaYziGElAT6Vo
UmltmZ11A5ZqmjSwV7OJTcFqpjudE984TcSjCZbbqpFlaarJXHR6pJJfbdJK
tKWMy2ZkI06QqNhHxVnpq10WlzWpa4xx04/ntEKUIXdTUtZ3bQ5lWqUNP6fN
o1QbnKjLU1oui1qEG9a1tUo9t2CaQS3VLGOznKnet91hF0+0Q3fBa885AhLN
KCdqTof2g8QnLJUGZzTO6sjft7YuKpppsBPaDPsmTUMb2mpzGBYkuHuNmmVs
ljPV+3bcXag+GS5UB5nqz+QFaGkjH/r+6Nfja9WGN1V7u9jOQWO5lybaVDpA
EGtrP5Nby0nJhXNwpR2D42Sjanl9+CSFov2k2tI2sIZd+p9gpZ2CFzAMo6S5
mO4rVvw/+AM5/h+1
            "], {{0, 19}, {119, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{119, 19},
          PlotRange->{{0, 119}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{123, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "780660a4-ec04-4b50-b941-ba5c99defe10"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCGP2zAYjTYyOGm/YH8geNRwKNJNYyF32uU0covuJp1KwwzNwoKCgoKC
QoJMQkxMAkJMAgJCDAI62+m1aWunvt2BTcqTWiXty/Pn58+fv/bzza+r4J3j
OI8fxNvV9RN4eLjefPsobr7fP/68u7/98fX+9+3d7cOXm/fiw0/i9SRe8nq7
YsWKFSv+LfQFDFw3JHy6HRpC2mFcemJguMizLMe0W6LxDpd5lheYMpswaF23
PTd8OzJKDqCtiWenZh2b5UwVdebbkAYA+BHudjYOJBYnYABzNm6bbOMoQNwb
oyeZqzjTe5hRLW1kpTejebBaXLYtRpLuQmyaApqEdgD18PdqlrFZzlTgzLeR
Fok/C2CokeOgacnbMo1COX5cG01uUvE0VMsv1ksKa9d4ZAVwo0ZFX0IgbMFm
W3iTTUF6cW2gDDFwvIQIYQWjlI2aZWyWM90afKOJ57houudEmjwbhAo2Mpss
Ruyfi0mP4bJ7O1oVLdIYFLkCfN91ADKZ3ImRYrq8G+zVLGN70UxPfSMiLdx4
ekKu17PhErwGF0w+oEaCGy0UtaFjpMp8WY9SU4BEbiynaFkqV95gy1Cr/e+H
QRChlHZGt63UrGPb4+JMz32jylih3DdlKFZoXrusTR7bXAVorFTTHp9gEpxE
NoUMPwEOiA1qYxMBN4BJUaSBLJGe9tCwVbOL7UR2caYa30ZVtWBOoarrZb9E
1qPHMgf8yzkw8q5Akpu35+k3JOoECiFCKPKmOlq2l4auXP3R/GK1xdj2w9nN
VOMbj9WROfY0EhdRORuYyNpCFiU7LM8BgJYbuEP/NBKgt4VXaYziGElAT6Vo
UmltmZ11A5ZqmjSwV7OJTcFqpjudE984TcSjCZbbqpFlaarJXHR6pJJfbdJK
tKWMy2ZkI06QqNhHxVnpq10WlzWpa4xx04/ntEKUIXdTUtZ3bQ5lWqUNP6fN
o1QbnKjLU1oui1qEG9a1tUo9t2CaQS3VLGOznKnet91hF0+0Q3fBa885AhLN
KCdqTof2g8QnLJUGZzTO6sjft7YuKpppsBPaDPsmTUMb2mpzGBYkuHuNmmVs
ljPV+3bcXag+GS5UB5nqz+QFaGkjH/r+6Nfja9WGN1V7u9jOQWO5lybaVDpA
EGtrP5Nby0nJhXNwpR2D42Sjanl9+CSFov2k2tI2sIZd+p9gpZ2CFzAMo6S5
mO4rVvw/+AM5/h+1
              "], {{0, 19}, {119, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {119, 19}, 
            PlotRange -> {{0, 119}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fc2ae504-f9ea-4c0a-b956-76c1fff74759"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x3.2"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ef503ef7-0ee7-4223-ae42-84ed4def42bd"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c5982b97-02eb-48e0-908f-045a6c3339ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dc1001c2-1a57-4d62-bbc5-f81bc3bdee86"],

Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Reverse",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Join",
  FontFamily->"Source Sans Pro"],
 " to create ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
   "3", ",", "2", ",", "1", ",", "4", ",", "3", ",", "2", ",", "1", ",", "5", 
    ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}]], "InlineCode",
  ExpressionUUID->"7aec35a1-f2bc-4eac-a7fa-3c1d724cd12f"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+3.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"762e1f59-f42e-47a7-bf5c-28f4b896e3ac"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"adc49a80-93a4-48df-8063-089fb3e43d40"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK+PnEAUJq2pbNK/oP8AunZkFck1dZi79LjUXMm1SbMWN3IcqigUCoXC
oMZgxoxBcGIMAoEZgdjOG/aW211+nOjt0oQv2Q27fLz3Pebx3hs+3vy4ct4Y
hvHznfq6uv6NHh6uN1/eqx9f739+v7u//fb5/tft3e3Dp5u36s8P6vNHfeB4
u2LFihUrVqx4XdQJdkzTZXK7lRVN4yhOKBdTVzSCJnEUxZRXc8abgrGyaV8i
g+d5WcvR8xfQ1grOevByXFyHy4bQhA5CtkerXUQN89Uo5eD48TG1DICpvy2c
DcZcs8h8RnMjPua1iDaaYmBazyncUgLOTUwHz7biItoa0hnaAeXNkkNoeRLY
zwQ0OTEMIsF1gkyv0P5SjFQgdCiQIlRXY51zKknA8FhilWnouRCNn8+srCyi
TqTl54OEC2lrfGRYAVP+Nf6DEHhgGSbpfksGK3vkpM68MdfKY/1UwWqKx2k7
V8o3mVlZgVWCIts2DUSGb8uFtFXKhM9f0kqWEgJTuWj63RWQJE+rDHYrwbLI
hgIdTtYeQE5U7nlTPUPmaG5lGZQQIylFCOk2dVvOra3JdXm1XcfxSMir0SVe
Tghcr6ayXBepq9Kibw1QfzrMPWjbtoy1wNFGMOh60MgmAfkBMpA/Ye3c2rZt
4SHTwUGShA60PWuwJy8qhFY3BRxzrHt1euiklVVCIK3icrwQ1RQY9lzizdy9
JtBThYsJIZ7Vtam0nLB3Rm1HNjNzeNxaWgjS17NXW3NPHXhp92c/r7cMTcyN
FYXejsjsUK7sQCNgYwJlFvrE9wkAW/q5CLLB23J+bcDob31DwelAGiwrBMkD
dWlAoYAUUPWhzyaqLpublIu6KmMM2RcWUo3SGzUVeMlelRSpreuJn+Yszyml
Rd2e0mBaVHvADBxtwkztCwXM36e0XqUuZUwfHtMuoi2GRuXRQlRlrh8yMxGD
1hYTwm5q8jvafjaWIvfs/f7NJEnRndYx9cMz8y3jEJB7JzRVKI54RO0GT2k9
9luMAacX0daU2abnoYBWg04XFMLhbKz3s3h/SSubuj54LwMP9RN5AmegXUQb
OG3+mdPXDoH7UDU6WleZkeMP9nMBRcQI2cyYsdIWQJM0gLdSzzbUkoZY7dj4
YOdoRCHmXpeutEXQZIJd1wuK2Qd7xYoVy8Nfy0rMzw==
            "], {{0, 19}, {158, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{158, 19},
          PlotRange->{{0, 158}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{162, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fa5e4cb7-5073-4056-8bd9-af84e19d453d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK+PnEAUJq2pbNK/oP8AunZkFck1dZi79LjUXMm1SbMWN3IcqigUCoXC
oMZgxoxBcGIMAoEZgdjOG/aW211+nOjt0oQv2Q27fLz3Pebx3hs+3vy4ct4Y
hvHznfq6uv6NHh6uN1/eqx9f739+v7u//fb5/tft3e3Dp5u36s8P6vNHfeB4
u2LFihUrVqx4XdQJdkzTZXK7lRVN4yhOKBdTVzSCJnEUxZRXc8abgrGyaV8i
g+d5WcvR8xfQ1grOevByXFyHy4bQhA5CtkerXUQN89Uo5eD48TG1DICpvy2c
DcZcs8h8RnMjPua1iDaaYmBazyncUgLOTUwHz7biItoa0hnaAeXNkkNoeRLY
zwQ0OTEMIsF1gkyv0P5SjFQgdCiQIlRXY51zKknA8FhilWnouRCNn8+srCyi
TqTl54OEC2lrfGRYAVP+Nf6DEHhgGSbpfksGK3vkpM68MdfKY/1UwWqKx2k7
V8o3mVlZgVWCIts2DUSGb8uFtFXKhM9f0kqWEgJTuWj63RWQJE+rDHYrwbLI
hgIdTtYeQE5U7nlTPUPmaG5lGZQQIylFCOk2dVvOra3JdXm1XcfxSMir0SVe
Tghcr6ayXBepq9Kibw1QfzrMPWjbtoy1wNFGMOh60MgmAfkBMpA/Ye3c2rZt
4SHTwUGShA60PWuwJy8qhFY3BRxzrHt1euiklVVCIK3icrwQ1RQY9lzizdy9
JtBThYsJIZ7Vtam0nLB3Rm1HNjNzeNxaWgjS17NXW3NPHXhp92c/r7cMTcyN
FYXejsjsUK7sQCNgYwJlFvrE9wkAW/q5CLLB23J+bcDob31DwelAGiwrBMkD
dWlAoYAUUPWhzyaqLpublIu6KmMM2RcWUo3SGzUVeMlelRSpreuJn+Yszyml
Rd2e0mBaVHvADBxtwkztCwXM36e0XqUuZUwfHtMuoi2GRuXRQlRlrh8yMxGD
1hYTwm5q8jvafjaWIvfs/f7NJEnRndYx9cMz8y3jEJB7JzRVKI54RO0GT2k9
9luMAacX0daU2abnoYBWg04XFMLhbKz3s3h/SSubuj54LwMP9RN5AmegXUQb
OG3+mdPXDoH7UDU6WleZkeMP9nMBRcQI2cyYsdIWQJM0gLdSzzbUkoZY7dj4
YOdoRCHmXpeutEXQZIJd1wuK2Qd7xYoVy8Nfy0rMzw==
              "], {{0, 19}, {158,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {158, 19}, 
            PlotRange -> {{0, 158}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b01683c9-7056-405f-8bc3-e02afd3d6f07"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x3.3"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5f49d9fd-9784-4aa5-aba7-33f270657db0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"683f90af-6270-4984-bdff-c613a0fcffee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"06c3e9a1-14f0-4ce7-a7a2-ddcf1113e551"],

Cell[TextData[{
 "Plot the list of numbers ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"10", ",", "11", ",", "12", ",", "13", ",", "14"}], "}"}]], 
  "InlineCode",ExpressionUUID->"356d531e-c2ee-4656-a45e-444b4a274c47"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+3.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"a446c61a-cb0c-4573-8515-f890ce49aa30"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c3e616ce-51fc-4b33-b8bd-b58aca0d2c94"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3TFv2+gdwOG0XTr2K/RbdO3Y9YquAXro8dpFBe4KFR00BNBmZPDkRZOG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            "], {{0, 234}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 234},
          PlotRange->{{0, 360}, {0, 234}}]], "ExerciseOutput",
         ImageSize->{364, 234},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8a0b87bb-462b-480e-a640-4f6864febfa1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3TFv2+gdwOG0XTr2K/RbdO3Y9YquAXro8dpFBe4KFR00BNBmZPDkRZOG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              "], {{0, 234}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 234}, 
            PlotRange -> {{0, 360}, {0, 234}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29ff0187-b728-4055-8708-6d56dfcf1e83"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x3.4"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4fe593a5-7254-476d-8f4b-828f56c6ea78"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d12566f4-2c21-49d0-9aa9-5e89a41dc835"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"877a340c-9131-4843-b4fa-f57652623828"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Join",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Join",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["Range",
        FontFamily->"Source Sans Pro"], "[", "10", "]"}], ",", 
      RowBox[{
       StyleBox["Reverse",
        FontFamily->"Source Sans Pro"], "[", 
       RowBox[{
        StyleBox["Range",
         FontFamily->"Source Sans Pro"], "[", "10", "]"}], "]"}]}], "]"}], 
    ",", 
    RowBox[{
     StyleBox["Range",
      FontFamily->"Source Sans Pro"], "[", "10", "]"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"2b65cfa4-ed9b-484e-9082-869b400b2213"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+3.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"856975a7-e097-4674-b527-665a7eed75ba"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"99f25c22-106a-4c12-aa50-f84fa6176e8b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWy2P40YYdltSWKm/oH/AuNSwyNJVZSF36vpUco3uKlWmZoZmJpWRkZGR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            "], {{0, 19}, {413, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{413, 19},
          PlotRange->{{0, 413}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{417, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "30d8ed8c-e7f2-47c2-8e47-41abf5d41e2b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWy2P40YYdltSWKm/oH/AuNSwyNJVZSF36vpUco3uKlWmZoZmJpWRkZGR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              "], {{0, 19}, {413,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {413, 19}, 
            PlotRange -> {{0, 413}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"70d80004-2396-44c0-8994-77c044ab9a91"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x3.5"], StandardForm],
   ImageSizeCache->{139., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6321e4ba-6111-4c10-8d35-cc95f5617812"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4ad7a6e0-5abc-4fd9-833b-bd2101f2330e"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"354444ee-effc-47db-8209-29fc6efe4273"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"First Look at Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 3  First Look at Lists", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
03-first-look-at-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+3.1", "3.1", "3.10", "3.11", "+3.2", "3.2", "+3.3", "3.3", "+3.4", 
         "3.4", "+3.5", "3.5", "3.6", "3.7", "3.8", "3.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+3.1", "3.1", "3.10", "3.11", "+3.2", "3.2", "+3.3", "3.3", "+3.4", 
      "3.4", "+3.5", "3.5", "3.6", "3.7", "3.8", "3.9"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[7202, 196, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b191c6a2-b070-4b7a-b117-c63d3e7622e5",
   CellTags->"FirstInputCell"],
  Cell[32809, 699, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7e2c42b2-c55c-4ebc-a64c-3c0d8f8b9d2e",
   CellTags->"FirstInputCell"],
  Cell[40598, 919, 813, 26, 
  70, "Input", "ExpressionUUID" -> "048e8843-84a6-4b38-a792-077e45afd214",
   CellTags->"FirstInputCell"],
  Cell[57827, 1285, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6120b9e9-d929-486f-84c7-bb746770bbc2",
   CellTags->"FirstInputCell"],
  Cell[66036, 1515, 813, 26, 
  70, "Input", "ExpressionUUID" -> "57e13358-68f0-400c-a525-e5e1ef9edb61",
   CellTags->"FirstInputCell"],
  Cell[82666, 1871, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a3e72682-7a50-4dc7-8df0-01c4f8a2c740",
   CellTags->"FirstInputCell"],
  Cell[89461, 2075, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5b1e1e27-4143-44d4-8c06-d79873c3debe",
   CellTags->"FirstInputCell"],
  Cell[99118, 2325, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0b62ee8f-50cb-4d2a-b2b0-7515b0104cd2",
   CellTags->"FirstInputCell"],
  Cell[107327, 2554, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cf3087ab-57fd-41e1-bfd3-05fe550e903e",
   CellTags->"FirstInputCell"],
  Cell[117640, 2819, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a1f86a0d-5706-40e8-be8b-c982dd59d8cf",
   CellTags->"FirstInputCell"],
  Cell[132790, 3164, 813, 26, 
  70, "Input", "ExpressionUUID" -> "288bc299-f413-4bd4-bbb2-5c093f1a8c23",
   CellTags->"FirstInputCell"],
  Cell[140457, 3378, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3e7b9277-f220-40a3-a27c-1d662f5b53b0",
   CellTags->"FirstInputCell"],
  Cell[148976, 3613, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c5982b97-02eb-48e0-908f-045a6c3339ea",
   CellTags->"FirstInputCell"],
  Cell[157463, 3847, 813, 26, 
  70, "Input", "ExpressionUUID" -> "683f90af-6270-4984-bdff-c613a0fcffee",
   CellTags->"FirstInputCell"],
  Cell[169782, 4137, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d12566f4-2c21-49d0-9aa9-5e89a41dc835",
   CellTags->"FirstInputCell"],
  Cell[180975, 4419, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4ad7a6e0-5abc-4fd9-833b-bd2101f2330e",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 239896, 5638}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[642, 22, 646, 19, 70, "Exercise", "ExpressionUUID" -> \
"9debdb06-72b5-410e-aa00-c0546a790a40",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1313, 45, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5eac4d41-db0e-49ca-9ce2-18acb4fc7de9"],
Cell[1952, 66, 4644, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"97753574-7ad6-4bb0-abcf-a21f6852e8b9"]
}, Closed]],
Cell[CellGroupData[{
Cell[6633, 176, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"18ec879d-7c4c-4bda-8765-ef7cfb4455d6"],
Cell[7202, 196, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b191c6a2-b070-4b7a-b117-c63d3e7622e5",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8052, 227, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9c08239e-fba9-465d-bb31-cd8a23924859"],
Cell[8339, 238, 416, 9, 70, "Exercise", "ExpressionUUID" -> \
"aafdf490-8e2b-408c-aca4-8c2ad2d07bde",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[8780, 251, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c0daa25b-6a44-4010-bea9-7241493c2956"],
Cell[9419, 272, 22784, 402, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a5f90c4e-a21c-49d5-a88f-cc7dfbf29826"]
}, Closed]],
Cell[CellGroupData[{
Cell[32240, 679, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"3e9575a9-d25e-4526-8dd7-6b3b3e20855d"],
Cell[32809, 699, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7e2c42b2-c55c-4ebc-a64c-3c0d8f8b9d2e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33671, 731, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c9980acc-7674-4765-911b-987ece2e7864"],
Cell[33958, 742, 702, 22, 70, "Exercise", "ExpressionUUID" -> \
"e7210382-bc91-4d70-b027-a5c52c4fe74a",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[34685, 768, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"540c4467-7bd9-40d7-b640-4b84fa7e4f20"],
Cell[35324, 789, 4668, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"720e6900-fd66-4804-a59f-3487249d0511"]
}, Closed]],
Cell[CellGroupData[{
Cell[40029, 899, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"48292a57-d5ff-4e77-88fe-c059f423c809"],
Cell[40598, 919, 813, 26, 70, "Input", "ExpressionUUID" -> \
"048e8843-84a6-4b38-a792-077e45afd214",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41460, 951, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d37acd2e-d0e5-4f29-8452-2ebf3469b1d3"],
Cell[41747, 962, 436, 9, 70, "Exercise", "ExpressionUUID" -> \
"384e874a-2871-4d41-9307-d4499823a3c7",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[42208, 975, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c69db293-075e-487a-a8cf-4ad0f7b1c6dd"],
Cell[42847, 996, 14374, 264, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f573d4c1-c5c0-4508-9275-46ee1dcae357"]
}, Closed]],
Cell[CellGroupData[{
Cell[57258, 1265, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"f15047f1-9f6c-4f0c-ac85-8010f106c03a"],
Cell[57827, 1285, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6120b9e9-d929-486f-84c7-bb746770bbc2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58689, 1317, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"11396b22-bf20-4a81-b2d2-6576b666bc7a"],
Cell[58976, 1328, 810, 27, 70, "Exercise", "ExpressionUUID" -> \
"bbd12395-5c80-4d66-8350-aeac34abef42",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[59811, 1359, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9b6641c4-a66c-425a-80b0-992e5ef64829"],
Cell[60450, 1380, 4980, 110, 70, "ExerciseOutput", "ExpressionUUID" -> \
"20b13f32-a32e-46a6-a11c-a3793a4cf6df"]
}, Closed]],
Cell[CellGroupData[{
Cell[65467, 1495, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"e0beb40b-e352-4f3c-8716-9eea6f3fff2a"],
Cell[66036, 1515, 813, 26, 70, "Input", "ExpressionUUID" -> \
"57e13358-68f0-400c-a525-e5e1ef9edb61",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66898, 1547, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4b12ae53-e76c-4935-bc84-7130c16e7500"],
Cell[67185, 1558, 440, 9, 70, "Exercise", "ExpressionUUID" -> \
"2748f13f-aa7b-4ac3-b00b-d3341de66aa8",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[67650, 1571, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"59c1ccad-fcf2-4396-85ec-e53803e5ec28"],
Cell[68289, 1592, 13771, 254, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9187e0c7-06a9-4fe1-b6cb-569372ef928d"]
}, Closed]],
Cell[CellGroupData[{
Cell[82097, 1851, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"5e956a59-d5b3-4f88-bd13-f5ed8b53bea4"],
Cell[82666, 1871, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a3e72682-7a50-4dc7-8df0-01c4f8a2c740",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83528, 1903, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d8da3f81-e552-437c-b662-b3719af09389"],
Cell[83815, 1914, 635, 20, 70, "Exercise", "ExpressionUUID" -> \
"02cf4705-bf56-4972-b2af-f55740f4b447",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[84475, 1938, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5e92bd18-2861-4e83-acc6-1653eb8ed064"],
Cell[85134, 1960, 3721, 90, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d2d25228-7532-47a8-9abf-61f9c895b16a"]
}, Closed]],
Cell[CellGroupData[{
Cell[88892, 2055, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"ad1fa4a9-a14c-469d-bc39-ae3c398958f9"],
Cell[89461, 2075, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5b1e1e27-4143-44d4-8c06-d79873c3debe",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90323, 2107, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8aacadb0-2d0d-495e-b8ae-cba69e598b43"],
Cell[90610, 2118, 778, 23, 70, "Exercise", "ExpressionUUID" -> \
"abc22d3a-10fe-43cb-bb5b-a3b55224e03c",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[91413, 2145, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2578de91-bf66-4749-820e-8f6a71ca9e04"],
Cell[92052, 2166, 6460, 134, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4fe6bb1f-db07-48e1-b2f7-4a55ca0dcb49"]
}, Closed]],
Cell[CellGroupData[{
Cell[98549, 2305, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"0ee0c759-699a-497e-b18e-a3df109dbbc5"],
Cell[99118, 2325, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0b62ee8f-50cb-4d2a-b2b0-7515b0104cd2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99980, 2357, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1c8ef91f-49c6-46ea-933c-dc76a0fb99b7"],
Cell[100267, 2368, 870, 27, 70, "Exercise", "ExpressionUUID" -> \
"0e901362-5751-4682-a93d-61454a482650",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[101162, 2399, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"27f1dfd3-d9e3-4f56-9d70-0298b6fefaf6"],
Cell[101801, 2420, 4920, 109, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2d3a8588-c0b4-4da1-b6ca-ef57fd430ef2"]
}, Closed]],
Cell[CellGroupData[{
Cell[106758, 2534, 566, 18, 70, "Subsection", "ExpressionUUID" -> \
"99f13f09-6dea-4bdf-ab6d-95476405031a"],
Cell[107327, 2554, 813, 26, 70, "Input", "ExpressionUUID" -> \
"cf3087ab-57fd-41e1-bfd3-05fe550e903e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108189, 2586, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3a82dec4-e2ff-4a64-9306-9af8b8eb49d7"],
Cell[108476, 2597, 1014, 31, 70, "Exercise", "ExpressionUUID" -> \
"65754fe2-a272-484b-9007-cdd6a7c4e9f7",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[109515, 2632, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c5abce64-a8d1-41c7-9af3-6850414927ca"],
Cell[110154, 2653, 6879, 141, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fcb01493-810d-4f08-a424-40b70bbac072"]
}, Closed]],
Cell[CellGroupData[{
Cell[117070, 2799, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e409a571-cfb5-4a12-aed0-3a52d718f89f"],
Cell[117640, 2819, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a1f86a0d-5706-40e8-be8b-c982dd59d8cf",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118502, 2851, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5629cdb9-dec9-40be-8eff-2b0b7b199c5e"],
Cell[118789, 2862, 995, 31, 70, "Exercise", "ExpressionUUID" -> \
"482fade5-ee54-4812-9ca3-3d0fc02d5cc1",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[119809, 2897, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a31b3976-b812-4d3a-a1fd-c1059aa2ddb7"],
Cell[120448, 2918, 11735, 221, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0e3fa91b-e2b4-4c67-b3a2-47931272bdda"]
}, Closed]],
Cell[CellGroupData[{
Cell[132220, 3144, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"c0a9f192-4a89-4139-96b8-8e2b3c48061b"],
Cell[132790, 3164, 813, 26, 70, "Input", "ExpressionUUID" -> \
"288bc299-f413-4bd4-bbb2-5c093f1a8c23",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133652, 3196, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2f2326d0-53fb-4699-ade8-5c468a7a3955"],
Cell[133939, 3207, 603, 16, 70, "Exercise", "ExpressionUUID" -> \
"c3b25a1b-2a9b-4686-9e30-2f1640687dac",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[134567, 3227, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5e55ba26-4797-4204-a967-3d7be5318595"],
Cell[135206, 3248, 4644, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a6d31739-9ec1-4158-a0f1-02cdd0025193"]
}, Closed]],
Cell[CellGroupData[{
Cell[139887, 3358, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"64ecda6e-2a0d-449f-9fd7-f1fa93b78d3d"],
Cell[140457, 3378, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3e7b9277-f220-40a3-a27c-1d662f5b53b0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141319, 3410, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c3feced7-5d19-4390-a427-2f7c4f4be758"],
Cell[141606, 3421, 830, 27, 70, "Exercise", "ExpressionUUID" -> \
"8681e51f-624c-44dd-b6d1-305af4e1b7a5",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[142461, 3452, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6a5c3fcb-58bc-4211-aa6e-8c8022183a16"],
Cell[143100, 3473, 5269, 115, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fc2ae504-f9ea-4c0a-b956-76c1fff74759"]
}, Closed]],
Cell[CellGroupData[{
Cell[148406, 3593, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"ef503ef7-0ee7-4223-ae42-84ed4def42bd"],
Cell[148976, 3613, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c5982b97-02eb-48e0-908f-045a6c3339ea",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149838, 3645, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"dc1001c2-1a57-4d62-bbc5-f81bc3bdee86"],
Cell[150125, 3656, 851, 27, 70, "Exercise", "ExpressionUUID" -> \
"762e1f59-f42e-47a7-bf5c-28f4b896e3ac",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[151001, 3687, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"adc49a80-93a4-48df-8063-089fb3e43d40"],
Cell[151640, 3708, 5216, 114, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b01683c9-7056-405f-8bc3-e02afd3d6f07"]
}, Closed]],
Cell[CellGroupData[{
Cell[156893, 3827, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5f49d9fd-9784-4aa5-aba7-33f270657db0"],
Cell[157463, 3847, 813, 26, 70, "Input", "ExpressionUUID" -> \
"683f90af-6270-4984-bdff-c613a0fcffee",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158325, 3879, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"06c3e9a1-14f0-4ce7-a7a2-ddcf1113e551"],
Cell[158612, 3890, 605, 16, 70, "Exercise", "ExpressionUUID" -> \
"a446c61a-cb0c-4573-8515-f890ce49aa30",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[159242, 3910, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c3e616ce-51fc-4b33-b8bd-b58aca0d2c94"],
Cell[159881, 3931, 9294, 181, 70, "ExerciseOutput", "ExpressionUUID" -> \
"29ff0187-b728-4055-8708-6d56dfcf1e83"]
}, Closed]],
Cell[CellGroupData[{
Cell[169212, 4117, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4fe593a5-7254-476d-8f4b-828f56c6ea78"],
Cell[169782, 4137, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d12566f4-2c21-49d0-9aa9-5e89a41dc835",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[170644, 4169, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"877a340c-9131-4843-b4fa-f57652623828"],
Cell[170931, 4180, 1117, 35, 70, "Exercise", "ExpressionUUID" -> \
"856975a7-e097-4674-b527-665a7eed75ba",
 CounterAssignments->{{"SectionNumber", 3}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[172073, 4219, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"99f25c22-106a-4c12-aa50-f84fa6176e8b"],
Cell[172712, 4240, 7656, 154, 70, "ExerciseOutput", "ExpressionUUID" -> \
"70d80004-2396-44c0-8994-77c044ab9a91"]
}, Closed]],
Cell[CellGroupData[{
Cell[180405, 4399, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6321e4ba-6111-4c10-8d35-cc95f5617812"],
Cell[180975, 4419, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4ad7a6e0-5abc-4fd9-833b-bd2101f2330e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[181815, 4449, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"354444ee-effc-47db-8209-29fc6efe4273"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature YTcZeXM8TodHKjum2gScldv6 *)
