(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26973,        671]
NotebookOptionsPosition[     25692,        625]
NotebookOutlinePosition[     26335,        649]
CellTagsIndexPosition[     26292,        646]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Wave-Particle Duality in the Double-Slit Experiment", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", "[", "d_", "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"Gray", ",", "10"}], "]"}], ",", 
      RowBox[{"Cylinder", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", ".5"}], 
       "]"}], ",", "Black", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{"-", "1.5"}], ",", 
           RowBox[{"-", ".75"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1.5", ",", 
           RowBox[{"-", ".75"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1.5", ",", ".75"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{"-", "1.5"}], ",", ".75"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{"-", "1.5"}], ",", 
           RowBox[{"-", ".75"}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "3", ",", 
           RowBox[{"-", "1.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "3", ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", 
           RowBox[{"-", "3"}], ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", 
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1.5"}]}], "}"}]}], "}"}], "]"}], ",", "Thick", ",", 
      "White", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{
            RowBox[{"-", "d"}], "/", "2"}], ",", 
           RowBox[{"-", ".65"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{
            RowBox[{"-", "d"}], "/", "2"}], ",", ".65"}], "}"}]}], "}"}], 
       "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{"d", "/", "2"}], ",", 
           RowBox[{"-", ".65"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           RowBox[{"d", "/", "2"}], ",", ".65"}], "}"}]}], "}"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.403910528594325*^9, 3.403910534871735*^9}, 
   3.403911212018602*^9, 3.4039117769910593`*^9, 3.403912960573056*^9, {
   3.4039130076798573`*^9, 3.403913008676058*^9}, {3.40391315051254*^9, 
   3.403913209551607*^9}, {3.403913259818529*^9, 3.403913316881234*^9}, {
   3.403913352666346*^9, 3.4039133584867773`*^9}, {3.403913467338743*^9, 
   3.403913489992165*^9}, {3.403913538802505*^9, 3.403913561478804*^9}, {
   3.4039138759896517`*^9, 3.403913876217639*^9}, 3.403915026420494*^9, {
   3.403917014687108*^9, 3.403917017289589*^9}, {3.403917104373146*^9, 
   3.403917106177802*^9}, 3.403918916504642*^9, {3.403918954215371*^9, 
   3.403918976764627*^9}, {3.403919072352664*^9, 3.403919114836157*^9}, {
   3.403919154345202*^9, 3.40391918957232*^9}, {3.4039193162372437`*^9, 
   3.403919405603363*^9}, 3.404143311585224*^9},
 CellID->1897874382],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"d_", ",", "\[Lambda]_", ",", "\[Xi]_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"Sin", "[", " ", 
       FractionBox[
        RowBox[{"150", "\[Pi]", " ", "\[Xi]"}], "\[Lambda]"], "]"}], 
      RowBox[{" ", 
       FractionBox[
        RowBox[{"150", "\[Pi]", " ", "\[Xi]"}], "\[Lambda]"]}]], ")"}], "2"], 
   
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"300", "\[Pi]", " ", "d"}], "\[Lambda]"], "  ", "\[Xi]"}], 
     "]"}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.404065369411089*^9, 3.404065401116844*^9}, {
   3.404065432038415*^9, 3.404065476479768*^9}, {3.404065621970291*^9, 
   3.404065622201458*^9}, {3.4040667557270308`*^9, 3.404066762410172*^9}, {
   3.404066826471539*^9, 3.404066826824566*^9}, {3.404074743075016*^9, 
   3.404074832625731*^9}, 3.40407593388319*^9, {3.404077905855583*^9, 
   3.404077935193577*^9}, {3.404079141183155*^9, 3.404079141314765*^9}, 
   3.404079229884894*^9, 3.404079311749776*^9, {3.404079503632905*^9, 
   3.4040795112908916`*^9}, {3.4040795469255543`*^9, 3.404079547389379*^9}, {
   3.404079596325494*^9, 3.404079601426993*^9}, {3.40413364117286*^9, 
   3.404133674530539*^9}, {3.404134333411763*^9, 3.404134351019306*^9}, 
   3.404134408883554*^9, 3.404134463438756*^9, 3.404143109984622*^9, 
   3.4041433115869827`*^9, {3.404143488599956*^9, 3.404143494204834*^9}, {
   3.4041435654311447`*^9, 3.404143569660892*^9}},
 CellID->1400038656],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", "[", 
   RowBox[{"d_", ",", "\[Lambda]_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"ColorData", "[", "\"\<VisibleSpectrum\>\"", "]"}], "[", 
      "\[Lambda]", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", 
          RowBox[{
           RowBox[{"Re", "[", "#", "]"}], 
           RowBox[{"Boole", "[", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"d", ",", "\[Lambda]", ",", 
               RowBox[{"Re", "[", "#", "]"}]}], "]"}], "\[GreaterEqual]", 
             RowBox[{"Im", "[", "#", "]"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"3", 
               RowBox[{"Im", "[", "#", "]"}]}], 
              RowBox[{"f", "[", 
               RowBox[{"d", ",", "\[Lambda]", ",", 
                RowBox[{"Re", "[", "#", "]"}]}], "]"}]], "-", "1.5"}], ")"}], 
           
           RowBox[{"Boole", "[", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"d", ",", "\[Lambda]", ",", 
               RowBox[{"Re", "[", "#", "]"}]}], "]"}], "\[GreaterEqual]", 
             RowBox[{"Im", "[", "#", "]"}]}], "]"}]}]}], "}"}], "&"}], "/@", 
       RowBox[{"RandomComplex", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"3", "+", "\[ImaginaryI]"}]}], "}"}], ",", "n"}], "]"}]}], 
      "]"}], ",", "White", ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.40391121546058*^9, 3.403911217441708*^9}, {
   3.403911635931788*^9, 3.403911656561336*^9}, 3.4039117305483637`*^9, {
   3.4039125101636963`*^9, 3.4039125278980713`*^9}, {3.4039167906622353`*^9, 
   3.403916809151626*^9}, {3.4039194722687883`*^9, 3.403919494848812*^9}, {
   3.4040515994178133`*^9, 3.404051609961225*^9}, {3.404051851935727*^9, 
   3.404051863904615*^9}, {3.4040654905971937`*^9, 3.40406551014152*^9}, {
   3.40406554374338*^9, 3.404065555062458*^9}, 3.40406589941426*^9, 
   3.404065949442163*^9, 3.404066156925384*^9, {3.404066280318371*^9, 
   3.4040663022442217`*^9}, {3.4040663484618597`*^9, 3.404066418341823*^9}, {
   3.404066458911036*^9, 3.404066475534767*^9}, {3.404074894522149*^9, 
   3.404074899189158*^9}, {3.404076925153297*^9, 3.404076948801136*^9}, 
   3.404077033985568*^9, {3.404077556817436*^9, 3.404077630156987*^9}, {
   3.404077719090317*^9, 3.4040777263715143`*^9}, {3.404077885324086*^9, 
   3.404077894870385*^9}, 3.404078116050022*^9, 3.404143311588889*^9, {
   3.4041436595752773`*^9, 3.404143693531578*^9}, {3.404143727617078*^9, 
   3.404143747591762*^9}, {3.404143833525332*^9, 3.404143857070488*^9}, {
   3.404143902296912*^9, 3.404143924274845*^9}, {3.404172981483119*^9, 
   3.40417302739962*^9}, {3.404175584379825*^9, 3.404175585262236*^9}, {
   3.404175731903298*^9, 3.4041757345966167`*^9}, {3.4041757673664303`*^9, 
   3.404175795684379*^9}, 3.404175912944112*^9, 3.4041767963579903`*^9, {
   3.404177263512965*^9, 3.4041772887476263`*^9}, {3.404177923463099*^9, 
   3.4041779412998743`*^9}, 3.404177973439296*^9, {3.404213624796875*^9, 
   3.40421364090625*^9}, {3.404214066875*^9, 3.404214069421875*^9}},
 CellID->1000129383],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"g1", "[", "d", "]"}], ",", 
     RowBox[{"Refresh", "[", 
      RowBox[{
       RowBox[{"g2", "[", 
        RowBox[{"d", ",", "\[Lambda]", ",", "n"}], "]"}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "2"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"450", ",", "400"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "1", ",", "\"\<slit separation\>\""}], "}"}], ",", 
     "0", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[Lambda]", ",", "550", ",", "\"\<wavelength of light/nm\>\""}], "}"}],
      ",", "400", ",", "700", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "500", ",", "\"\<photons/pulse\>\""}], "}"}], ",", 
     "0", ",", "3500", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"d", ",", "\[Lambda]", ",", "n"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4039111742622547`*^9, 3.403911194722041*^9}, {
   3.4039112461391087`*^9, 3.403911342921336*^9}, {3.4039117880251226`*^9, 
   3.4039118090381937`*^9}, {3.40391187298892*^9, 3.403911883310437*^9}, 
   3.403911913632258*^9, {3.403912109107082*^9, 3.4039121795024347`*^9}, {
   3.403912263219864*^9, 3.4039122873670063`*^9}, {3.4039123540758457`*^9, 
   3.4039124028077793`*^9}, {3.403912539721031*^9, 3.40391254238489*^9}, {
   3.4039126424372663`*^9, 3.40391269564896*^9}, 3.403913377420619*^9, {
   3.403913812554906*^9, 3.403913836360732*^9}, {3.403913997012829*^9, 
   3.4039140105430937`*^9}, {3.403914963459464*^9, 3.403914993089479*^9}, {
   3.403916857994823*^9, 3.403916859044281*^9}, {3.4039172788426*^9, 
   3.403917326662278*^9}, {3.4039174398678513`*^9, 3.4039174406635103`*^9}, 
   3.403917497554716*^9, 3.40391756582622*^9, {3.4039176634388113`*^9, 
   3.4039177389829493`*^9}, {3.403918684442861*^9, 3.4039188358943253`*^9}, {
   3.4039192242308197`*^9, 3.403919261263835*^9}, {3.403959821042705*^9, 
   3.403960043054606*^9}, {3.4039601044248447`*^9, 3.40396013484142*^9}, {
   3.4039601759946413`*^9, 3.403960194179264*^9}, {3.403960278209838*^9, 
   3.403960313475811*^9}, {3.403960381745183*^9, 3.403960410111105*^9}, {
   3.404051634673437*^9, 3.4040516380859632`*^9}, {3.404051965313533*^9, 
   3.404051973486164*^9}, {3.404052013063236*^9, 3.404052022878941*^9}, {
   3.4040520910423183`*^9, 3.4040521747351093`*^9}, {3.404052256849059*^9, 
   3.4040522948576202`*^9}, 3.404066846401973*^9, {3.4040738409011087`*^9, 
   3.404073854165711*^9}, {3.4040757854980087`*^9, 3.404075787652508*^9}, {
   3.404077098913191*^9, 3.404077101110702*^9}, 3.40407925890431*^9, {
   3.404133735534848*^9, 3.40413373639963*^9}, 3.40413384715309*^9, 
   3.404133894584969*^9, {3.404134422047529*^9, 3.404134422891944*^9}, 
   3.4041345208704157`*^9, {3.404147557305736*^9, 3.404147621715026*^9}, {
   3.40414767547264*^9, 3.4041477074326277`*^9}, {3.4041755993893538`*^9, 
   3.404175611141036*^9}, 3.404175705993286*^9, 3.4041759430925083`*^9, {
   3.404176044453457*^9, 3.4041760501549788`*^9}, {3.404176096503253*^9, 
   3.4041761095804663`*^9}, {3.404176860143889*^9, 3.404176871359683*^9}, {
   3.404176902208126*^9, 3.404176933270132*^9}, {3.4041769651280413`*^9, 
   3.40417702549397*^9}, {3.404177132449641*^9, 3.404177134462747*^9}, 
   3.404177175207303*^9, {3.404177276048839*^9, 3.404177299256404*^9}, {
   3.404177385338019*^9, 3.404177448877677*^9}, {3.404177480279091*^9, 
   3.404177512396015*^9}, {3.404177562114046*^9, 3.4041775653276443`*^9}, {
   3.404213644875*^9, 3.4042136700625*^9}, {3.404213942984375*^9, 
   3.40421394303125*^9}, {3.404213991484375*^9, 3.404213995234375*^9}, {
   3.4042506616865244`*^9, 3.4042506778428774`*^9}, {3.40425780909375*^9, 
   3.4042578094375*^9}, {3.40425788346875*^9, 3.404257909828125*^9}, {
   3.404258019046875*^9, 3.4042580293125*^9}, {3.404258101796875*^9, 
   3.40425811153125*^9}, {3.404258163859375*^9, 3.40425817440625*^9}, {
   3.4042582174375*^9, 3.404258229*^9}, {3.40426328015625*^9, 
   3.40426329034375*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 1, $CellContext`n$$ = 
    500, $CellContext`\[Lambda]$$ = 550, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`d$$], 1, "slit separation"}, 0, 2}, {{
       Hold[$CellContext`\[Lambda]$$], 550, "wavelength of light/nm"}, 400, 
      700}, {{
       Hold[$CellContext`n$$], 500, "photons/pulse"}, 0, 3500, 1}}, 
    Typeset`size$$ = {450., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`d$1752152$$ = 0, $CellContext`\[Lambda]$1752153$$ = 
    0, $CellContext`n$1752154$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`d$$ = 1, $CellContext`n$$ = 
        500, $CellContext`\[Lambda]$$ = 550}, "ControllerVariables" :> {
        Hold[$CellContext`d$$, $CellContext`d$1752152$$, 0], 
        Hold[$CellContext`\[Lambda]$$, $CellContext`\[Lambda]$1752153$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$1752154$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        $CellContext`g1[$CellContext`d$$], 
        Refresh[
         $CellContext`g2[$CellContext`d$$, $CellContext`\[Lambda]$$, \
$CellContext`n$$], UpdateInterval -> 2], ImageSize -> {450, 400}], 
      "Specifications" :> {{{$CellContext`d$$, 1, "slit separation"}, 0, 2, 
         Appearance -> 
         "Labeled"}, {{$CellContext`\[Lambda]$$, 550, 
          "wavelength of light/nm"}, 400, 700, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 500, "photons/pulse"}, 0, 3500, 1, 
         Appearance -> "Labeled"}}, 
      "Options" :> {
       TrackedSymbols -> {$CellContext`d$$, $CellContext`\[Lambda]$$, \
$CellContext`n$$}}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{494., {268., 273.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`g1[
          Pattern[$CellContext`d, 
           Blank[]]] := Graphics3D[{Gray, 
           Specularity[Gray, 10], 
           Cylinder[{{0, 0, 0}, {2, 0, 0}}, 0.5], Black, 
           
           Polygon[{{5, -1.5, -0.75}, {5, 1.5, -0.75}, {5, 1.5, 0.75}, {
             5, -1.5, 0.75}, {5, -1.5, -0.75}}], 
           
           Line[{{10, -3, -1.5}, {10, 3, -1.5}, {10, 3, 1.5}, {10, -3, 1.5}, {
             10, -3, -1.5}}], Thick, White, 
           
           Line[{{5, -($CellContext`d/2), -0.65}, {
             5, -($CellContext`d/2), 0.65}}], 
           Line[{{5, $CellContext`d/2, -0.65}, {5, $CellContext`d/2, 0.65}}]},
           Boxed -> False, ViewPoint -> {-5, -2.5, 2.5}], $CellContext`g2[
          Pattern[$CellContext`d, 
           Blank[]], 
          Pattern[$CellContext`\[Lambda], 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := Graphics3D[{
           ColorData["VisibleSpectrum"][$CellContext`\[Lambda]], 
           Point[
            
            Map[{10, Re[#] 
              Boole[$CellContext`f[$CellContext`d, $CellContext`\[Lambda], 
                  Re[#]] >= 
                Im[#]], ((3 
                 Im[#])/$CellContext`f[$CellContext`d, $CellContext`\[Lambda],
                  
                 Re[#]] - 1.5) 
              Boole[$CellContext`f[$CellContext`d, $CellContext`\[Lambda], 
                  Re[#]] >= Im[#]]}& , 
             RandomComplex[{-3, 3 + I}, $CellContext`n]]], White, 
           Point[{10, 0, 0}]}], $CellContext`g2[
          Pattern[$CellContext`d, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := Graphics3D[{Red, 
           Map[
           Point[{10, (2 Re[#] - 2) 
              Boole[Sin[(2 Pi) Re[#]]^2 >= Im[#]], ((2 Im[#])/
                Sin[(2 Pi) Re[#]]^2 - 1) 
              Boole[Sin[(2 Pi) Re[#]]^2 >= Im[#]]}]& , 
            RandomComplex[2 + I, $CellContext`n]]}], $CellContext`f[
          Pattern[$CellContext`d, 
           Blank[]], 
          Pattern[$CellContext`\[Lambda], 
           Blank[]], 
          Pattern[$CellContext`\[Xi], 
           Blank[]]] := (
           Sin[((150 Pi) $CellContext`\[Xi])/$CellContext`\[Lambda]]/(((150 
             Pi) $CellContext`\[Xi])/$CellContext`\[Lambda]))^2 
         Cos[(((300 
               Pi) $CellContext`d)/$CellContext`\[Lambda]) \
$CellContext`\[Xi]]^2}; Typeset`initDone$$ = True); ReleaseHold[
       HoldComplete[{$CellContext`g1[
           Pattern[$CellContext`d, 
            Blank[]]] := Graphics3D[{Gray, 
            Specularity[Gray, 10], 
            Cylinder[{{0, 0, 0}, {2, 0, 0}}, 0.5], Black, 
            
            Polygon[{{5, -1.5, -0.75}, {5, 1.5, -0.75}, {5, 1.5, 0.75}, {
              5, -1.5, 0.75}, {5, -1.5, -0.75}}], 
            
            Line[{{10, -3, -1.5}, {10, 3, -1.5}, {10, 3, 1.5}, {
              10, -3, 1.5}, {10, -3, -1.5}}], Thick, White, 
            
            Line[{{5, (-$CellContext`d)/2, -0.65}, {
              5, (-$CellContext`d)/2, 0.65}}], 
            
            Line[{{5, $CellContext`d/2, -0.65}, {
              5, $CellContext`d/2, 0.65}}]}, Boxed -> False, 
           ViewPoint -> {-5, -2.5, 2.5}], $CellContext`f[
           Pattern[$CellContext`d, 
            Blank[]], 
           Pattern[$CellContext`\[Lambda], 
            Blank[]], 
           Pattern[$CellContext`\[Xi], 
            Blank[]]] := (
            Sin[150 Pi $CellContext`\[Xi]/$CellContext`\[Lambda]]/(150 
            Pi $CellContext`\[Xi]/$CellContext`\[Lambda]))^2 
          Cos[(300 
              Pi $CellContext`d/$CellContext`\[Lambda]) \
$CellContext`\[Xi]]^2, $CellContext`g2[
           Pattern[$CellContext`d, 
            Blank[]], 
           Pattern[$CellContext`\[Lambda], 
            Blank[]], 
           Pattern[$CellContext`n, 
            Blank[]]] := Graphics3D[{
            ColorData["VisibleSpectrum"][$CellContext`\[Lambda]], 
            Point[
             
             Map[{10, Re[#] 
               Boole[$CellContext`f[$CellContext`d, $CellContext`\[Lambda], 
                   Re[#]] >= Im[#]], (
                3 Im[#]/$CellContext`f[$CellContext`d, $CellContext`\[Lambda],
                   
                  Re[#]] - 1.5) 
               Boole[$CellContext`f[$CellContext`d, $CellContext`\[Lambda], 
                   Re[#]] >= Im[#]]}& , 
              RandomComplex[{-3, 3 + I}, $CellContext`n]]], White, 
            Point[{10, 0, 0}]}]}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->106689423],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Wave-Particle Duality in the Double-Slit Experiment",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
WaveParticleDualityInTheDoubleSlitExperiment/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
WaveParticleDualityInTheDoubleSlitExperiment/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
WaveParticleDualityInTheDoubleSlitExperiment/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
WaveParticleDualityInTheDoubleSlitExperiment/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
WaveParticleDualityInTheDoubleSlitExperiment/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["S. M. Blinder",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=S.+M.+Blinder"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=S.+M.+Blinder"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->713761910],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
WaveParticleDualityInTheDoubleSlitExperiment"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Wave-Particle Duality in the Double-Slit Experiment - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 243, 4, 70, "Section"],
Cell[836, 29, 3787, 100, 70, "Input",
 CellID->1897874382],
Cell[4626, 131, 1571, 35, 70, "Input",
 CellID->1400038656],
Cell[6200, 168, 3480, 74, 70, "Input",
 CellID->1000129383],
Cell[9683, 244, 4541, 81, 70, "Input"]
}, Open  ]],
Cell[14239, 328, 7082, 156, 70, "Output",
 CellID->106689423],
Cell[CellGroupData[{
Cell[21346, 488, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[21722, 499, 1066, 31, 70, "Text"],
Cell[22791, 532, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[23131, 543, 456, 15, 70, "Text",
 CellID->713761910],
Cell[CellGroupData[{
Cell[23612, 562, 829, 24, 70, "Text"],
Cell[24444, 588, 1220, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 8TzSp0wfm90qgAT@kednOuqO *)
