(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24470,        584]
NotebookOptionsPosition[     23268,        537]
NotebookOutlinePosition[     23907,        562]
CellTagsIndexPosition[     23864,        559]
WindowTitle->Wave Interference - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Wave Interference", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DensityPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"q1", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"f", " ", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], "-", "xy1"}], "]"}]}], "-", 
          "p"}], "]"}]}], "+", 
       RowBox[{"q2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"f", " ", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], "-", "xy2"}], "]"}]}], "-", 
          "p"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"420", ",", "420"}], "}"}]}], ",", 
      RowBox[{"MeshFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"#3", "&"}], "}"}]}], ",", 
      RowBox[{"Mesh", "\[Rule]", 
       RowBox[{"If", "[", 
        RowBox[{"ms", ",", "10", ",", "None"}], "]"}]}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "None"}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", 
       RowBox[{"If", "[", 
        RowBox[{"hq", ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"7", "f"}], "+", "5"}], "]"}], ",", 
         RowBox[{"Round", "[", 
          RowBox[{
           RowBox[{"3", "f"}], "+", "5"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Blend", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"White", ",", 
             RowBox[{"RGBColor", "[", 
              RowBox[{".13", ",", " ", ".35", ",", " ", ".9"}], "]"}]}], 
            "}"}], ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xy1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
        "\"\<position of source 1\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", 
        RowBox[{"-", "5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}], ",", 
      RowBox[{"ControlType", "\[Rule]", "Locator"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "10", ",", "\"\<amplitude of source 1\>\""}], "}"}],
       ",", 
      RowBox[{"-", "10"}], ",", "10", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xy2", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}], ",", 
        "\"\<position of source 2\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", 
        RowBox[{"-", "5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}], ",", 
      RowBox[{"ControlType", "\[Rule]", "Locator"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q2", ",", "10", ",", "\"\<amplitude of source 2\>\""}], "}"}],
       ",", 
      RowBox[{"-", "10"}], ",", "10", ",", "1"}], "}"}], ",", "Delimiter", 
    ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "6", ",", "\"\<frequency\>\""}], "}"}], ",", "1", 
      ",", "15"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "1", ",", "\"\<phase\>\""}], "}"}], ",", "1", ",", 
      RowBox[{"12", " ", "Pi"}]}], "}"}], ",", "Delimiter", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"hq", ",", "False", ",", "\"\<high quality\>\""}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ms", ",", "False", ",", "\"\<show mesh\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}], ",", 
      RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
    RowBox[{"AutorunSequencing", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
      "xy1", ",", "xy2", ",", "q1", ",", "q2", ",", "p", ",", "f", ",", 
       "hq"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.380907341086568*^9, 3.38090748139537*^9}, {
   3.38090756265047*^9, 3.3809075627502213`*^9}, {3.380907786371799*^9, 
   3.380907870025576*^9}, {3.380907919570438*^9, 3.380907939498704*^9}, {
   3.38090797114301*^9, 3.3809079907337027`*^9}, {3.380908021327758*^9, 
   3.38090803907238*^9}, {3.380908074935902*^9, 3.38090814797991*^9}, {
   3.380908389331835*^9, 3.380908389433462*^9}, {3.380908422428919*^9, 
   3.380908436872079*^9}, {3.380908487846987*^9, 3.380908553454693*^9}, {
   3.3809085905416603`*^9, 3.380908593287902*^9}, {3.380908721822937*^9, 
   3.380908724116221*^9}, {3.380908764198208*^9, 3.3809087675417747`*^9}, {
   3.38090883341031*^9, 3.3809088339521837`*^9}, {3.380909067689954*^9, 
   3.3809090902322273`*^9}, {3.380909145724337*^9, 3.380909145970292*^9}, {
   3.3809091808062572`*^9, 3.380909199870694*^9}, {3.380909233591961*^9, 
   3.380909235910335*^9}, {3.380909304709991*^9, 3.3809093340166283`*^9}, {
   3.380909375980818*^9, 3.3809093787647247`*^9}, 3.380909420054071*^9, {
   3.380909457287425*^9, 3.380909457468811*^9}, {3.38090949656102*^9, 
   3.380909499334138*^9}, {3.380909541586241*^9, 3.3809095488799467`*^9}, {
   3.380909604732332*^9, 3.380909616452251*^9}, {3.380909863955942*^9, 
   3.3809098844238987`*^9}, {3.380909994290578*^9, 3.3809100181073*^9}, {
   3.380910188742209*^9, 3.3809102044802*^9}, {3.380922937114398*^9, 
   3.38092293733722*^9}, {3.381062138843257*^9, 3.3810622363996677`*^9}, {
   3.381062328445159*^9, 3.381062345123333*^9}, {3.381062375972487*^9, 
   3.381062392231194*^9}, {3.381062448060161*^9, 3.3810624555981283`*^9}, 
   3.381062514399189*^9, {3.384180443436604*^9, 3.384180444005945*^9}, {
   3.384180531263579*^9, 3.384180537664674*^9}, {3.384180674996481*^9, 
   3.3841806852197647`*^9}, {3.3841807196725388`*^9, 3.384180720054081*^9}, {
   3.384180893861569*^9, 3.384180913791469*^9}, {3.384180956360766*^9, 
   3.384180957584746*^9}, {3.3841809991359367`*^9, 3.384181039058199*^9}, {
   3.384181116663507*^9, 3.384181196415434*^9}, 3.384181318757866*^9, {
   3.3841813572311993`*^9, 3.384181381052845*^9}, {3.384181443035988*^9, 
   3.384181483162878*^9}, 3.384181530789508*^9, {3.384181572471706*^9, 
   3.384181587263533*^9}, {3.3841816273614273`*^9, 3.384181645966403*^9}, {
   3.384181790775744*^9, 3.384181814871141*^9}, {3.384181862696917*^9, 
   3.384181878265201*^9}, {3.3841820745488243`*^9, 3.384182086753477*^9}, {
   3.3841821255768633`*^9, 3.3841821327906322`*^9}, {3.384182179121731*^9, 
   3.384182209760433*^9}, {3.384182371240859*^9, 3.3841824627312202`*^9}, {
   3.384182502150775*^9, 3.3841825159628477`*^9}, {3.38418255617493*^9, 
   3.384182590925506*^9}, {3.3841828153238*^9, 3.384182838173799*^9}, {
   3.3841832393502073`*^9, 3.384183260818729*^9}, {3.384184621431025*^9, 
   3.384184668509447*^9}, {3.3841847042120543`*^9, 3.384184722523581*^9}, {
   3.384201165044879*^9, 3.384201165224078*^9}, {3.384202898356147*^9, 
   3.384202905361714*^9}, {3.3842030027004957`*^9, 3.3842030098729973`*^9}, {
   3.384203075300243*^9, 3.384203085344846*^9}, 3.384203116366102*^9, {
   3.384203179585126*^9, 3.384203191668256*^9}, {3.384536238279578*^9, 
   3.384536325882131*^9}, {3.385916657896512*^9, 3.385916703795953*^9}, {
   3.385916739449897*^9, 3.385916742789319*^9}, {3.385916782699218*^9, 
   3.385916784772792*^9}, {3.3859169756611977`*^9, 3.385916990459674*^9}, {
   3.386006531624268*^9, 3.3860065354011793`*^9}, {3.3860066055112057`*^9, 
   3.386006654837247*^9}, {3.386006697470676*^9, 3.386006761794723*^9}, {
   3.386006798890115*^9, 3.386006848209359*^9}, {3.3860069145596447`*^9, 
   3.386006933451767*^9}, {3.386007150086051*^9, 3.386007186001193*^9}, 
   3.38600732386242*^9, {3.386007620360454*^9, 3.386007653484775*^9}, {
   3.3861149414215345`*^9, 3.3861149485153294`*^9}, {3.38611522590773*^9, 
   3.386115255048541*^9}, {3.3865344380435247`*^9, 3.386534536042276*^9}, {
   3.386534835873722*^9, 3.386534853786436*^9}, {3.386534922580612*^9, 
   3.3865350400378304`*^9}, {3.386535084171857*^9, 3.386535086167289*^9}, 
   3.3865352119907207`*^9, {3.3865352702915993`*^9, 3.3865352724600143`*^9}, 
   3.386535324134365*^9, {3.386535365622674*^9, 3.3865353857959137`*^9}, {
   3.3865355611038027`*^9, 3.3865355664708223`*^9}, {3.3891367865440607`*^9, 
   3.38913679879598*^9}, {3.3891368599683523`*^9, 3.389136911647235*^9}, 
   3.389136974424756*^9},
 CellID->1886719048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = 6, $CellContext`hq$$ = 
    False, $CellContext`ms$$ = False, $CellContext`p$$ = 
    1, $CellContext`q1$$ = 10, $CellContext`q2$$ = 
    10, $CellContext`xy1$$ = {-3, 0}, $CellContext`xy2$$ = {3, 0}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`xy1$$], {-3, 0}, "position of source 1"}, {-5, -5}, {
      5, 5}}, {{
       Hold[$CellContext`q1$$], 10, "amplitude of source 1"}, -10, 10, 1}, {{
       Hold[$CellContext`xy2$$], {3, 0}, "position of source 2"}, {-5, -5}, {
      5, 5}}, {{
       Hold[$CellContext`q2$$], 10, "amplitude of source 2"}, -10, 10, 1}, {{
       Hold[$CellContext`f$$], 6, "frequency"}, 1, 15}, {{
       Hold[$CellContext`p$$], 1, "phase"}, 1, 12 Pi}, {{
       Hold[$CellContext`hq$$], False, "high quality"}, {True, False}}, {{
       Hold[$CellContext`ms$$], False, "show mesh"}, {True, False}}}, 
    Typeset`size$$ = {420., {208., 212.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`xy1$16389$$ = {0, 0}, $CellContext`q1$16390$$ = 
    0, $CellContext`xy2$16391$$ = {0, 0}, $CellContext`q2$16392$$ = 
    0, $CellContext`f$16393$$ = 0, $CellContext`p$16394$$ = 
    0, $CellContext`hq$16395$$ = False, $CellContext`ms$16396$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`f$$ = 6, $CellContext`hq$$ = 
        False, $CellContext`ms$$ = False, $CellContext`p$$ = 
        1, $CellContext`q1$$ = 10, $CellContext`q2$$ = 
        10, $CellContext`xy1$$ = {-3, 0}, $CellContext`xy2$$ = {3, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`xy1$$, $CellContext`xy1$16389$$, {0, 0}], 
        Hold[$CellContext`q1$$, $CellContext`q1$16390$$, 0], 
        Hold[$CellContext`xy2$$, $CellContext`xy2$16391$$, {0, 0}], 
        Hold[$CellContext`q2$$, $CellContext`q2$16392$$, 0], 
        Hold[$CellContext`f$$, $CellContext`f$16393$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$16394$$, 0], 
        Hold[$CellContext`hq$$, $CellContext`hq$16395$$, False], 
        Hold[$CellContext`ms$$, $CellContext`ms$16396$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      DensityPlot[$CellContext`q1$$ 
         Cos[$CellContext`f$$ 
            Norm[{$CellContext`x, $CellContext`y} - $CellContext`xy1$$] - \
$CellContext`p$$] + $CellContext`q2$$ 
         Cos[$CellContext`f$$ 
            Norm[{$CellContext`x, $CellContext`y} - $CellContext`xy2$$] - \
$CellContext`p$$], {$CellContext`x, -5, 5}, {$CellContext`y, -5, 5}, 
        ImageSize -> {420, 420}, MeshFunctions -> {#3& }, Mesh -> 
        If[$CellContext`ms$$, 10, None], ImagePadding -> None, ImageMargins -> 
        None, PlotRangePadding -> None, Frame -> False, PlotPoints -> 
        If[$CellContext`hq$$, 
          Round[7 $CellContext`f$$ + 5], 
          Round[3 $CellContext`f$$ + 5]], MaxRecursion -> 1, PlotRange -> All,
         ColorFunction -> (Blend[{White, 
           RGBColor[0.13, 0.35, 0.9]}, #]& )], 
      "Specifications" :> {{{$CellContext`xy1$$, {-3, 0}, 
          "position of source 1"}, {-5, -5}, {5, 5}, ControlType -> 
         Locator}, {{$CellContext`q1$$, 10, "amplitude of source 1"}, -10, 10,
          1}, {{$CellContext`xy2$$, {3, 0}, 
          "position of source 2"}, {-5, -5}, {5, 5}, ControlType -> 
         Locator}, {{$CellContext`q2$$, 10, "amplitude of source 2"}, -10, 10,
          1}, Delimiter, {{$CellContext`f$$, 6, "frequency"}, 1, 
         15}, {{$CellContext`p$$, 1, "phase"}, 1, 12 Pi}, 
        Delimiter, {{$CellContext`hq$$, False, "high quality"}, {True, False},
          ControlPlacement -> 
         Left}, {{$CellContext`ms$$, False, "show mesh"}, {True, False}, 
         ControlPlacement -> Left}}, 
      "Options" :> {
       AutorunSequencing -> {{1, 8}, {3, 8}, {4, 4}, {5, 8}, {6, 6}, {7, 4}}, 
        TrackedSymbols :> {$CellContext`xy1$$, $CellContext`xy2$$, \
$CellContext`q1$$, $CellContext`q2$$, $CellContext`p$$, $CellContext`f$$, \
$CellContext`hq$$}}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{547., {309., 314.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->682345409],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["Interference patterns made by waves from two sources.", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Wave Interference",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/WaveInterference/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/WaveInterference/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/WaveInterference/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/WaveInterference/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/WaveInterference/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Stephen Wolfram",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stephen+\
Wolfram"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stephen+Wolfram"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->139300377],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
WaveInterference"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{747, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Wave Interference - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[619, 23, 137, 3, 70, "Section"],
Cell[759, 28, 3700, 64, 70, "Section"],
Cell[4462, 94, 9764, 213, 70, "Input",
 CellID->1886719048]
}, Open  ]],
Cell[CellGroupData[{
Cell[14263, 312, 4898, 88, 70, "Output",
 CellID->682345409],
Cell[CellGroupData[{
Cell[19186, 404, 209, 6, 70, "Section"],
Cell[19398, 412, 69, 0, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19515, 418, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[19873, 429, 874, 24, 70, "Text"],
Cell[20750, 455, 459, 15, 70, "Text",
 CellID->139300377],
Cell[CellGroupData[{
Cell[21234, 474, 815, 24, 70, "Text"],
Cell[22052, 500, 1188, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ES4KaTe3TMeGWCTbeXWjXE0E *)
