(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26827,        671]
NotebookOptionsPosition[     25648,        626]
NotebookOutlinePosition[     26301,        651]
CellTagsIndexPosition[     26258,        648]
WindowTitle->Superposition of Standing Waves - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Superposition of Standing Waves", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"coeff", "=", 
     RowBox[{"{", 
      RowBox[{
      "c1", ",", "c2", ",", "c3", ",", "c4", ",", "c5", ",", "c6", ",", "c7", 
       ",", "c8", ",", "c9", ",", "c10"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fun", "[", 
      RowBox[{"xp_", ",", "tp_"}], "]"}], "=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"coeff", "[", 
         RowBox[{"[", "j", "]"}], "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"j", " ", "\[Pi]", " ", "tp"}], "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"j", " ", "\[Pi]", " ", "xp"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "10"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fun", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Red"}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<x\>\"", ",", "16", ",", "Italic"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<\[Psi](\>\"", ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<x\>\"", ",", "Italic"}], "]"}], ",", 
              RowBox[{"\"\<,\>\"", 
               RowBox[{"Style", "[", 
                RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}]}], ",", 
              "\"\<)\>\""}], "}"}], "]"}], ",", "16"}], "]"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", ".75"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", ".5", ",", "1"}], "}"}], ",", "None"}], "}"}]}],
         "}"}]}], ",", 
      RowBox[{"FrameTicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Gray", ",", "16"}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "300"}], "}"}]}], ",", 
      RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}]}], 
   ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<coefficients\>\"", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c1", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(1\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c2", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(2\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c3", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(3\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c4", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(4\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c5", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(5\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c6", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(6\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c7", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(7\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c8", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(8\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c9", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(9\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "c10", ",", "0", ",", "\"\<\!\(\*SubscriptBox[\(c\), \(10\)]\)\>\""}], 
      "}"}], ",", "0", ",", ".3", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "\"\<time\>\""}], "}"}], ",", "0.", ",", 
     "5.", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[Rule]", "True"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.466719282787856*^9, 3.466719285519281*^9}, {
   3.466719409290009*^9, 3.466719468933488*^9}, {3.466792695929295*^9, 
   3.466792697620824*^9}, {3.4667927370981627`*^9, 3.4667930204511766`*^9}, {
   3.4667932529224358`*^9, 3.4667933249865437`*^9}, {3.466794587727044*^9, 
   3.4667946742196302`*^9}, {3.46679499303929*^9, 3.466795006790722*^9}, 
   3.4667950916608467`*^9, {3.466795122920178*^9, 3.466795204233773*^9}, {
   3.466795421162622*^9, 3.466795421283545*^9}, {3.4678186144664497`*^9, 
   3.467818671055608*^9}, {3.467818704086856*^9, 3.4678187208794937`*^9}, {
   3.467818757059414*^9, 3.467818757637206*^9}, {3.4678187963267717`*^9, 
   3.4678188212911386`*^9}, {3.467818947979733*^9, 3.467819001285945*^9}, {
   3.467819083382009*^9, 3.4678191117714243`*^9}, {3.46781915108575*^9, 
   3.467819179622106*^9}, {3.467819243921096*^9, 3.467819337572941*^9}, {
   3.4678194300075274`*^9, 3.467819443294585*^9}, {3.4678194977991543`*^9, 
   3.467819571428157*^9}, 3.467852371773156*^9, {3.467854415463559*^9, 
   3.467854460969458*^9}, 3.467854512765819*^9, {3.4679308680057487`*^9, 
   3.467930873755109*^9}, {3.467931021613549*^9, 3.467931064418503*^9}, {
   3.467931104349698*^9, 3.467931168923399*^9}, {3.467931897483493*^9, 
   3.4679318991176453`*^9}, 3.467933721751286*^9, {3.467933961543125*^9, 
   3.46793396290592*^9}, {3.468072176052781*^9, 3.4680723387820525`*^9}, {
   3.4684207347503986`*^9, 3.4684208211404705`*^9}, {3.468420896108741*^9, 
   3.4684209403897076`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = 0, $CellContext`c10$$ = 
    0, $CellContext`c2$$ = 0, $CellContext`c3$$ = 0, $CellContext`c4$$ = 
    0, $CellContext`c5$$ = 0, $CellContext`c6$$ = 0, $CellContext`c7$$ = 
    0, $CellContext`c8$$ = 0, $CellContext`c9$$ = 0, $CellContext`t$$ = 0., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["coefficients", Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`c1$$], 0, "\!\(\*SubscriptBox[\(c\), \(1\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c2$$], 0, "\!\(\*SubscriptBox[\(c\), \(2\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c3$$], 0, "\!\(\*SubscriptBox[\(c\), \(3\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c4$$], 0, "\!\(\*SubscriptBox[\(c\), \(4\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c5$$], 0, "\!\(\*SubscriptBox[\(c\), \(5\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c6$$], 0, "\!\(\*SubscriptBox[\(c\), \(6\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c7$$], 0, "\!\(\*SubscriptBox[\(c\), \(7\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c8$$], 0, "\!\(\*SubscriptBox[\(c\), \(8\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c9$$], 0, "\!\(\*SubscriptBox[\(c\), \(9\)]\)"}, 0, 
      0.3, 0.01}, {{
       Hold[$CellContext`c10$$], 0, "\!\(\*SubscriptBox[\(c\), \(10\)]\)"}, 0,
       0.3, 0.01}, {{
       Hold[$CellContext`t$$], 0., "time"}, 0., 5., 0.01}}, Typeset`size$$ = {
    400., {148., 152.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`c1$110$$ = 
    0, $CellContext`c2$115$$ = 0, $CellContext`c3$116$$ = 
    0, $CellContext`c4$117$$ = 0, $CellContext`c5$118$$ = 
    0, $CellContext`c6$119$$ = 0, $CellContext`c7$120$$ = 
    0, $CellContext`c8$121$$ = 0, $CellContext`c9$122$$ = 
    0, $CellContext`c10$123$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = 0, $CellContext`c10$$ = 
        0, $CellContext`c2$$ = 0, $CellContext`c3$$ = 0, $CellContext`c4$$ = 
        0, $CellContext`c5$$ = 0, $CellContext`c6$$ = 0, $CellContext`c7$$ = 
        0, $CellContext`c8$$ = 0, $CellContext`c9$$ = 0, $CellContext`t$$ = 
        0.}, "ControllerVariables" :> {
        Hold[$CellContext`c1$$, $CellContext`c1$110$$, 0], 
        Hold[$CellContext`c2$$, $CellContext`c2$115$$, 0], 
        Hold[$CellContext`c3$$, $CellContext`c3$116$$, 0], 
        Hold[$CellContext`c4$$, $CellContext`c4$117$$, 0], 
        Hold[$CellContext`c5$$, $CellContext`c5$118$$, 0], 
        Hold[$CellContext`c6$$, $CellContext`c6$119$$, 0], 
        Hold[$CellContext`c7$$, $CellContext`c7$120$$, 0], 
        Hold[$CellContext`c8$$, $CellContext`c8$121$$, 0], 
        Hold[$CellContext`c9$$, $CellContext`c9$122$$, 0], 
        Hold[$CellContext`c10$$, $CellContext`c10$123$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`coeff = {$CellContext`c1$$, $CellContext`c2$$, \
$CellContext`c3$$, $CellContext`c4$$, $CellContext`c5$$, $CellContext`c6$$, \
$CellContext`c7$$, $CellContext`c8$$, $CellContext`c9$$, $CellContext`c10$$}; \
$CellContext`fun[
          Pattern[$CellContext`xp, 
           Blank[]], 
          Pattern[$CellContext`tp, 
           Blank[]]] = 
        Sum[(Part[$CellContext`coeff, $CellContext`j] 
           Cos[($CellContext`j Pi) $CellContext`tp]) 
          Sin[($CellContext`j Pi) $CellContext`xp], {$CellContext`j, 10}]; 
       Plot[
         $CellContext`fun[$CellContext`x, $CellContext`t$$], {$CellContext`x, 
          0, 1}, PlotStyle -> {
           Thickness[0.007], Red}, Frame -> True, FrameLabel -> {
           Style["x", 16, Italic], 
           Style[
            Row[{"\[Psi](", 
              Style["x", Italic], "," Style["t", Italic], ")"}], 16]}, 
         AspectRatio -> 0.75, PlotRange -> {{0, 1}, {-1.2, 1.2}}, 
         FrameTicks -> {{None, {-0.5, 0.5}}, {{0, 0.5, 1}, None}}, 
         FrameTicksStyle -> Directive[Gray, 16], ImageSize -> {400, 300}, 
         PerformanceGoal -> "Quality"]), "Specifications" :> {
        Style[
        "coefficients", 
         Bold], {{$CellContext`c1$$, 0, "\!\(\*SubscriptBox[\(c\), \(1\)]\)"},
          0, 0.3, 0.01, ImageSize -> Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c2$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(2\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c3$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(3\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c4$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(4\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c5$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(5\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c6$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(6\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c7$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(7\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c8$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(8\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c9$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(9\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> 
         "Labeled"}, {{$CellContext`c10$$, 0, 
          "\!\(\*SubscriptBox[\(c\), \(10\)]\)"}, 0, 0.3, 0.01, ImageSize -> 
         Tiny, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`t$$, 0., "time"}, 0., 5., 0.01, ImageSize -> 
         Tiny}}, "Options" :> {
       TrackedSymbols -> True, ControlPlacement -> Left, 
        AutorunSequencing -> {1, 3, 5, 7, 9}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{592., {176., 181.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->676671752],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration shows a linear superposition of 10 standing waves, of \
the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Psi]", "(", 
     RowBox[{"x", ",", "t"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "1"}], "10"], 
     RowBox[{
      SubscriptBox["c", "n"], 
      RowBox[{"cos", "(", 
       RowBox[{"n", " ", "\[Pi]", " ", 
        SubscriptBox["\[Omega]", "0"], "t"}], ")"}], 
      RowBox[{"sin", "(", 
       FractionBox[
        RowBox[{"n", " ", "\[Pi]", " ", "x"}], "L"], ")"}], " "}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". The box is of unit length and each standing wave has its endpoints fixed \
at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "L"}], TraditionalForm]], "InlineMath"],
 ". The coefficients ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], ",", " ", 
    SubscriptBox["c", "2"], ",", " ", "\[Ellipsis]", " ", ",", " ", 
    SubscriptBox["c", "10"]}], TraditionalForm]], "InlineMath"],
 " can be selected."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Superposition of Standing Waves",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SuperpositionOfStandingWaves/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SuperpositionOfStandingWaves/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/SuperpositionOfStandingWaves/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/SuperpositionOfStandingWaves/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/SuperpositionOfStandingWaves/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Porscha McRobbie",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Porscha+\
McRobbie"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Porscha+McRobbie"],
 " and ",
 ButtonBox["Eitan Geva",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Eitan+Geva"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Eitan+Geva"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
SuperpositionOfStandingWaves"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Superposition of Standing Waves - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[633, 23, 151, 3, 70, "Section"],
Cell[787, 28, 3700, 64, 70, "Section"],
Cell[4490, 94, 8817, 211, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13344, 310, 6767, 131, 70, "Output",
 CellID->676671752],
Cell[CellGroupData[{
Cell[20136, 445, 209, 6, 70, "Section"],
Cell[20348, 453, 1161, 37, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21557, 496, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[21915, 507, 966, 28, 70, "Text"],
Cell[22884, 537, 693, 22, 70, "Text"],
Cell[CellGroupData[{
Cell[23602, 563, 815, 24, 70, "Text"],
Cell[24420, 589, 1200, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 0SzQeGaf1CsFjBpO36NgrcDi *)
