(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     22113,        612]
NotebookOptionsPosition[     20515,        555]
NotebookOutlinePosition[     21170,        580]
CellTagsIndexPosition[     21127,        577]
WindowTitle->Multiple Slit Diffraction Pattern - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Multiple Slit Diffraction Pattern", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "n"}], ")"}], 
          RowBox[{"ChebyshevU", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"b", " ", 
              RowBox[{"k", "/", "2"}]}], "]"}]}], "]"}], 
          RowBox[{"Sinc", "[", 
           RowBox[{"a", " ", 
            RowBox[{"k", "/", "2"}]}], "]"}]}], ")"}], "^", "2"}], ",", 
       RowBox[{
        RowBox[{"Sinc", "[", 
         RowBox[{"a", " ", 
          RowBox[{"k", "/", "2"}]}], "]"}], "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "kmax"}], ",", "kmax"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<position\>\"", ",", "\"\<intensity\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{
       RowBox[{"ToString", "[", "n", "]"}], "<>", 
       "\"\< slit diffraction pattern\>\""}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Filling", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "350"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"40", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"40", ",", "20"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0.5", ",", "\"\<slit width\>\""}], "}"}], ",", "0", 
     ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "2.5", ",", "\"\<slit spacing\>\""}], "}"}], ",", "1",
      ",", "5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "2", ",", "\"\<number of slits\>\""}], "}"}], ",", 
     RowBox[{"Range", "[", "10", "]"}], ",", "SetterBar"}], "}"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kmax", ",", "10", ",", "\"\<horizontal range\>\""}], "}"}], 
     ",", "1", ",", "100", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.444695859026884*^9, {3.444696299781196*^9, 
   3.444696341694256*^9}, {3.444696401996207*^9, 3.444696402959168*^9}, {
   3.444696509207447*^9, 3.444696597511465*^9}, {3.444752502538575*^9, 
   3.4447525323925605`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.5, $CellContext`b$$ = 
    2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 0.5, "slit width"}, 0, 1}, {{
       Hold[$CellContext`b$$], 2.5, "slit spacing"}, 1, 5}, {{
       Hold[$CellContext`n$$], 2, "number of slits"}, {1, 2, 3, 4, 5, 6, 7, 8,
       9, 10}}, {{
       Hold[$CellContext`kmax$$], 10, "horizontal range"}, 1, 100}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$31849$$ = 0, $CellContext`b$31850$$ = 
    0, $CellContext`n$31851$$ = 0, $CellContext`kmax$31852$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.5, $CellContext`b$$ = 
        2.5, $CellContext`kmax$$ = 10, $CellContext`n$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$31849$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$31850$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$31851$$, 0], 
        Hold[$CellContext`kmax$$, $CellContext`kmax$31852$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{(((1/$CellContext`n$$) ChebyshevU[$CellContext`n$$ - 1, 
             Cos[$CellContext`b$$ ($CellContext`k/2)]]) 
          Sinc[$CellContext`a$$ ($CellContext`k/2)])^2, 
         Sinc[$CellContext`a$$ ($CellContext`k/
            2)]^2}, {$CellContext`k, -$CellContext`kmax$$, \
$CellContext`kmax$$}, PlotRange -> {0, 1}, Axes -> False, Frame -> True, 
        FrameTicks -> {True, False}, FrameLabel -> {"position", "intensity"}, 
        PlotLabel -> StringJoin[
          ToString[$CellContext`n$$], " slit diffraction pattern"], 
        Filling -> {1 -> Axis}, PlotStyle -> {Automatic, {Thick, Dashed}}, 
        ImageSize -> {500, 350}, ImagePadding -> {{40, 20}, {40, 20}}], 
      "Specifications" :> {{{$CellContext`a$$, 0.5, "slit width"}, 0, 1, 
         Appearance -> "Labeled"}, {{$CellContext`b$$, 2.5, "slit spacing"}, 
         1, 5, Appearance -> 
         "Labeled"}, {{$CellContext`n$$, 2, "number of slits"}, {1, 2, 3, 4, 
         5, 6, 7, 8, 9, 10}, ControlType -> SetterBar}, 
        Delimiter, {{$CellContext`kmax$$, 10, "horizontal range"}, 1, 100, 
         Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {264., 269.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->341469225],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "In this Demonstration we visualize the diffraction pattern of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " equally spaced slits of equal width, also known as a ",
 StyleBox["diffraction grating",
  FontSlant->"Italic"],
 ". It can be shown that the diffraction pattern is equivalent to the \
diffraction pattern for ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " delta function slits modulated by the diffraction pattern of a single slit \
of finite width. The latter thus acts as an envelope, shown by the thick \
dashed line. Special cases of this system include the single (",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "1"}], TraditionalForm]], "InlineMath"],
 ") and double (",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "2"}], TraditionalForm]], "InlineMath"],
 ") slits, which appear in introductory physics courses. The horizontal scale \
is arbitrary and the vertical scale normalized to the peak intensity."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "For an array of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " slits of width ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and equal spacing ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", the intensity of the diffracted light on a screen may be neatly expressed \
as"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["I", 
     SubscriptBox["I", "0"]], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "n"], 
       RowBox[{
        SubscriptBox["U", 
         RowBox[{"n", "-", "1"}]], "(", 
        RowBox[{"cos", "(", 
         FractionBox[
          RowBox[{"d", " ", "q"}], "2"], ")"}], ")"}], 
       RowBox[{"sinc", "(", 
        FractionBox[
         RowBox[{"a", " ", "q"}], "2"], ")"}]}], ")"}], "2"]}], 
   TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "0"], TraditionalForm]], "InlineMath"],
 " is the peak intensity and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the Chebyshev polynomial of the second kind, which appears when we \
simplify the ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sin", "(", 
     RowBox[{"n", " ", "x"}], ")"}], "/", 
    RowBox[{"sin", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " is a normalized wavenumber. It is related to the actual wavenumber ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ", the perpendicular distance ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " from the diffraction grating to the screen on which the pattern is \
observed, and the distance from the center of the pattern ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    FractionBox[
     RowBox[{"k", " ", "x"}], "R"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "The formula for the intensity is valid within the Fraunhofer diffraction \
regime, for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"R", "\[GreaterGreater]", "a"}], ",", "d"}], TraditionalForm]], 
  "InlineMath"],
 ". In this case, the diffraction pattern is equivalent to the Fourier \
transform of the diffraction grating. This explains why, since an array of \
finite-width slits is equivalent to the ",
 StyleBox["convolution",
  FontSlant->"Italic"],
 " of an array of delta function slits with a single slit, the resulting \
diffraction pattern is the ",
 StyleBox["product",
  FontSlant->"Italic"],
 " of the two corresponding diffraction patterns."
}], "Text"],

Cell["\<\
Snapshot 1: for a single, infinitely narrow slit, the diffraction pattern is \
constant; this is essentially because the Fourier transform of the delta \
function is constant\
\>", "Text"],

Cell["\<\
Snapshot 2: for multiple infinitely narrow slits, there is an infinitely \
repeating pattern of peaks and troughs, corresponding to \
constructive/destructive interference between paths from different slits\
\>", "Text"],

Cell["\<\
Snapshot 3: for a single slit of finite width, the diffraction pattern has \
the well-known form of a sinc function\
\>", "Text"],

Cell["\<\
Snapshot 4: for multiple slits of finite width, the diffraction is a pattern \
of peaks and troughs modulated by the sinc function pattern arising from the \
finite width of each slit\
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Multiple Slit Diffraction Pattern",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/MultipleSlitDiffractionPattern/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/MultipleSlitDiffractionPattern/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/MultipleSlitDiffractionPattern/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/MultipleSlitDiffractionPattern/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/MultipleSlitDiffractionPattern/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Peter Falloon",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Peter+Falloon"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Peter+Falloon"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MultipleSlitDiffractionPattern"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Multiple Slit Diffraction Pattern - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[635, 23, 153, 3, 70, "Section"],
Cell[791, 28, 3700, 64, 70, "Section"],
Cell[4494, 94, 3689, 97, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8220, 196, 3237, 60, 70, "Output",
 CellID->341469225],
Cell[CellGroupData[{
Cell[11482, 260, 209, 6, 70, "Section"],
Cell[11694, 268, 1003, 23, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12745, 297, 209, 6, 70, "Section"],
Cell[12957, 305, 369, 12, 70, "Text"],
Cell[13329, 319, 556, 21, 70, "Text"],
Cell[13888, 342, 557, 20, 70, "Text"],
Cell[14448, 364, 694, 21, 70, "Text"],
Cell[15145, 387, 700, 18, 70, "Text"],
Cell[15848, 407, 198, 4, 70, "Text"],
Cell[16049, 413, 230, 4, 70, "Text"],
Cell[16282, 419, 139, 3, 70, "Text"],
Cell[16424, 424, 207, 4, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[16667, 433, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[17025, 444, 978, 28, 70, "Text"],
Cell[18006, 474, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[18467, 492, 815, 24, 70, "Text"],
Cell[19285, 518, 1202, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature oS4sWs0lcWbjCD0@9S254tf@ *)
