(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26200,        676]
NotebookOptionsPosition[     24784,        622]
NotebookOutlinePosition[     25435,        647]
CellTagsIndexPosition[     25392,        644]
WindowTitle->Beat Frequency of Sound Waves - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Beat Frequency of Sound Waves", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"c", ">", 
       RowBox[{"range", "-", 
        RowBox[{"1", "/", "100"}]}]}], ",", 
      RowBox[{"c", "=", 
       RowBox[{"range", "-", 
        RowBox[{"1", "/", "100"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Column", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "-", 
                 FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
               "t"}], "]"}], "+", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
               "t"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "range"}], "}"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", 
             RowBox[{"1", "/", "3"}]}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"375", ",", "125"}], "}"}]}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2.2"}], ",", "2.2"}], "}"}]}], ",", 
            RowBox[{"Axes", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"{", "2.2", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "c", ",", 
              RowBox[{"c", "+", 
               RowBox[{"1", "/", "100"}]}]}], "}"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", 
             RowBox[{"1", "/", "3"}]}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"375", ",", "125"}], "}"}]}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2.2"}], ",", "2.2"}], "}"}]}], ",", 
            RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
            RowBox[{"Axes", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", "Transparent"}], ",", 
            RowBox[{"FillingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Opacity", "[", 
               RowBox[{"0.4", ",", "Red"}], "]"}], "}"}]}]}], "]"}]}], "]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"a", "-", 
                  FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
                "t"}], "]"}], "+", 
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
                "t"}], "]"}]}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "-", 
                 FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
               "t"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 FractionBox["b", "2"]}], ")"}], "2", " ", "\[Pi]", " ", 
               "t"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "c", ",", 
             RowBox[{"c", "+", 
              RowBox[{"1", "/", "100"}]}]}], "}"}], ",", 
           RowBox[{"AspectRatio", "\[Rule]", 
            RowBox[{"1", "/", "3"}]}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"375", ",", "125"}], "}"}]}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2.2"}], ",", "2.2"}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dashed", ",", "Dashed"}], "}"}]}], ",", 
           RowBox[{"Axes", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", ",", "Center"}], 
     "]"}]}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "1", ",", "\"\<upper view\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "16"}], "\[Rule]", "\"\<narrow\>\""}], ",", 
       RowBox[{
        RowBox[{"1", "/", "4"}], "\[Rule]", "\"\<medium\>\""}], ",", 
       RowBox[{"1", "\[Rule]", "\"\<wide\>\""}], ",", 
       RowBox[{"4", "\[Rule]", "\"\<really wide\>\""}]}], "}"}]}], "}"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "0.58014`", ",", "\"\<zoomed view\>\""}], "}"}], ",", 
     "0", ",", 
     RowBox[{"range", "-", 
      RowBox[{"1", "/", "100"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "320", ",", "\"\<mean frequency (Hz)\>\""}], "}"}], 
     ",", "220", ",", "5000", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "3", ",", "\"\<difference in frequencies (Hz)\>\""}], 
      "}"}], ",", 
     RowBox[{"-", "20"}], ",", "20", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<play tones\>\"", ",", 
     RowBox[{"EmitSound", "[", 
      RowBox[{"Sound", "[", 
       RowBox[{"Play", "[", 
        RowBox[{
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "-", 
               RowBox[{"b", "/", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"2", " ", "\[Pi]", " ", "t"}], ")"}]}], "]"}], ",", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "/", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"2", " ", "\[Pi]", " ", "t"}], ")"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "time"}], "}"}], ",", 
         RowBox[{"SampleRate", "\[Rule]", "6000"}]}], "]"}], "]"}], "]"}], 
     ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<FramedPalette\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "168"}], ",", 
     RowBox[{"ImageMargins", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"135", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"time", ",", "4", ",", "\"\<play time (s)\>\""}], "}"}], ",", 
     "2", ",", "20", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", "Bottom"}]}], "\[IndentingNewLine]",
   "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.447985758671875*^9, {3.447986840296875*^9, 
   3.447986842328125*^9}, {3.44798689575*^9, 3.447986901046875*^9}, 
   3.447987043734375*^9, {3.44798707884375*^9, 3.447987085734375*^9}, {
   3.447987701390625*^9, 3.447987750546875*^9}, {3.447989050765625*^9, 
   3.44798905453125*^9}, {3.4479890953125*^9, 3.447989107828125*^9}, {
   3.4479980708294888`*^9, 3.4479980804076138`*^9}, 3.4479988409388638`*^9, 
   3.4479988973607388`*^9, 3.4479991970638638`*^9, {3.4484015922961893`*^9, 
   3.4484016216243143`*^9}, {3.5076457959892917`*^9, 3.5076457996976624`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 320, $CellContext`b$$ = 
    3, $CellContext`c$$ = 0.58014, $CellContext`range$$ = 
    1, $CellContext`time$$ = 4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`range$$], 1, "upper view"}, {
      Rational[1, 16] -> "narrow", Rational[1, 4] -> "medium", 1 -> "wide", 4 -> 
       "really wide"}}, {{
       Hold[$CellContext`c$$], 0.58014, "zoomed view"}, 0, 
      Dynamic[$CellContext`range$$ - 1/100]}, {{
       Hold[$CellContext`a$$], 320, "mean frequency (Hz)"}, 220, 5000}, {{
       Hold[$CellContext`b$$], 3, "difference in frequencies (Hz)"}, -20, 20, 
      1}, {
      Hold[
       Button["play tones", 
        EmitSound[
         Sound[
          Play[{
            
            Sin[($CellContext`a$$ - $CellContext`b$$/2) (2 
              Pi $CellContext`t)], 
            
            Sin[($CellContext`a$$ + $CellContext`b$$/2) (2 
              Pi $CellContext`t)]}, {$CellContext`t, 0, $CellContext`time$$}, 
           SampleRate -> 6000]]], Appearance -> "FramedPalette", ImageSize -> 
        168, ImageMargins -> {{135, 2}, {2, 2}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`time$$], 4, "play time (s)"}, 2, 20, 2}}, 
    Typeset`size$$ = {375., {125., 130.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`range$137743$$ = False, $CellContext`c$137744$$ = 
    0, $CellContext`a$137745$$ = 0, $CellContext`b$137746$$ = 
    0, $CellContext`time$137747$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 320, $CellContext`b$$ = 
        3, $CellContext`c$$ = 0.58014, $CellContext`range$$ = 
        1, $CellContext`time$$ = 4}, "ControllerVariables" :> {
        Hold[$CellContext`range$$, $CellContext`range$137743$$, False], 
        Hold[$CellContext`c$$, $CellContext`c$137744$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$137745$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$137746$$, 0], 
        Hold[$CellContext`time$$, $CellContext`time$137747$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       If[$CellContext`c$$ > $CellContext`range$$ - 1/
          100, $CellContext`c$$ = $CellContext`range$$ - 1/100]; Column[{
          Show[
           Plot[
           Sin[($CellContext`a$$ - $CellContext`b$$/2) 2 Pi $CellContext`t] + 
            Sin[($CellContext`a$$ + $CellContext`b$$/2) 2 
              Pi $CellContext`t], {$CellContext`t, 0, $CellContext`range$$}, 
            AspectRatio -> 1/3, ImageSize -> {375, 125}, 
            PlotRange -> {-2.2, 2.2}, Axes -> {True, False}], 
           
           Plot[{2.2}, {$CellContext`t, $CellContext`c$$, $CellContext`c$$ + 
             1/100}, AspectRatio -> 1/3, ImageSize -> {375, 125}, 
            PlotRange -> {-2.2, 2.2}, Filling -> Bottom, 
            Axes -> {True, False}, PlotStyle -> Transparent, 
            FillingStyle -> {
              Opacity[0.4, Red]}]], 
          Show[
           
           Plot[{Sin[($CellContext`a$$ - $CellContext`b$$/2) 2 
               Pi $CellContext`t] + 
             Sin[($CellContext`a$$ + $CellContext`b$$/2) 2 Pi $CellContext`t], 
             Sin[($CellContext`a$$ - $CellContext`b$$/2) 2 Pi $CellContext`t], 
             
             Sin[($CellContext`a$$ + $CellContext`b$$/2) 2 
              Pi $CellContext`t]}, {$CellContext`t, $CellContext`c$$, \
$CellContext`c$$ + 1/100}, AspectRatio -> 1/3, ImageSize -> {375, 125}, 
            PlotRange -> {-2.2, 2.2}, PlotStyle -> {Thick, Dashed, Dashed}, 
            Axes -> {True, False}]]}, Center]), 
      "Specifications" :> {{{$CellContext`range$$, 1, "upper view"}, {
         Rational[1, 16] -> "narrow", Rational[1, 4] -> "medium", 1 -> "wide",
           4 -> "really wide"}}, {{$CellContext`c$$, 0.58014, "zoomed view"}, 
         0, 
         Dynamic[$CellContext`range$$ - 1/100]}, {{$CellContext`a$$, 320, 
          "mean frequency (Hz)"}, 220, 5000, Appearance -> 
         "Labeled"}, {{$CellContext`b$$, 3, 
          "difference in frequencies (Hz)"}, -20, 20, 1, Appearance -> 
         "Labeled"}, 
        Button["play tones", 
         EmitSound[
          Sound[
           Play[{
             
             Sin[($CellContext`a$$ - $CellContext`b$$/2) (2 
               Pi $CellContext`t)], 
             
             Sin[($CellContext`a$$ + $CellContext`b$$/2) (2 
               Pi $CellContext`t)]}, {$CellContext`t, 0, $CellContext`time$$},
             SampleRate -> 6000]]], Appearance -> "FramedPalette", ImageSize -> 
         168, ImageMargins -> {{135, 2}, {2, 2}}], {{$CellContext`time$$, 4, 
          "play time (s)"}, 2, 20, 2, Appearance -> "Labeled"}}, 
      "Options" :> {ControlPlacement -> Bottom}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{420., {235., 240.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->37398893],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Adjust the sliders to explore the relationship between the difference in \
frequencies of the two component waveforms (shown dashed) and the resulting \
beat frequency seen in the upper plot. The red region in the upper plot is \
projected in the lower plot: move the \"zoomed view\" slider to view where \
the component waveforms are in phase, so that their sum reaches maximum \
amplitude, and where the waveforms are out of phase, so that their sum \
reaches minimum amplitude. The frequencies permitted by the \"mean \
frequency\" slider are audible to humans: click the \"play tones\" button to \
hear the resulting beating effect.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Note that each stereo channel plays a tone of a single frequency, so that \
beating effect is the inteference of the soundwaves and not the speakers \
playing the mathematical summation of the two waveforms.\
\>", "Text"],

Cell[TextData[{
 "This Demonstration is an expanded version of the application created by Jon \
McLoone in the Screencast titled \"",
 StyleBox["Mathematica Player",
  FontSlant->"Italic"],
 " Family: Creating an Application in 60 Seconds\" found in the Wolfram \
Screencast Gallery."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Beat Frequency of Sound Waves",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/BeatFrequencyOfSoundWaves/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/BeatFrequencyOfSoundWaves/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/BeatFrequencyOfSoundWaves/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/BeatFrequencyOfSoundWaves/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/BeatFrequencyOfSoundWaves/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Christopher Engberg",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Christopher+\
Engberg"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Christopher+Engberg"]\

}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "After work by: ",
 ButtonBox["Jon McLoone",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jon+McLoone"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jon+McLoone"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->185192154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
BeatFrequencyOfSoundWaves"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Beat Frequency of Sound Waves - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[631, 23, 149, 3, 70, "Section"],
Cell[783, 28, 3700, 64, 70, "Section"],
Cell[4486, 94, 8582, 214, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13105, 313, 5653, 115, 70, "Output",
 CellID->37398893],
Cell[CellGroupData[{
Cell[18783, 432, 209, 6, 70, "Section"],
Cell[18995, 440, 660, 10, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19703, 456, 209, 6, 70, "Section"],
Cell[19915, 464, 231, 4, 70, "Text"],
Cell[20149, 470, 296, 7, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[20481, 482, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20839, 493, 935, 25, 70, "Text"],
Cell[CellGroupData[{
Cell[21799, 522, 453, 15, 70, "Text"],
Cell[22255, 539, 449, 15, 70, "Text",
 CellID->185192154]
}, Open  ]],
Cell[CellGroupData[{
Cell[22741, 559, 815, 24, 70, "Text"],
Cell[23559, 585, 1197, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 8Q4CBt5m3O3ONATgBw4Fvi2g *)
