(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26129,        754]
NotebookOptionsPosition[     23940,        682]
NotebookOutlinePosition[     24614,        708]
CellTagsIndexPosition[     24571,        705]
WindowTitle->Fraunhofer Diffraction through a Rectangular Aperture - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fraunhofer Diffraction through a Rectangular Aperture", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuO40QUQFuAxGyBT5YCSxhWABL8IgESYpOjmR6+gA3Mb/s13Xk0jssu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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.09, $CellContext`b$$ = 
    0.09, $CellContext`color$$ = "violet", $CellContext`z$$ = 900, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 0.09, "length (cm)"}, 0.01, 0.1, 0.01}, {{
       Hold[$CellContext`a$$], 0.09, "breadth (cm)"}, 0.01, 0.1, 0.01}, {{
       Hold[$CellContext`z$$], 900, "distance (cm)"}, 100, 1000, 100}, {
      Hold[$CellContext`color$$], {"violet", "green", "orange"}}}, 
    Typeset`size$$ = {424., {185., 190.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`b$36240$$ = 0, $CellContext`a$36241$$ = 
    0, $CellContext`z$36242$$ = 0, $CellContext`color$36243$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.09, $CellContext`b$$ = 
        0.09, $CellContext`color$$ = "violet", $CellContext`z$$ = 900}, 
      "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$36240$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$36241$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$36242$$, 0], 
        Hold[$CellContext`color$$, $CellContext`color$36243$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ContourPlot[(
          Sin[((Pi $CellContext`b$$) $CellContext`x)/($CellContext`\[Lambda] = 
            Which[$CellContext`color$$ == "violet", 4 
               10^(-5), $CellContext`color$$ == "green", 5 
               10^(-5), $CellContext`color$$ == "orange", 6 
               10^(-5)] $CellContext`z$$)]/(((
            Pi $CellContext`b$$) $CellContext`x)/($CellContext`\[Lambda] = 
          Which[$CellContext`color$$ == "violet", 4 
             10^(-5), $CellContext`color$$ == "green", 5 
             10^(-5), $CellContext`color$$ == "orange", 6 
             10^(-5)] $CellContext`z$$)))^2 (
          Sin[((Pi $CellContext`a$$) $CellContext`y)/($CellContext`\[Lambda] = 
            Which[$CellContext`color$$ == "violet", 4 
               10^(-5), $CellContext`color$$ == "green", 5 
               10^(-5), $CellContext`color$$ == "orange", 6 
               10^(-5)] $CellContext`z$$)]/(((
            Pi $CellContext`a$$) $CellContext`y)/($CellContext`\[Lambda] = 
          Which[$CellContext`color$$ == "violet", 4 
             10^(-5), $CellContext`color$$ == "green", 5 
             10^(-5), $CellContext`color$$ == "orange", 6 
             10^(-5)] $CellContext`z$$)))^2, {$CellContext`x, -2, 
         2}, {$CellContext`y, -2, 2}, ColorFunction -> 
        Which[$CellContext`color$$ == "violet", 
          Blend[{Black, Purple, LightPurple}, #]& , $CellContext`color$$ == 
          "green", "AvocadoColors", $CellContext`color$$ == "orange", 
          Blend[{Black, Red, Orange, LightOrange}, #]& ], PlotLegends -> 
        Automatic, PlotLabel -> "intensity profile", FrameLabel -> {
          Row[{
            Style["x", Italic], " (cm)"}], 
          Row[{
            Style["y", Italic], " (cm)"}]}, Contours -> 100, ContourStyle -> 
        None, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`b$$, 0.09, "length (cm)"}, 0.01, 
         0.1, 0.01, ControlType -> 
         Setter}, {{$CellContext`a$$, 0.09, "breadth (cm)"}, 0.01, 0.1, 0.01, 
         ControlType -> Setter}, {{$CellContext`z$$, 900, "distance (cm)"}, 
         100, 1000, 100, ControlType -> Setter}, {$CellContext`color$$, {
         "violet", "green", "orange"}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{471., {266., 273.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->125649460],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration illustrates Fraunhofer optical diffraction through a \
rectangular aperture. The length and breadth determine the dimensions of the \
aperture in cm (length is along the horizontal axis and breadth along the \
vertical axis). The distance control specifies the distance between the \
aperture and the screen. Color is related to the wavelength of light used to \
illuminate the aperture. Violet corresponds to 400nm, green is around 500nm \
and orange is at 600nm. You can change the parameters to observe the \
variation in the intensity profile on the screen.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The Fraunhofer diffraction pattern is the Fourier transform of the aperture \
function. It is obtained by evaluating the Fraunhofer diffraction integral. \
\>", "Text"],

Cell[TextData[Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[Thickness[Tiny]], 
   RectangleBox[{0.013405292479108627`, -0.01787372330547865}, \
{0.5134052924791086, 0.7821262766945216}], 
   {GrayLevel[1], RectangleBox[{0.8, 0.8}, {1.3, 1.6}], 
    {EdgeForm[Thickness[Tiny]], RectangleBox[{0.18, 0.27}, {0.32, 0.53}], 
     {GrayLevel[0], Thickness[Large], LineBox[{{0.25, 0.4}, {1.05, 1.2}}], 
      {Arrowheads[Medium], ArrowBox[{{0.25, 0.4}, {0.25, 1}}], 
       ArrowBox[{{0.25, 0.4}, {0.7, 0.4}}], 
       ArrowBox[{{1.05, 1.2}, {1.05, 1.8}}], 
       ArrowBox[{{1.05, 1.2}, {1.5, 1.2}}], PointBox[{1.18, 1.45}]}, 
      {Thickness[Tiny], Arrowheads[{-Small, Small}], 
       ArrowBox[{{0.18, 0.24}, {0.32, 0.24}}], 
       ArrowBox[{{0.15, 0.27}, {0.15, 0.53}}], 
       StyleBox[InsetBox[
         StyleBox["\<\"x\"\>",
          StripOnInput->False,
          FontSize->15], {1.54, 1.1955315691736301`}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"y\"\>",
          StripOnInput->False,
          FontSize->15], {1.05, 1.85}],
        FontSlant->"Italic"], InsetBox[
        StyleBox["\<\"P\"\>",
         StripOnInput->False,
         FontSize->18], {1.23, 1.45}], InsetBox[
        StyleBox["\<\"o\"\>",
         StripOnInput->False,
         FontSize->15], {0.24, 0.37}], InsetBox[
        StyleBox["\<\"o'\"\>",
         StripOnInput->False,
         FontSize->15], {1.05, 1.15}], InsetBox[
        StyleBox["\<\"\[Xi]\"\>",
         StripOnInput->False,
         FontSize->15], {0.75, 0.4}], InsetBox[
        StyleBox["\<\"\[Eta]\"\>",
         StripOnInput->False,
         FontSize->15], {0.25, 1.05}], InsetBox[
        StyleBox["\<\"screen\"\>",
         StripOnInput->False,
         FontSize->17], {1.1, 0.85}], 
       StyleBox[InsetBox[
         StyleBox["\<\"z\"\>",
          StripOnInput->False,
          FontSize->15], {0.7, 0.78}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"b\"\>",
          StripOnInput->False,
          FontSize->15], {0.25, 0.19}],
        FontSlant->"Italic"], 
       StyleBox[InsetBox[
         StyleBox["\<\"a\"\>",
          StripOnInput->False,
          FontSize->15], {0.11, 0.39553156917362997`}],
        FontSlant->"Italic"]}}}}},
  ImagePadding->{{0., 1.}, {1., 3.1072}},
  PlotRange->{{-0.03208333333333334, 1.5720833333333333`}, {-0.0308, 1.8808}},
  
  PlotRangePadding->Automatic]]]], "Text"],

Cell[TextData[{
 "Consider a screen in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " plane. The rectangular aperture is in a plane parallel to it (the ",
 Cell[BoxData[
  FormBox["\[Xi]", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox["\[Eta]", TraditionalForm]], "InlineMath"],
 " plane). The perpendicular distance between the screen and aperture is \
given by ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". The dimensions of the aperture are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "\[Times]", "a"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text"],

Cell[TextData[{
 "Consider a monochromatic plane wave normally incident on the aperture. The \
field distribution at a point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["P",
     FontSlant->"Plain"], "(", 
    RowBox[{"x", ",", "y", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " on the screen is given by the Fraunhofer diffraction integral:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "P", ")"}], "=", 
    RowBox[{
     FractionBox["A", 
      RowBox[{"i", "\[Lambda]", "z"}]], 
     TagBox[
      SuperscriptBox["e", 
       RowBox[{"i", "k", "z"}]],
      "MathMLPresentationTag",
      AutoDelete->True], 
     RowBox[{"exp", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"i", "k"}], 
        RowBox[{"2", "z"}]], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}], 
     RowBox[{
      UnderoverscriptBox[
       StyleBox["\[Integral]",
        SpanMinSize->1.,
        SpanMaxSize->1.], 
       RowBox[{
        RowBox[{"-", "b"}], "/", "2"}], 
       RowBox[{"b", "/", "2"}]], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{
         RowBox[{"-", "i"}], "u", "\[Xi]"}]], "d", "\[InvisibleSpace]", 
       "\[Xi]", 
       RowBox[{
        UnderoverscriptBox[
         StyleBox["\[Integral]",
          SpanMinSize->1.,
          SpanMaxSize->1.], 
         RowBox[{
          RowBox[{"-", "a"}], "/", "2"}], 
         RowBox[{"a", "/", "2"}]], 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{
           RowBox[{"-", "i"}], "v", "\[Eta]"}]], "d", "\[InvisibleSpace]", 
         "\[Eta]"}]}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell["where ", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"u", "=", 
     FractionBox[
      RowBox[{"2", "\[Pi]", "x"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"v", "=", 
     FractionBox[
      RowBox[{"2", "\[Pi]", "y"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is the amplitude of the incident plane wave in the plane of the aperture. \
The value of the integral turns out to be"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "(", "P", ")"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "b", "a"}], 
      RowBox[{"i", "\[Lambda]", "z"}]], 
     SuperscriptBox["e", 
      RowBox[{"i", "k", "z"}]], " ", 
     RowBox[{"exp", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"i", "k"}], 
        RowBox[{"2", "z"}]], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}]}], "]"}], 
     FractionBox[
      RowBox[{"sin", " ", "\[Beta]"}], "\[Beta]"], 
     FractionBox[
      RowBox[{"sin", " ", "\[Gamma]"}], "\[Gamma]"]}]}], TraditionalForm]], 
  "InlineMath"],
 ","
}], "Text"],

Cell["where", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[Beta]", "=", 
     FractionBox[
      RowBox[{"\[Pi]", "b", "x"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " "
}], "Text"],

Cell["and ", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[Gamma]", "=", 
     FractionBox[
      RowBox[{"\[Pi]", "a", "y"}], 
      RowBox[{"\[Lambda]", "z"}]]}],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 ". "
}], "Text"],

Cell["\<\
The intensity of a light wave is proportional to the square of the amplitude, \
hence the intensity distribution on the screen is given by\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"I", "(", "P", ")"}], "=", 
    RowBox[{
     SubscriptBox["I", "0"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["sin", "2"], "\[Beta]"}], 
      SuperscriptBox["\[Beta]", "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox["sin", "2"], "\[Gamma]"}], 
      SuperscriptBox["\[Gamma]", "2"]]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   TagBox[
    SubscriptBox["I", "0"],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " is a constant. In this Demonstration, the intensity distribution has been \
plotted schematically (for simplicity, ",
 Cell[BoxData[
  FormBox[
   TagBox[
    SubscriptBox["I", "0"],
    "MathMLPresentationTag",
    AutoDelete->True], TraditionalForm]], "InlineMath"],
 " has been taken to be unity)."
}], "Text"],

Cell["\<\
Snapshot 1: pattern obtained from a square aperture (0.1cm x 0.1cm) and \
violet light at a distance of 1000cm\
\>", "Text"],

Cell["\<\
Snapshot 2: pattern obtained from a square aperture (0.1cm x 0.1cm) and green \
light at a distance of 1000cm\
\>", "Text"],

Cell["\<\
Snapshot 3: pattern obtained from a square aperture (0.1cm x 0.1cm) and \
orange light at a distance of 1000cm\
\>", "Text"],

Cell["\<\
As the wavelength of the light increases, the width (the spacing between \
bright or dark spots) of the pattern also increases. This is seen clearly in \
the first three Snapshots.\
\>", "Text"],

Cell["\<\
Snapshots 4 and 5: the single slit limit is obtained when one of the \
dimensions is much larger in comparison to the other\
\>", "Text"],

Cell["\<\
Snapshot 6: if the dimension of the aperture decreases (0.05cm x 0.05cm in \
this case), then the width of the pattern increases, and vice versa; compare \
with Snapshot 1\
\>", "Text"],

Cell["References", "Text"],

Cell[TextData[{
 "[1] A. Ghatak, ",
 StyleBox["Optics",
  FontSlant->"Italic"],
 ", 5th ed., India: Tata McGraw-Hill Education Pvt. Ltd, 2012."
}], "Text"],

Cell[TextData[{
 "[2] Wikipedia. \"Visible Spectrum.\" (Mar 14, 2018) ",
 ButtonBox["en.wikipedia.org/wiki/Visible_spectrum",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://en.wikipedia.org/wiki/Visible_spectrum"], None},
  ButtonNote->"https://en.wikipedia.org/wiki/Visible_spectrum"],
 "."
}], "Text"]
}, Close]],

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\[NonBreakingSpace]",
 ButtonBox["Radhika Prasad",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Radhika+Prasad"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Radhika+Prasad"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "\"",
 ButtonBox["Fraunhofer Diffraction through a Rectangular Aperture",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"],
 "\"",
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FraunhoferDiffractionThroughARectangularAperture/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 "Published: ",
 "May 2, 2018"
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
FraunhoferDiffractionThroughARectangularAperture"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fraunhofer Diffraction through a Rectangular Aperture - \
Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[656, 23, 173, 3, 70, "Section"],
Cell[832, 28, 3749, 65, 70, "Section"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4618, 98, 4413, 80, 70, "Output",
 CellID->125649460],
Cell[CellGroupData[{
Cell[9056, 182, 209, 6, 70, "Section"],
Cell[9268, 190, 604, 9, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9920, 205, 209, 6, 70, "Section"],
Cell[10132, 213, 178, 3, 70, "Text"],
Cell[10313, 218, 2444, 61, 70, "Text"],
Cell[12760, 281, 700, 22, 70, "Text"],
Cell[13463, 305, 374, 10, 70, "Text"],
Cell[13840, 317, 1371, 49, 70, "Text"],
Cell[15214, 368, 22, 0, 70, "Text"],
Cell[15239, 370, 269, 11, 70, "Text"],
Cell[15511, 383, 269, 11, 70, "Text"],
Cell[15783, 396, 222, 6, 70, "Text"],
Cell[16008, 404, 713, 26, 70, "Text"],
Cell[16724, 432, 21, 0, 70, "Text"],
Cell[16748, 434, 275, 11, 70, "Text"],
Cell[17026, 447, 20, 0, 70, "Text"],
Cell[17049, 449, 277, 11, 70, "Text"],
Cell[17329, 462, 162, 3, 70, "Text"],
Cell[17494, 467, 436, 16, 70, "Text"],
Cell[17933, 485, 494, 17, 70, "Text"],
Cell[18430, 504, 134, 3, 70, "Text"],
Cell[18567, 509, 133, 3, 70, "Text"],
Cell[18703, 514, 134, 3, 70, "Text"],
Cell[18840, 519, 204, 4, 70, "Text"],
Cell[19047, 525, 147, 3, 70, "Text"],
Cell[19197, 530, 195, 4, 70, "Text"],
Cell[19395, 536, 26, 0, 70, "Text"],
Cell[19424, 538, 155, 5, 70, "Text"],
Cell[19582, 545, 315, 8, 70, "Text"]
}, Close]],
Cell[19911, 556, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20269, 567, 416, 13, 70, "Text"],
Cell[20688, 582, 1195, 34, 70, "Text"],
Cell[CellGroupData[{
Cell[21908, 620, 793, 24, 70, "Text"],
Cell[22704, 646, 1220, 33, 70, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature SS45lhV5hAGIVADRk6Sn139A *)
