(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10653,        311]
NotebookOptionsPosition[      9607,        272]
NotebookOutlinePosition[     10229,        296]
CellTagsIndexPosition[     10186,        293]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fraunhofer Diffraction at One Slit", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"2", "\[Pi]"}], 
           RowBox[{"hull", " ", 
            SuperscriptBox["10", 
             RowBox[{"-", "9"}]]}]], 
          FractionBox["d", "2"], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "]"}], ")"}], "^", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", "\[Pi]"}], 
          RowBox[{"hull", " ", 
           SuperscriptBox["10", 
            RowBox[{"-", "9"}]]}]], 
         FractionBox["d", "2"], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ")"}], "^", "2"}]], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"-", "0.015"}], ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"-", "0.004"}], ",", "0.004"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ColorFunction", "\[Rule]", "GrayLevel"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "550"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"hull", ",", "550", ",", "\"\<wavelength (nm)\>\""}], "}"}], 
     ",", "380", ",", "700", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "0.0004", ",", "\"\<width of slit (m)\>\""}], "}"}], 
     ",", "0.0001", ",", "0.01", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4353373615*^9, 3.435337442359375*^9}, {
   3.435337496578125*^9, 3.4353375285*^9}, {3.435339279734375*^9, 
   3.4353392975*^9}, {3.435339361453125*^9, 3.4353393664375*^9}, {
   3.4353394260625*^9, 3.435339447578125*^9}, {3.435346995500294*^9, 
   3.4353469997927237`*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 0.0004, $CellContext`hull$$ = 550, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`hull$$], 550, "wavelength (nm)"}, 380, 700}, {{
       Hold[$CellContext`d$$], 0.0004, "width of slit (m)"}, 0.0001, 0.01}}, 
    Typeset`size$$ = {550., {76., 81.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`hull$279743$$ = 0, $CellContext`d$279744$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`d$$ = 0.0004, $CellContext`hull$$ = 550}, 
      "ControllerVariables" :> {
        Hold[$CellContext`hull$$, $CellContext`hull$279743$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$279744$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      DensityPlot[
       Sin[((2 (Pi/($CellContext`hull$$ 10^(-9)))) ($CellContext`d$$/2)) 
           Sin[$CellContext`\[Theta]]]^2/(((
           2 (Pi/($CellContext`hull$$ 10^(-9)))) ($CellContext`d$$/2)) 
         Sin[$CellContext`\[Theta]])^2, {$CellContext`\[Theta], -0.015, 
         0.015}, {$CellContext`c, -0.004, 0.004}, AspectRatio -> Automatic, 
        PlotPoints -> 50, ColorFunction -> GrayLevel, ImageSize -> 550], 
      "Specifications" :> {{{$CellContext`hull$$, 550, "wavelength (nm)"}, 
         380, 700, Appearance -> 
         "Labeled"}, {{$CellContext`d$$, 0.0004, "width of slit (m)"}, 0.0001,
          0.01, Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{594., {133., 138.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->114927948],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Fraunhofer Diffraction at One Slit",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/FraunhoferDiffractionAtOneSlit/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FraunhoferDiffractionAtOneSlit/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/FraunhoferDiffractionAtOneSlit/\
",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/FraunhoferDiffractionAtOneSlit/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FraunhoferDiffractionAtOneSlit/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["G\[AAcute]bor Angler",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=G%E1bor+Angler"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=G%E1bor+Angler"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
FraunhoferDiffractionAtOneSlit"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{774, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fraunhofer Diffraction at One Slit - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 226, 4, 70, "Section"],
Cell[819, 29, 2155, 57, 70, "Input"]
}, Open  ]],
Cell[2989, 89, 2360, 45, 70, "Output",
 CellID->114927948],
Cell[CellGroupData[{
Cell[5374, 138, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[5750, 149, 981, 29, 70, "Text"],
Cell[6734, 180, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[7074, 191, 442, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[7541, 209, 829, 24, 70, "Text"],
Cell[8373, 235, 1206, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature RQNWZhpWDeOQfCDItHVn8q1K *)
