(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25973,        650]
NotebookOptionsPosition[     24663,        601]
NotebookOutlinePosition[     25337,        626]
CellTagsIndexPosition[     25294,        623]
WindowTitle->Intensity Distribution for Multiple Slit Diffraction - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Intensity Distribution for Multiple Slit Diffraction", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Pane", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Column", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"intensityPlot", "[", 
         RowBox[{"intensityData", "[", 
          RowBox[{"b", ",", "g", ",", "k", ",", "a"}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"se", ",", 
          RowBox[{"patternPlot", "[", 
           RowBox[{"patternData", "[", 
            RowBox[{"b", ",", "g", ",", "k", ",", "a"}], "]"}], "]"}], ",", 
          "Null"}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"370", ",", "370"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0.01", ",", "\"\<slit width (mm)\>\""}], "}"}], ",", 
     "0.005", ",", "0.05", ",", "0.005", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "0.03", ",", "\"\<slit spacing (mm)\>\""}], "}"}], 
     ",", "0.025", ",", "0.1", ",", "0.005", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "40", ",", "\"\<image width (mm)\>\""}], "}"}], ",", 
     "2", ",", "80", ",", "2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "2", ",", "\"\<number of slits\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "10", ",", 
       "15"}], "}"}], ",", "SetterBar", ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"se", ",", "False", ",", "\"\<show screen\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"b", ",", "g", ",", "k", ",", "a", ",", "se"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"vectorSum", "=", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"b", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"g", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "_Integer"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"j", "=", "0"}], 
           RowBox[{"k", "-", "1"}]], 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"i", "=", "1"}], "40"], 
           RowBox[{"Exp", "[", 
            RowBox[{"3174.6", " ", "\[Pi]", " ", "\[ImaginaryI]", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["10", "6"], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "g"}], "2"]}], " ", "+", 
                    RowBox[{"j", " ", "g"}], " ", "-", 
                    FractionBox["b", "2"], "+", 
                    FractionBox[
                    RowBox[{"b", " ", "i"}], "41"]}], ")"}]}], ")"}], 
                "2"]}]]}], "]"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"intensityData", "[", 
        RowBox[{
        "SlitWidth_", ",", "SlitSpacing_", ",", "SlitNumber_", ",", 
         "ImageWidth_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "positionOnScreen", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"positionOnScreen", ",", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 FractionBox["1", 
                  RowBox[{"40", " ", "SlitNumber"}]], 
                 RowBox[{"vectorSum", "[", 
                  RowBox[{
                  "positionOnScreen", ",", "SlitWidth", ",", "SlitSpacing", 
                   ",", "SlitNumber"}], "]"}]}], "]"}], ")"}], "2"]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"positionOnScreen", ",", 
             RowBox[{"-", "ImageWidth"}], ",", "ImageWidth", ",", ".1"}], 
            "}"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"intensityPlot", "[", "data_", "]"}], ":=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"data", ",", "\[IndentingNewLine]", 
         RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"None", ",", "\"\<I\>\""}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"370", ",", "250"}], "}"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"patternData", "[", 
        RowBox[{
        "SlitWidth_", ",", "SlitSpacing_", ",", "SlitNumber_", ",", 
         "ImageWidth_"}], "]"}], ":=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                ",", "i", ",", 
                RowBox[{
                "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
                "}"}], "&"}], ",", 
             RowBox[{"intensityData", "[", 
              RowBox[{
              "SlitWidth", ",", "SlitSpacing", ",", "SlitNumber", ",", 
               "ImageWidth"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", "1"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"patternPlot", "[", "data_", "]"}], ":=", 
       RowBox[{"ListDensityPlot", "[", 
        RowBox[{"data", ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "Full"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"ColorFunction", "\[Rule]", "GrayLevel"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", "\[Rule]", ".2"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"370", ",", "100"}], "}"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.449313715130087*^9, 3.449313903718244*^9}, {
   3.4500257662455673`*^9, 3.450025767008387*^9}, {3.4535886783253317`*^9, 
   3.4535889038268795`*^9}, {3.4537397902483954`*^9, 3.453739796036974*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 40, $CellContext`b$$ = 
    0.01, $CellContext`g$$ = 0.03, $CellContext`k$$ = 2, $CellContext`se$$ = 
    False, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`b$$], 0.01, "slit width (mm)"}, 0.005, 0.05, 
      0.005}, {{
       Hold[$CellContext`g$$], 0.03, "slit spacing (mm)"}, 0.025, 0.1, 
      0.005}, {{
       Hold[$CellContext`a$$], 40, "image width (mm)"}, 2, 80, 2}, {{
       Hold[$CellContext`k$$], 2, "number of slits"}, {1, 2, 3, 4, 5, 6, 10, 
      15}}, {{
       Hold[$CellContext`se$$], False, "show screen"}, {True, False}}}, 
    Typeset`size$$ = {370., {182.5, 187.5}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`b$2155589$$ = 0, $CellContext`g$2155590$$ = 
    0, $CellContext`a$2155591$$ = 0, $CellContext`k$2155592$$ = 
    0, $CellContext`se$2155593$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 40, $CellContext`b$$ = 
        0.01, $CellContext`g$$ = 0.03, $CellContext`k$$ = 
        2, $CellContext`se$$ = False}, "ControllerVariables" :> {
        Hold[$CellContext`b$$, $CellContext`b$2155589$$, 0], 
        Hold[$CellContext`g$$, $CellContext`g$2155590$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$2155591$$, 0], 
        Hold[$CellContext`k$$, $CellContext`k$2155592$$, 0], 
        Hold[$CellContext`se$$, $CellContext`se$2155593$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Pane[
        Column[{
          $CellContext`intensityPlot[
           $CellContext`intensityData[$CellContext`b$$, $CellContext`g$$, \
$CellContext`k$$, $CellContext`a$$]], 
          If[$CellContext`se$$, 
           $CellContext`patternPlot[
            $CellContext`patternData[$CellContext`b$$, $CellContext`g$$, \
$CellContext`k$$, $CellContext`a$$]], Null]}], ImageSize -> {370, 370}], 
      "Specifications" :> {{{$CellContext`b$$, 0.01, "slit width (mm)"}, 
         0.005, 0.05, 0.005, Appearance -> "Labeled", ImageSize -> 
         Tiny}, {{$CellContext`g$$, 0.03, "slit spacing (mm)"}, 0.025, 0.1, 
         0.005, Appearance -> "Labeled", ImageSize -> 
         Tiny}, {{$CellContext`a$$, 40, "image width (mm)"}, 2, 80, 2, 
         Appearance -> "Labeled", ImageSize -> 
         Tiny}, {{$CellContext`k$$, 2, "number of slits"}, {1, 2, 3, 4, 5, 6, 
         10, 15}, ControlType -> SetterBar, ControlPlacement -> 
         Top}, {{$CellContext`se$$, False, "show screen"}, {True, False}, 
         ControlPlacement -> Top}}, 
      "Options" :> {
       ControlPlacement -> Left, SynchronousUpdating -> False, 
        TrackedSymbols :> {$CellContext`b$$, $CellContext`g$$, \
$CellContext`k$$, $CellContext`a$$, $CellContext`se$$}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{623., {234., 239.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`vectorSum = Compile[{{$CellContext`x, 
           Blank[Real]}, {$CellContext`b$$, 
           Blank[Real]}, {$CellContext`g$$, 
           Blank[Real]}, {$CellContext`k$$, 
           Blank[Integer]}}, 
         Sum[
          Exp[
          3174.6 Pi 
           I (10^6 + ($CellContext`x - (-(($CellContext`k$$ - 
                  1) $CellContext`g$$/
                 2) + $CellContext`j $CellContext`g$$ - $CellContext`b$$/
               2 + $CellContext`b$$ $CellContext`i/41))^2)^
            Rational[1, 2]], {$CellContext`j, 0, $CellContext`k$$ - 
           1}, {$CellContext`i, 1, 40}]]; $CellContext`intensityData[
         Pattern[$CellContext`SlitWidth, 
          Blank[]], 
         Pattern[$CellContext`SlitSpacing, 
          Blank[]], 
         Pattern[$CellContext`SlitNumber, 
          Blank[]], 
         Pattern[$CellContext`ImageWidth, 
          Blank[]]] := Module[{$CellContext`positionOnScreen}, 
         Table[{$CellContext`positionOnScreen, 
           Abs[(1/(40 $CellContext`SlitNumber)) \
$CellContext`vectorSum[$CellContext`positionOnScreen, $CellContext`SlitWidth, \
$CellContext`SlitSpacing, $CellContext`SlitNumber]]^2}, \
{$CellContext`positionOnScreen, -$CellContext`ImageWidth, \
$CellContext`ImageWidth, 0.1}]]; $CellContext`intensityPlot[
         Pattern[$CellContext`data, 
          Blank[]]] := 
       ListLinePlot[$CellContext`data, InterpolationOrder -> 3, 
         PlotRange -> {0, 1.1}, AxesLabel -> {None, "I"}, Filling -> Axis, 
         ImageSize -> {370, 250}]; $CellContext`patternData[
         Pattern[$CellContext`SlitWidth, 
          Blank[]], 
         Pattern[$CellContext`SlitSpacing, 
          Blank[]], 
         Pattern[$CellContext`SlitNumber, 
          Blank[]], 
         Pattern[$CellContext`ImageWidth, 
          Blank[]]] := Flatten[
         Table[
          Map[{
            Part[#, 1], $CellContext`i, 
            Part[#, 2]}& , 
           $CellContext`intensityData[$CellContext`SlitWidth, \
$CellContext`SlitSpacing, $CellContext`SlitNumber, $CellContext`ImageWidth]], \
{$CellContext`i, 0, 1}], 1]; $CellContext`patternPlot[
         Pattern[$CellContext`data, 
          Blank[]]] := 
       ListDensityPlot[$CellContext`data, FrameTicks -> {Automatic, None}, 
         PlotRange -> {0, Full}, ColorFunction -> GrayLevel, AspectRatio -> 
         0.2, ImageSize -> {370, 100}]; Null); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->122791344],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The mathematical treatment of Fraunhofer diffraction can be used to calculate \
intensity patterns of both single-slit and multiple-slit diffraction. The \
relevant formulas are difficult to derive with the methods available in \
college mathematics. As an alternative, this Demonstration uses Richard P. \
Feynman's method of \"integrating over paths\". This approach is more \
physical than mathematical, but leads to the same results.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
For each slit, the vectors of 40 waves are summed up at a given point on the \
screen and then the vector sum over all slits gives the intensity at that \
point. You can calculate one vector for each slit and achieve a fairly good \
representation of the intensity distribution. A larger number of waves yields \
better agreement with experimental results and shows the modulation of \
intensity depending on the slit width of the grating.\
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Intensity Distribution for Multiple Slit Diffraction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
IntensityDistributionForMultipleSlitDiffraction/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
IntensityDistributionForMultipleSlitDiffraction/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
IntensityDistributionForMultipleSlitDiffraction/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
IntensityDistributionForMultipleSlitDiffraction/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
IntensityDistributionForMultipleSlitDiffraction/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Hans-Joachim Domke",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Hans-Joachim+\
Domke"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Hans-Joachim+Domke"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
IntensityDistributionForMultipleSlitDiffraction"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Intensity Distribution for Multiple Slit Diffraction - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[654, 23, 172, 3, 70, "Section"],
Cell[829, 28, 3700, 64, 70, "Section"],
Cell[4532, 94, 8578, 210, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13147, 309, 6078, 122, 70, "Output",
 CellID->122791344],
Cell[CellGroupData[{
Cell[19250, 435, 209, 6, 70, "Section"],
Cell[19462, 443, 461, 7, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19971, 456, 209, 6, 70, "Section"],
Cell[20183, 464, 463, 7, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[20682, 476, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[21040, 487, 1082, 31, 70, "Text"],
Cell[22125, 520, 448, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[22598, 538, 815, 24, 70, "Text"],
Cell[23416, 564, 1219, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 8Rz60KxokBzyCCpaoN6K20ot *)
