(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36616,        833]
NotebookOptionsPosition[     35558,        793]
NotebookOutlinePosition[     36160,        817]
CellTagsIndexPosition[     36117,        814]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Colliding Cars", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", "=", 
        RowBox[{"ArcTan", "[", 
         FractionBox[
          RowBox[{"m2", " ", "v2"}], 
          RowBox[{"m1", " ", "v1"}]], "]"}]}], ",", 
       RowBox[{"cd", "=", ".75"}], ",", 
       RowBox[{"sf", "=", "20"}]}], "}"}], ",", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vf", "=", 
         FractionBox[
          RowBox[{"m1", " ", "v1"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m1", "+", "m2"}], ")"}], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]]}], "}"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{".25", ",", ".43", ",", ".82"}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5"}], ",", 
               RowBox[{"-", "5"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", 
               RowBox[{"-", "5"}]}], "}"}]}], "]"}], ",", "Dashed", ",", 
           RowBox[{"Thickness", "[", ".01", "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".48", ",", ".11", ",", ".56"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"collpos", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"v1", "/", "sf"}], " ", "cd"}]}], ",", 
                RowBox[{"collpos", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "collpos"}], 
             "}"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"collpos", "-", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"v2", "/", "sf"}], " ", "cd"}]}], "}"}]}], ",", 
              "collpos"}], "}"}], "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".79", ",", ".71", ",", ".26"}], "]"}], ",", 
           RowBox[{"PointSize", "[", ".03", "]"}], ",", 
           RowBox[{"Point", "[", "collpos", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"collpos", ",", 
              RowBox[{"collpos", "+", 
               RowBox[{"1.1", 
                RowBox[{"{", " ", 
                 RowBox[{
                  RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
                  RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}]}], "}"}],
             "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".49", ",", "0", ",", "0"}], "]"}], ",", 
           RowBox[{"Rotate", "[", 
            RowBox[{
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"collpos", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "v1"}], "/", "sf"}], " ", "cd"}], "-", ".6", 
                   "+", 
                   RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{"t", "<", "cd"}], ",", 
                    RowBox[{
                    RowBox[{"v1", "/", "sf"}], " ", "t"}], ",", 
                    RowBox[{
                    RowBox[{"v1", "/", "sf"}], " ", "cd"}]}], "]"}]}], ",", 
                  RowBox[{"-", ".17"}]}], "}"}], "+", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"t", ">", "cd"}], ",", 
                  RowBox[{
                   RowBox[{"vf", "/", "sf"}], 
                   RowBox[{"(", 
                    RowBox[{"t", "-", "cd"}], ")"}], 
                   RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", " ", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
                  "0"}], "]"}]}], ",", 
               RowBox[{"collpos", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "v1"}], "/", "sf"}], " ", "cd"}], "+", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"t", "<", "cd"}], ",", 
                    RowBox[{
                    RowBox[{"v1", "/", "sf"}], " ", "t"}], ",", 
                    RowBox[{
                    RowBox[{"v1", "/", "sf"}], " ", "cd"}]}], "]"}]}], ",", 
                  ".17"}], "}"}], "+", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"t", ">", "cd"}], ",", 
                  RowBox[{
                   RowBox[{"vf", "/", "sf"}], 
                   RowBox[{"(", 
                    RowBox[{"t", "-", "cd"}], ")"}], 
                   RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", " ", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
                  "0"}], "]"}]}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"t", ">", "cd"}], ",", " ", 
               RowBox[{"\[Theta]", "/", "2"}], ",", "0"}], "]"}]}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".6", ",", ".73", ",", ".36"}], "]"}], ",", 
           RowBox[{"Rotate", "[", 
            RowBox[{
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"collpos", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", ".17"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "v2"}], "/", "sf"}], " ", "cd"}], "-", ".6", 
                   "+", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"t", "<", "cd"}], ",", 
                    RowBox[{
                    RowBox[{"v2", "/", "sf"}], " ", "t"}], ",", 
                    RowBox[{
                    RowBox[{"v2", "/", "sf"}], " ", "cd"}]}], "]"}]}]}], 
                 "}"}], "+", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"t", ">", "cd"}], ",", 
                  RowBox[{
                   RowBox[{"vf", "/", "sf"}], 
                   RowBox[{"(", 
                    RowBox[{"t", "-", "cd"}], ")"}], 
                   RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", " ", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
                  "0"}], "]"}]}], ",", 
               RowBox[{"collpos", "+", 
                RowBox[{"{", 
                 RowBox[{".17", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "v2"}], "/", "sf"}], " ", "cd"}], "+", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"t", "<", "cd"}], ",", 
                    RowBox[{
                    RowBox[{"v2", "/", "sf"}], " ", "t"}], ",", 
                    RowBox[{
                    RowBox[{"v2", "/", "sf"}], " ", "cd"}]}], "]"}]}]}], 
                 "}"}], "+", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"t", ">", "cd"}], ",", 
                  RowBox[{
                   RowBox[{"vf", "/", "sf"}], 
                   RowBox[{"(", 
                    RowBox[{"t", "-", "cd"}], ")"}], 
                   RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", " ", 
                    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
                  "0"}], "]"}]}]}], "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"t", ">", "cd"}], ",", 
               RowBox[{
                RowBox[{"2", 
                 RowBox[{"\[Pi]", "/", "2"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"\[Pi]", "/", "2"}], "-", "\[Theta]"}], ")"}], "/",
                  "2"}]}], ",", "0"}], "]"}]}], "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".79", ",", ".71", ",", ".26"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Column", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Row", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"\<\[Theta]\>\"", ",", "\[Theta]"}], "}"}], 
                    ",", "\"\<=\>\""}], "]"}], ",", 
                  RowBox[{"Row", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<\!\(\*SubscriptBox[\(v\), \(f\)]\)\>\"", ",", 
                    FractionBox[
                    RowBox[{"m1", " ", "v1"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"m1", "+", "m2"}], ")"}], " ", 
                    RowBox[{"Cos", "[", "\[Theta]", "]"}]}]]}], "}"}], ",", 
                    "\"\<=\>\""}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "3."}], ",", 
                 RowBox[{"-", "3."}]}], "}"}]}], "]"}], ",", "16"}], "]"}], 
           ",", 
           RowBox[{"Dashing", "[", "None", "]"}], ",", "White", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2.8"}], ",", 
                RowBox[{"-", "0.85"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", 
                RowBox[{"-", "0.85"}]}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<10 m\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1.9"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"Background", "\[Rule]", "Black"}], ",", 
         RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"350", ",", "350"}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "5"}], ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "5"}], ",", "2.5"}], "}"}]}], "}"}]}]}], "]"}]}], 
      "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.", ",", "1.1", ",", ".01", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "m1", ",", "1000.", ",", "\"\<\!\(\*SubscriptBox[\(m\), \(1\)]\)\>\""}],
       "}"}], ",", "1000.", ",", "1400.", ",", ".1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "m2", ",", "1000.", ",", "\"\<\!\(\*SubscriptBox[\(m\), \(2\)]\)\>\""}],
       "}"}], ",", "1000.", ",", "1800.", ",", ".1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "v1", ",", "40.", ",", "\"\<\!\(\*SubscriptBox[\(v\), \(1\)]\)\>\""}], 
      "}"}], ",", "20.", ",", "100.", ",", ".1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "v2", ",", "90.", ",", "\"\<\!\(\*SubscriptBox[\(v\), \(2\)]\)\>\""}], 
      "}"}], ",", "20.", ",", "100.", ",", ".1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"collpos", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".7"}], ",", 
       RowBox[{"-", ".7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{".7", ",", ".7"}], "}"}], ",", "Locator"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.4262667581705093`*^9, 3.42626682467527*^9}, {
   3.426266854950025*^9, 3.4262668879115753`*^9}, {3.4262669624917307`*^9, 
   3.426266970715663*^9}, {3.426267029777556*^9, 3.4262671258869667`*^9}, {
   3.426267170006721*^9, 3.4262673590624657`*^9}, {3.426267489159583*^9, 
   3.426267519283264*^9}, {3.426267615244863*^9, 3.426267749882286*^9}, {
   3.426267907029381*^9, 3.426267935661841*^9}, {3.4262679952762623`*^9, 
   3.42626799685791*^9}, 3.42626810345863*^9, {3.426268154667574*^9, 
   3.4262682053784447`*^9}, {3.426268754234367*^9, 3.426268760361538*^9}, {
   3.4262689995394897`*^9, 3.426269082630163*^9}, {3.4262691266378393`*^9, 
   3.4262691822359*^9}, {3.4262695319974833`*^9, 3.4262695667903633`*^9}, {
   3.426269616102869*^9, 3.426269619147684*^9}, {3.426269767059067*^9, 
   3.426269774371649*^9}, {3.42626980760402*^9, 3.4262699946307707`*^9}, {
   3.4262700537520733`*^9, 3.426270054740623*^9}, {3.4262723670593576`*^9, 
   3.4262723810590477`*^9}, {3.4262724861099854`*^9, 3.426272492314272*^9}, {
   3.426272539158494*^9, 3.426272606728899*^9}, {3.4262726450979853`*^9, 
   3.426272655376671*^9}, {3.426273220565662*^9, 3.426273237603994*^9}, {
   3.426273294941332*^9, 3.426273295507732*^9}, {3.426273359770856*^9, 
   3.426273442094558*^9}, {3.4262734853583117`*^9, 3.4262734871818323`*^9}, {
   3.4262735241286287`*^9, 3.426273528158997*^9}, {3.426273594098219*^9, 
   3.426273609519897*^9}, {3.4262740625044107`*^9, 3.426274085123027*^9}, {
   3.426274130844709*^9, 3.426274152026527*^9}, {3.4262741846513567`*^9, 
   3.426274195727137*^9}, {3.4262742281186037`*^9, 3.426274240586425*^9}, {
   3.426274368306026*^9, 3.426274370529476*^9}, {3.426274420313306*^9, 
   3.4262744839217978`*^9}, 3.426274618766375*^9, {3.4262746710546637`*^9, 
   3.4262746941503477`*^9}, {3.426274807556766*^9, 3.4262748121548643`*^9}, {
   3.426274848612385*^9, 3.42627486665818*^9}, {3.4262750433947277`*^9, 
   3.426275046256885*^9}, {3.426275093723103*^9, 3.426275217304822*^9}, {
   3.426275264244763*^9, 3.426275297505755*^9}, {3.426275496183614*^9, 
   3.42627557406319*^9}, {3.426275617170876*^9, 3.4262756420645533`*^9}, {
   3.426275683466937*^9, 3.426275684281682*^9}, {3.426275826830502*^9, 
   3.426275828033896*^9}, {3.4262764184995747`*^9, 3.4262764571333313`*^9}, {
   3.42627651779272*^9, 3.426276557900764*^9}, {3.426276674016973*^9, 
   3.426276717951355*^9}, {3.4262768166726093`*^9, 3.42627682911292*^9}, {
   3.426277328172884*^9, 3.4262774157646217`*^9}, {3.4262775168964148`*^9, 
   3.4262775598847437`*^9}, {3.426277601814378*^9, 3.4262776101130943`*^9}, {
   3.42627783683318*^9, 3.426277914629768*^9}, {3.426278060394396*^9, 
   3.426278079818029*^9}, {3.42628131992883*^9, 3.4262813581063547`*^9}, {
   3.426281399232635*^9, 3.426281429806584*^9}, {3.426281488410947*^9, 
   3.426281561101894*^9}, {3.426540869320941*^9, 3.42654089400349*^9}, {
   3.426540946115046*^9, 3.4265409474793653`*^9}, 3.426542409765329*^9, {
   3.426542454511197*^9, 3.426542474958549*^9}, {3.426542547493683*^9, 
   3.4265425608528833`*^9}, {3.426542884613772*^9, 3.4265428879218597`*^9}, {
   3.426543167519862*^9, 3.42654317401624*^9}, {3.42654320486509*^9, 
   3.42654322569272*^9}, {3.427205800305637*^9, 3.427205857331653*^9}, {
   3.427205895368738*^9, 3.4272058963570433`*^9}, 3.427205956511578*^9, {
   3.427206404938568*^9, 3.427206405390094*^9}, {3.427206578221135*^9, 
   3.427206605937051*^9}, {3.4272066571193047`*^9, 3.427206662325576*^9}, 
   3.427206883623884*^9, 3.427206995455055*^9, {3.427207084247319*^9, 
   3.427207084788871*^9}, {3.42721001229423*^9, 3.427210029294857*^9}, {
   3.427210553888547*^9, 3.427210589820291*^9}, {3.4272106429774303`*^9, 
   3.427210659915695*^9}, {3.4272108205837727`*^9, 3.4272108282726517`*^9}, {
   3.427210896396188*^9, 3.427210908127841*^9}, {3.42721097285721*^9, 
   3.427210982848736*^9}, {3.427220136245929*^9, 3.427220137166142*^9}, {
   3.427220186826049*^9, 3.427220187822386*^9}, {3.427220806314807*^9, 
   3.427220836999165*^9}, {3.427220888007134*^9, 3.4272208974584103`*^9}, 
   3.427220962633071*^9, 3.427221016932226*^9, {3.4282609519976397`*^9, 
   3.4282609568274307`*^9}, {3.4282610243489447`*^9, 3.428261031578752*^9}, 
   3.428261548182459*^9, {3.4282615959341*^9, 3.428261604303672*^9}, {
   3.428261911333996*^9, 3.4282619157005873`*^9}, {3.4282620555370207`*^9, 
   3.428262073649996*^9}, {3.4282700916866693`*^9, 3.4282701312473183`*^9}, {
   3.428270173147645*^9, 3.428270179345269*^9}, 3.428270232578487*^9, {
   3.4282725293524227`*^9, 3.4282725818533373`*^9}, {3.429559468961302*^9, 
   3.429559477592477*^9}, 3.429559521075884*^9, 3.429559859220916*^9, 
   3.429559923965831*^9, 3.429559991038124*^9, {3.429560142779499*^9, 
   3.4295601468788757`*^9}, 3.429902229583144*^9, {3.429903810831828*^9, 
   3.429903819670978*^9}, {3.4299039455063257`*^9, 3.429903948943825*^9}, {
   3.4299040447583427`*^9, 3.429904056680188*^9}, {3.4299041751987677`*^9, 
   3.429904177778434*^9}, {3.42990422849573*^9, 3.429904233734273*^9}, {
   3.4299045634063377`*^9, 3.42990461273967*^9}, {3.4299052168715553`*^9, 
   3.4299052311395187`*^9}, {3.429905276678643*^9, 3.429905277328273*^9}, {
   3.429905318588841*^9, 3.429905319133564*^9}, {3.429906099148278*^9, 
   3.4299061032607327`*^9}, {3.429907009412184*^9, 3.429907054717718*^9}, {
   3.42990767849235*^9, 3.429907689249311*^9}, {3.429907723477319*^9, 
   3.429907724063628*^9}, {3.429908039583283*^9, 3.429908057289019*^9}, {
   3.429908358091853*^9, 3.429908390784257*^9}, {3.429909458888092*^9, 
   3.429909460611022*^9}, {3.429909776557982*^9, 3.4299098396074657`*^9}, 
   3.429911032762169*^9, {3.429911512427637*^9, 3.429911516448023*^9}, {
   3.4299115557056007`*^9, 3.4299115639025793`*^9}, {3.429911605219881*^9, 
   3.4299116067651443`*^9}, {3.4299120921321173`*^9, 3.429912117434074*^9}, {
   3.429912240924741*^9, 3.4299122618492603`*^9}, 3.429912538837385*^9, 
   3.4299125698866053`*^9, {3.4299126140424232`*^9, 3.429912624903472*^9}, {
   3.42991267368779*^9, 3.429912692103013*^9}, 3.429912761715341*^9, {
   3.4299128037258167`*^9, 3.4299128062371693`*^9}, 3.429912886016197*^9, {
   3.429912927979665*^9, 3.429912960042624*^9}, {3.4299136792520037`*^9, 
   3.429913703579939*^9}, {3.429914213570994*^9, 3.4299142168811293`*^9}, {
   3.42991429827938*^9, 3.42991430793239*^9}, {3.429914372114133*^9, 
   3.429914402664548*^9}, {3.429914484347616*^9, 3.429914506491151*^9}, {
   3.429915073309823*^9, 3.429915076548242*^9}, {3.4299151971686707`*^9, 
   3.4299151997846212`*^9}, 3.429980060015658*^9, 3.42998012239847*^9, {
   3.429981073950732*^9, 3.429981129236709*^9}, {3.429981365259581*^9, 
   3.429981387397027*^9}, {3.429981425069374*^9, 3.429981508343059*^9}, {
   3.429981598119522*^9, 3.42998162744766*^9}, 3.429981796386751*^9, {
   3.429981848238769*^9, 3.429981874199355*^9}, {3.429982012963214*^9, 
   3.429982053801857*^9}, 3.4299820875271673`*^9, {3.429982150775712*^9, 
   3.429982167081319*^9}, {3.429982965393216*^9, 3.429982975861064*^9}, {
   3.4299843505455313`*^9, 3.4299845101967*^9}, {3.429985638939502*^9, 
   3.4299856452652063`*^9}, {3.429986114338935*^9, 3.4299861174507933`*^9}, {
   3.429986286194088*^9, 3.429986287535527*^9}, {3.42998649300563*^9, 
   3.4299864997122*^9}, {3.429986549083296*^9, 3.42998654943056*^9}, {
   3.429986707235585*^9, 3.429986731891507*^9}, {3.429987761316238*^9, 
   3.429987795380331*^9}, {3.429988212494092*^9, 3.4299882389423428`*^9}, {
   3.4299883086687717`*^9, 3.429988312268166*^9}, {3.4299888408101387`*^9, 
   3.429989027584249*^9}, {3.429989156929748*^9, 3.429989195191958*^9}, {
   3.4299892908228197`*^9, 3.4299892938322277`*^9}, {3.4299893358830013`*^9, 
   3.429989343106636*^9}, {3.429989511607568*^9, 3.429989519554443*^9}, {
   3.4299897190191517`*^9, 3.429989772526176*^9}, {3.429989818927805*^9, 
   3.429989832237323*^9}, {3.430577995555747*^9, 3.4305780507628736`*^9}, {
   3.4305782404697866`*^9, 3.430578291243976*^9}, {3.430579383354549*^9, 
   3.43057938845277*^9}, {3.430580555245253*^9, 3.4305806471120996`*^9}, {
   3.430580704894453*^9, 3.430580746326029*^9}, {3.4305809615695868`*^9, 
   3.430580964009653*^9}, {3.4305811220346813`*^9, 3.430581197037818*^9}, {
   3.430581311078904*^9, 3.430581349951324*^9}, {3.4305817416516323`*^9, 
   3.430581804237906*^9}, {3.430582057372292*^9, 3.430582061187693*^9}, {
   3.430674416475517*^9, 3.430674495443413*^9}, {3.430674555593427*^9, 
   3.4306745647063384`*^9}, {3.43067467193906*^9, 3.4306746738702536`*^9}, {
   3.430755424798374*^9, 3.430755461889513*^9}},
 CellID->1077409234]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`collpos$$ = {0, 0}, $CellContext`m1$$ = 
    1000., $CellContext`m2$$ = 1000., $CellContext`t$$ = 
    0.25, $CellContext`v1$$ = 86.4, $CellContext`v2$$ = 90., Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0., 1.1, 0.01}, {{
       Hold[$CellContext`m1$$], 1000., "\!\(\*SubscriptBox[\(m\), \(1\)]\)"}, 
      1000., 1400., 0.1}, {{
       Hold[$CellContext`m2$$], 1000., "\!\(\*SubscriptBox[\(m\), \(2\)]\)"}, 
      1000., 1800., 0.1}, {{
       Hold[$CellContext`v1$$], 40., "\!\(\*SubscriptBox[\(v\), \(1\)]\)"}, 
      20., 100., 0.1}, {{
       Hold[$CellContext`v2$$], 90., "\!\(\*SubscriptBox[\(v\), \(2\)]\)"}, 
      20., 100., 0.1}, {{
       Hold[$CellContext`collpos$$], {0, 0}}, {-0.7, -0.7}, {0.7, 0.7}}}, 
    Typeset`size$$ = {350., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$105333$$ = 0, $CellContext`m1$105334$$ = 
    0, $CellContext`m2$105335$$ = 0, $CellContext`v1$105336$$ = 
    0, $CellContext`v2$105337$$ = 0, $CellContext`collpos$105338$$ = {0, 0}}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`collpos$$ = {0, 0}, $CellContext`m1$$ = 
        1000., $CellContext`m2$$ = 1000., $CellContext`t$$ = 
        0., $CellContext`v1$$ = 40., $CellContext`v2$$ = 90.}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$105333$$, 0], 
        Hold[$CellContext`m1$$, $CellContext`m1$105334$$, 0], 
        Hold[$CellContext`m2$$, $CellContext`m2$105335$$, 0], 
        Hold[$CellContext`v1$$, $CellContext`v1$105336$$, 0], 
        Hold[$CellContext`v2$$, $CellContext`v2$105337$$, 0], 
        Hold[$CellContext`collpos$$, $CellContext`collpos$105338$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      With[{$CellContext`\[Theta]$ = 
         ArcTan[$CellContext`m2$$ ($CellContext`v2$$/($CellContext`m1$$ \
$CellContext`v1$$))], $CellContext`cd$ = 0.75, $CellContext`sf$ = 20}, 
        With[{$CellContext`vf$ = $CellContext`m1$$ \
($CellContext`v1$$/(($CellContext`m1$$ + $CellContext`m2$$) 
            Cos[$CellContext`\[Theta]$]))}, 
         Graphics[{
           RGBColor[0.25, 0.43, 0.82], 
           Rectangle[{-5, -5}, {-1, -1}], 
           Rectangle[{-5, 5}, {-1, 1}], 
           Rectangle[{1, 1}, {5, 5}], 
           Rectangle[{1, -1}, {5, -5}], Dashed, 
           Thickness[0.01], 
           RGBColor[0.48, 0.11, 0.56], 
           
           Line[{{Part[$CellContext`collpos$$, 
                1] - ($CellContext`v1$$/$CellContext`sf$) $CellContext`cd$, 
              Part[$CellContext`collpos$$, 2]}, $CellContext`collpos$$}], 
           
           Line[{$CellContext`collpos$$ - {
             0, ($CellContext`v2$$/$CellContext`sf$) $CellContext`cd$}, \
$CellContext`collpos$$}], 
           RGBColor[0.79, 0.71, 0.26], 
           PointSize[0.03], 
           Point[$CellContext`collpos$$], 
           Line[{$CellContext`collpos$$, $CellContext`collpos$$ + 1.1 {
                Cos[$CellContext`\[Theta]$], 
                Sin[$CellContext`\[Theta]$]}}], 
           RGBColor[0.49, 0, 0], 
           Rotate[
            
            Rectangle[$CellContext`collpos$$ + \
{((-$CellContext`v1$$)/$CellContext`sf$) $CellContext`cd$ - 0.6 + 
               If[$CellContext`t$$ < $CellContext`cd$, \
($CellContext`v1$$/$CellContext`sf$) $CellContext`t$$, \
($CellContext`v1$$/$CellContext`sf$) $CellContext`cd$], -0.17} + 
             If[$CellContext`t$$ > $CellContext`cd$, \
(($CellContext`vf$/$CellContext`sf$) ($CellContext`t$$ - $CellContext`cd$)) {
                 Cos[$CellContext`\[Theta]$], 
                 Sin[$CellContext`\[Theta]$]}, 
               0], $CellContext`collpos$$ + \
{((-$CellContext`v1$$)/$CellContext`sf$) $CellContext`cd$ + 
               If[$CellContext`t$$ < $CellContext`cd$, \
($CellContext`v1$$/$CellContext`sf$) $CellContext`t$$, \
($CellContext`v1$$/$CellContext`sf$) $CellContext`cd$], 0.17} + 
             If[$CellContext`t$$ > $CellContext`cd$, \
(($CellContext`vf$/$CellContext`sf$) ($CellContext`t$$ - $CellContext`cd$)) {
                 Cos[$CellContext`\[Theta]$], 
                 Sin[$CellContext`\[Theta]$]}, 0]], 
            
            If[$CellContext`t$$ > $CellContext`cd$, $CellContext`\[Theta]$/2, 
             0]], 
           RGBColor[0.6, 0.73, 0.36], 
           Rotate[
            
            Rectangle[$CellContext`collpos$$ + {-0.17, \
((-$CellContext`v2$$)/$CellContext`sf$) $CellContext`cd$ - 0.6 + 
               If[$CellContext`t$$ < $CellContext`cd$, \
($CellContext`v2$$/$CellContext`sf$) $CellContext`t$$, \
($CellContext`v2$$/$CellContext`sf$) $CellContext`cd$]} + 
             If[$CellContext`t$$ > $CellContext`cd$, \
(($CellContext`vf$/$CellContext`sf$) ($CellContext`t$$ - $CellContext`cd$)) {
                 Cos[$CellContext`\[Theta]$], 
                 Sin[$CellContext`\[Theta]$]}, 0], $CellContext`collpos$$ + {
              0.17, ((-$CellContext`v2$$)/$CellContext`sf$) $CellContext`cd$ + 
               If[$CellContext`t$$ < $CellContext`cd$, \
($CellContext`v2$$/$CellContext`sf$) $CellContext`t$$, \
($CellContext`v2$$/$CellContext`sf$) $CellContext`cd$]} + 
             If[$CellContext`t$$ > $CellContext`cd$, \
(($CellContext`vf$/$CellContext`sf$) ($CellContext`t$$ - $CellContext`cd$)) {
                 Cos[$CellContext`\[Theta]$], 
                 Sin[$CellContext`\[Theta]$]}, 0]], 
            
            If[$CellContext`t$$ > $CellContext`cd$, 
             2 (Pi/2) - (Pi/2 - $CellContext`\[Theta]$)/2, 0]], 
           RGBColor[0.79, 0.71, 0.26], 
           Style[
            Text[
             Column[{
               Row[{"\[Theta]", $CellContext`\[Theta]$}, "="], 
               Row[{
                "\!\(\*SubscriptBox[\(v\), \(f\)]\)", $CellContext`m1$$ \
($CellContext`v1$$/(($CellContext`m1$$ + $CellContext`m2$$) 
                  Cos[$CellContext`\[Theta]$]))}, "="]}], {-3., -3.}], 16], 
           Dashing[None], White, 
           Line[{{-2.8, -0.85}, {-1, -0.85}}], 
           Text["10 m", {-1.9, -1}]}, Background -> Black, PlotRangePadding -> 
          0, ImageSize -> {350, 350}, PlotRange -> {{-5, 2.5}, {-5, 2.5}}]]], 
      "Specifications" :> {{$CellContext`t$$, 0., 1.1, 0.01, ImageSize -> 
         Small, Appearance -> 
         "Labeled"}, {{$CellContext`m1$$, 1000., 
          "\!\(\*SubscriptBox[\(m\), \(1\)]\)"}, 1000., 1400., 0.1, ImageSize -> 
         Small, Appearance -> 
         "Labeled"}, {{$CellContext`m2$$, 1000., 
          "\!\(\*SubscriptBox[\(m\), \(2\)]\)"}, 1000., 1800., 0.1, ImageSize -> 
         Small, Appearance -> 
         "Labeled"}, {{$CellContext`v1$$, 40., 
          "\!\(\*SubscriptBox[\(v\), \(1\)]\)"}, 20., 100., 0.1, ImageSize -> 
         Small, Appearance -> 
         "Labeled"}, {{$CellContext`v2$$, 90., 
          "\!\(\*SubscriptBox[\(v\), \(2\)]\)"}, 20., 100., 0.1, ImageSize -> 
         Small, Appearance -> 
         "Labeled"}, {{$CellContext`collpos$$, {0, 0}}, {-0.7, -0.7}, {0.7, 
         0.7}, ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> Left}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{626., {200., 205.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->101728473],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Colliding Cars",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CollidingCars/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/CollidingCars/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/CollidingCars/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CollidingCars/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/CollidingCars/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
CollidingCars"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Colliding Cars - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 206, 4, 70, "Section"],
Cell[799, 29, 22608, 470, 70, "Input",
 CellID->1077409234]
}, Open  ]],
Cell[23422, 502, 8026, 158, 70, "Output",
 CellID->101728473],
Cell[CellGroupData[{
Cell[31473, 664, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[31849, 675, 856, 24, 70, "Text"],
Cell[32708, 701, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[33048, 712, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[33509, 730, 829, 24, 70, "Text"],
Cell[34341, 756, 1189, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature eTzRjpE4OVl35BDp0LCvqzc3 *)
