(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17192,        446]
NotebookOptionsPosition[     16120,        407]
NotebookOutlinePosition[     16759,        431]
CellTagsIndexPosition[     16716,        428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Unsteady-State Conduction of Heat in Two Dimensions", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"plt", ",", "sol"}], "}"}], ",", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"T", "[", 
               RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "\[Equal]", 
            RowBox[{"alpha", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"D", "[", 
                RowBox[{
                 RowBox[{"T", "[", 
                  RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "+", 
               RowBox[{"D", "[", 
                RowBox[{
                 RowBox[{"T", "[", 
                  RowBox[{"x", ",", "y", ",", "t"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ")"}]}]}], ",", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"x", ",", "y", ",", "0"}], "]"}], "\[Equal]", " ", 
            RowBox[{"400", "-", 
             RowBox[{"400", " ", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{"-", "100000"}], " ", 
                RowBox[{"x", "^", "2"}], " ", 
                RowBox[{"y", "^", "2"}], " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "]"}]}], "+", 
             
             RowBox[{"350", " ", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{"-", "100000"}], " ", 
                RowBox[{"x", "^", "2"}], "  ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"x", ",", "0", ",", "t"}], "]"}], "\[Equal]", " ", 
            RowBox[{"350", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "100000"}], " ", 
               RowBox[{"x", "^", "2"}], "  ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}], "]"}]}]}], ",",
            
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"x", ",", "1", ",", "t"}], "]"}], "\[Equal]", " ", 
            RowBox[{"350", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "100000"}], " ", 
               RowBox[{"x", "^", "2"}], "  ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}], "]"}]}]}], ",",
            
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"0", ",", "y", ",", "t"}], "]"}], "\[Equal]", " ", 
            "350"}], ",", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"1", ",", "y", ",", "t"}], "]"}], "\[Equal]", " ", 
            "350"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"T", "[", 
           RowBox[{"x", ",", "y", ",", "t"}], "]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}]}], ";", 
      RowBox[{"plt", "=", 
       RowBox[{"ContourPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"x", ",", "y", ",", "t"}], "]"}], "/.", "sol"}], "/.", 
          RowBox[{"t", "\[Rule]", " ", "time"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"ColorFunction", "\[Rule]", "\"\<Pastel\>\""}], ",", 
         RowBox[{"Contours", "\[Rule]", " ", "8"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<temperature profile\>\""}]}], 
        "]"}]}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"time", ",", "5", ",", "\"\<time\>\""}], "}"}], ",", "5", ",", 
     "100", ",", "0.05", ",", 
     RowBox[{"Appearance", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "alpha", ",", "0.002", ",", 
       "\"\<thermal diffusivity in \!\(\*SuperscriptBox[\(cm\), \
\(2\)]\)/s\>\""}], "}"}], ",", "0.001", ",", "0.005", ",", "0.001", ",", 
     RowBox[{"Appearance", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], ",", 
   
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"alpha", ",", "time"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.434604400609477*^9, 3.434604413198677*^9}, {
   3.434604465271477*^9, 3.4346044915886774`*^9}, {3.4346045504744773`*^9, 
   3.4346046358688774`*^9}, {3.4346046921848774`*^9, 
   3.4346047794512773`*^9}, {3.434604813303277*^9, 3.4346048212592773`*^9}, 
   3.434604944577277*^9, {3.4346049755276775`*^9, 3.4346049778364773`*^9}, {
   3.4346050501580772`*^9, 3.4346050564916773`*^9}, {3.4346050877228775`*^9, 
   3.434605135334077*^9}, {3.434605194473677*^9, 3.434605231804477*^9}, {
   3.434605634284477*^9, 3.434605702362877*^9}, {3.434605790846077*^9, 
   3.4346058539168773`*^9}, {3.434606005907677*^9, 3.434606082332077*^9}, {
   3.4346153141648808`*^9, 3.4346153782340813`*^9}, {3.4346162862242813`*^9, 
   3.434616302729081*^9}, {3.4346394520960755`*^9, 3.4346394763700757`*^9}, {
   3.4346395226880755`*^9, 3.434639639994076*^9}, {3.4346397089340754`*^9, 
   3.4346397919930754`*^9}, {3.4346401887010756`*^9, 
   3.4346401903900757`*^9}, {3.4346402745950756`*^9, 
   3.4346402753420753`*^9}, {3.4346403667620754`*^9, 
   3.4346404462010756`*^9}, {3.434640483650076*^9, 3.4346404843350754`*^9}, {
   3.4346409442710752`*^9, 3.4346410313540754`*^9}, {3.4346411744500756`*^9, 
   3.4346411747210755`*^9}, {3.4346415312140756`*^9, 
   3.4346415466350756`*^9}, {3.4346417300240755`*^9, 
   3.4346417316920757`*^9}, {3.4346418965410757`*^9, 
   3.4346419072280755`*^9}, {3.4346419949060755`*^9, 
   3.4346420145990753`*^9}, {3.434642718546076*^9, 3.4346427478020754`*^9}, {
   3.434683837101*^9, 3.4346838465889997`*^9}, {3.434683973659*^9, 
   3.434683973759*^9}, {3.434684015646*^9, 3.434684048889*^9}, {
   3.4346841965550003`*^9, 3.434684196644*^9}, {3.434684251666*^9, 
   3.434684286988*^9}, {3.434743701255431*^9, 3.4347437026395693`*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`alpha$$ = 0.002, $CellContext`time$$ = 5, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`time$$], 5, "time"}, 5, 100, 0.05}, {{
       Hold[$CellContext`alpha$$], 0.002, 
       "thermal diffusivity in \!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s"}, 
      0.001, 0.005, 0.001}}, Typeset`size$$ = {360., {185., 189.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`time$106157$$ = 0, $CellContext`alpha$106158$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`alpha$$ = 0.002, $CellContext`time$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`time$$, $CellContext`time$106157$$, 0], 
        Hold[$CellContext`alpha$$, $CellContext`alpha$106158$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`plt$, $CellContext`sol$}, $CellContext`sol$ = 
         NDSolve[{D[
              $CellContext`T[$CellContext`x, $CellContext`y, $CellContext`t], \
{$CellContext`t, 1}] == $CellContext`alpha$$ (D[
                $CellContext`T[$CellContext`x, $CellContext`y, \
$CellContext`t], {$CellContext`x, 2}] + D[
                $CellContext`T[$CellContext`x, $CellContext`y, \
$CellContext`t], {$CellContext`y, 
                 2}]), $CellContext`T[$CellContext`x, $CellContext`y, 0] == 
            400 - 400 
             Exp[(-100000) $CellContext`x^2 $CellContext`y^2 ($CellContext`x - 
                 1)^2 ($CellContext`y - 1)^2] + 
             350 Exp[(-100000) $CellContext`x^2 ($CellContext`x - 
                  1)^2], $CellContext`T[$CellContext`x, 0, $CellContext`t] == 
            350 
             Exp[(-100000) $CellContext`x^2 ($CellContext`x - 
                 1)^2], $CellContext`T[$CellContext`x, 1, $CellContext`t] == 
            350 Exp[(-100000) $CellContext`x^2 ($CellContext`x - 
                 1)^2], $CellContext`T[0, $CellContext`y, $CellContext`t] == 
            350, $CellContext`T[1, $CellContext`y, $CellContext`t] == 350}, {
            $CellContext`T[$CellContext`x, $CellContext`y, $CellContext`t]}, \
{$CellContext`x, 0, 1}, {$CellContext`y, 0, 1}, {$CellContext`t, 0, 100}, 
           PrecisionGoal -> 2]; $CellContext`plt$ = ContourPlot[
           ReplaceAll[
            ReplaceAll[
             $CellContext`T[$CellContext`x, $CellContext`y, $CellContext`t], \
$CellContext`sol$], $CellContext`t -> $CellContext`time$$], {$CellContext`x, 
            0, 1}, {$CellContext`y, 0, 1}, ColorFunction -> "Pastel", 
           Contours -> 8, PlotLabel -> "temperature profile"]], 
      "Specifications" :> {{{$CellContext`time$$, 5, "time"}, 5, 100, 0.05, 
         Appearance -> 
         "Labeled"}, {{$CellContext`alpha$$, 0.002, 
          "thermal diffusivity in \!\(\*SuperscriptBox[\(cm\), \(2\)]\)/s"}, 
         0.001, 0.005, 0.001, Appearance -> "Labeled"}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`alpha$$, $CellContext`time$$}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{404., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->303150276],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Unsteady-State Conduction of Heat in Two Dimensions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
UnsteadyStateConductionOfHeatInTwoDimensions/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
UnsteadyStateConductionOfHeatInTwoDimensions/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
UnsteadyStateConductionOfHeatInTwoDimensions/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
UnsteadyStateConductionOfHeatInTwoDimensions/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
UnsteadyStateConductionOfHeatInTwoDimensions/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Housam Binous",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Housam+Binous"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Housam+Binous"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
UnsteadyStateConductionOfHeatInTwoDimensions"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Unsteady-State Conduction of Heat in Two Dimensions - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 243, 4, 70, "Section"],
Cell[836, 29, 7041, 164, 70, "Input"]
}, Open  ]],
Cell[7892, 196, 3877, 71, 70, "Output",
 CellID->303150276],
Cell[CellGroupData[{
Cell[11794, 271, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[12170, 282, 1066, 31, 70, "Text"],
Cell[13239, 315, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[13579, 326, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[14040, 344, 829, 24, 70, "Text"],
Cell[14872, 370, 1220, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature UR487H@05Dw@yBpE9n0bIeX# *)
