(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    132161,       3187]
NotebookOptionsPosition[    130175,       3121]
NotebookOutlinePosition[    130849,       3146]
CellTagsIndexPosition[    130806,       3143]
WindowTitle->Tracking and Separation (Visual Depth Perception 11) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Tracking and Separation (Visual Depth Perception 11)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"nORM", "[", 
      RowBox[{"vector_", "?", "VectorQ"}], "]"}], ":=", 
     SqrtBox[
      RowBox[{"vector", ".", "vector"}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"degrees", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"arcMinutes", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", "60", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"aim\[Psi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"midPoint", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{"aimOffset", "*", "interOcular", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
        "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"rightViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"leftViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fixateConvergence", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}]}], 
      ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"rightEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"leftEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"convergenceDistraction", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"left\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"left\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"right\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"right\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}]}], "]"}], ",", "0.0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}], "-", 
         RowBox[{"left\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"right\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"left\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{
     RowBox[{"binocularDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"retinalDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyePict", "[", 
      RowBox[{
       RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
       RowBox[{
        RowBox[{"viewVector", "=", 
         RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"viewVector", "=", 
         RowBox[{"viewVector", "/", 
          RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray", ",", 
               RowBox[{"Circle", "[", 
                RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                   RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                  "}"}]}], "]"}]}], "}"}], "]"}], ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Gray", ",", "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", " ", 
                  RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                 RowBox[{".5", "eyeRadius"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                   RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
              "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Green", ",", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", 
                  RowBox[{
                  "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], ",", 
                 RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
           "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyeEdge", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"eyeRadius", "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"inRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"leftEyeCenter", "[", 
            RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
           "fixate"}], "]"}], ",", 
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"rightEyeCenter", "[", 
            RowBox[{"headAimVector", ",", "base"}], "]"}], ",", "fixate"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Green", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}], "}"}],
                "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"min", "=", 
           RowBox[{"Min", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"MAX", "=", 
           RowBox[{"Max", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Brown", ",", 
             RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                "eyeRadius", ",", 
                RowBox[{"{", 
                 RowBox[{"min", ",", "MAX"}], "}"}]}], "]"}], "}"}]}], "}"}], 
           "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "interOcular"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", "interOcular"}]}], "}"}]}],
          "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"outRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "fixate", "]"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "distraction", "]"}], "]"}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Green", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"headAimVector", ",", "base"}], "}"}], "]"}], "]"}], 
             "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"outLabels", "[", 
      RowBox[{
       RowBox[{"aimHead_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Magenta", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"StringForm", "[", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(r\)]\) = `1`\[Degree]\
\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"N", "[", 
                    RowBox[{
                    FractionBox["180", "\[Pi]"], 
                    RowBox[{"right\[Theta]", "[", 
                    RowBox[{
                    "aimHead", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}], ",", ".1"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{".7", ",", "0"}], "}"}], "+", 
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", "base"}], "]"}], "-", 
                
                RowBox[{"2.5", "eyeRadius", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"aimHead", ",", "base"}], "]"}], "-", 
                    "distraction", "-", "fixate"}], ")"}], "/", 
                  RowBox[{"nORM", "[", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"aimHead", ",", "base"}], "]"}], "-", 
                    "distraction", "-", "fixate"}], ")"}], "]"}]}]}]}]}], 
              "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"rightEyeNode", "[", 
                RowBox[{"aimHead", ",", "fixate", ",", "base"}], "]"}], ",", 
               RowBox[{"2.5", "eyeRadius"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Min", "[", 
                  RowBox[{
                   RowBox[{"right\[Delta]", "[", 
                    RowBox[{
                    "aimHead", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}], ",", 
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", "base"}], "]"}]}], 
                  "]"}], ",", 
                 RowBox[{"Max", "[", 
                  RowBox[{
                   RowBox[{"right\[Delta]", "[", 
                    RowBox[{
                    "aimHead", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}], ",", 
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", "base"}], "]"}]}], 
                  "]"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
          "}"}], "]"}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Real", " ", "Program", " ", "Starts", " ", "Here"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"interOcular", "=", "6.5"}], ";", "\[IndentingNewLine]", 
    RowBox[{"eyeRadius", "=", "1.3"}], ";", "\[IndentingNewLine]", 
    RowBox[{"aimOffset", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"base", "[", "t_", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"aimHead", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"f", "=", 
     RowBox[{"fixate", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"fixate", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "f"}], "}"}]}], ";"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"inRays", "[", 
         RowBox[{"aimHead", ",", "fixate", ",", "distraction", ",", 
          RowBox[{"base", "[", "t", "]"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"outLabels", "[", 
         RowBox[{"aimHead", ",", "fixate", ",", "distraction", ",", 
          RowBox[{"base", "[", "t", "]"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"midPoint", "[", 
             RowBox[{"aimHead", ",", 
              RowBox[{"base", "[", "t", "]"}]}], "]"}], "]"}]}], "}"}], "]"}],
         "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Green", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", 
              RowBox[{"base", "[", "t", "]"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<B\>\"", ",", 
               RowBox[{
                RowBox[{"base", "[", "t", "]"}], "-", 
                RowBox[{"{", 
                 RowBox[{"0", ",", ".5"}], "}"}]}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<A\>\"", ",", 
               RowBox[{
                RowBox[{"1.05", "aimHead"}], "+", 
                RowBox[{"{", 
                 RowBox[{"0", ",", ".5"}], "}"}], "+", 
                RowBox[{"base", "[", "t", "]"}]}]}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"base", "[", "t", "]"}], ",", 
                RowBox[{"aimHead", "+", 
                 RowBox[{"base", "[", "t", "]"}]}], ",", 
                RowBox[{
                 RowBox[{"base", "[", "t", "]"}], "+", 
                 RowBox[{"{", 
                  RowBox[{".1", ",", ".7"}], "}"}]}]}], "}"}], "]"}]}], 
            "\[IndentingNewLine]", "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Orange", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"rightEyeNode", "[", 
                RowBox[{"aimHead", ",", "fixate", ",", 
                 RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
               RowBox[{"1.5", "eyeRadius"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Min", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"aim\[Psi]", "[", 
                    RowBox[{"aimHead", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                    RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "}"}], "]"}], 
                 ",", 
                 RowBox[{"Max", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"aim\[Psi]", "[", 
                    RowBox[{"aimHead", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                    RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "}"}], 
                  "]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                RowBox[{
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"aimHead", ",", "fixate", ",", 
                   RowBox[{"base", "[", "t", "]"}]}], "]"}], "+", 
                 RowBox[{"3", "aimHead"}]}]}], "}"}], "]"}], 
             "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"StringForm", "[", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) = `1` \
\[Degree]\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{"right\[Alpha]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], 
                    RowBox[{"180", "/", "\[Pi]"}]}], "]"}], ",", ".1"}], 
                  "]"}]}], "]"}], ",", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], "+", 
                RowBox[{"2", "aimHead"}], "+", 
                RowBox[{"{", 
                 RowBox[{".8", ",", "0"}], "}"}]}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "fixate", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"StringForm", "[", 
                RowBox[{"\"\<F = (`1`  ,  `2`)\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"fixate", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", ".01"}], "]"}], ",", 
                 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"fixate", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", ".01"}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"fixate", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", ".5"}], "}"}]}]}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", "fixate"}], 
               "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", "fixate"}], 
               "}"}], "]"}]}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "distraction", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"StringForm", "[", 
                RowBox[{"\"\<D = (`1`  ,  `2`)\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"distraction", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", ".01"}], "]"}], ",", 
                 
                 RowBox[{"Round", "[", 
                  RowBox[{"distraction", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", ".01"}], "]"}],
                ",", 
               RowBox[{"distraction", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", ".5"}], "}"}]}]}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                "distraction"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                "distraction"}], "}"}], "]"}]}], "}"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Brown", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"StringForm", "[", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[Beta]\), \(r\)]\) = `1` \[Degree]\
\>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"N", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"right\[Alpha]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], "-", 
                    RowBox[{"right\[Theta]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", "distraction", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}]}], ")"}], 
                    RowBox[{"180", "/", "\[Pi]"}]}], "]"}], ",", ".1"}], 
                  "]"}]}], "]"}], ",", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"aimHead", ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", ".6"}], ",", "0"}], "}"}], "-", 
                RowBox[{"2.", "eyeRadius", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rightEyeNode", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], "-", 
                    "distraction"}], ")"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rightEyeNode", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], "-", 
                    "distraction"}], ")"}], "]"}]}], ")"}]}]}]}], "]"}], 
             "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"rightEyeNode", "[", 
                RowBox[{"aimHead", ",", "fixate", ",", 
                 RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
               RowBox[{"2.", "eyeRadius"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Min", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"aim\[Psi]", "[", 
                    RowBox[{"aimHead", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                    RowBox[{"right\[Delta]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", "distraction", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "}"}], "]"}], 
                 ",", 
                 RowBox[{"Max", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"aim\[Psi]", "[", 
                    RowBox[{"aimHead", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                    RowBox[{"right\[Delta]", "[", 
                    RowBox[{"aimHead", ",", "fixate", ",", "distraction", ",", 
                    RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "}"}], 
                  "]"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
           RowBox[{"Dashing", "[", ".025", "]"}], ",", "Gray", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"base", "[", "t", "]"}], "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], ",", 
               RowBox[{
                RowBox[{"base", "[", "t", "]"}], "+", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}]}], "}"}], "]"}], 
            "\[IndentingNewLine]", "}"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<Translation\>\"", ",", 
            RowBox[{
             RowBox[{"base", "[", "t", "]"}], "+", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", ".1"}], ",", 
               RowBox[{"-", "1.5"}]}], "}"}]}]}], "]"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3.25"}], ",", "3.25"}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "12"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fixate", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "11"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"distraction", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "9"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "11"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nodePercent", ",", ".5", ",", "\"\<node percent\>\""}], "}"}], 
     ",", "0", ",", "1.", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\"\<time t\>\""}], "}"}], ",", 
     RowBox[{"-", "4"}], ",", "4", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.402931471872177*^9, 3.4029314778811703`*^9}, {
   3.402931554067174*^9, 3.40293159815585*^9}, {3.4029316793795633`*^9, 
   3.4029316873830357`*^9}, {3.402931811978162*^9, 3.402931914482718*^9}, {
   3.402931945238101*^9, 3.402931968285226*^9}, {3.402931998662466*^9, 
   3.4029320546432123`*^9}, {3.402932094226103*^9, 3.402932181622746*^9}, {
   3.4029322332691717`*^9, 3.402932233664102*^9}, {3.4029322647202044`*^9, 
   3.402932340785534*^9}, {3.402932373764728*^9, 3.402932434010462*^9}, {
   3.4029337592283154`*^9, 3.402933760842346*^9}, 3.4030224458500643`*^9, {
   3.403023551042521*^9, 3.403023560125489*^9}, {3.403024691950955*^9, 
   3.403024698764286*^9}, {3.403024738741001*^9, 3.403024761086549*^9}, {
   3.403025125637392*^9, 3.403025167593399*^9}, 3.403025220104023*^9, {
   3.405365510510847*^9, 3.405365650406583*^9}, {3.405365851321547*^9, 
   3.4053658773386717`*^9}, {3.405365973877887*^9, 3.405366122576042*^9}, {
   3.411402401272196*^9, 3.4114024013441963`*^9}, {3.411402778232449*^9, 
   3.411402800371559*^9}, {3.41140311999578*^9, 3.411403165432968*^9}, {
   3.411403212572207*^9, 3.411403242591331*^9}, {3.411750066875346*^9, 
   3.411750070874642*^9}, {3.411750163680995*^9, 3.411750281928667*^9}, {
   3.411750383716878*^9, 3.411750480620823*^9}, {3.411750522088669*^9, 
   3.411750622275432*^9}, {3.4117506862145557`*^9, 3.411750729888049*^9}, 
   3.411750982601137*^9, {3.411751112137909*^9, 3.411751150680591*^9}, {
   3.4117511919122667`*^9, 3.4117513167469263`*^9}, {3.411751367828828*^9, 
   3.411751382419073*^9}, {3.411811298966631*^9, 3.411811326187975*^9}, {
   3.41181138891117*^9, 3.411811403203309*^9}, {3.412274934895339*^9, 
   3.4122750533106613`*^9}, {3.412275104990543*^9, 3.41227511008519*^9}, {
   3.412275150600514*^9, 3.412275184105116*^9}, {3.4122752301722927`*^9, 
   3.412275274939118*^9}, {3.4122753057096252`*^9, 3.412275310132764*^9}, {
   3.412275379536392*^9, 3.4122754704522*^9}, {3.412275503337247*^9, 
   3.4122755041927347`*^9}, 3.412275542403599*^9, {3.41227565754274*^9, 
   3.4122756582498417`*^9}, {3.4122757301072693`*^9, 3.412275742121007*^9}, {
   3.412275784998678*^9, 3.412275833096032*^9}, {3.412275947960984*^9, 
   3.41227596194221*^9}, {3.412276050708641*^9, 3.412276075197199*^9}, {
   3.412341370930374*^9, 3.412341448297298*^9}, {3.4123414785682077`*^9, 
   3.412341479137343*^9}, {3.412341511288123*^9, 3.4123415204909973`*^9}, {
   3.412341955198337*^9, 3.4123419962640142`*^9}, {3.412342655274766*^9, 
   3.4123426984643803`*^9}, {3.4127816683854733`*^9, 3.412781687260819*^9}, {
   3.413324128154437*^9, 3.4133241289650993`*^9}, {3.41332418212187*^9, 
   3.413324203206889*^9}, {3.413324578881542*^9, 3.413324579714937*^9}, {
   3.41389752701343*^9, 3.413897542722611*^9}, {3.4138976804595823`*^9, 
   3.41389771476439*^9}, {3.413897774661368*^9, 3.4138978104657173`*^9}, {
   3.413897843941231*^9, 3.4138978460824966`*^9}, {3.41389789856948*^9, 
   3.4138979181904497`*^9}, {3.413897963025228*^9, 3.4138979996439657`*^9}, {
   3.413898053587276*^9, 3.413898068020564*^9}, {3.4138981427723618`*^9, 
   3.413898147900141*^9}, {3.413898188013857*^9, 3.4138983114068413`*^9}, {
   3.4138984065139303`*^9, 3.413898497573852*^9}, {3.413898621053396*^9, 
   3.4138986224924183`*^9}, {3.4138986901451597`*^9, 
   3.4138987774254932`*^9}, {3.413898808169201*^9, 3.4138988533253527`*^9}, {
   3.413898909447117*^9, 3.413898909990423*^9}, {3.413898959507093*^9, 
   3.413898985216649*^9}, {3.4138990945061197`*^9, 3.413899136164723*^9}, {
   3.413900102366733*^9, 3.4139001239368668`*^9}, {3.414358568173295*^9, 
   3.414358572786212*^9}, {3.414359133031817*^9, 3.414359199105749*^9}, {
   3.414359246715426*^9, 3.414359306864193*^9}, {3.414361395053692*^9, 
   3.414361438088546*^9}, {3.414361472550667*^9, 3.414361521449841*^9}, {
   3.414361554060773*^9, 3.414361589631493*^9}, {3.414361627844035*^9, 
   3.4143617148356133`*^9}, {3.414361791632144*^9, 3.414361823628475*^9}, {
   3.4143618810997972`*^9, 3.414361911890684*^9}, {3.4143620438012342`*^9, 
   3.41436209971766*^9}, {3.414362328048938*^9, 3.414362344143695*^9}, {
   3.4143629853326683`*^9, 3.4143630159292593`*^9}, {3.4143630643346453`*^9, 
   3.4143630730603867`*^9}, {3.414363131358262*^9, 3.414363136043024*^9}, {
   3.414364068464672*^9, 3.414364070871717*^9}, {3.414364762063128*^9, 
   3.414364763949951*^9}, {3.41444771635968*^9, 3.414447719228635*^9}, 
   3.4144477723842897`*^9, 3.4144939654251347`*^9, {3.415569297825309*^9, 
   3.415569298304824*^9}, {3.4155693414186707`*^9, 3.415569346075089*^9}, {
   3.41556939547514*^9, 3.4155694059985437`*^9}, {3.41556949411371*^9, 
   3.4155695098360977`*^9}, {3.415571937517589*^9, 3.41557196366778*^9}, {
   3.421144266578437*^9, 3.4211443147491713`*^9}, {3.421144345378768*^9, 
   3.421144525018449*^9}, 3.4211446230499573`*^9, {3.421144658041556*^9, 
   3.421144690053976*^9}, {3.421144839742754*^9, 3.421144847428844*^9}, {
   3.421145079253008*^9, 3.421145103751737*^9}, {3.42114516263772*^9, 
   3.4211451777510653`*^9}, {3.421145244073029*^9, 3.421145247965982*^9}, {
   3.4211452808470993`*^9, 3.4211452812452393`*^9}, {3.42114534115658*^9, 
   3.421145500118544*^9}, {3.421145532485775*^9, 3.421145549079184*^9}, {
   3.421145592136424*^9, 3.421145622150424*^9}, {3.4211456741295652`*^9, 
   3.421145683143993*^9}, {3.421145777583165*^9, 3.42114578685364*^9}, {
   3.4214165438718*^9, 3.421416568884576*^9}, {3.421587689019102*^9, 
   3.421587715092291*^9}, {3.4215877702935057`*^9, 3.421587806568091*^9}, {
   3.4215885692738523`*^9, 3.4215886196353407`*^9}, {3.423777305180449*^9, 
   3.4237773958222513`*^9}, {3.423777433575522*^9, 3.423777437098939*^9}, 
   3.424351198795003*^9, {3.4243512372514877`*^9, 3.424351241726428*^9}, 
   3.424351272782687*^9, {3.424351401126972*^9, 3.4243514107053947`*^9}, {
   3.424351441990089*^9, 3.42435144580727*^9}, {3.424351512477159*^9, 
   3.4243515588968782`*^9}, {3.424351737441012*^9, 3.424351758595049*^9}, {
   3.42435214481203*^9, 3.424352158145849*^9}, {3.424352287086863*^9, 
   3.424352320786499*^9}, {3.424352433604273*^9, 3.4243524918238363`*^9}, {
   3.4243525311841793`*^9, 3.424352587148584*^9}, {3.424352674504727*^9, 
   3.4243526757251453`*^9}, {3.424352888186702*^9, 3.4243529268360043`*^9}, {
   3.424352973584195*^9, 3.424352974871789*^9}, 3.424353113140304*^9, {
   3.424353174934297*^9, 3.424353201087984*^9}, {3.424353232767284*^9, 
   3.4243533082489367`*^9}, {3.424353352425918*^9, 3.424353367290284*^9}, {
   3.424353422377387*^9, 3.424353477819116*^9}, {3.424353544289948*^9, 
   3.424353584536351*^9}, 3.424353629778943*^9, {3.424353710064672*^9, 
   3.4243537373061323`*^9}, 3.4243544547746553`*^9, {3.4243545711817293`*^9, 
   3.424354633972919*^9}, 3.424354673935013*^9, {3.4243547119262238`*^9, 
   3.424354733308875*^9}, {3.424354794628483*^9, 3.424354834671383*^9}, {
   3.4243548652432823`*^9, 3.4243548982733383`*^9}, {3.424354930833476*^9, 
   3.424354939005155*^9}, {3.424354976217244*^9, 3.424355017854538*^9}, {
   3.424355055954691*^9, 3.424355146258161*^9}, {3.424359434241007*^9, 
   3.4243594358127213`*^9}, {3.424359525762879*^9, 3.4243595291135883`*^9}, {
   3.4243601135809393`*^9, 3.424360147784477*^9}, {3.4243715488676*^9, 
   3.424371614148272*^9}, {3.424371713341381*^9, 3.4243717452993526`*^9}, {
   3.424371785548992*^9, 3.4243717944825974`*^9}, {3.4264426247899933`*^9, 
   3.4264427041059237`*^9}, {3.4267866029731784`*^9, 3.426786620207554*^9}, {
   3.4274678475378304`*^9, 3.427467942880109*^9}, {3.427468021079873*^9, 
   3.427468039400258*^9}, {3.427468072205634*^9, 3.4274680950746317`*^9}, {
   3.427468142198153*^9, 3.427468143489143*^9}, {3.427468189057556*^9, 
   3.427468237671206*^9}, {3.4274682870565147`*^9, 3.427468403158711*^9}, {
   3.4274684397199783`*^9, 3.427468469533276*^9}, 3.4274922959475107`*^9, {
   3.427492438691174*^9, 3.427492466132921*^9}, {3.42749254833676*^9, 
   3.4274925727465963`*^9}, {3.430495974211813*^9, 3.430495974650612*^9}, {
   3.4304960620813527`*^9, 3.4304960801034627`*^9}},
 CellID->952990542]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`distraction$$ = {1, 
    9}, $CellContext`fixate$$ = {-1, 8}, $CellContext`nodePercent$$ = 
    0.5, $CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fixate$$], {-1, 8}}, {-6, 5}, {6, 11}}, {{
       Hold[$CellContext`distraction$$], {1, 9}}, {-6, 5}, {6, 11}}, {{
       Hold[$CellContext`nodePercent$$], 0.5, "node percent"}, 0, 1.}, {{
       Hold[$CellContext`t$$], 0, "time t"}, -4, 4}}, Typeset`size$$ = {
    400., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`fixate$1872$$ = {0, 
    0}, $CellContext`distraction$1873$$ = {0, 
    0}, $CellContext`nodePercent$1874$$ = 0, $CellContext`t$1875$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`distraction$$ = {1, 
         9}, $CellContext`fixate$$ = {-1, 8}, $CellContext`nodePercent$$ = 
        0.5, $CellContext`t$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`fixate$$, $CellContext`fixate$1872$$, {0, 0}], 
        Hold[$CellContext`distraction$$, $CellContext`distraction$1873$$, {0, 
         0}], 
        Hold[$CellContext`nodePercent$$, $CellContext`nodePercent$1874$$, 0], 
        
        Hold[$CellContext`t$$, $CellContext`t$1875$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`nORM[
          PatternTest[
           Pattern[$CellContext`vector, 
            Blank[]], VectorQ]] := 
        Dot[$CellContext`vector, $CellContext`vector]^
         Rational[1, 2]; $CellContext`degrees[
          Pattern[$CellContext`q, 
           Blank[]]] := $CellContext`q (180/Pi); $CellContext`arcMinutes[
          Pattern[$CellContext`q, 
           Blank[]]] := ($CellContext`q 60) (180/Pi); $CellContext`aim\[Psi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[$CellContext`headAimVector, 1], 
          Part[$CellContext`headAimVector, 2]]; $CellContext`midPoint[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`base - ($CellContext`aimOffset \
$CellContext`interOcular) {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`base + ((
            1/2 - $CellContext`aimOffset) $CellContext`interOcular) {
            Part[$CellContext`headAimVector, 2], -
            Part[$CellContext`headAimVector, 1]}; $CellContext`leftEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := $CellContext`base - ((
           1/2 + $CellContext`aimOffset) $CellContext`interOcular) {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightViewVector[
         
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`right\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`rightEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base$, 
            Blank[]], 
           VectorQ]] := \
$CellContext`rightEyeCenter[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$$ $CellContext`eyeRadius) \
($CellContext`rightViewVector[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM[
            $CellContext`rightViewVector[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`leftViewVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`left\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`leftEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base$, 
            Blank[]], 
           VectorQ]] := \
$CellContext`leftEyeCenter[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$$ $CellContext`eyeRadius) \
($CellContext`leftViewVector[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM[
            $CellContext`leftViewVector[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`fixateConvergence[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate,
           $CellContext`base]; $CellContext`left\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - $CellContext`aim\[Psi][$CellContext`headAimVector, \
$CellContext`base]; $CellContext`right\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`aim\[Psi][$CellContext`headAimVector, $CellContext`base]; \
$CellContext`rightDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`rightEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`right\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`leftDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`leftEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`left\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`convergenceDistraction[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          Or[
          Abs[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3., 
           Abs[$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3.], 
          0., $CellContext`right\[Delta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; $CellContext`right\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]; $CellContext`left\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - $CellContext`left\[Delta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]; \
$CellContext`binocularDisparity[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 
          0, $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; \
$CellContext`right\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base$, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[Theta][$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$] + 
         ArcSin[$CellContext`nodePercent$$ Sin[
             $CellContext`right\[Theta][$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]]]; \
$CellContext`left\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base$, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[Theta][$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$] + 
         ArcSin[$CellContext`nodePercent$$ Sin[
             $CellContext`left\[Theta][$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]]]; \
$CellContext`retinalDisparity[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 
          0, $CellContext`right\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]; \
$CellContext`eyePict[
          PatternTest[
           Pattern[$CellContext`eyeCenter$, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate$, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`\[Lambda]$, $CellContext`viewVector$}, \
$CellContext`viewVector$ = $CellContext`fixate$ - $CellContext`eyeCenter$; \
$CellContext`\[Lambda]$ = ArcTan[
             Part[$CellContext`viewVector$, 1], 
             
             Part[$CellContext`viewVector$, 
              2]]; $CellContext`viewVector$ = \
$CellContext`viewVector$/$CellContext`nORM[$CellContext`viewVector$]; Show[{
             Graphics[{
               AbsoluteThickness[2], Gray, 
               
               Circle[$CellContext`eyeCenter$, $CellContext`eyeRadius, \
{$CellContext`\[Lambda]$ + 0.4, 2 Pi + $CellContext`\[Lambda]$ - 0.4}]}], 
             Graphics[{Gray, 
               
               Circle[$CellContext`eyeCenter$ + (
                  0.8 $CellContext`eyeRadius) $CellContext`viewVector$, 
                0.5 $CellContext`eyeRadius, {$CellContext`\[Lambda]$ - 
                 1.5, $CellContext`\[Lambda]$ + 1.5}]}], 
             Graphics[{Green, 
               
               Disk[$CellContext`eyeCenter$ + ($CellContext`eyeRadius \
$CellContext`nodePercent$$) $CellContext`viewVector$, $CellContext`eyeRadius/
                10]}]}, AspectRatio -> Automatic]]; $CellContext`eyeEdge[
          Pattern[$CellContext`\[Theta], 
           Blank[]]] := $CellContext`eyeRadius {
           Cos[$CellContext`\[Theta]], 
           Sin[$CellContext`\[Theta]]}; $CellContext`inRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           $CellContext`eyePict[
            $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           $CellContext`eyePict[
            $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           Graphics[{Red, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]/$CellContext`nORM[
                  $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Red, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`leftViewVector[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]/$CellContext`nORM[
                  $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Green, {
              Line[
               N[{
                 $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], 
                 $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base]}]]}}], $CellContext`min = 
            Min[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; $CellContext`MAX = 
            Max[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; Graphics[{Brown, 
              AbsoluteThickness[3], {
               Circle[
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`eyeRadius, {$CellContext`min, \
$CellContext`MAX}]}}]}, AspectRatio -> Automatic, PlotRange -> {{Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] + $CellContext`interOcular}, {Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] + $CellContext`interOcular}}]; $CellContext`outRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           Graphics[{Red, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`fixate]]}}], 
           Graphics[{Blue, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`distraction]]}}], 
           Graphics[{Red, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Red, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Blue, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Blue, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Green, {
              Line[
               N[{$CellContext`headAimVector, $CellContext`base}]]}}]}, 
          AspectRatio -> Automatic]; $CellContext`outLabels[
          PatternTest[
           Pattern[$CellContext`aimHead, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           Graphics[{Magenta, {
              Text[
               StringForm[
               "\!\(\*SubscriptBox[\(\[Theta]\), \(r\)]\) = `1`\[Degree]", 
                Round[
                 
                 N[(180/Pi) $CellContext`right\[Theta][$CellContext`aimHead, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]], 0.1]], {
                0.7, 0} + $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate, $CellContext`base] - (
                2.5 $CellContext`eyeRadius) \
(($CellContext`rightEyeCenter[$CellContext`aimHead, $CellContext`base] - \
$CellContext`distraction - \
$CellContext`fixate)/$CellContext`nORM[$CellContext`rightEyeCenter[$\
CellContext`aimHead, $CellContext`base] - $CellContext`distraction - \
$CellContext`fixate])], 
              Circle[
               $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate, $CellContext`base], 2.5 $CellContext`eyeRadius, {
                Min[
                 $CellContext`right\[Delta][$CellContext`aimHead, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
                 $CellContext`right\[CurlyPhi][$CellContext`aimHead, \
$CellContext`fixate, $CellContext`base]], 
                Max[
                 $CellContext`right\[Delta][$CellContext`aimHead, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
                 $CellContext`right\[CurlyPhi][$CellContext`aimHead, \
$CellContext`fixate, $CellContext`base]]}]}}]}, AspectRatio -> 
          Automatic]; $CellContext`interOcular = 6.5; $CellContext`eyeRadius = 
        1.3; $CellContext`aimOffset = 0; $CellContext`base[
          Pattern[$CellContext`t, 
           Blank[]]] = {$CellContext`t, 0}; $CellContext`aimHead = {0, 
         1}; $CellContext`f = Part[$CellContext`fixate$$, 2]; Show[{
          $CellContext`inRays[$CellContext`aimHead, $CellContext`fixate$$, \
$CellContext`distraction$$, 
           $CellContext`base[$CellContext`t$$]], 
          $CellContext`outLabels[$CellContext`aimHead, $CellContext`fixate$$, \
$CellContext`distraction$$, 
           $CellContext`base[$CellContext`t$$]], 
          Graphics[{
            AbsolutePointSize[4], 
            Point[
             $CellContext`midPoint[$CellContext`aimHead, 
              $CellContext`base[$CellContext`t$$]]]}], 
          Graphics[{Green, 
            AbsolutePointSize[4], {
             Point[
              $CellContext`base[$CellContext`t$$]], 
             Text["B", $CellContext`base[$CellContext`t$$] - {0, 0.5}], 
             Text[
             "A", 1.05 $CellContext`aimHead + {
               0, 0.5} + $CellContext`base[$CellContext`t$$]], 
             Line[{
               $CellContext`base[$CellContext`t$$], $CellContext`aimHead + \
$CellContext`base[$CellContext`t$$], $CellContext`base[$CellContext`t$$] + {
                0.1, 0.7}}]}}], 
          Graphics[{Orange, {
             Circle[
              $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
               $CellContext`base[$CellContext`t$$]], 
              1.5 $CellContext`eyeRadius, {
               Min[{
                 $CellContext`aim\[Psi][$CellContext`aimHead, 
                  $CellContext`base[$CellContext`t$$]], 
                 $CellContext`right\[CurlyPhi][$CellContext`aimHead, \
$CellContext`fixate$$, 
                  $CellContext`base[$CellContext`t$$]]}], 
               Max[{
                 $CellContext`aim\[Psi][$CellContext`aimHead, 
                  $CellContext`base[$CellContext`t$$]], 
                 $CellContext`right\[CurlyPhi][$CellContext`aimHead, \
$CellContext`fixate$$, 
                  $CellContext`base[$CellContext`t$$]]}]}], 
             Line[{
               $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]], \
$CellContext`rightEyeNode[$CellContext`aimHead, $CellContext`fixate$$, 
                 $CellContext`base[$CellContext`t$$]] + 
               3 $CellContext`aimHead}], 
             Text[
              StringForm[
              "\!\(\*SubscriptBox[\(\[Alpha]\), \(r\)]\) = `1` \[Degree]", 
               Round[
                
                N[$CellContext`right\[Alpha][$CellContext`aimHead, \
$CellContext`fixate$$, 
                   $CellContext`base[$CellContext`t$$]] (180/Pi)], 
                0.1]], $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]] + 
              2 $CellContext`aimHead + {0.8, 0}]}}], 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Point[$CellContext`fixate$$], 
             Text[
              StringForm["F = (`1`  ,  `2`)", 
               Round[
                Part[$CellContext`fixate$$, 1], 0.01], 
               Round[
                Part[$CellContext`fixate$$, 2], 
                0.01]], $CellContext`fixate$$ + {-1, 0.5}], 
             Line[{
               $CellContext`leftEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]], $CellContext`fixate$$}], 
             Line[{
               $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]], \
$CellContext`fixate$$}]}}], 
          Graphics[{Blue, 
            AbsolutePointSize[5], {
             Point[$CellContext`distraction$$], 
             Text[
              StringForm["D = (`1`  ,  `2`)", 
               Round[
                Part[$CellContext`distraction$$, 1], 0.01], 
               Round[
                Part[$CellContext`distraction$$, 2]], 
               0.01], $CellContext`distraction$$ + {-1, 0.5}], 
             Line[{
               $CellContext`leftEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]], \
$CellContext`distraction$$}], 
             Line[{
               $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]], \
$CellContext`distraction$$}]}}], 
          Graphics[{Brown, {
             Text[
              StringForm[
              "\!\(\*SubscriptBox[\(\[Beta]\), \(r\)]\) = `1` \[Degree]", 
               Round[
                
                N[($CellContext`right\[Alpha][$CellContext`aimHead, \
$CellContext`fixate$$, 
                    $CellContext`base[$CellContext`t$$]] - $CellContext`right\
\[Theta][$CellContext`aimHead, $CellContext`fixate$$, \
$CellContext`distraction$$, 
                   $CellContext`base[$CellContext`t$$]]) (180/Pi)], 
                0.1]], $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
                $CellContext`base[$CellContext`t$$]] + {-0.6, 0} - (
               2. $CellContext`eyeRadius) \
(($CellContext`rightEyeNode[$CellContext`aimHead, $CellContext`fixate$$, 
                  $CellContext`base[$CellContext`t$$]] - \
$CellContext`distraction$$)/$CellContext`nORM[$CellContext`rightEyeNode[$\
CellContext`aimHead, $CellContext`fixate$$, 
                  $CellContext`base[$CellContext`t$$]] - \
$CellContext`distraction$$])], 
             Circle[
              $CellContext`rightEyeNode[$CellContext`aimHead, \
$CellContext`fixate$$, 
               $CellContext`base[$CellContext`t$$]], 
              2. $CellContext`eyeRadius, {
               Min[{
                 $CellContext`aim\[Psi][$CellContext`aimHead, 
                  $CellContext`base[$CellContext`t$$]], 
                 $CellContext`right\[Delta][$CellContext`aimHead, \
$CellContext`fixate$$, $CellContext`distraction$$, 
                  $CellContext`base[$CellContext`t$$]]}], 
               Max[{
                 $CellContext`aim\[Psi][$CellContext`aimHead, 
                  $CellContext`base[$CellContext`t$$]], 
                 $CellContext`right\[Delta][$CellContext`aimHead, \
$CellContext`fixate$$, $CellContext`distraction$$, 
                  $CellContext`base[$CellContext`t$$]]}]}]}}], 
          Graphics[{
            AbsoluteThickness[2], 
            Dashing[0.025], Gray, {
             
             Arrow[{$CellContext`base[$CellContext`t$$] + {-1, -1}, \
$CellContext`base[$CellContext`t$$] + {1, -1}}]}}], 
          Graphics[{
            Text[
            "Translation", $CellContext`base[$CellContext`t$$] + {-0.1, \
-1.5}]}]}, PlotRange -> {2 {-3.25, 3.25}, {-2, 12}}, AspectRatio -> Automatic,
          ImageSize -> {400, 400}]), 
      "Specifications" :> {{{$CellContext`fixate$$, {-1, 8}}, {-6, 5}, {6, 
         11}, ControlType -> 
         Locator}, {{$CellContext`distraction$$, {1, 9}}, {-6, 5}, {6, 11}, 
         ControlType -> 
         Locator}, {{$CellContext`nodePercent$$, 0.5, "node percent"}, 0, 1., 
         Appearance -> "Labeled"}, {{$CellContext`t$$, 0, "time t"}, -4, 4, 
         Appearance -> "Labeled"}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{451., {259., 264.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->122780320],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "We study the case of an observer moving at right angles to the aim of the \
head, fixing his eyes on a (fixate) point F and also observing a distractor \
D. The important angles for depth perception by motion parallax are ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ". The angle ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", 
    RowBox[{"\[Alpha]", "-", "\[Theta]"}]}], TraditionalForm]], 
  "InlineMath"],
 " is mathematically helpful. "
}], "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "To animate motion in time, click the [+] next to the \"time ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 "\" slider and click play [>]. The changing position of the distractor on \
the retina is \"motion parallax\"."
}], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "Fixation on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F",
     FontSlant->"Plain"], 
    StyleBox["=",
     FontWeight->"Plain"], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "f"}], ")"}],
     FontWeight->"Plain"]}], TraditionalForm]], "InlineMath"],
 " causes the eyes to rotate because of the observer's continuous \
translation. We measure the tracking angle ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " counterclockwise (+) from the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis (head aim direction) and call the time rate of change needed to \
maintain fixation the \"pursuit\". This is ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], 
    RowBox[{"d", "\[VeryThinSpace]", "t"}]], TraditionalForm]], 
  "InlineMath"],
 ", the time derivative in the sense of calculus. "
}], "Text"],

Cell[TextData[{
 "In terms of the ",
 ButtonBox["eye parameters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
EyeParametersVisualDepthPerception6/"], None}],
 " ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " = node percent, ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " = interocular distance, and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " = eye radius, the derivative is"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
       RowBox[{"(", "t", ")"}]}], " ", "=", 
      FractionBox[
       RowBox[{"i", " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"n", " ", "r"}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"f", "+", 
           RowBox[{"n", " ", "r"}]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["i", "2"], " ", 
         SuperscriptBox["t", "2"]}]}]]}], TraditionalForm]]]], "InlineMath"], 
   "."}], TraditionalForm]], "Text"],

Cell[TextData[{
 "This peaks at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " (when the denominator is largest):"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
       RowBox[{"(", "0", ")"}]}], " ", "=", 
      FractionBox["i", 
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}]]}], TraditionalForm]]]], "InlineMath"], 
   "."}], TraditionalForm]], "Text"],

Cell[TextData[{
 "The observer's translation also causes the angle separating the fixate and \
distraction to change, causing motion of the image of D on the retina. The \
time rate of change in angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " from the distractor to the fixate is a \"dynamic parallax\" describing the \
moving retinal image of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["D",
     FontSlant->"Plain"], "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["d", "1"], 
      StyleBox[",",
       FontWeight->"Plain"], 
      StyleBox[
       SubscriptBox["d", "2"],
       FontWeight->"Plain"]}], 
     StyleBox[")",
      FontWeight->"Plain"]}]}], TraditionalForm]], "InlineMath"],
 ". This derivative is"
}], "Text"],

Cell[BoxData[
 FormBox[Cell[TextData[Cell[BoxData[
   FormBox[
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[VeryThinSpace]", "t"}]], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"i", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"n", " ", "r"}]}], ")"}], " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["f", "2"], "+", 
             RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["i", "2"], " ", 
              SuperscriptBox["t", "2"]}]}]], " ", 
           SubsuperscriptBox["d", "1", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["n", "3"]}], " ", 
              SuperscriptBox["r", "3"]}], "+", 
             RowBox[{
              SuperscriptBox["n", "2"], " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["f", "2"], "+", 
                RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                RowBox[{
                 SuperscriptBox["n", "2"], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["i", "2"], " ", 
                 SuperscriptBox["t", "2"]}]}]], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "f", " ", "n", " ", 
              RowBox[{"(", 
               RowBox[{
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["f", "2"], "+", 
                  RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                  RowBox[{
                   SuperscriptBox["n", "2"], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{
                   SuperscriptBox["i", "2"], " ", 
                   SuperscriptBox["t", "2"]}]}]], "-", 
                RowBox[{"n", " ", "r"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SqrtBox[
                 RowBox[{
                  SuperscriptBox["f", "2"], "+", 
                  RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                  RowBox[{
                   SuperscriptBox["n", "2"], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{
                   SuperscriptBox["i", "2"], " ", 
                   SuperscriptBox["t", "2"]}]}]], "-", 
                RowBox[{"n", " ", "r"}]}], ")"}]}], "-", 
             RowBox[{
              SuperscriptBox["i", "2"], " ", 
              SuperscriptBox["t", "2"], " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["f", "2"], "+", 
                RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                RowBox[{
                 SuperscriptBox["n", "2"], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["i", "2"], " ", 
                 SuperscriptBox["t", "2"]}]}]]}]}], ")"}], " ", 
           SubscriptBox["d", "1"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"n", " ", "r"}]}], ")"}], " ", 
           SubscriptBox["d", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"i", " ", "t", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox["f", "2"], "+", 
                   RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                   RowBox[{
                    SuperscriptBox["n", "2"], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{
                    SuperscriptBox["i", "2"], " ", 
                    SuperscriptBox["t", "2"]}]}]]}], "-", 
                RowBox[{"n", " ", "r"}]}], ")"}]}], "+", 
             RowBox[{
              SqrtBox[
               RowBox[{
                SuperscriptBox["f", "2"], "+", 
                RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                RowBox[{
                 SuperscriptBox["n", "2"], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["i", "2"], " ", 
                 SuperscriptBox["t", "2"]}]}]], " ", 
              SubscriptBox["d", "2"]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox["f", "2"], "+", 
           RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
           RowBox[{
            SuperscriptBox["n", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["i", "2"], " ", 
            SuperscriptBox["t", "2"]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}]}], ")"}], " ", 
            SubsuperscriptBox["d", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"f", "+", 
              RowBox[{"n", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}], "-", 
              RowBox[{"n", " ", "r", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                 RowBox[{
                  SuperscriptBox["n", "2"], " ", 
                  SuperscriptBox["r", "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["i", "2"], " ", 
                  SuperscriptBox["t", "2"]}]}]]}]}], ")"}], " ", 
            SubscriptBox["d", "1"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}]}], ")"}], " ", 
            SubsuperscriptBox["d", "2", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}], "-", 
              RowBox[{"2", " ", "n", " ", "r", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                 RowBox[{
                  SuperscriptBox["n", "2"], " ", 
                  SuperscriptBox["r", "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["i", "2"], " ", 
                  SuperscriptBox["t", "2"]}]}]]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "i", " ", "t", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["f", "2"], "+", 
              RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
              RowBox[{
               SuperscriptBox["n", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["i", "2"], " ", 
               SuperscriptBox["t", "2"]}], "-", 
              RowBox[{"n", " ", "r", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox["f", "2"], "+", 
                 RowBox[{"2", " ", "n", " ", "r", " ", "f"}], "+", 
                 RowBox[{
                  SuperscriptBox["n", "2"], " ", 
                  SuperscriptBox["r", "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["i", "2"], " ", 
                  SuperscriptBox["t", "2"]}]}]]}]}], ")"}], " ", 
            SubscriptBox["d", "2"]}]}], ")"}]}], ")"}], "."}]}]}], 
    TraditionalForm]]]], "InlineMath"], TraditionalForm]], "Text"],

Cell[TextData[{
 "This simplifies greatly at the time ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", when the eye crosses the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "1"], TraditionalForm]], "InlineMath"],
 " axis:"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
       RowBox[{"(", "0", ")"}]}], " ", "=", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["d", "1"], "2"], "+", 
          SuperscriptBox[
           SubscriptBox["d", "2"], "2"], "+", 
          RowBox[{
           SubscriptBox["d", "1"], " ", "f"}]}], ")"}], " ", "i"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["d", "1"], "+", "f"}], ")"}], "2"], "+", 
          SuperscriptBox[
           SubscriptBox["d", "2"], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]]]], 
    "InlineMath"], "."}], TraditionalForm]], "Text"],

Cell[TextData[{
 "When the distraction is in line with the eye, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["d", "2"], "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
    RowBox[{"(", "0", ")"}]}], TraditionalForm]], "InlineMath"],
 " has the simple form "
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[Cell[TextData[Cell[BoxData[
   FormBox[
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
       RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
      RowBox[{"(", "0", ")"}]}], " ", "=", 
     FractionBox[
      RowBox[{"i", " ", 
       SubscriptBox["d", "1"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["d", "1"], "+", "f"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"f", "+", 
         RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]]]], 
   "InlineMath"], TraditionalForm]]]], "Text"],

Cell["and the ratio of retinal motion over pursuit is", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}]], 
       RowBox[{"(", "0", ")"}]}], " ", "=", 
      FractionBox[
       SubscriptBox["d", "1"], 
       RowBox[{"f", "+", 
        SubscriptBox["d", "1"]}]]}], TraditionalForm]]]], "InlineMath"], 
   "."}], TraditionalForm]], "Text"],

Cell["\<\
The basic case of the motion/pursuit law for relative depth from motion \
parallax is\
\>", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      FractionBox[
       SubscriptBox["d", "1"], "f"], "=", 
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "\[Beta]"}]], "=", 
       RowBox[{
        FractionBox[
         RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
         RowBox[{
          RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], "-", 
          RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}]}]], "=", 
        RowBox[{
         FractionBox[
          RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
          RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}]], 
         FractionBox["1", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
            RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}]]}]]}]}]}]}], 
     TraditionalForm]]]], "InlineMath"], "."}], TraditionalForm]], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Tracking and Separation (Visual Depth Perception 11)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
TrackingAndSeparationVisualDepthPerception11"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Tracking and Separation (Visual Depth Perception 11) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[654, 23, 172, 3, 70, "Section"],
Cell[829, 28, 3700, 64, 70, "Section"],
Cell[4532, 94, 65298, 1500, 70, "Input",
 CellID->952990542]
}, Open  ]],
Cell[CellGroupData[{
Cell[69867, 1599, 37672, 838, 70, "Output",
 CellID->122780320],
Cell[CellGroupData[{
Cell[107564, 2441, 209, 6, 70, "Section"],
Cell[107776, 2449, 591, 16, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[108393, 2469, 269, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[108687, 2479, 209, 6, 70, "Section"],
Cell[108899, 2487, 940, 29, 70, "Text"],
Cell[109842, 2518, 502, 17, 70, "Text"],
Cell[110347, 2537, 739, 23, 70, "Text"],
Cell[111089, 2562, 173, 6, 70, "Text"],
Cell[111265, 2570, 436, 13, 70, "Text"],
Cell[111704, 2585, 782, 24, 70, "Text"],
Cell[112489, 2611, 9640, 244, 70, "Text"],
Cell[122132, 2857, 285, 10, 70, "Text"],
Cell[122420, 2869, 1035, 32, 70, "Text"],
Cell[123458, 2903, 446, 15, 70, "Text"],
Cell[123907, 2920, 623, 19, 70, "Text"],
Cell[124533, 2941, 63, 0, 70, "Text"],
Cell[124599, 2943, 469, 14, 70, "Text"],
Cell[125071, 2959, 109, 3, 70, "Text"],
Cell[125183, 2964, 986, 26, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[126205, 2995, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[126563, 3006, 1067, 31, 70, "Text"],
Cell[127633, 3039, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[128113, 3058, 815, 24, 70, "Text"],
Cell[128931, 3084, 1216, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature FQ4bW#kK2561LBpSW#RWhMnH *)
