(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     63892,       1541]
NotebookOptionsPosition[     62610,       1492]
NotebookOutlinePosition[     63255,       1517]
CellTagsIndexPosition[     63212,       1514]
WindowTitle->Ray Tracing With Lenses - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Ray Tracing With Lenses", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"converginglens", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "1.3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1", "/", "1.3"}], "]"}]}], ",", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"1", "/", "1.3"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", "1.3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1", "/", "1.3"}], "]"}]}], ",", 
         RowBox[{"\[Pi]", "+", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1", "/", "1.3"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"diverginglens", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", "1.3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1.02", "/", "1.3"}], "]"}]}], ",", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"1.02", "/", "1.3"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.5", ",", "0"}], "}"}], ",", "1.3", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1.02", "/", "1.3"}], "]"}]}], ",", 
         RowBox[{"\[Pi]", "+", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"1.02", "/", "1.3"}], "]"}]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".48"}], ",", ".8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".48", ",", ".8"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".48"}], ",", 
          RowBox[{"-", ".8"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".48", ",", 
          RowBox[{"-", ".8"}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.36043588389747*^9, 3.36043593566092*^9}, {
   3.36043597458302*^9, 3.36043597605318*^9}, {3.36043701894539*^9, 
   3.36043707150228*^9}, {3.36043729496104*^9, 3.36043732166496*^9}, {
   3.36043735238633*^9, 3.36043745566649*^9}, {3.3604384530728*^9, 
   3.36043852987397*^9}, {3.36043856360331*^9, 3.36043856609044*^9}, {
   3.36043861453519*^9, 3.36043863985174*^9}, {3.36043883307175*^9, 
   3.36043883558094*^9}, {3.36043909534745*^9, 3.36043921645607*^9}, {
   3.36051247346832*^9, 3.36051248448816*^9}, 3.36051293741761*^9, 
   3.36051505897697*^9},
 CellID->1139161038],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lenstype", "\[Equal]", "\"\<converging\>\""}], ",", 
         RowBox[{"(", 
          RowBox[{"{", 
           RowBox[{"converginglens", ",", "converginglens", ",", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "n"}], ",", "0"}], "}"}], "]"}]}], "}"}], 
             "]"}]}], "}"}], ")"}], ",", 
         RowBox[{"{", 
          RowBox[{"diverginglens", ",", "diverginglens"}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrowheads", "[", 
          RowBox[{".05", " ", "size"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"itempos", ",", 
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"size", "/", "2"}], ")"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"itempos", ",", 
              RowBox[{"size", "/", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"fromtoppara", "\[Equal]", "True"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0", ",", ".5", ",", "0"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "2"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"size", "/", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"itempos", ",", 
            RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lenstype", "\[Equal]", "\"\<converging\>\""}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"fromtoppara", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"RGBColor", "[", 
                RowBox[{"0", ",", ".5", ",", "0"}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "n"}], ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"frombotpara", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"RGBColor", "[", 
                RowBox[{".4", ",", ".4", ",", ".8"}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "n"}], ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"fromtopfoc", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{"Purple", ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"itempos", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"frombotfoc", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"RGBColor", "[", 
                RowBox[{"1", ",", ".6", ",", "0"}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"itempos", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"n", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"showanswer", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thick", ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{
                 RowBox[{"-", ".05"}], " ", "n", " ", 
                 RowBox[{"size", "/", 
                  RowBox[{"(", 
                   RowBox[{"n", "-", "itempos"}], ")"}]}]}], "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"thrucenter", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Black", ",", "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Black", ",", "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}]}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"fromtoppara", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"RGBColor", "[", 
                RowBox[{"0", ",", ".5", ",", "0"}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"2", ",", 
                    RowBox[{
                    RowBox[{"size", "/", 
                    RowBox[{"-", "n"}]}], "+", 
                    RowBox[{"size", "/", "2"}]}]}], "}"}]}], "}"}], "]"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0", ",", ".5", ",", "0"}], "]"}], ",", "Dashed", 
                 ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"n", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"frombotpara", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{".4", ",", ".4", ",", ".8"}], "]"}], ",", "Dashed", 
                 ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"n", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{".4", ",", ".4", ",", ".8"}], "]"}], ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{
                    RowBox[{"size", "/", "n"}], "-", 
                    RowBox[{"size", "/", "2"}]}]}], "}"}]}], "}"}], "]"}]}], 
                "}"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"fromtopfoc", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Purple", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"n", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Purple", ",", "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"frombotfoc", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"1", ",", ".6", ",", "0"}], "]"}], ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"n", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}], ",", 
               RowBox[{"RGBColor", "[", 
                RowBox[{"1", ",", ".6", ",", "0"}], "]"}], ",", "Dashed", ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"thrucenter", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Black", ",", "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{"size", "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Black", ",", "Dashed", ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"itempos", ",", 
                    RowBox[{
                    RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", "itempos"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"showanswer", "\[Equal]", "True"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thick", ",", 
               RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{
                 RowBox[{"-", ".05"}], " ", "n", " ", 
                 RowBox[{"size", "/", 
                  RowBox[{"(", 
                   RowBox[{"n", "-", "itempos"}], ")"}]}]}], "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"itempos", " ", "n"}], 
                    RowBox[{
                    RowBox[{"-", "itempos"}], "+", "n"}]]}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", " ", 
                    RowBox[{"size", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "itempos"}], ")"}]}]}], "}"}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}]}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"frombotpara", "\[Equal]", "True"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{".4", ",", ".4", ",", ".8"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"itempos", ",", 
                RowBox[{
                 RowBox[{"-", "size"}], "/", "2"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{
                 RowBox[{"-", "size"}], "/", "2"}]}], "}"}]}], "}"}], "]"}]}],
           "}"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"itempos", ",", 
            RowBox[{"size", "/", "3"}]}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"showanswer", "!=", "True"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"itempos", ",", 
            RowBox[{"size", "/", "3"}]}], "}"}], "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.2"}], ",", "3.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"showanswer", "\[Equal]", "True"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lenstype", "\[Equal]", "\"\<converging\>\""}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<The image is real.\>\"", ",", "14", ",", "\"\<Label\>\""}], 
           "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<The image is virtual.\>\"", ",", "\"\<Label\>\"", ",", "14"}],
            "]"}]}], "]"}], ",", "\"\< \>\""}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"500", ",", "234"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"-", ".85"}], ",", "\"\<focal length\>\""}], "}"}], ",", 
     RowBox[{"-", ".5"}], ",", 
     RowBox[{"-", "1.05"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "lenstype", ",", "\"\<converging\>\"", ",", "\"\<lens type\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<converging\>\"", ",", "\"\<diverging\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"size", ",", ".6", ",", "\"\<object size\>\""}], "}"}], ",", 
     ".3", ",", ".8", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"itempos", ",", 
       RowBox[{"-", "2"}], ",", "\"\<object position\>\""}], "}"}], ",", 
     RowBox[{"-", "2.4"}], ",", 
     RowBox[{"-", "1.6"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fromtoppara", ",", "True", ",", "\"\<parallel from top\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "frombotpara", ",", "True", ",", "\"\<parallel from bottom\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "fromtopfoc", ",", "True", ",", 
       "\"\<through focal point from top\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "frombotfoc", ",", "True", ",", 
       "\"\<through focal point from bottom\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "thrucenter", ",", "True", ",", "\"\<rays through lens center\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "showanswer", ",", "False", ",", "\"\<show perceived image\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Top"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35757176568782*^9, 3.36051305692323*^9, {3.36051310545807*^9, 
   3.36051312222075*^9}, {3.36051366823842*^9, 3.36051377514135*^9}, {
   3.36051431988308*^9, 3.36051433530704*^9}, {3.36559989282968*^9, 
   3.36560005698593*^9}, {3.36560013153281*^9, 3.36560024836093*^9}, {
   3.36560028359531*^9, 3.36560039470468*^9}, {3.36560055542343*^9, 
   3.36560059232968*^9}, {3.36560087673593*^9, 3.36560090036093*^9}, {
   3.36560093556406*^9, 3.36560094726718*^9}, {3.36560098904843*^9, 
   3.36560100459531*^9}, {3.36560123507968*^9, 3.36560123698593*^9}, {
   3.36784843373923*^9, 3.36784848553578*^9}, {3.36784852126993*^9, 
   3.36784852744176*^9}, {3.36784858219141*^9, 3.36784858570701*^9}, {
   3.36784863092547*^9, 3.36784863919105*^9}, {3.36784867689393*^9, 
   3.36784867740955*^9}, {3.36784876879959*^9, 3.36784876940896*^9}, {
   3.36784881811178*^9, 3.36784886145525*^9}, {3.36784894998593*^9, 
   3.36784897628264*^9}, {3.36784900804806*^9, 3.36784903454789*^9}, {
   3.36784916045333*^9, 3.36784916498456*^9}, {3.36839157095313*^9, 
   3.36839158151563*^9}, {3.369098853625*^9, 3.36909885625*^9}, {
   3.369098913*^9, 3.3690989164375*^9}, {3.3701181029375*^9, 
   3.370118115421875*^9}, {3.370118258890625*^9, 3.37011826278125*^9}, {
   3.3792626481019635`*^9, 3.37926271196093*^9}, {3.3792627606324935`*^9, 
   3.3792627945854015`*^9}, {3.3792628456631994`*^9, 
   3.3792629431157007`*^9}, {3.381857050983868*^9, 3.381857051546368*^9}},
 CellID->1496021318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`frombotfoc$$ = 
    True, $CellContext`frombotpara$$ = True, $CellContext`fromtopfoc$$ = 
    True, $CellContext`fromtoppara$$ = 
    True, $CellContext`itempos$$ = -2, $CellContext`lenstype$$ = 
    "converging", $CellContext`n$$ = -0.85, $CellContext`showanswer$$ = 
    False, $CellContext`size$$ = 0.6, $CellContext`thrucenter$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], -0.85, "focal length"}, -0.5, -1.05}, {{
       Hold[$CellContext`lenstype$$], "converging", "lens type"}, {
      "converging", "diverging"}}, {{
       Hold[$CellContext`size$$], 0.6, "object size"}, 0.3, 0.8}, {{
       Hold[$CellContext`itempos$$], -2, "object position"}, -2.4, -1.6}, {{
       Hold[$CellContext`fromtoppara$$], True, "parallel from top"}, {
      True, False}}, {{
       Hold[$CellContext`frombotpara$$], True, "parallel from bottom"}, {
      True, False}}, {{
       Hold[$CellContext`fromtopfoc$$], True, 
       "through focal point from top"}, {True, False}}, {{
       Hold[$CellContext`frombotfoc$$], True, 
       "through focal point from bottom"}, {True, False}}, {{
       Hold[$CellContext`thrucenter$$], True, "rays through lens center"}, {
      True, False}}, {{
       Hold[$CellContext`showanswer$$], False, "show perceived image"}, {
      True, False}}}, Typeset`size$$ = {500., {115., 119.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`n$35467$$ = 0, $CellContext`lenstype$35468$$ = 
    False, $CellContext`size$35469$$ = 0, $CellContext`itempos$35470$$ = 
    0, $CellContext`fromtoppara$35471$$ = 
    False, $CellContext`frombotpara$35472$$ = 
    False, $CellContext`fromtopfoc$35473$$ = 
    False, $CellContext`frombotfoc$35474$$ = 
    False, $CellContext`thrucenter$35475$$ = 
    False, $CellContext`showanswer$35476$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`frombotfoc$$ = 
        True, $CellContext`frombotpara$$ = True, $CellContext`fromtopfoc$$ = 
        True, $CellContext`fromtoppara$$ = 
        True, $CellContext`itempos$$ = -2, $CellContext`lenstype$$ = 
        "converging", $CellContext`n$$ = -0.85, $CellContext`showanswer$$ = 
        False, $CellContext`size$$ = 0.6, $CellContext`thrucenter$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$35467$$, 0], 
        Hold[$CellContext`lenstype$$, $CellContext`lenstype$35468$$, False], 
        Hold[$CellContext`size$$, $CellContext`size$35469$$, 0], 
        Hold[$CellContext`itempos$$, $CellContext`itempos$35470$$, 0], 
        Hold[$CellContext`fromtoppara$$, $CellContext`fromtoppara$35471$$, 
         False], 
        Hold[$CellContext`frombotpara$$, $CellContext`frombotpara$35472$$, 
         False], 
        Hold[$CellContext`fromtopfoc$$, $CellContext`fromtopfoc$35473$$, 
         False], 
        Hold[$CellContext`frombotfoc$$, $CellContext`frombotfoc$35474$$, 
         False], 
        Hold[$CellContext`thrucenter$$, $CellContext`thrucenter$35475$$, 
         False], 
        Hold[$CellContext`showanswer$$, $CellContext`showanswer$35476$$, 
         False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         If[$CellContext`lenstype$$ == 
          "converging", {$CellContext`converginglens, \
$CellContext`converginglens, 
           Dynamic[{Red, 
             
             Point[{-$CellContext`n$$, 
               0}]}]}, {$CellContext`diverginglens, \
$CellContext`diverginglens}], 
         Dynamic[{Red, 
           Point[{$CellContext`n$$, 0}]}], {Thick, 
          Arrowheads[0.05 $CellContext`size$$], 
          Arrow[{{$CellContext`itempos$$, -($CellContext`size$$/
              2)}, {$CellContext`itempos$$, $CellContext`size$$/2}}]}, 
         Point[{0, 0}], 
         If[$CellContext`fromtoppara$$ == True, {
           RGBColor[0, 0.5, 0], 
           
           Line[{{$CellContext`itempos$$, $CellContext`size$$/2}, {
             0, $CellContext`size$$/2}}]}, 
          Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
         If[$CellContext`lenstype$$ == "converging", {
           If[$CellContext`fromtoppara$$ == True, {
             RGBColor[0, 0.5, 0], 
             
             Line[{{0, $CellContext`size$$/2}, {-$CellContext`n$$, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
($CellContext`n$$ ($CellContext`size$$/
                  2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`frombotpara$$ == True, {
             RGBColor[0.4, 0.4, 0.8], 
             
             Line[{{0, (-$CellContext`size$$)/2}, {-$CellContext`n$$, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
(-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`fromtopfoc$$ == True, {Purple, 
             
             Line[{{$CellContext`itempos$$, $CellContext`size$$/
                2}, {$CellContext`n$$, 0}, {
               0, ($CellContext`n$$ ($CellContext`size$$/
                  2))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{($CellContext`n$$ $CellContext`itempos$$)/($CellContext`n$$ - \
$CellContext`itempos$$), ($CellContext`n$$ ($CellContext`size$$/
                  2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`frombotfoc$$ == True, {
             RGBColor[1, 0.6, 0], 
             Line[{{$CellContext`itempos$$, (-$CellContext`size$$)/
                2}, {$CellContext`n$$, 0}, {
               0, (-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{($CellContext`n$$ $CellContext`itempos$$)/($CellContext`n$$ - \
$CellContext`itempos$$), (-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`showanswer$$ == True, {Thick, 
             
             Arrowheads[(-0.05) $CellContext`n$$ \
($CellContext`size$$/($CellContext`n$$ - $CellContext`itempos$$))], 
             
             Arrow[{{($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
(-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{($CellContext`n$$ $CellContext`itempos$$)/($CellContext`n$$ - \
$CellContext`itempos$$), ($CellContext`n$$ ($CellContext`size$$/
                  2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`thrucenter$$ == True, {{Black, Dashed, 
              
              Line[{{$CellContext`itempos$$, $CellContext`size$$/2}, {0, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, {
             Black, Dashed, 
              
              Line[{{$CellContext`itempos$$, (-$CellContext`size$$)/2}, {0, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
(-($CellContext`n$$ ($CellContext`size$$/
                    2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]]}, {
           If[$CellContext`fromtoppara$$ == True, {
             RGBColor[0, 0.5, 0], 
             
             Line[{{0, $CellContext`size$$/2}, {
               
               2, $CellContext`size$$/(-$CellContext`n$$) + \
$CellContext`size$$/2}}], {
              RGBColor[0, 0.5, 0], Dashed, 
              
              Line[{{0, $CellContext`size$$/2}, {$CellContext`n$$, 
                 0}, {-($CellContext`itempos$$ \
$CellContext`n$$/(-$CellContext`itempos$$ + $CellContext`n$$)), \
($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`frombotpara$$ == True, {{
              RGBColor[0.4, 0.4, 0.8], Dashed, 
              
              Line[{{0, (-$CellContext`size$$)/2}, {$CellContext`n$$, 
                 0}, {-($CellContext`itempos$$ \
$CellContext`n$$/(-$CellContext`itempos$$ + $CellContext`n$$)), \
(-($CellContext`n$$ ($CellContext`size$$/
                    2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, {
              RGBColor[0.4, 0.4, 0.8], 
              
              Line[{{0, (-$CellContext`size$$)/2}, {
                2, $CellContext`size$$/$CellContext`n$$ - $CellContext`size$$/
                 2}}]}}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`fromtopfoc$$ == True, {{Purple, 
              
              Line[{{$CellContext`itempos$$, $CellContext`size$$/
                 2}, {$CellContext`n$$, 0}, {
                0, ($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}, {
                2, ($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, {
             Purple, Dashed, 
              
              Line[{{0, ($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{-($CellContext`itempos$$ $CellContext`n$$/(-$CellContext`itempos$$ + \
$CellContext`n$$)), ($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`frombotfoc$$ == True, {{
              RGBColor[1, 0.6, 0], 
              Line[{{$CellContext`itempos$$, (-$CellContext`size$$)/
                 2}, {$CellContext`n$$, 0}, {
                0, (-($CellContext`n$$ ($CellContext`size$$/
                    2)))/($CellContext`n$$ - $CellContext`itempos$$)}, {
                2, (-($CellContext`n$$ ($CellContext`size$$/
                    2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
             RGBColor[1, 0.6, 0], Dashed, 
             
             Line[{{0, (-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{-($CellContext`itempos$$ $CellContext`n$$/(-$CellContext`itempos$$ + \
$CellContext`n$$)), (-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`thrucenter$$ == True, {{Black, Dashed, 
              
              Line[{{$CellContext`itempos$$, $CellContext`size$$/2}, {0, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
($CellContext`n$$ ($CellContext`size$$/
                   2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, {
             Black, Dashed, 
              
              Line[{{$CellContext`itempos$$, (-$CellContext`size$$)/2}, {0, 
                0}, {($CellContext`n$$ \
$CellContext`itempos$$)/($CellContext`n$$ - $CellContext`itempos$$), \
(-($CellContext`n$$ ($CellContext`size$$/
                    2)))/($CellContext`n$$ - $CellContext`itempos$$)}}]}}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
           If[$CellContext`showanswer$$ == True, {Thick, 
             GrayLevel[0.5], 
             
             Arrowheads[(-0.05) $CellContext`n$$ \
($CellContext`size$$/($CellContext`n$$ - $CellContext`itempos$$))], 
             
             Arrow[{{-($CellContext`itempos$$ \
$CellContext`n$$/(-$CellContext`itempos$$ + $CellContext`n$$)), \
(-($CellContext`n$$ ($CellContext`size$$/
                   2)))/($CellContext`n$$ - $CellContext`itempos$$)}, \
{-($CellContext`itempos$$ $CellContext`n$$/(-$CellContext`itempos$$ + \
$CellContext`n$$)), ($CellContext`n$$ ($CellContext`size$$/
                  2))/($CellContext`n$$ - $CellContext`itempos$$)}}]}, 
            Point[{$CellContext`itempos$$, $CellContext`size$$/3}]]}], 
         If[$CellContext`frombotpara$$ == True, {
           RGBColor[0.4, 0.4, 0.8], 
           
           Line[{{$CellContext`itempos$$, (-$CellContext`size$$)/2}, {
             0, (-$CellContext`size$$)/2}}]}, 
          Point[{$CellContext`itempos$$, $CellContext`size$$/3}]], 
         If[$CellContext`showanswer$$ != True, 
          Point[{$CellContext`itempos$$, $CellContext`size$$/3}], {}]}, 
        PlotRange -> {{-3.2, 3.5}, {-1, 1}}, PlotLabel -> 
        If[$CellContext`showanswer$$ == True, 
          If[$CellContext`lenstype$$ == "converging", 
           Style["The image is real.", 14, "Label"], 
           Style["The image is virtual.", "Label", 14]], " "], 
        ImageSize -> {500, 234}], 
      "Specifications" :> {{{$CellContext`n$$, -0.85, 
          "focal length"}, -0.5, -1.05, Appearance -> 
         "Labeled"}, {{$CellContext`lenstype$$, "converging", "lens type"}, {
         "converging", "diverging"}}, {{$CellContext`size$$, 0.6, 
          "object size"}, 0.3, 0.8, Appearance -> 
         "Labeled"}, {{$CellContext`itempos$$, -2, 
          "object position"}, -2.4, -1.6, Appearance -> 
         "Labeled"}, {{$CellContext`fromtoppara$$, True, 
          "parallel from top"}, {
         True, False}}, {{$CellContext`frombotpara$$, True, 
          "parallel from bottom"}, {
         True, False}}, {{$CellContext`fromtopfoc$$, True, 
          "through focal point from top"}, {
         True, False}}, {{$CellContext`frombotfoc$$, True, 
          "through focal point from bottom"}, {
         True, False}}, {{$CellContext`thrucenter$$, True, 
          "rays through lens center"}, {
         True, False}}, {{$CellContext`showanswer$$, False, 
          "show perceived image"}, {True, False}}}, 
      "Options" :> {
       AutorunSequencing -> {1, 2, 3, 4}, ControlPlacement -> Top}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {249., 254.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`converginglens = {
          Circle[{-1, 0}, 1.3, {-0.6931599075767539, 0.6931599075767539}], 
          
          Circle[{1, 0}, 1.3, {2.4484327460130393`, 
           3.834752561166547}]}, $CellContext`diverginglens = {
          Circle[{-1.5, 0}, 1.3, {-0.6687208080957076, 0.6687208080957076}], 
          Circle[{1.5, 0}, 1.3, {2.4728718454940855`, 3.810313461685501}], 
          Line[{{-0.48, 0.8}, {0.48, 0.8}}], 
          Line[{{-0.48, -0.8}, {0.48, -0.8}}]}}; Typeset`initDone$$ = True); 
     ReleaseHold[{{
         HoldComplete[$CellContext`converginglens = {
             Circle[{-1, 0}, 1.3, {-ArcCos[1/1.3], 
               ArcCos[1/1.3]}], 
             Circle[{1, 0}, 1.3, {Pi - ArcCos[1/1.3], Pi + ArcCos[1/1.3]}]}; 
          Null], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`diverginglens = {
             Circle[{-1.5, 0}, 1.3, {-ArcCos[1.02/1.3], 
               ArcCos[1.02/1.3]}], 
             
             Circle[{1.5, 0}, 1.3, {
              Pi - ArcCos[1.02/1.3], Pi + ArcCos[1.02/1.3]}], 
             Line[{{-0.48, 0.8}, {0.48, 0.8}}], 
             Line[{{-0.48, -0.8}, {0.48, -0.8}}]}; Null]}}]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->579553281],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Using ray tracing, this demonstrates how a perceived image depends on the \
various characteristics of a lens. Converging lenses form an image on the \
opposite side of the lens from the object. A diverging lens creates a virtual \
image on the same side as the object. Vary the controls to learn how to \
construct the image.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Ray Tracing With Lenses",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/RayTracingWithLenses/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/RayTracingWithLenses/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/RayTracingWithLenses/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/RayTracingWithLenses/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/RayTracingWithLenses/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Brian Van Vertloo",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Brian+Van+\
Vertloo"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Brian+Van+Vertloo"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->1792162721],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
RayTracingWithLenses"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Ray Tracing With Lenses - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[625, 23, 143, 3, 70, "Section"],
Cell[771, 28, 3700, 64, 70, "Section"],
Cell[4474, 94, 3001, 86, 70, "Input",
 CellID->1139161038],
Cell[7478, 182, 34137, 846, 70, "Input",
 CellID->1496021318]
}, Open  ]],
Cell[CellGroupData[{
Cell[41652, 1033, 16533, 316, 70, "Output",
 CellID->579553281],
Cell[CellGroupData[{
Cell[58210, 1353, 209, 6, 70, "Section"],
Cell[58422, 1361, 350, 6, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58820, 1373, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[59178, 1384, 900, 24, 70, "Text"],
Cell[60081, 1410, 466, 15, 70, "Text",
 CellID->1792162721],
Cell[CellGroupData[{
Cell[60572, 1429, 815, 24, 70, "Text"],
Cell[61390, 1455, 1192, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature bQ4cg8Nb8UIKnC0l6KroNi1t *)
