(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     50501,       1348]
NotebookOptionsPosition[     48534,       1282]
NotebookOutlinePosition[     49224,       1308]
CellTagsIndexPosition[     49181,       1305]
WindowTitle->Polarization of an Optical Wave through Polarizers and Wave \
Plates - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Polarization of an Optical",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Wave through Polarizers and Wave Plates"
}], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"JvC", " ", "\[Equal]", "1"}], ",", 
      RowBox[{"init", "=", "True"}], ",", 
      RowBox[{"init", "=", "False"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"JmC", " ", "\[Equal]", "1"}], ",", 
      RowBox[{"polarize", "=", "True"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"polarize", "=", "False"}], ";", 
        RowBox[{"\[Beta]deg", " ", "=", " ", "0"}]}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Alpha]", "=", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"\[Alpha]deg", " ", "/", "180."}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Beta]", "=", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"\[Beta]deg", " ", "/", "180."}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"E1", " ", "=", " ", 
     RowBox[{"Evaluate", "[", 
      RowBox[{"E0", "*", "Jv"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Jv", " ", "=", " ", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"JvLinear", "[", "\[Alpha]", "]"}], ",", 
          RowBox[{"JvC", " ", "\[Equal]", " ", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"JvRCircular", ",", 
          RowBox[{"JvC", " ", "\[Equal]", " ", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"JvLCircular", ",", 
          RowBox[{"JvC", " ", "\[Equal]", " ", "3"}]}], "}"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Jm", " ", "=", " ", 
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"JmLinear", "[", "\[Beta]", "]"}], ",", 
          RowBox[{"JmC", " ", "\[Equal]", " ", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"JmQWP", ",", 
          RowBox[{"JmC", " ", "\[Equal]", " ", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"JmHWP", ",", " ", 
          RowBox[{"JmC", " ", "\[Equal]", " ", "3"}]}], "}"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"E2", " ", "=", " ", 
     RowBox[{"Evaluate", "[", 
      RowBox[{"Jm", ".", "E1"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"p1", " ", "=", " ", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Insert", "[", 
           RowBox[{"E1", ",", "x", ",", "1"}], "]"}], "]"}], "/.", " ", 
         RowBox[{"x", "\[Rule]", " ", "x1"}]}], " ", "/.", " ", 
        RowBox[{"t", "\[Rule]", " ", 
         RowBox[{"(", "t1", ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "0", ",", 
         RowBox[{
          RowBox[{"4", "Pi"}], "-", ".4"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"8", "Pi"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"280", ",", "375"}], "}"}]}], ",", 
       RowBox[{"ViewVector", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Insert", "[", 
           RowBox[{"\[Phi]", ",", 
            RowBox[{"20", "Pi"}], ",", "1"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"280", ",", "375"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"p2", " ", "=", " ", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Insert", "[", 
           RowBox[{"E2", ",", "x", ",", "1"}], "]"}], "]"}], " ", "/.", " ", 
         RowBox[{"x", "\[Rule]", " ", "x1"}]}], " ", "/.", " ", 
        RowBox[{"t", "\[Rule]", " ", 
         RowBox[{"(", "t1", ")"}]}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x1", ",", 
         RowBox[{
          RowBox[{"4", "Pi"}], "+", ".4"}], ",", 
         RowBox[{"8", "Pi"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"p3", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Thick", ",", " ", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"8", "Pi"}], ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", ".1", ",", "1.8"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", ".1"}], ",", "1.8"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1.8"}], ",", ".1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1.8"}], ",", 
             RowBox[{"-", ".1"}]}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"8", "Pi"}], ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"8", "Pi"}], "-", "1"}], ",", ".1", ",", "0"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"8", "Pi"}], "-", "1"}], ",", 
             RowBox[{"-", ".1"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "Black", ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"4", "\[Pi]"}], ",", "1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"4", "\[Pi]"}], ",", 
               RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          "\[Beta]", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", "Black", ",", 
        RowBox[{"GrayLevel", "[", 
         RowBox[{".5", ",", ".5"}], "]"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Cuboid", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"4", "Pi"}], "-", ".4"}], ",", 
              RowBox[{"-", "1"}], ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"4", "Pi"}], "+", ".4"}], ",", "1", ",", "1"}], 
             "}"}]}], "]"}], ",", "\[Beta]", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"coords", " ", "=", " ", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Insert", "[", 
         RowBox[{"E2", ",", 
          RowBox[{"8", "Pi"}], ",", "1"}], "]"}], "/.", " ", 
        RowBox[{"x", "\[Rule]", " ", 
         RowBox[{"8", "Pi"}]}]}], " ", "/.", " ", 
       RowBox[{"t", "\[Rule]", " ", 
        RowBox[{"(", "t1", ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"p4", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Yellow", ",", "Thick", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"8", "Pi"}], ",", "0", ",", "0"}], "}"}], ",", 
           "coords"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"p5", " ", "=", " ", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{"Insert", "[", 
           RowBox[{"E2", ",", 
            RowBox[{"8", "Pi"}], ",", "1"}], "]"}], "]"}], " ", "/.", " ", 
         RowBox[{"x", "\[Rule]", " ", "x1"}]}], " ", "/.", " ", 
        RowBox[{"t", "\[Rule]", " ", 
         RowBox[{"(", "t1", ")"}]}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x1", ",", 
         RowBox[{
          RowBox[{"4", "Pi"}], "+", ".4"}], ",", 
         RowBox[{"8", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"p1", ",", "p2", ",", "p3", ",", "p5", ",", "p4", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"375", ",", "375"}], "}"}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t1", ",", "0", ",", "\"\<animation\>\""}], "}"}], ",", "0", 
     ",", 
     RowBox[{"2", "Pi"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ControlType", "\[Rule]", "Animator"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"AppearanceElements", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<PlayPauseButton\>\"", ",", "\"\<FasterSlowerButtons\>\"", ",", 
        "\"\<ProgressSlider\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"AnimationRate", "\[Rule]", ".3"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"JvC", ",", "1", ",", "\"\<initial wave\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<linear\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{"2", "\[Rule]", " ", "\"\<right circular\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"3", "\[Rule]", "\"\<left circular\>\""}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]deg", ",", "45.", ",", "\"\<initial angle\>\""}], 
      "}"}], ",", "0", ",", "360.", ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"Dynamic", "[", "init", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"JmC", ",", "1", ",", "\"\<optical element\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<linear polarizer\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"2", "\[Rule]", "\"\<quarter-wave plate\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"3", "\[Rule]", "\"\<half-wave plate\>\""}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]deg", ",", "0", ",", "\"\<polarizer angle\>\""}], "}"}],
      ",", "0", ",", "360.", ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"Dynamic", "[", "polarize", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\"\<view point\>\""}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "Slider2D"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", " ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"E0", " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{"I", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"k", " ", "x"}], " ", "-", " ", 
                RowBox[{"\[Omega]", " ", "t"}]}], ")"}]}], ")"}]}], ",", 
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{"I", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"k", " ", "x"}], " ", "-", " ", 
                RowBox[{"\[Omega]", " ", "t"}]}], ")"}]}], ")"}]}]}], "}"}], "/.",
          " ", 
         RowBox[{"k", "\[Rule]", "1"}]}], " ", "/.", " ", 
        RowBox[{"\[Omega]", " ", "\[Rule]", " ", "1"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"JvLinear", " ", "[", "\[Alpha]_", "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", 
         RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"JvRCircular", " ", "=", " ", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", "2", "]"}]}], " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "I"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"JvLCircular", " ", "=", " ", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", "2", "]"}]}], " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", "I"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"JmLinear", "[", "\[Beta]_", "]"}], " ", ":=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "\[Beta]", "]"}], "^", "2"}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Beta]", "]"}], " ", 
            RowBox[{"Cos", "[", "\[Beta]", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", "\[Beta]", "]"}], " ", 
            RowBox[{"Cos", "[", "\[Beta]", "]"}]}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Beta]", "]"}], "^", "2"}]}], "}"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"JmQWP", " ", "=", " ", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"I", " ", 
            RowBox[{"Pi", "/", "4"}]}], ")"}]}]}], 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "I"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"JmHWP", " ", "=", " ", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"I", " ", 
            RowBox[{"Pi", "/", "2"}]}], ")"}]}]}], 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Jv", " ", "=", " ", 
       RowBox[{"JvLinear", "[", 
        RowBox[{"Pi", "/", "4"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Jm", " ", "=", " ", 
       RowBox[{"JmLinear", "[", "0", "]"}]}]}], "}"}]}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "6"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4251461525954*^9, {3.4251464458384*^9, 
   3.4251464472953997`*^9}, {3.4251473140914*^9, 3.4251473148394003`*^9}, {
   3.425293030822459*^9, 3.4252930311934967`*^9}, {3.4252939997763453`*^9, 
   3.425294094928859*^9}, {3.426432643689*^9, 3.426432654486*^9}, {
   3.4264327717469997`*^9, 3.426432775064*^9}, {3.426432809289*^9, 
   3.426432880635*^9}, {3.4264329313789997`*^9, 3.42643295966*^9}, {
   3.426432993201*^9, 3.426433037336*^9}, {3.42643308333*^9, 
   3.426433108139*^9}, 3.426433214451*^9, {3.4264358704536133`*^9, 
   3.4264359078933573`*^9}, 3.4264461336238413`*^9, {3.426530220801791*^9, 
   3.4265302368934*^9}, {3.426588701695073*^9, 3.4265887087097745`*^9}, {
   3.4265888625861607`*^9, 3.4265888986347647`*^9}, {3.4265891450414033`*^9, 
   3.4265891452364225`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`JmC$$ = 1, $CellContext`JvC$$ = 
    1, $CellContext`t1$$ = 0, $CellContext`\[Alpha]deg$$ = 
    45., $CellContext`\[Beta]deg$$ = 0, $CellContext`\[Phi]$$ = {-10, 10}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t1$$], 0, "animation"}, 0, 2 Pi}, {{
       Hold[$CellContext`JvC$$], 1, "initial wave"}, {
      1 -> "linear", 2 -> "right circular", 3 -> "left circular"}}, {{
       Hold[$CellContext`\[Alpha]deg$$], 45., "initial angle"}, 0, 360.}, {{
       Hold[$CellContext`JmC$$], 1, "optical element"}, {
      1 -> "linear polarizer", 2 -> "quarter-wave plate", 3 -> 
       "half-wave plate"}}, {{
       Hold[$CellContext`\[Beta]deg$$], 0, "polarizer angle"}, 0, 360.}, {{
       Hold[$CellContext`\[Phi]$$], {-10, 10}, "view point"}, {-10, -10}, {10,
       10}}}, Typeset`size$$ = {375., {185., 190.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`t1$5117$$ = 0, $CellContext`JvC$5118$$ = 
    False, $CellContext`\[Alpha]deg$5119$$ = 0, $CellContext`JmC$5120$$ = 
    False, $CellContext`\[Beta]deg$5121$$ = 0, $CellContext`\[Phi]$5122$$ = {
    0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`JmC$$ = 1, $CellContext`JvC$$ = 
        1, $CellContext`t1$$ = 0, $CellContext`\[Alpha]deg$$ = 
        45., $CellContext`\[Beta]deg$$ = 
        0, $CellContext`\[Phi]$$ = {-10, 10}}, "ControllerVariables" :> {
        Hold[$CellContext`t1$$, $CellContext`t1$5117$$, 0], 
        Hold[$CellContext`JvC$$, $CellContext`JvC$5118$$, False], 
        Hold[$CellContext`\[Alpha]deg$$, $CellContext`\[Alpha]deg$5119$$, 0], 
        
        Hold[$CellContext`JmC$$, $CellContext`JmC$5120$$, False], 
        Hold[$CellContext`\[Beta]deg$$, $CellContext`\[Beta]deg$5121$$, 0], 
        Hold[$CellContext`\[Phi]$$, $CellContext`\[Phi]$5122$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       If[$CellContext`JvC$$ == 1, $CellContext`init = 
         True, $CellContext`init = False]; 
       If[$CellContext`JmC$$ == 1, $CellContext`polarize = 
         True, {$CellContext`polarize = False; $CellContext`\[Beta]deg$$ = 
           0}]; $CellContext`\[Alpha] = 
        Pi ($CellContext`\[Alpha]deg$$/180.); $CellContext`\[Beta] = 
        Pi ($CellContext`\[Beta]deg$$/180.); $CellContext`E1 = 
        Evaluate[$CellContext`E0 $CellContext`Jv]; $CellContext`Jv = 
        Piecewise[{{
            $CellContext`JvLinear[$CellContext`\[Alpha]], $CellContext`JvC$$ == 
            1}, {$CellContext`JvRCircular, $CellContext`JvC$$ == 
            2}, {$CellContext`JvLCircular, $CellContext`JvC$$ == 
            3}}]; $CellContext`Jm = Piecewise[{{
            $CellContext`JmLinear[$CellContext`\[Beta]], $CellContext`JmC$$ == 
            1}, {$CellContext`JmQWP, $CellContext`JmC$$ == 
            2}, {$CellContext`JmHWP, $CellContext`JmC$$ == 
            3}}]; $CellContext`E2 = Evaluate[
          Dot[$CellContext`Jm, $CellContext`E1]]; $CellContext`p1 = 
        ParametricPlot3D[
          ReplaceAll[
           ReplaceAll[
            Re[
             Insert[$CellContext`E1, DemonstrationsTools`x, 1]], 
            DemonstrationsTools`x -> $CellContext`x1], $CellContext`t -> \
$CellContext`t1$$], {$CellContext`x1, 0, 4 Pi - 0.4}, Axes -> False, 
          PlotRange -> {{0, 8 Pi}, {-2, 2}, {-2, 2}}, Boxed -> False, 
          ImageSize -> {280, 375}, ViewVector -> {
            Insert[$CellContext`\[Phi]$$, 20 Pi, 1], {0, 0, 0}}, 
          ImageSize -> {280, 375}]; $CellContext`p2 = ParametricPlot3D[
          ReplaceAll[
           ReplaceAll[
            Re[
             Insert[$CellContext`E2, DemonstrationsTools`x, 1]], 
            
            DemonstrationsTools`x -> $CellContext`x1], $CellContext`t -> \
$CellContext`t1$$], {$CellContext`x1, 4 Pi + 0.4, 8 Pi}]; $CellContext`p3 = 
        Graphics3D[{Black, Thick, 
           Line[{{0, 0, 0}, {8 Pi, 0, 0}}], 
           Line[{{0, 0, 0}, {0, -2, 0}}], 
           Line[{{0, 0, 0}, {0, 0, 2}}], 
           Polygon[{{0, 0, 2}, {0, 0.1, 1.8}, {0, -0.1, 1.8}}], 
           Polygon[{{0, -2, 0}, {0, -1.8, 0.1}, {0, -1.8, -0.1}}], 
           Polygon[{{8 Pi, 0, 0}, {8 Pi - 1, 0.1, 0}, {8 Pi - 1, -0.1, 0}}], 
           Black, 
           Rotate[
            Line[{{4 Pi, 1, 0}, {4 Pi, -1, 0}}], $CellContext`\[Beta], {1, 0, 
            0}], Black, 
           GrayLevel[0.5, 0.5], 
           Rotate[
            
            Cuboid[{4 Pi - 0.4, -1, -1}, {
             4 Pi + 0.4, 1, 1}], $CellContext`\[Beta], {1, 0, 
            0}]}]; $CellContext`coords = Re[
          ReplaceAll[
           ReplaceAll[
            Insert[$CellContext`E2, 8 Pi, 1], DemonstrationsTools`x -> 
            8 Pi], $CellContext`t -> $CellContext`t1$$]]; $CellContext`p4 = 
        Graphics3D[{Yellow, Thick, 
           Line[{{8 Pi, 0, 0}, $CellContext`coords}]}]; $CellContext`p5 = 
        ParametricPlot3D[
          ReplaceAll[
           ReplaceAll[
            Re[
             Insert[$CellContext`E2, 8 Pi, 1]], 
            DemonstrationsTools`x -> $CellContext`x1], $CellContext`t -> \
$CellContext`t1$$], {$CellContext`x1, 4 Pi + 0.4, 8 Pi}, PlotStyle -> Purple]; 
       Show[$CellContext`p1, $CellContext`p2, $CellContext`p3, \
$CellContext`p5, $CellContext`p4, ImageSize -> {375, 375}]), 
      "Specifications" :> {{{$CellContext`t1$$, 0, "animation"}, 0, 2 Pi, 
         ControlType -> Animator, 
         AppearanceElements -> {
          "PlayPauseButton", "FasterSlowerButtons", "ProgressSlider"}, 
         AnimationRate -> 0.3, AnimationRunning -> False, ImageSize -> Small, 
         ControlPlacement -> Top}, {{$CellContext`JvC$$, 1, "initial wave"}, {
         1 -> "linear", 2 -> "right circular", 3 -> "left circular"}, 
         ControlType -> PopupMenu, ControlPlacement -> 
         Left}, {{$CellContext`\[Alpha]deg$$, 45., "initial angle"}, 0, 360., 
         ControlPlacement -> Left, Enabled -> Dynamic[$CellContext`init], 
         ImageSize -> Small}, {{$CellContext`JmC$$, 1, "optical element"}, {
         1 -> "linear polarizer", 2 -> "quarter-wave plate", 3 -> 
          "half-wave plate"}, ControlType -> PopupMenu, ControlPlacement -> 
         Left}, {{$CellContext`\[Beta]deg$$, 0, "polarizer angle"}, 0, 360., 
         ControlPlacement -> Left, Enabled -> Dynamic[$CellContext`polarize], 
         ImageSize -> 
         Small}, {{$CellContext`\[Phi]$$, {-10, 10}, 
          "view point"}, {-10, -10}, {10, 10}, ControlType -> Slider2D, 
         ControlPlacement -> Left}}, 
      "Options" :> {
       TrackedSymbols -> Manipulate, AutorunSequencing -> {1, 4, 5, 6}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{622., {226., 231.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`E0 = ReplaceAll[
          
          ReplaceAll[{
           E^(I ($CellContext`k 
               DemonstrationsTools`x - $CellContext`\[Omega] $CellContext`t)),
             E^(I ($CellContext`k 
               DemonstrationsTools`x - $CellContext`\[Omega] \
$CellContext`t))}, $CellContext`k -> 1], $CellContext`\[Omega] -> 
          1]; $CellContext`JvLinear[
          Pattern[$CellContext`\[Alpha], 
           Blank[]]] := {
          Cos[$CellContext`\[Alpha]], 
          Sin[$CellContext`\[Alpha]]}; $CellContext`JvRCircular = (1/Sqrt[
          2]) {1, -I}; $CellContext`JvLCircular = (1/Sqrt[2]) {
          1, I}; $CellContext`JmLinear[
          Pattern[$CellContext`\[Beta], 
           Blank[]]] := {{
          Cos[$CellContext`\[Beta]]^2, Sin[$CellContext`\[Beta]] 
           Cos[$CellContext`\[Beta]]}, {
          Sin[$CellContext`\[Beta]] Cos[$CellContext`\[Beta]], 
           Sin[$CellContext`\[Beta]]^2}}; $CellContext`JmQWP = 
        E^(-(I (Pi/4))) {{1, 0}, {0, I}}; $CellContext`JmHWP = 
        E^(-(I (Pi/2))) {{1, 0}, {
          0, -1}}; $CellContext`Jv = $CellContext`JvLinear[
         Pi/4]; $CellContext`Jm = $CellContext`JmLinear[0]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->163686402],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Wave plates and linear polarizers are common optical elements that alter the \
polarization of light passing through them. This Demonstration shows the \
effect of the optical element on the polarization of light. You can select \
the optical element from the drop-down menu and set the polarization state of \
the incident wave (linear, right circular, or left circular). The line \
through the optical element represents the direction of polarization \
(transmission axis) for the polarizer and the fast axis for half- and \
quarter-wave plates.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "An electromagnetic (EM) wave propagating in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction can be represented mathematically as"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["E",
     FontWeight->"Bold"], " ", "=", 
    RowBox[{
     RowBox[{"(", "\[NoBreak]", 
      TagBox[GridBox[{
         {
          RowBox[{
           SubscriptBox["E", 
            RowBox[{"0", "x"}]], 
           SuperscriptBox["\[ExponentialE]", "\[Delta]x"], " "}]},
         {
          RowBox[{
           SubscriptBox["E", 
            RowBox[{"0", "y"}]], 
           SuperscriptBox["\[ExponentialE]", "\[Delta]y"], " "}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], "\[NoBreak]", ")"}], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", " ", "z"}], "-", 
         RowBox[{"\[Omega]", " ", "t"}]}], ")"}]}]]}]}], TraditionalForm]], 
  "InlineMath"],
 ", "
}], "Text"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["E", 
     RowBox[{"0", "x"}]],
    FontWeight->"Bold"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["E", 
    RowBox[{"0", "y"}]], TraditionalForm]], "InlineMath"],
 " are the amplitudes of the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " components of the electric field, ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " is the wave number, ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " is the distance along the propagation direction, ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineMath"],
 " is the frequency, ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is the time, and ",
 StyleBox["\[Delta]",
  FontWeight->"Bold"],
 " is the phase. The term in brackets is referred to as the Jones vector, \
which gives the polarization of the wave; for example:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["E", "0"],
     FontWeight->"Bold"], 
    StyleBox["=",
     FontWeight->"Bold"], 
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"cos", "(", "\[Alpha]", ")"}]},
        {
         RowBox[{"sin", "(", "\[Alpha]", ")"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", linearly polarized light angle ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " from the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis,"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["E", "0"],
     FontWeight->"Bold"], 
    StyleBox["=",
     FontWeight->"Bold"], 
    RowBox[{
     FormBox[
      FractionBox["1", 
       SqrtBox["2"]],
      TraditionalForm], 
     RowBox[{"(", "\[NoBreak]", 
      TagBox[GridBox[{
         {"1"},
         {
          RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], "\[NoBreak]", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", left/right circularly polarized light,"
}], "Text"],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["E", "0"],
     FontWeight->"Bold"], 
    StyleBox["=",
     FontWeight->"Bold"], 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["A", "2"], "+", 
        SuperscriptBox["B", "2"], "+", 
        SuperscriptBox["C", "2"]}]]], 
     RowBox[{"(", "\[NoBreak]", 
      TagBox[GridBox[{
         {"A"},
         {
          RowBox[{"B", "+", 
           RowBox[{"\[ImaginaryI]", " ", "C"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], "\[NoBreak]", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", elliptically polarized light."
}], "Text"],

Cell["\<\
Optical elements that modify polarization are made from anisotropic \
materials. In an anisotropic material the index of refraction is different \
for the vertical and horizontal components of the optical wave. For example, \
quarter-wave plates are typically made from calcite, which is birefringent, \
and linear polarizers can be made from Polaroid sheets, which are dichroic. \
Once light passes through these materials, the polarization of the \
transmitted light changes. Depending on the material and orientation of the \
incident light, the transmitted light can be linearly or circularly \
polarized, both of which are special cases of elliptical polarization. \
\>", "Text"],

Cell["\<\
In this Demonstration, we assume the light source was polarized at some point \
before reaching the origin. Once the light comes into contact with an \
anisotropic optical element it will go through a change in polarization \
calculated by using the appropriate Jones matrix. You can choose between \
three common optical components: a linear polarizer, a quarter-wave plate and \
a half-wave plate.\
\>", "Text"],

Cell[TextData[{
 "Snapshot 1: When a wave comes into contact with a linear polarizer only the \
components parallel to the transmission angle of the polarizer are \
transmitted. This also causes it to have a lower amplitude than the incident \
wave, unless the polarizer and incident wave are polarized in the same \
direction. The Jones matrix for a linear polarizer with transmission axis \
oriented at an angle ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineMath"],
 " with the ",
 StyleBox["x ",
  FontSlant->"Italic"],
 "axis is"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", " ", 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["cos", "2"], "(", "\[Beta]", ")"}], 
        RowBox[{
         RowBox[{"sin", "(", "\[Beta]", ")"}], " ", 
         RowBox[{"cos", "(", "\[Beta]", ")"}]}]},
       {
        RowBox[{
         RowBox[{"sin", "(", "\[Beta]", ")"}], " ", 
         RowBox[{"cos", "(", "\[Beta]", ")"}]}], 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Beta]", ")"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "Snapshot 2: When a quarter-wave plate is used, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " components of the electric field become 90\[Degree] or 180\[Degree] out of \
phase, respectively. If the incident wave is linearly polarized, the \
resulting wave is elliptically polarized. Notice that the tip of the electric \
field vector traces out an ellipse (shown in purple). The Jones matrix for a \
quarter waveplate is "
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", 
    FormBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", " ", 
          FractionBox["\[Pi]", "4"]}], ")"}]}]], " ", 
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "0"},
         {"0", "\[ImaginaryI]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}],
     TraditionalForm]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "Snapshot 3: Linearly polarized light incident on the quarter-wave plate at \
45\[Degree] results in equal ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " components. In this case the transmitted light is circularly polarized, a \
special case of elliptical polarization."
}], "Text"],

Cell["\<\
Snapshot 4: Linearly polarized light incident on a half-wave plate will be \
rotated.\
\>", "Text"],

Cell["\<\
Suggestion: use a quarter-wave plate and a half-wave plate with circularly \
polarized incident light and see the results.\
\>", "Text"],

Cell["Reference:", "Text"],

Cell[TextData[{
 "F. L. Pedrotti and L. S. Pedrotti, ",
 StyleBox["Introduction to Optics",
  FontSlant->"Italic"],
 ", 2nd ed., Upper Saddle River, NJ: Prentice Hall, 1993."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Polarization of an Optical",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"],
 StyleBox[ButtonBox[" ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"],
  FontSlant->"Italic"],
 ButtonBox["Wave through Polarizers and Wave Plates",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Fred E. Moolekamp",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Fred+E.+\
Moolekamp"], None}],
 " and ",
 ButtonBox["Kevin L. Stokes",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Kevin+L.+\
Stokes"], None}],
 " (University of New Orleans)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
PolarizationOfAnOpticalWaveThroughPolarizersAndWavePlates"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Polarization of an Optical Wave through Polarizers and Wave \
Plates - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[670, 24, 244, 8, 70, "Section"],
Cell[917, 34, 3700, 64, 70, "Section"],
Cell[4620, 100, 18361, 483, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23018, 588, 8791, 169, 70, "Output",
 CellID->163686402],
Cell[CellGroupData[{
Cell[31834, 761, 209, 6, 70, "Section"],
Cell[32046, 769, 571, 9, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32665, 784, 209, 6, 70, "Section"],
Cell[32877, 792, 195, 5, 70, "Text"],
Cell[33075, 799, 1277, 40, 70, "Text"],
Cell[34355, 841, 1080, 36, 70, "Text"],
Cell[35438, 879, 1073, 34, 70, "Text"],
Cell[36514, 915, 1007, 33, 70, "Text"],
Cell[37524, 950, 1118, 37, 70, "Text"],
Cell[38645, 989, 694, 10, 70, "Text"],
Cell[39342, 1001, 423, 7, 70, "Text"],
Cell[39768, 1010, 564, 13, 70, "Text"],
Cell[40335, 1025, 1026, 30, 70, "Text"],
Cell[41364, 1057, 554, 12, 70, "Text"],
Cell[41921, 1071, 923, 28, 70, "Text"],
Cell[42847, 1101, 397, 10, 70, "Text"],
Cell[43247, 1113, 109, 3, 70, "Text"],
Cell[43359, 1118, 146, 3, 70, "Text"],
Cell[43508, 1123, 26, 0, 70, "Text"],
Cell[43537, 1125, 186, 5, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[43759, 1135, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[44117, 1146, 1755, 48, 70, "Text"],
Cell[45875, 1196, 559, 19, 70, "Text"],
Cell[CellGroupData[{
Cell[46459, 1219, 815, 24, 70, "Text"],
Cell[47277, 1245, 1229, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 4QNZxAYJnKCkEBD6rkdrr8VI *)
