(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     49142,       1183]
NotebookOptionsPosition[     47689,       1130]
NotebookOutlinePosition[     48343,       1155]
CellTagsIndexPosition[     48300,       1152]
WindowTitle->Optical Rotation and Ellipticity - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Optical Rotation and Ellipticity", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"orplot", "[", 
    RowBox[{"kdiff", ",", "loss", ",", "t"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kdiff", ",", "1.07", ",", "\"\<ratio of wave vectors\>\""}], 
      "}"}], ",", "1", ",", "1.1", ",", " ", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "loss", ",", "30", ",", 
       "\"\<absorption of one\\ncircular component (%)\>\""}], "}"}], ",", 
     "0", ",", "100", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\"\<time\>\""}], "}"}], ",", "0", ",", 
     RowBox[{
      RowBox[{"2", " ", "Pi"}], " ", "-", " ", 
      RowBox[{"Pi", "/", "16"}]}], ",", 
     RowBox[{"Pi", "/", "16"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "Animator"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Below", " ", "we", " ", "define", " ", "all", " ", "the", " ", 
     "components", " ", "for", " ", "this", " ", "simulation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", " ", "\[RuleDelayed]", " ", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"blue", " ", ":=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.392193", ",", "0.584307", ",", "0.929395"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"red", ":=", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.829997", ",", "0.239998", ",", "0.099994"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"green", " ", ":=", 
       FormBox[
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.380001", ",", "0.700003", ",", "0.159993"}], "]"}],
        TraditionalForm]}], ";", "\[IndentingNewLine]", " ", 
      RowBox[{"\[Omega]", ":=", "3"}], ";", " ", 
      RowBox[{"(*", " ", "frequency", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"amp", " ", ":=", " ", "3"}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "amplitude", " ", "of", " ", "the", " ", "individual", " ", "waves"}], 
       " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"len", " ", ":=", " ", 
       RowBox[{"12", " ", "Pi"}]}], " ", ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"length", " ", "of", " ", "the", " ", "\"\<cuvette\>\""}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"pos2", " ", ":=", " ", 
       RowBox[{"len", " ", "+", " ", 
        RowBox[{"7", " ", "Pi"}]}]}], " ", ";", 
      RowBox[{"(*", " ", 
       RowBox[{"position", " ", "of", " ", "\"\<detector\>\""}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"k1", "[", "s_", "]"}], " ", ":=", " ", "1"}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"k", "-", 
        RowBox[{
        "value", " ", "for", " ", "the", " ", "first", " ", "wave"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"k2", "[", 
        RowBox[{"s_", ",", "kdiff_"}], "]"}], " ", ":=", " ", 
       RowBox[{"If", "[", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"s", " ", "<", " ", "0"}], "  ", "||", " ", 
          RowBox[{"s", " ", ">", " ", "len"}]}], ",", 
         RowBox[{"k1", "[", "0", "]"}], ",", " ", 
         RowBox[{
          RowBox[{"k1", "[", "0", "]"}], " ", "*", " ", "kdiff"}]}], "]"}]}], 
      ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"k", "-", 
        RowBox[{
        "value", " ", "for", " ", "the", " ", "second", " ", "wave", " ", 
         "relative", " ", "to", " ", "that", " ", "of", " ", "the", " ", 
         "first", " ", "one"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"s_", ",", "kdiff_"}], "]"}], " ", ":=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"s", " ", "<", " ", "len"}], ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"k1", "[", "0", "]"}], " ", "*", " ", "kdiff", " ", "*", 
          " ", "len"}]}], "]"}]}], ";", 
      RowBox[{"(*", " ", 
       RowBox[{
       "additional", " ", "phase", " ", "shift", " ", "after", " ", "the", 
        " ", "wave", " ", "has", " ", "passed", " ", "through", " ", "the", 
        " ", "medium"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"a1", "[", "s_", "]"}], " ", "=", " ", "amp"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"next", " ", 
         RowBox[{"line", ":", " ", 
          RowBox[{
          "we", " ", "have", " ", "a", " ", "bit", " ", "of", " ", 
           "absorption", " ", "going", " ", "on", " ", "for", " ", "the", " ",
            "second", " ", "set", " ", "of", " ", "waves"}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"too", ".", " ", "More"}], " ", "realistically", " ", "we", 
         " ", "should", " ", "apply", " ", 
         RowBox[{"Beer", "'"}], "s", " ", "law", " ", "here", " ", "but", " ",
          "I", " ", "wanted", " ", "to", " ", "keep", " ", "things", " ", 
         "simple", " ", "so", " ", 
         RowBox[{"it", "'"}], "s", " ", "\[IndentingNewLine]", "a", " ", 
         "LINEAR", " ", "function", " ", "instead", " ", "of", " ", "an", " ",
          "exponential", " ", "function"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"a2", "[", 
        RowBox[{"s_", ",", "loss_"}], "]"}], " ", ":=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"s", " ", "<", " ", "0"}], ",", "amp", ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", " ", "\[GreaterEqual]", " ", "0"}], " ", "&&", " ", 
            RowBox[{"s", " ", "\[LessEqual]", " ", "len"}]}], ",", " ", 
           RowBox[{"amp", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "  ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"loss", "/", "100"}], ")"}], " ", 
               RowBox[{"s", "/", "len"}]}]}], ")"}]}], ",", 
           RowBox[{"amp", " ", 
            RowBox[{"(", 
             RowBox[{"1", " ", "-", " ", 
              RowBox[{"loss", "/", "100"}]}], ")"}]}]}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"w11", "[", 
        RowBox[{"t_", ",", "s_", ",", "\[Phi]_"}], "]"}], " ", ":=", " ", 
       RowBox[{
        RowBox[{"a1", "[", "s", "]"}], " ", 
        RowBox[{"Sin", "[", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Phi]", " ", "+", 
            RowBox[{
             RowBox[{"k1", "[", "s", "]"}], " ", "s"}]}], ")"}], " ", "-", 
          RowBox[{"\[Omega]", " ", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"w22", "[", 
        RowBox[{"t_", ",", "s_"}], "]"}], " ", ":=", " ", 
       RowBox[{
        RowBox[{"a1", "[", "s", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k1", "[", "s", "]"}], " ", "s"}], " ", ")"}], " ", "-", 
          RowBox[{"\[Omega]", " ", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v11", "[", 
        RowBox[{
        "t_", ",", "s_", ",", "\[Phi]_", ",", "kdiff_", ",", "loss_"}], "]"}],
        " ", ":=", " ", 
       RowBox[{
        RowBox[{"a2", "[", 
         RowBox[{"s", ",", "loss"}], "]"}], "  ", 
        RowBox[{"Sin", "[", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Phi]", " ", "+", " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"s", ",", "kdiff"}], "]"}], "+", 
            RowBox[{
             RowBox[{"k2", "[", 
              RowBox[{"s", ",", "kdiff"}], " ", "]"}], "s"}]}], " ", ")"}], 
          " ", "-", 
          RowBox[{"\[Omega]", " ", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v22", "[", 
        RowBox[{"t_", ",", "s_", ",", "kdiff_", ",", "loss_"}], "]"}], " ", ":=",
        " ", 
       RowBox[{
        RowBox[{"a2", "[", 
         RowBox[{"s", ",", "loss"}], "]"}], "  ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"s", ",", "kdiff"}], "]"}], " ", "+", 
            RowBox[{
             RowBox[{"k2", "[", 
              RowBox[{"s", ",", "kdiff"}], " ", "]"}], "  ", "s"}]}], ")"}], 
          " ", "-", 
          RowBox[{"\[Omega]", " ", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xx", " ", ":=", " ", 
       RowBox[{"2", " ", "amp"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"box", "=", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "len", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "len", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "len", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "len", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "len", ",", 
                 RowBox[{"-", "xx"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "0", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "0", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "0", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "0", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "0", ",", 
                 RowBox[{"-", "xx"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "0", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "len", ",", 
                 RowBox[{"-", "xx"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"xx", ",", "0", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "len", ",", "xx"}], "}"}]}], "}"}], 
             "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "0", ",", "xx"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "xx"}], ",", "len", ",", "xx"}], "}"}]}], "}"}],
              "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"xx", ",", "0", ",", 
                 RowBox[{"-", "xx"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"xx", ",", "len", ",", 
                 RowBox[{"-", "xx"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Next", ";", " ", 
         RowBox[{
         "we", " ", "create", " ", "the", " ", "superposition", " ", "of", 
          " ", "two", " ", "circularly", " ", "polarized", " ", "waves"}]}], 
        ",", "  ", 
        RowBox[{"with", " ", "opposite", " ", "helicity", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"use", " ", "phase", " ", "shifts", " ", "of", " ", 
            RowBox[{"Pi", "/", "2"}], " ", "and"}], " ", "-", 
           RowBox[{
            RowBox[{"Pi", "/", "2"}], " ", "for", " ", "the", " ", "linear", 
            " ", "components"}]}], ")"}]}]}], "  ", "*)"}], " ", 
      RowBox[{
       RowBox[{"waveSup", "[", 
        RowBox[{"t_", ",", "s_", ",", "kdiff_", ",", "loss_"}], "]"}], " ", ":=",
        "  ", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"v22", "[", 
           RowBox[{"t", ",", "s", ",", "kdiff", ",", "loss"}], "]"}], " ", 
          "+", " ", 
          RowBox[{"w22", "[", 
           RowBox[{"t", ",", "s"}], "]"}]}], " ", ",", " ", "s", ",", 
         RowBox[{
          RowBox[{"v11", "[", 
           RowBox[{"t", ",", "s", ",", 
            RowBox[{"Pi", "/", "2"}], ",", "kdiff", ",", "loss"}], "]"}], " ",
           "+", " ", 
          RowBox[{"w11", "[", 
           RowBox[{"t", ",", "s", ",", 
            RowBox[{
             RowBox[{"-", "Pi"}], "/", "2"}]}], "]"}]}]}], "  ", "}"}]}], ";",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"next", ",", " ", 
        RowBox[{
        "we", " ", "define", " ", "the", " ", "actual", " ", "appearence", 
         " ", "of", " ", "the", " ", "plot"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"orplot", "[", 
        RowBox[{"kdiff_", ",", "loss_", ",", "t_"}], "]"}], " ", ":=", " ", 
       RowBox[{"Module", "[", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s", ",", "t2"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"ParametricPlot3D", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"waveSup", "[", 
              RowBox[{"t", ",", "s", ",", "kdiff", ",", "loss"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"s", ",", 
               RowBox[{
                RowBox[{"-", "5"}], " ", "Pi"}], ",", 
               RowBox[{"len", " ", "+", " ", 
                RowBox[{"5", "  ", "Pi"}]}]}], " ", "}"}], ",", 
             RowBox[{"Boxed", "->", "False"}], ",", 
             RowBox[{"Axes", "\[Rule]", " ", "False"}], ",", " ", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"blue", ",", 
                RowBox[{"AbsoluteThickness", "[", "3.", "]"}]}], "}"}]}]}], 
            "]"}], ",", "\[IndentingNewLine]", " ", "box", ",", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"{", 
             RowBox[{"green", ",", 
              RowBox[{"AbsoluteThickness", "[", "3.", "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "pos2", ",", "0"}], "}"}], ",", 
                 "\[IndentingNewLine]", "    ", 
                 RowBox[{"waveSup", "[", 
                  RowBox[{"t", ",", "pos2", ",", "kdiff", ",", "loss"}], 
                  "]"}]}], "                  ", "}"}], "]"}]}], "}"}], "]"}],
            ",", " ", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{
             "the", " ", "field", " ", "vector", " ", "at", " ", "s"}], " ", 
             "=", " ", "pos"}], " ", "*)"}], "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"ParametricPlot3D", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"waveSup", "[", 
              RowBox[{"t2", ",", "pos2", ",", "kdiff", ",", "loss"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"t2", ",", "0", ",", 
               RowBox[{"2", "Pi"}]}], " ", "}"}], ",", 
             RowBox[{"Boxed", "->", "False"}], ",", 
             RowBox[{"Axes", "\[Rule]", " ", "False"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Black", ",", 
                RowBox[{"AbsoluteThickness", "[", "1.", "]"}]}], "}"}]}]}], 
            "]"}], ",", 
           RowBox[{"(*", " ", 
            RowBox[{
            "the", " ", "projection", " ", "of", " ", "the", " ", "outgoing", 
             " ", "wave", " ", "at", " ", "the", " ", "\"\<detector\>\""}], 
            " ", "*)"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           " ", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"450", ",", "350"}], "}"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ";"}], "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "The", " ", "definition", " ", "for", " ", "the", " ", "plot", " ", 
       "that", " ", "we", " ", "are", " ", "going", " ", "to", " ", "do", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
         "the", " ", "static", " ", "part", " ", "depending", " ", "on", " ", 
          "parameters", " ", "t"}], ",", " ", "kdiff", ",", " ", 
         RowBox[{"and", " ", "the", " ", "loss"}]}], ")"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", ")"}]}], ",", " ", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.438102254140625*^9, 3.438102264640625*^9}, {
   3.438102317*^9, 3.43810231859375*^9}, {3.438102375078125*^9, 
   3.43810242684375*^9}, {3.438102463890625*^9, 3.438102471578125*^9}, {
   3.438102508703125*^9, 3.43810252696875*^9}, {3.438102574859375*^9, 
   3.438102634515625*^9}, {3.4381065284375*^9, 3.438106534515625*^9}, {
   3.438351186366654*^9, 3.438351332913307*^9}, {3.438453138027273*^9, 
   3.4384531432587967`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`kdiff$$ = 1.07, $CellContext`loss$$ = 
    30, $CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`kdiff$$], 1.07, "ratio of wave vectors"}, 1, 1.1}, {{
      
       Hold[$CellContext`loss$$], 30, 
       "absorption of one\ncircular component (%)"}, 0, 100}, {{
       Hold[$CellContext`t$$], 0, "time"}, 0, Rational[31, 16] Pi, 
      Rational[1, 16] Pi}}, Typeset`size$$ = {450., {173., 177.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`kdiff$12240$$ = 0, $CellContext`loss$12241$$ = 
    0, $CellContext`t$12242$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`kdiff$$ = 1.07, $CellContext`loss$$ = 
        30, $CellContext`t$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`kdiff$$, $CellContext`kdiff$12240$$, 0], 
        Hold[$CellContext`loss$$, $CellContext`loss$12241$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$12242$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`orplot[$CellContext`kdiff$$, \
$CellContext`loss$$, $CellContext`t$$], 
      "Specifications" :> {{{$CellContext`kdiff$$, 1.07, 
          "ratio of wave vectors"}, 1, 1.1, Appearance -> 
         "Labeled"}, {{$CellContext`loss$$, 30, 
          "absorption of one\ncircular component (%)"}, 0, 100, Appearance -> 
         "Labeled"}, {{$CellContext`t$$, 0, "time"}, 0, Rational[31, 16] Pi, 
         Rational[1, 16] Pi, ControlType -> Animator, AnimationRunning -> 
         False}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{495., {248., 253.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({{$CellContext`orplot[
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]], 
           Pattern[$CellContext`t, 
            Blank[]]] := Module[{$CellContext`s, $CellContext`t2}, 
           Show[
            ParametricPlot3D[
             $CellContext`waveSup[$CellContext`t, $CellContext`s, \
$CellContext`kdiff, $CellContext`loss], {$CellContext`s, (-5) 
              Pi, $CellContext`len + 5 Pi}, Boxed -> False, Axes -> False, 
             PlotStyle -> {$CellContext`blue, 
               AbsoluteThickness[3.]}], $CellContext`box, 
            Graphics3D[{$CellContext`green, 
              AbsoluteThickness[3.], 
              Line[{{0, $CellContext`pos2, 0}, 
                $CellContext`waveSup[$CellContext`t, $CellContext`pos2, \
$CellContext`kdiff, $CellContext`loss]}]}], 
            ParametricPlot3D[
             $CellContext`waveSup[$CellContext`t2, $CellContext`pos2, \
$CellContext`kdiff, $CellContext`loss], {$CellContext`t2, 0, 2 Pi}, Boxed -> 
             False, Axes -> False, PlotStyle -> {Black, 
               AbsoluteThickness[1.]}], PlotRange -> All, 
            ImageSize -> {450, 350}]], $CellContext`waveSup[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            
            Blank[]]] := {$CellContext`v22[$CellContext`t, $CellContext`s, \
$CellContext`kdiff, $CellContext`loss] + $CellContext`w22[$CellContext`t, \
$CellContext`s], $CellContext`s, $CellContext`v11[$CellContext`t, \
$CellContext`s, Pi/
             2, $CellContext`kdiff, $CellContext`loss] + \
$CellContext`w11[$CellContext`t, $CellContext`s, -Pi/2]}, $CellContext`v22[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := $CellContext`a2[$CellContext`s, $CellContext`loss] 
          Sin[($CellContext`\[CapitalDelta][$CellContext`s, \
$CellContext`kdiff] + $CellContext`k2[$CellContext`s, $CellContext`kdiff] \
$CellContext`s) - $CellContext`\[Omega] $CellContext`t], $CellContext`a2[
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := If[$CellContext`s < 0, $CellContext`amp, 
           If[
            
            And[$CellContext`s >= 
             0, $CellContext`s <= $CellContext`len], $CellContext`amp (
             1 - ($CellContext`loss/
              100) ($CellContext`s/$CellContext`len)), $CellContext`amp (
             1 - $CellContext`loss/100)]], $CellContext`amp := 
         3, $CellContext`len := 12 Pi, $CellContext`\[CapitalDelta][
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]]] := 
         If[$CellContext`s < $CellContext`len, 
           0, $CellContext`k1[
            0] $CellContext`kdiff $CellContext`len], $CellContext`k1[
           Pattern[$CellContext`s, 
            Blank[]]] := 1, $CellContext`k2[
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]]] := If[
           Or[$CellContext`s < 0, $CellContext`s > $CellContext`len], 
           $CellContext`k1[
           0], $CellContext`k1[0] $CellContext`kdiff], $CellContext`\[Omega] := 
         3, $CellContext`w22[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]]] := $CellContext`a1[$CellContext`s] 
          Sin[$CellContext`k1[$CellContext`s] $CellContext`s - $CellContext`\
\[Omega] $CellContext`t], $CellContext`a1[
           Pattern[$CellContext`s, 
            Blank[]]] = 3, $CellContext`v11[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`\[Phi], 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := $CellContext`a2[$CellContext`s, $CellContext`loss] 
          Sin[($CellContext`\[Phi] + \
$CellContext`\[CapitalDelta][$CellContext`s, $CellContext`kdiff] + \
$CellContext`k2[$CellContext`s, $CellContext`kdiff] $CellContext`s) - \
$CellContext`\[Omega] $CellContext`t], $CellContext`w11[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`\[Phi], 
            Blank[]]] := $CellContext`a1[$CellContext`s] 
          Sin[($CellContext`\[Phi] + $CellContext`k1[$CellContext`s] \
$CellContext`s) - $CellContext`\[Omega] $CellContext`t], $CellContext`blue := 
         RGBColor[0.392193, 0.584307, 0.929395], $CellContext`box = 
         Graphics3D[{{
             AbsoluteThickness[2], 
             
             Line[{{-6, 12 Pi, -6}, {-6, 12 Pi, 6}, {6, 12 Pi, 6}, {
               6, 12 Pi, -6}, {-6, 12 Pi, -6}}]}, {
             AbsoluteThickness[2], 
             
             Line[{{-6, 0, -6}, {-6, 0, 6}, {6, 0, 6}, {6, 0, -6}, {-6, 
              0, -6}}]}, {
             AbsoluteThickness[2], 
             Line[{{-6, 0, -6}, {-6, 12 Pi, -6}}]}, {
             AbsoluteThickness[2], 
             Line[{{6, 0, 6}, {6, 12 Pi, 6}}]}, {
             AbsoluteThickness[2], 
             Line[{{-6, 0, 6}, {-6, 12 Pi, 6}}]}, {
             AbsoluteThickness[2], 
             Line[{{6, 0, -6}, {6, 12 Pi, -6}}]}}, {}], $CellContext`green := 
         RGBColor[
          0.380001, 0.700003, 
           0.159993], $CellContext`pos2 := $CellContext`len + 7 Pi, 
         Attributes[PlotRange] = {ReadProtected}}; ($CellContext`blue := 
         RGBColor[0.392193, 0.584307, 0.929395]; $CellContext`red := 
         RGBColor[0.829997, 0.239998, 0.099994]; $CellContext`green := 
         RGBColor[0.380001, 0.700003, 0.159993]; $CellContext`\[Omega] := 
         3; $CellContext`amp := 3; $CellContext`len := 
         12 Pi; $CellContext`pos2 := $CellContext`len + 7 Pi; $CellContext`k1[
          
           Pattern[$CellContext`s, 
            Blank[]]] := 1; $CellContext`k2[
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]]] := If[
           Or[$CellContext`s < 0, $CellContext`s > $CellContext`len], 
           $CellContext`k1[
           0], $CellContext`k1[
            0] $CellContext`kdiff]; $CellContext`\[CapitalDelta][
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]]] := 
         If[$CellContext`s < $CellContext`len, 
           0, $CellContext`k1[
            0] $CellContext`kdiff $CellContext`len]; $CellContext`a1[
           Pattern[$CellContext`s, 
            Blank[]]] = $CellContext`amp; $CellContext`a2[
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := If[$CellContext`s < 0, $CellContext`amp, 
           If[
            
            And[$CellContext`s >= 
             0, $CellContext`s <= $CellContext`len], $CellContext`amp (
             1 - ($CellContext`loss/
              100) ($CellContext`s/$CellContext`len)), $CellContext`amp (
             1 - $CellContext`loss/100)]]; $CellContext`w11[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`\[Phi], 
            Blank[]]] := $CellContext`a1[$CellContext`s] 
          Sin[($CellContext`\[Phi] + $CellContext`k1[$CellContext`s] \
$CellContext`s) - $CellContext`\[Omega] $CellContext`t]; $CellContext`w22[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]]] := $CellContext`a1[$CellContext`s] 
          Sin[$CellContext`k1[$CellContext`s] $CellContext`s - $CellContext`\
\[Omega] $CellContext`t]; $CellContext`v11[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`\[Phi], 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := $CellContext`a2[$CellContext`s, $CellContext`loss] 
          Sin[($CellContext`\[Phi] + \
$CellContext`\[CapitalDelta][$CellContext`s, $CellContext`kdiff] + \
$CellContext`k2[$CellContext`s, $CellContext`kdiff] $CellContext`s) - \
$CellContext`\[Omega] $CellContext`t]; $CellContext`v22[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]]] := $CellContext`a2[$CellContext`s, $CellContext`loss] 
          Sin[($CellContext`\[CapitalDelta][$CellContext`s, \
$CellContext`kdiff] + $CellContext`k2[$CellContext`s, $CellContext`kdiff] \
$CellContext`s) - $CellContext`\[Omega] $CellContext`t]; $CellContext`xx := 
         2 $CellContext`amp; $CellContext`box = Show[
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{-$CellContext`xx, $CellContext`len, -$CellContext`xx}, \
{-$CellContext`xx, $CellContext`len, $CellContext`xx}, {$CellContext`xx, \
$CellContext`len, $CellContext`xx}, {$CellContext`xx, $CellContext`len, \
-$CellContext`xx}, {-$CellContext`xx, $CellContext`len, -$CellContext`xx}}]}], 
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{-$CellContext`xx, 0, -$CellContext`xx}, {-$CellContext`xx,
                 0, $CellContext`xx}, {$CellContext`xx, 
                0, $CellContext`xx}, {$CellContext`xx, 
                0, -$CellContext`xx}, {-$CellContext`xx, 
                0, -$CellContext`xx}}]}], 
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{-$CellContext`xx, 
                0, -$CellContext`xx}, {-$CellContext`xx, $CellContext`len, \
-$CellContext`xx}}]}], 
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{$CellContext`xx, 
                0, $CellContext`xx}, {$CellContext`xx, $CellContext`len, \
$CellContext`xx}}]}], 
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{-$CellContext`xx, 
                0, $CellContext`xx}, {-$CellContext`xx, $CellContext`len, \
$CellContext`xx}}]}], 
           Graphics3D[{
             AbsoluteThickness[2], 
             
             Line[{{$CellContext`xx, 
                0, -$CellContext`xx}, {$CellContext`xx, $CellContext`len, \
-$CellContext`xx}}]}]]; $CellContext`waveSup[
           Pattern[$CellContext`t, 
            Blank[]], 
           Pattern[$CellContext`s, 
            Blank[]], 
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            
            Blank[]]] := {$CellContext`v22[$CellContext`t, $CellContext`s, \
$CellContext`kdiff, $CellContext`loss] + $CellContext`w22[$CellContext`t, \
$CellContext`s], $CellContext`s, $CellContext`v11[$CellContext`t, \
$CellContext`s, Pi/
             2, $CellContext`kdiff, $CellContext`loss] + \
$CellContext`w11[$CellContext`t, $CellContext`s, (-Pi)/
             2]}; $CellContext`orplot[
           Pattern[$CellContext`kdiff, 
            Blank[]], 
           Pattern[$CellContext`loss, 
            Blank[]], 
           Pattern[$CellContext`t, 
            Blank[]]] := Module[{$CellContext`s, $CellContext`t2}, 
           Show[
            ParametricPlot3D[
             $CellContext`waveSup[$CellContext`t, $CellContext`s, \
$CellContext`kdiff, $CellContext`loss], {$CellContext`s, (-5) 
              Pi, $CellContext`len + 5 Pi}, Boxed -> False, Axes -> False, 
             PlotStyle -> {$CellContext`blue, 
               AbsoluteThickness[3.]}], $CellContext`box, 
            Graphics3D[{$CellContext`green, 
              AbsoluteThickness[3.], 
              Line[{{0, $CellContext`pos2, 0}, 
                $CellContext`waveSup[$CellContext`t, $CellContext`pos2, \
$CellContext`kdiff, $CellContext`loss]}]}], 
            ParametricPlot3D[
             $CellContext`waveSup[$CellContext`t2, $CellContext`pos2, \
$CellContext`kdiff, $CellContext`loss], {$CellContext`t2, 0, 2 Pi}, Boxed -> 
             False, Axes -> False, PlotStyle -> {Black, 
               AbsoluteThickness[1.]}], PlotRange -> All, 
            ImageSize -> {450, 350}]]; Null)}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->249891066],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Circularly polarized light waves (or, in general, electromagnetic waves) can \
be constructed as a superposition of two linearly polarized light waves of \
the same frequency with perpendicular planes of polarization, equal \
amplitudes, and a phase shift of one quarter of a wavelength. Depending on \
the sign of the phase shift the resulting wave is a left- or right-hand \
circularly polarized wave.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "In turn, a linearly polarized light wave can be constructed from a \
superposition of a left- and a right-hand circularly polarized wave. The \
plane of polarization depends on the phase shift between the two circularly \
polarized components. We can use this behavior to explain the phenomenon of \
",
 StyleBox["optical rotation",
  FontSlant->"Italic"],
 ". Consider a medium, indicated  in the animation by the rectangular box, \
that is chiral. For example, in chemistry one has a solution of a chiral \
compound with some enantiomeric excess. The medium interacts slightly \
differently with the left- and the right-hand circular components of a \
linearly polarized light wave. (The electric field vector goes around on a \
left- or right-handed helix that can also be considered chiral.) These \
different interactions cause the refractive indices for the circular \
components to be slightly different, slowing down one of the circular \
components more than the other as they enter the medium. As the linearly \
polarized wave passes through the medium, the phase shift increases between \
the two circular components, which manifests in a rotation of the plane of \
polarization of their superposition."
}], "Text"],

Cell["\<\
The animation is constructed in exactly this way. The electric field vector \
for the incoming linearly polarized wave, in blue, is constructed as a \
superposition of left- and right-hand circularly polarized components. You \
can adjust the ratio of the wave vectors for the left- and right-hand \
circular components. The more the ratio deviates from unity, the larger the \
optical rotation angle becomes. As you can see, the rotation angle is also \
proportional to the path length that the light wave takes through the chiral \
medium. There is a symbolic \"detector\" that traces the amplitude of the \
outgoing wave at a fixed position. \
\>", "Text"],

Cell[TextData[{
 "If the chiral medium also absorbs light, then the amplitude ratio of the \
two circularly polarized components changes, in addition to the change in \
their relative phase. The medium exhibits ",
 StyleBox["circular dichroism",
  FontSlant->"Italic"],
 ", that is, the absorption coefficients for the circular components are \
slightly different. A percentage absorption can be selected in the animation \
for one of the circularly polarized components relative to the other over the \
full path length. For simplicity, the animation is constructed such that the \
first component is not absorbed at all. Also, the Demonstration assumes that \
a simple linear decrease of the amplitude has been applied instead of the \
exponential decrease according to Beer's law. The result is an outgoing wave \
that not only has its plane of polarization rotated but is also ",
 StyleBox["elliptically polarized",
  FontSlant->"Italic"],
 ". In the case of 100% absorption you can see the single remaining \
circularly polarized component. The amount of ellipticity, which is \
proportional to the medium's circular dichroism, is also shown by the \
detector. "
}], "Text"],

Cell["\<\
The animation, qualitatively, models what goes on inside a polarimeter. Note \
that the dimensions (wavelengths versus cuvette size, etc.) are not to scale! \
We suggest pausing the animation between rotations because it is quite CPU \
intensive.\
\>", "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "See the ",
 ButtonBox["author's web page",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.nsm.buffalo.edu/~jochena/research/opticalactivity.html"], 
    None}],
 " for more information on this subject."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Optical Rotation and Ellipticity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/OpticalRotationAndEllipticity/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/OpticalRotationAndEllipticity/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/OpticalRotationAndEllipticity/",
  
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/OpticalRotationAndEllipticity/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/OpticalRotationAndEllipticity/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Jochen Autschbach",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jochen+\
Autschbach"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jochen+Autschbach"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
OpticalRotationAndEllipticity"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Optical Rotation and Ellipticity - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[634, 23, 152, 3, 70, "Section"],
Cell[789, 28, 3700, 64, 70, "Section"],
Cell[4492, 94, 19470, 465, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23999, 564, 15256, 334, 70, "Output",
 CellID->249891066],
Cell[CellGroupData[{
Cell[39280, 902, 209, 6, 70, "Section"],
Cell[39492, 910, 427, 7, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[39945, 921, 1244, 20, 70, "Text"],
Cell[41192, 943, 669, 10, 70, "Text"],
Cell[41864, 955, 1179, 20, 70, "Text"],
Cell[43046, 977, 270, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[43341, 986, 209, 6, 70, "Section"],
Cell[43553, 994, 247, 8, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[43836, 1007, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[44194, 1018, 975, 29, 70, "Text"],
Cell[45172, 1049, 445, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[45642, 1067, 815, 24, 70, "Text"],
Cell[46460, 1093, 1201, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature KQNSSq2SAePwtBTBF34IPSwr *)
