(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    175667,       4262]
NotebookOptionsPosition[    173229,       4185]
NotebookOutlinePosition[    173903,       4210]
CellTagsIndexPosition[    173860,       4207]
WindowTitle->Motion/Pursuit Law in 1D (Visual Depth Perception 1) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Motion/Pursuit Law in 1D (Visual Depth Perception 1)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"nORM", "[", 
      RowBox[{"vector_", "?", "VectorQ"}], "]"}], ":=", 
     SqrtBox[
      RowBox[{"vector", ".", "vector"}]]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"degrees", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"arcMinutes", "[", "q_", "]"}], ":=", 
     RowBox[{"q", "*", "60", "*", 
      RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"aim\[Psi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"headAimVector", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"midPoint", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{"aimOffset", "*", "interOcular", "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "-", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeCenter", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"base", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", "aimOffset"}], ")"}], "*", "interOcular",
        "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"headAimVector", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"rightEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"rightViewVector", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
        "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"rightViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftViewVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"fixate", "-", 
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftEyeNode", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"leftEyeCenter", "[", 
       RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
      RowBox[{"nodePercent", "*", "eyeRadius", "*", 
       RowBox[{
        RowBox[{"leftViewVector", "[", 
         RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
         "]"}], "/", 
        RowBox[{"nORM", "[", 
         RowBox[{"leftViewVector", "[", 
          RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
          "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fixateConvergence", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}]}], 
      ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Alpha]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[CurlyPhi]", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
      RowBox[{"aim\[Psi]", "[", 
       RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rightDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"rightEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"rightDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"leftDistractVector", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"distraction", "-", 
      RowBox[{"leftEyeNode", "[", 
       RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Delta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"leftDistractVector", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"convergenceDistraction", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"left\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"left\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"right\[CurlyPhi]", "[", 
             RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
             "]"}], "-", 
            RowBox[{"right\[Delta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
              "base"}], "]"}]}], "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}]}], "]"}], ",", "0.0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}], "-", 
         RowBox[{"left\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
           "base"}], "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"right\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
       "-", 
       RowBox[{"left\[Delta]", "[", 
        RowBox[{
        "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
        "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{
     RowBox[{"binocularDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"right\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"right\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"right\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"left\[Theta]inside", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"left\[Theta]", "[", 
       RowBox[{
       "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
       "]"}], "+", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"nodePercent", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"left\[Theta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"retinalDisparity", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Or", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
         RowBox[{
          RowBox[{"left\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "<", 
          RowBox[{
           RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
         RowBox[{
          RowBox[{"right\[Theta]", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], ">", 
          RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}], "-", 
         RowBox[{"left\[Theta]inside", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eDGE", "[", 
      RowBox[{
       RowBox[{"L_", "?", "VectorQ"}], ",", 
       RowBox[{"R_", "?", "VectorQ"}], ",", 
       RowBox[{"F_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "bX", ",", "bY", ",", "c", ",", "r"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bX", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bY", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"-", 
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", ".", "L"}], ",", 
               RowBox[{"R", ".", "R"}], ",", 
               RowBox[{"F", ".", "F"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"bX", ",", "bY"}], "}"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", " ", "a"}], ")"}]}], "+", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            SqrtBox[
             RowBox[{
              SuperscriptBox["bX", "2"], "+", 
              SuperscriptBox["bY", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]], 
            RowBox[{"2", 
             RowBox[{"Abs", "[", "a", "]"}]}]], ",", "0"}], "}"}]}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"antiEDGE", "[", 
      RowBox[{
       RowBox[{"L_", "?", "VectorQ"}], ",", 
       RowBox[{"R_", "?", "VectorQ"}], ",", 
       RowBox[{"F_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "bX", ",", "bY", ",", "c", ",", "r"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bX", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bY", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"-", 
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", ".", "L"}], ",", 
               RowBox[{"R", ".", "R"}], ",", 
               RowBox[{"F", ".", "F"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"bX", ",", "bY"}], "}"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", " ", "a"}], ")"}]}], "-", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            SqrtBox[
             RowBox[{
              SuperscriptBox["bX", "2"], "+", 
              SuperscriptBox["bY", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]], 
            RowBox[{"2", 
             RowBox[{"Abs", "[", "a", "]"}]}]], ",", "0"}], "}"}]}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rADIUS", "[", 
      RowBox[{
       RowBox[{"L_", "?", "VectorQ"}], ",", 
       RowBox[{"R_", "?", "VectorQ"}], ",", 
       RowBox[{"F_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "bX", ",", "bY", ",", "c", ",", "r"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bX", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bY", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"-", 
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", ".", "L"}], ",", 
               RowBox[{"R", ".", "R"}], ",", 
               RowBox[{"F", ".", "F"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        FractionBox[
         SqrtBox[
          RowBox[{
           SuperscriptBox["bX", "2"], "+", 
           SuperscriptBox["bY", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]], 
         RowBox[{"2", 
          RowBox[{"Abs", "[", "a", "]"}]}]]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cENTER", "[", 
      RowBox[{
       RowBox[{"L_", "?", "VectorQ"}], ",", 
       RowBox[{"R_", "?", "VectorQ"}], ",", 
       RowBox[{"F_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "bX", ",", "bY", ",", "c", ",", "r"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bX", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bY", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"-", 
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", ".", "L"}], ",", 
               RowBox[{"R", ".", "R"}], ",", 
               RowBox[{"F", ".", "F"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"bX", ",", "bY"}], "}"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", "a"}], ")"}]}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cIRCLE", "[", 
      RowBox[{
       RowBox[{"L_", "?", "VectorQ"}], ",", 
       RowBox[{"R_", "?", "VectorQ"}], ",", 
       RowBox[{"F_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "bX", ",", "bY", ",", "c", ",", "r"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bX", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"bY", "=", 
         RowBox[{"Det", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"R", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"F", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"L", ".", "L"}], ",", 
              RowBox[{"R", ".", "R"}], ",", 
              RowBox[{"F", ".", "F"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"c", "=", 
         RowBox[{"-", 
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", ".", "L"}], ",", 
               RowBox[{"R", ".", "R"}], ",", 
               RowBox[{"F", ".", "F"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"L", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"R", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"F", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}], "]"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"bX", ",", "bY"}], "}"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", " ", "a"}], ")"}]}], ",", 
          FractionBox[
           SqrtBox[
            RowBox[{
             SuperscriptBox["bX", "2"], "+", 
             SuperscriptBox["bY", "2"], "-", 
             RowBox[{"4", " ", "a", " ", "c"}]}]], 
           RowBox[{"2", 
            RowBox[{"Abs", "[", "a", "]"}]}]]}], "]"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyePict", "[", 
      RowBox[{
       RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
       RowBox[{
        RowBox[{"viewVector", "=", 
         RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"viewVector", "=", 
         RowBox[{"viewVector", "/", 
          RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray", ",", 
               RowBox[{"Circle", "[", 
                RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                   RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                  "}"}]}], "]"}]}], "}"}], "]"}], ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Gray", ",", "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", " ", 
                  RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                 RowBox[{".5", "eyeRadius"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                   RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
              "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Green", ",", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", 
                  RowBox[{
                  "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], ",", 
                 RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
           "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eyeEdge", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"eyeRadius", "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"inRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"leftEyeCenter", "[", 
            RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
           "fixate"}], "]"}], ",", 
         RowBox[{"eyePict", "[", 
          RowBox[{
           RowBox[{"rightEyeCenter", "[", 
            RowBox[{"headAimVector", ",", "base"}], "]"}], ",", "fixate"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "-", 
                 RowBox[{"eyeRadius", "*", 
                  RowBox[{
                   RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                   RowBox[{"nORM", "[", 
                    RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}],
                 ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                 RowBox[{"eyeEdge", "[", 
                  RowBox[{
                   RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                   RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Green", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}], "}"}],
                "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"min", "=", 
           RowBox[{"Min", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"MAX", "=", 
           RowBox[{"Max", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}], "-", 
               RowBox[{"retinalDisparity", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"left\[CurlyPhi]", "[", 
                RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], 
               "-", "\[Pi]", "-", 
               RowBox[{"left\[Theta]inside", "[", 
                RowBox[{
                "headAimVector", ",", "fixate", ",", "distraction", ",", 
                 "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Brown", ",", 
             RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                "eyeRadius", ",", 
                RowBox[{"{", 
                 RowBox[{"min", ",", "MAX"}], "}"}]}], "]"}], "}"}]}], "}"}], 
           "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "interOcular"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", "interOcular"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"midPoint", "[", 
               RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", "interOcular"}]}], "}"}]}],
          "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"outRays", "[", 
      RowBox[{
       RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}], ",", 
       RowBox[{"distraction_", "?", "VectorQ"}], ",", 
       RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "fixate", "]"}], "]"}], "}"}]}], "}"}], "]"}],
          ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Point", "[", 
              RowBox[{"N", "[", "distraction", "]"}], "]"}], "}"}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"fixate", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"{", 
             RowBox[{"Line", "[", 
              RowBox[{"N", "[", 
               RowBox[{"{", 
                RowBox[{"distraction", ",", 
                 RowBox[{"leftEyeNode", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
                  "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"movingEyePict", "[", 
      RowBox[{
       RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
       RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
       RowBox[{
        RowBox[{"viewVector", "=", 
         RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"viewVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"viewVector", "=", 
         RowBox[{"viewVector", "/", 
          RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
               RowBox[{"Dashing", "[", ".0125", "]"}], ",", "Gray", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"eyeCenter", "-", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.", "eyeRadius"}], ",", 
                    RowBox[{"1.5", "eyeRadius"}]}], "}"}]}], ",", 
                    RowBox[{"eyeCenter", "+", 
                    RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{"1.", "eyeRadius"}], ",", 
                    RowBox[{
                    RowBox[{"-", "1.5"}], "eyeRadius"}]}], "}"}]}], ",", 
                    RowBox[{"eyeCenter", "+", 
                    RowBox[{"{", " ", 
                    RowBox[{
                    RowBox[{".6", "eyeRadius"}], ",", 
                    RowBox[{
                    RowBox[{"-", "1.8"}], "eyeRadius"}]}], "}"}]}]}], "}"}], 
                  "]"}], ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                    RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                    "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Gray", ",", "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", " ", 
                  RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                 RowBox[{".5", "eyeRadius"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                   RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
              "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Green", ",", "\[IndentingNewLine]", 
               RowBox[{"Disk", "[", 
                RowBox[{
                 RowBox[{"eyeCenter", "+", 
                  RowBox[{
                  "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], ",", 
                 RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
           "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Real", " ", "Program", " ", "Starts", " ", "Here"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"f", "=", 
     RowBox[{
      RowBox[{"fixate", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "-", 
      RowBox[{"n", " ", "r"}]}]}], ";", 
    RowBox[{"d", "=", 
     RowBox[{
      RowBox[{"distraction", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "-", 
      RowBox[{"fixate", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"fixate", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "f"}], "}"}]}], ";", 
      RowBox[{"distraction", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"f", "+", "d"}]}], "}"}]}], ";"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"r", "=", 
     RowBox[{"eyeRadius", "=", "1.3"}]}], ";", 
    RowBox[{"i", "=", 
     RowBox[{"interOcular", "=", "6.5"}]}], ";", 
    RowBox[{"aimOffset", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{"n", "=", 
     RowBox[{"nodePercent", "=", 
      RowBox[{"1", "/", "2"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"aim", "=", "0"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"headAimVector", "[", "aim_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"aim", " ", 
         RowBox[{"\[Pi]", "/", "180"}]}], "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"aim", " ", 
         RowBox[{"\[Pi]", "/", "180"}]}], "]"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"base", "[", "t_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"interOcular", "*", "t"}], ",", "0"}], "}"}]}], ";", 
    RowBox[{
     RowBox[{"aimHead", "[", "t_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"t", "=", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2."}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"inRays", "[", 
         RowBox[{
          RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
          RowBox[{"fixate", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{"distraction", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{
           RowBox[{"base", "[", "0", "]"}], "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"outRays", "[", 
         RowBox[{
          RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
          RowBox[{"fixate", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{"distraction", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{
           RowBox[{"base", "[", "0", "]"}], "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"midPoint", "[", 
             RowBox[{
              RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
              RowBox[{
               RowBox[{"base", "[", "0", "]"}], "+", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], "]"}], 
            "]"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "fixate", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< = \>\"", ",", "f", ",", "\"\< cm\>\""}], "}"}], "]"}],
                ",", 
               RowBox[{
                RowBox[{"fixate", "/", "2"}], "+", 
                RowBox[{"scale", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", ".08"}], ",", "0"}], "}"}]}]}]}], "]"}], ",", 
             
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{
                  RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                  RowBox[{"fixate", "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                  RowBox[{
                   RowBox[{"base", "[", "0", "]"}], "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                 "]"}], ",", 
                RowBox[{"fixate", "+", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], "}"}],
               "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{
                  RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                  RowBox[{"fixate", "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                  RowBox[{
                   RowBox[{"base", "[", "0", "]"}], "+", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                 "]"}], ",", 
                RowBox[{"fixate", "+", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], "}"}],
               "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Circle", "[", 
              RowBox[{"fixate", ",", "1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"left\[CurlyPhi]", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                    RowBox[{"fixate", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"base", "[", "0", "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                   "]"}], "+", "\[Pi]"}], ",", 
                 RowBox[{
                  RowBox[{"right\[CurlyPhi]", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                    RowBox[{"fixate", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"base", "[", "0", "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                   "]"}], "+", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"HoldForm", "[", 
                   FractionBox[
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "\[Alpha]"}], 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "t"}]], "]"}], ",", "\"\<(0)\>\"", 
                  ",", "\"\< = \>\"", ",", 
                  RowBox[{"Round", "[", 
                   RowBox[{
                    RowBox[{"degrees", "[", 
                    FractionBox["i", 
                    RowBox[{"f", "+", 
                    RowBox[{"n", " ", "r"}]}]], "]"}], ",", ".1"}], "]"}], 
                  ",", "\"\<\[Degree]/sec\>\""}], "}"}], "]"}], ",", 
               RowBox[{"scale", 
                RowBox[{"{", 
                 RowBox[{".25", ",", ".6"}], "}"}]}]}], "]"}]}], "}"}]}], 
          "}"}], "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "distraction", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], ",", 
                  "\"\< = \>\"", ",", "d", ",", "\"\< cm\>\""}], "}"}], "]"}],
                ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"distraction", "+", "fixate"}], ")"}], "/", "2"}], 
                "+", 
                RowBox[{"scale", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", ".08"}], ",", "0"}], "}"}]}]}]}], "]"}], ",", 
             
             RowBox[{"Circle", "[", 
              RowBox[{"distraction", ",", "1", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"left\[Delta]", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                    RowBox[{"fixate", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    " ", 
                    RowBox[{"distraction", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"base", "[", "0", "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                   "]"}], "+", "\[Pi]"}], ",", 
                 RowBox[{
                  RowBox[{"right\[Delta]", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", 
                    RowBox[{"fixate", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    " ", 
                    RowBox[{"distraction", "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"base", "[", "0", "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{".6", " ", "scale"}], ",", "0"}], "}"}]}]}], 
                   "]"}], "+", "\[Pi]"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Row", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"HoldForm", "[", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                   "\[InvisibleSpace]", "\[Theta]"}], 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                   "\[InvisibleSpace]", "\[Alpha]"}]], "]"}], ",", 
                "\"\< = \>\"", ",", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  FractionBox["d", 
                   RowBox[{"f", "+", "d"}]], ",", ".01"}], "]"}]}], "}"}], 
              "]"}], ",", 
             RowBox[{"scale", 
              RowBox[{"{", 
               RowBox[{".25", ",", ".4"}], "}"}]}]}], "]"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Row", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"HoldForm", "[", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                   "\[InvisibleSpace]", "\[Theta]"}], 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "\[Alpha]"}], "-", 
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "\[Theta]"}]}]], "]"}], ",", 
                "\"\< = \>\"", ",", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  FractionBox["d", "f"], ",", ".01"}], "]"}]}], "}"}], "]"}], 
             ",", 
             RowBox[{"scale", 
              RowBox[{"{", 
               RowBox[{".25", ",", ".2"}], "}"}]}]}], "]"}]}], "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Magenta", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"HoldForm", "[", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "\[Theta]"}], 
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    "\[InvisibleSpace]", "t"}]], "]"}], ",", "\"\<(0)\>\"", 
                 ",", "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"N", "[", 
                    RowBox[{"degrees", "[", 
                    FractionBox[
                    RowBox[{"d", " ", "i"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"d", "+", "f"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"f", "+", 
                    RowBox[{"n", " ", "r"}]}], ")"}]}]], "]"}], "]"}], ",", 
                   ".01"}], "]"}], ",", "\"\<\[Degree]/sec\>\""}], "}"}], 
               "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{".25", ",", ".8"}], "}"}]}]}], "]"}], "}"}]}], "}"}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"movingEyePict", "[", 
         RowBox[{
          RowBox[{"rightEyeCenter", "[", 
           RowBox[{
            RowBox[{"aimHead", "[", "t", "]"}], ",", 
            RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", "fixate"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"{", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"2", 
                 RowBox[{"rightEyeCenter", "[", 
                  RowBox[{
                   RowBox[{"aimHead", "[", "t", "]"}], ",", 
                   RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "-", 
                RowBox[{"leftEyeCenter", "[", 
                 RowBox[{
                  RowBox[{"aimHead", "[", "t", "]"}], ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"2", 
                 RowBox[{"leftEyeCenter", "[", 
                  RowBox[{
                   RowBox[{"aimHead", "[", "t", "]"}], ",", 
                   RowBox[{"base", "[", "t", "]"}]}], "]"}]}], "-", 
                RowBox[{"rightEyeCenter", "[", 
                 RowBox[{
                  RowBox[{"aimHead", "[", "t", "]"}], ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}]}]}], "}"}], "]"}], 
            "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "fixate", "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{
                  RowBox[{"aimHead", "[", "t", "]"}], ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", "fixate"}], 
               "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"rightEyeNode", "[", 
                 RowBox[{
                  RowBox[{"aimHead", "[", "t", "]"}], ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", "fixate"}], 
               "}"}], "]"}]}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "distraction", "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftEyeNode", "[", 
                 RowBox[{
                  RowBox[{"aimHead", "[", "t", "]"}], ",", "fixate", ",", 
                  RowBox[{"base", "[", "t", "]"}]}], "]"}], ",", 
                "distraction"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"rightEyeNode", "[", 
                  RowBox[{
                   RowBox[{"aimHead", "[", "t", "]"}], ",", "fixate", ",", 
                   RowBox[{"base", "[", "t", "]"}]}], "]"}], "+", 
                 RowBox[{"{", 
                  RowBox[{".1", ",", "0"}], "}"}]}], ",", 
                RowBox[{"distraction", "+", 
                 RowBox[{"{", 
                  RowBox[{".1", ",", "0"}], "}"}]}]}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"fixate", ",", "distraction"}], "}"}], "]"}]}], 
            "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Purple", ",", 
           RowBox[{"{", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<t\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"scale", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", ".04"}], " ", ",", ".05"}], "}"}]}]}], "]"}], 
            "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "fixate", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<F\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", ".05"}], "scale"}], ",", "f"}], "}"}]}], 
              "]"}]}], "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "distraction", "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<D\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", ".05"}], "scale"}], ",", 
                 RowBox[{"f", "+", "d"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], 
         "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"scale", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".2"}], ",", ".8"}], " ", "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.5"}], ",", "scale"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fixate", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"50", "+", 
          RowBox[{"n", " ", "r"}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"15", "+", 
        RowBox[{"n", " ", "r"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1000", "+", 
        RowBox[{"n", " ", "r"}]}]}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"distraction", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"60", "+", 
          RowBox[{"n", " ", "r"}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"5", "+", 
        RowBox[{"n", " ", "r"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1100", "+", 
        RowBox[{"n", " ", "r"}]}]}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"scale", ",", "64"}], "}"}], ",", "50", ",", "1200", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.415631056611476*^9, 3.415631100678975*^9}, 
   3.4156311776434717`*^9, {3.415631212455894*^9, 3.415631221344046*^9}, {
   3.415631553121703*^9, 3.415631584441774*^9}, {3.41563170387989*^9, 
   3.4156318135764427`*^9}, {3.415631844613402*^9, 3.415631994351959*^9}, 
   3.415632076206313*^9, {3.415632132888604*^9, 3.415632230077179*^9}, {
   3.415632280138607*^9, 3.4156323162096653`*^9}, {3.415632358076092*^9, 
   3.415632459415897*^9}, {3.415632515962677*^9, 3.415632542101994*^9}, {
   3.415636745825086*^9, 3.415636757515396*^9}, 3.415636809129287*^9, {
   3.4156368697570744`*^9, 3.4156370774816113`*^9}, {3.415637124942294*^9, 
   3.4156371289234953`*^9}, {3.415637159617889*^9, 3.415637159753862*^9}, {
   3.415637209897422*^9, 3.4156372205903378`*^9}, {3.415637281112441*^9, 
   3.415637331448494*^9}, {3.4156373639313393`*^9, 3.415637389769145*^9}, {
   3.4156374701608963`*^9, 3.415637473497898*^9}, {3.4156375228988132`*^9, 
   3.4156375667511044`*^9}, {3.4156379721031313`*^9, 
   3.4156380063918877`*^9}, {3.415638187553422*^9, 3.415638214899034*^9}, {
   3.41563824614327*^9, 3.415638285774281*^9}, {3.415638356485004*^9, 
   3.415638358483034*^9}, {3.415638451030836*^9, 3.415638470884265*^9}, {
   3.41563852409552*^9, 3.415638602895067*^9}, {3.41563865045817*^9, 
   3.4156387126590767`*^9}, {3.415638796930463*^9, 3.415638800740904*^9}, {
   3.415638985477434*^9, 3.415638997282158*^9}, 3.4156390318566437`*^9, {
   3.415639073626341*^9, 3.415639135728075*^9}, {3.415639186619458*^9, 
   3.415639216906703*^9}, {3.4156392506044197`*^9, 3.41563928550809*^9}, {
   3.415639336954619*^9, 3.415639338739873*^9}, {3.415639445470993*^9, 
   3.415639507758444*^9}, {3.423236864281934*^9, 3.4232369041648808`*^9}, {
   3.42323693781913*^9, 3.423236948696603*^9}, {3.423236987940701*^9, 
   3.42323699450814*^9}, 3.423251431702692*^9, {3.423263279597601*^9, 
   3.423263295386057*^9}, {3.423263327541277*^9, 3.4232633551010637`*^9}, {
   3.423263387408484*^9, 3.423263479064974*^9}, {3.423263519153284*^9, 
   3.423263559418202*^9}, {3.4232635988139277`*^9, 3.423263798246532*^9}, {
   3.42326383414931*^9, 3.42326386173147*^9}, {3.423263903664654*^9, 
   3.423263947132983*^9}, {3.4232640001583138`*^9, 3.4232640011092043`*^9}, {
   3.423264145849874*^9, 3.423264180728039*^9}, {3.42326422237508*^9, 
   3.423264384479814*^9}, {3.423264422297311*^9, 3.4232644813636217`*^9}, 
   3.4232645147855787`*^9, {3.4232645501150227`*^9, 3.4232646680120583`*^9}, {
   3.423264716766341*^9, 3.423264779913115*^9}, {3.4232648467557583`*^9, 
   3.423264855431892*^9}, {3.423264922741559*^9, 3.423264961877684*^9}, {
   3.4232650005242357`*^9, 3.423265020805792*^9}, {3.42329912311366*^9, 
   3.423299124334407*^9}, {3.4232991756192102`*^9, 3.4232991768711042`*^9}, {
   3.4242823878183537`*^9, 3.4242825042603083`*^9}, {3.424282548468277*^9, 
   3.424282558336512*^9}, {3.4242825931501713`*^9, 3.4242827139778643`*^9}, {
   3.4242827698168173`*^9, 3.424282770246276*^9}, {3.424282800618389*^9, 
   3.424282801154138*^9}, {3.424282834387052*^9, 3.424282860231016*^9}, {
   3.424282905246375*^9, 3.424282905922577*^9}, {3.424282942176571*^9, 
   3.424282956132021*^9}, {3.424283005831724*^9, 3.424283024244396*^9}, {
   3.424283069975174*^9, 3.424283101995242*^9}, {3.42428313849393*^9, 
   3.424283260953487*^9}, {3.4242832927485456`*^9, 3.424283363140686*^9}, {
   3.424283429470469*^9, 3.424283568408002*^9}, 3.424283604204198*^9, {
   3.424283636380618*^9, 3.424283901001046*^9}, {3.424283984116294*^9, 
   3.424283984526732*^9}, {3.424284039777791*^9, 3.424284056881459*^9}, {
   3.424284088160502*^9, 3.424284100834837*^9}, 3.42428417296527*^9, {
   3.424512408770074*^9, 3.424512415279338*^9}, {3.424512465994439*^9, 
   3.424512524470704*^9}, {3.424512605826048*^9, 3.424512610758418*^9}, {
   3.424512656784676*^9, 3.424512703785899*^9}, {3.424512777872579*^9, 
   3.424512803774273*^9}, {3.424512840901731*^9, 3.424512846695043*^9}, {
   3.424512884126302*^9, 3.424512909830525*^9}, {3.424512945972084*^9, 
   3.424512981590308*^9}, {3.4245130295590067`*^9, 3.4245130486765003`*^9}, {
   3.424513088624631*^9, 3.424513097365821*^9}, {3.424513127968358*^9, 
   3.424513160329455*^9}, {3.4245132040833483`*^9, 3.4245132132193527`*^9}, {
   3.424513259454967*^9, 3.424513322754298*^9}, {3.424513355918378*^9, 
   3.424513438648827*^9}, {3.424513607289221*^9, 3.424513636106464*^9}, {
   3.424513668824822*^9, 3.4245137079088917`*^9}, {3.4245138310926*^9, 
   3.424513833774486*^9}, {3.424513910668495*^9, 3.424513929474641*^9}, {
   3.424513962914001*^9, 3.4245139974631863`*^9}, {3.424514052529852*^9, 
   3.424514052964099*^9}, {3.4245141224372673`*^9, 3.424514184337172*^9}, {
   3.4245142207700644`*^9, 3.42451425016292*^9}, {3.424514300584248*^9, 
   3.424514329951744*^9}, {3.424514408566025*^9, 3.424514410518792*^9}, 
   3.424514516835785*^9, {3.424514555319829*^9, 3.424514583308938*^9}, {
   3.424514686359003*^9, 3.424514726340806*^9}, {3.424514770388989*^9, 
   3.424514938150819*^9}, {3.424514972186554*^9, 3.424515009163306*^9}, {
   3.424515069794405*^9, 3.424515072870646*^9}, {3.424515113475712*^9, 
   3.424515121861742*^9}, {3.424515209006385*^9, 3.42451525346209*^9}, 
   3.424515300131174*^9, {3.4245153360311813`*^9, 3.424515378805505*^9}, {
   3.424515439875126*^9, 3.424515639785345*^9}, 3.424515694631094*^9, {
   3.424515748325714*^9, 3.4245157770820932`*^9}, {3.424515825230798*^9, 
   3.424515856420888*^9}, {3.424515890929833*^9, 3.424515988493887*^9}, {
   3.424516129512617*^9, 3.4245161961149597`*^9}, {3.424516268193221*^9, 
   3.4245162968523006`*^9}, {3.424516329452121*^9, 3.424516337328927*^9}, {
   3.424516446925193*^9, 3.424516466879252*^9}, {3.42451650091075*^9, 
   3.424516515196048*^9}, {3.424520110939067*^9, 3.424520114529502*^9}, {
   3.426433627309019*^9, 3.426433655324436*^9}, {3.426433700711772*^9, 
   3.426433713014002*^9}, {3.427059495295376*^9, 3.427059906409191*^9}, {
   3.4270599404187202`*^9, 3.427059966242217*^9}, {3.4270604906482267`*^9, 
   3.427060525423244*^9}, {3.427188138284197*^9, 3.427188140430327*^9}, {
   3.42718817394285*^9, 3.4271882246008463`*^9}, {3.4271882588439007`*^9, 
   3.427188269284728*^9}, {3.4271883406855087`*^9, 3.4271883540592957`*^9}, {
   3.4271883847588377`*^9, 3.427188385267047*^9}, {3.42718841567307*^9, 
   3.427188416853033*^9}, {3.427188453431868*^9, 3.427188458770343*^9}, 
   3.427188492912321*^9, 3.427188527496305*^9, {3.4271885640217257`*^9, 
   3.427188565366332*^9}, {3.4271886148131943`*^9, 3.427188625008706*^9}, {
   3.427188657733656*^9, 3.427188666011321*^9}, {3.427189061257873*^9, 
   3.4271890976877728`*^9}, {3.427189176193185*^9, 3.4271892431870413`*^9}, {
   3.4271893489096327`*^9, 3.427189534524495*^9}, {3.427189572860347*^9, 
   3.427189609944902*^9}, {3.427189762694724*^9, 3.427189826016609*^9}, {
   3.42719009626035*^9, 3.4271901073009567`*^9}, {3.427190199094952*^9, 
   3.4271902051907997`*^9}, {3.427190262294713*^9, 3.427190327503069*^9}, {
   3.4271903605192547`*^9, 3.42719036542962*^9}, 3.427190407471637*^9, {
   3.4271904433424053`*^9, 3.427190446664905*^9}, {3.427190482705638*^9, 
   3.4271905389554043`*^9}, {3.427190583863544*^9, 3.427190584450635*^9}, {
   3.427190629288126*^9, 3.427190629486751*^9}, 3.4271906621336937`*^9, {
   3.427190693984598*^9, 3.427190735559227*^9}, 3.427190772967812*^9, {
   3.427190853939989*^9, 3.427190861160449*^9}, {3.4271909431116877`*^9, 
   3.427191001211458*^9}, {3.427191034151986*^9, 3.427191044410037*^9}, {
   3.42719115341136*^9, 3.427191160701741*^9}, {3.427191222835347*^9, 
   3.4271912594634666`*^9}, {3.4271914088824463`*^9, 3.427191421138062*^9}, {
   3.427191544634218*^9, 3.427191562331807*^9}, {3.427191644593885*^9, 
   3.427191698240094*^9}, {3.427191755465748*^9, 3.42719176323597*^9}, {
   3.42719228362608*^9, 3.427192293127367*^9}, {3.430429540539099*^9, 
   3.4304295456332083`*^9}, 3.4304296733596973`*^9},
 CellID->1233924367]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`distraction$$ = {
    0, 60.65}, $CellContext`fixate$$ = {0, 50.65}, $CellContext`scale$$ = 64, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fixate$$], {0, 50.65}}, {0, 15.65}, {0, 1000.65}}, {{
      
       Hold[$CellContext`distraction$$], {0, 60.65}}, {0, 5.65}, {
      0, 1100.65}}, {{
       Hold[$CellContext`scale$$], 64}, 50, 1200}}, Typeset`size$$ = {
    400., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`fixate$23961$$ = {0, 
    0}, $CellContext`distraction$23962$$ = {0, 
    0}, $CellContext`scale$23963$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`distraction$$ = {
         0, 60.65}, $CellContext`fixate$$ = {0, 50.65}, $CellContext`scale$$ = 
        64}, "ControllerVariables" :> {
        Hold[$CellContext`fixate$$, $CellContext`fixate$23961$$, {0, 0}], 
        Hold[$CellContext`distraction$$, $CellContext`distraction$23962$$, {0,
          0}], 
        Hold[$CellContext`scale$$, $CellContext`scale$23963$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`nORM[
          PatternTest[
           Pattern[$CellContext`vector, 
            Blank[]], VectorQ]] := 
        Dot[$CellContext`vector, $CellContext`vector]^
         Rational[1, 2]; $CellContext`degrees[
          Pattern[$CellContext`q, 
           Blank[]]] := $CellContext`q (180/Pi); $CellContext`arcMinutes[
          Pattern[$CellContext`q, 
           Blank[]]] := ($CellContext`q 60) (180/Pi); $CellContext`aim\[Psi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[$CellContext`headAimVector, 1], 
          Part[$CellContext`headAimVector, 2]]; $CellContext`midPoint[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`base - ($CellContext`aimOffset \
$CellContext`interOcular) {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`base + ((
            1/2 - $CellContext`aimOffset) $CellContext`interOcular) {
            Part[$CellContext`headAimVector, 2], -
            Part[$CellContext`headAimVector, 1]}; $CellContext`leftEyeCenter[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := $CellContext`base - ((
           1/2 + $CellContext`aimOffset) $CellContext`interOcular) {
           Part[$CellContext`headAimVector, 2], -
           Part[$CellContext`headAimVector, 1]}; $CellContext`rightViewVector[
         
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`right\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`rightEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
($CellContext`nodePercent $CellContext`eyeRadius) \
($CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]/$CellContext`nORM[
            $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]]); $CellContext`leftViewVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`fixate - \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base]; \
$CellContext`left\[CurlyPhi][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 1], 
          Part[
           $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], 2]]; $CellContext`leftEyeNode[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
($CellContext`nodePercent $CellContext`eyeRadius) \
($CellContext`leftViewVector[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]/$CellContext`nORM[
            $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]]); $CellContext`fixateConvergence[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`left\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - $CellContext`aim\[Psi][$CellContext`headAimVector, \
$CellContext`base]; $CellContext`right\[Alpha][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`aim\[Psi][$CellContext`headAimVector, $CellContext`base]; \
$CellContext`rightDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`rightEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`right\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`rightDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`leftDistractVector[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`distraction - \
$CellContext`leftEyeNode[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]; $CellContext`left\[Delta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := ArcTan[
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 1], 
          Part[
           $CellContext`leftDistractVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], 
           2]]; $CellContext`convergenceDistraction[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          Or[
          Abs[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3., 
           Abs[$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]] > Pi/3.], 
          0., $CellContext`right\[Delta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; $CellContext`right\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - \
$CellContext`right\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]; $CellContext`left\[Theta][
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, 
           $CellContext`base] - \
$CellContext`left\[Delta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]; $CellContext`binocularDisparity[
         
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 
          0, $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base]]; \
$CellContext`right\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := \
$CellContext`right\[Theta][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`distraction, $CellContext`base] + 
         ArcSin[$CellContext`nodePercent Sin[
             $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]]; \
$CellContext`left\[Theta]inside[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], 
           VectorQ]] := $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] + 
         ArcSin[$CellContext`nodePercent Sin[
             $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]]; \
$CellContext`retinalDisparity[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := If[
          
          Or[$CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            2., $CellContext`left\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > 
           Pi/3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] < (-Pi)/
            3., $CellContext`right\[Theta][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] > Pi/2.], 0,
           $CellContext`right\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base] - \
$CellContext`left\[Theta]inside[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base]]; \
$CellContext`eDGE[
          PatternTest[
           Pattern[$CellContext`L, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`R, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`F, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`a, $CellContext`bX, $CellContext`bY, \
$CellContext`c, $CellContext`r}, $CellContext`a = Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bX = 
           Det[{{
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bY = 
           Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {1, 1, 
              1}}]; $CellContext`c = -Det[{{
                Dot[$CellContext`L, $CellContext`L], 
                Dot[$CellContext`R, $CellContext`R], 
                Dot[$CellContext`F, $CellContext`F]}, {
                Part[$CellContext`L, 1], 
                Part[$CellContext`R, 1], 
                Part[$CellContext`F, 1]}, {
                Part[$CellContext`L, 2], 
                Part[$CellContext`R, 2], 
                
                Part[$CellContext`F, 
                 2]}}]; {$CellContext`bX, $CellContext`bY}/(
            2 $CellContext`a) + {($CellContext`bX^2 + $CellContext`bY^2 - (
                4 $CellContext`a) $CellContext`c)^Rational[1, 2]/(2 
             Abs[$CellContext`a]), 0}]; $CellContext`antiEDGE[
          PatternTest[
           Pattern[$CellContext`L, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`R, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`F, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`a, $CellContext`bX, $CellContext`bY, \
$CellContext`c, $CellContext`r}, $CellContext`a = Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bX = 
           Det[{{
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bY = 
           Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {1, 1, 
              1}}]; $CellContext`c = -Det[{{
                Dot[$CellContext`L, $CellContext`L], 
                Dot[$CellContext`R, $CellContext`R], 
                Dot[$CellContext`F, $CellContext`F]}, {
                Part[$CellContext`L, 1], 
                Part[$CellContext`R, 1], 
                Part[$CellContext`F, 1]}, {
                Part[$CellContext`L, 2], 
                Part[$CellContext`R, 2], 
                
                Part[$CellContext`F, 
                 2]}}]; {$CellContext`bX, $CellContext`bY}/(
            2 $CellContext`a) - {($CellContext`bX^2 + $CellContext`bY^2 - (
               4 $CellContext`a) $CellContext`c)^Rational[1, 2]/(2 
            Abs[$CellContext`a]), 0}]; $CellContext`rADIUS[
          PatternTest[
           Pattern[$CellContext`L, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`R, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`F, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`a, $CellContext`bX, $CellContext`bY, \
$CellContext`c, $CellContext`r}, $CellContext`a = Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bX = 
           Det[{{
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bY = 
           Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {1, 1, 
              1}}]; $CellContext`c = -Det[{{
                Dot[$CellContext`L, $CellContext`L], 
                Dot[$CellContext`R, $CellContext`R], 
                Dot[$CellContext`F, $CellContext`F]}, {
                Part[$CellContext`L, 1], 
                Part[$CellContext`R, 1], 
                Part[$CellContext`F, 1]}, {
                Part[$CellContext`L, 2], 
                Part[$CellContext`R, 2], 
                
                Part[$CellContext`F, 
                 2]}}]; ($CellContext`bX^2 + $CellContext`bY^2 - (
              4 $CellContext`a) $CellContext`c)^Rational[1, 2]/(2 
           Abs[$CellContext`a])]; $CellContext`cENTER[
          PatternTest[
           Pattern[$CellContext`L, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`R, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`F, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`a, $CellContext`bX, $CellContext`bY, \
$CellContext`c, $CellContext`r}, $CellContext`a = Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bX = 
           Det[{{
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bY = 
           Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {1, 1, 
              1}}]; $CellContext`c = -Det[{{
                Dot[$CellContext`L, $CellContext`L], 
                Dot[$CellContext`R, $CellContext`R], 
                Dot[$CellContext`F, $CellContext`F]}, {
                Part[$CellContext`L, 1], 
                Part[$CellContext`R, 1], 
                Part[$CellContext`F, 1]}, {
                Part[$CellContext`L, 2], 
                Part[$CellContext`R, 2], 
                
                Part[$CellContext`F, 
                 2]}}]; {$CellContext`bX, $CellContext`bY}/(
           2 $CellContext`a)]; $CellContext`cIRCLE[
          PatternTest[
           Pattern[$CellContext`L, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`R, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`F, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`a, $CellContext`bX, $CellContext`bY, \
$CellContext`c, $CellContext`r}, $CellContext`a = Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bX = 
           Det[{{
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {
               Part[$CellContext`L, 2], 
               Part[$CellContext`R, 2], 
               Part[$CellContext`F, 2]}, {1, 1, 1}}]; $CellContext`bY = 
           Det[{{
               Part[$CellContext`L, 1], 
               Part[$CellContext`R, 1], 
               Part[$CellContext`F, 1]}, {
               Dot[$CellContext`L, $CellContext`L], 
               Dot[$CellContext`R, $CellContext`R], 
               Dot[$CellContext`F, $CellContext`F]}, {1, 1, 
              1}}]; $CellContext`c = -Det[{{
                Dot[$CellContext`L, $CellContext`L], 
                Dot[$CellContext`R, $CellContext`R], 
                Dot[$CellContext`F, $CellContext`F]}, {
                Part[$CellContext`L, 1], 
                Part[$CellContext`R, 1], 
                Part[$CellContext`F, 1]}, {
                Part[$CellContext`L, 2], 
                Part[$CellContext`R, 2], 
                Part[$CellContext`F, 2]}}]; 
          Circle[{$CellContext`bX, $CellContext`bY}/(
            2 $CellContext`a), ($CellContext`bX^2 + $CellContext`bY^2 - (
               4 $CellContext`a) $CellContext`c)^Rational[1, 2]/(2 
            Abs[$CellContext`a])]]; $CellContext`eyePict[
          PatternTest[
           Pattern[$CellContext`eyeCenter, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`\[Lambda], $CellContext`viewVector}, \
$CellContext`viewVector = $CellContext`fixate - $CellContext`eyeCenter; \
$CellContext`\[Lambda] = ArcTan[
             Part[$CellContext`viewVector, 1], 
             
             Part[$CellContext`viewVector, 
              2]]; $CellContext`viewVector = \
$CellContext`viewVector/$CellContext`nORM[$CellContext`viewVector]; Show[{
             Graphics[{
               AbsoluteThickness[2], Gray, 
               
               Circle[$CellContext`eyeCenter, $CellContext`eyeRadius, \
{$CellContext`\[Lambda] + 0.4, 2 Pi + $CellContext`\[Lambda] - 0.4}]}], 
             Graphics[{Gray, 
               
               Circle[$CellContext`eyeCenter + (
                  0.8 $CellContext`eyeRadius) $CellContext`viewVector, 
                0.5 $CellContext`eyeRadius, {$CellContext`\[Lambda] - 
                 1.5, $CellContext`\[Lambda] + 1.5}]}], 
             Graphics[{Green, 
               
               Disk[$CellContext`eyeCenter + ($CellContext`eyeRadius \
$CellContext`nodePercent) $CellContext`viewVector, $CellContext`eyeRadius/
                10]}]}, AspectRatio -> Automatic]]; $CellContext`eyeEdge[
          Pattern[$CellContext`\[Theta], 
           Blank[]]] := $CellContext`eyeRadius {
           Cos[$CellContext`\[Theta]], 
           Sin[$CellContext`\[Theta]]}; $CellContext`inRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           $CellContext`eyePict[
            $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           $CellContext`eyePict[
            $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`fixate], 
           Graphics[{Red, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]/$CellContext`nORM[
                  $CellContext`rightViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Red, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] - \
$CellContext`eyeRadius \
($CellContext`leftViewVector[$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base]/$CellContext`nORM[
                  $CellContext`leftViewVector[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]])}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`rightEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Blue, {
              Line[{
                $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base], \
$CellContext`leftEyeCenter[$CellContext`headAimVector, $CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`right\[CurlyPhi][$CellContext`headAimVector,\
 $CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`right\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Purple, {
              Line[{
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base] + \
$CellContext`eyeEdge[$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
                  Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]]}]}}], 
           Graphics[{Green, {
              Line[
               N[{
                 $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], 
                 $CellContext`rightEyeCenter[$CellContext`headAimVector, \
$CellContext`base]}]]}}], $CellContext`min = 
            Min[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; $CellContext`MAX = 
            Max[{$CellContext`left\[CurlyPhi][$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base] - \
$CellContext`retinalDisparity[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`distraction, $CellContext`base], \
$CellContext`left\[CurlyPhi][$CellContext`headAimVector, $CellContext`fixate, \
$CellContext`base] - 
               Pi - $CellContext`left\[Theta]inside[$CellContext`\
headAimVector, $CellContext`fixate, $CellContext`distraction, \
$CellContext`base]}]; Graphics[{Brown, 
              AbsoluteThickness[3], {
               Circle[
                $CellContext`leftEyeCenter[$CellContext`headAimVector, \
$CellContext`base], $CellContext`eyeRadius, {$CellContext`min, \
$CellContext`MAX}]}}]}, AspectRatio -> Automatic, PlotRange -> {{Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 1] + $CellContext`interOcular}, {Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] - $CellContext`interOcular, Part[
               $CellContext`midPoint[$CellContext`headAimVector, \
$CellContext`base], 2] + $CellContext`interOcular}}]; $CellContext`outRays[
          PatternTest[
           Pattern[$CellContext`headAimVector, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`distraction, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`base, 
            Blank[]], VectorQ]] := Show[{
           Graphics[{Red, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`fixate]]}}], 
           Graphics[{Blue, 
             AbsolutePointSize[4], {
              Point[
               N[$CellContext`distraction]]}}], 
           Graphics[{Red, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Red, {
              Line[
               N[{$CellContext`fixate, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Blue, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`rightEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}], 
           Graphics[{Blue, {
              Line[
               N[{$CellContext`distraction, 
                 $CellContext`leftEyeNode[$CellContext`headAimVector, \
$CellContext`fixate, $CellContext`base]}]]}}]}, AspectRatio -> 
          Automatic]; $CellContext`movingEyePict[
          PatternTest[
           Pattern[$CellContext`eyeCenter, 
            Blank[]], VectorQ], 
          PatternTest[
           Pattern[$CellContext`fixate, 
            Blank[]], VectorQ]] := 
        Module[{$CellContext`\[Lambda], $CellContext`viewVector}, \
$CellContext`viewVector = $CellContext`fixate - $CellContext`eyeCenter; \
$CellContext`\[Lambda] = ArcTan[
             Part[$CellContext`viewVector, 1], 
             
             Part[$CellContext`viewVector, 
              2]]; $CellContext`viewVector = \
$CellContext`viewVector/$CellContext`nORM[$CellContext`viewVector]; Show[{
             Graphics[{
               AbsoluteThickness[2], 
               Dashing[0.0125], Gray, {
                
                Line[{$CellContext`eyeCenter - {
                  1. $CellContext`eyeRadius, 
                   1.5 $CellContext`eyeRadius}, $CellContext`eyeCenter + {
                   1. $CellContext`eyeRadius, (-1.5) $CellContext`eyeRadius}, \
$CellContext`eyeCenter + {
                   0.6 $CellContext`eyeRadius, (-1.8) \
$CellContext`eyeRadius}}], 
                
                Circle[$CellContext`eyeCenter, $CellContext`eyeRadius, \
{$CellContext`\[Lambda] + 0.4, 2 Pi + $CellContext`\[Lambda] - 0.4}]}}], 
             Graphics[{Gray, 
               
               Circle[$CellContext`eyeCenter + (
                  0.8 $CellContext`eyeRadius) $CellContext`viewVector, 
                0.5 $CellContext`eyeRadius, {$CellContext`\[Lambda] - 
                 1.5, $CellContext`\[Lambda] + 1.5}]}], 
             Graphics[{Green, 
               
               Disk[$CellContext`eyeCenter + ($CellContext`eyeRadius \
$CellContext`nodePercent) $CellContext`viewVector, $CellContext`eyeRadius/
                10]}]}, AspectRatio -> Automatic]]; $CellContext`f = 
        Part[$CellContext`fixate$$, 
           2] - $CellContext`n $CellContext`r; $CellContext`d = 
        Part[$CellContext`distraction$$, 2] - 
         Part[$CellContext`fixate$$, 
          2]; $CellContext`r = ($CellContext`eyeRadius = 
         1.3); $CellContext`i = ($CellContext`interOcular = 
         6.5); $CellContext`aimOffset = 
        0; $CellContext`n = ($CellContext`nodePercent = 
         1/2); $CellContext`aim = 0; $CellContext`headAimVector[
          Pattern[$CellContext`aim, 
           Blank[]]] := {
          Sin[$CellContext`aim (Pi/180)], 
          Cos[$CellContext`aim (Pi/180)]}; $CellContext`base[
          Pattern[$CellContext`t, 
           Blank[]]] := {$CellContext`interOcular $CellContext`t, 
          0}; $CellContext`aimHead[
          Pattern[$CellContext`t, 
           Blank[]]] := {0, 1}; $CellContext`t = (-1)/2.; Show[{
          $CellContext`inRays[
           $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {
            0.6 $CellContext`scale$$, 0}, $CellContext`distraction$$ + {
            0.6 $CellContext`scale$$, 0}, $CellContext`base[0] + {
            0.6 $CellContext`scale$$, 0}], 
          $CellContext`outRays[
           $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {
            0.6 $CellContext`scale$$, 0}, $CellContext`distraction$$ + {
            0.6 $CellContext`scale$$, 0}, $CellContext`base[0] + {
            0.6 $CellContext`scale$$, 0}], 
          Graphics[{
            AbsolutePointSize[4], 
            Point[
             $CellContext`midPoint[
              $CellContext`headAimVector[$CellContext`aim], $CellContext`base[
               0] + {0.6 $CellContext`scale$$, 0}]]}], 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Point[$CellContext`fixate$$], 
             Text[
              Row[{
                Style["f", Italic], " = ", $CellContext`f, 
                " cm"}], $CellContext`fixate$$/
               2 + $CellContext`scale$$ {-0.08, 0}], 
             Line[{
               $CellContext`leftEyeNode[
                $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {0.6 $CellContext`scale$$, 0}, $CellContext`base[
                 0] + {0.6 $CellContext`scale$$, 
                  0}], $CellContext`fixate$$ + {
                0.6 $CellContext`scale$$, 0}}], 
             Line[{
               $CellContext`rightEyeNode[
                $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {0.6 $CellContext`scale$$, 0}, $CellContext`base[
                 0] + {0.6 $CellContext`scale$$, 
                  0}], $CellContext`fixate$$ + {
                0.6 $CellContext`scale$$, 0}}], 
             Circle[$CellContext`fixate$$, 1, {$CellContext`left\[CurlyPhi][
                 $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {0.6 $CellContext`scale$$, 0}, $CellContext`base[
                  0] + {0.6 $CellContext`scale$$, 0}] + 
               Pi, $CellContext`right\[CurlyPhi][
                 $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {0.6 $CellContext`scale$$, 0}, $CellContext`base[
                  0] + {0.6 $CellContext`scale$$, 0}] + Pi}], 
             Text[
              Row[{
                HoldForm[
                Style["d", Italic] ($CellContext`\[Alpha]/(
                  Style["d", Italic] $CellContext`t))], "(0)", " = ", 
                Round[
                 $CellContext`degrees[$CellContext`i/($CellContext`f + \
$CellContext`n $CellContext`r)], 0.1], 
                "\[Degree]/sec"}], $CellContext`scale$$ {0.25, 0.6}]}}], 
          Graphics[{Blue, 
            AbsolutePointSize[5], {
             Point[$CellContext`distraction$$], 
             Text[
              Row[{
                Style["d", Italic], " = ", $CellContext`d, 
                " cm"}], ($CellContext`distraction$$ + $CellContext`fixate$$)/
               2 + $CellContext`scale$$ {-0.08, 0}], 
             
             Circle[$CellContext`distraction$$, 
              1, {$CellContext`left\[Delta][
                 $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {
                  0.6 $CellContext`scale$$, 0}, $CellContext`distraction$$ + {
                  0.6 $CellContext`scale$$, 0}, $CellContext`base[0] + {
                  0.6 $CellContext`scale$$, 0}] + 
               Pi, $CellContext`right\[Delta][
                 $CellContext`headAimVector[$CellContext`aim], \
$CellContext`fixate$$ + {
                  0.6 $CellContext`scale$$, 0}, $CellContext`distraction$$ + {
                  0.6 $CellContext`scale$$, 0}, $CellContext`base[0] + {
                  0.6 $CellContext`scale$$, 0}] + Pi}]}}], 
          Graphics[{Black, 
            Text[
             Row[{
               HoldForm[
               Style["d", Italic] ($CellContext`\[Theta]/(
                 Style["d", Italic] $CellContext`\[Alpha]))], " = ", 
               
               Round[$CellContext`d/($CellContext`f + $CellContext`d), 
                0.01]}], $CellContext`scale$$ {0.25, 0.4}]}], 
          Graphics[{Black, 
            Text[
             Row[{
               HoldForm[
               Style["d", Italic] ($CellContext`\[Theta]/(
                 Style["d", Italic] $CellContext`\[Alpha] - 
                 Style["d", Italic] $CellContext`\[Theta]))], " = ", 
               
               Round[$CellContext`d/$CellContext`f, 
                0.01]}], $CellContext`scale$$ {0.25, 0.2}]}], 
          Graphics[{Magenta, {
             Text[
              Row[{
                HoldForm[
                Style["d", Italic] ($CellContext`\[Theta]/(
                  Style["d", Italic] $CellContext`t))], "(0)", " = ", 
                Round[
                 N[
                  $CellContext`degrees[$CellContext`d \
($CellContext`i/(($CellContext`d + $CellContext`f) ($CellContext`f + \
$CellContext`n $CellContext`r)))]], 0.01], 
                "\[Degree]/sec"}], $CellContext`scale$$ {0.25, 0.8}]}}], 
          $CellContext`movingEyePict[
           $CellContext`rightEyeCenter[
            $CellContext`aimHead[$CellContext`t], 
            $CellContext`base[$CellContext`t]], $CellContext`fixate$$], 
          Graphics[{Black, {
             Line[{2 $CellContext`rightEyeCenter[
                  $CellContext`aimHead[$CellContext`t], 
                  $CellContext`base[$CellContext`t]] - \
$CellContext`leftEyeCenter[
                $CellContext`aimHead[$CellContext`t], 
                $CellContext`base[$CellContext`t]], 
               2 $CellContext`leftEyeCenter[
                  $CellContext`aimHead[$CellContext`t], 
                  $CellContext`base[$CellContext`t]] - \
$CellContext`rightEyeCenter[
                $CellContext`aimHead[$CellContext`t], 
                $CellContext`base[$CellContext`t]]}]}}], 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Point[$CellContext`fixate$$], 
             Line[{
               $CellContext`leftEyeNode[
                $CellContext`aimHead[$CellContext`t], $CellContext`fixate$$, 
                $CellContext`base[$CellContext`t]], $CellContext`fixate$$}], 
             Line[{
               $CellContext`rightEyeNode[
                $CellContext`aimHead[$CellContext`t], $CellContext`fixate$$, 
                $CellContext`base[$CellContext`t]], \
$CellContext`fixate$$}]}}], 
          Graphics[{Blue, 
            AbsolutePointSize[5], {
             Point[$CellContext`distraction$$], 
             Line[{
               $CellContext`leftEyeNode[
                $CellContext`aimHead[$CellContext`t], $CellContext`fixate$$, 
                $CellContext`base[$CellContext`t]], \
$CellContext`distraction$$}], 
             Line[{$CellContext`rightEyeNode[
                 $CellContext`aimHead[$CellContext`t], $CellContext`fixate$$, \

                 $CellContext`base[$CellContext`t]] + {
                0.1, 0}, $CellContext`distraction$$ + {0.1, 0}}], 
             Line[{$CellContext`fixate$$, $CellContext`distraction$$}]}}], 
          Graphics[{Purple, {
             Text[
              Row[{
                Style["t", Italic], " = ", 0}], $CellContext`scale$$ {-0.04, 
               0.05}]}}], 
          Graphics[{Red, 
            AbsolutePointSize[4], {
             Point[$CellContext`fixate$$], 
             Text["F", {(-0.05) $CellContext`scale$$, $CellContext`f}]}}], 
          Graphics[{Blue, 
            AbsolutePointSize[4], {
             Point[$CellContext`distraction$$], 
             Text[
             "D", {(-0.05) $CellContext`scale$$, $CellContext`f + \
$CellContext`d}]}}]}, 
         PlotRange -> {$CellContext`scale$$ {-0.2, 
            0.8}, {-2.5, $CellContext`scale$$}}, AspectRatio -> Automatic, 
         ImageSize -> {400, 400}]), 
      "Specifications" :> {{{$CellContext`fixate$$, {0, 50.65}}, {0, 15.65}, {
         0, 1000.65}, ControlType -> 
         Locator}, {{$CellContext`distraction$$, {0, 60.65}}, {0, 5.65}, {
         0, 1100.65}, ControlType -> Locator}, {{$CellContext`scale$$, 64}, 
         50, 1200, Appearance -> "Labeled"}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{451., {245., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->263342323],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration interactively computes retinal motion, pursuit, the \
motion/pursuit ratio, and the motion/pursuit law for relative depth of \
objects on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis.  The observer's eyes are \"fixed\" on the point ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " (the \"fixate\" point). \"Fixation\" means the ray from ",
 Cell[BoxData[
  FormBox[
   StyleBox[Cell[TextData[Cell[BoxData[
     FormBox["F", TraditionalForm]], "InlineMath"]], "InlineMath"],
    FontSlant->"Plain"], TraditionalForm]], "InlineMath"],
 " through the eye node strikes the fovea at the center of the retina (see: \
",
 ButtonBox["Fixation and Distraction (Visual Depth Perception 5)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None}],
 ")."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[ButtonBox["",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None}]], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "We recently discovered a new formula for visual depth perception from \
motion parallax. Neurological work by J. W. Nadler, D. E. Angelaki, and G. C. \
DeAngelis in \"A Neural Representation of Depth from Motion Parallax in \
Macaque Visual Cortex\" (",
 StyleBox["Nature",
  FontSlant->"Italic"],
 ", ",
 StyleBox["452",
  FontWeight->"Bold"],
 "(7187), 2008 pp. 642\[Dash]645) suggests that an extra-retinal signal is \
needed for depth perception. In the static case, retinal disparity and motor \
control convergence are both needed to mathematically determine depth. Our \
dynamic formula involves a moving retinal image cue and an eye pursuit motor \
control cue that we believe is the needed extra-retinal signal."
}], "Text"],

Cell[TextData[{
 "Mark Nawrot conducted psychophysical experiments that indicate people use \
the motion/pursuit ratio to determine depth from motion. (Our joint work has \
not yet appeared.) Previous work by Nawrot and others (such as M. Nawrot and \
L. Joyce, ",
 StyleBox["Vision Research",
  FontSlant->"Italic"],
 ", \"The Pursuit Theory of Motion Parallax,\" ",
 StyleBox["46",
  FontWeight->"Bold"],
 "(28), 2006 pp. 4709\[Dash]4725) suggested that the motion/pursuit ratio was \
important. Our new formula forms a theoretical basis to understand past work, \
suggest new experiments, and perhaps even find a neurological basis for the \
formula."
}], "Text"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 played a role in this discovery and is helpful in explaining both the \
new dynamic formula and the old static formula for depth. There is a \
remarkable relation between the dynamic and static formulas. This collection \
of Demonstrations explains the new and old formulas interactively and lets \
you make your own computations.",
 " ",
 "Perhaps the computations will be helpful in designing new experiments."
}], "Text"],

Cell["\<\
We begin with a description of the formula for depth from motion parallax in \
a symmetric case with links to Demonstrations that explain basic terms and \
quantities. We outline the other visual depth perception Demonstrations below.\
\>", "Text"],

Cell[TextData[{
 "Fixation on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F",
     FontSlant->"Plain"], 
    StyleBox["=",
     FontWeight->"Plain"], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "f"}], ")"}],
     FontWeight->"Plain"]}], TraditionalForm]], "InlineMath"],
 " causes the eyes to rotate because of the observer's continuous \
translation.    \"Fixation\" means the ray from ",
 Cell[BoxData[
  FormBox[
   StyleBox[Cell[TextData[Cell[BoxData[
     FormBox["F", TraditionalForm]], "InlineMath"]], "InlineMath"],
    FontSlant->"Plain"], TraditionalForm]], "InlineMath"],
 " through the eye node strikes the fovea at the center of the retina (see: \
",
 ButtonBox["Fixation and Distraction (Visual Depth Perception 5)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None}],
 ").  Since the eye translates, it must rotate to maintain fixation (see: ",
 ButtonBox["Tracking and Separation (Visual Depth Perception 11)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"], None}],
 ")."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{
     {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.025], 
      LineBox[{{2.6, -1.9500000000000002`}, {4.875, -1.9500000000000002`}, {
       4.55, -2.08}}], 
      CircleBox[{3.25, 0}, 1.3, {2.467219080199778, 7.950404387379365}]}, 
     {GrayLevel[0.5], 
      CircleBox[{2.754665525517617, 0.914463645198245}, 0.65, {
       0.5672190801997781, 3.567219080199778}]}, 
     {RGBColor[0, 1, 0], 
      DiskBox[{2.940415953448511, 0.5715397782489031}, 0.13]}}, 
    {GrayLevel[0], LineBox[{{9.75, 0}, {0, 0}}]}, 
    {RGBColor[1, 0, 1], 
     InsetBox["\<\"\[Theta][t]\"\>", {2.364082248717103, 4.393490324618912}], 
     CircleBox[{2.940415953448511, 0.5715397782489031}, 3.9000000000000004`, {
      1.8731034751892794`, 2.067219080199778}]}, 
    {RGBColor[1, 0.5, 0], 
     CircleBox[{2.940415953448511, 0.5715397782489031}, 2.6, 
      NCache[{Rational[1, 2] Pi, 2.067219080199778}, {1.5707963267948966`, 
       2.067219080199778}]], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {2.940415953448511, 
      4.4715397782489035`}}], 
     InsetBox["\<\"\[Alpha][t]\"\>", \
{3.540415953448511, 3.2715397782489033`}]}, 
    {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 6}], 
     InsetBox["\<\"F\"\>", {0.5, 6.}], LineBox[{{0, 0}, {0, 6}}], 
     InsetBox["\<\"f\"\>", {-0.4, 3}], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {0, 6}}]}, 
    {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 10}], 
     InsetBox["\<\"D\"\>", {0.5, 10.}], 
     LineBox[{{2.940415953448511, 0.5715397782489031}, {0, 10}}], 
     LineBox[{{0, 6}, {0, 10}}], 
     InsetBox["\<\"d\"\>", 
      NCache[{-0.4, Rational[22, 3]}, {-0.4, 7.333333333333333}]]}, 
    {GrayLevel[0.5], InsetBox["\<\"Translation\"\>", {1, -2}]}},
   AspectRatio->Automatic,
   ImageSize->{Automatic, 225.},
   PlotRange->{{-2, 6}, {-4, 11}}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "The derivative in terms of the ",
 ButtonBox["eye parameters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
EyeParametersVisualDepthPerception6/"], None}],
 ", the node percent ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", interocular distance ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ", and eye radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " above is"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "t"}]], 
     RowBox[{"(", "t", ")"}]}], " ", "=", 
    FractionBox[
     RowBox[{"i", " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"f", "+", 
         RowBox[{"n", " ", "r"}]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["i", "2"], " ", 
       SuperscriptBox["t", "2"]}]}]]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "This peaks at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " (when the denominator is largest):"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "t"}]], 
     RowBox[{"(", "0", ")"}]}], " ", "=", 
    FractionBox["i", 
     RowBox[{"f", "+", 
      RowBox[{"n", " ", "r"}]}]]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "The observer's translation also causes the ",
 ButtonBox["angle separating the fixate and distraction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
TrackingAndSeparationVisualDepthPerception11/"], None}],
 " to change, causing motion of the image of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"D", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0", ",", 
       RowBox[{"f", "+", "d"}]}], ")"}], Cell["", "InlineMath"]}]}], 
   TraditionalForm]], "InlineMath"],
 " on the retina. In this case, where the distractor is also on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis, at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " this derivative is"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "t"}]], 
     RowBox[{"(", "0", ")"}]}], " ", "=", 
    FractionBox[
     RowBox[{"d", " ", "i"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", "f"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{3.25, 0.}, 1.3, {2.54717154738608, 
           8.030356854565667}]}, 
         {GrayLevel[0.5], 
          CircleBox[{2.683212115380769, 0.8719813609526625}, 0.65, {
           0.6471715473860802, 3.64717154738608}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{2.8957575721129807`, 0.5449883505954141}, 0.13]}}, {
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{-3.25, 0.}, 1.3, {1.3944211062037128`, 
           6.877606413383299}]}, 
         {GrayLevel[0.5], 
          CircleBox[{-2.683212115380769, 0.8719813609526625}, 
           0.65, {-0.5055788937962871, 2.494421106203713}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{-2.8957575721129807`, 0.5449883505954141}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{9.75, 0.}, {-9.75, 0.}}]}, {
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(r\\)]\\)\"\>", {1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{2.8957575721129807`, 0.5449883505954141}, 3.25, {
           1.9412898100876528`, 2.14717154738608}]}, 
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(l\\)]\\)\"\>", {-1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{-2.8957575721129807`, 0.5449883505954141}, 3.25, {
           0.9944211062037129, 1.2003028435021403`}]}}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], LineBox[{{0, 0}, {0, 5}}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 5}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{0, 5}, {0, 8}}], InsetBox["\<\"d\"\>", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {192., -226.80000000000004`}, 
      ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}], InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.025], 
          LineBox[{{-1.3, -1.9500000000000002`}, {
           1.3, -1.9500000000000002`}, {0.9099999999999999, -2.08}}], 
          CircleBox[{0., 0.}, 1.3, {1.9707963267948965`, 7.453981633974482}]}, 
         {GrayLevel[0.5], 
          CircleBox[{0., 1.04}, 0.65, {0.07079632679489656, 
           3.0707963267948966`}]}, 
         {RGBColor[0, 1, 0], DiskBox[{0., 0.65}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{6.5, 0.}, {-13., 0.}}]}, 
        {RGBColor[1, 0, 1], 
         InsetBox["\<\"\\!\\(\\*FractionBox[SubscriptBox[\\(d\[Theta]\\), \
\\(r\\)], \\(dt\\)]\\)[t=0]\"\>", {2, 3}]}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 5}}], 
         LineBox[{{0., 0.65}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 8}}], 
         LineBox[{{0.1, 0.65}, {0.1, 8}}], LineBox[{{0, 5}, {0, 8}}], 
         InsetBox["\<\"d\"\>", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {576., -226.80000000000004`}, 
      ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}]}, {}},
   ImageSize->{320., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell["The ratio of retinal motion over pursuit is", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}]], 
     RowBox[{"(", "0", ")"}]}], " ", "=", 
    FractionBox["d", 
     RowBox[{"f", "+", "d"}]], " "}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell["\<\
The basic case of the motion/pursuit law for relative depth from motion \
parallax is\
\>", "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["d", "f"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[InvisibleSpace]", "\[Beta]"}]], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
      RowBox[{
       RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}], "-", 
       RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}]}]], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
       RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}]], 
      FractionBox["1", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}], 
         RowBox[{"d", "\[InvisibleSpace]", "\[Alpha]"}]]}]]}]}]}]}], 
  TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "where the angle ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", 
    RowBox[{"\[Alpha]", "-", "\[Theta]"}]}], TraditionalForm]], 
  "InlineMath"],
 " simplifies the math, but may not correspond to a neurological signal."
}], "Text"],

Cell[TextData[{
 "You can compute all these quantities in this Demonstration by dragging the \
fixate and distractor. The Demonstration \"",
 ButtonBox["Motion, Pursuit, Fixate and Distractor (Visual Depth Perception \
2)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitFixateAndDistractorVisualDepthPerception2/"], None}],
 "\" plots the values of retinal motion and smooth eye pursuit for your \
choice of fixate and distractor in this basic one-dimensional setting."
}], "Text"],

Cell[TextData[StyleBox["The Visual Depth Perception Demonstrations",
 FontWeight->"Bold"]], "Text"],

Cell[TextData[{
 "The ratio of retinal motion and tracking pursuit derivatives extends to a \
distractor located anywhere in the horizontal fixation plane. The \
Demonstrations \"",
 ButtonBox["Motion/Pursuit Law in 2D (Visual Depth Perception 3)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn2DVisualDepthPerception3/"], None}],
 "\" and \"",
 ButtonBox["Motion/Pursuit Law on Invariant Circles (Visual Depth Perception \
4)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawOnInvariantCirclesVisualDepthPerception4/"], None}],
 "\" allow you to do computations with the 2D formula. The two-dimensional \
motion/pursuit law does not peak at time ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " as it does in the symmetric 1D case above and the peak time value of the \
formula gives a good measure of the relative distance for a 2D distractor."
}], "Text"],

Cell[TextData[{
 "The time zero value of the motion/pursuit formula is invariant on circles \
with diameter on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis so it is not a good measure of relative distance when the distractor \
is displaced left or right. A similar thing happens with binocular disparity \
as explained in the Demonstration \"",
 ButtonBox["Vieth\[Dash]M\[UDoubleDot]ller Circles (Visual Depth Perception \
8)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ViethMullerCirclesVisualDepthPerception8/"], None}],
 "\". Binocular disparity is a well-studied static cue to depth that is \
explored in the Demonstrations \"",
 ButtonBox["Binocular Disparity (Visual Depth Perception 7)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
BinocularDisparityVisualDepthPerception7/"], None}],
 "\" and \"",
 ButtonBox["Disparity, Convergence and Depth (Visual Depth Perception 10)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
DisparityConvergenceAndDepthVisualDepthPerception10/"], None}],
 "\"."
}], "Text"],

Cell[TextData[{
 "Neither binocular disparity alone nor retinal motion alone is sufficient to \
determine relative depth. These results are shown in the Demonstrations \"",
 ButtonBox["Binocular Disparity versus Depth (Visual Depth Perception 9)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/"], None}],
 "\", \"",
 ButtonBox["Motion Parallax versus Depth, 2D (Visual Depth Perception 12)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/"], None}],
 "\", and \"",
 ButtonBox["Motion Parallax versus Depth, 3D (Visual Depth Perception 13)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/"], None}],
 "\"."
}], "Text"],

Cell[TextData[{
 "The remarkable connection between the new motion/pursuit formula for depth \
and the classical formula for depth from disparity and convergence is \
explored in the Demonstration \"",
 ButtonBox["Dynamic Approximation of Static Quantities (Visual Depth \
Perception 14)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
DynamicApproximationOfStaticQuantitiesVisualDepthPerception1/"], None}],
 "\"."
}], "Text"],

Cell[TextData[{
 "We do not know a visual cue that could give a translating observer an \
accurate estimate of the speed of translation, but if speed is known, the \
motion/pursuit ratio would determine the absolute distance as you can compute \
in the Demonstrations \"",
 ButtonBox["Speed, Motion, Pursuit and Depth (Visual Depth Perception 15)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
SpeedMotionPursuitAndDepthVisualDepthPerception15/"], None}],
 "\" and \"",
 ButtonBox["Speed, Pursuit, M/P Ratio and Depth (Visual Depth Perception 16)",
  
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
SpeedPursuitMPRatioAndDepthVisualDepthPerception16/"], None}],
 "\"."
}], "Text"],

Cell[TextData[{
 "Experimental evidence suggests that people often perceive distractors \
closer to them than they actually are. The motion/pursuit ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "\[Alpha]"}], 
   TraditionalForm]], "InlineMath"],
 " also has this property and it remains to be seen experimentally how human \
perception compares with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "\[Alpha]"}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "\[Beta]"}], 
   TraditionalForm]], "InlineMath"],
 ". You can explore this comparison computationally in the Demonstrations \
\"",
 ButtonBox["Motion/Pursuit Ratio and Depth in 1D (Visual Depth Perception 17)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitRatioAndDepthIn1DVisualDepthPerception17/"], None}],
 "\" and \"",
 ButtonBox["Motion/Pursuit Ratio and Depth in 2D (Visual Depth Perception 18)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitRatioAndDepthIn2DVisualDepthPerception18/"], None}],
 "\"."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion/Pursuit Law in 1D (Visual Depth Perception 1)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionPursuitLawIn1DVisualDepthPerception1/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionPursuitLawIn1DVisualDepthPerception1"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion/Pursuit Law in 1D (Visual Depth Perception 1) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[654, 23, 172, 3, 70, "Section"],
Cell[829, 28, 3700, 64, 70, "Section"],
Cell[4532, 94, 93788, 2278, 70, "Input",
 CellID->1233924367]
}, Open  ]],
Cell[CellGroupData[{
Cell[98357, 2377, 49027, 1090, 70, "Output",
 CellID->263342323],
Cell[CellGroupData[{
Cell[147409, 3471, 209, 6, 70, "Section"],
Cell[147621, 3479, 934, 23, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[148581, 3506, 177, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[148783, 3514, 209, 6, 70, "Section"],
Cell[148995, 3522, 751, 15, 70, "Text"],
Cell[149749, 3539, 666, 14, 70, "Text"],
Cell[150418, 3555, 494, 10, 70, "Text"],
Cell[150915, 3567, 258, 4, 70, "Text"],
Cell[151176, 3573, 1205, 34, 70, "Text"],
Cell[152384, 3609, 1937, 38, 70, "Text"],
Cell[154324, 3649, 506, 17, 70, "Text"],
Cell[154833, 3668, 647, 23, 70, "Text"],
Cell[155483, 3693, 173, 6, 70, "Text"],
Cell[155659, 3701, 364, 13, 70, "Text"],
Cell[156026, 3716, 798, 24, 70, "Text"],
Cell[156827, 3742, 505, 19, 70, "Text"],
Cell[157335, 3763, 3932, 71, 70, "Text"],
Cell[161270, 3836, 59, 0, 70, "Text"],
Cell[161332, 3838, 349, 12, 70, "Text"],
Cell[161684, 3852, 109, 3, 70, "Text"],
Cell[161796, 3857, 838, 23, 70, "Text"],
Cell[162637, 3882, 258, 8, 70, "Text"],
Cell[162898, 3892, 535, 11, 70, "Text"],
Cell[163436, 3905, 99, 1, 70, "Text"],
Cell[163538, 3908, 1019, 23, 70, "Text"],
Cell[164560, 3933, 1173, 28, 70, "Text"],
Cell[165736, 3963, 895, 21, 70, "Text"],
Cell[166634, 3986, 468, 11, 70, "Text"],
Cell[167105, 3999, 762, 18, 70, "Text"],
Cell[167870, 4019, 1365, 35, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[169271, 4059, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[169629, 4070, 1057, 31, 70, "Text"],
Cell[170689, 4103, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[171169, 4122, 815, 24, 70, "Text"],
Cell[171987, 4148, 1214, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature bQje1YeBHwdj9CpcQRl9RaXS *)
