(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32566,        803]
NotebookOptionsPosition[     31127,        749]
NotebookOutlinePosition[     31812,        775]
CellTagsIndexPosition[     31769,        772]
WindowTitle->Motion Parallax versus Depth, 3D (Visual Depth Perception 13) - \
Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Motion Parallax versus Depth, 3D (Visual Depth Perception 13)\
\>", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "degrees", ",", "f", ",", "i", ",", "\[CapitalDelta]", ",", "c", ",", 
       "n", ",", "r", ",", "d\[Alpha]", ",", "point", ",", "curve", ",", 
       "value\[Theta]", ",", "value\[Alpha]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"degrees", "[", "q_", "]"}], ":=", 
       RowBox[{"q", "*", 
        RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", "\[CapitalDelta]_", "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"\[CapitalDelta]", " ", 
          RowBox[{"i", "/", "c"}]}], "-", 
         RowBox[{"n", " ", "r", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], 
        RowBox[{"1", "+", "\[CapitalDelta]"}]]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"d\[Alpha]", "[", "\[CapitalDelta]_", "]"}], "=", 
       RowBox[{"degrees", "[", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["1", "\[CapitalDelta]"]}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"point", "[", "\[CapitalDelta]_", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "\[CapitalDelta]", "]"}], ",", 
         RowBox[{"d\[Alpha]", "[", "\[CapitalDelta]", "]"}], ",", 
         "\[CapitalDelta]"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"c", "=", 
       RowBox[{"\[Pi]", "/", "180."}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"r", "=", 
       RowBox[{"13", "/", "10"}]}], ";", 
      RowBox[{"i", "=", 
       RowBox[{"13", "/", "2"}]}], ";", 
      RowBox[{"n", "=", 
       RowBox[{"1", "/", "2"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"curve", "=", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"point", "[", "\[CapitalDelta]", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalDelta]", ",", ".01", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Red"}], 
           "}"}]}], ",", 
         RowBox[{"BoxRatios", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
            RowBox[{"HoldForm", "[", 
             RowBox[{"d", "\[VeryThinSpace]", 
              RowBox[{"\[Alpha]", "/", 
               RowBox[{"(", 
                RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], ",", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".2"}], ",", "200"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".1"}], ",", "14"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".01"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"value\[Theta]", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"HoldForm", "[", 
                RowBox[{"d", "\[VeryThinSpace]", 
                 RowBox[{"\[Theta]", "/", 
                  RowBox[{"(", 
                   RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], 
               ",", " ", "\"\< = \>\"", ",", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{"degrees", "[", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", " ", 
                    RowBox[{"f", "[", "depth", "]"}]}], ")"}], " ", "i"}], 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", "+", "1"}], ")"}], 
                    RowBox[{"f", "[", "depth", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "+", 
                    RowBox[{"n", " ", "r"}]}], ")"}]}]], "]"}], ",", ".01"}], 
                "]"}]}], "}"}], "]"}], ",", 
            RowBox[{
             RowBox[{"point", "[", "depth", "]"}], "+", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", ".1"}], "}"}]}]}], "]"}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"value\[Alpha]", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{"point", "[", "depth", "]"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "depth"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "depth"}], 
                "}"}], ",", 
               RowBox[{"point", "[", "depth", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "0"}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", "0", ",", "0"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", "0", ",", "depth"}], 
                "}"}], ",", 
               RowBox[{"point", "[", "depth", "]"}]}], "}"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", "0", ",", "depth"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "depth"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "0"}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "depth"}], 
                "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", "0", ",", "0"}], 
                "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "0"}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], ",", 
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", "0"}], 
                "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"f", "[", "depth", "]"}], ",", ".02"}], "]"}]}], 
                "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], "/", "2"}], ",", 
                RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", 
                RowBox[{"depth", "+", ".05"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"depth", ",", ".02"}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], "-", "20"}], ",", 
                RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", 
                RowBox[{"depth", "/", "2"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"HoldForm", "[", 
                  RowBox[{"d", "\[VeryThinSpace]", 
                   RowBox[{"\[Alpha]", "/", 
                    RowBox[{"(", 
                    RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], 
                 ",", "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", ".02"}], 
                  "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"f", "[", "depth", "]"}], "+", "20"}], ",", 
                RowBox[{
                 RowBox[{"d\[Alpha]", "[", "depth", "]"}], "/", "2"}], ",", 
                "depth"}], "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"curve", ",", "value\[Theta]", ",", "value\[Alpha]"}], "}"}],
         ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"depth", ",", ".5", ",", "\"\<relative depth\>\""}], "}"}], ",",
      ".1", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4195921210345097`*^9, {3.419592156782467*^9, 3.419592204428047*^9}, {
   3.419592277310615*^9, 3.419592278381673*^9}, {3.4195923260717373`*^9, 
   3.419592363645295*^9}, {3.4195923937639313`*^9, 3.419592626861312*^9}, {
   3.419592657445121*^9, 3.419592711765678*^9}, {3.419592813835106*^9, 
   3.41959281810002*^9}, {3.419592951532349*^9, 3.419593142996532*^9}, {
   3.419593201968212*^9, 3.419593314809662*^9}, {3.419593486855612*^9, 
   3.4195934993408737`*^9}, {3.419593711834914*^9, 3.4195937312146797`*^9}, 
   3.4195937629135303`*^9, {3.419593816617619*^9, 3.419593896689312*^9}, {
   3.4195939353450212`*^9, 3.4195939448153477`*^9}, {3.4195940117610292`*^9, 
   3.419594112662403*^9}, 3.419594159620707*^9, {3.41959421488227*^9, 
   3.419594221273044*^9}, {3.419594256720047*^9, 3.419594411929366*^9}, 
   3.419595354484726*^9, {3.4195954344675007`*^9, 3.419595453804636*^9}, {
   3.419595531663352*^9, 3.419595582405143*^9}, {3.419595668565496*^9, 
   3.41959575076053*^9}, {3.4195957977692547`*^9, 3.4195958204727917`*^9}, {
   3.4195958680535*^9, 3.419595890594545*^9}, 3.4195959480920353`*^9, 
   3.419595993798828*^9, {3.419596942628478*^9, 3.419596962668954*^9}, {
   3.4195970179685297`*^9, 3.419597176267613*^9}, {3.419597274105795*^9, 
   3.419597275584433*^9}, {3.4196341072736197`*^9, 3.41963413695844*^9}, {
   3.4196347052686243`*^9, 3.419634796122188*^9}, {3.419634834593485*^9, 
   3.419634882898131*^9}, {3.419634988305771*^9, 3.41963511381931*^9}, {
   3.4196351621198606`*^9, 3.419635189693062*^9}, {3.4196361296262207`*^9, 
   3.419636160891509*^9}, {3.41963632309748*^9, 3.419636324510037*^9}, {
   3.4244412490587273`*^9, 3.424441293722892*^9}, 3.4244617999898*^9, {
   3.426358208319957*^9, 3.4263582646925936`*^9}, {3.426366521862112*^9, 
   3.426366555884385*^9}, {3.426366601813675*^9, 3.4263666291658516`*^9}, {
   3.4263674996753845`*^9, 3.4263677265409775`*^9}, {3.4263678140092363`*^9, 
   3.42636785871542*^9}, {3.4263678902708855`*^9, 3.4263679942725725`*^9}, {
   3.426584358982727*^9, 3.426584363268149*^9}, {3.426584449778838*^9, 
   3.426584453236412*^9}, {3.426584484079434*^9, 3.426584488331522*^9}, 
   3.427036865449258*^9, 3.4302442550764904`*^9},
 CellID->1165637783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`depth$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`depth$$], 0.5, "relative depth"}, 0.1, 1}}, 
    Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`depth$1163076$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`depth$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`depth$$, $CellContext`depth$1163076$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`degrees$, $CellContext`f$, $CellContext`i$, \
$CellContext`\[CapitalDelta]$, $CellContext`c$, 
         DemonstrationsTools`n$, $CellContext`r$, $CellContext`d\[Alpha]$, \
$CellContext`point$, $CellContext`curve$, $CellContext`value\[Theta]$, \
$CellContext`value\[Alpha]$}, $CellContext`degrees$[
           Pattern[$CellContext`q, 
            Blank[]]] := $CellContext`q (180/Pi); $CellContext`f$[
           Pattern[$CellContext`\[CapitalDelta]$, 
            
            Blank[]]] = ($CellContext`\[CapitalDelta]$ \
($CellContext`i$/$CellContext`c$) - (DemonstrationsTools`n$ $CellContext`r$) (
            1 + $CellContext`\[CapitalDelta]$))/(
          1 + $CellContext`\[CapitalDelta]$); $CellContext`d\[Alpha]$[
           Pattern[$CellContext`\[CapitalDelta]$, 
            Blank[]]] = $CellContext`degrees$[$CellContext`c$ (1 + 
            1/$CellContext`\[CapitalDelta]$)]; $CellContext`point$[
           Pattern[$CellContext`\[CapitalDelta]$, 
            Blank[]]] = {
           $CellContext`f$[$CellContext`\[CapitalDelta]$], 
           $CellContext`d\[Alpha]$[$CellContext`\[CapitalDelta]$], \
$CellContext`\[CapitalDelta]$}; $CellContext`c$ = Pi/180.; $CellContext`r$ = 
         13/10; $CellContext`i$ = 13/2; 
        DemonstrationsTools`n$ = 1/2; $CellContext`curve$ = ParametricPlot3D[
           $CellContext`point$[$CellContext`\[CapitalDelta]$], {$CellContext`\
\[CapitalDelta]$, 0.01, 1}, PlotStyle -> {
             AbsoluteThickness[2], Red}, BoxRatios -> {1, 1, 1}, AxesLabel -> {
             Style["f", Italic], 
             
             HoldForm[$CellContext`d ($CellContext`\[Alpha]/($CellContext`d \
$CellContext`t))], Style["d", Italic]/Style["f", Italic]}, 
           PlotRange -> {{-0.2, 200}, {-0.1, 14}, {-0.01, 
              1}}]; $CellContext`value\[Theta]$ = Graphics3D[{Red, 
            Text[
             Row[{
               
               HoldForm[$CellContext`d ($CellContext`\[Theta]/($CellContext`d \
$CellContext`t))], " = ", 
               Round[
                $CellContext`degrees$[($CellContext`depth$$ \
$CellContext`f$[$CellContext`depth$$]) \
($CellContext`i$/((($CellContext`depth$$ + 
                    1) $CellContext`f$[$CellContext`depth$$]) \
($CellContext`f$[$CellContext`depth$$] + 
                   DemonstrationsTools`n$ $CellContext`r$)))], 
                0.01]}], $CellContext`point$[$CellContext`depth$$] + {
              0, 0, 0.1}]}]; $CellContext`value\[Alpha]$ = Graphics3D[{Blue, 
            AbsolutePointSize[4], {
             Point[
              $CellContext`point$[$CellContext`depth$$]], 
             Line[{{0, 0, 0}, {0, 0, $CellContext`depth$$}, {0, 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], \
$CellContext`depth$$}, 
               $CellContext`point$[$CellContext`depth$$], {
                $CellContext`f$[$CellContext`depth$$], 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], 0}, {
                $CellContext`f$[$CellContext`depth$$], 0, 0}, {
                $CellContext`f$[$CellContext`depth$$], 
                0, $CellContext`depth$$}, 
               $CellContext`point$[$CellContext`depth$$]}], 
             Line[{{
                $CellContext`f$[$CellContext`depth$$], 
                0, $CellContext`depth$$}, {0, 0, $CellContext`depth$$}, {0, 0,
                0}, {0, 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], 0}, {0, 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], \
$CellContext`depth$$}}], 
             Line[{{0, 0, 0}, {
                $CellContext`f$[$CellContext`depth$$], 0, 0}}], 
             Line[{{0, 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], 0}, {
                $CellContext`f$[$CellContext`depth$$], 
                $CellContext`d\[Alpha]$[$CellContext`depth$$], 0}}], 
             Text[
              Row[{
                Style["f", Italic], " = ", 
                Round[
                 $CellContext`f$[$CellContext`depth$$], 
                 0.02]}], {$CellContext`f$[$CellContext`depth$$]/2, 
               $CellContext`d\[Alpha]$[$CellContext`depth$$], \
$CellContext`depth$$ + 0.05}], 
             Text[
              Row[{Style["d", Italic]/Style["f", Italic], " = ", 
                
                Round[$CellContext`depth$$, 
                 0.02]}], {$CellContext`f$[$CellContext`depth$$] - 20, 
               $CellContext`d\[Alpha]$[$CellContext`depth$$], \
$CellContext`depth$$/2}], 
             Text[
              Row[{
                
                HoldForm[$CellContext`d \
($CellContext`\[Alpha]/($CellContext`d $CellContext`t))], " = ", 
                Round[
                 $CellContext`d\[Alpha]$[$CellContext`depth$$], 
                 0.02]}], {$CellContext`f$[$CellContext`depth$$] + 
               20, $CellContext`d\[Alpha]$[$CellContext`depth$$]/
               2, $CellContext`depth$$}]}}]; 
        Show[{$CellContext`curve$, $CellContext`value\[Theta]$, \
$CellContext`value\[Alpha]$}, ImageSize -> {400, 400}]], 
      "Specifications" :> {{{$CellContext`depth$$, 0.5, "relative depth"}, 
         0.1, 1, Appearance -> "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {\
ControllerLinking -> True}],
     ImageSizeCache->{445., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->738544632],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration lets you move the relative distance between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]]],
 " and uses the formulas below to find the fixate distance ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and pursuit rate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Alpha]", "/", "d"}], "\[VeryThinSpace]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ", keeping the motion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "\[VeryThinSpace]", 
     RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "t"}], "=", 
    RowBox[{"1", "\[Degree]"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The retinal motion of a distractor viewed by a translating observer is not \
sufficient by itself to determine the relative depth of an object. This is \
similar to the static situation where binocular disparity does not determine \
depth by itself, but together with convergence does determine it.\
\>", "Text"],

Cell["\<\
The Demonstration \"Motion Parallax versus Depth, 2D (Visual Depth Perception \
12)\" (see Related Links) shows both fixate distance and pursuit on separate \
graphs. There are additional details in that Demonstration. This \
Demonstration shows both the fixate distance and associated pursuit rate on a \
single 3D curve where retinal motion is constant.\
\>", "Text"],

Cell["\<\
The Demonstration \"The Motion/Pursuit Law in 1D\" (see Related Links) shows \
how the ratio of motion to pursuit does determine relative depth in this \
basic case.\
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion Parallax versus Depth, 3D (Visual Depth Perception 13)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth3DVisualDepthPerception13/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionParallaxVersusDepth3DVisualDepthPerception13"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion Parallax versus Depth, 3D (Visual Depth Perception 13) - \
Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[665, 24, 189, 5, 70, "Section"],
Cell[857, 31, 3700, 64, 70, "Section"],
Cell[4560, 97, 13703, 315, 70, "Input",
 CellID->1165637783]
}, Open  ]],
Cell[CellGroupData[{
Cell[18300, 417, 6620, 132, 70, "Output",
 CellID->738544632],
Cell[CellGroupData[{
Cell[24945, 553, 209, 6, 70, "Section"],
Cell[25157, 561, 763, 24, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25968, 591, 209, 6, 70, "Section"],
Cell[26180, 599, 322, 5, 70, "Text"],
Cell[26505, 606, 379, 6, 70, "Text"],
Cell[26887, 614, 189, 4, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[27112, 623, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[27470, 634, 1106, 31, 70, "Text"],
Cell[28579, 667, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[29059, 686, 815, 24, 70, "Text"],
Cell[29877, 712, 1222, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 7Sj3Nl720BzwwDTma5CNUxok *)
