(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     73381,       1817]
NotebookOptionsPosition[     71489,       1752]
NotebookOutlinePosition[     72174,       1778]
CellTagsIndexPosition[     72131,       1775]
WindowTitle->Motion Parallax versus Depth, 2D (Visual Depth Perception 12) - \
Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Motion Parallax versus Depth, 2D (Visual Depth Perception 12)\
\>", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "r", ",", "i", ",", "n", ",", "nORM", ",", "degrees", ",", "arcMinutes",
        ",", "eyeRadius", ",", "interOcular", ",", "aimOffset", ",", 
       "nodePercent", ",", "aim\[Psi]", ",", "midPoint", ",", 
       "rightEyeCenter", ",", "leftEyeCenter", ",", "rightViewVector", ",", 
       "right\[CurlyPhi]", ",", "rightEyeNode", ",", "leftViewVector", ",", 
       "left\[CurlyPhi]", ",", "leftEyeNode", ",", "rightDistractVector", ",",
        "right\[Delta]", ",", "leftDistractVector", ",", "left\[Delta]", ",", 
       "right\[Theta]", ",", "left\[Theta]", ",", "binocularDisparity", ",", 
       "f", ",", "\[CapitalDelta]", ",", "c", ",", "d\[Alpha]", ",", "fGraph",
        ",", "\[Alpha]Graph"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"r", "=", 
       RowBox[{"13", "/", "10"}]}], ";", 
      RowBox[{"i", "=", 
       RowBox[{"13", "/", "2"}]}], ";", 
      RowBox[{"n", "=", 
       RowBox[{"1", "/", "2"}]}], ";", 
      RowBox[{
       RowBox[{"nORM", "[", 
        RowBox[{"vector_", "?", "VectorQ"}], "]"}], ":=", 
       SqrtBox[
        RowBox[{"vector", ".", "vector"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"degrees", "[", "q_", "]"}], ":=", 
       RowBox[{"q", "*", 
        RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"arcMinutes", "[", "q_", "]"}], ":=", 
       RowBox[{"q", "*", "60", "*", 
        RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eyeRadius", "=", 
       FractionBox["13", "10"]}], ";", 
      RowBox[{"interOcular", "=", 
       FractionBox["13", "2"]}], ";", 
      RowBox[{"aimOffset", "=", 
       FractionBox["1", "8"]}], ";", 
      RowBox[{"nodePercent", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aim\[Psi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"midPoint", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "-", 
        RowBox[{"aimOffset", "*", "interOcular", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"headAimVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightEyeCenter", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "-", "aimOffset"}], ")"}], "*", 
         "interOcular", "*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"headAimVector", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], "/", 
          RowBox[{"nORM", "[", "headAimVector", "]"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftEyeCenter", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "+", "aimOffset"}], ")"}], "*", 
         "interOcular", "*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"headAimVector", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], "/", 
          RowBox[{"nORM", "[", "headAimVector", "]"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightViewVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"fixate", "-", 
        RowBox[{"rightEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightEyeNode", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"rightEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
        RowBox[{"nodePercent", "*", "eyeRadius", "*", 
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
          "/", 
          RowBox[{"nORM", "[", 
           RowBox[{"rightViewVector", "[", 
            RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
            "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftViewVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"fixate", "-", 
        RowBox[{"leftEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftEyeNode", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"leftEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
        RowBox[{"nodePercent", "*", "eyeRadius", "*", 
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "/", 
          RowBox[{"nORM", "[", 
           RowBox[{"leftViewVector", "[", 
            RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
            "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightDistractVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"distraction", "-", 
        RowBox[{"rightEyeNode", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Delta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rightDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"rightDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftDistractVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"distraction", "-", 
        RowBox[{"leftEyeNode", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Delta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"leftDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"leftDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Theta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
         "-", 
         RowBox[{"right\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Theta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"left\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
         "-", 
         RowBox[{"left\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\n", 
      RowBox[{
       RowBox[{"binocularDisparity", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Or", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"left\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], "<", 
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
           RowBox[{
            RowBox[{"left\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "3."}]}], ",", 
           RowBox[{
            RowBox[{"right\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], "<", 
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
           RowBox[{
            RowBox[{"right\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"right\[Theta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}], "-", 
           RowBox[{"left\[Theta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"f", "[", "\[CapitalDelta]_", "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"\[CapitalDelta]", " ", 
          RowBox[{"i", "/", "c"}]}], "-", 
         RowBox[{"n", " ", "r", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], 
        RowBox[{"1", "+", "\[CapitalDelta]"}]]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"d\[Alpha]", "[", "\[CapitalDelta]_", "]"}], "=", 
       RowBox[{"degrees", "[", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["1", "\[CapitalDelta]"]}], ")"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"c", "=", 
       RowBox[{"\[Pi]", "/", "180."}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"fGraph", "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f", "[", "\[CapitalDelta]", "]"}], ",", 
           "\[CapitalDelta]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalDelta]", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", 
          RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], 
           "}"}]}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}]}], "}"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]Graph", "=", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"180", "/", "\[Pi]"}], " ", 
            RowBox[{"i", "/", 
             RowBox[{"f", "[", "\[CapitalDelta]", "]"}]}]}], ",", 
           "\[CapitalDelta]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalDelta]", ",", ".01", ",", "1"}], "}"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", 
          RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
         RowBox[{"AxesOrigin", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Purple"}], 
           "}"}]}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"HoldForm", "[", 
             RowBox[{"d", "\[VeryThinSpace]", 
              RowBox[{"\[Alpha]", "/", 
               RowBox[{"(", 
                RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], ",", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}]}], "}"}]}]}], 
        "]"}]}], ";", "\n", 
      RowBox[{"GraphicsGrid", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Show", "[", 
            RowBox[{"{", 
             RowBox[{"fGraph", ",", 
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{"Brown", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                    "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], ",", ".1"}], "]"}]}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "+", "15"}], ",", 
                    ".1"}], "}"}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]], ",", 
                    "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{"depth", ",", ".01"}], "]"}], ",", "\"\<, \>\"", 
                    ",", " ", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], ",", 
                    "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], " ", "depth"}], ",", 
                    ".1"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"30", ",", 
                    RowBox[{"depth", "+", ".2"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"HoldForm", "[", 
                    RowBox[{"d", "\[VeryThinSpace]", 
                    RowBox[{"\[Theta]", "/", 
                    RowBox[{"(", 
                    RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], 
                    ",", "\"\< = \>\"", ",", 
                    RowBox[{"degrees", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", " ", 
                    RowBox[{"f", "[", "depth", "]"}]}], ")"}], " ", "i"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", "+", "1"}], ")"}], 
                    RowBox[{"f", "[", "depth", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "+", 
                    RowBox[{"n", " ", "r"}]}], ")"}]}]], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "-", "15"}], ",", 
                    RowBox[{"depth", "+", ".05"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<B.D.\>\"", ",", "\"\< = \>\"", ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Round", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"degrees", "[", 
                    RowBox[{"binocularDisparity", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"f", "[", "depth", "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "depth"}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}], ",", 
                    ".0001"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "+", "20"}], ",", 
                    RowBox[{"depth", "-", ".02"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "depth"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], ",", "depth"}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], ",", "0"}], "}"}]}], 
                    "}"}], "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
           "\[IndentingNewLine]", "}"}], ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"Show", "[", 
            RowBox[{"{", 
             RowBox[{"\[Alpha]Graph", ",", "\[IndentingNewLine]", 
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{"Brown", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"HoldForm", "[", 
                    RowBox[{"d", "\[VeryThinSpace]", 
                    RowBox[{"\[Alpha]", "/", 
                    RowBox[{"(", 
                    RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], 
                    ",", "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"d\[Alpha]", "[", "depth", "]"}], ",", ".1"}], 
                    "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d\[Alpha]", "[", "depth", "]"}], "+", "1"}], ",",
                     ".1"}], "}"}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox[
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]], ",", 
                    "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{"depth", ",", ".01"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"depth", "+", ".1"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"HoldForm", "[", 
                    RowBox[{"d", "\[VeryThinSpace]", 
                    RowBox[{"\[Theta]", "/", 
                    RowBox[{"(", 
                    RowBox[{"d", "\[VeryThinSpace]", "t"}], ")"}]}]}], "]"}], 
                    ",", "\"\< = \>\"", ",", 
                    RowBox[{"degrees", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", " ", 
                    RowBox[{"f", "[", "depth", "]"}]}], ")"}], " ", "i"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"depth", "+", "1"}], ")"}], 
                    RowBox[{"f", "[", "depth", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"f", "[", "depth", "]"}], "+", 
                    RowBox[{"n", " ", "r"}]}], ")"}]}]], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"d\[Alpha]", "[", "depth", "]"}], "+", "1"}], ",",
                     "depth"}], "}"}]}], "]"}], ",", 
                   RowBox[{"Line", "[", 
                    RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "depth"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"180", "/", "\[Pi]"}], " ", 
                    RowBox[{"i", "/", 
                    RowBox[{"f", "[", "depth", "]"}]}]}], ",", "depth"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"180", "/", "\[Pi]"}], " ", 
                    RowBox[{"i", "/", 
                    RowBox[{"f", "[", "depth", "]"}]}]}], ",", "0"}], "}"}]}],
                     "}"}], "]"}]}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
           "}"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"400", ",", "450"}], "}"}]}]}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"depth", ",", ".5", ",", "\"\<relative depth\>\""}], "}"}], ",",
      ".1", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.424385966867381*^9, 3.424386099114352*^9}, {
   3.424386157394094*^9, 3.424386236007834*^9}, {3.4243863352159452`*^9, 
   3.424386350758917*^9}, {3.424386407388694*^9, 3.424386419771253*^9}, {
   3.4243864645058413`*^9, 3.4243864754191427`*^9}, {3.424386575897773*^9, 
   3.424386580627631*^9}, {3.4243866150516777`*^9, 3.424386636810442*^9}, {
   3.424386673397214*^9, 3.4243868067006474`*^9}, {3.424386843772359*^9, 
   3.424387091149521*^9}, {3.4243872407637453`*^9, 3.424387258391491*^9}, {
   3.424387311986397*^9, 3.424387351814045*^9}, {3.424387398807933*^9, 
   3.424387460821457*^9}, {3.424387521186841*^9, 3.424387524360427*^9}, {
   3.424387559104085*^9, 3.4243875768284817`*^9}, 3.424418500787533*^9, {
   3.424418558126782*^9, 3.4244186967670927`*^9}, {3.424418728055951*^9, 
   3.424418737740016*^9}, {3.424418895877513*^9, 3.424418907924007*^9}, {
   3.424418948363051*^9, 3.424418953644909*^9}, 3.424418988013425*^9, {
   3.424419039133862*^9, 3.42441905427133*^9}, {3.424419166281393*^9, 
   3.424419198826091*^9}, {3.424419499294479*^9, 3.424419504120569*^9}, {
   3.424419555342101*^9, 3.424419573422944*^9}, 3.424419784668138*^9, 
   3.4244216874188623`*^9, {3.424421721590266*^9, 3.4244217400823803`*^9}, {
   3.424421771162552*^9, 3.424421776192711*^9}, {3.424422670621344*^9, 
   3.4244226713219223`*^9}, {3.4244238256169662`*^9, 3.42442383114716*^9}, {
   3.4244238748382177`*^9, 3.424424089688962*^9}, 3.424424135458128*^9, {
   3.424424266565111*^9, 3.424424284307908*^9}, {3.42442439777698*^9, 
   3.424424441094907*^9}, {3.42442450284026*^9, 3.42442462661561*^9}, {
   3.424424658460477*^9, 3.424424731363933*^9}, {3.424424769507638*^9, 
   3.424424773425658*^9}, {3.4244248226400137`*^9, 3.4244248733514338`*^9}, {
   3.424424913782227*^9, 3.424424948550748*^9}, {3.424424985555509*^9, 
   3.424425030763961*^9}, {3.424425068065549*^9, 3.4244251009539423`*^9}, {
   3.424425165324523*^9, 3.424425202384797*^9}, {3.424425238754281*^9, 
   3.4244252459993963`*^9}, 3.42442529480774*^9, 3.4244254116469812`*^9, {
   3.424425503942976*^9, 3.424425510615394*^9}, {3.4244255958966427`*^9, 
   3.424425713172542*^9}, {3.424425749776639*^9, 3.424425780815946*^9}, {
   3.424425812763129*^9, 3.424425829047007*^9}, {3.42442587029755*^9, 
   3.4244259651974277`*^9}, {3.4244260072865257`*^9, 3.424426012397398*^9}, {
   3.4244260783295603`*^9, 3.4244261076508904`*^9}, {3.426359062523026*^9, 
   3.426359092685042*^9}, {3.426359299256697*^9, 3.4263595034301124`*^9}, {
   3.4263690040465374`*^9, 3.42636926236411*^9}, {3.4263694035721245`*^9, 
   3.426369485890068*^9}, {3.4264308872866554`*^9, 3.4264311086588216`*^9}, {
   3.4264312080481744`*^9, 3.426431229219778*^9}, {3.426583923830287*^9, 
   3.426583938816237*^9}, {3.426583970898242*^9, 3.4265839823050756`*^9}, {
   3.426584035023671*^9, 3.426584099880728*^9}, {3.427037026347172*^9, 
   3.427037076628879*^9}},
 CellID->246815488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`depth$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`depth$$], 0.5, "relative depth"}, 0.1, 1}}, 
    Typeset`size$$ = {400., {223., 227.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`depth$11847$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`depth$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`depth$$, $CellContext`depth$11847$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`r$, $CellContext`i$, 
         DemonstrationsTools`n$, $CellContext`nORM$, $CellContext`degrees$, \
$CellContext`arcMinutes$, $CellContext`eyeRadius$, $CellContext`interOcular$, \
$CellContext`aimOffset$, $CellContext`nodePercent$, $CellContext`aim\[Psi]$, \
$CellContext`midPoint$, $CellContext`rightEyeCenter$, \
$CellContext`leftEyeCenter$, $CellContext`rightViewVector$, \
$CellContext`right\[CurlyPhi]$, $CellContext`rightEyeNode$, \
$CellContext`leftViewVector$, $CellContext`left\[CurlyPhi]$, \
$CellContext`leftEyeNode$, $CellContext`rightDistractVector$, \
$CellContext`right\[Delta]$, $CellContext`leftDistractVector$, \
$CellContext`left\[Delta]$, $CellContext`right\[Theta]$, $CellContext`left\
\[Theta]$, $CellContext`binocularDisparity$, $CellContext`f$, $CellContext`\
\[CapitalDelta]$, $CellContext`c$, $CellContext`d\[Alpha]$, \
$CellContext`fGraph$, $CellContext`\[Alpha]Graph$}, $CellContext`r$ = 
         13/10; $CellContext`i$ = 13/2; 
        DemonstrationsTools`n$ = 1/2; $CellContext`nORM$[
           PatternTest[
            Pattern[$CellContext`vector, 
             Blank[]], VectorQ]] := 
         Dot[$CellContext`vector, $CellContext`vector]^
          Rational[1, 2]; $CellContext`degrees$[
           Pattern[$CellContext`q, 
            Blank[]]] := $CellContext`q (180/Pi); $CellContext`arcMinutes$[
           Pattern[$CellContext`q, 
            Blank[]]] := ($CellContext`q 60) (180/
           Pi); $CellContext`eyeRadius$ = 13/10; $CellContext`interOcular$ = 
         13/2; $CellContext`aimOffset$ = 1/8; $CellContext`nodePercent$ = 
         1; $CellContext`aim\[Psi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base, 
             Blank[]], VectorQ]] := ArcTan[
           Part[$CellContext`headAimVector, 1], 
           Part[$CellContext`headAimVector, 2]]; $CellContext`midPoint$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`base$ - ($CellContext`aimOffset$ \
$CellContext`interOcular$) {
            Part[$CellContext`headAimVector$, 2], -
            Part[$CellContext`headAimVector$, 
              1]}; $CellContext`rightEyeCenter$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`base$ + ((
             1/2 - $CellContext`aimOffset$) $CellContext`interOcular$) ({
              Part[$CellContext`headAimVector$, 2], -
              Part[$CellContext`headAimVector$, 
                1]}/$CellContext`nORM$[$CellContext`headAimVector$]); \
$CellContext`leftEyeCenter$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := $CellContext`base$ - ((
            1/2 + $CellContext`aimOffset$) $CellContext`interOcular$) ({
             Part[$CellContext`headAimVector$, 2], -
             Part[$CellContext`headAimVector$, 
               1]}/$CellContext`nORM$[$CellContext`headAimVector$]); \
$CellContext`rightViewVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`fixate$ - \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`right\[CurlyPhi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 1], 
           Part[
            $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 2]]; $CellContext`rightEyeNode$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$ $CellContext`eyeRadius$) \
($CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
             $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`leftViewVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`fixate$ - \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`left\[CurlyPhi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 1], 
           Part[
            $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 2]]; $CellContext`leftEyeNode$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$ $CellContext`eyeRadius$) \
($CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
             $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`rightDistractVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`distraction$ - \
$CellContext`rightEyeNode$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`base$]; $CellContext`right\[Delta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`rightDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 1], 
           Part[
            $CellContext`rightDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 
            2]]; $CellContext`leftDistractVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`distraction$ - \
$CellContext`leftEyeNode$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`base$]; $CellContext`left\[Delta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`leftDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 1], 
           Part[
            $CellContext`leftDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 
            2]]; $CellContext`right\[Theta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`right\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`right\[Delta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]; \
$CellContext`left\[Theta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`left\[Delta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$]; \
$CellContext`binocularDisparity$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := If[
           
           Or[$CellContext`left\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] < (-Pi)/
             2., $CellContext`left\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] > 
            Pi/3., $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] < (-Pi)/
             3., $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] > Pi/2.],
            0, $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] - \
$CellContext`left\[Theta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$]]; $CellContext`f$[
           Pattern[$CellContext`\[CapitalDelta]$, 
            
            Blank[]]] = ($CellContext`\[CapitalDelta]$ \
($CellContext`i$/$CellContext`c$) - (DemonstrationsTools`n$ $CellContext`r$) (
            1 + $CellContext`\[CapitalDelta]$))/(
          1 + $CellContext`\[CapitalDelta]$); $CellContext`d\[Alpha]$[
           Pattern[$CellContext`\[CapitalDelta]$, 
            Blank[]]] = $CellContext`degrees$[$CellContext`c$ (1 + 
            1/$CellContext`\[CapitalDelta]$)]; $CellContext`c$ = 
         Pi/180.; $CellContext`fGraph$ = ParametricPlot[{
            $CellContext`f$[$CellContext`\[CapitalDelta]$], $CellContext`\
\[CapitalDelta]$}, {$CellContext`\[CapitalDelta]$, 0, 1}, AspectRatio -> 
           1/GoldenRatio, PlotStyle -> {
             AbsoluteThickness[2], Blue}, AxesLabel -> {
             Style["f", Italic], Style["d", Italic]/Style[
             "f", Italic]}]; $CellContext`\[Alpha]Graph$ = 
         ParametricPlot[{(180/
             Pi) ($CellContext`i$/$CellContext`f$[$CellContext`\[CapitalDelta]\
$]), $CellContext`\[CapitalDelta]$}, {$CellContext`\[CapitalDelta]$, 0.01, 1},
            AspectRatio -> 1/GoldenRatio, AxesOrigin -> {0, 0}, 
           PlotStyle -> {
             AbsoluteThickness[2], Purple}, AxesLabel -> {
             
             HoldForm[$CellContext`d ($CellContext`\[Alpha]/($CellContext`d \
$CellContext`t))], Style["d", Italic]/Style["f", Italic]}]; GraphicsGrid[{{
            Show[{$CellContext`fGraph$, 
              Graphics[{Brown, {
                 Text[
                  Row[{
                    Style["f", Italic], " = ", 
                    Round[
                    $CellContext`f$[$CellContext`depth$$], 
                    0.1]}], {$CellContext`f$[$CellContext`depth$$] + 15, 
                   0.1}], 
                 Text[
                  Row[{Style["d", Italic]/Style["f", Italic], " = ", 
                    Round[$CellContext`depth$$, 0.01], ", ", 
                    Style["d", Italic], " = ", 
                    
                    Round[$CellContext`f$[$CellContext`depth$$] \
$CellContext`depth$$, 0.1]}], {30, $CellContext`depth$$ + 0.2}], 
                 Text[
                  Row[{
                    
                    HoldForm[$CellContext`d \
($CellContext`\[Theta]/($CellContext`d $CellContext`t))], " = ", 
                    $CellContext`degrees$[($CellContext`depth$$ \
$CellContext`f$[$CellContext`depth$$]) \
($CellContext`i$/((($CellContext`depth$$ + 
                    1) $CellContext`f$[$CellContext`depth$$]) \
($CellContext`f$[$CellContext`depth$$] + 
                    DemonstrationsTools`n$ $CellContext`r$)))]}], \
{$CellContext`f$[$CellContext`depth$$] - 15, $CellContext`depth$$ + 0.05}], 
                 Text[
                  Row[{"B.D.", " = ", 
                    Round[
                    $CellContext`degrees$[
                    $CellContext`binocularDisparity$[{0, 1}, {0, 
                    $CellContext`f$[$CellContext`depth$$]}, {
                    0, $CellContext`f$[$CellContext`depth$$] (
                    1 + $CellContext`depth$$)}, {0, 0}]], 
                    0.0001]}], {$CellContext`f$[$CellContext`depth$$] + 
                   20, $CellContext`depth$$ - 0.02}], 
                 Line[{{0, $CellContext`depth$$}, {
                    $CellContext`f$[$CellContext`depth$$], \
$CellContext`depth$$}, {
                    $CellContext`f$[$CellContext`depth$$], 0}}]}}]}]}, {
            Show[{$CellContext`\[Alpha]Graph$, 
              Graphics[{Brown, {
                 Text[
                  Row[{
                    
                    HoldForm[$CellContext`d \
($CellContext`\[Alpha]/($CellContext`d $CellContext`t))], " = ", 
                    Round[
                    $CellContext`d\[Alpha]$[$CellContext`depth$$], 
                    0.1]}], {$CellContext`d\[Alpha]$[$CellContext`depth$$] + 
                   1, 0.1}], 
                 Text[
                  Row[{Style["d", Italic]/Style["f", Italic], " = ", 
                    Round[$CellContext`depth$$, 0.01]}], {
                  1, $CellContext`depth$$ + 0.1}], 
                 Text[
                  Row[{
                    
                    HoldForm[$CellContext`d \
($CellContext`\[Theta]/($CellContext`d $CellContext`t))], " = ", 
                    $CellContext`degrees$[($CellContext`depth$$ \
$CellContext`f$[$CellContext`depth$$]) \
($CellContext`i$/((($CellContext`depth$$ + 
                    1) $CellContext`f$[$CellContext`depth$$]) \
($CellContext`f$[$CellContext`depth$$] + 
                    DemonstrationsTools`n$ $CellContext`r$)))]}], \
{$CellContext`d\[Alpha]$[$CellContext`depth$$] + 1, $CellContext`depth$$}], 
                 
                 Line[{{0, $CellContext`depth$$}, {(180/
                    Pi) ($CellContext`i$/$CellContext`f$[$CellContext`depth$$]\
), $CellContext`depth$$}, {(180/
                    Pi) ($CellContext`i$/$CellContext`f$[$CellContext`depth$$]\
), 0}}]}}]}]}}, ImageSize -> {400, 450}]], 
      "Specifications" :> {{{$CellContext`depth$$, 0.5, "relative depth"}, 
         0.1, 1, Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{445., {267., 272.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->371332373],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration lets you move the relative distance between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]]],
 " and uses the formulas below to find the fixate distance ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and pursuit rate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Alpha]", "/", "d"}], "\[VeryThinSpace]", "t"}], 
   TraditionalForm]], "InlineMath"],
 ", keeping the motion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "\[VeryThinSpace]", 
     RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "t"}], "=", 
    RowBox[{"1", "\[Degree]"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "The program computes the binocular disparity of a fixed observer at the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " position.",
 " ",
 "Notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontSlant->"Plain"], ".", 
     StyleBox["D",
      FontSlant->"Plain"], "."}], "\[TildeTilde]", 
    RowBox[{"d", "\[VeryThinSpace]", 
     RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "t"}]}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The retinal motion of a distractor viewed by a translating observer is not \
sufficient by itself to determine the relative depth of an object. This is \
similar to the static situation where binocular disparity does not determine \
depth by itself, but together with convergence does determine it.\
\>", "Text"],

Cell[TextData[{
 "Consider the case where the fixate and distractor lie on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis and the observer moves to the right along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis at 6.5 cm/sec (interocular distance/sec). Suppose the right eye \
crosses the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " as shown next."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{3.25, 0.}, 1.3, {2.54717154738608, 
           8.030356854565667}]}, 
         {GrayLevel[0.5], 
          CircleBox[{2.683212115380769, 0.8719813609526625}, 0.65, {
           0.6471715473860802, 3.64717154738608}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{2.8957575721129807`, 0.5449883505954141}, 0.13]}}, {
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{-3.25, 0.}, 1.3, {1.3944211062037128`, 
           6.877606413383299}]}, 
         {GrayLevel[0.5], 
          CircleBox[{-2.683212115380769, 0.8719813609526625}, 
           0.65, {-0.5055788937962871, 2.494421106203713}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{-2.8957575721129807`, 0.5449883505954141}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{9.75, 0.}, {-9.75, 0.}}]}, {
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(r\\)]\\)\"\>", {1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{2.8957575721129807`, 0.5449883505954141}, 3.25, {
           1.9412898100876528`, 2.14717154738608}]}, 
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(l\\)]\\)\"\>", {-1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{-2.8957575721129807`, 0.5449883505954141}, 3.25, {
           0.9944211062037129, 1.2003028435021403`}]}}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], LineBox[{{0, 0}, {0, 5}}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 5}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{0, 5}, {0, 8}}], InsetBox["\<\"d\"\>", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {192., -226.80000000000004`}, 
      ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}], InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.025], 
          LineBox[{{-1.3, -1.9500000000000002`}, {
           1.3, -1.9500000000000002`}, {0.9099999999999999, -2.08}}], 
          CircleBox[{0., 0.}, 1.3, {1.9707963267948965`, 7.453981633974482}]}, 
         {GrayLevel[0.5], 
          CircleBox[{0., 1.04}, 0.65, {0.07079632679489656, 
           3.0707963267948966`}]}, 
         {RGBColor[0, 1, 0], DiskBox[{0., 0.65}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{6.5, 0.}, {-13., 0.}}]}, 
        {RGBColor[1, 0, 1], 
         InsetBox["\<\"\!\(\*FractionBox[\(d\[VeryThinSpace]\*SubscriptBox[\(\
\[Theta]\), \(r\)]\), \(d\[VeryThinSpace]t\)]\)[t=0]\"\>", {2, 3}]}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 5}}], 
         LineBox[{{0., 0.65}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 8}}], 
         LineBox[{{0.1, 0.65}, {0.1, 8}}], LineBox[{{0, 5}, {0, 8}}], 
         InsetBox["d", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {569.068936036399, -226.7999999999998},
       ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}]}, {}},
   ImageSize->{320., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell[TextData[{
 "The derivative in terms of the ",
 ButtonBox["eye parameters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
EyeParametersVisualDepthPerception6/"], None}],
 ", ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " = node percent, ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " = interocular distance, and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " = eye radius at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 " is"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
        RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
       RowBox[{"(", "0", ")"}]}], "=", 
      FractionBox[
       RowBox[{"i", " ", "d"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", "f"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]], 
    "InlineMath"]]], "."}], TraditionalForm]], "Text"],

Cell[TextData[{
 "Solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[VeryThinSpace]", "t"}]], "=", "c"}], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   FractionBox["d", "f"], TraditionalForm]], "InlineMath"],
 " gives"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", "f"], "=", 
    FractionBox[
     RowBox[{"f", "+", 
      RowBox[{"n", " ", "r"}]}], 
     RowBox[{
      RowBox[{"i", "/", "c"}], "-", 
      RowBox[{"(", 
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "Solving the equation ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox[
     RowBox[{"\[CapitalDelta]", "=", 
      FractionBox[
       RowBox[{"f", "+", 
        RowBox[{"n", " ", "r"}]}], 
       RowBox[{
        RowBox[{"i", "/", "c"}], "-", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"n", " ", "r"}]}], ")"}]}]]}], TraditionalForm]], 
    "InlineMath"]]], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "=", 
    FractionBox[
     RowBox[{
      RowBox[{"\[CapitalDelta]", " ", 
       RowBox[{"i", "/", "c"}]}], "-", 
      RowBox[{"n", " ", "r", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], 
     RowBox[{"1", "+", "\[CapitalDelta]"}]]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "Define the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "\[CapitalDelta]", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"\[CapitalDelta]", " ", 
       RowBox[{"i", "/", "c"}]}], "-", 
      RowBox[{"n", " ", "r", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], 
     RowBox[{"1", "+", "\[CapitalDelta]"}]]}], TraditionalForm]], 
  "InlineMath"],
 "; then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[VeryThinSpace]", "t"}]], "=", "c"}], TraditionalForm]], 
  "InlineMath"],
 " at fixate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"f", "(", "\[CapitalDelta]", ")"}]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " and distractor ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"f", "(", "\[CapitalDelta]", ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[CapitalDelta]"}], ")"}]}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " for all values of ",
 Cell[BoxData[
  FormBox["\[CapitalDelta]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[".", TraditionalForm]]]
}], "Text"],

Cell[TextData[{
 "For fixate and distractor on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis,"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], 
      RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
     RowBox[{"(", "0", ")"}]}], "=", 
    FractionBox["i", 
     RowBox[{"f", "+", 
      RowBox[{"n", " ", "r"}]}]]}], TraditionalForm]], "InlineMath"],
 ", and when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"d", "\[VeryThinSpace]", "\[Theta]"}], 
     RowBox[{"d", "\[VeryThinSpace]", "t"}]], "=", "c"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"d", "\[VeryThinSpace]", "\[Alpha]"}], 
      RowBox[{"d", "\[VeryThinSpace]", "t"}]], 
     RowBox[{"(", "0", ")"}]}], "=", 
    RowBox[{
     FractionBox["i", 
      RowBox[{
       RowBox[{"f", "(", "\[CapitalDelta]", ")"}], "+", 
       RowBox[{"n", " ", "r"}]}]], "=", 
     RowBox[{"c", "(", 
      RowBox[{"1", "+", 
       FractionBox["1", "\[CapitalDelta]"]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text"],

Cell["\<\
The Demonstration \"Motion Parallax versus Depth, 3D (Visual Depth Perception \
13)\" (see Related Links) shows both fixate distance and pursuit on a single \
3D curve.\
\>", "Text"],

Cell["\<\
The Demonstration \"Motion/Pursuit Law in 1D (Visual Depth Perception 1)\" \
(see Related Links) shows how the ratio of motion to pursuit does determine \
relative depth in this basic case.\
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion Parallax versus Depth, 2D (Visual Depth Perception 12)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
MotionParallaxVersusDepth2DVisualDepthPerception12/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionParallaxVersusDepth2DVisualDepthPerception12"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion Parallax versus Depth, 2D (Visual Depth Perception 12) - \
Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[665, 24, 189, 5, 70, "Section"],
Cell[857, 31, 3700, 64, 70, "Section"],
Cell[4560, 97, 31268, 716, 70, "Input",
 CellID->246815488]
}, Open  ]],
Cell[CellGroupData[{
Cell[35865, 818, 19211, 418, 70, "Output",
 CellID->371332373],
Cell[CellGroupData[{
Cell[55101, 1240, 209, 6, 70, "Section"],
Cell[55313, 1248, 763, 24, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[56102, 1276, 551, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[56678, 1300, 209, 6, 70, "Section"],
Cell[56890, 1308, 322, 5, 70, "Text"],
Cell[57215, 1315, 552, 16, 70, "Text"],
Cell[57770, 1333, 3962, 71, 70, "Text"],
Cell[61735, 1406, 599, 21, 70, "Text"],
Cell[62337, 1429, 580, 18, 70, "Text"],
Cell[62920, 1449, 349, 14, 70, "Text"],
Cell[63272, 1465, 359, 15, 70, "Text"],
Cell[63634, 1482, 896, 32, 70, "Text"],
Cell[64533, 1516, 1265, 45, 70, "Text"],
Cell[65801, 1563, 139, 5, 70, "Text"],
Cell[65943, 1570, 1084, 39, 70, "Text"],
Cell[67030, 1611, 192, 4, 70, "Text"],
Cell[67225, 1617, 213, 4, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[67474, 1626, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[67832, 1637, 1106, 31, 70, "Text"],
Cell[68941, 1670, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[69421, 1689, 815, 24, 70, "Text"],
Cell[70239, 1715, 1222, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature QQzne9yOuUCglB0yVY4NuEPD *)
