(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58569,       1152]
NotebookOptionsPosition[     57417,       1110]
NotebookOutlinePosition[     58045,       1134]
CellTagsIndexPosition[     58002,       1131]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Motion of a Simple Pendulum with Damping", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", "\[GreaterEqual]", "Pi"}], ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "+", 
      RowBox[{"(", 
       RowBox[{"x", "-", "Pi"}], ")"}]}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[LessEqual]", 
        RowBox[{"-", "Pi"}]}], ",", 
       RowBox[{"Pi", "+", 
        RowBox[{"(", 
         RowBox[{"x", "+", "Pi"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Evolution2", "[", 
    RowBox[{"n_", ",", 
     RowBox[{"{", 
      RowBox[{"x0_", ",", "v0_"}], "}"}], ",", "dt_", ",", "k_", ",", "d_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"flow", "=", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"i", "=", "0"}], ",", 
       RowBox[{"x", "=", "x0"}], ",", 
       RowBox[{"v", "=", "v0"}], ",", 
       RowBox[{"tmpx", "=", "0"}], ",", 
       RowBox[{"tmpv", "=", "0"}], ",", 
       RowBox[{"a", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "n"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"flow", ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "v"}], "}"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tmpx", "=", "x"}], ";", "\[IndentingNewLine]", 
         RowBox[{"tmpv", "=", "v"}], ";", "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "k"}], " ", 
            RowBox[{"Sin", "[", "x", "]"}]}], "-", 
           RowBox[{"d", " ", "v"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"v", "+=", 
          RowBox[{"a", " ", "dt"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"x", "+=", 
          RowBox[{"v", " ", "dt"}]}], ";", 
         RowBox[{"x", "=", 
          RowBox[{"f", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", ";", 
         RowBox[{"i", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "flow"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.431169246171875*^9, 3.4311693248125*^9}, {
  3.4311693611875*^9, 3.431169361484375*^9}, {3.431170592203125*^9, 
  3.431170666203125*^9}, {3.43117072371875*^9, 3.431170772375*^9}, {
  3.431171086859375*^9, 3.431171098640625*^9}, {3.43117114921875*^9, 
  3.431171156796875*^9}, {3.431171438140625*^9, 3.4311714423125*^9}, {
  3.43117189365625*^9, 3.431171957546875*^9}, {3.431172431453125*^9, 
  3.431172473609375*^9}, {3.43117250434375*^9, 3.431172530703125*^9}, {
  3.43117266284375*^9, 3.43117266471875*^9}, {3.431172741296875*^9, 
  3.431172744390625*^9}, {3.431172803953125*^9, 3.43117280934375*^9}, {
  3.431172881078125*^9, 3.431172892921875*^9}, {3.43117366240625*^9, 
  3.43117368315625*^9}, {3.431455574328125*^9, 3.431455575703125*^9}},
 CellID->194316413],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"l", "=", 
     RowBox[{"Evolution2", "[", 
      RowBox[{"700", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "v"}], "}"}], ",", "0.02`", ",", 
       RowBox[{"1", "/", "e"}], ",", "d"}], "]"}]}], ";", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{
           RowBox[{"ListPlot", "[", 
            RowBox[{"l", ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "\[Pi]"}], "-", "0.2"}], ",", 
                  RowBox[{"\[Pi]", "+", "0.2"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"Abs", "[", "v", "]"}]}], "-", "0.3"}], ",", 
                  RowBox[{
                   RowBox[{"Abs", "[", "v", "]"}], "+", "0.3"}]}], "}"}]}], 
               "}"}]}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"275", ",", "275"}], "}"}]}], ",", 
             RowBox[{"AxesLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<\[Theta]\>\"", ",", "Bold"}], "]"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<\[Omega]\>\"", ",", "Bold"}], "]"}]}], "}"}]}], 
             ",", 
             RowBox[{"ImagePadding", "\[Rule]", "25"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"l", "[", 
                  RowBox[{"[", 
                   RowBox[{"a", ",", "1"}], "]"}], "]"}], ",", 
                 RowBox[{"l", "[", 
                  RowBox[{"[", 
                   RowBox[{"a", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
             "}"}], "]"}]}], "]"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "Red", ",", 
               RowBox[{"Rotate", "[", 
                RowBox[{
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "0.4`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0.05`", ",", "0.4`"}], "}"}]}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"l", "\[LeftDoubleBracket]", 
                   RowBox[{"a", ",", "1"}], "\[RightDoubleBracket]"}], "+", 
                  "Pi"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Dashed", ",", "Pink", ",", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "0.8`"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Dashed", ",", "Blue", ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
            "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"275", ",", "275"}], "}"}]}]}], "]"}]}], "}"}], "}"}], 
      ",", 
      RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "\"\<step\>\""}], "}"}], ",", "1", ",", 
     "500", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "1", ",", "\"\<pendulum length\>\""}], "}"}], ",", 
     "1", ",", "2.5"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", "2", ",", "\"\<angular velocity\>\""}], "}"}], ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "0", ",", "\"\<damping\>\""}], "}"}], ",", "0", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", "Manipulate"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.43145558959375*^9, {3.431456003828125*^9, 
   3.431456004109375*^9}, {3.431456044421875*^9, 3.4314561219375*^9}, {
   3.431697965863936*^9, 3.431697991372486*^9}, {3.4316980271030593`*^9, 
   3.431698132214569*^9}, {3.4316982482301693`*^9, 3.431698299328279*^9}, 
   3.43170315699754*^9, {3.4317064567199364`*^9, 3.4317065077250366`*^9}, {
   3.4318666655594406`*^9, 3.431866671265011*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`d$$ = 
    0, $CellContext`e$$ = 1, $CellContext`v$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 1, "step"}, 1, 500, 1}, {{
       Hold[$CellContext`e$$], 1, "pendulum length"}, 1, 2.5}, {{
       Hold[$CellContext`v$$], 2, "angular velocity"}, -10, 10}, {{
       Hold[$CellContext`d$$], 0, "damping"}, 0, 1}}, Typeset`size$$ = {
    569., {138., 143.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`a$8601$$ = 
    0, $CellContext`e$8602$$ = 0, $CellContext`v$8603$$ = 
    0, $CellContext`d$8604$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`d$$ = 
        0, $CellContext`e$$ = 1, $CellContext`v$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$8601$$, 0], 
        Hold[$CellContext`e$$, $CellContext`e$8602$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$8603$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$8604$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`l = $CellContext`Evolution2[
         700, {0, $CellContext`v$$}, 0.02, 
          1/$CellContext`e$$, $CellContext`d$$]; Grid[{{
           Show[
            
            ListPlot[$CellContext`l, 
             PlotRange -> {{-Pi - 0.2, Pi + 0.2}, {-Abs[$CellContext`v$$] - 
                0.3, Abs[$CellContext`v$$] + 0.3}}, ImageSize -> {275, 275}, 
             AxesLabel -> {
               Style["\[Theta]", Bold], 
               Style["\[Omega]", Bold]}, ImagePadding -> 25], 
            Graphics[{Red, 
              PointSize[0.03], 
              Point[{
                Part[$CellContext`l, $CellContext`a$$, 1], 
                Part[$CellContext`l, $CellContext`a$$, 2]}]}]], 
           Graphics[{{
              EdgeForm[Thick], Red, 
              Rotate[
               Disk[{0, 0.4}, {0.05, 0.4}], 
               Part[$CellContext`l, $CellContext`a$$, 1] + Pi, {0, 0}]}, {
             Blue, 
              PointSize[0.02], 
              Point[{0, 0}]}, {Dashed, Pink, 
              Circle[{0, 0}, 0.8]}, {Dashed, Blue, 
              Line[{{-1, 0}, {1, 0}}]}}, PlotRange -> 1, 
            ImageSize -> {275, 275}]}}, Frame -> All]), 
      "Specifications" :> {{{$CellContext`a$$, 1, "step"}, 1, 500, 
         1}, {{$CellContext`e$$, 1, "pendulum length"}, 1, 
         2.5}, {{$CellContext`v$$, 2, "angular velocity"}, -10, 
         10}, {{$CellContext`d$$, 0, "damping"}, 0, 1}}, 
      "Options" :> {TrackedSymbols -> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{613., {222., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`l = {{0, 2}, {0.04, 2}, {
          0.07998400426632535, 1.9992002133162674`}, {0.11993604903289697`, 
          1.9976022383285807`}, {0.15984023431307987`, 1.9952092640091457`}, {
          0.19968075540144817`, 1.992026054418415}, {0.23944193391393037`, 
          1.9880589256241095`}, {0.27910824821894914`, 1.9833157152509373`}, {
          0.3186643631176091, 1.977805744932998}, {0.3580951586376383, 
          1.9715397760014592`}, {0.3973857578135582, 1.9645299587959957`}, {
          0.43652155333433745`, 1.9567897760389608`}, {0.4754882329494518, 
          1.9483339807557165`}, {0.5142718035347014, 1.9391785292624784`}, {
          0.5528586137301831, 1.929340509774084}, {0.5912353750743436, 
          1.9188380672080307`}, {0.6293891815699005, 1.9076903247778443`}, {
          0.6673075276294678, 1.8959173029783611`}, {0.7049783243608275, 
          1.8835398365679858`}, {0.7423899141638007, 1.870579490148662}, {
          0.7795310836224718, 1.8570584729335549`}, {0.816391074687986, 
          1.8429995532757109`}, {0.8529595941581616, 1.8284259735087798`}, {
          0.8892268214706383, 1.8133613656238305`}, {0.9251834148361382, 
          1.7978296682749995`}, {0.9608205157475749, 1.7818550455718367`}, {
          0.9961297519091438, 1.7654618080784452`}, {1.031103238637134, 
          1.7486743363995045`}, {1.065733578790968, 1.7315170076917081`}, {
          1.1000138612989014`, 1.7140141253966654`}, {1.1339376583478717`, 
          1.6961898524485206`}, {1.1674990213112117`, 1.678068148167002}, {
          1.2006924754913086`, 1.6596727090048395`}, {1.2335130137568677`, 
          1.64102691327795}, {1.2659560891562254`, 1.6221537699678772`}, {
          1.2980176065892064`, 1.6030758716490514`}, {1.3296939136203818`, 
          1.5838153515587692`}, {1.3609817905162942`, 1.5643938447956198`}, {
          1.3918784395883457`, 1.5448324536025768`}, {1.4223814739216303`, 
          1.525151716664229}, {1.4524889055681047`, 1.5053715823237266`}, {
          1.482199133280184, 1.4855113856039677`}, {1.5115109298581708`, 
          1.4655898288993332`}, {1.5404234291819474`, 1.4456249661888338`}, {
          1.5689361129941226`, 1.425634190608758}, {1.5970487974983767`, 
          1.4056342252127019`}, {1.624761619833158, 1.3856411167390696`}, {
          1.65207502447717, 1.3656702322006022`}, {1.6789897496393111`, 
          1.345736258107053}, {1.7055068136819234`, 1.3258532021306126`}, {
          1.731627501622401, 1.3060343970238864`}, {1.757353351754441, 
          1.286292506602002}, {1.782686142426512, 1.2666395336035428`}, {
          1.8076278790114986`, 1.247086829249332}, {1.8321807810979671`, 
          1.227645104323432}, {1.8563472699301056`, 1.20832444160692}, {
          1.8801299561201439`, 1.1891343095019105`}, {1.903531627653959, 
          1.170083576690745}, {1.9265552382076223`, 1.1511805276831724`}, {
          1.9492038957898727`, 1.1324328791125238`}, {1.9714808517228783`, 
          1.1138477966502804`}, {1.9933894899712166`, 1.0954319124169165`}, {
          2.0149333168267245`, 1.0771913427753899`}, {2.036115950954766, 
          1.0591317064020773`}, {2.056941113805531, 1.0412581425382423`}, {
          2.077412620392195, 1.023575329333217}, {2.097534370436162, 
          1.0060875021983426`}, {2.117310339878128, 0.9887984720982879}, {
          2.136744572752401, 0.9717116437136408}, {2.155841173420713, 
          0.9548300334156045}, {2.174604299160717, 0.9381562870002128}, {
          2.1930381531034313`, 0.9216926971357097}, {2.211146977513083, 
          0.9054412204825848}, {2.228935047402108, 0.8894034944512456}, {
          2.246406664473456, 0.8735808535674122}, {2.2635661513818577`, 
          0.8579743454200699}, {2.2804178463052818`, 0.8425847461711996}, {
          2.2969660978174926`, 0.8274125756105455}, {2.31321526005234, 
          0.8124581117423789}, {2.329169688150232, 0.7977214048945981}, {
          2.3448337339771035`, 0.7832022913435666}, {2.360211742106121, 
          0.7689004064508729}, {2.375308046052335, 0.7548151973106834}, {
          2.3901269647505066`, 0.7409459349085962}, {2.4046727992664043`, 
          0.7272917257948898}, {2.4189498297319405`, 0.713851523276813}, {
          2.4329623124946624`, 0.7006241381361068}, {2.446714477472248, 
          0.687608248879287}, {2.4602105257028355`, 0.674802411529377}, {
          2.473454627082211, 0.6622050689687662}, {2.486450918279085, 
          0.6498145598437001}, {2.4992035008199167`, 0.6376291270416028}, {
          2.5117164393349767`, 0.6256469257529874}, {2.52399375995758, 
          0.6138660311301559}, {2.5360394488686846`, 0.6022844455552249}, {
          2.5478574509792895`, 0.590900105530254}, {2.5594516687433377`, 
          0.5797108882024098}, {2.5708259610940813`, 0.5687146175371735}, {
          2.5819841424971335`, 0.5579090701526138}, {2.5929299821136875`, 
          0.5472919808276946}, {2.603667203067637, 0.5368610476974838}, {
          2.614199481810597, 0.5266139371479847}, {2.624530447579059, 
          0.5165482884231185}, {2.6346636819381826`, 0.506661717956168}, {
          2.6446027184069374`, 0.4969518234377384}, {2.6543510421595777`, 
          0.4874161876320192}, {2.6639120897986346`, 0.478052381952832}, {
          2.6732892491948475`, 0.4688579698106407}, {2.6824858593896748`, 
          0.4598305097413748}, {2.6915052105562265`, 0.4509675583275832}, {
          2.7003505440146682`, 0.44226667292209537`}, {2.709025052298349, 
          0.43372541418402233`}, {2.7175318792670806`, 
          0.42534134843658145`}, {2.7258741202641983`, 0.4171120498558831}, {
          2.734054822314188, 0.40903510249947056`}, {2.742076984357849, 
          0.4011081021830606}, {2.749943557522121, 0.3933286582135949}, {
          2.7576574454218483`, 0.3856943949863764}, {2.765221504490923, 
          0.37820295345373844`}, {2.7726385443403707`, 
          0.37085199247237266`}, {2.779911328141093, 0.363639190036129}, {
          2.787042573029109, 0.3565622444007947}, {2.7940349505312505`, 
          0.34961887510706335`}, {2.800891087009403, 0.34280682390761585`}, {
          2.807613564121482, 0.3361238556039568}, {2.8142049192974494`, 
          0.3295677587983796}, {2.820667646228773, 0.3231363465661722}, {
          2.8270041953698315`, 0.3168274570529256}, {2.8332169744498628`, 
          0.310638954001563}, {2.839308348994132, 0.3045687272134768}, {
          2.845280642853091, 0.2986146929479352}, {2.851136138738365, 
          0.292774794263707}, {2.856877078764498, 0.287047001306646}, {
          2.8625056649954335`, 0.2814293115467807}, {2.8680240599947986`, 
          0.2759197499682653}, {2.873434387379106, 0.2705163692153689}, {
          2.878738732373056, 0.2652172496975062}, {2.883939142366179, 
          0.2600204996561498}, {2.8890376274701053`, 0.2549242551963076}, {
          2.894036161075807, 0.24992668028509796`}, {2.8989366804102037`, 
          0.24502596671981464`}, {2.9037410870915585`, 
          0.24022033406773738`}, {2.9084512476831548`, 
          0.23550802957981476`}, {2.9130689942447594`, 
          0.23088732808022452`}, {2.9175961248814333`, 
          0.22635653183369916`}, {2.922034404289281, 0.22191397039239472`}, {
          2.9263855642977608`, 0.21755800042397563`}, {2.9306513044082103`, 
          0.21328700552248886`}, {2.9348332923282805`, 0.2090993960035064}, {
          2.938933164501979, 0.20499360868492575`}, {2.942952526635074, 
          0.20096810665473297`}, {2.946892954215613, 0.19702137902695344`}, {
          2.9507559930293517`, 0.1931519406869385}, {2.954543159669893, 
          0.18935833202706526`}, {2.9582559420433703`, 
          0.18563911867385835`}, {2.96189579986752, 0.18199289120747839`}, {
          2.965464165165009, 0.17841826487446122`}, {2.9689624427509, 
          0.1749138792945346}, {2.9723920107141457`, 0.1714783981622851}, {
          2.9757542208930334`, 0.16811050894439628`}, {2.979050399344496, 
          0.164808922573132}, {2.98228184680723, 0.16157237313669234`}, {
          2.9854498391585707`, 0.1583996175670268}, {2.9885556278650838`, 
          0.15528943532564998`}, {2.991600440426843, 0.15224062808796557`}, {
          2.9945854808153745`, 0.14925201942656946`}, {2.997511929905254, 
          0.14632245449396883`}, {3.0003809458993564`, 
          0.14345079970512206`}, {3.00319366474776, 0.1406359424201748}, {
          3.0059512005603146`, 0.13787679062773894`}, {3.008654646012895, 
          0.1351722726290354}, {3.011305072747359, 0.132521336723196}, {
          3.013903531765239, 0.1299229508939973}, {3.0164510538152043`, 
          0.12737610249827633`}, {3.0189486497743294`, 
          0.12487979795625852`}, {3.0213973110232097`, 
          0.12243306244400817`}, {3.0237980098149735`, 
          0.12003493958819401`}, {3.0261516996382403`, 
          0.11768449116334527`}, {3.0284593155740755`, 
          0.11538079679175789`}, {3.0307217746469997`, 
          0.11312295364619566`}, {3.03293997617011, 0.11091007615551676`}, {
          3.035114802084377, 0.1087412957133436}, {3.0372471172921744`, 
          0.1066157603898814}, {3.039337769985114, 0.10453263464697954`}, {
          3.0413875919662443`, 0.1024910990565191}, {3.0433973989666883`, 
          0.10049035002219996`}, {3.045367990956784, 0.09852959950479186}, {
          3.047300152451802, 0.0966080747509047}, {3.0491946528123086`, 
          0.09472501802532564}, {3.051052246539248, 0.09287968634696286}, {
          3.0528736735638167`, 0.0910713512284291}, {3.0546596595322026`, 
          0.08929929841929117}, {3.056410916085263, 0.08756282765300609}, {
          3.058128141133214, 0.08586125239755847}, {3.05981201912541, 
          0.08419389960980898}, {3.0614632213152815`, 0.08256010949355849}, {
          3.063082406020508, 0.08095923526132845}, {3.064670218878505, 
          0.0793906428998536}, {3.066227293097291, 0.07785371093927977}, {
          3.067754249701812, 0.07634783022605536}, {3.069251697775802, 
          0.07487240369950263}, {3.070720234699243, 0.07342684617205149}, {
          3.0721604463815053`, 0.07201058411311588}, {3.073572907490237, 
          0.07062305543659053}, {3.074958181676076, 0.06926370929194331}, {
          3.0763168217932537`, 0.06793200585887678}, {3.0776493701161645`, 
          0.06662741614553024}, {3.0789563585519684`, 0.06534942179019211}, {
          3.080238308849298, 0.06409751486649115}, {3.081495732803139, 
          0.06287119769203306}, {3.082729132455948, 0.061669982640448616`}, {
          3.0839390002950844`, 0.06049339195681764}, {3.085125819446613, 
          0.05934095757643267}, {3.08629006386555, 0.05821222094686511}, {
          3.0874321985226163`, 0.057106732853296004`}, {3.0885526795875577`, 
          0.05602405324707292}, {3.089651954609107, 0.05496375107745391}, {
          3.0907304626916368`, 0.0539254041264991}, {3.0917886346685783`, 
          0.05290859884707012}, {3.0928268932726564`, 
          0.051912930203897166`}, {3.09384565330301, 0.05093800151767354}, {
          3.0948453217892524`, 0.04998342431213712}, {3.0958262981525344`, 
          0.04904881816409828}, {3.096788974363662, 0.048133810556373745`}, {
          3.0977337350983336`, 0.04723803673358584}, {3.098660957889549, 
          0.046361139560786746`}, {3.0995710132772465`, 
          0.04550276938486743}, {3.1004642649552205`, 0.0446625838987112}, {
          3.1013410699153816`, 0.043840248008051905`}, {3.1022017785894014`, 
          0.04303543370099712}, {3.103046734987805, 0.04224781992017698}, {
          3.103876276836554, 0.041477092437479525`}, {3.104690735711181, 
          0.04072294373133379}, {3.1054904371685113`, 
          0.039985072866502346`}, {3.106275700876038, 0.03926318537634517}, {
          3.1070468407389886`, 0.0385569931475173}, {3.10780416502513, 
          0.037866214307063085`}, {3.108547976487367, 0.03719057311187028}, {
          3.1092785724841763`, 0.03652979984044773}, {3.109996245097916, 
          0.03588363068699073}, {3.1107012812510697`, 0.03525180765769883}, {
          3.111393962820456, 0.03463407846931118}, {3.1120745667494525`, 
          0.03403019644982509}, {3.1127433651582797`, 0.03343992044136395}, {
          3.1134006254523827`, 0.03286301470516115}, {3.1140466104289555`, 
          0.032299248828627364`}, {3.114681578381645, 0.03174839763446875}, {
          3.1153057832034814`, 0.031210241091824444`}, {3.115919474488069, 
          0.030684564229392104`}, {3.1165228976290793`, 
          0.030171157050510915`}, {3.1171162939180825`, 
          0.029669814450171916`}, {3.117699900640761, 
          0.029180336133926055`}, {3.1182739511715343`, 
          0.028702526538661052`}, {3.118838675066639, 
          0.028236194755218498`}, {3.1193942981556955`, 
          0.027781154452823385`}, {3.1199410426318015`, 
          0.027337223805298596`}, {3.1204791271401824`, 
          0.02690422541903762}, {3.1210087668654367`, 
          0.026481986262709183`}, {3.12153017361741, 0.026070337598668034`}, {
          3.122043555915731, 0.02566911491604678}, {3.122549119073041, 
          0.02527815786550404}, {3.1230470652769533`, 0.02489731019560488}, {
          3.1235375936707697`, 0.024526419690809913`}, {3.1240209004329906`, 
          0.024165338111050053`}, {3.124497178855648, 
          0.023813921132864395`}, {3.1249666194214893`, 
          0.023472028292079297`}, {3.1254294098800495`, 
          0.023139522928007143`}, {3.1258857353226324`, 0.0228162721291439}, {
          3.126335778256239, 0.022502146680345034`}, {3.126779718676468, 
          0.022197021011459917`}, {3.1272177341394163`, 
          0.021900773147405288`}, {3.1276499998326095`, 
          0.02161328465965895}, {3.1280766886449927`, 0.02133444061915526}, {
          3.128497971236004, 0.02106412955056461}, {3.1289140161037627`, 
          0.02080224338793941}, {3.129324989652397, 0.02054867743170986}, {
          3.129731056258537, 0.020303330307012896`}, {3.1301323783370036`, 
          0.02006610392333859}, {3.130529116405713, 0.019836903435478476`}, {
          3.1309214291498284`, 0.01961563720576083}, {3.1313094734851794`, 
          0.01940221676755852}, {3.1316934046209806`, 0.01919655679005531}, {
          3.1320733761218658`, 0.01899857504425718}, {3.1324495399692704`, 
          0.018808192370235514`}, {3.132822046622182, 0.01862533264558955}, {
          3.1331910450772846`, 0.018449922755115988`}, {3.133556682928518, 
          0.01828189256167402}, {3.1339191064260827`, 0.01812117487823449}, {
          3.134278460534905, 0.017967705441102443`}, {3.1346348889925912`, 
          0.017821422884302718`}, {3.1349885343668937`, 
          0.017682268715118563`}, {3.135339538112709, 0.01755018729077393}, {
          3.1356880406286343`, 0.01742512579625033}, {3.1360341813130987`, 
          0.01730703422322965}, {3.136378098620102, 0.017195865350154785`}, {
          3.13671993011457, 0.01709157472340034}, {3.1370598125273608`, 
          0.01699412063954605}, {3.1373978818099357`, 0.01690346412874605}, {
          3.1377342731887197`, 0.01681956893918757}, {3.1380691212191723`, 
          0.01674240152263293}, {3.138402559839593, 0.016671931021039227`}, {
          3.138734722424678, 0.01660812925425057}, {3.1390657418388535`, 
          0.01655097070875799}, {3.139395750489404, 0.016500432527522667`}, {
          3.139724880379421, 0.016456494500858527`}, {3.1400532631605884`, 
          0.016419139058370648`}, {3.1403810301858273`, 
          0.01638835126194631}, {3.140708312561823, 0.016364118799795994`}, {
          3.141035241201454, 0.016346431981541946`}, {3.141361946876141, 
          0.01633528373435247}, {-3.141496746911443, 
          0.016330669600120355`}, {-3.1411700951567694`, 
          0.01633258773368442}, {-3.1408432743787276`, 
          0.0163410389020934}, {-3.1405161538490294`, 
          0.01635602648491195}, {-3.140188602719518, 
          0.01637755647556888}, {-3.139860489969843, 
          0.01640563748374809}, {-3.1395316843550667`, 
          0.016440280738823206`}, {-3.13920205435318, 
          0.016481500094337208`}, {-3.138871468112509, 
          0.016529312033528854`}, {-3.138539793398991, 
          0.016583735675907988`}, {-3.1382068975432933`, 
          0.016644792784882338`}, {-3.1378726473877645`, 
          0.01671250777643879}, {-3.137536909233187, 
          0.016786907728882465`}, {-3.137199548785314, 
          0.01686802239363747}, {-3.1368604311011716`, 
          0.01695588420711348}, {-3.1365194205350986`, 
          0.017050528303642783`}, {-3.1361763806845087`, 
          0.017151992529492843`}, {-3.1358311743353493`, 
          0.01726031745795982}, {-3.1354836634072383`, 
          0.01737554640554893}, {-3.135133708898253, 
          0.017497725449247933`}, {-3.1347811708293554`, 
          0.01762690344490048}, {-3.1344259081884216`, 
          0.017763132046686416`}, {-3.134067778873867, 
          0.017906465727716685`}, {-3.133706639637832, 
          0.018056961801750742`}, {-3.133342346028911, 
          0.018214680446044962`}, {-3.1329747523344045`, 
          0.01837968472534088}, {-3.1326037115220644`, 
          0.018552040617002566`}, {-3.132229075181318, 
          0.01873181703731285}, {-3.1318506934639396`, 
          0.018919085868938597`}, {-3.1314684150241483`, 
          0.01911392198957565}, {-3.1310820869581124`, 
          0.01931640330178446}, {-3.130691554742832, 
          0.019526610764028018`}, {-3.1302966621743735`, 
          0.019744628422923897`}, {-3.1298972513054393`, 
          0.019970543446723023`}, {-3.129493162382239, 
          0.020204446160027912`}, {-3.1290842337806435`, 
          0.020446430079763777`}, {-3.1286703019415953`, 
          0.020696591952416323`}, {-3.128251201305744, 
          0.020955031792550476`}, {-3.127826764247292, 
          0.021221852922624854`}, {-3.1273968210070096`, 
          0.02149716201411717}, {-3.12696119962441, 
          0.021781069129976308`}, {-3.126519725869042, 
          0.022073687768417245`}, {-3.12607222317088, 
          0.02237513490807551}, {-3.1256185125497895`, 
          0.02268553105453839}, {-3.125158412544024, 
          0.02300500028827049}, {-3.124691739137745, 
          0.023333670313951872`}, {-3.12421830568752, 
          0.023671672511247417`}, {-3.1237379228477797`, 
          0.0240191419870266}, {-3.1232503984951987`, 
          0.024376217629053336`}, {-3.1227555376519756`, 
          0.02474304216116617}, {-3.1222531424079762`, 
          0.02511976219996942}, {-3.121743011841715, 
          0.025506528313056612`}, {-3.1212249419401394`, 
          0.025903495078787905`}, {-3.1206987255171867`, 
          0.026310821147643805`}, {-3.1201641521310832`, 
          0.026728669305178008`}, {-3.1196210080003515`, 
          0.027157206536592694`}, {-3.1190690759184925`, 
          0.027596604092960154`}, {-3.11850813516731, 
          0.028047037559115202`}, {-3.1179379614288454`, 
          0.028508686923243324`}, {-3.1173583266958818`, 
          0.028981736648190003`}, {-3.1167689991809913`, 
          0.029466375744517402`}, {-3.1161697432240847`, 
          0.02996279784533487}, {-3.1155603191984262`, 
          0.030471201282930477`}, {-3.1149404834150816`, 
          0.03099178916723126}, {-3.114309988025759, 
          0.03152476946612041}, {-3.1136685809240063`, 
          0.03207035508764017}, {-3.1130160056447242`, 
          0.032628763964109804`}, {-3.1123520012619603`, 
          0.03320021913818852}, {-3.111676302284942, 
          0.03378494885091372}, {-3.1109886385523073`, 
          0.03438318663174558}, {-3.1102887351244943`, 
          0.034995171390649525`}, {-3.1095763121742492`, 
          0.035621147512248486`}, {-3.108851084875208, 
          0.0362613649520777}, {-3.108112763288508, 
          0.036916079334975}, {-3.1073610522473953`, 
          0.03758555205564031}, {-3.1065956512397674`, 
          0.03827005038139849}, {-3.1058162542886234`, 
          0.038969847557200045`}, {-3.1050225498303656`, 
          0.039685222912895037`}, {-3.1042142205909093`, 
          0.04041646197281562}, {-3.1033909434595555`, 
          0.04116385656770346}, {-3.102552389360575, 
          0.041927704949018485`}, {-3.1016982231224617`, 
          0.042708311905666034`}, {-3.100828103344798, 
          0.0435059888831798}, {-3.09994168226269, 
          0.04432105410539845}, {-3.0990386056087167`, 
          0.045153832698674075`}, {-3.0981185124723436`, 
          0.04600465681865122}, {-3.0971810351567504`, 
          0.04687386577965529}, {-3.0962257990330158`, 
          0.04776180618672969}, {-3.0952524223916087`, 
          0.048668832070361205`}, {-3.09426051629113, 
          0.04959530502393352}, {-3.093249684404251, 
          0.0505415943439488}, {-3.09221952286079, 
          0.05150807717305766}, {-3.091169620087871, 
          0.05249513864593782}, {-3.0900995566471097`, 
          0.05350317203806197}, {-3.089008905068762, 
          0.054532578917395366`}, {-3.0878972296827807`, 
          0.05558376929906365}, {-3.08676408644672, 
          0.0566571618030314}, {-3.0856090227704236`, 
          0.057753183814831854`}, {-3.084431577337436, 
          0.05887227164938776}, {-3.0832312799230768`, 
          0.06001487071796363}, {-3.082007651209111, 
          0.06118143569828871}, {-3.0807602025949534`, 
          0.06237243070789009}, {-3.07948843600534, 
          0.06358832948067458}, {-3.078191843694404, 
          0.06482961554679753}, {-3.076869908046087, 
          0.06609678241585608}, {-3.0755221013708183`, 
          0.06739033376344346}, {-3.0741478856983964`, 
          0.06871078362110017}, {-3.0727467125670023`, 
          0.07005865656969676}, {-3.071318022808277, 
          0.0714344879362818}, {-3.0698612463283883`, 
          0.07283882399442729}, {-3.0683758018850265`, 
          0.07427222216810236}, {-3.0668610968602446`, 
          0.07573525123910461}, {-3.065316527029083, 
          0.07722849155807625}, {-3.0637414763239006`, 
          0.07875253525913069}, {-3.0621353165943384`, 
          0.08030798647811294}, {-3.060497407362848, 
          0.08189546157451452}, {-3.058827095575707, 
          0.08351558935706135}, {-3.057123715349447, 
          0.08516901131299004}, {-3.0553865877126265`, 
          0.08685638184102493}, {-3.0536150203428654`, 
          0.08857836848806493}, {-3.0518083072990736`, 
          0.09033565218958543}, {-3.0499657287487985`, 
          0.09212892751375672}, {-3.0480865506906127`, 
          0.09395890290927583}, {-3.0461700246714747`, 
          0.0958263009569044}, {-3.044215387498981, 
          0.09773185862469976}, {-3.0422218609484424`, 
          0.09967632752692127}, {-3.0401886514647107`, 
          0.10166047418658805`}, {-3.0381149498586777`, 
          0.10368508030165778`}, {-3.035999930998382, 
          0.1057509430147896}, {-3.033842753494649, 
          0.10785887518664698`}, {-3.031642559381195, 
          0.11000970567268822`}, {-3.029398473789127, 
          0.11220427960338426`}, {-3.027109604615771, 
          0.11444345866779408`}, {-3.0247750421877626`, 
          0.1167281214004186}, {-3.022393858918338, 
          0.11905916347124347`}, {-3.0199651089587607`, 
          0.12143749797886999`}, {-3.017487827843828, 
          0.12386405574662179`}, {-3.014961032131398, 
          0.12633978562150183`}, {-3.012383719035881, 
          0.12886565477586104`}, {-3.0097548660556486`, 
          0.13144264901162525`}, {-3.0070734305943105`, 
          0.1340717730669116}, {-3.0043383495758134`, 
          0.13675405092484902`}, {-3.001548539053325, 
          0.13949052612440016`}, {-2.998702893811866, 
          0.1422822620729625}, {-2.995800286964656, 
          0.14513034236050715`}, {-2.992839569543156, 
          0.14803587107499233`}, {-2.989819570080781, 
          0.15099997311876517`}, {-2.986739094190268, 
          0.15402379452564213`}, {-2.9835969241347016`, 
          0.1571085027783319}, {-2.9803918183921847`, 
          0.1602552871258377}, {-2.977122511214176, 
          0.16346535890044614`}, {-2.9737877121774985`, 
          0.1667399518338797}, {-2.9703861057300553`, 
          0.17008032237215606`}, {-2.966916350730282, 
          0.17348774998866284`}, {-2.9633770799803836`, 
          0.17696353749491972`}, {-2.9597668997534146`, 
          0.18050901134845948`}, {-2.9560843893142703`, 
          0.18412552195721832`}, {-2.952328100434675, 
          0.18781444397978136`}, {-2.9484965569022594`, 
          0.1915771766207821}, {-2.9445882540238455`, 
          0.19541514392070433`}, {-2.9406016581230596`, 
          0.19932979503928303`}, {-2.936535206032427, 
          0.20332260453164383`}, {-2.9323873045801014`, 
          0.20739507261626208`}, {-2.928156330071426, 
          0.21154872543375916`}, {-2.9238406277655162`, 
          0.21578511529548808`}, {-2.9194385113471006`, 
          0.22010582092078937`}, {-2.914948262393866, 
          0.22451244766172473`}, {-2.910368129839586, 
          0.2290066277140171}, {-2.905696329433329, 
          0.23359002031284318`}, {-2.9009310431950883`, 
          0.23826431191203662`}, {-2.896070418868185, 
          0.24303121634516864`}, {-2.8911125693688473`, 
          0.2478924749668744}, {-2.8860555722333934`, 
          0.25284985677269156`}, {-2.880897469063482, 
          0.25790515849556916`}, {-2.87563626496994, 
          0.26306020467709085`}, {-2.870269928015713, 
          0.26831684771133674`}, {-2.8647963886585295`, 
          0.27367696785918183`}, {-2.8592135391939157`, 
          0.27914247323069663`}, {-2.8535192331992523`, 
          0.2847152997331756}, {-2.8477112849796087`, 
          0.29039741098217314`}, {-2.841787469016153, 
          0.29619079817277294`}, {-2.83574551941799, 
          0.30209747990815544`}, {-2.829583129378343, 
          0.3081195019823588}, {-2.8232979506360643`, 
          0.3142589371139531}, {-2.816887592943521, 
          0.32051788462716013`}, {-2.8103496235419856`, 
          0.3268984700767608}, {-2.803681566645727, 
          0.3334028448129266}, {-2.796880902936089, 
          0.3400331854819033}, {-2.7899450690669236`, 
          0.3467916934582539}, {-2.782871457182841, 
          0.35368059420413844`}, {-2.775657414451824, 
          0.36070213655087163`}, {-2.768300242613869, 
          0.3678585918977495}, {-2.7607971975474115`, 
          0.37515225332288155`}, {-2.7531454888554014`, 
          0.38258543460049715`}, {-2.745342279473023, 
          0.3901604691189204}, {-2.7373846852991606`, 
          0.39787970869312295`}, {-2.7292697748538512`, 
          0.4057455222654709}, {-2.7209945689640915`, 
          0.41376029448797974`}, {-2.71255604048051, 
          0.4219264241790816}, {-2.703951114027558, 
          0.4302463226475908}, {-2.6951766657900333`, 
          0.4387224118762284}, {-2.6862295233388984`, 
          0.44735712255673593`}, {-2.677106465499533, 
          0.4561528919682695}, {-2.6678042222657243`, 
          0.46511216169042635`}, {-2.658319474762886, 
          0.4742373751419082}, {-2.6486488552641765`, 
          0.4835309749354812}, {-2.6387889472633854`, 
          0.49299540003954256`}, {-2.6287362856086602`, 
          0.5026330827362598}, {-2.6184873567013423`, 
          0.5124464453659044}, {-2.608038598764409, 
          0.5224378968466661}, {-2.5973864021852306`, 
          0.5326098289589039}, {-2.586527109937581, 
          0.5429646123824754}, {-2.5754570180880716`, 
          0.5535045924754808}, {-2.5641723763924222`, 
          0.5642320847824753}, {-2.552669388987223, 
          0.5751493702599431}, {-2.5409442151830914`, 
          0.5862586902065877}, {-2.5289929703653757`, 
          0.5975622408857953}, {-2.5168117270088266`, 
          0.6090621678274579}, {-2.504396515812902, 
          0.6207605597962229}, {-2.4917433269646385`, 
          0.632659442413164}, {-2.4788481115362817`, 
          0.6447607714178498}, {-2.465706783025125, 
          0.6570664255578393}, {-2.45231521904327, 
          0.6695781990927515}, {-2.438669263165265, 
          0.6822977939002636}, {-2.4247647269418313`, 
          0.6952268111716859}, {-2.4105973920881283`, 
          0.7083667426851595}, {-2.3961630128552276`, 
          0.721718961645032}, {-2.3814573185936956`, 
          0.7352847130766029}, {-2.3664760165183716`, 
          0.7490651037662018}, {-2.3512147946836217`, 
          0.7630610917374828}, {-2.3356693251785035`, 
          0.7772734752559065}, {-2.3198352675514107`, 
          0.7917028813546437}, {-2.303708272473879, 
          0.806349753876591}, {-2.2872839856533016`, 
          0.8212143410288539}, {-2.270558052004343, 
          0.8362966824479432}, {-2.253526120088822, 
          0.8515965957760556}, {-2.236183846833798, 
          0.8671136627511997}, {-2.2185269025374663`, 
          0.8828472148165787}, {-2.2005509761723143`, 
          0.8987963182575918}, {-2.1822517809947533`, 
          0.9149597588780611}, {-2.163625060470136, 
          0.9313360262308573}, {-2.1446665945216963`, 
          0.9479232974219953}, {-2.125372206111466, 
          0.9647194205115127}, {-2.1057377681606853`, 
          0.9817218975390407}, {-2.0857592108165464`, 
          0.9989278672069346}, {-2.065432529071363, 
          1.0163340872591626`}, {-2.044753790739366, 
          1.0339369165998493`}, {-2.0237191447953373`, 
          1.051732297201444}, {-2.002324830078159, 
          1.0697157358589204`}, {-1.9805671843610946`, 
          1.087882285853211}, {-1.9584426537892103`, 
          1.1062265285942123`}, {-1.9359478026827872`, 
          1.1247425553211574`}, {-1.9130793237038692`, 
          1.1434239489458946`}, {-1.8898340483812168`, 
          1.1622637661326203`}, {-1.8662089579869003`, 
          1.1812545197158266`}, {-1.8422011947555683`, 
          1.2003881615666023`}, {-1.8178080734350504`, 
          1.2196560660258957`}, {-1.7930270931544134`, 
          1.2390490140318497`}, {-1.7678559495928783`, 
          1.258557178076755}, {-1.7422925474301292`, 
          1.2781701081374524`}, {-1.7163350130555082`, 
          1.2978767187310494`}, {-1.689981707510399, 
          1.317665277255463}, {-1.6632312396347697`, 
          1.3375233937814544`}, {-1.6360824793853832`, 
          1.357438012469328}, {-1.6085345712895995`, 
          1.377395404789181}, {-1.5805869479950325`, 
          1.3973811647283543`}, {-1.552239343871565, 
          1.4173802061733765`}, {-1.5234918086184441`, 
          1.4373767626560439`}, {-1.494344720825361, 
          1.4573543896541497`}, {-1.4647988014326292`, 
          1.4772959696365913`}, {-1.43485512703183, 
          1.4971837200399614`}, {-1.4045151429446483`, 
          1.5169992043590816`}, {-1.3737806760141063`, 
          1.5367233465270984`}, {-1.3426539470390748`, 
          1.5563364487515667`}, {-1.31113758277985, 
          1.5758182129612492`}, {-1.2792346274597695`, 
          1.5951477660040287`}, {-1.2469485536853842`, 
          1.6143036887192654`}, {-1.214283272705623, 
          1.6332640489880585`}, {-1.18124314392878, 
          1.6520064388421454`}, {-1.147832983615048, 
          1.6705080156865983`}, {-1.114058072661786, 
          1.6887455476631033`}, {-1.0799241633987957`, 
          1.7066954631495053`}, {-1.0454374853116426`, 
          1.724333904357658}, {-1.010604749612531, 
          1.74163678495558}, {-0.975433152580495, 
          1.7585798516018005`}, {-0.9399303775956979, 
          1.7751387492398596`}, {-0.9041045957965056, 
          1.7912890899596112`}, {-0.8679644652927117, 
          1.8070065251896956`}, {-0.8315191288738559, 
          1.8222668209427861`}, {-0.7947782101580051, 
          1.83704593579254}, {-0.7577518081336219, 
          1.8513201012191591`}, {-0.7204504900552269, 
          1.8650659039197477`}, {-0.6828852826624094, 
          1.878260369640873}, {-0.6450676617013176, 
          1.8908810480545917`}, {-0.6070095397379907, 
          1.9029060981663433`}, {-0.5687232522637058, 
          1.9143143737142414`}, {-0.5302215421038055, 
          1.9250855079950182`}, {-0.49151754215314875`, 
          1.9351999975328351`}, {-0.4526247564732708, 
          1.9446392839938982`}, {-0.41355703979841485`, 
          1.9533858337427963`}, {-0.37432857550969256`, 
          1.961423214436114}, {-0.3349538521485833, 
          1.968736168055462}, {-0.2954476385526672, 
          1.975310679795806}, {-0.2558249577077486, 
          1.981134042245931}, {-0.21610105942122812`, 
          1.986194914326024}, {-0.17629139193157858`, 
          1.9904833744824773`}, {-0.1364115725779419, 
          1.993990967681834}, {-0.09647735766206468, 
          1.9967107457938609`}, {-0.05650461164191523, 
          1.9986373010074723`}, {-0.01650927580227539, 1.9997667919819921`}, {
          0.023492663447709103`, 2.0000969624992244`}, {0.06348520649667225, 
          1.9996271524481575`}, {0.10345237251753046`, 1.9983583010429107`}, {
          0.14337823136242564`, 1.9962929422447588`}, {0.18324693521102003`, 
          1.9934351924297191`}, {0.22304274981928468`, 1.9897907304132318`}, {
          0.26275008521952264`, 1.9853667700118973`}, {0.30235352572728386`, 
          1.9801720253880597`}, {0.3418378591169907, 1.9742166694853422`}, {
          0.3811881048354141, 1.967512285921169}, {0.42038954113051624`, 
          1.960071814755108}, {0.45942773098249384`, 1.95190949259888}, {
          0.49828854673398487`, 1.9430407875745515`}, {0.536958193327212, 
          1.933482329661355}, {0.5754232300671815, 1.9232518369984797`}, {
          0.6136705908417989, 1.9123680387308652`}, {0.6516876027417493, 
          1.9008505949975225`}, {0.6894620030350944, 1.888720014667257}, {
          0.7269819544635968, 1.8759975714251205`}, {0.7642360588396923, 
          1.862705218804774}, {0.8012133689346448, 1.848865504747625}, {
          0.8379033986596369, 1.834501486249605}, {0.8742961315522636, 
          1.8196366446313317`}, {0.9103820275910193, 1.804294801937784}, {
          0.946152028369822, 1.7885000389401373`}, {0.981597560673337, 
          1.7722766151757512`}, {1.0167105385017998`, 1.755648891423135}, {
          1.0514833636011542`, 1.7386412549677253`}, {1.0859089245605968`, 
          1.7212780479721257`}, {1.1199805945450314`, 1.7035834992217262`}, {
          1.1536922277345096`, 1.6855816594739075`}, {1.1870381545464472`, 
          1.6672963405968844`}, {1.22001317571931, 1.6487510586431429`}, {
          1.2526125553385659`, 1.629968980962794}, {1.2848320128870536`, 
          1.61097287742439}, {1.316667714402556, 1.5917850757751189`}, {
          1.3481162628253374`, 1.5724274211390654`}, {1.3791746876177695`, 
          1.552921239621611}, {1.4098404337369723`, 1.5332873059601353`}, {
          1.4401113500396947`, 1.5135458151361194`}, {1.469985677196525, 
          1.4937163578415127`}, {1.4994620351899821`, 1.4738178996728541`}, {
          1.528539410468183, 1.4538687639100532`}, {1.5572171428226405`, 
          1.433886617722873}, {1.5854949120553787`, 1.4138884616369125`}, {
          1.6133727244970208`, 1.393890622082102}, {1.6408508994338267`, 
          1.373908746840296}, {1.6679300554979117`, 1.3539578032042543`}, {
          1.6946110970710722`, 1.33405207865802}, {1.7208952007488365`, 
          1.3142051838882174`}, {1.7467838019075752`, 1.2944300579369394`}, {
          1.7722785814137647`, 1.2747389753094753`}, {1.7973814525108445`, 
          1.2551435548539884`}, {1.8220945479155481`, 1.2356547702351888`}, {
          1.8464202071521463`, 1.2162829618299116`}, {1.8703609641497292`, 
          1.1970378498791434`}, {1.8939195351244948`, 1.177928548738286}, {
          1.9170988067659982`, 1.1589635820751711`}, {1.9399018247434667`, 
          1.1401508988734288`}, {1.9623317825456092`, 1.1214978901071233`}, {
          1.9843920106648298`, 1.1030114059610336`}, {2.006085966134419, 
          1.0846977734794494`}, {2.027417222425115, 1.0665628145348167`}, {
          2.0483894597054335`, 1.0486118640159197`}, {2.069006455468303, 
          1.0308497881434642`}, {2.089272075524881, 1.0132810028288974`}, {
          2.1091902653648806`, 0.9959094919999898}, {2.128765041881363, 
          0.9787388258241122}, {2.1480004854567074`, 0.9617721787672188}, {
          2.166900732405373, 0.9450123474332756}, {2.185469967768078, 
          0.9284617681352543}, {2.2037124184511745`, 0.9121225341548148}, {
          2.221632346704243, 0.8959964126534362}, {2.2392340439283034`, 
          0.8800848612030201}, {2.256521824806481, 0.8643890439088863}, {
          2.2735000217485335`, 0.848909847102613}, {2.2901729796402606`, 
          0.8336478945863558}, {2.306545050888543, 0.8186035624141175}, {
          2.322620590752522, 0.8037769931989512}, {2.3384039529512877`, 
          0.7891681099382737}}, $CellContext`Evolution2[
          Pattern[$CellContext`n, 
           Blank[]], {
           Pattern[$CellContext`x0, 
            Blank[]], 
           Pattern[$CellContext`v0, 
            Blank[]]}, 
          Pattern[$CellContext`dt, 
           Blank[]], 
          Pattern[$CellContext`k, 
           Blank[]], 
          Pattern[$CellContext`d, 
           Blank[]]] := 
        Module[{$CellContext`flow = {}, $CellContext`i = 
           0, $CellContext`x = $CellContext`x0, $CellContext`v = \
$CellContext`v0, $CellContext`tmpx = 0, $CellContext`tmpv = 0, $CellContext`a = 
           0}, For[$CellContext`i = 1, $CellContext`i <= $CellContext`n, 
            AppendTo[$CellContext`flow, {$CellContext`x, $CellContext`v}]; \
$CellContext`tmpx = $CellContext`x; $CellContext`tmpv = $CellContext`v; \
$CellContext`a = (-$CellContext`k) 
               Sin[$CellContext`x] - $CellContext`d $CellContext`v; 
            AddTo[$CellContext`v, $CellContext`a $CellContext`dt]; 
            AddTo[$CellContext`x, $CellContext`v $CellContext`dt]; \
$CellContext`x = $CellContext`f[$CellContext`x]; Null; 
            Increment[$CellContext`i]]; $CellContext`flow], $CellContext`f[
          Pattern[$CellContext`x, 
           Blank[]]] := 
        If[$CellContext`x >= Pi, -Pi + ($CellContext`x - Pi), 
          
          If[$CellContext`x <= -Pi, 
           Pi + ($CellContext`x + Pi), $CellContext`x]], 
        Attributes[PlotRange] = {ReadProtected}}; Typeset`initDone$$ = True); 
     ReleaseHold[{{
         HoldComplete[$CellContext`f[
             Pattern[$CellContext`x, 
              Blank[]]] := 
           If[$CellContext`x >= Pi, -Pi + ($CellContext`x - Pi), 
             
             If[$CellContext`x <= -Pi, 
              Pi + ($CellContext`x + Pi), $CellContext`x]]; Null], 
         HoldComplete[Null], 
         HoldComplete[$CellContext`Evolution2[
             Pattern[$CellContext`n, 
              Blank[]], {
              Pattern[$CellContext`x0, 
               Blank[]], 
              Pattern[$CellContext`v0, 
               Blank[]]}, 
             Pattern[$CellContext`dt, 
              Blank[]], 
             Pattern[$CellContext`k, 
              Blank[]], 
             Pattern[$CellContext`d, 
              Blank[]]] := 
           Module[{$CellContext`flow = {}, $CellContext`i = 
              0, $CellContext`x = $CellContext`x0, $CellContext`v = \
$CellContext`v0, $CellContext`tmpx = 0, $CellContext`tmpv = 0, $CellContext`a = 
              0}, For[$CellContext`i = 1, $CellContext`i <= $CellContext`n, 
               AppendTo[$CellContext`flow, {$CellContext`x, $CellContext`v}]; \
$CellContext`tmpx = $CellContext`x; $CellContext`tmpv = $CellContext`v; \
$CellContext`a = (-$CellContext`k) 
                  Sin[$CellContext`x] - $CellContext`d $CellContext`v; 
               AddTo[$CellContext`v, $CellContext`a $CellContext`dt]; 
               AddTo[$CellContext`x, $CellContext`v $CellContext`dt]; \
$CellContext`x = $CellContext`f[$CellContext`x]; Null; 
               Increment[$CellContext`i]]; $CellContext`flow]; Null]}}]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->2688309],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Motion of a Simple Pendulum with Damping",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/MotionOfASimplePendulumWithDamping/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/MotionOfASimplePendulumWithDamping/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
MotionOfASimplePendulumWithDamping/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/MotionOfASimplePendulumWithDamping/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/MotionOfASimplePendulumWithDamping/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Bartosz Naskrecki",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Bartosz+\
Naskrecki"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Bartosz+Naskrecki"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
MotionOfASimplePendulumWithDamping"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Motion of a Simple Pendulum with Damping - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 232, 4, 70, "Section"],
Cell[825, 29, 3079, 77, 70, "Input",
 InitializationCell->True,
 CellID->194316413],
Cell[3907, 108, 5693, 141, 70, "Input"]
}, Open  ]],
Cell[9615, 252, 43499, 720, 70, "Output",
 CellID->2688309],
Cell[CellGroupData[{
Cell[53139, 976, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[53515, 987, 1001, 29, 70, "Text"],
Cell[54519, 1018, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[54859, 1029, 445, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[55329, 1047, 847, 24, 70, "Text"],
Cell[56179, 1073, 1210, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 8QzeFe0XrbYU3ADXwAH6zTwg *)
