(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     56612,       1365]
NotebookOptionsPosition[     55410,       1320]
NotebookOutlinePosition[     56077,       1345]
CellTagsIndexPosition[     56034,       1342]
WindowTitle->Light Ray Passing through a Transparent Plate - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Light Ray Passing through a Transparent Plate", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "\:0440\:043e\:0437\:0440\:0430\:0445\:0443\:043d\:043e\:043a", " ", 
     "\:043a\:0443\:0442\:0430", " ", "\:043c\:0456\:0436", " ", 
     "\:0432\:0435\:043a\:0442\:043e\:0440\:0430\:043c\:0438", " ", "\:0437", 
     " ", "\:0457\:0445", " ", 
     "\:0441\:043a\:0430\:043b\:044f\:0440\:043d\:043e\:0433\:043e", " ", 
     "\:0434\:043e\:0431\:0443\:0442\:043a\:0443"}], "*)"}], 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"angle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x0_", ",", "y0_"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], " ", ":=", 
      RowBox[{"ArcCos", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], "-", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "y0"}], "}"}]}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}], "-", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "y0"}], "}"}]}], ")"}]}], 
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x1", "-", "x0"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y1", "-", "y0"}], ")"}], "2"]}]], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x2", "-", "x0"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y2", "-", "y0"}], ")"}], "2"]}]]}]], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"refangle", "[", 
       RowBox[{"\[Theta]1_", ",", "n_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"If", " ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           FractionBox["1", "n"], 
           RowBox[{"Sin", "[", "\[Theta]1", " ", "]"}]}], "\[GreaterEqual]", 
          "1"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}], ",", 
         RowBox[{"ArcSin", "[", 
          RowBox[{
           FractionBox["1", "n"], 
           RowBox[{"Sin", "[", "\[Theta]1", " ", "]"}]}], "]"}]}], "]"}], "//",
        "N"}]}], " ", ";", "  ", 
     RowBox[{"(*", 
      RowBox[{
      "Angle", " ", "of", " ", "Refraction", " ", "at", " ", "the", " ", "1", 
       "st", " ", "interface"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"pleft", "=", 
          RowBox[{"-", "9"}]}], ",", 
         RowBox[{"pright", "=", "9"}], ",", 
         RowBox[{"point1", "=", 
          RowBox[{"{", 
           RowBox[{"xpoint1", ",", "d"}], "}"}]}], ",", "xpoint1", ",", 
         "xpoint2", ",", "xpoint3", ",", 
         RowBox[{"phi0", "=", 
          RowBox[{"phi0gr", "*", "Degree"}]}], ",", "phi1"}], "}"}], ",", 
       "  ", "\n", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"line2", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x2", " ", "y1"}], "-", 
                  RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x4", ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x2", " ", "y1"}], "-", 
                  RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"arrow2", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x2", " ", "y1"}], "-", 
                  RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x4", ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x2", " ", "y1"}], "-", 
                  RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
          "]"}]}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
          "\:043b\:0456\:043d\:0456\:044f", " ", "\:0437", " ", 
           "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
           " ", "\:0442", ".3"}], ",", " ", 
          RowBox[{
          "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c\
", " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
           "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
           "\:0447\:0435\:0440\:0435\:0437", " ", 
           "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
           "2"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "(*", "\:043f\:043b\:0430\:0441\:0442\:0438\:043d\:043a\:0430", 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Thick", ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"pleft", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"pright", ",", "d"}], "}"}]}], "}"}], "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"pleft", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"pright", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
              RowBox[{"Lighter", "[", 
               RowBox[{"Blue", ",", 
                RowBox[{".8", "/", 
                 RowBox[{"(", 
                  RowBox[{"nred", "-", ".13"}], ")"}]}]}], "]"}], ",", 
              RowBox[{"Polygon", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"pleft", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"pleft", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"pright", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"pright", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{"\:043f\:0440\:043e\:043c\:0456\:043d\:044c", ",", " ", 
              RowBox[{
              "\:0449\:043e", " ", "\:043f\:0430\:0434\:0430\:0454", " ", 
               "\:043d\:0430", " ", 
               "\:043f\:043b\:0430\:0441\:0442\:0438\:043d\:0443", " ", 
               RowBox[{"Darker", "[", 
                RowBox[{"Red", ",", ".4"}], "]"}]}]}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", 
              RowBox[{"Darker", "[", 
               RowBox[{"Red", ",", ".4"}], "]"}], ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"point1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"11", "-", "d"}], ")"}], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", "phi0", "]"}]}], ",", 
                    RowBox[{"Cos", "[", "phi0", "]"}]}], "}"}]}]}], ",", 
                 "point1"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
               "\:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:0438\:0439",
                 " ", "\:043f\:0440\:043e\:043c\:0456\:043d\:044c"}], "*)"}], 
              "\[IndentingNewLine]", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{"point1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"xpoint2", "=", 
                    RowBox[{
                    RowBox[{
                    "point1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"d", "*", 
                    RowBox[{"Tan", "[", 
                    RowBox[{"phi1", "=", 
                    RowBox[{"refangle", "[", 
                    RowBox[{"phi0", ",", "nred"}], "]"}]}], "]"}]}]}]}], ",", 
                   "0"}], "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"arrow2", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"xpoint2", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"xmax", "=", 
                    RowBox[{"xpoint2", "+", 
                    RowBox[{"6", "*", 
                    RowBox[{"Tan", "[", 
                    RowBox[{"refangle", "[", 
                    RowBox[{
                    RowBox[{"angle", "[", 
                    RowBox[{"point1", ",", 
                    RowBox[{"{", 
                    RowBox[{"xpoint2", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"xpoint2", ",", "9"}], "}"}]}], "]"}], ",", 
                    RowBox[{"1", "/", "nred"}]}], "]"}], "]"}]}]}]}], ",", 
                    RowBox[{"-", "6"}]}], "}"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"xpoint2", ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"xmax", ">", "9"}], ",", "9", ",", "xmax"}], 
                   "]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "\:043f\:043e\:0437\:043d\:0430\:0447\:0435\:043d\:043d\:044f", 
              " ", "\:043d\:0430", " ", 
              "\:043c\:0430\:043b\:044e\:043d\:043a\:0443"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"pozn", ",", 
              RowBox[{"{", 
               RowBox[{"Thin", ",", "Black", ",", 
                RowBox[{"Arrowheads", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", ".03"}], ",", ".03"}], "}"}], "]"}], ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "8"}], ",", "d"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "8"}], ",", "0"}], "}"}]}], "}"}], "]"}], 
                ",", 
                RowBox[{"Thickness", "[", "0.004", "]"}], ",", "Dashed", ",", 
                
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "point1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "10"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "point1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "0.1"}], "*", "d"}]}], "}"}]}], "}"}], "]"}],
                 " ", ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"xpoint2", ",", 
                    RowBox[{"0.9", "*", "d"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"xpoint2", ",", 
                    RowBox[{"-", "d"}]}], "}"}]}], "}"}], "]"}], ",", 
                RowBox[{"Circle", "[", 
                 RowBox[{"point1", ",", "1.7", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "2"}], "+", "phi0"}]}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(0\)]\)\>\"", 
                    ",", "Medium"}], "]"}], ",", 
                  RowBox[{"point1", "+", 
                   RowBox[{"2.4", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"phi0", "/", "2"}], "]"}]}], ",", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"phi0", "/", "2"}], "]"}]}], "}"}]}]}]}], "]"}], 
                ",", 
                RowBox[{"Circle", "[", 
                 RowBox[{"point1", ",", "1.7", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"3", 
                    RowBox[{"\[Pi]", "/", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"3", 
                    RowBox[{"\[Pi]", "/", "2"}]}], "+", "phi1"}]}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(1\)]\)\>\"", 
                    ",", "Medium"}], "]"}], ",", 
                  RowBox[{"point1", "-", 
                   RowBox[{"2.4", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"phi1", "/", "2"}], "]"}]}], ",", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"phi1", "/", "2"}], "]"}]}], "}"}]}]}]}], "]"}], 
                ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<d\>\"", ",", "Medium"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "8.5"}], ",", 
                    RowBox[{"d", "/", "2"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<\!\(\*SubscriptBox[\(n\), \(1\)]\)\>\"", ",", 
                    "Medium"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "7"}], ",", 
                    RowBox[{"d", "+", "1"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<\!\(\*SubscriptBox[\(n\), \(2\)]\)\>\"", ",", 
                    "Medium"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "7"}], ",", 
                    RowBox[{"d", "/", "2"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<\!\(\*SubscriptBox[\(n\), \(1\)]\)\>\"", ",", 
                    "Medium"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "7"}], ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], " ", ",", 
              RowBox[{"{", " ", "}"}]}], "]"}], " ", ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{
              "\:043f\:0440\:043e\:0434\:043e\:0432\:0436\:0435\:043d\:043d\
\:044f", " ", "\:043f\:0440\:043e\:043c\:0435\:043d\:044f"}], ",", " ", 
              RowBox[{
              "\:0449\:043e", " ", "\:043f\:0430\:0434\:0430\:0454", " ", 
               "\:043d\:0430", " ", 
               "\:043f\:043b\:0430\:0441\:0442\:0438\:043d\:0443"}]}], "*)"}],
             "\[IndentingNewLine]", " ", 
            RowBox[{"{", 
             RowBox[{"Thin", ",", 
              RowBox[{"Darker", "[", 
               RowBox[{"Red", ",", ".4"}], "]"}], ",", "Dashed", ",", 
              RowBox[{"line2", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"point1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"10", "-", "d"}], ")"}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", "phi0", "]"}]}], ",", 
                    RowBox[{"Cos", "[", "phi0", "]"}]}], "}"}]}]}], ",", 
                  "point1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                  "point1", "\[LeftDoubleBracket]", "1", 
                   "\[RightDoubleBracket]"}], ",", "10"}], "}"}]}], "]"}]}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{"pozn", ",", 
              RowBox[{"{", 
               RowBox[{"Thin", ",", "Black", ",", 
                RowBox[{"Arrowheads", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", ".03"}], ",", ".03"}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nred", ">", "1"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xpoint3", "=", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "point1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"Tan", "[", "phi0", "]"}]}]}], ")"}]}], ",", 
                    "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xpoint3", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"h", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"xpoint3", "-", "xpoint2"}], ")"}], " ", 
                    RowBox[{"Cos", "[", "phi0", "]"}]}]}], ")"}], 
                    RowBox[{"Cos", "[", "phi0", "]"}]}]}], ",", 
                    RowBox[{"ypoint4", "=", 
                    RowBox[{
                    RowBox[{"-", "h"}], " ", 
                    RowBox[{"Sin", "[", "phi0", "]"}]}]}]}], "}"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<h\>\"", ",", "Medium"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"xpoint3", ",", 
                    RowBox[{".8", " ", "ypoint4"}]}], "}"}]}], "]"}]}], "}"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xpoint2", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xpoint2", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"h", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"xpoint2", "-", 
                    RowBox[{"(", 
                    RowBox[{"xpoint3", "=", 
                    RowBox[{
                    RowBox[{
                    "point1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{"d", " ", 
                    RowBox[{"Tan", "[", "phi0", "]"}]}]}]}], ")"}]}], ")"}], 
                    " ", 
                    RowBox[{"Cos", "[", "phi0", "]"}]}]}], ")"}], 
                    RowBox[{"Cos", "[", "phi0", "]"}]}]}], ",", 
                    RowBox[{"ypoint4", "=", 
                    RowBox[{
                    RowBox[{"-", "h"}], " ", 
                    RowBox[{"Sin", "[", "phi0", "]"}]}]}]}], "}"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<h\>\"", ",", "Medium"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xpoint2", "-", "0.5"}], ",", 
                    RowBox[{".8", " ", "ypoint4"}]}], "}"}]}], "]"}]}], 
                   "}"}]}], "\[IndentingNewLine]", "]"}]}], " ", "}"}], " ", 
              ",", 
              RowBox[{"{", " ", "}"}]}], "]"}]}], "  ", "\[IndentingNewLine]",
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"PlotLabel", "->", 
           RowBox[{"If", "[", 
            RowBox[{"pozn", ",", 
             RowBox[{"Text", "@", 
              RowBox[{"TraditionalForm", "@", 
               RowBox[{"Style", "[", 
                RowBox[{
                 RowBox[{"Row", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    SubscriptBox["n", "2"], "/", 
                    SubscriptBox["n", "1"]}], ",", "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{"nred", ",", ".01"}], "]"}], ",", "\"\<, \>\"", 
                    ",", " ", 
                    SubscriptBox["\[CurlyPhi]", "0"], " ", ",", "\"\< = \>\"",
                     ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"phi0", "/", "Degree"}], ",", ".1"}], "]"}], ",", 
                    "\"\<\[Degree]\>\"", ",", "\"\<, \>\"", ",", 
                    SubscriptBox["\[CurlyPhi]", "1"], " ", ",", "\"\< = \>\"",
                     ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"phi1", "/", "Degree"}], ",", ".1"}], "]"}], ",", 
                    "\"\<\[Degree]\>\"", ",", "\"\<\\n\>\"", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<h\>\"", ",", "Italic"}], "]"}], ",", " ", 
                    "\"\< = \>\"", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], ",", 
                    "\"\< \>\"", ",", " ", 
                    RowBox[{"Cos", "[", 
                    SubscriptBox["\[CurlyPhi]", "0"], "]"}], ",", "\"\<(\>\"",
                     ",", 
                    RowBox[{
                    RowBox[{"Tan", "[", 
                    SubscriptBox["\[CurlyPhi]", "0"], "]"}], "-", 
                    RowBox[{"Tan", "[", 
                    SubscriptBox["\[CurlyPhi]", "1"], "]"}]}], ",", 
                    "\"\<)\>\"", ",", "\"\< = \>\"", ",", 
                    RowBox[{"Round", "[", 
                    RowBox[{"h", ",", ".1"}], "]"}]}], "}"}], "]"}], ",", 
                 RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}]}], " ", 
             ",", "\"\< \>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "\:041e\:043f\:0446\:0456\:0457", " ", 
            "\:0413\:0440\:0430\:0444\:0456\:043a\:0430"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"ImageSize", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"425", ",", "400"}], "}"}]}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", ".85"}], ",", 
          RowBox[{"Axes", "\[Rule]", "koord"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"ImagePadding", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"10", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"GrayLevel", "[", "0.9", "]"}]}]}], "]"}]}]}], 
      RowBox[{"(*", 
       RowBox[{"End", " ", "Graphics"}], "*)"}], "\[IndentingNewLine]", 
      "]"}]}], ",", 
    RowBox[{"(*", 
     RowBox[{"End", " ", "Module"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
     "\:0456\:043d\:0441\:0442\:0440\:0443\:043c\:0435\:043d\:0442\:0438", 
      " ", "\:0434\:043b\:044f", " ", 
      "\:043a\:0435\:0440\:0443\:0432\:0430\:043d\:043d\:044f"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Control", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "nred", ",", "1.51106", ",", 
              "\"\<\!\(\*SubscriptBox[\(n\), \
\(2\)]\)/\!\(\*SubscriptBox[\(n\), \(1\)]\) \>\""}], "}"}], ",", "0.8", ",", 
            "2.2", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Control", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"d", ",", "4", ",", "\"\<d \>\""}], "}"}], ",", "0.1", 
            ",", "8", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Control", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xpoint1", ",", 
              RowBox[{"-", "3"}], ",", "\"\<P\>\""}], "}"}], ",", 
            RowBox[{"-", "7"}], ",", "0", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Control", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "phi0gr", ",", "64", ",", 
              "\"\<\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(0\)]\)\>\""}], "}"}],
             ",", "0.01", ",", "89.9", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], "]"}]}], 
        "}"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Control", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"pozn", ",", "True", ",", "\"\<notation\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Control", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"koord", ",", "False", ",", "\"\<  axes\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{"Button", "[", 
        RowBox[{"\"\<initialize\>\"", ",", 
         RowBox[{
          RowBox[{"phi0gr", "=", "64"}], ";", 
          RowBox[{"nred", "=", "1.51106"}], ";", 
          RowBox[{"koord", "=", "False"}], ";", 
          RowBox[{"xpoint1", "=", 
           RowBox[{"-", "3"}]}], ";", 
          RowBox[{"d", "=", "4"}], ";", 
          RowBox[{"pozn", "=", "True"}]}]}], "]"}]}], "}"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "\[RuleDelayed]", "Manipulate"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.446830106828125*^9, {3.446869125671875*^9, 
   3.446869158734375*^9}, {3.446896261015625*^9, 3.446896301203125*^9}, {
   3.446896363296875*^9, 3.44689636384375*^9}, {3.4468964105*^9, 
   3.446896478453125*^9}, {3.447188291609744*^9, 3.4471882977972836`*^9}, {
   3.4471883287193565`*^9, 3.447188370844626*^9}, {3.447188422141811*^9, 
   3.4471887176399193`*^9}, {3.447189383541908*^9, 3.447189396151202*^9}, {
   3.4471894383228073`*^9, 3.447189495775564*^9}, {3.447190547925081*^9, 
   3.4471905681280766`*^9}, {3.447190604455969*^9, 3.4471906691899295`*^9}, {
   3.447190736642623*^9, 3.447190762126835*^9}, {3.447190801251584*^9, 
   3.447190983625417*^9}, {3.4471910242814074`*^9, 3.447191067203007*^9}, {
   3.4471911766554317`*^9, 3.4471911989990387`*^9}, {3.447191255139304*^9, 
   3.4471912891390867`*^9}, 3.4475252654486694`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 4, $CellContext`koord$$ = 
    False, $CellContext`nred$$ = 1.51106, $CellContext`phi0gr$$ = 
    64, $CellContext`pozn$$ = True, $CellContext`xpoint1$$ = -3, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`nred$$], 1.51106, 
       "\!\(\*SubscriptBox[\(n\), \(2\)]\)/\!\(\*SubscriptBox[\(n\), \(1\)]\) \
"}, 0.8, 2.2}, {{
       Hold[$CellContext`d$$], 4, "d "}, 0.1, 8}, {{
       Hold[$CellContext`xpoint1$$], -3, "P"}, -7, 0}, {{
       Hold[$CellContext`phi0gr$$], 64, 
       "\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(0\)]\)"}, 0.01, 89.9}, {
      Hold[
       Grid[{{
          Manipulate`Place[1], 
          Manipulate`Place[2]}, {
          Manipulate`Place[3], 
          Manipulate`Place[4]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`pozn$$], True, "notation"}, {True, False}}, {{
       Hold[$CellContext`koord$$], False, "  axes"}, {True, False}}, {
      Hold[
       Row[{
         Manipulate`Place[5], 
         Manipulate`Place[6], 
         Button[
         "initialize", $CellContext`phi0gr$$ = 64; $CellContext`nred$$ = 
           1.51106; $CellContext`koord$$ = 
           False; $CellContext`xpoint1$$ = -3; $CellContext`d$$ = 
           4; $CellContext`pozn$$ = True]}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    425., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`nred$525180$$ = 
    0, $CellContext`d$525181$$ = 0, $CellContext`xpoint1$525182$$ = 
    0, $CellContext`phi0gr$525183$$ = 0, $CellContext`pozn$525184$$ = 
    False, $CellContext`koord$525185$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`d$$ = 4, $CellContext`koord$$ = 
        False, $CellContext`nred$$ = 1.51106, $CellContext`phi0gr$$ = 
        64, $CellContext`pozn$$ = True, $CellContext`xpoint1$$ = -3}, 
      "ControllerVariables" :> {
        Hold[$CellContext`nred$$, $CellContext`nred$525180$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$525181$$, 0], 
        Hold[$CellContext`xpoint1$$, $CellContext`xpoint1$525182$$, 0], 
        Hold[$CellContext`phi0gr$$, $CellContext`phi0gr$525183$$, 0], 
        Hold[$CellContext`pozn$$, $CellContext`pozn$525184$$, False], 
        Hold[$CellContext`koord$$, $CellContext`koord$525185$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`angle[{
           Pattern[$CellContext`x1, 
            Blank[]], 
           Pattern[$CellContext`y1, 
            Blank[]]}, {
           Pattern[$CellContext`x0, 
            Blank[]], 
           Pattern[$CellContext`y0, 
            Blank[]]}, {
           Pattern[$CellContext`x2, 
            Blank[]], 
           Pattern[$CellContext`y2, 
            Blank[]]}] := 
        ArcCos[Dot[{$CellContext`x1, $CellContext`y1} - {$CellContext`x0, \
$CellContext`y0}, {$CellContext`x2, $CellContext`y2} - {$CellContext`x0, \
$CellContext`y0}]/((($CellContext`x1 - $CellContext`x0)^2 + ($CellContext`y1 - \
$CellContext`y0)^2)^
           Rational[
            1, 2] (($CellContext`x2 - $CellContext`x0)^2 + ($CellContext`y2 - \
$CellContext`y0)^2)^Rational[1, 2])]; $CellContext`refangle[
          Pattern[$CellContext`\[Theta]1, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := N[
          If[(1/$CellContext`n) Sin[$CellContext`\[Theta]1] >= 1, Pi/2, 
           ArcSin[(1/$CellContext`n) Sin[$CellContext`\[Theta]1]]]]; 
       Module[{$CellContext`pleft$ = -9, $CellContext`pright$ = 
          
          9, $CellContext`point1$ = {$CellContext`xpoint1$$, \
$CellContext`d$$}, $CellContext`xpoint1$, $CellContext`xpoint2$, \
$CellContext`xpoint3$, $CellContext`phi0$ = $CellContext`phi0gr$$ 
           Degree, $CellContext`phi1$}, $CellContext`line2[{{
              Pattern[$CellContext`x1, 
               Blank[]], 
              Pattern[$CellContext`y1, 
               Blank[]]}, {
              Pattern[$CellContext`x2, 
               Blank[]], 
              Pattern[$CellContext`y2, 
               Blank[]]}}, {
             Pattern[$CellContext`x3, 
              Blank[]], 
             Pattern[$CellContext`x4, 
              Blank[]]}] := 
          Line[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; $CellContext`arrow2[{{
              Pattern[$CellContext`x1, 
               Blank[]], 
              Pattern[$CellContext`y1, 
               Blank[]]}, {
              Pattern[$CellContext`x2, 
               Blank[]], 
              Pattern[$CellContext`y2, 
               Blank[]]}}, {
             Pattern[$CellContext`x3, 
              Blank[]], 
             Pattern[$CellContext`x4, 
              Blank[]]}] := 
          Arrow[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; Graphics[{{Thick, 
             
             Line[{{$CellContext`pleft$, $CellContext`d$$}, \
{$CellContext`pright$, $CellContext`d$$}}], 
             Line[{{$CellContext`pleft$, 0}, {$CellContext`pright$, 0}}], 
             Lighter[Blue, 0.8/($CellContext`nred$$ - 0.13)], 
             
             Polygon[{{$CellContext`pleft$, 
                0}, {$CellContext`pleft$, $CellContext`d$$}, \
{$CellContext`pright$, $CellContext`d$$}, {$CellContext`pright$, 0}}]}, {
            Thick, 
             Darker[Red, 0.4], 
             
             Arrow[{$CellContext`point1$ + (
                 11 - $CellContext`d$$) {-Sin[$CellContext`phi0$], 
                  Cos[$CellContext`phi0$]}, $CellContext`point1$}], 
             
             Arrow[{$CellContext`point1$, {$CellContext`xpoint2$ = 
                Part[$CellContext`point1$, 1] + $CellContext`d$$ 
                  Tan[$CellContext`phi1$ = \
$CellContext`refangle[$CellContext`phi0$, $CellContext`nred$$]], 0}}], 
             $CellContext`arrow2[{{$CellContext`xpoint2$, 
                0}, {$CellContext`xmax = $CellContext`xpoint2$ + 6 Tan[
                    $CellContext`refangle[
                    $CellContext`angle[$CellContext`point1$, \
{$CellContext`xpoint2$, 0}, {$CellContext`xpoint2$, 9}], 
                    1/$CellContext`nred$$]], -6}}, {$CellContext`xpoint2$, 
               If[$CellContext`xmax > 9, 9, $CellContext`xmax]}]}, 
            If[$CellContext`pozn$$, {Thin, Black, 
              Arrowheads[{-0.03, 0.03}], 
              Arrow[{{-8, $CellContext`d$$}, {-8, 0}}], 
              Thickness[0.004], Dashed, 
              Line[{{
                 Part[$CellContext`point1$, 1], 10}, {
                 Part[$CellContext`point1$, 1], (-0.1) $CellContext`d$$}}], 
              
              Line[{{$CellContext`xpoint2$, 
                 0.9 $CellContext`d$$}, {$CellContext`xpoint2$, \
-$CellContext`d$$}}], 
              
              Circle[$CellContext`point1$, 1.7, {
               Pi/2, Pi/2 + $CellContext`phi0$}], 
              Text[
               Style[
               "\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(0\)]\)", 
                Medium], $CellContext`point1$ + 
               2.4 {-Sin[$CellContext`phi0$/2], 
                  Cos[$CellContext`phi0$/2]}], 
              
              Circle[$CellContext`point1$, 1.7, {
               3 (Pi/2), 3 (Pi/2) + $CellContext`phi1$}], 
              Text[
               Style[
               "\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(1\)]\)", 
                Medium], $CellContext`point1$ - 
               2.4 {-Sin[$CellContext`phi1$/2], 
                 Cos[$CellContext`phi1$/2]}], 
              Text[
               Style["d", Medium], {-8.5, $CellContext`d$$/2}], 
              Text[
               Style[
               "\!\(\*SubscriptBox[\(n\), \(1\)]\)", 
                Medium], {-7, $CellContext`d$$ + 1}], 
              Text[
               Style[
               "\!\(\*SubscriptBox[\(n\), \(2\)]\)", 
                Medium], {-7, $CellContext`d$$/2}], 
              Text[
               Style[
               "\!\(\*SubscriptBox[\(n\), \(1\)]\)", 
                Medium], {-7, -1}]}, {}], {Thin, 
             Darker[Red, 0.4], Dashed, 
             $CellContext`line2[{$CellContext`point1$ + (
                 10 - $CellContext`d$$) {-Sin[$CellContext`phi0$], 
                  Cos[$CellContext`phi0$]}, $CellContext`point1$}, {
               Part[$CellContext`point1$, 1], 10}]}, 
            If[$CellContext`pozn$$, {Thin, Black, 
              Arrowheads[{-0.03, 0.03}], 
              If[$CellContext`nred$$ > 1, {
                
                Arrow[{{$CellContext`xpoint3$ = 
                   Part[$CellContext`point1$, 1] + $CellContext`d$$ 
                    Tan[$CellContext`phi0$], 
                   0}, {$CellContext`xpoint3$ - ($CellContext`h = \
($CellContext`xpoint3$ - $CellContext`xpoint2$) Cos[$CellContext`phi0$]) 
                   Cos[$CellContext`phi0$], $CellContext`ypoint4 = \
(-$CellContext`h) Sin[$CellContext`phi0$]}}], 
                Text[
                 Style[
                 "h", Medium], {$CellContext`xpoint3$, 
                  0.8 $CellContext`ypoint4}]}, {
                
                Arrow[{{$CellContext`xpoint2$, 
                   0}, {$CellContext`xpoint2$ - ($CellContext`h = \
($CellContext`xpoint2$ - ($CellContext`xpoint3$ = 
                    Part[$CellContext`point1$, 1] + $CellContext`d$$ 
                    Tan[$CellContext`phi0$])) Cos[$CellContext`phi0$]) 
                   Cos[$CellContext`phi0$], $CellContext`ypoint4 = \
(-$CellContext`h) Sin[$CellContext`phi0$]}}], 
                Text[
                 Style[
                 "h", Medium], {$CellContext`xpoint2$ - 0.5, 
                  0.8 $CellContext`ypoint4}]}]}, {}]}, PlotLabel -> 
           If[$CellContext`pozn$$, 
             Text[
              TraditionalForm[
               Style[
                
                Row[{Subscript[$CellContext`n, 2]/
                  Subscript[$CellContext`n, 1], " = ", 
                  Round[$CellContext`nred$$, 0.01], ", ", 
                  Subscript[$CellContext`\[CurlyPhi], 0], " = ", 
                  Round[$CellContext`phi0$/Degree, 0.1], "\[Degree]", ", ", 
                  Subscript[$CellContext`\[CurlyPhi], 1], " = ", 
                  Round[$CellContext`phi1$/Degree, 0.1], "\[Degree]", "\n", 
                  Style["h", Italic], " = ", 
                  Style["d", Italic], " ", 
                  Cos[
                   Subscript[$CellContext`\[CurlyPhi], 0]], "(", Tan[
                    Subscript[$CellContext`\[CurlyPhi], 0]] - Tan[
                   Subscript[$CellContext`\[CurlyPhi], 1]], ")", " = ", 
                  Round[$CellContext`h, 0.1]}], FontWeight -> Bold, FontSize -> 
                14]]], " "], ImageSize -> {425, 400}, AspectRatio -> 0.85, 
           Axes -> $CellContext`koord$$, PlotRange -> {{-9, 9}, {-6, 10}}, 
           ImagePadding -> {{10, 10}, {0, 40}}, Background -> 
           GrayLevel[0.9]]]), 
      "Specifications" :> {{{$CellContext`nred$$, 1.51106, 
          "\!\(\*SubscriptBox[\(n\), \(2\)]\)/\!\(\*SubscriptBox[\(n\), \
\(1\)]\) "}, 0.8, 2.2, Appearance -> "Labeled", ImageSize -> Small, 
         ControlPlacement -> 1}, {{$CellContext`d$$, 4, "d "}, 0.1, 8, 
         Appearance -> "Labeled", ImageSize -> Small, ControlPlacement -> 
         2}, {{$CellContext`xpoint1$$, -3, "P"}, -7, 0, Appearance -> 
         "Labeled", ImageSize -> Small, ControlPlacement -> 
         3}, {{$CellContext`phi0gr$$, 64, 
          "\!\(\*SubscriptBox[\(\[CurlyPhi]\), \(0\)]\)"}, 0.01, 89.9, 
         Appearance -> "Labeled", ImageSize -> Small, ControlPlacement -> 4}, 
        
        Grid[{{
           Manipulate`Place[1], 
           Manipulate`Place[2]}, {
           Manipulate`Place[3], 
           Manipulate`Place[4]}}], {{$CellContext`pozn$$, True, "notation"}, {
         True, False}, ControlPlacement -> 
         5}, {{$CellContext`koord$$, False, "  axes"}, {True, False}, 
         ControlPlacement -> 6}, 
        Row[{
          Manipulate`Place[5], 
          Manipulate`Place[6], 
          Button[
          "initialize", $CellContext`phi0gr$$ = 64; $CellContext`nred$$ = 
            1.51106; $CellContext`koord$$ = 
            False; $CellContext`xpoint1$$ = -3; $CellContext`d$$ = 
            4; $CellContext`pozn$$ = True]}]}, 
      "Options" :> {TrackedSymbols :> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{470., {263., 268.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->429665889],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "A light ray passes from medium 1 with index of refraction ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 " through a plate with index of refraction ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
 " and continues back out again into medium 1. The path depends on the ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "2"], "/", 
    SubscriptBox["n", "1"]}], TraditionalForm]], "InlineMath"],
 ", the thickness of the plate ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", and the angle of incidence ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Phi]", "0"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Light Ray Passing through a Transparent Plate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LightRayPassingThroughATransparentPlate/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/LightRayPassingThroughATransparentPlate/\
"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
LightRayPassingThroughATransparentPlate/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LightRayPassingThroughATransparentPlate/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/LightRayPassingThroughATransparentPlate/\
"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Volodymyr Holovatsky",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"],
 " (Chernivtsi National University, Ukraine)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
LightRayPassingThroughATransparentPlate"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Light Ray Passing through a Transparent Plate - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[647, 23, 165, 3, 70, "Section"],
Cell[815, 28, 3700, 64, 70, "Section"],
Cell[4518, 94, 31893, 764, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36448, 863, 13939, 289, 70, "Output",
 CellID->429665889],
Cell[CellGroupData[{
Cell[50412, 1156, 209, 6, 70, "Section"],
Cell[50624, 1164, 757, 23, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51429, 1193, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[51787, 1204, 1035, 31, 70, "Text"],
Cell[52825, 1237, 503, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[53353, 1257, 815, 24, 70, "Text"],
Cell[54171, 1283, 1211, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature vQNvbRuD418QACpEn5NwIDgL *)
