(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45555,       1260]
NotebookOptionsPosition[     43284,       1186]
NotebookOutlinePosition[     43952,       1211]
CellTagsIndexPosition[     43909,       1208]
WindowTitle->Laser Lineshape and Frequency Fluctuations: Low-Pass Filtered \
White Noise - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Laser Lineshape and Frequency Fluctuations: Low-Pass Filtered White Noise\
\>", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{
  RowBox[{"fourierSpectrum", "[", 
   RowBox[{"list_List", ",", 
    RowBox[{"SampRate_", "?", "NumberQ"}]}], "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "flist", "}"}], ",", "\n", "    ", 
    RowBox[{
     RowBox[{"flist", "=", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Take", "[", 
         RowBox[{
          RowBox[{"Fourier", "[", "list", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             RowBox[{"IntegerPart", "[", 
              RowBox[{
               RowBox[{"Length", "[", "list", "]"}], "/", "2"}], "]"}], "+", 
             "1"}]}], "}"}]}], "]"}], "]"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2.", "/", 
         RowBox[{"Length", "[", "list", "]"}]}], "]"}]}]}], ";", "\n", "    ", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}], 
           RowBox[{
            RowBox[{"SampRate", "/", "2."}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Length", "[", "flist", "]"}], "-", "1"}], ")"}]}]}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"Length", "[", "flist", "]"}]}], "}"}]}], "]"}], ",", 
        "flist"}], "}"}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellID->105894819],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "h0", ",", "fc", ",", "Npts", ",", "sr", ",", "\[Tau]list", ",", 
        "RElist", ",", "SElist", ",", "amp0", ",", "lf", ",", "FWHM"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h0", "=", 
        SuperscriptBox["10", "logh0"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"fc", "=", 
        SuperscriptBox["10", "logfc"]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Npts", "=", "50"}], ";", "\[IndentingNewLine]", 
       RowBox[{"sr", "=", 
        RowBox[{"0.5", " ", 
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"Npts", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"h0", " ", "fc"}], ")"}], "0.5"]}], ",", 
           RowBox[{"Npts", " ", "h0"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"\[Tau]list", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "/", "sr"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"-", "Npts"}], ",", "Npts"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"RElist", "=", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "h0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                SuperscriptBox[
                 RowBox[{"Sin", "[", 
                  RowBox[{"fc", " ", "\[Pi]", " ", 
                   RowBox[{"Abs", "[", "#", "]"}]}], "]"}], "2"], "fc"]}], 
              "+", 
              RowBox[{"\[Pi]", " ", 
               RowBox[{"Abs", "[", "#", "]"}], " ", 
               RowBox[{"SinIntegral", "[", 
                RowBox[{"2", " ", "fc", " ", "\[Pi]", " ", 
                 RowBox[{"Abs", "[", "#", "]"}]}], "]"}]}]}], ")"}]}]], "&"}],
          "/@", "\[Tau]list"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"SElist", "=", 
        RowBox[{"fourierSpectrum", "[", 
         RowBox[{"RElist", ",", "sr"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"amp0", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", "SElist", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"SElist", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             SuperscriptBox["amp0", 
              RowBox[{"-", "1"}]], 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
         "SElist"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"lf", "=", 
        RowBox[{"Interpolation", "[", "SElist", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHM", "=", 
        RowBox[{
         RowBox[{"2", " ", "x"}], "/.", 
         RowBox[{"(", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"lf", "[", "x", "]"}], "-", "0.5"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0.001", ",", 
              RowBox[{"Max", "[", 
               RowBox[{"First", "/@", "SElist"}], "]"}]}], "}"}]}], "]"}], 
          ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"LogLogPlot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Piecewise", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"h0", ",", 
                    RowBox[{"f", "\[LessEqual]", "fc"}]}], "}"}], "}"}], ",", 
                   
                   SuperscriptBox["10", 
                    RowBox[{"-", "9"}]]}], "]"}], ",", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"8", " ", 
                    RowBox[{"Log", "[", "2", "]"}]}], 
                   SuperscriptBox["\[Pi]", "2"]], "f"}]}], "}"}], " ", ",", 
               RowBox[{"{", 
                RowBox[{"f", ",", "0.1", ",", "1001"}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Filling", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"1", "\[Rule]", "Bottom"}], "}"}]}], ",", 
               RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", 
                  RowBox[{"{", 
                   RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<\!\(\*SubscriptBox[\(f\), \(\[InvisibleSpace]\)]\)  \
[Hz]\>\"", ",", 
                  "\"\<\!\(\*SubscriptBox[\(S\), \(\[Delta]\[InvisibleSpace]\
\[Nu]\)]\)(\!\(\*SubscriptBox[\(f\), \(\[InvisibleSpace]\)]\))  \
[\!\(\*SuperscriptBox[\(Hz\), \(2\)]\)/Hz]\>\"", ",", 
                  "\"\<frequency noise spectral density\>\""}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"GridLinesStyle", "\[Rule]", "LightGray"}], ",", 
               RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0.1", ",", "1000"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0.1", ",", "1000"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"BaseStyle", "\[Rule]", "12"}], ",", 
               RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}], ",", 
             "\[IndentingNewLine]", "SpanFromLeft"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ListLinePlot", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", 
                RowBox[{"{", 
                 RowBox[{"\[Tau]list", ",", "RElist"}], "}"}], "]"}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"Axes", "\[Rule]", "False"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<\[Tau] [s]\>\"", ",", 
                  "\"\<\!\(\*SubscriptBox[\(R\), \(E\)]\)(\[Tau])\>\"", ",", 
                  "\"\<autocorrelation function\>\""}], "}"}]}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"FrameTicks", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"All", ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"BaseStyle", "\[Rule]", "14"}], ",", 
               RowBox[{"ImageSize", "\[Rule]", "275"}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
               RowBox[{"GridLinesStyle", "\[Rule]", "LightGray"}], ",", 
               RowBox[{"GridLines", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", "0.5", "}"}]}], "}"}]}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ListLinePlot", "[", 
              RowBox[{
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"Reverse", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
                   "SElist"}], "]"}], ",", "SElist"}], "]"}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"Axes", "\[Rule]", "False"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<\[Nu]-\!\(\*SubscriptBox[\(\[Nu]\), \(0\)]\) [Hz]\>\"", 
                  ",", "\"\<\!\(\*SubscriptBox[\(S\), \
\(E\)]\)(\[Nu]-\!\(\*SubscriptBox[\(\[Nu]\), \(0\)]\))\>\"", ",", 
                  "\"\<laser lineshape\>\""}], "}"}]}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"FrameTicks", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"All", ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"BaseStyle", "\[Rule]", "14"}], ",", 
               RowBox[{"ImageSize", "\[Rule]", "275"}], ",", 
               "\[IndentingNewLine]", "\t", 
               RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
               RowBox[{"GridLinesStyle", "\[Rule]", "LightGray"}], ",", 
               RowBox[{"GridLines", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", "0.5", "}"}]}], "}"}]}], ",", 
               RowBox[{"Epilog", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1.5"}], "FWHM"}], ",", "0.5"}], "}"}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "0.5"}], "FWHM"}], ",", "0.5"}], "}"}]}], 
                    "}"}], "]"}], ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"1.5", "FWHM"}], ",", "0.5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.5", "FWHM"}], ",", "0.5"}], "}"}]}], "}"}], 
                   "]"}], ",", 
                  RowBox[{"Text", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"FWHM", ",", "2"}], "]"}], "]"}], "<>", 
                    "\"\< Hz\>\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"FWHM", ",", "0.5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}]}], 
              "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
         RowBox[{"Alignment", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Center", ",", "Baseline"}], "}"}]}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "logh0", ",", "1", ",", "\"\<frequency noise level (log scale)\>\""}], 
      "}"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "0.2"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "500"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "logfc", ",", "2", ",", "\"\<cutoff frequency (log scale)\>\""}], "}"}],
      ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "0.2"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "500"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4635449964375*^9, 3.46354526440625*^9, {
   3.46367690478125*^9, 3.463676932203125*^9}, {3.463676969546875*^9, 
   3.463677008*^9}, {3.4636770503125*^9, 3.463677263078125*^9}, {
   3.463677303390625*^9, 3.4636773253125*^9}, 3.463677381140625*^9, {
   3.46367749709375*^9, 3.46367760109375*^9}, {3.4636776470625*^9, 
   3.4636776726875*^9}, {3.463677703265625*^9, 3.4636777224375*^9}, {
   3.46367778175*^9, 3.463677862984375*^9}, 3.4636779050625*^9, {
   3.46367793709375*^9, 3.4636779420625*^9}, {3.463678346671875*^9, 
   3.4636783643125*^9}, 3.463769261958508*^9, {3.4639721367396965`*^9, 
   3.4639721983493347`*^9}, {3.4641167254819713`*^9, 3.464116843449211*^9}, {
   3.464455756093218*^9, 3.4644557596495733`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`logfc$$ = 2, $CellContext`logh0$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`logh0$$], 1, 
       "frequency noise level (log scale)"}, -0.6989700043360187, 
      Log[10]^(-1) Log[500]}, {{
       Hold[$CellContext`logfc$$], 2, 
       "cutoff frequency (log scale)"}, -0.6989700043360187, Log[10]^(-1) 
      Log[500]}}, Typeset`size$$ = {558., {206.5, 211.5}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`logh0$10797$$ = 0, $CellContext`logfc$10798$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`logfc$$ = 2, $CellContext`logh0$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`logh0$$, $CellContext`logh0$10797$$, 0], 
        Hold[$CellContext`logfc$$, $CellContext`logfc$10798$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`h0$, $CellContext`fc$, $CellContext`Npts$, \
$CellContext`sr$, $CellContext`\[Tau]list$, $CellContext`RElist$, \
$CellContext`SElist$, $CellContext`amp0$, $CellContext`lf$, \
$CellContext`FWHM$}, $CellContext`h0$ = 
          10^$CellContext`logh0$$; $CellContext`fc$ = 
          10^$CellContext`logfc$$; $CellContext`Npts$ = 50; $CellContext`sr$ = 
          0.5 Min[$CellContext`Npts$ ($CellContext`h0$ $CellContext`fc$)^0.5, \
$CellContext`Npts$ $CellContext`h0$]; $CellContext`\[Tau]list$ = 
          Table[$CellContext`i/$CellContext`sr$, {$CellContext`i, \
-$CellContext`Npts$, $CellContext`Npts$}]; $CellContext`RElist$ = 
          Map[
           E^((-2) $CellContext`h0$ (-(
                Sin[$CellContext`fc$ Pi Abs[#]]^2/$CellContext`fc$) + 
              Pi Abs[#] 
               SinIntegral[
                2 $CellContext`fc$ Pi 
                 Abs[#]]))& , $CellContext`\[Tau]list$]; $CellContext`SElist$ = \
$CellContext`fourierSpectrum[$CellContext`RElist$, $CellContext`sr$]; \
$CellContext`amp0$ = Max[
            Part[
             Transpose[$CellContext`SElist$], 2]]; $CellContext`SElist$ = Map[{
             Part[#, 1], $CellContext`amp0$^(-1) 
             Part[#, 2]}& , $CellContext`SElist$]; $CellContext`lf$ = 
          Interpolation[$CellContext`SElist$]; $CellContext`FWHM$ = 
          ReplaceAll[2 $CellContext`x, 
            
            FindRoot[$CellContext`lf$[$CellContext`x] - 
             0.5, {$CellContext`x, 0.001, 
              Max[
               Map[First, $CellContext`SElist$]]}]]; Grid[{{
             LogLogPlot[{
               
               Piecewise[{{$CellContext`h0$, $CellContext`f <= \
$CellContext`fc$}}, 10^(-9)], (8 Log[2]/
                Pi^2) $CellContext`f}, {$CellContext`f, 0.1, 1001}, 
              Filling -> {1 -> Bottom}, Exclusions -> None, 
              PlotStyle -> {Automatic, {Red, Dashed}}, Frame -> True, 
              FrameLabel -> {
               "\!\(\*SubscriptBox[\(f\), \(\[InvisibleSpace]\)]\)  [Hz]", 
                "\!\(\*SubscriptBox[\(S\), \
\(\[Delta]\[InvisibleSpace]\[Nu]\)]\)(\!\(\*SubscriptBox[\(f\), \(\
\[InvisibleSpace]\)]\))  [\!\(\*SuperscriptBox[\(Hz\), \(2\)]\)/Hz]", 
                "frequency noise spectral density"}, GridLinesStyle -> 
              LightGray, GridLines -> Automatic, 
              PlotRange -> {{0.1, 1000}, {0.1, 1000}}, BaseStyle -> 12, 
              ImageSize -> 300], SpanFromLeft}, {
             ListLinePlot[
              Transpose[{$CellContext`\[Tau]list$, $CellContext`RElist$}], 
              Axes -> False, Frame -> True, Filling -> Bottom, 
              FrameLabel -> {
               "\[Tau] [s]", "\!\(\*SubscriptBox[\(R\), \(E\)]\)(\[Tau])", 
                "autocorrelation function"}, FrameTicks -> {Automatic, None}, 
              PlotRange -> {All, {0, 1}}, BaseStyle -> 14, ImageSize -> 275, 
              ImagePadding -> 40, GridLinesStyle -> LightGray, 
              GridLines -> {{}, {0.5}}], 
             ListLinePlot[
              Join[
               Reverse[
                Map[{-Part[#, 1], 
                  
                  Part[#, 
                   2]}& , $CellContext`SElist$]], $CellContext`SElist$], Axes -> 
              False, Frame -> True, Filling -> Bottom, 
              FrameLabel -> {
               "\[Nu]-\!\(\*SubscriptBox[\(\[Nu]\), \(0\)]\) [Hz]", 
                "\!\(\*SubscriptBox[\(S\), \(E\)]\)(\[Nu]-\!\(\*SubscriptBox[\
\(\[Nu]\), \(0\)]\))", "laser lineshape"}, FrameTicks -> {Automatic, None}, 
              PlotRange -> {All, {0, 1}}, BaseStyle -> 14, ImageSize -> 275, 
              ImagePadding -> 40, GridLinesStyle -> LightGray, 
              GridLines -> {{}, {0.5}}, Epilog -> {
                
                Arrow[{{(-1.5) $CellContext`FWHM$, 
                   0.5}, {(-0.5) $CellContext`FWHM$, 0.5}}], 
                
                Arrow[{{1.5 $CellContext`FWHM$, 0.5}, {
                  0.5 $CellContext`FWHM$, 0.5}}], 
                Text[
                 StringJoin[
                  ToString[
                   NumberForm[$CellContext`FWHM$, 2]], 
                  " Hz"], {$CellContext`FWHM$, 0.5}, {-1, -1}]}]}}, 
           Alignment -> {Center, Baseline}]]], 
      "Specifications" :> {{{$CellContext`logh0$$, 1, 
          "frequency noise level (log scale)"}, -0.6989700043360187, 
         Log[10]^(-1) 
         Log[500]}, {{$CellContext`logfc$$, 2, 
          "cutoff frequency (log scale)"}, -0.6989700043360187, Log[10]^(-1) 
         Log[500]}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{603., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`fourierSpectrum[
          Pattern[$CellContext`list, 
           Blank[List]], 
          PatternTest[
           Pattern[$CellContext`SampRate, 
            Blank[]], NumberQ]] := 
        Module[{$CellContext`flist}, $CellContext`flist = Abs[
              Take[
               Fourier[$CellContext`list], {
               1, IntegerPart[Length[$CellContext`list]/2] + 1}]] 
            Sqrt[2./Length[$CellContext`list]]; Transpose[{
             Table[($CellContext`n - 1) ($CellContext`SampRate/(
               2. (Length[$CellContext`flist] - 1))), {$CellContext`n, 
               Length[$CellContext`flist]}], $CellContext`flist}]], 
        Attributes[PlotRange] = {ReadProtected}}; Typeset`initDone$$ = True); 
     ReleaseHold[
       HoldComplete[{$CellContext`fourierSpectrum[
           Pattern[$CellContext`list, 
            Blank[List]], 
           PatternTest[
            Pattern[$CellContext`SampRate, 
             Blank[]], NumberQ]] := 
         Module[{$CellContext`flist}, $CellContext`flist = Abs[
               Take[
                Fourier[$CellContext`list], {
                1, IntegerPart[Length[$CellContext`list]/2] + 1}]] 
             Sqrt[2./Length[$CellContext`list]]; Transpose[{
              
              Table[($CellContext`n - 1) (($CellContext`SampRate/2.)/(
                Length[$CellContext`flist] - 1)), {$CellContext`n, 
                Length[$CellContext`flist]}], $CellContext`flist}]]}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->159159200],

Cell[CellGroupData[{

Cell["Caption", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[TextData[{
 "Frequency fluctuations cause the optical field of a real laser to deviate \
from a pure sine wave. Thus the laser is not purely monochromatic, its power \
spectrum showing a broadened lineshape rather than a Dirac delta function. \
The lineshape and linewidth depend on the spectral properties of the \
frequency fluctuations. This Demonstration calculates the lineshape of a \
laser having a constant frequency noise level ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "0"], TraditionalForm]], "InlineMath"],
 " below a cutoff frequency ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "c"], TraditionalForm]], "InlineMath"],
 " but zero above this threshold. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], " ", "\[LessLess]", " ", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 ", the lineshape is Gaussian and the linewidth increases as ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     SubscriptBox["h", "0"], " ", 
     SubscriptBox["f", "c"]}]], TraditionalForm]], "InlineMath"],
 ". When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], "\[LessLess]", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 ", the lineshape becomes Lorentzian and the linewidth is independent of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "c"], TraditionalForm]], "InlineMath"],
 ". These observations lead us to separate the frequency noise spectrum into \
two regions where the effect of noise on the lineshape is radically \
different: 1) the ",
 StyleBox["slow modulation area",
  FontSlant->"Italic"],
 " (left side of the red line) where the noise contributes to the laser \
linewidth, with a Gaussian shape, and 2) the ",
 StyleBox["fast modulation area",
  FontSlant->"Italic"],
 " (right side of the red line) where the noise contributes only to the wings \
of the line, and not to the linewidth, thus transforming the lineshape from \
Gaussian to Lorentzian."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Details", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[TextData[{
 "The calculation of the laser lineshape ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "E"], "(", 
    RowBox[{"\[Nu]", "-", 
     SubscriptBox["\[Nu]", "0"]}], ")"}], TraditionalForm]], "InlineMath"],
 " from the frequency noise spectral density ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", 
     RowBox[{"\[Delta]", "\[InvisibleSpace]", "\[Nu]"}]], "(", "f", ")"}], 
   TraditionalForm]], "InlineMath"],
 " is described in D. S. Elliott, R. Roy, and S. J. Smith, \"Extracavity \
Laser Band-Shape and Bandwidth Modification,\" ",
 StyleBox["Phys. Rev. A",
  FontSlant->"Italic"],
 " ",
 StyleBox["26",
  FontWeight->"Bold"],
 ", 1982 pp. 12\[Dash]18. First, one calculates the autocorrelation function \
of the optical field:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "=", 
    RowBox[{
     OverscriptBox[
      RowBox[{
       RowBox[{"E", "(", "t", ")"}], 
       RowBox[{
        SuperscriptBox["E", "*"], "(", 
        RowBox[{"t", "+", "\[Tau]"}], ")"}]}], "_"], "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        SubscriptBox["E", "0"], "2"], "4"], 
      RowBox[{"exp", "(", 
       RowBox[{
        RowBox[{"-", "2"}], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         RowBox[{
          RowBox[{
           SubscriptBox["S", "\[Delta]\[Nu]"], "[", "f", "]"}], 
          FractionBox[
           SuperscriptBox[
            RowBox[{"sin", "(", 
             RowBox[{"\[Pi]", " ", "f", " ", "\[Tau]"}], ")"}], "2"], 
           SuperscriptBox["f", "2"]], "d", "\[InvisibleSpace]", "f"}]}]}], 
       ")"}]}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell["\<\
Then the lineshape is given by the Fourier transform of the autocorrelation \
function:\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", "E"], "(", 
     RowBox[{"\[Nu]", "-", 
      SubscriptBox["\[Nu]", "0"]}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{"2", 
        RowBox[{"\[Pi]", "(", 
         RowBox[{"\[Nu]", "-", 
          SubscriptBox["\[Nu]", "0"]}], ")"}], "\[Tau]"}], ")"}], " ", 
      RowBox[{
       SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "d", "\[InvisibleSpace]",
       "\[Tau]"}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell["\<\
In the case of a low-pass filtered white noise, that is, for a frequency \
noise spectral density given by\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", "\[Delta]\[Nu]"], "(", "f", ")"}], "=", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        SubscriptBox["h", "0"], 
        RowBox[{
         RowBox[{"if", " ", "f"}], "\[LessEqual]", " ", 
         SubscriptBox["f", "c"]}]},
       {"0", 
        RowBox[{
         RowBox[{"if", " ", "f"}], ">", 
         SubscriptBox["f", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}]}], TraditionalForm]], 
  "InlineMath"],
 " , "
}], "Text"],

Cell["\<\
the first integral is easy to evaluate analytically and one obtains the \
following expression for the autocorrelation function:\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       SubscriptBox["E", "0"], "2"], "4"], 
     RowBox[{"exp", "(", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "h0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"sin", "(", 
             RowBox[{"c", " ", "\[Pi]", " ", "\[Tau]"}], ")"}], "2"], 
           SubscriptBox["f", "c"]]}], "+", 
         RowBox[{"\[Pi]", " ", "\[Tau]", " ", 
          RowBox[{"Si", "(", 
           RowBox[{"2", " ", 
            SubscriptBox["f", "c"], " ", "\[Pi]", " ", "\[Tau]"}], ")"}]}]}], 
        ")"}]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Si", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " is the sine integral. However, it is not possible to obtain an analytical \
expression for the Fourier transform of this expression. Therefore, the laser \
lineshape ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "E"], "(", 
    RowBox[{"\[Nu]", "-", 
     SubscriptBox["\[Nu]", "0"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is evaluated numerically using the discrete Fourier transform. "
}], "Text"],

Cell[TextData[{
 "The red line, separating the frequency noise spectrum into two regions in \
which the effect of noise on the lineshape is radically different, can be \
determined by studying the asymptotic behavior of the two limiting cases ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], " ", "\[LessLess]", " ", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], " ", "\[GreaterGreater]", " ", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 ". It is given by the following equation:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "\[Delta]\[Nu]"], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"log", "(", "2", ")"}]}], 
      SuperscriptBox["\[Pi]", "2"]], "f"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"]
}, Close]],

Cell[TextData[{
 "The calculation of the laser lineshape ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "E"], "(", 
    RowBox[{"\[Nu]", "-", 
     SubscriptBox["\[Nu]", "0"]}], ")"}], TraditionalForm]], "InlineMath"],
 " from the frequency noise spectral density ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", 
     RowBox[{"\[Delta]", "\[InvisibleSpace]", "\[Nu]"}]], "(", "f", ")"}], 
   TraditionalForm]], "InlineMath"],
 " is described in D. S. Elliott, R. Roy, and S. J. Smith, \"Extracavity \
Laser Band-Shape and Bandwidth Modification,\" ",
 StyleBox["Phys. Rev. A",
  FontSlant->"Italic"],
 " ",
 StyleBox["26",
  FontWeight->"Bold"],
 ", 1982 pp. 12\[Dash]18. First, one calculates the autocorrelation function \
of the optical field:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "=", 
    RowBox[{
     OverscriptBox[
      RowBox[{
       RowBox[{"E", "(", "t", ")"}], 
       RowBox[{
        SuperscriptBox["E", "*"], "(", 
        RowBox[{"t", "+", "\[Tau]"}], ")"}]}], "_"], "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        SubscriptBox["E", "0"], "2"], "4"], 
      RowBox[{"exp", "(", 
       RowBox[{
        RowBox[{"-", "2"}], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
         RowBox[{
          RowBox[{
           SubscriptBox["S", "\[Delta]\[Nu]"], "[", "f", "]"}], 
          FractionBox[
           SuperscriptBox[
            RowBox[{"sin", "(", 
             RowBox[{"\[Pi]", " ", "f", " ", "\[Tau]"}], ")"}], "2"], 
           SuperscriptBox["f", "2"]], "d", "\[InvisibleSpace]", "f"}]}]}], 
       ")"}]}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell["\<\
Then the lineshape is given by the Fourier transform of the autocorrelation \
function:\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", "E"], "(", 
     RowBox[{"\[Nu]", "-", 
      SubscriptBox["\[Nu]", "0"]}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{"2", 
        RowBox[{"\[Pi]", "(", 
         RowBox[{"\[Nu]", "-", 
          SubscriptBox["\[Nu]", "0"]}], ")"}], "\[Tau]"}], ")"}], " ", 
      RowBox[{
       SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "d", "\[InvisibleSpace]",
       "\[Tau]"}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell["\<\
In the case of a low-pass filtered white noise, that is, for a frequency \
noise spectral density given by\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", "\[Delta]\[Nu]"], "(", "f", ")"}], "=", 
    RowBox[{"\[Piecewise]", GridBox[{
       {
        SubscriptBox["h", "0"], 
        RowBox[{
         RowBox[{"if", " ", "f"}], "\[LessEqual]", " ", 
         SubscriptBox["f", "c"]}]},
       {"0", 
        RowBox[{
         RowBox[{"if", " ", "f"}], ">", 
         SubscriptBox["f", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}]}], TraditionalForm]], 
  "InlineMath"],
 " , "
}], "Text"],

Cell["\<\
the first integral is easy to evaluate analytically and one obtains the \
following expression for the autocorrelation function:\
\>", "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["R", "E"], "(", "\[Tau]", ")"}], "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       SubscriptBox["E", "0"], "2"], "4"], 
     RowBox[{"exp", "(", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "h0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"sin", "(", 
             RowBox[{"c", " ", "\[Pi]", " ", "\[Tau]"}], ")"}], "2"], 
           SubscriptBox["f", "c"]]}], "+", 
         RowBox[{"\[Pi]", " ", "\[Tau]", " ", 
          RowBox[{"Si", "(", 
           RowBox[{"2", " ", 
            SubscriptBox["f", "c"], " ", "\[Pi]", " ", "\[Tau]"}], ")"}]}]}], 
        ")"}]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ","
}], "Text"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Si", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " is the sine integral. However, it is not possible to obtain an analytical \
expression for the Fourier transform of this expression. Therefore, the laser \
lineshape ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "E"], "(", 
    RowBox[{"\[Nu]", "-", 
     SubscriptBox["\[Nu]", "0"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is evaluated numerically using the discrete Fourier transform. "
}], "Text"],

Cell[TextData[{
 "The red line, separating the frequency noise spectrum into two regions in \
which the effect of noise on the lineshape is radically different, can be \
determined by studying the asymptotic behavior of the two limiting cases ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], " ", "\[LessLess]", " ", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "c"], " ", "\[GreaterGreater]", " ", 
    SubscriptBox["h", "0"]}], TraditionalForm]], "InlineMath"],
 ". It is given by the following equation:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["S", "\[Delta]\[Nu]"], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"log", "(", "2", ")"}]}], 
      SuperscriptBox["\[Pi]", "2"]], "f"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Laser Lineshape and Frequency Fluctuations: Low-Pass Filtered \
White Noise",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Gianni Di Domenico",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Gianni+Di+\
Domenico"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Gianni+Di+Domenico"],\

 " (Universit\[EAcute] de Neuch\[AHat]tel)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
LaserLineshapeAndFrequencyFluctuationsLowPassFilteredWhiteNo"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Laser Lineshape and Frequency Fluctuations: Low-Pass Filtered \
White Noise - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[665, 24, 273, 6, 70, "Section"],
Cell[941, 32, 1481, 44, 70, "Input",
 InitializationCell->True,
 CellID->105894819],
Cell[2425, 78, 13566, 315, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16028, 398, 7888, 157, 70, "Output",
 CellID->159159200],
Cell[CellGroupData[{
Cell[23941, 559, 199, 4, 70, "Section"],
Cell[24143, 565, 1987, 49, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26178, 620, 199, 4, 70, "Section"],
Cell[26380, 626, 790, 24, 70, "Text"],
Cell[27173, 652, 981, 32, 70, "Text"],
Cell[28157, 686, 111, 3, 70, "Text"],
Cell[28271, 691, 616, 20, 70, "Text"],
Cell[28890, 713, 130, 3, 70, "Text"],
Cell[29023, 718, 1047, 32, 70, "Text"],
Cell[30073, 752, 152, 3, 70, "Text"],
Cell[30228, 757, 829, 27, 70, "Text"],
Cell[31060, 786, 562, 16, 70, "Text"],
Cell[31625, 804, 629, 16, 70, "Text"],
Cell[32257, 822, 294, 11, 70, "Text"]
}, Close]],
Cell[32565, 836, 790, 24, 70, "Text"],
Cell[33358, 862, 981, 32, 70, "Text"],
Cell[34342, 896, 111, 3, 70, "Text"],
Cell[34456, 901, 616, 20, 70, "Text"],
Cell[35075, 923, 130, 3, 70, "Text"],
Cell[35208, 928, 1047, 32, 70, "Text"],
Cell[36258, 962, 152, 3, 70, "Text"],
Cell[36413, 967, 829, 27, 70, "Text"],
Cell[37245, 996, 562, 16, 70, "Text"],
Cell[37810, 1014, 629, 16, 70, "Text"],
Cell[38442, 1032, 294, 11, 70, "Text"],
Cell[CellGroupData[{
Cell[38761, 1047, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[39137, 1058, 1170, 32, 70, "Text"],
Cell[40310, 1092, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[40650, 1103, 495, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[41170, 1123, 847, 24, 70, "Text"],
Cell[42020, 1149, 1236, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 9QzHakcdd24YAC0YVFC7IQG# *)
