(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20164,        507]
NotebookOptionsPosition[     19000,        462]
NotebookOutlinePosition[     19641,        487]
CellTagsIndexPosition[     19598,        484]
WindowTitle->Huygens's Principle - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Huygens's Principle", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", ".005", "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"pattern", "==", "\"\<plane\>\""}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}], "[", 
              FractionBox[
               RowBox[{"n", "+", 
                RowBox[{"Mod", "[", 
                 RowBox[{"t", ",", "2"}], "]"}]}], "10"], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "0"}], "}"}], ",", 
               RowBox[{"n", "+", 
                RowBox[{"Mod", "[", 
                 RowBox[{"t", ",", "2"}], "]"}]}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "t", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", 
             RowBox[{
              RowBox[{"2", "sources"}], "-", "2"}], ",", "2"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}], "[", 
              FractionBox[
               RowBox[{"n", "+", 
                RowBox[{"Mod", "[", 
                 RowBox[{"t", ",", "2"}], "]"}]}], "10"], "]"}], ",", 
             RowBox[{"Circle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "+", "1"}], ")"}], 
                   RowBox[{"\[Pi]", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "sources"}], ")"}]}]}], "]"}], ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "+", "1"}], ")"}], 
                   RowBox[{"\[Pi]", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "sources"}], ")"}]}]}], "]"}]}], "}"}], ",", 
               
               RowBox[{"n", "+", 
                RowBox[{"Mod", "[", 
                 RowBox[{"t", ",", "2"}], "]"}]}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "t", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", 
             RowBox[{
              RowBox[{"2", "sources"}], "-", "2"}], ",", "2"}], "}"}]}], 
          "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"pattern", "==", "\"\<plane\>\""}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", 
            RowBox[{
             RowBox[{"2", "sources"}], "-", "2", "+", "5"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "sources"}], "+", "2", "-", ".5"}], ",", 
            RowBox[{
             RowBox[{"2", "sources"}], "-", "2", "+", ".5"}]}], "}"}]}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".5"}], ",", 
          RowBox[{
           RowBox[{"2", "sources"}], "+", ".5"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "350"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "8.15", ",", "\"\<time\>\""}], "}"}], ",", "0", ",", 
     "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sources", ",", "5"}], "}"}], ",", "1", ",", "10", ",", "1", 
     ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"pattern", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<plane\>\"", ",", "\"\<circular\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.431466055865809*^9, 3.4314660881253023`*^9}, {
   3.441139666250978*^9, 3.441139690550873*^9}, {3.441139723784009*^9, 
   3.441139743272818*^9}, {3.441139872950594*^9, 3.441139910348729*^9}, 
   3.44114688333593*^9, {3.4411476938439093`*^9, 3.441147715700074*^9}, {
   3.443808372209195*^9, 3.44380842770251*^9}, {3.443808465650393*^9, 
   3.443808517188253*^9}, {3.443808558624322*^9, 3.443808559123003*^9}, {
   3.443808619863881*^9, 3.443808632061254*^9}, {3.443808719628636*^9, 
   3.4438088500525827`*^9}, {3.443808914237818*^9, 3.443808980091743*^9}, {
   3.443809010644712*^9, 3.443809038762521*^9}, {3.443809231236206*^9, 
   3.4438092322794237`*^9}, 3.443809282799932*^9, {3.443809353696457*^9, 
   3.443809410291965*^9}, {3.443809563564925*^9, 3.4438096804716043`*^9}, {
   3.4438099171516438`*^9, 3.443809928327551*^9}, {3.4438099787086563`*^9, 
   3.443809992684804*^9}, {3.443810037530834*^9, 3.4438100587081347`*^9}, {
   3.443810099616832*^9, 3.443810100125458*^9}, {3.443810148018149*^9, 
   3.4438101574076366`*^9}, {3.44381022752242*^9, 3.443810230081778*^9}, {
   3.44381026756618*^9, 3.443810291436064*^9}, 3.443810338191867*^9, {
   3.4438103873140707`*^9, 3.4438103903556957`*^9}, {3.443810496625031*^9, 
   3.443810498667943*^9}, {3.4438105699845943`*^9, 3.443810593521764*^9}, {
   3.443810751664278*^9, 3.443810763156376*^9}, {3.443810966927087*^9, 
   3.4438109736833763`*^9}, {3.44381110908284*^9, 3.443811158978052*^9}, {
   3.443811194253581*^9, 3.443811195656061*^9}, {3.4438112960325603`*^9, 
   3.443811298750895*^9}, {3.4438113690847063`*^9, 3.443811369625342*^9}, {
   3.443811485471599*^9, 3.443811486050465*^9}, {3.4438123403318863`*^9, 
   3.443812383994524*^9}, {3.4438124142490463`*^9, 3.4438124365044107`*^9}, {
   3.4438126761944857`*^9, 3.443812742802619*^9}, 3.443812802615424*^9, {
   3.443812875825189*^9, 3.443812881183074*^9}, {3.443812919341117*^9, 
   3.443812952266471*^9}, {3.443813084234683*^9, 3.443813104367269*^9}, {
   3.4438178509335527`*^9, 3.443817872547872*^9}, {3.443818020651341*^9, 
   3.443818032757125*^9}, {3.443818758517076*^9, 3.443818765219161*^9}, {
   3.443818801672296*^9, 3.443818817441811*^9}, {3.4438194905385103`*^9, 
   3.4438195356691093`*^9}, {3.443819571515167*^9, 3.443819581829211*^9}, {
   3.443819624413707*^9, 3.4438196825923853`*^9}, {3.44381976493121*^9, 
   3.443819784081305*^9}, 3.4439000579317164`*^9, {3.4439000944773703`*^9, 
   3.4439001087818007`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pattern$$ = 
    "circular", $CellContext`sources$$ = 8, $CellContext`t$$ = 
    6.1000000000000005`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 8.15, "time"}, 0, 20}, {{
       Hold[$CellContext`sources$$], 5}, 1, 10, 1}, {
      Hold[$CellContext`pattern$$], {"plane", "circular"}}}, 
    Typeset`size$$ = {500., {173., 177.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$15479$$ = 0, $CellContext`sources$15480$$ = 
    0, $CellContext`pattern$15481$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pattern$$ = 
        "plane", $CellContext`sources$$ = 5, $CellContext`t$$ = 8.15}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$15479$$, 0], 
        Hold[$CellContext`sources$$, $CellContext`sources$15480$$, 0], 
        Hold[$CellContext`pattern$$, $CellContext`pattern$15481$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Thickness[0.005], 
         If[$CellContext`pattern$$ == "plane", 
          Table[{
            ColorData[
            "SouthwestColors"][($CellContext`n + Mod[$CellContext`t$$, 2])/
             10], 
            
            Circle[{$CellContext`x, 0}, $CellContext`n + 
             Mod[$CellContext`t$$, 2]]}, {$CellContext`n, 0, $CellContext`t$$,
             2}, {$CellContext`x, 0, 2 $CellContext`sources$$ - 2, 2}], 
          Table[{
            ColorData[
            "SouthwestColors"][($CellContext`n + Mod[$CellContext`t$$, 2])/
             10], 
            Circle[{
              Cos[($CellContext`x + 1) (Pi/(2 $CellContext`sources$$))], 
              
              Sin[($CellContext`x + 1) (Pi/(
                2 $CellContext`sources$$))]}, $CellContext`n + 
             Mod[$CellContext`t$$, 2]]}, {$CellContext`n, 0, $CellContext`t$$,
             2}, {$CellContext`x, 0, 2 $CellContext`sources$$ - 2, 2}]]}, 
        PlotRange -> {
          
          If[$CellContext`pattern$$ == 
           "plane", {-5, 2 $CellContext`sources$$ - 2 + 
            5}, {(-2) $CellContext`sources$$ + 2 - 0.5, 
            2 $CellContext`sources$$ - 2 + 0.5}], {-0.5, 
           2 $CellContext`sources$$ + 0.5}}, ImageSize -> {500, 350}], 
      "Specifications" :> {{{$CellContext`t$$, 8.15, "time"}, 0, 
         20}, {{$CellContext`sources$$, 5}, 1, 10, 1, Appearance -> 
         "Labeled"}, {$CellContext`pattern$$, {"plane", "circular"}}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {243., 248.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->166852584],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The Huygens principle states that every point of a wave front at any instant \
may be considered a source of spherical secondary wavelets with a speed equal \
to the speed of the the overall wave. Basic wave phenomena like refraction \
and diffraction can be explained using this principle.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Huygens's Principle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/HuygenssPrinciple/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/HuygenssPrinciple/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/HuygenssPrinciple/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/HuygenssPrinciple/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/HuygenssPrinciple/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
HuygenssPrinciple"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Huygens's Principle - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[621, 23, 139, 3, 70, "Section"],
Cell[763, 28, 3700, 64, 70, "Section"],
Cell[4466, 94, 6742, 152, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11245, 251, 3418, 70, 70, "Output",
 CellID->166852584],
Cell[CellGroupData[{
Cell[14688, 325, 209, 6, 70, "Section"],
Cell[14900, 333, 314, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15262, 344, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[15620, 355, 881, 24, 70, "Text"],
Cell[16504, 381, 436, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[16965, 399, 815, 24, 70, "Text"],
Cell[17783, 425, 1189, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature iR4zUpmvesLq5B0IWgzTPR@C *)
