(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     48775,       1215]
NotebookOptionsPosition[     47052,       1152]
NotebookOutlinePosition[     47721,       1177]
CellTagsIndexPosition[     47678,       1174]
WindowTitle->Comparing Fourier Series and Fourier Transform - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Comparing Fourier Series and Fourier Transform", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rect", "[", 
   RowBox[{"x_", ",", "amp_", ",", "per_", ",", "off_"}], "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"amp", "+", "off"}], ",", 
       RowBox[{"0", "\[LessEqual]", 
        RowBox[{"Mod", "[", 
         RowBox[{"x", ",", "per"}], "]"}], "<", 
        FractionBox["per", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "amp"}], "+", "off"}], ",", 
       RowBox[{
        FractionBox["per", "2"], "\[LessEqual]", 
        RowBox[{"Mod", "[", 
         RowBox[{"x", ",", "per"}], "]"}], "<", "per"}]}], "}"}]}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tria", "[", 
   RowBox[{"x_", ",", "amp_", ",", "per_", ",", "off_"}], "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "amp", "*", 
          FractionBox[
           RowBox[{"per", "-", 
            RowBox[{"Mod", "[", 
             RowBox[{
              RowBox[{"x", "-", 
               FractionBox["per", "4"]}], ",", "per"}], "]"}]}], "per"]}], 
         "-", 
         RowBox[{"3", "amp"}], "+", "off"}], ")"}], ",", 
       RowBox[{"0", "\[LessEqual]", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"x", "-", 
           FractionBox["per", "4"]}], ",", "per"}], "]"}], "<", 
        FractionBox["per", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", "amp", "*", 
          FractionBox[
           RowBox[{"Mod", "[", 
            RowBox[{
             RowBox[{"x", "-", 
              FractionBox["per", "4"]}], ",", "per"}], "]"}], "per"]}], "-", 
         RowBox[{"3", "amp"}], "+", "off"}], ")"}], ",", 
       RowBox[{
        FractionBox["per", "2"], "\[LessEqual]", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"x", "-", 
           FractionBox["per", "4"]}], ",", "per"}], "]"}], "<", "per"}]}], 
      "}"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sin", "[", 
   RowBox[{"x_", ",", "amp_", ",", "per_", ",", "off_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"amp", "*", "x"}], ")"}], "*", 
     FractionBox["per", 
      RowBox[{"2", "\[Pi]"}]]}], "]"}], "+", "off"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133521603500032`*^9, 3.5133521642562532`*^9}, {
   3.5133558664281282`*^9, 3.5133558921781282`*^9}, {3.5133578726156282`*^9, 
   3.5133578829281282`*^9}, {3.5133658586000032`*^9, 
   3.5133658926156282`*^9}, {3.5133698496000032`*^9, 3.5133698507093782`*^9}},
 
 CellID->427735805],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ao", "[", 
   RowBox[{"func_", ",", "per_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "per"], 
    RowBox[{"func", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"an", "[", 
   RowBox[{"func_", ",", "per_", ",", "n_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "\[Pi]"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "per"], 
    RowBox[{"func", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"n", "*", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bn", "[", 
   RowBox[{"func_", ",", "per_", ",", "n_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "\[Pi]"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "per"], 
    RowBox[{"func", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"n", "*", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133525960531282`*^9, 3.5133525986312532`*^9}},
 CellID->476037277],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ao", "[", 
   RowBox[{"func_", ",", "per_"}], "]"}], ":=", 
  RowBox[{"ao", "[", 
   RowBox[{"func", ",", "per"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"An", "[", 
   RowBox[{"func_", ",", "per_", ",", "n_"}], "]"}], ":=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"an", "[", 
      RowBox[{"func", ",", "per", ",", "n"}], "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"bn", "[", 
      RowBox[{"func", ",", "per", ",", "n"}], "]"}], "2"]}]]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133603700218782`*^9, 3.5133604055218782`*^9}, {
   3.5133604450062532`*^9, 3.5133604837250032`*^9}, {3.5133605278968782`*^9, 
   3.5133605903187532`*^9}},
 CellID->741820790],

Cell[BoxData[
 RowBox[{
  RowBox[{"phA", "[", 
   RowBox[{"func_", ",", "per_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Arg", "[", 
   RowBox[{
    RowBox[{"bn", "[", 
     RowBox[{"func", ",", "per", ",", "n"}], "]"}], "+", 
    RowBox[{"\[ImaginaryJ]", "*", 
     RowBox[{"an", "[", 
      RowBox[{"func", ",", "per", ",", "n"}], "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133645570375032`*^9, 3.5133646026312532`*^9}, {
   3.5133655632562532`*^9, 3.5133655738812532`*^9}},
 CellID->143658254],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"func_", ",", "per_", ",", "x_", ",", "lim_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ao", "[", 
    RowBox[{"func", ",", "per"}], "]"}], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "1"}], "lim"], 
    RowBox[{
     RowBox[{"an", "[", 
      RowBox[{"func", ",", "per", ",", "n"}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"n", "*", "x"}], "]"}]}]}], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "1"}], "lim"], 
    RowBox[{
     RowBox[{"bn", "[", 
      RowBox[{"func", ",", "per", ",", "n"}], "]"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"n", "*", "x"}], "]"}]}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133530458656282`*^9, 3.5133530500218782`*^9}, 
   3.5133599371312532`*^9, 3.5133600959593782`*^9},
 CellID->449804097],

Cell[BoxData[
 RowBox[{
  RowBox[{"X", "[", 
   RowBox[{"func_", ",", "per_", ",", "\[Omega]_"}], "]"}], ":=", 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", 
     FractionBox["per", "2"]}], 
    FractionBox["per", "2"]], 
   RowBox[{"func", "*", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryJ]"}], "*", "\[Omega]", "*", "x"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.5133668077406282`*^9, 3.5133668219593782`*^9}, {
   3.5133674849593782`*^9, 3.5133675295218782`*^9}},
 CellID->522323752],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"four", ",", "abs", ",", "pha", ",", "fourtrans", ",", "phx"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"four", "=", 
       RowBox[{"h", "[", 
        RowBox[{"func", ",", 
         RowBox[{"2", "\[Pi]"}], ",", "x", ",", "deg"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"abs", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"ao", "[", 
             RowBox[{"func", ",", 
              RowBox[{"2", "\[Pi]"}]}], "]"}]}], "}"}], "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"An", "[", 
              RowBox[{"func", ",", 
               RowBox[{"2", "\[Pi]"}], ",", "n"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "1", ",", "deg"}], "}"}]}], "]"}]}], "]"}]}], 
      ";", 
      RowBox[{"pha", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"n", ",", 
           FractionBox[
            RowBox[{"180", "*", 
             RowBox[{"phA", "[", 
              RowBox[{"func", ",", 
               RowBox[{"2", "\[Pi]"}], ",", "n"}], "]"}]}], 
            RowBox[{"2", "\[Pi]"}]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "1", ",", "deg"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fourtrans", "=", 
       RowBox[{"X", "[", 
        RowBox[{"func", ",", 
         RowBox[{"2", "\[Pi]"}], ",", "\[Omega]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"phx", "=", 
       FractionBox[
        RowBox[{"180", "*", 
         RowBox[{"Arg", "[", "fourtrans", "]"}]}], 
        RowBox[{"2", "\[Pi]"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
       "ctrl", ",", "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
        RowBox[{"Column", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot", "[", 
            RowBox[{"four", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"-", "2"}], "\[Pi]"}], ",", 
               RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Plot", "[", 
            RowBox[{
             RowBox[{"Piecewise", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"x", "<", 
                   RowBox[{"-", "\[Pi]"}]}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"func", ",", 
                  RowBox[{
                   RowBox[{"-", "\[Pi]"}], "<", "x", "<", "\[Pi]"}]}], "}"}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"x", ">", "\[Pi]"}]}], "}"}]}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"-", "2"}], "\[Pi]"}], ",", 
               RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
        "2", ",", "\[IndentingNewLine]", 
        RowBox[{"Column", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ListPlot", "[", 
            RowBox[{"abs", ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "0.1"}], ",", "1.5"}], "}"}]}], ",", 
             RowBox[{"Joined", "\[Rule]", "False"}], ",", 
             RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
             RowBox[{"Frame", "\[Rule]", "True"}], ",", 
             RowBox[{"Axes", "\[Rule]", "True"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<harmonic\>\"", ",", " ", 
                  "\"\<Fourier Series Spectrum\>\""}], "}"}]}], "}"}]}], ",", 
             
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
             RowBox[{"PlotRangeClipping", "\[Rule]", "True"}], ",", 
             RowBox[{"AspectRatio", "\[Rule]", "0.4"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Plot", "[", 
            RowBox[{
             RowBox[{"Abs", "[", "fourtrans", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Omega]", ",", "0", ",", "deg"}], "}"}], ",", 
             RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
             RowBox[{"Frame", "\[Rule]", "True"}], ",", 
             RowBox[{"Axes", "\[Rule]", "True"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<harmonic\>\"", ",", " ", 
                  "\"\<Fourier Transform Spectrum\>\""}], "}"}]}], "}"}]}], 
             ",", 
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
             RowBox[{"PlotRangeClipping", "\[Rule]", "True"}], ",", 
             RowBox[{"AspectRatio", "\[Rule]", "0.4"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", 
        "3", ",", "\[IndentingNewLine]", 
        RowBox[{"Column", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ListPlot", "[", 
            RowBox[{"pha", ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "180"}], ",", "180"}], "}"}]}], ",", 
             RowBox[{"Joined", "\[Rule]", "False"}], ",", 
             RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
             RowBox[{"Frame", "\[Rule]", "True"}], ",", 
             RowBox[{"Axes", "\[Rule]", "True"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<harmonic\>\"", ",", " ", 
                  "\"\<Fourier Series Phase\>\""}], "}"}]}], "}"}]}], ",", 
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
             RowBox[{"PlotRangeClipping", "\[Rule]", "True"}], ",", 
             RowBox[{"AspectRatio", "\[Rule]", "0.4"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Plot", "[", 
            RowBox[{"phx", ",", 
             RowBox[{"{", 
              RowBox[{"\[Omega]", ",", "1", ",", "deg"}], "}"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "180"}], ",", "180"}], "}"}]}], ",", 
             RowBox[{"Frame", "\[Rule]", "True"}], ",", 
             RowBox[{"Axes", "\[Rule]", "True"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"None", ",", "None"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<harmonic\>\"", ",", " ", 
                  "\"\<Fourier Transform Phase\>\""}], "}"}]}], "}"}]}], ",", 
             
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
             RowBox[{"PlotRangeClipping", "\[Rule]", "True"}], ",", 
             RowBox[{"AspectRatio", "\[Rule]", "0.4"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"350", ",", "200"}], "}"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], "]"}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ctrl", ",", "1", ",", "\"\<\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<wave\>\""}], ",", 
       RowBox[{"2", "\[Rule]", "\"\<spectrum\>\""}], ",", 
       RowBox[{"3", "\[Rule]", "\"\<phase\>\""}]}], "}"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"func", ",", 
       RowBox[{"sin", "[", 
        RowBox[{"x", ",", "1", ",", 
         RowBox[{"2", "\[Pi]"}], ",", "0"}], "]"}], ",", "\"\<function\>\""}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"x", ",", "1", ",", 
          RowBox[{"2", "\[Pi]"}], ",", "0"}], "]"}], "\[Rule]", 
        "\"\<sine\>\""}], ",", 
       RowBox[{
        RowBox[{"rect", "[", 
         RowBox[{"x", ",", "1", ",", 
          RowBox[{"2", "\[Pi]"}], ",", "0"}], "]"}], "\[Rule]", 
        "\"\<rectangular\>\""}], ",", 
       RowBox[{
        RowBox[{"tria", "[", 
         RowBox[{"x", ",", "1", ",", 
          RowBox[{"2", "\[Pi]"}], ",", "0"}], "]"}], "\[Rule]", 
        "\"\<triangular\>\""}]}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"deg", ",", "5", ",", "\"\<degree of Fourier series\>\""}], 
      "}"}], ",", 
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"ctrl", ",", "func", ",", "deg"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.5133525309281282`*^9, {3.5133526639906282`*^9, 
   3.5133527049750032`*^9}, 3.5133527404281282`*^9, {3.5133528751156282`*^9, 
   3.5133528788812532`*^9}, {3.5133529440375032`*^9, 
   3.5133529696312532`*^9}, {3.5133531019125032`*^9, 
   3.5133532036312532`*^9}, {3.5133544497562532`*^9, 
   3.5133544810843782`*^9}, {3.5133545791468782`*^9, 
   3.5133545811312532`*^9}, {3.5133546371625032`*^9, 
   3.5133546485062532`*^9}, {3.5133546825531282`*^9, 
   3.5133546946000032`*^9}, {3.5133547254593782`*^9, 
   3.5133547909281282`*^9}, {3.5133548320531282`*^9, 
   3.5133548581625032`*^9}, {3.5133553004593782`*^9, 
   3.5133554675375032`*^9}, {3.5133557486625032`*^9, 
   3.5133557550062532`*^9}, {3.5133606171000032`*^9, 
   3.5133606599906282`*^9}, {3.5133607294437532`*^9, 
   3.5133608482875032`*^9}, {3.5133608788812532`*^9, 
   3.5133610572406282`*^9}, {3.5133610919437532`*^9, 
   3.5133611196468782`*^9}, {3.5133612176312532`*^9, 
   3.5133612243343782`*^9}, {3.5133613170062532`*^9, 
   3.5133613709437532`*^9}, {3.5133614397562532`*^9, 
   3.5133614415531282`*^9}, {3.5133616192875032`*^9, 
   3.5133616356937532`*^9}, {3.5133616690687532`*^9, 
   3.5133616736000032`*^9}, {3.5133617673812532`*^9, 
   3.5133617745687532`*^9}, {3.5133618227875032`*^9, 
   3.5133618381937532`*^9}, {3.5133619293031282`*^9, 
   3.5133619294125032`*^9}, {3.5133620888343782`*^9, 
   3.5133620890062532`*^9}, {3.5133622698031282`*^9, 
   3.5133622770062532`*^9}, {3.5133625156625032`*^9, 
   3.5133626975375032`*^9}, {3.5133635025375032`*^9, 
   3.5133635068031282`*^9}, {3.5133635605531282`*^9, 
   3.5133636357093782`*^9}, {3.5133637461781282`*^9, 
   3.5133637514906282`*^9}, {3.5133638023031282`*^9, 
   3.5133638123031282`*^9}, {3.5133640145375032`*^9, 
   3.5133640689125032`*^9}, {3.5133642069906282`*^9, 
   3.5133642167093782`*^9}, {3.5133644015062532`*^9, 3.5133644223500032`*^9}, 
   3.5133646308968782`*^9, {3.5133653843656282`*^9, 3.5133654840218782`*^9}, {
   3.5133656128812532`*^9, 3.5133656396000032`*^9}, 3.5133656731937532`*^9, {
   3.5133657461625032`*^9, 3.5133657543500032`*^9}, {3.5133657961781282`*^9, 
   3.5133658011312532`*^9}, {3.5133659542718782`*^9, 
   3.5133660039281282`*^9}, {3.5133660654750032`*^9, 
   3.5133661801000032`*^9}, {3.5133662279281282`*^9, 
   3.5133662426312532`*^9}, {3.5133664305062532`*^9, 
   3.5133664336156282`*^9}, {3.5133664700843782`*^9, 3.5133664732875032`*^9}, 
   3.5133665619750032`*^9, {3.5133666152562532`*^9, 3.5133666726781282`*^9}, 
   3.5133667981468782`*^9, {3.5133679173187532`*^9, 3.5133679197250032`*^9}, {
   3.5133679794281282`*^9, 3.5133681540531282`*^9}, {3.5133681898656282`*^9, 
   3.5133682433500032`*^9}, {3.5133683639593782`*^9, 
   3.5133683651468782`*^9}, {3.5133684654125032`*^9, 
   3.5133685105843782`*^9}, {3.5133685866625032`*^9, 3.5133685913343782`*^9}, 
   3.5133686570375032`*^9, {3.5133686884125032`*^9, 3.5133687316625032`*^9}, {
   3.5133688487875032`*^9, 3.5133688489281282`*^9}, {3.5133689572562532`*^9, 
   3.5133689990062532`*^9}, {3.5133690513656282`*^9, 
   3.5133691466625032`*^9}, {3.5133692128656282`*^9, 3.5133692235843782`*^9}, 
   3.5133692962406282`*^9, {3.5133693298812532`*^9, 3.5133693630218782`*^9}, {
   3.5133695639437532`*^9, 3.5133696133343782`*^9}, {3.5133696705218782`*^9, 
   3.5133696923812532`*^9}, {3.5133705440218782`*^9, 
   3.5133705865687532`*^9}, {3.5133707460375032`*^9, 
   3.5133707474593782`*^9}, {3.5133710707093782`*^9, 
   3.5133711230531282`*^9}, {3.5133712191156282`*^9, 
   3.5133712344437532`*^9}, {3.5134340148295217`*^9, 3.513434079711009*^9}, {
   3.513434161360173*^9, 3.5134342071187487`*^9}, {3.513434241982235*^9, 
   3.5134342512821646`*^9}, {3.5134343052095566`*^9, 3.513434312951331*^9}, {
   3.51343445195723*^9, 3.5134344591509495`*^9}, {3.513434580087042*^9, 
   3.5134345932763605`*^9}, {3.5139441695250053`*^9, 3.513944492131263*^9}, {
   3.513944534416491*^9, 3.5139445449555445`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`ctrl$$ = 1, $CellContext`deg$$ = 
    5, $CellContext`func$$ = Sin[$CellContext`x], Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`ctrl$$], 1, ""}, {
      1 -> "wave", 2 -> "spectrum", 3 -> "phase"}}, {{
       Hold[$CellContext`func$$], 
       Sin[$CellContext`x], "function"}, {
      Sin[$CellContext`x] -> "sine", Piecewise[{{1, 
           Inequality[0, LessEqual, 
            Mod[$CellContext`x, 2 Pi], Less, Pi]}, {-1, 
           Inequality[Pi, LessEqual, 
            Mod[$CellContext`x, 2 Pi], Less, 2 Pi]}}, 0] -> "rectangular", 
       Piecewise[{{-3 + (2/Pi) (2 Pi - Mod[
             Rational[-1, 2] Pi + $CellContext`x, 2 Pi]), 
           Inequality[0, LessEqual, 
            Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], Less, 
            Pi]}, {-3 + (2/Pi) Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], 
           Inequality[Pi, LessEqual, 
            Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], Less, 2 Pi]}}, 0] -> 
       "triangular"}}, {{
       Hold[$CellContext`deg$$], 5, "degree of Fourier series"}, {1, 2, 3, 4, 
      5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}}}, 
    Typeset`size$$ = {350., {199.84375, 205.15625}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`ctrl$134253$$ = False, $CellContext`func$134254$$ = 
    False, $CellContext`deg$134255$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`ctrl$$ = 1, $CellContext`deg$$ = 
        5, $CellContext`func$$ = Sin[$CellContext`x]}, "ControllerVariables" :> {
        Hold[$CellContext`ctrl$$, $CellContext`ctrl$134253$$, False], 
        Hold[$CellContext`func$$, $CellContext`func$134254$$, False], 
        Hold[$CellContext`deg$$, $CellContext`deg$134255$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`four$, $CellContext`abs$, $CellContext`pha$, \
$CellContext`fourtrans$, $CellContext`phx$}, $CellContext`four$ = \
$CellContext`h[$CellContext`func$$, 2 
           Pi, $CellContext`x, $CellContext`deg$$]; $CellContext`abs$ = 
         Join[{{0, 
             $CellContext`ao[$CellContext`func$$, 2 Pi]}}, 
           Table[{$CellContext`n, 
             $CellContext`An[$CellContext`func$$, 2 
              Pi, $CellContext`n]}, {$CellContext`n, 
             1, $CellContext`deg$$}]]; $CellContext`pha$ = 
         Table[{$CellContext`n, 
            180 ($CellContext`phA[$CellContext`func$$, 2 Pi, $CellContext`n]/(
             2 Pi))}, {$CellContext`n, 
            1, $CellContext`deg$$}]; $CellContext`fourtrans$ = \
$CellContext`X[$CellContext`func$$, 2 
           Pi, $CellContext`\[Omega]]; $CellContext`phx$ = 
         180 (Arg[$CellContext`fourtrans$]/(2 Pi)); 
        Switch[$CellContext`ctrl$$, 1, 
          Column[{
            
            Plot[$CellContext`four$, {$CellContext`x, (-2) Pi, 4 Pi}, 
             ImageSize -> {350, 200}], 
            Plot[
             
             Piecewise[{{
               0, $CellContext`x < -Pi}, {$CellContext`func$$, -
                 Pi < $CellContext`x < Pi}, {
               0, $CellContext`x > Pi}}], {$CellContext`x, (-2) Pi, 4 Pi}, 
             ImageSize -> {350, 200}]}], 2, 
          Column[{
            
            ListPlot[$CellContext`abs$, PlotRange -> {-0.1, 1.5}, Joined -> 
             False, Filling -> Axis, Frame -> True, Axes -> True, PlotRange -> 
             All, FrameLabel -> {{None, None}, {
               "harmonic", "Fourier Series Spectrum"}}, 
             FrameTicks -> {Automatic, Automatic}, PlotRangeClipping -> True, 
             AspectRatio -> 0.4, ImageSize -> {350, 200}], 
            Plot[
             
             Abs[$CellContext`fourtrans$], {$CellContext`\[Omega], 
              0, $CellContext`deg$$}, Filling -> Axis, Frame -> True, Axes -> 
             True, PlotRange -> All, 
             FrameLabel -> {{None, None}, {
               "harmonic", "Fourier Transform Spectrum"}}, 
             FrameTicks -> {Automatic, Automatic}, PlotRangeClipping -> True, 
             AspectRatio -> 0.4, ImageSize -> {350, 200}]}], 3, 
          Column[{
            
            ListPlot[$CellContext`pha$, PlotRange -> {-180, 180}, Joined -> 
             False, Filling -> Axis, Frame -> True, Axes -> True, PlotRange -> 
             All, FrameLabel -> {{None, None}, {
               "harmonic", "Fourier Series Phase"}}, 
             FrameTicks -> {Automatic, Automatic}, PlotRangeClipping -> True, 
             AspectRatio -> 0.4, ImageSize -> {350, 200}], 
            
            Plot[$CellContext`phx$, {$CellContext`\[Omega], 
              1, $CellContext`deg$$}, PlotRange -> {-180, 180}, Frame -> True,
              Axes -> True, PlotRange -> All, 
             FrameLabel -> {{None, None}, {
               "harmonic", "Fourier Transform Phase"}}, 
             FrameTicks -> {Automatic, Automatic}, PlotRangeClipping -> True, 
             AspectRatio -> 0.4, ImageSize -> {350, 200}]}]]], 
      "Specifications" :> {{{$CellContext`ctrl$$, 1, ""}, {
         1 -> "wave", 2 -> "spectrum", 3 -> "phase"}, ControlPlacement -> 
         Top}, {{$CellContext`func$$, 
          Sin[$CellContext`x], "function"}, {
         Sin[$CellContext`x] -> "sine", Piecewise[{{1, 
              Inequality[0, LessEqual, 
               Mod[$CellContext`x, 2 Pi], Less, Pi]}, {-1, 
              Inequality[Pi, LessEqual, 
               Mod[$CellContext`x, 2 Pi], Less, 2 Pi]}}, 0] -> "rectangular", 
          Piecewise[{{-3 + (2/Pi) (2 Pi - Mod[
                Rational[-1, 2] Pi + $CellContext`x, 2 Pi]), 
              Inequality[0, LessEqual, 
               Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], Less, 
               Pi]}, {-3 + (2/Pi) 
               Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], 
              Inequality[Pi, LessEqual, 
               Mod[Rational[-1, 2] Pi + $CellContext`x, 2 Pi], Less, 2 Pi]}}, 
            0] -> "triangular"}, ControlType -> PopupMenu, ControlPlacement -> 
         Left}, {{$CellContext`deg$$, 5, "degree of Fourier series"}, {1, 2, 
         3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, 
         ControlType -> PopupMenu, ControlPlacement -> Left}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`ctrl$$, $CellContext`func$$, \
$CellContext`deg$$}, SynchronousUpdating -> False}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{596., {244., 249.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`h[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`lim, 
           Blank[]]] := $CellContext`ao[$CellContext`func, $CellContext`per] + 
         Sum[$CellContext`an[$CellContext`func, $CellContext`per, \
$CellContext`n] 
           Cos[$CellContext`n $CellContext`x], {$CellContext`n, 
            1, $CellContext`lim}] + 
         Sum[$CellContext`bn[$CellContext`func, $CellContext`per, \
$CellContext`n] 
           Sin[$CellContext`n $CellContext`x], {$CellContext`n, 
            1, $CellContext`lim}], $CellContext`ao[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]]] := (1/(2 Pi)) 
         Integrate[$CellContext`func, {$CellContext`x, 
            0, $CellContext`per}], $CellContext`an[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := (1/Pi) 
         Integrate[$CellContext`func 
           Cos[$CellContext`n $CellContext`x], {$CellContext`x, 
            0, $CellContext`per}], $CellContext`bn[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := (1/Pi) 
         Integrate[$CellContext`func 
           Sin[$CellContext`n $CellContext`x], {$CellContext`x, 
            0, $CellContext`per}], $CellContext`An[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := 
        Sqrt[$CellContext`an[$CellContext`func, $CellContext`per, \
$CellContext`n]^2 + $CellContext`bn[$CellContext`func, $CellContext`per, \
$CellContext`n]^2], $CellContext`phA[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := 
        Arg[$CellContext`bn[$CellContext`func, $CellContext`per, \
$CellContext`n] + 
          I $CellContext`an[$CellContext`func, $CellContext`per, \
$CellContext`n]], $CellContext`X[
          Pattern[$CellContext`func, 
           Blank[]], 
          Pattern[$CellContext`per, 
           Blank[]], 
          Pattern[$CellContext`\[Omega], 
           Blank[]]] := 
        Integrate[$CellContext`func/
          E^((I $CellContext`\[Omega]) $CellContext`x), {$CellContext`x, \
-($CellContext`per/2), $CellContext`per/2}]}; Typeset`initDone$$ = True); 
     ReleaseHold[
       HoldComplete[{{
          HoldComplete[$CellContext`rect[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`amp, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`off, 
              Blank[]]] := Piecewise[{{$CellContext`amp + $CellContext`off, 
               Inequality[0, LessEqual, 
                Mod[$CellContext`x, $CellContext`per], Less, $CellContext`per/
                2]}, {-$CellContext`amp + $CellContext`off, 
               Inequality[$CellContext`per/2, LessEqual, 
                Mod[$CellContext`x, $CellContext`per], 
                Less, $CellContext`per]}}]], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`tria[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`amp, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`off, 
              Blank[]]] := 
           Piecewise[{{
              4 $CellContext`amp (($CellContext`per - 
                  Mod[$CellContext`x - $CellContext`per/
                   4, $CellContext`per])/$CellContext`per) - 
               3 $CellContext`amp + $CellContext`off, 
               Inequality[0, LessEqual, 
                Mod[$CellContext`x - $CellContext`per/4, $CellContext`per], 
                Less, $CellContext`per/2]}, {
              4 $CellContext`amp (
                 Mod[$CellContext`x - $CellContext`per/
                   4, $CellContext`per]/$CellContext`per) - 
               3 $CellContext`amp + $CellContext`off, 
               Inequality[$CellContext`per/2, LessEqual, 
                Mod[$CellContext`x - $CellContext`per/4, $CellContext`per], 
                Less, $CellContext`per]}}]], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`sin[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`amp, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`off, 
              Blank[]]] := 
           Sin[($CellContext`amp $CellContext`x) ($CellContext`per/(2 
               Pi))] + $CellContext`off]}, {
          HoldComplete[$CellContext`ao[
             Pattern[$CellContext`func, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]]] := (1/(2 Pi)) 
            Integrate[$CellContext`func, {$CellContext`x, 
               0, $CellContext`per}]], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`an[
             Pattern[$CellContext`func, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`n, 
              Blank[]]] := (1/Pi) 
            Integrate[$CellContext`func 
              Cos[$CellContext`n $CellContext`x], {$CellContext`x, 
               0, $CellContext`per}]], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`bn[
             Pattern[$CellContext`func, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`n, 
              Blank[]]] := (1/Pi) 
            Integrate[$CellContext`func 
              Sin[$CellContext`n $CellContext`x], {$CellContext`x, 
               0, $CellContext`per}]]}, {
          HoldComplete[$CellContext`Ao[
             Pattern[$CellContext`func, 
              Blank[]], 
             Pattern[$CellContext`per, 
              
              Blank[]]] := $CellContext`ao[$CellContext`func, \
$CellContext`per]], 
          HoldComplete[Null], 
          HoldComplete[$CellContext`An[
             Pattern[$CellContext`func, 
              Blank[]], 
             Pattern[$CellContext`per, 
              Blank[]], 
             Pattern[$CellContext`n, 
              
              Blank[]]] := ($CellContext`an[$CellContext`func, \
$CellContext`per, $CellContext`n]^2 + $CellContext`bn[$CellContext`func, \
$CellContext`per, $CellContext`n]^2)^Rational[1, 2]]}, $CellContext`phA[
           Pattern[$CellContext`func, 
            Blank[]], 
           Pattern[$CellContext`per, 
            Blank[]], 
           Pattern[$CellContext`n, 
            Blank[]]] := 
         Arg[$CellContext`bn[$CellContext`func, $CellContext`per, \
$CellContext`n] + 
           I $CellContext`an[$CellContext`func, $CellContext`per, \
$CellContext`n]], $CellContext`h[
           Pattern[$CellContext`func, 
            Blank[]], 
           Pattern[$CellContext`per, 
            Blank[]], 
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`lim, 
            Blank[]]] := $CellContext`ao[$CellContext`func, $CellContext`per] + 
          Sum[$CellContext`an[$CellContext`func, $CellContext`per, \
$CellContext`n] 
            Cos[$CellContext`n $CellContext`x], {$CellContext`n, 
             1, $CellContext`lim}] + 
          Sum[$CellContext`bn[$CellContext`func, $CellContext`per, \
$CellContext`n] 
            Sin[$CellContext`n $CellContext`x], {$CellContext`n, 
             1, $CellContext`lim}], $CellContext`X[
           Pattern[$CellContext`func, 
            Blank[]], 
           Pattern[$CellContext`per, 
            Blank[]], 
           Pattern[$CellContext`\[Omega], 
            Blank[]]] := 
         Integrate[$CellContext`func 
           E^((-I) $CellContext`\[Omega] $CellContext`x), {$CellContext`x, \
-($CellContext`per/2), $CellContext`per/2}]}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->753661978],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration shows the differences between the Fourier series and the \
Fourier transform. The Fourier series use the sine-cosine representation. The \
three functions used each have period ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Comparing Fourier Series and Fourier Transform",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ComparingFourierSeriesAndFourierTransform/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
ComparingFourierSeriesAndFourierTransform/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
ComparingFourierSeriesAndFourierTransform/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
ComparingFourierSeriesAndFourierTransform/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
ComparingFourierSeriesAndFourierTransform/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Martin Jungwith",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Martin+\
Jungwith"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Martin+Jungwith"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ComparingFourierSeriesAndFourierTransform"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Comparing Fourier Series and Fourier Transform - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[648, 23, 166, 3, 70, "Section"],
Cell[817, 28, 3700, 64, 70, "Section"],
Cell[4520, 94, 2808, 83, 70, "Input",
 InitializationCell->True,
 CellID->427735805],
Cell[7331, 179, 1161, 36, 70, "Input",
 InitializationCell->True,
 CellID->476037277],
Cell[8495, 217, 777, 22, 70, "Input",
 InitializationCell->True,
 CellID->741820790],
Cell[9275, 241, 554, 15, 70, "Input",
 InitializationCell->True,
 CellID->143658254],
Cell[9832, 258, 911, 27, 70, "Input",
 InitializationCell->True,
 CellID->449804097],
Cell[10746, 287, 638, 18, 70, "Input",
 InitializationCell->True,
 CellID->522323752],
Cell[11387, 307, 15429, 344, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26853, 656, 15659, 345, 70, "Output",
 CellID->753661978],
Cell[CellGroupData[{
Cell[42537, 1005, 209, 6, 70, "Section"],
Cell[42749, 1013, 325, 8, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43122, 1027, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[43480, 1038, 1046, 31, 70, "Text"],
Cell[44529, 1071, 439, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[44993, 1089, 815, 24, 70, "Text"],
Cell[45811, 1115, 1213, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ZQNhWPM5SVFpYCD57yR1W8bA *)
