(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     93548,       2329]
NotebookOptionsPosition[     89739,       2195]
NotebookOutlinePosition[     90447,       2221]
CellTagsIndexPosition[     90404,       2218]
WindowTitle->Cardinal Elements of an Aging Human Eye Model with a \
Gradient-Index Crystalline Lens - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Cardinal Elements of an Aging Human Eye Model with a Gradient-Index \
Crystalline Lens\
\>", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"corneaR1", "=", "7.79"}], ";", 
   RowBox[{"corneaR2", "=", "6.53"}], ";", " ", 
   RowBox[{
    RowBox[{"corneaK1", "[", "edad_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "0.24"}], "+", 
     RowBox[{"0.003", "*", "edad"}]}]}], ";", 
   RowBox[{
    RowBox[{"corneaK2", "[", "edad_", "]"}], ":=", " ", 
    RowBox[{
     RowBox[{"-", "0.006"}], "*", "edad"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569637873075*^9, 3.45356964873245*^9}},
 CellID->34436261],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"corneathickness", "=", "0.579"}], " ", ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.45356965104495*^9, 3.453569659966825*^9}},
 CellID->432427219],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"corneaindex", "[", "lambda_", "]"}], ":=", 
    RowBox[{"1.361594", "+", 
     FractionBox["6009.687", 
      SuperscriptBox["lambda", "2"]], "-", 
     FractionBox["676076000", 
      SuperscriptBox["lambda", "4"]], "+", 
     FractionBox["59084500000000", 
      SuperscriptBox["lambda", "6"]]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4535696647637*^9, 3.45356966604495*^9}},
 CellID->340978535],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"acuosothickness", "[", "edad_", "]"}], ":=", 
    RowBox[{"3.291", "-", 
     RowBox[{"0.01", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569675029325*^9, 3.4535696761387*^9}},
 CellID->129822244],

Cell[BoxData[
 RowBox[{"    ", 
  RowBox[{
   RowBox[{
    RowBox[{"acuosoindex", "[", "lambda_", "]"}], ":=", 
    RowBox[{"1.321631", "+", 
     FractionBox["6070.796", 
      SuperscriptBox["lambda", "2"]], "-", 
     FractionBox["706230500", 
      SuperscriptBox["lambda", "4"]], "+", 
     FractionBox["61478610000000", 
      SuperscriptBox["lambda", "6"]]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569679904325*^9, 3.4535696807637*^9}},
 CellID->17198994],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"lensR1", "[", "edad_", "]"}], ":=", 
    RowBox[{"12.7", "-", 
     RowBox[{"0.058", "*", "edad"}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"lensR2", "[", "edad_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "5.9"}], "+", 
     RowBox[{"0.0015", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569684966825*^9, 3.453569685716825*^9}},
 CellID->623822431],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"lensthickness", "[", "edad_", "]"}], ":=", 
    RowBox[{"2.93", "+", 
     RowBox[{"0.0236", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569691060575*^9, 3.4535696920137*^9}},
 CellID->81929097],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"n0", "[", "lambda_", "]"}], ":=", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "30.121153"}], "*", 
        SuperscriptBox["lambda", "2"]}], 
       RowBox[{
        RowBox[{"-", "19383097"}], "-", 
        SuperscriptBox["lambda", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "0.809941"}], "*", 
        SuperscriptBox["lambda", "2"]}], 
       RowBox[{"17803", "-", 
        SuperscriptBox["lambda", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "156.88487"}], "*", 
        SuperscriptBox["lambda", "2"]}], 
       RowBox[{"107420080", "-", 
        SuperscriptBox["lambda", "2"]}]]}]]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.45356969623245*^9, 3.4535696968262*^9}},
 CellID->41512196],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"n1", "[", "edad_", "]"}], ":=", 
    RowBox[{"0.0394", "-", 
     RowBox[{"0.000355", "*", "edad"}]}]}], ";", "  ", 
   RowBox[{
    RowBox[{"n2", "[", "edad_", "]"}], ":=", 
    RowBox[{"1.238", "-", 
     RowBox[{"0.00561", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569700966825*^9, 3.45356970173245*^9}},
 CellID->233124576],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"n3", "[", "edad_", "]"}], ":=", 
    RowBox[{"0.1092", "-", 
     RowBox[{"0.00077", "*", "edad"}]}]}], ";", " ", 
   RowBox[{
    RowBox[{"n4", "[", "edad_", "]"}], ":=", 
    RowBox[{"0.79", "-", 
     RowBox[{"0.00312", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569705716825*^9, 3.4535697061387*^9}},
 CellID->18409716],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"n5", "[", "edad_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "0.00235"}], "+", 
     RowBox[{"0.0000132", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569709716825*^9, 3.453569710373075*^9}},
 CellID->76418197],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"lensindex", "[", 
     RowBox[{"lambda_", ",", "edad_", ",", "x_", ",", "y_", ",", "z_"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"n0", "[", "lambda", "]"}], "+", 
     RowBox[{
      RowBox[{"n1", "[", "edad", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"n2", "[", "edad", "]"}], "*", "x"}], "]"}], "-", "1"}], 
       ")"}]}], "+", 
     RowBox[{
      RowBox[{"n3", "[", "edad", "]"}], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"n4", "[", "edad", "]"}], "*", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"n5", "[", "edad", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}]}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569714435575*^9, 3.45356971510745*^9}},
 CellID->378426586],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"vitreothickness", "[", "edad_", "]"}], ":=", 
    RowBox[{"16.79", "-", 
     RowBox[{"0.0136", "*", "edad"}]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4535697188262*^9, 3.453569719623075*^9}},
 CellID->51309576],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{
    RowBox[{"vitreoindex", "[", "lambda_", "]"}], ":=", 
    RowBox[{"1.322357", "+", 
     FractionBox["5560.24", 
      SuperscriptBox["lambda", "2"]], "-", 
     FractionBox["581739100", 
      SuperscriptBox["lambda", "4"]], "+", 
     FractionBox["50368100000000", 
      SuperscriptBox["lambda", "6"]]}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569723310575*^9, 3.4535697237012*^9}},
 CellID->135126610],

Cell[BoxData[
 RowBox[{"    ", 
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", 
     RowBox[{"radio_", ",", "nimg_", ",", "nobj_"}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"nimg", "-", "nobj"}], 
          RowBox[{"radio", " ", "nimg"}]]}], ",", 
        RowBox[{"nobj", "/", "nimg"}]}], "}"}]}], "}"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.45356972723245*^9, 3.453569727810575*^9}},
 CellID->157223545],

Cell[BoxData[
 RowBox[{"    ", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "espesor_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "espesor"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569731654325*^9, 3.453569732341825*^9}},
 CellID->80181997],

Cell[BoxData[
 RowBox[{"    ", 
  RowBox[{
   RowBox[{"beta", "[", 
    RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"n5", "[", "edad", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"lensthickness", "[", "edad", "]"}]}], "}"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"lensthickness", "[", "edad", "]"}], "*", 
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", 
         RowBox[{"lensthickness", "[", "edad", "]"}], ",", "0", ",", "0"}], 
        "]"}]}], " ", "-", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"Integrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"n5", "[", "edad", "]"}], "*", 
           RowBox[{"x", "^", "2"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"lensthickness", "[", "edad", "]"}]}], "}"}]}], "]"}], 
        ")"}]}]}], ")"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4535697362637*^9, 3.45356973666995*^9}},
 CellID->551618667],

Cell[BoxData[
 RowBox[{"     ", 
  RowBox[{
   RowBox[{"elemC", "[", 
    RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
   RowBox[{"2", "*", 
    RowBox[{"beta", "[", 
     RowBox[{"lambda", ",", "edad"}], "]"}], "*", " ", 
    RowBox[{"lensthickness", "[", "edad", "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569740216825*^9, 3.4535697408887*^9}},
 CellID->228392252],

Cell[BoxData[
 RowBox[{"     ", 
  RowBox[{
   RowBox[{"elemA", "[", 
    RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"beta", "[", 
      RowBox[{"lambda", ",", "edad"}], "]"}], "*", 
     RowBox[{
      RowBox[{"lensthickness", "[", "edad", "]"}], "^", "2", 
      " "}]}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569748716825*^9, 3.453569749154325*^9}},
 CellID->556813497],

Cell[BoxData[
 RowBox[{"     ", 
  RowBox[{
   RowBox[{"elemB", "[", 
    RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"lensthickness", "[", "edad", "]"}], "/", "2"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", "0", ",", "0", ",", "0"}], "]"}], 
       
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", 
         RowBox[{"lensthickness", "[", "edad", "]"}], ",", "0", ",", "0"}], 
        "]"}]], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"beta", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}], "*", 
        RowBox[{
         RowBox[{"lensthickness", "[", "edad", "]"}], "^", "2"}]}], " ", 
       ")"}]}], ")"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.45356975304495*^9, 3.45356975341995*^9}},
 CellID->4336973],

Cell[BoxData[
 RowBox[{"     ", 
  RowBox[{
   RowBox[{"elemD", "[", 
    RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"lensindex", "[", 
      RowBox[{"lambda", ",", "edad", ",", "0", ",", "0", ",", "0"}], "]"}], 
     RowBox[{"lensindex", "[", 
      RowBox[{"lambda", ",", "edad", ",", 
       RowBox[{"lensthickness", "[", "edad", "]"}], ",", "0", ",", "0"}], 
      "]"}]], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"beta", "[", 
       RowBox[{"lambda", ",", "edad"}], "]"}], "*", 
      RowBox[{
       RowBox[{"lensthickness", "[", "edad", "]"}], "^", "2"}]}], 
     ")"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569758998075*^9, 3.4535697596387*^9}},
 CellID->324266708],

Cell[BoxData[
 RowBox[{"    ", 
  RowBox[{
   RowBox[{
    RowBox[{"FirstOrder", "[", 
     RowBox[{"lambda_", ",", "edad_", ",", "matrix_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "ABCD", ",", "vphp", ",", "vpnp", ",", "vn", ",", "vh", ",", 
        "entpupil", ",", "extpupil", ",", "cristpupilcong", ",", 
        "corneapupilcong", ",", "ent", ",", "ext", ",", "results"}], "}"}], 
      ",", 
      RowBox[{
       RowBox[{"ABCD", "=", "matrix"}], ";", 
       RowBox[{"phip", "=", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"ABCD", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "*", "1000", "*", 
         RowBox[{"vitreoindex", "[", "lambda", "]"}]}]}], ";", 
       RowBox[{"vphp", "=", 
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"ABCD", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
         RowBox[{"ABCD", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
       RowBox[{"vpnp", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ABCD", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
            RowBox[{"Det", "[", "matrix", "]"}]}], ")"}]}], 
         RowBox[{"ABCD", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
       RowBox[{"vh", "=", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ABCD", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], "-", 
           RowBox[{"Det", "[", "matrix", "]"}]}], ")"}], 
         RowBox[{"ABCD", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
       RowBox[{"vn", "=", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ABCD", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], "-", "1"}], ")"}], 
         RowBox[{"ABCD", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
       RowBox[{"corneapupilcong", "=", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"acuosothickness", "[", "edad", "]"}], "]"}], ".", 
         RowBox[{"ABCDcornea", "[", 
          RowBox[{"lambda", ",", "edad"}], "]"}], ".", 
         RowBox[{"T", "[", "ent", "]"}]}]}], " ", ";", 
       RowBox[{"sol", "=", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"corneapupilcong", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
          "ent"}], "]"}]}], ";", " ", 
       RowBox[{"entpupil", "=", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
       RowBox[{"cristpupilcong", "=", 
        RowBox[{
         RowBox[{"T", "[", "ext", "]"}], ".", 
         RowBox[{"ABCDcrist", "[", 
          RowBox[{"lambda", ",", "edad"}], "]"}], ".", 
         RowBox[{"T", "[", "0", "]"}]}]}], "  ", ";", 
       RowBox[{"sol", "=", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"cristpupilcong", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
          "ext"}], "]"}]}], ";", " ", 
       RowBox[{"extpupil", "=", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
       RowBox[{"results", "=", 
        RowBox[{"Text", "@", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Column", "@", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"\"\<\>\"", ",", 
              RowBox[{"\"\<eye ABCD matrix = \>\"", 
               RowBox[{"MatrixForm", "[", "ABCD", "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"\"\<power = \>\"", "<>", 
               RowBox[{"ToString", "[", "phip", "]"}], "<>", "\"\< D\>\""}], 
              ",", 
              RowBox[{
              "\"\<crystalline lens second surface vertex to principal point \
P' = \>\"", "<>", 
               RowBox[{"ToString", "[", "vphp", "]"}], "<>", "\"\< mm\>\""}], 
              ",", 
              RowBox[{
              "\"\<crystalline lens second surface vertex to nodal point N' = \
\>\"", "<>", 
               RowBox[{"ToString", "[", "vpnp", "]"}], "<>", "\"\< mm\>\""}], 
              ",", 
              RowBox[{
              "\"\<distance from crystalline lens second surface vertex to \
exit pupil E' = \>\"", "<>", 
               RowBox[{"ToString", "[", "extpupil", "]"}], "<>", 
               "\"\< mm\>\""}], ",", 
              RowBox[{
              "\"\<cornea first surface vertex to principal point P = \>\"", "<>", 
               RowBox[{"ToString", "[", "vh", "]"}], "<>", "\"\< mm\>\""}], 
              ",", 
              RowBox[{
              "\"\<cornea first surface vertex to nodal point N = \>\"", "<>", 
               RowBox[{"ToString", "[", "vn", "]"}], "<>", "\"\< mm\>\""}], 
              ",", 
              RowBox[{
              "\"\<distance from cornea second surface vertex to entrance \
pupil E = \>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"-", "entpupil"}], "]"}], "<>", "\"\< mm\>\""}]}], 
             "}"}]}], ",", "14"}], "]"}]}]}]}]}], "]"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569778060575*^9, 3.45356977891995*^9}, {
   3.45364537696875*^9, 3.4536453775*^9}, {3.4538079074269648`*^9, 
   3.453807913759598*^9}, {3.4541626408001533`*^9, 3.4541627562733374`*^9}, {
   3.454162798087443*^9, 3.4541627984312057`*^9}, 3.454162829682406*^9, {
   3.454162864746252*^9, 3.4541628691995487`*^9}, {3.454163956725336*^9, 
   3.4541639880986834`*^9}, {3.4548500024859037`*^9, 3.454850011477803*^9}},
 CellID->592568098],

Cell[BoxData[
 RowBox[{"     ", 
  RowBox[{
   RowBox[{
    RowBox[{"ABCDGRIN", "[", 
     RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"elemA", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}], ",", 
        RowBox[{"elemB", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"elemC", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}], ",", 
        RowBox[{"elemD", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}]}], "}"}]}], "}"}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569787654325*^9, 3.453569788498075*^9}},
 CellID->57563046],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ABCDeye", "[", 
     RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{
       RowBox[{"lensR2", "[", "edad", "]"}], ",", 
       RowBox[{"vitreoindex", "[", "lambda", "]"}], ",", 
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", 
         RowBox[{"lensthickness", "[", "edad", "]"}], ",", "0", ",", "0"}], 
        "]"}]}], "]"}], ".", 
     RowBox[{"ABCDGRIN", "[", 
      RowBox[{"lambda", ",", "edad"}], "]"}], " ", ".", 
     RowBox[{"R", "[", 
      RowBox[{
       RowBox[{"lensR1", "[", "edad", "]"}], ",", 
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", "0", ",", "0", ",", "0"}], "]"}], 
       ",", 
       RowBox[{"acuosoindex", "[", "lambda", "]"}]}], "]"}], ".", 
     RowBox[{"T", "[", 
      RowBox[{"acuosothickness", "[", "edad", "]"}], "]"}], ".", 
     RowBox[{"R", "[", 
      RowBox[{"corneaR2", ",", 
       RowBox[{"acuosoindex", "[", "lambda", "]"}], ",", 
       RowBox[{"corneaindex", "[", "lambda", "]"}]}], "]"}], ".", 
     RowBox[{"T", "[", "corneathickness", "]"}], ".", 
     RowBox[{"R", "[", 
      RowBox[{"corneaR1", ",", 
       RowBox[{"corneaindex", "[", "lambda", "]"}], ",", "1"}], "]"}]}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569792748075*^9, 3.4535697932012*^9}},
 CellID->256023326],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ABCDcornea", "[", 
     RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{"corneaR2", ",", 
       RowBox[{"acuosoindex", "[", "lambda", "]"}], ",", 
       RowBox[{"corneaindex", "[", "lambda", "]"}]}], "]"}], ".", 
     RowBox[{"T", "[", "corneathickness", "]"}], ".", 
     RowBox[{"R", "[", 
      RowBox[{"corneaR1", ",", 
       RowBox[{"corneaindex", "[", "lambda", "]"}], ",", "1"}], "]"}]}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569797123075*^9, 3.45356979785745*^9}},
 CellID->126704473],

Cell[BoxData[
 RowBox[{"   ", 
  RowBox[{
   RowBox[{
    RowBox[{"ABCDcrist", "[", 
     RowBox[{"lambda_", ",", "edad_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{
       RowBox[{"lensR2", "[", "edad", "]"}], ",", 
       RowBox[{"vitreoindex", "[", "lambda", "]"}], ",", 
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", 
         RowBox[{"lensthickness", "[", "edad", "]"}], ",", "0", ",", "0"}], 
        "]"}]}], "]"}], ".", 
     RowBox[{"ABCDGRIN", "[", 
      RowBox[{"lambda", ",", "edad"}], "]"}], " ", ".", 
     RowBox[{"R", "[", 
      RowBox[{
       RowBox[{"lensR1", "[", "edad", "]"}], ",", 
       RowBox[{"lensindex", "[", 
        RowBox[{"lambda", ",", "edad", ",", "0", ",", "0", ",", "0"}], "]"}], 
       ",", 
       RowBox[{"acuosoindex", "[", "lambda", "]"}]}], "]"}]}]}], 
   ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569801623075*^9, 3.453569802248075*^9}},
 CellID->97624088],

Cell[BoxData[
 RowBox[{"  ", 
  RowBox[{
   RowBox[{"SchematicEye", "[", 
    RowBox[{"lambda_", ",", "edad_", ",", "matrix_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "irispos", ",", "crist", ",", "cornea", ",", "retina", ",", "Npos", ",",
        "Hpos", ",", "Nprimapos", ",", "Hprimapos", ",", "entpupil", ",", 
       "extpupil", ",", "cristpupilcong", ",", "corneapupilcong", ",", "ent", 
       ",", "ext"}], "}"}], ",", 
     RowBox[{
      RowBox[{"irispos", "=", 
       RowBox[{"corneathickness", "+", 
        RowBox[{"acuosothickness", "[", "edad", "]"}]}]}], ";", 
      RowBox[{"Hpos", "=", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"matrix", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "-", 
          RowBox[{"Det", "[", "matrix", "]"}]}], ")"}], 
        RowBox[{"matrix", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
      RowBox[{"Npos", "=", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"matrix", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "-", "1"}], ")"}], 
        RowBox[{"matrix", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
      RowBox[{"Nprimapos", "=", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"matrix", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
           RowBox[{"Det", "[", "matrix", "]"}]}], ")"}]}], 
        RowBox[{"matrix", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
      RowBox[{"Hprimapos", "=", 
       FractionBox[
        RowBox[{"1", "-", 
         RowBox[{"matrix", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
        RowBox[{"matrix", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}]]}], ";", 
      RowBox[{"corneapupilcong", "=", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"acuosothickness", "[", "edad", "]"}], "]"}], ".", 
        RowBox[{"ABCDcornea", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}], ".", 
        RowBox[{"T", "[", "ent", "]"}]}]}], " ", ";", 
      RowBox[{"sol", "=", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"corneapupilcong", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "ent"}], "]"}]}], ";", " ", 
      RowBox[{"entpupil", "=", 
       RowBox[{
        RowBox[{"-", "1"}], "*", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}]}], ";", 
      RowBox[{"cristpupilcong", "=", 
       RowBox[{
        RowBox[{"T", "[", "ext", "]"}], ".", 
        RowBox[{"ABCDcrist", "[", 
         RowBox[{"lambda", ",", "edad"}], "]"}], ".", 
        RowBox[{"T", "[", "0", "]"}]}]}], "  ", ";", 
      RowBox[{"sol", "=", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"cristpupilcong", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "ext"}], "]"}]}], ";", " ", 
      RowBox[{"extpupil", "=", 
       RowBox[{"sol", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
      RowBox[{"crist", "=", 
       RowBox[{"RegionPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"lensindex", "[", 
            RowBox[{"lambda", ",", "edad", ",", 
             RowBox[{"x", "-", "corneathickness", "-", 
              RowBox[{"acuosothickness", "[", "edad", "]"}]}], ",", "y", ",", 
             "0"}], "]"}], "-", 
           RowBox[{"n0", "[", "lambda", "]"}]}], ">", "0"}], " ", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", 
           RowBox[{
            RowBox[{"lensthickness", "[", "edad", "]"}], "+", "0.025", "+", 
            "corneathickness", "+", 
            RowBox[{"acuosothickness", "[", "edad", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "4.9"}], ",", "4.9"}], "}"}], ",", " ", 
         RowBox[{"AspectRatio", "\[Rule]", " ", "Automatic"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"Lighter", "[", 
             RowBox[{"Blue", ",", ".5"}], "]"}], ",", " ", 
            RowBox[{"Opacity", "[", "0.2", "]"}]}], "]"}]}]}], "]"}]}], " ", 
      ";", 
      RowBox[{"cornea", "=", " ", 
       RowBox[{"RegionPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["y", "2"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"corneaK1", "[", "edad", "]"}]}], ")"}], "*", 
             SuperscriptBox[
              RowBox[{"(", "x", ")"}], "2"]}], "-", 
            RowBox[{"2", " ", "corneaR1", "*", 
             RowBox[{"(", "x", ")"}]}]}], "<", "0"}], " ", "&&", "  ", 
          RowBox[{
           RowBox[{
            SuperscriptBox["y", "2"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"corneaK2", "[", "edad", "]"}]}], ")"}], "*", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"x", "-", "corneathickness"}], ")"}], "2"]}], "-", 
            RowBox[{"2", " ", "corneaR2", "*", 
             RowBox[{"(", 
              RowBox[{"x", "-", "corneathickness"}], ")"}]}]}], ">", "0"}]}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "3.43"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "4.5"}], ",", "4.5"}], "}"}], ",", " ", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"Lighter", "[", 
             RowBox[{"Blue", ",", ".5"}], "]"}], ",", " ", 
            RowBox[{"Opacity", "[", "0.2", "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{"retina", "=", 
       RowBox[{"ContourPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "2"], "+", 
           RowBox[{"1.25", "*", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "-", "23.59"}], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", "12.72", " ", 
            RowBox[{"(", 
             RowBox[{"x", "-", "23.59"}], ")"}]}]}], "\[Equal]", "0"}], " ", 
         ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "20.16", ",", "23.59"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "4.9"}], ",", "4.9"}], "}"}], ",", " ", 
         RowBox[{"AspectRatio", "\[Rule]", " ", "Automatic"}]}], "]"}]}], " ",
       ";", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "0.009", "]"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"entpupil", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"extpupil", "+", 
                   RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                   "corneathickness", "+", 
                   RowBox[{"acuosothickness", "[", "edad", "]"}]}], ",", 
                  "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Hpos", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Npos", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Hprimapos", "+", 
                   RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                   "corneathickness", "+", 
                   RowBox[{"acuosothickness", "[", "edad", "]"}]}], ",", 
                  "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Nprimapos", "+", 
                   RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                   "corneathickness", "+", 
                   RowBox[{"acuosothickness", "[", "edad", "]"}]}], ",", 
                  "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", "\"\<cornea\>\"", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<iris\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"irispos", ",", "6"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<crystalline lens\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", 
               RowBox[{"-", "6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<retina\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"22", ",", 
               RowBox[{"-", "6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<P\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"Hpos", ",", "0.5"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<F'\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"23.09", ",", "0.5"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<N\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"Npos", ",", "0.5"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<E\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"entpupil", ",", 
               RowBox[{"-", "0.6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<E'\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"extpupil", "+", 
                RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                "corneathickness", "+", 
                RowBox[{"acuosothickness", "[", "edad", "]"}], "+", "0.1"}], 
               ",", 
               RowBox[{"-", "0.6"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<P'\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Hprimapos", "+", 
                RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                "corneathickness", "+", 
                RowBox[{"acuosothickness", "[", "edad", "]"}], "+", "0.5"}], 
               ",", "0.5"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<N'\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Nprimapos", "+", 
                RowBox[{"lensthickness", "[", "edad", "]"}], "+", 
                "corneathickness", "+", 
                RowBox[{"acuosothickness", "[", "edad", "]"}], "+", "0.5"}], 
               ",", "0.5"}], "}"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"irispos", ",", 
                 RowBox[{"-", "4"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"irispos", ",", 
                 RowBox[{"-", "3"}]}], "}"}]}], "}"}], "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"irispos", ",", "3"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"irispos", ",", "4"}], "}"}]}], "}"}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"25", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
          "}"}], "]"}], ",", "cornea", ",", "crist", ",", "retina", ",", " ", 
        
        RowBox[{"PlotRange", "\[Rule]", " ", "All"}], ",", " ", 
        RowBox[{"Frame", "\[Rule]", " ", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Schematic Eye\>\"", ",", "Bold", ",", " ", "Medium"}], 
          "]"}]}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Medium", ",", "\"\<Label\>\""}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"400", ",", "250"}], "}"}]}]}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.453569806623075*^9, 3.453569807404325*^9}, {
   3.45357055066995*^9, 3.453570552654325*^9}, {3.453570641529325*^9, 
   3.453570657560575*^9}, {3.453645488359375*^9, 3.453645489609375*^9}, {
   3.453807844347657*^9, 3.453807846580881*^9}, 3.453807917805002*^9, {
   3.4541641353925686`*^9, 3.4541641355643487`*^9}, {3.4541641867744417`*^9, 
   3.454164186977532*^9}, {3.454164288381881*^9, 3.4541642915844526`*^9}, {
   3.4548500226529207`*^9, 3.454850022918947*^9}},
 CellID->783395680],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SchematicEye", "[", 
         RowBox[{"lambda", ",", "edad", ",", 
          RowBox[{"ABCDeye", "[", 
           RowBox[{"lambda", ",", "edad"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Paraxial Data\>\"", ",", " ", "Bold", ",", " ", 
          "\"\<Label\>\""}], "]"}], ",", 
        RowBox[{"Pane", "[", 
         RowBox[{
          RowBox[{"FirstOrder", "[", 
           RowBox[{"lambda", ",", "edad", ",", 
            RowBox[{"ABCDeye", "[", 
             RowBox[{"lambda", ",", "edad"}], "]"}]}], "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"500", ",", "200"}], "}"}]}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", "Center"}], 
     "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"edad", ",", "25", ",", "\"\<age (years)\>\""}], "}"}], ",", 
      "20", ",", "65", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lambda", ",", "555", ",", "\"\<wavelength (nm)\>\""}], "}"}], 
      ",", "400", ",", "700", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], ",",
     "\[IndentingNewLine]", " ", 
    RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4535698176387*^9, {3.453807851799402*^9, 
   3.4538078997641983`*^9}, {3.453807941677389*^9, 3.453807942044426*^9}, {
   3.454162500779152*^9, 3.4541625515623517`*^9}, {3.454162595064022*^9, 
   3.454162596610956*^9}, 3.454163863128339*^9, {3.454864121277011*^9, 
   3.4548641383027134`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`edad$$ = 25, $CellContext`lambda$$ = 555, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`edad$$], 25, "age (years)"}, 20, 65, 1}, {{
       Hold[$CellContext`lambda$$], 555, "wavelength (nm)"}, 400, 700, 1}}, 
    Typeset`size$$ = {500., {233., 238.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`edad$6821$$ = 0, $CellContext`lambda$6822$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`edad$$ = 25, $CellContext`lambda$$ = 555}, 
      "ControllerVariables" :> {
        Hold[$CellContext`edad$$, $CellContext`edad$6821$$, 0], 
        Hold[$CellContext`lambda$$, $CellContext`lambda$6822$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         $CellContext`SchematicEye[$CellContext`lambda$$, $CellContext`edad$$, 
          $CellContext`ABCDeye[$CellContext`lambda$$, $CellContext`edad$$]], 
         Style["Paraxial Data", Bold, "Label"], 
         Pane[
          $CellContext`FirstOrder[$CellContext`lambda$$, $CellContext`edad$$, \

           $CellContext`ABCDeye[$CellContext`lambda$$, $CellContext`edad$$]], 
          ImageSize -> {500, 200}]}, Center], 
      "Specifications" :> {{{$CellContext`edad$$, 25, "age (years)"}, 20, 65, 
         1, Appearance -> 
         "Labeled"}, {{$CellContext`lambda$$, 555, "wavelength (nm)"}, 400, 
         700, 1, Appearance -> "Labeled"}}, 
      "Options" :> {SynchronousUpdating -> False}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {291., 296.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`SchematicEye[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]], 
          Pattern[$CellContext`matrix, 
           Blank[]]] := 
        Module[{$CellContext`irispos, $CellContext`crist, \
$CellContext`cornea, $CellContext`retina, $CellContext`Npos, \
$CellContext`Hpos, $CellContext`Nprimapos, $CellContext`Hprimapos, \
$CellContext`entpupil, $CellContext`extpupil, $CellContext`cristpupilcong, \
$CellContext`corneapupilcong, $CellContext`ent, $CellContext`ext}, \
$CellContext`irispos = $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad]; $CellContext`Hpos = (
             Part[$CellContext`matrix, 2, 2] - Det[$CellContext`matrix])/
            Part[$CellContext`matrix, 2, 1]; $CellContext`Npos = (
             Part[$CellContext`matrix, 2, 2] - 1)/
            Part[$CellContext`matrix, 2, 
             1]; $CellContext`Nprimapos = -((Part[$CellContext`matrix, 1, 1] - 
              Det[$CellContext`matrix])/
             Part[$CellContext`matrix, 2, 1]); $CellContext`Hprimapos = (1 - 
             Part[$CellContext`matrix, 1, 1])/
            Part[$CellContext`matrix, 2, 1]; $CellContext`corneapupilcong = 
           Dot[
             $CellContext`T[
              $CellContext`acuosothickness[$CellContext`edad]], 
             $CellContext`ABCDcornea[$CellContext`lambda, $CellContext`edad], \

             $CellContext`T[$CellContext`ent]]; $CellContext`sol = 
           Solve[Part[$CellContext`corneapupilcong, 1, 2] == 
             0, $CellContext`ent]; $CellContext`entpupil = -
            Part[$CellContext`sol, 1, 1, 2]; $CellContext`cristpupilcong = Dot[
             $CellContext`T[$CellContext`ext], 
             $CellContext`ABCDcrist[$CellContext`lambda, $CellContext`edad], 
             $CellContext`T[0]]; $CellContext`sol = 
           Solve[Part[$CellContext`cristpupilcong, 1, 2] == 
             0, $CellContext`ext]; $CellContext`extpupil = 
           Part[$CellContext`sol, 1, 1, 2]; $CellContext`crist = 
           RegionPlot[$CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, $CellContext`x - $CellContext`corneathickness - \
$CellContext`acuosothickness[$CellContext`edad], $CellContext`y, 
                0] - $CellContext`n0[$CellContext`lambda] > 
             0, {$CellContext`x, 
              0, $CellContext`lensthickness[$CellContext`edad] + 
              0.025 + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad]}, {$CellContext`y, -4.9, 4.9},
              AspectRatio -> Automatic, PlotStyle -> Directive[
               Lighter[Blue, 0.5], 
               Opacity[0.2]]]; $CellContext`cornea = RegionPlot[
             
             And[$CellContext`y^2 + (
                 1 + $CellContext`corneaK1[$CellContext`edad]) \
$CellContext`x^2 - 2 $CellContext`corneaR1 $CellContext`x < 
              0, $CellContext`y^2 + (
                 1 + $CellContext`corneaK2[$CellContext`edad]) \
($CellContext`x - $CellContext`corneathickness)^2 - 
               2 $CellContext`corneaR2 ($CellContext`x - \
$CellContext`corneathickness) > 0], {$CellContext`x, 0, 
              3.43}, {$CellContext`y, -4.5, 4.5}, AspectRatio -> Automatic, 
             PlotStyle -> Directive[
               Lighter[Blue, 0.5], 
               Opacity[0.2]]]; $CellContext`retina = 
           ContourPlot[$CellContext`y^2 + 1.25 ($CellContext`x - 23.59)^2 + 
              2 12.72 ($CellContext`x - 23.59) == 
             0, {$CellContext`x, 20.16, 23.59}, {$CellContext`y, -4.9, 4.9}, 
             AspectRatio -> Automatic]; Show[
            Graphics[{{
               PointSize[0.009], 
               
               Point[{{$CellContext`entpupil, 
                  0}, {$CellContext`extpupil + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 0}, {$CellContext`Hpos, 
                  0}, {$CellContext`Npos, 
                  0}, {$CellContext`Hprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 
                  
                  0}, {$CellContext`Nprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 0}}]}, 
              Text[
               Style["cornea"], {1, -6}], 
              Text["iris", {$CellContext`irispos, 6}], 
              Text["crystalline lens", {6, -6}], 
              Text["retina", {22, -6}], 
              Text["P", {$CellContext`Hpos, 0.5}], 
              Text["F'", {23.09, 0.5}], 
              Text["N", {$CellContext`Npos, 0.5}], 
              Text["E", {$CellContext`entpupil, -0.6}], 
              Text[
              "E'", {$CellContext`extpupil + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.1, -0.6}], 
              Text[
              "P'", {$CellContext`Hprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.5, 0.5}], 
              Text[
              "N'", {$CellContext`Nprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.5, 0.5}], {
               
               Line[{{$CellContext`irispos, -4}, {$CellContext`irispos, \
-3}}]}, {
               
               Line[{{$CellContext`irispos, 3}, {$CellContext`irispos, 
                  4}}]}, {Dashed, 
               
               Line[{{-2, 0}, {25, 
                0}}]}}], $CellContext`cornea, $CellContext`crist, \
$CellContext`retina, PlotRange -> All, Frame -> False, PlotLabel -> 
            Style["Schematic Eye", Bold, Medium], 
            BaseStyle -> {Medium, "Label"}, 
            ImageSize -> {400, 250}]], $CellContext`corneathickness = 
        0.579, $CellContext`acuosothickness[
          Pattern[$CellContext`edad, 
           Blank[]]] := 3.291 - 0.01 $CellContext`edad, $CellContext`T[
          Pattern[$CellContext`espesor, 
           Blank[]]] := {{1, $CellContext`espesor}, {0, 
          1}}, $CellContext`ABCDcornea[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := Dot[
          $CellContext`R[$CellContext`corneaR2, 
           $CellContext`acuosoindex[$CellContext`lambda], 
           $CellContext`corneaindex[$CellContext`lambda]], 
          $CellContext`T[$CellContext`corneathickness], 
          $CellContext`R[$CellContext`corneaR1, 
           $CellContext`corneaindex[$CellContext`lambda], 1]], $CellContext`R[
         
          Pattern[$CellContext`radio, 
           Blank[]], 
          Pattern[$CellContext`nimg, 
           Blank[]], 
          Pattern[$CellContext`nobj, 
           Blank[]]] := {{1, 
          0}, {-(($CellContext`nimg - $CellContext`nobj)/($CellContext`radio \
$CellContext`nimg)), $CellContext`nobj/$CellContext`nimg}}, \
$CellContext`corneaR2 = 6.53, $CellContext`acuosoindex[
          Pattern[$CellContext`lambda, 
           Blank[]]] := 
        1.321631 + 6070.796/$CellContext`lambda^2 - 
         706230500/$CellContext`lambda^4 + 
         61478610000000/$CellContext`lambda^6, $CellContext`corneaindex[
          Pattern[$CellContext`lambda, 
           Blank[]]] := 
        1.361594 + 6009.687/$CellContext`lambda^2 - 
         676076000/$CellContext`lambda^4 + 
         59084500000000/$CellContext`lambda^6, $CellContext`corneaR1 = 
        7.79, $CellContext`sol = {{$CellContext`ext$6698 -> \
-3.5160153095234707`}}, 
        Attributes[$CellContext`ext$6698] = {
         Temporary}, $CellContext`ABCDcrist[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := Dot[
          $CellContext`R[
           $CellContext`lensR2[$CellContext`edad], 
           $CellContext`vitreoindex[$CellContext`lambda], 
           $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
            $CellContext`lensthickness[$CellContext`edad], 0, 0]], 
          $CellContext`ABCDGRIN[$CellContext`lambda, $CellContext`edad], 
          $CellContext`R[
           $CellContext`lensR1[$CellContext`edad], 
           $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 0, 
            0, 0], 
           $CellContext`acuosoindex[$CellContext`lambda]]], \
$CellContext`lensR2[
          Pattern[$CellContext`edad, 
           Blank[]]] := -5.9 + 
         0.0015 $CellContext`edad, $CellContext`vitreoindex[
          Pattern[$CellContext`lambda, 
           Blank[]]] := 
        1.322357 + 5560.24/$CellContext`lambda^2 - 
         581739100/$CellContext`lambda^4 + 
         50368100000000/$CellContext`lambda^6, $CellContext`lensindex[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]], 
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`y, 
           Blank[]], 
          Pattern[$CellContext`z, 
           
           Blank[]]] := $CellContext`n0[$CellContext`lambda] + \
$CellContext`n1[$CellContext`edad] (
           Cos[$CellContext`n2[$CellContext`edad] $CellContext`x] - 
           1) + $CellContext`n3[$CellContext`edad] 
          Sin[$CellContext`n4[$CellContext`edad] $CellContext`x] + \
$CellContext`n5[$CellContext`edad] ($CellContext`z^2 + $CellContext`y^2), \
$CellContext`n0[
          Pattern[$CellContext`lambda, 
           Blank[]]] := 
        Sqrt[1 - (
           30.121153 $CellContext`lambda^2)/(-19383097 - \
$CellContext`lambda^2) - (0.809941 $CellContext`lambda^2)/(
          17803 - $CellContext`lambda^2) - (156.88487 $CellContext`lambda^2)/(
          107420080 - $CellContext`lambda^2)], $CellContext`n1[
          Pattern[$CellContext`edad, 
           Blank[]]] := 0.0394 - 0.000355 $CellContext`edad, $CellContext`n2[
          Pattern[$CellContext`edad, 
           Blank[]]] := 1.238 - 0.00561 $CellContext`edad, $CellContext`n3[
          Pattern[$CellContext`edad, 
           Blank[]]] := 0.1092 - 0.00077 $CellContext`edad, $CellContext`n4[
          Pattern[$CellContext`edad, 
           Blank[]]] := 0.79 - 0.00312 $CellContext`edad, $CellContext`n5[
          Pattern[$CellContext`edad, 
           Blank[]]] := -0.00235 + 
         0.0000132 $CellContext`edad, $CellContext`lensthickness[
          Pattern[$CellContext`edad, 
           Blank[]]] := 2.93 + 0.0236 $CellContext`edad, $CellContext`ABCDGRIN[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := {{
           $CellContext`elemA[$CellContext`lambda, $CellContext`edad], 
           $CellContext`elemB[$CellContext`lambda, $CellContext`edad]}, {
           $CellContext`elemC[$CellContext`lambda, $CellContext`edad], 
           $CellContext`elemD[$CellContext`lambda, $CellContext`edad]}}, \
$CellContext`elemA[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := 
        1 + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2, $CellContext`beta[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := Integrate[
           $CellContext`n5[$CellContext`edad], {$CellContext`x, 0, 
            $CellContext`lensthickness[$CellContext`edad]}]/($CellContext`\
lensthickness[$CellContext`edad] $CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, 
            $CellContext`lensthickness[$CellContext`edad], 0, 0] - 2 
         Integrate[$CellContext`n5[$CellContext`edad] $CellContext`x^2, \
{$CellContext`x, 0, 
            $CellContext`lensthickness[$CellContext`edad]}]), \
$CellContext`elemB[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := ($CellContext`lensthickness[$CellContext`edad]/2) (
          1 + $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
             0, 0, 
             0]/$CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
            $CellContext`lensthickness[$CellContext`edad], 0, 
            0] + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2), $CellContext`elemC[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := 
        2 $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad], $CellContext`elemD[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           
           Blank[]]] := $CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, 0, 0, 
            0]/$CellContext`lensindex[$CellContext`lambda, $CellContext`edad, \

           $CellContext`lensthickness[$CellContext`edad], 0, 
           0] + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2, $CellContext`lensR1[
          Pattern[$CellContext`edad, 
           Blank[]]] := 
        12.7 - 0.058 $CellContext`edad, $CellContext`corneaK1[
          Pattern[$CellContext`edad, 
           Blank[]]] := -0.24 + 0.003 $CellContext`edad, $CellContext`corneaK2[
          Pattern[$CellContext`edad, 
           Blank[]]] := (-0.006) $CellContext`edad, 
        Attributes[PlotRange] = {ReadProtected}, $CellContext`ABCDeye[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]]] := Dot[
          $CellContext`R[
           $CellContext`lensR2[$CellContext`edad], 
           $CellContext`vitreoindex[$CellContext`lambda], 
           $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
            $CellContext`lensthickness[$CellContext`edad], 0, 0]], 
          $CellContext`ABCDGRIN[$CellContext`lambda, $CellContext`edad], 
          $CellContext`R[
           $CellContext`lensR1[$CellContext`edad], 
           $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 0, 
            0, 0], 
           $CellContext`acuosoindex[$CellContext`lambda]], 
          $CellContext`T[
           $CellContext`acuosothickness[$CellContext`edad]], 
          $CellContext`R[$CellContext`corneaR2, 
           $CellContext`acuosoindex[$CellContext`lambda], 
           $CellContext`corneaindex[$CellContext`lambda]], 
          $CellContext`T[$CellContext`corneathickness], 
          $CellContext`R[$CellContext`corneaR1, 
           $CellContext`corneaindex[$CellContext`lambda], 
           1]], $CellContext`FirstOrder[
          Pattern[$CellContext`lambda, 
           Blank[]], 
          Pattern[$CellContext`edad, 
           Blank[]], 
          Pattern[$CellContext`matrix, 
           Blank[]]] := 
        Module[{$CellContext`ABCD, $CellContext`vphp, $CellContext`vpnp, \
$CellContext`vn, $CellContext`vh, $CellContext`entpupil, \
$CellContext`extpupil, $CellContext`cristpupilcong, \
$CellContext`corneapupilcong, $CellContext`ent, $CellContext`ext, \
$CellContext`results}, $CellContext`ABCD = $CellContext`matrix; \
$CellContext`phip = (-Part[$CellContext`ABCD, 2, 1]) 
            1000 $CellContext`vitreoindex[$CellContext`lambda]; \
$CellContext`vphp = (1 - Part[$CellContext`ABCD, 1, 1])/
            Part[$CellContext`ABCD, 2, 
             1]; $CellContext`vpnp = -((Part[$CellContext`ABCD, 1, 1] - 
              Det[$CellContext`matrix])/
             Part[$CellContext`ABCD, 2, 1]); $CellContext`vh = (
             Part[$CellContext`ABCD, 2, 2] - Det[$CellContext`matrix])/
            Part[$CellContext`ABCD, 2, 1]; $CellContext`vn = (
             Part[$CellContext`ABCD, 2, 2] - 1)/
            Part[$CellContext`ABCD, 2, 1]; $CellContext`corneapupilcong = 
           Dot[
             $CellContext`T[
              $CellContext`acuosothickness[$CellContext`edad]], 
             $CellContext`ABCDcornea[$CellContext`lambda, $CellContext`edad], \

             $CellContext`T[$CellContext`ent]]; $CellContext`sol = 
           Solve[Part[$CellContext`corneapupilcong, 1, 2] == 
             0, $CellContext`ent]; $CellContext`entpupil = 
           Part[$CellContext`sol, 1, 1, 2]; $CellContext`cristpupilcong = 
           Dot[
             $CellContext`T[$CellContext`ext], 
             $CellContext`ABCDcrist[$CellContext`lambda, $CellContext`edad], 
             $CellContext`T[0]]; $CellContext`sol = 
           Solve[Part[$CellContext`cristpupilcong, 1, 2] == 
             0, $CellContext`ext]; $CellContext`extpupil = 
           Part[$CellContext`sol, 1, 1, 2]; $CellContext`results = Text[
             Style[
              
              Column[{"", "eye ABCD matrix = " MatrixForm[$CellContext`ABCD], 
                
                StringJoin["power = ", 
                 ToString[$CellContext`phip], " D"], 
                StringJoin[
                "crystalline lens second surface vertex to principal point P' \
= ", 
                 ToString[$CellContext`vphp], " mm"], 
                StringJoin[
                "crystalline lens second surface vertex to nodal point N' = ", 
                 ToString[$CellContext`vpnp], " mm"], 
                StringJoin[
                "distance from crystalline lens second surface vertex to exit \
pupil E' = ", 
                 ToString[$CellContext`extpupil], " mm"], 
                StringJoin[
                "cornea first surface vertex to principal point P = ", 
                 ToString[$CellContext`vh], " mm"], 
                StringJoin[
                "cornea first surface vertex to nodal point N = ", 
                 ToString[$CellContext`vn], " mm"], 
                StringJoin[
                "distance from cornea second surface vertex to entrance pupil \
E = ", 
                 ToString[-$CellContext`entpupil], " mm"]}], 
              14]]], $CellContext`phip = 61.10600593386093}; 
      Typeset`initDone$$ = True); ReleaseHold[
       HoldComplete[{$CellContext`corneaR1 = 7.79; $CellContext`corneaR2 = 
          6.53; $CellContext`corneaK1[
            Pattern[$CellContext`edad, 
             Blank[]]] := -0.24 + 
           0.003 $CellContext`edad; $CellContext`corneaK2[
            Pattern[$CellContext`edad, 
             Blank[]]] := (-0.006) $CellContext`edad; 
         Null, $CellContext`corneathickness = 0.579; 
         Null, $CellContext`corneaindex[
            Pattern[$CellContext`lambda, 
             Blank[]]] := 
          1.361594 + 6009.687/$CellContext`lambda^2 - 
           676076000/$CellContext`lambda^4 + 
           59084500000000/$CellContext`lambda^6; 
         Null, $CellContext`acuosothickness[
            Pattern[$CellContext`edad, 
             Blank[]]] := 3.291 - 0.01 $CellContext`edad; 
         Null, $CellContext`acuosoindex[
            Pattern[$CellContext`lambda, 
             Blank[]]] := 
          1.321631 + 6070.796/$CellContext`lambda^2 - 
           706230500/$CellContext`lambda^4 + 
           61478610000000/$CellContext`lambda^6; Null, $CellContext`lensR1[
            Pattern[$CellContext`edad, 
             Blank[]]] := 
          12.7 - 0.058 $CellContext`edad; $CellContext`lensR2[
            Pattern[$CellContext`edad, 
             Blank[]]] := -5.9 + 0.0015 $CellContext`edad; 
         Null, $CellContext`lensthickness[
            Pattern[$CellContext`edad, 
             Blank[]]] := 2.93 + 0.0236 $CellContext`edad; 
         Null, $CellContext`n0[
            Pattern[$CellContext`lambda, 
             Blank[]]] := (1 - 
            30.121153 $CellContext`lambda^2/(-19383097 - \
$CellContext`lambda^2) - 0.809941 $CellContext`lambda^2/(
            17803 - $CellContext`lambda^2) - 156.88487 $CellContext`lambda^2/(
            107420080 - $CellContext`lambda^2))^Rational[1, 2]; 
         Null, $CellContext`n1[
            Pattern[$CellContext`edad, 
             Blank[]]] := 0.0394 - 0.000355 $CellContext`edad; $CellContext`n2[
            Pattern[$CellContext`edad, 
             Blank[]]] := 1.238 - 0.00561 $CellContext`edad; 
         Null, $CellContext`n3[
            Pattern[$CellContext`edad, 
             Blank[]]] := 
          0.1092 - 0.00077 $CellContext`edad; $CellContext`n4[
            Pattern[$CellContext`edad, 
             Blank[]]] := 0.79 - 0.00312 $CellContext`edad; 
         Null, $CellContext`n5[
            Pattern[$CellContext`edad, 
             Blank[]]] := -0.00235 + 0.0000132 $CellContext`edad; 
         Null, $CellContext`lensindex[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]], 
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`y, 
             Blank[]], 
            Pattern[$CellContext`z, 
             
             Blank[]]] := $CellContext`n0[$CellContext`lambda] + \
$CellContext`n1[$CellContext`edad] (
             Cos[$CellContext`n2[$CellContext`edad] $CellContext`x] - 
             1) + $CellContext`n3[$CellContext`edad] 
            Sin[$CellContext`n4[$CellContext`edad] $CellContext`x] + \
$CellContext`n5[$CellContext`edad] ($CellContext`z^2 + $CellContext`y^2); 
         Null, $CellContext`vitreothickness[
            Pattern[$CellContext`edad, 
             Blank[]]] := 16.79 - 0.0136 $CellContext`edad; 
         Null, $CellContext`vitreoindex[
            Pattern[$CellContext`lambda, 
             Blank[]]] := 
          1.322357 + 5560.24/$CellContext`lambda^2 - 
           581739100/$CellContext`lambda^4 + 
           50368100000000/$CellContext`lambda^6; Null, $CellContext`R[
            Pattern[$CellContext`radio, 
             Blank[]], 
            Pattern[$CellContext`nimg, 
             Blank[]], 
            Pattern[$CellContext`nobj, 
             Blank[]]] := {{1, 
            0}, {-(($CellContext`nimg - \
$CellContext`nobj)/($CellContext`radio $CellContext`nimg)), \
$CellContext`nobj/$CellContext`nimg}}; Null, $CellContext`T[
            Pattern[$CellContext`espesor, 
             Blank[]]] := {{1, $CellContext`espesor}, {0, 1}}; 
         Null, $CellContext`beta[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            Blank[]]] := Integrate[
            $CellContext`n5[$CellContext`edad], {$CellContext`x, 0, 
             $CellContext`lensthickness[$CellContext`edad]}]/($CellContext`\
lensthickness[$CellContext`edad] $CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, 
             $CellContext`lensthickness[$CellContext`edad], 0, 0] - 2 
          Integrate[$CellContext`n5[$CellContext`edad] $CellContext`x^2, \
{$CellContext`x, 0, 
             $CellContext`lensthickness[$CellContext`edad]}]), \
$CellContext`elemC[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            Blank[]]] := 
         2 $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad], $CellContext`elemA[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            Blank[]]] := 
         1 + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2, $CellContext`elemB[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            Blank[]]] := ($CellContext`lensthickness[$CellContext`edad]/2) (
           1 + $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
              0, 0, 0]/$CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, 
             $CellContext`lensthickness[$CellContext`edad], 0, 
             0] + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2), $CellContext`elemD[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            
            Blank[]]] := $CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, 0, 0, 
             0]/$CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
            $CellContext`lensthickness[$CellContext`edad], 0, 
            0] + $CellContext`beta[$CellContext`lambda, $CellContext`edad] \
$CellContext`lensthickness[$CellContext`edad]^2, $CellContext`FirstOrder[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]], 
            Pattern[$CellContext`matrix, 
             Blank[]]] := 
          Module[{$CellContext`ABCD, $CellContext`vphp, $CellContext`vpnp, \
$CellContext`vn, $CellContext`vh, $CellContext`entpupil, \
$CellContext`extpupil, $CellContext`cristpupilcong, \
$CellContext`corneapupilcong, $CellContext`ent, $CellContext`ext, \
$CellContext`results}, $CellContext`ABCD = $CellContext`matrix; \
$CellContext`phip = (-Part[$CellContext`ABCD, 2, 1]) 
              1000 $CellContext`vitreoindex[$CellContext`lambda]; \
$CellContext`vphp = (1 - Part[$CellContext`ABCD, 1, 1])/
              Part[$CellContext`ABCD, 2, 1]; $CellContext`vpnp = -(
               Part[$CellContext`ABCD, 1, 1] - Det[$CellContext`matrix])/
              Part[$CellContext`ABCD, 2, 1]; $CellContext`vh = (
               Part[$CellContext`ABCD, 2, 2] - Det[$CellContext`matrix])/
              Part[$CellContext`ABCD, 2, 1]; $CellContext`vn = (
               Part[$CellContext`ABCD, 2, 2] - 1)/
              Part[$CellContext`ABCD, 2, 1]; $CellContext`corneapupilcong = 
             Dot[
               $CellContext`T[
                $CellContext`acuosothickness[$CellContext`edad]], 
               $CellContext`ABCDcornea[$CellContext`lambda, \
$CellContext`edad], 
               $CellContext`T[$CellContext`ent]]; $CellContext`sol = 
             Solve[Part[$CellContext`corneapupilcong, 1, 2] == 
               0, $CellContext`ent]; $CellContext`entpupil = 
             Part[$CellContext`sol, 1, 1, 2]; $CellContext`cristpupilcong = 
             Dot[
               $CellContext`T[$CellContext`ext], 
               $CellContext`ABCDcrist[$CellContext`lambda, $CellContext`edad], 
               $CellContext`T[0]]; $CellContext`sol = 
             Solve[Part[$CellContext`cristpupilcong, 1, 2] == 
               0, $CellContext`ext]; $CellContext`extpupil = 
             Part[$CellContext`sol, 1, 1, 2]; $CellContext`results = Text[
               Style[
                
                Column[{
                 "", "eye ABCD matrix = " MatrixForm[$CellContext`ABCD], 
                  StringJoin["power = ", 
                   ToString[$CellContext`phip], " D"], 
                  StringJoin[
                  "crystalline lens second surface vertex to principal point \
P' = ", 
                   ToString[$CellContext`vphp], " mm"], 
                  StringJoin[
                  "crystalline lens second surface vertex to nodal point N' = \
", 
                   ToString[$CellContext`vpnp], " mm"], 
                  StringJoin[
                  "distance from crystalline lens second surface vertex to \
exit pupil E' = ", 
                   ToString[$CellContext`extpupil], " mm"], 
                  StringJoin[
                  "cornea first surface vertex to principal point P = ", 
                   ToString[$CellContext`vh], " mm"], 
                  StringJoin[
                  "cornea first surface vertex to nodal point N = ", 
                   ToString[$CellContext`vn], " mm"], 
                  StringJoin[
                  "distance from cornea second surface vertex to entrance \
pupil E = ", 
                   ToString[-$CellContext`entpupil], " mm"]}], 14]]]; 
         Null, $CellContext`ABCDGRIN[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]]] := {{
             $CellContext`elemA[$CellContext`lambda, $CellContext`edad], 
             $CellContext`elemB[$CellContext`lambda, $CellContext`edad]}, {
             $CellContext`elemC[$CellContext`lambda, $CellContext`edad], 
             $CellContext`elemD[$CellContext`lambda, $CellContext`edad]}}; 
         Null, $CellContext`ABCDeye[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]]] := Dot[
            $CellContext`R[
             $CellContext`lensR2[$CellContext`edad], 
             $CellContext`vitreoindex[$CellContext`lambda], 
             $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
              $CellContext`lensthickness[$CellContext`edad], 0, 0]], 
            $CellContext`ABCDGRIN[$CellContext`lambda, $CellContext`edad], 
            $CellContext`R[
             $CellContext`lensR1[$CellContext`edad], 
             $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 0,
               0, 0], 
             $CellContext`acuosoindex[$CellContext`lambda]], 
            $CellContext`T[
             $CellContext`acuosothickness[$CellContext`edad]], 
            $CellContext`R[$CellContext`corneaR2, 
             $CellContext`acuosoindex[$CellContext`lambda], 
             $CellContext`corneaindex[$CellContext`lambda]], 
            $CellContext`T[$CellContext`corneathickness], 
            $CellContext`R[$CellContext`corneaR1, 
             $CellContext`corneaindex[$CellContext`lambda], 1]]; 
         Null, $CellContext`ABCDcornea[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]]] := Dot[
            $CellContext`R[$CellContext`corneaR2, 
             $CellContext`acuosoindex[$CellContext`lambda], 
             $CellContext`corneaindex[$CellContext`lambda]], 
            $CellContext`T[$CellContext`corneathickness], 
            $CellContext`R[$CellContext`corneaR1, 
             $CellContext`corneaindex[$CellContext`lambda], 1]]; 
         Null, $CellContext`ABCDcrist[
            Pattern[$CellContext`lambda, 
             Blank[]], 
            Pattern[$CellContext`edad, 
             Blank[]]] := Dot[
            $CellContext`R[
             $CellContext`lensR2[$CellContext`edad], 
             $CellContext`vitreoindex[$CellContext`lambda], 
             $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 
              $CellContext`lensthickness[$CellContext`edad], 0, 0]], 
            $CellContext`ABCDGRIN[$CellContext`lambda, $CellContext`edad], 
            $CellContext`R[
             $CellContext`lensR1[$CellContext`edad], 
             $CellContext`lensindex[$CellContext`lambda, $CellContext`edad, 0,
               0, 0], 
             $CellContext`acuosoindex[$CellContext`lambda]]]; 
         Null, $CellContext`SchematicEye[
           Pattern[$CellContext`lambda, 
            Blank[]], 
           Pattern[$CellContext`edad, 
            Blank[]], 
           Pattern[$CellContext`matrix, 
            Blank[]]] := 
         Module[{$CellContext`irispos, $CellContext`crist, \
$CellContext`cornea, $CellContext`retina, $CellContext`Npos, \
$CellContext`Hpos, $CellContext`Nprimapos, $CellContext`Hprimapos, \
$CellContext`entpupil, $CellContext`extpupil, $CellContext`cristpupilcong, \
$CellContext`corneapupilcong, $CellContext`ent, $CellContext`ext}, \
$CellContext`irispos = $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad]; $CellContext`Hpos = (
              Part[$CellContext`matrix, 2, 2] - Det[$CellContext`matrix])/
             Part[$CellContext`matrix, 2, 1]; $CellContext`Npos = (
              Part[$CellContext`matrix, 2, 2] - 1)/
             Part[$CellContext`matrix, 2, 1]; $CellContext`Nprimapos = -(
              Part[$CellContext`matrix, 1, 1] - Det[$CellContext`matrix])/
             Part[$CellContext`matrix, 2, 1]; $CellContext`Hprimapos = (1 - 
              Part[$CellContext`matrix, 1, 1])/
             Part[$CellContext`matrix, 2, 1]; $CellContext`corneapupilcong = 
            Dot[
              $CellContext`T[
               $CellContext`acuosothickness[$CellContext`edad]], 
              $CellContext`ABCDcornea[$CellContext`lambda, $CellContext`edad], 
              $CellContext`T[$CellContext`ent]]; $CellContext`sol = 
            Solve[Part[$CellContext`corneapupilcong, 1, 2] == 
              0, $CellContext`ent]; $CellContext`entpupil = -
             Part[$CellContext`sol, 1, 1, 2]; $CellContext`cristpupilcong = 
            Dot[
              $CellContext`T[$CellContext`ext], 
              $CellContext`ABCDcrist[$CellContext`lambda, $CellContext`edad], \

              $CellContext`T[0]]; $CellContext`sol = 
            Solve[Part[$CellContext`cristpupilcong, 1, 2] == 
              0, $CellContext`ext]; $CellContext`extpupil = 
            Part[$CellContext`sol, 1, 1, 2]; $CellContext`crist = 
            RegionPlot[$CellContext`lensindex[$CellContext`lambda, \
$CellContext`edad, $CellContext`x - $CellContext`corneathickness - \
$CellContext`acuosothickness[$CellContext`edad], $CellContext`y, 
                 0] - $CellContext`n0[$CellContext`lambda] > 
              0, {$CellContext`x, 
               0, $CellContext`lensthickness[$CellContext`edad] + 
               0.025 + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad]}, {$CellContext`y, -4.9, 4.9},
               AspectRatio -> Automatic, PlotStyle -> Directive[
                Lighter[Blue, 0.5], 
                Opacity[0.2]]]; $CellContext`cornea = RegionPlot[
              
              And[$CellContext`y^2 + (
                  1 + $CellContext`corneaK1[$CellContext`edad]) \
$CellContext`x^2 - 2 $CellContext`corneaR1 $CellContext`x < 
               0, $CellContext`y^2 + (
                  1 + $CellContext`corneaK2[$CellContext`edad]) \
($CellContext`x - $CellContext`corneathickness)^2 - 
                2 $CellContext`corneaR2 ($CellContext`x - \
$CellContext`corneathickness) > 0], {$CellContext`x, 0, 
               3.43}, {$CellContext`y, -4.5, 4.5}, AspectRatio -> Automatic, 
              PlotStyle -> Directive[
                Lighter[Blue, 0.5], 
                Opacity[0.2]]]; $CellContext`retina = 
            ContourPlot[$CellContext`y^2 + 1.25 ($CellContext`x - 23.59)^2 + 
               2 12.72 ($CellContext`x - 23.59) == 
              0, {$CellContext`x, 20.16, 23.59}, {$CellContext`y, -4.9, 4.9}, 
              AspectRatio -> Automatic]; Show[
             Graphics[{{
                PointSize[0.009], 
                
                Point[{{$CellContext`entpupil, 
                   0}, {$CellContext`extpupil + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 0}, {$CellContext`Hpos, 
                   0}, {$CellContext`Npos, 
                   0}, {$CellContext`Hprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 
                   0}, {$CellContext`Nprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad], 0}}]}, 
               Text[
                Style["cornea"], {1, -6}], 
               Text["iris", {$CellContext`irispos, 6}], 
               Text["crystalline lens", {6, -6}], 
               Text["retina", {22, -6}], 
               Text["P", {$CellContext`Hpos, 0.5}], 
               Text["F'", {23.09, 0.5}], 
               Text["N", {$CellContext`Npos, 0.5}], 
               Text["E", {$CellContext`entpupil, -0.6}], 
               Text[
               "E'", {$CellContext`extpupil + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.1, -0.6}], 
               Text[
               "P'", {$CellContext`Hprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.5, 0.5}], 
               Text[
               "N'", {$CellContext`Nprimapos + \
$CellContext`lensthickness[$CellContext`edad] + $CellContext`corneathickness + \
$CellContext`acuosothickness[$CellContext`edad] + 0.5, 0.5}], {
                
                Line[{{$CellContext`irispos, -4}, {$CellContext`irispos, \
-3}}]}, {
                
                Line[{{$CellContext`irispos, 3}, {$CellContext`irispos, 
                   4}}]}, {Dashed, 
                
                Line[{{-2, 0}, {25, 
                 0}}]}}], $CellContext`cornea, $CellContext`crist, \
$CellContext`retina, PlotRange -> All, Frame -> False, PlotLabel -> 
             Style["Schematic Eye", Bold, Medium], 
             BaseStyle -> {Medium, "Label"}, ImageSize -> {400, 250}]]}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->141200248],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration calculates and graphically illustrates the relevant \
cardinal elements (as a function of the age and the wavelength) of a relaxed \
emmetropic human eye model having a GRIN crystalline lens. \
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
The human eye is an optical system with two components: the cornea and the \
crystalline lens, with a diaphragm (iris) in contact with the lens. Despite \
the accommodation process, it is well known that the biometrical data of the \
human eye changes with age, as does the gradient of the refractive index \
structure. Therefore, the paraxial properties of the human eye as an optical \
system evolve with aging. The ABCD matrix formalism has proved to be a good \
tool to characterize the optical system in the paraxial regime. However, when \
the optical system has a gradient index element, an ABCD matrix for this \
element needs to be formulated. Gathering information concerning the aging of \
the biometric ocular data, a model of the human eye has been created, \
accurate both anatomically and optically. Together with the ABCD matrix for \
the GRIN crystalline lens, it is possible to determine the relevant paraxial \
parameters for the eye model. These parameters\[LongDash]which also vary with \
the wavelength in the visible part of the electromagnetic spectrum, as the \
ocular media show light dispersion\[LongDash]help us to study and to teach \
how the relaxed and emmetropic human eye forms an image on the retina.\
\>", "Text"],

Cell[TextData[{
 "A. Gerrard and J. Burch, ",
 StyleBox["Introduction to Matrix Methods in Optics",
  FontSlant->"Italic"],
 ", New York: Dover Publishing Inc., 1975. "
}], "Text"],

Cell[TextData[{
 "J. A. D\[IAcute]az, C. Pizarro, and J. Arasa, \"",
 "Single Dispersive Gradient-Index Profile for the Aging Human Lens",
 ",\" ",
 StyleBox["Journal of the Optical Society of America A",
  FontSlant->"Italic"],
 ", ",
 StyleBox["25",
  FontWeight->"Bold"],
 "(1), 2008 pp. 250\[Dash]261."
}], "Text"],

Cell[TextData[{
 "J. A. D\[IAcute]az, \"ABCD Matrix of the Human Lens Gradient-Index Profile: \
Applicability of the\nCalculation Methods,\" ",
 StyleBox["Applied Optics",
  FontSlant->"Italic"],
 ", ",
 StyleBox["47",
  FontWeight->"Bold"],
 "(2), 2008 pp. 195\[Dash]205."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Cardinal Elements of an Aging Human Eye Model with a \
Gradient-Index Crystalline Lens",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Jos\[EAcute] A. D\[IAcute]az, ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jos%E9+A.+D%\
EDaz"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jos%E9+A.+D%EDaz"],
 ButtonBox["Jos\[EAcute] Fern\[AAcute]ndez-Dorado",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jos\[EAcute]+\
Fern\[AAcute]ndez-Dorado"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jos\[EAcute]+Fern\
\[AAcute]ndez-Dorado"],
 ", ",
 ButtonBox["Josep Arasa",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Josep+Arasa"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Josep+Arasa"],
 ", and ",
 ButtonBox["Carles Pizarro",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Carles+Pizarro"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Carles+Pizarro"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
CardinalElementsOfAnAgingHumanEyeModelWithAGradientIndexCrys"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Cardinal Elements of an Aging Human Eye Model with a \
Gradient-Index Crystalline Lens - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[688, 24, 214, 6, 70, "Section"],
Cell[905, 32, 3700, 64, 70, "Section"],
Cell[4608, 98, 573, 17, 70, "Input",
 InitializationCell->True,
 CellID->34436261],
Cell[5184, 117, 246, 7, 70, "Input",
 InitializationCell->True,
 CellID->432427219],
Cell[5433, 126, 520, 15, 70, "Input",
 InitializationCell->True,
 CellID->340978535],
Cell[5956, 143, 333, 10, 70, "Input",
 InitializationCell->True,
 CellID->129822244],
Cell[6292, 155, 521, 15, 70, "Input",
 InitializationCell->True,
 CellID->17198994],
Cell[6816, 172, 487, 15, 70, "Input",
 InitializationCell->True,
 CellID->623822431],
Cell[7306, 189, 331, 10, 70, "Input",
 InitializationCell->True,
 CellID->81929097],
Cell[7640, 201, 910, 29, 70, "Input",
 InitializationCell->True,
 CellID->41512196],
Cell[8553, 232, 466, 14, 70, "Input",
 InitializationCell->True,
 CellID->233124576],
Cell[9022, 248, 461, 14, 70, "Input",
 InitializationCell->True,
 CellID->18409716],
Cell[9486, 264, 349, 11, 70, "Input",
 InitializationCell->True,
 CellID->76418197],
Cell[9838, 277, 990, 31, 70, "Input",
 InitializationCell->True,
 CellID->378426586],
Cell[10831, 310, 334, 10, 70, "Input",
 InitializationCell->True,
 CellID->51309576],
Cell[11168, 322, 519, 15, 70, "Input",
 InitializationCell->True,
 CellID->135126610],
Cell[11690, 339, 628, 20, 70, "Input",
 InitializationCell->True,
 CellID->157223545],
Cell[12321, 361, 430, 14, 70, "Input",
 InitializationCell->True,
 CellID->80181997],
Cell[12754, 377, 1174, 34, 70, "Input",
 InitializationCell->True,
 CellID->551618667],
Cell[13931, 413, 426, 12, 70, "Input",
 InitializationCell->True,
 CellID->228392252],
Cell[14360, 427, 480, 15, 70, "Input",
 InitializationCell->True,
 CellID->556813497],
Cell[14843, 444, 986, 29, 70, "Input",
 InitializationCell->True,
 CellID->4336973],
Cell[15832, 475, 788, 23, 70, "Input",
 InitializationCell->True,
 CellID->324266708],
Cell[16623, 500, 6096, 153, 70, "Input",
 InitializationCell->True,
 CellID->592568098],
Cell[22722, 655, 769, 24, 70, "Input",
 InitializationCell->True,
 CellID->57563046],
Cell[23494, 681, 1468, 38, 70, "Input",
 InitializationCell->True,
 CellID->256023326],
Cell[24965, 721, 677, 19, 70, "Input",
 InitializationCell->True,
 CellID->126704473],
Cell[25645, 742, 1013, 28, 70, "Input",
 InitializationCell->True,
 CellID->97624088],
Cell[26661, 772, 13739, 345, 70, "Input",
 InitializationCell->True,
 CellID->783395680],
Cell[40403, 1119, 2070, 48, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42510, 1172, 39477, 791, 70, "Output",
 CellID->141200248],
Cell[CellGroupData[{
Cell[82012, 1967, 209, 6, 70, "Section"],
Cell[82224, 1975, 235, 4, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82507, 1985, 209, 6, 70, "Section"],
Cell[82719, 1993, 1258, 17, 70, "Text"],
Cell[83980, 2012, 180, 5, 70, "Text"],
Cell[84163, 2019, 318, 10, 70, "Text"],
Cell[84484, 2031, 285, 9, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[84805, 2045, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[85163, 2056, 1181, 32, 70, "Text"],
Cell[86347, 2090, 1289, 38, 70, "Text"],
Cell[CellGroupData[{
Cell[87661, 2132, 815, 24, 70, "Text"],
Cell[88479, 2158, 1232, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature VS4EbXQ3FyIkkBTfXMODoF8j *)
