(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     78918,       1827]
NotebookOptionsPosition[     74269,       1680]
NotebookOutlinePosition[     75877,       1731]
CellTagsIndexPosition[     75549,       1719]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fern Fractals", "DemoTitle",
 CellChangeTimes->{3.63129256494524*^9}],

Cell[CellGroupData[{

Cell["", "InitializationSection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Barnsley", " ", "fern"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", " ", "=", " ", "0.01"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"probability", " ", "for", " ", "stem"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", " ", "=", " ", "0.85"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"successively", " ", "smaller", " ", "leaflets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p3", " ", "=", " ", "0.07"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"largest", " ", "left"}], "-", 
       RowBox[{"hand", " ", "leaflet"}]}], ";", " ", 
      RowBox[{"p4", " ", "=", " ", "0.07"}]}], ",", " ", 
     RowBox[{
      RowBox[{"largest", " ", "right"}], "-", 
      RowBox[{"hand", " ", "leaflet"}]}]}], "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.63155211141936*^9},
 CellID->140126495],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"multiplies", " ", "matrix"}], " ", "+", " ", 
    RowBox[{"point", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], " ", "to", " ", "successively", " ", 
     "generate", " ", "points"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f1", " ", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"Dot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.", ",", "0."}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.", ",", ".16"}], "}"}]}], "}"}], ",", "point"}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f2", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".85", ",", ".04"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".04"}], ",", ".85"}], "}"}]}], "}"}], ",", 
          "point"}], "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", "1.6"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f3", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".2", ",", 
              RowBox[{"-", ".26"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".23", ",", ".22"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", "1.6"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f4", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".15"}], ",", ".28"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".26", ",", ".24"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", ".44"}], "}"}]}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.631552120441043*^9}},
 CellID->1493634199],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Thelypteridaceae", " ", "fern"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1t", " ", "=", " ", "0.02"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"probability", " ", "for", " ", "stem"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2t", " ", "=", " ", "0.84"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"successively", " ", "smaller", " ", "leaflets"}], 
    "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.6315521274796333`*^9}},
 CellID->894911208],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"multiplies", " ", "matrix"}], " ", "+", " ", 
    RowBox[{"point", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], " ", "to", " ", "successively", " ", 
     "generate", " ", "points"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f1t", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0.", ",", "0."}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.", ",", ".25"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", 
          RowBox[{"-", ".4"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f2t", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".95", ",", ".005"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".005"}], ",", ".93"}], "}"}]}], "}"}], ",", 
          "point"}], "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".002"}], ",", ".5"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f3t", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".035", ",", 
              RowBox[{"-", ".2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".16", ",", ".04"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".09"}], ",", ".02"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f4t", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".04"}], ",", ".2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".16", ",", ".04"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{".083", ",", ".12"}], "}"}]}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.631552141265061*^9}},
 CellID->32957756],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Leptosporangiate", " ", "fern"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"multiplies", " ", "matrix"}], " ", "+", " ", 
    RowBox[{"point", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], " ", "to", " ", "successively", " ", 
     "generate", " ", "points"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f1l", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0.", ",", "0."}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.", ",", ".25"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", 
          RowBox[{"-", ".14"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f2l", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".85", ",", ".02"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".02"}], ",", ".83"}], "}"}]}], "}"}], ",", 
          "point"}], "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", "1."}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f3l", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".09", ",", 
              RowBox[{"-", ".28"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".3", ",", ".11"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", ".6"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f4l", "=", " ", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"point", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{
        RowBox[{"Dot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".09"}], ",", ".28"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".3", ",", ".09"}], "}"}]}], "}"}], ",", "point"}], 
         "]"}], " ", "+", " ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", ".7"}], "}"}]}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.63155215235957*^9}},
 CellID->1321613716],

Cell[BoxData[
 RowBox[{
  RowBox[{"point", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0.", ",", "0."}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.631552155583618*^9}},
 CellID->1493693289],

Cell[BoxData[
 RowBox[{
  RowBox[{"generatePointB", "[", "point_", "]"}], " ", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"RandomReal", "[", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"p1", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1", "+", "p2"}]}], ",", 
      RowBox[{"f2", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1", "+", "p2"}], " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1", "+", "p2", "+", "p3"}]}], ",", 
      RowBox[{"f3", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1", "+", "p2", "+", "p3"}], "<", "r"}], ",", 
      RowBox[{"f4", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"r", "<", "p1"}], ",", 
      RowBox[{"f1", "[", "point", "]"}]}], "]"}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.631552169215313*^9}},
 CellID->857600144],

Cell[BoxData[
 RowBox[{
  RowBox[{"generatePointT", "[", "point_", "]"}], " ", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"RandomReal", "[", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"p1t", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1t", "+", "p2t"}]}], ",", 
      RowBox[{"f2t", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1t", "+", "p2t"}], " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1t", "+", "p2t", "+", "p3"}]}], ",", 
      RowBox[{"f3t", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1t", "+", "p2t", "+", "p3"}], "<", "r"}], ",", 
      RowBox[{"f4t", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"r", "<", "p1t"}], ",", 
      RowBox[{"f1", "[", "point", "]"}]}], "]"}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.631552167383029*^9}},
 CellID->1922865191],

Cell[BoxData[
 RowBox[{
  RowBox[{"generatePointL", "[", "point_", "]"}], " ", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"RandomReal", "[", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"p1t", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1t", "+", "p2t"}]}], ",", 
      RowBox[{"f2l", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1t", "+", "p2t"}], " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"p1t", "+", "p2t", "+", "p3"}]}], ",", 
      RowBox[{"f3l", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"p1t", "+", "p2t", "+", "p3"}], "<", "r"}], ",", 
      RowBox[{"f4l", "[", "point", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"r", "<", "p1t"}], ",", 
      RowBox[{"f1l", "[", "point", "]"}]}], "]"}]}], ")"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.63155211141936*^9, 3.63155216615882*^9}},
 CellID->113861434]
}, Closed]],

Cell[CellGroupData[{

Cell["", "ManipulateSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"NestList", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Which", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"type", "===", "\"\<Barnsley\>\""}], ",", "generatePointB", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"type", " ", "===", " ", "\"\<Thelypteridaceae\>\""}], ",", 
         "generatePointT", ",", "\[IndentingNewLine]", 
         RowBox[{"type", " ", "===", " ", "\"\<Leptosporangiate\>\""}], ",", 
         "generatePointL"}], "\[IndentingNewLine]", "]"}], ",", "point", ",", 
       "iterations"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
     RowBox[{"Background", " ", "\[Rule]", " ", "Black"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"1.1", 
       RowBox[{"{", 
        RowBox[{"400", ",", "400"}], "}"}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"iterations", ",", "100"}], "}"}], ",", "0", ",", "20000", ",", 
     "100", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"type", ",", "\"\<Barnsley\>\"", ",", "\"\<fern type\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Barnsley\>\"", ",", "\"\<Thelypteridaceae\>\"", ",", 
       "\"\<Leptosporangiate\>\""}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "RadioButtonBar"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", " ", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.631292597078434*^9, {3.631293280547967*^9, 3.631293298179347*^9}, {
   3.631552187769333*^9, 3.6315523427393312`*^9}, {3.631645384967783*^9, 
   3.631645386270564*^9}, {3.631730146636921*^9, 3.63173014700478*^9}, {
   3.6317302480340643`*^9, 3.631730421051914*^9}, {3.63173059163305*^9, 
   3.631730709019433*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`iterations$$ = 100, $CellContext`type$$ = 
    "Barnsley", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`iterations$$], 100}, 0, 20000, 100}, {{
       Hold[$CellContext`type$$], "Barnsley", "fern type"}, {
      "Barnsley", "Thelypteridaceae", "Leptosporangiate"}}}, 
    Typeset`size$$ = {440., {218., 222.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`iterations$181663$$ = 0, $CellContext`type$181664$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`iterations$$ = 100, $CellContext`type$$ = 
        "Barnsley"}, "ControllerVariables" :> {
        Hold[$CellContext`iterations$$, $CellContext`iterations$181663$$, 0], 
        Hold[$CellContext`type$$, $CellContext`type$181664$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        NestList[
         Which[$CellContext`type$$ === 
          "Barnsley", $CellContext`generatePointB, $CellContext`type$$ === 
          "Thelypteridaceae", $CellContext`generatePointT, \
$CellContext`type$$ === 
          "Leptosporangiate", $CellContext`generatePointL], \
$CellContext`point, $CellContext`iterations$$], PlotStyle -> Green, 
        Background -> Black, Axes -> False, AspectRatio -> 1, ImageSize -> 
        1.1 {400, 400}], 
      "Specifications" :> {{{$CellContext`iterations$$, 100}, 0, 20000, 100, 
         Appearance -> 
         "Labeled"}, {{$CellContext`type$$, "Barnsley", "fern type"}, {
         "Barnsley", "Thelypteridaceae", "Leptosporangiate"}, ControlType -> 
         RadioButtonBar}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{483., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`generatePointB[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1 < $CellContext`r < $CellContext`p1 + \
$CellContext`p2, 
          $CellContext`f2[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 < $CellContext`r < $CellContext`p1 + $CellContext`p2 + \
$CellContext`p3, 
          $CellContext`f3[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4[$CellContext`point], $CellContext`r < \
$CellContext`p1, 
          $CellContext`f1[$CellContext`point]]), $CellContext`point = {0., 
        0.}, $CellContext`r = 0.03341643137241013, $CellContext`p1 = 
       0.01, $CellContext`p2 = 0.85, $CellContext`f2 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {{{0.85, 0.04}, {-0.04, 0.85}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.04}, {-0.04, 0.85}}, $CellContext`point] + {0., 1.6}],
          Evaluate], $CellContext`p3 = 0.07, $CellContext`f3 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {
          4, {2, 0, 0}}, {{{0.2, -0.26}, {0.23, 0.22}}, {3, 2, 1}}}, {0, 1, 0,
          0, 4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.2, -0.26}, {0.23, 0.22}}, $CellContext`point] + {0., 1.6}], 
         Evaluate], $CellContext`f4 = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.15, 0.28}, {0.26, 0.24}}, {3, 2, 1}}, {{
           0., 0.44}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.15, 0.28}, {0.26, 0.24}}, $CellContext`point] + {0., 
           0.44}], Evaluate], $CellContext`f1 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0., 0.}, {0., 0.16}}, {3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0,
          0, 3}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.16}}, $CellContext`point]], 
         Evaluate], $CellContext`generatePointT[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4t[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1[$CellContext`point]]), $CellContext`p1t = 
       0.02, $CellContext`p2t = 0.84, $CellContext`f2t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{-0.002, 0.5}, {3, 1, 3}}, {{{0.95, 0.005}, {-0.005, 0.93}}, {
           3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.95, 0.005}, {-0.005, 0.93}}, $CellContext`point] + {-0.002, 
           0.5}], Evaluate], $CellContext`f3t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.035, -0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{-0.09, 0.02}, {3,
            1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.035, -0.2}, {0.16, 0.04}}, $CellContext`point] + {-0.09, 
           0.02}], Evaluate], $CellContext`f4t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{-0.04, 0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{0.083, 0.12}, {3, 
           1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.04, 0.2}, {0.16, 0.04}}, $CellContext`point] + {0.083, 
           0.12}], Evaluate], $CellContext`generatePointL[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4l[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1l[$CellContext`point]]), $CellContext`f2l = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.85, 0.02}, {-0.02, 0.83}}, {3, 2, 1}}, {{0., 1.}, {3, 1, 
           3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.02}, {-0.02, 0.83}}, $CellContext`point] + {0., 1.}], 
         Evaluate], $CellContext`f3l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 0.6}, {3, 1, 3}}, {{{0.09, -0.28}, {0.3, 0.11}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.09, -0.28}, {0.3, 0.11}}, $CellContext`point] + {0., 0.6}], 
         Evaluate], $CellContext`f4l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.09, 0.28}, {0.3, 0.09}}, {3, 2, 1}}, {{
           0., 0.7}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.09, 0.28}, {0.3, 0.09}}, $CellContext`point] + {0., 0.7}], 
         Evaluate], $CellContext`f1l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., -0.14}, {3, 1, 3}}, {{{0., 0.}, {0., 0.25}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.25}}, $CellContext`point] + {0., -0.14}], 
         Evaluate]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->1546394690]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ManipulateCaptionSection"],

Cell["\<\
This Demonstration plots three types of ferns: Barnsley, Thelypteridaceae, \
and Leptosporangiate. The ferns are obtained by repeatedly applying one of \
four affine transformations chosen randomly, starting at the origin. By \
adjusting matrix coefficients and probabilities, we can generate different \
types of ferns.\
\>", "ManipulateCaption",
 CellChangeTimes->{
  3.631292613259687*^9, {3.631611441985359*^9, 3.6316114595238953`*^9}, 
   3.631632563340493*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ThumbnailSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
    "Leptosporangiate", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`iterations$$], 4400}, 0, 20000, 100}, {{
       Hold[$CellContext`type$$], "Leptosporangiate", "fern type"}, {
      "Barnsley", "Thelypteridaceae", "Leptosporangiate"}}}, 
    Typeset`size$$ = {440., {218., 222.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`iterations$181719$$ = 0, $CellContext`type$181720$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
        "Leptosporangiate"}, "ControllerVariables" :> {
        Hold[$CellContext`iterations$$, $CellContext`iterations$181719$$, 0], 
        Hold[$CellContext`type$$, $CellContext`type$181720$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        NestList[
         Which[$CellContext`type$$ === 
          "Barnsley", $CellContext`generatePointB, $CellContext`type$$ === 
          "Thelypteridaceae", $CellContext`generatePointT, \
$CellContext`type$$ === 
          "Leptosporangiate", $CellContext`generatePointL], \
$CellContext`point, $CellContext`iterations$$], PlotStyle -> Green, 
        Background -> Black, Axes -> False, AspectRatio -> 1, ImageSize -> 
        1.1 {400, 400}], 
      "Specifications" :> {{{$CellContext`iterations$$, 4400}, 0, 20000, 100, 
         Appearance -> 
         "Labeled"}, {{$CellContext`type$$, "Leptosporangiate", 
          "fern type"}, {"Barnsley", "Thelypteridaceae", "Leptosporangiate"}, 
         ControlType -> RadioButtonBar}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{483., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`generatePointB[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1 < $CellContext`r < $CellContext`p1 + \
$CellContext`p2, 
          $CellContext`f2[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 < $CellContext`r < $CellContext`p1 + $CellContext`p2 + \
$CellContext`p3, 
          $CellContext`f3[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4[$CellContext`point], $CellContext`r < \
$CellContext`p1, 
          $CellContext`f1[$CellContext`point]]), $CellContext`point = {0., 
        0.}, $CellContext`r = 0.03341643137241013, $CellContext`p1 = 
       0.01, $CellContext`p2 = 0.85, $CellContext`f2 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {{{0.85, 0.04}, {-0.04, 0.85}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.04}, {-0.04, 0.85}}, $CellContext`point] + {0., 1.6}],
          Evaluate], $CellContext`p3 = 0.07, $CellContext`f3 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {
          4, {2, 0, 0}}, {{{0.2, -0.26}, {0.23, 0.22}}, {3, 2, 1}}}, {0, 1, 0,
          0, 4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.2, -0.26}, {0.23, 0.22}}, $CellContext`point] + {0., 1.6}], 
         Evaluate], $CellContext`f4 = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.15, 0.28}, {0.26, 0.24}}, {3, 2, 1}}, {{
           0., 0.44}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.15, 0.28}, {0.26, 0.24}}, $CellContext`point] + {0., 
           0.44}], Evaluate], $CellContext`f1 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0., 0.}, {0., 0.16}}, {3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0,
          0, 3}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.16}}, $CellContext`point]], 
         Evaluate], $CellContext`generatePointT[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4t[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1[$CellContext`point]]), $CellContext`p1t = 
       0.02, $CellContext`p2t = 0.84, $CellContext`f2t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{-0.002, 0.5}, {3, 1, 3}}, {{{0.95, 0.005}, {-0.005, 0.93}}, {
           3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.95, 0.005}, {-0.005, 0.93}}, $CellContext`point] + {-0.002, 
           0.5}], Evaluate], $CellContext`f3t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.035, -0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{-0.09, 0.02}, {3,
            1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.035, -0.2}, {0.16, 0.04}}, $CellContext`point] + {-0.09, 
           0.02}], Evaluate], $CellContext`f4t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{-0.04, 0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{0.083, 0.12}, {3, 
           1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.04, 0.2}, {0.16, 0.04}}, $CellContext`point] + {0.083, 
           0.12}], Evaluate], $CellContext`generatePointL[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4l[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1l[$CellContext`point]]), $CellContext`f2l = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.85, 0.02}, {-0.02, 0.83}}, {3, 2, 1}}, {{0., 1.}, {3, 1, 
           3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.02}, {-0.02, 0.83}}, $CellContext`point] + {0., 1.}], 
         Evaluate], $CellContext`f3l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 0.6}, {3, 1, 3}}, {{{0.09, -0.28}, {0.3, 0.11}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.09, -0.28}, {0.3, 0.11}}, $CellContext`point] + {0., 0.6}], 
         Evaluate], $CellContext`f4l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.09, 0.28}, {0.3, 0.09}}, {3, 2, 1}}, {{
           0., 0.7}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.09, 0.28}, {0.3, 0.09}}, $CellContext`point] + {0., 0.7}], 
         Evaluate], $CellContext`f1l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., -0.14}, {3, 1, 3}}, {{{0., 0.}, {0., 0.25}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.25}}, $CellContext`point] + {0., -0.14}], 
         Evaluate]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->1408458836]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SnapshotsSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
    "Barnsley", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`iterations$$], 4400}, 0, 20000, 100}, {{
       Hold[$CellContext`type$$], "Barnsley", "fern type"}, {
      "Barnsley", "Thelypteridaceae", "Leptosporangiate"}}}, 
    Typeset`size$$ = {440., {218., 222.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`iterations$181775$$ = 0, $CellContext`type$181776$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
        "Barnsley"}, "ControllerVariables" :> {
        Hold[$CellContext`iterations$$, $CellContext`iterations$181775$$, 0], 
        Hold[$CellContext`type$$, $CellContext`type$181776$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        NestList[
         Which[$CellContext`type$$ === 
          "Barnsley", $CellContext`generatePointB, $CellContext`type$$ === 
          "Thelypteridaceae", $CellContext`generatePointT, \
$CellContext`type$$ === 
          "Leptosporangiate", $CellContext`generatePointL], \
$CellContext`point, $CellContext`iterations$$], PlotStyle -> Green, 
        Background -> Black, Axes -> False, AspectRatio -> 1, ImageSize -> 
        1.1 {400, 400}], 
      "Specifications" :> {{{$CellContext`iterations$$, 4400}, 0, 20000, 100, 
         Appearance -> 
         "Labeled"}, {{$CellContext`type$$, "Barnsley", "fern type"}, {
         "Barnsley", "Thelypteridaceae", "Leptosporangiate"}, ControlType -> 
         RadioButtonBar}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{483., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`generatePointB[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1 < $CellContext`r < $CellContext`p1 + \
$CellContext`p2, 
          $CellContext`f2[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 < $CellContext`r < $CellContext`p1 + $CellContext`p2 + \
$CellContext`p3, 
          $CellContext`f3[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4[$CellContext`point], $CellContext`r < \
$CellContext`p1, 
          $CellContext`f1[$CellContext`point]]), $CellContext`point = {0., 
        0.}, $CellContext`r = 0.03341643137241013, $CellContext`p1 = 
       0.01, $CellContext`p2 = 0.85, $CellContext`f2 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {{{0.85, 0.04}, {-0.04, 0.85}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.04}, {-0.04, 0.85}}, $CellContext`point] + {0., 1.6}],
          Evaluate], $CellContext`p3 = 0.07, $CellContext`f3 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {
          4, {2, 0, 0}}, {{{0.2, -0.26}, {0.23, 0.22}}, {3, 2, 1}}}, {0, 1, 0,
          0, 4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.2, -0.26}, {0.23, 0.22}}, $CellContext`point] + {0., 1.6}], 
         Evaluate], $CellContext`f4 = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.15, 0.28}, {0.26, 0.24}}, {3, 2, 1}}, {{
           0., 0.44}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.15, 0.28}, {0.26, 0.24}}, $CellContext`point] + {0., 
           0.44}], Evaluate], $CellContext`f1 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0., 0.}, {0., 0.16}}, {3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0,
          0, 3}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.16}}, $CellContext`point]], 
         Evaluate], $CellContext`generatePointT[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4t[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1[$CellContext`point]]), $CellContext`p1t = 
       0.02, $CellContext`p2t = 0.84, $CellContext`f2t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{-0.002, 0.5}, {3, 1, 3}}, {{{0.95, 0.005}, {-0.005, 0.93}}, {
           3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.95, 0.005}, {-0.005, 0.93}}, $CellContext`point] + {-0.002, 
           0.5}], Evaluate], $CellContext`f3t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.035, -0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{-0.09, 0.02}, {3,
            1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.035, -0.2}, {0.16, 0.04}}, $CellContext`point] + {-0.09, 
           0.02}], Evaluate], $CellContext`f4t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{-0.04, 0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{0.083, 0.12}, {3, 
           1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.04, 0.2}, {0.16, 0.04}}, $CellContext`point] + {0.083, 
           0.12}], Evaluate], $CellContext`generatePointL[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4l[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1l[$CellContext`point]]), $CellContext`f2l = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.85, 0.02}, {-0.02, 0.83}}, {3, 2, 1}}, {{0., 1.}, {3, 1, 
           3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.02}, {-0.02, 0.83}}, $CellContext`point] + {0., 1.}], 
         Evaluate], $CellContext`f3l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 0.6}, {3, 1, 3}}, {{{0.09, -0.28}, {0.3, 0.11}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.09, -0.28}, {0.3, 0.11}}, $CellContext`point] + {0., 0.6}], 
         Evaluate], $CellContext`f4l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.09, 0.28}, {0.3, 0.09}}, {3, 2, 1}}, {{
           0., 0.7}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.09, 0.28}, {0.3, 0.09}}, $CellContext`point] + {0., 0.7}], 
         Evaluate], $CellContext`f1l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., -0.14}, {3, 1, 3}}, {{{0., 0.}, {0., 0.25}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.25}}, $CellContext`point] + {0., -0.14}], 
         Evaluate]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->255415771],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
    "Thelypteridaceae", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`iterations$$], 4400}, 0, 20000, 100}, {{
       Hold[$CellContext`type$$], "Thelypteridaceae", "fern type"}, {
      "Barnsley", "Thelypteridaceae", "Leptosporangiate"}}}, 
    Typeset`size$$ = {440., {218., 222.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`iterations$181831$$ = 0, $CellContext`type$181832$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`iterations$$ = 4400, $CellContext`type$$ = 
        "Thelypteridaceae"}, "ControllerVariables" :> {
        Hold[$CellContext`iterations$$, $CellContext`iterations$181831$$, 0], 
        Hold[$CellContext`type$$, $CellContext`type$181832$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        NestList[
         Which[$CellContext`type$$ === 
          "Barnsley", $CellContext`generatePointB, $CellContext`type$$ === 
          "Thelypteridaceae", $CellContext`generatePointT, \
$CellContext`type$$ === 
          "Leptosporangiate", $CellContext`generatePointL], \
$CellContext`point, $CellContext`iterations$$], PlotStyle -> Green, 
        Background -> Black, Axes -> False, AspectRatio -> 1, ImageSize -> 
        1.1 {400, 400}], 
      "Specifications" :> {{{$CellContext`iterations$$, 4400}, 0, 20000, 100, 
         Appearance -> 
         "Labeled"}, {{$CellContext`type$$, "Thelypteridaceae", 
          "fern type"}, {"Barnsley", "Thelypteridaceae", "Leptosporangiate"}, 
         ControlType -> RadioButtonBar}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{483., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`generatePointB[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1 < $CellContext`r < $CellContext`p1 + \
$CellContext`p2, 
          $CellContext`f2[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 < $CellContext`r < $CellContext`p1 + $CellContext`p2 + \
$CellContext`p3, 
          $CellContext`f3[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4[$CellContext`point], $CellContext`r < \
$CellContext`p1, 
          $CellContext`f1[$CellContext`point]]), $CellContext`point = {0., 
        0.}, $CellContext`r = 0.03341643137241013, $CellContext`p1 = 
       0.01, $CellContext`p2 = 0.85, $CellContext`f2 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {{{0.85, 0.04}, {-0.04, 0.85}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.04}, {-0.04, 0.85}}, $CellContext`point] + {0., 1.6}],
          Evaluate], $CellContext`p3 = 0.07, $CellContext`f3 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {
          4, {2, 0, 0}}, {{{0.2, -0.26}, {0.23, 0.22}}, {3, 2, 1}}}, {0, 1, 0,
          0, 4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.2, -0.26}, {0.23, 0.22}}, $CellContext`point] + {0., 1.6}], 
         Evaluate], $CellContext`f4 = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.15, 0.28}, {0.26, 0.24}}, {3, 2, 1}}, {{
           0., 0.44}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.15, 0.28}, {0.26, 0.24}}, $CellContext`point] + {0., 
           0.44}], Evaluate], $CellContext`f1 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0., 0.}, {0., 0.16}}, {3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0,
          0, 3}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.16}}, $CellContext`point]], 
         Evaluate], $CellContext`generatePointT[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4t[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1[$CellContext`point]]), $CellContext`p1t = 
       0.02, $CellContext`p2t = 0.84, $CellContext`f2t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{-0.002, 0.5}, {3, 1, 3}}, {{{0.95, 0.005}, {-0.005, 0.93}}, {
           3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.95, 0.005}, {-0.005, 0.93}}, $CellContext`point] + {-0.002, 
           0.5}], Evaluate], $CellContext`f3t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.035, -0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{-0.09, 0.02}, {3,
            1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.035, -0.2}, {0.16, 0.04}}, $CellContext`point] + {-0.09, 
           0.02}], Evaluate], $CellContext`f4t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{-0.04, 0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{0.083, 0.12}, {3, 
           1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.04, 0.2}, {0.16, 0.04}}, $CellContext`point] + {0.083, 
           0.12}], Evaluate], $CellContext`generatePointL[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4l[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1l[$CellContext`point]]), $CellContext`f2l = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.85, 0.02}, {-0.02, 0.83}}, {3, 2, 1}}, {{0., 1.}, {3, 1, 
           3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.02}, {-0.02, 0.83}}, $CellContext`point] + {0., 1.}], 
         Evaluate], $CellContext`f3l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 0.6}, {3, 1, 3}}, {{{0.09, -0.28}, {0.3, 0.11}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.09, -0.28}, {0.3, 0.11}}, $CellContext`point] + {0., 0.6}], 
         Evaluate], $CellContext`f4l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.09, 0.28}, {0.3, 0.09}}, {3, 2, 1}}, {{
           0., 0.7}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.09, 0.28}, {0.3, 0.09}}, $CellContext`point] + {0., 0.7}], 
         Evaluate], $CellContext`f1l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., -0.14}, {3, 1, 3}}, {{{0., 0.}, {0., 0.25}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.25}}, $CellContext`point] + {0., -0.14}], 
         Evaluate]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->2100536491],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`iterations$$ = 20000, $CellContext`type$$ = 
    "Leptosporangiate", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`iterations$$], 20000}, 0, 20000, 100}, {{
       Hold[$CellContext`type$$], "Leptosporangiate", "fern type"}, {
      "Barnsley", "Thelypteridaceae", "Leptosporangiate"}}}, 
    Typeset`size$$ = {440., {218., 222.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`iterations$181887$$ = 0, $CellContext`type$181888$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`iterations$$ = 20000, $CellContext`type$$ = 
        "Leptosporangiate"}, "ControllerVariables" :> {
        Hold[$CellContext`iterations$$, $CellContext`iterations$181887$$, 0], 
        Hold[$CellContext`type$$, $CellContext`type$181888$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ListPlot[
        NestList[
         Which[$CellContext`type$$ === 
          "Barnsley", $CellContext`generatePointB, $CellContext`type$$ === 
          "Thelypteridaceae", $CellContext`generatePointT, \
$CellContext`type$$ === 
          "Leptosporangiate", $CellContext`generatePointL], \
$CellContext`point, $CellContext`iterations$$], PlotStyle -> Green, 
        Background -> Black, Axes -> False, AspectRatio -> 1, ImageSize -> 
        1.1 {400, 400}], 
      "Specifications" :> {{{$CellContext`iterations$$, 20000}, 0, 20000, 100,
          Appearance -> 
         "Labeled"}, {{$CellContext`type$$, "Leptosporangiate", 
          "fern type"}, {"Barnsley", "Thelypteridaceae", "Leptosporangiate"}, 
         ControlType -> RadioButtonBar}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{483., {273., 278.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`generatePointB[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1 < $CellContext`r < $CellContext`p1 + \
$CellContext`p2, 
          $CellContext`f2[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 < $CellContext`r < $CellContext`p1 + $CellContext`p2 + \
$CellContext`p3, 
          $CellContext`f3[$CellContext`point], $CellContext`p1 + \
$CellContext`p2 + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4[$CellContext`point], $CellContext`r < \
$CellContext`p1, 
          $CellContext`f1[$CellContext`point]]), $CellContext`point = {0., 
        0.}, $CellContext`r = 0.03341643137241013, $CellContext`p1 = 
       0.01, $CellContext`p2 = 0.85, $CellContext`f2 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {{{0.85, 0.04}, {-0.04, 0.85}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.04}, {-0.04, 0.85}}, $CellContext`point] + {0., 1.6}],
          Evaluate], $CellContext`p3 = 0.07, $CellContext`f3 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 1.6}, {3, 1, 3}}, {
          4, {2, 0, 0}}, {{{0.2, -0.26}, {0.23, 0.22}}, {3, 2, 1}}}, {0, 1, 0,
          0, 4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.2, -0.26}, {0.23, 0.22}}, $CellContext`point] + {0., 1.6}], 
         Evaluate], $CellContext`f4 = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.15, 0.28}, {0.26, 0.24}}, {3, 2, 1}}, {{
           0., 0.44}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.15, 0.28}, {0.26, 0.24}}, $CellContext`point] + {0., 
           0.44}], Evaluate], $CellContext`f1 = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0., 0.}, {0., 0.16}}, {3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0,
          0, 3}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.16}}, $CellContext`point]], 
         Evaluate], $CellContext`generatePointT[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3t[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4t[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1[$CellContext`point]]), $CellContext`p1t = 
       0.02, $CellContext`p2t = 0.84, $CellContext`f2t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{-0.002, 0.5}, {3, 1, 3}}, {{{0.95, 0.005}, {-0.005, 0.93}}, {
           3, 2, 1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.95, 0.005}, {-0.005, 0.93}}, $CellContext`point] + {-0.002, 
           0.5}], Evaluate], $CellContext`f3t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.035, -0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{-0.09, 0.02}, {3,
            1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.035, -0.2}, {0.16, 0.04}}, $CellContext`point] + {-0.09, 
           0.02}], Evaluate], $CellContext`f4t = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{-0.04, 0.2}, {0.16, 0.04}}, {3, 2, 1}}, {{0.083, 0.12}, {3, 
           1, 3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.04, 0.2}, {0.16, 0.04}}, $CellContext`point] + {0.083, 
           0.12}], Evaluate], $CellContext`generatePointL[
         Pattern[$CellContext`point, 
          Blank[]]] := ($CellContext`r = RandomReal[]; 
        Which[$CellContext`p1t < $CellContext`r < $CellContext`p1t + \
$CellContext`p2t, 
          $CellContext`f2l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t < $CellContext`r < $CellContext`p1t + $CellContext`p2t + \
$CellContext`p3, 
          $CellContext`f3l[$CellContext`point], $CellContext`p1t + \
$CellContext`p2t + $CellContext`p3 < $CellContext`r, 
          $CellContext`f4l[$CellContext`point], $CellContext`r < \
$CellContext`p1t, 
          $CellContext`f1l[$CellContext`point]]), $CellContext`f2l = 
       CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{{0.85, 0.02}, {-0.02, 0.83}}, {3, 2, 1}}, {{0., 1.}, {3, 1, 
           3}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.85, 0.02}, {-0.02, 0.83}}, $CellContext`point] + {0., 1.}], 
         Evaluate], $CellContext`f3l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., 0.6}, {3, 1, 3}}, {{{0.09, -0.28}, {0.3, 0.11}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0.09, -0.28}, {0.3, 0.11}}, $CellContext`point] + {0., 0.6}], 
         Evaluate], $CellContext`f4l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{4, {2, 0, 0}}, {{{-0.09, 0.28}, {0.3, 0.09}}, {3, 2, 1}}, {{
           0., 0.7}, {3, 1, 3}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{-0.09, 0.28}, {0.3, 0.09}}, $CellContext`point] + {0., 0.7}], 
         Evaluate], $CellContext`f1l = CompiledFunction[{8, 9., 5468}, {{
           Blank[Real], 1}}, {{3, 1, 0}, {3, 1, 
         2}}, {{{0., -0.14}, {3, 1, 3}}, {{{0., 0.}, {0., 0.25}}, {3, 2, 
           1}}, {4, {2, 0, 0}}}, {0, 1, 0, 0, 
         4}, {{42, "Dot", 3, 2, 1, 3, 1, 0, 2, 0, 0, 3, 1, 2}, {44, 2, 3, 
          2}, {1}}, 
         Function[{$CellContext`point}, 
          Dot[{{0., 0.}, {0., 0.25}}, $CellContext`point] + {0., -0.14}], 
         Evaluate]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->1233131204]
}, Open  ]],

Cell["", "DetailsSection"],

Cell[CellGroupData[{

Cell["", "ControlSuggestionsSection"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Resize Images"]}],
  "\"Click inside an image to reveal its orange resize frame.\\nDrag any of \
the orange resize handles to resize the image.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.6312927647294607`*^9},
 FontFamily->"Verdana",
 CellTags->"ResizeImages"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Rotate and Zoom in 3D"]}],
  RowBox[{
   "\"Drag a 3D graphic to rotate it. Starting the drag near the center \
tumbles\\nthe graphic; starting near a corner turns it parallel to the plane \
of the screen.\\nHold down \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" (or \"", 
    FrameBox[
    "Cmd", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" on Mac) and drag up and down to zoom.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"RotateAndZoomIn3D"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Drag Locators"]}],
  RowBox[{"\"Drag any locator (\"", 
    GraphicsBox[
     LocatorBox[
      Scaled[{0.5, 0.5}]], ImageSize -> 20], 
    "\", etc.) to move it around.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"DragLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Create and Delete Locators"]}],
  RowBox[{"\"Insert a new locator in the graphic by holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key\\nand clicking where you want it to be. Delete a locator by \
clicking it\\nwhile holding down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" key.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"CreateAndDeleteLocators"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Slider Zoom"]}],
  RowBox[{"\"Hold down the \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], 
    "\" key while moving a slider to make fine adjustments in the slider \
value.\\nHold \"", 
    FrameBox[
    "Ctrl", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" and/or \"", 
    FrameBox[
    "Shift", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" at the same time as \"", 
    FrameBox[
    "Alt", Background -> GrayLevel[0.9], FrameMargins -> 2, FrameStyle -> 
     GrayLevel[0.9]], "\" to make ever finer adjustments.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.631292766300601*^9},
 FontFamily->"Verdana",
 CellTags->"SliderZoom"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Gamepad Controls"]}],
  "\"Control this Demonstration with a gamepad or other\\nhuman interface \
device connected to your computer.\"",
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.35696210375764*^9, 3.3895522232313623`*^9, 
  3.631292767237115*^9},
 FontFamily->"Verdana",
 CellTags->"GamepadControls"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[True], Cell[" Automatic Animation"]}],
  RowBox[{"\"Animate a slider in this Demonstration by clicking the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwcIKwAgOI/R/IhBKc\n\
/4EAyGAG0f+nTZsGwgysIJIRKsWKLAXGIHFmEpUgLADxWUAkI24jZs+eTaEt\n\
IG+wQKRmzJgBlYf5lhEA30OqWA=="], "Graphics", ImageSize -> {9, 9}, ImageMargins -> 
      0, CellBaseline -> Baseline], BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"button\\nnext to the slider, and then clicking the play button that \
appears.\\nAnimate all controls by selecting \"", 
    StyleBox["Autorun", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 CellChangeTimes->{3.631292768740699*^9},
 FontFamily->"Verdana",
 CellTags->"AutomaticAnimation"],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Bookmark Animation"]}],
  RowBox[{
   "\"See a prepared animation of this Demonstration by selecting\\n\"", 
    StyleBox["Animate Bookmarks", FontWeight -> "Bold"], "\" from the\"", 
    AdjustmentBox[
     Cell[
      GraphicsData[
      "CompressedBitmap", 
       "eJyNULENwyAQfEySIlMwTVJlCGRFsosokeNtqBmDBagoaZjAI1C8/8GUUUC6\n\
57h7cQ8PvU7Pl17nUav7oj/TPH7V7b2QJAUAXBkKmCPRowxICy64bRvGGNF7\n\
X8CctGoDSN4xhIDGGDhzFXwUh3/ClBKrDQPmnGXtI6u0OOd+tZBVUqy1xSaH\n\
UqiK6pPe4XdEdAz6563tx/gejuORGMxJaz8mdpJn7hc="], "Graphics", 
      ImageSize -> {10, 10}, ImageMargins -> 0, CellBaseline -> Baseline], 
     BoxBaselineShift -> 0.1839080459770115, 
     BoxMargins -> {{0., 0.}, {-0.1839080459770115, 0.1839080459770115}}], 
    "\"menu.\""}],
  TooltipDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"BookmarkAnimation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SearchTermsSection"],

Cell["fern ", "SearchTerms",
 CellChangeTimes->{{3.6312895143806067`*^9, 3.631289527065834*^9}, {
  3.631290373378172*^9, 3.631290373386704*^9}},
 CellID->624087736],

Cell["fractal ", "SearchTerms",
 CellChangeTimes->{{3.6312895143806067`*^9, 3.631289527065834*^9}, {
  3.631290373378172*^9, 3.631290375304927*^9}},
 CellID->147323054],

Cell["nature ", "SearchTerms",
 CellChangeTimes->{{3.6312895143806067`*^9, 3.631289527065834*^9}, {
  3.631290373378172*^9, 3.631290377368659*^9}},
 CellID->2109058569],

Cell["Barnsley", "SearchTerms",
 CellChangeTimes->{{3.6312895143806067`*^9, 3.631289527065834*^9}, {
  3.631290373378172*^9, 3.631290377360681*^9}},
 CellID->1630563086]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "RelatedLinksSection"],

Cell[TextData[ButtonBox["Barnsley's Fern",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BarnsleysFern.html"], None},
 ButtonNote->
  "http://mathworld.wolfram.com/BarnsleysFern.html"]], "RelatedLinks",
 CellID->1351626515]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "AuthorSection"],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Elaine Lin",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Elaine+Lin"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Elaine+Lin"]
}], "Author",
 CellChangeTimes->{3.63129266574585*^9, 3.631552434678454*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{926, 914},
WindowMargins->{{86, Automatic}, {Automatic, 1}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Demonstration.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ResizeImages"->{
  Cell[67027, 1471, 355, 9, 29, "ControlSuggestions",
   CellTags->"ResizeImages"]},
 "RotateAndZoomIn3D"->{
  Cell[67385, 1482, 678, 16, 29, "ControlSuggestions",
   CellTags->"RotateAndZoomIn3D"]},
 "DragLocators"->{
  Cell[68066, 1500, 340, 11, 29, "ControlSuggestions",
   CellTags->"DragLocators"]},
 "CreateAndDeleteLocators"->{
  Cell[68409, 1513, 637, 15, 29, "ControlSuggestions",
   CellTags->"CreateAndDeleteLocators"]},
 "SliderZoom"->{
  Cell[69049, 1530, 885, 22, 29, "ControlSuggestions",
   CellTags->"SliderZoom"]},
 "GamepadControls"->{
  Cell[69937, 1554, 393, 10, 29, "ControlSuggestions",
   CellTags->"GamepadControls"]},
 "AutomaticAnimation"->{
  Cell[70333, 1566, 1505, 32, 29, "ControlSuggestions",
   CellTags->"AutomaticAnimation"]},
 "BookmarkAnimation"->{
  Cell[71841, 1600, 908, 21, 29, "ControlSuggestions",
   CellTags->"BookmarkAnimation"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ResizeImages", 74649, 1692},
 {"RotateAndZoomIn3D", 74758, 1695},
 {"DragLocators", 74868, 1698},
 {"CreateAndDeleteLocators", 74984, 1701},
 {"SliderZoom", 75098, 1704},
 {"GamepadControls", 75204, 1707},
 {"AutomaticAnimation", 75318, 1710},
 {"BookmarkAnimation", 75435, 1713}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 75, 1, 76, "DemoTitle"],
Cell[CellGroupData[{
Cell[679, 27, 33, 0, 275, "InitializationSection"],
Cell[715, 29, 989, 29, 89, "Input",
 InitializationCell->True,
 CellID->140126495],
Cell[1707, 60, 2934, 90, 89, "Input",
 InitializationCell->True,
 CellID->1493634199],
Cell[4644, 152, 605, 18, 57, "Input",
 InitializationCell->True,
 CellID->894911208],
Cell[5252, 172, 3127, 97, 89, "Input",
 InitializationCell->True,
 CellID->32957756],
Cell[8382, 271, 3162, 97, 105, "Input",
 InitializationCell->True,
 CellID->1321613716],
Cell[11547, 370, 245, 7, 25, "Input",
 InitializationCell->True,
 CellID->1493693289],
Cell[11795, 379, 992, 23, 89, "Input",
 InitializationCell->True,
 CellID->857600144],
Cell[12790, 404, 1006, 23, 89, "Input",
 InitializationCell->True,
 CellID->1922865191],
Cell[13799, 429, 1005, 23, 89, "Input",
 InitializationCell->True,
 CellID->113861434]
}, Closed]],
Cell[CellGroupData[{
Cell[14841, 457, 29, 0, 201, "ManipulateSection"],
Cell[CellGroupData[{
Cell[14895, 461, 2194, 49, 231, "Input"],
Cell[17092, 512, 9801, 183, 563, "Output",
 CellID->1546394690]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26942, 701, 36, 0, 181, "ManipulateCaptionSection"],
Cell[26981, 703, 476, 9, 55, "ManipulateCaption"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27494, 717, 28, 0, 179, "ThumbnailSection"],
Cell[27525, 719, 9838, 183, 563, "Output",
 CellID->1408458836]
}, Open  ]],
Cell[CellGroupData[{
Cell[37400, 907, 28, 0, 149, "SnapshotsSection"],
Cell[37431, 909, 9804, 183, 563, "Output",
 CellID->255415771],
Cell[47238, 1094, 9838, 183, 563, "Output",
 CellID->2100536491],
Cell[57079, 1279, 9842, 183, 563, "Output",
 CellID->1233131204]
}, Open  ]],
Cell[66936, 1465, 26, 0, 357, "DetailsSection"],
Cell[CellGroupData[{
Cell[66987, 1469, 37, 0, 119, "ControlSuggestionsSection"],
Cell[67027, 1471, 355, 9, 29, "ControlSuggestions",
 CellTags->"ResizeImages"],
Cell[67385, 1482, 678, 16, 29, "ControlSuggestions",
 CellTags->"RotateAndZoomIn3D"],
Cell[68066, 1500, 340, 11, 29, "ControlSuggestions",
 CellTags->"DragLocators"],
Cell[68409, 1513, 637, 15, 29, "ControlSuggestions",
 CellTags->"CreateAndDeleteLocators"],
Cell[69049, 1530, 885, 22, 29, "ControlSuggestions",
 CellTags->"SliderZoom"],
Cell[69937, 1554, 393, 10, 29, "ControlSuggestions",
 CellTags->"GamepadControls"],
Cell[70333, 1566, 1505, 32, 29, "ControlSuggestions",
 CellTags->"AutomaticAnimation"],
Cell[71841, 1600, 908, 21, 29, "ControlSuggestions",
 CellTags->"BookmarkAnimation"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72786, 1626, 30, 0, 165, "SearchTermsSection"],
Cell[72819, 1628, 165, 3, 23, "SearchTerms",
 CellID->624087736],
Cell[72987, 1633, 168, 3, 23, "SearchTerms",
 CellID->147323054],
Cell[73158, 1638, 168, 3, 23, "SearchTerms",
 CellID->2109058569],
Cell[73329, 1643, 169, 3, 23, "SearchTerms",
 CellID->1630563086]
}, Open  ]],
Cell[CellGroupData[{
Cell[73535, 1651, 31, 0, 149, "RelatedLinksSection"],
Cell[73569, 1653, 254, 6, 23, "RelatedLinks",
 CellID->1351626515]
}, Open  ]],
Cell[CellGroupData[{
Cell[73860, 1664, 25, 0, 149, "AuthorSection"],
Cell[73888, 1666, 353, 10, 23, "Author"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
