(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    868086,      19274]*)
(*NotebookOutlinePosition[    869814,      19329]*)
(*  CellTagsIndexPosition[    869770,      19325]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Introduction to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Conventions"
}], "Section"],

Cell[CellGroupData[{

Cell[TextData[{
  "What ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Is"
}], "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a system for doing mathematics and other technical calculations; we \
type questions and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gives back answers. In addition, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a powerful programming language that allows us to create simple \
or sophisticated functions and programs, and an interface that does word \
processing, outlining, and mathematical typesetting."
}], "Text"],

Cell[TextData[{
  "Three of the classes of computations that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does are numerical calculations (such as arithmetic and finding values of \
functions), symbolic calculations (such as algebra and calculus), and \
graphical calculations (such as two- and three-dimensional graphs of \
functions or data)."
}], "Text"],

Cell[TextData[{
  "The two main parts of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system are the ",
  StyleBox["front end",
    FontSlant->"Italic"],
  " and the ",
  StyleBox["kernel",
    FontSlant->"Italic"],
  ". The front end is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s interface, providing a word-processing and outlining \
environment called a ",
  StyleBox["notebook",
    FontSlant->"Italic"],
  " for entering commands and accompanying text, while the kernel performs \
the mathematical computations."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Started", "Subsection"],

Cell[CellGroupData[{

Cell["Where to Get Help", "Subsubsection"],

Cell[TextData[{
  "The basic reference for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is Stephen Wolfram\[CloseCurlyQuote]s ",
  StyleBox["The Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Book,",
    FontSlant->"Italic"],
  " Third Edition (earlier editions were called",
  StyleBox[" Mathematica:",
    FontSlant->"Italic"],
  " ",
  StyleBox["A System for Doing Mathematics by Computer",
    FontSlant->"Italic"],
  "), which is the definitive reference for all of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s built-in functions and commands."
}], "Text"],

Cell[TextData[{
  "Other helpful items are the books ",
  StyleBox["Standard Add-on Packages",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Getting Started with Mathematica 3.0",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "On many systems, the complete text of ",
  StyleBox["The Mathematica Book ",
    FontSlant->"Italic"],
  "and other reference materials is available on-line using the Help Browser, \
which we open by choosing ",
  StyleBox["Help", "MenuItem"],
  " from the Help menu. At the top of the Help Browser window are radio \
buttons that control which help category we can browse."
}], "Text"],

Cell[TextData[{
  "When we click the ",
  StyleBox["Built-in Functions", "MenuItem"],
  " button, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " presents a list of topics that the built-in functions fall into. \
Selecting a topic with the mouse pointer opens a list of subtopics, and \
selecting a subtopic brings up a list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that fall under that subtopic. Selecting a command name provides \
the usage message for the command, any special considerations to be aware of \
when using the command, hyperlinks to related functions, and examples for the \
command that can be evaluated, edited, or pasted into another notebook."
}], "Text"],

Cell[TextData[{
  "Clicking the ",
  StyleBox["Add-ons", "MenuItem"],
  " button allows us to browse the contents of the book ",
  StyleBox["Standard Add-on Packages",
    FontSlant->"Italic"],
  ", and clicking the button labeled ",
  StyleBox["The Mathematica Book", "MenuItem"],
  " allows us to browse ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Clicking ",
  StyleBox["Getting Started/Demos", "MenuItem"],
  " allows us to browse the contents of ",
  StyleBox["Getting Started with Mathematica 3.0",
    FontSlant->"Italic"],
  ", along with many examples of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " computations, graphics, and typesetting related to various fields."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Other Information", "MenuItem"],
  " category contains information about the front end\[CloseCurlyQuote]s menu \
items and keyboard shortcuts, a reference guide for entering two-dimensional \
typeset formulas, information on how to contact Wolfram Research, and other ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-related information. "
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Master Index", "MenuItem"],
  " category contains an alphabetical index of information contained in all \
of the Help Browser categories."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Starting ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsubsection"],

Cell[TextData[{
  "To start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a windowing system such as Macintosh or Microsoft Windows, we \
double-click the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end icon \[MathematicaIcon] (not the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel icon \[KernelIcon]), or a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook icon. Be aware that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel will load automatically in the background when the first question \
is evaluated, so the first question will take a few moments longer to answer \
than (similar) subsequent questions."
}], "Text"],

Cell[TextData[{
  "On a text-based system, we type ",
  StyleBox["mathematica", "Output"],
  " to start the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end, or type ",
  StyleBox["math", "Output"],
  " to start only the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel."
}], "Text"],

Cell[TextData[{
  "To open an existing notebook once ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is running, we double-click a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook icon, or  pull down the File menu, choose ",
  StyleBox["Open", "MenuItem"],
  ", and find the notebook on the hard disk."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Entering Input", "Subsection"],

Cell[CellGroupData[{

Cell["Questions Must Be Precise", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " requires that questions we type follow a consistent syntax: we must \
follow certain consistent naming, capitalization, and punctuation rules in \
order for the computer to understand our input. The following set of rules is \
designed to allow us to enter questions precisely, without the computer \
having to guess what a question means."
}], "Text"],

Cell[TextData[{
  "The following sections list some of the conventions to be aware of when \
entering questions into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". When entering examples from these notes, it is important to type them \
exactly as they appear here."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluating Questions", "Subsubsection"],

Cell[TextData[{
  "To evaluate a question in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we press \[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified] (that \
is, hold down the Shift key while pressing Return) after typing the question. \
(On a Macintosh we can press the Enter key instead of \[ShiftKey]\
\[LeftModified]\[ReturnKey]\[RightModified], and on a machine running \
Microsoft Windows we can press Insert.) We reevaluate previous questions by \
pressing \[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified] while the \
text insertion point is in the same cell as the input, or while the cell or \
cells containing the questions to be reevaluated are selected."
}], "Text"],

Cell[TextData[{
  "Because the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end does word processing, pressing Return alone merely continues \
input on a new line without evaluating anything. We can type over old \
questions and text to change a function\[CloseCurlyQuote]s arguments, correct \
spelling, and so forth."
}], "Text"],

Cell[TextData[{
  "We can enter several calculations on the same line by separating them with \
semicolons; note that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints only the answer to the last calculation. We can suppress output of \
a command by ending a line with a semicolon."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Names", "Subsubsection"],

Cell[TextData[{
  "Built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands, functions, constants, and other expressions begin with capital \
letters, and are (with some standard exceptions) one or more full-length \
English words. It is important to remember that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is case sensitive. A common cause of errors for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " beginners is the failure to capitalize command names."
}], "Text"],

Cell[TextData[{
  StyleBox["Plot", "Input"],
  ", ",
  StyleBox["Solve", "Input"],
  ", and ",
  StyleBox["Factor", "Input"],
  " are typical built-in function names. Some exceptions to the \
full-length-English-word(s) rule are the standard mathematical abbreviations \
",
  StyleBox["Sin", "Input"],
  ", ",
  StyleBox["Det", "Input"],
  ", ",
  StyleBox["Abs", "Input"],
  ", and ",
  StyleBox["GCD", "Input"],
  ". If a function name contains more than one word, the first letter of each \
word is capitalized, as in ",
  StyleBox["FindRoot", "Input"],
  " and ",
  StyleBox["ExpandNumerator", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "The names of variables and functions that we define can be almost any \
mixture of letters (both upper- and lower-case) and numbers, with the \
restriction that names cannot begin with a number. ",
  StyleBox["mySolve", "Input"],
  ", ",
  StyleBox["x13", "Input"],
  ", and ",
  StyleBox["PrOvE", "Input"],
  " are examples of legal function names. By convention, user-defined \
functions begin with a lower-case letter, but this is not a requirement. Note \
that the name of a variable or function cannot contain an underscore \
character, so ",
  Cell["my_var", "Input"],
  " is ",
  StyleBox["not",
    FontSlant->"Italic"],
  " a valid variable name. (Underscore characters have a special meaning in ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming.)"
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Brackets: ( ) and [ ] and { }", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interprets various types of brackets differently (for example, ",
  StyleBox["f[2]", "Input"],
  " does not mean the same thing as ",
  StyleBox["f(2)", "Input"],
  "), and using an incorrect type of bracket is another common source of \
errors for beginners. The following are ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s bracketing conventions."
}], "Text"],

Cell[TextData[{
  "Parentheses are used only for grouping, as in ",
  Cell[BoxData[
      \(\((a + b + c)\)^n\)], "Input"],
  " and ",
  Cell[BoxData[
      \(1/\((2  \[Pi])\)\)], "Input"],
  ". The input ",
  Cell["f(2)", "Input"],
  " is typically understood to mean a variable ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " times 2, and not a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " evaluated at 2."
}], "Text"],

Cell[TextData[{
  "Function arguments go in square brackets, as in ",
  Cell[BoxData[
      \(Sin[\[Pi]/2]\)], "Input"],
  ", ",
  Cell["Inverse[mat]", "Input"],
  ", and ",
  Cell[BoxData[
      StyleBox[\(Factor[x\^64 - 1]\),
        "Input"]]],
  ". The input ",
  Cell["f[2]", "Input"],
  " means the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " evaluated at 2, where ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " may be a user-defined function."
}], "Text"],

Cell["\<\
Lists, ranges, and iterators (which will be discussed later) go in \
curly brackets or braces, with the elements separated by commas. The \
following are typical uses of curly brackets:\
\>", "Text"],

Cell[TextData[{
  "\t\tthe list ",
  Cell[BoxData[
      StyleBox[\({1, 2, 4, 8, 16}\),
        "Input"]]],
  "\n\t\tthe range for ",
  StyleBox["x", "Input"],
  " in ",
  Cell[BoxData[
      StyleBox[\(Plot[Sin[x]/x, {x, \(-10\), 10}]\),
        "Input"]]],
  "\n\t\tthe iterator ",
  StyleBox["m", "Input"],
  " in ",
  Cell[BoxData[
      StyleBox[\(Table[m\^3, {m, 1, 10}]\),
        "Input"]]]
}], "Text"],

Cell[TextData[{
  "Comments (statements that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel ignores) are enclosed by ",
  Cell["(*", "Input"],
  " and ",
  Cell["*)", "Input"],
  ", as in ",
  Cell[BoxData[
      \( (*\ iterate\ 13\ times\ here\ *) \)], "Input"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Equal Signs: = and == and :=", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses several different types of equal signs to represent the different \
ideas of assigning a value to a variable, separating the parts of an \
equation, and defining a function."
}], "Text"],

Cell[TextData[{
  "A single equal sign ",
  StyleBox["=", "Input"],
  " assigns a value to a variable, as in ",
  Cell[BoxData[
      StyleBox[\(x = 1\),
        "Input"]]],
  " and ",
  Cell[BoxData[
      RowBox[{
        StyleBox["y",
          "Input"], 
        StyleBox["=",
          "Input"], 
        RowBox[{
          StyleBox["5",
            "Input"], 
          StyleBox["+",
            "Input"], 
          SuperscriptBox[
            StyleBox["m",
              "Input"], "2"]}]}]]],
  ". The values we assign in this way can be referred to later in our ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session: if we evaluate ",
  Cell[BoxData[
      StyleBox[\(x + y\),
        "Input"]]],
  " after making the above assignments to ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns ",
  Cell[BoxData[
      RowBox[{
        StyleBox["6",
          "Input"], 
        StyleBox["+",
          "Input"], 
        SuperscriptBox[
          StyleBox["m",
            "Input"], "2"]}]]],
  "."
}], "Text"],

Cell[TextData[{
  "A double equal sign ",
  StyleBox["==", "Input"],
  " is used to represent an equation. To solve the equation ",
  Cell[BoxData[
      \(TraditionalForm\`z\^3 = 1\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", we type ",
  Cell[BoxData[
      StyleBox[\(Solve[z^3 == 1, z]\),
        "Input"]]],
  "."
}], "Text"],

Cell[TextData[{
  "A colon-equal sign ",
  StyleBox[":=", "Input"],
  " is used in function definitions. For example, ",
  Cell[BoxData[
      StyleBox[\(f[x_] := 1 - x^2\),
        "Input"]]],
  " reevaluates the value of ",
  StyleBox["f", "Input"],
  " whenever a new value of the dummy variable ",
  StyleBox["x", "Input"],
  " is given."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Referring to Previous Results", "Subsubsection"],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " remembers all of the input and output in a session, and we can refer to \
previous results by using percent sign (",
  StyleBox["%", "Input"],
  ") notation. A single percent sign ",
  StyleBox["%", "Input"],
  " refers to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s last output, ",
  StyleBox["%%", "Input"],
  " refers to the next-to-last output, ",
  StyleBox["%%%", "Input"],
  " refers to three ago, and so on. ",
  StyleBox["%", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  " refers to the output line numbered ",
  StyleBox["Out[", "Output"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Output"],
  ". For example, ",
  StyleBox["%1", "Input"],
  " refers to the output line labeled ",
  StyleBox["Out[", "Output"],
  StyleBox["1", "Output"],
  StyleBox["]", "Output"],
  "."
}], "Text"],

Cell["\<\
A good rule of thumb is to give a name to a result that will be \
useful later, rather than relying on output line numbers.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["On-Line Help", "Subsubsection"],

Cell[TextData[{
  "If we know the name of a function, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " displays a usage message for the function after we enter ",
  StyleBox["?", "Input"],
  StyleBox["FunctionName",
    FontSlant->"Italic"],
  ". For example, if we want to see how to use the ",
  StyleBox["Simplify", "Input"],
  " command, we type ",
  StyleBox["?Simplify", "Input"],
  ", followed by pressing \[ShiftKey]\[LeftModified]\[ReturnKey]\
\[RightModified]."
}], "Text"],

Cell[BoxData[
    \(\(?Simplify\)\)], "Input"],

Cell[TextData[{
  "On the other hand, ",
  StyleBox["?*", "Input"],
  StyleBox["String",
    FontSlant->"Italic"],
  StyleBox["*", "Input"],
  " finds all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions, commands, constants, and expressions that contain the string ",
  
  StyleBox["String. ",
    FontSlant->"Italic"],
  "This is useful if we know a word, or part of a word, that is likely to be \
contained in a command."
}], "Text"],

Cell[TextData[{
  "For instance, to find all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions related to logarithms we type ",
  StyleBox["?*", "Input"],
  StyleBox["Log*", "Input",
    FontFamily->"Courier"],
  ". (The asterisks before and after ",
  StyleBox["Log", "Input"],
  " stand for any characters, similar to MS-DOS and Unix \
\[OpenCurlyDoubleQuote]wild card\[CloseCurlyDoubleQuote] characters.)"
}], "Text"],

Cell["?*Log*", "Input"],

Cell[TextData[{
  "After locating the desired command in the above list, we evaluate ",
  Cell[TextData[{
    "?",
    Cell["FunctionName", "Text",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"]
  }], "Input"],
  " as before."
}], "Text"],

Cell["? ProductLog", "Input"],

Cell[TextData[{
  "The on-line help is case sensitive, so ",
  StyleBox["?", "Input"],
  StyleBox["\[ThinSpace]", "Input",
    FontFamily->"Courier"],
  StyleBox["*log*", "Input"],
  " finds only function names that contain the word \[OpenCurlyDoubleQuote]",
  StyleBox["log", "Input"],
  "\[CloseCurlyDoubleQuote] in lower case."
}], "Text"],

Cell[BoxData[
    \(\(?*log*\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Loading Add-On Packages", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is an extensible system. In addition to the hundreds of built-in \
functions, there are many more functions defined inside ",
  StyleBox["packages",
    FontSlant->"Italic"],
  " which come with most copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Packages are ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks which contain programs that teach ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " additional functions, and to make these functions available to us we must \
load the appropriate packages. (Many packages are included with the standard \
distribution of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and it is a straightforward exercise to create additional packages.)"
}], "Text"],

Cell[TextData[{
  "To load a package we use the ",
  StyleBox["Needs", "Input"],
  " command, which takes the following form."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`DescriptiveStatistics`\>"]\)], "Input"],

Cell[TextData[{
  "The argument to ",
  StyleBox["Needs", "Input"],
  " is a string inside quotation marks. The first part of the string is the \
desired package directory (in this case, ",
  StyleBox["Statistics", "Input"],
  "; some of the other possibilities are ",
  StyleBox["DiscreteMath", "Input"],
  ", ",
  StyleBox["Calculus", "Input"],
  ", and ",
  StyleBox["Graphics", "Input"],
  "\[LongDash]see the Help Browser or the book",
  StyleBox[" Standard Add-on Packages",
    FontSlant->"Italic"],
  " for a complete list of available packages and directories). After the \
directory name goes a ",
  StyleBox["backquote",
    FontSlant->"Italic"],
  " character ",
  StyleBox["`", "Input"],
  " (usually found on the same key as the tilde ",
  StyleBox["~", "Input"],
  ", and not an ordinary single quote ",
  StyleBox["'", "Input"],
  "), followed by the package name (",
  StyleBox["DescriptiveStatistics", "Input"],
  ", in this case) and another backquote. (An alternative command for loading \
packages takes the form ",
  Cell[BoxData[
      \(<< Statistics`DescriptiveStatistics`\)], "Input"],
  "; when using this form, it is important not to try to reload a package \
after it has been loaded.)"
}], "Text"],

Cell[TextData[{
  "Once a package has been loaded using ",
  StyleBox["Needs", "Input"],
  ", we use the functions defined in the package as if they were built in. \
Here is the on-line help message for the ",
  StyleBox["LocationReport", "Input"],
  " function defined in the ",
  Cell[BoxData[
      \(Statistics`DescriptiveStatistics`\)], "Input"],
  " package."
}], "Text"],

Cell[BoxData[
    \(\(?LocationReport\)\)], "Input"],

Cell[TextData[{
  "We can now use ",
  StyleBox["LocationReport", "Input"],
  " as if it were a built-in function."
}], "Text"],

Cell[BoxData[
    \(LocationReport[{2, 1, 7, 5, 5, 5, 1, 2, 1, 2}]\)], "Input"],

Cell[TextData[{
  "Packages can also be loaded by clicking the button labeled ",
  StyleBox["Add-ons", "MenuItem"],
  " in the Help Browser, and navigating through the package directories to \
the listing for the desired package. In each package\[CloseCurlyQuote]s help \
notebook is a command to load the package, which can be evaluated by clicking \
in it and pressing \[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified]."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Warning Messages", "Subsubsection"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not understand a question, cannot complete an operation, or needs to \
draw attention to special considerations during the course of an evaluation, \
it displays one or more warning messages."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " warns that the input is incomplete: in this case, it needs a closing \
square bracket to be valid."
}], "Text"],

Cell[BoxData[
    \(\(Sin[x\)\)], "Input"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " warns that the name ",
  StyleBox["cos",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is similar to the built-in function name ",
  StyleBox["Cos",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "; this message appears when we misspell or fail to capitalize a built-in \
function. It is important to remember that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is case sensitive."
}], "Text"],

Cell[BoxData[
    \(cos[Pi]\)], "Input"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " explains the reason it did not return an answer."
}], "Text"],

Cell[BoxData[
    \(Integrate[1/x, {x, \(-1\), 2}]\)], "Input"],

Cell[TextData[{
  "The first part of a message (",
  StyleBox["Integrate::idiv",
    FontFamily->"Courier"],
  ") in the previous example) is the name of the message. Messages can be \
turned off by entering ",
  StyleBox["Off[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["messagename",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". For example, to turn off the message named ",
  StyleBox["General::spell1",
    FontFamily->"Courier"],
  " we enter the following."
}], "Text"],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no longer prints warning messages about possible spelling errors. Here we \
misspell the command ",
  StyleBox["Integrate",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Integrat[x\^5, x]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not print the warning message."
}], "Text"],

Cell["To turn the warning message back on, we enter the following.", "Text"],

Cell[BoxData[
    \(On[General::spell1]\)], "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Front End"
}], "Section"],

Cell[CellGroupData[{

Cell["Notebooks", "Subsection"],

Cell[TextData[{
  "Documents created by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end are called ",
  StyleBox["notebooks",
    FontSlant->"Italic"],
  ", which are similar in many ways to documents created using familiar word \
processors. A notebook can contain styled text, pictures, animations, sounds, \
and typeset formulas. In addition, notebooks can contain \
\[OpenCurlyDoubleQuote]live\[CloseCurlyDoubleQuote] mathematical expressions, \
hyperlinks, and buttons that execute arbitrary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions."
}], "Text"],

Cell[TextData[{
  "One special type of notebook is a ",
  StyleBox["palette",
    FontSlant->"Italic"],
  ", which typically contains a collection of special characters, \
two-dimensional forms, or ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions to be pasted into the current notebook. In later sections we \
will see how to use palettes to enter special expressions into a notebook."
}], "Text"],

Cell[TextData[{
  "To create a new notebook, we pull down the File menu and choose ",
  StyleBox["New", "MenuItem"],
  ". (There can be any number of notebooks open at the same time.) A blank \
notebook typically looks something like the following figure."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000KA000`40O003h00O00<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<003W>>Lh033W>0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd00WNm1SW>17Nm0@00
00000`00Oomoo`3oOonaOol00`00Mkeg_@02Mkd00cW>Mkeg_@02Mkd00cW>Mkeg_@02Mkd100000003
001oogoo0?mook5oo`03001g_GNm009g_@03>Lig_GNm009g_@03>Lig_GNm009g_@40000000<007oo
Ool0ogoo/Goo00<007NmMkd00WNm00<icWNmMkd00WNm00<icWNmMkd00WNm0@0000000`00Oomoo`3o
OonaOol00`00MkdicP03>Lh4Mkd4>Lh1Mkd100000003001oogoo0?mook5oo`04001g_GNm>Lh8Mkd0
0cW>Mkeg_@0100000003001oogoo0?mook5oo`05001g_GNmMkdicP06Mkd013W>Mkeg_GNm0@000000
0`00Oomoo`3oOonaOol00`00Mkeg_@02Mkd00cW>Mkeg_@02Mkd00cW>Mkeg_@02Mkd100000?l00;D0
00Eg_@04>Lig_GNm>Lh5Mkd100000003001oogoo0?mook5oo`03001g_GNm00Ag_@8icPIg_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000?l00<@0000000<004ioCWl0odio`4io0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W
>GNm0?mg_Kmg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT02FLi00=g_CW>>Lh0XcW>CgNmYCW>
00=g_AS6IcT02FLi00=g_CW>>Lh013W>0Dio0@0000000`00IcUg_@06Mkd00aS6IcTHaP076<H00fLi
Mkeg_@2/Mkd40003Mkd20002Mkd20004Mkd20002Mkd20004Mkd20002Mkd20003Mkd40004Mkd5000;
Mkd2002_Mkd00aS6IcTHaP076<H00fLiMkeg_@05Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi
00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g
_@80009g_@8000=g_@03001g_GNm0080009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00MF]@036<IW
>GNm00HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm0P00
0WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P001WNm0P000WNm0P002gNm0P00
[gNm00<HaVLiE[D01UJe00<HaVLiMkd01WNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D0
0aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002
Mkd60002Mkd20002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@056<H2E[D00aS6IcUg_@06>Lh1CWl1
00000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g_@80009g_@80009g_@80
00=g_@8000=g_@8000=g_@8000=g_@80009g_@80009g_@80009g_@80009g_@80009g_@D000Ag_@80
0:mg_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi
00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g
_@80009g_@80009g_@80009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00AF]@066<IF]EJe
6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd2
0002Mkd50003Mkd40002Mkd20002Mkd40002Mkd20003Mkd40004Mkd5000;Mkd2002_Mkd00aS6IcUF
]@03E[D01AS6E[EF]AS6IcT01gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg
_@2U>Lh7Mkd20002Mkd2000;Mkd20008Mkd20003Mkd2000>Mkd2000:Mkd30009MkfU>Lh00gNm6<IW
>@04E[D01QS6E[EF]AS6IcUg_@HicP5>O`40000000<006LiMkd01WNm00<HaVLiIcT026Li[GNm0P00
0WNm0P002gNm0P000gNm0P000gNm0P000gNm0P003WNm0P002gNm0P00[gNm00<HaVLiIcT026Li1gNm
0Dio0@0000000`00IcTicP05>Lh00gNm6<HHaP096<H00gNm>LhicP2S>Li?MkfU>Lh00gNm6<HHaP09
6<H00gNm>LhicP04>Lh1CWl100000003001W>GNm0?mg_Kmg_@5>O`40000000<006LiMkd0ogNm_gNm
0Dio0@0000000`00IcUW>@3oIcVoIcT1CWl100000?l00<@00000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[" To enter the first calculation, we just start typing. ", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000EA000`40O003h00O00<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd1
00000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g
_GNm00ag_@40000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@40000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0@0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo
0?moojQoo`D07`Aoo`03001g_GNm00ag_@40000000<007ooOol0B7oo00<007ooOol0ogooHGoo00<0
7gooOol00Woo00<007NmMkd037Nm0@0000000`00Oomoo`18Ool00`00Oomoo`3oOomQOol00`0OOomo
o`02Ool00`00Mkeg_@0<Mkd100000003001oogoo04Qoo`03001oogoo0?moof5oo`0301moogoo009o
o`03001g_GNm00ag_@40000000<007ooOol0;Woo1P001Goo0P001Woo1P0000=oo`00Ool0ogooHWoo
00<07gooOol00Woo00<003W>>Lh033W>0@0000000`00Oomoo`0`Ool20007Ool20008Ool20003Ool0
0`00Oomoo`3oOomQOol00`0OOomoo`02Ool00`00Mkeg_@0<Mkd100000003001oogoo031oo`8000Eo
o`H000Ioo`8000=oo`03001oogoo0?moof5oo`0301moogoo009oo`03001g_GNm00ag_@40000000<0
07ooOol0<7oo0P001goo0P0027oo0P000goo00<007ooOol0ogooHGoo00<07gooOol00Woo00<007Nm
Mkd00WNm1SW>17Nm0@0000000`00Oomoo`0`Ool20007Ool20008Ool20003Ool00`00Oomoo`3oOomQ
Ool00`0OOomoo`02Ool00`00Mkeg_@02Mkd00cW>Mkeg_@02Mkd00cW>Mkeg_@02Mkd100000003001o
ogoo031oo`80015oo`8000=oo`03001oogoo0?moof5oo`0301moogoo009oo`03001g_GNm009g_@03
>Lig_GNm009g_@03>Lig_GNm009g_@40000000<007ooOol0;Woo10003goo10000goo00<007ooOol0
ogooH7oo0P0O17oo00<007NmMkd00WNm00<icWNmMkd00WNm00<icWNmMkd00WNm0@0000000`00Oomo
o`0`Ool2000AOol20003Ool00`00Oomoo`3oOomOOol00`0OOol07`04Ool00`00MkdicP03>Lh4Mkd4
>Lh1Mkd100000003001oogoo04Qoo`03001oogoo0?mooeioo`0401moogoo01l4Ool01000Mkeg_CW>
27Nm00<icWNmMkd00@0000000`00Oomoo`18Ool00`00Oomoo`3oOomMOol01@0OOomoogoo01l017oo
00D007NmMkeg_CW>00Ig_@04>Lig_GNmMkd100000003001oogoo0?moojMoo`H07`Aoo`03001g_GNm
009g_@03>Lig_GNm009g_@03>Lig_GNm009g_@40000000<007ooOol0ogoo/Goo00<007NmMkd00gNm
00@icWNmMkdicPEg_@40000000<007ooOol0ogoo/Goo00<007NmMkd017Nm0SW>1WNm0@0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd100000003001oogoo0?mook5oo`03001g_GNm00ag_@400000
o`00a00000000`00CWm>O`3oCWo0CWl100000003001W>GNm0?mg_Kmg_@5>O`40000000<006LiMkd0
ogNm_gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm>LhicP2S>Li?MkfU>Lh00gNm
6<IW>@09IcT00gNm>LhicP04>Lh1CWl100000003001W>GNm00Ig_@036<IW>AS600LHaP03IcUg_GNm
0:ag_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@8000=g_@@000Ag_@D000]g_@80
0:mg_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT01eJe
00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P00
0WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT01eJe00<HaVLiMkd0
1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd20002Mkd2
0002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd20002Mkd2000;Mkd2002_Mkd0
0aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW
>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@H0
009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00DHaP9F]@036<IW>GNm00HicP5>O`400000
00<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm0P000WNm0P000WNm0P000gNm
0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm1@0017Nm0P00[gNm
00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT01eJe
00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P00
0WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT015Je00HHaUJeE[DHaVLi
Mkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g_@80009g
_@D000=g_@@0009g_@80009g_@@0009g_@8000=g_@@000Ag_@D000]g_@800:mg_@036<IW>EJe00=F
]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:Di
cPMg_@80009g_@8000]g_@8000Qg_@8000=g_@8000ig_@8000Yg_@<000Ug_JDicP03MkdHaVLi00AF
]@066<IF]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUW>@08IcV]Mkd20002Mkd2
000;Mkd20003Mkd20003Mkd20003Mkd2000>Mkd2000;Mkd2002_Mkd00aS6IcUW>@08IcT7Mkd1CWl1
00000003001W>CW>00DicP03MkdHaQS600THaP03MkdicSW>0:<icTmg_JDicP03MkdHaQS600THaP03
MkdicSW>00@icP5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00IcUg_@3oMkfoMkd1CWl1
00000003001W>FLi0?mW>KmW>@5>O`400000o`00a0000000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 85},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Cells", "Subsection"],

Cell[TextData[{
  "One of the fundamental differences between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks and traditional word-processed documents is the notion of ",
  StyleBox["cells",
    FontSlant->"Italic"],
  ". Every piece of information in a notebook goes inside a separate cell, \
and the type of a cell determines the default appearance and properties of \
its contents. For example, mathematical questions go inside input cells, \
whose contents are sent to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel when we evaluate them; and the answers are placed inside new \
output cells. Titles, section headings, and explanatory text go inside title, \
section, and text cells, which are not ordinarily sent to the kernel for \
interpretation."
}], "Text"],

Cell[TextData[{
  "Cells are denoted by vertical brackets on the right-hand side of the \
screen. When we press \[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified] \
after entering ",
  StyleBox["1+1",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in our notebook, the result is the following."
}], "Text"],

Cell[TextData[
"(In these notes, keyboard sequences of the form \[ShiftKey]\[LeftModified]\
\[ReturnKey]\[RightModified] mean we should hold down the first key while \
pressing the key inside the \
\[LeftModified]\[NonBreakingSpace]\[RightModified] brackets. Keyboard \
sequences of the form \[EscapeKey]m\[EscapeKey] without brackets mean we \
should press the keys separately.)"], "Text"],

Cell[TextData[{
  "The bracket to the right of ",
  StyleBox["1+1",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the bracket for the input cell, and the bracket to the right of ",
  StyleBox["2",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the bracket for the output cell. (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " launches the kernel application when we enter the first calculation, so \
it may take a few moments for the answer ",
  StyleBox["2",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be returned.)"
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000H1000`40O003h00O00<007ooOol0ogoo
/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05
>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
OonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP400000o`00]@000fmk00DicVmkKg]_NcW>00=_N`03>Li_Nfmk0040
000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5o
o`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj5oo`D07`9oo`D0
7`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonUOol00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00
Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol06Goo00<07gooOol01Woo00<07gooOol0ogoo
P7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00]o
o`D00?moog9oo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk
>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O0Woo00H07goo01l07goo01l2Ool00`0OOomo
o`02Ool01P0OOomoogoo01moo`@07`Ioo`05001oogooOol0003oOombOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0:Ool00`0O
Oomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0OOomoo`02Ool01@0OOomoogoo01l037oo
00<007ooOol0ogooLgoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/100000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O
009oo`0301moogoo009oo`0601moogooOol07goo100O27oo00<007ooOol0ogooLWoo00<07gooOol0
17oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
2Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l07goo01l4Ool01@0OOomoogoo01l03Woo
00<007ooOol0ogooKWoo100O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/100000003001oogoo00]oo`0401moogoo01l7Ool0100OOomoo`0O0goo0P0O0goo00<07goo
Ool02Goo00D007ooOomoo`000?moog9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00aoo`807`]oo`807`=oo`0301moogoo0080
7`]oo`05001oogooOol0003oOomaOol201l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00Di
cVmkKg]_NcW>009_N`40000000<007ooOol0;goo0`00ogooLGoo00<07goo01l01Woo00<07gooOol0
0Woo00<001S66<H031S60@0000000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo
00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol0
0Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonPOol601l6Ool00`0OOomoo`02Ool00`00
IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F
]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe
0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3E[D16<H10000
0003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007oo
Ool0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`3oOon/
Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojaoo`0301mo
ogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo
00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOonQOol501l6Ool00`0OOomoo`02Ool0
0`00IcUF]@02E[D6CWl3E[D16<H100000003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo
009oo`03001W>EJe00]F]@4HaP40000000<007ooOol05goo0P0O1Woo0P0OogooQ7oo00<07gooOol0
17oo00<07gooOol00Woo00<006LiIcT02fLi0AS60@0000000`00Oomoo`0GOol00`0OOomoo`06Ool0
0`0OOomoo`3oOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00:DXYBP0<:DX100000003001o
ogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol07`02Ool00`0OOomoo`08Ool6
0005Ool20006Ool6003oOomNOol00`0OOomoo`04Ool00`0OOomoo`02Ool@00000003001oogoo011o
o`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol07`04Ool401l7Ool20007Ool20008Ool2
003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>LhicP0<>Lh100000003001oogoo011o
o`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol07`0?Ool20005Ool60006Ool2003oOomP
Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`0;Kg/1>Lh100000003001oogoo011oo`08
01moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool401l7Ool20007Ool20008Ool2003oOomP
Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`02Kg/56<H4Kg/1>Lh100000003001oogoo
011oo`0501moo`0OOol07`02Ool00`0OOomoo`02Ool01@0OOomoogoo01l00Woo00<07gooOol02Woo
0P001goo0P0027oo0P00ogooH7oo00<07gooOol017oo00<07gooOol00Woo00<007ooKg/00Vmk00DH
aTioCWm>OaS600A_N`4icP40000000<007ooOol047oo00<07gooOol017oo00@07gooOomoo`807`=o
o`0301moogoo00eoo`80015oo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk
009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo011oo`0301moogoo00Aoo`807`=oo`03
01moogoo00807`eoo`@000moo`@00?mooemoo`807`Ioo`0301moogoo009oo`03001oofmk009_N`05
6<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo031oo`80015oo`800?mooeioo`0301moo`0O00Io
o`0301moogoo009oo`03001ooaS600<HaP=>O`@HaP5_N`4icP40000000<007ooOol0ogooXWoo00@0
7gooOol07`Ioo`0301moogoo009oo`04001oofmk6<H7CWl011S6Kg]_NcW>0@0000000`00Oomoo`3o
OonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D007ooKg]_NaS600E>O`056<I_NfmkKg/i
cP0100000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03001oofmk009_N`056<I>OdioCWlHaP04
Kg/1>Lh100000003001oogoo0?mook5oo`03001oofmk00=_N`036<I>OaS600E_N`4icP40000000<0
07ooOol0ogoo/Goo00<007ooKg/016mk00<HaVmkKg/016mk0CW>0@0000000`00Oomoo`3oOonaOol0
0`00Oom_N`0;Kg/1>Lh100000003001oogoo0?mook5oo`03001oogoo00]oo`4icP400000o`00a000
00000`00CWm>O`3oCWo0CWl100000003001W>GNm0?mg_Kmg_@5>O`40000000<006LiMkd0ogNm_gNm
0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm>LhicP2S>Li?MkfU>Lh00gNm6<IW>@09
IcT00gNm>LhicP04>Lh1CWl100000003001W>GNm00Ig_@036<IW>AS600LHaP03IcUg_GNm0:ag_@@0
00=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@8000=g_@@000Ag_@D000]g_@800:mg_@03
6<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<HaVLi
Mkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P00
0gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT01eJe00<HaVLiMkd01SW>0Dio
0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd20002Mkd20002Mkd2
0003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd20002Mkd2000;Mkd2002_Mkd00aS6IcUF
]@06E[D00aS6IcUg_@06Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:Di
cPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@H0009g_@80
009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00DHaP9F]@036<IW>GNm00HicP5>O`40000000<006Li
Mkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm
0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm1@0017Nm0P00[gNm00<HaVLi
E[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<HaVLi
Mkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P00
0WNm0P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1
CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g_@80009g_@D000=g
_@@0009g_@80009g_@@0009g_@8000=g_@@000Ag_@D000]g_@800:mg_@036<IW>EJe00=F]@056<IF
]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80
009g_@8000]g_@8000Qg_@8000=g_@8000ig_@8000Yg_@<000Ug_JDicP03MkdHaVLi00AF]@066<IF
]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUW>@08IcV]Mkd20002Mkd2000;Mkd2
0003Mkd20003Mkd20003Mkd2000>Mkd2000;Mkd2002_Mkd00aS6IcUW>@08IcT7Mkd1CWl100000003
001W>CW>00DicP03MkdHaQS600THaP03MkdicSW>0:<icTmg_JDicP03MkdHaQS600THaP03MkdicSW>
00@icP5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00IcUg_@3oMkfoMkd1CWl100000003
001W>FLi0?mW>KmW>@5>O`400000o`00a0000000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 96},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Cells can be collected into groups, which organize the contents of \
a notebook similar to the way a book is organized into chapters and sections. \
In the figure above, there is a cell bracket that groups the input and output \
cells.\
\>", "Text"],

Cell["\<\
Cell groups can be closed, which hides all of the information in a \
cell group except for the first cell. To close a cell group, double-click the \
cell bracket that encloses the cell group. When we double-click the cell \
bracket that contains the input and output cells, the result is similar to \
the following figure. The small arrow at the bottom of the closed cell group \
indicates that there is information hidden there.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000740000@A000`40O003h00O00<007ooOol0ogoo
/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo
0?mook5oo`03001g_GNm00ag_@80000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0P0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo0?mook5oo`03001g_GNm00ag_@800000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd2
00000003001oogoo0?mook5oo`03001g_GNm00ag_@80000000<007ooOol0ogoo/Goo00<007NmMkd0
37Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo0?mook5oo`03001g
_GNm00ag_@80000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol0
0`00Mkeg_@0<Mkd200000003001oogoo0?mook5oo`03001g_GNm00ag_@80000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo
0?mook5oo`03001g_GNm00ag_@80000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0P0000000`00
Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo0?mook5oo`03001g_GNm00ag_@800000
00<007ooOol0ogoo/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd2
00000?l00;<00003Ool007Nm00eg_@80000000<007ooOol0ogoo/Goo00<007NmMkd037Nm0P000000
0`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000003001oogoo0?mook5oo`03001g_GNm00ag_@80
000000<007ooOol0ogooXGoo1@0O1Woo00<07gooOol00Woo00<007NmMkd037Nm0P0000000`00Oomo
o`3oOonUOol00`0OOomoo`03Ool201l4Ool00`00Mkeg_@0<Mkd200000003001oogoo01Moo`807`Io
o`807omoohAoo`0301moogoo009oo`<07`Aoo`03001g_GNm00ag_@80000000<007ooOol05goo00<0
7gooOol01Woo00<07gooOol0ogooPWoo00@07gooOomoo`@07`Aoo`03001g_GNm00ag_@80000000<0
07ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O009oo`0301moogoo00Qo
o`H000Eoo`8000Ioo`H00?mooeioo`0301moogoo00D07`Aoo`03000icSW>00`icP80000000<007oo
Ool047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00Aoo`@07`Moo`8000Moo`80
00Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001g_GNm00ag_@80000000<007oo
Ool047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00moo`8000Eoo`H000Ioo`80
0?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001g_GNm00ag_@80000000<007ooOol047oo
00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Moo`8000Moo`8000Qoo`800?mo
of1oo`0301moogoo00Aoo`0301moogoo009oo`03001g_GNm009g_@HicPAg_@80000000<007ooOol0
47oo00D07goo01moo`0O009oo`0301moogoo009oo`0501moogooOol07`02Ool00`0OOomoo`0:Ool2
0007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Mkeg_@02Mkd00cW>
Mkeg_@02Mkd00cW>Mkeg_@02Mkd200000003001oogoo011oo`0301moogoo00Aoo`0401moogooOol2
01l3Ool00`0OOomoo`0=Ool2000AOol2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
Mkeg_@02Mkd00cW>Mkeg_@02Mkd00cW>Mkeg_@02Mkd200000003001oogoo011oo`0301moogoo00Ao
o`807`=oo`0301moogoo00807`eoo`@000moo`@00?mooemoo`807`Ioo`0301moogoo009oo`03001g
_GNm009g_@03>Lig_GNm009g_@03>Lig_GNm009g_@80000000<007ooOol0<7oo0P004Goo0P00ogoo
GWoo00<07goo01l01Woo00<07gooOol00Woo00<007Nm>Lh00cW>17Nm13W>0GNm0@000@0000000`00
Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo00@007NmMkdicPQg_@03>Lig_GNm0080
000000<007ooOol0ogooXGoo00D07gooOomoo`0O00Ioo`0301moogoo009oo`05001g_GNmMkdicP06
Mkd013W>Mkeg_GNm0P0000000`00Oomoo`3oOonPOol601l2Ool501l4Ool00`00Mkeg_@02Mkd00cW>
Mkeg_@02Mkd00cW>Mkeg_@02Mkd200000003001oogoo0?mook5oo`03001g_GNm00=g_@04>Lig_GNm
>Lh5Mkd200000003001oogoo0?mook5oo`03001g_GNm00Ag_@8icPIg_@80000000<007ooOol0ogoo
/Goo00<007NmMkd037Nm0P0000000`00Oomoo`3oOonaOol00`00Mkeg_@0<Mkd200000?l00<D00000
00<004ioCWl0odio`4io0P0000000`00Ocmg_@3oMkfoMkd1CWl1000100000003001o?gNm0?mg_Kmg
_@5>O`400040000000<007lo>Lh01CW>00=g_AS6Ocl02Glo00=g_CW>>Lh0XcW>CgNmYCW>00=g_AS6
Ocl02Glo00=g_CW>>Lh013W>0Dio0@000@0000000`00Ocmg_@06Mkd00aS6OclHaP076<H00gloMkeg
_@2/Mkd40003Mkd20002Mkd20004Mkd20002Mkd20004Mkd20002Mkd20003Mkd40004Mkd5000;Mkd2
002_Mkd00aS6OclHaP076<H00gloMkeg_@05Mkd1CWl1000100000003001o?cW>00DicP03MkdHaWlo
00MF]@036<Io?gNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g
_@80009g_@8000=g_@03001g_GNm0080009g_@8000]g_@8000Ug_JDicP03MkdHaWlo00MF]@036<Io
?gNm00HicP5>O`400040000000<007loMkd01WNm00<HaWloE[D01UJe00<HaWloMkd0[7Nm0P000WNm
0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P001WNm0P000WNm0P002gNm
0P00[gNm00<HaWloE[D01UJe00<HaWloMkd01WNm0Dio0@000@0000000`00OclicP05>Lh00gNm6<Io
?`07E[D00aS6Ocmg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003
Mkd20002Mkd60002Mkd20002Mkd2000;Mkd20009MkfU>Lh00gNm6<Io?`056<H2E[D00aS6Ocmg_@06
>Lh1CWl1000100000003001o?gNm00Ig_@036<Io?eJe00IF]@036<Io?gNm0:ag_@80009g_@80009g
_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@80009g_@80009g_@80009g_@80009g
_@D000Ag_@800:mg_@036<Io?eJe00=F]@056<IF]EJe6<Io?`07Mkd1CWl1000100000003001o?cW>
00DicP03MkdHaWlo00MF]@036<Io?gNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g
_@8000=g_@8000=g_@80009g_@80009g_@80009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaWlo
00AF]@066<IF]EJe6<Io?gNm1SW>0Dio0@000@0000000`00Ocmg_@06Mkd00aS6OcmF]@06E[D00aS6
Ocmg_@2/Mkd20002Mkd20002Mkd50003Mkd40002Mkd20002Mkd40002Mkd20003Mkd40004Mkd5000;
Mkd2002_Mkd00aS6OcmF]@03E[D01AS6E[EF]AS6Ocl01gNm0Dio0@000@0000000`00OclicP05>Lh0
0gNm6<Io?`07E[D00aS6Ocmg_@2U>Lh7Mkd20002Mkd2000;Mkd20008Mkd20003Mkd2000>Mkd2000:
Mkd30009MkfU>Lh00gNm6<Io?`04E[D01QS6E[EF]AS6Ocmg_@HicP5>O`400040000000<007loMkd0
1WNm00<HaWloOcl027lo[GNm0P000WNm0P002gNm0P000gNm0P000gNm0P000gNm0P003WNm0P002gNm
0P00[gNm00<HaWloOcl027lo1gNm0Dio0@000@0000000`00OclicP05>Lh00gNm6<HHaP096<H00gNm
>LhicP2S>Li?MkfU>Lh00gNm6<HHaP096<H00gNm>LhicP04>Lh1CWl1000100000003001o?gNm0?mg
_Kmg_@5>O`400040000000<007loMkd0ogNm_gNm0Dio0@000@0000000`00Ocmo?`3oOcnoOcl1CWl1
000100000?l00<@0005oo`00\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{452, 65},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Double-clicking the closed cell bracket again opens it and reveals \
the hidden output cell.\
\>", "Text"],

Cell[TextData[{
  "The horizontal line crossing the screen is called the ",
  StyleBox["cell insertion point",
    FontSlant->"Italic"],
  ", which is where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will create a new cell (by default, a new cell is an input cell). If we \
type a new question and press \[ShiftKey]\[LeftModified]\[ReturnKey]\
\[RightModified], the result is similar to the following figure. Again, the \
matching input and output cells are grouped."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000SA000`40O003h00O00<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
OonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@000000
0`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3o
OonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000o`00]@000fmk00DicVmkKg]_NcW>00=_N`03
>Li_Nfmk0040000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj5o
o`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
OonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol06Goo00<07gooOol01Woo00<0
7gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>
00=_N`4icP40000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<07goo01l00Woo100O0Woo
00<07gooOol02goo00<007ooOol00Woo1@0017oo00<007ooOol00goo0`000goo0`001Woo00<007oo
Ool00Woo0`001Goo0`001Goo00<007ooOol00goo0`000goo0`0017oo1@000goo0`000goo10000goo
1@000Woo100017oo0`0017oo0`001Goo00<007ooOol017oo00<007ooOol00goo0`000goo1@0017oo
0`000Woo0`00dWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_Nfmk
Kg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l2Ool01P0OOol07`0OOol07`9oo`0401mo
ogoo01l5Ool00`0OOol07`0301l8Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
1@00Oomoogoo00001Goo00<007ooOol00goo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001o
ogoo009oo`03001oogoo009oo`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool0
1`00Oomoogoo001oo`0000Aoo`04001oogoo0003Ool00`00Ool00004Ool01000Oomoo`000goo00@0
07ooOol000=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00002
Ool01@00Oomoogoo00001Goo00<007ooOol017oo00<007ooOol0cgoo00<07gooOol017oo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol02Woo00<07goo
Ool00Woo00<07goo01l00Woo00<07goo01l00Woo00D07gooOomoo`0O00Aoo`0301moogoo00]oo`03
001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02
Ool00`00Oomoo`06Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomo
o`0000Ioo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00006Ool01@00Oomoogoo0000
2Goo00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo1P001Woo00<007ooOol0cWoo00<07gooOol0
17oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogoo
Ool07goo100O2Goo00<007ooOol00goo00<007ooOol01Goo00D007ooOomoo`0000=oo`04001oogoo
Ool40005Ool00`00Oomoo`02Ool40002Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000=oo`04
001oogooOol40004Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<007oo
Ool01Woo00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`04Ool01@00
Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`@00=1oo`03
01moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0601moo`0O01moo`0O1Goo00@07gooOol0
7`ioo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo009oo`<000=oo`05001oogooOol00005
Ool01@00Oomoogoo00000goo00@007ooOomoo`<000Ioo`04001oogooOol40003Ool01@00Oomoogoo
000017oo00<007ooOol00goo0`000goo10001Woo00@007ooOomoo`@000Aoo`<000Aoo`<000Ioo`03
001oogoo00Aoo`05001oogooOol00003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00D007oo
Oomoo`0000=oo`03001oogoo0<]oo`@07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O1goo00@07gooOol07`9oo`0401mo
ogoo01l2Ool00`0OOomoo`0<Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo
00@007ooOol000=oo`03001oogoo00=oo`05001oogooOol00003Ool01000Oomoo`000goo00<007oo
Ool00goo00D007ooOomoo`0000Ioo`05001oogooOol00004Ool00`00Oomoo`02Ool01@00Oomoogoo
00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo00Aoo`05001oogooOol00002
Ool01@00Oomoogoo00001Goo00<007ooOol017oo00D007ooOomoo`0000=oo`04001oogoo0003Ool0
1`00Oomoogoo001oo`0000=oo`05001oogooOol0003@Ool00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l;Ool201l2Ool2
01l2Ool201l;Ool01@00Oomoogoo00000Woo0`0017oo00D007ooOomoo`00009oo`05001oogooOol0
0002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomo
ogoo00000Woo00D007ooOomoo`0000=oo`03001oogoo00=oo`05001oogooOol00002Ool30004Ool0
1@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo00Aoo`05001o
ogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool0
1@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`8000=oo`05001oogooOol0003?Ool201l6Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0;Woo
1@0017oo00<007ooOol00Woo1@000goo0`0017oo0`000goo1@000goo0`0017oo0`000goo1@0017oo
0`000goo0`001Goo00<007ooOol00goo0`000goo1@000goo0`000goo1@000goo0`0017oo0`000goo
1@000Woo1@000goo0`0017oo0`001Woo00<007ooOol00Woo0`00cgoo00<07goo01l01Woo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooXWoo00@0
7gooOol07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@000000
0`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP40000000<007ooOol0ogooX7oo1P0O1Woo00<07gooOol00Woo00D006mkKg]_
NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`0301moogoo009oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo009oo`05
001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool00`0OOomo
o`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo[7oo00<0
7gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo[7oo
00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
0?moojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00
Oomoo`3oOonQOol501l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`40000000<007ooOol05goo0P0O1Woo0P0OogooQ7oo00<07gooOol017oo
00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol05goo
00<07gooOol01Woo00<07gooOol0ogooPWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_
NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O
009oo`@07`9oo`0401moogoo01l;Ool4000;Ool50003Ool4003oOomKOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0@Ool00`0O
Ool07`02Ool00`0OOol07`02Ool00`0OOomoo`03Ool00`0OOomoo`02Ool401l5Ool20002Ool2000:
Ool20002Ool200000goo00000002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l00Woo00<0
7goo01l00goo00<07gooOol00Woo00<07gooOol03goo0P003Woo0P0000=oo`0000000Woo0P00ogoo
FWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Uoo`80
00ioo`800003Ool00000009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool01@0OOol07goo01l00Woo00<0
7gooOol00goo00@07gooOol07`9oo`0301moogoo00Yoo`<000]oo`D0009oo`80009oo`800?mooeYo
o`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo011oo`0301moogoo00Aoo`0401moogoo01l2Ool0100OOomoo`0O4Goo0P000Woo0P00
0Woo0P000Woo0P001Goo0P000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo011oo`0301moogoo00Aoo`807`9o
o`807`9oo`807`eoo`80009oo`8000=oo`@000=oo`8000Eoo`80009oo`800?mooeUoo`807`Ioo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo02moo`@0
00Eoo`8000Aoo`D000=oo`@00?mooeUoo`0301moo`0O00Ioo`0301moogoo009oo`05001_NfmkKg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooXGoo00D0
7gooOomoo`0O00Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@00
00000`00Oomoo`3oOonPOol601l2Ool501l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogooXGoo1@0O0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/10000
0003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_Nfmk
Kg/icP03Kg/1>Lh100000003001oogoo01Uoo`807`Ioo`807omooh9oo`0301moogoo00Aoo`0301mo
ogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0IOol00`0O
Oomoo`06Ool00`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool00`0OOol0
7`04Ool01@0OOomoogoo01l02goo1@00ogooLWoo00<07gooOol017oo00<07gooOol00Woo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l2Ool01P0O
Ool07`0OOol07`9oo`0301moogoo009oo`0601moogooOol07goo100O1Woo00D007ooOomoo`000?mo
og9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh1
00000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo
009oo`0501moogooOol07`0<Ool00`00Oomoo`3oOomcOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02Woo00<07gooOol00Woo
00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo00H07gooOomoo`0OOol401l8Ool00`00
Oomoo`3oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol0
7`Aoo`0501moogooOol07`0>Ool00`00Oomoo`3oOom^Ool401l6Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02goo00@07gooOol07`Moo`0401mo
ogoo01l3Ool201l3Ool00`0OOomoo`09Ool01@00Oomoogoo0000ogooLWoo00<07gooOol017oo00<0
7gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O
2goo0P0O0goo00<07gooOol00P0O2goo00D007ooOomoo`000?moog5oo`807`Ioo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0_Ool3003oOomaOol0
0`0OOol07`06Ool00`0OOomoo`02Ool00`006<HHaP0<6<H100000003001oogoo0?mooj9oo`0401mo
ogoo01l6Ool00`0OOomoo`02Ool00`00IcUF]@0;E[D16<H100000003001oogoo0?mooj5oo`0501mo
ogooOol07`06Ool00`0OOomoo`02Ool00`00IcUF]@0;E[D16<H100000003001oogoo0?mooj1oo`H0
7`Ioo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol0ogoo[7oo00<0
7gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02
Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W
>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe
1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3E[D1
6<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP400000
00<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomo
o`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?mooj5o
o`D07`Ioo`0301moogoo009oo`03001W>EJe009F]@I>O`=F]@4HaP40000000<007ooOol0ogooYGoo
00<07gooOol017oo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`0GOol201l6
Ool201ooOon4Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUW>@0;IcT16<H100000003001o
ogoo01Moo`0301moogoo00Ioo`0301moogoo0?mooh9oo`0301moogoo00Aoo`0301moogoo009oo`03
000YBRU:00`YBP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomo
o`0O009oo`0301moogoo00Qoo`H000Eoo`8000Ioo`H00?mooeioo`0301moogoo00Aoo`0301moogoo
009ooa00000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00Ao
o`@07`Moo`8000Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03000icSW>
00`icP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00mo
o`8000Eoo`H000Ioo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk00]_N`4i
cP40000000<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Mo
o`8000Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk009_N`DH
aPA_N`4icP40000000<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo009oo`0501moogoo
Ool07`02Ool00`0OOomoo`0:Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomo
o`02Ool00`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk0CW>0@0000000`00Oomoo`0@Ool00`0OOomo
o`04Ool0100OOomoogoo0P0O0goo00<07gooOol03Goo0P004Goo0P00ogooH7oo00<07gooOol017oo
00<07gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol047oo
00<07gooOol017oo0P0O0goo00<07gooOol00P0O3Goo10003goo1000ogooGgoo0P0O1Woo00<07goo
Ool00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol0<7oo0P004Goo
0P00ogooGWoo00<07goo01l01Woo00<07gooOol00Woo00<007oo6<H00aS60dio11S60Fmk0CW>0@00
00000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo00@007ooKg/HaPM>O`046<I_
Nfmk>Lh100000003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02Ool01@00Oom_
Nfmk6<H01Dio00DHaVmkKg]_NcW>0040000000<007ooOol0ogooX7oo1P0O0Woo1@0O17oo00<007oo
Kg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol0ogoo/Goo00<007ooKg/00fmk00<H
aTio6<H01Fmk0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`04Kg/00aS6Kg]_N`04Kg/1>Lh1
00000003001oogoo0?mook5oo`03001oofmk00]_N`4icP40000000<007ooOol0ogoo/Goo00<007oo
Ool02goo0CW>0@00003o003400000003001>Odio0?m>Ol1>O`40000000<006LiMkd0ogNm_gNm0Dio
0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W>CW>00DicP03MkdHaVLi00UW>@03MkdicSW>
0:<icTmg_JDicP03MkdHaVLi00UW>@03MkdicSW>00@icP5>O`40000000<006LiMkd01WNm00<HaVLi
6<H01aS600=W>GNmMkd0[7Nm10000gNm0P000WNm0P0017Nm0P000WNm0P0017Nm0P000WNm0P000gNm
100017Nm1@002gNm0P00[gNm00<HaVLi6<H01aS600=W>GNmMkd01GNm0Dio0@0000000`00IcTicP05
>Lh00gNm6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd2
0003Mkd20003Mkd20002Mkd20003Mkd00`00Mkeg_@020002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW
>@07E[D00aS6IcUg_@06>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag
_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@8000Ig_@80009g
_@8000]g_@800:mg_@036<IW>EJe00IF]@036<IW>GNm00Ig_@5>O`40000000<006Li>Lh01CW>00=g
_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm
0P000gNm0P000WNm1P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT01AS60UJe00<HaVLi
Mkd01SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd20002
Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002
Mkd50004Mkd2002_Mkd00aS6IcUF]@03E[D01AS6E[EF]AS6IcT01gNm0Dio0@0000000`00IcTicP05
>Lh00gNm6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd2
0003Mkd20003Mkd20002Mkd20002Mkd20002Mkd20002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@04
E[D01QS6E[EF]AS6IcUg_@HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0
[7Nm0P000WNm0P000WNm1@000gNm10000WNm0P000WNm10000WNm0P000gNm100017Nm1@002gNm0P00
[gNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT0
1eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P002gNm0P0027Nm0P000gNm0P003WNm0P002WNm0`002GNm
YCW>00=g_AS6IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>FLi
00QW>Jeg_@80009g_@8000]g_@8000=g_@8000=g_@8000=g_@8000ig_@8000]g_@800:mg_@036<IW
>FLi00QW>@Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS66<H02AS600=g_CW>>Lh0XcW>CgNmYCW>
00=g_AS66<H02AS600=g_CW>>Lh013W>0Dio0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W
>GNm0?mg_Kmg_@5>O`40000000<006LiIcT0ofLi_fLi0Dio0@00003o003400000001\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 141},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
To create a new input cell between the two existing questions, we \
must place the cell insertion point at the appropriate place. To move the \
cell insertion point, we move the mouse pointer upward until it becomes a \
horizontal I-bar, which happens only when the pointer is vertically between \
two existing cells.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000S1000`40O003h00O00<007ooOol0ogoo
/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05
>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
OonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@00003o002e0003Kg/01CW>Kg]_Nfmk
>Lh00fmk00<icVmkKg/00@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40
000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool0ogooXGoo1@0O0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/i
cP03Kg/1>Lh100000003001oogoo01Uoo`807`Ioo`807omooh9oo`0301moogoo00Aoo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0IOol00`0OOomo
o`06Ool00`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool00`0OOol07`02
Ool401l2Ool00`0OOomoo`0;Ool00`00Oomoo`02Ool50004Ool00`00Oomoo`03Ool30003Ool30006
Ool00`00Oomoo`02Ool30005Ool30005Ool00`00Oomoo`03Ool30003Ool30004Ool50003Ool30003
Ool40003Ool50002Ool40004Ool30004Ool30005Ool00`00Oomoo`04Ool00`00Oomoo`03Ool30003
Ool50004Ool30002Ool3003BOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`40000000<007ooOol02goo00@07gooOol07`9oo`0601moo`0O01moo`0O
0Woo00@07gooOol07`Eoo`0301moo`0O00<07`Qoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo009oo`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo0000
0goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00=oo`03001o
ogoo009oo`07001oogooOol007oo000017oo00@007ooOol000=oo`03001oo`0000Aoo`04001oogoo
0003Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00D007oo
Oomoo`00009oo`05001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`3?Ool00`0OOomoo`04
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0:
Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool01@0OOomoogoo01l017oo00<07goo
Ool02goo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03
001oogoo009oo`03001oogoo00Ioo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1@00Oomoogoo00001Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Ioo`05001o
ogooOol00009Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo009oo`03001oogoo00Ao
o`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool60006Ool00`00Oomoo`3>Ool0
0`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo
00H07gooOomoo`0OOol401l9Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo
00@007ooOomoo`@000Eoo`03001oogoo009oo`@0009oo`05001oogooOol00005Ool01@00Oomoogoo
00000goo00@007ooOomoo`@000Aoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02
Ool00`00Oomoo`06Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo
00Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo
1000d7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l07goo01l5Ool0
100OOomoo`0O3Woo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00Woo0`000goo00D007oo
Oomoo`0000Eoo`05001oogooOol00003Ool01000Oomoogoo0`001Woo00@007ooOomoo`@000=oo`05
001oogooOol00004Ool00`00Oomoo`03Ool30003Ool40006Ool01000Oomoogoo100017oo0`0017oo
0`001Woo00<007ooOol017oo00D007ooOomoo`0000=oo`03001oogoo00=oo`05001oogooOol00002
Ool01@00Oomoogoo00000goo00<007ooOol0bgoo100O1Woo00<07gooOol00Woo00D006mkKg]_NcW>
00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7Ool0100OOomoo`0O
0Woo00@07gooOol07`9oo`0301moogoo00aoo`03001oogoo00=oo`03001oogoo00Eoo`05001oogoo
Ool00003Ool01000Oomoo`000goo00<007ooOol00goo00D007ooOomoo`0000=oo`04001oogoo0003
Ool00`00Oomoo`03Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Aoo`03001oogoo009oo`05
001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007oo
Oomoo`00009oo`05001oogooOol00005Ool00`00Oomoo`04Ool01@00Oomoogoo00000goo00@007oo
Ool000=oo`07001oogooOol007oo00000goo00D007ooOomoo`000=1oo`0301moogoo00Aoo`0301mo
ogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00aoo`807`]o
o`807`9oo`807`9oo`807`]oo`05001oogooOol00002Ool30004Ool01@00Oomoogoo00000Woo00D0
07ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009o
o`05001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol00goo00D007ooOomoo`00009o
o`<000Aoo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol0
17oo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomo
o`00009oo`05001oogooOol00002Ool01@00Oomoogoo000017oo0P000goo00D007ooOomoo`000<mo
o`807`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00
Oomoo`0^Ool50004Ool00`00Oomoo`02Ool50003Ool30004Ool30003Ool50003Ool30004Ool30003
Ool50004Ool30003Ool30005Ool00`00Oomoo`03Ool30003Ool50003Ool30003Ool50003Ool30004
Ool30003Ool50002Ool50003Ool30004Ool30006Ool00`00Oomoo`02Ool3003?Ool00`0OOol07`06
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3o
OonROol0100OOomoo`0O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02Ool00`00Kg/icP03
Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonPOol601l6Ool00`0OOomoo`02Ool0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo[7oo00<07gooOol0
0Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo[7oo00<07goo
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojao
o`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
Oon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomo
o`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000
00<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/1
00000003001oogoo0?mooj5oo`D07`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/i
cP03Kg/1>Lh100000003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0GOol201l6Ool201ooOon4Ool00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00
Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l00Woo
00<07goo01l00Woo100O0Woo00@07gooOol07`]oo`@000]oo`D000=oo`@00?mooe]oo`0301moogoo
00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
011oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo00=oo`0301moogoo009oo`@07`Eoo`80
009oo`8000Yoo`80009oo`800003Ool00000009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOol0
7`02Ool00`0OOol07`03Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool2000>Ool200000goo00000002
Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0@0000000`00Oomoo`0@Ool0200OOol07`0OOol07goo01l4Ool01@0OOomoogoo01l017oo
100O2Goo0P003Woo0P0000=oo`0000000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo011oo`0501moo`0OOol0
7`02Ool00`0OOomoo`03Ool0100OOomoo`0O0Woo00<07gooOol02Woo0`002goo1@000Woo0P000Woo
0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_
N`4icP40000000<007ooOol047oo00<07gooOol017oo00@07gooOol07`9oo`0401moogoo01lAOol2
0002Ool20002Ool20002Ool20005Ool20002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02
Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07gooOol0
17oo0P0O0Woo0P0O0Woo0P0O3Goo0P000Woo0P000goo10000goo0P001Goo0P000Woo0P00ogooFGoo
0P0O1Woo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool0;goo10001Goo0P0017oo1@000goo1000ogooFGoo00<07goo01l01Woo00<07gooOol00Woo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj9oo`0401moogoo01l6
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3o
OonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/100000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03001_NcW>00=_N`05>Li_NfmkKg/i
cP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
0@0000000`00Oomoo`3oOomhOol00`00Oomoo`0<Ool00`00Oomoo`0WOol00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOomhOol00`00Oomoo`0<Ool00`00Oomoo`0WOol0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooNGoo00<007ooOol0
2Woo00<007ooOol0:7oo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
ogooNWoo3000:goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ogUoo`03001oogoo00Yoo`03001oogoo02Qoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh1
00000003001oogoo0?moogQoo`03001oogoo00aoo`03001oogoo02Moo`05001_NfmkKg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOomhOol00`00Oomoo`0<Ool00`00Oomoo`0WOol0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonQOol501l2Ool501l4
Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooYGoo00<07goo
Ool017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool06Goo0P0O1Woo0P0OogooPWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_
N`05>Li_NfmkKg/icP02Kg/100000003001oogoo01Uoo`0301moogoo00Ioo`0301moogoo0?mooh1o
o`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo00aoo`807`Aoo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol07`0;Ool5
003oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>
009_N`40000000<007ooOol02goo00@07gooOol07`9oo`0601moo`0O01moo`0O0Woo00<07gooOol0
0Woo00H07gooOomoo`0OOol401l6Ool01@00Oomoogoo0000ogooLWoo00<07gooOol017oo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol02Woo00<07goo
Ool00Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo00D07gooOomoo`0O00aoo`03
001oogoo0?moog=oo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02
Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Qoo`03001oogoo0?moog9oo`0301moogoo00Ao
o`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00Yo
o`0301moogoo009oo`0301moo`0O009oo`0601moo`0O01moo`0O17oo00D07gooOomoo`0O00ioo`03
001oogoo0?moofioo`@07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O1goo00@07gooOol07`=oo`807`=oo`0301moogoo
00Uoo`05001oogooOol0003oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l;Ool201l3Ool00`0OOomoo`0201l;
Ool01@00Oomoogoo0000ogooLGoo0P0O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/100000003001oogoo02moo`<00?moog5oo`0301moo`0O00Ioo`0301moogoo009o
o`03000HaQS600`HaP40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`0301moogoo009oo`03
001W>EJe00]F]@4HaP40000000<007ooOol0ogooXGoo00D07gooOomoo`0O00Ioo`0301moogoo009o
o`03001W>EJe00]F]@4HaP40000000<007ooOol0ogooX7oo1P0O1Woo00<07gooOol00Woo00<006Li
E[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6
<I<3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4H
aP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@000000
0`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo
0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo
00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomo
o`02Ool00`00IcUF]@02E[D6<I<3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03
001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol0ogooXGoo1@0O1Woo00<07gooOol00Woo00<0
06LiE[D00UJe1Tio0eJe0AS60@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00IcUF]@0;E[D16<H100000003001oogoo01Moo`807`Ioo`807omoohAoo`0301moogoo00Ao
o`0301moogoo009oo`03001W>FLi00]W>@4HaP40000000<007ooOol05goo00<07gooOol01Woo00<0
7gooOol0ogooPWoo00<07gooOol017oo00<07gooOol00Woo00<002U::DX032U:0@0000000`00Oomo
o`0@Ool00`0OOol07`02Ool00`0OOol07`04Ool01@0OOomoogoo01l00Woo00<07gooOol027oo1P00
1Goo0P001Woo1P00ogooGWoo00<07gooOol017oo00<07gooOol00Woo400000000`00Oomoo`0@Ool0
0`0OOol07`02Ool00`0OOol07`04Ool01@0OOomoogoo01l017oo100O1goo0P001goo0P0027oo0P00
ogooH7oo00<07gooOol017oo00<07gooOol00Woo00<003W>>Lh033W>0@0000000`00Oomoo`0@Ool0
0`0OOol07`02Ool00`0OOol07`04Ool01@0OOomoogoo01l03goo0P001Goo1P001Woo0P00ogooH7oo
00<07gooOol017oo00<07gooOol00Woo00<007ooKg/02fmk0CW>0@0000000`00Oomoo`0@Ool0200O
Ool07`0OOol07goo01l4Ool01@0OOomoogoo01l017oo100O1goo0P001goo0P0027oo0P00ogooH7oo
00<07gooOol017oo00<07gooOol00Woo00<007ooKg/00Vmk1AS616mk0CW>0@0000000`00Oomoo`0@
Ool01@0OOol07goo01l00Woo00<07gooOol00Woo00D07gooOomoo`0O009oo`0301moogoo00Yoo`80
00Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk009_N`056<I>
OdioCWlHaP04Kg/1>Lh100000003001oogoo011oo`0301moogoo00Aoo`0401moogooOol201l3Ool0
0`0OOomoo`0=Ool2000AOol2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`02
Kg/01AS6CWm>Odio6<H016mk0CW>0@0000000`00Oomoo`0@Ool00`0OOomoo`04Ool201l3Ool00`0O
Oomoo`0201l=Ool4000?Ool4003oOomOOol201l6Ool00`0OOomoo`02Ool00`00Oom_N`02Kg/01AS6
CWm>Odio6<H016mk0CW>0@0000000`00Oomoo`0`Ool2000AOol2003oOomNOol00`0OOol07`06Ool0
0`0OOomoo`02Ool00`00OolHaP036<H3CWl46<H1Kg/1>Lh100000003001oogoo0?mooj9oo`0401mo
ogoo01l6Ool00`0OOomoo`02Ool01000Oom_NaS61dio00@HaVmkKg/icP40000000<007ooOol0ogoo
XGoo00D07gooOomoo`0O00Ioo`0301moogoo009oo`05001oofmkKg/HaP05CWl01AS6Kg]_Nfmk>Lh0
0@0000000`00Oomoo`3oOonPOol601l2Ool501l4Ool00`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk
0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`03Kg/00aS6CWlHaP05Kg/1>Lh100000003001o
ogoo0?mook5oo`03001oofmk00A_N`036<I_Nfmk00A_N`4icP40000000<007ooOol0ogoo/Goo00<0
07ooKg/02fmk0CW>0@0000000`00Oomoo`3oOonaOol00`00Oomoo`0;Ool1>Lh100000?l00<@00000
00<004ioCWl0odio`4io0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W>GNm0?mg_Kmg_@5>
O`40000000<006Li>Lh01CW>00=g_AS6IcT02FLi00=g_CW>>Lh0XcW>CgNmYCW>00=g_AS6IcT02FLi
00=g_CW>>Lh013W>0Dio0@0000000`00IcUg_@06Mkd00aS6IcTHaP076<H00fLiMkeg_@2/Mkd40003
Mkd20002Mkd20004Mkd20002Mkd20004Mkd20002Mkd20003Mkd40004Mkd5000;Mkd2002_Mkd00aS6
IcTHaP076<H00fLiMkeg_@05Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm
0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@8000=g
_@03001g_GNm0080009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00MF]@036<IW>GNm00HicP5>O`40
000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm0P000WNm0P000WNm0P00
0gNm0P000gNm0P000gNm0P000gNm0P000WNm0P001WNm0P000WNm0P002gNm0P00[gNm00<HaVLiE[D0
1UJe00<HaVLiMkd01WNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg_@2U>Lh7
Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd60002Mkd20002
Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@056<H2E[D00aS6IcUg_@06>Lh1CWl100000003001W>GNm
00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g_@80009g_@80009g_@8000=g_@8000=g_@80
00=g_@8000=g_@80009g_@80009g_@80009g_@80009g_@80009g_@D000Ag_@800:mg_@036<IW>EJe
00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm
0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@80009g
_@80009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio
0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd20002Mkd50003Mkd4
0002Mkd20002Mkd40002Mkd20003Mkd40004Mkd5000;Mkd2002_Mkd00aS6IcUF]@03E[D01AS6E[EF
]AS6IcT01gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002
Mkd2000;Mkd20008Mkd20003Mkd2000>Mkd2000:Mkd30009MkfU>Lh00gNm6<IW>@04E[D01QS6E[EF
]AS6IcUg_@HicP5>O`40000000<006LiMkd01WNm00<HaVLiIcT026Li[GNm0P000WNm0P002gNm0P00
0gNm0P000gNm0P000gNm0P003WNm0P002gNm0P00[gNm00<HaVLiIcT026Li1gNm0Dio0@0000000`00
IcTicP05>Lh00gNm6<HHaP096<H00gNm>LhicP2S>Li?MkfU>Lh00gNm6<HHaP096<H00gNm>LhicP04
>Lh1CWl100000003001W>GNm0?mg_Kmg_@5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00
IcUW>@3oIcVoIcT1CWl100000?l00<@00000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 140},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Pressing the mouse button places the cell insertion point between \
the first output cell and the second input cell.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000Sa000`40O003h00O00<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
OonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@000000
0`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3o
OonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>
00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_Nfmk
Kg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooXGoo1@0O
0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojEo
o`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo01Uoo`807`Ioo`807omooh9oo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0IOol00`0OOomoo`06Ool00`0OOomo
o`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool00`0OOol07`02Ool401l2Ool00`0O
Oomoo`0;Ool00`00Oomoo`02Ool50004Ool00`00Oomoo`03Ool30003Ool30006Ool00`00Oomoo`02
Ool30005Ool30005Ool00`00Oomoo`03Ool30003Ool30004Ool50003Ool30003Ool40003Ool50002
Ool40004Ool30004Ool30005Ool00`00Oomoo`04Ool00`00Oomoo`03Ool30003Ool50004Ool30002
Ool3003BOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>
009_N`40000000<007ooOol02goo00@07gooOol07`9oo`0601moo`0O01moo`0O0Woo00@07gooOol0
7`Eoo`0301moo`0O00<07`Qoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`05001o
ogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00=oo`03001oogoo009oo`07001o
ogooOol007oo000017oo00@007ooOol000=oo`03001oo`0000Aoo`04001oogoo0003Ool01000Oomo
o`000goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`00009oo`05
001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`3?Ool00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0:Ool00`0OOomoo`02
Ool00`0OOol07`02Ool00`0OOol07`02Ool01@0OOomoogoo01l017oo00<07gooOol02goo00<007oo
Ool017oo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03001oogoo009oo`03
001oogoo00Ioo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo0000
1Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Ioo`05001oogooOol00009Ool0
1000Oomoo`000goo00@007ooOol000=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo009o
o`05001oogooOol00003Ool00`00Oomoo`02Ool60006Ool00`00Oomoo`3>Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02Woo
00<07gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo00H07gooOomoo`0O
Ool401l9Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00@007ooOomoo`@0
00Eoo`03001oogoo009oo`@0009oo`05001oogooOol00005Ool01@00Oomoogoo00000goo00@007oo
Oomoo`@000Aoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo00Aoo`05001oogoo
Ool00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo1000d7oo00<07goo
Ool017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l07goo01l5Ool0100OOomoo`0O3Woo
00<007ooOol00goo00<007ooOol01Goo00<007ooOol00Woo0`000goo00D007ooOomoo`0000Eoo`05
001oogooOol00003Ool01000Oomoogoo0`001Woo00@007ooOomoo`@000=oo`05001oogooOol00004
Ool00`00Oomoo`03Ool30003Ool40006Ool01000Oomoogoo100017oo0`0017oo0`001Woo00<007oo
Ool017oo00D007ooOomoo`0000=oo`03001oogoo00=oo`05001oogooOol00002Ool01@00Oomoogoo
00000goo00<007ooOol0bgoo100O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_Nfmk
Kg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7Ool0100OOomoo`0O0Woo00@07gooOol0
7`9oo`0301moogoo00aoo`03001oogoo00=oo`03001oogoo00Eoo`05001oogooOol00003Ool01000
Oomoo`000goo00<007ooOol00goo00D007ooOomoo`0000=oo`04001oogoo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Aoo`03001oogoo009oo`05001oogooOol00002
Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`05
001oogooOol00005Ool00`00Oomoo`04Ool01@00Oomoogoo00000goo00@007ooOol000=oo`07001o
ogooOol007oo00000goo00D007ooOomoo`000=1oo`0301moogoo00Aoo`0301moogoo009oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00aoo`807`]oo`807`9oo`807`9o
o`807`]oo`05001oogooOol00002Ool30004Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009o
o`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol0
0002Ool01@00Oomoogoo00000goo00<007ooOol00goo00D007ooOomoo`00009oo`<000Aoo`05001o
ogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomo
o`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001o
ogooOol00002Ool01@00Oomoogoo000017oo0P000goo00D007ooOomoo`000<moo`807`Ioo`0301mo
ogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0^Ool50004
Ool00`00Oomoo`02Ool50003Ool30004Ool30003Ool50003Ool30004Ool30003Ool50004Ool30003
Ool30005Ool00`00Oomoo`03Ool30003Ool50003Ool30003Ool50003Ool30004Ool30003Ool50002
Ool50003Ool30004Ool30006Ool00`00Oomoo`02Ool3003?Ool00`0OOol07`06Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonROol0100OOomo
o`0O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonPOol601l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`0301moogoo009oo`03
001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0OOomo
o`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool00`0O
Oomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo[7oo
00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo
[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
0?mooj5oo`D07`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0GOol201l6Ool201ooOon4Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0GOol00`0O
Oomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l00Woo
100O0Woo00@07gooOol07`]oo`@000]oo`D000=oo`@00?mooe]oo`0301moogoo00Aoo`0301moogoo
009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo011oo`0301moo`0O
009oo`0301moo`0O009oo`0301moogoo00=oo`0301moogoo009oo`@07`Eoo`80009oo`8000Yoo`80
009oo`800003Ool00000009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol0
7`03Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool2000>Ool200000goo00000002Ool2003oOomJOol0
0`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`0@Ool0200OOol07`0OOol07goo01l4Ool01@0OOomoogoo01l017oo100O2Goo0P003Woo
0P0000=oo`0000000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>
00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo011oo`0501moo`0OOol07`02Ool00`0OOomo
o`03Ool0100OOomoo`0O0Woo00<07gooOol02Woo0`002goo1@000Woo0P000Woo0P00ogooFWoo00<0
7gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol047oo00<07gooOol017oo00@07gooOol07`9oo`0401moogoo01lAOol20002Ool20002Ool2
0002Ool20005Ool20002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk
>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07gooOol017oo0P0O0Woo0P0O
0Woo0P0O3Goo0P000Woo0P000goo10000goo0P001Goo0P000Woo0P00ogooFGoo0P0O1Woo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0;goo10001Goo
0P0017oo1@000goo1000ogooFGoo00<07goo01l01Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_
N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj9oo`0401moogoo01l6Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonQOol01@0OOomo
ogoo01l01Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo0?moogUoo`03001oogoo00aoo`03001oogoo02Ioo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOomiOol00`00Oomoo`0<Ool00`00Oomoo`0VOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOomjOol00`00Oomoo`0:Ool0
0`00Oomoo`0WOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo
Ngoo3000:Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000o`00O@0000=oo`000000
2P0000=oo`000000:0000fmk00DicVmkKg]_NcW>00=_N`03>Li_Nfmk0040000000<007ooOol0ogoo
NGoo00<007ooOol037oo00<007ooOol09Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol0ogooNGoo00<007ooOol037oo00<007ooOol09Woo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo0?mooj5oo`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0O
Oomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol06Goo00<07gooOol01Woo00<07gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo
00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O17oo00<07goo
01l00Woo00<07goo01l017oo00D07gooOomoo`0O00]oo`D00?moog9oo`0301moogoo00Aoo`0301mo
ogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100O
Oomoo`0O0Woo00H07goo01l07goo01l2Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Ioo`05
001oogooOol0003oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol0
7`02Ool00`0OOomoo`02Ool01@0OOomoogoo01l037oo00<007ooOol0ogooLgoo00<07gooOol017oo
00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00Yo
o`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogooOol0
7goo100O27oo00<007ooOol0ogooLWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo
00H07goo01l07goo01l4Ool01@0OOomoogoo01l03Woo00<007ooOol0ogooKWoo100O1Woo00<07goo
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401mo
ogoo01l7Ool0100OOomoo`0O0goo0P0O0goo00<07gooOol02Goo00D007ooOomoo`000?moog9oo`03
01moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo00aoo`807`]oo`807`=oo`0301moogoo00807`]oo`05001oogooOol0003oOomaOol201l6
Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
;goo0`00ogooLGoo00<07goo01l01Woo00<07gooOol00Woo00<001S66<H031S60@0000000`00Oomo
o`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomo
o`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00
Oomoo`3oOonPOol601l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001o
ogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo
[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0O
Oomoo`02Ool00`00IcUF]@02E[D6<I<3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009o
o`03001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006Li
E[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6
IcT3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4H
aP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@000000
0`00Oomoo`3oOonQOol501l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6CWl3E[D16<H100000003
001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe00]F]@4HaP40000000<0
07ooOol05goo0P0O1Woo0P0OogooQ7oo00<07gooOol017oo00<07gooOol00Woo00<006LiIcT02fLi
0AS60@0000000`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool00`00:DXYBP0<:DX100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O
00Aoo`0501moogooOol07`02Ool00`0OOomoo`08Ool60005Ool20006Ool6003oOomNOol00`0OOomo
o`04Ool00`0OOomoo`02Ool@00000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`05
01moogooOol07`04Ool401l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomo
o`02Ool00`00>LhicP0<>Lh100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`05
01moogooOol07`0?Ool20005Ool60006Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Oom_N`0;Kg/1>Lh100000003001oogoo011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogoo
Ool07`04Ool401l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Oom_N`02Kg/56<H4Kg/1>Lh100000003001oogoo011oo`0501moo`0OOol07`02Ool00`0OOomo
o`02Ool01@0OOomoogoo01l00Woo00<07gooOol02Woo0P001goo0P0027oo0P00ogooH7oo00<07goo
Ool017oo00<07gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007oo
Ool047oo00<07gooOol017oo00@07gooOomoo`807`=oo`0301moogoo00eoo`80015oo`800?moof1o
o`0301moogoo00Aoo`0301moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh10000
0003001oogoo011oo`0301moogoo00Aoo`807`=oo`0301moogoo00807`eoo`@000moo`@00?mooemo
o`807`Ioo`0301moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001o
ogoo031oo`80015oo`800?mooeioo`0301moo`0O00Ioo`0301moogoo009oo`03001ooaS600<HaP=>
O`@HaP5_N`4icP40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`0301moogoo009oo`04001o
ofmk6<H7CWl011S6Kg]_NcW>0@0000000`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07goo
Ool00Woo00D007ooKg]_NaS600E>O`056<I_NfmkKg/icP0100000003001oogoo0?mooj1oo`H07`9o
o`D07`Aoo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo0?mook5oo`03
001oofmk00=_N`036<I>OaS600E_N`4icP40000000<007ooOol0ogoo/Goo00<007ooKg/016mk00<H
aVmkKg/016mk0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`0;Kg/1>Lh100000003001oogoo
0?mook5oo`03001oogoo00]oo`4icP400000o`00a00000000`00CWm>O`3oCWo0CWl100000003001W
>GNm0?mg_Kmg_@5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW
>@09IcT00gNm>LhicP2S>Li?MkfU>Lh00gNm6<IW>@09IcT00gNm>LhicP04>Lh1CWl100000003001W
>GNm00Ig_@036<IW>AS600LHaP03IcUg_GNm0:ag_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag
_@80009g_@8000=g_@@000Ag_@D000]g_@800:mg_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40
000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm
0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P00
2GNmYCW>00=g_AS6IcT01eJe00<HaVLiMkd01SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06
E[D00aS6IcUg_@2/Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002
Mkd20006Mkd20002Mkd2000;Mkd2002_Mkd00aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl100000003
001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g
_@8000=g_@8000=g_@8000=g_@80009g_@H0009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi
00DHaP9F]@036<IW>GNm00HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0
[7Nm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P00
0WNm0P000WNm0P000WNm1@0017Nm0P00[gNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40
000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm
0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNm
YCW>00=g_AS6IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe
00IF]@036<IW>GNm0:ag_@80009g_@80009g_@D000=g_@@0009g_@80009g_@@0009g_@8000=g_@@0
00Ag_@D000]g_@800:mg_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>
00DicP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@8000]g_@8000Qg_@8000=g_@8000ig
_@8000Yg_@<000Ug_JDicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg
_@06Mkd00aS6IcUW>@08IcV]Mkd20002Mkd2000;Mkd20003Mkd20003Mkd20003Mkd2000>Mkd2000;
Mkd2002_Mkd00aS6IcUW>@08IcT7Mkd1CWl100000003001W>CW>00DicP03MkdHaQS600THaP03Mkdi
cSW>0:<icTmg_JDicP03MkdHaQS600THaP03MkdicSW>00@icP5>O`40000000<006LiMkd0ogNm_gNm
0Dio0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W>FLi0?mW>KmW>@5>O`400000o`00a000
0000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[
"When we start typing, a new input cell is created at the cell insertion \
point. (Pressing \[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified] \
afterward places the matching output cell directly under the new input cell, \
and places the cell insertion point beneath the new output cell.)"], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000Ya000`40O003h00O00<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogooXGoo1@0O0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/100000003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo01Uoo`807`Ioo`807omooh9oo`0301moogoo
00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomo
o`0IOol00`0OOomoo`06Ool00`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02
Ool00`0OOol07`02Ool401l2Ool00`0OOomoo`0;Ool00`00Oomoo`02Ool50004Ool00`00Oomoo`03
Ool30003Ool30006Ool00`00Oomoo`02Ool30005Ool30005Ool00`00Oomoo`03Ool30003Ool30004
Ool50003Ool30003Ool40003Ool50002Ool40004Ool30004Ool30005Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool30003Ool50004Ool30002Ool3003BOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02goo00@07gooOol07`9oo`06
01moo`0O01moo`0O0Woo00@07gooOol07`Eoo`0301moo`0O00<07`Qoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo009oo`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`05Ool0
1@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001o
ogoo00=oo`03001oogoo009oo`07001oogooOol007oo000017oo00@007ooOol000=oo`03001oo`00
00Aoo`04001oogoo0003Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol017oo00<007oo
Ool00Woo00D007ooOomoo`00009oo`05001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`3?
Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@00
00000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool01@0OOomoogoo
01l017oo00<07gooOol02goo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo00D007oo
Oomoo`0000Ioo`03001oogoo009oo`03001oogoo00Ioo`04001oogoo0003Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomo
o`0000Ioo`05001oogooOol00009Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo009o
o`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool60006Ool0
0`00Oomoo`3>Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo
00<07gooOol00Woo00H07gooOomoo`0OOol401l9Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00
Oomoogoo00000goo00@007ooOomoo`@000Eoo`03001oogoo009oo`@0009oo`05001oogooOol00005
Ool01@00Oomoogoo00000goo00@007ooOomoo`@000Aoo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`02Ool00`00Oomoo`06Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo
00=oo`03001oogoo00Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo
00<007ooOol00Woo1000d7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo
01l07goo01l5Ool0100OOomoo`0O3Woo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00Woo
0`000goo00D007ooOomoo`0000Eoo`05001oogooOol00003Ool01000Oomoogoo0`001Woo00@007oo
Oomoo`@000=oo`05001oogooOol00004Ool00`00Oomoo`03Ool30003Ool40006Ool01000Oomoogoo
100017oo0`0017oo0`001Woo00<007ooOol017oo00D007ooOomoo`0000=oo`03001oogoo00=oo`05
001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol0bgoo100O1Woo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7
Ool0100OOomoo`0O0Woo00@07gooOol07`9oo`0301moogoo00aoo`03001oogoo00=oo`03001oogoo
00Eoo`05001oogooOol00003Ool01000Oomoo`000goo00<007ooOol00goo00D007ooOomoo`0000=o
o`04001oogoo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Aoo`03
001oogoo009oo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007oo
Ool017oo00D007ooOomoo`00009oo`05001oogooOol00005Ool00`00Oomoo`04Ool01@00Oomoogoo
00000goo00@007ooOol000=oo`07001oogooOol007oo00000goo00D007ooOomoo`000=1oo`0301mo
ogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001o
ogoo00aoo`807`]oo`807`9oo`807`9oo`807`]oo`05001oogooOol00002Ool30004Ool01@00Oomo
ogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D0
07ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol00goo00D0
07ooOomoo`00009oo`<000Aoo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo0000
0Woo00<007ooOol017oo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo0000
0Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo000017oo0P000goo00D0
07ooOomoo`000<moo`807`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`0^Ool50004Ool00`00Oomoo`02Ool50003Ool30004Ool30003Ool50003
Ool30004Ool30003Ool50004Ool30003Ool30005Ool00`00Oomoo`03Ool30003Ool50003Ool30003
Ool50003Ool30004Ool30003Ool50002Ool50003Ool30004Ool30006Ool00`00Oomoo`02Ool3003?
Ool00`0OOol07`06Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@00
00000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonPOol601l6Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo
[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo0?moojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?moojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@00
00000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>
009_N`40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>
00=_N`4icP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/100000003001oogoo0?mooj5oo`D07`Ioo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0GOol201l6Ool2
01ooOon4Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo
00<07goo01l00Woo00<07goo01l00Woo100O0Woo00@07gooOol07`]oo`@000]oo`D000=oo`@00?mo
oe]oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh1
00000003001oogoo011oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo00=oo`0301moogoo
009oo`@07`Eoo`80009oo`8000Yoo`80009oo`800003Ool00000009oo`800?mooeYoo`0301moogoo
00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomo
o`0@Ool00`0OOol07`02Ool00`0OOol07`03Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool2000>Ool2
00000goo00000002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0@Ool0200OOol07`0OOol07goo01l4Ool01@0O
Oomoogoo01l017oo100O2Goo0P003Woo0P0000=oo`0000000Woo0P00ogooFWoo00<07gooOol017oo
00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo011o
o`0501moo`0OOol07`02Ool00`0OOomoo`03Ool0100OOomoo`0O0Woo00<07gooOol02Woo0`002goo
1@000Woo0P000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00Di
cVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07gooOol017oo00@07gooOol07`9oo`04
01moogoo01lAOol20002Ool20002Ool20002Ool20005Ool20002Ool2003oOomJOol00`0OOomoo`04
Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
47oo00<07gooOol017oo0P0O0Woo0P0O0Woo0P0O3Goo0P000Woo0P000goo10000goo0P001Goo0P00
0Woo0P00ogooFGoo0P0O1Woo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0;goo10001Goo0P0017oo1@000goo1000ogooFGoo00<07goo01l01Woo00<0
7gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj9o
o`0401moogoo01l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@00
00000`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_
N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
o`00]@0000=_NcW>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`3oOonQOol501l2Ool501l4Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`40000000<007ooOol0ogooYGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol06Goo0P0O1Woo0P0OogooPWoo00<07goo
Ool017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo01Uoo`0301moogoo00Ioo`0301moogoo0?mooh1oo`0301moogoo00Aoo`0301moogoo009oo`03
001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00aoo`807`Aoo`0301moo`0O
009oo`0301moo`0O00=oo`807`=oo`0301moogoo0?mooh1oo`0301moogoo00Aoo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O
0Woo00H07goo01l07goo01l2Ool0100OOomoo`0O0Woo00D07gooOol07goo00@07`Moo`<00003Ool0
07oo015oo`03001oo`0000800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009o
o`0301moo`0O009oo`0301moogoo00=oo`0401moogoo01l;Ool01@00Oomoogoo000057oo00D007oo
Oomoo`000?mooeUoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02
Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Ioo`05001oogooOol0000:Ool50005Ool01@00
Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l0
7goo01l5Ool0100OOomoo`0O37oo100057oo00D007ooOomoo`000?mooeUoo`0301moogoo00Aoo`03
01moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0
100OOomoo`0O1goo00@07gooOol07`9oo`0401moogoo01l2Ool00`0OOomoo`0=Ool00`00Oomoo`0B
Ool01@00Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00Di
cVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O2goo0P0O0Woo0P0O0Woo0P0O2goo1000
0Woo10003goo10000Woo1000ogooDGoo100O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo03Eoo`03001oogoo00moo`03001oogoo00Aoo`03001o
ogoo0?mooeAoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo03Ioo`03001oogoo00eoo`8000Moo`03001oogoo0?mooe9oo`807`Io
o`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0g
Ool00`00Oomoo`0FOol00`00Oomoo`3oOom@Ool00`0OOol07`06Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0dOol01000Oomoo`005Goo00@007oo
Ool00?mooe5oo`0401moogoo01l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`40000000<007ooOol0=Goo0P005goo0P00ogooDGoo00D07gooOomoo`0O00Ioo`0301mo
ogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj1oo`H0
7`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomo
o`3oOon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00
Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?moojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXGoo1@0O1Woo00<07gooOol00Woo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0>goo1000ogooIWoo00<07gooOol0
17oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
01Moo`807`Ioo`807a]oo`8001]oo`@000Ioo`8001eoo`8000]oo`8001ioo`8000Eoo`@00>Yoo`03
01moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo01Moo`0301moogoo00Ioo`0301moogoo01Uoo`8001]oo`8000Moo`8001moo`8000Uoo`80
021oo`8000Ioo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`03Ool201l3Ool0
100OOomoo`0O2Woo1P0000=oo`0000000Woo0P0000=oo`0000000`000goo2@0000=oo`0000000Woo
1P0000=oo`0000001goo0P0017oo1P001Goo0P001Goo1P000goo0P002Goo0P0017oo1P003Goo1P00
0goo0P001Woo0P00jWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l00Woo00@07gooOol0
7`9oo`0301moogoo009oo`@07`Ioo`80009oo`03001oo`0000800004Ool00000Ool20002Ool20000
0goo00000002Ool200000goo00000002Ool200000goo00000002Ool20002Ool20006Ool20004Ool2
0002Ool20006Ool20006Ool20002Ool20003Ool20007Ool20004Ool20002Ool2000?Ool20002Ool2
0003Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00Di
cVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l01Goo00@07goo
Ool07`ioo`8000Eoo`@0009oo`80009oo`800003Ool00000009oo`800003Ool00000009oo`800003
Ool00000009oo`80009oo`8000Ioo`8000Aoo`80009oo`8000Aoo`H000Aoo`80009oo`8000=oo`80
00Moo`8000Aoo`80009oo`8000Eoo`D000Eoo`80009oo`8000=oo`8000Eoo`800>Yoo`0301moogoo
00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool401l6Ool200000goo001oo`03
Ool20003Ool20002Ool20002Ool500000goo00000002Ool200000goo00000002Ool20002Ool20006
Ool20005Ool50006Ool20006Ool20002Ool20003Ool20007Ool20005Ool5000?Ool20002Ool20003
Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo00=oo`0401mo
ogoo01l2Ool00`0OOomoo`09Ool40003Ool40002Ool20002Ool20005Ool200001Goo00000000Ool0
0P0000=oo`0000000Woo0P000Woo0P001Woo0P0027oo0P001Woo0P001Woo0P000Woo0P000goo0P00
1goo0P0027oo0P003goo0P000Woo0P000goo0P001Goo0P00jWoo00<07gooOol017oo00<07gooOol0
0Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07gooOol0
17oo00@07gooOol07`9oo`0401moogoo01l>Ool20004Ool300000goo00000002000017oo00000000
0goo100000Aoo`00001oo`<000=oo`D0009oo`8000Moo`8000Aoo`@000moo`D000=oo`8000Uoo`80
00Aoo`@0011oo`D000=oo`8000Ioo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOomoo`04Ool201l2Ool2
01l2Ool201l>Ool20002Ool00`00Oomoo`0OOol20002Ool20007Ool2000GOol20006Ool20009Ool2
000HOol20006Ool20006Ool2003YOol201l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0^Ool6000POol30002Ool40006Ool2000EOol30005Ool2
000;Ool2000FOol30005Ool20005Ool4003XOol00`0OOol07`06Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj5o
o`0501moogooOol07`06Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogooX7oo1P0O0Woo1@0O17oo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_
N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/10000
0003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk
>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo0?mooj5oo`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
0@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol06Goo
00<07gooOol01Woo00<07gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<0
7goo01l017oo00D07gooOomoo`0O00]oo`D00?moog9oo`0301moogoo00Aoo`0301moogoo009oo`05
001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O0Woo
00H07goo01l07goo01l2Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Ioo`05001oogooOol0
003oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0O
Oomoo`02Ool01@0OOomoogoo01l037oo00<007ooOol0ogooLgoo00<07gooOol017oo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00Yoo`0301moogoo
009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogooOol07goo100O27oo
00<007ooOol0ogooLWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l0
7goo01l4Ool01@0OOomoogoo01l03Woo00<007ooOol0ogooKWoo100O1Woo00<07gooOol00Woo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7Ool0
100OOomoo`0O0goo0P0O0goo00<07gooOol02Goo00D007ooOomoo`000?moog9oo`0301moogoo00Ao
o`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00ao
o`807`]oo`807`=oo`0301moogoo00807`]oo`05001oogooOol0003oOomaOol201l6Ool00`0OOomo
o`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0;goo0`00ogoo
LGoo00<07goo01l01Woo00<07gooOol00Woo00<001S66<H031S60@0000000`00Oomoo`3oOonROol0
100OOomoo`0O1Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonQOol0
1@0OOomoogoo01l01Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonP
Ool601l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojao
o`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07goo
Ool00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool0
0`00IcUF]@02E[D6<I<3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe
009F]@IW>@=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C
0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H1
00000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<0
07ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3o
OonQOol501l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6CWl3E[D16<H100000003001oogoo0?mo
ojEoo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe00]F]@4HaP40000000<007ooOol05goo
0P0O1Woo0P0OogooQ7oo00<07gooOol017oo00<07gooOol00Woo00<006LiIcT02fLi0AS60@000000
0`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00:DXYBP0<:DX100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501mo
ogooOol07`02Ool00`0OOomoo`08Ool60005Ool20006Ool6003oOomNOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool@00000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol0
7`04Ool401l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
>LhicP0<>Lh100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol0
7`0?Ool20005Ool60006Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`0;
Kg/1>Lh100000003001oogoo011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool4
01l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`02
Kg/56<H4Kg/1>Lh100000003001oogoo011oo`0501moo`0OOol07`02Ool00`0OOomoo`02Ool01@0O
Oomoogoo01l00Woo00<07gooOol02Woo0P001goo0P0027oo0P00ogooH7oo00<07gooOol017oo00<0
7gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol047oo00<0
7gooOol017oo00@07gooOomoo`807`=oo`0301moogoo00eoo`80015oo`800?moof1oo`0301moogoo
00Aoo`0301moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo
011oo`0301moogoo00Aoo`807`=oo`0301moogoo00807`eoo`@000moo`@00?mooemoo`807`Ioo`03
01moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo031oo`80
015oo`800?mooeioo`0301moo`0O00Ioo`0301moogoo009oo`03001ooaS600<HaP=>O`@HaP5_N`4i
cP40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`0301moogoo009oo`04001oofmk6<H7CWl0
11S6Kg]_NcW>0@0000000`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D0
07ooKg]_NaS600E>O`056<I_NfmkKg/icP0100000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03
001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo0?mook5oo`03001oofmk00=_
N`036<I>OaS600E_N`4icP40000000<007ooOol0ogoo/Goo00<007ooKg/016mk00<HaVmkKg/016mk
0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`0;Kg/1>Lh100000003001oogoo0?mook5oo`03
001oogoo00]oo`4icP400000o`00a00000000`00CWm>O`3oCWo0CWl100000003001W>GNm0?mg_Kmg
_@5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm
>LhicP2S>Li?MkfU>Lh00gNm6<IW>@09IcT00gNm>LhicP04>Lh1CWl100000003001W>GNm00Ig_@03
6<IW>AS600LHaP03IcUg_GNm0:ag_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@80
00=g_@@000Ag_@D000]g_@800:mg_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40000000<006Li
>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P00
0gNm0P000gNm0P000gNm0P000WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYCW>00=g
_AS6IcT01eJe00<HaVLiMkd01SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg
_@2/Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd2
0002Mkd2000;Mkd2002_Mkd00aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl100000003001W>CW>00Di
cP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@80
00=g_@8000=g_@80009g_@H0009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00DHaP9F]@03
6<IW>GNm00HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm
0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm
0P000WNm1@0017Nm0P00[gNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li
>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P00
0gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6
IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW
>GNm0:ag_@80009g_@80009g_@D000=g_@@0009g_@80009g_@@0009g_@8000=g_@@000Ag_@D000]g
_@800:mg_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdH
aVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@8000]g_@8000Qg_@8000=g_@8000ig_@8000Yg_@<0
00Ug_JDicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6
IcUW>@08IcV]Mkd20002Mkd2000;Mkd20003Mkd20003Mkd20003Mkd2000>Mkd2000;Mkd2002_Mkd0
0aS6IcUW>@08IcT7Mkd1CWl100000003001W>CW>00DicP03MkdHaQS600THaP03MkdicSW>0:<icTmg
_JDicP03MkdHaQS600THaP03MkdicSW>00@icP5>O`40000000<006LiMkd0ogNm_gNm0Dio0@000000
0`00IcUg_@3oMkfoMkd1CWl100000003001W>FLi0?mW>KmW>@5>O`400000o`00a0000000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 167},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
To create a text cell at the current cell insertion point, we first \
type some text into a new cell. By default, new cells are input cells, so the \
result is the following.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000`A000`40O003h00O00<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
ok5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonQOol501l2
Ool501l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonUOol0
0`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol06Goo0P0O1Woo0P0OogooPWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol06Goo00<07gooOol01Woo00<07gooOol0
ogooP7oo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo00aoo`807`Aoo`0301moo`0O009oo`0301moo`0O009oo`@07`9oo`0301mo
ogoo00]oo`03001oogoo009oo`D000Aoo`03001oogoo00=oo`<000=oo`<000Ioo`03001oogoo009o
o`<000Eoo`<000Eoo`03001oogoo00=oo`<000=oo`<000Aoo`D000=oo`<000=oo`@000=oo`D0009o
o`@000Aoo`<000Aoo`<000Eoo`03001oogoo00Aoo`03001oogoo00=oo`<000=oo`D000Aoo`<0009o
o`<00=9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh100000003001oogoo00]oo`0401moogoo01l2Ool01P0OOol07`0OOol07`9oo`0401moogoo01l5
Ool00`0OOol07`0301l8Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02Ool01@00Oomo
ogoo00001Goo00<007ooOol00goo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo009o
o`03001oogoo009oo`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01`00Oomo
ogoo001oo`0000Aoo`04001oogoo0003Ool00`00Ool00004Ool01000Oomoo`000goo00@007ooOol0
00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00002Ool01@00
Oomoogoo00001Goo00<007ooOol017oo00<007ooOol0cgoo00<07gooOol017oo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00Yoo`0301moogoo009o
o`0301moo`0O009oo`0301moo`0O009oo`0501moogooOol07`04Ool00`0OOomoo`0;Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<0
07ooOol01Woo00@007ooOol000=oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Uoo`04
001oogoo0003Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo
00D007ooOomoo`0000=oo`03001oogoo009oo`H000Ioo`03001oogoo0<ioo`0301moogoo00Aoo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00Yoo`03
01moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogooOol07goo
100O2Goo00<007ooOol00goo00<007ooOol01Goo00D007ooOomoo`0000=oo`04001oogooOol40005
Ool00`00Oomoo`02Ool40002Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000=oo`04001oogoo
Ool40004Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<007ooOol01Woo
00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`04Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`@00=1oo`0301moogoo
00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomo
o`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol07`Eoo`0401moogoo01l>Ool0
0`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`02Ool30003Ool01@00Oomoogoo00001Goo00D0
07ooOomoo`0000=oo`04001oogooOol30006Ool01000Oomoogoo10000goo00D007ooOomoo`0000Ao
o`03001oogoo00=oo`<000=oo`@000Ioo`04001oogooOol40004Ool30004Ool30006Ool00`00Oomo
o`04Ool01@00Oomoogoo00000goo00<007ooOol00goo00D007ooOomoo`00009oo`05001oogooOol0
0003Ool00`00Oomoo`3;Ool401l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0@0000000`00Oomoo`0;Ool0100OOomoo`0O1goo00@07gooOol07`9oo`0401moogoo01l2
Ool00`0OOomoo`0<Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00@007oo
Ool000=oo`03001oogoo00=oo`05001oogooOol00003Ool01000Oomoo`000goo00<007ooOol00goo
00D007ooOomoo`0000Ioo`05001oogooOol00004Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo
00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo00Aoo`05001oogooOol00002Ool01@00
Oomoogoo00001Goo00<007ooOol017oo00D007ooOomoo`0000=oo`04001oogoo0003Ool01`00Oomo
ogoo001oo`0000=oo`05001oogooOol0003@Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol037oo0P0O2goo0P0O0Woo0P0O0Woo
0P0O2goo00D007ooOomoo`00009oo`<000Aoo`05001oogooOol00002Ool01@00Oomoogoo00000Woo
00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00
009oo`05001oogooOol00003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo0`0017oo00D007oo
Oomoo`00009oo`03001oogoo00Aoo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo
00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007oo
Oomoo`00009oo`05001oogooOol00004Ool20003Ool01@00Oomoogoo0000cgoo0P0O1Woo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0;Woo1@0017oo
00<007ooOol00Woo1@000goo0`0017oo0`000goo1@000goo0`0017oo0`000goo1@0017oo0`000goo
0`001Goo00<007ooOol00goo0`000goo1@000goo0`000goo1@000goo0`0017oo0`000goo1@000Woo
1@000goo0`0017oo0`001Woo00<007ooOol00Woo0`00cgoo00<07goo01l01Woo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj9oo`0401moogoo
01l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomo
o`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_Nfmk
Kg/icP02Kg/100000003001oogoo0?mooj1oo`H07`Ioo`0301moogoo009oo`03001_NcW>00=_N`05
>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo009oo`05001_NfmkKg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo[7oo00<07gooOol00Woo
00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo[7oo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`0301mo
ogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojaoo`03
01moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3o
OonQOol501l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol0ogooYGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol05goo0P0O1Woo0P0OogooQ7oo00<07gooOol017oo00<07goo
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo01Moo`0301mo
ogoo00Ioo`0301moogoo0?mooh9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05
>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O009oo`@0
7`9oo`0401moogoo01l;Ool4000;Ool50003Ool4003oOomKOol00`0OOomoo`04Ool00`0OOomoo`02
Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l0
0Woo00<07goo01l00Woo00<07gooOol00goo00<07gooOol00Woo100O1Goo0P000Woo0P002Woo0P00
0Woo0P0000=oo`0000000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l0
0goo00<07gooOol00Woo00<07gooOol03goo0P003Woo0P0000=oo`0000000Woo0P00ogooFWoo00<0
7gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003
001oogoo011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool401l9Ool2000>Ool2
00000goo00000002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0@Ool01@0OOol07goo01l00Woo00<07gooOol0
0goo00@07gooOol07`9oo`0301moogoo00Yoo`<000]oo`D0009oo`80009oo`800?mooeYoo`0301mo
ogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00
Oomoo`0@Ool00`0OOomoo`04Ool0100OOomoo`0O0Woo00@07gooOol07a5oo`80009oo`80009oo`80
009oo`8000Eoo`80009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo011oo`0301moogoo00Aoo`807`9oo`807`9o
o`807`eoo`80009oo`8000=oo`@000=oo`8000Eoo`80009oo`800?mooeUoo`807`Ioo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0_Ool40005Ool2
0004Ool50003Ool4003oOomIOol00`0OOol07`06Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mooj5oo`0501moogoo
Ool07`06Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00
Oomoo`3oOonPOol601l2Ool501l4Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03
001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>
009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000
00<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
0?moojQoo`D07`Aoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0:9o
o`03001oogoo0?moo`Moo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
0@0000000`00Oomoo`2ROol00`00Oomoo`3oOol7Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`2ROol00`00Oomoo`3oOol7Ool00`0OOomoo`02Ool0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0;Goo100000Eoo`000000
07oo00@0009oo`D000=oo`@000Eoo`H0009oo`@000Ioo`@000=oo`@00008Ool00000001oo`00Ool0
009oo`@000Moo`<000=oo`@0009oo`80009oo`8000=oo`<000Ioo`8000=oo`03001oogoo0?moo`Mo
o`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo02io
o`80009oo`800003Ool00000009oo`80009oo`8000Aoo`80009oo`8000Ioo`8000=oo`80009oo`80
00Aoo`80009oo`800003Ool00000009oo`800008Ool00000Ool007oo001oo`80009oo`8000Eoo`80
009oo`04001oo`000002Ool200001Goo00000000Ool00P000Woo0P000Woo00<007ooOol00goo0P00
0goo00<007ooOol0ogoo1goo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo02ioo`80009oo`800003Ool0000000Ioo`8000Aoo`8000Yoo`8000Ioo`<0
00Moo`<00003Ool00000009oo`800008Ool00000Ool007oo001oo`8000Uoo`8000Aoo`8000Ioo`@0
00=oo`8000eoo`03001oogoo0?moo`Moo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/i
cP03Kg/1>Lh100000003001oogoo02ioo`80009oo`800003Ool0000000@0009oo`8000Aoo`H000Io
o`8000Aoo`@000Ioo`@0009oo`80009oo`800008Ool00000Ool007oo001oo`H000Eoo`8000Aoo`H0
00=oo`8000Aoo`8000eoo`03001oogoo0?moo`Moo`0301moogoo009oo`05001_NfmkKg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0^Ool600000goo00000002Ool20002Ool300000goo
001oo`020002Ool20006Ool20003Ool30002Ool00`00Oomoo`02Ool30002Ool01000Ool000000Woo
0P0000=oo`000000100000=oo`0000000Woo0P001Goo0P0017oo0P000Woo0P000Woo10000goo0P00
3Goo00<007ooOol0ogoo1goo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP40000000<007ooOol0;Woo0P000Woo0P000Woo10000Woo0P0000Aoo`000000009oo`@000Eoo`@0
00Aoo`D000Eoo`D0009oo`@00007Ool00000Ool007oo00000goo10001Goo1P000Woo10000Woo0`00
00Aoo`00001oo`H000Yoo`03001oogoo0?moo`Moo`0301moogoo009oo`05001_NfmkKg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0^Ool20002Ool2001:Ool2000COol2000=Ool00`00
Oomoo`3oOol6Ool201l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomo
o`0]Ool4000017oo000000006Woo0P00;Goo0P004goo0P003Goo00<007ooOol0ogoo1Goo00<07goo
01l017oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0:9oo`03001o
ogoo0?moo`Aoo`0401moogoo01l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`2ROol00`00Oomoo`3oOol3Ool01@0OOomoogoo01l017oo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojMoo`H07`Aoo`03001_NcW>00=_N`05>Li_Nfmk
Kg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`3oOonQOol501l2Ool501l4Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`40000000<007ooOol0ogooYGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol06Goo0P0O1Woo0P0OogooPWoo00<07goo
Ool017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo01Uoo`0301moogoo00Ioo`0301moogoo0?mooh1oo`0301moogoo00Aoo`0301moogoo009oo`03
001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00aoo`807`Aoo`0301moo`0O
009oo`0301moo`0O00=oo`807`=oo`0301moogoo0?mooh1oo`0301moogoo00Aoo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O
0Woo00H07goo01l07goo01l2Ool0100OOomoo`0O0Woo00D07gooOol07goo00@07`Moo`<00003Ool0
07oo015oo`03001oo`0000800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009o
o`0301moo`0O009oo`0301moogoo00=oo`0401moogoo01l;Ool01@00Oomoogoo000057oo00D007oo
Oomoo`000?mooeUoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02
Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Ioo`05001oogooOol0000:Ool50005Ool01@00
Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l0
7goo01l5Ool0100OOomoo`0O37oo100057oo00D007ooOomoo`000?mooeUoo`0301moogoo00Aoo`03
01moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0
100OOomoo`0O1goo00@07gooOol07`9oo`0401moogoo01l2Ool00`0OOomoo`0=Ool00`00Oomoo`0B
Ool01@00Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00Di
cVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O2goo0P0O0Woo0P0O0Woo0P0O2goo1000
0Woo10003goo10000Woo1000ogooDGoo100O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo03Eoo`03001oogoo00moo`03001oogoo00Aoo`03001o
ogoo0?mooeAoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo03Ioo`03001oogoo00eoo`8000Moo`03001oogoo0?mooe9oo`807`Io
o`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0g
Ool00`00Oomoo`0FOol00`00Oomoo`3oOom@Ool00`0OOol07`06Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0dOol01000Oomoo`005Goo00@007oo
Ool00?mooe5oo`0401moogoo01l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`40000000<007ooOol0=Goo0P005goo0P00ogooDGoo00D07gooOomoo`0O00Ioo`0301mo
ogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj1oo`H0
7`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomo
o`3oOon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00
Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40
000000<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?moojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXGoo1@0O1Woo00<07gooOol00Woo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0>goo1000ogooIWoo00<07gooOol0
17oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
01Moo`807`Ioo`807a]oo`8001]oo`@000Ioo`8001eoo`8000]oo`8001ioo`8000Eoo`@00>Yoo`03
01moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo01Moo`0301moogoo00Ioo`0301moogoo01Uoo`8001]oo`8000Moo`8001moo`8000Uoo`80
021oo`8000Ioo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`03Ool201l3Ool0
100OOomoo`0O2Woo1P0000=oo`0000000Woo0P0000=oo`0000000`000goo2@0000=oo`0000000Woo
1P0000=oo`0000001goo0P0017oo1P001Goo0P001Goo1P000goo0P002Goo0P0017oo1P003Goo1P00
0goo0P001Woo0P00jWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l00Woo00@07gooOol0
7`9oo`0301moogoo009oo`@07`Ioo`80009oo`03001oo`0000800004Ool00000Ool20002Ool20000
0goo00000002Ool200000goo00000002Ool200000goo00000002Ool20002Ool20006Ool20004Ool2
0002Ool20006Ool20006Ool20002Ool20003Ool20007Ool20004Ool20002Ool2000?Ool20002Ool2
0003Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00Di
cVmkKg]_NcW>009_N`40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l01Goo00@07goo
Ool07`ioo`8000Eoo`@0009oo`80009oo`800003Ool00000009oo`800003Ool00000009oo`800003
Ool00000009oo`80009oo`8000Ioo`8000Aoo`80009oo`8000Aoo`H000Aoo`80009oo`8000=oo`80
00Moo`8000Aoo`80009oo`8000Eoo`D000Eoo`80009oo`8000=oo`8000Eoo`800>Yoo`0301moogoo
00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool401l6Ool200000goo001oo`03
Ool20003Ool20002Ool20002Ool500000goo00000002Ool200000goo00000002Ool20002Ool20006
Ool20005Ool50006Ool20006Ool20002Ool20003Ool20007Ool20005Ool5000?Ool20002Ool20003
Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo00=oo`0401mo
ogoo01l2Ool00`0OOomoo`09Ool40003Ool40002Ool20002Ool20005Ool200001Goo00000000Ool0
0P0000=oo`0000000Woo0P000Woo0P001Woo0P0027oo0P001Woo0P001Woo0P000Woo0P000goo0P00
1goo0P0027oo0P003goo0P000Woo0P000goo0P001Goo0P00jWoo00<07gooOol017oo00<07gooOol0
0Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07gooOol0
17oo00@07gooOol07`9oo`0401moogoo01l>Ool20004Ool300000goo00000002000017oo00000000
0goo100000Aoo`00001oo`<000=oo`D0009oo`8000Moo`8000Aoo`@000moo`D000=oo`8000Uoo`80
00Aoo`@0011oo`D000=oo`8000Ioo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_Nfmk
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool00`0OOomoo`04Ool201l2Ool2
01l2Ool201l>Ool20002Ool00`00Oomoo`0OOol20002Ool20007Ool2000GOol20006Ool20009Ool2
000HOol20006Ool20006Ool2003YOol201l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0^Ool6000POol30002Ool40006Ool2000EOol30005Ool2
000;Ool2000FOol30005Ool20005Ool4003XOol00`0OOol07`06Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj5o
o`0501moogooOol07`06Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogooX7oo1P0O0Woo1@0O17oo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_
N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/10000
0003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk
>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo0?mooj5oo`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
0@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol06Goo
00<07gooOol01Woo00<07gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<0
7goo01l017oo00D07gooOomoo`0O00]oo`D00?moog9oo`0301moogoo00Aoo`0301moogoo009oo`05
001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O0Woo
00H07goo01l07goo01l2Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Ioo`05001oogooOol0
003oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0O
Oomoo`02Ool01@0OOomoogoo01l037oo00<007ooOol0ogooLgoo00<07gooOol017oo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00Yoo`0301moogoo
009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogooOol07goo100O27oo
00<007ooOol0ogooLWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo01l0
7goo01l4Ool01@0OOomoogoo01l03Woo00<007ooOol0ogooKWoo100O1Woo00<07gooOol00Woo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7Ool0
100OOomoo`0O0goo0P0O0goo00<07gooOol02Goo00D007ooOomoo`000?moog9oo`0301moogoo00Ao
o`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo00ao
o`807`]oo`807`=oo`0301moogoo00807`]oo`05001oogooOol0003oOomaOol201l6Ool00`0OOomo
o`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0;goo0`00ogoo
LGoo00<07goo01l01Woo00<07gooOol00Woo00<001S66<H031S60@0000000`00Oomoo`3oOonROol0
100OOomoo`0O1Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonQOol0
1@0OOomoogoo01l01Woo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`3oOonP
Ool601l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojao
o`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07goo
Ool00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool0
0`00IcUF]@02E[D6<I<3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe
009F]@IW>@=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C
0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H1
00000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP40000000<0
07ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3o
OonQOol501l6Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6CWl3E[D16<H100000003001oogoo0?mo
ojEoo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe00]F]@4HaP40000000<007ooOol05goo
0P0O1Woo0P0OogooQ7oo00<07gooOol017oo00<07gooOol00Woo00<006LiIcT02fLi0AS60@000000
0`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00:DXYBP0<:DX100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501mo
ogooOol07`02Ool00`0OOomoo`08Ool60005Ool20006Ool6003oOomNOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool@00000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol0
7`04Ool401l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
>LhicP0<>Lh100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00Aoo`0501moogooOol0
7`0?Ool20005Ool60006Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`0;
Kg/1>Lh100000003001oogoo011oo`0801moo`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool4
01l7Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`02
Kg/56<H4Kg/1>Lh100000003001oogoo011oo`0501moo`0OOol07`02Ool00`0OOomoo`02Ool01@0O
Oomoogoo01l00Woo00<07gooOol02Woo0P001goo0P0027oo0P00ogooH7oo00<07gooOol017oo00<0
7gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol047oo00<0
7gooOol017oo00@07gooOomoo`807`=oo`0301moogoo00eoo`80015oo`800?moof1oo`0301moogoo
00Aoo`0301moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo
011oo`0301moogoo00Aoo`807`=oo`0301moogoo00807`eoo`@000moo`@00?mooemoo`807`Ioo`03
01moogoo009oo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo031oo`80
015oo`800?mooeioo`0301moo`0O00Ioo`0301moogoo009oo`03001ooaS600<HaP=>O`@HaP5_N`4i
cP40000000<007ooOol0ogooXWoo00@07gooOol07`Ioo`0301moogoo009oo`04001oofmk6<H7CWl0
11S6Kg]_NcW>0@0000000`00Oomoo`3oOonQOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00D0
07ooKg]_NaS600E>O`056<I_NfmkKg/icP0100000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`03
001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo0?mook5oo`03001oofmk00=_
N`036<I>OaS600E_N`4icP40000000<007ooOol0ogoo/Goo00<007ooKg/016mk00<HaVmkKg/016mk
0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`0;Kg/1>Lh100000003001oogoo0?mook5oo`03
001oogoo00]oo`4icP400000o`00a00000000`00CWm>O`3oCWo0CWl100000003001W>GNm0?mg_Kmg
_@5>O`40000000<006LiMkd0ogNm_gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm
>LhicP2S>Li?MkfU>Lh00gNm6<IW>@09IcT00gNm>LhicP04>Lh1CWl100000003001W>GNm00Ig_@03
6<IW>AS600LHaP03IcUg_GNm0:ag_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@80
00=g_@@000Ag_@D000]g_@800:mg_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40000000<006Li
>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P00
0gNm0P000gNm0P000gNm0P000WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYCW>00=g
_AS6IcT01eJe00<HaVLiMkd01SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg
_@2/Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd2
0002Mkd2000;Mkd2002_Mkd00aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl100000003001W>CW>00Di
cP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@80
00=g_@8000=g_@80009g_@H0009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00DHaP9F]@03
6<IW>GNm00HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P000WNm
0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm
0P000WNm1@0017Nm0P00[gNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li
>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P00
0gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6
IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW
>GNm0:ag_@80009g_@80009g_@D000=g_@@0009g_@80009g_@@0009g_@8000=g_@@000Ag_@D000]g
_@800:mg_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdH
aVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@8000]g_@8000Qg_@8000=g_@8000ig_@8000Yg_@<0
00Ug_JDicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6
IcUW>@08IcV]Mkd20002Mkd2000;Mkd20003Mkd20003Mkd20003Mkd2000>Mkd2000;Mkd2002_Mkd0
0aS6IcUW>@08IcT7Mkd1CWl100000003001W>CW>00DicP03MkdHaQS600THaP03MkdicSW>0:<icTmg
_JDicP03MkdHaQS600THaP03MkdicSW>00@icP5>O`40000000<006LiMkd0ogNm_gNm0Dio0@000000
0`00IcUg_@3oMkfoMkd1CWl100000003001W>FLi0?mW>KmW>@5>O`400000o`00a0000000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 193},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
To change the input cell into a text cell, we first select the \
input cell bracket by clicking it with the mouse pointer.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000720000_Q000`40O003h00O00<007ooOol0ogoo
/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogoo/Goo00D006mkKg]_
NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_Nfmk
Kg/icP03Kg/1>Lh00003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
00000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3o
OonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo/Goo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/00003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh00003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomo
o`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOonaOol01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogooXGoo1@0O0Woo1@0O17oo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooYGoo00<07gooOol017oo00<0
7gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo01Uoo`807`Io
o`807omooh9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh00003001oogoo01Uoo`0301moogoo00Ioo`0301moogoo0?mooh1oo`0301moogoo00Aoo`03
01moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0<Ool201l4
Ool00`0OOol07`02Ool00`0OOol07`02Ool401l2Ool00`0OOomoo`0;Ool00`00Oomoo`02Ool50004
Ool00`00Oomoo`03Ool30003Ool30006Ool00`00Oomoo`02Ool30005Ool30005Ool00`00Oomoo`03
Ool30003Ool30004Ool50003Ool30003Ool40003Ool50002Ool40004Ool30004Ool30005Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool30003Ool50004Ool30002Ool3003BOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0;Ool0100OOomo
o`0O0Woo00H07goo01l07goo01l2Ool0100OOomoo`0O1Goo00<07goo01l00`0O27oo00<007ooOol0
17oo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00=oo`03001o
ogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo0000
1Goo00<007ooOol00goo00<007ooOol00Woo00L007ooOomoo`00Ool00004Ool01000Oomoo`000goo
00<007oo000017oo00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Eoo`03001oogoo00Aoo`03
001oogoo0<moo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk
>Lh00Vmk00000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool01@0O
Oomoogoo01l017oo00<07gooOol02goo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo
00D007ooOomoo`0000Ioo`03001oogoo009oo`03001oogoo00Ioo`04001oogoo0003Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<007ooOol00Woo00D0
07ooOomoo`0000Ioo`05001oogooOol00009Ool01000Oomoo`000goo00@007ooOol000=oo`03001o
ogoo009oo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool6
0006Ool00`00Oomoo`3>Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>00000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02
Ool00`0OOomoo`02Ool01P0OOomoogoo01moo`@07`Uoo`03001oogoo00=oo`03001oogoo00Eoo`05
001oogooOol00003Ool01000Oomoogoo10001Goo00<007ooOol00Woo10000Woo00D007ooOomoo`00
00Eoo`05001oogooOol00003Ool01000Oomoogoo100017oo00<007ooOol00Woo00D007ooOomoo`00
00Ioo`03001oogoo009oo`03001oogoo00Ioo`04001oogoo0003Ool01000Oomoo`000goo00<007oo
Ool00goo00<007ooOol017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003
Ool00`00Oomoo`02Ool4003@Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`0000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00H07goo
01l07goo01l5Ool0100OOomoo`0O3Woo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00Woo
0`000goo00D007ooOomoo`0000Eoo`05001oogooOol00003Ool01000Oomoogoo0`001Woo00@007oo
Oomoo`@000=oo`05001oogooOol00004Ool00`00Oomoo`03Ool30003Ool40006Ool01000Oomoogoo
100017oo0`0017oo0`001Woo00<007ooOol017oo00D007ooOomoo`0000=oo`03001oogoo00=oo`05
001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol0bgoo100O1Woo00<07gooOol00Woo
00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol02goo00@07gooOol07`Moo`04
01moogoo01l2Ool0100OOomoo`0O0Woo00<07gooOol037oo00<007ooOol00goo00<007ooOol01Goo
00D007ooOomoo`0000=oo`04001oogoo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00@0
07ooOol000=oo`03001oogoo00=oo`05001oogooOol00006Ool01@00Oomoogoo000017oo00<007oo
Ool00Woo00D007ooOomoo`00009oo`03001oogoo00Aoo`05001oogooOol00002Ool00`00Oomoo`04
Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Eoo`03001oogoo00Aoo`05001oogooOol00003
Ool01000Oomoo`000goo00L007ooOomoo`00Ool00003Ool01@00Oomoogoo0000d7oo00<07gooOol0
17oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo00ao
o`807`]oo`807`9oo`807`9oo`807`]oo`05001oogooOol00002Ool30004Ool01@00Oomoogoo0000
0Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomo
o`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol00goo00D007ooOomo
o`00009oo`<000Aoo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<0
07ooOol017oo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo00D0
07ooOomoo`00009oo`05001oogooOol00002Ool01@00Oomoogoo000017oo0P000goo00D007ooOomo
o`000<moo`807`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003
001oogoo02ioo`D000Aoo`03001oogoo009oo`D000=oo`<000Aoo`<000=oo`D000=oo`<000Aoo`<0
00=oo`D000Aoo`<000=oo`<000Eoo`03001oogoo00=oo`<000=oo`D000=oo`<000=oo`D000=oo`<0
00Aoo`<000=oo`D0009oo`D000=oo`<000Aoo`<000Ioo`03001oogoo009oo`<00<moo`0301moo`0O
00Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3o
OonROol0100OOomoo`0O1Woo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4i
cP0000<007ooOol0ogooXGoo00D07gooOomoo`0O00Ioo`0301moogoo009oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOonPOol601l6Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?moojaoo`0301moogoo009oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo0?moojaoo`0301moogoo009oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo[7oo00<07gooOol00Woo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooXGoo1@0O1Woo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?moojEoo`0301moogoo
00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo01Mo
o`807`Ioo`807omoohAoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOon2Ool00`0OOomo
o`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0@
Ool00`0OOol07`02Ool00`0OOol07`02Ool401l2Ool0100OOomoo`0O2goo10002goo1@000goo1000
ogooFgoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/00003001oogoo011oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo00=oo`0301moogoo
009oo`@07`Eoo`80009oo`8000Yoo`80009oo`800003Ool00000009oo`800?mooeYoo`0301moogoo
00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo011o
o`0301moo`0O009oo`0301moo`0O00=oo`0301moogoo009oo`0301moogoo00moo`8000ioo`800003
Ool00000009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0@Ool0200OOol07`0OOol07goo01l4Ool01@0OOomoogoo
01l017oo100O2Goo0P003Woo0P0000=oo`0000000Woo0P00ogooFWoo00<07gooOol017oo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol047oo00D07goo01mo
o`0O009oo`0301moogoo00=oo`0401moogoo01l2Ool00`0OOomoo`0:Ool3000;Ool50002Ool20002
Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`0000<007ooOol047oo00<07gooOol017oo00@07gooOol07`9oo`0401moogoo01lAOol2
0002Ool20002Ool20002Ool20005Ool20002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0@Ool00`0OOomoo`04Ool2
01l2Ool201l2Ool201l=Ool20002Ool20003Ool40003Ool20005Ool20002Ool2003oOomIOol201l6
Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0;goo
10001Goo0P0017oo1@000goo1000ogooFGoo00<07goo01l01Woo00<07gooOol00Woo00<006mk>Lh0
0fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooXWoo00@07gooOol07`Ioo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOonQOol01@0OOomo
ogoo01l01Woo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007oo
Ool0ogooX7oo1P0O0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001o
ogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo0?mook5oo`05
001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`0000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?moojQo
o`@00003Ool007oo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo0?mo
ojMoo`D00003Ool007oo009oo`05001oogooKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomo
o`3oOonWOol00`00OW=nL`02OW<00goo001oo`03Ool00`00Oom_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>00000`00Oomoo`3oOonWOol500000goo001oo`02Ool01@00Oom_Nfmk>Lh00fmk00DicVmkKg]_
NcW>009_N`0000<007ooOol0ogooYgoo1@0000Qoo`00Oomoo`00Oom_NcW>0fmk00DicVmkKg]_NcW>
00=_N`4icP0000<007ooOol0ogooYgoo1@0000Aoo`00Ool000Yoo`=_N`4icP5_N`5_N`0000<007oo
Ool0;Goo100000Eoo`00000007oo00@0009oo`D000=oo`@000Eoo`H0009oo`@000Ioo`@000=oo`@0
0008Ool00000001oo`00Ool0009oo`@000Moo`<000=oo`@0009oo`80009oo`8000=oo`<000Ioo`80
0?moo`Qoo`D00003Ool0000000X00003Oom_NcW>00=_N`4icP0000<007ooOol0;Woo0P000Woo0P00
00=oo`0000000Woo0P000Woo0P0017oo0P000Woo0P001Woo0P000goo0P000Woo0P0017oo0P000Woo
0P0000=oo`0000000Woo0P0000Qoo`00001oo`00Ool007oo0P000Woo0P001Goo0P000Woo00@007oo
0000009oo`800005Ool00000001oo`020002Ool20002Ool00`00Oomoo`03Ool2003oOol8Ool50000
17oo001oo`002Woo0fmk0CW>0Fmk0Fmk00000`00Oomoo`0^Ool20002Ool200000goo00000006Ool2
0004Ool2000:Ool20006Ool30007Ool300000goo00000002Ool2000027oo000007oo001oo`00Ool2
0009Ool20004Ool20006Ool40003Ool2003oOolBOol5000027oo001oogoo001oofmk>Lh3Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0^Ool20002Ool200000goo000000040002Ool20004Ool6
0006Ool20004Ool40006Ool40002Ool20002Ool2000027oo000007oo001oo`00Ool60005Ool20004
Ool60003Ool20004Ool2003oOolBOol500000goo001oo`02Ool01@00Oom_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`0000<007ooOol0;Woo1P0000=oo`0000000Woo0P000Woo0`0000=oo`00Ool00P00
0Woo0P001Woo0P000goo0`000Woo00<007ooOol00Woo0`000Woo00@007oo0000009oo`800003Ool0
000000@00003Ool00000009oo`8000Eoo`8000Aoo`80009oo`80009oo`@000=oo`800?mooa9oo`D0
0003Ool007oo00=oo`03001oofmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo02ioo`80
009oo`80009oo`@0009oo`800004Ool000000002Ool40005Ool40004Ool50005Ool50002Ool40000
1goo000007oo001oo`0000=oo`@000Eoo`H0009oo`@0009oo`<00004Ool00000Ool6003oOol?Ool5
00000goo001oo`02Ool01@00Oomoofmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0;Woo
0P000Woo0P00BWoo0P004goo0P00ogoo4Woo100000=nLgoo00000goo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP0000<007ooOol0;Goo100000Aoo`00000001Yoo`8002eoo`8001=oo`800?mo
oa9oo`<00003OW<007oo00Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomo
o`3oOonWOol200001Gic000007ic00000goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP00
00<007ooOol0ogooYgoo00<007ic00000P0000=nL`00Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_
NfmkKg/icP02Kg/00003001oogoo0?moojMoo`InL`07001oogooOol006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP0000<007ooOol0ogooYgoo1`000goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/00003001oogoo0?moojQoo`D000Aoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh0
0003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3o
OonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOonaOol01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmk
Kg]_NcW>00=_N`4icP0000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/00003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo
0?mooj5oo`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomo
o`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>00000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol06Goo00<07gooOol01Woo00<07goo
Ool0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_
N`4icP0000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<07goo01l00goo0P0O0goo00<07goo
Ool0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/i
cP02Kg/00003001oogoo00]oo`0401moogoo01l2Ool01P0OOol07`0OOol07`9oo`0401moogoo01l2
Ool01@0OOomoo`0OOol0100O1goo0`0000=oo`00Ool04Goo00<007oo00000P00ogooFWoo00<07goo
Ool017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0
2Woo00<07gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00goo00@07gooOol0
7`]oo`05001oogooOol0000DOol01@00Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo00Yoo`0301moogoo009o
o`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`0601moogooOol07goo100O1Woo00D0
07ooOomoo`0000Yoo`D000Eoo`05001oogooOol0003oOomIOol00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0:Ool00`0OOomoo`02Ool0
0`0OOol07`02Ool01P0OOol07`0OOol07`Eoo`0401moogoo01l<Ool4000DOol01@00Oomoogoo0000
ogooFGoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/00003001oogoo00]oo`0401moogoo01l7Ool0100OOomoo`0O0Woo00@07gooOol07`9oo`0301mo
ogoo00eoo`03001oogoo019oo`05001oogooOol0003oOomIOol00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0<Ool201l;Ool201l2Ool2
01l2Ool201l;Ool40002Ool4000?Ool40002Ool4003oOomAOol401l6Ool00`0OOomoo`02Ool01@00
Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0=Goo00<007ooOol03goo00<007oo
Ool017oo00<007ooOol0ogooE7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00Di
cVmkKg]_NcW>00=_N`4icP0000<007ooOol0=Woo00<007ooOol03Goo0P001goo00<007ooOol0ogoo
DWoo0P0O1Woo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001o
ogoo03Moo`03001oogoo01Ioo`03001oogoo0?mooe1oo`0301moo`0O00Ioo`0301moogoo009oo`03
001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo03Aoo`04001oogoo000EOol01000
Oomoo`00ogooDGoo00@07gooOol07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk00000`00Oomoo`0eOol2000GOol2003oOomAOol01@0OOomoogoo01l01Woo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooX7oo1P0O1Woo
00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?moojao
o`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo0?moojao
o`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOon/
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOon/
Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo
[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogoo
[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?mo
ojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo0?mo
ojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3o
OonQOol501l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00
Oomoo`0kOol4003oOomVOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00Di
cVmkKg]_NcW>009_N`0000<007ooOol05goo0P0O1Woo0P0O6goo0P006goo10001Woo0P007Goo0P00
2goo0P007Woo0P001Goo1000jWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00Di
cVmkKg]_NcW>00=_N`4icP0000<007ooOol05goo00<07gooOol01Woo00<07gooOol06Goo0P006goo
0P001goo0P007goo0P002Goo0P0087oo0P001Woo0P00jWoo00<07gooOol017oo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo011oo`0301moo`0O009oo`03
01moo`0O00=oo`807`=oo`0401moogoo01l:Ool600000goo00000002Ool200000goo000000030003
Ool900000goo00000002Ool600000goo00000007Ool20004Ool60005Ool20005Ool60003Ool20009
Ool20004Ool6000=Ool60003Ool20006Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol0
7`02Ool0100OOomoo`0O0Woo00<07gooOol00Woo100O1Woo0P000Woo00<007oo00000P0000Aoo`00
001oo`80009oo`800003Ool00000009oo`800003Ool00000009oo`800003Ool00000009oo`80009o
o`8000Ioo`8000Aoo`80009oo`8000Ioo`8000Ioo`80009oo`8000=oo`8000Moo`8000Aoo`80009o
o`8000moo`80009oo`8000=oo`8000Eoo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol0
7`05Ool0100OOomoo`0O3Woo0P001Goo10000Woo0P000Woo0P0000=oo`0000000Woo0P0000=oo`00
00000Woo0P0000=oo`0000000Woo0P000Woo0P001Woo0P0017oo0P000Woo0P0017oo1P0017oo0P00
0Woo0P000goo0P001goo0P0017oo0P000Woo0P001Goo1@001Goo0P000Woo0P000goo0P001Goo0P00
jWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP00
00<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Ioo`800003
Ool007oo00=oo`8000=oo`80009oo`80009oo`D00003Ool00000009oo`800003Ool00000009oo`80
009oo`8000Ioo`8000Eoo`D000Ioo`8000Ioo`80009oo`8000=oo`8000Moo`8000Eoo`D000moo`80
009oo`8000=oo`8000Eoo`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0@Ool01@0OOol07goo01l00Woo00<07gooOol00goo
00@07gooOol07`9oo`0301moogoo00Uoo`@000=oo`@0009oo`80009oo`8000Eoo`800005Ool00000
001oo`0200000goo00000002Ool20002Ool20006Ool20008Ool20006Ool20006Ool20002Ool20003
Ool20007Ool20008Ool2000?Ool20002Ool20003Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0@Ool00`0OOomo
o`04Ool0100OOomoo`0O0Woo00@07gooOol07`ioo`8000Aoo`<00003Ool0000000800004Ool00000
0003Ool4000017oo000007oo0`000goo1@000Woo0P001goo0P0017oo10003goo1@000goo0P002Goo
0P0017oo100047oo1@000goo0P001Woo0P00jWoo00<07gooOol017oo00<07gooOol00Woo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo011oo`0301moogoo00Aoo`807`9oo`80
7`9oo`807`ioo`80009oo`03001oogoo01moo`80009oo`8000Moo`8001Moo`8000Ioo`8000Uoo`80
01Qoo`8000Ioo`8000Ioo`800>Uoo`807`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_Nfmk
Kg/icP03Kg/1>Lh00003001oogoo02ioo`H0021oo`<0009oo`@000Ioo`8001Eoo`<000Eoo`8000]o
o`8001Ioo`<000Eoo`8000Eoo`@00>Qoo`0301moo`0O00Ioo`0301moogoo009oo`05001_NfmkKg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol0
0Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooXGoo00D07gooOomo
o`0O00Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomo
o`3oOonPOol601l2Ool501l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomo
o`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo/Goo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_
N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh00003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00
Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`3oOonaOol0
1@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol0ogoo/Goo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol0ogooXGoo1@0O0Woo1@0O17oo00D006mkKg]_NcW>
00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009o
o`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh00003001oogoo01Uoo`807`Ioo`807omooh9o
o`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0000
0`00Oomoo`0IOol00`0OOomoo`06Ool00`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02
Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>00000`00Oomoo`0<Ool201l4Ool00`0OOol0
7`02Ool00`0OOol07`04Ool01@0OOomoogoo01l02goo1@00ogooLWoo00<07gooOol017oo00<07goo
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/00003001oogoo00]oo`0401moogoo
01l2Ool01P0OOol07`0OOol07`9oo`0301moogoo009oo`0601moogooOol07goo100O1Woo00D007oo
Oomoo`000?moog9oo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/i
cP03Kg/1>Lh00003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`03
01moogoo009oo`0501moogooOol07`0<Ool00`00Oomoo`3oOomcOol00`0OOomoo`04Ool00`0OOomo
o`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol02Woo00<07gooOol0
0Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo00H07gooOomoo`0OOol401l8Ool0
0`00Oomoo`3oOombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>00000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol0
7`Aoo`0501moogooOol07`0>Ool00`00Oomoo`3oOom^Ool401l6Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`0000<007ooOol02goo00@07gooOol07`Moo`0401moogoo
01l3Ool201l3Ool00`0OOomoo`09Ool01@00Oomoogoo0000ogooLWoo00<07gooOol017oo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP0000<007ooOol037oo0P0O2goo0P0O
0goo00<07gooOol00P0O2goo00D007ooOomoo`000?moog5oo`807`Ioo`0301moogoo009oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk00000`00Oomoo`0_Ool3003oOomaOol00`0OOol07`06
Ool00`0OOomoo`02Ool00`006<HHaP0<6<H00003001oogoo0?mooj9oo`0401moogoo01l6Ool00`0O
Oomoo`02Ool00`00IcUF]@0;E[D16<H00003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0O
Oomoo`02Ool00`00IcUF]@0;E[D16<H00003001oogoo0?mooj1oo`H07`Ioo`0301moogoo009oo`03
001W>EJe009F]@IW>@=F]@4HaP0000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe
1S6C0eJe0AS600000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H0
0003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4HaP0000<007ooOol0
ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS600000`00Oomoo`3oOon/Ool00`0O
Oomoo`02Ool00`00IcUF]@02E[D6<I<3E[D16<H00003001oogoo0?moojaoo`0301moogoo009oo`03
001W>EJe009F]@IW>@=F]@4HaP0000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe
1S6C0eJe0AS600000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H0
0003001oogoo0?mooj5oo`D07`Ioo`0301moogoo009oo`03001W>EJe009F]@I>O`=F]@4HaP0000<0
07ooOol0ogooYGoo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D02eJe0AS600000`00Oomo
o`0GOol201l6Ool201ooOon4Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUW>@0;IcT16<H0
0003001oogoo01Moo`0301moogoo00Ioo`0301moogoo0?mooh9oo`0301moogoo00Aoo`0301moogoo
009oo`03000YBRU:00`YBP0000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07goo
Oomoo`0O009oo`0301moogoo00Qoo`H000Eoo`8000Ioo`H00?mooeioo`0301moogoo00Aoo`0301mo
ogoo009oo`l0000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O
00Aoo`@07`Moo`8000Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03000i
cSW>00`icP0000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00mo
o`8000Eoo`H000Ioo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk00]_N`4i
cP0000<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Moo`80
00Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk009_N`DHaPA_
N`4icP0000<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo009oo`0501moogooOol07`02
Ool00`0OOomoo`0:Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk0CW>00000`00Oomoo`0@Ool00`0OOomoo`04Ool0100O
Oomoogoo0P0O0goo00<07gooOol03Goo0P004Goo0P00ogooH7oo00<07gooOol017oo00<07gooOol0
0Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP0000<007ooOol047oo00<07gooOol017oo
0P0O0goo00<07gooOol00P0O3Goo10003goo1000ogooGgoo0P0O1Woo00<07gooOol00Woo00<007oo
Kg/00Vmk00DHaTioCWm>OaS600A_N`4icP0000<007ooOol0<7oo0P004Goo0P00ogooGWoo00<07goo
01l01Woo00<07gooOol00Woo00<007oo6<H00aS60dio11S60Fmk0CW>00000`00Oomoo`3oOonROol0
100OOomoo`0O1Woo00<07gooOol00Woo00@007ooKg/HaPM>O`036<I_Nfmk004icP0000<007ooOol0
ogooXGoo00D07gooOomoo`0O00Ioo`0301moogoo009oo`05001oofmkKg/HaP05CWl011S6Kg]_Nfmk
0CW>00000`00Oomoo`3oOonPOol601l2Ool501l4Ool00`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk
0CW>00000`00Oomoo`3oOonaOol00`00Oom_N`03Kg/00aS6CWlHaP05Kg/1>Lh00003001oogoo0?mo
ok5oo`03001oofmk00A_N`036<I_Nfmk00A_N`4icP0000<007ooOol0ogoo/Goo00<007ooKg/02fmk
0CW>00000`00Oomoo`3oOonaOol00`00Oomoo`0;Ool1>Lh00?l00<<0000000<004ioCWl0odio`4io
00000`00IcUg_@3oMkfoMkd1CWl00003001W>GNm0?mg_Kmg_@5>O`0000<006Li>Lh01CW>00=g_AS6
IcT02FLi00=g_CW>>Lh0XcW>CgNmYCW>00=g_AS6IcT02FLi00=g_CW>>Lh013W>0Dio00000`00IcUg
_@06Mkd00aS6IcTHaP076<H00fLiMkeg_@2/Mkd40003Mkd20002Mkd20004Mkd20002Mkd20004Mkd2
0002Mkd20003Mkd40004Mkd5000;Mkd2002_Mkd00aS6IcTHaP076<H00fLiMkeg_@05Mkd1CWl00003
001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g
_@8000=g_@8000=g_@8000=g_@80009g_@8000=g_@03001g_GNm0080009g_@8000]g_@8000Ug_JDi
cP03MkdHaVLi00MF]@036<IW>GNm00HicP5>O`0000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLi
Mkd0[7Nm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P001WNm
0P000WNm0P002gNm0P00[gNm00<HaVLiE[D01UJe00<HaVLiMkd01WNm0Dio00000`00IcTicP05>Lh0
0gNm6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003
Mkd20003Mkd20002Mkd60002Mkd20002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@056<H2E[D00aS6
IcUg_@06>Lh1CWl00003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g_@80009g
_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@80009g_@80009g_@80009g_@80009g
_@D000Ag_@800:mg_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl00003001W>CW>00DicP03
MkdHaVLi00MF]@036<IW>GNm0:DicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g
_@8000=g_@80009g_@80009g_@80009g_@80009g_@8000]g_@8000Ug_JDicP03MkdHaVLi00AF]@06
6<IF]EJe6<IW>GNm1SW>0Dio00000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002
Mkd20002Mkd50003Mkd40002Mkd20002Mkd40002Mkd20003Mkd40004Mkd5000;Mkd2002_Mkd00aS6
IcUF]@03E[D01AS6E[EF]AS6IcT01gNm0Dio00000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg
_@2U>Lh7Mkd20002Mkd2000;Mkd20008Mkd20003Mkd2000>Mkd2000:Mkd30009MkfU>Lh00gNm6<IW
>@04E[D01QS6E[EF]AS6IcUg_@HicP5>O`0000<006LiMkd01WNm00<HaVLiIcT026Li[GNm0P000WNm
0P002gNm0P000gNm0P000gNm0P000gNm0P003WNm0P002gNm0P00[gNm00<HaVLiIcT026Li1gNm0Dio
00000`00IcTicP05>Lh00gNm6<HHaP096<H00gNm>LhicP2S>Li?MkfU>Lh00gNm6<HHaP096<H00gNm
>LhicP04>Lh1CWl00003001W>GNm0?mg_Kmg_@5>O`0000<006LiMkd0ogNm_gNm0Dio00000`00IcUW
>@3oIcVoIcT1CWl00?l00<<00000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{450, 190},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Next we pull down the Format menu and choose ",
  StyleBox["Text", "MenuItem"],
  " from the ",
  "Style",
  " submenu. By default, text cells have margins to the left of the margin \
for an input or output cell, and use a different font."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000730000`1000`40O003h00O00<007ooOol0ogoo
/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mk
Kg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05
>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_
Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo
/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03
Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<0
07ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mo
oj5oo`D07`9oo`D07`Aoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo
0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0IOol00`0OOomoo`06Ool0
0`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmk
Kg]_NcW>009_N`40000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<07goo01l00Woo100O
0Woo00<07gooOol02goo00<007ooOol00Woo1@0017oo00<007ooOol00goo0`000goo0`001Woo00<0
07ooOol00Woo0`001Goo0`001Goo00<007ooOol00goo0`000goo0`0017oo1@000goo0`000goo1000
0goo1@000Woo100017oo0`0017oo0`001Goo00<007ooOol017oo00<007ooOol00goo0`000goo1@00
17oo0`000Woo0`00dWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02goo00@07gooOol07`9oo`0601moo`0O01moo`0O0Woo00@0
7gooOol07`Eoo`0301moo`0O00<07`Qoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009o
o`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<0
07ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00=oo`03001oogoo009o
o`07001oogooOol007oo000017oo00@007ooOol000=oo`03001oo`0000Aoo`04001oogoo0003Ool0
1000Oomoo`000goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`00
009oo`05001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`3?Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02Woo00<0
7gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo00D07gooOomoo`0O00Aoo`0301moogoo00]o
o`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol00Woo00D007oo
Oomoo`0000Ioo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00006Ool01@00Oomoogoo
00002Goo00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo1P001Woo00<007ooOol0cWoo00<07goo
Ool017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool02Woo00<07gooOol00Woo00<07goo01l00Woo00<07goo01l00Woo00<07gooOol00Woo00H07goo
Oomoo`0OOol401l9Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00@007oo
Oomoo`@000Eoo`03001oogoo009oo`@0009oo`05001oogooOol00005Ool01@00Oomoogoo00000goo
00@007ooOomoo`@000Aoo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00
Oomoo`06Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo00Aoo`05
001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo1000d7oo
00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/10000
0003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0601moo`0O01moo`0O1Goo00@07goo
Ool07`ioo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo009oo`<000=oo`05001oogooOol0
0005Ool01@00Oomoogoo00000goo00@007ooOomoo`<000Ioo`04001oogooOol40003Ool01@00Oomo
ogoo000017oo00<007ooOol00goo0`000goo10001Woo00@007ooOomoo`@000Aoo`<000Aoo`<000Io
o`03001oogoo00Aoo`05001oogooOol00003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00D0
07ooOomoo`0000=oo`03001oogoo0<]oo`@07`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_
NfmkKg/icP03Kg/1>Lh100000003001oogoo00]oo`0401moogoo01l7Ool0100OOomoo`0O0Woo00@0
7gooOol07`9oo`0301moogoo00aoo`03001oogoo00=oo`03001oogoo00Eoo`05001oogooOol00003
Ool01000Oomoo`000goo00<007ooOol00goo00D007ooOomoo`0000=oo`04001oogoo0003Ool00`00
Oomoo`03Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Aoo`03001oogoo009oo`05001oogoo
Ool00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00
009oo`05001oogooOol00005Ool00`00Oomoo`04Ool01@00Oomoogoo00000goo00@007ooOol000=o
o`07001oogooOol007oo00000goo00D007ooOomoo`000=1oo`0301moogoo00Aoo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0<Ool201l;Ool201l2
Ool201l2Ool201l;Ool01@00Oomoogoo00000Woo0`0017oo00D007ooOomoo`00009oo`05001oogoo
Ool00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01@00
Oomoogoo00000Woo00D007ooOomoo`0000=oo`03001oogoo00=oo`05001oogooOol00002Ool30004
Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo00Aoo`05
001oogooOol00002Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002
Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`8000=oo`05001oogooOol0003?Ool201l6
Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0^
Ool50004Ool00`00Oomoo`02Ool50003Ool30004Ool30003Ool50003Ool30004Ool30003Ool50004
Ool30003Ool30005Ool00`00Oomoo`03Ool30003Ool50003Ool30003Ool50003Ool30004Ool30003
Ool50002Ool50003Ool30004Ool30006Ool00`00Oomoo`02Ool3003?Ool00`0OOol07`06Ool00`0O
Oomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXWoo
00@07gooOol07`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh10000
0003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk
00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooX7oo1P0O1Woo00<07gooOol00Woo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`0301moogoo009o
o`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojaoo`0301moogoo
009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOon/Ool00`0O
Oomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOon/Ool0
0`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo
[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo0?moojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mooj5oo`D07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0GOol201l6Ool201ooOon4Ool00`0OOomoo`04
Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
5goo00<07gooOol01Woo00<07gooOol0ogooPWoo00<07gooOol017oo00<07gooOol00Woo00<006mk
>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07goo01l00Woo00<07goo
01l00Woo100O0Woo00@07gooOol07`]oo`@000]oo`D000=oo`@00?mooe]oo`0301moogoo00Aoo`03
01moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0@Ool0
0`0OOol07`02Ool00`0OOol07`02Ool00`0OOomoo`03Ool00`0OOomoo`02Ool401l5Ool20002Ool2
000:Ool20002Ool200000goo00000002Ool2003oOomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool0
0`0OOol07`03Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool2000>Ool200000goo00000002Ool2003o
OomJOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_
N`40000000<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Uo
o`8000ioo`800003Ool00000009oo`800?mooeYoo`0301moogoo00Aoo`0301moogoo009oo`03001_
NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo011oo`0501moo`0OOol07`02Ool0
0`0OOomoo`03Ool0100OOomoo`0O0Woo00<07gooOol02Woo0`002goo1@000Woo0P000Woo0P00ogoo
FWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/1
00000003001oogoo011oo`0301moogoo00Aoo`0401moogoo01l2Ool0100OOomoo`0O4Goo0P000Woo
0P000Woo0P000Woo0P001Goo0P000Woo0P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00<07gooOol017oo0P0O
0Woo0P0O0Woo0P0O3Goo0P000Woo0P000goo10000goo0P001Goo0P000Woo0P00ogooFGoo0P0O1Woo
00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo02mo
o`@000Eoo`8000Aoo`D000=oo`@00?mooeUoo`0301moo`0O00Ioo`0301moogoo009oo`03001_NcW>
00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mooj9oo`0401moogoo01l6Ool00`0O
Oomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooXGoo
00D07gooOomoo`0O00Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh1
00000003001oogoo0?mooj1oo`H07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonXOol400000goo001oo`02Ool00`00Kg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonWOol500000goo001oo`02Ool01@00Oomo
ofmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogooYgoo00<007icOW<00Wic00=o
o`00Ool00goo00<007ooKg/00Vmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooYgoo
1@0000=oo`00Ool00Woo00D007ooKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
0?moojMoo`D00008Ool007ooOol007ooKg/icP=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001o
ogoo0?moojMoo`D00004Ool007oo000:Ool3Kg/00cW>Kg]_N`0100000003001oogoo00Aoo`<0009o
o`<0009oo`80009oo`<0009oo`8000Eoo`H000Eoo`<000=oo`<0009oo`<00004Ool00000Ool20002
Ool20006Ool00`00Oomoo`020002Ool200000goo00000002Ool01000Oomoo`00ogooCWoo1@0000=o
o`0000002P0000=oofmk>Lh00fmk0CW>0@0000000`00Oomoo`05Ool00`00Oomoo`02Ool01000Oomo
o`000Woo00@007ooOol0009oo`04001oogoo0005Ool00`00Ool00002Ool00`00Oomoo`02Ool01P00
Oomoo`00Ool000=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Aoo`04001oogoo
0002Ool01P00Oomoo`00Ool0009oo`03001oogoo0?mooe1oo`D00004Ool007oo000:Ool3Kg/00cW>
Kg]_N`0100000003001oogoo00Eoo`03001oogoo009oo`04001oogoo0005Ool01000Oomoo`0027oo
00@007ooOomoo`8000Ioo`800003Ool007oo009oo`04001oogoo0002Ool01000Oomoo`000Woo00<0
07ooOol01Goo00@007ooOol000Ioo`05001oogooOol0003oOomBOol5000027oo001oogoo001oofmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomo
o`040002Ool00`00Oomoo`040005Ool01000Ool000001Woo0P000goo00D007ooOomoo`00009oo`04
001oogoo0002Ool00`00Oomoo`040004Ool00`00Oomoo`040003Ool01@00Oomoogoo0000ogooDWoo
1@0000=oo`00Ool00Woo00D007ooKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
00Eoo`H0009oo`04001oogoo0002Ool200001Goo001oogoo00001Goo00<007oo00000Woo00<007oo
Ool00Woo00H007ooOol007oo0003Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004
Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool00`00Oomoo`3oOom@Ool500000goo001oo`03
Ool00`00Oom_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`05Ool00`00Oomoo`02
Ool01000Oomoogoo0P000Woo00D007oo000007oo008000Eoo`80009oo`<000Eoo`<0009oo`<0009o
o`05001oo`00001oo`020004Ool20004Ool30002Ool20002Ool200000goo00000003003oOomAOol5
00000goo001oo`02Ool01@00Oomoofmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
1Goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol02goo00<007ooOol0ogooD7oo1@0000=o
o`00Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol01Goo00<0
07ooOol00Woo00<007ooOol0ogooVWoo1@001Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo00Aoo`<0009oo`<001=oo`03001oogoo0?moohEoo`8000AnL`07001oogoo
Ool006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooYgoo1@0000=nL`00
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojMoo`03
001nLgic00=nL`07001oogooOol006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007oo
Ool0ogooYgoo1`000goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo
0?moojQoo`D000Aoo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mo
ok5oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00
Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo0?mooj5oo`D07`9oo`D07`Aoo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@00
00000`00Oomoo`3oOonUOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0IOol201l6Ool201ooOon2Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol06Goo00<0
7gooOol01Woo00<07gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk
00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O17oo00<07goo01l00Woo00<07goo
01l00goo0P0O0goo00<07gooOol0ogooP7oo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_
NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l2Ool01P0OOol0
7`0OOol07`9oo`0401moogoo01l2Ool01@0OOomoo`0OOol0100O1goo0`0000=oo`00Ool04Goo00<0
07oo00000P00ogooFWoo00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_
NcW>00=_N`4icP40000000<007ooOol02Woo00<07gooOol00Woo00<07goo01l00Woo00<07goo01l0
0Woo00<07gooOol00goo00@07gooOol07`]oo`05001oogooOol0000DOol01@00Oomoogoo0000ogoo
FGoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/1
00000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo
009oo`0601moogooOol07goo100O1Woo00D007ooOomoo`0000Yoo`D000Eoo`05001oogooOol0003o
OomIOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol07`Eoo`04
01moogoo01l<Ool4000DOol01@00Oomoogoo0000ogooFGoo00<07gooOol017oo00<07gooOol00Woo
00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l7
Ool0100OOomoo`0O0Woo00@07gooOol07`9oo`0301moogoo00eoo`03001oogoo019oo`05001oogoo
Ool0003oOomIOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0@0000000`00Oomoo`0<Ool201l;Ool201l2Ool201l2Ool201l;Ool40002Ool4000?Ool4
0002Ool4003oOomAOol401l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>
009_N`40000000<007ooOol0=Goo00<007ooOol03goo00<007ooOol017oo00<007ooOol0ogooE7oo
00<07gooOol017oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000
00<007ooOol0=Woo00<007ooOol03Goo0P001goo00<007ooOol0ogooDWoo0P0O1Woo00<07gooOol0
0Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo03Moo`03001oogoo
01Ioo`03001oogoo0?mooe1oo`0301moo`0O00Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_
NfmkKg/icP03Kg/1>Lh100000003001oogoo03Aoo`04001oogoo000EOol01000Oomoo`00ogooDGoo
00@07gooOol07`Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@00
00000`00Oomoo`0eOol2000GOol2003oOomAOol01@0OOomoogoo01l01Woo00<07gooOol00Woo00<0
06mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooX7oo1P0O1Woo00<07goo
Ool00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?moojaoo`03
01moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?moojao
o`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3o
Oon/Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomo
o`3oOon/Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<0
07ooOol0ogoo[7oo00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP400000
00<007ooOol0ogoo[7oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/1
00000003001oogoo0?moojaoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh100000003001oogoo0?moojaoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk
>Lh00Vmk0@0000000`00Oomoo`3oOonQOol501l6Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0kOol4003oOomVOol00`0OOomoo`04Ool00`0OOomo
o`02Ool01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol05goo0P0O1Woo
0P0O6goo0P006goo10001Woo0P007Goo0P002goo0P007Woo0P001Goo1000jWoo00<07gooOol017oo
00<07gooOol00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol05goo
00<07gooOol01Woo00<07gooOol06Goo0P006goo0P001goo0P007goo0P002Goo0P0087oo0P001Woo
0P00jWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02
Kg/100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O00=oo`807`=oo`0401moogoo01l:
Ool600000goo00000002Ool200000goo000000030003Ool900000goo00000002Ool600000goo0000
0007Ool20004Ool60005Ool20005Ool60003Ool20009Ool20004Ool6000=Ool60003Ool20006Ool2
003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`02Ool0100OOomoo`0O0Woo00<07goo
Ool00Woo100O1Woo0P000Woo00<007oo00000P0000Aoo`00001oo`80009oo`800003Ool00000009o
o`800003Ool00000009oo`800003Ool00000009oo`80009oo`8000Ioo`8000Aoo`80009oo`8000Io
o`8000Ioo`80009oo`8000=oo`8000Moo`8000Aoo`80009oo`8000moo`80009oo`8000=oo`8000Eo
o`800>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh0
0Vmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`05Ool0100OOomoo`0O3Woo0P00
1Goo10000Woo0P000Woo0P0000=oo`0000000Woo0P0000=oo`0000000Woo0P0000=oo`0000000Woo
0P000Woo0P001Woo0P0017oo0P000Woo0P0017oo1P0017oo0P000Woo0P000goo0P001goo0P0017oo
0P000Woo0P001Goo1@001Goo0P000Woo0P000goo0P001Goo0P00jWoo00<07gooOol017oo00<07goo
Ool00Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol047oo00P07goo
01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Ioo`800003Ool007oo00=oo`8000=oo`80
009oo`80009oo`D00003Ool00000009oo`800003Ool00000009oo`80009oo`8000Ioo`8000Eoo`D0
00Ioo`8000Ioo`80009oo`8000=oo`8000Moo`8000Eoo`D000moo`80009oo`8000=oo`8000Eoo`80
0>Yoo`0301moogoo00Aoo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk
0@0000000`00Oomoo`0@Ool01@0OOol07goo01l00Woo00<07gooOol00goo00@07gooOol07`9oo`03
01moogoo00Uoo`@000=oo`@0009oo`80009oo`8000Eoo`800005Ool00000001oo`0200000goo0000
0002Ool20002Ool20006Ool20008Ool20006Ool20006Ool20002Ool20003Ool20007Ool20008Ool2
000?Ool20002Ool20003Ool20005Ool2003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/i
cP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0@Ool00`0OOomoo`04Ool0100OOomo
o`0O0Woo00@07gooOol07`ioo`8000Aoo`<00003Ool0000000800004Ool000000003Ool4000017oo
000007oo0`000goo1@000Woo0P001goo0P0017oo10003goo1@000goo0P002Goo0P0017oo100047oo
1@000goo0P001Woo0P00jWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>00=_N`05
>Li_NfmkKg/icP02Kg/100000003001oogoo011oo`0301moogoo00Aoo`807`9oo`807`9oo`807`io
o`80009oo`03001oogoo01moo`80009oo`8000Moo`8001Moo`8000Ioo`8000Uoo`8001Qoo`8000Io
o`8000Ioo`800>Uoo`807`Ioo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1
>Lh100000003001oogoo02ioo`H0021oo`<0009oo`@000Ioo`8001Eoo`<000Eoo`8000]oo`8001Io
o`<000Eoo`8000Eoo`@00>Qoo`0301moo`0O00Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/0
1CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo
00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogooXGoo00D07gooOomo
o`0O00Ioo`0301moogoo009oo`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00
Oomoo`3oOonPOol601l2Ool501l4Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0@000000
0`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol0
ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0ogoo/Goo00D0
06mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo0?mook5oo`03001_NcW>00=_
N`05>Li_NfmkKg/icP03Kg/1>Lh100000003001oogoo0?mook5oo`05001_NfmkKg/icP03Kg/01CW>
Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`3oOonaOol00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0@0000000`00Oomoo`3oOonaOol01@00Kg]_Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`400000
00<007ooOol0ogoo/Goo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol0
ogooXGoo1@0O0Woo1@0O17oo00D006mkKg]_NcW>00=_N`05>Li_NfmkKg/icP02Kg/100000003001o
ogoo0?moojEoo`0301moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03
Kg/1>Lh100000003001oogoo01Uoo`807`Ioo`807omooh9oo`0301moogoo00Aoo`0301moogoo009o
o`05001_NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0IOol00`0OOomoo`06
Ool00`0OOomoo`3oOon0Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool00`0OOol07`04Ool0
1@0OOomoogoo01l02goo1@00ogooLWoo00<07gooOol017oo00<07gooOol00Woo00D006mkKg]_NcW>
00=_N`05>Li_NfmkKg/icP02Kg/100000003001oogoo00]oo`0401moogoo01l2Ool01P0OOol07`0O
Ool07`9oo`0301moogoo009oo`0601moogooOol07goo100O1Woo00D007ooOomoo`000?moog9oo`03
01moogoo00Aoo`0301moogoo009oo`03001_NcW>00=_N`05>Li_NfmkKg/icP03Kg/1>Lh100000003
001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O009oo`0301moogoo009oo`05
01moogooOol07`0<Ool00`00Oomoo`3oOomcOol00`0OOomoo`04Ool00`0OOomoo`02Ool01@00Kg]_
Nfmk>Lh00fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02Woo00<07gooOol00Woo00<07goo
01l00Woo00<07goo01l00Woo00<07gooOol00Woo00H07gooOomoo`0OOol401l8Ool00`00Oomoo`3o
OombOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Kg/icP03Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0@0000000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol07`Aoo`05
01moogooOol07`0>Ool00`00Oomoo`3oOom^Ool401l6Ool00`0OOomoo`02Ool01@00Kg]_Nfmk>Lh0
0fmk00DicVmkKg]_NcW>009_N`40000000<007ooOol02goo00@07gooOol07`Moo`0401moogoo01l3
Ool201l3Ool00`0OOomoo`09Ool01@00Oomoogoo0000ogooLWoo00<07gooOol017oo00<07gooOol0
0Woo00<006mk>Lh00fmk00DicVmkKg]_NcW>00=_N`4icP40000000<007ooOol037oo0P0O2goo0P0O
0goo00<07gooOol00P0O2goo00D007ooOomoo`000?moog5oo`807`Ioo`0301moogoo009oo`05001_
NfmkKg/icP03Kg/01CW>Kg]_Nfmk>Lh00Vmk0@0000000`00Oomoo`0_Ool3003oOomaOol00`0OOol0
7`06Ool00`0OOomoo`02Ool00`006<HHaP0<6<H100000003001oogoo0?mooj9oo`0401moogoo01l6
Ool00`0OOomoo`02Ool00`00IcUF]@0;E[D16<H100000003001oogoo0?mooj5oo`0501moogooOol0
7`06Ool00`0OOomoo`02Ool00`00IcUF]@0;E[D16<H100000003001oogoo0?mooj1oo`H07`Ioo`03
01moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol0
0Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00
IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F
]@HaT`=F]@4HaP40000000<007ooOol0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe
0AS60@0000000`00Oomoo`3oOon/Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3E[D16<H10000
0003001oogoo0?moojaoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007oo
Ool0ogoo[7oo00<07gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`3oOon/
Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001oogoo0?mooj5oo`D07`Io
o`0301moogoo009oo`03001W>EJe009F]@I>O`=F]@4HaP40000000<007ooOol0ogooYGoo00<07goo
Ool017oo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`0GOol201l6Ool201oo
Oon4Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUW>@0;IcT16<H100000003001oogoo01Mo
o`0301moogoo00Ioo`0301moogoo0?mooh9oo`0301moogoo00Aoo`0301moogoo009oo`03000YBRU:
00`YBP40000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O009o
o`0301moogoo00Qoo`H000Eoo`8000Ioo`H00?mooeioo`0301moogoo00Aoo`0301moogoo009ooa00
000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00Aoo`@07`Mo
o`8000Moo`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03000icSW>00`icP40
000000<007ooOol047oo00<07goo01l00Woo00<07goo01l017oo00D07gooOomoo`0O00moo`8000Eo
o`H000Ioo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk00]_N`4icP400000
00<007ooOol047oo00P07goo01l07goo01moo`0O17oo00D07gooOomoo`0O00Aoo`@07`Moo`8000Mo
o`8000Qoo`800?moof1oo`0301moogoo00Aoo`0301moogoo009oo`03001oofmk009_N`DHaPA_N`4i
cP40000000<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo009oo`0501moogooOol07`02
Ool00`0OOomoo`0:Ool20007Ool20008Ool2003oOomPOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk0CW>0@0000000`00Oomoo`0@Ool00`0OOomoo`04Ool0
100OOomoogoo0P0O0goo00<07gooOol03Goo0P004Goo0P00ogooH7oo00<07gooOol017oo00<07goo
Ool00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol047oo00<07goo
Ool017oo0P0O0goo00<07gooOol00P0O3Goo10003goo1000ogooGgoo0P0O1Woo00<07gooOol00Woo
00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol0<7oo0P004Goo0P00ogoo
GWoo00<07goo01l01Woo00<07gooOol00Woo00<007oo6<H00aS60dio11S60Fmk0CW>0@0000000`00
Oomoo`3oOonROol0100OOomoo`0O1Woo00<07gooOol00Woo00@007ooKg/HaPM>O`046<I_Nfmk>Lh1
00000003001oogoo0?mooj5oo`0501moogooOol07`06Ool00`0OOomoo`02Ool01@00Oom_Nfmk6<H0
1Dio00DHaVmkKg]_NcW>0040000000<007ooOol0ogooX7oo1P0O0Woo1@0O17oo00<007ooKg/00Vmk
00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol0ogoo/Goo00<007ooKg/00fmk00<HaTio6<H0
1Fmk0CW>0@0000000`00Oomoo`3oOonaOol00`00Oom_N`04Kg/00aS6Kg]_N`04Kg/1>Lh100000003
001oogoo0?mook5oo`03001oofmk00]_N`4icP40000000<007ooOol0ogoo/Goo00<007ooOol02goo
0CW>0@00003o003400000003001>Odio0?m>Ol1>O`40000000<006LiMkd0ogNm_gNm0Dio0@000000
0`00IcUg_@3oMkfoMkd1CWl100000003001W>CW>00DicP03MkdHaVLi00UW>@03MkdicSW>0:<icTmg
_JDicP03MkdHaVLi00UW>@03MkdicSW>00@icP5>O`40000000<006LiMkd01WNm00<HaVLi6<H01aS6
00=W>GNmMkd0[7Nm10000gNm0P000WNm0P0017Nm0P000WNm0P0017Nm0P000WNm0P000gNm100017Nm
1@002gNm0P00[gNm00<HaVLi6<H01aS600=W>GNmMkd01GNm0Dio0@0000000`00IcTicP05>Lh00gNm
6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd2
0003Mkd20002Mkd20003Mkd00`00Mkeg_@020002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@07E[D0
0aS6IcUg_@06>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:ag_@80009g
_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@8000Ig_@80009g_@8000]g
_@800:mg_@036<IW>EJe00IF]@036<IW>GNm00Ig_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT0
1eJe00<HaVLiMkd0YCW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm
0P000WNm1P000WNm0P000WNm0P002gNm0P002GNmYCW>00=g_AS6IcT01AS60UJe00<HaVLiMkd01SW>
0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2/Mkd20002Mkd20002Mkd20002
Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002Mkd50004
Mkd2002_Mkd00aS6IcUF]@03E[D01AS6E[EF]AS6IcT01gNm0Dio0@0000000`00IcTicP05>Lh00gNm
6<IW>@07E[D00aS6IcUg_@2U>Lh7Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd2
0003Mkd20002Mkd20002Mkd20002Mkd20002Mkd2000;Mkd20009MkfU>Lh00gNm6<IW>@04E[D01QS6
E[EF]AS6IcUg_@HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[7Nm0P00
0WNm0P000WNm1@000gNm10000WNm0P000WNm10000WNm0P000gNm100017Nm1@002gNm0P00[gNm00<H
aVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<H
aVLiMkd0YCW>1gNm0P000WNm0P002gNm0P0027Nm0P000gNm0P003WNm0P002WNm0`002GNmYCW>00=g
_AS6IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>FLi00QW>Jeg
_@80009g_@8000]g_@8000=g_@8000=g_@8000=g_@8000ig_@8000]g_@800:mg_@036<IW>FLi00QW
>@Mg_@5>O`40000000<006Li>Lh01CW>00=g_AS66<H02AS600=g_CW>>Lh0XcW>CgNmYCW>00=g_AS6
6<H02AS600=g_CW>>Lh013W>0Dio0@0000000`00IcUg_@3oMkfoMkd1CWl100000003001W>GNm0?mg
_Kmg_@5>O`40000000<006LiIcT0ofLi_fLi0Dio0@00003o003400000001\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{451, 192},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "We can insert section headings by creating new cells, typing the text for \
each heading, and changing the cells into section cells by choosing ",
  StyleBox["Section", "MenuItem"],
  " from the Style submenu of the Format menu. Section cells usually use a \
larger font size than text cells, and have a dingbat to the left of the \
heading text."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000760000eQ000`40O003h00O00<007ooOol01Goo
00<007ooOol00Woo00@007ooOol000Eoo`04001oogoo0008Ool01000Oomoogoo0P001Woo0P0000=o
o`00Ool00Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`05Ool01000Oomoo`001Woo
00D007ooOomoo`000?mooe=oo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>
Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`040002Ool00`00
Oomoo`040005Ool01000Ool000001Woo0P000goo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`040004Ool00`00Oomoo`040003Ool01@00Oomoogoo0000ogooDgoo00<07gooOol017oo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
1Goo1P000Woo00@007ooOol0009oo`800005Ool007ooOol00005Ool00`00Ool00002Ool00`00Oomo
o`02Ool01P00Oomoo`00Ool000=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Ao
o`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`03001oogoo0?mooe5oo`0301moogoo00Aoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`05Ool00`00
Oomoo`02Ool01000Oomoogoo0P000Woo00D007oo000007oo008000Eoo`80009oo`<000Eoo`<0009o
o`<0009oo`05001oo`00001oo`020004Ool20004Ool30002Ool20002Ool200000goo00000003003o
OomBOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0Fmk0@0000000`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`0;Ool00`00
Oomoo`3oOomAOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`40000000<007ooOol01Goo00<007ooOol00Woo00<007ooOol0ogooVgoo00<07gooOol017oo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
17oo0`000Woo0`004goo00<007ooOol0ogooPgoo100O1Woo00<07gooOol00Woo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojAoo`D07`Io
o`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_
Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomo
o`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007oo
Ool0ogoo[goo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`400000
00<007ooOol0ogoo[goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/10000
0003001oogoo0?moojmoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1
Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmk
Kg]_NcW>00=_N`40000000<007ooOol0ogooWGoo1@0O0Woo1@0O1Woo00<07gooOol00Woo00<003W>
Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooXGoo00<07gooOol017oo
00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003
001oogoo01Uoo`807`Ioo`807omoogioo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo01Uoo`0301moogoo
00Ioo`0301moogoo0?moogaoo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`04001_
Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool0
0`0OOol07`03Ool201l3Ool00`0OOomoo`3oOomlOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0;Ool0
100OOomoo`0O0Woo00H07goo01l07goo01l2Ool0100OOomoo`0O0Woo00D07gooOol07goo00@07`Mo
o`<00003Ool007oo015oo`03001oo`0000800?mooeIoo`0301moogoo00Aoo`0301moogoo00Aoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0:Ool00`0O
Oomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0OOomoo`03Ool0100OOomoo`0O2goo00D0
07ooOomoo`0001Aoo`05001oogooOol0003oOomEOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0:Ool0
0`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0OOomoo`02Ool01P0OOomoogoo01mo
o`@07`Ioo`05001oogooOol0000:Ool50005Ool01@00Oomoogoo0000ogooEGoo00<07gooOol017oo
00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003
001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0601moo`0O01moo`0O1Goo00@07gooOol0
7`aoo`@001Aoo`05001oogooOol0003oOomEOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomo
o`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0;Ool0100O
Oomoo`0O1goo00@07gooOol07`9oo`0401moogoo01l2Ool00`0OOomoo`0=Ool00`00Oomoo`0BOol0
1@00Oomoogoo0000ogooEGoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00@006mk
Kg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo00aoo`807`]oo`807`9oo`807`9oo`80
7`]oo`@0009oo`@000moo`@0009oo`@00?moodeoo`@07`Ioo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo03Eoo`03001oogoo
00moo`03001oogoo00Aoo`03001oogoo0?mooe1oo`0301moogoo00Aoo`0301moogoo00Aoo`0301mo
ogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0fOol00`00Oomo
o`0=Ool20007Ool00`00Oomoo`3oOom>Ool201l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0gOol00`00Oomoo`0FOol0
0`00Oomoo`3oOom<Ool00`0OOol07`06Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0=7oo00@007ooOol001Eoo`04001oogoo003o
Oom=Ool0100OOomoo`0O1Woo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`4icP5_N`40000000<007ooOol0=Goo0P005goo0P00ogooCGoo00D07gooOomoo`0O
00Ioo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@00
00000`00Oomoo`3oOonLOol601l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomo
o`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooZ7oo00<07goo
Ool017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<0
07ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301mo
ogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonXOol00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@000000
0`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_
NcW>00=_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooWGoo1@0O1Woo00<07gooOol0
17oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo03]o
o`@00?moof9oo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05
>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo01Moo`807`Ioo`807a]oo`8001]oo`@000Io
o`8001eoo`8000]oo`8001ioo`8000Eoo`@00>Ioo`0301moogoo00Aoo`0301moogoo00Aoo`0301mo
ogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0GOol00`0OOomo
o`06Ool00`0OOomoo`0IOol2000KOol20007Ool2000OOol20009Ool2000POol20006Ool2003VOol0
0`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0Fmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`03Ool201l3Ool0100O
Oomoo`0O2Woo1P0000=oo`0000000Woo0P0000=oo`0000000`000goo2@0000=oo`0000000Woo1P00
00=oo`0000001goo0P0017oo1P001Goo0P001Goo1P000goo0P002Goo0P0017oo1P003Goo1P000goo
0P001Woo0P00iWoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/100000003001oogoo011oo`0301moo`0O009oo`0301moo`0O009oo`04
01moogoo01l2Ool00`0OOomoo`02Ool401l6Ool20002Ool00`00Ool00002000017oo000007oo0P00
0Woo0P0000=oo`0000000Woo0P0000=oo`0000000Woo0P0000=oo`0000000Woo0P000Woo0P001Woo
0P0017oo0P000Woo0P001Woo0P001Woo0P000Woo0P000goo0P001goo0P0017oo0P000Woo0P003goo
0P000Woo0P000goo0P001Goo0P00iWoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo
00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol047oo00<07goo01l0
0Woo00<07goo01l01Goo00@07gooOol07`ioo`8000Eoo`@0009oo`80009oo`800003Ool00000009o
o`800003Ool00000009oo`800003Ool00000009oo`80009oo`8000Ioo`8000Aoo`80009oo`8000Ao
o`H000Aoo`80009oo`8000=oo`8000Moo`8000Aoo`80009oo`8000Eoo`D000Eoo`80009oo`8000=o
o`8000Eoo`800>Ioo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0@Ool0200OOol07`0OOol07goo01l4Ool01@0O
Oomoogoo01l017oo100O1Woo0P0000=oo`00Ool00goo0P000goo0P000Woo0P000Woo1@0000=oo`00
00000Woo0P0000=oo`0000000Woo0P000Woo0P001Woo0P001Goo1@001Woo0P001Woo0P000Woo0P00
0goo0P001goo0P001Goo1@003goo0P000Woo0P000goo0P001Goo0P00iWoo00<07gooOol017oo00<0
7gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`400000
00<007ooOol047oo00D07goo01moo`0O009oo`0301moogoo00=oo`0401moogoo01l2Ool00`0OOomo
o`09Ool40003Ool40002Ool20002Ool20005Ool200001Goo00000000Ool00P0000=oo`0000000Woo
0P000Woo0P001Woo0P0027oo0P001Woo0P001Woo0P000Woo0P000goo0P001goo0P0027oo0P003goo
0P000Woo0P000goo0P001Goo0P00iWoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo
00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo011oo`0301moogoo00Aoo`04
01moogoo01l2Ool0100OOomoo`0O3Woo0P0017oo0`0000=oo`0000000P0000Aoo`00000000=oo`@0
0004Ool00000Ool30003Ool50002Ool20007Ool20004Ool4000?Ool50003Ool20009Ool20004Ool4
000@Ool50003Ool20006Ool2003VOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0@Ool00`0OOomoo`04
Ool201l2Ool201l2Ool201l>Ool20002Ool00`00Oomoo`0OOol20002Ool20007Ool2000GOol20006
Ool20009Ool2000HOol20006Ool20006Ool2003UOol201l6Ool00`0OOomoo`04Ool00`0OOomoo`02
Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0;Woo1P0087oo0`000Woo
10001Woo0P005Goo0`001Goo0P002goo0P005Woo0`001Goo0P001Goo1000i7oo00<07goo01l01Woo
00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40
000000<007ooOol0ogooWWoo00@07gooOol07`Ioo`0301moogoo00Aoo`0301moogoo009oo`04001_
Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonMOol01@0OOomoogoo01l01Woo
00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40
000000<007ooOol0ogooW7oo1P0O0Woo1@0O1Woo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_
NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03000icVmk009_N`05>Li_
NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02
Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00<0
03W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo[goo00<07gooOol0
0Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo
009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonTOol5
01l6Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00
Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk
00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07goo
Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojQoo`0301mo
ogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003
001oogoo00Aoo`/000Ioo`03001oo`0000<000Ioo`@000Aoo`@000Aoo`<0009oo`D0009oo`@000=o
o`D00003Ool00000008000Moo`<000Eoo`80009oo`8000Eoo`@00?moocaoo`0301moogoo00Aoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`04Ool00`00
>LhicP07>Lh00`00Oomoo`04Ool30002Ool30003Ool300000goo00000002Ool300000goo00000002
Ool3000017oo001oogoo0`000Woo0P000Woo0P000goo0`000Woo0`001goo0`0000=oo`00Ool00goo
0P000Woo0P0017oo0P000Woo0P00ogoo>goo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol017oo00<003W>>Lh01cW>00<007oo
Ool017oo0P0017oo0`0000Aoo`00000000Eoo`<000Ioo`<000Aoo`<00004Ool000000002Ool30002
Ool30002Ool30007Ool30005Ool80002Ool30002Ool3003oOoljOol00`0OOomoo`04Ool00`0OOomo
o`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol017oo00<003W>>Lh0
1cW>00<007ooOol02Woo0`0000Aoo`00000000Eoo`<000Ioo`<000Aoo`<00004Ool000000002Ool3
0002Ool30002Ool30007Ool30005Ool300000goo000000020002Ool30002Ool3003oOoljOol00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@000000
0`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`09Ool4000017oo000000001Goo0`001Woo0`00
17oo0`0000Aoo`000000009oo`<0009oo`<0009oo`<000Moo`<000Aoo`<0009oo`800004Ool007oo
Ool30002Ool3003oOoljOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmk
Kg]_NcW>00=_N`40000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol027oo1@0000=oo`00
00001@0000Aoo`00000000Ioo`<000Aoo`<00004Ool000000002Ool30002Ool30002Ool30007Ool3
0004Ool300001Goo00000000Ool00P0000Aoo`000000009oo`<00?moocYoo`0301moogoo00Aoo`03
01moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo00Ao
o`03000icSW>00LicP03001oogoo00Ioo`H0009oo`<0009oo`800004Ool000000002Ool20002Ool3
0004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001goo0`000goo0`000Woo0`000Woo00<0
07oo00000P000Woo0`00ogoo>Woo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05
>Li_NfmkKg/icP03Kg/100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Eoo`D000Eo
o`<00003Ool00000009oo`<00003Ool00000009oo`<000Aoo`<0009oo`80009oo`8000=oo`P000Mo
o`<000=oo`<00004Ool000000003Ool200000goo00000002Ool2003oOolkOol00`0OOomoo`04Ool0
0`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`04
Ool00`00>LhicP07>Lh00`00Oomoo`04Ool50007Ool40004Ool500000goo0000000400000goo0000
00020003Ool40003Ool30002Ool30007Ool:00000goo000000020002Ool300000goo00000002003o
OollOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40
000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol017oo0`006Goo0P008Woo0P00ogooDGoo
00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40
000000<007ooOol017oo2`001Woo0`0017oo0P0057oo00<007ooOol00Woo0`0077oo00<007ooOol0
ogooCgoo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/1
00000003001oogoo01Ioo`8000=oo`<001Uoo`<00?moofioo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo01Qoo`@00003Ool0
07oo01Qoo`<00?moof]oo`@07`Ioo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0@0000000`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/0
1CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonTOol501l2Ool501l4Ool01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/100000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/1
00000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomo
o`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOond
Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo]7oo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05
>Li_NfmkKg/icP03Kg/100000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03
Kg/1>Lh1Kg/100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@00
00000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00
Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo]7oo
00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo]7oo00@006mk
Kg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_
NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk
>Lh00fmk0@0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk
0@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007oo
Ool0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo
]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?mookAoo`03000icVmk
009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/0
1CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0Fmk0@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40
000000<007ooOol0ogooWGoo1@0O0Woo1@0O0Woo1@0O17oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`4icP5_N`40000000<007ooOol0ogooXGoo00<07gooOol017oo00<07gooOol017oo00<07goo
Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo01Uoo`807`Ioo`80
7omoogioo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_
NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo01Uoo`0301moogoo00Ioo`0301moogoo0?moogao
o`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk
>Lh00fmk0@0000000`00Oomoo`0<Ool201l4Ool00`0OOol07`02Ool00`0OOol07`04Ool01@0OOomo
ogoo01l02goo1@00ogooKWoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00<003W>
Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol02goo00@07gooOol07`9oo`06
01moo`0O01moo`0O0Woo00<07gooOol00Woo00H07gooOomoo`0OOol401l6Ool01@00Oomoogoo0000
ogooKWoo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_
NfmkKg/icP03Kg/100000003001oogoo00Yoo`0301moogoo009oo`0301moo`0O009oo`0301moo`0O
009oo`0301moogoo009oo`0501moogooOol07`0<Ool00`00Oomoo`3oOom_Ool00`0OOomoo`04Ool0
0`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@00
00000`00Oomoo`0:Ool00`0OOomoo`02Ool00`0OOol07`02Ool00`0OOol07`02Ool00`0OOomoo`02
Ool01P0OOomoogoo01moo`@07`Qoo`03001oogoo0?moofioo`0301moogoo00Aoo`0301moogoo00Ao
o`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0:Ool0
0`0OOomoo`02Ool00`0OOol07`02Ool01P0OOol07`0OOol07`Aoo`0501moogooOol07`0>Ool00`00
Oomoo`3oOomZOol401l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0;Ool0100OOomoo`0O1goo00@07gooOol07`=oo`80
7`=oo`0301moogoo00Uoo`05001oogooOol0003oOom^Ool00`0OOomoo`04Ool00`0OOomoo`04Ool0
0`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol037oo0P0O
2goo0P0O0goo00<07gooOol00P0O2goo00D007ooOomoo`000?moofeoo`807`Ioo`0301moogoo00Ao
o`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo
02moo`<00?moofeoo`0301moo`0O00Ioo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonNOol0100OOomoo`0O1Woo00<07gooOol0
17oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007oo
Ool0ogooWGoo00D07gooOomoo`0O00Ioo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonLOol601l6Ool00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonX
Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`400000
00<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_
NcW>00=_N`4icP5_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00@0
06mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`03
01moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?mo
ojQoo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@00
00000`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool0
1000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
ogooWGoo1@0O1Woo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/100000003001oogoo0?mooj5oo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo01Moo`807`Ioo`80
7omooh1oo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>
Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0GOol00`0OOomoo`06Ool00`0OOomoo`3oOomnOol00`0O
Oomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0Fmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`04Ool01@0OOomoogoo01l0
0Woo00<07gooOol027oo1P001Goo0P001Woo1P00ogooFWoo00<07gooOol017oo00<07gooOol017oo
00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo011oo`03
01moo`0O009oo`0301moo`0O00Aoo`0501moogooOol07`04Ool401l7Ool20007Ool20008Ool2003o
OomLOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`0@Ool00`0OOol07`02Ool00`0OOol07`04Ool01@0O
Oomoogoo01l03goo0P001Goo1P001Woo0P00ogooG7oo00<07gooOol017oo00<07gooOol017oo00<0
7gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo011oo`0801mo
o`0O01moo`0OOol07`Aoo`0501moogooOol07`04Ool401l7Ool20007Ool20008Ool2003oOomLOol0
0`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0Fmk0@0000000`00Oomoo`0@Ool01@0OOol07goo01l00Woo00<07gooOol00Woo00D07goo
Oomoo`0O009oo`0301moogoo00Yoo`8000Moo`8000Qoo`800?mooeaoo`0301moogoo00Aoo`0301mo
ogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomo
o`0@Ool00`0OOomoo`04Ool0100OOomoogoo0P0O0goo00<07gooOol03Goo0P004Goo0P00ogooG7oo
00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`4icP5_N`40000000<007ooOol047oo00<07gooOol017oo0P0O0goo00<07gooOol00P0O3Goo
10003goo1000ogooFgoo0P0O1Woo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05
>Li_NfmkKg/icP03Kg/100000003001oogoo031oo`80015oo`800?mooeYoo`0301moo`0O00Ioo`03
01moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/10000
0003001oogoo0?mooiioo`0401moogoo01l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooWGoo00D07gooOomoo`0O00Ioo`03
01moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/10000
0003001oogoo0?mooiaoo`H07`9oo`D07`Ioo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_
Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk
00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00<003W>Kg/00Vmk
00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00@006mk
Kg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009o
o`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02
Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0O
Oomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooY7oo1@0O
1Woo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007oo
Ool0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03
Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05
>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301moogoo
009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOonXOol00`0OOomo
o`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00
Oomoo`04Ool;0006Ool00`00Ool000030006Ool40004Ool40004Ool30002Ool50002Ool40003Ool5
00000goo000000020007Ool40003Ool500000goo000000020003Ool4003oOolkOol00`0OOomoo`04
Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol017oo
00<003W>>Lh01cW>00<007ooOol017oo0`000Woo0`000goo0`0000=oo`0000000Woo0`0000=oo`00
00000Woo0`0000Aoo`00Oomoo`<0009oo`80009oo`8000=oo`<0009oo`<000Moo`80009oo`8000=o
o`<0009oo`<000=oo`<00003Ool000000?moocYoo`0301moogoo00Aoo`0301moogoo009oo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo00Aoo`03000icSW>00LicP03
001oogoo00Aoo`8000Aoo`<00004Ool000000005Ool30006Ool30004Ool3000017oo000000000Woo
0`000Woo0`000Woo0`001Woo0`000Woo0`000Woo0`000Woo0`000Woo0`00ogoo?Woo00<07gooOol0
17oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo00Ao
o`03000icSW>00LicP03001oogoo00Yoo`<00004Ool000000005Ool30006Ool30004Ool3000017oo
000000000Woo0`000Woo0`000Woo0`001Woo0`000Woo0`000Woo0`000Woo0`000Woo0`00ogoo?Woo
00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40
000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol02Goo100000Aoo`00000000Eoo`<000Io
o`<000Aoo`<00004Ool000000002Ool30002Ool30002Ool30006Ool30002Ool30002Ool30002Ool3
0002Ool3003oOolnOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`006<HHaP0<6<H100000003001o
ogoo00Aoo`03000icSW>00LicP03001oogoo00Qoo`D00003Ool0000000D00004Ool000000006Ool3
0004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001Woo0`000Woo0`000Woo0`000Woo0`00
0Woo1`00ogoo>Woo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00
Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`06Ool60002Ool30002Ool2000017oo000000000Woo
0P000Woo0`0017oo0`0000Aoo`000000009oo`<0009oo`<0009oo`<000Ioo`<0009oo`<0009oo`<0
009oo`<0009oo`<0009oo`800?moocYoo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe00]F
]@4HaP40000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol01Goo1@001Goo0`0000=oo`00
00000Woo0`0000=oo`0000000Woo0`0017oo0`000Woo0P000Woo0P000goo20001goo0P000Woo0P00
0goo20000goo0`0000=oo`000000ogoo>Woo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D0
0UJe1VLi0eJe0AS60@0000000`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`04Ool50007Ool4
0004Ool500000goo0000000400000goo000000020003Ool40003Ool30002Ool30009Ool40003Ool3
0002Ool30005Ool4003oOolkOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3
E[D16<H100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Aoo`<001Uoo`800?moogEo
o`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol0
17oo2`001Woo0`0017oo0P0057oo00<007ooOol00Woo0`00ogooKWoo00<07gooOol017oo00<07goo
Ool00Woo00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`0FOol20003Ool3000IOol3003o
Oom^Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H100000003001o
ogoo01Qoo`@00003Ool007oo01Qoo`<00?moof]oo`@07`Ioo`0301moogoo009oo`03001W>EJe009F
]@HaT`=F]@4HaP40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<006Li
E[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`3oOonTOol501l2Ool501l4Ool00`00IcUF]@02E[D6
<I<3E[D16<H100000003001oogoo0?mookAoo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007oo
Ool0ogoo]7oo00<006LiE[D00UJe1Tio0eJe0AS60@0000000`00Oomoo`3oOondOol00`00IcUF]@0;
E[D16<H100000003001oogoo0?mookAoo`03001W>FLi00]W>@4HaP40000000<007ooOol0ogoo]7oo
00<002U::DX032U:0@0000000`00Oomoo`3oOondOol@00000003001oogoo0?mookAoo`03000icSW>
00`icP40000000<007ooOol0ogoo]7oo00<007ooKg/02fmk0CW>0@0000000`00Oomoo`3oOondOol0
0`00Oom_N`02Kg/56<H4Kg/1>Lh100000003001oogoo0?mookAoo`03001oofmk009_N`056<I>Odio
CWlHaP04Kg/1>Lh100000003001oogoo0?mookAoo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1
>Lh100000003001oogoo0?mookAoo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003
001oogoo0?mookAoo`03001ooaS600<HaP=>O`@HaP5_N`4icP40000000<007ooOol0ogoo]7oo00@0
07ooKg/HaPM>O`046<I_Nfmk>Lh100000003001oogoo0?mookAoo`05001oofmkKg/HaP05CWl01AS6
Kg]_Nfmk>Lh00@0000000`00Oomoo`3oOondOol00`00Oom_N`02Kg/01AS6CWm>Odio6<H016mk0CW>
0@0000000`00Oomoo`3oOondOol00`00Oom_N`03Kg/00aS6CWlHaP05Kg/1>Lh100000003001oogoo
0?mookAoo`03001oofmk00A_N`036<I_Nfmk00A_N`4icP40000000<007ooOol0ogoo]7oo00<007oo
Kg/02fmk0CW>0@0000000`00Oomoo`3oOondOol00`00Oomoo`0;Ool1>Lh100000?l00<L0000000<0
04ioCWl0odio`dio0@0000000`00IcUg_@3oMkg2Mkd1CWl100000003001W>GNm0?mg_L9g_@5>O`40
000000<006Li>Lh01CW>00=g_AS6IcT02FLi00=g_CW>>Lh0Y3W>CgNmYcW>00=g_AS6IcT02FLi00=g
_CW>>Lh013W>0Dio0@0000000`00IcUg_@06Mkd00aS6IcTHaP076<H00fLiMkeg_@2]Mkd40003Mkd2
0002Mkd20004Mkd20002Mkd20004Mkd20002Mkd20003Mkd40004Mkd5000;Mkd2002aMkd00aS6IcTH
aP076<H00fLiMkeg_@05Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:Hi
cPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@8000=g_@03
001g_GNm0080009g_@8000]g_@8000Ug_JLicP03MkdHaVLi00MF]@036<IW>GNm00HicP5>O`400000
00<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[GNm0P000WNm0P000WNm0P000WNm0P000gNm
0P000gNm0P000gNm0P000gNm0P000WNm0P001WNm0P000WNm0P002gNm0P00/GNm00<HaVLiE[D01UJe
00<HaVLiMkd01WNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg_@2V>Lh7Mkd2
0002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd60002Mkd20002Mkd2
000;Mkd20009MkfW>Lh00gNm6<IW>@056<H2E[D00aS6IcUg_@06>Lh1CWl100000003001W>GNm00Ig
_@036<IW>EJe00IF]@036<IW>GNm0:eg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g
_@8000=g_@80009g_@80009g_@80009g_@80009g_@80009g_@D000Ag_@800;5g_@036<IW>EJe00=F
]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:Hi
cPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@8000=g_@80009g_@80009g_@80
009g_@80009g_@8000]g_@8000Ug_JLicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@00
00000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2]Mkd20002Mkd20002Mkd50003Mkd40002
Mkd20002Mkd40002Mkd20003Mkd40004Mkd5000;Mkd2002aMkd00aS6IcUF]@03E[D01AS6E[EF]AS6
IcT01gNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@07E[D00aS6IcUg_@2V>Lh7Mkd20002Mkd2
000;Mkd20008Mkd20003Mkd2000>Mkd2000:Mkd30009MkfW>Lh00gNm6<IW>@04E[D01QS6E[EF]AS6
IcUg_@HicP5>O`40000000<006LiMkd01WNm00<HaVLiIcT026Li[WNm0P000WNm0P002gNm0P000gNm
0P000gNm0P000gNm0P003WNm0P002gNm0P00/GNm00<HaVLiIcT026Li1gNm0Dio0@0000000`00IcTi
cP05>Lh00gNm6<HHaP096<H00gNm>LhicP2T>Li?MkfW>Lh00gNm6<HHaP096<H00gNm>LhicP04>Lh1
CWl100000003001W>GNm0?mg_L9g_@5>O`40000000<006LiMkd0ogNm`WNm0Dio0@0000000`00IcUW
>@3oIcW2IcT1CWl100000?l00<L00000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{454, 214},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "By default, section cells are set up so that they put all cells from the \
section heading down to the next section cell (or the end of the notebook) \
into a cell group. (To turn off automatic cell grouping, we pull down the \
Cell menu and choose ",
  StyleBox["Manual Grouping", "MenuItem"],
  " from the Cell Grouping submenu. To group cells manually, we select the \
cells to be grouped, then choose ",
  StyleBox["Group Cells", "MenuItem"],
  " from the Cell Grouping submenu.) We close the cell groups corresponding \
to each section by double-clicking the cell bracket of each group. The result \
is similar to the following figure."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000770000J1000`40O003h00O00<007ooOol0ogoo
]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk
009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk
>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001o
ogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo
0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00
>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_Nfmk
Kg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>
Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P000000
0`00Oomoo`3oOon[Ool50004Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@00
00000`00Oomoo`3oOonZOol70003Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<0
07ooOol0ogooY7oo1@0O00=oo`0000000`0000=nL`00Ool00Woo00<003W>Kg/00Vmk00DicVmkKg]_
NcW>00=_N`03>Li_N`000040000000<007ooOol0ogooZ7oo00<07goo00000`000Wic00D007ooOomo
o`00009_N`05>Li_NfmkKg/icP03Kg/013W>Kg]_Nfmk0P0000000`00Oomoo`3oOonXOol00`0OOol0
00020003OW<01P00Oomoogoo000icP=_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001o
ogoo0?moojQoo`0401moo`000004OW<01@00Oomoogoo00000Vmk00DicVmkKg]_NcW>00=_N`04>Li_
NfmkKg/200000003001oogoo0?moojQoo`0301moo`0000EnL`06001oogooOol003W>0fmk00DicVmk
Kg]_NcW>00=_N`03>Li_N`000040000000<007ooOol017oo2`001Woo00<007oo00000`001Woo1000
17oo100017oo0`000Woo1@000Woo10000goo1@0000=oo`0000000P001goo0`001Goo0P000Woo0P00
1Goo1000ogoo?7oo00<07goo0000100000=nL`00Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/200000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Aoo`<0009oo`<000=oo`<0
0003Ool00000009oo`<00003Ool00000009oo`<00004Ool007ooOol30002Ool20002Ool20003Ool3
0002Ool30007Ool300000goo001oo`03Ool20002Ool20004Ool20002Ool2003oOolkOol00`0OOol0
000400000gic001oo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@000000
0`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`04Ool20004Ool3000017oo000000001Goo0`00
1Woo0`0017oo0`0000Aoo`000000009oo`<0009oo`<0009oo`<000Moo`<000Eoo`P0009oo`<0009o
o`<00?moocYoo`0301moo`0000@00003OW<007oo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0P0000000`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`0:Ool3000017oo000000001Goo
0`001Woo0`0017oo0`0000Aoo`000000009oo`<0009oo`<0009oo`<000Moo`<000Eoo`<00003Ool0
00000080009oo`<0009oo`<00?moocYoo`0301moo`0000@00003OW<007oo009oo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo00Aoo`03000icSW>00LicP03001o
ogoo00Uoo`@00004Ool000000005Ool30006Ool30004Ool3000017oo000000000Woo0`000Woo0`00
0Woo0`001goo0`0017oo0`000Woo0P0000Aoo`00Oomoo`<0009oo`<00?moocYoo`0301moo`0000@0
0003OW<007oo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`04Ool0
0`00>LhicP07>Lh00`00Oomoo`08Ool500000goo00000005000017oo000000001Woo0`0017oo0`00
00Aoo`000000009oo`<0009oo`<0009oo`<000Moo`<000Aoo`<00005Ool00000001oo`02000017oo
000000000Woo0`00ogoo>Woo00<07goo0000100000=nL`00Ool00Woo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`03>Li_N`000040000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol01Woo
1P000Woo0`000Woo0P0000Aoo`000000009oo`80009oo`<000Aoo`<00004Ool000000002Ool30002
Ool30002Ool30007Ool30003Ool30002Ool30002Ool00`00Ool000020002Ool3003oOoljOol00`0O
Ool0000400000gic001oo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007oo
Ool017oo00<003W>>Lh01cW>00<007ooOol01Goo1@001Goo0`0000=oo`0000000Woo0`0000=oo`00
00000Woo0`0017oo0`000Woo0P000Woo0P000goo20001goo0`000goo0`0000Aoo`00000000=oo`80
0003Ool00000009oo`800?mooc]oo`0301moo`0000@00003OW<007oo009oo`03000icVmk009_N`05
>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo
00Aoo`D000Moo`@000Aoo`D00003Ool0000000@00003Ool00000008000=oo`@000=oo`<0009oo`<0
00Moo`X00003Ool000000080009oo`<00003Ool0000000800?moocaoo`0301moo`0000@00003OW<0
07oo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`04Ool00`00>Lhi
cP07>Lh00`00Oomoo`04Ool3000IOol2000ROol2003oOomAOol00`0OOol0000400000gic001oo`02
Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`04Ool;0006
Ool30004Ool2000DOol00`00Oomoo`02Ool3000LOol00`00Oomoo`3oOom?Ool00`0OOol000040000
0gic001oo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol05Woo0P00
0goo0`006Goo0`00ogooKWoo00<07goo0000100000=nL`00Ool00Woo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`03>Li_N`000040000000<007ooOol067oo100000=oo`00Ool067oo0`00ogooJgoo
100O00=oo`0000000`0000=nL`00Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/20000
0003001oogoo0?moojQoo`0301moo`0000@00003OW<007oo009oo`03000icVmk009_N`05>Li_Nfmk
Kg/icP03Kg/00cW>Kg/0000100000003001oogoo0?moojAoo`D07`03Ool007ic00AnL`05001oogoo
Ool00002Kg/01CW>Kg]_Nfmk>Lh00fmk00@icVmkKg]_N`80000000<007ooOol0ogooZWoo1`000goo
00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogooZgoo1@00
17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk
009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk
>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001o
ogoo0?moojAoo`D07`Ioo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>
Kg/0000100000003001oogoo0?moojQoo`0301moogoo00=oo`807`Aoo`04001_Nfmk>Lh3Kg/01CW>
Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOonXOol00`0OOomoo`02Ool301l4Ool00`00>Li_N`02
Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOonXOol0100OOomoogoo100O
17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?moojQoo`0301moogoo
00D07`Aoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo00Ao
o`/000Ioo`03001oo`0000<000Ioo`@000Aoo`@000Aoo`<0009oo`D0009oo`@000=oo`D00003Ool0
0000008000Moo`@000=oo`D00003Ool00000008000=oo`@00?mooc]oo`0301moogoo00Aoo`0301mo
ogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`04Ool00`00>Lhi
cP07>Lh00`00Oomoo`04Ool30002Ool30003Ool300000goo00000002Ool300000goo00000002Ool3
000017oo001oogoo0`000Woo0P000Woo0P000goo0`000Woo0`001goo0P000Woo0P000goo0`000Woo
0`000goo0`0000=oo`000000ogoo>Woo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk
00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol017oo00<003W>>Lh01cW>00<007oo
Ool017oo0P0017oo0`0000Aoo`00000000Eoo`<000Ioo`<000Aoo`<00004Ool000000002Ool30002
Ool30002Ool30006Ool30002Ool30002Ool30002Ool30002Ool3003oOolnOol00`0OOomoo`04Ool0
0`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol017oo00<0
03W>>Lh01cW>00<007ooOol02Woo0`0000Aoo`00000000Eoo`<000Ioo`<000Aoo`<00004Ool00000
0002Ool30002Ool30002Ool30006Ool30002Ool30002Ool30002Ool30002Ool3003oOolnOol00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@00
00000`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`09Ool4000017oo000000001Goo0`001Woo
0`0017oo0`0000Aoo`000000009oo`<0009oo`<0009oo`<000Ioo`<0009oo`<0009oo`<0009oo`<0
009oo`<00?moocioo`0301moogoo00Aoo`0301moogoo009oo`03000HaQS600`HaP80000000<007oo
Ool017oo00<003W>>Lh01cW>00<007ooOol027oo1@0000=oo`0000001@0000Aoo`00000000Ioo`<0
00Aoo`<00004Ool000000002Ool30002Ool30002Ool30006Ool30002Ool30002Ool30002Ool30002
Ool7003oOoljOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUF]@0;E[D16<H1000100000003
001oogoo00Aoo`03000icSW>00LicP03001oogoo00Ioo`H0009oo`<0009oo`800004Ool000000002
Ool20002Ool30004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001Woo0`000Woo0`000Woo
0`000Woo0`000Woo0`000Woo0P00ogoo>Woo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D0
2eJe0AS60@000@0000000`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`05Ool50005Ool30000
0goo00000002Ool300000goo00000002Ool30004Ool30002Ool20002Ool20003Ool80007Ool20002
Ool20003Ool80003Ool300000goo0000003oOoljOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
IcUF]@02E[D6IcT3E[D16<H1000100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Ao
o`D000Moo`@000Aoo`D00003Ool0000000@00003Ool00000008000=oo`@000=oo`<0009oo`<000Uo
o`@000=oo`<0009oo`<000Eoo`@00?mooc]oo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe
009F]@HaT`=F]@4HaP400040000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol017oo0`00
6Goo0P00ogooMGoo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@00
0@0000000`00Oomoo`04Ool;0006Ool30004Ool2000DOol00`00Oomoo`02Ool3003oOom^Ool00`0O
Oomoo`04Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3E[D16<H1000100000003001oogoo01Io
o`8000=oo`<001Uoo`<00?moofioo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe009F]@IW
>@=F]@4HaP400040000000<007ooOol067oo100000=oo`00Ool067oo0`00ogooJgoo100O1Woo00<0
7gooOol00Woo00<006LiE[D00UJe1S6C0eJe0AS60@000@0000000`00Oomoo`3oOonXOol00`0OOomo
o`04Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6IcT3E[D16<H1000100000003001oogoo0?moojAo
o`D07`9oo`D07`Aoo`03001W>EJe009F]@HaT`=F]@4HaP400040000000<007ooOol0ogoo]7oo00<0
06LiE[D00UJe1VLi0eJe0AS60@000@0000000`00Oomoo`3oOondOol00`00IcUF]@02E[D6CWl3E[D1
6<H1000100000003001oogoo0?mookAoo`03001W>EJe00]F]@4HaP400040000000<007ooOol0ogoo
]7oo00<006LiIcT02fLi0AS60@000@0000000`00Oomoo`3oOondOol00`00:DXYBP0<:DX200000003
001oogoo0?mookAooa40000000<007ooOol0ogoo]7oo00<003W>>Lh033W>0P0000000`00Oomoo`3o
OondOol00`00Oom_N`0;Kg/1>Lh1000100000003001oogoo0?mookAoo`03001oofmk009_N`DHaPA_
N`4icP400040000000<007ooOol0ogoo]7oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40
0040000000<007ooOol0ogoo]7oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP4000400000
00<007ooOol0ogoo]7oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP400040000000<007oo
Ool0ogoo]7oo00<007oo6<H00aS60dio11S600=_NcW>00000@0000000`00Oomoo`3oOondOol01000
Oom_NaS61dio00@HaVmkKg/icP80000000<007ooOol0ogoo]7oo00D007ooKg]_NaS600E>O`056<I_
NfmkKg/icP0200000003001oogoo0?mookAoo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh1
000100000003001oogoo0?mookAoo`03001oofmk00=_N`036<I>OaS600E_N`4icP400040000000<0
07ooOol0ogoo]7oo00<007ooKg/016mk00<HaVmkKg/016mk0CW>0@000@0000000`00Oomoo`3oOond
Ool00`00Oom_N`0;Kg/1>Lh1000100000003001oogoo0?mookAoo`03001oogoo00]oo`4icP400040
0000o`00b00000000`00CWm>O`3oCWo3CWl200000003001W>GNm0?mg_L9g_@5>O`400040000000<0
06LiMkd0ogNm`WNm0Dio0@000@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm>LhicP2T>Li?
MkfW>Lh00gNm6<IW>@09IcT00gNm>LhicP04>Lh1CWl1000100000003001W>GNm00Ig_@036<IW>AS6
00LHaP03IcUg_GNm0:eg_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@8000=g_@@0
00Ag_@D000]g_@800;5g_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`400040000000<006Li>Lh0
1CW>00=g_AS6IcT01eJe00<HaVLiMkd0YSW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm
0P000gNm0P000gNm0P000WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYcW>00=g_AS6
IcT01eJe00<HaVLiMkd01SW>0Dio0@000@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg
_@2]Mkd20002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd2
0002Mkd2000;Mkd2002aMkd00aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl1000100000003001W>CW>
00DicP03MkdHaVLi00MF]@036<IW>GNm0:HicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g
_@8000=g_@8000=g_@80009g_@H0009g_@80009g_@8000]g_@8000Ug_JLicP03MkdHaVLi00DHaP9F
]@036<IW>GNm00HicP5>O`400040000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[GNm
0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm
0P000WNm0P000WNm1@0017Nm0P00/GNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`400040
000000<006Li>Lh01CW>00=g_AS6IcT01eJe00<HaVLiMkd0YSW>1gNm0P000WNm0P000WNm0P000WNm
0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNm
YcW>00=g_AS6IcT015Je00HHaUJeE[DHaVLiMkd6>Lh1CWl1000100000003001W>GNm00Ig_@036<IW
>EJe00IF]@036<IW>GNm0:eg_@80009g_@80009g_@D000=g_@@0009g_@80009g_@@0009g_@8000=g
_@@000Ag_@D000]g_@800;5g_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl1000100000003
001W>CW>00DicP03MkdHaVLi00MF]@036<IW>GNm0:HicPMg_@80009g_@8000]g_@8000Qg_@8000=g
_@8000ig_@8000Yg_@<000Ug_JLicP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@000@00
00000`00IcUg_@06Mkd00aS6IcUW>@08IcV^Mkd20002Mkd2000;Mkd20003Mkd20003Mkd20003Mkd2
000>Mkd2000;Mkd2002aMkd00aS6IcUW>@08IcT7Mkd1CWl1000100000003001W>CW>00DicP03MkdH
aQS600THaP03MkdicSW>0:@icTmg_JLicP03MkdHaQS600THaP03MkdicSW>00@icP5>O`4000400000
00<006LiMkd0ogNm`WNm0Dio0@000@0000000`00IcUg_@3oMkg2Mkd1CWl1000100000003001W>FLi
0?mW>L9W>@5>O`4000400000o`00a`000Goo0000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{455, 104},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
We can insert a title cell at the top of the notebook as well, by \
creating a new cell at the top of the notebook, then changing it to a title \
cell.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000760000UA000`40O003h00O00<007ooOol0ogoo
]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo]7oo00@0
06mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?mookAoo`03000icVmk009_N`05
>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_
Nfmk>Lh00fmk0@0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>
0Fmk0@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<0
07ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?mookAoo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?mookAoo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk
>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonMOol501l6Ool00`0OOomoo`0501l4Ool01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooXGoo00<07gooOol00goo0P0O1Woo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
ogooXGoo00<07gooOol00Woo0`0O1Woo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/100000003001oogoo0?mooj5oo`0401moogooOol401l6Ool00`0OOomoo`02Ool00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonQOol00`0OOomoo`0501l6
Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol017oo
2`001Woo00<007oo00000`001Woo100017oo100017oo0`000Woo1@000Woo10000goo1@0000=oo`00
00000P001goo0`001Goo0P000Woo0P001Goo1000ogoo=Goo00<07gooOol017oo00<07gooOol017oo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
17oo00<003W>>Lh01cW>00<007ooOol017oo0`000Woo0`000goo0`0000=oo`0000000Woo0`0000=o
o`0000000Woo0`0000Aoo`00Oomoo`<0009oo`80009oo`8000=oo`<0009oo`<000Moo`<00003Ool0
07oo00=oo`80009oo`8000Aoo`80009oo`800?moocAoo`0301moogoo00Aoo`0301moogoo00Aoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`04Ool00`00
>LhicP07>Lh00`00Oomoo`04Ool20004Ool3000017oo000000001Goo0`001Woo0`0017oo0`0000Ao
o`000000009oo`<0009oo`<0009oo`<000Moo`<000Eoo`P0009oo`<0009oo`<00?mooc=oo`0301mo
ogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1
>Lh1Kg/100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Yoo`<00004Ool000000005
Ool30006Ool30004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001goo0`001Goo0`0000=o
o`0000000P000Woo0`000Woo0`00ogoo<goo00<07gooOol017oo00<07gooOol017oo00<07gooOol0
0Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo00Aoo`03000icSW>00Li
cP03001oogoo00Uoo`@00004Ool000000005Ool30006Ool30004Ool3000017oo000000000Woo0`00
0Woo0`000Woo0`001goo0`0017oo0`000Woo0P0000Aoo`00Oomoo`<0009oo`<00?mooc=oo`0301mo
ogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1
>Lh1Kg/100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Qoo`D00003Ool0000000D0
0004Ool000000006Ool30004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001goo0`0017oo
0`0000Eoo`00000007oo00800004Ool000000002Ool3003oOolcOol00`0OOomoo`04Ool00`0OOomo
o`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0
17oo00<003W>>Lh01cW>00<007ooOol01Woo1P000Woo0`000Woo0P0000Aoo`000000009oo`80009o
o`<000Aoo`<00004Ool000000002Ool30002Ool30002Ool30007Ool30003Ool30002Ool30002Ool0
0`00Ool000020002Ool3003oOolcOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`04Ool00`00>LhicP07
>Lh00`00Oomoo`05Ool50005Ool300000goo00000002Ool300000goo00000002Ool30004Ool30002
Ool20002Ool20003Ool80007Ool30003Ool3000017oo000000000goo0P0000=oo`0000000Woo0P00
ogoo=7oo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_
NfmkKg/icP03Kg/100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Aoo`D000Moo`@0
00Aoo`D00003Ool0000000@00003Ool00000008000=oo`@000=oo`<0009oo`<000Moo`X00003Ool0
00000080009oo`<00003Ool0000000800?moocEoo`0301moogoo00Aoo`0301moogoo00Aoo`0301mo
ogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo00Aoo`03
000icSW>00LicP03001oogoo00Aoo`<001Uoo`80029oo`800?moodYoo`0301moogoo00Aoo`0301mo
ogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomo
o`04Ool;0006Ool30004Ool2000DOol00`00Oomoo`02Ool3000LOol00`00Oomoo`3oOom8Ool00`0O
Oomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0Fmk0@0000000`00Oomoo`0FOol20003Ool3000IOol3003oOomWOol00`0OOomoo`04Ool00`0O
Oomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007oo
Ool067oo100000=oo`00Ool067oo0`00ogooI7oo100O1Woo00<07gooOol017oo00<07gooOol00Woo
00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooXGoo00<07goo
Ool017oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/1
00000003001oogoo0?mooieoo`D07`9oo`D07`Ioo`0301moogoo009oo`03000icVmk009_N`05>Li_
NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02
Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00<0
03W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo[goo00<07gooOol0
0Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo
009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool0
0`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3o
OonMOol501l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`40000000<007ooOol0ogooXGoo00<07gooOol00goo0P0O1Woo00<07gooOol00Woo00<003W>
Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooXGoo00<07gooOol00Woo
0`0O1Woo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo
0?mooj5oo`0401moogooOol401l6Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk0CW>0Fmk0@0000000`00Oomoo`3oOonQOol00`0OOomoo`0501l6Ool00`0OOomoo`02Ool01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol017oo2`001Woo00<007oo00000`00
1Woo100017oo100017oo0`000Woo1@000Woo10000goo1@0000=oo`0000000P001goo10000goo1@00
00=oo`0000000P000goo1000ogoo=7oo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo
00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol017oo00<003W>>Lh0
1cW>00<007ooOol017oo0`000Woo0`000goo0`0000=oo`0000000Woo0`0000=oo`0000000Woo0`00
00Aoo`00Oomoo`<0009oo`80009oo`8000=oo`<0009oo`<000Moo`80009oo`8000=oo`<0009oo`<0
00=oo`<00003Ool000000?mooc=oo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo009oo`04
001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`04Ool00`00>LhicP07>Lh00`00
Oomoo`04Ool20004Ool3000017oo000000001Goo0`001Woo0`0017oo0`0000Aoo`000000009oo`<0
009oo`<0009oo`<000Ioo`<0009oo`<0009oo`<0009oo`<0009oo`<00?moocMoo`0301moogoo00Ao
o`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/1
00000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Yoo`<00004Ool000000005Ool30006
Ool30004Ool3000017oo000000000Woo0`000Woo0`000Woo0`001Woo0`000Woo0`000Woo0`000Woo
0`000Woo0`00ogoo=goo00<07gooOol017oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/i
cP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo00Aoo`03000icSW>00LicP03001oogoo00Uo
o`@00004Ool000000005Ool30006Ool30004Ool3000017oo000000000Woo0`000Woo0`000Woo0`00
1Woo0`000Woo0`000Woo0`000Woo0`000Woo0`00ogoo=goo00<07gooOol017oo00<07gooOol017oo
00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0
17oo00<003W>>Lh01cW>00<007ooOol027oo1@0000=oo`0000001@0000Aoo`00000000Ioo`<000Ao
o`<00004Ool000000002Ool30002Ool30002Ool30006Ool30002Ool30002Ool30002Ool30002Ool7
003oOolcOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00Di
cVmkKg]_NcW>00=_N`40000000<007ooOol017oo00<003W>>Lh01cW>00<007ooOol01Woo1P000Woo
0`000Woo0P0000Aoo`000000009oo`80009oo`<000Aoo`<00004Ool000000002Ool30002Ool30002
Ool30006Ool30002Ool30002Ool30002Ool30002Ool30002Ool2003oOolcOol00`0OOomoo`04Ool0
0`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@00
00000`00Oomoo`04Ool00`00>LhicP07>Lh00`00Oomoo`05Ool50005Ool300000goo00000002Ool3
00000goo00000002Ool30004Ool30002Ool20002Ool20003Ool80007Ool20002Ool20003Ool80003
Ool300000goo0000003oOolcOol00`0OOomoo`04Ool00`0OOomoo`04Ool00`0OOomoo`02Ool01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol017oo00<003W>>Lh01cW>00<007oo
Ool017oo1@001goo100017oo1@0000=oo`000000100000=oo`0000000P000goo10000goo0`000Woo
0`002Goo10000goo0`000Woo0`001Goo1000ogoo=7oo00<07gooOol017oo00<07gooOol017oo00<0
7gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol017oo
00<003W>>Lh01cW>00<007ooOol017oo0`006Goo0P00ogooKWoo00<07gooOol017oo00<07gooOol0
17oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo00Ao
o`/000Ioo`<000Aoo`8001Aoo`03001oogoo009oo`<00?moofMoo`0301moogoo00Aoo`0301moogoo
00Aoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001o
ogoo01Ioo`8000=oo`<001Uoo`<00?moofMoo`0301moogoo00Aoo`0301moogoo00Aoo`0301moogoo
009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`0HOol400000goo001o
o`0HOol3003oOomTOol401l6Ool00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonQOol00`0OOomoo`04Ool00`0OOomoo`04
Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo
WGoo1@0O0Woo1@0O1Woo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_
N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03
Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03
Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_
Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk
00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00<003W>Kg/00Vmk
00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00@006mk
Kg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009o
o`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02
Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0O
Oomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<0
7gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo
[goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?mo
ojmoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001o
ogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00
Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@00
00000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40
000000<007ooOol0ogoo[goo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4i
cP5_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/i
cP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>
Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>
Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogoo[goo00<07gooOol00Woo00@0
06mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojmoo`0301moogoo009oo`03
000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojmoo`0301moogoo
009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomoo`3oOon_Ool00`0OOomo
o`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`3oOonTOol5
01l6Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0
ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4i
cP5_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/100000003001oogoo0?moojQoo`0301moogoo00Aoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo0?moojQoo`0301mo
ogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@0000000`00Oomo
o`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk
0CW>0Fmk0@0000000`00Oomoo`3oOonXOol00`0OOomoo`04Ool00`0OOomoo`02Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol0
0Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`4icP5_N`40000000<007ooOol0ogooZ7oo00<0
7gooOol017oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/100000003001o
ogoo00Eoo`D000eoo`D000moo`D000Moo`D000Uoo`P000aoo`H000Qoo`L000Uoo`D000=oo`H000ao
o`P000ioo`P000Uoo`D000Ioo`H00=ioo`0301moogoo00Aoo`0301moogoo009oo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/1>Lh1Kg/100000003001oogoo00Eoo`H000]oo`D0011oo`D000Moo`D0
00Moo``000Uoo`L000Ioo``000Ioo`D00003Ool0000000L000Uoo``000Yoo``000Moo`D000Eoo`H0
0=moo`0301moogoo00Aoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0@00
00000`00Oomoo`06Ool5000;Ool5000@Ool50007Ool50006Ool>0007Ool80005Ool>0005Ool@0007
Ool>0008Ool>0006Ool50005Ool6003OOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00>Li_N`02
Kg/01CW>Kg]_Nfmk>Lh00fmk0CW>0Fmk0@0000000`00Oomoo`06Ool5000;Ool5000@Ool50007Ool5
0005Ool@0006Ool80004Ool@0004OolA0005Ool@0006Ool@0005Ool50004Ool6003POol00`0OOomo
o`04Ool00`0OOomoo`02Ool00`006<HHaP0<6<H100000003001oogoo00Ioo`H000Uoo`D0015oo`D0
00Moo`D000Aoo`L000Aoo`L000Eoo`D000Ioo`L000Aoo`H000Aoo`L000Eoo`H000=oo`L000Aoo`L0
00Aoo`L000Aoo`L000Aoo`D000Aoo`H00>1oo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe
00]F]@4HaP40000000<007ooOol01goo1@002Goo1@004Goo1@001goo1@0017oo1@0027oo1@001Goo
1@001Woo1@001goo1P000goo1P001goo1@000goo1@0027oo1@0017oo1@0027oo1@0017oo1@000goo
1P00hGoo00<07gooOol017oo00<07gooOol00Woo00<006LiE[D02eJe0AS60@0000000`00Oomoo`07
OolC000AOol50007Ool50004Ool50008Ool50005Ool50005Ool6000@Ool60007Ool60002Ool50008
Ool50004Ool50008Ool50004Ool50003Ool6003QOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
IcUF]@02E[D6IcT3E[D16<H100000003001oogoo00Mooa80019oo`D000Moo`D000=oo`D000Yoo`D0
00Aoo`D000Eoo`D0015oo`D000Uoo`D00003Ool0000000<000Yoo`D0009oo`D000Yoo`D000=oo`H0
0003Ool0000000@00>9oo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4H
aP40000000<007ooOol027oo4@004Woo1@001goo1@000goo1@002Woo1@0017oo1@001Goo1@004Goo
1@002Goo1@0000=oo`0000000`002Woo1@000Woo1@002Woo1@000goo3000hgoo00<07gooOol017oo
00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`08OolA000BOol50007
Ool50003Ool5000:Ool50004Ool50005OolC0003Ool50009Ool500000goo00000003000:Ool50002
Ool5000:Ool50003Ool<003SOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00IcUF]@02E[D6<I<3
E[D16<H100000003001oogoo00Qoo`D000Ioo`D001=oo`D000Moo`D000=oo`D000Yoo`D000Aoo`D0
00Eooa<000=oo`D000Uoo`D00003Ool0000000<000Yoo`D0009oo`D000Yoo`D000=oo`/00>Aoo`03
01moogoo00Aoo`0301moogoo009oo`03001W>EJe009F]@IW>@=F]@4HaP40000000<007ooOol02Goo
1@001Goo1@004goo1@001goo1@000goo1@002Woo1@0017oo1@001Goo4`000goo1@002Goo1@0000=o
o`0000000`002Woo1@000Woo1@002Woo1@000goo2`00i7oo00<07gooOol017oo00<07gooOol00Woo
00<006LiE[D00UJe1S6C0eJe0AS60@0000000`00Oomoo`09Ool50005Ool5000COol50007Ool50003
Ool5000:Ool50004Ool50005Ool50009Ool50003Ool50009Ool500000goo00000003000:Ool50002
Ool5000:Ool50003Ool500000goo00000002003UOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
IcUF]@02E[D6IcT3E[D16<H100000003001oogoo00Yoo`@000Eoo`@001Aoo`D000Moo`D000Aoo`D0
00Qoo`D000Eoo`D000Eoo`D000Uoo`D000=oo`H000Moo`H0009oo`D000Qoo`D000Aoo`D000Qoo`D0
00Aoo`D0009oo`@00>Aoo`0301moogoo00Aoo`0301moogoo009oo`03001W>EJe009F]@HaT`=F]@4H
aP40000000<007ooOol02Woo1@000goo1@0057oo1P001Woo1@0017oo1@0027oo1@001Goo1@001Woo
1@001goo1@0017oo1P001goo1@000goo1@0027oo1@0017oo1@0027oo1@0017oo1@000Woo1@00hgoo
00<07gooOol017oo00<07gooOol00Woo00<006LiE[D00UJe1VLi0eJe0AS60@0000000`00Oomoo`0:
Ool50003Ool5000DOol70004Ool60004Ool70004Ool70005Ool50006Ool60005Ool60004Ool70005
Ool60003Ool70004Ool70004Ool70004Ool70004Ool50003Ool5003ROol00`0OOomoo`04Ool00`0O
Oomoo`02Ool00`00IcUF]@02E[D6CWl3E[D16<H100000003001oogoo00]oo`@000=oo`@001Eooa40
00Eooa0000=oo`/000Aoo`l000Eooa4000Eooa0000Iooa0000Eoo`D000Aoo`D00>5oo`0301moogoo
00Aoo`0301moogoo009oo`03001W>EJe00]F]@4HaP40000000<007ooOol02goo1@0000=oo`000000
0`005Goo40001goo3P0017oo2`001Goo3@001Woo4@001Woo3P0027oo3P001Woo1@001Goo1@00h7oo
00<07gooOol017oo00<07gooOol00Woo00<006LiIcT02fLi0AS60@0000000`00Oomoo`0;Ool50000
0goo00000003000EOol500000goo000000070009Ool<0005Ool;0006Ool;0007Ool500000goo0000
00080008Ool<000:Ool<0007Ool50006Ool4003POol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00
:DXYBP0<:DX100000003001oogoo00aoo`@00003Ool00000008001Ioo`D000=oo`D000eoo`P000Mo
o`/000Qoo`L000Uoo`D000=oo`H000aoo`P000ioo`P000Uoo`D000Ioo`D00=moo`0301moogoo00Ao
o`0301moogoo009ooa00000000<007ooOol037oo2@00@Woo1@006goo1@00?7oo1@00jWoo00<07goo
Ool017oo00<07gooOol00Woo00<003W>>Lh033W>0@0000000`00Oomoo`0<Ool90012Ool5000KOol5
000lOol5003ZOol00`0OOomoo`04Ool00`0OOomoo`02Ool00`00Oom_N`0;Kg/1>Lh100000003001o
ogoo00eoo`L004=oo`D001]oo`D003aoo`D00>Yoo`0301moogoo00Aoo`0301moogoo009oo`03001o
ofmk009_N`DHaPA_N`4icP40000000<007ooOol03Goo1`00@goo1@006goo1@00?7oo1@00jWoo00<0
7gooOol017oo00<07gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<0
07ooOol03Goo1`00@goo1@006goo1@00?7oo1@00jWoo00<07gooOol017oo00<07gooOol00Woo00<0
07ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40000000<007ooOol03Woo1@00I7oo1@00?7oo1@00
jWoo00<07gooOol017oo00<07gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP40
000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00<007oo6<H00aS60dio11S6
0Fmk0CW>0@0000000`00Oomoo`3oOonUOol401l6Ool00`0OOomoo`02Ool01000Oom_NaS61dio00@H
aVmkKg/icP40000000<007ooOol0ogooZ7oo00<07gooOol017oo00<07gooOol00Woo00D007ooKg]_
NaS600E>O`056<I_NfmkKg/icP0100000003001oogoo0?moojAoo`D07`9oo`D07`Aoo`03001oofmk
009_N`056<I>OdioCWlHaP04Kg/1>Lh100000003001oogoo0?mookAoo`03001oofmk00=_N`036<I>
OaS600E_N`4icP40000000<007ooOol0ogoo]7oo00<007ooKg/016mk00<HaVmkKg/016mk0CW>0@00
00000`00Oomoo`3oOondOol00`00Oom_N`0;Kg/1>Lh100000003001oogoo0?mookAoo`03001oogoo
00]oo`4icP400000o`00a`0000000`00CWm>O`3oCWo3CWl100000003001W>GNm0?mg_L9g_@5>O`40
000000<006LiMkd0ogNm`WNm0Dio0@0000000`00IcTicP05>Lh00gNm6<IW>@09IcT00gNm>LhicP2T
>Li?MkfW>Lh00gNm6<IW>@09IcT00gNm>LhicP04>Lh1CWl100000003001W>GNm00Ig_@036<IW>AS6
00LHaP03IcUg_GNm0:eg_@@000=g_@80009g_@8000Ag_@80009g_@8000Ag_@80009g_@8000=g_@@0
00Ag_@D000]g_@800;5g_@036<IW>AS600LHaP03IcUg_GNm00Eg_@5>O`40000000<006Li>Lh01CW>
00=g_AS6IcT01eJe00<HaVLiMkd0YSW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P00
0gNm0P000gNm0P000WNm0P000gNm00<007NmMkd00P000WNm0P002gNm0P002GNmYcW>00=g_AS6IcT0
1eJe00<HaVLiMkd01SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUF]@06E[D00aS6IcUg_@2]Mkd2
0002Mkd20002Mkd20002Mkd20003Mkd20003Mkd20003Mkd20003Mkd20002Mkd20006Mkd20002Mkd2
000;Mkd2002aMkd00aS6IcUF]@06E[D00aS6IcUg_@06Mkd1CWl100000003001W>CW>00DicP03MkdH
aVLi00MF]@036<IW>GNm0:HicPMg_@80009g_@80009g_@80009g_@8000=g_@8000=g_@8000=g_@80
00=g_@80009g_@H0009g_@80009g_@8000]g_@8000Ug_JLicP03MkdHaVLi00DHaP9F]@036<IW>GNm
00HicP5>O`40000000<006LiMkd01WNm00<HaVLiE[D01UJe00<HaVLiMkd0[GNm0P000WNm0P000WNm
0P000WNm0P000gNm0P000gNm0P000gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm
1@0017Nm0P00/GNm00<HaVLiE[D00eJe00DHaUJeE[DHaVLi00Mg_@5>O`40000000<006Li>Lh01CW>
00=g_AS6IcT01eJe00<HaVLiMkd0YSW>1gNm0P000WNm0P000WNm0P000WNm0P000gNm0P000gNm0P00
0gNm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P002gNm0P002GNmYcW>00=g_AS6IcT015Je
00HHaUJeE[DHaVLiMkd6>Lh1CWl100000003001W>GNm00Ig_@036<IW>EJe00IF]@036<IW>GNm0:eg
_@80009g_@80009g_@D000=g_@@0009g_@80009g_@@0009g_@8000=g_@@000Ag_@D000]g_@800;5g
_@036<IW>EJe00=F]@056<IF]EJe6<IW>@07Mkd1CWl100000003001W>CW>00DicP03MkdHaVLi00MF
]@036<IW>GNm0:HicPMg_@80009g_@8000]g_@8000Qg_@8000=g_@8000ig_@8000Yg_@<000Ug_JLi
cP03MkdHaVLi00AF]@066<IF]EJe6<IW>GNm1SW>0Dio0@0000000`00IcUg_@06Mkd00aS6IcUW>@08
IcV^Mkd20002Mkd2000;Mkd20003Mkd20003Mkd20003Mkd2000>Mkd2000;Mkd2002aMkd00aS6IcUW
>@08IcT7Mkd1CWl100000003001W>CW>00DicP03MkdHaQS600THaP03MkdicSW>0:@icTmg_JLicP03
MkdHaQS600THaP03MkdicSW>00@icP5>O`40000000<006LiMkd0ogNm`WNm0Dio0@0000000`00IcUg
_@3oMkg2Mkd1CWl100000003001W>FLi0?mW>L9W>@5>O`400000o`00a`000000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{454, 149},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "We delete a cell by selecting it and then choosing ",
  StyleBox["Clear", "MenuItem"],
  " from the Edit menu. Furthermore, cells can be merged by selecting two or \
more adjacent cells, pulling down the Cell menu, and choosing ",
  StyleBox["Merge Cells", "MenuItem"],
  ". A cell can be divided into two cells by placing the text insertion point \
at the place the cell should be divided, and choosing ",
  StyleBox["Divide Cell", "MenuItem"],
  " from the Cell menu."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Word Processing", "Subsection"],

Cell[TextData[
"Most of the front end\[CloseCurlyQuote]s word-processing menu commands \
(fonts, sizes, faces, text and background colors, text alignment, and so \
forth) are under the Format menu. We change the format of the contents of a \
cell by selecting some text to be changed, then making the modifications with \
the commands under the Format menu. To change the format of all the contents \
of a cell (or several cells), we select the cell bracket(s) and make the \
modifications using the same commands."], "Text"],

Cell[TextData[{
  "The commands ",
  StyleBox["Show Ruler", "MenuItem"],
  " and ",
  StyleBox["Show Toolbar", "MenuItem"],
  " are also under the Format menu, making it easier to change a notebook\
\[CloseCurlyQuote]s margins, text alignment, and cell styles."
}], "Text"],

Cell[TextData[{
  "We can change the style of every cell of a certain type in a notebook by \
editing the notebook\[CloseCurlyQuote]s ",
  StyleBox["style sheet",
    FontSlant->"Italic"],
  ", which is a document that contains cells with styles representative of \
the ones that will be used when a new cell of each type is created."
}], "Text"],

Cell[TextData[{
  "To edit the style sheet, pull down the Format menu and choose ",
  StyleBox["Edit Style Sheet", "MenuItem"],
  ". To apply changes only to the current notebook, click the",
  StyleBox[" Import Private Copy", "MenuItem"],
  " button. (To edit a style sheet that defines styles for future new \
notebooks, click the ",
  StyleBox["Edit Shared Style Sheet", "MenuItem"],
  " button.)"
}], "Text"],

Cell["The following figure shows a typical style sheet.", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006?000100P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000003o`0000T02Ol600;o1P02o`800_l400;o
00<0ool00`02o`800_l<00Co1P02o`800_l500;o0P02o`P00_l600;o0P02o`D00_l200;o1002o`<0
0_l00`3oo`0900;o1002o`X00ol400;o]P000d`000040003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o00002@09o`d00ol200;o1002o`030?oo00<00_l200So0`06o`L00_l200;o
1@02o`800_l800;o1P02o`800_l500;o0P02o`@00_l300;o00<0ool02@02o`@02?l400?o1002okH0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000T0
2Ol800Oo0`02o`@00_l00`3oo`0300;o0P02o`@00_l200Co2P02o`800_l500;o0P02o`P02Ol300;o
1@02o`800_l400;o0`02o`030?oo00T00_l400;o1002o`@00ol400;o]P000d`000040003C00000@0
00=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002@09o`L01ol400;o0`02o`<00_l200;o
0P03o`800ol200;o1002o`H00_l200?o0`03o`800ol700Wo0`03o`<00ol200?o0P03o`800_l300;o
2002o`@00ol200?o0`02o`030?oo00<00_nf0003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo1P03o`P01?l200;o0`02o`800_l300Ko0`08o`D0
1?l200Oo0`05o`D00_l600;o0`07o`@01ol200;o0`02o`P00_l500Ko0`03o`050?ooo`001?ne0003
C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo1P02o`H0
0_l00`3oo`02o`800_l300;o0P02o`@01?l600Co1`04o`<01Ol400;o00<0ool01@02o`H00_l400Go
1P03o`030?oo00800_l300;o2002o`H01?l400;o0`02o`030?oo00;o]@000d`000040003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00006003o`@00ol200;o3002oaX0
0_lG00;o1P02oa<00_lA00;o5`02okH000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`0001T02?l300;o3002oaX00olF00Wo5002o`h02?lD00;o]P000d`000040003
C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00006P06oa800_lK00;o
5P08oaD00_l>00Sob@04C0H000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o06T000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0I@05C0801D`60003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`0
00020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<00000P000ooi
d`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L0
00=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0I@05C0H000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o06T000=<00000`02C0H000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000:@03og@01?o40003C00000800d`60003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`0002T01?ma00Oo``0014`00004C0H000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000;002og000_l400;o`P000d`00005C0H000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o00002@09o`P01_l400?o1003o`@00_l400Co1@06o`L00_l400Go
1002o`P00_l500;o1004o`D01?l00`3oo`0400?o00<0ool00P02o`800_l400;o1003o`030?oo00<0
1_ni0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo
1`08o`<00ol400?o1002o`<01_l300So1P02o`<01ol300;o2002o`D00_l300Ko0`08o`<01ol200;o
0P02o`@00_l300Oo0P08okP000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`0000T02Ol600?o1003o`800_l400;o00<0ool00`02o`800ol300;o0P02o`@0
0_l600;o0P03o`<00ol200;o2002o`D00_l200?o0`02o`800_l300?o0P03o`800ol200;o0P02o`@0
0_l200?o0P03o`800_l400;o^0000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o00002@09o`H00_l600;o0P02o`@00_l00`3oo`0300;o0P02o``01?l600;o0P02o`D0
0_l200;o2002o`D00_l200;o2002o`@00_l200;o1002o`800_l200;o1002o`800_l400;o1P04okP0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000T0
2Ol=00?o0P02o`@00_l00`3oo`0300;o0P08o`<01_l700;o0P02o`D00_l200;o2002o`D00_l200So
0`04o`030?oo00800_l400;o0P02o`800_l400;o0P02o`@00_l300Ko^@000d`000040003C00000@0
00=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002@09o`P01ol300;o1002o`030?oo00<0
0_l200;o1002o`801?l:00;o0P02o`D00_l200;o2009o`800_l400;o1`03o`800_l400;o0P02o`80
0_l400;o0P02o`@00_l200Co_0000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o00002@09o`L01ol400;o0`02o`<00_l200;o0P03o`800ol200;o1002o`H0
0_l200?o0`03o`800ol700Wo0P03o`800ol200;o1002o`800ol200?o0P02o`800ol300;o0P03o`80
0ol200;o1002okP000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0000T02Ol600?o2004o`800_l300;o0P02o`<01_l300So1@04o`801ol300Go1@02o`D00_l300Ko
0`08o`<01ol200;o0P08o`<01ol200So^0000d`000040003C00000@000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o00002@09o`H00_l600;o00<0ool00_l200;o0`02o`800_l400Co
1P04o`L01?l300Go1002o`030?oo00D00_l500;o1004o`H01?l600?o00<0ool00P02o`800_l00`3o
o`02o`D00ol00`3oo`0400Co^P000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o00006003o`@00ol200;o3002oaX00_lG00;o1@02oa`00_oJ0003C00000@000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000I00So0`02o``00_lJ00?o
5P02o`D00_lL00;o0P02omH000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`0001X01_lB00;o6`02oaH00_l500;o7002o`800_oC00A<1P000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0J@000d`000040003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1U00E<0P05C0H000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1U00E<1P000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0J@000d`0
0003009<1P000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0001g00;ok`000d`0
000200=<1P000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0001g00;ok`0014`00004C0H0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000M`02onl000=<00001D`60003
C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol600;o1@02o`@01Ol400?o1004o`@0
0_l0103oool600Go1P05o`@00_l200?o2@05o`D00_l0103oool400?o0P02o`@01Ol400;o1002o`<0
1_o20003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
000900Wo1P02o`@00ol300Oo0`03o`<01_l300Oo1007o`@01ol300;o0P02o`T01ol400Oo0`03o`80
0_l300Oo0`02o`@00_l200So`@000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o00002@09o`H00_l300Co0P03o`<00ol200;o0`03o`<00_l200?o0P03o`800ol300?o
0P03o`<00ol200;o00@0oooo2003o`<00ol300?o0P03o`800_l300;o0P03o`<00ol200;o1002o`80
0_l400;o`@000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`00
00?o00002@09o`H00_l300Co0P02o`D00_l200;o0`02o`P00_l400;o0P02o`D00_l200;o1@02o`80
1Ol800?o1@03o`800_l400;o0P02o`<00_l200;o1@02o`800_l400;o1P04ol4000=<000010000d`0
00040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol600;o0P02o`030?oo0080
0_l500;o0P02o`<02?l200;o1002o`800_l500;o0P02o`D00_l200Go2002o`L00_l200;o1002o`80
0_l300;o0P02o`D00_l200;o1002o`<01_o20003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo1P02o`800_l00`3oo`0200;o1@02o`800_l300;o
1002o`800_l400;o0P02o`D00_l200;o1@02o`801?l900;o1`02o`800_l400;o0P02o`<00_l200;o
1@02o`800_l400;o0P04olD000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`0000T02Ol600;o00<0ool00P02o`800ol300?o0P02o`<00ol200?o0P03o`800ol200?o
0`03o`800ol300?o0P02o`030?oo00P00_l700;o0P03o`800ol200;o0`02o`800ol300?o0P03o`<0
0_l200;o1002ol4000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0000T02Ol600;o00<0ool00P02o`<01ol200Co0`06o`<01ol400Oo1007o`<00_l0103o
ool700;o1`02o`801ol200Co0P02o`<01ol300So0P08ol4000=<000010000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol600Co0`02o`@01Ol300Co1004o`@00_l0103o
ool600Go1P05o`@00_l200?o1P03o`D00ol200;o00@0oooo0`04o`800_l400Go1002o`030?oo00;o
1@04ol<000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`0001P01?l300;o3@02o`d00_lN00;o3003o`<00ol=00;oi@000d`000040003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00006003o`@00_l=00;o3@02oah00_l=00Oo3P02o`<0
0_oP0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
000H00?o1002oa`00_lN00;o3P05oa@00_oM00A<1P000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`000?l0J@000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1U00E<0P05C0H000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0
M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1U00E<1P000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0J@000d`00003009<1P000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000Y00?oo`0m0003C00000800d`60003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002T01?oo03`000A<000014`60003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0002`00_oo03/000=<00001D`60003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`0000T02Ol800Ko1003o`@00ol400;o1004o`P02Ol200;o
1002o`@00ol400;o0P02o`H01Ol400;o1002o`800_l300;o0`02o`@01?l400;o1002o`800ol600;o
1@02o`<01?l00`3oo`0200;o0`02o`<00_l400Co1@06ohP000=<000010000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol700So0`03o`@00ol400;o0`06o`L02Ol200;o
1002o`@00ol400;o0P02o`D01ol300;o1002o`800_l300;o0`02o`<01_l300;o1002o`800ol600;o
1003o`802?l200;o0`02o`<00_l300Ko0`08ohL000=<000010000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`0000T02Ol600?o1003o`800_l400;o00<0ool00`02o`80
0ol300;o1P02o`T00_l400;o0`02o`030?oo00<00_l200;o1003o`<00ol200;o1002o`800_l300;o
0`02o`800ol300;o0P02o`@00_l200;o1`02o`<01?l200;o0`03o`800_l300;o0`02o`800ol300;o
0P02o`@00_n70003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
000900Wo1P02o`H00_l200;o1002o`030?oo00<00_l200;o3002o`T00_l400;o0`02o`030?oo00<0
0_l200;o1002o`D00_l200;o1002o`800_l300;o0`02o`800_l800;o1002o`800_l700;o0`04o`80
0_l400;o0P02o`<00_l300;o0P02o``01?n70003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo3@03o`800_l400;o00<0ool00`02o`802?l600;o
2@02o`@00_l300;o00<0ool00`02o`800_l400;o1@02o`800_l400;o0P02o`<00_l300;o0P08o`80
0_l400;o0P02o`L00_l200;o00<0ool00`04o`030?oo00800_l300;o0`02o`802?l300KoR0000d`0
00040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002@09o`P01ol300;o
1002o`030?oo00<00_l200;o1002o`H02?l300;o1002o`<00_l00`3oo`0300;o0P02o`@00_l500;o
0P02o`@00_l200;o0`02o`<00_l200;o1002o`800_l400;o0P02o`L00_l200;o00<0ool01`03o`80
0_l300;o0`02o`800_l400;o0P04oh/000=<000010000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`0000T02Ol700Oo1002o`<00_l300;o0P02o`800ol200?o1P08o`<0
0ol300;o0P02o`<00_l200;o0P03o`<00ol300?o0P03o`<00_l200?o0P03o`800_l200?o0P03o`80
0ol300;o0P02o`L00_l00`3oo`0200;o0P02o`@00_l200?o0P03o`800_l200?o0P03o`800_l400;o
Q`000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002@09o`H0
0ol800Co0P02o`<00_l200;o0`06o`L00_l900So0P02o`<00_l200;o0P05o`801ol300So0P0<o`<0
1_l300So00<0ool00_l600;o00<0ool00P02o`802?l200co0`06o`<02?n70003C00000@000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo1P02o`H00_l00`3o
o`02o`800_l300;o0P02o`@01?l800;o2@02o`030?oo00;o0`02o`<00_l200;o0P02o`030?oo00<0
1Ol400;o00<0ool00_l300;o00@0oooo0P03o`D01?l400;o00<0ool00_l200Co1P04o`<00_l400Co
1002o`040?ooo`800ol500Co1P04ohT000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`0001P00ol400?o0P02o``00_l@00;oG@02o`L01?l300;o/`000d`000040003
C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00006@08o`<00_l<00;o
4009oaD00_lo00;o1`03o`@00_nc0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000J00Ko4P02oa002OlE00;oB003o`@00_n`00A<1P000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0J@000d`000040003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1U00E<0P05C0H000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0
M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o003oog[o00<]ool00ol01OWC
dm?i00?C00Kidm?CnM<2o`0000?o0000o`1/00E<1P000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000;00;o0`03o`800ol0103oo`02o`050?ooo`00
0_l00`3oo`0200;o00<0ool00_l0103oo`02o`030?oo00?o1@06o`030?oo00@000?o0?l00_l0103o
o`02o`D01?l400?o0P03o`050?ooo`000_l00`3oo`0200;o00@0o`3o1003o`040?oo00;o0P02o`80
0ol00`3oo`0200;o00@0o`3oc@000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0000X000Ko003o0?l30004o`00o`8000Co003o0`001?l00?l20004o`00o`8000Co003o
0P000ol0o`0200;o00D0o`00o`050004o`00o`8000?o00000P001Ol0003o008000?o0?l00P000ol0
00030003o`0000<000Go0000o`020005o`000?l00P001?l00?l20006o`00o`3o1P001?l00?l20004
o`00o`8000Co003o0P001?l00?l20003o`000<h000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000:0003o`00008000Go0000o`020004o`00o`8000Go0000o`020004o`00o`80
00Co003o0P001_l00?l0o`<000Co00000_l50004o`00o`8000?o00000P001Ol0003o008000?o0?l0
20000ol000030005o`000?l00P001Ol0003o008000Co003o0P001_l00?l0o`H000Co003o0P001?l0
0?l50004o`00o`8000Co003od0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0000X000?o00000P001Ol0003o008000Co003o0P001Ol0003o008000Co003o0`03o`80
00Ko003o0?l30004o`3oo`L000Co003o0P000ol000020005o`000?l00P000ol0o`03o`D000Oo0000
o`3o00<000Co003o0`001?l00?l20004o`0000?o00<0o`001@001?l00?l20003o`0000Co0P001?l0
0?l20004o`00om0000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000:0006
o`00o`3o0`001?l00?l20004o`00o`<000Co003o0P001?l00?l20004o`00o`8000?o0?l00P02o`05
0?l00?l01@001?l00?l20003o`00008000Go0000o`020003o`3o008000?o00000`05o`030?l00080
00?o00000_l20004o`00o`8000Co003o0P000ol0o`060004o`00o`8000Co003o0P001?l00?l20004
o`00o`8000?o0000cP000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`0000/00_l300?o0P001Ol0ool000;o0`001Ol0ool000;o1002o`8000Co0?oo0`02o`040?l000?o
1002o`030?l000;o1003o`800ol300;o1P001Ol0003o00800ol20003o`3o00;o00@0ool00_l400;o
00@0oooo10001Ol0ool000;o1002o`8000Co0?oo0P02o`030?oo0=0000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0000h0003o`0001<000Go0000o`0=0003o`0001`000?o0000
k@000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0003P000?o0000
5`000ol0000;0003o`00008000?o0000o`080003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o0000=`02o`X000?o00002`02o``01ooo00X000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o0700
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000g00?o8002ohh00_m=00?o<`000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0003H000Go0000o`0O0003
o`3o08d000?o0?l0B`001Ol0003o038000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0000f0005o`000?l08@000ol0002=0003o`0004T000Go0000o`0b0003C00000@000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00002`02o`<00_l200Wo1@06o`030?oo00@0
0_l00`3o000300?o0P03o`8000?o00000P02o`800ol00`3oo`0300?o0`001Ol0003o00<00ol00`3o
o`030003o`0000D00ol20003o`0000?o00@0ool01?l0103oo`02o`D00ol0103oo`02o`800ol300;o
00<0ool01_l01@3oool000;o0`02o`050?l0o`000ol0103oool200?o00<0ool00ol60003o`0000?o
1P02o`030?oo00;o00<0ool00P000ol0000500;o00@0ool00_l200?o00<0ool01?l00`3oo`03o`03
0?l000?o00@0oooo0P03o`030?oo00D00_l00`3oo`02o`801_l0103oo`03oc<000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000:0006o`00o`3o0P001?l00?l20003o`3o0080
00?o00000`001?l00?l20003o`00008000Co003o10000ol000040005o`000?l00`001?l00?l20004
o`00o`@000Ko003o0?l40003o`00008000?o0?l00P000ol000090005o`000?l00`000ol0o`020004
o`00o`8000?o0?l00P000ol000030004o`00o`8000Co003o0`000ol0o`0200;o0P001?l00?l30003
o`3o008000?o0?l00P000ol0o`030003o`3o00<000Co003o0P000ol0o`020003o`00008000Co003o
0`000ol000020004o`00o`8000Co003o0`000ol000040003o`0000;o00D0o`00o`020005o`000?l0
0P001?l00?l20003o`3o00<000?o0?l00`001?l00?l20003o`0000<000Ko003o0?l20004o`00o`80
00Ko003o0?lf0003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
2P000ol000020003o`0000<000Co003o0`02o`D000Co003o0P000ol000020004o`00o`D00_l40006
o`00o`3o0P000ol000030004o`00o`H00_l00`3o00020003o`3o00<000?o0?l03P001_l00?l0o`80
00?o0?l00P001_l00?l0o`8000?o00001P001?l00?l20004o`00o`<000?o0?l00`001?l00?l20007
o`000?l0o`040006o`00o`3o0`000ol0o`030004o`00o`8000Co00000_l40004o`00o`<000?o0000
0P001?l00?l20004o`00o`8000?o0?l01@001ol0003o0?l01@001Ol0003o008000Co003o0P000ol0
o`030003o`3o00<000Co003o0P000ol000030004o`00o`<00_l20004o`00o`8000?o00000_ld0003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002P000ol0000200Co0P001Ol0
0?l000;o1`001?l00?l20003o`0000<00ol40004o`00o`<000Ko003o0?l200Co0P001?l00?l400;o
0`001ol0003o0?l00`000ol0o`03o`/000Ko003o0?l20003o`0000?o0P02o`<01?l50004o`00o`80
00Co003o0`000ol0o`030004o`00o`8000Oo0000o`3o00D00ol00`3o00020003o`3o00<000Co003o
0P001?l0ool60004o`00o`<000?o00000`03o`8000Co003o0P000ol0o`050006o`000?l01?l20005
o`000?l00P001?l00?l20003o`3o00<000?o0?l00`001?l00?l20003o`0000<000Go003o0002o`@0
00Co003o0P000ol0o`020003o`00034000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0000:0006o`00o`3o0P001?l00?l20003o`3o008000?o00000`001?l00?l20003
o`00008000Co003o10001?l00?l30003o`3o00<000?o0?l00P001?l00?l20003o`00008000Ko003o
0?l20005o`000?l00P000ol0o`020003o`0000T000?o0?l00`001Ol0o`3o008000Ko003o0?l20004
o`00o`D000Co003o0P001?l00?l30003o`3o00800_l20004o`00o`<000?o0?l00P000ol0o`020003
o`3o00<000?o0?l00`001?l00?l20003o`3o008000?o00000P001?l00?l30003o`00008000Co003o
0P001_l00?l0o`<000?o00000P000ol00002o`050?l00?l00P001Ol0003o008000Co003o0P000ol0
o`030003o`3o00<000Co003o0P000ol000030006o`00o`3o0P001?l00?l20006o`00o`3o0P000ol0
000a0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002`02o`<00_l30004
o`00o`800ol400;o00<0o`000_l600;o1P04o`030?oo00?o00D0oooo0002o`8000Co0?oo1P09o`06
0?ooo`3o0P02o``000?o0?l00`000ol0o`0200;o0`001?l0ool200;o1@001Ol0ool000;o1003o`<0
0_l00`3o0002o`050?ooo`000_l200;o0`02o`050?ooo`000_l200?o0P001?l0ool300?o0`03o`80
0ol600;o0P001Ol0ool000?o00@0oooo1002o`040?l000;o0P03o`060?oo0?l00_l200Go00<0ool0
0P03o`8000Co0?oo1@02o`030?oo00800ol01P3oo`3o00;o0`04oc8000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000E0004o`00ocl000?o00001`000ol0000>00;o
1@02o`L000?o00007P000ol000030003o`0000d000?o00005`000ol0000Q0003o`0000D000?o0000
30000ol0001M0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00005@001?l0
0?m90003o`0000h00_l500;o1`000ol0000N0003o`0000<000?o0000B`000ol000050003o`0006`0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000D00;o00<0ool0
2P000ol0000G0003o`0002400_l?00;o1`02o`D00_lO00;o0P001?l00002o`030?l000h000?o0000
=P02o`P00_l00`3o00070003o`0000<000?o00006P000ol0000l0003C00000@000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1`0003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00009`02oi400om200?o0`03ofL0
00=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000W0003o`3o08l000Go0000
o`120003o`0000<000?o0000IP000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0002T000?o0000S@001Ol0003o048000?o00000`000ol0001V0003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002P03o`8000?o00000ol0103oool300;o00<0ool0
1_l30003o`0000D000?o0?l00_l0103oo`02o`H00_l0103oo`02o`800ol00`3oo`04o`030?oo00?o
00<0o`000ol0103oool200?o00<0ool00ol600?o0`02o`800ol0103oool50003o`3o00L000?o0000
0ol600;o0P03o`040?oo00;o00<0ool00_l0103oo`03o`<00_l60003o`3o00;o00@0ool00_l600;o
00@0ool00_l200?o0P02o`040?l000;o00<0ool00_l00`3o000400;o00@0ool00_l20004o`3oo`<0
0_l300;o00<0ool00_l200;o00<0ool00_l0103oo`02o`<00_l600?o0P03o`D00_l00`3oo`05obD0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000;0005o`000?l0
0`000ol0o`030003o`3o00800_l20004o`00o`@000?o000010001Ol0003o008000?o0?l00P000ol0
00020003o`0000;o00D0o`00o`020005o`000?l00P001?l00?l20003o`3o00<000?o0?l00`001?l0
0?l20003o`3o008000?o00000P001ol0003o0?l00P001_l00?l0o`<000?o00000P000ol0o`060004
o`00o`<000?o00000P001?l00?l20006o`00o`3o0P001?l00?l20003o`3o00D000Co003o10001Ol0
003o008000?o0?l00P000ol000020003o`0000;o00D0o`00o`020004o`00o`8000Co003o0P001_l0
0?l0o`D000Go003o0002o`8000Co0?oo0P000ol0o`020003o`3o008000Co003o0P001?l00?l20006
o`00o`3o0P000ol0o`020003o`00008000Go0000o`020003o`0000<000Co003o0P001?l00?lV0003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002`001_l00?l0o`8000?o0?l0
0`000ol0o`030004o`00o`8000Oo0000o`3o00D000Go0000o`020003o`3o00L000Oo0000o`3o00D0
00Go0000o`020004o`00o`8000?o0?l00`000ol0o`030004o`00o`8000Co00000_l40007o`000?l0
o`050003o`3o00<000Wo0000o`3o0?l01@001?l00?l30003o`00008000?o00000`001_l00?l0o`80
00Co003o0P000ol00002o`<000?o00001@001Ol0003o008000?o0?l01`001ol0003o0?l01@001?l0
0?l20004o`00o`8000Ko003o0?l50006o`00o`3o0`000ol0o`030003o`3o00@000Co003o0P001?l0
0?l20004o`00o`8000?o0?l010000ol000050005o`000?l00P000ol000030004o`00o`8000Co003o
9P000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000/000Ko003o
0?l20003o`3o00<000?o0?l00`001?l00?l20007o`000?l0o`050005o`000?l00P000ol0o`03o`@0
00Ko0000o`04o`8000Go0000o`020004o`00o`8000?o0?l00`000ol0o`030004o`00o`8000Co0?oo
1P001_l0003o00Co0P000ol0o`030009o`000?l0o`3o00D000Co003o0`000ol000020003o`0000<0
00Co003o0P03o`8000Ko003o0?l20003o`0000Co10001Ol0003o008000?o0?l00ol40006o`000?l0
1?l20004o`0000?o0P001?l00?l20003o`3o00H00ol00`3o00020003o`3o00<000?o0?l00ol200?o
0P001?l00003o`8000Ko003o0?l400Co10001Ol0003o008000?o00001003o`8000Co003o9P000d`0
00040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000/000?o0?l00`001Ol0o`3o00<0
00?o0?l00P02o`8000Co003o0P001Ol0003o00@000Go0000o`020003o`3o008000?o00000P000ol0
0002o`050?l00?l00P001Ol0003o008000Co003o0P000ol0o`030003o`3o00<000Co003o0P000ol0
o`020003o`0000800_l20003o`3o008000Ko003o0?l30006o`00o`3o0`000ol000020004o`00o`<0
00?o00000P001?l00?l20006o`00o`3o0P001?l00?l20003o`3o008000Co003o0P000ol000020005
o`000?l00P000ol0o`020003o`00008000?o00000_l01@3o003o008000Co003o0P001?l00?l20006
o`00o`3o1@001Ol00?l000;o0P001?l0ool20003o`3o008000?o0?l00P000ol00002o`050?l00?l0
0P001_l00?l0o`8000?o0?l00P000ol000020005o`000?l00P000ol000030004o`00o`8000Co003o
9P000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000/000?o0?l0
0`000ol0o`0200?o0`02o`030?l000;o00<0ool01?l0103oool200?o0P03o`<00_l600;o00@0o`00
0_l200?o00H0ool0o`02o`801Ol00`3oo`0200?o0P001?l0ool300?o10001?l0ool300;o0`000ol0
0003o`800_l0103oo`03o`800ol200?o1P02o`<00ol300;o0P001?l0ool300Co0P02o`@00ol200?o
0`02o`H00_l0103o0002o`800ol200;o0P02o`030?oo00801?l500;o00@0ool00_l0103oo`02o`<0
0_l300;o0P001Ol0ool000;o0P001?l0ool300;o0`02o`H00ol200?o1@02o`<000Co003o9P000d`0
00040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000/00_l500;o2`000ol000030003
o`0000T000Go0000o`0@0003o`0000D000?o000030000ol0000G0003o`0000T000?o00004@000ol0
000?0003o`0001/000Go0000o`0@0003o`0000D000?o000030000ol0o`130003o`0000T000Co003o
9P000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000/00_l500;o
2`000ol000030003o`0000d000?o00003P000ol000050003o`0002H000?o00002@000ol0000S0003
o`0001l000?o00003P000ol000050003o`0000`000?o0000@`000ol000090004o`00obH000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000:00;o1`02o`T00_l20004o`0000;o
3002o`l00_l800;o00<0o`001`000ol000030003o`0001800_l:00;o9002ob000_l?00;o2002o`/0
0_m600;o2002o`030?oo02H000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o06d014`60003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0K005C0H000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0
M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o06`01D`60003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0002@00ooo04T000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0000T00Coo`180003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o00009P02ool0B0000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`0002L00_oo04L000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0000W00;oo`170003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`00
00?o00003`06o`T00ol700;o1`02o`L01?l=00[o2`04o`L00_l500;o1002o`H00_l400;o1P03o`<0
0_l600Go1P02o`H00_l500Ko/`000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0000d02_l600Co1`02o`L00_l500So2`0<o`L02?l500;o1@02o`@00_l600;o1002o`D01?l300;o
1@07o`D00_l600;o1008ok8000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0000<00Co1@03o`D00_l800?o1`02o`@00ol400?o2P02o`L01?l500?o1003o`@00_l500;o
1002o`H00_l400;o1@02o`D00_l400?o0`03o`@00_l600;o0`03o`@00ona0003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002`03o`P00ol400;o2004o`H00_l400;o1P02o`X0
0_l900?o1002o`H00_l400;o1@02o`@00_l600;o1002o`D00_l500;o1002o`D00_l400;o1P02o`<0
0_l600;o/@000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000/0
0_l:00;o1002o`L00_l00`3oo`0600;o0`02oa<00_l:00;o0`02o`d00_l500;o1002o`H00_l400;o
1@02o`D00_l300;o1`02o`<00_l600;o0`02o`H00_na0003C00000@000=<00000P000ooXj00<j0;o
00000ol0000;00;o2P02o`@00_l700;o00<0ool01P02o`<00_lC00;o2P03o`800_l=00;o1@02o`@0
0_l600;o1002o`D00_l500;o0`02o`L00_l300;o1P02o`X00ona0003C00000@000=<00000P000olH
_P0;_P7X0Ol1o`0000?o00005`02o`@00_l600;o0`02o`D00_l300_o2P02o`/00_l200_o1002o`D0
0_l400;o1P02o`@00_l500;o1@02o`<00_l700;o0`02o`H00_l700Go/P000d`000040003C0000080
00?o6;h02kh1j07o0Ol00003o`0001H00ol400;o1P02o`<00_l500;o0`0;o`X00_l;00;o0P0;o`@0
0_l500;o1002o`H00_l400;o1@02o`D00_l300;o1`02o`<00_l600;o1007ok<000=<000010000d`0
00020003oaRn00:n1QP3_P7X0Ol1o`0000?o00005004o`D00_l500?o0`03o`@00_l300;o1`02o`X0
0_l;00;o0P02o`L00_l400;o1@02o`@00_l600;o1002o`D00_l500;o0`02o`L00_l300;o1P02o`<0
1Onf0003C00000@000=<00000P000olH_P02_PKQ0kh1j07o0Ol00003o`0001801Ol600;o1@02o`D0
0_l400;o0`02o`L00_l:00;o2`02o`800_l700;o1002o`D00_l400;o1P02o`@00_l500;o1@02o`<0
0_l700;o0`02o`H00_l300;o^@000d`000040003C000008000?o6;h00[h660>n0NP1o`7o00000ol0
000?00Ko2002o`@00ol500;o1002o`@00_l500;o2`02o`/00_l300;o1@02o`D00_l500;o1003o`D0
0_l400;o1@02o`D00_l400;o1@02o`@00ol500;o0`02o`D00_nb0003C00000@000=<00000P000olH
_P02_PKQ0kh1j07o0Ol00003o`0000d01Ol;00;o1002o`L00_l300;o1003o`<00ol;00;o2`02o`<0
0ol300?o1@02o`D00_l400Co0`02o`D00_l500;o1@02o`@00ol300?o1004o`<00_l400?o0`03ok80
00=<000010000d`000020003oaRn00:n1QP3_P7X0Ol1o`0000?o00003003o``01_l00`3oo`0800;o
0`02o`D01ol<00;o2`02o`@01ol400Ko0`02o`@00_l00`3oo`04o`D00_l300Ko0`02o`D01ol500;o
00<0ool01?l500Oo/`000d`000040003C000008000?o6;h00[h6h@>n0NP1o`7o00000ol0000<00;o
3@06o`030?oo00P00_l300;o1`03o`h00_l:00?o1P03o`H01_l300;o1002o`800ol700;o0`06o`<0
0_l600Go1P02o`800ol800Go]0000d`000040003C000008000?o6;h00[h660>n0NP1o`7o00000ol0
000<00;o2002o`D00_lB00;o6002o`X00_lB00;o8002on0000=<000010000d`000020003oaRn00:n
1^43_P7X0Ol1o`0000?o00003003o`L00_l500;o4P02oaP00_l900?o4P02ob000_oP0003C00000@0
00=<00000P000olH_P02_PHH0kh1j07o0Ol00003o`0000d00ol500?o1@02oa800_lH00;o1`04oa<0
0_l500;o4P02o`D00_l500;of@000d`000040003C000008000?o6;h00[h65`>n0NP1o`7o00000ol0
000>00Wo1P02oa800_lH00co5004o`<00_lB00;o1@02o`D00_oF00A<1P000d`000020003oaRn00^n
0NP1o`7o00000ol0000@00Go7002oaP02_lG00?o0`02oa800_l<00;of@000d`000040003C0000080
00?o61P02aP1j07o0Ol00003o`000?l0K005C0801D`40003okFe00be0_l00003o`000?l0O00Ao`00
00?o0000o`1l0003ooWi00ci0_l00003o`000?l0O0000ol0d`0;d`7i0Ol1o`0000?o0000o`1l0003
o`3C00;C1NP4d`7i0Ol1o`0000?o0000o`1l0003o`3C00;C00GX5aLGj004d`7i0Ol1o`0000?o0000
o`1l0003o`3C00;C00GX5aLGj004d`7i0Ol1o`0000?o0000o`1l0003o`3C00;C00GX5aLGj004d`7i
0Ol1o`0000?o0000o`1l0003o`3X00?X0aL4j003doWo007o00000ol0003o07`000Co0=?X1aL01>SC
doT2o`0000?o0000o`1l0005o`3CdnP01AL01NSCdm?i00;o00000ol0003o07`000?o0=<00]<01NPG
5aOX00CC0OT1o`7o00000ol0003o07`000?o0=<00m<00nPGj005d`7i0Ol1o`0000?o0000o`1l0003
o`3C00CC00?Xdm<01=<1n@7o0Ol00003o`000?l0O0000ol0d`0;d`7i0Ol1o`0000?o0000o`1l0003
o`0000/00OT1o`7o003ooi3o00000olG5`3o5h/G0_l00003oaSK06gK1?oofaWK0AL1o`7o00000olH
f`1/f`04om_Kf`;oom/Hf`4G0Ol1o`0000?o6?T01OT00m_X60096003foWi04Ci6=/2okgKAoT00m_X
60096003foWi00Ci0AL1o`7o00000olHf`06f`03j1SX00OX00<Hfm/0CM/3o`GK0_l3f`Go0]/2o`?K
1?l7f`Go1=/4o`CK0_l3f`;o0]/2o`;K0_l2f`;o1=/2o`;K0_l3f`Co0m/2o`;K0_l3f`?o2=/2o`CK
1?l3f`;o2M/4o`?K0_l2f`;o1=/2o`;K0_l4f`;o0]/2o`?K1?l4f`Go2m/2oe7K00?X6>P01nP00aSK
f`05f`4G0Ol1o`0000?o6?T01OT00m_X6007_P03j1SK04Ki1m/00ooKf`02o`?K0_l3f`;o0]/2o`;K
0_l2f`;o0m/00ooKf`04f`;o0]/2o`;K0_l3f`04om_Kf`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o
0]/2o`;K0_l2f`;o0]/2o`;K00?ofm/00_l7f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K
0_l3f`;o0m/2o`?K0_l2f`;o0m/00ooKf`02o`;K0_l;f`;o2M]7n@03fnPH00Nn00?X6=/01_T15`7o
0Ol00003oaSK00KK00?X6;h01[h00nPHf`1@f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l:f`;o0]/2o`;K
0_l7f`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`CK0ol7f`;o0m/2o`;K
0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`;o1]/2o`;K0_l;f`;oDM/00nPH
_P06_P03j1SK00KK0AL1o`7o00000olHn@05n@03fnPH00Nn00?X6=/0A_T9f`?o0m/2o`?K0_l2f`;o
0]/2o`;K1_l6f`;o0]/2o`;K1_l3f`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o
0]/2o`?K0ol8f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`Ko
0]/2o`;K0_l;f`;o2M]7n@03fnPH00GX0[h00nPHf`06n@4G0Ol1o`0000?o6=/01]/00nPH_P06_P03
j1SK04kK0ol4f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l6f`;o0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l2f`?o2M/2o`?K0_l2f`;o0]/2o`SK0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`;K1Ol4f`;oDM/00nPH_P03_P05
j;jnj1P01m/15`7o0Ol00003oaSi00Gi00?Kj1P01kh00nPHf`16n@OK0ol5f`;o0m/2o`;K0_l2f`;o
0]/2o`;K0_l6f`;o0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o
0]/2o`;K0_l2f`;o0]/00ooKf`05f`;o0m/2o`;K0_l2f`?o1m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o
0m/2o`?K0_l2f`;o0]/2o`;K0_l2f`;o2m/2o`WKAoT00m_X6004_P06j;jnj1SK1_T15`7o0Ol00003
oaSK00KK00?X6;h01[h00nPHf`1=f`;o1M/4o`;K0_l2f`;o0]/2o`?K1?l7f`;o0]/2o`?K1?l3f`Co
0]/2o`;K1Ol3f`;o0]/4o`;K0_l3f`Co0m/5o`CK0ol7f`Co0m/4o`?K0_l00m_oo`05f`;o0]/2o`;K
1Ol3f`Co0]/2o`;K1?l2f`;o0m/4o`CK1Ol;f`;oDM/00nPH_P03_P05j;jnj1P01m/15`7o0Ol00003
oaSi00Gi00?Kj1P01kh00nPHf`16n@OK0_l2f`04om_Kf`;o2m/2o`kK0_l2f`;o2m/2oaCK0_lSf`;o
5M/2o`;K0_l;f`;o2=/2o`?K0_l>f`;o2]/3o`WKAoT00m_X6004_P06j;jnj1SK1_T15`7o0Ol00003
oaSK00KK00?X61P021Q?f`?o1=/2o`_K0_l>f`Go3M/3o`03fooo00[K0_l3f`;o0m/2oaoK0olCf`;o
0]/2o`_K0_l3f`;o0m/2o`?K0_l>f`;o2m/2oe7K00?X61P021P7f`4G0Ol1o`0000?o6?T01OT00m_X
j009j003foWi04Ciem]7n@03fnSX00WX00?KnOT01?T15`7o0Ol00003oaSK0?oKR]/15`7o0Ol00003
oaSK0?oKR]/15`7o0Ol00003oaPH0?lHRQP15`7o0Ol00?ooSol10000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  ImageSize->{399, 256},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
To change the style of all cells of a certain type, we open the \
appropriate cell group and select the desired prototype cell. In the \
following figure, the prototype input cell is selected.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006?0000_PP10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000003o`0003401?oo02d000=<000010000d`0
00040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1R0003C00000@0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0004h0
0_l30003o`0002L00_lW0003o`000;P000=<000010000d`000040003C00000@000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000D0001?l00?l[0003o`0002@000?o0000^0000d`000040003
C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000^0003
o`0000@000?o00000`02o`@000?o00000_l40004o`0000?o0P03o`<00_l60004o`0000;o0`000ol0
000600;o10001?l00003o`8000Co00000_l30003o`0000P00ol400?o0`000ol00003o`@00ol30003
o`0000D000?o0000X`000d`000040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000^0003o`0000@000?o00000P001?l00?l20004o`00o`8000Co003o0`001?l0
0?l20006o`00o`3o0P000ol000030004o`00o`8000Co003o1`001?l00?l20005o`000?l00P001?l0
0?l20004o`00o``000Go0000o`020004o`00o`8000Go0000o`020004o`00o`8000Co003o[P000d`0
00040003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
000^0003o`0000@000?o00000P001?l00?l20004o`00o`8000Co003o0`001?l00?l20006o`00o`3o
20001?l00?l20004o`00o`X000Co003o0`001?l00?l20004o`00o`l000Go0000o`020004o`00o`80
00Go0000o`020004o`00o`8000Co003o[P000d`000040003C00000@000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0000^00Co0`000ol000020004o`00o`8000Co003o0P001?l0
0?l30004o`00o`8000Go003o0004o`D000Co003o0P001?l00?l800;o0`001Ol0003o008000Co003o
0P04o``000Go0000o`020004o`00o`8000Go0000o`020004o`00o`8000Co003o[P000d`000040003
C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000^0005
o`000?l00P02o`<000Co003o0P001?l00?l20004o`00o`<000Co003o0P001_l00?l0o`8000?o0000
0`001?l00?l20003o`0000;o1P001?l00?l20005o`000?l00P001?l00?l20004o`00o`8000?o0000
1`001Ol0003o008000Co003o0P001Ol0003o008000Co003o0P001?l00?l80003o`000:<000=<0000
10000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;P001Ol0
003o008000Co0?oo0P02o`800ol200;o0P03o`8000Co003o0P03o`<00_l500?o0P02o`<000Co0?oo
1@02o`800ol20004o`00o`8000Co00000_l=0005o`000?l00P001Ol00?l000?o0P03o`<000Go003o
0003ojd000=<000010000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWC
o`01o`0000?o0000;P001Ol0003o00d000?o00001P000ol0000E0003o`0001@000?o00001`000ol0
000<0005o`3o0?l00`000ol000060003o`0000d000Oo0000o`3o0:P000=<000010000d`000040003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;P04o`h000?o00001P000ol0
000F00;o50000ol0000600;o3P000ol0o`0200?o2@000ol0000=0007o`000?l0o`2X0003C00000@0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0
HP000d`000040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o05l014`60003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o068000=<000010000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o0000;@3oobKo2`05C0801D`60003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1`0003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o0000o`1N00Go3@000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`000?l0G@07o``000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o05d000?o;Bd00bd00ol000030003C00000@000=<000010000d`000020003ooWC00;C00Gidm?C
n@03d`03nM?o007o00000ol0003o05d01Ol00bgo0003009<1P000d`000040003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`0003P01?oo02401Ol00bgo000200=<1P000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0003T00_oo02801Ol012go0004C0H000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000i00;oo`0R00Go00<]o`001D`60003
C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000;@07o`050?ooo`00
1Ol300Go0P02ool04`05o`03;Ol000@000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`0002h00_l200;o00<0ool00P02o`800_l0103oo`02o`800_oo01@01Ol00bgo
00040003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
000^00;o0P02o`030?oo00800_l200;o00@0ool00_l200;oo`0D00Go00<]o`0010000d`000040003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;P02o`800_l00`3oo`0200;o
0P02o`040?oo00;o0P02ool05005o`03;Ol000@000=<000010000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`0002h00_l200Go0P03o`040?oo00;o00<0ool00P02ool0
5005o`03;Ol000@000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0002h00_l01@3oool000;o00D0oooo0002o`050?ooo`000_l00`3oo`02ool04`05o`03;Ol000@0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002h0
0_lG00;oo`0D00Go00<]o`0010000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o0000;@04oaL000?o0000o`0B00Go00<]o`0010000d`000040003C00000@000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1M00Go00<]o`0010000d`000040003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1M00Go00<]o`0010000d`0
00040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000C002o`<0
00?o00009`02ob4000?o0000^`05o`03;Ol000@000=<000010000d`000040003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`0004h000Co003o:`000ol0000N0003o`000;/01Ol00bgo00040003
C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000/0003
o`0000@000?o00000`02o`@000?o00000_l40004o`0000?o0P03o`<00_l60004o`0000;o0`000ol0
000600;o10001?l00003o`8000Co00000_l30003o`0000P000Go0000o`020003o`0000?o1003o`<0
00?o00001@000ol0002V00Go00<]o`0010000d`000040003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000;0000ol000040003o`00008000Co003o0P001?l00?l20004o`00o`<0
00Co003o0P001_l00?l0o`8000?o00000`001?l00?l20004o`00o`L000Co003o0P001Ol0003o0080
00Co003o0P001?l00?l=0005o`000?l00P001?l00?l20004o`00o`8000Co003o/@05o`03;Ol000@0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002`0
00?o000010000ol000020004o`00o`8000Co003o0P001?l00?l30004o`00o`8000Ko003o0?l80004
o`00o`8000Co003o2P001?l00?l30004o`00o`8000Co003o40001Ol0003o008000Co003o0P001?l0
0?l20004o`00ok401Ol00bgo00040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000/00Co0`000ol000020004o`00o`8000Co003o0P001?l00?l30004o`00o`80
00Go003o0004o`D000Co003o0P001?l00?l800;o0`001Ol0003o008000Co003o0P04o`d000Go0000
o`020004o`00o`8000Co003o0P001?l00?na00Go00<]o`0010000d`000040003C00000@000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000;0001Ol0003o00800_l30004o`00o`80
00Co003o0P001?l00?l30004o`00o`8000Ko003o0?l20003o`0000<000Co003o0P000ol00002o`H0
00Co003o0P001Ol0003o008000Co003o0P001?l00?l20003o`0000P000Go0000o`020004o`00o`80
00Co003o0P001?l00?l80003o`000:H01Ol00bgo00040003C00000@000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0000/0005o`000?l00P001?l0ool200;o0P03o`800_l200?o
0P001?l00?l200?o0`02o`D00ol200;o0`001?l0ool500;o0P03o`8000Co003o0P001?l00002o`h0
00Co00000ol300?o0`001Ol00?l000?o/005o`03;Ol000@000=<000010000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002`000Go0000o`0=0003o`0000H000?o0000
5@000ol0000D0003o`0000L000?o000030000ol0o`020003o`0001<000Oo0000o`3o0:/01Ol00bgo
00040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000/00Co
3P000ol000060003o`0001H00_lD0003o`0000H00_l>0003o`3o008000?o00004`001ol0003o0?l0
Z`05o`03;Ol000@000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`000?l0G@05o`03;Ol000@000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`000?l0G@05o`03;Ol000@000=<000010000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`000?l0G@05o`03;Ol000@000=<000010000d`000040003
C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0002/0oolXo`X000?o;Bd00bd00ol0C004C0H0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o05d01ol<0003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1N00Go3@000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`000?l0L0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003
C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`000?l0L0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0
L0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0I@05C0H0
00=<000010000d`000020003onSX00cX0_l00003o`000?l0J@000d`000040003C00000@000=<0000
0P000olH_P0;_P7X0Ol1o`0000?o0000H`03ocX00olm00;oQP000d`000040003C00000@000=<0000
0P000olH_P0;_P7X0Ol1o`0000?o0000I0000ol0000i0004o`00och000?o0000P`000d`000040003
C00000@000=<00000P000olH_P02_PHH0kh1j07o0Ol00003o`0000X01?l300;o0P02o`050?oo0?l0
1@02o`800_l0103oo`02o`030?l000<00_l0103oool200;o0`02o`<00_l30003o`0000;o00@0o`3o
0P02o`800_l500;o0P03o`<00_l300;o0`000ol00002o`030?oo00;o0`02o`040?oo00;o00<0ool0
0`02o`050?ooo`000_l00`3o0002o`040?oo00;o0P02o`L000?o0?l00`001Ol00?l000;o00<0ool0
10001Ol0ool000;o00<0ool00P02o`<00_l500;o0`001?l00?l300?o00<0ool01@02o`040?oo00;o
00D0oooo0002o`040?oo00;o0P02o`8000?o0000F@000d`000040003C00000@000=<00000P000olH
_P02_PKQ0kh1j07o0Ol00003o`0000/000?o0?l00P001_l00?l0o`8000?o0?l01@001_l00?l0o`80
00?o0?l00P000ol000020004o`00o`<000Oo0000o`3o008000?o0?l00P001_l00?l0o`8000?o0?l0
0P001?l00?l30003o`0000@000?o0?l00P000ol0o`020003o`3o008000Ko003o0?l20004o`00o`@0
00Co003o0P000ol0o`020003o`3o008000?o0?l00P001_l00?l0o`8000Co003o1@000ol000040003
o`3o00<000?o0?l00P001?l00?l40004o`00o`8000?o0?l00P001ol0003o0?l00P000ol000040003
o`3o00<00_l30003o`3o008000?o00000P001_l00?l0o`8000?o0?l00P001_l00?l0o`8000Go0000
o`1M0003C00000@000=<000010000d`000020003oaRn00:n1QP3_P7X0Ol1o`0000?o00002`000ol0
o`020006o`00o`3o0P000ol0o`0500?o0P001_l00?l0o`8000?o00000`03o`8000Go0000o`020006
o`00o`3o1@000ol00003o`040?l000?o0`000ol000040004o`00o`8000?o0?l00_l20003o`0000<0
00?o00000ol20003o`00008000Co003o0P000ol0o`02o`<00ol01@3o003o008000?o0?l00P001Ol0
o`3o00<000?o000010001Ol0o`3o008000?o0?l00P001?l00?l40004o`00o`8000?o0?l00_l30003
o`0000?o1P001?l00?l20003o`3o00<000?o0?l00_l50004o`00o`800ol01@3o003o008000?o0?l0
0_l30003o`0005`000=<000010000d`000040003C000008000?o6;h00[h6h@>n0NP1o`7o00000ol0
000;0006o`3oo`3o0P000ol0o`020003o`3o00D000Ko003o0?l20003o`3o008000?o00001@000ol0
o`030005o`000?l00P000ol0o`020004o`00o`@000?o0?l00P001_l00?l0o`H000Go0000o`020003
o`3o008000?o0?l00P001?l00?l40004o`00o`@000Co003o0P000ol0o`020003o`00008000?o0?l0
0P001_l00?l0o`8000Go0?l0o`020003o`0000D000Go0?l0o`020003o`3o008000Co003o10001?l0
0?l20003o`3o008000?o0?l00`001?l00?l40005o`000?l00P001?l00?l20003o`3o008000?o0000
0P001?l00?l40003o`3o008000Ko003o0?l20003o`3o05l000=<000010000d`000040003C0000080
00?o6;h00[h660>n0NP1o`7o00000ol0000:00Co00<0o`000_l200?o00@0oooo1@02o`800ol300?o
1003o`<00_l200;o0P02o`<00_l200;o00D0oooo0003o`800_l300;o1@06o`<00_l300;o0P02o`04
0?ooo`<000?o00000P03o`030?oo00<00_l200?o0P03o`800_l0103oool300?o0P02o`@00_l00`3o
0007o`040?ooo`@00ol0103oool300;o0`02o`800_l600Oo00H0oooo0?l200;o1@03o`800ol200?o
00<0ool00`02o`<00_mM0003C00000@000=<000010000d`000020003oaRn00:n1^43_P7X0Ol1o`00
00?o00002`000ol0000<0003o`00010000?o00008@000ol0000X0003o`0003L000Co003o1`001?l0
0?lI0003o`0000H000?o0000OP000d`000040003C00000@000=<00000P000olH_P02_PHH0kh1j07o
0Ol00003o`0000`00_lN00;o70000ol0000W0003o`0000@00_lL0003o`0001P000Co00000_l900;o
8@02oh0000=<000010000d`000040003C000008000?o6;h00[h6h@>n0NP1o`7o00000ol0003o06T0
00=<000010000d`000040003C000008000?o6;h00[h660>n0NP1o`7o00000ol0003o06T000=<0000
10000d`000040003C000008000?o6;h00[h65`>n0NP1o`7o00000ol0003o06T000=<000010000d`0
00040003C000008000?o6;h02kh1j07o0Ol00003o`000?l0J@000d`000040003C00000@000=<0000
0P000olH600;607X0Ol1o`0000?o0000o`1Y0003C00000@000=<000010000d`000020003okFe00be
0_l00003o`000?l0J@000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000J@02o``00olZ00?o=@03ob@00_mS0003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0001[0003o`0000T000Ko003o0?lW0006o`00o`3o<P001?l0
0?lU0003o`0000d000?o0000D0000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o00002P05o`<00_l600;o0`02o`030?oo00<00_l200?o00@0ool01?l50003o`3o0080
0_l0103oo`02o`800_l00`3oo`0300;o00@0ool00_l00`3oo`0300;o00D0o`3o0003o`030?l000<0
00Go0?oo0002o`030?oo00<000?o00000P001?l00002o`800_l0103oo`02o`050?ooo`000_l01P3o
o`3o00;o00@0ool00_l30003o`0000<00_l20003o`0000<000Co00000_l200;o00@0ool00_l00`3o
o`040006o`000?l00_l0103oo`02o`H000Go0?oo0002o`030?oo00800_l300;o1@02o`<000Co003o
0`03o`030?oo00800_l30003o`0000800ol300;o0`02o`<00_l00`3o0002o`040?ooo`<00_l60005
o`3oo`000_l00`3oo`0M0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0000;0007o`000?l0o`020003o`00008000Ko003o0?l20003o`3o008000Co003o
0P000ol0o`020004o`00o`H000?o0?l00P001_l00?l0o`8000?o0?l00P000ol000020004o`00o`80
00?o0?l00P000ol0o`020004o`00o`8000?o00000_l30003o`3o008000Co003o10000ol000020004
o`00o`8000?o0?l00P000ol0o`020003o`3o008000Co003o0P000ol0o`020004o`00o`@000?o0000
0P001_l00?l0o`D000Co003o0P000ol0o`020006o`00o`3o0P001Ol0003o00<000?o0?l00P001?l0
0?l60004o`00o`8000?o0?l00P001ol0003o0?l00P000ol000040003o`3o00<00_l30003o`3o0080
00Go0000o`020003o`00008000Ko003o0?l20003o`3o008000?o0?l00P000ol0o`020007o`000?l0
o`020003o`00008000Co003o0P000ol0o`020003o`0001X000=<000010000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0000/000Ko0000o`03o`D000?o00000`03o`040?l000?o
0`000ol0o`020004o`00o`D000Oo0?l0o`3o008000?o0?l00_l20004o`00o`@000Co003o0P000ol0
o`020003o`3o008000Co003o0P001Ol0o`3o00<000?o0?l00P001Ol0o`3o00P000?o00000ol20004
o`00o`800ol01@3o003o008000Ko003o0?l20005o`3o0?l020001_l00?l0o`D000?o00000ol20004
o`00o`8000?o0?l00P001_l00?l0o`8000?o0?l00P001Ol0o`3o00D000Co003o0P000ol0o`02o`<0
00?o00000ol60004o`00o`8000?o0?l00`000ol0o`02o`<000?o00001P001Ol00?l000?o0P000ol0
000300?o00D0o`00o`020003o`0000?o1@001?l00?l20003o`3o00;o7@000d`000040003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00002`04o`8000Co003o10001?l0
0?l40006o`3oo`3o0P001_l00?l0o`8000Co003o1@001ol0o`3o0?l00P000ol0o`020003o`3o0080
00?o00000P001?l00?l20003o`3o008000?o0?l00P001?l00?l20003o`3o008000Ko003o0?l20005
o`3o0?l02002o`070?l00?l0o`020003o`00008000?o0?l00P001?l00?l20003o`3o008000Go0?l0
o`080005o`00o`000_l400;o00L0o`00o`3o008000Ko003o0?l20006o`00o`3o0P000ol0o`020005
o`3o0?l01@001?l00?l20003o`3o008000?o0?l00`001?l00?l40005o`000?l00P001?l00?l20003
o`3o008000?o0?l02@001_l00?l0o`8000?o0?l00P000ol000020003o`3o008000?o0?l00`001?l0
0?l40004o`00o`8000?o0?l00P000ol0000J0003C00000@000=<000010000d`000020004om?Cn@?C
00Gidm?Cn@03d`;o00000ol0000;0005o`000?l00P02o`H00_l200?o0P001?l0o`02o`801?l20004
o`00o`@00_l00`3o0005o`<00_l200?o1@03o`030?oo00<00_l300?o00@0ool01?l00`3oo`03o`04
0?ooo`<00ol70004o`3o00;o0P03o`800ol200?o00<0ool00P02o`040?ooo`<00ol800;o0P000ol0
o`030004o`3o00;o0P03o`030?oo00<00_l200;o00<0ool00_l0103oool300?o0`03o`040?ooo`<0
0_l300;o0P02o`H01ol01P3oool0o`800_l300;o1`03o`<00_l300;o0P03o`8000Co003o0P02o`80
0_l400?o00@0oooo0`02oad000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`0000/000Go0000o`0L0003o`0000D000?o00002@000ol0000O0003o`0000<0
00?o0000N@001?l00?lI0003o`0000H000?o00003P000ol0000R0004o`00ob@000=<000010000d`0
00040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000X01OlN00;o1002o`X00_lP00;o
0P001?l00002o`D000?o0000:P000ol0000e0003o`0000h00_lQ00;o3`02obH00_lT0003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o06T000=<0000
10000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0J@000d`000040003
C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1Y0003C00000@0
00=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o06T000=<000010000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0J@000d`000040003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1Y0003C00000@000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0002E00;o?P03ob`00omQ0003
C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0002G0003o`0003`0
00?o0000;0000ol0001P0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0000;00?o0P02o`040?oo00;o1P02o`<00_l200So1P001Ol0ool000;o10001Ol0
ool000;o00<0o`000_l500;o0`02o`<00_l30004o`00o`800_l200;o00<0ool01002o`030?l000;o
0P03o`030?l000;o00@0ool00_l500;o0`001?l00?l300?o00<0ool00P02o`H00_l0103oool300;o
0`02o`030?l000800ol00`3oo`020003o`0000@000Go0?oo0005o`<00_l0103o0?l500;o00D0oooo
0002o`050?oo0?l01002o`<00_l01@3o0?l000?o0`02o`040?l0o`D000?o00000_l60005o`3oo`00
0_l00`3oo`050003o`0000;o00<0ool00P000ol00002o`040?oo00;o0P04oad000=<000010000d`0
00040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000`000Go0000o`020003o`3o0080
00?o00000P001_l00?l0o`8000Co003o0P001Ol0003o00D000?o0?l00P000ol000020004o`00o`80
00Co003o0`000ol000040003o`3o008000?o0?l00P000ol0o`030003o`3o008000?o0?l00P000ol0
00020006o`00o`3o0P001?l00?l20003o`3o008000?o0?l00P000ol000040003o`3o00<00_l30003
o`3o008000Go0000o`040004o`00o`<000?o0?l00P000ol0o`020003o`0000<000?o0?l00P000ol0
o`060003o`3o008000?o0?l00P000ol0o`020003o`3o00D000Ko003o0?l20003o`3o008000?o0000
0P001_l00?l0o`8000?o0?l00P001_l00?l0o`8000?o0?l01@001?l00?l20003o`00008000Co003o
0P000ol0o`020003o`00008000Ko003o0?l20003o`3o008000Ko003o0?l20004o`00oal000=<0000
10000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000`000Go0000
o`020003o`3o00;o1@000ol0000200?o0`001?l00?l20003o`0000@000?o0?l00P000ol000020004
o`00o`8000Co003o0P000ol000040003o`0000?o0P000ol000020007o`000?l0o`020003o`3o0080
00?o00000P001Ol00?l000?o0`001_l00?l0o`8000?o0?l00_l60004o`00o`8000?o0?l00`000ol0
o`02o`<000?o00000`001?l00?l20003o`0000?o0P001?l00?l50003o`3o008000?o0?l01P000ol0
o`020003o`3o008000?o0?l00P000ol0o`0600?o00L0o`00o`3o008000?o00000P001_l00?l0o`80
00?o0?l00P001_l00?l0o`8000?o0?l01@001?l00?l20003o`00008000Co003o0P000ol0o`02o`D0
0ol200?o0P001?l00?l20003o`3o00;o0`000ol0000M0003C00000@000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0000<0005o`000?l00P000ol0o`020003o`00008000Ko003o
0?l20004o`00o`8000?o0?l01`000ol0o`020003o`00008000Co003o0P001_l00?l0o`H000Go0000
o`020003o`3o008000?o0?l00`000ol0o`020003o`3o008000?o00000P001_l00?l0o`8000Co003o
0P000ol0o`020003o`3o008000?o00000P001Ol0003o008000Co003o0P000ol0o`020003o`3o00H0
00Ko003o0?l30006o`00o`3o0P000ol000030003o`3o008000Co0?oo1@000ol0o`020003o`3o0080
00?o0?l00P000ol0o`080003o`3o008000?o0?l00P000ol000020006o`00o`3o0P000ol0o`020006
o`00o`3o0P000ol0o`050004o`00o`8000?o00000P001?l00?l20003o`3o008000?o00000P000ol0
o`020005o`00o`000_l01`3o003o0?l00P001?l00?lO0003C00000@000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000<0004o`0000?o0`02o`H00_l300;o0`001?l0
0?l200;o1002o`040?ooo`@00ol0103oool200;o0P02o`D00_l200;o0`02o`050?ooo`000_l200;o
0P03o`H00ol200;o0P05o`040?ooo`<00_l600Oo00H0oooo0?l200;o0`02o`@000Co003o0P02o`80
0_l300?o1003o`030?oo008000?o0?l00`02o`050?ooo`001?l20003o`0000Co1003o`800ol300?o
1@02o`8000?o00002?l20003o`0000Co0`03o`800_l400?o00@0oooo0`02o`D000Co003o0P02o`80
00?o0?l00ol300;o0`000ol0000M0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000:0007o`3o0?l0o`0G0004o`00oa<000Co003o70000ol0000C0003o`0000D0
00?o00004`000ol000060003o`0001`000?o00000`000ol0000L0003o`00010000?o000030000ol0
000:0003o`0000<000?o000020001?l00?l<0003o`0001D000?o00007@000d`000040003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00002P07oaH00_l00`3oo`090003
o`0000T00_l50003o`0001P000?o00003P02o`P00olJ00;o7@02o`H00_l;0003o`0002000_l^00;o
2`02oaH00_lO0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o06T000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0IP04C0H000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o06T0
00=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0
I@05C0H000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o0700
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C
00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o0700
00=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`0
00020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o06D01D`60003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1Y0003C00000@000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000Y00?oB@02ocL00_nh0003C00000@000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000Y00CoB002ocL00_nh0003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000/00;oA`02ocL0
0_nh0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo
2006o`@00ol400?o1002o`@01?l500Ko1`02o`@01Ol400;o2002o`800_l400;o0P02o`040?ooo`D0
1?l00`3oo`0200?o00<0ool01P05o`H01?l00`3oo`0200?o0P02o`040?ooo`D01?l00`3oo`0200?o
X`000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
2@09o`L02?l300?o1003o`@00_l300Ko0`08o`H00_l300Oo0`02o`P00_l200;o1002o`801ol300So
0P03o`030?oo00D01ol400So0P03o`801ol300So0P03oj<000=<000010000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol600?o1003o`800_l400;o00<0ool00`02o`80
0ol300;o0P02o`@00_l600;o0P03o`<00ol200;o2002o`800_l400;o0P03o`800ol200;o0`03o`80
0_l200;o1003o`<00ol300;o0`03o`800_l300?o0P03o`800_l300?o0P02oj@000=<000010000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000T02Ol600;o1P02o`80
0_l400;o00<0ool00`02o`800_l<00Co1P02o`800_l500;o0P02o`P00_l200;o1002o`800_l400;o
0P02o`@00_l200;o0`02o`800ol500?o0P02o`@00_l200;o0`02o`@00_l200;o1002o`800_nT0003
C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo3@03o`80
0_l400;o00<0ool00`02o`802?l300Ko1`02o`800_l500;o0P02o`P00_l200;o1002o`800_l400;o
0P02o`@00_l200;o0`02o`800_l700;o0P02o`@00_l200;o0`02o`@00_l200;o1002o`800_nT0003
C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo
2007o`<00_l400;o00<0ool00`02o`800_l400;o0P04o`X00_l200;o1@02o`800_l800;o0P02o`@0
0_l200;o1002o`800_l400;o0P02o`<00_l200;o1`02o`800_l400;o0P02o`<00_l400;o0P02o`@0
0_l200;oY0000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000
2@09o`L01ol400;o0`02o`<00_l200;o0P03o`800ol200;o1002o`H00_l200?o0`03o`800ol700;o
0P03o`<00_l200?o0P03o`800_l400;o0P02o`@00_l00`3oo`0700;o0P02o`@00_l200;o0`03o`80
0ol200;o1002o`800_nT0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0000900Wo1P03o`P01?l200;o0`02o`800_l300Ko0`08o`D01?l200Oo0`05o`D0
0_l200So0P07o`<00_l400;o00<0ool00_l300;o00<0ool01`02o`800_l400;o00<0ool00_l200Oo
0`02o`@00_l00`3oo`02oj<000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`0000T02Ol600;o1P02o`030?oo00;o0P02o`<00_l200;o1004o`H01?l700Co0`05o`@0
0_l00`3oo`0500;o0P02o`030?oo00;o0`02o`040?ooo`@00_l400;o00<0ool00_l300;o00@0oooo
1@03o`800_l400;o00<0ool00_l200;o00@0oooo1002o`@00_l00`3oo`02oj<000=<000010000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0001P00ol400?o0P02o``0
0_lJ00;o5`02ob000_l500;o00@0oooo0`03o`d00_lG00;oY0000d`000040003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00006@08o`<00_l<00;o6P03oaH00_lP00;o1@02o`80
1ol>00;o5`02oj@000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0001X01_lB00;o6`02oaH00_lW00;o0`05ol/014`60003C00000@000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000o`1Y0003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o06D01D`200E<1P000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1g0003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0
M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o07L000=<00000P0Ao`00
00?o0000o`1g0003C000008000?onOT03?T2o`0000?o0000o`1g0003C000008000?o0=<02m<1n@7o
0Ol00003o`000?l0I@05C0H000=<000010000d`000020003o`3C00;C1NP4d`7i0Ol1o`0000?o0000
o`1Y0003C00000<00T`60003C000008000?o0=<00]<01NPG5aOX00CC0OT1o`7o00000ol0000Y00?o
G003omd000=<00000P03C0H000=<00000P000ol0d`02d`05j1LG5nP01=<1n@7o0Ol00003o`0002T0
1?mK00Cog00014`00004C0H000=<00000P000ol0d`02d`05j1LG5nP01=<1n@7o0Ol00003o`0002`0
0_mM00;of`000d`00005C0H000=<00000P000ol0j003j0<G1>P00m?io`01o`0000?o00002@09o`P0
1_l400?o1003o`@00_l400Co1@06o`L00_l400Go1002o`P02?l600Go1P03o`030?oo00@00ol:00;o
1P04o`@00_l300;o0P03okD000=<000010000d`000040003C000008000Co0=?X1aL01>SCdoT2o`00
00?o00002@09o`L02?l300?o1003o`@00_l300Ko0`08o`H00_l300Oo0`02o`P02Ol400Oo1007o`@0
0ol:00;o1@06o`<00ol0103oool200?o]@000d`000040003C00000@000=<00000P001Ol0dm?X00DG
00GXdm?Cn@02o`0000?o00002@09o`H00ol400?o0P02o`@00_l00`3oo`0300;o0P03o`<00_l200;o
1002o`H00_l200?o0`03o`800_l800;o1P02o`800ol300?o0P03o`800ol300;o00<0ool02@02o`@0
0ol300;o0`02o`030?oo00<00_nf0003C00000@000=<000010000d`000020003o`3C00;C00GX5aLG
j004d`7i0Ol1o`0000?o00002@09o`H00_l600;o0P02o`@00_l00`3oo`0300;o0P02o``01?l600;o
0P02o`D00_l200;o2002o`H00_l200;o1@02o`800_l400;o0`02o`030?oo00T00_l400;o2P03o`@0
0_nf0003C00000@000=<000010000d`000020003o`3C00?C00?X5nP01M<1n@7o0Ol00003o`0000T0
2Ol=00?o0P02o`@00_l00`3oo`0300;o0P08o`<01_l700;o0P02o`D00_l200;o2002o`H00_l200;o
1@02o`800_l400;o0`02o`030?oo00T00_l400So1003o`@00_nf0003C00000@000=<000010000d`0
00020003o`3C00CC00?Xdm<01=<1n@7o0Ol00003o`0000T02Ol800Oo0`02o`@00_l00`3oo`0300;o
0P02o`@00_l200Co2P02o`800_l500;o0P02o`P02Ol300;o1@02o`800_l400;o0`02o`030?oo00T0
0_l400;o1002o`@00ol400;o]P000d`000040003C00000@000=<00000P000ol0d`0;d`7i0Ol1o`00
00?o00002@09o`L01ol400;o0`02o`<00_l200;o0P03o`800ol200;o1002o`H00_l200?o0`03o`80
0ol700Wo0`03o`<00ol200?o0P03o`800_l300;o2002o`@00ol200?o0`02o`030?oo00<00_nf0003
C00000@000=<000010000d`000020003o`0000/00OT1o`7o003ooi3o00000olG5`3o5h/G0_l00003
oaSK06gK1?oofaWK0AL1o`7o00000olHf`1/f`04om_Kf`;oom/Hf`4G0Ol1o`0000?o6?T01OT00m_X
60096003foWi04Ci6=/2okgKAoT00m_X60096003foWi00Ci0AL1o`7o00000olHf`06f`03j1SX00OX
00<Hfm/0CM/3o`GK0_l3f`Go0]/2o`?K1?l7f`Go1=/4o`CK0_l3f`;o0]/2o`;K0_l2f`;o1=/2o`;K
0_l3f`Co0m/2o`;K0_l3f`?o2=/2o`CK1?l3f`;o2M/4o`?K0_l2f`;o1=/2o`;K0_l4f`;o0]/2o`?K
1?l4f`Go2m/2oe7K00?X6>P01nP00aSKf`05f`4G0Ol1o`0000?o6?T01OT00m_X6007_P03j1SK04Ki
1m/00ooKf`02o`?K0_l3f`;o0]/2o`;K0_l2f`;o0m/00ooKf`04f`;o0]/2o`;K0_l3f`04om_Kf`;o
0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`;K00?ofm/00_l7f`;o0m/2o`;K
0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`;o0m/00ooKf`02o`;K0_l;f`;o
2M]7n@03fnPH00Nn00?X6=/01_T15`7o0Ol00003oaSK00KK00?X6;h01[h00nPHf`1@f`;o0m/2o`?K
0_l2f`;o0]/2o`;K0_l:f`;o0]/2o`;K0_l7f`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K
0_l2f`;o0]/2o`CK0ol7f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K
0_l2f`;o1]/2o`;K0_l;f`;oDM/00nPH_P06_P03j1SK00KK0AL1o`7o00000olHn@05n@03fnPH00Nn
00?X6=/0A_T9f`?o0m/2o`?K0_l2f`;o0]/2o`;K1_l6f`;o0]/2o`;K1_l3f`;o0m/2o`;K0_l2f`;o
0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`?K0ol8f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o
0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`Ko0]/2o`;K0_l;f`;o2M]7n@03fnPH00GX0[h00nPHf`06n@4G
0Ol1o`0000?o6=/01]/00nPH_P06_P03j1SK04kK0ol4f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l6f`;o
0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l2f`?o
2M/2o`?K0_l2f`;o0]/2o`SK0_l2f`;o0]/2o`;K0_l3f`;o0m/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o
0]/2o`;K1Ol4f`;oDM/00nPH_P03_P05j;jnj1P01m/15`7o0Ol00003oaSi00Gi00?Kj1P01kh00nPH
f`16n@OK0ol5f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l6f`;o0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l2f`;o0]/00ooKf`05f`;o0m/2o`;K0_l2f`?o
1m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l2f`;o2m/2o`WKAoT00m_X
6004_P06j;jnj1SK1_T15`7o0Ol00003oaSK00KK00?X6;h01[h00nPHf`1=f`;o1M/4o`;K0_l2f`;o
0]/2o`?K1?l7f`;o0]/2o`?K1?l3f`Co0]/2o`;K1Ol3f`;o0]/4o`;K0_l3f`Co0m/5o`CK0ol7f`Co
0m/4o`?K0_l00m_oo`05f`;o0]/2o`;K1Ol3f`Co0]/2o`;K1?l2f`;o0m/4o`CK1Ol;f`;oDM/00nPH
_P03_P05j;jnj1P01m/15`7o0Ol00003oaSi00Gi00?Kj1P01kh00nPHf`16n@OK0_l2f`04om_Kf`;o
2m/2o`kK0_l2f`;o2m/2oaCK0_lSf`;o5M/2o`;K0_l;f`;o2=/2o`?K0_l>f`;o2]/3o`WKAoT00m_X
6004_P06j;jnj1SK1_T15`7o0Ol00003oaSK00KK00?X61P021Q?f`?o1=/2o`_K0_l>f`Go3M/3o`03
fooo00[K0_l3f`;o0m/2oaoK0olCf`;o0]/2o`_K0_l3f`;o0m/2o`?K0_l>f`;o2m/2oe7K00?X61P0
21P7f`4G0Ol1o`0000?o6?T01OT00m_Xj009j003foWi04Ciem]7n@03fnSX00WX00?KnOT01?T15`7o
0Ol00003oaSK0?oKR]/15`7o0Ol00003oaSK0?oKR]/15`7o0Ol00003oaPH0?lHRQP15`7o0Ol00?oo
Sol10P00\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  ImageSize->{399, 190},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Here we pull down the Format menu and choose ",
  StyleBox["Italic", "MenuItem"],
  " from the Face submenu."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006?0000`@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000003o`0002l000?o000010001Ol0ool000Oo
00<0ool00P02o`030?oo00?oo`0C0003C00000@000=<000010000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`00030000?o00000P000ol000060003o`0000`000?o0000
o`0B0003C00000@000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0003000_l200;oo`0/0003C00000@000=<000010000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`0003401?oo02d000=<000010000d`000040003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1R0003C00000@000=<000010000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0004h00_l30003o`0002L00_lW0003
o`000;P000=<000010000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000D0001?l00?l[0003o`0002@000?o0000^0000d`000040003C00000@000=<000010000d`0
00020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000^0003o`0000@000?o00000`02o`@0
00?o00000_l40004o`0000?o0P03o`<00_l60004o`0000;o0`000ol0000600;o10001?l00003o`80
00Co00000_l30003o`0000P00ol400?o0`000ol00003o`@00ol30003o`0000D000?o0000X`000d`0
00040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000^0003
o`0000@000?o00000P001?l00?l20004o`00o`8000Co003o0`001?l00?l20006o`00o`3o0P000ol0
00030004o`00o`8000Co003o1`001?l00?l20005o`000?l00P001?l00?l20004o`00o``000Go0000
o`020004o`00o`8000Go0000o`020004o`00o`8000Co003o[P000d`000040003C00000@000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000^0003o`0000@000?o0000
0P001?l00?l20004o`00o`8000Co003o0`001?l00?l20006o`00o`3o20001?l00?l20004o`00o`X0
00Co003o0`001?l00?l20004o`00o`l000Go0000o`020004o`00o`8000Go0000o`020004o`00o`80
00Co003o[P000d`000040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0000^00Co0`000ol000020004o`00o`8000Co003o0P001?l00?l30004o`00o`8000Go003o
0004o`D000Co003o0P001?l00?l800;o0`001Ol0003o008000Co003o0P04o``000Go0000o`020004
o`00o`8000Go0000o`020004o`00o`8000Co003o[P000d`000040003C00000@000=<000010000d`0
00020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000^0005o`000?l00P02o`<000Co003o
0P001?l00?l20004o`00o`<000Co003o0P001_l00?l0o`8000?o00000`001?l00?l20003o`0000;o
1P001?l00?l20005o`000?l00P001?l00?l20004o`00o`8000?o00001`001Ol0003o008000Co003o
0P001Ol0003o008000Co003o0P001?l00?l80003o`000:<000=<000010000d`000040003C00000@0
00=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;P001Ol0003o008000Co0?oo0P02o`80
0ol200;o0P03o`8000Co003o0P03o`<00_l500?o0P02o`<000Co0?oo1@02o`800ol20004o`00o`80
00Co00000_l=0005o`000?l00P001Ol00?l000?o0P03o`<000Go003o0003ojd000=<000010000d`0
00040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000;P001Ol0
003o00d000?o00001P000ol0000E0003o`0001@000?o00001`000ol0000<0005o`3o0?l00`000ol0
00060003o`0000d000Oo0000o`3o0:P000=<000010000d`000040003C00000@000=<00000P001?oC
doT3d`05nM?CdoT00m<2o`0000?o0000;P04o`h000?o00001P000ol0000F00;o50000ol0000600;o
3P000ol0o`0200?o2@000ol0000=0007o`000?l0o`2X0003C00000@000=<000010000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0HP000d`000040003C00000@0
00=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o05l014`60003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o068000=<0000
10000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;@3oobKo
2`05C0801D`60003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000
o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@0
00=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<0000
0P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1`0003C00000@000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o0000o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT0
0m<2o`0000?o0000o`1`0003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`00
00?o0000o`1`0003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1N00Go
3@000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0G@07o``0
00=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o05d000?o;Bd00bd00ol0
00030003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o05d01Ol00bgo0003009<1P000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0003L01?oo02801Ol00bgo000200=<1P000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`0003P00_oo02<01Ol012go0004C0H000=<000010000d`000020004om?Cn@?C
00Gidm?Cn@03d`;o00000ol0000h00;oo`0S00Go00<]o`001D`60003C00000@000=<00000P000ooi
d`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000;004o`800_l01@3oool000Co0P02o`050?ooo`00
0_oo01D01Ol00bgo00040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0000]00;o0`02o`040?oo00?o00@0ool01Ol00`3oo`02ool05005o`03;Ol000@000=<0000
10000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002h00_l300;o
00@0o`000_l200Co00<0ool00P02ool05@05o`03;Ol000@000=<000010000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`0002h00_l300;o00<0ool00P02o`040?oo00;o00<0ool0
0P02ool05005o`03;Ol000@000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`0002h00_l300Go0P05o`040?oo00;o0P02ool05005o`03;Ol000@000=<0000
10000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0002h00_l200?o00@0ool0
0ol00`3oo`03o`040?oo00Coo`0C00Go00<]o`0010000d`000040003C00000@000=<00000P000ooi
d`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000;`02oaL000?o0000o`0B00Go00<]o`0010000d`0
00040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;P04oaH000?o0000
o`0B00Go00<]o`0010000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWC
o`01o`0000?o0000o`1M00Go00<]o`0010000d`000040003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000o`1M00Go00<]o`0010000d`000040003C00000@000=<00000P000ooi
d`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000C002o`<000?o00009`02ob4000?o0000^`05o`03
;Ol000@000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0004h0
00Co003o:`000ol0000N0003o`000;/01Ol00bgo00040003C00000@000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000/0003o`0000@000?o00000`02o`@000?o0000
0_l40004o`0000?o0P03o`<00_l60004o`0000;o0`000ol0000600;o10001?l00003o`8000Co0000
0_l30003o`0000P000Go0000o`020003o`0000?o1003o`<000?o00001@000ol0002V00Go00<]o`00
10000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000;0000ol0
00040003o`00008000Co003o0P001?l00?l20004o`00o`<000Co003o0P001_l00?l0o`8000?o0000
0`001?l00?l20004o`00o`L000Co003o0P001Ol0003o008000Co003o0P001?l00?l=0005o`000?l0
0P001?l00?l20004o`00o`8000Co003o/@05o`03;Ol000@000=<000010000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0002`000?o000010000ol000020004o`00o`80
00Co003o0P001?l00?l30004o`00o`8000Ko003o0?l80004o`00o`8000Co003o2P001?l00?l30004
o`00o`8000Co003o40001Ol0003o008000Co003o0P001?l00?l20004o`00ok401Ol00bgo00040003
C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000/00Co0`000ol0
00020004o`00o`8000Co003o0P001?l00?l30004o`00o`8000Go003o0004o`D000Co003o0P001?l0
0?l800;o0`001Ol0003o008000Co003o0P04o`d000Go0000o`020004o`00o`8000Co003o0P001?l0
0?na00Go00<]o`0010000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT00m<00oWC
o`01o`0000?o0000;0001Ol0003o00800_l30004o`00o`8000Co003o0P001?l00?l30004o`00o`80
00Ko003o0?l20003o`0000<000Co003o0P000ol00002o`H000Co003o0P001Ol0003o008000Co003o
0P001?l00?l20003o`0000P000Go0000o`020004o`00o`8000Co003o0P001?l00?l80003o`000:H0
1Ol00bgo00040003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
000/0005o`000?l00P001?l0ool200;o0P03o`800_l200?o0P001?l00?l200?o0`02o`D00ol200;o
0`001?l0ool500;o0P03o`8000Co003o0P001?l00002o`h000Co00000ol300?o0`001Ol00?l000?o
/005o`03;Ol000@000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol0
0Ol00003o`0002`000Go0000o`0=0003o`0000H000?o00005@000ol0000D0003o`0000L000?o0000
30000ol0o`020003o`0001<000Oo0000o`3o0:/01Ol00bgo00040003C00000@000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000/00Co3P000ol000060003o`0001H00_lD0003
o`0000H00_l>0003o`3o008000?o00004`001ol0003o0?l0Z`05o`03;Ol000@000=<000010000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0G@05o`03;Ol000@0
00=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0G@05o`03
;Ol000@000=<000010000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0G@05o`03;Ol000@000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`0002/0oolXo`X000?o;Bd00bd00ol0C004C0H000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o05d01ol<0003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000o`1N00Go3@000d`000040003C000008000?onM<00]<01OWCdm?i00?C
00?idol00Ol00003o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`000?l0L0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0
L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003C0000080
00Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C
0_l00003o`000?l0L0000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003
o`000?l0L0000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0L0000d`000040003
C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0L0000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`000?l0I@05C0H000=<000010000d`000020003onSX00cX
0_l00003o`000?l0J@000d`000040003C00000@000=<00000P000olH_P0;_P7X0Ol1o`0000?o0000
H`03ocX00olm00;oQP000d`000040003C00000@000=<00000P000olH_P0;_P7X0Ol1o`0000?o0000
I0000ol0000i0004o`00och000?o0000P`000d`000040003C00000@000=<00000P000olH_P02_PHH
0kh1j07o0Ol00003o`0000X01?l300;o0P02o`050?oo0?l01@02o`800_l0103oo`02o`030?l000<0
0_l0103oool200;o0`02o`<00_l30003o`0000;o00@0o`3o0P02o`800_l500;o0P03o`<00_l300;o
0`000ol00002o`030?oo00;o0`02o`040?oo00;o00<0ool00`02o`050?ooo`000_l00`3o0002o`04
0?oo00;o0P02o`L000?o0?l00`001Ol00?l000;o00<0ool010001Ol0ool000;o00<0ool00P02o`<0
0_l500;o0`001?l00?l300?o00<0ool01@02o`040?oo00;o00D0oooo0002o`040?oo00;o0P02o`80
00?o0000F@000d`000040003C00000@000=<00000P000olH_P02_PKQ0kh1j07o0Ol00003o`0000/0
00?o0?l00P001_l00?l0o`8000?o0?l01@001_l00?l0o`8000?o0?l00P000ol000020004o`00o`<0
00Oo0000o`3o008000?o0?l00P001_l00?l0o`8000?o0?l00P001?l00?l30003o`0000@000?o0?l0
0P000ol0o`020003o`3o008000Ko003o0?l20004o`00o`@000Co003o0P000ol0o`020003o`3o0080
00?o0?l00P001_l00?l0o`8000Co003o1@000ol000040003o`3o00<000?o0?l00P001?l00?l40004
o`00o`8000?o0?l00P001ol0003o0?l00P000ol000040003o`3o00<00_l30003o`3o008000?o0000
0P001_l00?l0o`8000?o0?l00P001_l00?l0o`8000Go0000o`1M0003C00000@000=<000010000d`0
00020003oaRn00:n1QP3_P7X0Ol1o`0000?o00002`000ol0o`020006o`00o`3o0P000ol0o`0500?o
0P001_l00?l0o`8000?o00000`03o`8000Go0000o`020006o`00o`3o1@000ol00003o`040?l000?o
0`000ol000040004o`00o`8000?o0?l00_l20003o`0000<000?o00000ol20003o`00008000Co003o
0P000ol0o`02o`<00ol01@3o003o008000?o0?l00P001Ol0o`3o00<000?o000010001Ol0o`3o0080
00?o0?l00P001?l00?l40004o`00o`8000?o0?l00_l30003o`0000?o1P001?l00?l20003o`3o00<0
00?o0?l00_l50004o`00o`800ol01@3o003o008000?o0?l00_l30003o`0005`000=<000010000d`0
00040003C000008000?o6;h00[h6h@>n0NP1o`7o00000ol0000;0006o`3oo`3o0P000ol0o`020003
o`3o00D000Ko003o0?l20003o`3o008000?o00001@000ol0o`030005o`000?l00P000ol0o`020004
o`00o`@000?o0?l00P001_l00?l0o`H000Go0000o`020003o`3o008000?o0?l00P001?l00?l40004
o`00o`@000Co003o0P000ol0o`020003o`00008000?o0?l00P001_l00?l0o`8000Go0?l0o`020003
o`0000D000Go0?l0o`020003o`3o008000Co003o10001?l00?l20003o`3o008000?o0?l00`001?l0
0?l40005o`000?l00P001?l00?l20003o`3o008000?o00000P001?l00?l40003o`3o008000Ko003o
0?l20003o`3o05l000=<000010000d`000040003C000008000?o6;h00[h660>n0NP1o`7o00000ol0
000:00Co00<0o`000_l200?o00@0oooo1@02o`800ol300?o1003o`<00_l200;o0P02o`<00_l200;o
00D0oooo0003o`800_l300;o1@06o`<00_l300;o0P02o`040?ooo`<000?o00000P03o`030?oo00<0
0_l200?o0P03o`800_l0103oool300?o0P02o`@00_l00`3o0007o`040?ooo`@00ol0103oool300;o
0`02o`800_l600Oo00H0oooo0?l200;o1@03o`800ol200?o00<0ool00`02o`<00_mM0003C00000@0
00=<000010000d`000020003oaRn00:n1^43_P7X0Ol1o`0000?o00002`000ol0000<0003o`000100
00?o00008@000ol0000X0003o`0003L000Co003o1`001?l00?lI0003o`0000H000?o0000OP000d`0
00040003C00000@000=<00000P000olH_P02_PHH0kh1j07o0Ol00003o`0000`00_lN00;o70000ol0
000W0003o`0000@00_lL0003o`0001P000Co00000_l900;o8@02oh0000=<000010000d`000040003
C000008000?o6;h00[h6h@>n0NP1o`7o00000ol0003o06T000=<000010000d`000040003C0000080
00?o6;h00[h660>n0NP1o`7o00000ol0003o06T000=<000010000d`000040003C000008000?o6;h0
0[h65`>n0NP1o`7o00000ol0003o06T000=<000010000d`000040003C000008000?o6;h02kh1j07o
0Ol00003o`000?l0J@000d`000040003C00000@000=<00000P000olH600;607X0Ol1o`0000?o0000
o`1Y0003C00000@000=<000010000d`000020003okFe00be0_l00003o`000?l0J@000d`000040003
C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000J@02o``00olZ00?o=@03ob@0
0_mS0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
001[0003o`0000T000Ko003o0?lW0006o`00o`3o<P001?l00?lU0003o`0000d000?o0000D0000d`0
00040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002P05o`<00_l600;o
0`02o`030?oo00<00_l200?o00@0ool01?l50003o`3o00800_l0103oo`02o`800_l00`3oo`0300;o
00@0ool00_l00`3oo`0300;o00D0o`3o0003o`030?l000<000Go0?oo0002o`030?oo00<000?o0000
0P001?l00002o`800_l0103oo`02o`050?ooo`000_l01P3oo`3o00;o00@0ool00_l30003o`0000<0
0_l20003o`0000<000Co00000_l200;o00@0ool00_l00`3oo`040006o`000?l00_l0103oo`02o`H0
00Go0?oo0002o`030?oo00800_l300;o1@02o`<000Co003o0`03o`030?oo00800_l30003o`000080
0ol300;o0`02o`<00_l00`3o0002o`040?ooo`<00_l60005o`3oo`000_l00`3oo`0M0003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000;0007o`000?l0
o`020003o`00008000Ko003o0?l20003o`3o008000Co003o0P000ol0o`020004o`00o`H000?o0?l0
0P001_l00?l0o`8000?o0?l00P000ol000020004o`00o`8000?o0?l00P000ol0o`020004o`00o`80
00?o00000_l30003o`3o008000Co003o10000ol000020004o`00o`8000?o0?l00P000ol0o`020003
o`3o008000Co003o0P000ol0o`020004o`00o`@000?o00000P001_l00?l0o`D000Co003o0P000ol0
o`020006o`00o`3o0P001Ol0003o00<000?o0?l00P001?l00?l60004o`00o`8000?o0?l00P001ol0
003o0?l00P000ol000040003o`3o00<00_l30003o`3o008000Go0000o`020003o`00008000Ko003o
0?l20003o`3o008000?o0?l00P000ol0o`020007o`000?l0o`020003o`00008000Co003o0P000ol0
o`020003o`0001X000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0000/000Ko0000o`03o`D000?o00000`03o`040?l000?o0`000ol0o`020004o`00o`D000Oo0?l0
o`3o008000?o0?l00_l20004o`00o`@000Co003o0P000ol0o`020003o`3o008000Co003o0P001Ol0
o`3o00<000?o0?l00P001Ol0o`3o00P000?o00000ol20004o`00o`800ol01@3o003o008000Ko003o
0?l20005o`3o0?l020001_l00?l0o`D000?o00000ol20004o`00o`8000?o0?l00P001_l00?l0o`80
00?o0?l00P001Ol0o`3o00D000Co003o0P000ol0o`02o`<000?o00000ol60004o`00o`8000?o0?l0
0`000ol0o`02o`<000?o00001P001Ol00?l000?o0P000ol0000300?o00D0o`00o`020003o`0000?o
1@001?l00?l20003o`3o00;o7@000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o00002`04o`8000Co003o10001?l00?l40006o`3oo`3o0P001_l00?l0o`80
00Co003o1@001ol0o`3o0?l00P000ol0o`020003o`3o008000?o00000P001?l00?l20003o`3o0080
00?o0?l00P001?l00?l20003o`3o008000Ko003o0?l20005o`3o0?l02002o`070?l00?l0o`020003
o`00008000?o0?l00P001?l00?l20003o`3o008000Go0?l0o`080005o`00o`000_l400;o00L0o`00
o`3o008000Ko003o0?l20006o`00o`3o0P000ol0o`020005o`3o0?l01@001?l00?l20003o`3o0080
00?o0?l00`001?l00?l40005o`000?l00P001?l00?l20003o`3o008000?o0?l02@001_l00?l0o`80
00?o0?l00P000ol000020003o`3o008000?o0?l00`001?l00?l40004o`00o`8000?o0?l00P000ol0
000J0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000;0005
o`000?l00P02o`H00_l200?o0P001?l0o`02o`801?l20004o`00o`@00_l00`3o0005o`<00_l200?o
1@03o`030?oo00<00_l300?o00@0ool01?l00`3oo`03o`040?ooo`<00ol70004o`3o00;o0P03o`80
0ol200?o00<0ool00P02o`040?ooo`<00ol800;o0P000ol0o`030004o`3o00;o0P03o`030?oo00<0
0_l200;o00<0ool00_l0103oool300?o0`03o`040?ooo`<00_l300;o0P02o`H01ol01P3oool0o`80
0_l300;o1`03o`<00_l300;o0P03o`8000Co003o0P02o`800_l400?o00@0oooo0`02oad000=<0000
10000d`000040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0000/000Go0000
o`0L0003o`0000D000?o00002@000ol0000O0003o`0000<000?o0000N@001?l00?lI0003o`0000H0
00?o00003P000ol0000R0004o`00ob@000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`0000X01OlN00;o1002o`X00_lP00;o0P001?l00002o`D000?o0000:P000ol0
000e0003o`0000h00_lQ00;o3`02obH00_lT0003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o06T000=<000010000d`000040003C000008000Codm?i
0m<01OWCdm?i00?C0_l00003o`000?l0J@000d`000040003C00000@000=<00000P000ooid`02d`05
nM?CdoT00m<00oWCo`01o`0000?o0000o`1Y0003C00000@000=<000010000d`000020004om?Cn@?C
00Gidm?Cn@03d`;o00000ol0003o06T000=<000010000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`000?l0J@000d`000040003C00000@000=<00000P001?oCdoT3d`05
nM?CdoT00m<2o`0000?o0000o`1Y0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?C
n@03d`03nM?o007o00000ol0002E00;o?P03ob`00omQ0003C00000@000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0002G0003o`0003`000?o0000;0000ol0001P0003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000;00?o0P02o`04
0?oo00;o1P02o`<00_l200So1P001Ol0ool000;o10001Ol0ool000;o00<0o`000_l500;o0`02o`<0
0_l30004o`00o`800_l200;o00<0ool01002o`030?l000;o0P03o`030?l000;o00@0ool00_l500;o
0`001?l00?l300?o00<0ool00P02o`H00_l0103oool300;o0`02o`030?l000800ol00`3oo`020003
o`0000@000Go0?oo0005o`<00_l0103o0?l500;o00D0oooo0002o`050?oo0?l01002o`<00_l01@3o
0?l000?o0`02o`040?l0o`D000?o00000_l60005o`3oo`000_l00`3oo`050003o`0000;o00<0ool0
0P000ol00002o`040?oo00;o0P04oad000=<000010000d`000040003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`0000`000Go0000o`020003o`3o008000?o00000P001_l00?l0o`8000Co003o
0P001Ol0003o00D000?o0?l00P000ol000020004o`00o`8000Co003o0`000ol000040003o`3o0080
00?o0?l00P000ol0o`030003o`3o008000?o0?l00P000ol000020006o`00o`3o0P001?l00?l20003
o`3o008000?o0?l00P000ol000040003o`3o00<00_l30003o`3o008000Go0000o`040004o`00o`<0
00?o0?l00P000ol0o`020003o`0000<000?o0?l00P000ol0o`060003o`3o008000?o0?l00P000ol0
o`020003o`3o00D000Ko003o0?l20003o`3o008000?o00000P001_l00?l0o`8000?o0?l00P001_l0
0?l0o`8000?o0?l01@001?l00?l20003o`00008000Co003o0P000ol0o`020003o`00008000Ko003o
0?l20003o`3o008000Ko003o0?l20004o`00oal000=<000010000d`000040003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`0000`000Go0000o`020003o`3o00;o1@000ol0000200?o
0`001?l00?l20003o`0000@000?o0?l00P000ol000020004o`00o`8000Co003o0P000ol000040003
o`0000?o0P000ol000020007o`000?l0o`020003o`3o008000?o00000P001Ol00?l000?o0`001_l0
0?l0o`8000?o0?l00_l60004o`00o`8000?o0?l00`000ol0o`02o`<000?o00000`001?l00?l20003
o`0000?o0P001?l00?l50003o`3o008000?o0?l01P000ol0o`020003o`3o008000?o0?l00P000ol0
o`0600?o00L0o`00o`3o008000?o00000P001_l00?l0o`8000?o0?l00P001_l00?l0o`8000?o0?l0
1@001?l00?l20003o`00008000Co003o0P000ol0o`02o`D00ol200?o0P001?l00?l20003o`3o00;o
0`000ol0000M0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0
000<0005o`000?l00P000ol0o`020003o`00008000Ko003o0?l20004o`00o`8000?o0?l01`000ol0
o`020003o`00008000Co003o0P001_l00?l0o`H000Go0000o`020003o`3o008000?o0?l00`000ol0
o`020003o`3o008000?o00000P001_l00?l0o`8000Co003o0P000ol0o`020003o`3o008000?o0000
0P001Ol0003o008000Co003o0P000ol0o`020003o`3o00H000Ko003o0?l30006o`00o`3o0P000ol0
00030003o`3o008000Co0?oo1@000ol0o`020003o`3o008000?o0?l00P000ol0o`080003o`3o0080
00?o0?l00P000ol000020006o`00o`3o0P000ol0o`020006o`00o`3o0P000ol0o`050004o`00o`80
00?o00000P001?l00?l20003o`3o008000?o00000P000ol0o`020005o`00o`000_l01`3o003o0?l0
0P001?l00?lO0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0000<0004o`0000?o0`02o`H00_l300;o0`001?l00?l200;o1002o`040?ooo`@00ol0103o
ool200;o0P02o`D00_l200;o0`02o`050?ooo`000_l200;o0P03o`H00ol200;o0P05o`040?ooo`<0
0_l600Oo00H0oooo0?l200;o0`02o`@000Co003o0P02o`800_l300?o1003o`030?oo008000?o0?l0
0`02o`050?ooo`001?l20003o`0000Co1003o`800ol300?o1@02o`8000?o00002?l20003o`0000Co
0`03o`800_l400?o00@0oooo0`02o`D000Co003o0P02o`8000?o0?l00ol300;o0`000ol0000M0003
C00000@000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000:0007o`3o0?l0
o`0G0004o`00oa<000Co003o70000ol0000C0003o`0000D000?o00004`000ol000060003o`0001`0
00?o00000`000ol0000L0003o`00010000?o000030000ol0000:0003o`0000<000?o000020001?l0
0?l<0003o`0001D000?o00007@000d`000040003C00000@000=<00000P000ooid`02d`05nM?CdoT0
0m<00oWCo`01o`0000?o00002P07oaH00_l00`3oo`090003o`0000T00_l50003o`0001P000?o0000
3P02o`P00olJ00;o7@02o`H00_l;0003o`0002000_l^00;o2`02oaH00_lO0003C00000@000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o06T000=<000010000d`000040003
C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0IP04C0H000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o06T000=<000010000d`000040003C0000080
00?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`000?l0I@05C0H000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?C
n@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<0000
10000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0003o070000=<000010000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o0700
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<0000
10000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0003o070000=<000010000d`000020004om?Cn@?C
00Gidm?Cn@03d`;o00000ol0003o070000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03
nM?o007o00000ol0003o06D01D`60003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o0000o`1Y0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o
00000ol0000Y00?oB@02ocL00_nh0003C00000@000=<000010000d`000020004om?Cn@?C00Gidm?C
n@03d`;o00000ol0000Y00CoB002ocL00_nh0003C00000@000=<000010000d`000020003ooWC00;C
00Gidm?Cn@03d`03nM?o007o00000ol0000/00;oA`02ocL00_nh0003C00000@000=<000010000d`0
00020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo2006o`@00ol400?o1002o`@01?l500Ko
1`02o`@01Ol400;o2002o`800_l400;o0P02o`040?ooo`D01?l00`3oo`0200?o00<0ool01P05o`H0
1?l00`3oo`0200?o0P02o`040?ooo`D01?l00`3oo`0200?oX`000d`000040003C00000@000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o00002@09o`L02?l300?o1003o`@00_l300Ko
0`08o`H00_l300Oo0`02o`P00_l200;o1002o`801ol300So0P03o`030?oo00D01ol400So0P03o`80
1ol300So0P03oj<000=<000010000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003
o`0000T02Ol600?o1003o`800_l400;o00<0ool00`02o`800ol300;o0P02o`@00_l600;o0P03o`<0
0ol200;o2002o`800_l400;o0P03o`800ol200;o0`03o`800_l200;o1003o`<00ol300;o0`03o`80
0_l300?o0P03o`800_l300?o0P02oj@000=<000010000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`0000T02Ol600;o1P02o`800_l400;o00<0ool00`02o`800_l<00Co
1P02o`800_l500;o0P02o`P00_l200;o1002o`800_l400;o0P02o`@00_l200;o0`02o`800ol500?o
0P02o`@00_l200;o0`02o`@00_l200;o1002o`800_nT0003C00000@000=<000010000d`000020004
om?Cn@?C00Gidm?Cn@03d`;o00000ol0000900Wo3@03o`800_l400;o00<0ool00`02o`802?l300Ko
1`02o`800_l500;o0P02o`P00_l200;o1002o`800_l400;o0P02o`@00_l200;o0`02o`800_l700;o
0P02o`@00_l200;o0`02o`@00_l200;o1002o`800_nT0003C00000@000=<000010000d`000020003
ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo2007o`<00_l400;o00<0ool00`02o`80
0_l400;o0P04o`X00_l200;o1@02o`800_l800;o0P02o`@00_l200;o1002o`800_l400;o0P02o`<0
0_l200;o1`02o`800_l400;o0P02o`<00_l400;o0P02o`@00_l200;oY0000d`000040003C00000@0
00=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o00002@09o`L01ol400;o0`02o`<00_l200;o
0P03o`800ol200;o1002o`H00_l200?o0`03o`800ol700;o0P03o`<00_l200?o0P03o`800_l400;o
0P02o`@00_l00`3oo`0700;o0P02o`@00_l200;o0`03o`800ol200;o1002o`800_nT0003C00000@0
00=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0000900Wo1P03o`P0
1?l200;o0`02o`800_l300Ko0`08o`D01?l200Oo0`05o`D00_l200So0P07o`<00_l400;o00<0ool0
0_l300;o00<0ool01`02o`800_l400;o00<0ool00_l200Oo0`02o`@00_l00`3oo`02oj<000=<0000
10000d`000040003C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`0000T02Ol600;o1P02o`03
0?oo00;o0P02o`<00_l200;o1004o`H01?l700Co0`05o`@00_l00`3oo`0500;o0P02o`030?oo00;o
0`02o`040?ooo`@00_l400;o00<0ool00_l300;o00@0oooo1@03o`800_l400;o00<0ool00_l200;o
00@0oooo1002o`@00_l00`3oo`02oj<000=<000010000d`000040003C000008000?onM<00]<01OWC
dm?i00?C00?idol00Ol00003o`0001P00ol400?o0P02o``00_lJ00;o5`02ob000_l500;o00@0oooo
0`03o`d00_lG00;oY0000d`000040003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`00
00?o00006@08o`<00_l<00;o6P03oaH00_lP00;o1@02o`801ol>00;o5`02oj@000=<000010000d`0
00040003C000008000?onM<00]<01OWCdm?i00?C00?idol00Ol00003o`0001X01_lB00;o6`02oaH0
0_lW00;o0`05ol/014`60003C00000@000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000
o`1Y0003C00000@000=<000010000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o06D01D`200E<1P000d`000020004om?Cn@?C00Gidm?Cn@03d`;o00000ol0003o07L000=<0000
0P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003C000008000Codm?i0m<01OWC
dm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?Cn@03d`03nM?o007o00000ol0
003o07L000=<00000P001?oCdoT3d`05nM?CdoT00m<2o`0000?o0000o`1g0003C000008000?onM<0
0]<01OWCdm?i00?C00?idol00Ol00003o`000?l0M`000d`000020004om?Cn@?C00Gidm?Cn@03d`;o
00000ol0003o07L000=<00000P000ooid`02d`05nM?CdoT00m<00oWCo`01o`0000?o0000o`1g0003
C000008000Codm?i0m<01OWCdm?i00?C0_l00003o`000?l0M`000d`000020003ooWC00;C00Gidm?C
n@03d`03nM?o007o00000ol0003o07L000=<00000P0Ao`0000?o0000o`1g0003C000008000?onOT0
3?T2o`0000?o0000o`1g0003C000008000?o0=<02m<1n@7o0Ol00003o`000?l0I@05C0H000=<0000
10000d`000020003o`3C00;C1NP4d`7i0Ol1o`0000?o0000o`1Y0003C00000<00T`60003C0000080
00?o0=<00]<01NPG5aOX00CC0OT1o`7o00000ol0000Y00?oG003omd000=<00000P03C0H000=<0000
0P000ol0d`02d`05j1LG5nP01=<1n@7o0Ol00003o`0002T01?mK00Cog00014`00004C0H000=<0000
0P000ol0d`02d`05j1LG5nP01=<1n@7o0Ol00003o`0002`00_mM00;of`000d`00005C0H000=<0000
0P000ol0j003j0<G1>P00m?io`01o`0000?o00002@09o`P01_l400?o1003o`@00_l400Co1@06o`L0
0_l400Go1002o`P02?l600Go1P03o`030?oo00@00ol:00;o1P04o`@00_l300;o0P03okD000=<0000
10000d`000040003C000008000Co0=?X1aL01>SCdoT2o`0000?o00002@09o`L02?l300?o1003o`@0
0_l300Ko0`08o`H00_l300Oo0`02o`P02Ol400Oo1007o`@00ol:00;o1@06o`<00ol0103oool200?o
]@000d`000040003C00000@000=<00000P001Ol0dm?X00DG00GXdm?Cn@02o`0000?o00002@09o`H0
0ol400?o0P02o`@00_l00`3oo`0300;o0P03o`<00_l200;o1002o`H00_l200?o0`03o`800_l800;o
1P02o`800ol300?o0P03o`800ol300;o00<0ool02@02o`@00ol300;o0`02o`030?oo00<00_nf0003
C00000@000=<000010000d`000020003o`3C00;C00GX5aLGj004d`7i0Ol1o`0000?o00002@09o`H0
0_l600;o0P02o`@00_l00`3oo`0300;o0P02o``01?l600;o0P02o`D00_l200;o2002o`H00_l200;o
1@02o`800_l400;o0`02o`030?oo00T00_l400;o2P03o`@00_nf0003C00000@000=<000010000d`0
00020003o`3C00?C00?X5nP01M<1n@7o0Ol00003o`0000T02Ol=00?o0P02o`@00_l00`3oo`0300;o
0P08o`<01_l700;o0P02o`D00_l200;o2002o`H00_l200;o1@02o`800_l400;o0`02o`030?oo00T0
0_l400So1003o`@00_nf0003C00000@000=<000010000d`000020003o`3C00CC00?Xdm<01=<1n@7o
0Ol00003o`0000T02Ol800Oo0`02o`@00_l00`3oo`0300;o0P02o`@00_l200Co2P02o`800_l500;o
0P02o`P02Ol300;o1@02o`800_l400;o0`02o`030?oo00T00_l400;o1002o`@00ol400;o]P000d`0
00040003C00000@000=<00000P000ol0d`0;d`7i0Ol1o`0000?o00002@09o`L01ol400;o0`02o`<0
0_l200;o0P03o`800ol200;o1002o`H00_l200?o0`03o`800ol700Wo0`03o`<00ol200?o0P03o`80
0_l300;o2002o`@00ol200?o0`02o`030?oo00<00_nf0003C00000@000=<000010000d`000020003
o`0000/00OT1o`7o003ooi3o00000olG5`3o5h/G0_l00003oaSK06gK1?oofaWK0AL1o`7o00000olH
f`1/f`04om_Kf`;oom/Hf`4G0Ol1o`0000?o6?T01OT00m_X60096003foWi04Ci6=/2okgKAoT00m_X
60096003foWi00Ci0AL1o`7o00000olHf`06f`03j1SX00OX00<Hfm/0CM/3o`GK0_l3f`Go0]/2o`?K
1?l7f`Go1=/4o`CK0_l3f`;o0]/2o`;K0_l2f`;o1=/2o`;K0_l3f`Co0m/2o`;K0_l3f`?o2=/2o`CK
1?l3f`;o2M/4o`?K0_l2f`;o1=/2o`;K0_l4f`;o0]/2o`?K1?l4f`Go2m/2oe7K00?X6>P01nP00aSK
f`05f`4G0Ol1o`0000?o6?T01OT00m_X6007_P03j1SK04Ki1m/00ooKf`02o`?K0_l3f`;o0]/2o`;K
0_l2f`;o0m/00ooKf`04f`;o0]/2o`;K0_l3f`04om_Kf`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o
0]/2o`;K0_l2f`;o0]/2o`;K00?ofm/00_l7f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K
0_l3f`;o0m/2o`?K0_l2f`;o0m/00ooKf`02o`;K0_l;f`;o2M]7n@03fnPH00Nn00?X6=/01_T15`7o
0Ol00003oaSK00KK00?X6;h01[h00nPHf`1@f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l:f`;o0]/2o`;K
0_l7f`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`CK0ol7f`;o0m/2o`;K
0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`;o1]/2o`;K0_l;f`;oDM/00nPH
_P06_P03j1SK00KK0AL1o`7o00000olHn@05n@03fnPH00Nn00?X6=/0A_T9f`?o0m/2o`?K0_l2f`;o
0]/2o`;K1_l6f`;o0]/2o`;K1_l3f`;o0m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o
0]/2o`?K0ol8f`;o0m/2o`;K0_l2f`;o2=/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`Ko
0]/2o`;K0_l;f`;o2M]7n@03fnPH00GX0[h00nPHf`06n@4G0Ol1o`0000?o6=/01]/00nPH_P06_P03
j1SK04kK0ol4f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l6f`;o0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o0]/2o`;K0_l2f`?o2M/2o`?K0_l2f`;o0]/2o`SK0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`;K1Ol4f`;oDM/00nPH_P03_P05
j;jnj1P01m/15`7o0Ol00003oaSi00Gi00?Kj1P01kh00nPHf`16n@OK0ol5f`;o0m/2o`;K0_l2f`;o
0]/2o`;K0_l6f`;o0]/2o`;K0_l2f`;o0m/2o`?K0_l2f`;o0]/2o`;K0_l3f`;o0m/2o`;K0_l2f`;o
0]/2o`;K0_l2f`;o0]/00ooKf`05f`;o0m/2o`;K0_l2f`?o1m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o
0m/2o`?K0_l2f`;o0]/2o`;K0_l2f`;o2m/2o`WKAoT00m_X6004_P06j;jnj1SK1_T15`7o0Ol00003
oaSK00KK00?X6;h01[h00nPHf`1=f`;o1M/4o`;K0_l2f`;o0]/2o`?K1?l7f`;o0]/2o`?K1?l3f`Co
0]/2o`;K1Ol3f`;o0]/4o`;K0_l3f`Co0m/5o`CK0ol7f`Co0m/4o`?K0_l00m_oo`05f`;o0]/2o`;K
1Ol3f`Co0]/2o`;K1?l2f`;o0m/4o`CK1Ol;f`;oDM/00nPH_P03_P05j;jnj1P01m/15`7o0Ol00003
oaSi00Gi00?Kj1P01kh00nPHf`16n@OK0_l2f`04om_Kf`;o2m/2o`kK0_l2f`;o2m/2oaCK0_lSf`;o
5M/2o`;K0_l;f`;o2=/2o`?K0_l>f`;o2]/3o`WKAoT00m_X6004_P06j;jnj1SK1_T15`7o0Ol00003
oaSK00KK00?X61P021Q?f`?o1=/2o`_K0_l>f`Go3M/3o`03fooo00[K0_l3f`;o0m/2oaoK0olCf`;o
0]/2o`_K0_l3f`;o0m/2o`?K0_l>f`;o2m/2oe7K00?X61P021P7f`4G0Ol1o`0000?o6?T01OT00m_X
j009j003foWi04Ciem]7n@03fnSX00WX00?KnOT01?T15`7o0Ol00003oaSK0?oKR]/15`7o0Ol00003
oaSK0?oKR]/15`7o0Ol00003oaPH0?lHRQP15`7o0Ol00?ooSol10P00\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  ImageSize->{399, 193},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
When we close the style sheet window, all existing and new input \
cells in the notebook will have italic text.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006d0000=`P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000003o`000?l0X@000ooKf`0<f`;o00000ol0
003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003om_K00cK0_l00003o`000?l0X@000ooKf`0<f`;o
00000ol0003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003om_K00cK0_l00003o`000?l0X@000ooK
f`0<f`;o00000ol0003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003om_K00cK0_l00003o`000?l0
X@000ooKf`0<f`;o00000ol0003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003om_K00cK0_l00003
o`000?l0X@000ooKf`0<f`;o00000ol0003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003om_K00cK
0_l00003o`000?l0V005C0@000?ofm/03=/2o`0000?o0000T0000ol0003o00T000=<00000P000ooK
f`0<f`;o00000ol0002@0003o`000?l02@000d`000020003om_K00cK0_l00003o`0002l01?l500Co
0`04o`<01_l200Ko4@06o`801_l300Co1@04o`<01?l60003o`000?l02@000d`000020003om_K00cK
0_l00003o`0002h00_l200;o1@02o`<00_l200;o0P02o`800_l400;o5@02o`@00_l200;o0P02o`80
0_l500;o0`02o`800_l50003o`000?l02@000d`000020003om_K00cK0_l00003o`0003<00_l500;o
1`02o`<00_l700;o1`05o`T00_l500;o2@02o`D00_l700;o10000ol0003o00T000=<00000P000ooK
f`0<f`;o00000ol0000_00;o0P02o`801_l600;o1002o`H00_lE00;o1P02o`P00_l200Ko0P02o`80
0_l40003o`000?l02@000d`000020003ooWi00ci0_l00003o`0003001Ol300;o00<0ool01@03o`H0
0_l500;o5@02o`L00_l500?o0`02o`030?oo00<01Ol40003o`000?l02@000d`000020003om_K00cK
0_l00003o`0003000_l700Co1`02o`H00_l200Co4`04o`P00_l600;o0`04o`<00_l70003o`000?l0
2@000d`000020003om_K00cK0_l00003o`0003400_l800?o0`02o`800_l200;o0P02o`<00olD00?o
1002o`800_l200;o0P02o`@00ol300;o1P000ol0003o00P00T`40003om_K00;K1_T4f`;o00000ol0
000a00Ko1@02o`@01?l400Co1@02oaD00_l500Co1004o`H00_l300Ko0P000ol0003o00L000=<04`0
10000ooKf`02f`03nM_K00;K00?ifm/00]/2o`0000?o0000T0000ol0003o00H000A<001<10000ooK
f`02f`03nM_K00;K00?ifm/00]/2o`0000?o0000T0000ol0003o00D000E<0000C0040003om_K00;K
00?ifm/00]/00oWKf`02f`;o00000ol0003o09L01T`40003om_i00?i1=/4n@7K0Ol1o`0000?o0000
o`2Q0004om_Kn@SK00?ifm/00_l00003o`000?l0X@001OoKfm_i00KK00Cifm_K0_l00003o`000?l0
X@000ooKf`02f`03nM_K00;K00?ifm/00]/2o`0000?o0000o`2Q0003om_K00?K00Cifm_i1M/2o`00
00?o0000o`2Q0003om_K00CK0_T6f`;o00000ol0003o0:4000?ofm/03=/2o`0000?o0000o`2Q0003
om_K00cK0_l00?oo]Ol00003oaLG0?lG/1L2o`0000?o6=/0om^_f`4G0Ol1o`0000?o6=/0om^_f`4G
0Ol1o`0000?o6?T01OT00m_X60096003foWi09_iCm^Mn@03fnPH00TH00?KnOT01?T15`7o0Ol00003
oaSK00KK00?X6>P01nP00aSKf`2Tf`Co0m/2o`;K0_l4f`;o0]/2o`CK0_l2f`;o0m/4o`CK1Ol;f`;o
Ym/00nPHj007j0036=_K00GK0AL1o`7o00000olHn@05n@03fnPH00Nn00?X6=/0WOT7f`;o0]/2o`;K
0_l2f`;o0m/2o`?K0_l3f`;o0m/2o`;K0_l3f`03om_K00;o0]/2o`_K0_l9figi00?Kj1P01kh00nPH
f`06n@4G0Ol1o`0000?o6=/01]/00nPH_P06_P03j1SK0:CK0_l2f`;o0]/2o`;K0_l3f`;o0m/2o`?K
0_l3f`;o0]/2o`KK0_l2f`;o2m/2ojOK00?X6;h01[h00nPHf`06f`4G0Ol1o`0000?o6?T01OT00m_X
6007_P03j1SK09gi1m/2o`;K0_l2f`;o0]/2o`?K0_l3f`;o0m/2o`?K0_l2f`Ko0]/2o`;K0_l;f`;o
2M^Mn@03fnPH00GX0[h00nPHf`06n@4G0Ol1o`0000?o6=/01]/00nPH_P06_P03j1SK0:CK0_l2f`;o
0]/2o`;K0_l3f`;o0m/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`;K1Ol4f`;oYm/00nPH_P03_P05
j;jnj1P01m/15`7o0Ol00003oaSi00Gi00?Kj1P01kh00nPHf`2Mn@OK0_l2f`;o0]/2o`;K0_l3f`;o
0m/2o`?K0_l3f`;o0]/2o`;K0_l2f`;o0]/2o`_K0_l9figi00?Kj1P01;h01^Rn_^PHf`Ki0AL1o`7o
00000olHf`06f`03j1Rn00Jn00?X6=/0Y=/2o`;K0_l2f`Go0m/4o`;K0_l2f`Co0]/2o`?K1?l4f`Go
2m/2ojOK00?X6;h00kh01NRn_^PH00OK0AL1o`7o00000olHn@05n@03fnPH00Nn00?X6=/0WOT7f`;o
0]/2o`_K0_l8f`;o0m/2o`kK0_l:f`?o2M^Mn@03fnPH00Bn00KX_[kX6=/6n@4G0Ol1o`0000?o6=/0
1]/00nPH60086:GK0_l2f`;o2m/2o`?K0_l3f`;o0m/2o`kK0_l;f`;oYm/00nPH600860OK0AL1o`7o
00000olHn@05n@03fnSX00WX00?KnOT0VoU?figi00?Kj>P02NP00m_in@04n@4G0Ol1o`0000?o6=/0
om^_f`4G0Ol1o`0000?o6=/0om^_f`4G0Ol1o`0000?o61P0oaR_604G0Ol1o`00ooneo`00\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  ImageSize->{436, 55},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Most versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " come with several style sheets, and we choose a predefined style sheet by \
pulling down the Format menu and choosing the desired style sheet from the \
Style Sheet submenu."
}], "Text"],

Cell[TextData[{
  "The appearance of a notebook can be further be changed by switching to a \
different ",
  StyleBox["style environment",
    FontSlant->"Italic"],
  ". Typical style environments are Working and Presentation; documents \
viewed in the Presentation environment typically use larger font sizes than \
documents in the Working environment. There is also a Printout environment \
which uses smaller fonts than the Working environment, and uses styles that \
look better on the printed page."
}], "Text"],

Cell["\<\
Here is part of a notebook in the Working environment, in which \
text in cells typically wraps around at the window width, and uses fonts \
large enough to be viewed comfortably on the screen.\
\>", "Text"],

Cell[GraphicsData["PICT", "\<\
K@00@@1A0HL1h00A0_l<0?ooool0D@000440007P0001Q`000000000100X0@@1A
0HL1h02HPI00@@1A0HL1h0000000000004P0001800000008004020000001dgKL
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000@@1A
0HL1h0110541Q`7P00002X7oPOn1oo;o00003P3oP@J11X46m@H2E?l000l1o`J1
mH7ePOGfm@9Do`003`7o1X7ePOF1mOKe0UCo000O0Ol6noX0mOJ/0?FOnX7ehOFN
nP3emZ`0mO_j0UCo00110Ol6n_D0[?L6U_Gnooke0OoojOD1ooo`m@7ooo_e0Ooo
o?GkooOe0Oool?D1ooo_m@7ooh7e0OF/m`Kjm@9Do`00B@7o1__j0_F/1_[h0Z`6
mIojn_D4oooemOoBm@7ooo;e0OoomOD1ooo`m@7oonoe0Oooi?FNnP;e[0Kmn0F/
n?R/1_GknP9Do`00R07o1_[e0J`6n_P1[0JGm@7oooce0Oooo_Gmooke1OoomOoo
mOcoo_D3oooemOcooOGnooke2OoomOGoooGeooojm@7ooogeoOonmOgo2?Geoooe
oooemOgoo_GloogeoOommOco2?GeoooeoooemOgoo_GloiGe0J`6oOP4[?Sh[0Kj
m@9Do`00/P7o1__j0_F/1_[h0Z`6mIojn_Gnooge2ooomOGoooGeoooemOkoo_DO
oooemOoomOGoooGeoooemOoomOGoooGeooGeoooeooonm@7ooo[e0Oooo_D5oooe
mOooo_D1ooonmOkoo_D0ooke6ooomOGoooGeoooemOoomOGoooGeoooemOoomOGn
ooke3OoomOGoooGeoooemOoon_FNnP;e[0Kmn0F/n?R/1_GknP9Do`00X@7o1_[e
0J`6n_P1[0JFmOkoo_D=oooemOoomOGoooGeooommA?oooGeoooemOoomOGoooGe
oooemOkooOGmooge0Ooon_D1ooonm@GoooGeooonm@7oooke0Oooo?Gloa_emOoo
mOGoooGeoooemOoomOGoooGeoooemOoooOD=oooemOoomOGoooGeoonFm@6/1_gh
1:chn:`6n_D2E?l00:41o`KknP;e[0Kjn0:/1_FOn_Seo_l5mOGoooGenol3mOGo
ooge4OoomOGoooGeoooemOoomOGoookeo_onmOkoo?D1ooojm@7oookenoonm@7o
ooke0OoooOD?oooemOoomOGoooGeoooemO_o2oGeoooemOoomOGoooge3OoomOGo
ooGeoooemOoon_FNnP;e[0Kl[0Chn:`6mO_j0UCo002I0Ol6n_D1[0Kjn06/1YCe
2OoomOGoooGeoookm@7oooge4OoomOGoooGeoooemOoomOGooogeo_l1mOGmooge
0Ooon_D1ooonm@7ooo[e0Oooo_D1ooommA7oooGeoooemOoomOGoooGeoookm@Wo
ooGeoooemOoooOD=oooemOoomOGoooGeoonFm@6/1_[h0J`6n_D2E?l00;<1o`Kk
nP;e[0Kjn0:/1_FOn_[e3?oemOoomOGoooGeooonm@ComOGoooge7ooomOGoooGe
oooemOoomOGoooGeooGeoooemOoomOooo_D1ooojm@7oooke0Oooo_D0ooke0Ooo
o_D1ooommA7oooGeoooemOoomOGoooGeooonm@comOGoooGeoooemOoooOD=oooe
mOoomOGoooGeooojmIkj0_F/1_[h0Z`6mO_j0UCo00280Ol6n_D1[0Ki[006U_Gn
ooke0Oooo_Gmooke0OoooOGlooke2OoomOGoooGeooonmOkoo_D9oooemOoomOGo
oo[e0OoooOGmooce1OoomOGoooceo?l7mOGoooGeooonmOgooOGlo`?emOooo?Gm
ooke1OoomOGooiKe0J`6nJ`01_[e0UCo000T0Ol6noX1mJcg1P3eWo[Qm@7ooh?e
W_X1mJcg1P3enoX2E?l00181o`J1mNce0OooPOF=m@9Do`003`7o1X7ePOF1mOKe
0UCo000=0?n1E85DPECdE07o000:POn1oh7ol_l0000@0?n10840P`00oo@00_[o
000A0?n10840P`01o`3emP;jo`005@3oP@2108<00Ol0o?H0[?_f0_[o000G0?n1
0840P`01o`3mmP:/E:clmP;jo`008P3oP@2109<0o=81003ld_d00Ol0o_H0[?iD
0:cmmP;jo`00803oP@2108l00=;k003Bo@04o`3fmZclE02/o_H2n_l001h0oh40
P@2B0?gBn`00d_d00ol0mZcjE0F/m_Kjo`008P3oZ@3ioh40P@3_003Bn`00d_d0
0Ol0oJcnE?f/0oKjo`00>@3onP3/ooh0o?o?0?Gon03lol@0o?oC0?col@3lohT0
0=;k003Bo@01o`3nmP2/oU@0[?gf0_[o000i0?oj0>cooP3lom40l_oi0?coa03l
om<0o?oa0?coR@00d_/00=;m007o0?kf0:cnE02/oOH2n_l003T0ooX0k?on0?co
dP3`ooX0o?o40?cod`3loo40o?n9003Bn`00d_d00Ol0o_H0[?iD0:cmmP;jo`00
>@3onP3/ooh0o?oB0?_oo03joo/0o?o40?cod`3loo40o?n9003Bn`00d_d00Ol0
o_Kl[?gf0_[o000[0?ob0?comP3lom<0nooi0?_oQ`3loh40m000d_/00=;m007o
0?Gf0_[o000Y0?ob0?comP3lom<0o?og0?coQ`3loh40m000d_/00=;m003oloX1
o`00G03olP3looH0o?on0?com03jonl0o?og0?coo03looP0n_oi0?cooP3nood0
o?on0?_on@3loo`0o?on0?com@3iooT0o?ok0?coo03lohT00=;k003Bo@3ao`00
05`0oo80o?of0?co003hooP0m_oa0?cok@3looX0m_ok0?co0@00oOom0?co003g
oo/0o?ol0?co003hooT0mOok0?con`3moo/0o?n9003Bn`00d_d00?ocn`7o001@
0?ob0?comP3aooX0m?ob0?_okP3loo/0m?ol0?co003lood0l?ol0?coo03aoo/0
lool0?coo03loo/0o?n9003Bn`00d_d00?od1P:/o`00C@3olP3looH0lOok0?;o
l`3goo80o?ol0?;oo@3food0l?ol0?coo03`ood0lOom0?coo@3looX0o?n9003B
n`00d_d00Ol6mOP2[?l006T0oo80o?of0?[oo@3kood0nool0?_ol`3eooD0o?om
0?_oo03kooh0m_om0?[oo03kood0o?ol0?[oo@3kooh0nool0?_oo@3looh0o?oi
0?coR@00d_/00=;m007o1_khneCnn0:/o`00JP3olP3looH0nook0?coo@3looX0
o?oc0?7on@3lood0o?oj0?cooP3jooT0nooj0?coo@3loo`0nook0?cooP3looX0
noon0?co0@00o?oh0?coR@00d_/00=;m007o1_khn`Knn0:/o`00J`3olP3looH0
o?oj0?cooP3looP0o?ob0?7on`3looh0o?oh0?co0@00nooh0?_onP3kooh0o?ol
0?conP3looh0o?oi0?cooP3lo`400?gom`3lohT00=;k003Bo@01o`Knn?^0o_P2
[?l006H0oo80o?of0?conP3looh0o?oh0?col@3aoo`0o?on0?con03lo`400?co
m`3looP0o?on0?coo03looX0o?on0?[ol`3lo`00oOof0?coR@00d_/00=;m007o
1_khn`Knn0:/o`00FP3olP3looH0o?oj0?cooP3^onh0m?ol0?cooP3^o`400?co
m`3looP0o?on0?coo03looX0o?on0?Gon03fooL0o?n9003Bn`00d_d00Ol6o_Sk
P?kh0Zco001J0?ob0?comP3looX0o?on0>kojP3good0o?on0>ko0@00o?og0?co
n03looh0o?ol0?conP3lood0look0?Kom`3lohT00=;k003Bo@01o`Knn?/6o_P2
[?l005X0oo80o?of0?conP3looh0k_oW0?[oo@3looh0k_l1003looL0o?oh0?co
oP3loo`0o?oj0?con`3cood0mOoh0?coR@00d_/00=;m007o1_khnh3nn0:/o`00
F@3olP3looH0o?oj0?cooP3lomL0o?om0?cooP3loo40o?og0?con03looh0o?ol
0?conP3looP0m_om0?Gon03lohT00=;k003Bo@01o`Knn?/6o_P2[?l00640oo80
o?of0?conP3looh0o?oW0?comP3lood0o?on0?col@3looL0o?oh0?cooP3loo`0
o?oj0?col`3jooh0nol00?_on@3lohT00=;k003Bo@01o`Knn?^0o_P2[?l006D0
oo80o?of0?conP3looh0nooX0?comP3lood0o?on0?_olP3looL0nooj0?_ooP3l
oo`0o?oj0?cooP3looT0o?on0?cooP3kooX0o?n9003Bn`00d_d00Ol6o_Sk1_kh
0Zco001Z0?ob0?comP3looX0o?om0?conP3kooD0nooh0?_oo@3lood0o?oj0?_o
0@00o?og0?_onP3lood0o?ol0?conP3looh0o?oi0?cooP3looh0nooj0?coR@00
d_/00=;m007o1_Gh0Zco001Y0?ob0?comP3looX0o?om0?[oo@3koo<0n_ok0?_o
o03lood0n_om0?_ooP3looL0n_om0?[oo@3loo`0o?oj0?cooP3joo`0noon0?co
o@3koo/0o?n9003Bn`00d_d00Ol6mOP2[?l005<0oo80o?of0?conP3loo`0lOoc
0>oon`3loo`0lOon0?com`3`oo`0o?ol0?conP3lood0lOom0?coo@3koo/0o?n9
003Bn`00d_d00?oc[07o001N0?ob0?comP3looX0o?ok0??ol@3aooX0o?ok0??o
o@3looL0l?ol0?coo03looX0o?ol0?;oo@3loo`0nool0?coR@00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Ko001R0?ob0?comP3looX0o?oj0?GokP3dooT0o?oj0?Go
o03looL0o?l00?SonP3loo`0o?oj0?con`3eoo/0o?ol0?_oo03lohT00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jo`00HP3olP3looH0o?oj0?con03jonT0n?og0?co
n03jooT0o?og0?cooP3looP0o?ol0?conP3looT0nOoi0?con`3kood0o?n9003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_l002H0oh40jP3loh40Z`00d_/00=;m00;o
m_[nmP3jo_H0n_kf0_[o000V0?n10>X0o?n10:/00=;k003Bo@00ookf0?[nmP3j
o_H4n_Kfo`009P3oP@3Z0?coP@2[003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l0
02H0oh40jP3loh40Z`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000V0?n10>X0
o?n10:/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@3Z0?coP@2[003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_l002H0oh40jP3loh40Z`00d_/00=;m00;o
m_[nmP3jo_H0n_kf0_[o000V0?n10>X0o?n10:/00=;k003Bo@00ookf0?[nmP3j
o_H4n_Kfo`008P3oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`008P3o
P@2108l00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`008P3oP@2108l00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jo`008P3oP@2108l00=;k003Bo@00ookf0?[nmP3j
o_H4n_Kfo`008P3oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00;03o
nP3/ok`0o?o?0?coP@2/003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l00300ooX0
k?oZ0?cof03loll0o?n10:`00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00<03o
nP3/onX0o?oH0?coc`3loh40[000d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000`
0?oj0>cojP3lomP0o?o?0?coP@2/003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l0
0300oo80o?oR0?cof03loll0o?n10:`00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
o`00<03olP3lon80o?oH0?coc`3loh40[000d_/00=;m00;om_[nmP3jo_H0n_kf
0_[o001P0?ob0?colP3joo/0m_on0?cooP3nooX0nOoh0?cooP3loo@0n_oc0?co
oP3looh0o?on0?kon@3iooL0o?on0?coP@3Q003Bn`00d_d00?onmP3jo_H0n_kf
1?[fm_l00680oo80o?od0?Koo@3fooh0o?l1003moo`0mOoj0?co003hooP0m_og
0?So003looh0o?l1003moo/0mOoi0?co003hoh40h`00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[o001D0?ob0?com@3dooh0m_on0?co003lood0look0?7onP3dooT0
lOon0?co003loo`0looj0?7oP@3T003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l0
04d0oo80o?of0?;o0@00m_on0?KooP3aoo`0lOok0?;on`3`ooh0m_om0?7on`3`
oh40i@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001Y0?ob0?com`3koo`0noom
0?con`3fo`400?_oo03koo`0n_om0?_oo@3koo`0noom0?_oo03jooh0m_on0?[o
o@3joo`0n_om0?_oP@3U003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l006P0oo80
o?og0?conP3lood0o?ok0?[on`3looX0o?ol0?_on`3lood0o?oj0?coo@3looX0
noon0?[onP3looT0o?ol0?_on`3loh40i@00d_/00=;m00;om_[nmP3jo_H0n_kf
0_[o001Y0?ob0?con03looP0o?on0?con`3kooX0o?oj0?coo03looX0o?on0?co
n03lo`400?_onP3kooh0nooi0?con@3loo`0o?oj0?coP@3U003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_l006D0oo80o?oh0?con03looh0o?ok0?cokP3koo`0o?oj
0?cooP3looP0o?l1003looP0o?on0?con@3looL0o?om0?conP3loh40i@00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o001M0?ob0?con03^ooh0o?ok0?com03eoo`0
o?oj0?cooP3^o`400?con03looh0o?oi0?com`3lood0o?oj0?coP@3U003Bn`00
d_d00?onmP3jo_H0n_kf1?[fm_l005d0oo80o?oh0>kooP3loo/0o?of0??oo03l
ooX0o?on0>ko0@00o?oh0?cooP3looT0o?og0?coo@3looX0o?n10>D00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jo`00G@3olP3looP0k_on0?con`3looP0lOol0?co
nP3looh0k_l1003looP0o?on0?con@3looL0o?om0?conP3loh40i@00d_/00=;m
003oo_H0n_kf0?[nmPCjm_Ko001P0?ob0?con03loo00o?ok0?con03koo`0o?ol
0?conP3looh0o?oa0?con03looh0o?oi0?com`3lood0o?oj0?coP@3U003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_l00600oo80o?oh0?col03loo/0o?oi0?conP3l
oo`0o?oj0?cooP3loo40o?oh0?cooP3looT0o?og0?coo@3looX0o?n10>D00=;k
003Bo@00ookf0?[nmP3jo_H4n_Kfo`00H03olP3looP0nooa0?con`3looT0o?oj
0?coo03looX0o?on0?_olP3kooX0noon0?con03looT0o?ol0?conP3loh40i@00
d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001X0?ob0?com`3looX0noon0?con`3l
ooT0o?ok0?_oo03looX0o?om0?conP3kooh0o?oj0?_ooP3looP0o?oi0?coo03l
ooX0o?n10>D00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00J03olP3looL0n_om
0?_oo@3loo/0o?oi0?_oo@3joo`0o?oj0?coo@3jood0noom0?_oo03jooh0o?oh
0?[oo@3joo`0o?oj0?coP@3U003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l005@0
oo80o?of0?7oo@3iooh0o?oi0?3oo03looX0o?ol0?7oo03`ooh0o?og0?7on`3l
ooX0o?n10>D00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00E03olP3looD0lool
0?WooP3looP0lOol0?conP3loo/0looj0?7ooP3looH0looj0?conP3loh40i@00
d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001M0?ob0?com03eooX0n_on0?com`3i
o`400?coo03looX0o?oj0?Gon03ho`00o?on0?com@3eooT0o?oj0?coP@3U003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_l005`0oo80o?ob0?[omP3kooh0o?of0?_o
oP3kood0o?oj0?con03joo@0noon0?cooP3loo<0nOog0?conP3loh40i@00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o000R0?n10840S`00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko000R0?n10840S`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000R
0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000R0?n10840S`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o000R0?n10840S`00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko000R0?n10840S`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000R
0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000R0?n10840S`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o000R0?n10840T`3ld_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko000N0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40
P@28003Bo@00ookf0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3j
o_H0n_kf0_[o000N0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf
0?[nmPCjm_Ko000N0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40
P@28003Bo@00ookf0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3j
o_H0n_kf0_[o000N0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf
0?[nmPCjm_Ko000N0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40
P@28003Bo@00ookf0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3j
o_H0n_kf0_[o000N0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf
0?[nmPCjm_Ko000N0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40
P@28003Bo@00ookf0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3j
o_H0n_kf0_[o000N0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf
0?[nmPCjm_Ko000N0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40
P@28003Bo@00ookf0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3j
o_H0n_kf0_[o000N0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf
0?[nmPCjm_Ko000W0?n10840VP3ldP400?cBn`00d_d00_ofn_kf0?[nmP3jo_H2
n_l002H0oh40P@2F003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000b0?oZ
0?Won`3nomL0o_n10840kP3md_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00
=P3oj@3nooh0o_om0?koe`3noh40P@3[003Bn`00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Ko000j0?ok0?KonP3nood0o_on0?koe`3noh40P@3[003Bn`00d_/00=;m
00;om_[nmP3jo_H0n_kf0_[o000g0?ok003on?X0ooX0o_ol007ooh40P@2h003B
n`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001U0?ok003on?X0ooX0o_ol0?ko
003mo`400?cooP3lo`00oOl00?gooP3lo`400?co003mooh0oOon0?ko0@00o_n1
0840o@00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00M@3on`00ooSj0?oj
0?koo03no`400?ko203oo`00ool00?ko103oo`00o_l1003noa000?oo003oo`3o
o`00ool00?ko1`00ool00?oooP3ioh40P@3n003Bn`00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko001k0?ok003on?X0ooX0o_ol0?ko0@00o_l00?ko0`00o`3no`D0
0?oo003no`400?ko0@00o_l3003o0?ko1000o`00o_l00?ko0@00o_l1003no`40
0?koP@210?h00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l006`0oo/00?oh
nP3onP3noo`0o_l1003no`00oOon0?kon`3no`400?ko0@00oOon0?goo@3no`00
o_l1003no`400?ko0@00o_n10840oP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4
n_Kfo`00K@3on`00ooSj0?oj0?koo03no`400?ko0@00oOl1003noo/0o_l1003n
ooh0oOon0?gooP3no`00o_l1003no`400?ko0@00o_n10840oP00d_/00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jo`00K03on`00ooSj0?oj0?koo001ooon0?kooP3m
o`00o_ok0?ko0@00o_om0?gooP3mo`400?ko003no`400?ko0@00o_l1003noh40
P@3n003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001e0?ok003on?X0ooX0
o_om0?kooP3no`<0o`00o_l00?kon`3no`400?ko1000o`00o_l30?l00?ko0@00
o_l00?ko0@00o_l1003no`400?koP@210?h00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_l007@0oo/00?ohnP3onP3nooh0o_om0?ko203oo`00ool00?ko103o
o`00nOl@003oo`00ool0ool00?oo003no`L00?oo003oooh0o_l1003noh40P@3n
003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001I0?ok0?Kon`3ioo`0moom
0?goo@3mo`00o_l00?co0@00o?l1003lo`400?gooP3lo`00oOn108400P00d_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@2109H00=;k003Bn`00d_d0
0?onmP3jo_H0n_kf1?[fm_l002H0oh40P@2F003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[o000V0?n10840UP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
o`009P3oP@2109H00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l002H0oh40
P@2J0?cBn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000R0?n10840S`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o000R0?n10840S`00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko000R0?n10840S`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000R
0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000R0?n10840S`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o000R0?n10840S`00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Ko000R0?n10840S`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000R
0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000V0?n10840VP3ld_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@2109H00=;k003Bn`00d_d0
0?onmP3jo_H0n_kf1?[fm_l007D0oo/0n?od0?ko103o003ol000ooD00Oooo000
onT00Ooom@01ooo/003omP01oooU007oooh00OoolP00on/00?o^007oolH00Ooo
k`01oooe003oj`3md_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00F`3on`08
o`00o`00o`3om@00ooh00Ooog`00on800?od003oh@00on800?om003oaP00olL0
0?o/003of`00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00JP3on000ood0
0?oe003oo@00oml00?og003onP00ooD00?od003oh@00on800?om003ol000oo40
0?o]003ooP00olL00?o/003of`00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;j
o`01D`3on000ood0o_on007ooo/00Oooo@09ool00?oo003o0?ko2`3oo`00ool0
o`3oooh0o_l8003o0?oo0?oooP3no`@00?oo0?ko1`3o0?oo0?oooP3nooh00Ooo
oP09ool0o`3o0?oo0?ko1@00o`3ooo`00ooo003nood0o_l1003no`<00?l0o_l5
0?oo0?ooo@01ooon00?oo`3oo@04o`3oo`3no`00o_on0?co3@00ool00?l0ool0
ool0o_l70?oo0?l0ooon0?gooP3no`400?kooP01ooom00_oo`3oo`00o`3oo`3n
ooh00OoooP01ooon0?ko0@00o_ol0?ko0@00o_om00co0?oo0?oo0?oo0?oooP04
o`00ooon00[oo`00ool0o`3oooh0oOod003Bn`00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Ko005T0?oh003oo@08o`00o`3o003on`3nooh08_l0o`00o`00ool0ool0
0?l00?l00?l00?l0o`00o`00o`3ooP00ood02?l00?l00?l0ooh07Ooo0?l00?l0
0?l00?l0o`00o`3o003oo`00ool0ooh01_l00?l00?ol00Go0?l00?ol00?o003o
oP0Io`00ool00?l00?l00?l00?l00?l0o`00ooom00Koo`00o`3ooP00oo`04ol0
o`00o`00o`00ool0o`00o`3ooP0;o`00o`00o`3o003oo000ooh02?l00?l0o`00
ood02_oo003o003oo`3ooP0Do`3o003o0?l00?l0o`00o`3o003oo@00ooh00ol0
0?ok02Ooo`3o003o0?oo003o003o0?l00?l0o`00o`00o`00o`00o`3o003ol`00
d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`01C03on000ood01?l00?l0oOoi
00Goo`00o`3mo`D00?l00?on00co003o003o003o0?ooo@01ooom003oo@02o`00
oOl10?on003ooP3no`H00?l00?l0oOl10?on00Ko003o003ooP06o`00o`00oo`0
0ol0oooj00?o003ooP03o`00ooh02?l00?l00?l00?go0@3ooP00ood00?on00Go
003o0?ok00Co0?l00?go0P00ooh0o_l10?on00_o003o003o0?l00?ol003ooP04
o`00o`3mood00?on00Ko003o003ooP02o`3oo@3mo`80ooon007ooo/00?on00?o
003on`02o`00oOl10?on00Go003o003no`40oo`02ol00?l00?l0o`00oo<00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l00E00ooP00?om00Go003o0?oj003o
o@05o`00o`3oo003o`00ooh02Ol00?l00?l00?on00Koo`00o`3ooP00ood00ol0
0?om003ooP0>o`00o`00o`00o`00o`3oo@00ooh01_l00?l00?on00Ko003o003o
o000ooh00Oooo003o`00ooh00ol00?on00Wo003o003o003oo@00ooh00?om003o
oP05o`00o`3on`05o`3o003oo008o`00o`00o`3ooP0:o`00o`00o`00oook003o
oP05o`00o`3onP00ooh01_l00?l00?on00;o0?om003on`01ooon007oood00?on
00?o003on`03o`00ood00?on00[o003o0?l00?l0oo`02_l00?l00?l00?oolP00
d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`01H03on000ood02?l00?l0o`00
ood0;_oo003oo`00o`3o003o003o003oo`00o`00o`00o`00o`3o003o003o003o
003oo@08o`00o`00o`3ooP0Mo`00o`00o`00o`00o`3o003o0?l00?oo003o003o
oP06o`00o`00oo`01Ol0o`00oo`00ol00?on00?o003ooP0Bo`00o`00o`00o`00
o`3o003oood00?on003ooP00ooX04ol0o`00o`00o`00o`00o`00o`3ooP08o`00
o`00o`3on@00ooh02?l00?l0o`00ood02_oo003o003o003ooP0Do`3o003o0?l0
0?l0o`00o`3o003oo@00ooh00ol00?ok02Co003o003o0?oo003o003o0?l00?l0
o`00o`00o`00o`00o`3ol000d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`01
A@3on@3no`400?ko1@3oo`3ooo`00Ol0o_l1003no`@0ool00?ko1P3o0?oo003k
o`00o?l1003no`00o?om00Co003oooh00Ol0o_l4003oo`3mo`D0ool0ooon00;o
o`3lo`400?ko0@00o_l20?oooP3koo`0o_l1003no`400?ko003no`T0ool0ool0
0?oooP04ool0ooom0?koo@00oo/0o_l70?l00?oo003no`P00?oo0?l0o`3ko`<0
ool0o_ok007o0?ko1@3oo`3ooo`01Ol0ool00?ko0@00o_on007oooh00ooo003n
o`400?kon`3no`400?koo@3no`/00?oo003o0?oo003no`T0ool0o`3oo`00nol3
0?oo0?kol`00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00A03od`00oh40
lP00omX00?on003ok000olD00?oV003ooP00oo@00=;k003Bn`00d_d00?onmP3j
o_H0n_kf1?[fm_l004H0om<00?n10?@00_l0omX00?on003ok000olD00?oV003o
oP00oo@00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l003d0om@0o_n10?D0
0Ooof03non`0o_o70?koiP3noo<00=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[f
m_l002H0oh40P@2F003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000V0?n1
0840UP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`009P3oP@2109H00=;k
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l007l0oml00Ooom@01oooS003oo@01
oooh007oomX01?oo0?ooh001oooe007ooo800?of003oo@01oooj007oooP00Ooo
oP01oook007oonX00?oi003om@01oooe007oomD00=;k003Bn`00d_d00?onmP3j
o_H0n_kf1?[fm_l00600omh00?od003og@00ooT00?oG00?o003og`00oo@00?oc
003ok`00ooT00?og00?o003on000om<00?od003oe@00d_/00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`00O03ol`00ooX00?oe003om000on400?on003on@00omL0
0ol00?od003onP00ooD00?od003ol`00oo<00?on003on@00ooL00ol00?ol003o
oP00om<00?od003oe@00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`01>P3o
nP01ooom0?ko1000ool0o_l70?l0ool0ooon0?kooP01ooon00Woo`3o0?l0ool0
o_l5003o0?ooo005ool0ool0nOl1003noo`0o_l1003no`/00?oo0?oo0?l0ooom
0?ko1`3o0?oo0?ooo@01ooon00oo003o003oo`00o`3oo`00o_l4003oo`3no`L0
o`3oo`3oooh0o_on007oooh02ooo0?l0o`3oo`3ooo`00?on00Goo`3oo`3io`40
0?kon`3nooh00OoooP01o`3nooh0o_l1003nooh00Ooon`3no`<00?l0oOl1003m
o`L0ool0o`3oooh00OoooP00oo`00OoooP05ool0o`00oOl3003ooml00=;k003B
n`00d_d00_ofn_kf0?[nmP3jo_H2n_l00EX0oo/00ol00?om00So003o003o0?on
01goo`3o003o003o003o0?l00?l0o`00ool00?oo0?on00Ko003o003oo002o`3o
oP05o`00o`3ooP03o`00oo`00ol00?on00[o003o003o003oood08Ol00?l00?l0
0?l00?l00?l00?l00?l00?l0o`00o`00ooom00So003o003o0?on023oo`3o003o
003o003o0?l00?l0o`00ool00?oo0?l00?om003oo@02o`3ooP05o`00o`3ooP03
o`00oo`03_l00?l0o`00o`00o`00oo`00?on00So003o0?l00?om003ooP0<o`00
ool00?l0o`00ooh03_l00?l00?l0o`00o`00ood05?l00?l0o`00ool0o`00o`00
o`00on000=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l00D80ooX0o_om00;o
003mo`40ooh00?on0?ko1P00o`00o`3mo`40ooh01_l00?l00?on00Ko003o003o
n`04o`3o0?on00;o0?on00?o003oo003o`00ooh02Ol00?l00?l00?ol007oood0
1_l00?l00?on0?ko1P00o`00o`3mo`800?ol00;o003mo`40ooh00?on0?ko1P00
o`00o`3mo`40ooh00ol00?on0?koo@00oo`01?l0o`3ooP02o`3ooP03o`00oo`0
1Ol00?l00?ko1@00o`00oo`00?on00Co003o0?goo@00ooh00ol00?on00Go0?l0
0?on00So003o003o003no`800?om0?go0@3ooP07o`3o003o003mon000=;k003B
n`00d_d00_ofn_kf0?[nmP3jo_H2n_l00DH0oo/00ol00?om00?o003oo@00ooh0
3_l00?l00?l00?l00?l0ood00?on00Ko003o003ooP06o`00o`00oo/01?l0o`3o
oP02o`3ooP03o`00oo`00ol00?on00Wo003o003o003onP0Hool00?l00?l00?l0
0?l00?l00?l00?l0oo`00?ol00?o003oo@00ooh03_l00?l00?l00?l00?l0ood0
0?on00Wo003o003o003oo@00oo`01?l0o`3ooP02o`3ooP03o`00oo`03_l00?l0
o`00o`00o`00oo`00?on00Go003o0?oj003ooP03o`00ooh01?l00?ooo@0>o`00
o`00o`3o003o003oo@00ood00?on00Co003oooh00?oM003Bn`00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Ko005=0?ok00?o003oo@08o`00o`00o`3ooP0Mo`00o`00
o`00o`00o`3o003o0?l00?oo003o003ooP06o`00o`00ooX00_l0ood00_l0ooh0
0ol00?ol00?o003ooP09o`00o`00o`00oo`08?l00?l00?l00?l00?l00?l00?l0
0?l00?l0o`00o`00oo`02?l00?l00?l0ooh08?l00?l00?l00?l00?l0o`00o`3o
003oo`00o`00o`00ood00?ok00;o0?om00;o0?on00?o003oo00>o`00o`3o003o
003o003oo000ooh02?l00?l0o`00ood00?on00?o003ooP02o`3on`0>o`00o`00
o`3o003o003oo@0;o`00o`3o003oo`3oo003o`00on000=;k003Bn`00d_d00_of
n_kf0?[nmP3jo_H2n_l00CL0ooX00ooo0?om00Co003oooh00Ol0o_l4003oo`3m
o`D0ool0ooon00;oo`3lo`400?ko0@00o_l20?oon`02o`3ooP3no`80o`3no`80
ooon0?ko0@00o_om00;oo`3mood0o_l1003no`X0ool0ool00?oo0?[o103oo`00
o_ol00Co003oooh00Ol0o_l4003oo`3mo`D0ool0ooon00;oo`3lo`D00?oo0?on
003on`02o`3ooP3no`80o`3no`80ooon0?ko1P3oo`3oo`3joo`00Ol0o_l50?oo
0?oon`3no`400?ko003no`00o_l1003ko`H0ool0ool0oOom007oooh01Ooo0?oo
0?kooP01oooO003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000h0?n10;@0
0?nd003ooP00on400?on003of`00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;j
o`00>03oP@2d003o]000ooh00?oQ003ooP00om/00=;k003Bn`00d_d00?onmP3j
o_H0n_kf1?[fm_l00300oh40/`00ok@0o_oO0?kofP00d_/00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`009P3oP@2109H00=;k003Bn`00d_d00?onmP3jo_H0n_kf
1?[fm_l002H0oh40P@2F003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o000V
0?n10840UP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00D`3on`01ooo/
007oood00?o]007ooo<00Ooo`001oook007oonX00?oi003om@01oon10=X00=;k
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l004@0ooX00?o[003oo000ond00?od
003o_`00ooP00?oC003oP@3J003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko
001D0?oj003ok`00ooh00?ol003om`00oo`00?on003om000okl00?ol003ooP00
om<00?n10=X00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l00<H0ooX02_l0
0?oo003o0?oooP3jo`400?koo@00oo`00_oo0?kooP3no`400?kooP01oool0?ko
0@00o_l;003oo`3oo`3o0?ooo@01ooon0?ko0`00o`3no`80ooon00Soo`00o`3o
o`3noo`0o_l1003nooh0o_l1003nooh00Ooon`3no`<00?l0oOl1003mo`L0ool0
o`3oooh00OoooP00oh40fP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00
fP3onP0Co`3o003o003o003o0?l00?l00?on00?o003ooP00ood01Ol00?l0oo`0
0?on00So003o0?l00?ol00?o003ooP0:o`00o`00o`00ooom00Go003o0?on01So
003oo`00o`00o`3o003o003oo`3o003oo@00ooh00ol00?ol003ooP08o`00o`3o
003oo@00ooh03?l00?oo003o0?l00?on00ko003o003o0?l00?l00?n10=X00=;k
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l00<h0ooX00Ol0oOl=003o003o0?l0
0?l00?on00?o003ooP00oo`0o_l10?ol003ooP04o`00o`3moo`00ol00?on00Wo
003o003o003oo000ood00?on00?o003ooP04o`00o`3mo`H00?l00?oon`00ooh0
0ol00?ol003ooP04o`00o`3mood00?on00?o003ooP05o`3o003ooP08o`00o`00
o`00o_l2003oP@3J003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko003<0?oj
00;o0?ol00Oo003o003oooh00?on00?o003ooP00ood01Ol00?l0oo`00?on00Go
003o0?oi00?o003ooP09o`00o`00o`00oo`00?om003ooP03o`00ooh01Ol00?l0
oo`00?om007oood00?on00?o003oo000ooh01Ol00?l0ooX00?on00?o003ooP04
o`00ooom00ko003o003o0?l00?l00?n10=X00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_l00=@0ooX03Ol0o`00o`00o`00o`3oo000ooh00ol00?on003oo@05
o`00o`3oo000ooh02?l00?l0o`00oo`00ol00?on00Wo003o003o003oo005o`00
o`3ooP03o`00ooh04Ol00?l0o`00o`00o`00o`00ood00?on00?o003oo000ooh0
2?l00?l0o`00ood00?on00?o003ooP02o`3on`0>o`00o`00o`3o003o003oP@3J
003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko00380?ok0?ko103oo`00o_l3
0?oo0?kooP01o`3no`D0ool00?ol00Goo`3o0?ol007o0?ko1@3oo`3ooo`0o_l1
003nood00_oo0?goo001ooon0?ko0@00o_l00?ko1`3oo`3oo`00o_l00?kon`3n
o`400?koo001o`3no`D0ool0oook0?ko0@00o_l00?ko003no`400?_o1P3oo`3o
o`3mo`40oh40g@00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00>P3ok@00
ooh00?of003oP@3h003ooP00oh40b@00d_/00=;k003Bo@00ookf0?[nmP3jo_H4
n_Kfo`00>P3ok@00ooh00?of003oP@3h003ooP00oh40b@00d_/00=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jo`00<P3ok03nooH00?n10?H0o_n10<P00=;k003Bn`00
d_d00?onmP3jo_H0n_kf1?[fm_l002L0oh40P@2J0?cB0@00o=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf0?[nmPCjm_Ko000N
0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40P@28003Bo@00ookf
0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3jo_H0n_kf0_[o000N
0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40P@28003Bo@02ooKj
o_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf0?[nmPCjm_Ko000N
0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40P@28003Bo@00ookf
0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3jo_H0n_kf0_[o000N
0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40P@28003Bo@02ooKj
o_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf0?[nmPCjm_Ko000N
0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40P@28003Bo@00ookf
0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3jo_H0n_kf0_[o000N
0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40P@28003Bo@02ooKj
o_H0n_kf0?[nmP;jo`007P3oP@2108P00=;m003oo_H0n_kf0?[nmPCjm_Ko000N
0?n10840R000d_d00_ofn_kf0?[nmP3jo_H2n_l001h0oh40P@28003Bo@00ookf
0?[nmP3jo_H4n_Kfo`007P3oP@2108P00=;m00;om_[nmP3jo_H0n_kf0_[o000N
0?n10840R000d_d00?onmP3jo_H0n_kf1?[fm_l001h0oh40P@28003Bo@02ooKj
o_H0n_kf0?[nmP;jo`009`3oP@2109X0o=81003ld_/00=;m003oo_H0n_kf0?[n
mPCjm_Ko000V0?n10840UP00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00
=P3oiP3lo`800?oT0?gon@3noh40P@3X0?gBn`00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Ko000f0?oX0?kooP3mon<0o_oi0?koP@210>D00=;k003Bn`00d_d00_of
n_kf0?[nmP3jo_H2n_l003X0oo/0m_oj0?koo03non<0o_oi0?koP@210>D00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l003/0oo/00?ohnP3onP3noo/00Ooo
h`3noh40P@3J003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001H0?ok003o
n?X0oo/0o_of0?ko003no`400?cooP3no`<00?ooo@3no`00o_on0?gooP3loh40
P@3]003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001F0?ok003on?X0oo/0
o_oe0?ko1`3oo`3oo`00o_on0?[ooP3iooh0o_l1003no`80oon10840k@00d_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00I03on`00ooSj0?ok0?koo03lo`40
0?koo@03ool00?kooP3no`400?ko0@00o_l1003nooh0o_l00?ko0`00oon10840
k@00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00F@3on`00ooSj0?ok0?ko
n`3nooh0o_oj0?gooP3no`400?ko0@00o_l1003nooh0o_l00?koP@210>T00=;k
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l005d0oo/00?ohnP3on`3noo/0o_on
0?koo002ool0o_on0?ko0@00o_l1003no`400?kooP3no`00o_n10840j@00d_/0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00GP3on`00ooSj0?oj0?koo03nooh0
o_om00?oo`00o_on0?ko0@00o_l1003no`400?kooP3no`00o_n10840j@00d_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00GP3on`00ooSj0?oj0?koo03nooh0
o_om00?oo`00o_on0?ko0@00o_l1003no`400?kooP3no`00o_n10840j@00d_/0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00G03on`00ooSj0?oi0?kooP3mooh0
o_om0?[ooP3mo`80ooon0?ko0@00o_on0?ko0@00o_l20?ooP@210>d00=;k003B
n`00d_d00_ofn_kf0?[nmP3jo_H2n_l005@0oo/0m_og0?_oo@3lood0o_l00?ko
0@00o_l20?oooP3lo`00oOl00?co0@00oOn10840k000d_/00=;k003Bo@00ookf
0?[nmP3jo_H4n_Kfo`00:P3obP3noh40P@3@003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[o000Z0?o:0?koP@210=000=;k003Bn`00d_d00?onmP3jo_H0n_kf
1?[fm_l002X0olX0o_n10840d000d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;j
o`00:P3ob`3loh40P@3A003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000V
0?n10840VP3ld_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`008P3oP@2108l0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`008P3oP@2108l00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`008P3oP@2108l00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
o`008P3oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`008P3oP@2108l0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`008P3oP@2108l00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`008P3oP@2108l00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
o`008P3oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@2109X0
o=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l002H0oh40P@2F003Bn`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o001g0?ok0?ko0@00o_oK007ooo<00ooo0?o_
007oond00?o[003ok001oooc00Coo`00on800Ooom03no`@0o`00oo000?oe007o
oo`00?oY007oooD00Oooc`3md_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00
E`3onP00ood00?oI003om000on`00?nm003olP00omh00?oe003ooP01oooO003o
hP00oo@00?o<003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001f0?oj003o
o@00omd00?on003om000oo<00?ok003oj@00oo400?oW003olP00onh00?of003o
oP00ooD00?om003og`00ooL00?oj003om@00oo@00?o<003Bn`00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Ko004l0?oj003oo@00ooh02_oo003o0?oo0?oon`0:ool0
0?l0ool0ooom0?ko0@00o_on007ooo`0o_l80?oo0?l0ool0noom0?ko0@00o_l;
003oo`3oo`3o0?oooP3lo`d00?oo003o0?oo0?oo0?ko103oo`00o_l5003o0?oo
oP3noo`01?l00?oooP01ooon00_oo`3o0?oo0?l0ooon0?gooP3no`400?koo@3n
o`400?kooP01oook007oood02Ooo003oo`00o`3no`/0ool00?oo0?l0ooon0?ko
2000o`3oo`3oooh0o_l4003oo`3no`L0o`3oo`3oooh0o_on007oooh02Ooo0?l0
o`3oo`3no`D00?l0oooK003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o005<
0?oj0?_o3P00o`00o`00ool0o`00ood03?l00?l00?oo0?l00?om003ooP08o`00
o`3o003oo000ooh02ol00?oo0?l00?l0oo/00ol00?on00[o003o003o003ooo`0
4ol0o`00o`00o`00ool0o`00o`3ooP02o`3ooP0;o`00o`00o`3o003oo00No`3o
003o0?l00?l0o`00ool00?l00?l00?l0o`00oo`00ol00?on003oo@00ooh02?l0
0?l0o`00oo/0o_on02;o0?l00?l00?oo0?oo003o003o003o003o0?l00?l00?l0
ooh00?om00So003o003o0?on01goo`3o003o003o003o0?l00?l0o`00ool00?oo
0?on00Ko003o003og000d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`01>03o
nP00ood00_l00?go1000o`00oOol0?ko1000o`00oOom003ooP04o`00o`3moo`0
0?on00Oo003o003oooh00?ok00?o003ooP09o`00o`00o`00oo/01?l0o`00oOl2
003ooP3no`40ooh00_l0ooh02Ol00?l00?l0oooj007o0?go0@00o_l10?on00ko
003o003o003o0?l00?ol00?o003ooP00ood00?on00Co003o0?gon@05ool00?l0
oOl5003o003ooP0<o`00o`00o`00o`3oood00Oooo@00ood00_l00?go0@3ooP00
ooh0o_l6003o003o0?go0@3ooP06o`00o`00ooh01_l00?l00?oL003Bn`00d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[o004j0?oj003oo@03o`00oo`00ol00?oj00Wo
003o003o003onP00ooh01Ol00?l0ooT00?on00?o003oo@03ool0oo/00ol00?on
00Wo003o003o003on`05o`3o003oo008o`00o`00o`3ooP02o`3ooP06o`00o`00
ooh00Oooo002o`3oo@05o`00o`3ooP0=o`00o`00o`00o`00oook00?o003ooP00
ood00?on00Go003o0?oj003oo@05o`00o`3oo003o`00ooh02Ol00?l00?l00?on
00Koo`00o`3ooP00ood00ol00?om003ooP0>o`00o`00o`00o`00o`3oo@00ooh0
1_l00?l00?on00Ko003o003og000d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
o`01C`3onP00ood03ol00?l00?l00?l00?l00?om00co003o003o003o003oo@00
ooh02?l00?l0o`00oo`00?on00_o003o003o003o0?ok00?o003ooP09o`00o`00
o`00oo/04ol0o`00o`00o`00o`00o`00o`3ooP02o`3ooP0;o`00o`00o`3o003o
o00Ko`3o003o0?l00?l0o`00ool00?l00?l00?l0ooT00ol00?on003oo@00ooh0
2?l00?l0o`00ood0;_oo003oo`00o`3o003o003o003oo`00o`00o`00o`00o`3o
003o003o003o003oo@08o`00o`00o`3ooP0Mo`00o`00o`00o`00o`3o003o0?l0
0?oo003o003ooP06o`00o`00om`00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2
n_l00C00oo/0o_l1003no`D00?oo003no`<00?oon`02ool0oOl3003ooo/00Ol0
o_l50?oo0?ooo03no`00nol00?kooP00ood0o_l1003nood00_oo0?goo@3no`L0
o`00ool00?ko2000ool0o`3o0?ko003no`400?ko003loo`0o_l20?oooP07ool0
o`3oo`3io`<0ool0o_ok00;o003noo/00Ol0o_l50?oo0?ooo001o`3no`400?ko
103oo`00o_l60?l0ool00?_o003lo`400?ko003lood01?l00?oooP01o`3no`@0
0?oo0?go1@3oo`3oooh00_oo0?co0@00o_l1003no`@0ool0oml00=;k003Bn`00
d_d00?onmP3jo_H0n_kf1?[fm_l00300oh40b000ooh00?o=003oR@00d_/00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jo`00<03oP@38003ooP00old00?n9003Bn`00
d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000/0?n10<L0o_o=0?koRP00d_/00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@2109X0o=;k003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_l00280oh40P@2?003Bn`00d_d00_ofn_kf0?[nmP3jo_H2
n_l00280oh40P@2?003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l00280oh40P@2?
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l00280oh40P@2?003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_l00280oh40P@2?003Bn`00d_d00_ofn_kf0?[nmP3jo_H2
n_l00280oh40P@2?003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l00280oh40P@2?
003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l00280oh40P@2?003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_l002H0oh40P@2J0?cBn`00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[o000V0?n10840UP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00
9P3oP@2109T0oM;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l002H0oh40P@2F
003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000V0?n10840UP00d_/00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jo`009P3oP@2109H00=;k003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_l002H0oh40P@2F003Bn`00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[o000V0?n10840UP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00
9P3oP@2109H00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l002`0oi/00?n1
0?<00?n<003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko000/0?nL0?koP@3e
0?koS@00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00<P3oW@03ogkooh40
mP03oeKoohd00=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l003@0oid01?oj
O_ooP@3g00CoO_l2ohh00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l003H0
oih01OmFOUKooh40n005ogiFO_ooSP00d_/00=;k003Bo@00ookf0?[nmP3jo_H4
n_Kfo`00>P3oW`07ooYnnWko0_n10?X01omnnWkjo`;oS`00d_/00=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jo`00>`3oW`07ogiFOUKo3_n10?X02?mFOUIno`8>oi00
0=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l003h0oj002OmnnWkjO_l20_n1
0?`02OojO_Ynn_l20_n@003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o0011
0?nQ00[oOUInEWiFo`h2oh40o@0;oeInEWiFO_l23P;oT@00d_/00=;k003Bo@00
ookf0?[nmP3jo_H4n_Kfo`00@P3oX@0;ooYnnWkjO_[o0P;oP@3n00OoO_YnnWkj
ooh20?nA003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o00150?nR00goEWiF
OUInEWko0Ph2oh403P3oOUInEWiFO_l23P8>oi800=;k003Bn`00d_d00?onmP3j
o_H0n_kf1?[fm_l004H0oj<02_ojO_YnnWkjO_[ooP80oh402_mnnWkjO_YnnWko
oP80oi800=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l004X0oj@04?mFOUIn
EWiFOUIno`8>0PkoP`0@ogiFOUInEWiFOUKo3P8>0_nC003Bn`00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Ko00180?nT00_oO_YnnWkjO_Ynn_om0P3oP`0;ooYnnWkj
O_YnnWkoo@80oi<00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l004h0ojD0
4_mnEWiFOUInEWiFO_l23P8>0_n501;oEWiFOUInEWiFOUKo3P8>0PkoU000d_/0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00C@3oYP0>ogkjO_YnnWkjO_YnnWko
o@80ohH03OojO_YnnWkjO_YnnWkon`80oiD00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_l00580ojH05?mFOUInEWiFOUInEWiFo`h23P8>ohL05?mnEWiFOUIn
EWiFOUKo3P8>0Ph2oiD00=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l004l0
ojL03oojO_YnnWkjO_YnnWkjO_ol0P3oR00>ogkjO_YnnWkjO_YnnWkonP80oiH0
0=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l005P0ojP05omFOUInEWiFOUIn
EWiFOUKo3P8>0Ph2ohX05omnEWiFOUInEWiFOUInEWko0Ph23P8>oiH00=;k003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_l00500ojP04?mnnWkjO_YnnWkjO_YnnWko
n`80ohX0oOl<O_YnnWkjO_YnnWkjood2oOnG003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[o001E0?nY01WoOUInEWiFOUInEWiFOUInE_l>0Ph23P8>oh`0o_l1
003io`EFOUIno`;mo`;hoonG003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko
001?0?nZ01;oO_YnnWkjO_YnnWkjO_YnnWkonP80ohd00oojooog0?_ooP04ogko
0_nH003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o001F0?nZ01_oEWiFOUIn
EWiFOUInEWiFOUIno`8>0Ph23P;oSP04ogko0_oe0?ko1`00ogkhO_ooV000d_/0
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00E`3oZ`0DooYnnWkjO_YnnWkjO_Yn
nWkjO_[onP80ohl01OmnnWkoooH03?ojool0ogkjO_[o0_nI003Bn`00d_/00=;m
00;om_[nmP3jo_H0n_kf0_[o001O0?n/01koEWiFOUInEWiFOUInEWiFOUInEWko
0Ph23P8>0PkoT@07ogiFOUKomoog00;oOUKno`KhO_Qno`;oV@00d_/00=;k003B
o@00ookf0?[nmP3jo_H4n_Kfo`00G@3o[00EogkjO_YnnWkjO_YnnWkjO_YnnWkj
ooT20?nA00SonWkjO_l20_oi00koO_YnooojO_Ynn_l20_nJ003Bn`00d_/00=;m
00;om_[nmP3jo_H0n_kf0_[o001V0?n]023oOUInEWiFOUInEWiFOUInEWiFOUIn
o`8>0Ph23P8>0_nC00WoEWiFOUKom`;onP0?ogiFOUKo3_ohO_Qno`8>oiX00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l006@0ojh05omnnWkjO_YnnWkjO_Yn
nWkjO_YnnWkjooL20?nE00OonWkjO_Ynooh20?ok00conWkjO_l20_ojO_[ooP80
oi/00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_l006`0ojh08_mFOUInEWiF
OUInEWiFOUInEWiFOUInE_l>0Ph23P8>0PkoU@0;ogiFOUInE_og0_Ooo00AoeIn
EWiFo`h2ogkhO_l23P;oV`00d_/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfo`00
JP3o[`0IooYnnWkjO_YnnWkjO_YnnWkjO_YnnWkjO_og0P3oU`08ogkjO_YnnWko
o@80ooh03oojO_YnnWkjo`82ogkjO_on0P3oW000d_/00=;k003Bo@02ooKjo_H0
n_kf0?[nmP;jo`00M03o/00UoeInEWiFOUInEWiFOUInEWiFOUInEWiFOUKo3P8>
0Ph23P8>0_nH00koOUInEWiFOUIno`;g0_on01?oOUInEWiFO_l23_ohO_So3P8>
oi`00=;k003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l006h0ok406oojO_YnnWkj
O_YnnWkjO_YnnWkjO_YnnWkjO_of0P3oVP0;ogkjO_YnnWkjO_[oo@8;o`3oO_Yn
nWkjO_[ooP83ooYnood20?nM003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o
001h0?na02OoOUInEWiFOUInEWiFOUInEWiFOUInEWiFOUKo3P8>0Ph23P8>0Pko
VP0WoeInEWiFOUInEWko0_L2moooOUInEWiFOUIno`8>0_mnn?l>0Ph2oid00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_l006l0ok807?mnnWkjO_YnnWkjO_Yn
nWkjO_YnnWkjO_YnnWkom@80oi`03?ojO_YnnWkjO_Ynn_om0P_oO_YnnWkjO_Yn
n_om0P;oO_ol0P3oWP00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jo`00OP3o
/`0ZogiFOUInEWiFOUInEWiFOUInEWiFOUInEWiFOUIno`8>0Ph23P8>0Ph2oid0
:_mFOUInEWiFOUInEWko0_L2momFOUInEWiFOUIno`8>0Pkon?l>0Ph23_nN003B
n`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001c0?nc01konWkjO_YnnWkjO_Yn
nWkjO_YnnWkjO_YnnWkjO_[om@80oih03OmnnWkjO_YnnWkjO_[ooP8=ooYnnWkj
O_YnnWkjO_om0P7ooo/20?nO003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[o
00220?nd02coEWiFOUInEWiFOUInEWiFOUInEWiFOUInEWiFOUIno`8>0Ph23P8>
0Ph23_nO02coOUInEWiFOUInEWiFO_l2momFOUInEWiFOUInEWiFo`h23P8>ool2
3P8>0_nO003Bn`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Ko001g0?ne023onWkj
O_YnnWkjO_YnnWkjO_YnnWkjO_YnnWkjO_Ynn_og0_goX@0PogkjO_YnnWkjO_Yn
nWkjO_l2ogkjO_YnnWkjO_YnnWkoo081ooon0_goX000d_/00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jo`00o`\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{399, 326},
  ImageMargins->{{0, Inherited}, {Inherited, Inherited}}],

Cell["\<\
Here is the same notebook in the Printout environment, which uses \
smaller fonts, and for which text breaks at the width of a sheet of paper \
instead of the width of the notebook window.\
\>", "Text"],

Cell[GraphicsData["PICT", "\<\
GCh0@@1A0D<1hP0A0_l<0?ooool0D@000440007R0001@`000000000100X0@@1A
0D<1hP2HPI80@@1A0D<1hP000000000004P0001800000008004020000001dgJl
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000@@1A
0D<1hP110541@`7R00002X7oPOn1oo;ooP00403oP@J11X46m@H4E?oo00004@7o
1X7ePOF1mOKe15Coo`000141o`J1mH7ePOGfm@ADool0000Q0Ol6noX0mOJ/0?FO
nX7ehOFNnP3emZ`0mO_j15Coo`0004<1o`Kjm@2/m`JFmOkoo_D1oooYm@7ooo3e
0OoonoD1ooolmO_omoD1ooo`m@7oonoe0OooPOD1mJcg1_[e15Coo`0004/1o`Kk
nP;e[0Kjn0:/1_FOn_[e1?oomOGod_D1ooobm@7oooGe0Oool?D1ooo_m@7oonCe
W_X2mJ`6oOP5[?Sh[0KenoX4E?oo0000RP7o1_[e0J`6n_P1[0JGm@7oooce0Ooo
o_Gmooke1OoomOoomOcoo_D3oooemOcooOGnooke2OoomOGoooGeooojm@7oooge
oOonmOgo2?GeoooeoooemOgoo_GloogeoOommOco2?GeoooeoooemOgoo_GloiGe
0J`6oOP4[?Sh[0Kjm@ADool0002d0Ol6noX2mJ`6n_P2[0KeWo[jmOkooOD;oooe
mOoomOGoooGeo_onmAooooGeoooemOoomOGoooGeoooemOoomOGomOGoooGoooke
0Ooon_D1ooonm@GoooGeooonm@7oookeo_onm@3oo_DKoooemOoomOGoooGeoooe
mOoomOGoooGeoooemOkoo_D=oooemOoomOGoooGeooojmIkj0_F/1_gh1Jchn:`6
mO_j15Coo`000:<1o`Kjm@6/1_[h0J`6U_Gnooke3OoomOGoooGeoooemOoooODC
oooemOoomOGoooGeoooemOoomOGnoogeoOomm@7ooo[e0Oooo_D5oooemOooo_D1
ooonm@7oooceo?lKmOGoooGeoooemOoomOGoooGeoooemOoomOGoooge3OoomOGo
ooGeoooemOooU_D1[0Kmn0B/n?R/1_[e15Coo`000:<1o`KknP;e[0Kjn0:/1_FO
n_Seo_l5mOGoooGenol3mOGoooge4OoomOGoooGeoooemOoomOGoookeo_onmOko
o?D1ooojm@7oookenoonm@7oooke0OoooOD?oooemOoomOGoooGeoooemO_o2oGe
oooemOoomOGoooge3OoomOGoooGeoooemOoon_FNnP;e[0Kl[0Chn:`6mO_j15Co
o`0009/1o`Kjm@6/1_[h0J`6U?D9oooemOoomOGooo_e0OoooODAoooemOoomOGo
ooGeoooemOoooOGno`7emOgooOD1ooojm@7oooke0Ooon_D1ooonm@7oooge4Ooo
mOGoooGeoooemOoomOGooo_e2OoomOGoooGeooomm@goooGeoooemOoomOGooiKe
0J`6n_P1[0Kjm@ADool0002e0Ol6noX2mJ`6n_P2[0KeWo[jm@comOGoooGeoooe
mOooo_D4ooGeooommAooooGeoooemOoomOGoooGeoooemOoemOoomOGoooGoooke
0Ooon_D1ooonm@7oooke0?onm@7oooke0OoooODAoooemOoomOGoooGeoooemOoo
o_D<ooGeoooemOoomOGoooge3OoomOGoooGeoooemOoon_FNnP;e[0Kjn0:/1_Gk
nPADool0002:0Ol6n_D1[0Ki[006U_Gnooke0Oooo_Gmooke0OoooOGlooke2Ooo
mOGoooGeooonmOkoo_D9oooemOoomOGooo[e0OoooOGmooce1OoomOGoooceo?l7
mOGoooGeooonmOgooOGlo`?emOooo?Gmooke1OoomOGooiKe0J`6nJ`01_[e15Co
o`0002H1o`KknP7e[?L60?FOn^7e0OooPoFNnP7e[?L60?GknPADool0000D0Ol6
POG/m@7ooh7eSOD4E?oon`004@7o1X7ePOF1mOKe05Cno`0000l0oh5DPEB1E?AD
0ooo00002h7oPOn1oo7o0@000180oh40P@23003om004n_oo00004`3oP@2108<0
0Ol0mOH4n_oo00005`3oP@2108<00Ol0o?H0[?_f1?[oo`0001T0oh40P@23007o
0?gf0ZaD[?cf1?[oo`0004T0oo80m?l1003nom`0o?oi0?koe`3noml0o_of0?ko
m`3dom<0o_oN0?ko]`3ldP400?cBo@01o`3nmP2/oU@0[?gf1?[oo`0004/0oo80
m?l1003nomh0n?ok0?koe`3noml0o_of0?kom`3doo40o_oV0?kogP3nok<00=;k
003Bo@04o`3fmZclE02/o_H4n_oo0000B@3olP3do`400?kog`3foo`0o_oG0?ko
g`3nooH0o_og0?Col@3nonH0o_oN0?ko]P3md_/00=;m00?o0?J/nU@7[?Kfn_oo
0000@03ok@3nooX0o_oP0?goo03moj/0o_oT0?kok03nonH0o_oN0?ko/`00d_/0
0=;m007o0?f/oUCm[0Gfn_oo0000/`3ok@3nooX0o_l1003looP0oOod0?konP3n
ood0o_oj0?gonP3no`D00?oo003no`400?gon`3nood0o_l1003looT0nook0?ko
o@3nood0o_ob0?kom`3moo`0n_on0?ko0`00ooom0?con`3no`400?con03mooP0
o?l00?koo@3no`<00?ooo03looX0o_l1003lomT00=;k003Bo@01o`3nmP2/oU@0
[?gf1?[oo`000:D0ond0o_oj0?ko003joo/0nOof0?konP3nood0o_ol0?Woo03n
o`00o_l1003goo`0o_om0?ko003joo`0moom0?kooP3mood0o_ob0?kon@3iooh0
n_on0?ko003no`400?Soo@3no`00n_ok0?Won`3good0o_l00?kooP3hoo`0o_l0
0?[ofP00d_/00=;m007o0?kf0:cnE02/oOH4n_oo0000R03ok@3nooX0mOom0?Oo
m`3moo@0o_om0?Ooo@3jo`400?Koo@3nood0mOom0?Ooo@3no`400?goo03noo80
o_oj0?Oo0@00n_on0?[o0@00moon0?Goo@3good0m_om0?[o0@00m_om0?Gof`00
d_/00=;m007o0?kf0:cnE02/oOH4n_oo0000/`3ok@3nooX0oOom0?goo@3nood0
o_og0?[om`3nood0o_om0?koo@3moo`0oOom0?koo@3nood0oOom0?gooP3mood0
oOon0?ko003moo/0o_ob0?konP3nood0o_om0?koo03mood0oOom0?kooP3mood0
oOom0?koo@3nood0o_om0?goo@3moo`0oOon0?goo@3mood0oOoK003Bn`00d_d0
0Ol0o_Kl[?gf1?[oo`000;00ond0o_oj0?kon`3nooh0o_ok0?kom`3goo/0o_on
0?kon`3nooh0o_ok0?goo@3mooh0o_om0?kon`3nooh0o_ok0?kooP3no`00o_oj
0?kolP3noo/0o_ok0?kooP3noo`0o_ol0?koo03nooh0o_ok0?kooP3noo/0o_l1
003mood0oOom0?koo03moo`0oOon0?kon`3nom/00=;k003Bo@01o`3emPCjool0
002R0?o]0?konP3noo/0o_on0?kon`3nooD0moom0?kooP3noo/0o_on0?kon`3n
oo/0o_on0?koo@3noo/0o_on0?com`3jooX0o_ob0?kon`3noo/0o_on0?koo03n
ooD0oOon0?kon`3nooh0o_ok0?ko0@00o_ok0?koo@3noo`0o_oj0?kooP3noo/0
o_oK003Bn`00d_d00?ocnP?oo`0008h0ond0o_oj0?kon`3nooh0mOoa0?[ooP3n
ooh0mOon0?kon`3noo/0o_on0?koo@3noo/0o_om0?Soo03jooX0o_ob0?kon`3e
ooh0o_ol0?konP3hooh0o_ok0?kooP3eo`400?kon`3nood0o_ol0?konP3nooh0
o_ok0?kof`00d_/00=;m0?3o0@0009H0ond0o_oj0?kon`3nooh0mOo^0?gooP3n
ooh0mOon0?kon`3noo/0o_on0?koo@3noo/0o_ol0?Soo@3ioo/0o_ob0?kon`3e
ooh0o_ol0?kon`3ko`00o_on0?kon`3nooh0mOl1003noo/0o_om0?koo03nooX0
o_on0?kon`3nom/00=;k003Bo@00oo?k0ooo0000WP3ok@3nooX0o_ok0?kooP3n
onl0o_oi0?kooP3nooh0o_oe0?kon`3noo/0o_on0?koo@3noo/0o_og0?cooP3m
o`00o_ok0?kolP3noo/0o_oe0?koo03noo`0o_ol0?kooP3noo/0o_on0?komP3n
oo/0o_om0?koo03nooX0o_on0?kon`3nom/00=;k003Bo@00oo@61:coo`000:@0
ond0o_oj0?kon`3nooh0o_o_0?gonP3nooh0o_on0?kom@3noo/0o_ol0?gooP3n
ood0o_ok0?kooP3noo/0o_on0?ko0@00oOol0?kolP3noo/0o_oe0?koo03noo`0
o_ol0?kooP3noo/0o_on0?komP3mood0oOom0?koo03moo`0oOon0?kon`3nom/0
0=;k003Bo@01o`Ken0B/ool0002g0?o]0?konP3noo/0o_om0?koo@3mooL0oOol
0?gooP3nood0o_om0?gooP3noo/0oOom0?koo@3nood0o_ok0?kooP3moo`0o_on
0?kooP3noo`0o_ob0?konP3nood0oOon0?koo03noo`0o_om0?gooP3noo/0o_om
0?koo@3mooh0o_om0?goo@3noo/0oOon0?goo@3noo/0o_oK003Bn`00d_d00Ol6
o_SkE?kh1:coo`0008l0ond0o_oj0?kon`3nood0moof0?Goo@3nood0moom0?ko
n`3food0o_om0?kon`3nood0m_on0?kooP3mood0o_ob0?konP3good0o?on0?ko
o03fooh0o_ok0?koo@3good0m_om0?kon`3food0o_ok0?kof`00d_/00=;m007o
1_khn`Knn0B/ool0002G0?o]0?konP3noo/0o_ol0?Wom03goo`0o_ol0?Woo03n
oo/0mool0?koo@3noo/0o_om0?Ooo@3nooh0oOom0?kolP3nooT0nOol0?cooP3n
oo/0nol00?kooP3noo/0o_ol0?Won`3ko`00o_om0?konP3hoo`0o_ok0?kof`00
d_/00=;m007o1_khnh3nn0B/ool0002O0?o]0?konP3noo/0o_oj0?col@3kooX0
o_oj0?con`3noo/0o_l1003moo/0o_om0?kon`3noo/0nook0?koo@3mooh0o_ob
0?kom`3looX0oOon0?konP3mo`400?go0@00o_ok0?konP3looT0oOl1003nood0
o_oh0?conP3noo/0o_oK003Bn`00d_d00Ol6o_Sk1_kh1:coo`000240oi00o_n1
08<00=;k003Bo@01o`Knn?^0o_P4[?oo00008@3oT03noh40P`00d_/00=;m007o
1_khn`Knn0B/ool0000Q0?n@0?koP@23003Bn`00d_d00Ol6o_SkP?kh1:coo`00
0240oi00o_n108<00=;k003Bo@01o`Knn?/6o_P4[?oo00008@3oT03noh40P`00
d_/00=;m007o1_khnh3nn0B/ool0000O0?n10840S`00d_/00=;m007o1_khn`Kn
n0B/ool0000K0?n10840T`3ld_/00=;m007o1_Gh1:coo`0001L0oh40P@28003B
o@01o`Ken0B/ool0000E0?n10840R000d_d00?oc[0?oo`000200oh40P@28003B
o@00ookf0?[nmP3jo_H6n_Kfool0000P0?n10840R000d_d00_ofn_kf0?[nmP3j
o_H4n_oo0000803oP@2108P00=;m003oo_H0n_kf0?[nmPKjm_Koo`000200oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmPCjool0000P0?n10840R000d_d00?onmP3j
o_H0n_kf1_[fm_oo0000803oP@2108P00=;m00;om_[nmP3jo_H0n_kf1?[oo`00
0200oh40P@28003Bo@00ookf0?[nmP3jo_H6n_Kfool0000P0?n10840R000d_d0
0_ofn_kf0?[nmP3jo_H4n_oo0000803oP@2108P00=;m003oo_H0n_kf0?[nmPKj
m_Koo`000200oh40P@28003Bo@02ooKjo_H0n_kf0?[nmPCjool0000P0?n10840
R000d_d00?onmP3jo_H0n_kf1_[fm_oo0000803oP@2108P00=;m00;om_[nmP3j
o_H0n_kf1?[oo`000200oh40P@28003Bo@00ookf0?[nmP3jo_H6n_Kfool0000P
0?n10840R000d_d00_ofn_kf0?[nmP3jo_H4n_oo0000803oP@2108P00=;m003o
o_H0n_kf0?[nmPKjm_Koo`000200oh40P@28003Bo@02ooKjo_H0n_kf0?[nmPCj
ool0000P0?n10840R000d_d00?onmP3jo_H0n_kf1_[fm_oo0000803oP@2108P0
0=;m00;om_[nmP3jo_H0n_kf1?[oo`000200oh40P@28003Bo@00ookf0?[nmP3j
o_H6n_Kfool0000P0?n10840R000d_d00_ofn_kf0?[nmP3jo_H4n_oo0000803o
P@2108P00=;m003oo_H0n_kf0?[nmPKjm_Koo`000200oh40P@28003Bo@02ooKj
o_H0n_kf0?[nmPCjool0000P0?n10840R000d_d00?onmP3jo_H0n_kf1_[fm_oo
0000803oP@2108P00=;m00;om_[nmP3jo_H0n_kf1?[oo`000200oh40P@28003B
o@00ookf0?[nmP3jo_H6n_Kfool0000P0?n10840R000d_d00_ofn_kf0?[nmP3j
o_H4n_oo0000803oP@2108P00=;m003oo_H0n_kf0?[nmPKjm_Koo`000200oh40
P@28003Bo@02ooKjo_H0n_kf0?[nmPCjool0000Y0?n10840VP3ldP400?cBn`00
d_d00?onmP3jo_H0n_kf1_[fm_oo0000=P3ol`3koo`00OoohP01oon10840dP00
d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool000100_l00?Woo001ooon007o
ooh00OoohP01oon10840e@3md_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0
000i0ol00?oknP3oo001ooon007ooh40P@2/003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf1?[oo`0006@3o`00oo_j0?ol007oood00_oo0?ko0@00oOl1003no`00
o_l00?ko0@00oOl00?[ooP3no`400?ko0P3ooh40P@3P003Bn`00d_/00=;m003o
o_H0n_kf0?[nmPKjm_Koo`0006d3o`00oo_j0?ol007oood07Ooo003oo`3oo`00
o`3oo`3oo`3oo`00ool0ool00?ko3P00o`3oo`00ool0ool00?ko0P3ooh40P@3Q
003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`0006`3o`00oo_j0?ol007o
ood01_oo003oo`3no`l00?oo003oo`3oo`00ool0o_l1003nooh01?oo0?oooP08
ool0ool00?ooP@210>400=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000
J`?o003onoX0oo`00Oooo@07ool00?oo003no`80oool00Ooo`00ool00?ko0@00
o_l6003oo`3oooh02?oo0?oo003ooh40P@3Q003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf1?[oo`0006L3o`00oo_j0?ol007oooh00OoooP01ooon0?coo005ool0
0?oooP3no`400?ko1@3oo`3oooh02?oo0?oo003ooh40P@3Q003Bn`00d_/00=;m
003oo_H0n_kf0?[nmPKjm_Koo`0006h3o`00oo_j0?ol007oooh00OoooP0Aool0
o`00ool0ool00?l0ool0o_l30?l00?ko5@00ool0ool00?oo0?oo003oo`00oon1
0840h@00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001F0_l00?Woo@3k
ood0nOon0?kooP02ool0n_l00?go003mo`400?ko0@00oOl00?koP@210>800=;k
003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000:03oP@2109H00=;k003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000:03oP@2109H00=;k003Bn`00d_d00?on
mP3jo_H0n_kf1_[fm_oo0000:03oP@2109H00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H4n_oo0000:03oP@2109X0o=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[f
m_oo0000903oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0000T0?n1
0840S`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002@0oh40P@2?003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000903oP@2108l00=;k003Bo@00ookf0?[n
mP3jo_H6n_Kfool0000T0?n10840S`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[o
o`0002@0oh40P@2?003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000903oP@21
08l00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0000T0?n10840S`00d_/00=;m
003oo_H0n_kf0?[nmPKjm_Koo`0002P0oh40P@2J0?cBn`00d_/00=;m00;om_[n
mP3jo_H0n_kf1?[oo`0007l0oo<0nOoe0?ko0P00oo<00?og007oood00?o/007o
ooP00Oook`00ooL00Oook@01ooom007oooD00?o^003ol001ooo@007ooo<00Ooo
m`00om/00Ooon001ooo`003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`00
07d0oo<01ol00?l00?oomP03o`00on@00?og003on`00ooP00?og003oi@00onX0
0?ol003olP00oo@00?o_00?o003od@00oo000?oP003on`00ooP00?og003ol`3m
d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0004i0?o`003ooP01ooon007o
oo`00?om00Koo`00ool0n_l30?oo0?kooP3no`80o`3mood0o_l30?oo0?WooP01
ooon00?oo`00o_l00?ko003no`00o_ol00?oo`00o_on0?ko003no`00nOon00?o
o`00o_ol0?ko1@3oo`3oooh00_oo0?ko0`3oo`3lo`400?co003no`400?koo03n
o`80ooon007oood0oOl00?ko003no`400?ko103oo`00o_l00?koo@3no`00o_on
0?ko0`3oo`3mo`D00?l0ooon0?co003no`400?koo001oool0?ko0`3oo`3iooh0
0OoooP03ool00?ko003no`00o_l20?oon`00d_/00=;k003Bo@00ookf0?[nmP3j
o_H6n_Kfool0005O0?o`003ooP07o`3o0?l00?ol007oooh05_l0o`00o`3o003o
003o0?l00?l0o`3oo@05o`3o003oo00:o`3o003o0?l00?on01?o003o0?l0o`00
ool00?l00?l0ooh01?l0o`3oo002o`3onP02o`3ooP0Bo`3o003o0?l0o`3o003o
o`00oo`01ol00?l0o`3oo00:o`00o`3o003o0?on013o003o003o003o0?l0o`00
oo`02_l00?l0o`3o003oo@07o`00o`3o0?on00Woo`00ool00?oooP00oo/00?on
00;o0?ol00co0?l00?l0o`00o`3ooP0Ao`3o003o0?l00?l0o`3o003on`00oo`0
2_l0o`00o`3o003ooP0Co`00o`3o0?l00?oo003o003o0?on00;o0?ok003Bn`00
d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`000Dl0oo000?on00?o0?l0oOoj00Co
003o0?go5P3o003o003o0?l00?l0o`00ool00?oooP00oo`00Ol0oOl>0?l00?l0
0?oo003o0?l0o?l7003o003o0?on00Co0?l0oo`01?l00?ooo002o`3ooP0:o`3o
003o0?l0o`3lo`800?ol00Oo003o0?l0oo`01?l00?l0oOlB0?l00?oo003o003o
003o0?l00?koo006o`00o`3o0?goo@07o`00o`3o0?on007oooh0oOl60?oo003o
ood00?on00;o0?ol007o0?go303o003o0?l00?oo0?om00Oo003o0?l00?koo001
oool007o0?go3P3o003o003oo`00o`3o0?co1`00o`00o`3ooP02o`3on`00d_/0
0=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0005B0?o`003ooP04o`3o0?oj00So
003o003o0?om00go003o003o0?l00?l0ood01ol0o`3o003oo002o`3oo@0>o`00
o`3o0?l00?l0o`3ooP08o`00o`00o`3ooP04o`3o0?ol003oo@00ood00_l0ooh0
2ol0o`00o`3o0?l0ooh00ol00?ol00Ko003o003on`05o`00o`3oo@0Ao`3o0?l0
0?l00?l00?l0o`3on@07o`00o`3o0?oj00Oo003o0?l0ooh01Ooo003ooo/00?on
003ooP00ooh00_l0oo`00_l0ood05ol00?l0o`3o0?l0o`00o`3o003o0?l0ooX0
0_l0oo`00_l0ood03_l00?l0o`3o003o0?l0ooh02?l00?l00?l0ooh00_l0oo/0
0=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0001B`3ol@3no`P00?l0ool0
oool0?ko0@00o_l70?oo003oo`3no`00o_l20?l0o?l30?oo0?coo003o`3oooh0
1?l0ool0o_l90?l0ool0ool00?go0`3oo`3no`D00?l0ooon0?_oo@3no`00o_l?
003oo`3o0?l0ool0ool00?goo@3nooh00?ol0?ko2P00o`3oo`00ool0o_l1003m
o`D0o`3oo`3moo`02?l0o`3oo`3ooo`0o_l4003oo`3no`P00?oo003oo`3no`00
o_ol0?ko003nood01_oo0?oo003no`00o_l00?ko0`3oo`3no`D0o`3oo`3mood0
o_ol00?o0?oooP04o`3oo`3no`T0o`3oo`3oo`00oOl30?oo0?ko0P00oo/00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000A03od000ohT00?oP003ooP00
onh00?o@003oj`00ooh00?o8003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[o
o`0003d0om40o_n<007ooml0oOo^0?kodP3non`0oOo7003Bn`00d_/00=;m003o
o_H0n_kf0?[nmPKjm_Koo`0002P0oh40P@2F003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf1?[oo`0002P0oh40P@2F003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKj
m_Koo`0008H0oo400?oh003oo@01oook007oooX00OoooP01oool007oonh00?oj
003om`01ooog007ooo@00Oook`01ooon003okP01oooe007ool`00Oooo001ooo^
003onP00ooL00Ooo^000d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001f
0?ob003om003o`00ooX00?oi00?o003oo003o`00omX00?of003ol`00oo400ol0
0?om003om`00oo`00ol00?of003ob`00oo`00ol00?oJ003o^000d_/00=;k003B
o@00ookf0?[nmP3jo_H6n_Kfool0004B0?oc003ooP3mo`00oOl00?ko0P3ooo/0
1Ooo003oooh00Ol0o_on0?ko0P3oooh00Oooo03no`00o?l00?ko1000ool0o_l3
003oooh00?ol00?oo`00o_l00?kooP01oool00Go003oo`3no`400?ko0@00o_l2
0?ooo@00ood00ooo003nooh0o_l20?oooP01ooom0?ko003no`D0ool0o`3nood0
o_l00?ko003kooh00_oo0?ko003nood0o_l00?kooP3no`80ooon007ooo`0o_l0
0?co003no`@00?oo0?ko0`00ooon003o^000d_/00=;k003Bo@02ooKjo_H0n_kf
0?[nmPCjool0004X0?oc003oo@0?o`3o003o0?l00?l00?l0oo`00_l0ooh01_l0
0?l00?ol00[o003o0?l0o`00ooh00?on01;o0?l00?l0o`00o`00o`00o`3ooP03
o`00ood04Ol00?oo003o0?l00?l0o`00ood05_l0o`00o`3o0?l0o`00o`00o`00
o`3ooP00oo/00ol00?ol00[o003o0?l0o`00ood00_l0ooh01ol0o`3o003oo@04
o`00ooon013o0?l00?l0o`3o003o0?l0oo/00?on00;o0?ol00[o003o0?l0o`00
ooh00?on01;o0?l00?l0o`00o`00o`00o`3ooP03o`00okP00=;k003Bn`00d_d0
0?onmP3jo_H0n_kf1_[fm_oo00017P3ol`00ood03ol0o`3o003o003o003o0?ol
00co0?l00?oo003o003oo006o`00o`3o0?gooP00ooh01ol0o`00o`00o_l>003o
003o0?l00?oo003oo@3lo`@00?l00?ko003mood00Ol0oOl50?l0o`00o_l7003o
003o0?on003oo004ool00?ol00Ko003o0?l0oOom00;o0?on00Oo0?l0o`00ood0
0?on003ooP08o`3o003o0?l0oOl50?l00?ooo@00ooh00_l0oo`01_l00?l0o`3m
ooh00?on00Oo0?l00?l00?ko3P00o`00o`3o003oo`00okP00=;k003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H4n_oo00015`3ol`00ood03ol0o`3o003o003o003o0?ol
00co0?l0o`3o003o003oo007o`00o`3o0?ok003ooP07o`3o003o0?ol00co003o
0?l0o`3o003oo@00ooh01Ol00?l0ood00?oj00;o0?om00Co0?l0oo`01Ol00?l0
ooh00?om00Go0?l00?ol00Oo003o0?l0ooX00_l0ooh01ol0o`3o003oo@04o`00
ooon00Wo0?l00?l0o`3oo@00ood00?on003ooP02o`3oo007o`00o`3o0?ok003o
oP07o`3o003o0?ol00co003o0?l0o`3o003o^000d_/00=;k003Bo@00ookf0?[n
mP3jo_H6n_Kfool0003m0?oc003oo004o`3o003no`L00?l0o`3oood01?l0ool0
n?ol00So0?l0ool0oool0?ko0@00o?l00?[o1@3o0?oo0?_oo@03ool00?go003m
o`80ooom0?ko2@3oo`00o`3oo`3mo`X00?l0o`3oo`00oo`0o_l2003oo008o`3o
0?oo0?ooo@3no`00o_on0?ko0P3oood00ooo003no`d00?oo0?l0ool0ool00?co
o03no`00o_ol00So0?l0ool0oool0?ko0@00o?l00?[o1@3o0?oo0?[o^P00d_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001<0?ob003o_P00ooh00?oV003o
oP00onh00?on003on000oh`00?on003oZP00d_/00=;k003Bo@00ookf0?[nmP3j
o_H6n_Kfool0000l0?oa003o_`3monD0oOo]0?gon000oh/0oOnY003Bn`00d_/0
0=;m00;om_[nmP3jo_H0n_kf1?[oo`0002T0oh40P@2J0?cB0@00o=;k003Bo@00
ookf0?[nmP3jo_H6n_Kfool0000P0?n10840R000d_d00_ofn_kf0?[nmP3jo_H4
n_oo0000803oP@2108P00=;m003oo_H0n_kf0?[nmPKjm_Koo`000200oh40P@28
003Bo@02ooKjo_H0n_kf0?[nmPCjool0000P0?n10840R000d_d00?onmP3jo_H0
n_kf1_[fm_oo0000803oP@2108P00=;m00;om_[nmP3jo_H0n_kf1?[oo`000200
oh40P@28003Bo@00ookf0?[nmP3jo_H6n_Kfool0000P0?n10840R000d_d00_of
n_kf0?[nmP3jo_H4n_oo0000803oP@2108P00=;m003oo_H0n_kf0?[nmPKjm_Ko
o`000200oh40P@28003Bo@02ooKjo_H0n_kf0?[nmPCjool0000P0?n10840R000
d_d00?onmP3jo_H0n_kf1_[fm_oo0000803oP@2108P00=;m00;om_[nmP3jo_H0
n_kf1?[oo`000200oh40P@28003Bo@00ookf0?[nmP3jo_H6n_Kfool0000P0?n1
0840R000d_d00_ofn_kf0?[nmP3jo_H4n_oo0000803oP@2108P00=;m003oo_H0
n_kf0?[nmPKjm_Koo`000200oh40P@28003Bo@02ooKjo_H0n_kf0?[nmPCjool0
000P0?n10840R000d_d00?onmP3jo_H0n_kf1_[fm_oo0000803oP@2108P00=;m
00;om_[nmP3jo_H0n_kf1?[oo`000200oh40P@28003Bo@00ookf0?[nmP3jo_H6
n_Kfool0000P0?n10840R000d_d00_ofn_kf0?[nmP3jo_H4n_oo0000803oP@21
08P00=;m003oo_H0n_kf0?[nmPKjm_Koo`000200oh40P@28003Bo@02ooKjo_H0
n_kf0?[nmPCjool0000P0?n10840R000d_d00?onmP3jo_H0n_kf1_[fm_oo0000
803oP@2108P00=;m00;om_[nmP3jo_H0n_kf1?[oo`000200oh40P@28003Bo@00
ookf0?[nmP3jo_H6n_Kfool0000Y0?n10840VP3ldP400?cBn`00d_d00_ofn_kf
0?[nmP3jo_H4n_oo0000>@3ol03no`800?oZ0?kon`01oon10840c`00d_/00=;k
003Bo@00ookf0?[nmP3jo_H6n_Kfool0000o0_l00?Woo001ooon0?koj@01oook
007ooh40P@3B0?gBn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`0003d3o`00
oo_j0?ol007ooo`00?oY007ooh40P@37003Bn`00d_/00=;m003oo_H0n_kf0?[n
mPKjm_Koo`0005P3o`00oo_j0?om007oooP0o_l30?oo0?go0@00o_l20?oooP06
ool0ool00?kooP3noh40P@3E003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[o
o`0005P3o`00oo_j0?om007oooL0n_l5003oo`00o_l40?oo003no`d0ool00?oo
003oo`3ooh40P@3F003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`000643
o`00oo_j0?om007oood0oOl3003oooh02Ooo003oo`00ooon01?oo`3oo`00ool0
0?oo0?oo003ooh40P@3F003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`00
05X3o`00oo_j0?om007ooo`00OoooP01oool0?go0`00ooon00ooo`3oo`00ool0
0?oo0?ooP@210=800=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000GP?o
003onoX0oo`00Oooo@01ooon007oooh02Ooo003oo`00ooon00ooo`3oo`00ool0
0?oo0?ooP@210=800=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000HP?o
003onoX0oo`00Oooo@01ooon007oooh01ooo003oo`00o_lE0?oo003oo`00ool0
0?oo003oo`00oh40P@3F003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`00
04d2o`00nOoj0?cooP3mo`400?[o1`3oo`3oo`00oOl00?[o0@00o_n10840e@00
d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0000]0?oJ007ooh40P@2o003B
n`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002d0omX00OooP@210;l00=;k
003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000;03of`3moh40P@30003Bn`00
d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002P0oh40P@2J0?cBn`00d_/00=;m
00;om_[nmP3jo_H0n_kf1?[oo`0002@0oh40P@2?003Bn`00d_d00?onmP3jo_H0
n_kf1_[fm_oo0000903oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0
000T0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002@0oh40P@2?
003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000903oP@2108l00=;k003Bo@00
ookf0?[nmP3jo_H6n_Kfool0000T0?n10840S`00d_/00=;m00;om_[nmP3jo_H0
n_kf1?[oo`0002@0oh40P@2?003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000
903oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0000X0?n10840VP3l
d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0001c0?oc0?ko003non800Ooo
m@3noo400Oool@00onh00?o_007oooH01?oo003oi@01oooe0?ko0P00oo<00?og
007oood00?o/007oooP00OooZ000d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCj
ool0001e0?ob003ooP00on<00ol00?of003om@00oo`00?o/003om000on/00?oe
003ok`00ooL00ol00?of00?o003oi000ooL00?ok003on000ooL00?n[0?gBn`00
d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`000@D0oo800?on00Go003oo`3no`80
ooom00?oo`00o_l20?ooo@3no`80ooon007oood0o?l00?ko003kooh0o_l00?ko
1@3oo`3o0?kooP02ool0o_l30?oo0?co0@00o?l1003no`00o_on0?koo@07o`00
ool0ooon0?ko0`3oo`3no`400?koo03no`00o_om0?ko0P3oooh00Oooo000ood0
1_oo003oo`3jo`<0ool0o_on0?ko0P3o0?goo@3no`<0ool0nOon007oooh00ooo
003no`00o_l00?ko003nok@00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo
00017`3olP3lo`/0o`00o`3o0?l00?ol00So003o0?l00?om00[o003o0?l0o`00
ood02?l00?l00?l0ood00?ol00;o0?on00Oo0?l0o`00oo`02_l00?l0o`00o`3o
oP08o`00o`00o`3ooP06o`3o0?l0ooX06_l0o`00o`00o`3o003o003o003o0?l0
o`00oo`00_l0ooh00?om00[o003o0?l0o`00oo`00OoooP0Fo`3o003o0?l00?l0
0?l0o`00o`3o0?om00Go0?l00?ol00[o0?l00?l0o`00ooh04ol00?l0o`3o003o
o`00o`00o`3ooP04o`3o0?ne003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Ko
o`000AD0oo800?on007o0?go0P3o0?goo@05ool00?l0oOom00Ko003o0?l0oOom
00go003o003o003oo`00oo`00_l0ooh01ol0o`3o003oo004o`00o`3mo`d0o`00
ool00?l00?l0ooh02?l0o`3o003ooo`00Ol0oOlA0?oo0?l00?l00?l00?l0o`00
o_ol00;o0?on003oo@06o`00o`3o0?gonP04o`00o`3moaH0o`00o`00o`3o003o
0?l00?oo003oooh00?ol007o0?go3P3o003o003oo`00o`3o0?co1`00o`00o`3o
oP04o`3o0?ne003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`000A@0oo80
0?on00;o0?om00;o0?ok00Oo0?l00?l0ooX01ol00?l0o`3onP06o`00o`00ood0
0_l0oo`00_l0ooh01ol0o`3o003oo005o`00o`3oo@0<o`3o0?l00?l00?l0ooh0
1?l0o`3oo@00ood00_l0ooh04Ol0o`3o003o003o003o0?l0ooT00_l0ooh00?om
00Oo003o0?l0ooX02?l00?l00?l0ood03Ol00?l00?l0o`00o`3oo@07o`3o0?l0
0?ol00;o0?om00ko003o0?l0o`00o`3o0?on00So003o003o0?on00Co0?l0okD0
0=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo00012@3ol`3no`00o_l90?oo
003oo`3ooo`0o_l50?oo0?oon`08o`3o0?oo0?ooo@3ko`00o?on003ooP3no`00
o_on0?ko0P3oooh0o_l:003o0?oo003oo`3no`400?go003no`<00?l0o?om0?ko
103oo`00o_l00?[o1@3o0?oo0?goo001o`3noo/02?l0o`3oo`3ooo`0o_l1003n
o`L0ool00?oo0?ko003no`80o`3lo`<0ool0o?ol00?o0?oooP04o`3oo`3no`T0
o`3oo`3oo`00oOl30?oo0?ko0`00o`3nokL00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H4n_oo0000=03oP@3K003ooP00om<00?n10?000=;k003Bn`00d_d00?on
mP3jo_H0n_kf1_[fm_oo0000<03oP@3K0?god`3noh40l@00d_/00=;k003Bo@02
ooKjo_H0n_kf0?[nmPCjool0000X0?n10840UP00d_/00=;k003Bo@00ookf0?[n
mP3jo_H6n_Kfool0000X0?n10840VP3ld_/00=;k003Bo@02ooKjo_H0n_kf0?[n
mPCjool0000T0?n10840S`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002@0
oh40P@2?003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000903oP@2108l00=;k
003Bo@00ookf0?[nmP3jo_H6n_Kfool0000T0?n10840S`00d_/00=;m00;om_[n
mP3jo_H0n_kf1?[oo`0002@0oh40P@2?003Bn`00d_d00?onmP3jo_H0n_kf1_[f
m_oo0000903oP@2108l00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0000T0?n1
0840S`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0002@0oh40P@2?003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000:03oP@2109X0o=;k003Bn`00d_d00?on
mP3jo_H0n_kf1_[fm_oo0000:03oP@2109H00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H4n_oo0000:03oP@2109T0oM;k003Bn`00d_d00?onmP3jo_H0n_kf1_[f
m_oo0000:03oP@2109H00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000
:03oP@2109H00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000:03oP@21
09H00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000:03oP@2109H00=;k
003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000:03oP@2109H00=;k003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000:03oP@2109H00=;k003Bn`00d_d00?on
mP3jo_H0n_kf1_[fm_oo0000;P3oP`00oh40l`00oj@00=;k003Bn`00d_d00_of
n_kf0?[nmP3jo_H4n_oo0000;P3oQ03noh40m@3nojD00=;k003Bn`00d_d00?on
mP3jo_H0n_kf1_[fm_oo0000=03oQ@03ogkooh40mP03oeKoojD00=;k003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000=P3oQ@04ooYnoon10?L01?mno`;oYP00
d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0000h0?n600GoEWiFoon10?P0
1OmnEWkoojH00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000?03oQ`07
ooYnnWko0_n10?X01omnnWkjo`;oY`00d_/00=;k003Bo@00ookf0?[nmP3jo_H6
n_Kfool0000m0?n700OoOUInE_l>oh40nP08oeInEWko0PkoZ000d_/00=;k003B
o@02ooKjo_H0n_kf0?[nmPCjool000100?n800WoO_YnnWko0P;oP@3l00WonWkj
O_[o0P;oZ000d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool000130?n900[o
OUInEWiFo`h2oh40o@0;oeInEWiFO_l23P;oZ@00d_/00=;k003Bo@02ooKjo_H0
n_kf0?[nmPCjool000140?n900_onWkjO_Ynn_l20_n10?h01omnnWkjO_[ooP80
ojT00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000A`3oRP0=oeInEWiF
OUIno`8>0_n100h0ogiFOUInEWko0Ph23_nZ003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf1?[oo`0004P0oh/02_ojO_YnnWkjO_[ooP80oh402_mnnWkjO_YnnWko
oP80ojX00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000C03oS00@oeIn
EWiFOUInEWko0Ph23_n3013oOUInEWiFOUInE_l>0Ph2oj/00=;k003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H4n_oo0000BP3oS00;ogkjO_YnnWkjO_[oo@80oh<02ooj
O_YnnWkjO_Ynood20?n[003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`00
0500ohd04_mnEWiFOUInEWiFO_l23P8>0_n501;oEWiFOUInEWiFOUKo3P8>0Pko
[000d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001?0?n>00koO_YnnWkj
O_YnnWkjO_om0P3oQP0=ooYnnWkjO_YnnWkjO_ok0P3o[@00d_/00=;k003Bo@00
ookf0?[nmP3jo_H6n_Kfool0001D0?n>01CoEWiFOUInEWiFOUInE_l>0Ph23_n7
01CoOUInEWiFOUInEWiFo`h23P8>0_n]003Bn`00d_/00=;m00;om_[nmP3jo_H0
n_kf1?[oo`000540ohl03oojO_YnnWkjO_YnnWkjO_ol0P3oR00>ogkjO_YnnWkj
O_YnnWkonP80ojh00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000FP3o
T00GoeInEWiFOUInEWiFOUInE_l>0Ph23P;oRP0GogiFOUInEWiFOUInEWiFO_l2
3P8>0Pko[P00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001B0?n@013o
O_YnnWkjO_YnnWkjO_Ynoo/20?n:0?go37kjO_YnnWkjO_Ynn_om0_go[`00d_/0
0=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0001G0?nA01WoOUInEWiFOUInEWiF
OUInE_l>0Ph23P8>oh`0o_l1003io`EFOUIno`;mo`;hoon_003Bn`00d_/00=;m
00;om_[nmP3jo_H0n_kf1?[oo`000540oi804_mnnWkjO_YnnWkjO_YnnWkjO_oj
0P3oS@03oo[oooL0noon00CoO_l2ok000=;k003Bn`00d_d00?onmP3jo_H0n_kf
1_[fm_oo0000F03oTP0KoeInEWiFOUInEWiFOUInEWiFO_l23P8>0Ph2ohh01?mn
o`;om@3no`L00?mnn7kook000=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo
0000F@3oT`0DooYnnWkjO_YnnWkjO_YnnWkjO_[onP80ohl01OmnnWkoooH03?oj
ool0ogkjO_[o0_na003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`000640
oi@07_mFOUInEWiFOUInEWiFOUInEWiFO_l23P8>0Ph23_nA00OoOUInE_ogooL0
0_mnE_ko1_Qnn7ko0_na003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[oo`00
05l0oi@05OmnnWkjO_YnnWkjO_YnnWkjO_Ynn_oi0P3oT@08ooYnnWko0P;on@0>
ogkjO_oonWkjO_[o0P;o/P00d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0
001X0?nE023oOUInEWiFOUInEWiFOUInEWiFOUIno`8>0Ph23P8>0_nC00WoEWiF
OUKom`;onP0?ogiFOUKo3_ohO_Qno`8>ok800=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H4n_oo0000IP3oUP0GogkjO_YnnWkjO_YnnWkjO_YnnWkjO_[om`80oiD0
1oojO_YnnWkooP80oo/03?ojO_Yno`82ooYnn_on0P3o/`00d_/00=;k003Bo@00
ookf0?[nmP3jo_H6n_Kfool0001^0?nF02;oEWiFOUInEWiFOUInEWiFOUInEWiF
OUKo3P8>0Ph23P8>oiD02omnEWiFOUKom`;goo`04OmFOUInE_l>0_mnn7ko0Ph2
ok<00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000K03oU`0IooYnnWkj
O_YnnWkjO_YnnWkjO_YnnWkjO_og0P3oU`08ogkjO_YnnWkoo@80ooh03oojO_Yn
nWkjo`82ogkjO_on0P3o]000d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0
001f0?nH02GoEWiFOUInEWiFOUInEWiFOUInEWiFOUInE_l>0Ph23P8>0Ph2oiP0
3_mnEWiFOUInEWko0_L2ooh04omnEWiFOUIno`8>ooQnn?l>0Pko]000d_/00=;k
003Bo@02ooKjo_H0n_kf0?[nmPCjool0001`0?nI01_onWkjO_YnnWkjO_YnnWkj
O_YnnWkjO_YnnWkomP80oiX02omnnWkjO_YnnWkjood22ol0ogkjO_YnnWkjooh2
0oojO_om0P3o]@00d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool0001j0?nI
02OoOUInEWiFOUInEWiFOUInEWiFOUInEWiFOUKo3P8>0Ph23P8>0PkoVP0WoeIn
EWiFOUInEWko0_L2moooOUInEWiFOUIno`8>0_mnn?l>0Ph2okD00=;k003Bn`00
d_d00_ofn_kf0?[nmP3jo_H4n_oo0000L@3oVP0LogkjO_YnnWkjO_YnnWkjO_Yn
nWkjO_YnnWkjO_oe0P3oW00<ooYnnWkjO_YnnWkjood22omnnWkjO_YnnWkjood2
0_mnoo`20?nf003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`000800oi/0
:_mnEWiFOUInEWiFOUInEWiFOUInEWiFOUInEWiFO_l23P8>0Ph23P8>0_nM02[o
EWiFOUInEWiFOUIno`;g0_OoEWiFOUInEWiFO_l23P8>ooSo3P8>0Pko]P00d_/0
0=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0001e0?nK01konWkjO_YnnWkjO_Yn
nWkjO_YnnWkjO_YnnWkjO_[om@80oih03OmnnWkjO_YnnWkjO_[ooP8=ooYnnWkj
O_YnnWkjO_om0P7ooo/20?ng003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Ko
o`0008@0oi`0;?mFOUInEWiFOUInEWiFOUInEWiFOUInEWiFOUInEWko0Ph23P8>
0Ph23P8>oil0;?mnEWiFOUInEWiFOUIno`;goeInEWiFOUInEWiFOUKo3P8>0Pko
o`8>0Ph2okL00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000N@3oW@0P
ooYnnWkjO_YnnWkjO_YnnWkjO_YnnWkjO_YnnWkjO_[om`;moj408?mnnWkjO_Yn
nWkjO_YnnWko0_mnnWkjO_YnnWkjO_Ynoo`20OoooP;mokP00=;k003Bn`00d_d0
0?onmP3jo_H0n_kf1_[fm_oo0000Q@3oW@3nob]nEWiFOUInEWiFOUInEWiFOUIn
EWiFOUInEWiFO_l23P8>0Ph23P;oog[ooj40oOlTOUInEWiFOUInEWiFoomnEWiF
OUInEWiFOUInE_l>0Ph23P;o0_ko0UcookP00=;k003Bn`00d_d00_ofn_kf0?[n
mP3jo_H4n_oo0000N@3oWP3no`00n_lFO_YnnWkjO_YnnWkjO_YnnWkjO_Ynn_oj
0_ko1?UJnOooX`3no`400?Wo5?YnnWkoO_YnnWkjO_YnnWkjO_Ynoo/22?oo0?mJ
nE[ookT00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000N`3oW`04ogko
mOoj0?_o7eInEWiFOUInEWiFOUInEWiFo`h23P;oo`00oeajG?ooY004oeKo0_oh
0?[o4eInEWiFOUInEWiFOUIno`8>0PkooP05ogYLN_oo^@00d_/00=;k003Bo@02
ooKjo_H0n_kf0?[nmPCjool0001a0?nO00Con_l2oo@0n_l:nWkjO_YnnWkjO_on
0P3ooP07oe[iF_Wo0_nU00CoO_l>oo40o?l=nWkjO_YnnWkjo`82ooon00OonE[i
F_l2okX00=;k003Bn`00d_d00?onmP3jo_H0n_kf1_[fm_oo0000I`3oX006oeIn
E_l2onh0n_l6EWiFo`koooh02?mLNUajG?l2ojH01_mnEWkomOo]0?_o1GiFO_l2
ood02?mjG7YLN_l>okX00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000
G`3oX@07ooYnnWko3_oW0?coo@0:oe[iF_UJnOl20_nX00SoO_Ynn_l23_oX0?co
o@0:ooUJnE[iF_l20_nk003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`00
0640oj402?mnEWiFo`;eonH0o_om00[oNUajG7YLN_l>ojT02OmnEWiFO_oe0_oV
0?koo@0:oeajG7YLNUco0_nk003Bn`00d_/00=;m00;om_[nmP3jo_H0n_kf1?[o
o`0006h0oj802_mnnWkjO_l>0Pkoj003ogkoooh03?oiF_UJnE[iF_l20_nZ00[o
nWkjO_[o0Ph2onP00oojooon00coF_UJnE[iF_Wo0P;o_000d_/00=;k003Bo@00
ookf0?[nmP3jo_H6n_Kfool0001a0?nS00_oOUInEWiFo`;e0_oX01?oEWkoo`3o
NUajG7YLNUajo`h2oj/03?mFOUInEWkom@;e0_oY01?oOUKoo`3oG7YLNUajG7YL
o`8>ok`00=;k003Bn`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000N03oX`0<ooYn
nWkjO_l>0Ph2onX04OojO_[o0_ooF_UJnE[iF_UJooh20?n]00konWkjO_Ynn_l2
3P8>0_o[00?oO_Yno_l:F_UJnE[iF_UJnOon0P3o_@00d_/00=;k003Bo@00ookf
0?[nmP3jo_H6n_Kfool0001l0?nT00koEWiFOUInE_l2m@;e0_o/01KoEWiFO_l2
oeajG7YLNUajG7[o3P8>ojd03_mnEWiFOUInooD2m@;eon`05_mnEWiFo`koNUaj
G7YLNUajG?l23P;o_@00d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool00022
0?nU00oonWkjO_YnnWkjo`8>0Pkok00CogkjO_[o0P;oF_UJnE[iF_UJnOon0P3o
[`0@ogkjO_YnnWkjO_l>0Ph23_o^01CoO_YnnWko0P;onE[iF_UJnE[iF_on0P3o
_P00d_/00=;k003Bo@00ookf0?[nmP3jo_H6n_Kfool000260?nU013oOUInEWiF
OUInooD2m@;eonh06?mnEWiFO_l23_mjG7YLNUajG7YLo`8>0_n`01;oOUInEWiF
OUInE_l2m@;e0_Gok`0HoeInEWiFo`h2oeajG7YLNUajG7[o3P8>okh00=;k003B
n`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000RP3oYP0AogkjO_YnnWkjO_[o0Ph2
3P;ok`0EogkjO_YnnWko0P;onE[iF_UJnE[iood20?nb01?oO_YnnWkjO_YnnWko
3P8>0Ph2oo001oojO_YnnWkooP8:oe[iF_UJnE[iF_om0P3o_`00d_/00=;k003B
o@00ookf0?[nmP3jo_H6n_Kfool0002B0?nW01?oOUInEWiFOUInEWkom@;e0_D2
oo407?mnEWiFOUInE_l>0_mLNUajG7YLNUco0Ph23P;o/`0DoeInEWiFOUInEWiF
o`;e0_D2m@;olP0KoeInEWiFOUIno`8>ogYLNUajG7YLN_l>0Ph2okl00=;k003B
n`00d_d00_ofn_kf0?[nmP3jo_H4n_oo0000TP3oY`0DooYnnWkjO_YnnWkjo`8>
0Ph23P;olP09ooYnnWkjO_Ynooh22OmJnE[iF_UJnOol0P3o]00FooYnnWkjO_Yn
nWkjO_l>0Ph23P8>0_oc00WoO_YnnWkjO_[ooP89ooUJnE[iF_UJooh2o_o0003B
n`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`0009/0ojP05OmFOUInEWiFOUIn
EWkom@;e0_D2mOoc01koEWiFOUInEWiFo`h23P;oG7YLNUajG7[o3P8>0Pko]P0G
oeInEWiFOUInEWiFOUKo0_D2m@;e0_Gom00MogiFOUInEWiFO_l23P;oG7YLNUaj
G7YLo`;oG?oo`000d_/00=;k003Bo@02ooKjo_H0n_kf0?[nmPCjool0002G0?nX
01KoO_YnnWkjO_YnnWkjo`8>0Ph23P8>ooD02oojO_YnnWkjO_Ynood22OoiF_UJ
nE[iF_ol0P3o]P0EooojO_YnnWkjO_YnnWko3P8>0Ph23_komP0;ogkjO_YnnWkj
O_[oo@;ko`WiF_Wooe[iF_oo`@00d_/00=;k003Bo@00ookf0?[nmP3jo_H2n_Kf
o_l0002J0?nY01SoOUInEWiFOUInEWiFOUKo0_D2m@;e0_GomP0PogiFOUInEWiF
OUKo3P8>0PkoNUajG7YLN_l>0Ph23P;o^03joa9nEWiFOUInEWkom@;e0_ooO_oo
mP0@oeInEWiFOUInEWko0Ph23_ol0?co17YLN_oo`@00d_/00=;k003Bo@02ooKj
o_H0n_kf0?[nmPCjool0002O0?nZ01WoO_YnnWkjO_YnnWkjO_Yno`h23P8>0Ph2
ooL03OmnnWkjO_YnnWkjO_[oo@88oe[iF_UJnE[on`80okT01?mnob_ooP3noa1n
nWkjO_[o0Pkoo`3on_l2ooP03?ojO_YnnWkjO_Ynn_ol0P3on`3no`EJnE[o0_o2
003Bn`00d_/00=;m003oo_H0n_kf0?[nmPKjm_Koo`000:T0ojX06_mFOUInEWiF
OUInEWiFOUKo0_D2m@;e0_D2ooT08omnEWiFOUInEWiFOUIno`8>0Ph2oeajG7YL
N_l>0Ph23P8>okX01?mFo`;on`3mo`eFO_oeo`00ooQnooD2ooX05?mFOUInEWiF
OUInEWiFo`h23P8>ood02OmLoomjG7[o3_o2003Bn`00d_/00=;m00;om_[nmP3j
o_H0n_kf1?[oo`000?l\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{401, 258},
  ImageMargins->{{0, Inherited}, {Inherited, Inherited}}],

Cell["\<\
Almost any feature of a notebook can be changed using the Option \
Inspector, available under the Format menu.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Characters", "Subsection"],

Cell[TextData[{
  "There are several ways to enter special characters into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". We can click a button in a palette to place a special character inside \
the current notebook at the text insertion point; clicking a button \
containing an alpha character \[Alpha] places an alpha at the current \
insertion point. A palette containing every character in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " character set can be opened by pulling down the File menu and choosing ",
  StyleBox["CompleteCharacters", "MenuItem"],
  " from the Palettes submenu."
}], "Text"],

Cell[TextData[{
  "Every special character has a full name of the form ",
  StyleBox["\\\[InvisibleSpace][", "Input"],
  StyleBox["FullName",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ". The character \[Pi] has the full name ",
  Cell[TextData["\\\[InvisibleSpace][Pi]"], "Input"],
  ", and the character \[CapitalPi] has the full name ",
  Cell[TextData["\\\[InvisibleSpace][CapitalPi]"], "Input"],
  "; ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usually converts the form ",
  Cell[TextData["\\\[InvisibleSpace][Pi]"], "Input"],
  " to the \[Pi] character when we type the closing square bracket. Like all \
other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " objects, character names are case sensitive."
}], "Text"],

Cell[TextData[{
  "Many special characters have keyboard aliases of the form \
\[AliasIndicator]",
  StyleBox["alias",
    FontSlant->"Italic"],
  "\[AliasIndicator], where we press the Escape key to create the \
\[AliasIndicator] character. To enter \[Pi] into a notebook, we type \
\[AliasIndicator]p\[AliasIndicator] (that is, \[EscapeKey]p\[EscapeKey]); to \
enter \[CapitalGamma] we type \[AliasIndicator]G\[AliasIndicator]. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " converts a keyboard alias into the corresponding special character when \
we type the second \[AliasIndicator] character."
}], "Text"],

Cell[TextData[{
  "When we use the ",
  StyleBox["CompleteCharacters", "MenuItem"],
  " palette, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " displays the full name and keyboard alias (if one is defined) for a \
character when the mouse pointer is over the character. A complete listing of \
characters in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " character set can be found in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Two-Dimensional Input", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " understands many two-dimensional and other special forms of mathematical \
functions, and we enter these forms using palettes. To enter an integral, we \
click a button containing the form ",
  Cell[BoxData[
      StyleBox[
        \(\[Integral]\[SelectionPlaceholder] \[DifferentialD]\[Placeholder]\),
        
        "Input"]]],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pastes an empty template for an integral into the notebook, after which \
we type the desired functions and variables into the proper spaces. \
Similarly, to enter a superscript (usually interpreted as an exponent), we \
click a button containing the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\^\[Placeholder]\)]],
  ", and to enter a subscript, we press a button containing the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\_\[Placeholder]\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["BasicInput", "MenuItem"],
  " and ",
  StyleBox["BasicTypesetting", "MenuItem"],
  " palettes, available in the Palettes submenu of the File menu, contain \
templates for many types of two-dimensional typeset forms, and ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " contains a complete listing of the typeset forms that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " understands."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Different Forms of Input and Output", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " understands a few different forms of input and output. By default, input \
and output are in a form called ",
  StyleBox["StandardForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which is an unambiguous two-dimensional form that uses the \
capitalization and bracketing conventions described earlier."
}], "Text"],

Cell[TextData[{
  "We can convert any input or output to ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which follows the rules of traditional typeset notation. For example, \
here is some ",
  StyleBox["StandardForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " input and output."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\(1\/\(x\^3 - 1\)\) \[DifferentialD]x\)], "Input"],

Cell[TextData[{
  "To convert the input and output to traditional mathematical notation, we \
select the input and output cells, pull down the ",
  "Cell",
  " menu, and choose ",
  StyleBox["TraditionalForm", "MenuItem"],
  " from the ",
  StyleBox["Convert To", "MenuItem"],
  " submenu. Here is the result, which uses the conventions of traditional \
mathematical typesetting."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(1\/\(x\^3 - 1\)\) \[DifferentialD]x\)], 
  "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Entering Hyperlinks", "Subsection"],

Cell[TextData[{
  "To enter a hyperlink into a notebook, we first select the destination of \
the link (where the link should jump to), then add a ",
  StyleBox["tag",
    FontSlant->"Italic"],
  " to the cell containing the destination. A tag is a label associated with \
a cell, which allows us to refer to the cell using programming functions."
}], "Text"],

Cell["\<\
Here we select a cell to be the destination of the hyperlink.\
\>", 
  "Text"],

Cell[GraphicsData["PICT", "\<\
?]80B0180C<22P0A0_l<0?ooool0B00004P0008:0001<`000000000100X0B018
0C<22P2HPL80B0180C<22P000000000004P0001800000008004020000002dFD/
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000B018
0C<22P1804P1<`8:00002X7oPOn1ol3o00003P3oPB^1:h4[`b/2E?oo00l1ob^1
mH7ePOG4m@9Dool03`7o:h7ePOF1mLCe0UCoo`0Q0Ol[noX0mOJ/0?F1n]cj]OF1
n]_j0?Gf[03enoX2E?oo02`1ob_jm@2/mb^1mM?eoOonm@7oon[e0Oooj?D1oon1
mM?e0:cg:o[e0UCoo`120Ol[noX2mJ`[n_P2[2_ePO[Ln_[e0Oooo_D4ooGeoooZ
m@7oonWeo_ojmH7jfoX2mJ`[oOP5[?Sh[2_enoX2E?oo04`1ob_jm@6/:o[h0J`[
POGDm@7ooo_eo?ommOgoo_GlookeoOonmOgoo_D4oooeooojm@?omOooPOGCm@6/
:ogh1:chn:`[n_D2E?oo06@1ob_knP;e[2_jn0:/:oF1n]cjn_D1oookm@SoooGe
oooemOonm@WoooGeoooemOooo_D1ooonm@OoooGeoooemOkonOD4ooGeooojmH7j
foX2mJ`[oOP5[?Sh[2_enoX2E?oo05X1ob_jm@6/:o[h0J`[POGDm@7ooo_e1Ooo
mOGoookeo?l7mOGoooGeooonm@7oooke2OoomOGoooGeoooim@3oo_D1oon1mM?e
0J`[oOP4[?Sh[2_jm@9Dool0F`7o:o_j0_F/:o[h0Z`[mH7jg?[jm@7ooo_e5Ooo
mOGoooGeoooemOoomOGoooGeooonm@7oookenol3mOGoooWen_okmH7jfoX2mJ`[
o:`4n?R/:oGknP9Dool0D`7o:o[e0J`[n_P1[2^1mMCe0OoonoDEoooemOoomOGo
ooGeoooemOoomOGoooke0Oooo_D1oookm@7oooGe0OooPOGCm@6/:o[h0J`[n_D2
E?oo0641ob_knP;e[2_jn0:/:oF1n]cjn_D1ooonmASomOGoooGeoooemOoomOGo
ooGeoooemOooo_D1ooonm@7oooke1?oemOoomOD1ooojmH7jfoX2mJ`[n_P2[2_e
noX2E?oo04P1ob_jm@6/:oV/02^1mM?eoOonm@GoooGeooonmOco0OGeo?olm@7o
ookeoOonm@7oooGe0OooPOGCm@6/:oV/02_jm@9Dool0:07o:o_j0OF/mb/0mH7j
g?[Rm@7oomKePO[KnP7e[?L[0?GknP9Dool04P7o:h7eZ_D1oon1mIge0UCoo`0?
0Ol[POF1mH7ea?D2E?oo00d0oh5DPEB1E<9D0Ooo00R1oh7oPOnoo`0d0?n10;@0
o_oX003om@00ood0o?od007oood00ol0oon10?@00=;k003Bo@00oo@00_[oo`0g
0?n10;400Oooj@01ooof003on@3looL00OoooP03ool0oh40m@00d_/00=;m007o
0?Gf0_[oo`0l0?n10:l00Oooj@00ooH00?oi003ooP3mooT0o_l4003o0?n10?H0
0=;k003Bo@01o`3lmP2/noH2n_oo03d0oh40[@01oooZ007oooL00?oj003onP3l
oo/00_oo0?koP@3g003Bn`00d_d00Ol0oOH2[5B/o?H2n_oo03d0oh40Z`3non/0
0?og003onP00ooH0oOom00Coo`3ooh40n000d_/00=;m007o0?kf0:cnE02/oOH2
n_oo03h0oh40Z001ooo/007oooP00?oj003ol`3lo`00oOl00?koP@3m003Bn`00
d_d01?l0m_J/o5@0[?kf0_[oo`0d0?n10:H00Oook000ooP00Ooon`00onl0mon1
0?h00=;k003Bo@03o`3f[?YD1Jcfm_[oo`0d0?n10:@00Oook@01oooh003on`00
on/0o?n10?h00=;k003Bo@01o`3m[?iDoJ`3m_[oo`0e0?n10:80o_o^003on000
oo/00?o/0?coP@3n003Bn`00d_d00Ol0o_H0[?iD0:cmmP;jool0=`3oP@2O007o
onl00Ooon@00oo/00?o/0?koP@3m003Bn`00d_d00Ol0o_H0[?iD0:cmmP;jool0
<P3oP@2M007oonl00?oi003on`00oh40iP00d_/00=;m007o0?kf0:cnE02/oOH2
n_oo02h0oh40V`3noo400OoonP00oo/00?n10>L00=;k003Bo@01o`3nm_b/oOH2
n_oo02X0oh40V001oooa003onP00oo/00?n10>P00=;k003Bo@01o`3emP;jool0
:P3oP@2F007ooo800Ooon`01oool003oP@3Y003Bn`00d_d00?ocnP7oo`0S0?n1
09@00OoolP00ooX00?om003oP@3Y003Bn`00d_d0l?l0<`3oP@2B0?kom001oook
003oo@00oh40jP00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0c0?n108l00Ooo
m000oo/00?om003oP@3[003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo03@0oh40
S@01oooe007ooo`00?om003oP@3/003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo
03<0oh40R`01oooe003oo000ood00?n10>d00=;k003Bo@00ookf0?[nmP3jo_H4
n_Kfool0<`3oP@290?kom`01ooom003oo@00oh40kP00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[oo`0d0?n108H00Ooom`00ood00OoooP00oh40k`00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Koo`0d0?n108@00Ooon001ooom003ooP00oh40l000d_/0
0=;m00;om_[nmP3jo_H0n_kf0_[oo`0b0?n10880o_oi003oo@00ooh00?n10?40
0=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0=P3oP@2100<00?oonP01ooon003o
oP00oh40lP00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0d0?n10840o@01oooj
003ooP03o`00oh40lP00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0d0?n10840
n`01oook00Ooo`00o`00oh40l`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0b
0?n10840n@3noo`01_l00?l00?n10?@00=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
ool0<`3oP@210?H00Oooo@06ool0o`00oh40m@00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[oo`0b0?n10840m001ooom00Go0?oo0?n10?H00=;k003Bo@00ookf0?[n
mP3jo_H4n_Kfool0<P3oP@210?800OoooP05ool0o`3oP@3g003Bn`00d_d00_of
n_kf0?[nmP3jo_H2n_oo0300oh40P@3`0?ko1P00o`3o0?n10?P00=;k003Bo@00
ookf0?[nmP3jo_H4n_Kfool0;`3oP@210>d00_oo0?ko0@3oP@3i003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo02h0oh40P@3[00Koo`3oo`3oP@3j003Bn`00d_d0
0?onmP3jo_H0n_kf1?[fm_oo02`0oh40P@3Y0?go003noh40o@00d_/00=;m00;o
m_[nmP3jo_H0n_kf0_[oo`0X0?n10840iP3koh40oP00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`0X0?n10840i@3loh40oP00d_/00=;m00;om_[nmP3jo_H0n_kf
0_[oo`0X0?n10840i@3loh40oP00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0X
0?n10840i03noh40o@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0T0?n10840
P@3M003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210=d00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jool0903oP@210840g@00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`0T0?n10840P@3M003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo
02@0oh40P@210=d00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0903oP@210840
g@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0T0?n10840P@3M003Bn`00d_d0
0?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210>40o=;k003Bo@02ooKjo_H0n_kf
0?[nmP;jool0803oP@210840eP00d_d00?onmP3jo_H0n_kf1?[fm_oo0200oh40
P@210=H00=;m00;om_[nmP3jo_H0n_kf0_[oo`0P0?n10840P@3F003Bo@00ookf
0?[nmP3jo_H4n_Kfool0803oP@210840eP00d_d00_ofn_kf0?[nmP3jo_H2n_oo
0200oh40P@210=H00=;m003oo_H0n_kf0?[nmPCjm_Koo`0P0?n10840P@3F003B
o@02ooKjo_H0n_kf0?[nmP;jool0903oP@210840h@3loo/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`0T0?n10840P@3R0?[oo000d_d00_ofn_kf0?[nmP3jo_H2n_oo
02P0oh40P@210>800?ol3P3oo000d_d00?onmP3jo_H0n_kf1?[fm_oo02L0oh40
P@210>80o?l13_ol003Bo@02ooKjo_H0n_kf0?[nmP;jool0A@3on`3lo`80oooC
003ooP00onH00?ol003ooP00oh40P@39007oood>1_l00?l00=;m003oo_H0n_kf
0?[nmPCjm_Koo`160?ok007oon00o_on0?kom`03o`00onD00?ol00?o003oP@21
0<P0o?l73_l00?l00=;m00;om_[nmP3jo_H0n_kf0_[oo`1e0?ok007oood04ooo
003oo`3o0?oo0?oo0?l0ool0o_ol00[oo`3oo`3oo`3oooT00ol00?oc007oooh0
0ol0ooon00?oo`3oo@03o`00oh40P@370?co30ko003o003B0?l00?onmP3jo_H0
n_kf1?[fm_oo06d0oo/0oOl@003oo`3oo`3oo`3oo`3oo`3no`D0ool0oooj007o
ood00Ooon@3noo<04?l00?l00?oo003o0?l00?ooo@3noh40P@360?co10ko003o
oP00ooh00_ofn_kf0?[nmP3jo_H2n_oo07X0oo/00Oooo@0Bool0o`00ool0ool0
ool0ool00?con`01ooom007oooP00_l0ooh0oOoi0?ko0P00ooh00_l0ooh00?om
00;o0?om007ooo/00OooP@210=@0o?l73_l00?l00?om003oo_H0n_kf0?[nmPCj
m_Koo`1l0?ok007oood05?oo0?l00?oo0?oo0?oo0?oo003oooT00Oooo@01oooh
003ooP03o`00ooL01_l00?l00?on00;o0?on003ooP00ooh01_l00?l00?om00?o
003oP@210=D0o?l63_l00?l0ooL00OKjo_H0n_kf0_[oo`1i0?ok007oood05ooo
0?oo0?oo0?oo0?oo0?oo003oo`3oood00Oooo@01ooog003ooP02o`00o_oi00Ko
003o003ooP06o`3o003oooh00?on003oo000ooX00?n10840e@3lo`<>o`00mOl0
0?kf0?[nmPCjm_Koo`1h0?ok007oood00ooo003mo`P00?oo0?l0ooon0?koo03l
o`00o?l20?ooo@00ood00?om003on@05ool0o`3ooP06o`00ool0ooh00?om003o
oP00ooX00?n10840e03lo`H>o`00o`3om`01m_[nmP3jo_H2n_oo03P0onl00Ooo
d@00om`00?oj003oP@210=D0o?l73_l00?l00?om003oo_H0n_kf0?[nmPCjm_Ko
o`110?oa0?kod`03o`00oml00ol00?om00?o003oP@210=D0o?l43_l00?on003o
oP02ooKjo_H0n_kf0?[nmP;jool0>P3o_`01oooM007oooh01?l00?ooP@210=@0
o?l<3_l00?l00=80o`00ookf0?[nmP3jo_H4n_Kfool0:`3oU000oh40P@3@0?co
1`ko003o003Bo@02ooKjo_H0n_kf0?[nmP;jool0;03oU@00oh40P@3?003oo0h6
o`00o`00d_d00?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210>80n_ol003Bo@02
ooKjo_H0n_kf0?[nmP;jool0903oP@210840h@3loo/00=;m003oo_H0n_kf0?[n
mPCjm_Koo`0P0?n10840P@3F003Bo@02ooKjo_H0n_kf0?[nmP;jool0803oP@21
0840eP00d_d00?onmP3jo_H0n_kf1?[fm_oo0200oh40P@210=H00=;m00;om_[n
mP3jo_H0n_kf0_[oo`0P0?n10840P@3F003Bo@00ookf0?[nmP3jo_H4n_Kfool0
803oP@210840eP00d_d00_ofn_kf0?[nmP3jo_H2n_oo0200oh40P@210=H00=;m
003oo_H0n_kf0?[nmPCjm_Koo`0T0?n10840P@3Q0?cBn`00d_d00_ofn_kf0?[n
mP3jo_H2n_oo02@0oh40P@210=d00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
903oP@210840h03md_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0T0?n10840P@3M
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0300ohD0oOl00?coP@3M0?go003l
oi400=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0<03oQ@3mo`00o?n10=d0oOl0
0?coT@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0d0?n4007oooh00OooP@3J
007oooh00OooS`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0b0?n400Goo`00
oon10=T01Ooo003oohh00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0<P3oQ@05
ool00?ooP@3I00Goo`00oon=003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo02P0
ohD0o?n10=P0o?n<003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo03@0ohD0o?ol
0?coP@3R0?con`3mooD0oOnV003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo04T0
ohH00ooo003nood00OooP@3P00?oo`00o_om00Goo`00ooog00Goo`00oonW003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_oo0400ohH00OoooP3nooh0oOn10>800Ooo
oP3nooX00Oool`01oonW003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo04<0ohL0
o?l1003mo`D0o`00oon10>@0o?l1003mooh00Oool`01oonU003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_oo0440ohL0o?l1003mood00OooP@3T0?co0@00oOol007o
oo<00OooY`00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0a0?n10?P00OooP@3D
007ooo<00OooY`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`110?n10?/01?l0
0?ooP@3H00Goo`00ooom007oood01Ooo003oojL00=;k003Bo@02ooKjo_H0n_kf
0?[nmP;jool0<`3oP@3k0?goP@3F0?goo@01oook0?goYP00d_/00=;m003oo_H0
n_kf0?[nmPCjm_Koo`0V0?n10840a000oi/00=;k003Bo@02ooKjo_H0n_kf0?[n
mP;jool0903oP@210840g@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0T0?n1
0840P@3M003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo02@0oh40P@210=d00=;k
003Bo@00ookf0?[nmP3jo_H4n_Kfool0903oP@210840g@00d_/00=;m00;om_[n
mP3jo_H0n_kf0_[oo`0T0?n10840P@3M003Bn`00d_d00?onmP3jo_H0n_kf1?[f
m_oo02@0oh40P@210=d00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0903oP@21
0840g@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0T0?n10840P@3M003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_oo02P0oh40kP3noh40P@3c003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_oo02P0oh40kP3noh40P@3c003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_oo02P0oh40l@3koh40P@3c003Bn`00d_d00?onmP3jo_H0n_kf1?[f
m_oo0300oh40m03no`H00?l0o`3oP@210?@00=;k003Bo@02ooKjo_H0n_kf0?[n
mP;jool0=P3oP@3g0?koo@06o`00o`00oiP0o_nD0?kod@00d_/00=;m003oo_H0
n_kf0?[nmPCjm_Koo`0b0?n10?X0o_oj00Ko003o003oV02>om400=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jool0>03oP@3m0?kon000ooh00?on003oV@3moiD0o_oA
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo03X0oh40003nooH00?om003oo@00
oiL00OooU`01ooo?003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo03H0oh@0oOod
003oo000oo`00?nG0?koV`3nolh00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
?03oQ`3noo000?ol003oo000oiH00ol0oonO00?oo`3oc@00d_/00=;m00;om_[n
mP3jo_H0n_kf0_[oo`0n0?n:0?kokP00oo/00?ok003oUP04o`00oonS00Coo`00
ol`00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0?P3oS@3non`00?oj003onP00
oiH00?on003oY@00ooh00?o;003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo0400
oi00o_oZ003on@00ooT00?nF003ooP01oonY007oooh00?o:003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_oo0400oi<0o_oW003on@00ooP00?nF003oo@01oon]007o
ood00?o9003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo0400oiL0oOoU003on000
ooP00?nF003on`01oona007ooo/00?o9003Bn`00d_d00?onmP3jo_H0n_kf1?[f
m_oo0400oiX0o_oR003om`00ooL00?nF003onP01oone007oooX00?o8003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_oo03h0oid0o_oP003omP00ooH00?nF003on@00
okL00?oi003oa`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`100?nP0?kogP00
ooD00?oe003oUP00ooT00Ooo^`01oooi003oaP00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[oo`100?nS0?kof`00ooD00?oe003oU@00ooP00Ooo_`01oooh003oa@00
d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`100?nV0?kof@00oo@00?od003oU@00
ooL00Ooo``01ooog003oa000d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0n0?nY
0?koe`00oo<00?oc003oU@00ooH00?o5003omP00ol<00=;k003Bo@00ookf0?[n
mP3jo_H4n_Kfool0@03o[@3momD00?ob003olP00oiD00?of007oolT00OoomP00
ol800=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0@03o/03nom400?ob003olP00
oi@00?oe007oold00Ooom@00ol400=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
@03o/`3noll00?oa003ol@00oiD00?oc007oom400Oool`00ol400=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jool0?P3o]P3nold00?o`003ol000oiD00?ob003od`00
oo800?o0003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04@0ol40o_ol0?kob`00
onl00?o_003oU@00oo800Oooe`01ooob003o_`00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[oo`150?o10?ko0@00o_o8003ok`00onl00?nD003ol@01oooK007ooo40
0?nn003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0400ol40o?o6003okP00onh0
0?nD003ol001oooO007ooo000?nm003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo
03<0okl0o?o9003ok@00ond00?nD003ok`00on400?o_003o_000d_/00=;m003o
lo/1ool0?03o_`04o`3o003nold00?o/003ok000oi@00?o_007oonD00Oook`00
ok/00=;k003Bo@00oo@[0Zcoo`0n0?no00?o003oo@3nom000?o/003ok000oi<0
0?o^007oonT00OookP00okX00=;k003Bo@01ob_en0:/ool0@P3o_`03o`00ooX0
oOoE003oj`00on/00?nC003ok@01ooo]007oond00?ni003Bn`00d_d00Ol[o_Sk
E?kh0Zcoo`130?no003ooP00ooL0o_oI003ojP00onX00?nD003oj`01oooa007o
on/00?ni003Bn`00d_d00Ol[o_Sk:okh0Zcoo`110?no003oo@00ooD0o_oM003o
j@00onT00?nD003ojP00oo<00?oZ003o^000d_/00=;m007o:okhnh3nn0:/ool0
@`3o_`00oo`00?oc0?koh000onT00?oY003oT`00onX00Ooom`01oooZ003o]`00
d_/00=;m007o:okhnb_nn0:/ool0@`3o_`00oo`00?o`0?goi@00onP00?oX003o
T`00onT00Ooon`01oooY003o]P00d_/00=;m007o:okhnh3nn0:/ool0@P3o_`00
oo/00?o]0?koj@00onL00?oW003oT`00onP01Ooo003oonP00?ne003Bn`00d_d0
0Ol[o_Sk:okh0Zcoo`0n0?no003onP00on/0o_o]003oiP00onH00?nC003oi`01
oooW003o]000d_/00=;m007o:okhnh3nn0:/ool0?@3o_`00ooT00?oY0?kol000
onH00?oU003oT`00onT0oOoY003o/`00d_/00=;m007o:okhnb_nn0:/ool0@`3o
_`00ooT00?oV0?gom@00onD00?oU003oTP00on`00Oooo@01ooo/003o/P00d_/0
0=;m007o:okhnh3nn0:/ool0@`3o_`00ooP00?oS0?kon@00on@00?oT003oTP00
onl00Ooon@01ooo_003o/@00d_/00=;m007o:okhnb_nn0:/ool0?@3o_`00ooL0
0?oQ0?koo@00on<00?oS003oT`00oo000?oe003ol000ok400=;k003Bo@01ob_e
n0:/ool0>`3o_`00ooH00?oO0?gohP00on800?nC003ol`01oooc007ooo<00?n`
003Bn`00d_d00Ol[mOP2[?oo03T0okl00?oe003og@3monD00?oR003oTP00ooH0
0Oook`01ooof003o[`00d_/00=;m003olj`1ool0B03o_`00ooD00?oN003oo@3n
onP00?oQ003oTP00ooT00Oooj`01oooi003o[P00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Koo`180?no003om000on000?oi0?koj`00on000?nB003oo001oooW007o
oo`00?n]003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo04H0okl00?oc003ohP00
ooD0o_o^003og`00oi800?on003oh`00ooh00?n/003Bn`00d_d00?onmP3jo_H0
n_kf1?[fm_oo03h0okl00?ob003oh`00oo80o_oa003og`00oi40o_oQ0?koZ`00
d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0n0?no003olP00on@00?o^0?gom@00
omh00?nC0?kog`3noj`00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0B03o_`00
oo400?oV003oj@3nooP00?oM003oUP01ooon003oh@00ooh00Ooo[P00d_/00=;m
00;om_[nmP3jo_H0n_kf0_[oo`160?no003ol000onP00?oU0?kon`00om`00?nH
003oo000on400?ol003o[`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no
003ok`00onT00?oR0?kooP00om`00?nJ007oooX00?oS003onP01oona003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_oo04@0okl00?o_003ojP00omh0oOoK003oW@01
ooog003oi@00ooL00Ooo/`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`140?no
003okP00on`00?oJ0?gog@00oj000Ooom000onL00?od007ookD00=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jool0AP3o_`00ond00?o^003of@00ooh0o_oO003oXP00
oo400?oY003ol@00okH00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0B03o_`00
on`00?o_003of@00oo/0o_oR003oY001ooo_003oj`00onl00Ooo^000d_/00=;m
00;om_[nmP3jo_H0n_kf0_[oo`180?no003ok000oo000?oH003on03monD00?nW
007oon`00?o]003ok001oonj003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04P0
okl00?o[003olP00omL00?od0?koi`00ojX00Oooj@00onl00?oY007ook`00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jool0AP3o_`00onX00?od003oeP00oo40o_oY
003o[000onH00?oa003oiP00okd00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
B03o_`00onT00?oe003oeP00onh0o_o[003o[`01oooU003ol@00onD00Ooo_`00
d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`180?no003oj@00ooH00?oE003oj`3m
onl00?na007oon800?oc003ohP01ooo1003Bn`00d_d00?onmP3jo_H0n_kf1?[f
m_oo04P0okl00?oX003on000om@00?oW0?kol@00ok@00Ooog`00ooD00?oO007o
ol<00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0B03o_`00onL00?oj003od`00
on@0o_oc003o]`01oooL003om`00om`00Oooa@00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Koo`160?no003oiP00oo/00?oC003oh@3nooD00?ni003of@00ooT00?oI
003oaP00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`180?no003oiP00oo`00?oB
003ogP3mooT00?nk007oomL00?ok003oe`01ooo8003Bn`00d_d00?onmP3jo_H0
n_kf1?[fm_oo04P0okl00?oU003ooP00om400?oJ0?kon`00okh00Oooe000ood0
0?oD007oolX00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0A@3o_`00on@00_l0
om000?oG0?koo@00ol400Oood@03o`00om400Oooc000d_/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`100?no003oh`01ooo@003oe03no`00o_o4003ocP01ooo>003o
c@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0l0?no003oh`01ooo@003od@3m
olT0o?o=007oold0oOoA003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo03@0okl0
0?oT00;o0?o@003od`3kolT0S_oA003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo
04D0okl00?oU003ooP00om400?oF0?ko0P00olH0oOo=00?o003oc@3nom400=;k
003Bo@00ookf0?[nmP3jo_H4n_Kfool0AP3o_`00onH00?ol003odP00omT0o_om
003o`@00oll00?om003oc`00olh00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0
B03o_`00onH00?ok003od`00omd0oOoj003o`001oooB003on`00om800Oooc@00
d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no003oi`00ooX00?oC003oh03n
ooL00?nm007oomD00?oi003oe@01ooo;003Bn`00d_d00_ofn_kf0?[nmP3jo_H2
n_oo04P0okl00?oX003on000om@00?oS0?kom@00okX00Ooof000ooL00?oH007o
olT00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0B03o_`00onT00?of003oe@00
onH0o_oc003o]`01oooK003om@00om/00Oooa`00d_/00=;m00;om_[nmP3jo_H0
n_kf0_[oo`160?no003oj@00ooD00?oF003ojP3moo000?ne003og@00oo<00?oM
003oa@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no003ojP00oo@00?oF
003ok@3nond00?nc007oon000?oa003oh001ooo4003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_oo04P0okl00?o[003olP00omL00?o`0?koj`00ok000OoohP00oo40
0?oR007ool800=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0B03o_`00on`00?o`
003of000oo<0o_oY003o[@01oooU003ok`00onD00Ooo`000d_/00=;m00;om_[n
mP3jo_H0n_kf0_[oo`180?no003ok000onl00?oI003om`3monL00?nZ007oonP0
0?o]003oj001oonn003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04H0okl00?o]
003okP00omT00?oj0?koh`00ojP00?oZ003oj`00onX00?nl003Bn`00d_d00_of
n_kf0?[nmP3jo_H2n_oo04P0okl00?o^003ok000omX00?om0?koh@00ojH00Ooo
k@00onT00?o]007ook/00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0A`3o_`00
onl00?oZ003of`01o`3noml00?nS007ooo000?oW003ol001ooni003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo04@0okl00?o_003oj@00omh0oOoM003oX001oooc
003oi@00oo<00Ooo]`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no003o
l000onP00?oQ0?ko0P00om`00?nN007oooH00?oS003omP01oone003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo04H0okl00?oa003oiP00onD0o_ol003og@00oi/0
0?oh003oh@00ooP00?nc003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04P0okl0
0?ob003oi000onT0o_oi003ogP00oiT00OoonP00on400?oj007ook800=;k003B
o@02ooKjo_H0n_kf0?[nmP;jool0B03o_`00oo800?oS003ok@3nooH00?oO003o
UP01ooom003og`00ood00Ooo/000d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`14
0?no003ol`00on800?oa0?gol`00oml00?nD00?oo`3og@03o`3oojh00=;k003B
o@02ooKjo_H0n_kf0?[nmP;jool0@03o_`00oo@00?oP003om@3nonl00?oP003o
T@01oooM007ooj`00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0A03o_`00ooD0
0?oN003on@3non`00?oQ003oT@03o`00oml00ol00?n]003Bn`00d_d00_ofn_kf
0?[nmP3jo_H2n_oo04P0okl00?oe003og@00ood0o_oY003ohP00oi400?om007o
on<00Oooo@00ojh00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0A03o_`00ooH0
0?oL0?coiP00on800?nB003onP01oooW007oooX00?n_003Bn`00d_d00_ofn_kf
0?[nmP3jo_H2n_oo04@0okl00?og003og@3mon<00?oS003oTP00ooL00Oooj`01
ooog003o/000d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no003on000oml0
o_om003oi000on@00?nB003om001ooo_007ooo@00?na003Bn`00d_d00_ofn_kf
0?[nmP3jo_H2n_oo04H0okl00?oi003oh@3nooT00?oU003oi@00oi400?ob003o
l@00oo800?na003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04P0okl00?oi003o
i@3mooD00?oV003oi@00oi800?o`007oooD00Oool000ok800=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jool0B03o_`00ooX00?oW0?kol@00onH00?oV003oTP00ond0
0Ooon@01ooo]003o/`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`180?no003o
n`00onT0o_o]003oi`00onL00?nB003ojP01ooom007oonX00?nd003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo04D0okl00?ol003oj`3nonT00?oX003oj000oi80
0?oW00?o003oi`00okD00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0@`3o_`00
oo`00?o_0?goi@00onT00?oX003oT`00onD00Oooi@00okH00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jool0A`3o_`00ood00?oa0?koh@00onT00?oY003oT`00onH0
1Ooo003oonH00?ng003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04P0okl00?on
003ol`3nomd00?oZ003ojP00oi<00?oW007ooo/00Oooi`00okP00=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jool0A`3o_`03o`00ooD0o_oI003oj`00on/00?nC003o
j001ooog007oonP00?ni003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04D0okl0
0ol00?oi0?goe@00on`00?o/003oTP00onT00?oc003oj@00okT00=;k003Bo@02
ooKjo_H0n_kf0?[nmP;jool0AP3o_`02o`3on`3nom400?o/003ok000oi<00?oZ
007ooo400OoojP00okX00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0A@3o_`01
ooom0?koc@00ond00?o]003oT`00on/00Oook@01ooo[003o^`00d_/00=;m00;o
m_[nmP3jo_H0n_kf0_[oo`150?o10?ko0@00o_o9003okP00onh00?nC003ok001
oooY007oon`00?nl003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0400ol40o?o5
003ok`00onl00?nC003ok@01oooU007oond00?nm003Bn`00d_d00_ofn_kf0?[n
mP3jo_H2n_oo0480ol40o_l00?koa`00onl00?o_003oU000ond00?oQ003ok@00
okh00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0@03o^P3nolT00?o`003ol000
oi@00?o^007ooml00OookP00okl00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0
0?l\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{450, 235},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "To add a tag to the cell, we pull down the Find menu and choose ",
  StyleBox["Add/Remove Cell Tags", "MenuItem"],
  ", then type the desired tag into the uppermost text field. To add to the \
tag to the cell, we click the ",
  StyleBox["Add", "MenuItem"],
  " button."
}], "Text"],

Cell[GraphicsData["PICT", "\<\
AnH0?`0g0I`1l00A0_l<0?ooool0=`0003l0007`0001W0000000000100X0?`0g
0I`1l02HPKX0?`0g0I`1l0000000000004P0001800000008004020000002NEGH
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000?`0g
0I`1l00o03L1W07`00002h7oPOn1olWo0@2f00l0oh4[PB^1:l`[0eCoofd0407o
:h7ePOF1mLge0eCoom/0407o:h7ePOF1mLge0eCookH0607o:o_j0?Gf[03eVOZ1
mL?eQ_X3E?ooK@1<0Ol[n_D0[?L[TOGloo_e1OoomOGoooke0OoonOGmooKe1Ooo
mOGooocenooSmOkokOGmooke0Oooj_D1oooXm@7ooh7e1OGeE?oof`1K0Ol[noX2
mJ`[n_P2[2_eVO[jm@7oooSe0Ooon_D1ooojm@7oooke0?ogm@GoooGeooojm@7o
on;e0Oook?D1ooonm@ComOGoon[e0OoojOGnoo[eQ_X3E?oo]P230Ol[n_D1[2_j
n06/:i7e0OoonoGlo`GemOoomOGmoo_e0Ooon_Gmooke1OoomOGooo[e0OoooOGm
oogeo?onmOkon_GmookeoOonm@CoooGoooce0OoonoGloogeoOonmOcoo_Gmooke
oOonm@CoooGooo[e0ooeoon1m@GemECoofd0[P7o:o_j0_F/:o[h0Z`[mIWjn_D1
ooolm@WoooGeoooemOooo_D1ooojm@7ooo_e3OoomOGoooGeoooemOoon_D1ooon
m@3oo_D@oooemOoomOGoooGeoooemOojm@7oooke1ooomOGoooGeo_ojm@7ooo_e
2?oomOGoooGeooke2OoomOGoooGeooonm@7oooke1ooomOGoooGeo_oim@ComOGo
oo[eQ_X3E?oof`2P0Ol[n_D1[2_jn06/:i7eoOonm@WoooGeoooemOooo_D1oooj
m@7ooo_e3OoomOGoooGeoooemOoon_D1ooommOco2OGeoooemOoomOGnooSe0Ooo
o_D9oooemOoomOGoooWe0OoonoD5oooemOooo_Glo`OemOoomOGoooke0Oooo_D9
oooemOoomOGoooWe0?onm@7ooh7e1OGeE?oo]P2O0Ol[noX2mJ`[n_P2[2_eVO[j
m@7oooce2OoomOGoooGeooonm@7ooo[e0OoonoGko`OemOoomOGooo[e0Oooo_D=
oooemOoomOGoooGeooonmOkonOD1ooonm@WoooGeoooemOoonOD1oookmAGoooGe
oooemOoomOGoooGeoooemOooo_D1ooonmO_o0oGeoooimO[onoF6nP=Doom]09h1
ob_jm@6/:o[h0J`[TOD1ooolm@WoooGeoooemOooo_D1ooojm@7ooo_e0OoonoD5
oooemOoon_D1ooonm@goooGeoooemOoomOGooogeo_ojm@7oooke2OoomOGoooGe
oooim@7ooo_e5OoomOGoooGeoooemOoomOGoooGeooonm@7oooke0OoonoD1oooe
m@7ooh7e1OGeE?oof`2a0Ol[noX2mJ`[n_P2[2_eVO[jm@7oooce2OoomOGoooGe
ooonm@7ooo[e0Oooo_D4ooGeooonm@SomOGoooGeooojm@7oooke5?oomOGoooGe
oooemOoomOGomOGooo[e0Oooo_D9oooemOoomOGoooWe0Oooo_DHooGeoooemOoo
mOGoooGeoooemOoomOGoooke0Oooo_D1ooonm@ComOGoooGe0Ooon_F6nP=Doonf
0801ob_jm@6/:oV/02^AmOcoo_Glo`?emOoooOD1ooojmOgooOGmooke1OoomOGo
oo[e0OoooOGlookeo?onmOkonOD1ooommOgoo_D1ooohmOgoo_D5oooemOooo_Gl
o`7emOcoo?D1ooonmOgoo_D1oooem@7ooh7e1OGeE?ooK@0Q0Ol[noX1mJcg:`3e
VOZ_m@7oolCe0Oooe_F6nP=DoooK01`1ob^1mKSe0?onm@7oolCe0OooPOGKm@=D
oonf0181ob^1mKOeoOn1mI_e0eCoofd03P3oPEB1E85Dbe@2oooK00Z1oh7oPOo8
o`2f00h0oh40P@210</00_ooK@0>0?n10840P@3;00;oom/03P3oP@210840b`02
oonf00h0oh40P@210</00_ooK@0>0?n10840P@3;00;oom/03P3oP@210840b`02
oonf00h0oh40P@210</00_ooK@0>0?n10840P@3;00;oom/0803ol`3mooL00Ooo
oP01oooi003oP@210840m`02oonf0280oo@00?om003om`00ood00?oi003oP@21
0840m`02oom]02P0oo@00?oi0?koo@00ood00?oj0?koo@3nood0oOn10840Q`02
oooK03H0oo@00?oj003ooP00ooh00?om003on@00ood00?on00?o003ooP03o`00
oh40P@2:00;ookH0>03om000ooX00?on003ooP00ood00?oi003oo03mo`800?on
003oP@210>H00?ob0<7olP02oom]03d0oo@00?oj0?cooP00ood00?oi003oo@00
ooh00ol00?on003oP@210>H00?od007ool400Ooom002oooK03/0oo@00?oj003o
nP00ood00?oi003oo@00ooh00ol00?on003oP@210>H00?od003o_`00oo@00_oo
]P120?od003oo@03o`00ooh00?on003oo@00ooT00?om003ooP03o`00ooh00?n1
0840iP00ooD00?nm003om@02oom]03T0oo<0oOom0?koo@00ood00?oh007oooh0
oOon0?go0P00oh40P@3Y003om@00okd00?oe00;oom/09@3oaP00oh40P@3V003o
m@00onl0oOon007oomP00?oe00;ookH0;@3obP00ooh00?n10840iP00ooD00?o`
007oooh01?l00?oof000ooD00_ooK@0b0?o90?koP@210>D00?oe003ol001oook
007oooh0oOom0?koo@3monh00?oe00;oom/0>@3oP@210:X00?oe003ol001oook
01Soo`00ool00?oo003oo`00o`00ool00?ook`00ooD00_oo]P0g0?n10840ZP00
ooD00?o`007ooo/02ooo003oo`00ool00?koo@05ool00?ook`00ooD00_ooK@0b
0?n10840ZP00ooD00?o`007ooo/02Ooo003oo`00ooon0?kooP3konl00?oe00;o
om/0=`3on@21oh7o__oe003om@00oo000Ooon`09ool00?oo003oood0o_l3003o
on/00?oe00;ookH0A03on@00oh40P@30003om@00ooD00?o`007oooh05ol00?oo
003oo`00ool00?l00?oo003oooh00?o_003om@02oom]03D0ooT00?n10840`000
ooD00?oe003ok`3mooh00OoooP3mood0o_om0?gokP00ooD00_oof`0T0?oi003o
a000oh40P@3n003om@00ooD00?nm003om@02oonf02@0ooT00?o4003oP@210?h0
0?oe003om@00okd00?oe00;oofd0903on@00ol@00?n10840oP00ooD00?oe003o
_@00ooD00_oof`0c0?oi003oo@3looh00?oM0?koo03no`40oh40P@3n003om@00
oo@00?no003om002oonf03L0ooT00?om003oeP00ooh00?on003ooP01oon10840
oP00ooD00?od007ool400Ooom002oom]04h0ooT00?om003on`01ooom0?go0P00
ooh01?l00?l0o_l1003nooX00?om00?o003oo@01ooo4003oP@2l003om@00oo80
`Oob00;oom/0A`3on@00ood00?oj003ooP00ooh00ol00?on00Co003oood00?on
003omP00ooX00Oooa001oon10;d00?oe003oX`02oonf04H0ooT00?om0?goo@00
ooh00?on00?o003ooP03o`00oo`00?on003om`00ooX00_l0ol@0o_n10;h00?oe
003oX`02oom]04<0ooT00?om003onP00ooh00?on00?o003ooP03o`00oo`0o?oh
003onP03o`00ol@0oOn10;l00?oe003oX`02oooK04@0ooT00?om003onP00ooh0
0?on00?o003ooP03o`00oo`00?oe003onP00ooh00?o40?coP@30003om@00oj<0
0_oo]P180?oi003oo@00ooX00?on003ooP0:o`00o`00ool00?ol003ooP00ooX0
0?oj003oo@00ol@0non10<400?oe003oX`02oom]03d0ooT00?om003onP00ood0
oOon00Koo`3o003on`3nooX0nol1003jol@0n_n10<800?oe003oX`02oooK02H0
ooT00?o]003of@00ol@0nOn10<<00?oe003olP31oo800_oo]P0`0?oi003ol@00
ooh00?oI003oa03loh40`000ooD00?od007ool400Ooom002oom]02h0ooT00?o`
0?kof000ol@01?oo0?ooP@30003om@00oo@00?no003om002oooK02/0ooT00?o4
003oa000ooh00OooP@31003om@00ooD00?nm003om@02oonf02<0ooT00?n2007o
oh40`@00ooD00?oe003o_@00ooD00_ooK@0a0?oi003oP@01oon10<800?oe003o
m@00on`01Ooo003oooL00Oooi000ooD00_oof`0_0?oi087o0`3oo`21ol;om@00
ooD00?o/00Goo`00ooog007oon@00?oe00;ookH0;P3oP@210:X00?oe003ok005
ool00?oooP3mooh00ooo003lon/00?oe00;oofd0=@3oP@210:X00?oe003ok00I
ool00?oo003oo`00ool00?oo003oo`00ooo/003om@02oooK0340oh40P@2Z003o
m@00on`0nolC003oo`00ool00?oo003oo`00ooo/003om@02oonf0380oh40P@2Z
003om@00on`01ooo003oo`00nol;003oo`00ool00?ook000ooD00_ooK@0h0?od
0<ColP36oh40_P00ooD00?o/00Woo`00ool00?oon`09ool00?oo003oon`00?oe
00;oom/0A`3om@01ooo6007oooD00OooaP01oon10<000?oe003ok009ool00?oo
003oooh03?l00?oo003oo`00ooo/003om@02oonf03h0ooH00Oooa001ooof003o
a000oh40`000ooD00?o/00Goo`00ooon0?gooP03ool00?coj`00ooD00_ooK@0[
0?of003o`P00ooL00?o2003oP@31003om@00omP00Oooj000ooD00_oof`0[0?of
003o`P00ooL00?o2003oP@31003om@00omP00Oooj000ooD00_oo]P0h0?of003o
k03mooX00Ooon`01ooo/003om`00oo/0o?o=003oP@31003om@00okd00?oe00;o
ofd0@P3omP00ond01Ooo003ooo/00Ooon`01ooo/003om`00oo/01Ooo003oolh0
0?n10<400?od003o_`00oo@00_oof`1K0?of003ok@05ool00?oooP3looh0o?o/
003om`00oo/01Ooo003oooh0oOon0?Soo@3mooh01Ooo003oooh0oOoi003oP@31
003om001ooo1007ooo@00_oo]P1`0?of003ok@0Eool00?oo003oo`00ool00?oo
003oon`00?og003on`0aool00?oo003oo`00ool00?oo003oo`00ool00?oo003o
o`00ool00?oo003oo`00oooj003oP@31003olP31oo800_ooK@1T0?of003ok@3k
o`l00?oo003oo`00ool00?ook000ooL00?ok0?cooP0Yool00?oo003oo`00ool0
0?oo003oo`00ool00?oo003oo`00ool00?oonP00oh40`@00oj<00_oof`1U0?of
003ok@0Eool00?oo003oo`00ool00?oo003oon`00?og003on`07ool00?oo003k
oad00?oo003oo`00ool00?oo003oo`00ool00?oo003kooX00?n10<400?nS00;o
okH0I@3omP00ond05Ooo003oo`00ool00?oo003oo`00ooo/003om`00oo/02Ooo
003oo`00oook01goo`00ool00?oo003oo`00ool00?oo003oo`00ooof003oP@31
003oX`02oom]06`0ooH00?o]01Goo`00ool00?oo003oo`00ool00?ook000ooL0
0?ok00Woo`00ool00?oooP0Ko`00ool00?oo003oo`00ool00?oo003oo`00ooh0
0OoooP00ooX00?n10<400?nS00;oom/0E@3omP00ond01Ooo003oooh0o?on0?co
k000ooL00?ok00Goo`00ooon0?gooP09ool00?oo003oooh0oOon0?goo03mooT0
0?n10<400?nS00;ookH07P3omP00ol800?og003o`P00oh40`@00oj<00_ooK@0N
0?of003o`P00ooL00?o2003oP@31003oX`02oooK0200ooH00Oooa001ooog003o
`P00oh40`@00oj<00_oo]P0P0?oe007oolH00Ooom@00ol@00?n10<000?nS00;o
ofd0703om034oo@00OooaP01oon10<000?nS00;oom/04P3oZ036oh40_P00oj<0
0_oo]P0@0?n10840ZP00oj<00_ooK@0@0?n10840ZP00oj<00_oof`0@0?n10840
ZP00oj<00_oo]P0@0?n10840ZP00oj<00_ooK@0@0?n10840ZP00oj<00_oof`0@
0?n10840ZP00oj<00_oo]P0@0?n10840ZP00oj<00_ooK@0@0?n10840ZP00oj<0
0_oof`0@0?n10840ZP00oj<00_oo]P0@0?n10840ZP00oj<00_ooK@0@0?n10840
ZP00oj<00_oof`0@0?n10840ZP00oj<00_oo]P0F0?n10;400?oh003oQ@00oj<0
0_ooK@0m0?oe0?[og@01oooB003oo@01oooU007oonl00?ob003ok@01ooon007o
ood00?of003oQP00oj<00_oof`0h0?ob003of`00om000?ol003oi000onl00?ob
003ok000ood00?om003omP00ohH00?nS00;ookH0U03olP00oo/0o_om0?gooP3n
ooT0o_on0?kon@3nooh00?on00Co003o0?ko0P3o0?ko0@00o_on00?o0?oooP3n
ood00?on003ooP00ooX0o_om0?koo@00ood0o_om0?kooP3nood0o_om0?gonP3n
ood0o_om003oo@00ooh00?ol0?koo000ohL00?nS00;oofd0b03olP00oo`00?on
00?o003ooP03o`00ooh00?ok003ooP00ooh00?oi003ooP03o`00ooh01?l00?oo
o@01ooom003ooP07o`00ool00?on003oo000ooh00?on003on`00ooh00ol00?on
003ooP00ooh00?on00?o003ooP00ooh00?om003ooP03o`00ooh00?ok003ooP03
o`00ooh00?on003oo@00ooh00?om003ooP00ood00ol00?n:003oX`02oooK0:/0
oo800?ok0?go0P00ooh00ol00?og003ooP00ooh00?oi003on`00ooh00ol00?ol
003oo000ooh00ol00?on003ooP00oo`00?on003ooP00oo/00?ok003ooP00ooh0
0?on003ooP03o`00ooX00?om003ooP03o`00ooh00?ok003on`00ooh00?on003o
o@00ooh00?om003on@00ohL00?nS00;ookH0WP3olP00oo`00?on00?o003ooP00
ooh0o_oj003ooP00ooh00?oi003on`00ooh00ol00?ol003oo03lo`800?on003o
oP00oo`00?on003ooP00ooX0o_on0?cooP00ooh0o?l2003onP00ood0o?l2003o
oP00oo/00?ok0?cooP00ood00?on003oo03noo`00?n7003oX`02oom]09d0oo80
0?ol003ooP03o`00ooh00?ok003on`00ooh00?on003on@00oo/00?on00?o003o
o000oo`00?ok003ooP00ooh00?ol003ooP00ooh00?og00?o003onP00ooh00?ok
003onP00ood00?ok003ooP00oo/00?ok003onP00ood00?on003on@00ood00?n7
003oX`02oooK0<<0oo800?ol003ooP03o`00ooh00ol00?on003on`00ooh00?on
003on@00ooh02_l00?l00?oo003oo000oo`00?on00?o003ooP00ooh00?ol003o
oP00ooh00?ok003ooP03o`00ooh00?on003ooP00ooh00ol00?on003ooP00ood0
0?on00?o003ooP00oo/00?on00?o003ooP00ooh00?om003oo@00ooh00?on003o
oP00ohH00?nS00;ookH0T03olP00oo/0oOon0?gooP3nooT0o_om003on03nood0
1_oo0?l00?ol003on`3nooh00?on003oo@01ooon003oo@3mooX0o_om0?koo@00
ood0o_om0?koo001ooon0?koo@3mooX0o_om0?koo@00ood00?om003oo@3nood0
0?on003oRP00oj<00_ooK@0L0?oQ003o[000ojP00?oh003oQ@00oj<00_oof`0N
0?oU003ooP00ok000?on003oP@2Q003oX`02oonf01H0on@0o_n^0?koP@2P003o
X`02oom]0100oh40P@2Z003oX`02oooK0100oh40P@2Z003oX`02oonf0100oh40
P@2Z003oX`02oom]01@0ooT0POn1okkom@00oj<00_oof`0L0?oi003oP@210<l0
0?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0Q
0?oi003oP@210<l00?okm@7jn__e0?oe003oX`02oooK02<0ooT00?n10840c`00
ooce0o[emO[lm@3om@00oj<00_oo]P0T0?oi003oP@210<l00?omm@3joOD0n_ge
0?oe003oX`02oom]02@0ooT00?n10840c`00ooke0?[km@3jo_D0ooD00?nS00;o
om/08P3on@00oh40P@3?00?omOGjnOD3n_GeooD00?nS00;ookH08P3on@00oh40
P@3?007omOgjoOGmnP7eooD00?nS00;oofd0903on@00oh40P@3?003ooOD0n_ge
0?[mm@3om@00oj<00_oof`0T0?oi003oP@210<l00?omm@3joOD0n_ge0?oe003o
X`02oonf02@0ooT00?n10840c`00ooge0?[mm@3joOD0ooD00?nS00;oofd0803o
n@00oh40P@3?003ooOGkn_ge0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e
0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT0
0?n10840c`00oo?j0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003o
X`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840
c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf
01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e
0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003o
X`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840
c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK
01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e
0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003o
X`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840
c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]
01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e
0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003o
X`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840
c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf
01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e
0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003o
X`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840
c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK
01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e
0?oe003oX`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003o
X`02oom]01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840
c`00oo?e0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]
01`0ooT00?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e
0?oe003oX`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT0
0?n10840c`00oo?e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003o
X`02oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01`0ooT00?n10840
c`00oo?j0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02oonf
01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]0200ooT00?n10840c`00ooge
no[mm@3om@00oj<00_oof`0T0?oi003oP@210<l00?omm@3joOD0n_ge0?oe003o
X`02oonf02@0ooT00?n10840c`00ooge0?[mm@3joOD0ooD00?nS00;oofd0903o
n@00oh40P@3?003ooOD0n_ge0?[mm@3om@00oj<00_oof`0R0?oi003oP@210<l0
0OoeoO[mmOgj0OGom@00oj<00_oo]P0R0?oi003oP@210<l00ooemO[im@?jmOGo
m@00oj<00_ooK@0T0?oi003oP@210<l00?onm@3jnoD0n_ke0?oe003oX`02oooK
02@0ooT00?n10840c`00ooge0?[mm@3joOD0ooD00?nS00;ookH08`3on@00oh40
P@3?003oo?D3n_Gen_ce0?oe003oX`02oom]0240ooT00?n10840c`00oo_e0O[j
noD0ooD00?nS00;oom/0703on@00oh40P@3?003oloD0ooD00?nS00;ookH0703o
n@00oh40P@3?003oloD0ooD00?nS00;oofd0503on@21oh7o__oe003oX`02oooK
0100oh40P@2Z003oX`02oonf0100oh40P@2Z003oX`02oom]01H0okT00?n10<P0
0?n]003oX`02oooK03H0okX00?on0?gok`00oo/00Oooj@01ooom003om`00ooH0
0?ne003oj`00ojh00?nS00;ookH0=03o^P00ooh00?on003ol000ooX00?oX003o
lP00ooH00?ne003oj`00ojh00?nS00;oofd0S03o^`00ood00?om003ooP3nooh0
0?on00;o003mood00?om0?komP3nood00?on007oood0o_on003ooP00oo/0o_om
0?konP01o`3no`400?kooP07o`3oo`00ooom0?kooP00ooh00?on0?kon@3nooX0
o_om0?koo@3mooX00?n_003oX`02oooK0:l0ok/00?om003oo@03o`00ooh00ol0
0?on00?o003ooP00ooh00?on003ooP00ooP00?on003ooP00ood00?on003ooP06
o`00o`00ooT00?om003ooP00oo/00Oooo@00ooh03_l00?oo003oo`00o`00ooh0
0ol00?on00?o003ooP00oo/00?on003onP00ood00?on00?o003ooP00ooX00?n_
003oX`02oonf0:<0ok/00?om003oo@03o`00ooh00ol00?on00?o003ooP00ooh0
0?on003ooP02o`00o?l2003onP00ood00?on003on`02o`3on000ood00?on003o
n`00oo`00?on00?o003ooP00ooh00ol00?on00?o003ooP03o`00ooh00?oj0?go
nP00oo`0oOl2003ooP00ooX00?n_003oX`02oom]09X0ok/00?om003oo@03o`00
ooh00ol00?on00?o003ooP00ooh00?on0?con000ooX00?om003ooP00oo/00Ooo
m`00ood00?on003on`00oo`0o?l2003ooP00ooh00ol00?on003ooP02o`3ooP3l
oo/00?on003onP00ood00?on00?o003ooP00ooX00?n_003oX`02oooK09/0ok/0
0?om003oo@03o`00ooh00ol00?on00?o003ooP00ooh00?on003om000ooX00?om
003ooP00oo/00_l0ooP00?om003ooP00oo/00?ol003on`00ooh00?on00?o003o
oP00ooh00_l0ooh00?og003ooP00ooX00?om003ooP03o`00ooh00?oj003o[`00
oj<00_oo]P2]0?nj003ooP00ooh00?on003ooP0:o`00o`00ool00?on003ooP00
ooh00?on003on000ooh00?on003oo@00ooh00?on00Ko003o003on@00ood00?on
003on`00oo`00?on00?o003ooP00ooh00ol00?on003oo@00ood00?on003on`00
ooh00?oj003oo@00ooh00ol00?on003on`00ojh00?nS00;oofd0Q@3o^P00ooh0
oOol0?koo@05ool0o`00oOom003oo@3nooH0o_om003oo@00ood0o_on003ooP00
ooT00OoooP3nooX00?ok0?kooP00ooh00?on003ooP3noo`00?ol0?kon@3mooT0
0OoooP3mooh0oOl2003ooP00ojh00?nS00;oom/06P3o^@00oh40cP00oo`00?n]
003oX`02oonf01H0oh40R@00ooh00?nW003oX`02oom]0180oh40R03nojH00?nS
00;oom/0403oP@210:X00?nS00;ookH0403oP@210:X00?nS00;oofd0403oP@21
0:X00?nS00;oom/0403oP@210:X00?nS00;ookH0403oP@210:X00?nS00;oofd0
403oP@210:X00?nS00;oom/0403oP@210:X00?nS00;ookH0403oP@210:X00?nS
00;oofd0403oP@210:X00?nS00;oom/0403oP@210:X00?nS00;ookH0403oP@21
0:X00?nS00;oofd0403oP@210:X00?nS00;oom/0403oP@210:X00?nS00;ookH0
403oP@210:X00?nS00;oofd0@P3olP00oo`00OoooP01ooo/007oooh00Ooon@00
on<00?ob003oo@00on400?of003ok@00oh40h@00oj<00_oof`0j0?ob003on`00
ood00?o[003oo@00ooT00?oC003oo@00on400?of003ok@00oh40h@00oj<00_oo
]P1n0?oc00;o0?ol003oo@00ooT0o_om0?koo@00ood00?oj0?koo@3nood0oOon
0?konP01ooon00?o0?oonP3nooh00ol0ooom0?konP03o`3oood0o_on0?koo@3n
ooh0oOom0?koo@3nooh00?on003oP@3U003oX`02oom]0:H0oo<00_l0oo`00?om
003onP00ooh00ol00?on003ooP00ood00?oi003oo@00ooh00ol00?on00?o003o
oP00ooX00?on00Coo`00ooX00?om00Ooo`00o`00ooh00?ok00Ooo`00o`00ooh0
0?on003oo@00ooh00ol00?on00?o003ooP03o`00ooh01_l00?l00?on003oP@3X
003oX`02oooK09T0oo@00?on003oo@00ood00?oj003on`00ooh00?on003oo@00
ooT00?ol0?go0P00ooh00ol00?of003ooP00ooh00?oj003oo@00ooh00ol00?on
003on`00ooh00ol00?on003ooP00ood00?on00?o003ooP03o`00ooh00ol00?on
00Go003o0?n10><00?nS00;ookH0TP3om000ooh00?om003oo@00ooX00?ok0?co
oP00ood00?oi003oo@00ooh00ol00?on003ooP3nooT00?on003ooP00ooX00?om
003ooP02o`00o?ok003ooP03o`00ooh00?on003oo@3lo`800?on00?o003ooP03
o`00ooh01?l00?ooP@3R003oX`02oom]08h0ooD0n_on003oo@00ooX00?ok003o
nP00ood00?oi003oo@00ooh00ol00?on003on`00ooX00?on003ooP00ooX00?om
003ooP03o`00ooL00?on00?o003ooP00ooh00?om003on`00ooh00ol00?on00?o
003ooP05o`00o`3oP@3S003oX`02oooK0:@0ooD00?ol003ooP00ood00?oj003o
oP03o`00ooh00?on003oo@00ooT00?om003ooP03o`00ooh00ol00?on003onP00
ooh00?on003onP00ood00?on00?o003ooP00oo/00?on00?o003ooP00ooh00?om
003ooP03o`00ooh00ol00?on00?o003ooP06o`00o`00oh40i000oj<00_oo]P27
0?oe003oo000ooh00?om003on@3nood0o_om003oo@00ooP00OoooP3mooh0oOon
0?kon@00ooh00?on003on@04ool00?on003ooP3nooX00?on003ooP3noo`00Ooo
oP3nooh0oOom0?koo@3nooh00?on00?o003oP@3X003oX`02oom]01@0ok400?n1
0840n`00oj<00_oof`0H0?ne003ooP00oh40P@3k003oX`02oonf01@0ok@0o_n1
0840nP00oj<00_ooK@0@0?n10840ZP00oj<00_oof`0@0?n10840ZP00oj<00_oo
]P0@0?n10840ZP00oj<00_ooK@0D0?oi087oPOnnooD00?nS00;oom/0703on@00
oh40P@3?003oloD0ooD00?nS00;ookH0703on@00oh40P@3?003oloD0ooD00?nS
00;oofd08@3on@00oh40P@3?003onoD1n_[km@3om@00oj<00_oof`0S0?oi003o
P@210<l00?olm@?jmOGjo?D0ooD00?nS00;ookH0903on@00oh40P@3?003ooOD0
n_ge0?[mm@3om@00oj<00_ooK@0T0?oi003oP@210<l00?onm@3jnoD0n_ke0?oe
003oX`02oooK0280ooT00?n10840c`03ooGen_We0o[emOoe003oX`02oonf0280
ooT00?n10840c`01ooGmn_geoOX1mOoe003oX`02oom]02@0ooT00?n10840c`00
ooge0?[mm@3joOD0ooD00?nS00;oom/0903on@00oh40P@3?003ooOD0n_ge0?[m
m@3om@00oj<00_oo]P0T0?oi003oP@210<l00?omm@3joOD0n_ge0?oe003oX`02
oom]0200ooT00?n10840c`00oogeno[mm@3om@00oj<00_oof`0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
K@0L0?oi003oP@210<l00?ocnP3om@00oj<00_oof`0L0?oi003oP@210<l00?oc
m@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi
003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00
oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?oc
m@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi
003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00
oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
f`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?oc
m@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi
003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00
oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
K@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?oc
m@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi
003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00
oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?oc
m@3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi
003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00
oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
f`0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?oc
m@3om@00oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi
003oP@210<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00
oj<00_ooK@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@21
0<l00?ocm@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_oo
K@0L0?oi003oP@210<l00?ocm@3om@00oj<00_oof`0L0?oi003oP@210<l00?oc
m@3om@00oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0L0?oi
003oP@210<l00?ocnP3om@00oj<00_oof`0L0?oi003oP@210<l00?ocm@3om@00
oj<00_oo]P0L0?oi003oP@210<l00?ocm@3om@00oj<00_ooK@0P0?oi003oP@21
0<l00?ommO_joOD0ooD00?nS00;oom/0903on@00oh40P@3?003ooOD0n_ge0?[m
m@3om@00oj<00_oo]P0T0?oi003oP@210<l00?omm@3joOD0n_ge0?oe003oX`02
oom]02@0ooT00?n10840c`00ooge0?[mm@3joOD0ooD00?nS00;oom/08P3on@00
oh40P@3?007omOgjoOGmnP7eooD00?nS00;ookH08P3on@00oh40P@3?00?omOGj
nOD3n_GeooD00?nS00;oofd0903on@00oh40P@3?003oo_D0n__e0?[nm@3om@00
oj<00_oof`0T0?oi003oP@210<l00?omm@3joOD0n_ge0?oe003oX`02oonf02<0
ooT00?n10840c`00ooce0o[emO[lm@3om@00oj<00_ooK@0Q0?oi003oP@210<l0
0?okm@7jn__e0?oe003oX`02oooK01`0ooT00?n10840c`00oo?e0?oe003oX`02
oonf01`0ooT00?n10840c`00oo?e0?oe003oX`02oom]01@0ooT0POn1okkom@00
oj<00_oof`0@0?n10840ZP00oj<00_oo]P0@0?n10840ZP00oj<00_ooK@0F0?n]
003oP@3P003oX@00oj<00_oof`0n0?n^003ooP3monl00?ok007oonT00Oooo@00
ooL00?of003oi`00oo/00?o_003oj`00oj800?nS00;ookH0?03o[P00ooh00?on
003ol000ooX00?oX003olP00ooH00?oW003on`00onl00?o[003oXP00oj<00_oo
K@1a0?n_003oo@00ood00?on0?kooP00ooh00_l00?goo@00ood0o_of0?koo@00
ooh00Oooo@3nooh00?on003on`3nood0o_oi0?koo@3mooh0oOoj0?konP3nood0
o_om0?gonP00oj<00?nS00;oom/0UP3o[`00ood00?om00?o003ooP03o`00ooh0
0ol00?on003ooP00ooh00?on003on000ooh00?on003oo@00ooh00?on00Ko003o
003on@00ood00?on003on`00ooh00ol00?on00?o003ooP00oo/00?on003onP00
ood00?on00?o003ooP00ooX00?n10<@00_oo]P280?n_003oo@00ood00ol00?on
00?o003ooP03o`00ooh00?on003ooP00ooh00_l00?co0P00ooX00?om003ooP00
oo/00_l0ooP00?om003ooP00ooX0oOl2003ooP03o`00ooh00?oj0?gonP00oo`0
oOl2003ooP00ooX00?n10<@00_ooK@290?n_003oo@00ood00ol00?on00?o003o
oP03o`00ooh00?on003ooP3looP00?oj003oo@00ooh00?ok007oooL00?om003o
oP00oo/00?on00?o003ooP03o`00ooh00?ok003ooP00ooX00?om003ooP03o`00
ooh00?oj003oP@3400;oom/0RP3o[`00ood00?om00?o003ooP03o`00ooh00ol0
0?on003ooP00ooh00?od003onP00ood00?on003on`02o`3on000ood00?on003o
n`00ooh00ol00?on00?o003ooP00oo/00?on003onP00ood00?on00?o003ooP00
ooX00?n10<@00_oo]P2G0?n^003ooP00ooh00?on003ooP0:o`00o`00ool00?on
003ooP00ooh00?on003on000ooh00?on003oo@00ooh00?on00Ko003o003on@00
ood00?on003on`00ooh00ol00?on00?o003ooP00oo/00?on003onP00ood00?on
00?o003ooP00oo/00?n10<<00_ooK@1_0?n^003ooP3moo`0o_om00Goo`3o003m
ood00?om0?komP3nood00?om003oo@3nooh00?on003on@01ooon0?kon@3mooh0
oOon0?gonP3mooT00OoooP3mooh0oOl2003ooP00oh40``02oooK01P0ojd00?n1
0>H00?ol003oP@3200;ookH0503oP@2E003ooP00oh40_002oom]0100oh40U03n
oh40^`02oooK00h0oh40P@210</00_oo]P0>0?n10840P@3;00;oofd03P3oP@21
0840b`02oooK00h0oh40P@210</00_oo]P0>0?n10840P@3;00;oofd03P3oP@21
0840b`02oooK00h0oh40P@210</00_oo]P0>0?n10840P@3;00;oofd02X7oPOn1
olSo0=/03000POn1oh7obOl0]P00o`\>"], "Graphics",
  ImageSize->{441, 349},
  ImageMargins->{{12, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Next, we select the text we want to act as the hyperlink, then pull down \
the Input menu and choose ",
  StyleBox["Create Hyperlink", "MenuItem"],
  ". In the dialog box that appears, we click the desired target cell tag \
from the list at the bottom of the window."
}], "Text"],

Cell[GraphicsData["PICT", "\<\
D0@0GP1e0J/22`0A0_l<0?ooool0M@0005h0008;0001Z`000000000100X0GP1e
0J/22`2HPIH0GP1e0J/22`000000000004P0001800000008004020000002NEGd
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000GP1e
0J/22`1N07D1Z`8;0000287oPOn1on_o00d0oh4[PB^1:nh[0O[o00h1ob^1mh7g
POO_m`7jo`0@0_l[mh7jPOZ1n_7j0_Ojo`0B0ol[moZ1oh7oPOoco`<[mo[o01@4
ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOj
oh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@21
0840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e
00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[
mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l0
50Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0b1?l[
mo[om03monh00?ol003ok`00oo`00?oM003omP00ond00?n108401P00ob_gn_l0
;PCo:oOjoo@00?on003ok`00onT00?oG003omP00ond00?n108401P00ob_gn_l0
K`Co:oOjoo@00?om003ooP3nood0o_on0?kooP01ooon00?o0?ooo@3nooh0o_on
007oood0o_on00?o0?oonP03o`3oood0o_on0?koo@3nooh0oOom0?koo@3nooh0
0?on003oP@2300Co:oOjo`2>1?l[mo[om000ood00ol00?on00?o003ooP00ooh0
0?ol003ooP07ool00?l00?on003ooP00oo`00?on003ooP07o`00ool00?ok00Oo
o`00o`00ooh00?on003oo@00ooh00ol00?on00?o003ooP03o`00ooh01_l00?l0
0?on003oP@2600Co:oOjo`221?l[mo[om000ood00ol00?on00?o003onP00oo`0
0?on003ooP00ooh0oOon003oo000ooh00?on00?o003ooP00oo/00?on00?o003o
oP00ooh00?om003ooP03o`00ooh00ol00?on00?o003ooP05o`00o`3oP@2100Co
:oOjo`201?l[mo[om000ood00_l00?cooP3nood00?ol003ooP00ooh00ol00?on
003ooP00oo`00?on003ooP03o`00ooh00?ok003ooP03o`00ooh00?on003oo@3l
o`800?on00?o003ooP03o`00ooh01?l00?ooP@2100D0ob_gn_l0O`Co:oOjoo@0
0?om00?o003om`00ooh00?ol003ooP00ooh00ol00?on003ooP00oo`00?on003o
oP03o`00ooh00?ok003ooP03o`00ooh00?on003oo@00oo/00?on00?o003ooP03
o`00ooh01Ol00?l0oh40P@04ob_gn_l0R`Co:oOjoo@00?on003ooP00ooh00ol0
0?on003ooP00oo`00?on003ooP03o`00ooh00?on003oo000ooh00?on00?o003o
oP00oo/00?on00?o003ooP00ooh00?om003ooP03o`00ooh00ol00?on00?o003o
oP06o`00o`00oh40PP04ob_gn_l0LPCo:oOjoo@0oOol0?koo@3noo`00OoooP00
ooh00?on003ooP3mood00OoooP00ood0o_on003ooP00oo/00?on003ooP3noo`0
0OoooP3nooh0oOom0?koo@3nooh00?on00?o003oP@2600Co:oOjo`0D1?l[mo[o
P@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840
P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D0
1?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_g
n_l05PCo:oOjon80oOn10840V004ob_gn_l0;PCo:oOjon@00Oooo@01oooi0?go
g000onX00?of003ok@00oh40Q@04ob_gn_l0<0Co:oOjonD00?oi003on`00ood0
0?oM003ojP00ooH00?o]003oP@2500Co:oOjo`1[1?l[mo[oi@02o`00oOl2003o
n`00ooX00?on00Co003o0?ko0P3o0?ko0@00o_on00?o0?oooP3nooX00ol0ooom
0?kooP3nood0o_on0?goo@3nood0o_on003ooP00oh40R@04ob_gn_l0NPCo:oOj
onH00_l00?_o0P00oo`00?oj003ooP04o`00ooom007oood00?on00Oo003oo`00
ooh00?oi00Ooo`00o`00ooh00?on003oo@00ooh00ol00?on00?o003ooP03o`00
ooh01_l00?l00?n108P01?l[mo[o07L4ob_gn_oV00;o003ko`800?ol003onP00
ooh00ol00?ol003oo000ooh00ol00?on003ooP00ooT00?on00?o003ooP00ooh0
0?om003ooP03o`00ooh00ol00?on00?o003ooP05o`00o`3oP@2700Co:oOjo`1`
1?l[mo[oiP02o`00nol2003oo000ooX00?on00?o003oo000oo`0o?l2003ooP00
ooh00?oi003ooP03o`00ooh00?on003oo@3lo`800?on00?o003ooP03o`00ooh0
1?l00?ooP@2600Co:oOjo`1a1?l[mo[oiP02o`00nol2003oo000ooX00?on00?o
003oo000oo`00?ok003ooP00ooh00?oi003ooP03o`00ooh00?on003oo@00oo/0
0?on00?o003ooP03o`00ooh01Ol00?l0oh40Q`04ob_gn_l0N`Co:oOjonD00_l0
0?go0P00oo/00?om00[o003o003oo`00oo`00?ol003ooP03o`00ooh00?on003o
n@00ooh00ol00?on003ooP00ood00?on00?o003ooP03o`00ooh00ol00?on00Ko
003o003oP@2800Co:oOjo`1T1?l[mo[oi@00ooT00?oj0?goo@06ool0o`00oo`0
0?ok0?kooP00ooh00?om007ooo/00?on003ooP3noo`00OoooP3nooh0oOom0?ko
o@3nooh00?on003oP@2900Co:oOjo`0L1?l[mo[oi001ooom007ooh40P@2J00Co
:oOjo`0F1?l[mo[ohP3moh40P@2H00Co:oOjo`0D1?l[mo[oP@210840m@04ob_g
n_l05PCo:oOjoh40^035oh40nP04ob_gn_l070Co:oOjoh40^@01ooo7007ooh40
n`04ob_gn_l070Co:oOjoh40^P01ooo5007ooh40o004ob_gn_l06PCo:oOjoh40
^P00ol<00?n10?`01?l[mo[o01h4ob_gn_oR0?goP@3M003o``00oh40o004ob_g
n_l0CPCo:oOjon@00Oooo@01oooi0?goo@00ood00?oK003omP00ond00?oV003o
o@02o`00o?on003oj@00ooX0o?o?003oP@3l00Co:oOjo`1G1?l[mo[oi@00ooT0
0?ok003oo@00ooh00?om003of`00ooH00?o]003oiP00ood00ol00?om00?o003o
j@00ooX01Ooo003oom000?n10?`01?l[mo[o0:/4ob_gn_oU003on@00oo/00?om
00;o003nooh00ol0ooom0?kooP01o`3noo`00ol0ooom0?kooP3nood0o_on0?go
o@3nood0o_on003ooP00ooX0o_on007o0?koo000ood00ol00?om00?o003oj@00
ooX03_oo003oo`00ool0ool00?gooP09ool00?oo003oooh0o_om0?gon000oh40
o004ob_gn_l0b0Co:oOjonH00?og003oo000ood00?on003oo@07ool00?l00?on
00Co003oooT01ooo003o003ooP00ooh00?om003ooP03o`00ooh00ol00?on00?o
003ooP06o`00o`00ooX00?on00Co003oooT00?om00?o003oo@03o`00oo/00?o`
003onP07ool00?oo003nooh08?oo003oo`00ool00?oo003oo`00ool00?l00?oo
003oooT00?n10?`01?l[mo[o0;T4ob_gn_oV003om`00oo`00?om003ooP00ood0
0?on00?o003ooP03o`00ooP00?on00?o003ooP00ooh00?om003ooP03o`00ooh0
0ol00?on00?o003ooP05o`00o`3on@00ooh00ol00?oh003oo@02o`00o?on003o
j@00ooX0o?on007oood04ooo003oo`00ool00?oo003oo`00o_om00Goo`00oooi
003oP@3l00Co:oOjo`2c1?l[mo[oiP00ooL00?ol003oo@00ooh00?om003ooP02
o`00o?l2003on000ooh00ol00?on003ooP00ood0o?l2003ooP03o`00ooh00ol0
0?on00Co003oooP00?on00?o003on000ood01Ol00?l0oo`00?oY003onP09ool0
0?oo003oood04Ooo003oo`00ool00?oo003oooh0o_on0?_on@00oh40o004ob_g
n_l0]@Co:oOjonH00?og003oo000ood00?on003oo@00ooh00ol00?ok003on000
ooh00ol00?on003ooP00ood00?ok003ooP03o`00ooh00ol00?on00Go003o0?oi
003ooP03o`00ooP00?om00Ko003o003oo@00onT00?oj00Woo`00ool00?ooo@0A
ool00?oo003oo`00ool00?ooo@3no`<00?oom@00oh40o004ob_gn_l0``Co:oOj
onD00?oi003on`00ood00?on003oo@00ooh00ol00?on00?o003on000ooh00ol0
0?on003ooP00ood00?on00?o003ooP03o`00ooh00ol00?on00Ko003o003onP00
ooh00ol00?oh003oo@03o`00ooh00?on003oj@00ooX02Ooo003oo`00ooom013o
o`00ool00?oo003oo`00ooh02?l00?oo003oooh00?oi003oP@3l00Co:oOjo`2F
1?l[mo[oi@00ooT00?oj0?goo004ool00?on003ooP3nooh00?oh003ooP00ooh0
o_ol007oooh0o_on0?goo@3nood0o_on003ooP00ooX0o_on003om`3mooh00?om
00;o003lo`800?o`003onP3looh00Oooo03mooh0nOol0?koo@3mooP00?n10?`0
1?l[mo[o02@4ob_gn_oT007oood00OooP@3O003o``00oh40o004ob_gn_l07PCo
:oOjon80oOn10=d00?o3003oP@3l00Co:oOjo`0L1?l[mo[oP@2j007oolD00Ooo
P@3l00Co:oOjo`0L1?l[mo[oP@2i007oolL00OooP@3k00Co:oOjo`0F1?l[mo[o
P@2h0<GoP@3j00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40
P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840
m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co
:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l05PCo:oOjomL0POn1oj_om@04ob_g
n_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d0
0?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL0
0?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J
1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD0
1?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40
P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_g
n_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_g
n_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d0
0?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL0
0?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J
1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD0
1?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40
P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_g
n_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_g
n_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d0
0?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL0
0?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J
1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD0
1?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40
P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_g
n_oG003oP@210:d00?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_g
n_l06PCo:oOjomL00?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d0
0?oe00Co:oOjo`0J1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL0
0?n10840[@00ooD01?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0J
1?l[mo[oe`00oh40P@2]003om@04ob_gn_l06PCo:oOjomL00?n10840[@00ooD0
1?l[mo[o01X4ob_gn_oG003oP@210:d00?oe00Co:oOjo`0F1?l[mo[oe`21oh7o
Zooe00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D0
1?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_g
n_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D
1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_g
n_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40
P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840
m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o0404ob_gn_od0?gokP00oo`0
0?o_003oo000on000?om003oo@00ooX00?oT003omP00ond00?n10:`01?l[mo[o
03@4ob_gn_od003ooP00onl00?oY003oe@00ood00?oL003omP00ond00?n10:`0
1?l[mo[o09H4ob_gn_od003oo@00ooh0o_om0?kooP3nooh00OoooP03o`3oood0
o_on0?kooP01ooom0?kooP03o`3oooX00?on003ooP04o`00ooon0?kooP03o`3o
ooh00OoooP03o`3oooX00ol0ooom0?kooP3nood0o_on0?goo@3nood0o_on003o
oP00oh40/004ob_gn_l0]PCo:oOjoo@00?om00?o003ooP03o`00ooh00?on003o
o000ooh01ooo003o003ooP00ooh00?ol003ooP00ooh01ol00?oo003on`00ooh0
0?on003ooP00ood00?om00Coo`00ooh00?on00Coo`00oo/01ooo003o003ooP00
ooh00?om003ooP03o`00ooh00ol00?on00?o003ooP06o`00o`00ooh00?n10;<0
1?l[mo[o0:P4ob_gn_od003oo@03o`00ooh00ol00?oj003oo000ooh00?on003o
oP3mooh00?ol003ooP00ooh00ol00?on003onP06o`3o0?l0ood00?om003oo@00
ooh00?on003ooP00ooh00?ok003ooP03o`00ooh00?on003oo@00ooh00ol00?on
00?o003ooP03o`00ooh01Ol00?l0oh40[P04ob_gn_l0Y@Co:oOjoo@00?om00;o
003looh0o_om003oo000ooh00?on00?o003ooP00ooh00?ol003ooP00ooh00ol0
0?on003onP06o`3o0?l0ood00?om003oo@00ooh00?on003ooP00ooh00?ok003o
oP03o`00ooh00?on003oo@3lo`800?on00?o003ooP03o`00ooh01?l00?ooP@2]
00Co:oOjo`2S1?l[mo[om000ood00ol00?og003ooP00oo`00?on003ooP03o`00
ooh00?on003oo000ooh00?on00?o003ooP00ooT00?on003oo000ood00?om003o
oP00ooh00?on003ooP00oo/00?on00?o003ooP00ooh00?om003on`00ooh00ol0
0?on00?o003ooP05o`00o`3oP@2^00Co:oOjo`2_1?l[mo[om000ooh00?on003o
oP03o`00ooh00?on003oo000ooh00?on00?o003ooP00ooh00?ol003ooP00ooh0
0ol00?on003on@00ooh00?ol003oo@00ood00?on003ooP00ooh00?on003on`00
ooh00ol00?on003ooP00ood00?on00?o003ooP03o`00ooh00ol00?on00Ko003o
003oP@2_00Co:oOjo`2F1?l[mo[om03moo`0o_om0?koo001ooon003ooP00ooh0
0?on0?goo@01ooon003oo@3nooh00?on003on@00ooh00?ol003oo004ool00?on
003ooP00ooh00?on003on`00ooh00?on0?koo001ooon0?kooP3mood0o_om0?ko
oP00ooh00ol00?n10;<01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[
mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n1
0840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@21
0?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0F1?l[mo[ohP3moh40P@2H
00Co:oOjo`0d1?l[mo[oi001ooom007oooX0o?og003oo000omh00?of003ok@00
oh40P@3l00Co:oOjo`0^1?l[mo[oi@00ooT00?ok003ol`00omP00?of003ok@00
oh40P@3l00Co:oOjo`1P1?l[mo[oi@00ooT00?ok003on`03o`3oooh0o_on007o
ooh00Ol0o_l1003nooX00ol0ooom0?kooP3nood0o_on0?goo@3nood0o_on003o
oP00oh40P@050?l[mo[o0744ob_gn_oV003om`00oo`00?ok00Coo`00ooh00?ol
003ooP01ooom003ooP00oo/01ooo003o003ooP00ooh00?om003ooP03o`00ooh0
0ol00?on00?o003ooP06o`00o`00oh40P@06003o:oOjo`1_1?l[mo[oiP00ooL0
0?ol0?gooP00ooh00?on003oo000ooh00?ol003ooP00oo/00?on00?o003ooP00
ooh00?om003ooP03o`00ooh00ol00?on00?o003ooP05o`00o`3oP@210?h01?l[
mo[o06L4ob_gn_oV003om`00oo`00?ok003ooP00ooh00?ol003ooP00oo`0o?ok
003ooP03o`00ooh00?on003oo@3lo`800?on00?o003ooP03o`00ooh01?l00?oo
P@210?d01?l[mo[o06P4ob_gn_oV003om`00oo`00?ok003ooP00ooh00?ol003o
oP00oo`00?og003ooP03o`00ooh00?on003oo@00oo/00?on00?o003ooP03o`00
ooh01Ol00?l0oh40P@3n00Co:oOjo`1`1?l[mo[oi@00ooT00?ok003on`00ooh0
0?on003oo000ooh00?ol003ooP00oo/00?on00?o003ooP00ooh00?om003ooP03
o`00ooh00ol00?on00?o003ooP06o`00o`00oh40P@06003o:oOjo`1O1?l[mo[o
i@00ooT00?ok0?co0P00ooh00?om007oooh00?on003on`3nooX00?on003ooP3n
oo`00OoooP3nooh0oOom0?koo@3nooh00?on003oP@2100D0ob_gn_l070Co:oOj
on@00Oooo@01oon10840VP04ob_gn_l05PCo:oOjon80oOn10840V004ob_gn_l0
50Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[
mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n1
0840P@3e00Co:oOjo`0F1?l[mo[ohP3moh40P@2H00Co:oOjo`111?l[mo[oi001
ooom007oooT0oOog007oooh00Oooi`00ood00?om003omP00ood00?o_003oP@21
00D0ob_gn_l0?@Co:oOjonD00?oi003on`00ood00?og003oo@00on800?om003o
mP00ood00?o_003oP@2100D0ob_gn_l0IPCo:oOjonD00_l00?go0P00oo/00?oi
0?koo@00ood00?om0?konP00ooh00?on00Co003oooh0o_on00?o0?oonP3nooh0
0ol0ooom0?konP3nood0o_om0?goP@2@00Co:oOjo`1m1?l[mo[oiP02o`00nol2
003oo000ooX00?on003ooP00ood00?on003ooP00oo/00?on003ooP00ooh00?om
003oo@04ool00?oj003oo@07ool00?l00?on003onP00ood00?on00?o003ooP03
o`00oh40T`04ob_gn_l0L@Co:oOjonH00_l00?_o0P00oo`00?oj003ooP00ooh0
0?om003ooP00ooH01_l0o`3o0?om003oo@00ood00?on003onP00ood00?on00?o
003ooP00ooX00?ol0?go0P00ooh00?n109001?l[mo[o06d4ob_gn_oV00;o003k
o`800?ol003onP3looh00?om003oo@3nooT01_l0o`3o0?om003oo@00ood00?on
003onP00ood00?on00;o003looX00?om003ooP03o`00ooh00?n109001?l[mo[o
06X4ob_gn_oV00;o003ko`800?ol003onP00ooX00?om003onP00ooT00?on003o
o000ood00?om003ooP00ooX00?om003ooP03o`00ooH00?om003ooP03o`00ooh0
0?n109001?l[mo[o07T4ob_gn_oU00;o003mo`800?ok003oo@03o`00ooh00?on
003oo@00ooh00?on003on@00ooh00?ol003oo@00ood00?on003onP00ood00?on
00?o003ooP00ooX00?om003ooP03o`00ooh00?n109001?l[mo[o06D4ob_gn_oU
003on@00ooX0oOom0?koo@00ood00?om0?kon000ooh00?ol003oo004ool00?on
003on@04ool00?on003ooP3nooP00OoooP3mooh0oOl2003oP@2C00Co:oOjo`0N
1?l[mo[oi001ooom007ooh`00?n109001?l[mo[o01`4ob_gn_oR0?goSP00ooh0
0?n109001?l[mo[o01H4ob_gn_n10>X0o_n108l01?l[mo[o01@4ob_gn_n10840
P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D0
1?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oe`21oi?oS@04ob_g
n_l060Co:oOjomL00?n109D00?n=00Co:oOjo`0H1?l[mo[oe`00oh40U@00ohd0
1?l[mo[o02@4ob_gn_oG00;o0021oiWo0P00ooT0n_oU003o^@04ob_gn_l090Co
:oOjomL00_l0087oVOl2003omP00on800?ni00Co:oOjo`1C1?l[mo[oe`02o`00
POnIo`800?of003on`3nooT0o_om0?kooP3nooX00?on00;o003mooX00ol0ooom
0?kooP00ooh00?on003ojP04ob_gn_l0M0Co:oOjomL01?l00?ooo03no`00gOon
0?cooP21om?o0P00ooH00?ol003ooP00oo/00?on00?o003ooP00ooh00?oi003o
oP03o`00ooh00?ok00Ooo`00o`00ooh00ol00?on003ooP00onX01?l[mo[o07<4
ob_gn_oG00Go003oo`3Fo`00o_l00?ko003no`00POoDo`800?of003oo000ooh0
0?ok003on`00ooh00?on003on@00ooh00ol00?on003on`00ooh00ol00?on003o
oP06o`3o0?l0onT01?l[mo[o08L4ob_gn_oG00Go003oo`3ko`400?goo@02ool0
o_l40?oo0?on007oooh0n_l00?go0`3oo`3mo`00POoDo`800?of003oo000ooh0
0?oj0?kooP3looh00?oi003ooP03o`00ooh00?ok003ooP02o`00o?on00Ko0?l0
o`3oj@04ob_gn_l0O`Co:oOjomL01Ol00?oo0?[o003no`00o_l30?oo0?ko103o
o`00oOl00?ko003fo`00n_l0087oe?l2003omP00oo`00?on003om`03o`00ooX0
0?oi003ooP03o`00ooh00?ok003ooP03o`00ooT00?on003oj004ob_gn_l0R`Co
:oOjomL01?l00?ooo@3mo`00o_l00?ko0`3oo`3no`<0ool0o?l00?ko003go`00
n_l0087odol2003omP00oo`00?on003on`00ooh00ol00?on003ooP00ooT01ol0
0?oo003ooP00oo/00?on00?o003ooP00ood00?on003oj004ob_gn_l0M@Co:oOj
omL01Ol00?oo0?[o003no`00o_l30?oo0?ko0`3oo`3loo`0n?l00?[o0021om;o
0P00ooH00?ok0?kon@3nood0o_ol007oooX01Ooo0?l00?gonP00ooh00?on0?ko
o000ooh00?oX00Co:oOjo`151?l[mo[oe`05o`00ool0n_l00?ko003no`<0ool0
o_l30?oo0?co003eo`00n_l0087odOl2003oaP00olT01?l[mo[o04T4ob_gn_oG
00Go003oo`3jo`00o_l00?ko2P3oo`3oo`00ool0o?l00?ko003jo`00n_l0087o
d?l2003oaP00olT01?l[mo[o03h4ob_gn_oG00Go003oo`3jo`00oOom0?ko1P00
o`3oo`3kooh0n_ok007ooo/0POoDo`800?n=00Co:oOjo`0P1?l[mo[oe`02o`00
kol0087o[?l2003oS@04ob_gn_l090Co:oOjomL00_l00??o003no`00POn/o`80
0?n=00Co:oOjo`0P1?l[mo[oe`02o`00l_on087oZol2003oS@04ob_gn_l070Co
:oOjomL00_l0087oVOl2003oS@04ob_gn_l090Co:oOjomL00?n109D00?og003o
aP00ood00?oI00Co:oOjo`0T1?l[mo[oe`00oh40U@00ooL00?o6003oo@00omT0
1?l[mo[o04<4ob_gn_oG087oTooh0?koo@3nood0oOon0?komP00ooh00?on0?ko
o@3nooX0o_on00?o0?ooo@3non<01?l[mo[o05/4ob_gn_oG087oX_ocm@3om`00
ood00?on00?o003ooP03o`00ooh00?og003ooP03o`00ooh00ol00?on003onP00
ood01ooo003o003ooP00on@01?l[mo[o0544ob_gn_oG087oX_ocm@3om`00oo`0
oOl2003ooP03o`00oo<00?on00?o003on`00ooh00?oj003oo@00ooh00ol00?on
003oi004ob_gn_l0E0Co:oOjomL0POnRoo_e0O[jnoD0ooL00?om003ooP03o`00
ooh00?on0?komP00ooh00?on0?kooP3looX00?om003ooP02o`00o?oT00Co:oOj
o`1T1?l[mo[oe`3koo`0o_l00=gooP3looh0POoPooce0o[emO[lm@3om`00ood0
0?on00?o003ooP00oo/00?og003ooP00oo/00ol00?of003oo@00ooh00ol00?oP
00Co:oOjo`1g1?l[mo[oe`3ko`00e_l00?ko003no`00o_l0087ohOomm@3joOD0
n_ge0?og003oo@00ooh00ol00?on00?o003ooP00ooL01ol00?oo003ooP03o`00
ooh00?oj003oo@00ooh00ol00?on003oi004ob_gn_l0P`Co:oOjomL0nol00?_o
0@00oOom00;oo`3no`@0ool0ooh00OoooP3jo`00oOl30?oo0?go0021on7oo_D0
n__e0?[nm@3omP01ooon0?gooP3mooh0o_om003onP03ool0ooh0o_om0?kon004
ool00?on003ooP3non<01?l[mo[o0584ob_gn_oG0?_o003jo`00o_l00?ko0`3o
o`3no`@0ool00?go003no`00m_l00?[o0021on7o0_Gen_We0o[emOoW003om`00
ok<01?l[mo[o05D4ob_gn_oG0?_oo@3mo`00o_l00?ko0`3oo`3no`<0ool0o?l0
0?ko003go`00n_l0087oh?l0mOgjoOGmnP7eon/00?on003on000ok801?l[mo[o
04X4ob_gn_oG0?_o003jo`00o_l00?ko0`3oo`3no`<0ool0o?ol0?So003jo`00
POoOooge0?[mm@3joOD0onX0o_nW00Co:oOjo`161?l[mo[oe`3ko`00n_l00?ko
003no`<0ool0o_l30?oo0?co003eo`00n_l0087og_omm@3joOD0n_ge0?n=00Co
:oOjo`1:1?l[mo[oe`3ko`00n_l00?ko003no`X0ool0ool00?oo0?co003no`00
n_l00?[o0021omgooOD0n_ge0?[mm@3oS@04ob_gn_l0?`Co:oOjomL0nol00?[o
003mood0o_l6003o0?oo0?_ooP3joo/00Ooon`21on7ooOGkn_ge0?n=00Co:oOj
o`0P1?l[mo[oe`3[o`00POnioo?e0?oM003o/P04ob_gn_l0=0Co:oOjomL0kol0
0?ko0021okWoloD0ooD00?oh003on`00oo/00_l00?co^@04ob_gn_l0=0Co:oOj
omL0k_on087o^?ocnP3om@00ooP00?ok003oo000ooh00?om003o^P04ob_gn_l0
D@Co:oOjomL0POnRoo?e0?of00;o0?ol0?gooP3moo`00?on003oo@00ooh0o_on
00Oo0?oo003oood0o_on003ooP00ooh0o_oP00Co:oOjo`1T1?l[mo[oe`00oh40
Y000oo?e0?of00;o0?om003ooP03o`00ooh00?om003oo@00ood00ol00?on00ko
003oo`00ool00?l00?on00?o003ooP03o`00ooh00?oQ00Co:oOjo`1S1?l[mo[o
e`00oh40Y000oo?e0?og003ooP00ooh00?on00?o003ooP00ood00?om0?cooP00
ooh00ol00?on003ooP03o`00ooh00ol00?on00?o003ooP00on401?l[mo[o05h4
ob_gn_oG003oP@2T003oloD0ooL00?on003ooP00ooh00ol00?on003ooP00oo`0
0_l0oo`0o?l2003ooP00ooh00ol00?on003ooP02o`3ooP3lon401?l[mo[o05/4
ob_gn_oG003oP@2T003oloD0ooP0n_l2003ooP03o`00ooh00?on003oo003o`00
ood00?ok003ooP00ooh00ol00?on003ooP02o`3ooP00omd01?l[mo[o06<4ob_g
n_oG003oP@2T003oloD0ooP00?ol00?o003ooP03o`00ooh00ol00?ok003ooP00
ooh00?on00?o003ooP00ooh00ol00?on003oo@00ood00?on003oh@04ob_gn_l0
E0Co:oOjomL00?n10:@00?ocm@3on000oo`00?on0?gooP3mo`800?ok003oo@00
ooh0o_on003ooP00ooh00?on0?koo000oo`0o_oP00Co:oOjo`0L1?l[mo[oe`00
oh40Y000oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=00Co:oOj
o`0L1?l[mo[oe`00oh40Y000oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00oh40Y000
oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=00Co:oOjo`0L1?l[
mo[oe`00oh40Y000oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=
00Co:oOjo`0^1?l[mo[oe`00oh40Y000oo?e0?og0?gom`01ooon007ooo/0n_ni
00Co:oOjo`0`1?l[mo[oe`00oh40Y000oo?e0?oh003oo@00ooL00?om003on000
okH01?l[mo[o03`4ob_gn_oG003oP@2T003oloD0ooP00?oi0?koo@00ood00?oh
003on`3nood0oOon0?koc@04ob_gn_l0BPCo:oOjomL00?n10:@00?ocm@3on000
ooX00?on003ooP00ood00?oh003oo000ooh00ol00?on00?o003ooP00olh01?l[
mo[o04<4ob_gn_oG003oP@2T003oloD0ooP00?oj003ooP00ooh00?om003on000
oo/0oOl2003ooP03o`00olX01?l[mo[o04<4ob_gn_oG003oP@2T003oloD0ooP0
0?oj0?cooP00ood00?oh003oo000ooh00ol00?on003ooP3nold01?l[mo[o04<4
ob_gn_oG003oP@2T003oloD0ooP00?oj003onP00ood00?oh003oo000ooh00ol0
0?on003on`00olh01?l[mo[o04d4ob_gn_oG003oP@2T003oloD0ooP00?om00?o
003ooP00ooh00?om003on000oo`00?on00?o003ooP03o`00ooh00?o>00Co:oOj
o`0l1?l[mo[oe`00oh40Y000oo?e0?og0?goo@3nood00?om003on000oo/0oOon
0?gooP3nold01?l[mo[o0204ob_gn_oG003oP@2T003oloD0olP00?o700Co:oOj
o`0T1?l[mo[oe`00oh40Y000oo?e0?o<003ooP00olL01?l[mo[o0204ob_gn_oG
003oP@2T003oloD0ol/0o_o600Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=
00Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00
oh40Y000oo?e0?n=00Co:oOjo`0L1?l[mo[oe`00oh40Y000oo?e0?n=00Co:oOj
o`0/1?l[mo[oe`00oh40Y000oo?e0?o2003onP00oo800?om003ojP04ob_gn_l0
:0Co:oOjomL00?n10:@00?ocm@3o`P00onX00?om003ojP04ob_gn_l0I0Co:oOj
omL00?n10:@00?ocm@3om`3nood0o_on00Oo0?oo003oooh01ol0ool00?ooo@3n
ooh00ol0ooom0?gon`01ooon00?o0?oonP3nooh00ol0ooom0?kom004ob_gn_l0
M@Co:oOjomL00?n10:@00?ocm@3on000ooh00ol00?on01Wo003oo`00ool00?l0
0?oo003oo`00o`00ooh02_l00?oo003o003ooP00ooX00?on00Coo`00ooX00?om
00Ooo`00o`00ooh00?oe00Co:oOjo`1`1?l[mo[oe`00oh40Y000oo?e0?oh003o
n`00ooh00ol00?on003ooP03o`00ooh00?on003ooP3mo`800?on00?o003ooP00
ooX00?on003ooP00ooX00?om003ooP03o`00ooh00?oe00Co:oOjo`1_1?l[mo[o
e`00oh40Y000oo?e0?oh003on`00ooh00ol00?on003ooP03o`00ooh00?on00?o
003ooP03o`00ooh00ol00?on003onP00ooh00?on003onP00ood00?on00;o003l
ooD01?l[mo[o06h4ob_gn_oG003oP@2T003oloD0ooP00?ok003ooP03o`00ooh0
0?on00?o003ooP00ooh00ol00?on00?o003ooP03o`00ooh00?oj003ooP00ooh0
0?oj003oo@00ooh00ol00?oa00Co:oOjo`1e1?l[mo[oe`00oh40Y000oo?e0?oh
003ooP03o`00ooh00ol00?on003ooP03o`00ooh00?on00?o003ooP03o`00ooh0
0ol00?on003onP00ooh00?on003onP00ood00?on00?o003ooP00ooD01?l[mo[o
06L4ob_gn_oG003oP@2T003oloD0ooL0o_om0?kooP00ooh00?on00?o003ooP00
ooh00?on0?go0P00ooh00?on0?gonP00ooh00?on003on@04ool00?on003ooP3n
oo@01?l[mo[o01`4ob_gn_oG003oP@2T003oloD0ohd01?l[mo[o01`4ob_gn_oG
003oP@2T003oloD0ohd01?l[mo[o01`4ob_gn_oG003oP@2T003oloD0ohd01?l[
mo[o01`4ob_gn_oG003oP@2T003oloD0ohd01?l[mo[o01`4ob_gn_oG003oP@2T
003oloD0ohd01?l[mo[o01`4ob_gn_oG003oP@2T003oloD0ohd01?l[mo[o01`4
ob_gn_oG003oP@2T003oloD0ohd01?l[mo[o02P4ob_gn_oG003oP@2T003oloD0
ooP0o?on003ol`00ojh01?l[mo[o02@4ob_gn_oG003oP@2T003oloD0ooP00?o[
003o[P04ob_gn_l0CPCo:oOjomL00?n10:@00?ocm@3on000oo/00OoooP03o`3o
ood0oOok00Oo0?oo003oood0o_on00?o0?oooP00ooh00?oB00Co:oOjo`1D1?l[
mo[oe`00oh40Y000oo?e0?oh003onP00ooh01ooo003o003ooP00oo/02ooo003o
o`00o`00ooh02_l00?oo003o003ooP00om801?l[mo[o05@4ob_gn_oG003oP@2T
003oloX0ooP0oOom003ooP00ooh00ol00?on003on`00ooh00?on00?o003ooP03
o`00ooh00ol00?on003odP04ob_gn_l0DPCo:oOjomL00?n10:@00?ocm@3on000
ooX00?on003ooP03o`00ooh00?ok003ooP00ooh00_l00?co0P00ooh00ol00?on
003odP04ob_gn_l0D@Co:oOjomL00?n10:@00?ocm@3on000ooX00?on003ooP03
o`00ooh00?ok003ooP00ooh00ol00?ok003ooP03o`00ooh00?oB00Co:oOjo`1H
1?l[mo[oe`00oh40Y000oogeno[mm@3on000ooX00?on003ooP03o`00ooh00?ok
003ooP00ooh00ol00?on00?o003ooP07o`00o`00oooB00Co:oOjo`1J1?l[mo[o
e`00oh40Y000ooge0?[mm@3joOD0ooP00?oj003ooP00ooh00?on0?gon`00ooh0
0?on003ooP3nooh00?on003ooP06ool0o`00omD01?l[mo[o02@4ob_gn_oG003o
P@2T003ooOD0n_ge0?[mm@3oS@04ob_gn_l090Co:oOjomL00?n10:@00?omm@3j
oOD0n_ge0?n=00Co:oOjo`0R1?l[mo[oe`00oh40Y001ooGmn_geoOX1mOn=00Co
:oOjo`0R1?l[mo[oe`00oh40Y003ooGen_We0o[emOn=00Co:oOjo`0T1?l[mo[o
e`00oh40Y000ooke0?[km@3jo_D0ohd01?l[mo[o02@4ob_gn_oG003oP@2T003o
oOD0n_ge0?[mm@3oS@04ob_gn_l08`Co:oOjomL00?n10:@00?olm@?jmOGjo?D0
ohd01?l[mo[o0244ob_gn_oG003oP@2T003onoD1n_[km@3oS@04ob_gn_l070Co
:oOjomL00?n10:@00?ocm@3oS@04ob_gn_l070Co:oOjomL00?n10:@00?ocm@3o
S@04ob_gn_l050Co:oOjomL0POnCohd01?l[mo[o01@4ob_gn_n10840P@3e00Co
:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o
01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co
:oOjoh40P@210?D01?l[mo[o01H4ob_gn_n10840`P31oo@01?l[mo[o01H4ob_g
n_n10840a02mooH01?l[mo[o01H4ob_gn_n10840a@2kooL01?l[mo[o01X4ob_g
n_n10840aP3lol<0o?oh00Co:oOjo`0T1?l[mo[oP@3]0;kokP2noo<0o_on0<Go
oP3nooP01?l[mo[o03@4ob_gn_n10>l00Ooo_P01ooob007ookh00OoomP3mo`80
ooo500;oo`3mooT01?l[mo[o0304ob_gn_n10>l00?nl003olP00ok`00?of0?ko
0P00ol<00_l00?kon@04ob_gn_l0;PCo:oOjoh40l000okX00?od003o^P00ooL0
o_l10?o1007o0?kon@04ob_gn_l0;PCo:oOjoh40l000okX00?od003o^P00ooL0
o_l10?o1007o0?kon@04ob_gn_l0D`Co:oOjoh40l000on/01Ooo003oooL00Ooo
hP00oo@00?oa0?gog`01ooob003om`3no`40onP0oOon007oooh00Oooj001o`3n
ooT01?l[mo[o05/4ob_gn_n10?000?o[00Goo`00ooog007oon800?od003olP01
ooon003oh001ooob003om`3no`40onT03Ooo003oo`00ool00?ooi`01o`3nooT0
1?l[mo[o06h4ob_gn_n10?000?o[00Goo`00ooon0?gooP03ool00?coj@00oo@0
0?ob007oooX0oOon0?coo@3nood0oOon007ooo800?og0?ko0@3oj@0<ool00?oo
003oo`3oonH00Ol0o_oi00Co:oOjo`211?l[mo[oP@3`003oj`0Iool00?oo003o
o`00ool00?oo003oo`00oooZ003om000oo800Ooon`00ooh07?oo003oo`00ool0
0?oo003o003oo`00ool00?oolP00ooL0o_l10?oY00Ooo`00ool00?goi@01o`3n
ooT01?l[mo[o07L4ob_gn_n10?000?o[0?_o4`00ool00?oo003oo`00ool00?oo
jP00oo@00?ob007oooX0o?l;003oo`00ool00?ooo009ool00?oo003ooo800?og
0?ko0@3oj@07ool00?oo003non@00Ol0o_oi00Co:oOjo`1h1?l[mo[oP@3`003o
j`07ool00?oo003ko`/00?oo003oo`00oooZ003om000oo800Ooon`0Aool00?oo
003oo`00ool00?ooo03ko`<00?oolP00ooL0o_l10?oY00Ooo`00ool00?goi@01
o`3nooT01?l[mo[o07`4ob_gn_n10?000?o[00Woo`00ool00?oon`09ool00?oo
003oonX00?od003olP01oook017oo`00ool00?oo003oo`00oool007ooo/00Ooo
lP00ooL0o_l10?oY00coo`00ool00?oo0?ooiP01o`3nooT01?l[mo[o08P4ob_g
n_n10?000?o[00Woo`00ool00?oooP0<o`00ool00?oo003oonX00?od003olP01
ooon01_o003oo`00ool00?oo003oo`00ool00?l00?oooP04o`00ooob003om`3n
o`40onT03Ooo003oo`00ool00?ooi`01o`3nooT01?l[mo[o0704ob_gn_n10?00
0?o[00Goo`00ooon0?gooP03ool00?coj@00oo@00?oa0?goo@3lo`L00?oo003o
ooh0o_om0?gooP01ooob003om`3no`40onP0oOon007oooh00Oooj001o`3nooT0
1?l[mo[o03<4ob_gn_n10?000?oG007oonH00?od003o^P00ooL0o_l10?o1007o
0?kon@04ob_gn_l0<`Co:oOjoh40l000omL00OooiP00oo@00?nj003om`3no`40
ol400Ol0o_oi00Co:oOjo`0^1?l[mo[oP@3`003o^P00oo@00?nj003om`3no`40
ol400Ol0o_oi00Co:oOjo`0`1?l[mo[oP@3_003o_000oo800?nl003omP3no`80
0?o300;o003nooT01?l[mo[o03@4ob_gn_n10>l00Ooo_P01ooob007ookh00Ooo
mP3mo`80ooo500;oo`3mooT01?l[mo[o02@4ob_gn_n10>d0__o^0;kol`3nooh0
aOon0?kon004ob_gn_l06PCo:oOjoh40P@360?co``3looP01?l[mo[o01H4ob_g
n_n10840a@2kooL01?l[mo[o01H4ob_gn_n10840a02mooH01?l[mo[o01H4ob_g
n_n10840`P31oo@01?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[o
P@210840m@04ob_gn_l050Co:oOjoh40P@210?D01?l[mo[o01@4ob_gn_n10840
P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_gn_l050Co:oOjoh40P@210?D0
1?l[mo[o01@4ob_gn_n10840P@3e00Co:oOjo`0D1?l[mo[oP@210840m@04ob_g
n_l04P?o:oOjPOn1oh7olol3:oOjo`0A0ol[moZ1:h4[PB_b:`;gn_l03P7o:h7g
PON1mnog0O[o00`0oh7jPOZ1n^gj0?l0287oPOn1on_o003o\>"], "Graphics",
  ImageSize->{406, 333},
  ImageMargins->{{12, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
The selected text now appears (by default) as underlined blue text.\
\
\>", "Text"],

Cell[GraphicsData["PICT", "\<\
AMP0B0180B<22P0A0_l<0?ooool0B00004P0008:00018`000000000100X0B018
0B<22P2HPL80B0180B<22P000000000004P0001800000008004020000002dFC/
0000000000R0003o003oooooool00?ooooo<c000oooooiVI003oooooIVH00?oo
oolc<`00ooooo`00003oolc<ool00?ooc<c<c000ooo<c9VI003oolc<IVH00?oo
c<`c<`00ooo<c000003ooiVIool00?ooVIW<c000oonIVIVI003ooiVIIVH00?oo
VITc<`00oonIV@00003oofIVool00?ooIVK<c000oomVIYVI003oofIVIVH00?oo
IVHc<`00oomVIP00003ooc<cool00?oo<c?<c000oolc<iVI003ooc<cIVH00?oo
<c<c<`00oolc<`00003oo`00ool00?oo003<c000ool009VI003oo`00IVH00?oo
000c<`00ool00000003<c?ooool00<c<ooo<c000c<cooiVI003<c?ooIVH00<c<
oolc<`00c<coo`00003<c<c<ool00<c<c<c<c000c<c<c9VI003<c<c<IVH00<c<
c<`c<`00c<c<c000003<c9VIool00<c<VIW<c000c<bIVIVI003<c9VIIVH00<c<
VITc<`00c<bIV@00003<c6IVool00<c<IVK<c000c<aVIYVI003<c6IVIVH00<c<
IVHc<`00c<aVIP00003<c3<cool00<c<<c?<c000c<`c<iVI003<c3<cIVH00<c<
<c<c<`00c<`c<`00003<c000ool00<c<003<c000c<`009VI003<c000IVH00<c<
000c<`00c<`00000002IVOooool009VIooo<c000VIWooiVI002IVOooIVH009VI
oolc<`00VIWoo`00002IVLc<ool009VIc<c<c000VIW<c9VI002IVLc<IVH009VI
c<`c<`00VIW<c000002IVIVIool009VIVIW<c000VIVIVIVI002IVIVIIVH009VI
VITc<`00VIVIV@00002IVFIVool009VIIVK<c000VIUVIYVI002IVFIVIVH009VI
IVHc<`00VIUVIP00002IVC<cool009VI<c?<c000VITc<iVI002IVC<cIVH009VI
<c<c<`00VITc<`00002IV@00ool009VI003<c000VIT009VI002IV@00IVH009VI
000c<`00VIT00000001VI_ooool006IVooo<c000IVKooiVI001VI_ooIVH006IV
oolc<`00IVKoo`00001VI/c<ool006IVc<c<c000IVK<c9VI001VI/c<IVH006IV
c<`c<`00IVK<c000001VIYVIool006IVVIW<c000IVJIVIVI001VIYVIIVH006IV
VITc<`00IVJIV@00001VIVIVool006IVIVK<c000IVIVIYVI001VIVIVIVH006IV
IVHc<`00IVIVIP00001VIS<cool006IV<c?<c000IVHc<iVI001VIS<cIVH006IV
<c<c<`00IVHc<`00001VIP00ool006IV003<c000IVH009VI001VIP00IVH006IV
000c<`00IVH00000000c<oooool003<cooo<c000<c?ooiVI000c<oooIVH003<c
oolc<`00<c?oo`00000c<lc<ool003<cc<c<c000<c?<c9VI000c<lc<IVH003<c
c<`c<`00<c?<c000000c<iVIool003<cVIW<c000<c>IVIVI000c<iVIIVH003<c
VITc<`00<c>IV@00000c<fIVool003<cIVK<c000<c=VIYVI000c<fIVIVH003<c
IVHc<`00<c=VIP00000c<c<cool003<c<c?<c000<c<c<iVI000c<c<cIVH003<c
<c<c<`00<c<c<`00000c<`00ool003<c003<c000<c<009VI000c<`00IVH003<c
000c<`00<c<0000000000?ooool00000ooo<c000003ooiVI00000?ooIVH00000
oolc<`00003oo`0000000<c<ool00000c<c<c000003<c9VI00000<c<IVH00000
c<`c<`00003<c000000009VIool00000VIW<c000002IVIVI000009VIIVH00000
VITc<`00002IV@00000006IVool00000IVK<c000001VIYVI000006IVIVH00000
IVHc<`00001VIP00000003<cool00000<c?<c000000c<iVI000003<cIVH00000
<c<c<`00000c<`0000000000ool00000003<c000000009VI00000000IVH00000
000c<`00k^h00000003Mg@0000000;^k00000000ZZX000000028R000000007Mg
00000000EED000000014A0000000028R000000004A40000000000>k^00000000
gMd00000002k^`0000000:ZZ00000000R8P00000001gM`00000005EE00000000
A4@00000000R8P000000014A00000000003^kP0000000=gM00000000^k/00000
002ZZP00000008R800000000MgL00000001EE@00000004A4000000008R800000
000A4@00k^k^k^k^003MgMgMgMd00;^k^k^k^`00ZZZZZZZZ0028R8R8R8P007Mg
MgMgM`00EEEEEEEE0014A4A4A4@0028R8R8R8P004A4A4A4A000000000000B018
0B<22P1804P18`8:00002X7oPOn1ol3o00003P3oPB^1:h4[`b/2E?oo00l1ob^1
mH7ePOG4m@9Dool03`7o:h7ePOF1mLCe0UCoo`0Q0Ol[noX0mOJ/0?F1n]cj]OF1
n]_j0?Gf[03enoX2E?oo02`1ob_jm@2/mb^1mM?eoOonm@7oon[e0Oooj?D1oon1
mM?e0:cg:o[e0UCoo`120Ol[noX2mJ`[n_P2[2_ePO[Ln_[e0Oooo_D4ooGeoooZ
m@7oonWeo_ojmH7jfoX2mJ`[oOP5[?Sh[2_enoX2E?oo04`1ob_jm@6/:o[h0J`[
POGDm@7ooo_eo?ommOgoo_GlookeoOonmOgoo_D4oooeooojm@?omOooPOGCm@6/
:ogh1:chn:`[n_D2E?oo06@1ob_knP;e[2_jn0:/:oF1n]cjn_D1oookm@SoooGe
oooemOonm@WoooGeoooemOooo_D1ooonm@OoooGeoooemOkonOD4ooGeooojmH7j
foX2mJ`[oOP5[?Sh[2_enoX2E?oo05X1ob_jm@6/:o[h0J`[POGDm@7ooo_e1Ooo
mOGoookeo?l7mOGoooGeooonm@7oooke2OoomOGoooGeoooim@3oo_D1oon1mM?e
0J`[oOP4[?Sh[2_jm@9Dool0F`7o:o_j0_F/:o[h0Z`[mH7jg?[jm@7ooo_e5Ooo
mOGoooGeoooemOoomOGoooGeooonm@7oookenol3mOGoooWen_okmH7jfoX2mJ`[
o:`4n?R/:oGknP9Dool0D`7o:o[e0J`[n_P1[2^1mMCe0OoonoDEoooemOoomOGo
ooGeoooemOoomOGoooke0Oooo_D1oookm@7oooGe0OooPOGCm@6/:o[h0J`[n_D2
E?oo0641ob_knP;e[2_jn0:/:oF1n]cjn_D1ooonmASomOGoooGeoooemOoomOGo
ooGeoooemOooo_D1ooonm@7oooke1?oemOoomOD1ooojmH7jfoX2mJ`[n_P2[2_e
noX2E?oo04P1ob_jm@6/:oV/02^1mM?eoOonm@GoooGeooonmOco0OGeo?olm@7o
ookeoOonm@7oooGe0OooPOGCm@6/:oV/02_jm@9Dool0:07o:o_j0OF/mb/0mH7j
g?[Rm@7oomKePO[KnP7e[?L[0?GknP9Dool04P7o:h7eZ_D1oon1mIge0UCoo`0?
0Ol[POF1mH7ea?D2E?oo00d0oh5DPEB1E<9D0Ooo00R1oh7oPOnoo`0B0?n10840
P@3A003om002n_oo01<0oh40P@210=400Ol0mOH2n_oo01L0oh40P@210=400Ol0
o?H0[?_f0_[oo`0I0?n10840P@3A007o0?gf0ZaD[?cf0_[oo`0O0?n10840P@3J
0?cBo@01o`3nmP2/oU@0[?gf0_[oo`0N0?n10840P@3F003Bo@04o`3fmZclE02/
o_H2n_oo01`0oh40P@210=T0oM;m00?o0?J/nU@5[?Kfn_oo0200oo40nOn10840
P@3^003Bo@01o`3m[?iDoJ`3m_[oo`0W0?oc0?Gon03loh40P@210?h00=;m007o
0?kf0:cnE02/oOH2n_oo02d0ooD0lOoj0?coaP3lolL0non10840oP00d_d00Ol0
o_H0[?iD0:cmmP;jool0;@3omP3_oo/0o?o60?cob03joh40P@3n003Bo@01o`3n
mP2/oU@0[?gf0_[oo`0]0?of0?_on`3koo/0o?o60?cob03joh40P@3n003Bo@01
o`3nm_b/oOH2n_oo02T0ooL0nooi0?_oo03lolH0o?o90?WoP@210?h00=;m007o
0?Gf0_[oo`0W0?oh0?_om`3loo`0o?o60?cob@3ioh40P@3n003Bo@00oo?j0Ooo
03h0ooP0o?of0?_oo@3looh0o?oe0?Won03looh0nool0?Kon@3jooT0o?on0?ko
k`3hoh40P@3n003Bo@3`o`140?oh0?com@3lood0o?l00?Son@3eooX0o?l00?Oo
oP3foo/0m_ok0?co0@00oOo`0?OoP@210?h00=;m003olo/1ool0?@3on@3kon`0
lOok0??on`3`o`400?Koo03doo`0o?l00?col03mo`00o?n10840oP00d_d00?od
:`:/ool0>P3on@3lon/0lOol0?7oo03`o`400?Koo@3bood0m_oa0?co003loh40
P@3n003Bo@01ob_en0:/ool0CP3on@3lon/0n_om0?_ooP3koo`0nool0?[oo03k
ood0o?ok0?_oo03kooh0m_oa0?go0@00o?n10840oP00d_d00Ol[o_SkE?kh0Zco
o`1>0?oi0?coj`3koo/0o?on0?conP3loo`0nooj0?coo@3loo/0o?oj0?cooP3j
onh0o?l1003loh40P@3n003Bo@01ob_nn?/[o_P2[?oo04h0ooT0o?o[0?conP3l
ooh0o?oj0?coo03kooX0noon0?coo03looP0o?l1003konh0o?on0?coP@210?h0
0=;m007o:okhnh3nn0:/ool0BP3on@3lon/0o?oj0?col`3koo`0o?oh0?cooP3l
oo`0o?oh0?co0@00o?o]0?goo@3loh40P@3n003Bo@01ob_nn?/[o_P2[?oo04H0
ooT0o?o[0?conP3looT0mOol0?con03looh0o?ol0>ko0@00o?o^0?coo@3loh40
P@3n003Bo@01ob_nn?^0o_P2[?oo04H0ooT0o?o[0?conP3loo/0lool0?con03l
ooh0o?ol0>ko0@00o?o^0?goo03loh40P@3n003Bo@01ob_nn?/[o_P2[?oo04X0
ooT0o?od0?coo@3looX0o?om0?7oo03looP0o?on0?coo03^o`400?cok`3loo`0
o?n10840oP00d_d00Ol[o_SkP?kh0Zcoo`170?oh0?com@3lood0o?oj0?coo@3k
oo`0o?ol0?con03looh0o?ol0?col@3lonl0kon108400=;m007o:okhnb_nn0:/
ool0A`3on03looH0o?ol0?conP3looh0o?oj0?coo03looP0o?on0?coo03loo40
o?o_0>ooP@21003Bo@01ob_nn?^0o_P2[?oo04L0ooP0noog0?coo03looX0o?on
0?conP3loo`0nooj0?_ooP3loo`0noob0?cok`3_oh40P@00d_d00Ol[o_Sk:okh
0Zcoo`180?og0?_on@3loo/0o?oj0?cooP3loo/0nool0?_onP3lood0o?ok0?co
nP3ko`400?cok`3_oh40P@00d_d00Ol[mOP2[?oo04T0ooL0n_ol0?[on`3looX0
o?on0?_oo@3joo`0n_om0?[oo@3loo/0n_om0?_ooP3lonD0o?n10840oP00d_d0
0Ol[mOP2[?oo03L0ooH0l?oj0?conP3looh0l?ol0?3oo03iood0lOon0?coi@3l
oh40P@3n003Bo@00oo>/0Ooo0480ooD0l_oi0?conP3lood0lOol0?3oo03ioo`0
loom0?coi@3loh40P@3n003Bo@02ooKjo_H0n_kf0?[nmP;jool0B`3ol`3eooP0
o?oj0?coo03io`400?coo03lo`00n?oi0?[on`3eoo`0o?oU0?coP@210?h00=;m
003oo_H0n_kf0?[nmPCjm_Koo`1:0?oa0?[om@3looX0o?ok0?_ooP3kood0o?on
0?comP3kooT0n_oi0?coi@3loh40P@3n003Bo@02ooKjo_H0n_kf0?[nmP;jool0
8P3o]03loh40P@2X003Bo@00ookf0?[nmP3jo_H4n_Kfool08P3o]03loh40P@2X
003Bo@02ooKjo_H0n_kf0?[nmP;jool08P3o]03loh40P@2X003Bo@00ookf0?[n
mP3jo_H4n_Kfool08P3o]03loh40P@2X003Bo@02ooKjo_H0n_kf0?[nmP;jool0
8P3o]03loh40P@2X003Bo@00ookf0?[nmP3jo_H4n_Kfool08P3o]03loh40P@2X
003Bo@02ooKjo_H0n_kf0?[nmP;jool08P3o]03loh40P@2X003Bo@00ookf0?[n
mP3jo_H4n_Kfool08P3o]03loh40P@2X003Bo@02ooKjo_H0n_kf0?[nmP;jool0
803oP@210840fP3ld_d00?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_of
n_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0
oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0
n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@21
0=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2
n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_of
n_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0
oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0
n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@21
0=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2
n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_of
n_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0
oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0
n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@21
0=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_ofn_kf0?[nmP3jo_H2
n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0oh40P@210=400_of
n_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0n_kf1?[fm_oo01`0
oh40P@210=400_ofn_kf0?[nmP3jo_H2n_oo01`0oh40P@210=400?onmP3jo_H0
n_kf1?[fm_oo02D0oh40P@210>40o=81003ld_d00_ofn_kf0?[nmP3jo_H2n_oo
02@0oh40P@210=d00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0;P3ojP3lomT0
oOoT0?koP@210<P0oM;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0;P3oj@3nomL0
o_oT0?koP@210<D00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0>P3on`3fooX0
o_oa003oj03nonT00?om0?koP@210<D00=;k003Bo@02ooKjo_H0n_kf0?[nmP;j
ool0?03on`00ooSj0?oj0?kolP01oooX0?kojP01oon10840_P00d_/00=;m003o
o_H0n_kf0?[nmPCjm_Koo`1b0?ok003on?X0ooX0o_l1003no`400?kooP3ko`00
o_l00?kooP3moo`00_oo0?ko0@00oOl00?goo@3lo`00nol00?gooP3mooh0o_l1
003noh40P@3G003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo0700oo/00?ohnP3o
nP3nooh0nOon0?koo@3no`X0ool00?oo003oooh0n_on0?ko0@00o_on0?ko103o
o`00o_om0?ko1`00ool00?oooP3ioh40P@3H003Bn`00d_d00?onmP3jo_H0n_kf
1?[fm_oo07l0oo/00?ohnP3onP3nooh0o_l1003nooh0o_om0?koo@3no`400?ko
003no`400?kooP3no`400?ko0@00o_l5003oo`00o_om0?ko003no`400?ko0@00
o_l1003noh40P@3H003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo07X0oo/00?oh
nP3onP3nooh0o_l1003nooh0o_om0?koo@3no`400?ko003no`400?kooP3no`40
0?ko0@00o_ok0?koo@3no`00o_l1003no`400?ko0@00o_n10840f000d_/00=;m
003oo_H0n_kf0?[nmPCjm_Koo`1j0?ok003on?X0ooX0o_on0?ko0@00o_on0?ko
o@3nood0o_l1003no`00o_l1003nooh0o_l1003no`400?kon`3nood0o_l00?ko
0@00o_l1003no`400?koP@210=P00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0
NP3on`00ooSj0?oj0?kooP3no`400?kooP3nood0o_om0?ko0@00o_l00?ko0@00
o_on0?ko0@00o_l1003noo/0o_om0?ko003no`400?ko0@00o_l1003noh40P@3H
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo07X0oo/00?ohnP3onP3nooh0o_l1
003nooh0o_om0?koo@3no`400?ko003no`400?kooP3no`400?ko0@00o_ok0?ko
o@3no`00o_l1003no`400?ko0@00o_n10840f000d_/00=;m00;om_[nmP3jo_H0
n_kf0_[oo`1l0?ok003on?X0ooX0o_on0?ko0@00o_on0?ko0`3o003noo`01Ooo
003oooh0o_l00?kooP3iooh0o_l40?oo003no`<0o`00o_l7003oo`00ooon0?ko
0@00o_n10840f000d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`1Y0?ok0?Kon`3l
o`00o?l00?gooP3no`400?coo03moo`0o_l00?kooP3mo`00o_on0?goo@3no`40
0?co0@00oOon0?co003moh40P@3I003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo
02@0oh40P@210=d00]800?cBo@00ookf0?[nmP3jo_H4n_Kfool0903oP@210840
g@00d_h0oM;m00;om_[nmP3jo_H0n_kf0_[oo`0T0?n10840P@3M003Bo@3nd_d0
0?onmP3jo_H0n_kf1?[fm_oo02D0oh40P@210=d00=;l007Bd_d00_ofn_kf0?[n
mP3jo_H2n_oo02@0oh40P@210>40o=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
703oP@210840d@02ooKjo_H0n_kf0?[nmP;jool0703oP@210840d@00ookf0?[n
mP3jo_H4n_Kfool0703oP@210840d@02ooKjo_H0n_kf0?[nmP;jool0703oP@21
0840d@00ookf0?[nmP3jo_H4n_Kfool0703oP@210840d@02ooKjo_H0n_kf0?[n
mP;jool0703oP@210840d@00ookf0?[nmP3jo_H4n_Kfool0703oP@210840d@02
ooKjo_H0n_kf0?[nmP;jool0703oP@210840d@00ookf0?[nmP3jo_H4n_Kfool0
9@3oP@210840h@3ldP400?cBo@02ooKjo_H0n_kf0?[nmP;jool0903oP@210840
g@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0j0?oZ0?[oo03nomd0o_oX0?co
0P00on@0oOn10840k`3md_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0o0?oY0?ko
0@00o_on0?kog@3nonX0o_on0?goh`3noh40P@3/003Bn`00d_d00?onmP3jo_H0
n_kf1?[fm_oo04/0oo/0m_oj0?kooP3no`400?kohP00ood0o_om003ol03noo`0
o_oS0?koP@210>`00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0B@3on`00ooSj
0?oj0?kooP3nomh00Ooom`01ooo`0?kon`01oooS0?koP@210>`00=;k003Bo@00
ookf0?[nmP3jo_H4n_Kfool0P@3on`00ooSj0?oj0?kooP3no`00oOl00?ko0`00
ooom0?cooP3no`00o_l00?_o003mo`00noon0?gonP3nooH0o_l00?ko0@00o?on
0?ko0`00ooom0?ko003nood0o?n10840n@00d_/00=;m00;om_[nmP3jo_H0n_kf
0_[oo`260?ok003on?X0ooX0o_l1003nooh0o_l1003jo`D00?oo003nooh0o_l4
0?oo003nood0o_l1003nood0o_l20?oon`3nooD0o_l70?oo0?oo003nooh0n_on
0?Wo1`00ool00?ooP@210?T00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0T03o
n`00ooSj0?oj0?_oo03no`400?ko0@00o_l40?oo003nooh0o_ol0?koo@3no`40
0?kooP3no`<00?oon`3noo`0o?l1003nood00ooo003nooh0o_l1003no`400?ko
0@00o_l1003no`800?n10840n@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`22
0?ok003on?X0ooX0o_l1003nooh0o_l1003no`400?koo@3mooh0o_ol0?koo@3n
o`400?kooP3joo/0o_ok0?kooP3nooX0oOon0?ko0@00o_l1003no`400?ko0@00
oOn10840m`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`290?ok003on?X0ooX0
o_on0?ko0@00o_l1003no`400?ko1000ool0o_on0?koo03nood0o_l1003nooh0
o_og0?kon`3nooh0o_ol00;oo`3nooh0o_l1003no`400?ko0@00o_on0?goP@21
0?P00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0RP3on`00ooSj0?oj0?kooP3n
o`400?ko0@00o_l1003no`@0ool00?kooP3noo`0o_om0?ko0@00o_on0?komP3n
oo`0o_on0?koo@03ool00?kooP3no`400?ko0@00o_l1003nood0oOn10840n@00
d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`2>0?ok003on?X0ooX0o_on0?ko0@00
o_l1003no`400?ko103oo`00o_on0?koo03nood0o_l1003nooh0o_of0?koo03n
ooh0o_om00?oo`00o_on0?ko0@00o_l1003no`400?ko1000o`00o_n10840n@00
d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`2=0?ok003on?X0ooX0o_l1003nooh0
o_l1003mo`@0ool00?[ooP3noo`0o_l30?l00?ko0@00o_l30?l00?ko0P3oooT0
o_on0?gooP3nood0n_on0?go0P3oooh0o_l1003no`L00?oo003ooh40P@3i003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_oo07T0oo/0m_ok0?WooP3lo`00o_l20?oo
o@3no`00o_l00?coo03no`400?co0@00o_om0?gomP3kood0o?om0?ko003no`40
0?ko0P3oooh0o?l00?go003loh40P@3h003Bn`00d_d00_ofn_kf0?[nmP3jo_H2
n_oo02X0omT0o_nZ0?koP@210>800]800?cBo@00ookf0?[nmP3jo_H4n_Kfool0
:P3of@3nojX0o_n10840hP00d_h0oM;m00;om_[nmP3jo_H0n_kf0_[oo`0Z0?oI
0?koZP3noh40P@3R003Bo@3nd_d00?onmP3jo_H0n_kf1?[fm_oo02/0omX0o?n/
0?coP@210><00=;l007Bd_d00_ofn_kf0?[nmP3jo_H2n_oo02@0oh40P@210>40
o=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0703oP@210840d@02ooKjo_H0n_kf
0?[nmP;jool0703oP@210840d@00ookf0?[nmP3jo_H4n_Kfool0703oP@210840
d@02ooKjo_H0n_kf0?[nmP;jool0703oP@210840d@00ookf0?[nmP3jo_H4n_Kf
ool0703oP@210840d@02ooKjo_H0n_kf0?[nmP;jool0703oP@210840d@00ookf
0?[nmP3jo_H4n_Kfool0703oP@210840d@02ooKjo_H0n_kf0?[nmP;jool0703o
P@210840d@00ookf0?[nmP3jo_H4n_Kfool09@3oP@210840h@3ldP400?cBo@02
ooKjo_H0n_kf0?[nmP;jool0903oP@210840g@00d_/00=;m003oo_H0n_kf0?[n
mPCjm_Koo`150?oZ0?Wo0@00oOnn0?gonP3moo`0o_oR0?god@3lo`800?oT0?go
P@3K0?gBn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo04X0onT0o_l1003no`400?ko
_@3nooT0oOol003oh03nom<0o_on0?goh`3noh40f000d_/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`1<0?ok0?KonP3nooh0o_l00?ko_@3nooT0oOol003oh03nom@0
o_ol0?koh`3noh40f000d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`1A0?ok003o
n?X0ooX0o_on0?ko003nokd0o_oi0?coo@00on00o_oD0?kon`01oooS0?koP@3H
003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0<H0oo/00?ohnP3onP3nooh0o_l0
0?kooP3looh0o_l1003nood0o?on0?ko003noo/0o?on0?ko0@00o_ol00;oo`3n
ooT00Ol0oOon003oo@3mooh0o_l1003nooh0o_l3003oood0o_on0?cooP3no`40
0?koo@3looh0o_l00?kon`3nooH0o_l00?ko0@00o?on0?ko0`00ooom0?ko003n
ood0o?n10>D00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0b03on`00ooSj0?oj
0?ko0@00o_l1003no`D00?oo003nooh0nOl5003oo`00o_on0?ko0P3ooo`00ooo
003nooh0nOon0?[on@02o`00o_on003ooP05ool00?oooP3iooh0n_on0?ko1@00
ool00?kooP3io`D00?oo003nooh0o_l20?oon`3nooD0o_l70?oo0?oo003nooh0
n_on0?Wo1`00ool00?ooP@3U003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0>T0
oo/00?ohnP3onP3jooh0o_l5003oo`00o_on0?ko0@00o_l5003oo`00o_on0?ko
n@03ool00?kooP3no`400?ko0@00o_l1003nooT00_l00?go1000o`00o_l1003n
o`400?ko0@00o_on0?ko0@00o_l1003no`D00?oo003nooh0o_l1003no`D00?oo
003nooh0o_oh0?koo03lo`400?koo@03ool00?kooP3no`400?ko0@00o_l1003n
o`400?ko0P00oh40i@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`350?ok003o
n?X0ooX0o_oj0?koo03mooh0o_l1003noo`0oOon0?komP3mooh0o_l1003no`40
0?ko0@00o_oi003ooP3mo`<0o`00o_l1003no`400?ko0@00o_on0?ko0@00o_l1
003noo`0oOon0?ko0@00o_ol0?gooP3nooP0o_ok0?kooP3nooX0oOon0?ko0@00
o_l1003no`400?ko0@00oOn10><00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0
g03on`00ooSj0?oj0?konP3nooh00_oo0?kooP3no`400?kooP02ool0o_on0?ko
n002ool0o_on0?ko0@00o_l1003no`400?kon@00ood0o_l30?l00?ko0@00o_l1
003no`400?kooP3no`400?ko0@00o_on00;oo`3nooh0o_l1003nooh00_oo0?ko
oP3nooP0o_ok0?kooP3noo`00_oo0?kooP3no`400?ko0@00o_l1003nooh0oOn1
0>@00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0h03on`00ooSj0?oj0?konP3n
o`D00?oo003nooh0o_l1003no`D00?oo003nooh0o_oi00?oo`00o_on0?ko0@00
o_l1003no`400?kon@00ood0o?l1003no`400?ko0@00o_l1003nooh0o_l1003n
o`400?ko1@00ool00?kooP3no`400?ko1@00ool00?kooP3nooL0o_ol0?kooP3n
ood00ooo003nooh0o_l1003no`400?ko0@00o_om0?goP@3U003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_oo0>@0oo/00?ohnP3onP3nooX0o_l5003oo`00o_on0?ko
0@00o_l5003oo`00o_on0?kon@03ool00?kooP3no`400?ko0@00o_l1003nooT0
0?ol0?go0@00o_l1003no`400?ko0@00o_on0?ko0@00o_l1003no`D00?oo003n
ooh0o_l1003no`D00?oo003nooh0o_og0?koo03nooh0o_om00?oo`00o_on0?ko
0@00o_l1003no`400?ko1000o`00o_n10>D00=;k003Bo@02ooKjo_H0n_kf0?[n
mP;jool0``3on`00ooSj0?oj0?konP3no`400?[ooP3no`400?ko0@00n_on0?ko
n@3jooh0o_l1003nooh0o_l00?kon@00oo/0o_on00Goo`00ooon0?ko0@00o_on
0?go0P3oooh0o_l1003jooh0o_l1003no`400?[ooP3nooH0o_on0?gooP3nood0
n_on0?go0P3oooh0o_l1003no`L00?oo003ooh40i@00d_/00=;m003oo_H0n_kf
0?[nmPCjm_Koo`360?ok0?Kon`3loo`0o?l1003no`00o_l00?co003mo`400?ko
003no`00o?oi0?ko003no`00o?l00?gooP3no`00o_ok0?koo03nood0oOon0?co
003mo`400?ko0P3oooh0o?l1003no`00o_l00?co003mo`400?ko003no`00o?oe
0?_oo@3lood0o_l00?ko0@00o_l20?oooP3lo`00oOl00?coP@3T003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo02X0oh40k03noj/0o_n10<h00=;k003Bo@00ookf
0?[nmP3jo_H4n_Kfool0:P3oP@3/0?koZ`3noh40cP00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[oo`0Z0?n10>`0o_n[0?koP@3>003Bn`00d_d00?onmP3jo_H0n_kf
1?[fm_oo02X0oh40k@3lojd0o?n10<l00=;k003Bo@02ooKjo_H0n_kf0?[nmP;j
ool0903oP@210840h@3ld_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0P0?n10840
P@3F003Bo@02ooKjo_H0n_kf0?[nmP;jool0803oP@210840eP00d_d00?onmP3j
o_H0n_kf1?[fm_oo0200oh40P@210=H00=;m00;om_[nmP3jo_H0n_kf0_[oo`0P
0?n10840P@3F003Bo@00ookf0?[nmP3jo_H4n_Kfool0803oP@210840eP00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo0200oh40P@210=H00=;m003oo_H0n_kf0?[nmPCj
m_Koo`0P0?n10840P@3F003Bo@02ooKjo_H0n_kf0?[nmP;jool0803oP@210840
eP00d_d00?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210>40o=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jool0903oP@210840g@00d_/00=;m003oo_H0n_kf0?[nmPCj
m_Koo`1i0?ok0?kooP01oooQ007oooH0o_l10?oT003oh001oooW007oooL00Ooo
l@00on<00Oool`00ooH01?oo0?ooi@00ooD00Oooh@3no`00o_oY0?ko003non/0
0OoohP3md_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`1Q0?oj003ooP00omh00?og
003ooP00ol000?oV003omP00om400?oV00?o003oe`00on000?on003oi`00ooh0
0?oY003og`00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`1k0?oj003ooP00omh0
0?oh003oo@00on`00?oF003oiP00ooX00?on003on000oo400?o/003oiP03o`00
omL00?oe003oo000oo<00ol00?oV00?o003ok000ooh00?oO003Bn`00d_d00_of
n_kf0?[nmP3jo_H2n_oo0Dh0ooX00_l00?koo001oook0?go3@3o0?oo0?oo0?oo
0?oooP3nooX00?og007oooh0o_l6003o0?oo0?ko3000ool00?oo0?l0ooon0?ko
o001oook0?ko2P3oo`3oo`3o0?oooP3mo`d0o`3oo`3oo`3oo`3oooh0o_om0?ko
0@00o_on00;oo`3nood00ooo003nooh0o_l1003no`D0ool0ooon0?kooP02o`00
o_on0?go1P3oo`00ooon007oooh00_l00?go003nood00OoooP0:ool0o`3oo`3o
o`3lo`00o_l20?oooP0;o`00ool00?l0ool0o_on0?ko0@00o_oj00?o003om03n
o`D00?l0oool00?o003ok03no`400?kooP07ool00?l0ooo/003Bn`00d_d00?on
mP3jo_H0n_kf1?[fm_oo0F`0ooX00?on003oo003o`00ood00ol00?on01;oo`3o
003o0?oo003o003o003oo000ooL01Ol00?l0ooh07?l00?l00?l0o`00o`00o`00
o`00o`00o`3o003oo@03o`00ood05?l00?l00?l00?l0ool00?l0o`00ooh04_oo
0?l00?l0ool00?l00?l00?om003ooP0:o`00o`3o003o0?ok00Go0?l00?om00?o
003ooP08o`3oo`00o`3ooP05o`00o`3ooP05o`3o003ooP0Bo`3o003o0?l00?l0
0?l00?l0ooh00?om01Co003o0?l00?oo003o003o003o0?on01Go0?l00?l00?l0
o`00o`00o`00o`3oo003o`00ooh00?ok0?kom000ooh01?l00?oon`3nonX00?on
00ko003o0?l00?l00?l00?o]003Bn`00d_d00_ofn_kf0?[nmP3jo_H2n_oo0FL0
ooX00?on003on`3nood00ol00?on003ooP3no`40ooh01_l00?l00?ol003ooP3n
ood00?om003ooP08o`00o`00o`3ooP3no`/00?l00?l00?l0oooj0?koo@01ooom
00Go003o0?on00Go0?l00?on003ooP3no`40ooh01_l00?l00?om003ooP05o`00
o`00o_l10?ok00?o0?oon`03o`00ooh00_l0ooh00_l0ooh01Ol00?l0ooh01Ol0
o`00ooh00_l0oo`0o_l:003o003o003o0?ol0?go0@3ooP0>o`00o`00o`00o`00
o`3ooP3no`<00?l0oOl7003o003o0?ol00?o003ooP00oo/00_l0ood0oOol003o
oP03o`00ooX00_l0ood0o_om0?kon000ooh01?l00?l0oOl5003o003ok@00d_/0
0=;m003oo_H0n_kf0?[nmPCjm_Koo`5j0?oj003ooP00oo`00ol00?ol007oood0
2?l00?l00?l0ooh01_l00?l00?ol003oo@00oo`00?om003ooP0Go`00o`00o`3o
003o003o003o003o003ooP01ooom00?o003on`09ool00?l00?l0ooh01?l00?oo
o@08o`00o`00o`3ooP06o`00o`00ood00?on00[o003o0?l00?l0oo/00?on007o
ood00ol00?on00;o0?on00;o0?on00Go003o0?on00Co003oood00_l0ood03_l0
0?l00?l00?l00?l0oo`00?om003ooP0Io`00o`00o`00o`00o`3o003o003o003o
0?ol00Go003o0?ol00?o003ooP00oo`00?on003ooP00ooT00?on00?o003on`00
ooh01_l00?l00?on00?o003on000ooh01Ol00?l0oo`00ol00?o]003Bn`00d_d0
0_ofn_kf0?[nmP3jo_H2n_oo0GP0ooX00?on003oo003o`00ood00?ok01;o003o
003o0?oo003o003o003oo000ooh00?ok00Go003o0?on01co003o003o0?l00?l0
0?l00?l00?l00?l0o`00ood00ol00?om00_o003o003o003o0?on00;o0?ok01;o
003o003o0?oo003o003o003oo@00ooh02_l00?l0o`00o`3on`05o`3o003oo@03
o`00ooh02?l0ool00?l0ooh01Ol00?l0ooh00_l0oo/04?l0o`00o`3o003o003o
003ooP00oo/04_l00?l0o`00ool00?l00?l00?on003ooP0Co`00o`00o`3o003o
003o003o0?ol00?o003ooP00oo`00?om007o0?gon`00ooh00ol00?ok003oo@04
o`00oool007oooL00?on00ko003o0?l00?l00?l00?o]003Bn`00d_d00?onmP3j
o_H0n_kf1?[fm_oo0El0oo/0o_l00?koo003ool0ood0o_l1003no`/00?oo0?oo
0?oo003no`80oool0?gonP01ooon0?ko0@00o_l90?oo0?l00?oo0?[o003loo/0
0ooo0?on0?koo@04ool0o`3nooh0o_l1003no`/00?oo0?oo0?oo003no`80ooom
007o0?ko2@3oo`3oo`3o0?om0?_on`02o`00o_l5003o0?oooP3no`400?ko003n
ooh0o_l1003no`80ooon00;oo`3jo`800?oj007oooh00ooo0?on00;oo`3mo`80
0?om00;oo`3mo`@0ool00?ko103oo`3oo002o`00o_ol0?ko0@00o_om003on`3n
o`400?koo@3no`400?kooP00oo/00?om003oo001o`3no`L0ool0ool00?ko0P3o
onh00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0FP3oj000ooh00?og003oY000
ooh00?og003ob`00ond00?on003ok000oo400?o0003oi000oo/00?om003oeP00
d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`1L0?oX003ooP00ooL00?nT003ooP00
ooL00?o;003ok@00ooh00?o^00;o0?oa003oa03monH0o_on0?goo@00omD00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jool0@`3oi`3nooL0o_nT0?kom`3nold0o_o]
0?kok@01oooa0?koX000old00=;k003Bo@00ookf0?[nmP3jo_H4n_Kfool0903o
P@210840g@00d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0T0?n10840P@3M003B
n`00d_d00?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210=d00=;k003Bo@02ooKj
o_H0n_kf0?[nmP;jool0A`3om`3no`40on@00Ooof001oooW003okP3jdP40d^H0
o];n0?kB0@3oP@2C003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo04`0ooP00?on
003ohP00omL00?oX003ok000d_d00=;U003BoP02dP3BoP02dP3oP@2D003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_oo04H0ooT00?om003oj000oo`00?oG003oj000
on`00=;L003Bo002dP3oP@2D003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0;@0
ooT00?oh00Ko0?oo0?oooP06ool0ool00?_oo@03o`3oooh00Oooo003o`3oooh0
o_l5003o0?ooo004ool0ooon00[o003oo`00o`3oooh01ooo003o0?oooP00ood0
o_l3003oooh00Ooon`00d_h01M80d]800?gB3@3BdP3BdP3B0=;B0=;Bm`00d_`0
0m800?n109D00=;k003Bo@02ooKjo_H0n_kf0?[nmP;jool0^@3onP00ooH01_l0
0?l00?on00[o003o0?l00?l0oo`02Ooo003o0?l00?ol00Go003o0?on00Ko003o
003oo00Kool00?l00?l0o`00o`00o`00o`3o003o003oood00?on00go003o0?l0
0?l0o`00oo`0o=87003B0=800=;n00cB003B003BdP3B003Bn@00d_`00=;n003o
P@2E003Bn`00d_d00?onmP3jo_H0n_kf1?[fm_oo0;L0ooX00?on0?koo006o`00
o`00ooh01_l00?l0ooon003oo000ooh00Ol0oOol00Go003o0?on00So003o003o
003mooh01Ol00?l00?ko1`00o`00o`00o_l2003oo000ooh00OoooP3mo`00oOol
003BoP08dP00dP3B003BoP08dP00dP00dP00oM;j003Bo000d_d00?n109D00=;k
003Bo@02ooKjo_H0n_kf0?[nmP;jool0[`3onP00ood00?ok00Ko003o003ooP03
o`00ooh00ooo0?ol003ooP02o`3on@05o`00o`3ooP06o`00o`00oo`00?on01Ko
003o0?l00?l00?l00?l0o`00o`00oo`00?ol00?oo`3oo@00ooT00=;k00CB003B
d_d02M800=800=800=;h003Bo000d_`00?n109D00=;k003Bo@00ookf0?[nmP3j
o_H4n_Kfool0_P3onP00ooh00?oj00Ko003o003ooP0:o`00o`3o003o0?ol003o
oP05o`3o003oo005o`00o`3ooP06o`00o`00oo`06_oo003o003o0?l00?l00?l0
0?l0o`00o`00oo`00?on00go003o0?l00?l0o`00oo`00=;k00;B0=;k00cB003B
003B003B003Bo000d_h00]80d_h00m800?n109D00=;k003Bo@02ooKjo_H0n_kf
0?[nmP;jool0[P3on@3moo/0o_l50?oo0?oooP02ool0oOon003oo03nooh00Ooo
o03no`<0ool0o_l1003no`80ooom00Go0?oo003no`<0ool0oOl60?oo0?oo0?go
o@00ooh0o_on007oooh00Oooo03md_h0o]800?kBo@02d]80oM83003Bd_/0o=80
0?cB1@00o`00oh40V000d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0d0?n`003o
h@00on<00=;n003Bh@00oh40U000d_/00=;m00;om_[nmP3jo_H0n_kf0_[oo`0i
0?n`003oh@00ond0n=810=;n007B0>?B0@3oP@2D003Bn`00d_d00?onmP3jo_H0
n_kf1?[fm_oo0300ok40o_oQ003oh`3nd^400?n109<00=;k003Bo@02ooKjo_H0
n_kf0?[nmP;jool0903oP@210840h@3ld_/00=;m003oo_H0n_kf0?[nmPCjm_Ko
o`0P0?n10840P@3F003Bo@02ooKjo_H0n_kf0?[nmP;jool0803oP@210840eP00
d_d00?onmP3jo_H0n_kf1?[fm_oo0200oh40P@210=H00=;m00;om_[nmP3jo_H0
n_kf0_[oo`0P0?n10840P@3F003Bo@00ookf0?[nmP3jo_H4n_Kfool0803oP@21
0840eP00d_d00_ofn_kf0?[nmP3jo_H2n_oo0200oh40P@210=H00=;m003oo_H0
n_kf0?[nmPCjm_Koo`0P0?n10840P@3F003Bo@02ooKjo_H0n_kf0?[nmP;jool0
803oP@210840eP00d_d00?onmP3jo_H0n_kf1?[fm_oo02@0oh40P@210>80nm;k
003Bo@02ooKjo_H0n_kf0?[nmP;jool0:03oP@210840h@00d_h00=;k003Bo@00
ookf0?[nmP3jo_H4n_Kfool09`3oP@210840h003dP00d_/00=;m00;om_[nmP3j
o_H0n_kf0_[oo`0V0?n10840P@3O00;B0=;k003Bo@00ookf0?[nmP3jo_H4n_Kf
ool09@3oP@210840gP01d];k003Bo@02ooKjo_H0n_kf0?[nmP;jool0903oP@21
0840g@00d_/00=;m003oo_H0n_kf0?[nmPCjm_Koo`0T0?n10840P@3M003Bn`00
d_d00_ofn_kf0?[nmP3jo_H2n_oo003o\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{450, 219},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
When we click a hyperlink, the front end scrolls the selected \
notebook to the destination of the link.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations and Figures", "Subsection"],

Cell[TextData[{
  "To create numbered equations or figures, we select the cell containing the \
equation or figure, then choose ",
  StyleBox["Numbered Equation", "MenuItem"],
  " (or ",
  StyleBox["Numbered Figure", "MenuItem"],
  ") from the Style submenu of the Format menu. (Not every style sheet \
contains the numbered-equation and numbered-figure style definitions. Some of \
the standard style sheets that define automatic-numbering cells are Report, \
Classroom, Classic, and the Article styles.)"
}], "Text"],

Cell["\<\
Here is a notebook containing some formulas inside \
numbered-equation cells.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000770000SQ000`40O003h00O00<007ooOol0ogoo
]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk
009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk
>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001o
ogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo
0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00
>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmk
Kg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_Nfmk
Kg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>
Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P00003o
002h00001CW>Kg]_Nfmk>Lh00fmk00HicVmkKg]_NcW>Kg/200000003001oogoo0?mookAoo`04001_
Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>
Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmk
Kg]_NcW>00=_N`80000000<007ooOol0ogooZgoo1@0O17oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`03>Li_N`000040000000<007ooOol0BGoo0`00IGoo0`00>goo0`00_7oo00<07gooOol00Woo
00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04Qoo`80009oo`03001oogoo
065oo`80009oo`03001oogoo03Moo`80009oo`03001oogoo0;Uoo`0301moogoo009oo`03000icVmk
009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04eoo`03001oogoo06Eoo`03
001oogoo03]oo`03001oogoo0;Qoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0P0000000`00Oomoo`1=Ool00`00Oomoo`1UOol00`00Oomoo`0kOol00`00Oomoo`2hOol00`0O
Oomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1=
Ool00`00Oomoo`1UOol00`00Oomoo`0kOol00`00Oomoo`2hOol00`0OOomoo`02Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CGoo0P00IWoo0P00?7oo0P00^Goo00<07goo
Ool00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0CGoo
0P00IWoo0P00?7oo0P00^Goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/2
00000003001oogoo04eoo`8000Yoo`8001moo`<003Qoo`8000Ioo`8003Aoo`8000Moo`<005Eoo`03
001oogoo00Eoo`03001oogoo04moo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03
Kg/00cW>Kg/0000100000003001oogoo04eoo`8000Uoo`800003Ool007oo00Eoo`03001oogoo00Ao
o`03001oogoo00eoo`05001oogooOol00004Ool00`00Oomoo`04Ool01@00Oomoogoo00009goo0P00
1Woo00<007oo00001Woo00<007ooOol017oo00<007ooOol08goo0P001Woo00D007ooOomoo`0000Ao
o`03001oogoo00Aoo`03001oogoo04Eoo`03001oogoo00Moo`03001oogoo04ioo`0301moogoo009o
o`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool20008Ool01@00Oomo
ogoo00001Goo00<007ooOol01Woo00<007ooOol037oo00D007ooOomoo`0000=oo`03001oogoo00Io
o`05001oogooOol0000VOol20008Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`0ROol2
0006Ool01@00Oomoogoo00000goo00<007ooOol01Woo00<007ooOol0A7oo00<007ooOol01goo00<0
07ooOol0CWoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040
000000<007ooOol0CGoo0P0027oo00D007ooOomoo`0000Eoo`05001oogoo001oo`020002Ool00`00
Oomoo`06Ool00`00Oomoo`04Ool30004Ool01@00Oomoo`00Ool00P000Woo00D007ooOomoo`0000Eo
o`03001oo`00008000Aoo`04001oo`00000DOol20008Ool00`00Oomoo`03Ool01@00Oomoo`00Ool0
0P000Woo00<007ooOol00goo00<007oo00000P000goo00@007oo000000Moo`03001oogoo00Uoo`80
00Moo`<000Aoo`05001oogoo001oo`020002Ool00`00Oomoo`03Ool00`00Ool000020003Ool01000
Ool00000=7oo00<007ooOol00goo0`000goo00<007ooOol0CGoo00<07gooOol00Woo00@006mkKg/i
cP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`8000Moo`03001oogoo009oo`03001o
ogoo009oo`05001oogoo001oo`0200001Goo001oogoo00001goo00<007ooOol01Goo00<007ooOol0
0Woo00D007ooOol007oo00800005Ool007ooOol00003Ool02`00Oomoogoo001oo`00Ool007oo0000
0Woo00H007oo000007oo0004Ool70008Ool20008Ool00`00Oomoo`02Ool01@00Oomoo`00Ool00P00
00Eoo`00Oomoo`0000=oo`0:001oo`00Ool007oo001oo`00Ool200000goo001oo`05Ool00`00Oomo
o`09Ool20008Ool00`00Oomoo`02Ool01@00Oomoo`00Ool00P0000Eoo`00Oomoo`0000=oo`0:001o
o`00Ool007oo001oo`00Ool200000goo001oo`0bOol00`00Oomoo`02Ool01@00Oomoogoo00000Woo
00<007ooOol0CGoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0CGoo0P001goo00<007ooOol00Woo00<007ooOol00Woo00@007ooOol0009o
o`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`8000=oo`04001oogoo0002Ool00`00
Oomoo`02Ool01@00Oomoogoo00000goo00H007ooOol007oo0003Ool01000Oomoo`005Goo0P0027oo
00<007ooOol00Woo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00002Ool00`00Ool0
0002Ool01000Oomoo`0027oo00<007ooOol02Goo0P0027oo0P000goo00@007ooOol0009oo`03001o
ogoo009oo`05001oogooOol00002Ool00`00Ool00002Ool01000Oomoo`00=Goo00<007ooOol01Woo
00@007ooOol004moo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P000000
0`00Oomoo`1>Ool20006Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00@007ooOol000=oo`03
001oogoo009oo`L000=oo`04001oogoo0002Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000=o
o`05001oogooOol00002Ool00`00Ool00004Ool01000Oomoo`005Goo0P0027oo00D007ooOomoo`00
00=oo`04001oogoo0003Ool01@00Oomoogoo00000Woo00<007oo00000goo00@007ooOol000Aoo`L0
00Uoo`8000Ioo`04001oogoo0002Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000=oo`06001o
ogoo001oo`000goo00@007ooOol003Aoo`03001oogoo00Ioo`04001oogoo001?Ool00`0OOomoo`02
Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1>Ool20006
Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00@007ooOol000=oo`03001oogoo00Eoo`03001o
ogoo00Aoo`04001oogoo0002Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000=oo`03001oogoo
009oo`05001oo`00Ool00004Ool01000Oomoo`001Goo1`002Goo0P0027oo00D007ooOomoo`0000=o
o`04001oogoo0003Ool00`00Oomoo`02Ool01@00Ool007oo00000goo00@007ooOol000Moo`03001o
ogoo00Yoo`8000Ioo`04001oogoo0002Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`05
001oo`00Ool00003Ool01000Oomoo`00=7oo00<007ooOol00goo0`000goo00<007ooOol0CGoo00<0
7gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04ioo`8000Mo
o`04001oogooOol30003Ool01000Ool000000Woo00@007ooOol000Qoo`03001oogoo00Eoo`@0009o
o`04001oo`000002Ool01000Oomoo`000goo00<007ooOol017oo0`0000Aoo`00Oomoo`80009oo`03
001oogoo01=oo`8000Moo`<000=oo`04001oo`000002Ool01000Oomoo`001Woo0`0000=oo`00Ool0
0P000Woo00<007ooOol01Goo00<007ooOol02Woo0P001goo10000Woo00@007oo0000009oo`04001o
ogoo0006Ool300000goo001oo`020002Ool00`00Oomoo`0bOol00`00Oomoo`05Ool01@00Oomoogoo
0000Cgoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`0000400000
00<007ooOol0CWoo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol01Woo00<007oo
Ool01Woo00<007ooOol02goo00<007ooOol01Woo00D007ooOomoo`0000Qoo`03001oo`0001aoo`80
00Qoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00Ioo`03001oo`0000eoo`03001oogoo
00Yoo`8000eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oo`0003]oo`03001oogoo00Eoo`03
001oo`00051oo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00
Oomoo`1>Ool20008Ool01`00Oomoogoo001oo`0000=oo`03001oogoo00Aoo`03001oogoo01Ioo`03
001oogoo00Aoo`05001oogooOol00008Ool4000LOol20008Ool00`00Ool00003Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool4000JOol2000>Ool00`00Oomoo`04Ool00`00Oomoo`06Ool4000kOol01@00
Oomoogoo00000goo00<007oo0000D7oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`03>Li_N`000040000000<007ooOol0CWoo0P003Goo0P00Egoo0P002Goo0P00<Goo0P00GWoo
00@007ooOomoo`<00003Ool007oo051oo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk
>Lh00fmk0P0000000`00Oomoo`1>Ool2001VOol2000lOol2002hOol00`0OOomoo`02Ool00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1>Ool2001VOol2000lOol2
002eOol401l4Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P00
IWoo0P00?7oo0P00^7oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_
N`000040000000<007ooOol0Cgoo00<007ooOol0IGoo00<007ooOol0>goo00<007ooOol0]Goo0P0O
17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04moo`03001oogoo06Eo
o`03001oogoo03]oo`03001oogoo0;Aoo`0301moo`0O00Aoo`03000icVmk009_N`05>Li_NfmkKg/i
cP03Kg/00cW>Kg/0000100000003001oogoo051oo`03001oogoo008006=oo`03001oogoo008003Uo
o`03001oogoo00800;1oo`0401moogoo01l4Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80
000000<007ooOol0DGoo0`00IGoo0`00>goo0`00/7oo00D07gooOomoo`0O00Aoo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?moojYoo`H07`Aoo`04001_Nfmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_
NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_
N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003
001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001o
ogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogooZgoo1@0O17oo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0BGoo0`00ogooHgoo00<07goo
Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04Qoo`80009oo`03
001oogoo0?moof1oo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0
000100000003001oogoo04eoo`03001oogoo0?mooemoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/0
1CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool00`00Oomoo`3oOomOOol00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1=Ool00`00Oomo
o`3oOomOOol00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007oo
Ool0CGoo0P00ogooH7oo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_
N`000040000000<007ooOol0CGoo0P00ogooH7oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_
NfmkKg/icP03Kg/200000003001oogoo04eoo`800?moo`Ioo`03001oogoo00Eoo`03001oogoo04mo
o`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001o
ogoo04eoo`800?moo`Eoo`03001oogoo00Moo`03001oogoo04ioo`0301moogoo009oo`04001_Nfmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool2003oOol5Ool00`00Oomoo`07Ool0
0`00Oomoo`1>Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk0000
0@0000000`00Oomoo`1=Ool20006Ool01000Ool0000017oo00<007oo00000P000goo00@007oo0000
00moo`04001oo`000004Ool01000Ool00000cWoo00<007ooOol00Woo1@000Woo00<007ooOol0CGoo
00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`80
00Ioo`05001oo`00Ool00002Ool02P00Ool007oo001oo`00Ool007oo0P0000=oo`00Ool00goo1`00
0goo00D007oo001oo`00009oo`06001oo`00001oo`00cGoo00<007ooOol00Woo00D007ooOomoo`00
009oo`03001oogoo04eoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>
Kg/0000100000003001oogoo04eoo`8000Ioo`03001oo`0000Aoo`06001oogoo001oo`000Woo00@0
07ooOol0011oo`03001oo`0000Aoo`04001oogoo003?Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
0`00Oomoo`1=Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<0
07ooOol0CWoo0P001Woo0P0017oo00H007ooOol007oo0003Ool01000Oomoo`0047oo0P001Goo00@0
07ooOol00<ioo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo04eoo`0301moogoo009oo`03
000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04ioo`8000Ioo`03
001oo`0000Aoo`05001oo`00Ool00003Ool01000Oomoo`001Goo1`0017oo00<007oo000017oo00@0
07ooOol00<ioo`03001oogoo00Eoo`05001oogooOol0001?Ool00`0OOomoo`02Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P001Woo00@007ooOol000Aoo`<00003
Ool007oo0080009oo`03001oogoo00ioo`04001oogoo0002Ool20002Ool00`00Oomoo`3<Ool00`00
Oomoo`06Ool01000Oomoo`00Cgoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_
N`03>Li_N`000040000000<007ooOol0CWoo0P001goo00<007ooOol01Woo00<007oo00005goo00<0
07ooOol0eWoo00<007ooOol01Goo00<007oo0000D7oo00<07gooOol00Woo00@006mkKg/icP=_N`05
>Li_NfmkKg/icP03Kg/200000003001oogoo04ioo`8000Moo`03001oogoo00Eoo`@001Moo`03001o
ogoo0=Ioo`05001oogooOol00003Ool00`00Ool0001@Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/0
1CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1>Ool20006Ool2000QOol2003IOol0
1000Oomoogoo0`0000=oo`00Ool0D7oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/200000003001oogoo04ioo`800?mooemoo`0301moogoo009oo`03000icVmk009_N`05>Li_
NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04ioo`800?mooeaoo`@07`Aoo`04001_Nfmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1>Ool2003oOomOOol00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1?Ool00`00Oomo
o`3oOomLOol201l4Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0Cgoo
00<007ooOol0ogooFgoo00<07goo01l017oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_
N`000040000000<007ooOol0D7oo00<007ooOol00P00ogooEgoo00@07gooOol07`Aoo`04001_Nfmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1AOol3003oOomGOol01@0OOomoogoo01l0
17oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogooZWoo
1P0O17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk
>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_
Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_
NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_
N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003
001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001o
ogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOon[Ool5
01l4Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`19Ool3
003oOomSOol00`0OOomoo`02Ool00`006<HHaP0<6<H200000003001oogoo04Qoo`80009oo`03001o
ogoo0?moof1oo`0301moogoo009oo`03001o?eJe00]F]@4HaP400040000000<007ooOol0CGoo00<0
07ooOol0ogooGgoo00<07gooOol00Woo00<007loE[D02eJe0AS60@000@0000000`00Oomoo`1=Ool0
0`00Oomoo`3oOomOOol00`0OOomoo`02Ool00`00OcmF]@02E[D6Ocl3E[D16<H1000100000003001o
ogoo04eoo`03001oogoo0?mooemoo`0301moogoo009oo`03001o?eJe009F]@HaT`=F]@4HaP400040
000000<007ooOol0CGoo0P00ogooH7oo00<07gooOol00Woo00<007loE[D00UJe1Wlo0eJe0AS60@00
0@0000000`00Oomoo`1=Ool2003oOomPOol00`0OOomoo`02Ool00`00OcmF]@02E[D6<I<3E[D16<H1
000100000003001oogoo04eoo`800?moo`Ioo`03001oogoo00Eoo`03001oogoo04moo`0301moogoo
009oo`03001o?eJe009F]@Io?`=F]@4HaP400040000000<007ooOol0CGoo0P00ogoo1Goo00<007oo
Ool01goo00<007ooOol0CWoo00<07gooOol00Woo00<007loE[D00UJe1S6C0eJe0AS60@000@000000
0`00Oomoo`1=Ool2003oOol5Ool00`00Oomoo`07Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool00`00
OcmF]@02E[D6Ocl3E[D16<H1000100000003001oogoo04eoo`8000Moo`03001oo`00008000=oo`04
001oo`00000@Ool01000Ool00000g7oo00<007ooOol00goo0`000goo00<007ooOol0CGoo00<07goo
Ool00Woo00<007loE[D00UJe1S6C0eJe0AS60@000@0000000`00Oomoo`1=Ool20006Ool02P00Ool0
07oo001oo`00Ool007oo0P0000=oo`00Ool00goo1`000goo00H007oo000007oo003KOol00`00Oomo
o`04Ool00`00Oomoo`02Ool00`00Oomoo`1=Ool00`0OOomoo`02Ool00`00OcmF]@02E[D6Ocl3E[D1
6<H1000100000003001oogoo04eoo`8000Ioo`06001oogoo001oo`000Woo00@007ooOol0011oo`04
001oogoo003MOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`1=Ool00`0OOomoo`02Ool0
0`00OcmF]@02E[D6CWl3E[D16<H1000100000003001oogoo04ioo`8000Eoo`06001oogoo001oo`00
0goo00@007ooOol0011oo`04001oogoo003LOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomo
o`1=Ool00`0OOomoo`02Ool00`00OcmF]@0;E[D16<H1000100000003001oogoo04ioo`8000Ioo`05
001oo`00Ool00003Ool01000Oomoo`001Goo1`0017oo00@007ooOol00=aoo`03001oogoo00Aoo`03
001oogoo009oo`03001oogoo04eoo`0301moogoo009oo`03001o?glo00]o?`4HaP400040000000<0
07ooOol0CWoo0P001goo0`0000=oo`00Ool00P000Woo00<007ooOol03Goo0P000Woo00<007ooOol0
fWoo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0CGoo00<07gooOol00Woo00<002U::DX0
32U:0P0000000`00Oomoo`1>Ool20009Ool00`00Ool0003gOol01`00Oomoogoo001oo`0000=oo`03
001oogoo04ioo`0301moogoo009ooa40000000<007ooOol0CWoo0P0027oo1000mgoo00<007ooOol0
0Woo0P000goo00<007ooOol0CWoo00<07gooOol00Woo00<003W>>Lh033W>0P0000000`00Oomoo`1>
Ool2003oOol5Ool00`00Oomoo`02Ool01000Oomoo`00DGoo00<07gooOol00Woo00<007ooKg/02fmk
0CW>0@000@0000000`00Oomoo`1>Ool2003oOomOOol00`0OOomoo`02Ool00`00Oom_N`02Kg/56<H4
Kg/1>Lh1000100000003001oogoo04ioo`800?mooeaoo`@07`Aoo`03001oofmk009_N`056<I>Odio
CWlHaP04Kg/1>Lh1000100000003001oogoo04ioo`800?mooemoo`0301moogoo009oo`03001oofmk
009_N`056<I>OdioCWlHaP04Kg/1>Lh1000100000003001oogoo04moo`03001oogoo0?mooeaoo`80
7`Aoo`03001oofmk009_N`056<I>OdioCWlHaP04Kg/1>Lh1000100000003001oogoo04moo`03001o
ogoo0?mooe]oo`0301moo`0O00Aoo`03001ooaS600<HaP=>O`@HaP03Kg/icP000040000000<007oo
Ool0D7oo00<007ooOol00P00ogooEgoo00@07gooOol07`Aoo`04001oofmk6<H7CWl011S6Kg]_NcW>
0P0000000`00Oomoo`1AOol3003oOomGOol01@0OOomoogoo01l017oo00D007ooKg]_NaS600E>O`05
6<I_NfmkKg/icP0200000003001oogoo0?moojYoo`H07`Aoo`03001oofmk009_N`056<I>OdioCWlH
aP04Kg/1>Lh1000100000003001oogoo0?mookAoo`03001oofmk00=_N`036<I>OaS600E_N`4icP40
0040000000<007ooOol0ogoo]7oo00<007ooKg/016mk00<HaVmkKg/016mk0CW>0@000@0000000`00
Oomoo`3oOondOol00`00Oom_N`0;Kg/1>Lh1000100000003001oogoo0?mookAoo`03001oogoo00]o
o`4icP4000400000o`00b00000000`00CWm>O`3oCWo3CWl200000003001o?gNm0?mg_L9g_@5>O`40
0040000000<007loMkd0ogNm`WNm0Dio0@000@0000000`00OclicP05>Lh00gNm6<Io?`09Ocl00gNm
>LhicP2<>Lj0Mkf>>Lh00gNm6<Io?`09Ocl00gNm>LhicP04>Lh1CWl1000100000003001o?gNm00Ig
_@036<Io?aS600LHaP03Ocmg_GNm09Eg_@8000Ag_@D0009g_@D000=g_@8000=g_@@000Qg_@@000Ag
_@8000Mg_@8000Ig_@@000=g_@8000Ag_@80009g_@80009g_@8000=g_@D0009g_@8000=g_@D000=g
_@<009Mg_@036<Io?aS600LHaP03Ocmg_GNm00Eg_@5>O`400040000000<007lo>Lh01CW>00=g_AS6
Ocl01eJe00<HaWloMkd0SSW>27Nm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm0P00
0gNm00<007NmMkd017Nm0P000WNm0P000gNm0P001gNm0P001GNm0P000WNm0P000WNm0P0017Nm0P00
0WNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm00<007NmMkd00P001gNm
SSW>00=g_AS6Ocl01eJe00<HaWloMkd01SW>0Dio0@000@0000000`00Ocmg_@06Mkd00aS6OcmF]@06
E[D00aS6Ocmg_@2FMkd20003Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002Mkd2000:Mkd20002
Mkd20003Mkd20007Mkd20005Mkd20002Mkd20002Mkd20004Mkd20002Mkd20002Mkd20002Mkd20002
Mkd20002Mkd20002Mkd20002Mkd20004Mkd3002FMkd00aS6OcmF]@06E[D00aS6Ocmg_@06Mkd1CWl1
000100000003001o?cW>00DicP03MkdHaWlo00MF]@036<Io?gNm08hicPQg_@8000=g_@80009g_@80
009g_@80009g_@80009g_@80009g_@H000Ig_@80009g_@8000=g_@8000Mg_@8000Eg_@80009g_@80
009g_@8000Ag_@80009g_@80009g_@80009g_@80009g_@80009g_@80009g_@80009g_@8000=g_@<0
00Qg_HhicP03MkdHaWlo00DHaP9F]@036<Io?gNm00HicP5>O`400040000000<007loMkd01WNm00<H
aWloE[D01UJe00<HaWloMkd0UWNm0P0017Nm1@000WNm0P000WNm0P000WNm0P000WNm0P000WNm0P00
1WNm0P000WNm0P000gNm0P001gNm10000gNm0P000WNm0P000WNm0P0017Nm0P000WNm0P000WNm0P00
0WNm0P000WNm0P000WNm0P000gNm1@000WNm0`00V7Nm00<HaWloE[D00eJe00DHaUJeE[DHaWlo00Mg
_@5>O`400040000000<007lo>Lh01CW>00=g_AS6Ocl01eJe00<HaWloMkd0SSW>27Nm0P000gNm00@0
07NmMkeg_@80009g_@80009g_@80009g_@80009g_@80009g_@8000Ig_@80009g_@8000=g_@8000Mg
_@8000Eg_@80009g_@80009g_@<000=g_@80009g_@80009g_@80009g_@80009g_@80009g_@80009g
_@04001g_GNmMkd20002Mkd20002Mkd00`00Mkeg_@05Mkf>>Lh00gNm6<Io?`04E[D01QS6E[EF]AS6
Ocmg_@HicP5>O`400040000000<007loMkd01WNm00<HaWloE[D01UJe00<HaWloMkd0UWNm0P0017Nm
10000gNm1@000gNm0P000gNm100027Nm10000gNm10001WNm0P001WNm10000gNm0P0000Ag_@00001g
_@T000=g_@80009g_@80009g_@8000=g_@@000Ag_@<009Mg_@036<Io?eJe00=F]@056<IF]EJe6<Io
?`07Mkd1CWl1000100000003001o?cW>00DicP03MkdHaWlo00MF]@036<Io?gNm08hicPQg_@8000]g
_@8000Ig_@8001Mg_@8000Mg_@8002Mg_@8001Ig_HhicP03MkdHaWlo00AF]@066<IF]EJe6<Io?gNm
1SW>0Dio0@000@0000000`00Ocmg_@06Mkd00aS6Ocmo?`08OcnEMkd60009Mkd20006Mkd2000HMkd3
0005Mkd5000TMkd2002UMkd00aS6Ocmo?`08Ocl7Mkd1CWl1000100000003001o?cW>00DicP03MkdH
aQS600THaP03MkdicSW>08`icX1g_HhicP03MkdHaQS600THaP03MkdicSW>00@icP5>O`4000400000
00<007loMkd0ogNm`WNm0Dio0@000@0000000`00Ocmg_@3oMkg2Mkd1CWl1000100000003001o?glo
0?mo?l9o?`5>O`4000400000o`00a`000Goo0000\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{455, 142},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "If an equation is inserted between existing cells, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically updates the equation numbers."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000770000]A000`40O003h00O00<007ooOol0ogoo
]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo
00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/0
1CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_
N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040
000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mo
okAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@00003o002h0002Kg/01CW>Kg]_Nfmk>Lh00fmk
00@icVmkKg]_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03
>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/20000
0003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003
001oogoo0?mooj]oo`D07`Aoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomo
o`19Ool3001UOol3000kOol3002lOol00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh0
0fmk00<icVmk00000@0000000`00Oomoo`18Ool20002Ool00`00Oomoo`1QOol20002Ool00`00Oomo
o`0gOol20002Ool00`00Oomoo`2iOol00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>
00=_N`80000000<007ooOol0CGoo00<007ooOol0IGoo00<007ooOol0>goo00<007ooOol0^7oo00<0
7gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0
CGoo00<007ooOol0IGoo00<007ooOol0>goo00<007ooOol0^7oo00<07gooOol00Woo00@006mkKg/i
cP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`03001oogoo06Eoo`03001oogoo03]o
o`03001oogoo0;Qoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0
000100000003001oogoo04eoo`8006Ioo`8003aoo`800;Uoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool2001VOol2000lOol2002iOol00`0OOomo
o`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1=Ool2
000:Ool2000OOol3000hOol20006Ool2000dOol20007Ool3001EOol00`00Oomoo`05Ool00`00Oomo
o`1?Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0
CGoo0P002Goo0P0000=oo`00Ool01Goo00<007ooOol017oo00<007ooOol03Goo00D007ooOomoo`00
00Aoo`03001oogoo00Aoo`05001oogooOol0000WOol20006Ool00`00Ool00006Ool00`00Oomoo`04
Ool00`00Oomoo`0SOol20006Ool01@00Oomoogoo000017oo00<007ooOol017oo00<007ooOol0AGoo
00<007ooOol01goo00<007ooOol0CWoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`03>Li_N`000040000000<007ooOol0CGoo0P0027oo00D007ooOomoo`0000Eoo`03001oogoo
00Ioo`03001oogoo00aoo`05001oogooOol00003Ool00`00Oomoo`06Ool01@00Oomoogoo00009Woo
0P0027oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol08Woo0P001Woo00D007ooOomoo`00
00=oo`03001oogoo00Ioo`03001oogoo04Aoo`03001oogoo00Moo`03001oogoo04ioo`0301moogoo
009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool20008Ool01@00
Oomoogoo00001Goo00D007ooOol007oo0080009oo`03001oogoo00Ioo`03001oogoo00Aoo`<000Ao
o`05001oogoo001oo`020002Ool01@00Oomoogoo00001Goo00<007oo00000P0017oo00@007oo0000
01Aoo`8000Qoo`03001oogoo00=oo`05001oogoo001oo`020002Ool00`00Oomoo`03Ool00`00Ool0
00020003Ool01000Ool000001goo00<007ooOol02Goo0P001goo0`0017oo00D007ooOol007oo0080
009oo`03001oogoo00=oo`03001oo`00008000=oo`04001oo`00000dOol00`00Oomoo`05Ool01@00
Oomoogoo0000Cgoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0CGoo0P001goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOol007oo
00800005Ool007ooOol00007Ool00`00Oomoo`05Ool00`00Oomoo`02Ool01@00Oomoo`00Ool00P00
00Eoo`00Oomoo`0000=oo`0;001oogooOol007oo001oo`00Ool00002Ool01P00Ool00000Ool000Ao
o`L000Qoo`8000Qoo`03001oogoo009oo`05001oogoo001oo`0200001Goo001oogoo00000goo00X0
07oo001oo`00Ool007oo001oo`800003Ool007oo00Eoo`03001oogoo00Uoo`8000Qoo`03001oogoo
009oo`05001oogoo001oo`0200001Goo001oogoo00000goo00X007oo001oo`00Ool007oo001oo`80
0003Ool007oo039oo`03001oogoo00Eoo`05001oogooOol0001?Ool00`0OOomoo`02Ool01000Kg]_
NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CGoo0P001goo00<007ooOol00Woo00<0
07ooOol00Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`80
00=oo`04001oogoo0002Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00H007ooOol007oo0003
Ool01000Oomoo`005Goo0P0027oo00<007ooOol00Woo00@007ooOol0009oo`03001oogoo009oo`05
001oogooOol00002Ool00`00Ool00002Ool01000Oomoo`0027oo00<007ooOol02Goo0P0027oo0P00
0goo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00002Ool00`00Ool00002Ool01000
Oomoo`00=Goo00<007ooOol00Woo1@000Woo00<007ooOol0CGoo00<07gooOol00Woo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0CWoo0P001Woo00<007ooOol0
0goo00D007ooOomoo`0000=oo`04001oogoo0003Ool00`00Oomoo`02Ool70003Ool01000Oomoo`00
0Woo00D007ooOomoo`00009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00<007oo0000
17oo00@007ooOol001Eoo`8000Qoo`05001oogooOol00003Ool01000Oomoo`000goo00D007ooOomo
o`00009oo`03001oo`0000=oo`04001oogoo0004Ool70009Ool20006Ool01000Oomoo`000Woo00D0
07ooOomoo`00009oo`05001oogooOol00003Ool01P00Oomoo`00Ool000=oo`04001oogoo000dOol0
0`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol0CGoo00<07gooOol00Woo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04ioo`8000Ioo`03001oogoo00=oo`05001oogoo
Ool00003Ool01000Oomoo`000goo00<007ooOol01Goo00<007ooOol017oo00@007ooOol0009oo`05
001oogooOol00002Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo001oo`0000Aoo`04
001oogoo0005Ool70009Ool20008Ool01@00Oomoogoo00000goo00@007ooOol000=oo`03001oogoo
009oo`05001oo`00Ool00003Ool01000Oomoo`001goo00<007ooOol02Woo0P001Woo00@007ooOol0
009oo`05001oogooOol00002Ool01@00Oomoogoo000017oo00D007oo001oo`0000=oo`04001oogoo
000dOol00`00Oomoo`03Ool00`00Ool00003Ool00`00Oomoo`1=Ool00`0OOomoo`02Ool00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1>Ool20007Ool01000Oomo
ogoo0`000goo00@007oo0000009oo`04001oogoo0008Ool00`00Oomoo`05Ool40002Ool01000Ool0
00000Woo00@007ooOol000=oo`03001oogoo00Aoo`<00004Ool007ooOol20002Ool00`00Oomoo`0C
Ool20007Ool30003Ool01000Ool000000Woo00@007ooOol000Ioo`<00003Ool007oo0080009oo`03
001oogoo00Eoo`03001oogoo00Yoo`8000Moo`@0009oo`04001oo`000002Ool01000Oomoo`001Woo
0`0000=oo`00Ool00P000Woo00<007ooOol0<Woo00<007ooOol00goo00<007oo00000goo00<007oo
Ool0CGoo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
04ioo`8000Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00Ioo`03
001oogoo00]oo`03001oogoo00Ioo`05001oogooOol00008Ool00`00Ool0000LOol20008Ool00`00
Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Ool0000=Ool00`00Oomoo`0:Ool2000=
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Ool0000kOol00`00Oomoo`03Ool20002Ool00`00
Oomoo`1>Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@00
00000`00Oomoo`1>Ool20008Ool01`00Oomoogoo001oo`0000=oo`03001oogoo00Aoo`03001oogoo
01Ioo`03001oogoo00Aoo`05001oogooOol00008Ool4000LOol20008Ool00`00Ool00003Ool00`00
Oomoo`04Ool00`00Oomoo`06Ool4000JOol2000>Ool00`00Oomoo`04Ool00`00Oomoo`06Ool4000k
Ool00`00Oomoo`03Ool20002Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00Di
cVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P003Goo0P00Egoo0P002Goo0P00<Goo0P00GWoo
00<007ooOol00goo00<007oo0000DGoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>
00=_N`03>Li_N`000040000000<007ooOol0CWoo0P00IWoo0P00?7oo0P00^7oo00<07gooOol00Woo
00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04ioo`8006Ioo`8003aoo`80
0;Eoo`@07`Aoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo
04ioo`8006Ioo`8003aoo`800;Qoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0P0000000`00Oomoo`1?Ool00`00Oomoo`1UOol00`00Oomoo`0kOol00`00Oomoo`2eOol201l4
Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1?Ool00`00
Oomoo`1UOol00`00Oomoo`0kOol00`00Oomoo`2dOol00`0OOol07`04Ool01000Kg]_NcW>0fmk00Di
cVmkKg]_NcW>00=_N`80000000<007ooOol0D7oo00<007ooOol00P00Hgoo00<007ooOol00P00>Goo
00<007ooOol00P00/7oo00@07gooOol07`Aoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>
Kg/0000100000003001oogoo055oo`<006Eoo`<003]oo`<00;1oo`0501moogooOol07`04Ool01000
Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogooZWoo1P0O17oo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/i
cP03Kg/00cW>Kg/0000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh0
0fmk0P0000000`00Oomoo`3oOondOol00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk0000
0@0000000`00Oomoo`3oOondOol01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007oo
Ool0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0
ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo0?mookAoo`03000i
cVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mooj]oo`D07`Aoo`04
001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOon_Ool00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`22Ool00`00Oomo
o`020008Ool00`00Oomoo`05Ool3003oOolEOol00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmk
Kg]_NcW>00=_N`80000000<007ooOol0BGoo0`00=Woo00H007ooOol007oo0007Ool00`00Oomoo`06
Ool00`00Oomoo`3oOolDOol00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<i
cVmk00000@0000000`00Oomoo`18Ool20002Ool00`00Oomoo`0cOol01000Oomoo`002Goo00<007oo
Ool01Woo00<007ooOol0ogoo57oo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03
Kg/200000003001oogoo04eoo`03001oogoo03=oo`04001oogoo0005Ool70005Ool00`00Oomoo`3o
OolDOol00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@000000
0`00Oomoo`1=Ool00`00Oomoo`0cOol200000goo001oo`07Ool00`00Oomoo`06Ool00`00Oomoo`3o
OolDOol00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0
CGoo00<007ooOol0<Woo0P0000=oo`00Ool027oo00<007ooOol01Woo00<007ooOol0ogoo57oo00<0
7gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0
CGoo0P00@7oo00<007ooOol017oo00<007oo0000ogoo5Woo00<07gooOol00Woo00@006mkKg/icP=_
N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`8004Qoo`800?mooaIoo`0301moogoo009o
o`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04eoo`8004Uo
o`03001oogoo0?mooaAoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P00
00000`00Oomoo`1=Ool2001DOol00`00Oomoo`0QOol00`00Oomoo`2:Ool00`00Oomoo`05Ool00`00
Oomoo`1?Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@00
00000`00Oomoo`1=Ool2001COol00`00Oomoo`0;Ool00`00Oomoo`0EOol00`00Oomoo`28Ool00`00
Oomoo`07Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_
N`80000000<007ooOol0CGoo0P001goo00@007oo000000Yoo`03001oo`00008000=oo`04001oo`00
000bOol00`00Ool00002Ool20007Ool00`00Oomoo`0@Ool30002Ool00`00Oomoo`28Ool00`00Oomo
o`07Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<i
cVmk00000@0000000`00Oomoo`1=Ool20006Ool01P00Ool00000Ool000Qoo`0:001oo`00Ool007oo
001oo`00Ool200000goo001oo`03Ool7000UOol01000Oomoo`000Woo00<007oo000017oo1`003goo
00<007ooOol00Woo00<007ooOol0QWoo00<007ooOol00goo0`000goo00<007ooOol0CGoo00<07goo
Ool00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`8000Ioo`04
001oogoo000:Ool01P00Oomoo`00Ool0009oo`04001oogoo000bOol01000Oomoo`000Woo00<007oo
Ool01goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol0QWoo00<007ooOol00Woo00D007oo
Oomoo`00009oo`03001oogoo04eoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03
Kg/00cW>Kg/0000100000003001oogoo04ioo`8000Ioo`04001oogoo0009Ool01P00Oomoo`00Ool0
00=oo`04001oogoo000AOolK0005Ool01@00Oomoogoo00000Woo00<007ooOol01Woo00<007ooOol0
1Goo1`0017oo00<007ooOol00Woo00<007ooOol0QWoo00<007ooOol01Woo00@007ooOol004moo`03
01moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1>Ool20006
Ool01000Oomoo`002Woo00D007oo001oo`0000=oo`04001oogoo0005Ool7000UOol01000Oomoogoo
0P0000=oo`00Ool017oo1`003goo00<007ooOol00Woo00<007ooOol0QWoo00<007ooOol01Woo00@0
07ooOol004moo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/00001
00000003001oogoo04ioo`8000Eoo`80009oo`03001oogoo00Uoo`<00003Ool007oo0080009oo`03
001oogoo031oo`06001oo`00001oo`002Woo00<007ooOol03goo00D007ooOomoo`0008Uoo`03001o
ogoo00=oo`<000=oo`03001oogoo04eoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk
>Lh00fmk0P0000000`00Oomoo`1>Ool2000;Ool01000Oomoo`0027oo00<007oo0000>7oo00<007oo
Ool03Goo00<007ooOol03Goo00<007oo00000goo00<007ooOol0Qgoo00<007ooOol01Goo00D007oo
Oomoo`0004moo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/00001
00000003001oogoo04ioo`8000]oo`04001oogoo0007Ool4000iOol00`00Oomoo`0MOol20002Ool0
0`00Oomoo`29Ool00`00Oomoo`05Ool00`00Ool0001@Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk
00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P0037oo0`00IGoo00<007ooOol0S7oo00D0
07ooOomoo`0000=oo`03001oo`00051oo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/i
cP03Kg/00cW>Kg/0000100000003001oogoo04ioo`8000]oo`800003Ool007oo0?Aoo`04001oogoo
Ool300000goo001oo`1@Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80
000000<007ooOol0CWoo0P00=7oo00@007oo00000?moobMoo`0301moogoo009oo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04ioo`8003=oo`06001oo`00001o
o`00ogoo9Woo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001o
ogoo04moo`03001oogoo035oo`04001oogoo003oOolXOol00`0OOomoo`02Ool00`00>Li_N`02Kg/0
1CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1?Ool00`00Oomoo`0bOol01000Oomo
o`00ogoo9goo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001o
ogoo051oo`03001oogoo008002moo`04001oogoo003oOolWOol00`0OOomoo`02Ool00`00>Li_N`02
Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1AOol3000_Ool20002Ool00`00
Ool00002Ool00`00Oomoo`02Ool01000Oomoogoo0`00ogoo57oo100O17oo00@006mkKg/icP=_N`05
>Li_NfmkKg/icP03Kg/200000003001oogoo08Uoo`04001oogoo0004Ool00`00Oomoo`02Ool00`00
Oomoo`3oOolFOol00`0OOomoo`02Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk0000
0@0000000`00Oomoo`2:Ool30002Ool50002Ool00`00Oomoo`3oOolEOol201l4Ool01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0RGoo0P0000=oo`00Ool00goo00<007ooOol0
0Woo00<007ooOol0ogoo57oo00<07goo01l017oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03
>Li_N`000040000000<007ooOol0TGoo00<007ooOol00Woo00<007ooOol0ogoo4goo00@07gooOol0
7`Aoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`2EOol2003oOolDOol0
1@0OOomoogoo01l017oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<0
07ooOol0ogooZWoo1P0O17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mo
okAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_
NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/200000003001oogoo0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0
000100000003001oogoo0?mookAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00
Oomoo`3oOon[Ool501l4Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@000000
0`00Oomoo`19Ool3003oOomSOol00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_
N`80000000<007ooOol0B7oo0P000Woo00<007ooOol0ogooH7oo00<07gooOol00Woo00<003W>Kg/0
0Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0CGoo00<007ooOol0ogooGgoo
00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo04eoo`03
001oogoo0?mooemoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0
000100000003001oogoo04eoo`03001oogoo0?mooemoo`0301moogoo009oo`04001_Nfmk>Lh3Kg/0
1CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1=Ool2003oOomPOol00`0OOomoo`02Ool00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1=Ool2003oOomPOol00`0O
Oomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CGoo0P00ogoo
1Woo00<007ooOol01Goo00<007ooOol0Cgoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_
NcW>00=_N`03>Li_N`000040000000<007ooOol0CGoo0P00ogoo1Goo00<007ooOol01goo00<007oo
Ool0CWoo00<07gooOol00Woo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
04eoo`800?moo`Eoo`03001oogoo00Moo`03001oogoo04ioo`0301moogoo009oo`03000icVmk009_
N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo04eoo`8000Ioo`04001oo`000004
Ool00`00Ool000020003Ool01000Ool000003goo00@007oo000000Aoo`04001oo`00003>Ool00`00
Oomoo`02Ool50002Ool00`00Oomoo`1=Ool00`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_
NcW>00=_N`80000000<007ooOol0CGoo0P001Woo00D007oo001oo`00009oo`0:001oo`00Ool007oo
001oo`00Ool200000goo001oo`03Ool70003Ool01@00Ool007oo00000Woo00H007oo000007oo003=
Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00<007ooOol0CGoo00<07gooOol00Woo00<003W>
Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0CGoo0P001Woo00<007oo
000017oo00H007ooOol007oo0002Ool01000Oomoo`0047oo00<007oo000017oo00@007ooOol00<mo
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04eoo`0301moogoo009oo`04001_Nfmk>Lh3
Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1>Ool20006Ool20004Ool01P00Oomoo`00Ool0
00=oo`04001oogoo000@Ool20005Ool01000Oomoo`00cWoo00<007ooOol017oo00<007ooOol00Woo
00<007ooOol0CGoo00<07gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`00
0040000000<007ooOol0CWoo0P001Woo00<007oo000017oo00D007oo001oo`0000=oo`04001oogoo
0005Ool70004Ool00`00Ool00004Ool01000Oomoo`00cWoo00<007ooOol01Goo00D007ooOomoo`00
04moo`0301moogoo009oo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`1>
Ool20006Ool01000Oomoo`0017oo0`0000=oo`00Ool00P000Woo00<007ooOol03Woo00@007ooOol0
009oo`80009oo`03001oogoo0<aoo`03001oogoo00Ioo`04001oogoo001?Ool00`0OOomoo`02Ool0
0`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1>Ool20007Ool0
0`00Oomoo`06Ool00`00Ool0000GOol00`00Oomoo`3FOol00`00Oomoo`05Ool00`00Ool0001@Ool0
0`0OOomoo`02Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P00
1goo00<007ooOol01Goo10005goo00<007ooOol0eWoo00D007ooOomoo`0000=oo`03001oo`00051o
o`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001o
ogoo04ioo`8000Ioo`80025oo`800=Uoo`04001oogooOol300000goo001oo`1@Ool00`0OOomoo`02
Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0CWoo0P00ogooGgoo00<0
7gooOol00Woo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040000000<007ooOol0
CWoo0P00ogooG7oo100O17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
04ioo`800?mooemoo`0301moogoo009oo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0
000100000003001oogoo04moo`03001oogoo0?mooeaoo`807`Aoo`04001_Nfmk>Lh3Kg/01CW>Kg]_
Nfmk>Lh00fmk0P0000000`00Oomoo`1?Ool00`00Oomoo`3oOomKOol00`0OOol07`04Ool00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`1@Ool00`00Oomoo`02003o
OomGOol0100OOomoo`0O17oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
055oo`<00?mooeMoo`0501moogooOol07`04Ool00`00>Li_N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<i
cVmk00000@0000000`00Oomoo`3oOonZOol601l4Ool01000Kg]_NcW>0fmk00DicVmkKg]_NcW>00=_
N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_NcW>00=_N`03>Li_N`000040
000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/icP03Kg/200000003001oogoo
0?mookAoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/00cW>Kg/0000100000003001oogoo0?mo
okAoo`04001_Nfmk>Lh3Kg/01CW>Kg]_Nfmk>Lh00fmk0P0000000`00Oomoo`3oOondOol00`00>Li_
N`02Kg/01CW>Kg]_Nfmk>Lh00fmk00<icVmk00000@0000000`00Oomoo`3oOondOol01000Kg]_NcW>
0fmk00DicVmkKg]_NcW>00=_N`80000000<007ooOol0ogoo]7oo00<003W>Kg/00Vmk00DicVmkKg]_
NcW>00=_N`03>Li_N`000040000000<007ooOol0ogoo]7oo00@006mkKg/icP=_N`05>Li_NfmkKg/i
cP03Kg/200000003001oogoo0?mooj]oo`D07`Aoo`03000icVmk009_N`05>Li_NfmkKg/icP03Kg/0
0cW>Kg/0000100000003001oogoo04Uoo`<00?moof=oo`0301moogoo009oo`03000HaQS600`HaP80
000000<007ooOol0B7oo0P000Woo00<007ooOol0ogooH7oo00<07gooOol00Woo00<007loE[D02eJe
0AS60@000@0000000`00Oomoo`1=Ool00`00Oomoo`3oOomOOol00`0OOomoo`02Ool00`00OcmF]@0;
E[D16<H1000100000003001oogoo04eoo`03001oogoo0?mooemoo`0301moogoo009oo`03001o?eJe
009F]@Io?`=F]@4HaP400040000000<007ooOol0CGoo00<007ooOol0ogooGgoo00<07gooOol00Woo
00<007loE[D00UJe1S6C0eJe0AS60@000@0000000`00Oomoo`1=Ool2003oOomPOol00`0OOomoo`02
Ool00`00OcmF]@02E[D6Ocl3E[D16<H1000100000003001oogoo04eoo`800?moof1oo`0301moogoo
009oo`03001o?eJe009F]@HaT`=F]@4HaP400040000000<007ooOol0CGoo0P00ogoo1Woo00<007oo
Ool01Goo00<007ooOol0Cgoo00<07gooOol00Woo00<007loE[D00UJe1Wlo0eJe0AS60@000@000000
0`00Oomoo`1=Ool2003oOol5Ool00`00Oomoo`07Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool00`00
OcmF]@02E[D6<I<3E[D16<H1000100000003001oogoo04eoo`800?moo`Eoo`03001oogoo00Moo`03
001oogoo04ioo`0301moogoo009oo`03001o?eJe009F]@Io?`=F]@4HaP400040000000<007ooOol0
CGoo0P001goo00<007oo00000P000goo00@007oo0000011oo`04001oo`00003LOol00`00Oomoo`03
Ool30003Ool00`00Oomoo`1=Ool00`0OOomoo`02Ool00`00OcmF]@02E[D6<I<3E[D16<H100010000
0003001oogoo04eoo`8000Ioo`0:001oo`00Ool007oo001oo`00Ool200000goo001oo`03Ool70003
Ool01P00Ool00000Ool00=]oo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo04eoo`0301mo
ogoo009oo`03001o?eJe009F]@Io?`=F]@4HaP400040000000<007ooOol0CGoo0P001Woo00H007oo
Ool007oo0002Ool01000Oomoo`0047oo00@007ooOol00=eoo`03001oogoo00Aoo`03001oogoo009o
o`03001oogoo04eoo`0301moogoo009oo`03001o?eJe009F]@I>O`=F]@4HaP400040000000<007oo
Ool0CWoo0P001Goo00H007ooOol007oo0003Ool01000Oomoo`0047oo00@007ooOol00=aoo`03001o
ogoo00Aoo`03001oogoo009oo`03001oogoo04eoo`0301moogoo009oo`03001o?eJe00]F]@4HaP40
0040000000<007ooOol0CWoo0P001Woo00D007oo001oo`0000=oo`04001oogoo0005Ool70004Ool0
1000Oomoo`00g7oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0CGoo00<07gooOol00Woo
00<007loOcl02glo0AS60@000@0000000`00Oomoo`1>Ool20007Ool300000goo001oo`020002Ool0
0`00Oomoo`0=Ool20002Ool00`00Oomoo`3JOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomo
o`1=Ool00`0OOomoo`02Ool00`00:DXYBP0<:DX200000003001oogoo04ioo`8000Uoo`03001oo`00
0?Moo`07001oogooOol007oo00000goo00<007ooOol0CWoo00<07gooOol00Woo4@0000000`00Oomo
o`1>Ool20008Ool4003gOol00`00Oomoo`02Ool20003Ool00`00Oomoo`1>Ool00`0OOomoo`02Ool0
0`00>LhicP0<>Lh200000003001oogoo04ioo`800?moo`Eoo`03001oogoo009oo`04001oogoo001A
Ool00`0OOomoo`02Ool00`00Oom_N`0;Kg/1>Lh1000100000003001oogoo04ioo`800?mooemoo`03
01moogoo009oo`03001oofmk009_N`DHaPA_N`4icP400040000000<007ooOol0CWoo0P00ogooG7oo
100O17oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP400040000000<007ooOol0CWoo0P00
ogooGgoo00<07gooOol00Woo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP400040000000<0
07ooOol0Cgoo00<007ooOol0ogooG7oo0P0O17oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4i
cP400040000000<007ooOol0Cgoo00<007ooOol0ogooFgoo00<07goo01l017oo00<007oo6<H00aS6
0dio11S600=_NcW>00000@0000000`00Oomoo`1@Ool00`00Oomoo`02003oOomGOol0100OOomoo`0O
17oo00@007ooKg/HaPM>O`046<I_Nfmk>Lh200000003001oogoo055oo`<00?mooeMoo`0501moogoo
Ool07`04Ool01@00Oom_Nfmk6<H01Dio00DHaVmkKg]_NcW>0080000000<007ooOol0ogooZWoo1P0O
17oo00<007ooKg/00Vmk00DHaTioCWm>OaS600A_N`4icP400040000000<007ooOol0ogoo]7oo00<0
07ooKg/00fmk00<HaTio6<H01Fmk0CW>0@000@0000000`00Oomoo`3oOondOol00`00Oom_N`04Kg/0
0aS6Kg]_N`04Kg/1>Lh1000100000003001oogoo0?mookAoo`03001oofmk00]_N`4icP4000400000
00<007ooOol0ogoo]7oo00<007ooOol02goo0CW>0@000@00003o003800000003001>Odio0?m>Ol=>
O`80000000<007loMkd0ogNm`WNm0Dio0@000@0000000`00Ocmg_@3oMkg2Mkd1CWl1000100000003
001o?cW>00DicP03MkdHaWlo00Uo?`03MkdicSW>08`icX1g_HhicP03MkdHaWlo00Uo?`03MkdicSW>
00@icP5>O`400040000000<007loMkd01WNm00<HaWlo6<H01aS600=o?gNmMkd0UGNm0P0017Nm1@00
0WNm1@000gNm0P000gNm100027Nm100017Nm0P001gNm0P001WNm10000gNm0P0017Nm0P000WNm0P00
0WNm0P000gNm1@000WNm0P000gNm1@000gNm0`00UgNm00<HaWlo6<H01aS600=o?gNmMkd01GNm0Dio
0@000@0000000`00OclicP05>Lh00gNm6<Io?`07E[D00aS6Ocmg_@2>>Lh8Mkd20003Mkd20002Mkd2
0002Mkd20002Mkd20002Mkd20002Mkd20003Mkd00`00Mkeg_@04Mkd20002Mkd20003Mkd20007Mkd2
0005Mkd20002Mkd20002Mkd20004Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002Mkd2
0002Mkd20002Mkd00`00Mkeg_@020007Mkf>>Lh00gNm6<Io?`07E[D00aS6Ocmg_@06>Lh1CWl10001
00000003001o?gNm00Ig_@036<Io?eJe00IF]@036<Io?gNm09Ig_@8000=g_@80009g_@80009g_@80
009g_@80009g_@80009g_@8000Yg_@80009g_@8000=g_@8000Mg_@8000Eg_@80009g_@80009g_@80
00Ag_@80009g_@80009g_@80009g_@80009g_@80009g_@80009g_@80009g_@8000Ag_@<009Ig_@03
6<Io?eJe00IF]@036<Io?gNm00Ig_@5>O`400040000000<007lo>Lh01CW>00=g_AS6Ocl01eJe00<H
aWloMkd0SSW>27Nm0P000gNm0P000WNm0P000WNm0P000WNm0P000WNm0P000WNm1P001WNm0P000WNm
0P000gNm0P001gNm0P001GNm0P000WNm0P000WNm0P0017Nm0P000WNm0P000WNm0P000WNm0P000WNm
0P000WNm0P000WNm0P000WNm0P000gNm0`0027NmSSW>00=g_AS6Ocl01AS60UJe00<HaWloMkd01SW>
0Dio0@000@0000000`00Ocmg_@06Mkd00aS6OcmF]@06E[D00aS6Ocmg_@2FMkd20004Mkd50002Mkd2
0002Mkd20002Mkd20002Mkd20002Mkd20006Mkd20002Mkd20003Mkd20007Mkd40003Mkd20002Mkd2
0002Mkd20004Mkd20002Mkd20002Mkd20002Mkd20002Mkd20002Mkd20003Mkd50002Mkd3002HMkd0
0aS6OcmF]@03E[D01AS6E[EF]AS6Ocl01gNm0Dio0@000@0000000`00OclicP05>Lh00gNm6<Io?`07
E[D00aS6Ocmg_@2>>Lh8Mkd20003Mkd01000Mkeg_GNm0P000WNm0P000WNm0P000WNm0P000WNm0P00
0WNm0P001WNm0P000WNm0P000gNm0P001gNm0P001GNm0P000WNm0P000WNm0`000gNm0P000WNm0P00
0WNm0P000WNm0P000WNm0P000WNm0P000WNm00@007NmMkeg_@80009g_@80009g_@03001g_GNm00Eg
_HhicP03MkdHaWlo00AF]@066<IF]EJe6<Io?gNm1SW>0Dio0@000@0000000`00Ocmg_@06Mkd00aS6
OcmF]@06E[D00aS6Ocmg_@2FMkd20004Mkd40003Mkd50003Mkd20003Mkd40008Mkd40003Mkd40006
Mkd20006Mkd40003Mkd2000017Nm000007Nm2@000gNm0P000WNm0P000WNm0P000gNm100017Nm0`00
UgNm00<HaWloE[D00eJe00DHaUJeE[DHaWlo00Mg_@5>O`400040000000<007lo>Lh01CW>00=g_AS6
Ocl01eJe00<HaWloMkd0SSW>27Nm0P002gNm0P001WNm0P005gNm0P001gNm0P009gNm0P005WNmSSW>
00=g_AS6Ocl015Je00HHaUJeE[DHaWloMkd6>Lh1CWl1000100000003001o?gNm00Ig_@036<Io?glo
00Qo?iEg_@H000Ug_@8000Ig_@8001Qg_@<000Eg_@D002Ag_@800:Eg_@036<Io?glo00Qo?`Mg_@5>
O`400040000000<007lo>Lh01CW>00=g_AS66<H02AS600=g_CW>>Lh0S3W>P7NmSSW>00=g_AS66<H0
2AS600=g_CW>>Lh013W>0Dio0@000@0000000`00Ocmg_@3oMkg2Mkd1CWl1000100000003001o?gNm
0?mg_L9g_@5>O`400040000000<007loOcl0oglo`Wlo0Dio0@000@00003o00370001Ool00001\
\>"], "Graphics",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{455, 181},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerics", "Section"],

Cell[CellGroupData[{

Cell["Basic Calculator Functions ", "Subsection"],

Cell[TextData[{
  "We enter arithmetic calculations in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " just as on a calculator, followed by pressing \[ShiftKey]\[LeftModified]\
\[ReturnKey]\[RightModified]."
}], "Text"],

Cell["Addition and subtraction are denoted by the usual symbols.", "Text"],

Cell[BoxData[
    \(2 + 3.45 - 0.4\)], "Input"],

Cell[TextData[{
  "A space denotes multiplication, as does an asterisk ",
  StyleBox["*",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " or the character ",
  StyleBox["\[Cross]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", entered ",
  Cell[TextData["\\\[InvisibleSpace][Times]"], "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(2*2\ 2 \((2\[Times]2)\)\)], "Input"],

Cell[TextData[{
  "A forward sla",
  StyleBox["sh ",
    FontFamily->"Palatino"],
  StyleBox["/",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontFamily->"Palatino"],
  "denotes division, as does the two-dimensional form ",
  Cell[BoxData[
      \(\[SelectionPlaceholder]\/\[Placeholder]\)], "Input",
    GeneratedCell->True],
  "."
}], "Text"],

Cell[BoxData[
    \(5/3\)], "Input"],

Cell[TextData[{
  "A caret ",
  StyleBox["^",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " or a superscript ",
  Cell[BoxData[
      \(\[SelectionPlaceholder]\^\[Placeholder]\)], "Input",
    GeneratedCell->True],
  " stands for exponentiation."
}], "Text"],

Cell[BoxData[
    \(2^5 - 2\^4\)], "Input"],

Cell[TextData[{
  "Because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the standard order of arithmetic operations, it is sometimes \
necessary to group parts of a calculation using parentheses. Note that in ",
  StyleBox["InputForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["StandardForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " parentheses are not used for function notation, as they are in written \
mathematics, or to enclose lists of elements, as they are in some programming \
languages."
}], "Text"],

Cell[BoxData[
    \(2 + 4 \((2 + 9.25)\)^2\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["NonCommutativeMultiply",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Basic Calculator Functions", "Subsubsection"],

Cell["\<\
What is the ratio of heights between a person 5 feet, 8 inches tall \
and a person 6 feet, 4 inches tall?\
\>", "Question"],

Cell["\<\
Here is an exact value for the ratio. Note that we group the \
numerator and denominator with parentheses, and that we do not include units \
in the calculation.\
\>", "SmallText"],

Cell[BoxData[
    \(\((5*12 + 8)\)/\((6*12 + 4)\)\)], "Input"],

Cell[TextData[{
  "Applying the function ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to the previous exact result returns an approximate figure."
}], "SmallText"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  "If a copy of ",
  StyleBox["Mathematica for Students",
    FontSlant->"Italic"],
  " costs $139, and sales tax is 7%, what is the total cost?"
}], "Question"],

Cell["\<\
The total cost is $139 plus 7% tax on $139. Note that there is no \
built-in percent function, so we express 7% as 0.07.\
\>", "SmallText"],

Cell[BoxData[
    \(139 + \((0.07*139)\)\)], "Input"],

Cell[TextData[{
  "Alternatively, we can define a unit multiplier called ",
  StyleBox["percent",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(\(percent = 0.01; \)\)], "Input"],

Cell[BoxData[
    \(139 + \((7\ percent*139)\)\)], "Input"],

Cell["\<\
How many days are there in 35 years? How many hours? Minutes? \
Seconds? (Ignore the complication of leap years.)\
\>", "Question"],

Cell[BoxData[
    \(days = 35*365\)], "Input"],

Cell[BoxData[
    \(hours = 24*days\)], "Input"],

Cell[BoxData[
    \(minutes = 60*hours\)], "Input"],

Cell[BoxData[
    \(seconds = 60*minutes\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbers and Constants", "Subsection"],

Cell[CellGroupData[{

Cell["Integers, Rationals, and Reals", "Subsubsection"],

Cell[TextData[{
  "When working with numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an answer as precise as it can justified by each calculation. For \
this reason, it has different rules for working with exact and approximate \
quantities."
}], "Text"],

Cell[TextData[{
  "An approximate quantity can be identified by the presence of a decimal \
point; therefore 17.0 and 0.71 are approximate numbers. The integer 17 and \
the ratio 71/100, on the other hand, do not contain a decimal point and are \
considered exact numbers. In the following discussion, we refer to an \
approximate (non-complex) number containing a decimal point as a ",
  StyleBox["real",
    FontSlant->"Italic"],
  " number, an integer without a decimal point as an ",
  StyleBox["integer",
    FontSlant->"Italic"],
  ", and a ratio of two exact integers as a ",
  StyleBox["rational",
    FontSlant->"Italic"],
  " number. To ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 7.0 is an approximate real number, and 7 is an exact integer."
}], "Text"],

Cell[TextData[{
  "When doing arithmetic with exact numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an exact number. For example, the following input contains only \
integers, so the result is an integer."
}], "Text"],

Cell[BoxData[
    \(2 + \((3*5)\)\^7\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " leaves rational numbers (quotients of two integers, reduced to lowest \
terms) in explicit fractional form."
}], "Text"],

Cell[BoxData[
    \(3 + 1\/7\)], "Input"],

Cell["This occurs even when there is a precise decimal equivalent.", "Text"],

Cell[BoxData[
    \(2\/3 + 7\/12\)], "Input"],

Cell["\<\
If a calculation involves even one approximate number (a number \
that contains a decimal point), however, the result will be an approximate \
number because the uncertainty associated with the approximate number \
propagates through the whole calculation.\
\>", "Text"],

Cell[BoxData[
    \(2\/3 + 7.0\/12\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Irrational Numbers", "Subsubsection"],

Cell[TextData[{
  "Irrational numbers (numbers that cannot be written as the quotient of two \
integers) are held in exact symbolic form. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows us to use exact irrational numbers in calculations and, unless we \
ask, it does not automatically approximate these numbers. The following \
difference of two exact irrational numbers is an exact irrational number."
}], "Text"],

Cell[BoxData[
    \(\@27 - \@12\)], "Input"],

Cell["The following difference is also left in exact form.", "Text"],

Cell[BoxData[
    \(\@27 - \@13\)], "Input"],

Cell["\<\
If we repeat the calculation with inexact input, however, we get an \
inexact answer.\
\>", "Text"],

Cell[BoxData[
    \(\@27.0 - \@13\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Constants", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " also has a number of common mathematical constants built in, defined so \
that we can take an approximation to whatever precision we want; the only \
limits being the amount of RAM installed on the computer and the amount of \
time we are willing to wait for an answer. Two of the more well known \
constants are ",
  StyleBox["Pi",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["E",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Pi > E\)], "Input"],

Cell[TextData[{
  StyleBox["Pi ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "and ",
  StyleBox["E",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be entered in the special forms \[Pi] and \[ExponentialE] by typing ",
  
  Cell[BoxData[
      \(\[EscapeKey]\)], "Input",
    GeneratedCell->True],
  "p",
  Cell[BoxData[
      \(\[EscapeKey]\)], "Input",
    GeneratedCell->True],
  " and ",
  Cell[BoxData[
      \(\[EscapeKey]\)], "Input",
    GeneratedCell->True],
  "ee",
  Cell[BoxData[
      \(\[EscapeKey]\)], "Input",
    GeneratedCell->True],
  "."
}], "Text"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\[Pi]\ \[ImaginaryI]\)\)], "Input"],

Cell[TextData[{
  "As with other irrational numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " leaves constants in symbolic form unless we specifically ask for an \
approximation with the function ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", described below. Here is a 250-digit approximation to \[Pi]."
}], "Text"],

Cell[TextData["N[\[Pi], 250]"], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " also knows the standard rules for dealing with infinity, entered as ",
  StyleBox["Infinity",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " or \[Infinity] (\[EscapeKey]inf\[EscapeKey])."
}], "Text"],

Cell[BoxData[
    \({1\/Infinity, Infinity - 1}\)], "Input"],

Cell[TextData[{
  "The add-on package ",
  StyleBox["Miscellaneous`PhysicalConstants`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " defines a wide range of physical constants such as the speed of light, \
the radius of the earth, acceleration due to gravity, Avogadro\
\[CloseCurlyQuote]s constant, and many more."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Degree",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (\[Degree]), ",
  StyleBox["GoldenRatio",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["EulerGamma",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Catalan",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Indeterminate",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DirectedInfinity",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Miscellaneous`Units`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsubsection"],

Cell[TextData[{
  StyleBox["I",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " denotes the imaginary unit ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Sqrt[\(-9\)]\)], "Input"],

Cell[TextData[{
  "We can enter ",
  StyleBox["I",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in the special form \[ImaginaryI] by typing \[EscapeKey]ii\[EscapeKey]."
}], "Text"],

Cell[BoxData[
    \(\[ImaginaryI]\^2\)], "Input"],

Cell[TextData[
"We can also use the form \[ImaginaryJ], used in some scientific fields, by \
typing \[EscapeKey]jj\[EscapeKey]."], "Text"],

Cell[BoxData[
    \(\((5\ \[ImaginaryJ])\)\^2\)], "Input"],

Cell["As with all numbers, exact input generates exact output.", "Text"],

Cell[BoxData[
    \(\((3 + 19  I)\)/\((2 - 9  I)\)\)], "Input"],

Cell["Inexact input leads to inexact output.", "Text"],

Cell[BoxData[
    \(\((3.0 + 19  I)\)/\((2 - 9  I)\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows the standard functions for describing and manipulating complex \
numbers. ",
  StyleBox["Re[z]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the real part of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", ",
  StyleBox["Im[z]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the imaginary part, and so forth."
}], "Text"],

Cell[TextData[{
  "Here is a complex number called ",
  StyleBox["num",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(num = 1.23 + 4.56\ I\)], "Input"],

Cell[TextData[{
  "Here is a list of the real and imaginary parts of ",
  StyleBox["num",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \({Re[num], \ Im[num]}\)], "Input"],

Cell[TextData[{
  "Here is the conjugate of ",
  StyleBox["num",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(Conjugate[num]\)], "Input"],

Cell[TextData[{
  "Here are the absolute value and approximate argument (or phase), in \
radians, of ",
  StyleBox["num",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \({Abs[num], \ Arg[num]}\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Converting between Types of Numbers", "Subsubsection"],

Cell[TextData[{
  "To convert from an exact number to an approximate number we use the \
function ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". ",
  StyleBox["N[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a numerical approximation to ",
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(N[\@27 - \@13]\)], "Input"],

Cell[TextData[{
  StyleBox["N[expr, n]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " does computations to at most n significant digits. Here is a 100-digit \
approximation to the difference between ",
  Cell[BoxData[
      \(TraditionalForm\`22\/7\)]],
  " and \[Pi]."
}], "Text"],

Cell[BoxData[
    \(N[22/7 - \[Pi], 100]\)], "Input"],

Cell["\<\
The presence of the decimal point in the following example \
indicates the change from exact integer to approximate real number.\
\>", 
  "Text"],

Cell[BoxData[
    \(N[2]\)], "Input"],

Cell[TextData[{
  "There are many functions that convert an approximate number into an exact \
integer. ",
  StyleBox["Round[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the integer closest to ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Floor[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the greatest integer less than ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["Ceiling[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the least integer greater than ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \({Round[3.3], Floor[3.3], Ceiling[3.3]}\)], "Input"],

Cell[TextData[{
  StyleBox["Chop[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " replaces approximate real numbers in ",
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " that are close to zero (within ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-10\)\)]],
  ") with the exact integer 0. ",
  StyleBox["Chop[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["tol",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " replaces approximate real numbers in ",
  StyleBox["expr",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " that differ from zero by less than ",
  StyleBox["tol",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " with 0."
}], "Text"],

Cell[BoxData[
    \(Chop[1.012 + 10\^\(-20\)\ I]\)], "Input"],

Cell["\<\
When we take the Fourier transform of a list of approximate \
numbers, then take the inverse Fourier transform of the result, the \
uncertainty in the approximate input leads to spurious imaginary parts in the \
answer.\
\>", "Text"],

Cell[BoxData[
    \(InverseFourier[Fourier[{0, 0, 0, 1., 1., 1.}]]\)], "Input"],

Cell[TextData[{
  StyleBox["Chop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " removes the small imaginary parts of the answer, and returns the original \
data."
}], "Text"],

Cell[BoxData[
    \(Chop[%]\)], "Input"],

Cell[TextData[{
  "The function ",
  StyleBox["Rationalize",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " converts numbers into exact rational numbers. ",
  StyleBox["Rationalize[x,dx]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a rational number equal to ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " within a tolerance of ",
  StyleBox["dx",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "Here are some successively better rational approximations to \[Pi]. (",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is explained below in the section \[OpenCurlyDoubleQuote]Matrix and \
Vector Operations\[CloseCurlyDoubleQuote].)"
}], "Text"],

Cell[BoxData[
    \(Table[Rationalize[\[Pi], 10\^\(-2\^n\)], {n, 1, 4}]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["IntegerPart",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["FractionalPart",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["NumberTheory`Recognize`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Finding the Type of a Number", "Subsubsection"],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not have the concept of a type declaration (a statement such as \
\[OpenCurlyDoubleQuote]the variable x is a real \
number\[CloseCurlyDoubleQuote]), the type of a number can be found using the \
function ",
  StyleBox["Head",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". (",
  StyleBox["Head",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " has many other uses in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming.)"
}], "Text"],

Cell[BoxData[
    \(Head[2]\)], "Input"],

Cell[BoxData[
    \(Head[3.2]\)], "Input"],

Cell[BoxData[
    \(Head[3 + 19\ I]\)], "Input"],

Cell[BoxData[
    \(Head[2\/3]\)], "Input"],

Cell[TextData[{
  "Seel also ",
  StyleBox["FullForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Numbers and Constants", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Set the variable ",
  StyleBox["comp",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " equal to the complex number ",
  Cell[BoxData[
      \(TraditionalForm\`23 + 19  \[ImaginaryI]\)]],
  " . What is the absolute value of ",
  StyleBox["comp",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "? What is the result of adding ",
  StyleBox["comp",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and its conjugate?"
}], "Question"],

Cell[BoxData[
    \(comp = 23 + 19\ I\)], "Input"],

Cell[BoxData[
    \(Abs[comp]\)], "Input"],

Cell[BoxData[
    \(comp + Conjugate[comp]\)], "Input"],

Cell[TextData[{
  "Catalan\[CloseCurlyQuote]s constant (used in combinatorics) is built into \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Knowing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s naming conventions, find ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s",
  StyleBox[" ",
    FontSlant->"Italic"],
  "name for the constant, then find an approximation to this number with 100 \
digits of precision. "
}], "Question"],

Cell[TextData[{
  "We search for a list of functions that contain the word ",
  StyleBox["Catalan", "Input"],
  "; there is only one, so ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " displays the usage message for it."
}], "SmallText"],

Cell[BoxData[
    \(\(?*Catalan*\)\)], "Input"],

Cell[TextData[{
  "We use ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to find a 100-digit numeric approximation."
}], "SmallText"],

Cell[BoxData[
    \(N[Catalan, 100]\)], "Input"],

Cell[TextData[{
  "Enter the expression ",
  Cell[BoxData[
      \(TraditionalForm\`2 \@ 19 + 2\)]],
  " into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Take approximations to 20, 30, and 100 decimal places. "
}], "Question"],

Cell[TextData[{
  "Because the number is an exact quantity, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " leaves it in symbolic form."
}], "SmallText"],

Cell[BoxData[
    \(2\ Sqrt[19] + 2\)], "Input"],

Cell[TextData[{
  "Here we use ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to approximate the number."
}], "SmallText"],

Cell[BoxData[
    \(N[2 + 2\ \@19, 20]\)], "Input"],

Cell[BoxData[
    \(N[2 + 2\ \@19, 30]\)], "Input"],

Cell[BoxData[
    \(N[2 + 2\ \@19, 100]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematical Functions", "Subsection"],

Cell[CellGroupData[{

Cell["Elementary Functions", "Subsubsection"],

Cell[TextData[{
  "All the standard elementary functions are built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "All of the trigonometric functions are available. Note that when given \
exact input, they return exact output, and that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the standard abbreviations for trigonometric functions."
}], "Text"],

Cell["Sin[Pi/4]", "Input"],

Cell[TextData[{
  "By default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " assumes that arguments to trigonometric functions are in radians. For \
entering arguments in degrees there is a multiplier called ",
  StyleBox["Degree",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". (",
  StyleBox["Degree",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be entered in the special form \[Degree] by typing \[EscapeKey]deg\
\[EscapeKey].)"
}], "Text"],

Cell[BoxData[
    \(Cos[15\ Degree]\)], "Input"],

Cell["Where appropriate, functions are defined for complex values.", "Text"],

Cell[BoxData[
    \(Sin[6.54321 - 1.23456\ I]\)], "Input"],

Cell["\<\
Inverse and hyperbolic trigonometric functions are also \
available.\
\>", "Text"],

Cell[BoxData[
    \(ArcSin[1/2]\)], "Input"],

Cell[TextData[{
  "Here no exact mathematical result is known, so ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the expression unevaluated."
}], "Text"],

Cell[BoxData[
    \(Sinh[3]\)], "Input"],

Cell[TextData[{
  "If we give approximate input, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an approximate answer."
}], "Text"],

Cell[BoxData[
    \(Sinh[3.0]\)], "Input"],

Cell[TextData[{
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " also returns an approximate value."
}], "Text"],

Cell[BoxData[
    \(N[Sinh[3]]\)], "Input"],

Cell[TextData[{
  "Logarithmic and exponential functions are also built in. ",
  StyleBox["Log[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the natural logarithm of ",
  StyleBox["z",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Log[Exp[5]]\)], "Input"],

Cell[TextData[{
  StyleBox["Log[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the logarithm to base ",
  StyleBox["b",
    FontSlant->"Italic"],
  " of ",
  StyleBox["z",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Log[10, \ 10000]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Tan",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["ArcTan",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Tanh",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["ArcTanh",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Functions", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " includes many special functions that cover a wide range of scientific \
subjects. In most cases, special functions are solutions to transcendental \
equations, integrals, or differential equations that have no elementary \
symbolic solution. In many cases it is advisable to consult ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " to see what definition ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses for a particular special function, as many special functions have \
conflicting definitions in different fields."
}], "Text"],

Cell[TextData[{
  "In general, if a function is named after a person, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " name for it is ",
  StyleBox["PersonSymbol",
    FontSlant->"Italic"],
  ". For example, to find out if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows any of the Bessel functions, we assume the word \
\[OpenCurlyDoubleQuote]Bessel\[CloseCurlyDoubleQuote] is in the name, and use \
the question mark to get a list of all such functions."
}], "Text"],

Cell["? *Bessel*", "Input"],

Cell["Here is the usage message for a particular Bessel function.", "Text"],

Cell["? BesselJ", "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s special functions are typically defined for both real \
and complex arguments, and know special values of the functions."
}], "Text"],

Cell[BoxData[
    \(Gamma[1/2]\)], "Input"],

Cell[BoxData[
    \(Gamma[1.23 + 4.56\ I]\)], "Input"],

Cell[BoxData[
    \(Zeta[8]\)], "Input"],

Cell[TextData[{
  "There are several hundred special functions built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and the Help Browser provides a convenient way to explore the different \
classes of functions."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Erf",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Binomial",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Multinomial",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Beta",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Factorial",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["HypergeometricPFQ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["MeijerG",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix and Vector Operations", "Subsection"],

Cell[CellGroupData[{

Cell["Creating Vectors, Matrices, and Tensors", "Subsubsection"],

Cell[TextData[{
  "The basic structural form in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the list, which is an arbitrary collection of numbers, variables, \
data, and other objects, where the elements are separated by commas and \
enclosed within braces ",
  StyleBox["{\[NonBreakingSpace]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", as in ",
  StyleBox["{1, 4, 2}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "A list can have several interpretations, depending on its context. For \
example, the list ",
  StyleBox["{1, 4, 2}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be interpreted as a vector with three components, a point in 3-space, \
or a data set containing three measurements; and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically treats a list correctly depending on the functions used \
with it."
}], "Text"],

Cell[TextData[{
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is one of several commands used to generate lists."
}], "Text"],

Cell[TextData[{
  StyleBox["Table[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["{",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox["}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " generates a list of ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  " copies of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Table[again, \ {7}]\)], "Input"],

Cell["Here is a vector of ten zeros.", "Text"],

Cell[BoxData[
    \(Table[0, {10}]\)], "Input"],

Cell[TextData[{
  StyleBox["Table[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["{i,",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox["}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "generates a list of the values of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " when ",
  StyleBox["i",
    FontSlant->"Italic"],
  " runs from 1 to ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Table[i/12, \ {i, 12}]\)], "Input"],

Cell[TextData[{
  StyleBox["Table[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[", {",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "i, ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox["}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " starts with i = ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Table[Sqrt[i], \ {i, 5, 15}]\)], "Input"],

Cell[TextData[{
  StyleBox["Table[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "expr",
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["{",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "i, ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  ", di",
  StyleBox["}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " uses the increment di."
}], "Text"],

Cell[BoxData[
    \(Table[Sqrt[i], \ {i, 2, 5, 1/2}]\)], "Input"],

Cell[TextData[{
  StyleBox["Table[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "expr",
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["{",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "i, ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox["},",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["{",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "j, ",
  Cell[BoxData[
      \(TraditionalForm\`j\_min\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`j\_max\)]],
  StyleBox["},",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " \[Ellipsis]",
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " generates a nested (multi-dimensional) list."
}], "Text"],

Cell["Table[i/j, {i,1,4}, {j,1,2}]", "Input"],

Cell[TextData[{
  "A matrix is represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a two-dimensional list, where each sublist represents a separate row \
of the matrix. Here we create a matrix by using ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " with two iterators."
}], "Text"],

Cell[BoxData[
    \(Table[a + b, \ {a, 2, 5}, \ {b, 1, 3}]\)], "Input"],

Cell[TextData[{
  "We can also enter matrices by hand, being sure to enclose each sublist \
with curly brackets ",
  StyleBox["{",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". For example, a 3 \[Times] 3 matrix is a list containing three sublists, \
where each sublist is one row of the matrix."
}], "Text"],

Cell[BoxData[
    \(matrix = {{1, 2, 3}, {3, 4, 5}, {5, 6, 7}}\)], "Input"],

Cell[TextData[{
  "We can also enter matrices in two-dimensional form by clicking a button in \
a palette, or pulling down the Input menu, choosing ",
  StyleBox["Create Table/Matrix/Palette", "MenuItem"],
  ", clicking the ",
  StyleBox["Matrix", "MenuItem"],
  " button, choosing the desired numbers of rows and columns, and clicking \
the ",
  StyleBox["OK", "MenuItem"],
  " button, after which we fill in the placeholders. Notice that the default \
output form of the following matrix is still a nested list of elements."
}], "Text"],

Cell[BoxData[
    RowBox[{"matrix", "=", 
      RowBox[{"(", GridBox[{
            {"1", "2", "3"},
            {"3", "4", "5"},
            {"5", "6", "7"}
            }], ")"}]}]], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Range",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Array",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DiagonalMatrix",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["IdentityMatrix",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Formatting Matrices and Tensors", "Subsubsection"],

Cell[TextData[{
  StyleBox["MatrixForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " displays a matrix in two-dimensional form. Here we use the matrix defined \
above."
}], "Text"],

Cell[BoxData[
    \(MatrixForm[matrix]\)], "Input"],

Cell[TextData[{
  StyleBox["TableForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a generalization of ",
  StyleBox["MatrixForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " that formats arbitrary arrays of elements. Here is the ",
  StyleBox["TableForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " of a four-dimensional tensor (created by giving ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " four iterators)."
}], "Text"],

Cell[BoxData[
    \(TableForm[Table[i + j + k - l, {i, 2}, {j, 3}, {k, 4}, {l, 5}]]\)], 
  "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["TableSpacing",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["TableAlignments",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Describing and Manipulating Lists", "Subsubsection"],

Cell[TextData[{
  "There are many functions for describing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists. For instance, we can compute the length or dimensions of a vector \
or matrix."
}], "Text"],

Cell[BoxData[
    \(Length[{a, b, c, d, e}]\)], "Input"],

Cell[BoxData[
    RowBox[{"Dimensions", "[", 
      RowBox[{"(", GridBox[{
            {"a", "b", "c"},
            {"d", "e", "f"}
            }], ")"}], "]"}]], "Input"],

Cell[TextData[{
  StyleBox["Part",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " extracts an element from a list according to its position. Here is the \
fourth element of a list. (Note that the first element of a list has position \
1, not 0.)"
}], "Text"],

Cell[BoxData[
    \(Part[{a, b, c, d, e}, 4]\)], "Input"],

Cell[TextData[{
  "An abbreviation for ",
  StyleBox["Part",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the following double square bracket notation, where the desired \
position is placed inside ",
  StyleBox["[[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \({a, b, c, d, e}[\([4]\)]\)], "Input"],

Cell["\<\
We can also extract elements according to their distance from the \
end of the list, by giving a negative position. Here is the last element of a \
list.\
\>", "Text"],

Cell[BoxData[
    \({a, b, c, d, e}[\([\(-1\)]\)]\)], "Input"],

Cell[TextData[{
  "We extract ranges of elements from a list using ",
  StyleBox["Take",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". Here are the first three elements of a list."
}], "Text"],

Cell[BoxData[
    \(Take[{a, b, c, d, e}, 3]\)], "Input"],

Cell["Here are the second through fourth elements.", "Text"],

Cell[BoxData[
    \(Take[{a, b, c, d, e}, {2, 4}]\)], "Input"],

Cell[TextData[{
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " removes elements from a list. Here we drop the first three elements from \
a list."
}], "Text"],

Cell[BoxData[
    \(Drop[{a, b, c, d, e}, 3]\)], "Input"],

Cell["Here we drop the last three elements.", "Text"],

Cell[BoxData[
    \(Drop[{a, b, c, d, e}, \(-3\)]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many built-in routines for sorting and otherwise rearranging lists."
}], "Text"],

Cell[BoxData[
    \(Sort[{1, 3, 5, 2, 4, 6}]\)], "Input"],

Cell[BoxData[
    \(Reverse[{a, b, c, d, e}]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Extract",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Select",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Cases",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Depth",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["TensorRank",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Append",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Prepend",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Insert",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Join",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Union",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Intersection",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Flatten",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Partition",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Split",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["LinearAlgebra`MatrixManipulation`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Linear Algebra", "Subsubsection"],

Cell[TextData[{
  "Here is a Hilbert matrix, where each element of the matrix is a function \
of its indices, created using ",
  StyleBox["Table", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(hil = Table[\((i + j - 1)\)\^\(-1\), {i, 3}, {j, 3}]\)], "Input"],

Cell[TextData[{
  "Here is the standard matrix form of ",
  StyleBox["hil", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(MatrixForm[hil]\)], "Input"],

Cell["\<\
Standard operations, such as computing the determinant or \
eigenvalues of a matrix, are straightforward.\
\>", "Text"],

Cell[BoxData[
    \(Det[hil]\)], "Input"],

Cell[BoxData[
    \(Eigenvalues[N[hil]]\)], "Input"],

Cell[TextData[{
  "We can also take the inverse, here giving it the name ",
  StyleBox["inv", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(inv = Inverse[hil]\)], "Input"],

Cell[TextData[{
  StyleBox["Cross[", "Input"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{"a", 
          StyleBox["\[Cross]",
            "Input"], "b"}], TraditionalForm]]],
  " (where \[Cross] is entered ",
  Cell[TextData["\\\[InvisibleSpace][Cross]"], "Input"],
  ") returns the vector cross product of ",
  StyleBox["a",
    FontSlant->"Italic"],
  " and ",
  StyleBox["b",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Cross[{1, 2, 3}, {a, b, c}]\)], "Input"],

Cell[TextData[{
  StyleBox["Dot[", "Input"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " or ",
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[".", "Input"],
  StyleBox["b",
    FontSlant->"Italic"],
  " gives products of vectors, matrices, and tensors. Here is the dot product \
of the vectors ",
  StyleBox["{1,2,3}", "Input"],
  " and ",
  StyleBox["{a,b,c}", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \({1, 2, 3}.{a, b, c}\)], "Input"],

Cell[TextData[{
  "Here is the matrix product of the Hilbert matrix ",
  StyleBox["hil", "Input"],
  " and its inverse ",
  StyleBox["inv", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(MatrixForm[hil.inv]\)], "Input"],

Cell["An identity matrix is the expected result.", "Text"],

Cell[TextData[{
  "It is important not to confuse the matrix-multiplication operator ",
  StyleBox[".", "Input"],
  " and ordinary multiplication ",
  StyleBox["*", "Input"],
  ". Using ",
  StyleBox["*", "Input"],
  " to multiply the two matrices results in termwise multiplication."
}], "Text"],

Cell[BoxData[
    \(MatrixForm[hil*inv]\)], "Input"],

Cell["\<\
We do use ordinary multiplication to multiply a scalar by a vector \
or matrix.\
\>", "Text"],

Cell[BoxData[
    \(\[Lambda]*{1, 3, 5, 7}\)], "Input"],

Cell[TextData[{
  "There are many other matrix functions defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". For example, \n",
  StyleBox["Minors[", "Input"],
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["k",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " gives a matrix consisting of the determinants of all ",
  StyleBox["k",
    FontSlant->"Italic"],
  " \[Times] ",
  StyleBox["k",
    FontSlant->"Italic"],
  " submatrices of ",
  StyleBox["m",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Minors[hil, 2]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"mp", "=", 
        RowBox[{"MatrixPower", "[", 
          RowBox[{
            RowBox[{"(", GridBox[{
                  {"1", "1"},
                  {"1", "0"}
                  }], ")"}], ",", "10"}], "]"}]}], ";", " ", 
      \(MatrixForm[mp]\)}]], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Transpose",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Eigenvectors",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Eigensystem",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["LinearSolve",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["NullSpace",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["RowReduce",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["LinearProgramming",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["MatrixExp",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["MatrixPower",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Inner",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Outer",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["LinearAlgebra`Orthogonalization`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercises: Numerical Matrix Operations", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input"],
  " to create a 5 \[Times] 5 matrix where each element has the form ",
  Cell[BoxData[
      \(TraditionalForm\`1\/\(i\^2 + j\^2 - 1\)\)]],
  "."
}], "Question"],

Cell[BoxData[
    \(matrix = Table[1\/\(i\^2 + j\^2 - 1\), {i, 1, 5}, {j, 1, 5}]\)], "Input"],

Cell[TextData[{
  "Display the matrix using ",
  StyleBox["MatrixForm", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[BoxData[
    \(MatrixForm[matrix]\)], "Input"],

Cell["Compute the inverse of this matrix.", "Question"],

Cell[BoxData[
    \(inv = Inverse[matrix]; MatrixForm[inv]\)], "Input"],

Cell[TextData[{
  "Display a numerical approximation to the inverted matrix using ",
  StyleBox["MatrixForm",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[BoxData[
    \(MatrixForm[N[inv]]\)], "Input"],

Cell["Find the determinant of the inverted matrix.", "Question"],

Cell["Here is the determinant of the exact matrix.", "SmallText"],

Cell[BoxData[
    \(Det[inv]\)], "Input"],

Cell["Here is an approximation to the determinant.", "SmallText"],

Cell[BoxData[
    \(N[%]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Working with Precision", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can work with numbers with any number of digits, and in the case of \
approximate numbers it maintains information about how many of the digits are \
significant. The number of significant digits in a number ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called the ",
  StyleBox["precision",
    FontSlant->"Italic"],
  " of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows the rules of numerical analysis for dealing with numbers with \
different amounts of precision."
}], "Text"],

Cell[TextData[{
  StyleBox["Precision[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["x",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the number of significant digits in the number ",
  StyleBox["x",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Precision[N[\[Pi], 40]]\)], "Input"],

Cell[TextData[{
  StyleBox["Accuracy",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the number of digits to the right of the decimal point. Precision \
is a measure of the relative error of a number, and accuracy is a measure of \
the absolute error."
}], "Text"],

Cell["The following number has 24 significant digits.", "Text"],

Cell[BoxData[
    \(Precision[1234567890.123456789012345]\)], "Input"],

Cell["It has 15 digits to the right of the decimal point.", "Text"],

Cell[BoxData[
    \(Accuracy[1234567890.123456789012345]\)], "Input"],

Cell[TextData[{
  "For simplicity, we deal primarily with ",
  StyleBox["Precision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in these notes."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses two types of approximate numbers, ",
  StyleBox["machine-precision",
    FontSlant->"Italic"],
  " numbers and ",
  StyleBox["arbitrary-precision",
    FontSlant->"Italic"],
  " numbers. Machine-precision numbers are numbers that can be calculated \
using a computer\[CloseCurlyQuote]s hardware: most computers can directly \
handle numbers with up to 16 significant digits. (The number of digits that \
the hardware can handle is stored in the parameter ",
  StyleBox["$MachinePrecision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ".) For efficiency reasons, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does any calculation that contains even one machine-precision number to \
machine precision."
}], "Text"],

Cell[TextData[{
  "We determine a machine\[CloseCurlyQuote]s precision by looking at the \
value of ",
  StyleBox["$MachinePrecision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \($MachinePrecision\)], "Input"],

Cell["\<\
The number 2.3 in the following calculation is a machine-precision \
number (while the other number is not), so the answer is a machine-precision \
number.\
\>", "Text"],

Cell[BoxData[
    \(2.3 + 1.234567890123456789012345\)], "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[TextData[{
  "By default, ",
  StyleBox["N",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a machine-precision number."
}], "Text"],

Cell[BoxData[
    \(N[\@19]\)], "Input"],

Cell["Precision[%]", "Input"],

Cell[TextData[{
  "If a number has more than 16 (or the value of ",
  StyleBox["$MachinePrecision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", if different) significant digits, it is called an arbitrary-precision \
number."
}], "Text"],

Cell[TextData[{
  "Here we ask for an approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`\@19\)]],
  " with 50 significant digits."
}], "Text"],

Cell[BoxData[
    \(N[\@19, \ 50]\)], "Input"],

Cell["\<\
The precision of the result is 50, making the approximation an \
arbitrary-precision number.\
\>", "Text"],

Cell["Precision[%]", "Input"],

Cell[TextData[{
  "Note that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " defaults to machine precision when a number with lower precision than \
machine precision is generated."
}], "Text"],

Cell[BoxData[
    \(N[\@19, 4]\)], "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[TextData[{
  "Using ",
  StyleBox["SetPrecision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " we can artificially set the precision of a number to an arbitrary number \
of digits."
}], "Text"],

Cell[BoxData[
    \(SetPrecision[\ N[\@19, 4], \ 5]\)], "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[TextData[{
  "When using arbitrary-precision numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not generate more precision than is justified by the calculation. \
For example, adding two values with different numbers of significant digits \
returns a number as precise as the less precise value."
}], "Text"],

Cell[BoxData[
    \(x\_1 = 54.23232323232312312624874590149643; \n
    x\_2 = 34323.98129712872939137913; \)], "Input"],

Cell[BoxData[
    \(Precision[x\_1]\)], "Input"],

Cell[BoxData[
    \(Precision[x\_2]\)], "Input"],

Cell[TextData[{
  "The precision of the sum is equal to the precision of ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Precision[x\_1 + x\_2]\)], "Input"],

Cell[TextData[{
  "The precision of an exact number is ",
  StyleBox["Infinity",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell["\<\
We can approximate an exact number to as many digits as \
desired.\
\>", "Text"],

Cell[BoxData[
    \(N[Sin[1], 250]\)], "Input"],

Cell["\<\
However, we cannot approximate the following machine-precision \
number to more than machine precision.\
\>", "Text"],

Cell[BoxData[
    \(N[Sin[1.0], 250]\)], "Input"],

Cell[TextData[{
  "An additional way to enter a number with a known precision is in the form \
",
  StyleBox["nnnn",
    FontSlant->"Italic"],
  StyleBox["`", "Input"],
  StyleBox["p",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["nnnn",
    FontSlant->"Italic"],
  " is the number and ",
  StyleBox["p",
    FontSlant->"Italic"],
  " is the number of digits of precision. For example, here is an \
approximation to \[Pi] with three digits of precision."
}], "Text"],

Cell[BoxData[
    \(3.141`3\)], "Input"],

Cell[TextData[{
  "By default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints only the correct digits, without the ",
  StyleBox["`", "Input"],
  StyleBox["p",
    FontSlant->"Italic"],
  ". To explicitly see all of the information ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has for a number, we look at the number\[CloseCurlyQuote]s input form."
}], "Text"],

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell[TextData[{
  "As with arbitrary-precision arithmetic, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " keeps track of the number of significant digits in a result. Here we use \
several imprecise numbers in the calculation of the volume of a cylinder, and \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an answer with the correct number of significant digits."
}], "Text"],

Cell[BoxData[
    \(3.1416`4*\(\((11.1111`5)\)\^2\) \((15.253545`6)\)\)], "Input"],

Cell[TextData[{
  "Similarly, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows the standard rules of interval arithmetic. Here is a similar \
calculation performed using intervals."
}], "Text"],

Cell[BoxData[
    \(Interval[{3.1415, 3.1416}]*Interval[{11.11105, 11.11110}]\^2*
      Interval[{15.25350, 15.25355}]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["MachineNumberQ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["SetAccuracy",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["PrecisionGoal",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["AccuracyGoal",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["$NumberMarks",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["$MaxExtraPrecision",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Interval",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["IntervalMemberQ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["NumericalMath`Microscope`",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " "
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Working With Precision", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Find the machine precision of a particular machine either by entering ",
  StyleBox["$MachinePrecision", "Input",
    FontFamily->"Courier"],
  " or by entering a machine-precision number and finding its precision."
}], "Question"],

Cell[BoxData[
    \(Precision[3.0]\)], "Input"],

Cell[BoxData[
    \($MachinePrecision\)], "Input"],

Cell[TextData[{
  "Create an number with more than machine precision by entering digits by \
hand, and add it to a machine-precision number. What is the precision of the \
result? Now add ",
  StyleBox["Sqrt[3]", "Input"],
  " to the original number. What is the precision of the result?"
}], "Question"],

Cell["Here is a number with more than machine precision.", "SmallText"],

Cell[BoxData[
    \(bignum = 12.32121212134312321234\)], "Input"],

Cell[BoxData[
    \(Precision[bignum]\)], "Input"],

Cell[TextData[{
  "Here is the sum of ",
  StyleBox["bignum", "Input"],
  " and a machine-precision number."
}], "SmallText"],

Cell[BoxData[
    \(result = bignum + 2.3\)], "Input"],

Cell["The result has machine precision.", "SmallText"],

Cell[BoxData[
    \(Precision[result]\)], "Input"],

Cell[TextData[{
  "Here is the sum of ",
  StyleBox["bignum", "Input"],
  " and an exact quantity (a number with infinite precision)."
}], "SmallText"],

Cell[BoxData[
    \(result2 = bignum + Sqrt[3]\)], "Input"],

Cell[TextData[{
  "The result has the same precision as ",
  StyleBox["bignum", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(Precision[result2]\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Solving", "Subsection"],

Cell[TextData[{
  StyleBox["Solve", "Input"],
  " is the basic function for solving equations in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Solve", "Input"],
  " finds solutions to equations using algebraic methods, which are often \
enough to get an exact numeric result. "
}], "Text"],

Cell["\<\
When we solve this quadratic equation, we get an answer involving \
irrational numbers.\
\>", "Text"],

Cell[BoxData[
    \(Solve[\ 3\ x\^2 - 12\ x + 10 == 11, \ x]\)], "Input"],

Cell[TextData[{
  "We get approximate solutions by using ",
  StyleBox["N", "Input"],
  " on the exact solutions."
}], "Text"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  "But when we try to solve a quintic (fifth-degree polynomial) equation, we \
find that we do not get a numerical answer, but rather an implicit symbolic \
answer in the form of ",
  StyleBox["Root", "Input"],
  " objects."
}], "Text"],

Cell[BoxData[
    \(Solve[x\^5 + 5  x + 1 == 0, \ x]\)], "Input"],

Cell[TextData[{
  StyleBox["N", "Input"],
  " still returns approximations to the implicit solutions."
}], "Text"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  "When an equation cannot be solved symbolically, ",
  StyleBox["NSolve", "Input"],
  " will often find numeric solutions. (Using ",
  StyleBox["NSolve", "Input"],
  " is different from using both ",
  StyleBox["N", "Input"],
  " and ",
  StyleBox["Solve", "Input"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(NSolve[x\^5 - x\^4 + 12\ x\^3 - 11\ x\^2 + x - 12 == 0, \ x]\)], "Input"],

Cell[TextData[{
  StyleBox["NSolve", "Input"],
  " solves systems of any number of algebraic equations for an appropriate \
number of unknowns. Here we look for the points of intersection between an \
ellipse and a line. The graph allows us to make a visual approximation of the \
solutions."
}], "Text"],

Cell[BoxData[{
    \(\(Needs["\<Graphics`ImplicitPlot`\>"]; \)\), 
    \(\(ImplicitPlot[{3\ x\^2 + 12\ y\^2 == 10, 12\ x - 19\ y == 10}, {x, 
        \(-2\), 2}, {y, \(-1\), 1}]; \)\)}], "Input"],

Cell[TextData[{
  StyleBox["NSolve", "Input"],
  " numerically solves the system of equations."
}], "Text"],

Cell[BoxData[
    \(NSolve[{3\ x\^2 + 12\ y\^2 == 10, \ 12\ x\  - \ 19\ y == 10}, 
      \ {x, \ y}]\)], "Input"],

Cell[TextData[{
  "There are several pairs of functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " whose names differ by the letter N, such as ",
  StyleBox["Solve", "Input"],
  " and ",
  StyleBox["NSolve", "Input"],
  ", and ",
  StyleBox["Integrate", "Input"],
  " and ",
  StyleBox["NIntegrate", "Input"],
  ". These \[OpenCurlyDoubleQuote]N-functions\[CloseCurlyDoubleQuote] perform \
their operations numerically, rather than symbolically. Although in most \
cases we arrive at the same result by taking a numerical approximation of a \
symbolic solution, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is in fact using a different algorithm."
}], "Text"],

Cell[TextData[{
  StyleBox["FindRoot", "Input"],
  " searches for a root of an equation, using a given starting point. This \
function uses Newton\[CloseCurlyQuote]s method to find the roots of \
non-algebraic expressions that ",
  StyleBox["NSolve", "Input"],
  " cannot solve."
}], "Text"],

Cell[TextData[{
  "Here is a graph of a transcendental expression; the roots of the \
expression are the points at which the graph crosses the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Exp[x] - Sin[x], \ {x, \(-7\), 2}, \ 
      PlotLabel -> "\<exp(x) - sin(x)\>"]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["NSolve", "Input"],
  " is unable to solve this equation."
}], "Text"],

Cell[BoxData[
    \(NSolve[Exp[x] - Sin[x] == 0, \ x]\)], "Input"],

Cell[TextData[{
  StyleBox["FindRoot", "Input"],
  " returns one root of the equation, given a starting point for the search \
algorithm. From the graph it appears that one root is near ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-6\)\)]],
  ", so we use ",
  Cell[BoxData[
      \(TraditionalForm\`\(-6\)\)]],
  " as one starting point. The result indicates that there is a root at ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-6.28131\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(FindRoot[Exp[x] - Sin[x] == 0, \ {x, \ \(-6\)}]\)], "Input"],

Cell[TextData[{
  "The other root appears to be near ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-3\)\)]],
  ", so we use ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\)\)]],
  " as the second starting point."
}], "Text"],

Cell[BoxData[
    \(FindRoot[Exp[x] - Sin[x] == 0, \ {x, \ \(-3\)}]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["RootReduce", "Input"],
  ", ",
  StyleBox["ToRadicals", "Input"],
  ", ",
  StyleBox["NumericalMath`IntervalRoots`", "Input"]
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Equation Solving", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Use ",
  StyleBox["FindRoot", "Input"],
  " to find approximations for the three roots of the function graphed below. \
(Hint: estimate the starting points from the graph.)"
}], "Question"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.253778 0.00460373 [
[.02381 .24128 -9 -9 ]
[.02381 .24128 9 0 ]
[.2619 .24128 -6 -9 ]
[.2619 .24128 6 0 ]
[.7381 .24128 -3 -9 ]
[.7381 .24128 3 0 ]
[.97619 .24128 -6 -9 ]
[.97619 .24128 6 0 ]
[.4875 .06963 -18 -4.5 ]
[.4875 .06963 0 4.5 ]
[.4875 .1617 -18 -4.5 ]
[.4875 .1617 0 4.5 ]
[.4875 .34585 -12 -4.5 ]
[.4875 .34585 0 4.5 ]
[.4875 .43793 -12 -4.5 ]
[.4875 .43793 0 4.5 ]
[.4875 .53 -12 -4.5 ]
[.4875 .53 0 4.5 ]
[.5 .63053 -35.6562 0 ]
[.5 .63053 35.6562 14.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .25378 m
.02381 .26003 L
s
[(-10)] .02381 .24128 0 1 Mshowa
.2619 .25378 m
.2619 .26003 L
s
[(-5)] .2619 .24128 0 1 Mshowa
.7381 .25378 m
.7381 .26003 L
s
[(5)] .7381 .24128 0 1 Mshowa
.97619 .25378 m
.97619 .26003 L
s
[(10)] .97619 .24128 0 1 Mshowa
.125 Mabswid
.07143 .25378 m
.07143 .25753 L
s
.11905 .25378 m
.11905 .25753 L
s
.16667 .25378 m
.16667 .25753 L
s
.21429 .25378 m
.21429 .25753 L
s
.30952 .25378 m
.30952 .25753 L
s
.35714 .25378 m
.35714 .25753 L
s
.40476 .25378 m
.40476 .25753 L
s
.45238 .25378 m
.45238 .25753 L
s
.54762 .25378 m
.54762 .25753 L
s
.59524 .25378 m
.59524 .25753 L
s
.64286 .25378 m
.64286 .25753 L
s
.69048 .25378 m
.69048 .25753 L
s
.78571 .25378 m
.78571 .25753 L
s
.83333 .25378 m
.83333 .25753 L
s
.88095 .25378 m
.88095 .25753 L
s
.92857 .25378 m
.92857 .25753 L
s
.25 Mabswid
0 .25378 m
1 .25378 L
s
.5 .06963 m
.50625 .06963 L
s
[(-40)] .4875 .06963 1 0 Mshowa
.5 .1617 m
.50625 .1617 L
s
[(-20)] .4875 .1617 1 0 Mshowa
.5 .34585 m
.50625 .34585 L
s
[(20)] .4875 .34585 1 0 Mshowa
.5 .43793 m
.50625 .43793 L
s
[(40)] .4875 .43793 1 0 Mshowa
.5 .53 m
.50625 .53 L
s
[(60)] .4875 .53 1 0 Mshowa
.125 Mabswid
.5 .09265 m
.50375 .09265 L
s
.5 .11567 m
.50375 .11567 L
s
.5 .13868 m
.50375 .13868 L
s
.5 .18472 m
.50375 .18472 L
s
.5 .20774 m
.50375 .20774 L
s
.5 .23076 m
.50375 .23076 L
s
.5 .2768 m
.50375 .2768 L
s
.5 .29982 m
.50375 .29982 L
s
.5 .32283 m
.50375 .32283 L
s
.5 .36887 m
.50375 .36887 L
s
.5 .39189 m
.50375 .39189 L
s
.5 .41491 m
.50375 .41491 L
s
.5 .46095 m
.50375 .46095 L
s
.5 .48396 m
.50375 .48396 L
s
.5 .50698 m
.50375 .50698 L
s
.5 .55302 m
.50375 .55302 L
s
.5 .57604 m
.50375 .57604 L
s
.5 .59906 m
.50375 .59906 L
s
.5 .04661 m
.50375 .04661 L
s
.5 .02359 m
.50375 .02359 L
s
.5 .00057 m
.50375 .00057 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -80.6562 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.875 translate 1 -1 scale
47.000000 14.875000 moveto
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
53.375000 10.875000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
61.812500 14.875000 moveto
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
70.187500 14.875000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(12) show
85.187500 14.875000 moveto
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.937500 14.875000 moveto
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
102.312500 14.875000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(12) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.5 Mabswid
s
s
s
s
s
s
.26054 0 m
.26171 .00859 L
.28302 .12519 L
.30316 .2122 L
.32313 .27831 L
.34157 .32328 L
.35124 .34125 L
.36029 .35485 L
.37023 .3664 L
.37577 .37141 L
.38092 .37518 L
.38581 .37802 L
.39102 .38027 L
.394 .38122 L
.39681 .38189 L
.39803 .38212 L
.39933 .38232 L
.40075 .38248 L
.40205 .38259 L
.4033 .38266 L
.40444 .38268 L
.40576 .38267 L
.40701 .38262 L
.40816 .38254 L
.40922 .38244 L
.41039 .3823 L
.41163 .38212 L
.41421 .38163 L
.41663 .38104 L
.42214 .37923 L
.42684 .3772 L
.43198 .37452 L
.44233 .36775 L
.46083 .3519 L
.50139 .30741 L
.54044 .26493 L
.55068 .25578 L
.56178 .2474 L
.56688 .24419 L
.57227 .24127 L
.57732 .23903 L
.58194 .23742 L
.58425 .23678 L
.58678 .23621 L
.58793 .236 L
.58916 .2358 L
.59031 .23565 L
.59137 .23554 L
.59269 .23544 L
.59338 .2354 L
Mistroke
.59411 .23538 L
.59534 .23536 L
.59604 .23537 L
.59669 .23539 L
.59791 .23545 L
.59902 .23554 L
.6003 .23568 L
.60151 .23585 L
.60372 .23627 L
.60607 .23685 L
.61029 .23827 L
.61482 .24036 L
.61982 .24336 L
.62994 .25182 L
.63921 .26254 L
.64938 .27784 L
.66008 .2982 L
.67986 .34843 L
.69824 .41119 L
.71874 .50146 L
.73734 .60366 L
Mfstroke
.73734 .60366 m
.7393 .61803 L
s
s
s
s
s
s
s
s
.5 g
gsave
.80952 .47936 -58.5 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Helvetica findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.500008 0.500008 0.500008 setrgbcolor
(roots) show
1.000000 setlinewidth
grestore
.78571 .45174 m
.31905 .25382 L
s
% Start of user PostScript
6. 43. -3.8 0.01 MAarrowhead1
% End of user PostScript
.78571 .45174 m
.55238 .25382 L
s
% Start of user PostScript
6. 43. 1.1 0.01 MAarrowhead1
% End of user PostScript
.78571 .45174 m
.62857 .25382 L
s
% Start of user PostScript
6. 43. 2.7 0.01 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[PP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP00054000?o0000>P000ol000290000D@000ol0
000j0003o`0008T0001B0003o`0003T000?o0000R@00058000?o0000>@000ol000290000DP000ol0
000i0003o`0008T0001B0003o`0003T000?o0000R@00058000?o0000>@000ol000290000D`000ol0
000h0003o`0008T0001C0003o`0003P000?o0000R@0005<000?o0000>0000ol000290000D`000ol0
000h0003o`0008T0001C0003o`0003P000?o0000R@0005<000?o0000>0000ol000290000E0000ol0
000g0003o`0008T0001D0003o`0003L000?o0000R@0005@000?o0000:@03o`<00_l60003o`0008T0
001D0003o`0002X000Go0000o`020003o`0000<000?o0000R@0005@000?o00008@05o`030?oo00?o
0P001?l00?l50003o`0008T0001E0003o`0002H000Co003o0`001?l00?l500;oRP0005D000?o0000
9`000ol0o`030004o`00o`D000?o0000R@0005D000?o0000:002o`<000Co003o1@000ol000290000
E@000ol0000Y0003o`0000800_l60003o`0008T0001E0003o`0003H000?o0000R@0005D000?o0000
=P000ol000290000EP000ol0000e0003o`0008T0001F0003o`0003D000?o0000R@0005H000?o0000
=@000ol000290000EP000ol0000e0003o`0008T0001F0003o`0003D000?o0000R@0005H000?o0000
=@000ol000290000E`000ol0000d0003o`0008T0001G0003o`0003@000?o0000R@0005L000?o0000
=0000ol000290000E`000ol0000d0003o`0008T0001G0003o`0003@000?o0000R@0005P000?o0000
<`000ol000290000F0000ol0000c0003o`0008T0001H0003o`0003<000?o0000R@0005P000?o0000
<`000ol000290000F0000ol0000S00Go0`02o`H000?o0000R@0005T000?o00008`001?l00?l20004
o`00o`D000?o0000R@0005T000?o00007005o`<000?o00000P001?l00?l500;oRP0005T000?o0000
9@001Ol0003o008000?o00000`000ol000290000F@000ol0000R0005o`000?l00P001?l00?l50003
o`0008T0001J0003o`00024000Go0000o`020004o`00o`D000?o0000R@0005X000?o00008P03o`@0
0_l60003o`0008T0001J0003o`00034000?o0000R@0005X000?o0000<@000ol000290000F`000ol0
000`0003o`0008T0001K0003o`00030000?o0000R@0005/000?o0000<0000ol000290000F`000ol0
000`0003o`0008T0001K0003o`00030000?o0000R@0001@00ol400;o=P03o`H000?o0000;`000ol0
000f00?o=P03o`@00_lA00005@000ol000020004o`00oc@000Go0000o`050003o`0002l000?o0000
=@001Ol0003o03H000?o00000P001?l00?l@00003@05o`<000?o00000P001?l00?l^00Go1@000ol0
00030003o`0002l000?o0000>@000ol0000d0003o`00008000Co003o400001D000?o00000P001?l0
0?lh0003o`0000<000?o0000;`000ol0000i0003o`0003@000?o00000P001?l00?l@00005@000ol0
00020004o`00oc@01?l70003o`0002h000?o0000=@04ocL000?o00000P001?l00?l@00005002o`@0
00Co003o=0000ol000080003o`0002h000?o0000=@000ol0000g00;o10001?l00?l@00005@000ol0
000300;o=@05o`H000?o0000;P000ol0000e00Go=P000ol0000300;o4@0005h000?o0000;@000ol0
000@00WoL00005h000?o0000;@000ol0000>00;o2@02ofh0001N0003o`0002d000?o00003@000ol0
000;0003o`0006/0001O0003o`0002`000?o00002`02o`l000?o0000JP000100D?l46SOo0QXAo`8J
G?l>00005P000ol000090003o`0000T000?o00002@000ol000090003o`0000T000?o00002@02o`80
2AX;0003o`0000T000?o00002@000ol0000800;o11X60003o`0000H00aX00ol000090003o`0000T0
00?o00002@000ol000090003o`0000T000?o00002@000ol000090003o`000180000F0003o`0003T0
00?o00002`000ol0000;6R0000?o000020000ol000056Ph00aXG0003o`0003T000?o00004P000600
00Co00002QXP0003o`0000L000?o00000P056Pd011YW0000H0000ol0000200PJ8@000ol000070003
o`0000801aX;00HJI@00064000?o00000`076R0000?o00001P000ol0000400PJ2P066V@0001Q0003
o`0000@011X2008J7P000ol000050003o`0000H021X900LJH`00064000?o00001@036P@00aXK0003
o`0000@000?o00001`086PX01aYR0000HP000ol0000500036P0000H00QXI0003o`0000<000?o0000
2@066P/021YQ0000HP000ol0000@008J5`000ol000020003o`0000X01AX00`0J000:00DJH`000680
00?o00004P036Q@000Go0000o`0>00<J0`000aX0000800@JI00006<000?o000050026Q8000Co003o
40000aX0000300036P0000L00aX00`0J001R0000H`000ol0000F008J40000ol0o`0H008J20001AX0
0?lJ0680001T0003o`0001L00aX=00;o6`000aX000090003oaX00600001T0003o`0001X00QX;0003
o`0001/000<J000020000ol06P1P0000I@000ol0000K008J2@000ol0000L00036P0000L000?o01X0
H00006D000?o00007@036PD00_lO00036P0000L000?o01X0G`0006D000?o000080026P8000?o0?l0
80000aX000060004o`006Uh0001V0003o`0002400QX20003o`0001l000<J00001P001?l001YM0000
IP000ol0000Q0003o`0J008J8P026PH000Co000JG@0006L000?o00007`000ol000020003oaXJ0280
00<J00000`001Ol0000J05`0001W0003o`0001@01Ol300?o1@000ol000026R4000<J00000`001Ol0
000J05/0001X0003o`0001@000Co003o0P001?l0ool50003o`0000800aXO00036P00008000?o0000
0P000aX0001H0000J0000ol0000E0003o`0000800_l00`3o000400;o1P026Qh000DJ0000o`050003
6P0005L0001Y0003o`0001D000Go0000o`020003o`0000<000?o00001`026Qd000DJ0000o`040003
6P0005L0001Z0003o`00014000Co00001?l20003o`0000<000?o00002@036Q/00QX00`3o00040003
6P0005H0001[0003o`00010000Go0000o`020004o`00o`D000?o000030026Q/000<Jo`001@000aX0
001E0000K0000ol0000@00?o1002o`H000?o00003P026QX000<Jo`001@000aX0001D0000K@000ol0
000@0003o`0000/000?o000040036QP000<J000010000aX0001D0000K@000ol0000>00;o3P000ol0
000C008J5P000olJ000500036P0005<0001^00;o3002oa0000?o00005@026Q@000?o01X01P000aX0
001B0000L002o`T000?o000040000ol0000G00<J4P001?l06QX500036P000540001b00Wo4`000ol0
000J008J40001Ol0000J00D000<J0000D00008h000?o000070026Ph000?o00000P000aX000020003
6P000500002>0003o`0001h00aX;0003o`0000<000<J00000P000aX0001?0000SP000ol0000Q008J
2P000ol0000300036P00008000<J0000CP0008h000?o00008`026PP000?o000010000aX000020003
6P0004d0002>0003o`0002D00aX50003o`0000D00QX200036P0004d0002>0003o`0002P00QX30003
o`0000L000@J000JCP0008h000?o0000:P026P8000?o00001`0011X001Y=0000SP000ol0000/00<J
2P0011X001Y<0000SP000ol0000^0003oaXJ00T000@J000JB`0008h000?o0000;P000ol000026PP0
00<J01X0B`0008h000?o0000;`001?l000036PH000<J01X0BP0008000ol300;o1P000ol0000_0003
o`0000@00QX500<JB@00084000Go0000o`020003o`0000<000?o0000;`000ol00006008J1@026TP0
001n00Go0P001?l00?l500;o<0000ol0000800<J0`000aX000160000OP001?l00?l30004o`00o`D0
00?o0000;`000ol0000;008J0P000aX000150000O`000ol0o`030004o`00o`D000?o0000<0000ol0
000<008J00<06P00A@0008000_l30004o`00o`D000?o0000<0000ol0000>00<JA@00084000?o0000
0P02o`H000?o0000<0000ol0000A00036P000480002>0003o`00030000?o0000EP0008h000?o0000
<@000ol0001E0000SP000ol0000a0003o`0005D0002>0003o`00034000?o0000E@0008h000?o0000
<@000ol0000;0003:P0000800RX4008Z0`000bX00002:SD0002>0003o`00038000?o00002P001BX0
000Z008000@Z000Z0P000bX0:P020004:P00:S@0002>0003o`00038000?o00002P001BX0000Z0080
00@Z000Z0P000bX0:P050003:P000380002>0003o`00038000?o00002P001BX0000Z008000@Z000Z
0P000bX0:P03008Z=@0008h000?o0000<P000ol0000:008Z0P0012X002X20006:P00:P0Z0P0012X0
02Xd0000SP000ol0000b0003o`0000X000<Z02X00P02:P@00RX2008Z0P02:SD0002>0003o`0003<0
00?o000060000bX0000h0000SP000ol0000c0003o`0001P000<Z0000>00008h000?o0000<`000ol0
001C0000SP000ol0000c0003o`0005<0002>0003o`0003<000?o0000D`0008h000?o0000=0000ol0
001B0000O`03o`@00_l60003o`0003@000?o0000DP0007h000Go0000o`020004o`00o`D000?o0000
=0000ol0001B0000OP001Ol0003o008000Co003o1@02ocD000?o0000DP0007h01?l30004o`00o`D0
00?o0000=0000ol0001B0000OP000ol000040004o`00o`D000?o0000=@000ol0001A0000O`000ol0
00030004o`00o`D000?o0000=@000ol0001A0000P002o`@00_l60003o`0003D000?o0000D@0008h0
00?o0000=@000ol0001A0000SP000ol0000e0003o`000540002>0003o`0003H000?o0000D00008h0
00?o0000=P000ol0001@0000SP000ol0000f0003o`000500002>0003o`0003H000?o0000D00008h0
00?o0000=P000ol0001@0000SP000ol0000g0003o`0004l0002>0003o`0003L000?o0000C`0008h0
00?o0000=`000ol0001?0000SP000ol0000g0003o`0004l0002>0003o`0003L000?o0000C`0008h0
00?o0000>0000ol0001>0000SP000ol0000h0003o`0004h0002>0003o`0003P000?o0000CP0008h0
00?o0000>0000ol0001>0000SP000ol0000i0003o`0004d0002>0003o`0003T000?o0000C@000?l0
6`000?l06`000?l06`000?l06`000?l06`000?l06`000?l06`000?l06`0006`00_l00`3oo`0C00?o
0P05o`@00_l00`3oo`060003o`0000@00ol200GoK00006d000?o0?l05@000ol000020004o`00o`D0
00?o0?l01`000ol000050003o`00008000Co003oK00006l000?o00002P04o`D000?o00000`000ol0
00070003o`0000<01Ol50003o`0000<000?o0000K00006h000?o0?l050000ol000040003o`0000D0
00?o0?l01P000ol000050003o`0000@000?o0000J`0006h00_l00`3oo`02oa0000Go0000o`030003
o`0000@00_l00`3oo`040003o`0000D000Go0000o`030003o`0006X0001b0004o`00o`h00_l30005
o`000?l05P02o`<000Go0000o`1/0000M@000ol0000=0003o`0000800olH0003o`0000800om]0000
M0000ol0002S0000LP001?l00?nT0000L`02ojD00000\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-11.891, -55.1251, 0.0837391, 
  0.866163}}],

Cell[TextData[{
  "The first root is near ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-4\)\)]],
  ", so we use ",
  Cell[BoxData[
      \(TraditionalForm\`\(-4\)\)]],
  " as the starting point for the search algorithm."
}], "Text"],

Cell[BoxData[
    \(FindRoot[x^3 - 12  x + 12 == 0, \ {x, \(-4\)}]\)], "Input"],

Cell[TextData[{
  "The second root is near ",
  Cell[BoxData[
      \(TraditionalForm\`x = 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(FindRoot[x^3 - 12  x + 12 == 0, \ {x, 1}]\)], "Input"],

Cell[TextData[{
  "The third root is near ",
  Cell[BoxData[
      \(TraditionalForm\`x = 3\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(FindRoot[x^3 - 12  x + 12 == 0, \ {x, 3}]\)], "Input"],

Cell[TextData[{
  "Find the six roots of the equation ",
  Cell[BoxData[
      \(TraditionalForm
      \`4  x\^6 - 12  x\^5 + 8  x\^4 + 3  x\^3 - 19  x\^2 + 12  x - 10 = 0
        \)]],
  "."
}], "Question"],

Cell[TextData[{
  StyleBox["NSolve", "Input"],
  " will find the six roots of the equation. Remember to use ",
  StyleBox["==", "Input"],
  " to represent equations."
}], "Text"],

Cell[BoxData[
    \(NSolve[
      4\ x\^6 - 12\ x\^5 + 8\ x\^4 + 3\ x\^3 - 19\ x\^2 + 12\ x - 10 == 0, x]
      \)], "Input"],

Cell["\<\
The result is a list of two real-valued solutions, and two \
conjugate complex pairs.\
\>", "Text"],

Cell[TextData[{
  "Find six solutions of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(sin(x)\) = 1\)]],
  "."
}], "Question"],

Cell[TextData[{
  "Here is a plot of ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(sin(x)\) - 1\)]],
  ", the roots of which are the roots of ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(sin(x)\) = 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[{x\ Sin[x] - 1}, {x, 0, 20}, PlotStyle \[Rule] GrayLevel[0.5]]; 
    \)\)], "Input"],

Cell[TextData[{
  "Note that ",
  StyleBox["NSolve", "Input"],
  " does not find the solutions of this transcendental equation."
}], "Text"],

Cell[BoxData[
    \(NSolve[x\ Sin[x] == 1, x]\)], "Input"],

Cell[TextData[{
  "We then use ",
  StyleBox["FindRoot", "Input"],
  ". Using ",
  StyleBox["Table", "Input"],
  " we can find six of the infinite number of solutions at once."
}], "Text"],

Cell[BoxData[
    \(Table[FindRoot[x\ Sin[x] == 1, {x, a}], {a, \[Pi], 6\ \[Pi], \[Pi]}]\)],
   "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerical Calculus", "Subsection"],

Cell[TextData[{
  "We perform integration using the commands ",
  StyleBox["Integrate", "Input"],
  " and ",
  StyleBox["NIntegrate", "Input"],
  ". ",
  StyleBox["Integrate", "Input"],
  " uses symbolic methods to compute the value of a definite integral."
}], "Text"],

Cell[BoxData[
    \(Integrate[Sin[x], {x, 0, \[Pi]}]\)], "Input"],

Cell[TextData[{
  StyleBox["Integrate", "Input"],
  " also works on functions with more than one variable. Here is the volume \
under a surface, over a square region."
}], "Text"],

Cell[BoxData[
    \(Integrate[Sin[x] + Sin[y], {x, 0, \[Pi]}, {y, 0, \[Pi]}]\)], "Input"],

Cell[TextData[{
  "Here is a special input form for the same expression. We enter the \
integral sign \[Integral] by typing \[EscapeKey]int\[EscapeKey] or ",
  Cell[TextData["\\\[InvisibleSpace][Integral]"], "Input"],
  ", and we must use the special differential \[DifferentialD], entered by \
typing \[EscapeKey]dd\[EscapeKey] or ",
  Cell[TextData["\\\[InvisibleSpace][DifferentialD]"], "Input"],
  ", and not an ordinary keyboard ",
  StyleBox["d",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\_0
        \%\[Pi]\(\[Integral]\_0\%\[Pi]\((Sin[x] + Sin[y])\) 
          \[DifferentialD]x\ \[DifferentialD]y\)\)], "Input"],

Cell["\<\
Here is a more complicated integral, taken over a nonrectangular \
region.\
\>", "Text"],

Cell[BoxData[
    \(\[Integral]\_0
        \%\(2  \[Pi]\)\(\[Integral]\_0\%x Sin[x\ y] \[DifferentialD]y\ 
          \[DifferentialD]x\)\)], "Input"],

Cell[TextData[{
  "When calculating definite integrals involving symbolic parameters, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may return an answer that depends on the value of the parameters."
}], "Text"],

Cell[BoxData[
    \(Integrate[x\^n, {x, 0, 1}]\)], "Input"],

Cell[TextData[{
  StyleBox["NIntegrate", "Input"],
  " uses numerical methods to approximate the area under the specified curve \
in the specified domain. This method produces results in many cases where the \
symbolic method fails."
}], "Text"],

Cell["\<\
We cannot get an exact value for the following integral using \
symbolic methods.\
\>", "Text"],

Cell[BoxData[
    \(Integrate[E\^Sin[x], {x, \(-2\), 2}]\)], "Input"],

Cell[TextData[{
  "We can get an approximation using ",
  StyleBox["N", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  StyleBox["NIntegrate", "Input"],
  " uses numerical methods from the beginning, and returns the same result."
}], "Text"],

Cell[BoxData[
    \(NIntegrate[\ E\^Sin[x], \ {x, \(-2\), 2}]\)], "Input"],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does all numerical calculus calculations with machine-precision numbers, \
but most numerical functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allow changes to this through the ",
  StyleBox["WorkingPrecision", "Input"],
  " option. ",
  StyleBox["WorkingPrecision->", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  " causes all internal computations to be done to at most ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-digit precision."
}], "Text"],

Cell["\<\
We can see the effect of this option by looking at an example of \
numerical integration. Here is an example performed with machine precision.\
\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[1\/x, {x, 1, 2}]\)], "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell["\<\
Now we look at the same example with a working precision of 50 \
digits. Note that we are setting the precision to be used while working this \
problem, and not the desired precision of the result.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[1/x, {x, 1, 2}, WorkingPrecision -> 50]\)], "Input"],

Cell["Precision[%]", "Input"],

Cell[TextData[{
  StyleBox["NDSolve", "Input"],
  " finds numerical solutions to systems of differential equations. Here we \
solve a system of differential equations, giving the list of solutions the \
name ",
  StyleBox["sol", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(sol = 
      NDSolve[{\(x'\)[t] == \(-y[t]\) - x[t]\^2, \(y'\)[t] == 2\ x[t] - y[t], 
          x[0] == y[0] == 1}, {x, y}, {t, 0, 9}]\)], "Input"],

Cell[TextData[{
  "The result of this calculation is a set of two interpolating functions, \
essentially large sets of points that we treat as continuous functions. We \
then look at the solution set graphically, in two different ways. For the \
first plot, we plot ",
  Cell[BoxData[
      \(TraditionalForm\`x(t)\)]],
  " (dashed line) and ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " (gray line) on the same set of axes. (The form ",
  StyleBox["/.", "Input"],
  " is explained in the next chapter.)"
}], "Text"],

Cell[BoxData[
    \(\(Plot[{x[t] /. sol, y[t] /. sol}, {t, 0, 9}, 
      PlotStyle -> {Dashing[{0.015}], GrayLevel[0.5]}]; \)\)], "Input"],

Cell[TextData[{
  "For the second plot, we plot ",
  Cell[BoxData[
      \(TraditionalForm\`x(t)\)]],
  " against ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[Evaluate[{x[t], y[t]} /. sol], {t, 0, 9}, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  "Here is the first interpolating function, corresponding to ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(x /. sol[\([1, 1]\)]\)], "Input"],

Cell["\<\
To evaluate the interpolating function at a particular point, we \
append an argument inside square brackets. Here is the value of the \
interpolating function at 6.28.\
\>", "Text"],

Cell[BoxData[
    \(%[6.28]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can also solve some partial differential equations numerically, given \
sufficient initial conditions and ranges for all variables appearing in the \
system. (The form ",
  Cell["Derivative[0,1][x][t,0]", "Input"],
  " means the derivative of the function ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", taking the first derivative with respect to the second variable of ",
  StyleBox["x, ",
    FontSlant->"Italic"],
  "and no derivative with respect to the first variable, evaluating the \
derivative at (",
  StyleBox["t",
    FontSlant->"Italic"],
  ", 0); in traditional notation, it represents ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", 
            TagBox[\((0, 1)\),
              Derivative],
            MultilineFunction->None], \((t, 0)\)}], TraditionalForm]]],
  ".) The result of ",
  StyleBox["NDSolve", "Input"],
  " in this case is a single two-dimensional interpolating function."
}], "Text"],

Cell[BoxData[
    \(NDSolve[{D[x[t, u], {u, 2}] == D[x[t, u], {t, 2}], 
        x[t, 0] == Exp[\(-t^2\)], \(\(Derivative[0, 1]\)[x]\)[t, 0] == 0}, 
      x, {t, \(-5\), 5}, {u, \(-2\), 2}]\)], "Input"],

Cell["Here is a graph of the solution.", "Text"],

Cell[BoxData[
    \(\(Plot3D[Evaluate[x[t, u] /. First[%]], {t, \(-5\), 5}, {u, \(-2\), 2}, 
      PlotPoints -> 30]; \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["NSum", "Input"],
  ", ",
  StyleBox["NProduct", "Input"],
  ", ",
  StyleBox["Derivative", "Input"],
  ", ",
  StyleBox["PrincipalValue", "Input"],
  ", ",
  StyleBox["Assumptions", "Input"],
  ", ",
  StyleBox["GenerateConditions", "Input"],
  ", ",
  StyleBox["NumericalMath`ListIntegrate`", "Input"],
  ", ",
  StyleBox["Method", "Input"],
  ", ",
  StyleBox["Trapezoidal", "Input"],
  ", ",
  StyleBox["Oscillatory", "Input"],
  ", ",
  StyleBox["MonteCarlo", "Input"],
  "  "
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Numerical Calculus", "Subsubsection"],

Cell[TextData[{
  "The area under the curve ",
  Cell[BoxData[
      \(TraditionalForm\`4\/\(1 + x\^2\)\)]],
  ", between 0 and 1, is exactly \[Pi]. Use ",
  StyleBox["NIntegrate", "Input"],
  " to generate an approximation of \[Pi] to approximately 20, 30, and 40 \
places of precision. (Hint: use the ",
  StyleBox["WorkingPrecision", "Input"],
  " option, recalling that the precision of the result is usually 10 places \
less than the ",
  StyleBox["WorkingPrecision", "Input"],
  ".)"
}], "Question"],

Cell[TextData[{
  "Here is a graph that represents the area we wish to compute. (The graph \
uses the add-on package ",
  StyleBox["Graphics`FilledPlot`", "Input"],
  " to fill in the areas under the curve.)"
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`FilledPlot`\>"]; \n
    FilledPlot[{4/\((1 + x^2)\), \ If[0 < x < 1, 4/\((1 + x^2)\), 0]}, {x, 
        \(-2\), 2}, \n\tFills -> {GrayLevel[0.95], GrayLevel[0.55]}, \n\t
      Epilog -> 
        Text[StyleForm["\<\[Pi]\>", FontSize -> 18, 
            FontWeight -> "\<Bold\>"], {0.5, 1.75}]]; \)], "Input"],

Cell["\<\
When we calculate the integral with a working precision of 30 \
digits, the result has around 20 significant digits.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[4\/\(1 + x\^2\), {x, 0, 1}, WorkingPrecision \[Rule] 30]\)], 
  "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell["\<\
Using 40 digits internally results in a value with around 30 \
significant digits.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[4\/\(1 + x\^2\), {x, 0, 1}, WorkingPrecision \[Rule] 40]\)], 
  "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell["Using 50 digits returns an answer with around 40 digits.", "Text"],

Cell[BoxData[
    \(NIntegrate[4\/\(1 + x\^2\), {x, 0, 1}, WorkingPrecision \[Rule] 50]\)], 
  "Input"],

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[TextData[
"Aside from rounding in the last digit, the answers are the same as a direct \
approximation to \[Pi]."], "Text"],

Cell[BoxData[
    \(N[\[Pi], 45]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Numerical Functions", "Subsection"],

Cell[CellGroupData[{

Cell["Random Numbers", "Subsubsection"],

Cell[TextData[{
  "There are many more numerical functions built into the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel or defined in the standard add-on packages that cover a large \
number of specialized fields."
}], "Text"],

Cell[TextData[{
  "A function useful for performing simulations is ",
  StyleBox["Random", "Input"],
  ", which generates pseudorandom numbers. ",
  StyleBox["Random[]", "Input"],
  " gives a uniformly distributed pseudorandom real number in the range 0 to \
1. ",
  Cell[TextData[{
    "Random[",
    StyleBox["type",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"],
    ",",
    StyleBox["range",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"],
    "]"
  }], "Input"],
  " gives a pseudorandom number of the specified type in the specified range. \
Possible types are ",
  StyleBox["Integer", "Input"],
  ", ",
  StyleBox["Real", "Input"],
  ", and ",
  StyleBox["Complex", "Input"],
  ". The default range is from 0 to 1, and we can specify the range {",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  "} explicitly."
}], "Text"],

Cell["Here is a random number between 0 and 1.", "Text"],

Cell[BoxData[
    \(Random[\ ]\)], "Input"],

Cell["Here is a table of random integers between 1 and 10.", "Text"],

Cell[BoxData[
    \(Table[Random[Integer, \ {1, 10}], {15}]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["SeedRandom", "Input"],
  ", ",
  StyleBox["$RandomState", "Input"],
  ", ",
  StyleBox["Statistics`ContinuousDistributions`", "Input"],
  ", ",
  StyleBox["Statistics`DiscreteDistributions`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Products and Sums", "Subsubsection"],

Cell[TextData[{
  "Products and sums are also defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Product[", "Input"],
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox[",", "Input"],
  " ",
  StyleBox["di",
    FontSlant->"Italic"],
  StyleBox["}]", "Input"],
  " evaluates the product of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with ",
  StyleBox["i",
    FontSlant->"Italic"],
  " running from ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  " in steps of ",
  StyleBox["di",
    FontSlant->"Italic"],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  " and ",
  StyleBox["di",
    FontSlant->"Italic"],
  " are omitted they are assumed to be 0 and 1, respectively. Multiple \
products are entered in the form ",
  StyleBox["Product[", "Input"],
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`i\_min\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`i\_max\)]],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["j",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`j\_min\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`j\_max\)]],
  StyleBox["},", "Input"],
  " \[Ellipsis]",
  StyleBox["]", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Product", "Input"],
  " computes an exact result."
}], "Text"],

Cell["Product[i, {i, 1, 10}]", "Input"],

Cell["We can enter products in the following two-dimensional form.", "Text"],

Cell[BoxData[
    \(\[Product]\+\(i = 1\)\%10 i\)], "Input"],

Cell[TextData[{
  StyleBox["NProduct", "Input"],
  " uses numerical methods to find an approximate product."
}], "Text"],

Cell[BoxData[
    \(NProduct[i, \ {i, 1, 10}]\)], "Input"],

Cell["The values computed are equal to 10 factorial.", "Text"],

Cell[BoxData[
    \(\(10!\)\)], "Input"],

Cell[TextData[{
  StyleBox["Sum", "Input"],
  " takes the same form as ",
  StyleBox["Product", "Input"],
  ". ",
  StyleBox["Sum", "Input"],
  " computes exact values, and ",
  StyleBox["NSum", "Input"],
  " computes approximate values."
}], "Text"],

Cell[BoxData[
    \({Sum[n\^2, \ {n, 2, 30}], \ NSum[n\^2, {n, 2, 30}]}\)], "Input"],

Cell[TextData[{
  "Here is the two-dimensional input form for ",
  StyleBox["Sum", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\[Sum]\+\(n = 2\)\%30 n\^2\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["NumericalMath`NLimit`", "Input"],
  ", ",
  StyleBox["NumericalMath`NSeries`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Optimization", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has several built-in optimization functions. ",
  StyleBox["FindMinimum", "Input"],
  " finds a local minimum for a function, given a starting value for the \
search. Here is a graph of the gamma function."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Gamma[x], {x, 0, 4}]; \)\)], "Input"],

Cell[TextData[{
  "The following command finds a local minimum for the gamma function. The \
result states that the local minimum is 0.885603, which occurs when ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is 1.46163."
}], "Text"],

Cell[BoxData[
    \(FindMinimum[Gamma[x], {x, 1.5}]\)], "Input"],

Cell[TextData[{
  "Here is a function with several local minima. The starting value we give \
to ",
  StyleBox["FindMinimum", "Input"],
  " can affect the local minimum that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns."
}], "Text"],

Cell[BoxData[
    \(\(Plot[\ Sin[x] + x/5, \ {x, \ \(-6\), 6}]; \)\)], "Input"],

Cell[TextData[{
  "Here is the local minimum of ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x) + x\/5\)]],
  " near ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-2\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(FindMinimum[Sin[x] + x\/5, {x, \(-2\)}]\)], "Input"],

Cell[TextData[{
  "Starting the search near ",
  Cell[BoxData[
      \(TraditionalForm\`x = 4\)]],
  " gives a different local minimum."
}], "Text"],

Cell[BoxData[
    \(FindMinimum[Sin[x] + x\/5, {x, 4}]\)], "Input"],

Cell[TextData[{
  "We interpret the result as telling us that the local minimum is \
\[Dash]0.0775897, which occurs when ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is 4.51103."
}], "Text"],

Cell[TextData[{
  StyleBox["ConstrainedMin[", "Input"],
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["inequalities",
    FontSlant->"Italic"],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["}]", "Input"],
  " finds the global minimum of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " in the domain specified by the linear constraints ",
  StyleBox["inequalities",
    FontSlant->"Italic"],
  ". The variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", \[Ellipsis] are all assumed to be nonnegative. Here is the minimum of ",
  Cell[BoxData[
      \(TraditionalForm\`5  x - 3  y\)]],
  ", constrained by ",
  Cell[BoxData[
      \(TraditionalForm\`x + 2  y < 4\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x + 3  y > 6\)]],
  ". The constraints ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y \[GreaterEqual] 0\)]],
  " are implied."
}], "Text"],

Cell[BoxData[
    \(ConstrainedMin[5  x - 3  y, \ {x + 2  y < 4, x + 3  y > 6}, \ {x, \ y}]
      \)], "Input"],

Cell[TextData[{
  "The result states that the constrained minimum is ",
  Cell[BoxData[
      \(TraditionalForm\`\(-6\)\)]],
  ", which occurs when ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is 0 and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " is 2."
}], "Text"],

Cell[TextData[{
  StyleBox["ConstrainedMax", "Input"],
  " works similarly."
}], "Text"],

Cell[BoxData[
    \(ConstrainedMax[12  x + 10  y, {x + y < 4, 5  x + 3  y < 15}, {x, y}]\)],
   "Input"],

Cell["\<\
Again, the Help Browser provides an easy way to explore the many \
different categories of functions and algorithms.\
\>", "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["LinearProgramming", "Input"],
  ", ",
  StyleBox["Fourier", "Input"],
  ", ",
  StyleBox["InverseFourier", "Input"],
  ", ",
  StyleBox["PrimeQ", "Input"],
  ", ",
  StyleBox["FactorInteger", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Other Numerical Functions", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input",
    FontFamily->"Courier"],
  " to make a list of the squares of the first 25 integers."
}], "Question"],

Cell[BoxData[
    \(Table[i\^2, {i, 1, 25}]\)], "Input"],

Cell[TextData[{
  "What is the product of these integers? (Hint: do not use ",
  StyleBox["Table", "Input"],
  " or the result of the last exercise.)"
}], "Question"],

Cell[BoxData[
    \(Product[i^2, {i, 1, 25}]\)], "Input"],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input",
    FontFamily->"Courier"],
  " to create a list of fifteen random integers between 1 and 10."
}], "Question"],

Cell[BoxData[
    \(numbers = Table[Random[Integer, {1, 10}], {15}]\)], "Input"],

Cell[TextData[{
  "The commands ",
  StyleBox["Max", "Input"],
  " and ",
  StyleBox["Min", "Input"],
  " return the greatest and least elements of  a list. What are the greatest \
and least numbers in the list generated above?"
}], "Question"],

Cell[BoxData[
    \(Max[numbers]\)], "Input"],

Cell[BoxData[
    \(Min[numbers]\)], "Input"],

Cell[TextData[{
  "The sum of the numbers 1, 2, \[Ellipsis], ",
  StyleBox["n",
    FontSlant->"Italic"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(i = 1\)\%n i\)]],
  ") is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\(1\/2\) \(n(n + 1)\)\)]],
  ". Use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to verify that this is true for ",
  StyleBox["n",
    FontSlant->"Italic"],
  " = 50, 100, and 200. (Compare the results of each method.)"
}], "Question"],

Cell[TextData[{
  "Here we verify the formula when ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is 50."
}], "Text"],

Cell[BoxData[
    \(Sum[i, {i, 1, 50}]\)], "Input"],

Cell[BoxData[
    \(1\/2\[Times]50\[Times]\((50 + 1)\)\)], "Input"],

Cell[TextData[{
  "Here we verify the formula when ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is 100, using the two-dimensional input form for ",
  StyleBox["Sum", "Input"],
  ", and directly testing if the two results are equal."
}], "Text"],

Cell[BoxData[
    \(\[Sum]\+\(i = 1\)\%100 i == \(1\/2\) \((100)\) \((101)\)\)], "Input"],

Cell[TextData[{
  "Here we repeat the calculation for ",
  Cell[BoxData[
      \(TraditionalForm\`n = 200\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\[Sum]\+\(i = 1\)\%200 i == \(1\/2\) \((200)\) \((201)\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " verifies the general formula when we use a variable name for the upper \
limit of the summation."
}], "Text"],

Cell[BoxData[
    \(\[Sum]\+\(i = 1\)\%n i\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolics", "Section"],

Cell[CellGroupData[{

Cell["Algebra", "Subsection"],

Cell[CellGroupData[{

Cell["Entering Symbolic Expressions", "Subsubsection"],

Cell[TextData[{
  "We enter symbolic expressions such as polynomials the same way we enter \
numeric expressions. To enter the expression ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + a\ x\^2 + b\ x + 1\)]],
  ", for example, we type the following. We use a caret ",
  StyleBox["^", "Input"],
  " or a superscript to represent a power, and use a space or an asterisk to \
represent multiplication."
}], "Text"],

Cell[BoxData[
    \(x\^3\  + \ a\ x^2 + b*x + 1\)], "Input"],

Cell[TextData[{
  "It is very important to remember to type a space or asterisk for \
multiplication. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interprets ",
  Cell["b x", "Input"],
  " and ",
  StyleBox["b*x", "Input"],
  " as ",
  StyleBox["b",
    FontSlant->"Italic"],
  " times ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", but interprets ",
  StyleBox["bx", "Input"],
  " (with no space between) as a variable with the two-letter name ",
  StyleBox["bx",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "It is also important to group exponents, numerators, and denominators with \
parentheses: ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the grouping rules and order of operations of standard arithmetic, \
so the following two expressions are interpreted differently."
}], "Text"],

Cell[BoxData[
    \({E^2  \[Pi], \ E^\((2  \[Pi])\)}\)], "Input"],

Cell["The following two expressions are also different.", "Text"],

Cell[BoxData[
    \({1/2  \[Pi], \ 1/\((2  \[Pi])\)}\)], "Input"],

Cell["\<\
Variables, functions, and other expressions can contain special \
characters, such as Greek and script letters. The following is a valid \
symbolic expression.\
\>", "Text"],

Cell[BoxData[
    \(\[Alpha]\ \[Lambda]\^2 + \[Beta]\ \[Lambda] + \[Gamma]\)], "Input"],

Cell["\<\
We can also use two-dimensional forms in symbolic expressions.\
\>",
   "Text"],

Cell[BoxData[
    \(x\&_ = \(1\/3\) \((x\_1 + x\_2 + x\_3)\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Defining Variables", "Subsubsection"],

Cell[TextData[{
  "We define variables in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by typing ",
  StyleBox["name",
    FontSlant->"Italic"],
  " ",
  StyleBox["=", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  ", using a single equal sign. Variable names can be as long as desired, and \
can be any combination of letters (both upper- and lower-case) and numbers, \
with the restriction that a variable name cannot begin with a number."
}], "Text"],

Cell[TextData[{
  "To set the variable ",
  StyleBox["newvar", "Input"],
  " equal to 15, we enter the following."
}], "Text"],

Cell[BoxData[
    \(newvar = 15\)], "Input"],

Cell[TextData[{
  "After we make the assignment, every time ",
  StyleBox["newvar", "Input"],
  " is used it is replaced with its value."
}], "Text"],

Cell[BoxData[
    \(newvar\^2 - 2\^newvar\)], "Input"],

Cell["\<\
Variable names are case sensitive, so the following names are all \
different.\
\>", "Text"],

Cell[BoxData[
    \(newvar + newVAR + NewVar + NeWvAr\)], "Input"],

Cell[TextData[{
  "Variables can have symbolic values, so the following is a valid \
assignment. (We keep ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from printing the value of a variable when it is assigned by ending the \
line with a semicolon.)"
}], "Text"],

Cell[BoxData[
    \(\(zzz = xxx\^2 + yyy\^2; \)\)], "Input"],

Cell[TextData[{
  "The right-hand side of a variable assignment can be a function or program; \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will set the value of the variable equal to the result of the right-hand \
side. Here we set the value of ",
  StyleBox["solutionset", "Input"],
  " to be the result of solving an equation."
}], "Text"],

Cell[BoxData[
    \(solutionset = Solve[x^2 == 2\ x + 1, x]\)], "Input"],

Cell[TextData[{
  "We can even set a variable equal to a function name. For instance, we can \
set the variable ",
  StyleBox["int", "Input"],
  " equal to the built-in ",
  StyleBox["Integrate", "Input"],
  " function."
}], "Text"],

Cell[BoxData[
    \(\(int = Integrate; \)\)], "Input"],

Cell[TextData[{
  "We can now use ",
  StyleBox["int", "Input"],
  " where we would use ",
  StyleBox["Integrate", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(int[Tan[x], x]\)], "Input"],

Cell[TextData[{
  "It is important to realize that variable assignments are permanent. The \
values of ",
  StyleBox["newvar", "Input"],
  ", ",
  StyleBox["zzz", "Input"],
  ", ",
  StyleBox["solutionset", "Input"],
  ", and ",
  StyleBox["int", "Input"],
  " will remain in memory until we quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", or until we use the ",
  StyleBox["Clear", "Input"],
  " command to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to forget the value of the variable. Here is another calculation that \
uses the value of ",
  StyleBox["newvar", "Input"],
  " defined above."
}], "Text"],

Cell[BoxData[
    \(newvar\^2 + newvar - 200\)], "Input"],

Cell[TextData[{
  "The ",
  StyleBox["Clear", "Input"],
  " function erases the value of ",
  StyleBox["newvar", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[newvar]\)], "Input"],

Cell[TextData[{
  "We see that ",
  StyleBox["newvar", "Input"],
  " no longer has a value."
}], "Text"],

Cell[BoxData[
    \(newvar\^2 + newvar - 200\)], "Input"],

Cell["Here we clear the other variables used in this section.", "Text"],

Cell[BoxData[
    \(Clear[zzz, solutionset, int]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Defining Functions", "Subsubsection"],

Cell[TextData[{
  "Defining functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is somewhat different from writing functions by hand. The reason is that \
standard mathematical notation is ambiguous, while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " requires a precise definition in order to understand a question. For \
example, it is unclear in traditional notation whether ",
  Cell[BoxData[
      \(TraditionalForm\`q(1 - p)\)]],
  " means the function ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`1 - p\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " times the quantity ",
  Cell[BoxData[
      \(TraditionalForm\`1 - p\)]],
  "."
}], "Text"],

Cell[TextData[{
  "To avoid this ambiguity, in ",
  StyleBox["StandardForm", "Input"],
  " and ",
  StyleBox["InputForm", "Input"],
  " we type ",
  StyleBox["q[1-p]", "Input"],
  " to denote the function ",
  StyleBox["q",
    FontSlant->"Italic"],
  " evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`1 - p\)]],
  ", and ",
  StyleBox["q(1-p)", "Input"],
  " to denote ",
  StyleBox["q",
    FontSlant->"Italic"],
  " times ",
  Cell[BoxData[
      \(TraditionalForm\`1 - p\)]],
  "."
}], "Text"],

Cell[TextData[{
  "To define a function, say areaCircle(",
  StyleBox["r",
    FontSlant->"Italic"],
  "), we must tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that we wish areaCircle to be applicable to ",
  StyleBox["any",
    FontSlant->"Italic"],
  " argument ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", and not just to the literal symbol ",
  StyleBox["r",
    FontSlant->"Italic"],
  ". In order to do this, we set up a ",
  StyleBox["pattern",
    FontSlant->"Italic"],
  " on the left side of the function definition. A pattern is a blank that \
can match any single argument given to a function. For example, to define ",
  Cell[BoxData[
      \(TraditionalForm\`areaCircle(r) = \[Pi]\ r\^2\)]],
  ", we type the following. (Note the use of ",
  StyleBox[":=", "Input"],
  " to separate the left and right sides of a function definition.)"
}], "Text"],

Cell[BoxData[
    \(areaCircle[r_] := \[Pi]\ r\^2\)], "Input"],

Cell[TextData[{
  "There are several things to keep in mind. The name of the function is ",
  StyleBox["areaCircle", "Input"],
  ", and because it is a function, its argument goes inside square brackets. \
The ",
  StyleBox["r_", "Input"],
  " term inside the square brackets is the pattern for the argument to ",
  StyleBox["areaCircle", "Input"],
  ", which we read as \[OpenCurlyDoubleQuote]any ",
  StyleBox["r",
    FontSlant->"Italic"],
  "\[CloseCurlyDoubleQuote]; the underscore ",
  StyleBox["_", "Input"],
  " is a blank that matches any single argument, and the ",
  StyleBox["r", "Input"],
  " next to it is the name of the pattern, which is used to refer to the \
argument on the right-hand side of the function definition."
}], "Text"],

Cell["\<\
We use the function after defining it by entering a line such as \
the following.\
\>", "Text"],

Cell[BoxData[
    \(areaCircle[10]\)], "Input"],

Cell[TextData[{
  "When we evaluate ",
  StyleBox["areaCircle[10]", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks in its database to see if it has a definition for ",
  StyleBox["areaCircle", "Input"],
  " called with one argument. Because we used the pattern ",
  StyleBox["r_", "Input"],
  " in the definition of ",
  StyleBox["areaCircle", "Input"],
  ", and ",
  StyleBox["r_", "Input"],
  " is a pattern that matches any single argument, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puts the ",
  StyleBox["10", "Input"],
  " into the blank called ",
  StyleBox["r", "Input"],
  ", then substitutes ",
  StyleBox["10", "Input"],
  " everywhere ",
  StyleBox["r", "Input"],
  " appears on the right-hand side of the definition."
}], "Text"],

Cell[TextData[{
  "When we define a function, the name we give to the pattern is unimportant, \
except that we must use the same name on the right side of the definition. \
For instance, we could have defined the function ",
  StyleBox["areaCircle", "Input"],
  " by entering ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox["areaCircle",
            "Input"], 
          StyleBox["[",
            "Input"], 
          StyleBox[
            RowBox[{
              StyleBox["x",
                "Input",
                Editable->True], 
              StyleBox["_",
                "Input"]}]], 
          StyleBox["]",
            "Input"]}], 
        StyleBox[":=",
          "Input"], 
        RowBox[{
          StyleBox["\[Pi]",
            "Input",
            Editable->True], 
          StyleBox[" ",
            "Input",
            Editable->True], 
          StyleBox[
            SuperscriptBox[
              StyleBox["x",
                Editable->True], "2"],
            "Input"]}]}]]],
  "."
}], "Text"],

Cell[TextData[{
  "Arguments we give to ",
  StyleBox["areaCircle", "Input"],
  " do not have to be numbers. When we type ",
  Cell[BoxData[
      RowBox[{
        StyleBox["areaCircle",
          "Input"], 
        StyleBox["[",
          "Input"], 
        StyleBox[\(19\ c\),
          "Input",
          Editable->True], 
        StyleBox["]",
          "Input"]}]]],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " matches ",
  Cell[BoxData[
      \(19  c\)], "Input"],
  " with the pattern ",
  Cell["r_", "Input"],
  ", and again substitutes ",
  Cell[BoxData[
      \(19  c\)], "Input"],
  " everywhere ",
  StyleBox["r", "Input"],
  " appears on the right side of the definition."
}], "Text"],

Cell[BoxData[
    \(areaCircle[19\ c]\)], "Input"],

Cell[TextData[{
  "Here is a more complicated use of ",
  StyleBox["areaCircle", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(1\/2\) \((areaCircle[s/2] + areaCircle[s])\)\)], "Input"],

Cell[TextData[{
  "Once we define a function, we use it just as we use a built-in function. \
Here is a plot of",
  StyleBox[" ",
    FontSize->11],
  StyleBox["areaCircle", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[areaCircle[t], {t, 0, 2}]; \)\)], "Input"],

Cell[TextData[{
  "Here is the derivative of ",
  StyleBox["areaCircle", "Input"],
  " with respect to ",
  StyleBox["z", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(D[areaCircle[z], z]\)], "Input"],

Cell[TextData[{
  "Similarly, we can define a function ",
  Cell[BoxData[
      \(TraditionalForm\`volumeCylinder(r, h) = \[Pi]\ \(r\^2\) h\)]],
  " by entering the following."
}], "Text"],

Cell[BoxData[
    \(volumeCylinder[r_, h_] := \[Pi]\ \(r\^2\) h\)], "Input"],

Cell[TextData[{
  "We read the left side of the definition as \
\[OpenCurlyDoubleQuote]volumeCylinder of any ",
  StyleBox["r",
    FontSlant->"Italic"],
  " and any ",
  StyleBox["h",
    FontSlant->"Italic"],
  "\[CloseCurlyDoubleQuote]. Here is an application of the function."
}], "Text"],

Cell[BoxData[
    \(volumeCylinder[2, 10]\)], "Input"],

Cell[TextData[{
  "Like variables, function definitions are permanent; the definitions of the \
functions ",
  StyleBox["areaCircle", "Input"],
  " and ",
  StyleBox["volumeCylinder", "Input"],
  " will remain in memory until we explicitly clear the definitions using ",
  StyleBox["Clear", "Input"],
  ", or we quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[areaCircle, volumeCylinder]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating Polynomials", "Subsubsection"],

Cell[TextData[{
  "Given a symbolic polynomial, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not carry out much manipulation without being told to do so; that \
is, it makes few assumptions about the form in which we want a polynomial."
}], "Text"],

Cell[TextData[{
  "One of the operations ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " carries out automatically is putting expressions into a standard order. \
In ",
  StyleBox["StandardForm", "Input"],
  " and ",
  StyleBox["OutputForm", "Input"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puts constants in front, and arranges terms in order of increasing \
powers."
}], "Text"],

Cell[BoxData[
    \(2\ x + x^2 + 1\)], "Input"],

Cell[TextData[{
  "In ",
  StyleBox["TraditionalForm", "Input"],
  " the reverse order is used."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm[2\ x + x^2 + 1]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically adds and subtracts like terms."
}], "Text"],

Cell[BoxData[
    \(\((1 + 2\ x)\) + \((4\ x + 3)\)\)], "Input"],

Cell[BoxData[
    \(3\^\((2  x - x)\)\)], "Input"],

Cell[TextData[{
  "However, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not automatically expand, factor, or greatly simplify a polynomial."
}], "Text"],

Cell[BoxData[
    \(\((x + 3\ y - 5\ z)\)\^9\)], "Input"],

Cell[TextData[{
  "To have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expand an expression, we explicitly tell it to do so. In this case, we \
apply the function ",
  StyleBox["Expand", "Input"],
  " to the previous output (which we refer to as ",
  StyleBox["%", "Input"],
  ")."
}], "Text"],

Cell["Expand[%]", "Input"],

Cell[TextData[{
  "Similarly, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not automatically simplify an expression. The most commonly used \
simplification command is ",
  StyleBox["Simplify", "Input"],
  ", which tries a long list of transformation rules, returning the smallest \
equivalent expression it finds, in this case the original expression."
}], "Text"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[BoxData[
    \(Simplify[\((1 - x\^3)\)\ \((1 + x\^3 + x\^6)\)]\)], "Input"],

Cell[TextData[{
  "One area where it is important to recognize that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not automatically simplify expressions is equation solving. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s ",
  StyleBox["==", "Input"],
  " construct, for instance, returns ",
  StyleBox["True", "Input"],
  " only if the left and right sides of the equation are identical in ",
  StyleBox["form",
    FontSlant->"Italic"],
  ", and not necessarily identical in a mathematical sense."
}], "Text"],

Cell[TextData[{
  "In the following example, the left and right sides of the equation are \
mathematically equal, but not equal in form, so ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the equation unevaluated."
}], "Text"],

Cell[BoxData[
    \(\((b + x)\)\ \((b - x)\) == b\^2 - x\^2\)], "Input"],

Cell[TextData[{
  "One way to get ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to recognize the equality is to use the ",
  StyleBox["Simplify", "Input"],
  " command to transform each side of the equation into an equivalent form."
}], "Text"],

Cell[BoxData[
    \(Simplify[\((b + x)\)\ \((b - x)\) == b\^2 - x\^2]\)], "Input"],

Cell[TextData[{
  "There are several ways to rearrange polynomials generated in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", or to pick out particular features or specific terms of a polynomial."
}], "Text"],

Cell[TextData[{
  "Using ",
  StyleBox["Collect", "Input"],
  " on the expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`\((a + b + c)\)\^5\)]],
  ", we can arrange terms with respect to the variable ",
  StyleBox["c",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Collect[Expand[\((a + b + c)\)\^5], c]\)], "Input"],

Cell[TextData[{
  "Using ",
  StyleBox["Coefficient", "Input"],
  ", we can select the coefficient of any expression in a polynomial."
}], "Text"],

Cell[BoxData[
    \(Coefficient[Expand[\((a + b + c)\)\^5], a\^3]\)], "Input"],

Cell[TextData[{
  StyleBox["Factor", "Input"],
  " represents an expression as a product of factors."
}], "Text"],

Cell[BoxData[
    \(Factor[x^9 + 1]\)], "Input"],

Cell["\<\
Here we find the names of all the variables in an expression.\
\>", 
  "Text"],

Cell[BoxData[
    \(Variables[Expand[\((a + b + c)\)^5]]\)], "Input"],

Cell["This is the greatest exponent in the polynomial.", "Text"],

Cell[BoxData[
    \(Exponent[\((1 + x)\)\ \((1 - x - x\^2)\)\ \((1 - x)\), x]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["PolynomialMod", "Input"],
  ", ",
  StyleBox["PolynomialQuotient", "Input"],
  ", ",
  StyleBox["PolynomialRemainder", "Input"],
  ", ",
  StyleBox["PolynomialGCD", "Input"],
  ", ",
  StyleBox["PolynomialLCM", "Input"],
  ", ",
  StyleBox["FactorList", "Input"],
  ", ",
  StyleBox["CoefficientList", "Input"],
  ", ",
  StyleBox["InterpolatingPolynomial", "Input"],
  ", ",
  StyleBox["Fit", "Input"],
  ", ",
  StyleBox["Cyclotomic", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating Rational Expressions", "Subsubsection"],

Cell["\<\
There are several commands that work exclusively on rational \
expressions and formulas.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Apart", "Input"],
  " performs partial-fraction decomposition of a rational expression."
}], "Text"],

Cell[BoxData[
    \(Apart[1/\((1 - x^5)\)]\)], "Input"],

Cell[TextData[{
  StyleBox["Together", "Input"],
  " does the opposite: it puts two or more rational expressions over a common \
denominator, without simplifying."
}], "Text"],

Cell[BoxData[
    \(Together[%]\)], "Input"],

Cell["\<\
We can choose what part of a rational expression to expand, such as \
the numerator or denominator.\
\>", "Text"],

Cell[BoxData[
    \(ExpandDenominator[%]\)], "Input"],

Cell[TextData[{
  StyleBox["Cancel", "Input"],
  " divides out common factors."
}], "Text"],

Cell[BoxData[
    \(Cancel[\(x\^5 - 1\)\/\(x - 1\)]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Numerator", "Input"],
  ", ",
  StyleBox["Denominator", "Input"],
  ", ",
  StyleBox["ExpandAll", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating Symbolic Functions", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " carries out basic simplifications and computes special values of \
mathematical functions."
}], "Text"],

Cell[BoxData[
    \(\((Csc[x] Tan[w])\)/\((Cot[x]\ Sec[w])\)\)], "Input"],

Cell[BoxData[
    \(BesselY[5/2, \[Zeta]]\)], "Input"],

Cell[TextData[{
  "In most cases, however, we must explicitly tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to manipulate a symbolic expression. ",
  StyleBox["TrigExpand", "Input"],
  " expands trigonometric expressions."
}], "Text"],

Cell[BoxData[
    \(TrigExpand[Sin[\[Alpha] + \[Beta] + \[Gamma]]]\)], "Input"],

Cell[TextData[{
  StyleBox["TrigToExp", "Input"],
  " converts trigonometric expressions into exponential form."
}], "Text"],

Cell[BoxData[
    \(TrigToExp[\ Cos[z] + I\ Sin[z]]\)], "Input"],

Cell[TextData[{
  StyleBox["ExpToTrig", "Input"],
  " does the opposite."
}], "Text"],

Cell[BoxData[
    \(ExpToTrig[%]\)], "Input"],

Cell[TextData[{
  StyleBox["FullSimplify", "Input"],
  " generates the smallest possible form of an expression involving special \
functions. (",
  StyleBox["Simplify", "Input"],
  " works primarily on polynomial expressions.)"
}], "Text"],

Cell[BoxData[
    \(FullSimplify[Gamma[\[Omega]] Gamma[1 - \[Omega]]]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[Abs[z]\ Exp[I\ Arg[z]]]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["FunctionExpand", "Input"],
  ", ",
  StyleBox["TrigReduce", "Input"],
  ", ",
  StyleBox["ComplexityFunction", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many options to symbolic functions that allow us to change the \
default assumptions used to perform a calculation. For instance, by default \
the ",
  StyleBox["Factor", "Input"],
  " command allows only real integers in the factorization of a polynomial."
}], "Text"],

Cell[BoxData[
    \(Factor[x\^2 - 1]\)], "Input"],

Cell[TextData[{
  "For this reason, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not extract any factors from ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 2\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Factor[x^2 - 2]\ \ \ \ 
     (*\ use\ the\ default\ behavior\ of\ Factor\ *) \)\)], "Input"],

Cell["\<\
There may be instances, however, in which algebraic numbers should \
be allowed in the factorization.\
\>", "Text"],

Cell[TextData[{
  "Here is a list of options to ",
  StyleBox["Factor", "Input"],
  ", along with their default values."
}], "Text"],

Cell[BoxData[
    \(Options[Factor]\)], "Input"],

Cell[TextData[{
  "To allow algebraic numbers in the factorization of a polynomial, we use \
the ",
  StyleBox["Extension", "Input"],
  " option."
}], "Text"],

Cell[BoxData[
    \(\(?Extension\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now factors ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 2\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Factor[x^2\  - \ 2, \ Extension -> \@2]\)], "Input"],

Cell[TextData[
"Similarly we can factor over complex integers by including the complex unit \
\[ImaginaryI] in the field over which polynomials are factored."], "Text"],

Cell[BoxData[
    \(Factor[\ x^2\  + \ 1, \ Extension \[Rule] \[ImaginaryI]]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["GaussianIntegers", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s Assumptions"
}], "Subsubsection"],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " assumes that any variable or symbol that does not have an explicit value \
can take any complex value."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the real part of any number."
}], "Text"],

Cell[BoxData[
    \(Re[3 + 4\ I]\)], "Input"],

Cell[TextData[{
  "However, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not automatically simplify ",
  Cell[BoxData[
      \(Re[x + I\ y]\)], "Input"],
  " to ",
  StyleBox["x", "Input"],
  ", because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " assumes the variables ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " could have complex values."
}], "Text"],

Cell[BoxData[
    \(Re[x + I\ y]\)], "Input"],

Cell[TextData[{
  "To instruct ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to assume that ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " have real values, we use ",
  StyleBox["ComplexExpand", "Input"],
  ". When ",
  StyleBox["ComplexExpand", "Input"],
  " is applied to an expression, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " treats all the variables in the expression as if they have real values. \
When ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " are assumed to be real-valued, the real part of ",
  Cell[BoxData[
      \(x + I\ y\)], "Input"],
  " is ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Re[x + I\ y]]\)], "Input"],

Cell[TextData[{
  "Similarly, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplifies ",
  Cell[BoxData[
      \(TraditionalForm\`\((\@z)\)\^2\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " because the simplification is correct for any value of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Sqrt[z]^2\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not, however, automatically simplify ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\^2\)]],
  " to ",
  StyleBox["z",
    FontSlant->"Italic"],
  ": the simplification is valid only for nonnegative real values of ",
  StyleBox["z", "Input"],
  ", and by default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " assumes ",
  StyleBox["z", "Input"],
  " can take any complex value. Here is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s default behavior."
}], "Text"],

Cell[BoxData[
    \(Sqrt[z^2]\)], "Input"],

Cell[TextData[{
  "However, there are ways to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to perform the simplification. The ",
  StyleBox["PowerExpand", "Input"],
  " function multiplies the exponents in an expression like ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\^2\)]],
  ", as the usage message reveals."
}], "Text"],

Cell[BoxData[
    \(\(?PowerExpand\)\)], "Input"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs the simplification."
}], "Text"],

Cell[BoxData[
    \(PowerExpand[\@z\^2]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["TargetFunctions", "Input"],
  ", ",
  StyleBox["Miscellaneous`RealOnly`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Algebra", "Subsubsection"],

Cell["\<\
Add, subtract, multiply, and divide any two polynomials, \
simplifying the result if necessary.\
\>", "Question"],

Cell[TextData[{
  "Here we define two polynomials, ",
  StyleBox["polyone", "Input"],
  " and ",
  StyleBox["polytwo", "Input"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(polyone = x\^2 + 2\ x + 1; \)\), 
    \(\(polytwo = x\^3 - 3\ x - 2; \)\)}], "Input"],

Cell["Here are the sum and difference.", "Text"],

Cell[BoxData[
    \(polyone + polytwo\)], "Input"],

Cell[BoxData[
    \(polyone - polytwo\)], "Input"],

Cell["Here is the product.", "Text"],

Cell[BoxData[
    \(polyone\[Times]polytwo\)], "Input"],

Cell["The result needs to be expanded.", "Text"],

Cell[BoxData[
    \(Expand[%]\)], "Input"],

Cell["Here is the quotient.", "Text"],

Cell[BoxData[
    \(polyone/polytwo\)], "Input"],

Cell["In this case, the quotient can be simplified.", "Text"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[TextData[{
  "Expand the expression ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + x)\)\^10\)]],
  ". Factor the expression ",
  Cell[BoxData[
      \(TraditionalForm\`1 + x\^105\)]],
  "."
}], "Question"],

Cell[TextData[{
  "This is simply a matter of using proper ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " syntax."
}], "Text"],

Cell[BoxData[
    \(Expand[\((1 + x)\)^10]\)], "Input"],

Cell[BoxData[
    \(Factor[1 + x^105]\)], "Input"],

Cell[TextData[{
  "Use ",
  StyleBox["ComplexExpand", "Input"],
  " and its option ",
  StyleBox["TargetFunctions", "Input"],
  " to convert ",
  Cell[BoxData[
      \(Abs[x + I\ y]\)], "Input"],
  " to ",
  Cell[BoxData[
      \(Sqrt[x^2 + y^2]\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "By default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not simplify ",
  Cell[BoxData[
      \(Abs[x + I\ y]\)], "Input"],
  " because it assumes ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " could be complex-valued variables."
}], "Text"],

Cell[BoxData[
    \(Abs[x + I\ y]\)], "Input"],

Cell[TextData[{
  "The option ",
  StyleBox["TargetFunctions", "Input"],
  " allows us to specify the form in which we want the result of ",
  StyleBox["ComplexExpand", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(?TargetFunctions\)\)], "Input"],

Cell[TextData[{
  "Here is the default setting of ",
  StyleBox["TargetFunctions", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Options[ComplexExpand]\)], "Input"],

Cell[TextData[{
  "To simplify ",
  Cell[BoxData[
      \(Abs[x + I\ y]\)], "Input"],
  ", we need to give a value for ",
  StyleBox["TargetFunctions", "Input"],
  " that does not include ",
  StyleBox["Abs", "Input"],
  ". Here we use the option value ",
  Cell[BoxData[
      \({Re, Im}\)], "Input"],
  ", and we get the desired result."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[Abs[x + I\ y], TargetFunctions -> {Re, Im}]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitution with Replacement Rules", "Subsection"],

Cell[TextData[{
  "Suppose we want to substitute a particular value for the variable ",
  StyleBox["y", "Input"],
  " into the formula ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\)], "Input"],
  ". One way to substitute the value 7 for ",
  StyleBox["y", "Input"],
  " is to set ",
  StyleBox["y", "Input"],
  " equal to 7."
}], "Text"],

Cell[BoxData[
    \(\(y = 7; \)\)], "Input"],

Cell[TextData[{
  "Evaluating ",
  Cell[BoxData[
      \(Sqrt[x^2 + y^2]\)], "Input"],
  " now reflects the new value of ",
  StyleBox["y", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Sqrt[x^2 + y^2]\)], "Input"],

Cell[TextData[{
  "The trouble with this approach is that the value 7 (in this case) will be \
substituted wherever ",
  StyleBox["y", "Input"],
  " appears in any expressions evaluated after the assignment, at least until \
",
  StyleBox["y", "Input"],
  " is cleared of its value. For instance, if we later try to solve an \
equation with respect to ",
  StyleBox["y", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " substitutes the value 7 into ",
  StyleBox["y", "Input"],
  ", in effect assuming we want to solve the equation with respect to 7."
}], "Text"],

Cell[BoxData[
    \(Solve[y\^10 + x\^10 == 1, y]\)], "Input"],

Cell[TextData[{
  "To clear the value of ",
  StyleBox["y", "Input"],
  ", we use ",
  StyleBox["Clear", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[y]\)], "Input"],

Cell[TextData[{
  "A better method for replacing any part of an expression with another value \
or expression uses the replacement operator pair ",
  StyleBox["/.", "Input"],
  " and ",
  StyleBox["->", "Input"],
  ". Expressions of the form ",
  StyleBox["replacethis",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["->", "Input"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["withthis",
    FontSlant->"Italic"],
  " are called ",
  StyleBox["rules",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " carries out any substitutions described by a rule or set of rules placed \
after the slash-period ",
  StyleBox["/.", "Input"],
  ". The general syntax for making a substitution is ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["/.", "Input"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["replacethis",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["->", "Input"],
  StyleBox[" ",
    FontSize->10],
  StyleBox["withthis",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "For instance, to replace ",
  StyleBox["y", "Input"],
  " in the expression ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\)], "Input"],
  " with 7, we type the following."
}], "Text"],

Cell[BoxData[
    \(Sqrt[x^2\  + \ y^2]\  /. \ y\  -> \ 7\)], "Input"],

Cell[TextData[{
  "Although we replaced the variable ",
  StyleBox["y", "Input"],
  " with the value 7 in the expression ",
  Cell[BoxData[
      \(Sqrt[x^2 + y^2]\)], "Input"],
  ", the value for ",
  StyleBox["y", "Input"],
  " remains undefined."
}], "Text"],

Cell[BoxData[
    \(y\)], "Input"],

Cell[TextData[{
  "We are not limited to numerical replacements. Here we replace ",
  StyleBox["y", "Input"],
  " with ",
  Cell[BoxData[
      \(1 + a\)], "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Sqrt[x^2\  + \ y^2]\  /. \ y\  -> \ 1\  + \ a\)], "Input"],

Cell[TextData[{
  "Here is an expression that contains the variable ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Log[\((1 - x)\)\ x]\)], "Input"],

Cell[TextData[{
  "We can replace ",
  StyleBox["x", "Input"],
  " with a numerical value by using a replacement rule. (We enter the arrow \
character ",
  StyleBox["\[Rule]", "Input"],
  " by typing \[EscapeKey]",
  StyleBox["->", "Input"],
  "\[EscapeKey].)"
}], "Text"],

Cell[BoxData[
    \(Log[\((1 - x)\)\ x]\  /. \ x\  \[Rule] \ 0.35\)], "Input"],

Cell["\<\
We can also replace any number of variables or subexpressions in an \
expression with others by giving a list of replacement rules.\
\>", "Text"],

Cell[BoxData[
    \(a + b^2 + c^3\  /. 
      \ {a \[Rule] \[Alpha], \ b \[Rule] \[Beta], \ c \[Rule] \[Gamma]}\)], 
  "Input"],

Cell[TextData[{
  "We can also create a list of expressions formed by different lists of \
replacement rules by telling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to substitute more than one set of values for an expression. Below we \
compute three values for ",
  Cell[BoxData[
      \(Sqrt[x^2 + y^2]\)], "Input"],
  " by substituting into it a list containing three lists of replacement \
rules."
}], "Text"],

Cell[BoxData[
    \(Sqrt[x^2\  + \ y^2]\  /. \n
      \t{{x \[Rule] 3, \ y \[Rule] 4}, \ {x \[Rule] 5, \ y \[Rule] 12}, 
        \ {x \[Rule] 1, \ y \[Rule] 1}}\)], "Input"],

Cell[TextData[{
  "A somewhat tricky case occurs when we perform more than one substitution \
in an expression with only one variable. For instance, to substitute two \
values for ",
  StyleBox["x", "Input"],
  " into the expression defined above, we might try the following."
}], "Text"],

Cell[BoxData[
    \(\(Log[\((1 - x)\)\ x]\  /. \ {x -> 0.35, \ x -> 0.55}\ 
     (*\ this\ is\ incorrect\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returned only one of the two desired values. The reason is that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs the substitutions from left to right: First the rule ",
  Cell[BoxData[
      \(x -> 0.35\)], "Input"],
  " was applied to the formula, replacing all occurrences of ",
  StyleBox["x", "Input"],
  " with 0.35; then the rule ",
  Cell[BoxData[
      \(x -> 0.55\)], "Input"],
  " was applied to ",
  StyleBox["that",
    FontSlant->"Italic"],
  " result, which was free of any occurrences of ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "To avoid this difficulty, we must put each set of replacement rules inside \
its own list, even if each set contains only one rule: this indicates to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that each replacement rule should be considered a separate solution set."
}], "Text"],

Cell[BoxData[
    \(\(Log[\((1 - x)\)\ x]\  /. \ {{x -> 0.35}, \ {x -> 0.55}}\ 
     (*\ this\ is\ correct\ *) \)\)], "Input"],

Cell[TextData[{
  "In general ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns as many values from a substitution as there are sets of \
replacement rules."
}], "Text"],

Cell[TextData[{
  "One reason that replacement rules are important is that functions such as \
",
  StyleBox["Solve", "Input"],
  " return results in the form of a list of lists of replacement rules."
}], "Text"],

Cell[BoxData[
    \(Solve[x\^2 - 1 == 0, x]\)], "Input"],

Cell[TextData[{
  "Here we verify the solutions separately by substituting each one into the \
original equation, using the replacement operator ",
  StyleBox["/.", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(x\^2 - 1 == 0 /. x \[Rule] \(-1\)\)], "Input"],

Cell[BoxData[
    \(x\^2 - 1 == 0 /. x \[Rule] 1\)], "Input"],

Cell["\<\
We can test both solutions at the same time by substituting a list \
of solution sets into the equation.\
\>", "Text"],

Cell[BoxData[
    \(x\^2 - 1 == 0 /. {{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Input"],

Cell[TextData[{
  "An easier way to do the same thing is to name the list of replacement \
rules. Here we solve the same equation, this time naming the solution set of \
replacement rules ",
  StyleBox["solset", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(solset = Solve[x\^2 - 1 == 0, x]\)], "Input"],

Cell[TextData[{
  "Now, instead of retyping the solutions, we can directly substitute ",
  StyleBox["solset", "Input"],
  " into the equation (note that the entire rule is contained in ",
  StyleBox["solset", "Input"],
  ", so it is important not to type ",
  Cell[BoxData[
      \(x \[Rule] solset\)], "Input"],
  " after the ",
  StyleBox["/.", "Input"],
  ")."
}], "Text"],

Cell[BoxData[
    \(x\^2 - 1 == 0 /. solset\)], "Input"],

Cell["\<\
Similarly, we can generate a list of the solutions by substituting \
the rules containing the solutions into the variable(s) of the equation.\
\>",
   "Text"],

Cell[BoxData[
    \(x /. solset\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["ReplaceAll", "Input"],
  ", ",
  StyleBox["ReplaceRepeated", "Input"],
  ", ",
  StyleBox["RuleDelayed", "Input"],
  ", ",
  StyleBox["Dispatch", "Input"],
  " "
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Substitution with Replacement Rules", "Subsubsection"],

Cell[TextData[{
  "Using a replacement rule, replace ",
  StyleBox["x",
    FontSlant->"Italic"],
  " in the expression ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2\ x - 1\)]],
  " with 5."
}], "Question"],

Cell[TextData[{
  "To replace ",
  StyleBox["x",
    FontSlant->"Italic"],
  " with 5, we use the replacement operator pair ",
  StyleBox["/.", "Input"],
  " and ",
  StyleBox["->", "Input"],
  " on the polynomial."
}], "Text"],

Cell[BoxData[
    \(x\^2 + 2\ x - 1 /. x \[Rule] 5\)], "Input"],

Cell[TextData[{
  "Verify that ",
  Cell[BoxData[
      \(TraditionalForm\`x = 3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x = 5\)]],
  " are roots of the expression ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 - 9  x\^2 + 23  x - 15\)]],
  ", and that ",
  Cell[BoxData[
      \(TraditionalForm\`x = 4\)]],
  " ",
  "is not."
}], "Question"],

Cell[TextData[{
  "Enter the polynomial, calling it ",
  StyleBox["cubic", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(cubic = x\^3 - 9\ x\^2 + 23\ x - 15\)], "Input"],

Cell[TextData[{
  "Replace ",
  StyleBox["x",
    FontSlant->"Italic"],
  " with 3."
}], "Text"],

Cell[BoxData[
    \(cubic /. x \[Rule] 3\)], "Input"],

Cell[TextData[{
  "The result is zero, so ",
  StyleBox["x",
    FontSlant->"Italic"],
  " = 3 is a root."
}], "Text"],

Cell[TextData[{
  "Next replace ",
  StyleBox["x",
    FontSlant->"Italic"],
  " with 4."
}], "Text"],

Cell[BoxData[
    \(cubic /. x \[Rule] 4\)], "Input"],

Cell[TextData[{
  "The result is not zero, so ",
  StyleBox["x",
    FontSlant->"Italic"],
  " = 4 is not a root."
}], "Text"],

Cell[TextData[{
  "Now replace ",
  StyleBox["x",
    FontSlant->"Italic"],
  " with 5."
}], "Text"],

Cell[BoxData[
    \(cubic /. x \[Rule] 5\)], "Input"],

Cell["Again we have a root.", "Text"],

Cell["\<\
We can test all three roots at once by giving a list of lists of \
replacement rules.\
\>", "Text"],

Cell[BoxData[
    \(cubic /. {{x \[Rule] 3}, {x \[Rule] 4}, {x \[Rule] 5}}\)], "Input"],

Cell[TextData[{
  "We generate ",
  StyleBox["True", "Input"],
  " or ",
  StyleBox["False", "Input"],
  " values by substituting the solutions into the equation ",
  Cell["cubic==0", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(cubic == 0 /. {{x \[Rule] 3}, {x \[Rule] 4}, {x \[Rule] 5}}\)], "Input"],

Cell[TextData[{
  "Verify that ",
  Cell[BoxData[
      \(TraditionalForm\`\(-b\) - \@\(b\^2 - c\)\)]],
  " is  a root of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2  b\ x + c\)]],
  "."
}], "Question"],

Cell[TextData[{
  "The basic idea is the same as in the preceding problem. (We must be \
certain to type a space or asterisk between the ",
  StyleBox["b", "Input"],
  " and ",
  StyleBox["x", "Input"],
  " in the term ",
  Cell[BoxData[
      \(2\ b\ x\)], "Input"],
  " to denote multiplication.)"
}], "Text"],

Cell[BoxData[
    \(x\^2 + 2\ b\ x + c /. x \[Rule] \(-b\) - Sqrt[b\^2 - c]\)], "Input"],

Cell[TextData[{
  "In this case, a complication is that the symbolic result does not \
automatically simplify. Therefore, we explicitly tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to simplify the result."
}], "Text"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[TextData[{
  "Thus we see that the given expression is a root of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2  b\ x + c\)]],
  "."
}], "Text"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solving Equations", "Subsection"],

Cell[CellGroupData[{

Cell["Basic Solving", "Subsubsection"],

Cell[TextData[{
  "Using ",
  StyleBox["Solve", "Input"],
  " gives generic solutions to an equation or system of equations. Recall \
that we use a double equal sign ",
  StyleBox["==", "Input"],
  " to separate the left and right sides of an equation, and that we should \
specify a variable or list of variables to solve for. Here we solve the \
general quadratic equation with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Solve[a\ x\^2 + b\ x + c == 0, x]\)], "Input"],

Cell[TextData[{
  "Inside ",
  StyleBox["Solve", "Input"],
  ", we enter a system of equations as a list of equations, followed by a \
list of variables to solve for."
}], "Text"],

Cell[BoxData[
    \(Solve[{x + 5\ y == c, 2\ x + y == d}, {x, y}]\)], "Input"],

Cell["\<\
We can also solve some systems of equations expressed as matrices. \
For instance, the same set of linear equations as above can be solved by \
expressing the coefficients in the system as a matrix.\
\>", "Text"],

Cell[BoxData[
    \(\(coeffs = {{1, 5}, {2, 1}}; \)\)], "Input"],

Cell[TextData[{
  "We can then use ",
  StyleBox["LinearSolve", "Input"],
  " to solve the same system."
}], "Text"],

Cell["?LinearSolve", "Input"],

Cell[BoxData[
    \(LinearSolve[coeffs, {c, d}]\)], "Input"],

Cell["As expected, the answers are the same.", "Text"],

Cell["\<\
Naturally, there are many equations that cannot be solved using \
symbolic techniques, and when such equations are encountered we must use \
numeric solving or root-finding techniques.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Solve", "Input"],
  " solves equations for general values of the parameters, so the solutions \
returned may be incorrect for special values of the parameters. For example, \
the solutions to the general quadratic equation are incorrect for the value ",
  
  Cell[BoxData[
      \(TraditionalForm\`a = 0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Solve[a\ x\^2 + b\ x + c == 0, x]\)], "Input"],

Cell[TextData[{
  Cell["Reduce", "Input"],
  " returns a list of logical statements that account for special values of \
parameters. (The form ",
  Cell["&&", "Input"],
  " stands for the logical function ",
  Cell["And", "Input"],
  ", and ",
  Cell["||", "Input"],
  " for the logical function ",
  Cell["Or", "Input"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(Reduce[a\ x\^2 + b\ x + c == 0, x]\)], "Input"],

Cell[TextData[{
  "The result states that when ",
  StyleBox["a",
    FontSlant->"Italic"],
  " \[NotEqual] 0, the solutions ",
  Cell[BoxData[
      \(TraditionalForm
      \`x = \(\(-b\) \[PlusMinus] \@\(b\^2 - 4\ a\ c\)\)\/\(2  a\)\)]],
  " are correct; that when ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  " are all zero, any value of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is a solution; and that when ",
  Cell[BoxData[
      \(TraditionalForm\`a = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b \[NotEqual] 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-\(c\/b\)\)\)]],
  " is a solution."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Eliminate", "Input"],
  ", ",
  StyleBox["NSolve", "Input"],
  ", ",
  StyleBox["FindRoot", "Input"],
  ", ",
  StyleBox["ToRules", "Input"],
  ", ",
  StyleBox["Root", "Input"],
  ", ",
  StyleBox["ToRadicals", "Input"],
  ", ",
  StyleBox["RootReduce", "Input"],
  ", ",
  StyleBox["LogicalExpand", "Input"],
  ", ",
  StyleBox["Algebra`InequalitySolve`", "Input"],
  ", ",
  StyleBox["Calculus`RSolve", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Solutions as Replacement Rules", "Subsubsection"],

Cell[TextData[{
  "The following command loads from the ",
  StyleBox["Graphics", "Input"],
  " package directory the package containing the ",
  StyleBox["ImplicitPlot", "Input"],
  " command."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`ImplicitPlot`\>"]\)], "Input"],

Cell["\<\
Once the package is loaded, we can make a plot of two relations on \
the same set of axes.\
\>", "Text"],

Cell[BoxData[
    \(\(imp = \n\t
      ImplicitPlot[\n
        \t\t{11\ x^2 + 23\ y^2 == 200, \n\t\t\t10  y - 6\ x^2 == \(-50\)}, 
        \ {x, \(-5\), 5}, \ {y, \(-5\), 5}]; \)\)], "Input"],

Cell[TextData[{
  "Given symbols and integers as coefficients, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns a list of exact solutions to the equations."
}], "Text"],

Cell[BoxData[
    \(solns = \n\t
      Solve[\n\t\t{11\ x^2 + 23\ y^2 == 200, 10  y - 6\ x^2 == \(-50\)}, \n
        \t\t{x, y}]\)], "Input"],

Cell["\<\
As before, the answers are in the form of lists of replacement \
rules. As always, we can get numeric approximations to the solutions.\
\>", 
  "Text"],

Cell[BoxData[
    \(solns = N[solns]\)], "Input"],

Cell[TextData[{
  "We can then substitute the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-",
  StyleBox["y",
    FontSlant->"Italic"],
  " values into the ",
  StyleBox["Point", "Input"],
  " graphics primitive."
}], "Text"],

Cell[BoxData[
    \(Point[{x, y}] /. solns\)], "Input"],

Cell[TextData[{
  "By default, points are the same color and thickness as lines, so we need \
to prepend the graphics directive ",
  StyleBox["PointSize", "Input"],
  " to make the points visible."
}], "Text"],

Cell[BoxData[
    \(bigpoints = Prepend[%, PointSize[0.04]]\)], "Input"],

Cell[TextData[{
  "When we plot the two relations, we can then highlight the solutions by \
including the ",
  StyleBox["bigpoints", "Input"],
  " object in the plotting command."
}], "Text"],

Cell[BoxData[
    \(\(Show[imp, Epilog \[Rule] bigpoints]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Solving Equations", "Subsubsection"],

Cell[TextData[{
  "Solve the equation ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 = 8\)]],
  " with respect to x, then substitute the solutions back into the equation."
}], "Question"],

Cell[TextData[{
  StyleBox["Solve", "Input"],
  " gives an answer in the form of a list of replacement rules, and we call \
the list of rules ",
  StyleBox["solns", "Input"],
  ". (It is important to use a double equal sign inside the ",
  StyleBox["Solve", "Input"],
  " command to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that we are testing for the equality of the polynomial and 0.) The single \
equal sign after ",
  StyleBox["solns", "Input"],
  " denotes that we wish to set ",
  StyleBox["solns", "Input"],
  " equal to the result returned by ",
  StyleBox["Solve", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(solns = Solve[x\^3 == 8, x]\)], "Input"],

Cell[TextData[{
  "To verify the solutions, we substitute the solutions (",
  StyleBox["solns", "Input"],
  ") back into the equations using the replacement notation slash-period (",
  StyleBox["/.", "Input"],
  ")."
}], "Text"],

Cell[BoxData[
    \(x\^3 == 8 /. solns\)], "Input"],

Cell["\<\
Solve the general quadratic equation, substituting the solutions \
into the equation to verify that they are roots.\
\>", "Question"],

Cell["\<\
Solve the equation, getting the two roots as a list of replacement \
rules.\
\>", "Text"],

Cell[BoxData[
    \(Solve[a\ x\^2 + b\ x + c == 0, x]\)], "Input"],

Cell["Next, substitute the roots into the equation.", "Text"],

Cell[BoxData[
    \(a\ x\^2 + b\ x + c == 0 /. %\)], "Input"],

Cell["The resulting equations need to be simplified.", "Text"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculus and Analysis", "Subsection"],

Cell[CellGroupData[{

Cell["Differentiation, Integration, and Taylor Series Expansion", 
  "Subsubsection"],

Cell[TextData[{
  "For differentiation, integration, and series expansions we must indicate \
the variable(s) with respect to which the operations are being performed. \
Below we define an expression called ",
  StyleBox["expr", "Input"],
  " and set it equal to ",
  Cell[BoxData[
      \(TraditionalForm\`sin(n\ \[Pi]\ x)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Clear[expr]\  (*\ clear\ any\ previous\ values\ of\ expr\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(expr = Sin[n\ Pi\ x]\)], "Input"],

Cell[TextData[{
  "We take the derivative of ",
  StyleBox["expr", "Input"],
  " with respect to ",
  StyleBox["x", "Input"],
  ", using the differentiation operator ",
  StyleBox["D", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(D[\ expr, \ x\ ]\)], "Input"],

Cell[TextData[{
  "We can also use the special form ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[PartialD]\_\[Placeholder]\ \[SelectionPlaceholder]\),
          "Input"], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(\[PartialD]\_x\ expr\)], "Input"],

Cell[TextData[{
  "Similarly we integrate ",
  StyleBox["expr", "Input"],
  " with respect to ",
  StyleBox["x", "Input"],
  " using ",
  StyleBox["Integrate", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Integrate[\ expr, \ x\ ]\)], "Input"],

Cell[TextData[{
  "We can also use the following form. We enter the integral sign \[Integral] \
by typing \[EscapeKey]int\[EscapeKey] or ",
  Cell[TextData["\\\[InvisibleSpace][Integral]"], "Input"],
  ", and we must use the special differential \[DifferentialD], entered by \
typing \[EscapeKey]dd\[EscapeKey] or ",
  Cell[TextData["\\\[InvisibleSpace][DifferentialD]"], "Input"],
  ", and not an ordinary keyboard ",
  StyleBox["d",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\[Integral]expr\ \[DifferentialD]x\)], "Input"],

Cell[TextData[{
  "Here we take a Taylor series expansion of ",
  StyleBox["expr", "Input"],
  " with respect to ",
  StyleBox["x", "Input"],
  ", around ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  ", up to degree 7."
}], "Text"],

Cell[BoxData[
    \(Series[expr, \ {x, 0, 7}]\)], "Input"],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(O[x]\^8\)]],
  " term denotes the extra terms beginning at order 8. To remove the order \
term, we use the function ",
  StyleBox["Normal", "Input"],
  ". The result is a polynomial."
}], "Text"],

Cell[BoxData[
    \(Normal[%]\)], "Input"],

Cell["\<\
We can apply these calculus operations to general functions and \
expressions as well.\
\>", "Text"],

Cell[BoxData[
    \(D[f[x]\ g[x]\ h[x], x]\)], "Input"],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot return an antiderivative for an expression, it returns the \
expression unevaluated."
}], "Text"],

Cell[BoxData[
    \(Integrate[f[x], \ x]\)], "Input"],

Cell[BoxData[
    \(Integrate[Sin[Sin[x]], \ x]\)], "Input"],

Cell["\<\
Given limits of integration, we can use numerical methods to obtain \
an approximation.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[Sin[Sin[x]], \ {x, 0, \[Pi]}]\)], "Input"],

Cell["\<\
All of the calculus functions apply to multivariate expressions. \
Here is a mixed partial derivative.\
\>", "Text"],

Cell[BoxData[
    \(D[\[Pi]\^\(x\ y\), \ x, \ y]\)], "Input"],

Cell[TextData[{
  "In these examples, ",
  StyleBox["Exp", "Input"],
  " is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s name for the exponential function, and ",
  StyleBox["Erf", "Input"],
  " is the name for the error function."
}], "Text"],

Cell[BoxData[
    \(Integrate[Exp[\(-\((\[Alpha]^2 + \[Beta]^2)\)\)], \ \[Alpha], \ \[Beta]]
      \)], "Input"],

Cell[BoxData[
    \(\[Integral]\(\[Integral]\(\[Integral]Exp[\(-\((x\^2 + y\^2 + z\^2)\)\)] 
            \[DifferentialD]z \[DifferentialD]y \[DifferentialD]x\)\)\)], 
  "Input"],

Cell[TextData[{
  "Here we see that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows how to apply the fundamental theorem of calculus."
}], "Text"],

Cell[BoxData[
    \(D[\[Integral]\_a\%\(b[z]\)f[x] \[DifferentialD]x, \ z]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Calculus and Analysis Functions", "Subsubsection"],

Cell[TextData[{
  StyleBox["Sum", "Input"],
  " allows us to evaluate many finite and infinite sums and products."
}], "Text"],

Cell["We can evaluate summations with symbolic or infinite limits.", "Text"],

Cell[BoxData[
    \(Sum[k\^5, \ {k, 1, n}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recognizes many special summations, as well."
}], "Text"],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Infinity] x\^k\/\(k!\)\)], "Input"],

Cell[TextData[{
  "We can do a spot check of the answer by comparing a partial summation to \
the series expansion of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s result."
}], "Text"],

Cell[BoxData[
    \(Sum[x^k/\(k!\), \ {k, \ 0, \ 7}]\)], "Input"],

Cell[BoxData[
    \(Normal[Series[E\^x, {x, 0, 7}]]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves a large class of ordinary differential equations (or systems of \
ODEs) symbolically, given the equations and initial conditions, a function or \
list of functions to solve for, and independent variables."
}], "Text"],

Cell[BoxData[
    \(DSolve[\(y'\)[x] + 2\ y[x] == 3\ Exp[x], y[x], x]\)], "Input"],

Cell[BoxData[
    \(DSolve[\(y'\)[x]\/x - \(2\ y[x]\)\/x\^2 == x\ Cos[x], y[x], x]\)], 
  "Input"],

Cell[TextData[{
  "The ",
  StyleBox["C[1]", "Input"],
  " in each of the previous examples is an undetermined coefficient. To \
replace it with a numerical (or other) value, we use replacement rules."
}], "Text"],

Cell[BoxData[
    \(% /. C[1] \[Rule] 5\)], "Input"],

Cell[TextData[{
  "We can specify initial conditions, expressing them in the form of an \
equation (that is, using ",
  StyleBox["==", "Input"],
  " notation)."
}], "Text"],

Cell[BoxData[
    \(DSolve[{\(y'\)[x]/x - \((2\ y[x]\ x)\) == x, \ y[\[Pi]] == 3}, \ y[x], 
      \ x]\)], "Input"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recognizes a special differential equation, and returns the answer as a \
linear combination of Bessel functions."
}], "Text"],

Cell[BoxData[
    \(DSolve[
      z\^2\ \(\(y'\)'\)[z] + z\ \(y'\)[z] + \((z\^2 - 169)\)\ y[z] == 0, 
      y[z], z]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve some partial differential equations. Here the solution includes \
an undetermined ",
  StyleBox["function",
    FontSlant->"Italic"],
  " ",
  StyleBox["C[1]", "Input"],
  " of the quantity ",
  Cell[BoxData[
      \(2  t + u\)], "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(DSolve[x[t, u] == D[x[t, u], t] - 2\ D[x[t, u], u], x[t, u], {t, u}]\)],
   "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calculates limits."
}], "Text"],

Cell[BoxData[
    \(Limit[\((x^2 - 4)\)\/\((x - 2)\), \ x -> 2]\)], "Input"],

Cell[TextData[{
  "Graphics are useful as an informal way to verify a limit. Here we find the \
limit of ",
  Cell[BoxData[
      \(Sin[x]/x\)], "Input"],
  " as ",
  StyleBox["x", "Input"],
  " approaches zero."
}], "Text"],

Cell[BoxData[
    \(Limit[Sin[x]/x, x -> 0]\)], "Input"],

Cell[TextData[{
  "A plot of ",
  Cell[BoxData[
      \(TraditionalForm\`\(sin(x)\)\/x\)]],
  "suggests that the result returned by ",
  StyleBox["Limit", "Input"],
  " is correct."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, {x, \(-10\), 10}]; \)\)], "Input"],

Cell[TextData[{
  "We can specify the direction from which a limit is taken, setting the \
option ",
  StyleBox["Direction", "Input"],
  " to 1 to take the limit from the left, or setting ",
  StyleBox["Direction", "Input"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " to take the limit from the right."
}], "Text"],

Cell[TextData[{
  "Here is a plot of ",
  Cell[BoxData[
      \(TraditionalForm\`1\/x\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[1/x, {x, \(-0.5\), 0.5}]; \)\)], "Input"],

Cell[TextData[{
  "Setting ",
  StyleBox["Direction", "Input"],
  " to 1, we take the limit from the left."
}], "Text"],

Cell[BoxData[
    \(Limit[\ 1/x, \ x -> 0, \ Direction\  -> \ 1\ ]\)], "Input"],

Cell[TextData[{
  "Setting ",
  StyleBox["Direction", "Input"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  ", we take the limit from the right."
}], "Text"],

Cell[BoxData[
    \(Limit[\ 1/x, \ x -> 0, \ Direction\  -> \ \(-1\)\ ]\)], "Input"],

Cell["We can take limits of purely symbolic expressions.", "Text"],

Cell[BoxData[
    \(Limit[\((1 + m/n)\)^n, n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "The ",
  StyleBox["Interval", "Input"],
  " object returned by ",
  Cell[BoxData[
      \(Limit[Sin[x], x -> Infinity]\)], "Input"],
  " reflects the fact that the sine function oscillates forever between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " and 1."
}], "Text"],

Cell[BoxData[
    \(Limit[Sin[x], x \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "There are hundreds of mathematical functions available for use with \
symbolic arguments. Capabilities exist in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel and standard packages to solve recurrence relations, calculate \
Laplace transforms, compute orthogonal polynomials, and much more. The Help \
Browser, on-line help, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " books provide convenient ways to explore these functions."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Residue", "Input"],
  ", ",
  StyleBox["ComposeSeries", "Input"],
  ", ",
  StyleBox["InverseSeries", "Input"],
  ", ",
  StyleBox["Calculus`LaplaceTransform`", "Input"],
  StyleBox[", ", "Text"],
  StyleBox["Calculus`FourierTransform`", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Calculus and Analysis", "Subsubsection"],

Cell[TextData[{
  "Find where the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 - 6  x\^2 + 11  x - 6\)]],
  " crosses the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis, and where its derivative is equal to zero."
}], "Question"],

Cell["First we plot the curve.", "SmallText"],

Cell[BoxData[
    \(\(Plot[x\^3 - 6\ x\^2 + 11\ x - 6, {x, 0, 4}]; \)\)], "Input"],

Cell[TextData[{
  "To find where the curve crosses the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis, we use ",
  StyleBox["Solve", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(Solve[x\^3 - 6\ x\^2 + 11\ x - 6 == 0, x]\)], "Input"],

Cell[TextData[{
  "For the second part of the question, we take the derivative of the \
polynomial, using the derivative operator ",
  StyleBox["D", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(der = D[\((x\^3 - 6\ x\^2 + 11\ x - 6)\), x]\)], "Input"],

Cell[TextData[{
  "Next, we use ",
  StyleBox["Solve", "Input"],
  " again."
}], "SmallText"],

Cell[BoxData[
    \(Solve[der == 0, x]\)], "Input"],

Cell[TextData[{
  "Using the command ",
  StyleBox["InterpolatingPolynomial", "Input"],
  ", create a polynomial whose graph passes through the points (0, 1), (1, \
11), (2, 21), and (3, 17); then take its derivative. If possible, plot the \
polynomial and its derivative."
}], "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["InterpolatingPolynomial", "Input"],
  " with the given points to create the polynomial."
}], "SmallText"],

Cell[BoxData[
    \(mypoly = 
      InterpolatingPolynomial[{{0, 1}, {1, 11}, {2, 21}, {3, 17}}, x]\)], 
  "Input"],

Cell["Here it is in simpler form.", "SmallText"],

Cell[BoxData[
    \(mypoly = Simplify[mypoly]\)], "Input"],

Cell["Here is the derivative of our interpolating polynomial.", "SmallText"],

Cell[BoxData[
    \(der = \[PartialD]\_x mypoly\)], "Input"],

Cell["Here is a somewhat simpler form of the derivative.", "SmallText"],

Cell[BoxData[
    \(der = Simplify[der]\)], "Input"],

Cell[TextData[{
  "Here is a plot of ",
  StyleBox["mypoly", "Input"],
  " and its derivative."
}], "SmallText"],

Cell[BoxData[
    \(\(Plot[{mypoly, der}, {x, \(-0.1\), 3.1}, 
      PlotStyle \[Rule] {GrayLevel[0.5], GrayLevel[0.2]}]; \)\)], "Input"],

Cell[TextData[{
  "Solve the differential equation ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(y\^\[DoublePrime]\)(x) = \(y\^\[Prime]\)(x) + e\^x\)]],
  ", when ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\^\[Prime]\)(0) = 1\)]],
  ".\nAdditionally, try plotting ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ") over ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 1\)]],
  "."
}], "Question"],

Cell[TextData[{
  "First we solve the differential equation using ",
  StyleBox["DSolve", "Input"],
  ". Note that the initial conditions are written as equations, not \
assignments (",
  StyleBox["y[0]==2", "Input"],
  ", not ",
  StyleBox["y[0]=2", "Input"],
  "). For convenience, we call the solution ",
  StyleBox["dsol", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(dsol = 
      DSolve[{\(\(y'\)'\)[x] == \(y'\)[x] + E^x, \ y[0] == 2, 
          \(y'\)[0] == 1}, y[x], x]\)], "Input"],

Cell[TextData[{
  "We can isolate ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ") using the replacement operator ",
  StyleBox["/.", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(y[x] /. dsol\)], "Input"],

Cell[TextData[{
  "Next, plot ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ") using ",
  StyleBox["Plot", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(\(Plot[%, {x, \(-1\), 1}]; \)\)], "Input"],

Cell[TextData[{
  "Load the package ",
  StyleBox["DiscreteMath`RSolve`",
    FontFamily->"Courier"],
  ". Using the on-line help, solve the following system of recurrence \
equations, and compute ",
  Cell[BoxData[
      \(TraditionalForm\`a\_0\)]],
  " through ",
  Cell[BoxData[
      \(TraditionalForm\`a\_10\)]],
  "."
}], "Question"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`a\_n = a\_\(n - 1\) + a\_\(n - 2\), \ a\_0 = 1, \ 
    a\_1 = 3\)],
  FontWeight->"Bold"]], "Text",
  TextAlignment->-0.5,
  TextJustification->0],

Cell[TextData[{
  "Here we load the package and examine the usage message for ",
  StyleBox["RSolve", "Input"],
  "."
}], "SmallText"],

Cell[BoxData[
    \(Needs["\<DiscreteMath`RSolve`\>"]\)], "Input"],

Cell["?RSolve", "Input"],

Cell[TextData[{
  "We see from the usage message that ",
  StyleBox["RSolve", "Input"],
  " accepts a list of recurrence equations, a list of functions to solve for, \
and an independent variable. Here we enter the given system of equations, \
following the directions of the usage message, and get the result. (It is \
possible that we have previously defined values or rules for ",
  StyleBox["a", "Input"],
  " and ",
  StyleBox["n", "Input"],
  "; to be safe, we clear the variables first.)"
}], "SmallText"],

Cell[BoxData[
    \(\(Clear[a, n]; \)\)], "Input"],

Cell[BoxData[
    \(RSolve[{a[n] == a[n - 1] + a[n - 2], a[0] == 1, a[1] == 3}, a[n], n]\)],
   "Input"],

Cell[TextData[{
  "Extract the general result, calling it ",
  StyleBox["gen", "Input"],
  ", by replacing ",
  StyleBox["a[n]", "Input"],
  " with the solution."
}], "SmallText"],

Cell[BoxData[
    \(gen = \((a[n] /. First[%])\)\)], "Input"],

Cell[TextData[{
  "Here we test some values of ",
  StyleBox["n", "Input"],
  ", replacing the ",
  StyleBox["n", "Input"],
  " in ",
  StyleBox["gen", "Input"],
  " with 0."
}], "SmallText"],

Cell[BoxData[
    \(gen /. n \[Rule] 0\)], "Input"],

Cell["The answer can be simplified.", "SmallText"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[TextData[{
  "We test the case ",
  Cell[BoxData[
      \(TraditionalForm\`n = 1\)]],
  "."
}], "SmallText"],

Cell[BoxData[
    \(Simplify[gen /. n \[Rule] 1]\)], "Input"],

Cell["Now we generate the table of values.", "SmallText"],

Cell[BoxData[
    \(Table[Simplify[gen /. n \[Rule] j], {j, 0, 10}]\)], "Input"],

Cell["These numbers are called the Lucas numbers.", "SmallText"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lists and Functions", "Subsection"],

Cell[CellGroupData[{

Cell["Function Definitions", "Subsubsection"],

Cell["\<\
Function definitions that we have seen look like the \
following.\
\>", "Text"],

Cell[BoxData[
    \(func[z_] := 1 + z^10\)], "Input"],

Cell[TextData[{
  "The function has a name (",
  StyleBox["func", "Input"],
  ") and a pattern to match the argument(s) given to the function (",
  StyleBox["z_", "Input"],
  ", read as \[OpenCurlyDoubleQuote]any ",
  StyleBox["z",
    FontSlant->"Italic"],
  "\[CloseCurlyDoubleQuote]; the name of the pattern is unimportant, except \
that we must use the same name on the right side of the definition) on the \
left side of the colon-equal, and something to do with the argument(s) on the \
right side of the colon-equal."
}], "Text"],

Cell[TextData[{
  "We define functions that take more than one argument in the same way, \
except we type in a pattern for each argument that the function is to accept. \
The following function ",
  StyleBox["dist", "Input"],
  " takes two arguments, any ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and any ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ", and returns the absolute value of the difference of the two arguments."
}], "Text"],

Cell[BoxData[
    \(dist[x1_, x2_] := Abs[x1 - x2]\)], "Input"],

Cell[TextData[{
  "The ",
  StyleBox["body",
    FontSlant->"Italic"],
  " of a function (the part on the right-hand side of the definition) can be \
as complicated as necessary, and can contain compound expressions. The \
following function assigns values to the variables ",
  StyleBox["X", "Input"],
  " and ",
  StyleBox["Y", "Input"],
  ", then prints the new values."
}], "Text"],

Cell[BoxData[
    \(setXandY[xval_, yval_] := \n\t
      \((X = xval; Y = yval; 
        Print["\<X is now \>", X, "\<, and Y is now \>", Y])\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " executes all of the commands in the body of the function."
}], "Text"],

Cell[BoxData[
    \(setXandY[3, \(-7\)]\)], "Input"],

Cell[BoxData[
    \(X/Y\)], "Input"],

Cell[TextData[{
  "When we finish using ",
  StyleBox["X", "Input"],
  " and ",
  StyleBox["Y", "Input"],
  " we clear their values."
}], "Text"],

Cell[BoxData[
    \(Clear[X, Y]\)], "Input"],

Cell["\<\
We can define functions so that only certain types of arguments are \
valid. For instance, here is a recursive definition of a factorial \
function.\
\>", "Text"],

Cell[BoxData[
    \(fac[n_] := n\ fac[n - 1]; fac[0] := 1\)], "Input"],

Cell[TextData[{
  "Here we compare a value computed with ",
  StyleBox["fac", "Input"],
  " to a value computed using the built-in factorial function."
}], "Text"],

Cell[BoxData[
    \({fac[35], \(35!\)}\)], "Input"],

Cell[TextData[{
  "A shortcoming of ",
  StyleBox["fac", "Input"],
  " is that it should apply only to integers. We can determine a number\
\[CloseCurlyQuote]s type by using the ",
  StyleBox["Head", "Input"],
  " function. Possible values for the head of a number are ",
  StyleBox["Integer", "Input"],
  ", ",
  StyleBox["Rational", "Input"],
  ", ",
  StyleBox["Real", "Input"],
  ", and ",
  StyleBox["Complex", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Head[3]\)], "Input"],

Cell[BoxData[
    \(Head[22\/7]\)], "Input"],

Cell[BoxData[
    \(Head[3.14159]\)], "Input"],

Cell[TextData[{
  "We tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that a function applies only to a certain type of number by typing the \
permissible head of the number after the underscore in the function \
definition. (Before redefining ",
  StyleBox["fac", "Input"],
  ", we use ",
  StyleBox["Clear", "Input"],
  " to erase the old definition.)"
}], "Text"],

Cell[BoxData[
    \(Clear[fac]\)], "Input"],

Cell[TextData[{
  "Here we restrict ",
  StyleBox["fac", "Input"],
  " to arguments that have the head ",
  StyleBox["Integer", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(fac[n_Integer] := n\ fac[n - 1]; fac[0] := 1\)], "Input"],

Cell["\<\
The function works as intended when given an integer argument.\
\>",
   "Text"],

Cell[BoxData[
    \(fac[35]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns ",
  StyleBox["fac", "Input"],
  " unevaluated if called with anything but an integer."
}], "Text"],

Cell[BoxData[
    \(fac[1.23456]\)], "Input"],

Cell[TextData[{
  "A further shortcoming of ",
  StyleBox["fac", "Input"],
  " is that it should accept only ",
  StyleBox["positive",
    FontSlant->"Italic"],
  " integers. We can include conditions (such as \[OpenCurlyDoubleQuote]",
  StyleBox["n",
    FontSlant->"Italic"],
  " must be positive\[CloseCurlyDoubleQuote]) by typing slash-semicolon ",
  StyleBox["/;", "Input"],
  " after the body of the function, followed by the condition. First we clear \
",
  StyleBox["fac", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[fac]\)], "Input"],

Cell[TextData[{
  "Now we include the condition by typing ",
  StyleBox["/;", "Input"],
  " after the body of the definition, followed by the condition ",
  Cell[BoxData[
      \(TraditionalForm\`n > 0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(fac[n_Integer] := n\ fac[n - 1] /; n > 0\)], "Input"],

Cell[BoxData[
    \(fac[0] := 1\)], "Input"],

Cell["The function works for arguments that are positive integers.", "Text"],

Cell[BoxData[
    \(fac[40]\)], "Input"],

Cell["\<\
It returns unevaluated if called with anything other than a \
positive integer.\
\>", "Text"],

Cell[BoxData[
    \(fac[\(-10\)]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["If", "Input"],
  ", ",
  StyleBox["Which", "Input"],
  ", ",
  StyleBox["Switch", "Input"],
  ", ",
  StyleBox["Do", "Input"],
  ", ",
  StyleBox["For", "Input"],
  ", ",
  StyleBox["Alternatives", "Input"],
  ", ",
  StyleBox["Optional", "Input"],
  ", ",
  StyleBox["PatternTest", "Input"],
  ", ",
  StyleBox["MatchQ", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["List Functions", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many functions for creating lists. One such function is ",
  StyleBox["Range", "Input"],
  ", which generates a list of numbers. ",
  StyleBox["Range[", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " creates a list of numbers going from 1 to ",
  StyleBox["n",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Range[15]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  StyleBox["Range[", "Input"],
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a list of numbers from ",
  StyleBox["m",
    FontSlant->"Italic"],
  " to ",
  StyleBox["n",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Range[20, 30]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  StyleBox["Range[", "Input"],
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["s",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a list of numbers from ",
  StyleBox["m",
    FontSlant->"Italic"],
  " to ",
  StyleBox["n",
    FontSlant->"Italic"],
  " in increments of ",
  StyleBox["s",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(Range[3, 4, 1/10]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "Another function for creating lists is ",
  StyleBox["Table", "Input"],
  ", which we have seen before. Here is a table of approximations to the \
natural logarithm of the ",
  Cell[BoxData[
      \(TraditionalForm\`i\^th\)]],
  " prime number, as ",
  StyleBox["i",
    FontSlant->"Italic"],
  " goes from 1",
  StyleBox[" ",
    FontSize->11],
  "to",
  StyleBox[" ",
    FontSize->10],
  "5."
}], "Text"],

Cell[BoxData[
    \(Table[N[Log[Prime[i]]], {i, 1, 5}]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell["\<\
The elements of a list can be other lists, and lists can be nested \
to any depth. For instance, a matrix is a list of lists, where each sublist \
contains the elements of one row of the matrix. Here is a 3 \[Times] 3 \
matrix.\
\>", "Text"],

Cell[BoxData[
    \(\(mymat = {{i, j, k}, {1, 2, 3}, {\(-1\), 0, \(-1\)}}; \)\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "We format matrices and arbitrary arrays of elements using ",
  StyleBox["MatrixForm", "Input"],
  " and ",
  StyleBox["TableForm", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(MatrixForm[mymat]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "See also ",
  StyleBox["Part", "Input"],
  ", ",
  StyleBox["Extract", "Input"],
  ", ",
  StyleBox["Take", "Input"],
  ", ",
  StyleBox["Drop", "Input"],
  ", ",
  StyleBox["Append", "Input"],
  ", ",
  StyleBox["AppendTo", "Input"],
  ", ",
  StyleBox["Prepend", "Input"],
  ", ",
  StyleBox["PrependTo", "Input"],
  ", ",
  StyleBox["Insert", "Input"],
  ", ",
  StyleBox["Delete", "Input"],
  ", ",
  StyleBox["Join", "Input"],
  ", ",
  StyleBox["Intersection", "Input"],
  ", ",
  StyleBox["Union", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Functions with Lists", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides many functions designed to allow functions and lists to work \
together."
}], "Text"],

Cell[TextData[{
  "One such function is ",
  StyleBox["Map", "Input"],
  ", which applies a function to each element of a list. Here is a simple \
function."
}], "Text"],

Cell[BoxData[
    \(nlp[x_Integer] := N[Log[Prime[x]]]\)], "Input"],

Cell[TextData[{
  "To apply the function to each element of a list of integers, we use ",
  StyleBox["Map", "Input"],
  ". Notice that we give only the name of the function (",
  StyleBox["nlp", "Input"],
  ") as the first argument to ",
  StyleBox["Map", "Input"],
  ", and not ",
  StyleBox["nlp[x]", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Map[nlp, Range[5]]\)], "Input"],

Cell[TextData[{
  "There is a special class of functions called ",
  StyleBox["predicate functions",
    FontSlant->"Italic"],
  ", each of which returns ",
  StyleBox["True", "Input"],
  " or ",
  StyleBox["False", "Input"],
  " depending on whether its condition is met. All the built-in predicate \
functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " end with the letter Q. Here are the names of all the built-in functions \
that end with the letter Q (not all of them are predicate functions)."
}], "Text"],

Cell[BoxData[
    \(Names["\<*Q\>"]\)], "Input"],

Cell["\<\
Here are some predicate functions applied to the number 101. Here \
we check if 101 is prime.\
\>", "Text"],

Cell[BoxData[
    \(PrimeQ[101]\)], "Input"],

Cell["Here we determine if 101 is even.", "Text"],

Cell[BoxData[
    \(EvenQ[101]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a function called ",
  StyleBox["Select", "Input"],
  " that extracts all the elements of a list that satisfy a particular \
predicate function. For example, we extract all the prime elements of a list \
of integers from 1 to 100. (Notice again that we use only the name of the \
predicate function.)"
}], "Text"],

Cell[BoxData[
    \(Select[Range[100], PrimeQ]\)], "Input"],

Cell[TextData[{
  "We can define our own predicate functions. The following predicate \
function returns ",
  StyleBox["True", "Input"],
  " for numbers between 0.33 and 0.66."
}], "Text"],

Cell[BoxData[
    \(middlethird[x_] := 0.33 < x < 0.66\)], "Input"],

Cell[TextData[{
  "Given a list of numbers, we can select all the numbers that satisfy ",
  StyleBox["middlethird", "Input"],
  ". Here is a list of 25 random real numbers between 0 and 1."
}], "Text"],

Cell[BoxData[
    \(randompoints = Table[Random[], {25}]\)], "Input"],

Cell[TextData[{
  "Here is the subset of ",
  StyleBox["randompoints", "Input"],
  " whose elements satisfy ",
  StyleBox["middlethird", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Select[randompoints, middlethird]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Cases", "Input"],
  ", ",
  StyleBox["MemberQ", "Input"],
  ", ",
  StyleBox["FreeQ", "Input"],
  ", ",
  StyleBox["Count", "Input"],
  ", ",
  StyleBox["Position", "Input"],
  ", ",
  StyleBox["DeleteCases", "Input"],
  " "
}], "SeeAlso"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Section"],

Cell[CellGroupData[{

Cell["Two-Dimensional Graphics", "Subsection"],

Cell[CellGroupData[{

Cell["Plot", "Subsubsection"],

Cell[TextData[{
  "The simplest example of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s graphing capabilities is a graph of a function of one \
variable created with ",
  StyleBox["Plot", "Input"],
  ". ",
  StyleBox["Plot", "Input"],
  " takes a function to be graphed and a domain for the variable, and \
generates a two-dimensional graph."
}], "Text"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, \(-10\), 10}]\)], "Input"],

Cell[TextData[{
  StyleBox["Plot", "Input"],
  " also accepts a list of functions to plot on the same set of axes."
}], "Text"],

Cell[BoxData[
    \(\(Plot[{Sin[x], Cos[x]}, {x, \(-\[Pi]\), \[Pi]}]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Subsubsection"],

Cell[TextData[{
  "There are dozens of options we can use to control almost every aspect of a \
graph. ",
  Cell[TextData[{
    "Options[",
    StyleBox["FunctionName",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"],
    "]"
  }], "Input"],
  " returns a list of the options available for a function, along with their \
default values."
}], "Text"],

Cell[BoxData[
    \(Options[Plot]\)], "Input"],

Cell[TextData[{
  "For example, by default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses an algorithm to choose the most \[OpenCurlyDoubleQuote]interesting\
\[CloseCurlyDoubleQuote] ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-range for a graph. In the above list we see that the default value for ",
  StyleBox["PlotRange", "Input"],
  " is ",
  StyleBox["Automatic", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x\^2]/x\^2, {x, \(-10\), 10}]; \)\)], "Input"],

Cell[TextData[{
  "We can override the default setting by giving a different value to the ",
  StyleBox["PlotRange", "Input"],
  " option."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x\^2]/x\^2, {x, \(-10\), 10}, \ 
      PlotRange -> {\(-0.25\), 1.05}]; \)\)], "Input"],

Cell[TextData[{
  "In every case, options are added after the required arguments to the \
function. We set an option by typing the name of the option, an arrow made by \
the two characters ",
  StyleBox["-", "Input"],
  " and ",
  StyleBox[">", "Input"],
  " (or the special character ",
  StyleBox["\[Rule]", "Input"],
  " made by typing \[EscapeKey]",
  StyleBox["->", "Input"],
  "\[EscapeKey]), and the new value of the option. Note that most plotting \
commands accept the same set of options."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, \ {x, \(-10\), 10}, \ Frame -> True, \ 
      PlotLabel -> "\<sinc function\>", \ GridLines -> Automatic, \ 
      PlotRange -> {{\(-11\), 11}, {\(-0.5\), 1.15}}, \n\tAspectRatio -> 1]; 
    \)\)], "Input"],

Cell[TextData[
"In the following sections we will change many of a graph\[CloseCurlyQuote]s \
default option settings."], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["SetOptions", "Input"],
  ", ",
  StyleBox["FullOptions", "Input"],
  ", ",
  StyleBox["FullGraphics", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["ParametricPlot", "Subsubsection"],

Cell[TextData[{
  StyleBox["ParametricPlot", "Input"],
  " plots a two-dimensional curve described by two functions of the same \
parameter, one that describes movement in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " direction and one for the ",
  StyleBox["y",
    FontSlant->"Italic"],
  " direction. This allows us to plot curves that are not functions, in the \
mathematical sense. Here is a parametric plot of a circle."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{Sin[t], Cos[t]}, {t, 0, 2\ \[Pi]}]; \)\)], "Input"],

Cell[TextData[{
  "The option ",
  StyleBox["AspectRatio", "Input"],
  " controls the relative sizes of units on the two axes; the setting ",
  StyleBox["Automatic", "Input"],
  " makes them equal (that is, makes one unit on the vertical axis equal to \
one unit on the horizontal axis)."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{Sin[t], Cos[t]}, {t, 0, 2\ \[Pi]}, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["ParametricPlot", "Input"],
  " can be used to plot graphs of complicated curves that cannot be expressed \
as a function of the form ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{4\ Cos[\(-5\)\ t/4] + 7\ Cos[t], 
        4\ Sin[\(-5\)\ t/4] + 7\ Sin[t]}, {t, 0, 8\ \[Pi]}, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["ParametricPlot", "Input"],
  " takes many of the same options as ",
  StyleBox["Plot", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{4\ Cos[\(-11\)\ t/4] + 7\ Cos[t], 
        4\ Sin[\(-11\)\ t/4] + 7\ Sin[t]}, {t, 0, 8\ \[Pi]}, 
      AspectRatio \[Rule] Automatic, \ Axes -> False, Frame -> True, 
      FrameLabel -> {"\<x\>", "\<y\>"}]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["ImplicitPlot", "Subsubsection"],

Cell[TextData[{
  StyleBox["ImplicitPlot", "Input"],
  " allows us to plot implicit relations, rather than functions. It is \
defined in one of the standard packages, so we must load it first with the ",
  StyleBox["Needs", "Input"],
  " command."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`ImplicitPlot`\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["ImplicitPlot[", "Input"],
  StyleBox["eqn",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["}]", "Input"],
  " draws a graph of the set of points that satisfy ",
  StyleBox["eqn",
    FontSlant->"Italic"],
  ". The variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is associated with the horizontal axis and ranges from ",
  StyleBox["a",
    FontSlant->"Italic"],
  " to ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". The remaining variable in the equation is associated with the vertical \
axis. We can also specify a vertical range for the graph using the form ",
  StyleBox["ImplicitPlot[", "Input"],
  StyleBox["eqn",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["},", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["{", "Input"],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["c",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSize->11],
  StyleBox["d",
    FontSlant->"Italic"],
  StyleBox["}]", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ImplicitPlot[3\ x\^2 + 3\ x\ y + 12\ y\^2 == 12, {x, \(-2.5\), 2.5}, 
      AxesOrigin \[Rule] {0, 0}]; \)\)], "Input"],

Cell[TextData[{
  "Like most graphing functions, ",
  StyleBox["ImplicitPlot", "Input"],
  " accepts a list of functions to plot on the same set of axes."
}], "Text"],

Cell[BoxData[
    \(\(ImplicitPlot[{3\ x\^2 + 3\ x\ y + 12\ y\^2 == 12, 
        12\ x\^2 + 3\ x\ y + 3\ y\^2 == 12, 
        3\ x\^2 + 12\ x\ y + 3\ y\^2 == 1}, {x, \(-2.5\), 2.5}, {y, \(-2.5\), 
        2.5}, AxesOrigin \[Rule] {0, 0}]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics Directives and Plot Styles", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains several objects called ",
  StyleBox["graphics directives",
    FontSlant->"Italic"],
  ", which specify the style in which a graph should be drawn. Graphics \
directives control the color, thickness, point size, and dashing of a lines, \
points, and other objects."
}], "Text"],

Cell[TextData[{
  "For example, to specify that lines should be drawn with a specified \
thickness, we use the directive ",
  StyleBox["Thickness[", "Input"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ", where ",
  StyleBox["t",
    FontSlant->"Italic"],
  " is given as a percentage of the width of a graph."
}], "Text"],

Cell[TextData[{
  "All two-dimensional graphing functions have an option called ",
  StyleBox["PlotStyle", "Input"],
  ", which allows us to specify a list of graphics directives that control \
how the actual curve (as opposed to the surrounding axes, grid lines, etc.) \
is drawn. To draw a sine wave so that the curve is drawn with a thickness 2% \
of the width of the graph, we set the option ",
  StyleBox["PlotStyle\[NonBreakingSpace]-> Thickness[0.02]", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x], {x, \(-3\), 3}, PlotStyle -> {Thickness[0.02]}]; \)\)], 
  "Input"],

Cell[TextData[{
  "To draw a curve with a dashed line, we use the directive ",
  StyleBox["Dashing", "Input"],
  ". ",
  StyleBox["Dashing[{", "Input"],
  StyleBox["d",
    FontSlant->"Italic"],
  StyleBox["}]", "Input"],
  " draws a line so that it alternates between line segments ",
  StyleBox["d",
    FontSlant->"Italic"],
  " percent of the width of the graph and gaps ",
  StyleBox["d",
    FontSlant->"Italic"],
  " percent of the width of the graph. ",
  StyleBox["Dashing[{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`d\_1\)]],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`d\_2\)]],
  StyleBox["}]", "Input"],
  " alternates between line segments ",
  Cell[BoxData[
      \(TraditionalForm\`d\_1\)]],
  " long and gaps ",
  Cell[BoxData[
      \(TraditionalForm\`d\_2\)]],
  " long, and ",
  StyleBox["Dashing[{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`d\_1\)]],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`d\_2\)]],
  StyleBox[",", "Input"],
  "\[Ellipsis]",
  StyleBox["}]", "Input"],
  " applies the successive widths cyclically. The following graph uses line \
segments twice as long as the gaps."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x], {x, \(-3\), 3}, PlotStyle -> {Dashing[{0.04, 0.02}]}]; 
    \)\)], "Input"],

Cell[TextData[{
  "There are several ways to specify colors using graphics directives. ",
  StyleBox["RGBColor[", "Input"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["g",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " describes a color made up of ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["b",
    FontSlant->"Italic"],
  " percent of red, green, and blue. Thus ",
  Cell["RGBColor[1,0,0]", "Input"],
  " is red, and ",
  Cell["RGBColor[1,0,1]", "Input"],
  " is purple. (The parameters ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["b",
    FontSlant->"Italic"],
  " must all be between 0 and 1.)"
}], "Text"],

Cell[TextData[{
  "The add-on package ",
  StyleBox["Graphics`Colors`", "Input"],
  " defines a list of English names for colors and their ",
  StyleBox["RGBColor", "Input"],
  " values. Here we load the package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Colors`\>"]\)], "Input"],

Cell["Here are the first ten colors defined in the package.", "Text"],

Cell[BoxData[
    \(Take[AllColors, 10]\)], "Input"],

Cell[TextData[{
  "Here is the ",
  StyleBox["RGBColor", "Input"],
  " value of the color apricot."
}], "Text"],

Cell[BoxData[
    \(Apricot\)], "Input"],

Cell[TextData[{
  "Other color functions are ",
  StyleBox["Hue[", "Input"],
  StyleBox["h",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ", which represents the spectrum of colors going through red, orange, \
yellow, green, blue, purple, and back to red; and ",
  StyleBox["GrayLevel[", "Input"],
  StyleBox["g",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] g \[LessEqual] 1\)]],
  "), where ",
  StyleBox["GrayLevel[0]", "Input"],
  " is black and ",
  StyleBox["GrayLevel[1]", "Input"],
  " is white."
}], "Text"],

Cell[TextData[{
  "To change the style of each graph in a list given to ",
  StyleBox["Plot", "Input"],
  ", we give a list containing as many graphics directives as there are \
functions being plotted. Here we draw the first curve in the list using a \
thick line (",
  Cell["Thickness[0.02]", "Input"],
  "), and the second curve using a green line (",
  Cell[BoxData[
      \(RGBColor[0, 1, 0]\)], "Input"],
  ")."
}], "Text"],

Cell[BoxData[
    \(\(Plot[{Sin[x], Cos[x]}, {x, \(-3\), 3}, 
      PlotStyle -> {Thickness[0.02], RGBColor[0, 1, 0]}]; \)\)], "Input"],

Cell["\<\
To apply multiple styles to each function in a list, we surround \
the styles that apply to each function inside a set of list brackets.\
\>", 
  "Text"],

Cell[BoxData[
    \(\(Plot[{Sin[x], Cos[x]}, {x, \(-3\), 3}, 
      PlotStyle -> {{Thickness[0.02], Apricot}, {Dashing[{0.04, 0.02}], 
            Green}}]; \)\)], "Input"],

Cell[TextData[{
  "One tricky case to be aware of is that to specify more than one graphics \
directive in the plot style of a single function, we must surround the \
graphics directives with double list brackets ",
  Cell["{{", "Input"],
  " and ",
  Cell["}}", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, {x, \(-10\), 10}, \n\t
      PlotStyle \[Rule] {{RGBColor[0, 0, 1], Thickness[0.015]}}]; \)\)], 
  "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["PointSize", "Input"],
  ", ",
  StyleBox["CMYKColor", "Input"],
  ", ",
  StyleBox["AbsoluteThickness", "Input"],
  ", ",
  StyleBox["AbsolutePointSize", "Input"],
  ", ",
  StyleBox["Graphics`ArgColors`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Combining Graphs", "Subsubsection"],

Cell[TextData[{
  StyleBox["Show", "Input"],
  " allows us to display a previously computed graph without having to \
recompute any of the points that make up the curve(s)."
}], "Text"],

Cell[TextData[{
  StyleBox["Show[", "Input"],
  StyleBox["graphics",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["options",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " displays two- and three-dimensional graphics using the new option \
settings specified. ",
  StyleBox["Show", "Input"],
  " accepts options that affect the way a graph or its surrounding elements \
(axes, frame, etc.) is drawn, without requiring any points of the graph to be \
recomputed."
}], "Text"],

Cell[BoxData[
    \(\(p1\  = \ Plot[\ Sin[x]/x, \ {x, \ \(-10\), 10}]; \)\)], "Input"],

Cell[TextData[{
  "None of the options given below require points on the graph to be \
recomputed, so we can use them inside ",
  StyleBox["Show", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[p1, Frame \[Rule] True, AxesStyle \[Rule] Hue[0], 
      PlotRange \[Rule] {\(-0.1\), 0.8}, PlotLabel \[Rule] "\<p1\>"]; \)\)], 
  "Input"],

Cell[TextData[{
  "When given a list of graphics, ",
  StyleBox["Show", "Input"],
  " combines them onto the same set of axes. Here is another two-dimensional \
plot."
}], "Text"],

Cell[BoxData[
    \(\(p2 = 
      Plot[BesselJ[2, x], {x, \(-10\), 10}, 
        PlotStyle \[Rule] {GrayLevel[0.5]}]; \)\)], "Input"],

Cell[TextData[{
  "We combine ",
  StyleBox["p1", "Input"],
  " and ",
  StyleBox["p2", "Input"],
  " by placing their names in a list and giving the list to ",
  StyleBox["Show", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[{p1, p2}]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Show", "Input"],
  " also combines three-dimensional graphics. Here are two three-dimensional \
graphs."
}], "Text"],

Cell[BoxData[
    \(p3 = Plot3D[1 - x, {x, 0, 1}, {y, 0, 1}, ColorFunction \[Rule] Hue]; \n
    p4 = Plot3D[y, {x, 0, 1}, {y, 0, 1}, ColorFunction \[Rule] GrayLevel]; 
    \)], "Input"],

Cell[TextData[{
  "We put them in the same box using ",
  StyleBox["Show", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[{p3, p4}]; \)\)], "Input"],

Cell[TextData[{
  "The object ",
  StyleBox["GraphicsArray", "Input"],
  " takes an array of graphs, and when used with ",
  StyleBox["Show", "Input"],
  " displays the graphs in an array. Here is an array containing the four \
previous graphs."
}], "Text"],

Cell[BoxData[
    \(\(Show[GraphicsArray[{{p1, p3}, {p4, p2}}], 
      ImageSize \[Rule] {400, 250}]; \)\)], "Input"],

Cell[TextData[{
  "The package ",
  StyleBox["Graphics`Graphics`", "Input"],
  " defines functions ",
  StyleBox["DisplayTogether", "Input"],
  " and ",
  StyleBox["DisplayTogetherArray", "Input"],
  ", which allow us to combine graphs on the same set of axes or in an array \
without rendering each graph beforehand. To use the functions we first load \
the package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Graphics`\>"]\)], "Input"],

Cell[BoxData[
    \(\(DisplayTogether[
      Plot[Sin[x], {x, \(-3\), 3}, PlotStyle -> GrayLevel[0.5]], 
      Plot[Sin[3  x], {x, \(-3\), 3}, PlotStyle -> Dashing[{0.01}]]]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(DisplayTogetherArray[
      Plot[Sin[x], {x, \(-3\), 3}, PlotStyle -> GrayLevel[0.5]], 
      Plot[Sin[3  x], {x, \(-3\), 3}, PlotStyle -> Dashing[{0.01}]]]; \)\)], 
  "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["DisplayFunction", "Input"],
  ", ",
  StyleBox["$DisplayFunction", "Input"],
  ", ",
  StyleBox["Identity", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Draws a Graph"
}], "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses an adaptive sampling algorithm to choose the points sampled in a \
two-dimensional plot. Beginning with 25 equally spaced points dividing the \
domain to be plotted, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks at each set of three consecutive points and computes the angle \
between the line segment joining the first and second points and the line \
segment joining the second and third points. If this angle is close to 180 \
degrees, then ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " connects the points with lines. If not, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " subdivides that interval and tries again. This allows ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to sample more points in a \[OpenCurlyDoubleQuote]curvy\
\[CloseCurlyDoubleQuote] section of the function than in a flat section."
}], "Text"],

Cell[TextData[{
  "This process can be controlled by the options ",
  StyleBox["PlotDivision", "Input"],
  ", which is the upper limit on the number of times an interval will be \
divided, and ",
  StyleBox["PlotPoints", "Input"],
  ", which sets the initial number of points to be sampled."
}], "Text"],

Cell["\<\
Although this is a very robust algorithm, which produces accurate \
results in most cases, any scheme using a finite number of sampled points is \
prone to miss sometimes. Here is an example of a function that is plotted \
incorrectly using the default number of plot points, but which can be \
accurately plotted by raising the initial number of plot points used.\
\>", 
  "Text"],

Cell[BoxData[
    \(\(Plot[x + Sin[2\ \[Pi]\ x], {x, 0, 25}]; \)\)], "Input"],

Cell[BoxData[
    \(\(Plot[x + Sin[2\ \[Pi]\ x], {x, 0, 25}, PlotPoints \[Rule] 50]; \)\)], 
  "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Two-Dimensional Graphics", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Load the package ",
  Cell["Graphics`Master`", "Input",
    FontFamily->"Courier"],
  ". This loads the name of every function defined in a graphics package into \
memory, and tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to load the appropriate package when a package function is first used."
}], "Question"],

Cell[BoxData[
    \(Needs["\<Graphics`Master`\>"]\)], "Input"],

Cell[TextData[{
  "Make a simple two-dimensional plot of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 20 \( cos(x\^2)\)\)]],
  " between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-10\)\)]],
  " and 10. (If there are obvious flaws in the graph, plot it again using \
more plot points.)"
}], "Question"],

Cell[BoxData[
    \(\(Plot[x\^2 - 20\ Cos[x\^2], {x, \(-10\), 10}]; \)\)], "Input"],

Cell[TextData[{
  "Use ",
  Cell["Options[Plot]", "Input"],
  " or the on-line help to find a list of all the options that ",
  StyleBox["Plot", "Input"],
  " accepts. Plot the same function as above, this time changing at least \
five of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s default options."
}], "Question"],

Cell[BoxData[
    \(\(Plot[x\^2 - 20\ Cos[x\^2], {x, \(-10\), 10}, PlotPoints \[Rule] 75, 
      Frame \[Rule] True, GridLines \[Rule] Automatic, 
      PlotLabel \[Rule] "\<exercise one\>", AspectRatio \[Rule] 0.5]; \)\)], 
  "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Three-Dimensional Graphics", "Subsection"],

Cell[CellGroupData[{

Cell["Plot3D", "Subsubsection"],

Cell[TextData[{
  StyleBox["Plot3D", "Input"],
  " is the three-dimensional analog of the ",
  StyleBox["Plot", "Input"],
  " command. Given a function of two variables and a domain for each \
variable, ",
  StyleBox["Plot3D", "Input"],
  " produces a surface plot."
}], "Text"],

Cell[BoxData[
    \(Plot3D[Sin[x - Cos[y]], {x, \(-3\), 3}, {y, \(-3\), 3}]\)], "Input"],

Cell["\<\
Applying options to three-dimensional graphics works the same as \
with two-dimensional graphics; in fact, many of the options are the \
same.\
\>", "Text"],

Cell[TextData[{
  "One of the differences between two- and three-dimensional plotting in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is point sampling. Instead of adaptive sampling, three-dimensional plots \
rely on a fixed grid of points at which to evaluate the function. By default, \
a 15 \[Times] 15 grid is used, resulting in ",
  Cell[BoxData[
      \(TraditionalForm\`15\^2 = 225\)]],
  " points plotted; raising this number results in a smoother graph, but \
takes more time and memory to generate."
}], "Text"],

Cell["Here is a smoother graph of the same function as above.", "Text"],

Cell[BoxData[
    \(\(Plot3D[Sin[x - Cos[y]], {x, \(-3\), 3}, {y, \(-3\), 3}, 
      Axes \[Rule] False, FaceGrids \[Rule] All, PlotPoints \[Rule] 25]; 
    \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["HiddenSurface", "Input"],
  ", ",
  StyleBox["RenderAll", "Input"],
  ", ",
  StyleBox["Lighting", "Input"],
  ", ",
  StyleBox["ColorFunction", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing the Viewpoint", "Subsubsection"],

Cell[TextData[{
  "One important option to three-dimensional plotting functions is the \
viewpoint, the point in space from which the observer looks at the object. ",
  Cell["ViewPoint", "Input"],
  " is an option to all three-dimensional graphics functions. Its default \
value is ",
  Cell[BoxData[
      \({1.3, \(-2.4\), 2.0}\)], "Input"],
  ",",
  " which can be changed by entering a new value directly as an option."
}], "Text"],

Cell[BoxData[
    \(\(Show[%, ViewPoint \[Rule] {0, 3, 2}]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides an easier way to do this using the 3D ViewPoint Selector. To use \
this front-end feature we pull down the Input menu and choose ",
  StyleBox["3D ViewPoint Selector", "MenuItem"],
  ". Rotating the box with the mouse will have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " compute the point from which to view the object. The ",
  StyleBox["Paste", "MenuItem"],
  " button enters the view point at the current text insertion point."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["ParametricPlot3D", "Subsubsection"],

Cell[TextData[{
  StyleBox["ParametricPlot3D", "Input"],
  " is the three-dimensional analog of ",
  StyleBox["ParametricPlot", "Input"],
  ". Depending on the input, ",
  StyleBox["ParametricPlot3D", "Input"],
  " produces a space curve or a surface."
}], "Text"],

Cell[TextData[{
  "When we give ",
  StyleBox["ParametricPlot3D", "Input"],
  " a list of three parametric functions in one parameter, the result is a \
space curve."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Sin[t], Cos[t], t/3}, {t, 0, 6\ \[Pi]}, 
      Axes \[Rule] False]; \)\)], "Input"],

Cell["\<\
A list of three parametric functions in two parameters results in a \
surface.\
\>", "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Sin[v]\ Cos[u], Sin[v]\ Sin[u], Cos[v]}, {u, 0, 
        1.5  \[Pi]}, {v, 0, \[Pi]}]; \)\)], "Input"],

Cell[TextData[{
  "Like most graphing functions, ",
  StyleBox["ParametricPlot3D", "Input"],
  " accepts a list of sets of parametric equations and plots the surfaces \
together."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{{Sin[v]\ Cos[u], Sin[v]\ Sin[u], Cos[v]}, {\ 
          Sin[v]\ Cos[4  u/3]/2, \ Sin[v]\ Sin[4  u/3]/2, Cos[v]/2}}, {u, 0, 
        1.5  \[Pi]}, {v, 0, \[Pi]}]; \)\)], "Input"],

Cell[TextData[{
  "Options are given to ",
  StyleBox["ParametricPlot3D", "Input"],
  " the same way as for ",
  StyleBox["Plot3D", "Input"],
  ". Most of the options are the same."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Three-Dimensional Graphics", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Make a three-dimensional plot of the function ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x + sin(y))\)]],
  " between ",
  Cell[BoxData[
      \(\(-3\)\)]],
  " and ",
  StyleBox["3", "Input"],
  " on both axes."
}], "Question"],

Cell[BoxData[
    \(\(Plot3D[Sin[x + Sin[y]], {x, \(-3\), 3}, {y, \(-3\), 3}]; \)\)], 
  "Input"],

Cell[TextData[{
  "Evaluate ",
  StyleBox["Options[Plot3D]", "Input"],
  " or use the on-line help to find a list of all the options that ",
  StyleBox["Plot3D", "Input"],
  " accepts. Plot the same function again, this time changing at least four \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s default options, including the options that control \
the smoothness of the plot and the color."
}], "Question"],

Cell[BoxData[
    \(\(changedplot3d = 
      Plot3D[Sin[x + Sin[y]], {x, \(-3\), 3}, {y, \(-3\), 3}, 
        PlotPoints \[Rule] {15, 45}, Mesh \[Rule] False, 
        ColorFunction \[Rule] Hue, FaceGrids \[Rule] All]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contour and Density Graphics", "Subsection"],

Cell[CellGroupData[{

Cell["ContourPlot and DensityPlot", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " plots contour and density plots of functions of two or three variables. \
With the exception of special options that apply only to these types of \
graphics, these functions work very much like ",
  StyleBox["Plot", "Input"],
  " and ",
  StyleBox["Plot3D", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["ContourPlot", "Input"],
  " displays a graphics of a function of two variables, where regions of \
different intensities of gray have (nearly) the same function value."
}], "Text"],

Cell[BoxData[
    \(\(ContourPlot[Exp[x] Sin[y], {x, \(-3\), 3}, {y, \(-3\), 3}]; \)\)], 
  "Input"],

Cell[TextData[{
  StyleBox["DensityPlot", "Input"],
  " by default generates a grid of gray levels, where the lighter gray areas \
have greater function values than the darker gray areas."
}], "Text"],

Cell[BoxData[
    \(\(DensityPlot[Exp[x]\ Sin[y], {x, \(-3\), 3}, {y, \(-3\), 3}]; \)\)], 
  "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["ColorFunction", "Input"],
  ", ",
  StyleBox["Mesh", "Input"],
  ", ",
  StyleBox["Contours", "Input"],
  ", ",
  StyleBox["ContourLines", "Input"],
  ", ",
  StyleBox["ContourStyle", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["ContourPlot3D", "Subsubsection"],

Cell[TextData[{
  "The function ",
  StyleBox["ContourPlot3D", "Input"],
  " provides a way to plot surfaces showing particular values of a function \
of three variables. This function is defined in one of the standard add-on \
packages, so we must load the package before using the function."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`ContourPlot3D`\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["ContourPlot3D[", "Input"],
  StyleBox["fun",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1\)]],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`z\_0\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`z\_1\)]],
  StyleBox["}]", "Input"],
  " plots the surface implicitly defined by ",
  StyleBox["fun[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " ",
  StyleBox["==", "Input"],
  " ",
  StyleBox["0", "Input"],
  ". Setting the option ",
  StyleBox["Contours", "Input"],
  " to ",
  StyleBox["{", "Input"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            FontSlant->"Italic"], "2"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " \[Ellipsis] ",
  StyleBox["}", "Input"],
  "  plots the level surfaces corresponding to the values ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["val",
            FontSlant->"Italic"], "2"], TraditionalForm]]],
  ", \[Ellipsis]"
}], "Text"],

Cell[BoxData[
    \(\(ContourPlot3D[
      Sqrt[x\^2 + y\^2 + z\^2], {x, \(-1\), 1}, {y, 0, 1}, {z, 0, 1}, 
      Contours \[Rule] {0.25, 0.5, 0.75}]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Contour and Density Graphics", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Create a density plot of the function ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x - sin(y))\)]],
  " over any range that includes the origin. Render the graphic with twice as \
many plot points. Experiment with other options."
}], "Question"],

Cell[BoxData[
    \(\(DensityPlot[Sin[x - Sin[y]], {x, \(-10\), 10}, {y, \(-10\), 10}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(DensityPlot[Sin[x - Sin[y]], {x, \(-10\), 10}, {y, \(-10\), 10}, 
      PlotPoints \[Rule] 30, Mesh -> False, 
      FrameLabel -> {"\<x\>", "\<y\>"}]; \)\)], "Input"],

Cell[TextData[{
  "Repeat the above exercise using ",
  StyleBox["ContourPlot", "Input",
    FontFamily->"Courier"],
  " instead of ",
  StyleBox["DensityPlot", "Input",
    FontFamily->"Courier"],
  ". Experiment with the options to ",
  StyleBox["ContourPlot", "Input"],
  " that do not apply to ",
  StyleBox["DensityPlot", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[BoxData[
    \(\(ContourPlot[Sin[x - Sin[y]], {x, \(-10\), 10}, {y, \(-10\), 10}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ContourPlot[Sin[x - Sin[y]], {x, \(-10\), 10}, {y, \(-10\), 10}, 
      PlotPoints \[Rule] 30, Contours \[Rule] 30, 
      ContourLines \[Rule] False]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotting Data", "Subsection"],

Cell["\<\
There are many occasions when we want to work with data rather than \
functions. There are several functions designed to visualize data in two or \
three dimensions. For these examples, we need data to work with. In practice, \
we would most likely read this data from a file or use the output of other \
calculations. For this demonstration we will create a list of ordered pairs \
to use as data.\
\>", "Text"],

Cell[BoxData[
    \(\(exampleData = 
      N[Table[{n, n + Sin[n] + Random[]}, {n, 0, 5\ \[Pi], 0.2  \[Pi]}]]; 
    \)\)], "Input"],

Cell[TextData[{
  StyleBox["ListPlot", "Input"],
  " takes a vector or array of data and plots it in two dimensions. Given a \
one-dimensional set of data such as ",
  Cell[BoxData[
      \({10, 20, 30, 40}\)], "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " plots the ordered pairs ",
  Cell[BoxData[
      \({{1, 10}, {2, 20}, {3, 30}, {4, 40}}\)], "Input"],
  ". In this case, we supply a list of ordered pairs and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " plots the points using our explicit ",
  StyleBox["x",
    FontSlant->"Italic"],
  " values. (The graphics directive ",
  StyleBox["PointSize[", "Input"],
  StyleBox["p",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " specifies that points should be drawn so they are ",
  StyleBox["p",
    FontSlant->"Italic"],
  " percent of the width of the graph.)"
}], "Text"],

Cell[BoxData[
    \(\(pointplot = ListPlot[exampleData, PlotStyle \[Rule] PointSize[0.02]]; 
    \)\)], "Input"],

Cell[TextData[{
  "Options to ",
  StyleBox["ListPlot", "Input"],
  " include nearly all of those applicable to ",
  StyleBox["Plot", "Input"],
  ". One exception is the option ",
  StyleBox["PlotJoined", "Input"],
  ", which when set to ",
  StyleBox["True", "Input"],
  " draws a line connecting each of the points."
}], "Text"],

Cell[BoxData[
    \(\(joinedplot = 
      ListPlot[exampleData, PlotJoined \[Rule] True, 
        PlotStyle \[Rule] RGBColor[0, 0, 1]]; \)\)], "Input"],

Cell[TextData[{
  "At this point in our analysis we can easily find a good least-squares fit \
to this data. The function ",
  StyleBox["Fit", "Input"],
  " takes as arguments a set of data, a set of basis functions for the \
best-fit polynomial, and a list of variables to be used. Below we include \
only constant, linear, and quadratic terms for the best-fit function."
}], "Text"],

Cell[BoxData[
    \(exampleFit = Fit[exampleData, {1, x, x\^2}, x]\)], "Input"],

Cell["Here is a plot of the best-fit quadratic polynomial.", "Text"],

Cell[BoxData[
    \(\(fitplot = 
      Plot[exampleFit, {x, 0, 5\ \[Pi]}, PlotStyle -> Dashing[{0.01}]]; \)\)],
   "Input"],

Cell["Here we combine the previous three graphs.", "Text"],

Cell[BoxData[
    \(\(Show[{pointplot, joinedplot, fitplot}]; \)\)], "Input"],

Cell[TextData[{
  "When working with three-dimensional data, we use analogs to ",
  StyleBox["Plot3D", "Input"],
  ", ",
  StyleBox["DensityPlot", "Input"],
  ", and ",
  StyleBox["ContourPlot", "Input"],
  ". ",
  StyleBox["ListPlot3D", "Input"],
  " plots a three-dimensional surface from a rectangular array of height \
values."
}], "Text"],

Cell[BoxData[
    \(\(examplearray = 
      Table[n + Sin[n] + 3\ Random[], {i, 1, 5\ \[Pi], 0.3  \[Pi]}, {n, 1, 
          5\ \[Pi], 0.3  \[Pi]}]; \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot3D[examplearray]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["ListContourPlot", "Input"],
  " and ",
  StyleBox["ListDensityPlot", "Input"],
  " create density and contour plots from rectangular arrays of data."
}], "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[examplearray]; \)\)], "Input"],

Cell[CellGroupData[{

Cell["Exercises: Plotting Data", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Create tabular data from the curve ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(cos(x)\) - sin(x\^2)\)]],
  " between ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-2\) \[Pi]\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`x = 2  \[Pi]\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and display the data using ",
  StyleBox["ListPlot", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[BoxData[
    \(\(mydata = 
      Table[N[{x, x\ Cos[x] - Sin[x\^2]}], {x, \(-2\)\ \[Pi], 2\ \[Pi], 
          0.05  \[Pi]}]; \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[mydata, PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[TextData[{
  "Create a list of the first twenty prime numbers. (Hint: use ",
  StyleBox["Table", "Input",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Prime[", "Input"],
  StyleBox["n", "Text",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ", which gives the ",
  Cell[BoxData[
      \(TraditionalForm\`n\^th\)]],
  " prime number.) Plot the list using ",
  StyleBox["ListPlot", "Input"],
  ", then fit the data to a quadratic polynomial, and plot the data and the \
best-fitting curve on the same set of axes. Use options to change the color \
and other aspects of the graphic."
}], "Question"],

Cell[BoxData[
    \(primes = Table[Prime[n], {n, 1, 20}]\)], "Input"],

Cell[BoxData[
    \(\(pointplot = 
      ListPlot[primes, PlotStyle \[Rule] {Red, PointSize[0.02]}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(fitline = Fit[primes, {1, x, x\^2}, x]\)], "Input"],

Cell[BoxData[
    \(\(fitplot = Plot[fitline, {x, 0, 20}, PlotStyle \[Rule] {Blue}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Show[{pointplot, fitplot}]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics Primitives", "Subsection"],

Cell[TextData[{
  "In addition to the high-level plotting functions just described, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows us to build up graphics in two and three dimensions from the basic \
building blocks of points, lines, circles, and so on. These building blocks \
are called ",
  StyleBox["graphics primitives",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
Graphics primitives are the actual objects that are drawn, while \
graphics directives control the style in which an object is drawn.\
\>", 
  "Text"],

Cell["\<\
First we look at an example in two dimensions. The following syntax \
is used to render a series of graphics primitives.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Show",
          "Input"], 
        StyleBox["[",
          "Input"], 
        RowBox[{
          StyleBox["Graphics",
            "Input"], 
          StyleBox["[",
            "Input"], 
          RowBox[{
            StyleBox["{",
              "Input"], 
            StyleBox[\(graphics\ primitives\ and\ directives\),
              FontFamily->"Times",
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["}",
              "Input"]}], 
          StyleBox["]",
            "Input"]}], 
        StyleBox["]",
          "Input"]}], 
      StyleBox[" ",
        "Input"]}]], "Input"],

Cell[TextData[{
  "The primitives ",
  StyleBox["Point", "Input"],
  ", ",
  StyleBox["Line", "Input"],
  ", ",
  StyleBox["Polygon", "Input"],
  ", ",
  StyleBox["Text", "Input"],
  ", ",
  StyleBox["Rectangle", "Input"],
  ", ",
  StyleBox["Cuboid", "Input"],
  ",  ",
  StyleBox["Circle", "Input"],
  ", and ",
  StyleBox["Disk", "Input"],
  " form the basis for most graphics."
}], "Text"],

Cell[TextData[{
  Cell["Circle[{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox["},", "Input"],
  " ",
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " is a two-dimensional graphics primitive that represents a circle of \
radius r centered at the point {",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  "}. ",
  Cell["Circle[{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`r\_x\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`r\_y\)]],
  Cell["}]", "Input"],
  " yields an ellipse with semi-axes ",
  Cell[BoxData[
      \(TraditionalForm\`r\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_y\)]],
  ". ",
  Cell["Circle[{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  Cell["},", "Input"],
  " ",
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\_1\)]],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\_2\)]],
  Cell["}]", "Input"],
  " represents a circular arc. ",
  Cell["Line[{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`p\_2\)]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  Cell["}]", "Input"],
  " is a graphics primitive which represents a line joining a sequence of \
points."
}], "Text"],

Cell["\<\
Here is a diagram made up of text, line, and circle \
primitives.\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[{Text["\<r\>", {1.6, \(-0.2\)}], 
          Text["\<\[Theta]\>", {0.8, 0.35}], Thickness[0.015], 
          Circle[{0, 0}, 3], Thickness[0.01], 
          Line[{{3, 0}, {0, 0}, {3  Cos[\[Pi]/4], 3  Sin[\[Pi]/4]}}], 
          Thickness[0.005], Dashing[{0.0075}], 
          Circle[{0, 0}, 1.25, {0, \[Pi]/4}]}], 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell["Here is a more complicated example.", "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[{{GrayLevel[0.75], 
            Polygon[{{0, 0}, {1, 1}, {0, 2}, {\(-1\), 1}, {0, 0}}]}, {Hue[0], 
            Thickness[0.01], 
            Line[{{0, 0}, {1, 1}, {0, 2}, {\(-1\), 1}, {0, 0}}]}, 
          Line[{{0, 0}, {0, 2}}], {Dashing[{0.01}], Circle[{0, 0}, 1], 
            Circle[{0, 0}, \@2], Line[{{\(-2\), \(-2\)}, {2, 2}}], 
            Line[{{\(-2\), 2}, {2, \(-2\)}}], Line[{{\(-2\), 0}, {2, 4}}], 
            Line[{{\(-2\), 4}, {2, 0}}]}, {Thickness[0.01], 
            Line[{{0, 0}, {1, 0}, {1, 1}, {0, 1}, {0, 0}}]}}], 
      Axes \[Rule] True, AxesOrigin \[Rule] {0, 0}, 
      AspectRatio \[Rule] Automatic, 
      PlotRange \[Rule] {Automatic, {\(-0.2\), 2.2}}, 
      PlotLabel \[Rule] "\<duplicating the square\>"]; \)\)], "Input"],

Cell[TextData[{
  "This works similarly in three dimensions using ",
  StyleBox["Graphics3D", "Input"],
  " in place of ",
  StyleBox["Graphics", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics3D[{\n\t\t\t
          Polygon[{{0, 0, 0}, {0, 4, 0}, {4.5, 4, 0}, {4.5, 0, 0}}], 
          PointSize[0.03], 
          Table[Point[{t, 2, Abs[50 + 20  t - 8  t\^2]}], {t, 0, 4, 0.2}]}], 
      BoxRatios -> {1, 0.25, 1}, 
      ViewPoint -> {\(-0.012\), \ \(-3.220\), \ 1.040}, 
      Axes -> {True, False, True}, 
      AxesLabel -> {"\<time\>", None, "\<height\>"}]; \)\)], "Input"],

Cell[TextData[{
  "Several of the standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages define more graphics objects and tools to manipulate them."
}], "Text"],

Cell[CellGroupData[{

Cell["Exercises: Graphics Primitives and Directives", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Below is the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "code to draw a face. Use other two-dimensional graphics commands (such as \
",
  StyleBox["Polygon", "Input",
    FontFamily->"Courier"],
  ") to add other features (nose, beard, hat, etc.) and make changes to the \
face (such as eye color). Experiment and have fun."
}], "Question"],

Cell[BoxData[
    \(\(Show[
      Graphics[{Thickness[0.03], Circle[{0, 0}, 1], PointSize[0.04], 
          Point[{\(-0.5\), 0.3}], Point[{0.5, 0.3}], 
          Circle[{0, \(-0.1\)}, 0.5, {5  \[Pi]/4, 7  \[Pi]/4}]}], 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell["Here is one variation.", "Text"],

Cell[BoxData[
    \(\(Show[
      Graphics[{Thickness[0.03], Circle[{0, 0}, 1], Thickness[0.009], Blue, 
          Circle[{\(-0.5\), 0.3}, 0.04], Circle[{0.5, 0.3}, 0.04], Red, 
          Circle[{0, \(-0.1\)}, 0.5, {5  \[Pi]/4, 7  \[Pi]/4}], Pink, 
          Polygon[{{\(-0.25\), \(-0.9\)}, {0.25, \(-0.9\)}, {0, \(-1.25\)}}], 
          Green, Polygon[{{\(-0.6\), 0.9}, {0.6, 0.9}, {0.6, 1.1}, {\(-0.6\), 
                1.1}}], 
          Polygon[{{\(-0.4\), 1.1}, {0.4, 1.1}, {0.4, 1.5}, {\(-0.4\), 
                1.5}}]}], AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Shapes and Polyhedra", "Subsection"],

Cell[TextData[{
  "The packages ",
  StyleBox["Graphics`Shapes`", "Input"],
  " and ",
  StyleBox["Graphics`Polyhedra`", "Input"],
  " provide ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " definitions of common three-dimensional shapes and the regular Platonic \
polyhedra, as well as functions for affine transformations on them."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Shapes`\>"]\)], "Input"],

Cell[TextData[{
  "Once a package is loaded, we can get a list of all the objects that it \
defines by giving using ",
  StyleBox["?", "Input"],
  " with the context name and ",
  StyleBox["*", "Input"],
  " (to denote all names)."
}], "Text"],

Cell["?Graphics`Shapes`*", "Input"],

Cell[TextData[{
  StyleBox["Torus[", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`r\_1\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox["]", "Input"],
  " is a list of ",
  Cell[BoxData[
      \(TraditionalForm\`m\ n\)]],
  " polygons approximating a torus centered around the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "-axis with radii ",
  Cell[BoxData[
      \(TraditionalForm\`r\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  "."
}], "Text"],

Cell[TextData[{
  "We use ",
  StyleBox["Show", "Input"],
  " and ",
  StyleBox["Graphics3D", "Input"],
  " to have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " render the shape. "
}], "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[Torus[1, 0.75, 25, 25]]]; \)\)], "Input"],

Cell[TextData[{
  "Transformations on these ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " objects, such as ",
  StyleBox["WireFrame", "Input"],
  " and ",
  StyleBox["RotateShape", "Input"],
  ", are wrapped around the shape, using the following syntax. "
}], "Text"],

Cell[BoxData[
    \(\(Show[WireFrame[Graphics3D[Torus[1, 0.75, 25, 25]]], Boxed -> False]; 
    \)\)], "Input"],

Cell["\<\
Here we load the package in which various polyhedra are \
defined.\
\>", "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Polyhedra`\>"]\)], "Input"],

Cell["\<\
We can now use the standard polyhedra as graphics primitives.\
\>", 
  "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[GreatIcosahedron[]]]; \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Geometry`Polytopes`", "Input"],
  " "
}], "SeeAlso"],

Cell[CellGroupData[{

Cell["Exercises: Shapes and Polyhedra", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " draw the default ",
  StyleBox["Cylinder", "Input",
    FontFamily->"Courier"],
  ". Draw another cylinder whose length is twice its diameter. Use ",
  StyleBox["RotateShape", "Input",
    FontFamily->"Courier"],
  " to rotate this ",
  StyleBox["Cylinder", "Input",
    FontFamily->"Courier"],
  " off the vertical. Use ",
  StyleBox["AffineShape", "Input",
    FontFamily->"Courier"],
  " to deform the cylinder in any way."
}], "Question"],

Cell[TextData[{
  "Here we load the package ",
  StyleBox["Graphics`Shapes`", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Shapes`\>"]\)], "Input"],

Cell["Here is the default cylinder.", "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[Cylinder[]], Boxed \[Rule] False]; \)\)], "Input"],

Cell["Here is a cylinder with a height twice its diameter.", "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[Cylinder[1, 2]], Boxed \[Rule] False]; \)\)], "Input"],

Cell[TextData[{
  "Here we use ",
  StyleBox["RotateShape", "Input"],
  " to rotate the cylinder."
}], "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[RotateShape[Cylinder[1, 2], 0, \[Pi]/2, \[Pi]/2]], 
      Boxed \[Rule] False]; \)\)], "Input"],

Cell[TextData[{
  "Here we deform the cylinder with ",
  StyleBox["AffineShape", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[AffineShape[Cylinder[1, 2], {0.25, 0.5, 0.15}]], 
      Boxed \[Rule] False]; \)\)], "Input"],

Cell["Do the previous exercise with any other shape.", "Question"],

Cell[BoxData[
    \(\(Show[
      Graphics3D[
        RotateShape[AffineShape[Cone[], {0.25, 0.5, 1.15}], \[Pi], \[Pi]/3, 
          \(-\[Pi]\)/4]], Boxed \[Rule] False]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Customizing Graphics", "Subsection"],

Cell[CellGroupData[{

Cell["Arrows", "Subsubsection"],

Cell["\<\
Now that we know how to use graphics primitives to create arbitrary \
graphics objects, we can combine these with other types of graphics.\
\>", 
  "Text"],

Cell[TextData[{
  StyleBox["Epilog", "Input"],
  " is an option for most plotting functions that allows us to specify \
graphics directives and primitives to be drawn after the main graphics are \
generated."
}], "Text"],

Cell[TextData[{
  "We can use ",
  StyleBox["Epilog", "Input"],
  " to add arbitrary graphics to any plot. The standard package ",
  StyleBox["Graphics`Arrow`", "Input"],
  " defines an arrow graphics primitive. We load it in the standard way, \
using ",
  StyleBox["Needs", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Arrow`\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["Arrow[", "Input"],
  StyleBox["start",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["finish",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " is a graphics primitive representing an arrow starting at the point ",
  StyleBox["start",
    FontSlant->"Italic"],
  " and ending at the point ",
  StyleBox["finish",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, {x, \(-10\), 10}, PlotRange \[Rule] All, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
      Epilog \[Rule] {Arrow[{7, 0.6}, {0.01, 0.99}], 
          Arrow[{7, 0.4}, {4.49, \(-0.21\)}]}]; \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Prolog", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Text in Graphs", "Subsubsection"],

Cell[TextData[{
  StyleBox["Text[", "Input"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["coords",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " is a graphics primitive that represents text corresponding to the printed \
form of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", centered at the point specified by ",
  StyleBox["coords",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[Graphics[Text["\<look here\>", {0, 0}]]]; \)\)], "Input"],

Cell[TextData[{
  "We can use text as part of a list of graphics primitives given to the \
option ",
  StyleBox["Epilog", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, {x, \(-10\), 10}, PlotRange \[Rule] All, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
      Epilog \[Rule] {Arrow[{7, 0.6}, {0.01, 0.99}], 
          Arrow[{7, 0.4}, {4.49, \(-0.21\)}], 
          Text["\<some extrema\>", {7, 0.5}]}]; \)\)], "Input"],

Cell[TextData[{
  "The option ",
  StyleBox["TextStyle", "Input"],
  " accepts a list of options that change the font used for all text in a \
graph, as well as its size, color, weight, and slant. (The specific options \
are ",
  StyleBox["FontFamily", "Input"],
  ", ",
  StyleBox["FontSize", "Input"],
  ", ",
  StyleBox["FontColor", "Input"],
  ", ",
  StyleBox["FontWeight", "Input"],
  ", and ",
  StyleBox["FontSlant", "Input"],
  ".) In the following example all text is in 9-point Helvetica, drawn in 50% \
gray."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]/x, {x, \(-10\), 10}, PlotRange \[Rule] All, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
      Epilog \[Rule] {Arrow[{7, 0.6}, {0.01, 0.99}], 
          Arrow[{7, 0.4}, {4.49, \(-0.21\)}], 
          Text["\<some extrema\>", {7, 0.5}]}, 
      TextStyle -> {FontFamily \[Rule] "\<Helvetica\>", FontSize \[Rule] 9, 
          FontColor \[Rule] GrayLevel[0.5]}]; \)\)], "Input"],

Cell[TextData[{
  "We can change the font styles for a particular piece of text by putting \
the text inside ",
  StyleBox["StyleForm", "Input"],
  " and including the desired changes. In this example all settings are the \
same as above, except the text \[OpenCurlyDoubleQuote]some extrema\
\[CloseCurlyDoubleQuote] is drawn in red 12-point bold Times."
}], "Text"],

Cell[BoxData[
    \(\(Plot[Sin[x]\/x, {x, \(-10\), 10}, PlotRange \[Rule] All, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
      Epilog \[Rule] {Arrow[{7, 0.6}, {0.01, 0.99}], 
          Arrow[{7, 0.4}, {4.49, \(-0.21\)}], \n\t\t\t
          Text[StyleForm["\<some extrema\>", FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] 12, FontWeight \[Rule] "\<Bold\>", 
              FontColor \[Rule] Hue[0]], {7, 0.5}]}, \n\t
      TextStyle 
        \[Rule] {FontFamily \[Rule] "\<Helvetica\>", FontSize \[Rule] 9, 
          FontColor \[Rule] GrayLevel[0.5]}]; \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["$TextStyle", "Input"],
  ", ",
  StyleBox["FormatType", "Input"],
  ", ",
  StyleBox["$FormatType", "Input"],
  ", ",
  StyleBox["Background", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics Formats", "Subsubsection"],

Cell[TextData[{
  "By default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " generates graphics using a subset of the PostScript language, which is \
transportable among all types of computers ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " runs on. Graphics in the PostScript language can be enlarged or reduced \
to any size without loss of resolution."
}], "Text"],

Cell[TextData[{
  "The function ",
  StyleBox["DisplayString", "Input"],
  " allows us to see the PostScript code that makes up a graph. We can save \
the PostScript to a file that can be read by many of the highest-quality \
graphics processors. Here is a two-dimensional plot."
}], "Text"],

Cell[BoxData[
    \(\(sinplot = Plot[Sin[x], {x, \(-3\), 3}]; \)\)], "Input"],

Cell[TextData[{
  "The PostScript code that makes up the graph is rather long, so here we use \
",
  StyleBox["StringTake", "Input"],
  " to show only the first 150 characters."
}], "Text"],

Cell[BoxData[
    \(StringTake[DisplayString[sinplot], 150]\)], "Input"],

Cell[TextData[{
  "The function ",
  StyleBox["Display", "Input"],
  " will save a graph in a file. Here we save the graph called ",
  StyleBox["sinplot", "Input"],
  " into a file called ",
  StyleBox["sinfile", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Display["\<sinfile\>", sinplot]\)], "Input"],

Cell[TextData[{
  StyleBox["Display[\"", "Input"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox["\",", "Input"],
  " ",
  StyleBox["graphics",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["\"", "Input"],
  StyleBox["format",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  " saves a graph to a file after converting the graph to another format. \
Some of the possible values for the parameter ",
  StyleBox["format",
    FontSlant->"Italic"],
  " are ",
  StyleBox["GIF", "Input"],
  ", ",
  StyleBox["EPS", "Input"],
  ", ",
  StyleBox["Illustrator", "Input"],
  ", ",
  StyleBox["Metafile", "Input"],
  ", ",
  StyleBox["PICT", "Input"],
  ", ",
  StyleBox["TIFF", "Input"],
  ", and ",
  StyleBox["XBitmap", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "There is also a package ",
  StyleBox["Utilities`DXF`", "Input"],
  " that saves three-dimensional graphics in DXF format, the standard used in \
AutoCad and other modeling programs."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end will convert graphics to several formats. We select a graphic, \
then pull down the Edit menu and choose a format from the Copy As submenu to \
copy the graph to the system clipboard in the specified form, or choose a \
format from the Save As submenu to save the converted graph to a file."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Graphics`ThreeScript`", "Input"],
  ", ",
  StyleBox["ImageSize", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Customizing Graphics", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Scroll back in this notebook and copy the code used to generate the last \
graphic in the two-dimensional graphics section. Use ",
  StyleBox["Arrow",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Text",
    FontFamily->"Courier"],
  " to draw an arrow pointing at an arbitrary point on the graphic with the \
caption \[OpenCurlyDoubleQuote]Look Here!\[CloseCurlyDoubleQuote]"
}], "Question"],

Cell[BoxData[
    \(\(Plot[x\^2 - 20\ Cos[x\^2], {x, \(-10\), 10}, 
      PlotStyle \[Rule] {Green}, PlotPoints \[Rule] 75, Frame \[Rule] True, 
      GridLines \[Rule] Automatic, PlotLabel \[Rule] "\<Exercise One\>", 
      Epilog \[Rule] {Arrow[{5, 62}, {0, \(-19\)}], 
          Text["\<Look Here!\>", {3, 64}]}]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Animation", "Subsection"],

Cell[TextData[{
  "All versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can create animations. Animation results when a series of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics are displayed quickly in succession to create the illusion of \
smooth movement."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides many features to aid this process. Here is a simple example. The \
command ",
  StyleBox["Table", "Input"],
  " creates an array of results by iterating commands. Here we will create \
ten different plots of ",
  Cell[BoxData[
      \(TraditionalForm\`sin(a\ x)\)]],
  ", letting ",
  StyleBox["a",
    FontSlant->"Italic"],
  " vary. Notice that in the next example we explicitly set the value for the \
option ",
  StyleBox["PlotRange", "Input"],
  " because by default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " picks a new value for ",
  StyleBox["PlotRange", "Input"],
  " for each frame of the animation, causing the axes to move from one frame \
to the next."
}], "Text"],

Cell[BoxData[
    \(\(Table[
      Plot[Sin[a\ x], {x, 0, 10}, PlotRange \[Rule] {{0, 10}, {\(-1\), 1}}], 
      \n\t{a, 1, 5, 0.5}]; \)\)], "Input"],

Cell[TextData[{
  "(The cells of the animation have been deleted to save space. Enter the \
code into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to see the animation.)"
}], "Text"],

Cell[TextData[{
  "The package ",
  StyleBox["Graphics`Animation`", "Input"],
  " defines several functions for automating the creation of animations. Here \
we load the package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Animation`\>"]\)], "Input"],

Cell["\<\
Here are the names of all the functions defined in the \
package.\
\>", "Text"],

Cell["?Graphics`Animation`*", "Input"],

Cell[TextData[{
  StyleBox["MoviePlot[f[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["],{", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  StyleBox["},{", "Input"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  StyleBox[",", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`t\_1\)]],
  StyleBox["}]", "Input"],
  " animates plots of ",
  StyleBox["f[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " regarded as a function of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", with ",
  StyleBox["t",
    FontSlant->"Italic"],
  " serving as the animation, or time, variable."
}], "Text"],

Cell[BoxData[
    \(\(MoviePlot[Sin[a\ x], {x, 0, 10}, {a, 1, 5, 0.5}]; \)\)], "Input"],

Cell[TextData[{
  "(The cells of the animation have been deleted to save space. Enter the \
code into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to see the animation.)"
}], "Text"],

Cell[TextData[{
  "Notice that ",
  StyleBox["MoviePlot", "Input"],
  " is essentially a shortcut for using the ",
  StyleBox["Table", "Input"],
  " command. One difference is that ",
  StyleBox["MoviePlot", "Input"],
  " automatically uses the same value for ",
  StyleBox["PlotRange", "Input"],
  " for each frame."
}], "Text"],

Cell[TextData[{
  "Another interesting animation results from varying the viewpoint, thereby \
creating a revolution or a \[OpenCurlyDoubleQuote]fly-by\
\[CloseCurlyDoubleQuote] of an object. ",
  StyleBox["SpinShow", "Input"],
  " automates this process."
}], "Text"],

Cell[BoxData[
    \(\(SpinShow[Graphics3D[Stellate[Icosahedron[]]], Boxed \[Rule] False]; 
    \)\)], "Input"],

Cell[TextData[{
  "(The cells of the animation have been deleted to save space. Enter the \
code into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to see the animation.)"
}], "Text"],

Cell["\<\
Other effects can be achieved by varying colors, options, ranges, \
and so on.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Exercises: Animation", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Using ",
  StyleBox["Table", "Input",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Do", "Input",
    FontFamily->"Courier"],
  ", or ",
  StyleBox["MoviePlot", "Input",
    FontFamily->"Courier"],
  ", create a two-dimensional animation of a function that changes over time. \
Ensure that the domain and range remain the same throughout the animation."
}], "Question"],

Cell[BoxData[
    \(\(myanim = 
      Table[Plot[Sin[k\ x], {x, 0, 3\ \[Pi]}, 
          PlotRange \[Rule] {{0, 10}, {\(-1\), 1}}, PlotPoints \[Rule] 50], {
          k, 1, 9}]; \)\)], "Input"],

Cell[TextData[{
  "The line above will generate the animation, but for better viewing on the \
printed page we use ",
  StyleBox["GraphicsArray", "Input"],
  " to view all the frames at once."
}], "Text"],

Cell[BoxData[
    \(\(Show[GraphicsArray[Partition[myanim, 3]]]; \)\)], "Input"],

Cell[TextData[{
  "Choose your favorite three-dimensional graphic from this set of exercises \
(or make a new one) and create an animation using ",
  StyleBox["SpinShow", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[TextData[{
  "To use ",
  StyleBox["SpinShow", "Input"],
  ", we must load the package ",
  StyleBox["Graphics`Animation`", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Animation`\>"]\)], "Input"],

Cell[BoxData[
    \(\(simpleplot3d = 
      Plot3D[1/Abs[\((x + I\ y)\)\^5 - 1], {x, \(-1\), 1}, {y, \(-1\), 1}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(my3danim = SpinShow[simpleplot3d, Frames \[Rule] 12]; \)\)], "Input"],

Cell["\<\
Using the same technique as above, we look at all of the frames at \
once.\
\>", "Text"],

Cell[BoxData[
    \(\(Show[GraphicsArray[Partition[my3danim, 3]]]; \)\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional Topics", "Section"],

Cell[TextData[{
  "This section is a sampler, rather than a tutorial, of a miscellany of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s capabilities. Documentation for the commands used here \
are found in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Standard Add-on Packages",
    FontSlant->"Italic"],
  ", and the Help Browser."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Files"
}], "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a virtual operating system with which we can navigate \
directories and list their contents, as well as create, delete, and get \
information about files. Here we get the name of the current working \
directory, where any files we create will be saved."
}], "Text"],

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell["\<\
Here we get a list of all files and subdirectories found in our \
current working directory.\
\>", "Text"],

Cell[BoxData[
    \(FileNames[]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains functions for reading and writing many kinds of data files. We \
can read and write numbers, strings, lists, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions, or anything else."
}], "Text"],

Cell[TextData[{
  "To illustrate, here we create a file called ",
  StyleBox["datafile", "Output",
    FontFamily->"Courier"],
  " in which to write data, by using ",
  StyleBox["OpenWrite", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(?OpenWrite\)\)], "Input"],

Cell[BoxData[
    \(stream = OpenWrite["\<datafile\>"]\)], "Input"],

Cell[TextData[{
  "Here we set up a loop that writes twelve random numbers to ",
  StyleBox["datafile",
    FontFamily->"Courier"],
  "."
}], "Text"],

Cell[BoxData[
    \(Do[Write[stream, Random[]], {12}]\)], "Input"],

Cell["When finished writing data, we close the file.", "Text",
  PageBreakAbove->True],

Cell[BoxData[
    \(Close[stream]\)], "Input"],

Cell[TextData[{
  "Here we display the file, using ",
  StyleBox["!!datafile", "Input"],
  "."
}], "Text"],

Cell["!!datafile", "Input"],

Cell[TextData[{
  "In order to use the data in computations, here we read the contents of ",
  StyleBox["datafile", "Output",
    FontFamily->"Courier"],
  ", putting the contents in a list called ",
  StyleBox["somedata", "Input"],
  " using ",
  StyleBox["ReadList", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(somedata = ReadList["\<datafile\>"]; \)\)], "Input"],

Cell["\<\
The list can now be treated as a list generated any other way. For \
example, we can plot the list or sort its elements.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[somedata, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[Sort[somedata], PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[TextData[{
  "Moreover, we can specify to ",
  StyleBox["ReadList", "Input"],
  " the type of data we wish to read. For example, suppose we want to read ",
  StyleBox["datafile", "Output"],
  " as six ordered pairs of data, rather than twelve data values. To do this, \
we specify to ",
  StyleBox["ReadList", "Input"],
  " that we are reading data of the form ",
  Cell[BoxData[
      \({Number, Number}\)], "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(datapairs = ReadList["\<datafile\>", {Number, Number}]; \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[datapairs, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[TextData[{
  "Similarly, we can read ",
  StyleBox["datafile", "Output"],
  " as a list of ordered triples."
}], "Text"],

Cell[BoxData[
    \(\(datatriples = ReadList["\<datafile\>", {Number, Number, Number}]; 
    \)\)], "Input"],

Cell["We now plot the ordered triples.", "Text"],

Cell[BoxData[
    \(\(Show[Graphics3D[Line[datatriples]]]; \)\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Read", "Input"],
  ", ",
  StyleBox["RecordSeparators", "Input"],
  ", ",
  StyleBox["Utilities`BinaryFiles`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Statistics and Data Analysis", "Subsection"],

Cell[TextData[{
  "To use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s statistical functions, we first load the appropriate \
packages from the Statistics directory. The package names can be found in the \
Help Browser or the book ",
  StyleBox["Standard Add-on Packages",
    FontSlant->"Italic"],
  ", and the packages can be loaded using the Help Browser or the ",
  StyleBox["Needs", "Input"],
  " command."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows about many continuous and discrete statistical distributions. We \
first load the package containing the continuous distributions."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`ContinuousDistributions`\>"]\)], "Input"],

Cell["\<\
Once the package is loaded, on-line help for the statistics \
functions is available.\
\>", "Text"],

Cell["?PDF", "Input"],

Cell["\<\
The loaded functions can then be plotted or manipulated in the \
usual ways. Below we generate two statistical plots. Here is a plot of the \
p.d.f. of the standard normal distribution and the p.d.f. of an extreme-value \
distribution.\
\>", "Text"],

Cell[BoxData[
    \(\(Plot[\n
      \t{PDF[NormalDistribution[0, 1], x], 
        PDF[ExtremeValueDistribution[\(-1\), 1], x]}, {x, \(-3\), 3}]; \)\)], 
  "Input"],

Cell["Here is a three-dimensional plot of binomial coefficients.", "Text"],

Cell[BoxData[
    \(\(ListPlot3D[Table[Binomial[m, n], {m, 1, 6}, {n, 1, 6}]]; \)\)], 
  "Input"],

Cell["\<\
Here we load a package that computes descriptive statistics from \
lists of data.\
\>", "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`DescriptiveStatistics`\>"]\)], "Input"],

Cell["\<\
The functions defined in the package can be used on numeric lists \
of data.\
\>", "Text"],

Cell[BoxData[
    \(Mean[{0.1, 1, 10, 100, 1000}]\)], "Input"],

Cell["They can also be used on symbolic lists of data.", "Text"],

Cell[BoxData[
    \(HarmonicMean[{a, b, c}]\)], "Input"],

Cell[BoxData[
    \(Skewness[{a, b}]\)], "Input"],

Cell[TextData[{
  "The ",
  StyleBox["Fit", "Input"],
  " function built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs least-squares fitting to a list of data. If we want to fit to \
data a function that is not a linear combination of the basis functions, we \
need to load the package ",
  StyleBox["Statistics`NonlinearFit`", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`NonlinearFit`\>"]\)], "Input"],

Cell["?NonlinearFit", "Input"],

Cell[TextData[{
  "For this example we generate a list of points and call it ",
  StyleBox["dataToFit", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(dataToFit = 
      Table[{x, N[3\ Sin[7\ x/4] + Random[]/3 - 1/6]}, {x, 0, 3, 1/4}]; \)\)],
   "Input"],

Cell["Here is a graph of the points.", "Text"],

Cell[BoxData[
    \(\(ListPlot[dataToFit, PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[TextData[{
  "Here we use ",
  StyleBox["NonlinearFit", "Input"],
  " to fit our model (which is not a linear combination of basis functions) \
to the list ",
  StyleBox["dataToFit", "Input"],
  ". Here is the resulting model."
}], "Text"],

Cell[BoxData[
    \(nlmodel = NonlinearFit[dataToFit, b\ Sin[a\ x], x, {a, b}]\)], "Input"],

Cell[TextData[{
  "Here we plot the nonlinear model called ",
  StyleBox["nlmodel", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[nlmodel, {x, 0, 3}, 
      Epilog \[Rule] {PointSize[0.02], Map[Point, dataToFit]}]; \)\)], "Input"],

Cell[TextData[{
  "To augment the built-in (least-squares) ",
  StyleBox["Fit", "Input"],
  " function, a package exists to perform full linear regression on a set of \
data. We load the appropriate package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`LinearRegression`\>"]\)], "Input"],

Cell[TextData[{
  "Now we perform the linear regression, fitting ",
  StyleBox["dataToFit", "Input"],
  " with constant, linear, quadratic, and cubic basis functions."
}], "Text"],

Cell[BoxData[
    \(Regress[dataToFit, {1, x, x\^2, x\^3}, x]\)], "Input"],

Cell[TextData[{
  "Part of the default result is an ANOVA table. There are options we can set \
to obtain covariance and correlation matrices, residual tables, confidence \
intervals, and more. If all we want is the fitted function, we can use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s built-in ",
  StyleBox["Fit", "Input"],
  " function."
}], "Text"],

Cell[BoxData[
    \(Fit[dataToFit, {1, x, x\^2, x\^3}, x]\)], "Input"],

Cell["\<\
We plot the fitted function and again compare it to the given \
points.\
\>", "Text"],

Cell[BoxData[
    \(\(Plot[%, {x, 0, 3}, 
      Epilog \[Rule] {PointSize[0.02], Map[Point, dataToFit]}]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional Graphics Functions", "Subsection"],

Cell["\<\
Other specialized graphics functions are contained in the packages.\
\
\>", "Text"],

Cell[BoxData[
    \(\(Needs["\<Graphics`Graphics`\>"]; \)\)], "Input"],

Cell[TextData[{
  "While not ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s main purpose, it can create most of the common \
business graphics. As an example, ",
  StyleBox["BarChart", "Input"],
  " is an easy function to start with."
}], "Text"],

Cell[BoxData[
    \(\(BarChart[Prime[Range[5]], PlotLabel \[Rule] "\<primes\>"]; \)\)], 
  "Input"],

Cell["\<\
There are several log-plotting functions available. The list \
generated below shows eight different log plots, including functions for data \
plotting.\
\>", "Text"],

Cell[BoxData[
    \(\(?*Log*Plot*\)\)], "Input"],

Cell[BoxData[
    \(\(LogPlot[Abs[100\/\(\((I\ x)\)\^2 + 2\ I\ x + 100\)], {x, 1, 20}, 
      GridLines \[Rule] {LogGridMajor, Automatic}]; \)\)], "Input"],

Cell[TextData[{
  "Many variants of standard plots are defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". To visualize the space between curves, we use ",
  StyleBox["FilledPlot", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`FilledPlot`\>"]\)], "Input"],

Cell[BoxData[
    \(\(FilledPlot[{Sin[t]/t, BesselJ[1, t]}, {t, \(-10\), 10}]; \)\)], 
  "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["PieChart", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["System Parameters", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many global and system parameters, most of which begin with ",
  StyleBox["$", "Input"],
  ". Here is a list of the system parameters beginning with ",
  StyleBox["$M", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Names["\<$M*\>"]\)], "Input"],

Cell["The on-line help tells us what each parameter is.", "Text"],

Cell["? $MaxNumber", "Input"],

Cell[TextData[
"To find the setting or value of a parameter, type its name and press \
\[ShiftKey]\[LeftModified]\[ReturnKey]\[RightModified]."], "Text"],

Cell[BoxData[
    \($MaxNumber\)], "Input"],

Cell[BoxData[
    \($MachineType\)], "Input"],

Cell[BoxData[
    \($Version\)], "Input"],

Cell["\<\
Here is a list containing the date and time at which this notebook \
was evaluated.\
\>", "Text"],

Cell[BoxData[
    \(Date[]\)], "Input"],

Cell["\<\
Here is the number of seconds that have elapsed since the turn of \
the century.\
\>", "Text"],

Cell[BoxData[
    \(AbsoluteTime[]\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 540}},
ScreenStyleEnvironment->"Presentation",
WindowToolbars->{},
WindowSize->{623, 465},
WindowMargins->{{Automatic, 28}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontSize -> 10]}]], Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Introduction to Mathematica", FontSize -> 10, FontSlant -> 
            "Italic"]}]]}, {Cell[ 
        TextData[ {
          StyleBox[ 
          "Introduction to Mathematica", FontSlant -> "Italic", FontSize -> 
            10]}]], Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontSize -> 10]}]]}},
PrintingOptions->{"PrintingMargins"->{{72, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 4, 67, "Title"],

Cell[CellGroupData[{
Cell[1835, 57, 99, 4, 78, "Section"],

Cell[CellGroupData[{
Cell[1959, 65, 104, 5, 66, "Subsection"],
Cell[2066, 72, 530, 13, 116, "Text"],
Cell[2599, 87, 371, 8, 91, "Text"],
Cell[2973, 97, 582, 19, 116, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[3592, 121, 37, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[3654, 125, 42, 0, 43, "Subsubsection"],
Cell[3699, 127, 620, 20, 71, "Text"],
Cell[4322, 149, 226, 8, 52, "Text"],
Cell[4551, 159, 405, 9, 90, "Text"],
Cell[4959, 170, 717, 15, 128, "Text"],
Cell[5679, 187, 387, 12, 71, "Text"],
Cell[6069, 201, 371, 10, 71, "Text"],
Cell[6443, 213, 402, 10, 71, "Text"],
Cell[6848, 225, 188, 5, 52, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7073, 235, 102, 4, 29, "Subsubsection"],
Cell[7178, 241, 719, 20, 109, "Text"],
Cell[7900, 263, 320, 12, 52, "Text"],
Cell[8223, 277, 344, 10, 52, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8616, 293, 36, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[8677, 297, 50, 0, 54, "Subsubsection"],
Cell[8730, 299, 424, 8, 70, "Text"],
Cell[9157, 309, 290, 7, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9484, 321, 45, 0, 32, "Subsubsection"],
Cell[9532, 323, 703, 12, 70, "Text"],
Cell[10238, 337, 351, 8, 70, "Text"],
Cell[10592, 347, 310, 7, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[10939, 359, 39, 0, 32, "Subsubsection"],
Cell[10981, 361, 517, 13, 70, "Text"],
Cell[11501, 376, 625, 22, 70, "Text"],
Cell[12129, 400, 812, 22, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[12978, 427, 54, 0, 32, "Subsubsection"],
Cell[13035, 429, 464, 12, 70, "Text"],
Cell[13502, 443, 446, 16, 70, "Text"],
Cell[13951, 461, 490, 19, 70, "Text"],
Cell[14444, 482, 209, 4, 70, "Text"],
Cell[14656, 488, 410, 17, 70, "Text"],
Cell[15069, 507, 304, 12, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[15410, 524, 53, 0, 32, "Subsubsection"],
Cell[15466, 526, 263, 6, 70, "Text"],
Cell[15732, 534, 1116, 47, 70, "Text"],
Cell[16851, 583, 366, 14, 70, "Text"],
Cell[17220, 599, 354, 12, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[17611, 616, 54, 0, 32, "Subsubsection"],
Cell[17668, 618, 942, 32, 70, "Text"],
Cell[18613, 652, 147, 3, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[18797, 660, 37, 0, 32, "Subsubsection"],
Cell[18837, 662, 493, 14, 73, "Text"],
Cell[19333, 678, 46, 1, 30, "Input"],
Cell[19382, 681, 456, 15, 53, "Text"],
Cell[19841, 698, 439, 12, 54, "Text"],
Cell[20283, 712, 23, 0, 30, "Input"],
Cell[20309, 714, 272, 10, 34, "Text"],
Cell[20584, 726, 29, 0, 30, "Input"],
Cell[20616, 728, 342, 9, 53, "Text"],
Cell[20961, 739, 43, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[21041, 745, 48, 0, 32, "Subsubsection"],
Cell[21092, 747, 829, 22, 109, "Text"],
Cell[21924, 771, 138, 4, 34, "Text"],
Cell[22065, 777, 79, 1, 30, "Input"],
Cell[22147, 780, 1227, 33, 171, "Text"],
Cell[23377, 815, 377, 10, 73, "Text"],
Cell[23757, 827, 52, 1, 30, "Input"],
Cell[23812, 830, 127, 4, 34, "Text"],
Cell[23942, 836, 79, 1, 30, "Input"],
Cell[24024, 839, 439, 7, 71, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[24500, 851, 41, 0, 32, "Subsubsection"],
Cell[24544, 853, 292, 7, 91, "Text"],
Cell[24839, 862, 194, 6, 66, "Text"],
Cell[25036, 870, 42, 1, 56, "Input"],
Cell[25081, 873, 505, 17, 92, "Text"],
Cell[25589, 892, 40, 1, 56, "Input"],
Cell[25632, 895, 144, 5, 41, "Text"],
Cell[25779, 902, 63, 1, 56, "Input"],
Cell[25845, 905, 551, 18, 92, "Text"],
Cell[26399, 925, 53, 1, 56, "Input"],
Cell[26455, 928, 265, 9, 67, "Text"],
Cell[26723, 939, 50, 1, 58, "Input"],
Cell[26776, 942, 120, 4, 41, "Text"],
Cell[26899, 948, 76, 0, 41, "Text"],
Cell[26978, 950, 52, 1, 56, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27091, 958, 107, 5, 50, "Section"],

Cell[CellGroupData[{
Cell[27223, 967, 31, 0, 66, "Subsection"],
Cell[27257, 969, 604, 15, 116, "Text"],
Cell[27864, 986, 417, 10, 116, "Text"],
Cell[28284, 998, 268, 5, 91, "Text"],
Cell[28555, 1005, 6458, 84, 117, 6260, 78, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[35016, 1091, 71, 0, 41, "Text"],
Cell[35090, 1093, 6048, 79, 93, 5851, 73, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[41175, 1177, 27, 0, 38, "Subsection"],
Cell[41205, 1179, 810, 17, 191, "Text"],
Cell[42018, 1198, 319, 8, 67, "Text"],
Cell[42340, 1208, 390, 6, 91, "Text"],
Cell[42733, 1216, 581, 18, 93, "Text"],
Cell[43317, 1236, 9604, 123, 104, 9407, 117, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[52924, 1361, 259, 5, 91, "Text"],
Cell[53186, 1368, 453, 7, 141, "Text"],
Cell[53642, 1377, 5700, 75, 73, 5503, 69, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[59345, 1454, 116, 3, 41, "Text"],
Cell[59464, 1459, 495, 11, 116, "Text"],
Cell[59962, 1472, 17976, 226, 149, 17778, 220, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[77941, 1700, 341, 6, 116, "Text"],
Cell[78285, 1708, 18106, 228, 148, 17908, 222, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[96394, 1938, 140, 3, 66, "Text"],
Cell[96537, 1943, 18317, 231, 151, 18119, 225, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[114857, 2176, 319, 4, 91, "Text"],
Cell[115179, 2182, 23731, 297, 175, 23533, 291, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[138913, 2481, 198, 4, 66, "Text"],
Cell[139114, 2487, 27133, 339, 201, 26935, 333, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[166250, 2828, 146, 3, 66, "Text"],
Cell[166399, 2833, 26036, 326, 198, 25838, 320, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[192438, 3161, 270, 7, 66, "Text"],
Cell[192711, 3170, 27040, 338, 200, 26842, 332, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[219754, 3510, 378, 7, 116, "Text"],
Cell[220135, 3519, 29118, 364, 222, 28920, 358, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[249256, 3885, 672, 12, 166, "Text"],
Cell[249931, 3899, 12683, 161, 112, 12485, 155, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[262617, 4062, 175, 4, 66, "Text"],
Cell[262795, 4068, 20402, 256, 157, 20204, 250, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[283200, 4326, 501, 10, 116, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[283738, 4341, 37, 0, 38, "Subsection"],
Cell[283778, 4343, 525, 7, 166, "Text"],
Cell[284306, 4352, 273, 7, 66, "Text"],
Cell[284582, 4361, 346, 7, 91, "Text"],
Cell[284931, 4370, 412, 9, 91, "Text"],
Cell[285346, 4381, 65, 0, 41, "Text"],
Cell[285414, 4383, 35029, 436, 264, 34857, 431, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[320446, 4821, 216, 4, 66, "Text"],
Cell[320665, 4827, 30769, 384, 198, 30597, 379, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[351437, 5213, 140, 4, 41, "Text"],
Cell[351580, 5219, 31141, 388, 201, 30969, 383, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[382724, 5609, 135, 3, 66, "Text"],
Cell[382862, 5614, 4750, 62, 63, 4579, 57, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[387615, 5678, 281, 7, 91, "Text"],
Cell[387899, 5687, 517, 10, 141, "Text"],
Cell[388419, 5699, 217, 4, 66, "Text"],
Cell[388639, 5705, 38024, 587, 334, 37835, 582, "GraphicsData", 
"PICT", "Graphics",
  Evaluatable->False],
Cell[426666, 6294, 212, 4, 66, "Text"],
Cell[426881, 6300, 32561, 503, 266, 32372, 498, "GraphicsData", 
"PICT", "Graphics",
  Evaluatable->False],
Cell[459445, 6805, 134, 3, 66, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[459616, 6813, 40, 0, 38, "Subsection"],
Cell[459659, 6815, 633, 13, 141, "Text"],
Cell[460295, 6830, 760, 20, 116, "Text"],
Cell[461058, 6852, 623, 13, 116, "Text"],
Cell[461684, 6867, 494, 15, 116, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[462215, 6887, 43, 0, 38, "Subsection"],
Cell[462261, 6889, 992, 24, 166, "Text"],
Cell[463256, 6915, 464, 13, 91, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[463757, 6933, 57, 0, 38, "Subsection"],
Cell[463817, 6935, 400, 10, 92, "Text"],
Cell[464220, 6947, 348, 11, 68, "Text"],
Cell[464571, 6960, 81, 1, 73, "Input"],
Cell[464655, 6963, 392, 10, 91, "Text"],
Cell[465050, 6975, 101, 2, 80, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[465188, 6982, 41, 0, 38, "Subsection"],
Cell[465232, 6984, 359, 7, 91, "Text"],
Cell[465594, 6993, 88, 3, 41, "Text"],
Cell[465685, 6998, 22024, 342, 243, 21826, 336, "GraphicsData", 
"PICT", "Graphics",
  Evaluatable->False],
Cell[487712, 7342, 300, 7, 91, "Text"],
Cell[488015, 7351, 25066, 387, 357, 24973, 384, "GraphicsData", 
"PICT", "Graphics"],
Cell[513084, 7740, 298, 6, 91, "Text"],
Cell[513385, 7748, 27879, 430, 341, 27786, 427, "GraphicsData", 
"PICT", "Graphics"],
Cell[541267, 8180, 93, 3, 41, "Text"],
Cell[541363, 8185, 24458, 379, 227, 24260, 373, "GraphicsData", 
"PICT", "Graphics",
  Evaluatable->False],
Cell[565824, 8566, 128, 3, 66, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[565989, 8574, 52, 0, 38, "Subsection"],
Cell[566044, 8576, 518, 10, 141, "Text"],
Cell[566565, 8588, 101, 3, 41, "Text"],
Cell[566669, 8593, 19730, 248, 150, 19532, 242, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False],
Cell[586402, 8843, 185, 5, 66, "Text"],
Cell[586590, 8850, 25598, 320, 189, 25400, 314, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[612237, 9176, 27, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[612289, 9180, 49, 0, 66, "Subsection"],
Cell[612341, 9182, 230, 6, 66, "Text"],
Cell[612574, 9190, 74, 0, 41, "Text"],
Cell[612651, 9192, 47, 1, 56, "Input"],
Cell[612701, 9195, 331, 12, 42, "Text"],
Cell[613035, 9209, 56, 1, 56, "Input"],
Cell[613094, 9212, 372, 14, 44, "Text"],
Cell[613469, 9228, 36, 1, 56, "Input"],
Cell[613508, 9231, 268, 10, 42, "Text"],
Cell[613779, 9243, 43, 1, 58, "Input"],
Cell[613825, 9246, 577, 16, 118, "Text"],
Cell[614405, 9264, 55, 1, 56, "Input"],
Cell[614463, 9267, 133, 5, 30, "SeeAlso"],

Cell[CellGroupData[{
Cell[614621, 9276, 62, 0, 54, "Subsubsection"],
Cell[614686, 9278, 133, 3, 29, "Question"],
Cell[614822, 9283, 190, 4, 58, "SmallText"],
Cell[615015, 9289, 62, 1, 56, "Input"],
Cell[615080, 9292, 193, 6, 38, "SmallText"],
Cell[615276, 9300, 37, 1, 56, "Input"],
Cell[615316, 9303, 177, 5, 29, "Question"],
Cell[615496, 9310, 149, 3, 58, "SmallText"],
Cell[615648, 9315, 53, 1, 56, "Input"],
Cell[615704, 9318, 172, 6, 38, "SmallText"],
Cell[615879, 9326, 53, 1, 56, "Input"],
Cell[615935, 9329, 59, 1, 56, "Input"],
Cell[615997, 9332, 141, 3, 50, "Question"],
Cell[616141, 9337, 46, 1, 56, "Input"],
Cell[616190, 9340, 48, 1, 56, "Input"],
Cell[616241, 9343, 51, 1, 56, "Input"],
Cell[616295, 9346, 53, 1, 56, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[616397, 9353, 43, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[616465, 9357, 55, 0, 54, "Subsubsection"],
Cell[616523, 9359, 282, 7, 91, "Text"],
Cell[616808, 9368, 780, 18, 166, "Text"],
Cell[617591, 9388, 245, 6, 66, "Text"],
Cell[617839, 9396, 49, 1, 58, "Input"],
Cell[617891, 9399, 192, 5, 66, "Text"],
Cell[618086, 9406, 41, 1, 71, "Input"],
Cell[618130, 9409, 76, 0, 41, "Text"],
Cell[618209, 9411, 45, 1, 71, "Input"],
Cell[618257, 9414, 280, 5, 91, "Text"],
Cell[618540, 9421, 47, 1, 71, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[618624, 9427, 43, 0, 54, "Subsubsection"],
Cell[618670, 9429, 432, 8, 116, "Text"],
Cell[619105, 9439, 44, 1, 60, "Input"],
Cell[619152, 9442, 68, 0, 41, "Text"],
Cell[619223, 9444, 44, 1, 60, "Input"],
Cell[619270, 9447, 109, 3, 41, "Text"],
Cell[619382, 9452, 46, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[619465, 9458, 47, 0, 54, "Subsubsection"],
Cell[619515, 9460, 553, 16, 117, "Text"],
Cell[620071, 9478, 39, 1, 56, "Input"],
Cell[620113, 9481, 593, 26, 42, "Text"],
Cell[620709, 9509, 74, 1, 59, "Input"],
Cell[620786, 9512, 363, 10, 92, "Text"],
Cell[621152, 9524, 40, 0, 54, "Input"],
Cell[621195, 9526, 280, 8, 67, "Text"],
Cell[621478, 9536, 60, 1, 74, "Input"],
Cell[621541, 9539, 338, 8, 92, "Text"],
Cell[621882, 9549, 739, 34, 52, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[622658, 9588, 40, 0, 32, "Subsubsection"],
Cell[622701, 9590, 190, 8, 42, "Text"],
Cell[622894, 9600, 45, 1, 56, "Input"],
Cell[622942, 9603, 191, 6, 42, "Text"],
Cell[623136, 9611, 49, 1, 58, "Input"],
Cell[623188, 9614, 138, 2, 41, "Text"],
Cell[623329, 9618, 58, 1, 58, "Input"],
Cell[623390, 9621, 72, 0, 41, "Text"],
Cell[623465, 9623, 63, 1, 56, "Input"],
Cell[623531, 9626, 54, 0, 41, "Text"],
Cell[623588, 9628, 65, 1, 56, "Input"],
Cell[623656, 9631, 445, 16, 67, "Text"],
Cell[624104, 9649, 141, 6, 42, "Text"],
Cell[624248, 9657, 53, 1, 56, "Input"],
Cell[624304, 9660, 159, 6, 42, "Text"],
Cell[624466, 9668, 53, 1, 56, "Input"],
Cell[624522, 9671, 134, 6, 42, "Text"],
Cell[624659, 9679, 47, 1, 56, "Input"],
Cell[624709, 9682, 191, 7, 42, "Text"],
Cell[624903, 9691, 55, 1, 56, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[624995, 9697, 60, 0, 32, "Subsubsection"],
Cell[625058, 9699, 542, 22, 68, "Text"],
Cell[625603, 9723, 47, 1, 62, "Input"],
Cell[625653, 9726, 292, 9, 70, "Text"],
Cell[625948, 9737, 53, 1, 56, "Input"],
Cell[626004, 9740, 155, 4, 66, "Text"],
Cell[626162, 9746, 37, 1, 56, "Input"],
Cell[626202, 9749, 705, 27, 94, "Text"],
Cell[626910, 9778, 71, 1, 56, "Input"],
Cell[626984, 9781, 1223, 48, 94, "Text"],
Cell[628210, 9831, 61, 1, 58, "Input"],
Cell[628274, 9834, 243, 5, 91, "Text"],
Cell[628520, 9841, 79, 1, 56, "Input"],
Cell[628602, 9844, 185, 6, 42, "Text"],
Cell[628790, 9852, 40, 1, 56, "Input"],
Cell[628833, 9855, 475, 18, 68, "Text"],
Cell[629311, 9875, 293, 7, 67, "Text"],
Cell[629607, 9884, 84, 1, 62, "Input"],
Cell[629694, 9887, 316, 14, 30, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[630047, 9906, 53, 0, 32, "Subsubsection"],
Cell[630103, 9908, 562, 19, 93, "Text"],
Cell[630668, 9929, 40, 1, 56, "Input"],
Cell[630711, 9932, 42, 1, 56, "Input"],
Cell[630756, 9935, 48, 1, 56, "Input"],
Cell[630807, 9938, 43, 1, 71, "Input"],
Cell[630853, 9941, 211, 10, 30, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[631101, 9956, 81, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[631185, 9959, 471, 17, 52, "Question"],
Cell[631659, 9978, 50, 1, 56, "Input"],
Cell[631712, 9981, 42, 1, 56, "Input"],
Cell[631757, 9984, 55, 1, 56, "Input"],
Cell[631815, 9987, 505, 16, 71, "Question"],
Cell[632323, 10005, 248, 7, 58, "SmallText"],
Cell[632574, 10014, 47, 1, 56, "Input"],
Cell[632624, 10017, 161, 6, 38, "SmallText"],
Cell[632788, 10025, 48, 1, 56, "Input"],
Cell[632839, 10028, 242, 8, 51, "Question"],
Cell[633084, 10038, 164, 5, 37, "SmallText"],
Cell[633251, 10045, 48, 1, 56, "Input"],
Cell[633302, 10048, 150, 6, 38, "SmallText"],
Cell[633455, 10056, 51, 1, 62, "Input"],
Cell[633509, 10059, 51, 1, 62, "Input"],
Cell[633563, 10062, 52, 1, 62, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[633664, 10069, 44, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[633733, 10073, 45, 0, 54, "Subsubsection"],
Cell[633781, 10075, 144, 5, 41, "Text"],
Cell[633928, 10082, 272, 6, 66, "Text"],
Cell[634203, 10090, 26, 0, 54, "Input"],
Cell[634232, 10092, 481, 15, 92, "Text"],
Cell[634716, 10109, 48, 1, 56, "Input"],
Cell[634767, 10112, 76, 0, 41, "Text"],
Cell[634846, 10114, 58, 1, 56, "Input"],
Cell[634907, 10117, 92, 3, 41, "Text"],
Cell[635002, 10122, 44, 1, 56, "Input"],
Cell[635049, 10125, 173, 5, 66, "Text"],
Cell[635225, 10132, 40, 1, 56, "Input"],
Cell[635268, 10135, 151, 5, 41, "Text"],
Cell[635422, 10142, 42, 1, 56, "Input"],
Cell[635467, 10145, 135, 5, 42, "Text"],
Cell[635605, 10152, 43, 1, 56, "Input"],
Cell[635651, 10155, 359, 14, 67, "Text"],
Cell[636013, 10171, 44, 1, 56, "Input"],
Cell[636060, 10174, 455, 21, 42, "Text"],
Cell[636518, 10197, 49, 1, 56, "Input"],
Cell[636570, 10200, 356, 17, 30, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[636963, 10222, 42, 0, 32, "Subsubsection"],
Cell[637008, 10224, 635, 14, 141, "Text"],
Cell[637646, 10240, 499, 13, 91, "Text"],
Cell[638148, 10255, 27, 0, 54, "Input"],
Cell[638178, 10257, 75, 0, 41, "Text"],
Cell[638256, 10259, 26, 0, 54, "Input"],
Cell[638285, 10261, 224, 5, 66, "Text"],
Cell[638512, 10268, 43, 1, 56, "Input"],
Cell[638558, 10271, 54, 1, 56, "Input"],
Cell[638615, 10274, 40, 1, 56, "Input"],
Cell[638658, 10277, 242, 6, 66, "Text"],
Cell[638903, 10285, 620, 29, 52, "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[639572, 10320, 50, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[639647, 10324, 64, 0, 54, "Subsubsection"],
Cell[639714, 10326, 473, 15, 92, "Text"],
Cell[640190, 10343, 470, 12, 118, "Text"],
Cell[640663, 10357, 155, 5, 42, "Text"],
Cell[640821, 10364, 558, 25, 42, "Text"],
Cell[641382, 10391, 52, 1, 56, "Input"],
Cell[641437, 10394, 46, 0, 41, "Text"],
Cell[641486, 10396, 47, 1, 56, "Input"],
Cell[641536, 10399, 632, 28, 42, "Text"],
Cell[642171, 10429, 55, 1, 56, "Input"],
Cell[642229, 10432, 489, 22, 42, "Text"],
Cell[642721, 10456, 61, 1, 56, "Input"],
Cell[642785, 10459, 483, 23, 42, "Text"],
Cell[643271, 10484, 65, 1, 56, "Input"],
Cell[643339, 10487, 848, 39, 67, "Text"],
Cell[644190, 10528, 45, 0, 54, "Input"],
Cell[644238, 10530, 338, 10, 92, "Text"],
Cell[644579, 10542, 71, 1, 56, "Input"],
Cell[644653, 10545, 394, 12, 92, "Text"],
Cell[645050, 10559, 75, 1, 56, "Input"],
Cell[645128, 10562, 538, 11, 141, "Text"],
Cell[645669, 10575, 191, 6, 91, "Input"],
Cell[645863, 10583, 381, 18, 30, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[646281, 10606, 56, 0, 32, "Subsubsection"],
Cell[646340, 10608, 192, 6, 67, "Text"],
Cell[646535, 10616, 51, 1, 56, "Input"],
Cell[646589, 10619, 497, 17, 93, "Text"],
Cell[647089, 10638, 99, 2, 79, "Input"],
Cell[647191, 10642, 220, 10, 30, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[647448, 10657, 58, 0, 32, "Subsubsection"],
Cell[647509, 10659, 216, 6, 66, "Text"],
Cell[647728, 10667, 56, 1, 56, "Input"],
Cell[647787, 10670, 171, 5, 71, "Input"],
Cell[647961, 10677, 267, 7, 67, "Text"],
Cell[648231, 10686, 57, 1, 56, "Input"],
Cell[648291, 10689, 381, 15, 68, "Text"],
Cell[648675, 10706, 57, 1, 56, "Input"],
Cell[648735, 10709, 177, 4, 66, "Text"],
Cell[648915, 10715, 62, 1, 56, "Input"],
Cell[648980, 10718, 203, 6, 42, "Text"],
Cell[649186, 10726, 57, 1, 56, "Input"],
Cell[649246, 10729, 60, 0, 41, "Text"],
Cell[649309, 10731, 62, 1, 56, "Input"],
Cell[649374, 10734, 186, 6, 42, "Text"],
Cell[649563, 10742, 57, 1, 56, "Input"],
Cell[649623, 10745, 53, 0, 41, "Text"],
Cell[649679, 10747, 62, 1, 56, "Input"],
Cell[649744, 10750, 156, 4, 41, "Text"],
Cell[649903, 10756, 57, 1, 56, "Input"],
Cell[649963, 10759, 57, 1, 56, "Input"],
Cell[650023, 10762, 1295, 62, 74, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[651355, 10829, 39, 0, 32, "Subsubsection"],
Cell[651397, 10831, 174, 5, 66, "Text"],
Cell[651574, 10838, 85, 1, 58, "Input"],
Cell[651662, 10841, 103, 4, 41, "Text"],
Cell[651768, 10847, 48, 1, 56, "Input"],
Cell[651819, 10850, 129, 3, 66, "Text"],
Cell[651951, 10855, 41, 1, 56, "Input"],
Cell[651995, 10858, 52, 1, 56, "Input"],
Cell[652050, 10861, 121, 4, 41, "Text"],
Cell[652174, 10867, 51, 1, 56, "Input"],
Cell[652228, 10870, 573, 23, 66, "Text"],
Cell[652804, 10895, 60, 1, 56, "Input"],
Cell[652867, 10898, 498, 21, 66, "Text"],
Cell[653368, 10921, 52, 1, 56, "Input"],
Cell[653423, 10924, 167, 6, 41, "Text"],
Cell[653593, 10932, 52, 1, 56, "Input"],
Cell[653648, 10935, 58, 0, 41, "Text"],
Cell[653709, 10937, 296, 8, 66, "Text"],
Cell[654008, 10947, 52, 1, 56, "Input"],
Cell[654063, 10950, 103, 3, 41, "Text"],
Cell[654169, 10955, 55, 1, 56, "Input"],
Cell[654227, 10958, 562, 23, 73, "Text"],
Cell[654792, 10983, 47, 1, 56, "Input"],
Cell[654842, 10986, 302, 9, 71, "Input"],
Cell[655147, 10997, 1083, 50, 74, "SeeAlso"]
}, Open  ]],

Cell[CellGroupData[{
Cell[656267, 11052, 87, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[656357, 11055, 217, 7, 37, "Question"],
Cell[656577, 11064, 93, 1, 74, "Input"],
Cell[656673, 11067, 130, 5, 29, "Question"],
Cell[656806, 11074, 51, 1, 56, "Input"],
Cell[656860, 11077, 55, 0, 29, "Question"],
Cell[656918, 11079, 71, 1, 56, "Input"],
Cell[656992, 11082, 159, 5, 29, "Question"],
Cell[657154, 11089, 51, 1, 56, "Input"],
Cell[657208, 11092, 64, 0, 29, "Question"],
Cell[657275, 11094, 65, 0, 37, "SmallText"],
Cell[657343, 11096, 41, 1, 56, "Input"],
Cell[657387, 11099, 65, 0, 37, "SmallText"],
Cell[657455, 11101, 37, 1, 56, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[657541, 11108, 44, 0, 38, "Subsection"],
Cell[657588, 11110, 630, 19, 116, "Text"],
Cell[658221, 11131, 378, 15, 42, "Text"],
Cell[658602, 11148, 56, 1, 56, "Input"],
Cell[658661, 11151, 282, 7, 67, "Text"],
Cell[658946, 11160, 63, 0, 41, "Text"],
Cell[659012, 11162, 70, 1, 56, "Input"],
Cell[659085, 11165, 67, 0, 41, "Text"],
Cell[659155, 11167, 69, 1, 56, "Input"],
Cell[659227, 11170, 169, 6, 42, "Text"],
Cell[659399, 11178, 813, 21, 167, "Text"],
Cell[660215, 11201, 204, 7, 42, "Text"],
Cell[660422, 11210, 50, 1, 56, "Input"],
Cell[660475, 11213, 179, 4, 66, "Text"],
Cell[660657, 11219, 65, 1, 56, "Input"],
Cell[660725, 11222, 45, 1, 56, "Input"],
Cell[660773, 11225, 154, 6, 42, "Text"],
Cell[660930, 11233, 40, 1, 62, "Input"],
Cell[660973, 11236, 29, 0, 54, "Input"],
Cell[661005, 11238, 249, 7, 67, "Text"],
Cell[661257, 11247, 153, 5, 41, "Text"],
Cell[661413, 11254, 46, 1, 62, "Input"],
Cell[661462, 11257, 116, 3, 41, "Text"],
Cell[661581, 11262, 29, 0, 54, "Input"],
Cell[661613, 11264, 204, 6, 66, "Text"],
Cell[661820, 11272, 43, 1, 62, "Input"],
Cell[661866, 11275, 45, 1, 56, "Input"],
Cell[661914, 11278, 209, 7, 67, "Text"],
Cell[662126, 11287, 64, 1, 62, "Input"],
Cell[662193, 11290, 45, 1, 56, "Input"],
Cell[662241, 11293, 336, 7, 91, "Text"],
Cell[662580, 11302, 119, 2, 79, "Input"],
Cell[662702, 11306, 48, 1, 56, "Input"],
Cell[662753, 11309, 48, 1, 56, "Input"],
Cell[662804, 11312, 144, 5, 41, "Text"],
Cell[662951, 11319, 55, 1, 56, "Input"],
Cell[663009, 11322, 150, 6, 42, "Text"],
Cell[663162, 11330, 90, 3, 41, "Text"],
Cell[663255, 11335, 47, 1, 56, "Input"],
Cell[663305, 11338, 127, 3, 66, "Text"],
Cell[663435, 11343, 49, 1, 56, "Input"],
Cell[663487, 11346, 472, 16, 91, "Text"],
Cell[663962, 11364, 40, 1, 56, "Input"],
Cell[664005, 11367, 392, 12, 66, "Text"],
Cell[664400, 11381, 45, 1, 56, "Input"],
Cell[664448, 11384, 409, 10, 91, "Text"],
Cell[664860, 11396, 82, 1, 58, "Input"],
Cell[664945, 11399, 209, 6, 66, "Text"],
Cell[665157, 11407, 131, 2, 103, "Input"],
Cell[665291, 11411, 846, 38, 74, "SeeAlso"],

Cell[CellGroupData[{
Cell[666162, 11453, 82, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[666247, 11456, 250, 5, 50, "Question"],
Cell[666500, 11463, 47, 1, 56, "Input"],
Cell[666550, 11466, 50, 1, 56, "Input"],
Cell[666603, 11469, 304, 6, 71, "Question"],
Cell[666910, 11477, 71, 0, 37, "SmallText"],
Cell[666984, 11479, 65, 1, 56, "Input"],
Cell[667052, 11482, 50, 1, 56, "Input"],
Cell[667105, 11485, 125, 4, 37, "SmallText"],
Cell[667233, 11491, 54, 1, 56, "Input"],
Cell[667290, 11494, 54, 0, 37, "SmallText"],
Cell[667347, 11496, 50, 1, 56, "Input"],
Cell[667400, 11499, 151, 4, 37, "SmallText"],
Cell[667554, 11505, 59, 1, 56, "Input"],
Cell[667616, 11508, 112, 4, 37, "SmallText"],
Cell[667731, 11514, 51, 1, 56, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[667831, 11521, 38, 0, 38, "Subsection"],
Cell[667872, 11523, 318, 9, 66, "Text"],
Cell[668193, 11534, 111, 3, 41, "Text"],
Cell[668307, 11539, 73, 1, 58, "Input"],
Cell[668383, 11542, 126, 4, 41, "Text"],
Cell[668512, 11548, 37, 1, 56, "Input"],
Cell[668552, 11551, 252, 6, 66, "Text"],
Cell[668807, 11559, 65, 1, 58, "Input"],
Cell[668875, 11562, 114, 3, 41, "Text"],
Cell[668992, 11567, 37, 1, 56, "Input"],
Cell[669032, 11570, 302, 10, 66, "Text"],
Cell[669337, 11582, 93, 1, 58, "Input"],
Cell[669433, 11585, 304, 6, 91, "Text"],
Cell[669740, 11593, 195, 3, 103, "Input"],
Cell[669938, 11598, 107, 3, 41, "Text"],
Cell[670048, 11603, 113, 2, 58, "Input"],
Cell[670164, 11607, 692, 19, 141, "Text"],
Cell[670859, 11628, 291, 7, 66, "Text"],
Cell[671153, 11637, 210, 6, 66, "Text"],
Cell[671366, 11645, 123, 2, 79, "Input"],
Cell[671492, 11649, 97, 3, 41, "Text"],
Cell[671592, 11654, 66, 1, 56, "Input"],
Cell[671661, 11657, 472, 13, 91, "Text"],
Cell[672136, 11672, 80, 1, 56, "Input"],
Cell[672219, 11675, 230, 8, 41, "Text"],
Cell[672452, 11685, 80, 1, 56, "Input"],
Cell[672535, 11688, 183, 7, 29, "SeeAlso"],

Cell[CellGroupData[{
Cell[672743, 11699, 76, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[672822, 11702, 208, 5, 50, "Question"],
Cell[673033, 11709, 15460, 537, 182, 6468, 420, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[688496, 12248, 237, 8, 41, "Text"],
Cell[688736, 12258, 79, 1, 56, "Input"],
Cell[688818, 12261, 115, 5, 41, "Text"],
Cell[688936, 12268, 74, 1, 56, "Input"],
Cell[689013, 12271, 114, 5, 41, "Text"],
Cell[689130, 12278, 74, 1, 56, "Input"],
Cell[689207, 12281, 207, 7, 29, "Question"],
Cell[689417, 12290, 178, 5, 41, "Text"],
Cell[689598, 12297, 125, 3, 58, "Input"],
Cell[689726, 12302, 109, 3, 41, "Text"],
Cell[689838, 12307, 142, 5, 29, "Question"],
Cell[689983, 12314, 229, 8, 41, "Text"],
Cell[690215, 12324, 111, 2, 79, "Input"],
Cell[690329, 12328, 140, 4, 41, "Text"],
Cell[690472, 12334, 58, 1, 56, "Input"],
Cell[690533, 12337, 188, 6, 66, "Text"],
Cell[690724, 12345, 104, 2, 56, "Input"],
Cell[690831, 12349, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[690905, 12355, 40, 0, 38, "Subsection"],
Cell[690948, 12357, 269, 8, 66, "Text"],
Cell[691220, 12367, 65, 1, 56, "Input"],
Cell[691288, 12370, 179, 4, 66, "Text"],
Cell[691470, 12376, 89, 1, 56, "Input"],
Cell[691562, 12379, 496, 11, 91, "Text"],
Cell[692061, 12392, 157, 3, 74, "Input"],
Cell[692221, 12397, 98, 3, 41, "Text"],
Cell[692322, 12402, 149, 3, 75, "Input"],
Cell[692474, 12407, 223, 5, 66, "Text"],
Cell[692700, 12414, 59, 1, 56, "Input"],
Cell[692762, 12417, 245, 5, 66, "Text"],
Cell[693010, 12424, 105, 3, 41, "Text"],
Cell[693118, 12429, 69, 1, 58, "Input"],
Cell[693190, 12432, 99, 4, 41, "Text"],
Cell[693292, 12438, 37, 1, 56, "Input"],
Cell[693332, 12441, 139, 3, 41, "Text"],
Cell[693474, 12446, 74, 1, 58, "Input"],
Cell[693551, 12449, 571, 18, 116, "Text"],
Cell[694125, 12469, 168, 4, 66, "Text"],
Cell[694296, 12475, 60, 1, 71, "Input"],
Cell[694359, 12478, 45, 1, 56, "Input"],
Cell[694407, 12481, 221, 4, 91, "Text"],
Cell[694631, 12487, 83, 1, 56, "Input"],
Cell[694717, 12490, 29, 0, 54, "Input"],
Cell[694749, 12492, 256, 7, 66, "Text"],
Cell[695008, 12501, 167, 3, 104, "Input"],
Cell[695178, 12506, 528, 13, 116, "Text"],
Cell[695709, 12521, 138, 2, 79, "Input"],
Cell[695850, 12525, 185, 8, 41, "Text"],
Cell[696038, 12535, 133, 2, 79, "Input"],
Cell[696174, 12539, 140, 5, 41, "Text"],
Cell[696317, 12546, 53, 1, 56, "Input"],
Cell[696373, 12549, 192, 4, 66, "Text"],
Cell[696568, 12555, 40, 1, 56, "Input"],
Cell[696611, 12558, 1022, 28, 166, "Text"],
Cell[697636, 12588, 201, 3, 125, "Input"],
Cell[697840, 12593, 48, 0, 41, "Text"],
Cell[697891, 12595, 133, 2, 79, "Input"],
Cell[698027, 12599, 538, 24, 71, "SeeAlso"],

Cell[CellGroupData[{
Cell[698590, 12627, 54, 0, 54, "Subsubsection"],
Cell[698647, 12629, 505, 13, 97, "Question"],
Cell[699155, 12644, 220, 5, 66, "Text"],
Cell[699378, 12651, 345, 6, 194, "Input"],
Cell[699726, 12659, 140, 3, 66, "Text"],
Cell[699869, 12664, 103, 2, 71, "Input"],
Cell[699975, 12668, 45, 1, 56, "Input"],
Cell[700023, 12671, 106, 3, 41, "Text"],
Cell[700132, 12676, 103, 2, 71, "Input"],
Cell[700238, 12680, 45, 1, 56, "Input"],
Cell[700286, 12683, 72, 0, 41, "Text"],
Cell[700361, 12685, 103, 2, 71, "Input"],
Cell[700467, 12689, 45, 1, 56, "Input"],
Cell[700515, 12692, 128, 2, 41, "Text"],
Cell[700646, 12696, 45, 1, 56, "Input"],
Cell[700694, 12699, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[700768, 12705, 47, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[700840, 12709, 39, 0, 54, "Subsubsection"],
Cell[700882, 12711, 246, 6, 66, "Text"],
Cell[701131, 12719, 950, 34, 141, "Text"],
Cell[702084, 12755, 56, 0, 41, "Text"],
Cell[702143, 12757, 43, 1, 56, "Input"],
Cell[702189, 12760, 68, 0, 41, "Text"],
Cell[702260, 12762, 72, 1, 56, "Input"],
Cell[702335, 12765, 265, 10, 71, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[702637, 12780, 42, 0, 32, "Subsubsection"],
Cell[702682, 12782, 1834, 82, 116, "Text"],
Cell[704519, 12866, 90, 3, 41, "Text"],
Cell[704612, 12871, 39, 0, 54, "Input"],
Cell[704654, 12873, 76, 0, 41, "Text"],
Cell[704733, 12875, 60, 1, 87, "Input"],
Cell[704796, 12878, 120, 3, 41, "Text"],
Cell[704919, 12883, 58, 1, 56, "Input"],
Cell[704980, 12886, 62, 0, 41, "Text"],
Cell[705045, 12888, 40, 1, 56, "Input"],
Cell[705088, 12891, 250, 9, 66, "Text"],
Cell[705341, 12902, 84, 1, 58, "Input"],
Cell[705428, 12905, 110, 4, 41, "Text"],
Cell[705541, 12911, 59, 1, 87, "Input"],
Cell[705603, 12914, 152, 6, 29, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[705792, 12925, 37, 0, 32, "Subsubsection"],
Cell[705832, 12927, 290, 7, 91, "Text"],
Cell[706125, 12936, 64, 1, 56, "Input"],
Cell[706192, 12939, 234, 6, 66, "Text"],
Cell[706429, 12947, 64, 1, 56, "Input"],
Cell[706496, 12950, 254, 8, 66, "Text"],
Cell[706753, 12960, 79, 1, 56, "Input"],
Cell[706835, 12963, 197, 8, 44, "Text"],
Cell[707035, 12973, 72, 1, 68, "Input"],
Cell[707110, 12976, 148, 5, 41, "Text"],
Cell[707261, 12983, 67, 1, 68, "Input"],
Cell[707331, 12986, 194, 6, 66, "Text"],
Cell[707528, 12994, 1240, 49, 116, "Text"],
Cell[708771, 13045, 111, 2, 79, "Input"],
Cell[708885, 13049, 273, 11, 41, "Text"],
Cell[709161, 13062, 88, 3, 41, "Text"],
Cell[709252, 13067, 104, 2, 79, "Input"],
Cell[709359, 13071, 140, 3, 66, "Text"],
Cell[709502, 13076, 258, 11, 47, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[709797, 13092, 85, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[709885, 13095, 159, 5, 29, "Question"],
Cell[710047, 13102, 56, 1, 58, "Input"],
Cell[710106, 13105, 166, 4, 29, "Question"],
Cell[710275, 13111, 57, 1, 56, "Input"],
Cell[710335, 13114, 165, 5, 29, "Question"],
Cell[710503, 13121, 80, 1, 56, "Input"],
Cell[710586, 13124, 244, 7, 50, "Question"],
Cell[710833, 13133, 45, 1, 56, "Input"],
Cell[710881, 13136, 45, 1, 56, "Input"],
Cell[710929, 13139, 494, 17, 55, "Question"],
Cell[711426, 13158, 119, 5, 41, "Text"],
Cell[711548, 13165, 51, 1, 56, "Input"],
Cell[711602, 13168, 67, 1, 71, "Input"],
Cell[711672, 13171, 248, 7, 66, "Text"],
Cell[711923, 13180, 89, 1, 87, "Input"],
Cell[712015, 13183, 128, 5, 41, "Text"],
Cell[712146, 13190, 89, 1, 87, "Input"],
Cell[712238, 13193, 181, 5, 66, "Text"],
Cell[712422, 13200, 55, 1, 85, "Input"],
Cell[712480, 13203, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[712566, 13210, 28, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[712619, 13214, 29, 0, 66, "Subsection"],

Cell[CellGroupData[{
Cell[712673, 13218, 54, 0, 54, "Subsubsection"],
Cell[712730, 13220, 415, 9, 70, "Text"],
Cell[713148, 13231, 60, 1, 70, "Input"],
Cell[713211, 13234, 525, 21, 70, "Text"],
Cell[713739, 13257, 316, 7, 70, "Text"],
Cell[714058, 13266, 65, 1, 70, "Input"],
Cell[714126, 13269, 65, 0, 70, "Text"],
Cell[714194, 13271, 65, 1, 70, "Input"],
Cell[714262, 13274, 183, 4, 70, "Text"],
Cell[714448, 13280, 87, 1, 70, "Input"],
Cell[714538, 13283, 89, 3, 70, "Text"],
Cell[714630, 13288, 73, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[714740, 13294, 43, 0, 32, "Subsubsection"],
Cell[714786, 13296, 485, 15, 70, "Text"],
Cell[715274, 13313, 126, 4, 70, "Text"],
Cell[715403, 13319, 44, 1, 70, "Input"],
Cell[715450, 13322, 149, 4, 70, "Text"],
Cell[715602, 13328, 54, 1, 70, "Input"],
Cell[715659, 13331, 102, 3, 70, "Text"],
Cell[715764, 13336, 66, 1, 70, "Input"],
Cell[715833, 13339, 275, 7, 70, "Text"],
Cell[716111, 13348, 60, 1, 70, "Input"],
Cell[716174, 13351, 357, 9, 70, "Text"],
Cell[716534, 13362, 72, 1, 70, "Input"],
Cell[716609, 13365, 232, 7, 70, "Text"],
Cell[716844, 13374, 54, 1, 70, "Input"],
Cell[716901, 13377, 142, 6, 70, "Text"],
Cell[717046, 13385, 47, 1, 70, "Input"],
Cell[717096, 13388, 644, 22, 70, "Text"],
Cell[717743, 13412, 57, 1, 70, "Input"],
Cell[717803, 13415, 140, 6, 70, "Text"],
Cell[717946, 13423, 46, 1, 70, "Input"],
Cell[717995, 13426, 104, 4, 70, "Text"],
Cell[718102, 13432, 57, 1, 70, "Input"],
Cell[718162, 13435, 71, 0, 70, "Text"],
Cell[718236, 13437, 61, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[718334, 13443, 43, 0, 32, "Subsubsection"],
Cell[718380, 13445, 769, 25, 70, "Text"],
Cell[719152, 13472, 506, 22, 70, "Text"],
Cell[719661, 13496, 885, 26, 70, "Text"],
Cell[720549, 13524, 62, 1, 70, "Input"],
Cell[720614, 13527, 749, 17, 70, "Text"],
Cell[721366, 13546, 105, 3, 70, "Text"],
Cell[721474, 13551, 47, 1, 70, "Input"],
Cell[721524, 13554, 792, 26, 70, "Text"],
Cell[722319, 13582, 1040, 37, 70, "Text"],
Cell[723362, 13621, 717, 29, 70, "Text"],
Cell[724082, 13652, 50, 1, 70, "Input"],
Cell[724135, 13655, 108, 4, 70, "Text"],
Cell[724246, 13661, 79, 1, 70, "Input"],
Cell[724328, 13664, 201, 7, 70, "Text"],
Cell[724532, 13673, 69, 1, 70, "Input"],
Cell[724604, 13676, 149, 6, 70, "Text"],
Cell[724756, 13684, 52, 1, 70, "Input"],
Cell[724811, 13687, 188, 5, 70, "Text"],
Cell[725002, 13694, 76, 1, 70, "Input"],
Cell[725081, 13697, 292, 9, 70, "Text"],
Cell[725376, 13708, 54, 1, 70, "Input"],
Cell[725433, 13711, 389, 12, 70, "Text"],
Cell[725825, 13725, 66, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[725928, 13731, 49, 0, 32, "Subsubsection"],
Cell[725980, 13733, 267, 6, 70, "Text"],
Cell[726250, 13741, 415, 14, 70, "Text"],
Cell[726668, 13757, 47, 1, 70, "Input"],
Cell[726718, 13760, 108, 4, 70, "Text"],
Cell[726829, 13766, 64, 1, 70, "Input"],
Cell[726896, 13769, 129, 4, 70, "Text"],
Cell[727028, 13775, 64, 1, 70, "Input"],
Cell[727095, 13778, 50, 1, 70, "Input"],
Cell[727148, 13781, 172, 5, 70, "Text"],
Cell[727323, 13788, 57, 1, 70, "Input"],
Cell[727383, 13791, 308, 10, 70, "Text"],
Cell[727694, 13803, 26, 0, 70, "Input"],
Cell[727723, 13805, 384, 9, 70, "Text"],
Cell[728110, 13816, 44, 1, 70, "Input"],
Cell[728157, 13819, 80, 1, 70, "Input"],
Cell[728240, 13822, 559, 15, 70, "Text"],
Cell[728802, 13839, 245, 6, 70, "Text"],
Cell[729050, 13847, 72, 1, 70, "Input"],
Cell[729125, 13850, 257, 7, 70, "Text"],
Cell[729385, 13859, 82, 1, 70, "Input"],
Cell[729470, 13862, 222, 5, 70, "Text"],
Cell[729695, 13869, 269, 10, 70, "Text"],
Cell[729967, 13881, 71, 1, 70, "Input"],
Cell[730041, 13884, 146, 4, 70, "Text"],
Cell[730190, 13890, 78, 1, 70, "Input"],
Cell[730271, 13893, 113, 3, 70, "Text"],
Cell[730387, 13898, 48, 1, 70, "Input"],
Cell[730438, 13901, 88, 3, 70, "Text"],
Cell[730529, 13906, 69, 1, 70, "Input"],
Cell[730601, 13909, 64, 0, 70, "Text"],
Cell[730668, 13911, 90, 1, 70, "Input"],
Cell[730761, 13914, 510, 22, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[731308, 13941, 58, 0, 32, "Subsubsection"],
Cell[731369, 13943, 112, 3, 70, "Text"],
Cell[731484, 13948, 128, 3, 70, "Text"],
Cell[731615, 13953, 55, 1, 70, "Input"],
Cell[731673, 13956, 175, 4, 70, "Text"],
Cell[731851, 13962, 44, 1, 70, "Input"],
Cell[731898, 13965, 123, 3, 70, "Text"],
Cell[732024, 13970, 53, 1, 70, "Input"],
Cell[732080, 13973, 91, 3, 70, "Text"],
Cell[732174, 13978, 64, 1, 70, "Input"],
Cell[732241, 13981, 171, 8, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[732449, 13994, 56, 0, 32, "Subsubsection"],
Cell[732508, 13996, 175, 5, 70, "Text"],
Cell[732686, 14003, 73, 1, 70, "Input"],
Cell[732762, 14006, 54, 1, 70, "Input"],
Cell[732819, 14009, 252, 7, 70, "Text"],
Cell[733074, 14018, 79, 1, 70, "Input"],
Cell[733156, 14021, 124, 3, 70, "Text"],
Cell[733283, 14026, 64, 1, 70, "Input"],
Cell[733350, 14029, 85, 3, 70, "Text"],
Cell[733438, 14034, 45, 1, 70, "Input"],
Cell[733486, 14037, 239, 6, 70, "Text"],
Cell[733728, 14045, 82, 1, 70, "Input"],
Cell[733813, 14048, 69, 1, 70, "Input"],
Cell[733885, 14051, 184, 8, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[734106, 14064, 32, 0, 32, "Subsubsection"],
Cell[734141, 14066, 345, 8, 70, "Text"],
Cell[734489, 14076, 49, 1, 70, "Input"],
Cell[734541, 14079, 204, 8, 70, "Text"],
Cell[734748, 14089, 114, 2, 70, "Input"],
Cell[734865, 14093, 125, 3, 70, "Text"],
Cell[734993, 14098, 132, 4, 70, "Text"],
Cell[735128, 14104, 48, 1, 70, "Input"],
Cell[735179, 14107, 158, 5, 70, "Text"],
Cell[735340, 14114, 47, 1, 70, "Input"],
Cell[735390, 14117, 159, 7, 70, "Text"],
Cell[735552, 14126, 72, 1, 70, "Input"],
Cell[735627, 14129, 168, 2, 70, "Text"],
Cell[735798, 14133, 89, 1, 70, "Input"],
Cell[735890, 14136, 92, 4, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[736019, 14145, 124, 4, 33, "Subsubsection"],
Cell[736146, 14151, 205, 6, 66, "Text"],
Cell[736354, 14159, 121, 4, 41, "Text"],
Cell[736478, 14165, 45, 1, 56, "Input"],
Cell[736526, 14168, 412, 17, 66, "Text"],
Cell[736941, 14187, 45, 1, 56, "Input"],
Cell[736989, 14190, 684, 26, 116, "Text"],
Cell[737676, 14218, 60, 1, 56, "Input"],
Cell[737739, 14221, 347, 14, 66, "Text"],
Cell[738089, 14237, 42, 1, 56, "Input"],
Cell[738134, 14240, 584, 20, 91, "Text"],
Cell[738721, 14262, 42, 1, 56, "Input"],
Cell[738766, 14265, 347, 10, 91, "Text"],
Cell[739116, 14277, 49, 1, 56, "Input"],
Cell[739168, 14280, 124, 5, 41, "Text"],
Cell[739295, 14287, 52, 1, 63, "Input"],
Cell[739350, 14290, 147, 6, 29, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[739534, 14301, 43, 0, 32, "Subsubsection"],
Cell[739580, 14303, 123, 3, 29, "Question"],
Cell[739706, 14308, 146, 6, 41, "Text"],
Cell[739855, 14316, 108, 2, 82, "Input"],
Cell[739966, 14320, 48, 0, 41, "Text"],
Cell[740017, 14322, 50, 1, 56, "Input"],
Cell[740070, 14325, 50, 1, 56, "Input"],
Cell[740123, 14328, 36, 0, 41, "Text"],
Cell[740162, 14330, 55, 1, 56, "Input"],
Cell[740220, 14333, 48, 0, 41, "Text"],
Cell[740271, 14335, 42, 1, 56, "Input"],
Cell[740316, 14338, 37, 0, 41, "Text"],
Cell[740356, 14340, 48, 1, 56, "Input"],
Cell[740407, 14343, 61, 0, 41, "Text"],
Cell[740471, 14345, 44, 1, 30, "Input"],
Cell[740518, 14348, 214, 8, 25, "Question"],
Cell[740735, 14358, 138, 5, 33, "Text"],
Cell[740876, 14365, 55, 1, 30, "Input"],
Cell[740934, 14368, 50, 1, 30, "Input"],
Cell[740987, 14371, 281, 12, 43, "Question"],
Cell[741271, 14385, 302, 12, 66, "Text"],
Cell[741576, 14399, 46, 1, 56, "Input"],
Cell[741625, 14402, 196, 6, 66, "Text"],
Cell[741824, 14410, 53, 1, 56, "Input"],
Cell[741880, 14413, 110, 4, 41, "Text"],
Cell[741993, 14419, 55, 1, 56, "Input"],
Cell[742051, 14422, 351, 12, 66, "Text"],
Cell[742405, 14436, 90, 1, 79, "Input"],
Cell[742498, 14439, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[742572, 14445, 57, 0, 38, "Subsection"],
Cell[742632, 14447, 339, 11, 66, "Text"],
Cell[742974, 14460, 44, 1, 56, "Input"],
Cell[743021, 14463, 167, 7, 41, "Text"],
Cell[743191, 14472, 48, 1, 56, "Input"],
Cell[743242, 14475, 588, 16, 116, "Text"],
Cell[743833, 14493, 61, 1, 58, "Input"],
Cell[743897, 14496, 132, 6, 41, "Text"],
Cell[744032, 14504, 41, 1, 56, "Input"],
Cell[744076, 14507, 1116, 43, 141, "Text"],
Cell[745195, 14552, 203, 7, 66, "Text"],
Cell[745401, 14561, 70, 1, 56, "Input"],
Cell[745474, 14564, 261, 9, 66, "Text"],
Cell[745738, 14575, 34, 1, 56, "Input"],
Cell[745775, 14578, 183, 7, 41, "Text"],
Cell[745961, 14587, 78, 1, 56, "Input"],
Cell[746042, 14590, 114, 4, 41, "Text"],
Cell[746159, 14596, 52, 1, 56, "Input"],
Cell[746214, 14599, 272, 9, 66, "Text"],
Cell[746489, 14610, 78, 1, 56, "Input"],
Cell[746570, 14613, 155, 3, 66, "Text"],
Cell[746728, 14618, 127, 3, 56, "Input"],
Cell[746858, 14623, 427, 11, 116, "Text"],
Cell[747288, 14636, 173, 3, 79, "Input"],
Cell[747464, 14641, 288, 6, 91, "Text"],
Cell[747755, 14649, 124, 2, 79, "Input"],
Cell[747882, 14653, 640, 20, 116, "Text"],
Cell[748525, 14675, 313, 6, 91, "Text"],
Cell[748841, 14683, 126, 2, 79, "Input"],
Cell[748970, 14687, 186, 6, 66, "Text"],
Cell[749159, 14695, 212, 5, 66, "Text"],
Cell[749374, 14702, 56, 1, 58, "Input"],
Cell[749433, 14705, 192, 5, 66, "Text"],
Cell[749628, 14712, 66, 1, 58, "Input"],
Cell[749697, 14715, 61, 1, 58, "Input"],
Cell[749761, 14718, 128, 3, 41, "Text"],
Cell[749892, 14723, 85, 1, 58, "Input"],
Cell[749980, 14726, 239, 6, 66, "Text"],
Cell[750222, 14734, 65, 1, 58, "Input"],
Cell[750290, 14737, 375, 11, 91, "Text"],
Cell[750668, 14750, 56, 1, 58, "Input"],
Cell[750727, 14753, 168, 4, 66, "Text"],
Cell[750898, 14759, 44, 1, 56, "Input"],
Cell[750945, 14762, 219, 10, 29, "SeeAlso"],

Cell[CellGroupData[{
Cell[751189, 14776, 71, 0, 54, "Subsubsection"],
Cell[751263, 14778, 213, 8, 29, "Question"],
Cell[751479, 14788, 227, 9, 41, "Text"],
Cell[751709, 14799, 63, 1, 58, "Input"],
Cell[751775, 14802, 361, 15, 50, "Question"],
Cell[752139, 14819, 102, 4, 41, "Text"],
Cell[752244, 14825, 68, 1, 58, "Input"],
Cell[752315, 14828, 96, 5, 41, "Text"],
Cell[752414, 14835, 53, 1, 56, "Input"],
Cell[752470, 14838, 118, 5, 41, "Text"],
Cell[752591, 14845, 101, 5, 41, "Text"],
Cell[752695, 14852, 53, 1, 56, "Input"],
Cell[752751, 14855, 126, 5, 41, "Text"],
Cell[752880, 14862, 100, 5, 41, "Text"],
Cell[752983, 14869, 53, 1, 56, "Input"],
Cell[753039, 14872, 37, 0, 41, "Text"],
Cell[753079, 14874, 109, 3, 41, "Text"],
Cell[753191, 14879, 87, 1, 56, "Input"],
Cell[753281, 14882, 211, 8, 66, "Text"],
Cell[753495, 14892, 92, 1, 56, "Input"],
Cell[753590, 14895, 211, 8, 31, "Question"],
Cell[753804, 14905, 311, 10, 66, "Text"],
Cell[754118, 14917, 88, 1, 58, "Input"],
Cell[754209, 14920, 236, 6, 66, "Text"],
Cell[754448, 14928, 44, 1, 56, "Input"],
Cell[754495, 14931, 155, 5, 41, "Text"],
Cell[754653, 14938, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[754727, 14944, 39, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[754791, 14948, 38, 0, 54, "Subsubsection"],
Cell[754832, 14950, 453, 12, 70, "Text"],
Cell[755288, 14964, 66, 1, 70, "Input"],
Cell[755357, 14967, 179, 5, 70, "Text"],
Cell[755539, 14974, 78, 1, 70, "Input"],
Cell[755620, 14977, 222, 4, 70, "Text"],
Cell[755845, 14983, 64, 1, 70, "Input"],
Cell[755912, 14986, 116, 4, 70, "Text"],
Cell[756031, 14992, 29, 0, 70, "Input"],
Cell[756063, 14994, 60, 1, 70, "Input"],
Cell[756126, 14997, 54, 0, 70, "Text"],
Cell[756183, 14999, 208, 4, 70, "Text"],
Cell[756394, 15005, 354, 9, 70, "Text"],
Cell[756751, 15016, 66, 1, 70, "Input"],
Cell[756820, 15019, 340, 12, 70, "Text"],
Cell[757163, 15033, 67, 1, 70, "Input"],
Cell[757233, 15036, 756, 30, 70, "Text"],
Cell[757992, 15068, 479, 22, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[758508, 15095, 61, 0, 32, "Subsubsection"],
Cell[758572, 15097, 206, 6, 66, "Text"],
Cell[758781, 15105, 68, 1, 56, "Input"],
Cell[758852, 15108, 114, 3, 41, "Text"],
Cell[758969, 15113, 191, 4, 125, "Input"],
Cell[759163, 15119, 186, 5, 66, "Text"],
Cell[759352, 15126, 141, 3, 125, "Input"],
Cell[759496, 15131, 161, 4, 66, "Text"],
Cell[759660, 15137, 49, 1, 56, "Input"],
Cell[759712, 15140, 229, 10, 41, "Text"],
Cell[759944, 15152, 55, 1, 56, "Input"],
Cell[760002, 15155, 209, 5, 66, "Text"],
Cell[760214, 15162, 72, 1, 56, "Input"],
Cell[760289, 15165, 191, 5, 66, "Text"],
Cell[760483, 15172, 74, 1, 56, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[760594, 15178, 53, 0, 32, "Subsubsection"],
Cell[760650, 15180, 189, 5, 29, "Question"],
Cell[760842, 15187, 624, 18, 116, "Text"],
Cell[761469, 15207, 60, 1, 58, "Input"],
Cell[761532, 15210, 228, 6, 66, "Text"],
Cell[761763, 15218, 51, 1, 58, "Input"],
Cell[761817, 15221, 143, 3, 50, "Question"],
Cell[761963, 15226, 99, 3, 41, "Text"],
Cell[762065, 15231, 66, 1, 58, "Input"],
Cell[762134, 15234, 61, 0, 41, "Text"],
Cell[762198, 15236, 61, 1, 58, "Input"],
Cell[762262, 15239, 62, 0, 41, "Text"],
Cell[762327, 15241, 44, 1, 56, "Input"],
Cell[762374, 15244, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[762448, 15250, 43, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[762516, 15254, 85, 1, 54, "Subsubsection"],
Cell[762604, 15257, 346, 9, 70, "Text"],
Cell[762953, 15268, 101, 2, 70, "Input"],
Cell[763057, 15272, 53, 1, 70, "Input"],
Cell[763113, 15275, 212, 8, 70, "Text"],
Cell[763328, 15285, 49, 1, 70, "Input"],
Cell[763380, 15288, 218, 7, 70, "Text"],
Cell[763601, 15297, 53, 1, 70, "Input"],
Cell[763657, 15300, 187, 8, 70, "Text"],
Cell[763847, 15310, 57, 1, 70, "Input"],
Cell[763907, 15313, 478, 11, 70, "Text"],
Cell[764388, 15326, 67, 1, 70, "Input"],
Cell[764458, 15329, 242, 9, 70, "Text"],
Cell[764703, 15340, 58, 1, 70, "Input"],
Cell[764764, 15343, 245, 8, 70, "Text"],
Cell[765012, 15353, 42, 1, 70, "Input"],
Cell[765057, 15356, 110, 3, 70, "Text"],
Cell[765170, 15361, 55, 1, 70, "Input"],
Cell[765228, 15364, 185, 6, 70, "Text"],
Cell[765416, 15372, 53, 1, 70, "Input"],
Cell[765472, 15375, 60, 1, 70, "Input"],
Cell[765535, 15378, 111, 3, 70, "Text"],
Cell[765649, 15383, 73, 1, 70, "Input"],
Cell[765725, 15386, 126, 3, 70, "Text"],
Cell[765854, 15391, 61, 1, 70, "Input"],
Cell[765918, 15394, 276, 9, 70, "Text"],
Cell[766197, 15405, 112, 2, 70, "Input"],
Cell[766312, 15409, 178, 3, 70, "Input"],
Cell[766493, 15414, 163, 5, 70, "Text"],
Cell[766659, 15421, 87, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[766783, 15427, 62, 0, 32, "Subsubsection"],
Cell[766848, 15429, 126, 3, 41, "Text"],
Cell[766977, 15434, 76, 0, 41, "Text"],
Cell[767056, 15436, 55, 1, 58, "Input"],
Cell[767114, 15439, 129, 4, 41, "Text"],
Cell[767246, 15445, 76, 1, 96, "Input"],
Cell[767325, 15448, 216, 6, 66, "Text"],
Cell[767544, 15456, 65, 1, 56, "Input"],
Cell[767612, 15459, 64, 1, 56, "Input"],
Cell[767679, 15462, 296, 6, 91, "Text"],
Cell[767978, 15470, 82, 1, 56, "Input"],
Cell[768063, 15473, 98, 2, 71, "Input"],
Cell[768164, 15477, 213, 5, 66, "Text"],
Cell[768380, 15484, 52, 1, 56, "Input"],
Cell[768435, 15487, 172, 5, 66, "Text"],
Cell[768610, 15494, 115, 2, 56, "Input"],
Cell[768728, 15498, 209, 6, 66, "Text"],
Cell[768940, 15506, 129, 3, 58, "Input"],
Cell[769072, 15511, 339, 13, 66, "Text"],
Cell[769414, 15526, 104, 2, 79, "Input"],
Cell[769521, 15530, 103, 4, 41, "Text"],
Cell[769627, 15536, 76, 1, 75, "Input"],
Cell[769706, 15539, 224, 8, 66, "Text"],
Cell[769933, 15549, 56, 1, 56, "Input"],
Cell[769992, 15552, 193, 7, 44, "Text"],
Cell[770188, 15561, 71, 1, 56, "Input"],
Cell[770262, 15564, 338, 10, 66, "Text"],
Cell[770603, 15576, 108, 5, 44, "Text"],
Cell[770714, 15583, 68, 1, 56, "Input"],
Cell[770785, 15586, 119, 4, 41, "Text"],
Cell[770907, 15592, 79, 1, 56, "Input"],
Cell[770989, 15595, 178, 7, 41, "Text"],
Cell[771170, 15604, 84, 1, 56, "Input"],
Cell[771257, 15607, 66, 0, 41, "Text"],
Cell[771326, 15609, 75, 1, 56, "Input"],
Cell[771404, 15612, 303, 10, 66, "Text"],
Cell[771710, 15624, 66, 1, 56, "Input"],
Cell[771779, 15627, 500, 11, 141, "Text"],
Cell[772282, 15640, 304, 11, 54, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[772623, 15656, 57, 0, 32, "Subsubsection"],
Cell[772683, 15658, 251, 8, 50, "Question"],
Cell[772937, 15668, 45, 0, 37, "SmallText"],
Cell[772985, 15670, 82, 1, 58, "Input"],
Cell[773070, 15673, 172, 7, 37, "SmallText"],
Cell[773245, 15682, 74, 1, 58, "Input"],
Cell[773322, 15685, 181, 5, 58, "SmallText"],
Cell[773506, 15692, 77, 1, 58, "Input"],
Cell[773586, 15695, 93, 4, 37, "SmallText"],
Cell[773682, 15701, 51, 1, 56, "Input"],
Cell[773736, 15704, 289, 6, 71, "Question"],
Cell[774028, 15712, 146, 4, 37, "SmallText"],
Cell[774177, 15718, 115, 3, 79, "Input"],
Cell[774295, 15723, 48, 0, 37, "SmallText"],
Cell[774346, 15725, 58, 1, 56, "Input"],
Cell[774407, 15728, 76, 0, 37, "SmallText"],
Cell[774486, 15730, 60, 1, 56, "Input"],
Cell[774549, 15733, 71, 0, 37, "SmallText"],
Cell[774623, 15735, 52, 1, 56, "Input"],
Cell[774678, 15738, 112, 4, 37, "SmallText"],
Cell[774793, 15744, 137, 2, 79, "Input"],
Cell[774933, 15748, 552, 21, 50, "Question"],
Cell[775488, 15771, 359, 11, 58, "SmallText"],
Cell[775850, 15784, 139, 3, 102, "Input"],
Cell[775992, 15789, 216, 10, 37, "SmallText"],
Cell[776211, 15801, 45, 1, 56, "Input"],
Cell[776259, 15804, 189, 10, 37, "SmallText"],
Cell[776451, 15816, 62, 1, 56, "Input"],
Cell[776516, 15819, 339, 12, 50, "Question"],
Cell[776858, 15833, 197, 5, 35, "Text"],
Cell[777058, 15840, 134, 4, 37, "SmallText"],
Cell[777195, 15846, 66, 1, 56, "Input"],
Cell[777264, 15849, 24, 0, 54, "Input"],
Cell[777291, 15851, 512, 11, 100, "SmallText"],
Cell[777806, 15864, 50, 1, 56, "Input"],
Cell[777859, 15867, 104, 2, 102, "Input"],
Cell[777966, 15871, 179, 6, 37, "SmallText"],
Cell[778148, 15879, 61, 1, 56, "Input"],
Cell[778212, 15882, 191, 8, 37, "SmallText"],
Cell[778406, 15892, 51, 1, 56, "Input"],
Cell[778460, 15895, 50, 0, 37, "SmallText"],
Cell[778513, 15897, 44, 1, 56, "Input"],
Cell[778560, 15900, 113, 5, 37, "SmallText"],
Cell[778676, 15907, 61, 1, 56, "Input"],
Cell[778740, 15910, 57, 0, 37, "SmallText"],
Cell[778800, 15912, 80, 1, 56, "Input"],
Cell[778883, 15915, 64, 0, 37, "SmallText"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[778996, 15921, 41, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[779062, 15925, 45, 0, 54, "Subsubsection"],
Cell[779110, 15927, 89, 3, 70, "Text"],
Cell[779202, 15932, 53, 1, 70, "Input"],
Cell[779258, 15935, 536, 12, 70, "Text"],
Cell[779797, 15949, 463, 12, 70, "Text"],
Cell[780263, 15963, 63, 1, 70, "Input"],
Cell[780329, 15966, 385, 11, 70, "Text"],
Cell[780717, 15979, 156, 3, 70, "Input"],
Cell[780876, 15984, 142, 4, 70, "Text"],
Cell[781021, 15990, 52, 1, 70, "Input"],
Cell[781076, 15993, 36, 1, 70, "Input"],
Cell[781115, 15996, 145, 6, 70, "Text"],
Cell[781263, 16004, 44, 1, 70, "Input"],
Cell[781310, 16007, 172, 4, 70, "Text"],
Cell[781485, 16013, 70, 1, 70, "Input"],
Cell[781558, 16016, 163, 4, 70, "Text"],
Cell[781724, 16022, 51, 1, 70, "Input"],
Cell[781778, 16025, 443, 15, 70, "Text"],
Cell[782224, 16042, 40, 1, 70, "Input"],
Cell[782267, 16045, 44, 1, 70, "Input"],
Cell[782314, 16048, 46, 1, 70, "Input"],
Cell[782363, 16051, 382, 11, 70, "Text"],
Cell[782748, 16064, 43, 1, 70, "Input"],
Cell[782794, 16067, 155, 6, 70, "Text"],
Cell[782952, 16075, 77, 1, 70, "Input"],
Cell[783032, 16078, 89, 3, 70, "Text"],
Cell[783124, 16083, 40, 1, 70, "Input"],
Cell[783167, 16086, 179, 6, 70, "Text"],
Cell[783349, 16094, 45, 1, 70, "Input"],
Cell[783397, 16097, 508, 15, 70, "Text"],
Cell[783908, 16114, 43, 1, 70, "Input"],
Cell[783954, 16117, 224, 7, 70, "Text"],
Cell[784181, 16126, 73, 1, 70, "Input"],
Cell[784257, 16129, 44, 1, 70, "Input"],
Cell[784304, 16132, 76, 0, 70, "Text"],
Cell[784383, 16134, 40, 1, 70, "Input"],
Cell[784426, 16137, 103, 3, 70, "Text"],
Cell[784532, 16142, 45, 1, 70, "Input"],
Cell[784580, 16145, 395, 20, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[785012, 16170, 39, 0, 32, "Subsubsection"],
Cell[785054, 16172, 415, 14, 70, "Text"],
Cell[785472, 16188, 81, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[785556, 16192, 339, 16, 70, "Text"],
Cell[785898, 16210, 85, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[785986, 16214, 480, 23, 70, "Text"],
Cell[786469, 16239, 89, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[786561, 16243, 426, 17, 70, "Text"],
Cell[786990, 16262, 106, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[787099, 16266, 251, 5, 70, "Text"],
Cell[787353, 16273, 129, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[787485, 16277, 177, 6, 70, "Text"],
Cell[787665, 16285, 89, 2, 70, "Input",
  CellGroupingRules->"NormalGrouping"],
Cell[787757, 16289, 554, 28, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[788348, 16322, 51, 0, 32, "Subsubsection"],
Cell[788402, 16324, 166, 5, 41, "Text"],
Cell[788571, 16331, 169, 5, 66, "Text"],
Cell[788743, 16338, 67, 1, 56, "Input"],
Cell[788813, 16341, 330, 10, 66, "Text"],
Cell[789146, 16353, 51, 1, 56, "Input"],
Cell[789200, 16356, 530, 14, 116, "Text"],
Cell[789733, 16372, 48, 1, 56, "Input"],
Cell[789784, 16375, 117, 3, 41, "Text"],
Cell[789904, 16380, 44, 1, 56, "Input"],
Cell[789951, 16383, 49, 0, 41, "Text"],
Cell[790003, 16385, 43, 1, 56, "Input"],
Cell[790049, 16388, 389, 9, 91, "Text"],
Cell[790441, 16399, 59, 1, 56, "Input"],
Cell[790503, 16402, 188, 5, 66, "Text"],
Cell[790694, 16409, 67, 1, 56, "Input"],
Cell[790764, 16412, 201, 4, 66, "Text"],
Cell[790968, 16418, 69, 1, 56, "Input"],
Cell[791040, 16421, 164, 6, 41, "Text"],
Cell[791207, 16429, 66, 1, 56, "Input"],
Cell[791276, 16432, 282, 14, 29, "SeeAlso"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[791619, 16453, 27, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[791671, 16457, 46, 0, 66, "Subsection"],

Cell[CellGroupData[{
Cell[791742, 16461, 29, 0, 54, "Subsubsection"],
Cell[791774, 16463, 387, 11, 53, "Text"],
Cell[792164, 16476, 65, 1, 22, "Input"],
Cell[792232, 16479, 127, 3, 23, "Text"],
Cell[792362, 16484, 85, 1, 22, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[792484, 16490, 32, 0, 32, "Subsubsection"],
Cell[792519, 16492, 382, 13, 53, "Text"],
Cell[792904, 16507, 46, 1, 22, "Input"],
Cell[792953, 16510, 419, 13, 38, "Text"],
Cell[793375, 16525, 77, 1, 27, "Input"],
Cell[793455, 16528, 151, 4, 23, "Text"],
Cell[793609, 16534, 118, 2, 27, "Input"],
Cell[793730, 16538, 511, 13, 68, "Text"],
Cell[794244, 16553, 243, 4, 67, "Input"],
Cell[794490, 16559, 129, 2, 70, "Text"],
Cell[794622, 16563, 175, 8, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[794834, 16576, 39, 0, 32, "Subsubsection"],
Cell[794876, 16578, 445, 11, 70, "Text"],
Cell[795324, 16591, 89, 1, 70, "Input"],
Cell[795416, 16594, 300, 7, 70, "Text"],
Cell[795719, 16603, 127, 2, 70, "Input"],
Cell[795849, 16607, 236, 7, 70, "Text"],
Cell[796088, 16616, 186, 3, 70, "Input"],
Cell[796277, 16621, 142, 5, 70, "Text"],
Cell[796422, 16628, 261, 4, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[796720, 16637, 37, 0, 32, "Subsubsection"],
Cell[796760, 16639, 259, 6, 70, "Text"],
Cell[797022, 16647, 68, 1, 70, "Input"],
Cell[797093, 16650, 1644, 69, 70, "Text"],
Cell[798740, 16721, 141, 2, 70, "Input"],
Cell[798884, 16725, 166, 4, 70, "Text"],
Cell[799053, 16731, 254, 4, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[799344, 16740, 60, 0, 32, "Subsubsection"],
Cell[799407, 16742, 359, 9, 70, "Text"],
Cell[799769, 16753, 349, 11, 70, "Text"],
Cell[800121, 16766, 487, 9, 70, "Text"],
Cell[800611, 16777, 102, 2, 70, "Input"],
Cell[800716, 16781, 1189, 40, 70, "Text"],
Cell[801908, 16823, 110, 2, 70, "Input"],
Cell[802021, 16827, 872, 35, 70, "Text"],
Cell[802896, 16864, 225, 6, 70, "Text"],
Cell[803124, 16872, 62, 1, 70, "Input"],
Cell[803189, 16875, 69, 0, 70, "Text"],
Cell[803261, 16877, 52, 1, 70, "Input"],
Cell[803316, 16880, 111, 4, 70, "Text"],
Cell[803430, 16886, 40, 1, 70, "Input"],
Cell[803473, 16889, 596, 20, 70, "Text"],
Cell[804072, 16911, 429, 11, 70, "Text"],
Cell[804504, 16924, 135, 2, 70, "Input"],
Cell[804642, 16928, 163, 4, 70, "Text"],
Cell[804808, 16934, 172, 3, 70, "Input"],
Cell[804983, 16939, 290, 8, 70, "Text"],
Cell[805276, 16949, 144, 3, 70, "Input"],
Cell[805423, 16954, 279, 12, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[805739, 16971, 41, 0, 32, "Subsubsection"],
Cell[805783, 16973, 185, 4, 70, "Text"],
Cell[805971, 16979, 508, 15, 70, "Text"],
Cell[806482, 16996, 86, 1, 70, "Input"],
Cell[806571, 16999, 174, 5, 70, "Text"],
Cell[806748, 17006, 166, 3, 70, "Input"],
Cell[806917, 17011, 179, 5, 70, "Text"],
Cell[807099, 17018, 133, 3, 70, "Input"],
Cell[807235, 17023, 207, 8, 70, "Text"],
Cell[807445, 17033, 53, 1, 70, "Input"],
Cell[807501, 17036, 144, 4, 70, "Text"],
Cell[807648, 17042, 185, 3, 70, "Input"],
Cell[807836, 17047, 102, 4, 70, "Text"],
Cell[807941, 17053, 53, 1, 70, "Input"],
Cell[807997, 17056, 257, 7, 70, "Text"],
Cell[808257, 17065, 117, 2, 70, "Input"],
Cell[808377, 17069, 380, 10, 70, "Text"],
Cell[808760, 17081, 64, 1, 70, "Input"],
Cell[808827, 17084, 193, 4, 70, "Input"],
Cell[809023, 17090, 198, 4, 70, "Input"],
Cell[809224, 17096, 181, 8, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[809442, 17109, 117, 5, 33, "Subsubsection"],
Cell[809562, 17116, 953, 22, 191, "Text"],
Cell[810518, 17140, 303, 7, 91, "Text"],
Cell[810824, 17149, 391, 7, 116, "Text"],
Cell[811218, 17158, 77, 1, 56, "Input"],
Cell[811298, 17161, 103, 2, 56, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[811438, 17168, 84, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[811525, 17171, 347, 9, 71, "Question"],
Cell[811875, 17182, 62, 1, 56, "Input"],
Cell[811940, 17185, 311, 9, 50, "Question"],
Cell[812254, 17196, 83, 1, 58, "Input"],
Cell[812340, 17199, 350, 10, 50, "Question"],
Cell[812693, 17211, 235, 4, 104, "Input"],
Cell[812931, 17217, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[813005, 17223, 48, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[813078, 17227, 31, 0, 54, "Subsubsection"],
Cell[813112, 17229, 278, 8, 38, "Text"],
Cell[813393, 17239, 88, 1, 22, "Input"],
Cell[813484, 17242, 166, 4, 70, "Text"],
Cell[813653, 17248, 535, 11, 70, "Text"],
Cell[814191, 17261, 71, 0, 70, "Text"],
Cell[814265, 17263, 172, 3, 70, "Input"],
Cell[814440, 17268, 218, 10, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[814695, 17283, 47, 0, 32, "Subsubsection"],
Cell[814745, 17285, 435, 10, 70, "Text"],
Cell[815183, 17297, 75, 1, 70, "Input"],
Cell[815261, 17300, 539, 12, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[815837, 17317, 41, 0, 32, "Subsubsection"],
Cell[815881, 17319, 264, 7, 66, "Text"],
Cell[816148, 17328, 178, 5, 66, "Text"],
Cell[816329, 17335, 123, 2, 79, "Input"],
Cell[816455, 17339, 102, 3, 41, "Text"],
Cell[816560, 17344, 141, 2, 102, "Input"],
Cell[816704, 17348, 191, 5, 66, "Text"],
Cell[816898, 17355, 216, 3, 125, "Input"],
Cell[817117, 17360, 193, 6, 66, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[817347, 17371, 86, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[817436, 17374, 252, 10, 29, "Question"],
Cell[817691, 17386, 97, 2, 56, "Input"],
Cell[817791, 17390, 443, 11, 71, "Question"],
Cell[818237, 17403, 234, 4, 102, "Input"],
Cell[818474, 17409, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[818548, 17415, 50, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[818623, 17419, 52, 0, 54, "Subsubsection"],
Cell[818678, 17421, 357, 10, 53, "Text"],
Cell[819038, 17433, 208, 4, 70, "Text"],
Cell[819249, 17439, 100, 2, 70, "Input"],
Cell[819352, 17443, 200, 4, 70, "Text"],
Cell[819555, 17449, 101, 2, 70, "Input"],
Cell[819659, 17453, 257, 12, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[819953, 17470, 38, 0, 32, "Subsubsection"],
Cell[819994, 17472, 305, 6, 91, "Text"],
Cell[820302, 17480, 69, 1, 56, "Input"],
Cell[820374, 17483, 2150, 93, 91, "Text"],
Cell[822527, 17578, 166, 3, 81, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[822730, 17586, 88, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[822821, 17589, 267, 6, 50, "Question"],
Cell[823091, 17597, 108, 2, 79, "Input"],
Cell[823202, 17601, 189, 3, 102, "Input"],
Cell[823394, 17606, 385, 13, 50, "Question"],
Cell[823782, 17621, 108, 2, 79, "Input"],
Cell[823893, 17625, 189, 3, 102, "Input"],
Cell[824085, 17630, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[824159, 17636, 35, 0, 38, "Subsection"],
Cell[824197, 17638, 422, 7, 141, "Text"],
Cell[824622, 17647, 131, 3, 79, "Input"],
Cell[824756, 17652, 877, 27, 166, "Text"],
Cell[825636, 17681, 112, 2, 79, "Input"],
Cell[825751, 17685, 330, 10, 66, "Text"],
Cell[826084, 17697, 151, 3, 79, "Input"],
Cell[826238, 17702, 384, 7, 116, "Text"],
Cell[826625, 17711, 79, 1, 58, "Input"],
Cell[826707, 17714, 68, 0, 41, "Text"],
Cell[826778, 17716, 123, 3, 79, "Input"],
Cell[826904, 17721, 58, 0, 41, "Text"],
Cell[826965, 17723, 77, 1, 56, "Input"],
Cell[827045, 17726, 343, 11, 91, "Text"],
Cell[827391, 17739, 163, 3, 79, "Input"],
Cell[827557, 17744, 63, 1, 56, "Input"],
Cell[827623, 17747, 189, 5, 66, "Text"],
Cell[827815, 17754, 68, 1, 56, "Input"],

Cell[CellGroupData[{
Cell[827908, 17759, 73, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[827984, 17762, 474, 18, 44, "Question"],
Cell[828461, 17782, 145, 3, 31, "Input"],
Cell[828609, 17787, 90, 1, 30, "Input"],
Cell[828702, 17790, 614, 17, 62, "Question"],
Cell[829319, 17809, 69, 1, 30, "Input"],
Cell[829391, 17812, 119, 3, 30, "Input"],
Cell[829513, 17817, 71, 1, 31, "Input"],
Cell[829587, 17820, 103, 2, 30, "Input"],
Cell[829693, 17824, 65, 1, 30, "Input"],
Cell[829761, 17827, 25, 0, 25, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[829835, 17833, 41, 0, 38, "Subsection"],
Cell[829879, 17835, 388, 10, 91, "Text"],
Cell[830270, 17847, 160, 4, 66, "Text"],
Cell[830433, 17853, 144, 3, 66, "Text"],
Cell[830580, 17858, 686, 26, 56, "Input"],
Cell[831269, 17886, 393, 18, 66, "Text"],
Cell[831665, 17906, 1800, 78, 116, "Text"],
Cell[833468, 17986, 89, 3, 41, "Text"],
Cell[833560, 17991, 409, 8, 194, "Input"],
Cell[833972, 18001, 51, 0, 41, "Text"],
Cell[834026, 18003, 796, 14, 376, "Input"],
Cell[834825, 18019, 173, 6, 41, "Text"],
Cell[835001, 18027, 427, 9, 241, "Input"],
Cell[835431, 18038, 182, 5, 66, "Text"],

Cell[CellGroupData[{
Cell[835638, 18047, 94, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[835735, 18050, 374, 10, 60, "Question"],
Cell[836112, 18062, 272, 5, 90, "Input"],
Cell[836387, 18069, 38, 0, 33, "Text"],
Cell[836428, 18071, 577, 9, 150, "Input"],
Cell[837008, 18082, 25, 0, 25, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[837082, 18088, 42, 0, 38, "Subsection"],
Cell[837127, 18090, 356, 10, 91, "Text"],
Cell[837486, 18102, 62, 1, 56, "Input"],
Cell[837551, 18105, 243, 7, 66, "Text"],
Cell[837797, 18114, 35, 0, 54, "Input"],
Cell[837835, 18116, 694, 30, 66, "Text"],
Cell[838532, 18148, 206, 9, 41, "Text"],
Cell[838741, 18159, 79, 1, 56, "Input"],
Cell[838823, 18162, 280, 9, 66, "Text"],
Cell[839106, 18173, 111, 2, 79, "Input"],
Cell[839220, 18177, 90, 3, 41, "Text"],
Cell[839313, 18182, 65, 1, 56, "Input"],
Cell[839381, 18185, 88, 3, 41, "Text"],
Cell[839472, 18190, 75, 1, 56, "Input"],
Cell[839550, 18193, 95, 4, 29, "SeeAlso"],

Cell[CellGroupData[{
Cell[839670, 18201, 80, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[839753, 18204, 525, 17, 44, "Question"],
Cell[840281, 18223, 105, 4, 34, "Text"],
Cell[840389, 18229, 62, 1, 30, "Input"],
Cell[840454, 18232, 45, 0, 33, "Text"],
Cell[840502, 18234, 88, 1, 30, "Input"],
Cell[840593, 18237, 68, 0, 33, "Text"],
Cell[840664, 18239, 92, 1, 30, "Input"],
Cell[840759, 18242, 110, 4, 34, "Text"],
Cell[840872, 18248, 133, 2, 30, "Input"],
Cell[841008, 18252, 108, 4, 34, "Text"],
Cell[841119, 18258, 131, 2, 50, "Input"],
Cell[841253, 18262, 66, 0, 25, "Question"],
Cell[841322, 18264, 186, 4, 70, "Input"],
Cell[841511, 18270, 25, 0, 25, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[841585, 18276, 42, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[841652, 18280, 31, 0, 54, "Subsubsection"],
Cell[841686, 18282, 165, 4, 66, "Text"],
Cell[841854, 18288, 220, 5, 66, "Text"],
Cell[842077, 18295, 302, 9, 91, "Text"],
Cell[842382, 18306, 61, 1, 56, "Input"],
Cell[842446, 18309, 415, 16, 66, "Text"],
Cell[842864, 18327, 241, 4, 125, "Input"],
Cell[843108, 18333, 82, 4, 29, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[843227, 18342, 39, 0, 32, "Subsubsection"],
Cell[843269, 18344, 440, 17, 66, "Text"],
Cell[843712, 18363, 84, 1, 56, "Input"],
Cell[843799, 18366, 149, 5, 41, "Text"],
Cell[843951, 18373, 288, 5, 148, "Input"],
Cell[844242, 18380, 533, 17, 116, "Text"],
Cell[844778, 18399, 411, 7, 194, "Input"],
Cell[845192, 18408, 366, 7, 91, "Text"],
Cell[845561, 18417, 589, 10, 282, "Input"],
Cell[846153, 18429, 216, 10, 29, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[846406, 18444, 41, 0, 32, "Subsubsection"],
Cell[846450, 18446, 390, 10, 91, "Text"],
Cell[846843, 18458, 291, 6, 91, "Text"],
Cell[847137, 18466, 77, 1, 56, "Input"],
Cell[847217, 18469, 189, 5, 66, "Text"],
Cell[847409, 18476, 72, 1, 56, "Input"],
Cell[847484, 18479, 240, 8, 66, "Text"],
Cell[847727, 18489, 64, 1, 56, "Input"],
Cell[847794, 18492, 786, 33, 91, "Text"],
Cell[848583, 18527, 214, 5, 66, "Text"],
Cell[848800, 18534, 395, 8, 116, "Text"],
Cell[849198, 18544, 139, 6, 29, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[849374, 18555, 80, 1, 32, "Subsubsection",
  PageBreakAbove->True],
Cell[849457, 18558, 416, 10, 71, "Question"],
Cell[849876, 18570, 332, 5, 150, "Input"],
Cell[850211, 18577, 25, 0, 29, "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[850285, 18583, 31, 0, 38, "Subsection"],
Cell[850319, 18585, 313, 9, 91, "Text"],
Cell[850635, 18596, 775, 23, 166, "Text"],
Cell[851413, 18621, 149, 3, 102, "Input"],
Cell[851565, 18626, 196, 6, 66, "Text"],
Cell[851764, 18634, 191, 5, 66, "Text"],
Cell[851958, 18641, 65, 1, 56, "Input"],
Cell[852026, 18644, 89, 3, 41, "Text"],
Cell[852118, 18649, 38, 0, 54, "Input"],
Cell[852159, 18651, 1017, 41, 66, "Text"],
Cell[853179, 18694, 87, 1, 56, "Input"],
Cell[853269, 18697, 196, 6, 66, "Text"],
Cell[853468, 18705, 329, 10, 91, "Text"],
Cell[853800, 18717, 268, 6, 66, "Text"],
Cell[854071, 18725, 110, 2, 79, "Input"],
Cell[854184, 18729, 196, 6, 66, "Text"],
Cell[854383, 18737, 102, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[854510, 18744, 69, 1, 54, "Subsubsection",
  PageBreakAbove->True],
Cell[854582, 18747, 390, 12, 43, "Question"],
Cell[854975, 18761, 193, 4, 70, "Input"],
Cell[855171, 18767, 204, 5, 53, "Text"],
Cell[855378, 18774, 80, 1, 30, "Input"],
Cell[855461, 18777, 229, 6, 43, "Question"],
Cell[855693, 18785, 156, 6, 34, "Text"],
Cell[855852, 18793, 65, 1, 30, "Input"],
Cell[855920, 18796, 134, 3, 31, "Input"],
Cell[856057, 18801, 91, 1, 30, "Input"],
Cell[856151, 18804, 98, 3, 33, "Text"],
Cell[856252, 18809, 82, 1, 30, "Input"],
Cell[856337, 18812, 25, 0, 25, "EndExercises"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[856423, 18819, 36, 0, 50, "Section"],
Cell[856462, 18821, 413, 12, 52, "Text"],

Cell[CellGroupData[{
Cell[856900, 18837, 100, 4, 48, "Subsection"],
Cell[857003, 18843, 346, 7, 71, "Text"],
Cell[857352, 18852, 44, 1, 70, "Input"],
Cell[857399, 18855, 116, 3, 70, "Text"],
Cell[857518, 18860, 44, 1, 70, "Input"],
Cell[857565, 18863, 292, 8, 70, "Text"],
Cell[857860, 18873, 218, 7, 70, "Text"],
Cell[858081, 18882, 47, 1, 70, "Input"],
Cell[858131, 18885, 67, 1, 70, "Input"],
Cell[858201, 18888, 149, 5, 70, "Text"],
Cell[858353, 18895, 66, 1, 70, "Input"],
Cell[858422, 18898, 86, 1, 70, "Text",
  PageBreakAbove->True],
Cell[858511, 18901, 46, 1, 70, "Input"],
Cell[858560, 18904, 106, 4, 70, "Text"],
Cell[858669, 18910, 27, 0, 70, "Input"],
Cell[858699, 18912, 296, 9, 70, "Text"],
Cell[858998, 18923, 74, 1, 70, "Input"],
Cell[859075, 18926, 144, 3, 70, "Text"],
Cell[859222, 18931, 82, 1, 70, "Input"],
Cell[859307, 18934, 88, 1, 70, "Input"],
Cell[859398, 18937, 441, 12, 70, "Text"],
Cell[859842, 18951, 93, 1, 70, "Input"],
Cell[859938, 18954, 83, 1, 70, "Input"],
Cell[860024, 18957, 125, 4, 70, "Text"],
Cell[860152, 18963, 108, 2, 70, "Input"],
Cell[860263, 18967, 48, 0, 70, "Text"],
Cell[860314, 18969, 74, 1, 70, "Input"],
Cell[860391, 18972, 184, 8, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[860612, 18985, 50, 0, 31, "Subsection"],
Cell[860665, 18987, 456, 12, 70, "Text"],
Cell[861124, 19001, 221, 5, 70, "Text"],
Cell[861348, 19008, 81, 1, 70, "Input"],
Cell[861432, 19011, 109, 3, 70, "Text"],
Cell[861544, 19016, 21, 0, 70, "Input"],
Cell[861568, 19018, 259, 5, 70, "Text"],
Cell[861830, 19025, 163, 4, 70, "Input"],
Cell[861996, 19031, 74, 0, 70, "Text"],
Cell[862073, 19033, 97, 2, 70, "Input"],
Cell[862173, 19037, 105, 3, 70, "Text"],
Cell[862281, 19042, 79, 1, 70, "Input"],
Cell[862363, 19045, 100, 3, 70, "Text"],
Cell[862466, 19050, 62, 1, 70, "Input"],
Cell[862531, 19053, 64, 0, 70, "Text"],
Cell[862598, 19055, 56, 1, 70, "Input"],
Cell[862657, 19058, 49, 1, 70, "Input"],
Cell[862709, 19061, 382, 11, 70, "Text"],
Cell[863094, 19074, 70, 1, 70, "Input"],
Cell[863167, 19077, 30, 0, 70, "Input"],
Cell[863200, 19079, 131, 4, 70, "Text"],
Cell[863334, 19085, 125, 3, 70, "Input"],
Cell[863462, 19090, 46, 0, 70, "Text"],
Cell[863511, 19092, 93, 1, 70, "Input"],
Cell[863607, 19095, 244, 7, 70, "Text"],
Cell[863854, 19104, 91, 1, 70, "Input"],
Cell[863948, 19107, 111, 4, 70, "Text"],
Cell[864062, 19113, 127, 2, 70, "Input"],
Cell[864192, 19117, 220, 5, 70, "Text"],
Cell[864415, 19124, 74, 1, 70, "Input"],
Cell[864492, 19127, 179, 4, 70, "Text"],
Cell[864674, 19133, 74, 1, 70, "Input"],
Cell[864751, 19136, 388, 9, 70, "Text"],
Cell[865142, 19147, 70, 1, 70, "Input"],
Cell[865215, 19150, 95, 3, 70, "Text"],
Cell[865313, 19155, 121, 2, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[865471, 19162, 51, 0, 31, "Subsection"],
Cell[865525, 19164, 93, 3, 70, "Text"],
Cell[865621, 19169, 70, 1, 70, "Input"],
Cell[865694, 19172, 277, 8, 70, "Text"],
Cell[865974, 19182, 99, 2, 70, "Input"],
Cell[866076, 19186, 176, 4, 70, "Text"],
Cell[866255, 19192, 48, 1, 70, "Input"],
Cell[866306, 19195, 155, 2, 70, "Input"],
Cell[866464, 19199, 227, 7, 70, "Text"],
Cell[866694, 19208, 66, 1, 70, "Input"],
Cell[866763, 19211, 97, 2, 70, "Input"],
Cell[866863, 19215, 84, 4, 70, "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{
Cell[866984, 19224, 39, 0, 31, "Subsection"],
Cell[867026, 19226, 277, 8, 70, "Text"],
Cell[867306, 19236, 49, 1, 70, "Input"],
Cell[867358, 19239, 65, 0, 70, "Text"],
Cell[867426, 19241, 29, 0, 70, "Input"],
Cell[867458, 19243, 153, 2, 70, "Text"],
Cell[867614, 19247, 43, 1, 70, "Input"],
Cell[867660, 19250, 45, 1, 70, "Input"],
Cell[867708, 19253, 41, 1, 70, "Input"],
Cell[867752, 19256, 107, 3, 70, "Text"],
Cell[867862, 19261, 39, 1, 70, "Input"],
Cell[867904, 19264, 104, 3, 70, "Text"],
Cell[868011, 19269, 47, 1, 70, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

