(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     54924,       1773]*)
(*NotebookOutlinePosition[    103140,       3130]*)
(*  CellTagsIndexPosition[    103096,       3126]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:800006B000`400?l00000o`00003oo`00003o
000008X00000003o00000?l00000RP0000000?l00000o`00002:00000000o`00003o000008X00000
000:0000000>05eMG@2l_;`0jn_[0>c/k031`L407QhN0000000L71`0QXJ60<[:bP3[jn/0gmoO0:^[
Z`1ADE420000000;06UYJ@3GemL0e=CD055AD@0000009BDU0<S8b03De=@0bl_;01DE5@1RHV800P3F
e]H01P20P8000000000000000000JFUY0=KFeP80dM7A00h0dm?C0=KFeP16ATH0ATI60=CDe03EeMD0
TY:B00X:2P2b/[80e=CD0=WIf@1^KVh0HV9R0=KFeP80dM7A01d0dm?C0=SHf01PH600;2`/0=7Ad@3F
e]H0P820000000061PH0[Jf]0=GEe@3De=@0DE5A0000000=3@d0Ng]k0<c<c03]kNd0iNGU09bLW00@
4100`/;20=;BdP3AdM40d];B0=?Cd`3<[[@0/0HU0:l07P050:l080030:l07`2_01h0[`0O0080[`0P
0P2_01l0102d1B<0/P<S0;838`2b0b<20;838P<0/P<S00<0/P<R0;438@2b0b800P2b0b<30;838P@0
/P<S00<0/@<Q0;838P2b0b<00`2b0b<00`2a0b40/P<R0;838`0<0;838`030;838P2b0b<0/P<S0080
/P<S0P2b0b840;838`80/P<R0`2b0b<00`2b0b80/@<Q0;838P040;838`030;D3902F1Al03`l?0?l0
3`l?00<07QhN000000000000fP00000000T0000000<0Rh^;0?ooo`3oool00`3oool00`0T92@07alO
0=WIf@060?ooo`0307]kN`000000Ph>30080oooo00<0Hf=S0000002n_[h00`3oool01@0K6a/0O7al
0?ooo`3oool0WinO00<0000000<0QHF50?ooo`3oool00`3oool01P1IFET0F5QH0?ooo`3oool0/K6a
075aL@80oooo00<0h^;R01XJ6P1mOGd01@3oool01`1iNGT0>3Ph0?ooo`3oool0X:2P00000024Q8@0
0`3oool00`1SHf<01@D50;fm_@040?ooo`030=cLg00G5aL0m?Cd00@0oooo00<0nMOM0=L7;P3E02@0
1@3F02L01@3E0240f0/`0=L4:`3F02H0eP0W0080e`@Z00@0e`D/0=H1:03F02L0eP0W0P3G12X30=H0
9`090=D08@3H2c00e`@[0=H09P3F02L0e`L]0=D08P3G0bX0eP<Y0080eP0W00X0e@0S0=P9;`3F0BL0
eP0U0=H09`3F02P0e@0R0=L9;P3F0BP0eP0U303F02L0203G1R`0eP4X0=H09`3F02L0eP0V0=L6;03F
0RP0eP0V0P3F02L00`3F02H0e`L]0=H09`030=H09`030=H09@3H3C80eP0U00D0eP0W00<0]`0Q0000
00000000oP0000000`0;2`/000000000003J00000000200000002@0h>3P0oOgm0?ooo`3oool0alO7
09BDU037alL0=3@d09bLW0020?ooo`030>KViP2FUYH0^[Zj0080oooo00<0oOgm024Q8@1gMgL00P3o
ool00`1EEED0H61P0?ooo`020?ooo`030?Shn00J6QX0N7Qh0080oooo00D0Z:RX01`L700L71`00000
07moO`020?ooo`050<30`01KFe/0GemO01XJ6P1NGUh00P3oool01`3Jf]X0k>c/0?ooo`3_knl0@d=3
00000021PH400P3oool01@30`<00Fe]K065QH@0V9RH0@T920080oooo00<0T92@034a<@3kno/00`3o
ool04@1FEUH0GemO0?ooo`3oool0o_kn0;6a/@2HV9P0_Kfm01hN7P3/k>`0oooo0?[jnP1iNGT0FEUI
071?E@3A0R40eP0V00@0eP0W00`0e@0O0>=CK@3d^L@0fado0=D08`3D01d0iF1g0>ELM@3/QYP0fQTl
0=D08`3D01d20>IQN@0I0=@07@3F02L0e@0O0>=CK@3d^L@0fado0=D08`3D01d0jG>80>f>X03aZKL0
fADi0=D08`3E0200gRi>0?Fob@3YN8d0eP8T0=H09P3E0200gBm?0?G0bP3^UJH0ePDW0=H09@090=H0
9`0F0=H09@3G0bX0kYFU0=XH>`3E02<0eP0W0=D08@3M;dl0jWjB0=D08P3F02H0eP0W0=@07@3TFG80
iEae0=@07P3F02L0e00O0>AJL`3c]l80i5Yc0=@07`@0eP0W00<0/@0P000000000000oP0000000`0?
3`l000000000003J00000000200000003`2>SXh0oooo0?ooo`34a<@02`/;0000000<30`08R8R0>CT
i03oool0o?cl04a<C00000000P820;Zj^P020?ooo`0<06=SH`1_Kfl0oooo0?Win@2@T900i>CT0?oo
o`3bl_80oooo0?Shn00J6QX0N7Qh0P3oool01@3inOT0k^k^0>7Qh@000000Ng]k0080oooo00D0k^k^
0=;BdP35aLD00000061PH0050?ooo`040=?Cd`0d=3@000000820P080oooo00D0k^k^0=;BdP34a<@0
000004E5A@020?ooo`080:6QX@32`/80oooo0>c/k03kno/0oooo06EUI@2h^;P20?ooo`0<09:BTP00
0000000001XJ6P0F5QH0kno_0?ooo`3no_h0f][J0=;BdP24AE40`00E103F02L03@3F02@0e`d`0?G4
c@3O=eH0e@4T0=H09`3D01/0ifb20?6Y]P3d_LL0fQPk0=D08`3D01`00P3YL8H06@3D01`0eP0T0=L=
<03ea<d0gcMF0=D1903F02L0e00L0>AJL`3ieM`0lkG10=L4:@3F02D0e00L0>b8VP3_UjL0mKo90=TC
=`3E02<0e00L0>fAXP3XLHL0l:Bb0>51G`3D01l02@3F02L05P3F02D0e`<Z0?:]^@3J73l0e@0S0=H0
9`3E0240iF1h0?WIg`3J6ch0e@0R0=H09P3F12H0kiJV0?Bja@3F0bH0eP0U0=@07`3ZP9@0l[6n0>^1
U@3D01l40=H09`030;408000000000000?h0000000<03`l?000000000000fP00000000P0000000@0
Vi^K0?ooo`3oool0YJFU0`0000001@0@4100l?3`0?ooo`3jn_X0<C4a0080000000<0YZJV0?ooo`3o
ool00P1^KVh02P3oool0n_[j0?;blP3oool0alO70;fm_@3oool0n?Sh01XJ6P1hN7P20?ooo`050?Ge
m@3Vi^H0emOG0000001lO7`0103oool00`3dm?@00@4105mOG`020?ooo`070>3Ph02[Zj/0moOg0?oo
o`3Zj^X04a<C07UiN@040?ooo`030?Cdm0030`<0@d=30080oooo00P0kno_0?ooo`3QhN40Xj>S0?gm
o@3oool0JFUY0<C4a080oooo00H0JFUY0000000000000000010@403`l?040?ooo`0309mDH@2m01D0
eP0W00<0eP0W00d0e@0S0=TC=`3gb]80f0db0=D08P3F02L0e00K0>IWO`3e`l`0m/SA0=TE>@3E02<0
e00L0080j6j301T0e00L0=D08`3I4cL0ml[B0=P=<P3E0280eP0W0=D08P3L8T@0nMOM0>YmT@3D01`0
eP0V0=@07P3^UJH0jWfA0>MXOP3G22d0e@0U0=@07P3_VZX0he=]0>jFYP3SCf/0e00N00T0eP0W01H0
eP0U0=L1:03aY[@0fQ/n0=D08`3F02@0f0/`0?:/^@3b[k/0i5E_0=@07P3E0240gS1@0?>g`@3d^lD0
fQLl0=D08`3D01/0iEYd0?_Xk03UFg@0e00K103F02L00`2a020000000000003n0000000300l?3`00
000000000=X0000000080000000905IFEP3oool0oooo0?KfmP1eMGD0ATI608Z:RP0g=cL0^KVi0080
oooo00@0bl_;05YJFP2:RXX0n?Sh0P3oool00`0i>CT0M7Ad0?ooo`020?ooo`070?;blP0l?3`0a/K6
0?ooo`3hn?P06QXJ07QhN0020?ooo`050;Ng]`14A4@0ADE500X:2P1mOGd00P3oool01@2d];@0>c/k
03/k>`000000HV9R0080oooo00<0/[:b01hN7P3Shn<00P3oool01@0e=CD0M7Ad0?ooo`3oool0];Bd
0080>c/k00<00P8204I6AP3oool00`3oool01P1OGel0SHf=0?ooo`3oool0FEUI0861P@80oooo00d0
g]kN05YJFP1;Bd/0TY:B01lO7`3/k>`0oooo0?[jnP1OGel0>SXj04/]<`3=01/0eP0V00<0eP0W00d0
eP0V0=D18@3ZNi00lk>n0=TF>@3E02<0e00L0>M]P`3WJX40kiVX0=XL?`3E02<0e00L0080j6n401T0
e00L0=H09P3E0B40jW^@0?>c_P3I5ST0e@0S0=H0903G12X0n=3G0>AJM03D01`0eP0W0=@07@3RBfL0
mlWA0>YhS@3F0RD0eP0V0=@07P3QAV<0mlWB0?:_^`3H3S00e@0T00T0eP0W01H0e@0S0=XH?03fbM80
fQPk0=D08`3F02D0eP@W0>j@X@3c]l80gRi>0=D08@3E02<0fQTk0?:^^`3aYK<0e``^0=D0903D01`0
i5Uc0?O@f03TFG<0e00L103F02L00`2a020000000000003n0000000300l?3`00000000000=X00000
00080000000300H61P2k^k/0oooo00@0oooo00<08b<S04A4A03gmoL01P3oool00`2d];@00@4107em
O@030?ooo`070861P@000000e=CD0?ooo`3hn?P06QXJ07QhN0020?ooo`050?KfmP3Vi^H0j>SX04U9
B@1bLW800P3oool01@3^k^h0d];B0=CDe00_;bl0FUYJ0080oooo00L0mOGe0>KViP3oool0oooo0>7Q
h@0=3@d0NWYj0080oooo00D0kno_0=;BdP3De=@0<S8b03hn?P030?ooo`030;bl_0000000VIVI0080
oooo00<0G5aL01HF5P3Vi^H0103oool02P3Kfm/05aLG0>c/k03oool0o_kn0=_Kf`3AdM40f;Fl0=L5
;03E02@40=H09`040=H09@3F02L0gS9A0=P:<080eP0U00H0fADh0=XF>@3K7T00e`D[0=H09P3F02D2
0=XE>@070=H09@3F02L0eP0U0=H09`3N<U80f0X`0=H09@020=H09`030=`Q@`3H3C80eP0U0080eP0W
00@0eP0T0=h`C`3J63`0eP0T0P3F02L0103E02@0gRm>0=XH?03E02<:0=H09`0:0=H09@3H3340gS1@
0=L3:P3F02H0eP0W0=D08`3I53P0gBU:0=D08`80eP0W00X0e@0T0=`RA03J6ch0e@0T0=H09`3F02H0
e`@[0=dZB`3G12/0eP0V103F02L00`2a020000000000003n0000000300l?3`00000000000=X00000
00090000000;01<C4`2QXJ40lo?c0?knoP3oool0l?3`02PX:0000000@d=30<G5a@3kno/00P3oool0
4@3/k>`0UiNG00T92@000000NGUi0?gmo@3lo?`0`L7100d=3@030`<0f][J0?gmo@3emOD0410@07al
O03oool0oOgm00<0oooo00@0BTY:06UYJ@3moOd0oOgm0`3oool0100b<S80Cdm?0?gmo@3lo?`20?oo
o`070?knoP3Cdm<0BTY:0000001jNWX0oOgm0?knoP030?ooo`0803De=@0d=3@0oooo0?ooo`3_knl0
8R8R0000002FUYH20?ooo`0505]KF`0000009BDU0;Fe]@3emOD00P3oool00`3<c<`05QHF0>[ZjP02
0?gmo@80oooo00L0n=?J0=P1:03D01l0eP0Q0=L08`3G0280e@0R0080e`0R00`0e00I0=D0803G0280
e@0R0=D07P3F01h0e`0J0=P07`3G0280e@0R0=D07P3G01h20=D08P0?0=P08@3G0240eP0J0=D0803E
0280e`0R0=L08`3E01/0e@0O0=P08P3H0240e@0R0=D08@3D01X0e@0N0080e`0R00T0e@0R0=D08@3F
01P0e`0L0=D08P3H0240f00P0=L08P3E02800P3F02820=D08P80f00P00T0f00Q0=D0803D01T0e`0Q
0=H08P3E0280f00R0=H07`3F01X00P3E0280103H0240e`0S0=H06P3G01/30=D08P060=H0803D01X0
e@0P0=P08@3H0200f00Q0P3E02800`2b01`000000000003n0000000300l?3`00000000000=X00000
000;0000000<04E5A@2c/k<0_[jn071`L0061PH08R8R05IFEP1]KFd0K6a/05UIF@1=CDd09BDU0P00
00004`0n?Sh0SHf=0;jn_P2DU9@0>3Ph000000010@40>c/k09ZJVP2OWil0H61P01`L701`L700XZ:R
0:2PX02FUYH0N7Qh07IfMP1lO7`00P2PX:006`2NWYh0HF5Q09FEU@1_Kfl0MWIf0::RXP2CTi<0L71`
0451@@0_;bl03@d=000000051@D0MWIf0::RXP2?Shl0?clo04a<C02MWId0LG5a05MGE`0o?cl0@410
02/[:`0o?cl0HF5Q08R8R002061PH00:07YjNP1PH600F5QH06MWI`23Ph<0NWYj04];B`0W9bL02PX:
09FEU@@0X:2P02<0SHR906U<DP1eEEX0K4aA03853@1B8RX0M5eR04XN9P0e1@h0LU1F07EEFP1_CeD0
MUEJ07IEF`1WAT`0>1HL02X:401G>d00MeIK07=CF01PADT0Le=H07IIGP1F:340=@D<04dP:01eFEh0
M5QM04DL900e1@h0KdiD07MGG@1F=cd0DRP_07IHG@0307EDFP0/06I9CP1OA4P0MUEK079>E00f31<0
BB0W07ELH@1C9Bd0<`/B06]9C`1fEE/0L51F07EDF@1fEE/0Kd]B02l<4P0Z2@h0DBD]07IIGP1fEEX0
F3m306i?E01gEU/0HDA903D53P1;7RH0MEUN07IIGP1F:340=@D=02h83`1D5B00PeUQ08iVK@1_CeD0
KTmD07IEFP1dEe`0?A`R02X93@0o7B<0MEQM07IEFP1G?T;o00000040000000<03`l?000000000000
fP00000000/0000000H0N7Qh0?gmo@3moOd0]kNg0000002<S8`20?ooo`060;>c/`00000000000000
000a<C40_;bl0`3oool03P3moOd0g]kN075aL@00000010@40>g]k@3moOd0lo?c018B4P38b<P0oOgm
0?ooo`22PX80LW9b0P3oool01@3no_h0oooo0?clo01?Cdl0h>3P00<0oooo00@0o_kn0>_[j`2VYZH0
6QXJ0P0000002P18B4P0o_kn0?gmo@3YjNT000000492@P3lo?`0oooo0>o_k`0820P2000000030;no
_`3oool0oooo0080C4a<103oool01P3moOd0fMWI07EeM@00000030`<0>k^kP80oOgm0P3oool08P39
bl/0KWEc0:ji]`2V];401PD505ADE02__;X0HV9R0000002LZ:H0[kZh0828Q`29TY00[kZh0:>]Z`17
BDP0<cDd08J>S@2_^[P0Yk6`05QNG@2W/K00[kZh06E/JP000000:b/[0:jj^02_^kT0>SXj0000002?
VYP0[kZh06ieL`0m@3l20:nj^080/;^i0180VZBR05eSHP2_^[P0[;Ne01LH600m@3l0[kZh07MnO@00
0000Qi2>0:nj^02=UY@0OXF40:nj^02Z]K<0AdY9030b<P1iP7h20:nj^00@04M<B`2FX9h0[kZh08fH
UP0000009bLW0:fi]`2_^[P0I6]Z0000000j>SX0WJJU0:nj^02`^kT0Z[Fc08F=R`80[kZh00<0HFMV
02`^;P1NHf800P2_^[P00`1UK6/000000000003n0000000300l?3`00000000000=X00000000:0000
000700D51@3Fe]H0oooo0?ooo`3/k>`051@D0;Ng]`020?ooo`050?KfmP0X:2P0000000h>3P3De=@0
0`3oool02P3bl_80oooo0?ooo`3oool0FUYJ00@4103`l?00oooo0>SXj02:RXX20?ooo`030<c<c009
2@T0NWYj00<0oooo00L0o_kn0?_kn`1GEeL0i>CT0?ooo`3no_h0lO7a00<0oooo00@0b<S800H61P00
0000WIfM0`3oool00`0j>SX0N7Qh0?ooo`020?ooo`0405mOG`00000000000;Rh^080oooo0P1EEED2
0?ooo`030?Win@3dm?@0oooo0080oooo01@0KFe]00820P3`l?00oooo0?knoP3<c<`0`L7109FEU@0n
?Sh0/K6a0;:b/P0n@400K6e]0;:b/P2WZ:P07b0P08j>SP2b/[80MgMg03dm?@H0/[:b0240Xj>S02DU
9@2XZ:P0/[:b08>3P`00000051@D0:b/[02b/[80FU]K0000001bLW80/[:b09>CT`0_;bl0[jn_0;:b
/P2VYZH0QhN707emO@0j>SX0[Jf]0;:b/P1=CDd0FEUI0;:b/P2_[jl0:b/[07UiN@2b/[80S8b<034a
<@2`/;001@2b/[80302][Jd092@T08J6QP2b/[80Z:RX00P92@0A4Q80[:b/0;:b/P1oOgl04a<C0:>T
Y080/[:b00@0[Zj^0:n_[`1VIVH0U9BD1P2b/[800`19BDT000000000003n0000000300l?3`000000
00000=X00000000:0000000703dm?@3no_h0oooo0?ooo`3moOd0E5AD0=cLg0030?ooo`0308Z:RP00
0000KVi^0080oooo00@0i>CT04Y:BP0_;bl0ZJVY0P3oool01@3:b/X04a<C0>c/k03oool0oOgm0080
oooo00@0l?3`0410@0000000PH610P3oool02P2e]KD0@41003lo?`0Q8B40kNg]0?ooo`3inOT0BTY:
05UIF@3_knl20?ooo`0303hn?P071`L0i>CT00<0oooo00<0Ng]k0:6QX@3oool00P3oool01035aLD0
0@410000002h^;P20?ooo`80EEEE0P3oool00`31`L40<C4a09VIV@020?ooo`0=0<c<c00G5aL0k>c/
0?ooo`3kno/0P82006QXJ00_;bl020P80:2PX02b/[80Jf][08B4Q0020;:b/P0@06UYJ@23Ph<0/[:b
07inOP0410@0T92@0;:b/P2][Jd0LG5a0:ZZZP2b/[80Rh^;00P8202IVIT0/[:b09bLW0800`<30180
WIfM0;:b/P2CTi<0GUiN096AT@2b/[80YZJV02DU9@2VYZH0/[:b09BDU018B4P0@T9200P8202>SXh0
/[:b07YjNP1gMgL20;:b/P0F07MgM`1dM7@0/[:b09>CT`020P80OWin0;:b/P2a/K40MgMg0:6QX@2b
/[80WinO00@4101`L700/[:b0;2`/00S8b<00@4109ZJVP2b/[80U9BD03Ti>@80/[:b00D0UiNG02XZ
:P0[:b/0<30`05EEE@020;:b/P0508>3P`2>SXh0/[:b0;6a/@0[:b/0o`0000010000000300l?3`00
000000000=X00000000:0000000=0:RXZ03oool0i>CT0<C4a03oool0`l?30?KfmP3Ogml0clo?0?oo
o`3IfMT00@4109jNWP020?ooo`0A09fMW@000000000002`/;03lo?`0oooo0>k^kP0P8200jn_[0?oo
o`3no_h0oOgm0?ooo`3moOd0_Kfm01DE5@1jNWX00P3oool02P2GUiL000000000000<30`0lO7a0?oo
o`3hn?P07QhN0000002j^[X20?ooo`0?06m_K`1JFUX0oooo0?KfmP2l_;`0oooo0<o?c`3UiND0kno_
0;no_`3oool0o?cl02`/;0000000^;Rh0080oooo0P1EEED20?ooo`080;Fe]@0000007alO0?[jnP3o
ool0m?Cd03Ti>@3Xj>P40?ooo`0K08F5Q@000000Lg=c0;:b/P2JVYX0YJFU0:n_[`2XZ:P0YJFU09>C
T`2b/[80P82000000012@T80/[:b0:n_[`0g=cL0WYjN0;:b/P1^KVh0000008:2PP2b/[80[:b/01<C
4`000000Ph>300D0/[:b00<0[jn_034a<@2@T900102b/[805@0J6QX0FEUI0;:b/P2UYJD0VYZJ0:n_
[`2XZ:P0ZZZZ08n?S`2b/[80Ti>C0000000];Bd0/[:b0;6a/@16ATH0QhN70;:b/P24Q8@0000005UI
F@020;:b/P0903/k>`000000Ph>30;:b/P2SXj<0BDU90;2`/02b/[80KFe]00<0000000P04A4A0:>S
X`2b/[80Hf=S069RHP2b/[80Z:RX00l?3ol000000@0000000`0?3`l000000000003J000000002@00
00001@0F5QH0k^k^0?ooo`2ZZZX0MGEe00<0oooo00H0Shn?08Z:RP3oool0o_kn03Xj>P1kNg/20?oo
o`040=3@d00O7al02`/;08:2PP80oooo00L0g=cL01TI6@3/k>`0oooo0>o_k`0c<c<0^k^k0080oooo
00D0IfMW06i^KP3oool0oooo09bLW0020000000700l?3`3`l?00oooo0?Shn00^;Rh0:RXZ0>7Qh@02
0?ooo`0605=CD`2a/K40oooo0>?Sh`1ADE40no_k0P3oool01`35aLD0HV9R0?ooo`3oool0PH610000
002g]kL00P3oool205EEE@80oooo00l0^KVi00`<301]KFd0o_kn0?ooo`3Kfm/08B4Q0>_[j`3oool0
o?cl0:BTY02DU9@0ATI600000010@4000`2b/[800`2@T900KVi^0;:b/P020;:b/P0D0820P0000000
1@D509FEU@2b/[80Q8B40:FUY@2b/[80D51@00820P1YJFT0/[:b0;6a/@0b<S800@4106][J`2b/[80
/K6a0:FUY@2WYjL20;:b/P0804A4A01eMGD0/[:b0;6a/@1gMgL0IFEU01@D500X:2P30;:b/P0309nO
W`1RHV80/[:b0080/[:b0240Ti>C00<30`000000Q8B40;:b/P2;Rh/0W9bL0;:b/P1SHf<00`<304=3
@`2a/K40/[:b05QHF0020P80JFUY0;:b/P2^[Zh0@41009jNWP2b/[80VIVI01TI6@0000008B4Q0000
001IFET0/[:b0:6QX@28R8P0/[:b08Z:RP010@40o`0000010000000300l?3`00000000000=X00000
00090000000605eMG@3oool0oooo0820P00/;2`0o_kn0P3oool01`1HF5P0E5AD0?ooo`3oool0YZJV
01`L703bl_800P3oool00`3Vi^H0c/k>0?ooo`020?ooo`0708R8R0051@D0kno_0?ooo`3emOD0MgMg
0=GEe@020?ooo`05065QH@1_Kfl0oooo0?ooo`2LW9`00P0000001P0?3`l0l?3`0?ooo`3moOd0d=3@
0>g]k@80oooo00L0fm_K03De=@3alO40oooo0;jn_P0>3Ph0hN7Q0080oooo00L0V9RH020P803inOT0
oooo0=oOg`0<30`0/k>c0080oooo0P1EEED20?ooo`030>k^kP3@d=00oooo0080oooo00/0RXZ:00<3
0`3_knl0oooo0?_kn`29RHT0Lg=c059BDP0000004Q8B0:JVYP020;:b/P030820P00S8b<0[Jf]0080
/[:b00@0P820000000000000B4Q80`2b/[80102`/;00?Cdm07MgM`2IVIT20;:b/P0;09ZJVP1aLG40
Fe]K0;:b/P2_[jl0;bl_02@T902][Jd0/[:b05ADE01LG5`00P2b/[801@1YJFT0D51@03Hf=P061PH0
V9RH0080/[:b00<0UYJF01TI6@2SXj<00P2b/[80102CTi<01@D50000000d=3@40;:b/P0804E5A@1J
FUX0TI6A0;6a/@2b/[80XZ:R07emO@1fMWH20;:b/P0>0410@01ADE40/[:b0;:b/P2MWId0O7al0:2P
X00E5AD03Ph>0:FUY@2b/[80/K6a0;:b/P1]KFgo00000080000000<03`l?000000000000fP000000
00P0000000L020P80=?Cd`3oool0oooo05YJFP010@40jNWY0080oooo00P0;Bd]02HV9P3oool0oooo
0?knoP0N7Qh0Fe]K0?7al@D0oooo00@0/;2`010@400;2`/0no_k1@3oool00`3Cdm<04Q8B0820P002
0?ooo`050:>SX`0000000000010@403kno/01@3oool00`3Lg=`0?clo092@T0020?ooo`0309NGU`00
0000[jn_0080oooo00<0K6a/0000003Ogml00P3oool0101LG5`0/k>c0?ooo`3oool205UIF@H0oooo
00@0];Bd01LG5`0:2PX0no_k103oool01038b<P0000000000021PH420;:b/P0307]kN`000000Ogmo
0080/[:b00D0QhN700000000000020P809fMW@020;:b/P030:n_[`0J6QX0Vi^K00D0/[:b00T0Fe]K
0;:b/P2b/[80=cLg0000002SXj<0/[:b071`L01=CDd0102b/[800`2GUiL0000006YZJP020;:b/P03
092@T0000000JFUY0080/[:b00D0VYZJ00D51@0000000@4108Z:RP030;:b/P03028R8P1^KVh0/[:b
00@0/[:b00H0QHF50;:b/P2b/[80HF5Q00<30`1eMGD40;:b/P0302l_;`000000H61P00<0/[:b00<0
DU9B000000000000o`0000000`0?3`l000000000003J00000000200000006P0K6a/0/[:b0;Jf]P2a
/K409BDU0000001cLg<0^[Zj0:>SX`061PH00P8209JFUP2g]kL0^[Zj04=3@`000000<c<c08n?S`31
`L40d=3@0:JVYP1PH60010@40000000;2`/0ZZZZ0P2e]KD02@2g]kL0ZZZZ07moO`0O7al0000005]K
F`2i^KT0^;Rh06i^KP020000000H00/;2`2ZZZX0]KFe0;Fe]@2c/k<0V9RH06UYJ@0J6QX0000009BD
U02f][H0]kNg04e=C@000000BTY:0;Jf]P2c/k<0:b/[0000001^KVh0^KVi0;Ng]`1[Jf/0NGUi0P2g
]kL203`l?00:0;Ng]`2e]KD0][Jf0:^[Z`2<S8`0CTi>00<30`0000002`/;0:ZZZP<0]KFe00D0^;Rh
08>3P`000000000003`l?0020820P00604a<C0000000;bl_07inOP20P800Fe]K0`0000001`16ATH0
P8200820P01/K6`00`<305UIF@20P8000`1nOWh02P1jNWX0?clo07MgM`21PH40=cLg0000001PH600
PH6105aLG00[:b/307inOP0=07moO`1cLg<00@4102d];@1nOWh0P82005YJFP0000008B4Q07emO@20
P800J6QX00<30`0200000007030`<01nOWh0Ogmo07MgM`030`<0?3`l0861P@0307inOP0B0820P01H
F5P0LW9b0820P01BDU80000000410@12@T80Ng]k09>CT`20P8008B4Q0000000E5AD0Ng]k07moO`1n
OWh09bLWo`0000020000000300/;2`00000000000=X00000001X0000000301hN7P0?3`l03`l?0?l0
3`l?@@0?3`l00`0N7Qh000000000003J00000000o`00003o000008X00000003o00000?l00000RP00
00000?l00000o`00002:00000000\
\>"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  CellFrameMargins->4,
  ImageSize->{648, 25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[0]],

Cell[CellGroupData[{

Cell["Introduction to Numerics", "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[CellGroupData[{

Cell["Abstract", "Subsection"],

Cell["\<\

If all problems could be solved analytically, there would be no need for \
numerical approximations.  However, many important problems have no analytic \
solution, take too long to compute one, or are posed with inexact input.   \
The numerical functions in Mathematica offer a variety of sophisticated \
numerical algorithms that allow you to continue from symbolic calculations.  \
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This notebook will give a brief overview of some of the numerical \
functions in Mathematica and show some of their typical uses.  \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This tutorial is written for Version 3.0 ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Initialization", "Subsection"],

Cell[BoxData[
    \(SetOptions[Plot, \ Frame -> True, Axes -> False, \n\tGridLines -> None, 
      \n\tPlotStyle -> {Hue[0], RGBColor[0, 0, 1]}, ImageSize -> {400, 280}]; 
    SetOptions[ParametricPlot, \ Frame -> False, Axes -> True, \n\t
      GridLines -> None, \n\tPlotStyle -> {Hue[0], RGBColor[0, 0, 1]}, 
      ImageSize -> {400, 280}]; \n
    SetOptions[ListPlot, Frame -> True, PlotRange -> All, PlotJoined -> True, 
      GridLines -> Automatic, ImageSize -> {400, 300}]; \n
    Off[General::spell]; \nOff[General::spell1]; \)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerical Expressions", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " works with many different types of numerical expressions,  numbers and \
formulae that contain numbers.  This is one of its strengths."
}], "Text"],

Cell[CellGroupData[{

Cell["Numbers", "Subsection"],

Cell["Two basic types of numbers, exact and approximate.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["For example, ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Sqrt[2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "is an exact quantity representing the positive root of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 \[Equal] 2\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
When exact quantities are used in calculations, the results are \
exact:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((Sqrt[2])\)^2\)], "Input"],

Cell[BoxData[
    \(Log[Sqrt[2]] - Log[2]/2\)], "Input"],

Cell["\<\
Numbers can typically be represented by decimals.  When the number \
of digits is restricted, we have an approximation.  For example,\
\>", "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell["approx = N[Sqrt[2]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "is an inexact approximation to the positive root of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 \[Equal] 2\)]],
  ".    ",
  StyleBox["N", "InlineInput"],
  " calculates the numerical approximation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
When inexact numbers are used in calculations, the result are \
inexact:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(approx^2\)], "Input",
  AspectRatioFixed->True],

Cell["(Note the decimal point)", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Log[approx] - Log[2]/2\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "These approximate numbers are machine numbers.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can generate arbitrary precision approximations to numeric quantities.  \
The precision refers to the number of correct digits in the approximation.   \
Such numbers are often called bignums."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["For example,", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["approx32 = N[Sqrt[2],32]", "Input",
  AspectRatioFixed->True],

Cell["has 32 correct digits.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Now suppose we do a calculation, as before", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["approx32^2", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It is obvious here that the result is correct, in other cases, you may \
want to know how many digits are likely to be correct.  Mathematica has a \
command, ",
  StyleBox["Precision", "InlineInput"],
  ", that gives you this information."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Precision[%]", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulae", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  can also work with a formula,  a compound mathematical expression."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\ f = 
      1/\((\((x - 0.2)\)^2 + 0.01)\) + 1/\((\((x - 0.8)\)^2 + 0.04)\)\)\)], 
  "Input"],

Cell["\<\
There are lots of things we can do with this formula,   plot \
it.\
\>", "Text"],

Cell[BoxData[
    \(\(Plot[f, {x, \(-1\), 2}, Frame -> True]; \)\)], "Input"],

Cell["Differentiate it.", "Text"],

Cell[BoxData[
    \(D[f, x]\)], "Input"],

Cell["Plot the derivative.", "Text"],

Cell[BoxData[
    \(\(Plot[%, {x, \(-1\), 2}, PlotRange -> All]; \)\)], "Input"],

Cell[TextData[{
  "In the original picture we could see a minimum,   let's search for the \
minimum near ",
  StyleBox["0.5", "InlineInput"],
  "."
}], "Text"],

Cell["FindMinimum[f,{x,0.5}]", "Input",
  AspectRatioFixed->True],

Cell["\<\
A list results,  the first element is the minimum value,  the \
second the value of x.  We substitute in as follows.\
\>", "Text"],

Cell[BoxData[
    \(f /. Last[%]\)], "Input"],

Cell["\<\
Something else we can do is quadrature...  area under the \
curve.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[f, {x, 0, 1}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Summary", "Subsection"],

Cell[TextData[{
  "This is a basic part of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " numerics,  so to summarize."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " works with numbers and symbols"
}], "Indent"],

Cell["Hybrid (mix numeric and symbolic) methods", "Indent"],

Cell["Numbers can be exact or inexact", "Indent"],

Cell["Inexact numbers can be machine or arbitrary precision", "Indent"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Finding Roots", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["FindRoot", "InlineInput"],
  " is the basic function for finding roots."
}], "Text"],

Cell[TextData[{
  "Computing the square root of 2, provides a good example.  Of course ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has it's own square root function,\nbut this makes a good example."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["FindRoot[x^2 == 2,{x,1}]", "Input",
  AspectRatioFixed->True],

Cell["Making a plot often helps see what we are doing.", "Text"],

Cell[BoxData[
    \(\(Plot[x\^2, {x, 0, 3}, Prolog -> Line[{{0, 2}, {3, 2}}]]; \)\)], 
  "Input"],

Cell["\<\
The command above used Newton's method.  This is the best method to \
use when the derivative of the function can be computed directly.  Sometimes \
this is not possible, in which case it is best to use the secant method \
(Brent's method in 1D if the root is bracketed).  This is done by specifying \
two starting points for the algorithm.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["FindRoot[x^2 == 2,{x,0,1}]", "Input",
  AspectRatioFixed->True],

Cell["The root is reasonably accurate:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["x^2 /. %", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Suppose you wanted to know how many digits of the root were correct.  This \
is easy to do in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by using bignums.  In ",
  StyleBox["FindRoot", "InlineInput"],
  " (and most other numerical functions as well), the precision of numbers \
used is controlled by the option ",
  StyleBox["WorkingPrecision", "InlineInput"],
  ".  For example, to work with 32 digits, you can use"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["FindRoot[x^2 == 2,{x,0,1},WorkingPrecision->32]", "Input",
  AspectRatioFixed->True],

Cell["two = x^2 /. %", "Input",
  AspectRatioFixed->True],

Cell["This does not have 32 digits correct:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["two-2", "Input",
  AspectRatioFixed->True],

Cell["\<\
But Mathematica still claims that the precision of \"two\" is 32.  \
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Precision[two]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The discrepency is a part of the nature of numerical analysis.  In doing \
any numerical procedure, there are typically two types of errors.  Arithmetic \
(roundoff) error and truncation (algorithm) error.  The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  StyleBox["Precision", "InlineInput"],
  " keeps track only of the arithmetic error.  The truncation error is \
controlled by the algorithm.  In this case, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is using the secant method, which iteratively improves the result.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " must decide at some point when to stop the iterations.  This is \
controlled by the option ",
  StyleBox["AccuracyGoal", "InlineInput"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The default ",
  StyleBox["AccuracyGoal", "InlineInput"],
  "->",
  StyleBox["Automatic", "InlineInput"],
  " tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to stop the iterations when the value of the function is zero accurate to \
",
  StyleBox["WorkingPrecision", "InlineInput"],
  "-10 digits.  Why not go all the way to ",
  StyleBox["WorkingPrecision", "InlineInput"],
  " digits?  This may not always be possible arithmetically, as roundoff \
error may exceed the truncation error.  You can see that the result above  \
had the function value ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-26\)\)]],
  ", which is less than the stopping criterion ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-22\)\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["FindRoot", "InlineInput"],
  " will also do multidimensional root finding.  For example, consider the \
problem of finding the value of b for which the curve ",
  Cell[BoxData[
      \(TraditionalForm\`y = b\^x\)]],
  " is tangent to the line ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Define the objective function.   ",
  Cell[BoxData[
      \(TraditionalForm\`b\^x \[Equal] x\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`D[\ b\^x, x] \[Equal] 1\)]],
  ".     Use dot product to combine."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["func  = {b^x-x,D[b^x,x]-1};", "Input",
  AspectRatioFixed->True],

Cell["So find root of the dot product.", "Text"],

Cell[BoxData[
    \(func . func\)], "Input"],

Cell["\<\
One way to obtain starting values is to use a plot to estimate \
where the root might be:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ContourPlot[func.func,{x,.1,4},{b,.1,4},
\tPlotPoints->30,
\tContours->{0.1,1,2},
\tPlotRange->{0,2}];\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
It looks like a good bet to try a value somewhere in the innermost \
contour.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["FindRoot[func,{x,2},{b,1.5}]", "Input",
  AspectRatioFixed->True],

Cell["A plot also verifies that we have the right solution:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Plot[{t,b^t /. %},{t,0,4}];", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It would be possible to use ",
  StyleBox["FindMinimum", "InlineInput"],
  " to find this solution."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Linear Algebra", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The symbolic/numeric hybrid approach applies also to linear algebra.  For \
large matrices,  symbolic calculations are generally impractical.  In this \
section we will look at some examples of numerical computation with matrices \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "When we think about matrices we should bear in mind that many techniques \
can be generalized to more general tensors.  Tensors can be described with \
n-indices,  rather than the two indices that are used for matrices.   The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " implementation is very general."
}], "Text"],

Cell[CellGroupData[{

Cell["Constructing Matrices", "Subsection"],

Cell[TextData[{
  StyleBox["Table", "InlineInput"],
  " is a basic constructor for matrices.     Here we get a ",
  StyleBox["4\[Times]4", "InlineInput"],
  " matrix of random values."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["M = Table[Random[],{4},{4}]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Matrices are formed with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists;  this means they work nicely with other parts of the system.  By \
default they do not format like matrices,  this can be done with ",
  StyleBox["MatrixForm", "InlineInput"],
  "."
}], "Text"],

Cell[BoxData[
    \(M // MatrixForm\)], "Input"],

Cell[TextData[{
  "Looking at the prettified form can obscure some important details,  so \
generally it would not be good to wrap result from ",
  StyleBox["Table", "InlineInput"],
  " in ",
  StyleBox["MatrixForm", "InlineInput"],
  ",  before assigning to a variable."
}], "Text"],

Cell["We can just type the list notation in directly.", "Text"],

Cell[BoxData[
    \(V = {1, 2, 3, 4}\)], "Input"],

Cell["\<\
Alternatively we can use Table to make a vector (a list of \
elements).\
\>", "Text"],

Cell["V = Table[i,{i,4}]", "Input",
  AspectRatioFixed->True],

Cell["Here we make a rank-3 tensor ( a list of lists of lists).", "Text"],

Cell["T = Table[Random[],{4},{3},{3}]", "Input",
  AspectRatioFixed->True],

Cell["\<\
There are many useful commands for getting information about \
matrices,  such as the dimensions and rank.\
\>", "Text"],

Cell[BoxData[
    \(Dimensions[\ T]\)], "Input"],

Cell[BoxData[
    \(TensorRank[M]\)], "Input"],

Cell[TextData[{
  "Another way to generate a matrix, sometimes good for a symbolic matrix, is \
with ",
  StyleBox["Array", "InlineInput"],
  ". "
}], "Text"],

Cell[BoxData[
    \(Array[Subscript[m, SequenceForm[##]]&, {3, 3}] // MatrixForm\)], "Input"],

Cell[BoxData[
    \(Array[Subscript[m, SequenceForm[##]]&, {3, 5, 3}] // MatrixForm\)], 
  "Input"],

Cell["We can also generate diagonal and identity matrices.", "Text"],

Cell[BoxData[
    \(IdentityMatrix[5] // MatrixForm\)], "Input"],

Cell[TextData[{
  StyleBox["DiagonalMatrix", "InlineInput"],
  " takes a vector of the diagonal terms,  (here they are symbolic)."
}], "Text"],

Cell[BoxData[
    \(DiagonalMatrix[{a, b, c, d}] // MatrixForm\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Accessing Elements", "Subsection"],

Cell[TextData[{
  "It is very important to be able to extract parts of a matrix.  This can be \
done with the standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions ",
  StyleBox["Part", "InlineInput"],
  ", ",
  StyleBox["Take", "InlineInput"],
  ", and ",
  StyleBox["Drop", "InlineInput"],
  ".  "
}], "Text"],

Cell["\<\
First we generate, and then print, a matrix for demonstration.\
\>",
   "Text"],

Cell[BoxData[
    \(\(mat = Array[Subscript[m, SequenceForm[##]]&, {5, 5}]; \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell[CellGroupData[{

Cell["Part", "Subsubsection"],

Cell[TextData[{
  "If we want to extract an element we use ",
  StyleBox["Part", "InlineInput"],
  ", entered here with a shortcut notation,"
}], "Text"],

Cell[BoxData[
    \(mat[\([1, 2]\)]\)], "Input"],

Cell[TextData[{
  "alternatively we can type in the full name  ",
  StyleBox["Part", "InlineInput"],
  StyleBox[",", "Rule"]
}], "Text"],

Cell[BoxData[
    \(Part[mat, \ 1, 2]\)], "Input"],

Cell["These two ways are completely identical.", "Text"],

Cell["\<\
This is a matrix so when we give Part two integer indices we \
extract an element.   If we gave one index we would get a row.\
\>", "Text"],

Cell[BoxData[
    \(mat[\([3]\)]\)], "Input"],

Cell[TextData[{
  "We can also use Part to pick out particular rows,  for example the ",
  Cell[BoxData[
      \(TraditionalForm\`2\^nd\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`3\^rd\)]],
  " rows."
}], "Text"],

Cell[BoxData[
    \(mat[\([\ {\ 2, 3}]\)]\)], "Input"],

Cell[TextData[{
  "This is really very powerful,  to get a particular column  we use a list \
to select all rows and an index for the column.  Here we get the ",
  Cell[BoxData[
      \(TraditionalForm\`3\^rd\)]],
  "column."
}], "Text"],

Cell[BoxData[
    \(mat[\([\ Range[1, 5], \ 3]\)]\)], "Input"],

Cell["\<\
This works because we are taking rows 1 through 5,  ie all \
rows.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Extracting a Sub-matrix", "Subsubsection"],

Cell[TextData[{
  "To extract a sub-matrix  we can also use ",
  StyleBox["Part", "InlineInput"],
  "."
}], "Text"],

Cell[TextData[{
  "The sub-matrix from ",
  Cell[BoxData[
      \(TraditionalForm\`m\_21\ to\ m\_52\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Part[\ mat, \ Range[2, 5], Range[1, 2]] // MatrixForm\)], "Input"],

Cell["\<\
We can use All to describe all the rows.  Negative indices count \
from the end.   \
\>", "Text"],

Cell["\<\
This returns the matrix with the first and last columns \
dropped.\
\>", "Text"],

Cell[BoxData[
    \(Part[\ mat, \ Range[1, 5], Range[\ 2, 4]] // MatrixForm\)], "Input"],

Cell["We can also give a step size.", "Text"],

Cell[BoxData[
    \(Part[mat, Range[1, 5, 2]] // MatrixForm\)], "Input"],

Cell["Take the first to the last column in steps of 2.", "Text"],

Cell[BoxData[
    \(Part[mat, Range[1, 5], Range[1, 5, 2]] // MatrixForm\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Tensors", "Subsubsection"],

Cell["\<\
All of this works quite properly with tensors,  not just with \
matrices.\
\>", "Text"],

Cell[BoxData[
    \(\(mat = Array[Subscript[m, SequenceForm[##]]&, {2, 4, 2}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell[TextData[{
  "This returns the vector found at position ",
  Cell[BoxData[
      \(TraditionalForm\`m\_32\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Part[mat, \ 2, 2]\)], "Input"],

Cell[TextData[{
  "The sub-tensor from ",
  Cell[BoxData[
      \(TraditionalForm\`m\_221\)]],
  "to ",
  Cell[BoxData[
      \(TraditionalForm\`m\_223\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Part[mat, {2}, {2, 3}, {1, 2}] // MatrixForm\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Operations", "Subsection"],

Cell[CellGroupData[{

Cell["Basic Arithmetic", "Subsubsection"],

Cell[TextData[{
  "The standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " operations such as ",
  StyleBox["Plus", "InlineInput"],
  " and ",
  StyleBox["Times", "InlineInput"],
  " are scalar operations rather than  the matrix operations."
}], "Text"],

Cell[BoxData[
    \(\(mat = Array[Subscript[m, SequenceForm[##]]&, {2, 2}]; \)\)], "Input"],

Cell[BoxData[
    \(\(mat1 = Array[Subscript[n, SequenceForm[##]]&, {2, 2}]; \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell["If we multiply by a scalar this is applied to all elements.", "Text"],

Cell[BoxData[
    \(10\ mat // MatrixForm\)], "Input"],

Cell["\<\
If we multiply two matrices,  we get element by element \
multiplication.\
\>", "Text"],

Cell[BoxData[
    \(mat\ mat1 // MatrixForm\)], "Input"],

Cell[TextData[{
  "To get matrix multiplication we use the ",
  StyleBox["Dot", "InlineInput"],
  " operation,  typically entered with a '",
  StyleBox[".", "InlineInput"],
  "' ."
}], "Text"],

Cell[BoxData[
    \(mat\  . \ mat1 // MatrixForm\)], "Input"],

Cell["\<\
This of course works for general tensors.   For matrix \
multiplication of a rank-m and a rank-n tensor the result will be a \
rank-(m+n-2) tensor.    Consequently for matrix multiplication of two vectors \
the result is a scalar.\
\>", "Text"],

Cell[BoxData[
    \({a, b, c} . {x, y, z}\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix Functions", "Subsubsection"],

Cell["Starting with a random number matrix.", "Text"],

Cell["M = Table[Random[],{4},{4}]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If we want to invert this matrix,  since it was constructed randomly, we \
do not know ",
  StyleBox["a priori",
    FontSlant->"Italic"],
  " whether it is invertible or not.  One way to check is to see if it has  \
an empty null space."
}], "Text"],

Cell["NullSpace[M]", "Input",
  AspectRatioFixed->True],

Cell["This means that we should be able to find its inverse.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["inv = Inverse[M]", "Input",
  AspectRatioFixed->True],

Cell["We can check on the inverse by taking the matrix product.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["M.inv", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["Chop", "InlineInput"],
  " command is useful to get rid of things that are near, but not quite \
zero:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Chop[%] // MatrixForm", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Here we have a random vector ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["b = Table[Random[],{4}]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Suppose you want to solve the system ",
  Cell[BoxData[
      \(TraditionalForm\`M\ x \[Equal] \ b\)]],
  " for the vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " given the vector ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ".  One way is to use the inverse:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["x1 = inv.b", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Of course page 1 of any numerics book tells you ",
  StyleBox["not",
    FontSlant->"Italic"],
  " do this."
}], "Text"],

Cell[TextData[{
  "the correct way, both in terms of efficiency for large matrices and in \
terms of numerical stability,  is to solve the system by elimination.  This \
is done in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using ",
  StyleBox["LinearSolve", "InlineInput"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["LinearSolve[M,b]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If you want to find the solution for many different vectors ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", you can use the commands ",
  StyleBox["LUDecomposition", "InlineInput"],
  " and ",
  StyleBox["LUBackSubstitution", "InlineInput"],
  " as an alternative to finding the inverse:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
dec = LUDecomposition[M];
LUBackSubstitution[dec,b]\
\>", "Input",
  AspectRatioFixed->True],

Cell["The eigenvectors and eigenvalues are easily found:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Eigenvalues[M]", "Input",
  AspectRatioFixed->True],

Cell["Eigenvectors[M]", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Numeric Functions", "Subsubsection"],

Cell[TextData[{
  "A basic property of many ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions is that they are ",
  StyleBox["Listable", "InlineInput"],
  ",  this means they will thread over the elements of a matrix or tensor. "
}], "Text"],

Cell[BoxData[
    \(\(mat = Array[Subscript[m, SequenceForm[##]]&, {4, 4}]; \)\)], "Input"],

Cell[TextData[{
  "The ",
  StyleBox["Sin", "InlineInput"],
  " function is ",
  StyleBox["Listable", "InlineInput"],
  ",  this means that it will thread down over every list (row and column) in \
a matrix."
}], "Text"],

Cell[BoxData[
    \(Sin[mat] // MatrixForm\)], "Input"],

Cell[TextData[{
  "You can make your own functions ",
  StyleBox["Listable", "InlineInput"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(SetAttributes[\ fun, \ Listable]; \)\)], "Input"],

Cell[BoxData[
    \(fun[mat] // MatrixForm\)], "Input"],

Cell[TextData[{
  "Here you still need to say how ",
  StyleBox["fun", "InlineInput"],
  " should behave for each element."
}], "Text"],

Cell[TextData[{
  "It is ",
  StyleBox["very",
    FontSlant->"Italic"],
  " advantageous to use listability to operate on the elements of a matrix.   \
For numerical matrices these computations can be done in a very efficient \
manner,   one can consider this as a form of parallel or vectorised \
computation."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting Elements", "Subsection"],

Cell[TextData[{
  "We can use ",
  StyleBox["Part", "InlineInput"],
  " on the left-hand side of a set to change elements."
}], "Text"],

Cell[BoxData[
    \(\(mat = Array[Subscript[m, SequenceForm[##]]&, {5, 5}]; \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell[TextData[{
  "Set the element 3,3 to be ",
  StyleBox["x", "InlineInput"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(mat[\([3, 3]\)] = x; \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell["Here we set a row to have a particular value...", "Text"],

Cell[BoxData[
    \(\(mat[\([2]\)] = {1, 2, 3, 4, 5}; \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"],

Cell["Here we set a column to have a particular value...", "Text"],

Cell[BoxData[
    \(\(mat[\([Range[1, 5], 2]\)] = {\(-1\), \(-2\), \(-3\), \(-4\), \(-5\)}; 
    \)\)], "Input"],

Cell[BoxData[
    \(mat // MatrixForm\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Vectors", "Subsection"],

Cell[TextData[{
  "A final comment about vectors in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Matrices in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are represented by a list of lists of elements.  Vectors are represented \
by a list of elements.   "
}], "Text"],

Cell["Sometimes a basic question comes up.", "Text"],

Cell[TextData[{
  "          'How do I represent a row and a column vector in ",
  StyleBox["Mathematica?'  ",
    FontSlant->"Italic"]
}], "Text"],

Cell["Answer:   'there are no such things'.", "Text"],

Cell["You can have a matrix with one row or one column...", "Text"],

Cell[BoxData[{
    \(\(row = {{x, y, z}}; \)\), 
    \(\n\), 
    \(\(col = {{x}, {y}, {z}}; \)\)}], "Input"],

Cell[BoxData[
    \(row // MatrixForm\)], "Input"],

Cell[BoxData[
    \(col // MatrixForm\)], "Input"],

Cell["\<\
but these are matrices...  if I multiply the row by the column I do \
not get a scalar,  I get a matrix.\
\>", "Text"],

Cell[BoxData[
    \(row . col\)], "Input"],

Cell[TextData[{
  "Really if I take the vector product of two vectors I get a scalar.  Of \
course you need to distinguish between them.   As ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does,  it is not constructive to do otherwise."
}], "Text"],

Cell["\<\
If you are unconvinced ponder this.   The points in an \
n-dimensional space can be represented with a length-n vector.   Is this a \
row or a column vector?   If I have a plane in this space,  is the normal to \
this a row or a column vector?   The questions are meaningless.   A length-n \
vector is just a collection (an n-tuple) of elements.\
\>", "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Differential equations", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The command ",
  StyleBox["NDSolve", "InlineInput"],
  " will solve (systems of) differential equations.  For example, Duffings \
equations has no analytic solutions, but can easily be solved with ",
  StyleBox["NDSolve", "InlineInput"],
  ":"
}], "Text",
  Evaluatable->False],

Cell["\<\
sol = NDSolve[{
\tx''[t] + .15 x'[t] + x[t] - x[t]^3 == .3 Cos[t],
\tx'[0] == x[0] == 0},
\tx,{t,0,10}]\
\>", "Input"],

Cell[TextData[{
  "The ",
  StyleBox["InterpolatingFunction", "InlineInput"],
  " object returned can be treated like any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that evaluates to a number.   Here we make a phase space plot, \
easy in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " since we just differentiate the result of ",
  StyleBox["NDSolve", "InlineInput"],
  ".   Good example of symbolic/numeric powers."
}], "Text",
  Evaluatable->False],

Cell["ParametricPlot[Evaluate[{x[t],x'[t]} /. sol],{t,0,10}];", "Input"],

Cell[TextData[{
  "The methods used in ",
  StyleBox["NDSolve", "InlineInput"],
  " include a solver for \"stiff\" systems of equations.  A system of \
equations is called stiff when it has components that vary on extremely \
different time scales.  For example,"
}], "Text",
  Evaluatable->False],

Cell["\<\
sol = NDSolve[{
\tx'[t] == -1000 x[t] + Cos[t],
\ty'[t] == -y[t] + t^2, 
\tx[0]==1, y[0] == 0},
\t{x,y},{t,0,2}];\
\>", "Input"],

Cell["\<\
Plot[Evaluate[{x[t],y[t]} /. sol[[1]]],{t,0,2},
\tPlotRange->All];\
\>", "Input"],

Cell["The first component of the system varies much more rapidly.", "Text",
  Evaluatable->False],

Cell["Plot[Evaluate[x[t] /. sol[[1]]],{t,0,.005}];", "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Handling", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " handles vectors as lists and matrices as lists of lists.  We can work \
with data using lists.  There are many commands to work with data.  Brief \
description here."
}], "Text"],

Cell[CellGroupData[{

Cell["Importing Data", "Subsection"],

Cell[TextData[{
  StyleBox["ReadList", "InlineInput"],
  " is probably the main function for importing data."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Analysis", "Subsection"],

Cell[TextData[{
  "Linear fitting can be done with ",
  StyleBox["Fit.", "InlineInput"]
}], "Text"],

Cell[BoxData[
    \(\(data = 
      Table[{x, Exp[\(-x\)]\ Sin[x] + \((Random[] - 0.5)\)/20. }, {x, 0.1, 
          10, 0.05}]; \)\)], "Input"],

Cell[BoxData[
    \(\(p1 = ListPlot[data]; \)\)], "Input"],

Cell[BoxData[
    \(fun = Fit[data, {1, x, x^2, x^3}, x]\)], "Input"],

Cell[BoxData[
    \(\(p2 = Plot[fun, {x, 0, 10}, PlotRange -> All]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[p2, p1]; \)\)], "Input"],

Cell["\<\
Linear fit is not very satisfactory.  Lets try a non-linear fit,  \
from the appropriate package.\
\>", "Text"],

Cell[BoxData[
    \(<< Statistics`NonlinearFit`\)], "Input"],

Cell[BoxData[
    \(\(Plot[\ Exp[\(-x\)]\  - \ Exp[\(-2\)\ x], {x, 0, 10}]; \)\)], "Input"],

Cell[BoxData[
    \(b\)], "Input"],

Cell[BoxData[
    \(NonlinearFit[data, \ \ Exp[\(-b1\)\ x] - \ c1\ Exp[\(-d1\)\ x], 
      x, {{b1, 1}, {c1, 1}, {d1, 2}}]\)], "Input"],

Cell[BoxData[
    \(\(p2 = Plot[%, {x, 0, 10}]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[p1, p2]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Statistics", "Subsection"],

Cell["\<\
There are many standard packages that carry out a wide variety of \
statistical computations.  In addition there are application packages to \
provide functions in TimeSeries or Wavelets.   Really this is outside of the \
scope of this tutorial.   Look in the on-line documention.\
\>", "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrature and Summation", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Quadrature", "Subsection"],

Cell["\<\
The command NIntegrate can approximate numerical integrals \
accurately even over infinite intervals.\
\>", "Text",
  Evaluatable->False],

Cell["NIntegrate[Exp[-x^2/2]/Sqrt[2 Pi],{x,-Infinity,Infinity}]", "Input"],

Cell["NIntegrate assumes its integrand is smooth.", "Text",
  Evaluatable->False],

Cell["\<\
Clear[f];
f[x_] := Which[
\tx < 0,\t0,
\tx < 1, \tx^2,
\tx < 2,\t2x,
\tx < 3,\t4,
\tx >= 3,\t0]\
\>", "Input"],

Cell["NIntegrate[f[x],{x,-3,6}]", "Input"],

Cell["\<\
This does quite poorly bacause the assumption of smoothness is \
violated.  You can tell NIntegrate to treat different regions separately by \
including the points where there might be discontinuities.\
\>", "Text",
  Evaluatable->False],

Cell["NIntegrate[f[x],{x,-3,0,1,2,3,6}]", "Input"],

Cell["\<\
NIntegrate can handle singularities at the endpoints of its region \
(or in the middle if the points are specified as above).  For example,\
\>", 
  "Text",
  Evaluatable->False],

Cell["NIntegrate[1/Sqrt[Abs[x]],{x,-1,0,1}]", "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Sums and Products", "Subsection"],

Cell[TextData[{
  "There are many ways to compute sums in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  I will use a simple example to demonstrate the difference between \
these."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Timing[N[Sum[Exp[-x]Sin[x],{x,1,10000}]]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["N[Sum[]]", "InlineInput"],
  " works first by summing the sum (symbolically or numerically depending on \
the arguments) and then applying N to the result."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Timing[Sum[N[Exp[-x]Sin[x]],{x,1,10000}]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Sum[N[],]", "InlineInput"],
  " adds up the numerical values of the summands."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Timing[NSum[Exp[-x]Sin[x],{x,1,10000}]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["NSum", "InlineInput"],
  " works by adding up the first few terms, then using mathematical \
approximations to estimate the size of the tail.  Even though it was much \
faster, its result is just as good in this case:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["%[[2]]-%%[[2]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Because ",
  StyleBox["NSum", "InlineInput"],
  " approximates the tail, it can do infinite sums as well:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["NSum[1/(n(n+1)(n+2)),{n,1,Infinity}]", "Input",
  AspectRatioFixed->True],

Cell["\<\
In cases where the Sum cannot be evaluated, this is equivalent to \
N[Sum[]]\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["N[Sum[1/(n(n+1)(n+2)),{n,1,Infinity}]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "However, if you know what you want is a numerical approximation to the \
sum, ",
  StyleBox["NSum", "InlineInput"],
  " has the advantage that it takes options that control the way the sum is \
approximated."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["NSum", "InlineInput"],
  " uses two different methods to approximate the tail.  One is \
Euler-MacLaurin summation, where the tail is approximated by integration.  \
This was the method used in the above sum.  The other method uses Wynn's \
epsilon algorithm (as in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command ",
  StyleBox["SequenceLimit", "InlineInput"],
  ") to approximate the limit of the sequence of partial sums.  This method \
is used in sums like:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["NSum[1/2^n,{n,1,Infinity}]-1", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses heuristics to decide which method is best to use.  You can control \
the method using the option ",
  StyleBox["Method", "InlineInput"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["NSum[1/2^n,{n,1,Infinity},Method->Integrate]-1", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "In this case, ",
  StyleBox["Integrate", "InlineInput"],
  " was not a great choice."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["NProduct", "InlineInput"],
  " works similarily to ",
  StyleBox["NSum", "InlineInput"],
  ", but it computes the exponential of the sum of the logarithms of the \
terms instead."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["NProduct[1+2^-n,{n,1,Infinity}]", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Summary", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "These are some of the key elements of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " numerics."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " works with numbers and symbols"
}], "Indent"],

Cell["Hybrid (mix numeric and symbolic) methods", "Indent"],

Cell["Numbers can be exact or inexact", "Indent"],

Cell["Inexact numbers can be machine or arbitrary precision", "Indent"],

Cell["\<\
Many functions for standard numerical computations (root finding,  \
minimisation,  quadrature, and ODE solving)\
\>", "Indent"],

Cell["Numeric (and symbolic) linear algebra", "Indent"],

Cell["Data handling functions", "Indent"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1024}, {0, 768}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
WindowSize->{532, 532},
WindowMargins->{{143, Automatic}, {Automatic, 35}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell["\<\
Below is a PICT header for use with all WWMC notebooks. Copy and \
paste this cell at the top of your notebook. \
\>", "Text"],
  
  Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:800006B000`400?l00000o`00003oo`00003o
000008X00000003o00000?l00000RP0000000?l00000o`00002:00000000o`00003o000008X00000
000:0000000>05eMG@2l_;`0jn_[0>c/k031`L407QhN0000000L71`0QXJ60<[:bP3[jn/0gmoO0:^[
Z`1ADE420000000;06UYJ@3GemL0e=CD055AD@0000009BDU0<S8b03De=@0bl_;01DE5@1RHV800P3F
e]H01P20P8000000000000000000JFUY0=KFeP80dM7A00h0dm?C0=KFeP16ATH0ATI60=CDe03EeMD0
TY:B00X:2P2b/[80e=CD0=WIf@1^KVh0HV9R0=KFeP80dM7A01d0dm?C0=SHf01PH600;2`/0=7Ad@3F
e]H0P820000000061PH0[Jf]0=GEe@3De=@0DE5A0000000=3@d0Ng]k0<c<c03]kNd0iNGU09bLW00@
4100`/;20=;BdP3AdM40d];B0=?Cd`3<[[@0/0HU0:l07P050:l080030:l07`2_01h0[`0O0080[`0P
0P2_01l0102d1B<0/P<S0;838`2b0b<20;838P<0/P<S00<0/P<R0;438@2b0b800P2b0b<30;838P@0
/P<S00<0/@<Q0;838P2b0b<00`2b0b<00`2a0b40/P<R0;838`0<0;838`030;838P2b0b<0/P<S0080
/P<S0P2b0b840;838`80/P<R0`2b0b<00`2b0b80/@<Q0;838P040;838`030;D3902F1Al03`l?0?l0
3`l?00<07QhN000000000000fP00000000T0000000<0Rh^;0?ooo`3oool00`3oool00`0T92@07alO
0=WIf@060?ooo`0307]kN`000000Ph>30080oooo00<0Hf=S0000002n_[h00`3oool01@0K6a/0O7al
0?ooo`3oool0WinO00<0000000<0QHF50?ooo`3oool00`3oool01P1IFET0F5QH0?ooo`3oool0/K6a
075aL@80oooo00<0h^;R01XJ6P1mOGd01@3oool01`1iNGT0>3Ph0?ooo`3oool0X:2P00000024Q8@0
0`3oool00`1SHf<01@D50;fm_@040?ooo`030=cLg00G5aL0m?Cd00@0oooo00<0nMOM0=L7;P3E02@0
1@3F02L01@3E0240f0/`0=L4:`3F02H0eP0W0080e`@Z00@0e`D/0=H1:03F02L0eP0W0P3G12X30=H0
9`090=D08@3H2c00e`@[0=H09P3F02L0e`L]0=D08P3G0bX0eP<Y0080eP0W00X0e@0S0=P9;`3F0BL0
eP0U0=H09`3F02P0e@0R0=L9;P3F0BP0eP0U303F02L0203G1R`0eP4X0=H09`3F02L0eP0V0=L6;03F
0RP0eP0V0P3F02L00`3F02H0e`L]0=H09`030=H09`030=H09@3H3C80eP0U00D0eP0W00<0]`0Q0000
00000000oP0000000`0;2`/000000000003J00000000200000002@0h>3P0oOgm0?ooo`3oool0alO7
09BDU037alL0=3@d09bLW0020?ooo`030>KViP2FUYH0^[Zj0080oooo00<0oOgm024Q8@1gMgL00P3o
ool00`1EEED0H61P0?ooo`020?ooo`030?Shn00J6QX0N7Qh0080oooo00D0Z:RX01`L700L71`00000
07moO`020?ooo`050<30`01KFe/0GemO01XJ6P1NGUh00P3oool01`3Jf]X0k>c/0?ooo`3_knl0@d=3
00000021PH400P3oool01@30`<00Fe]K065QH@0V9RH0@T920080oooo00<0T92@034a<@3kno/00`3o
ool04@1FEUH0GemO0?ooo`3oool0o_kn0;6a/@2HV9P0_Kfm01hN7P3/k>`0oooo0?[jnP1iNGT0FEUI
071?E@3A0R40eP0V00@0eP0W00`0e@0O0>=CK@3d^L@0fado0=D08`3D01d0iF1g0>ELM@3/QYP0fQTl
0=D08`3D01d20>IQN@0I0=@07@3F02L0e@0O0>=CK@3d^L@0fado0=D08`3D01d0jG>80>f>X03aZKL0
fADi0=D08`3E0200gRi>0?Fob@3YN8d0eP8T0=H09P3E0200gBm?0?G0bP3^UJH0ePDW0=H09@090=H0
9`0F0=H09@3G0bX0kYFU0=XH>`3E02<0eP0W0=D08@3M;dl0jWjB0=D08P3F02H0eP0W0=@07@3TFG80
iEae0=@07P3F02L0e00O0>AJL`3c]l80i5Yc0=@07`@0eP0W00<0/@0P000000000000oP0000000`0?
3`l000000000003J00000000200000003`2>SXh0oooo0?ooo`34a<@02`/;0000000<30`08R8R0>CT
i03oool0o?cl04a<C00000000P820;Zj^P020?ooo`0<06=SH`1_Kfl0oooo0?Win@2@T900i>CT0?oo
o`3bl_80oooo0?Shn00J6QX0N7Qh0P3oool01@3inOT0k^k^0>7Qh@000000Ng]k0080oooo00D0k^k^
0=;BdP35aLD00000061PH0050?ooo`040=?Cd`0d=3@000000820P080oooo00D0k^k^0=;BdP34a<@0
000004E5A@020?ooo`080:6QX@32`/80oooo0>c/k03kno/0oooo06EUI@2h^;P20?ooo`0<09:BTP00
0000000001XJ6P0F5QH0kno_0?ooo`3no_h0f][J0=;BdP24AE40`00E103F02L03@3F02@0e`d`0?G4
c@3O=eH0e@4T0=H09`3D01/0ifb20?6Y]P3d_LL0fQPk0=D08`3D01`00P3YL8H06@3D01`0eP0T0=L=
<03ea<d0gcMF0=D1903F02L0e00L0>AJL`3ieM`0lkG10=L4:@3F02D0e00L0>b8VP3_UjL0mKo90=TC
=`3E02<0e00L0>fAXP3XLHL0l:Bb0>51G`3D01l02@3F02L05P3F02D0e`<Z0?:]^@3J73l0e@0S0=H0
9`3E0240iF1h0?WIg`3J6ch0e@0R0=H09P3F12H0kiJV0?Bja@3F0bH0eP0U0=@07`3ZP9@0l[6n0>^1
U@3D01l40=H09`030;408000000000000?h0000000<03`l?000000000000fP00000000P0000000@0
Vi^K0?ooo`3oool0YJFU0`0000001@0@4100l?3`0?ooo`3jn_X0<C4a0080000000<0YZJV0?ooo`3o
ool00P1^KVh02P3oool0n_[j0?;blP3oool0alO70;fm_@3oool0n?Sh01XJ6P1hN7P20?ooo`050?Ge
m@3Vi^H0emOG0000001lO7`0103oool00`3dm?@00@4105mOG`020?ooo`070>3Ph02[Zj/0moOg0?oo
o`3Zj^X04a<C07UiN@040?ooo`030?Cdm0030`<0@d=30080oooo00P0kno_0?ooo`3QhN40Xj>S0?gm
o@3oool0JFUY0<C4a080oooo00H0JFUY0000000000000000010@403`l?040?ooo`0309mDH@2m01D0
eP0W00<0eP0W00d0e@0S0=TC=`3gb]80f0db0=D08P3F02L0e00K0>IWO`3e`l`0m/SA0=TE>@3E02<0
e00L0080j6j301T0e00L0=D08`3I4cL0ml[B0=P=<P3E0280eP0W0=D08P3L8T@0nMOM0>YmT@3D01`0
eP0V0=@07P3^UJH0jWfA0>MXOP3G22d0e@0U0=@07P3_VZX0he=]0>jFYP3SCf/0e00N00T0eP0W01H0
eP0U0=L1:03aY[@0fQ/n0=D08`3F02@0f0/`0?:/^@3b[k/0i5E_0=@07P3E0240gS1@0?>g`@3d^lD0
fQLl0=D08`3D01/0iEYd0?_Xk03UFg@0e00K103F02L00`2a020000000000003n0000000300l?3`00
000000000=X0000000080000000905IFEP3oool0oooo0?KfmP1eMGD0ATI608Z:RP0g=cL0^KVi0080
oooo00@0bl_;05YJFP2:RXX0n?Sh0P3oool00`0i>CT0M7Ad0?ooo`020?ooo`070?;blP0l?3`0a/K6
0?ooo`3hn?P06QXJ07QhN0020?ooo`050;Ng]`14A4@0ADE500X:2P1mOGd00P3oool01@2d];@0>c/k
03/k>`000000HV9R0080oooo00<0/[:b01hN7P3Shn<00P3oool01@0e=CD0M7Ad0?ooo`3oool0];Bd
0080>c/k00<00P8204I6AP3oool00`3oool01P1OGel0SHf=0?ooo`3oool0FEUI0861P@80oooo00d0
g]kN05YJFP1;Bd/0TY:B01lO7`3/k>`0oooo0?[jnP1OGel0>SXj04/]<`3=01/0eP0V00<0eP0W00d0
eP0V0=D18@3ZNi00lk>n0=TF>@3E02<0e00L0>M]P`3WJX40kiVX0=XL?`3E02<0e00L0080j6n401T0
e00L0=H09P3E0B40jW^@0?>c_P3I5ST0e@0S0=H0903G12X0n=3G0>AJM03D01`0eP0W0=@07@3RBfL0
mlWA0>YhS@3F0RD0eP0V0=@07P3QAV<0mlWB0?:_^`3H3S00e@0T00T0eP0W01H0e@0S0=XH?03fbM80
fQPk0=D08`3F02D0eP@W0>j@X@3c]l80gRi>0=D08@3E02<0fQTk0?:^^`3aYK<0e``^0=D0903D01`0
i5Uc0?O@f03TFG<0e00L103F02L00`2a020000000000003n0000000300l?3`00000000000=X00000
00080000000300H61P2k^k/0oooo00@0oooo00<08b<S04A4A03gmoL01P3oool00`2d];@00@4107em
O@030?ooo`070861P@000000e=CD0?ooo`3hn?P06QXJ07QhN0020?ooo`050?KfmP3Vi^H0j>SX04U9
B@1bLW800P3oool01@3^k^h0d];B0=CDe00_;bl0FUYJ0080oooo00L0mOGe0>KViP3oool0oooo0>7Q
h@0=3@d0NWYj0080oooo00D0kno_0=;BdP3De=@0<S8b03hn?P030?ooo`030;bl_0000000VIVI0080
oooo00<0G5aL01HF5P3Vi^H0103oool02P3Kfm/05aLG0>c/k03oool0o_kn0=_Kf`3AdM40f;Fl0=L5
;03E02@40=H09`040=H09@3F02L0gS9A0=P:<080eP0U00H0fADh0=XF>@3K7T00e`D[0=H09P3F02D2
0=XE>@070=H09@3F02L0eP0U0=H09`3N<U80f0X`0=H09@020=H09`030=`Q@`3H3C80eP0U0080eP0W
00@0eP0T0=h`C`3J63`0eP0T0P3F02L0103E02@0gRm>0=XH?03E02<:0=H09`0:0=H09@3H3340gS1@
0=L3:P3F02H0eP0W0=D08`3I53P0gBU:0=D08`80eP0W00X0e@0T0=`RA03J6ch0e@0T0=H09`3F02H0
e`@[0=dZB`3G12/0eP0V103F02L00`2a020000000000003n0000000300l?3`00000000000=X00000
00090000000;01<C4`2QXJ40lo?c0?knoP3oool0l?3`02PX:0000000@d=30<G5a@3kno/00P3oool0
4@3/k>`0UiNG00T92@000000NGUi0?gmo@3lo?`0`L7100d=3@030`<0f][J0?gmo@3emOD0410@07al
O03oool0oOgm00<0oooo00@0BTY:06UYJ@3moOd0oOgm0`3oool0100b<S80Cdm?0?gmo@3lo?`20?oo
o`070?knoP3Cdm<0BTY:0000001jNWX0oOgm0?knoP030?ooo`0803De=@0d=3@0oooo0?ooo`3_knl0
8R8R0000002FUYH20?ooo`0505]KF`0000009BDU0;Fe]@3emOD00P3oool00`3<c<`05QHF0>[ZjP02
0?gmo@80oooo00L0n=?J0=P1:03D01l0eP0Q0=L08`3G0280e@0R0080e`0R00`0e00I0=D0803G0280
e@0R0=D07P3F01h0e`0J0=P07`3G0280e@0R0=D07P3G01h20=D08P0?0=P08@3G0240eP0J0=D0803E
0280e`0R0=L08`3E01/0e@0O0=P08P3H0240e@0R0=D08@3D01X0e@0N0080e`0R00T0e@0R0=D08@3F
01P0e`0L0=D08P3H0240f00P0=L08P3E02800P3F02820=D08P80f00P00T0f00Q0=D0803D01T0e`0Q
0=H08P3E0280f00R0=H07`3F01X00P3E0280103H0240e`0S0=H06P3G01/30=D08P060=H0803D01X0
e@0P0=P08@3H0200f00Q0P3E02800`2b01`000000000003n0000000300l?3`00000000000=X00000
000;0000000<04E5A@2c/k<0_[jn071`L0061PH08R8R05IFEP1]KFd0K6a/05UIF@1=CDd09BDU0P00
00004`0n?Sh0SHf=0;jn_P2DU9@0>3Ph000000010@40>c/k09ZJVP2OWil0H61P01`L701`L700XZ:R
0:2PX02FUYH0N7Qh07IfMP1lO7`00P2PX:006`2NWYh0HF5Q09FEU@1_Kfl0MWIf0::RXP2CTi<0L71`
0451@@0_;bl03@d=000000051@D0MWIf0::RXP2?Shl0?clo04a<C02MWId0LG5a05MGE`0o?cl0@410
02/[:`0o?cl0HF5Q08R8R002061PH00:07YjNP1PH600F5QH06MWI`23Ph<0NWYj04];B`0W9bL02PX:
09FEU@@0X:2P02<0SHR906U<DP1eEEX0K4aA03853@1B8RX0M5eR04XN9P0e1@h0LU1F07EEFP1_CeD0
MUEJ07IEF`1WAT`0>1HL02X:401G>d00MeIK07=CF01PADT0Le=H07IIGP1F:340=@D<04dP:01eFEh0
M5QM04DL900e1@h0KdiD07MGG@1F=cd0DRP_07IHG@0307EDFP0/06I9CP1OA4P0MUEK079>E00f31<0
BB0W07ELH@1C9Bd0<`/B06]9C`1fEE/0L51F07EDF@1fEE/0Kd]B02l<4P0Z2@h0DBD]07IIGP1fEEX0
F3m306i?E01gEU/0HDA903D53P1;7RH0MEUN07IIGP1F:340=@D=02h83`1D5B00PeUQ08iVK@1_CeD0
KTmD07IEFP1dEe`0?A`R02X93@0o7B<0MEQM07IEFP1G?T;o00000040000000<03`l?000000000000
fP00000000/0000000H0N7Qh0?gmo@3moOd0]kNg0000002<S8`20?ooo`060;>c/`00000000000000
000a<C40_;bl0`3oool03P3moOd0g]kN075aL@00000010@40>g]k@3moOd0lo?c018B4P38b<P0oOgm
0?ooo`22PX80LW9b0P3oool01@3no_h0oooo0?clo01?Cdl0h>3P00<0oooo00@0o_kn0>_[j`2VYZH0
6QXJ0P0000002P18B4P0o_kn0?gmo@3YjNT000000492@P3lo?`0oooo0>o_k`0820P2000000030;no
_`3oool0oooo0080C4a<103oool01P3moOd0fMWI07EeM@00000030`<0>k^kP80oOgm0P3oool08P39
bl/0KWEc0:ji]`2V];401PD505ADE02__;X0HV9R0000002LZ:H0[kZh0828Q`29TY00[kZh0:>]Z`17
BDP0<cDd08J>S@2_^[P0Yk6`05QNG@2W/K00[kZh06E/JP000000:b/[0:jj^02_^kT0>SXj0000002?
VYP0[kZh06ieL`0m@3l20:nj^080/;^i0180VZBR05eSHP2_^[P0[;Ne01LH600m@3l0[kZh07MnO@00
0000Qi2>0:nj^02=UY@0OXF40:nj^02Z]K<0AdY9030b<P1iP7h20:nj^00@04M<B`2FX9h0[kZh08fH
UP0000009bLW0:fi]`2_^[P0I6]Z0000000j>SX0WJJU0:nj^02`^kT0Z[Fc08F=R`80[kZh00<0HFMV
02`^;P1NHf800P2_^[P00`1UK6/000000000003n0000000300l?3`00000000000=X00000000:0000
000700D51@3Fe]H0oooo0?ooo`3/k>`051@D0;Ng]`020?ooo`050?KfmP0X:2P0000000h>3P3De=@0
0`3oool02P3bl_80oooo0?ooo`3oool0FUYJ00@4103`l?00oooo0>SXj02:RXX20?ooo`030<c<c009
2@T0NWYj00<0oooo00L0o_kn0?_kn`1GEeL0i>CT0?ooo`3no_h0lO7a00<0oooo00@0b<S800H61P00
0000WIfM0`3oool00`0j>SX0N7Qh0?ooo`020?ooo`0405mOG`00000000000;Rh^080oooo0P1EEED2
0?ooo`030?Win@3dm?@0oooo0080oooo01@0KFe]00820P3`l?00oooo0?knoP3<c<`0`L7109FEU@0n
?Sh0/K6a0;:b/P0n@400K6e]0;:b/P2WZ:P07b0P08j>SP2b/[80MgMg03dm?@H0/[:b0240Xj>S02DU
9@2XZ:P0/[:b08>3P`00000051@D0:b/[02b/[80FU]K0000001bLW80/[:b09>CT`0_;bl0[jn_0;:b
/P2VYZH0QhN707emO@0j>SX0[Jf]0;:b/P1=CDd0FEUI0;:b/P2_[jl0:b/[07UiN@2b/[80S8b<034a
<@2`/;001@2b/[80302][Jd092@T08J6QP2b/[80Z:RX00P92@0A4Q80[:b/0;:b/P1oOgl04a<C0:>T
Y080/[:b00@0[Zj^0:n_[`1VIVH0U9BD1P2b/[800`19BDT000000000003n0000000300l?3`000000
00000=X00000000:0000000703dm?@3no_h0oooo0?ooo`3moOd0E5AD0=cLg0030?ooo`0308Z:RP00
0000KVi^0080oooo00@0i>CT04Y:BP0_;bl0ZJVY0P3oool01@3:b/X04a<C0>c/k03oool0oOgm0080
oooo00@0l?3`0410@0000000PH610P3oool02P2e]KD0@41003lo?`0Q8B40kNg]0?ooo`3inOT0BTY:
05UIF@3_knl20?ooo`0303hn?P071`L0i>CT00<0oooo00<0Ng]k0:6QX@3oool00P3oool01035aLD0
0@410000002h^;P20?ooo`80EEEE0P3oool00`31`L40<C4a09VIV@020?ooo`0=0<c<c00G5aL0k>c/
0?ooo`3kno/0P82006QXJ00_;bl020P80:2PX02b/[80Jf][08B4Q0020;:b/P0@06UYJ@23Ph<0/[:b
07inOP0410@0T92@0;:b/P2][Jd0LG5a0:ZZZP2b/[80Rh^;00P8202IVIT0/[:b09bLW0800`<30180
WIfM0;:b/P2CTi<0GUiN096AT@2b/[80YZJV02DU9@2VYZH0/[:b09BDU018B4P0@T9200P8202>SXh0
/[:b07YjNP1gMgL20;:b/P0F07MgM`1dM7@0/[:b09>CT`020P80OWin0;:b/P2a/K40MgMg0:6QX@2b
/[80WinO00@4101`L700/[:b0;2`/00S8b<00@4109ZJVP2b/[80U9BD03Ti>@80/[:b00D0UiNG02XZ
:P0[:b/0<30`05EEE@020;:b/P0508>3P`2>SXh0/[:b0;6a/@0[:b/0o`0000010000000300l?3`00
000000000=X00000000:0000000=0:RXZ03oool0i>CT0<C4a03oool0`l?30?KfmP3Ogml0clo?0?oo
o`3IfMT00@4109jNWP020?ooo`0A09fMW@000000000002`/;03lo?`0oooo0>k^kP0P8200jn_[0?oo
o`3no_h0oOgm0?ooo`3moOd0_Kfm01DE5@1jNWX00P3oool02P2GUiL000000000000<30`0lO7a0?oo
o`3hn?P07QhN0000002j^[X20?ooo`0?06m_K`1JFUX0oooo0?KfmP2l_;`0oooo0<o?c`3UiND0kno_
0;no_`3oool0o?cl02`/;0000000^;Rh0080oooo0P1EEED20?ooo`080;Fe]@0000007alO0?[jnP3o
ool0m?Cd03Ti>@3Xj>P40?ooo`0K08F5Q@000000Lg=c0;:b/P2JVYX0YJFU0:n_[`2XZ:P0YJFU09>C
T`2b/[80P82000000012@T80/[:b0:n_[`0g=cL0WYjN0;:b/P1^KVh0000008:2PP2b/[80[:b/01<C
4`000000Ph>300D0/[:b00<0[jn_034a<@2@T900102b/[805@0J6QX0FEUI0;:b/P2UYJD0VYZJ0:n_
[`2XZ:P0ZZZZ08n?S`2b/[80Ti>C0000000];Bd0/[:b0;6a/@16ATH0QhN70;:b/P24Q8@0000005UI
F@020;:b/P0903/k>`000000Ph>30;:b/P2SXj<0BDU90;2`/02b/[80KFe]00<0000000P04A4A0:>S
X`2b/[80Hf=S069RHP2b/[80Z:RX00l?3ol000000@0000000`0?3`l000000000003J000000002@00
00001@0F5QH0k^k^0?ooo`2ZZZX0MGEe00<0oooo00H0Shn?08Z:RP3oool0o_kn03Xj>P1kNg/20?oo
o`040=3@d00O7al02`/;08:2PP80oooo00L0g=cL01TI6@3/k>`0oooo0>o_k`0c<c<0^k^k0080oooo
00D0IfMW06i^KP3oool0oooo09bLW0020000000700l?3`3`l?00oooo0?Shn00^;Rh0:RXZ0>7Qh@02
0?ooo`0605=CD`2a/K40oooo0>?Sh`1ADE40no_k0P3oool01`35aLD0HV9R0?ooo`3oool0PH610000
002g]kL00P3oool205EEE@80oooo00l0^KVi00`<301]KFd0o_kn0?ooo`3Kfm/08B4Q0>_[j`3oool0
o?cl0:BTY02DU9@0ATI600000010@4000`2b/[800`2@T900KVi^0;:b/P020;:b/P0D0820P0000000
1@D509FEU@2b/[80Q8B40:FUY@2b/[80D51@00820P1YJFT0/[:b0;6a/@0b<S800@4106][J`2b/[80
/K6a0:FUY@2WYjL20;:b/P0804A4A01eMGD0/[:b0;6a/@1gMgL0IFEU01@D500X:2P30;:b/P0309nO
W`1RHV80/[:b0080/[:b0240Ti>C00<30`000000Q8B40;:b/P2;Rh/0W9bL0;:b/P1SHf<00`<304=3
@`2a/K40/[:b05QHF0020P80JFUY0;:b/P2^[Zh0@41009jNWP2b/[80VIVI01TI6@0000008B4Q0000
001IFET0/[:b0:6QX@28R8P0/[:b08Z:RP010@40o`0000010000000300l?3`00000000000=X00000
00090000000605eMG@3oool0oooo0820P00/;2`0o_kn0P3oool01`1HF5P0E5AD0?ooo`3oool0YZJV
01`L703bl_800P3oool00`3Vi^H0c/k>0?ooo`020?ooo`0708R8R0051@D0kno_0?ooo`3emOD0MgMg
0=GEe@020?ooo`05065QH@1_Kfl0oooo0?ooo`2LW9`00P0000001P0?3`l0l?3`0?ooo`3moOd0d=3@
0>g]k@80oooo00L0fm_K03De=@3alO40oooo0;jn_P0>3Ph0hN7Q0080oooo00L0V9RH020P803inOT0
oooo0=oOg`0<30`0/k>c0080oooo0P1EEED20?ooo`030>k^kP3@d=00oooo0080oooo00/0RXZ:00<3
0`3_knl0oooo0?_kn`29RHT0Lg=c059BDP0000004Q8B0:JVYP020;:b/P030820P00S8b<0[Jf]0080
/[:b00@0P820000000000000B4Q80`2b/[80102`/;00?Cdm07MgM`2IVIT20;:b/P0;09ZJVP1aLG40
Fe]K0;:b/P2_[jl0;bl_02@T902][Jd0/[:b05ADE01LG5`00P2b/[801@1YJFT0D51@03Hf=P061PH0
V9RH0080/[:b00<0UYJF01TI6@2SXj<00P2b/[80102CTi<01@D50000000d=3@40;:b/P0804E5A@1J
FUX0TI6A0;6a/@2b/[80XZ:R07emO@1fMWH20;:b/P0>0410@01ADE40/[:b0;:b/P2MWId0O7al0:2P
X00E5AD03Ph>0:FUY@2b/[80/K6a0;:b/P1]KFgo00000080000000<03`l?000000000000fP000000
00P0000000L020P80=?Cd`3oool0oooo05YJFP010@40jNWY0080oooo00P0;Bd]02HV9P3oool0oooo
0?knoP0N7Qh0Fe]K0?7al@D0oooo00@0/;2`010@400;2`/0no_k1@3oool00`3Cdm<04Q8B0820P002
0?ooo`050:>SX`0000000000010@403kno/01@3oool00`3Lg=`0?clo092@T0020?ooo`0309NGU`00
0000[jn_0080oooo00<0K6a/0000003Ogml00P3oool0101LG5`0/k>c0?ooo`3oool205UIF@H0oooo
00@0];Bd01LG5`0:2PX0no_k103oool01038b<P0000000000021PH420;:b/P0307]kN`000000Ogmo
0080/[:b00D0QhN700000000000020P809fMW@020;:b/P030:n_[`0J6QX0Vi^K00D0/[:b00T0Fe]K
0;:b/P2b/[80=cLg0000002SXj<0/[:b071`L01=CDd0102b/[800`2GUiL0000006YZJP020;:b/P03
092@T0000000JFUY0080/[:b00D0VYZJ00D51@0000000@4108Z:RP030;:b/P03028R8P1^KVh0/[:b
00@0/[:b00H0QHF50;:b/P2b/[80HF5Q00<30`1eMGD40;:b/P0302l_;`000000H61P00<0/[:b00<0
DU9B000000000000o`0000000`0?3`l000000000003J00000000200000006P0K6a/0/[:b0;Jf]P2a
/K409BDU0000001cLg<0^[Zj0:>SX`061PH00P8209JFUP2g]kL0^[Zj04=3@`000000<c<c08n?S`31
`L40d=3@0:JVYP1PH60010@40000000;2`/0ZZZZ0P2e]KD02@2g]kL0ZZZZ07moO`0O7al0000005]K
F`2i^KT0^;Rh06i^KP020000000H00/;2`2ZZZX0]KFe0;Fe]@2c/k<0V9RH06UYJ@0J6QX0000009BD
U02f][H0]kNg04e=C@000000BTY:0;Jf]P2c/k<0:b/[0000001^KVh0^KVi0;Ng]`1[Jf/0NGUi0P2g
]kL203`l?00:0;Ng]`2e]KD0][Jf0:^[Z`2<S8`0CTi>00<30`0000002`/;0:ZZZP<0]KFe00D0^;Rh
08>3P`000000000003`l?0020820P00604a<C0000000;bl_07inOP20P800Fe]K0`0000001`16ATH0
P8200820P01/K6`00`<305UIF@20P8000`1nOWh02P1jNWX0?clo07MgM`21PH40=cLg0000001PH600
PH6105aLG00[:b/307inOP0=07moO`1cLg<00@4102d];@1nOWh0P82005YJFP0000008B4Q07emO@20
P800J6QX00<30`0200000007030`<01nOWh0Ogmo07MgM`030`<0?3`l0861P@0307inOP0B0820P01H
F5P0LW9b0820P01BDU80000000410@12@T80Ng]k09>CT`20P8008B4Q0000000E5AD0Ng]k07moO`1n
OWh09bLWo`0000020000000300/;2`00000000000=X00000001X0000000301hN7P0?3`l03`l?0?l0
3`l?@@0?3`l00`0N7Qh000000000003J00000000o`00003o000008X00000003o00000?l00000RP00
00000?l00000o`00002:00000000\
\>"], "WWMCHeader",
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {0, 0}},
    Evaluatable->False,
    CellFrameMargins->4,
    ImageSize->{648, 25},
    ImageMargins->{{0, 0}, {0, 0}},
    ImageRegion->{{0, 1}, {0, 1}},
    Background->GrayLevel[0]],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook", "Presentation"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellBracketOptions->{"Color"->RGBColor[0.66717, 0.187915, 0.232395]},
    CellElementSpacings->{"ClosedGroupTopMargin"->20},
    CellFrameLabelMargins->6,
    StyleMenuListing->None,
    Background->RGBColor[0.924025, 0.891524, 0.771649]],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellElementSpacings->{"ClosedGroupTopMargin"->20},
    CellFrameLabelMargins->6,
    StyleMenuListing->None,
    Background->None]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{40, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    ShowCellBracket->False,
    CellMargins->{{0, 100}, {0, 0}},
    CellFrameMargins->{{30, 100}, {10, 20}},
    AutoIndent->False,
    LineSpacing->{0, 44},
    FontSize->40,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.812512, 0, 0]],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{10, 10}, {12, 30}},
    CellFrameMargins->2,
    FontSize->26]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{40, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    ShowCellBracket->False,
    CellMargins->{{98, 0}, {20, 0}},
    CellFrameMargins->{{10, 4}, {4, 6}},
    AutoIndent->False,
    LineSpacing->{0, 34},
    FontSize->24,
    Background->RGBColor[0.833814, 0.797284, 0.0792248]],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{40, 10}, {1, 0}},
    FontSize->18]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Author"],
    CellMargins->{{100, Inherited}, {20, 0}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Author", "Presentation"],
    CellFrame->{{0, 0}, {2, 0}},
    ShowCellBracket->False,
    CellMargins->{{98, 0}, {60, 10}},
    CellFrameMargins->{{4, 4}, {2, 8}},
    LineSpacing->{1, 0},
    FontSize->22,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Author", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Author", "Printout"],
    CellMargins->{{40, 10}, {60, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellFrame->{{0, 0}, {0, 2}},
    CellDingbat->None,
    CellMargins->{{40, 22}, {0, 30}},
    CellFrameMargins->{{99, 0}, {1, 4}},
    CellFrameColor->RGBColor[0.708598, 0.00158694, 0.047715],
    CellFrameLabelMargins->{{4, 4}, {0, 2}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellDingbat->None,
    CellMargins->{{10, 0}, {4, 22}},
    CellFrameMargins->3,
    FontSize->14]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{40, 22}, {0, 30}},
    CellFrameMargins->{{0, 0}, {0, 2}},
    CellFrameColor->GrayLevel[1],
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{10, 0}, {0, 22}},
    CellFrameMargins->3,
    FontSize->12]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{99, 60}, {0, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{40, 0}, {0, 25}},
    FontSize->11]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Rule"],
    CellMargins->{{10, Inherited}, {8, 18}},
    PageBreakBelow->False],
  
  Cell[StyleData["Rule", "Presentation"],
    CellFrame->{{0, 0}, {3, 0}},
    CellMargins->{{99, 60}, {0, 40}},
    CellFrameMargins->False,
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Rule", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Rule", "Printout"],
    CellMargins->{{10, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    FontSize->14],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{99, 22}, {10, 10}},
    TextAlignment->Left,
    TextJustification->0,
    LineSpacing->{1, 3},
    FontSize->14],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{40, 2}, {6, 6}},
    TextJustification->0.5]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextZero"],
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {100, 100}}],
  
  Cell[StyleData["TextZero", "Presentation"]],
  
  Cell[StyleData["TextZero", "Condensed"]],
  
  Cell[StyleData["TextZero", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{119, 22}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->12,
    FontColor->RGBColor[0.0899214, 0.182635, 0.460777]],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{50, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{99, 45}, {0, 10}},
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontSize->16,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.28748, 0.378042, 0.556527],
    ButtonBoxOptions->{ButtonMinHeight->0.125,
    ButtonMargins->9,
    Background->RGBColor[0.665293, 0.0723888, 0.101137]}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {0, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9,
    Background->GrayLevel[0.849989]]
  }, Open  ]],
  
  Cell[StyleData["InputOnly"],
    CellMargins->{{99, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputWord"],
    CellMargins->{{99, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"InputGrouping",
    AutoItalicWords->{},
    FormatType->InputForm,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineInput"],
    CellMargins->{{55, 10}, {5, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->True,
    CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InlineInput", "Printout"],
    CellMargins->{{55, 55}, {0, 10}},
    ShowCellLabel->False,
    FontSize->9.5]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input3.0"],
    Evaluator->"3.0",
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input3.0", "Presentation"],
    CellMargins->{{99, 45}, {0, 10}},
    CellLabelPositioning->Left,
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontSize->16,
    FontColor->GrayLevel[1],
    Background->RGBColor[1, 0, 1],
    ButtonBoxOptions->{ButtonMinHeight->0.125,
    ButtonMargins->9,
    Background->RGBColor[0.665293, 0.0723888, 0.101137]}],
  
  Cell[StyleData["Input3.0", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input3.0", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {0, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9,
    Background->GrayLevel[0.849989]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{99, 45}, {10, 0}},
    CellLabelPositioning->Left,
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontSize->16,
    Background->RGBColor[0.978958, 0.959915, 0.622477]],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {6, 0}},
    FontSize->9]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{99, 45}, {Inherited, Inherited}},
    CellFrameMargins->12,
    LineSpacing->{1, 0},
    FontColor->RGBColor[0.694072, 0.204471, 0.227802],
    Background->RGBColor[0.963821, 0.948333, 0.891249]],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{40, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{99, 45}, {0, 0}},
    CellFrameMargins->{{12, 12}, {2, 2}},
    LineSpacing->{1, 0},
    Background->GrayLevel[1]],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{50, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    CellMargins->{{99, 45}, {10, 0}},
    Background->RGBColor[0.978958, 0.959915, 0.622477]],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    CellFrame->True,
    CellMargins->{{40, 0}, {0, -1}},
    ImageMargins->{{40, Inherited}, {Inherited, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontSize->7,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Indent"],
    CellDingbat->"\[FilledSmallCircle]",
    CellMargins->{{60, Inherited}, {Inherited, Inherited}},
    PageBreakBelow->False,
    CounterIncrements->"Text",
    FontSize->14],
  
  Cell[StyleData["Indent", "Presentation"],
    CellMargins->{{150, Inherited}, {Inherited, Inherited}},
    FontSize->14],
  
  Cell[StyleData["Indent", "Printout"],
    CellMargins->{{36, Inherited}, {2, 30}},
    FontSize->12]
  }, Open  ]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{99, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{10, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    CellMargins->{{99, Inherited}, {Inherited, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Expression Annotation Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to effect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to
make them stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Automatic Numbering", "Section"],
  
  Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{55, 10}, {0, 10}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{55, 55}, {0, 10}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedFigure"],
    CellMargins->{{55, 145}, {2, 10}},
    CellHorizontalScrolling->True,
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Figure ", 
              CounterBox[ "NumberedFigure"]}], FontWeight -> "Bold"], None}},
    CounterIncrements->"NumberedFigure",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedFigure", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedTable"],
    CellMargins->{{55, 145}, {2, 10}},
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Table ", 
              CounterBox[ "NumberedTable"]}], FontWeight -> "Bold"], None}},
    TextAlignment->Center,
    CounterIncrements->"NumberedTable",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedTable", "Printout"],
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]]
  }, Closed]]
  }, Open  ]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 15033, 192, 33, 14810, 184, "GraphicsData", 
"Bitmap", InheritFromParent,
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16767, 245, 89, 2, 104, "Title",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16881, 251, 31, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[16937, 255, 30, 0, 45, "Subsection"],
Cell[16970, 257, 457, 10, 109, "Text",
  Evaluatable->False],
Cell[17430, 269, 203, 5, 52, "Text",
  Evaluatable->False],
Cell[17636, 276, 132, 5, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[17805, 286, 36, 0, 29, "Subsection"],
Cell[17844, 288, 575, 9, 171, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18468, 303, 88, 2, 30, "Section",
  Evaluatable->False],
Cell[18559, 307, 219, 5, 52, "Text"],

Cell[CellGroupData[{
Cell[18803, 316, 29, 0, 45, "Subsection"],
Cell[18835, 318, 114, 2, 33, "Text",
  Evaluatable->False],
Cell[18952, 322, 77, 2, 33, "Text",
  Evaluatable->False],
Cell[19032, 326, 66, 2, 40, "Input"],
Cell[19101, 330, 206, 7, 33, "Text",
  Evaluatable->False],
Cell[19310, 339, 144, 5, 33, "Text",
  Evaluatable->False],
Cell[19457, 346, 48, 1, 40, "Input"],
Cell[19508, 349, 56, 1, 40, "Input"],
Cell[19567, 352, 207, 6, 52, "Text",
  Evaluatable->False],
Cell[19777, 360, 62, 1, 40, "Input"],
Cell[19842, 363, 283, 9, 33, "Text",
  Evaluatable->False],
Cell[20128, 374, 144, 5, 33, "Text",
  Evaluatable->False],
Cell[20275, 381, 67, 2, 40, "Input"],
Cell[20345, 385, 88, 2, 33, "Text",
  Evaluatable->False],
Cell[20436, 389, 81, 2, 40, "Input"],
Cell[20520, 393, 378, 9, 71, "Text",
  Evaluatable->False],
Cell[20901, 404, 76, 2, 33, "Text",
  Evaluatable->False],
Cell[20980, 408, 67, 1, 40, "Input"],
Cell[21050, 411, 86, 2, 33, "Text",
  Evaluatable->False],
Cell[21139, 415, 106, 2, 33, "Text",
  Evaluatable->False],
Cell[21248, 419, 53, 1, 40, "Input"],
Cell[21304, 422, 318, 8, 52, "Text",
  Evaluatable->False],
Cell[21625, 432, 55, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[21717, 438, 78, 2, 45, "Subsection",
  Evaluatable->False],
Cell[21798, 442, 200, 6, 33, "Text",
  Evaluatable->False],
Cell[22001, 450, 116, 3, 40, "Input"],
Cell[22120, 455, 90, 3, 33, "Text"],
Cell[22213, 460, 77, 1, 40, "Input"],
Cell[22293, 463, 33, 0, 33, "Text"],
Cell[22329, 465, 40, 1, 40, "Input"],
Cell[22372, 468, 36, 0, 33, "Text"],
Cell[22411, 470, 80, 1, 40, "Input"],
Cell[22494, 473, 159, 5, 33, "Text"],
Cell[22656, 480, 65, 1, 40, "Input"],
Cell[22724, 483, 140, 3, 33, "Text"],
Cell[22867, 488, 45, 1, 40, "Input"],
Cell[22915, 491, 90, 3, 33, "Text"],
Cell[23008, 496, 57, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[23102, 502, 29, 0, 45, "Subsection"],
Cell[23134, 504, 142, 5, 33, "Text"],
Cell[23279, 511, 117, 4, 25, "Indent"],
Cell[23399, 517, 59, 0, 25, "Indent"],
Cell[23461, 519, 49, 0, 25, "Indent"],
Cell[23513, 521, 71, 0, 25, "Indent"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23633, 527, 80, 2, 30, "Section",
  Evaluatable->False],
Cell[23716, 531, 112, 3, 33, "Text"],
Cell[23831, 536, 273, 7, 71, "Text",
  Evaluatable->False],
Cell[24107, 545, 67, 1, 40, "Input"],
Cell[24177, 548, 64, 0, 33, "Text"],
Cell[24244, 550, 97, 2, 41, "Input"],
Cell[24344, 554, 412, 8, 90, "Text",
  Evaluatable->False],
Cell[24759, 564, 69, 1, 40, "Input"],
Cell[24831, 567, 96, 2, 33, "Text",
  Evaluatable->False],
Cell[24930, 571, 51, 1, 40, "Input"],
Cell[24984, 574, 511, 13, 71, "Text",
  Evaluatable->False],
Cell[25498, 589, 90, 1, 40, "Input"],
Cell[25591, 592, 57, 1, 40, "Input"],
Cell[25651, 595, 101, 2, 33, "Text",
  Evaluatable->False],
Cell[25755, 599, 48, 1, 40, "Input"],
Cell[25806, 602, 141, 5, 33, "Text",
  Evaluatable->False],
Cell[25950, 609, 57, 1, 40, "Input"],
Cell[26010, 612, 845, 21, 128, "Text",
  Evaluatable->False],
Cell[26858, 635, 823, 24, 109, "Text",
  Evaluatable->False],
Cell[27684, 661, 393, 12, 52, "Text",
  Evaluatable->False],
Cell[28080, 675, 294, 10, 33, "Text",
  Evaluatable->False],
Cell[28377, 687, 70, 1, 40, "Input"],
Cell[28450, 690, 48, 0, 33, "Text"],
Cell[28501, 692, 44, 1, 40, "Input"],
Cell[28548, 695, 161, 5, 33, "Text",
  Evaluatable->False],
Cell[28712, 702, 153, 6, 85, "Input"],
Cell[28868, 710, 149, 5, 33, "Text",
  Evaluatable->False],
Cell[29020, 717, 71, 1, 40, "Input"],
Cell[29094, 720, 117, 2, 33, "Text",
  Evaluatable->False],
Cell[29214, 724, 70, 1, 40, "Input"],
Cell[29287, 727, 131, 4, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[29455, 736, 81, 2, 30, "Section",
  Evaluatable->False],
Cell[29539, 740, 326, 8, 71, "Text"],
Cell[29868, 750, 348, 7, 71, "Text"],

Cell[CellGroupData[{
Cell[30241, 761, 43, 0, 45, "Subsection"],
Cell[30287, 763, 244, 7, 33, "Text",
  Evaluatable->False],
Cell[30534, 772, 70, 1, 40, "Input"],
Cell[30607, 775, 303, 8, 52, "Text"],
Cell[30913, 785, 48, 1, 40, "Input"],
Cell[30964, 788, 283, 7, 52, "Text"],
Cell[31250, 797, 63, 0, 33, "Text"],
Cell[31316, 799, 49, 1, 40, "Input"],
Cell[31368, 802, 95, 3, 33, "Text"],
Cell[31466, 807, 61, 1, 40, "Input"],
Cell[31530, 810, 73, 0, 33, "Text"],
Cell[31606, 812, 74, 1, 40, "Input"],
Cell[31683, 815, 130, 3, 33, "Text"],
Cell[31816, 820, 48, 1, 40, "Input"],
Cell[31867, 823, 46, 1, 40, "Input"],
Cell[31916, 826, 158, 5, 33, "Text"],
Cell[32077, 833, 93, 1, 40, "Input"],
Cell[32173, 836, 99, 2, 40, "Input"],
Cell[32275, 840, 68, 0, 33, "Text"],
Cell[32346, 842, 64, 1, 40, "Input"],
Cell[32413, 845, 142, 3, 33, "Text"],
Cell[32558, 850, 75, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[32670, 856, 40, 0, 45, "Subsection"],
Cell[32713, 858, 335, 12, 52, "Text"],
Cell[33051, 872, 89, 3, 33, "Text"],
Cell[33143, 877, 91, 1, 40, "Input"],
Cell[33237, 880, 50, 1, 40, "Input"],

Cell[CellGroupData[{
Cell[33312, 885, 29, 0, 42, "Subsubsection"],
Cell[33344, 887, 153, 4, 33, "Text"],
Cell[33500, 893, 48, 1, 40, "Input"],
Cell[33551, 896, 136, 4, 33, "Text"],
Cell[33690, 902, 50, 1, 40, "Input"],
Cell[33743, 905, 56, 0, 33, "Text"],
Cell[33802, 907, 149, 3, 52, "Text"],
Cell[33954, 912, 45, 1, 40, "Input"],
Cell[34002, 915, 226, 8, 33, "Text"],
Cell[34231, 925, 54, 1, 40, "Input"],
Cell[34288, 928, 237, 6, 52, "Text"],
Cell[34528, 936, 62, 1, 40, "Input"],
Cell[34593, 939, 90, 3, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[34720, 947, 48, 0, 42, "Subsubsection"],
Cell[34771, 949, 115, 4, 33, "Text"],
Cell[34889, 955, 122, 5, 33, "Text"],
Cell[35014, 962, 86, 1, 40, "Input"],
Cell[35103, 965, 107, 3, 33, "Text"],
Cell[35213, 970, 90, 3, 33, "Text"],
Cell[35306, 975, 88, 1, 40, "Input"],
Cell[35397, 978, 45, 0, 33, "Text"],
Cell[35445, 980, 72, 1, 40, "Input"],
Cell[35520, 983, 64, 0, 33, "Text"],
Cell[35587, 985, 85, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[35709, 991, 32, 0, 42, "Subsubsection"],
Cell[35744, 993, 97, 3, 33, "Text"],
Cell[35844, 998, 97, 2, 40, "Input"],
Cell[35944, 1002, 50, 1, 40, "Input"],
Cell[35997, 1005, 133, 5, 33, "Text"],
Cell[36133, 1012, 50, 1, 40, "Input"],
Cell[36186, 1015, 174, 8, 33, "Text"],
Cell[36363, 1025, 77, 1, 40, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36489, 1032, 32, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[36546, 1036, 41, 0, 42, "Subsubsection"],
Cell[36590, 1038, 269, 9, 52, "Text"],
Cell[36862, 1049, 91, 1, 40, "Input"],
Cell[36956, 1052, 92, 1, 40, "Input"],
Cell[37051, 1055, 50, 1, 40, "Input"],
Cell[37104, 1058, 75, 0, 33, "Text"],
Cell[37182, 1060, 54, 1, 40, "Input"],
Cell[37239, 1063, 97, 3, 33, "Text"],
Cell[37339, 1068, 56, 1, 40, "Input"],
Cell[37398, 1071, 192, 6, 33, "Text"],
Cell[37593, 1079, 61, 1, 40, "Input"],
Cell[37657, 1082, 254, 5, 71, "Text"],
Cell[37914, 1089, 54, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[38005, 1095, 41, 0, 42, "Subsubsection"],
Cell[38049, 1097, 53, 0, 33, "Text"],
Cell[38105, 1099, 70, 1, 40, "Input"],
Cell[38178, 1102, 269, 7, 52, "Text"],
Cell[38450, 1111, 55, 1, 40, "Input"],
Cell[38508, 1114, 118, 2, 33, "Text",
  Evaluatable->False],
Cell[38629, 1118, 59, 1, 40, "Input"],
Cell[38691, 1121, 121, 2, 33, "Text",
  Evaluatable->False],
Cell[38815, 1125, 48, 1, 40, "Input"],
Cell[38866, 1128, 201, 7, 33, "Text",
  Evaluatable->False],
Cell[39070, 1137, 64, 1, 40, "Input"],
Cell[39137, 1140, 164, 7, 33, "Text",
  Evaluatable->False],
Cell[39304, 1149, 66, 1, 40, "Input"],
Cell[39373, 1152, 362, 13, 52, "Text",
  Evaluatable->False],
Cell[39738, 1167, 53, 1, 40, "Input"],
Cell[39794, 1170, 139, 5, 33, "Text"],
Cell[39936, 1177, 349, 10, 52, "Text",
  Evaluatable->False],
Cell[40288, 1189, 59, 1, 40, "Input"],
Cell[40350, 1192, 375, 11, 52, "Text",
  Evaluatable->False],
Cell[40728, 1205, 102, 4, 55, "Input"],
Cell[40833, 1211, 114, 2, 33, "Text",
  Evaluatable->False],
Cell[40950, 1215, 57, 1, 40, "Input"],
Cell[41010, 1218, 58, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[41105, 1224, 42, 0, 42, "Subsubsection"],
Cell[41150, 1226, 260, 7, 52, "Text"],
Cell[41413, 1235, 91, 1, 40, "Input"],
Cell[41507, 1238, 220, 7, 52, "Text"],
Cell[41730, 1247, 55, 1, 40, "Input"],
Cell[41788, 1250, 110, 4, 33, "Text"],
Cell[41901, 1256, 71, 1, 40, "Input"],
Cell[41975, 1259, 55, 1, 40, "Input"],
Cell[42033, 1262, 135, 4, 33, "Text"],
Cell[42171, 1268, 324, 8, 71, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42544, 1282, 38, 0, 45, "Subsection"],
Cell[42585, 1284, 135, 4, 33, "Text"],
Cell[42723, 1290, 91, 1, 40, "Input"],
Cell[42817, 1293, 50, 1, 40, "Input"],
Cell[42870, 1296, 97, 4, 33, "Text"],
Cell[42970, 1302, 58, 1, 40, "Input"],
Cell[43031, 1305, 50, 1, 40, "Input"],
Cell[43084, 1308, 63, 0, 33, "Text"],
Cell[43150, 1310, 69, 1, 40, "Input"],
Cell[43222, 1313, 50, 1, 40, "Input"],
Cell[43275, 1316, 66, 0, 33, "Text"],
Cell[43344, 1318, 112, 2, 40, "Input"],
Cell[43459, 1322, 50, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[43546, 1328, 29, 0, 45, "Subsection"],
Cell[43578, 1330, 124, 5, 33, "Text"],
Cell[43705, 1337, 203, 6, 52, "Text"],
Cell[43911, 1345, 52, 0, 33, "Text"],
Cell[43966, 1347, 147, 4, 33, "Text"],
Cell[44116, 1353, 53, 0, 33, "Text"],
Cell[44172, 1355, 67, 0, 33, "Text"],
Cell[44242, 1357, 109, 3, 88, "Input"],
Cell[44354, 1362, 50, 1, 40, "Input"],
Cell[44407, 1365, 50, 1, 40, "Input"],
Cell[44460, 1368, 128, 3, 33, "Text"],
Cell[44591, 1373, 42, 1, 40, "Input"],
Cell[44636, 1376, 260, 6, 52, "Text"],
Cell[44899, 1384, 369, 6, 90, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[45317, 1396, 89, 2, 30, "Section",
  Evaluatable->False],
Cell[45409, 1400, 296, 8, 52, "Text",
  Evaluatable->False],
Cell[45708, 1410, 128, 5, 85, "Input"],
Cell[45839, 1417, 487, 14, 71, "Text",
  Evaluatable->False],
Cell[46329, 1433, 72, 0, 40, "Input"],
Cell[46404, 1435, 297, 7, 52, "Text",
  Evaluatable->False],
Cell[46704, 1444, 138, 6, 100, "Input"],
Cell[46845, 1452, 91, 3, 55, "Input"],
Cell[46939, 1457, 97, 1, 33, "Text",
  Evaluatable->False],
Cell[47039, 1460, 61, 0, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[47137, 1465, 32, 0, 30, "Section"],
Cell[47172, 1467, 250, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[47447, 1477, 36, 0, 45, "Subsection"],
Cell[47486, 1479, 121, 3, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[47644, 1487, 35, 0, 29, "Subsection"],
Cell[47682, 1489, 99, 3, 33, "Text"],
Cell[47784, 1494, 143, 3, 40, "Input"],
Cell[47930, 1499, 58, 1, 40, "Input"],
Cell[47991, 1502, 69, 1, 40, "Input"],
Cell[48063, 1505, 83, 1, 40, "Input"],
Cell[48149, 1508, 51, 1, 40, "Input"],
Cell[48203, 1511, 121, 3, 33, "Text"],
Cell[48327, 1516, 60, 1, 40, "Input"],
Cell[48390, 1519, 91, 1, 40, "Input"],
Cell[48484, 1522, 34, 1, 40, "Input"],
Cell[48521, 1525, 135, 2, 40, "Input"],
Cell[48659, 1529, 63, 1, 40, "Input"],
Cell[48725, 1532, 51, 1, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[48813, 1538, 32, 0, 45, "Subsection"],
Cell[48848, 1540, 304, 5, 71, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[49201, 1551, 91, 2, 30, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[49317, 1557, 32, 0, 45, "Subsection"],
Cell[49352, 1559, 147, 4, 33, "Text",
  Evaluatable->False],
Cell[49502, 1565, 74, 0, 40, "Input"],
Cell[49579, 1567, 81, 1, 33, "Text",
  Evaluatable->False],
Cell[49663, 1570, 120, 8, 130, "Input"],
Cell[49786, 1580, 42, 0, 40, "Input"],
Cell[49831, 1582, 247, 5, 52, "Text",
  Evaluatable->False],
Cell[50081, 1589, 50, 0, 40, "Input"],
Cell[50134, 1591, 188, 5, 52, "Text",
  Evaluatable->False],
Cell[50325, 1598, 54, 0, 40, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[50416, 1603, 39, 0, 45, "Subsection"],
Cell[50458, 1605, 254, 8, 52, "Text",
  Evaluatable->False],
Cell[50715, 1615, 84, 1, 40, "Input"],
Cell[50802, 1618, 244, 6, 52, "Text",
  Evaluatable->False],
Cell[51049, 1626, 84, 1, 40, "Input"],
Cell[51136, 1629, 166, 5, 33, "Text",
  Evaluatable->False],
Cell[51305, 1636, 82, 1, 40, "Input"],
Cell[51390, 1639, 306, 7, 52, "Text",
  Evaluatable->False],
Cell[51699, 1648, 57, 1, 40, "Input"],
Cell[51759, 1651, 185, 6, 33, "Text",
  Evaluatable->False],
Cell[51947, 1659, 79, 1, 40, "Input"],
Cell[52029, 1662, 148, 5, 33, "Text",
  Evaluatable->False],
Cell[52180, 1669, 81, 1, 40, "Input"],
Cell[52264, 1672, 287, 8, 52, "Text",
  Evaluatable->False],
Cell[52554, 1682, 572, 14, 90, "Text",
  Evaluatable->False],
Cell[53129, 1698, 71, 1, 40, "Input"],
Cell[53203, 1701, 272, 8, 52, "Text",
  Evaluatable->False],
Cell[53478, 1711, 89, 1, 40, "Input"],
Cell[53570, 1714, 164, 6, 33, "Text",
  Evaluatable->False],
Cell[53737, 1722, 267, 8, 52, "Text",
  Evaluatable->False],
Cell[54007, 1732, 74, 1, 40, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54130, 1739, 74, 2, 30, "Section",
  Evaluatable->False],
Cell[54207, 1743, 138, 5, 33, "Text"],
Cell[54348, 1750, 117, 4, 25, "Indent"],
Cell[54468, 1756, 59, 0, 25, "Indent"],
Cell[54530, 1758, 49, 0, 25, "Indent"],
Cell[54582, 1760, 71, 0, 25, "Indent"],
Cell[54656, 1762, 138, 3, 42, "Indent"],
Cell[54797, 1767, 55, 0, 25, "Indent"],
Cell[54855, 1769, 41, 0, 25, "Indent"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

