(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21733,        431]*)
(*NotebookOutlinePosition[     22433,        456]*)
(*  CellTagsIndexPosition[     22389,        452]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N000061000`40O003h00OJgoo00Ikog?NJia[
W7>LNmh4Ool00gOoJg]c_@05Ool01GOoJke[NfnLOmh0g7oo001YOol047?oDeU6DTV]CHa1cSIc?YAJ
mgNmOomSW56<@NlfLe[g0Woo00U_oe<HBLi=JdG>=U8nU5lGMmh0fWoo001XOol00f_NH:El0005O000
16R4=Li2eVIB0g`000EXHcHaKke__FAS00El0004H:D^4DjDMmkIOol006Moo`03Nomh07`000Ql0003
>Q1l07`000=l0003CLeO_G`000Ql0003<Q1JmWoo0=Qoo`0000MVNFIjHWYVNV9jIWYRN@02IWX0269i
IWYVNV9jIWYRNFIjHWX2IWX00f9iIWYRNP02IWX2HWX2IWX00f9iHWYVN@02IWX01F9jIWYVNFIjHWX0
0VIj01=RNVIjHWYVNV9jIWUVNVIiHWYVNVIiHWYVNV9jIWYRNVIjIWURNP02IWX01F9iHWYVNVIjHWX0
0VIj00ERNFIjHWYVNFIj009RNP06IWUVNVIjHWYVNV9j0VIj00=RNVIjIWT00V9j0VIj00ARNVIjIWUR
NP9VNP03HWYVNF9j009VNP03HWYNgW@000]l0003O21l07`0009l0003CM9d0G`000Ql0009L00MKeHF
J[]VVfZjJY]V^fZj009Z^`03J]]Z^f[K009Zf`03K]]ZnfkK009^n`03K_a^nfkl009^o004Kaa^o6lL
La`3Ka`05W<mLaac?7<lLaac?G<lLcec?7LmLeac?GLlLeec?G=MMeecGGMMLeegGG=M0WMM0gMm00Eg
GGMnMgegOWMm00=gOP0=NiigOGMnNiigOWNNNiigOGNNNiigWW^NMkh017^N00Ek_W^NNiik_W^O00Ik
_P0>Nkmo_W^oNmik_gnoNmio_g_OOmmkgWnoOmmkg`Aog`03NmmoggoO009og`03OomoggoO065oo`00
00<d43P@>1000SP@00Hd4CP@=10h43PA=102>1001C@@>10h43P@=1000SP@00<d43P@=1000cP@00ld
43P@>14h43@@>10d43P@=14h43@@>10d43P@=1000SP@00Ld43P@=14h43@@>10d4@02>10013@@>10d
43P@0S@@00<h43@@>1000SP@00Td43P@>10d43PA>10d43P@=1000cP@00Ld43P@=10h43@@>10d4002
>1001C@@>10h43P@=1000SP@00@d43P@>10d408h4006=10h43@@>10d4CP?1G`000<l:TQ>O00017`0
00I41W`0O01l05`W?2h5O0000f`2O01l0003O0001B@692dlDT1a?7800T2B00A0Td2bA;=4/`94d`03
A?A8m4Sd00995003CAE9=DdD009=E@03DEIAME5e009AMP05DIIEUUFFEIME]P02EKL015WGEMMIeeGG
15Wh00aN65XHGQQN65hhGQQN>F8hHUUR>69IGUT3HUT0369iHWYVNF9jIWUVNV:IIYYVNVJJI[YZVP9V
^P06J[]Z^V[KJ[]ZffkK0f[K00=Znf[lK_/00Vkk0VlL00=_6flLK_`00W<L00A_?7<lKaac?09c?@09
Leac?G<mLeagGG=MMeegOG=M00=gO@07MiigOGNMMiikWGNNNih00W^n00AkWW^nNkik_`9k_P06Nmmo
gW_OOmikggoOEWoo0002A=<01DBcA=A4ddCCA;<014CC00]4/dCCA==4e4CCA;=4ddBcA=A4ddBc00=4
d`06A;=4e4CCA;=4ddCD0TCC00=4/dCCA=<00TCC00=4/dCDB;<00TCC00E4]4CCA;=4ddCD00A4d`06
A;=4ddCDA==4/dCD0dCC00E4e4CCA==4ddBd00=4d`03A;=4ddSD0094d`03A;=4e4CC00=4d`03A=A4
ddBc0094d`03A=A4ddBc0094d`03A=A4ddBd00A4d`0>A=A4ddBcA=A0e5B_O05d0g@SN05TB3Cg:?QP
9@Al0006:6X`eEB?B;8`nW0S17`000</JRciF8h017`000EL8b3>BAA=5Ddd009==@03DEE=EU5E00=A
MP9EUP0=DIIEUeFgEKII]eGGFMMEeeggFOMIf5hHFOP00ehH00MN>5hIGSQN>68iHUUN>@03HUT01f9i
IUURNFIjHWYVVFIj00AVVP09IY]V^VZJI[]Z^VZkI[]ZfVZj00EZf`07K_]ZnfkLJ_]^nfklK_/00Vkl
00I_6flLKaa^o7<LKc`2La`00flmLaa_?@02Lc`2Lcd02WMLLeecGGMMLeegGG=mMeegOGMM0WMm00Qg
OWNMMgigWWMmNiigWGNN0g^N00=k_W^NMkl017^n00Qo_g_NNkikggoNNmmogWoo0WoO00=ooWoOOol0
EGoo0002A;<0142B?54lDSab0TBc0210Td2BA;=4/cab@58lLCaB?790LSab@994/d2c@58lLT1b@990
LSab@74lDTBBA;=0Tcab@54lLT1bA;=0TSaA0Sab0T2B01LlLT1a?590LSab@590LT2B?790DT2BA;=4
/T1bA;=4Td1b?74lDT1b?78lLD1b0094/`09@78lLSaA@790Tcab@54lLT1b0094/`05@990DSab?590
TP02A;<013ab?34lDSaA0T2B014lDT1b@9=4/d2B?790LSaA@9=0e3SF>?LlecSF?=I8/dAY00El0005
;;50e42d@=@he`04O00017006914dcCi17`000Id01b^A?===DTECC@2CCD01E5ECEEAEE5fDGD00U5f
0UFF00aE]UFgEKII]eGGFKQEeeWhFOMIn5ggFOP4GQP2GST2HSP6HUT01fIjHUUVNF9jIWURVVIi009V
VP05JYYVVfJjJYYV^`02J[X00fZkJ]]Z^P03J]/02fkKJ]]^nf[KK_]Zo6kkJaa^o6kkK_`00VlL00Uc
6flLLaa_?7<lLaa_?G<lLcd00W<l0W<m00=gG7<mLed00W=M01EgGG=MMgecOGMnMgegOWMmNgigOGNN
MiekOW^NMiikWGNnNiik_W^NNkl00W^n00Qo_W_NNkmogg^nNmmogg_O0WoO00AoogoOOomogeEoo`00
02i4/d2BEKMZ^ehHJ[Y8ld1cCEEEUT1bA==VVV9IFMQRFFIiGSUVNUFF@79AMVJJFMMVNU5fGQQRFEWH
IYYAUT1bDGIZ^UWhGSUR>CaBGQQVVUWGIWYEUUVgIWYIf0=RF@0>IYYE]ddeIYYRFEWG@794m5Vg?59=
EFJJGQUN60=RF@0:HSTlLTBcIYYIn68iGQQ=EFZjFOP2HST06D2C@99I]fJjFMQRNEgh?98h46JJMii^
fflLB?AAUVIjIYYAMT1bEGIVVUWGIYYEUT2B00=4/`03A=@leFA800El0006>6/le4RdA==0]3cE17`0
00EH0b2>A;@lmg0T00Al00046:e954dECA@3CCD07deEDEEAEU5eDEIAUUFFDIIEUeFfEIME]eGGFKME
eeWgFMMImeghFOQJ65hGGOQN65hiGQQR>5iIHSUNF68i00=RF@08HWYVFF9iHWYRNFIjIYUVNP=VVP03
I[YVVVJk009Z^P05I[]Z^fJjJ]]Z^`05J]/01FkkJ]a^nfkkK_`00Vkk00=_76kkKa`00flL00Ec76lL
Laac?6lL009c?00=Leec?7=LLcecG7<mLeegGG=MMgegGGMnMed00gMm00IgOWMmMiekOWNNMid3Nih0
0gNNNiik_P02Nkh027^oNkik_goNNkikggnnNml2Oml017_nOmmoogoOEWoo0000?DBc@9=956JJOomE
]dBc?75Mn7oo=110TUFgLceoog<mB?Aoof9IA==0TdCCGQUoogMm@998m7MmOomN64CD@998m5FgOomo
gdSd@79956[LOomVVTBcA?=^o7ooHSU==E5EEIIooddeK_]oodBc@79==Goo>114ddde009oo`07A;=^
o7oOA==4/d2BBCD00Woo00=8m4BcDIH00Woo00U954BB@9=8lehIOomgGDCC>1000Woo00i8e42BHUUo
oe5FOomRFDCC@9=4dehIOomkWT2c0dBc00A4ddBc?=I/A`Al0007>4L<S3b@A;A4/dCC?=H017`000EL
8QR=@;8ln7@R00Al00048<i4m4dEBA@2CCD014eECCE=EE5e0U5f015AME5fEIIAUUFGEKII]UFgEMMI
]eWHFOMIf5WgGQQMn5XH009N6004HQQN>EhHGST2HST00eiIHSURF@02HUT0269jIWURNVIiHWYVVVJI
IWX4IYX01fZjIY]V^VZjJ[]ZffZj009Zf`0EJ[]ZffkKJ_]ZffkkJ_a^g6kkK_a_76kkKaa^o7<KKaac
76llLaa_?6lM009c?00BLcec?7<mLcagGG=MMeegG7=MMeecGGMmMeegOG=nMgegOWNM0WMn00UgWG]n
NiigWG^NMiikWWNnNih01G^n00]k_g_OOmikggnnNmmoogoONmmoogoO05Ioo`0002]4/dCC@98d47^n
>150/caAHSUooeFF?790DT2BOomEUS@@DEERNS`aA;<lDE5EOom4dd1b?59=5GooA==0LTBc@;<d3goo
Ka`h44CC@78lDGooDGHlDP02@780?7ooCEDlDD2C>35AMG<m>15_73`a?79EUWooIWTh<CP@Lceogc@@
>11gOCPA@;=4/c@?OomZVSPA@;<d47ooMcdd44BcA==0Tc0?OomR>3@@FMMoocPa@790/SPAGQQ^fd2b
IYXl<DCC?55AEGooA;=0LTBc?=DX/@8PSP0378m0SGPT00Al0003:4L/STCC0094/`03>=Ml07`000=l
000316/PSR2a00Al0006K00TdDdEBAA==Ddd0Tde00Y=EE5FCEEAEU5eDGIEUU6FEIME]P=E]`9Ie`06
EMMIeeWgGOQIn5Wg0ehH015N>EhHGSQR>EiHHSURFEiIHUURNF9IIWURFVIiHWYVNVIi00EVVP09J[YV
VfZjJ[YZ^fJkJ[YZ^fJk009Zf`0<K_]Zff[KK_]ZffkkJ_]^o6[kK_a_76lK16lL00=c76llLa`00W<l
00Qc?G<lLcecG7<mLeec?G=L0g=M029gOG=MMgegOGMMMgegOWMmMiigOG^NMiegWW^NMiikWW^nMiik
_g^nNkmk_WnoNkikggoNNkiogg_OOmikggoOOomogUMoo`0001m0/dBcA=<lDV[KEII0Tc`aK_aoogoO
?350TT1bOomVVSaA>35k_SaB?34`46ZkOolh4D2c@;90TWooFMLlLP02A;<013PaNgioocPA0TBc038h
4GooIYXlDDBc>11oofIj?554/dSd?790TSaALce0TcaAHUYoogMn@78h<FZkOolh<CaBIWUMn3P@>154
/gooEKI0LTBc?35c?Goo>114ddBcA=<h47ooMgh`3gMMOold44CC0TBc01<lDE6G?35kWSaB?34`46Zk
Oolh4DBc?=EXB6PSG09L8VP106`@[`04O0001f0188m4/dCCA;<leVa600Al0003J08dAg0000Al000;
D2@hlddECAA95DTdDCE==E5ECEEAE@02DGH04U6FDGIEUU6FEIME]UFgFKIEeeVhFMMImeWHFOMN65Wh
GQMJ609N6006GSUN>68iHSUNF68i169I00ERNVIiHWUVNF:J009VNP03IYUVVVJK009VVP05J[YV^fZj
I[YZ^`03J]/016ZjJ]]ZffkK0V[K00I^nfklK_]ZnfklKa/2K_`00flKKaac7002Ka`01W<LKcac76lm
Kcac?09c?@0<LcagG7=MMeecGGMMLeegGGMmLeegOGMn0WMm00agOWMmMiikOG^NNiegWW^NMkikWW^n
Nih4Nkh01g^oOkikgg_OOkmkgW_O00=og`03Oomoggoo05Eoo`0000Q4ddBcA;=0TUFFJ_]0DCPA0Woo
04AIefJJ?54h4GooLa`l<D1bEIIooflLLaaoogoO>114ddBc>15oof9J?554ddBc?55Z^goo<0llLT1b
=0moogMM>354/cPAOom^o30??55gGCaAA;=0LVIjEIHd47^NOom8m6kk=11R>Goo>354TSaBOom_77<L
Niiood2c@994/caAHWYoocPA0dBc00Ph4GMnOol`3WMnOolh4D2c0TBc00e0ddBB?79EUWooKaac77oo
Nmlh442c?=Id9004O0000g0RK09l0003O0000f@1;;54e002A;<00d3DB;9l000:O0001BR_BAE=54TE
CA@00dde0TeE00MAMU5EDGIAMUFFDIIEU`02EKH2EKL04EWGEMMImeWHFOMMn5WgGOQJ65hIGQQN>5hH
HSUN>5hiHST01F9I00QVNV9iIWYRNVIiIWYRVFIj0fJJ00UV^VZkIYYZ^fZjJ]YZ^fZjJ[/00V[K00a^
ff[KJ_]^nf[KK_aZnfklKa]^o6kkLa`4Ka`01g<LKcec76llLaac?7<m009c?005Leec?G=MLeecG002
Led00gMmMeegO@03Mgd037MnMgekWWMmMiigOGNNNiigWW^NMiikWP=k_P0?Nkmk_WnnNkikgWnoNmik
ggnoOomoggooNmmoogoO05Eoo`000dBc00=0/d1bMgh00SPa015oogMM<0moocaB>11oog^o>354/cPa
Okm0LSQAOomZfc`a0094/`0:=11oogMM>354/dCC?59In7ooGOP2HUT0<eWhOomoocPAA;<h<G=MOomV
NW^oNkhh4DBc@99=EF[K<0ioog<m<0ikOSPaEGIood2B@;<l<F[KFMLh<FlLOolh4DBcA=<lLUWGOom0
TT2CA==4/caAIYYoob`>K_aoocP@A;=4d`02A;<0342cA;<h<GoO@78hDGooK]/l<DCC@;A0d`Yl0008
@6/le4BcA;=4dd2c>=M/A`Ul000>D4Lm5DceBAA=54TECCA==DeECCEAEDeEDGIAM@9AMP9EUP05DIMI
]eFfFMME]`02FML015WgFOQImeWh0UhH00UMmehHGQQN>EhHHUUR>5hiGUT00f9I00MRNF9IIUYRNFIj
HWYVN@04IYX01fJjJYYV^VZkI[YV^fZj009Zf`05J[YZff[KJ]]^f`02J]/04FkkJ_]^o6kkJ_]^o6lL
K_]_77;lKaac76llLaa_77<mKc`00W<l0W<m01]c?7=MMcecG7MMLeegGG=MLgegGWMMMgegOWMmMiig
OW^MMiekWWNNNiikWG^NNkigWW^nNil00W^n00ek_g^nNmik_g_NOmmogW_OOmmogWoOOomog`1FOol0
000OA;=0/dCCA;<lDG<LA9=4dgooIWTd46IJIYX`3goOOolh44Bc@79N>E6F>11ooeWG?594ddBc?35g
OWoo>1000TBc02M0LU5EOomIeddeDII8m6klOolh44Bc?55Z^gooA==N67oo?550/dBc@79^o3P@OomR
FC`aDIIRFD2COom9541cA;94/fkl;0ioog^n>1400TBc00E0LTdeOom==D2B0094/`0:?79Mn7oo=11A
MWooA;=0TTBcA=<2A;<024CC@79R>E6F>11ooeWG?782A;<00ccFE8il0007O0001E1Y>=I4]4BcA=<0
0dBc00<dmfa7O0001W`000QHAcTHB?A954SdBAE=54dd0Tde00]=EE5FDEEAMTefEGIAUUFFDIME]UFF
009E]`08FMMEeeWGFMQIeeWhGOQIm`=N6003GSUR65hh009N>@03HUQR>F9I00=RF@07IWYRNVIiHWYV
NFJJIWX00VJJ00YZVVJJIYYVVfJjJ[]Z^VJkJ[YV^`9Zf`0<J[]^nf[KJ]]^nf[kK]a^nf[kK_a_76kk
0VlL00Q_6g<LKaac76lLLca_?7<L0W<m00]c?7MLLcacGG=LLcecGGMMLeegOGMM009gO@03LgegOGMn
009gO@06MgikWWMnNiegWW^N0WNN015k_W^NNkik_g^nOkikgWnoNmmo_W_ONkmogWooNmmoogoO05Mo
o`0001m4/dCCA;=0/d1bGQQEeddeOomE]caB>31ooc@?KaaoocPAA;=0/dBbK_a=5GooB?A0TT2CA;<l
<FZkOolh4@02A;<0:42B@9=ooe6F?350TS`aFMMoocaBA;<lDEhHOold43P@Lce8m42BA;<lDF9JFMMo
oe5f@78h<G<lA==ooeFG?994/caBJ_]4TgooJ[/lDD2B0TBc00@lLWooFOQ0DP94/`08?79=EGooBA@d
47ooJ[/h<@A4/`0??590/T1bK_a=5GooB?A0LTBcA==4/ccFA;=TB7@S009l000:M0=PJ42d?=I4/dCC
A;=0/dBcA=<2A;<02CSGC;1XAg`1O01h0FA6A;4m5`03B?@00dTDCAA95@02CCD02deECCE=EE5FDGEA
MU6EEGIAUUFFEIL00UFf00YI]eGGFKMIeeWgFOQImeWhGOQJ60=N6005GSUR>5hiHUUN>@06HUT01fIi
HWYVNF9jIYUVNVJI009VVP0:IY]Z^VJkJYYV^VZkJ[YZffZjJ[/4J]/016kkJ]]^nf[k0Vkl00A^nfkl
Kaa^n`E_7004Lcac77<lKc`2Lc`2Lcd01W=MMcecGG=MLeacG@9gG@03LgegGGMm009gO@9gOP0:Mgeg
WWMmMiikWW^MMiik_W^NMih3Nkh01W^oNkik_W_NOkikg`9ogP06NmmoggoOOmmoog_OEWoo0005A;<0
34CCIWYR>GooB?A0TT1bHUUIn5ghOollD@94/`0T?59IegooOolh44SdDCDlLCabGQQoocaA@;=0LTde
>35oof9J?554/d2BDEEoodTD@98lTUEfOom9541c@990LTSDA==0TdCC0Woo02Q0TT2C@99EUVIjOomI
md1AA;=0TTBcMgeooeFg?35EUcaA@;<h47ooIYXlDD2cA;=8m41bOomIecP@GQQooc`a@794/d2bA;=Z
fd1B?79Ie`9oo`03=10lLT2B00=4/`03@=@leCSG008leP05>?LleD2dA;=0d`03A;<00dCCA;=0/`02
A;<023cD?=HheccF??LleTCeA=<3B?@014dDBAE==DdD0Tde01E=EE5ECEEAMU5EDGIAUUFFDIME]UFG
EKMIeUFgFMMEeeWhFMMIn5hHFOL00ehH00AN>5hHGSUN>09R>@03GUQRFF9I009RF@06IWYRNV9IHWYV
VFIj16JJ00YV^VJJJYYV^VZkJ[YV^fZkJ]]Z^P=Zf`05K]]Zff[KJ]]^o002K_/00f[lKa]^n`02Ka`0
17;lKaac?6lL0W<L00A_?7<MLcac?@9c?004LcecG7LmLe`2Med01g=mMeegGGMmMeegOGMn009gO@06
MiigOGNNNgekWWNN0W^N00AgWW^nNkikW`=k_P04Okmk_W_ONkh2Nml01GoONmioggooOmh0Egoo0000
1d2cA==4/dCCA;<h<FZj009oo`09?350/dBc?35gGEWgOom8e42B0094/`0M=11oogoo>10lLWooB=@d
44BcOom4/cPAA==ogbP=OomgGC0@A;<lLSPAOomI]cPA@78h<GooDGHh4002>34017oo@;=4TR`>0Woo
00Pl<D2cA;<h4G<LOomVNS@@0TBc02Hh4G<LOom4dc`aJ_]c7C@?<0moog^N=10d3gNNEIHX3GooIWXd
430?NkioocPa?58l<E5fOolh<DBc>11oog^NCEEooe5f@994/dCC0dBc00E0ddBcA;=4/dCC00=4/`0<
A==4/dBcA;=4ddBcA==4/dCCA;=0/dBd0TCC00i8e4SdA?=8m4TDCAA954TeCCEA=DeEDEEAEU5e0U5f
00EEMU6FEIIE]eFf009E]`03FMMEeeWG009Im`9In003GOQJ65hH009N6006GSUN668iGSQRFF8i0V9I
00URNF9IIUURNFIjHWUVNV:IIWX016JJ00MV^VJKJ[YV^VZkJ[YZ^`06J]/00fkkJ]]^n`02J_/01Fkl
K_]^o6lLK_/00VlL00ec76lLLca_76llLca_?7<mLcac?G=MLcac?@03Led00g=LMeecG@03Mgd02gMn
MgegOGNNMgegWW^NMgigWG^NMih00W^N00AgWW^NNkik_`=k_P05Ommk_WoONmio_`02Oml01GooNmmo
ggooOml0EGoo0002A;<0442cA;=4/d1bCCEoogoO>114/dCC?79E]goOOom953ab0TBc00llDFZkNihh
DCaBHUUoofIjK_]oog^NHWUoog^nGQP00Woo00A^o4CCCAEgO@9oo`03HYU95GMM009oo`07J[YZ^goo
Oolh44SdK_`00Woo00Dh4DBcA;=0TTTD009oo`0<J]]4ddBc@990/goo?350/cPAOomk_VIj0Woo00ER
FG=MOom4/fkK009oo`0DJ]]4/c@?KaaooehHFOQoogoO?554/caAJYYcGE5fOomE]T1bA==0/`94/`0:
@==4/dBc@;=4ddBc@;=4/dCC@;<2A;<0143CA;=4/d2c0TBc00e0ddBcA==4/dSCA==4m4SdBAA<m4TD
CAE==002CCD3CED2DGH02E6EDGIEUU6GEIIE]UGGEKMEe`02FML03eWHFOQImeghFOMN65XHGQQN>EhH
HSUN>F9IGSQN>@02HUT01VIIHUURNFIjHWYRN@9VNP03IYUVNVZJ00=VVP0?J[YVVfZjI[YZ^f[KI[YZ
^f[KJ[]ZnfkKJ]]^nf[K009^o007J_]^nfklKa]^o6lLKa/00VlL00Ec76llLaa_?G<L009c?007Lcec
?7LmLeec?7=MMe`00W=M00EgOG=NMgegGGMm009gOP0>MgegOW^MMgigWG^NMiikWG^NMkikWW^nNkmo
_P9k_P07Nkmk_W_ONkiogg_NNml00goO00=oogoOOol0EGoo00002TBcA==4/dBc@;90TehhOomkWSPa
0dBc00Dd47ooOomc7D2B0094/`0V@;=0/TdD@9=4/d2BDGI8ldCD>354ddSdBAAA=E5f@;=0TUWG@;=8
m5FF?558deFGB==EUSaaA;=E]eEfCEE4TT2CA==E]dCCA;=0/P=4/`04@794ddSdEKL2A;<05dCC@798
m4BbA;=0TU5EBAA8m3ab?59=54BcDGI4/eFg@794/eVgA;=0/c`aA;800UhH00Y4/cPaA;=4dd2c@998
m3aAB?A0LP=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00=4ddBcA;<014Bc00A4ddCD
B=A8l`98m003BAA95DdD00===@03CEEAEU5E009AMP0=EGIAMU6FEIIE]eFFFKME]UVgEMQIeeWgFML0
0UWh00=J65ghGQP00UhH00AN>EhhHSQR>@9RF@0;GUURFF9IHUUVFV9iIWUVNV9iIWYRVP03IYX026Jj
JYYV^fZjI[]Z^VZkJ[X2J]/02FZkJ]]Zff[KK_]ZffkkJ_]^n`02K_`01VlLK_a_6fklKaac709_700;
Laac?7<LKcac?G<lLcec?7<mLeagG@02Led2Med017=MMgegGG=n0gMm00agOW]mMgigWGNNNiekWWNN
NkikWWNnNih2Nkh03G^oOkik_W^nNmmogW^oOmmogWoONmmooWoO05Moo`000TBc00U4ddBc@79cGG<L
J[]In41bA=<00TBc00M0LUFFK_aV^W^NB?A0/`02A;<02T2CA;=4/dBc@790TdBbA;=0TdBC0T2B00i0
TdBB@9=0TTBCA;=0TTBc@9=0TT2c@994Td2C0T2B00M0LT2cA;=4/d2BA990/`03A;<01DCCA;=0TT2C
@98014Bc00M0/dBcA;=4/d2B@9=0TP02A;<0242BA9=0TT2c@794/T2C@983A;<0142c@790LT2c1DBc
00=4TdBc@;<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00TBc
00I4ddBcA?=4ddSdB=@2BA@02TdDBAE==4deCEE==E5ECEEAME5F0U6F00AEUUFGEIIE]P9E]`09EMMI
eeWGFMMIn5ggFOQMn5XH009N600BGSUN65hHGSURFEhiHSURFF8iHWURFVIiHUURNV9iIYYVNVIi16JJ
00UVVfZJI[]Z^VJjJ]YZ^f[JJ[/00f[K00Y^ff[KJ]]ZnfkkK_aZnfkkK_a^n`9_700EL_a_76lLLaa_
?7<MKcac7G<lLcec?7=MLcacGG<mLeegGG=LLeegOG=M00AgO@08MiigOGMnMiekWWMnNiigWP9kWP05
MiikWW^nNkik_`03Nkh027oONmik_goONmiogg_OOol2Oml00gooOmmoo`1DOol000E4/`04?54lDSaA
@783A;<01TCCA;=0LSaA?58lD@A4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBc
A;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05
A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03
A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dSD
A?<014Sd00===DdDBCD00Tde00M=EE5EDEE=MU5eDGIEMP02DIH035FgEIME]UVgFMMEeeWGFMQImeWh
GOQIm`AN6006GSUN>5hhHSURF5iI169I00MRNVIjHWUVNV9iIYYVNP04IYX01VJjJY]Z^VJkJ[YV^`9Z
^`0@J]YZff[KK]]ZffkkJ]]^nf[lK]]^o6[lK_]_76klKa/2Ka`01W<LKaac76llLca_?09c?007Lcec
?7=MLcacGGLlLgd00WMM00=cGGMmMed00gMm0WMn00MgWGMnMgekWGNNNiigW@02Nih00gNnNiik_`03
Nkh01gnoNkikggoNNmmogg_N009og`9oo`03Ommoogoo05Aoo`000814/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dSD0TCC
00A8e4SdB?E9509=5008BAE==E4eCEEAEDeEDGIEMP9AMP08DIIEUUFGEKII]UFgFMMEe`9Ie`05FOMM
meWhGOQJ6003GQP01V8iGSQN>F8iHUUN>@=RF@06IUURNFIJHWUVNV:I0VIj00UVVFJJIYYZVVJjIYYV
^VJkJ[X00VZk00=ZfV[KJ[/00f[K01A^nf[KK_aZffkkK_a[6fkkK_a_6flLLaa_77<LKaac?6llLaa_
77<l0W<m00Ac?7<mMcac?@EcG@0@MgegGGMmMeigOGMnMgegWGMnMiikWWNNNiikWG^NMkh2Nih3Nkh0
2G_OOkik_W_NNkmogW^oOmikg`02Oml00gooOmmog`1FOol0008/3P04<0h/3R`><0h2;0h0130>;0h/
3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04
<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>
0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/
3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>
00@`3R`>;0h`3P8/3P05<0l`3S0?<0ld3`03=102>103>342?5400cab@790TP02@9800dBc@;=4d`02
A=<2B?@3BA@04TddBCE==DeDCEEAEDeeDEIAME6FDGIEUU6FEKIE]eFfEKMIeP9Ee`07FMMImeWgFOQI
meghFQP015hH0ehh00AR>EiHHUUNF@=RF@9RN@05IWURNVJIIWYVV@03IYX3I[X016ZkI[YZ^f[J0V[K
00YZfV[KJ_]^nf[kK_]^o6lKK_a_6`=_700KLca_?7<LKcac?G<lLeac?7=MLeacGGMmLeegOG=mMgec
OGMnMiegOGNNNiigWG^nMiik_WNn009k_P07Nmik_goNNmikggoOOoh0Dgoo0000
\>"], "Text",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {Inherited, 0}},
  Evaluatable->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Manipulating ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "Notebooks"
}], "Title"],

Cell["A few examples of the power of notebook programming", "Subtitle"],

Cell[CellGroupData[{

Cell["Creating a Notebook", "Section"],

Cell["This creates a new notebook.", "Commentary"],

Cell[BoxData[
    \(\(nb = NotebookCreate[]; \)\)], "Input"],

Cell["This writes an input cell into a notebook.", "Commentary"],

Cell[BoxData[
    \(NotebookWrite[nb, Cell["\<1000!\>", "\<Input\>"]]\)], "Input"],

Cell["This moves the selection to be the whole notebook.", "Commentary"],

Cell[BoxData[
    \(SelectionMove[nb, All, Notebook]\)], "Input"],

Cell["This evaluates the selection.", "Commentary"],

Cell[BoxData[
    \(SelectionEvaluateCreateCell[nb]\)], "Input"],

Cell["This moves before the current cell.", "Commentary"],

Cell[BoxData[
    \(SelectionMove[nb, Before, Cell]\)], "Input"],

Cell["This finds the first 30 occurrences of 5 in the notebook.", "Commentary"],

Cell[BoxData[
    \(Do[NotebookFind[nb, "\<5\>"], {30}]\)], "Input"],

Cell["This closes the notebook.", "Commentary"],

Cell[BoxData[
    \(NotebookClose[nb]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Generating a Notebook of Usage Messages", "Section"],

Cell["Here is the definition.", "Commentary"],

Cell[BoxData[
    \(UsageNotebook[cmds : {__String}]\  := 
      NotebookPut[
        Notebook[
          Flatten[\({Cell[#, "\<Section\>"], 
                  Cell[\(MessageName[#, "\<usage\>"]&\)[ToExpression[#]], 
                    "\<Text\>"]}&\)/@cmds], 
          StyleDefinitions \[Rule] "\<Report.nb\>"]]\)], "Input"],

Cell["\<\
Running this will create a new notebook containing messages for all \
functions whose names start with Li.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(UsageNotebook[Names["\<Li*\>"]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM32410485", 1, 1]], 32],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Here is another function which writes cells directly into the \
current notebook.\
\>", "Commentary"],

Cell[BoxData[
    \(UsageCells[cmds : {__String}]\  := 
      Scan[\((StylePrint[#, "\<Subsection\>"]; 
            StylePrint[\(MessageName[#, "\<usage\>"]&\)[ToExpression[#]], 
              "\<Text\>"])\)&, cmds]\)], "Input"],

Cell["\<\
Running this will insert new cells into the current notebook.\
\>", 
  "Commentary"],

Cell[BoxData[
    \(UsageCells[Names["\<Abo*\>"]]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Notebooks That Change Form", "Section"],

Cell[CellGroupData[{

Cell["A Notebook That Changes Color", "Subsection"],

Cell["This puts a small notebook up on the screen.", "Commentary"],

Cell[BoxData[
    \(\(nb = 
      NotebookPut[
        Notebook[{Cell["\<Watch Me!\>", "\<Section\>"]}, 
          WindowTitle \[Rule] "\<A Changing Window\>", 
          WindowSize \[Rule] {160, 160}]]; \)\)], "Input"],

Cell["Executing this makes the notebook cyclically change color.", 
  "Commentary"],

Cell[BoxData[
    \(Do[SetOptions[nb, Background \[Rule] Hue[Mod[t, 1], .5]], {t, 0., 
        4., .1}]\)], "Input"],

Cell["This closes the notebook.", "Commentary"],

Cell[BoxData[
    \(NotebookClose[nb]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["A Notebook That Pulsates", "Subsection"],

Cell["This puts a notebook up on the screen.", "Commentary"],

Cell[BoxData[
    \(\(nb = 
      NotebookCreate[WindowTitle \[Rule] "\<A Pulsating Window\>", 
        WindowSize \[Rule] {240, 240}, Background \[Rule] Hue[.3  .5]]; \)\)],
   "Input"],

Cell["This makes the edges of the notebook pulsate. ", "Commentary"],

Cell[BoxData[
    \(Do[SetOptions[nb, 
        WindowSize \[Rule] N[100 \((2.4 + {Sin[t\/10], Sin[t\/15]})\)]], {t, 
        40}]\)], "Input"],

Cell["This closes the notebook.", "Commentary"],

Cell[BoxData[
    \(NotebookClose[nb]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["A Notebook That Walks around the Screen", "Subsection"],

Cell["This creates a small new notebook.", "Commentary"],

Cell[BoxData[
    \(\(nb = 
      NotebookPut[
        Notebook[{Cell["\<Follow Me!\>", "\<Section\>"]}, 
          Background \[Rule] Hue[.3, .5], 
          WindowTitle \[Rule] "\<A Moving Window\>", 
          WindowSize \[Rule] {160, 75}]]; \)\)], "Input"],

Cell["\<\
Evaluating this will make the notebook execute 100 steps in a \
random walk on the screen.\
\>", "Commentary"],

Cell[BoxData[
    \(Do[SetOptions[nb, 
        First[Map[If[NumberQ[#], # + Random[Real, {\(-40\), 40}], #]&, 
            Options[nb, WindowMargins], {\(-1\)}]]], {100}]\)], "Input"],

Cell["This closes the notebook.", "Commentary"],

Cell[BoxData[
    \(NotebookClose[nb]\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{},
WindowSize->{446, 329},
WindowMargins->{{4, Automatic}, {Automatic, 5}},
StyleDefinitions -> "Demo.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 15114, 191, 34, 14934, 185, "GraphicsData", "Bitmap", "Text"],
Cell[16826, 242, 114, 5, 81, "Title"],
Cell[16943, 249, 71, 0, 21, "Subtitle"],

Cell[CellGroupData[{
Cell[17039, 253, 38, 0, 72, "Section"],
Cell[17080, 255, 50, 0, 25, "Commentary"],
Cell[17133, 257, 60, 1, 34, "Input"],
Cell[17196, 260, 64, 0, 25, "Commentary"],
Cell[17263, 262, 82, 1, 34, "Input"],
Cell[17348, 265, 72, 0, 25, "Commentary"],
Cell[17423, 267, 65, 1, 34, "Input"],
Cell[17491, 270, 51, 0, 25, "Commentary"],
Cell[17545, 272, 64, 1, 34, "Input"],
Cell[17612, 275, 57, 0, 25, "Commentary"],
Cell[17672, 277, 64, 1, 34, "Input"],
Cell[17739, 280, 79, 0, 25, "Commentary"],
Cell[17821, 282, 68, 1, 34, "Input"],
Cell[17892, 285, 47, 0, 25, "Commentary"],
Cell[17942, 287, 50, 1, 34, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[18029, 293, 58, 0, 63, "Section"],
Cell[18090, 295, 45, 0, 25, "Commentary"],
Cell[18138, 297, 327, 7, 134, "Input"],
Cell[18468, 306, 136, 3, 40, "Commentary"],

Cell[CellGroupData[{
Cell[18629, 313, 64, 1, 34, "Input"],
Cell[18696, 316, 238, 6, 48, "Output"]
}, Open  ]],
Cell[18949, 325, 111, 3, 40, "Commentary"],
Cell[19063, 330, 228, 4, 114, "Input"],
Cell[19294, 336, 94, 3, 25, "Commentary"],
Cell[19391, 341, 62, 1, 34, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[19490, 347, 54, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[19569, 351, 51, 0, 39, "Subsection"],
Cell[19623, 353, 66, 0, 25, "Commentary"],
Cell[19692, 355, 219, 5, 94, "Input"],
Cell[19914, 362, 83, 1, 25, "Commentary"],
Cell[20000, 365, 116, 2, 74, "Input"],
Cell[20119, 369, 47, 0, 25, "Commentary"],
Cell[20169, 371, 50, 1, 34, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[20256, 377, 46, 0, 33, "Subsection"],
Cell[20305, 379, 60, 0, 25, "Commentary"],
Cell[20368, 381, 186, 4, 94, "Input"],
Cell[20557, 387, 68, 0, 25, "Commentary"],
Cell[20628, 389, 142, 3, 90, "Input"],
Cell[20773, 394, 47, 0, 25, "Commentary"],
Cell[20823, 396, 50, 1, 34, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[20910, 402, 61, 0, 33, "Subsection"],
Cell[20974, 404, 56, 0, 25, "Commentary"],
Cell[21033, 406, 260, 6, 114, "Input"],
Cell[21296, 414, 120, 3, 40, "Commentary"],
Cell[21419, 419, 183, 3, 94, "Input"],
Cell[21605, 424, 47, 0, 25, "Commentary"],
Cell[21655, 426, 50, 1, 34, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

