(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     68257,       2971]*)
(*NotebookOutlinePosition[     69145,       3001]*)
(*  CellTagsIndexPosition[     69101,       2997]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Introduction to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Lists"
}], "Title"],

Cell["- George Beck, 8/19/99", "Subsubtitle"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell["\<\
My plan for this talk was to use the Help Browser for all the nifty Further \
Examples that so many developers have helped to write. That would save me \
from typing and was going to be the way to organize my talk. But things \
started happening and I only remembered to look at the browser every once in \
a while. As a consequence, I skipped some fundamental operations, certainly \
making this talk incomplete. If you want to learn about lists, though, I \
think that browsing through the Further Examples is still a pretty good way \
to do it. \
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Four problems", "Section"],

Cell["\<\
Our goal is to be able to construct the following by the end of today's talk. \
Keep these problems in mind as we go through the talk.\
\>", "Text"],

Cell[CellGroupData[{

Cell["problem 1", "Subsection"],

Cell[BoxData[
    \({a, 0, a, 0, a, 0, a, 0, a}\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["problem 2", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, a, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}} // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["What if one of the lists had one less element?", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}} // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({a, 0, 0, 0}\)},
            {\({0, 0, 0}\)},
            {\({0, 0, a, 0}\)},
            {\({0, 0, 0, a}\)}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{a, 0, 0, 0}, {0, 0, 0}, {0, 0, a, 0}, {0, 0, 0, 
        a}}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Compare ",
  StyleBox["TableForm", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}} // 
      TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"a", "0", "0", "0"},
          {"0", "0", "0", "\<\"\"\>"},
          {"0", "0", "a", "0"},
          {"0", "0", "0", "a"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{a, 0, 0, 0}, {0, 0, 0}, {0, 0, a, 0}, {0, 0, 0, 
        a}}]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["problem 3", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{0, 0, 0, a}, {0, 0, a, 0}, {0, a, 0, 0}, {a, 0, 0, 0}} // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "0", "0", "a"},
            {"0", "0", "a", "0"},
            {"0", "a", "0", "0"},
            {"a", "0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["problem 4", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, 0, 0, 0}, {b, a, 0, 0}, {0, b, a, 0}, {0, 0, b, a}} // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"b", "a", "0", "0"},
            {"0", "b", "a", "0"},
            {"0", "0", "b", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["What is a list?", "Section"],

Cell[TextData[{
  "Go to the Help Browser and under the Built-in Functions, find the entry \
for ",
  StyleBox["List", "MR"],
  ". The Further Examples are at the bottom."
}], "Text"],

Cell["\<\
Lists collect objects. A list starts with a brace and ends with a brace. What \
better list to start with than the empty list? \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({}\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell["\<\
The entries (or components, or arguments, or parts) are separated by commas. \
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c}\)], "Input"],

Cell[BoxData[
    \({a, b, c}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "If you forget an argument, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calls the empty thing that should be there ",
  StyleBox["Null", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, , c}\)], "Input"],

Cell[BoxData[
    \({a, Null, c}\)], "Output"]
}, Open  ]],

Cell["\<\
Lists don't do much. They sit there and hold things. They are interesting \
because there are many functions that work on lists. That's what this talk is \
about. \
\>", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will do what it can to the entries inside the list, though. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1 + 2, 2, 3}\)], "Input"],

Cell[BoxData[
    \({3, 2, 3}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " would add 1 + 2 anywhere, so ",
  StyleBox["List", "MR"],
  " isn't responsible for that. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 + 2\)], "Input"],

Cell[BoxData[
    \(3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "You can put numbers, functions (including ",
  StyleBox["List", "MR"],
  "!), strings, or even another list into a list. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({5440, List, Reverse, Plot, "\<I am George\>", {a, b, c}}\)], "Input"],

Cell[BoxData[
    \({5440, List, Reverse, Plot, "I am George", {a, b, c}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Recall that % means the previous result. The quotes around a string get \
dropped in output, but you can see they are still there by using ",
  StyleBox["FullForm", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[5440, List, Reverse, Plot, "\<I am George\>", 
          List[a, b, c]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["FullForm", "MR"],
  " of a list starts with ",
  StyleBox["List", "MR"],
  " \[LongDash] that's the head of the expression \[LongDash] and the \
arguments are enclosed in square brackets. Notice that applying ",
  StyleBox["FullForm,", "MR"],
  " we wrap the argument % with square brackets. That's how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions are applied. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{1, 23}]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[1, 23]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Braces are used instead of the ",
  StyleBox["FullForm", "MR"],
  " way because lists are so common. Other cases like that are sums, powers, \
and products. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a + 1\)], "Input"],

Cell[BoxData[
    \(1 + a\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[1 + a]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, a]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[x\^2]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[x, 2]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[this\ is\ a\ multiplication]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[a, is, multiplication, this]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "I entered the power in ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  " with Ctrl-^. You can enter it as InputForm with x^2, but the default \
output is in StandardForm. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x^2\)], "Input"],

Cell[BoxData[
    \(x\^2\)], "Output"]
}, Open  ]],

Cell["\<\
What if you do FullForm on a FullForm?
That is not particularly interesting. \
\>", "Text"],

Cell["\<\
What is the relationship between FullForm, StandardForm, and TraditionalForm?
Sorry, that topic doesn't belong in this talk. We have a time crunch. \
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["What are lists used for?", "Section"],

Cell["\<\
Lists allow you to get more than one result out of a function. For instance, \
you get all the solutions of an equation in a list. \
\>", "Text"],

Cell[TextData[{
  "Let's look up ",
  StyleBox["Solve", "MR"],
  ". Type it in and hit F1 to go to the Help Browser. "
}], "Text"],

Cell[BoxData[
    \(Solve\)], "Input"],

Cell["\<\
Let's copy this solution to the quadratic equation we see there. You can get \
two possible answers. \
\>", "Text"],

Cell[BoxData[
    \({{x \[Rule] \(-b\) - \@\(b\^2 - c\)}, {x \[Rule] \(-b\) + \@\(b\^2 - \
c\)}}\)], "Input"],

Cell["Why so many braces?  Why isn't it simpler, like this? ", "Text"],

Cell[BoxData[
    \({x \[Rule] \(-b\) - \@\(b\^2 - c\), 
      x \[Rule] \(-b\) + \@\(b\^2 - c\)}\)], "Input"],

Cell[TextData[{
  "Well, if we had two variables to solve for, we'd have two ",
  StyleBox["sets",
    FontSlant->"Italic"],
  " of solutions. The list entries are the different sets of solutions. Each \
sublist has one entry per variable. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{2  x^2 + y \[Equal] 10, x^2 - y \[Equal] 2}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({{y \[Rule] 2, x \[Rule] \(-2\)}, {y \[Rule] 2, 
        x \[Rule] 2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["List", "MR"],
  " provides a way for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to provide multiple answers. Some other languages cannot provide multiple \
answers as conveniently."
}], "Text"],

Cell[TextData[{
  "Look at how lists are used to gather up the iterator notation for ",
  StyleBox["Table", "MR"],
  " in the next section. "
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Building lists", "Section"],

Cell[TextData[{
  "Let's go back to the Help Browser to look at ",
  StyleBox["Range", "MR"],
  ". ",
  StyleBox["Range", "MR"],
  " is a fast way to build lists. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[12]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[120]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 
      120}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[1]\)], "Input"],

Cell[BoxData[
    \({1}\)], "Output"]
}, Open  ]],

Cell["Aha! The empty list again. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[0]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Length", "MR"],
  " counts the number of items in a list. ",
  StyleBox["Length[Range[n]]", "MR"],
  " is ",
  StyleBox["n", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Range[120]]\)], "Input"],

Cell[BoxData[
    \(120\)], "Output"]
}, Open  ]],

Cell["\<\
If you want to start at something other than 1, give the starting and ending \
values. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[4, 12]\)], "Input"],

Cell[BoxData[
    \({4, 5, 6, 7, 8, 9, 10, 11, 12}\)], "Output"]
}, Open  ]],

Cell["\<\
The third argument is the step size. The next number would be 13, but it is \
bigger than 12 so it isn't put in. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[4, 12, 3]\)], "Input"],

Cell[BoxData[
    \({4, 7, 10}\)], "Output"]
}, Open  ]],

Cell["\<\
This is copied from the Further Examples. It shows lists of lists can be \
staggered by iterating up to another iterator.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Binomial[i, j], {i, 0, 8}, {j, 0, i}]\)], "Input"],

Cell[BoxData[
    \({{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 5, 10, 10, 
        5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 1}, {1, 8, 
        28, 56, 70, 56, 28, 8, 1}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Notice how lists are used to group the iterator notation in ",
  StyleBox["Table", "MR"],
  ". \n\nExcept for the explicit iterator variable at the beginning of the \
list (",
  StyleBox["i ", "MR"],
  "in the table here), the remaining entries are like the arguments of ",
  StyleBox["Range", "MR"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {"notation", "start", "end", "step"},
        {\({i, n}\), "1", "n", "1"},
        {\({i, m, n}\), "m", "n", "1"},
        {\({i, m, n, s}\), "m", "n", "s"}
        }]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Table[Binomial[i, j], {i, 0, 8}, {j, 0, i}]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
          {"1", "2", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
          {"1", "3", "3", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "4", "6", "4", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "5", "10", "10", "5", 
            "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {"1", "6", "15", "20", "15", "6", "1", "\<\"\"\>", "\<\"\"\>"},
          {"1", "7", "21", "35", "35", "21", "7", "1", "\<\"\"\>"},
          {"1", "8", "28", "56", "70", "56", "28", "8", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 
        5, 10, 10, 5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 
        1}, {1, 8, 28, 56, 70, 56, 28, 8, 1}}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[Table[Binomial[i, j], {i, 0, 8}, {j, 0, i}]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({1}\)},
            {\({1, 1}\)},
            {\({1, 2, 1}\)},
            {\({1, 3, 3, 1}\)},
            {\({1, 4, 6, 4, 1}\)},
            {\({1, 5, 10, 10, 5, 1}\)},
            {\({1, 6, 15, 20, 15, 6, 1}\)},
            {\({1, 7, 21, 35, 35, 21, 7, 1}\)},
            {\({1, 8, 28, 56, 70, 56, 28, 8, 1}\)}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 
        5, 10, 10, 5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 
        1}, {1, 8, 28, 56, 70, 56, 28, 8, 1}}]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The solution to problem 2", "Section"],

Cell["\<\
Let's solve one of the problems from the top of this notebook. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, a, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}} // 
      TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "0", "0", "0"},
          {"0", "a", "0", "0"},
          {"0", "0", "a", "0"},
          {"0", "0", "0", "a"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Let's skip ",
  StyleBox["Array,", "MR"],
  " which is next in the Help Browser. We're looking at ",
  StyleBox["IdentityMatrix", "MR"],
  ", famous as the analogue of the number 1 in linear algebra. ",
  StyleBox["IdentityMatrix", "MR"],
  " puts a diagonal of ones into a square matrix of zeros. Multiplying by ",
  StyleBox["a", "MR"],
  " gives ",
  StyleBox["a", "MR"],
  "s on the diagonal. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ IdentityMatrix[4] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Be careful with ",
  StyleBox["MatrixForm", "MR"],
  "; it can get in the way when applied as an afterthought with //. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4 = a\ IdentityMatrix[4] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["i4", "MR"],
  " looks okay, but appearances are deceiving. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
We expect that when we add 1000 to a matrix, it will get added to all the \
entries.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ IdentityMatrix[4] + 1000 // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(1000 + a\), "1000", "1000", "1000"},
            {"1000", \(1000 + a\), "1000", "1000"},
            {"1000", "1000", \(1000 + a\), "1000"},
            {"1000", "1000", "1000", \(1000 + a\)}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "But ",
  StyleBox["MatrixForm", "MR"],
  " is interfering with that, as you can see when we try it on ",
  StyleBox["i4.", "MR"],
  " "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4 + 1000\)], "Input"],

Cell[BoxData[
    RowBox[{"1000", "+", 
      TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
              {"a", "0", "0", "0"},
              {"0", "a", "0", "0"},
              {"0", "0", "a", "0"},
              {"0", "0", "0", "a"}
              }], "\[NoBreak]", ")"}],
        (MatrixForm[ #]&)]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1000, 
          MatrixForm[
            List[List[a, 0, 0, 0], List[0, a, 0, 0], List[0, 0, a, 0], 
              List[0, 0, 0, a]]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Let's redefine ",
  StyleBox["i4", "MR"],
  " using parentheses for grouping. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((i4 = a\ IdentityMatrix[4])\) // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["That's better. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4 + 1000 // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(1000 + a\), "1000", "1000", "1000"},
            {"1000", \(1000 + a\), "1000", "1000"},
            {"1000", "1000", \(1000 + a\), "1000"},
            {"1000", "1000", "1000", \(1000 + a\)}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The reason 1000 gets added to each entry of a nested list (like the matrix \
here) is that first it gets added to each of the four parts. Then it goes \
down into the next level. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, a, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1000 + {a, 0, 0, 0}\)], "Input"],

Cell[BoxData[
    \({1000 + a, 1000, 1000, 1000}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(i4 + 1000\)], "Input"],

Cell[BoxData[
    \({{1000 + a, 1000, 1000, 1000}, {1000, 1000 + a, 1000, 1000}, {1000, 
        1000, 1000 + a, 1000}, {1000, 1000, 1000, 1000 + a}}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Listable versus Map", "Section"],

Cell[TextData[{
  "Arithmetic operations and numerical functions go down into the entries. \
They are ",
  StyleBox["Listable", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1. , 2. , 3. } + 100\)], "Input"],

Cell[BoxData[
    \({101.`, 102.`, 103.`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3}^2\)], "Input"],

Cell[BoxData[
    \({1, 4, 9}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[{1. , 2. , 3. }]\)], "Input"],

Cell[BoxData[
    \({0.8414709848078965`, 0.9092974268256817`, 
      0.1411200080598672`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({Sin[1. ], Sin[2. ], Sin[3. ]}\)], "Input"],

Cell[BoxData[
    \({0.8414709848078965`, 0.9092974268256817`, 
      0.1411200080598672`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exp[{1. , 2. , 3. }]\)], "Input"],

Cell[BoxData[
    \({2.718281828459045`, 7.38905609893065`, 20.08553692318767`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({Exp[1. ], Exp[2. ], Exp[3. ]}\)], "Input"],

Cell[BoxData[
    \({2.718281828459045`, 7.38905609893065`, 20.08553692318767`}\)], "Output"]
}, Open  ]],

Cell["You can operate on lists as if they were numbers. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3}^2 + 100 + 100000 {1, 2, 3}\)], "Input"],

Cell[BoxData[
    \({100101, 200104, 300109}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Undefined functions, user-defined functions that aren't built up directly \
from ",
  StyleBox["Listable", "MR"],
  " functions, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " built-in functions without the attribute ",
  StyleBox["Listable", "MR"],
  " don't go down to hit the entries of a list. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[{1. , 2. , 3. }]\)], "Input"],

Cell[BoxData[
    \(f[{1.`, 2.`, 3.`}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Point[{1. , 2. , 3. }]\)], "Input"],

Cell[BoxData[
    \(Point[{1.`, 2.`, 3.`}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Listable\)\)], "Input"],

Cell[BoxData[
    \("Listable is an attribute that can be assigned to a symbol f to \
indicate that the function f should automatically be threaded over lists that \
appear as its arguments."\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "Let's ask for information on ",
  StyleBox["Exp", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Exp\)\)], "Input"],

Cell[BoxData[
    \("Exp[z] is the exponential function."\)], "Print"]
}, Open  ]],

Cell["\<\
I need a little more, so I add another question mark. See the first \
attribute? \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(?? Exp\)], "Input"],

Cell[BoxData[
    \("Exp[z] is the exponential function."\)], "Print"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(Attributes[Exp] = {Listable, NumericFunction, Protected, 
                ReadProtected}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ Exp],
      Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
  "I can force ",
  StyleBox["f", "MR"],
  " to be Listable. "
}], "Text"],

Cell[BoxData[
    \(SetAttributes[f, Listable]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(?? f\)], "Input"],

Cell[BoxData[
    \("Global`f"\)], "Print"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(Attributes[f] = {Listable}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
  "See?  ",
  StyleBox["f", "MR"],
  " goes inside lists now. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[{1. , 2. , 3. }]\)], "Input"],

Cell[BoxData[
    \({f[1.`], f[2.`], f[3.`]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Here's a more temporary way. ",
  StyleBox["g", "MR"],
  ", like ",
  StyleBox["f ", "MR"],
  "was, is not ",
  StyleBox["Listable", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \(g[{1, 2, 3}]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " makes ",
  StyleBox["g", "MR"],
  " run through the list as if it were ",
  StyleBox["Listable", "MR"],
  ". ",
  StyleBox["Map", "MR"],
  " makes a function infiltrate a list, you might say. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[g, {1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({g[1], g[2], g[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "But ",
  StyleBox["g", "MR"],
  " needs ",
  StyleBox["Map", "MR"],
  " to do it. ",
  StyleBox["g", "MR"],
  " is still not ",
  StyleBox["Listable", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \(g[{1, 2, 3}]\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["What can we map?", "Section"],

Cell[TextData[{
  "Someone asked what happens when I map ",
  StyleBox["List", "MR"],
  " onto something. It depends on what the something is. "
}], "Text"],

Cell[TextData[{
  "It doesn't make much sense to map ",
  StyleBox["List", "MR"],
  " onto a scalar. (A scalar is another word for a number.) Nothing happens \
because a number doesn't have entries. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[100]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["100",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[List, 100]\)], "Input"],

Cell[BoxData[
    \(100\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Mapping ",
  StyleBox["List", "MR"],
  " onto a list is fine. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[List, {a, b, c}]\)], "Input"],

Cell[BoxData[
    \({{a}, {b}, {c}}\)], "Output"]
}, Open  ]],

Cell["\<\
Usually, you map functions onto objects that have a structure. The structure \
doesn't have to be a list. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Sin, SomeHead[a, b, c]]\)], "Input"],

Cell[BoxData[
    \(SomeHead[Sin[a], Sin[b], Sin[c]]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "You can't meaningfully ",
  StyleBox["Map", "MR"],
  " an object like a number or a list {a,b,c}, but it works. It looks \
backwards, but ",
  StyleBox["10[Sin]", "MR"],
  " might have its uses. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[10, {a, b, c}]\)], "Input"],

Cell[BoxData[
    \({10[a], 10[b], 10[c]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Here we ",
  StyleBox["Map", "MR"],
  " a function onto something that is not a list, namely a polynomial. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, x^2 + 2  x + 1]\)], "Input"],

Cell[BoxData[
    \(f[1] + f[2\ x] + f[x\^2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Unfortunately, this fails when the polynomial has only one term. (We want \
",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[2  x]\),
          "MR"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x\^2]\),
          "MR"], TraditionalForm]]],
  " as it was when there were three terms.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, 2  x]\)], "Input"],

Cell[BoxData[
    \(f[2]\ f[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, x^2]\)], "Input"],

Cell[BoxData[
    \(f[x]\^f[2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " has a nice Further Example that fixes this problem. The function defined \
there is called ",
  StyleBox["PlusMap", "MR"],
  ". Take a look. "
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Join and DiagonalMatrix", "Section"],

Cell[TextData[{
  "Someone asked how to join up two lists. Use ",
  StyleBox["Join", "MR"],
  ". Look up ",
  StyleBox["Union", "MR"],
  ", too. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Join[{1, 2}, {3, 4, 5}]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DiagonalMatrix", "MR"],
  " is similar to ",
  StyleBox["IdentityMatrix", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[{{a, 0, 0, 0}, {0, b, 0, 0}, {0, 0, c, 0}, {0, 0, 0, 
          d}}]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "b", "0", "0"},
            {"0", "0", "c", "0"},
            {"0", "0", "0", "d"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[DiagonalMatrix[{a, b, c, d}]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "b", "0", "0"},
            {"0", "0", "c", "0"},
            {"0", "0", "0", "d"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The solution to problem 1, interrupted", "Section"],

Cell["We wanted to construct this without having to type it in. ", "Text"],

Cell[BoxData[
    \({a, 0, a, 0, a, 0, a, 0, a}\)], "Input"],

Cell["Let's start with something else.", "Text"],

Cell[BoxData[
    \({a, a, a, a, a, a, a, a}\)], "Input"],

Cell["Here are two ways. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[a, {i, 12}]\)], "Input"],

Cell[BoxData[
    \({a, a, a, a, a, a, a, a, a, a, a, a}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[12]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(1^Range[12]\)], "Input"],

Cell[BoxData[
    \({1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ 1^Range[12]\)], "Input"],

Cell[BoxData[
    \({a, a, a, a, a, a, a, a, a, a, a, a}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This happened when I added ",
  StyleBox["a", "MR"],
  " to the beginning of ",
  StyleBox["1^Range[12]", "MR"],
  " without adding a space. ",
  StyleBox["a1", "MR"],
  " is a variable. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a1^Range[12]\)], "Input"],

Cell[BoxData[
    \({a1, a1\^2, a1\^3, a1\^4, a1\^5, a1\^6, a1\^7, a1\^8, a1\^9, a1\^10, 
      a1\^11, a1\^12}\)], "Output"]
}, Open  ]],

Cell["We'll come back to problem 1 after a short interruption. ", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Many simple functions", "Section"],

Cell[TextData[{
  "I want to show you a bunch of functions, so let's construct a 4 by 4 \
matrix. (I am skipping the next built-in function in the Help Browser, ",
  StyleBox["Part", "MR"],
  "; please look it up.) Let's start with a square number of entries. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[16]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Partition", "MR"],
  " is a way to get a matrix. Here's the matrix. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(my16 = Partition[Range[16], 4]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15, 
        16}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4"},
          {"5", "6", "7", "8"},
          {"9", "10", "11", "12"},
          {"13", "14", "15", "16"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Examine the following sequence of list gymnastics carefully. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[my16]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Last[my16]\)], "Input"],

Cell[BoxData[
    \({13, 14, 15, 16}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rest[my16] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"5", "6", "7", "8"},
          {"9", "10", "11", "12"},
          {"13", "14", "15", "16"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[my16, 1] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"5", "6", "7", "8"},
          {"9", "10", "11", "12"},
          {"13", "14", "15", "16"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[my16, 2] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4"},
          {"5", "6", "7", "8"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["Minuses mean work from the end. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[my16, \(-1\)] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4"},
          {"5", "6", "7", "8"},
          {"9", "10", "11", "12"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[my16, \(-3\)] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"5", "6", "7", "8"},
          {"9", "10", "11", "12"},
          {"13", "14", "15", "16"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Select", "MR"],
  " and ",
  StyleBox["Cases", "MR"],
  " are a little more complicated; ",
  StyleBox["Cases", "MR"],
  " uses patterns. Let's skip them, even though they are very useful. "
}], "Text"],

Cell[TextData[{
  "Now let's move on to other ",
  StyleBox["List", "MR"],
  " operations. One of my favorites is ",
  StyleBox["Reverse", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[Range[13]]\)], "Input"],

Cell[BoxData[
    \({13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[my16] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"13", "14", "15", "16"},
          {"9", "10", "11", "12"},
          {"5", "6", "7", "8"},
          {"1", "2", "3", "4"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Recall the function ",
  StyleBox["Map", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, {a, b, c}]\)], "Input"],

Cell[BoxData[
    \({f[a], f[b], f[c]}\)], "Output"]
}, Open  ]],

Cell["Try to understand each of the following. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Reverse, my16] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"4", "3", "2", "1"},
          {"8", "7", "6", "5"},
          {"12", "11", "10", "9"},
          {"16", "15", "14", "13"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[Map[Reverse, my16]] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"16", "15", "14", "13"},
          {"12", "11", "10", "9"},
          {"8", "7", "6", "5"},
          {"4", "3", "2", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Reverse[Range[16]], 4] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"16", "15", "14", "13"},
          {"12", "11", "10", "9"},
          {"8", "7", "6", "5"},
          {"4", "3", "2", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The solution to  problem 3", "Section"],

Cell["This solves problem 3. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ Reverse[IdentityMatrix[4]] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "0", "0", "a"},
            {"0", "0", "a", "0"},
            {"0", "a", "0", "0"},
            {"a", "0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Three solutions to problem 1", "Section"],

Cell[CellGroupData[{

Cell["solution 1", "Subsection"],

Cell[TextData[{
  StyleBox["Flatten", "MR"],
  " is the opposite or inverse of ",
  StyleBox["Partition", "MR"],
  ". It destroys structure by getting rid of braces. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[{{a, 0}, {a, 0}, {a, 0}}]\)], "Input"],

Cell[BoxData[
    \({a, 0, a, 0, a, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[{a, 0}, {4}]\)], "Input"],

Cell[BoxData[
    \({{a, 0}, {a, 0}, {a, 0}, {a, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[%]\)], "Input"],

Cell[BoxData[
    \({a, 0, a, 0, a, 0, a, 0}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["solution 2", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ 1^Range[12]\)], "Input"],

Cell[BoxData[
    \({a, a, a, a, a, a, a, a, a, a, a, a}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This uses substitution. We replace ",
  StyleBox["a", "MR"],
  " by {",
  StyleBox["a, 0", "MR"],
  "} and then ",
  StyleBox["Flatten", "MR"],
  ". (The slash-dot notation /. stands for ",
  StyleBox["ReplaceAll", "MR"],
  ".) "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ 1^Range[12] /. a \[Rule] {a, 0}\)], "Input"],

Cell[BoxData[
    \({{a, 0}, {a, 0}, {a, 0}, {a, 0}, {a, 0}, {a, 0}, {a, 0}, {a, 0}, {a, 
        0}, {a, 0}, {a, 0}, {a, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[%]\)], "Input"],

Cell[BoxData[
    \({a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 0, a, 
      0}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["solution 3a", "Subsection"],

Cell["Here is a more mathematical solution. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\(-1\))\)^Range[12]\)], "Input"],

Cell[BoxData[
    \({\(-1\), 1, \(-1\), 1, \(-1\), 1, \(-1\), 1, \(-1\), 1, \(-1\), 
      1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\(-1\))\)^Range[12] + 1\)], "Input"],

Cell[BoxData[
    \({0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. \ 2 \[Rule] a\)], "Input"],

Cell[BoxData[
    \({0, a, 0, a, 0, a, 0, a, 0, a, 0, a}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["solution 3b", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\((\(-1\))\)^Range[12] + 1)\)/2\)], "Input"],

Cell[BoxData[
    \({0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ %\)], "Input"],

Cell[BoxData[
    \({0, a, 0, a, 0, a, 0, a, 0, a, 0, a}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["What is Apply?", "Section"],

Cell[TextData[{
  StyleBox["Apply", "MR"],
  " switches in the head of an expression, as if you were copying and
pasting. \
It \"recapitates\" or \"reheads\" an expression. It might have been called ",
  StyleBox["ReplaceHead", "MR"],
  ". \n\nThe ",
  StyleBox["Head", "MR"],
  " of a list is ",
  StyleBox["List", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[1, 2, 3]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "You don't see it without ",
  StyleBox["FullForm", "MR"],
  ", but the head of a sum is ",
  StyleBox["Plus", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a + b + c\)], "Input"],

Cell[BoxData[
    \(a + b + c\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[a + b + c]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Open  ]],

Cell["Here are heads you do see.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[b, x]\)], "Input"],

Cell[BoxData[
    \(f[b, x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[newhead, oldhead[arguments]]\)], "Input"],

Cell[BoxData[
    \(newhead[arguments]\)], "Output"]
}, Open  ]],

Cell["\<\
You can write the list and the sum showing their heads, but they disappear on \
evaluation. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      StyleBox[\(List[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Input"],

Cell[BoxData[
    \({a, b, c}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, 2, 3]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Input"],

Cell[BoxData[
    \(6\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This replaces the head ",
  StyleBox["Plus", "MR"],
  " with the head ",
  StyleBox["List", "MR"],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, {1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \(6\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This replaces the head ",
  StyleBox["List", "MR"],
  " with the head ",
  StyleBox["Plus", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[List, a + b + c]\)], "Input"],

Cell[BoxData[
    \({a, b, c}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This changes the head ",
  StyleBox["Plus", "MR"],
  " from ",
  StyleBox["Power ", "MR"],
  "to ",
  StyleBox["Plus", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, x\^2]\)], "Input"],

Cell[BoxData[
    \(2 + x\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Anonymous solutions to problem 4", "Section"],

Cell[TextData[{
  "More than a dozen different solutions were sent in following the talk. You \
can become a good beginner at ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming by studying them to understand how they work. If you don't \
understand a built-in function, look in the Further Examples under Built-in \
Functions. \n\nThe problem was to construct this banded matrix. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}} // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"b", "0", "0", "0"},
            {"a", "b", "0", "0"},
            {"0", "a", "b", "0"},
            {"0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["a student", "Subsection"],

Cell[TextData[{
  "The ",
  StyleBox["ReplacePart", "MR"],
  " section seems awfully long and cumbersome \[LongDash] do you have a\n\
better suggestion?"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IdentityMatrix[4]\)], "Input"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. \ 1 \[Rule] a\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, a, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"0", "a", "0", "0"},
            {"0", "0", "a", "0"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[%%]\)], "Input"],

Cell[BoxData[
    \({a, 0, 0, 0, 0, a, 0, 0, 0, 0, a, 0, 0, 0, 0, a}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[{a, 0, 0, 0, 0, a, 0, 0, 0, 0, a, 0, 0, 0, 0, a}, \ 
      b, \ {5, 10, 15}]\)], "Input"],

Cell[BoxData[
    \(ReplacePart::"partw" \(\(:\)\(\ \)\) 
      "Part \!\({5, 10, 15}\) of \!\({a, 0, 0, 0, 0, a, 0, 0, 0, 0, a, 0, 0, \
0, 0, a}\) does not exist."\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    \(ReplacePart[{a, 0, 0, 0, 0, a, 0, 0, 0, 0, a, 0, 0, 0, 0, a}, 
      b, {5, 10, 15}]\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[{a, 0, 0, 0, 0, a, 0, 0, 0, 0, a, 0, 0, 0, 0, a}, \ b, \ 
      5]\)], "Input"],

Cell[BoxData[
    \({a, 0, 0, 0, b, a, 0, 0, 0, 0, a, 0, 0, 0, 0, a}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[%, \ b, 10]\)], "Input"],

Cell[BoxData[
    \({a, 0, 0, 0, b, a, 0, 0, 0, b, a, 0, 0, 0, 0, a}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[%, b, 15]\)], "Input"],

Cell[BoxData[
    \({a, 0, 0, 0, b, a, 0, 0, 0, b, a, 0, 0, 0, b, a}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, 0, 0, 0, b, a, 0, 0, 0, b, a, 0, 0, 0, b, a}, \ 
      4]\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, 0}, {b, a, 0, 0}, {0, b, a, 0}, {0, 0, b, a}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["another student", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mya\  = \ a\ IdentityMatrix[4]\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, 0}, {0, a, 0, 0}, {0, 0, a, 0}, {0, 0, 0, a}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(myb\  = \ b\ IdentityMatrix[3]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0}, {0, b, 0}, {0, 0, b}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(myb\  = \ PadRight[myb, \ {3, 4}]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {0, b, 0, 0}, {0, 0, b, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(myb\  = Prepend[myb, \ Table[0, \ {i, \ 4}]]\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {b, 0, 0, 0}, {0, b, 0, 0}, {0, 0, b, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mya\  + \ myb\  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "0", "0", "0"},
            {"b", "a", "0", "0"},
            {"0", "b", "a", "0"},
            {"0", "0", "b", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["a beginner", "Subsection"],

Cell["This solution seems a bit verbose.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[
      Delete[Transpose[\[IndentingNewLine]NestList[RotateRight, 
            PadRight[{a, b}, 5], 3]\[IndentingNewLine]], 1]]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["another beginner", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PadRight[{a, b}, 4, 0, #] &\) /@ Range[\(-1\), 2]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["an intern", "Subsection"],

Cell[CellGroupData[{

Cell["solution 1", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
      ReplacePart[ReplacePart[{0, 0, 0, 0}, a, Fibonacci[i]], b, i], {i, 1, 
        4}]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["solution 2", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[
      Table[Which[x + y == 5, b, x + y == 4, a, 1 \[Equal] 1, 0\ ]\ \ , {x, 
          1, 4}, {y, 1, 4}]]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["an intermediate", "Subsection"],

Cell[CellGroupData[{

Cell["first try", "Subsubsection"],

Cell[TextData[{
  "First replace ",
  StyleBox["1", "MR"],
  " by {",
  StyleBox["a,b", "MR"],
  "} along the diagonal."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IdentityMatrix[4] /. \ 1 \[Rule] {a, b} // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\({a, b}\), "0", "0", "0"},
            {"0", \({a, b}\), "0", "0"},
            {"0", "0", \({a, b}\), "0"},
            {"0", "0", "0", \({a, b}\)}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["Get rid of the list in each row. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Flatten, %] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "b", "0", "0", "0"},
            {"0", "a", "b", "0", "0"},
            {"0", "0", "a", "b", "0"},
            {"0", "0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["Drop none of the rows, but drop the first column. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[%, None, 1] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"b", "0", "0", "0"},
            {"a", "b", "0", "0"},
            {"0", "a", "b", "0"},
            {"0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["Putting it together we get this. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[Map[Flatten, IdentityMatrix[4] /. \ 1 \[Rule] {a, b}], None, 1] // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"b", "0", "0", "0"},
            {"a", "b", "0", "0"},
            {"0", "a", "b", "0"},
            {"0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["a better way", "Subsubsection"],

Cell["Rotate an extended row over and over again by one position. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[RotateRight, {a, b, 0, 0, 0}, 3] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "b", "0", "0", "0"},
            {"0", "a", "b", "0", "0"},
            {"0", "0", "a", "b", "0"},
            {"0", "0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Get rid of the first column, in this case by taking all the rows and all but \
the first column. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[%, All, {2, 5}] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"b", "0", "0", "0"},
            {"a", "b", "0", "0"},
            {"0", "a", "b", "0"},
            {"0", "0", "a", "b"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["an expert", "Subsection"],

Cell[TextData[{
  "Constructing out of what \[LongDash] what's given? I'll assume {",
  StyleBox["a, b", "MR"],
  "} is given.Why the asymmetry? Change '-2' below to '-1' for symmetry."
}], "Text"],

Cell[TextData[{
  "[There are ",
  StyleBox["b", "MR"],
  "'s on the main diagonal, ",
  StyleBox["a", "MR"],
  "'s on the subdiagonal. It is symmetric about the other diagonal. \
\[LongDash] George]"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b}, 4, 1, {\(-2\), 1}, 0] // Reverse\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b}, 4, 1, {\(-1\), 1}, 0] // Reverse\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}, {0, 0, 0, 
        a}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"b", "0", "0", "0"},
            {"a", "b", "0", "0"},
            {"0", "a", "b", "0"},
            {"0", "0", "a", "b"},
            {"0", "0", "0", "a"}
            }], "\[NoBreak]", ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["another expert", "Subsection"],

Cell["\<\
Hi George, I really enjoyed your talk, especially the idea of just looking
  at the \"Further Examples\" section in order not to get confused. :)\
\>", "Text"],

Cell["\<\
Come on! That's not an easy problem! Using list operations makes it even more \
complicated, as I would usually attack these matrix construction problems \
with If statements. \
\>", "Text"],

Cell["Anyway, I came up with this solution:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[Partition[Flatten[Table[{b, Table[0, {4 - 1}], a}, {4}]], 4], 
      4]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "There are a couple of things I like about this solution: ",
  StyleBox["b", "MR"],
  " and ",
  StyleBox["a", "MR"],
  " (and ",
  StyleBox["0", "MR"],
  ") appear only once, and it can be used for any dimension by simply \
replacing the 4s by the dimension you want."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[Partition[Flatten[Table[{b, Table[0, {5 - 1}], a}, {5}]], 5], 
      5]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0, 0}, {a, b, 0, 0, 0}, {0, a, b, 0, 0}, {0, 0, a, b, 
        0}, {0, 0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["yet another expert", "Subsection"],

Cell[CellGroupData[{

Cell["solution 1", "Subsubsection"],

Cell["Here's a newfangled way to do it:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse@Partition[{a, b}, 4, 1, {3, 1}, 0]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["solution 2 and 3", "Subsubsection"],

Cell[TextData[{
  "Here are two more methods using new-age functions ",
  StyleBox["ListCorrelate", "MR"],
  " and ",
  StyleBox["PadLeft", "MR"],
  ", and one using only old-fashioned functions. I've used the following \
definitions to make it clear what parameters are used where in the new age \
functions, so that things don't appear quite so magical, and so that the \
reader can see how these might generalize."
}], "Text"],

Cell[BoxData[{
    \(\(main = {a, b};\)\), "\[IndentingNewLine]", 
    \(\(m = Length[main];\)\), "\[IndentingNewLine]", 
    \(\(k = 4;\)\)}], "Input"],

Cell[BoxData[
    \(\(kernel = Table[1, {k}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse@
      ListCorrelate[kernel, main, {\(-m\), 1}, 0, Times, List]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[PadLeft[main, k, 0, i], {i, k - 1, 0, \(-1\)}]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(padded = \(Join[#, main, #] &\)@Table[0, {k}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
      Take[padded, {i, i + \((k - 1)\)}], {i, k + m, 
        k + m - \((k - 1)\), \(-1\)}]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "If you want to see how ",
  StyleBox["ListCorrelate", "MR"],
  " or ",
  StyleBox["ListConvolve", "MR"],
  " lines up the the two lists in arguments 1 and 2, giving you a window view \
into the main list, then define these functions:"
}], "Text"],

Cell[BoxData[
    \(t[a_] := {MakeBoxes[
          a], "\<\[UpDownArrow]\>", "\<\[FilledSquare]\>"}\)], "Input"],

Cell[BoxData[
    \(t[a_, b_] := {MakeBoxes[a], "\<\[UpDownArrow]\>", 
        StyleBox[MakeBoxes[b], Background \[Rule] GrayLevel[0.8]]}\)], "Input"],

Cell[BoxData[
    \(p[columns__] := 
      DisplayForm@
        GridBox[Transpose[{columns}], GridFrame \[Rule] True, 
          ColumnLines \[Rule] True]\)], "Input"],

Cell["\<\
and then always specify them in arguments 5 and 6 (which forces you to use \
arguments 3 and 4, sorry). Do this in a front end and it'll help you \
visualize what's going on. It sure helped me.\
\>", "Text"],

Cell[BoxData[
    \( (*ListCorrelate[kernel, main, {kL, kR}, pad, t, p]*) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListCorrelate[kernel, main, {\(-m\), 1}, 0, t, p]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[GridBox[{
              {"1", "1", "1", "1"},
              {"\[UpDownArrow]", "\[UpDownArrow]", "\[UpDownArrow]", 
                "\[UpDownArrow]"},
              {
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["a",
                  Background->GrayLevel[0.8]], 
                StyleBox["b",
                  Background->GrayLevel[0.8]]}
              },
            GridFrame->True,
            ColumnLines->True],
          DisplayForm], ",", 
        TagBox[GridBox[{
              {"1", "1", "1", "1"},
              {"\[UpDownArrow]", "\[UpDownArrow]", "\[UpDownArrow]", 
                "\[UpDownArrow]"},
              {
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["a",
                  Background->GrayLevel[0.8]], 
                StyleBox["b",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]]}
              },
            GridFrame->True,
            ColumnLines->True],
          DisplayForm], ",", 
        TagBox[GridBox[{
              {"1", "1", "1", "1"},
              {"\[UpDownArrow]", "\[UpDownArrow]", "\[UpDownArrow]", 
                "\[UpDownArrow]"},
              {
                StyleBox["a",
                  Background->GrayLevel[0.8]], 
                StyleBox["b",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]]}
              },
            GridFrame->True,
            ColumnLines->True],
          DisplayForm], ",", 
        TagBox[GridBox[{
              {"1", "1", "1", "1"},
              {"\[UpDownArrow]", "\[UpDownArrow]", "\[UpDownArrow]", 
                "\[UpDownArrow]"},
              {
                StyleBox["b",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]], 
                StyleBox["0",
                  Background->GrayLevel[0.8]]}
              },
            GridFrame->True,
            ColumnLines->True],
          DisplayForm]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "[If you like this kind of visual explanation take a look at the Further \
Examples for ",
  StyleBox["ListConvolve", "MR"],
  " and ",
  StyleBox["ListCorrelate", "MR"],
  ". \[LongDash] George]"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4", "Subsubsection"],

Cell[TextData[{
  "Here's a solution that views the lists as digits of a moving \"window\" to \
a ternary (base-3) number. We use base 3  because there are three distinct \
elements in all your lists: ",
  StyleBox["0", "MR"],
  ",",
  StyleBox[" a", "MR"],
  ", and ",
  StyleBox["b", "MR"],
  ". Represent '",
  StyleBox["a", "MR"],
  "' by the ternary digit ",
  StyleBox["1", "MR"],
  ", and '",
  StyleBox["b", "MR"],
  "' by the digit ",
  StyleBox["2.", "MR"]
}], "Text"],

Cell[BoxData[
    \(\(r = 3^^12000;\)\)], "Input"],

Cell[BoxData[
    \(\(len = 4;\)\)], "Input"],

Cell[BoxData[
    \(\(window = 3^\((len - 1)\);\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
        Take[IntegerDigits[Mod[r, 3^i*window], 3, \((len - 1)\) + i], 
          len], {i, 1, len}] /. {1 \[Rule] a, 2 \[Rule] b}\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]],

Cell["\<\
I'm sure this can be generalized to use base B if there are B distinct \
elements in the lists, and to take some sort of specifier of where to start \
and end, but I'm too tired right now and will have to look into this later if \
I have time. Also, I wouldn't be surprised if my code above can be made more \
succinct.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["a developer", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Function[PadRight[{a, b}, 4, 0, #]], Range[\(-1\), 2]]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["just returned from vacation", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[
      ListCorrelate[{0, 0, 0, 0}, {a, b}, {3, 1}, 0, Plus, List]]\)], "Input"],

Cell[BoxData[
    \({{b, 0, 0, 0}, {a, b, 0, 0}, {0, a, b, 0}, {0, 0, a, b}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["another late submission", "Subsection"],

Cell["\<\
A simple solution would be to use RotateLeft to generate the off-diagonal \
component, but...\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ IdentityMatrix[4]\  + \ 
      b\ Map[RotateLeft, IdentityMatrix[4]]\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, b}, {b, a, 0, 0}, {0, b, a, 0}, {0, 0, b, a}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "i.e., we get an extraneous ``b'' at the (1,4) position of the matrix, \
since RotateLeft ``wraps around.''  What we ",
  StyleBox["really ",
    FontSlant->"Italic"],
  "want is a ShiftLeft, that just drops elements of the list that are shifted \
off the end:"
}], "Text"],

Cell[BoxData[
    \(ShiftLeft[mm_]\  := \ 
      PadLeft[RotateLeft[PadLeft[mm, Length[mm] + 1]], Length[mm]]\)], "Input"],

Cell["(Yes, I read ahead ;-).  Let's test it:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShiftLeft[{1, 2, 3, 4}]\)], "Input"],

Cell[BoxData[
    \({2, 3, 4, 0}\)], "Output"]
}, Open  ]],

Cell["\<\
As you can see, the ``1'' vanishes off the left edge, and the right is padded \
by zeroes.  This should do what we want:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\ IdentityMatrix[4]\  + \ 
      b\ Map[ShiftLeft, IdentityMatrix[4]]\)], "Input"],

Cell[BoxData[
    \({{a, 0, 0, 0}, {b, a, 0, 0}, {0, b, a, 0}, {0, 0, b, a}}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->False},
Magnification->1.25
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 113, 5, 142, "Title"],
Cell[1855, 58, 45, 0, 67, "Subsubtitle"],

Cell[CellGroupData[{
Cell[1925, 62, 31, 0, 74, "Section"],
Cell[1959, 64, 572, 9, 101, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[2568, 78, 32, 0, 48, "Section"],
Cell[2603, 80, 158, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[2786, 87, 31, 0, 57, "Subsection"],
Cell[2820, 89, 60, 1, 35, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2917, 95, 31, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[2973, 99, 110, 2, 35, "Input"],
Cell[3086, 103, 277, 8, 85, "Output"]
}, Open  ]],
Cell[3378, 114, 62, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[3465, 118, 107, 2, 35, "Input"],
Cell[3575, 122, 335, 9, 85, "Output"]
}, Open  ]],
Cell[3925, 134, 78, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[4028, 142, 106, 2, 35, "Input"],
Cell[4137, 146, 405, 12, 85, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4591, 164, 31, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[4647, 168, 110, 2, 35, "Input"],
Cell[4760, 172, 277, 8, 85, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5086, 186, 31, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[5142, 190, 110, 2, 35, "Input"],
Cell[5255, 194, 277, 8, 85, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[5593, 209, 34, 0, 48, "Section"],
Cell[5630, 211, 183, 5, 38, "Text"],
Cell[5816, 218, 151, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[5992, 225, 35, 1, 35, "Input"],
Cell[6030, 228, 36, 1, 35, "Output"]
}, Open  ]],
Cell[6081, 232, 103, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[6209, 239, 42, 1, 35, "Input"],
Cell[6254, 242, 43, 1, 35, "Output"]
}, Open  ]],
Cell[6312, 246, 194, 7, 38, "Text"],

Cell[CellGroupData[{
Cell[6531, 257, 41, 1, 35, "Input"],
Cell[6575, 260, 46, 1, 35, "Output"]
}, Open  ]],
Cell[6636, 264, 187, 4, 38, "Text"],
Cell[6826, 270, 145, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[6996, 278, 46, 1, 35, "Input"],
Cell[7045, 281, 43, 1, 35, "Output"]
}, Open  ]],
Cell[7103, 285, 175, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[7303, 295, 38, 1, 35, "Input"],
Cell[7344, 298, 35, 1, 35, "Output"]
}, Open  ]],
Cell[7394, 302, 153, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[7572, 310, 90, 1, 35, "Input"],
Cell[7665, 313, 87, 1, 35, "Output"]
}, Open  ]],
Cell[7767, 317, 209, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[8001, 326, 44, 1, 35, "Input"],
Cell[8048, 329, 252, 7, 35, "Output"]
}, Open  ]],
Cell[8315, 339, 436, 12, 59, "Text"],

Cell[CellGroupData[{
Cell[8776, 355, 50, 1, 35, "Input"],
Cell[8829, 358, 187, 6, 35, "Output"]
}, Open  ]],
Cell[9031, 367, 189, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[9245, 376, 38, 1, 35, "Input"],
Cell[9286, 379, 39, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9362, 385, 48, 1, 35, "Input"],
Cell[9413, 388, 186, 6, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9636, 399, 47, 1, 36, "Input"],
Cell[9686, 402, 187, 6, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9910, 413, 70, 1, 35, "Input"],
Cell[9983, 416, 210, 6, 35, "Output"]
}, Open  ]],
Cell[10208, 425, 211, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[10444, 435, 36, 1, 35, "Input"],
Cell[10483, 438, 38, 1, 35, "Output"]
}, Open  ]],
Cell[10536, 442, 101, 3, 59, "Text"],
Cell[10640, 447, 172, 3, 59, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[10849, 455, 43, 0, 48, "Section"],
Cell[10895, 457, 155, 3, 38, "Text"],
Cell[11053, 462, 130, 4, 38, "Text"],
Cell[11186, 468, 38, 1, 35, "Input"],
Cell[11227, 471, 125, 3, 38, "Text"],
Cell[11355, 476, 109, 2, 40, "Input"],
Cell[11467, 480, 70, 0, 38, "Text"],
Cell[11540, 482, 110, 2, 40, "Input"],
Cell[11653, 486, 253, 6, 59, "Text"],

Cell[CellGroupData[{
Cell[11931, 496, 92, 1, 35, "Input"],
Cell[12026, 499, 104, 2, 35, "Output"]
}, Open  ]],
Cell[12145, 504, 237, 7, 38, "Text"],
Cell[12385, 513, 153, 4, 38, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[12575, 522, 33, 0, 48, "Section"],
Cell[12611, 524, 176, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[12812, 534, 42, 1, 35, "Input"],
Cell[12857, 537, 73, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12967, 543, 43, 1, 35, "Input"],
Cell[13013, 546, 575, 8, 119, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13625, 559, 41, 1, 35, "Input"],
Cell[13669, 562, 37, 1, 35, "Output"]
}, Open  ]],
Cell[13721, 566, 43, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[13789, 570, 41, 1, 35, "Input"],
Cell[13833, 573, 36, 1, 35, "Output"]
}, Open  ]],
Cell[13884, 577, 178, 7, 38, "Text"],

Cell[CellGroupData[{
Cell[14087, 588, 51, 1, 35, "Input"],
Cell[14141, 591, 37, 1, 35, "Output"]
}, Open  ]],
Cell[14193, 595, 111, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[14329, 602, 45, 1, 35, "Input"],
Cell[14377, 605, 64, 1, 35, "Output"]
}, Open  ]],
Cell[14456, 609, 137, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[14618, 616, 48, 1, 35, "Input"],
Cell[14669, 619, 44, 1, 35, "Output"]
}, Open  ]],
Cell[14728, 623, 145, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[14898, 630, 76, 1, 35, "Input"],
Cell[14977, 633, 219, 3, 56, "Output"]
}, Open  ]],
Cell[15211, 639, 337, 9, 80, "Text"],
Cell[15551, 650, 209, 5, 85, "Input"],

Cell[CellGroupData[{
Cell[15785, 659, 87, 1, 35, "Input"],
Cell[15875, 662, 1256, 27, 175, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17168, 694, 88, 1, 35, "Input"],
Cell[17259, 697, 662, 15, 175, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[17970, 718, 44, 0, 48, "Section"],
Cell[18017, 720, 87, 2, 38, "Text"],

Cell[CellGroupData[{
Cell[18129, 726, 109, 2, 35, "Input"],
Cell[18241, 730, 329, 11, 85, "Output"]
}, Open  ]],
Cell[18585, 744, 429, 12, 59, "Text"],

Cell[CellGroupData[{
Cell[19039, 760, 67, 1, 35, "Input"],
Cell[19109, 763, 277, 8, 85, "Output"]
}, Open  ]],
Cell[19401, 774, 151, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[19577, 782, 72, 1, 35, "Input"],
Cell[19652, 785, 277, 8, 85, "Output"]
}, Open  ]],
Cell[19944, 796, 100, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[20069, 803, 35, 1, 35, "Input"],
Cell[20107, 806, 277, 8, 85, "Output"]
}, Open  ]],
Cell[20399, 817, 108, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[20532, 824, 74, 1, 35, "Input"],
Cell[20609, 827, 349, 8, 85, "Output"]
}, Open  ]],
Cell[20973, 838, 166, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[21164, 848, 42, 1, 35, "Input"],
Cell[21209, 851, 321, 9, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21567, 865, 44, 1, 35, "Input"],
Cell[21614, 868, 315, 9, 35, "Output"]
}, Open  ]],
Cell[21944, 880, 110, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[22079, 888, 78, 1, 35, "Input"],
Cell[22160, 891, 277, 8, 85, "Output"]
}, Open  ]],
Cell[22452, 902, 31, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[22508, 906, 56, 1, 35, "Input"],
Cell[22567, 909, 349, 8, 85, "Output"]
}, Open  ]],
Cell[22931, 920, 203, 4, 59, "Text"],

Cell[CellGroupData[{
Cell[23159, 928, 35, 1, 35, "Input"],
Cell[23197, 931, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23324, 937, 52, 1, 35, "Input"],
Cell[23379, 940, 62, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23478, 946, 42, 1, 35, "Input"],
Cell[23523, 949, 163, 2, 56, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[23735, 957, 38, 0, 48, "Section"],
Cell[23776, 959, 153, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[23954, 968, 54, 1, 35, "Input"],
Cell[24011, 971, 55, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24103, 977, 44, 1, 35, "Input"],
Cell[24150, 980, 43, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24230, 986, 53, 1, 35, "Input"],
Cell[24286, 989, 104, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24427, 996, 63, 1, 35, "Input"],
Cell[24493, 999, 104, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24634, 1006, 53, 1, 35, "Input"],
Cell[24690, 1009, 93, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24820, 1015, 63, 1, 35, "Input"],
Cell[24886, 1018, 93, 1, 35, "Output"]
}, Open  ]],
Cell[24994, 1022, 66, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[25085, 1026, 69, 1, 35, "Input"],
Cell[25157, 1029, 58, 1, 35, "Output"]
}, Open  ]],
Cell[25230, 1033, 346, 10, 59, "Text"],

Cell[CellGroupData[{
Cell[25601, 1047, 51, 1, 35, "Input"],
Cell[25655, 1050, 52, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25744, 1056, 55, 1, 35, "Input"],
Cell[25802, 1059, 56, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25895, 1065, 46, 1, 35, "Input"],
Cell[25944, 1068, 204, 3, 51, "Print"]
}, Open  ]],
Cell[26163, 1074, 93, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[26281, 1082, 41, 1, 35, "Input"],
Cell[26325, 1085, 70, 1, 30, "Print"]
}, Open  ]],
Cell[26410, 1089, 105, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[26540, 1096, 39, 1, 35, "Input"],
Cell[26582, 1099, 70, 1, 30, "Print"],
Cell[26655, 1102, 298, 8, 30, "Print"]
}, Open  ]],
Cell[26968, 1113, 90, 4, 38, "Text"],
Cell[27061, 1119, 59, 1, 35, "Input"],

Cell[CellGroupData[{
Cell[27145, 1124, 37, 1, 35, "Input"],
Cell[27185, 1127, 43, 1, 30, "Print"],
Cell[27231, 1130, 234, 7, 30, "Print"]
}, Open  ]],
Cell[27480, 1140, 91, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[27596, 1148, 51, 1, 35, "Input"],
Cell[27650, 1151, 58, 1, 35, "Output"]
}, Open  ]],
Cell[27723, 1155, 177, 8, 38, "Text"],

Cell[CellGroupData[{
Cell[27925, 1167, 45, 1, 35, "Input"],
Cell[27973, 1170, 46, 1, 35, "Output"]
}, Open  ]],
Cell[28034, 1174, 250, 9, 38, "Text"],

Cell[CellGroupData[{
Cell[28309, 1187, 50, 1, 35, "Input"],
Cell[28362, 1190, 52, 1, 35, "Output"]
}, Open  ]],
Cell[28429, 1194, 195, 10, 38, "Text"],

Cell[CellGroupData[{
Cell[28649, 1208, 45, 1, 35, "Input"],
Cell[28697, 1211, 46, 1, 35, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[28792, 1218, 35, 0, 48, "Section"],
Cell[28830, 1220, 156, 4, 38, "Text"],
Cell[28989, 1226, 212, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[29226, 1235, 46, 1, 35, "Input"],
Cell[29275, 1238, 177, 6, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29489, 1249, 47, 1, 35, "Input"],
Cell[29539, 1252, 37, 1, 35, "Output"]
}, Open  ]],
Cell[29591, 1256, 94, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[29710, 1264, 53, 1, 35, "Input"],
Cell[29766, 1267, 49, 1, 35, "Output"]
}, Open  ]],
Cell[29830, 1271, 130, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[29985, 1278, 60, 1, 35, "Input"],
Cell[30048, 1281, 66, 1, 35, "Output"]
}, Open  ]],
Cell[30129, 1285, 227, 7, 38, "Text"],

Cell[CellGroupData[{
Cell[30381, 1296, 51, 1, 35, "Input"],
Cell[30435, 1299, 55, 1, 35, "Output"]
}, Open  ]],
Cell[30505, 1303, 139, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[30669, 1311, 55, 1, 35, "Input"],
Cell[30727, 1314, 58, 1, 35, "Output"]
}, Open  ]],
Cell[30800, 1318, 361, 13, 38, "Text"],

Cell[CellGroupData[{
Cell[31186, 1335, 45, 1, 35, "Input"],
Cell[31234, 1338, 44, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31315, 1344, 44, 1, 35, "Input"],
Cell[31362, 1347, 44, 1, 35, "Output"]
}, Open  ]],
Cell[31421, 1351, 199, 6, 38, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[31657, 1362, 42, 0, 48, "Section"],
Cell[31702, 1364, 158, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[31885, 1374, 56, 1, 35, "Input"],
Cell[31944, 1377, 49, 1, 35, "Output"]
}, Open  ]],
Cell[32008, 1381, 127, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[32160, 1390, 112, 2, 56, "Input"],
Cell[32275, 1394, 277, 8, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32589, 1407, 73, 1, 35, "Input"],
Cell[32665, 1410, 277, 8, 85, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[32991, 1424, 57, 0, 48, "Section"],
Cell[33051, 1426, 74, 0, 38, "Text"],
Cell[33128, 1428, 60, 1, 35, "Input"],
Cell[33191, 1431, 48, 0, 38, "Text"],
Cell[33242, 1433, 57, 1, 35, "Input"],
Cell[33302, 1436, 35, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[33362, 1440, 50, 1, 35, "Input"],
Cell[33415, 1443, 70, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33522, 1449, 42, 1, 35, "Input"],
Cell[33567, 1452, 73, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33677, 1458, 44, 1, 35, "Input"],
Cell[33724, 1461, 70, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33831, 1467, 47, 1, 35, "Input"],
Cell[33881, 1470, 70, 1, 35, "Output"]
}, Open  ]],
Cell[33966, 1474, 219, 8, 38, "Text"],

Cell[CellGroupData[{
Cell[34210, 1486, 45, 1, 35, "Input"],
Cell[34258, 1489, 125, 2, 35, "Output"]
}, Open  ]],
Cell[34398, 1494, 73, 0, 38, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[34508, 1499, 40, 0, 48, "Section"],
Cell[34551, 1501, 273, 5, 59, "Text"],

Cell[CellGroupData[{
Cell[34849, 1510, 42, 1, 35, "Input"],
Cell[34894, 1513, 89, 1, 35, "Output"]
}, Open  ]],
Cell[34998, 1517, 109, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[35132, 1524, 63, 1, 35, "Input"],
Cell[35198, 1527, 106, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35341, 1534, 47, 1, 35, "Input"],
Cell[35391, 1537, 336, 11, 85, "Output"]
}, Open  ]],
Cell[35742, 1551, 85, 2, 38, "Text"],

Cell[CellGroupData[{
Cell[35852, 1557, 44, 1, 35, "Input"],
Cell[35899, 1560, 46, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35982, 1566, 43, 1, 35, "Input"],
Cell[36028, 1569, 50, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36115, 1575, 56, 1, 35, "Input"],
Cell[36174, 1578, 304, 10, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36515, 1593, 59, 1, 35, "Input"],
Cell[36577, 1596, 304, 10, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36918, 1611, 59, 1, 35, "Input"],
Cell[36980, 1614, 265, 9, 49, "Output"]
}, Open  ]],
Cell[37260, 1626, 48, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[37333, 1630, 64, 1, 35, "Input"],
Cell[37400, 1633, 300, 10, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37737, 1648, 64, 1, 35, "Input"],
Cell[37804, 1651, 304, 10, 67, "Output"]
}, Open  ]],
Cell[38123, 1664, 230, 7, 38, "Text"],
Cell[38356, 1673, 163, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[38544, 1683, 51, 1, 35, "Input"],
Cell[38598, 1686, 77, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38712, 1692, 59, 1, 35, "Input"],
Cell[38774, 1695, 336, 11, 85, "Output"]
}, Open  ]],
Cell[39125, 1709, 85, 4, 38, "Text"],

Cell[CellGroupData[{
Cell[39235, 1717, 50, 1, 35, "Input"],
Cell[39288, 1720, 52, 1, 35, "Output"]
}, Open  ]],
Cell[39355, 1724, 57, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[39437, 1728, 64, 1, 35, "Input"],
Cell[39504, 1731, 336, 11, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39877, 1747, 73, 1, 35, "Input"],
Cell[39953, 1750, 336, 11, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40326, 1766, 78, 1, 35, "Input"],
Cell[40407, 1769, 336, 11, 85, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[40792, 1786, 45, 0, 48, "Section"],
Cell[40840, 1788, 39, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[40904, 1792, 76, 1, 35, "Input"],
Cell[40983, 1795, 277, 8, 85, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[41309, 1809, 47, 0, 48, "Section"],

Cell[CellGroupData[{
Cell[41381, 1813, 32, 0, 57, "Subsection"],
Cell[41416, 1815, 179, 5, 38, "Text"],

Cell[CellGroupData[{
Cell[41620, 1824, 66, 1, 35, "Input"],
Cell[41689, 1827, 52, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41778, 1833, 51, 1, 35, "Input"],
Cell[41832, 1836, 66, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41935, 1842, 43, 1, 35, "Input"],
Cell[41981, 1845, 58, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42088, 1852, 32, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[42145, 1856, 47, 1, 35, "Input"],
Cell[42195, 1859, 70, 1, 35, "Output"]
}, Open  ]],
Cell[42280, 1863, 260, 10, 38, "Text"],

Cell[CellGroupData[{
Cell[42565, 1877, 67, 1, 35, "Input"],
Cell[42635, 1880, 139, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42811, 1887, 43, 1, 35, "Input"],
Cell[42857, 1890, 113, 2, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43019, 1898, 33, 0, 57, "Subsection"],
Cell[43055, 1900, 54, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[43134, 1904, 55, 1, 35, "Input"],
Cell[43192, 1907, 107, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43336, 1914, 59, 1, 35, "Input"],
Cell[43398, 1917, 70, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43505, 1923, 51, 1, 35, "Input"],
Cell[43559, 1926, 70, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43678, 1933, 33, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[43736, 1937, 67, 1, 35, "Input"],
Cell[43806, 1940, 70, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43913, 1946, 37, 1, 35, "Input"],
Cell[43953, 1949, 70, 1, 35, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[44084, 1957, 33, 0, 48, "Section"],
Cell[44120, 1959, 339, 10, 101, "Text"],

Cell[CellGroupData[{
Cell[44484, 1973, 52, 1, 35, "Input"],
Cell[44539, 1976, 189, 6, 35, "Output"]
}, Open  ]],
Cell[44743, 1985, 154, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[44922, 1995, 42, 1, 35, "Input"],
Cell[44967, 1998, 43, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45047, 2004, 52, 1, 35, "Input"],
Cell[45102, 2007, 189, 6, 35, "Output"]
}, Open  ]],
Cell[45306, 2016, 42, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[45373, 2020, 40, 1, 35, "Input"],
Cell[45416, 2023, 41, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45494, 2029, 67, 1, 35, "Input"],
Cell[45564, 2032, 52, 1, 35, "Output"]
}, Open  ]],
Cell[45631, 2036, 116, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[45772, 2043, 188, 6, 35, "Input"],
Cell[45963, 2051, 43, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46043, 2057, 188, 6, 35, "Input"],
Cell[46234, 2065, 35, 1, 35, "Output"]
}, Open  ]],
Cell[46284, 2069, 136, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[46445, 2079, 55, 1, 35, "Input"],
Cell[46503, 2082, 35, 1, 35, "Output"]
}, Open  ]],
Cell[46553, 2086, 135, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[46713, 2096, 55, 1, 35, "Input"],
Cell[46771, 2099, 43, 1, 35, "Output"]
}, Open  ]],
Cell[46829, 2103, 162, 8, 38, "Text"],

Cell[CellGroupData[{
Cell[47016, 2115, 50, 1, 36, "Input"],
Cell[47069, 2118, 39, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47157, 2125, 51, 0, 48, "Section"],
Cell[47211, 2127, 413, 8, 101, "Text"],

Cell[CellGroupData[{
Cell[47649, 2139, 110, 2, 35, "Input"],
Cell[47762, 2143, 277, 8, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48076, 2156, 31, 0, 57, "Subsection"],
Cell[48110, 2158, 165, 5, 59, "Text"],

Cell[CellGroupData[{
Cell[48300, 2167, 50, 1, 35, "Input"],
Cell[48353, 2170, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48480, 2176, 51, 1, 35, "Input"],
Cell[48534, 2179, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48661, 2185, 46, 1, 35, "Input"],
Cell[48710, 2188, 277, 8, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49024, 2201, 44, 1, 35, "Input"],
Cell[49071, 2204, 82, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49190, 2210, 121, 2, 35, "Input"],
Cell[49314, 2214, 231, 5, 30, "Message"],
Cell[49548, 2221, 170, 4, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49755, 2230, 111, 2, 35, "Input"],
Cell[49869, 2234, 82, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49988, 2240, 56, 1, 35, "Input"],
Cell[50047, 2243, 82, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50166, 2249, 54, 1, 35, "Input"],
Cell[50223, 2252, 82, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50342, 2258, 104, 2, 35, "Input"],
Cell[50449, 2262, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50588, 2269, 37, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[50650, 2273, 63, 1, 35, "Input"],
Cell[50716, 2276, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50843, 2282, 63, 1, 35, "Input"],
Cell[50909, 2285, 67, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51013, 2291, 66, 1, 35, "Input"],
Cell[51082, 2294, 76, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51195, 2300, 77, 1, 35, "Input"],
Cell[51275, 2303, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51402, 2309, 62, 1, 35, "Input"],
Cell[51467, 2312, 277, 8, 85, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51793, 2326, 32, 0, 57, "Subsection"],
Cell[51828, 2328, 50, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[51903, 2332, 169, 3, 77, "Input"],
Cell[52075, 2337, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52214, 2344, 38, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[52277, 2348, 84, 1, 35, "Input"],
Cell[52364, 2351, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52503, 2358, 31, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[52559, 2362, 35, 0, 51, "Subsubsection"],

Cell[CellGroupData[{
Cell[52619, 2366, 128, 3, 35, "Input"],
Cell[52750, 2371, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52889, 2378, 35, 0, 51, "Subsubsection"],

Cell[CellGroupData[{
Cell[52949, 2382, 147, 3, 35, "Input"],
Cell[53099, 2387, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53250, 2395, 37, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[53312, 2399, 34, 0, 51, "Subsubsection"],
Cell[53349, 2401, 132, 6, 38, "Text"],

Cell[CellGroupData[{
Cell[53506, 2411, 86, 1, 35, "Input"],
Cell[53595, 2414, 305, 8, 85, "Output"]
}, Open  ]],
Cell[53915, 2425, 49, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[53989, 2429, 62, 1, 35, "Input"],
Cell[54054, 2432, 297, 8, 85, "Output"]
}, Open  ]],
Cell[54366, 2443, 66, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[54457, 2447, 63, 1, 35, "Input"],
Cell[54523, 2450, 277, 8, 85, "Output"]
}, Open  ]],
Cell[54815, 2461, 49, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[54889, 2465, 122, 2, 56, "Input"],
Cell[55014, 2469, 277, 8, 85, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55340, 2483, 37, 0, 51, "Subsubsection"],
Cell[55380, 2485, 76, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[55481, 2489, 88, 1, 56, "Input"],
Cell[55572, 2492, 297, 8, 85, "Output"]
}, Open  ]],
Cell[55884, 2503, 121, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[56030, 2510, 67, 1, 35, "Input"],
Cell[56100, 2513, 277, 8, 85, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56438, 2528, 31, 0, 57, "Subsection"],
Cell[56472, 2530, 197, 4, 59, "Text"],
Cell[56672, 2536, 212, 7, 59, "Text"],

Cell[CellGroupData[{
Cell[56909, 2547, 83, 1, 35, "Input"],
Cell[56995, 2550, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57122, 2556, 83, 1, 35, "Input"],
Cell[57208, 2559, 113, 2, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57358, 2566, 46, 1, 35, "Input"],
Cell[57407, 2569, 311, 9, 103, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57767, 2584, 36, 0, 57, "Subsection"],
Cell[57806, 2586, 169, 3, 59, "Text"],
Cell[57978, 2591, 200, 4, 59, "Text"],
Cell[58181, 2597, 53, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[58259, 2601, 109, 2, 98, "Input"],
Cell[58371, 2605, 90, 1, 35, "Output"]
}, Open  ]],
Cell[58476, 2609, 299, 9, 80, "Text"],

Cell[CellGroupData[{
Cell[58800, 2622, 109, 2, 98, "Input"],
Cell[58912, 2626, 128, 2, 56, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59089, 2634, 40, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[59154, 2638, 35, 0, 51, "Subsubsection"],
Cell[59192, 2640, 49, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[59266, 2644, 75, 1, 35, "Input"],
Cell[59344, 2647, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59483, 2654, 41, 0, 51, "Subsubsection"],
Cell[59527, 2656, 429, 9, 101, "Text"],
Cell[59959, 2667, 152, 3, 77, "Input"],
Cell[60114, 2672, 60, 1, 35, "Input"],

Cell[CellGroupData[{
Cell[60199, 2677, 104, 2, 56, "Input"],
Cell[60306, 2681, 90, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60433, 2687, 85, 1, 35, "Input"],
Cell[60521, 2690, 90, 1, 35, "Output"]
}, Open  ]],
Cell[60626, 2694, 83, 1, 35, "Input"],

Cell[CellGroupData[{
Cell[60734, 2699, 131, 3, 56, "Input"],
Cell[60868, 2704, 90, 1, 35, "Output"]
}, Open  ]],
Cell[60973, 2708, 265, 7, 80, "Text"],
Cell[61241, 2717, 112, 2, 35, "Input"],
Cell[61356, 2721, 150, 2, 56, "Input"],
Cell[61509, 2725, 167, 4, 77, "Input"],
Cell[61679, 2731, 217, 4, 80, "Text"],
Cell[61899, 2737, 87, 1, 35, "Input"],

Cell[CellGroupData[{
Cell[62011, 2742, 82, 1, 35, "Input"],
Cell[62096, 2745, 2464, 70, 77, "Output"]
}, Open  ]],
Cell[64575, 2818, 226, 7, 59, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64838, 2830, 26, 0, 51, "Subsubsection"],
Cell[64867, 2832, 478, 17, 80, "Text"],
Cell[65348, 2851, 50, 1, 35, "Input"],
Cell[65401, 2854, 45, 1, 35, "Input"],
Cell[65449, 2857, 62, 1, 35, "Input"],

Cell[CellGroupData[{
Cell[65536, 2862, 169, 3, 77, "Input"],
Cell[65708, 2867, 90, 1, 35, "Output"]
}, Open  ]],
Cell[65813, 2871, 343, 6, 101, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66205, 2883, 33, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[66263, 2887, 91, 1, 35, "Input"],
Cell[66357, 2890, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66496, 2897, 49, 0, 57, "Subsection"],

Cell[CellGroupData[{
Cell[66570, 2901, 107, 2, 35, "Input"],
Cell[66680, 2905, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66819, 2912, 45, 0, 57, "Subsection"],
Cell[66867, 2914, 117, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[67009, 2921, 104, 2, 35, "Input"],
Cell[67116, 2925, 90, 1, 35, "Output"]
}, Open  ]],
Cell[67221, 2929, 291, 7, 59, "Text"],
Cell[67515, 2938, 122, 2, 35, "Input"],
Cell[67640, 2942, 55, 0, 38, "Text"],

Cell[CellGroupData[{
Cell[67720, 2946, 56, 1, 35, "Input"],
Cell[67779, 2949, 46, 1, 35, "Output"]
}, Open  ]],
Cell[67840, 2953, 144, 3, 38, "Text"],

Cell[CellGroupData[{
Cell[68009, 2960, 103, 2, 35, "Input"],
Cell[68115, 2964, 90, 1, 35, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

