(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    136083,       3513]*)
(*NotebookOutlinePosition[    136771,       3537]*)
(*  CellTagsIndexPosition[    136727,       3533]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N000061000`40O003h00OJgoo00Ikog?NJia[
W7>LNmh4Ool00gOoJg]c_@05Ool01GOoJke[NfnLOmh0g7oo001YOol047?oDeU6DTV]CHa1cSIc?YAJ
mgNmOomSW56<@NlfLe[g0Woo00U_oe<HBLi=JdG>=U8nU5lGMmh0fWoo001XOol00f_NH:El0005O000
16R4=Li2eVIB0g`000EXHcHaKke__FAS00El0004H:D^4DjDMmkIOol006Moo`03Nomh07`000Ql0003
>Q1l07`000=l0003CLeO_G`000Ql0003<Q1JmWoo0=Qoo`0000MVNFIjHWYVNV9jIWYRN@02IWX0269i
IWYVNV9jIWYRNFIjHWX2IWX00f9iIWYRNP02IWX2HWX2IWX00f9iHWYVN@02IWX01F9jIWYVNFIjHWX0
0VIj01=RNVIjHWYVNV9jIWUVNVIiHWYVNVIiHWYVNV9jIWYRNVIjIWURNP02IWX01F9iHWYVNVIjHWX0
0VIj00ERNFIjHWYVNFIj009RNP06IWUVNVIjHWYVNV9j0VIj00=RNVIjIWT00V9j0VIj00ARNVIjIWUR
NP9VNP03HWYVNF9j009VNP03HWYNgW@000]l0003O21l07`0009l0003CM9d0G`000Ql0009L00MKeHF
J[]VVfZjJY]V^fZj009Z^`03J]]Z^f[K009Zf`03K]]ZnfkK009^n`03K_a^nfkl009^o004Kaa^o6lL
La`3Ka`05W<mLaac?7<lLaac?G<lLcec?7LmLeac?GLlLeec?G=MMeecGGMMLeegGG=M0WMM0gMm00Eg
GGMnMgegOWMm00=gOP0=NiigOGMnNiigOWNNNiigOGNNNiigWW^NMkh017^N00Ek_W^NNiik_W^O00Ik
_P0>Nkmo_W^oNmik_gnoNmio_g_OOmmkgWnoOmmkg`Aog`03NmmoggoO009og`03OomoggoO065oo`00
00<d43P@>1000SP@00Hd4CP@=10h43PA=102>1001C@@>10h43P@=1000SP@00<d43P@=1000cP@00ld
43P@>14h43@@>10d43P@=14h43@@>10d43P@=1000SP@00Ld43P@=14h43@@>10d4@02>10013@@>10d
43P@0S@@00<h43@@>1000SP@00Td43P@>10d43PA>10d43P@=1000cP@00Ld43P@=10h43@@>10d4002
>1001C@@>10h43P@=1000SP@00@d43P@>10d408h4006=10h43@@>10d4CP?1G`000<l:TQ>O00017`0
00I41W`0O01l05`W?2h5O0000f`2O01l0003O0001B@692dlDT1a?7800T2B00A0Td2bA;=4/`94d`03
A?A8m4Sd00995003CAE9=DdD009=E@03DEIAME5e009AMP05DIIEUUFFEIME]P02EKL015WGEMMIeeGG
15Wh00aN65XHGQQN65hhGQQN>F8hHUUR>69IGUT3HUT0369iHWYVNF9jIWUVNV:IIYYVNVJJI[YZVP9V
^P06J[]Z^V[KJ[]ZffkK0f[K00=Znf[lK_/00Vkk0VlL00=_6flLK_`00W<L00A_?7<lKaac?09c?@09
Leac?G<mLeagGG=MMeegOG=M00=gO@07MiigOGNMMiikWGNNNih00W^n00AkWW^nNkik_`9k_P06Nmmo
gW_OOmikggoOEWoo0002A=<01DBcA=A4ddCCA;<014CC00]4/dCCA==4e4CCA;=4ddBcA=A4ddBc00=4
d`06A;=4e4CCA;=4ddCD0TCC00=4/dCCA=<00TCC00=4/dCDB;<00TCC00E4]4CCA;=4ddCD00A4d`06
A;=4ddCDA==4/dCD0dCC00E4e4CCA==4ddBd00=4d`03A;=4ddSD0094d`03A;=4e4CC00=4d`03A=A4
ddBc0094d`03A=A4ddBc0094d`03A=A4ddBd00A4d`0>A=A4ddBcA=A0e5B_O05d0g@SN05TB3Cg:?QP
9@Al0006:6X`eEB?B;8`nW0S17`000</JRciF8h017`000EL8b3>BAA=5Ddd009==@03DEE=EU5E00=A
MP9EUP0=DIIEUeFgEKII]eGGFMMEeeggFOMIf5hHFOP00ehH00MN>5hIGSQN>68iHUUN>@03HUT01f9i
IUURNFIjHWYVVFIj00AVVP09IY]V^VZJI[]Z^VZkI[]ZfVZj00EZf`07K_]ZnfkLJ_]^nfklK_/00Vkl
00I_6flLKaa^o7<LKc`2La`00flmLaa_?@02Lc`2Lcd02WMLLeecGGMMLeegGG=mMeegOGMM0WMm00Qg
OWNMMgigWWMmNiigWGNN0g^N00=k_W^NMkl017^n00Qo_g_NNkikggoNNmmogWoo0WoO00=ooWoOOol0
EGoo0002A;<0142B?54lDSab0TBc0210Td2BA;=4/cab@58lLCaB?790LSab@994/d2c@58lLT1b@990
LSab@74lDTBBA;=0Tcab@54lLT1bA;=0TSaA0Sab0T2B01LlLT1a?590LSab@590LT2B?790DT2BA;=4
/T1bA;=4Td1b?74lDT1b?78lLD1b0094/`09@78lLSaA@790Tcab@54lLT1b0094/`05@990DSab?590
TP02A;<013ab?34lDSaA0T2B014lDT1b@9=4/d2B?790LSaA@9=0e3SF>?LlecSF?=I8/dAY00El0005
;;50e42d@=@he`04O00017006914dcCi17`000Id01b^A?===DTECC@2CCD01E5ECEEAEE5fDGD00U5f
0UFF00aE]UFgEKII]eGGFKQEeeWhFOMIn5ggFOP4GQP2GST2HSP6HUT01fIjHUUVNF9jIWURVVIi009V
VP05JYYVVfJjJYYV^`02J[X00fZkJ]]Z^P03J]/02fkKJ]]^nf[KK_]Zo6kkJaa^o6kkK_`00VlL00Uc
6flLLaa_?7<lLaa_?G<lLcd00W<l0W<m00=gG7<mLed00W=M01EgGG=MMgecOGMnMgegOWMmNgigOGNN
MiekOW^NMiikWGNnNiik_W^NNkl00W^n00Qo_W_NNkmogg^nNmmogg_O0WoO00AoogoOOomogeEoo`00
02i4/d2BEKMZ^ehHJ[Y8ld1cCEEEUT1bA==VVV9IFMQRFFIiGSUVNUFF@79AMVJJFMMVNU5fGQQRFEWH
IYYAUT1bDGIZ^UWhGSUR>CaBGQQVVUWGIWYEUUVgIWYIf0=RF@0>IYYE]ddeIYYRFEWG@794m5Vg?59=
EFJJGQUN60=RF@0:HSTlLTBcIYYIn68iGQQ=EFZjFOP2HST06D2C@99I]fJjFMQRNEgh?98h46JJMii^
fflLB?AAUVIjIYYAMT1bEGIVVUWGIYYEUT2B00=4/`03A=@leFA800El0006>6/le4RdA==0]3cE17`0
00EH0b2>A;@lmg0T00Al00046:e954dECA@3CCD07deEDEEAEU5eDEIAUUFFDIIEUeFfEIME]eGGFKME
eeWgFMMImeghFOQJ65hGGOQN65hiGQQR>5iIHSUNF68i00=RF@08HWYVFF9iHWYRNFIjIYUVNP=VVP03
I[YVVVJk009Z^P05I[]Z^fJjJ]]Z^`05J]/01FkkJ]a^nfkkK_`00Vkk00=_76kkKa`00flL00Ec76lL
Laac?6lL009c?00=Leec?7=LLcecG7<mLeegGG=MMgegGGMnMed00gMm00IgOWMmMiekOWNNMid3Nih0
0gNNNiik_P02Nkh027^oNkik_goNNkikggnnNml2Oml017_nOmmoogoOEWoo0000?DBc@9=956JJOomE
]dBc?75Mn7oo=110TUFgLceoog<mB?Aoof9IA==0TdCCGQUoogMm@998m7MmOomN64CD@998m5FgOomo
gdSd@79956[LOomVVTBcA?=^o7ooHSU==E5EEIIooddeK_]oodBc@79==Goo>114ddde009oo`07A;=^
o7oOA==4/d2BBCD00Woo00=8m4BcDIH00Woo00U954BB@9=8lehIOomgGDCC>1000Woo00i8e42BHUUo
oe5FOomRFDCC@9=4dehIOomkWT2c0dBc00A4ddBc?=I/A`Al0007>4L<S3b@A;A4/dCC?=H017`000EL
8QR=@;8ln7@R00Al00048<i4m4dEBA@2CCD014eECCE=EE5e0U5f015AME5fEIIAUUFGEKII]UFgEMMI
]eWHFOMIf5WgGQQMn5XH009N6004HQQN>EhHGST2HST00eiIHSURF@02HUT0269jIWURNVIiHWYVVVJI
IWX4IYX01fZjIY]V^VZjJ[]ZffZj009Zf`0EJ[]ZffkKJ_]ZffkkJ_a^g6kkK_a_76kkKaa^o7<KKaac
76llLaa_?6lM009c?00BLcec?7<mLcagGG=MMeegG7=MMeecGGMmMeegOG=nMgegOWNM0WMn00UgWG]n
NiigWG^NMiikWWNnNih01G^n00]k_g_OOmikggnnNmmoogoONmmoogoO05Ioo`0002]4/dCC@98d47^n
>150/caAHSUooeFF?790DT2BOomEUS@@DEERNS`aA;<lDE5EOom4dd1b?59=5GooA==0LTBc@;<d3goo
Ka`h44CC@78lDGooDGHlDP02@780?7ooCEDlDD2C>35AMG<m>15_73`a?79EUWooIWTh<CP@Lceogc@@
>11gOCPA@;=4/c@?OomZVSPA@;<d47ooMcdd44BcA==0Tc0?OomR>3@@FMMoocPa@790/SPAGQQ^fd2b
IYXl<DCC?55AEGooA;=0LTBc?=DX/@8PSP0378m0SGPT00Al0003:4L/STCC0094/`03>=Ml07`000=l
000316/PSR2a00Al0006K00TdDdEBAA==Ddd0Tde00Y=EE5FCEEAEU5eDGIEUU6FEIME]P=E]`9Ie`06
EMMIeeWgGOQIn5Wg0ehH015N>EhHGSQR>EiHHSURFEiIHUURNF9IIWURFVIiHWYVNVIi00EVVP09J[YV
VfZjJ[YZ^fJkJ[YZ^fJk009Zf`0<K_]Zff[KK_]ZffkkJ_]^o6[kK_a_76lK16lL00=c76llLa`00W<l
00Qc?G<lLcecG7<mLeec?G=L0g=M029gOG=MMgegOGMMMgegOWMmMiigOG^NMiegWW^NMiikWW^nMiik
_g^nNkmk_WnoNkikggoNNkiogg_OOmikggoOOomogUMoo`0001m0/dBcA=<lDV[KEII0Tc`aK_aoogoO
?350TT1bOomVVSaA>35k_SaB?34`46ZkOolh4D2c@;90TWooFMLlLP02A;<013PaNgioocPA0TBc038h
4GooIYXlDDBc>11oofIj?554/dSd?790TSaALce0TcaAHUYoogMn@78h<FZkOolh<CaBIWUMn3P@>154
/gooEKI0LTBc?35c?Goo>114ddBcA=<h47ooMgh`3gMMOold44CC0TBc01<lDE6G?35kWSaB?34`46Zk
Oolh4DBc?=EXB6PSG09L8VP106`@[`04O0001f0188m4/dCCA;<leVa600Al0003J08dAg0000Al000;
D2@hlddECAA95DTdDCE==E5ECEEAE@02DGH04U6FDGIEUU6FEIME]UFgFKIEeeVhFMMImeWHFOMN65Wh
GQMJ609N6006GSUN>68iHSUNF68i169I00ERNVIiHWUVNF:J009VNP03IYUVVVJK009VVP05J[YV^fZj
I[YZ^`03J]/016ZjJ]]ZffkK0V[K00I^nfklK_]ZnfklKa/2K_`00flKKaac7002Ka`01W<LKcac76lm
Kcac?09c?@0<LcagG7=MMeecGGMMLeegGGMmLeegOGMn0WMm00agOWMmMiikOG^NNiegWW^NMkikWW^n
Nih4Nkh01g^oOkikgg_OOkmkgW_O00=og`03Oomoggoo05Eoo`0000Q4ddBcA;=0TUFFJ_]0DCPA0Woo
04AIefJJ?54h4GooLa`l<D1bEIIooflLLaaoogoO>114ddBc>15oof9J?554ddBc?55Z^goo<0llLT1b
=0moogMM>354/cPAOom^o30??55gGCaAA;=0LVIjEIHd47^NOom8m6kk=11R>Goo>354TSaBOom_77<L
Niiood2c@994/caAHWYoocPA0dBc00Ph4GMnOol`3WMnOolh4D2c0TBc00e0ddBB?79EUWooKaac77oo
Nmlh442c?=Id9004O0000g0RK09l0003O0000f@1;;54e002A;<00d3DB;9l000:O0001BR_BAE=54TE
CA@00dde0TeE00MAMU5EDGIAMUFFDIIEU`02EKH2EKL04EWGEMMImeWHFOMMn5WgGOQJ65hIGQQN>5hH
HSUN>5hiHST01F9I00QVNV9iIWYRNVIiIWYRVFIj0fJJ00UV^VZkIYYZ^fZjJ]YZ^fZjJ[/00V[K00a^
ff[KJ_]^nf[KK_aZnfklKa]^o6kkLa`4Ka`01g<LKcec76llLaac?7<m009c?005Leec?G=MLeecG002
Led00gMmMeegO@03Mgd037MnMgekWWMmMiigOGNNNiigWW^NMiikWP=k_P0?Nkmk_WnnNkikgWnoNmik
ggnoOomoggooNmmoogoO05Eoo`000dBc00=0/d1bMgh00SPa015oogMM<0moocaB>11oog^o>354/cPa
Okm0LSQAOomZfc`a0094/`0:=11oogMM>354/dCC?59In7ooGOP2HUT0<eWhOomoocPAA;<h<G=MOomV
NW^oNkhh4DBc@99=EF[K<0ioog<m<0ikOSPaEGIood2B@;<l<F[KFMLh<FlLOolh4DBcA=<lLUWGOom0
TT2CA==4/caAIYYoob`>K_aoocP@A;=4d`02A;<0342cA;<h<GoO@78hDGooK]/l<DCC@;A0d`Yl0008
@6/le4BcA;=4dd2c>=M/A`Ul000>D4Lm5DceBAA=54TECCA==DeECCEAEDeEDGIAM@9AMP9EUP05DIMI
]eFfFMME]`02FML015WgFOQImeWh0UhH00UMmehHGQQN>EhHHUUR>5hiGUT00f9I00MRNF9IIUYRNFIj
HWYVN@04IYX01fJjJYYV^VZkI[YV^fZj009Zf`05J[YZff[KJ]]^f`02J]/04FkkJ_]^o6kkJ_]^o6lL
K_]_77;lKaac76llLaa_77<mKc`00W<l0W<m01]c?7=MMcecG7MMLeegGG=MLgegGWMMMgegOWMmMiig
OW^MMiekWWNNNiikWG^NNkigWW^nNil00W^n00ek_g^nNmik_g_NOmmogW_OOmmogWoOOomog`1FOol0
000OA;=0/dCCA;<lDG<LA9=4dgooIWTd46IJIYX`3goOOolh44Bc@79N>E6F>11ooeWG?594ddBc?35g
OWoo>1000TBc02M0LU5EOomIeddeDII8m6klOolh44Bc?55Z^gooA==N67oo?550/dBc@79^o3P@OomR
FC`aDIIRFD2COom9541cA;94/fkl;0ioog^n>1400TBc00E0LTdeOom==D2B0094/`0:?79Mn7oo=11A
MWooA;=0TTBcA=<2A;<024CC@79R>E6F>11ooeWG?782A;<00ccFE8il0007O0001E1Y>=I4]4BcA=<0
0dBc00<dmfa7O0001W`000QHAcTHB?A954SdBAE=54dd0Tde00]=EE5FDEEAMTefEGIAUUFFDIME]UFF
009E]`08FMMEeeWGFMQIeeWhGOQIm`=N6003GSUR65hh009N>@03HUQR>F9I00=RF@07IWYRNVIiHWYV
NFJJIWX00VJJ00YZVVJJIYYVVfJjJ[]Z^VJkJ[YV^`9Zf`0<J[]^nf[KJ]]^nf[kK]a^nf[kK_a_76kk
0VlL00Q_6g<LKaac76lLLca_?7<L0W<m00]c?7MLLcacGG=LLcecGGMMLeegOGMM009gO@03LgegOGMn
009gO@06MgikWWMnNiegWW^N0WNN015k_W^NNkik_g^nOkikgWnoNmmo_W_ONkmogWooNmmoogoO05Mo
o`0001m4/dCCA;=0/d1bGQQEeddeOomE]caB>31ooc@?KaaoocPAA;=0/dBbK_a=5GooB?A0TT2CA;<l
<FZkOolh4@02A;<0:42B@9=ooe6F?350TS`aFMMoocaBA;<lDEhHOold43P@Lce8m42BA;<lDF9JFMMo
oe5f@78h<G<lA==ooeFG?994/caBJ_]4TgooJ[/lDD2B0TBc00@lLWooFOQ0DP94/`08?79=EGooBA@d
47ooJ[/h<@A4/`0??590/T1bK_a=5GooB?A0LTBcA==4/ccFA;=TB7@S009l000:M0=PJ42d?=I4/dCC
A;=0/dBcA=<2A;<02CSGC;1XAg`1O01h0FA6A;4m5`03B?@00dTDCAA95@02CCD02deECCE=EE5FDGEA
MU6EEGIAUUFFEIL00UFf00YI]eGGFKMIeeWgFOQImeWhGOQJ60=N6005GSUR>5hiHUUN>@06HUT01fIi
HWYVNF9jIYUVNVJI009VVP0:IY]Z^VJkJYYV^VZkJ[YZffZjJ[/4J]/016kkJ]]^nf[k0Vkl00A^nfkl
Kaa^n`E_7004Lcac77<lKc`2Lc`2Lcd01W=MMcecGG=MLeacG@9gG@03LgegGGMm009gO@9gOP0:Mgeg
WWMmMiikWW^MMiik_W^NMih3Nkh01W^oNkik_W_NOkikg`9ogP06NmmoggoOOmmoog_OEWoo0005A;<0
34CCIWYR>GooB?A0TT1bHUUIn5ghOollD@94/`0T?59IegooOolh44SdDCDlLCabGQQoocaA@;=0LTde
>35oof9J?554/d2BDEEoodTD@98lTUEfOom9541c@990LTSDA==0TdCC0Woo02Q0TT2C@99EUVIjOomI
md1AA;=0TTBcMgeooeFg?35EUcaA@;<h47ooIYXlDD2cA;=8m41bOomIecP@GQQooc`a@794/d2bA;=Z
fd1B?79Ie`9oo`03=10lLT2B00=4/`03@=@leCSG008leP05>?LleD2dA;=0d`03A;<00dCCA;=0/`02
A;<023cD?=HheccF??LleTCeA=<3B?@014dDBAE==DdD0Tde01E=EE5ECEEAMU5EDGIAUUFFDIME]UFG
EKMIeUFgFMMEeeWhFMMIn5hHFOL00ehH00AN>5hHGSUN>09R>@03GUQRFF9I009RF@06IWYRNV9IHWYV
VFIj16JJ00YV^VJJJYYV^VZkJ[YV^fZkJ]]Z^P=Zf`05K]]Zff[KJ]]^o002K_/00f[lKa]^n`02Ka`0
17;lKaac?6lL0W<L00A_?7<MLcac?@9c?004LcecG7LmLe`2Med01g=mMeegGGMmMeegOGMn009gO@06
MiigOGNNNgekWWNN0W^N00AgWW^nNkikW`=k_P04Okmk_W_ONkh2Nml01GoONmioggooOmh0Egoo0000
1d2cA==4/dCCA;<h<FZj009oo`09?350/dBc?35gGEWgOom8e42B0094/`0M=11oogoo>10lLWooB=@d
44BcOom4/cPAA==ogbP=OomgGC0@A;<lLSPAOomI]cPA@78h<GooDGHh4002>34017oo@;=4TR`>0Woo
00Pl<D2cA;<h4G<LOomVNS@@0TBc02Hh4G<LOom4dc`aJ_]c7C@?<0moog^N=10d3gNNEIHX3GooIWXd
430?NkioocPa?58l<E5fOolh<DBc>11oog^NCEEooe5f@994/dCC0dBc00E0ddBcA;=4/dCC00=4/`0<
A==4/dBcA;=4ddBcA==4/dCCA;=0/dBd0TCC00i8e4SdA?=8m4TDCAA954TeCCEA=DeEDEEAEU5e0U5f
00EEMU6FEIIE]eFf009E]`03FMMEeeWG009Im`9In003GOQJ65hH009N6006GSUN668iGSQRFF8i0V9I
00URNF9IIUURNFIjHWUVNV:IIWX016JJ00MV^VJKJ[YV^VZkJ[YZ^`06J]/00fkkJ]]^n`02J_/01Fkl
K_]^o6lLK_/00VlL00ec76lLLca_76llLca_?7<mLcac?G=MLcac?@03Led00g=LMeecG@03Mgd02gMn
MgegOGNNMgegWW^NMgigWG^NMih00W^N00AgWW^NNkik_`=k_P05Ommk_WoONmio_`02Oml01GooNmmo
ggooOml0EGoo0002A;<0442cA;=4/d1bCCEoogoO>114/dCC?79E]goOOom953ab0TBc00llDFZkNihh
DCaBHUUoofIjK_]oog^NHWUoog^nGQP00Woo00A^o4CCCAEgO@9oo`03HYU95GMM009oo`07J[YZ^goo
Oolh44SdK_`00Woo00Dh4DBcA;=0TTTD009oo`0<J]]4ddBc@990/goo?350/cPAOomk_VIj0Woo00ER
FG=MOom4/fkK009oo`0DJ]]4/c@?KaaooehHFOQoogoO?554/caAJYYcGE5fOomE]T1bA==0/`94/`0:
@==4/dBc@;=4ddBc@;=4/dCC@;<2A;<0143CA;=4/d2c0TBc00e0ddBcA==4/dSCA==4m4SdBAA<m4TD
CAE==002CCD3CED2DGH02E6EDGIEUU6GEIIE]UGGEKMEe`02FML03eWHFOQImeghFOMN65XHGQQN>EhH
HSUN>F9IGSQN>@02HUT01VIIHUURNFIjHWYRN@9VNP03IYUVNVZJ00=VVP0?J[YVVfZjI[YZ^f[KI[YZ
^f[KJ[]ZnfkKJ]]^nf[K009^o007J_]^nfklKa]^o6lLKa/00VlL00Ec76llLaa_?G<L009c?007Lcec
?7LmLeec?7=MMe`00W=M00EgOG=NMgegGGMm009gOP0>MgegOW^MMgigWG^NMiikWG^NMkikWW^nNkmo
_P9k_P07Nkmk_W_ONkiogg_NNml00goO00=oogoOOol0EGoo00002TBcA==4/dBc@;90TehhOomkWSPa
0dBc00Dd47ooOomc7D2B0094/`0V@;=0/TdD@9=4/d2BDGI8ldCD>354ddSdBAAA=E5f@;=0TUWG@;=8
m5FF?558deFGB==EUSaaA;=E]eEfCEE4TT2CA==E]dCCA;=0/P=4/`04@794ddSdEKL2A;<05dCC@798
m4BbA;=0TU5EBAA8m3ab?59=54BcDGI4/eFg@794/eVgA;=0/c`aA;800UhH00Y4/cPaA;=4dd2c@998
m3aAB?A0LP=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00=4ddBcA;<014Bc00A4ddCD
B=A8l`98m003BAA95DdD00===@03CEEAEU5E009AMP0=EGIAMU6FEIIE]eFFFKME]UVgEMQIeeWgFML0
0UWh00=J65ghGQP00UhH00AN>EhhHSQR>@9RF@0;GUURFF9IHUUVFV9iIWUVNV9iIWYRVP03IYX026Jj
JYYV^fZjI[]Z^VZkJ[X2J]/02FZkJ]]Zff[KK_]ZffkkJ_]^n`02K_`01VlLK_a_6fklKaac709_700;
Laac?7<LKcac?G<lLcec?7<mLeagG@02Led2Med017=MMgegGG=n0gMm00agOW]mMgigWGNNNiekWWNN
NkikWWNnNih2Nkh03G^oOkik_W^nNmmogW^oOmmogWoONmmooWoO05Moo`000TBc00U4ddBc@79cGG<L
J[]In41bA=<00TBc00M0LUFFK_aV^W^NB?A0/`02A;<02T2CA;=4/dBc@790TdBbA;=0TdBC0T2B00i0
TdBB@9=0TTBCA;=0TTBc@9=0TT2c@994Td2C0T2B00M0LT2cA;=4/d2BA990/`03A;<01DCCA;=0TT2C
@98014Bc00M0/dBcA;=4/d2B@9=0TP02A;<0242BA9=0TT2c@794/T2C@983A;<0142c@790LT2c1DBc
00=4TdBc@;<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00TBc
00I4ddBcA?=4ddSdB=@2BA@02TdDBAE==4deCEE==E5ECEEAME5F0U6F00AEUUFGEIIE]P9E]`09EMMI
eeWGFMMIn5ggFOQMn5XH009N600BGSUN65hHGSURFEhiHSURFF8iHWURFVIiHUURNV9iIYYVNVIi16JJ
00UVVfZJI[]Z^VJjJ]YZ^f[JJ[/00f[K00Y^ff[KJ]]ZnfkkK_aZnfkkK_a^n`9_700EL_a_76lLLaa_
?7<MKcac7G<lLcec?7=MLcacGG<mLeegGG=LLeegOG=M00AgO@08MiigOGMnMiekWWMnNiigWP9kWP05
MiikWW^nNkik_`03Nkh027oONmik_goONmiogg_OOol2Oml00gooOmmoo`1DOol000E4/`04?54lDSaA
@783A;<01TCCA;=0LSaA?58lD@A4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBc
A;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05
A==4/dBcA;=4d`03A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03
A;<01DCCA;=4/dBcA=<00dBc00E4ddBcA;=4/dCC00=4/`05A==4/dBcA;=4d`03A;<01DCCA;=4/dSD
A?<014Sd00===DdDBCD00Tde00M=EE5EDEE=MU5eDGIEMP02DIH035FgEIME]UVgFMMEeeWGFMQImeWh
GOQIm`AN6006GSUN>5hhHSURF5iI169I00MRNVIjHWUVNV9iIYYVNP04IYX01VJjJY]Z^VJkJ[YV^`9Z
^`0@J]YZff[KK]]ZffkkJ]]^nf[lK]]^o6[lK_]_76klKa/2Ka`01W<LKaac76llLca_?09c?007Lcec
?7=MLcacGGLlLgd00WMM00=cGGMmMed00gMm0WMn00MgWGMnMgekWGNNNiigW@02Nih00gNnNiik_`03
Nkh01gnoNkikggoNNmmogg_N009og`9oo`03Ommoogoo05Aoo`000814/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4
e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dCDA;=4e4BcA=A4/dSD0TCC
00A8e4SdB?E9509=5008BAE==E4eCEEAEDeEDGIEMP9AMP08DIIEUUFGEKII]UFgFMMEe`9Ie`05FOMM
meWhGOQJ6003GQP01V8iGSQN>F8iHUUN>@=RF@06IUURNFIJHWUVNV:I0VIj00UVVFJJIYYZVVJjIYYV
^VJkJ[X00VZk00=ZfV[KJ[/00f[K01A^nf[KK_aZffkkK_a[6fkkK_a_6flLLaa_77<LKaac?6llLaa_
77<l0W<m00Ac?7<mMcac?@EcG@0@MgegGGMmMeigOGMnMgegWGMnMiikWWNNNiikWG^NMkh2Nih3Nkh0
2G_OOkik_W_NNkmogW^oOmikg`02Oml00gooOmmog`1FOol0008/3P04<0h/3R`><0h2;0h0130>;0h/
3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04
<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>
0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/
3R`><0h2;0h0130>;0h/3S0>0R`>00@`3R`>;0h`3P8/3P04<0h/3R`><0h2;0h0130>;0h/3S0>0R`>
00@`3R`>;0h`3P8/3P05<0l`3S0?<0ld3`03=102>103>342?5400cab@790TP02@9800dBc@;=4d`02
A=<2B?@3BA@04TddBCE==DeDCEEAEDeeDEIAME6FDGIEUU6FEKIE]eFfEKMIeP9Ee`07FMMImeWgFOQI
meghFQP015hH0ehh00AR>EiHHUUNF@=RF@9RN@05IWURNVJIIWYVV@03IYX3I[X016ZkI[YZ^f[J0V[K
00YZfV[KJ_]^nf[kK_]^o6lKK_a_6`=_700KLca_?7<LKcac?G<lLeac?7=MLeacGGMmLeegOG=mMgec
OGMnMiegOGNNNiigWG^nMiik_WNn009k_P07Nmik_goNNmikggoOOoh0Dgoo0000
\>"], "Commentary",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {Inherited, 0}},
  Evaluatable->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Expression Formatting in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "Notebooks"
}], "Title"],

Cell[TextData[{
  "A few examples of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s unprecedentedly powerful expression formatting capabilities."
}], "Subtitle"],

Cell[CellGroupData[{

Cell["Recursive Expressions", "Section"],

Cell["This shows successive nesting in an ordinary expression.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[\@\(1 + #\)&, \[Lambda], 5]\)], "Input"],

Cell[BoxData[
    \({\[Lambda], \@\(1 + \[Lambda]\), \@\(1 + \@\(1 + \[Lambda]\)\), 
      \@\(1 + \@\(1 + \@\(1 + \[Lambda]\)\)\), 
      \@\(1 + \@\(1 + \@\(1 + \@\(1 + \[Lambda]\)\)\)\), 
      \@\(1 + \@\(1 + \@\(1 + \@\(1 + \@\(1 + \[Lambda]\)\)\)\)\)}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
RadicalBox is an expression formatting primitive that is displayed \
as a radical.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[RadicalBox[#, #]&, x, 4] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      "\({x, \@x\%x, \@\(\@x\%x\)\%\(\@x\%x\),          \
\@\(\@\(\@x\%x\)\%\(\@x\%x\)\)\%\(\@\(\@x\%x\)\%\(\@x\%x\)\),          \@\(\@\
\(\@\(\@x\%x\)\%\(\@x\%x\)\)\%\(\@\(\@x\%x\)\%\(\@x\%x                       \
\)\)\)\%\(\@\(\@\(\@x\%x\)\%\(\@x\%x\)\)\%\(\@\(\@x\%x                       \
\)\%\(\@x\%x\)\)\)}\)",
      DisplayForm]], "Output"]
}, Open  ]],

Cell["This creates a recursive button structure. ", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[GridBox[Table[ButtonBox[#], {2}, {2}]]&, \[FilledSmallCircle], 
        2] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{"\[FilledSmallCircle]", ",", GridBox[{
              {
                ButtonBox["\[FilledSmallCircle]"], 
                ButtonBox["\[FilledSmallCircle]"]},
              {
                ButtonBox["\[FilledSmallCircle]"], 
                ButtonBox["\[FilledSmallCircle]"]}
              }], ",", GridBox[{
              {
                ButtonBox[GridBox[{
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]},
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]}
                      }]], 
                ButtonBox[GridBox[{
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]},
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]}
                      }]]},
              {
                ButtonBox[GridBox[{
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]},
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]}
                      }]], 
                ButtonBox[GridBox[{
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]},
                      {
                        ButtonBox["\[FilledSmallCircle]"], 
                        ButtonBox["\[FilledSmallCircle]"]}
                      }]]}
              }]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["This creates another recursive typeset structure.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[SubsuperscriptBox[#, #, #]&, "X", 4] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      \({"X", X\_X\%X, \(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X\), 
        \(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X\)\)\_\(\(X\_X\%X\)\_\(X\_X\%X
                  \)\%\(X\_X\%X\)\)\%\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X
                  \)\), \(\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X\)\)\_\(\(X\_X
                      \%X\)\_\(X\_X\%X\)\%\(X\_X\%X\)\)\%\(\(X\_X\%X\)\_\(X\_X
                      \%X\)\%\(X\_X\%X\)\)\)\_\(\(\(X\_X\%X\)\_\(X\_X\%X
                      \)\%\(X\_X\%X\)\)\_\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X
                      \)\)\%\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X
                      \)\)\)\%\(\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X
                      \)\)\_\(\(X\_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X\)\)\%\(\(X
                      \_X\%X\)\_\(X\_X\%X\)\%\(X\_X\%X\)\)\)}\),
      DisplayForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating Box Structures", "Section"],

Cell[TextData[{
  "Here is a typical ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x\^12 - 1]\)], "Input"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 + x\^2)\)\ \((1 - x + x\^2)\)\ 
      \((1 + x + x\^2)\)\ \((1 - x\^2 + x\^4)\)\)], "Output"]
}, Open  ]],

Cell["This shows the box representation of the expression.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(boxes = ToBoxes[%]\)], "Input"],

Cell[BoxData[
    \(RowBox[{RowBox[{"(", RowBox[{RowBox[{"-", "1"}], "+", "x"}], ")"}], 
        " ", RowBox[{"(", RowBox[{"1", "+", "x"}], ")"}], " ", 
        RowBox[{"(", RowBox[{"1", "+", SuperscriptBox["x", "2"]}], ")"}], 
        " ", RowBox[{"(", 
            RowBox[{"1", "-", "x", "+", SuperscriptBox["x", "2"]}], ")"}], 
        " ", RowBox[{"(", 
            RowBox[{"1", "+", "x", "+", SuperscriptBox["x", "2"]}], ")"}], 
        " ", RowBox[{"(", 
            RowBox[{"1", "-", SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["x", "4"]}], ")"}]}]\)], "Output"]
}, Open  ]],

Cell["\<\
This replaces every superscript in the expression by an overscript.\
\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DisplayForm[boxes /. SuperscriptBox \[Rule] OverscriptBox]\)], "Input"],

Cell[BoxData[
    TagBox[
      "\(\((\(-1\) + x)\)\\ \((1 + x)\)\\ \((1 + x\&2)\)\\ \((1 - x + x\&2)\)\
\\          \((1 + x + x\&2)\)\\ \((1 - x\&2 + x\&4)\)\)",
      DisplayForm]], "Output"]
}, Open  ]],

Cell["This puts a frame around row boxes at every level.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DisplayForm[\(\((# /. a : RowBox[_] \[Rule] FrameBox[a])\)&\)//@boxes]
      \)], "Input"],

Cell[BoxData[
    TagBox[
      FrameBox[
        RowBox[{
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox[
                    RowBox[{
                      FrameBox[
                        FrameBox["\(-1\)"]], "+", "x"}]]], ")"}]]], " ", 
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox["\(1 + x\)"]], ")"}]]], " ", 
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox["\(1 + x\^2\)"]], ")"}]]], " ", 
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox["\(1 - x + x\^2\)"]], ")"}]]], " ", 
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox["\(1 + x + x\^2\)"]], ")"}]]], " ", 
          FrameBox[
            FrameBox[
              RowBox[{"(", 
                FrameBox[
                  FrameBox["\(1 - x\^2 + x\^4\)"]], ")"}]]]}]],
      DisplayForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing Styles", "Section"],

Cell["This makes characters with a sequence of different sizes.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[StyleBox["\[Alpha]", FontSize \[Rule] i], {i, 60}] // DisplayForm
      \)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          StyleBox["\[Alpha]",
            FontSize->1], ",", 
          StyleBox["\[Alpha]",
            FontSize->2], ",", 
          StyleBox["\[Alpha]",
            FontSize->3], ",", 
          StyleBox["\[Alpha]",
            FontSize->4], ",", 
          StyleBox["\[Alpha]",
            FontSize->5], ",", 
          StyleBox["\[Alpha]",
            FontSize->6], ",", 
          StyleBox["\[Alpha]",
            FontSize->7], ",", 
          StyleBox["\[Alpha]",
            FontSize->8], ",", 
          StyleBox["\[Alpha]",
            FontSize->9], ",", 
          StyleBox["\[Alpha]",
            FontSize->10], ",", 
          StyleBox["\[Alpha]",
            FontSize->11], ",", 
          StyleBox["\[Alpha]",
            FontSize->12], ",", 
          StyleBox["\[Alpha]",
            FontSize->13], ",", 
          StyleBox["\[Alpha]",
            FontSize->14], ",", 
          StyleBox["\[Alpha]",
            FontSize->15], ",", 
          StyleBox["\[Alpha]",
            FontSize->16], ",", 
          StyleBox["\[Alpha]",
            FontSize->17], ",", 
          StyleBox["\[Alpha]",
            FontSize->18], ",", 
          StyleBox["\[Alpha]",
            FontSize->19], ",", 
          StyleBox["\[Alpha]",
            FontSize->20], ",", 
          StyleBox["\[Alpha]",
            FontSize->21], ",", 
          StyleBox["\[Alpha]",
            FontSize->22], ",", 
          StyleBox["\[Alpha]",
            FontSize->23], ",", 
          StyleBox["\[Alpha]",
            FontSize->24], ",", 
          StyleBox["\[Alpha]",
            FontSize->25], ",", 
          StyleBox["\[Alpha]",
            FontSize->26], ",", 
          StyleBox["\[Alpha]",
            FontSize->27], ",", 
          StyleBox["\[Alpha]",
            FontSize->28], ",", 
          StyleBox["\[Alpha]",
            FontSize->29], ",", 
          StyleBox["\[Alpha]",
            FontSize->30], ",", 
          StyleBox["\[Alpha]",
            FontSize->31], ",", 
          StyleBox["\[Alpha]",
            FontSize->32], ",", 
          StyleBox["\[Alpha]",
            FontSize->33], ",", 
          StyleBox["\[Alpha]",
            FontSize->34], ",", 
          StyleBox["\[Alpha]",
            FontSize->35], ",", 
          StyleBox["\[Alpha]",
            FontSize->36], ",", 
          StyleBox["\[Alpha]",
            FontSize->37], ",", 
          StyleBox["\[Alpha]",
            FontSize->38], ",", 
          StyleBox["\[Alpha]",
            FontSize->39], ",", 
          StyleBox["\[Alpha]",
            FontSize->40], ",", 
          StyleBox["\[Alpha]",
            FontSize->41], ",", 
          StyleBox["\[Alpha]",
            FontSize->42], ",", 
          StyleBox["\[Alpha]",
            FontSize->43], ",", 
          StyleBox["\[Alpha]",
            FontSize->44], ",", 
          StyleBox["\[Alpha]",
            FontSize->45], ",", 
          StyleBox["\[Alpha]",
            FontSize->46], ",", 
          StyleBox["\[Alpha]",
            FontSize->47], ",", 
          StyleBox["\[Alpha]",
            FontSize->48], ",", 
          StyleBox["\[Alpha]",
            FontSize->49], ",", 
          StyleBox["\[Alpha]",
            FontSize->50], ",", 
          StyleBox["\[Alpha]",
            FontSize->51], ",", 
          StyleBox["\[Alpha]",
            FontSize->52], ",", 
          StyleBox["\[Alpha]",
            FontSize->53], ",", 
          StyleBox["\[Alpha]",
            FontSize->54], ",", 
          StyleBox["\[Alpha]",
            FontSize->55], ",", 
          StyleBox["\[Alpha]",
            FontSize->56], ",", 
          StyleBox["\[Alpha]",
            FontSize->57], ",", 
          StyleBox["\[Alpha]",
            FontSize->58], ",", 
          StyleBox["\[Alpha]",
            FontSize->59], ",", 
          StyleBox["\[Alpha]",
            FontSize->60]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["Here the size of the characters increases quadratically.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RowBox[
        Table[StyleBox["\[MathematicaIcon]", FontSize \[Rule] i\^2\/6.5], {i, 
            2, 23}]] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["\[MathematicaIcon]",
          FontSize->0.5625], 
        StyleBox["\[MathematicaIcon]",
          FontSize->1.375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->2.4375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->3.8125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->5.5], 
        StyleBox["\[MathematicaIcon]",
          FontSize->7.5], 
        StyleBox["\[MathematicaIcon]",
          FontSize->9.8125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->12.4375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->15.375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->18.5625], 
        StyleBox["\[MathematicaIcon]",
          FontSize->22.125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->26], 
        StyleBox["\[MathematicaIcon]",
          FontSize->30.125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->34.5625], 
        StyleBox["\[MathematicaIcon]",
          FontSize->39.375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->44.4375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->49.8125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->55.5], 
        StyleBox["\[MathematicaIcon]",
          FontSize->61.5], 
        StyleBox["\[MathematicaIcon]",
          FontSize->67.8125], 
        StyleBox["\[MathematicaIcon]",
          FontSize->74.4375], 
        StyleBox["\[MathematicaIcon]",
          FontSize->81.375]}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["This makes characters with a sequence of different hues.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
        StyleBox["\[MathematicaIcon]", FontColor \[Rule] Hue[i/75.5]], {i, 
          60}] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.079469, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.158938, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.238407, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.317876, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.397345, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.476814, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.556298, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.635767, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.715236, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.794705, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.874174, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[1, 0.953643, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.966888, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.887419, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.80795, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.728481, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.649012, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.569543, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.490059, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.41059, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.331121, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.251652, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.172183, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.092714, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.013245, 1, 0]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.066224]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.145693]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.225162]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.304631]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.3841]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.463569]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.543053]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.622522]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.701991]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.78146]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.860929]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 1, 0.940398]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.980133, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.900664, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.821195, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.741726, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.662257, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.582788, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.503319, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.423835, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.344366, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.264897, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.185428, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.105959, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0, 0.02649, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.052979, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.132448, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.211917, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.291386, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.370855, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.450324, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.529809, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.609277, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.688746, 0, 1]], ",", 
          StyleBox["\[MathematicaIcon]",
            FontColor->RGBColor[0.768215, 0, 1]]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
This function wraps a StyleBox with random option settings around \
any expression.\
\>", "Commentary"],

Cell[BoxData[
    \(RandomizedStyle[expr_] := 
      StyleBox[expr, FontSize \[Rule] Random[Integer, {8, 20}], 
        FontColor \[Rule] GrayLevel[Random[]/2], 
        FontSlant 
          \[Rule] {"Plain", "Italic"}\[LeftDoubleBracket]1 + 
              Random[Integer]\[RightDoubleBracket], 
        FontWeight 
          \[Rule] {"Plain", "Bold"}\[LeftDoubleBracket]1 + 
              Random[Integer]\[RightDoubleBracket]]\)], "Input"],

Cell["\<\
Here is the result of applying randomized styles to a string of \
characters.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print[
        RowBox[RandomizedStyle/@Characters["This text looks strange"]] // 
          DisplayForm], {5}]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["T",
          FontSize->11,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.381643]], 
        StyleBox["h",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.421393]], 
        StyleBox["i",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.469642]], 
        StyleBox["s",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.24654]], 
        StyleBox[" ",
          FontSize->11,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.318791]], 
        StyleBox["t",
          FontSize->20,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.068147]], 
        StyleBox["e",
          FontSize->8,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.391348]], 
        StyleBox["x",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.49398]], 
        StyleBox["t",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.301549]], 
        StyleBox[" ",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.246418]], 
        StyleBox["l",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.338674]], 
        StyleBox["o",
          FontSize->20,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.020584]], 
        StyleBox["o",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.293919]], 
        StyleBox["k",
          FontSize->9,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.242023]], 
        StyleBox["s",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.389487]], 
        StyleBox[" ",
          FontSize->19,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.49865]], 
        StyleBox["s",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.027634]], 
        StyleBox["t",
          FontSize->15,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.270848]], 
        StyleBox["r",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.220264]], 
        StyleBox["a",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.013336]], 
        StyleBox["n",
          FontSize->12,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.477104]], 
        StyleBox["g",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.073838]], 
        StyleBox["e",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.462013]]}],
      DisplayForm]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["T",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.107012]], 
        StyleBox["h",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.095445]], 
        StyleBox["i",
          FontSize->11,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.152453]], 
        StyleBox["s",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.492363]], 
        StyleBox[" ",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.360479]], 
        StyleBox["t",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.276661]], 
        StyleBox["e",
          FontSize->12,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.084306]], 
        StyleBox["x",
          FontSize->13,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.101015]], 
        StyleBox["t",
          FontSize->13,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.366491]], 
        StyleBox[" ",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.475105]], 
        StyleBox["l",
          FontSize->9,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.337881]], 
        StyleBox["o",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.262333]], 
        StyleBox["o",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.345907]], 
        StyleBox["k",
          FontSize->15,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.181186]], 
        StyleBox["s",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.095857]], 
        StyleBox[" ",
          FontSize->15,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.372854]], 
        StyleBox["s",
          FontSize->18,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.347265]], 
        StyleBox["t",
          FontSize->18,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.153567]], 
        StyleBox["r",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.325002]], 
        StyleBox["a",
          FontSize->13,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.15259]], 
        StyleBox["n",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.333913]], 
        StyleBox["g",
          FontSize->8,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.176455]], 
        StyleBox["e",
          FontSize->12,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.251164]]}],
      DisplayForm]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["T",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.190585]], 
        StyleBox["h",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.226902]], 
        StyleBox["i",
          FontSize->17,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.08101]], 
        StyleBox["s",
          FontSize->17,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.098726]], 
        StyleBox[" ",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.19823]], 
        StyleBox["t",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.36643]], 
        StyleBox["e",
          FontSize->12,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.304356]], 
        StyleBox["x",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.01442]], 
        StyleBox["t",
          FontSize->19,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.097215]], 
        StyleBox[" ",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.499931]], 
        StyleBox["l",
          FontSize->18,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.329244]], 
        StyleBox["o",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.176532]], 
        StyleBox["o",
          FontSize->11,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.334874]], 
        StyleBox["k",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.154025]], 
        StyleBox["s",
          FontSize->9,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.148058]], 
        StyleBox[" ",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.080674]], 
        StyleBox["s",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.462028]], 
        StyleBox["t",
          FontSize->19,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.306767]], 
        StyleBox["r",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.494499]], 
        StyleBox["a",
          FontSize->9,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.255665]], 
        StyleBox["n",
          FontSize->13,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.309422]], 
        StyleBox["g",
          FontSize->13,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.472847]], 
        StyleBox["e",
          FontSize->15,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.318044]]}],
      DisplayForm]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["T",
          FontSize->9,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.004501]], 
        StyleBox["h",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.118837]], 
        StyleBox["i",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.245945]], 
        StyleBox["s",
          FontSize->15,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.237034]], 
        StyleBox[" ",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.405783]], 
        StyleBox["t",
          FontSize->20,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.420615]], 
        StyleBox["e",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.379522]], 
        StyleBox["x",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.432685]], 
        StyleBox["t",
          FontSize->14,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.391363]], 
        StyleBox[" ",
          FontSize->16,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.3234]], 
        StyleBox["l",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.379583]], 
        StyleBox["o",
          FontSize->20,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.103441]], 
        StyleBox["o",
          FontSize->11,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.214817]], 
        StyleBox["k",
          FontSize->17,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.488533]], 
        StyleBox["s",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.225559]], 
        StyleBox[" ",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.455375]], 
        StyleBox["s",
          FontSize->13,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.134142]], 
        StyleBox["t",
          FontSize->11,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.026505]], 
        StyleBox["r",
          FontSize->8,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.418799]], 
        StyleBox["a",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.460868]], 
        StyleBox["n",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.37847]], 
        StyleBox["g",
          FontSize->10,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.217075]], 
        StyleBox["e",
          FontSize->16,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.445945]]}],
      DisplayForm]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox["T",
          FontSize->8,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.14284]], 
        StyleBox["h",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.373983]], 
        StyleBox["i",
          FontSize->15,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.098238]], 
        StyleBox["s",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.199985]], 
        StyleBox[" ",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.405798]], 
        StyleBox["t",
          FontSize->12,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.468193]], 
        StyleBox["e",
          FontSize->18,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.17763]], 
        StyleBox["x",
          FontSize->11,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.32047]], 
        StyleBox["t",
          FontSize->15,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.473121]], 
        StyleBox[" ",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.076844]], 
        StyleBox["l",
          FontSize->11,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.354223]], 
        StyleBox["o",
          FontSize->17,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.440879]], 
        StyleBox["o",
          FontSize->9,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.36968]], 
        StyleBox["k",
          FontSize->18,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.36202]], 
        StyleBox["s",
          FontSize->19,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.365698]], 
        StyleBox[" ",
          FontSize->19,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.215305]], 
        StyleBox["s",
          FontSize->9,
          FontWeight->"Plain",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.414313]], 
        StyleBox["t",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.227878]], 
        StyleBox["r",
          FontSize->14,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.339193]], 
        StyleBox["a",
          FontSize->17,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.296513]], 
        StyleBox["n",
          FontSize->15,
          FontWeight->"Plain",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.453437]], 
        StyleBox["g",
          FontSize->12,
          FontWeight->"Bold",
          FontSlant->"Plain",
          FontColor->GrayLevel[0.349401]], 
        StyleBox["e",
          FontSize->13,
          FontWeight->"Bold",
          FontSlant->"Italic",
          FontColor->GrayLevel[0.122118]]}],
      DisplayForm]], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Coloring Expressions", "Section"],

Cell["\<\
Here is a sequence of expressions colored with progressively \
different hues.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
        StyleBox[ToBoxes[Factor[x\^i - 1]], Background \[Rule] Hue[i\/12.]], {
          i, 12}] // DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          StyleBox["\(\(-1\) + x\)",
            Background->RGBColor[1, 0.499992, 0]], ",", 
          StyleBox["\(\((\(-1\) + x)\)\\ \((1 + x)\)\)",
            Background->RGBColor[1, 1, 0]], ",", 
          StyleBox["\(\((\(-1\) + x)\)\\ \((1 + x + x\^2)\)\)",
            Background->RGBColor[0.500008, 1, 0]], ",", 
          StyleBox["\(\((\(-1\) + x)\)\\ \((1 + x)\)\\ \((1 + x\^2)\)\)",
            Background->RGBColor[0, 1, 0]], ",", 
          StyleBox["\(\((\(-1\) + x)\)\\ \((1 + x + x\^2 + x\^3 + x\^4)\)\)",
            Background->RGBColor[0, 1, 0.500008]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\ \((1 + x)\)\\ \((1 - x + x\^2)\)\\          \
      \((1 + x + x\^2)\)\)",
            Background->RGBColor[0, 1, 1]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\                \((1 + x + x\^2 + x\^3 + \
x\^4 + x\^5 + x\^6)\)\)",
            Background->RGBColor[0, 0.500008, 1]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\ \((1 + x)\)\\ \((1 + x\^2)\)\\ \((1 + x\^4)\
\)\)",
            Background->RGBColor[0, 0, 1]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\ \((1 + x + x\^2)\)\\ \((1 + x\^3 + \
x\^6)\)\)",
            Background->RGBColor[0.500008, 0, 1]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\ \((1 + x)\)\\                \((1 - x + \
x\^2 - x\^3 + x\^4)\)\\                \((1 + x + x\^2 + x\^3 + x\^4)\)\)",
            Background->RGBColor[1, 0, 1]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\                \((1 + x + x\^2 + x\^3 + \
x\^4 + x\^5 + x\^6 + x\^7 + x\^8 +                    x\^9 + x\^10)\)\)",
            Background->RGBColor[1, 0, 0.499992]], ",", 
          
          StyleBox[
            "\(\((\(-1\) + x)\)\\ \((1 + x)\)\\ \((1 + x\^2)\)\\              \
  \((1 - x + x\^2)\)\\ \((1 + x + x\^2)\)\\ \((1 - x\^2 + x\^4)\)\)",
            Background->RGBColor[1, 0, 0]]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
This generates a list of colors, using each color as the background \
for its name.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Needs["\<Graphics`Colors`\>"]\)], "Input"],

Cell[BoxData[
    \(RowBox[
        \(StyleBox[AdjustmentBox[#, BoxMargins -> {{0, 0}, {1, 1}}], 
              Background -> ToExpression[#], FontSize -> 10]&\)/@AllColors]
         // DisplayForm\)], "Input",
  CellGroupingRules->"OutputGrouping"],

Cell[BoxData[
    TagBox[
      RowBox[{
        StyleBox[
          AdjustmentBox["AliceBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.941207, 0.972503, 1]], 
        StyleBox[
          AdjustmentBox["AlizarinCrimson",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.149996, 0.209995]], 
        StyleBox[
          AdjustmentBox["Antique",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.980575, 0.922332, 0.844663]], 
        StyleBox[
          AdjustmentBox["Apricot",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.340002, 0.129992]], 
        StyleBox[
          AdjustmentBox["Aquamarine",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.497993, 1, 0.831403]], 
        StyleBox[
          AdjustmentBox["AureolineYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.659998, 0.140002]], 
        StyleBox[
          AdjustmentBox["Azure",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.941741, 1, 1]], 
        StyleBox[
          AdjustmentBox["Banana",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.81001, 0.340002]], 
        StyleBox[
          AdjustmentBox["Beige",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.640009, 0.580011, 0.500008]], 
        StyleBox[
          AdjustmentBox["Bisque",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.898054, 0.771847]], 
        StyleBox[
          AdjustmentBox["Black",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0]], 
        StyleBox[
          AdjustmentBox["BlanchedAlmond",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.921599, 0.803906]], 
        StyleBox[
          AdjustmentBox["Blue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0, 1]], 
        StyleBox[
          AdjustmentBox["BlueViolet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.541207, 0.168597, 0.886305]], 
        StyleBox[
          AdjustmentBox["Brick",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.61001, 0.4, 0.119997]], 
        StyleBox[
          AdjustmentBox["Brown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.500008, 0.164691, 0.164691]], 
        StyleBox[
          AdjustmentBox["BrownOadder",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.859998, 0.159991, 0.159991]], 
        StyleBox[
          AdjustmentBox["BrownOchre",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.530007, 0.259998, 0.119997]], 
        StyleBox[
          AdjustmentBox["Burlywood",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.870604, 0.721599, 0.529412]], 
        StyleBox[
          AdjustmentBox["BurntSienna",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.540002, 0.209995, 0.0599985]], 
        StyleBox[
          AdjustmentBox["BurntUmber",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.540002, 0.2, 0.140002]], 
        StyleBox[
          AdjustmentBox["CadetBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.372488, 0.619608, 0.627512]], 
        StyleBox[
          AdjustmentBox["CadmiumLemon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.889998, 0.00999466]], 
        StyleBox[
          AdjustmentBox["CadmiumOrange",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.379995, 0.00999466]], 
        StyleBox[
          AdjustmentBox["CadmiumYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.6, 0.0699931]], 
        StyleBox[
          AdjustmentBox["Carrot",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.930007, 0.570001, 0.129992]], 
        StyleBox[
          AdjustmentBox["Cerulean",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.0200046, 0.719997, 0.8]], 
        StyleBox[
          AdjustmentBox["Chartreuse",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.497993, 1, 0]], 
        StyleBox[
          AdjustmentBox["Chocolate",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.823499, 0.411795, 0.117601]], 
        StyleBox[
          AdjustmentBox["ChromeOxideGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.4, 0.500008, 0.0800031]], 
        StyleBox[
          AdjustmentBox["CinnabarGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.379995, 0.700008, 0.159991]], 
        StyleBox[
          AdjustmentBox["Cobalt",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.239994, 0.349996, 0.670008]], 
        StyleBox[
          AdjustmentBox["CobaltGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.239994, 0.570001, 0.250004]], 
        StyleBox[
          AdjustmentBox["ColdGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.500008, 0.540002, 0.530007]], 
        StyleBox[
          AdjustmentBox["Coral",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.497993, 0.313695]], 
        StyleBox[
          AdjustmentBox["CornflowerBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.392187, 0.584314, 0.929397]], 
        StyleBox[
          AdjustmentBox["Cornsilk",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.972503, 0.862699]], 
        StyleBox[
          AdjustmentBox["Cyan",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 1, 1]], 
        StyleBox[
          AdjustmentBox["CyanWhite",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.878401, 1, 1]], 
        StyleBox[
          AdjustmentBox["DarkGoldenrod",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.721599, 0.525505, 0.0431067]], 
        StyleBox[
          AdjustmentBox["DarkGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.392187, 0]], 
        StyleBox[
          AdjustmentBox["DarkKhaki",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.741207, 0.717601, 0.419593]], 
        StyleBox[
          AdjustmentBox["DarkOliveGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.333288, 0.419593, 0.184298]], 
        StyleBox[
          AdjustmentBox["DarkOrange",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.549004, 0]], 
        StyleBox[
          AdjustmentBox["DarkOrchid",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.6, 0.196094, 0.8]], 
        StyleBox[
          AdjustmentBox["DarkSeaGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.5608, 0.737301, 0.5608]], 
        StyleBox[
          AdjustmentBox["DarkSlateBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.282399, 0.2392, 0.545113]], 
        StyleBox[
          AdjustmentBox["DarkSlateGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.184298, 0.309789, 0.309789]], 
        StyleBox[
          AdjustmentBox["DarkTurquoise",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.807797, 0.819608]], 
        StyleBox[
          AdjustmentBox["DarkViolet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.580407, 0, 0.827497]], 
        StyleBox[
          AdjustmentBox["DeepCadmiumRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.0899977, 0.0500038]], 
        StyleBox[
          AdjustmentBox["DeepCobaltViolet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.570001, 0.129992, 0.620005]], 
        StyleBox[
          AdjustmentBox["DeepMadderLake",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.179995, 0.18999]], 
        StyleBox[
          AdjustmentBox["DeepNaplesYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.659998, 0.0699931]], 
        StyleBox[
          AdjustmentBox["DeepOchre",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.449989, 0.239994, 0.0999924]], 
        StyleBox[
          AdjustmentBox["DeepPink",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.0784009, 0.576501]], 
        StyleBox[
          AdjustmentBox["DeepSkyBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.749004, 1]], 
        StyleBox[
          AdjustmentBox["DimGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0.333333]], 
        StyleBox[
          AdjustmentBox["DodgerBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.117601, 0.564706, 1]], 
        StyleBox[
          AdjustmentBox["Eggshell",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.990005, 0.900008, 0.790005]], 
        StyleBox[
          AdjustmentBox["EmeraldGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.790005, 0.340002]], 
        StyleBox[
          AdjustmentBox["EnglishRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.829999, 0.239994, 0.0999924]], 
        StyleBox[
          AdjustmentBox["Firebrick",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.698009, 0.133303, 0.133303]], 
        StyleBox[
          AdjustmentBox["Floral",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.980407, 0.941207]], 
        StyleBox[
          AdjustmentBox["ForestGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.133303, 0.545113, 0.133303]], 
        StyleBox[
          AdjustmentBox["Gainsboro",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0.862699]], 
        StyleBox[
          AdjustmentBox["GeraniumLake",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.0699931, 0.18999]], 
        StyleBox[
          AdjustmentBox["Ghost",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.972503, 0.972503, 1]], 
        StyleBox[
          AdjustmentBox["Gold",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.843107, 0]], 
        StyleBox[
          AdjustmentBox["Goldenrod",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.854902, 0.647105, 0.125505]], 
        StyleBox[
          AdjustmentBox["GoldOchre",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.780011, 0.469993, 0.149996]], 
        StyleBox[
          AdjustmentBox["Gray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0.752911]], 
        StyleBox[
          AdjustmentBox["Green",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 1, 0]], 
        StyleBox[
          AdjustmentBox["GreenishUmber",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.239994, 0.0500038]], 
        StyleBox[
          AdjustmentBox["GreenYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.678401, 1, 0.184298]], 
        StyleBox[
          AdjustmentBox["Honeydew",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.941207, 1, 0.941207]], 
        StyleBox[
          AdjustmentBox["HotPink",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.411795, 0.705898]], 
        StyleBox[
          AdjustmentBox["IndianRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.689998, 0.0899977, 0.119997]], 
        StyleBox[
          AdjustmentBox["Indigo",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.0299992, 0.179995, 0.329992]], 
        StyleBox[
          AdjustmentBox["Ivory",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 1, 0.941207]], 
        StyleBox[
          AdjustmentBox["IvoryBlack",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.159991, 0.140002, 0.129992]], 
        StyleBox[
          AdjustmentBox["Khaki",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.941207, 0.902007, 0.549004]], 
        StyleBox[
          AdjustmentBox["LampBlack",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.179995, 0.280003, 0.229999]], 
        StyleBox[
          AdjustmentBox["Lavender",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.902007, 0.902007, 0.980407]], 
        StyleBox[
          AdjustmentBox["LavenderBlush",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.941207, 0.9608]], 
        StyleBox[
          AdjustmentBox["LawnGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.48629, 0.988205, 0]], 
        StyleBox[
          AdjustmentBox["LemonChiffon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.980407, 0.803906]], 
        StyleBox[
          AdjustmentBox["LightBeige",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.9608, 0.9608, 0.862699]], 
        StyleBox[
          AdjustmentBox["LightBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.678401, 0.847105, 0.902007]], 
        StyleBox[
          AdjustmentBox["LightCadmiumRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.00999466, 0.0500038]], 
        StyleBox[
          AdjustmentBox["LightCadmiumYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.689998, 0.0599985]], 
        StyleBox[
          AdjustmentBox["LightCoral",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.941207, 0.502007, 0.502007]], 
        StyleBox[
          AdjustmentBox["LightGoldenrod",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.933303, 0.866697, 0.509789]], 
        StyleBox[
          AdjustmentBox["LightGoldenrod",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.933303, 0.866697, 0.509789]], 
        StyleBox[
          AdjustmentBox["LightGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0.666667]], 
        StyleBox[
          AdjustmentBox["LightPink",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.71371, 0.756909]], 
        StyleBox[
          AdjustmentBox["LightSalmon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.627512, 0.478386]], 
        StyleBox[
          AdjustmentBox["LightSeaGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.125505, 0.698009, 0.666712]], 
        StyleBox[
          AdjustmentBox["LightSkyBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.529412, 0.807797, 0.980407]], 
        StyleBox[
          AdjustmentBox["LightSlateBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.517601, 0.4392, 1]], 
        StyleBox[
          AdjustmentBox["LightSlateGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.466697, 0.533303, 0.6]], 
        StyleBox[
          AdjustmentBox["LightSteelBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.690211, 0.768597, 0.870604]], 
        StyleBox[
          AdjustmentBox["LightViridian",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.429999, 1, 0.439994]], 
        StyleBox[
          AdjustmentBox["LightYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 1, 0.878401]], 
        StyleBox[
          AdjustmentBox["LimeGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.196094, 0.803906, 0.196094]], 
        StyleBox[
          AdjustmentBox["Linen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.980407, 0.941207, 0.902007]], 
        StyleBox[
          AdjustmentBox["Magenta",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0, 1]], 
        StyleBox[
          AdjustmentBox["ManganeseBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.00999466, 0.659998, 0.620005]], 
        StyleBox[
          AdjustmentBox["Maroon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.690211, 0.18819, 0.376501]], 
        StyleBox[
          AdjustmentBox["MarsOrange",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.590005, 0.269993, 0.0800031]], 
        StyleBox[
          AdjustmentBox["MarsYellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.439994, 0.0999924]], 
        StyleBox[
          AdjustmentBox["MediumAquamarine",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.4, 0.803906, 0.666712]], 
        StyleBox[
          AdjustmentBox["MediumBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0, 0.803906]], 
        StyleBox[
          AdjustmentBox["MediumOrchid",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.729412, 0.333288, 0.827497]], 
        StyleBox[
          AdjustmentBox["MediumPurple",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.576501, 0.4392, 0.858808]], 
        StyleBox[
          AdjustmentBox["MediumSeaGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.235294, 0.702007, 0.443091]], 
        StyleBox[
          AdjustmentBox["MediumSlateBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.482399, 0.407797, 0.933303]], 
        StyleBox[
          AdjustmentBox["MediumSpringGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.980407, 0.603906]], 
        StyleBox[
          AdjustmentBox["MediumTurquoise",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.282399, 0.819608, 0.8]], 
        StyleBox[
          AdjustmentBox["MediumVioletRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.780407, 0.0823987, 0.521614]], 
        StyleBox[
          AdjustmentBox["Melon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.659998, 0.409995]], 
        StyleBox[
          AdjustmentBox["MidnightBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.0979934, 0.0979934, 0.4392]], 
        StyleBox[
          AdjustmentBox["Mint",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.740001, 0.990005, 0.790005]], 
        StyleBox[
          AdjustmentBox["MintCream",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.9608, 1, 0.980407]], 
        StyleBox[
          AdjustmentBox["MistyRose",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.894102, 0.882399]], 
        StyleBox[
          AdjustmentBox["Moccasin",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.894102, 0.709804]], 
        StyleBox[
          AdjustmentBox["Navajo",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.870604, 0.678401]], 
        StyleBox[
          AdjustmentBox["Navy",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0, 0.502007]], 
        StyleBox[
          AdjustmentBox["NavyBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0, 0.502007]], 
        StyleBox[
          AdjustmentBox["Oak",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.489998, 0.250004]], 
        StyleBox[
          AdjustmentBox["OldLace",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.992203, 0.9608, 0.902007]], 
        StyleBox[
          AdjustmentBox["Olive",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.229999, 0.370001, 0.170001]], 
        StyleBox[
          AdjustmentBox["OliveDrab",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.419593, 0.556909, 0.137301]], 
        StyleBox[
          AdjustmentBox["Orange",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.500008, 0]], 
        StyleBox[
          AdjustmentBox["OrangeRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.270604, 0]], 
        StyleBox[
          AdjustmentBox["Orchid",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.854902, 0.4392, 0.8392]], 
        StyleBox[
          AdjustmentBox["PaleGoldenrod",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.933303, 0.909804, 0.666712]], 
        StyleBox[
          AdjustmentBox["PaleGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.596109, 0.984298, 0.596109]], 
        StyleBox[
          AdjustmentBox["PaleTurquoise",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.686305, 0.933303, 0.933303]], 
        StyleBox[
          AdjustmentBox["PaleVioletRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.858808, 0.4392, 0.576501]], 
        StyleBox[
          AdjustmentBox["PapayaWhip",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.937301, 0.835309]], 
        StyleBox[
          AdjustmentBox["Peach",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.439994, 0.259998, 0.259998]], 
        StyleBox[
          AdjustmentBox["PeachPuff",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.854902, 0.725505]], 
        StyleBox[
          AdjustmentBox["Peacock",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.2, 0.629999, 0.790005]], 
        StyleBox[
          AdjustmentBox["PermanentGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.0399939, 0.790005, 0.170001]], 
        StyleBox[
          AdjustmentBox["PermanentRedViolet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.859998, 0.149996, 0.269993]], 
        StyleBox[
          AdjustmentBox["Peru",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.803906, 0.521614, 0.247089]], 
        StyleBox[
          AdjustmentBox["Pink",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.752911, 0.796109]], 
        StyleBox[
          AdjustmentBox["Plum",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.866697, 0.627512, 0.866697]], 
        StyleBox[
          AdjustmentBox["PowderBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.690211, 0.878401, 0.902007]], 
        StyleBox[
          AdjustmentBox["PrussianBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.179995, 0.179995, 0.310002]], 
        StyleBox[
          AdjustmentBox["Purple",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.627512, 0.125505, 0.941207]], 
        StyleBox[
          AdjustmentBox["Raspberry",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.530007, 0.149996, 0.340002]], 
        StyleBox[
          AdjustmentBox["RawSienna",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.780011, 0.379995, 0.0800031]], 
        StyleBox[
          AdjustmentBox["RawUmber",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.449989, 0.289998, 0.0699931]], 
        StyleBox[
          AdjustmentBox["Red",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0, 0]], 
        StyleBox[
          AdjustmentBox["RoseMadder",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.209995, 0.219989]], 
        StyleBox[
          AdjustmentBox["RosyBrown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.737301, 0.5608, 0.5608]], 
        StyleBox[
          AdjustmentBox["RoyalBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.254902, 0.411795, 0.882399]], 
        StyleBox[
          AdjustmentBox["SaddleBrown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.545113, 0.270604, 0.0744945]], 
        StyleBox[
          AdjustmentBox["Salmon",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.980407, 0.502007, 0.447089]], 
        StyleBox[
          AdjustmentBox["SandyBrown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.956893, 0.643107, 0.376501]], 
        StyleBox[
          AdjustmentBox["SapGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.18999, 0.500008, 0.0800031]], 
        StyleBox[
          AdjustmentBox["SeaGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.180392, 0.545113, 0.341192]], 
        StyleBox[
          AdjustmentBox["Seashell",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.9608, 0.933303]], 
        StyleBox[
          AdjustmentBox["Sepia",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.370001, 0.149996, 0.0699931]], 
        StyleBox[
          AdjustmentBox["Sienna",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.627512, 0.321599, 0.176501]], 
        StyleBox[
          AdjustmentBox["SkyBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.529412, 0.807797, 0.921599]], 
        StyleBox[
          AdjustmentBox["SlateBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.415686, 0.352895, 0.803906]], 
        StyleBox[
          AdjustmentBox["SlateGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.4392, 0.502007, 0.564706]], 
        StyleBox[
          AdjustmentBox["Smoke",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[0.9608]], 
        StyleBox[
          AdjustmentBox["Snow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.980407, 0.980407]], 
        StyleBox[
          AdjustmentBox["SpringGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 1, 0.497993]], 
        StyleBox[
          AdjustmentBox["SteelBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.274495, 0.509789, 0.705898]], 
        StyleBox[
          AdjustmentBox["TerreVerte",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.219989, 0.370001, 0.0599985]], 
        StyleBox[
          AdjustmentBox["Thistle",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.847105, 0.749004, 0.847105]], 
        StyleBox[
          AdjustmentBox["Titanium",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.990005, 1, 0.940002]], 
        StyleBox[
          AdjustmentBox["Tomato",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 0.38819, 0.278401]], 
        StyleBox[
          AdjustmentBox["Turquoise",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.250996, 0.878401, 0.815702]], 
        StyleBox[
          AdjustmentBox["TurquoiseBlue",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0, 0.780011, 0.550011]], 
        StyleBox[
          AdjustmentBox["Ultramarine",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.0699931, 0.0399939, 0.560006]], 
        StyleBox[
          AdjustmentBox["UltramarineViolet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.359991, 0.140002, 0.429999]], 
        StyleBox[
          AdjustmentBox["VanDykeBrown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.370001, 0.149996, 0.0200046]], 
        StyleBox[
          AdjustmentBox["VenetianRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.829999, 0.0999924, 0.119997]], 
        StyleBox[
          AdjustmentBox["Violet",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.560006, 0.370001, 0.6]], 
        StyleBox[
          AdjustmentBox["VioletRed",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.815702, 0.125505, 0.564706]], 
        StyleBox[
          AdjustmentBox["WarmGray",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.500008, 0.500008, 0.409995]], 
        StyleBox[
          AdjustmentBox["Wheat",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.9608, 0.870604, 0.702007]], 
        StyleBox[
          AdjustmentBox["White",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->GrayLevel[1]], 
        StyleBox[
          AdjustmentBox["Yellow",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[1, 1, 0]], 
        StyleBox[
          AdjustmentBox["YellowBrown",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.859998, 0.579995, 0.439994]], 
        StyleBox[
          AdjustmentBox["YellowGreen",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.603906, 0.803906, 0.196094]], 
        StyleBox[
          AdjustmentBox["YellowOchre",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.889998, 0.510002, 0.0899977]], 
        StyleBox[
          AdjustmentBox["Zinc",
            BoxMargins->{{0, 0}, {1, 1}}],
          FontSize->10,
          Background->RGBColor[0.990005, 0.970001, 1]]}],
      DisplayForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Coloring Box Structures", "Section"],

Cell["\<\
This defines a function that randomly colors boxes in an expression.\
\>", "Commentary"],

Cell[BoxData[
    \(RandomColoring[expr_] := 
      \(\((# /. 
              x : \((_RowBox | _FractionBox | _OverscriptBox | _RadicalBox
                       | _SqrtBox | _SubscriptBox | _SubsuperscriptBox
                       | _SuperscriptBox | _UnderoverscriptBox
                       | _UnderscriptBox)\) :> 
                StyleBox[x, Background \[Rule] Hue[Random[], .5]])\)&\)//@
        ToBoxes[expr]\)], "Input"],

Cell["Here is an example.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomColoring[\[Integral]\(1\/\(x\^5 - 1\)\) \[DifferentialD]x] // 
      DisplayForm\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{
          StyleBox[
            RowBox[{
              StyleBox[
                RowBox[{"-", 
                  StyleBox[\(1\/5\),
                    Background->RGBColor[0.500008, 1, 0.788602]]}],
                Background->RGBColor[1, 0.530205, 0.500008]], " ", 
              StyleBox[
                SqrtBox[
                  StyleBox[
                    RowBox[{
                      StyleBox[\(1\/2\),
                        Background->RGBColor[0.500008, 0.639643, 1]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{"5", "+", 
                              StyleBox[\(\@5\),
                                Background->RGBColor[0.91368, 0.500008, 1]]}],
                            
                            Background->RGBColor[1, 0.500008, 0.64625]], 
                          ")"}],
                        Background->RGBColor[0.500008, 0.54139, 1]]}],
                    Background->RGBColor[0.500008, 0.688136, 1]]],
                Background->RGBColor[0.694362, 1, 0.500008]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      StyleBox[
                        SqrtBox[
                          StyleBox[
                            FractionBox["2", 
                              StyleBox[
                                RowBox[{"5", "+", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[1, 0.555795, 
                                    0.500008]]}],
                                Background->RGBColor[1, 0.96524, 0.500008]]],
                            Background->RGBColor[0.648386, 0.500008, 1]]],
                        Background->RGBColor[1, 0.500008, 0.918364]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{
                                  StyleBox[\(1\/4\),
                                    Background->RGBColor[0.500008, 1, 
                                    0.787198]], " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[
                                        RowBox[{"1", "-", 
                                        StyleBox[\(\@5\),
                                        Background->RGBColor[0.980194, 
                                        0.500008, 1]]}],
                                        Background->RGBColor[0.517952, 
                                        0.500008, 1]], ")"}],
                                    Background->RGBColor[1, 0.500008, 
                                    0.535378]]}],
                                Background->RGBColor[0.935378, 0.500008, 1]], 
                              "+", "x"}],
                            Background->RGBColor[0.949065, 1, 0.500008]], 
                          ")"}],
                        Background->RGBColor[0.500008, 0.694041, 1]]}],
                    Background->RGBColor[0.526116, 0.500008, 1]], "]"}],
                Background->RGBColor[0.500008, 0.529671, 1]]}],
            Background->RGBColor[1, 0.500008, 0.660182]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/5\),
                Background->RGBColor[0.837842, 0.500008, 1]], " ", 
              StyleBox[
                SqrtBox[
                  StyleBox[
                    RowBox[{
                      StyleBox[\(1\/2\),
                        Background->RGBColor[0.500008, 0.751263, 1]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{"5", "-", 
                              StyleBox[\(\@5\),
                                Background->RGBColor[0.876768, 0.500008, 
                                1]]}],
                            Background->RGBColor[0.500008, 0.893523, 1]], 
                          ")"}],
                        Background->RGBColor[1, 0.614435, 0.500008]]}],
                    Background->RGBColor[0.500008, 0.858137, 1]]],
                Background->RGBColor[0.500008, 1, 0.718547]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      StyleBox[
                        SqrtBox[
                          StyleBox[
                            FractionBox["2", 
                              StyleBox[
                                RowBox[{"5", "-", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[1, 0.500008, 
                                    0.727565]]}],
                                Background->RGBColor[0.500008, 1, 0.590921]]],
                            
                            Background->RGBColor[1, 0.861799, 0.500008]]],
                        Background->RGBColor[1, 0.62855, 0.500008]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{
                                  StyleBox[\(1\/4\),
                                    Background->RGBColor[0.86537, 0.500008, 
                                    1]], " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[
                                        RowBox[{"1", "+", 
                                        StyleBox[\(\@5\),
                                        Background->RGBColor[0.500008, 1, 
                                        0.835691]]}],
                                        Background->RGBColor[0.563729, 1, 
                                        0.500008]], ")"}],
                                    Background->RGBColor[0.500008, 0.842573, 
                                    1]]}],
                                Background->RGBColor[0.500008, 0.764981, 1]], 
                              "+", "x"}],
                            Background->RGBColor[0.780652, 0.500008, 1]], 
                          ")"}],
                        Background->RGBColor[0.815625, 1, 0.500008]]}],
                    Background->RGBColor[0.500008, 0.961608, 1]], "]"}],
                Background->RGBColor[0.500008, 0.734035, 1]]}],
            Background->RGBColor[0.961578, 0.500008, 1]], "+", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/5\),
                Background->RGBColor[1, 0.500008, 0.636774]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{
                      StyleBox[\(-1\),
                        Background->RGBColor[0.700511, 1, 0.500008]], "+", 
                      "x"}],
                    Background->RGBColor[0.859648, 1, 0.500008]], "]"}],
                Background->RGBColor[0.900725, 0.500008, 1]]}],
            Background->RGBColor[0.522652, 1, 0.500008]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/20\),
                Background->RGBColor[1, 0.688899, 0.500008]], " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[
                    RowBox[{"1", "-", 
                      StyleBox[\(\@5\),
                        Background->RGBColor[0.834302, 1, 0.500008]]}],
                    Background->RGBColor[0.500008, 0.913207, 1]], ")"}],
                Background->RGBColor[0.500008, 1, 0.758556]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{
                          StyleBox[\(1\/2\),
                            Background->RGBColor[1, 0.500008, 0.663645]], " ",
                           
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[
                                RowBox[{"1", "-", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[0.500008, 1, 
                                    0.554894]]}],
                                Background->RGBColor[0.550469, 0.500008, 1]], 
                              ")"}],
                            Background->RGBColor[0.648386, 1, 0.500008]], " ",
                           "x"}],
                        Background->RGBColor[0.500008, 1, 0.849531]], "+", 
                      StyleBox[\(x\^2\),
                        Background->RGBColor[1, 0.552117, 0.500008]]}],
                    Background->RGBColor[0.500008, 1, 0.620478]], "]"}],
                Background->RGBColor[1, 0.500008, 0.654505]]}],
            Background->RGBColor[0.500008, 0.590311, 1]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/20\),
                Background->RGBColor[1, 0.932677, 0.500008]], " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[\(\@5\),
                        Background->RGBColor[0.586404, 0.500008, 1]]}],
                    Background->RGBColor[0.724163, 0.500008, 1]], ")"}],
                Background->RGBColor[0.500008, 0.95201, 1]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{
                          StyleBox[\(1\/2\),
                            Background->RGBColor[0.500008, 0.745022, 1]], " ",
                           
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[
                                RowBox[{"1", "+", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[1, 0.500008, 
                                    0.893416]]}],
                                Background->RGBColor[0.500008, 1, 0.774807]], 
                              ")"}],
                            Background->RGBColor[0.850523, 0.500008, 1]], " ",
                           "x"}],
                        Background->RGBColor[0.500008, 0.797147, 1]], "+", 
                      StyleBox[\(x\^2\),
                        Background->RGBColor[0.500008, 0.808759, 1]]}],
                    Background->RGBColor[0.500008, 1, 0.804974]], "]"}],
                Background->RGBColor[1, 0.847761, 0.500008]]}],
            Background->RGBColor[1, 0.500008, 0.715877]]}],
        Background->RGBColor[1, 0.949889, 0.500008]],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
This defines a function that colors row boxes according to depth.\
\>", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DepthColoring[expr_] := 
      Module[{b = ToBoxes[expr], d}, d = 2\ Depth[b]; 
        \(\((# /. 
                x : \((_RowBox)\) :> 
                  StyleBox[x, Background \[Rule] Hue[0.78\ Depth[x]/d, .5]])
              \)&\)//@b]\)], "Input"],

Cell[BoxData[
    \(DepthColoring[\[Integral]\(1\/\(x\^5 - 1\)\) \[DifferentialD]x] // 
      DisplayForm\)], "Input",
  CellGroupingRules->"OutputGrouping"],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{
          StyleBox[
            RowBox[{
              StyleBox[\(-\(1\/5\)\),
                Background->RGBColor[1, 0.734005, 0.500008]], " ", 
              SqrtBox[
                StyleBox[
                  RowBox[{\(1\/2\), " ", 
                    StyleBox[
                      RowBox[{"(", 
                        StyleBox[\(5 + \@5\),
                          Background->RGBColor[1, 0.734005, 0.500008]], ")"}],
                      
                      Background->RGBColor[1, 0.968002, 0.500008]]}],
                  Background->RGBColor[0.798001, 1, 0.500008]]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      SqrtBox[
                        FractionBox["2", 
                          StyleBox[\(5 + \@5\),
                            Background->RGBColor[1, 0.734005, 0.500008]]]], 
                      " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{\(1\/4\), " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[\(1 - \@5\),
                                        Background->RGBColor[1, 0.734005, 
                                        0.500008]], ")"}],
                                    Background->RGBColor[1, 0.968002, 
                                    0.500008]]}],
                                Background->RGBColor[0.798001, 1, 0.500008]], 
                              "+", "x"}],
                            Background->RGBColor[0.564004, 1, 0.500008]], 
                          ")"}],
                        Background->RGBColor[0.500008, 1, 0.669993]]}],
                    Background->RGBColor[0.500008, 1, 0.904005]], "]"}],
                Background->RGBColor[0.500008, 0.861997, 1]]}],
            Background->RGBColor[0.500008, 0.628, 1]], "-", 
          StyleBox[
            RowBox[{\(1\/5\), " ", 
              SqrtBox[
                StyleBox[
                  RowBox[{\(1\/2\), " ", 
                    StyleBox[
                      RowBox[{"(", 
                        StyleBox[\(5 - \@5\),
                          Background->RGBColor[1, 0.734005, 0.500008]], ")"}],
                      
                      Background->RGBColor[1, 0.968002, 0.500008]]}],
                  Background->RGBColor[0.798001, 1, 0.500008]]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      SqrtBox[
                        FractionBox["2", 
                          StyleBox[\(5 - \@5\),
                            Background->RGBColor[1, 0.734005, 0.500008]]]], 
                      " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{\(1\/4\), " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[\(1 + \@5\),
                                        Background->RGBColor[1, 0.734005, 
                                        0.500008]], ")"}],
                                    Background->RGBColor[1, 0.968002, 
                                    0.500008]]}],
                                Background->RGBColor[0.798001, 1, 0.500008]], 
                              "+", "x"}],
                            Background->RGBColor[0.564004, 1, 0.500008]], 
                          ")"}],
                        Background->RGBColor[0.500008, 1, 0.669993]]}],
                    Background->RGBColor[0.500008, 1, 0.904005]], "]"}],
                Background->RGBColor[0.500008, 0.861997, 1]]}],
            Background->RGBColor[0.500008, 0.628, 1]], "+", 
          StyleBox[
            RowBox[{\(1\/5\), " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{
                      StyleBox[\(-1\),
                        Background->RGBColor[1, 0.675502, 0.500008]], "+", 
                      "x"}],
                    Background->RGBColor[1, 0.909499, 0.500008]], "]"}],
                Background->RGBColor[0.856504, 1, 0.500008]]}],
            Background->RGBColor[0.622507, 1, 0.500008]], "-", 
          StyleBox[
            RowBox[{\(1\/20\), " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[\(1 - \@5\),
                    Background->RGBColor[1, 0.734005, 0.500008]], ")"}],
                Background->RGBColor[1, 0.968002, 0.500008]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{\(1\/2\), " ", 
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[\(1 - \@5\),
                                Background->RGBColor[1, 0.734005, 0.500008]], 
                              ")"}],
                            Background->RGBColor[1, 0.968002, 0.500008]], " ",
                           "x"}],
                        Background->RGBColor[0.798001, 1, 0.500008]], "+", 
                      \(x\^2\)}],
                    Background->RGBColor[0.564004, 1, 0.500008]], "]"}],
                Background->RGBColor[0.500008, 1, 0.669993]]}],
            Background->RGBColor[0.500008, 1, 0.904005]], "-", 
          StyleBox[
            RowBox[{\(1\/20\), " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[\(1 + \@5\),
                    Background->RGBColor[1, 0.734005, 0.500008]], ")"}],
                Background->RGBColor[1, 0.968002, 0.500008]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{\(1\/2\), " ", 
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[\(1 + \@5\),
                                Background->RGBColor[1, 0.734005, 0.500008]], 
                              ")"}],
                            Background->RGBColor[1, 0.968002, 0.500008]], " ",
                           "x"}],
                        Background->RGBColor[0.798001, 1, 0.500008]], "+", 
                      \(x\^2\)}],
                    Background->RGBColor[0.564004, 1, 0.500008]], "]"}],
                Background->RGBColor[0.500008, 1, 0.669993]]}],
            Background->RGBColor[0.500008, 1, 0.904005]]}],
        Background->RGBColor[0.605997, 0.500008, 1]],
      DisplayForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(boxtypes
       = {RowBox, FractionBox, OverscriptBox, RadicalBox, SqrtBox, 
        SubscriptBox, SubsuperscriptBox, SuperscriptBox, UnderoverscriptBox, 
        UnderscriptBox}; \)\)], "Input"],

Cell[BoxData[
    \(\(boxrules = 
      MapIndexed[
        \((#[x__] -> 
              StyleBox[#[x], 
                Background -> Hue[N[First[#2]/Length[boxtypes]], .8]])\)&, 
        boxtypes]; \)\)], "Input",
  CellGroupingRules->"OutputGrouping"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TypeColoring[expr_] := \((#1 /. boxrules&)\)//@ToBoxes[expr]\)], "Input"],

Cell[BoxData[
    \(TypeColoring[\[Integral]\(1\/\(x\^5 - 1\)\) \[DifferentialD]x] // 
      DisplayForm\)], "Input",
  CellGroupingRules->"OutputGrouping"],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{
          StyleBox[
            RowBox[{
              StyleBox[
                RowBox[{"-", 
                  StyleBox[\(1\/5\),
                    Background->RGBColor[0.839994, 1, 0.2]]}],
                Background->RGBColor[1, 0.680003, 0.2]], " ", 
              StyleBox[
                SqrtBox[
                  StyleBox[
                    RowBox[{
                      StyleBox[\(1\/2\),
                        Background->RGBColor[0.839994, 1, 0.2]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{"5", "+", 
                              StyleBox[\(\@5\),
                                Background->RGBColor[0.2, 1, 1]]}],
                            Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                        Background->RGBColor[1, 0.680003, 0.2]]}],
                    Background->RGBColor[1, 0.680003, 0.2]]],
                Background->RGBColor[0.2, 1, 1]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      StyleBox[
                        SqrtBox[
                          StyleBox[
                            FractionBox["2", 
                              StyleBox[
                                RowBox[{"5", "+", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[0.2, 1, 1]]}],
                                Background->RGBColor[1, 0.680003, 0.2]]],
                            Background->RGBColor[0.839994, 1, 0.2]]],
                        Background->RGBColor[0.2, 1, 1]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{
                                  StyleBox[\(1\/4\),
                                    Background->RGBColor[0.839994, 1, 0.2]], 
                                  " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[
                                        RowBox[{"1", "-", 
                                        StyleBox[\(\@5\),
                                        Background->RGBColor[0.2, 1, 1]]}],
                                        Background->RGBColor[1, 0.680003, 
                                        0.2]], ")"}],
                                    Background->RGBColor[1, 0.680003, 0.2]]}],
                                
                                Background->RGBColor[1, 0.680003, 0.2]], "+", 
                              "x"}],
                            Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                        Background->RGBColor[1, 0.680003, 0.2]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], "]"}],
                Background->RGBColor[1, 0.680003, 0.2]]}],
            Background->RGBColor[1, 0.680003, 0.2]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/5\),
                Background->RGBColor[0.839994, 1, 0.2]], " ", 
              StyleBox[
                SqrtBox[
                  StyleBox[
                    RowBox[{
                      StyleBox[\(1\/2\),
                        Background->RGBColor[0.839994, 1, 0.2]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{"5", "-", 
                              StyleBox[\(\@5\),
                                Background->RGBColor[0.2, 1, 1]]}],
                            Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                        Background->RGBColor[1, 0.680003, 0.2]]}],
                    Background->RGBColor[1, 0.680003, 0.2]]],
                Background->RGBColor[0.2, 1, 1]], " ", 
              StyleBox[
                RowBox[{"ArcTan", "[", 
                  StyleBox[
                    RowBox[{"2", " ", 
                      StyleBox[
                        SqrtBox[
                          StyleBox[
                            FractionBox["2", 
                              StyleBox[
                                RowBox[{"5", "-", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[0.2, 1, 1]]}],
                                Background->RGBColor[1, 0.680003, 0.2]]],
                            Background->RGBColor[0.839994, 1, 0.2]]],
                        Background->RGBColor[0.2, 1, 1]], " ", 
                      StyleBox[
                        RowBox[{"(", 
                          StyleBox[
                            RowBox[{
                              StyleBox[
                                RowBox[{
                                  StyleBox[\(1\/4\),
                                    Background->RGBColor[0.839994, 1, 0.2]], 
                                  " ", 
                                  StyleBox[
                                    RowBox[{"(", 
                                      StyleBox[
                                        RowBox[{"1", "+", 
                                        StyleBox[\(\@5\),
                                        Background->RGBColor[0.2, 1, 1]]}],
                                        Background->RGBColor[1, 0.680003, 
                                        0.2]], ")"}],
                                    Background->RGBColor[1, 0.680003, 0.2]]}],
                                
                                Background->RGBColor[1, 0.680003, 0.2]], "+", 
                              "x"}],
                            Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                        Background->RGBColor[1, 0.680003, 0.2]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], "]"}],
                Background->RGBColor[1, 0.680003, 0.2]]}],
            Background->RGBColor[1, 0.680003, 0.2]], "+", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/5\),
                Background->RGBColor[0.839994, 1, 0.2]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{
                      StyleBox[\(-1\),
                        Background->RGBColor[1, 0.680003, 0.2]], "+", "x"}],
                    Background->RGBColor[1, 0.680003, 0.2]], "]"}],
                Background->RGBColor[1, 0.680003, 0.2]]}],
            Background->RGBColor[1, 0.680003, 0.2]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/20\),
                Background->RGBColor[0.839994, 1, 0.2]], " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[
                    RowBox[{"1", "-", 
                      StyleBox[\(\@5\),
                        Background->RGBColor[0.2, 1, 1]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                Background->RGBColor[1, 0.680003, 0.2]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{
                          StyleBox[\(1\/2\),
                            Background->RGBColor[0.839994, 1, 0.2]], " ", 
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[
                                RowBox[{"1", "-", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[0.2, 1, 1]]}],
                                Background->RGBColor[1, 0.680003, 0.2]], 
                              ")"}],
                            Background->RGBColor[1, 0.680003, 0.2]], " ", 
                          "x"}],
                        Background->RGBColor[1, 0.680003, 0.2]], "+", 
                      StyleBox[\(x\^2\),
                        Background->RGBColor[0.839994, 0.2, 1]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], "]"}],
                Background->RGBColor[1, 0.680003, 0.2]]}],
            Background->RGBColor[1, 0.680003, 0.2]], "-", 
          StyleBox[
            RowBox[{
              StyleBox[\(1\/20\),
                Background->RGBColor[0.839994, 1, 0.2]], " ", 
              StyleBox[
                RowBox[{"(", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[\(\@5\),
                        Background->RGBColor[0.2, 1, 1]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], ")"}],
                Background->RGBColor[1, 0.680003, 0.2]], " ", 
              StyleBox[
                RowBox[{"Log", "[", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      StyleBox[
                        RowBox[{
                          StyleBox[\(1\/2\),
                            Background->RGBColor[0.839994, 1, 0.2]], " ", 
                          StyleBox[
                            RowBox[{"(", 
                              StyleBox[
                                RowBox[{"1", "+", 
                                  StyleBox[\(\@5\),
                                    Background->RGBColor[0.2, 1, 1]]}],
                                Background->RGBColor[1, 0.680003, 0.2]], 
                              ")"}],
                            Background->RGBColor[1, 0.680003, 0.2]], " ", 
                          "x"}],
                        Background->RGBColor[1, 0.680003, 0.2]], "+", 
                      StyleBox[\(x\^2\),
                        Background->RGBColor[0.839994, 0.2, 1]]}],
                    Background->RGBColor[1, 0.680003, 0.2]], "]"}],
                Background->RGBColor[1, 0.680003, 0.2]]}],
            Background->RGBColor[1, 0.680003, 0.2]]}],
        Background->RGBColor[1, 0.680003, 0.2]],
      DisplayForm]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visual Bracket Matching", "Section"],

Cell["\<\
This finds pairs of brackets in an expression, applying a \
transformation to them.\
\>", "Commentary"],

Cell[BoxData[
    \(TransformBrackets[f_, expr_] := 
      DisplayForm[FindBrackets[ToBoxes[expr], f]]\)], "Input"],

Cell[BoxData[
    \(FindBrackets[startexpr_, f_] := \n\t
      Fold[Function[{expr, \ location}, \n\t\t
          ReplacePart[expr, 
            f[expr\[LeftDoubleBracket]Sequence\ @@\ location
                  \[RightDoubleBracket], Length[location]], location]], 
        startexpr, \n\t\t
        Sort[Position[startexpr, \ 
            RowBox[{a___, "\<{\>"\  | \ "\<[\>"\  | \ "\<(\>", \ b__, \ 
                "\<]\>"\  | \ "\<}\>"\  | \ "\<)\>", \ c___}]], \ 
          Length[#1]\  > \ Length[#2]&]]\)], "Input"],

Cell["\<\
This defines a function that resizes brackets according to their \
depth.\
\>", "Commentary"],

Cell[BoxData[
    \(SizeBrackets[expr_] := 
      TransformBrackets[
        StyleBox[#1, SpanMinSize \[Rule] \((#2 - 2)\), \n\t\t\t\t\t
            SpanMaxSize\  \[Rule] \ \((#2 - 2)\)]&, expr]\)], "Input"],

Cell["Here is an expression with a range of levels.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[f, x, 5]\)], "Input"],

Cell[BoxData[
    \({x, f[x], f[f[x]], f[f[f[x]]], f[f[f[f[x]]]], f[f[f[f[f[x]]]]]}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
This shows brackets at different levels with different sizes.\
\>", 
  "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SizeBrackets[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{"x", ",", 
          StyleBox[\(f[x]\),
            SpanMinSize->2,
            SpanMaxSize->2], ",", 
          StyleBox[
            RowBox[{"f", "[", 
              StyleBox[\(f[x]\),
                SpanMinSize->4,
                SpanMaxSize->4], "]"}],
            SpanMinSize->2,
            SpanMaxSize->2], ",", 
          StyleBox[
            RowBox[{"f", "[", 
              StyleBox[
                RowBox[{"f", "[", 
                  StyleBox[\(f[x]\),
                    SpanMinSize->6,
                    SpanMaxSize->6], "]"}],
                SpanMinSize->4,
                SpanMaxSize->4], "]"}],
            SpanMinSize->2,
            SpanMaxSize->2], ",", 
          StyleBox[
            RowBox[{"f", "[", 
              StyleBox[
                RowBox[{"f", "[", 
                  StyleBox[
                    RowBox[{"f", "[", 
                      StyleBox[\(f[x]\),
                        SpanMinSize->8,
                        SpanMaxSize->8], "]"}],
                    SpanMinSize->6,
                    SpanMaxSize->6], "]"}],
                SpanMinSize->4,
                SpanMaxSize->4], "]"}],
            SpanMinSize->2,
            SpanMaxSize->2], ",", 
          StyleBox[
            RowBox[{"f", "[", 
              StyleBox[
                RowBox[{"f", "[", 
                  StyleBox[
                    RowBox[{"f", "[", 
                      StyleBox[
                        RowBox[{"f", "[", 
                          StyleBox[\(f[x]\),
                            SpanMinSize->10,
                            SpanMaxSize->10], "]"}],
                        SpanMinSize->8,
                        SpanMaxSize->8], "]"}],
                    SpanMinSize->6,
                    SpanMaxSize->6], "]"}],
                SpanMinSize->4,
                SpanMaxSize->4], "]"}],
            SpanMinSize->2,
            SpanMaxSize->2]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
This defines a function that colors successive levels of bracketing \
differently.\
\>", "Commentary"],

Cell[BoxData[
    \(ColorBrackets[expr_] := 
      TransformBrackets[
        StyleBox[AdjustmentBox[#1, BoxMargins \[Rule] {{0, 0}, {.5, .5}}], \ 
            Background \[Rule] Hue[Mod[N[#2/10], 1], .5]]&, expr]\)], "Input"],

Cell["Here is an example.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColorBrackets[NestList[f, x, 5]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{"x", ",", 
          StyleBox[
            AdjustmentBox[\(f[x]\),
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], ",", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"f", "[", 
                StyleBox[
                  AdjustmentBox[\(f[x]\),
                    BoxMargins->{{0, 0}, {0.5, 0.5}}],
                  Background->RGBColor[0.500008, 0.700008, 1]], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], ",", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"f", "[", 
                StyleBox[
                  AdjustmentBox[
                    RowBox[{"f", "[", 
                      StyleBox[
                        AdjustmentBox[\(f[x]\),
                          BoxMargins->{{0, 0}, {0.5, 0.5}}],
                        Background->RGBColor[0.900008, 0.500008, 1]], "]"}],
                    BoxMargins->{{0, 0}, {0.5, 0.5}}],
                  Background->RGBColor[0.500008, 0.700008, 1]], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], ",", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"f", "[", 
                StyleBox[
                  AdjustmentBox[
                    RowBox[{"f", "[", 
                      StyleBox[
                        AdjustmentBox[
                          RowBox[{"f", "[", 
                            StyleBox[
                              AdjustmentBox[\(f[x]\),
                                BoxMargins->{{0, 0}, {0.5, 0.5}}],
                              Background->RGBColor[1, 0.500008, 0.500008]], 
                            "]"}],
                          BoxMargins->{{0, 0}, {0.5, 0.5}}],
                        Background->RGBColor[0.900008, 0.500008, 1]], "]"}],
                    BoxMargins->{{0, 0}, {0.5, 0.5}}],
                  Background->RGBColor[0.500008, 0.700008, 1]], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], ",", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"f", "[", 
                StyleBox[
                  AdjustmentBox[
                    RowBox[{"f", "[", 
                      StyleBox[
                        AdjustmentBox[
                          RowBox[{"f", "[", 
                            StyleBox[
                              AdjustmentBox[
                                RowBox[{"f", "[", 
                                  StyleBox[
                                    AdjustmentBox[\(f[x]\),
                                      BoxMargins->{{0, 0}, {0.5, 0.5}}],
                                    Background->RGBColor[0.900008, 1, 
                                    0.500008]], "]"}],
                                BoxMargins->{{0, 0}, {0.5, 0.5}}],
                              Background->RGBColor[1, 0.500008, 0.500008]], 
                            "]"}],
                          BoxMargins->{{0, 0}, {0.5, 0.5}}],
                        Background->RGBColor[0.900008, 0.500008, 1]], "]"}],
                    BoxMargins->{{0, 0}, {0.5, 0.5}}],
                  Background->RGBColor[0.500008, 0.700008, 1]], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}], "}"}],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["Here is another example.", "Commentary"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColorBrackets[\[Integral]\(1\/\(x\^5 - 1\)\) \[DifferentialD]x]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{
        RowBox[{\(-\(1\/5\)\), " ", 
          SqrtBox[
            RowBox[{\(1\/2\), " ", 
              StyleBox[
                AdjustmentBox[\((5 + \@5)\),
                  BoxMargins->{{0, 0}, {0.5, 0.5}}],
                Background->RGBColor[0.6, 0.500008, 1]]}]], " ", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"ArcTan", "[", 
                RowBox[{"2", " ", \(\@\(2\/\(5 + \@5\)\)\), " ", 
                  StyleBox[
                    AdjustmentBox[
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(1\/4\), " ", 
                            StyleBox[
                              AdjustmentBox[\((1 - \@5)\),
                                BoxMargins->{{0, 0}, {0.5, 0.5}}],
                              Background->RGBColor[0.500008, 1, 0.699992]]}], 
                          "+", "x"}], ")"}],
                      BoxMargins->{{0, 0}, {0.5, 0.5}}],
                    Background->RGBColor[0.900008, 0.500008, 1]]}], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}], "-", 
        RowBox[{\(1\/5\), " ", 
          SqrtBox[
            RowBox[{\(1\/2\), " ", 
              StyleBox[
                AdjustmentBox[\((5 - \@5)\),
                  BoxMargins->{{0, 0}, {0.5, 0.5}}],
                Background->RGBColor[0.6, 0.500008, 1]]}]], " ", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"ArcTan", "[", 
                RowBox[{"2", " ", \(\@\(2\/\(5 - \@5\)\)\), " ", 
                  StyleBox[
                    AdjustmentBox[
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(1\/4\), " ", 
                            StyleBox[
                              AdjustmentBox[\((1 + \@5)\),
                                BoxMargins->{{0, 0}, {0.5, 0.5}}],
                              Background->RGBColor[0.500008, 1, 0.699992]]}], 
                          "+", "x"}], ")"}],
                      BoxMargins->{{0, 0}, {0.5, 0.5}}],
                    Background->RGBColor[0.900008, 0.500008, 1]]}], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}], "+", 
        RowBox[{\(1\/5\), " ", 
          StyleBox[
            AdjustmentBox[\(Log[\(-1\) + x]\),
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}], "-", 
        RowBox[{\(1\/20\), " ", 
          StyleBox[
            AdjustmentBox[\((1 - \@5)\),
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], " ", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"Log", "[", 
                RowBox[{"1", "+", 
                  RowBox[{\(1\/2\), " ", 
                    StyleBox[
                      AdjustmentBox[\((1 - \@5)\),
                        BoxMargins->{{0, 0}, {0.5, 0.5}}],
                      Background->RGBColor[1, 0.500008, 0.500008]], " ", 
                    "x"}], "+", \(x\^2\)}], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}], "-", 
        RowBox[{\(1\/20\), " ", 
          StyleBox[
            AdjustmentBox[\((1 + \@5)\),
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]], " ", 
          StyleBox[
            AdjustmentBox[
              RowBox[{"Log", "[", 
                RowBox[{"1", "+", 
                  RowBox[{\(1\/2\), " ", 
                    StyleBox[
                      AdjustmentBox[\((1 + \@5)\),
                        BoxMargins->{{0, 0}, {0.5, 0.5}}],
                      Background->RGBColor[1, 0.500008, 0.500008]], " ", 
                    "x"}], "+", \(x\^2\)}], "]"}],
              BoxMargins->{{0, 0}, {0.5, 0.5}}],
            Background->RGBColor[0.500008, 1, 0.700008]]}]}],
      DisplayForm]], "Output"]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"Microsoft Windows 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 735}},
WindowSize->{439, 262},
WindowMargins->{{6, Automatic}, {Automatic, 10}},
StyleDefinitions -> "Demo.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 15120, 191, 34, 14940, 185, "GraphicsData", 
"Bitmap", "Commentary"],
Cell[16832, 242, 126, 5, 81, "Title"],
Cell[16961, 249, 175, 5, 37, "Subtitle"],

Cell[CellGroupData[{
Cell[17161, 258, 40, 0, 72, "Section"],
Cell[17204, 260, 78, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[17307, 264, 69, 1, 37, "Input"],
Cell[17379, 267, 274, 5, 179, "Output"]
}, Open  ]],
Cell[17668, 275, 112, 3, 45, "Commentary"],

Cell[CellGroupData[{
Cell[17805, 282, 81, 1, 54, "Input"],
Cell[17889, 285, 375, 7, 154, "Output"]
}, Open  ]],
Cell[18279, 295, 65, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[18369, 299, 131, 2, 74, "Input"],
Cell[18503, 303, 1865, 46, 136, "Output"]
}, Open  ]],
Cell[20383, 352, 65, 0, 30, "Text"],

Cell[CellGroupData[{
Cell[20473, 356, 93, 1, 74, "Input"],
Cell[20569, 359, 857, 13, 145, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[21475, 378, 46, 0, 41, "Section"],
Cell[21524, 380, 126, 5, 30, "Commentary"],

Cell[CellGroupData[{
Cell[21675, 389, 50, 1, 35, "Input"],
Cell[21728, 392, 149, 2, 71, "Output"]
}, Open  ]],
Cell[21892, 397, 74, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[21991, 401, 51, 1, 34, "Input"],
Cell[22045, 404, 588, 10, 276, "Output"]
}, Open  ]],
Cell[22648, 417, 99, 3, 30, "Commentary"],

Cell[CellGroupData[{
Cell[22772, 424, 91, 1, 54, "Input"],
Cell[22866, 427, 194, 4, 85, "Output"]
}, Open  ]],
Cell[23075, 434, 72, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[23172, 438, 110, 2, 54, "Input"],
Cell[23285, 442, 1137, 37, 215, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[24471, 485, 34, 0, 41, "Section"],
Cell[24508, 487, 79, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[24612, 491, 111, 2, 54, "Input"],
Cell[24726, 495, 3927, 124, 201, "Output"]
}, Open  ]],
Cell[28668, 622, 78, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[28771, 626, 155, 3, 92, "Input"],
Cell[28929, 631, 1582, 47, 192, "Output"]
}, Open  ]],
Cell[30526, 681, 78, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[30629, 685, 145, 3, 74, "Input"],
Cell[30777, 690, 5910, 124, 124, "Output"]
}, Open  ]],
Cell[36702, 817, 113, 3, 45, "Commentary"],
Cell[36818, 822, 440, 9, 154, "Input"],
Cell[37261, 833, 107, 3, 30, "Commentary"],

Cell[CellGroupData[{
Cell[37393, 840, 146, 3, 94, "Input"],
Cell[37542, 845, 3540, 118, 25, "Print"],
Cell[41085, 965, 3549, 118, 25, "Print"],
Cell[44637, 1085, 3533, 118, 25, "Print"],
Cell[48173, 1205, 3543, 118, 25, "Print"],
Cell[51719, 1325, 3537, 118, 25, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[55305, 1449, 39, 0, 41, "Section"],
Cell[55347, 1451, 108, 3, 45, "Commentary"],

Cell[CellGroupData[{
Cell[55480, 1458, 151, 3, 89, "Input"],
Cell[55634, 1463, 2097, 49, 260, "Output"]
}, Open  ]],
Cell[57746, 1515, 113, 3, 45, "Commentary"],

Cell[CellGroupData[{
Cell[57884, 1522, 62, 1, 34, "Input"],
Cell[57949, 1525, 249, 5, 134, "Input",
  CellGroupingRules->"OutputGrouping"],
Cell[58201, 1532, 35363, 973, 818, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[93613, 2511, 42, 0, 41, "Section"],
Cell[93658, 2513, 98, 2, 30, "Commentary"],
Cell[93759, 2517, 429, 8, 214, "Input"],
Cell[94191, 2527, 41, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[94257, 2531, 119, 2, 46, "Input"],
Cell[94379, 2535, 11160, 231, 307, "Output"]
}, Open  ]],
Cell[105554, 2769, 95, 2, 30, "Commentary"],

Cell[CellGroupData[{
Cell[105674, 2775, 271, 6, 114, "Input"],
Cell[105948, 2783, 157, 3, 46, "Input",
  CellGroupingRules->"OutputGrouping"],
Cell[106108, 2788, 7101, 153, 307, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113246, 2946, 217, 4, 94, "Input"],
Cell[113466, 2952, 253, 7, 114, "Input",
  CellGroupingRules->"OutputGrouping"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113756, 2964, 93, 1, 54, "Input"],
Cell[113852, 2967, 156, 3, 46, "Input",
  CellGroupingRules->"OutputGrouping"],
Cell[114011, 2972, 10176, 215, 307, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[124236, 3193, 42, 0, 41, "Section"],
Cell[124281, 3195, 113, 3, 45, "Commentary"],
Cell[124397, 3200, 115, 2, 54, "Input"],
Cell[124515, 3204, 522, 10, 214, "Input"],
Cell[125040, 3216, 103, 3, 30, "Commentary"],
Cell[125146, 3221, 207, 4, 74, "Input"],
Cell[125356, 3227, 67, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[125448, 3231, 50, 1, 34, "Input"],
Cell[125501, 3234, 100, 2, 67, "Output"]
}, Open  ]],
Cell[125616, 3239, 94, 3, 30, "Commentary"],

Cell[CellGroupData[{
Cell[125735, 3246, 48, 1, 34, "Input"],
Cell[125786, 3249, 1998, 59, 233, "Output"]
}, Open  ]],
Cell[127799, 3311, 112, 3, 45, "Commentary"],
Cell[127914, 3316, 226, 4, 114, "Input"],
Cell[128143, 3322, 41, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[128209, 3326, 65, 1, 34, "Input"],
Cell[128277, 3329, 3526, 77, 116, "Output"]
}, Open  ]],
Cell[131818, 3409, 46, 0, 30, "Commentary"],

Cell[CellGroupData[{
Cell[131889, 3413, 99, 2, 46, "Input"],
Cell[131991, 3417, 4064, 92, 337, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

