(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     89510,       2393]*)
(*NotebookOutlinePosition[     90390,       2426]*)
(*  CellTagsIndexPosition[     90311,       2420]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Programming
the V3.0 Front End\
\>", "Title"],

Cell["by John M. Novak", "Subsubtitle"],

Cell[TextData[{
  "The following material is excerpted from a draft of a chapter for the book \
",
  StyleBox["Elements of Mathematica Programming",
    FontSlant->"Plain"],
  ", edited by Troels Petersen, forthcoming from TELOS/Springer-Verlag (used \
with permission). The full chapter expands on many of the concepts I \
described in my tutorial on Programming the Front End, given at the 1998 \
Worldwide ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Conference. The excerpt that follows includes the text of the first three \
sections of the chapter, which provides the foundations of front end \
programming."
}], "Subsubtitle"],

Cell[TextData[{
  "In Version 3.0, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gained a much more flexible and powerful front end than it had before. \
The new capabilities include typesetting, an expanded help system, and \
programmability, among other things. This chapter focuses on the \
programmability of the new front end, from the perspective of an advanced ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user. In particular, the essentials of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming, of representing an expression, and of standard entry of \
typeset expressions will not be addressed. The elementary output routines \
such as ",
  StyleBox["StylePrint", "Input"],
  " and ",
  StyleBox["CellPrint", "Input"],
  " will be passed over, as will many of the subtle points of typesetting. \
Instead, this will concentrate on the underlying expression structure of \
notebooks, option handling, the front end/kernel interactions, and creating \
buttons."
}], "Text"],

Cell["\<\
To work effectively with the front end, several features need to be \
understood and manipulated. The most important are:\
\>", "Text"],

Cell[TextData[{
  StyleBox["The Notebook Expression\n",
    FontWeight->"Bold"],
  "Notebooks are represented by a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. Understanding the components of that expression and being \
able to output them to the front end on demand is the key to front end \
operations."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Current Selection Manipulation\n",
    FontWeight->"Bold"],
  "A variety of commands are available for manipulating notebook expressions \
that operate on the current selection, rather than treating the notebook as a \
fixed structure modified by part manipulation commands. These selection \
handling commands, also called stream manipulation commands, are the most \
common means of affecting the front end."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Front End Options\n",
    FontWeight->"Bold"],
  "Portions of the notebook expression, including the individual cells, boxes \
within the cells, the notebook as a whole, and, for that matter, the entire \
front end, have various options that can be set. In many cases, it is faster \
to simply set an option than emit an entire notebook expression. Several \
commands can be used to manipulate options."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Front End/Kernel Interactions\n",
    FontWeight->"Bold"],
  "The front end actually implements a limited evaluator that allows front \
end operations to be invoked directly in the front end, bypassing the kernel. \
Awareness of where an evaluation is occurring, and of the kernel/front end \
callback mechanism, is vital for advanced front end operations."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Front End Tokens\n",
    FontWeight->"Bold"],
  "A low\[Hyphen]level tool for working with the front end, front end tokens \
allow access to essentially all menu items and front end operations. However, \
most of these tokens are undocumented, and these function calls are more \
likely to be changed than others, so they should be used with care. In \
return, they may provide substantial performance benefits over other \
mechanisms."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Button Functions\n",
    FontWeight->"Bold"],
  "Buttons are the primary graphic interface control tool in the Version 3.0 \
front end. However, their use for complex operations is not well documented. \
Knowledge of the capabilities and limitations of buttons will enable you to \
write powerful applications operated via a graphic interface."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{40, 48}, {Inherited, Inherited}}],

Cell[TextData[{
  "Together, these tools will give you the capability to control the front \
end and create graphic interfaces to your applications. You should be aware \
that the front end is evolving; these tools are merely the first step in \
creating a fully general graphic interface. Many useful features, such as \
generalized dialog boxes and interactive graphics, remain to be implemented. \
In time, they will be added, making portions of this chapter obsolete; but \
the core concept of using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions for representing and manipulating the front end will remain \
intact."
}], "Text"],

Cell[CellGroupData[{

Cell["The Notebook Expression", "Section"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 2.x, a notebook was simply the main document type. In Version \
3.0, the concept of the document was extended tremendously. Now, virtually \
any window that you can manipulate is actually a notebook; and a large number \
of the characteristics of a window that you can affect can be changed. For \
instance, the palettes of buttons are notebooks; so is the \"About ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[Ellipsis]\" box. The bottom portion of the Help Browser is a notebook, \
though because of the operations that place it in the special window, it \
can't be manipulated as flexibly. At this point in time, most dialog boxes \
are not notebooks; they are generated using operating system\[Hyphen]specific \
tools, and are not open to the same degree of manipulation as a notebook."
}], "Text"],

Cell["\<\
Given this enhanced flexibility, the first question that arises is \"how is a \
window represented\"? The answer is \"via a notebook expression\". Since the \
most common use of a notebook is still the traditional hierarchical document, \
the notebook expression reflects this heritage. It takes the form\
\>", "Text"],

Cell[TextData[{
  StyleBox["Notebook[{\n\tCell[", "Input"],
  StyleBox["data", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["style", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["options", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["],\n\tCell[", "Input"],
  StyleBox["data", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["style", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["options", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["],\n\t\[Ellipsis]\n},\n", "Input"],
  StyleBox["options", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\n]", "Input"]
}], "Text"],

Cell[TextData[{
  "This is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression like any other. In the kernel, it is inert; that is, it \
doesn't evaluate to anything, so it is effectively a data type. When sent to \
the front end by the proper commands, it is turned into a window that you can \
view. Conversely, you can retrieve the notebook expression for a particular \
notebook window."
}], "Text"],

Cell[TextData[{
  "The separation of front end (graphic interface) and kernel (computational \
engine) is very important to working with notebooks. The protocol for \
communication between these two main parts of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ". Because ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does not currently use a shared memory model, it becomes necessary to \
have handles to notebooks that can be quickly passed over the link and used \
to refer to and operate on a notebook. That handle perforce becomes another \
data type, called the notebook object. Its syntax is:"
}], "Text"],

Cell[TextData[{
  StyleBox["NotebookObject[", "Input"],
  StyleBox["front end object,", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" ", "Input"],
  StyleBox["id", "Input",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["]", "Input"]
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["id",
    FontSlant->"Italic"],
  " is unique to a particular ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (front end) session. The ",
  StyleBox["front end object",
    FontSlant->"Italic"],
  " is another handle, this time to the entire front end; it in turn contains \
a handle to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " stream used to communicate with the front end. In general, you won\
\[CloseCurlyQuote]t need to access the internals of this object, but it is \
useful to be aware of it. Because the internals of this object are not \
important to most users, it is formatted as ",
  Cell[BoxData[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\)]],
  ". The most important point is that this object is not the notebook \
expression, but instead a reference to a particular notebook window."
}], "Text"],

Cell[TextData[{
  "We can now tie these two data objects together by looking at a couple of \
the simplest commands for working with notebooks object and expressions: ",
  StyleBox["NotebookPut", "Input"],
  " and ",
  StyleBox["NotebookGet", "Input"],
  ". ",
  StyleBox["NotebookPut", "Input"],
  " will transfer a notebook expression from the kernel to the front end, \
returning the referencing notebook object, while ",
  StyleBox["NotebookGet", "Input"],
  " accepts a notebook object and returns the expression corresponding to \
that object. Here\[CloseCurlyQuote]s an example."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nb\  = 
      NotebookPut[\n\t
        Notebook[\n\t\t{Cell["\<A Head of a Notebook\>", \ 
              "\<Section\>"], \n\t\t\tCell[
              "\<Some descriptive text might go here.\>", "\<Text\>"]}\n\t\t]]
        \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM3351e24f", 1, 1]], 15],
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[nb]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        \(NotebookObject[FrontEndObject[LinkObject["\<FM3351e24f\>", 1, 1]], 
          15]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NotebookGet[nb]\)], "Input"],

Cell[BoxData[
    \(Notebook[{
        Cell[CellGroupData[{
              Cell[TextData["A Head of a Notebook"], "Section"], 
              Cell[TextData["Some descriptive text might go here."], 
                "Text"]}, Open]]}, 
      FrontEndVersion \[Rule] "Microsoft Windows 3.0", 
      ScreenRectangle 
        \[Rule] {{0.`, 1024.00000000000002`}, {0.`, 712.00000000000001`}}, 
      WindowSize \[Rule] {499.000000000000021`, 607.000000000000028`}, 
      WindowMargins 
        \[Rule] {{252.000000000000001`, Automatic}, {Automatic, 
            22.9999999999999982`}}]\)], "Output"]
}, Open  ]],

Cell["\<\
The very first thing to notice is that the front end may rearrange and add \
information to a notebook expression without additional input from the user. \
In many cases this is to optimize front end handling of a notebook; in \
others, it is due to specific front end features such as auto-grouping. Some \
options may also vary from machine to machine.\
\>", "Text"],

Cell[TextData[{
  "Given this foundation, we can start looking at some of the details of the \
notebook expression. We first look at the cell data types. As seen from the \
example we just executed (assuming you haven\[CloseCurlyQuote]t globally \
turned off automatic cell grouping), one of those data types is ",
  StyleBox["CellGroupData", "Input"],
  ". A ",
  StyleBox["CellGroupData", "Input"],
  " expression takes a list of subcells as its first argument, and the state \
of the group (",
  StyleBox["Open", "Input"],
  " or ",
  StyleBox["Closed", "Input"],
  ") as the second. This data type represents the hierarchical structure of \
the classical notebook. Note that cells whose data types are ",
  StyleBox["CellGroupData", "Input"],
  " expressions are the only cells that do not also have a style associated \
with them."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NotebookPut[\n\t
      Notebook[{\n\t\t\tNest[
            Cell[CellGroupData[{Cell["\<Head cell\>", "\<Text\>"], #, #}, 
                  Open]] &, \n\t\t\t\tCell["\<A Cell\>", 
              "\<Text\>"], \n\t\t\t\t5]}, \n\t\tCellGrouping \[Rule] Manual]]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM3351e24f", 1, 1]], 19],
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Here we begin to see the advantages of coupling the front end and kernel \
through expressions; it becomes very easy to write ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs that create notebooks. This simple case displays a notebook that \
violates the traditional nesting of a notebook\[CloseCurlyQuote]s cells by \
using the notebook option ",
  StyleBox["CellGrouping", "Input"],
  ". If you experiment with variations on this little program, you will \
discover at least one more characteristic of the ",
  StyleBox["CellGroupData", "Input"],
  " type; the first cell in a ",
  StyleBox["CellGroupData", "Input"],
  " list of cells must be a \[OpenCurlyQuote]leaf\[CloseCurlyQuote] cell, \
that is, one that does not itself contain a ",
  StyleBox["CellGroupData", "Input"],
  " expression. This is because all cell groups must have a head cell. If you \
attempt to violate this convention, the front end will rearrange the grouping \
of your cells. The requirement for a head cell most likely derives from the \
need to retain a clear marker for a group when that group is closed; the head \
cell is displayed, often acting as a description of the closed group."
}], "Text"],

Cell[TextData[{
  "The most common cell data types are ",
  StyleBox["TextData", "Input"],
  " and ",
  StyleBox["BoxData", "Input"],
  ". (A simple string is also a ",
  StyleBox["TextData", "Input"],
  " type, as we found in the first example when we wrote out a notebook and \
read it back in.)"
}], "Text"],

Cell[TextData[{
  "A ",
  StyleBox["TextData", "Input"],
  " wrapper is used for formatted text. This consists of paragraphs entered \
in much the same way as a word processor, with style modifications allowed on \
words. It does not directly include any two\[Hyphen]dimensional forms (such \
as superscripts), however these can be handled via ",
  StyleBox["in",
    FontSlant->"Italic"],
  "\[Hyphen]",
  StyleBox["line",
    FontSlant->"Italic"],
  " cells. An in\[Hyphen]line cell is a complete ",
  StyleBox["Cell", "Input"],
  " expression embedded in a cell data type; currently, only ",
  StyleBox["TextData", "Input"],
  " expressions support this feature. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.1, ",
  StyleBox["BoxData", "Input"],
  " wrappers will too. The in\[Hyphen]line cell can contain any of the \
\[OpenCurlyQuote]leaf\[CloseCurlyQuote] cell data types (all but ",
  StyleBox["CellGroupData", "Input"],
  "), including the graphics data types described later."
}], "Text"],

Cell[TextData[{
  "To examine some examples of the ",
  StyleBox["TextData", "Input"],
  " wrapper, we will use a series of unformatted cells. A significant feature \
of the front end that is very useful to anyone wishing to program it is the \
ability to examine and edit the raw cell expression for any given leaf cell. \
To toggle between the raw cell expression and the formatted cell, use the ",
  StyleBox["Format \[RightTriangle] Show Expression", "Output"],
  " menu item. An unformatted cell is actually a cell whose contents are in \
the ",
  StyleBox["RawData", "Input"],
  " cell data type; it takes a single argument, which is a string containing \
the cell expression to be formatted. In most cases, however, you won\
\[CloseCurlyQuote]t see this wrapper, but only the unformatted contents."
}], "Text"],

Cell[TextData[{
  "Here are some simple unformatted cells showing uses of the ",
  StyleBox["TextData", "Input"],
  " cell type."
}], "Text"],

Cell[RawData["Cell[TextData[\"This is some text.\"], \"Text\"]"], "Text"],

Cell[RawData["\<\
Cell[TextData[{\"This is text \",
  StyleBox[\"with\", FontSlant -> \"Italic\"], \" \",
  StyleBox[\"style\", FontWeight -> \"Bold\"], \".\"}], \"Text\"]\
\>"], "Text"],

Cell[TextData[{
  "Note two things in particular about the next example: in an unformatted \
cell, any non\[Hyphen]ASCII character is represented by its ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \[OpenCurlyDoubleQuote]long name\[CloseCurlyDoubleQuote], which is of the \
form ",
  Cell[TextData["\[Backslash][name]"]],
  ". Also, note that if you edit an in\[Hyphen]line cell in a formatted cell, \
the background color changes to let you know that you are working with an in\
\[Hyphen]line cell. Because an in\[Hyphen]line cell can contain any leaf data \
type, including ",
  StyleBox["TextData", "Input"],
  ", an interesting use of such cells is to prevent line\[Hyphen]breaking in \
a bit of text that breaks incorrectly. For example, text in \
\[OpenCurlyDoubleQuote]computer voice\[CloseCurlyDoubleQuote] (like this: ",
  Cell["a + b", "Input"],
  ") should generally not line\[Hyphen]break when embedded in a paragraph, \
yet if you simply change the style, it will be prone to breaking at the \
spaces. Putting it in an in\[Hyphen]line cell will inhibit breaking. However, \
in\[Hyphen]line cells are more commonly used to work with \
two\[Hyphen]dimensional layout, such as the superscript in the following \
example."
}], "Text",
  Background->None],

Cell[RawData["\<\
Cell[TextData[{\"Here comes an in\\[Hyphen]line cell: \",
  Cell[BoxData[SuperscriptBox[\"a\",\"b\"]]]}], \"Text\"]\
\>"], "Text"],

Cell["Here is the formatted version of the above cell:", "Text",
  CellMargins->{{5, Inherited}, {0, Inherited}},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0.4, 1]],

Cell[TextData[{
  "Here comes an in\[Hyphen]line cell: ",
  Cell[BoxData[
      \(a\^b\)]]
}], "Text"],

Cell[TextData[{
  "Any style of cell can have a ",
  StyleBox["TextData", "Input"],
  " object. The cell style simply determines what kind of data object will be \
created in a new instance of that cell. This is quite useful when dealing \
with large cells containing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code in ",
  StyleBox["InputForm", "Input"],
  "; because a large ",
  StyleBox["StandardForm", "Input"],
  " cell can take a while to parse, it is sometimes useful to put code in an \
",
  StyleBox["Input", "Output"],
  " cell with text rather than boxes for faster parsing. (This can be done \
automatically for all new input cells by choosing the ",
  StyleBox[
  "Cell \[RightTriangle] Default Input Format Type \[RightTriangle] \
InputForm", "Output"],
  " menu item.)"
}], "Text"],

Cell[RawData["Cell[TextData[\"Text for evaluation\"], \"Input\"]"], "Input"],

Cell[TextData[{
  StyleBox["TextData", "Input"],
  " expressions can also contain several other types of boxes: these include \
",
  StyleBox["ButtonBox", "Input"],
  ", ",
  StyleBox["CounterBox", "Input"],
  ", and ",
  StyleBox["ValueBox", "Input"],
  ". A ",
  StyleBox["ButtonBox", "Input"],
  " in a text object is similar to that in a ",
  StyleBox["BoxData", "Input"],
  " cell type, and will be described in detail later. The main difference \
between one in text and one in boxes is that the framed background often seen \
in buttons is not available. This is related to the fact that buttons in text \
are usually hyperlinks, and are set off from surrounding text via text \
formatting (e.g., colors and underlines), rather than being shown as a \
traditional GUI (graphic user interface) button. The box types ",
  StyleBox["CounterBox", "Input"],
  " and ",
  StyleBox["ValueBox", "Input"],
  " are specific to text cells, and cannot be used inside of a ",
  StyleBox["BoxData", "Input"],
  " expression at this time. They won't be described in detail here; they are \
used for automatic numbering and for displaying information about a front end \
attribute. For example, the following cell shows the current front end \
version number, when formatted."
}], "Text"],

Cell[RawData["\<\
Cell[TextData[{\"Here's the version: \",
    ValueBox[\"$FullVersion\"]}], \"Text\"]\
\>"], "Text"],

Cell["Here is the formatted version of the above cell:", "Text",
  CellMargins->{{5, Inherited}, {0, Inherited}},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0.4, 1]],

Cell[TextData[{
  "Here's the version: ",
  ValueBox["$FullVersion"]
}], "Text"],

Cell[TextData[{
  "One way to create ",
  StyleBox["CounterBox", "Input"],
  " and ",
  StyleBox["ValueBox", "Input"],
  " boxes is via the ",
  StyleBox[
  "Input \[RightTriangle] Create Automatic Numbering Object\[Ellipsis]", 
    "Output"],
  " and the ",
  StyleBox[
  "Input \[RightTriangle] Create Value Display Object\[Ellipsis]", "Output"],
  " menu items."
}], "Text"],

Cell[TextData[{
  "Each cell data type can be thought of as triggering a different kind of \
editor or viewer. For example, while ",
  StyleBox["TextData", "Input"],
  " objects use a standard text editor, ",
  StyleBox["BoxData", "Input"],
  " types specify the use of an editor for a two\[Hyphen]dimensional layout \
of typeset expressions. The 2\[Hyphen]D layout is expressed by a sequence of \
nested box primitives. Each box primitive has certain characteristic \
behaviors for layout; for instance, a ",
  StyleBox["SuperscriptBox", "Input"],
  " takes two arguments, which are arranged with the second as a superscript \
to the first. In many cases, the boxes have options controlling their \
position or size."
}], "Text"],

Cell["\<\
While you must know the specifics of each box to produce particular effects, \
there are too many box types to go into full detail here. In general, \
however, the ways of working with all the different boxes are very similar, \
and don't change the way you write front end programs, so a few brief \
examples should give you a good starting point.\
\>", "Text"],

Cell[TextData[{
  "Here\[CloseCurlyQuote]s an example of a typeset cell using ",
  StyleBox["BoxData", "Input"],
  "."
}], "Text"],

Cell[RawData["\<\
Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[\"\\[Integral]\", \"0\", \"\\[Infinity]\"], 
      RowBox[{
        FractionBox[\"x\", 
          RowBox[{
            SuperscriptBox[\"x\", \"3\"], \"+\", \"5\"}]], 
        RowBox[{\"\\[DifferentialD]\", \"x\"}]}]}]], \"Input\"]\
\>"], "Input"],

Cell["Here is the formatted version of the above cell:", "Text",
  CellMargins->{{5, Inherited}, {0, Inherited}},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0.4, 1]],

Cell[BoxData[
    \(\[Integral]\_0\%\[Infinity]\( x\/\(x\^3 + 5\)\) \[DifferentialD]x\)], 
  "Input"],

Cell[TextData[{
  "You can see that ",
  StyleBox["RowBox", "Input"],
  " primitives place things next to each other, ",
  StyleBox["*scriptBox", "Input"],
  " object place things slightly above or below and to the side of some set \
of boxes, fraction boxes place one set of boxes over another with a \
horizontal separator, and so on. Some additional useful box primitives \
include ",
  StyleBox["FrameBox", "Input"],
  ", which draws a border around its contents, ",
  StyleBox["AdjustmentBox", "Input"],
  ", which can tweak the position of its boxes, ",
  StyleBox["GridBox", "Input"],
  ", for arranging grids of boxes, and ",
  StyleBox["ButtonBox", "Input"],
  ", which can be used to create an interactive interface. These are only a \
few of the boxes available to you, and most have various options controlling \
their behavior; you will need to experiment to understand the full range of \
layout tools open to you."
}], "Text"],

Cell[TextData[{
  "Here\[CloseCurlyQuote]s a pair of little utilities to help you better \
visualize boxes. When you are entering a typeset expression via palettes and \
control keys, you don\[CloseCurlyQuote]t have any direct exposure to the \
boxes involved. The first utility captures those boxes before they are turned \
into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. This is done via a typesetting rule. The rule essentially \
says that when something that looks like ",
  StyleBox["LiteralBoxes[", "Input"],
  "\[Ellipsis]",
  StyleBox["]", "Input"],
  " is encountered in parsing, do not parse the contents, but instead turn \
the expression into the actual box expression. As mentioned before, this \
chapter doesn\[CloseCurlyQuote]t go into the details of typesetting, so not \
all of the ramifications of this will be described; but note that ",
  StyleBox["LiteralBoxes", "Input"],
  " is thus not a function, but instead a sort of typesetting wrapper, \
despite its appearance."
}], "Text"],

Cell[TextData[{
  "LiteralBoxes is not built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", but is defined by the following rule."
}], "Text"],

Cell[BoxData[
    \(MakeExpression[
        RowBox[{"\<LiteralBoxes\>", \ "\<[\>", \ boxes_, \ "\<]\>"}], \ form_]
        \  := \n\tHoldComplete[boxes]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LiteralBoxes[a\  + \ b\/c]\)], "Input"],

Cell[BoxData[
    \(RowBox[{"a", "+", FractionBox["b", "c"]}]\)], "Output"]
}, Open  ]],

Cell["\<\
Next is a small utility that takes a box expression and adds frames around \
all the subboxes, then outputs the boxes so that they are typeset. This will \
help you visualize the effects of the various boxes (though somewhat \
distorted by the frames).\
\>", "Text"],

Cell[BoxData[
    \(showBoxes[boxes_]\  := \n\t
      DisplayForm[MapAll[If[Head[#] === List, \ #, \ FrameBox[#]] &, \ boxes]]
        \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(showBoxes[
      LiteralBoxes[
        \[Integral]\_a\%b\ \ \@\(x\  + \ 3\)\/\(2  x\)\ \ \[DifferentialD]x]]
      \)], "Input"],

Cell[BoxData[
    TagBox[
      FrameBox[
        RowBox[{
          FrameBox[
            SubsuperscriptBox[
              RowBox[{"(", 
                FrameBox["\[Integral]"], ")"}], 
              FrameBox["a"], 
              FrameBox["b"]]], 
          FrameBox[
            RowBox[{
              FrameBox[
                FractionBox[
                  FrameBox[
                    SqrtBox[
                      FrameBox[
                        RowBox[{
                          FrameBox["x"], 
                          FrameBox["+"], 
                          FrameBox["3"]}]]]], 
                  FrameBox[
                    RowBox[{
                      FrameBox["2"], 
                      FrameBox["x"]}]]]], 
              FrameBox["  "], 
              FrameBox[
                RowBox[{
                  FrameBox["\[DifferentialD]"], 
                  FrameBox["x"]}]]}]]}]],
      DisplayForm]], "Output"]
}, Open  ]],

Cell["\<\
Together, these tools will allow you to experiment with various box \
layouts.\
\>", "Text"],

Cell[TextData[{
  "At the current time, ",
  StyleBox["BoxData", "Input"],
  " cells cannot contain in\[Hyphen]line cells, so certain kinds of \
formatting (such as aligning graphics with a ",
  StyleBox["GridBox", "Input"],
  ") cannot yet be done. This will change in the future."
}], "Text"],

Cell[TextData[{
  "The final cell data type covered here is ",
  StyleBox["GraphicsData", "Input"],
  ". Images, whether PostScript, bitmap, or machine\[Hyphen]specific types \
(such as Macintosh PICT or Windows MetaFile) are stored in a ",
  StyleBox["GraphicsData", "Input"],
  " object. The object takes two arguments; the first is a string denoting \
the type (e.g., \"PostScript\", \"PICT\"), and the second is the image data \
in the form of a string. Here\[CloseCurlyQuote]s a simple example of a small \
image. (The \"Bitmap\" graphics type is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[Hyphen]specific format that can render on all platforms.)"
}], "Text"],

Cell[RawData["\<\
Cell[GraphicsData[\"Bitmap\", \"\\<\\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000I00006A000`40O003
h00O6Goo000IOol00003001oogoo01Ioo`000P005goo0003000FOol000@0
01Eoo`001@0057oo0006000COol000L0019oo`0020004Goo0009000@Ool0
00X000moo`002`003Woo000<000=Ool000d000aoo`003P002goo000?000:
Ool0010000Uoo`004@0027oo000B0007Ool001<000Ioo`0050001Goo000E
0004Ool001H000=oo`005`000Woo0000\\
\\>\"], \"Graphics\",
  Evaluatable->False,
  ImageSize->{25.375, 25.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{25.375, 25.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Here is the formatted version of the above cell:", "Text",
  CellMargins->{{5, Inherited}, {0, Inherited}},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0.4, 1]],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000I00006A000`40O003
h00O6Goo000IOol00003001oogoo01Ioo`000P005goo0003000FOol000@0
01Eoo`001@0057oo0006000COol000L0019oo`0020004Goo0009000@Ool0
00X000moo`002`003Woo000<000=Ool000d000aoo`003P002goo000?000:
Ool0010000Uoo`004@0027oo000B0007Ool001<000Ioo`0050001Goo000E
0004Ool001H000=oo`005`000Woo0000\
\>"], "Graphics",
  Evaluatable->False,
  ShowCellLabel->True,
  ImageSize->{25.375, 25.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "The data used in a ",
  StyleBox["GraphicsData", "Input"],
  " object is not something that you will normally generate from scratch. \
Instead, you will most often use the function ",
  StyleBox["DisplayString", "Input"],
  ", a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function new in V3.0 that displays to a string rather than a stream. For \
example, there is no option for plot commands to direct the output of a plot \
to a particular notebook. However, by combining ",
  StyleBox["DisplayString", "Input"],
  " with the knowledge of the notebook format, we can write a display \
function that will do the job. Here\[CloseCurlyQuote]s a variation that only \
uses notebook commands discussed so far."
}], "Text"],

Cell[BoxData[
    \(displaytonew[gr_]\  := \n\t
      NotebookPut[
        Notebook[
          {Cell[GraphicsData["\<PostScript\>", DisplayString[gr]], 
              "\<Graphics\>"]}]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], \ {x, \ 0, \ 2\ \[Pi]}, \ 
      DisplayFunction\  \[Rule] \ displaytonew]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM33927091", 1, 1]], 16],
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  "As an aside, note that the necessity of first rendering to PostScript will \
change in some future version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", as the ",
  StyleBox["Graphics", "Input"],
  " object will format directly as a graphic, rather than being rendered \
first into PostScript and then into a bitmap."
}], "Text"],

Cell["\<\
These are not all the cell data types, and more are likely to be added in the \
future. However, they cover most of the cases you will encounter. With these, \
you should be able to understand the structure of most notebooks you will \
work with. Many characteristics of these structures can be changed by the use \
of options; this will be discussed in more detail in the section on option \
handling.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating the Selection", "Section"],

Cell[TextData[{
  "Before discussing options in the parts of notebooks, it is useful for us \
to expand the repertoire of notebook manipulation commands. We\
\[CloseCurlyQuote]ve already seen ",
  StyleBox["NotebookPut", "Input"],
  " and ",
  StyleBox["NotebookGet", "Input"],
  ", which handle the entire notebook expression at one time; but what if we \
wish to deal with only a part of the notebook?"
}], "Text"],

Cell[TextData[{
  "A ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programmer looking at notebook expressions for the first time would \
naturally think of manipulating a notebook by replacing parts of the \
expression: replace the ",
  Cell[BoxData[
      \(TraditionalForm\`5\^th\)]],
  " cell by a new cell expression; transform the first cell group in a \
particular way; etc. However, recall that the notebook expression is normally \
in the front end, not the kernel. Further, note that it can often be \
difficult to determine exactly which part of the notebook one wishes to \
transform, due to closed cells or cell groups, for instance. Finally, \
manipulating the expression by parts does not have a simple parallel to the \
sorts of changes performed manually in a graphic interface."
}], "Text"],

Cell[TextData[{
  "Because of these limitations, the model currently implemented for notebook \
operations is akin to stream handling. That is, the notebook is viewed as \
essentially a linear sequence of objects, and manipulations occur by \
transforming a pointer to a location in the sequence. The location is \
referred to as the current selection, and corresponds to the highlighted \
region of a visible notebook. The entire notebook is referenced by a handle \
(the ",
  StyleBox["NotebookObject", "Input"],
  "), rather than maintaining the full expression in kernel memory. "
}], "Text"],

Cell[TextData[{
  "Since the current selection can correspond to a range, the parallel to \
streams is not exact; but it is close enough that many notebook commands \
mimic stream commands. For example, ",
  StyleBox["NotebookOpen[", "Input"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " opens the named notebook, returning a ",
  StyleBox["NotebookObject", "Input"],
  " handle. ",
  StyleBox["NotebookClose[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " closes the specified notebook, while ",
  StyleBox["NotebookFind[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " sets the current selection to the next instance of data in the given \
notebook."
}], "Text"],

Cell["\<\
Given this model, you should thus first think about streams and graphic \
interface operations when manipulating notebooks, rather than structural \
transformations of the notebook expression. The exception to this is when you \
are dealing with notebooks small enough to be transferred to the kernel, \
where the entire expression is manipulated via pattern matching.\
\>", "Text"],

Cell[TextData[{
  "The first step in operating on a notebook is to get its handle (the \
notebook object). We\[CloseCurlyQuote]ve seen how this can be done with ",
  StyleBox["NotebookPut", "Input"],
  " and ",
  StyleBox["NotebookOpen", "Input"],
  "; but how do we find the handle for other notebooks?"
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Notebooks[]", "Input"],
  " command returns the handles for all open notebooks. (The following will \
vary depending on what you have done during a session and how many notebook \
windows are open.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Notebooks[] // InputForm\)], "Input"],

Cell["\<\
{NotebookObject[FrontEndObject[LinkObject[\"FM3392709\\
1\", 1, 1]], 11], NotebookObject[FrontEndObject[
    LinkObject[\"FM33927091\", 1, 1]], 19], 
  NotebookObject[FrontEndObject[LinkObject[\"FM3392709\\
1\", 1, 1]], 18], NotebookObject[FrontEndObject[
    LinkObject[\"FM33927091\", 1, 1]], 17], 
  NotebookObject[FrontEndObject[LinkObject[\"FM3392709\\
1\", 1, 1]], 9], NotebookObject[FrontEndObject[
    LinkObject[\"FM33927091\", 1, 1]], 8], 
  NotebookObject[FrontEndObject[LinkObject[\"FM3392709\\
1\", 1, 1]], 7]}\
\>", "Output"]
}, Open  ]],

Cell[TextData[{
  "Note that not all open notebooks must be visible. In fact, various \
notebook programming tasks depend on the current notebook being invisible \
(with the option ",
  StyleBox["Visible", "Input"],
  " set to ",
  StyleBox["False", "Input"],
  "). An invisible notebook will still appear in the ",
  StyleBox["Notebooks[]", "Input"],
  " list."
}], "Text"],

Cell[TextData[{
  "Generally, the notebook that is frontmost (which may include a palette) is \
called the selected notebook. (This will actually vary a bit depending on \
your operating system; under NEXTSTEP, for instance, a palette is never \
frontmost.) The selected notebook often appears slightly different, having a \
colored title bar, for instance. You can get the handle to the selected \
notebook with the command ",
  StyleBox["SelectedNotebook[]", "Input"],
  ". The frontmost non\[Hyphen]palette notebook is called the input notebook, \
with the corresponding command ",
  StyleBox["InputNotebook[]", "Input"],
  ". In this situation, a palette is considered to be any notebook with the ",
  
  StyleBox["WindowClickSelect", "Input"],
  " option set to ",
  StyleBox["False", "Input"],
  ". This option specifies that any click inside the window proper does not \
make it the frontmost window, which allows you to click on a button without \
obscuring the notebook that you are editing in. Most of your button functions \
will operate on the ",
  StyleBox["InputNotebook[]", "Input"],
  "."
}], "Text"],

Cell[TextData[
"Here\[CloseCurlyQuote]s a bit of demonstration code that creates a palette \
with a button that, when pressed, makes a new notebook showing what the \
handles were for the selected and input notebooks at the time of the button \
press. A variety of options are used here; most will be explained in detail \
in later sections. The key for now is to examine the notebook structures."], 
  "Text"],

Cell[BoxData[
    \(NotebookPut[
      Notebook[{
          Cell[BoxData[
              ButtonBox["\<Press Me\>", \n\t\t\t\t\t\t
                ButtonEvaluator\  \[Rule] \ Automatic, \ 
                Active\  \[Rule] \ True, \n\t\t\t\t\t\t
                ButtonFunction\  \[RuleDelayed] \ 
                  NotebookPut[
                    Notebook[{\n\t\t\t\t\t\t\t\t\t\t
                        Cell[ToString[FullForm[SelectedNotebook[]]], 
                          "\<Text\>"], \n\t\t\t\t\t\t\t\t\t\t
                        Cell[ToString[FullForm[InputNotebook[]]], \ 
                          "\<Text\>"]}]]]], \n\t\t\t\tNotebookDefault, \ 
            CellMargins\  \[Rule] \ {{0, 0}, {0, 0}}]}, \n\t\t
        WindowClickSelect\  \[Rule] \ False, \ WindowSize\  \[Rule] \ Fit, \n
        \t\tWindowElements\  \[Rule] \ {}, \ 
        WindowFrameElements\  \[Rule] \ "\<CloseBox\>"]]\)], "Input"],

Cell[TextData[{
  "Two additional common handle\[Hyphen]generating commands are ",
  StyleBox["EvaluationNotebook[]", "Input"],
  " and ",
  StyleBox["ButtonNotebook[]", "Input"],
  ". If an evaluation is occurring, ",
  StyleBox["EvaluationNotebook[]", "Input"],
  " returns the triggering notebook. If a function that was started by a \
button is evaluating, ",
  StyleBox["ButtonNotebook[]", "Input"],
  " will return a handle to the notebook containing the button. This is most \
useful for self\[Hyphen]modifying palettes, or for modifying a cell near the \
button."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EvaluationNotebook[]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM33927091", 1, 1]], 11],
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  "A handy way to experiment with notebook commands is to set up a target \
notebook with cells that you would like to operate on. Make that notebook \
frontmost, then evaluate something like ",
  Cell[BoxData[
      \(Null\`nb\  = \ EvaluationNotebook[]\)], "Input",
    FontFamily->"Courier"],
  ". Make a selection in the target notebook, then switch to a scratch \
notebook and evaluate commands using ",
  StyleBox["nb", "Input"],
  " as the handle, e.g., ",
  StyleBox["NotebookClose[nb]", "Input"],
  ". This is particularly useful when experimenting with selection \
operations."
}], "Text"],

Cell[TextData[{
  "The three operations you will perform most often with a notebook are \
reading the current selection, writing to the current selection, and changing \
the current selection. The first two are handled by ",
  StyleBox["NotebookRead[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " and ",
  StyleBox["NotebookWrite[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ", respectively, while changing the selection is performed most often by ",
  StyleBox["SelectionMove[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["direction",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["scope",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["NotebookRead", "Input"],
  " will return different objects based on the current selection. If the \
selection is an insertion cursor of any type (that is, nothing is \
highlighted), an empty list is returned. If the selection is within a text \
cell, a string or a list of strings and boxes is returned. When the selection \
is within a box cell type, ",
  StyleBox["NotebookRead", "Input"],
  " gives a ",
  StyleBox["BoxData", "Input"],
  " object. If the selection is an entire cell, the whole cell expression is \
returned, while if a sequence of cells that is not a full cell group is \
selected, a list of cells is found. (An entire cell group is a cell with a ",
  StyleBox["CellGroupData", "Input"],
  " cell data type.)"
}], "Text"],

Cell[TextData[{
  StyleBox["NotebookWrite", "Input"],
  " will first delete the current selection if it is a range, then write out \
the data. If the data is a box expression, it should be wrapped with ",
  StyleBox["BoxData", "Input"],
  ". If the insertion cursor is between cells, a new cell will be created. If \
it is within a cell, the data will be integrated with that cell as closely as \
possible (thus, if your data is a cell expression containing text, and you \
are writing to a text cell, the cell wrapper will be stripped and the text \
will be integrated with the cell). Here is a sequence of commands that \
creates a new notebook and writes cells to it:"
}], "Text"],

Cell[BoxData[
    \(\((nb\  = \ NotebookCreate[]; \n\t
      NotebookWrite[nb, \ Cell["\<The First Cell\>", \ "\<Text\>"]]; \n\t
      NotebookWrite[nb, \ "\<A new cell?\>"]; \n\t
      NotebookWrite[nb, \ BoxData[SuperscriptBox["\<a\>", "\<b\>"]]])\)\)], 
  "Input"],

Cell[TextData[{
  "Notice that ",
  StyleBox["NotebookWrite", "Input"],
  " of a string acts much the same as if you had typed that string; that is, \
the new cell is created in the default new cell style (an input cell by \
default), and the insertion cursor remains in the cell. Thus, the ",
  StyleBox["BoxData", "Input"],
  " that gets written in the last command ends up in the same cell, rather \
than starting yet another cell. If you want the writes to create new cells, \
you should start from a cell insertion cursor, then make certain all the data \
are wrapped in ",
  StyleBox["Cell", "Input"],
  " expressions. So how can you make certain you are at a cell insertion \
cursor? Use ",
  StyleBox["SelectionMove", "Input"],
  "!"
}], "Text"],

Cell[TextData[{
  StyleBox["SelectionMove", "Input"],
  " has three required arguments; the notebook handle, the direction of the \
move, and the scope of the move. The direction can be ",
  StyleBox["Previous", "Input"],
  ", ",
  StyleBox["Next", "Input"],
  ", ",
  StyleBox["Before", "Input"],
  ", ",
  StyleBox["After", "Input"],
  ", or ",
  StyleBox["All", "Input"],
  "; the scope can be ",
  StyleBox["Character", "Input"],
  ", ",
  StyleBox["Word", "Input"],
  ", ",
  StyleBox["Expression", "Input"],
  ", ",
  StyleBox["CellContents", "Input"],
  ", ",
  StyleBox["Cell", "Input"],
  ", and ",
  StyleBox["Notebook", "Input"],
  ", among others. Not all scopes are equally applicable; for instance, if \
the current selection is in a text cell, movement by ",
  StyleBox["Expression", "Input"],
  " doesn\[CloseCurlyQuote]t make sense. The directions ",
  StyleBox["Previous", "Input"],
  " and ",
  StyleBox["Next", "Input"],
  " differ from ",
  StyleBox["Before", "Input"],
  " and ",
  StyleBox["After", "Input"],
  " in that the first select instances of the object named in the scope that \
are in front of or after the current selection, while the latter move the \
insertion cursor in front of or behind the nearest object named in the \
scope."
}], "Text"],

Cell[TextData[{
  "Here\[CloseCurlyQuote]s one way to experiment with ",
  StyleBox["SelectionMove", "Input"],
  ". Take the following cell, and turn it into a palette via the ",
  StyleBox[
  "File \[RightTriangle] Generate Palette from Selection", "Output"],
  " menu item. Clicking on the buttons will then transform the current \
selection in the input notebook by a ",
  StyleBox["SelectionMove", "Input"],
  " with the arguments specified by the grid position."
}], "Text"],

Cell[BoxData[GridBox[{
        {" ", \(P\nr\ne\nv\ni\no\ns\), \(N\ne\nx\nt\), \(B\ne\nf\no\nr\ne\), 
          \(A\nf\nt\ne\nr\), \(A\n
          l\n
          l\)},
        {"Character", 
          ButtonBox["11",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, Character}], 
          ButtonBox["21",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, Character}], 
          ButtonBox["31",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, Character}], 
          ButtonBox["41",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, Character}], 
          ButtonBox["51",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, Character}]},
        {"Word", 
          ButtonBox["12",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, Word}], 
          ButtonBox["22",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, Word}], 
          ButtonBox["32",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, Word}], 
          ButtonBox["42",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, Word}], 
          ButtonBox["52",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, Word}]},
        {"Expression", 
          ButtonBox["13",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, Expression}], 
          ButtonBox["23",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, Expression}], 
          ButtonBox["33",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, Expression}], 
          ButtonBox["43",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, Expression}], 
          ButtonBox["53",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, Expression}]},
        {"CellContents", 
          ButtonBox["14",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, CellContents}], 
          ButtonBox["24",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, CellContents}], 
          ButtonBox["34",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, CellContents}], 
          ButtonBox["44",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, CellContents}], 
          ButtonBox["54",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, CellContents}]},
        {"Cell", 
          ButtonBox["15",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, Cell}], 
          ButtonBox["25",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, Cell}], 
          ButtonBox["35",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, Cell}], 
          ButtonBox["45",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, Cell}], 
          ButtonBox["55",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, Cell}]},
        {"Notebook", 
          ButtonBox["16",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Previous, Notebook}], 
          ButtonBox["26",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Next, Notebook}], 
          ButtonBox["36",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{Before, Notebook}], 
          ButtonBox["46",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{After, Notebook}], 
          ButtonBox["56",
            ButtonFunction:>(SelectionMove[ 
                InputNotebook[ ], 
                Apply[ Sequence, #]]&),
            ButtonData:>{All, Notebook}]}
        }]], "Input",
  AutoIndent->False,
  LineSpacing->{0.8, 0},
  ButtonBoxOptions->{ButtonEvaluator->Automatic,
  Active->True},
  GridBoxOptions->{RowSpacings->{0.5, 0},
  ColumnSpacings->{0.5, 0},
  RowAlignments->{Bottom, Baseline},
  ColumnAlignments->{Right, Center}}],

Cell[TextData[{
  "The ",
  StyleBox["SelectionMove", "Input"],
  " commands emitted by the palette will work in much the same way when \
evaluated by your programs."
}], "Text"],

Cell[TextData[{
  "The combination of movement, reading, and writing operations within the \
notebook stream provide many alternatives for presenting information to and \
getting information from the user. For example, one sort of operation \
frequently desired is a sort of dialog\[Hyphen]like data entry field. As \
previously mentioned, the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not generally support graphic\[Hyphen]interface dialogs; however, \
the existing commands can perform manipulations that are adequate to most \
purposes. The following bit of code grabs information from the cell that \
follows it, then emits a result based on that."
}], "Text"],

Cell[BoxData[
    \(\((SelectionMove[InputNotebook[], \ All, \ EvaluationCell]; 
      SelectionMove[InputNotebook[], Next, Cell]; \n\t
      dat\  = \ NotebookRead[InputNotebook[]]; \n\t
      SelectionMove[InputNotebook[], After, Cell]; \n\t
      NotebookWrite[InputNotebook[], 
        dat /. {SuperscriptBox[a_, b_] \[RuleDelayed] \ SubscriptBox[a, b], 
            SubscriptBox[a_, b_] \[RuleDelayed] SuperscriptBox[a, b], 
            SubsuperscriptBox[a_, b_, c_] \[RuleDelayed] 
              SubsuperscriptBox[a, c, b]}])\)\)], "Input"],

Cell[BoxData[
    \(\(a\^3\) \(b\_7\) c\_d\%e\)], "Input"],

Cell[BoxData[
    \(\(a\_3\) \(b\^7\) c\_e\%d\)], "Input",
  GeneratedCell->True],

Cell["\<\
As can be seen, the result of this program was to swap subscripts and \
superscripts in the cell following the code. Naturally, this sort of \
operation looks much nicer if the code can be hidden and control invested in \
a button. That procedure will be described in the section on buttons at the \
end of the chapter.\
\>", "Text"],

Cell[TextData[{
  "The code seen so far has a number of drawbacks. A key failing is that the \
\[OpenCurlyDoubleQuote]input field\[CloseCurlyDoubleQuote] is positioned in a \
specific location relative to the code or button. For some applications, \
variants of this are necessary; but you gain much more flexibility in layout \
if you don\[CloseCurlyQuote]t need to take such care in the positioning of \
the field. One way to do this is to tag the field somehow, and search for \
that tag. There are two nice ways of doing this. The first is to tag by the \
cell\[CloseCurlyQuote]s style, the second by a cell\[Hyphen]level option \
called ",
  StyleBox["CellTag", "Input"],
  ". Generally, the ",
  StyleBox["CellTag", "Input"],
  " is preferred, since it is very easy to create unique tags for each cell, \
or use a common tag for a group of cells you wish to handle simultaneously. \
Tags can be assigned programmatically, using the kinds of notebook operations \
discussed so far, or by hand, via the ",
  StyleBox[
  "Find \[RightTriangle] Add/Remove Cell Tags\[Ellipsis]", "Output"],
  " menu item. Note that cell tags are also used for other purposes, such as \
destinations for hyperlinks, and selection of sections of a notebook for \
display in the Help Browser; if you perform programmatic operations for \
setting cell tags, be sure not to disturb tags assigned for other purposes."
}], "Text"],

Cell[TextData[{
  "Assuming that you have a cell that is tagged, how do you locate it? The \
relevant command is ",
  StyleBox["NotebookFind", "Input"],
  ". ",
  StyleBox["NotebookFind[", "Input"],
  StyleBox["handle",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["dir",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["type",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " will locate the string ",
  StyleBox["data",
    FontSlant->"Italic"],
  " in the specified notebook. That data will be interpreted as being of ",
  StyleBox["type",
    FontSlant->"Italic"],
  ", which can be ",
  StyleBox["CellTags", "Input"],
  ", ",
  StyleBox["CellStyle", "Input"],
  ", ",
  StyleBox["CellContents", "Input"],
  ", or ",
  StyleBox["CellLabel", "Input"],
  ". The direction will be ",
  StyleBox["Next", "Input"],
  ", ",
  StyleBox["Previous", "Input"],
  ", or ",
  StyleBox["All", "Input"],
  ". (You may notice that ",
  StyleBox["CellLabel", "Input"],
  " is an option. What is the difference between a cell label and a cell tag? \
The cell label is only allowed to be a single string, while you can have a \
list of cell tags. Furthermore, the cell label is set by a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel evaluation; it is where the ",
  StyleBox["In[]", "Output"],
  " prompt is held. This also means that for many notebooks, the cell label \
is automatically deleted when the notebook is closed.)"
}], "Text"],

Cell[TextData[{
  "Another feature lacking in the previous example is that the operation was \
performed on the literal boxes. Suppose you wish to work with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s interpretation of the boxes, rather than the \
formatting information itself; what do you do? Essentially, you must call the \
formatter yourself, via the ",
  StyleBox["MakeExpression", "Input"],
  " command. To reverse the process, you call ",
  StyleBox["MakeBoxes", "Input"],
  " (alternately, use ",
  StyleBox["ToExpression/ToBoxes", "Input"],
  " if you don\[CloseCurlyQuote]t need tight control of the evaluation of the \
expression to be turned into an expression or boxes)."
}], "Text"],

Cell["\<\
Finally, note that you can use various formatting options to make the input \
cell look more like an input field.\
\>", "Text"],

Cell["Putting these pieces together, we might have the following.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((x\^2 + 3)\)\^4\)], "Input",
  CellFrame->True,
  Evaluatable->False,
  CellFrameLabels->{{"Enter an expression : ", None}, {None, None}},
  CellTags->"TheInputCell"],

Cell[BoxData[
    \(81 + 108\ x\^2 + 54\ x\^4 + 12\ x\^6 + x\^8\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\((NotebookFind[InputNotebook[], "\<TheInputCell\>", All, 
        CellTags]; \n\t
      dat\  = \ MakeExpression[First[NotebookRead[InputNotebook[]]]]; \n\t
      SelectionMove[InputNotebook[], After, Cell]; \n\t
      NotebookWrite[InputNotebook[], 
        Cell[BoxData[ToBoxes[Expand\  @@ \ dat]], "\<Output\>"]])\)\)], 
  "Input"],

Cell[TextData[{
  "Note that the result does not overwrite the previous result. Because you \
aren\[CloseCurlyQuote]t going through the main evaluator for this example, \
the previous output cell is not automatically deleted. You should also notice \
that the result of ",
  StyleBox["MakeExpression", "Input"],
  " is wrapped in ",
  StyleBox["HoldComplete", "Input"],
  ", which must be removed to actually do a useful evaluation (handled in \
this case by applying ",
  StyleBox["Expand", "Input"],
  ", rather than simply wrapping it around the result). Be careful if you \
have more than one of these in a notebook; this particular code will fail if \
there are multiple cells with a cell tag ",
  StyleBox["\"MyInputCell\"", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "This assortment of examples has given you the flavor of front end stream \
manipulation. The keys are the selection changing functions ",
  StyleBox["SelectionMove", "Input"],
  " and ",
  StyleBox["NotebookFind", "Input"],
  ". Combined with the basic ability to read and write to the selection given \
by ",
  StyleBox["NotebookRead", "Input"],
  " and ",
  StyleBox["NotebookWrite", "Input"],
  ", you can assemble a large number of notebook manipulations."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Front End Options", "Section"],

Cell["\<\
Many valuable operations can be handled by changing attributes of a \
selection, rather than reading in an entire cell or notebook and transforming \
its expression directly. There are a large number of attributes, such as font \
color and size; cell characteristics such as the bracket, frame, tags, and \
label; aspects of a notebook such as window position and size, as well as the \
style sheet; and globals for the entire front end such as message behavior \
and paths. Almost all options can be found somewhere in the option inspector, \
and modified by hand; but there is a standard assortment of functions for \
doing the same programmatically.\
\>", "Text"],

Cell[TextData[{
  "The main operations you may want to perform with options include \
determining and setting current option values. These are done with the \
functions ",
  StyleBox["Options", "Input"],
  " and ",
  StyleBox["SetOptions", "Input"],
  ". These functions also need a handle to the option being checked; in the \
case of front end globals, this is ",
  StyleBox["$FrontEnd", "Input"],
  ". For example, here is the value of the ",
  StyleBox["StartupSound", "Input"],
  " option, which dictates whether a sound is played when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[$FrontEnd, StartupSound]\)], "Input"],

Cell[BoxData[
    \({StartupSound \[Rule] True}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Multiple options can be examined by providing their names in a list. Here \
is the ",
  StyleBox["ScreenRectangle", "Input"],
  " option, which is the virtual screen size for the front end (generally \
inherited from the screen size set by the system), and the ",
  StyleBox["FrontEndStackSize", "Input"],
  ", which gives the size of the internal stack."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[$FrontEnd, \ {ScreenRectangle, \ FrontEndStackSize}]\)], "Input"],

Cell[BoxData[
    \({ScreenRectangle 
        \[Rule] {{Inherited, Inherited}, {Inherited, Inherited}}, 
      FrontEndStackSize \[Rule] 65536}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "To change option values, use the ",
  StyleBox["SetOptions", "Input"],
  " function. In the following evaluation, the ",
  StyleBox["StartupSoundOption", "Input"],
  " is set to ",
  StyleBox["False", "Input"],
  ". (Don\[CloseCurlyQuote]t forget to reset it to ",
  StyleBox["True", "Input"],
  " after trying this!) ",
  StyleBox["SetOptions", "Input"],
  " changes the option value, and returns a list of all options set to non\
\[Hyphen]default values. (",
  StyleBox["Shallow", "Input"],
  " is used here to reduce the amount of visible output, though the value \
stored in the command history is complete.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[$FrontEnd, StartupSound \[Rule] False] // Shallow\)], "Input"],

Cell[BoxData[
    \({NotebookDirectory \[RuleDelayed] 
        FrontEnd`FileName[\[LeftSkeleton]2\[RightSkeleton]], 
      AutoOpenPalettes \[Rule] {}, 
      DefaultStyleDefinitions \[RuleDelayed] "Default.nb", 
      StartupSound \[Rule] False, 
      NotebooksMenu \[Rule] {\[LeftSkeleton]5\[RightSkeleton]}, 
      FindSettings \[Rule] {\[LeftSkeleton]4\[RightSkeleton]}, 
      ViewPointSelectorSettings \[Rule] {\[LeftSkeleton]1\[RightSkeleton]}, 
      GridCreationSettings \[Rule] {\[LeftSkeleton]10\[RightSkeleton]}, 
      OptionInspectorSettings \[Rule] {\[LeftSkeleton]3\[RightSkeleton]}, 
      HelpBrowserSettings \[Rule] {\[LeftSkeleton]2\[RightSkeleton]}, 
      \[LeftSkeleton]2\[RightSkeleton]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Unlike ",
  StyleBox["SetOptions", "Input"],
  " applied to a kernel function, the change made to the state of ",
  StyleBox["$FrontEnd", "Input"],
  " persists between sessions. In the kernel, setting the default value for \
an option currently only pertains to the running session; you also cannot \
return to the original default value for an option unless you store it first. \
In the front end, a changed option will remain in the new state when you \
restart the program; furthermore, you can use the option inspector to return \
an option to its default value (clicking the small button that appears to the \
left of a set option in the inspector returns it to the default state)."
}], "Text"],

Cell[TextData[{
  "Also contrary to kernel design is the front end\[CloseCurlyQuote]s \
behavior of returning only the non\[Hyphen]default options from functions \
like ",
  StyleBox["Options", "Input"],
  ". This design is questionable, so for now it should not be depended on to \
remain the same. However, you can use the current behavior as a visual \
diagnostic to determine what options don\[CloseCurlyQuote]t have default \
values. Notice that some options are always considered to have \
non\[Hyphen]default settings."
}], "Text"],

Cell[TextData[{
  "Another option behavior that varies from the kernel relates to what could \
be called \[OpenCurlyDoubleQuote]superoptions\[CloseCurlyDoubleQuote], which \
encapsulate other options. One example is the ",
  StyleBox["MessageOptions", "Input"],
  " option, which controls behaviors relating to informing the user of an \
error. (",
  StyleBox["StyleForm", "Input"],
  " is also used in the following example in conjunction with the ",
  StyleBox["ShowStringCharacters", "Input"],
  " option to control the behavior of quotes in the output; it demonstrates \
another way in which options may be set. ",
  StyleBox["StyleForm", "Input"],
  " allows options that dictate formatting to be set for the output \
expression. The result of ",
  StyleBox["Options", "Input"],
  " is also being stored in a variable ",
  StyleBox["mopt", "Input"],
  " for later use.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StyleForm[mopt\  = \ Options[$FrontEnd, \ MessageOptions], 
      ShowStringCharacters\  \[Rule] \ Rule]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        \({MessageOptions 
            \[Rule] {"\<WarningAction\>" \[Rule] "\<Beep\>", 
              "\<ErrorAction\>" \[Rule] {"\<Beep\>", "\<DialogBox\>"}, 
              "\<ConsoleMessageAction\>" 
                \[Rule] {"\<Beep\>", "\<PrintToConsole\>"}, 
              "\<KernelMessageAction\>" 
                \[Rule] {"\<Beep\>", "\<PrintToNotebook\>"}, 
              "\<StartupHelp\>" \[Rule] False, 
              "\<ExplainBeepHelp\>" \[Rule] False, 
              "\<IgnoreTagBoxDeletionWarning\>" \[Rule] True, 
              "\<TraditionalFormEvaluationWarning\>" \[Rule] True, 
              "\<AllowDisablingWarnings\>" \[Rule] True}}\),
        ShowStringCharacters->True],
      (StyleForm[ #, ShowStringCharacters -> True]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These superoptions, like ",
  StyleBox["MessageOptions", "Input"],
  ", generally have a name ending in 'Options' or 'Settings'. This \
superoption syntax is occasionally used in kernel applications; the main \
difference here is that the front end suboptions are all named with strings \
instead of symbols, and that ",
  StyleBox["SetOptions", "Input"],
  " will allow you to change one of these suboptions individually, rather \
than forcing the setting of the option to affect all the suboptions \
simultaneously."
}], "Text"],

Cell[TextData[{
  "For example, the following is very useful in dialog box style operations. \
If you have a standalone window with a button\[Hyphen]triggered evaluation, \
an error may be emitted and be displayed in the notebook being used as a \
dialog, distorting the display. One solution is for your evaluation to \
temporarily reset the ",
  StyleBox["\"KernelMessageAction\"", "Input"],
  " suboption to ",
  StyleBox["MessageOptions", "Input"],
  " to redirect the error message to a separate messages window."
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[$FrontEnd, 
      MessageOptions 
        \[Rule] {"\<KernelMessageAction\>" \[Rule] {"\<PrintToConsole\>"}}]; 
    \)\)], "Input"],

Cell["\<\
Here is a an evaluation that emits a kernel error message. The message is not \
placed between input and output in the usual fashion, but instead shows up in \
the messages window.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0\)], "Input"],

Cell[BoxData[
    InterpretationBox["ComplexInfinity",
      DirectedInfinity[ ]]], "Output"]
}, Open  ]],

Cell["Note that the other suboptions are unaffected.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[$FrontEnd, \ MessageOptions]\)], "Input"],

Cell[BoxData[
    \({MessageOptions 
        \[Rule] {"WarningAction" \[Rule] "Beep", 
          "ErrorAction" \[Rule] {"Beep", "DialogBox"}, 
          "ConsoleMessageAction" \[Rule] {"Beep", "PrintToConsole"}, 
          "KernelMessageAction" \[Rule] "PrintToConsole", 
          "StartupHelp" \[Rule] False, "ExplainBeepHelp" \[Rule] False, 
          "IgnoreTagBoxDeletionWarning" \[Rule] True, 
          "TraditionalFormEvaluationWarning" \[Rule] True, 
          "AllowDisablingWarnings" \[Rule] True}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Peculiarly, ",
  StyleBox["SetOptions", "Input"],
  " does not accept a list of options, but it will accept a sequence of \
options. Here is one way to reset the options from values obtained by ",
  StyleBox["Options", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(SetOptions[$FrontEnd, ##] &\)\  @@ \ mopt;\)\)], "Input"],

Cell["Now the kernel messages behave as before.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0\)], "Input"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message"],

Cell[BoxData[
    InterpretationBox["ComplexInfinity",
      DirectedInfinity[ ]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Options can be set on several levels other than that of the entire front \
end. For example, a common assortment of options are set on the level of an \
entire notebook. In terms of the notebook expression, these options are saved \
at the end of the expression (much like the options in a kernel ",
  StyleBox["Graphics", "Input"],
  " object). Thus, when using functions that send an entire notebook \
expression, you can include the options explicitly. In addition, ",
  StyleBox["NotebookCreate", "Input"],
  " accepts options to be applied to the generated notebook."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nb = NotebookCreate[Background\  \[Rule] \ Hue[0]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM3482942a", 1, 1]], 15],
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Options", "Input"],
  " and ",
  StyleBox["SetOptions", "Input"],
  " are used much as before."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[nb, \ Background]\)], "Input"],

Cell[BoxData[
    \({Background \[Rule] RGBColor[1.`, 0.`, 0.`]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[nb, \ Background\  \[Rule] \ Hue[0.3]]\)], "Input"],

Cell[BoxData[
    \({FrontEndVersion \[Rule] "Microsoft Windows 3.0", 
      ScreenRectangle 
        \[Rule] {{0.`, 640.000000000000035`}, {0.`, 424.00000000000011`}}, 
      WindowSize \[Rule] {496.000000000000085`, 316.000000000000014`}, 
      WindowMargins \[Rule] {{30.`, Automatic}, {1.`, Automatic}}, 
      Background \[Rule] RGBColor[0.2`, 1.`, 0.`]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Notice the front end\[CloseCurlyQuote]s behavior of changing some objects \
to a canonical form; in this case, the color used has been converted to an ",
  StyleBox["RGBColor", "Input"],
  " expression."
}], "Text"],

Cell["\<\
Some of the most useful of these options from a programming perspective are \
those described as notebook and window properties. This includes attributes \
such as the editability of the window, as well as its size, color, position, \
and selectability, among others. The bulk of the options found under the \
\[OpenCurlyDoubleQuote]Notebook Options\[CloseCurlyDoubleQuote] section of \
the Option Inspector are generally set only at the notebook level.\
\>", "Text"],

Cell[TextData[{
  "Start with a notebook\[CloseCurlyQuote]s size and position. This is \
determined by two options: ",
  StyleBox["WindowMargins", "Input"],
  " and ",
  StyleBox["WindowSize", "Input"],
  ". The ",
  StyleBox["WindowMargins", "Input"],
  " are given as two pairs of values, corresponding to left-right margins and \
bottom-top margins. (This syntax is used for positioning other notebook \
elements, so you should be familiar with it.) This gives us: ",
  StyleBox["WindowMargins \[Rule] {{", "Input"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}, {", "Input"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}", "Input"],
  ". The unit of measure is points; this generally corresponds to pixels. The \
distance is measured from the specified side of the screen. In principle, we \
can specify both size and position with this syntax; however, it is \
frequently more convenient to specify a window size explicitly, and give \
position with respect to a particular corner of the screen. (In some versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", implementation issues require that we use such a syntax.) In that case, \
the value used for a margin to be determined by the system is ",
  StyleBox["Automatic", "Input"],
  ". (If all four values are ",
  StyleBox["Automatic", "Input"],
  ", the window is centered on the screen.) Window size is given by a ",
  StyleBox["{", "Input"],
  StyleBox["width",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  StyleBox["height",
    FontSlant->"Italic"],
  StyleBox["}", "Input"],
  " pair, also in points. Here are a few examples:"
}], "Text"],

Cell["\<\
A window 10 points from the left side of the screen, and 10 points from the \
bottom:\
\>", "Text"],

Cell[BoxData[
    \(\(NotebookCreate[
      WindowMargins\  \[Rule] \ {{10, Automatic}, {10, Automatic}}]; \)\)], 
  "Input"],

Cell["\<\
The next is partially off the screen; 20 points off the left side, 10 points \
from the top. (Note that under Windows, the top of the screen is given from \
the bottom of the menu bar, while the bottom is with respect to the taskbar.)\
\
\>", "Text"],

Cell[BoxData[
    \(\(NotebookCreate[
      WindowMargins\  \[Rule] \ {{\(-20\), Automatic}, {Automatic, 10}}]; 
    \)\)], "Input"],

Cell["A 200 by 200 point window centered on the screen:", "Text"],

Cell[BoxData[
    \(\(NotebookCreate[WindowSize\  \[Rule] \ {200, 200}, \n
      WindowMargins\  \[Rule] 
        \ {{Automatic, Automatic}, {Automatic, Automatic}}]; \)\)], "Input"],

Cell[TextData[{
  "Other variations include using the value ",
  StyleBox["Fit", "Input"],
  " for a window size, which adjusts the windows dimensions with respect to \
its contents. This is common with palette notebooks, which display only a \
grid of buttons."
}], "Text"],

Cell[TextData[{
  "Options permeate all levels of a notebook, and can be set on individual \
cells or on parts of the contents of a cell. If you are generating the entire \
object in question, it is easy to see how to set an option; but suppose you \
wish to change a setting without rewriting the entire object? There is not an \
obvious handle to a ",
  StyleBox["part",
    FontSlant->"Italic"],
  " of a notebook, the way there is to the entire front end or an individual \
notebook. The answer is a wrapper called ",
  StyleBox["NotebookSelection", "Input"],
  ". Wrapped around a notebook object, it represents the current selection of \
the notebook in question. The encapsulated object can then be used in \
functions like ",
  StyleBox["SetOptions", "Input"],
  "."
}], "Text"],

Cell[TextData[
"Many of the options that can be set at the level of an entire cell can also \
be set on parts of the cell; these include things like font attributes such \
as family, style, size, and color. Cell\[Hyphen]specific options can also be \
used to control the style (or visibility) of the cell bracket, as well as \
various labels such as the cell frame labels, cell dingbat, and cell label \
(which corresponds to the In[]/Out[] tags in input and output cells)."], 
  "Text"],

Cell["\<\
Here, for example, the current selection is moved to enclose the evaluating \
cell, and the font color is changed to red:\
\>", "Text"],

Cell[BoxData[
    \(\((SelectionMove[EvaluationNotebook[], \ All, \ EvaluationCell]; 
      SetOptions[NotebookSelection[EvaluationNotebook[]], \ 
        FontColor\  \[Rule] \ Hue[0]])\)\)], "Input"],

Cell[TextData[
"We can start putting some of these pieces together to create useful tools. \
For example, a simple \[OpenCurlyDoubleQuote]progress dialog\
\[CloseCurlyDoubleQuote] can be made using the commands shown so far combined \
with an array of options."], "Text"],

Cell["\<\
The basic idea of a graphic progress indicator is to have a bar that \
incrementally grows the width of the window as progress is made in some task. \
This naturally breaks up into three steps: opening the window, incrementing \
the progress dialog, and closing the window when done.\
\>", "Text"],

Cell["Here is the code for the first step:", "Text"],

Cell[BoxData[
    \(CreateProgress[desctext_String: "\<Progress :\>"]\  := \n\t
      NotebookPut[\n\t\tNotebook[
          {\n\t\t\t\tCell[desctext, \ 
              "\<Text\>", \n\t\t\t\tFontWeight\  \[Rule] \ "\<Bold\>", 
              FontSize\  \[Rule] \ 18], \n\t\t\t\tCell[
              "\<\>", \n\t\t\t\t\tCellTags\  \[Rule] \ 
                "\<ProgressBar\>", \n\t\t\t\t\tCellFrame\  \[Rule] \ 
                True, \n\t\t\t\t\tBackground\  \[Rule] \ 
                Hue[0], \n\t\t\t\t\tCellFrameMargins\  \[Rule] \ 
                {{0, 0}, {Inherited, Inherited}}, \n\t\t\t\t\tCellMargins\  
                \[Rule] \ 
                {{10, 190}, \ 
                  {Inherited, Inherited}}]}, \n\t\t\tShowCellBracket\  
            \[Rule] \ False, \n\t\t\tWindowSize\  \[Rule] \ 
            {200, \ 100}, \n\t\t\tWindowMargins\  \[Rule] \ 
            {{Automatic, Automatic}, 
              {Automatic, 10}}, \ \n\t\t\tWindowTitle\  \[Rule] \ 
            "\<Progress\>", \n\t\t\tWindowElements\  \[Rule] \ {}]]\)], 
  "Input"],

Cell[TextData[{
  "Two approaches to creating the dialog might have been reasonable here: \
first, opening an empty notebook and writing the contents to it via ",
  StyleBox["NotebookWrite", "Input"],
  "; or second, writing the entire starting notebook at once via ",
  StyleBox["NotebookPut", "Input"],
  ". The advantages of this second approach are clear, as it allows us to \
clearly specify all the parts in a single operation. Here, all the various \
starting options are set explicitly in the data objects affected; there is no \
need to apply ",
  StyleBox["SetOptions", "Input"],
  " separately."
}], "Text"],

Cell[TextData[{
  "The first cell in this window displays the progress bar text, which may be \
passed as the first argument to ",
  StyleBox["CreateProgress", "Input"],
  ". Here, I explicitly specify some font options determining how the text is \
to be displayed; a better approach is to establish a custom style sheet, and \
refer to a particular style, but that adds complexity, though it greatly \
improves modularity and maintainability of the code."
}], "Text"],

Cell[TextData[{
  "The next cell displays the bar. This is handled here by having the bar \
rendered as the interior of an empty cell. The background of the cell falls \
inside what is called the cell frame; as the left and right margins of the \
cell are adjusted, the block of color inside the frame changes size. The \
margins are specified in much the same manner as ",
  StyleBox["WindowMargins", "Input"],
  ".  The ",
  StyleBox["CellMargins", "Input"],
  " specifies the distance from the sides of the page (by default, the sides \
of the window), and the distance from the adjacent cells on top and bottom \
(or more accurately, the distance to the boundary specified by the adjacent \
cells margins). The value ",
  StyleBox["Inherited", "Input"],
  " in these options means \[OpenCurlyQuote]inherit the default value from \
the cell style\[CloseCurlyQuote]. The ",
  StyleBox["CellFrameMargins", "Input"],
  " specifies the boundaries around the text inside the cell frame. The color \
of the background is given by the ",
  StyleBox["Background", "Input"],
  " option. We tag the cell with the ",
  StyleBox["CellTags", "Input"],
  " option, for use in relocating the cell, as in examples earlier in the \
chapter."
}], "Text"],

Cell[TextData[{
  "Note that cell options may be specified at the level of the entire \
notebook, in which case they apply to every cell in the notebook. If the \
option is specified again on a particular cell, the option at the cell level \
takes precedence over the one at the notebook level. Here, the ",
  StyleBox["ShowCellBracket", "Input"],
  " option is set to ",
  StyleBox["False", "Input"],
  " to hide the cell brackets."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["WindowSize", "Input"],
  " and ",
  StyleBox["WindowMargins", "Input"],
  " options behave much as before. In this case, the window is 200 points \
across by 100 points high, centered horizontally on the screen, but 10 points \
from the top of the screen. The ",
  StyleBox["WindowTitle", "Input"],
  " option specifies what shows in the top of the window\[CloseCurlyQuote]s \
frame, if the windowing system allows it for the particular style of frame. \
If this option is ",
  StyleBox["Automatic", "Input"],
  ", it shows ",
  StyleBox["\"Untitled-",
    FontFamily->"Courier"],
  StyleBox["n",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " or the file name; if ",
  StyleBox["None", "Input"],
  ", it displays no title. Otherwise, it is usually set to a specific string, \
as in this case. Finally, setting the ",
  StyleBox["WindowElements", "Input"],
  " option to ",
  StyleBox["{}", "Input"],
  " gets rid of the various adornments around the window, such as scroll \
bars, status area, etc."
}], "Text"],

Cell[TextData[{
  "Next, we need a routine to adjust the size of the bar to some particular \
percentage specified as input. For simplicity, the following code has the \
window\[CloseCurlyQuote]s width and margins input as arguments (with hard\
\[Hyphen]coded defaults), though it could be adjusted to read these values \
from the progress notebook itself. The algorithm is simple: ",
  StyleBox["NotebookFind", "Input"],
  " is used to locate the progress bar in the specified notebook, and the \
cell margins are reset to a value determined from the percentage, width of \
the window, and margins of the bar at 100%. Again, for brevity, error \
checking was ignored in this case. (For example, the routine should properly \
verify that the window still exists before acting on it, perhaps by \
determining if the notebook object ",
  StyleBox["nb", "Input"],
  " is a member of the list returned by ",
  StyleBox["Notebooks[]", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(AdjustProgress[nb_NotebookObject, perc_, \ wid_:  200, 
        lrmargins_:  10]\  := \n\t
      \((NotebookFind[nb, "\<ProgressBar\>", \ All, \ 
          CellTags]; \n\t\tSetOptions[
          NotebookSelection[nb], \n\t\t\tCellMargins\  \[Rule] \ 
            {{lrmargins, \ 
                wid \((1 - perc)\)\  + \ lrmargins\ \((2\ perc\  - \ 1)\)}, 
              {Inherited, Inherited}}])\)\)], "Input"],

Cell[TextData[{
  "Finally, we close the progress dialog via a ",
  StyleBox["NotebookClose", "Input"],
  ". The ",
  StyleBox["Interactive", "Input"],
  "\[Rule]",
  StyleBox["False", "Input"],
  " option is used so that the front end does not ask the user if she wishes \
to save the dialog notebook (an effect of the dialog being simply another \
notebook\[Ellipsis])"
}], "Text"],

Cell[BoxData[
    \(CloseProgress[nb_NotebookObject]\  := 
      NotebookClose[nb, \ Interactive\  \[Rule] \ False]\)], "Input"],

Cell["Here we evaluate the routines:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(progressdialog\  = \ CreateProgress[]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \(\[SkeletonIndicator]  NotebookObject  \[SkeletonIndicator]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "FM34de61f5", 1, 1]], 35],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Adjust the width of the progress bar in 10% increments, pausing a second \
between each adjustment:\
\>", "Text"],

Cell[BoxData[
    \(Do[AdjustProgress[progressdialog, n]; Pause[1], {n, 0, 1, 0.1}]\)], 
  "Input"],

Cell[BoxData[
    \(CloseProgress[progressdialog]\)], "Input"],

Cell[TextData[{
  "In practice, you might use this by scattering ",
  StyleBox["AdjustProgress", "Input"],
  " evaluations throughout a long operation."
}], "Text"],

Cell["\<\
It is evident that a large number of enhancements could be made to this code, \
improving the style of the window and the behavior of the progress bar; but \
this prototype suffices to demonstrate a number of useful concepts in option \
handling.\
\>", "Text"],

Cell[TextData[{
  "Unfortunately, this chapter cannot contain a definitive listing of \
options; there are enough for an entire book! For example, there are many \
options associated with the various types of boxes in typeset cells, as well \
as ",
  StyleBox["StyleBox", "Input"],
  " wrappers in text cells. The best way to find out more about these at the \
current time is to experiment with the option inspector, remembering to also \
examine the raw cell expressions."
}], "Text"]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The remaining sections of the actual text expand the above material \
significantly. The most important addition involves detailed handling of \
buttons and button functions, with several substantial examples. The book ",
  StyleBox["Elements of Mathematica Programming",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " contains the full chapter, as well as a number of other chapters with \
valuable information for the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programmer."
}], "Subsubtitle",
  CellGroupingRules->"TitleGrouping"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowToolbars->{},
WindowSize->{578, 343},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
DefaultNewCellStyle->"Text",
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "TheInputCell"->{
    Cell[60891, 1635, 188, 5, 48, "Input",
      Evaluatable->False,
      CellTags->"TheInputCell"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"TheInputCell", 90183, 2412}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 55, 3, 150, "Title"],
Cell[1797, 56, 39, 0, 53, "Subsubtitle"],
Cell[1839, 58, 647, 14, 161, "Subsubtitle"],
Cell[2489, 74, 1027, 23, 168, "Text"],
Cell[3519, 99, 145, 3, 52, "Text"],
Cell[3667, 104, 433, 11, 90, "Text"],
Cell[4103, 117, 540, 10, 109, "Text"],
Cell[4646, 129, 533, 10, 109, "Text"],
Cell[5182, 141, 487, 9, 109, "Text"],
Cell[5672, 152, 566, 11, 109, "Text"],
Cell[6241, 165, 474, 9, 109, "Text"],
Cell[6718, 176, 657, 12, 128, "Text"],

Cell[CellGroupData[{
Cell[7400, 192, 42, 0, 53, "Section"],
Cell[7445, 194, 905, 16, 166, "Text"],
Cell[8353, 212, 328, 5, 71, "Text"],
Cell[8684, 219, 854, 30, 154, "Text"],
Cell[9541, 251, 423, 9, 90, "Text"],
Cell[9967, 262, 690, 16, 109, "Text"],
Cell[10660, 280, 287, 10, 34, "Text"],
Cell[10950, 292, 901, 22, 128, "Text"],
Cell[11854, 316, 598, 13, 111, "Text"],

Cell[CellGroupData[{
Cell[12477, 333, 255, 6, 130, "Input"],
Cell[12735, 341, 238, 6, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13010, 352, 45, 1, 30, "Input"],
Cell[13058, 355, 239, 7, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13334, 367, 48, 1, 30, "Input"],
Cell[13385, 370, 594, 12, 143, "Output"]
}, Open  ]],
Cell[13994, 385, 378, 6, 90, "Text"],
Cell[14375, 393, 848, 18, 150, "Text"],

Cell[CellGroupData[{
Cell[15248, 415, 297, 6, 150, "Input"],
Cell[15548, 423, 238, 6, 29, "Output"]
}, Open  ]],
Cell[15801, 432, 1219, 22, 207, "Text"],
Cell[17023, 456, 310, 9, 53, "Text"],
Cell[17336, 467, 1024, 25, 151, "Text"],
Cell[18363, 494, 817, 14, 149, "Text"],
Cell[19183, 510, 141, 4, 34, "Text"],
Cell[19327, 516, 73, 0, 41, "Text"],
Cell[19403, 518, 186, 4, 75, "Text"],
Cell[19592, 524, 1277, 24, 187, "Text"],
Cell[20872, 550, 148, 3, 58, "Text"],
Cell[21023, 555, 190, 4, 24, "Text"],
Cell[21216, 561, 102, 4, 33, "Text"],
Cell[21321, 567, 813, 21, 130, "Text"],
Cell[22137, 590, 76, 0, 41, "Input"],
Cell[22216, 592, 1279, 28, 208, "Text"],
Cell[23498, 622, 117, 3, 58, "Text"],
Cell[23618, 627, 190, 4, 24, "Text"],
Cell[23811, 633, 80, 3, 33, "Text"],
Cell[23894, 638, 377, 13, 53, "Text"],
Cell[24274, 653, 730, 14, 132, "Text"],
Cell[25007, 669, 372, 6, 90, "Text"],
Cell[25382, 677, 130, 4, 34, "Text"],
Cell[25515, 683, 315, 9, 52, "Input"],
Cell[25833, 694, 190, 4, 24, "Text"],
Cell[26026, 700, 101, 2, 41, "Input"],
Cell[26130, 704, 941, 20, 151, "Text"],
Cell[27074, 726, 1033, 20, 168, "Text"],
Cell[28110, 748, 160, 5, 33, "Text"],
Cell[28273, 755, 165, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[28463, 762, 59, 1, 42, "Input"],
Cell[28525, 765, 75, 1, 29, "Output"]
}, Open  ]],
Cell[28615, 769, 276, 5, 71, "Text"],
Cell[28894, 776, 148, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[29067, 783, 148, 4, 48, "Input"],
Cell[29218, 789, 935, 30, 113, "Output"]
}, Open  ]],
Cell[30168, 822, 102, 3, 33, "Text"],
Cell[30273, 827, 294, 7, 54, "Text"],
Cell[30570, 836, 684, 13, 111, "Text"],
Cell[31257, 851, 678, 17, 50, "Graphics",
  Evaluatable->False],
Cell[31938, 870, 190, 4, 24, "Text"],
Cell[32131, 876, 533, 12, 34, 389, 7, "GraphicsData", "Bitmap", "Graphics",
  Evaluatable->False],
Cell[32667, 890, 754, 16, 131, "Text"],
Cell[33424, 908, 198, 5, 110, "Input"],

Cell[CellGroupData[{
Cell[33647, 917, 120, 2, 30, "Input"],
Cell[33770, 921, 238, 6, 29, "Output"]
}, Open  ]],
Cell[34023, 930, 365, 9, 72, "Text"],
Cell[34391, 941, 426, 7, 90, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[34854, 953, 45, 0, 33, "Section"],
Cell[34902, 955, 416, 9, 91, "Text"],
Cell[35321, 966, 820, 16, 147, "Text"],
Cell[36144, 984, 596, 10, 129, "Text"],
Cell[36743, 996, 854, 25, 112, "Text"],
Cell[37600, 1023, 392, 6, 90, "Text"],
Cell[37995, 1031, 316, 7, 72, "Text"],
Cell[38314, 1040, 249, 6, 53, "Text"],

Cell[CellGroupData[{
Cell[38588, 1050, 57, 1, 30, "Input"],
Cell[38648, 1053, 549, 12, 199, "Output"]
}, Open  ]],
Cell[39212, 1068, 374, 10, 73, "Text"],
Cell[39589, 1080, 1116, 22, 210, "Text"],
Cell[40708, 1104, 410, 6, 90, "Text"],
Cell[41121, 1112, 909, 17, 230, "Input"],
Cell[42033, 1131, 583, 13, 112, "Text"],

Cell[CellGroupData[{
Cell[42641, 1148, 53, 1, 30, "Input"],
Cell[42697, 1151, 238, 6, 29, "Output"]
}, Open  ]],
Cell[42950, 1160, 615, 14, 110, "Text"],
Cell[43568, 1176, 888, 28, 93, "Text"],
Cell[44459, 1206, 769, 15, 132, "Text"],
Cell[45231, 1223, 683, 11, 130, "Text"],
Cell[45917, 1236, 267, 5, 90, "Input"],
Cell[46187, 1243, 753, 16, 132, "Text"],
Cell[46943, 1261, 1279, 40, 171, "Text"],
Cell[48225, 1303, 479, 10, 92, "Text"],
Cell[48707, 1315, 6305, 169, 209, "Input"],
Cell[55015, 1486, 178, 5, 53, "Text"],
Cell[55196, 1493, 705, 12, 128, "Text"],
Cell[55904, 1507, 546, 9, 170, "Input"],
Cell[56453, 1518, 58, 1, 30, "Input"],
Cell[56514, 1521, 81, 2, 30, "Input"],
Cell[56598, 1525, 343, 6, 71, "Text"],
Cell[56944, 1533, 1408, 23, 225, "Text"],
Cell[58355, 1558, 1559, 49, 171, "Text"],
Cell[59917, 1609, 731, 15, 131, "Text"],
Cell[60651, 1626, 137, 3, 52, "Text"],
Cell[60791, 1631, 75, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[60891, 1635, 188, 5, 48, "Input",
  Evaluatable->False,
  CellTags->"TheInputCell"],
Cell[61082, 1642, 77, 1, 29, "Output"]
}, Open  ]],
Cell[61174, 1646, 355, 7, 110, "Input"],
Cell[61532, 1655, 758, 16, 131, "Text"],
Cell[62293, 1673, 491, 12, 92, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[62821, 1690, 36, 0, 33, "Section"],
Cell[62860, 1692, 676, 10, 128, "Text"],
Cell[63539, 1704, 624, 16, 112, "Text"],

Cell[CellGroupData[{
Cell[64188, 1724, 65, 1, 30, "Input"],
Cell[64256, 1727, 61, 1, 29, "Output"]
}, Open  ]],
Cell[64332, 1731, 386, 8, 73, "Text"],

Cell[CellGroupData[{
Cell[64743, 1743, 93, 1, 30, "Input"],
Cell[64839, 1746, 157, 3, 48, "Output"]
}, Open  ]],
Cell[65011, 1752, 644, 16, 113, "Text"],

Cell[CellGroupData[{
Cell[65680, 1772, 93, 1, 30, "Input"],
Cell[65776, 1775, 726, 12, 124, "Output"]
}, Open  ]],
Cell[66517, 1790, 719, 12, 129, "Text"],
Cell[67239, 1804, 538, 10, 91, "Text"],
Cell[67780, 1816, 887, 19, 153, "Text"],

Cell[CellGroupData[{
Cell[68692, 1839, 137, 2, 50, "Input"],
Cell[68832, 1843, 803, 16, 162, "Output"]
}, Open  ]],
Cell[69650, 1862, 549, 11, 111, "Text"],
Cell[70202, 1875, 530, 10, 111, "Text"],
Cell[70735, 1887, 164, 4, 50, "Input"],
Cell[70902, 1893, 204, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[71131, 1901, 36, 1, 30, "Input"],
Cell[71170, 1904, 93, 2, 29, "Output"]
}, Open  ]],
Cell[71278, 1909, 62, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[71365, 1913, 69, 1, 30, "Input"],
Cell[71437, 1916, 523, 9, 143, "Output"]
}, Open  ]],
Cell[71975, 1928, 265, 7, 54, "Text"],
Cell[72243, 1937, 81, 1, 30, "Input"],
Cell[72327, 1940, 57, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[72409, 1944, 36, 1, 30, "Input"],
Cell[72448, 1947, 117, 2, 36, "Message"],
Cell[72568, 1951, 93, 2, 29, "Output"]
}, Open  ]],
Cell[72676, 1956, 603, 10, 111, "Text"],

Cell[CellGroupData[{
Cell[73304, 1970, 83, 1, 30, "Input"],
Cell[73390, 1973, 238, 6, 29, "Output"]
}, Open  ]],
Cell[73643, 1982, 135, 5, 34, "Text"],

Cell[CellGroupData[{
Cell[73803, 1991, 58, 1, 30, "Input"],
Cell[73864, 1994, 78, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73979, 2000, 82, 1, 30, "Input"],
Cell[74064, 2003, 374, 6, 105, "Output"]
}, Open  ]],
Cell[74453, 2012, 234, 5, 53, "Text"],
Cell[74690, 2019, 477, 7, 90, "Text"],
Cell[75170, 2028, 1806, 46, 229, "Text"],
Cell[76979, 2076, 109, 3, 33, "Text"],
Cell[77091, 2081, 125, 3, 30, "Input"],
Cell[77219, 2086, 260, 5, 71, "Text"],
Cell[77482, 2093, 132, 3, 30, "Input"],
Cell[77617, 2098, 65, 0, 33, "Text"],
Cell[77685, 2100, 182, 3, 50, "Input"],
Cell[77870, 2105, 274, 6, 53, "Text"],
Cell[78147, 2113, 786, 16, 150, "Text"],
Cell[78936, 2131, 487, 7, 90, "Text"],
Cell[79426, 2140, 145, 3, 52, "Text"],
Cell[79574, 2145, 200, 3, 70, "Input"],
Cell[79777, 2150, 271, 4, 52, "Text"],
Cell[80051, 2156, 307, 5, 71, "Text"],
Cell[80361, 2163, 52, 0, 33, "Text"],
Cell[80416, 2165, 1048, 19, 390, "Input"],
Cell[81467, 2186, 618, 12, 112, "Text"],
Cell[82088, 2200, 469, 8, 92, "Text"],
Cell[82560, 2210, 1239, 24, 209, "Text"],
Cell[83802, 2236, 445, 9, 92, "Text"],
Cell[84250, 2247, 1105, 30, 152, "Text"],
Cell[85358, 2279, 957, 17, 168, "Text"],
Cell[86318, 2298, 430, 8, 150, "Input"],
Cell[86751, 2308, 383, 10, 72, "Text"],
Cell[87137, 2320, 128, 2, 50, "Input"],
Cell[87268, 2324, 46, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[87339, 2328, 70, 1, 30, "Input"],
Cell[87412, 2331, 238, 6, 29, "Output"]
}, Open  ]],
Cell[87665, 2340, 123, 3, 33, "Text"],
Cell[87791, 2345, 99, 2, 30, "Input"],
Cell[87893, 2349, 62, 1, 30, "Input"],
Cell[87958, 2352, 164, 4, 34, "Text"],
Cell[88125, 2358, 270, 5, 71, "Text"],
Cell[88398, 2365, 486, 9, 91, "Text"]
}, Closed]]
}, Open  ]],
Cell[88911, 2378, 595, 13, 125, "Subsubtitle",
  CellGroupingRules->"TitleGrouping"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

