(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    295163,       6940]
NotebookOptionsPosition[    183412,       4683]
NotebookOutlinePosition[    280624,       6683]
CellTagsIndexPosition[    279699,       6644]
WindowTitle->String Patterns and Templates: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[
   "String Patterns and Templates", "SectionInline",ExpressionUUID->
    "24077de8-b7b4-41af-ab91-a307eb5522f0"],
   $Line = 0; Null], " "}]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 41}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:255",
 CellLabel->"In[23]:=",ExpressionUUID->"b06fcce9-d1f1-4aa1-ad3f-83b38443d3ad"],

Cell[TextData[{
 "String patterns work very much like other patterns in the Wolfram Language, \
except that they operate on sequences of characters in strings rather than \
parts of expressions. In a string pattern, you can combine pattern constructs \
like ",
 Cell[BoxData[
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "471c7b06-3477-457f-943e-0daceae4410e"],
 " with strings like ",
 Cell[BoxData[
 "\"\<abc\>\""], "InlineCodeText",ExpressionUUID->
  "2cf4ec7c-89ec-4092-ba70-e23698d781fd"],
 " using ",
 Cell[BoxData[
  ButtonBox["~~",
   BaseStyle->"Link",
   ButtonData->"StringExpression"]], "InlineCodeText",ExpressionUUID->
  "6310b823-1835-4338-a756-354b434f3b3d"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"3755b7ce-c176-4d49-b5e6-5e784a4858fa"],

Cell[TextData[{
 "This picks out all instances of ",
 Cell[BoxData[
 "+"], "InlineCode",ExpressionUUID->"198e6baf-4a83-4150-b7bc-14e601a3a824"],
 " followed by a single character:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"34e06253-8c8c-49bc-995a-a899f07b625a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<+string +patterns are +quite +easy\>\"", ",", " ", 
   RowBox[{"\"\<+\>\"", "~~", "_"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"1cb2e9b5-9fb7-4c10-be97-aa3bb9a9d3de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"+s\"\>", ",", "\<\"+p\"\>", ",", "\<\"+q\"\>", 
   ",", "\<\"+e\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"8a4fd4c5-23f0-4219-9b62-ceb63def788f"]
}, Open  ]],

Cell[TextData[{
 "This picks out three characters after each ",
 Cell[BoxData[
 "+"], "InlineCode",ExpressionUUID->"89759495-8208-494f-b0b3-3f6149250f3b"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"113f2a01-c752-4063-a41b-47c2086e45e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<+string +patterns are +quite +easy\>\"", ",", " ", 
   RowBox[{"\"\<+\>\"", "~~", "_", "~~", "_", "~~", "_"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"5e9319ff-2cf3-47e4-85f4-8e102825de03"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"+str\"\>", ",", "\<\"+pat\"\>", ",", "\<\"+qui\"\>", 
   ",", "\<\"+eas\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"6453bdd6-8340-471f-a020-2629cc59225b"]
}, Open  ]],

Cell[TextData[{
 "Use the name ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"cb4399ca-4bc2-45ea-b9b3-324382829a48"],
 " for the character after each ",
 Cell[BoxData[
 "+"], "InlineCode",ExpressionUUID->"b44a66ff-21b4-4d6d-b467-1654e8f89f7c"],
 ", and return that character framed: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"366427e2-a212-4ad9-8ac2-57414f2020cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<+string +patterns are +quite +easy\>\"", ",", " ", 
   RowBox[{
    RowBox[{"\"\<+\>\"", "~~", "x_"}], "\[Rule]", 
    RowBox[{"Framed", "[", "x", "]"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"667c4beb-b912-4f3b-b079-f34e33d0e13d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox["\<\"s\"\>",
    StripOnInput->False], ",", 
   FrameBox["\<\"p\"\>",
    StripOnInput->False], ",", 
   FrameBox["\<\"q\"\>",
    StripOnInput->False], ",", 
   FrameBox["\<\"e\"\>",
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"4c718184-e3ac-43d4-b674-adfafd05cdfd"]
}, Open  ]],

Cell[TextData[{
 "In a string pattern, ",
 Cell[BoxData[
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "66db201f-4eab-44e0-bb89-b3685e245338"],
 " stands for any single character. ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"_", "\[ThinSpace]", "_"}],
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCodeText",ExpressionUUID->
  "5132e4a4-6869-43e7-b467-908c15c737e1"],
 " (\[OpenCurlyDoubleQuote]double blank\[CloseCurlyDoubleQuote]) stands for \
any sequence of one or more characters, and ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"_", "\[ThinSpace]", "_", "\[ThinSpace]", "_"}],
   BaseStyle->"Link",
   ButtonData->"BlankNullSequence"]], "InlineCodeText",ExpressionUUID->
  "925efac1-c2c7-410a-86c1-f1c0110c01ad"],
 " (\[OpenCurlyDoubleQuote]triple blank\[CloseCurlyDoubleQuote]) stands for \
any sequence of zero or more characters. ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"_", "\[ThinSpace]", "_"}],
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCodeText",ExpressionUUID->
  "9c358b59-c433-43e3-8ae0-6ceef4b9c085"],
 " and ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"_", "\[ThinSpace]", "_", "\[ThinSpace]", "_"}],
   BaseStyle->"Link",
   ButtonData->"BlankNullSequence"]], "InlineCodeText",ExpressionUUID->
  "0ca7c575-faa2-460a-b3af-456cca3855bf"],
 " will normally grab as much of the string as they can."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"d5b3304d-2452-495b-978f-111c7baad48a"],

Cell[TextData[{
 "Pick out the sequence of characters between ",
 Cell[BoxData[
 "["], "InlineCode",ExpressionUUID->"c40883d8-5845-44fc-80ed-d81f78c117e6"],
 " and ",
 Cell[BoxData[
 "]"], "InlineCode",ExpressionUUID->"e44fd635-6e84-4f6e-b44f-7e3ba6c85d3a"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"67783737-6b5c-4456-a3ad-8ef1254b214f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the [important] word\>\"", ",", " ", 
   RowBox[{
    RowBox[{"\"\<[\>\"", "~~", "x__", "~~", "\"\<]\>\""}], "\[Rule]", 
    RowBox[{"Framed", "[", "x", "]"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"9f56850c-504e-4f62-bcb1-8d7ead4c645b"],

Cell[BoxData[
 RowBox[{"{", 
  FrameBox["\<\"important\"\>",
   StripOnInput->False], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"38f422a6-f6a0-45cf-8488-2237099cfb8d"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"_", "\[ThinSpace]", "_"}],
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCode",ExpressionUUID->
  "75d1291a-3b08-4ca5-afc1-6050fbc5a2f3"],
 " normally matches as long a sequence of characters as it can:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a40b7db1-367f-4074-98c7-68e53111e95a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<now [several] important [words]\>\"", ",", " ", 
   RowBox[{
    RowBox[{"\"\<[\>\"", "~~", "x__", "~~", "\"\<]\>\""}], "\[Rule]", 
    RowBox[{"Framed", "[", "x", "]"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"4489116d-fab1-4755-87fc-ff20bb35fad6"],

Cell[BoxData[
 RowBox[{"{", 
  FrameBox["\<\"several] important [words\"\>",
   StripOnInput->False], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"c266e2f8-9ef2-436d-b38e-a81291bf93c6"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Shortest",
  BaseStyle->"Link"],
 " forces the shortest match:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"9a1b9b07-4459-4a52-a7cb-ff26d608f9ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<now [several] important [words]\>\"", ",", " ", 
   RowBox[{
    RowBox[{"\"\<[\>\"", "~~", 
     RowBox[{"Shortest", "[", "x__", "]"}], "~~", "\"\<]\>\""}], "\[Rule]", 
    RowBox[{"Framed", "[", "x", "]"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"b43806e2-0d00-48d9-9b37-189c94929d8b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox["\<\"several\"\>",
    StripOnInput->False], ",", 
   FrameBox["\<\"words\"\>",
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"5df0ec88-5db1-4ced-9739-9663514f0099"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringCases",
  BaseStyle->"Link"],
 " picks out cases of a particular pattern in a string. ",
 ButtonBox["StringReplace",
  BaseStyle->"Link"],
 " makes replacements."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e71a8619-af65-46d4-ba66-ea1d900a7fb3"],

Cell["Make replacements for characters in the string:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"bb2b6bcd-fc64-4870-b496-0ed2b72483fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<now [several] important [words]\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<<<\>\""}], ",", 
     RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<>>\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"7daa5a7b-e2a1-4d02-8d44-8e7f982dcb18"],

Cell[BoxData["\<\"now <<several>> important <<words>>\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[7]=",ExpressionUUID->"f7685304-5dde-4c5a-ad80-3024627662bd"]
}, Open  ]],

Cell[TextData[{
 "Make replacements for patterns, using ",
 Cell[BoxData[
  ButtonBox["\[RuleDelayed]",
   BaseStyle->"Link",
   ButtonData->"RuleDelayed"]], "InlineCode",ExpressionUUID->
  "966e22c3-a915-4c58-afae-3484c721f25c"],
 " to compute ",
 ButtonBox["ToUpperCase",
  BaseStyle->"Link"],
 " in each case:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:256",ExpressionUUID->"ad5e9bb2-195a-4833-abe9-a3e75d8259aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<now [several] important [words]\>\"", ",", " ", 
   RowBox[{
    RowBox[{"\"\<[\>\"", "~~", 
     RowBox[{"Shortest", "[", "x__", "]"}], "~~", "\"\<]\>\""}], 
    "\[RuleDelayed]", 
    RowBox[{"ToUpperCase", "[", "x", "]"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"37c9374b-3557-4c0b-902f-a7cd5804d457"],

Cell[BoxData["\<\"now SEVERAL important WORDS\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"8f4d4d9a-9b4e-4c94-8859-feddd7996afa"]
}, Open  ]],

Cell[TextData[{
 "Use ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 " to apply a string replacement repeatedly:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"d0d0965c-780d-4ddd-8f4e-2a812fe64f37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringReplace", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<AB\>\""}], ",", 
        RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<BA\>\""}]}], "}"}]}], "]"}], 
    "&"}], ",", "\"\<A\>\"", ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"5df2ad75-7542-4111-9755-144b1fa00794"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"AB\"\>", ",", "\<\"ABBA\"\>", 
   ",", "\<\"ABBABAAB\"\>", ",", "\<\"ABBABAABBAABABBA\"\>", 
   ",", "\<\"ABBABAABBAABABBABAABABBAABBABAAB\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"97dae070-a955-4fa3-a0a6-c37f060b53de"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringMatchQ",
  BaseStyle->"Link"],
 " tests whether a string matches a pattern."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"cf74ceef-32f6-45ab-9b3c-056c2e97014f"],

Cell[TextData[{
 "Select common words that match the pattern of beginning with ",
 Cell[BoxData[
 "a"], "InlineCode",ExpressionUUID->"01b45923-4ec4-4436-baf6-9ec915ee9e7e"],
 " and ending with ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"0b70d530-34cd-4967-bb60-33dcce83a063"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2259330f-ddcb-4863-834a-e3f72679efad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"WordList", "[", " ", "]"}], ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"\"\<a\>\"", "~~", "___", "~~", "\"\<b\>\""}]}], "]"}], "&"}]}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"3d44e525-35cd-40e9-8516-59025bac5176"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"absorb\"\>", ",", "\<\"adsorb\"\>", ",", "\<\"adverb\"\>", 
   ",", "\<\"alb\"\>", ",", "\<\"aplomb\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"1bacdf79-c94a-4a52-8f4d-b0fd59be629e"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"Alternatives"]], "InlineCodeText",ExpressionUUID->
  "eb486bee-e98e-42c4-8ee6-7c40ab07424f"],
 " and ",
 Cell[BoxData[
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"Repeated"]], "InlineCodeText",ExpressionUUID->
  "ef36e17f-8a26-4f84-9381-0fe676dd8652"],
 " in string patterns just like in ordinary patterns. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"fcfff13d-9606-4570-9554-200cf8836734"],

Cell["Pick out any sequence of A or B repeated:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4d31d2dc-7a72-41c5-8fc0-0453e587b40e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<the AAA and the BBB and the ABABBBABABABA\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<A\>\"", "|", "\"\<B\>\""}], ")"}], ".."}]}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"c6c38424-91d9-4fa7-81de-85b839a5abb0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AAA\"\>", ",", "\<\"BBB\"\>", ",", "\<\"ABABBBABABABA\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"9da2682b-1309-465a-949e-09d3381cc7e2"]
}, Open  ]],

Cell[TextData[{
 "In a string pattern, ",
 ButtonBox["LetterCharacter",
  BaseStyle->"Link"],
 " stands for any letter character, ",
 ButtonBox["DigitCharacter",
  BaseStyle->"Link"],
 " for any digit character and ",
 ButtonBox["Whitespace",
  BaseStyle->"Link"],
 " for any sequence of \[OpenCurlyDoubleQuote]white\[CloseCurlyDoubleQuote] \
characters such as spaces."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"5a4769e4-b7aa-43e4-932e-c346f203917c"],

Cell["Pick out sequences of digit characters:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a213c363-4e9f-49d6-a56f-de9fae29eae5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<12 and 123 and 4567 and 0x456\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"ec19a97c-244c-402b-8966-4a6de7f1b89c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"12\"\>", ",", "\<\"123\"\>", ",", "\<\"4567\"\>", 
   ",", "\<\"0\"\>", ",", "\<\"456\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"6106554c-00f5-4e6b-94ff-46089f3b902d"]
}, Open  ]],

Cell["\<\
Pick out sequences of digit characters \[OpenCurlyDoubleQuote]flanked\
\[CloseCurlyDoubleQuote] by whitespace:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b61e0373-3f22-494a-b6a6-498f0eb23962"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<12 and 123 and 4567 and 0x456\>\"", ",", 
   RowBox[{"Whitespace", "~~", 
    RowBox[{"DigitCharacter", ".."}], "~~", "Whitespace"}]}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"4f370568-fa3c-4e7b-9500-031d6dd266e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\" 123 \"\>", ",", "\<\" 4567 \"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"16b71ca0-c3dc-46d9-9921-d08b3a2c10a2"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s common in practice to want to go back and forth \
between strings and lists. You can split a string into a list of pieces using \
",
 ButtonBox["StringSplit",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"29fce3c7-1985-40b0-9cd7-7597d20906a8"],

Cell["\<\
Split a string into a list of pieces, by default breaking at spaces:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"483ef844-3b9b-422c-8013-e69424ac54de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<a string to split\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"a02ef30d-6241-4d74-962a-38175190500f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"string\"\>", ",", "\<\"to\"\>", 
   ",", "\<\"split\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"c3dc160c-21f2-422d-826d-d4842cdc50ad"]
}, Open  ]],

Cell["This uses a string pattern to decide where to split:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d3c8f85f-263b-4fd3-8e28-d0b1b3e9c259"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<you+can+split--at+any--delimiter\>\"", ",", 
   RowBox[{"\"\<+\>\"", "|", "\"\<--\>\""}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"481e3a4f-7f96-4738-b8c5-c5e9ef36bceb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"you\"\>", ",", "\<\"can\"\>", ",", "\<\"split\"\>", 
   ",", "\<\"at\"\>", ",", "\<\"any\"\>", ",", "\<\"delimiter\"\>"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[15]=",ExpressionUUID->"8fdda2c9-a729-42bf-8b63-17b25100e275"]
}, Open  ]],

Cell[TextData[{
 "Within strings, there\[CloseCurlyQuote]s a special newline character which \
indicates where the string should break onto a new line. The newline \
character is represented within strings as ",
 Cell[BoxData[
 "\\n"], "InlineCodeText",ExpressionUUID->
  "736f4270-9336-46c7-916e-e0a139828071"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:257", "i:11"},ExpressionUUID->"5b6d6cfb-9253-40eb-876d-0efed4a287f9"],

Cell["Split at newlines:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c2d18b70-aed7-4c73-b29d-d87601d8c1ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<first line\nsecond line\nthird line\>\"", ",", "\"\<\\n\>\""}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"2eecec11-16c5-4d10-ac3f-89104301edbf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"first line\"\>", ",", "\<\"second line\"\>", 
   ",", "\<\"third line\"\>"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"83b166fc-a185-49f9-990c-32d5506d8b7c"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["StringJoin",
  BaseStyle->"Link"],
 " joins any list of strings together. In practice, though, one often wants \
to insert something between the strings before joining them. ",
 ButtonBox["StringRiffle",
  BaseStyle->"Link"],
 " does this."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"a13204df-fdb1-4047-a319-256c6bfdb23b"],

Cell[TextData[{
 "Join strings, riffling the string ",
 Cell[BoxData["\<\"---\"\>"], "InlineCode",ExpressionUUID->
  "800ed1ea-440a-48fc-8b39-4e6c4592e240"],
 " in between them:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSyntaxStyles->
  False,ExpressionUUID->"433b8c22-3e70-495c-958f-a8b7029b011f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringRiffle", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<a\>\"", ",", "\"\<list\>\"", ",", "\"\<of\>\"", ",", 
     "\"\<strings\>\""}], "}"}], ",", "\"\<---\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"cbb98337-f620-4152-a8cf-ae243a21da82"],

Cell[BoxData["\<\"a---list---of---strings\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"3b3eefc2-0283-4ebf-a61d-d2f123c19b6f"]
}, Open  ]],

Cell[TextData[{
 "In assembling strings, one often wants to turn arbitrary Wolfram Language \
expressions into strings. One can do this using ",
 ButtonBox["TextString",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"58545237-5f96-41e0-878a-db161d1f3c22"],

Cell[TextData[{
 ButtonBox["TextString",
  BaseStyle->"Link"],
 " turns numbers and other Wolfram Language expressions into strings:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"07b8eef4-2687-45ee-a8c5-466d0fb11619"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"\"\<two to the \>\"", ",", 
   RowBox[{"TextString", "[", "50", "]"}], ",", "\"\< is \>\"", ",", 
   RowBox[{"TextString", "[", 
    RowBox[{"2", "^", "50"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"600abfac-6225-470d-b97d-19d0bd371e3e"],

Cell[BoxData["\<\"two to the 50 is 1125899906842624\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"2a45f7e5-4c29-4c1f-9779-fa3c7db7d4ed"]
}, Open  ]],

Cell[TextData[{
 "A more convenient way to create strings from expressions is to use ",
 StyleBox["string templates",
  FontSlant->"Italic"],
 ". String templates work like pure functions in that they have slots into \
which arguments can be inserted. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"2170f7f9-b0db-4068-b7f3-96476bdcc590"],

Cell[TextData[{
 "In a string template each ",
 Cell[BoxData[
  ButtonBox["``",
   BaseStyle->"Link",
   ButtonData->"TemplateSlot"]], "InlineCode",ExpressionUUID->
  "36ec1aed-6889-445f-8508-16e26fdd038f"],
 " is a slot for a successive argument: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"e9a205f4-053c-43fd-ba60-c30b7185469b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringTemplate", "[", "\"\<first `` then ``\>\"", "]"}], "[", 
  RowBox[{"100", ",", "200"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"cfb31a6c-9e66-4c0f-a672-1e7c44d0227f"],

Cell[BoxData["\<\"first 100 then 200\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"1be52ccb-2d4a-4efe-9905-bbd77baf31ac"]
}, Open  ]],

Cell["Named slots pick elements from an association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"639d4081-557f-43df-bfd9-827df3b1eb90"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "StringTemplate", "[", "\"\<first: `a`; second `b`; first again `a`\>\"", 
   "]"}], "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "\[Rule]", "\"\<AAAA\>\""}], ",", " ", 
    RowBox[{"\"\<b\>\"", "\[Rule]", "\"\<BB BBB\>\""}]}], 
   "\[RightAssociation]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"75983e50-39e7-4475-aee8-0f91ee2aa8d7"],

Cell[BoxData["\<\"first: AAAA; second BB BBB; first again AAAA\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"34eab068-0174-4f65-8054-83f259cdcf31"]
}, Open  ]],

Cell[TextData[{
 "You can insert any expression within a string template by enclosing it with \
",
 ButtonBox["<*",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
 StyleBox[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
  FontColor->GrayLevel[0.6]],
 ButtonBox["*>",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
 ". The value of the expression is computed when the template is applied."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2afdabf8-2046-44fb-9d9c-28159fcccbc1"],

Cell[TextData[{
 "Evaluate the ",
 ButtonBox["<*",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
 StyleBox[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
  FontColor->GrayLevel[0.6]],
 ButtonBox["*>",
  BaseStyle->"Link",
  ButtonData->"TemplateExpression"],
 " when the template is applied; no arguments are needed:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"250b4070-b0ad-4a21-9c7a-06753e65ff1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringTemplate", "[", "\"\<2 to the 50 is <* 2^50 *>\>\"", "]"}], 
  "[", " ", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"f1463554-9ab9-4b22-b418-559fdb3fac2a"],

Cell[BoxData["\<\"2 to the 50 is 1125899906842624\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[21]=",ExpressionUUID->"8b3fe170-f07d-4c63-8b4e-fd1d8f7db514"]
}, Open  ]],

Cell[TextData[{
 "Use slots in the template (",
 Cell[BoxData[
 "`"], "InlineCode",ExpressionUUID->"222ed332-8a4d-403b-9f6d-3fa1e09be697"],
 " is the backquote character):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:258", "i:17"},ExpressionUUID->"f7171858-2d7b-4767-a730-64eed13de514"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "StringTemplate", "[", "\"\<`1` to the `2` is <* #1^#2 *>\>\"", "]"}], "[", 
  
  RowBox[{"2", ",", "50"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"ee0d63a4-be5f-4123-9271-f0659ce44ddf"],

Cell[BoxData["\<\"2 to the 50 is 1125899906842624\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"6b6dcbe8-d6e3-471e-b1cf-619da1bd1b92"]
}, Open  ]],

Cell["\<\
The expression in the template is evaluated when the template is applied:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"d3659c47-66d8-45f0-ae7a-24036981beef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringTemplate", "[", "\"\<the time now is <* Now *>\>\"", "]"}], 
  "[", " ", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"92abbd93-f9e0-4614-a065-bf9539af024b"],

Cell[BoxData["\<\"the time now is Wed 16 Sep 2015 16:50:43\"\>"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"55217262-c9e7-423f-bb3b-a93164a0fac4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0e9f9b55-5eb7-4541-acff-c10df62e19bd"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["patt", "CodeVariableLrg"], "1"], 
     ButtonBox["~~",
      BaseStyle->"CodeLink",
      ButtonData->"StringExpression"], 
     SubscriptBox[
      StyleBox["patt", "CodeVariableLrg"], "2"]}], " ", Cell[
    "sequence of string patterns ", "VocabularyText",ExpressionUUID->
     "f19704ee-b4f5-4c84-81f4-034a01a48a23"]},
   {
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["patt", "CodeVariableLrg"], "]"}], " ", Cell[
    "shortest sequence that matches ", "VocabularyText",ExpressionUUID->
     "47b84ce3-ed4f-4e09-8667-a4ebaa838236"]},
   {
    RowBox[{
     ButtonBox["StringCases",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["string", "CodeVariableLrg"], ",", 
      StyleBox["patt", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "cases within a string matching a pattern ", "VocabularyText",
     ExpressionUUID->"08da5356-bae7-4e0a-b053-336dacc5d621"]},
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["string", "CodeVariableLrg"], ",", 
      RowBox[{
       StyleBox["patt", "CodeVariableLrg"], 
       ButtonBox["\[Rule]",
        BaseStyle->"Link",
        ButtonData->"Rule"], 
       StyleBox["val", "CodeVariableLrg"]}]}], "]"}], " ", Cell[
    "replace a pattern within a string  ", "VocabularyText",ExpressionUUID->
     "234ab7c1-bbc1-4242-b850-43b874d92f05"]},
   {
    RowBox[{
     ButtonBox["StringMatchQ",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["string", "CodeVariableLrg"], ",", 
      StyleBox["patt", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "test whether a string matches a pattern ", "VocabularyText",
     ExpressionUUID->"115c5477-ac8d-4d82-8cc6-c499d7f1b0a3"]},
   {
    ButtonBox["LetterCharacter",
     BaseStyle->"CodeLink"], " ", Cell[
    "pattern construct matching a letter ", "VocabularyText",ExpressionUUID->
     "9b1adbd6-893e-4c3d-8371-c4bcb12478d8"]},
   {
    ButtonBox["DigitCharacter",
     BaseStyle->"CodeLink"], " ", Cell[
    "pattern construct matching a digit ", "VocabularyText",ExpressionUUID->
     "10a2cb3e-9db1-4f1c-b38b-a69e2a91cc95"]},
   {
    ButtonBox["Whitespace",
     BaseStyle->"CodeLink"], " ", Cell[
    "pattern construct matching spaces, etc.", "VocabularyText",
     ExpressionUUID->"92bb2892-d86d-48ac-af0a-91394ce307b9"]},
   {"\\n", " ", Cell[
    "newline character ", "VocabularyText",ExpressionUUID->
     "371e9cf4-1ad4-43ca-8d44-b0b1bcd785c2"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["string", "CodeVariableLrg"], "]"}], " ", Cell[
    "split a string into a list of pieces ", "VocabularyText",ExpressionUUID->
     "a9a182b3-6c91-41c0-9991-1315eaef1b2e"]},
   {
    RowBox[{
     ButtonBox["StringJoin",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["string", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["string", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "join strings together ", "VocabularyText",ExpressionUUID->
     "79565fcc-e13d-4eff-94c3-87c512a8fff7"]},
   {
    RowBox[{
     ButtonBox["StringRiffle",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["string", "CodeVariableLrg"], "1"], ",", 
        SubscriptBox[
         StyleBox["string", "CodeVariableLrg"], "2"], ",", " ", 
        StyleBox["...", "GrayPointSix"]}], "}"}], ",", 
      StyleBox["m", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "join strings, inserting ",
     Cell[BoxData[
      StyleBox["m", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fb372f2c-533e-4510-9209-b360e2513ba8"],
     " between them "
    }], "VocabularyText",ExpressionUUID->
     "8c510a18-5513-431f-8eb1-13a769a239e4"]},
   {
    RowBox[{
     ButtonBox["TextString",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "make a text string out of anything ", "VocabularyText",ExpressionUUID->
     "fd58c024-9a50-46df-8300-d712816c87ba"]},
   {
    RowBox[{
     ButtonBox["StringTemplate",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["string", "CodeVariableLrg"], "]"}], " ", Cell[
    "create a string template to apply ", "VocabularyText",ExpressionUUID->
     "7944dbab-4118-4fd4-a30d-a727de7bf716"]},
   {
    ButtonBox["``",
     BaseStyle->"Link",
     ButtonData->"Accuracy"], " ", Cell[
    "slot in a string template", "VocabularyText",ExpressionUUID->
     "f96c7cc6-262d-4ce2-bfa1-c7d30a60dc0b"]},
   {
    ButtonBox[
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"<", "\[NegativeThinSpace]\[NegativeThinSpace]", "*"}], 
        StyleBox["...", "GrayPointSix"]}], "*"}], "\[NegativeThinSpace]", 
      ">"}],
     BaseStyle->"Link",
     ButtonData->"TemplateExpression"], " ", Cell[
    "expression to evaluate in a string template ", "VocabularyText",
     ExpressionUUID->"28cd1db6-e448-468a-873d-e62f1fe14eb3"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True}, False}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"67063ab0-b230-4228-b300-b1d511c04921"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"86c0862d-1ade-41ea-9d1c-b8e9e85b0d1c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-42-string-patterns-and-templates-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"41a1d41a-0072-44b8-a201-7fec057cebcf"],

Cell[CellGroupData[{

Cell[TextData[{
 "Replace each space in ",
 Cell[BoxData["\<\"1 2 3 4\"\>"], "InlineCode",ExpressionUUID->
  "7d775c0f-2f08-4223-8af8-7e0f51909bb5"],
 " with ",
 Cell[BoxData["\<\"---\"\>"], "InlineCode",ExpressionUUID->
  "f49f49f5-9f99-44dd-a1d5-11c4b9b98b4d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6c082fe7-7b78-4bf4-86f4-b6065f0cf318"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"1---2---3---4\"\>"], "ExerciseOutput",ExpressionUUID->
       "89df0ace-57b5-4ef2-8fe6-d7793edb7c4d"],
      Apply[TextCell, 
       Cell[
        BoxData["\"1---2---3---4\""], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6f912bd0-1cc0-4d66-acc5-b7555d0b6c8b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Get a sorted list of all sequences of 4 digits (representing possible \
dates) in the Wikipedia article on computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"64d041a3-e314-45df-bda2-8fc0b747b5aa"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"1000\"\>", ",", "\<\"1235\"\>", ",", "\<\"1357\"\>", 
         ",", "\<\"1357\"\>", ",", "\<\"1500\"\>", ",", "\<\"1595\"\>", 
         ",", "\<\"1613\"\>", ",", "\<\"1620\"\>", ",", "\<\"1630\"\>", 
         ",", "\<\"1770\"\>", ",", "\<\"1833\"\>", ",", "\<\"1872\"\>", 
         ",", "\<\"1872\"\>", ",", "\<\"1876\"\>", ",", "\<\"1876\"\>", 
         ",", "\<\"1888\"\>", ",", "\<\"1901\"\>", ",", "\<\"1906\"\>", 
         ",", "\<\"1920\"\>", ",", "\<\"1927\"\>", ",", "\<\"1930\"\>", 
         ",", "\<\"1931\"\>", ",", "\<\"1934\"\>", ",", "\<\"1936\"\>", 
         ",", "\<\"1936\"\>", ",", "\<\"1938\"\>", ",", "\<\"1939\"\>", 
         ",", "\<\"1941\"\>", ",", "\<\"1942\"\>", ",", "\<\"1943\"\>", 
         ",", "\<\"1943\"\>", ",", "\<\"1943\"\>", ",", "\<\"1944\"\>", 
         ",", "\<\"1945\"\>", ",", "\<\"1945\"\>", ",", "\<\"1945\"\>", 
         ",", "\<\"1945\"\>", ",", "\<\"1947\"\>", ",", "\<\"1947\"\>", 
         ",", "\<\"1947\"\>", ",", "\<\"1948\"\>", ",", "\<\"1950\"\>", 
         ",", "\<\"1950\"\>", ",", "\<\"1951\"\>", ",", "\<\"1951\"\>", 
         ",", "\<\"1952\"\>", ",", "\<\"1953\"\>", ",", "\<\"1953\"\>", 
         ",", "\<\"1955\"\>", ",", "\<\"1955\"\>", ",", "\<\"1955\"\>", 
         ",", "\<\"1957\"\>", ",", "\<\"1958\"\>", ",", "\<\"1958\"\>", 
         ",", "\<\"1959\"\>", ",", "\<\"1970\"\>", ",", "\<\"1970\"\>", 
         ",", "\<\"1990\"\>", ",", "\<\"2000\"\>", ",", "\<\"2000\"\>", 
         ",", "\<\"2013\"\>", ",", "\<\"2400\"\>", ",", "\<\"2400\"\>", 
         ",", "\<\"2468\"\>", ",", "\<\"4004\"\>", ",", "\<\"5000\"\>"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "6dc16df9-dcc8-4463-ba3f-e79164b37dce"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"1000\"", ",", "\"1235\"", ",", "\"1357\"", ",", 
             "\"1357\"", ",", "\"1500\"", ",", "\"1595\"", ",", "\"1613\"", 
             ",", "\"1620\"", ",", "\"1630\"", ",", "\"1770\"", ",", 
             "\"1833\"", ",", "\"1872\"", ",", "\"1872\"", ",", "\"1876\"", 
             ",", "\"1876\"", ",", "\"1888\"", ",", "\"1901\"", ",", 
             "\"1906\"", ",", "\"1920\"", ",", "\"1927\"", ",", "\"1930\"", 
             ",", "\"1931\"", ",", "\"1934\"", ",", "\"1936\"", ",", 
             "\"1936\"", ",", "\"1938\"", ",", "\"1939\"", ",", "\"1941\"", 
             ",", "\"1942\"", ",", "\"1943\"", ",", "\"1943\"", ",", 
             "\"1943\"", ",", "\"1944\"", ",", "\"1945\"", ",", "\"1945\"", 
             ",", "\"1945\"", ",", "\"1945\"", ",", "\"1947\"", ",", 
             "\"1947\"", ",", "\"1947\"", ",", "\"1948\"", ",", "\"1950\"", 
             ",", "\"1950\"", ",", "\"1951\"", ",", "\"1951\"", ",", 
             "\"1952\"", ",", "\"1953\"", ",", "\"1953\"", ",", "\"1955\"", 
             ",", "\"1955\"", ",", "\"1955\"", ",", "\"1957\"", ",", 
             "\"1958\"", ",", "\"1958\"", ",", "\"1959\"", ",", "\"1970\"", 
             ",", "\"1970\"", ",", "\"1990\"", ",", "\"2000\"", ",", 
             "\"2000\"", ",", "\"2013\"", ",", "\"2400\"", ",", "\"2400\"", 
             ",", "\"2468\"", ",", "\"4004\"", ",", "\"5000\""}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cb04ffca-2de8-4bd9-ba15-7e170bd2135e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Extract \[OpenCurlyDoubleQuote]headings\[CloseCurlyDoubleQuote] in the \
Wikipedia article about computers, as indicated by strings starting and \
ending with ",
 Cell[BoxData["\<\"===\"\>"], "InlineCode",ExpressionUUID->
  "411dfbb1-7c1f-4873-a55b-64aa02ef2330"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2aa16d20-8bf4-4495-b7ea-aa16b75d2bb0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\" Pre-twentieth century \"\>", 
         ",", "\<\" First general-purpose computing device \"\>", 
         ",", "\<\" Later Analog computers \"\>", 
         ",", "\<\" Digital computer development \"\>", 
         ",", "\<\"= Electromechanical \"\>", 
         ",", "\<\"= Vacuum tubes and digital electronic circuits \"\>", 
         ",", "\<\"= Stored programs \"\>", ",", "\<\"= Transistors \"\>", 
         ",", "\<\"= Integrated circuits \"\>", 
         ",", "\<\" Mobile computers become dominant \"\>", 
         ",", "\<\" Stored program architecture \"\>", 
         ",", "\<\" Machine code \"\>", ",", "\<\" Programming language \"\>",
          ",", "\<\"= Low-level languages \"\>", 
         ",", "\<\"= High-level languages/Third Generation Language \"\>", 
         ",", "\<\" Fourth Generation Languages \"\>", 
         ",", "\<\" Program design \"\>", ",", "\<\" Bugs \"\>", 
         ",", "\<\" Control unit \"\>", 
         ",", "\<\" Central Processing unit (CPU) \"\>", 
         ",", "\<\" Arithmetic logic unit (ALU) \"\>", 
         ",", "\<\" Memory \"\>", ",", "\<\" Input/output (I/O) \"\>", 
         ",", "\<\" Multitasking \"\>", ",", "\<\" Multiprocessing \"\>", 
         ",", "\<\" Computer architecture paradigms \"\>", 
         ",", "\<\" Unconventional computing \"\>", 
         ",", "\<\" Artificial intelligence \"\>", 
         ",", "\<\" History of computing hardware \"\>", 
         ",", "\<\" Other hardware topics \"\>", ",", "\<\" Firmware \"\>", 
         ",", "\<\" Liveware \"\>", ",", "\<\" Based on uses \"\>", 
         ",", "\<\" Based on sizes \"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"17ae4e3f-9676-40b4-8f5d-54b9a16473ce"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
            "\" Pre-twentieth century \"", ",", 
             "\" First general-purpose computing device \"", ",", 
             "\" Later Analog computers \"", ",", 
             "\" Digital computer development \"", ",", 
             "\"= Electromechanical \"", ",", 
             "\"= Vacuum tubes and digital electronic circuits \"", ",", 
             "\"= Stored programs \"", ",", "\"= Transistors \"", ",", 
             "\"= Integrated circuits \"", ",", 
             "\" Mobile computers become dominant \"", ",", 
             "\" Stored program architecture \"", ",", "\" Machine code \"", 
             ",", "\" Programming language \"", ",", 
             "\"= Low-level languages \"", ",", 
             "\"= High-level languages/Third Generation Language \"", ",", 
             "\" Fourth Generation Languages \"", ",", "\" Program design \"",
              ",", "\" Bugs \"", ",", "\" Control unit \"", ",", 
             "\" Central Processing unit (CPU) \"", ",", 
             "\" Arithmetic logic unit (ALU) \"", ",", "\" Memory \"", ",", 
             "\" Input/output (I/O) \"", ",", "\" Multitasking \"", ",", 
             "\" Multiprocessing \"", ",", 
             "\" Computer architecture paradigms \"", ",", 
             "\" Unconventional computing \"", ",", 
             "\" Artificial intelligence \"", ",", 
             "\" History of computing hardware \"", ",", 
             "\" Other hardware topics \"", ",", "\" Firmware \"", ",", 
             "\" Liveware \"", ",", "\" Based on uses \"", ",", 
             "\" Based on sizes \""}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8fa6d3cf-1216-4861-ac7d-7be7f23be981"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use a string template to make a grid of results of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"i", "+", "j"}], "=", 
   StyleBox["...", "GrayPointSix"]}]], "InlineCode",ExpressionUUID->
  "a157dfb2-2828-4642-86fe-6595df330b88"],
 " for ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"78f47c29-a817-4f90-a6ce-d3e4731cb37e"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"8ec98780-dd8a-4e12-8054-68d5b279bb01"],
 " up to 9.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"586035f3-5bf2-4435-9870-d768f7cfbbea"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"1+1=2\"\>", "\<\"1+2=3\"\>", "\<\"1+3=4\"\>", \
"\<\"1+4=5\"\>", "\<\"1+5=6\"\>", "\<\"1+6=7\"\>", "\<\"1+7=8\"\>", \
"\<\"1+8=9\"\>", "\<\"1+9=10\"\>"},
          {"\<\"2+1=3\"\>", "\<\"2+2=4\"\>", "\<\"2+3=5\"\>", \
"\<\"2+4=6\"\>", "\<\"2+5=7\"\>", "\<\"2+6=8\"\>", "\<\"2+7=9\"\>", \
"\<\"2+8=10\"\>", "\<\"2+9=11\"\>"},
          {"\<\"3+1=4\"\>", "\<\"3+2=5\"\>", "\<\"3+3=6\"\>", \
"\<\"3+4=7\"\>", "\<\"3+5=8\"\>", "\<\"3+6=9\"\>", "\<\"3+7=10\"\>", \
"\<\"3+8=11\"\>", "\<\"3+9=12\"\>"},
          {"\<\"4+1=5\"\>", "\<\"4+2=6\"\>", "\<\"4+3=7\"\>", \
"\<\"4+4=8\"\>", "\<\"4+5=9\"\>", "\<\"4+6=10\"\>", "\<\"4+7=11\"\>", \
"\<\"4+8=12\"\>", "\<\"4+9=13\"\>"},
          {"\<\"5+1=6\"\>", "\<\"5+2=7\"\>", "\<\"5+3=8\"\>", \
"\<\"5+4=9\"\>", "\<\"5+5=10\"\>", "\<\"5+6=11\"\>", "\<\"5+7=12\"\>", \
"\<\"5+8=13\"\>", "\<\"5+9=14\"\>"},
          {"\<\"6+1=7\"\>", "\<\"6+2=8\"\>", "\<\"6+3=9\"\>", \
"\<\"6+4=10\"\>", "\<\"6+5=11\"\>", "\<\"6+6=12\"\>", "\<\"6+7=13\"\>", \
"\<\"6+8=14\"\>", "\<\"6+9=15\"\>"},
          {"\<\"7+1=8\"\>", "\<\"7+2=9\"\>", "\<\"7+3=10\"\>", \
"\<\"7+4=11\"\>", "\<\"7+5=12\"\>", "\<\"7+6=13\"\>", "\<\"7+7=14\"\>", \
"\<\"7+8=15\"\>", "\<\"7+9=16\"\>"},
          {"\<\"8+1=9\"\>", "\<\"8+2=10\"\>", "\<\"8+3=11\"\>", "\<\"8+4=12\"\
\>", "\<\"8+5=13\"\>", "\<\"8+6=14\"\>", "\<\"8+7=15\"\>", "\<\"8+8=16\"\>", \
"\<\"8+9=17\"\>"},
          {"\<\"9+1=10\"\>", "\<\"9+2=11\"\>", "\<\"9+3=12\"\>", \
"\<\"9+4=13\"\>", "\<\"9+5=14\"\>", "\<\"9+6=15\"\>", "\<\"9+7=16\"\>", \
"\<\"9+8=17\"\>", "\<\"9+9=18\"\>"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "b00f304f-a1bc-497c-9b6b-b5206e823d28"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "\"1+1=2\"", "\"1+2=3\"", "\"1+3=4\"", "\"1+4=5\"", "\"1+5=6\"", 
             "\"1+6=7\"", "\"1+7=8\"", "\"1+8=9\"", "\"1+9=10\""}, {
            "\"2+1=3\"", "\"2+2=4\"", "\"2+3=5\"", "\"2+4=6\"", "\"2+5=7\"", 
             "\"2+6=8\"", "\"2+7=9\"", "\"2+8=10\"", "\"2+9=11\""}, {
            "\"3+1=4\"", "\"3+2=5\"", "\"3+3=6\"", "\"3+4=7\"", "\"3+5=8\"", 
             "\"3+6=9\"", "\"3+7=10\"", "\"3+8=11\"", "\"3+9=12\""}, {
            "\"4+1=5\"", "\"4+2=6\"", "\"4+3=7\"", "\"4+4=8\"", "\"4+5=9\"", 
             "\"4+6=10\"", "\"4+7=11\"", "\"4+8=12\"", "\"4+9=13\""}, {
            "\"5+1=6\"", "\"5+2=7\"", "\"5+3=8\"", "\"5+4=9\"", "\"5+5=10\"", 
             "\"5+6=11\"", "\"5+7=12\"", "\"5+8=13\"", "\"5+9=14\""}, {
            "\"6+1=7\"", "\"6+2=8\"", "\"6+3=9\"", "\"6+4=10\"", "\"6+5=11\"",
              "\"6+6=12\"", "\"6+7=13\"", "\"6+8=14\"", "\"6+9=15\""}, {
            "\"7+1=8\"", "\"7+2=9\"", "\"7+3=10\"", "\"7+4=11\"", 
             "\"7+5=12\"", "\"7+6=13\"", "\"7+7=14\"", "\"7+8=15\"", 
             "\"7+9=16\""}, {
            "\"8+1=9\"", "\"8+2=10\"", "\"8+3=11\"", "\"8+4=12\"", 
             "\"8+5=13\"", "\"8+6=14\"", "\"8+7=15\"", "\"8+8=16\"", 
             "\"8+9=17\""}, {
            "\"9+1=10\"", "\"9+2=11\"", "\"9+3=12\"", "\"9+4=13\"", 
             "\"9+5=14\"", "\"9+6=15\"", "\"9+7=16\"", "\"9+8=17\"", 
             "\"9+9=18\""}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4624d66b-26f3-4dac-88ab-8518d98ef272"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find names of integers below 50 that have an \[OpenCurlyDoubleQuote]i\
\[CloseCurlyDoubleQuote] somewhere before an \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fefe7f3d-264e-4ce3-921a-04abf09558e7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"five\"\>", ",", "\<\"nine\"\>", ",", "\<\"thirteen\"\>", 
         ",", "\<\"fifteen\"\>", ",", "\<\"sixteen\"\>", 
         ",", "\<\"eighteen\"\>", ",", "\<\"nineteen\"\>", 
         ",", "\<\"twenty\[Hyphen]five\"\>", 
         ",", "\<\"twenty\[Hyphen]nine\"\>", 
         ",", "\<\"thirty\[Hyphen]one\"\>", 
         ",", "\<\"thirty\[Hyphen]three\"\>", 
         ",", "\<\"thirty\[Hyphen]five\"\>", 
         ",", "\<\"thirty\[Hyphen]seven\"\>", 
         ",", "\<\"thirty\[Hyphen]eight\"\>", 
         ",", "\<\"thirty\[Hyphen]nine\"\>", 
         ",", "\<\"forty\[Hyphen]five\"\>", 
         ",", "\<\"forty\[Hyphen]nine\"\>"}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"1746bb82-903a-4165-9dba-619343531085"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"five\"", ",", "\"nine\"", ",", "\"thirteen\"", ",", 
             "\"fifteen\"", ",", "\"sixteen\"", ",", "\"eighteen\"", ",", 
             "\"nineteen\"", ",", "\"twenty\[Hyphen]five\"", ",", 
             "\"twenty\[Hyphen]nine\"", ",", "\"thirty\[Hyphen]one\"", ",", 
             "\"thirty\[Hyphen]three\"", ",", "\"thirty\[Hyphen]five\"", ",", 
             "\"thirty\[Hyphen]seven\"", ",", "\"thirty\[Hyphen]eight\"", ",",
              "\"thirty\[Hyphen]nine\"", ",", "\"forty\[Hyphen]five\"", ",", 
             "\"forty\[Hyphen]nine\""}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5c13fe8b-8b28-4b51-872c-68ccf7f09828"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make any 2-letter word uppercase in the first sentence from the Wikipedia \
article on computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"31c95093-37e0-4240-99b9-bad3ba0e29b2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[
      BoxData["\<\"A computer IS a general-purpose device that can BE \
programmed TO carry out a set OF arithmetic OR logical operations \
automatically.\"\>"], "ExerciseOutput",ExpressionUUID->
       "c2c7ad2c-fa79-4690-a7df-b611fc2d2ad0"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "\"A computer IS a general-purpose device that can BE programmed TO \
carry out a set OF arithmetic OR logical operations automatically.\""], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c4d5e1c0-632f-4d00-bf75-309023d339ce"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a labeled bar chart of the number of countries whose ",
 ButtonBox["TextString",
  BaseStyle->"Link"],
 " names start with each possible letter.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ebd0713e-5f7a-4005-83af-c98d141618e7"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.036279069767441774`, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
           0.5249999999999999], Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5348837209302325, 0.}, {1.4651162790697674`, 
                  14.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{21.632859025963327`, 36.83968556693968}, {
                 8.087041005343124, 119.46482175935049`}}],
               StatusArea[#, 14]& ,
               TagBoxNote->"14"],
              StyleBox["14", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[14, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5348837209302326`, 0.}, {2.4651162790697674`,
                   19.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{37.44269755751291, 
                 52.64952409848926}, {-31.51216640680238, 
                 119.46482175935049`}}],
               StatusArea[#, 19]& ,
               TagBoxNote->"19"],
              StyleBox["19", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[19, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.5348837209302326`, 0.}, {3.4651162790697674`,
                   20.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{53.25253608906249, 
                 68.45936263003884}, {-39.43200788923147, 
                 119.46482175935049`}}],
               StatusArea[#, 20]& ,
               TagBoxNote->"20"],
              StyleBox["20", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[20, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5348837209302326`, 0.}, {4.465116279069767, 
                  5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{69.06237462061208, 84.26920116158843}, {
                 79.365614347205, 119.46482175935049`}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.534883720930233, 0.}, {5.465116279069767, 
                  8.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{84.87221315216163, 100.07903969313801`}, {
                 55.606089899917706`, 119.46482175935049`}}],
               StatusArea[#, 8]& ,
               TagBoxNote->"8"],
              StyleBox["8", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[8, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.534883720930233, 0.}, {6.465116279069767, 
                  7.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{100.68205168371122`, 115.88887822468757`}, {
                 63.525931382346805`, 119.46482175935049`}}],
               StatusArea[#, 7]& ,
               TagBoxNote->"7"],
              StyleBox["7", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[7, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.534883720930233, 0.}, {7.465116279069767, 
                  17.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{116.49189021526081`, 
                 131.69871675623716`}, {-15.672483441944166`, 
                 119.46482175935049`}}],
               StatusArea[#, 17]& ,
               TagBoxNote->"17"],
              StyleBox["17", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[17, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.534883720930233, 0.}, {8.465116279069768, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{132.3017287468104, 147.50855528778678`}, {
                 87.28545582963409, 119.46482175935049`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.534883720930234, 0.}, {9.465116279069768, 
                  10.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{148.11156727835998`, 163.31839381933634`}, {
                 39.76640693505951, 119.46482175935049`}}],
               StatusArea[#, 10]& ,
               TagBoxNote->"10"],
              StyleBox["10", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[10, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.534883720930234, 0.}, {10.465116279069768`, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{163.92140580990957`, 179.12823235088592`}, {
                 87.28545582963409, 119.46482175935049`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{10.534883720930234`, 0.}, {11.465116279069768`,
                   6.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{179.73124434145916`, 194.9380708824355}, {
                 71.4457728647759, 119.46482175935049`}}],
               StatusArea[#, 6]& ,
               TagBoxNote->"6"],
              StyleBox["6", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[6, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{11.534883720930234`, 0.}, {12.465116279069768`,
                   9.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{195.54108287300872`, 210.7479094139851}, {
                 47.68624841748861, 119.46482175935049`}}],
               StatusArea[#, 9]& ,
               TagBoxNote->"9"],
              StyleBox["9", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[9, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{12.534883720930234`, 0.}, {13.465116279069768`,
                   23.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{211.3509214045583, 
                 226.55774794553466`}, {-63.19153233651875, 
                 119.46482175935049`}}],
               StatusArea[#, 23]& ,
               TagBoxNote->"23"],
              StyleBox["23", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[23, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{13.534883720930234`, 0.}, {14.465116279069768`,
                   14.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{227.1607599361079, 242.36758647708425`}, {
                 8.087041005343124, 119.46482175935049`}}],
               StatusArea[#, 14]& ,
               TagBoxNote->"14"],
              StyleBox["14", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[14, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{14.534883720930234`, 0.}, {15.465116279069768`,
                   1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{242.97059846765748`, 258.1774250086338}, {
                 111.0449802769214, 119.46482175935049`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{15.534883720930234`, 0.}, {16.46511627906977, 
                  11.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{258.78043699920704`, 273.9872635401834}, {
                 31.846565452630415`, 119.46482175935049`}}],
               StatusArea[#, 11]& ,
               TagBoxNote->"11"],
              StyleBox["11", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[11, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{16.53488372093023, 0.}, {17.46511627906977, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{274.59027553075657`, 289.797102071733}, {
                 111.0449802769214, 119.46482175935049`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{17.53488372093023, 0.}, {18.46511627906977, 
                  5.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{290.40011406230616`, 305.60694060328257`}, {
                 79.365614347205, 119.46482175935049`}}],
               StatusArea[#, 5]& ,
               TagBoxNote->"5"],
              StyleBox["5", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[5, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{18.53488372093023, 0.}, {19.46511627906977, 
                  31.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{306.20995259385575`, 
                 321.4167791348321}, {-126.55026419595154`, 
                 119.46482175935049`}}],
               StatusArea[#, 31]& ,
               TagBoxNote->"31"],
              StyleBox["31", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[31, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{19.53488372093023, 0.}, {20.46511627906977, 
                  13.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{322.01979112540533`, 337.2266176663817}, {
                 16.006882487772216`, 119.46482175935049`}}],
               StatusArea[#, 13]& ,
               TagBoxNote->"13"],
              StyleBox["13", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[13, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{20.53488372093023, 0.}, {21.46511627906977, 
                  8.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{337.8296296569549, 353.0364561979313}, {
                 55.606089899917706`, 119.46482175935049`}}],
               StatusArea[#, 8]& ,
               TagBoxNote->"8"],
              StyleBox["8", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[8, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{21.53488372093023, 0.}, {22.46511627906977, 
                  4.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{353.63946818850445`, 368.84629472948086`}, {
                 87.28545582963409, 119.46482175935049`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{22.53488372093023, 0.}, {23.46511627906977, 
                  3.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{369.44930672005404`, 384.65613326103045`}, {
                 95.2052973120632, 119.46482175935049`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{23.53488372093023, 0.}, {24.46511627906977, 
                  1.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{385.2591452516036, 400.46597179258004`}, {
                 111.0449802769214, 119.46482175935049`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.5249999999999999], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{24.53488372093023, 0.}, {25.46511627906977, 
                  2.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{401.0689837831532, 416.2758103241296}, {
                 103.12513879449229`, 119.46482175935049`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.036279069767441774`, 0.}, {25.973693023255816`, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5348837209302325, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5348837209302325, 
                 0.}]}], 
              LineBox[{{25.46511627906977, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {25.46511627906977, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                LineBox[{{1.4651162790697674`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.4651162790697674`,
                    0.}]}], 
                LineBox[{{1.5348837209302326`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.5348837209302326`,
                    0.}]}], 
                LineBox[{{2.4651162790697674`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.4651162790697674`,
                    0.}]}], 
                LineBox[{{2.5348837209302326`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.5348837209302326`,
                    0.}]}], 
                LineBox[{{3.4651162790697674`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.4651162790697674`,
                    0.}]}], 
                LineBox[{{3.5348837209302326`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.5348837209302326`,
                    0.}]}], 
                LineBox[{{4.465116279069767, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.465116279069767, 
                   0.}]}], 
                LineBox[{{4.534883720930233, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.534883720930233, 
                   0.}]}], 
                LineBox[{{5.465116279069767, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.465116279069767, 
                   0.}]}], 
                LineBox[{{5.534883720930233, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.534883720930233, 
                   0.}]}], 
                LineBox[{{6.465116279069767, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.465116279069767, 
                   0.}]}], 
                LineBox[{{6.534883720930233, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.534883720930233, 
                   0.}]}], 
                LineBox[{{7.465116279069767, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.465116279069767, 
                   0.}]}], 
                LineBox[{{7.534883720930233, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.534883720930233, 
                   0.}]}], 
                LineBox[{{8.465116279069768, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.465116279069768, 
                   0.}]}], 
                LineBox[{{8.534883720930232, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.534883720930232, 
                   0.}]}], 
                LineBox[{{9.465116279069766, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.465116279069766, 
                   0.}]}], 
                LineBox[{{9.534883720930232, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.534883720930232, 
                   0.}]}], 
                LineBox[{{10.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {10.465116279069766`,
                    0.}]}], 
                LineBox[{{10.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {10.534883720930232`,
                    0.}]}], 
                LineBox[{{11.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {11.465116279069766`,
                    0.}]}], 
                LineBox[{{11.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {11.534883720930232`,
                    0.}]}], 
                LineBox[{{12.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {12.465116279069766`,
                    0.}]}], 
                LineBox[{{12.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {12.534883720930232`,
                    0.}]}], 
                LineBox[{{13.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {13.465116279069766`,
                    0.}]}], 
                LineBox[{{13.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {13.534883720930232`,
                    0.}]}], 
                LineBox[{{14.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {14.465116279069766`,
                    0.}]}], 
                LineBox[{{14.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {14.534883720930232`,
                    0.}]}], 
                LineBox[{{15.465116279069766`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {15.465116279069766`,
                    0.}]}], 
                LineBox[{{15.534883720930232`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {15.534883720930232`,
                    0.}]}], 
                LineBox[{{16.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {16.46511627906977, 
                   0.}]}], 
                LineBox[{{16.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {16.53488372093023, 
                   0.}]}], 
                LineBox[{{17.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {17.46511627906977, 
                   0.}]}], 
                LineBox[{{17.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {17.53488372093023, 
                   0.}]}], 
                LineBox[{{18.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {18.46511627906977, 
                   0.}]}], 
                LineBox[{{18.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {18.53488372093023, 
                   0.}]}], 
                LineBox[{{19.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {19.46511627906977, 
                   0.}]}], 
                LineBox[{{19.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {19.53488372093023, 
                   0.}]}], 
                LineBox[{{20.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {20.46511627906977, 
                   0.}]}], 
                LineBox[{{20.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {20.53488372093023, 
                   0.}]}], 
                LineBox[{{21.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {21.46511627906977, 
                   0.}]}], 
                LineBox[{{21.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {21.53488372093023, 
                   0.}]}], 
                LineBox[{{22.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {22.46511627906977, 
                   0.}]}], 
                LineBox[{{22.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {22.53488372093023, 
                   0.}]}], 
                LineBox[{{23.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {23.46511627906977, 
                   0.}]}], 
                LineBox[{{23.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {23.53488372093023, 
                   0.}]}], 
                LineBox[{{24.46511627906977, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {24.46511627906977, 
                   0.}]}], 
                LineBox[{{24.53488372093023, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {24.53488372093023, 
                   0.}]}]}, {}}}, 
             StyleBox[
              {Thickness[Tiny], 
               InsetBox["\<\"A\"\>", Offset[{0., -2.}, {1., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"B\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"C\"\>", Offset[{0., -2.}, {3., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"D\"\>", Offset[{0., -2.}, {4., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"E\"\>", Offset[{0., -2.}, {5., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"F\"\>", Offset[{0., -2.}, {6., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"G\"\>", Offset[{0., -2.}, {7., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"H\"\>", Offset[{0., -2.}, {8., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"I\"\>", Offset[{0., -2.}, {9., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"J\"\>", Offset[{0., -2.}, {10., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"K\"\>", Offset[{0., -2.}, {11., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"L\"\>", Offset[{0., -2.}, {12., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"M\"\>", Offset[{0., -2.}, {13., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"N\"\>", Offset[{0., -2.}, {14., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"O\"\>", Offset[{0., -2.}, {15., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"P\"\>", Offset[{0., -2.}, {16., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"Q\"\>", Offset[{0., -2.}, {17., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"R\"\>", Offset[{0., -2.}, {18., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"S\"\>", Offset[{0., -2.}, {19., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"T\"\>", Offset[{0., -2.}, {20., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"U\"\>", Offset[{0., -2.}, {21., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"V\"\>", Offset[{0., -2.}, {22., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"W\"\>", Offset[{0., -2.}, {23., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"Y\"\>", Offset[{0., -2.}, {24., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"Z\"\>", Offset[{0., -2.}, {25., 0.}], {0, 1}, 
                Automatic, {1, 0}]}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.036279069767441774`, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
             FormBox["\"A\"", TraditionalForm], 0}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox["\"B\"", TraditionalForm], 0}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox["\"C\"", TraditionalForm], 0}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox["\"D\"", TraditionalForm], 0}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox["\"E\"", TraditionalForm], 0}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox["\"F\"", TraditionalForm], 0}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox["\"G\"", TraditionalForm], 0}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox["\"H\"", TraditionalForm], 0}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox["\"I\"", TraditionalForm], 0}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox["\"J\"", TraditionalForm], 0}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox["\"K\"", TraditionalForm], 0}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox["\"L\"", TraditionalForm], 0}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox["\"M\"", TraditionalForm], 0}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox["\"N\"", TraditionalForm], 0}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox["\"O\"", TraditionalForm], 0}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox["\"P\"", TraditionalForm], 0}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox["\"Q\"", TraditionalForm], 0}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox["\"R\"", TraditionalForm], 0}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox["\"S\"", TraditionalForm], 0}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox["\"T\"", TraditionalForm], 0}, {21., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
             FormBox["\"U\"", TraditionalForm], 0}, {22., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
             FormBox["\"V\"", TraditionalForm], 0}, {23., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
             FormBox["\"W\"", TraditionalForm], 0}, {24., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
             FormBox["\"Y\"", TraditionalForm], 0}, {25., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
             FormBox["\"Z\"", TraditionalForm], 0}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{433.609375, Automatic},
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "8910be20-e0d7-4e66-b902-878999992e7c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.036279069767441774`, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.5249999999999999], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5348837209302325, 0.}, {
                    1.4651162790697674`, 14.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{22.614027964126826`, 
                   37.785721927050005`}, {6.733878726057483, 
                   117.84678777060061`}}], StatusArea[#, 14]& , TagBoxNote -> 
                 "14"], 
                StyleBox["14", {}, StripOnInput -> False]], Annotation[#, 
                Style[14, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5348837209302326`, 0.}, {
                    2.4651162790697674`, 19.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{38.38609897426925, 
                   53.55779293719243}, {-32.77073164699364, 
                   117.84678777060061`}}], StatusArea[#, 19]& , TagBoxNote -> 
                 "19"], 
                StyleBox["19", {}, StripOnInput -> False]], Annotation[#, 
                Style[19, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.5348837209302326`, 0.}, {
                    3.4651162790697674`, 20.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{54.15816998441167, 
                   69.32986394733486}, {-40.671653721603846`, 
                   117.84678777060061`}}], StatusArea[#, 20]& , TagBoxNote -> 
                 "20"], 
                StyleBox["20", {}, StripOnInput -> False]], Annotation[#, 
                Style[20, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5348837209302326`, 0.}, {4.465116279069767,
                     5.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{69.9302409945541, 85.10193495747727}, {
                   77.8421773975495, 117.84678777060061`}}], 
                 StatusArea[#, 5]& , TagBoxNote -> "5"], 
                StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                Style[5, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.534883720930233, 0.}, {5.465116279069767, 
                    8.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{85.70231200469651, 100.8740059676197}, {
                   54.13941117371883, 117.84678777060061`}}], 
                 StatusArea[#, 8]& , TagBoxNote -> "8"], 
                StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                Style[8, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.534883720930233, 0.}, {6.465116279069767, 
                    7.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{101.47438301483893`, 
                   116.64607697776212`}, {62.04033324832905, 
                   117.84678777060061`}}], StatusArea[#, 7]& , TagBoxNote -> 
                 "7"], 
                StyleBox["7", {}, StripOnInput -> False]], Annotation[#, 
                Style[7, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.534883720930233, 0.}, {7.465116279069767, 
                    17.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{117.24645402498136`, 
                   132.41814798790455`}, {-16.968887497773196`, 
                   117.84678777060061`}}], StatusArea[#, 17]& , TagBoxNote -> 
                 "17"], 
                StyleBox["17", {}, StripOnInput -> False]], Annotation[#, 
                Style[17, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.534883720930233, 0.}, {8.465116279069768, 
                    4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{133.0185250351238, 148.190218998047}, {
                   85.74309947215971, 117.84678777060061`}}], 
                 StatusArea[#, 4]& , TagBoxNote -> "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.534883720930234, 0.}, {9.465116279069768, 
                    10.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{148.79059604526623`, 
                   163.96229000818943`}, {38.337567024498384`, 
                   117.84678777060061`}}], StatusArea[#, 10]& , TagBoxNote -> 
                 "10"], 
                StyleBox["10", {}, StripOnInput -> False]], Annotation[#, 
                Style[10, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.534883720930234, 0.}, {10.465116279069768`,
                     4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{164.56266705540867`, 
                   179.73436101833184`}, {85.74309947215971, 
                   117.84678777060061`}}], StatusArea[#, 4]& , TagBoxNote -> 
                 "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{10.534883720930234`, 0.}, {
                    11.465116279069768`, 6.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{180.33473806555108`, 
                   195.50643202847425`}, {69.94125532293927, 
                   117.84678777060061`}}], StatusArea[#, 6]& , TagBoxNote -> 
                 "6"], 
                StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                Style[6, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{11.534883720930234`, 0.}, {
                    12.465116279069768`, 9.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{196.1068090756935, 211.2785030386167}, {
                   46.238489099108605`, 117.84678777060061`}}], 
                 StatusArea[#, 9]& , TagBoxNote -> "9"], 
                StyleBox["9", {}, StripOnInput -> False]], Annotation[#, 
                Style[9, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{12.534883720930234`, 0.}, {
                    13.465116279069768`, 23.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{211.87888008583593`, 
                   227.0505740487591}, {-64.37441994543452, 
                   117.84678777060061`}}], StatusArea[#, 23]& , TagBoxNote -> 
                 "23"], 
                StyleBox["23", {}, StripOnInput -> False]], Annotation[#, 
                Style[23, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{13.534883720930234`, 0.}, {
                    14.465116279069768`, 14.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{227.65095109597834`, 
                   242.82264505890151`}, {6.733878726057483, 
                   117.84678777060061`}}], StatusArea[#, 14]& , TagBoxNote -> 
                 "14"], 
                StyleBox["14", {}, StripOnInput -> False]], Annotation[#, 
                Style[14, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{14.534883720930234`, 0.}, {
                    15.465116279069768`, 1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{243.42302210612075`, 
                   258.59471606904395`}, {109.44586569599039`, 
                   117.84678777060061`}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{15.534883720930234`, 0.}, {16.46511627906977,
                     11.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{259.1950931162632, 
                   274.36678707918634`}, {30.436644949888162`, 
                   117.84678777060061`}}], StatusArea[#, 11]& , TagBoxNote -> 
                 "11"], 
                StyleBox["11", {}, StripOnInput -> False]], Annotation[#, 
                Style[11, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{16.53488372093023, 0.}, {17.46511627906977, 
                    1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{274.9671641264056, 290.1388580893288}, {
                   109.44586569599039`, 117.84678777060061`}}], 
                 StatusArea[#, 1]& , TagBoxNote -> "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{17.53488372093023, 0.}, {18.46511627906977, 
                    5.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{290.73923513654796`, 
                   305.91092909947116`}, {77.8421773975495, 
                   117.84678777060061`}}], StatusArea[#, 5]& , TagBoxNote -> 
                 "5"], 
                StyleBox["5", {}, StripOnInput -> False]], Annotation[#, 
                Style[5, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{18.53488372093023, 0.}, {19.46511627906977, 
                    31.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{306.5113061466904, 
                   321.6830001096136}, {-127.5817965423163, 
                   117.84678777060061`}}], StatusArea[#, 31]& , TagBoxNote -> 
                 "31"], 
                StyleBox["31", {}, StripOnInput -> False]], Annotation[#, 
                Style[31, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{19.53488372093023, 0.}, {20.46511627906977, 
                    13.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{322.28337715683284`, 
                   337.45507111975604`}, {14.634800800667705`, 
                   117.84678777060061`}}], StatusArea[#, 13]& , TagBoxNote -> 
                 "13"], 
                StyleBox["13", {}, StripOnInput -> False]], Annotation[#, 
                Style[13, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{20.53488372093023, 0.}, {21.46511627906977, 
                    8.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{338.0554481669752, 353.2271421298985}, {
                   54.13941117371883, 117.84678777060061`}}], 
                 StatusArea[#, 8]& , TagBoxNote -> "8"], 
                StyleBox["8", {}, StripOnInput -> False]], Annotation[#, 
                Style[8, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{21.53488372093023, 0.}, {22.46511627906977, 
                    4.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{353.82751917711767`, 
                   368.99921314004087`}, {85.74309947215971, 
                   117.84678777060061`}}], StatusArea[#, 4]& , TagBoxNote -> 
                 "4"], 
                StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                Style[4, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{22.53488372093023, 0.}, {23.46511627906977, 
                    3.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{369.5995901872601, 384.7712841501833}, {
                   93.64402154676995, 117.84678777060061`}}], 
                 StatusArea[#, 3]& , TagBoxNote -> "3"], 
                StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                Style[3, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{23.53488372093023, 0.}, {24.46511627906977, 
                    1.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{385.3716611974025, 
                   400.54335516032575`}, {109.44586569599039`, 
                   117.84678777060061`}}], StatusArea[#, 1]& , TagBoxNote -> 
                 "1"], 
                StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                Style[1, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.5249999999999999], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{24.53488372093023, 0.}, {25.46511627906977, 
                    2.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{401.14373220754493`, 
                   416.31542617046813`}, {101.54494362138017`, 
                   117.84678777060061`}}], StatusArea[#, 2]& , TagBoxNote -> 
                 "2"], 
                StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                Style[2, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              
              LineBox[{{0.036279069767441774`, 0.}, {25.973693023255816`, 
               0.}}], 
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5348837209302325, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5348837209302325, 
                   0.}]}], 
                LineBox[{{25.46511627906977, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {25.46511627906977, 
                   0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                  LineBox[{{1.4651162790697674`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.4651162790697674`, 0.}]}], 
                  LineBox[{{1.5348837209302326`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.5348837209302326`, 0.}]}], 
                  LineBox[{{2.4651162790697674`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    2.4651162790697674`, 0.}]}], 
                  LineBox[{{2.5348837209302326`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    2.5348837209302326`, 0.}]}], 
                  LineBox[{{3.4651162790697674`, 0.}, 
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.4651162790697674`, 0.}]}], 
                  LineBox[{{3.5348837209302326`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.5348837209302326`, 0.}]}], 
                  LineBox[{{4.465116279069767, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.465116279069767,
                     0.}]}], 
                  LineBox[{{4.534883720930233, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.534883720930233,
                     0.}]}], 
                  LineBox[{{5.465116279069767, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.465116279069767,
                     0.}]}], 
                  LineBox[{{5.534883720930233, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.534883720930233,
                     0.}]}], 
                  LineBox[{{6.465116279069767, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.465116279069767,
                     0.}]}], 
                  LineBox[{{6.534883720930233, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.534883720930233,
                     0.}]}], 
                  LineBox[{{7.465116279069767, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.465116279069767,
                     0.}]}], 
                  LineBox[{{7.534883720930233, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.534883720930233,
                     0.}]}], 
                  LineBox[{{8.465116279069768, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.465116279069768,
                     0.}]}], 
                  LineBox[{{8.534883720930232, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.534883720930232,
                     0.}]}], 
                  LineBox[{{9.465116279069766, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.465116279069766,
                     0.}]}], 
                  LineBox[{{9.534883720930232, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.534883720930232,
                     0.}]}], 
                  LineBox[{{10.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    10.465116279069766`, 0.}]}], 
                  LineBox[{{10.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    10.534883720930232`, 0.}]}], 
                  LineBox[{{11.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    11.465116279069766`, 0.}]}], 
                  LineBox[{{11.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    11.534883720930232`, 0.}]}], 
                  LineBox[{{12.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    12.465116279069766`, 0.}]}], 
                  LineBox[{{12.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    12.534883720930232`, 0.}]}], 
                  LineBox[{{13.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    13.465116279069766`, 0.}]}], 
                  LineBox[{{13.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    13.534883720930232`, 0.}]}], 
                  LineBox[{{14.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    14.465116279069766`, 0.}]}], 
                  LineBox[{{14.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    14.534883720930232`, 0.}]}], 
                  LineBox[{{15.465116279069766`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    15.465116279069766`, 0.}]}], 
                  LineBox[{{15.534883720930232`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    15.534883720930232`, 0.}]}], 
                  LineBox[{{16.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {16.46511627906977,
                     0.}]}], 
                  LineBox[{{16.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {16.53488372093023,
                     0.}]}], 
                  LineBox[{{17.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {17.46511627906977,
                     0.}]}], 
                  LineBox[{{17.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {17.53488372093023,
                     0.}]}], 
                  LineBox[{{18.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {18.46511627906977,
                     0.}]}], 
                  LineBox[{{18.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {18.53488372093023,
                     0.}]}], 
                  LineBox[{{19.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {19.46511627906977,
                     0.}]}], 
                  LineBox[{{19.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {19.53488372093023,
                     0.}]}], 
                  LineBox[{{20.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {20.46511627906977,
                     0.}]}], 
                  LineBox[{{20.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {20.53488372093023,
                     0.}]}], 
                  LineBox[{{21.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {21.46511627906977,
                     0.}]}], 
                  LineBox[{{21.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {21.53488372093023,
                     0.}]}], 
                  LineBox[{{22.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {22.46511627906977,
                     0.}]}], 
                  LineBox[{{22.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {22.53488372093023,
                     0.}]}], 
                  LineBox[{{23.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {23.46511627906977,
                     0.}]}], 
                  LineBox[{{23.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {23.53488372093023,
                     0.}]}], 
                  LineBox[{{24.46511627906977, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {24.46511627906977,
                     0.}]}], 
                  LineBox[{{24.53488372093023, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {24.53488372093023,
                     0.}]}]}, {}}}, 
               StyleBox[{
                 Thickness[Tiny], 
                 InsetBox["\"A\"", 
                  Offset[{0., -2.}, {1., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"B\"", 
                  Offset[{0., -2.}, {2., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"C\"", 
                  Offset[{0., -2.}, {3., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"D\"", 
                  Offset[{0., -2.}, {4., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"E\"", 
                  Offset[{0., -2.}, {5., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"F\"", 
                  Offset[{0., -2.}, {6., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"G\"", 
                  Offset[{0., -2.}, {7., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"H\"", 
                  Offset[{0., -2.}, {8., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"I\"", 
                  Offset[{0., -2.}, {9., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"J\"", 
                  Offset[{0., -2.}, {10., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"K\"", 
                  Offset[{0., -2.}, {11., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"L\"", 
                  Offset[{0., -2.}, {12., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"M\"", 
                  Offset[{0., -2.}, {13., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"N\"", 
                  Offset[{0., -2.}, {14., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"O\"", 
                  Offset[{0., -2.}, {15., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"P\"", 
                  Offset[{0., -2.}, {16., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"Q\"", 
                  Offset[{0., -2.}, {17., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"R\"", 
                  Offset[{0., -2.}, {18., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"S\"", 
                  Offset[{0., -2.}, {19., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"T\"", 
                  Offset[{0., -2.}, {20., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"U\"", 
                  Offset[{0., -2.}, {21., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"V\"", 
                  Offset[{0., -2.}, {22., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"W\"", 
                  Offset[{0., -2.}, {23., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"Y\"", 
                  Offset[{0., -2.}, {24., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"Z\"", 
                  Offset[{0., -2.}, {25., 0.}], {0, 1}, Automatic, {1, 0}]}, 
                "GraphicsLabel", StripOnInput -> False]}, "GraphicsTicks", 
              StripOnInput -> False]}, "GraphicsAxes", StripOnInput -> False, 
            Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, 
          AxesOrigin -> {0.036279069767441774`, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
               FormBox["\"A\"", TraditionalForm], 0}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox["\"B\"", TraditionalForm], 0}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox["\"C\"", TraditionalForm], 0}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox["\"D\"", TraditionalForm], 0}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox["\"E\"", TraditionalForm], 0}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox["\"F\"", TraditionalForm], 0}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox["\"G\"", TraditionalForm], 0}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox["\"H\"", TraditionalForm], 0}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox["\"I\"", TraditionalForm], 0}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox["\"J\"", TraditionalForm], 0}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox["\"K\"", TraditionalForm], 0}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox["\"L\"", TraditionalForm], 0}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox["\"M\"", TraditionalForm], 0}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox["\"N\"", TraditionalForm], 0}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox["\"O\"", TraditionalForm], 0}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox["\"P\"", TraditionalForm], 0}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox["\"Q\"", TraditionalForm], 0}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox["\"R\"", TraditionalForm], 0}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox["\"S\"", TraditionalForm], 0}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox["\"T\"", TraditionalForm], 0}, {21., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
               FormBox["\"U\"", TraditionalForm], 0}, {22., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
               FormBox["\"V\"", TraditionalForm], 0}, {23., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
               FormBox["\"W\"", TraditionalForm], 0}, {24., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
               FormBox["\"Y\"", TraditionalForm], 0}, {25., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
               FormBox["\"Z\"", TraditionalForm], 0}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {433.609375, Automatic}, 
          PlotRange -> {{All, All}, {All, All}}, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"81f9651d-97d5-4d56-9dc1-4be5dd0e2941"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find simpler code for \n",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Table",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["StringJoin",
       BaseStyle->"CodeLink"], "[", 
      RowBox[{
       RowBox[{
        ButtonBox["TextString",
         BaseStyle->"CodeLink"], "[", "i", "]"}], ",", "\<\"^\"\>", ",", 
       RowBox[{
        ButtonBox["TextString",
         BaseStyle->"CodeLink"], "[", "j", "]"}], ",", "\<\"=\"\>", ",", 
       RowBox[{
        ButtonBox["TextString",
         BaseStyle->"CodeLink"], "[", 
        RowBox[{"i", "^", "j"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"1149125c-bd27-4c92-af4c-5235d63bb0aa"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"605ad978-8731-4ee5-ad0d-601061f388aa"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"\<\"1^1=1\"\>", "\<\"1^2=1\"\>", "\<\"1^3=1\"\>", \
"\<\"1^4=1\"\>", "\<\"1^5=1\"\>"},
          {"\<\"2^1=2\"\>", "\<\"2^2=4\"\>", "\<\"2^3=8\"\>", \
"\<\"2^4=16\"\>", "\<\"2^5=32\"\>"},
          {"\<\"3^1=3\"\>", "\<\"3^2=9\"\>", "\<\"3^3=27\"\>", \
"\<\"3^4=81\"\>", "\<\"3^5=243\"\>"},
          {"\<\"4^1=4\"\>", "\<\"4^2=16\"\>", "\<\"4^3=64\"\>", \
"\<\"4^4=256\"\>", "\<\"4^5=1024\"\>"},
          {"\<\"5^1=5\"\>", "\<\"5^2=25\"\>", "\<\"5^3=125\"\>", "\<\"5^4=625\
\"\>", "\<\"5^5=3125\"\>"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "aee68768-fe36-4f2e-b7bc-7f8152f43140"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{
            "\"1^1=1\"", "\"1^2=1\"", "\"1^3=1\"", "\"1^4=1\"", 
             "\"1^5=1\""}, {
            "\"2^1=2\"", "\"2^2=4\"", "\"2^3=8\"", "\"2^4=16\"", 
             "\"2^5=32\""}, {
            "\"3^1=3\"", "\"3^2=9\"", "\"3^3=27\"", "\"3^4=81\"", 
             "\"3^5=243\""}, {
            "\"4^1=4\"", "\"4^2=16\"", "\"4^3=64\"", "\"4^4=256\"", 
             "\"4^5=1024\""}, {
            "\"5^1=5\"", "\"5^2=25\"", "\"5^3=125\"", "\"5^4=625\"", 
             "\"5^5=3125\""}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"09c954a7-5af9-4d6a-bc2f-8f773c527a32"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ff657d7c-01df-46ad-945f-1ee1b2679bf2"],

Cell[TextData[{
 "How should one read ",
 ButtonBox["~~",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"],
 " out loud?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"55930f7f-e22c-4bc6-9a66-e193f9507d1e"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s usually read \[OpenCurlyDoubleQuote]tilde tilde\
\[CloseCurlyDoubleQuote]. The underlying function is ",
 ButtonBox["StringExpression",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"97d7fbfb-5cb7-42a6-aef2-188dff7e49fe"],

Cell[TextData[{
 "How does one type ",
 ButtonBox["``",
  BaseStyle->"Link",
  ButtonData->"Accuracy"],
 " to make a slot in a string template?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"e2dbaa0a-7230-4af3-a691-13b3c8943400"],

Cell["\<\
It\[CloseCurlyQuote]s a pair of what are usually called backquote or backtick \
characters. On many keyboards, they\[CloseCurlyQuote]re at the top left, \
along with ~ (tilde).\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bd9273d4-d3e0-4c73-81f8-a3ffe152ad40"],

Cell["Can I write rules for understanding natural language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0c5a1e9e-acea-4d99-a50c-8205bc546bd1"],

Cell[TextData[{
 "Yes, but we didn\[CloseCurlyQuote]t cover that here. The key function is ",
 ButtonBox["GrammarRules",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"cd2e8a06-c178-404a-801c-8afd3e145e43"],

Cell[TextData[{
 "What does ",
 ButtonBox["TextString",
  BaseStyle->"Link"],
 " do when things don\[CloseCurlyQuote]t have an obvious textual form?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0ed2b94e-3648-4893-93ce-836943bad85d"],

Cell[TextData[{
 "It does its best to make something human readable, but if all else fails, \
it\[CloseCurlyQuote]ll fall back on ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"CodeLink"]], "InlineCode",ExpressionUUID->
  "12691b69-635d-4580-b9be-e3775c9fb04d"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a90c47df-f01d-4627-bb3f-b1563b37c7fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5c1a6b97-71c4-4027-94b8-e7636df3d55b"],

Cell[TextData[{
 "There\[CloseCurlyQuote]s a correspondence between patterns for strings, and \
patterns for sequences in lists. ",
 ButtonBox["SequenceCases",
  BaseStyle->"Link"],
 " is the analog for lists of ",
 ButtonBox["StringCases",
  BaseStyle->"Link"],
 " for strings."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"453f2bb2-a1ca-490f-a0b3-dde75e14e55b"],

Cell[TextData[{
 "The option ",
 ButtonBox["Overlaps",
  BaseStyle->"Link"],
 " specifies whether or not to allow overlaps in string matching. Different \
functions have different defaults. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"80513067-5816-4996-a4d7-eb801d14484a"],

Cell[TextData[{
 "String patterns by default match longest sequences, so you need to specify ",
 ButtonBox["Shortest",
  BaseStyle->"Link"],
 " if you want it. Expression patterns by default match shortest sequences."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"6e6f5cfb-f61a-4f8a-92a4-c3c273edaf55"],

Cell[TextData[{
 "Among string pattern constructs are ",
 ButtonBox["Whitespace",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["NumberString",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["WordBoundary",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["StartOfLine",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["EndOfLine",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["StartOfString",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["EndOfString",
  BaseStyle->"Link"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"f860d720-03ec-476e-a793-b012d05d97a8"],

Cell[TextData[{
 "Anywhere in a Wolfram Language symbolic string pattern, you can use ",
 ButtonBox["RegularExpression",
  BaseStyle->"Link"],
 " to include regular expression syntaxes like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "CodeVariable"], "*"}]], "InlineCode",ExpressionUUID->
  "936e5bac-d200-43b2-b173-046d0a116e84"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"[", 
    StyleBox["abc", "CodeVariable"], "]"}], "[", 
   StyleBox["def", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "e91e48fa-9c18-4bc9-be2d-b9515b27fe87"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"603e030e-1c3c-4876-bc54-e942323f31f9"],

Cell[TextData[{
 ButtonBox["TextString",
  BaseStyle->"Link"],
 " tries to make a simple human-readable textual version of anything, \
dropping things like the details of graphics. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToString",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["InputForm",
     BaseStyle->"CodeLink"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "f6fa875a-d191-4d90-9efc-3f5c759bd437"],
 " gives a complete version, suitable for subsequent input."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:27"},ExpressionUUID->"422ace7e-1c0a-469b-b9ae-1b7522bd5b32"],

Cell[TextData[{
 "You can compare strings using operations like ",
 ButtonBox["SequenceAlignment",
  BaseStyle->"Link"],
 ". This is particularly useful in bioinformatics. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"6ec7a7a9-edbd-4c99-95c5-56453e311c02"],

Cell[TextData[{
 ButtonBox["FileTemplate",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["XMLTemplate",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["NotebookTemplate",
  BaseStyle->"Link"],
 " let you do the analog of ",
 ButtonBox["StringTemplate",
  BaseStyle->"Link"],
 " for files, XML (and HTML) documents and notebooks."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:29",ExpressionUUID->"05e72e79-d617-4bae-a5f2-5ce6f3715c7c"],

Cell[TextData[{
 "The Wolfram Language includes the function ",
 ButtonBox["TextSearch",
  BaseStyle->"Link"],
 ", for searching text in large collections of files."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:30",ExpressionUUID->"e9447a9e-2ae2-4e62-8c82-4a5e94538311"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"281c4cfe-9f9e-4307-8091-cbd69c5466d3"],

Cell[TextData[ButtonBox["Guide to String Patterns in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"8c0821e1-a7cc-44f3-b62a-ca3b0f0626da"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"String Patterns and Templates: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"More about Patterns\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "More about Patterns", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Storing Things\"", TooltipDelay -> 0.15,
               LabelStyle -> "TextStyling"], 
             Annotation[#, "Storing Things", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->339,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | String Patterns and Templates \[LongDash] wolfr.am/eiwl-", 
       "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"b29eea8b-c683-41c3-a026-d3892a67c217"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:255"->{
  Cell[674, 24, 477, 12, 93, "SectionDoubleDigit",ExpressionUUID->"b06fcce9-d1f1-4aa1-ad3f-83b38443d3ad",
   CounterAssignments->{{"Section", 41}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:255"]},
 "i:1"->{
  Cell[1154, 38, 883, 25, 117, "Text",ExpressionUUID->"3755b7ce-c176-4d49-b5e6-5e784a4858fa",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[2040, 65, 334, 9, 37, "CodeCaption",ExpressionUUID->"34e06253-8c8c-49bc-995a-a899f07b625a",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[5098, 167, 1549, 42, 118, "Text",ExpressionUUID->"d5b3304d-2452-495b-978f-111c7baad48a",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[8746, 281, 245, 8, 70, "CodeCaption",ExpressionUUID->"9a1b9b07-4459-4a52-a7cb-ff26d608f9ff",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[10071, 329, 205, 4, 70, "CodeCaption",ExpressionUUID->"bb2b6bcd-fc64-4870-b496-0ed2b72483fe",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[10683, 348, 244, 5, 70, "Output",ExpressionUUID->"f7685304-5dde-4c5a-ad80-3024627662bd",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[19752, 652, 362, 9, 70, "Output",ExpressionUUID->"8fdda2c9-a729-42bf-8b63-17b25100e275",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[27405, 907, 241, 5, 70, "Output",ExpressionUUID->"8b3fe170-f07d-4c63-8b4e-fd1d8f7db514",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[29442, 978, 5703, 155, 70, "VocabularyTable",ExpressionUUID->"67063ab0-b230-4228-b300-b1d511c04921",
   CellTags->"LastCellOfAPage"],
  Cell[181026, 4599, 699, 21, 70, "TechNote",ExpressionUUID->"422ace7e-1c0a-469b-b9ae-1b7522bd5b32",
   CellTags->{"LastCellOfAPage", "i:27"}],
  Cell[183052, 4672, 344, 8, 70, "MoreExplore",ExpressionUUID->"8c0821e1-a7cc-44f3-b62a-ca3b0f0626da",
   CellTags->"LastCellOfAPage"]},
 "p:256"->{
  Cell[10942, 356, 469, 15, 70, "CodeCaption",ExpressionUUID->"ad5e9bb2-195a-4833-abe9-a3e75d8259aa",
   CellTags->"p:256"]},
 "i:6"->{
  Cell[12064, 393, 269, 9, 70, "CodeCaption",ExpressionUUID->"d0d0965c-780d-4ddd-8f4e-2a812fe64f37",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[13196, 431, 257, 8, 70, "Text",ExpressionUUID->"cf74ceef-32f6-45ab-9b3c-056c2e97014f",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[14606, 479, 570, 18, 70, "Text",ExpressionUUID->"fcfff13d-9606-4570-9554-200cf8836734",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[15999, 527, 517, 16, 70, "Text",ExpressionUUID->"5a4769e4-b7aa-43e4-932e-c346f203917c",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[18156, 599, 373, 11, 70, "Text",ExpressionUUID->"29fce3c7-1985-40b0-9cd7-7597d20906a8",
   CellTags->"i:10"]},
 "p:257"->{
  Cell[20129, 664, 480, 13, 70, "Text",ExpressionUUID->"5b6d6cfb-9253-40eb-876d-0efed4a287f9",
   CellTags->{"p:257", "i:11"}]},
 "i:11"->{
  Cell[20129, 664, 480, 13, 70, "Text",ExpressionUUID->"5b6d6cfb-9253-40eb-876d-0efed4a287f9",
   CellTags->{"p:257", "i:11"}]},
 "i:12"->{
  Cell[21340, 704, 416, 12, 70, "Text",ExpressionUUID->"a13204df-fdb1-4047-a319-256c6bfdb23b",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[22666, 749, 344, 10, 70, "Text",ExpressionUUID->"58545237-5f96-41e0-878a-db161d1f3c22",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[23877, 789, 401, 10, 70, "Text",ExpressionUUID->"2170f7f9-b0db-4068-b7f3-96476bdcc590",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[24281, 801, 404, 12, 70, "CodeCaption",ExpressionUUID->"e9a205f4-053c-43fd-ba60-c30b7185469b",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[25169, 831, 205, 4, 70, "CodeCaption",ExpressionUUID->"639d4081-557f-43df-bfd9-827df3b1eb90",
   CellTags->"i:16"]},
 "p:258"->{
  Cell[27661, 915, 341, 10, 70, "CodeCaption",ExpressionUUID->"f7171858-2d7b-4767-a730-64eed13de514",
   CellTags->{"p:258", "i:17"}]},
 "i:17"->{
  Cell[27661, 915, 341, 10, 70, "CodeCaption",ExpressionUUID->"f7171858-2d7b-4767-a730-64eed13de514",
   CellTags->{"p:258", "i:17"}]},
 "i:18"->{
  Cell[28515, 945, 240, 6, 70, "CodeCaption",ExpressionUUID->"d3659c47-66d8-45f0-ae7a-24036981beef",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[176191, 4424, 352, 10, 70, "Answer",ExpressionUUID->"97d7fbfb-5cb7-42a6-aef2-188dff7e49fe",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[176546, 4436, 296, 10, 70, "Question",ExpressionUUID->"e2dbaa0a-7230-4af3-a691-13b3c8943400",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[177366, 4464, 297, 9, 70, "Answer",ExpressionUUID->"cd2e8a06-c178-404a-801c-8afd3e145e43",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[178563, 4509, 431, 13, 70, "TechNote",ExpressionUUID->"453f2bb2-a1ca-490f-a0b3-dde75e14e55b",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[178997, 4524, 343, 10, 70, "TechNote",ExpressionUUID->"80513067-5816-4996-a4d7-eb801d14484a",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[179343, 4536, 369, 9, 70, "TechNote",ExpressionUUID->"6e6f5cfb-f61a-4f8a-92a4-c3c273edaf55",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[179715, 4547, 595, 27, 70, "TechNote",ExpressionUUID->"f860d720-03ec-476e-a793-b012d05d97a8",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[180313, 4576, 710, 21, 70, "TechNote",ExpressionUUID->"603e030e-1c3c-4876-bc54-e942323f31f9",
   CellTags->"i:26"]},
 "i:27"->{
  Cell[181026, 4599, 699, 21, 70, "TechNote",ExpressionUUID->"422ace7e-1c0a-469b-b9ae-1b7522bd5b32",
   CellTags->{"LastCellOfAPage", "i:27"}]},
 "i:28"->{
  Cell[181728, 4622, 325, 9, 70, "TechNote",ExpressionUUID->"6ec7a7a9-edbd-4c99-95c5-56453e311c02",
   CellTags->"i:28"]},
 "i:29"->{
  Cell[182056, 4633, 471, 17, 70, "TechNote",ExpressionUUID->"05e72e79-d617-4bae-a5f2-5ce6f3715c7c",
   CellTags->"i:29"]},
 "i:30"->{
  Cell[182530, 4652, 317, 9, 70, "TechNote",ExpressionUUID->"e9447a9e-2ae2-4e62-8c82-4a5e94538311",
   CellTags->"i:30"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:255", 274114, 6522},
 {"i:1", 274354, 6526},
 {"i:2", 274480, 6529},
 {"i:3", 274611, 6532},
 {"i:4", 274739, 6535},
 {"i:5", 274871, 6538},
 {"LastCellOfAPage", 275016, 6541},
 {"p:256", 275906, 6557},
 {"i:6", 276042, 6560},
 {"i:7", 276175, 6563},
 {"i:8", 276301, 6566},
 {"i:9", 276428, 6569},
 {"i:10", 276556, 6572},
 {"p:257", 276686, 6575},
 {"i:11", 276826, 6578},
 {"i:12", 276966, 6581},
 {"i:13", 277095, 6584},
 {"i:14", 277224, 6587},
 {"i:15", 277353, 6590},
 {"i:16", 277489, 6593},
 {"p:258", 277625, 6596},
 {"i:17", 277772, 6599},
 {"i:18", 277919, 6602},
 {"i:19", 278054, 6605},
 {"i:20", 278187, 6608},
 {"i:21", 278322, 6611},
 {"i:22", 278454, 6614},
 {"i:23", 278589, 6617},
 {"i:24", 278724, 6620},
 {"i:25", 278858, 6623},
 {"i:26", 278993, 6626},
 {"i:27", 279128, 6629},
 {"i:28", 279284, 6632},
 {"i:29", 279418, 6635},
 {"i:30", 279553, 6638}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[674, 24, 477, 12, 93, "SectionDoubleDigit",ExpressionUUID->"b06fcce9-d1f1-4aa1-ad3f-83b38443d3ad",
 CounterAssignments->{{"Section", 41}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:255"],
Cell[1154, 38, 883, 25, 117, "Text",ExpressionUUID->"3755b7ce-c176-4d49-b5e6-5e784a4858fa",
 CellTags->"i:1"],
Cell[2040, 65, 334, 9, 37, "CodeCaption",ExpressionUUID->"34e06253-8c8c-49bc-995a-a899f07b625a",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[2399, 78, 263, 5, 29, "Input",ExpressionUUID->"1cb2e9b5-9fb7-4c10-be97-aa3bb9a9d3de"],
Cell[2665, 85, 277, 7, 40, "Output",ExpressionUUID->"8a4fd4c5-23f0-4219-9b62-ceb63def788f",
 Evaluatable->False]
}, Open  ]],
Cell[2957, 95, 299, 9, 37, "CodeCaption",ExpressionUUID->"113f2a01-c752-4063-a41b-47c2086e45e1"],
Cell[CellGroupData[{
Cell[3281, 108, 285, 5, 29, "Input",ExpressionUUID->"5e9319ff-2cf3-47e4-85f4-8e102825de03"],
Cell[3569, 115, 285, 7, 40, "Output",ExpressionUUID->"6453bdd6-8340-471f-a020-2629cc59225b",
 Evaluatable->False]
}, Open  ]],
Cell[3869, 125, 431, 12, 37, "CodeCaption",ExpressionUUID->"366427e2-a212-4ad9-8ac2-57414f2020cb"],
Cell[CellGroupData[{
Cell[4325, 141, 330, 7, 29, "Input",ExpressionUUID->"667c4beb-b912-4f3b-b079-f34e33d0e13d"],
Cell[4658, 150, 425, 14, 53, "Output",ExpressionUUID->"4c718184-e3ac-43d4-b674-adfafd05cdfd",
 Evaluatable->False]
}, Open  ]],
Cell[5098, 167, 1549, 42, 118, "Text",ExpressionUUID->"d5b3304d-2452-495b-978f-111c7baad48a",
 CellTags->"i:3"],
Cell[6650, 211, 402, 12, 37, "CodeCaption",ExpressionUUID->"67783737-6b5c-4456-a3ad-8ef1254b214f"],
Cell[CellGroupData[{
Cell[7077, 227, 336, 7, 29, "Input",ExpressionUUID->"9f56850c-504e-4f62-bcb1-8d7ead4c645b"],
Cell[7416, 236, 247, 7, 53, "Output",ExpressionUUID->"38f422a6-f6a0-45cf-8488-2237099cfb8d",
 Evaluatable->False]
}, Open  ]],
Cell[7678, 246, 415, 12, 39, "CodeCaption",ExpressionUUID->"a40b7db1-367f-4074-98c7-68e53111e95a"],
Cell[CellGroupData[{
Cell[8118, 262, 347, 7, 70, "Input",ExpressionUUID->"4489116d-fab1-4755-87fc-ff20bb35fad6"],
Cell[8468, 271, 263, 7, 70, "Output",ExpressionUUID->"c266e2f8-9ef2-436d-b38e-a81291bf93c6",
 Evaluatable->False]
}, Open  ]],
Cell[8746, 281, 245, 8, 70, "CodeCaption",ExpressionUUID->"9a1b9b07-4459-4a52-a7cb-ff26d608f9ff",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[9016, 293, 385, 8, 70, "Input",ExpressionUUID->"b43806e2-0d00-48d9-9b37-189c94929d8b"],
Cell[9404, 303, 321, 10, 70, "Output",ExpressionUUID->"5df0ec88-5db1-4ced-9739-9663514f0099",
 Evaluatable->False]
}, Open  ]],
Cell[9740, 316, 328, 11, 70, "Text",ExpressionUUID->"e71a8619-af65-46d4-ba66-ea1d900a7fb3"],
Cell[10071, 329, 205, 4, 70, "CodeCaption",ExpressionUUID->"bb2b6bcd-fc64-4870-b496-0ed2b72483fe",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[10301, 337, 379, 9, 70, "Input",ExpressionUUID->"7daa5a7b-e2a1-4d02-8d44-8e7f982dcb18"],
Cell[10683, 348, 244, 5, 70, "Output",ExpressionUUID->"f7685304-5dde-4c5a-ad80-3024627662bd",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[10942, 356, 469, 15, 70, "CodeCaption",ExpressionUUID->"ad5e9bb2-195a-4833-abe9-a3e75d8259aa",
 CellTags->"p:256"],
Cell[CellGroupData[{
Cell[11436, 375, 404, 9, 70, "Input",ExpressionUUID->"37c9374b-3557-4c0b-902f-a7cd5804d457"],
Cell[11843, 386, 206, 4, 70, "Output",ExpressionUUID->"8f4d4d9a-9b4e-4c94-8859-feddd7996afa",
 Evaluatable->False]
}, Open  ]],
Cell[12064, 393, 269, 9, 70, "CodeCaption",ExpressionUUID->"d0d0965c-780d-4ddd-8f4e-2a812fe64f37",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[12358, 406, 450, 12, 70, "Input",ExpressionUUID->"5df2ad75-7542-4111-9755-144b1fa00794"],
Cell[12811, 420, 370, 8, 70, "Output",ExpressionUUID->"97dae070-a955-4fa3-a0a6-c37f060b53de",
 Evaluatable->False]
}, Open  ]],
Cell[13196, 431, 257, 8, 70, "Text",ExpressionUUID->"cf74ceef-32f6-45ab-9b3c-056c2e97014f",
 CellTags->"i:7"],
Cell[13456, 441, 431, 12, 70, "CodeCaption",ExpressionUUID->"2259330f-ddcb-4863-834a-e3f72679efad"],
Cell[CellGroupData[{
Cell[13912, 457, 362, 10, 70, "Input",ExpressionUUID->"3d44e525-35cd-40e9-8516-59025bac5176"],
Cell[14277, 469, 314, 7, 70, "Output",ExpressionUUID->"1bacdf79-c94a-4a52-8f4d-b0fd59be629e",
 Evaluatable->False]
}, Open  ]],
Cell[14606, 479, 570, 18, 70, "Text",ExpressionUUID->"fcfff13d-9606-4570-9554-200cf8836734",
 CellTags->"i:8"],
Cell[15179, 499, 184, 4, 70, "CodeCaption",ExpressionUUID->"4d31d2dc-7a72-41c5-8fc0-0453e587b40e"],
Cell[CellGroupData[{
Cell[15388, 507, 322, 8, 70, "Input",ExpressionUUID->"c6c38424-91d9-4fa7-81de-85b839a5abb0"],
Cell[15713, 517, 271, 7, 70, "Output",ExpressionUUID->"9da2682b-1309-465a-949e-09d3381cc7e2",
 Evaluatable->False]
}, Open  ]],
Cell[15999, 527, 517, 16, 70, "Text",ExpressionUUID->"5a4769e4-b7aa-43e4-932e-c346f203917c",
 CellTags->"i:9"],
Cell[16519, 545, 182, 4, 70, "CodeCaption",ExpressionUUID->"a213c363-4e9f-49d6-a56f-de9fae29eae5"],
Cell[CellGroupData[{
Cell[16726, 553, 254, 5, 70, "Input",ExpressionUUID->"ec19a97c-244c-402b-8966-4a6de7f1b89c"],
Cell[16983, 560, 300, 7, 70, "Output",ExpressionUUID->"6106554c-00f5-4e6b-94ff-46089f3b902d",
 Evaluatable->False]
}, Open  ]],
Cell[17298, 570, 261, 7, 70, "CodeCaption",ExpressionUUID->"b61e0373-3f22-494a-b6a6-498f0eb23962"],
Cell[CellGroupData[{
Cell[17584, 581, 311, 7, 70, "Input",ExpressionUUID->"4f370568-fa3c-4e7b-9500-031d6dd266e7"],
Cell[17898, 590, 243, 6, 70, "Output",ExpressionUUID->"16b71ca0-c3dc-46d9-9921-d08b3a2c10a2",
 Evaluatable->False]
}, Open  ]],
Cell[18156, 599, 373, 11, 70, "Text",ExpressionUUID->"29fce3c7-1985-40b0-9cd7-7597d20906a8",
 CellTags->"i:10"],
Cell[18532, 612, 219, 6, 70, "CodeCaption",ExpressionUUID->"483ef844-3b9b-422c-8013-e69424ac54de"],
Cell[CellGroupData[{
Cell[18776, 622, 186, 3, 70, "Input",ExpressionUUID->"a02ef30d-6241-4d74-962a-38175190500f"],
Cell[18965, 627, 284, 7, 70, "Output",ExpressionUUID->"c3dc160c-21f2-422d-826d-d4842cdc50ad",
 Evaluatable->False]
}, Open  ]],
Cell[19264, 637, 195, 4, 70, "CodeCaption",ExpressionUUID->"d3c8f85f-263b-4fd3-8e28-d0b1b3e9c259"],
Cell[CellGroupData[{
Cell[19484, 645, 265, 5, 70, "Input",ExpressionUUID->"481e3a4f-7f96-4738-b8c5-c5e9ef36bceb"],
Cell[19752, 652, 362, 9, 70, "Output",ExpressionUUID->"8fdda2c9-a729-42bf-8b63-17b25100e275",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[20129, 664, 480, 13, 70, "Text",ExpressionUUID->"5b6d6cfb-9253-40eb-876d-0efed4a287f9",
 CellTags->{"p:257", "i:11"}],
Cell[20612, 679, 161, 4, 70, "CodeCaption",ExpressionUUID->"c2d18b70-aed7-4c73-b29d-d87601d8c1ee"],
Cell[CellGroupData[{
Cell[20798, 687, 240, 5, 70, "Input",ExpressionUUID->"2eecec11-16c5-4d10-ac3f-89104301edbf"],
Cell[21041, 694, 284, 7, 70, "Output",ExpressionUUID->"83b166fc-a185-49f9-990c-32d5506d8b7c",
 Evaluatable->False]
}, Open  ]],
Cell[21340, 704, 416, 12, 70, "Text",ExpressionUUID->"a13204df-fdb1-4047-a319-256c6bfdb23b",
 CellTags->"i:12"],
Cell[21759, 718, 343, 10, 70, "CodeCaption",ExpressionUUID->"433b8c22-3e70-495c-958f-a8b7029b011f"],
Cell[CellGroupData[{
Cell[22127, 732, 318, 8, 70, "Input",ExpressionUUID->"cbb98337-f620-4152-a8cf-ae243a21da82"],
Cell[22448, 742, 203, 4, 70, "Output",ExpressionUUID->"3b3eefc2-0283-4ebf-a61d-d2f123c19b6f",
 Evaluatable->False]
}, Open  ]],
Cell[22666, 749, 344, 10, 70, "Text",ExpressionUUID->"58545237-5f96-41e0-878a-db161d1f3c22",
 CellTags->"i:13"],
Cell[23013, 761, 272, 8, 70, "CodeCaption",ExpressionUUID->"07b8eef4-2687-45ee-a8c5-466d0fb11619"],
Cell[CellGroupData[{
Cell[23310, 773, 336, 7, 70, "Input",ExpressionUUID->"600abfac-6225-470d-b97d-19d0bd371e3e"],
Cell[23649, 782, 213, 4, 70, "Output",ExpressionUUID->"2a45f7e5-4c29-4c1f-9779-fa3c7db7d4ed",
 Evaluatable->False]
}, Open  ]],
Cell[23877, 789, 401, 10, 70, "Text",ExpressionUUID->"2170f7f9-b0db-4068-b7f3-96476bdcc590",
 CellTags->"i:14"],
Cell[24281, 801, 404, 12, 70, "CodeCaption",ExpressionUUID->"e9a205f4-053c-43fd-ba60-c30b7185469b",
 CellTags->"i:15"],
Cell[CellGroupData[{
Cell[24710, 817, 243, 5, 70, "Input",ExpressionUUID->"cfb31a6c-9e66-4c0f-a672-1e7c44d0227f"],
Cell[24956, 824, 198, 4, 70, "Output",ExpressionUUID->"1be52ccb-2d4a-4efe-9905-bbd77baf31ac",
 Evaluatable->False]
}, Open  ]],
Cell[25169, 831, 205, 4, 70, "CodeCaption",ExpressionUUID->"639d4081-557f-43df-bfd9-827df3b1eb90",
 CellTags->"i:16"],
Cell[CellGroupData[{
Cell[25399, 839, 439, 11, 70, "Input",ExpressionUUID->"75983e50-39e7-4475-aee8-0f91ee2aa8d7"],
Cell[25841, 852, 224, 4, 70, "Output",ExpressionUUID->"34eab068-0174-4f65-8054-83f259cdcf31",
 Evaluatable->False]
}, Open  ]],
Cell[26080, 859, 570, 18, 70, "Text",ExpressionUUID->"2afdabf8-2046-44fb-9d9c-28159fcccbc1"],
Cell[26653, 879, 496, 17, 70, "CodeCaption",ExpressionUUID->"250b4070-b0ad-4a21-9c7a-06753e65ff1f"],
Cell[CellGroupData[{
Cell[27174, 900, 228, 5, 70, "Input",ExpressionUUID->"f1463554-9ab9-4b22-b418-559fdb3fac2a"],
Cell[27405, 907, 241, 5, 70, "Output",ExpressionUUID->"8b3fe170-f07d-4c63-8b4e-fd1d8f7db514",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[27661, 915, 341, 10, 70, "CodeCaption",ExpressionUUID->"f7171858-2d7b-4767-a730-64eed13de514",
 CellTags->{"p:258", "i:17"}],
Cell[CellGroupData[{
Cell[28027, 929, 259, 7, 70, "Input",ExpressionUUID->"ee0d63a4-be5f-4123-9271-f0659ce44ddf"],
Cell[28289, 938, 211, 4, 70, "Output",ExpressionUUID->"6b6dcbe8-d6e3-471e-b1cf-619da1bd1b92",
 Evaluatable->False]
}, Open  ]],
Cell[28515, 945, 240, 6, 70, "CodeCaption",ExpressionUUID->"d3659c47-66d8-45f0-ae7a-24036981beef",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[28780, 955, 228, 5, 70, "Input",ExpressionUUID->"92abbd93-f9e0-4614-a065-bf9539af024b"],
Cell[29011, 962, 220, 4, 70, "Output",ExpressionUUID->"55217262-c9e7-423f-bb3b-a93164a0fac4",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29280, 972, 159, 4, 70, "VocabularySection",ExpressionUUID->"0e9f9b55-5eb7-4541-acff-c10df62e19bd"],
Cell[29442, 978, 5703, 155, 70, "VocabularyTable",ExpressionUUID->"67063ab0-b230-4228-b300-b1d511c04921",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35182, 1138, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"86c0862d-1ade-41ea-9d1c-b8e9e85b0d1c"],
Cell[CellGroupData[{
Cell[36987, 1188, 1270, 39, 70, "ExerciseSummaryCell",ExpressionUUID->"41a1d41a-0072-44b8-a201-7fec057cebcf"],
Cell[CellGroupData[{
Cell[38282, 1231, 914, 26, 70, "Exercise",ExpressionUUID->"6c082fe7-7b78-4bf4-86f4-b6065f0cf318"],
Cell[39199, 1259, 1101, 31, 70, "ExerciseOutput",ExpressionUUID->"6f912bd0-1cc0-4d66-acc5-b7555d0b6c8b"]
}, Closed]],
Cell[CellGroupData[{
Cell[40337, 1295, 782, 21, 70, "Exercise",ExpressionUUID->"64d041a3-e314-45df-bda2-8fc0b747b5aa"],
Cell[41122, 1318, 4152, 76, 70, "ExerciseOutput",ExpressionUUID->"cb04ffca-2de8-4bd9-ba15-7e170bd2135e"]
}, Closed]],
Cell[CellGroupData[{
Cell[45311, 1399, 933, 25, 70, "Exercise",ExpressionUUID->"2aa16d20-8bf4-4495-b7ea-aa16b75d2bb0"],
Cell[46247, 1426, 4366, 87, 70, "ExerciseOutput",ExpressionUUID->"8fa6d3cf-1216-4861-ac7d-7be7f23be981"]
}, Closed]],
Cell[CellGroupData[{
Cell[50650, 1518, 1115, 32, 70, "Exercise",ExpressionUUID->"586035f3-5bf2-4435-9870-d768f7cfbbea"],
Cell[51768, 1552, 4377, 90, 70, "ExerciseOutput",ExpressionUUID->"4624d66b-26f3-4dac-88ab-8518d98ef272"]
}, Closed]],
Cell[CellGroupData[{
Cell[56182, 1647, 832, 22, 70, "Exercise",ExpressionUUID->"fefe7f3d-264e-4ce3-921a-04abf09558e7"],
Cell[57017, 1671, 2358, 55, 70, "ExerciseOutput",ExpressionUUID->"5c13fe8b-8b28-4b51-872c-68ccf7f09828"]
}, Closed]],
Cell[CellGroupData[{
Cell[59412, 1731, 762, 21, 70, "Exercise",ExpressionUUID->"31c95093-37e0-4240-99b9-bad3ba0e29b2"],
Cell[60177, 1754, 1376, 36, 70, "ExerciseOutput",ExpressionUUID->"c4d5e1c0-632f-4d00-bf75-309023d339ce"]
}, Closed]],
Cell[CellGroupData[{
Cell[61590, 1795, 814, 23, 70, "Exercise",ExpressionUUID->"ebd0713e-5f7a-4005-83af-c98d141618e7"],
Cell[62407, 1820, 109291, 2462, 70, "ExerciseOutput",ExpressionUUID->"81f9651d-97d5-4d56-9dc1-4be5dd0e2941"]
}, Closed]],
Cell[CellGroupData[{
Cell[171735, 4287, 1551, 48, 70, "Exercise",ExpressionUUID->"605ad978-8731-4ee5-ad0d-601061f388aa"],
Cell[173289, 4337, 2417, 62, 70, "ExerciseOutput",ExpressionUUID->"09c954a7-5af9-4d6a-bc2f-8f773c527a32"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175767, 4406, 144, 4, 70, "QASection",ExpressionUUID->"ff657d7c-01df-46ad-945f-1ee1b2679bf2"],
Cell[175914, 4412, 274, 10, 70, "Question",ExpressionUUID->"55930f7f-e22c-4bc6-9a66-e193f9507d1e"],
Cell[176191, 4424, 352, 10, 70, "Answer",ExpressionUUID->"97d7fbfb-5cb7-42a6-aef2-188dff7e49fe",
 CellTags->"i:19"],
Cell[176546, 4436, 296, 10, 70, "Question",ExpressionUUID->"e2dbaa0a-7230-4af3-a691-13b3c8943400",
 CellTags->"i:20"],
Cell[176845, 4448, 322, 8, 70, "Answer",ExpressionUUID->"bd9273d4-d3e0-4c73-81f8-a3ffe152ad40"],
Cell[177170, 4458, 193, 4, 70, "Question",ExpressionUUID->"0c5a1e9e-acea-4d99-a50c-8205bc546bd1"],
Cell[177366, 4464, 297, 9, 70, "Answer",ExpressionUUID->"cd2e8a06-c178-404a-801c-8afd3e145e43",
 CellTags->"i:21"],
Cell[177666, 4475, 285, 9, 70, "Question",ExpressionUUID->"0ed2b94e-3648-4893-93ce-836943bad85d"],
Cell[177954, 4486, 412, 12, 70, "Answer",ExpressionUUID->"a90c47df-f01d-4627-bb3f-b1563b37c7fe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178403, 4503, 157, 4, 70, "TechNoteSection",ExpressionUUID->"5c1a6b97-71c4-4027-94b8-e7636df3d55b"],
Cell[178563, 4509, 431, 13, 70, "TechNote",ExpressionUUID->"453f2bb2-a1ca-490f-a0b3-dde75e14e55b",
 CellTags->"i:22"],
Cell[178997, 4524, 343, 10, 70, "TechNote",ExpressionUUID->"80513067-5816-4996-a4d7-eb801d14484a",
 CellTags->"i:23"],
Cell[179343, 4536, 369, 9, 70, "TechNote",ExpressionUUID->"6e6f5cfb-f61a-4f8a-92a4-c3c273edaf55",
 CellTags->"i:24"],
Cell[179715, 4547, 595, 27, 70, "TechNote",ExpressionUUID->"f860d720-03ec-476e-a793-b012d05d97a8",
 CellTags->"i:25"],
Cell[180313, 4576, 710, 21, 70, "TechNote",ExpressionUUID->"603e030e-1c3c-4876-bc54-e942323f31f9",
 CellTags->"i:26"],
Cell[181026, 4599, 699, 21, 70, "TechNote",ExpressionUUID->"422ace7e-1c0a-469b-b9ae-1b7522bd5b32",
 CellTags->{"LastCellOfAPage", "i:27"}],
Cell[181728, 4622, 325, 9, 70, "TechNote",ExpressionUUID->"6ec7a7a9-edbd-4c99-95c5-56453e311c02",
 CellTags->"i:28"],
Cell[182056, 4633, 471, 17, 70, "TechNote",ExpressionUUID->"05e72e79-d617-4bae-a5f2-5ce6f3715c7c",
 CellTags->"i:29"],
Cell[182530, 4652, 317, 9, 70, "TechNote",ExpressionUUID->"e9447a9e-2ae2-4e62-8c82-4a5e94538311",
 CellTags->"i:30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182884, 4666, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"281c4cfe-9f9e-4307-8091-cbd69c5466d3"],
Cell[183052, 4672, 344, 8, 70, "MoreExplore",ExpressionUUID->"8c0821e1-a7cc-44f3-b62a-ca3b0f0626da",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature JLNafj4u@#5S9J55xQctRZO1 *)
