(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    278184,       5581]
NotebookOptionsPosition[    212311,       4207]
NotebookOutlinePosition[    271240,       5418]
CellTagsIndexPosition[    271161,       5413]
WindowTitle->String Patterns and Templates: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Replace each space in ",
 Cell[BoxData[
 "\"\<1 2 3 4\>\""], "InlineCode",ExpressionUUID->
  "7d775c0f-2f08-4223-8af8-7e0f51909bb5"],
 " with ",
 Cell[BoxData[
 "\"\<---\>\""], "InlineCode",ExpressionUUID->
  "f49f49f5-9f99-44dd-a1d5-11c4b9b98b4d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"4f754d1d-6584-4b19-a822-1eb1be6299e1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"33c397fd-e8e9-4e84-9456-148124a848ed"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztly+P2zAYxq2NDE7aJ9gXCB41HIp001hIT2tPI13VmzSVhgWahQUFBQUF
hQSZmJiEGIR4IMDAxCCgs53+za0je+90ID8pkW1Fj+3nff26/Xj/4271BiH0
+M6+7ha/8Ha72H15bztf14/fH9bLb5/XP5cPy+2n+7d28IN9FvZx7f3MzMzM
K0ILzjs9QKtKWpVFUdK2B1Y2Pa3LoqxoK4GVD6iWsU6ZsSOKHfIkVEHOwYvA
y47vTdFCKQ+yDi+Uw6SBDu2eEjdDkNCx29V5vHEjKYO0SOSRdd3HWOcrFwGo
TBpkhYNYeF/qBCOEqQaS9hhRjDkTpuxiuLUeEVCLrDPqeHIVTcA3clBuYmhl
mdjsxFEUIEwuLDIMw1t0hhErH8NWDd1L3hQ2U9EqB3SIZ06y6mQeouAfFple
tOIaafZGiim9ufXxmaEr/T5aUGWd4vE0HJcNoTwudVe5YGYY4bS9ZZFmCZoS
0N80eDIaU/X3j09xVdRFJToEGlLZ7sj0FXHyZTdAKOvMXwObhBAS+2aY1t1x
Mu5qEdenudUE7TzW01Flhlsfe3rq6jQm/cWuIJTNOUsHjse7GEDZNHlK0pQ4
ktCZG2ZN5+o357zJbH+XNy3nV4fkPzCyjnx40ppxxiilQsFcztXGxnxXt1L1
XZm4aOcCaNFnBn/QuGsaFl4nHGEwxY+nE2Gw311Gsjg6HaCAVAJE9hpX68KM
P4PyyzEYe4bA/w/MzMzMvFL+AG3QurY=
            "], {{0, 19}, {97, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{97, 19},
          PlotRange->{{0, 97}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{101, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "44bb4561-27a2-44b7-9cc3-bd312ad2c170"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztly+P2zAYxq2NDE7aJ9gXCB41HIp001hIT2tPI13VmzSVhgWahQUFBQUF
hQSZmJiEGIR4IMDAxCCgs53+za0je+90ID8pkW1Fj+3nff26/Xj/4271BiH0
+M6+7ha/8Ha72H15bztf14/fH9bLb5/XP5cPy+2n+7d28IN9FvZx7f3MzMzM
K0ILzjs9QKtKWpVFUdK2B1Y2Pa3LoqxoK4GVD6iWsU6ZsSOKHfIkVEHOwYvA
y47vTdFCKQ+yDi+Uw6SBDu2eEjdDkNCx29V5vHEjKYO0SOSRdd3HWOcrFwGo
TBpkhYNYeF/qBCOEqQaS9hhRjDkTpuxiuLUeEVCLrDPqeHIVTcA3clBuYmhl
mdjsxFEUIEwuLDIMw1t0hhErH8NWDd1L3hQ2U9EqB3SIZ06y6mQeouAfFple
tOIaafZGiim9ufXxmaEr/T5aUGWd4vE0HJcNoTwudVe5YGYY4bS9ZZFmCZoS
0N80eDIaU/X3j09xVdRFJToEGlLZ7sj0FXHyZTdAKOvMXwObhBAS+2aY1t1x
Mu5qEdenudUE7TzW01Flhlsfe3rq6jQm/cWuIJTNOUsHjse7GEDZNHlK0pQ4
ktCZG2ZN5+o357zJbH+XNy3nV4fkPzCyjnx40ppxxiilQsFcztXGxnxXt1L1
XZm4aOcCaNFnBn/QuGsaFl4nHGEwxY+nE2Gw311Gsjg6HaCAVAJE9hpX68KM
P4PyyzEYe4bA/w/MzMzMvFL+AG3QurY=
              "], {{0, 19}, {97, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {97, 19}, 
            PlotRange -> {{0, 97}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4f6a2cc7-c7d8-448c-b0f9-e26b2e4e76e1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"98b6e801-a40b-4202-b99c-728479c4722f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ad3b2efb-f8d7-49da-bc5c-ccd95c319aa7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ca391a35-c999-4a23-8c94-dc818a8b07e3"],

Cell["\<\
Get a sorted list of all sequences of 4 digits (representing possible dates) \
in the Wikipedia article on computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"dbb10425-77fc-4d6b-9dc4-fad95fa42d73"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5b730779-3fd0-4258-b033-1d6ff8aad9bf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT/L+0p6hp2kSZmvkC/gOq3LVIYN6dzskuMlEDZmNxDculOpTp0rV07j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            "], {{0, 108}, {486, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{486, 108},
          PlotRange->{{0, 486}, {0, 108}}]], "ExerciseOutput",
         ImageSize->{490, 108},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cc7c197f-81ec-41b3-b0bb-966c437c5d39"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT/L+0p6hp2kSZmvkC/gOq3LVIYN6dzskuMlEDZmNxDculOpTp0rV07j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              "], {{0, 108}, {486, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {486, 108}, 
            PlotRange -> {{0, 486}, {0, 108}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c06f7dce-cb6f-47b6-92f8-961ed59fb6dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1ed3dd13-8ca2-44a7-9620-dc8b1e5bccf6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a0495bfd-870f-4f3c-8c26-639184d63760"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3247582e-0ec7-4141-ad53-6a320488129f"],

Cell[TextData[{
 "Extract \[OpenCurlyDoubleQuote]headings\[CloseCurlyDoubleQuote] in the \
Wikipedia article about computers, as indicated by strings starting and \
ending with ",
 Cell[BoxData[
 "\"\<===\>\""], "InlineCode",ExpressionUUID->
  "411dfbb1-7c1f-4873-a55b-64aa02ef2330"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"f13714b5-63b9-4d82-9c94-6a6229f3bf69"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd458b32-4908-4a3e-ae70-dc743580715a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvb+r/E6X59f2gnHof8Hx2oqdCkfGgWCMwQtKdu3RsslYnlkwSjtyO7Iy
JUaRoo46ksEoER6sXUbsWniRbcQgHlZPoIV+QE+gQEFb9UNS/TglqX/ce/ve
W+/5zsP99FXXj3NOHVWVdOv1H/+T//4vnH//cDj8zX84/s9f/OP/0fzrv/7H
3n/1H43/+K//6m/+2T/9q7/87/6Lv/rnf/lP//Kv/7N/8g/GD/+Df+9w+Lfj
/6Ofb1paWlpaWlpaWlpaWlpaWlpa31BD3w97r+2rPK+vuy//hrrDGG+mri7y
sv3qVnx7vTAAHvDIPYNRa4+u8ckxDLfo50/67BwGRGF0SbKme0E1o+M+xHVD
383F9rl1OJh+vuviLjMOh2N2fX2Tlto+LVYZl43y/Sitq7N7OByCYpfzPso7
jyo/jc45faBvfqjYkLsrADZ1t0c2B6PWneqKYHSoc7o0y0jtAnP8zHQcx7bQ
T4eDlT49x0G+PmbPliKpy/2xqTmJx6EOXMeP610X41jy8w/LB0M9DpXTx5XP
ibjMsGzbGmWablRc88i2vbTZlYE/yDsPqxj7YwSvyTK/R3zI3RUAm7rbI1uD
Uete4fTl9/xno1vMoKD/ahJTvD+yd280Vd1T0ZgNDL/Yvo6tBSwZfbx8PpQB
Sr+qJgzcdJG7uM/Hfvl4OdF33UpAD/KUE/joJpYzFHP5e7TTjAphl+0w71IL
34VV76BLgaIULQaMqTRXz17SMdfckxn2RqBcqeq7A9cW+lknX6nol/KXULnT
pWwDgWt2dXJHyO33Dtug8X/L0OI9cp/Z56KEmlRRpCWrL1Cu5gcFGfi5+M+h
OprmKYocPNMeI6LJIgtPuw+mmzYrJu/OLpmfG+M6yo0urmEEWUuqH3/2LhW+
rPUt45Q0409yyX0VWbafJgH92LuMbS7P3mGS4UTdUHmGGdJFX5cELvmVdTxf
5YvxvNqLzkfaNDdvpYi9lgFt+cEN0g4qlpjFv1y4cvrSNebanHEm35fR2NGS
3ibGXpvnCg+BaJx8XCIPXf2P/uIf2sFk9qE+moa/dz0juAxXUp3NaWuLreWU
/zENnMm6QdXx3jmXvAEuNjWZaVmGYYfICNfiZJPuGX6MfQcaATSX2Jhr3+T+
ZGTTi8j3tnM1rvEYhtTOppfhCeQeO5/+ZQ5+98Z17eCFKSmmzSNziptLeVX1
i7XaStiYTlB2xEEopJPYp9WdizoLSd32Ke4mW9mnKPSoWf2EjJT+4plOSO+t
9cXD8SyF3BwASu8MeUQHxehd0zjMZVIbt/mRjEPDdtCMjXpEGJ5DE1sHamfU
1WLshVNc2cE42vA82dU6F1fe1FMUaa2qiuzRVHyw8fPqNkX7TuM/u5w4yA0v
aVb+uQxRUI1WrssQheGxUdfS5GjIG26QpEle/8EfXeQlqKYc514rRG5u4vHH
qOx7qGSyVzN+fMkLEvZB0XVNecE/n85JmldDh6fKeA2YnsYfjSAp6yJ28LpA
vLjPbTpG0gLHnri3NmZ+3LgozbPYt52whYqdzeJFTDnDNbugXtr+JU2zcWTg
9pvZtP0yt7MI8LcdP0mz/+1/GX92SjyMiGXivQtYvAfixe21bdumadET0w7d
hWmNbC3/5v9EJYfZaN3k6HhjK3jvMAmyL1B3TnFzrc8oyxnnvBmIWczjWECG
b3/nuoeNAJqLb8xYWzXe/O1TVlY5zlpe3Nz25OqpxtMlK3H7D8apve2yc/1H
+LuTx51LViQ4iVnjrXMox5ZbftI01fnk+mmj6tdW2ByOKNLOuDo2pJ04z880
J1pRNpoBXXKph7nZ4y2sqPLAMabPu8AYRy2tNPdHW/kdEHJTACi808SopUFa
tVXi4N6WLTtxrvDdxT6PHcEljxd06G4oD8/aQ31KyddiF+WLKzMYxxsoMX5W
5OeTc4zrGxhFWmpdqwTZ9SRsVHYhDhAb7VfjG5/hodsjnohaPrm4PzvofjiG
3DDOIpvL+A8UFX1blRUvMuHuQ2aRXoZjNHoNWnqPn44utfLh1iIfu7WiZBzY
RkpuKkMxbzXjbQ2rICltHpu4qU5U4jJwwOP7kXDxeM0xIRPXAQ0h58yGC94d
QveO5SOwWFU5uJFBMU82AnarnM8hHt3Uu6bGVFTiTbewXSIumzVbjNbI1kJS
hBdlzCswnHeWQvGVCbF5FZLtI2KWyziykA3aExqXOWxMhRe4Ls91tU2Zk7yX
3dhcrYooXPhpejR8TY8kL+2ys+q7uGvnmtolPRro1vkn5EfDDct28oaiX7Qj
irCxpylrX6BcN7aKNJVMu4cqwh+Sf6CtjBNtNs7DTDkWmkRxy6jFVqqQU4Ro
PiZgIxjmQuwzOzPAqX7pSElrgYcnHtFuNdD7uztm48X4+Cu8x+Eo0lLrhMd1
Ii7hOhTX49Lucj6fL+MUlHqLbvDSHYbIPvCycxTtp4MonMP56CKRGdf1eHWQ
Fyfk0wZlJzdWlqwYg/Dn05x5kYUW79DFdBwII+6Gl5Zkq2cRWKyqHKaRcjut
JYewE0g8J7Gi4VY70wxzn5B5jVM6kBc68KYgn6u5WsZpHFl8Wt65nb4OPLLH
MyvDi6q6CGwyg7rVsSfYwMa5GjCCwgvCnPlanOmc0kaXW3TuTa9RRhRvXjLZ
Q0utPXZWfJd0bR4O5En0WNe1jB26W+Im40pA0a+VsLHYp8zTTINv6jL94G8x
rK2uPp1Ocytf5r6mCDlFiLYZSpinuKiLC5owhdz2V5ueWGtMtcDD89YmB7xV
3mUnNPXiHIQnEnTWPVkJjCIttYZrecQzOf5jfg9kFhcJPXKZPPEb+qsg+uhA
KBM9sLaP47raHuMjOxqGe3TorR8ueSNX9/zneP3lXsRn0PDFWPKi+4oj+cLm
S7BYVTncrY1UPQ1h/LogNBhJ3jDD6IgC/o5FIZBs1bmaaKjSyCS7WyqP367o
rm2YY4aw3YDuMqIMNi1w1o2g8ALfGDSnGi8i/4xMurRn5oqKiGIeDd/ocn6e
V2/ZWfFd3LXDfIfM0MaFPWfdrsnRfu84y1X0i5pMETbOmW7JDvX5gFO3KqTl
XE2bgJddNprP4+znXJYpsTLkzFy6ry3Xt2jX0UTuNb0wFXac5lsV/y3FwB8/
H+8Ax/OZzri4XI2+QnaZZiuBUaS1qgqtiKD9anmW1XEev6Ib6MEJkuZ6rfM4
iLLVrVWydDoWTV3h17UT8pzDjvopvNGbgVdlycpcTZaceVXXLbNf3V/QTpoZ
pdX12mTn4Lx2MRJZbHJ26PD0yfDSsqmL2HX8eoCKVZVDVsph2jToD27IfsLx
kjdVSp4BMYORfbZ79ckDIC8WTTiU473NPMZQCt+Tq2ktReRa41S57boms5EH
Ktk7UxEo153i8oq2wVGWJOXi6e8pr9u2KaIgQusu2AiwF/guo1xteJe2a1O8
+2kte9rHeiWksHnH1V9a1lWGn/0tS6ctOyu+O05uUdfQJmpTJChU0FKlSWzT
jcum71v0wjIqBO7XVtgY4fhRleLHm+5otH252sIb40Vd5Xgb2yRjBO1RH+yx
VSV52m7SXC2FHC5fEaJ4ODjZ6EfqXt7cbYJaavtl2xYx3q82g6t64JN5+GF+
o5uplPxqXKlXbZOjTf8MjqJZa6H+e6V8D0RekuBIZl9ILs7HeQmzadiuiOhD
X7w9TvKzSyYbXYbHTjAXLZdM5kvzgnFpSV/Rp9vjFP3PzOdDEzrmXMgpqdcu
JoOCWcnSNpfneRvYdKMWLLZXlTOkPl0u4uVnM/3r4BzRaoaENLre5OptE9T3
IBfaMmUSw5d+cQNdxlqMraVOmb1t2yf5UPDOpOa09BX/1kX7nF0VL+tgw0Fv
8KqMAHlB6HIe0hckDpZ3cgxyxyF/x2Gf1a8HkHxrToWbXkEr32Fn5XfHrl3m
rlGPM2+GjE28kHc4wOiaLQ+ETR04UyGGk+DnaHxI59ac5eh+CG52yO44GEHa
zO2cqrB835ne0OBCbilf4R0yw2d15F+HrhN/7rhjLVs98MAfSnxHOk4PBdhK
h2z2MnrGWtzAKFqcuxLqv1f43np63CZ4iQq/NSqr76Sb90tKHsYrwXdEhw4t
mvt9F6sK76QpB1QsrH7ZBSJVt9etqku0YnTBBTZaBL3mL0RQD8QXhiXv4BmU
XXQDep9+6PPQWXLLHTbYvpSYWPiwW/c+nnwGZU+6IpS3Yee1797UHhdDd7Vf
wDd6qJB1oTkwvsWgiqTqx9mwXDsfcivCiynn3N2Ie/GzCfE1A9oP8B30OwY+
W9S+kfS6UP85Ig9WTCdYW29qfYraIj1HeIEJzScb9NzxEBVX+VcfJFyjGZft
MAxXsltrBp9X/br4df3nffdzBWzNvUxdiB4oBtWYPvuuSvGbeFG5/b2P1+eH
+jdRn0UnxzmWem/oq0UWvG6QgK4YuqZa+4OjD9C40neXlb5hn4r3OeoKvaBr
hI8ddvHMdz9XZeQY/KukL1RXJc7y5zMo8N7EIl8Q6lpaP0DjrKu7b7Gr9Y2E
3XvfzoyWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaW
1veSpmA/oWH9Veq7gL8/1REv6ldf5Xn9Pn9e9GH6dmHwkgbfDZvumjwrXvSm
e59F/jnbdajyswjvoTkHfpQ8SPb51hTsT6Gfz9xzPwiitJx9ik+8JIfGw99j
4NQqeiCjd3PEq2z7mn7hYwyP2deb53UU+zmuSHD5UYoOtnnAXK9r0iN63r8P
QOTJUe3Za/52tEMHI8qnu8h6GuFN2V6KI4w29Y0p2J9EP6fcc8elp8WZbkRO
LUwD15EBgkzzZjg1B4VX6L0c8TrbvqZfDArha/U6ij2NK8u2rVHmGFboSL0H
zPW6Jj2i5/37AESeOyP3WSnOtUbi51gwTxkGH4MfJh49p0C+MYGzOR6CDZga
/NbmLOttUNSbpoMo22ti4QIdYaYqDs+HIea3G0yQ33QEV+73sC3w+cNQbw7b
3ctHSCnLUfyC+xi6ZOV7y+erFPu7RFKEWJQUBkqbz65VNIkdsmu2Yi4CBjkI
T2evnBEPyq9DcQow4hXlz5+wBX14ru6bOJhwPORgXomnfIO45ALMmu8DopG6
UYyYnxP6B18fX+bjeSegc5lE8+nCp4mGzMUGRKa+9ct5whaCSppRydvoPVDU
e0wHUbbvdWWD1nz4dOKxcHJI9Q2EmE+keBEKv8cR39C2bKufgnp3ELabz9VL
OYZ9zulmKdxBzCU/nc+kR4YTVuQURNSG4zy7kXtHTJoSPAE6t/vS3dYo9vcL
BgyxYSC36iZSzv8gNon0N4ocfMF4s1XZavTdmRrCjss6oenCCOedWxCeLgUk
RjzY/mlHtlEw4heIPFR+3+T+9InpRS09Q/5jc/VQXwyEbC6qMnHxeO8lnjLI
JRdg1qwISim53kp0Dd07JdcbbpiX2Qn9eMQeak/m2P24rEpMgpaQVSCZmmJQ
vLxpS5wK7DBt2Rvt26Cot013BSjbD7gSl+mUPcu1gSDm02miIhR+0xHf0bbc
wuw5qDeI7eZQdPhoYi/Mi4x0hGR7uIMzw/2cZdOx/26Y5GloTpBZsHeTSe1L
XpCb47huVVLsJfVV7Dqux8j1hLOU8R6IE6RZlqbpGBnXgQsDsFUy5Vxs0tRf
N7ykWfmnLVvleUwToT2WmVLy2hx7gheggKSIB2dHtlEw4heIPFR+Nd527FNW
VjnOP4Ss+kl7IP21ropwTNbkfGOOpwyDj0GYNdaA8HfYtgShSwgpLINJIMGh
KU9dpefTYYGAzGRViEzdo7FsBmQKgSi0Pr/T8jYo6h2m6yXK9i6JrsSPQkxc
+GQ6CGLOphcOCr/liG9pW7bZz0G9VfB3nvR9nG60ONsv3Empg4RLnpL5JHqK
NDECEI8efxFuGDbpRDkcZhovTLGX1VcXx7IdRrZz4thbBASJ7rYGmhOPC4qe
dQHYKoByLjaJdNzPFsdt2QptUh0o4RHzNBG9FPQCEJB3ZRsFI35OvGD51Fht
U+axg9I76trH74FUPr61GZZNiGyE+8Ys7mDwsXInsy8d/moTo3vZ65lOzWwg
00GQIRGEqiBT9zGaKDpJWWWRO9+XZ70NinqX6UTK9kOuxPw+NF7YJYkMMVcS
5Lcc8U1tO+tJqPcq/J2Svo2F9H1Fc2U8b4c7yHHJWVfOP8MNUxAeV55D3Su4
qFVzAZRzsRyO+bvLVuzPPe51pvACEJB3ZRsFI37+Flj+taCUN8vG2Ek6FX91
ruY3o1CnDhZ57aieH7hwtoXBx6pBQcib0bhKqaq6qWO0gHHGKQpoPbKkOtGF
f2lJQ1hFpsYGxHxuy5HfQnwbFPUdplso25JJIfGuJDhXFzWGKRyAmKsI8puO
+Na2vT0N9V6Dv6P29IT0Pf2+PU44LbiD/E0HytVww9ZyNUCxl4yA9t7HgDAN
8h8KDZfPQuv71WCrAMq5WA7X3w1bybl67jXoBSAgFV+Hg1zBiF8qBcpHU/px
uJHyI7oUen2uPjhBXuRZNv6XFWhthz7Km2ud4zsFxFMGwccSv5sI7+8x0KJp
8XvlViWL9fBv0/raFmR6z9CfMQUbIlPTjlhBPfG5xae6b4Oi3jQdRNmebbfB
PR+rKaoyveDXrA5m0pId4KlwGGIOE+T/vOmIb2hbTs9CvSFsNw5OJ8yHKWPY
flw31QVvzpO7I9zBbjNXww1TmFRBsZfip2+yIAhCRkEYt9B+9ZwixhwxMGEA
tgqgnAtN4plralstvpOTbdYpvAAE5O2ObKNixDMQeal8lKsN79J2bYon6nRe
jW8lcc2M18d57h0DwMYjwM/76jLToI9HG+Qp3yDwsczvJm1zROhbfcQVsdcz
AOgFWm173gytZinYAJmajmVuMST8RcKboKi3TQdStolWueesK23Pz6chxxQO
QcxVBPlh2xHfz7a8noJ630Bsd4+fpB7InnweLSv044UOAbiDHCIcYRMnhH03
zueXjXqpYbxJl0Jgiv0jMHExRZCvs2EAmQuinLNN4jnsSlsxvmNfqiS9JvN/
EJ4uB+Qd2UbBiGdNLZefz/21vJNjUJe1CR5PjMFfz3PvgampzFN+AHy8TyAd
mqdg81BpskE6+gkDnEf34T/xkd92exsU9ZbpQMr27TkY9CrEfKmZhcLvcMRa
k9/TtnKrn4B6y9junuuyRPpe6+CuBu/unUSxv70UJs6FAdgqmXIONWnt+r0C
4emqMSTq/iCFyyf/Fi/qRQb9b+e5dzl+bzPvEMC5md4B+ygW50eiqNf0JAz6
rSHmk77Ktp+mL+yghol/ubQL0KsGzEIMv7W787XkR/ShKOoVPQuDfmeI+aSv
su2n6Qs7qGHiXy7tgkmEz61NsSoNMdfS0tLS0tLS0tLS0tLS0tLS0tLS0tLS
0tLS0tLS0tLS0tLS0tLS0tLS0vpN+mrIcl9uwazZFq5jxz4EMv5KvPIjeoKR
usFk/+Da31FDV+dZ+Xv/Zvk3q68j349ZdFRXhacge48/t9lDQ/5i1jY5zm4V
Zj23cAOOzELGd+TtnR1/DK/8KmL4AzzoSVtM9jtr/2Cydp9fAtexHccL4/lQ
8G1S/L16KSxb63upQSde4UN6idoEH+//hRNVRntoyF/M2t4Bs2aO416FIzOQ
8T3M7p0df+RY3dcRwx/gQU/aYrLfWftHkrUJ/OJguZ7nEIgYZovsIMXfq5ce
kqz1zZQTKuL0T8ReYE6VhJm/6C+Xn5t472Bb3/YBmslRZr2Ciwwgj0G2MXv9
XsbxgIoeypVcraBmc02B2wExuwVu8kquZnsNjG7QAqxPYWI4D9pWTxrv5UHv
/+2N/+1d01Y5llS+vltdhk59no4CbtMowrxXkBSvNFvPIb5B/DYKN4Jjg3O1
ggzeC/BwaDzDccitrhTm2kCxv8zIWugYY3QEd0QxWAj8hBkfMNh6jMs09Kbj
gPwSn+BtGB7FkfWFaxAGNISivu1iW88VCTRkRUXkIHTT8ygobmIWg8jjcarm
TOfQBhVX3x2MY9QjjDE9EO4KYkqKuRqkZrNw5BXIuIySB7nJCsi42Gs+Vy/A
cWuZsvI+bcXaJTg4QC1/jAfNt1z87cxkH11vOUFCDuzCRzTz4OwrttjMsu/H
yCGZc6pdgn135cS4Phyjp3cU8Hn17oU75VsixXNnlXthSgNZ7BrsoNincWuj
oOLPtsWWP4Yh9ZrpZXgdsVLy4jVFHPLYceXQ2ECxv9bIv0A74MVoG8TCeZXk
7RhNCmCwNaZoHdwwLvLEs52kHRZqw43nCsko6tsutvXSLJ6GrKjoRmiC5jEq
SgYVDSGPSe3h+FGZHB2Pz693MY5DHJ8BBjej2sV5tYKavcCRVyHjN4nZDXKT
lZBxoNfUfRg4bgRJWReE6ZkDPv1jK9QuwMFBavljPGix5QKNmoN04N8mSVa2
MjhbJq0YfO1CLKUogXl504z2dI6X9TSyYwT1eF98nAD4aTnhEgRSPO2gc8mK
BJ+0bwUz+GnpGuggYnAvSoo89kwpV89U9EtW4m4SohZUsuQ1RRyy2HGYcb8D
xX6XkbVuu+DF42hFXPCertbZ43YB5u/EI6baw+sUKGbrbGu27SwNWcWE4pB2
EyoaRh7j6PWiTP3Wxh7G8YCRVRO4eSjkPRAFNZuBI29Bxnlm91Qsz01WQcah
XmO7EQYWmnAOw4wBhXwq1M6D12Fq+TM86LnlEI16YbJPv4XA2QqCIRMzbCwN
GLJqX/J6z+p8zwhCa5No4vAYLiHjsKR40sHzVGF6RHDnsue7tsNBdF+F9TpB
b0xPt68oRZoT9JwrWcGaB+IQCAlwaKyh2O8zstZOYWrkGADX0c4WdaiS+Rvw
A0pIoRabqyUU9R62NVs2m/AVFcGoaBg8fRvG2TxZzFnemX98up9xjEBLBy+Z
bAe0XEHNZrqwBRkXigW5yQBkHOo1m6tFDLUVdpBPVcDQ2fIytfwxHvTS8lUa
NQUq0d9C4OztXC2QtevQpVtUp4kh9Qr1FV5TMDNbGrHENXNIzKxermsKB2GD
T3tY8tMH3lmEADumU6Fk2Gsrcbi8urM5NGBk5IcZ+cdqB7yYpg7nhCYG5NYP
M3/xSpPHKXI0NPICG8nVIIp6Dy+VLZtN+IqKYFQ0DJ6ee5tGeKW2PGm6h3GM
u2ZONYLzapiazXZ/AzLOjxeYmwxAxqFes5RPvK1a878GfCqMVq4iBbX8IR40
0/JVGrWw5Q6Aszu2wWiaB+dqgdDdt3jzzVh/62nHCOobBkrboHUXYuCypHjs
mkM8dRDvO9mFQBBWO8iZPuyheTX7ILjBLwdMdwGuZMBrm3G4a2gocvU9Rta6
7YIXI6XkwcA0BBSEcbL8PPhxMS7HQ8+JCrqMOl7ypkrJgwbiQRBFfWeu5mjI
qorIs0UJFQ0gj4vItcYpRNt1TWajBLU8DLqLcVyTTZAoa9ua7LqLLVdQs5m0
uQEZ55ndMDcZgowDvWbwygQ4bkZpdb022Tk4K3wqEMN5ODhMLX+IB822fI1G
LUwmIXB2jemtQdXWBI1tSXsgTCz9fWBbp0t+7fsKZTY+jdyP/66xBd3gUtZj
DMYoOMm8miHFDwSTih4lNAWm9Bqn9CZ2DXQQ4dXal6JuqcEteQ9kNEda1uOs
3jwcGLqrULLsta043DU0wFzd3mVkrf3qcpQJrWC+IcJg63GR58/E6oOD/4hm
udI5HucrQRT1HrY11yoO0AxXhJnF9kSrYlnYIvK4ThlKs+0LTzL3M47Hsi/0
wehYsGcDdxmYms0ilTcg4zyzG+Qmw5BxGfTM4pWHJnSWik9JrfApV7sIB4eo
5Y/xoLmWq2nUXNjgFsjg7MVEjh96JjOvnmpfYul/n1+rOKAnYjn/nPAB9vR1
fsUCt97LSCrnSPFoRMyumbsvdg10UJvNb+a4pzE4oVxtmnPtZHoslQx5bTsO
bzuGBohiv77ayFprUjF/JWL1MN6XASaxAkV9nzgasqIifB2ERZaRx+gT1cvh
dzGOewhkLFcO1rQPMs4xu0Fu8hpknKlZwCuDHGiZQi4Sw7eu36d13vReGvV8
Lf+69ZZH2FgawIBBepA9jQuULMaR4nd2EHLQoASaz08ccGivlyx4bWcc3u4c
GkyrX21kLa3P1beAjP9OfT/2dAfuH+7SV8Xh9zOy1q/Vd4CM/059P/Y0enPb
CB85ceXL4vD7GVnrl0tDxrXeQToOtbS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0
tLS0tLS0tLS0tLS0tLS0tD5dr2Kt/nptY9Mn/QgIuBLCPvXuqyntn6u+2uv9
L1NXF3n57Jl6Xx9476ghv4R+EEwniaEffD/I5ZP4nhFP6Jaa8LVItj6L/HOm
OKyT6CNbeB9fewc2HesNIeB9dg78KGX/XK1KolNwWQHnKrDdS+++Bdf7ZRMV
7P3jtve/UohBfDg900Q28F6inzJR7C9H27Rsa/pLU8u2TdM6S9yLp8QSuiV9
BO75HqHjjg+nNcL1h7bwPr72Dmw6ue79IODotEx0NubSphqjEcyVTKvAdi+9
+wZc79dB4Xd7/yu1gmzeKTbwXqAX2v9NhM/Mt4TD2LFYNvGwAjMexI/Ud7OB
PenuUdzz8CxLnUo6HZ1Wv9FCgJC+iwct9gxitYNA6m1s+ntDwDuCE3aXY/Mj
MjtgM61gHQqYGJR920tpX/mlKtQ4Z+5geCurBKHw8FeZD6HwJkfq4aLACFGV
ubPHm12GYl5sPOYABoJLwevHX6yT2zfbrArCvmN2xWD7f2d14jaFQK8GUdr4
mvgyn3WcKHDhM6EbEaijCUvnXMrrY7hnoZAnez7naoJZTwkcAXUToVhWWzgT
0nfwoP/UxIE3F4QPEJb42rdbQyBQ2HbpdL7NJjb9O0DAO8T1mpDut4nJezjY
NNNCfqeACZ/SV+3jhfR87t0OSrvSRDcI7U1iIInp8ePeuaizkDTLPsXdVLt9
ikKPmmUO+4tnOhPTsL54KFokJD3oYmGsKcObMCD8YEGWT3uVYNiIjlYYeU+X
wZifNbQ5PdDdsB3GxUurDPuc001s0tkzPdrbjss6oQnECPFW5BR488VAhlGh
1f3LhRZsuGgjF7L/22oHhZlcJ+ZqgV6tQGljuJwb5mV2Qj8eZ4AyhwtfCN0l
OiHXT5qmQkCPtHkE9/x//61QyHPdF/B8Bwz0LMgoRtw6sIU8K3wPD7qvLwbi
dBdVmaD4scJeYrUTXpI9Doa6xGfnI/7dHmz620LABTu7AeJhxmjUopWp53t0
Xr3ud8NNijIln+NkCHBnFJT2FROBaO/JXE6c52eagKwoyzGI6nDBoUPCfpyx
FFVODvDHn3eBQU13I1wkw+8kJD3oYm6sXcUxwg5SkrN8HlkOlgk4emNwqbsM
xjxjW3zDs8+jbXFnx3K7KW5NL8yLjFiJ7KzO1svzmN487bGRmExFMUALAg/M
MLdVtLo3jjF8j0ABINn/nbWPwqzK1Z6wxQyhtP0J6cbiPnlc+IzowjlttPyY
M+Yy78c9A4U80X0hV0+8QgakKLcQJKTv4kH317oqQteYDgpm+dqEM+U3mGPd
N5fxH1m3A5v+xhBwwc5WkIz3fCuqh2os/FjkIUs5V/h92X1Cxx7jFA2gGEEI
+IqJ1tDeJpl2DxXGV5E7AV5KnxbE58Q0IV5Gm4fcZtqybctB4UEXC6R4dXiD
yPIrWCbg6HUjr3QZjPml2IKzbUk7ThpwnO406NkEwwml1kMbJgfKDcSkSATz
Ze+/YIaZBKHVKSpsQHdf59yL9v8RAnI194xgE6XNWFjChTPZ4FrGFCVkuknd
8V/ch3uGCnlCYHbi2iy3kBUipO/hQU+oLMOyCYGx42un1Fe+7LzbxqZ/Ewg4
odOW1/w0ZqKTY1hh1Vc0V6/6fdmOnvdCwVwNQMBXTKRAe/MxwNwZGSvxQ+Pq
0+k0h99druHNC7lYGmuq8IaR5X8Ew0Z29C4jQ12GY34SwV/OxbIIaWNpwBWt
xizOd4Ile9wMoT2qDLOFVmdu1jDL9R21i2N+28zV2yht6SkPgwuXzNURCAVL
Pt2Pe4YKeaL7u3P10kKZkL7Ng0a2OlhkTlQvz1/YAY5fRcN7I2zzNrHp7wwB
Z6sJ6OQcc2yxDYeZcr7q94LOBPvIUc+rQQj4iokUaO89+GZSO/XINTUoCB57
yrkMvP35WzboYvjdCSC8YWQ5HDayo3cNLqjLipifDclNd6e+9KQB05faI6Wm
KnP13IzNXL0Dra6y/1trJ8dcfrbI06tVKG1mhTJZEsCFTzuiQ5PYphuXTd+3
Z3fK1XfinsFCqO6HUO/K1WwLIVb4Hh40Brs7eXOtc7xCofNqjtWO+XcHJ0ia
63hZHETZsAeb/sYQcMHO5BaPTGFFAzcrXvH7wfEvo+kTHHjupWIDb4vSvmIi
GO29L1dbeGO8qKsc7+maJI9hF9tjZJbk8bRJcwULhQddzI6jtfDuYGQ5WCbg
6D0sdbDLYMzPahNkPNsv27aIfbJmvE73R9uP66YicUUmMWxn5VQMzavFDLMD
rb480RDsvy9W31t94TDbdzeGIk0EorTZa2ZuMoALn6nHzGPo8eLL9Oj9Ptwz
WMjUi/v5yGTSKGKvOVKz2EKJFb6DB91Xlxk1fTza87NyntV+K87HuZApkLax
6d8BAo73q2mADcMgunXF7+7M0T7RkbUE3ialXW0iEO3Nx0BuzX+UQTcH0M9F
yG46GMH0+G/swlSF5Y9Woi7moPCgi7mxthre6J45/y3EhCxXhA3g6O3Bpegy
FPOL6sSfG4z2JKbdpzxaNk+O03YZ21n2BT/6fmbPtQfMMDvQ6viLtBmi/Wdj
/mCWOojSXrlW9f4zxHK+G/esuuLD+MhQCyfW9G4etALrzLHaKf1ZeHN0G9L9
rSHgbLOgLqx0bQ+lfaX8B4DsaM6GEwhghKEbF1bAFqOAOIdcvNFQ9rc9hCwH
y5QcfV+cyGWtmhb4HdCA1+iuXoj2x9Is9S/UV/GRNZec6JfwqZf1tda31S+J
1bfVl/GRNZcc65fwqcvIMcj7YFrfVr8kVrVgaR60lpaWlpaWlpaWlpaWlpaW
lpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlqShq/Os/CV/vKkCN/8UIuc9
2sSOf572A99/rJ4LwG/ATP/R6vNL4Dq243hhPJ1X8QGQ7m9Bl36VYHAze8bs
Yxb+VLz7I5BxWZvY8c/TXuD7ukazhAFRGF2SrPk+If0sDfw7MNN/rvoYn/xo
uZ7nEGYQJtZ9AKT7G9ClXycY3Myg2x+z8Ofi3R+BjAOlbGHHP0+vQX4Ts5gI
J0RPt7PSved1f7GepYF/B2b6j1WXmRRyhNSmUYRplY9ixBXsYUxCHibeByQF
17hfYX0v9cEFMhevgNaXa1bp08oSmE/Zrs8nz6tYzLsx6FwJ4LdWGs217m7C
+y7IOGwZ9Jf1E3VmQQNwIHhAA3TBaxDkKuD7I2bhIAsNOn+VR96LhHqw2fBI
Ys8GVEftFun7jsDGF0gbVCqbS3wQVSNBV961AQgVDA/2dZD6zxEFZ3AM4scw
4jcYGN3NJxvbljjMCWX4GIYLghnf8VdKntHStz2U8F6JNj6dz6RSwwkrcgge
PuRXWh2qS1hqAXDY+OR525/Y3hS1PKHbd2LQhWL/TviWCjUuMcpBnvWe4FiF
jEOWwd9KQ286rsov6SnxRhD5k5MpSGiBqkOkeFLU8wjymxr4/rhZWHjZ/E8p
KkBg961fzse2bMs4IA8KyPK+yf2pa6YXEQrGJul7T2AvNHAQ8I1Lmc+XHgfV
aDCHOb6ezdVgI5WuBHrdAoT3mzKugMF+2wCp/zj1eAdrjFY/LafT0R/AiJct
CIwmVGgvSoo89jCygsvVE2X4xCOYoZJFtPQeSviwijY+nbNsOozdDZMcj2iW
74m1VgKtBSSGk5PnHR61PFEqdmHQpWL/XviWEjUuMMoBnvU+rULGQctM+dwN
4yJPPNtJEDMHAMHfAKi6eMGLEOQw8P1Jsyzz6ja1CJOOj4o/wcBuAtPx8qYt
Y0xICdO255Hl3a0a8719ysoqx9d4mLC1SfreE9gLDRwEfFME2CFIq7ZKHDzU
y5ZdRC0hBzZS4Uqw1xDhXTXiwMG+DlL/merSaAKYGC4BYdyPEYeA0Tyzm67f
2VwNIpg7oGQFWnofJRxEG9MdRkQSJOyVGwZzG76Qq5UlzLWoieESapkJ9W0M
OlQs+61VfC3PKJcY2fu0BhnfYxlaCiFiSyB4Ho8okeJfgyBvFcD3p8yCEUem
jfaryRTWwwmJ7bsK2I0SlBmQLcfamZB/HLJ8rqZtypzcpGYi4Rrpe09gC4R3
GfCdo68FCx3SPvMMBomRyjcSdiXcawXhnYqLK3Cwr4PUf7T6iizZlpntPRhx
EBhNqdDUA8AzJhjB3Aklg2jpXZTwbbQxRwzn17ZbJUy1rBPDb/wA2Y9BB4tV
UvDEXL0wykFG9j6tQcZXLBPw9xdVm2FQ73zBaxDkf1AA358zi4U3ZS7n8/ky
LnB6tvCJJqwAdpNH+U5SjqMNWQ9PtiVkeUHJYpaNkYYSchokfe8JbCkUaZ3z
rbDFPMRTXNQFostZIY+kZ9wHNlLha7DXCsI7GFfQYF8Hqf9E9Q3zylGDZiFo
CnQ3RhwERhMq9PJkSpGrRQQzULKMlt5DCd+BNt7I1XvgyOvE8Nt6rlZj0MFi
2W/tQI3fbgpG9j6tQcZhy+Am2RE3wB/M1a9BkP9BAXx/2iwCwP0mxJ4S2I3v
MjhqLeec0Q7wuRpNEceek39G05R4k/S9J7AVFzMFtjHKkqh9phem0tObOeTg
Rqp8DfUaJrzDcQUN9nWQ+s9TjZdqbnAp67rKY/RUgsyr78SI32BgNFkt2pei
bikV2pL3QGQEM1SyiJbeQwnfgTbezNXbcOR1YjhnKOaLOzDoQLHct7ZR40gg
z3rRo5Bx2DJ07X/w42JcHIeeExXX1VwtQdWZydhLEOQq4PuTZpHWX2LsKYDd
+H0/K6inqCWvOrDRQtKg4V3ark3xDJOZV6+RvvcENhiKN/bZAQowJxvjkI4q
/lUMnAocxD6GG6lwJdxrkPCuGHHgYF8FqX9fIrlS1/nROTaXl00PdO/DiN8U
wOg2c6dHuu5pNB6Uq00RwSyVDKCl91DCd6CN0Wtp0zZXN66XpTG4DUdG31QT
w7nu3IdBhyjb/Lc2UeNEEM96dsHDkHHIMriF/uysgzMOLxUIHoaqsyZ6BYL8
pga+P2MWYGtUigoQ2I0TFCs7u/LIcpYgb3knxzBprt4gfe8JbDgUGcA3WY+w
Osas2Xv81PYwTrjBRqpcCfZaQXgH4woa7LdVkPpPJZJj2LGE9L0bIz5dJJCL
ByWded7eHCAEs3AtX/1uSvh9aGNQ+0p4gAS9hkFXF8t9awfKnHxJych+Btys
6vIDHHCVXoIgV1rpY8wiNHApnmyqjzkFR+2YalR/RznsdOuLhZdFzrm7kVGF
d4lPwpP6fjbv3kau9FpBeBd8uDrYlQGiieSvlLCZcI80Jfwl0uBmUB9lli4f
05R7zse7Q981MZ5BXt7oTTP8109WUF1R+6oUv9bIP314qNRne/3AYNeB/WKh
NySN8LHTCTQl/BXS4GZQH2aWgd14Qe+HZ7tf6/4UdVWy7GChJ1nJK+alT/f6
/sGuA/vtpCnhWt9PJGrfN5Pg9r1mC0ss9Zle68GupaWlpaWlpaWlpaWlpaWl
paWlpaWlpaWlpaWlpaWlpaWlpaWlpaX1k/UiIDLMyNa05UXr4CQVb10h7bW7
9QzRfujqPCvf+a+kn6Oia71EfRb554/7o6oXAZFhRvavoy2Lzuqb1Pcv6BQu
lpwOCeatq6S9BqlJg+P5X+WX0CdscyT0g+8HeTtsE+3VUiDg0Q0gDn3XGeUF
l734zZcIIQ+n/PwsFR3pg/PMrxA6D/kgHtvyOr0IiAwzsn8dbVl0Fj7ZEoNO
GHI6KJi3rpL2GqD+jA7A+9eXo21aE9gcn8Bvmta56jeJ9isCDTU0CTmeznY9
z8U/updPm92iW8+RRtqzVHSkD84zv0KKQ3qRHkA/S5JgQOu4au6rTPWqUf89
aMu7u7wl0VmwWaY62So3eeuctNduUpcxG30m3BGcgcWQCPZbmKsKt2aoQslQ
mGJwMM7TYc1NEl7YbZIVtLn0sYIAztlSsNWYqw1f4iysV3NTEOqRNvKMoicv
976ihJeN0A8VbEMZzdyVkXFwyTLomofGwSbAt6G+mAdHyUXiGRYCrrqM3IPl
z+uizLdN94LcI2GLN0f9u9KW+zSgeHfTDapndyRFUsmCtpzI6YredTBvXSXt
NclrGKHlLvPjTtzcWCfa3yZA+QwxH4uIfVqLjQkSnKHaxJgO9pfDQMa+48Lj
iy/5V+6dyGGXbdWdqVMMfG5euVDR+dpniLyaUL+0GcgzfRMH09Hf0znk93i/
68ekZHgTcbRwDZOAiUHvgyWAxvwS9VXsOuMKapHrBTV3AwFs2EFo5qFB0B8y
xBJC48DcpRLd/j3lPhQzMGVcNWFD0H2wobQJmwnCFm+O+vekLZMGhONHZXJ0
vPV1/05njfkgzdIkSdI0i9E58BaP/1AQtEHeuvbabq+hwt2E7YWYq1eJ9rcJ
UD5DzAmN3YuSIo89U8zVnRpcBWLfSeGGy9cOEsB5DvsA2arJ0U3NcIMkTfK6
W6joSog8TKgXQlfIM+M0z0CE+qIqE0Qqwai1e7zPsHK4uIK8rygBNOaXqK8u
jmU7jGznxBFwABuq0MztCRGTxx8ajzBe7PNo7wgzlW99W5UVL3xSIYNAhXDV
qMwDRoviY8ZNRJEAYd/7VtPvRlsmV3pRtuethz3Owqy0cbpDRaYDPFZPRdAG
eevaazu9dh1/5aXM/U3O1VtEew5izoPgBwlRyoKPafoaR9+4alBg38HaYQI4
xKAXOfUYiW5OeyACFV2CyF8VLmOl3gPpr3VVhK5Bjqq+x/srCGm5R1AJCmO+
q2QbqtDMZN4S1PVlvCcXxXnsZXlFAJ1TdiUPsnkZXKwqcNUVBlSMARxjUMWg
wBZvjvp3pS0P+flIU6p33v/O3E5nLRjijd7BlFXttb1euybIMleuF1CuXuPY
crcSSmOn/5INRebVCdlm7Oq8wIwUM+gUHgFrh3vHcdgVtuIjTcjVEkReidpc
CV18JcXAGRbesTDVAGVFVAsXT4kd7BFUgsKYX6KuCBGoePw/8h/iA8/7TvQS
CdasRDNj9LB59KyDE5N7k+d7dF5H6GCsyNOMOTBUuOpraiDE6sWecD8gtnht
1H8D2vJQpRFmXKgf1ux3FvhscaN3ikyivbbPawg+Irzj8WSuJjT2ybC9NK8e
VyxocX5cdl0qwl5UeASsHe4dn0sVtuLSgkDalSDyu3M1H/8FJumSO2A9kSXv
8T7DoLzRd0HHixU9gkpQhfdXqG+y6UVQqiCMW3kL1AnGG3eWjf9lRd0p0Mw3
MjM5TPuK9KZtR2sviyxAZBWuerjQByxuRRoGYYvJNCMWeEBvT1suItcaJ3Jt
1zWZjUzFPNGT+Ms7nSXnap5tvU3QXnl7RHsN8tr/EzvSfRZ4trhBtOch5mQ7
y74UdUtp7CJFlGyAW16YV1VVpGggohU67BFF7RABvBNytZpTbxyLpq6ajvEI
DJHfmauFPIN95+TNtc7x8mptXg17n+wOHS/52BjC5sa5GuwRWIIqvEmMvxsh
nW6BziLhB6KZx9bjpyAmWZq1CZ4WnVffKGCAyCpcNbk1sBtoALa4TfA3BVrx
u9OW65Sxru1zDwof4S+LZG2Qbb1J0JYB6Npra17r0dwsLMU7jsPs3N52EO0F
iPmtzdzpXQX3NDZS9siQR0cGtGWFGTY+5BGVfwGniBx2mFPfFRF9feSUcR6B
IPJKQv0iIM/01WXqhnk82kyu3ut9tvHO8Tg7GuwRXIIivOfavwchXUAzP66e
ZRWv4qql6pkL0XodeEv0/WnLmN0Ovd/6Ifzl3QTtzYK016jXxtrK6mMmV4OK
rs6I7FNJeXyvR3ZdC+PoERUeJny9jl/f70oya1E92rCVixAbuDouVAbShPQv
1lfQlhWF/EKC9qN6D69pfY2ej+r7S9CE9DfQF9CWgTJ+K0H7Ub2F17S+SM9H
9d0laEL62+hn05bfnaD9qH6217TW9XxU/9RxoaWlpaWlpaWlpaWlpaWlpaWl
paWlpaWlpaWlpaWlpaWlpaWlpaWl9X6CidVvqu/A69G6Q3dS2m/oPVsdAq/T
/fYXdRec66erz84Yukzk+1H67EmArHmVIGZWGsr8bcRESxhdkqx57zMR7qO0
U5ThdELgi7WYLgyjOMk/+48jr9UlOCFOhYvOn3ugAHaw7NSd9pfEHzD76/M2
PhIQneptW6NM043WzlLe1lC7zKnjm8dsaijztxKJFhOxaSix20qfJiV8nO6j
tCOcout8FFxvMp3rIqbfgVKuPkdDHRNvOd6RDDJ/9ThFUOxg2ak77S+Jpb3z
ieVXihx9DObne3nl+L43FPjE+ImXiXN1gY+Ehf6EU0OZvxbKPIAH/anFnwzf
oKNN+f6yNcPxo+ode7GKYD6WyJS+ZiZSWjmdVL/SJBUsfa5EUf69G3uc6cjJ
seHmIg7q5GqDQZFRZsb07N0hDUNmkCmH+bBnsHANFIt6IFerxpyQWH6l9vLK
0fnbIBuawx//5/Z/Mp+CgiDmhJIWRD452VYEGWsos1DUJ0KZ2zwyp1Zdyp3T
FaGD0z9Fa4PxA7dNoHiDBHNyzflIPrfjsk5oDBihtOM0tPnRolU75mE6uZpp
kumm5Oydrpzo4odjhDbqxorI4dU3EG6Ou+lfLrQhhpu3+5OmcJu7HMiGW1+O
Do1o6uzHmMSYvxs+pJqGzVi9aRzQ0JMavEtklEHsIdBN0CiTBksZWU6QkFOP
8EISLArI1Yr+wkN7pr2jbx0mOfevCX6G8NLMi1tERWiaFu2igbxyApEE2NAs
/vhv/8X/cUFp2fYvaZqNgbwOMtZQ5i+DMg8lOqbZT5qmOp9cP925HOcTTpta
BEDGW/tPcPwoQOo8xRskmJNrxtSd5zHNGbafFSnKmcKR7xRRZJ/TPMOhSJCg
hN9kjzfyusQcA+TQFGWasT3NWJdzRLdLQlFB8QjCzadueqM7cWq6B29NACij
TYosOWM0hy8Azck1ZIg1mK4UpFVbJQ7uRdl2coN3VawYZYphDo8yabCQALai
JMnGlimLknK1or/w0J4vHq4Zn1h+pQQug5F1Kl65gg0t4I8xFjPg90BUIGMN
ZeaL+kQoM85F49Ao2/v2QHC0mDbaryabrl7RCTGgjh8YpM5QvOdqeII563e0
rXE4kXkbTmgW+zQa33AP0cRqKWmUktuE32AT9GhOO8b5gNPheLtcsDxzVINw
c9LNI6Ef3QZ0F3fOu81HB5qJhE1nHvO25x26xE8+ZiYjWHiR9nm4AQ3eVTEz
yhip3KQArwODZbbzelEijxLs7ybtXUgsv1L41nZKB/KYF20VqXjlCja0gD/m
k8k6cE1DmfmiPhXKfC1juiFhukm9d46GMqt1PF/O5/MlzafHDJy1VfGzDVK/
KQjm7DXszz274sBq09OSY5eLu0g0gY0dXYcu3S45YSDdUjgEN5881U2F0ynE
XtOxD4aGBr0i4VwGRe5q8Yb2KS7qAgGtrBDf46QG76qYGWXsxwo3KWC+wGCZ
8/+uoqjWcvUaQVgx4n6V5PSi4pXDbGjRhnyS3MhvGsrMF/X5UOaOkFD2wuOA
DkrWUPLuN0HqKoK5KlfLbxkx80D2YtwkvPsEqG8xDQRlM6ZwAG4uOP3OB2fi
Q3xEFxlTfcfd5sbZNB2MbYwn4Yhg74Upn+6WBu/SNRVG2Tgx6tVuWsvV8mDB
DdpT1GQGuL97c/VTr9R+dwFTQRWvHGRDC/hjuuIO06apr8M2yFhDmb8Eyjw0
iW26oyv7vj27fK5ewzQrNnl4ayviZxukflMQzNlr5EHNPWPDz9HGusu2LWKf
LGSuFKo4eiZprqMj4iDKhlsb2NbpMpqyr9DSbM7V5CkMCDeXczU/r94y3cGN
yqoqi+zso97ZaGOqxj8FVVsTW1FoO7rpONkY0rR+tL8nN3hf1XSU2adzUddl
hnaex6yrGuYKtL1qsKx4nGxwHfktG7i/m7R3IbHs6fWPk4jAJgJ55TAbWsQT
D+n8MDfvdoCMNZT5K6DMy5szyObce5JrmGY4WmRrgPGzCVJH10AEc/Ya9jU8
bsUxqU78uV9oc8iiX2RRTXh0X2PfmT9xw3zgKoLg5nw30cVWyFlp1XRcbBjW
Kcp6ocuOH3om6TJZzbE6xv+X3OB9VaPyMsYjxngvw68cgm5SjjLVYFF7nPx9
mT0tUUUXM/3dpL0LiWVfr3+NQF65gg0tqL+ClOqNb2go8ydDmQdFB1+DaRbi
ZzdIfS/BfLNq4PNe5IMPsGtW4eZresx0vdhlPIl1zt2N1I83z8nfWCkavKtq
/F1xYILDfK2h6hEBFdVBQHapv3slJxaNFNf6An0FlFmWBqnfHoWbv850XYj3
i6orMlaV4hcOo7WHib8Trv07e631BvoCKDNQhAap3x6Em7/QdF2VOMzOoBsk
61PH3wnX/p291nob/Wwo8zu3TdJXw81x/d/llEotLS0tLS0tLS0tLS0tLS0t
LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0trcf1POD4I/WpMOufRfyETffB7t7j
r77K8/p+Hu1HeOdneVzrc/Uk41jJSFMKAhy/CSP7Q2HWcm27SM1dGZnW9DfO
srOG+hzMljsn2XTUPuGq50uS7Js0CNMeI5OsUypWs6mhOQd+lFSKX3OmY/vy
LM9abshS+D5/4XPzjtDxI2vivfMaPeBxyextfvaxH1k12dmfzoOi3/KDrB0e
9LXW++l5xjE5NPiuL0Fn/74JI/tDYdaSdpGaEWjDwQdQw87CR0eiU6Edh9Ba
DnaESxG56l1+ojnzmhoAg2xDXU7ITS58FjZrOr4vz/KsBXGF7/PXwmi4r6LF
O6/SnR6/QWZH1JiDiDkQP8QHsKDTsR7ytdb76SHGMU/fHsqAQo6Ei9QAcVWu
fpKRjf8ot5c+2kZXb7KhAW71OkhbrXtJzfiAGjJOFc7CJ2DPeKMKH+mP4Qvi
cdMYcUUPkEyPBnsY6R4lHj2iQh74opH5vhB390qbcT6CPMs7cQtpDRhYPm8c
doMSXL58674DJNVV3fZ4HEk2O3jvEz9kuvyAr7XeTnsYxxP3GaRvl2fmXFwn
6rYB4kjKXP0wI/vWpaE3feyT280edPUazFrJrYYY07NeTGq+MqwQhbP4SeNQ
IQwBPm50LVf3+LK42X27wThdN4oRFXkCNgkUcmo6qS/4zHnbP4l9R549n8nF
hhNW5EQ7ZNbjfDcQnSgVzsLH2/w8BZt1Zo9f49FRMqT+pgCXU+/gb8kB9uEe
V5j93lx9t6+13k8qxjHIfQbp211TXvDPp3OS5tWwAyB+2zOvvo+Rfcvw0fBu
GBd54tlO0g470dVrMGsFtxpkTLM2fSWpuSNz5m7FWcK8uo5Rl2JUxFquJknA
Oas2n0VhVhpCGZaoI3R/WKCQU9NJfSFcEkTx5vtOzHs6Z9l0BJ8bJnkamgdK
NACcKBc++YuwcsbGZEV+PjlHdu+CnWRCkHoVuHz+lhxgn+Bxtdnvy9X3+lrr
DbXGOBa5zyr6NtkDsQoSbLsA4nCufpyRDVS6E129BrNWcashxjRb8ytJzSws
SeEs2k52v3qiGom5umdzNT4k2dj74AwbCrefzNuDnPiRo5AzbFmuL6q+I/PS
ZxJoa50ep4+R2bhhcBxChU+wcgmJPpuI2nkNUg+Ay9lvSVEtFc7b/HmPq81+
Z66+z9da7ygV4xjkPquAg8DnGwBxxbz6YUY2mViWbMzvRVevwawV3GqYMT3r
paRmLlfDzppeLfCCy2i6S1LUcwkiyrYe09kCPFLAE0H1pcNb08SsVcGPKmLy
at87qTHzzyongoXje/1R8cIDn3VlSP0quPx6AwIMKpzvyPMe32n2xQ4mm6sL
pqf3+FrrPbXCOJa4zxu5uhc/v91UAPEdeyCz9jCy8bKRB2fsRVfLn2wnnBXG
9O3FpGZuLQM7S9wDEUw6rgXmaX/iHRicK55rnRRzRV6ELRtlVV1VdVPHaFvZ
qYatXA09C4P7DudqhRPhwjsSG/CrQ/NXFJD6DXA5EGCsmT/K4+tmF8xSYmPN
yy789sgc4Xf4WuttpWAcy9xnda7GW2pRXtV1O+wCiIOA42cY2WT9e/Djom3K
0HOi4roPXb0Os4a51RBjmtVLSc1kHji9GAw6SwFVRyJwUse/lFWZ4AWOPa8C
yEOrC7NnoKRCD7HLJnm6Hh9r5CnkTB/5vmz3Hc7VIH9cWXiboovHlVnVNvn5
5LJbFhii6iCeLAyp3wKXAwH28R5fMTvau07yPM/ybFSBRxJ+N2/sf1pWRYof
yJrTd+/wtdY7C2YcS9xnNci7r+jj+4Nd/nkXQBwCHD/FyB7b4C/QI2ccc1AX
ZHT1Ksxawa2GGNPcLukrSc1kbrws7SFn4dGteIG2i0/LPoJ1vMx2xO8GGAmb
clRUaDzS+VllfcRPWgUKOfNPri87+o4mfpP3uzHRzHdtOQ7Vhc8bbtgpZ3aN
1uPniIe0gyH12+ByKMA+1uMrZg/5rZEpnzdpsLxaYrrzA8s7fK31/oIZxxL3
Wf19hDBWXAniskHA8V4p4MsAeXwPulrNhoakZkxLLdlZIvdFyQttckQ3QanB
d5DiSWv4HqL9EOGp6Kup0Pfj7BWC4lBZuBLM3bOxIYTKTnD5Ctr+Yz1+hwgH
nivwE3ytpfV+upsx/bTaE9q1lXbyn9DQoC33C78J9Zup0I+Byz9Mr/S49rXW
r9W9jOnnNdSx651fWEt1PnqRmAp+NRX6IXD5BzbndR7Xvtb65dKM6R+orwaX
a2lpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaX1v
dU2eFeCL5s8Bu2Hy+HtBwD+q7x+i92uR1l3qM8RI5pjIVRKdgssbA38wnju7
n7euljCymjTgT/7ZW8jDw2HluxPSWuw128i+KSL/6Ni2653inB4kdT/A+pFg
wLzdQ9bRbix/ScICu+8n3cPk8Y8Ai09Ff1Tf30PktDRNyP3OIvRw9gyuGp/j
Zmbv61URz/2sRJx0f0YHpN19xEd+Msbk8lgT1N+dkdZCr5dGdkVET4bzPBv/
nbQd4MvuBlg/EgwSDWE6NZcBdj9AuofJ4x8BFqf6qL6/ia55ZNte+sYzMK0t
4ZOImLNtKbSOP2SsV+PMl2s28dPs508tx6CTrnm0+mYL+It4nPSAmAhn5qyb
nbPCMd8avjQb34c7h7/LIa35Xi+NJEnGmjiMhKVCD5m/E2C9KxjE7zD5SkG0
hz+H2PHDQglXH8otlQ64/v4I+6i+c80EP+63I03+GBiSUqRBFhaKlfZv9oWr
1lcIkbMMfKoYCcmMHuNr0xC9FidKhjb8+CH89Ewb54jk/+X/9N8a9nxa9VAf
TcNPYaYH0OYpa4Fo9Rte/tunKPQogJwipEHetIST7tEAdOmIXbp/8EKyQO4v
njmDy+uLh+jtt+5MT/4xxqvdc9lXZ8s6niN69vJ8cPSYAQzDozCovhjbc67+
nfBdpqcs0prL1XMjh/oiHPRHPiEo7TsB1qvBoKB1z/lKJtoTYLf4+Q1G27d5
ZE4XXcorm6uHOh7vP965ujFgcZXrb/1yPLWFyJ1zm7+g7zdVKHJjwULTBCDS
iFkkMrs8JG99GtATrU03qBDRoJyPLT9GGPNYnU3DRRXhqv3LhY5Zw83pMdfD
fDK8aVmmcXBeerSj1tNCGcANEJg0RpkS7QZ4vkenE2PI4QycVXWGo/Fc93vw
0x1IG+eJ5P8KsS0cckgv5g3dk1KmrAWi1W8TQtr0oqLKSQPQmZAgb1rCSef+
aBHMySLdPziXrEhwGFuod11gLJhRdDE+sL3JEaXFcIMkTfK6ow0z3DgvU/Jd
HPlkdGc8W0f4LtNRFmnN5eq5kRS6yk0/r0sL7wNYrwaDgtY95yuZaE+uFz8H
0fa4nZafNE2FiC5pM/Gtenoqvh1eb1wbFK4nOF0vb9oyxgihMG13nSf3IX1f
CUV2LAxwpEFkdmhIElOE40dlcnS8sdoUjcvRCE0e+84R3cUwwh4H3lS1F6UF
nlCRoGowJTpIq7ZKHNyCsn3fbdBfKRR4VpCMN3grqodqdPqxyEMagRjOdRnz
8zCQM3VRKt6Jn96kjePdVEIJR2ehq9iIijYzuRpAq3NsKVKvyLpiUh+Hk76O
3fRw70j3580QtJ8w3lx6LmcyTD3UfXPax+By8u02w5gUHDTuu0s/OaQ1Wy/T
SO4aeiWixLoX+vMdAOu1YFBZT9oHWIj2y8SY/ZyKR9tjkKvhhmXL7YEEWR7g
bNLcxDIVrkd3UjMgq4zakWiGn993VSiyY0ERaQCZHRySJFd7UTa9NYPp5+gu
tmzkscBHaxp345UIl+Oce3T3H0dyQK5HbZbYBFpfLULOKq/5aRwqJ8ewwqqv
aIjW8bKyI7Jxrt7ET6/QxlnEOcpgVjTgMeXF+9/rgAeLNEBm5gXaSSA3CzhX
s59fkzEDkGkq6f78sInOYDuO4ctUxOVwIYWWyCJBJzV4yTAQa1KZq5lGQnDz
9qTYOdllWEUw7MlXu0j3CrT9tYzp1oXpJuPios8Z9lg48TsVZTJ3vRiR4pyk
rLLIpQu6L+37WihOY0EVaTKZHR6StyE/H4nxLO+MYqGvQ5dMn43Thduu4ccv
nvbjWUSLSaanuKiLC4Jp3P9sXeuDRQKvoHxPPFEZJrdecR6YHlpN2omflmnj
0tMiTDk3Q7Spa608lFG0eTtX0yLxBB7t6Cp40+zAQc/yppGFu3+Y7yF4A9Mu
ejyCnMsyA2Fz9ZTDScOmmWSP9iWXebVFp/D4tbQlV0sMd27qyPSabeTtmqGt
J2ZEkw0lj76EcBfAei0YVNYD8pVEtGc/V6HtaQvIs49xIkpztZtkKHXYZO90
O1ejJwiUR24597zY+VF9h0ORHwuqSJPJ7PCQpBqqNDIPTCD1bYx4juhWrsDH
MwHcInyMiQxnemGqtz/eT8vmG9oCRbNclrmMtwqtU163bVNEQYSJz3vw0xBt
vBNzNZpmkAccXiy2a42zvCdXoyV1kBR1lWP6qInDG+ZNMzjp6vyXbKjj7qO9
waZIfDxHSamhDnZcNiV5sEWfRpGd0mPR1FVD96sd/1LVNQGIu5dqavDheMmb
KiXPNBdM9vTdpaMcxHzu9RA7XGLPA7yhi2DlVR5jOuo8wO8DWK8Gg8J6ZGIf
Y8KsimjPfv5nCG0/NIltuqNJ+7494/2irlv6XuJHcMITB4Xr8VsxVlBPPHIe
rPkFfYdDURgLikgDyOzQkCwi1/Kiqu26JrPRveBfBLZ1uuTXvq/QPJzP1Z2c
q/EsArXfycZiKcid3wLR3POvF96mow98h4E86WN45V0VL0tRw0HvZ+7DTwO0
cYlIfqMY0EMAUEhXOMsL8VyFVi/CpdVopNBZHMybZnHS/+nhEJZLPHbVZS7I
dKN2+tCaFue+78xvDnRFRB/Pn7Lpyde0UD3NQb6A3Z3jcX7/mf2u0NNpFTz1
Gr+txzYSvQYQLtY2HX9e998JsN4IBth6bYLvtz55OQMm2rOfDxDannkLYqzu
UnaTN0kzW3R7tCIWLK5yfe7zPPKDvTx4/Yq+w6EojQUw0kAyuzwk6zS05k9s
vx6usb+Azt0wH9i+8FWjW4mF3uoc6jNvt8ORfT9cc8+/hzAZ+Xr/HVVJlF5U
omWeC/7NwDOcZTRbwO8Vyw1Q8aYxGvzfVaW8vzkA8OqhGycfgEVQ6d08NIoe
f1l8iXUYJ30KCrt4KQQx76BGTlAxvoCXA6xB6yHM+PK2r4poz30O8sAhQ9/b
PjwbH/MX5pGPac1YFiZIn9/3lVCUpDAAMI7kIYkDjX3nGsPfd78rjVd2zrm7
EZB75YrTBs09/71qi/QcoSUe+EbZk5zleWX3VRLeA3lCjyOtfyPAusvxO+p5
hyDzDd6txW9NYH1J3788FPcJ/ymQFVRXZLgqRc8U2Jf2f3jYaK2KrA3dIIH/
svE5znIZOQZ+E+mrhP7m5eAUr2jBw0jrXwmwHorpnX+ynRIxjxe/pO9fHoo7
1VWJs/xRGBqYbMj99LDR0tL6EhEeuc4td4tspOk3q7W0tLS0tLS0tLS0tLS0
tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLR+j7q6yEsAQPOG4OmPVF8ylPDf
1fXX6aUxA3Pb30c6SN5C1+oSnBzHdlx0AtynVv0A4fo5IQrt4ST+reyT0O2H
v/VVwsexkoMyvo5wjcns+XLf7Js0CNO3/guWj4OVg9z2LxV7J9IY9HfQUMfk
eDDHO5LjyX351LsP0yOE6+fEn/0+6Uno9ld05CkxlPCvI1yLPPouPwG30XfS
B8LKQW77F2pAx8CelhO2NQb9y4W5AAczpif8DGkYMihRJQZ8/MWw/Awuj/Yh
xFWEa7BOqBoFrFnAQy//ms9+VxGb9zeJLWETYy0UJ8CrV68GL1DM46WSgVPb
eopBV2QG1K3NZshN2qRmSxKZNZgJKJ66CbC2Ia63almze7mjxIyzf6u+4WV1
ZVAv+KtXue1ArKo73HNeenhkFpR3qZbGoH+q2sQgADhJAIgcQ5kd/3KmB/Xa
cVkn9DBiIySH5GBK8jEMKRzc9DJ8L4b43b1EuFZj01niMxWEwwbw0GVAKeEH
N0C0C3z2u+1PmOeZK62AboPYaLHYvxO+pcBej0awnCAhhwvh+eRiZNNNhbNx
FJa89U0ceHNlCT5ETiwZumZUjfnFB8JNQceGo8ywEK5Rt6ZTlA3TsgzDDrs9
2HqJmr1P6lytZG2vc70XAjgO1Pjis17uIsewg6k6VIXhY2al7AUQkr4CKx8L
J3xedLETUM+regF6R5WrpQAG6yINTjAOGNnhXNRZSIxin+JusglAVL/1F8+c
keX1xZsCeO6rM64jNAb9y9UpkEAwiJyBMud5TCPI9rMipdwlXCKlnF+yEuO5
CaME5HeL9OdVbDolPi9thHDYMB7aitI8i33bCdv57HcnzMvshK4+Eg7uHU2S
iv17NcaaBY5MAAIrSpKsbAnNyh5vAHWJT5Q/co8KFJYc6ouBqi6qMkEDCjOF
hZIV14Q4NwQYio3Kmw7tnwjXGFBrnuLmWp8RBMA4582wA1svU7N3Rp8yVytY
20qut0QAJ4FquJyXM4QhoIelE3RR3A6gF0BI+gqsPEXUrcPxPLb2jD2FXano
BegdOFdDAQzWNTXYifMcDwf8rSyfToUdbiqiOqYJz/RkRGoYB/JwzS5og8r2
L2majclYY9C/XJQWIS1nYRA5D2VGvNcDZUVhT+FyOOzU7YqGMXKxCrbF0p9X
sOkL/VyUgMMG8NARh1DhujBBSO9rElisCmMtEcfmLxJuFyJ0j2X3zQXhbtno
Vlhy+u21rgo05zaDq1gyeM1wQWlmgmIzzPfZNaQQCpEhWNjJoavYeoCavU9i
ru7nXA2ztpVcb4kADnt5TJI0Tog1rKhXeEEBSVd4GbfWnqaRPb4nzp/LxHDQ
g2CuBiJNURdxIpl2DxWmpFG8OtrKOK0Q1XkvLE9zcK+DaR2rMehfLoiCjT6G
QeT8gzn2536eNvMhRyYtaE4C87u5HL6GTQceQEM4bAEPjTCplrDlxjYbBIZu
NgksVnUzknL1fGfE5FO+7JzP1aAlx+UowRQaFl75mzMenbnnAtcgwtrBS+TC
l5YPmAbiRVVdYIQjvllvY+sBavY+iUTgesybBs3VEGtbyfWWCOAKL9+uiInm
pYTJixMO7IVdQHY+V8+P4ZbcriCGgx4EczUQaYq6+IYtN5dtojrvheUavj0a
g/71uqZo9+KYLJ+gR08KELk6V4uunMILz7fnebXM7+bozzuw6czHIA5bwEPj
+LnwLyHuzdXqJoHFchjrHdhr+lSXrH9BKSxZYPgrmW7X6J465+rlLRToGpzo
zAmoDc2rUSqzKAPcdgPKANnG1s8NXqjZ+4Rpks4yAUu8w5TNQNa2iustE8BV
uZrwTdz4gslovdILG7lagJVjd894IwIuPEnRODcJ9CA4JwEiTVGXcqqwSVQn
geFclikx1B6NQX8Hkf1b+3Qu6rrM0L7oeJOFQeT8MkoeDtm0RDpYx7SsqyxC
O2uYvKngdwv0501s+qIewmGLF3c53tDz0rKpi9h1/HGtzK2OIbjznibJxXLf
UmGv+Yx6zTDCLEia67XO4yDKuGWjwpKY/erkzfiVs8XNq5eSwWtqsgkSZW1b
ky1NMVeTl67jcmKAkwdZm7m6lanZi1b51+StXQcR2EtCe7fJfEzB2ga43goC
OOzlOSTQN9IVLyhzNQwr77FpjXAMiCpFO/0HVw7duRegd0hHHMyxXQREGlzX
vlwNEdVpe+y4bEryLHWa56MUHqZNg/5AR2PQ30NDxjDHDdsvsZ0BEDlxNwZ9
3sh+NZer8bSZZBhzYkmb3oRog/ndPOF6E5vOCsJhy3jo8jwjngkemu0CDHfe
bBJUrPAtEHvNobeJPRnglBjJCkv21WX+6Hi0uT2QqWTwmvGqy3F6tcfxICB4
c+IZ4IZ77rex9QA1m+nFOv+6i0+Lda3j5cp8S2ZtK7jeAAEc9jIuIcF+YjeB
ZS+oIOlKUPtQBzMBa3m1A+6Fwjs9flJ4EKakQKRBdfENzq1lfJEFFPoZJqpj
A05VWP7oStqeIZ3fosk7jUF/I2Hq8VV473IHiFwUvo8HJQV4C3XA/G6R/nwH
Nn0f+PoBPvaeJsnFct9SAdOlqnpseBlrvmLJPYhq+JqVVuEZpl10hAHe56Ej
3Fk2ewE2aZt/Tdq0P85UXO9n2FMqL0CXKkDttB/7GgGaq1d8HejdPXVRrRHV
h26cDctDrpdzAiyNQf+GUmxZaN2tT7ck3ss147IdhuFKXqImryg8W6bmX7+F
PpKorjHo31DojVAj1OcGPK/Pt+TQhO6yCWLYp+Lpo4Q0//p99KFEdY1B19L6
bBEGuH47Vut+aQy6lpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaWlpaW
lpaWlpbW7xTLx7qWaRSGlxRRAFbxPcPqK7swxPkFnOiuybOCvPHJEsy/HWno
HTDrrK/fUM9Z6DUY8aGr86z8Pn8J9nyvf5fdvn4YDs058KOkUl8A45uHajqw
xQr+9RrpmFAd3UrVTxDivIMTjfBuq8bDuNUDOaJ/Jpi/K5QZc72z5QTMvkl9
/4IQSeum+BSEOuvrNzHcK0HbL8KIs/H2teqbIvKPjm273inOl2OUuCHzfK+/
od02k4ZSryXXP6QuJwAgV4VkVuGbF67KBum4T8fvHM9Kj4IQ5x2caJR+jypk
DG45c1bkfIjru0KZZa63T2Exq6b4HIQ66+u30GtB2y/CiAuH036VuiIi5wS4
nmfjYwPsgMYVN2Se7/U3tNtm0lDqteT6h5R49C/55WkJIR6r8M1DCYCnl9+u
3r447PUqxJkvk5tCjmY3/EK+ZP4HmKvBpsIsdBUGGoBSA6TpO2/fMn9QFcBD
x/QR9I5yrr27UUIJd/v6e4G2GbKD/K1BxWhnC8PdGgj7bHfOUZXMGeChQBrX
PxMjg7Bv6Lni3JBZ7bWqXq5t39Bum0ljx+fM7/kLVD1+jYbSGafUUYyomNMB
7IRXHuEc/jf/8/+wnOfD4JsRmnw+C3f8J4PDluHLY4HoMGTcG4A/rgKDTpxo
EEt9plUYY2HuGR3qJQOpwVzNNbVfTgO2bMs4EP74goq2puUA1Aa4s+DXd0hk
WtEk3HGmaPPInJxxKa+r4PWF682Bzv/Rf3OwTvNWSxbYpssf6SOVIPiaa/XP
AG3j+aEXnYVv9U3uT70zvYhyyEUefTef4G1jPgSigCGLuQVdco49tQmycqgv
JmkwVDI77vCS4ZFAIlhJ9pg78okT/Z04ZBS9Vsc/27bvaLfVpGHY55xUhkLo
GIY0xkwvI+s1nlyfht70PR/njHI+i/0YfcgClFCQkuutRNgIuqVMkMcHx0/S
7N/8vzC+ebhWF2Rq55KkJSKoTGtkkB6+nMcI8cfBXN0JSAsRS91gurfhBkma
5HWnBlKLuXppKkWjennTljiN2GHa9gQVbQRJWRexM+1QgW1Qk6bFr+8Qng7Z
fpqlSZKkaRajblgcjAPfWC0/aZoKcVHSBgavS1xvFnT+t8n/elgOya8cNK6Z
RxVQCYKvpYu/P2i7p7wY78x9q4qc8V6SlVWOw8PDtDCBGk/660VJkcf4PoNc
NjTxbGSybnUvaO1cojmu1yhKZsdd3T0YSHS3ihtMV2JDYcioer0S/3Pbvqnd
BAt0GC5semFeZCTkzoiyQ0PodMlKfD0lxzEZCdPiDm4YF3ni2U7SDghefRgz
STM2zDlePiBXYwg15jUQ/HFAEBKo7wswWgXpJutiyhiccdhKeji7/yDyx4Fc
LaLiJPg4RmmbdDmzAqSWc/X8IcoDZkBmILVDAHOEXoSmJQhePtM/wTaoSNPy
13cIk+/QLZ+KBDZ3L8OYj/F+UbbCHggHXpe53jzonCD2EOiwk4CSqhJYXwsX
/wTQ9ipzvGubMiejPpvqmnpN2ulnjC9IaLUnxHwfm914BO9jn8ffRzzeVyiZ
G3ePBhK0dYY97l74IaPotTL+LQEi/z3tJiUNwoBGqnEuzCmAeLrbXVEW5sHf
fONJD/BcwL7k9UdtgfTlgl8i833MyRVSqxoVuuxhztds0cPV/PGNXC2jTjn8
3yaQGsrVfYzu3U5SVlnk0rvqNFVYhClFYBtA0jT49R0S96v7csk/symuZUz3
bEw3wfMbGbwuc70F0DlGwBhZP6QemlWzzVeXAOxX/xzQtuJb14IitCwbgzdl
Hj3tbyc2gy4BghrtP7hFcUa3vCtCWZEkAJbMWeDRQCL3X55QjBKgORtzjjGw
1zvi/zvbjUsaiEO43AKuaGpsBR0fWmTBzk0pZ2YTZ4o6dEnTjNOFj65XiIBB
o6yqq6pu6hjtOjnVoMjVAr5ZkavX6eFr/HFhI3RnrqajeBtIDeVqkm0wutty
6PtyeKVDVl5gFzY6q/j6DqmfLUr3so5wW/AsVAKvA1xvaa6FphBOMK4nx9kK
N6rVJQC5+ueAtuFvtWh4uHQ9G5l0K0aA7aL+Tu5ebq801M2jZx2cmKzaPN+b
sGhwydy4eziQrpnJwH9v04teHnqBgX8mAvZ6R/x/Z7tJScM4TeOqPRL0GPPA
9EZ3z/h5Na6CfSLAGKTF23rCvfJ5DQitwywQpsXplVuNzktdEd8M5+p1ejjM
H1dAnOE9EGZWjPc9jkVTV00HA6nxHCPG/FC8UDrWg5jtxztpPaG78TNcgoo2
o7S6XpvsHJxX2qAkTYtfn0y8AnSGc3XG7FcPTWKbblw2fd+e3SlXs95RcL3l
dXEZkRWVI8wOVGRwMFf/HNA2/C2UGQzv0nZtiheDEI+e7FzZl6JuaX8nSOVQ
kQUk2VONyZMouoqBS+bH3cOBdMsDZD4bAeKrcSgYh2nHlR8yil5vx/83tpuY
NPBTKj+um4qQo4OCbnEcrGNa1uN625xn5gy5Hm+eHPy4aJsy9Jyo+P8C2zpd
8mvfV3hbmcvVz2Pc8YMq/u5QH/FWPIuBxv2D8c1o/HLpi1p7lR4O8cdBiDND
TFZhqbuCvp9AQJwAFrxNcMNRI8mfS9jnii0B5wFWNlppDU3oLJ+fknqtDQBp
Gvg62ykF0Jnc8YVcTejwkymYNzTGX12mdyx48DrA9ZYR6uPEFU3M8ZaX2A64
BB9s9k8CbcvfWnj0lndyDJhH32bzSynuaQzphZmOn5mZZNi2CZ4STisOsGRx
3D0YSOjX81sKyC+OX01pghsyKl78Vvx/Y7tJSWN+OwiFBNm7ILnanGnzHgVF
8kR7f4GWOXH59/M7Lai1wrTzszHuSnyz6voV0jL0KxXEeUuI6Mx8UQJSow+m
dyA7gVVNNs3ShqC7uyo2mGcKd/DUoc6qvv480BmyLAReXzcnevx6CJV/13sX
GfwngLZVGnbx6If7UOx3lPxEIBGkluwEYcjcWe9Ova3dkMSk0XEhN29Ho8/X
KhKDfADx9Ega4/6suhy/Zpl3CL/cTO+PfSDE8y2Azn2dXCI0KXgaU/5afSFo
+9vpLQLpp6oTHw89Ke2sV2hgt03wG7/N9peeqe8NgM7k8a5pn97trJwvBG1/
O71DIP1Yob8aMMLXnReknfU6EXS3NubPlwZta2lpaWlpaWlpaWlpaWlpaWlp
aWlpaWlpaWlpaWlpaWlpaWlpaWlpaWk9oC+n9b5QP6kvz4uFuWsJ+lDj6DjU
ek59dg6DWb4fpfW7Yr43JXLAb++LLFdpcUcYRnGSX189vmeY+zfUNzbO6+Kw
ixzTtI9ZqzP/bxPBaBqWbVujTNONinfFfG9K5IDf3hdZrhJxh+m4LmI/HigA
64VaAQS/vb6xcV4Xh0MZh/bug6e0fpDImcnF5nU8z5fD++6BTvNaQVwP7DV3
Fiue/3xXex74CsRR7rkT/h7rwnQUPDlclz2XAKIkD51USw9VTD4rEQlDBXNX
eeX+g9Dk+iHSOXDZmr6bce7kjwMNU5SA2/lBh1xpva2A/MZivjlA8L/Mj6Z5
Op/JqbOGE1aEToImO0d8CnXhGkaQkUPN0c/ehZw62/qWcUqaW9/EwXRa7HSy
MaEGnyJy9j06rlnGkT/dl3HlaNjz0dCoRsPHPBSxroe6IAGan+vCjO3Ax5aS
870B+LvENEcfLQdcG/502dDmlEZr2OhYX1NKRxD6XMltp5YtXYMw39E/zq6J
CXdQkyCoNHTZDzLOrU8DZ/J/UDGYdUKENwzDJMtYAqYEGiaWwOo7L460HhZe
V3pxi7goTdOiLUAG880Dgv844X3PWTYdT+eGSZ6GOMZzwsg7eOj4eoINolAt
zCaOyn6oLwZiXhdVmaCET347UYPd8JJm5Z8hHPn+vgi5eu5LhpgCLjlznEzJ
4naA0OePdEEANINE9Tvc4YR5UWTJGR+47pMD1wH4u8Q0p1RxhHSpszP68Tze
Sihlwz6nOWF/I6IcW6cCfQ5z25eWsudGdgGhKclNAqHY0GU/yTgkHsKxpjI5
Oh6CPk1xOFyrJB4HU4bJLQd/nBVADZNLYIWg3p93cL3Wm4iysyfJ7G8REDzh
+dDm8LRphtDABHxWhhQNn4/jB4EVrHy4tej4VndhM/TXuipC16DnJ3NQYBhH
vrMvUK6mfRnqeRo2IMSPFfWKuh7oAk8Jf6oLxB0mEp5omcd8QZYL8HeRaU5g
Xuj8bQRwRrSj8QaKs8SCGi+lKZkKXK5gx88WEHM1sryMWQeh0hCN/ScZh8SD
F2Xz00+RoXbNrJnuDTdMLIHVUGGK5aX8Lo9htF4hPCM6pQPeGiObYyBPFolj
FnM44PlnQmyM63oMuSAvTuj6JhknC26MS6DgG8PCSz5ThpzCOPL9fVHl6nF4
4BVESoC8R8QHgut6oAs8Jfz5LkzL/KFBLyYgLCwEf5eY5nXsiRUHeZui9DVz
yeXlswpcruARTwJztYxZV0ClZRr7jzLObcjPR1K55Z1b8ZoWzeApAPEGNkwu
gVePGYoHCfGr9YO1nt/AXC0OT/7nehw29tEzDvY4l8qOhuEeHZobcWkHizCy
6vk5DlcsjCO/oy/zfqbUF0xncOPLEXEJ+5W67u4CPxKf7gLzqJfAi/8Iwt/n
70xM8z9gEHDKr5eFWZ+cjlTg8o101HF32DH5cFTfGbO+CpVmaew/yjhUQ5VG
eHuwYK/JfGvG/k5ViA2TS2A/JZts4QdzMbTeTHty9TSUpC1KKFffEvK4EXOH
yc7wmLkYILWTN9c6x0BVMq/miTkgjnzRFgd8/GZe5Fk2/pcVdSdg7skczzym
63Xd2wVhtD7bBTcqq6ossrOPYb7jEh2CvwNM8w4jOK1TXrdtU0RBhIiobYK+
YPtl2xaxT9YCXGJQgMsV7PhZNW5cULU1AUBbfg5h1gGoNEhj/0nGKSLX8qKq
7boms1Ejq/maK3kI4p5RJ4qirNFettwwuQS2URXarw40G+OXSWRn33jcMAcI
5pjFCGA3fbGLrCVXk+RGucNdhocxjf++usxs4OPRnvZAOBTyDcSRz1rlgPN7
76hJPDp5IEl43p9U1XVvF2RK+Gu6YFinKMPfheDvENO8q+Jlz8FwyAu9deLP
l6FNAkukUYPgchW3fdZClHb80DNRAICYdRkqDV72g4xTp0xLbb8elmtyX4hR
HD9Sw+QSWOn3QLQ+RUrULycJRz7r9URgdV0KfU0XQDA4yDQHAM6E1Lza3PvB
45TjvKcguU2q+n6KcTAD+44XyGELgSWUeIKlc7XWO+sHEIF/QBc+Tto4W+qz
EL/i98jffGlpfZ5+ABH4B3Th46SNs6U+PrnuMaz0rFpLS0tLS0tLS0tLS0tL
S0tL6zvo/we3ck5O
            "], {{0, 262}, {484, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{484, 262},
          PlotRange->{{0, 484}, {0, 262}}]], "ExerciseOutput",
         ImageSize->{488, 262},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a8234b04-e2f2-4a50-8174-c45e87715743"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvb+r/E6X59f2gnHof8Hx2oqdCkfGgWCMwQtKdu3RsslYnlkwSjtyO7Iy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              "], {{0, 262}, {484, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {484, 262}, 
            PlotRange -> {{0, 484}, {0, 262}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f26f910e-a987-456a-8ce8-66e1e2e319d2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4941db2a-00d9-4d80-8382-cec032df1cbf"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"65fe0a83-047f-4b0d-b955-599732ea4054"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5edb1afc-0041-4c28-b551-a5844e01fd06"],

Cell[TextData[{
 "Use a string template to make a grid of results of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"i", "+", "j"}], "=", 
   StyleBox["...", "GrayPointSix"]}]], "InlineCode",ExpressionUUID->
  "a157dfb2-2828-4642-86fe-6595df330b88"],
 " for ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"78f47c29-a817-4f90-a6ce-d3e4731cb37e"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"8ec98780-dd8a-4e12-8054-68d5b279bb01"],
 " up to 9."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"62311efa-b711-4a12-9337-5146df104720"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4da76b77-0ab6-4f4f-8448-5a69170866aa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3S2zMm12BeCTxETmL+QPoGORUVRNKu6YmcrLVMyEmklVCotD4nAoagQK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            "], {{0, 167}, {476, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{476, 167},
          PlotRange->{{0, 476}, {0, 167}}]], "ExerciseOutput",
         ImageSize->{480, 167},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b3073491-d472-4712-8419-ce8ca4afd5f6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3S2zMm12BeCTxETmL+QPoGORUVRNKu6YmcrLVMyEmklVCotD4nAoagQK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              "], {{0, 167}, {476, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {476, 167}, 
            PlotRange -> {{0, 476}, {0, 167}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4f526b88-bf48-4eba-8d0d-279948e2920e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1c839604-4767-4f38-bdb9-508e1651d867"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7bea8757-379f-43c2-802e-193a0e9a31d6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"201cca3b-95d2-45c3-8d9e-e7e5eed96240"],

Cell["\<\
Find names of integers below 50 that have an \[OpenCurlyDoubleQuote]i\
\[CloseCurlyDoubleQuote] somewhere before an \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"cb395899-733e-49e4-9b7b-4929a23df4c3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"95d1daa3-d555-4b74-a1d5-d0cef89eeb01"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXT3LtNgZNkmTMn8hf8A6ZSxTCRvSDYRdsi5pNsO+gcUuTGeRws5mMY2V
pLCaysAKASErYQ3BxkIWbKYwYAoLi8m5z9Hx6zijMx518p4Ldnke3/Nx3R+e
L30uf/7ZHz5RfiwIwoefov998unX0ldffar++mfol998+eH3X3z5+e9+9eUf
P//i869+8dlP0MVfov+++JEgwM9XDg4ODg4ODg4ODg6OnaIIXdu0bC/OyqIo
WfVSMmk6TwM/zCkts+luEuj+zCLPMk3HizbhxTCwz+I+pTwJg+iyGplH2DCd
9oPsrCmieAyLa2QeBAzlL3+VBUHSAwbdFRZ0coyX8Dy6E2/5lgcaatfPJ3dX
Fjnj8FP9WcY2uSjIRs6eQw+xfUQ9G2HfTRVW53N9SOl6DTRRELRscL0d/bXw
fPaynIXXRh4akNWak5a5iTL7eIarZWIcFf2cMOiw8FDTJ3uYA08A0unkk5+x
IVIwGDTGussDnVZ+QdD9Sfolgxt7Dn1kgXU4qF5Kz9/1+TykhBAakiAaQ1Lt
6K+FZ7O3TNDIqAWLZP32wHmiF/BjYUqCZITT6xZoXppYMqftGx4UKB82j9JG
1CvCZNAIS9xYcbcinqDKCA8yvYIlZfIaM/ORUXR/lhE4PK9+Zs1htEF6QRof
atcv8XmUOb1JmQwaxcCOdvSbqpSGRxKpfJQnN7avZ28ZSijqYdErQonLSLAm
OnYdFGGVw5F1rJbNaKvy31gVJTPM4aKsp3VhXz9IRwcsz0LtIJLS+jmmN13G
J0nSHeckVc0GF7AbtSke7WK8AELqWzIhIx29lBrZ3D5W1RCPox3hQUM0LJ3Q
klSH3Ji37orIkhXDtU/wz4ffCjVExSLTvmtUHpBvU8nQzHHOPVD9iTiI9dU/
/fkDaw54ZlRqRxpxfi1iW8JbUd84CLKW4Ho+KiPr39pqnw81yi/xoVS/UcJ8
E0OpPCQfZFGQLAgsyoWDrlV7Pd2Nh9Efy5nhxSK25IPuuYbQzZM+FszeIjrW
UUeLeryQowV6eHGWY1dEjDZpoo4Y5vH5ALwM1wuy/wQwMAYZSnLhtt8sI1RA
sWNkC6SXdPLjxMeZZie0+zoPiOtUywuxG8mmHk8c0ONYgSIy4bZGKZVEJnjx
lFJav6aBUxN2gyQn+yxUzwlC4nxC+9ZdXUC2XPdv3/7dwWU0G5kLO1RPk2DM
caMkPCuECdXMEc4U62n+LLPY0VHziuN634X/Ys4Bm2yiypF7UlS0Os7DenN0
8VBnaCFUXs7Q1DnJ06jDh9r1a3yo1RtK18JGZotqkF6isw6xNL1LcQ3J0ZBi
BpGvQU+nyyD61JyhXhzLE4bZW2a+A3PZQXc8z0f3PSXQ1OhPd+yKyGIXmSVp
ZGOIl9NkvVdUSY5yC06hTh4U9jUIbkZ2NIIDKVRCAcg9mi0FmHxyybl3aeMR
p2hvUekFSObA8gY1X6QO+mVwvHntE663Jx4ZtctQrvg33ZFssaJqfMNLcTks
G6qKFeE+rzC1ifoPVDNHjHpAr/FntT0pVuFATFYtPyvbV6pTi/R8qmc/e8iH
GmV66KfzobbZUMoNtLYwIlw2UWA93wz7edNCNcK0ok/NGXoikRXpME8G0Vs0
e3FHBllO0QKdjV+clmzrQcOLHrfyWW5I9VDWSvIYvKAk1ysMf4qNLErOzTqW
4DAyaOBGqhu+8kPX7bQCuXXoNz9yNNci3DsIbfHvDhrybcPeK9/vUzb/TTVz
xKgH9Fp88rA502DPoQzsE1kay6p96R8XR3giE536wLv9r9Qo00M/mQ+1eqvT
4qwisoobxT7e3Nlxce0ehHZGmCb61JyhJ9JYnvSxbPa2O6IFOh+5ODnQ66HM
Ikipk4t/oyf5NfNQEf0Mq0HNhysZjPb1WH0H3YjcvD1we68AfqolmxNGVEy4
PmmcNmg0jwaqX0k3OZQ/Op2nRXQzR4wapTdl0GDIgaCMPYtsRtpOCE2YFGG7
XM9fbT7Url/kQ63eGakcFSiJgigrtp8OG+wPGlX0qTlDT6SZg8ZC2UsKh9Uz
s2Gg6RdnB3olxLDoIcNXK8nzNtvSqc7S6sfTeQijoqwFyeWShpZhwYRQRmiW
kE7nxl350OTbWI3vmpECeB8kKIabZlkSnA3Lh26H7VdLwVOYJnGa3x00dMqg
gZfKVhAnCdplFg7MbJLlxVmW+rZh4/0/xcwRzjR6dH92Bg3GHELrKKtWfMnz
1EftHKz45oQyQStntO/Mrgm8N6I2j4NrPvSuX/MJrXpvHBBkI8myy+WSZRl5
jNDZnrSWJe3oU3OGepGeJ6yzl+w+TC9Nk6ykBZoe/enJtiqKJofhvYJ6ZoTg
3thmPuSSrDfPxMkpXwVRgYfsuMotuMNGYHGFVlzkB8nMxwvAz/bp1nzlnGH7
kADVwwhR86vdR97v+tZdpwCUiatDaeEAr2aWqalIt041N7ljJoUzhR7dnzBo
3Iox5pB4ptwsk/WkvDmhmhBJSV+HxxOw4e7yoXT9qk8o1dtxCfTGfEIDrW2b
hOkGsR19es7QLtLzhHX2XktPr5/+wJBNCTTl4hzHrgk8uWhP9V7mGcwGt99h
0bLg8qksUOvtFxTp7ReIxdOPsEswoNVF36SxazQ8az5rDlA3n/pCzZAPtesX
fTJSHU/HGhpH4EWNEg0vYr0jHkUv+oOcGb04leqzoHVKLjVFXvDswmxngjwh
khQjee0JcHqG1ZUVsjqnYd3+i9gDvT1waGM2nzzAL12gdVBZ5OkZT80O9Wn+
0tib6+5jB2wL39IU5RS9FpwyT2P6W1jLgHX7L2IP9PbAoY35fMr2wh7eqPGp
b+gsj7257j7eiy0HB3ugZUY+8QVvDg4ODg4ODg4ODg4ODg4ODg4ODg4ODg4O
Dg4ODg4ODmZYRyx9J/h4NNvnYE3+o32xAXPTVr19WMk+z9S+XlwsfSd20fAR
abY/xJr8J/S1JNY0bZVvDTRgJPs8U/t6ebH0fdhFxcej2f4Ya/Kf0NeSWNG0
db410IAm+3wfk/Sf6Vrco1heLH0fdjV4G832RxibA6nXZ4WJNf9ZfbWJz9Js
f667drvzTWP4rYEBurLPlnMURcPHooVFiH5WHSJSfdFlUXPhz4sm6j9HHe3r
b75RxEYzsExOkqh7nY9qLS2Wvhe73kiz/TvwttZ420DeHkhWNp4XVNMr6sbR
xObcBCXccWHzLfnP6EvRHQuUCfGnTCZqtm8amuW/NXAXXdnnH8AkFeQB8wDf
LETZLAVFaysqpus/97Sv/wky9UpUSdpC+XP36zmLi6XvxK430mwvsMZXpQlT
xgqWAut0RjwvKI4fuhb8KBvEFhlna0dO/KkwseU/uS8cEEV3PT/JJmu2b2ra
8t8aeICO6Dc+TlFTWFmhq6DOFpTXC/yB/zEZkWIe03/uaHFjJVIivOyq9T1b
YEWSSrpkabH0ndj1RprtZF+MxaXzm9pnyxbiebtWZvFAf1ZBLVHlxJ8LE1P+
k/tCP6pJY840zfb9mLbM7XMfHdHvMobR6ZwkqDUjCDXoPYXbAc5Y5uk/d09+
SrhBZavE2vXqGabNUK/F6rDO88Ji6Tux640026vUEv2i9FSYzIquLd9jz9fi
9s34QFUGfi5MTPlnM/u6ztJs349py9w+99ER/UatopvgcEI7ukOE9kEnUTye
lGoqnKf/3NHirtbbkmmd2p6he3gRsfSd2PVGmu3YSyqo5lrgGa//JXfseeFc
b5N8+PoPSI9SB43nwsSU/9y+rrM02/dg2pK3z310ZJ/R7y45ksOjGdEcRulL
epmh/9zX4obalayseh718IJi6Tux65002wGRRdytUKTeiOAtbIfT0IWKoua1
G7+2238qTGz5z+xrNNn2aNrit88D9GSfyQ11tPFJS+7DGkg2biPTVP3n60CL
G+2gXKhr0NfZS4ul78Su99JsBzfB9xzF6ls5gyDFzs3z0tG63DhT5cTnh4k5
/zl91SbP0GzfzrTlb5/HmCX6PU3/mRRta19HsOY+LvTSyTSx9Pez6wEl5prt
cOgqmNGd9MGen9obgzANupjH/5m+JimLb2/anJbZfmtgCVxCz7bwett+5rnw
Q2wl4Mzarh7YmlkkrmPBR90lg5Ef353/Hby1aTvQP6eAfBn8aLiM9GS3EnBm
bVcPTM2svnZx0JaZymh4d/538Namcf1zDg4ODg4ODg4ODg4ODg4ODg4ODg4O
Dg4ODg4ODg4ODo73wLvLWU/BFjbelzjOkzCIhn+6OBPbxG7Bxhs97aVaHGt/
Ib1u1oSp2MWd+O5y1lOwrY2x3Sg1UQEKtII2zLyHgupbx25JWfVGT9uKJlXY
Wq+bNWEannN4bimSdDj5l8Vu1XeXs56CbW3MAutwUL10NGRtDYcx2lRsHbsF
ZdVbetoTK2ys182aMBXPObyMzjDAkT/3XgRry1mXw9nzseb2eF3M5ZHQ9/qS
3ffVnnvLYzJoFAP7Hgqqr2/XlZWsOkVPe3Rm3oVeN2vCrdpLODwyK9W4l7Gy
nDUaJ5VajcGIcdM9ze0yPcuCZMdVvTw0RUHB6/qcyLGCOAAZacd1vDe1kaL2
XMS2JB5DUq5IDKUS9JYPsihIFjCSQUVYawt692lvbBdbWfWunnZBlz0f57++
3D1zwos7fGw1+wRW1UzGdU0/TiL3pKioIE1zG2TNRKyGWilw4j8H9kBcTjTc
KAlB7xA2pCM63tvaSFV7zsNKTrNWc1KD9BKdQR3lYHqXovprWUHpCHr3aG9s
F2NZ9Y6edkGXPb/Df325e9aEF3c4qL7MldkZxYpy1riuavlZVZ6uuY3Pl/BR
TxHiXWNCJLvxcRNoKFfquyNC3xvbSNWvbk4bcgOtLQyybAAtYr11X1fiV0Ez
wrRpb2vXmrLqY7Ln9/hvKnfPhPDSDi9jmBc0J1riMHRNzeQysE9kDSer9mVM
c/viwqwXFjm0hgXQiqBfUDbzEaHvbW38nqb23GqhOMNXeBQ3in28viUbMao2
b4/2xrFbUVY9GZE9v8t/S7l7JoSXd3hh4HvPW2C1saZmcuWu2LMkGMD/MaK5
XaDFlniybbU+ncZaqUene9w9IvS9rY1Uted2g4kD2y9JFERZsf10SL4/aNw7
u1sxduvIquN7cEz2/D7/beTu2RFe2uFk22L61N3hXKynmRxaR1m14kuep/4B
75rpmttoreFpZJSs320oHJiWJcuLsyz1bcMOsjEd7411oWlqz71xAO14kyy7
XC6g0lhe211fO713BdU3tou1rHr7pqbLnj/iv7LcPWPCyzocrangTMNYSp9r
Nc3kxDPr5Rec1JAtIEVz+woxgkFCPDVrizI1FelWUnOTUR3vzSWvB2rP7QYD
vbGCtInmt1FB77ag+rZ2MZdVb+lpX+my5w/5ryt3z5jwsg5f9OlJzXA1zWSQ
Qc57D8Any4BTVaGH2IEu9AhTfHiloSyEFzVKlJxivSoeRYv2Dux6FhNl1bt1
Jsieby13P6yyGeFeP32HR3gryyC0r2FTOegbdq0LnQf4nYoARbPI0zP+0roz
7Qu8u7ZrJha35e3k7tfVsS98Ez9GfvnN+cWxrRz0DfvWhS7bS0c4PZ98MLVv
u+ZhcVveTu5+XR374qwdjycz3t06g2M60DIjf/CmNwcHBwcHBwcHB8f/F/4H
ShJL5Q==
            "], {{0, 64}, {359, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{359, 64},
          PlotRange->{{0, 359}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{363, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6a4461d8-6e85-4353-a8a0-caf7c6aa9ad3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXT3LtNgZNkmTMn8hf8A6ZSxTCRvSDYRdsi5pNsO+gcUuTGeRws5mMY2V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              "], {{0, 64}, {359, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {359, 64}, 
            PlotRange -> {{0, 359}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a5bb0d35-6d6d-4727-84f1-75378a6b3f44"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"58dcf19b-324d-4c46-b7ff-ec7d73e1ed2a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d06a3e65-da95-4a49-8b5f-485de39d1ee6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"477acb83-49cc-45cc-8056-2bc8a9cd5efa"],

Cell["\<\
Make any 2-letter word uppercase in the first sentence from the Wikipedia \
article on computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"2b7f4484-64e6-4476-abd9-20018c575fa3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c8a43cde-87f9-4235-b1ae-ebceb5b7bd4a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa2vtcp6X21NZf+F2jZB1yKrSE5T0QRzb3q4qTkl5zZpsDhccTgUihoU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            "], {{0, 42}, {428, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{428, 42},
          PlotRange->{{0, 428}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{432, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "28e7ea43-4fc4-4e01-84f2-a36bb5463ff8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa2vtcp6X21NZf+F2jZB1yKrSE5T0QRzb3q4qTkl5zZpsDhccTgUihoU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              "], {{0, 42}, {428, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {428, 42}, 
            PlotRange -> {{0, 428}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fc67e6c7-fe12-4490-a372-e5d4cc8e09dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"178323be-fce2-433f-850d-1e193319d85e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1b462e57-d857-4811-a8cd-90348182a086"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9923329b-d507-4580-a055-c0c557cbf7da"],

Cell[TextData[{
 "Make a labeled bar chart of the number of countries whose ",
 StyleBox["TextString",
  FontFamily->"Source Sans Pro"],
 " names start with each possible letter."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"634e761c-3e51-400a-beb4-e403bf20d08c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6e78dff3-b5d4-4234-abd7-39583aed3455"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnSGP68x6gL+2pLBSf0FR/0JpYem9Kim7V/18VeJK3618VGAWFhQUEhQS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            "], {{0, 
            275}, {434, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{434, 275},
          PlotRange->{{0, 434}, {0, 275}}]], "ExerciseOutput",
         ImageSize->{438, 275},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "246cda7d-1c91-4977-af97-b999b649fc60"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnSGP68x6gL+2pLBSf0FR/0JpYem9Kim7V/18VeJK3618VGAWFhQUEhQS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              "], {{
              0, 275}, {434, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {434, 275}, 
            PlotRange -> {{0, 434}, {0, 275}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"08964806-2402-46fa-846b-c1c70d48dbd5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bd2386f2-3b73-467f-b68f-ff3bc9f21497"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b69ac56f-139b-4cac-85c6-a795919f2781"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"cd8ef78d-974f-4c10-9bba-9020613bfdd0"],

Cell[TextData[{
 "Find simpler code for \n",
 Cell[BoxData[
  RowBox[{
   StyleBox["Grid",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Table",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["StringJoin",
       FontFamily->"Source Sans Pro"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["TextString",
         FontFamily->"Source Sans Pro"], "[", "i", "]"}], ",", "\"\<^\>\"", 
       ",", 
       RowBox[{
        StyleBox["TextString",
         FontFamily->"Source Sans Pro"], "[", "j", "]"}], ",", "\"\<=\>\"", 
       ",", 
       RowBox[{
        StyleBox["TextString",
         FontFamily->"Source Sans Pro"], "[", 
        RowBox[{"i", "^", "j"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"1149125c-bd27-4c92-af4c-5235d63bb0aa"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "42.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"11fc2044-c19e-451e-90a6-fc5bf56983b3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b77d8051-962b-4056-95ae-4841baa43a32"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS+v88gVxtOWFBb0C/QDNLjUsKSRtipqyK66WZVso91KlWmkgkglKTIz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            "], {{0, 91}, {276, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{276, 91},
          PlotRange->{{0, 276}, {0, 91}}]], "ExerciseOutput",
         ImageSize->{280, 91},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f9e1cec3-7fab-4afe-95c1-a9dbdb041d9b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS+v88gVxtOWFBb0C/QDNLjUsKSRtipqyK66WZVso91KlWmkgkglKTIz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              "], {{0, 91}, {276, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {276, 91}, 
            PlotRange -> {{0, 276}, {0, 91}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e4bb54fe-3fde-47ed-9e8d-de723cfc80d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["42.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"624a7230-d346-4c65-8dd1-ca090011e202"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"217e9eeb-5a2a-4720-b1b4-5dd63099bef1"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"66b7171e-dca9-4a12-a51c-bd0bc0b2ce51"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"String Patterns and Templates: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 42  String Patterns and Templates", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
42-string-patterns-and-templates.html"], None}], Evaluator -> Automatic, 
                Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "42.1", "42.2", "42.3", "42.4", "42.5", "42.6", "42.7", "42.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "42.1", "42.2", "42.3", "42.4", "42.5", "42.6", "42.7", "42.8"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[6908, 191, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ad3b2efb-f8d7-49da-bc5c-ccd95c319aa7",
   CellTags->"FirstInputCell"],
  Cell[27309, 611, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a0495bfd-870f-4f3c-8c26-639184d63760",
   CellTags->"FirstInputCell"],
  Cell[103209, 1944, 813, 26, 
  70, "Input", "ExpressionUUID" -> "65fe0a83-047f-4b0d-b955-599732ea4054",
   CellTags->"FirstInputCell"],
  Cell[132983, 2523, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7bea8757-379f-43c2-802e-193a0e9a31d6",
   CellTags->"FirstInputCell"],
  Cell[150244, 2892, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d06a3e65-da95-4a49-8b5f-485de39d1ee6",
   CellTags->"FirstInputCell"],
  Cell[170545, 3312, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1b462e57-d857-4811-a8cd-90348182a086",
   CellTags->"FirstInputCell"],
  Cell[193724, 3779, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b69ac56f-139b-4cac-85c6-a795919f2781",
   CellTags->"FirstInputCell"],
  Cell[211183, 4166, 813, 26, 
  70, "Input", "ExpressionUUID" -> "217e9eeb-5a2a-4720-b1b4-5dd63099bef1",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 270038, 5385}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[652, 22, 653, 19, 70, "Exercise", "ExpressionUUID" -> \
"4f754d1d-6584-4b19-a822-1eb1be6299e1",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1330, 45, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"33c397fd-e8e9-4e84-9456-148124a848ed"],
Cell[1969, 66, 4332, 100, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4f6a2cc7-c7d8-448c-b0f9-e26b2e4e76e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[6338, 171, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"98b6e801-a40b-4202-b99c-728479c4722f"],
Cell[6908, 191, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ad3b2efb-f8d7-49da-bc5c-ccd95c319aa7",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7758, 222, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ca391a35-c999-4a23-8c94-dc818a8b07e3"],
Cell[8045, 233, 558, 13, 70, "Exercise", "ExpressionUUID" -> \
"dbb10425-77fc-4d6b-9dc4-fad95fa42d73",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[8628, 250, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5b730779-3fd0-4258-b033-1d6ff8aad9bf"],
Cell[9287, 272, 17415, 314, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c06f7dce-cb6f-47b6-92f8-961ed59fb6dd"]
}, Closed]],
Cell[CellGroupData[{
Cell[26739, 591, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1ed3dd13-8ca2-44a7-9620-dc8b1e5bccf6"],
Cell[27309, 611, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a0495bfd-870f-4f3c-8c26-639184d63760",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28171, 643, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3247582e-0ec7-4141-ad53-6a320488129f"],
Cell[28458, 654, 718, 18, 70, "Exercise", "ExpressionUUID" -> \
"f13714b5-63b9-4d82-9c94-6a6229f3bf69",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[29201, 676, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"dd458b32-4908-4a3e-ae70-dc743580715a"],
Cell[29860, 698, 72742, 1221, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f26f910e-a987-456a-8ce8-66e1e2e319d2"]
}, Closed]],
Cell[CellGroupData[{
Cell[102639, 1924, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"4941db2a-00d9-4d80-8382-cec032df1cbf"],
Cell[103209, 1944, 813, 26, 70, "Input", "ExpressionUUID" -> \
"65fe0a83-047f-4b0d-b955-599732ea4054",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104071, 1976, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5edb1afc-0041-4c28-b551-a5844e01fd06"],
Cell[104358, 1987, 850, 23, 70, "Exercise", "ExpressionUUID" -> \
"62311efa-b711-4a12-9337-5146df104720",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[105233, 2014, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4da76b77-0ab6-4f4f-8448-5a69170866aa"],
Cell[105872, 2035, 26504, 463, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4f526b88-bf48-4eba-8d0d-279948e2920e"]
}, Closed]],
Cell[CellGroupData[{
Cell[132413, 2503, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1c839604-4767-4f38-bdb9-508e1651d867"],
Cell[132983, 2523, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7bea8757-379f-43c2-802e-193a0e9a31d6",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133845, 2555, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"201cca3b-95d2-45c3-8d9e-e7e5eed96240"],
Cell[134132, 2566, 560, 13, 70, "Exercise", "ExpressionUUID" -> \
"cb395899-733e-49e4-9b7b-4929a23df4c3",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[134717, 2583, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"95d1daa3-d555-4b74-a1d5-d0cef89eeb01"],
Cell[135356, 2604, 14281, 263, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a5bb0d35-6d6d-4727-84f1-75378a6b3f44"]
}, Closed]],
Cell[CellGroupData[{
Cell[149674, 2872, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"58dcf19b-324d-4c46-b7ff-ec7d73e1ed2a"],
Cell[150244, 2892, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d06a3e65-da95-4a49-8b5f-485de39d1ee6",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151106, 2924, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"477acb83-49cc-45cc-8056-2bc8a9cd5efa"],
Cell[151393, 2935, 538, 13, 70, "Exercise", "ExpressionUUID" -> \
"2b7f4484-64e6-4476-abd9-20018c575fa3",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[151956, 2952, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c8a43cde-87f9-4235-b1ae-ebceb5b7bd4a"],
Cell[152615, 2974, 17323, 313, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fc67e6c7-fe12-4490-a372-e5d4cc8e09dd"]
}, Closed]],
Cell[CellGroupData[{
Cell[169975, 3292, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"178323be-fce2-433f-850d-1e193319d85e"],
Cell[170545, 3312, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1b462e57-d857-4811-a8cd-90348182a086",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171407, 3344, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9923329b-d507-4580-a055-c0c557cbf7da"],
Cell[171694, 3355, 608, 15, 70, "Exercise", "ExpressionUUID" -> \
"634e761c-3e51-400a-beb4-e403bf20d08c",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[172327, 3374, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6e78dff3-b5d4-4234-abd7-39583aed3455"],
Cell[172986, 3396, 20131, 358, 70, "ExerciseOutput", "ExpressionUUID" -> \
"08964806-2402-46fa-846b-c1c70d48dbd5"]
}, Closed]],
Cell[CellGroupData[{
Cell[193154, 3759, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bd2386f2-3b73-467f-b68f-ff3bc9f21497"],
Cell[193724, 3779, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b69ac56f-139b-4cac-85c6-a795919f2781",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[194586, 3811, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"cd8ef78d-974f-4c10-9bba-9020613bfdd0"],
Cell[194873, 3822, 1344, 41, 70, "Exercise", "ExpressionUUID" -> \
"11fc2044-c19e-451e-90a6-fc5bf56983b3",
 CounterAssignments->{{"SectionNumber", 42}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[196242, 3867, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b77d8051-962b-4056-95ae-4841baa43a32"],
Cell[196881, 3888, 13695, 253, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e4bb54fe-3fde-47ed-9e8d-de723cfc80d7"]
}, Closed]],
Cell[CellGroupData[{
Cell[210613, 4146, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"624a7230-d346-4c65-8dd1-ca090011e202"],
Cell[211183, 4166, 813, 26, 70, "Input", "ExpressionUUID" -> \
"217e9eeb-5a2a-4720-b1b4-5dd63099bef1",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[212023, 4196, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"66b7171e-dca9-4a12-a51c-bd0bc0b2ce51"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature tQshRdraJGJzVlevzn6eIaPS *)
