(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    388061,       9618]
NotebookOptionsPosition[    279587,       7448]
NotebookOutlinePosition[    375356,       9406]
CellTagsIndexPosition[    374638,       9376]
WindowTitle->More about Patterns: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "More about Patterns", "SectionInline",ExpressionUUID->
   "8ad7551d-6304-485d-bdd5-f0c39b52ac7b"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 40}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:249",
 CellLabel->"In[24]:=",ExpressionUUID->"43026094-14cc-4c48-a732-3efee58f4763"],

Cell["\<\
Within the Wolfram Language, there\[CloseCurlyQuote]s a whole sublanguage of \
patterns. We\[CloseCurlyQuote]ve already seen some of its important elements. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"58e27099-6bd7-4d9c-8095-106649ba2637"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "21e5d50c-eb80-4401-bacf-b8b7df36bc11"],
 " (\"blank\") stands for anything. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "CodeVariable"], 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "96dbb4e3-5cb1-49e1-8e65-759ad769f8b6"],
 " (\"",
 StyleBox["x",
  FontSlant->"Italic"],
 " blank\") stands for anything, but calls it ",
 Cell[BoxData[
  StyleBox["x", "CodeVariable"]], "InlineCodeText",ExpressionUUID->
  "c9f783dc-62de-4e59-92f6-a746f64d9561"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"], 
   StyleBox["h", "CodeVariable"]}]], "InlineCodeText",ExpressionUUID->
  "856561ee-2465-4793-90a4-d0b2c2d30c49"],
 " stands for anything with head ",
 Cell[BoxData[
  StyleBox["h", "CodeVariable"]], "InlineCodeText",ExpressionUUID->
  "859c1a03-3b1e-47e1-be9a-3701d7cd853d"],
 ". And ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "CodeVariable"], 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"], 
   StyleBox["h", "CodeVariable"]}]], "InlineCodeText",ExpressionUUID->
  "2d4eebb3-c959-4562-be87-a7a3d3df579a"],
 " stands for anything with head ",
 Cell[BoxData[
  StyleBox["h", "CodeVariable"]], "InlineCodeText",ExpressionUUID->
  "ae20039e-cdf1-43ba-afe6-2d96945d7705"],
 ", and calls it ",
 Cell[BoxData[
  StyleBox["x", "CodeVariable"]], "InlineCodeText",ExpressionUUID->
  "fe684289-c15f-4e5a-accd-cbc1356401f5"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0067f869-09e6-4c89-9136-a1ad66f41b29"],

Cell[TextData[{
 "Define a function whose argument is an integer named ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2610d1a8-c61b-4386-9f30-26cc33492246"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b124aa07-b545-4f8c-a8a0-638509820598"],

Cell[BoxData[
 RowBox[{
  RowBox[{"digitback", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Framed", "[", 
   RowBox[{"Reverse", "[", 
    RowBox[{"IntegerDigits", "[", "n", "]"}], "]"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"ec9ea996-cbd3-4845-b2bd-02d6d9839fc4"],

Cell["The function evaluates whenever the argument is an integer:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd77b005-d8e2-4a4b-b336-f29ba59e5215"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"digitback", "[", "1234", "]"}], ",", 
   RowBox[{"digitback", "[", "6712", "]"}], ",", 
   RowBox[{"digitback", "[", "x", "]"}], ",", 
   RowBox[{"digitback", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"digitback", "[", 
    RowBox[{"2", "^", "32"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"1ee37cc0-9f94-4b1f-a263-baa35fbbc843"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}],
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "7", ",", "6"}], "}"}],
    StripOnInput->False], ",", 
   RowBox[{"digitback", "[", "x", "]"}], ",", 
   RowBox[{"digitback", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   FrameBox[
    RowBox[{"{", 
     RowBox[{
     "6", ",", "9", ",", "2", ",", "7", ",", "6", ",", "9", ",", "4", ",", 
      "9", ",", "2", ",", "4"}], "}"}],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"170a8505-e58c-49ed-a895-5fc2b369d2e8"]
}, Open  ]],

Cell[TextData[{
 "Sometimes you may want to put a condition on a pattern. You can do this \
with ",
 Cell[BoxData[
  ButtonBox["/;",
   BaseStyle->"Link",
   ButtonData->"Condition"]], "InlineCodeText",ExpressionUUID->
  "e7655d96-db2f-4bdd-bd86-15f2ce6d7aa8"],
 " (\[OpenCurlyDoubleQuote]slash semi\[CloseCurlyDoubleQuote]). ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], 
    ButtonBox["Integer",
     BaseStyle->"CodeLink"], 
    ButtonBox["/;",
     BaseStyle->"Link",
     ButtonData->"Condition"], "n"}], ">", "0"}]], "InlineCodeText",
  ExpressionUUID->"92e4c288-de1a-41de-b48a-7ff4d9ac4c3e"],
 " means any integer that is greater than 0."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"3594b72f-302b-4cf1-8ff0-ed6b914dfc26"],

Cell[TextData[{
 "Give a definition which only applies when ",
 Cell[BoxData[
  RowBox[{"n", ">", "0"}]], "InlineCode",ExpressionUUID->
  "942088e7-9539-4139-8b14-a3c3431a16e6"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad8da67e-1820-45c5-ab61-5352f43dd0bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdigitback", "[", 
   RowBox[{"n_Integer", "/;", 
    RowBox[{"n", ">", "0"}]}], "]"}], ":=", 
  RowBox[{"Framed", "[", 
   RowBox[{"Reverse", "[", 
    RowBox[{"IntegerDigits", "[", "n", "]"}], "]"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"55db4038-d9a2-4299-bcdf-6eaf33d39166"],

Cell["The definition doesn\[CloseCurlyQuote]t apply to negative numbers:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"accd1252-ad3d-436b-8913-f9fdcd0d839c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"pdigitback", "[", "1234", "]"}], ",", 
   RowBox[{"pdigitback", "[", 
    RowBox[{"-", "1234"}], "]"}], ",", 
   RowBox[{"pdigitback", "[", "x", "]"}], ",", 
   RowBox[{"pdigitback", "[", 
    RowBox[{"2", "^", "40"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"fcc21ef5-7e16-4b93-abf4-5e45f91ce68d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}],
    StripOnInput->False], ",", 
   RowBox[{"pdigitback", "[", 
    RowBox[{"-", "1234"}], "]"}], ",", 
   RowBox[{"pdigitback", "[", "x", "]"}], ",", 
   FrameBox[
    RowBox[{"{", 
     RowBox[{
     "6", ",", "7", ",", "7", ",", "7", ",", "2", ",", "6", ",", "1", ",", 
      "1", ",", "5", ",", "9", ",", "9", ",", "0", ",", "1"}], "}"}],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"d0b17a3b-a3b0-448c-99fe-c625e56b46ae"]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["/;",
   BaseStyle->"Link",
   ButtonData->"Condition"]], "InlineCodeText",ExpressionUUID->
  "51833461-3550-4473-9e9d-63f2e7b083e2"],
 " can go anywhere\[LongDash]even at the end of the whole definition. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"339c1a0b-928b-46b9-9f74-bc0dcbc52aa8"],

Cell["Define different cases of the check function:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a31779ed-757c-4128-907d-8739da308a66"],

Cell[BoxData[
 RowBox[{
  RowBox[{"check", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Red", "/;", 
   RowBox[{"x", ">", "y"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"6928bd00-f254-4dcd-be15-d133358932f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"check", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Green", "/;", 
   RowBox[{"x", "\[LessEqual]", "y"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"31cc19ab-532e-4049-9aec-8e72b069b51b"],

Cell["Some examples of the check function:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"037b46f0-20e2-4532-93aa-76712408194c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"check", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"check", "[", 
    RowBox[{"2", ",", "1"}], "]"}], ",", 
   RowBox[{"check", "[", 
    RowBox[{"3", ",", "4"}], "]"}], ",", 
   RowBox[{"check", "[", 
    RowBox[{"50", ",", "60"}], "]"}], ",", 
   RowBox[{"check", "[", 
    RowBox[{"60", ",", "50"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"86c03585-e5da-4714-ac54-1ffada806c74"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[7]=",ExpressionUUID->"4fb190b5-4f26-43e2-855e-e796e6e8b75e"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["__",
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCodeText",ExpressionUUID->
  "f9858c50-4a50-4ef8-81fc-9fb00776956e"],
 " (\[OpenCurlyDoubleQuote]double blank\[CloseCurlyDoubleQuote]) stands for \
any sequence of one or more arguments. ",
 Cell[BoxData[
  ButtonBox["___",
   BaseStyle->"Link",
   ButtonData->"BlankNullSequence"]], "InlineCodeText",ExpressionUUID->
  "9ac58897-d727-4aba-aa27-2fb86fd09a9e"],
 " (\[OpenCurlyDoubleQuote]triple blank\[CloseCurlyDoubleQuote]) stands for \
zero or more. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"dd39474e-f862-4a16-b7c0-32f4b2e3c526"],

Cell["\<\
Define a function that looks for black and white (in that order) in a list.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6e48bdbf-2cc1-4e6f-8bc6-e939cc43f0ef"],

Cell["\<\
The pattern matches black followed by white, with any elements before, \
between and after them: \
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a5dd1fb7-2825-4e8d-894f-1d2be3408446"],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackwhite", "[", 
   RowBox[{"{", 
    RowBox[{"___", ",", "Black", ",", "m___", ",", "White", ",", "___"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "m", ",", "2", ",", "m", ",", "3", ",", "m", ",", "4"}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"In[8]:=",ExpressionUUID->"0aa52fb3-9ae6-49bc-9f93-30ebb88753bd"],

Cell["\<\
Pick out the (smallest) sequence between a black and a white:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:250",ExpressionUUID->"5e1cac5f-115a-4ef9-8263-f46de25b8602"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"blackwhite", "[", 
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0.5, 0, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0.5, 0, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False]}], "}"}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[9]:=",ExpressionUUID->"57fbdd9e-a7f5-4052-8cb9-1c2af03bd5d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", "2", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", "3", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", "4"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[9]=",ExpressionUUID->"51bd3255-e64b-4480-bfe8-7450611c5d87"]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["__",
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCodeText",ExpressionUUID->
  "ac0ac987-d27b-4e67-bb85-ab90ab361225"],
 " and ",
 Cell[BoxData[
  ButtonBox["___",
   BaseStyle->"Link",
   ButtonData->"BlankNullSequence"]], "InlineCodeText",ExpressionUUID->
  "a9228bec-112c-405b-97ff-ef5b4239651d"],
 " pick the shortest matches that work. You can use ",
 ButtonBox["Longest",
  BaseStyle->"Link"],
 " to make them pick the longest instead. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"7ac52d6c-175a-49cb-a750-6e44ff65621d"],

Cell["\<\
Specify that the sequence between black and white should be as long as \
possible:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"002b2816-8dea-4f55-9e80-b272253a3edb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"blackwhitex", "[", 
   RowBox[{"{", 
    RowBox[{"___", ",", "Black", ",", 
     RowBox[{"Longest", "[", "m___", "]"}], ",", "White", ",", "___"}], "}"}],
    "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "m", ",", "2", ",", "m", ",", "3", ",", "m", ",", "4"}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"e397ebbc-dbcd-4e61-befb-df6591498af5"],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
 "m"], "InlineCode",ExpressionUUID->"9335f93d-0471-4018-b09c-3f5eed096a32"],
 " grabs elements all the way to the last white:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"249afbd5-415f-4763-8ba3-616c66cb8c43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"blackwhitex", "[", 
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0.5, 0, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0.5, 0, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False]}], "}"}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[11]:=",ExpressionUUID->"55e73d82-6b9b-41ce-bbb4-5972a2112dcd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->GrayLevel[0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "GrayLevel[1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["GrayLevelColorValueSelector"], {
           0, {Left, Bottom}}, {Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    GrayLevel[1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5, 0, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5, 0, 0.5],
    Editable->False,
    Selectable->False], ",", "2", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->GrayLevel[0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "GrayLevel[1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["GrayLevelColorValueSelector"], {
           0, {Left, Bottom}}, {Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    GrayLevel[1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5, 0, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5, 0, 0.5],
    Editable->False,
    Selectable->False], ",", "3", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->GrayLevel[0.6666666666666666],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "GrayLevel[1]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["GrayLevelColorValueSelector"], {
           0, {Left, Bottom}}, {Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    GrayLevel[1],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.33333333333333337`, 0., 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[0.5, 0, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0.5, 0, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[0.5, 0, 0.5],
    Editable->False,
    Selectable->False], ",", "4"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[11]=",ExpressionUUID->"2b1867fe-1aa9-41cd-93b9-02815b7077e6"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"x", "|", "y", "|", "z"}]], "InlineCodeText",ExpressionUUID->
  "11d1e206-f829-4e16-9f8b-11fe0d6a0390"],
 " matches ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "18c27a44-075f-4408-936a-ce3610c3d6db"],
 ", ",
 Cell[BoxData[
 "y"], "InlineCodeText",ExpressionUUID->
  "f02a8bd0-7b51-458b-915d-0b12bda5e73b"],
 " or ",
 Cell[BoxData[
 "z"], "InlineCodeText",ExpressionUUID->
  "b80d144c-aa0d-40ee-b271-6d8319b79ee1"],
 ". ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["..",
    BaseStyle->"Link",
    ButtonData->"Repeated"]}]], "InlineCodeText",ExpressionUUID->
  "eb898e84-50cf-4538-8507-e4a7e1a15a96"],
 " matches any number of repetitions of ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "e411b511-3e9f-40d2-b62e-b0edadfc3136"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"25d53ddd-71ab-4f1b-8edc-0e8495e080fe"],

Cell[TextData[{
 Cell[BoxData[
 "bwcut"], "InlineCode",ExpressionUUID->
  "df3ca5f4-2fac-4e59-99cc-21c9333116f8"],
 " effectively cuts out the longest run containing only black and white:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f4457219-f5c1-4d98-8eb3-3af97654361f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bwcut", "[", 
   RowBox[{"{", 
    RowBox[{"a___", ",", 
     RowBox[{"Longest", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Black", "|", "White"}], ")"}], ".."}], "]"}], ",", "b___"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", "Red", ",", 
    RowBox[{"{", "b", "}"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"9c0e28fb-1882-4a52-b371-bc2cd8cd031e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bwcut", "[", 
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False]}], "}"}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[13]:=",ExpressionUUID->"e48be22a-176a-4682-a822-4a195e1ce191"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[13]=",ExpressionUUID->"b9744ec3-c192-4863-b843-92a68f631bcc"]
}, Open  ]],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "13e92a8d-93ae-40db-8441-bc82bc42a616"],
 " is actually short for ",
 Cell[BoxData[
  RowBox[{"x", ":", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "68c46138-fb25-489f-be8a-1bfba8ee355d"],
 ", which means \[OpenCurlyDoubleQuote]match anything (i.e. ",
 Cell[BoxData[
  ButtonBox[
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"],
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "d6547d96-b2b3-4c85-a868-e22ac1009061"],
 ") and name the result ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "57fb2bf9-4c24-40e2-837a-32d06c633835"],
 "\[CloseCurlyDoubleQuote]. You can use notations like ",
 Cell[BoxData[
  RowBox[{"x", ":"}]], "InlineCodeText",ExpressionUUID->
  "33634061-93a6-4458-850f-a7b55830c064"],
 " for more complicated patterns too."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"ab0a32dc-7fb6-43d5-8bc6-b1e834d1feb7"],

Cell[TextData[{
 "Set up a pattern named ",
 Cell[BoxData[
 "m"], "InlineCode",ExpressionUUID->"aec2df02-83a3-4792-8b3b-9bc454f96539"],
 " that matches a list of two pairs: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"966eaf56-69e7-4428-8e22-c7970fb53f88"],

Cell[BoxData[
 RowBox[{
  RowBox[{"grid22", "[", 
   RowBox[{"m", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}]}], "}"}]}], "]"}], ":=", 
  RowBox[{"Grid", "[", 
   RowBox[{"m", ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"7ef3911a-0bda-43f9-835e-0505252f112c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"12", ",", "34"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"56", ",", "78"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{"123", ",", "456"}], "}"}], "]"}], ",", 
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"7265b3a4-b196-4d50-81e6-3140519f7b75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     AutoDelete->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Grid"], ",", 
   TagBox[GridBox[{
      {"12", "34"},
      {"56", "78"}
     },
     AutoDelete->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Grid"], ",", 
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{"123", ",", "456"}], "}"}], "]"}], ",", 
   RowBox[{"grid22", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"8ed25772-9508-4229-b53f-26a653cbe0ff"]
}, Open  ]],

Cell["\<\
Name the sequence of black and white, so it can be used in the result:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"01271a1e-aa01-4fae-9a5a-d3f5eb6d1290"],

Cell[BoxData[
 RowBox[{
  RowBox[{"bwcut", "[", 
   RowBox[{"{", 
    RowBox[{"a___", ",", 
     RowBox[{"r", ":", 
      RowBox[{"Longest", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Black", "|", "White"}], ")"}], ".."}], "]"}]}], ",", 
     "b___"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"Framed", "[", 
     RowBox[{"Length", "[", 
      RowBox[{"{", "r", "}"}], "]"}], "]"}], ",", 
    RowBox[{"{", "b", "}"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"840ae615-6743-4f74-aef2-5d449a569613"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bwcut", "[", 
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[
         0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0.5]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0.5],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[1],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->GrayLevel[0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "GrayLevel[0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["GrayLevelColorValueSelector"], {
            0, {Left, Bottom}}, {Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     GrayLevel[0],
     Editable->False,
     Selectable->False], ",", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False]}], "}"}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[17]:=",ExpressionUUID->"e0222c5e-63b0-4840-b430-17b009da8048"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   FrameBox["5",
    StripOnInput->False], ",", 
   RowBox[{"{", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[17]=",ExpressionUUID->"3ca7ffb9-cbcb-4f7b-b531-c8a8b6254a58"]
}, Open  ]],

Cell["\<\
As a final example, let\[CloseCurlyQuote]s use patterns to implement the \
classic computer science algorithm of sorting a list by repeatedly swapping \
pairs of successive elements that are found to be out of order. It\
\[CloseCurlyQuote]s easy to write each step in the algorithm as a replacement \
for a pattern.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "bubble-sort", 
   "i:7"},ExpressionUUID->"a5362192-9ab9-4f83-a78d-4d6105142581"],

Cell["\<\
Replace the first elements one finds out of order by ones that are in order: \
\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9133040b-8f4c-40e9-b876-ae6c40751e75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x___", ",", "b_", ",", "a_", ",", "y___"}], "}"}], "/;", 
    RowBox[{"b", ">", "a"}]}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b", ",", "y"}], "}"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"41cf0028-c095-4347-86af-f23d386c355f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[18]=",ExpressionUUID->"453bd4d0-f682-4a26-a949-36a59154b3f6"]
}, Open  ]],

Cell["\<\
Do the same operation 10 times, eventually sorting the list completely:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:251", "i:8"},ExpressionUUID->"d96c5ff3-4ee5-4f71-be21-446481f7a6f0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x___", ",", "b_", ",", "a_", ",", "y___"}], "}"}], "/;", 
        RowBox[{"b", ">", "a"}]}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "a", ",", "b", ",", "y"}], "}"}]}]}], ")"}], "&"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], ",", "10"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"7814fde1-618f-4951-af1c-44a43e8cf5ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"09c64c58-eb82-48ab-a3e9-3164645d7b3d"]
}, Open  ]],

Cell[TextData[{
 "At the beginning, we won\[CloseCurlyQuote]t know how long it\
\[CloseCurlyQuote]ll take to finish sorting a particular list. So the best \
thing is to use ",
 ButtonBox["FixedPointList",
  BaseStyle->"Link"],
 ", which is like ",
 ButtonBox["NestList",
  BaseStyle->"Link"],
 ", except that you don\[CloseCurlyQuote]t have to tell it a specific number \
of steps, and instead it just goes on until the result reaches a ",
 StyleBox["fixed point",
  FontSlant->"Italic"],
 ", where nothing more is changing."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "FixedPointList",ExpressionUUID->"a531f20c-f40f-4fd7-9270-038ad9886cf2"],

Cell["Do the operation until a fixed point is reached:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"e31035b6-7de4-42c1-8677-fba70bab2185"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x___", ",", "b_", ",", "a_", ",", "y___"}], "}"}], "/;", 
        RowBox[{"b", ">", "a"}]}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "a", ",", "b", ",", "y"}], "}"}]}]}], ")"}], "&"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"cff49405-9684-46eb-af32-194acabce307"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"f6cf75df-d1a4-4cf9-b5fe-2124058d1d3c"]
}, Open  ]],

Cell["\<\
Transpose to find the list of elements appearing first, second, etc. at \
successive steps:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"51e2b02d-f44b-4067-a0f3-de06ba582443"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "%", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"92705b0d-e9b6-4e2c-88c6-fd6dca58f362"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "4", ",", "4", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1",
      ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "1", ",", "4", ",", "4", ",", "3", ",", "3", ",", "3", ",", "2",
      ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "5", ",", "3", ",", "4", ",", "4", ",", "2", ",", "3",
      ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "3", ",", "3", ",", "5", ",", "5", ",", "2", ",", "4", ",", "4",
      ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "5", ",", "5", ",", "5",
      ",", "5"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"50b069eb-b28b-439b-9751-bd2b0d9951e5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["ListLinePlot",
  BaseStyle->"Link"],
 " plots each list in a different color, showing how the sorting process \
proceeds: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f6f6c916-79dd-4677-beda-6c670fed3bd0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "%", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"7aa0e382-dfeb-442f-8ed1-efce2352e740"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 4.}, {2., 4.}, {3., 1.}, {4., 1.}, {5., 1.}, {6., 1.}, {7.,
       1.}, {8., 1.}, {9., 1.}}]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 5.}, {2., 1.}, {3., 4.}, {4., 4.}, {5., 3.}, {6., 3.}, {7.,
       3.}, {8., 2.}, {9., 2.}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 1.}, {2., 5.}, {3., 5.}, {4., 3.}, {5., 4.}, {6., 4.}, {7.,
       2.}, {8., 3.}, {9., 3.}}]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 3.}, {2., 3.}, {3., 3.}, {4., 5.}, {5., 5.}, {6., 2.}, {7.,
       4.}, {8., 4.}, {9., 4.}}]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.019444444444444445`],
      AbsoluteThickness[1.6], 
     LineBox[{{1., 2.}, {2., 2.}, {3., 2.}, {4., 2.}, {5., 2.}, {6., 5.}, {7.,
       5.}, {8., 5.}, {9., 5.}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->180,
  Method->{},
  PlotRange->{{0., 9.}, {0, 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"3817b79f-cb86-4db2-88c0-bc4a5a714134"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the result for sorting a random length-20 \
list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6b74927c-1096-4bfd-9366-13f65dab7707"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"FixedPointList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "/.", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x___", ",", "b_", ",", "a_", ",", "y___"}], "}"}], "/;", 
          RowBox[{"b", ">", "a"}]}], "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"x", ",", "a", ",", "b", ",", "y"}], "}"}]}]}], ")"}], 
      "&"}], ",", 
     RowBox[{"RandomSample", "[", 
      RowBox[{"Range", "[", "20", "]"}], "]"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"82fad62f-7c76-4861-aea7-59a697561ad9"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdzTlKREEUhtEfI0MDAwODVkRERNp5tp/zPLXtBgRjt1BLqyW5BJV+NLxT
UFxOfVxq4fN7+DWVZPR3/+f4/AzGs9+0D+3stXMaz+BZPIfnm+4/PbyIl/Ay
XsGreA2v4z7ewJt4C2/jHbyL9/A+PsCH+Agf4xN8ige46brgnNFxzuk4F3Sc
SzrOFR3nmo5zQ8e5pePc0XHu6TgPdJxHOs4THeeZjvNCx3ntusEFV5w39nHB
FWfIPi644ryzjwuuOCP2ccEV52PiX99GmtA=
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxdzjlKBEEAheGHkaGBgYGBisggIuO+O+W+b+N4AcHYK9TR+kgeQWWagf4a
msfXP1X04uf38Gsqyejv/d/x8zMY70JpP7Tbb3e63V67M3gWz5XuvfOle7+7
hJfxCv/Vw6t4Da/jPt7Am3gLb+MdvIv38D4+wIf4CB/jE3yKB7h0XXHO6Djn
dJwLOs4lHeeKjnNNx7mh49zSce7oOPd0nAc6ziMd54mO80zHeaHjvHZdcMUN
zhvnccUNzpDzuOIG553zuOIGZ8R5XHGD8zHxL9EMU2U=
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJx100lKxFAUhtEfRw4dOHDgQEVERMS+14p935XlBgTHbuEtLUtyCSr1SsgB
A+Fy8nEfySCz75/9j7Ekg5/7dw6vr95wLjb1QdP1eJ2rdU7gyaZ7zhT703gG
z+F53mPhn72Rl/AyXsGreA2v1zn6zg28ibfwNt7Bu3gP7+MDfIiP8DHu4abr
gnNCxzml45zRcc7pOBd0nEs6zhUd55qOc0PHuaXj3NVZ/5uCc0/HeaDjPNJx
nug4z103uOAW54V9XHCL02cfF9zivLKPC25xBuzjgluctz9/A6PwV4U=
      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd00tOAkEUheETRg4dOHDgQIkxhhjTCIIK2AUC4guwxQ2YOHYLd2m1JJYA
hFsm9VfSOfn65Ka7kqqzn7/qtyZptX12uV/rcp83wV+E3AfwYcjnjtyF5zF8
Ap/CdXz33PPS8wJmNuAr+Bou4KZn2lfaZ/rPFtyGb+EO3IXv4Hv4Ae7BfXgA
P8IlHHIbrCF6WCP0yekcPOU2WGP0sCboYU3Rw3pGD2uGHtYLeliv6JPTPXnz
9PNksN7Rw/pAD2uOHtYCPaxl7gAbHGF9Yh42OMKqMA8bHGF9YR42OMJaYR42
OML6/vcG2mVaMw==
      "]]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd081KQkEYxvEHVy1btGjRwg4hIRFmmabWOWnfZerxdAOCa2/hvbS5JC8h
xXeE+Q8cHn48vDMchjlfrstVTVK1/Xa5X5s8TRWpj+Bjd9vzBD6Fz+B6kZ6T
ebY8L+AGfAk3Pa89r2BmnIv/cYN92/AtfAd34HvPzLML9+AHuA8P4CH8CD/B
OVykNljP6GGNPP3eLTre6zi1wXpBD+sVPaw39LDe0cP6QA/rEz2sL09/FxYd
38F3aoP1gx7WBD2sX/SwpuhhzVIXsMEB1hzzsMEBVol52OAAa4F52OAAq8I8
bHCA9XfwP1KvXT0=
      "]]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJx11MtOwkAYxfETViy7YMHChTaEEGOIVEXEC+XmXZBSX4DEta8wjzaP5COo
4ftI+o80aU5/PTNJJ+30aPNVfNYklb/nX26P75Fd5P9nHU7gBtyED+BDy8wy
hVtwG+5Ydi2PLU8tT2Afl+y534Mz+Aw+hy+wjj6e8xIewFfw0NLXfQ3fwLfw
HTyC86oDrDF6t7/niWVqPawpelgz9LDm6GHdo4f1gB7WI3pYT+jdvg+eLe07
DrBe0MN6RQ/rDT2sBXpYS/Sw3qvO3bZPAxxhrarO4QBHWAXmwwGOsNaYDwc4
wioxHw5u+49FWB87/wDVcVtw
      "]]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJx11MtKw0AYxfGDK5dduHDhwhYREZEa6/2SsdqL9V7jCwiufYXv0eaRfASV
fF9h/tBAOPxyGDKTTNL9/J5/rUhq/s7/bI+fus395BdS6VW4A6/B6/AGvAn3
4C14G97xrDx34b0l8+wvyQO4gg/hAeZ9hPscwyfwKXzmGes894x1XsCX8BV8
DddwKm2wbjz9vVo45jcsbbBu0cO6Qw9rhD4c+2Jc2mBN0MOaood17+n73sI9
z1lpg/WAHtYjelhP6GE9o4f1gh7Wq6d/lyns36XBGdZb6QQbnGHNMR42OMN6
x3jY4Ayrwfiw/7cs7M8nw/pY+BdEVV1W
      "]]}, 
    {RGBColor[1, 0.75, 0], PointSize[0.008333333333333333], AbsoluteThickness[
     1.6], LineBox[CompressedData["
1:eJxd1ElOAlEUheETRwwdMHDAQAkhhhCjonQqPHuxQdoNkDh2C3dpb0ksQUjd
a1J/JZWTr05e1atXzcnmd/FzIGm12/dZbNtxkYfJD6SyKzCzCh/BNfgYrsMN
uAmfwi247XnpeQafwxcws4N5XuE813AX7sF9z7ivAeY5hG/gW/jOM9ZhBI/h
VLaF4znee/o6G6wH9LAe0cN6Qg/r2dPfAwvHer2UbbBe0cN6Qx+O93yC68N6
Rw/rAz2sT/SwvtDDmqKH9Y0+HN/hzLNeZIINzrDmGA8bnGEtMB42OMNaYjxs
cIa18vT/VAr7f8ngDGv97z9tR1xs
      "]]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1E1OwlAUxfETRgwZOGDAAIgxhBCDgCiCUL/4UkERNmDi2C3cpb0lsQQh
3GvSf5Pm5PdOXtPX17b2/bv5KUjaHs5jno795JT1zAeyvItwCT6Dy3AFrsLM
c/gCbsBNuAVfwm34Cu7AXYz34Gu4D994xjpucR8D+A4ewiPPWPe9Z6xzDE/g
zNP3zcJxvYe8DdYjelhP6GE9ow/Hvr94+j4brCl6WDP0sOae/l5bOPZnkbfB
WqKH9Yoe1ht6WO/oYa3Qw1p7+ndn4Xi+H3lnsMEJ1ifmwwYnWBvMhw1OsL4w
HzY4heO/tPWs+3zY4ARr9+8/istdgA==
      "]]}, 
    {RGBColor[0.571589, 0.586483, 0.], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1EtOAkEUheETRg4dMGDgQAkhxBgD8vLdJaICykPADZg4dgt3abUkl6CG
e0n676Rz8vVJdVJd1XXy+b3+qkja/t3/ubt+il02kz9IZR/Ah3AVrsFH8DFc
hxswswWfwmfwOdyGO/AF3IV7cB8ewEO89xK+gq/hG8+Y5y3mcQffw4VnrFPy
9O9isB7Qwxqhh/WIHtbY09fZwjG/p7IN1jN6WC/ow7GPJ56+jwzWFD2sGXpY
r+hhvaGHNUcPa4E+HP/Z0tP3n8FalZ1ggzOsd4yHDc6w1hgPG5xhbTAetrCf
Qzkc58q27AQbnGF97P0LHVFeFA==
      "]]}, 
    {RGBColor[0.915, 0.3325, 0.2125], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1EtOAkEUheETRw4dMHDgQAkhxhiCCuKbAgUFRbFpN2Di2C3cpdWSXIIa
7iWpv5POydcnlVR3ddXB53f1tSWp/rv/c339DNd5lPxBKr0N78ANeBfeg/fh
JtyC2/AhzDyGO3AXPoFP4TO4B/fhc3gAX8CX8BV8jXndwLfwnWesy9Az3juV
Nlgj9LDG6GHdow/Huj54+roYrAl6WFP0sB49/b+1cHzPp9IGa4Ye1hw9rGf0
sF7Qw1qgh/Xq6fvKwrEv3kobrGXpBBucYb1jPGxwhlVhPGxwhrXC+LCfOxb2
cyPDqksn2OAM62PjXwSfXrw=
      "]]}, 
    {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
     0.008333333333333333], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1E1OQjEYheETRgwdOHDAAI0xxhCCooiA3AKC+AeCuAESxmzhW1qX5BKE
8JWk702ak6cnHdzb3p6vt8tNSdJqN/Z5eP6KQ54Gnwi5y/AJzDyDK3AVvoAv
4Sv4Gr6Ba3AdbsC38B3chO/hB7gFP8Jt+AnuwF24Bz/DfbxHAYfcBmuAHtYQ
PayRp++jJafv/pLbYI3Rw5qgT07n9NXT991gTdHDekMP6x09rA/0sD7Rw/pC
n5z+o5mnn3uDNUcP6zt3gA2OsBZYDxscYS2xHjY4wvrx9HsmJPu9YHCEtcod
YIMjrN+j/wESAVy4
      "]]}, 
    {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
     PointSize[0.008333333333333333], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1EtOAkEUheETRwwZOHDAAIwxxhiC4APw0QXIQ8EHCBsgYcwW7tJqSS5B
CLdI6u+kcvLVSU2663ZtvV1sTiQtd2ufh+evOORF8I2QuwSX4VP4DK7AVfgc
Zl7CV/A1fAPX4QZ8CzfhFnwH38MP8CPchjtwF36Cn+EX+BUu4JDbYPXQw+qj
hzXw9PdosN7QwxqihzXy9Htpyem7jnMbrAl6WO/oYX2ghzVFD2uGHtanp8+N
Jad7/JXbYH2jh/WTO8AGR1hznE/2uTM4wlrkDrDBMTn9V349fe4DbHCEtcR5
2OAIa3X0Py6KXog=
      "]]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
     0.008333333333333333], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1E1OwlAUhuEvjBg6cOCAARpjjCEERREB6QUE8Q8EcQMkjNnCWdpdkksQ
wrkk923SnDx903TQnp6vt8tNSdJqd+7n4fgrDrMc/ELIzXkCn8JncAWuwhfw
JXwFX8M3cA2uww34Fr6Dm/A9/AC34Ee4DT/BHbgL9+BnuA8XcMhtsAbosIbo
sEbosF7QYY3RYU18+nsyWK/osKbosN7QYb2jw/pAT07f2WduS0578uXTv1OD
NUOHNUeH9Z07wAZHWAufvmch2ffM4AhrmTvAluz/kZic9voHz4cNjrBWuB82
OML6PfofvcVZ7A==
      "]]}, 
    {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
     0.008333333333333333], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1EtqAkEURuGfjBw6cODAQRQRCSLxFaOJdvl+J8bHBgTHbqGWVkvKElSs
Euo0NJevT9esb+dPl935RdLhdt/n4/pPHrNm/AMTOwWn4QychXPwK1yAi3AJ
LsNvcAWuwu8wZx1uwE24BX/AbfgT7sBd+Av+hntwH05gE9vCGqDDGqLDGqHD
GqPDmqDDmqLDmqHDmqPDWqDDWqLDWqEHh+9q7affC7uO39cG52H9oMP6RYe1
jW1gC7vgsFd/fvo9MrCFHawdzgf7/4YN9nvrYO1jG9jCDtYB52ELO1jHp698
hmDq
      "]]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1DlKBUEUhtEfI0MDAwMDFREREedZXzvP0/O5AcHYLdTSekkuQcVqoU9D
cTn9UVnfnn3/HH6MJRn9nN/593wN/uZ0U180fY/jCTyJp7BzBs/hebyAF/ES
XsYreBWv4XW8gTfxFt7GO3gX7+F9fIAP8RE+xgPc9F1wTug4p3ScMzrOOR3n
go5zSce5ouNc03Fu6Di3dJw7Os59nfU7KzgPdJxHOs4THee57waXznWP2s7d
nrz03eCCW5xhnfU/0XSue1lwi/Pad4MLbnFG3McFtzhv//4G4tBcnw==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1ElKRDEYhdGLI4cOHDhwoCIiImLfa8W+78pyA4Jjt5ClvSW5BJV6VfBO
IPycfGSYzH9+978mkgz+9v8crp/ecK6W9qB0PYmn8DSewbN4Di/gRbyEl/EK
dq7hdbyBN/EW3sY7eBfv4X18gA/xET7GJ/gU93DpuuKc0XHO6TgXdJxLOs4V
HeeajnNDx7ml49zRce7pOA90nEc6zhMd55mO80LHee264Dpy+w4anLeuC664
GXn0L/Tb2b67gitucN65jytucAbcxxU3OB9j/wKnKF/p
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1DlKBEEYhuEPI0MDAwMDFREREfddp933bRwvIBh7hTpaHckjqMz0QD8F
xc/TL39YPf/53f+aSDL4u/9zeH56w7ndjD40XU/iKTyNZ/AsnsMLeBEv4WW8
glfxGl7HG3gTb2HnDt7Fe3gfH+BDfISP8Qk+xT3cdF1wzug453ScCzrOJR3n
io5zTce5oePc0nHu6Dj3dJwHOs4jHeeJjvNMx3mh47x23eCCK84b+7i0Hv0H
auv2XfW7bnDBFeedfVxwxRmwjwuuOB9j/wIwy2IG
      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd1DlKBEEYhuEPI0MDAwMDFREREfddp933bRwvIBh7hTpaHckjqMz0QD8F
xc/TL39YPf/53f+aSDL4u/9zeH56wznTjD40XU/iKTyNnbN4Di/gRbyEl/EK
XsVreB1v4E28hbfxDt7Fe3gfH+BDfISP8Qk+xT3cdF1wzug453ScCzrOJR3n
io5zTce5oePc0nHu6Dj3dJwHOs4jHeeJjvNMx3mh47x23eCCK84b+7i0Hr2T
itPvusEFV5x39nHBFWfAPi64tm7/Ax9j/wIn1lqw
      "]]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.008333333333333333], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJxd00lKQ0EUhtEfRw4dOHDgQEVERMQu9ppn38Ymxg0IGWcLtbRakktQiRHe
KSgupz7usBY/R/3hVJLBz/2d4/PVHc+d5u+haXsaz+BZPIfn8QJewst4Ba/i
NbyON/Am3sLb2LmLO3gP7+MDfIiP8DE+waf4DHdx03bBOafjXNBxLuk4V3Sc
azrODR3nlo5zR8e5p+M80HEe6ThPdJweHeeZjvNCx3ltu8EFV5w39nHBFafP
Pi644ryzjwuuOAP2ccF14sm///j3N3qYYew=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{214.7265625, Automatic},
  Method->{},
  PlotRange->{{0., 84.}, {0, 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[23]=",ExpressionUUID->"aa6aee6c-8a95-4d81-8f6a-82d804be47d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:252",ExpressionUUID->"8c900324-2812-4500-82b4-4b2bf649df20"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["patt", "CodeVariableLrg"], 
     ButtonBox["/;",
      BaseStyle->"CodeLink",
      ButtonData->"Condition"], 
     StyleBox["cond", "CodeVariableLrg"]}], " ", Cell[
    "a pattern that matches if a condition is met", "VocabularyText",
     ExpressionUUID->"0dd32930-029f-4fa2-aaaf-580d64594273"]},
   {
    ButtonBox[
     RowBox[{"_", "\[ThinSpace]", "_", "\[ThinSpace]", "_"}],
     BaseStyle->"CodeLink",
     ButtonData->"BlankNullSequence"], " ", Cell["\<\
a pattern for any sequence of zero or more elements \
(\[OpenCurlyDoubleQuote]triple blank\[CloseCurlyDoubleQuote])\
\>", "VocabularyText",ExpressionUUID->"06f9ab2f-e705-4de8-809f-dd708a1aad63"]},
   {
    RowBox[{
     StyleBox["patt", "CodeVariableLrg"], 
     ButtonBox["..",
      BaseStyle->"CodeLink",
      ButtonData->"Repeated"]}], " ", Cell[TextData[{
     "a pattern for one or more repeats of ",
     Cell[BoxData[
      StyleBox["patt", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "fa29cab5-9e47-433c-a961-23c00492be87"]
    }], "VocabularyText",ExpressionUUID->
     "6341d66e-96a8-4947-840f-cddfdf85e21e"]},
   {
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["patt", "CodeVariableLrg"], "]"}], " ", Cell[
    "a pattern that picks out the longest sequence that matches", 
     "VocabularyText",ExpressionUUID->"5de5f3f2-8c2b-42e2-84c2-64a0281eac62"]},
   {
    RowBox[{
     ButtonBox["FixedPointList",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["f", "CodeVariableLrg"], ",", 
      StyleBox["x", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "keep nesting ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "f1d9647e-3bd4-4059-9a1b-00571f0ca361"],
     " until the result no longer changes"
    }], "VocabularyText",ExpressionUUID->
     "6e0f664c-6805-4c98-ba5d-061cdab1e6ef"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1e4b360c-0cae-454c-97ed-0bfbdd61c324"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"5049bd0f-9205-4311-8436-574cb986eb48"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"12 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-41-more-about-patterns-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"003f00fe-de11-4c6f-ad67-73cc4c3749f3"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the list of digits for squares of numbers less than 100 that contain \
successive repeated digits.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"52899fa5-0917-4fe6-b805-c19a29a842f8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "5", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "0", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "6", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "8", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "8", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "9", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "7", ",", "7", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "8", ",", "8", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "7", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "8", ",", "3", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "1ccec279-a231-4f11-8860-89a0ddd6904b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "4", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "5", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "4", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "1", ",", "1", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "0", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "3", ",", "6", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "8", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "4", ",", "8", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "9", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "7", ",", "7", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "4", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "8", ",", "8", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "2", ",", "2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "7", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "8", ",", "3", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
            "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"80836a21-a1bd-4da8-876e-d0dedea96ab6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "In the first 100 Roman numerals, find those containing L, I and X in that \
order.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"32e5fc39-0705-4fe3-90f6-5f6d5e02a2ae"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"XLIX\"\>", ",", "\<\"LIX\"\>", ",", "\<\"LXIX\"\>", 
         ",", "\<\"LXXIX\"\>", ",", "\<\"LXXXIX\"\>"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "f271173a-50d1-4ae9-967e-b0a622125826"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"XLIX\"", ",", "\"LIX\"", ",", "\"LXIX\"", ",", 
             "\"LXXIX\"", ",", "\"LXXXIX\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"43e86cbf-53a6-493e-94a4-af0e8d7399c6"]
}, Closed]],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"46b4f8d7-bf66-4250-b56b-aaa3a0d73f00"],
 " that tests whether a list of integers is the same as its reverse.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"6762777e-0e78-4e5e-8e44-d4d9e090805c"],

Cell[CellGroupData[{

Cell[TextData[{
 "Get a list of pairs of successive words in the Wikipedia article on \
alliteration that have identical first letters.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"27983a0f-6894-49e1-855a-db33c1e7de63"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\<\"same\"\>", ",", "\<\"sounds\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"or\"\>", ",", "\<\"of\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"stressed\"\>", ",", "\<\"syllables\"\>"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"\<\"alphabet\"\>", ",", "\<\"and\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"lazy\"\>", ",", "\<\"languid\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Peter\"\>", ",", "\<\"Piper\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Piper\"\>", ",", "\<\"Picked\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Pickled\"\>", ",", "\<\"Peppers\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"wind\"\>", ",", "\<\"will\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"agreement\"\>", ",", "\<\"akin\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"stressed\"\>", ",", "\<\"syllable\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"alliterating\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"of\"\>", ",", "\<\"outside\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"same\"\>", ",", "\<\"sound\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"of\"\>", ",", "\<\"outside\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"brown\"\>", ",", "\<\"blazers\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"fundamentally\"\>", ",", "\<\"for\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"colour\"\>", ",", "\<\"co-ordination\"\>"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"\<\"in\"\>", ",", "\<\"its\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"silken\"\>", ",", "\<\"sad\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"furrow\"\>", ",", "\<\"followed\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"followed\"\>", ",", "\<\"free\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"stood\"\>", ",", "\<\"still\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Alphabetical\"\>", ",", "\<\"Africa\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"chapter\"\>", ",", "\<\"consists\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"at\"\>", ",", "\<\"all\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"written\"\>", ",", "\<\"with\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Brent\"\>", ",", "\<\"Bernard\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"who\"\>", ",", "\<\"watch\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"watch\"\>", ",", "\<\"with\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"with\"\>", ",", "\<\"wild\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"wild\"\>", ",", "\<\"wonder\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"wide\"\>", ",", "\<\"window\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"beautiful\"\>", ",", "\<\"birds\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"birds\"\>", ",", "\<\"begin\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bountiful\"\>", ",", "\<\"birdseed\"\>"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"\<\"Grey\"\>", ",", "\<\"Geese\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"grey\"\>", ",", "\<\"geese\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Betty\"\>", ",", "\<\"Botter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Betty\"\>", ",", "\<\"Botter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"butter\"\>", ",", "\<\"but\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"she\"\>", ",", "\<\"said\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"butter's\"\>", ",", "\<\"bitter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"it\"\>", ",", "\<\"in\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"make\"\>", ",", "\<\"my\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"batter\"\>", ",", "\<\"bitter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bitter\"\>", ",", "\<\"but\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"better\"\>", ",", "\<\"butter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"make\"\>", ",", "\<\"my\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bitter\"\>", ",", "\<\"batter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"batter\"\>", ",", "\<\"better\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Peter\"\>", ",", "\<\"Piper\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Piper\"\>", ",", "\<\"Peter\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Peter\"\>", ",", "\<\"Piper\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"pickled\"\>", ",", "\<\"peppers\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Peter\"\>", ",", "\<\"Piper\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"pickled\"\>", ",", "\<\"peppers\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"pickled\"\>", ",", "\<\"peppers\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Peter\"\>", ",", "\<\"Piper\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Irish\"\>", ",", "\<\"It\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"important\"\>", ",", "\<\"ingredient\"\>"}], "}"}], 
         ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"\[CapitalAE]thelwulf\"\>", 
           ",", "\<\"\[CapitalAE]thelbald\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"\[CapitalAE]thelbald\"\>", 
           ",", "\<\"\[CapitalAE]thelberht\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"direct\"\>", ",", "\<\"descendants\"\>"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"\<\"Tancred\"\>", ",", "\<\"Torhtred\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"poetry\"\>", ",", "\<\"poets\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"can\"\>", ",", "\<\"call\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"splendid\"\>", ",", "\<\"silent\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"silent\"\>", ",", "\<\"sun\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Walt\"\>", ",", "\<\"Whitman\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Splendid\"\>", ",", "\<\"Silent\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Silent\"\>", ",", "\<\"Sun\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"wondered\"\>", ",", "\<\"what\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"his\"\>", ",", "\<\"horse\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"also\"\>", ",", "\<\"add\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"harsh\"\>", ",", "\<\"hard\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"they\"\>", ",", "\<\"than\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"slippered\"\>", ",", "\<\"sleep\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"lean\"\>", ",", "\<\"lithe\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"fleet\"\>", ",", "\<\"flown\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"E.\"\>", ",", "\<\"E.\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"an\"\>", ",", "\<\"artistic\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"that\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"out\"\>", ",", "\<\"of\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"an\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"an\"\>", ",", "\<\"artistic\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"constraint\"\>", ",", "\<\"can\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"it\"\>", ",", "\<\"is\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"emotional\"\>", ",", "\<\"effect\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"and\"\>", ",", "\<\"attention\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"persuasive\"\>", ",", "\<\"public\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"any\"\>", ",", "\<\"attitude\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"adds\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"an\"\>", ",", "\<\"audience\[CloseCurlyQuote]s\"\>"}], 
          "}"}], ",", 
         RowBox[{"{", 
          
          RowBox[{"\<\"audience\[CloseCurlyQuote]s\"\>", 
           ",", "\<\"attention\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"noticeable\"\>", ",", "\<\"nature\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"evokes\"\>", ",", "\<\"emotion\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"an\"\>", ",", "\<\"audience\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"them\"\>", ",", "\<\"to\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"can\"\>", ",", "\<\"create\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"is\"\>", ",", "\<\"in\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"twenty-one\"\>", ",", "\<\"times\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"times\"\>", ",", "\<\"throughout\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"as\"\>", ",", "\<\"an\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"which\"\>", ",", "\<\"we\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"our\"\>", ",", "\<\"only\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"of\"\>", ",", "\<\"our\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"our\"\>", ",", "\<\"own\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"but\"\>", ",", "\<\"by\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"today\"\>", ",", "\<\"that\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"that\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"truths\"\>", ",", "\<\"that\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"is\"\>", ",", "\<\"inextricably\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"itself\"\>", ",", "\<\"is\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"testimony\"\>", ",", "\<\"to\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"have\"\>", ",", "\<\"had\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"because\"\>", ",", "\<\"brave\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"freedom's\"\>", ",", "\<\"front\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Ronald\"\>", ",", "\<\"Reagan\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Vietnam\"\>", ",", "\<\"Veterans\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"new\"\>", ",", "\<\"nation\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"to\"\>", ",", "\<\"the\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"modern\"\>", ",", "\<\"music\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"cartoon\"\>", ",", "\<\"characters\"\>"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"\<\"If\"\>", ",", "\<\"I\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Anadiplosis\"\>", ",", "\<\"Assonance\"\>"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"\<\"Tautogram\"\>", ",", "\<\"Tongue\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\<\"alliterations\"\>", ",", "\<\"and\"\>"}], "}"}]}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "8ba16e31-747f-46e6-837b-f73da5819f28"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"\"same\"", ",", "\"sounds\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"or\"", ",", "\"of\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"stressed\"", ",", "\"syllables\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"alphabet\"", ",", "\"and\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"lazy\"", ",", "\"languid\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Peter\"", ",", "\"Piper\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Piper\"", ",", "\"Picked\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Pickled\"", ",", "\"Peppers\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"wind\"", ",", "\"will\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"agreement\"", ",", "\"akin\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"stressed\"", ",", "\"syllable\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"alliterating\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"of\"", ",", "\"outside\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"same\"", ",", "\"sound\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"of\"", ",", "\"outside\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"brown\"", ",", "\"blazers\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"fundamentally\"", ",", "\"for\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"colour\"", ",", "\"co-ordination\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"in\"", ",", "\"its\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"silken\"", ",", "\"sad\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"furrow\"", ",", "\"followed\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"followed\"", ",", "\"free\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"stood\"", ",", "\"still\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Alphabetical\"", ",", "\"Africa\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"chapter\"", ",", "\"consists\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"at\"", ",", "\"all\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"written\"", ",", "\"with\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Brent\"", ",", "\"Bernard\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"who\"", ",", "\"watch\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"watch\"", ",", "\"with\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"with\"", ",", "\"wild\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"wild\"", ",", "\"wonder\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"wide\"", ",", "\"window\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"beautiful\"", ",", "\"birds\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"birds\"", ",", "\"begin\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"bountiful\"", ",", "\"birdseed\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Grey\"", ",", "\"Geese\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"grey\"", ",", "\"geese\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Betty\"", ",", "\"Botter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Betty\"", ",", "\"Botter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"butter\"", ",", "\"but\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"she\"", ",", "\"said\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"butter's\"", ",", "\"bitter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"it\"", ",", "\"in\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"make\"", ",", "\"my\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"batter\"", ",", "\"bitter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"bitter\"", ",", "\"but\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"better\"", ",", "\"butter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"make\"", ",", "\"my\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"bitter\"", ",", "\"batter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"batter\"", ",", "\"better\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Peter\"", ",", "\"Piper\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Piper\"", ",", "\"Peter\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Peter\"", ",", "\"Piper\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"pickled\"", ",", "\"peppers\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Peter\"", ",", "\"Piper\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"pickled\"", ",", "\"peppers\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"pickled\"", ",", "\"peppers\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Peter\"", ",", "\"Piper\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Irish\"", ",", "\"It\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"important\"", ",", "\"ingredient\""}], "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"\[CapitalAE]thelwulf\"", ",", "\"\[CapitalAE]thelbald\""}],
                "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"\[CapitalAE]thelbald\"", ",", 
                 "\"\[CapitalAE]thelberht\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"direct\"", ",", "\"descendants\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Tancred\"", ",", "\"Torhtred\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"poetry\"", ",", "\"poets\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"can\"", ",", "\"call\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"splendid\"", ",", "\"silent\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"silent\"", ",", "\"sun\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Walt\"", ",", "\"Whitman\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Splendid\"", ",", "\"Silent\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Silent\"", ",", "\"Sun\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"wondered\"", ",", "\"what\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"his\"", ",", "\"horse\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"also\"", ",", "\"add\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"harsh\"", ",", "\"hard\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"they\"", ",", "\"than\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"slippered\"", ",", "\"sleep\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"lean\"", ",", "\"lithe\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"fleet\"", ",", "\"flown\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"E.\"", ",", "\"E.\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"an\"", ",", "\"artistic\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"that\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"out\"", ",", "\"of\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"an\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"an\"", ",", "\"artistic\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"constraint\"", ",", "\"can\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"it\"", ",", "\"is\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"emotional\"", ",", "\"effect\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"a\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"and\"", ",", "\"attention\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"a\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"persuasive\"", ",", "\"public\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"any\"", ",", "\"attitude\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"a\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"adds\"", ",", "\"a\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"an\"", ",", "\"audience\[CloseCurlyQuote]s\""}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "\"audience\[CloseCurlyQuote]s\"", ",", "\"attention\""}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"noticeable\"", ",", "\"nature\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"evokes\"", ",", "\"emotion\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"an\"", ",", "\"audience\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"them\"", ",", "\"to\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"can\"", ",", "\"create\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"is\"", ",", "\"in\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"twenty-one\"", ",", "\"times\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"times\"", ",", "\"throughout\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"as\"", ",", "\"an\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"which\"", ",", "\"we\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"our\"", ",", "\"only\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"of\"", ",", "\"our\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"our\"", ",", "\"own\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"but\"", ",", "\"by\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"today\"", ",", "\"that\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"that\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"truths\"", ",", "\"that\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"is\"", ",", "\"inextricably\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"itself\"", ",", "\"is\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"testimony\"", ",", "\"to\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"have\"", ",", "\"had\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"because\"", ",", "\"brave\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"freedom's\"", ",", "\"front\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Ronald\"", ",", "\"Reagan\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Vietnam\"", ",", "\"Veterans\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"new\"", ",", "\"nation\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"to\"", ",", "\"the\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"modern\"", ",", "\"music\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"cartoon\"", ",", "\"characters\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"If\"", ",", "\"I\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"Anadiplosis\"", ",", "\"Assonance\""}], "}"}], ",", 
             
             RowBox[{"{", 
               RowBox[{"\"Tautogram\"", ",", "\"Tongue\""}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"\"alliterations\"", ",", "\"and\""}], "}"}]}], "}"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c920c8f5-e844-450b-b2c6-ef81f7311091"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Grid",
  BaseStyle->"Link"],
 " to show the ",
 ButtonBox["sorting process in this section",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-41-more-about-patterns.nb", "bubble-sort"}],
 " for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"71cb4b6c-ffbd-43ce-804c-b4a3c5538522"],
 ", with successive steps going down the page.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"cbf6f0a9-5e54-4c0a-8d34-f20c5af01d6f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {"4", "5", "1", "3", "2"},
          {"4", "1", "5", "3", "2"},
          {"1", "4", "5", "3", "2"},
          {"1", "4", "3", "5", "2"},
          {"1", "3", "4", "5", "2"},
          {"1", "3", "4", "2", "5"},
          {"1", "3", "2", "4", "5"},
          {"1", "2", "3", "4", "5"},
          {"1", "2", "3", "4", "5"}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "189731e6-93cc-42af-9ddb-0195b0d18397"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          
          GridBox[{{"4", "5", "1", "3", "2"}, {"4", "1", "5", "3", "2"}, {
            "1", "4", "5", "3", "2"}, {"1", "4", "3", "5", "2"}, {
            "1", "3", "4", "5", "2"}, {"1", "3", "4", "2", "5"}, {
            "1", "3", "2", "4", "5"}, {"1", "2", "3", "4", "5"}, {
            "1", "2", "3", "4", "5"}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8e720abb-29aa-4849-a7cd-9058fc2c4d99"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["ArrayPlot",
  BaseStyle->"Link"],
 " to show the ",
 ButtonBox["sorting process in this section",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-41-more-about-patterns.nb", "bubble-sort"}],
 " for a list of length 50, with successive steps going across the page.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2addc280-9998-47a0-9c88-1e9de94a587f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1y4jYUBuBsmnZZWBoCAdvkw8aAwAZL2V5Kr6DTG+j9/6tMYlmyzrE+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         "], {{0, 0}, {608, 50}}, {0, 50}],
        Frame->Automatic,
        FrameLabel->{None, None},
        FrameTicks->{{None, None}, {None, None}},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{542.09375, Automatic},
        Method->{
         "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
          Automatic}]], "ExerciseOutput",ExpressionUUID->
       "eb0ebdba-aef7-4c4e-afeb-57cf224394b9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          RasterBox[CompressedData["
1:eJzt3e1y4jYUBuBsmnZZWBoCAdvkw8aAwAZL2V5Kr6DTG+j9/6tMYlmyzrE+
gpek9TvTmW43m2TR4/fIgtDV3//8+ff11dXVH/yfv/i/xH36vCNXhgR9+tgE
8RN/aU/ap08ZYxEhgOLr1pA+/4OY8PCkhiL6EiCC4l/awvp81ligqUJMeMpJ
1l5E19cBQii+acmwz+dKjYZZoKlCTHh40tYi4gkQQ/GveMZ9Pn7kKhrWaJgF
GrEPMuHhSduKqEyAIIp/QxP1+UiBx9tYrqJhjYZZoKlCTHh40pYiOiVAFMVf
sdA+PyWWG6UIHm9juYqGNRpmgaYKMeHhSfEiek2AMIoHSMI+5w4Ih1pulCJ4
vI3lKhrWaJgFmirEhIcnRYvoLQHiKP4GJ+vjGGMHhSAcarlRiuDxNparaFij
YRZoqhATHp4UK6IqAQIphm9HHAq2z03JJzN2UAjCoZYbpQj+0mO5ioY1GmaB
pgox4eFJET8iAXJjG4+gWHzFPoPBWzXdlHwyYweFIBxqiTiCx9tYrqJhjYY5
/DWICQ9PajohCUBIo1H8Hci0Dxx15g3equmm5JMZOygE4VDLjVIEj7exXEXD
Gg2zQFOFWJywpYgfkQCCxBMDRyuLPqdou6ipOvMGb9V0U/LJjB0UgnCo5UYp
gsfbWK6iYY2GWaCpQkx4eFLEj0iAnNPFv2tJ/neBN+ULbRc1VWfe4K2aTnwy
YweFIBxquVGK4PE2lqtIQsMs0FQhJjw8qenAN9AhnRLfNmN52/zfyVUC//eF
touaqjNvIPPJjB0UgnCo5UYpgsfbGEHDLNBUIRZPGKSIH5FAg/SaeNKIg/xP
nrei+vIlgTflC20XNVUraSDzyYwdFIJwqOVGKYL/EmMEDbNAU4WY8PCkiB+R
oAnpLfGdmvl/OOoEHAlJCbwpX2hDbqpW0kDmkxk7KAThUMvLIYIhYWiYBZoq
xISHJ0X8iAR3cGL1Nsl4K/Rpc3U1VwtqJH4rgfdMC23ITdVKUvhkxg4KQTjU
co5FDmJ4mAWaKsSEhydF/IgEyI13PJNj8ZU+V0Rf/XJ9PVfFjYSkBN4zLbQh
N23hkxk7KAThUEsxkYMYHubwIBETHp7UdIITzODE91LyTxvk2ZmJ6Csuaq4W
1EhISuA900JDNG3hkxk7KAThUEsxkduVxSzQVCEWJ4Ap4kckuIcTS3sU0+f4
aKkh5cjh+UQWNVcLaiQkJXAnLTRE0xY+mbGDQhAOtRQTOYjhYRZoqhCLxzpF
/IgEyMY3rs8V3Tr4cqlUzWpIOXL0NJFFzdWCGglJCdxJCw3RtIVPZvy+QxAO
tRQTOYjhYQ4XKjHh4UlNd1ABclodix87Kj5akLF3W6ma1ZBy5OhpIouaqwVV
S0rgTlpoiKYtfDJjB4UgHGopJnJrd2aBpgqxuANPTU97YD/NFlcvVkKGzMVy
VSC/cVupmtWQcuToaSKLmmPTLYE7Sa/0aQufzNhBIQiHWoqJHMTwMKuDm9cQ
i6fNUt8XwcVvL8jdXDjNnrq+LpCxd1upmtWQcuTWbiI7mmPTLYE7aaEhmrbw
yYwdFIJwqKWYyEEMD7N7uvUUYuEk9X2ld7w8ZfuT0/S00SEVyNi7rVTNakg5
0k0T2dEcm24J3EkLDVEbn8zYQSEIh1qKiRzE8DCHkiEWTtKlZ+KHMr5/2jHC
07apaaNDKpCxd1upmtWQcqSbJrKjOTbdEriTFg5bntksM3ZQCMKhlmIit8nE
HEqGWCxd+uCZ+JFn11EaNbUUnrZNTRsdUoGMvdtK1ayGlCPdpDiaY9Mtgcks
HLY89/eZsYNCEA61FOM4mZjDdU8snKSPnomfnp5W54sCateoqaXwtG1q2uiQ
CmTs3VaqZjWk3LjD5kHP+RKYzMJhyzOfZ8YOguFQ33HQHuZQMsTCSfrkmfj5
GRlFzuGkVgqoXaOmluJDt01NGx1SgYw9oWpW28lthtgcK58EJuOw4+HJPCVQ
39nTHuZQMsTCSfrsGfP7N9nmKye1UkDtGgKXwtO2qWmjQypMjSTZyW2GGFo+
yTkqI/OUQH1nT3uYQ8kQCyep96s5bYaLIa999ZWTWimgdo2aWgpP26amjf5Z
C4cNUP4uG8k5KiPzlEB9Z097mEPJEAsmqe+mae8ZaRLevfZVSWqlgNo1amop
PG2bmjY6msKBSP4uG8k5KiPzlEB9Z097mEPHEAsnvm8rdnCJhGovTcK7mtRK
AbVr1NRSeNo2NW10NIUDkfxdNpJzVEbmKYH6jp72MIeSIevOgtyoAeGoDhKq
vVRUd/VHrRRQu0ZNLYWnbVPTRkdTOBDJ32UjOUdlZJ4SqO/saQ9zUEA6e37m
aEjdWN85qoOEai/Zu6tJrRRQu0ZN1Z62TU0bHU3hQCR/l42zVEbmKYF2Ux3M
gQHp6vka5HsTqo51Y33nqA4Sqr1UVBKplQJqh460bVPTRkdTOBDJz3r1eyXz
lEC76Q7m4KCrd+bU1/3Eai1UHevGKlEdJFR7+G5upXy6HTrStk1NGx1N4bC6
ue+Ffr5knhJoN+XBunp2xj4qjZLWw4nVWqg6qnv0g/The7iZVgqjHTrStk1N
Gx1N4bC6+Vmvfq9knhJoN6vLfI8HzpbaQWnrvqT1cGK1FqKOqsGDJGn/CGal
MNqhI23b1LTR0RQOq5uf9er3SuYpgXazvOzS72ZV798fS1v3Ja2HE6u1EHVU
6+kgSdrDzbRSGO3QkaZt/wA0hcPq5me9+r2SeUqg3awvu/BP4VQlxW09lrbu
y188nFithaijWk8HSdIebiaV0Q4daTZoCofVzc969XvFVwLtZoGZ0wnn2XPS
wHH9zm09lrZOtF5ZrYWoo1pPB0nS3mZn9L5KKBxWt5tF+imh3awwMx1BdZrT
Zv6Z4yptNfdRayHqqNbTQbLTWRHUKbp55D9aaDdLzC754zovLy8c1zNyh7cW
oo5qIf3kR77o5pH/aKHdrDG74Ptm//j27YVDwu7walGXfeS7eeA/XDpa5Av+
T2y+/Xh6eunTp6M8Pf3o06ez/As7kWBC
           "], {{0, 0}, {608, 50}}, {0, 50}],
           Frame -> Automatic, FrameLabel -> {None, None}, 
          FrameTicks -> {{None, None}, {None, None}}, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {542.09375, Automatic}, 
          Method -> {
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d0a964e7-7103-4994-9acc-a9aad3a9695a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Start with 1.0, then repeatedly apply the \[OpenCurlyDoubleQuote]",
 StyleBox["Newton",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["s method",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      ButtonBox["+",
       BaseStyle->"Link",
       ButtonData->"Plus"], 
      RowBox[{"2", "/", 
       ButtonBox["#",
        BaseStyle->"Link",
        ButtonData->"Slot"]}]}], " ", ")"}], "/", "2"}], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "2a83f0ef-caf5-4a2f-b5ea-242faf32842a"],
 " until the result no longer changes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"ac7f371d-a5fc-449d-872b-ebc6e929fafb"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", 
         "1.4142156862745097`", ",", "1.4142135623746899`", ",", 
         "1.414213562373095`", ",", "1.414213562373095`"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "90ad453d-6abd-48a8-bcd9-fefba177062a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", 
             "1.4142156862745097`", ",", "1.4142135623746899`", ",", 
             "1.414213562373095`", ",", "1.414213562373095`"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d2693749-2303-4e7d-866e-a194ec7f3353"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Implement ",
 StyleBox["Euclid\[CloseCurlyQuote]s algorithm",
  FontSlant->"Italic"],
 " for GCD in which ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]], "InlineCode",ExpressionUUID->
  "295ee201-c906-416a-bc66-fb33ab1416f0"],
 " is repeatedly replaced by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"b", ",", 
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "61fe695c-d289-4403-9b11-25f54238c877"],
 " until ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"bf8203bb-5dd7-4250-a132-747d83e78478"],
 " is 0, and apply the algorithm to ",
 Cell[BoxData[
  RowBox[{"12345", ",", " ", "54321"}]], "InlineCode",ExpressionUUID->
  "2240be4e-4209-4218-9810-78194052f886"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"05cd6007-fb69-41dd-b75e-338342ff4846"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"12345", ",", "54321"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"54321", ",", "12345"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"12345", ",", "4941"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4941", ",", "2463"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2463", ",", "15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"eaa32ee4-523d-4e73-8f39-492a4e37bcb6"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"12345", ",", "54321"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"54321", ",", "12345"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"12345", ",", "4941"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4941", ",", "2463"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2463", ",", "15"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"15", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f18b6079-b0c3-4a23-a97f-d2eaaab42a79"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define ",
 StyleBox["combinators",
  FontSlant->"Italic"],
 " using the rules ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", 
       RowBox[{"x", 
        ButtonBox["_",
         BaseStyle->"Link",
         ButtonData->"Blank"]}], "]"}], "[", 
      RowBox[{"y", 
       ButtonBox["_",
        BaseStyle->"Link",
        ButtonData->"Blank"]}], "]"}], "[", 
     RowBox[{"z", 
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"]}], "]"}], 
    ButtonBox["\[Rule]",
     BaseStyle->"Link",
     ButtonData->"Rule"], 
    RowBox[{
     RowBox[{"x", "[", "z", "]"}], "[", 
     RowBox[{"y", "[", "z", "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"k", "[", 
      RowBox[{"x", 
       ButtonBox["_",
        BaseStyle->"Link",
        ButtonData->"Blank"]}], "]"}], "[", 
     RowBox[{"y", 
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"]}], "]"}], 
    ButtonBox["\[Rule]",
     BaseStyle->"Link",
     ButtonData->"Rule"], "x"}]}]], "InlineCode",ExpressionUUID->
  "d33f19b1-179b-4dd0-80cb-0223650cc919"],
 ", then generate a list by starting with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"s", "[", "s", "]"}], "[", "k", "]"}], "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], "[", "s", 
   "]"}]], "InlineCode",ExpressionUUID->
  "4bf508ca-1ad9-4a7c-8ed4-531e51acb490"],
 " and applying these rules until nothing changes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"e671a221-845c-4a48-bb48-ac3dedfaf341"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"s", "[", "s", "]"}], "[", "k", "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], "[",
           "s", "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "[", 
           RowBox[{"k", "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", "s", "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", "s", 
           "]"}], "[", 
          RowBox[{
           RowBox[{"k", "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "[", "s", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "[", 
           RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], ",", 
         
         RowBox[{
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
           RowBox[{"s", "[", 
            RowBox[{"s", "[", "s", "]"}], "]"}], "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], ",", 
         
         RowBox[{
          RowBox[{
           RowBox[{"s", "[", "s", "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
          "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"s", "[", "s", "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
            "]"}], "[", 
           RowBox[{"s", "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
            "]"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
            "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", "s", "]"}], "[", 
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
              RowBox[{"s", "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}],
                "]"}], "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
              RowBox[{"s", "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}],
                "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"s", "[", "s", "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "]"}], "[", 
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"s", "[", "s", "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "]"}], "[", 
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
         
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], ",", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
           "]"}], "[", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
             "]"}], "]"}], "[", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "]"}], 
              "]"}], "[", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "[", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], "[", 
               RowBox[{"s", "[", 
                RowBox[{"s", "[", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                  "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "a825f20c-317c-4a41-87f7-eb10903b0a2c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"s", "[", "s", "]"}], "[", "k", "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "[", "s", "]"}], ",", 
             RowBox[{
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "[", 
                 RowBox[{"k", "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", "s", "]"}], ",", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[",
                  "s", "]"}], "[", 
               RowBox[{
                 RowBox[{"k", "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "[", "s", "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "[", 
                 RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
               "]"}], ",", 
             RowBox[{
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
               "]"}], ",", 
             RowBox[{
               RowBox[{
                 RowBox[{"s", "[", "s", "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                 "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{
                   RowBox[{"s", "[", "s", "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                 RowBox[{"s", "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"s", "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"s", "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"s", "[", "s", "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
             ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
               "]"}], ",", 
             RowBox[{
               RowBox[{"s", "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                   "]"}], "]"}], "[", 
               RowBox[{
                 RowBox[{"s", "[", 
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "[", 
                 RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "[", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], 
                    "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
               "]"}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"62631a7f-e248-40d8-b355-8ca9bd1a03a7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Remove all trailing 0\[CloseCurlyQuote]s from the digit list for ",
 Cell[BoxData[
  RowBox[{"100", 
   ButtonBox["!",
    BaseStyle->"Link",
    ButtonData->"Factorial"]}]], "InlineCode",ExpressionUUID->
  "815bddec-bbfa-4c4e-8fa4-39487b0d3299"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"90ffe6db-9618-48c6-a650-d0867cf65b05"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "9", ",", "3", ",", "3", ",", "2", ",", "6", ",", "2", ",", "1", ",", 
         "5", ",", "4", ",", "4", ",", "3", ",", "9", ",", "4", ",", "4", ",",
          "1", ",", "5", ",", "2", ",", "6", ",", "8", ",", "1", ",", "6", 
         ",", "9", ",", "9", ",", "2", ",", "3", ",", "8", ",", "8", ",", "5",
          ",", "6", ",", "2", ",", "6", ",", "6", ",", "7", ",", "0", ",", 
         "0", ",", "4", ",", "9", ",", "0", ",", "7", ",", "1", ",", "5", ",",
          "9", ",", "6", ",", "8", ",", "2", ",", "6", ",", "4", ",", "3", 
         ",", "8", ",", "1", ",", "6", ",", "2", ",", "1", ",", "4", ",", "6",
          ",", "8", ",", "5", ",", "9", ",", "2", ",", "9", ",", "6", ",", 
         "3", ",", "8", ",", "9", ",", "5", ",", "2", ",", "1", ",", "7", ",",
          "5", ",", "9", ",", "9", ",", "9", ",", "9", ",", "3", ",", "2", 
         ",", "2", ",", "9", ",", "9", ",", "1", ",", "5", ",", "6", ",", "0",
          ",", "8", ",", "9", ",", "4", ",", "1", ",", "4", ",", "6", ",", 
         "3", ",", "9", ",", "7", ",", "6", ",", "1", ",", "5", ",", "6", ",",
          "5", ",", "1", ",", "8", ",", "2", ",", "8", ",", "6", ",", "2", 
         ",", "5", ",", "3", ",", "6", ",", "9", ",", "7", ",", "9", ",", "2",
          ",", "0", ",", "8", ",", "2", ",", "7", ",", "2", ",", "2", ",", 
         "3", ",", "7", ",", "5", ",", "8", ",", "2", ",", "5", ",", "1", ",",
          "1", ",", "8", ",", "5", ",", "2", ",", "1", ",", "0", ",", "9", 
         ",", "1", ",", "6", ",", "8", ",", "6", ",", "4"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "85c8db05-0e09-4a6a-ad79-3e4553d7bd1a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"9", ",", "3", ",", "3", ",", "2", ",", "6", ",", "2", ",",
              "1", ",", "5", ",", "4", ",", "4", ",", "3", ",", "9", ",", "4",
              ",", "4", ",", "1", ",", "5", ",", "2", ",", "6", ",", "8", ",",
              "1", ",", "6", ",", "9", ",", "9", ",", "2", ",", "3", ",", "8",
              ",", "8", ",", "5", ",", "6", ",", "2", ",", "6", ",", "6", ",",
              "7", ",", "0", ",", "0", ",", "4", ",", "9", ",", "0", ",", "7",
              ",", "1", ",", "5", ",", "9", ",", "6", ",", "8", ",", "2", ",",
              "6", ",", "4", ",", "3", ",", "8", ",", "1", ",", "6", ",", "2",
              ",", "1", ",", "4", ",", "6", ",", "8", ",", "5", ",", "9", ",",
              "2", ",", "9", ",", "6", ",", "3", ",", "8", ",", "9", ",", "5",
              ",", "2", ",", "1", ",", "7", ",", "5", ",", "9", ",", "9", ",",
              "9", ",", "9", ",", "3", ",", "2", ",", "2", ",", "9", ",", "9",
              ",", "1", ",", "5", ",", "6", ",", "0", ",", "8", ",", "9", ",",
              "4", ",", "1", ",", "4", ",", "6", ",", "3", ",", "9", ",", "7",
              ",", "6", ",", "1", ",", "5", ",", "6", ",", "5", ",", "1", ",",
              "8", ",", "2", ",", "8", ",", "6", ",", "2", ",", "5", ",", "3",
              ",", "6", ",", "9", ",", "7", ",", "9", ",", "2", ",", "0", ",",
              "8", ",", "2", ",", "7", ",", "2", ",", "2", ",", "3", ",", "7",
              ",", "5", ",", "8", ",", "2", ",", "5", ",", "1", ",", "1", ",",
              "8", ",", "5", ",", "2", ",", "1", ",", "0", ",", "9", ",", "1",
              ",", "6", ",", "8", ",", "6", ",", "4"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a31d6d9f-3b05-4128-a2af-af144b39b660"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Start from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "71fd8267-1b98-4d5b-863a-927839ddd72e"],
 " then for 200 steps repeatedly remove the first 2 elements, and append ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "4ef16046-aa55-4a85-8d16-80baf0958d51"],
 " if the first element is ",
 Cell[BoxData[
 "1"], "InlineCode",ExpressionUUID->"4a609af2-0fa6-47be-9b58-09a897e23a68"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "db3896c9-593a-453b-a411-158fe827f97a"],
 " if it is ",
 Cell[BoxData[
 "0"], "InlineCode",ExpressionUUID->"6a99e269-198c-4ae3-8c60-8274e900c736"],
 " and get a list of the lengths of the sequences produced (",
 StyleBox["tag system",
  FontSlant->"Italic"],
 ").",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"b065832f-b67e-4b27-ace1-be417a2a625a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", "4", ",", "5", ",", 
         "6", ",", "6", ",", "7", ",", "8", ",", "9", ",", "9", ",", "10", 
         ",", "11", ",", "11", ",", "12", ",", "12", ",", "13", ",", "13", 
         ",", "14", ",", "14", ",", "15", ",", "16", ",", "16", ",", "17", 
         ",", "17", ",", "18", ",", "19", ",", "19", ",", "20", ",", "21", 
         ",", "22", ",", "22", ",", "23", ",", "23", ",", "24", ",", "24", 
         ",", "25", ",", "25", ",", "26", ",", "26", ",", "27", ",", "28", 
         ",", "29", ",", "29", ",", "30", ",", "30", ",", "31", ",", "32", 
         ",", "32", ",", "33", ",", "33", ",", "34", ",", "35", ",", "35", 
         ",", "36", ",", "37", ",", "37", ",", "38", ",", "38", ",", "39", 
         ",", "40", ",", "40", ",", "41", ",", "42", ",", "43", ",", "43", 
         ",", "44", ",", "44", ",", "45", ",", "45", ",", "46", ",", "46", 
         ",", "47", ",", "47", ",", "48", ",", "48", ",", "49", ",", "50", 
         ",", "50", ",", "51", ",", "52", ",", "53", ",", "53", ",", "54", 
         ",", "55", ",", "55", ",", "56", ",", "56", ",", "57", ",", "58", 
         ",", "58", ",", "59", ",", "59", ",", "60", ",", "61", ",", "61", 
         ",", "62", ",", "62", ",", "63", ",", "64", ",", "64", ",", "65", 
         ",", "66", ",", "67", ",", "67", ",", "68", ",", "69", ",", "69", 
         ",", "70", ",", "70", ",", "71", ",", "71", ",", "72", ",", "72", 
         ",", "73", ",", "74", ",", "74", ",", "75", ",", "76", ",", "77", 
         ",", "77", ",", "78", ",", "78", ",", "79", ",", "79", ",", "80", 
         ",", "80", ",", "81", ",", "82", ",", "82", ",", "83", ",", "84", 
         ",", "85", ",", "85", ",", "86", ",", "87", ",", "87", ",", "88", 
         ",", "88", ",", "89", ",", "89", ",", "90", ",", "90", ",", "91", 
         ",", "92", ",", "92", ",", "93", ",", "93", ",", "94", ",", "95", 
         ",", "95", ",", "96", ",", "97", ",", "98", ",", "98", ",", "99", 
         ",", "100", ",", "100", ",", "101", ",", "101", ",", "102", ",", 
         "103", ",", "103", ",", "104", ",", "104", ",", "105", ",", "106", 
         ",", "106", ",", "107", ",", "108", ",", "109", ",", "109", ",", 
         "110", ",", "111", ",", "111", ",", "112", ",", "112", ",", "113", 
         ",", "113", ",", "114", ",", "114", ",", "115", ",", "116", ",", 
         "116", ",", "117", ",", "117", ",", "118", ",", "119", ",", "119", 
         ",", "120", ",", "121", ",", "122", ",", "122", ",", "123", ",", 
         "123", ",", "124", ",", "124", ",", "125", ",", "125"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "25ef3913-71e1-4357-b5bd-16e04ab77ed0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"2", ",", "2", ",", "3", ",", "3", ",", "4", ",", "4", ",",
              "5", ",", "6", ",", "6", ",", "7", ",", "8", ",", "9", ",", "9",
              ",", "10", ",", "11", ",", "11", ",", "12", ",", "12", ",", 
             "13", ",", "13", ",", "14", ",", "14", ",", "15", ",", "16", ",",
              "16", ",", "17", ",", "17", ",", "18", ",", "19", ",", "19", 
             ",", "20", ",", "21", ",", "22", ",", "22", ",", "23", ",", "23",
              ",", "24", ",", "24", ",", "25", ",", "25", ",", "26", ",", 
             "26", ",", "27", ",", "28", ",", "29", ",", "29", ",", "30", ",",
              "30", ",", "31", ",", "32", ",", "32", ",", "33", ",", "33", 
             ",", "34", ",", "35", ",", "35", ",", "36", ",", "37", ",", "37",
              ",", "38", ",", "38", ",", "39", ",", "40", ",", "40", ",", 
             "41", ",", "42", ",", "43", ",", "43", ",", "44", ",", "44", ",",
              "45", ",", "45", ",", "46", ",", "46", ",", "47", ",", "47", 
             ",", "48", ",", "48", ",", "49", ",", "50", ",", "50", ",", "51",
              ",", "52", ",", "53", ",", "53", ",", "54", ",", "55", ",", 
             "55", ",", "56", ",", "56", ",", "57", ",", "58", ",", "58", ",",
              "59", ",", "59", ",", "60", ",", "61", ",", "61", ",", "62", 
             ",", "62", ",", "63", ",", "64", ",", "64", ",", "65", ",", "66",
              ",", "67", ",", "67", ",", "68", ",", "69", ",", "69", ",", 
             "70", ",", "70", ",", "71", ",", "71", ",", "72", ",", "72", ",",
              "73", ",", "74", ",", "74", ",", "75", ",", "76", ",", "77", 
             ",", "77", ",", "78", ",", "78", ",", "79", ",", "79", ",", "80",
              ",", "80", ",", "81", ",", "82", ",", "82", ",", "83", ",", 
             "84", ",", "85", ",", "85", ",", "86", ",", "87", ",", "87", ",",
              "88", ",", "88", ",", "89", ",", "89", ",", "90", ",", "90", 
             ",", "91", ",", "92", ",", "92", ",", "93", ",", "93", ",", "94",
              ",", "95", ",", "95", ",", "96", ",", "97", ",", "98", ",", 
             "98", ",", "99", ",", "100", ",", "100", ",", "101", ",", "101", 
             ",", "102", ",", "103", ",", "103", ",", "104", ",", "104", ",", 
             "105", ",", "106", ",", "106", ",", "107", ",", "108", ",", 
             "109", ",", "109", ",", "110", ",", "111", ",", "111", ",", 
             "112", ",", "112", ",", "113", ",", "113", ",", "114", ",", 
             "114", ",", "115", ",", "116", ",", "116", ",", "117", ",", 
             "117", ",", "118", ",", "119", ",", "119", ",", "120", ",", 
             "121", ",", "122", ",", "122", ",", "123", ",", "123", ",", 
             "124", ",", "124", ",", "125", ",", "125"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8e146cca-284d-4b45-8b37-d5068c5623a2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Start from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "1d400f94-20bc-4c71-90fa-b02ba801a7ce"],
 " then for 200 steps repeatedly remove the first 2 elements, and append ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]], "InlineCode",ExpressionUUID->
  "5bce96a8-a97a-4495-9f0e-543d777208c9"],
 " if the first element is ",
 Cell[BoxData[
 "0"], "InlineCode",ExpressionUUID->"2c04b8a8-888f-4c9d-94dd-bc2d71fb4f1b"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineCode",ExpressionUUID->
  "2aabb7b1-82f6-4aa1-9df0-5af4b955bf8d"],
 " if the first element is 1, and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "1", ",", "2"}], "}"}]], "InlineCode",
  ExpressionUUID->"cad6af90-cdc4-420c-80f8-e9a6688e6921"],
 " if it is ",
 Cell[BoxData[
 "2"], "InlineCode",ExpressionUUID->"0f136ab5-b4d4-467f-bf40-de8e599a34a5"],
 ", and make a line plot of the lengths of the sequences produced (",
 StyleBox["tag system",
  FontSlant->"Italic"],
 ").",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "41.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"464ccbf1-b389-4239-ba6d-2f700c9a4b3d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJx11UluFEEQheEUK5YsWLBgUSCEEEKIeQYnzTzabgbbDKZo09CsuEIcpY6S
W25RR+AIgHivUPwCS1b0V5mRVRmdUX1k8W2+3FdK+f7r/3f88/djTR/qv+N+
xQP/iQcx7xCuH4Y7XD+KeAzzjuP6CcSTiqcQzyiehnn9LHwO65yHL+C+F+FL
eL7LyL8CX0X+NTzPdfgG8m/Ct7DeGvJrdtiuw21F7Tts12WmqDoEXO4oqg5h
e993FVWXsF2He4rad9je531F7Svg8kBRdQjb+3yYHbbzH2F923V9jPVtr/9E
UXULe6b4VFF1Cdt1eKaofYftfT5X1L5Cnuqwnh3ryN/I+RWOjZzfbNdxM7tu
Ih9unu/7z7PrPD9fwM3zfQ5eZFd5qhfcPN/1fZldZdc/4Ob5Psevsqs8fZ9w
8/yZrr9GPhy27297/1t5f9V2/eC2hfxt2fWHYxv5tr//ney6g3zb3z9c3iDf
Vh8G3Gz34VtF9V2V3adha7zZ7sN3svqu2uqzgJs89eV7RfVdhcNW3zXbfbar
eRqvcOwi33b+h+wqT33rcfVdk93Hpc/u+pxf+5zfw4H8AW5Yb4TLx7xeJ/u9
UT2uvu897veAx9XXg8fl5nH17ehx9/VC95E7uC5yfr/I+QEPyG/wiPXKXnYn
+z1V4X4v7y+QP8AN+SNcPuX1OrjKfq/2cMhT/ZHf4BH5ZZmfp4PrMuf3cCzz
egPclvn5Rrh81jydpw6uss9bD4fs360BbrLP7wiXL5rn8w9X2f3QwyH7d3dA
foNH5JdVfp4Orquc38OxyusNyG/wiPzyVffx/f/6J8OJS2E=
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{374.6875, Automatic},
        Method->{},
        PlotRange->{{0., 201.}, {0, 82.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "4e0effd2-fc99-4318-91bd-594783187df7"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{
               RGBColor[0.368417, 0.506779, 0.709798], 
               PointSize[0.01388888888888889], 
               AbsoluteThickness[1.6], 
               LineBox[CompressedData["
1:eJx11UluFEEQheEUK5YsWLBgUSCEEEKIeQYnzTzabgbbDKZo09CsuEIcpY6S
W25RR+AIgHivUPwCS1b0V5mRVRmdUX1k8W2+3FdK+f7r/3f88/djTR/qv+N+
xQP/iQcx7xCuH4Y7XD+KeAzzjuP6CcSTiqcQzyiehnn9LHwO65yHL+C+F+FL
eL7LyL8CX0X+NTzPdfgG8m/Ct7DeGvJrdtiuw21F7Tts12WmqDoEXO4oqg5h
e993FVWXsF2He4rad9je531F7Svg8kBRdQjb+3yYHbbzH2F923V9jPVtr/9E
UXULe6b4VFF1Cdt1eKaofYftfT5X1L5Cnuqwnh3ryN/I+RWOjZzfbNdxM7tu
Ih9unu/7z7PrPD9fwM3zfQ5eZFd5qhfcPN/1fZldZdc/4Ob5Psevsqs8fZ9w
8/yZrr9GPhy27297/1t5f9V2/eC2hfxt2fWHYxv5tr//ney6g3zb3z9c3iDf
Vh8G3Gz34VtF9V2V3adha7zZ7sN3svqu2uqzgJs89eV7RfVdhcNW3zXbfbar
eRqvcOwi33b+h+wqT33rcfVdk93Hpc/u+pxf+5zfw4H8AW5Yb4TLx7xeJ/u9
UT2uvu897veAx9XXg8fl5nH17ehx9/VC95E7uC5yfr/I+QEPyG/wiPXKXnYn
+z1V4X4v7y+QP8AN+SNcPuX1OrjKfq/2cMhT/ZHf4BH5ZZmfp4PrMuf3cCzz
egPclvn5Rrh81jydpw6uss9bD4fs360BbrLP7wiXL5rn8w9X2f3QwyH7d3dA
foNH5JdVfp4Orquc38OxyusNyG/wiPzyVffx/f/6J8OJS2E=
                "]]}}}}, {}},
           AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {True, True}, AxesLabel -> {None, None}, 
          AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
          Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {374.6875, Automatic}, Method -> 
          {}, PlotRange -> {{0., 201.}, {0, 82.}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a7220b39-5aed-4179-b173-3c67942ac3ad"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:253",ExpressionUUID->"e0dbbfe2-7191-4db6-bb93-3affa95ebcf8"],

Cell["What are other pattern constructs in the Wolfram Language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ee9b34bf-461f-423f-ab6f-9768bd96727f"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["patt", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "ce931785-31c2-4dd3-889a-6f4905e3cb44"],
 " matches anything except ",
 Cell[BoxData[
  StyleBox["patt", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "ad02bd47-3f94-4d48-b6ef-071c76fb69b9"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PatternSequence",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["patt", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "073b1748-a165-4763-8db3-8124b19a6972"],
 " matches a sequence of arguments in a function. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OrderlessPatternSequence",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["patt", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "30cb1db0-1a62-45b6-a0b0-bbe9499fac44"],
 " matches them in any order. ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], ":", "v"}], "]"}]], "InlineCode",ExpressionUUID->
  "70b7159e-7e8f-4992-b6b7-bee5155c62b8"],
 " defines ",
 Cell[BoxData[
 "v"], "InlineCode",ExpressionUUID->"b25c45b4-c3a1-4d73-99d7-546ff56cd28f"],
 " as a default value, so ",
 Cell[BoxData[
  RowBox[{"f", "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "420f15b7-c2a5-43db-ae88-989de57b8640"],
 " is matched, with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"b7c00d45-ccf2-4de3-b66d-c226e4c9571a"],
 " being ",
 Cell[BoxData[
 "v"], "InlineCode",ExpressionUUID->"20045f51-cbf3-4f55-b0a0-0bffab3c0975"],
 ". "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"a1d09a40-cb4b-438f-b558-c8af4da67cfa"],

Cell["\<\
How can one see all the ways a pattern could match a particular expression?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f94396a7-33f7-4916-845e-85d2dd534b05"],

Cell[TextData[{
 "Use ",
 ButtonBox["ReplaceList",
  BaseStyle->"Link"],
 ". ",
 ButtonBox["Replace",
  BaseStyle->"Link"],
 " gives the first match; ",
 ButtonBox["ReplaceList",
  BaseStyle->"Link"],
 " gives a list of all of them."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"7997c1de-96e6-4fd8-8758-f3653623a833"],

Cell[TextData[{
 "What does ",
 ButtonBox["FixedPointList",
  BaseStyle->"Link"],
 " do if there\[CloseCurlyQuote]s no fixed point?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e005cfb-1611-45b3-90be-e6fafdd85a43"],

Cell[TextData[{
 "It\[CloseCurlyQuote]ll eventually stop. There\[CloseCurlyQuote]s an option \
that tells it how far to go. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPointList",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["f", "CodeVariable"], ",", 
    StyleBox["x", "CodeVariable"], ",", 
    StyleBox["n", "CodeVariable"]}], "]"}]], "InlineCode",ExpressionUUID->
  "9fe30e79-edc7-431b-8c38-7f4637e8849b"],
 " stops after at most ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "1206e690-f656-41c9-9026-0c0aaf572517"],
 " steps."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"48221f76-0ab8-4f65-846f-92374326378d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"475135c4-9ae6-4156-ba3c-3b480feece7e"],

Cell[TextData[{
 "In a repeating pattern ",
 Cell[BoxData[
  RowBox[{
   StyleBox["patt", "CodeVariable"], 
   ButtonBox["..",
    BaseStyle->"Link",
    ButtonData->"Repeated"]}]], "InlineCode",ExpressionUUID->
  "77efdec9-5d7f-4822-8a7c-e7926b12d91e"],
 ", don\[CloseCurlyQuote]t forget to leave a space in e.g. ",
 Cell[BoxData[
  RowBox[{"0", " ", 
   ButtonBox["..",
    BaseStyle->"Link",
    ButtonData->"Repeated"]}]], "InlineCode",ExpressionUUID->
  "850c1bb1-b5cb-4f62-90d3-fdd7c7952f03"],
 " to avoid confusion with decimal numbers."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f87de3d4-75be-44dd-a426-11ab49eca9f2"],

Cell[TextData[{
 "Functions can have attributes that affect how pattern matching works. For \
example, ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 " has attributes ",
 ButtonBox["Flat",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Orderless",
  BaseStyle->"Link"],
 ". ",
 ButtonBox["Flat",
  BaseStyle->"Link"],
 " means that ",
 Cell[BoxData[
  RowBox[{"b", "+", "c"}]], "InlineCode",ExpressionUUID->
  "26d99dbf-9d54-4e2c-b0f4-78cbfb48323b"],
 " can be pulled out of ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "InlineCode",ExpressionUUID->
  "5c39ec9e-b492-4e0c-91de-a79d42a9c91d"],
 ". ",
 ButtonBox["Orderless",
  BaseStyle->"Link"],
 " means that elements can be reordered, so ",
 Cell[BoxData[
  RowBox[{"a", "+", "c"}]], "InlineCode",ExpressionUUID->
  "34ac575f-2d53-4e33-831c-bc10bcb2a231"],
 " can be pulled out. (",
 ButtonBox["Flat",
  BaseStyle->"Link"],
 " is like the mathematical property of ",
 StyleBox["associativity",
  FontSlant->"Italic"],
 "; ",
 ButtonBox["Orderless",
  BaseStyle->"Link"],
 " like ",
 StyleBox["commutativity",
  FontSlant->"Italic"],
 ".) "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"b0ac734a-60ab-4987-b3a4-63052037eb33"],

Cell[TextData[{
 "The algorithm for sorting shown is usually called ",
 StyleBox["bubble sort",
  FontSlant->"Italic"],
 ". For a list of length ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "5efba205-14c8-4a8b-b012-1b665f42234d"],
 ", it\[CloseCurlyQuote]ll typically take about ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "CodeVariable"], "^", "2"}]], "InlineCode",ExpressionUUID->
  "2eed2527-d1c2-4360-8874-1f63573ea569"],
 " steps. The built-in Wolfram Language function ",
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " is much faster, and takes only a little over ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "38f44252-49d4-4544-b7d0-0504aba24884"],
 " steps."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"cd6a0acf-fcb8-4427-be71-1eef9309e511"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0aceacbc-5cae-45b5-9c97-8b97cabf7c4e"],

Cell[TextData[ButtonBox["Guide to Patterns in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"91a93abe-ce9c-4017-b04b-7dd663ac896d"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"More about Patterns: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-40-defining-your-own-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-40-defining-your-own-functions.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Defining Your Own Functions\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Defining Your Own Functions", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-42-string-patterns-and-templates.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-42-string-patterns-and-templates.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"String Patterns and Templates \"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "String Patterns and Templates ", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->332,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | More about Patterns \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"4c81bbb4-27fb-43a2-b5fa-f7de2b8461f4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:249"->{
  Cell[664, 24, 446, 11, 93, "SectionDoubleDigit",ExpressionUUID->"43026094-14cc-4c48-a732-3efee58f4763",
   CounterAssignments->{{"Section", 40}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:249"]},
 "i:1"->{
  Cell[1113, 37, 316, 7, 65, "Text",ExpressionUUID->"58e27099-6bd7-4d9c-8095-106649ba2637",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[5278, 173, 862, 26, 67, "Text",ExpressionUUID->"3594b72f-302b-4cf1-8ff0-ed6b914dfc26",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[17528, 544, 713, 19, 70, "Text",ExpressionUUID->"dd39474e-f862-4a16-b7c0-32f4b2e3c526",
   CellTags->"i:3"]},
 "LastCellOfAPage"->{
  Cell[18717, 582, 414, 11, 70, "Input",ExpressionUUID->"0aa52fb3-9ae6-49bc-9f93-30ebb88753bd",
   CellTags->"LastCellOfAPage"],
  Cell[125896, 3605, 278, 7, 70, "Output",ExpressionUUID->"453bd4d0-f682-4a26-a949-36a59154b3f6",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[135562, 3898, 10135, 200, 70, "Output",ExpressionUUID->"aa6aee6c-8a95-4d81-8f6a-82d804be47d4",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[265691, 7033, 1737, 49, 70, "Exercise",ExpressionUUID->"464ccbf1-b389-4239-ba6d-2f700c9a4b3d",
   CellTags->"LastCellOfAPage"],
  Cell[279240, 7437, 331, 8, 70, "MoreExplore",ExpressionUUID->"91a93abe-ce9c-4017-b04b-7dd663ac896d",
   CellTags->"LastCellOfAPage"]},
 "p:250"->{
  Cell[19134, 595, 229, 6, 70, "CodeCaption",ExpressionUUID->"5e1cac5f-115a-4ef9-8263-f46de25b8602",
   CellTags->"p:250"]},
 "i:4"->{
  Cell[45405, 1321, 669, 21, 70, "Text",ExpressionUUID->"7ac52d6c-175a-49cb-a750-6e44ff65621d",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[81917, 2341, 956, 32, 70, "Text",ExpressionUUID->"25d53ddd-71ab-4f1b-8edc-0e8495e080fe",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[102515, 2922, 1189, 37, 70, "Text",ExpressionUUID->"ab0a32dc-7fb6-43d5-8bc6-b1e834d1feb7",
   CellTags->"i:6"]},
 "bubble-sort"->{
  Cell[124685, 3566, 498, 12, 70, "Text",ExpressionUUID->"a5362192-9ab9-4f83-a78d-4d6105142581",
   CellTags->{"bubble-sort", "i:7"}]},
 "i:7"->{
  Cell[124685, 3566, 498, 12, 70, "Text",ExpressionUUID->"a5362192-9ab9-4f83-a78d-4d6105142581",
   CellTags->{"bubble-sort", "i:7"}]},
 "p:251"->{
  Cell[126189, 3615, 251, 7, 70, "CodeCaption",ExpressionUUID->"d96c5ff3-4ee5-4f71-be21-446481f7a6f0",
   CellTags->{"p:251", "i:8"}]},
 "i:8"->{
  Cell[126189, 3615, 251, 7, 70, "CodeCaption",ExpressionUUID->"d96c5ff3-4ee5-4f71-be21-446481f7a6f0",
   CellTags->{"p:251", "i:8"}]},
 "FixedPointList"->{
  Cell[128268, 3678, 686, 19, 70, "Text",ExpressionUUID->"a531f20c-f40f-4fd7-9270-038ad9886cf2",
   CellTags->"FixedPointList"]},
 "i:9"->{
  Cell[128957, 3699, 206, 4, 70, "CodeCaption",ExpressionUUID->"e31035b6-7de4-42c1-8677-fba70bab2185",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[130808, 3755, 258, 7, 70, "CodeCaption",ExpressionUUID->"51e2b02d-f44b-4067-a0f3-de06ba582443",
   CellTags->"i:10"]},
 "p:252"->{
  Cell[145746, 4104, 176, 4, 70, "VocabularySection",ExpressionUUID->"8c900324-2812-4500-82b4-4b2bf649df20",
   CellTags->"p:252"]},
 "i:11"->{
  Cell[202558, 5454, 1439, 46, 70, "Exercise",ExpressionUUID->"ac7f371d-a5fc-449d-872b-ebc6e929fafb",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[205586, 5549, 1481, 44, 70, "Exercise",ExpressionUUID->"05cd6007-fb69-41dd-b75e-338342ff4846",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[209529, 5667, 2198, 74, 70, "Exercise",ExpressionUUID->"e671a221-845c-4a48-bb48-ac3dedfaf341",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[257618, 6876, 1556, 44, 70, "Exercise",ExpressionUUID->"b065832f-b67e-4b27-ace1-be417a2a625a",
   CellTags->"i:14"]},
 "p:253"->{
  Cell[272267, 7196, 161, 4, 70, "QASection",ExpressionUUID->"e0dbbfe2-7191-4db6-bb93-3affa95ebcf8",
   CellTags->"p:253"]},
 "i:15"->{
  Cell[272632, 7208, 1758, 52, 70, "Answer",ExpressionUUID->"a1d09a40-cb4b-438f-b558-c8af4da67cfa",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[274619, 7270, 383, 15, 70, "Answer",ExpressionUUID->"7997c1de-96e6-4fd8-8758-f3653623a833",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[276878, 7353, 1259, 46, 70, "TechNote",ExpressionUUID->"b0ac734a-60ab-4987-b3a4-63052037eb33",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[278140, 7401, 895, 25, 70, "TechNote",ExpressionUUID->"cd6a0acf-fcb8-4427-be71-1eef9309e511",
   CellTags->"i:18"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:249", 370369, 9284},
 {"i:1", 370609, 9288},
 {"i:2", 370733, 9291},
 {"i:3", 370859, 9294},
 {"LastCellOfAPage", 370998, 9297},
 {"p:250", 371723, 9310},
 {"i:4", 371858, 9313},
 {"i:5", 371986, 9316},
 {"i:6", 372114, 9319},
 {"bubble-sort", 372252, 9322},
 {"i:7", 372398, 9325},
 {"p:251", 372546, 9328},
 {"i:8", 372692, 9331},
 {"FixedPointList", 372849, 9334},
 {"i:9", 372989, 9337},
 {"i:10", 373125, 9340},
 {"p:252", 373263, 9343},
 {"i:11", 373407, 9346},
 {"i:12", 373543, 9349},
 {"i:13", 373679, 9352},
 {"i:14", 373815, 9355},
 {"p:253", 373952, 9358},
 {"i:15", 374088, 9361},
 {"i:16", 374222, 9364},
 {"i:17", 374355, 9367},
 {"i:18", 374491, 9370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[664, 24, 446, 11, 93, "SectionDoubleDigit",ExpressionUUID->"43026094-14cc-4c48-a732-3efee58f4763",
 CounterAssignments->{{"Section", 40}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:249"],
Cell[1113, 37, 316, 7, 65, "Text",ExpressionUUID->"58e27099-6bd7-4d9c-8095-106649ba2637",
 CellTags->"i:1"],
Cell[1432, 46, 1718, 55, 92, "Text",ExpressionUUID->"0067f869-09e6-4c89-9136-a1ad66f41b29"],
Cell[3153, 103, 309, 9, 37, "CodeCaption",ExpressionUUID->"b124aa07-b545-4f8c-a8a0-638509820598"],
Cell[3465, 114, 301, 7, 29, "Input",ExpressionUUID->"ec9ea996-cbd3-4845-b2bd-02d6d9839fc4"],
Cell[3769, 123, 204, 5, 37, "CodeCaption",ExpressionUUID->"dd77b005-d8e2-4a4b-b336-f29ba59e5215"],
Cell[CellGroupData[{
Cell[3998, 132, 477, 12, 29, "Input",ExpressionUUID->"1ee37cc0-9f94-4b1f-a263-baa35fbbc843"],
Cell[4478, 146, 785, 24, 53, "Output",ExpressionUUID->"170a8505-e58c-49ed-a895-5fc2b369d2e8",
 Evaluatable->False]
}, Open  ]],
Cell[5278, 173, 862, 26, 67, "Text",ExpressionUUID->"3594b72f-302b-4cf1-8ff0-ed6b914dfc26",
 CellTags->"i:2"],
Cell[6143, 201, 322, 10, 37, "CodeCaption",ExpressionUUID->"ad8da67e-1820-45c5-ab61-5352f43dd0bc"],
Cell[6468, 213, 352, 9, 29, "Input",ExpressionUUID->"55db4038-d9a2-4299-bcdf-6eaf33d39166"],
Cell[6823, 224, 211, 5, 37, "CodeCaption",ExpressionUUID->"accd1252-ad3d-436b-8913-f9fdcd0d839c"],
Cell[CellGroupData[{
Cell[7059, 233, 393, 10, 29, "Input",ExpressionUUID->"fcc21ef5-7e16-4b93-abf4-5e45f91ce68d"],
Cell[7455, 245, 659, 19, 53, "Output",ExpressionUUID->"d0b17a3b-a3b0-448c-99fe-c625e56b46ae",
 Evaluatable->False]
}, Open  ]],
Cell[8129, 267, 390, 12, 41, "Text",ExpressionUUID->"339c1a0b-928b-46b9-9f74-bc0dcbc52aa8"],
Cell[8522, 281, 188, 4, 37, "CodeCaption",ExpressionUUID->"a31779ed-757c-4128-907d-8739da308a66"],
Cell[8713, 287, 255, 7, 29, "Input",ExpressionUUID->"6928bd00-f254-4dcd-be15-d133358932f2"],
Cell[8971, 296, 268, 7, 29, "Input",ExpressionUUID->"31cc19ab-532e-4049-9aec-8e72b069b51b"],
Cell[9242, 305, 179, 4, 70, "CodeCaption",ExpressionUUID->"037b46f0-20e2-4532-93aa-76712408194c"],
Cell[CellGroupData[{
Cell[9446, 313, 493, 14, 70, "Input",ExpressionUUID->"86c03585-e5da-4714-ac54-1ffada806c74"],
Cell[9942, 329, 7571, 212, 70, "Output",ExpressionUUID->"4fb190b5-4f26-43e2-855e-e796e6e8b75e",
 Evaluatable->False]
}, Open  ]],
Cell[17528, 544, 713, 19, 70, "Text",ExpressionUUID->"dd39474e-f862-4a16-b7c0-32f4b2e3c526",
 CellTags->"i:3"],
Cell[18244, 565, 219, 6, 70, "Text",ExpressionUUID->"6e48bdbf-2cc1-4e6f-8bc6-e939cc43f0ef"],
Cell[18466, 573, 248, 7, 70, "CodeCaption",ExpressionUUID->"a5dd1fb7-2825-4e8d-894f-1d2be3408446"],
Cell[18717, 582, 414, 11, 70, "Input",ExpressionUUID->"0aa52fb3-9ae6-49bc-9f93-30ebb88753bd",
 CellTags->"LastCellOfAPage"],
Cell[19134, 595, 229, 6, 70, "CodeCaption",ExpressionUUID->"5e1cac5f-115a-4ef9-8263-f46de25b8602",
 CellTags->"p:250"],
Cell[CellGroupData[{
Cell[19388, 605, 12358, 335, 70, "Input",ExpressionUUID->"57fbdd9e-a7f5-4052-8cb9-1c2af03bd5d9"],
Cell[31749, 942, 13641, 376, 70, "Output",ExpressionUUID->"51bd3255-e64b-4480-bfe8-7450611c5d87",
 Evaluatable->False]
}, Open  ]],
Cell[45405, 1321, 669, 21, 70, "Text",ExpressionUUID->"7ac52d6c-175a-49cb-a750-6e44ff65621d",
 CellTags->"i:4"],
Cell[46077, 1344, 233, 7, 70, "CodeCaption",ExpressionUUID->"002b2816-8dea-4f55-9e80-b272253a3edb"],
Cell[46313, 1353, 422, 11, 70, "Input",ExpressionUUID->"e397ebbc-dbcd-4e61-befb-df6591498af5"],
Cell[46738, 1366, 305, 9, 70, "CodeCaption",ExpressionUUID->"249afbd5-415f-4763-8ba3-616c66cb8c43"],
Cell[CellGroupData[{
Cell[47068, 1379, 12360, 335, 70, "Input",ExpressionUUID->"55e73d82-6b9b-41ce-bbb4-5972a2112dcd"],
Cell[59431, 1716, 22471, 622, 70, "Output",ExpressionUUID->"2b1867fe-1aa9-41cd-93b9-02815b7077e6",
 Evaluatable->False]
}, Open  ]],
Cell[81917, 2341, 956, 32, 70, "Text",ExpressionUUID->"25d53ddd-71ab-4f1b-8edc-0e8495e080fe",
 CellTags->"i:5"],
Cell[82876, 2375, 327, 9, 70, "CodeCaption",ExpressionUUID->"f4457219-f5c1-4d98-8eb3-3af97654361f"],
Cell[83206, 2386, 484, 15, 70, "Input",ExpressionUUID->"9c0e28fb-1882-4a52-b371-bc2cd8cd031e"],
Cell[CellGroupData[{
Cell[83715, 2405, 12264, 336, 70, "Input",ExpressionUUID->"e48be22a-176a-4682-a822-4a195e1ce191"],
Cell[95982, 2743, 6518, 176, 70, "Output",ExpressionUUID->"b9744ec3-c192-4863-b843-92a68f631bcc",
 Evaluatable->False]
}, Open  ]],
Cell[102515, 2922, 1189, 37, 70, "Text",ExpressionUUID->"ab0a32dc-7fb6-43d5-8bc6-b1e834d1feb7",
 CellTags->"i:6"],
Cell[103707, 2961, 313, 9, 70, "CodeCaption",ExpressionUUID->"966eaf56-69e7-4428-8e22-c7970fb53f88"],
Cell[104023, 2972, 458, 14, 70, "Input",ExpressionUUID->"7ef3911a-0bda-43f9-835e-0505252f112c"],
Cell[CellGroupData[{
Cell[104506, 2990, 891, 29, 70, "Input",ExpressionUUID->"7265b3a4-b196-4d50-81e6-3140519f7b75"],
Cell[105400, 3021, 1025, 33, 70, "Output",ExpressionUUID->"8ed25772-9508-4229-b53f-26a653cbe0ff",
 Evaluatable->False]
}, Open  ]],
Cell[106440, 3057, 221, 6, 70, "CodeCaption",ExpressionUUID->"01271a1e-aa01-4fae-9a5a-d3f5eb6d1290"],
Cell[106664, 3065, 611, 19, 70, "Input",ExpressionUUID->"840ae615-6743-4f74-aef2-5d449a569613"],
Cell[CellGroupData[{
Cell[107300, 3088, 12264, 336, 70, "Input",ExpressionUUID->"e0222c5e-63b0-4840-b430-17b009da8048"],
Cell[119567, 3426, 5103, 137, 70, "Output",ExpressionUUID->"3ca7ffb9-cbcb-4f7b-b531-c8a8b6254a58",
 Evaluatable->False]
}, Open  ]],
Cell[124685, 3566, 498, 12, 70, "Text",ExpressionUUID->"a5362192-9ab9-4f83-a78d-4d6105142581",
 CellTags->{"bubble-sort", "i:7"}],
Cell[125186, 3580, 230, 7, 70, "CodeCaption",ExpressionUUID->"9133040b-8f4c-40e9-b876-ae6c40751e75"],
Cell[CellGroupData[{
Cell[125441, 3591, 452, 12, 70, "Input",ExpressionUUID->"41cf0028-c095-4347-86af-f23d386c355f"],
Cell[125896, 3605, 278, 7, 70, "Output",ExpressionUUID->"453bd4d0-f682-4a26-a949-36a59154b3f6",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[126189, 3615, 251, 7, 70, "CodeCaption",ExpressionUUID->"d96c5ff3-4ee5-4f71-be21-446481f7a6f0",
 CellTags->{"p:251", "i:8"}],
Cell[CellGroupData[{
Cell[126465, 3626, 605, 18, 70, "Input",ExpressionUUID->"7814fde1-618f-4951-af1c-44a43e8cf5ad"],
Cell[127073, 3646, 1180, 29, 70, "Output",ExpressionUUID->"09c64c58-eb82-48ab-a3e9-3164645d7b3d",
 Evaluatable->False]
}, Open  ]],
Cell[128268, 3678, 686, 19, 70, "Text",ExpressionUUID->"a531f20c-f40f-4fd7-9270-038ad9886cf2",
 CellTags->"FixedPointList"],
Cell[128957, 3699, 206, 4, 70, "CodeCaption",ExpressionUUID->"e31035b6-7de4-42c1-8677-fba70bab2185",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[129188, 3707, 600, 18, 70, "Input",ExpressionUUID->"cff49405-9684-46eb-af32-194acabce307"],
Cell[129791, 3727, 1002, 25, 70, "Output",ExpressionUUID->"f6cf75df-d1a4-4cf9-b5fe-2124058d1d3c",
 Evaluatable->False]
}, Open  ]],
Cell[130808, 3755, 258, 7, 70, "CodeCaption",ExpressionUUID->"51e2b02d-f44b-4067-a0f3-de06ba582443",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[131091, 3766, 160, 3, 70, "Input",ExpressionUUID->"92705b0d-e9b6-4e2c-88c6-fd6dca58f362"],
Cell[131254, 3771, 898, 26, 70, "Output",ExpressionUUID->"50b069eb-b28b-439b-9751-bd2b0d9951e5",
 Evaluatable->False]
}, Open  ]],
Cell[132167, 3800, 290, 9, 70, "CodeCaption",ExpressionUUID->"f6f6c916-79dd-4677-beda-6c670fed3bd0"],
Cell[CellGroupData[{
Cell[132482, 3813, 163, 3, 70, "Input",ExpressionUUID->"7aa0e382-dfeb-442f-8ed1-efce2352e740"],
Cell[132648, 3818, 1954, 46, 70, "Output",ExpressionUUID->"3817b79f-cb86-4db2-88c0-bc4a5a714134",
 Evaluatable->False]
}, Open  ]],
Cell[134617, 3867, 216, 5, 70, "CodeCaption",ExpressionUUID->"6b74927c-1096-4bfd-9366-13f65dab7707"],
Cell[CellGroupData[{
Cell[134858, 3876, 701, 20, 70, "Input",ExpressionUUID->"82fad62f-7c76-4861-aea7-59a697561ad9"],
Cell[135562, 3898, 10135, 200, 70, "Output",ExpressionUUID->"aa6aee6c-8a95-4d81-8f6a-82d804be47d4",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145746, 4104, 176, 4, 70, "VocabularySection",ExpressionUUID->"8c900324-2812-4500-82b4-4b2bf649df20",
 CellTags->"p:252"],
Cell[145925, 4110, 2088, 55, 70, "VocabularyTable",ExpressionUUID->"1e4b360c-0cae-454c-97ed-0bfbdd61c324"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148050, 4170, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"5049bd0f-9205-4311-8436-574cb986eb48"],
Cell[CellGroupData[{
Cell[149855, 4220, 1274, 40, 70, "ExerciseSummaryCell",ExpressionUUID->"003f00fe-de11-4c6f-ad67-73cc4c3749f3"],
Cell[CellGroupData[{
Cell[151154, 4264, 768, 21, 70, "Exercise",ExpressionUUID->"52899fa5-0917-4fe6-b805-c19a29a842f8"],
Cell[151925, 4287, 6215, 144, 70, "ExerciseOutput",ExpressionUUID->"80836a21-a1bd-4da8-876e-d0dedea96ab6"]
}, Closed]],
Cell[CellGroupData[{
Cell[158177, 4436, 747, 21, 70, "Exercise",ExpressionUUID->"32e5fc39-0705-4fe3-90f6-5f6d5e02a2ae"],
Cell[158927, 4459, 1384, 39, 70, "ExerciseOutput",ExpressionUUID->"43e86cbf-53a6-493e-94a4-af0e8d7399c6"]
}, Closed]],
Cell[160326, 4501, 846, 23, 70, "Exercise",ExpressionUUID->"6762777e-0e78-4e5e-8e44-d4d9e090805c"],
Cell[CellGroupData[{
Cell[161197, 4528, 782, 21, 70, "Exercise",ExpressionUUID->"27983a0f-6894-49e1-855a-db33c1e7de63"],
Cell[161982, 4551, 28274, 617, 70, "ExerciseOutput",ExpressionUUID->"c920c8f5-e844-450b-b2c6-ef81f7311091"]
}, Closed]],
Cell[CellGroupData[{
Cell[190293, 5173, 1096, 32, 70, "Exercise",ExpressionUUID->"cbf6f0a9-5e54-4c0a-8d34-f20c5af01d6f"],
Cell[191392, 5207, 2038, 55, 70, "ExerciseOutput",ExpressionUUID->"8e720abb-29aa-4849-a7cd-9058fc2c4d99"]
}, Closed]],
Cell[CellGroupData[{
Cell[193467, 5267, 947, 27, 70, "Exercise",ExpressionUUID->"2addc280-9998-47a0-9c88-1e9de94a587f"],
Cell[194417, 5296, 8104, 153, 70, "ExerciseOutput",ExpressionUUID->"d0a964e7-7103-4994-9acc-a9aad3a9695a"]
}, Closed]],
Cell[CellGroupData[{
Cell[202558, 5454, 1439, 46, 70, "Exercise",ExpressionUUID->"ac7f371d-a5fc-449d-872b-ebc6e929fafb",
 CellTags->"i:11"],
Cell[204000, 5502, 1549, 42, 70, "ExerciseOutput",ExpressionUUID->"d2693749-2303-4e7d-866e-a194ec7f3353"]
}, Closed]],
Cell[CellGroupData[{
Cell[205586, 5549, 1481, 44, 70, "Exercise",ExpressionUUID->"05cd6007-fb69-41dd-b75e-338342ff4846",
 CellTags->"i:12"],
Cell[207070, 5595, 2422, 67, 70, "ExerciseOutput",ExpressionUUID->"f18b6079-b0c3-4a23-a97f-d2eaaab42a79"]
}, Closed]],
Cell[CellGroupData[{
Cell[209529, 5667, 2198, 74, 70, "Exercise",ExpressionUUID->"e671a221-845c-4a48-bb48-ac3dedfaf341",
 CellTags->"i:13"],
Cell[211730, 5743, 40569, 1017, 70, "ExerciseOutput",ExpressionUUID->"62631a7f-e248-40d8-b355-8ca9bd1a03a7"]
}, Closed]],
Cell[CellGroupData[{
Cell[252336, 6765, 917, 27, 70, "Exercise",ExpressionUUID->"90ffe6db-9618-48c6-a650-d0867cf65b05"],
Cell[253256, 6794, 4325, 77, 70, "ExerciseOutput",ExpressionUUID->"a31d6d9f-3b05-4128-a2af-af144b39b660"]
}, Closed]],
Cell[CellGroupData[{
Cell[257618, 6876, 1556, 44, 70, "Exercise",ExpressionUUID->"b065832f-b67e-4b27-ace1-be417a2a625a",
 CellTags->"i:14"],
Cell[259177, 6922, 6477, 106, 70, "ExerciseOutput",ExpressionUUID->"8e146cca-284d-4b45-8b37-d5068c5623a2"]
}, Closed]],
Cell[CellGroupData[{
Cell[265691, 7033, 1737, 49, 70, "Exercise",ExpressionUUID->"464ccbf1-b389-4239-ba6d-2f700c9a4b3d",
 CellTags->"LastCellOfAPage"],
Cell[267431, 7084, 4775, 105, 70, "ExerciseOutput",ExpressionUUID->"a7220b39-5aed-4179-b173-3c67942ac3ad"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[272267, 7196, 161, 4, 70, "QASection",ExpressionUUID->"e0dbbfe2-7191-4db6-bb93-3affa95ebcf8",
 CellTags->"p:253"],
Cell[272431, 7202, 198, 4, 70, "Question",ExpressionUUID->"ee9b34bf-461f-423f-ab6f-9768bd96727f"],
Cell[272632, 7208, 1758, 52, 70, "Answer",ExpressionUUID->"a1d09a40-cb4b-438f-b558-c8af4da67cfa",
 CellTags->"i:15"],
Cell[274393, 7262, 223, 6, 70, "Question",ExpressionUUID->"f94396a7-33f7-4916-845e-85d2dd534b05"],
Cell[274619, 7270, 383, 15, 70, "Answer",ExpressionUUID->"7997c1de-96e6-4fd8-8758-f3653623a833",
 CellTags->"i:16"],
Cell[275005, 7287, 268, 9, 70, "Question",ExpressionUUID->"5e005cfb-1611-45b3-90be-e6fafdd85a43"],
Cell[275276, 7298, 722, 21, 70, "Answer",ExpressionUUID->"48221f76-0ab8-4f65-846f-92374326378d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[276035, 7324, 157, 4, 70, "TechNoteSection",ExpressionUUID->"475135c4-9ae6-4156-ba3c-3b480feece7e"],
Cell[276195, 7330, 680, 21, 70, "TechNote",ExpressionUUID->"f87de3d4-75be-44dd-a426-11ab49eca9f2"],
Cell[276878, 7353, 1259, 46, 70, "TechNote",ExpressionUUID->"b0ac734a-60ab-4987-b3a4-63052037eb33",
 CellTags->"i:17"],
Cell[278140, 7401, 895, 25, 70, "TechNote",ExpressionUUID->"cd6a0acf-fcb8-4427-be71-1eef9309e511",
 CellTags->"i:18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279072, 7431, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"0aceacbc-5cae-45b5-9c97-8b97cabf7c4e"],
Cell[279240, 7437, 331, 8, 70, "MoreExplore",ExpressionUUID->"91a93abe-ce9c-4017-b04b-7dd663ac896d",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature eLzQtgPaIgjVfKO0#yWJzgyO *)
