(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    208858,       5181]
NotebookOptionsPosition[    102715,       3076]
NotebookOutlinePosition[    197262,       5008]
CellTagsIndexPosition[    196737,       4985]
WindowTitle->Defining Your Own Function: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Defining Your Own Functions", "SectionInline",ExpressionUUID->
   "f5cbfda5-f85b-4c98-93bd-8ac0b16eb4a8"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 39}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:243",
 CellLabel->"In[9]:=",ExpressionUUID->"d2d98f30-2466-45f8-b70e-41dc538ba745"],

Cell["\<\
As we\[CloseCurlyQuote]ve seen in this book, there\[CloseCurlyQuote]s a huge \
amount that can be done with functions that are already built into the \
Wolfram Language. But you can go even further if you define your own \
functions too. And the Wolfram Language has a very flexible way of letting \
you do this.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"6f34cbdb-76df-4249-bcd4-dc6abaf52c9c"],

Cell["\<\
Let\[CloseCurlyQuote]s start with a typical, simple example of a function \
definition.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"a4c875c7-ebf2-48cd-a0d2-9e27aade6ab0"],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData[
 "pinks"], "InlineCode",ExpressionUUID->
  "55f0558c-5e66-4358-ae90-1d736c4d7473"],
 " that takes any argument:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"904ee3b0-24b5-4d31-a977-e6c320727242"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pinks", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{"Pink", ",", "n"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"e1e74268-c33b-429f-9638-f191b0d95af1"],

Cell["This uses the function definition:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"00b7e7e1-038d-4403-ab8d-d67756956959"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pinks", "[", "5", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"6271f144-6569-42cb-bfb0-c403b4cd27cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[2]=",ExpressionUUID->"de2ab7ee-eb3c-4f5b-987b-b99e97f3c39c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pinks", "[", "10", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"21acdcf9-b17b-4ecf-b1b4-81cc075968e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0.5, 0.5]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0.5, 0.5],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[3]=",ExpressionUUID->"24b234a5-4996-44c9-9c1b-37d2db2fa302"]
}, Open  ]],

Cell[TextData[{
 "How does this function definition work? The idea is that the ",
 Cell[BoxData[
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"SetDelayed"]], "InlineCodeText",ExpressionUUID->
  "f7525e4e-9ceb-4184-8a38-00d17442c99f"],
 " defines a value for the pattern ",
 Cell[BoxData[
  RowBox[{"pinks", "[", 
   StyleBox[
    RowBox[{
     StyleBox["n", "CodeVariable"], "_"}]], "]"}]], "InlineCodeText",
  ExpressionUUID->"7b14e078-402b-45c3-91b9-f670dd27a65b"],
 ". When you ask for ",
 Cell[BoxData[
  RowBox[{"pinks", "[", "5", "]"}]], "InlineCodeText",ExpressionUUID->
  "18008178-941d-4c24-967b-3e042e4a3316"],
 ", this matches the ",
 Cell[BoxData[
  RowBox[{"pinks", "[", 
   StyleBox[
    RowBox[{
     StyleBox["n", "CodeVariable"], "_"}]], "]"}]], "InlineCodeText",
  ExpressionUUID->"07b61dc1-f2ae-4c95-8a0f-9679e30dcbad"],
 " pattern, and the value you\[CloseCurlyQuote]ve defined for this is used."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a1a18ea5-ed1b-4f4b-9ddc-c3b947d36287"],

Cell["\<\
But this is just the beginning of the story of function definition in the \
Wolfram Language. Because in the Wolfram Language, you can give a definition \
for anything.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d6dee6a0-efc9-4463-ad81-eb9165626f1c"],

Cell["Here\[CloseCurlyQuote]s a list of expressions:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"952558a9-75b7-415c-90a1-ab65b8fb8419"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "Red", "]"}], ",", 
   RowBox[{"f", "[", "Yellow", "]"}], ",", 
   RowBox[{"f", "[", "Green", "]"}], ",", 
   RowBox[{"f", "[", "Orange", "]"}], ",", 
   RowBox[{"f", "[", "Magenta", "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"f715911a-be2d-4381-9ac0-8fe502b4c2c6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0, 0],
     Editable->False,
     Selectable->False], "]"}], ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], "]"}], ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0, 1, 0],
     Editable->False,
     Selectable->False], "]"}], ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0],
     Editable->False,
     Selectable->False], "]"}], ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0., 0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0, 1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0, 1],
     Editable->False,
     Selectable->False], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[4]=",ExpressionUUID->"39aedb7d-d40c-4731-a087-99012d9a66ca"]
}, Open  ]],

Cell[TextData[{
 "Define values for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Red",
    BaseStyle->"CodeLink"], "]"}]], "InlineCode",ExpressionUUID->
  "3b6ede85-8458-40a4-a070-178e5a6302b1"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Green",
    BaseStyle->"CodeLink"], "]"}]], "InlineCode",ExpressionUUID->
  "bebbc841-b818-4809-9fe1-98284361e721"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2cd53f18-bcce-4d46-84ce-bab5e04454e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "Red", "]"}], "=", "1000"}], ";", 
  RowBox[{
   RowBox[{"f", "[", "Green", "]"}], "=", "2000"}], ";"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"fa0e33fa-7702-46ab-b69e-0e465c796923"],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Red",
    BaseStyle->"CodeLink"], "]"}]], "InlineCode",ExpressionUUID->
  "4f7e9ab6-1b21-4dcf-b44c-57e7629a86d0"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Green",
    BaseStyle->"CodeLink"], "]"}]], "InlineCode",ExpressionUUID->
  "41c0c62f-f252-4528-a7d1-fa119f12f91e"],
 " are replaced by the values defined; the other cases are left unchanged:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a2fd0b7a-8d3b-4861-b98d-3da224c1393e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "Red", "]"}], ",", 
   RowBox[{"f", "[", "Yellow", "]"}], ",", 
   RowBox[{"f", "[", "Green", "]"}], ",", 
   RowBox[{"f", "[", "Orange", "]"}], ",", 
   RowBox[{"f", "[", "Blue", "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"80293250-15d6-4c5d-98de-27d1fdff9c48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1000", ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 1, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 1, 0],
     Editable->False,
     Selectable->False], "]"}], ",", "2000", ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[1, 0.5, 0]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[1, 0.5, 0],
     Editable->False,
     Selectable->False], "]"}], ",", 
   RowBox[{"f", "[", 
    InterpretationBox[
     ButtonBox[
      TooltipBox[
       GraphicsBox[{
         {GrayLevel[0], RectangleBox[{0, 0}]}, 
         {GrayLevel[0], RectangleBox[{1, -1}]}, 
         {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
        AspectRatio->1,
        Frame->True,
        FrameStyle->RGBColor[0., 0., 0.6666666666666666],
        FrameTicks->None,
        ImageSize->
         Dynamic[{
          Automatic, 
           1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
            Magnification])}],
        PlotRangePadding->None],
       "RGBColor[0, 0, 1]"],
      Appearance->None,
      BaseStyle->{},
      BaselinePosition->Baseline,
      ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
        If[
         Not[
          AbsoluteCurrentValue["Deployed"]], 
         SelectionMove[Typeset`box$, All, Expression]; 
         FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
         FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
         FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
         MathLink`CallFrontEnd[
           FrontEnd`AttachCell[Typeset`box$, 
            FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
            Left, Top}, 
            "ClosingActions" -> {
             "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
      DefaultBaseStyle->{},
      Evaluator->Automatic,
      Method->"Preemptive"],
     RGBColor[0, 0, 1],
     Editable->False,
     Selectable->False], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[6]=",ExpressionUUID->"6620eb32-4a64-4142-af7c-3e2d2411b02c"]
}, Open  ]],

Cell[TextData[{
 "Now let\[CloseCurlyQuote]s add a definition for the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    StyleBox["x", "CodeVariable"], 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "]"}]], "InlineCodeText",ExpressionUUID->
  "709efb20-97b4-40b2-800f-4ac9f8b66608"],
 ". The Wolfram Language will use this whenever the special definitions for \
",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Red",
    BaseStyle->"CodeLink"], "]"}]], "InlineCodeText",ExpressionUUID->
  "bde52342-9537-4bcb-96b2-69151a147fa3"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox["Green",
    BaseStyle->"CodeLink"], "]"}]], "InlineCodeText",ExpressionUUID->
  "da81ff25-6a20-40ce-b27b-83891d92af19"],
 " don\[CloseCurlyQuote]t apply."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"cbbe3a6a-32ec-412d-8f61-8ce926ebeaa2"],

Cell[TextData[{
 "Define a value for ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"445b9076-f66f-44d7-8aa8-5f8d8b243a00"],
 " with any argument:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2f490fc9-3e8c-4273-ac48-a467b264cf56"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Framed", "[", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"ColorNegate", "[", "x", "]"}]}], "}"}], "]"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"In[7]:=",ExpressionUUID->"6811aa02-4d24-4410-8b29-d5ebd584b1b2"],

Cell["\<\
If the special cases don\[CloseCurlyQuote]t apply, the general definition is \
used:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:244",ExpressionUUID->"b49785f1-4ada-4c16-97b2-d07969ccd2d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "Red", "]"}], ",", 
   RowBox[{"f", "[", "Yellow", "]"}], ",", 
   RowBox[{"f", "[", "Green", "]"}], ",", 
   RowBox[{"f", "[", "Orange", "]"}], ",", 
   RowBox[{"f", "[", "Blue", "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"0070c472-7c54-49f7-8e4d-76035ca6bb50"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1000", ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1, 1, 0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1, 1, 0],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0., 0., 1.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0., 0.6666666666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0., 0., 1.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0., 0., 1.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0., 0., 1.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", "2000", ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1, 0.5, 0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[1, 0.5, 0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1, 0.5, 0],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0., 0.5, 1.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0.33333333333333337`, 0.6666666666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0., 0.5, 1.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0., 0.5, 1.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0., 0.5, 1.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0., 0.6666666666666666],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0, 0, 1]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0, 0, 1],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1., 1., 0.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666667, 0.6666666666666667, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1., 1., 0.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[1., 1., 0.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1., 1., 0.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"7a36ecd3-5f22-403e-90fd-96ddfb96f9b0"]
}, Open  ]],

Cell[TextData[{
 "Clear definitions for ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"05af12cf-0a46-4bc3-b2e0-e30b204feed3"],
 " to make sure nothing gets confused later:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"a2b8302b-eb8e-4662-8dea-9c0bce45bb4e"],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"503861b3-d04f-44b3-ab07-1faa1e9098d8"],

Cell[TextData[{
 "As another example, let\[CloseCurlyQuote]s do the classic computer science \
exercise of defining the ",
 Cell[BoxData[
 "factorial"], "InlineCodeText",ExpressionUUID->
  "da726665-2b0e-4a65-b714-3b90cac48895"],
 " function. Start by saying that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"factorial", "[", "1", "]"}], "=", "1"}]], "InlineCodeText",
  ExpressionUUID->"283855a8-9155-490e-91f9-6295be849856"],
 ". Then define how to compute ",
 Cell[BoxData[
  RowBox[{"factorial", "[", 
   RowBox[{
    StyleBox["n", "CodeVariable"], 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "]"}]], "InlineCodeText",ExpressionUUID->
  "3e203d40-bf8d-4993-ae50-a50cb16b2fa8"],
 " recursively in terms of another instance of factorial."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"27dbfefb-da51-461c-9ea0-7ce52680c37f"],

Cell[TextData[{
 "Give a recursive definition of ",
 Cell[BoxData[
 "factorial"], "InlineCode",ExpressionUUID->
  "b80598d5-c439-4153-8c54-ca184932ed04"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7c114bf0-761a-4a71-a9ef-21d4188bf559"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"factorial", "[", "1", "]"}], "=", "1"}], ";", " ", 
  RowBox[{
   RowBox[{"factorial", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"n", "*", 
    RowBox[{"factorial", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"b9ef4545-68a2-4b92-8f36-6f2a0192210e"],

Cell[TextData[{
 "Ask for ",
 Cell[BoxData[
  RowBox[{"factorial", "[", "50", "]"}]], "InlineCode",ExpressionUUID->
  "45f19464-4dfd-493f-a8c9-02293eb3d928"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bfb3a5a8-10c9-4364-b860-6a102f6efaf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factorial", "[", "50", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"f041923c-f4b5-4e18-bfbb-1ba9cd9f5878"],

Cell[BoxData[\
"30414093201713378043612608166064768844377641568960512000000000000"], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"174eb8b4-f61e-4b10-9ddc-c8f6f23d80ff"]
}, Open  ]],

Cell["\<\
There\[CloseCurlyQuote]s also a built-in factorial function, which gives the \
same result:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"ec1c0dfb-72ee-4f6b-a16a-43a53eddec89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"50", "!"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"e94c57c2-3e57-462b-b86e-06ddc0e17fdb"],

Cell[BoxData[\
"30414093201713378043612608166064768844377641568960512000000000000"], "Output",\

 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"de0f2aff-6bb8-4f01-af09-bef1eb978d2f"]
}, Open  ]],

Cell[TextData[{
 "Instead of having definitions for ",
 Cell[BoxData[
  RowBox[{"factorial", "[", "1", "]"}]], "InlineCodeText",ExpressionUUID->
  "197f7673-3086-43e0-9c3a-edec3ba956e8"],
 " and ",
 Cell[BoxData[
  RowBox[{"factorial", "[", 
   RowBox[{
    StyleBox["n", "CodeVariable"], 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "]"}]], "InlineCodeText",ExpressionUUID->
  "4a05890b-6351-4b09-a6b6-cb604ced183e"],
 " we could have had a single definition and used ",
 ButtonBox["If",
  BaseStyle->"Link"],
 ". But having separate definitions for each case tends to make things much \
easier to read and understand."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"9aac07b7-9652-4507-97e3-dbcb389badbf"],

Cell[TextData[{
 "An alternative definition using ",
 ButtonBox["If",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d0e0dfe9-e98e-4b67-a8b1-d10c05beaf9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"factorial", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"n", "\[Equal]", "1"}], ",", "1", ",", 
    RowBox[{"n", "*", 
     RowBox[{"factorial", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}]}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"b7bfdba9-4777-4f80-a233-3cd9a4bcafd5"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s nice to be able to break out special cases, but the \
real power of being able to make definitions for anything comes when one goes \
beyond simple ",
 Cell[BoxData[
  RowBox[{
   StyleBox["function", "CodeVariable"], "[", 
   StyleBox["arguments", "CodeVariable"], "]"}]], "InlineCodeText",
  ExpressionUUID->"8e948939-0f08-4b84-9aa3-c9ecaf449e8e"],
 " cases."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c3560189-2671-4f0e-85a1-db926ae06614"],

Cell[TextData[{
 "As a simple example, consider making a definition for ",
 Cell[BoxData[
  RowBox[{"plusminus", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["x", "CodeVariable"], 
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"]}], ",", 
     RowBox[{
      StyleBox["y", "CodeVariable"], 
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"]}]}], "}"}], "]"}]], "InlineCodeText",
  ExpressionUUID->"258afb28-4112-4b1a-b956-b296edb88fcd"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"47e91f1e-fa57-4538-bdf4-f2c0440ecae2"],

Cell["Define a value for a pattern:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"439d4c67-e6ca-4173-9eef-b14b89ddfe66"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plusminus", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{"x", "-", "y"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"f893cf2d-57df-4285-b747-547e996a5bd2"],

Cell["Use the definition:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1ed12296-814f-4c49-941e-b61ca777495f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plusminus", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "1"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"28695deb-5005-4432-9e8b-dc54bf918161"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "3"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[15]=",ExpressionUUID->"11c28672-dd3e-4a11-83c9-d2c4edea4d87"]
}, Open  ]],

Cell[TextData[{
 "A much less elegant form based on a traditional ",
 Cell[BoxData[
  RowBox[{
   StyleBox["function", "CodeVariable"], "[", 
   StyleBox["argument", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "d3eaefab-0105-45c5-b070-1cab516fd01a"],
 " definition:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:245",ExpressionUUID->"bac1a73c-8ac4-4989-8b47-f57dd35ec5ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"plusminus", "[", "v_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", 
     RowBox[{"v", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", 
     RowBox[{"v", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"5c10d27f-f721-46cb-81b8-b17cdcfa1b1d"],

Cell["\<\
It\[CloseCurlyQuote]s very common to want to define a function that applies \
only to objects with a certain structure. This is easy to do with patterns. \
Here\[CloseCurlyQuote]s an example.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e9eb02d6-b3f6-4701-ab81-6ed0b49e9b49"],

Cell[TextData[{
 "A list with some ",
 ButtonBox["Framed",
  BaseStyle->"Link"],
 " objects:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"569659d6-2f54-4159-a463-7574c2079ad0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Framed", "[", "b", "]"}], ",", "c", ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}], "]"}], ",", "100"}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"76a2a356-a407-4c79-9c99-464cc804b65b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   FrameBox["b",
    StripOnInput->False], ",", "c", ",", 
   FrameBox[
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}],
    StripOnInput->False], ",", "100"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"08b44341-094f-4b95-b11f-bea6efeb770c"]
}, Open  ]],

Cell["Define a function that applies only to framed objects:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34939c58-a3a4-4e54-afae-dbc035965aaa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"highlight", "[", 
   RowBox[{"Framed", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"x", ",", "\"\<+\>\""}], "]"}], ",", "20", ",", 
    RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"4388d3bd-6601-42ae-9291-4878a7f62b4a"],

Cell["\<\
Apply highlight to each element of a list; it knows what to do when it\
\[CloseCurlyQuote]s given something framed:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"963c04f5-884b-4a55-87ed-df1ce0d6a457"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"highlight", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Framed", "[", "b", "]"}], ",", "c", ",", 
    RowBox[{"Framed", "[", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}], "]"}], ",", "100"}], "}"}]}]], "Input",\

 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"ddf5b995-598d-48ba-b4d3-28e7aa6497af"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"highlight", "[", "a", "]"}], ",", 
   StyleBox[
    TemplateBox[{"b", "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   RowBox[{"highlight", "[", "c", "]"}], ",", 
   StyleBox[
    TemplateBox[{
      RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   RowBox[{"highlight", "[", "100", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"9be86473-8a7c-4716-a557-034a7ba57391"]
}, Open  ]],

Cell[TextData[{
 "This definition applies to anything with head ",
 ButtonBox["List",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ec0d3726-d9cd-488c-8bf0-66ee4d1372a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"highlight", "[", "list_List", "]"}], ":=", 
  RowBox[{"highlight", "/@", "list"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"175fb92e-49d7-4159-89a0-2556dc640dac"],

Cell[TextData[{
 "Now you no longer have to use ",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCode",ExpressionUUID->
  "2e599e62-7ab1-4fb8-af49-1c37ffd1723b"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e652f104-23df-443e-bcac-8d2498944a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"highlight", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Framed", "[", "b", "]"}], ",", "c", ",", 
    RowBox[{"Framed", "[", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}], "]"}], ",", "100"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"137e12d8-476e-4144-9f13-b045b7cd76c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"highlight", "[", "a", "]"}], ",", 
   StyleBox[
    TemplateBox[{"b", "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   RowBox[{"highlight", "[", "c", "]"}], ",", 
   StyleBox[
    TemplateBox[{
      RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   RowBox[{"highlight", "[", "100", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"77d1649b-17ab-46db-83ac-874d58ce834e"]
}, Open  ]],

Cell["\<\
Give a general case, to use if none of the special cases apply:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7af5a551-f15c-4beb-98bf-83f9368eec11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"highlight", "[", "x_", "]"}], ":=", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Rotate", "[", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "Degree"}]}], "]"}], ",", "20", ",", "Orange"}], 
   "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"ebbd591c-c6a0-4d0a-9bef-624e1be67e77"],

Cell["\<\
This uses the special cases when it can, then the general case when nothing \
else applies:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e6074f84-b9af-4047-9e68-a4ef294b1e89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"highlight", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Framed", "[", "b", "]"}], ",", "c", ",", 
    RowBox[{"Framed", "[", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}], "]"}], ",", "100"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"57472c5d-0312-4a82-b49c-6afa9f54a6e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    RotationBox["a",
     BoxRotation->-0.5235987755982988],
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[1, 0.5, 0],
    $CellContext`LineColor -> RGBColor[1, 0.5, 0],
    $CellContext`FrontFaceColor -> RGBColor[1, 0.5, 0],
    $CellContext`GraphicsColor -> RGBColor[1, 0.5, 0],
    $CellContext`BackFaceColor -> RGBColor[1, 0.5, 0]], ",", 
   StyleBox[
    TemplateBox[{"b", "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   StyleBox[
    RotationBox["c",
     BoxRotation->-0.5235987755982988],
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[1, 0.5, 0],
    $CellContext`LineColor -> RGBColor[1, 0.5, 0],
    $CellContext`FrontFaceColor -> RGBColor[1, 0.5, 0],
    $CellContext`GraphicsColor -> RGBColor[1, 0.5, 0],
    $CellContext`BackFaceColor -> RGBColor[1, 0.5, 0]], ",", 
   StyleBox[
    TemplateBox[{
      RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], "\"+\""},
     "Labeled",
     DisplayFunction->(GridBox[{{
         TagBox[
          ItemBox[
           PaneBox[
            TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
            BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
          "SkipImageSizeLevel"]}, {
         ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
       GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
       AutoDelete -> False, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
       BaselinePosition -> {1, 1}]& ),
     InterpretationFunction->(RowBox[{"Labeled", "[", 
        RowBox[{#, ",", #2}], "]"}]& )],
    StripOnInput->False,
    FontSize->20,
    Background->RGBColor[1, 1, 0.85]], ",", 
   StyleBox[
    RotationBox["100",
     BoxRotation->-0.5235987755982988],
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[1, 0.5, 0],
    $CellContext`LineColor -> RGBColor[1, 0.5, 0],
    $CellContext`FrontFaceColor -> RGBColor[1, 0.5, 0],
    $CellContext`GraphicsColor -> RGBColor[1, 0.5, 0],
    $CellContext`BackFaceColor -> RGBColor[1, 0.5, 0]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[23]=",ExpressionUUID->"ec09be4b-340a-404b-9210-c3f1c69dc5e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"19d2ae8f-f9ad-42f9-84a6-7da98326e5ff"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"10 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-40-defining-your-own-functions-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"882e068f-6238-48b2-ab4f-a4c4ba725729"],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " These exercises involve defining functions. Remember to use ",
 ButtonBox["Clear",
  BaseStyle->"Link"],
 " to get rid of definitions once you\[CloseCurlyQuote]re finished with each \
exercise."
}], "ExerciseNote",ExpressionUUID->"033ec9df-f92b-49b3-a791-3eae21fc8d04"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"4acdb0bc-c6b1-4a28-bba3-afa05ac6e006"],
 " that computes the square of its argument.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2102d42d-c3c7-431f-8aba-e620e4754b15"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "poly"], "InlineCode",ExpressionUUID->"cc454676-f4d2-420b-aa07-c9d7d7801b32"],
 " that takes an integer, and makes a picture of an orange regular polygon \
with that number of sides.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"32e1d1ea-aef9-4502-9252-b0cc85127bb2"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"7787f546-96ab-44ed-8e0c-f9deb69845f8"],
 " that takes a list of two elements and puts them in reverse order.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5525be9f-a10a-4ad0-b041-9db0a624852d"],

Cell[TextData[{
 "Create a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"35ad426c-db8b-4809-8804-46cb558ca988"],
 " that takes two arguments and gives the result of multiplying them and \
dividing by their sum.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"921e7d1b-6dc1-4b17-a095-30e4adccf2ef"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"635f4780-0548-4f74-b629-74714b86abf8"],
 " that takes a list of two elements and returns a list of their sum, \
difference and ratio.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"937c01ec-9401-4812-a6b2-496ac94f6464"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "evenodd"], "InlineCode",ExpressionUUID->
  "e1a998c6-c73f-42ae-9224-9fb75b7ebd65"],
 " that gives ",
 ButtonBox["Black",
  BaseStyle->"Link"],
 " if its argument is even and ",
 ButtonBox["White",
  BaseStyle->"Link"],
 " otherwise, but gives ",
 ButtonBox["Red",
  BaseStyle->"Link"],
 " if its argument is 0.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"43da641f-c26f-4c92-a1a4-1b82ce997969"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"30f7bbad-8590-45d3-b788-abc858805353"],
 " of three arguments where the second two arguments are added if the first \
argument is 1, multiplied if it\[CloseCurlyQuote]s 2 and raised to a power if \
it\[CloseCurlyQuote]s 3.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"25693477-4a27-4f65-bfbf-626db362986f"],

Cell[TextData[{
 "Define a Fibonacci function ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"8917b7ea-9543-4a6f-ba31-0012922cd354"],
 " with ",
 Cell[BoxData[
  RowBox[{"f", "[", "0", "]"}]], "InlineCode",ExpressionUUID->
  "a169efd7-2d43-4764-9ece-35bca9f2db73"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineCode",ExpressionUUID->
  "37be8620-db2b-4051-b56a-192ca753014e"],
 " both being 1, and ",
 Cell[BoxData[
  RowBox[{"f", "[", "n", "]"}]], "InlineCode",ExpressionUUID->
  "6f740b74-0edc-4078-b99c-568878a787b8"],
 " for integer ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2c34d29e-e21a-4530-a7fe-fe503fe179a7"],
 " being the sum of ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"n", "-", "1"}], "]"}]], "InlineCode",ExpressionUUID->
  "f3395300-e7f2-417f-8f52-0933f8e3e945"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"n", "-", "2"}], "]"}]], "InlineCode",ExpressionUUID->
  "f9bc0266-8c3b-4308-9af4-8c152b31db08"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"e7d9b85b-9453-483d-8e40-0168be035c93"],

Cell[TextData[{
 "Create a function ",
 Cell[BoxData[
 "animal"], "InlineCode",ExpressionUUID->
  "f330bf75-98f7-45b2-8f5f-2541ebd52454"],
 " that takes a string, and gives a picture of an animal with that name.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bc930a76-70e4-4bc4-9828-6e2e7775b082"],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData[
 "nearwords"], "InlineCode",ExpressionUUID->
  "3f1f37f3-6d7e-414d-a24a-bdc59f782697"],
 " that takes a string and an integer ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"769c80c1-c4ab-4cb4-88b7-8dee08e3ccb4"],
 ", and gives the ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"3c2dc73b-1396-441a-bec4-52bf1dea40f0"],
 " words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "6bbcd598-0a0e-46a8-9631-0573fe33de0b"],
 " that are nearest to a given string.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "40.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"02853a4f-399a-4cbd-833e-d4ca419b3af4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f2ac608-e755-4eba-b5f5-17d1158c628d"],

Cell["What kind of a pattern can be used in a function definition?", \
"Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"51366dbd-9045-453a-85f0-c0a825ce1201"],

Cell["\<\
Absolutely any pattern you want. Even one where the head is itself a pattern.\
\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f2fcec84-a516-42db-85b8-45cae9b37417"],

Cell["\<\
How can I see the definitions made for a particular function?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"9ad4addb-5790-4806-a887-5bc415de1931"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"?", "f"}]], "InlineCode",ExpressionUUID->
  "6ef8b7ab-c1f5-4f4b-8bb7-0d01b1eb7cb5"],
 " to see the definitions for ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"dabe1348-0af3-4954-8269-ef73104964e3"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"106df22c-1f02-409a-a81c-48ec2c434a66"],

Cell["How do I overwrite an existing function definition?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc3f1c35-3bd9-45ff-a06b-ecd9b929c22a"],

Cell[TextData[{
 "Just make a new definition for the same pattern. Use ",
 ButtonBox["Clear",
  BaseStyle->"Link"],
 " to remove all definitions."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"632ad18e-853e-4cfe-b144-d19d991b6833"],

Cell["\<\
How are different definitions for a particular function sorted?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0b70d23f-df0a-45fe-a746-f35f8ff98af7"],

Cell[TextData[{
 "Typically from most specific to least specific. If there are definitions \
that can\[CloseCurlyQuote]t be ordered by specificity, definitions made later \
are put later. When definitions are used, the earlier ones are tried first. \
",
 Cell[BoxData[
  RowBox[{"?", "f"}]], "InlineCode",ExpressionUUID->
  "c1c22d9c-fffd-497f-b13b-5c021ab70e32"],
 " shows the ordering of definitions for ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"313a1741-8d2b-4c64-ac35-5ecfac885cf4"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b8a632e6-28ff-4084-ac5d-9495e29d12ad"],

Cell[TextData[{
 "Can I redefine built-in functions like ",
 ButtonBox["Max",
  BaseStyle->"Link"],
 " or ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3325ced9-a1a5-4e3c-8c6b-28f1d807c92e"],

Cell[TextData[{
 "Usually yes. First, though, you often have to say e.g. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unprotect",
    BaseStyle->"CodeLink"], "[", "Max", "]"}]], "InlineCode",ExpressionUUID->
  "63aff070-2dbe-406c-be35-9d140f118644"],
 ". Then definitions you add will be used in preference to built-in ones. \
Some functions, like ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ", are so fundamental that the system locks them in a protected state. Even \
in this case, though, you can make \[OpenCurlyDoubleQuote]upvalue\
\[CloseCurlyDoubleQuote] definitions that are associated with particular \
structures of arguments. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"c737b804-d2d2-42a9-b871-66812c4dc9bb"],

Cell["\<\
Can I do object-oriented programming in the Wolfram Language?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2168ee14-0cfe-451e-b78a-4db8041b0b2c"],

Cell[TextData[{
 "A symbolic generalization of object-oriented programming, yes. Given an \
object \[OpenCurlyDoubleQuote]type\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
 "t"], "InlineCode",ExpressionUUID->"659d7aa5-bdca-4483-b1d6-bd8fa7b6387b"],
 ", one wants to make definitions e.g. for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"t", "[", "\[NegativeThinSpace]", 
    StyleBox["...",
     FontColor->GrayLevel[0.5]], "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "3d20f5d0-a665-4ffb-acd1-e4084630431a"],
 " and ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"t", "[", "\[NegativeThinSpace]", 
    StyleBox["...",
     FontColor->GrayLevel[0.5]], "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "164e995d-bb6b-4a2b-8fc5-c22802dfb2bb"],
 ". One can associate such definitions with ",
 Cell[BoxData[
 "t"], "InlineCode",ExpressionUUID->"da70a8fe-5917-4651-9e2e-b7910665a840"],
 " by saying ",
 Cell[BoxData[
  RowBox[{"t", "/:", 
   RowBox[{"f", "[", 
    RowBox[{"t", "[", "\[NegativeThinSpace]", 
     StyleBox["...",
      FontColor->GrayLevel[0.5]], "]"}], "]"}], "=", 
   "\[NegativeThinSpace]\[NegativeThinSpace]", 
   StyleBox["...",
    FontColor->GrayLevel[0.5]]}]], "InlineCode",ExpressionUUID->
  "51e4a7f4-f59c-47b3-b007-a3aaba4da657"],
 " In the Wolfram Language, this is called ",
 StyleBox["defining an upvalue for ",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox["t", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "76ea50bd-a3ae-4ac0-8d89-fb3de14ca9f0"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:10"},ExpressionUUID->"b3f2fccd-4e7e-46e7-8bf8-c7419398dec9"],

Cell[TextData[{
 "Can I use ",
 Cell[BoxData[
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"Set"]], "InlineCode",ExpressionUUID->
  "f4d62cdf-173b-4f80-a4f5-a6fc267393d9"],
 " instead of ",
 Cell[BoxData[
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"SetDelayed"]], "InlineCode",ExpressionUUID->
  "dfb5f1be-37f1-47e8-b66f-70b38ff85535"],
 " for function definitions?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:247",ExpressionUUID->"8a46f636-6252-4dcb-b754-b2dd027fbcee"],

Cell[TextData[{
 "Sometimes. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], "]"}], 
   ButtonBox["=",
    BaseStyle->"Link",
    ButtonData->"Set"], "n", 
   ButtonBox["^",
    BaseStyle->"Link",
    ButtonData->"Power"], "2"}]], "InlineCode",ExpressionUUID->
  "c457436f-435e-4026-b16b-c190dccf8a42"],
 " will work fine, because the right-hand side doesn\[CloseCurlyQuote]t \
evaluate when you make the assignment. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], "]"}], 
   ButtonBox["=",
    BaseStyle->"Link",
    ButtonData->"Set"], 
   ButtonBox["Now",
    BaseStyle->"CodeLink"]}]], "InlineCode",ExpressionUUID->
  "edf6b65e-835b-4a2e-ac95-a93f72115c8f"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], "]"}], 
   ButtonBox[":=",
    BaseStyle->"Link",
    ButtonData->"SetDelayed"], "Now"}]], "InlineCode",ExpressionUUID->
  "652e788a-5195-4be5-bb72-56310558639b"],
 " will give different results. And in many cases the right-hand side can\
\[CloseCurlyQuote]t be meaningfully evaluated until specific arguments are \
given."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26e5c12d-9478-4f48-b4be-8aab5b33dab2"],

Cell["How can I share function definitions with other people?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2e10f008-f30f-48d4-9158-a2c0abf3b0c7"],

Cell[TextData[{
 "Just send the code! A convenient way to do this through the cloud is to use \
",
 ButtonBox["CloudSave",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["CloudGet",
  BaseStyle->"Link"],
 ", as discussed in ",
 ButtonBox["Section 43",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-43-storing-things.nb", "CloudSave-CloudGet"}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"edfa26cd-ff67-483b-b7af-8e244680ccbd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1303c3c9-c0a0-409b-a0e4-f8e023c3022e"],

Cell[TextData[{
 "Many low-level languages require functions to have particular ",
 StyleBox["static types",
  FontSlant->"Italic"],
 " of arguments (e.g. integers, reals, strings). Some languages allow ",
 StyleBox["dynamic typing",
  FontSlant->"Italic"],
 ", with arguments allowed to have any of a certain set of types. The Wolfram \
Language generalizes this by allowing arguments to be defined by arbitrary \
symbolic structures."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"cdec5478-f87f-43c1-8663-a74afe1f11e8"],

Cell[TextData[{
 "Having a pattern like ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], ",", 
    RowBox[{"y", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}]}], "}"}]], "InlineCode",ExpressionUUID->
  "1a5dded3-42dd-401e-aa04-e8ffdcda0bbf"],
 " in a function definition allows immediate and convenient ",
 StyleBox["destructuring",
  FontSlant->"Italic"],
 " of the function argument. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"de3c02fa-90cf-41c5-9c3c-baca1508eb61"],

Cell[TextData[{
 "Definitions can be associated with the head of a function (\
\[OpenCurlyDoubleQuote]downvalues\[CloseCurlyDoubleQuote]), with the heads of \
its arguments (\[OpenCurlyDoubleQuote]upvalues\[CloseCurlyDoubleQuote]) or \
with the head of the head, etc. (\[OpenCurlyDoubleQuote]subvalues\
\[CloseCurlyDoubleQuote]). Upvalues are effectively a generalization of ",
 StyleBox["methods",
  FontSlant->"Italic"],
 " in object-oriented languages. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"1a27001b-36d3-4925-9200-8eb6c0c8ec3d"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", "=", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"], 
     ButtonBox["^",
      BaseStyle->"Link",
      ButtonData->"Power"], "2", 
     ButtonBox["&",
      BaseStyle->"Link",
      ButtonData->"Function"]}], ")"}]}]], "InlineCode",ExpressionUUID->
  "97de08b4-16c5-4e49-a58c-5cfd49bc9ec1"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], "]"}], 
   ButtonBox[":=",
    BaseStyle->"Link",
    ButtonData->"SetDelayed"], "n", 
   ButtonBox["^",
    BaseStyle->"Link",
    ButtonData->"Power"], "2"}]], "InlineCode",ExpressionUUID->
  "eb5115fb-c62b-417c-8fc9-28674897a063"],
 " are two ways of defining a function, that for example give the same \
results for ",
 Cell[BoxData[
  RowBox[{"f", "[", "10", "]"}]], "InlineCode",ExpressionUUID->
  "c2129fdb-71b4-4455-9e72-12c1aa61b792"],
 ". Pure function definitions tend to be easier to combine with each other, \
but much coarser in their handling of argument structures. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"a7b9b405-3e36-45e0-96ad-e13c06cbf81f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4431cdbf-4805-4d85-920f-0994b7b1b097"],

Cell[TextData[ButtonBox["Guide to Defining Functions in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"06a0e156-6df0-4b34-9966-e7f0c775030d"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Defining Your Own Function: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-39-immediate-and-delayed-values.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-39-immediate-and-delayed-values.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Immediate and Delayed Values\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Immediate and Delayed Values", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"More about Patterns\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "More about Patterns", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->327,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Defining Your Own Functions \[LongDash] wolfr.am/eiwl-", "Header"], 
      
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"75120b1b-bd07-483f-ac43-4327fa2e88df"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:243"->{
  Cell[671, 24, 453, 11, 93, "SectionDoubleDigit",ExpressionUUID->"d2d98f30-2466-45f8-b70e-41dc538ba745",
   CounterAssignments->{{"Section", 39}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:243"]},
 "i:1"->{
  Cell[1127, 37, 471, 10, 115, "Text",ExpressionUUID->"6f34cbdb-76df-4249-bcd4-dc6abaf52c9c",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1601, 49, 246, 7, 40, "Text",ExpressionUUID->"a4c875c7-ebf2-48cd-a0d2-9e27aade6ab0",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[43012, 1227, 933, 28, 70, "Text",ExpressionUUID->"cbbe3a6a-32ec-412d-8f61-8ce926ebeaa2",
   CellTags->"i:3"]},
 "LastCellOfAPage"->{
  Cell[44244, 1268, 370, 11, 70, "Input",ExpressionUUID->"6811aa02-4d24-4410-8b29-d5ebd584b1b2",
   CellTags->"LastCellOfAPage"],
  Cell[63587, 1842, 248, 7, 70, "Output",ExpressionUUID->"11c28672-dd3e-4a11-83c9-d2c4edea4d87",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[73958, 2175, 3065, 81, 70, "Output",ExpressionUUID->"ec09be4b-340a-404b-9210-c3f1c69dc5e1",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[94437, 2804, 1671, 46, 70, "Answer",ExpressionUUID->"b3f2fccd-4e7e-46e7-8bf8-c7419398dec9",
   CellTags->{"LastCellOfAPage", "i:10"}],
  Cell[102345, 3065, 354, 8, 70, "MoreExplore",ExpressionUUID->"06a0e156-6df0-4b34-9966-e7f0c775030d",
   CellTags->"LastCellOfAPage"]},
 "p:244"->{
  Cell[44617, 1281, 252, 7, 70, "CodeCaption",ExpressionUUID->"b49785f1-4ada-4c16-97b2-d07969ccd2d2",
   CellTags->"p:244"]},
 "i:4"->{
  Cell[56564, 1601, 334, 9, 70, "CodeCaption",ExpressionUUID->"a2b8302b-eb8e-4662-8dea-9c0bce45bb4e",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[57059, 1617, 912, 25, 70, "Text",ExpressionUUID->"27dbfefb-da51-461c-9ea0-7ce52680c37f",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[59394, 1696, 257, 7, 70, "CodeCaption",ExpressionUUID->"ec1c0dfb-72ee-4f6b-a16a-43a53eddec89",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[60078, 1721, 795, 23, 70, "Text",ExpressionUUID->"9aac07b7-9652-4507-97e3-dbcb389badbf",
   CellTags->"i:7"]},
 "p:245"->{
  Cell[63850, 1852, 435, 12, 70, "CodeCaption",ExpressionUUID->"bac1a73c-8ac4-4989-8b47-f57dd35ec5ce",
   CellTags->"p:245"]},
 "i:8"->{
  Cell[91181, 2695, 224, 6, 70, "Question",ExpressionUUID->"9ad4addb-5790-4806-a887-5bc415de1931",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[93436, 2775, 786, 19, 70, "Answer",ExpressionUUID->"c737b804-d2d2-42a9-b871-66812c4dc9bb",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[94437, 2804, 1671, 46, 70, "Answer",ExpressionUUID->"b3f2fccd-4e7e-46e7-8bf8-c7419398dec9",
   CellTags->{"LastCellOfAPage", "i:10"}]},
 "p:247"->{
  Cell[96111, 2852, 540, 18, 70, "Question",ExpressionUUID->"8a46f636-6252-4dcb-b754-b2dd027fbcee",
   CellTags->"p:247"]},
 "i:11"->{
  Cell[98996, 2958, 588, 14, 70, "TechNote",ExpressionUUID->"cdec5478-f87f-43c1-8663-a74afe1f11e8",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[99587, 2974, 657, 22, 70, "TechNote",ExpressionUUID->"de3c02fa-90cf-41c5-9c3c-baca1508eb61",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[100247, 2998, 609, 13, 70, "TechNote",ExpressionUUID->"1a27001b-36d3-4925-9200-8eb6c0c8ec3d",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[100859, 3013, 1281, 41, 70, "TechNote",ExpressionUUID->"a7b9b405-3e36-45e0-96ad-e13c06cbf81f",
   CellTags->"i:14"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:243", 193476, 4914},
 {"i:1", 193716, 4918},
 {"i:2", 193842, 4921},
 {"i:3", 193966, 4924},
 {"LastCellOfAPage", 194106, 4927},
 {"p:244", 194835, 4940},
 {"i:4", 194971, 4943},
 {"i:5", 195105, 4946},
 {"i:6", 195233, 4949},
 {"i:7", 195367, 4952},
 {"p:245", 195497, 4955},
 {"i:8", 195634, 4958},
 {"i:9", 195765, 4961},
 {"i:10", 195896, 4964},
 {"p:247", 196051, 4967},
 {"i:11", 196186, 4970},
 {"i:12", 196320, 4973},
 {"i:13", 196454, 4976},
 {"i:14", 196589, 4979}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[671, 24, 453, 11, 93, "SectionDoubleDigit",ExpressionUUID->"d2d98f30-2466-45f8-b70e-41dc538ba745",
 CounterAssignments->{{"Section", 39}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:243"],
Cell[1127, 37, 471, 10, 115, "Text",ExpressionUUID->"6f34cbdb-76df-4249-bcd4-dc6abaf52c9c",
 CellTags->"i:1"],
Cell[1601, 49, 246, 7, 40, "Text",ExpressionUUID->"a4c875c7-ebf2-48cd-a0d2-9e27aade6ab0",
 CellTags->"i:2"],
Cell[1850, 58, 311, 10, 37, "CodeCaption",ExpressionUUID->"904ee3b0-24b5-4d31-a977-e6c320727242"],
Cell[2164, 70, 239, 6, 29, "Input",ExpressionUUID->"e1e74268-c33b-429f-9638-f191b0d95af1"],
Cell[2406, 78, 177, 4, 37, "CodeCaption",ExpressionUUID->"00b7e7e1-038d-4403-ab8d-d67756956959"],
Cell[CellGroupData[{
Cell[2608, 86, 155, 3, 29, "Input",ExpressionUUID->"6271f144-6569-42cb-bfb0-c403b4cd27cf"],
Cell[2766, 91, 7876, 217, 40, "Output",ExpressionUUID->"de2ab7ee-eb3c-4f5b-987b-b99e97f3c39c",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[10679, 313, 156, 3, 29, "Input",ExpressionUUID->"21acdcf9-b17b-4ecf-b1b4-81cc075968e3"],
Cell[10838, 318, 15501, 427, 40, "Output",ExpressionUUID->"24b234a5-4996-44c9-9c1b-37d2db2fa302",
 Evaluatable->False]
}, Open  ]],
Cell[26354, 748, 1058, 30, 91, "Text",ExpressionUUID->"a1a18ea5-ed1b-4f4b-9ddc-c3b947d36287"],
Cell[27415, 780, 312, 8, 65, "Text",ExpressionUUID->"d6dee6a0-efc9-4463-ad81-eb9165626f1c"],
Cell[27730, 790, 189, 4, 37, "CodeCaption",ExpressionUUID->"952558a9-75b7-415c-90a1-ab65b8fb8419"],
Cell[CellGroupData[{
Cell[27944, 798, 366, 9, 29, "Input",ExpressionUUID->"f715911a-be2d-4381-9ac0-8fe502b4c2c6"],
Cell[28313, 809, 7979, 217, 40, "Output",ExpressionUUID->"39aedb7d-d40c-4731-a087-99012d9a66ca",
 Evaluatable->False]
}, Open  ]],
Cell[36307, 1029, 524, 18, 39, "CodeCaption",ExpressionUUID->"2cd53f18-bcce-4d46-84ce-bab5e04454e7"],
Cell[36834, 1049, 267, 7, 29, "Input",ExpressionUUID->"fa0e33fa-7702-46ab-b69e-0e465c796923"],
Cell[37104, 1058, 581, 18, 70, "CodeCaption",ExpressionUUID->"a2fd0b7a-8d3b-4861-b98d-3da224c1393e"],
Cell[CellGroupData[{
Cell[37710, 1080, 363, 9, 70, "Input",ExpressionUUID->"80293250-15d6-4c5d-98de-27d1fdff9c48"],
Cell[38076, 1091, 4921, 133, 70, "Output",ExpressionUUID->"6620eb32-4a64-4142-af7c-3e2d2411b02c",
 Evaluatable->False]
}, Open  ]],
Cell[43012, 1227, 933, 28, 70, "Text",ExpressionUUID->"cbbe3a6a-32ec-412d-8f61-8ce926ebeaa2",
 CellTags->"i:3"],
Cell[43948, 1257, 293, 9, 70, "CodeCaption",ExpressionUUID->"2f490fc9-3e8c-4273-ac48-a467b264cf56"],
Cell[44244, 1268, 370, 11, 70, "Input",ExpressionUUID->"6811aa02-4d24-4410-8b29-d5ebd584b1b2",
 CellTags->"LastCellOfAPage"],
Cell[44617, 1281, 252, 7, 70, "CodeCaption",ExpressionUUID->"b49785f1-4ada-4c16-97b2-d07969ccd2d2",
 CellTags->"p:244"],
Cell[CellGroupData[{
Cell[44894, 1292, 363, 9, 70, "Input",ExpressionUUID->"0070c472-7c54-49f7-8e4d-76035ca6bb50"],
Cell[45260, 1303, 11289, 295, 70, "Output",ExpressionUUID->"7a36ecd3-5f22-403e-90fd-96ddfb96f9b0",
 Evaluatable->False]
}, Open  ]],
Cell[56564, 1601, 334, 9, 70, "CodeCaption",ExpressionUUID->"a2b8302b-eb8e-4662-8dea-9c0bce45bb4e",
 CellTags->"i:4"],
Cell[56901, 1612, 155, 3, 70, "Input",ExpressionUUID->"503861b3-d04f-44b3-ab07-1faa1e9098d8"],
Cell[57059, 1617, 912, 25, 70, "Text",ExpressionUUID->"27dbfefb-da51-461c-9ea0-7ce52680c37f",
 CellTags->"i:5"],
Cell[57974, 1644, 298, 10, 70, "CodeCaption",ExpressionUUID->"7c114bf0-761a-4a71-a9ef-21d4188bf559"],
Cell[58275, 1656, 369, 10, 70, "Input",ExpressionUUID->"b9ef4545-68a2-4b92-8f36-6f2a0192210e"],
Cell[58647, 1668, 302, 10, 70, "CodeCaption",ExpressionUUID->"bfb3a5a8-10c9-4364-b860-6a102f6efaf5"],
Cell[CellGroupData[{
Cell[58974, 1682, 161, 3, 70, "Input",ExpressionUUID->"f041923c-f4b5-4e18-bfbb-1ba9cd9f5878"],
Cell[59138, 1687, 241, 6, 70, "Output",ExpressionUUID->"174eb8b4-f61e-4b10-9ddc-c8f6f23d80ff",
 Evaluatable->False]
}, Open  ]],
Cell[59394, 1696, 257, 7, 70, "CodeCaption",ExpressionUUID->"ec1c0dfb-72ee-4f6b-a16a-43a53eddec89",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[59676, 1707, 143, 3, 70, "Input",ExpressionUUID->"e94c57c2-3e57-462b-b86e-06ddc0e17fdb"],
Cell[59822, 1712, 241, 6, 70, "Output",ExpressionUUID->"de0f2aff-6bb8-4f01-af09-bef1eb978d2f",
 Evaluatable->False]
}, Open  ]],
Cell[60078, 1721, 795, 23, 70, "Text",ExpressionUUID->"9aac07b7-9652-4507-97e3-dbcb389badbf",
 CellTags->"i:7"],
Cell[60876, 1746, 235, 9, 70, "CodeCaption",ExpressionUUID->"d0e0dfe9-e98e-4b67-a8b1-d10c05beaf9b"],
Cell[61114, 1757, 378, 10, 70, "Input",ExpressionUUID->"b7bfdba9-4777-4f80-a233-3cd9a4bcafd5"],
Cell[61495, 1769, 533, 14, 70, "Text",ExpressionUUID->"c3560189-2671-4f0e-85a1-db926ae06614"],
Cell[62031, 1785, 646, 22, 70, "Text",ExpressionUUID->"47e91f1e-fa57-4538-bdf4-f2c0440ecae2"],
Cell[62680, 1809, 172, 4, 70, "CodeCaption",ExpressionUUID->"439d4c67-e6ca-4173-9eef-b14b89ddfe66"],
Cell[62855, 1815, 332, 10, 70, "Input",ExpressionUUID->"f893cf2d-57df-4285-b747-547e996a5bd2"],
Cell[63190, 1827, 162, 4, 70, "CodeCaption",ExpressionUUID->"1ed12296-814f-4c49-941e-b61ca777495f"],
Cell[CellGroupData[{
Cell[63377, 1835, 207, 5, 70, "Input",ExpressionUUID->"28695deb-5005-4432-9e8b-dc54bf918161"],
Cell[63587, 1842, 248, 7, 70, "Output",ExpressionUUID->"11c28672-dd3e-4a11-83c9-d2c4edea4d87",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[63850, 1852, 435, 12, 70, "CodeCaption",ExpressionUUID->"bac1a73c-8ac4-4989-8b47-f57dd35ec5ce",
 CellTags->"p:245"],
Cell[64288, 1866, 514, 16, 70, "Input",ExpressionUUID->"5c10d27f-f721-46cb-81b8-b17cdcfa1b1d"],
Cell[64805, 1884, 335, 8, 70, "Text",ExpressionUUID->"e9eb02d6-b3f6-4701-ab81-6ed0b49e9b49"],
Cell[65143, 1894, 232, 9, 70, "CodeCaption",ExpressionUUID->"569659d6-2f54-4159-a463-7574c2079ad0"],
Cell[CellGroupData[{
Cell[65400, 1907, 321, 8, 70, "Input",ExpressionUUID->"76a2a356-a407-4c79-9c99-464cc804b65b"],
Cell[65724, 1917, 379, 12, 70, "Output",ExpressionUUID->"08b44341-094f-4b95-b11f-bea6efeb770c",
 Evaluatable->False]
}, Open  ]],
Cell[66118, 1932, 197, 4, 70, "CodeCaption",ExpressionUUID->"34939c58-a3a4-4e54-afae-dbc035965aaa"],
Cell[66318, 1938, 406, 10, 70, "Input",ExpressionUUID->"4388d3bd-6601-42ae-9291-4878a7f62b4a"],
Cell[66727, 1950, 266, 7, 70, "CodeCaption",ExpressionUUID->"963c04f5-884b-4a55-87ed-df1ce0d6a457"],
Cell[CellGroupData[{
Cell[67018, 1961, 362, 10, 70, "Input",ExpressionUUID->"ddf5b995-598d-48ba-b4d3-28e7aa6497af"],
Cell[67383, 1973, 2045, 53, 70, "Output",ExpressionUUID->"9be86473-8a7c-4716-a557-034a7ba57391",
 Evaluatable->False]
}, Open  ]],
Cell[69443, 2029, 251, 9, 70, "CodeCaption",ExpressionUUID->"ec0d3726-d9cd-488c-8bf0-66ee4d1372a3"],
Cell[69697, 2040, 227, 5, 70, "Input",ExpressionUUID->"175fb92e-49d7-4159-89a0-2556dc640dac"],
Cell[69927, 2047, 346, 12, 70, "CodeCaption",ExpressionUUID->"e652f104-23df-443e-bcac-8d2498944a00"],
Cell[CellGroupData[{
Cell[70298, 2063, 367, 10, 70, "Input",ExpressionUUID->"137e12d8-476e-4144-9f13-b045b7cd76c2"],
Cell[70668, 2075, 2045, 53, 70, "Output",ExpressionUUID->"77d1649b-17ab-46db-83ac-874d58ce834e",
 Evaluatable->False]
}, Open  ]],
Cell[72728, 2131, 214, 6, 70, "CodeCaption",ExpressionUUID->"7af5a551-f15c-4beb-98bf-83f9368eec11"],
Cell[72945, 2139, 373, 11, 70, "Input",ExpressionUUID->"ebbd591c-c6a0-4d0a-9bef-624e1be67e77"],
Cell[73321, 2152, 242, 7, 70, "CodeCaption",ExpressionUUID->"e6074f84-b9af-4047-9e68-a4ef294b1e89"],
Cell[CellGroupData[{
Cell[73588, 2163, 367, 10, 70, "Input",ExpressionUUID->"57472c5d-0312-4a82-b49c-6afa9f54a6e2"],
Cell[73958, 2175, 3065, 81, 70, "Output",ExpressionUUID->"ec09be4b-340a-404b-9210-c3f1c69dc5e1",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77072, 2262, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"19d2ae8f-f9ad-42f9-84a6-7da98326e5ff"],
Cell[CellGroupData[{
Cell[78877, 2312, 1292, 41, 70, "ExerciseSummaryCell",ExpressionUUID->"882e068f-6238-48b2-ab4f-a4c4ba725729"],
Cell[80172, 2355, 330, 8, 70, "ExerciseNote",ExpressionUUID->"033ec9df-f92b-49b3-a791-3eae21fc8d04"],
Cell[80505, 2365, 822, 23, 70, "Exercise",ExpressionUUID->"2102d42d-c3c7-431f-8aba-e620e4754b15"],
Cell[81330, 2390, 884, 24, 70, "Exercise",ExpressionUUID->"32e1d1ea-aef9-4502-9252-b0cc85127bb2"],
Cell[82217, 2416, 846, 23, 70, "Exercise",ExpressionUUID->"5525be9f-a10a-4ad0-b041-9db0a624852d"],
Cell[83066, 2441, 875, 24, 70, "Exercise",ExpressionUUID->"921e7d1b-6dc1-4b17-a095-30e4adccf2ef"],
Cell[83944, 2467, 871, 24, 70, "Exercise",ExpressionUUID->"937c01ec-9401-4812-a6b2-496ac94f6464"],
Cell[84818, 2493, 1013, 33, 70, "Exercise",ExpressionUUID->"43da641f-c26f-4c92-a1a4-1b82ce997969"],
Cell[85834, 2528, 960, 25, 70, "Exercise",ExpressionUUID->"25693477-4a27-4f65-bfbf-626db362986f"],
Cell[86797, 2555, 1632, 48, 70, "Exercise",ExpressionUUID->"e7d9b85b-9453-483d-8e40-0168be035c93"],
Cell[88432, 2605, 858, 24, 70, "Exercise",ExpressionUUID->"bc930a76-70e4-4bc4-9828-6e2e7775b082"],
Cell[89293, 2631, 1259, 36, 70, "Exercise",ExpressionUUID->"02853a4f-399a-4cbd-833e-d4ca419b3af4"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90601, 2673, 144, 4, 70, "QASection",ExpressionUUID->"5f2ac608-e755-4eba-b5f5-17d1158c628d"],
Cell[90748, 2679, 202, 5, 70, "Question",ExpressionUUID->"51366dbd-9045-453a-85f0-c0a825ce1201"],
Cell[90953, 2686, 225, 7, 70, "Answer",ExpressionUUID->"f2fcec84-a516-42db-85b8-45cae9b37417"],
Cell[91181, 2695, 224, 6, 70, "Question",ExpressionUUID->"9ad4addb-5790-4806-a887-5bc415de1931",
 CellTags->"i:8"],
Cell[91408, 2703, 399, 13, 70, "Answer",ExpressionUUID->"106df22c-1f02-409a-a81c-48ec2c434a66"],
Cell[91810, 2718, 191, 4, 70, "Question",ExpressionUUID->"fc3f1c35-3bd9-45ff-a06b-ecd9b929c22a"],
Cell[92004, 2724, 280, 9, 70, "Answer",ExpressionUUID->"632ad18e-853e-4cfe-b144-d19d991b6833"],
Cell[92287, 2735, 211, 6, 70, "Question",ExpressionUUID->"0b70d23f-df0a-45fe-a746-f35f8ff98af7"],
Cell[92501, 2743, 639, 16, 70, "Answer",ExpressionUUID->"b8a632e6-28ff-4084-ac5d-9495e29d12ad"],
Cell[93143, 2761, 290, 12, 70, "Question",ExpressionUUID->"3325ced9-a1a5-4e3c-8c6b-28f1d807c92e"],
Cell[93436, 2775, 786, 19, 70, "Answer",ExpressionUUID->"c737b804-d2d2-42a9-b871-66812c4dc9bb",
 CellTags->"i:9"],
Cell[94225, 2796, 209, 6, 70, "Question",ExpressionUUID->"2168ee14-0cfe-451e-b78a-4db8041b0b2c"],
Cell[94437, 2804, 1671, 46, 70, "Answer",ExpressionUUID->"b3f2fccd-4e7e-46e7-8bf8-c7419398dec9",
 CellTags->{"LastCellOfAPage", "i:10"}],
Cell[96111, 2852, 540, 18, 70, "Question",ExpressionUUID->"8a46f636-6252-4dcb-b754-b2dd027fbcee",
 CellTags->"p:247"],
Cell[96654, 2872, 1463, 50, 70, "Answer",ExpressionUUID->"26e5c12d-9478-4f48-b4be-8aab5b33dab2"],
Cell[98120, 2924, 195, 4, 70, "Question",ExpressionUUID->"2e10f008-f30f-48d4-9158-a2c0abf3b0c7"],
Cell[98318, 2930, 481, 17, 70, "Answer",ExpressionUUID->"edfa26cd-ff67-483b-b7af-8e244680ccbd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98836, 2952, 157, 4, 70, "TechNoteSection",ExpressionUUID->"1303c3c9-c0a0-409b-a0e4-f8e023c3022e"],
Cell[98996, 2958, 588, 14, 70, "TechNote",ExpressionUUID->"cdec5478-f87f-43c1-8663-a74afe1f11e8",
 CellTags->"i:11"],
Cell[99587, 2974, 657, 22, 70, "TechNote",ExpressionUUID->"de3c02fa-90cf-41c5-9c3c-baca1508eb61",
 CellTags->"i:12"],
Cell[100247, 2998, 609, 13, 70, "TechNote",ExpressionUUID->"1a27001b-36d3-4925-9200-8eb6c0c8ec3d",
 CellTags->"i:13"],
Cell[100859, 3013, 1281, 41, 70, "TechNote",ExpressionUUID->"a7b9b405-3e36-45e0-96ad-e13c06cbf81f",
 CellTags->"i:14"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102177, 3059, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"4431cdbf-4805-4d85-920f-0994b7b1b097"],
Cell[102345, 3065, 354, 8, 70, "MoreExplore",ExpressionUUID->"06a0e156-6df0-4b34-9966-e7f0c775030d",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature fIj#URAgYoHIgJObypU#k3oL *)
