(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    559679,      10132]
NotebookOptionsPosition[    494864,       8782]
NotebookOutlinePosition[    553627,       9990]
CellTagsIndexPosition[    553548,       9985]
WindowTitle->Assigning Names to Things: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Module",
  FontFamily->"Source Sans Pro"],
 " to compute ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "x"}]], "InlineCode",ExpressionUUID->
  "a9d07442-30e9-48ae-ac11-fad40d35a5bf"],
 " where ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"357f644e-0521-4b09-b7ed-2cfe2d8607d5"],
 " is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Range",
    FontFamily->"Source Sans Pro"], "[", "10", "]"}]], "InlineCode",
  ExpressionUUID->"2737a7de-c7a1-4656-80b9-0f0be473000c"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"4132f952-f6d2-4e93-9311-3d1307f10593"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b7265290-2cf5-4e53-931a-af061d165367"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWb2vpDYQR0mTMlL+gvwD1GkpU610UTqaO+VxSvOC7iJFtHSUdO6oqKio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            "], {{0, 19}, {195, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{195, 19},
          PlotRange->{{0, 195}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{199, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "874742f5-8ac4-4abd-874e-bfdfd4e02986"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWb2vpDYQR0mTMlL+gvwD1GkpU610UTqaO+VxSvOC7iJFtHSUdO6oqKio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              "], {{0, 19}, {195, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {195, 19}, 
            PlotRange -> {{0, 195}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"52802dbb-ec97-44dc-aa47-71a6669cab5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"68eaff8f-87da-4bfd-849d-7bce71683f26"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2f4fce84-e133-4675-91de-a6018ce06c26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"185646e7-d4e9-4167-89e2-5ea6ae84838b"],

Cell[TextData[{
 "Use ",
 StyleBox["Module",
  FontFamily->"Source Sans Pro"],
 " to generate a list of 10 random integers up to 100, then make a column \
giving the original list, and the results of applying ",
 StyleBox["Sort",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["Max",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Total",
  FontFamily->"Source Sans Pro"],
 " to it."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"1f571e65-df3c-4453-aef0-11531b0ad303"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e1decda6-cfcb-4f05-9566-9f0474d938ff"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT2vpMgVhlt2sqH/gv8AsVPCjZDWctbJrjy9cjJGs5YsUjJCMjIiIiIi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            "], {{0, 73}, {195, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{195, 73},
          PlotRange->{{0, 195}, {0, 73}}]], "ExerciseOutput",
         ImageSize->{199, 73},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "13c58f25-3b8f-40a8-b207-b8709030b0bb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT2vpMgVhlt2sqH/gv8AsVPCjZDWctbJrjy9cjJGs5YsUjJCMjIiIiIi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              "], {{0, 73}, {195, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {195, 73}, 
            PlotRange -> {{0, 195}, {0, 73}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a1d55d65-6d01-4cc0-9c0d-f1c7ecec1455"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bf74e5ad-a4e1-4de1-b639-b432b88e0aad"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"67a113fc-2262-41e3-9504-7aa57b2ca18b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2d13bb75-1723-4b5a-9fbd-80e28387a7a4"],

Cell[TextData[{
 "Use ",
 StyleBox["Module",
  FontFamily->"Source Sans Pro"],
 " to generate an image collage from a picture of a giraffe, and the results \
of applying ",
 StyleBox["Blur",
  FontFamily->"Source Sans Pro"],
 ", ",
 StyleBox["EdgeDetect",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["ColorNegate",
  FontFamily->"Source Sans Pro"],
 " to it."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"5effde19-24d8-44ba-9767-15a58908cadf"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d4e90a4f-1b36-4f29-b4de-9454420e6b32"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJwcm3VYW+f/95m027q6e0upUqyF0kKRYqU4heLuFiwBQhIihLghgRBPiBAn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            "], {{0, 226}, {300, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{300, 226},
          PlotRange->{{0, 300}, {0, 226}}]], "ExerciseOutput",
         ImageSize->{304, 226},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "96a08f1b-c696-4681-afae-af11f7fc38b7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJwcm3VYW+f/95m027q6e0upUqyF0kKRYqU4heLuFiwBQhIihLghgRBPiBAn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              "], {{0, 226}, {300, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {300, 226}, 
            PlotRange -> {{0, 300}, {0, 226}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"33eb1a0d-98f2-4f4d-8ae0-940e3143d8da"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"50509f94-83ec-4563-8271-c86304f26aad"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ce14baf4-f549-4c39-a492-29c335b579ee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ed5f8d6a-418d-4e27-9f44-c4a09367a686"],

Cell[TextData[{
 "Inside a ",
 StyleBox["Module",
  FontFamily->"Source Sans Pro"],
 ", let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   RowBox[{
    StyleBox["Range",
     FontFamily->"Source Sans Pro"], "[", "10", "]"}]}]], "InlineCode",
  ExpressionUUID->"458118cf-3020-46c5-a74a-2bcebec53610"],
 ", then make a line plot of ",
 Cell[BoxData[
 "r"], "InlineCode",ExpressionUUID->"2d401ad6-d5ec-413a-bded-2403b88550e7"],
 " joined with the reverse of ",
 Cell[BoxData[
 "r"], "InlineCode",ExpressionUUID->"42a7039e-ac90-49e5-9e28-c4ec804af184"],
 " joined with ",
 Cell[BoxData[
 "r"], "InlineCode",ExpressionUUID->"eb74e0e9-db6b-4935-adfa-7ddb31b0fa03"],
 " joined with the reverse of ",
 Cell[BoxData[
 "r"], "InlineCode",ExpressionUUID->"3926ac0f-5f15-44a5-8b5e-184b141ce485"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"10e6de5a-db76-4188-9375-304a33f4cf2a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4dc80f36-6c28-416d-994d-230df34f7a7f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndtbE9maxntmbuZy/oX5L+Z2Lud2zzO3224Ppe5u07vt7rh7t+ndYrBB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            "], {{0, 230}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 230},
          PlotRange->{{0, 360}, {0, 230}}]], "ExerciseOutput",
         ImageSize->{364, 230},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5083d26c-0255-4175-8836-6ad128695a3b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndtbE9maxntmbuZy/oX5L+Z2Lud2zzO3224Ppe5u07vt7rh7t+ndYrBB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              "], {{0, 
              230}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 230}, 
            PlotRange -> {{0, 360}, {0, 230}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"64ad6ed1-23df-4c5a-a024-7de9e07714a4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"621330b2-c7b1-4570-8019-1a7e4f185c63"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f93c68d3-44b4-4554-9512-273a05bfd0df"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7db8cd1e-f65f-4f95-9b8f-21fe0e76be69"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["Range",
       FontFamily->"Source Sans Pro"], "[", "10", "]"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{
      StyleBox["Range",
       FontFamily->"Source Sans Pro"], "[", "10", "]"}], "-", "1"}], ",", 
    RowBox[{
     StyleBox["Reverse",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      StyleBox["Range",
       FontFamily->"Source Sans Pro"], "[", "10", "]"}], "]"}]}], "}"}]], 
  "InlineCode",ExpressionUUID->"a0e2eca6-3333-4dee-a9a4-c8a27746b260"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"8bba523d-3da5-481d-ba12-872d5079ad7c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0dee3169-6f03-4f08-933a-bc043ccaf373"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW6+v7LgVzrZkYaX+Bf0HgksDiyJtVTZkV31ZlbyO3laqQsMCw8KCggYF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            "], {{0, 
            19}, {437, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{437, 19},
          PlotRange->{{0, 437}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{441, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7758be2a-bdb5-48d3-85c0-28aa2d8d601a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW6+v7LgVzrZkYaX+Bf0HgksDiyJtVTZkV31ZlbyO3laqQsMCw8KCggYF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              "], {{
              0, 19}, {437, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {437, 19}, 
            PlotRange -> {{0, 437}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"175bd4cd-592a-4fcf-bd4e-63d6635f74fe"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0c15b25a-1006-43d1-9a4b-a4ec5177366b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ed3fde34-18b3-45ed-99d4-835273a360fb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9ab6cdcc-8b9a-4ddd-96fe-633519486df3"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Module",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", "=", "10"}], "}"}], ",", 
    RowBox[{
     StyleBox["Join",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{"{", "u", "}"}], ",", 
      RowBox[{
       StyleBox["Table",
        FontFamily->"Source Sans Pro"], "[", 
       RowBox[{
        RowBox[{"u", "=", 
         RowBox[{
          StyleBox["Mod",
           FontFamily->"Source Sans Pro"], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"17", "u"}], "+", "2"}], ",", "11"}], "]"}]}], ",", 
        "20"}], "]"}]}], "]"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "7d304854-fdcc-432e-a2b6-d86b5a53f4d9"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"a75537d4-39a1-494c-97b5-ba8338c30229"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"787f2070-f331-4d59-bd06-6d17a17f6de4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWiGzpEYQJomJTFV+QVwUOhYZRdWl4tbcVY6rmMvWXaqusDgkDodCoVAo
DGoMZsyYERgMAoEZMWIz3cAu+3aGfZerpN5ezVf1Xu0+vu3p7g96umffT2/+
ehV86zjOx+/Vr1evP3kfPrwOf/tBvfn9/cc/371/+8ev7/9+++7th1/efKf+
+KP6+fkbx4HXJwsLCwsLCwsLCwsLC4uvB2MVB657pGJ+O3FKu0lersuhqYq8
KGkvTCbE0NFrdIOR3LW1Mle33Z5TU0+qsihKwoY9mhhIXRZlRVi/RztNraIV
VduNu7STJnwdekrAHGHGIBFy7JoK3GPGbMiebbLGul2DVprHlWbKA887RGRY
OBNNHccJ4rKXJ16EDiIm5yR0seescEuuX5wmF9JCTVots00PeBl+HTI9Z6SF
65xZzrFghrzU/obmx41eErmE4CIvrIw3lS78W4gazXk+Gj2WJjkmlm8Tkutv
hClxtyyvnZ7vm5XmCV6yNJJVmcqvG5PFeps4TjIv3NV5dISEpe1ioa/BZsFV
2jp4FZSGciOlkArqFc2UBV/v5ESUO34KmhK4H3yqi5jnysEYq6SqEhCQtrDK
vvLciKNDmHCP6BbdhCDLUKXyaFL3NnxTCFEN3o1Epc7VLqou4v0e4tMwFnFq
qL9T6jl+RiGBS/6e65uVRhvCS5aGqfy7yUwSFJ67jYNMmUgWC7I8qpyl81UG
OQ/u7d9MkQ65vgwK3FvrWaq+cmAh/U0wrlv2SGKTaluMTWSitSrLa7Dzohnb
MbcNX+taq0QLGyRI6hnElX2JBfCe36dBhZeyO72Tzjcrza1rL10aqp5kd/k7
VLBz7AoCnF8tTKnreGtbgtLcyXNXqCIYcIOzHK6uFVLywCjuBSCNE+1MCNPQ
06aADinItbbQQrwEODbevnZX4WsxYLsQ1KwjmYog7HTBYhfhN0w1F1mWV2w0
ZGRqoVC6h2MQREnOhl2VrTQPLg3DZ029HHkNj+bac2oseBcLOAkau1wE7Kq4
NeuB9S1dDYhMGU+N5BO0/yWKpi/RZw9nmBQRPMf8RWkazQ17uhPDfXFPHZSz
BX7O9W7h9gHOh9EBVvVqfUPGI88N4qyq8gBo/u74YqV5bGkkL2CrLVmMc189
mi18VlHFViE3DPinuahe9tZO5SjeSeNIoFQe9KVyCymGKgFuqS1wUF6aJArD
KG1I6e0vek9cwTKIkQ5y4nnomxadxS2W3YUfd+/51cvG3T83sNI8vDQixfoi
RwaFJqovFiSFTpXOPFnBdpjNanEYpIOdhrerVE09aOfxZVWmfHDnBvw01FDf
qEG6gcDU7iX7R9WXpaCf3z/swg9Aj+HA0a0JV+FrAKOxE62XR5hwdMeDmO01
UhTCcIq4mdfxWGDvxrPSPLg0c2XICPTmHBrwudAJTilt4FKYN4zCNw9zcYhK
OvAaeueoQcMsVE90VD2R8bpX0dFwcFDdSTd00IDP51c3NNHXh7nrqFvatoQQ
rprwGxpE54Y168ehK2N/qec3NDk0x0PUsI63BZCOeLikCUET/i2tryNsFegk
BG9SnNAHnbUeeIeUDUOL58xwYnBDwwE8Irwfuha3BbfqNZFaab4GaZazlHT+
7OU8U7S+c4V5sm5RBuyYk2XfFhQdSZ6UHpr652McE21ixdr1eyWftDSwcw2o
ljc00bdzg45wk4prrUlVn1eWG6TGELTha0KQTRqcOUGK30zpIpXrLYqKtNpF
p64JL6t6GRk+wzcrzWNJc32eicc78X6jLqZxHK/+UQB2yW39NEBPk9M4XZn7
EmsSnLvvG0ZwtQl8WQi4qrhHg1AVTe7TwNj0b9J7stI8lDQMDlyWz849p3eu
Ns9AD22EGmDvdOyW9p/SXo4nlvYMCJJBT7sZOQXJ4yCI7nzruoGcem7+h0BL
+39oL8cTS3sGRBUfj1HGn7NTWlhYWFhYfBX4B6jiUaY=
            "], {{0, 19}, {296, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{296, 19},
          PlotRange->{{0, 296}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{300, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "50d27a46-f337-4cc6-8350-6d448e868fc2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWiGzpEYQJomJTFV+QVwUOhYZRdWl4tbcVY6rmMvWXaqusDgkDodCoVAo
DGoMZsyYERgMAoEZMWIz3cAu+3aGfZerpN5ezVf1Xu0+vu3p7g96umffT2/+
ehV86zjOx+/Vr1evP3kfPrwOf/tBvfn9/cc/371/+8ev7/9+++7th1/efKf+
+KP6+fkbx4HXJwsLCwsLCwsLCwsLC4uvB2MVB657pGJ+O3FKu0lersuhqYq8
KGkvTCbE0NFrdIOR3LW1Mle33Z5TU0+qsihKwoY9mhhIXRZlRVi/RztNraIV
VduNu7STJnwdekrAHGHGIBFy7JoK3GPGbMiebbLGul2DVprHlWbKA887RGRY
OBNNHccJ4rKXJ16EDiIm5yR0seescEuuX5wmF9JCTVots00PeBl+HTI9Z6SF
65xZzrFghrzU/obmx41eErmE4CIvrIw3lS78W4gazXk+Gj2WJjkmlm8Tkutv
hClxtyyvnZ7vm5XmCV6yNJJVmcqvG5PFeps4TjIv3NV5dISEpe1ioa/BZsFV
2jp4FZSGciOlkArqFc2UBV/v5ESUO34KmhK4H3yqi5jnysEYq6SqEhCQtrDK
vvLciKNDmHCP6BbdhCDLUKXyaFL3NnxTCFEN3o1Epc7VLqou4v0e4tMwFnFq
qL9T6jl+RiGBS/6e65uVRhvCS5aGqfy7yUwSFJ67jYNMmUgWC7I8qpyl81UG
OQ/u7d9MkQ65vgwK3FvrWaq+cmAh/U0wrlv2SGKTaluMTWSitSrLa7Dzohnb
MbcNX+taq0QLGyRI6hnElX2JBfCe36dBhZeyO72Tzjcrza1rL10aqp5kd/k7
VLBz7AoCnF8tTKnreGtbgtLcyXNXqCIYcIOzHK6uFVLywCjuBSCNE+1MCNPQ
06aADinItbbQQrwEODbevnZX4WsxYLsQ1KwjmYog7HTBYhfhN0w1F1mWV2w0
ZGRqoVC6h2MQREnOhl2VrTQPLg3DZ029HHkNj+bac2oseBcLOAkau1wE7Kq4
NeuB9S1dDYhMGU+N5BO0/yWKpi/RZw9nmBQRPMf8RWkazQ17uhPDfXFPHZSz
BX7O9W7h9gHOh9EBVvVqfUPGI88N4qyq8gBo/u74YqV5bGkkL2CrLVmMc189
mi18VlHFViE3DPinuahe9tZO5SjeSeNIoFQe9KVyCymGKgFuqS1wUF6aJArD
KG1I6e0vek9cwTKIkQ5y4nnomxadxS2W3YUfd+/51cvG3T83sNI8vDQixfoi
RwaFJqovFiSFTpXOPFnBdpjNanEYpIOdhrerVE09aOfxZVWmfHDnBvw01FDf
qEG6gcDU7iX7R9WXpaCf3z/swg9Aj+HA0a0JV+FrAKOxE62XR5hwdMeDmO01
UhTCcIq4mdfxWGDvxrPSPLg0c2XICPTmHBrwudAJTilt4FKYN4zCNw9zcYhK
OvAaeueoQcMsVE90VD2R8bpX0dFwcFDdSTd00IDP51c3NNHXh7nrqFvatoQQ
rprwGxpE54Y168ehK2N/qec3NDk0x0PUsI63BZCOeLikCUET/i2tryNsFegk
BG9SnNAHnbUeeIeUDUOL58xwYnBDwwE8Irwfuha3BbfqNZFaab4GaZazlHT+
7OU8U7S+c4V5sm5RBuyYk2XfFhQdSZ6UHpr652McE21ixdr1eyWftDSwcw2o
ljc00bdzg45wk4prrUlVn1eWG6TGELTha0KQTRqcOUGK30zpIpXrLYqKtNpF
p64JL6t6GRk+wzcrzWNJc32eicc78X6jLqZxHK/+UQB2yW39NEBPk9M4XZn7
EmsSnLvvG0ZwtQl8WQi4qrhHg1AVTe7TwNj0b9J7stI8lDQMDlyWz849p3eu
Ns9AD22EGmDvdOyW9p/SXo4nlvYMCJJBT7sZOQXJ4yCI7nzruoGcem7+h0BL
+39oL8cTS3sGRBUfj1HGn7NTWlhYWFhYfBX4B6jiUaY=
              "], {{0, 19}, {296,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {296, 19}, 
            PlotRange -> {{0, 296}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"701e5931-bd0b-4143-83c9-80b89faf6b40"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"55d120c7-858c-4c9e-9d6e-dc8a8c43c6bd"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bb03a02f-7b13-4c1e-89d5-b896a1bba52b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dd3bd630-882c-4c5b-97bb-9ac6a3083416"],

Cell["\<\
Generate 10 random strings made of 5 letters, in which consonants \
(non-vowels) alternate with vowels (aeiou).\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "38.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"1a8201dc-b9a9-42bc-8d93-8f79c4d79b46"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3c405554-206e-44dc-b14b-e7b284d358df"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXD+vpMgRH9uJQ0v+BP4CxE4JHSGd5YzkTl5OTtbozpJFSkZIRkZERERE
REKEZJF0QoIsEhICLJF00MG4q7qbYaBhZt7O27crTUl7mulpurp+9aerqnn3
p5/++YPz29Pp9Ovv+X9++PHf5i+//Oj99Q/8y98+//qPnz9/+vtfPv/r08+f
fvnzT7/jg3/k/+LfnE7w+fyiF73oRS960Yte9KIXvehFL3rRd0pTl6dJkubt
yD56K1+Rpr6uyPRkiWlb1933ACOj9PFdsjc8850RWEUzPfpQR+pmOFzz6ZZ2
RG9S7sfRXZiPeeAYhkvoQ0sPgXFCMvP+mZBwhL9ljKc64DJXj9rxjUUrjqVf
jU9d9B2I1hbXd1g/9Exic8Dc9ttV6RPobVZRgwsFe1p/F0s7oLco9yNJh8+U
OKZp+9UgrW0iEZ/jBNljIWqqTa6Yd/BH0LhfPX3ZZxHCZdbPNTm0q7D+5oMb
6yLXCfPuoWfKyLO99JuX7YvobVZBIvNkRHsPvYulHdBblPuRpMOHNXnMz1Ij
kAFkqkPuWKusjU7rdJgnVNMyoWIE/PEq22PXM67GFyvfSBB5cDNCcrDCcilt
PKZ7PzyDBKSECf6bXTFd2nkzFaVwUggwbyN/F+kRO/rhebRnB++0yl1mt//w
Rje69XamzV8eDUTi2Sa2roPbFWtc0wJL0xrVk2C+uc8Vix1jfLtZ3W/eK4H3
MEdUQ3GYUgLBDaaw1jfNMMt8E8tNw60xu6N9HbqmLEG9BMZo48ma9GS6KaV9
Hnnyu+EUHYqJqwVp6hpiOG77Wq5s+kRvBlMqGRn8ITdt+FBfJZZc2U5r2aBg
Q+3LUdv3bMvLkCVtisRWGwvyFtNUw45Ups063zTCUtPlqCL7ZAUdE5+dkxX2
tHENM5E1PeUbc5JGQWpESWhIQDIlylRErmBt+XOiMuWhIwa9KLRNT1/7Y+bm
JekdyBPXMKJqEJrjn72sxSWG0DKCot9DrElcO0hiTzIIi1argMK3TD9HGFgR
2IaTCEEIx9FJJ9Z6hhmTia/G4eoX6IEZ8E8jCZQCvLikirUhft2o+1o7rdLO
BUnTiYQGaJMYYBaGaVmWaboxHn877O6RlC9ZRo6y4aidAG6NGW+nLRE23bKH
acLRRInUpHwRuxz0DnsxXcN2+B5NDG461qKk8kNfGXomjWo7+Q6rWJHG4JVy
xYShThW0VkpGnXNJH/fj2FXOUOnLP70bbs2b9YV1MlPVSJsIV7oDO9Ipeg/z
ZT7cJrYMdFMtUPeSkqD6RAHeJs7JDqqmrfMQfs17mJqDd9thWpGOdplxsvhD
bVOAmFZMF6sFaVWlUkFuXNRljCrVl/Z9nUFW6UZFWdTdNJEYBY9rwjUA0qUt
5ZCi6dtpWVdZCOiYEep9CMyTG+VN26RgQBDVScQ/OA1CPtVgLfoO4VDirggb
cpSxE3W3KhUnAAzRECbHuWc1ET4YoT2UnDfHtGg6kjsKOhzkeBakzj2Aw9K3
UGhtC+TTm8iPgLtXzOJItHvYdtJQPWJngQOYEGlrMZ51GhwaaJAhXKxFlzZL
AACYgvgKE9alpxkcnGknLf+ALudkFSkS+GihltHYQm1ZWoH2XFEIjRXImA9M
gOYDFCnAYvhcbDa2RV6UFTglsOaOvMvuLkmFHuOq7ZrCdzwuCtOZ8XYabQBh
O8z5UAz6h+3N+fxYQiNIxZYNXZuugZuezkesuTMUpCmFgBjSdZNvWMWjBs+P
EoQ2rEidBo4PtarGuS4+nlUNei4vCLUXJFo31Jl37+Mn8VThg0uNO4rew7zB
gAYRsS042qYoUTF/8AuxOwaG5VwO3Gnom1q4LU7GsjRaJiJ07FoCQVyEGrGa
TJMm8A5ZCNNYBQodwa+mLEtp6kjjQeo8OInrCVLNi8qadeOCDV1bpoEMO2Np
KKEKTyldR30uI7CUmq6Dm3kJbsLlVW0OFg/CYmrHmFAld2cctEJZ/rNmv3J5
BPkGmgpeD/U73xPfo1Wz85C7GCX0iJ1VhJkW7KxoVfsj7y4DX27ZueUubJjg
MVw6uO8AMC+YTDEInDLZ1jA4IPjhlKpIUvoG2DM96iwJdng6sIxLYCUU92bH
cm8UY/WlGzlWlsLhkN1tSUXo8JJqfUd9bcabaYiwEfaoadrz/Rv8wMJpdlGl
sIlEw04xPTRdDWuzVnYAGl6eEdeTD61CT/sGL6zI0z147VwI79x4H0t/TqXW
tO+GK/Pu0A7ATVjDB92s21P0HuasTTHeNgGeDYUsUIV0cnPSQyElTEV8tmyI
zZaIS0vfp22IR6RhYe4oM+3lapfgcP15S1czoXr2yxkgH6P2fzFQF0rNC99h
VSzKGdNxLOUULEevYefOkafDHjUoppF1SzT0wU2KNc9RqdeFrHgSqq/nHPso
uN2PPD/w4ODrOo5CVJMAHuzBYNx8D7Fp3btWmZiG4Oi0kwYaF35R8Z24RQ/X
UjYcuwtMxioAv6ashIIg4bba5d5SL2iTYOqHbfMxggBaCvDB+CVoapX5+AAa
ID9RucF97A4kZXXqi1LH8lJYU2vG62lTsta0XU9zPg/kpnuFME+XdkxXx3pl
MJcGnW7yoVXs0Z7B48l1sSIJl8a5rnxE5rSRvuWkccOdwEJs2PVAG1l17il6
H3MaocLY2PgYUq+lWyI/gD5c2VlK5qRrMRlm8oILn+suKtAHh7uCmzxq8S0C
Y74rH3y8B5mlu96nxDYo+1lxKsfm42ac+HAi7Hc9SeyIXEUeZCJLl5qCzPMo
uOFkN7s+63DQUYP0MHN7APlz52Kr0eABh1d2vmG4viOPRT1i85pSejxGbWwh
bqniR7/luebJrybMNu0AWKVsvU9IC50ocVR+PuIJO58esM7JJoeZ2xnyB8gu
8gxiKmQ0AjRlq6L+FbGuCq1LznyL3T2SCg5tmYgCTW/G62n/AYQ3+b9wNNNL
yxQigLYQPi8cU9CMjJb14uoKoE8cmbnt7PPAKvS0NvhFcBNWtHxS71yLi7Az
qNLbzdw0brhn3lyVvOwOYi6Kk7F9Re9hLrYaV/BAC1WQ7LltXIyPwx4MLxum
ocTQvc3cauicOHU/djWGYnHkbXpWmuDG4GLC9PNlcYtpv0/6ru0n0Yexw7zr
2wz7sBHhOyoMHG2GgWC1LpIT0SgIy24ciDjaFPcxFG1LVctv+Yr6yOeeg94E
LQi0lpMdtUMnWFsHwe1MIZs+mUnZjmNfpVE6n4AnOyPd0JbYdJX59lrqh5CH
XgTKg/mSgIj/KLxej5hsehhRQbq2DuGcxCihwV81bYSVMuJI5LrtPptE/OjI
MgvPXL5c1fakgG0YQXle5ic6dnxNkQqZMlUQSBpx2fRtifdWbku5hUfyhG4b
QkjTjfvs7pKUJK7lJe0wTX1lY89Qa8bbaZiy8qhe9COfmUdJxa6a22hsRjho
5b02XZF3jTseJN/RCrO26wo0ABfbSnp3O7SKuwx+oVyRYVp+2g59nQZuWOmd
C9NsPq9suraC4A8Fy56i1264a948SopUORQRfEfReszlJUKkTFLdluIiCxez
xFZrmY5CXh44hqmCm6VSUNpm8s6D78C3VVm6XG2CTpq8RJgSSwU3se25QyJ+
hisSTJcx5agTdTHEdZHJI7grQjVmWsas3z5UJYPtecYiQx6gNcnTdcVnzZeK
41h8xQwBjoaL4E4Ye+Yic7NUcFvIyPrYMeetBgVGg6Fy52vlObhtpX4IeWW6
MhWfKjSwaO7GaBEj8bKaMiJxBOvw54POZUF+1gC+8vy/3ifPi8CmRNovdNdm
MxvTTQYpzlx86didmfDKS9+bdeIiAHcqrw7r0DotSbi/lt19knZlfFnRDvmx
rzXj7TRgoS7IcGpOr60CG/6oHZ28C9O1oLxDRWtZizXd2aQDGSv07nZsFfcY
/P+Wyp2LULSilOidSwQ3c96OR0YtO0krN9wzb9X0u7z4rVW0HvPrDgymysHx
GzpsGsfxeArlM97w2g3kjduahXJ+i9e9kP3mPSMYZJuXhXCn633gJeBVZ1XP
d0P0tuDbTY3XBxYTO6LQopcp353cz3chv/vYEjHQuAnGvBq/fyca6vH2Yf0X
MGylgia6vHd0PzuqVaSG1uwekRSena5e0NKa8XYavHQFbG9ZvF5eoZ313F0P
0iHxsLu9RdEbK1rvBCuXiJ9KiNBNdls33DHvcXH/uJp7W+YGG1sy+8AS1XSi
nT7BOxL2W04J+aK31w/eNOA0kDJNsI5YtByfwvdRwpsyyKI/hLsWpbfvhHZF
lmBOFx09TIemLjz1lsLXEfzJkn4BfQjTr7qT6zbFATutG+qIkTKP4B1F401/
1EmrGMqWZRJYJYHj+NrXYd6V2NS3/ZdybfD90r1VRJHiRsXVn1I8g++jhK+h
OoR+DHctSm/eiTwQ7eD475bVfZYp7PzrCP5cSb+EPoSplt5rJ/AGmhFvrke3
7LRuuLMgXAMn9f7/T+CIaB64rh+3byxFXvSiF73oRS960Yte9DH0f+FoLTw=

            "], {{0, 19}, {415, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{415, 19},
          PlotRange->{{0, 415}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{419, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "38f03cd4-f95d-4263-93db-0d600dd57409"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXD+vpMgRH9uJQ0v+BP4CxE4JHSGd5YzkTl5OTtbozpJFSkZIRkZERERE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              "], {{0, 19}, {415, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {415, 19}, 
            PlotRange -> {{0, 415}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0f525fdd-1d08-4834-a651-13eff0e28cdd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["38.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3da70acf-7083-4b42-bdcd-ee9fca7dc952"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bccb2b9d-176a-4a7f-950d-6e909fddefa7"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8fc8e0d2-62ef-4be5-9756-e430f80f7f94"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Assigning Names to Things: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 38  Assigning Names to Things", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
38-assigning-names-to-things.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "38.1", "38.2", "38.3", "38.4", "38.5", "38.6", "38.7"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "38.1", "38.2", "38.3", "38.4", "38.5", "38.6", "38.7"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[9988, 246, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2f4fce84-e133-4675-91de-a6018ce06c26",
   CellTags->"FirstInputCell"],
  Cell[22901, 551, 813, 26, 
  70, "Input", "ExpressionUUID" -> "67a113fc-2262-41e3-9504-7aa57b2ca18b",
   CellTags->"FirstInputCell"],
  Cell[428501, 7295, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ce14baf4-f549-4c39-a492-29c335b579ee",
   CellTags->"FirstInputCell"],
  Cell[456471, 7849, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f93c68d3-44b4-4554-9512-273a05bfd0df",
   CellTags->"FirstInputCell"],
  Cell[468417, 8140, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ed3fde34-18b3-45ed-99d4-835273a360fb",
   CellTags->"FirstInputCell"],
  Cell[478812, 8410, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bb03a02f-7b13-4c1e-89d5-b896a1bba52b",
   CellTags->"FirstInputCell"],
  Cell[493736, 8741, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bccb2b9d-176a-4a7f-950d-6e909fddefa7",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 552563, 9960}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[648, 22, 909, 28, 70, "Exercise", "ExpressionUUID" -> \
"4132f952-f6d2-4e93-9311-3d1307f10593",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1582, 54, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b7265290-2cf5-4e53-931a-af061d165367"],
Cell[2221, 75, 7160, 146, 70, "ExerciseOutput", "ExpressionUUID" -> \
"52802dbb-ec97-44dc-aa47-71a6669cab5c"]
}, Closed]],
Cell[CellGroupData[{
Cell[9418, 226, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"68eaff8f-87da-4bfd-849d-7bce71683f26"],
Cell[9988, 246, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2f4fce84-e133-4675-91de-a6018ce06c26",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10838, 277, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"185646e7-d4e9-4167-89e2-5ea6ae84838b"],
Cell[11125, 288, 824, 25, 70, "Exercise", "ExpressionUUID" -> \
"1f571e65-df3c-4453-aef0-11531b0ad303",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[11974, 317, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"e1decda6-cfcb-4f05-9566-9f0474d938ff"],
Cell[12633, 339, 9661, 187, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a1d55d65-6d01-4cc0-9c0d-f1c7ecec1455"]
}, Closed]],
Cell[CellGroupData[{
Cell[22331, 531, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bf74e5ad-a4e1-4de1-b639-b432b88e0aad"],
Cell[22901, 551, 813, 26, 70, "Input", "ExpressionUUID" -> \
"67a113fc-2262-41e3-9504-7aa57b2ca18b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23763, 583, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2d13bb75-1723-4b5a-9fbd-80e28387a7a4"],
Cell[24050, 594, 798, 25, 70, "Exercise", "ExpressionUUID" -> \
"5effde19-24d8-44ba-9767-15a58908cadf",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[24873, 623, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d4e90a4f-1b36-4f29-b4de-9454420e6b32"],
Cell[25532, 645, 402362, 6625, 70, "ExerciseOutput", "ExpressionUUID" -> \
"33eb1a0d-98f2-4f4d-8ae0-940e3143d8da"]
}, Closed]],
Cell[CellGroupData[{
Cell[427931, 7275, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"50509f94-83ec-4563-8271-c86304f26aad"],
Cell[428501, 7295, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ce14baf4-f549-4c39-a492-29c335b579ee",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[429363, 7327, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ed5f8d6a-418d-4e27-9f44-c4a09367a686"],
Cell[429650, 7338, 1165, 33, 70, "Exercise", "ExpressionUUID" -> \
"10e6de5a-db76-4188-9375-304a33f4cf2a",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[430840, 7375, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4dc80f36-6c28-416d-994d-230df34f7a7f"],
Cell[431479, 7396, 24385, 428, 70, "ExerciseOutput", "ExpressionUUID" -> \
"64ad6ed1-23df-4c5a-a024-7de9e07714a4"]
}, Closed]],
Cell[CellGroupData[{
Cell[455901, 7829, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"621330b2-c7b1-4570-8019-1a7e4f185c63"],
Cell[456471, 7849, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f93c68d3-44b4-4554-9512-273a05bfd0df",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[457333, 7881, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7db8cd1e-f65f-4f95-9b8f-21fe0e76be69"],
Cell[457620, 7892, 992, 30, 70, "Exercise", "ExpressionUUID" -> \
"8bba523d-3da5-481d-ba12-872d5079ad7c",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[458637, 7926, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0dee3169-6f03-4f08-933a-bc043ccaf373"],
Cell[459276, 7947, 8534, 168, 70, "ExerciseOutput", "ExpressionUUID" -> \
"175bd4cd-592a-4fcf-bd4e-63d6635f74fe"]
}, Closed]],
Cell[CellGroupData[{
Cell[467847, 8120, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0c15b25a-1006-43d1-9a4b-a4ec5177366b"],
Cell[468417, 8140, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ed3fde34-18b3-45ed-99d4-835273a360fb",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[469279, 8172, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9ab6cdcc-8b9a-4ddd-96fe-633519486df3"],
Cell[469566, 8183, 1173, 37, 70, "Exercise", "ExpressionUUID" -> \
"a75537d4-39a1-494c-97b5-ba8338c30229",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[470764, 8224, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"787f2070-f331-4d59-bd06-6d17a17f6de4"],
Cell[471403, 8245, 6802, 140, 70, "ExerciseOutput", "ExpressionUUID" -> \
"701e5931-bd0b-4143-83c9-80b89faf6b40"]
}, Closed]],
Cell[CellGroupData[{
Cell[478242, 8390, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"55d120c7-858c-4c9e-9d6e-dc8a8c43c6bd"],
Cell[478812, 8410, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bb03a02f-7b13-4c1e-89d5-b896a1bba52b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[479674, 8442, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"dd3bd630-882c-4c5b-97bb-9ac6a3083416"],
Cell[479961, 8453, 552, 13, 70, "Exercise", "ExpressionUUID" -> \
"1a8201dc-b9a9-42bc-8d93-8f79c4d79b46",
 CounterAssignments->{{"SectionNumber", 38}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[480538, 8470, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3c405554-206e-44dc-b14b-e7b284d358df"],
Cell[481197, 8492, 11932, 224, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0f525fdd-1d08-4834-a651-13eff0e28cdd"]
}, Closed]],
Cell[CellGroupData[{
Cell[493166, 8721, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3da70acf-7083-4b42-bdcd-ee9fca7dc952"],
Cell[493736, 8741, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bccb2b9d-176a-4a7f-950d-6e909fddefa7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[494576, 8771, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8fc8e0d2-62ef-4be5-9756-e430f80f7f94"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature nTGWIlN1EfMh3iILa1zVy6xu *)
