(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2180477,      46856]
NotebookOptionsPosition[   2071199,      44653]
NotebookOutlinePosition[   2167988,      46637]
CellTagsIndexPosition[   2167093,      46602]
WindowTitle->Layout and Display: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Layout and Display", "SectionInline",ExpressionUUID->
   "c3482d34-d6bd-4d13-889e-2db079656915"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 36}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:227",
 CellLabel->"In[20]:=",ExpressionUUID->"55bea3fd-f300-46cc-a42c-eefd68a36625"],

Cell[TextData[{
 ButtonBox["Earlier",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-25-ways-to-apply-functions.nb", "Framed"}],
 " we saw how to use ",
 ButtonBox["Framed",
  BaseStyle->"Link"],
 " to add a frame when one displays something."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"148ee87e-aa65-4a7e-a626-1c8dffe88c46"],

Cell["Generate a number and put a frame around it:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"a00e3e4c-c6ba-4fa7-a308-8d60b9674740"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"2", "^", "100"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"9aa26f84-10b6-4610-ad8c-b93da3f5b95e"],

Cell[BoxData[
 FrameBox["1267650600228229401496703205376",
  StripOnInput->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"ac9d2aad-7563-49e9-81e1-dd2e9e0b0795"]
}, Open  ]],

Cell[TextData[{
 "You can give options to ",
 ButtonBox["Framed",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"7827997b-8e84-436f-9eb8-7cccbf7b7fc5"],

Cell["Specify a background color and a frame style:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"51e33474-f053-4ec9-a544-6a8f011f30e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"2", "^", "100"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightYellow"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "LightGray"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"b38d759d-95f6-47cf-9ca5-e740666bd81b"],

Cell[BoxData[
 FrameBox["1267650600228229401496703205376",
  Background->RGBColor[1, 1, 0.85],
  FrameStyle->GrayLevel[0.85],
  StripOnInput->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"81518502-7dc9-4edd-a835-646a03a54f02"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Labeled",
  BaseStyle->"Link"],
 " lets you ",
 "make things be labeled",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"fd0d6fdb-39e4-47a7-9b4f-b276c704763a"],

Cell["Add a label to the framed number:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"81709a2a-62d5-4995-86b1-1b2486840b1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"2", "^", "100"}], "]"}], ",", "\"\<a big number\>\""}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"4e78b735-83ca-423d-a57c-db7f12e4d340"],

Cell[BoxData[
 TemplateBox[{
   FrameBox["1267650600228229401496703205376", StripOnInput -> False], 
   "\"a big number\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"be2383d4-87a7-4969-acfe-04e2f30b733b"]
}, Open  ]],

Cell["\<\
This adds a label to a number styled with a yellow background:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1b720107-8685-44d8-b825-aec04135b57e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"2", "^", "100"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}], ",", 
   "\"\<a big number\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"7f972ccb-22a5-4972-a637-4ab4609f8c8e"],

Cell[BoxData[
 TemplateBox[{
   StyleBox[
   "1267650600228229401496703205376", Background -> RGBColor[1, 1, 0], 
    StripOnInput -> False], "\"a big number\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"c8a3c685-1a11-406e-84d0-81e16c0e1c1a"]
}, Open  ]],

Cell["This adds styling to the label:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"fc1b5422-116f-4a82-8b5b-553c8b27ced1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"2", "^", "100"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<a big number\>\"", ",", "Italic", ",", "Orange"}], "]"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"36353b6a-7ac0-423d-982e-91d1d1c6cb78"],

Cell[BoxData[
 TemplateBox[{
   StyleBox[
   "1267650600228229401496703205376", Background -> RGBColor[1, 1, 0], 
    StripOnInput -> False], 
   StyleBox["\"a big number\"", Italic, 
    RGBColor[1, 0.5, 0], StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[5]=",ExpressionUUID->"1dbdf66f-1b1e-4093-a2f5-31c20cccc3af"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 ButtonBox["Labeled",
  BaseStyle->"Link"],
 " ",
 "in graphics",
 " as well."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:228", "i:6"},ExpressionUUID->"07a8f692-cd74-4e83-a22a-61cdc98b40b1"],

Cell["Make a pie chart in which some wedges are labeled:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"e0585664-415b-4311-b0b1-d7039caa1d2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"1", ",", "\"\<one\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"2", ",", "\"\<two\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"3", ",", "Red"}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"4", ",", "Orange"}], "]"}], ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"3b2379b1-29f4-48b0-9e8e-7ad147aaae93"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   DynamicModuleBox[{DynamicChart`click$2807$2865 = False, 
    DynamicChart`click$2817$2865 = False, DynamicChart`click$2821$2865 = 
    False, DynamicChart`click$2825$2865 = False, 
    DynamicChart`click$2829$2865 = False, DynamicChart`click$2832$2865 = 
    False}, {
     {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
         {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  DiskBox[{0, 0}, 1., {2.6927937030769655`, 
                   3.141592653589793}]},
                 
                 ImageSizeCache->{{7.084771798204425, 
                  73.22863349459959}, {-31.944971242800893`, \
-1.645006622254531}}], {}},
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2807$2865, 
                FEPrivate`Not[DynamicChart`click$2807$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2807$2865, {{{1., 0}, {
               0, 1.}}, {-0.19498558243636474`, 0.044504186791262904`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$2807$2865}]]}, 
         {RGBColor[0.9965728, 0.58382944, 0.22525344], EdgeForm[{GrayLevel[0],
           Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  DiskBox[{0, 0}, 1., {1.7951958020513104`, 
                   2.6927937030769655`}]},
                 
                 ImageSizeCache->{{13.35497096308514, 
                  73.22863349459958}, {-66.2014181828233, \
-1.645006622254531}}], {}},
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2817$2865, 
                FEPrivate`Not[DynamicChart`click$2817$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2817$2865, {{{1., 0}, {
               0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 0}, {
             0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$2817$2865}]]}, 
         {RGBColor[0.8704000000000001, 0.50272, 0.2], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  DiskBox[{0, 0}, 1., {0.4487989505128276, 
                   1.7951958020513104`}]},
                 
                 ImageSizeCache->{{56.311196735120134`, 
                  
                  130.27386890136785`}, {-67.7888683186497, \
-1.6450066222545132`}}], {}},
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2821$2865, 
                FEPrivate`Not[DynamicChart`click$2821$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2821$2865, {{{1., 0}, {0, 1.}}, {
              0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$2821$2865}]]}, 
         {RGBColor[0.74058432, 0.47903999999999997`, 0.4089916800000002], 
          EdgeForm[{GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[{
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                  
                  DiskBox[{0, 0}, 1., {-1.3463968515384819`, 
                   0.4487989505128276}]},
                 
                 ImageSizeCache->{{70.40020636985338, 
                  136.54406806624854`}, {-31.944971242800904`, 
                  60.08297781356805}}], {}},
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[4, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2825$2865, 
                FEPrivate`Not[DynamicChart`click$2825$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2825$2865, {{{1., 0}, {0, 1.}}, {
              0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$2825$2865}]]}, 
         {RGBColor[0.64020864, 0.49888000000000005`, 0.74416944], EdgeForm[{
          GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-2.243994752564138, -1.3463968515384819`}]},
                
                ImageSizeCache->{{30.923678614176378`, 
                 87.31764312933288}, {-4.473433747000726, 61.67042794939444}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2829$2865, 
                FEPrivate`Not[DynamicChart`click$2829$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2829$2865, {{{1., 0}, {
               0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$2829$2865}]]}, 
         {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-3.141592653589793, -2.243994752564138}]},
                
                ImageSizeCache->{{7.084771798204426, 
                 73.22863349459958}, {-4.473433747000726, 47.85699345200534}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2832$2865, 
                FEPrivate`Not[DynamicChart`click$2832$2865]], PassEventsDown -> 
              True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
           If[DynamicChart`click$2832$2865, {{{1., 0}, {
               0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {
             DynamicChart`click$2832$2865}]]}}}, {}}, {}}, {{{
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            
            TagBox[{{{}, 
               InsetBox["\<\"one\"\>", \
{-0.649951941454549, 0.14834728930420965}]}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2807$2865, 
              FEPrivate`Not[DynamicChart`click$2807$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2807$2865, {{{1., 0}, {
             0, 1.}}, {-0.19498558243636474`, 0.044504186791262904`}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2807$2865}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            
            TagBox[{{{}, 
               InsetBox["\<\"two\"\>", \
{-0.4156598679058223, 0.5212209883120199}]}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2817$2865, 
              FEPrivate`Not[DynamicChart`click$2817$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2817$2865, {{{1., 0}, {
             0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 0}, {0, 
           1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2817$2865}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{{}, InsetBox[
                InterpretationBox[
                 ButtonBox[
                  TooltipBox[
                   GraphicsBox[{
                    {GrayLevel[0], RectangleBox[{0, 0}]}, 
                    {GrayLevel[0], RectangleBox[{1, -1}]}, 
                    {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
                    AspectRatio->1,
                    Frame->True,
                    FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
                    FrameTicks->None,
                    
                    ImageSize->
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}],
                    PlotRangePadding->None],
                   "RGBColor[1, 0, 0]"],
                  Appearance->None,
                  BaseStyle->{},
                  BaselinePosition->Baseline,
                  ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
                  DefaultBaseStyle->{},
                  Evaluator->Automatic,
                  Method->"Preemptive"],
                 RGBColor[1, 0, 0],
                 Editable->False,
                 
                 Selectable->
                  False], {0.2892558260783721, 0.6006459119349461}]}, {}},
             StatusArea[#, 3]& ,
             TagBoxNote->"3"],
            StyleBox["3", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[3, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2821$2865, 
              FEPrivate`Not[DynamicChart`click$2821$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2821$2865, {{{1., 0}, {0, 1.}}, {
            0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 1}}, {{
           1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2821$2865}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{{}, InsetBox[
                InterpretationBox[
                 ButtonBox[
                  TooltipBox[
                   GraphicsBox[{
                    {GrayLevel[0], RectangleBox[{0, 0}]}, 
                    {GrayLevel[0], RectangleBox[{1, -1}]}, 
                    {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
                    AspectRatio->1,
                    Frame->True,
                    
                    FrameStyle->RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.],
                    FrameTicks->None,
                    
                    ImageSize->
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}],
                    PlotRangePadding->None],
                   "RGBColor[1, 0.5, 0]"],
                  Appearance->None,
                  BaseStyle->{},
                  BaselinePosition->Baseline,
                  ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
                  DefaultBaseStyle->{},
                  Evaluator->Automatic,
                  Method->"Preemptive"],
                 RGBColor[1, 0.5, 0],
                 Editable->False,
                 
                 Selectable->
                  False], {0.6006459119349462, -0.28925582607837175}]}, {}},
             StatusArea[#, 4]& ,
             TagBoxNote->"4"],
            StyleBox["4", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[4, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2825$2865, 
              FEPrivate`Not[DynamicChart`click$2825$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2825$2865, {{{1., 0}, {0, 1.}}, {
            0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 1}}, {{
           1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2825$2865}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2829$2865, 
              FEPrivate`Not[DynamicChart`click$2829$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2829$2865, {{{1., 0}, {
             0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2829$2865}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$2832$2865, 
              FEPrivate`Not[DynamicChart`click$2832$2865]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$2832$2865, {{{1., 0}, {
             0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$2832$2865}]]}, {}}, {}}},
    DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
  AspectRatio->0.9788825019485581,
  ContentSelectable->False,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{144.8515625, 140.},
  LabelStyle->{
    GrayLevel[0], FontFamily -> "Arial"},
  PlotRange->{{-1.1197704614978323`, 
   1.1390820660665946`}, {-1.1065109267369437`, 1.1046402869781464`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"913cca09-e5a4-475b-9815-1a81fa215b58"]
}, Open  ]],

Cell["Plot labeled points:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"af2dcace-6b99-4550-967e-c0daed93b9ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{"1", ",", "\"\<one\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"2", ",", "\"\<two\>\""}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"3", ",", "Pink"}], "]"}], ",", 
    RowBox[{"Labeled", "[", 
     RowBox[{"4", ",", "Yellow"}], "]"}], ",", "5", ",", "6", ",", "7"}], 
   "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"85001949-d6af-484b-b5b6-6ddb82e94d25"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {
       7., 7.}}]}, {}}, {
     TagBox[
      {Opacity[0.], PointBox[{{1., 1.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$2910, {1}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{2., 2.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$2910, {2}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3., 3.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$2910, {3}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4., 4.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$2910, {4}}]& ]}}, {
    InsetBox["\<\"one\"\>", Offset[{-2, -1}, {1., 1.}], {1, 1}], 
    InsetBox["\<\"two\"\>", Offset[{-2, 1}, {2., 2.}], {1, -1}], InsetBox[
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False], Offset[{-2, 1}, {3., 3.}], {1, -1}], InsetBox[
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 1, 0],
      Editable->False,
      Selectable->False], Offset[{-2, 1}, {4., 4.}], {1, -1}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{200.15234375, Automatic},
  Method->{},
  PlotRange->{{0., 7.}, {0, 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"84ecffbf-2b90-458c-abff-aa50864c73ba"]
}, Open  ]],

Cell["Plot the first few primes labeled with their values:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"ee94e687-e9c0-48b0-8f87-c03b2f1231e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"Prime", "[", "n", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "15"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"d026826c-3f4e-4e46-b541-eaa39fda84e8"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 
       13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
       37.}, {13., 41.}, {14., 43.}, {15., 47.}}]}, {}}, {
     TagBox[
      {Opacity[0.], PointBox[{{1., 2.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {1}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{2., 3.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {2}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3., 5.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {3}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4., 7.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {4}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{5., 11.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {5}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{6., 13.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {6}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{7., 17.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {7}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{8., 19.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {8}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{9., 23.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {9}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{10., 29.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {10}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{11., 31.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {11}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{12., 37.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {12}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{13., 41.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {13}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{14., 43.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {14}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{15., 47.}}]},
      Annotation[#, {{Labeled}, Charting`Private`Tag$17507, {
        15}}]& ]}}, {{{{}, {}}, {{}, {InsetBox[
        PaneBox["2"], 
        Offset[{2, -1}, {1., 2.}], \
{-0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["3"], 
        Offset[{2, -1}, {2., 3.}], \
{-0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["5"], 
        Offset[{2, -1}, {3., 5.}], \
{-0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["7"], 
        Offset[{-2, -1}, {4., 7.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["11"], Offset[{-4, 0}, {5., 11.}], {0.9620000000000001, 0}], 
       InsetBox[
        PaneBox["13"], 
        Offset[{-2, -1}, {6., 13.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["17"], 
        Offset[{-2, -1}, {7., 17.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["19"], Offset[{0, -1}, {8., 19.}], {0, 0.9620000000000001}], 
       InsetBox[
        PaneBox["23"], 
        Offset[{-2, -1}, {9., 23.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["29"], Offset[{0, -1}, {10., 29.}], {0, 0.9620000000000001}], 
       InsetBox[
        PaneBox["31"], Offset[{0, -1}, {11., 31.}], {0, 0.9620000000000001}], 
       InsetBox[
        PaneBox["37"], 
        Offset[{-2, -1}, {12., 37.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["41"], 
        Offset[{-2, -1}, {13., 41.}], \
{0.9620000000000001, -0.9620000000000001}], InsetBox[
        PaneBox["43"], Offset[{0, -1}, {14., 43.}], {0, 0.9620000000000001}], 
       InsetBox[
        PaneBox["47"], 
        Offset[{-2, -1}, {15., 47.}], \
{0.9620000000000001, -0.9620000000000001}]}}}, {{}, {}}}, {}, {{}, {}}, {{}, \
{}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{199.73046875, Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 15.}, {0, 47.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.08]}, {
     Scaled[0.02], 
     Scaled[0.0970820393249937]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"32f4bb6a-63f3-447b-be4c-25690570135a"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Labeled",
  BaseStyle->"Link"],
 " indicates something by putting a label right next to it. It\
\[CloseCurlyQuote]s often nice instead to use \[OpenCurlyDoubleQuote]callouts\
\[CloseCurlyDoubleQuote], that have little lines pointing to whatever they\
\[CloseCurlyQuote]re referring to. You can do this by using ",
 ButtonBox["Callout",
  BaseStyle->"Link"],
 " rather than ",
 ButtonBox["Labeled",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"ad045f26-040d-49bd-a0a2-0d9bd3388dcc"],

Cell[TextData[{
 ButtonBox["Callout",
  BaseStyle->"Link"],
 " creates \[OpenCurlyDoubleQuote]callouts\[CloseCurlyDoubleQuote] with \
little lines:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"44b28fc8-fd9b-418a-b1d3-9b2ccafa3333"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Callout", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"Prime", "[", "n", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "15"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"ed3c5081-7e55-4679-8494-397089bb17ba"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 
       13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
       37.}, {13., 41.}, {14., 43.}, {15., 47.}}]}, {}}, {
     TagBox[
      {Opacity[0.], PointBox[{{1., 2.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {1}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{2., 3.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {2}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{3., 5.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {3}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{4., 7.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {4}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{5., 11.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {5}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{6., 13.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {6}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{7., 17.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {7}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{8., 19.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {8}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{9., 23.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {9}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{10., 29.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {10}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{11., 31.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {11}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{12., 37.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {12}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{13., 41.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {13}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{14., 43.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {14}}]& ], 
     TagBox[
      {Opacity[0.], PointBox[{{15., 47.}}]},
      Annotation[#, {{Callout}, Charting`Private`Tag$19953, {
        15}}]& ]}}, {}, {{{{}, {}}, {{}, {GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-4., 2.4492935982947064`*^-16}, {1., 2.}], 
            Offset[{-4., 2.4492935982947064`*^-16}, {1., 2.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {1., 2.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {1., 2.}], 
            Offset[{-8., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-10., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-12., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-12., 4.898587196589413*^-16}, {1., 2.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-4., 2.4492935982947064`*^-16}, {1., 2.}], 
            Offset[{-4., 2.4492935982947064`*^-16}, {1., 2.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {1., 2.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {1., 2.}], 
            Offset[{-8., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-10., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-12., 4.898587196589413*^-16}, {1., 2.}], 
            Offset[{-12., 4.898587196589413*^-16}, {1., 2.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-12.000000000000002`, 6.500000000000003}, {1., 2.}], 
            Offset[{-11.999999999999998`, -6.499999999999997}, {1., 2.}], 
            Offset[{-24., -6.500000000000001}, {1., 2.}], 
            Offset[{-24., 6.499999999999999}, {1., 2.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["2",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-18., 4.898587196589413*^-16}, {1., 2.}], {0, 0}]}], 
       GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 3.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 3.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {2., 3.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {2., 3.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 
             3.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 3.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 3.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {2., 3.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {2., 3.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 3.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 
             3.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {2., 3.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {2., 3.}], 
            Offset[{-22.494480483301835`, 2.4040596560003085`}, {2., 3.}], 
            Offset[{-22.494480483301835`, 15.404059656000308`}, {2., 
             3.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["3",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-16.494480483301835, 8.90405965600031}, {2., 3.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 5.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 5.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {3., 5.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {3., 5.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 
             5.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 5.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 5.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {3., 5.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {3., 5.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 5.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 
             5.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {3., 5.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {3., 5.}], 
            Offset[{-22.494480483301835`, 2.4040596560003085`}, {3., 5.}], 
            Offset[{-22.494480483301835`, 15.404059656000308`}, {3., 
             5.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["5",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-16.494480483301835, 8.90405965600031}, {3., 5.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {4., 7.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {4., 7.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {4., 7.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {4., 7.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {4., 7.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {4., 7.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {4., 7.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {4., 7.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {4., 7.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {4., 7.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {4., 7.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {4., 7.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {4., 7.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {4., 7.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {4., 7.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {4., 7.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{22.60405965600031, -1.2944804833018333`}, {4., 7.}], 
            Offset[{22.60405965600031, -14.294480483301832`}, {4., 7.}], 
            Offset[{11.604059656000311`, -14.294480483301836`}, {4., 7.}], 
            Offset[{11.604059656000308`, -1.294480483301835}, {4., 7.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["7",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{17.10405965600031, -7.794480483301834}, {4., 7.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {5., 11.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {5., 11.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {5., 11.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {5., 11.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {5., 11.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {5., 11.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {5., 11.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {5., 11.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {5., 11.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {5., 11.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {5., 11.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {5., 11.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {5., 11.}], 
            Offset[{-25.494480483301835`, 2.4040596560003085`}, {5., 11.}], 
            Offset[{-25.494480483301835`, 15.404059656000308`}, {5., 11.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["11",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-17.994480483301835, 8.90405965600031}, {5., 11.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {6., 13.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {6., 13.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {6., 13.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {6., 13.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {6., 13.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {6., 13.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {6., 13.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {6., 13.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {6., 13.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {6., 13.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {6., 13.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {6., 13.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {6., 13.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {6., 13.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {6., 13.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {6., 13.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{27.60405965600031, -1.2944804833018324`}, {6., 13.}], 
            Offset[{27.60405965600031, -14.294480483301832`}, {6., 13.}], 
            Offset[{11.604059656000311`, -14.294480483301836`}, {6., 13.}], 
            Offset[{11.604059656000308`, -1.294480483301836}, {6., 13.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["13",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{19.60405965600031, -7.794480483301834}, {6., 13.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {7., 17.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {7., 17.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {7., 17.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {7., 17.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {7., 17.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {7., 17.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {7., 17.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {7., 17.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {7., 17.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {7., 17.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {7., 17.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {7., 17.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {7., 17.}], 
            Offset[{-26.494480483301835`, 2.4040596560003085`}, {7., 17.}], 
            Offset[{-26.494480483301835`, 15.404059656000308`}, {7., 17.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["17",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-18.494480483301835, 8.90405965600031}, {7., 17.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {8., 19.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {8., 19.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {8., 19.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {8., 19.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {8., 19.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {8., 19.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {8., 19.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {8., 19.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {8., 19.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{7.999999999999997, -11.999999999999998`}, {8., 19.}], 
            Offset[{8., -25.}, {8., 19.}], 
            Offset[{-7.999999999999999, -25.}, {8., 19.}], 
            Offset[{-8.000000000000004, -12.000000000000002`}, {8., 
             19.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["19",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-9.797174393178826*^-16, -18.5}, {8., 19.}], {0, 0}]}], 
       GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {9., 23.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {9., 23.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {9., 23.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {9., 23.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {9., 23.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {9., 23.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {9., 23.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {9., 23.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {9., 23.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {9., 23.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {9., 23.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {9., 23.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {9., 23.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {9., 23.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {9., 23.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {9., 23.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{28.60405965600031, -1.2944804833018324`}, {9., 23.}], 
            Offset[{28.60405965600031, -14.294480483301832`}, {9., 23.}], 
            Offset[{11.604059656000311`, -14.294480483301836`}, {9., 23.}], 
            Offset[{11.604059656000308`, -1.294480483301836}, {9., 23.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["23",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{20.10405965600031, -7.794480483301834}, {9., 23.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {10., 29.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {10., 29.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {10., 29.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {10., 29.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {10., 
             29.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {10., 29.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {10., 29.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {10., 29.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {10., 29.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {10., 29.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {10., 
             29.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {10., 29.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {10., 29.}], 
            Offset[{-27.494480483301835`, 2.4040596560003085`}, {10., 29.}], 
            Offset[{-27.494480483301835`, 15.404059656000308`}, {10., 
             29.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["29",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-18.994480483301835, 8.90405965600031}, {10., 29.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {11., 31.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {11., 31.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {11., 31.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {11., 31.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {11., 31.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {11., 31.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {11., 31.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {11., 
             31.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{3.8020298280001557`, -3.247240241650917}, {11., 31.}], 
            Offset[{3.8020298280001557`, -3.247240241650917}, {11., 31.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {11., 31.}], 
            Offset[{5.703044742000234, -4.8708603624763755`}, {11., 31.}], 
            Offset[{7.604059656000311, -6.494480483301834}, {11., 31.}], 
            Offset[{9.604059656000311, -6.494480483301834}, {11., 31.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {11., 31.}], 
            Offset[{11.604059656000311`, -6.494480483301834}, {11., 
             31.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{27.60405965600031, -1.2944804833018324`}, {11., 31.}], 
            Offset[{27.60405965600031, -14.294480483301832`}, {11., 31.}], 
            Offset[{11.604059656000311`, -14.294480483301836`}, {11., 31.}], 
            Offset[{11.604059656000308`, -1.294480483301836}, {11., 
             31.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["31",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{19.60405965600031, -7.794480483301834}, {11., 31.}], \
{0, 0}]}], GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-4., 2.4492935982947064`*^-16}, {12., 37.}], 
            Offset[{-4., 2.4492935982947064`*^-16}, {12., 37.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {12., 37.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {12., 37.}], 
            Offset[{-8., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-10., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-12., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-12., 4.898587196589413*^-16}, {12., 37.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-4., 2.4492935982947064`*^-16}, {12., 37.}], 
            Offset[{-4., 2.4492935982947064`*^-16}, {12., 37.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {12., 37.}], 
            Offset[{-6., 3.6739403974420594`*^-16}, {12., 37.}], 
            Offset[{-8., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-10., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-12., 4.898587196589413*^-16}, {12., 37.}], 
            Offset[{-12., 4.898587196589413*^-16}, {12., 37.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-12.000000000000002`, 6.500000000000003}, {12., 37.}], 
            Offset[{-11.999999999999998`, -6.499999999999997}, {12., 37.}], 
            Offset[{-29., -6.500000000000001}, {12., 37.}], 
            Offset[{-29., 6.499999999999999}, {12., 37.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["37",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-20.5, 4.898587196589413*^-16}, {12., 37.}], {0, 0}]}], 
       GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {13., 41.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {13., 41.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {13., 41.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {13., 41.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {13., 41.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {13., 41.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {13., 41.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {13., 41.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {13., 41.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{7.999999999999997, -11.999999999999998`}, {13., 41.}], 
            Offset[{8., -25.}, {13., 41.}], 
            Offset[{-7.999999999999999, -25.}, {13., 41.}], 
            Offset[{-8.000000000000004, -12.000000000000002`}, {13., 41.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["41",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-9.797174393178826*^-16, -18.5}, {13., 41.}], {0, 0}]}], 
       GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {14., 43.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {14., 43.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {14., 43.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {14., 43.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-4.898587196589413*^-16, -4.}, {14., 43.}], 
            Offset[{-4.898587196589413*^-16, -4.}, {14., 43.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {14., 43.}], 
            Offset[{-7.347880794884119*^-16, -6.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -8.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -10.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {14., 43.}], 
            Offset[{-9.797174393178826*^-16, -12.}, {14., 43.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{8.499999999999996, -11.999999999999998`}, {14., 43.}], 
            Offset[{8.5, -25.}, {14., 43.}], Offset[{-8.5, -25.}, {14., 43.}],
             Offset[{-8.500000000000004, -12.000000000000002`}, {14., 
             43.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["43",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-9.797174393178826*^-16, -18.5}, {14., 43.}], {0, 0}]}], 
       GraphicsGroupBox[{
         {GrayLevel[1], AbsoluteThickness[4], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
          "Round"], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {15., 47.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {15., 47.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {15., 47.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {15., 47.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {15., 
             47.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          BSplineCurveBox[{
           Offset[{-3.2472402416509185`, 3.8020298280001548`}, {15., 47.}], 
            Offset[{-3.2472402416509185`, 3.8020298280001548`}, {15., 47.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {15., 47.}], 
            Offset[{-4.870860362476378, 5.703044742000232}, {15., 47.}], 
            Offset[{-6.494480483301837, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-8.494480483301837, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {15., 47.}], 
            Offset[{-10.494480483301837`, 7.6040596560003095`}, {15., 
             47.}]}]}, 
         {GrayLevel[1], Opacity[
           NCache[
            Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
          PolygonBox[{
           Offset[{-10.494480483301837`, 15.404059656000312`}, {15., 47.}], 
            Offset[{-10.494480483301833`, 2.404059656000312}, {15., 47.}], 
            Offset[{-27.494480483301835`, 2.4040596560003085`}, {15., 47.}], 
            Offset[{-27.494480483301835`, 15.404059656000308`}, {15., 
             47.}]}]}, 
         {RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
          EdgeForm[None]}, {}, InsetBox[
          StyleBox[
           RotationBox["47",
            BoxRotation->0.],
           StripOnInput->False,
           Opacity->1,
           FontOpacity->1,
           $CellContext`LineOpacity -> 1,
           $CellContext`FrontFaceOpacity -> 1,
           $CellContext`BackFaceOpacity -> 1], 
          Offset[{-18.994480483301835, 8.90405965600031}, {15., 47.}], \
{0, 0}]}]}}}, {{}, {}}}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 15.}, {0, 47.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.08]}, {
     Scaled[0.02], 
     Scaled[0.0970820393249937]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[9]=",ExpressionUUID->"f5c57f7b-764b-494e-894e-597f154c0e54"]
}, Open  ]],

Cell[TextData[{
 "There are all sorts of ways to annotate graphics. ",
 ButtonBox["Style",
  BaseStyle->"Link"],
 " directly inserts styling. ",
 ButtonBox["Tooltip",
  BaseStyle->"Link"],
 " generates interactive tooltips that show themselves when the mouse hovers \
over them. ",
 ButtonBox["Legended",
  BaseStyle->"Link"],
 " puts labels into a legend on the side."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"18eb86e2-bd62-40a8-a706-f66cd5de63a6"],

Cell["Specify styles for the first three pie wedges:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"2d65c039-8c86-49cb-b583-d213928ecdaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{"3", ",", "Red"}], "]"}], ",", 
    RowBox[{"Style", "[", 
     RowBox[{"2", ",", "Green"}], "]"}], ",", 
    RowBox[{"Style", "[", 
     RowBox[{"1", ",", "Yellow"}], "]"}], ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"3f859001-1173-450f-b6de-e121ddf82ad2"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   DynamicModuleBox[{DynamicChart`click$21430$21465 = False, 
    DynamicChart`click$21433$21465 = False, DynamicChart`click$21436$21465 = 
    False, DynamicChart`click$21439$21465 = False, 
    DynamicChart`click$21442$21465 = False}, {
     {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
         {RGBColor[1, 0, 0], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {1.0471975511965979`, 
                  3.141592653589793}]},
                
                ImageSizeCache->{{7.736875587272583, 
                 104.99541267039046`}, {-67.7163379988072, \
-1.9345042351465223`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21430$21465, 
                FEPrivate`Not[DynamicChart`click$21430$21465]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$21430$21465, {{{1., 0}, {
               0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$21430$21465}]]}, 
         {RGBColor[0, 1, 0], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {-0.34906585039886595`, 
                  1.0471975511965979`}]},
                
                ImageSizeCache->{{70.69028222618705, 
                 136.47211598984774`}, {-59.28218076396461, 
                 19.596828926334148`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21433$21465, 
                FEPrivate`Not[DynamicChart`click$21433$21465]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$21433$21465, {{{1., 0}, {0, 1.}}, {
              0.18793852415718168`, 0.06840402866513376}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$21433$21465}]]}, 
         {RGBColor[1, 1, 0], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-1.0471975511965974`, -0.34906585039886595`}]},
                
                ImageSizeCache->{{70.69028222618705, 
                 132.67556102285582`}, {-4.762931359892725, 
                 52.58474516892538}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21436$21465, 
                FEPrivate`Not[DynamicChart`click$21436$21465]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$21436$21465, {{{1., 0}, {0, 1.}}, {
              0.15320888862379564`, -0.12855752193730785`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$21436$21465}]]}, 
         {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-1.7453292519943293`, -1.0471975511965974`}]},
                
                ImageSizeCache->{{59.75853788541435, 
                 104.99541267039052`}, {-4.762931359892711, 
                 61.01890240376799}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21439$21465, 
                FEPrivate`Not[DynamicChart`click$21439$21465]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$21439$21465, {{{1., 0}, {0, 1.}}, {
              0.03472963553338613, -0.1969615506024416}}, {{1, 0}, {0, 1}}, {{
             1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$21439$21465}]]}, 
         {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-3.141592653589793, -1.7453292519943293`}]},
                
                ImageSizeCache->{{7.736875587272583, 
                 73.51870935093325}, {-4.762931359892704, 60.0624987013867}}],
               
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21442$21465, 
                FEPrivate`Not[DynamicChart`click$21442$21465]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$21442$21465, {{{1., 0}, {
               0, 1.}}, {-0.15320888862379559`, -0.1285575219373079}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {
             DynamicChart`click$21442$21465}]]}}}, {}}, {}}, {{{
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 3]& ,
             TagBoxNote->"3"],
            StyleBox["3", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[3, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21430$21465, 
              FEPrivate`Not[DynamicChart`click$21430$21465]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$21430$21465, {{{1., 0}, {
             0, 1.}}, {-0.10000000000000005`, 0.1732050807568877}}, {{1, 0}, {
           0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$21430$21465}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21433$21465, 
              FEPrivate`Not[DynamicChart`click$21433$21465]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$21433$21465, {{{1., 0}, {0, 1.}}, {
            0.18793852415718168`, 0.06840402866513376}}, {{1, 0}, {0, 1}}, {{
           1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$21433$21465}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21436$21465, 
              FEPrivate`Not[DynamicChart`click$21436$21465]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$21436$21465, {{{1., 0}, {0, 1.}}, {
            0.15320888862379564`, -0.12855752193730785`}}, {{1, 0}, {0, 
           1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$21436$21465}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21439$21465, 
              FEPrivate`Not[DynamicChart`click$21439$21465]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$21439$21465, {{{1., 0}, {0, 1.}}, {
            0.03472963553338613, -0.1969615506024416}}, {{1, 0}, {0, 1}}, {{1,
            0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$21439$21465}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$21442$21465, 
              FEPrivate`Not[DynamicChart`click$21442$21465]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[
          DynamicChart`click$21442$21465, {{{1., 0}, {
             0, 1.}}, {-0.15320888862379559`, -0.1285575219373079}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$21442$21465}]]}, {}}, {}}},
    DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
  AspectRatio->0.9858492740262733,
  ContentSelectable->False,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{144.79296875, 144.},
  LabelStyle->{
    GrayLevel[0], FontFamily -> "Arial"},
  PlotRange->{{-1.1453628904013744`, 
   1.1546392299047983`}, {-1.1392670101562663`, 1.1281884104064623`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"dacb34e1-1e88-4088-8a6c-d68c9bd3e44f"]
}, Open  ]],

Cell["Set up words and colors as legends for pie wedges:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:229",ExpressionUUID->"87976e7f-2b22-4abb-bd91-449f8b07bc13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Legended", "[", 
     RowBox[{"1", ",", "\"\<one\>\""}], "]"}], ",", 
    RowBox[{"Legended", "[", 
     RowBox[{"2", ",", "\"\<two\>\""}], "]"}], ",", 
    RowBox[{"Legended", "[", 
     RowBox[{"3", ",", "Pink"}], "]"}], ",", 
    RowBox[{"Legended", "[", 
     RowBox[{"4", ",", "Yellow"}], "]"}], ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"2d9de456-f3c1-4a53-b054-a45e7bde990c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {}, 
     DynamicModuleBox[{
      DynamicChart`click$5024$5122 = False, DynamicChart`click$5038$5122 = 
       False, DynamicChart`click$5041$5122 = False, 
       DynamicChart`click$5044$5122 = False, DynamicChart`click$5047$5122 = 
       False, DynamicChart`click$5050$5122 = False}, {{
        Directive[
         RGBColor[0.5, 0.5, 1.], 
         EdgeForm[
          Directive[
           GrayLevel[0], 
           Opacity[0.5]]]], {{{{{{}, {{
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.982864, 0.7431472, 0.3262672]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.6927937030769655`, 
                    3.141592653589793}]}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[1, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5024$5122, 
                    FEPrivate`Not[DynamicChart`click$5024$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5024$5122, {{{1., 0}, {
                    0, 1.}}, {-0.19498558243636474`, 
                   0.044504186791262904`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$5024$5122}]]}, {
              
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.9965728, 0.58382944, 0.22525344]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.7951958020513104`, 
                    2.6927937030769655`}]}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                   StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5038$5122, 
                    FEPrivate`Not[DynamicChart`click$5038$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5038$5122, {{{1., 0}, {
                    0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$5038$5122}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.8704000000000001, 0.50272, 0.2]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.4487989505128276, 
                    1.7951958020513104`}]}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                   StyleBox["3", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[3, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5041$5122, 
                    FEPrivate`Not[DynamicChart`click$5041$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5041$5122, {{{1., 0}, {0, 1.}}, {
                   0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$5041$5122}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[
                0.74058432, 0.47903999999999997`, 0.4089916800000002]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.3463968515384819`, 
                    0.4487989505128276}]}], StatusArea[#, 4]& , TagBoxNote -> 
                    "4"], 
                   StyleBox["4", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[4, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5044$5122, 
                    FEPrivate`Not[DynamicChart`click$5044$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5044$5122, {{{1., 0}, {0, 1.}}, {
                   0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$5044$5122}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.64020864, 0.49888000000000005`, 0.74416944]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.243994752564138, -1.3463968515384819`}]}], 
                    StatusArea[#, 2]& , TagBoxNote -> "2"], 
                   StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5047$5122, 
                    FEPrivate`Not[DynamicChart`click$5047$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5047$5122, {{{1., 0}, {
                    0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$5047$5122}]]}, {
               Directive[
                EdgeForm[
                 Directive[
                  GrayLevel[0], 
                  Opacity[0.5]]], 
                RGBColor[0.4992, 0.5552, 0.8309304]], 
               GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.243994752564138}]}], 
                    StatusArea[#, 2]& , TagBoxNote -> "2"], 
                   StyleBox["2", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                   Style[2, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$5050$5122, 
                    FEPrivate`Not[DynamicChart`click$5050$5122]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], 
                Dynamic[
                 If[
                 DynamicChart`click$5050$5122, {{{1., 0}, {
                    0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$5050$5122}]]}}}}}, {}}, {{}}}}, {{{{
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 1]& , TagBoxNote -> "1"], 
               StyleBox["1", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[1, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5024$5122, 
                 FEPrivate`Not[DynamicChart`click$5024$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5024$5122, {{{1., 0}, {
                0, 1.}}, {-0.19498558243636474`, 0.044504186791262904`}}, {{1,
               0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5024$5122}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
               StyleBox["2", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[2, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5038$5122, 
                 FEPrivate`Not[DynamicChart`click$5038$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5038$5122, {{{1., 0}, {
                0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 0}, {
              0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5038$5122}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 3]& , TagBoxNote -> "3"], 
               StyleBox["3", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[3, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5041$5122, 
                 FEPrivate`Not[DynamicChart`click$5041$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5041$5122, {{{1., 0}, {0, 1.}}, {
               0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 
              1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5041$5122}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 4]& , TagBoxNote -> "4"], 
               StyleBox["4", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[4, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5044$5122, 
                 FEPrivate`Not[DynamicChart`click$5044$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5044$5122, {{{1., 0}, {0, 1.}}, {
               0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 
              1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5044$5122}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
               StyleBox["2", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[2, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5047$5122, 
                 FEPrivate`Not[DynamicChart`click$5047$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5047$5122, {{{1., 0}, {
                0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, {{1, 
              0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5047$5122}]], 
           GeometricTransformationBox[
            TagBox[
             TagBox[
              TooltipBox[
               TagBox[{{}, {}}, StatusArea[#, 2]& , TagBoxNote -> "2"], 
               StyleBox["2", {
                 GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                False]], Annotation[#, 
               Style[2, {
                 GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
             
             EventHandlerTag[{
              "MouseClicked" :> FEPrivate`Set[DynamicChart`click$5050$5122, 
                 FEPrivate`Not[DynamicChart`click$5050$5122]], PassEventsDown -> 
               True, Method -> "Preemptive", PassEventsUp -> True}]], 
            Dynamic[
             If[
             DynamicChart`click$5050$5122, {{{1., 0}, {
                0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, {{1, 
              0}, {0, 1}}, {{1, 0}, {0, 1}}], 
             TrackedSymbols :> {DynamicChart`click$5050$5122}]]}, {}}}, {}}}, 
      DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, {}}}, {
    ContentSelectable -> False, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {
       GrayLevel[0], FontFamily -> "Arial"}, 
     PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
     Scaled[0.02]}, ImageSize -> 160], 
   FormBox[
    FormBox[
     TemplateBox[{"\"one\"", "\"two\"", 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{{
             GrayLevel[0], 
             RectangleBox[{0, 0}]}, {
             GrayLevel[0], 
             RectangleBox[{1, -1}]}, {
             RGBColor[1, 0.5, 0.5], 
             RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> True,
            FrameStyle -> 
           RGBColor[
            0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`], 
           FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
           Dynamic[{
             Automatic, 
              1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
               Magnification])}]], "RGBColor[1, 0.5, 0.5]"], Appearance -> 
         None, BaseStyle -> {}, BaselinePosition -> Baseline, 
         DefaultBaseStyle -> {}, ButtonFunction :> 
         With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = 
             RGBColor[1, 0.5, 0.5]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]], 
         BaseStyle -> Inherited, Evaluator -> Automatic, Method -> 
         "Preemptive"], 
        RGBColor[1, 0.5, 0.5], Editable -> False, Selectable -> False], 
       InterpretationBox[
        ButtonBox[
         TooltipBox[
          GraphicsBox[{{
             GrayLevel[0], 
             RectangleBox[{0, 0}]}, {
             GrayLevel[0], 
             RectangleBox[{1, -1}]}, {
             RGBColor[1, 1, 0], 
             RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> True,
            FrameStyle -> 
           RGBColor[0.6666666666666666, 0.6666666666666666, 0.], FrameTicks -> 
           None, PlotRangePadding -> None, ImageSize -> 
           Dynamic[{
             Automatic, 
              1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
               Magnification])}]], "RGBColor[1, 1, 0]"], Appearance -> None, 
         BaseStyle -> {}, BaselinePosition -> Baseline, 
         DefaultBaseStyle -> {}, ButtonFunction :> 
         With[{Typeset`box$ = EvaluationBox[]}, 
           If[
            Not[
             AbsoluteCurrentValue["Deployed"]], 
            SelectionMove[Typeset`box$, All, Expression]; 
            FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
            FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
            FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
            MathLink`CallFrontEnd[
              FrontEnd`AttachCell[Typeset`box$, 
               FrontEndResource["RGBColorValueSelector"], {
               0, {Left, Bottom}}, {Left, Top}, 
               "ClosingActions" -> {
                "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]], 
         BaseStyle -> Inherited, Evaluator -> Automatic, Method -> 
         "Preemptive"], 
        RGBColor[1, 1, 0], Editable -> False, Selectable -> False]}, 
      "SwatchLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #}, {
                   GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.9965728, 0.58382944, 0.22525344]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.9965728, 0.58382944, 0.22525344]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #2}, {
                   GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.8704000000000001, 0.50272, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.8704000000000001, 0.50272, 0.2]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #3}, {
                   GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          GrayLevel[0], FontFamily -> "Arial", FontFamily -> "Arial"}, 
         Background -> Automatic, StripOnInput -> False], TraditionalForm]& ),
       InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6552426666666666, 0.4954314666666667, 
                    0.21751146666666665`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.982864, 0.7431472, 0.3262672]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.982864, 0.7431472, 0.3262672]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.982864, 0.7431472, 0.3262672], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.9965728, 0.58382944, 0.22525344], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6643818666666668, 0.3892196266666667, 
                    0.15016896000000002`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.9965728, 0.58382944, 0.22525344]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.9965728, 0.58382944, 0.22525344]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.9965728, 0.58382944, 0.22525344], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.8704000000000001, 0.50272, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5802666666666667, 0.33514666666666665`, 
                    0.13333333333333336`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.8704000000000001, 0.50272, 0.2]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.8704000000000001, 0.50272, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.8704000000000001, 0.50272, 0.2], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.49372288, 0.31936, 0.27266112000000015`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.74058432, 0.47903999999999997, \
0.4089916800000002]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002], 
                    Editable -> False, Selectable -> False]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.9965728, 0.58382944, 0.22525344]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.8704000000000001, 0.50272, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[
                    0.74058432, 0.47903999999999997`, 0.4089916800000002]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}]}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "None", ",", "None", ",", "None", ",", "None", ",", 
                    "None", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 
                 RowBox[{"FontFamily", "\[Rule]", "\"Arial\""}]}], "}"}]}], 
           ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"a67aa084-531d-4c69-a636-39caa430e237"]
}, Open  ]],

Cell["The default plot theme for the web is more brightly colored:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"9bc71895-65a6-4051-b68d-e306ac81f258"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"PlotTheme", "\[Rule]", "\"\<Web\>\""}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"f70567c1-9791-4182-a58a-118f22c3d00c"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   DynamicModuleBox[{DynamicChart`click$57538$57578 = False, 
    DynamicChart`click$57541$57578 = False, DynamicChart`click$57544$57578 = 
    False, DynamicChart`click$57547$57578 = False, 
    DynamicChart`click$57550$57578 = False, DynamicChart`click$57553$57578 = 
    False}, {
     {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
         {RGBColor[0.8115292, 0.2810584, 0.1], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {2.6927937030769655`, 
                  3.141592653589793}]},
                
                ImageSizeCache->{{5.665180026792155, 
                 72.54480777889184}, {-33.54424165672192, \
-3.3471684215592346`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57538$57578, 
                FEPrivate`Not[DynamicChart`click$57538$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57538$57578, {{{1., 0}, {
               0, 1.}}, {-0.19498558243636474`, 0.044504186791262904`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$57538$57578}]]}, 
         {RGBColor[0.2729413, 0.4494115, 0.8270587], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {1.7951958020513104`, 
                  2.6927937030769655`}]},
                
                ImageSizeCache->{{12.008242937128255`, 
                 72.54480777889184}, {-67.67238513777268, \
-3.3471684215592354`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57541$57578, 
                FEPrivate`Not[DynamicChart`click$57541$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57541$57578, {{{1., 0}, {
               0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 0}, {
             0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$57541$57578}]]}, 
         {RGBColor[1., 0.6470587, 0.1], EdgeForm[{GrayLevel[0], Opacity[
          0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {0.4487989505128276, 
                  1.7951958020513104`}]},
                
                ImageSizeCache->{{55.463647669523674`, 
                 
                 130.25294549590922`}, {-69.25388966739747, \
-3.347168421559232}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57544$57578, 
                FEPrivate`Not[DynamicChart`click$57544$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57544$57578, {{{1., 0}, {0, 1.}}, {
              0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$57544$57578}]]}, 
         {RGBColor[0.1, 0.6364702, 0.1988236], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 1., {-1.3463968515384819`, 
                  0.4487989505128276}]},
                
                ImageSizeCache->{{69.71638065414564, 
                 136.59600840624535`}, {-33.54424165672194, 
                 58.149621169908016`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[4, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57547$57578, 
                FEPrivate`Not[DynamicChart`click$57547$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57547$57578, {{{1., 0}, {0, 1.}}, {
              0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$57547$57578}]]}, 
         {RGBColor[0.6106834, 0.390853, 0.7568479], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-2.243994752564138, -1.3463968515384819`}]},
                
                ImageSizeCache->{{29.78111026618304, 
                 86.79754076351387}, {-6.175595546305431, 59.73112569953281}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57550$57578, 
                FEPrivate`Not[DynamicChart`click$57550$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57550$57578, {{{1., 0}, {
               0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$57550$57578}]]}, 
         {RGBColor[0.1, 0.6294115, 0.7352938], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 DiskBox[{0, 0}, 
                  1., {-3.141592653589793, -2.243994752564138}]},
                
                ImageSizeCache->{{5.665180026792155, 
                 72.54480777889184}, {-6.175595546305431, 45.96942778268857}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57553$57578, 
                FEPrivate`Not[DynamicChart`click$57553$57578]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$57553$57578, {{{1., 0}, {
               0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {
             DynamicChart`click$57553$57578}]]}}}, {}}, {}}, {{{
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57538$57578, 
              FEPrivate`Not[DynamicChart`click$57538$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57538$57578, {{{1., 0}, {
             0, 1.}}, {-0.19498558243636474`, 0.044504186791262904`}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57538$57578}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57541$57578, 
              FEPrivate`Not[DynamicChart`click$57541$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57541$57578, {{{1., 0}, {
             0, 1.}}, {-0.1246979603717467, 0.156366296493606}}, {{1, 0}, {0, 
           1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57541$57578}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 3]& ,
             TagBoxNote->"3"],
            StyleBox["3", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[3, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57544$57578, 
              FEPrivate`Not[DynamicChart`click$57544$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57544$57578, {{{1., 0}, {0, 1.}}, {
            0.08677674782351164, 0.18019377358048383`}}, {{1, 0}, {0, 1}}, {{
           1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57544$57578}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 4]& ,
             TagBoxNote->"4"],
            StyleBox["4", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[4, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57547$57578, 
              FEPrivate`Not[DynamicChart`click$57547$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57547$57578, {{{1., 0}, {0, 1.}}, {
            0.18019377358048388`, -0.08677674782351154}}, {{1, 0}, {0, 1}}, {{
           1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57547$57578}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57550$57578, 
              FEPrivate`Not[DynamicChart`click$57550$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57550$57578, {{{1., 0}, {
             0, 1.}}, {-0.04450418679126278, -0.19498558243636477`}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57550$57578}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$57553$57578, 
              FEPrivate`Not[DynamicChart`click$57553$57578]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$57553$57578, {{{1., 0}, {
             0, 1.}}, {-0.18019377358048383`, -0.08677674782351165}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$57553$57578}]]}, {}}, {}}},
    DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
  AspectRatio->1.0030194527575886`,
  ContentSelectable->False,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{144.66015625, 144.},
  LabelStyle->{
    GrayLevel[0], FontFamily -> "Arial"},
  PlotRange->{{-1.1019898027886565`, 
   1.1394437114346414`}, {-1.169362345822667, 1.1135148626757387`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"908a2cb8-27fe-430f-b6f9-1b1faba70791"]
}, Open  ]],

Cell[TextData[{
 "If you want the Wolfram Language to just automatically pick how to annotate \
things, then simply give the annotations with rules (",
 ButtonBox["\[Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"],
 "). "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f800eec5-0078-45d4-b598-b54e6474d000"],

Cell[TextData[{
 "In ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 ", annotations specified by rules are implemented with callouts:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a86fe62e-d5b9-4467-aa67-011c7aae904f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "\"\<one\>\""}], ",", 
    RowBox[{"2", "\[Rule]", "\"\<two\>\""}], ",", 
    RowBox[{"3", "\[Rule]", "Pink"}], ",", 
    RowBox[{"4", "\[Rule]", "Yellow"}], ",", "5", ",", "6", ",", "7"}], "}"}],
   "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"a1efc2ed-bc11-4617-9fa9-991fc4a70e58"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {
      7., 7.}}]}, {}}, {}, {}, {{}, {}}, {{GraphicsGroupBox[{
       {GrayLevel[1], AbsoluteThickness[4], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
        "Round"], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {1., 1.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {1., 1.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {1., 1.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {1., 1.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {1., 1.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {1., 1.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {1., 1.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {1., 1.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {1., 1.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {1., 1.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {1., 1.}]}]}, 
       {GrayLevel[1], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
        PolygonBox[{
         Offset[{-10.494480483301837`, 14.204059656000311`}, {1., 1.}], 
          Offset[{-10.494480483301833`, 3.204059656000312}, {1., 1.}], 
          Offset[{-33.494480483301835`, 3.2040596560003065`}, {1., 1.}], 
          Offset[{-33.494480483301835`, 14.204059656000307`}, {1., 1.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        EdgeForm[None]}, {}, InsetBox[
        StyleBox[
         RotationBox[
          TagBox[
           TagBox["\<\"one\"\>",
            HoldForm],
           HoldForm],
          BoxRotation->0.],
         StripOnInput->False,
         Opacity->1,
         FontOpacity->1,
         $CellContext`LineOpacity -> 1,
         $CellContext`FrontFaceOpacity -> 1,
         $CellContext`BackFaceOpacity -> 1], 
        Offset[{-21.994480483301835, 8.70405965600031}, {1., 1.}], {0, 0}]}], 
     GraphicsGroupBox[{
       {GrayLevel[1], AbsoluteThickness[4], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
        "Round"], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 2.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 2.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {2., 2.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {2., 2.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 2.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 2.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {2., 2.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {2., 2.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {2., 2.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 2.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {2., 2.}]}]}, 
       {GrayLevel[1], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
        PolygonBox[{
         Offset[{-10.494480483301837`, 15.404059656000314`}, {2., 2.}], 
          Offset[{-10.494480483301833`, 2.404059656000313}, {2., 2.}], 
          Offset[{-32.494480483301835`, 2.4040596560003076`}, {2., 2.}], 
          Offset[{-32.494480483301835`, 15.404059656000307`}, {2., 2.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        EdgeForm[None]}, {}, InsetBox[
        StyleBox[
         RotationBox[
          TagBox[
           TagBox["\<\"two\"\>",
            HoldForm],
           HoldForm],
          BoxRotation->0.],
         StripOnInput->False,
         Opacity->1,
         FontOpacity->1,
         $CellContext`LineOpacity -> 1,
         $CellContext`FrontFaceOpacity -> 1,
         $CellContext`BackFaceOpacity -> 1], 
        Offset[{-21.494480483301835, 8.90405965600031}, {2., 2.}], {0, 0}]}], 
     GraphicsGroupBox[{
       {GrayLevel[1], AbsoluteThickness[4], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
        "Round"], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 3.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 3.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {3., 3.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {3., 3.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 3.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        BSplineCurveBox[{
         Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 3.}], 
          Offset[{-3.2472402416509185`, 3.8020298280001548`}, {3., 3.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {3., 3.}], 
          Offset[{-4.870860362476378, 5.703044742000232}, {3., 3.}], 
          Offset[{-6.494480483301837, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-8.494480483301837, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 3.}], 
          Offset[{-10.494480483301837`, 7.6040596560003095`}, {3., 3.}]}]}, 
       {GrayLevel[1], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
        PolygonBox[{
         Offset[{-10.494480483301837`, 16.00405965600031}, {3., 3.}], 
          Offset[{-10.494480483301833`, 2.0040596560003117`}, {3., 3.}], 
          Offset[{-25.494480483301835`, 2.004059656000308}, {3., 3.}], 
          Offset[{-25.494480483301835`, 16.004059656000308`}, {3., 3.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        EdgeForm[None]}, {}, InsetBox[
        StyleBox[
         RotationBox[
          TagBox[
           TagBox[
            InterpretationBox[
             ButtonBox[
              TooltipBox[
               GraphicsBox[{
                 {GrayLevel[0], RectangleBox[{0, 0}]}, 
                 {GrayLevel[0], RectangleBox[{1, -1}]}, 
                 {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
                AspectRatio->1,
                Frame->True,
                
                FrameStyle->RGBColor[
                 0.6666666666666666, 0.33333333333333337`, 
                  0.33333333333333337`],
                FrameTicks->None,
                
                ImageSize->
                 Dynamic[{
                  Automatic, 
                   1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}],
                PlotRangePadding->None],
               "RGBColor[1, 0.5, 0.5]"],
              Appearance->None,
              BaseStyle->{},
              BaselinePosition->Baseline,
              ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
                If[
                 Not[
                  AbsoluteCurrentValue["Deployed"]], 
                 SelectionMove[Typeset`box$, All, Expression]; 
                 FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                 FrontEnd`Private`$ColorSelectorInitialColor = 
                  RGBColor[1, 0.5, 0.5]; 
                 FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                 MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
              DefaultBaseStyle->{},
              Evaluator->Automatic,
              Method->"Preemptive"],
             RGBColor[1, 0.5, 0.5],
             Editable->False,
             Selectable->False],
            HoldForm],
           HoldForm],
          BoxRotation->0.],
         StripOnInput->False,
         Opacity->1,
         FontOpacity->1,
         $CellContext`LineOpacity -> 1,
         $CellContext`FrontFaceOpacity -> 1,
         $CellContext`BackFaceOpacity -> 1], 
        Offset[{-17.994480483301835, 9.00405965600031}, {3., 3.}], {0, 0}]}], 
     GraphicsGroupBox[{
       {GrayLevel[1], AbsoluteThickness[4], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
        "Round"], 
        BSplineCurveBox[{
         Offset[{3.2472402416509185`, 3.8020298280001548`}, {4., 4.}], 
          Offset[{3.2472402416509185`, 3.8020298280001548`}, {4., 4.}], 
          Offset[{4.870860362476378, 5.703044742000232}, {4., 4.}], 
          Offset[{4.870860362476378, 5.703044742000232}, {4., 4.}], 
          Offset[{6.494480483301837, 7.6040596560003095`}, {4., 4.}], 
          Offset[{8.494480483301837, 7.6040596560003095`}, {4., 4.}], 
          Offset[{10.494480483301837`, 7.6040596560003095`}, {4., 4.}], 
          Offset[{10.494480483301837`, 7.6040596560003095`}, {4., 4.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        BSplineCurveBox[{
         Offset[{3.2472402416509185`, 3.8020298280001548`}, {4., 4.}], 
          Offset[{3.2472402416509185`, 3.8020298280001548`}, {4., 4.}], 
          Offset[{4.870860362476378, 5.703044742000232}, {4., 4.}], 
          Offset[{4.870860362476378, 5.703044742000232}, {4., 4.}], 
          Offset[{6.494480483301837, 7.6040596560003095`}, {4., 4.}], 
          Offset[{8.494480483301837, 7.6040596560003095`}, {4., 4.}], 
          Offset[{10.494480483301837`, 7.6040596560003095`}, {4., 4.}], 
          Offset[{10.494480483301837`, 7.6040596560003095`}, {4., 4.}]}]}, 
       {GrayLevel[1], Opacity[
         NCache[
          Rational[2, 3], 0.6666666666666666]], EdgeForm[None], 
        PolygonBox[{
         Offset[{25.494480483301835`, 16.00405965600031}, {4., 4.}], 
          Offset[{25.494480483301835`, 2.0040596560003117`}, {4., 4.}], 
          Offset[{10.494480483301837`, 2.004059656000308}, {4., 4.}], 
          Offset[{10.494480483301833`, 16.004059656000308`}, {4., 4.}]}]}, 
       {RGBColor[0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
        EdgeForm[None]}, {}, InsetBox[
        StyleBox[
         RotationBox[
          TagBox[
           TagBox[
            InterpretationBox[
             ButtonBox[
              TooltipBox[
               GraphicsBox[{
                 {GrayLevel[0], RectangleBox[{0, 0}]}, 
                 {GrayLevel[0], RectangleBox[{1, -1}]}, 
                 {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
                AspectRatio->1,
                Frame->True,
                
                FrameStyle->RGBColor[
                 0.6666666666666666, 0.6666666666666666, 0.],
                FrameTicks->None,
                
                ImageSize->
                 Dynamic[{
                  Automatic, 
                   1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}],
                PlotRangePadding->None],
               "RGBColor[1, 1, 0]"],
              Appearance->None,
              BaseStyle->{},
              BaselinePosition->Baseline,
              ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
                If[
                 Not[
                  AbsoluteCurrentValue["Deployed"]], 
                 SelectionMove[Typeset`box$, All, Expression]; 
                 FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                 FrontEnd`Private`$ColorSelectorInitialColor = 
                  RGBColor[1, 1, 0]; 
                 FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                 MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
              DefaultBaseStyle->{},
              Evaluator->Automatic,
              Method->"Preemptive"],
             RGBColor[1, 1, 0],
             Editable->False,
             Selectable->False],
            HoldForm],
           HoldForm],
          BoxRotation->0.],
         StripOnInput->False,
         Opacity->1,
         FontOpacity->1,
         $CellContext`LineOpacity -> 1,
         $CellContext`FrontFaceOpacity -> 1,
         $CellContext`BackFaceOpacity -> 1], 
        Offset[{17.994480483301835, 9.00405965600031}, {4., 4.}], {0, 0}]}]}, \
{}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 7.}, {0, 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.08]}, {
     Scaled[0.02], 
     Scaled[0.0970820393249937]}},
  Ticks->{Automatic, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"f77b0b75-93f7-4c7a-96fb-d0b042a752e4"]
}, Open  ]],

Cell[TextData[{
 "In ",
 ButtonBox["PieChart",
  BaseStyle->"Link"],
 ", strings are assumed to be labels, and colors to be styles:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4f885ffe-dcf3-4303-a116-93d7fdb7ff89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "\"\<one\>\""}], ",", 
    RowBox[{"2", "\[Rule]", "\"\<two\>\""}], ",", 
    RowBox[{"3", "\[Rule]", "Blue"}], ",", 
    RowBox[{"4", "\[Rule]", "Red"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"510e6887-3a9c-4162-9a34-443babc10bf6"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   DynamicModuleBox[{DynamicChart`click$31376$31413 = False, 
    DynamicChart`click$31381$31413 = False, DynamicChart`click$31386$31413 = 
    False, DynamicChart`click$31390$31413 = False}, {
     {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.5]}], {{{}, {
         {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], {
                  
                  DiskBox[{0, 0}, 1., {2.5132741228718345`, 
                   3.141592653589793}], {
                   GrayLevel[0], 
                   InsetBox[
                    FormBox["\"one\"", TraditionalForm], {-0.8559508646656382,
                     0.27811529493745274`}, {0, 0}]}}},
                
                ImageSizeCache->{{13.09275258346025, 
                 80.5431198123731}, {-42.269130680129805`, \
-1.4568801876269113`}}],
               StatusArea[#, 1]& ,
               TagBoxNote->"1"],
              StyleBox["1", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[1, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31376$31413, 
                FEPrivate`Not[DynamicChart`click$31376$31413]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$31376$31413, {{{1., 0}, {
               0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$31376$31413}]]}, 
         {RGBColor[0.928, 0.5210666666666667, 0.2], EdgeForm[{GrayLevel[0], 
          Opacity[0.5]}], GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], {
                  
                  DiskBox[{0, 0}, 1., {1.256637061435917, 
                   2.5132741228718345`}], {
                   GrayLevel[0], 
                   InsetBox[
                    FormBox[
                    "\"two\"", TraditionalForm], {-0.27811529493745263`, 
                    0.8559508646656383}, {0, 0}]}}},
                
                ImageSizeCache->{{25.434444933876126`, 
                 100.51239751404059`}, {-68.90724741653978, \
-1.4568801876269255`}}],
               StatusArea[#, 2]& ,
               TagBoxNote->"2"],
              StyleBox["2", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[2, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31381$31413, 
                FEPrivate`Not[DynamicChart`click$31381$31413]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$31381$31413, {{{1., 0}, {
               0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$31381$31413}]]}, 
         {RGBColor[0, 0, 1], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], {
                  RGBColor[0, 0, 1], 
                  
                  DiskBox[{0, 0}, 1., {-0.6283185307179591, 
                   1.256637061435917}]}},
                
                ImageSizeCache->{{77.71469268762691, 
                 145.1650599165398}, {-65.74442454407595, 
                 36.526943180129805`}}],
               StatusArea[#, 3]& ,
               TagBoxNote->"3"],
              StyleBox["3", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[3, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31386$31413, 
                FEPrivate`Not[DynamicChart`click$31386$31413]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$31386$31413, {{{1., 0}, {0, 1.}}, {
              0.19021130325903074`, 0.061803398874989424`}}, {{1, 0}, {0, 
             1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {DynamicChart`click$31386$31413}]]}, 
         {RGBColor[1, 0, 0], EdgeForm[{GrayLevel[0], Opacity[0.5]}], 
          GeometricTransformationBox[
           TagBox[
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], {
                  RGBColor[1, 0, 0], 
                  
                  DiskBox[{0, 0}, 
                   1., {-3.141592653589793, -0.6283185307179591}]}},
                
                ImageSizeCache->{{13.09275258346024, 
                 132.8233675661239}, {-4.2853073123731065`, 
                 63.165059916539775`}}],
               StatusArea[#, 4]& ,
               TagBoxNote->"4"],
              StyleBox["4", {
                GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
             
             Annotation[#, 
              Style[4, {
                GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
            
            EventHandlerTag[{
             "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31390$31413, 
                FEPrivate`Not[DynamicChart`click$31390$31413]], 
              PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
              True}]], Dynamic[
           If[DynamicChart`click$31390$31413, {{{1., 0}, {
               0, 1.}}, {-0.061803398874989514`, -0.1902113032590307}}, {{1, 
             0}, {0, 1}}, {{1, 0}, {0, 1}}], 
            TrackedSymbols :> {
             DynamicChart`click$31390$31413}]]}}}, {}}, {}}, {{{
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 1]& ,
             TagBoxNote->"1"],
            StyleBox["1", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[1, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31376$31413, 
              FEPrivate`Not[DynamicChart`click$31376$31413]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$31376$31413, {{{1., 0}, {
             0, 1.}}, {-0.1902113032590307, 0.06180339887498951}}, {{1, 0}, {
           0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$31376$31413}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 2]& ,
             TagBoxNote->"2"],
            StyleBox["2", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[2, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31381$31413, 
              FEPrivate`Not[DynamicChart`click$31381$31413]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$31381$31413, {{{1., 0}, {
             0, 1.}}, {-0.06180339887498947, 0.19021130325903074`}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$31381$31413}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 3]& ,
             TagBoxNote->"3"],
            StyleBox["3", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[3, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31386$31413, 
              FEPrivate`Not[DynamicChart`click$31386$31413]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[DynamicChart`click$31386$31413, {{{1., 0}, {0, 1.}}, {
            0.19021130325903074`, 0.061803398874989424`}}, {{1, 0}, {0, 
           1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {DynamicChart`click$31386$31413}]], 
        GeometricTransformationBox[
         TagBox[
          TagBox[
           TooltipBox[
            TagBox[{{}, {}},
             StatusArea[#, 4]& ,
             TagBoxNote->"4"],
            StyleBox["4", {
              GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> False]],
           Annotation[#, 
            Style[4, {
              GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
          
          EventHandlerTag[{
           "MouseClicked" :> FEPrivate`Set[DynamicChart`click$31390$31413, 
              FEPrivate`Not[DynamicChart`click$31390$31413]], PassEventsDown -> 
            True, Method -> "Preemptive", PassEventsUp -> True}]], Dynamic[
         If[
          DynamicChart`click$31390$31413, {{{1., 0}, {
             0, 1.}}, {-0.061803398874989514`, -0.1902113032590307}}, {{1, 
           0}, {0, 1}}, {{1, 0}, {0, 1}}], 
          TrackedSymbols :> {
           DynamicChart`click$31390$31413}]]}, {}}, {}}, {}, {}},
    DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
  ContentSelectable->False,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{158.2578125, Automatic},
  LabelStyle->{
    GrayLevel[0], FontFamily -> "Arial"},
  PlotRange->{{-1., 1.}, {-1., 1.}},
  PlotRangePadding->Scaled[0.09166666666666669]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"138705a3-4001-4256-9165-1859d7e91c8e"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s common to want to combine different objects ",
 "for presentation",
 ". ",
 ButtonBox["Row",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Column",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Grid",
  BaseStyle->"Link"],
 " are convenient ways to do this."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"4ae1af08-c59a-4979-b819-ba5b1a44082a"],

Cell["Display a list of objects in a row:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eb8169ec-ae71-4440-9284-7d465a55d97a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", "Pink", ",", "Cyan"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"44f46079-e894-41d4-a22e-36b170fdb22b"],

Cell[BoxData[
 TemplateBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{{
         GrayLevel[0], 
         RectangleBox[{0, 0}]}, {
         GrayLevel[0], 
         RectangleBox[{1, -1}]}, {
         RGBColor[1, 1, 0], 
         RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> True, 
       FrameStyle -> RGBColor[0.6666666666666666, 0.6666666666666666, 0.], 
       FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
       Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}]], "RGBColor[1, 1, 0]"], Appearance -> None, 
     BaseStyle -> {}, BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
     ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]], 
     BaseStyle -> Inherited, Evaluator -> Automatic, Method -> "Preemptive"], 
    
    RGBColor[1, 1, 0], Editable -> False, Selectable -> False], 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{{
         GrayLevel[0], 
         RectangleBox[{0, 0}]}, {
         GrayLevel[0], 
         RectangleBox[{1, -1}]}, {
         RGBColor[1, 0.5, 0.5], 
         RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> True, 
       FrameStyle -> 
       RGBColor[
        0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`], 
       FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
       Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}]], "RGBColor[1, 0.5, 0.5]"], Appearance -> None, 
     BaseStyle -> {}, BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
     ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]], 
     BaseStyle -> Inherited, Evaluator -> Automatic, Method -> "Preemptive"], 
    
    RGBColor[1, 0.5, 0.5], Editable -> False, Selectable -> False], 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{{
         GrayLevel[0], 
         RectangleBox[{0, 0}]}, {
         GrayLevel[0], 
         RectangleBox[{1, -1}]}, {
         RGBColor[0, 1, 1], 
         RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> True, 
       FrameStyle -> RGBColor[0., 0.6666666666666666, 0.6666666666666666], 
       FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
       Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}]], "RGBColor[0, 1, 1]"], Appearance -> None, 
     BaseStyle -> {}, BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
     ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 1]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]], 
     BaseStyle -> Inherited, Evaluator -> Automatic, Method -> "Preemptive"], 
    
    RGBColor[0, 1, 1], Editable -> False, Selectable -> False]},
  "RowDefault"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[15]=",ExpressionUUID->"cd274b6d-753c-41ab-be07-b5a86e0e5020"]
}, Open  ]],

Cell["Display objects in a column:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3489b7ec-e321-46c8-80fd-9ad2d5202a56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", "Pink", ",", "Cyan"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"0febbf0c-598f-421b-8c4e-54a0a7af72b6"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 1, 0],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0.5, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666666, 0.33333333333333337`, 0.33333333333333337`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0.5, 0.5]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0.5, 0.5]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0.5, 0.5],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 1],
      Editable->False,
      Selectable->False]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"f4fe9a62-e0bb-478c-8a5d-b270e676db06"]
}, Open  ]],

Cell[TextData[{
 "Use ",
 ButtonBox["GraphicsRow",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["GraphicsColumn",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["GraphicsGrid",
  BaseStyle->"Link"],
 " to arrange objects to fit in a certain overall size."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "GraphicsGrid", 
   "i:15"},ExpressionUUID->"2d5ed120-0218-476e-aa21-1d13fc18d945"],

Cell["Generate an array of random pie charts, sized to fit:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:230",ExpressionUUID->"1dba8cad-77b2-402d-b36e-b5ea9477eb82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PieChart", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"10", ",", "5"}], "]"}], "]"}], ",", "3", ",", "6"}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"df0956e1-de08-459c-9b61-f66bb2abbc7e"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43539$44504 = False, 
         DynamicChart`click$43542$44504 = False, 
         DynamicChart`click$43545$44504 = False, 
         DynamicChart`click$43548$44504 = False, 
         DynamicChart`click$43551$44504 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.3638001170020673`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    24.90895317590587}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 7.76398019774614]& ,
                    TagBoxNote->"7.76398019774614"],
                   StyleBox["7.76398019774614`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.76398019774614, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43539$44504, 
                    FEPrivate`Not[DynamicChart`click$43539$44504]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43539$44504, {{{1., 0}, {
                    0, 1.}}, {-0.12605386434859325`, 0.1552753144668735}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43539$44504}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.623559569410554, 
                    1.3638001170020673`}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    37.733276062373065`}, {-37.034177744875706`, \
-8.982868699245817}}],
                    StatusArea[#, 8.679202400479408]& ,
                    TagBoxNote->"8.679202400479408"],
                   StyleBox["8.679202400479408`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.679202400479408, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43542$44504, 
                    FEPrivate`Not[DynamicChart`click$43542$44504]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43542$44504, {{{1., 0}, {0, 1.}}, {
                   0.18645676920042176`, 0.07234551277958194}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43542$44504}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.2056378165762673`, -0.623559569410554}]},
                    
                    ImageSizeCache->{{9.190147295244468, 
                    34.695470094386565`}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 6.90925624305736]& ,
                    TagBoxNote->"6.90925624305736"],
                   StyleBox["6.90925624305736`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.90925624305736, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43545$44504, 
                    FEPrivate`Not[DynamicChart`click$43545$44504]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43545$44504, {{{1., 0}, {0, 1.}}, {
                   0.03111265285961029, -0.1975651862855331}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43545$44504}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.4304729249108226`, -2.2056378165762673`}]},
                    ImageSizeCache->{{6.533502642752367, 
                    21.59147050681752}, {-21.236956617928644`, \
-5.4117011453054555`}}],
                    StatusArea[#, 0.9819004709166492]& ,
                    TagBoxNote->"0.9819004709166492"],
                   StyleBox["0.9819004709166492`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.9819004709166492, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43548$44504, 
                    FEPrivate`Not[DynamicChart`click$43548$44504]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43548$44504, {{{1., 0}, {
                    0, 1.}}, {-0.1359261349963588, -0.14671089197790207`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43548$44504}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.4304729249108226`}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    21.591470506817515`}, {-21.236956617928644`, \
-7.873055137525656}}],
                    StatusArea[#, 3.105603931877962]& ,
                    TagBoxNote->"3.105603931877962"],
                   StyleBox["3.105603931877962`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.105603931877962, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43551$44504, 
                    FEPrivate`Not[DynamicChart`click$43551$44504]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43551$44504, {{{1., 0}, {
                    0, 1.}}, {-0.18749034768550601`, -0.0696230531129458}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43551$44504}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.76398019774614]& ,
                  TagBoxNote->"7.76398019774614"],
                 StyleBox["7.76398019774614`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.76398019774614, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43539$44504, 
                   FEPrivate`Not[DynamicChart`click$43539$44504]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43539$44504, {{{1., 0}, {
                  0, 1.}}, {-0.12605386434859325`, 0.1552753144668735}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43539$44504}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.679202400479408]& ,
                  TagBoxNote->"8.679202400479408"],
                 StyleBox["8.679202400479408`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.679202400479408, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43542$44504, 
                   FEPrivate`Not[DynamicChart`click$43542$44504]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43542$44504, {{{1., 0}, {0, 1.}}, {
                 0.18645676920042176`, 0.07234551277958194}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43542$44504}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.90925624305736]& ,
                  TagBoxNote->"6.90925624305736"],
                 StyleBox["6.90925624305736`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.90925624305736, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43545$44504, 
                   FEPrivate`Not[DynamicChart`click$43545$44504]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43545$44504, {{{1., 0}, {0, 1.}}, {
                 0.03111265285961029, -0.1975651862855331}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43545$44504}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.9819004709166492]& ,
                  TagBoxNote->"0.9819004709166492"],
                 StyleBox["0.9819004709166492`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.9819004709166492, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43548$44504, 
                   FEPrivate`Not[DynamicChart`click$43548$44504]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43548$44504, {{{1., 0}, {
                  0, 1.}}, {-0.1359261349963588, -0.14671089197790207`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43548$44504}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.105603931877962]& ,
                  TagBoxNote->"3.105603931877962"],
                 StyleBox["3.105603931877962`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.105603931877962, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43551$44504, 
                   FEPrivate`Not[DynamicChart`click$43551$44504]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43551$44504, {{{1., 0}, {
                  0, 1.}}, {-0.18749034768550601`, -0.0696230531129458}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43551$44504}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43590$44505 = False, 
         DynamicChart`click$43593$44505 = False, 
         DynamicChart`click$43596$44505 = False, 
         DynamicChart`click$43599$44505 = False, 
         DynamicChart`click$43602$44505 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.2806028529278626, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    37.73327606237308}, {-37.37876217348419, \
-13.938299001096915`}}],
                    StatusArea[#, 6.778458173935917]& ,
                    TagBoxNote->"6.778458173935917"],
                   StyleBox["6.778458173935917`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.778458173935917, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43590$44505, 
                    FEPrivate`Not[DynamicChart`click$43590$44505]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43590$44505, {{{1., 0}, {0, 1.}}, {
                   0.027968317121337044`, 0.19803477784823637`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43590$44505}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.1881413480180765`, -0.2806028529278626}]},
                    
                    ImageSizeCache->{{18.76304338207134, 
                    37.10194844726131}, {-21.236956617928644`, \
-3.4341545571279646`}}],
                    StatusArea[#, 1.7975921359518114`]& ,
                    TagBoxNote->"1.7975921359518114"],
                   StyleBox["1.7975921359518114`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.7975921359518114`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43593$44505, 
                    FEPrivate`Not[DynamicChart`click$43593$44505]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43593$44505, {{{1., 0}, {0, 1.}}, {
                   0.14845033369924732`, -0.13402424565944074`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43593$44505}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.6737055475498863`, -1.1881413480180765`}]},
                    
                    ImageSizeCache->{{17.10483319703132, 
                    27.6185744438529}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 0.9617734027814997]& ,
                    TagBoxNote->"0.9617734027814997"],
                   StyleBox["0.9617734027814997`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.9617734027814997, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43596$44505, 
                    FEPrivate`Not[DynamicChart`click$43596$44505]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43596$44505, {{{1., 0}, {0, 1.}}, {
                   0.02788344725604775, -0.19804674541410472`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43596$44505}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.0822578460832615`, -1.6737055475498863`}]},
                    
                    ImageSizeCache->{{10.862400205064269`, 
                    21.59147050681753}, {-21.236956617928644`, \
-2.352121875798243}}],
                    StatusArea[#, 0.8092333305328587]& ,
                    TagBoxNote->"0.8092333305328587"],
                   StyleBox["0.8092333305328587`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.8092333305328587, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43599$44505, 
                    FEPrivate`Not[DynamicChart`click$43599$44505]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43599$44505, {{{1., 0}, {
                    0, 1.}}, {-0.06047539300186882, -0.1906376847353889}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43599$44505}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.0822578460832615`}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.59147050681753}, {-21.236956617928644`, \
-4.332389255781589}}],
                    StatusArea[#, 2.098260216636291]& ,
                    TagBoxNote->"2.098260216636291"],
                   StyleBox["2.098260216636291`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.098260216636291, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43602$44505, 
                    FEPrivate`Not[DynamicChart`click$43602$44505]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43602$44505, {{{1., 0}, {
                    0, 1.}}, {-0.1725950322563145, -0.1010492693711427}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43602$44505}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.778458173935917]& ,
                  TagBoxNote->"6.778458173935917"],
                 StyleBox["6.778458173935917`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.778458173935917, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43590$44505, 
                   FEPrivate`Not[DynamicChart`click$43590$44505]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43590$44505, {{{1., 0}, {0, 1.}}, {
                 0.027968317121337044`, 0.19803477784823637`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43590$44505}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.7975921359518114`]& ,
                  TagBoxNote->"1.7975921359518114"],
                 StyleBox["1.7975921359518114`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.7975921359518114`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43593$44505, 
                   FEPrivate`Not[DynamicChart`click$43593$44505]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43593$44505, {{{1., 0}, {0, 1.}}, {
                 0.14845033369924732`, -0.13402424565944074`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43593$44505}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.9617734027814997]& ,
                  TagBoxNote->"0.9617734027814997"],
                 StyleBox["0.9617734027814997`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.9617734027814997, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43596$44505, 
                   FEPrivate`Not[DynamicChart`click$43596$44505]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43596$44505, {{{1., 0}, {0, 1.}}, {
                 0.02788344725604775, -0.19804674541410472`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43596$44505}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.8092333305328587]& ,
                  TagBoxNote->"0.8092333305328587"],
                 StyleBox["0.8092333305328587`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.8092333305328587, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43599$44505, 
                   FEPrivate`Not[DynamicChart`click$43599$44505]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43599$44505, {{{1., 0}, {
                  0, 1.}}, {-0.06047539300186882, -0.1906376847353889}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43599$44505}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.098260216636291]& ,
                  TagBoxNote->"2.098260216636291"],
                 StyleBox["2.098260216636291`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.098260216636291, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43602$44505, 
                   FEPrivate`Not[DynamicChart`click$43602$44505]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43602$44505, {{{1., 0}, {
                  0, 1.}}, {-0.1725950322563145, -0.1010492693711427}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43602$44505}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43641$44506 = False, 
         DynamicChart`click$43644$44506 = False, 
         DynamicChart`click$43647$44506 = False, 
         DynamicChart`click$43650$44506 = False, 
         DynamicChart`click$43653$44506 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.726253857811574, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-27.750174268342768`, \
-18.408529493182453`}}],
                    StatusArea[#, 1.2043329564104788`]& ,
                    TagBoxNote->"1.2043329564104788"],
                   StyleBox["1.2043329564104788`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.2043329564104788`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43641$44506, 
                    FEPrivate`Not[DynamicChart`click$43641$44506]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43641$44506, {{{1., 0}, {
                    0, 1.}}, {-0.1957028190359712, 0.041235986969804767`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43641$44506}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.9206625030381437, 
                    2.726253857811574}]},
                    
                    ImageSizeCache->{{3.993619478895635, 
                    31.361991371633327`}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 5.2355647882328675`]& ,
                    TagBoxNote->"5.2355647882328675"],
                   StyleBox["5.2355647882328675`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.2355647882328675`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43644$44506, 
                    FEPrivate`Not[DynamicChart`click$43644$44506]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$43644$44506, {{{1., 0}, {
                    0, 1.}}, {-0.04999643655403622, 0.1936500873531903}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43644$44506}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-2.026370026053103, 
                    0.9206625030381437}]},
                    
                    ImageSizeCache->{{11.661010947594594`, 
                    37.73327606237309}, {-34.08587908728629, \
-2.266723937626896}}],
                    StatusArea[#, 8.5453331941895]& ,
                    TagBoxNote->"8.5453331941895"],
                   StyleBox["8.5453331941895`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.5453331941895, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43647$44506, 
                    FEPrivate`Not[DynamicChart`click$43647$44506]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43647$44506, {{{1., 0}, {0, 1.}}, {
                   0.17020588558630925`, -0.10502359978490648`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43647$44506}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.7164830129975757`, -2.026370026053103}]},
                    
                    ImageSizeCache->{{4.05796311366816, 
                    21.591470506817537`}, {-21.236956617928644`, \
-3.9130466832514763`}}],
                    StatusArea[#, 2.0010791726470583`]& ,
                    TagBoxNote->"2.0010791726470583"],
                   StyleBox["2.0010791726470583`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.0010791726470583`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43650$44506, 
                    FEPrivate`Not[DynamicChart`click$43650$44506]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43650$44506, {{{1., 0}, {
                    0, 1.}}, {-0.14355900158550322`, -0.13925089968748314`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43650$44506}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.7164830129975757`}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-21.23695661792864, \
-11.75131529404604}}],
                    StatusArea[#, 1.232664888175778]& ,
                    TagBoxNote->"1.232664888175778"],
                   StyleBox["1.232664888175778`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.232664888175778, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43653$44506, 
                    FEPrivate`Not[DynamicChart`click$43653$44506]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43653$44506, {{{1., 0}, {
                    0, 1.}}, {-0.19549902917322148`, -0.04219158200788284}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43653$44506}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.2043329564104788`]& ,
                  TagBoxNote->"1.2043329564104788"],
                 StyleBox["1.2043329564104788`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.2043329564104788`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43641$44506, 
                   FEPrivate`Not[DynamicChart`click$43641$44506]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43641$44506, {{{1., 0}, {
                  0, 1.}}, {-0.1957028190359712, 0.041235986969804767`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43641$44506}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.2355647882328675`]& ,
                  TagBoxNote->"5.2355647882328675"],
                 StyleBox["5.2355647882328675`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.2355647882328675`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43644$44506, 
                   FEPrivate`Not[DynamicChart`click$43644$44506]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43644$44506, {{{1., 0}, {
                  0, 1.}}, {-0.04999643655403622, 0.1936500873531903}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43644$44506}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.5453331941895]& ,
                  TagBoxNote->"8.5453331941895"],
                 StyleBox["8.5453331941895`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.5453331941895, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43647$44506, 
                   FEPrivate`Not[DynamicChart`click$43647$44506]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43647$44506, {{{1., 0}, {0, 1.}}, {
                 0.17020588558630925`, -0.10502359978490648`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43647$44506}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.0010791726470583`]& ,
                  TagBoxNote->"2.0010791726470583"],
                 StyleBox["2.0010791726470583`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.0010791726470583`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43650$44506, 
                   FEPrivate`Not[DynamicChart`click$43650$44506]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43650$44506, {{{1., 0}, {
                  0, 1.}}, {-0.14355900158550322`, -0.13925089968748314`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43650$44506}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.232664888175778]& ,
                  TagBoxNote->"1.232664888175778"],
                 StyleBox["1.232664888175778`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.232664888175778, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43653$44506, 
                   FEPrivate`Not[DynamicChart`click$43653$44506]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43653$44506, {{{1., 0}, {
                  0, 1.}}, {-0.19549902917322148`, -0.04219158200788284}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43653$44506}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43692$44507 = False, 
         DynamicChart`click$43695$44507 = False, 
         DynamicChart`click$43698$44507 = False, 
         DynamicChart`click$43701$44507 = False, 
         DynamicChart`click$43704$44507 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.2654490102969054`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-33.63831958338146, \
-18.408529493182453`}}],
                    StatusArea[#, 2.3975475880457395`]& ,
                    TagBoxNote->"2.3975475880457395"],
                   StyleBox["2.3975475880457395`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.3975475880457395`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43692$44507, 
                    FEPrivate`Not[DynamicChart`click$43692$44507]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43692$44507, {{{1., 0}, {
                    0, 1.}}, {-0.1811142536185425, 0.08483883035614213}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43692$44507}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.05410799873832861, 
                    2.2654490102969054`}]},
                    
                    ImageSizeCache->{{8.430372711210929, 
                    37.73327606237312}, {-37.378762173484205`, \
-17.53555480852309}}],
                    StatusArea[#, 6.347416151358111]& ,
                    TagBoxNote->"6.347416151358111"],
                   StyleBox["6.347416151358111`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.347416151358111, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43695$44507, 
                    FEPrivate`Not[DynamicChart`click$43695$44507]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43695$44507, {{{1., 0}, {0, 1.}}, {
                   0.08970705188660408, 0.17875302750391145`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43695$44507}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.1028686505956316`, -0.05410799873832861}]},
                    
                    ImageSizeCache->{{10.573978228692077`, 
                    37.709652842096816`}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 5.606387944426883]& ,
                    TagBoxNote->"5.606387944426883"],
                   StyleBox["5.606387944426883`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.606387944426883, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43698$44507, 
                    FEPrivate`Not[DynamicChart`click$43698$44507]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43698$44507, {{{1., 0}, {0, 1.}}, {
                   0.09453221179931834, -0.1762488607972512}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43698$44507}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.3473778200805757`, -2.1028686505956316`}]},
                    
                    ImageSizeCache->{{7.450138829614987, 
                    21.591470506817554`}, {-21.236956617928644`, \
-4.4982060423394294`}}],
                    StatusArea[#, 0.6690939026281644]& ,
                    TagBoxNote->"0.6690939026281644"],
                   StyleBox["0.6690939026281644`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.6690939026281644, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43701$44507, 
                    FEPrivate`Not[DynamicChart`click$43701$44507]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43701$44507, {{{1., 0}, {
                    0, 1.}}, {-0.1217250623188107, -0.1586915536614399}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43701$44507}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.3473778200805757`}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-21.236956617928644`, \
-6.894360952624432}}],
                    StatusArea[#, 2.1733512227670477`]& ,
                    TagBoxNote->"2.1733512227670477"],
                   StyleBox["2.1733512227670477`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.1733512227670477`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43704$44507, 
                    FEPrivate`Not[DynamicChart`click$43704$44507]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43704$44507, {{{1., 0}, {
                    0, 1.}}, {-0.18443671282621696`, -0.07735049425737098}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43704$44507}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.3975475880457395`]& ,
                  TagBoxNote->"2.3975475880457395"],
                 StyleBox["2.3975475880457395`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.3975475880457395`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43692$44507, 
                   FEPrivate`Not[DynamicChart`click$43692$44507]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43692$44507, {{{1., 0}, {
                  0, 1.}}, {-0.1811142536185425, 0.08483883035614213}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43692$44507}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.347416151358111]& ,
                  TagBoxNote->"6.347416151358111"],
                 StyleBox["6.347416151358111`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.347416151358111, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43695$44507, 
                   FEPrivate`Not[DynamicChart`click$43695$44507]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43695$44507, {{{1., 0}, {0, 1.}}, {
                 0.08970705188660408, 0.17875302750391145`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43695$44507}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.606387944426883]& ,
                  TagBoxNote->"5.606387944426883"],
                 StyleBox["5.606387944426883`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.606387944426883, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43698$44507, 
                   FEPrivate`Not[DynamicChart`click$43698$44507]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43698$44507, {{{1., 0}, {0, 1.}}, {
                 0.09453221179931834, -0.1762488607972512}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43698$44507}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.6690939026281644]& ,
                  TagBoxNote->"0.6690939026281644"],
                 StyleBox["0.6690939026281644`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.6690939026281644, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43701$44507, 
                   FEPrivate`Not[DynamicChart`click$43701$44507]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43701$44507, {{{1., 0}, {
                  0, 1.}}, {-0.1217250623188107, -0.1586915536614399}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43701$44507}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.1733512227670477`]& ,
                  TagBoxNote->"2.1733512227670477"],
                 StyleBox["2.1733512227670477`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.1733512227670477`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43704$44507, 
                   FEPrivate`Not[DynamicChart`click$43704$44507]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43704$44507, {{{1., 0}, {
                  0, 1.}}, {-0.18443671282621696`, -0.07735049425737098}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43704$44507}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -193.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43743$44508 = False, 
         DynamicChart`click$43746$44508 = False, 
         DynamicChart`click$43749$44508 = False, 
         DynamicChart`click$43752$44508 = False, 
         DynamicChart`click$43755$44508 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {1.5281107528957645`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    22.280283520015427`}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 9.91178755946732]& ,
                    TagBoxNote->"9.91178755946732"],
                   StyleBox["9.91178755946732`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.91178755946732, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43743$44508, 
                    FEPrivate`Not[DynamicChart`click$43743$44508]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43743$44508, {{{1., 0}, {
                    0, 1.}}, {-0.13837105098394784`, 
                   0.14440724444984643`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43743$44508}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5909198038807273, 
                    1.5281107528957645`}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    34.9960872478549}, {-37.36405875148672, \
-18.408529493182453`}}],
                    StatusArea[#, 5.75726172403726]& ,
                    TagBoxNote->"5.75726172403726"],
                   StyleBox["5.75726172403726`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.75726172403726, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43746$44508, 
                    FEPrivate`Not[DynamicChart`click$43746$44508]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43746$44508, {{{1., 0}, {0, 1.}}, {
                   0.09785897479358299, 0.17442368260172955`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43746$44508}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.8524192360638874, 
                    0.5909198038807273}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.73327606237311}, {-30.229961489453263`, \
-6.255769893759567}}],
                    StatusArea[#, 8.866582224481647]& ,
                    TagBoxNote->"8.866582224481647"],
                   StyleBox["8.866582224481647`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.866582224481647, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43749$44508, 
                    FEPrivate`Not[DynamicChart`click$43749$44508]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43749$44508, {{{1., 0}, {0, 1.}}, {
                   0.1982928852510955, -0.02607549920511348}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43749$44508}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.302211577174724, -0.8524192360638874}]},
                    
                    ImageSizeCache->{{7.9815509058687315`, 
                    32.21542084141527}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 8.906225526454442]& ,
                    TagBoxNote->"8.906225526454442"],
                   StyleBox["8.906225526454442`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.906225526454442, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43752$44508, 
                    FEPrivate`Not[DynamicChart`click$43752$44508]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43752$44508, {{{1., 0}, {
                    0, 1.}}, {-0.0013038067298856342`, \
-0.19999575017487525`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43752$44508}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.302211577174724}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-21.236956617928644`, \
-6.395315660949617}}],
                    StatusArea[#, 5.1564054776719175`]& ,
                    TagBoxNote->"5.1564054776719175"],
                   StyleBox["5.1564054776719175`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.1564054776719175`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43755$44508, 
                    FEPrivate`Not[DynamicChart`click$43755$44508]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43755$44508, {{{1., 0}, {
                    0, 1.}}, {-0.18264301657385654`, -0.08149557347980298}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43755$44508}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.91178755946732]& ,
                  TagBoxNote->"9.91178755946732"],
                 StyleBox["9.91178755946732`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.91178755946732, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43743$44508, 
                   FEPrivate`Not[DynamicChart`click$43743$44508]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43743$44508, {{{1., 0}, {
                  0, 1.}}, {-0.13837105098394784`, 0.14440724444984643`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43743$44508}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.75726172403726]& ,
                  TagBoxNote->"5.75726172403726"],
                 StyleBox["5.75726172403726`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.75726172403726, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43746$44508, 
                   FEPrivate`Not[DynamicChart`click$43746$44508]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43746$44508, {{{1., 0}, {0, 1.}}, {
                 0.09785897479358299, 0.17442368260172955`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43746$44508}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.866582224481647]& ,
                  TagBoxNote->"8.866582224481647"],
                 StyleBox["8.866582224481647`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.866582224481647, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43749$44508, 
                   FEPrivate`Not[DynamicChart`click$43749$44508]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43749$44508, {{{1., 0}, {0, 1.}}, {
                 0.1982928852510955, -0.02607549920511348}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43749$44508}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.906225526454442]& ,
                  TagBoxNote->"8.906225526454442"],
                 StyleBox["8.906225526454442`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.906225526454442, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43752$44508, 
                   FEPrivate`Not[DynamicChart`click$43752$44508]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43752$44508, {{{1., 0}, {
                  0, 1.}}, {-0.0013038067298856342`, -0.19999575017487525`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43752$44508}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.1564054776719175`]& ,
                  TagBoxNote->"5.1564054776719175"],
                 StyleBox["5.1564054776719175`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.1564054776719175`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43755$44508, 
                   FEPrivate`Not[DynamicChart`click$43755$44508]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43755$44508, {{{1., 0}, {
                  0, 1.}}, {-0.18264301657385654`, -0.08149557347980298}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43755$44508}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43794$44509 = False, 
         DynamicChart`click$43797$44509 = False, 
         DynamicChart`click$43800$44509 = False, 
         DynamicChart`click$43803$44509 = False, 
         DynamicChart`click$43806$44509 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.311777562621331, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    25.725906220758823`}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 9.171883226569115]& ,
                    TagBoxNote->"9.171883226569115"],
                   StyleBox["9.171883226569115`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.171883226569115, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43794$44509, 
                    FEPrivate`Not[DynamicChart`click$43794$44509]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43794$44509, {{{1., 0}, {
                    0, 1.}}, {-0.12197276976326728`, 
                   0.15850124111904296`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43794$44509}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5219516126748158, 
                    1.311777562621331}]},
                    
                    ImageSizeCache->{{18.763043382071334`, 
                    35.58395930286311}, {-36.84030010324135, \
-18.408529493182453`}}],
                    StatusArea[#, 3.958974553209824]& ,
                    TagBoxNote->"3.958974553209824"],
                   StyleBox["3.958974553209824`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.958974553209824, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43797$44509, 
                    FEPrivate`Not[DynamicChart`click$43797$44509]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43797$44509, {{{1., 0}, {0, 1.}}, {
                   0.12166234277074835`, 0.15873964328904402`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43797$44509}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.8022043316777223, 
                    0.5219516126748158}]},
                    
                    ImageSizeCache->{{18.763043382071334`, 
                    37.733276062373065`}, {-29.284822414890133`, \
-6.804344968704687}}],
                    StatusArea[#, 6.637284693581183]& ,
                    TagBoxNote->"6.637284693581183"],
                   StyleBox["6.637284693581183`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.637284693581183, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43800$44509, 
                    FEPrivate`Not[DynamicChart`click$43800$44509]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43800$44509, {{{1., 0}, {0, 1.}}, {
                   0.1980396711418068, -0.027933647345898562`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43800$44509}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.2699109119904666`, -0.8022043316777223}]},
                    
                    ImageSizeCache->{{8.37514208655612, 
                    32.81202254828298}, {-21.23695661792864, \
-2.2667239376269066`}}],
                    StatusArea[#, 7.3568271635418405`]& ,
                    TagBoxNote->"7.3568271635418405"],
                   StyleBox["7.3568271635418405`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.3568271635418405`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43803$44509, 
                    FEPrivate`Not[DynamicChart`click$43803$44509]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43803$44509, {{{1., 0}, {0, 1.}}, {
                   0.006946343680082807, -0.1998793343732117}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43803$44509}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.2699109119904666`}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.591470506817522`}, {-21.236956617928644`, \
-6.053393181996032}}],
                    StatusArea[#, 4.369273804846561]& ,
                    TagBoxNote->"4.369273804846561"],
                   StyleBox["4.369273804846561`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.369273804846561, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43806$44509, 
                    FEPrivate`Not[DynamicChart`click$43806$44509]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43806$44509, {{{1., 0}, {
                    0, 1.}}, {-0.18130307400649712`, -0.08443456256649072}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43806$44509}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.171883226569115]& ,
                  TagBoxNote->"9.171883226569115"],
                 StyleBox["9.171883226569115`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.171883226569115, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43794$44509, 
                   FEPrivate`Not[DynamicChart`click$43794$44509]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43794$44509, {{{1., 0}, {
                  0, 1.}}, {-0.12197276976326728`, 0.15850124111904296`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43794$44509}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.958974553209824]& ,
                  TagBoxNote->"3.958974553209824"],
                 StyleBox["3.958974553209824`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.958974553209824, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43797$44509, 
                   FEPrivate`Not[DynamicChart`click$43797$44509]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43797$44509, {{{1., 0}, {0, 1.}}, {
                 0.12166234277074835`, 0.15873964328904402`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43797$44509}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.637284693581183]& ,
                  TagBoxNote->"6.637284693581183"],
                 StyleBox["6.637284693581183`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.637284693581183, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43800$44509, 
                   FEPrivate`Not[DynamicChart`click$43800$44509]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43800$44509, {{{1., 0}, {0, 1.}}, {
                 0.1980396711418068, -0.027933647345898562`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43800$44509}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.3568271635418405`]& ,
                  TagBoxNote->"7.3568271635418405"],
                 StyleBox["7.3568271635418405`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.3568271635418405`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43803$44509, 
                   FEPrivate`Not[DynamicChart`click$43803$44509]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43803$44509, {{{1., 0}, {0, 1.}}, {
                 0.006946343680082807, -0.1998793343732117}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43803$44509}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.369273804846561]& ,
                  TagBoxNote->"4.369273804846561"],
                 StyleBox["4.369273804846561`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.369273804846561, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43806$44509, 
                   FEPrivate`Not[DynamicChart`click$43806$44509]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43806$44509, {{{1., 0}, {
                  0, 1.}}, {-0.18130307400649712`, -0.08443456256649072}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43806$44509}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43845$44510 = False, 
         DynamicChart`click$43848$44510 = False, 
         DynamicChart`click$43851$44510 = False, 
         DynamicChart`click$43854$44510 = False, 
         DynamicChart`click$43857$44510 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.394698721053862, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    24.41933524644903}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 8.238093709303172]& ,
                    TagBoxNote->"8.238093709303172"],
                   StyleBox["8.238093709303172`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.238093709303172, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43845$44510, 
                    FEPrivate`Not[DynamicChart`click$43845$44510]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43845$44510, {{{1., 0}, {
                    0, 1.}}, {-0.12843762112390125`, 
                   0.15330941745383156`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43845$44510}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8559113950106427, 
                    1.394698721053862}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    32.17291677911535}, {-37.12912662732991, \
-18.408529493182453`}}],
                    StatusArea[#, 2.540841432132929]& ,
                    TagBoxNote->"2.540841432132929"],
                   StyleBox["2.540841432132929`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.540841432132929, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43848$44510, 
                    FEPrivate`Not[DynamicChart`click$43848$44510]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43848$44510, {{{1., 0}, {0, 1.}}, {
                   0.08618025055267686, 0.1804798171948261}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43848$44510}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.6994898320099319, 
                    0.8559113950106427}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    37.733276062373065`}, {-33.426742562720236`, \
-8.01599270359533}}],
                    StatusArea[#, 7.335042400175645]& ,
                    TagBoxNote->"7.335042400175645"],
                   StyleBox["7.335042400175645`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.335042400175645, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43851$44510, 
                    FEPrivate`Not[DynamicChart`click$43851$44510]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43851$44510, {{{1., 0}, {0, 1.}}, {
                   0.19938861910870642`, 0.01562621419036591}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43851$44510}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.5256811190759887`, -0.6994898320099319}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    33.94270792136196}, {-21.236956617928644`, \
-2.2831485214603795`}}],
                    StatusArea[#, 3.896196052830458]& ,
                    TagBoxNote->"3.896196052830458"],
                   StyleBox["3.896196052830458`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.896196052830458, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43854$44510, 
                    FEPrivate`Not[DynamicChart`click$43854$44510]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43854$44510, {{{1., 0}, {0, 1.}}, {
                   0.08846884521322089, -0.17936907042921077`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43854$44510}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.5256811190759887`}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    22.319464401151684`}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 7.620400070852501]& ,
                    TagBoxNote->"7.620400070852501"],
                   StyleBox["7.620400070852501`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.620400070852501, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43857$44510, 
                    FEPrivate`Not[DynamicChart`click$43857$44510]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43857$44510, {{{1., 0}, {
                    0, 1.}}, {-0.13819552056201798`, -0.14457523334441788`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43857$44510}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.238093709303172]& ,
                  TagBoxNote->"8.238093709303172"],
                 StyleBox["8.238093709303172`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.238093709303172, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43845$44510, 
                   FEPrivate`Not[DynamicChart`click$43845$44510]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43845$44510, {{{1., 0}, {
                  0, 1.}}, {-0.12843762112390125`, 0.15330941745383156`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43845$44510}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.540841432132929]& ,
                  TagBoxNote->"2.540841432132929"],
                 StyleBox["2.540841432132929`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.540841432132929, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43848$44510, 
                   FEPrivate`Not[DynamicChart`click$43848$44510]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43848$44510, {{{1., 0}, {0, 1.}}, {
                 0.08618025055267686, 0.1804798171948261}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43848$44510}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.335042400175645]& ,
                  TagBoxNote->"7.335042400175645"],
                 StyleBox["7.335042400175645`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.335042400175645, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43851$44510, 
                   FEPrivate`Not[DynamicChart`click$43851$44510]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43851$44510, {{{1., 0}, {0, 1.}}, {
                 0.19938861910870642`, 0.01562621419036591}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43851$44510}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.896196052830458]& ,
                  TagBoxNote->"3.896196052830458"],
                 StyleBox["3.896196052830458`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.896196052830458, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43854$44510, 
                   FEPrivate`Not[DynamicChart`click$43854$44510]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43854$44510, {{{1., 0}, {0, 1.}}, {
                 0.08846884521322089, -0.17936907042921077`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43854$44510}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.620400070852501]& ,
                  TagBoxNote->"7.620400070852501"],
                 StyleBox["7.620400070852501`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.620400070852501, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43857$44510, 
                   FEPrivate`Not[DynamicChart`click$43857$44510]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43857$44510, {{{1., 0}, {
                  0, 1.}}, {-0.13819552056201798`, -0.14457523334441788`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43857$44510}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43896$44511 = False, 
         DynamicChart`click$43899$44511 = False, 
         DynamicChart`click$43902$44511 = False, 
         DynamicChart`click$43905$44511 = False, 
         DynamicChart`click$43908$44511 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.9244713376719746`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.59147050681753}, {-36.37968479667188, \
-18.408529493182453`}}],
                    StatusArea[#, 4.953784148091193]& ,
                    TagBoxNote->"4.953784148091193"],
                   StyleBox["4.953784148091193`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.953784148091193, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43896$44511, 
                    FEPrivate`Not[DynamicChart`click$43896$44511]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43896$44511, {{{1., 0}, {
                    0, 1.}}, {-0.16409434414911173`, 
                   0.11433742265012309`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43896$44511}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.433372601671298, 
                    1.9244713376719746`}]},
                    
                    ImageSizeCache->{{13.172366330223365`, 
                    36.24104109631877}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 6.068894846417855]& ,
                    TagBoxNote->"6.068894846417855"],
                   StyleBox["6.068894846417855`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.068894846417855, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43899$44511, 
                    FEPrivate`Not[DynamicChart`click$43899$44511]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43899$44511, {{{1., 0}, {0, 1.}}, {
                   0.0763842712302456, 0.18483896534179226`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43899$44511}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.675743460835442, 
                    0.433372601671298}]},
                    
                    ImageSizeCache->{{18.76304338207134, 
                    37.73327606237308}, {-28.015449675871864`, \
-8.312192194774916}}],
                    StatusArea[#, 4.514193858067468]& ,
                    TagBoxNote->"4.514193858067468"],
                   StyleBox["4.514193858067468`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.514193858067468, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43902$44511, 
                    FEPrivate`Not[DynamicChart`click$43902$44511]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43902$44511, {{{1., 0}, {0, 1.}}, {
                   0.19853320558529802`, -0.024177805525435827`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43902$44511}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.98802952704224, -0.675743460835442}]},
                    
                    ImageSizeCache->{{2.81118917972808, 
                    34.18598755790565}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 9.411195014680693]& ,
                    TagBoxNote->"9.411195014680693"],
                   StyleBox["9.411195014680693`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.411195014680693, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43905$44511, 
                    FEPrivate`Not[DynamicChart`click$43905$44511]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43905$44511, {{{1., 0}, {
                    0, 1.}}, {-0.05162678510406954, -0.19322182863180398`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43905$44511}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.98802952704224}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.59147050681753}, {-21.23695661792864, \
-15.939474187899123`}}],
                    StatusArea[#, 0.6250145914574983]& ,
                    TagBoxNote->"0.6250145914574983"],
                   StyleBox["0.6250145914574983`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.6250145914574983, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43908$44511, 
                    FEPrivate`Not[DynamicChart`click$43908$44511]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43908$44511, {{{1., 0}, {
                    0, 1.}}, {-0.19941074872922035`, \
-0.015341228479224018`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43908$44511}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.953784148091193]& ,
                  TagBoxNote->"4.953784148091193"],
                 StyleBox["4.953784148091193`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.953784148091193, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43896$44511, 
                   FEPrivate`Not[DynamicChart`click$43896$44511]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43896$44511, {{{1., 0}, {
                  0, 1.}}, {-0.16409434414911173`, 0.11433742265012309`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43896$44511}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.068894846417855]& ,
                  TagBoxNote->"6.068894846417855"],
                 StyleBox["6.068894846417855`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.068894846417855, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43899$44511, 
                   FEPrivate`Not[DynamicChart`click$43899$44511]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43899$44511, {{{1., 0}, {0, 1.}}, {
                 0.0763842712302456, 0.18483896534179226`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43899$44511}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.514193858067468]& ,
                  TagBoxNote->"4.514193858067468"],
                 StyleBox["4.514193858067468`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.514193858067468, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43902$44511, 
                   FEPrivate`Not[DynamicChart`click$43902$44511]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43902$44511, {{{1., 0}, {0, 1.}}, {
                 0.19853320558529802`, -0.024177805525435827`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43902$44511}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.411195014680693]& ,
                  TagBoxNote->"9.411195014680693"],
                 StyleBox["9.411195014680693`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.411195014680693, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43905$44511, 
                   FEPrivate`Not[DynamicChart`click$43905$44511]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43905$44511, {{{1., 0}, {
                  0, 1.}}, {-0.05162678510406954, -0.19322182863180398`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43905$44511}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.6250145914574983]& ,
                  TagBoxNote->"0.6250145914574983"],
                 StyleBox["0.6250145914574983`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.6250145914574983, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43908$44511, 
                   FEPrivate`Not[DynamicChart`click$43908$44511]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43908$44511, {{{1., 0}, {
                  0, 1.}}, {-0.19941074872922035`, -0.015341228479224018`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43908$44511}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43947$44512 = False, 
         DynamicChart`click$43950$44512 = False, 
         DynamicChart`click$43953$44512 = False, 
         DynamicChart`click$43956$44512 = False, 
         DynamicChart`click$43959$44512 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.129262605512736, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-21.435980813445454`, \
-18.408529493182453`}}],
                    StatusArea[#, 0.02257390939212023]& ,
                    TagBoxNote->"0.02257390939212023"],
                   StyleBox["0.02257390939212023`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.02257390939212023, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43947$44512, 
                    FEPrivate`Not[DynamicChart`click$43947$44512]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43947$44512, {{{1., 0}, {
                    0, 1.}}, {-0.19999619925989853`, 
                   0.001232996997144506}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43947$44512}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0693398612011937`, 
                    3.129262605512736}]},
                    
                    ImageSizeCache->{{2.622464831010575, 
                    21.591470506817537`}, {-22.402232645014593`, \
-18.408529493182453`}}],
                    StatusArea[#, 0.10970683911062196`]& ,
                    TagBoxNote->"0.10970683911062196"],
                   StyleBox["0.10970683911062196`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.10970683911062196`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43950$44512, 
                    FEPrivate`Not[DynamicChart`click$43950$44512]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43950$44512, {{{1., 0}, {
                    0, 1.}}, {-0.19982117023389634`, 
                   0.008455762907994933}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43950$44512}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.876349811966941, 
                    3.0693398612011937`}]},
                    
                    ImageSizeCache->{{2.663353373438788, 
                    21.591470506817537`}, {-36.63108340349041, \
-18.408529493182453`}}],
                    StatusArea[#, 2.1841317332107817`]& ,
                    TagBoxNote->"2.1841317332107817"],
                   StyleBox["2.1841317332107817`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.1841317332107817`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43953$44512, 
                    FEPrivate`Not[DynamicChart`click$43953$44512]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43953$44512, {{{1., 0}, {
                    0, 1.}}, {-0.15691972785379651`, 
                   0.12400080245825203`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$43953$44512}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.701236562028452, 
                    1.876349811966941}]},
                    
                    ImageSizeCache->{{13.907248173929425`, 
                    37.73327606237311}, {-37.378762173484205`, \
-2.266723937626896}}],
                    StatusArea[#, 6.549861780290097]& ,
                    TagBoxNote->"6.549861780290097"],
                   StyleBox["6.549861780290097`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.549861780290097, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43956$44512, 
                    FEPrivate`Not[DynamicChart`click$43956$44512]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43956$44512, {{{1., 0}, {0, 1.}}, {
                   0.1992338733676718, 0.017488959457741517`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43956$44512}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.701236562028452}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-21.23695661792864, \
-2.403852964556613}}],
                    StatusArea[#, 2.6370106345160753`]& ,
                    TagBoxNote->"2.6370106345160753"],
                   StyleBox["2.6370106345160753`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.6370106345160753`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43959$44512, 
                    FEPrivate`Not[DynamicChart`click$43959$44512]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43959$44512, {{{1., 0}, {
                    0, 1.}}, {-0.15033766331331966`, -0.1319037034714755}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$43959$44512}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.02257390939212023]& ,
                  TagBoxNote->"0.02257390939212023"],
                 StyleBox["0.02257390939212023`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.02257390939212023, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43947$44512, 
                   FEPrivate`Not[DynamicChart`click$43947$44512]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43947$44512, {{{1., 0}, {
                  0, 1.}}, {-0.19999619925989853`, 0.001232996997144506}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43947$44512}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.10970683911062196`]& ,
                  TagBoxNote->"0.10970683911062196"],
                 StyleBox["0.10970683911062196`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.10970683911062196`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43950$44512, 
                   FEPrivate`Not[DynamicChart`click$43950$44512]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43950$44512, {{{1., 0}, {
                  0, 1.}}, {-0.19982117023389634`, 0.008455762907994933}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43950$44512}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.1841317332107817`]& ,
                  TagBoxNote->"2.1841317332107817"],
                 StyleBox["2.1841317332107817`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.1841317332107817`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43953$44512, 
                   FEPrivate`Not[DynamicChart`click$43953$44512]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43953$44512, {{{1., 0}, {
                  0, 1.}}, {-0.15691972785379651`, 0.12400080245825203`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43953$44512}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.549861780290097]& ,
                  TagBoxNote->"6.549861780290097"],
                 StyleBox["6.549861780290097`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.549861780290097, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43956$44512, 
                   FEPrivate`Not[DynamicChart`click$43956$44512]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43956$44512, {{{1., 0}, {0, 1.}}, {
                 0.1992338733676718, 0.017488959457741517`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43956$44512}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.6370106345160753`]& ,
                  TagBoxNote->"2.6370106345160753"],
                 StyleBox["2.6370106345160753`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.6370106345160753`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43959$44512, 
                   FEPrivate`Not[DynamicChart`click$43959$44512]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43959$44512, {{{1., 0}, {
                  0, 1.}}, {-0.15033766331331966`, -0.1319037034714755}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$43959$44512}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$43998$44513 = False, 
         DynamicChart`click$44001$44513 = False, 
         DynamicChart`click$44004$44513 = False, 
         DynamicChart`click$44007$44513 = False, 
         DynamicChart`click$44010$44513 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.1234646275258884`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-34.97567996033784, \
-18.408529493182453`}}],
                    StatusArea[#, 5.162419375453982]& ,
                    TagBoxNote->"5.162419375453982"],
                   StyleBox["5.162419375453982`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.162419375453982, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$43998$44513, 
                    FEPrivate`Not[DynamicChart`click$43998$44513]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$43998$44513, {{{1., 0}, {
                    0, 1.}}, {-0.17464021056538032`, 0.09747203113549872}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$43998$44513}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.35554497273636976`, 
                    2.1234646275258884`}]},
                    
                    ImageSizeCache->{{10.289238598262337`, 
                    36.7237178635836}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 8.964238726847963]& ,
                    TagBoxNote->"8.964238726847963"],
                   StyleBox["8.964238726847963`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.964238726847963, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44001$44513, 
                    FEPrivate`Not[DynamicChart`click$44001$44513]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44001$44513, {{{1., 0}, {0, 1.}}, {
                   0.06505291934167957, 0.18912460888293975`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44001$44513}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.3152778220355001`, 
                    0.35554497273636976`}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.73327606237311}, {-26.855940202796244`, \
-2.790810024439107}}],
                    StatusArea[#, 8.471908981846529]& ,
                    TagBoxNote->"8.471908981846529"],
                   StyleBox["8.471908981846529`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.471908981846529, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44004$44513, 
                    FEPrivate`Not[DynamicChart`click$44004$44513]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44004$44513, {{{1., 0}, {0, 1.}}, {
                   0.1774113194362499, -0.09233213815291454}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44004$44513}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.4409423213778263`, -1.3152778220355001`}]},
                    
                    ImageSizeCache->{{6.423874822943544, 
                    25.67126525520861}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 5.707683191996509]& ,
                    TagBoxNote->"5.707683191996509"],
                   StyleBox["5.707683191996509`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.707683191996509, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44007$44513, 
                    FEPrivate`Not[DynamicChart`click$44007$44513]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44007$44513, {{{1., 0}, {
                    0, 1.}}, {-0.06049986559530575, -0.19062991964261522`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44007$44513}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.4409423213778263`}]},
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-21.236956617928644`, \
-8.001666091427065}}],
                    StatusArea[#, 3.5526483485705533`]& ,
                    TagBoxNote->"3.5526483485705533"],
                   StyleBox["3.5526483485705533`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.5526483485705533`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44010$44513, 
                    FEPrivate`Not[DynamicChart`click$44010$44513]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44010$44513, {{{1., 0}, {
                    0, 1.}}, {-0.18785223288863956`, -0.06864064829787324}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44010$44513}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.162419375453982]& ,
                  TagBoxNote->"5.162419375453982"],
                 StyleBox["5.162419375453982`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.162419375453982, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$43998$44513, 
                   FEPrivate`Not[DynamicChart`click$43998$44513]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$43998$44513, {{{1., 0}, {
                  0, 1.}}, {-0.17464021056538032`, 0.09747203113549872}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$43998$44513}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.964238726847963]& ,
                  TagBoxNote->"8.964238726847963"],
                 StyleBox["8.964238726847963`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.964238726847963, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44001$44513, 
                   FEPrivate`Not[DynamicChart`click$44001$44513]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44001$44513, {{{1., 0}, {0, 1.}}, {
                 0.06505291934167957, 0.18912460888293975`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44001$44513}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.471908981846529]& ,
                  TagBoxNote->"8.471908981846529"],
                 StyleBox["8.471908981846529`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.471908981846529, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44004$44513, 
                   FEPrivate`Not[DynamicChart`click$44004$44513]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44004$44513, {{{1., 0}, {0, 1.}}, {
                 0.1774113194362499, -0.09233213815291454}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44004$44513}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.707683191996509]& ,
                  TagBoxNote->"5.707683191996509"],
                 StyleBox["5.707683191996509`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.707683191996509, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44007$44513, 
                   FEPrivate`Not[DynamicChart`click$44007$44513]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44007$44513, {{{1., 0}, {
                  0, 1.}}, {-0.06049986559530575, -0.19062991964261522`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44007$44513}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.5526483485705533`]& ,
                  TagBoxNote->"3.5526483485705533"],
                 StyleBox["3.5526483485705533`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.5526483485705533`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44010$44513, 
                   FEPrivate`Not[DynamicChart`click$44010$44513]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44010$44513, {{{1., 0}, {
                  0, 1.}}, {-0.18785223288863956`, -0.06864064829787324}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44010$44513}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -580.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44049$44514 = False, 
         DynamicChart`click$44052$44514 = False, 
         DynamicChart`click$44055$44514 = False, 
         DynamicChart`click$44058$44514 = False, 
         DynamicChart`click$44061$44514 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5082636469767714`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    22.600203151333094`}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 8.705862084837523]& ,
                    TagBoxNote->"8.705862084837523"],
                   StyleBox["8.705862084837523`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.705862084837523, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44049$44514, 
                    FEPrivate`Not[DynamicChart`click$44049$44514]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44049$44514, {{{1., 0}, {
                    0, 1.}}, {-0.13693122844551184`, 0.1457732440347098}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44049$44514}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.06329201818878571, 
                    1.5082636469767714`}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.73327606237311}, {-37.34721251425918, \
-17.38756400519423}}],
                    StatusArea[#, 8.376601911912289]& ,
                    TagBoxNote->"8.376601911912289"],
                   StyleBox["8.376601911912289`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.376601911912289, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44052$44514, 
                    FEPrivate`Not[DynamicChart`click$44052$44514]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44052$44514, {{{1., 0}, {0, 1.}}, {
                   0.1500328600229822, 0.13225029645836048`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44052$44514}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.21699932472175032`, -0.06329201818878571}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.70095578927463}, {-21.23695661792864, \
-14.933194017024569`}}],
                    StatusArea[#, 0.8192805042278177]& ,
                    TagBoxNote->"0.8192805042278177"],
                   StyleBox["0.8192805042278177`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.8192805042278177, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44055$44514, 
                    FEPrivate`Not[DynamicChart`click$44055$44514]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44055$44514, {{{1., 0}, {0, 1.}}, {
                   0.1980391316515698, -0.02793747187367196}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44055$44514}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.582033666814505, -0.21699932472175032`}]},
                    
                    ImageSizeCache->{{18.58165624209791, 
                    37.354716680164046`}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 7.2758156349463725`]& ,
                    TagBoxNote->"7.2758156349463725"],
                   StyleBox["7.2758156349463725`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.2758156349463725`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44058$44514, 
                    FEPrivate`Not[DynamicChart`click$44058$44514]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44058$44514, {{{1., 0}, {0, 1.}}, {
                   0.12439772749456023`, -0.15660525340546255`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44058$44514}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.582033666814505}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-21.23695661792864, \
-2.267743102835283}}],
                    StatusArea[#, 8.312658011376037]& ,
                    TagBoxNote->"8.312658011376037"],
                   StyleBox["8.312658011376037`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.312658011376037, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44061$44514, 
                    FEPrivate`Not[DynamicChart`click$44061$44514]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44061$44514, {{{1., 0}, {
                    0, 1.}}, {-0.14221371969797092`, -0.14062452819357993`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44061$44514}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.705862084837523]& ,
                  TagBoxNote->"8.705862084837523"],
                 StyleBox["8.705862084837523`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.705862084837523, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44049$44514, 
                   FEPrivate`Not[DynamicChart`click$44049$44514]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44049$44514, {{{1., 0}, {
                  0, 1.}}, {-0.13693122844551184`, 0.1457732440347098}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44049$44514}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.376601911912289]& ,
                  TagBoxNote->"8.376601911912289"],
                 StyleBox["8.376601911912289`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.376601911912289, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44052$44514, 
                   FEPrivate`Not[DynamicChart`click$44052$44514]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44052$44514, {{{1., 0}, {0, 1.}}, {
                 0.1500328600229822, 0.13225029645836048`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44052$44514}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.8192805042278177]& ,
                  TagBoxNote->"0.8192805042278177"],
                 StyleBox["0.8192805042278177`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.8192805042278177, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44055$44514, 
                   FEPrivate`Not[DynamicChart`click$44055$44514]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44055$44514, {{{1., 0}, {0, 1.}}, {
                 0.1980391316515698, -0.02793747187367196}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44055$44514}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.2758156349463725`]& ,
                  TagBoxNote->"7.2758156349463725"],
                 StyleBox["7.2758156349463725`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.2758156349463725`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44058$44514, 
                   FEPrivate`Not[DynamicChart`click$44058$44514]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44058$44514, {{{1., 0}, {0, 1.}}, {
                 0.12439772749456023`, -0.15660525340546255`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44058$44514}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.312658011376037]& ,
                  TagBoxNote->"8.312658011376037"],
                 StyleBox["8.312658011376037`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.312658011376037, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44061$44514, 
                   FEPrivate`Not[DynamicChart`click$44061$44514]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44061$44514, {{{1., 0}, {
                  0, 1.}}, {-0.14221371969797092`, -0.14062452819357993`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44061$44514}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44100$44515 = False, 
         DynamicChart`click$44103$44515 = False, 
         DynamicChart`click$44106$44515 = False, 
         DynamicChart`click$44109$44515 = False, 
         DynamicChart`click$44112$44515 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.272589612502162, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    26.334038564693216`}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 9.193265490005494]& ,
                    TagBoxNote->"9.193265490005494"],
                   StyleBox["9.193265490005494`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.193265490005494, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44100$44515, 
                    FEPrivate`Not[DynamicChart`click$44100$44515]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44100$44515, {{{1., 0}, {
                    0, 1.}}, {-0.11884388573836656`, 0.1608605943747756}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44100$44515}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.018561286928358012`, 
                    1.272589612502162}]},
                    
                    ImageSizeCache->{{18.763043382071334`, 
                    37.733276062373065`}, {-36.66634204994702, \
-18.108934012256547`}}],
                    StatusArea[#, 6.350922253832554]& ,
                    TagBoxNote->"6.350922253832554"],
                   StyleBox["6.350922253832554`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.350922253832554, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44103$44515, 
                    FEPrivate`Not[DynamicChart`click$44103$44515]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44103$44515, {{{1., 0}, {0, 1.}}, {
                   0.16195659883403038`, 0.11734589934937203`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44103$44515}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.6353638623758453`, -0.018561286928358012`}]},
                    
                    ImageSizeCache->{{17.721530801525304`, 
                    37.73049554370165}, {-21.23695661792864, \
-2.2667239376269066`}}],
                    StatusArea[#, 7.9527400406816575`]& ,
                    TagBoxNote->"7.9527400406816575"],
                   StyleBox["7.9527400406816575`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.9527400406816575`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44106$44515, 
                    FEPrivate`Not[DynamicChart`click$44106$44515]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44106$44515, {{{1., 0}, {0, 1.}}, {
                   0.13542281097856396`, -0.14717561709286}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44106$44515}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.3768010353343616`, -1.6353638623758453`}]},
                    
                    ImageSizeCache->{{7.116300432615644, 
                    21.591470506817526`}, {-21.23695661792864, \
-2.3003595742274072`}}],
                    StatusArea[#, 3.6469864549820024`]& ,
                    TagBoxNote->"3.6469864549820024"],
                   StyleBox["3.6469864549820024`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.6469864549820024`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44109$44515, 
                    FEPrivate`Not[DynamicChart`click$44109$44515]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44109$44515, {{{1., 0}, {
                    0, 1.}}, {-0.0843339719276787, -0.18134988607358293`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44109$44515}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.3768010353343616`}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.591470506817522`}, {-21.236956617928644`, \
-7.2321586482852585`}}],
                    StatusArea[#, 3.7618624670945415`]& ,
                    TagBoxNote->"3.7618624670945415"],
                   StyleBox["3.7618624670945415`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.7618624670945415`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44112$44515, 
                    FEPrivate`Not[DynamicChart`click$44112$44515]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44112$44515, {{{1., 0}, {
                    0, 1.}}, {-0.18555466331198606`, -0.0746288611944166}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44112$44515}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.193265490005494]& ,
                  TagBoxNote->"9.193265490005494"],
                 StyleBox["9.193265490005494`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.193265490005494, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44100$44515, 
                   FEPrivate`Not[DynamicChart`click$44100$44515]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44100$44515, {{{1., 0}, {
                  0, 1.}}, {-0.11884388573836656`, 0.1608605943747756}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44100$44515}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.350922253832554]& ,
                  TagBoxNote->"6.350922253832554"],
                 StyleBox["6.350922253832554`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.350922253832554, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44103$44515, 
                   FEPrivate`Not[DynamicChart`click$44103$44515]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44103$44515, {{{1., 0}, {0, 1.}}, {
                 0.16195659883403038`, 0.11734589934937203`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44103$44515}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.9527400406816575`]& ,
                  TagBoxNote->"7.9527400406816575"],
                 StyleBox["7.9527400406816575`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.9527400406816575`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44106$44515, 
                   FEPrivate`Not[DynamicChart`click$44106$44515]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44106$44515, {{{1., 0}, {0, 1.}}, {
                 0.13542281097856396`, -0.14717561709286}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44106$44515}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.6469864549820024`]& ,
                  TagBoxNote->"3.6469864549820024"],
                 StyleBox["3.6469864549820024`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.6469864549820024`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44109$44515, 
                   FEPrivate`Not[DynamicChart`click$44109$44515]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44109$44515, {{{1., 0}, {
                  0, 1.}}, {-0.0843339719276787, -0.18134988607358293`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44109$44515}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.7618624670945415`]& ,
                  TagBoxNote->"3.7618624670945415"],
                 StyleBox["3.7618624670945415`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.7618624670945415`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44112$44515, 
                   FEPrivate`Not[DynamicChart`click$44112$44515]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44112$44515, {{{1., 0}, {
                  0, 1.}}, {-0.18555466331198606`, -0.0746288611944166}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44112$44515}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44151$44516 = False, 
         DynamicChart`click$44154$44516 = False, 
         DynamicChart`click$44157$44516 = False, 
         DynamicChart`click$44160$44516 = False, 
         DynamicChart`click$44163$44516 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {2.102691543337426, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    21.591470506817515`}, {-35.148730193478244`, \
-18.408529493182453`}}],
                    StatusArea[#, 5.573964864566872]& ,
                    TagBoxNote->"5.573964864566872"],
                   StyleBox["5.573964864566872`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.573964864566872, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44151$44516, 
                    FEPrivate`Not[DynamicChart`click$44151$44516]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44151$44516, {{{1., 0}, {
                    0, 1.}}, {-0.1736184113831467, 0.09928064881331324}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44151$44516}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.36186924581006963`, 
                    2.102691543337426}]},
                    
                    ImageSizeCache->{{10.576441976359423`, 
                    36.68787949695441}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 9.33994797590982]& ,
                    TagBoxNote->"9.33994797590982"],
                   StyleBox["9.33994797590982`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.33994797590982, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44154$44516, 
                    FEPrivate`Not[DynamicChart`click$44154$44516]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44154$44516, {{{1., 0}, {0, 1.}}, {
                   0.06641752271729426, 0.1886497089213172}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44154$44516}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.6730203108074111, 
                    0.36186924581006963`}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    37.733276062373065`}, {-26.95152766008729, \
-8.34652634675152}}],
                    StatusArea[#, 5.552441873790826]& ,
                    TagBoxNote->"5.552441873790826"],
                   StyleBox["5.552441873790826`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.552441873790826, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44157$44516, 
                    FEPrivate`Not[DynamicChart`click$44157$44516]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44157$44516, {{{1., 0}, {0, 1.}}, {
                   0.19758450327630944`, -0.03098974128730457}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44157$44516}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4027329913542692`, -0.6730203108074111}]},
                    
                    ImageSizeCache->{{18.763043382071327`, 
                    34.21343466754061}, {-21.23695661792864, \
-2.4941528115639144`}}],
                    StatusArea[#, 3.915091438884934]& ,
                    TagBoxNote->"3.915091438884934"],
                   StyleBox["3.915091438884934`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.915091438884934, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44160$44516, 
                    FEPrivate`Not[DynamicChart`click$44160$44516]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44160$44516, {{{1., 0}, {0, 1.}}, {
                   0.10161005995319394`, -0.17226548033865732`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44160$44516}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4027329913542692`}]},
                    
                    ImageSizeCache->{{2.621237826515774, 
                    24.29156336242827}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 9.329417945620435]& ,
                    TagBoxNote->"9.329417945620435"],
                   StyleBox["9.329417945620435`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.329417945620435, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44163$44516, 
                    FEPrivate`Not[DynamicChart`click$44163$44516]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44163$44516, {{{1., 0}, {
                    0, 1.}}, {-0.12905244779558459`, -0.15279223055498573`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44163$44516}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.573964864566872]& ,
                  TagBoxNote->"5.573964864566872"],
                 StyleBox["5.573964864566872`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.573964864566872, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44151$44516, 
                   FEPrivate`Not[DynamicChart`click$44151$44516]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44151$44516, {{{1., 0}, {
                  0, 1.}}, {-0.1736184113831467, 0.09928064881331324}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44151$44516}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.33994797590982]& ,
                  TagBoxNote->"9.33994797590982"],
                 StyleBox["9.33994797590982`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.33994797590982, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44154$44516, 
                   FEPrivate`Not[DynamicChart`click$44154$44516]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44154$44516, {{{1., 0}, {0, 1.}}, {
                 0.06641752271729426, 0.1886497089213172}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44154$44516}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.552441873790826]& ,
                  TagBoxNote->"5.552441873790826"],
                 StyleBox["5.552441873790826`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.552441873790826, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44157$44516, 
                   FEPrivate`Not[DynamicChart`click$44157$44516]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44157$44516, {{{1., 0}, {0, 1.}}, {
                 0.19758450327630944`, -0.03098974128730457}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44157$44516}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.915091438884934]& ,
                  TagBoxNote->"3.915091438884934"],
                 StyleBox["3.915091438884934`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.915091438884934, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44160$44516, 
                   FEPrivate`Not[DynamicChart`click$44160$44516]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44160$44516, {{{1., 0}, {0, 1.}}, {
                 0.10161005995319394`, -0.17226548033865732`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44160$44516}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.329417945620435]& ,
                  TagBoxNote->"9.329417945620435"],
                 StyleBox["9.329417945620435`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.329417945620435, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44163$44516, 
                   FEPrivate`Not[DynamicChart`click$44163$44516]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44163$44516, {{{1., 0}, {
                  0, 1.}}, {-0.12905244779558459`, -0.15279223055498573`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44163$44516}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44202$44517 = False, 
         DynamicChart`click$44205$44517 = False, 
         DynamicChart`click$44208$44517 = False, 
         DynamicChart`click$44211$44517 = False, 
         DynamicChart`click$44214$44517 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.4463498050187886`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.59147050681753}, {-31.57694434018665, \
-18.408529493182453`}}],
                    StatusArea[#, 2.1342847119106843`]& ,
                    TagBoxNote->"2.1342847119106843"],
                   StyleBox["2.1342847119106843`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.1342847119106843`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44202$44517, 
                    FEPrivate`Not[DynamicChart`click$44202$44517]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44202$44517, {{{1., 0}, {
                    0, 1.}}, {-0.18803713263377353`, 0.06813249408959471}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44202$44517}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.287390458506314, 
                    2.4463498050187886`}]},
                    
                    ImageSizeCache->{{6.367780557229029, 
                    21.591470506817533`}, {-33.408638958929245`, \
-18.408529493182453`}}],
                    StatusArea[#, 0.48797985304589275`]& ,
                    TagBoxNote->"0.48797985304589275"],
                   StyleBox["0.48797985304589275`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.48797985304589275`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44205$44517, 
                    FEPrivate`Not[DynamicChart`click$44205$44517]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44205$44517, {{{1., 0}, {
                    0, 1.}}, {-0.14292303249767233`, 
                   0.13990356243380403`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$44205$44517}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5168709895050507, 
                    2.287390458506314}]},
                    
                    ImageSizeCache->{{8.16077779479528, 
                    37.73327606237309}, {-37.37876217348419, \
-10.431857821638186`}}],
                    StatusArea[#, 8.608635599766146]& ,
                    TagBoxNote->"8.608635599766146"],
                   StyleBox["8.608635599766146`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.608635599766146, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44208$44517, 
                    FEPrivate`Not[DynamicChart`click$44208$44517]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44208$44517, {{{1., 0}, {0, 1.}}, {
                   0.12661769354129407`, 0.15481588963114523`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44208$44517}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.3061346228300295`, -0.5168709895050507}]},
                    
                    ImageSizeCache->{{7.934505605450882, 
                    35.624666708600905`}, {-21.23695661792864, \
-2.2667239376268995`}}],
                    StatusArea[#, 5.49275411610833]& ,
                    TagBoxNote->"5.49275411610833"],
                   StyleBox["5.49275411610833`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.49275411610833, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44211$44517, 
                    FEPrivate`Not[DynamicChart`click$44211$44517]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44211$44517, {{{1., 0}, {0, 1.}}, {
                   0.031724142240309554`, -0.1974679184047794}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44211$44517}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.3061346228300295`}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.59147050681753}, {-21.236956617928644`, \
-6.4377042829612385`}}],
                    StatusArea[#, 2.5647229686124042`]& ,
                    TagBoxNote->"2.5647229686124042"],
                   StyleBox["2.5647229686124042`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.5647229686124042`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44214$44517, 
                    FEPrivate`Not[DynamicChart`click$44214$44517]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44214$44517, {{{1., 0}, {
                    0, 1.}}, {-0.18280252053313298`, -0.08113715848323443}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44214$44517}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.1342847119106843`]& ,
                  TagBoxNote->"2.1342847119106843"],
                 StyleBox["2.1342847119106843`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.1342847119106843`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44202$44517, 
                   FEPrivate`Not[DynamicChart`click$44202$44517]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44202$44517, {{{1., 0}, {
                  0, 1.}}, {-0.18803713263377353`, 0.06813249408959471}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44202$44517}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.48797985304589275`]& ,
                  TagBoxNote->"0.48797985304589275"],
                 StyleBox["0.48797985304589275`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.48797985304589275`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44205$44517, 
                   FEPrivate`Not[DynamicChart`click$44205$44517]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44205$44517, {{{1., 0}, {
                  0, 1.}}, {-0.14292303249767233`, 0.13990356243380403`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44205$44517}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.608635599766146]& ,
                  TagBoxNote->"8.608635599766146"],
                 StyleBox["8.608635599766146`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.608635599766146, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44208$44517, 
                   FEPrivate`Not[DynamicChart`click$44208$44517]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44208$44517, {{{1., 0}, {0, 1.}}, {
                 0.12661769354129407`, 0.15481588963114523`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44208$44517}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.49275411610833]& ,
                  TagBoxNote->"5.49275411610833"],
                 StyleBox["5.49275411610833`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.49275411610833, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44211$44517, 
                   FEPrivate`Not[DynamicChart`click$44211$44517]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44211$44517, {{{1., 0}, {0, 1.}}, {
                 0.031724142240309554`, -0.1974679184047794}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44211$44517}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.5647229686124042`]& ,
                  TagBoxNote->"2.5647229686124042"],
                 StyleBox["2.5647229686124042`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.5647229686124042`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44214$44517, 
                   FEPrivate`Not[DynamicChart`click$44214$44517]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44214$44517, {{{1., 0}, {
                  0, 1.}}, {-0.18280252053313298`, -0.08113715848323443}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44214$44517}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44253$44518 = False, 
         DynamicChart`click$44256$44518 = False, 
         DynamicChart`click$44259$44518 = False, 
         DynamicChart`click$44262$44518 = False, 
         DynamicChart`click$44265$44518 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.404046391818904, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-32.09189914980594, \
-18.408529493182453`}}],
                    StatusArea[#, 3.14683802997064]& ,
                    TagBoxNote->"3.14683802997064"],
                   StyleBox["3.14683802997064`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.14683802997064, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44253$44518, 
                    FEPrivate`Not[DynamicChart`click$44253$44518]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44253$44518, {{{1., 0}, {
                    0, 1.}}, {-0.18655405972528807`, 0.07209426329475636}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44253$44518}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.23633204807996044`, 
                    2.404046391818904}]},
                    
                    ImageSizeCache->{{6.816156372351806, 
                    37.28458746810604}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 9.248838057441837]& ,
                    TagBoxNote->"9.248838057441837"],
                   StyleBox["9.248838057441837`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.248838057441837, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44256$44518, 
                    FEPrivate`Not[DynamicChart`click$44256$44518]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44256$44518, {{{1., 0}, {0, 1.}}, {
                   0.04959842939766954, 0.19375240850447353`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44256$44518}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.16880892261935054`, 
                    0.23633204807996044`}]},
                    ImageSizeCache->{{18.76304338207135, 
                    37.73327606237309}, {-25.016370148184805`, \
-15.696571833950959`}}],
                    StatusArea[#, 1.7285871818191794`]& ,
                    TagBoxNote->"1.7285871818191794"],
                   StyleBox["1.7285871818191794`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.7285871818191794`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44259$44518, 
                    FEPrivate`Not[DynamicChart`click$44259$44518]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44259$44518, {{{1., 0}, {0, 1.}}, {
                   0.19988602651480886`, 0.006751029856335399}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44259$44518}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.4036388235995725`, -0.16880892261935054`}]},
                    
                    ImageSizeCache->{{6.820581494087744, 
                    37.50382961060539}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 9.535195400535706]& ,
                    TagBoxNote->"9.535195400535706"],
                   StyleBox["9.535195400535706`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.535195400535706, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44262$44518, 
                    FEPrivate`Not[DynamicChart`click$44262$44518]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44262$44518, {{{1., 0}, {0, 1.}}, {
                   0.056149425161552774`, -0.19195635455495397`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44262$44518}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.4036388235995725`}]},
                    
                    ImageSizeCache->{{2.6212378265157916`, 
                    21.59147050681754}, {-21.236956617928644`, \
-7.5487186915421525`}}],
                    StatusArea[#, 3.1485769733276587`]& ,
                    TagBoxNote->"3.1485769733276587"],
                   StyleBox["3.1485769733276587`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.1485769733276587`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44265$44518, 
                    FEPrivate`Not[DynamicChart`click$44265$44518]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44265$44518, {{{1., 0}, {
                    0, 1.}}, {-0.18653936418652717`, -0.07213227855049491}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44265$44518}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.14683802997064]& ,
                  TagBoxNote->"3.14683802997064"],
                 StyleBox["3.14683802997064`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.14683802997064, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44253$44518, 
                   FEPrivate`Not[DynamicChart`click$44253$44518]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44253$44518, {{{1., 0}, {
                  0, 1.}}, {-0.18655405972528807`, 0.07209426329475636}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44253$44518}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.248838057441837]& ,
                  TagBoxNote->"9.248838057441837"],
                 StyleBox["9.248838057441837`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.248838057441837, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44256$44518, 
                   FEPrivate`Not[DynamicChart`click$44256$44518]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44256$44518, {{{1., 0}, {0, 1.}}, {
                 0.04959842939766954, 0.19375240850447353`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44256$44518}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.7285871818191794`]& ,
                  TagBoxNote->"1.7285871818191794"],
                 StyleBox["1.7285871818191794`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.7285871818191794`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44259$44518, 
                   FEPrivate`Not[DynamicChart`click$44259$44518]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44259$44518, {{{1., 0}, {0, 1.}}, {
                 0.19988602651480886`, 0.006751029856335399}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44259$44518}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.535195400535706]& ,
                  TagBoxNote->"9.535195400535706"],
                 StyleBox["9.535195400535706`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.535195400535706, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44262$44518, 
                   FEPrivate`Not[DynamicChart`click$44262$44518]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44262$44518, {{{1., 0}, {0, 1.}}, {
                 0.056149425161552774`, -0.19195635455495397`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44262$44518}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.1485769733276587`]& ,
                  TagBoxNote->"3.1485769733276587"],
                 StyleBox["3.1485769733276587`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.1485769733276587`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44265$44518, 
                   FEPrivate`Not[DynamicChart`click$44265$44518]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44265$44518, {{{1., 0}, {
                  0, 1.}}, {-0.18653936418652717`, -0.07213227855049491}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44265$44518}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44304$44519 = False, 
         DynamicChart`click$44307$44519 = False, 
         DynamicChart`click$44310$44519 = False, 
         DynamicChart`click$44313$44519 = False, 
         DynamicChart`click$44316$44519 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.8136083853277087`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-26.43680366842755, \
-18.408529493182453`}}],
                    StatusArea[#, 1.306363715596067]& ,
                    TagBoxNote->"1.306363715596067"],
                   StyleBox["1.306363715596067`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.306363715596067, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44304$44519, 
                    FEPrivate`Not[DynamicChart`click$44304$44519]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44304$44519, {{{1., 0}, {
                    0, 1.}}, {-0.19731667972758693`, 0.03265161406854002}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44304$44519}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.378606374100853, 
                    2.8136083853277087`}]},
                    
                    ImageSizeCache->{{3.4816992905072297`, 
                    21.59147050681755}, {-32.39228294441993, \
-18.408529493182453`}}],
                    StatusArea[#, 1.7326161607970327`]& ,
                    TagBoxNote->"1.7326161607970327"],
                   StyleBox["1.7326161607970327`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.7326161607970327`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44307$44519, 
                    FEPrivate`Not[DynamicChart`click$44307$44519]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44307$44519, {{{1., 0}, {
                    0, 1.}}, {-0.170975123069443, 0.10376660007627125`}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44307$44519}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.10300536984891373`, 
                    2.378606374100853}]},
                    
                    ImageSizeCache->{{7.096142287828105, 
                    37.64771861457727}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 9.06373527877026]& ,
                    TagBoxNote->"9.06373527877026"],
                   StyleBox["9.06373527877026`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.06373527877026, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44310$44519, 
                    FEPrivate`Not[DynamicChart`click$44310$44519]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44310$44519, {{{1., 0}, {0, 1.}}, {
                   0.06480679964713253, 0.18920908730686387`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44310$44519}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.9897565401616877, 
                    0.10300536984891373`}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.73327606237311}, {-22.89671060434559, \
-4.915717393201415}}],
                    StatusArea[#, 4.352478600841268]& ,
                    TagBoxNote->"4.352478600841268"],
                   StyleBox["4.352478600841268`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.352478600841268, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44313$44519, 
                    FEPrivate`Not[DynamicChart`click$44313$44519]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44313$44519, {{{1., 0}, {0, 1.}}, {
                   0.18066174327783247`, -0.08579821977066054}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44313$44519}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.9897565401616877}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    30.451600767032108`}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 8.570778822371658]& ,
                    TagBoxNote->"8.570778822371658"],
                   StyleBox["8.570778822371658`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.570778822371658, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44316$44519, 
                    FEPrivate`Not[DynamicChart`click$44316$44519]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44316$44519, {{{1., 0}, {
                    0, 1.}}, {-0.09498490584635128, -0.17600530577616058`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44316$44519}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.306363715596067]& ,
                  TagBoxNote->"1.306363715596067"],
                 StyleBox["1.306363715596067`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.306363715596067, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44304$44519, 
                   FEPrivate`Not[DynamicChart`click$44304$44519]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44304$44519, {{{1., 0}, {
                  0, 1.}}, {-0.19731667972758693`, 0.03265161406854002}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44304$44519}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.7326161607970327`]& ,
                  TagBoxNote->"1.7326161607970327"],
                 StyleBox["1.7326161607970327`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.7326161607970327`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44307$44519, 
                   FEPrivate`Not[DynamicChart`click$44307$44519]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44307$44519, {{{1., 0}, {
                  0, 1.}}, {-0.170975123069443, 0.10376660007627125`}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44307$44519}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.06373527877026]& ,
                  TagBoxNote->"9.06373527877026"],
                 StyleBox["9.06373527877026`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.06373527877026, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44310$44519, 
                   FEPrivate`Not[DynamicChart`click$44310$44519]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44310$44519, {{{1., 0}, {0, 1.}}, {
                 0.06480679964713253, 0.18920908730686387`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44310$44519}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.352478600841268]& ,
                  TagBoxNote->"4.352478600841268"],
                 StyleBox["4.352478600841268`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.352478600841268, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44313$44519, 
                   FEPrivate`Not[DynamicChart`click$44313$44519]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44313$44519, {{{1., 0}, {0, 1.}}, {
                 0.18066174327783247`, -0.08579821977066054}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44313$44519}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.570778822371658]& ,
                  TagBoxNote->"8.570778822371658"],
                 StyleBox["8.570778822371658`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.570778822371658, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44316$44519, 
                   FEPrivate`Not[DynamicChart`click$44316$44519]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44316$44519, {{{1., 0}, {
                  0, 1.}}, {-0.09498490584635128, -0.17600530577616058`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44316$44519}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -967.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44355$44520 = False, 
         DynamicChart`click$44358$44520 = False, 
         DynamicChart`click$44361$44520 = False, 
         DynamicChart`click$44364$44520 = False, 
         DynamicChart`click$44367$44520 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.7008059498324015, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    33.92901942522529}, {-37.378762173484205`, \
-18.408529493182453`}}],
                    StatusArea[#, 9.276197755119934]& ,
                    TagBoxNote->"9.276197755119934"],
                   StyleBox["9.276197755119934`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.276197755119934, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44355$44520, 
                    FEPrivate`Not[DynamicChart`click$44355$44520]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$44355$44520, {{{1., 0}, {
                    0, 1.}}, {-0.06865526464881372, 0.18784689147281985`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44355$44520}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.2484503374169087, 
                    0.7008059498324015}]},
                    
                    ImageSizeCache->{{18.763043382071363`, 
                    37.73327606237311}, {-31.6457400857149, \
-14.439224391143242`}}],
                    StatusArea[#, 3.6076438089654506`]& ,
                    TagBoxNote->"3.6076438089654506"],
                   StyleBox["3.6076438089654506`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.6076438089654506`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44358$44520, 
                    FEPrivate`Not[DynamicChart`click$44358$44520]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44358$44520, {{{1., 0}, {0, 1.}}, {
                   0.1949061309881784, 0.044850865133451434`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44358$44520}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.6847229400398236`, -0.2484503374169087}]},
                    
                    ImageSizeCache->{{4.276777078788568, 
                    37.23763628633971}, {-21.236956617928644`, \
-2.266723937626896}}],
                    StatusArea[#, 9.259041936159779]& ,
                    TagBoxNote->"9.259041936159779"],
                   StyleBox["9.259041936159779`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.259041936159779, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44361$44520, 
                    FEPrivate`Not[DynamicChart`click$44361$44520]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44361$44520, {{{1., 0}, {0, 1.}}, {
                   0.020804235367941064`, -0.19891501650392138`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44361$44520}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.0856724317750768`, -2.6847229400398236`}]},
                    
                    ImageSizeCache->{{2.6464695380718055`, 
                    21.59147050681755}, {-21.23695661792864, \
-11.287716675551472`}}],
                    StatusArea[#, 1.5238065536105623`]& ,
                    TagBoxNote->"1.5238065536105623"],
                   StyleBox["1.5238065536105623`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.5238065536105623`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44364$44520, 
                    FEPrivate`Not[DynamicChart`click$44364$44520]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44364$44520, {{{1., 0}, {
                    0, 1.}}, {-0.19346209602098538`, \
-0.050719004358987935`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44364$44520}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -3.0856724317750768`}]},
                    
                    ImageSizeCache->{{2.621237826515806, 
                    21.591470506817554`}, {-21.23695661792864, \
-17.50634651602447}}],
                    StatusArea[#, 0.21252452550029943`]& ,
                    TagBoxNote->"0.21252452550029943"],
                   StyleBox["0.21252452550029943`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.21252452550029943`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44367$44520, 
                    FEPrivate`Not[DynamicChart`click$44367$44520]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44367$44520, {{{1., 0}, {
                    0, 1.}}, {-0.19992182831267957`, -0.005591293599469794}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44367$44520}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.276197755119934]& ,
                  TagBoxNote->"9.276197755119934"],
                 StyleBox["9.276197755119934`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.276197755119934, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44355$44520, 
                   FEPrivate`Not[DynamicChart`click$44355$44520]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44355$44520, {{{1., 0}, {
                  0, 1.}}, {-0.06865526464881372, 0.18784689147281985`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44355$44520}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.6076438089654506`]& ,
                  TagBoxNote->"3.6076438089654506"],
                 StyleBox["3.6076438089654506`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.6076438089654506`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44358$44520, 
                   FEPrivate`Not[DynamicChart`click$44358$44520]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44358$44520, {{{1., 0}, {0, 1.}}, {
                 0.1949061309881784, 0.044850865133451434`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44358$44520}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.259041936159779]& ,
                  TagBoxNote->"9.259041936159779"],
                 StyleBox["9.259041936159779`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.259041936159779, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44361$44520, 
                   FEPrivate`Not[DynamicChart`click$44361$44520]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44361$44520, {{{1., 0}, {0, 1.}}, {
                 0.020804235367941064`, -0.19891501650392138`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44361$44520}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.5238065536105623`]& ,
                  TagBoxNote->"1.5238065536105623"],
                 StyleBox["1.5238065536105623`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.5238065536105623`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44364$44520, 
                   FEPrivate`Not[DynamicChart`click$44364$44520]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44364$44520, {{{1., 0}, {
                  0, 1.}}, {-0.19346209602098538`, -0.050719004358987935`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44364$44520}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.21252452550029943`]& ,
                  TagBoxNote->"0.21252452550029943"],
                 StyleBox["0.21252452550029943`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.21252452550029943`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44367$44520, 
                   FEPrivate`Not[DynamicChart`click$44367$44520]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44367$44520, {{{1., 0}, {
                  0, 1.}}, {-0.19992182831267957`, -0.005591293599469794}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44367$44520}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$44406$44521 = False, 
         DynamicChart`click$44409$44521 = False, 
         DynamicChart`click$44412$44521 = False, 
         DynamicChart`click$44415$44521 = False, 
         DynamicChart`click$44418$44521 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.935141735783187, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    31.174931165118593`}, {-37.37876217348419, \
-18.408529493182453`}}],
                    StatusArea[#, 8.74998110160433]& ,
                    TagBoxNote->"8.74998110160433"],
                   StyleBox["8.74998110160433`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.74998110160433, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44406$44521, 
                    FEPrivate`Not[DynamicChart`click$44406$44521]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44406$44521, {{{1., 0}, {
                    0, 1.}}, {-0.09014384283695262, 0.17853315546023038`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44406$44521}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.7406078506795484, 
                    0.935141735783187}]},
                    
                    ImageSizeCache->{{18.763043382071334`, 
                    37.733276062373065`}, {-34.225996936757426`, \
-7.517061435104985}}],
                    StatusArea[#, 6.645412818494151]& ,
                    TagBoxNote->"6.645412818494151"],
                   StyleBox["6.645412818494151`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.645412818494151, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44409$44521, 
                    FEPrivate`Not[DynamicChart`click$44409$44521]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44409$44521, {{{1., 0}, {0, 1.}}, {
                   0.19905465985210916`, 0.019422728725931517`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44409$44521}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.1397232045577672`, -0.7406078506795484}]},
                    
                    ImageSizeCache->{{18.763043382071334`, 
                    33.50506820580175}, {-21.236956617928644`, \
-3.743410642595318}}],
                    StatusArea[#, 1.5827461991613827`]& ,
                    TagBoxNote->"1.5827461991613827"],
                   StyleBox["1.5827461991613827`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.5827461991613827`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44412$44521, 
                    FEPrivate`Not[DynamicChart`click$44412$44521]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44412$44521, {{{1., 0}, {0, 1.}}, {
                   0.11793086875650081`, -0.16153114310973282`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44412$44521}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.151132953533166, -1.1397232045577672`}]},
                    
                    ImageSizeCache->{{9.912402915787638, 
                    28.336259287166236`}, {-21.23695661792864, \
-2.2667239376269066`}}],
                    StatusArea[#, 4.01088286990338]& ,
                    TagBoxNote->"4.01088286990338"],
                   StyleBox["4.01088286990338`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.01088286990338, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44415$44521, 
                    FEPrivate`Not[DynamicChart`click$44415$44521]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44415$44521, {{{1., 0}, {
                    0, 1.}}, {-0.0149124979325082, -0.1994432686390116}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$44415$44521}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.151132953533166}]},
                    
                    ImageSizeCache->{{2.621237826515788, 
                    21.591470506817522`}, {-21.236956617928644`, \
-4.9094906411031936`}}],
                    StatusArea[#, 3.9278026025665707`]& ,
                    TagBoxNote->"3.9278026025665707"],
                   StyleBox["3.9278026025665707`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.9278026025665707`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$44418$44521, 
                    FEPrivate`Not[DynamicChart`click$44418$44521]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$44418$44521, {{{1., 0}, {
                    0, 1.}}, {-0.17597190011076844`, -0.09504677991076681}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$44418$44521}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.74998110160433]& ,
                  TagBoxNote->"8.74998110160433"],
                 StyleBox["8.74998110160433`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.74998110160433, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44406$44521, 
                   FEPrivate`Not[DynamicChart`click$44406$44521]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44406$44521, {{{1., 0}, {
                  0, 1.}}, {-0.09014384283695262, 0.17853315546023038`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44406$44521}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.645412818494151]& ,
                  TagBoxNote->"6.645412818494151"],
                 StyleBox["6.645412818494151`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.645412818494151, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44409$44521, 
                   FEPrivate`Not[DynamicChart`click$44409$44521]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44409$44521, {{{1., 0}, {0, 1.}}, {
                 0.19905465985210916`, 0.019422728725931517`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44409$44521}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.5827461991613827`]& ,
                  TagBoxNote->"1.5827461991613827"],
                 StyleBox["1.5827461991613827`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.5827461991613827`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44412$44521, 
                   FEPrivate`Not[DynamicChart`click$44412$44521]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44412$44521, {{{1., 0}, {0, 1.}}, {
                 0.11793086875650081`, -0.16153114310973282`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44412$44521}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.01088286990338]& ,
                  TagBoxNote->"4.01088286990338"],
                 StyleBox["4.01088286990338`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.01088286990338, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44415$44521, 
                   FEPrivate`Not[DynamicChart`click$44415$44521]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44415$44521, {{{1., 0}, {
                  0, 1.}}, {-0.0149124979325082, -0.1994432686390116}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$44415$44521}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.9278026025665707`]& ,
                  TagBoxNote->"3.9278026025665707"],
                 StyleBox["3.9278026025665707`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.9278026025665707`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$44418$44521, 
                   FEPrivate`Not[DynamicChart`click$44418$44521]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$44418$44521, {{{1., 0}, {
                  0, 1.}}, {-0.17597190011076844`, -0.09504677991076681}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$44418$44521}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}}, {}},
  ContentSelectable->True,
  ImageSize->{260.421875, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"2c2a1a88-9a67-4b18-b5ca-5ba663ed1177"]
}, Open  ]],

Cell["Do it with a frame around everything:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"252080ea-9ebc-4521-a310-83759eeb719e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PieChart", "[", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"10", ",", "5"}], "]"}], "]"}], ",", "3", ",", "6"}], "]"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"d479a600-e2ef-4e10-8df2-0c0d18884f1c"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40431$41405 = False, 
         DynamicChart`click$40436$41405 = False, 
         DynamicChart`click$40439$41405 = False, 
         DynamicChart`click$40442$41405 = False, 
         DynamicChart`click$40445$41405 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.966482740597739, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    21.179866971463994`}, {-24.403360475734516`, \
-18.820133028536002`}}],
                    StatusArea[#, 0.9370062632194163]& ,
                    TagBoxNote->"0.9370062632194163"],
                   StyleBox["0.9370062632194163`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.9370062632194163, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40431$41405, 
                    FEPrivate`Not[DynamicChart`click$40431$41405]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40431$41405, {{{1., 0}, {
                    0, 1.}}, {-0.19923390254725493`, 
                   0.017488627041335494`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$40431$41405}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.155849372281941, 
                    2.966482740597739}]},
                    
                    ImageSizeCache->{{2.780731764426463, 
                    27.554549316140175`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 9.688628002361902]& ,
                    TagBoxNote->"9.688628002361902"],
                   StyleBox["9.688628002361902`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.688628002361902, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40436$41405, 
                    FEPrivate`Not[DynamicChart`click$40436$41405]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40436$41405, {{{1., 0}, {
                    0, 1.}}, {-0.09419041612219597, 0.1764317587928193}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40436$41405}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.6177447313375506, 
                    1.155849372281941}]},
                    
                    ImageSizeCache->{{18.351439846717806`, 
                    36.992389698736716`}, {-36.11919593769022, \
-9.661548803802855}}],
                    StatusArea[#, 9.490432352484241]& ,
                    TagBoxNote->"9.490432352484241"],
                   StyleBox["9.490432352484241`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.490432352484241, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40439$41405, 
                    FEPrivate`Not[DynamicChart`click$40439$41405]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40439$41405, {{{1., 0}, {0, 1.}}, {
                   0.19280464789408608`, 0.0531635942204578}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40439$41405}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.1616642999139097`, -0.6177447313375506}]},
                    ImageSizeCache->{{9.542567310928728, 
                    34.070026396350315`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 8.26145294086642]& ,
                    TagBoxNote->"8.26145294086642"],
                   StyleBox["8.26145294086642`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.26145294086642, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40442$41405, 
                    FEPrivate`Not[DynamicChart`click$40442$41405]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40442$41405, {{{1., 0}, {0, 1.}}, {
                   0.03602072760773524, -0.19672952798857965`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40442$41405}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.1616642999139097`}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    21.179866971463994`}, {-21.648560153282194`, \
-5.688505572324136}}],
                    StatusArea[#, 5.243558112796611]& ,
                    TagBoxNote->"5.243558112796611"],
                   StyleBox["5.243558112796611`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.243558112796611, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40445$41405, 
                    FEPrivate`Not[DynamicChart`click$40445$41405]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40445$41405, {{{1., 0}, {
                    0, 1.}}, {-0.17646994347028605`, -0.09411885598324093}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40445$41405}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.9370062632194163]& ,
                  TagBoxNote->"0.9370062632194163"],
                 StyleBox["0.9370062632194163`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.9370062632194163, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40431$41405, 
                   FEPrivate`Not[DynamicChart`click$40431$41405]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40431$41405, {{{1., 0}, {
                  0, 1.}}, {-0.19923390254725493`, 0.017488627041335494`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40431$41405}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.688628002361902]& ,
                  TagBoxNote->"9.688628002361902"],
                 StyleBox["9.688628002361902`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.688628002361902, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40436$41405, 
                   FEPrivate`Not[DynamicChart`click$40436$41405]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40436$41405, {{{1., 0}, {
                  0, 1.}}, {-0.09419041612219597, 0.1764317587928193}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40436$41405}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.490432352484241]& ,
                  TagBoxNote->"9.490432352484241"],
                 StyleBox["9.490432352484241`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.490432352484241, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40439$41405, 
                   FEPrivate`Not[DynamicChart`click$40439$41405]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40439$41405, {{{1., 0}, {0, 1.}}, {
                 0.19280464789408608`, 0.0531635942204578}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40439$41405}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.26145294086642]& ,
                  TagBoxNote->"8.26145294086642"],
                 StyleBox["8.26145294086642`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.26145294086642, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40442$41405, 
                   FEPrivate`Not[DynamicChart`click$40442$41405]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40442$41405, {{{1., 0}, {0, 1.}}, {
                 0.03602072760773524, -0.19672952798857965`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40442$41405}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.243558112796611]& ,
                  TagBoxNote->"5.243558112796611"],
                 StyleBox["5.243558112796611`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.243558112796611, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40445$41405, 
                   FEPrivate`Not[DynamicChart`click$40445$41405]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40445$41405, {{{1., 0}, {
                  0, 1.}}, {-0.17646994347028605`, -0.09411885598324093}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40445$41405}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40486$41406 = False, 
         DynamicChart`click$40489$41406 = False, 
         DynamicChart`click$40492$41406 = False, 
         DynamicChart`click$40495$41406 = False, 
         DynamicChart`click$40498$41406 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5198139301409415`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.985678093343452`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 9.507461454481756]& ,
                    TagBoxNote->"9.507461454481756"],
                   StyleBox["9.507461454481756`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.507461454481756, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40486$41406, 
                    FEPrivate`Not[DynamicChart`click$40486$41406]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40486$41406, {{{1., 0}, {
                    0, 1.}}, {-0.13777080141239798`, 0.1449800202724003}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40486$41406}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.545535617309838, 
                    1.5198139301409415`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    34.69719403051734}, {-37.44053733906776, \
-18.820133028536002`}}],
                    StatusArea[#, 5.7115766603972045`]& ,
                    TagBoxNote->"5.7115766603972045"],
                   StyleBox["5.7115766603972045`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.7115766603972045`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40489$41406, 
                    FEPrivate`Not[DynamicChart`click$40489$41406]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40489$41406, {{{1., 0}, {0, 1.}}, {
                   0.10250478505610852`, 0.171734588946435}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40489$41406}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.5583847682816683, 
                    0.545535617309838}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.99238969873673}, {-29.853299282535552`, \
-10.442389797099153`}}],
                    StatusArea[#, 6.471586020384056]& ,
                    TagBoxNote->"6.471586020384056"],
                   StyleBox["6.471586020384056`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.471586020384056, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40492$41406, 
                    FEPrivate`Not[DynamicChart`click$40492$41406]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40492$41406, {{{1., 0}, {0, 1.}}, {
                   0.19999587249717957`, -0.0012849062580197186`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40492$41406}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.8485836415946775`, -0.5583847682816683}]},
                    
                    ImageSizeCache->{{14.015196080392421`, 
                    34.590657155067305`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 7.563618808954054]& ,
                    TagBoxNote->"7.563618808954054"],
                   StyleBox["7.563618808954054`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.563618808954054, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40495$41406, 
                    FEPrivate`Not[DynamicChart`click$40495$41406]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40495$41406, {{{1., 0}, {0, 1.}}, {
                   0.0718216292818207, -0.18665919095320413`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40495$41406}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.8485836415946775`}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-21.648560153282194`, \
-3.613790108572619}}],
                    StatusArea[#, 7.580092872163526]& ,
                    TagBoxNote->"7.580092872163526"],
                   StyleBox["7.580092872163526`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.580092872163526, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40498$41406, 
                    FEPrivate`Not[DynamicChart`click$40498$41406]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40498$41406, {{{1., 0}, {
                    0, 1.}}, {-0.15963887124628462`, -0.12048000160695618`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40498$41406}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.507461454481756]& ,
                  TagBoxNote->"9.507461454481756"],
                 StyleBox["9.507461454481756`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.507461454481756, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40486$41406, 
                   FEPrivate`Not[DynamicChart`click$40486$41406]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40486$41406, {{{1., 0}, {
                  0, 1.}}, {-0.13777080141239798`, 0.1449800202724003}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40486$41406}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.7115766603972045`]& ,
                  TagBoxNote->"5.7115766603972045"],
                 StyleBox["5.7115766603972045`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.7115766603972045`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40489$41406, 
                   FEPrivate`Not[DynamicChart`click$40489$41406]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40489$41406, {{{1., 0}, {0, 1.}}, {
                 0.10250478505610852`, 0.171734588946435}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40489$41406}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.471586020384056]& ,
                  TagBoxNote->"6.471586020384056"],
                 StyleBox["6.471586020384056`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.471586020384056, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40492$41406, 
                   FEPrivate`Not[DynamicChart`click$40492$41406]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40492$41406, {{{1., 0}, {0, 1.}}, {
                 0.19999587249717957`, -0.0012849062580197186`}}, {{1, 0}, {0,
                 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40492$41406}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.563618808954054]& ,
                  TagBoxNote->"7.563618808954054"],
                 StyleBox["7.563618808954054`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.563618808954054, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40495$41406, 
                   FEPrivate`Not[DynamicChart`click$40495$41406]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40495$41406, {{{1., 0}, {0, 1.}}, {
                 0.0718216292818207, -0.18665919095320413`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40495$41406}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.580092872163526]& ,
                  TagBoxNote->"7.580092872163526"],
                 StyleBox["7.580092872163526`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.580092872163526, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40498$41406, 
                   FEPrivate`Not[DynamicChart`click$40498$41406]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40498$41406, {{{1., 0}, {
                  0, 1.}}, {-0.15963887124628462`, -0.12048000160695618`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40498$41406}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40537$41407 = False, 
         DynamicChart`click$40540$41407 = False, 
         DynamicChart`click$40543$41407 = False, 
         DynamicChart`click$40546$41407 = False, 
         DynamicChart`click$40549$41407 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0222833400104596`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-23.53066874683948, \
-18.820133028536002`}}],
                    StatusArea[#, 0.4105953904983739]& ,
                    TagBoxNote->"0.4105953904983739"],
                   StyleBox["0.4105953904983739`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.4105953904983739, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40537$41407, 
                    FEPrivate`Not[DynamicChart`click$40537$41407]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40537$41407, {{{1., 0}, {
                    0, 1.}}, {-0.19964423771472647`, 
                   0.011923856226313506`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$40537$41407}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.6100663838112674, 
                    3.0222833400104596`}]},
                    
                    ImageSizeCache->{{2.651327036850045, 
                    34.13996851704353}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 8.301490750249116]& ,
                    TagBoxNote->"8.301490750249116"],
                   StyleBox["8.301490750249116`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.301490750249116, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40540$41407, 
                    FEPrivate`Not[DynamicChart`click$40540$41407]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$40540$41407, {{{1., 0}, {
                    0, 1.}}, {-0.04858470768936162, 0.1940090878766747}}, {{1,
                   0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40540$41407}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.25024000147467174`, 
                    0.6100663838112674}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.4998773141168}, {-30.707900246731825`, \
-18.820133028536002`}}],
                    StatusArea[#, 1.238319537132126]& ,
                    TagBoxNote->"1.238319537132126"],
                   StyleBox["1.238319537132126`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.238319537132126, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40543$41407, 
                    FEPrivate`Not[DynamicChart`click$40543$41407]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40543$41407, {{{1., 0}, {0, 1.}}, {
                   0.18178037549386727`, 0.08340200888053373}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40543$41407}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.9355454521810325`, 
                    0.25024000147467174`}]},
                    
                    ImageSizeCache->{{12.710876824992393`, 
                    36.99238969873673}, {-25.564317819625725`, \
-3.0076103012632807`}}],
                    StatusArea[#, 7.522241181051346]& ,
                    TagBoxNote->"7.522241181051346"],
                   StyleBox["7.522241181051346`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.522241181051346, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40546$41407, 
                    FEPrivate`Not[DynamicChart`click$40546$41407]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40546$41407, {{{1., 0}, {0, 1.}}, {
                   0.13309702920482422`, -0.1492822186894681}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40546$41407}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.9355454521810325`}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-21.648560153282194`, \
-4.047864286109867}}],
                    StatusArea[#, 4.1505344953026295`]& ,
                    TagBoxNote->"4.1505344953026295"],
                   StyleBox["4.1505344953026295`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.1505344953026295`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40549$41407, 
                    FEPrivate`Not[DynamicChart`click$40549$41407]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40549$41407, {{{1., 0}, {
                    0, 1.}}, {-0.16472491829159522`, -0.11342707478299563`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40549$41407}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.4105953904983739]& ,
                  TagBoxNote->"0.4105953904983739"],
                 StyleBox["0.4105953904983739`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.4105953904983739, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40537$41407, 
                   FEPrivate`Not[DynamicChart`click$40537$41407]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40537$41407, {{{1., 0}, {
                  0, 1.}}, {-0.19964423771472647`, 0.011923856226313506`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40537$41407}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.301490750249116]& ,
                  TagBoxNote->"8.301490750249116"],
                 StyleBox["8.301490750249116`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.301490750249116, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40540$41407, 
                   FEPrivate`Not[DynamicChart`click$40540$41407]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40540$41407, {{{1., 0}, {
                  0, 1.}}, {-0.04858470768936162, 0.1940090878766747}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40540$41407}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.238319537132126]& ,
                  TagBoxNote->"1.238319537132126"],
                 StyleBox["1.238319537132126`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.238319537132126, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40543$41407, 
                   FEPrivate`Not[DynamicChart`click$40543$41407]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40543$41407, {{{1., 0}, {0, 1.}}, {
                 0.18178037549386727`, 0.08340200888053373}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40543$41407}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.522241181051346]& ,
                  TagBoxNote->"7.522241181051346"],
                 StyleBox["7.522241181051346`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.522241181051346, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40546$41407, 
                   FEPrivate`Not[DynamicChart`click$40546$41407]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40546$41407, {{{1., 0}, {0, 1.}}, {
                 0.13309702920482422`, -0.1492822186894681}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40546$41407}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.1505344953026295`]& ,
                  TagBoxNote->"4.1505344953026295"],
                 StyleBox["4.1505344953026295`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.1505344953026295`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40549$41407, 
                   FEPrivate`Not[DynamicChart`click$40549$41407]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40549$41407, {{{1., 0}, {
                  0, 1.}}, {-0.16472491829159522`, -0.11342707478299563`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40549$41407}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40588$41408 = False, 
         DynamicChart`click$40591$41408 = False, 
         DynamicChart`click$40594$41408 = False, 
         DynamicChart`click$40597$41408 = False, 
         DynamicChart`click$40600$41408 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.211981241404479, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    26.732671964294568`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 7.74111993218758]& ,
                    TagBoxNote->"7.74111993218758"],
                   StyleBox["7.74111993218758`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.74111993218758, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40588$41408, 
                    FEPrivate`Not[DynamicChart`click$40588$41408]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40588$41408, {{{1., 0}, {
                    0, 1.}}, {-0.11391531693194878`, 0.1643876533328877}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40588$41408}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0464944255690658`, 
                    1.211981241404479}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    29.095755014890216`}, {-36.45403993990554, \
-18.820133028536002`}}],
                    StatusArea[#, 0.6638918491505823]& ,
                    TagBoxNote->"0.6638918491505823"],
                   StyleBox["0.6638918491505823`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.6638918491505823, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40591$41408, 
                    FEPrivate`Not[DynamicChart`click$40591$41408]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40591$41408, {{{1., 0}, {0, 1.}}, {
                   0.0854697993250911, 0.18081734818133094`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40591$41408}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.762378956263468, 
                    1.0464944255690658`}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    32.615405091889116`}, {-35.33704405342462, \
-18.820133028536002`}}],
                    StatusArea[#, 1.1398004326651296`]& ,
                    TagBoxNote->"1.1398004326651296"],
                   StyleBox["1.1398004326651296`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.1398004326651296`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40594$41408, 
                    FEPrivate`Not[DynamicChart`click$40594$41408]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40594$41408, {{{1., 0}, {0, 1.}}, {
                   0.12362569646846618`, 0.1572154164599855}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40594$41408}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.4412525249742245`, 
                    0.762378956263468}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.992389698736744`}, {-32.56938168358937, \
-3.140104545681801}}],
                    StatusArea[#, 8.840420135827266]& ,
                    TagBoxNote->"8.840420135827266"],
                   StyleBox["8.840420135827266`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.840420135827266, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40597$41408, 
                    FEPrivate`Not[DynamicChart`click$40597$41408]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40597$41408, {{{1., 0}, {0, 1.}}, {
                   0.18858846822790232`, -0.06659121301983825}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40597$41408}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4412525249742245`}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    23.222556810229896`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 6.821340700000118]& ,
                    TagBoxNote->"6.821340700000118"],
                   StyleBox["6.821340700000118`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.821340700000118, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40600$41408, 
                    FEPrivate`Not[DynamicChart`click$40600$41408]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40600$41408, {{{1., 0}, {
                    0, 1.}}, {-0.13197107407191458`, -0.1502785267704779}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40600$41408}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.74111993218758]& ,
                  TagBoxNote->"7.74111993218758"],
                 StyleBox["7.74111993218758`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.74111993218758, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40588$41408, 
                   FEPrivate`Not[DynamicChart`click$40588$41408]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40588$41408, {{{1., 0}, {
                  0, 1.}}, {-0.11391531693194878`, 0.1643876533328877}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40588$41408}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.6638918491505823]& ,
                  TagBoxNote->"0.6638918491505823"],
                 StyleBox["0.6638918491505823`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.6638918491505823, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40591$41408, 
                   FEPrivate`Not[DynamicChart`click$40591$41408]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40591$41408, {{{1., 0}, {0, 1.}}, {
                 0.0854697993250911, 0.18081734818133094`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40591$41408}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.1398004326651296`]& ,
                  TagBoxNote->"1.1398004326651296"],
                 StyleBox["1.1398004326651296`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.1398004326651296`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40594$41408, 
                   FEPrivate`Not[DynamicChart`click$40594$41408]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40594$41408, {{{1., 0}, {0, 1.}}, {
                 0.12362569646846618`, 0.1572154164599855}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40594$41408}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.840420135827266]& ,
                  TagBoxNote->"8.840420135827266"],
                 StyleBox["8.840420135827266`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.840420135827266, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40597$41408, 
                   FEPrivate`Not[DynamicChart`click$40597$41408]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40597$41408, {{{1., 0}, {0, 1.}}, {
                 0.18858846822790232`, -0.06659121301983825}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40597$41408}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.821340700000118]& ,
                  TagBoxNote->"6.821340700000118"],
                 StyleBox["6.821340700000118`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.821340700000118, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40600$41408, 
                   FEPrivate`Not[DynamicChart`click$40600$41408]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40600$41408, {{{1., 0}, {
                  0, 1.}}, {-0.13197107407191458`, -0.1502785267704779}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40600$41408}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -193.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40639$41409 = False, 
         DynamicChart`click$40642$41409 = False, 
         DynamicChart`click$40645$41409 = False, 
         DynamicChart`click$40648$41409 = False, 
         DynamicChart`click$40651$41409 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {0.9490734485247048, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    30.38965753892837}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 9.230489862871728]& ,
                    TagBoxNote->"9.230489862871728"],
                   StyleBox["9.230489862871728`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.230489862871728, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40639$41409, 
                    FEPrivate`Not[DynamicChart`click$40639$41409]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40639$41409, {{{1., 0}, {
                    0, 1.}}, {-0.09138528207482037, 0.17790089999802003`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40639$41409}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.03674718571875957, 
                    0.9490734485247048}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.992389698736744`}, {-34.502183483065934`, \
-18.239198084593575`}}],
                    StatusArea[#, 4.150297680390871]& ,
                    TagBoxNote->"4.150297680390871"],
                   StyleBox["4.150297680390871`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.150297680390871, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40642$41409, 
                    FEPrivate`Not[DynamicChart`click$40642$41409]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40642$41409, {{{1., 0}, {0, 1.}}, {
                   0.1795498536517963, 0.08810136238230676}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40642$41409}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.5195244359865305, -0.03674718571875957}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.981714635310894`}, {-21.64856015328219, \
-10.969731328984146`}}],
                    StatusArea[#, 2.032488702642608]& ,
                    TagBoxNote->"2.032488702642608"],
                   StyleBox["2.032488702642608`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.032488702642608, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40645$41409, 
                    FEPrivate`Not[DynamicChart`click$40645$41409]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40645$41409, {{{1., 0}, {0, 1.}}, {
                   0.1923137894566462, -0.05491271605761969}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40645$41409}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.698142550138515, -0.5195244359865305}]},
                    
                    ImageSizeCache->{{4.068355768477321, 
                    34.90601239383916}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.171966371510816]& ,
                    TagBoxNote->"9.171966371510816"],
                   StyleBox["9.171966371510816`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.171966371510816, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40648$41409, 
                    FEPrivate`Not[DynamicChart`click$40648$41409]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40648$41409, {{{1., 0}, {
                    0, 1.}}, {-0.0076055989474998606`, \
-0.19985533484160434`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40648$41409}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.698142550138515}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-21.64856015328219, \
-12.035637158213067`}}],
                    StatusArea[#, 1.8669217013654062`]& ,
                    TagBoxNote->"1.8669217013654062"],
                   StyleBox["1.8669217013654062`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.8669217013654062`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40651$41409, 
                    FEPrivate`Not[DynamicChart`click$40651$41409]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40651$41409, {{{1., 0}, {
                    0, 1.}}, {-0.1951039080180587, -0.043982554224156714`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40651$41409}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.230489862871728]& ,
                  TagBoxNote->"9.230489862871728"],
                 StyleBox["9.230489862871728`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.230489862871728, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40639$41409, 
                   FEPrivate`Not[DynamicChart`click$40639$41409]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40639$41409, {{{1., 0}, {
                  0, 1.}}, {-0.09138528207482037, 0.17790089999802003`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40639$41409}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.150297680390871]& ,
                  TagBoxNote->"4.150297680390871"],
                 StyleBox["4.150297680390871`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.150297680390871, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40642$41409, 
                   FEPrivate`Not[DynamicChart`click$40642$41409]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40642$41409, {{{1., 0}, {0, 1.}}, {
                 0.1795498536517963, 0.08810136238230676}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40642$41409}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.032488702642608]& ,
                  TagBoxNote->"2.032488702642608"],
                 StyleBox["2.032488702642608`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.032488702642608, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40645$41409, 
                   FEPrivate`Not[DynamicChart`click$40645$41409]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40645$41409, {{{1., 0}, {0, 1.}}, {
                 0.1923137894566462, -0.05491271605761969}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40645$41409}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.171966371510816]& ,
                  TagBoxNote->"9.171966371510816"],
                 StyleBox["9.171966371510816`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.171966371510816, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40648$41409, 
                   FEPrivate`Not[DynamicChart`click$40648$41409]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40648$41409, {{{1., 0}, {
                  0, 1.}}, {-0.0076055989474998606`, -0.19985533484160434`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40648$41409}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.8669217013654062`]& ,
                  TagBoxNote->"1.8669217013654062"],
                 StyleBox["1.8669217013654062`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.8669217013654062`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40651$41409, 
                   FEPrivate`Not[DynamicChart`click$40651$41409]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40651$41409, {{{1., 0}, {
                  0, 1.}}, {-0.1951039080180587, -0.043982554224156714`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40651$41409}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40690$41410 = False, 
         DynamicChart`click$40693$41410 = False, 
         DynamicChart`click$40696$41410 = False, 
         DynamicChart`click$40699$41410 = False, 
         DynamicChart`click$40702$41410 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.7731855137484211`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    21.179866971463994`}, {-37.138335422621196`, \
-18.820133028536002`}}],
                    StatusArea[#, 6.664365130983974]& ,
                    TagBoxNote->"6.664365130983974"],
                   StyleBox["6.664365130983974`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.664365130983974, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40690$41410, 
                    FEPrivate`Not[DynamicChart`click$40690$41410]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40690$41410, {{{1., 0}, {
                    0, 1.}}, {-0.1549845362496174, 0.1264112080611962}}, {{1, 
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40690$41410}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8987535638915736, 
                    1.7731855137484211`}]},
                    
                    ImageSizeCache->{{15.172959532811454`, 
                    31.024519907398222`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 4.258625687030426]& ,
                    TagBoxNote->"4.258625687030426"],
                   StyleBox["4.258625687030426`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.258625687030426, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40693$41410, 
                    FEPrivate`Not[DynamicChart`click$40693$41410]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40693$41410, {{{1., 0}, {0, 1.}}, {
                   0.04653490616836649, 0.19451093158972155`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40693$41410}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.6388598453594083, 
                    0.8987535638915736}]},
                    
                    ImageSizeCache->{{18.3514398467178, 
                    36.992389698736716`}, {-34.02267359916257, \
-9.391433434838333}}],
                    StatusArea[#, 7.488427158260446]& ,
                    TagBoxNote->"7.488427158260446"],
                   StyleBox["7.488427158260446`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.488427158260446, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40696$41410, 
                    FEPrivate`Not[DynamicChart`click$40696$41410]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40696$41410, {{{1., 0}, {0, 1.}}, {
                   0.198313756233642, 0.025916290021984756`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40696$41410}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.5609609487189866`, -0.6388598453594083}]},
                    
                    ImageSizeCache->{{5.130331950696506, 
                    33.87378279646937}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.360944706076516]& ,
                    TagBoxNote->"9.360944706076516"],
                   StyleBox["9.360944706076516`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.360944706076516, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40699$41410, 
                    FEPrivate`Not[DynamicChart`click$40699$41410]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40699$41410, {{{1., 0}, {
                    0, 1.}}, {-0.005821991485963806, -0.19991524307850406`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40699$41410}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.5609609487189866`}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    21.179866971463994`}, {-21.64856015328219, \
-10.146138504541899`}}],
                    StatusArea[#, 2.827770752740552]& ,
                    TagBoxNote->"2.827770752740552"],
                   StyleBox["2.827770752740552`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.827770752740552, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40702$41410, 
                    FEPrivate`Not[DynamicChart`click$40702$41410]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40702$41410, {{{1., 0}, {
                    0, 1.}}, {-0.19163070180179273`, -0.05725097489958051}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40702$41410}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.664365130983974]& ,
                  TagBoxNote->"6.664365130983974"],
                 StyleBox["6.664365130983974`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.664365130983974, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40690$41410, 
                   FEPrivate`Not[DynamicChart`click$40690$41410]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40690$41410, {{{1., 0}, {
                  0, 1.}}, {-0.1549845362496174, 0.1264112080611962}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40690$41410}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.258625687030426]& ,
                  TagBoxNote->"4.258625687030426"],
                 StyleBox["4.258625687030426`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.258625687030426, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40693$41410, 
                   FEPrivate`Not[DynamicChart`click$40693$41410]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40693$41410, {{{1., 0}, {0, 1.}}, {
                 0.04653490616836649, 0.19451093158972155`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40693$41410}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.488427158260446]& ,
                  TagBoxNote->"7.488427158260446"],
                 StyleBox["7.488427158260446`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.488427158260446, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40696$41410, 
                   FEPrivate`Not[DynamicChart`click$40696$41410]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40696$41410, {{{1., 0}, {0, 1.}}, {
                 0.198313756233642, 0.025916290021984756`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40696$41410}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.360944706076516]& ,
                  TagBoxNote->"9.360944706076516"],
                 StyleBox["9.360944706076516`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.360944706076516, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40699$41410, 
                   FEPrivate`Not[DynamicChart`click$40699$41410]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40699$41410, {{{1., 0}, {
                  0, 1.}}, {-0.005821991485963806, -0.19991524307850406`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40699$41410}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.827770752740552]& ,
                  TagBoxNote->"2.827770752740552"],
                 StyleBox["2.827770752740552`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.827770752740552, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40702$41410, 
                   FEPrivate`Not[DynamicChart`click$40702$41410]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40702$41410, {{{1., 0}, {
                  0, 1.}}, {-0.19163070180179273`, -0.05725097489958051}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40702$41410}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -193.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40741$41411 = False, 
         DynamicChart`click$40744$41411 = False, 
         DynamicChart`click$40747$41411 = False, 
         DynamicChart`click$40750$41411 = False, 
         DynamicChart`click$40753$41411 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.5156976152382153`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    21.179866971463994`}, {-30.911897782396778`, \
-18.820133028536002`}}],
                    StatusArea[#, 1.3943938954421569`]& ,
                    TagBoxNote->"1.3943938954421569"],
                   StyleBox["1.3943938954421569`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.3943938954421569`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40741$41411, 
                    FEPrivate`Not[DynamicChart`click$40741$41411]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40741$41411, {{{1., 0}, {
                    0, 1.}}, {-0.19028605362704706`, 0.06157286573682093}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40741$41411}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.8780583219244886`, 
                    2.5156976152382153`}]},
                    
                    ImageSizeCache->{{5.536352996854239, 
                    21.179866971463998`}, {-36.72050735090454, \
-18.820133028536002`}}],
                    StatusArea[#, 1.4205582144130595`]& ,
                    TagBoxNote->"1.4205582144130595"],
                   StyleBox["1.4205582144130595`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.4205582144130595`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40744$41411, 
                    FEPrivate`Not[DynamicChart`click$40744$41411]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40744$41411, {{{1., 0}, {
                    0, 1.}}, {-0.11719482041996283`, 0.1620659559152775}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40744$41411}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.199715404732471, 
                    1.8780583219244886`}]},
                    
                    ImageSizeCache->{{13.568942311684435`, 
                    36.992389698736716`}, {-37.46108288055491, \
-4.083875066977303}}],
                    StatusArea[#, 6.85678689402236]& ,
                    TagBoxNote->"6.85678689402236"],
                   StyleBox["6.85678689402236`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.85678689402236, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40747$41411, 
                    FEPrivate`Not[DynamicChart`click$40747$41411]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40747$41411, {{{1., 0}, {0, 1.}}, {
                   0.18860612995375417`, 0.06654117329794838}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40747$41411}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4387987854865871`, -1.199715404732471}]},
                    
                    ImageSizeCache->{{18.351439846717806`, 
                    26.913851300960737`}, {-21.64856015328219, \
-3.145163972798393}}],
                    StatusArea[#, 0.5326394781834765]& ,
                    TagBoxNote->"0.5326394781834765"],
                   StyleBox["0.5326394781834765`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.5326394781834765, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40750$41411, 
                    FEPrivate`Not[DynamicChart`click$40750$41411]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40750$41411, {{{1., 0}, {0, 1.}}, {
                   0.049779009257312136`, -0.1937060924115719}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40750$41411}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4387987854865871`}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    23.26102532732854}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 3.7935520005603856`]& ,
                    TagBoxNote->"3.7935520005603856"],
                   StyleBox["3.7935520005603856`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.7935520005603856`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40753$41411, 
                    FEPrivate`Not[DynamicChart`click$40753$41411]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40753$41411, {{{1., 0}, {
                    0, 1.}}, {-0.1317866026184913, -0.15044032494738857`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40753$41411}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.3943938954421569`]& ,
                  TagBoxNote->"1.3943938954421569"],
                 StyleBox["1.3943938954421569`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.3943938954421569`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40741$41411, 
                   FEPrivate`Not[DynamicChart`click$40741$41411]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40741$41411, {{{1., 0}, {
                  0, 1.}}, {-0.19028605362704706`, 0.06157286573682093}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40741$41411}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.4205582144130595`]& ,
                  TagBoxNote->"1.4205582144130595"],
                 StyleBox["1.4205582144130595`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.4205582144130595`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40744$41411, 
                   FEPrivate`Not[DynamicChart`click$40744$41411]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40744$41411, {{{1., 0}, {
                  0, 1.}}, {-0.11719482041996283`, 0.1620659559152775}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40744$41411}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.85678689402236]& ,
                  TagBoxNote->"6.85678689402236"],
                 StyleBox["6.85678689402236`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.85678689402236, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40747$41411, 
                   FEPrivate`Not[DynamicChart`click$40747$41411]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40747$41411, {{{1., 0}, {0, 1.}}, {
                 0.18860612995375417`, 0.06654117329794838}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40747$41411}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.5326394781834765]& ,
                  TagBoxNote->"0.5326394781834765"],
                 StyleBox["0.5326394781834765`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.5326394781834765, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40750$41411, 
                   FEPrivate`Not[DynamicChart`click$40750$41411]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40750$41411, {{{1., 0}, {0, 1.}}, {
                 0.049779009257312136`, -0.1937060924115719}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40750$41411}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.7935520005603856`]& ,
                  TagBoxNote->"3.7935520005603856"],
                 StyleBox["3.7935520005603856`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.7935520005603856`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40753$41411, 
                   FEPrivate`Not[DynamicChart`click$40753$41411]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40753$41411, {{{1., 0}, {
                  0, 1.}}, {-0.1317866026184913, -0.15044032494738857`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40753$41411}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40792$41412 = False, 
         DynamicChart`click$40795$41412 = False, 
         DynamicChart`click$40798$41412 = False, 
         DynamicChart`click$40801$41412 = False, 
         DynamicChart`click$40804$41412 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.0910742334689925`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-35.368786632360525`, \
-18.820133028536002`}}],
                    StatusArea[#, 4.311253540289933]& ,
                    TagBoxNote->"4.311253540289933"],
                   StyleBox["4.311253540289933`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.311253540289933, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40792$41412, 
                    FEPrivate`Not[DynamicChart`click$40792$41412]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40792$41412, {{{1., 0}, {
                    0, 1.}}, {-0.17303879862013724`, 
                   0.10028745770084911`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$40792$41412}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1931150036623326`, 
                    2.0910742334689925`}]},
                    
                    ImageSizeCache->{{10.490698128322897`, 
                    27.0109909066464}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 3.6851613778412506`]& ,
                    TagBoxNote->"3.6851613778412506"],
                   StyleBox["3.6851613778412506`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.6851613778412506`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40795$41412, 
                    FEPrivate`Not[DynamicChart`click$40795$41412]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40795$41412, {{{1., 0}, {
                    0, 1.}}, {-0.014247580056354217`, 
                   0.19949187066779883`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$40795$41412}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8293538470192536, 
                    1.1931150036623326`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    31.858892710018793`}, {-36.34665079979338, \
-18.820133028536002`}}],
                    StatusArea[#, 1.492850143662496]& ,
                    TagBoxNote->"1.492850143662496"],
                   StyleBox["1.492850143662496`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.492850143662496, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40798$41412, 
                    FEPrivate`Not[DynamicChart`click$40798$41412]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40798$41412, {{{1., 0}, {0, 1.}}, {
                   0.10616299314504932`, 0.16949754831998076`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40798$41412}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.7727184638458655, 
                    0.8293538470192536}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.99238969873673}, {-33.310218880744635`, \
-7.781659514113073}}],
                    StatusArea[#, 6.574791826328454]& ,
                    TagBoxNote->"6.574791826328454"],
                   StyleBox["6.574791826328454`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.574791826328454, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40801$41412, 
                    FEPrivate`Not[DynamicChart`click$40801$41412]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40801$41412, {{{1., 0}, {0, 1.}}, {
                   0.1999198161927621, 0.005662781423666013}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40801$41412}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.7727184638458655}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    32.50187993170654}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.721692681848037]& ,
                    TagBoxNote->"9.721692681848037"],
                   StyleBox["9.721692681848037`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.721692681848037, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40804$41412, 
                    FEPrivate`Not[DynamicChart`click$40804$41412]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40804$41412, {{{1., 0}, {
                    0, 1.}}, {-0.07536370469011511, -0.18525742094550796`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40804$41412}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.311253540289933]& ,
                  TagBoxNote->"4.311253540289933"],
                 StyleBox["4.311253540289933`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.311253540289933, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40792$41412, 
                   FEPrivate`Not[DynamicChart`click$40792$41412]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40792$41412, {{{1., 0}, {
                  0, 1.}}, {-0.17303879862013724`, 0.10028745770084911`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40792$41412}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.6851613778412506`]& ,
                  TagBoxNote->"3.6851613778412506"],
                 StyleBox["3.6851613778412506`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.6851613778412506`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40795$41412, 
                   FEPrivate`Not[DynamicChart`click$40795$41412]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40795$41412, {{{1., 0}, {
                  0, 1.}}, {-0.014247580056354217`, 0.19949187066779883`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40795$41412}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.492850143662496]& ,
                  TagBoxNote->"1.492850143662496"],
                 StyleBox["1.492850143662496`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.492850143662496, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40798$41412, 
                   FEPrivate`Not[DynamicChart`click$40798$41412]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40798$41412, {{{1., 0}, {0, 1.}}, {
                 0.10616299314504932`, 0.16949754831998076`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40798$41412}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.574791826328454]& ,
                  TagBoxNote->"6.574791826328454"],
                 StyleBox["6.574791826328454`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.574791826328454, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40801$41412, 
                   FEPrivate`Not[DynamicChart`click$40801$41412]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40801$41412, {{{1., 0}, {0, 1.}}, {
                 0.1999198161927621, 0.005662781423666013}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40801$41412}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.721692681848037]& ,
                  TagBoxNote->"9.721692681848037"],
                 StyleBox["9.721692681848037`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.721692681848037, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40804$41412, 
                   FEPrivate`Not[DynamicChart`click$40804$41412]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40804$41412, {{{1., 0}, {
                  0, 1.}}, {-0.07536370469011511, -0.18525742094550796`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40804$41412}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40843$41413 = False, 
         DynamicChart`click$40846$41413 = False, 
         DynamicChart`click$40849$41413 = False, 
         DynamicChart`click$40852$41413 = False, 
         DynamicChart`click$40855$41413 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.8557580050056166`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-36.82340220661686, \
-18.820133028536002`}}],
                    StatusArea[#, 5.839228604209584]& ,
                    TagBoxNote->"5.839228604209584"],
                   StyleBox["5.839228604209584`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.839228604209584, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40843$41413, 
                    FEPrivate`Not[DynamicChart`click$40843$41413]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40843$41413, {{{1., 0}, {
                    0, 1.}}, {-0.1600700268718177, 0.11990657403685406`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40843$41413}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.30341711450901565`, 
                    1.8557580050056166`}]},
                    
                    ImageSizeCache->{{13.906212782004253`, 
                    36.27009085090447}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 7.049485982706063]& ,
                    TagBoxNote->"7.049485982706063"],
                   StyleBox["7.049485982706063`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.049485982706063, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40846$41413, 
                    FEPrivate`Not[DynamicChart`click$40846$41413]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40846$41413, {{{1., 0}, {0, 1.}}, {
                   0.09433841579344404, 0.17635266741839567`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40846$41413}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.14909947349214425`, 
                    0.30341711450901565`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.99238969873673}, {-26.37307264335793, \
-16.47121981926525}}],
                    StatusArea[#, 2.054967026627544]& ,
                    TagBoxNote->"2.054967026627544"],
                   StyleBox["2.054967026627544`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.054967026627544, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40849$41413, 
                    FEPrivate`Not[DynamicChart`click$40849$41413]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40849$41413, {{{1., 0}, {0, 1.}}, {
                   0.19940494694955535`, 0.015416456533361446`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40849$41413}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4475106211187496`, -0.14909947349214425`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.81695371215295}, {-21.648560153282194`, \
-3.1276283232096027`}}],
                    StatusArea[#, 5.896340965453096]& ,
                    TagBoxNote->"5.896340965453096"],
                   StyleBox["5.896340965453096`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.896340965453096, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40852$41413, 
                    FEPrivate`Not[DynamicChart`click$40852$41413]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40852$41413, {{{1., 0}, {0, 1.}}, {
                   0.1395843185264834, -0.14323483522347918`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40852$41413}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4475106211187496`}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    23.124390325354426`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 7.693160448565127]& ,
                    TagBoxNote->"7.693160448565127"],
                   StyleBox["7.693160448565127`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.693160448565127, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40855$41413, 
                    FEPrivate`Not[DynamicChart`click$40855$41413]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40855$41413, {{{1., 0}, {
                    0, 1.}}, {-0.13244065597905005`, -0.14986484792585258`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40855$41413}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.839228604209584]& ,
                  TagBoxNote->"5.839228604209584"],
                 StyleBox["5.839228604209584`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.839228604209584, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40843$41413, 
                   FEPrivate`Not[DynamicChart`click$40843$41413]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40843$41413, {{{1., 0}, {
                  0, 1.}}, {-0.1600700268718177, 0.11990657403685406`}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40843$41413}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.049485982706063]& ,
                  TagBoxNote->"7.049485982706063"],
                 StyleBox["7.049485982706063`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.049485982706063, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40846$41413, 
                   FEPrivate`Not[DynamicChart`click$40846$41413]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40846$41413, {{{1., 0}, {0, 1.}}, {
                 0.09433841579344404, 0.17635266741839567`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40846$41413}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.054967026627544]& ,
                  TagBoxNote->"2.054967026627544"],
                 StyleBox["2.054967026627544`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.054967026627544, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40849$41413, 
                   FEPrivate`Not[DynamicChart`click$40849$41413]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40849$41413, {{{1., 0}, {0, 1.}}, {
                 0.19940494694955535`, 0.015416456533361446`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40849$41413}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.896340965453096]& ,
                  TagBoxNote->"5.896340965453096"],
                 StyleBox["5.896340965453096`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.896340965453096, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40852$41413, 
                   FEPrivate`Not[DynamicChart`click$40852$41413]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40852$41413, {{{1., 0}, {0, 1.}}, {
                 0.1395843185264834, -0.14323483522347918`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40852$41413}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.693160448565127]& ,
                  TagBoxNote->"7.693160448565127"],
                 StyleBox["7.693160448565127`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.693160448565127, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40855$41413, 
                   FEPrivate`Not[DynamicChart`click$40855$41413]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40855$41413, {{{1., 0}, {
                  0, 1.}}, {-0.13244065597905005`, -0.14986484792585258`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40855$41413}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40894$41414 = False, 
         DynamicChart`click$40897$41414 = False, 
         DynamicChart`click$40900$41414 = False, 
         DynamicChart`click$40903$41414 = False, 
         DynamicChart`click$40906$41414 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.89598813243016, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-36.63234008509434, \
-18.820133028536002`}}],
                    StatusArea[#, 4.806341562728695]& ,
                    TagBoxNote->"4.806341562728695"],
                   StyleBox["4.806341562728695`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.806341562728695, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40894$41414, 
                    FEPrivate`Not[DynamicChart`click$40894$41414]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40894$41414, {{{1., 0}, {
                    0, 1.}}, {-0.16244941026251125`, 
                   0.11666271514653817`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$40894$41414}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.2794422314816631`, 
                    1.89598813243016}]},
                    
                    ImageSizeCache->{{13.29948834699616, 
                    25.72200647306395}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 2.379029731122017]& ,
                    TagBoxNote->"2.379029731122017"],
                   StyleBox["2.379029731122017`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.379029731122017, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40897$41414, 
                    FEPrivate`Not[DynamicChart`click$40897$41414]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40897$41414, {{{1., 0}, {
                    0, 1.}}, {-0.0033836096017568007`, 
                   0.1999713759168119}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40897$41414}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.2588743835913985`, 
                    1.2794422314816631`}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    26.03254681746902}, {-36.794676610926444`, \
-18.820133028536002`}}],
                    StatusArea[#, 0.07936395580743927]& ,
                    TagBoxNote->"0.07936395580743927"],
                   StyleBox["0.07936395580743927`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.07936395580743927, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40900$41414, 
                    FEPrivate`Not[DynamicChart`click$40900$41414]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40900$41414, {{{1., 0}, {0, 1.}}, {
                   0.05941693381457472, 0.19097022798351174`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40900$41414}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.9910213169233373, 
                    1.2588743835913985`}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.992389698736744`}, {-36.69805759714036, \
-5.591599017350713}}],
                    StatusArea[#, 8.6815413989676]& ,
                    TagBoxNote->"8.6815413989676"],
                   StyleBox["8.6815413989676`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.6815413989676, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40903$41414, 
                    FEPrivate`Not[DynamicChart`click$40903$41414]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40903$41414, {{{1., 0}, {0, 1.}}, {
                   0.198209047693256, 0.02670530682341188}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40903$41414}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.9910213169233373}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    29.842531856788305`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 8.298284265546844]& ,
                    TagBoxNote->"8.298284265546844"],
                   StyleBox["8.298284265546844`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.298284265546844, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40906$41414, 
                    FEPrivate`Not[DynamicChart`click$40906$41414]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40906$41414, {{{1., 0}, {
                    0, 1.}}, {-0.09509619055632224, -0.17594520323576784`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40906$41414}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.806341562728695]& ,
                  TagBoxNote->"4.806341562728695"],
                 StyleBox["4.806341562728695`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.806341562728695, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40894$41414, 
                   FEPrivate`Not[DynamicChart`click$40894$41414]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40894$41414, {{{1., 0}, {
                  0, 1.}}, {-0.16244941026251125`, 0.11666271514653817`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40894$41414}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.379029731122017]& ,
                  TagBoxNote->"2.379029731122017"],
                 StyleBox["2.379029731122017`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.379029731122017, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40897$41414, 
                   FEPrivate`Not[DynamicChart`click$40897$41414]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40897$41414, {{{1., 0}, {
                  0, 1.}}, {-0.0033836096017568007`, 0.1999713759168119}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40897$41414}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.07936395580743927]& ,
                  TagBoxNote->"0.07936395580743927"],
                 StyleBox["0.07936395580743927`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.07936395580743927, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40900$41414, 
                   FEPrivate`Not[DynamicChart`click$40900$41414]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40900$41414, {{{1., 0}, {0, 1.}}, {
                 0.05941693381457472, 0.19097022798351174`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40900$41414}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.6815413989676]& ,
                  TagBoxNote->"8.6815413989676"],
                 StyleBox["8.6815413989676`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.6815413989676, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40903$41414, 
                   FEPrivate`Not[DynamicChart`click$40903$41414]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40903$41414, {{{1., 0}, {0, 1.}}, {
                 0.198209047693256, 0.02670530682341188}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40903$41414}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.298284265546844]& ,
                  TagBoxNote->"8.298284265546844"],
                 StyleBox["8.298284265546844`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.298284265546844, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40906$41414, 
                   FEPrivate`Not[DynamicChart`click$40906$41414]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40906$41414, {{{1., 0}, {
                  0, 1.}}, {-0.09509619055632224, -0.17594520323576784`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40906$41414}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -580.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40945$41415 = False, 
         DynamicChart`click$40948$41415 = False, 
         DynamicChart`click$40951$41415 = False, 
         DynamicChart`click$40954$41415 = False, 
         DynamicChart`click$40957$41415 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.933058190440263, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-24.922168798764787`, \
-18.820133028536002`}}],
                    StatusArea[#, 1.1830832081083749`]& ,
                    TagBoxNote->"1.1830832081083749"],
                   StyleBox["1.1830832081083749`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.1830832081083749`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40945$41415, 
                    FEPrivate`Not[DynamicChart`click$40945$41415]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40945$41415, {{{1., 0}, {
                    0, 1.}}, {-0.19891381902590363`, 0.02081568160138083}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40945$41415}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.6519877186929763`, 
                    2.933058190440263}]},
                    
                    ImageSizeCache->{{2.8814895741171433`, 
                    21.17986697146402}, {-37.40899309691845, \
-18.820133028536002`}}],
                    StatusArea[#, 7.267925601539144]& ,
                    TagBoxNote->"7.267925601539144"],
                   StyleBox["7.267925601539144`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.267925601539144, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40948$41415, 
                    FEPrivate`Not[DynamicChart`click$40948$41415]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40948$41415, {{{1., 0}, {
                    0, 1.}}, {-0.132136355416897, 0.1501332194324077}}, {{1, 
                  0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40948$41415}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.13152291107372083`, 
                    1.6519877186929763`}]},
                    
                    ImageSizeCache->{{17.069009174259648`, 
                    36.855822042262844`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 8.62608681196361]& ,
                    TagBoxNote->"8.62608681196361"],
                   StyleBox["8.62608681196361`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.62608681196361, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40951$41415, 
                    FEPrivate`Not[DynamicChart`click$40951$41415]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40951$41415, {{{1., 0}, {0, 1.}}, {
                   0.12560941040405663`, 0.15563507322562378`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40951$41415}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.5679238485013762`, 
                    0.13152291107372083`}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.992389698736744`}, {-23.722278460770696`, \
-3.007675536820976}}],
                    StatusArea[#, 9.641509100995908]& ,
                    TagBoxNote->"9.641509100995908"],
                   StyleBox["9.641509100995908`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.641509100995908, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40954$41415, 
                    FEPrivate`Not[DynamicChart`click$40954$41415]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40954$41415, {{{1., 0}, {0, 1.}}, {
                   0.15059821891131214`, -0.131606141424861}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40954$41415}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.5679238485013762`}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.22528803730131}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 8.927930234193877]& ,
                    TagBoxNote->"8.927930234193877"],
                   StyleBox["8.927930234193877`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.927930234193877, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40957$41415, 
                    FEPrivate`Not[DynamicChart`click$40957$41415]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40957$41415, {{{1., 0}, {
                    0, 1.}}, {-0.14121809555837223`, -0.1416243251947435}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$40957$41415}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.1830832081083749`]& ,
                  TagBoxNote->"1.1830832081083749"],
                 StyleBox["1.1830832081083749`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.1830832081083749`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40945$41415, 
                   FEPrivate`Not[DynamicChart`click$40945$41415]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40945$41415, {{{1., 0}, {
                  0, 1.}}, {-0.19891381902590363`, 0.02081568160138083}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40945$41415}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.267925601539144]& ,
                  TagBoxNote->"7.267925601539144"],
                 StyleBox["7.267925601539144`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.267925601539144, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40948$41415, 
                   FEPrivate`Not[DynamicChart`click$40948$41415]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40948$41415, {{{1., 0}, {
                  0, 1.}}, {-0.132136355416897, 0.1501332194324077}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40948$41415}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.62608681196361]& ,
                  TagBoxNote->"8.62608681196361"],
                 StyleBox["8.62608681196361`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.62608681196361, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40951$41415, 
                   FEPrivate`Not[DynamicChart`click$40951$41415]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40951$41415, {{{1., 0}, {0, 1.}}, {
                 0.12560941040405663`, 0.15563507322562378`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40951$41415}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.641509100995908]& ,
                  TagBoxNote->"9.641509100995908"],
                 StyleBox["9.641509100995908`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.641509100995908, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40954$41415, 
                   FEPrivate`Not[DynamicChart`click$40954$41415]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40954$41415, {{{1., 0}, {0, 1.}}, {
                 0.15059821891131214`, -0.131606141424861}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40954$41415}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.927930234193877]& ,
                  TagBoxNote->"8.927930234193877"],
                 StyleBox["8.927930234193877`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.927930234193877, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40957$41415, 
                   FEPrivate`Not[DynamicChart`click$40957$41415]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40957$41415, {{{1., 0}, {
                  0, 1.}}, {-0.14121809555837223`, -0.1416243251947435}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$40957$41415}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -566.9251648648292},
       ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$40996$41416 = False, 
         DynamicChart`click$40999$41416 = False, 
         DynamicChart`click$41002$41416 = False, 
         DynamicChart`click$41005$41416 = False, 
         DynamicChart`click$41008$41416 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.3972851791529324`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    23.90976987525918}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 5.841852138489475]& ,
                    TagBoxNote->"5.841852138489475"],
                   StyleBox["5.841852138489475`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.841852138489475, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40996$41416, 
                    FEPrivate`Not[DynamicChart`click$40996$41416]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40996$41416, {{{1., 0}, {
                    0, 1.}}, {-0.12863577785867483`, 0.1531431900369509}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40996$41416}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.6291873456554038, 
                    1.3972851791529324`}]},
                    
                    ImageSizeCache->{{18.3514398467178, 
                    36.992389698736716`}, {-37.223652613244255`, \
-9.514654475550834}}],
                    StatusArea[#, 6.786849810675545]& ,
                    TagBoxNote->"6.786849810675545"],
                   StyleBox["6.786849810675545`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.786849810675545, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$40999$41416, 
                    FEPrivate`Not[DynamicChart`click$40999$41416]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$40999$41416, {{{1., 0}, {0, 1.}}, {
                   0.18543104029041632`, 0.07493550091121036}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$40999$41416}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.6187792904392158`, -0.6291873456554038}]},
                    
                    ImageSizeCache->{{17.592999256250042`, 
                    33.964386669147174`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 3.3142378299638064`]& ,
                    TagBoxNote->"3.3142378299638064"],
                   StyleBox["3.3142378299638064`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.3142378299638064`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41002$41416, 
                    FEPrivate`Not[DynamicChart`click$41002$41416]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$41002$41416, {{{1., 0}, {0, 1.}}, {
                   0.0864187225957906, -0.18036575169613492`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41002$41416}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.132717533591582, -1.6187792904392158`}]},
                    
                    ImageSizeCache->{{2.5395398738152366`, 
                    21.179866971463987`}, {-21.648560153282194`, \
-3.025809906880955}}],
                    StatusArea[#, 5.07032360573697]& ,
                    TagBoxNote->"5.07032360573697"],
                   StyleBox["5.07032360573697`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.07032360573697, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41005$41416, 
                    FEPrivate`Not[DynamicChart`click$41005$41416]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41005$41416, {{{1., 0}, {
                    0, 1.}}, {-0.14415948637993337`, -0.13862915453350283`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41005$41416}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -3.132717533591582}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    21.179866971463994`}, {-21.64856015328219, \
-18.679796834201774`}}],
                    StatusArea[#, 0.02972362355876257]& ,
                    TagBoxNote->"0.02972362355876257"],
                   StyleBox["0.02972362355876257`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.02972362355876257, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41008$41416, 
                    FEPrivate`Not[DynamicChart`click$41008$41416]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41008$41416, {{{1., 0}, {
                    0, 1.}}, {-0.19999803080935688`, \
-0.0008875090870186809}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41008$41416}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.841852138489475]& ,
                  TagBoxNote->"5.841852138489475"],
                 StyleBox["5.841852138489475`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.841852138489475, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40996$41416, 
                   FEPrivate`Not[DynamicChart`click$40996$41416]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40996$41416, {{{1., 0}, {
                  0, 1.}}, {-0.12863577785867483`, 0.1531431900369509}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40996$41416}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.786849810675545]& ,
                  TagBoxNote->"6.786849810675545"],
                 StyleBox["6.786849810675545`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.786849810675545, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$40999$41416, 
                   FEPrivate`Not[DynamicChart`click$40999$41416]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$40999$41416, {{{1., 0}, {0, 1.}}, {
                 0.18543104029041632`, 0.07493550091121036}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$40999$41416}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.3142378299638064`]& ,
                  TagBoxNote->"3.3142378299638064"],
                 StyleBox["3.3142378299638064`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.3142378299638064`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41002$41416, 
                   FEPrivate`Not[DynamicChart`click$41002$41416]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41002$41416, {{{1., 0}, {0, 1.}}, {
                 0.0864187225957906, -0.18036575169613492`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41002$41416}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.07032360573697]& ,
                  TagBoxNote->"5.07032360573697"],
                 StyleBox["5.07032360573697`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.07032360573697, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41005$41416, 
                   FEPrivate`Not[DynamicChart`click$41005$41416]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41005$41416, {{{1., 0}, {
                  0, 1.}}, {-0.14415948637993337`, -0.13862915453350283`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41005$41416}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.02972362355876257]& ,
                  TagBoxNote->"0.02972362355876257"],
                 StyleBox["0.02972362355876257`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.02972362355876257, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41008$41416, 
                   FEPrivate`Not[DynamicChart`click$41008$41416]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41008$41416, {{{1., 0}, {
                  0, 1.}}, {-0.19999803080935688`, -0.0008875090870186809}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41008$41416}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -580.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41047$41417 = False, 
         DynamicChart`click$41050$41417 = False, 
         DynamicChart`click$41053$41417 = False, 
         DynamicChart`click$41056$41417 = False, 
         DynamicChart`click$41059$41417 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0476031830362333`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    29.080572943590617`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 9.504523603499216]& ,
                    TagBoxNote->"9.504523603499216"],
                   StyleBox["9.504523603499216`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.504523603499216, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41047$41417, 
                    FEPrivate`Not[DynamicChart`click$41047$41417]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41047$41417, {{{1., 0}, {
                    0, 1.}}, {-0.10003512669081516`, 
                   0.17318479560271036`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$41047$41417}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8173388649256981, 
                    1.0476031830362333`}]},
                    
                    ImageSizeCache->{{18.351439846717806`, 
                    31.99823315797289}, {-35.34581243768285, \
-18.820133028536002`}}],
                    StatusArea[#, 1.045159336902815]& ,
                    TagBoxNote->"1.045159336902815"],
                   StyleBox["1.045159336902815`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.045159336902815, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41050$41417, 
                    FEPrivate`Not[DynamicChart`click$41050$41417]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41050$41417, {{{1., 0}, {0, 1.}}, {
                   0.11917026740628787`, 0.16061895083181763`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41050$41417}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.10694315203264404`, 
                    0.8173388649256981}]},
                    
                    ImageSizeCache->{{18.351439846717806`, 
                    36.992389698736716`}, {-33.18107193758648, \
-17.13231352404736}}],
                    StatusArea[#, 4.195274317281113]& ,
                    TagBoxNote->"4.195274317281113"],
                   StyleBox["4.195274317281113`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.195274317281113, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41053$41417, 
                    FEPrivate`Not[DynamicChart`click$41053$41417]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41053$41417, {{{1., 0}, {0, 1.}}, {
                   0.1875155394944361, 0.06955517556667201}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41053$41417}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.4484542721344003`, -0.10694315203264404`}]},
                    
                    ImageSizeCache->{{18.351439846717806`, 
                    36.902053216410465`}, {-21.64856015328219, \
-3.125800358952695}}],
                    StatusArea[#, 6.089058366656047]& ,
                    TagBoxNote->"6.089058366656047"],
                   StyleBox["6.089058366656047`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.089058366656047, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41056$41417, 
                    FEPrivate`Not[DynamicChart`click$41056$41417]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41056$41417, {{{1., 0}, {0, 1.}}, {
                   0.14250602050822403`, -0.14032830833053478`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41056$41417}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4484542721344003`}]},
                    
                    ImageSizeCache->{{2.538917119445083, 
                    23.10958121377204}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 7.68507861994124]& ,
                    TagBoxNote->"7.68507861994124"],
                   StyleBox["7.68507861994124`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.68507861994124, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41059$41417, 
                    FEPrivate`Not[DynamicChart`click$41059$41417]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41059$41417, {{{1., 0}, {
                    0, 1.}}, {-0.13251135129248082`, -0.14980234236700288`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41059$41417}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.504523603499216]& ,
                  TagBoxNote->"9.504523603499216"],
                 StyleBox["9.504523603499216`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.504523603499216, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41047$41417, 
                   FEPrivate`Not[DynamicChart`click$41047$41417]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41047$41417, {{{1., 0}, {
                  0, 1.}}, {-0.10003512669081516`, 0.17318479560271036`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41047$41417}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.045159336902815]& ,
                  TagBoxNote->"1.045159336902815"],
                 StyleBox["1.045159336902815`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.045159336902815, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41050$41417, 
                   FEPrivate`Not[DynamicChart`click$41050$41417]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41050$41417, {{{1., 0}, {0, 1.}}, {
                 0.11917026740628787`, 0.16061895083181763`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41050$41417}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.195274317281113]& ,
                  TagBoxNote->"4.195274317281113"],
                 StyleBox["4.195274317281113`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.195274317281113, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41053$41417, 
                   FEPrivate`Not[DynamicChart`click$41053$41417]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41053$41417, {{{1., 0}, {0, 1.}}, {
                 0.1875155394944361, 0.06955517556667201}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41053$41417}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.089058366656047]& ,
                  TagBoxNote->"6.089058366656047"],
                 StyleBox["6.089058366656047`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.089058366656047, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41056$41417, 
                   FEPrivate`Not[DynamicChart`click$41056$41417]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41056$41417, {{{1., 0}, {0, 1.}}, {
                 0.14250602050822403`, -0.14032830833053478`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41056$41417}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.68507861994124]& ,
                  TagBoxNote->"7.68507861994124"],
                 StyleBox["7.68507861994124`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.68507861994124, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41059$41417, 
                   FEPrivate`Not[DynamicChart`click$41059$41417]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41059$41417, {{{1., 0}, {
                  0, 1.}}, {-0.13251135129248082`, -0.14980234236700288`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41059$41417}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {195.42857142857142, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41098$41418 = False, 
         DynamicChart`click$41101$41418 = False, 
         DynamicChart`click$41104$41418 = False, 
         DynamicChart`click$41107$41418 = False, 
         DynamicChart`click$41110$41418 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {3.0976259511425295`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-22.34356067024899, \
-18.820133028536002`}}],
                    StatusArea[#, 0.18210476313693214`]& ,
                    TagBoxNote->"0.18210476313693214"],
                   StyleBox["0.18210476313693214`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.18210476313693214`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41098$41418, 
                    FEPrivate`Not[DynamicChart`click$41098$41418]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41098$41418, {{{1., 0}, {
                    0, 1.}}, {-0.19995167517309734`, 
                   0.004396316125141067}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$41098$41418}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.8532264478482463`, 
                    3.0976259511425295`}]},
                    ImageSizeCache->{{2.554198021578461, 
                    21.179866971464012`}, {-36.83460691489003, \
-18.820133028536002`}}],
                    StatusArea[#, 5.154152214779668]& ,
                    TagBoxNote->"5.154152214779668"],
                   StyleBox["5.154152214779668`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.154152214779668, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41101$41418, 
                    FEPrivate`Not[DynamicChart`click$41101$41418]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41101$41418, {{{1., 0}, {
                    0, 1.}}, {-0.1572392957588798, 0.12359532300718962`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41101$41418}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.263487949952129, 
                    1.8532264478482463`}]},
                    
                    ImageSizeCache->{{13.944642965220272`, 
                    36.99238969873673}, {-37.46108288055491, \
-14.701766209908733`}}],
                    StatusArea[#, 8.767174988898063]& ,
                    TagBoxNote->"8.767174988898063"],
                   StyleBox["8.767174988898063`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.767174988898063, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41104$41418, 
                    FEPrivate`Not[DynamicChart`click$41104$41418]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41104$41418, {{{1., 0}, {0, 1.}}, {
                   0.14007561969441687`, 0.14275440717268625`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41104$41418}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-2.6452292941546647`, -0.263487949952129}]},
                    
                    ImageSizeCache->{{4.4471683563423205`, 
                    36.44665870213704}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.864884542107319]& ,
                    TagBoxNote->"9.864884542107319"],
                   StyleBox["9.864884542107319`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.864884542107319, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41107$41418, 
                    FEPrivate`Not[DynamicChart`click$41107$41418]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41107$41418, {{{1., 0}, {0, 1.}}, {
                   0.023234955540569244`, -0.19864575716845245`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41107$41418}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -2.6452292941546647`}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    21.17986697146401}, {-21.64856015328219, \
-11.28972073421589}}],
                    StatusArea[#, 2.055876992553758]& ,
                    TagBoxNote->"2.055876992553758"],
                   StyleBox["2.055876992553758`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[2.055876992553758, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41110$41418, 
                    FEPrivate`Not[DynamicChart`click$41110$41418]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41110$41418, {{{1., 0}, {
                    0, 1.}}, {-0.1938721358696376, -0.04912835162454335}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41110$41418}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.18210476313693214`]& ,
                  TagBoxNote->"0.18210476313693214"],
                 StyleBox["0.18210476313693214`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.18210476313693214`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41098$41418, 
                   FEPrivate`Not[DynamicChart`click$41098$41418]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41098$41418, {{{1., 0}, {
                  0, 1.}}, {-0.19995167517309734`, 0.004396316125141067}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41098$41418}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.154152214779668]& ,
                  TagBoxNote->"5.154152214779668"],
                 StyleBox["5.154152214779668`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.154152214779668, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41101$41418, 
                   FEPrivate`Not[DynamicChart`click$41101$41418]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41101$41418, {{{1., 0}, {
                  0, 1.}}, {-0.1572392957588798, 0.12359532300718962`}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41101$41418}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.767174988898063]& ,
                  TagBoxNote->"8.767174988898063"],
                 StyleBox["8.767174988898063`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.767174988898063, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41104$41418, 
                   FEPrivate`Not[DynamicChart`click$41104$41418]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41104$41418, {{{1., 0}, {0, 1.}}, {
                 0.14007561969441687`, 0.14275440717268625`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41104$41418}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.864884542107319]& ,
                  TagBoxNote->"9.864884542107319"],
                 StyleBox["9.864884542107319`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.864884542107319, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41107$41418, 
                   FEPrivate`Not[DynamicChart`click$41107$41418]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41107$41418, {{{1., 0}, {0, 1.}}, {
                 0.023234955540569244`, -0.19864575716845245`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41107$41418}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 2.055876992553758]& ,
                  TagBoxNote->"2.055876992553758"],
                 StyleBox["2.055876992553758`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[2.055876992553758, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41110$41418, 
                   FEPrivate`Not[DynamicChart`click$41110$41418]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41110$41418, {{{1., 0}, {
                  0, 1.}}, {-0.1938721358696376, -0.04912835162454335}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41110$41418}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {586.2857142857142, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41149$41419 = False, 
         DynamicChart`click$41152$41419 = False, 
         DynamicChart`click$41155$41419 = False, 
         DynamicChart`click$41158$41419 = False, 
         DynamicChart`click$41161$41419 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.4621433494648055`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    22.894566187455375`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 7.00955778381752]& ,
                    TagBoxNote->"7.00955778381752"],
                   StyleBox["7.00955778381752`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[7.00955778381752, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41149$41419, 
                    FEPrivate`Not[DynamicChart`click$41149$41419]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41149$41419, {{{1., 0}, {
                    0, 1.}}, {-0.13353356729672727`, 
                   0.14889186144652236`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$41149$41419}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.0133358957164824`, 
                    1.4621433494648055`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    29.545210533405744`}, {-37.36783754122834, \
-18.820133028536002`}}],
                    StatusArea[#, 1.873198418749503]& ,
                    TagBoxNote->"1.873198418749503"],
                   StyleBox["1.873198418749503`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.873198418749503, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41152$41419, 
                    FEPrivate`Not[DynamicChart`click$41152$41419]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41152$41419, {{{1., 0}, {0, 1.}}, {
                   0.06538665633266764, 0.1890094843483618}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41152$41419}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.55281271227049, 
                    1.0133358957164824`}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    36.99238969873673}, {-35.06708846644666, \
-10.517245139424858`}}],
                    StatusArea[#, 6.536671954768963]& ,
                    TagBoxNote->"6.536671954768963"],
                   StyleBox["6.536671954768963`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.536671954768963, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41155$41419, 
                    FEPrivate`Not[DynamicChart`click$41155$41419]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41155$41419, {{{1., 0}, {0, 1.}}, {
                   0.19472134493175236`, 0.04564644376037988}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41155$41419}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.9349421400010964, -0.55281271227049}]},
                    
                    ImageSizeCache->{{18.35143984671782, 
                    34.637129980760065`}, {-21.648560153282194`, \
-6.097935132773298}}],
                    StatusArea[#, 1.5949027446055393`]& ,
                    TagBoxNote->"1.5949027446055393"],
                   StyleBox["1.5949027446055393`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.5949027446055393`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41158$41419, 
                    FEPrivate`Not[DynamicChart`click$41158$41419]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41158$41419, {{{1., 0}, {0, 1.}}, {
                   0.14716970249760072`, -0.1354292385962784}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41158$41419}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.9349421400010964}]},
                    
                    ImageSizeCache->{{2.538917119445097, 
                    30.570370456451776`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.209950098344532]& ,
                    TagBoxNote->"9.209950098344532"],
                   StyleBox["9.209950098344532`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.209950098344532, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41161$41419, 
                    FEPrivate`Not[DynamicChart`click$41161$41419]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41161$41419, {{{1., 0}, {
                    0, 1.}}, {-0.09012602515568643, -0.1785421507365602}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41161$41419}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 7.00955778381752]& ,
                  TagBoxNote->"7.00955778381752"],
                 StyleBox["7.00955778381752`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[7.00955778381752, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41149$41419, 
                   FEPrivate`Not[DynamicChart`click$41149$41419]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41149$41419, {{{1., 0}, {
                  0, 1.}}, {-0.13353356729672727`, 0.14889186144652236`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41149$41419}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.873198418749503]& ,
                  TagBoxNote->"1.873198418749503"],
                 StyleBox["1.873198418749503`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.873198418749503, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41152$41419, 
                   FEPrivate`Not[DynamicChart`click$41152$41419]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41152$41419, {{{1., 0}, {0, 1.}}, {
                 0.06538665633266764, 0.1890094843483618}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41152$41419}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.536671954768963]& ,
                  TagBoxNote->"6.536671954768963"],
                 StyleBox["6.536671954768963`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.536671954768963, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41155$41419, 
                   FEPrivate`Not[DynamicChart`click$41155$41419]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41155$41419, {{{1., 0}, {0, 1.}}, {
                 0.19472134493175236`, 0.04564644376037988}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41155$41419}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.5949027446055393`]& ,
                  TagBoxNote->"1.5949027446055393"],
                 StyleBox["1.5949027446055393`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.5949027446055393`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41158$41419, 
                   FEPrivate`Not[DynamicChart`click$41158$41419]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41158$41419, {{{1., 0}, {0, 1.}}, {
                 0.14716970249760072`, -0.1354292385962784}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41158$41419}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.209950098344532]& ,
                  TagBoxNote->"9.209950098344532"],
                 StyleBox["9.209950098344532`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.209950098344532, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41161$41419, 
                   FEPrivate`Not[DynamicChart`click$41161$41419]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41161$41419, {{{1., 0}, {
                  0, 1.}}, {-0.09012602515568643, -0.1785421507365602}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41161$41419}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {977.1428571428571, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41200$41420 = False, 
         DynamicChart`click$41203$41420 = False, 
         DynamicChart`click$41206$41420 = False, 
         DynamicChart`click$41209$41420 = False, 
         DynamicChart`click$41212$41420 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.7349724856772544`, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-27.902529000000513`, \
-18.820133028536002`}}],
                    StatusArea[#, 1.1789030162226322`]& ,
                    TagBoxNote->"1.1789030162226322"],
                   StyleBox["1.1789030162226322`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.1789030162226322`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41200$41420, 
                    FEPrivate`Not[DynamicChart`click$41200$41420]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41200$41420, {{{1., 0}, {
                    0, 1.}}, {-0.19588071955129427`, 0.04038246783032462}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41200$41420}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.243541413988532, 
                    2.7349724856772544`}]},
                    
                    ImageSizeCache->{{3.8282257167535843`, 
                    21.179866971464023`}, {-34.01575640902058, \
-18.820133028536002`}}],
                    StatusArea[#, 1.4247930092930599`]& ,
                    TagBoxNote->"1.4247930092930599"],
                   StyleBox["1.4247930092930599`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.4247930092930599`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41203$41420, 
                    FEPrivate`Not[DynamicChart`click$41203$41420]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41203$41420, {{{1., 0}, {
                    0, 1.}}, {-0.15893361843028542`, 
                   0.12140883383286592`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$41203$41420}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.5635641138051346`, 
                    2.243541413988532}]},
                    
                    ImageSizeCache->{{8.498098699037676, 
                    21.29422550680831}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 1.9714400647278119`]& ,
                    TagBoxNote->"1.9714400647278119"],
                   StyleBox["1.9714400647278119`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.9714400647278119`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41206$41420, 
                    FEPrivate`Not[DynamicChart`click$41206$41420]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41206$41420, {{{1., 0}, {
                    0, 1.}}, {-0.06532990005570359, 0.18902910928931496`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41206$41420}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.8599148193381145`, 
                    1.5635641138051346`}]},
                    
                    ImageSizeCache->{{13.843172367439706`, 
                    36.992389698736744`}, {-37.46066934611002, \
-3.0076103012632807`}}],
                    StatusArea[#, 9.925601233643974]& ,
                    TagBoxNote->"9.925601233643974"],
                   StyleBox["9.925601233643974`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.925601233643974, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41209$41420, 
                    FEPrivate`Not[DynamicChart`click$41209$41420]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41209$41420, {{{1., 0}, {0, 1.}}, {
                   0.19780842073677352`, -0.029526745259570976`}}, {{1, 0}, {
                  0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41209$41420}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.8599148193381145`}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-21.64856015328219, \
-3.663900009220164}}],
                    StatusArea[#, 3.7159343875682893`]& ,
                    TagBoxNote->"3.7159343875682893"],
                   StyleBox["3.7159343875682893`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.7159343875682893`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41212$41420, 
                    FEPrivate`Not[DynamicChart`click$41212$41420]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41212$41420, {{{1., 0}, {
                    0, 1.}}, {-0.16031889564191734`, -0.11957362460072883`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41212$41420}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.1789030162226322`]& ,
                  TagBoxNote->"1.1789030162226322"],
                 StyleBox["1.1789030162226322`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.1789030162226322`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41200$41420, 
                   FEPrivate`Not[DynamicChart`click$41200$41420]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41200$41420, {{{1., 0}, {
                  0, 1.}}, {-0.19588071955129427`, 0.04038246783032462}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41200$41420}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.4247930092930599`]& ,
                  TagBoxNote->"1.4247930092930599"],
                 StyleBox["1.4247930092930599`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.4247930092930599`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41203$41420, 
                   FEPrivate`Not[DynamicChart`click$41203$41420]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41203$41420, {{{1., 0}, {
                  0, 1.}}, {-0.15893361843028542`, 0.12140883383286592`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41203$41420}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.9714400647278119`]& ,
                  TagBoxNote->"1.9714400647278119"],
                 StyleBox["1.9714400647278119`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.9714400647278119`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41206$41420, 
                   FEPrivate`Not[DynamicChart`click$41206$41420]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41206$41420, {{{1., 0}, {
                  0, 1.}}, {-0.06532990005570359, 0.18902910928931496`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41206$41420}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.925601233643974]& ,
                  TagBoxNote->"9.925601233643974"],
                 StyleBox["9.925601233643974`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.925601233643974, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41209$41420, 
                   FEPrivate`Not[DynamicChart`click$41209$41420]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41209$41420, {{{1., 0}, {0, 1.}}, {
                 0.19780842073677352`, -0.029526745259570976`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41209$41420}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.7159343875682893`]& ,
                  TagBoxNote->"3.7159343875682893"],
                 StyleBox["3.7159343875682893`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.7159343875682893`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41212$41420, 
                   FEPrivate`Not[DynamicChart`click$41212$41420]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41212$41420, {{{1., 0}, {
                  0, 1.}}, {-0.16031889564191734`, -0.11957362460072883`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41212$41420}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1368., -967.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41251$41421 = False, 
         DynamicChart`click$41254$41421 = False, 
         DynamicChart`click$41257$41421 = False, 
         DynamicChart`click$41260$41421 = False, 
         DynamicChart`click$41263$41421 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.8302438393452776, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    31.848509695257867`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 9.441973987555556]& ,
                    TagBoxNote->"9.441973987555556"],
                   StyleBox["9.441973987555556`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.441973987555556, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41251$41421, 
                    FEPrivate`Not[DynamicChart`click$41251$41421]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$41251$41421, {{{1., 0}, {
                    0, 1.}}, {-0.08066029961419635, 0.18301343138181983`}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41251$41421}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.18697291353534773`, 
                    0.8302438393452776}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.992389698736744`}, {-33.31971851192667, \
-15.880815560463738`}}],
                    StatusArea[#, 4.1553806423388835`]& ,
                    TagBoxNote->"4.1553806423388835"],
                   StyleBox["4.1553806423388835`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[4.1553806423388835`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41254$41421, 
                    FEPrivate`Not[DynamicChart`click$41254$41421]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41254$41421, {{{1., 0}, {0, 1.}}, {
                   0.18974393737851605`, 0.06322371570935849}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41254$41421}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-0.26182530849210606`, -0.18697291353534773`}]},
                    
                    ImageSizeCache->{{18.351439846717827`, 
                    36.71679999643396}, {-21.64856015328219, \
-14.72715509146407}}],
                    StatusArea[#, 0.3057757278920086]& ,
                    TagBoxNote->"0.3057757278920086"],
                   StyleBox["0.3057757278920086`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[0.3057757278920086, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41257$41421, 
                    FEPrivate`Not[DynamicChart`click$41257$41421]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41257$41421, {{{1., 0}, {0, 1.}}, {
                   0.1949855986466764, -0.044504115769187474`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41257$41421}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-1.5796491015170844`, -0.26182530849210606`}]},
                    
                    ImageSizeCache->{{18.211456973687955`, 
                    36.45348496482626}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 5.383375238406277]& ,
                    TagBoxNote->"5.383375238406277"],
                   StyleBox["5.383375238406277`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[5.383375238406277, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41260$41421, 
                    FEPrivate`Not[DynamicChart`click$41260$41421]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41260$41421, {{{1., 0}, {0, 1.}}, {
                   0.12104669411554646`, -0.15920960349079868`}}, {{1, 0}, {0,
                   1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41260$41421}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.5796491015170844`}]},
                    
                    ImageSizeCache->{{2.538917119445104, 
                    21.179866971464016`}, {-21.648560153282194`, \
-3.0082299237299672`}}],
                    StatusArea[#, 6.380616503148232]& ,
                    TagBoxNote->"6.380616503148232"],
                   StyleBox["6.380616503148232`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[6.380616503148232, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41263$41421, 
                    FEPrivate`Not[DynamicChart`click$41263$41421]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41263$41421, {{{1., 0}, {
                    0, 1.}}, {-0.14204595447166088`, -0.14079398715227454`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41263$41421}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.441973987555556]& ,
                  TagBoxNote->"9.441973987555556"],
                 StyleBox["9.441973987555556`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.441973987555556, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41251$41421, 
                   FEPrivate`Not[DynamicChart`click$41251$41421]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41251$41421, {{{1., 0}, {
                  0, 1.}}, {-0.08066029961419635, 0.18301343138181983`}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41251$41421}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 4.1553806423388835`]& ,
                  TagBoxNote->"4.1553806423388835"],
                 StyleBox["4.1553806423388835`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[4.1553806423388835`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41254$41421, 
                   FEPrivate`Not[DynamicChart`click$41254$41421]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41254$41421, {{{1., 0}, {0, 1.}}, {
                 0.18974393737851605`, 0.06322371570935849}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41254$41421}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 0.3057757278920086]& ,
                  TagBoxNote->"0.3057757278920086"],
                 StyleBox["0.3057757278920086`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[0.3057757278920086, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41257$41421, 
                   FEPrivate`Not[DynamicChart`click$41257$41421]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41257$41421, {{{1., 0}, {0, 1.}}, {
                 0.1949855986466764, -0.044504115769187474`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41257$41421}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 5.383375238406277]& ,
                  TagBoxNote->"5.383375238406277"],
                 StyleBox["5.383375238406277`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[5.383375238406277, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41260$41421, 
                   FEPrivate`Not[DynamicChart`click$41260$41421]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41260$41421, {{{1., 0}, {0, 1.}}, {
                 0.12104669411554646`, -0.15920960349079868`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41260$41421}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 6.380616503148232]& ,
                  TagBoxNote->"6.380616503148232"],
                 StyleBox["6.380616503148232`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[6.380616503148232, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41263$41421, 
                   FEPrivate`Not[DynamicChart`click$41263$41421]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41263$41421, {{{1., 0}, {
                  0, 1.}}, {-0.14204595447166088`, -0.14079398715227454`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41263$41421}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {1758.8571428571427, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
      GraphicsBox[{{}, {}, 
        DynamicModuleBox[{DynamicChart`click$41302$41422 = False, 
         DynamicChart`click$41305$41422 = False, 
         DynamicChart`click$41308$41422 = False, 
         DynamicChart`click$41311$41422 = False, 
         DynamicChart`click$41314$41422 = False}, {
          {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
           0.5]}], {{{}, {
              {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
               0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.858454869918573, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    21.179866971463994`}, {-26.06610252805732, \
-18.820133028536002`}}],
                    StatusArea[#, 1.3512473623132877`]& ,
                    TagBoxNote->"1.3512473623132877"],
                   StyleBox["1.3512473623132877`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[1.3512473623132877`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41302$41422, 
                    FEPrivate`Not[DynamicChart`click$41302$41422]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41302$41422, {{{1., 0}, {
                    0, 1.}}, {-0.19799916991598035`, 
                   0.028219296812336522`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                  1}}], TrackedSymbols :> {DynamicChart`click$41302$41422}]]}, 
              {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
               0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.186005358352003, 
                    2.858454869918573}]},
                    
                    ImageSizeCache->{{3.1685154127498034`, 
                    21.179866971463994`}, {-34.56190153290973, \
-18.820133028536002`}}],
                    StatusArea[#, 3.2091994823562846`]& ,
                    TagBoxNote->"3.2091994823562846"],
                   StyleBox["3.2091994823562846`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[3.2091994823562846`, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41305$41422, 
                    FEPrivate`Not[DynamicChart`click$41305$41422]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[
                 DynamicChart`click$41305$41422, {{{1., 0}, {
                    0, 1.}}, {-0.16284973565313338`, 0.1161032454227899}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41305$41422}]]}, 
              {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
               GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.4821365411095204, 
                    2.186005358352003}]},
                    
                    ImageSizeCache->{{9.22557060517617, 
                    35.189861550535824`}, {-37.46108288055491, \
-18.820133028536002`}}],
                    StatusArea[#, 8.131547175280048]& ,
                    TagBoxNote->"8.131547175280048"],
                   StyleBox["8.131547175280048`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.131547175280048, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41308$41422, 
                    FEPrivate`Not[DynamicChart`click$41308$41422]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41308$41422, {{{1., 0}, {0, 1.}}, {
                   0.04690411840817722, 0.19442223040679196`}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41308$41422}]]}, 
              {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[0],
                Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-1.4433695494608205`, 
                    0.4821365411095204}]},
                    
                    ImageSizeCache->{{18.3514398467178, 
                    36.992389698736716`}, {-28.980403502324386`, \
-3.1358152618101016`}}],
                    StatusArea[#, 9.189289370939612]& ,
                    TagBoxNote->"9.189289370939612"],
                   StyleBox["9.189289370939612`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[9.189289370939612, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41311$41422, 
                    FEPrivate`Not[DynamicChart`click$41311$41422]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41311$41422, {{{1., 0}, {0, 1.}}, {
                   0.1773420130888025, -0.09246518476492112}}, {{1, 0}, {0, 
                  1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {DynamicChart`click$41311$41422}]]}, 
              {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
               Opacity[0.5]}], GeometricTransformationBox[
                TagBox[
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -1.4433695494608205`}]},
                    
                    ImageSizeCache->{{2.5389171194450793`, 
                    23.189357253322193`}, {-21.648560153282194`, \
-3.0076103012632807`}}],
                    StatusArea[#, 8.10460356198304]& ,
                    TagBoxNote->"8.10460356198304"],
                   StyleBox["8.10460356198304`", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                  Annotation[#, 
                   Style[8.10460356198304, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                 
                 EventHandlerTag[{
                  "MouseClicked" :> 
                   FEPrivate`Set[DynamicChart`click$41314$41422, 
                    FEPrivate`Not[DynamicChart`click$41314$41422]], 
                   PassEventsDown -> True, Method -> "Preemptive", 
                   PassEventsUp -> True}]], Dynamic[
                If[DynamicChart`click$41314$41422, {{{1., 0}, {
                    0, 1.}}, {-0.13213007176933342`, -0.1501387496092558}}, {{
                  1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                 TrackedSymbols :> {
                  DynamicChart`click$41314$41422}]]}}}, {}}, {}}, {{{
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 1.3512473623132877`]& ,
                  TagBoxNote->"1.3512473623132877"],
                 StyleBox["1.3512473623132877`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[1.3512473623132877`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41302$41422, 
                   FEPrivate`Not[DynamicChart`click$41302$41422]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41302$41422, {{{1., 0}, {
                  0, 1.}}, {-0.19799916991598035`, 0.028219296812336522`}}, {{
                1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41302$41422}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 3.2091994823562846`]& ,
                  TagBoxNote->"3.2091994823562846"],
                 StyleBox["3.2091994823562846`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[3.2091994823562846`, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41305$41422, 
                   FEPrivate`Not[DynamicChart`click$41305$41422]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41305$41422, {{{1., 0}, {
                  0, 1.}}, {-0.16284973565313338`, 0.1161032454227899}}, {{1, 
                0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41305$41422}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.131547175280048]& ,
                  TagBoxNote->"8.131547175280048"],
                 StyleBox["8.131547175280048`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.131547175280048, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41308$41422, 
                   FEPrivate`Not[DynamicChart`click$41308$41422]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41308$41422, {{{1., 0}, {0, 1.}}, {
                 0.04690411840817722, 0.19442223040679196`}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41308$41422}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 9.189289370939612]& ,
                  TagBoxNote->"9.189289370939612"],
                 StyleBox["9.189289370939612`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[9.189289370939612, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41311$41422, 
                   FEPrivate`Not[DynamicChart`click$41311$41422]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41311$41422, {{{1., 0}, {0, 1.}}, {
                 0.1773420130888025, -0.09246518476492112}}, {{1, 0}, {0, 
                1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {DynamicChart`click$41311$41422}]], 
             GeometricTransformationBox[
              TagBox[
               TagBox[
                TooltipBox[
                 TagBox[{{}, {}},
                  StatusArea[#, 8.10460356198304]& ,
                  TagBoxNote->"8.10460356198304"],
                 StyleBox["8.10460356198304`", {
                   GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                  False]],
                Annotation[#, 
                 Style[8.10460356198304, {
                   GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
               
               EventHandlerTag[{
                "MouseClicked" :> 
                 FEPrivate`Set[DynamicChart`click$41314$41422, 
                   FEPrivate`Not[DynamicChart`click$41314$41422]], 
                 PassEventsDown -> True, Method -> "Preemptive", PassEventsUp -> 
                 True}]], Dynamic[
              If[DynamicChart`click$41314$41422, {{{1., 0}, {
                  0, 1.}}, {-0.13213007176933342`, -0.1501387496092558}}, {{1,
                 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
               TrackedSymbols :> {
                DynamicChart`click$41314$41422}]]}, {}}, {}}},
         DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
       ContentSelectable->False,
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       LabelStyle->{
         GrayLevel[0], FontFamily -> "Arial"},
       PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
       PlotRangePadding->Scaled[0.02]], {2149.7142857142853, -967.5}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{390.85714285714283`, 0}, {390.85714285714283`, -387.}}], 
      LineBox[{{390.85714285714283`, -387.}, {390.85714285714283`, -774.}}], 
      LineBox[{{390.85714285714283`, -774.}, {390.85714285714283`, -1161.}}], 
      LineBox[{{781.7142857142857, 0}, {781.7142857142857, -387.}}], 
      LineBox[{{781.7142857142857, -387.}, {781.7142857142857, -774.}}], 
      LineBox[{{781.7142857142857, -774.}, {781.7142857142857, -1161.}}], 
      LineBox[{{1172.5714285714284`, 0}, {1172.5714285714284`, -387.}}], 
      LineBox[{{1172.5714285714284`, -387.}, {1172.5714285714284`, -774.}}], 
      LineBox[{{1172.5714285714284`, -774.}, {1172.5714285714284`, -1161.}}], 
      LineBox[{{1563.4285714285713`, 0}, {1563.4285714285713`, -387.}}], 
      LineBox[{{1563.4285714285713`, -387.}, {1563.4285714285713`, -774.}}], 
      LineBox[{{1563.4285714285713`, -774.}, {1563.4285714285713`, -1161.}}], 
      LineBox[{{1954.2857142857142`, 0}, {1954.2857142857142`, -387.}}], 
      LineBox[{{1954.2857142857142`, -387.}, {1954.2857142857142`, -774.}}], 
      LineBox[{{1954.2857142857142`, -774.}, {1954.2857142857142`, -1161.}}], 
      LineBox[{{2345.142857142857, 0}, {2345.142857142857, -387.}}], 
      LineBox[{{2345.142857142857, -387.}, {2345.142857142857, -774.}}], 
      LineBox[{{2345.142857142857, -774.}, {2345.142857142857, -1161.}}], 
      LineBox[{{0, 0}, {390.85714285714283`, 0}}], 
      LineBox[{{390.85714285714283`, 0}, {781.7142857142857, 0}}], 
      LineBox[{{781.7142857142857, 0}, {1172.5714285714284`, 0}}], 
      LineBox[{{1172.5714285714284`, 0}, {1563.4285714285713`, 0}}], 
      LineBox[{{1563.4285714285713`, 0}, {1954.2857142857142`, 0}}], 
      LineBox[{{1954.2857142857142`, 0}, {2345.142857142857, 0}}], 
      LineBox[{{0, -387.}, {390.85714285714283`, -387.}}], 
      LineBox[{{390.85714285714283`, -387.}, {781.7142857142857, -387.}}], 
      LineBox[{{781.7142857142857, -387.}, {1172.5714285714284`, -387.}}], 
      LineBox[{{1172.5714285714284`, -387.}, {1563.4285714285713`, -387.}}], 
      LineBox[{{1563.4285714285713`, -387.}, {1954.2857142857142`, -387.}}], 
      LineBox[{{1954.2857142857142`, -387.}, {2345.142857142857, -387.}}], 
      LineBox[{{0, -774.}, {390.85714285714283`, -774.}}], 
      LineBox[{{390.85714285714283`, -774.}, {781.7142857142857, -774.}}], 
      LineBox[{{781.7142857142857, -774.}, {1172.5714285714284`, -774.}}], 
      LineBox[{{1172.5714285714284`, -774.}, {1563.4285714285713`, -774.}}], 
      LineBox[{{1563.4285714285713`, -774.}, {1954.2857142857142`, -774.}}], 
      LineBox[{{1954.2857142857142`, -774.}, {2345.142857142857, -774.}}], 
      LineBox[{{0, -1161.}, {390.85714285714283`, -1161.}}], 
      LineBox[{{390.85714285714283`, -1161.}, {781.7142857142857, -1161.}}], 
      LineBox[{{781.7142857142857, -1161.}, {1172.5714285714284`, -1161.}}], 
      LineBox[{{1172.5714285714284`, -1161.}, {1563.4285714285713`, -1161.}}],
       LineBox[{{1563.4285714285713`, -1161.}, {
       1954.2857142857142`, -1161.}}], 
      LineBox[{{1954.2857142857142`, -1161.}, {2345.142857142857, -1161.}}]}},
    
    StripOnInput->False,
    Antialiasing->False]},
  ContentSelectable->True,
  ImagePadding->{{0., 1.}, {1., 0.}},
  ImageSize->{259.8359375, Automatic},
  PlotRange->{{-6., 2351.142857142857}, {-1166., 5.}},
  PlotRangePadding->Automatic]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"2958db0e-7595-4d1f-855c-3f4f6b7713d3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad9063a1-52ba-4624-9b62-644407a86898"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Framed",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "add a frame ", "VocabularyText",ExpressionUUID->
     "99f70b07-bee4-48a8-b74c-701b068a6f60"]},
   {
    RowBox[{
     ButtonBox["Labeled",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["lab", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "add a label ", "VocabularyText",ExpressionUUID->
     "343f2f82-4f61-40e3-85aa-a9d31e229be7"]},
   {
    RowBox[{
     ButtonBox["Callout",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["lab", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "add a callout", "VocabularyText",ExpressionUUID->
     "4fa1fe62-b074-4441-8e3f-bad4a60f08e1"]},
   {
    RowBox[{
     ButtonBox["Tooltip",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["lab", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "add an interactive tooltip ", "VocabularyText",ExpressionUUID->
     "57d389c8-cc75-49fc-90d9-620faa463017"]},
   {
    RowBox[{
     ButtonBox["Legended",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["lab", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "add a legend ", "VocabularyText",ExpressionUUID->
     "2597b417-cc02-43a1-8f80-6387c279ec51"]},
   {
    RowBox[{
     ButtonBox["Row",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "arrange in a row ", "VocabularyText",ExpressionUUID->
     "4796c186-07da-49e2-9ae6-42b06eb2056b"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "arrange in a column ", "VocabularyText",ExpressionUUID->
     "033a1b6d-59eb-41c6-8142-9736cfef797b"]},
   {
    RowBox[{
     ButtonBox["GraphicsRow",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "arrange in a resizable row ", "VocabularyText",ExpressionUUID->
     "9fd765dd-b1f8-43f7-8c4b-b56a883197d9"]},
   {
    RowBox[{
     ButtonBox["GraphicsColumn",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["expr", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "arrange in a resizable column ", "VocabularyText",ExpressionUUID->
     "ecbc9da1-ed12-4e03-8a6f-b5716bfa5e60"]},
   {
    RowBox[{
     ButtonBox["GraphicsGrid",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["array", "CodeVariableLrg"], "]"}], " ", Cell[
    "arrange in a resizable grid ", "VocabularyText",ExpressionUUID->
     "2ac406b0-334d-41c3-a7d8-3a8d651d9334"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True, True}, 
     False}},
 GridBoxSpacings->{"Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{0.9}}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"eedff6fc-0e98-400e-aa1e-2f19a28e63b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"2418b7d8-7708-48d9-8f10-11f72f01801f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-37-layout-and-display-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"930bd92b-9e26-4c21-8343-291d69e053e8"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of numbers up to 100, with even numbers on yellow and odd \
numbers on light gray.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"271c7c28-fc82-45de-a74a-526236c3de3b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         StyleBox["1",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["2",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["3",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["4",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["5",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["6",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["7",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["8",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["9",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["10",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["11",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["12",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["13",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["14",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["15",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["16",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["17",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["18",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["19",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["20",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["21",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["22",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["23",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["24",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["25",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["26",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["27",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["28",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["29",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["30",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["31",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["32",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["33",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["34",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["35",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["36",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["37",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["38",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["39",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["40",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["41",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["42",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["43",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["44",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["45",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["46",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["47",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["48",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["49",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["50",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["51",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["52",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["53",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["54",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["55",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["56",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["57",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["58",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["59",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["60",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["61",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["62",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["63",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["64",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["65",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["66",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["67",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["68",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["69",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["70",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["71",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["72",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["73",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["74",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["75",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["76",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["77",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["78",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["79",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["80",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["81",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["82",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["83",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["84",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["85",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["86",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["87",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["88",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["89",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["90",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["91",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["92",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["93",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["94",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["95",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["96",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["97",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["98",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]], ",", 
         StyleBox["99",
          StripOnInput->False,
          Background->GrayLevel[0.85]], ",", 
         StyleBox["100",
          StripOnInput->False,
          Background->RGBColor[1, 1, 0]]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"25c9b5f7-7733-49e7-88c3-b6e803df7f66"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             StyleBox[
             "1", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             
             StyleBox[
             "2", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "3", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             
             StyleBox[
             "4", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "5", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             
             StyleBox[
             "6", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "7", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             
             StyleBox[
             "8", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "9", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             
             StyleBox[
             "10", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "11", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "12", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "13", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "14", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "15", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "16", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "17", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "18", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "19", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "20", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "21", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "22", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "23", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "24", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "25", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "26", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "27", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "28", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "29", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "30", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "31", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "32", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "33", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "34", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "35", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "36", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "37", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "38", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "39", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "40", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "41", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "42", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "43", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "44", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "45", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "46", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "47", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "48", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "49", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "50", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "51", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "52", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "53", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "54", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "55", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "56", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "57", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "58", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "59", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "60", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "61", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "62", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "63", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "64", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "65", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "66", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "67", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "68", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "69", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "70", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "71", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "72", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "73", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "74", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "75", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "76", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "77", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "78", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "79", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "80", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "81", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "82", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "83", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "84", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "85", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "86", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "87", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "88", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "89", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "90", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "91", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "92", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "93", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "94", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "95", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "96", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "97", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "98", StripOnInput -> False, Background -> RGBColor[1, 1, 0]], 
             ",", 
             StyleBox[
             "99", StripOnInput -> False, Background -> GrayLevel[0.85]], ",", 
             StyleBox[
             "100", StripOnInput -> False, Background -> RGBColor[1, 1, 0]]}],
            "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"703ed426-97e7-4a77-8f56-d223a50fd522"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of numbers up to 100, with primes framed.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9de2a9c0-c2ca-4dce-987b-2c97d5b97e1e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", 
         FrameBox["2",
          StripOnInput->False], ",", 
         FrameBox["3",
          StripOnInput->False], ",", "4", ",", 
         FrameBox["5",
          StripOnInput->False], ",", "6", ",", 
         FrameBox["7",
          StripOnInput->False], ",", "8", ",", "9", ",", "10", ",", 
         FrameBox["11",
          StripOnInput->False], ",", "12", ",", 
         FrameBox["13",
          StripOnInput->False], ",", "14", ",", "15", ",", "16", ",", 
         FrameBox["17",
          StripOnInput->False], ",", "18", ",", 
         FrameBox["19",
          StripOnInput->False], ",", "20", ",", "21", ",", "22", ",", 
         FrameBox["23",
          StripOnInput->False], ",", "24", ",", "25", ",", "26", ",", "27", 
         ",", "28", ",", 
         FrameBox["29",
          StripOnInput->False], ",", "30", ",", 
         FrameBox["31",
          StripOnInput->False], ",", "32", ",", "33", ",", "34", ",", "35", 
         ",", "36", ",", 
         FrameBox["37",
          StripOnInput->False], ",", "38", ",", "39", ",", "40", ",", 
         FrameBox["41",
          StripOnInput->False], ",", "42", ",", 
         FrameBox["43",
          StripOnInput->False], ",", "44", ",", "45", ",", "46", ",", 
         FrameBox["47",
          StripOnInput->False], ",", "48", ",", "49", ",", "50", ",", "51", 
         ",", "52", ",", 
         FrameBox["53",
          StripOnInput->False], ",", "54", ",", "55", ",", "56", ",", "57", 
         ",", "58", ",", 
         FrameBox["59",
          StripOnInput->False], ",", "60", ",", 
         FrameBox["61",
          StripOnInput->False], ",", "62", ",", "63", ",", "64", ",", "65", 
         ",", "66", ",", 
         FrameBox["67",
          StripOnInput->False], ",", "68", ",", "69", ",", "70", ",", 
         FrameBox["71",
          StripOnInput->False], ",", "72", ",", 
         FrameBox["73",
          StripOnInput->False], ",", "74", ",", "75", ",", "76", ",", "77", 
         ",", "78", ",", 
         FrameBox["79",
          StripOnInput->False], ",", "80", ",", "81", ",", "82", ",", 
         FrameBox["83",
          StripOnInput->False], ",", "84", ",", "85", ",", "86", ",", "87", 
         ",", "88", ",", 
         FrameBox["89",
          StripOnInput->False], ",", "90", ",", "91", ",", "92", ",", "93", 
         ",", "94", ",", "95", ",", "96", ",", 
         FrameBox["97",
          StripOnInput->False], ",", "98", ",", "99", ",", "100"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "27ebe915-c4ca-465e-80f6-ce1e2a5d51c4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", 
             FrameBox["2", StripOnInput -> False], ",", 
             FrameBox["3", StripOnInput -> False], ",", "4", ",", 
             FrameBox["5", StripOnInput -> False], ",", "6", ",", 
             FrameBox["7", StripOnInput -> False], ",", "8", ",", "9", ",", 
             "10", ",", 
             FrameBox["11", StripOnInput -> False], ",", "12", ",", 
             FrameBox["13", StripOnInput -> False], ",", "14", ",", "15", ",",
              "16", ",", 
             FrameBox["17", StripOnInput -> False], ",", "18", ",", 
             FrameBox["19", StripOnInput -> False], ",", "20", ",", "21", ",",
              "22", ",", 
             FrameBox["23", StripOnInput -> False], ",", "24", ",", "25", ",",
              "26", ",", "27", ",", "28", ",", 
             FrameBox["29", StripOnInput -> False], ",", "30", ",", 
             FrameBox["31", StripOnInput -> False], ",", "32", ",", "33", ",",
              "34", ",", "35", ",", "36", ",", 
             FrameBox["37", StripOnInput -> False], ",", "38", ",", "39", ",",
              "40", ",", 
             FrameBox["41", StripOnInput -> False], ",", "42", ",", 
             FrameBox["43", StripOnInput -> False], ",", "44", ",", "45", ",",
              "46", ",", 
             FrameBox["47", StripOnInput -> False], ",", "48", ",", "49", ",",
              "50", ",", "51", ",", "52", ",", 
             FrameBox["53", StripOnInput -> False], ",", "54", ",", "55", ",",
              "56", ",", "57", ",", "58", ",", 
             FrameBox["59", StripOnInput -> False], ",", "60", ",", 
             FrameBox["61", StripOnInput -> False], ",", "62", ",", "63", ",",
              "64", ",", "65", ",", "66", ",", 
             FrameBox["67", StripOnInput -> False], ",", "68", ",", "69", ",",
              "70", ",", 
             FrameBox["71", StripOnInput -> False], ",", "72", ",", 
             FrameBox["73", StripOnInput -> False], ",", "74", ",", "75", ",",
              "76", ",", "77", ",", "78", ",", 
             FrameBox["79", StripOnInput -> False], ",", "80", ",", "81", ",",
              "82", ",", 
             FrameBox["83", StripOnInput -> False], ",", "84", ",", "85", ",",
              "86", ",", "87", ",", "88", ",", 
             FrameBox["89", StripOnInput -> False], ",", "90", ",", "91", ",",
              "92", ",", "93", ",", "94", ",", "95", ",", "96", ",", 
             FrameBox["97", StripOnInput -> False], ",", "98", ",", "99", ",",
              "100"}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"22149537-0f94-4753-9bfd-6040d49f5ddf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of numbers up to 100, with primes framed and labeled in light \
gray with their values modulo 4.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"fc281f3f-f8b5-4e00-94ea-53f2b228421d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", 
         TemplateBox[{
           FrameBox["2", StripOnInput -> False], 
           StyleBox["2", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", 
         TemplateBox[{
           FrameBox["3", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "4", ",", 
         TemplateBox[{
           FrameBox["5", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "6", ",", 
         TemplateBox[{
           FrameBox["7", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "8", ",", "9", ",", "10", 
         ",", 
         TemplateBox[{
           FrameBox["11", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "12", ",", 
         TemplateBox[{
           FrameBox["13", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "14", ",", "15", ",", "16",
          ",", 
         TemplateBox[{
           FrameBox["17", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "18", ",", 
         TemplateBox[{
           FrameBox["19", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "20", ",", "21", ",", "22",
          ",", 
         TemplateBox[{
           FrameBox["23", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "24", ",", "25", ",", "26",
          ",", "27", ",", "28", ",", 
         TemplateBox[{
           FrameBox["29", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "30", ",", 
         TemplateBox[{
           FrameBox["31", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "32", ",", "33", ",", "34",
          ",", "35", ",", "36", ",", 
         TemplateBox[{
           FrameBox["37", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "38", ",", "39", ",", "40",
          ",", 
         TemplateBox[{
           FrameBox["41", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "42", ",", 
         TemplateBox[{
           FrameBox["43", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "44", ",", "45", ",", "46",
          ",", 
         TemplateBox[{
           FrameBox["47", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "48", ",", "49", ",", "50",
          ",", "51", ",", "52", ",", 
         TemplateBox[{
           FrameBox["53", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "54", ",", "55", ",", "56",
          ",", "57", ",", "58", ",", 
         TemplateBox[{
           FrameBox["59", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "60", ",", 
         TemplateBox[{
           FrameBox["61", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "62", ",", "63", ",", "64",
          ",", "65", ",", "66", ",", 
         TemplateBox[{
           FrameBox["67", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "68", ",", "69", ",", "70",
          ",", 
         TemplateBox[{
           FrameBox["71", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "72", ",", 
         TemplateBox[{
           FrameBox["73", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "74", ",", "75", ",", "76",
          ",", "77", ",", "78", ",", 
         TemplateBox[{
           FrameBox["79", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "80", ",", "81", ",", "82",
          ",", 
         TemplateBox[{
           FrameBox["83", StripOnInput -> False], 
           StyleBox["3", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "84", ",", "85", ",", "86",
          ",", "87", ",", "88", ",", 
         TemplateBox[{
           FrameBox["89", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "90", ",", "91", ",", "92",
          ",", "93", ",", "94", ",", "95", ",", "96", ",", 
         TemplateBox[{
           FrameBox["97", StripOnInput -> False], 
           StyleBox["1", 
            GrayLevel[0.85], StripOnInput -> False]},
          "Labeled",
          DisplayFunction->(GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"]}, {
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]& ),
          InterpretationFunction->(RowBox[{"Labeled", "[", 
             RowBox[{#, ",", #2}], "]"}]& )], ",", "98", ",", "99", ",", 
         "100"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "9478a89f-cc67-4973-9a7d-8ef5fadd4538"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", 
             TemplateBox[{
               FrameBox["2", StripOnInput -> False], 
               StyleBox["2", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", 
             TemplateBox[{
               FrameBox["3", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "4", ",", 
             TemplateBox[{
               FrameBox["5", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "6", ",", 
             TemplateBox[{
               FrameBox["7", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "8", ",", "9", ",", 
             "10", ",", 
             TemplateBox[{
               FrameBox["11", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "12", ",", 
             TemplateBox[{
               FrameBox["13", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "14", ",", "15", ",", 
             "16", ",", 
             TemplateBox[{
               FrameBox["17", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "18", ",", 
             TemplateBox[{
               FrameBox["19", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "20", ",", "21", ",", 
             "22", ",", 
             TemplateBox[{
               FrameBox["23", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "24", ",", "25", ",", 
             "26", ",", "27", ",", "28", ",", 
             TemplateBox[{
               FrameBox["29", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "30", ",", 
             TemplateBox[{
               FrameBox["31", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "32", ",", "33", ",", 
             "34", ",", "35", ",", "36", ",", 
             TemplateBox[{
               FrameBox["37", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "38", ",", "39", ",", 
             "40", ",", 
             TemplateBox[{
               FrameBox["41", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "42", ",", 
             TemplateBox[{
               FrameBox["43", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "44", ",", "45", ",", 
             "46", ",", 
             TemplateBox[{
               FrameBox["47", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "48", ",", "49", ",", 
             "50", ",", "51", ",", "52", ",", 
             TemplateBox[{
               FrameBox["53", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "54", ",", "55", ",", 
             "56", ",", "57", ",", "58", ",", 
             TemplateBox[{
               FrameBox["59", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "60", ",", 
             TemplateBox[{
               FrameBox["61", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "62", ",", "63", ",", 
             "64", ",", "65", ",", "66", ",", 
             TemplateBox[{
               FrameBox["67", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "68", ",", "69", ",", 
             "70", ",", 
             TemplateBox[{
               FrameBox["71", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "72", ",", 
             TemplateBox[{
               FrameBox["73", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "74", ",", "75", ",", 
             "76", ",", "77", ",", "78", ",", 
             TemplateBox[{
               FrameBox["79", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "80", ",", "81", ",", 
             "82", ",", 
             TemplateBox[{
               FrameBox["83", StripOnInput -> False], 
               StyleBox["3", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "84", ",", "85", ",", 
             "86", ",", "87", ",", "88", ",", 
             TemplateBox[{
               FrameBox["89", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "90", ",", "91", ",", 
             "92", ",", "93", ",", "94", ",", "95", ",", "96", ",", 
             TemplateBox[{
               FrameBox["97", StripOnInput -> False], 
               StyleBox["1", 
                GrayLevel[0.85], StripOnInput -> False]}, "Labeled", 
              DisplayFunction -> (GridBox[{{
                  TagBox[
                   ItemBox[
                    PaneBox[
                    TagBox[#, "SkipImageSizeLevel"], 
                    Alignment -> {Center, Baseline}, BaselinePosition -> 
                    Baseline], DefaultBaseStyle -> "Labeled"], 
                   "SkipImageSizeLevel"]}, {
                  ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                BaselinePosition -> {1, 1}]& ), 
              InterpretationFunction -> (RowBox[{"Labeled", "[", 
                 RowBox[{#, ",", #2}], "]"}]& )], ",", "98", ",", "99", ",", 
             "100"}], "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fafa0573-b88c-415a-a2ba-d30c7d8789ad"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a 3\[Times]6 ",
 ButtonBox["GraphicsGrid",
  BaseStyle->"Link"],
 " of randomly colored disks.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"51a0335b-3366-48e3-a4ea-c67479dcde9a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{InsetBox[
            GraphicsBox[
             {RGBColor[
              0.44982861908094285`, 0.22023602399241193`, 0.87106944199451], 
              DiskBox[{0, 0}]}], {195.42857142857142, -193.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.42956790859676985`, 0.3884931769110158, 0.8194426183863741], 
              DiskBox[{0, 0}]}], {586.2857142857142, -193.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.553379204181945, 0.20366841893289678`, 0.6194453155266755], 
              DiskBox[{0, 0}]}], {977.1428571428571, -193.5}, 
            ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.8770220089788925, 0.8681414980186863, 0.7644456430149436], 
              DiskBox[{0, 0}]}], {1368., -193.5}, 
            ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.35267568610597744`, 0.1673229232871596, 0.5975724594816196], 
              DiskBox[{0, 0}]}], {1758.8571428571427, -193.5}, 
            ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.4153675086379385, 0.45911945674569443`, 0.5882286301141191], 
              DiskBox[{0, 0}]}], {2149.7142857142853, -193.5}, 
            ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
            GraphicsBox[
             {RGBColor[
              0.9254890066393693, 0.43744524780939553`, 0.3830380156706734], 
              DiskBox[{0, 0}]}], {195.42857142857142, -580.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.42013447136757853`, 0.7924509784438705, 0.1546820762754697], 
              DiskBox[{0, 0}]}], {586.2857142857142, -580.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.8069188512033008, 0.4368851485677845, 0.6586766901193732], 
              DiskBox[{0, 0}]}], {977.1428571428571, -580.5}, 
            ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.3242756830352336, 0.5478265510915612, 0.9838640793469751], 
              DiskBox[{0, 0}]}], {1368., -580.5}, 
            ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.2111001063244824, 0.46880218126732665`, 0.9864332374940437], 
              DiskBox[{0, 0}]}], {1758.8571428571427, -580.5}, 
            ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.07224502759364504, 0.5264313777578158, 0.7825879542403851], 
              DiskBox[{0, 0}]}], {2149.7142857142853, -580.5}, 
            ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
            GraphicsBox[
             {RGBColor[
              0.4392355876273668, 0.6831424607743413, 0.1481313928778174], 
              DiskBox[{0, 0}]}], {195.42857142857142, -967.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.5202320785608503, 0.47634894012561113`, 0.32292167022174034`],
               DiskBox[{0, 0}]}], {586.2857142857142, -967.5}, 
            ImageScaled[{0.5, 0.5}], {359.99999999999994, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.06509324224737845, 0.9587527634753168, 0.49876723274314894`], 
              DiskBox[{0, 0}]}], {977.1428571428571, -967.5}, 
            ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.2309444902074531, 0.43803360138564984`, 0.7302067612026686], 
              DiskBox[{0, 0}]}], {1368., -967.5}, ImageScaled[{0.5, 0.5}], 
            {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.990725154656992, 0.33175512759568915`, 0.2721000119778654], 
              DiskBox[{0, 0}]}], {1758.8571428571427, -967.5}, 
            ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], InsetBox[
            GraphicsBox[
             {RGBColor[
              0.6108251203050665, 0.2505229632388297, 0.010432022839230726`], 
              DiskBox[{0, 0}]}], {2149.7142857142853, -967.5}, 
            ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}}, {}},
        ContentSelectable->True,
        PlotRangePadding->{6, 5}]], "ExerciseOutput",ExpressionUUID->
       "a542240e-a777-4779-8d0f-6a5e30656345"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.44982861908094285`, 0.22023602399241193`, 
                    0.87106944199451], 
                   DiskBox[{0, 0}]}}}}], {195.42857142857142`, -193.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.42956790859676985`, 0.3884931769110158, 
                    0.8194426183863741], 
                   DiskBox[{0, 0}]}}}}], {586.2857142857142, -193.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.553379204181945, 0.20366841893289678`, 
                    0.6194453155266755], 
                   DiskBox[{0, 0}]}}}}], {977.1428571428571, -193.5}, 
              ImageScaled[{0.5, 0.5}], {360., 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.8770220089788925, 0.8681414980186863, 
                    0.7644456430149436], 
                   DiskBox[{0, 0}]}}}}], {1368., -193.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.35267568610597744`, 0.1673229232871596, 
                    0.5975724594816196], 
                   DiskBox[{0, 0}]}}}}], {1758.8571428571427`, -193.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.4153675086379385, 0.45911945674569443`, 
                    0.5882286301141191], 
                   DiskBox[{0, 0}]}}}}], {2149.7142857142853`, -193.5}, 
              ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.9254890066393693, 0.43744524780939553`, 
                    0.3830380156706734], 
                   DiskBox[{0, 0}]}}}}], {195.42857142857142`, -580.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.42013447136757853`, 0.7924509784438705, 
                    0.1546820762754697], 
                   DiskBox[{0, 0}]}}}}], {586.2857142857142, -580.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.8069188512033008, 0.4368851485677845, 
                    0.6586766901193732], 
                   DiskBox[{0, 0}]}}}}], {977.1428571428571, -580.5}, 
              ImageScaled[{0.5, 0.5}], {360., 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.3242756830352336, 0.5478265510915612, 
                    0.9838640793469751], 
                   DiskBox[{0, 0}]}}}}], {1368., -580.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.2111001063244824, 0.46880218126732665`, 
                    0.9864332374940437], 
                   DiskBox[{0, 0}]}}}}], {1758.8571428571427`, -580.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.07224502759364504, 0.5264313777578158, 
                    0.7825879542403851], 
                   DiskBox[{0, 0}]}}}}], {2149.7142857142853`, -580.5}, 
              ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.4392355876273668, 0.6831424607743413, 
                    0.1481313928778174], 
                   DiskBox[{0, 0}]}}}}], {195.42857142857142`, -967.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.5202320785608503, 0.47634894012561113`, 
                    0.32292167022174034`], 
                   DiskBox[{0, 0}]}}}}], {586.2857142857142, -967.5}, 
              ImageScaled[{0.5, 0.5}], {359.99999999999994`, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.06509324224737845, 0.9587527634753168, 
                    0.49876723274314894`], 
                   DiskBox[{0, 0}]}}}}], {977.1428571428571, -967.5}, 
              ImageScaled[{0.5, 0.5}], {360., 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.2309444902074531, 0.43803360138564984`, 
                    0.7302067612026686], 
                   DiskBox[{0, 0}]}}}}], {1368., -967.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.990725154656992, 0.33175512759568915`, 
                    0.2721000119778654], 
                   DiskBox[{0, 0}]}}}}], {1758.8571428571427`, -967.5}, 
              ImageScaled[{0.5, 0.5}], {360.0000000000002, 360.}], 
             InsetBox[
              GraphicsBox[{{{{
                   RGBColor[
                   0.6108251203050665, 0.2505229632388297, 
                    0.010432022839230726`], 
                   DiskBox[{0, 0}]}}}}], {2149.7142857142853`, -967.5}, 
              ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}}, {}}, 
          ContentSelectable -> True, PlotRangePadding -> {6, 5}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"126caddd-d5a8-4e4e-9545-ea60595f87f1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a pie chart of the GDPs of the countries in the G5, labeling each \
wedge.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"829d0476-9387-43fc-9b60-824a5d80aaa6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {}, 
         DynamicModuleBox[{DynamicChart`click$34214$34265 = False, 
          DynamicChart`click$34219$34265 = False, 
          DynamicChart`click$34224$34265 = False, 
          DynamicChart`click$34229$34265 = False, 
          DynamicChart`click$34234$34265 = False}, {
           {RGBColor[0.5, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
            0.5]}], {{{}, {
               {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.647347806323696, 
                    3.141592653589793}]},
                    
                    ImageSizeCache->{{20.585786437626904`, 
                    121.41421356237312`}, {-50.90218006338735, \
-1.58578643762689}}], {}},
                    StatusArea[#, 2.42168237773095*^12]& ,
                    TagBoxNote->"2.42168237773095*^12"],
                    StyleBox["2.42168237773095`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2.42168237773095*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34214$34265, 
                    FEPrivate`Not[DynamicChart`click$34214$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34214$34265, {{{1., 0}, {
                    0, 1.}}, {-0.19392406660075512`, 0.04892296386182981}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34214$34265}]]}, 
               {RGBColor[1., 0.544, 0.2], EdgeForm[{GrayLevel[0], Opacity[
                0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.962463096708159, 
                    2.647347806323696}]},
                    
                    ImageSizeCache->{{32.31372276345381, 
                    121.4142135623731}, {-94.99307426322905, \
-1.5857864376268962`}}], {}},
                    StatusArea[#, 3.35577242985472*^12]& ,
                    TagBoxNote->"3.35577242985472*^12"],
                    StyleBox["3.35577242985472`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[3.35577242985472*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34219$34265, 
                    FEPrivate`Not[DynamicChart`click$34219$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34219$34265, {{{1., 0}, {
                    0, 1.}}, {-0.13398520218745377`, 
                    0.14848557369248752`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {
                   DynamicChart`click$34219$34265}]]}, 
               {RGBColor[0.784, 0.47519999999999996`, 0.2], EdgeForm[{
                GrayLevel[0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1209411670601166`, 
                    1.962463096708159}]},
                    
                    ImageSizeCache->{{81.1762957416159, 
                    164.02805420047486`}, {-102.4142135623731, \
-1.5857864376268793`}}], {}},
                    StatusArea[#, 4.12325760961474*^12]& ,
                    TagBoxNote->"4.12325760961474*^12"],
                    StyleBox["4.12325760961474`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[4.12325760961474*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34224$34265, 
                    FEPrivate`Not[DynamicChart`click$34224$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34224$34265, {{{1., 0}, {0, 1.}}, {
                    0.005818018102677833, 0.19991535875304056`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34224$34265}]]}, 
               {RGBColor[0.6754608, 0.4848, 0.7224792], EdgeForm[{GrayLevel[
                0], Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5395343257067293, 
                    1.1209411670601166`}]},
                    
                    ImageSizeCache->{{118.58578643762691`, 
                    205.4931183729874}, {-92.66420271857906, \
-1.5857864376268793`}}], {}},
                    StatusArea[#, 2.84875544942134*^12]& ,
                    TagBoxNote->"2.84875544942134*^12"],
                    StyleBox["2.84875544942134`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[2.84875544942134*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34229$34265, 
                    FEPrivate`Not[DynamicChart`click$34229$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34229$34265, {{{1., 0}, {0, 1.}}, {
                    0.13494006009702145`, 0.14761835990489883`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34229$34265}]]}, 
               {RGBColor[0.4992, 0.5552, 0.8309304], EdgeForm[{GrayLevel[0], 
                Opacity[0.5]}], GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    0.5395343257067293}]},
                    
                    ImageSizeCache->{{20.585786437626894`, 
                    219.4142135623731}, {-54.760392820065135`, 
                    96.41421356237313}}], {}},
                    StatusArea[#, 1.8036648*^13]& ,
                    TagBoxNote->"1.8036648*^13"],
                    StyleBox["1.8036648`*^13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]],
                   Annotation[#, 
                    Style[1.8036648*^13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34234$34265, 
                    FEPrivate`Not[DynamicChart`click$34234$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], Dynamic[
                 If[DynamicChart`click$34234$34265, {{{1., 0}, {0, 1.}}, {
                    0.05330140555903297, -0.19276659504548888`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34234$34265}]]}}}, {}}, {}}, {{{
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{{}, InsetBox[
                    InterpretationBox["\<\"France\"\>",
                    Entity["Country", "France"],
                    
                    BaseStyle->
                    "Entity"], {-0.6464135553358503, 0.16307654620609935}]}, \
{}},
                   StatusArea[#, 2.42168237773095*^12]& ,
                   TagBoxNote->"2.42168237773095*^12"],
                  StyleBox["2.42168237773095`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[2.42168237773095*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34214$34265, 
                    FEPrivate`Not[DynamicChart`click$34214$34265]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34214$34265, {{{1., 0}, {
                   0, 1.}}, {-0.19392406660075512`, 0.04892296386182981}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34214$34265}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{{}, InsetBox[
                    InterpretationBox["\<\"Germany\"\>",
                    Entity["Country", "Germany"],
                    
                    BaseStyle->
                    "Entity"], {-0.4466173406248458, 0.4949519123082917}]}, \
{}},
                   StatusArea[#, 3.35577242985472*^12]& ,
                   TagBoxNote->"3.35577242985472*^12"],
                  StyleBox["3.35577242985472`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[3.35577242985472*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34219$34265, 
                    FEPrivate`Not[DynamicChart`click$34219$34265]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34219$34265, {{{1., 0}, {
                   0, 1.}}, {-0.13398520218745377`, 0.14848557369248752`}}, {{
                 1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34219$34265}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{{}, InsetBox[
                    InterpretationBox["\<\"Japan\"\>",
                    Entity["Country", "Japan"],
                    
                    BaseStyle->
                    "Entity"], {0.019393393675592775, 0.6663845291768018}]}, \
{}},
                   StatusArea[#, 4.12325760961474*^12]& ,
                   TagBoxNote->"4.12325760961474*^12"],
                  StyleBox["4.12325760961474`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[4.12325760961474*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34224$34265, 
                    FEPrivate`Not[DynamicChart`click$34224$34265]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34224$34265, {{{1., 0}, {0, 1.}}, {
                  0.005818018102677833, 0.19991535875304056`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34224$34265}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{{}, InsetBox[
                    InterpretationBox["\<\"United Kingdom\"\>",
                    Entity["Country", "UnitedKingdom"],
                    
                    BaseStyle->
                    "Entity"], {0.4498002003234048, 0.49206119968299605}]}, \
{}},
                   StatusArea[#, 2.84875544942134*^12]& ,
                   TagBoxNote->"2.84875544942134*^12"],
                  StyleBox["2.84875544942134`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[2.84875544942134*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34229$34265, 
                    FEPrivate`Not[DynamicChart`click$34229$34265]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34229$34265, {{{1., 0}, {0, 1.}}, {
                  0.13494006009702145`, 0.14761835990489883`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {DynamicChart`click$34229$34265}]], 
              GeometricTransformationBox[
               TagBox[
                TagBox[
                 TooltipBox[
                  TagBox[{{{}, InsetBox[
                    InterpretationBox["\<\"United States\"\>",
                    Entity["Country", "UnitedStates"],
                    
                    BaseStyle->
                    "Entity"], {0.1776713518634432, -0.6425553168182961}]}, \
{}},
                   StatusArea[#, 1.8036648*^13]& ,
                   TagBoxNote->"1.8036648*^13"],
                  StyleBox["1.8036648`*^13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                   False]],
                 Annotation[#, 
                  Style[1.8036648*^13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ],
                
                EventHandlerTag[{
                 "MouseClicked" :> 
                  FEPrivate`Set[DynamicChart`click$34234$34265, 
                    FEPrivate`Not[DynamicChart`click$34234$34265]], 
                  PassEventsDown -> True, Method -> "Preemptive", 
                  PassEventsUp -> True}]], Dynamic[
               If[DynamicChart`click$34234$34265, {{{1., 0}, {0, 1.}}, {
                  0.05330140555903297, -0.19276659504548888`}}, {{1, 0}, {0, 
                 1}}, {{1, 0}, {0, 1}}], 
                TrackedSymbols :> {
                 DynamicChart`click$34234$34265}]]}, {}}, {}}, {}, {}},
          DynamicModuleValues:>{}], {{}, {}}, {{{}, {}, {}, {}}, {}}},
        ContentSelectable->False,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        LabelStyle->{
          GrayLevel[0], FontFamily -> "Arial"},
        PlotRange->{{-1., 1.}, {-1., 1.}},
        PlotRangePadding->Scaled[0.09166666666666669]]], "ExerciseOutput",
       ExpressionUUID->"a4e20de5-cfe3-4e1d-9944-f2b9d31b2d2b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {}, 
           DynamicModuleBox[{
            DynamicChart`click$34214$34265 = False, 
             DynamicChart`click$34219$34265 = False, 
             DynamicChart`click$34224$34265 = False, 
             DynamicChart`click$34229$34265 = False, 
             DynamicChart`click$34234$34265 = False}, {{
              RGBColor[0.5, 0.5, 1.], 
              EdgeForm[{
                GrayLevel[0], 
                Opacity[0.5]}], {{{}, {{
                  RGBColor[0.982864, 0.7431472, 0.3262672], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.647347806323696, 
                    3.141592653589793}]}, 
                    ImageSizeCache -> {{20.585786437626904`, 
                    121.41421356237312`}, {-50.90218006338735, \
-1.58578643762689}}], {}}, StatusArea[#, 2.42168237773095*^12]& , TagBoxNote -> 
                    "2.42168237773095*^12"], 
                    StyleBox["2.42168237773095`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2.42168237773095*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34214$34265, 
                    FEPrivate`Not[DynamicChart`click$34214$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34214$34265, {{{1., 0}, {
                    0, 1.}}, {-0.19392406660075512`, 0.04892296386182981}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34214$34265}]]}, {
                  RGBColor[1., 0.544, 0.2], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.962463096708159, 
                    2.647347806323696}]}, 
                    ImageSizeCache -> {{32.31372276345381, 
                    121.4142135623731}, {-94.99307426322905, \
-1.5857864376268962`}}], {}}, StatusArea[#, 3.35577242985472*^12]& , 
                    TagBoxNote -> "3.35577242985472*^12"], 
                    StyleBox["3.35577242985472`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3.35577242985472*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34219$34265, 
                    FEPrivate`Not[DynamicChart`click$34219$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34219$34265, {{{1., 0}, {
                    0, 1.}}, {-0.13398520218745377`, 
                    0.14848557369248752`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$34219$34265}]]}, {
                  RGBColor[0.784, 0.47519999999999996`, 0.2], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.1209411670601166`, 
                    1.962463096708159}]}, 
                    ImageSizeCache -> {{81.1762957416159, 
                    164.02805420047486`}, {-102.4142135623731, \
-1.5857864376268793`}}], {}}, StatusArea[#, 4.12325760961474*^12]& , 
                    TagBoxNote -> "4.12325760961474*^12"], 
                    StyleBox["4.12325760961474`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4.12325760961474*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34224$34265, 
                    FEPrivate`Not[DynamicChart`click$34224$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34224$34265, {{{1., 0}, {0, 1.}}, {
                    0.005818018102677833, 0.19991535875304056`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34224$34265}]]}, {
                  RGBColor[0.6754608, 0.4848, 0.7224792], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5395343257067293, 
                    1.1209411670601166`}]}, 
                    ImageSizeCache -> {{118.58578643762691`, 
                    205.49311837298745`}, {-92.66420271857906, \
-1.5857864376268793`}}], {}}, StatusArea[#, 2.84875544942134*^12]& , 
                    TagBoxNote -> "2.84875544942134*^12"], 
                    StyleBox["2.84875544942134`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2.84875544942134*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34229$34265, 
                    FEPrivate`Not[DynamicChart`click$34229$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34229$34265, {{{1., 0}, {0, 1.}}, {
                    0.13494006009702145`, 0.14761835990489883`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$34229$34265}]]}, {
                  RGBColor[0.4992, 0.5552, 0.8309304], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.5]}], 
                  GeometricTransformationBox[
                   TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    DiskBox[{0, 0}, 1., {-3.141592653589793, 
                    0.5395343257067293}]}, 
                    ImageSizeCache -> {{20.585786437626894`, 
                    219.4142135623731}, {-54.76039282006511, 
                    96.41421356237313}}], {}}, StatusArea[#, 1.8036648*^13]& ,
                     TagBoxNote -> "1.8036648*^13"], 
                    StyleBox["1.8036648`*^13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1.8036648*^13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34234$34265, 
                    FEPrivate`Not[DynamicChart`click$34234$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                   Dynamic[
                    If[
                    DynamicChart`click$34234$34265, {{{1., 0}, {0, 1.}}, {
                    0.05330140555903297, -0.19276659504548888`}}, {{1, 0}, {0,
                     1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$34234$34265}]]}}}, {}}, {}}, {{{
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{{}, 
                    InsetBox[
                    InterpretationBox["\"France\"", 
                    Entity["Country", "France"], BaseStyle -> 
                    "Entity"], {-0.6464135553358503, 
                    0.16307654620609935`}]}, {}}, 
                    StatusArea[#, 2.42168237773095*^12]& , TagBoxNote -> 
                    "2.42168237773095*^12"], 
                    StyleBox["2.42168237773095`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2.42168237773095*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34214$34265, 
                    FEPrivate`Not[DynamicChart`click$34214$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34214$34265, {{{1., 0}, {
                    0, 1.}}, {-0.19392406660075512`, 0.04892296386182981}}, {{
                   1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34214$34265}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{{}, 
                    InsetBox[
                    InterpretationBox["\"Germany\"", 
                    Entity["Country", "Germany"], BaseStyle -> 
                    "Entity"], {-0.4466173406248458, 
                    0.4949519123082917}]}, {}}, 
                    StatusArea[#, 3.35577242985472*^12]& , TagBoxNote -> 
                    "3.35577242985472*^12"], 
                    StyleBox["3.35577242985472`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[3.35577242985472*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34219$34265, 
                    FEPrivate`Not[DynamicChart`click$34219$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34219$34265, {{{1., 0}, {
                    0, 1.}}, {-0.13398520218745377`, 
                    0.14848557369248752`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                   1}}], TrackedSymbols :> {DynamicChart`click$34219$34265}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{{}, 
                    InsetBox[
                    InterpretationBox["\"Japan\"", 
                    Entity["Country", "Japan"], BaseStyle -> "Entity"], {
                    0.019393393675592775`, 0.6663845291768018}]}, {}}, 
                    StatusArea[#, 4.12325760961474*^12]& , TagBoxNote -> 
                    "4.12325760961474*^12"], 
                    StyleBox["4.12325760961474`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[4.12325760961474*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34224$34265, 
                    FEPrivate`Not[DynamicChart`click$34224$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34224$34265, {{{1., 0}, {0, 1.}}, {
                    0.005818018102677833, 0.19991535875304056`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34224$34265}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{{}, 
                    InsetBox[
                    InterpretationBox["\"United Kingdom\"", 
                    Entity["Country", "UnitedKingdom"], BaseStyle -> 
                    "Entity"], {0.4498002003234048, 
                    0.49206119968299605`}]}, {}}, 
                    StatusArea[#, 2.84875544942134*^12]& , TagBoxNote -> 
                    "2.84875544942134*^12"], 
                    StyleBox["2.84875544942134`*^12", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[2.84875544942134*^12, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34229$34265, 
                    FEPrivate`Not[DynamicChart`click$34229$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34229$34265, {{{1., 0}, {0, 1.}}, {
                    0.13494006009702145`, 0.14761835990489883`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {DynamicChart`click$34229$34265}]], 
                GeometricTransformationBox[
                 TagBox[
                  TagBox[
                   TooltipBox[
                    TagBox[{{{}, 
                    InsetBox[
                    InterpretationBox["\"United States\"", 
                    Entity["Country", "UnitedStates"], BaseStyle -> 
                    "Entity"], {
                    0.1776713518634432, -0.6425553168182961}]}, {}}, 
                    StatusArea[#, 1.8036648*^13]& , TagBoxNote -> 
                    "1.8036648*^13"], 
                    StyleBox["1.8036648`*^13", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[1.8036648*^13, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                  
                  EventHandlerTag[{
                   "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$34234$34265, 
                    FEPrivate`Not[DynamicChart`click$34234$34265]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                 Dynamic[
                  If[
                  DynamicChart`click$34234$34265, {{{1., 0}, {0, 1.}}, {
                    0.05330140555903297, -0.19276659504548888`}}, {{1, 0}, {0,
                    1}}, {{1, 0}, {0, 1}}], 
                  TrackedSymbols :> {
                   DynamicChart`click$34234$34265}]]}, {}}, {}}, {}, {}}, 
            DynamicModuleValues :> {}], {{}, {}}, {{{}, {}, {}, {}}, {}}}, 
          ContentSelectable -> False, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], LabelStyle -> {
            GrayLevel[0], FontFamily -> "Arial"}, 
          PlotRange -> {{-1., 1.}, {-1., 1.}}, PlotRangePadding -> 
          Scaled[0.09166666666666669]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"38676bc5-f402-4721-b6c1-91e9e32e5e75"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a pie chart of the populations of the countries in the G5, giving a \
legend for each wedge.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "37.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"23bbd871-b737-4336-8003-029e1e3019c4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         GraphicsBox[{{}, {}, 
           
           DynamicModuleBox[{
            DynamicChart`click$56604$56743 = False, 
             DynamicChart`click$56627$56743 = False, 
             DynamicChart`click$56630$56743 = False, 
             DynamicChart`click$56633$56743 = False, 
             DynamicChart`click$56636$56743 = False}, {{
              Directive[
               RGBColor[0.5, 0.5, 1.], 
               EdgeForm[
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5]]]], {{{{{{}, {{
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.529430886222643, 
                    3.141592653589793}]}], StatusArea[#, 64101308]& , 
                    TagBoxNote -> "64101308"], 
                    StyleBox["64101308", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[64101308, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56604$56743, 
                    FEPrivate`Not[DynamicChart`click$56604$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56604$56743, {{{1., 0}, {
                    0, 1.}}, {-0.19070436268867297`, 
                    0.060264799439698494`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$56604$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.749913704666187, 
                    2.529430886222643}]}], StatusArea[#, 81625599]& , 
                    TagBoxNote -> "81625599"], 
                    StyleBox["81625599", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[81625599, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56627$56743, 
                    FEPrivate`Not[DynamicChart`click$56627$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56627$56743, {{{1., 0}, {
                    0, 1.}}, {-0.1077370769890175, 0.16850140130533786`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56627$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5444737527105059, 
                    1.749913704666187}]}], StatusArea[#, 126225259]& , 
                    TagBoxNote -> "126225259"], 
                    StyleBox["126225259", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[126225259, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56630$56743, 
                    FEPrivate`Not[DynamicChart`click$56630$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56630$56743, {{{1., 0}, {0, 1.}}, {
                    0.08220945846627682, 0.18232280422010164`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56630$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.06248212913439799, 
                    0.5444737527105059}]}], StatusArea[#, 63556184]& , 
                    TagBoxNote -> "63556184"], 
                    StyleBox["63556184", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[63556184, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56633$56743, 
                    FEPrivate`Not[DynamicChart`click$56633$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56633$56743, {{{1., 0}, {0, 1.}}, {
                    0.1942201572408812, 0.04773395564299467}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56633$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.06248212913439799}]}], 
                    StatusArea[#, 322422965]& , TagBoxNote -> "322422965"], 
                    StyleBox["322422965", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[322422965, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56636$56743, 
                    FEPrivate`Not[DynamicChart`click$56636$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56636$56743, {{{1., 0}, {
                    0, 1.}}, {-0.00624719658278541, -0.19990240752641286`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$56636$56743}]]}}}}}, {}}, {{}}}}, {{{{
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 64101308]& , TagBoxNote -> 
                    "64101308"], 
                    StyleBox["64101308", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[64101308, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56604$56743, 
                    FEPrivate`Not[DynamicChart`click$56604$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                  Dynamic[
                   If[
                   DynamicChart`click$56604$56743, {{{1., 0}, {
                    0, 1.}}, {-0.19070436268867297`, 
                    0.060264799439698494`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$56604$56743}]], 
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 81625599]& , TagBoxNote -> 
                    "81625599"], 
                    StyleBox["81625599", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[81625599, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56627$56743, 
                    FEPrivate`Not[DynamicChart`click$56627$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                  Dynamic[
                   If[
                   DynamicChart`click$56627$56743, {{{1., 0}, {
                    0, 1.}}, {-0.1077370769890175, 0.16850140130533786`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {DynamicChart`click$56627$56743}]], 
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 126225259]& , TagBoxNote -> 
                    "126225259"], 
                    StyleBox["126225259", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[126225259, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56630$56743, 
                    FEPrivate`Not[DynamicChart`click$56630$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                  Dynamic[
                   If[
                   DynamicChart`click$56630$56743, {{{1., 0}, {0, 1.}}, {
                    0.08220945846627682, 0.18232280422010164`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {DynamicChart`click$56630$56743}]], 
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 63556184]& , TagBoxNote -> 
                    "63556184"], 
                    StyleBox["63556184", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[63556184, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56633$56743, 
                    FEPrivate`Not[DynamicChart`click$56633$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                  Dynamic[
                   If[
                   DynamicChart`click$56633$56743, {{{1., 0}, {0, 1.}}, {
                    0.1942201572408812, 0.04773395564299467}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {DynamicChart`click$56633$56743}]], 
                 GeometricTransformationBox[
                  TagBox[
                   TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 322422965]& , TagBoxNote -> 
                    "322422965"], 
                    StyleBox["322422965", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[322422965, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                   
                   EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56636$56743, 
                    FEPrivate`Not[DynamicChart`click$56636$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                  Dynamic[
                   If[
                   DynamicChart`click$56636$56743, {{{1., 0}, {
                    0, 1.}}, {-0.00624719658278541, -0.19990240752641286`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                   TrackedSymbols :> {
                    DynamicChart`click$56636$56743}]]}, {}}}, {}}}, 
            DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, \
{}}}, {ContentSelectable -> False, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], LabelStyle -> {
             GrayLevel[0], FontFamily -> "Arial"}, 
           PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
           Scaled[0.02]}], 
         FormBox[
          FormBox[
           TemplateBox[{
             InterpretationBox["\"France\"", 
              Entity["Country", "France"], BaseStyle -> "Entity"], 
             InterpretationBox["\"Germany\"", 
              Entity["Country", "Germany"], BaseStyle -> "Entity"], 
             InterpretationBox["\"Japan\"", 
              Entity["Country", "Japan"], BaseStyle -> "Entity"], 
             InterpretationBox["\"United Kingdom\"", 
              Entity["Country", "UnitedKingdom"], BaseStyle -> "Entity"], 
             InterpretationBox["\"United States\"", 
              Entity["Country", "UnitedStates"], BaseStyle -> "Entity"]}, 
            "SwatchLegend", DisplayFunction -> (FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]]}, ImageSize -> {10, 10}, 
                    DisplayFunction -> Identity, ImageSize -> 10, 
                    ImagePadding -> All, PlotRangePadding -> None, 
                    AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #2}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #3}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #4}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #5}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                GrayLevel[0], FontFamily -> "Arial", FontFamily -> "Arial"}, 
               Background -> Automatic, StripOnInput -> False], 
              TraditionalForm]& ), 
            InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.982864, 0.7431472, 0.3262672], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.6552426666666666, 0.4954314666666667, 
                    0.21751146666666665`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.982864, 0.7431472, 0.3262672]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.982864, 0.7431472, 0.3262672]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.982864, 0.7431472, 0.3262672], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1., 0.544, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.6666666666666667, 0.3626666666666667, 
                    0.13333333333333336`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "RGBColor[1., 0.544, 0.2]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1., 0.544, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1., 0.544, 0.2], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.784, 0.47519999999999996`, 0.2], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.5226666666666667, 0.31679999999999997`, 
                    0.13333333333333336`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.784, 0.47519999999999996, 0.2]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.6754608, 0.4848, 0.7224792], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.4503072, 0.32320000000000004`, 0.4816528], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.6754608, 0.4848, 0.7224792]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.6754608, 0.4848, 0.7224792]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.6754608, 0.4848, 0.7224792], Editable -> False,
                     Selectable -> False]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; FrontEnd`Private`$ColorSelectorUseMakeBoxes = 
                    True; MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}]}], "]"}], "]"}], 
                    ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.4992, 0.5552, 0.8309304], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.3328, 0.37013333333333337`, 0.5539536], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.4992, 0.5552, 0.8309304]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.4992, 0.5552, 0.8309304]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.4992, 0.5552, 0.8309304], Editable -> False, 
                    Selectable -> False]}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], 
                 ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}], ",", 
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, ImageSize -> 10}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "None", ",", "None", ",", "None", ",", "None", ",", 
                    "None"}], "}"}]}], "}"}]}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"FontFamily", "\[Rule]", "\"Arial\""}]}], "}"}]}],
                  ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& ), Editable -> True], TraditionalForm], 
          TraditionalForm]},
        "Legended",
        DisplayFunction->(GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ),
        Editable->True,
        InterpretationFunction->(RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], 
       "ExerciseOutput",ExpressionUUID->
       "7367a260-d699-4e1c-b1ee-5cfbd81945be"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           GraphicsBox[{{}, {}, 
             
             DynamicModuleBox[{
              DynamicChart`click$56604$56743 = False, 
               DynamicChart`click$56627$56743 = False, 
               DynamicChart`click$56630$56743 = False, 
               DynamicChart`click$56633$56743 = False, 
               DynamicChart`click$56636$56743 = False}, {{
                Directive[
                 RGBColor[0.5, 0.5, 1.], 
                 EdgeForm[
                  Directive[
                   GrayLevel[0], 
                   Opacity[0.5]]]], {{{{{{}, {{
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {2.529430886222643, 
                    3.141592653589793}]}], StatusArea[#, 64101308]& , 
                    TagBoxNote -> "64101308"], 
                    StyleBox["64101308", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[64101308, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56604$56743, 
                    FEPrivate`Not[DynamicChart`click$56604$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56604$56743, {{{1., 0}, {
                    0, 1.}}, {-0.19070436268867297`, 
                    0.060264799439698494`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$56604$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {1.749913704666187, 
                    2.529430886222643}]}], StatusArea[#, 81625599]& , 
                    TagBoxNote -> "81625599"], 
                    StyleBox["81625599", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[81625599, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56627$56743, 
                    FEPrivate`Not[DynamicChart`click$56627$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56627$56743, {{{1., 0}, {
                    0, 1.}}, {-0.1077370769890175, 0.16850140130533786`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56627$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {0.5444737527105059, 
                    1.749913704666187}]}], StatusArea[#, 126225259]& , 
                    TagBoxNote -> "126225259"], 
                    StyleBox["126225259", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[126225259, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56630$56743, 
                    FEPrivate`Not[DynamicChart`click$56630$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56630$56743, {{{1., 0}, {0, 1.}}, {
                    0.08220945846627682, 0.18232280422010164`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56630$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 1., {-0.06248212913439799, 
                    0.5444737527105059}]}], StatusArea[#, 63556184]& , 
                    TagBoxNote -> "63556184"], 
                    StyleBox["63556184", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[63556184, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56633$56743, 
                    FEPrivate`Not[DynamicChart`click$56633$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56633$56743, {{{1., 0}, {0, 1.}}, {
                    0.1942201572408812, 0.04773395564299467}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56633$56743}]]}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[2.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    DiskBox[{0, 0}, 
                    1., {-3.141592653589793, -0.06248212913439799}]}], 
                    StatusArea[#, 322422965]& , TagBoxNote -> "322422965"], 
                    StyleBox["322422965", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[322422965, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56636$56743, 
                    FEPrivate`Not[DynamicChart`click$56636$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56636$56743, {{{1., 0}, {
                    0, 1.}}, {-0.00624719658278541, -0.19990240752641286`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$56636$56743}]]}}}}}, {}}, {{}}}}, {{{{
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 64101308]& , TagBoxNote -> 
                    "64101308"], 
                    StyleBox["64101308", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[64101308, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56604$56743, 
                    FEPrivate`Not[DynamicChart`click$56604$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56604$56743, {{{1., 0}, {
                    0, 1.}}, {-0.19070436268867297`, 
                    0.060264799439698494`}}, {{1, 0}, {0, 1}}, {{1, 0}, {0, 
                    1}}], TrackedSymbols :> {
                    DynamicChart`click$56604$56743}]], 
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 81625599]& , TagBoxNote -> 
                    "81625599"], 
                    StyleBox["81625599", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[81625599, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56627$56743, 
                    FEPrivate`Not[DynamicChart`click$56627$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56627$56743, {{{1., 0}, {
                    0, 1.}}, {-0.1077370769890175, 0.16850140130533786`}}, {{
                    1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56627$56743}]], 
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 126225259]& , TagBoxNote -> 
                    "126225259"], 
                    StyleBox["126225259", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[126225259, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56630$56743, 
                    FEPrivate`Not[DynamicChart`click$56630$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56630$56743, {{{1., 0}, {0, 1.}}, {
                    0.08220945846627682, 0.18232280422010164`}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56630$56743}]], 
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    TagBox[{{}, {}}, StatusArea[#, 63556184]& , TagBoxNote -> 
                    "63556184"], 
                    StyleBox["63556184", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[63556184, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56633$56743, 
                    FEPrivate`Not[DynamicChart`click$56633$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56633$56743, {{{1., 0}, {0, 1.}}, {
                    0.1942201572408812, 0.04773395564299467}}, {{1, 0}, {0, 
                    1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {DynamicChart`click$56633$56743}]], 
                   GeometricTransformationBox[
                    TagBox[
                    TagBox[
                    TooltipBox[
                    
                    TagBox[{{}, {}}, StatusArea[#, 322422965]& , TagBoxNote -> 
                    "322422965"], 
                    StyleBox["322422965", {
                    GrayLevel[0], FontFamily -> "Arial"}, StripOnInput -> 
                    False]], Annotation[#, 
                    Style[322422965, {
                    GrayLevel[0], FontFamily -> "Arial"}], "Tooltip"]& ], 
                    
                    EventHandlerTag[{
                    "MouseClicked" :> 
                    FEPrivate`Set[DynamicChart`click$56636$56743, 
                    FEPrivate`Not[DynamicChart`click$56636$56743]], 
                    PassEventsDown -> True, Method -> "Preemptive", 
                    PassEventsUp -> True}]], 
                    Dynamic[
                    If[
                    DynamicChart`click$56636$56743, {{{1., 0}, {
                    0, 1.}}, {-0.00624719658278541, -0.19990240752641286`}}, \
{{1, 0}, {0, 1}}, {{1, 0}, {0, 1}}], 
                    TrackedSymbols :> {
                    DynamicChart`click$56636$56743}]]}, {}}}, {}}}, 
              DynamicModuleValues :> {}], {{{}, {}}}, {{{{}, {}, {}, {}}}, \
{}}}, {ContentSelectable -> False, GridLinesStyle -> Directive[
               GrayLevel[0.5, 0.4]], LabelStyle -> {
               GrayLevel[0], FontFamily -> "Arial"}, 
             PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}, PlotRangePadding -> 
             Scaled[0.02]}], 
           FormBox[
            FormBox[
             TemplateBox[{
               InterpretationBox["\"France\"", 
                Entity["Country", "France"], BaseStyle -> "Entity"], 
               InterpretationBox["\"Germany\"", 
                Entity["Country", "Germany"], BaseStyle -> "Entity"], 
               InterpretationBox["\"Japan\"", 
                Entity["Country", "Japan"], BaseStyle -> "Entity"], 
               InterpretationBox["\"United Kingdom\"", 
                Entity["Country", "UnitedKingdom"], BaseStyle -> "Entity"], 
               InterpretationBox["\"United States\"", 
                Entity["Country", "UnitedStates"], BaseStyle -> "Entity"]}, 
              "SwatchLegend", DisplayFunction -> (FormBox[
                StyleBox[
                 StyleBox[
                  PaneBox[
                   TagBox[
                    GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.982864, 0.7431472, 0.3262672]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[1., 0.544, 0.2]]}, ImageSize -> {10, 10}, 
                    DisplayFunction -> Identity, ImageSize -> 10, 
                    ImagePadding -> All, PlotRangePadding -> None, 
                    AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #2}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.784, 0.47519999999999996`, 0.2]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #3}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.6754608, 0.4848, 0.7224792]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #4}, {
                    GraphicsBox[{
                    GrayLevel[0.9], 
                    Directive[
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]], 
                    RectangleBox[{0, 0}, {1, 1}]}, {
                    DisplayFunction -> Identity, 
                    DefaultBaseStyle -> {"Graphics", 
                    Directive[
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    EdgeForm[
                    Directive[
                    GrayLevel[0], 
                    Opacity[0.5]]], 
                    RGBColor[0.4992, 0.5552, 0.8309304]]}, 
                    ImageSize -> {10, 10}, DisplayFunction -> Identity, 
                    ImageSize -> 10, ImagePadding -> All, PlotRangePadding -> 
                    None, AspectRatio -> Full}, {
                    AspectRatio -> Full, ImageSize -> {10, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)}], #5}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                     "Grid"], Alignment -> Left, AppearanceElements -> None, 
                   ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                   "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                  GrayLevel[0], FontFamily -> "Arial", FontFamily -> "Arial"},
                  Background -> Automatic, StripOnInput -> False], 
                TraditionalForm]& ), 
              InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"EdgeForm", "[", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], "GrayLevel[0]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    F