(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    304372,       6278]
NotebookOptionsPosition[    235366,       4832]
NotebookOutlinePosition[    294750,       6052]
CellTagsIndexPosition[    294671,       6047]
WindowTitle->Creating Websites and Apps: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Deploy a map of your current location to the web.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"74eca68a-714e-4b12-a033-15fc4d4f3654"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bdac96b1-3692-4479-8d15-b484b979cfae"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXM9LK8+Wl5nNLGczf8D8A65nMRsXdzGrQIbZiC7eI19lFr4J3zc4uhBE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            "], {{0, 21}, {572, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{572, 21},
          PlotRange->{{0, 572}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{576, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "48208485-fd1f-4160-b81e-488e1c7e682b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXM9LK8+Wl5nNLGczf8D8A65nMRsXdzGrQIbZiC7eI19lFr4J3zc4uhBE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              "], {{0, 21}, {572, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {572, 21}, 
            PlotRange -> {{0, 572}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bda3903c-eb92-4f1b-ab39-7c0d4e8aeafb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"02ea36b3-73cf-4a18-84be-000b24ff8d59"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c4ea8ccd-601c-41d1-b68c-1ab64c6bd53c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"73fe4dda-a483-47f5-af7b-202b61ba0483"],

Cell["\<\
Deploy to the web a map that shows the current inferred location of the user.\
\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"0d1f9782-637b-49c0-996e-6545a4977353"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6c3b708c-2bc9-4bc5-a0e9-b6fe8899407c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXM9LK8+Wl5nNLGczf8D8A66H2bm4i1kF8piN6OI9/Cqz8DvhvcHRhSCC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            "], {{0, 21}, {570, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{570, 21},
          PlotRange->{{0, 570}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{574, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7d44ce3f-c68f-48dc-ac88-0cf6fb945071"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXM9LK8+Wl5nNLGczf8D8A66H2bm4i1kF8piN6OI9/Cqz8DvhvcHRhSCC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              "], {{0, 21}, {570, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {570, 21}, 
            PlotRange -> {{0, 570}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c95c9235-e5cc-4353-b3ea-a49a6397d036"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"02ef6eee-0141-4f99-a5f7-ac6020cdc861"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9a198ace-8c9f-44b3-bca1-78afda054a1a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a2d769e6-ba57-4d3f-aab8-3813c242a147"],

Cell["\<\
Create a website that displays a new random number up to 1000 at size 100 \
every time it is visited.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"de01f540-c8a0-4d7d-82dd-82d9c4763e5a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8f470520-201c-4799-9795-09322705e1ea"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXM1LK9uWl+7JG/ak/4D+Bxz3NAMHPQqk6Yno4D28Sg+8He572DoQRBAU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            "], {{0, 21}, {577, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{577, 21},
          PlotRange->{{0, 577}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{581, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "80c6c144-1fa8-474c-99c2-89c3db1163a2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXM1LK9uWl+7JG/ak/4D+Bxz3NAMHPQqk6Yno4D28Sg+8He572DoQRBAU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              "], {{0, 21}, {577, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {577, 21}, 
            PlotRange -> {{0, 577}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8393874f-e435-4fb0-8c46-41ecc7833818"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2e4d4a91-a825-4926-baaf-7ebdf755c43d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c42b13cd-1ff7-4f41-8014-6ec3d35de3bf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1f3ff342-b9b5-47e8-865d-7f0cad2dfb52"],

Cell[TextData[{
 "Deploy a form on the web that takes a number ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"452f6008-1f5d-4e3f-8340-531a932e6bf9"],
 " and returns ",
 Cell[BoxData[
  RowBox[{"x", "^", "x"}]], "InlineCode",ExpressionUUID->
  "19338d91-6147-41de-b73b-72ef4e66ff1a"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"281d2973-66b5-43b7-ab94-fa5d006e7dbb"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"69fd519f-894c-4cd4-b566-9744860b60ce"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd1LK8uWz8y8zOP8C/MHTJ7n1Qcf5imQYV7EPNyLR5kHz4RzB0cfBBEE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            "], {{0, 45}, {501, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{501, 45},
          PlotRange->{{0, 501}, {0, 45}}]], "ExerciseOutput",
         ImageSize->{505, 45},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "20930bf8-12e7-4dd0-ac42-db4bc9195c26"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd1LK8uWz8y8zOP8C/MHTJ7n1Qcf5imQYV7EPNyLR5kHz4RzB0cfBBEE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              "], {{0, 45}, {501, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {501, 45}, 
            PlotRange -> {{0, 501}, {0, 45}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b897caa6-d892-48a1-bdf0-02dd21177988"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"97c534a7-fed5-4457-97d6-cc4ca94c9526"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"50601605-3115-47ee-8574-40b8113790d7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e17b9c61-253e-45f2-a0c9-09473b4922c1"],

Cell[TextData[{
 "Deploy a form on the web that takes numbers ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"2554218e-3548-4bea-bbe7-bc71e80db1de"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"db453c67-1dc9-40aa-b7e2-b206e3d85778"],
 " and computes ",
 Cell[BoxData[
  RowBox[{"x", "^", "y"}]], "InlineCode",ExpressionUUID->
  "a50e045c-7c4b-4726-8e5c-45ffa4f7044d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"05730d12-937e-48d6-b92c-4d432a6f8fa2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b4136004-7091-402f-b06e-6c13560ad3e6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztPE1LK9uW0j3pYU/6B/QfcNyTHjhw0KOATU9EB++Rq/TA+8J9ja0DQQRB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            "], {{0, 21}, {573, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{573, 21},
          PlotRange->{{0, 573}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{577, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8da5db9c-911b-4f97-82a8-544e9045cef9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztPE1LK9uW0j3pYU/6B/QfcNyTHjhw0KOATU9EB++Rq/TA+8J9ja0DQQRB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              "], {{0, 21}, {573, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {573, 21}, 
            PlotRange -> {{0, 573}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"397f7e93-5408-4e6f-ac1c-6e5fdd400ddb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"daef2f72-3218-4074-a52b-bbf6749eada1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8156b4a8-ee2e-49d9-a89b-aedc428c5d30"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"be1e6874-bec2-4c8f-8704-726b8d464a90"],

Cell["\<\
Deploy a form on the web that takes the topic of a Wikipedia page and gives a \
word cloud for the page.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"9d28cae0-12f1-45b8-b5d1-5ab0340470dd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2686b153-3b51-4de6-8e25-438ca5d13907"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd9LI8uXz+6+7OP+C/sHbJ73NQ/zsE+BLPsi+vD94lX2we+G+11cfRBE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            "], {{0, 45}, {500, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 45},
          PlotRange->{{0, 500}, {0, 45}}]], "ExerciseOutput",
         ImageSize->{504, 45},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7963230f-7948-44a9-95a6-d4225a4d55f2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd9LI8uXz+6+7OP+C/sHbJ73NQ/zsE+BLPsi+vD94lX2we+G+11cfRBE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              "], {{0, 45}, {500, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 45}, 
            PlotRange -> {{0, 500}, {0, 45}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"246467a8-9617-4cb1-bdbb-5ce572670ede"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2a71f4bf-923b-48b5-b6c7-b8cc86501e86"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3424e066-03e7-48c1-846a-2502479039c2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a3de2f4c-7fd3-4d4d-8dc3-3e05ffd77857"],

Cell["\<\
Deploy a form page on the web that takes a string and repeatedly gives a \
reversed version at size 50.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"73dc9779-a78f-4917-8c9e-c4e11b8f25c0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b89544d7-d9a2-46b0-b1f6-ea9085d15861"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztPM9LK0uXMrOZ5WzmD5h/IOuZZRYuZhVwmI3o4vvwKbPwm/C+wdGFEARB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            "], {{0, 21}, {569, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{569, 21},
          PlotRange->{{0, 569}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{573, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c0e20327-2e8c-47ff-8db1-44d0122e710f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztPM9LK0uXMrOZ5WzmD5h/IOuZZRYuZhVwmI3o4vvwKbPwm/C+wdGFEARB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              "], {{0, 21}, {569, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {569, 21}, 
            PlotRange -> {{0, 569}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"79068fec-7a62-49ce-992e-14797114c089"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0f8fda4e-4d1c-4324-b79e-07c9e8dda4c5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"25d1d2d1-83cd-40f4-acec-3ea804f77132"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7b4ed737-323f-4214-90a8-2d4a3df1fa60"],

Cell[TextData[{
 "Deploy a form page on the web that takes an integer ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2cccb245-9d6e-4729-b98c-326122458b9c"],
 " and repeatedly generates a picture of a polygon with random color and ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"202b847c-011b-42c0-bb6a-dc33e45a9264"],
 " sides."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"21263842-ba34-49f5-a3b0-869e7c612355"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b937ad1e-2e7d-4464-8fa1-68be1644ecdf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztPM9LK92S4c1mlm8zf8D8A1nPYjZZuJhVwMdsRBfvkc8wC78J3xscXQgi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            "], {{0, 21}, {572, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{572, 21},
          PlotRange->{{0, 572}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{576, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "98c25101-c182-4429-a027-d474f64a972e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztPM9LK92S4c1mlm8zf8D8A1nPYjZZuJhVwMdsRBfvkc8wC78J3xscXQgi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              "], {{0, 21}, {572, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {572, 21}, 
            PlotRange -> {{0, 572}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"868cc116-1748-4bbe-9b7b-fc57e8f98d1a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"85e03a1c-5dee-4c01-a1b0-663b9524942d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"10a153ca-2856-46eb-95d3-7cc8fc23c7b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9d806169-bca5-4337-9ada-757b371b57d3"],

Cell[TextData[{
 "Deploy a form page that takes a location and a number ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"43f213da-7655-4469-9a4f-f25571a1b2f0"],
 " and repeatedly gives a map of the\[ThinSpace] ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"3eaead6e-d342-478c-a535-1db4d30e6321"],
 " nearest volcanoes to the location."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "36.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"92ed57b9-0b0d-4718-9843-691ac3309e4d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef76b007-3509-4253-a2bc-f199d2279204"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd1LK8uWz8y8zOP8C/MHjM/z6sN+mKeAl3kRfbgXjzIP3gnnDo4+CCII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            "], {{0, 45}, {500, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 45},
          PlotRange->{{0, 500}, {0, 45}}]], "ExerciseOutput",
         ImageSize->{504, 45},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a0f10790-dd29-475a-b8b4-66d93f2cf28e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd1LK8uWz8y8zOP8C/MHjM/z6sN+mKeAl3kRfbgXjzIP3gnnDo4+CCII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              "], {{0, 45}, {500, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 45}, 
            PlotRange -> {{0, 500}, {0, 45}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"46e98049-7bc0-45d5-b235-cfff6d18e3d8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["36.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2ded7dc0-4f15-4e87-9088-1c5fbff83dd4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"aaab14e4-58ce-4fe7-a3b3-a54bff90132f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"13858ca7-1d53-44ef-8ec7-2ae15c0a3e94"],

Cell["\<\
Create a website that displays a random red regular polygon with between 3 \
and 8 sides every time it is visited.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+36.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"d936be9e-b584-47c2-a1e1-60537b53d015"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6f3ad86c-3de4-4144-a999-5772676d94f4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztPE1LK9uW0j3pYU/6B/QfyPhNHTjoUcCmJ6KD98hVeuDt8N7D1oEggqAg
iELAgBIUIpLgwRCCHxiUKETFsjvVdqqJUQvi8TNtNAlsSAXSe6296yvZFc3x
3HvPe12LnENqZ9dea6+1an3tVf7jH/6td/Bvurq6/vR39L/e3/979x//+Pux
f/57evEvP//pX4d+/sn3Tz//+aehn/74uz/8LR38B/rvd3Q+fG+44IILLrjg
ggsuuOCCCy644IILLrjgggsu/OUAUUJdHLqPy781NS644IILLnwYpPluZr69
i5LjpPJX6Vgua59ERRRJUl/eW8URl0Y+QUBZXuzq8kQlJa/ky1rtWlYLr/Vv
X+6vDiq3hczlm35Vyx5J65tS+qb6iyH8PiKwk/3bgDMN9c9o7F80aNVi5vyu
8luT8cNABw/U91bpX+FZtkO1lDkvVL635pef1Hw+Hx3zeGZ0P/WSjy3ODA72
D/onY9JXmCPNUEf22TSkfOzp6po5fuGX2ksquugfpDC2GE29GLPEuEi4nw77
8x1tXyNl3VKgn+qWCF5Ur3q9wbnzFsFptQqpO15+E9yfHM4lCoi0EJg9LPyo
hisTXO7x7pXwey4S6fEG6Wd08+6Xwuckgg7BSvYvB6YQO6ChtjFCeRi77kTi
GqmR91SuPTEN8nZ2lInvXpxd2igqyEp8U0rJxXcH75Wr7YSUPL8jbYggpaxS
0D93zy1TK/Ie1Z+zTsUrXrZ2fa7EKUknBavjExLfFqo5CI1q9NvzTcGCCHC1
t6ud4CIZyv/ERebW3HxHD9SHVLpaOtunWDJndo/2fKkmE9L2kVrSt2NDLdQN
B4XRXovpfRjPFWtspPJQSO5K2/u5a31EOOgserEcSfExtSvF93P35J2ZFOT5
buanNHWL5VeDY5N+L3yZl8rcyH/STxHJC6uhR9Lykx5M4gbHxgYRYfeMirx1
wKWlFsf6x6IvLau2gbI0byxlW5aoQ97gktzMyop80ONdyVTFl98EtfhwcCAC
yvl8lPgVLOo3Qza80tN3iFpB1oeDPVMXvyw+BxF0ChayfzkwhdgJDfV0OOGf
lTqSONiohatvJkZ7UIbQKPXi/0PBHDNXmTAaqz4Y9EfUhuNgLRVcoZcDw/B/
z1TGyVUZ1o99Ai3xRkU5/IZnR7AseQwM446Qzp7hw5LzjtrDWWgN1glS9pKl
vqAVUY93Oe1Mage4tGLAZ1I7vc/8WmcP1LsqXVKkXouUJxJcGc7CVu4lMEAy
UQt1w0lhKpenVv5sXJJMJMYYxUbWFcqvumjQQfQOcqwoaeTtGhIQgbscZjKQ
uJ9iaUv3FvMZ1DuEQkpZ5DssqcoHQCtTjdcUw0/lo4MUzdgWF7oaGwPPGM03
uEPxysBEQtqiIKTc+hxZb9IUM4dq8lMD1EgqEACQqolDu0QOE/GlDnVSrTUN
ESdKtTuqBvFbGiHXk+PBgbBzGPyrQxN3LU9Hbd3XSmrdGuc77NfGmVYusUF+
HxOBzU8JGNsG2ORcZM3poYbcpIlIpwRZo1mMcdEyxxSisXIL63xpwsbbkSze
oMkT9FO9IRvnm1ndQox1gvZwMdC3wzI49DgrENZWryirh8LwrJ2F6OBalrQb
nDsCw1A6p0HasjUqtvITteXgmQ5qdfqx76cGrLhJf9BPtV9We8hQYxW/Ab4V
dmmkF1xViJj4tkBuJGZL2V0NXB9RlALUHo5L1gVsPO8E1z3EopRaeN63Z6n1
jqEsBQ+U8Al6V6UZXG9Sf7R3j3dsjNNN7VGONR4uLN4nFwgzj2OiFuqGWGEa
1SUfejrYaTUePMwRStWXoRBGUNrjNOXkrIKkCgbRT61lNfZYcd0Qy5G50ZFT
gitM0DBg885hJgfup56SHjiokps4Y/dT5eSin3ckDC4q3PIrfk93WL+I+rsH
wwqbraZCLEHzdEMGtQh+qhyiHqt73pIcPcEpmTdEOK6uyflJhqJ/MsamKWG/
xx/lFL/IM/0etur8Vp6v8aIs+vlZm38xdRYd0xsnujyD4buWfGp6U5rD4Ken
L5Yp1nOJhBE/9I6f/qf9sqI9zvlW5iLpCeblfYmzBxRB9S4wwqfNbV6Bdmml
eHBnQ35Drhzquvo4SuONy1pqYW1g4QL1op4KRujKLFrIbn7pHZd2P/Grodjt
UcC010JghIdA05EcY6nhp3KbMb7xvli2ArsObJ6Owgh9Qmu5o1O/HosG9h+Z
isKchMQ40zuevn5QOWN9O1ndUj3Lkn7jWpzGXXY/dX9+OsSRRuIyK2XUtmdX
RiP86aYaC1JgOl9U54b55FGKyNfyUL/erU6tMCInwjmWJKbCfF8D44c5REtu
TodGDlL7B5wViULhPM0CS3/wwljTIkQn1tFAfWV6do3FlktHj2wu5WTvFDeA
5gZ9sfRDTcST/41zmpd7WZDcqlo2YkSysEDpZIeZHbwlmGKhPVqzJZkIBxtV
EMr0CXJHKwwYfqqFn1lqsUcyjWYgydAXNs0PAlp7x099bNnKqxE4FlgOLia+
HaAz8kUouwZCtoSoBDWTYPKBXQlY2hGuTAj8LI//cfL6JbE9UMIn6CMqbQNS
qnL7XzrfY1K+TlDOR3J232dHbdm1rhs2VuiDzFMEzp22SQJe3bmIBtFPBedC
O1wTFjI8dWqRI71r1Rfs5RIBl8q+i2ZyYH4KC2WeVEtxzeqnUjPgCyajKfk4
CrmXZ5KdYHUbNb1GebGb+g8Jbwyhm1g8lqXoTH8Xm4MFwH7dkTGQF2GMqgDz
U10ef1JWUmHwNd6QjBNgUUCg5WG0e/I4rx6jM4qqhA92ecMp6Xhrvn8wdP1V
iaE/nYkmU1K+ZPdTfm6aclk0IFR7Kw9322jKAgklLT++2i+1qsrsTGD3Kidn
4PY+CGPSCxB4ZB5Kmf2D0YUMeoEcCAirN6C3U7BN7eaUaVEOYqEvGPQ8ovFf
Sb82IIDpAxl95leLcradxiIf75ft80JqM2FEmIafqtxc0N31Th2mTtTSK9/1
RCSTPr/TGm8BHzUpF7mbu/jCGg+YDc4krs4SXDknIkrmJE2N3gAuTlgZYfzg
TFHjwS9z+0Wrn2K5/8BsOqNcrY4v69EUWbXsi1kADAMg7qLMjJ+oZ7sHvVgZ
sD3UfINrG3TC/oF/PA1iwnLWHIhbQtnt3OsPFGVFUlZxO3jXuZoMQf1kW89Z
DCE6sw7mDyycZi9VRj+7l2UHJdg+bNAfuri+vVufoisA9lae3KNeIeeVzC0R
qJaVGKEsmEEolrInuE307GjBMORucJWgllY4SNdcp56x70vqsngWoRMSBU3M
zyxmFtNTXyZm95IyN8yMydObSla+mPa956c+vKx5x63EomsH4h0hi+XE5G1p
Y9j2pDA7ybIAJ5Z2hAukY9T2X3NMw20PlCaS2rsq7QyIkapTPTkV7F1QCpfK
evgwvq+y2+2occSuGwyaBvG8Yy19eZeMpNc3L3JGs5NGnm8fUxHQ/OndR6dB
/lj1xVLKXZo9JhFbLmnIkX6/xoxpblctYDFz46bmNJMB91NYc5Na5GD6KeZi
QjzhIuiGmOtp8lPd4Ke0GDiKMa4ZmszrfsypybYjKHVrjHWM2xoeGo0tfxdz
T+inFsv81KkrBr6Jsv5phs5eZB62K6zYSMe6H5YQRedTc0csbq/HR3jij4U+
zFjZ7dZLvMWow+uxRz05Cwq2LRctgUy9oBSwk60agOgUsEAuP5KBh/4WYpX1
m3oDCiPLEL4e0ZAXmgqoOD7zq0W47aahEpqFo/TCMjg10lL3Y9Un3DVP7S0b
pJqZTuxxFWLMPGHMhMo/HgE0LAFSLQ7VCfvZv+mn2K879/yHIjVfeBfYECP6
Nd2ocoAFc67PuZZiPtugMcHYhV9/WAi6RTAgWEhnBxMYSOgmCFKJYIBHcaYQ
27OOWHANYaVFpxk32HdwD+WsBoFgleYpIp5YOd8QqpZJjFgWSMGqj4frLAxA
F2+wiBeChIMNyFv1CJzuYvNRzE+Wp48k4vuZJUyIoFRoVxVeM4eQ+e368vH6
xvopkY8vawLLieC0Qky8AyL2OEzvw1I40zza07AYaC2itrK0I1wEtah3ZGc1
vMMS81XQKKtYBSgcVdoBi0k/bg17M8jqME/MpxdQgsPpUrNGCXRDOKjHb8HR
2R1M/VZYOslEhp9YTqejdZCfT+kTqAM1c0y7HAGKuSHjIGw4bffO9pkI1nwq
+dRogiY/NSMZPXu66xH7qXKY/jyW1PmhzyFyf0sbPLbHQztf01mYEvIy92T4
KfRoNuhflPCEy9sU6ViXEpxP6bOhboOcbDoBtF3a61QsQkYrXVyf4gWfwK79
dPtVAYsEuQxowsQ+43dpDsuw4LkWlDOKekq5hw4ZlrN/5ldTvm2mFfYhgEm9
6nvEXhGa7Fv7KEwHwQ/yDLbWz/jJ6cro+BpXbBszrc7F+I5V6IWcjTkmP+HX
XvPX6hyPJ/F2vapvkPd8smelv/XQGWva9kMEFmMYD6ZeTLDL11JhsMraFOJH
WNewprf6ONnQy3f6J5Kpinhid80C1bIQI5aFDhp5M7JCyAhMQ1GcQFYIB5lW
byhvWvVxA8uY9HYBP1tohjCPM5nPM3jLur/sHygnfnRZ/TIOeehaGg2mkHgH
RMhnmuAHD5ZCO2gS11aPeNsetm0YAZKYpZ3gghmlm9zSQmJ64TB9ntGjHatY
BSicVLoNFlSGKz+W2oxntmckrTcnHOplPbtGteiGcJD5KTxlowC5niUhqlce
1Lm+psqkbbDJitqP22xyZPwcClH/RjK7e0aBQjSTAz+fekl1QyUvaf6AHRCm
kcdUiDU8wI9qtIu5LVuKVJ73cD+F51CLXNkMp0bzLGyjMJvMNQUSr8GYpuOS
9eP28GBzPvUiKk6+HGOS9dU2aE3NRH6Ks9ISq9siAdulpfWCwj2YLEuBl0t5
OWXh6v1+jAsIe7CT+k9nwZWe4cSELzh3TjDsjARml3tGJO3TvxrQZpq9II8z
vZEsaeun7N45cMKehrshm5/i5l7op8BQ9+nFk4aVn4T3b/cZnZBvc3pTFliY
8YzWJCPdOzTJzgBsAAhuP1iG8NhlNKGfBWAxIdDspyy7sHw3hfge67jWvOZ6
MUiw0IYbHE431fMFPLG7Zn3MVC0rMWJZNGqWvBqzwnPqfQ6hn42ZwaLC4ivh
IJgU747hcANYDxfwExNDK81wMMGYvMu1nBj5lFYrvVZtH+wW+Oiy+D0+S1m9
vM0tZ0NIvAOiWnrzcCl8uBSifmpvCLKDtfUTSxve7IWBU8jSTnDZ5SazDdat
D4UQhaNKt8FSvIKSvu/A0B/I+3xcCVHDW/2UQDfECqNYtqyX3zVibvBZt37C
QfZY6VWp2sa4kU81y5EdkRgPBiSSXoeZOuj9fg05BKdI/TNRWVWV41g/+BmZ
5VlbKqS2WMrzhFLK13xqzIPvNAEi1Y+JTf5JjU1CO7sXz6dUVvgLHz89qVEc
ZzkXyUfxNGkyJSuKnJzE9gc4ZtL7KAbnY3lVTYbgdn8M3KLhp+gMINE7I6lP
T1/l8GIYCChLeFg2RulS5S3/4Lyq8QphWKIrPdnOp6qtfgrzKVaLkB8Lt29a
0yWGiz3DO+nL4vX56QDPUt9WR9YCu2qJ1K5BTOinSGECkvFbo8GvdL5jlrhh
WZZWoyJphVF2UsZbWD/xK8d79+40P3Y4nN2Uskewwd5grsGbAXbw9S6Lbleb
/BQWx06KpWJhCQ9i4Kfqu36KJ0FDC9J1sZRJ7E2ErhgZoxHoK2Umyx+6KDw8
buM50aqiF6y8keRlKXeE22EhXFGBisrIQa74lt3HYj6rDBjbr+LhY18ifVkq
KBcT4wcFrbYNsdny+snd/U1uGoxV7Jo458vmd3uXZjvWraweFQo36tKIcSBo
Ghw87A6OhpX712pBvljdvNKEPOEVwp3sQ/H64alFtWzECGWBNZZE6rJUKha3
g8BJKPizY8rx00KxuA7FRmzDEA3eH8HxYmC3UKFIT4DngfO3Vn7m/+uQMfO5
WGLdKRPgnljmEtlWis+cyW3Ppz667NvG1DKyOpNV1LPzq8xlSbyj96Fu77tr
zjXE6t0JLq2YmxhBEyFLYC6mWJRl9VMiFE4q7QDkQWHH66tHalYGnly/1lnJ
cWLzqvT6yOi8tj/LQt0QKwwWZHpGDik9GWwnW/8fENZQkOpqFZ4gH4ZY2p1g
UC8bjoYy17fFVITJ8VEsR3ygeqdOC6+1ysMV6MwIzSpEM3Uw/BRl9nHY0inX
P6+UtcZTEj3JPJh5TV0c9BiNdEmVu0MpxJsAqY8JjXVjPkWhzNwWzh3rN2uD
jRcZ2zD00l1U5uPsjMyv/9Y/s8UQmH6Kzslvmfd6BlNfQSRlJerVx7r9YShe
kvwkbwDsP/sPaz4F/LH4qTVeGiWPvFGNVdKsl6xbwMfbk3p8iSw2JxgNTiAO
tLqskXVg+XwIG/xAQ8aDtpdiCDoO/l4ANU3LRgX4U78yvDwPardI5Sbj12ke
mDplDvQ6ARrlh6QDDI6xjt9WUCot6SUs/2yCn4vZ5hA0BdxPbQy3ljvgg6+p
1uK4FDseymya3ZVzevmU0qnXrteWKJ/1UkPhyCiJr40O62Vty/Yrl9JQ0wa1
IutwgE/fl9QtyIU10Bp+asg44uE1QMKawNctZyhC1oH++CIDemVmlUfLtlwv
q3eYwI0LF0TME0rSKX81JvjfzarVTIxAFuRBndPbEaHzUG8nowzRyVvZviHO
g/V02EQ6GjbeprHzU3vbDpqv6oyG9Lpw8WpC72SbCFKS3un3+8iyRD8rMT8s
rRbt6D0Ao20pYcFJqL0mJlLvTnBpNM3ROdA7brzUb3mgHFCIVdoBMC6y8YSd
m+d2DR1b274kTaiFuuGkMJruCiG+3YTbC9gWpVs/3rMqHGSP1YSxzeBFGzmW
lFNzhZE9Gj06zWRg8VOMUPJCwfJ+EgxYLkkZfm4qN7HBVsY6jUNVEUH47lET
BmXRy/v9jHuBxCa10Vro0mAS0T78qnKd5teWd4X0S4yxV6mV0Ejp1Y4U03Pr
2xCkSm8h15ePbF7p9vG++s4fGfguAHg/+k5bvQJlBBtVdOQjf3+j9caPArDO
SiHlm+Wq+Vc++FysCkwDm2wfs29fsEE6wYbxAwQbQrSAYGWEZjXI6eee+mow
oeXlrJZdE2ISaVUtETFCSjTrClZE1WrzX10QD9ZQE5rub9l1i9qzaYI9toMP
LisCIfGfBrFwO8FVEZUBP4SiRaU7hvcWEeqGWGFQNE2irFAmtGxNONjowFDU
4cH82LuTzX7qhwLypEhJqDGOJd+f7ACf/ZMa1db3Ul1wwQHIW05WoI5h9jy7
4IILn4Uf2U/xN6q6usNyR382qXURoz2jc4DXPZbXlc/GOy78fwC9s3dlQ3ED
Gxdc+G6g/MB+6rsAc3bz0a2trdTTj/rHYF1wwQUXXGiFJyW1ldya7+/q/qv2
UyQf83q6uz2erq7Bz/5BXRdccMEFF35FkEPwhhIFf7j5z/q54IILLrjgwg8F
/wfE3jCO
            "], {{0, 21}, {568, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{568, 21},
          PlotRange->{{0, 568}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{572, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d1d3c9e3-fcce-4be4-89f1-8a205dc49c8b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztPE1LK9uW0j3pYU/6B/QfyPhNHTjoUcCmJ6KD98hVeuDt8N7D1oEggqAg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              "], {{0, 21}, {568, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {568, 21}, 
            PlotRange -> {{0, 568}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0eea5337-9fce-467b-b4d9-468771cbfccf"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x36.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"269644bb-5b36-42f2-80b6-d0cf3cefc99a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d73e4a3d-7584-41da-ba94-fcc49b6c12b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"62d9e78b-d4ef-4c1f-825a-673a0a144d8b"],

Cell[TextData[{
 "Deploy a form on the web that takes numbers ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"8fda780b-4217-44dc-82fc-6a6bdcc6a9a1"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"8fd9fb55-c274-4bb5-a07a-05268883d500"],
 " given in English (e.g. \
\[OpenCurlyDoubleQuote]eight\[CloseCurlyDoubleQuote]) and computes ",
 Cell[BoxData[
  RowBox[{"x", "^", "y"}]], "InlineCode",ExpressionUUID->
  "57f5da74-2d4c-4268-a10a-6dd7424a12bb"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+36.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"409445b7-eafd-456e-98e6-00878f20b86a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34f0c1b0-cf58-4d12-b691-2293e6e2795c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXN1LK113l/aml73pH9B/INe9KuTiXPQqYOmN6MX74mPohU/D8xarF4II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            "], {{0, 21}, {574, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{574, 21},
          PlotRange->{{0, 574}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{578, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7763bff2-b425-4c2f-8285-de1abaf2ce7e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXN1LK113l/aml73pH9B/INe9KuTiXPQqYOmN6MX74mPohU/D8xarF4II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              "], {{0, 21}, {574, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {574, 21}, 
            PlotRange -> {{0, 574}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6a4c005c-a01a-4d9c-9894-3f861fe27d4b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x36.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d19efe53-a10d-492e-9cc1-b9f9679b3537"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"61aeff16-a289-4077-af35-26921628d68e"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9d1f813d-3080-4462-9084-46ecb2363219"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Creating Websites and Apps: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 36  Creating Websites and Apps", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
36-creating-websites-and-apps.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+36.1", "36.1", "+36.2", "36.2", "36.3", "36.4", "36.5", "36.6", 
         "36.7", "36.8", "36.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+36.1", "36.1", "+36.2", "36.2", "36.3", "36.4", "36.5", "36.6", "36.7",
       "36.8", "36.9"}, "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[21005, 416, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c4ea8ccd-601c-41d1-b68c-1ab64c6bd53c",
   CellTags->"FirstInputCell"],
  Cell[42618, 857, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9a198ace-8c9f-44b3-bca1-78afda054a1a",
   CellTags->"FirstInputCell"],
  Cell[64077, 1295, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c42b13cd-1ff7-4f41-8014-6ec3d35de3bf",
   CellTags->"FirstInputCell"],
  Cell[85931, 1743, 813, 26, 
  70, "Input", "ExpressionUUID" -> "50601605-3115-47ee-8574-40b8113790d7",
   CellTags->"FirstInputCell"],
  Cell[107415, 2186, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8156b4a8-ee2e-49d9-a89b-aedc428c5d30",
   CellTags->"FirstInputCell"],
  Cell[128365, 2616, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3424e066-03e7-48c1-846a-2502479039c2",
   CellTags->"FirstInputCell"],
  Cell[149070, 3042, 813, 26, 
  70, "Input", "ExpressionUUID" -> "25d1d2d1-83cd-40f4-acec-3ea804f77132",
   CellTags->"FirstInputCell"],
  Cell[169446, 3464, 813, 26, 
  70, "Input", "ExpressionUUID" -> "10a153ca-2856-46eb-95d3-7cc8fc23c7b4",
   CellTags->"FirstInputCell"],
  Cell[191247, 3909, 813, 26, 
  70, "Input", "ExpressionUUID" -> "aaab14e4-58ce-4fe7-a3b3-a54bff90132f",
   CellTags->"FirstInputCell"],
  Cell[212307, 4341, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d73e4a3d-7584-41da-ba94-fcc49b6c12b4",
   CellTags->"FirstInputCell"],
  Cell[234238, 4791, 813, 26, 
  70, "Input", "ExpressionUUID" -> "61aeff16-a289-4077-af35-26921628d68e",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 293135, 6010}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[649, 22, 482, 10, 70, "Exercise", "ExpressionUUID" -> \
"74eca68a-714e-4b12-a033-15fc4d4f3654",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1156, 36, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"bdac96b1-3692-4479-8d15-b484b979cfae"],
Cell[1815, 58, 18583, 333, 70, "ExerciseOutput", "ExpressionUUID" -> \
"bda3903c-eb92-4f1b-ab39-7c0d4e8aeafb"]
}, Closed]],
Cell[CellGroupData[{
Cell[20435, 396, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"02ea36b3-73cf-4a18-84be-000b24ff8d59"],
Cell[21005, 416, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c4ea8ccd-601c-41d1-b68c-1ab64c6bd53c",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21855, 447, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"73fe4dda-a483-47f5-af7b-202b61ba0483"],
Cell[22142, 458, 520, 13, 70, "Exercise", "ExpressionUUID" -> \
"0d1f9782-637b-49c0-996e-6545a4977353",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[22687, 475, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6c3b708c-2bc9-4bc5-a0e9-b6fe8899407c"],
Cell[23346, 497, 18665, 335, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c95c9235-e5cc-4353-b3ea-a49a6397d036"]
}, Closed]],
Cell[CellGroupData[{
Cell[42048, 837, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"02ef6eee-0141-4f99-a5f7-ac6020cdc861"],
Cell[42618, 857, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9a198ace-8c9f-44b3-bca1-78afda054a1a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43480, 889, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a2d769e6-ba57-4d3f-aab8-3813c242a147"],
Cell[43767, 900, 542, 13, 70, "Exercise", "ExpressionUUID" -> \
"de01f540-c8a0-4d7d-82dd-82d9c4763e5a",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[44334, 917, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8f470520-201c-4799-9795-09322705e1ea"],
Cell[44993, 939, 18477, 331, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8393874f-e435-4fb0-8c46-41ecc7833818"]
}, Closed]],
Cell[CellGroupData[{
Cell[63507, 1275, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2e4d4a91-a825-4926-baaf-7ebdf755c43d"],
Cell[64077, 1295, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c42b13cd-1ff7-4f41-8014-6ec3d35de3bf",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64939, 1327, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1f3ff342-b9b5-47e8-865d-7f0cad2dfb52"],
Cell[65226, 1338, 725, 19, 70, "Exercise", "ExpressionUUID" -> \
"281d2973-66b5-43b7-ab94-fa5d006e7dbb",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[65976, 1361, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"69fd519f-894c-4cd4-b566-9744860b60ce"],
Cell[66635, 1383, 18689, 335, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b897caa6-d892-48a1-bdf0-02dd21177988"]
}, Closed]],
Cell[CellGroupData[{
Cell[85361, 1723, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"97c534a7-fed5-4457-97d6-cc4ca94c9526"],
Cell[85931, 1743, 813, 26, 70, "Input", "ExpressionUUID" -> \
"50601605-3115-47ee-8574-40b8113790d7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86793, 1775, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e17b9c61-253e-45f2-a0c9-09473b4922c1"],
Cell[87080, 1786, 827, 22, 70, "Exercise", "ExpressionUUID" -> \
"05730d12-937e-48d6-b92c-4d432a6f8fa2",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[87932, 1812, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b4136004-7091-402f-b06e-6c13560ad3e6"],
Cell[88591, 1834, 18217, 327, 70, "ExerciseOutput", "ExpressionUUID" -> \
"397f7e93-5408-4e6f-ac1c-6e5fdd400ddb"]
}, Closed]],
Cell[CellGroupData[{
Cell[106845, 2166, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"daef2f72-3218-4074-a52b-bbf6749eada1"],
Cell[107415, 2186, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8156b4a8-ee2e-49d9-a89b-aedc428c5d30",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108277, 2218, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"be1e6874-bec2-4c8f-8704-726b8d464a90"],
Cell[108564, 2229, 545, 13, 70, "Exercise", "ExpressionUUID" -> \
"9d28cae0-12f1-45b8-b5d1-5ab0340470dd",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[109134, 2246, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"2686b153-3b51-4de6-8e25-438ca5d13907"],
Cell[109793, 2268, 17965, 323, 70, "ExerciseOutput", "ExpressionUUID" -> \
"246467a8-9617-4cb1-bdbb-5ce572670ede"]
}, Closed]],
Cell[CellGroupData[{
Cell[127795, 2596, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2a71f4bf-923b-48b5-b6c7-b8cc86501e86"],
Cell[128365, 2616, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3424e066-03e7-48c1-846a-2502479039c2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129227, 2648, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a3de2f4c-7fd3-4d4d-8dc3-3e05ffd77857"],
Cell[129514, 2659, 544, 13, 70, "Exercise", "ExpressionUUID" -> \
"73dc9779-a78f-4917-8c9e-c4e11b8f25c0",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[130083, 2676, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b89544d7-d9a2-46b0-b1f6-ea9085d15861"],
Cell[130742, 2698, 17721, 319, 70, "ExerciseOutput", "ExpressionUUID" -> \
"79068fec-7a62-49ce-992e-14797114c089"]
}, Closed]],
Cell[CellGroupData[{
Cell[148500, 3022, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0f8fda4e-4d1c-4324-b79e-07c9e8dda4c5"],
Cell[149070, 3042, 813, 26, 70, "Input", "ExpressionUUID" -> \
"25d1d2d1-83cd-40f4-acec-3ea804f77132",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149932, 3074, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7b4ed737-323f-4214-90a8-2d4a3df1fa60"],
Cell[150219, 3085, 772, 18, 70, "Exercise", "ExpressionUUID" -> \
"21263842-ba34-49f5-a3b0-869e7c612355",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[151016, 3107, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b937ad1e-2e7d-4464-8fa1-68be1644ecdf"],
Cell[151675, 3129, 17164, 310, 70, "ExerciseOutput", "ExpressionUUID" -> \
"868cc116-1748-4bbe-9b7b-fc57e8f98d1a"]
}, Closed]],
Cell[CellGroupData[{
Cell[168876, 3444, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"85e03a1c-5dee-4c01-a1b0-663b9524942d"],
Cell[169446, 3464, 813, 26, 70, "Input", "ExpressionUUID" -> \
"10a153ca-2856-46eb-95d3-7cc8fc23c7b4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[170308, 3496, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9d806169-bca5-4337-9ada-757b371b57d3"],
Cell[170595, 3507, 778, 18, 70, "Exercise", "ExpressionUUID" -> \
"92ed57b9-0b0d-4718-9843-691ac3309e4d",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[171398, 3529, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ef76b007-3509-4253-a2bc-f199d2279204"],
Cell[172057, 3551, 18583, 333, 70, "ExerciseOutput", "ExpressionUUID" -> \
"46e98049-7bc0-45d5-b235-cfff6d18e3d8"]
}, Closed]],
Cell[CellGroupData[{
Cell[190677, 3889, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2ded7dc0-4f15-4e87-9088-1c5fbff83dd4"],
Cell[191247, 3909, 813, 26, 70, "Input", "ExpressionUUID" -> \
"aaab14e4-58ce-4fe7-a3b3-a54bff90132f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[192109, 3941, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"13858ca7-1d53-44ef-8ec7-2ae15c0a3e94"],
Cell[192396, 3952, 556, 13, 70, "Exercise", "ExpressionUUID" -> \
"d936be9e-b584-47c2-a1e1-60537b53d015",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[192977, 3969, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6f3ad86c-3de4-4144-a999-5772676d94f4"],
Cell[193636, 3991, 18063, 325, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0eea5337-9fce-467b-b4d9-468771cbfccf"]
}, Closed]],
Cell[CellGroupData[{
Cell[211736, 4321, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"269644bb-5b36-42f2-80b6-d0cf3cefc99a"],
Cell[212307, 4341, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d73e4a3d-7584-41da-ba94-fcc49b6c12b4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213169, 4373, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"62d9e78b-d4ef-4c1f-825a-673a0a144d8b"],
Cell[213456, 4384, 907, 23, 70, "Exercise", "ExpressionUUID" -> \
"409445b7-eafd-456e-98e6-00878f20b86a",
 CounterAssignments->{{"SectionNumber", 36}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[214388, 4411, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"34f0c1b0-cf58-4d12-b691-2293e6e2795c"],
Cell[215047, 4433, 18583, 333, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6a4c005c-a01a-4d9c-9894-3f861fe27d4b"]
}, Closed]],
Cell[CellGroupData[{
Cell[233667, 4771, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"d19efe53-a10d-492e-9cc1-b9f9679b3537"],
Cell[234238, 4791, 813, 26, 70, "Input", "ExpressionUUID" -> \
"61aeff16-a289-4077-af35-26921628d68e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[235078, 4821, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9d1f813d-3080-4462-9084-46ecb2363219"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature vRcEMC4UCF@@TlYSLvqlqe6D *)
