(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    365934,       8605]
NotebookOptionsPosition[    258761,       6450]
NotebookOutlinePosition[    354338,       8405]
CellTagsIndexPosition[    353662,       8376]
WindowTitle->Associations: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Associations", "SectionInline",ExpressionUUID->
   "886bf485-e875-4b70-b802-c41e9c052a31"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 33}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:205",
 CellLabel->"In[37]:=",ExpressionUUID->"ebd2af30-4c40-40cb-b8c0-f11695d882a8"],

Cell[TextData[{
 StyleBox["Associations",
  FontSlant->"Italic"],
 " are a kind of generalization of lists, in which",
 " every element has a key as well as a value. ",
 ButtonBox["Counts",
  BaseStyle->"Link"],
 " is a typical function that produces an association. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"5126f3ff-24a8-4637-8379-e77a22558cd9"],

Cell[TextData[{
 ButtonBox["Counts",
  BaseStyle->"Link"],
 " gives an association ",
 "that reports how many times each different element occurs",
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cb922183-6283-457b-8479-21866c52a084"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Counts", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "a", ",", "b", ",", "c", ",", "a", ",", "a", ",", "b", ",", "c", 
    ",", "c", ",", "a", ",", "a"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"ef082667-9b3d-4e03-8391-92196d450fb4"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "6"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"d4269e8b-abd5-4634-bc37-02543d30d201"]
}, Open  ]],

Cell[TextData[{
 "You can get the value associated with a particular key using ",
 ButtonBox["[",
  BaseStyle->"Link",
  ButtonData->"Key"],
 StyleBox[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"Key"],
  FontColor->GrayLevel[0.6]],
 ButtonBox["]",
  BaseStyle->"Link",
  ButtonData->"Key"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"4264a836-51c6-4430-9184-7ce921d41383"],

Cell[TextData[{
 "Find the value associated with ",
 Cell[BoxData[
 "c"], "InlineCode",ExpressionUUID->"b8f7986a-9e90-4faa-ba28-a54c8235d577"],
 " in the association:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e89d3152-c0f4-4811-9802-5a62a21c902c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "[", "c", 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"c558e78a-ac19-4aa3-904d-eeadd56db00a"],

Cell[BoxData["3"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"7e945870-dd8b-48a1-9405-16f3e0e21a22"]
}, Open  ]],

Cell["\<\
Operations that work on lists typically also work on \
associations\[LongDash]but apply themselves only to the values, not the keys. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4dd2530f-5cfb-4b4f-9019-b7c8d8c8a600"],

Cell["This adds 500 to each value in the association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3f13a923-5a38-4585-b02d-06ec2b265f46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "+", 
  "500"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"ba01eaef-dc3b-41db-b7da-df87a218d8e2"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "506"}], ",", 
   RowBox[{"b", "\[Rule]", "502"}], ",", 
   RowBox[{"c", "\[Rule]", "503"}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"461f16e0-93f3-4bf6-81e3-29c9c0d5526c"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCode",ExpressionUUID->
  "d335ad10-9728-45f8-84dc-22ae63cc476c"],
 " applies a function to each value in the association:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f265de92-409a-4fee-8c6c-c95d665f8aef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"02e5c815-788f-41ce-bf38-9168e0cdfef7"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{"f", "[", "6", "]"}]}], ",", 
   RowBox[{"b", "\[Rule]", 
    RowBox[{"f", "[", "2", "]"}]}], ",", 
   RowBox[{"c", "\[Rule]", 
    RowBox[{"f", "[", "3", "]"}]}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"ec9246fd-822c-4eb4-a371-d195c181e196"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Total",
  BaseStyle->"Link"],
 " gives the total of the values:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"b6774023-9ed7-4754-90b7-439e5bbb3017"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"bcc8d05b-3fa8-4541-9eca-4b18a355e0e2"],

Cell[BoxData["11"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"36914fe6-f2fb-4e93-8393-5ab1ca15a1c7"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Sort",
  BaseStyle->"Link"],
 " operates on the values:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"3e19b49c-3b1d-404f-8144-8871846e71d0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"48b995be-88b1-4c31-a3a9-44f6e70322a6"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}], ",", 
   RowBox[{"a", "\[Rule]", "6"}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"326b17b4-9fdd-4428-a74b-25507bad98b8"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["KeySort",
  BaseStyle->"Link"],
 " operates on the keys:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"99c8058b-c183-4994-b0ae-3ba341803303"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KeySort", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"c", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"a", "\[Rule]", "4"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"d30726ff-4b2f-40b8-a60a-2302c56ce3e8"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "4"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "1"}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[7]=",ExpressionUUID->"bc547cc6-1553-4631-a397-c220bbc86815"]
}, Open  ]],

Cell[TextData[{
 "The functions ",
 ButtonBox["Keys",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Values",
  BaseStyle->"Link"],
 " extract the keys and values of an association. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:206", "i:6"},ExpressionUUID->"45b34fed-c371-4202-a328-53cfe84b3af2"],

Cell["Get the list of keys in the association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"79ec10e7-038d-4918-8214-85c35730eda6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Keys", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"263d88bb-0053-441d-8afd-c657fe85c225"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"6ab535d3-eb38-4d8d-9592-e94095901ede"]
}, Open  ]],

Cell["Get the list of values in the association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5bf15244-702d-4010-9124-73757592edc8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Values", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"20978510-0568-41e0-85c6-f20af3a890b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "2", ",", "3"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"e4f67de0-2e0c-4959-a4e9-da04f297422c"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Normal",
  BaseStyle->"Link"],
 " turns an association into a ",
 "normal",
 " list of rules. ",
 ButtonBox["Association",
  BaseStyle->"Link"],
 " makes an association from a list of rules."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"2ee1d113-3e02-4268-92c8-a4bd9f1d20b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"bf7198ec-d0a1-445a-8179-1894f64b6bc8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "6"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"2f496ae8-f1a7-47a0-b7a3-e9a14cc4f3ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Association", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "6"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"3c879028-8079-487d-82ef-97ace1d5ba4b"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "6"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}]}], "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"4acebfbf-a124-4b1d-ab18-6e3c5c27ee1c"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["LetterCounts",
  BaseStyle->"Link"],
 " ",
 "counts how many",
 " times letters occur in a string. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"a21a2918-cc31-4a8f-b79c-89fc8ff3635c"],

Cell["\<\
Count how many times each letter occurs in the Wikipedia article on computers:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"75f1239b-1f26-4cbc-87ff-b9ad5dee4347"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LetterCounts", "[", 
  RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"fa25ddff-9cc0-42ae-ad33-1c27aa8b0393"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"e\"\>", "\[Rule]", "4833"}], ",", 
   RowBox[{"\<\"t\"\>", "\[Rule]", "3528"}], ",", 
   RowBox[{"\<\"a\"\>", "\[Rule]", "3207"}], ",", 
   RowBox[{"\<\"o\"\>", "\[Rule]", "3059"}], ",", 
   RowBox[{"\<\"r\"\>", "\[Rule]", "2907"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "2818"}], ",", 
   RowBox[{"\<\"n\"\>", "\[Rule]", "2747"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "2475"}], ",", 
   RowBox[{"\<\"c\"\>", "\[Rule]", "1800"}], ",", 
   RowBox[{"\<\"l\"\>", "\[Rule]", "1673"}], ",", 
   RowBox[{"\<\"m\"\>", "\[Rule]", "1494"}], ",", 
   RowBox[{"\<\"h\"\>", "\[Rule]", "1473"}], ",", 
   RowBox[{"\<\"u\"\>", "\[Rule]", "1357"}], ",", 
   RowBox[{"\<\"d\"\>", "\[Rule]", "1329"}], ",", 
   RowBox[{"\<\"p\"\>", "\[Rule]", "1153"}], ",", 
   RowBox[{"\<\"g\"\>", "\[Rule]", "818"}], ",", 
   RowBox[{"\<\"f\"\>", "\[Rule]", "766"}], ",", 
   RowBox[{"\<\"y\"\>", "\[Rule]", "594"}], ",", 
   RowBox[{"\<\"b\"\>", "\[Rule]", "545"}], ",", 
   RowBox[{"\<\"w\"\>", "\[Rule]", "456"}], ",", 
   RowBox[{"\<\"v\"\>", "\[Rule]", "391"}], ",", 
   RowBox[{"\<\"k\"\>", "\[Rule]", "174"}], ",", 
   RowBox[{"\<\"T\"\>", "\[Rule]", "150"}], ",", 
   RowBox[{"\<\"A\"\>", "\[Rule]", "110"}], ",", 
   RowBox[{"\<\"I\"\>", "\[Rule]", "101"}], ",", 
   RowBox[{"\<\"C\"\>", "\[Rule]", "84"}], ",", 
   RowBox[{"\<\"M\"\>", "\[Rule]", "82"}], ",", 
   RowBox[{"\<\"x\"\>", "\[Rule]", "77"}], ",", 
   RowBox[{"\<\"S\"\>", "\[Rule]", "68"}], ",", 
   RowBox[{"\<\"P\"\>", "\[Rule]", "64"}], ",", 
   RowBox[{"\<\"q\"\>", "\[Rule]", "58"}], ",", 
   RowBox[{"\<\"U\"\>", "\[Rule]", "55"}], ",", 
   RowBox[{"\<\"B\"\>", "\[Rule]", "45"}], ",", 
   RowBox[{"\<\"H\"\>", "\[Rule]", "43"}], ",", 
   RowBox[{"\<\"E\"\>", "\[Rule]", "42"}], ",", 
   RowBox[{"\<\"R\"\>", "\[Rule]", "41"}], ",", 
   RowBox[{"\<\"L\"\>", "\[Rule]", "41"}], ",", 
   RowBox[{"\<\"z\"\>", "\[Rule]", "38"}], ",", 
   RowBox[{"\<\"O\"\>", "\[Rule]", "38"}], ",", 
   RowBox[{"\<\"D\"\>", "\[Rule]", "37"}], ",", 
   RowBox[{"\<\"W\"\>", "\[Rule]", "30"}], ",", 
   RowBox[{"\<\"N\"\>", "\[Rule]", "29"}], ",", 
   RowBox[{"\<\"F\"\>", "\[Rule]", "28"}], ",", 
   RowBox[{"\<\"j\"\>", "\[Rule]", "25"}], ",", 
   RowBox[{"\<\"G\"\>", "\[Rule]", "23"}], ",", 
   RowBox[{"\<\"J\"\>", "\[Rule]", "17"}], ",", 
   RowBox[{"\<\"K\"\>", "\[Rule]", "14"}], ",", 
   RowBox[{"\<\"V\"\>", "\[Rule]", "10"}], ",", 
   RowBox[{"\<\"Z\"\>", "\[Rule]", "8"}], ",", 
   RowBox[{"\<\"Q\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"\:016b\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"\:012b\"\>", "\[Rule]", "4"}], ",", 
   RowBox[{"\<\"\[ODoubleDot]\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"\[ABar]\"\>", "\[Rule]", "2"}], ",", 
   RowBox[{"\<\"Y\"\>", "\[Rule]", "1"}], ",", 
   RowBox[{"\<\"X\"\>", "\[Rule]", "1"}], ",", 
   RowBox[{"\<\"\[EAcute]\"\>", "\[Rule]", "1"}], ",", 
   RowBox[{"\<\"\[AHat]\"\>", "\[Rule]", "1"}]}], 
  "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"13d4d4cb-b8ab-4c19-9695-5a23af775b59"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["KeyTake",
  BaseStyle->"Link"],
 " picks out elements of an association that appear in a list of keys you \
specify. Here we\[CloseCurlyQuote]re taking the elements whose keys are \
letters in the (lowercase) alphabet."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"f61458c2-3de5-4b3d-bf1d-5513f6ea3f40"],

Cell["\<\
Take only those elements in the association whose keys appear as letters in \
the alphabet:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b8edd03-215e-48e7-97f8-5dcff2cf1e8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KeyTake", "[", 
  RowBox[{
   RowBox[{"LetterCounts", "[", 
    RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], "]"}], ",", 
   RowBox[{"Alphabet", "[", "\[ThinSpace]", "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"a6f183f7-4a0b-4314-90d7-9923a12d13fd"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"a\"\>", "\[Rule]", "3207"}], ",", 
   RowBox[{"\<\"b\"\>", "\[Rule]", "545"}], ",", 
   RowBox[{"\<\"c\"\>", "\[Rule]", "1800"}], ",", 
   RowBox[{"\<\"d\"\>", "\[Rule]", "1329"}], ",", 
   RowBox[{"\<\"e\"\>", "\[Rule]", "4833"}], ",", 
   RowBox[{"\<\"f\"\>", "\[Rule]", "766"}], ",", 
   RowBox[{"\<\"g\"\>", "\[Rule]", "818"}], ",", 
   RowBox[{"\<\"h\"\>", "\[Rule]", "1473"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "2818"}], ",", 
   RowBox[{"\<\"j\"\>", "\[Rule]", "25"}], ",", 
   RowBox[{"\<\"k\"\>", "\[Rule]", "174"}], ",", 
   RowBox[{"\<\"l\"\>", "\[Rule]", "1673"}], ",", 
   RowBox[{"\<\"m\"\>", "\[Rule]", "1494"}], ",", 
   RowBox[{"\<\"n\"\>", "\[Rule]", "2747"}], ",", 
   RowBox[{"\<\"o\"\>", "\[Rule]", "3059"}], ",", 
   RowBox[{"\<\"p\"\>", "\[Rule]", "1153"}], ",", 
   RowBox[{"\<\"q\"\>", "\[Rule]", "58"}], ",", 
   RowBox[{"\<\"r\"\>", "\[Rule]", "2907"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "2475"}], ",", 
   RowBox[{"\<\"t\"\>", "\[Rule]", "3528"}], ",", 
   RowBox[{"\<\"u\"\>", "\[Rule]", "1357"}], ",", 
   RowBox[{"\<\"v\"\>", "\[Rule]", "391"}], ",", 
   RowBox[{"\<\"w\"\>", "\[Rule]", "456"}], ",", 
   RowBox[{"\<\"x\"\>", "\[Rule]", "77"}], ",", 
   RowBox[{"\<\"y\"\>", "\[Rule]", "594"}], ",", 
   RowBox[{"\<\"z\"\>", "\[Rule]", "38"}]}], 
  "\[RightAssociation]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[13]=",ExpressionUUID->"c9d4f4ee-bbf4-4c8b-9182-7b471a163dc5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["BarChart",
  BaseStyle->"Link"],
 " plots the values in an association. With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChartLabels",
    BaseStyle->"CodeLink"], 
   ButtonBox["\[Rule]",
    BaseStyle->"Link",
    ButtonData->"Rule"], 
   ButtonBox["Automatic",
    BaseStyle->"CodeLink"]}]], "InlineCodeText",ExpressionUUID->
  "35b169e1-91f6-4559-881c-4d4bea70fe71"],
 ", it uses the keys as labels."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:207", "i:11"},ExpressionUUID->"5f624438-6b55-47ac-992f-ee85a68f0c65"],

Cell["\<\
Make a bar chart of how many times each letter appears; \
\[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote] is the most common:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ffe90cb0-4752-4b8e-a157-b519ccfa7c77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"KeyTake", "[", 
    RowBox[{
     RowBox[{"LetterCounts", "[", 
      RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], "]"}], ",", 
     RowBox[{"Alphabet", "[", "\[ThinSpace]", "]"}]}], "]"}], ",", 
   RowBox[{"ChartLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"f64c5e61-be0b-465f-b376-a718ebfbb41c"],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{0.01582867783985098, 0.}]}, {{}, 
    {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
     Thickness[Small]}], 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{0.5344506517690875, 0.}, {1.4655493482309123`, 
            3207.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{28.966760233505166`, 
           37.03724539240133}, {-27.026685415568345`, 60.62092745240282}}],
         StatusArea[#, 3207]& ,
         TagBoxNote->"3207"],
        StyleBox["3207", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[3207, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{1.5344506517690872`, 0.}, {2.4655493482309123`, 
            545.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{37.09746129415965, 45.16794645305582}, {
           45.31099636009091, 60.62092745240282}}],
         StatusArea[#, 545]& ,
         TagBoxNote->"545"],
        StyleBox["545", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[545, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{2.5344506517690872`, 0.}, {3.4655493482309123`, 
            1800.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{45.22816235481414, 53.29864751371031}, {
           11.207393569537807`, 60.62092745240282}}],
         StatusArea[#, 1800]& ,
         TagBoxNote->"1800"],
        StyleBox["1800", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1800, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{3.5344506517690872`, 0.}, {4.465549348230912, 1329.},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{53.35886341546862, 61.429348574364795`}, {
           24.006434935554147`, 60.62092745240282}}],
         StatusArea[#, 1329]& ,
         TagBoxNote->"1329"],
        StyleBox["1329", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1329, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{4.534450651769087, 0.}, {5.465549348230912, 4833.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{61.48956447612311, 
           69.56004963501928}, {-71.21191102308975, 60.62092745240281}}],
         StatusArea[#, 4833]& ,
         TagBoxNote->"4833"],
        StyleBox["4833", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[4833, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{5.534450651769087, 0.}, {6.465549348230912, 766.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{69.6202655367776, 77.69075069567376}, {
           39.305501366694706`, 60.62092745240282}}],
         StatusArea[#, 766]& ,
         TagBoxNote->"766"],
        StyleBox["766", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[766, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{6.534450651769087, 0.}, {7.465549348230912, 818.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{77.75096659743208, 85.82145175632824}, {
           37.89244372118972, 60.62092745240282}}],
         StatusArea[#, 818]& ,
         TagBoxNote->"818"],
        StyleBox["818", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[818, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{7.534450651769087, 0.}, {8.465549348230912, 1473.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{85.88166765808657, 93.95215281698273}, {
           20.09335222492495, 60.62092745240282}}],
         StatusArea[#, 1473]& ,
         TagBoxNote->"1473"],
        StyleBox["1473", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1473, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{8.534450651769086, 0.}, {9.465549348230912, 2818.}, 
            "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{94.01236871874104, 
           102.08285387763722`}, {-16.455927259771407`, 60.62092745240282}}],
         StatusArea[#, 2818]& ,
         TagBoxNote->"2818"],
        StyleBox["2818", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2818, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{9.534450651769086, 0.}, {10.465549348230912`, 25.}, 
            "RoundingRadius" -> 0]},
          ImageSizeCache->{{102.14306977939553`, 110.21355493829171`}, {
           59.4415728151408, 60.62092745240282}}],
         StatusArea[#, 25]& ,
         TagBoxNote->"25"],
        StyleBox["25", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[25, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{10.534450651769086`, 0.}, {11.465549348230912`, 
            174.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{110.27377084005002`, 118.3442559989462}, {
           55.3926191770592, 60.62092745240282}}],
         StatusArea[#, 174]& ,
         TagBoxNote->"174"],
        StyleBox["174", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[174, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{11.534450651769086`, 0.}, {12.465549348230912`, 
            1673.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{118.40447190070451`, 126.47495705960067`}, {
           14.658515126828839`, 60.62092745240282}}],
         StatusArea[#, 1673]& ,
         TagBoxNote->"1673"],
        StyleBox["1673", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1673, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{12.534450651769086`, 0.}, {13.465549348230912`, 
            1494.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{126.53517296135898`, 134.60565812025516`}, {
           19.522694329624855`, 60.62092745240282}}],
         StatusArea[#, 1494]& ,
         TagBoxNote->"1494"],
        StyleBox["1494", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1494, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{13.534450651769086`, 0.}, {14.465549348230912`, 
            2747.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{134.66587402201347`, 
           142.73635918090966`}, {-14.526560089947289`, 60.62092745240282}}],
         StatusArea[#, 2747]& ,
         TagBoxNote->"2747"],
        StyleBox["2747", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2747, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{14.534450651769086`, 0.}, {15.465549348230912`, 
            3059.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{142.79657508266797`, 
           150.86706024156413`}, {-23.004905962977226`, 60.62092745240282}}],
         StatusArea[#, 3059]& ,
         TagBoxNote->"3059"],
        StyleBox["3059", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[3059, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{15.534450651769086`, 0.}, {16.465549348230912`, 
            1153.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{150.92727614332244`, 158.9977613022186}, {
           28.78909158187873, 60.62092745240282}}],
         StatusArea[#, 1153]& ,
         TagBoxNote->"1153"],
        StyleBox["1153", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1153, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{16.534450651769088`, 0.}, {17.465549348230912`, 58.},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{159.05797720397695`, 167.1284623628731}, {
           58.54482469395494, 60.62092745240282}}],
         StatusArea[#, 58]& ,
         TagBoxNote->"58"],
        StyleBox["58", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[58, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{17.534450651769088`, 0.}, {18.465549348230912`, 
            2907.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{167.18867826463142`, 
           175.25916342352758`}, {-18.87442976842417, 60.62092745240282}}],
         StatusArea[#, 2907]& ,
         TagBoxNote->"2907"],
        StyleBox["2907", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2907, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{18.534450651769088`, 0.}, {19.465549348230912`, 
            2475.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{175.31937932528592`, 
           183.38986448418208`}, {-7.135181636536579, 60.62092745240282}}],
         StatusArea[#, 2475]& ,
         TagBoxNote->"2475"],
        StyleBox["2475", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[2475, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{19.534450651769088`, 0.}, {20.465549348230912`, 
            3528.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{183.4500803859404, 
           191.52056554483656`}, {-35.749598958012605`, 60.62092745240282}}],
         StatusArea[#, 3528]& ,
         TagBoxNote->"3528"],
        StyleBox["3528", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[3528, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{20.534450651769088`, 0.}, {21.465549348230912`, 
            1357.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{191.5807814465949, 199.65126660549106`}, {
           23.245557741820697`, 60.62092745240282}}],
         StatusArea[#, 1357]& ,
         TagBoxNote->"1357"],
        StyleBox["1357", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[1357, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{21.534450651769088`, 0.}, {22.465549348230912`, 
            391.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{199.71148250724937`, 207.78196766614553`}, {
           49.49582092562492, 60.62092745240282}}],
         StatusArea[#, 391]& ,
         TagBoxNote->"391"],
        StyleBox["391", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[391, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{22.534450651769088`, 0.}, {23.465549348230912`, 
            456.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{207.84218356790387`, 215.91266872680004`}, {
           47.72949886874368, 60.62092745240282}}],
         StatusArea[#, 456]& ,
         TagBoxNote->"456"],
        StyleBox["456", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[456, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{23.534450651769088`, 0.}, {24.465549348230912`, 77.},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{215.97288462855835`, 224.0433697874545}, {
           58.02851516963582, 60.62092745240282}}],
         StatusArea[#, 77]& ,
         TagBoxNote->"77"],
        StyleBox["77", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[77, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{24.534450651769088`, 0.}, {25.465549348230912`, 
            594.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{224.10358568921282`, 232.17407084810898`}, {
           43.97946127105736, 60.62092745240282}}],
         StatusArea[#, 594]& ,
         TagBoxNote->"594"],
        StyleBox["594", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[594, {}], "Tooltip"]& ]}, 
     {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518], 
      Thickness[Small]}], 
      TagBox[
       TooltipBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           
           RectangleBox[{25.534450651769088`, 0.}, {26.465549348230912`, 38.},
             "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{232.23428674986732`, 240.30477190876348`}, {
           59.08830840376456, 60.62092745240282}}],
         StatusArea[#, 38]& ,
         TagBoxNote->"38"],
        StyleBox["38", {}, StripOnInput -> False]],
       Annotation[#, 
        Style[38, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
   StyleBox[{
     {Thickness[Tiny], 
      LineBox[{{0.01582867783985098, 0.}, {26.994543761638734`, 0.}}], 
      StyleBox[{}, "GraphicsLabel",
       StripOnInput->False]}, 
     StyleBox[{
       {Thickness[Tiny], 
        LineBox[{{0.5344506517690875, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {0.5344506517690875, 0.}]}], 
        LineBox[{{26.465549348230912`, 0.}, 
          Offset[{-1.102182119232618*^-15, -6.}, {26.465549348230912`, 
           0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
          LineBox[{{1.4655493482309123`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {1.4655493482309123`, 
             0.}]}], 
          LineBox[{{1.5344506517690872`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {1.5344506517690872`, 
             0.}]}], LineBox[{{2.4655493482309128`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {2.4655493482309128`, 
             0.}]}], LineBox[{{2.5344506517690872`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {2.5344506517690872`, 
             0.}]}], LineBox[{{3.4655493482309128`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {3.4655493482309128`, 
             0.}]}], LineBox[{{3.5344506517690872`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {3.5344506517690872`, 
             0.}]}], LineBox[{{4.465549348230912, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {4.465549348230912, 0.}]}],
           LineBox[{{4.534450651769087, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {4.534450651769087, 0.}]}],
           LineBox[{{5.465549348230911, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {5.465549348230911, 0.}]}],
           LineBox[{{5.534450651769086, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {5.534450651769086, 0.}]}],
           LineBox[{{6.465549348230911, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {6.465549348230911, 0.}]}],
           LineBox[{{6.534450651769086, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {6.534450651769086, 0.}]}],
           LineBox[{{7.465549348230911, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {7.465549348230911, 0.}]}],
           LineBox[{{7.534450651769086, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {7.534450651769086, 0.}]}],
           LineBox[{{8.465549348230912, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {8.465549348230912, 0.}]}],
           LineBox[{{8.534450651769086, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {8.534450651769086, 0.}]}],
           LineBox[{{9.465549348230912, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {9.465549348230912, 0.}]}],
           LineBox[{{9.534450651769086, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {9.534450651769086, 0.}]}],
           LineBox[{{10.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {10.465549348230912`, 
             0.}]}], LineBox[{{10.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {10.534450651769086`, 
             0.}]}], LineBox[{{11.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {11.465549348230912`, 
             0.}]}], LineBox[{{11.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {11.534450651769086`, 
             0.}]}], LineBox[{{12.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {12.465549348230912`, 
             0.}]}], LineBox[{{12.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {12.534450651769086`, 
             0.}]}], LineBox[{{13.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {13.465549348230912`, 
             0.}]}], LineBox[{{13.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {13.534450651769086`, 
             0.}]}], LineBox[{{14.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {14.465549348230912`, 
             0.}]}], LineBox[{{14.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {14.534450651769086`, 
             0.}]}], LineBox[{{15.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {15.465549348230912`, 
             0.}]}], LineBox[{{15.534450651769086`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {15.534450651769086`, 
             0.}]}], LineBox[{{16.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {16.465549348230912`, 
             0.}]}], LineBox[{{16.534450651769085`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {16.534450651769085`, 
             0.}]}], LineBox[{{17.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {17.465549348230912`, 
             0.}]}], LineBox[{{17.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {17.534450651769088`, 
             0.}]}], LineBox[{{18.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {18.465549348230912`, 
             0.}]}], LineBox[{{18.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {18.534450651769088`, 
             0.}]}], LineBox[{{19.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {19.465549348230912`, 
             0.}]}], LineBox[{{19.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {19.534450651769088`, 
             0.}]}], LineBox[{{20.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {20.465549348230912`, 
             0.}]}], LineBox[{{20.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {20.534450651769088`, 
             0.}]}], LineBox[{{21.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {21.465549348230912`, 
             0.}]}], LineBox[{{21.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {21.534450651769088`, 
             0.}]}], LineBox[{{22.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {22.465549348230912`, 
             0.}]}], LineBox[{{22.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {22.534450651769088`, 
             0.}]}], LineBox[{{23.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {23.465549348230912`, 
             0.}]}], LineBox[{{23.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {23.534450651769088`, 
             0.}]}], LineBox[{{24.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {24.465549348230912`, 
             0.}]}], LineBox[{{24.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {24.534450651769088`, 
             0.}]}], LineBox[{{25.465549348230912`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {25.465549348230912`, 
             0.}]}], LineBox[{{25.534450651769088`, 0.}, 
            Offset[{-7.347880794884119*^-16, -4.}, {25.534450651769088`, 
             0.}]}]}, {}}}, 
       StyleBox[
        {Thickness[Tiny], 
         InsetBox["\<\"a\"\>", Offset[{0., -2.}, {0.9999999999999999, 0.}], {0, 1},
           Automatic, {1, 0}], 
         InsetBox["\<\"b\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"c\"\>", Offset[{0., -2.}, {3., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"d\"\>", Offset[{0., -2.}, {4., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"e\"\>", Offset[{0., -2.}, {4.999999999999999, 0.}], {0, 1},
           Automatic, {1, 0}], 
         InsetBox["\<\"f\"\>", Offset[{0., -2.}, {5.999999999999999, 0.}], {0, 1},
           Automatic, {1, 0}], 
         InsetBox["\<\"g\"\>", Offset[{0., -2.}, {6.999999999999999, 0.}], {0, 1},
           Automatic, {1, 0}], 
         InsetBox["\<\"h\"\>", Offset[{0., -2.}, {7.999999999999999, 0.}], {0, 1},
           Automatic, {1, 0}], 
         InsetBox["\<\"i\"\>", Offset[{0., -2.}, {9., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"j\"\>", Offset[{0., -2.}, {10., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"k\"\>", Offset[{0., -2.}, {11., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"l\"\>", Offset[{0., -2.}, {12., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"m\"\>", Offset[{0., -2.}, {13., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"n\"\>", Offset[{0., -2.}, {14., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"o\"\>", Offset[{0., -2.}, {15., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"p\"\>", Offset[{0., -2.}, {16., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"q\"\>", Offset[{0., -2.}, {17., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"r\"\>", Offset[{0., -2.}, {18., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"s\"\>", Offset[{0., -2.}, {19., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"t\"\>", Offset[{0., -2.}, {20., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"u\"\>", Offset[{0., -2.}, {21., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"v\"\>", Offset[{0., -2.}, {22., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"w\"\>", Offset[{0., -2.}, {23., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"x\"\>", Offset[{0., -2.}, {24., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"y\"\>", Offset[{0., -2.}, {25., 0.}], {0, 1}, 
          Automatic, {1, 0}], 
         InsetBox["\<\"z\"\>", Offset[{0., -2.}, {26., 0.}], {0, 1}, 
          Automatic, {1, 0}]}, "GraphicsLabel",
        StripOnInput->False]}, "GraphicsTicks",
      StripOnInput->False]}, "GraphicsAxes",
    StripOnInput->False,
    Antialiasing->False]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.01582867783985098, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Identity[
       Part[#, 1]], 
      Identity[
       Part[#, 2]]}& )},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {0.9999999999999999, 
       FormBox["\"a\"", TraditionalForm], 0}, {1.9999999999999998`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
       FormBox["\"b\"", TraditionalForm], 0}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox["\"c\"", TraditionalForm], 0}, {3.9999999999999996`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3.9999999999999996`, 
       FormBox["\"d\"", TraditionalForm], 0}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox["\"e\"", TraditionalForm], 0}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox["\"f\"", TraditionalForm], 0}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox["\"g\"", TraditionalForm], 0}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox["\"h\"", TraditionalForm], 0}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox["\"i\"", TraditionalForm], 0}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox["\"j\"", TraditionalForm], 0}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox["\"k\"", TraditionalForm], 0}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox["\"l\"", TraditionalForm], 0}, {13., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
       FormBox["\"m\"", TraditionalForm], 0}, {14., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
       FormBox["\"n\"", TraditionalForm], 0}, {15., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
       FormBox["\"o\"", TraditionalForm], 0}, {16., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
       FormBox["\"p\"", TraditionalForm], 0}, {17., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
       FormBox["\"q\"", TraditionalForm], 0}, {18., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
       FormBox["\"r\"", TraditionalForm], 0}, {19., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
       FormBox["\"s\"", TraditionalForm], 0}, {20., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
       FormBox["\"t\"", TraditionalForm], 0}, {21., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
       FormBox["\"u\"", TraditionalForm], 0}, {22., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
       FormBox["\"v\"", TraditionalForm], 0}, {23., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
       FormBox["\"w\"", TraditionalForm], 0}, {24., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
       FormBox["\"x\"", TraditionalForm], 0}, {25., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
       FormBox["\"y\"", TraditionalForm], 0}, {26., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
       FormBox["\"z\"", TraditionalForm], 0}}, {{0.9999999999999999, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {1.9999999999999998`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {3.9999999999999996`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[0]], TraditionalForm], {0.004, 0}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{249.92578125, Automatic},
  PlotRange->{{All, All}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{None, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"3f581bed-271a-46c7-94f5-27904932fe32"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s a direct way to apply a pure function to an \
association:\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3158f0ab-2ecb-4da4-9649-ece81fe16e47"],

Cell["Apply a pure function to an association:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd700958-418b-4506-a9e1-0a966b3d8375"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"#", "[", "\"\<apples\>\"", "]"}], ",", 
     RowBox[{"#", "[", "\"\<oranges\>\"", "]"}]}], "]"}], "&"}], "[", 
  RowBox[{"\[LeftAssociation]", 
   RowBox[{
    RowBox[{"\"\<apples\>\"", "\[Rule]", "10"}], ",", 
    RowBox[{"\"\<oranges\>\"", "\[Rule]", "12"}], ",", 
    RowBox[{"\"\<pears\>\"", "\[Rule]", "4"}]}], "\[RightAssociation]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"327cccf6-f83a-4b72-8fee-c49570ad2fb5"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"10", ",", "12"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"84061279-6410-44c7-a063-3a78f1f61123"]
}, Open  ]],

Cell[TextData[{
 "It\[CloseCurlyQuote]s very common to have keys that are strings, and the \
Wolfram Language has a special way to ",
 "handle these when it comes to pure functions",
 ": you can just use ",
 Cell[BoxData[
 "#key"], "InlineCodeText",ExpressionUUID->
  "6efea65f-384e-4dba-8a54-310db8b7144f"],
 " to refer to an element whose key is ",
 Cell[BoxData["\<\"key\"\>"], "InlineCodeText",ExpressionUUID->
  "14aa0a23-ba8a-4e78-9126-1cc97f89b879"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4af9a8c4-d5a2-4fbc-8566-5bcb0c330835"],

Cell["\<\
Use the simpler notation for association elements whose keys are strings:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0c5fcbe0-e506-4fb9-aaba-3de7a78e343e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#apples", ",", "#oranges"}], "]"}], "&"}], "[", 
   RowBox[{"\[LeftAssociation]", 
    RowBox[{
     RowBox[{"\"\<apples\>\"", "\[Rule]", "10"}], ",", 
     RowBox[{"\"\<oranges\>\"", "\[Rule]", "12"}], ",", 
     RowBox[{"\"\<pears\>\"", "\[Rule]", "4"}]}], "\[RightAssociation]"}], 
   "]"}], " "}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"9e5ff446-6601-4800-80bd-4632d75bbfc0"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"10", ",", "12"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"e03b9297-beec-440b-b833-11e3da3955cf"]
}, Open  ]],

Cell[TextData[{
 "As a more realistic example, apply a pure function that extracts the value \
for \[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote] from the letter counts, \
and divides by the total. The ",
 ButtonBox["N",
  BaseStyle->"Link"],
 " gives the result as a decimal. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8cc5bc8e-478f-405d-821e-b3c1e757645b"],

Cell["\<\
Compute the fraction of letters in the \[OpenCurlyDoubleQuote]computers\
\[CloseCurlyDoubleQuote] article that are \[OpenCurlyDoubleQuote]e\
\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"f5dc8673-c4f5-4221-b69a-6be49350d866"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"#e", "/", 
     RowBox[{"Total", "[", "#", "]"}]}], "&"}], " ", "@", 
   RowBox[{"LetterCounts", "[", 
    RowBox[{"WikipediaData", "[", "\"\<computers\>\"", "]"}], "]"}]}], "//", 
  "N"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"fb25b7b6-3aed-4ad1-bc79-3397f6111d17"],

Cell[BoxData["0.11794996949359365`"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[17]=",ExpressionUUID->"d09a580e-ffe8-429b-a71d-00bfbbaa404e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:208",ExpressionUUID->"3c25de26-148d-4090-9c8a-071bbfb94850"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["\[LeftAssociation]",
        BaseStyle->"CodeLink",
        ButtonData->"Association"], 
       SubscriptBox[
        StyleBox["key", "CodeVariableLrg"], "1"]}], "\[Rule]", 
      SubscriptBox[
       StyleBox["value", "CodeVariableLrg"], "1"]}], ",", 
     RowBox[{
      SubscriptBox[
       StyleBox["key", "CodeVariableLrg"], "2"], "\[Rule]", 
      SubscriptBox[
       StyleBox["value", "CodeVariableLrg"], "2"]}], ",", " ", 
     RowBox[{
      StyleBox["...", "GrayPointSix"], 
      ButtonBox["\[RightAssociation]",
       BaseStyle->"CodeLink",
       ButtonData->"Association"]}]}], " ", Cell[
    "an association", "VocabularyText",ExpressionUUID->
     "faa58ba5-8a9e-4fa6-80fd-557e1dcf29a4"]},
   {
    RowBox[{
     ButtonBox["Association",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["rules", "CodeVariableLrg"], "]"}], " ", Cell[
    "turn a list of rules into an association", "VocabularyText",
     ExpressionUUID->"ead98693-0e4a-42c8-a462-cca8f5970786"]},
   {
    RowBox[{
     StyleBox["assoc", "CodeVariableLrg"], "[", 
     StyleBox["key", "CodeVariableLrg"], "]"}], " ", Cell[
    "extract an element of an association", "VocabularyText",ExpressionUUID->
     "30eadfc4-77b5-438e-b1d3-864ea5e58286"]},
   {
    RowBox[{
     ButtonBox["Keys",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["assoc", "CodeVariableLrg"], "]"}], " ", Cell[
    "list of keys in an association", "VocabularyText",ExpressionUUID->
     "2d31d2e5-09d2-4947-9159-ca17a23ec396"]},
   {
    RowBox[{
     ButtonBox["Values",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["assoc", "CodeVariableLrg"], "]"}], " ", Cell[
    "list of values in an association", "VocabularyText",ExpressionUUID->
     "e50cde02-5bdb-42fa-a050-60f4dde08d8f"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["assoc", "CodeVariableLrg"], "]"}], " ", Cell[
    "turn an association into a list of rules", "VocabularyText",
     ExpressionUUID->"8f0ae6a4-9192-495f-966c-d76d084dc7aa"]},
   {
    RowBox[{
     ButtonBox["KeySort",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["assoc", "CodeVariableLrg"], "]"}], " ", Cell[
    "sort an association by its keys", "VocabularyText",ExpressionUUID->
     "4f578fa2-ddb9-448b-889d-083361149ab2"]},
   {
    RowBox[{
     ButtonBox["KeyTake",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["assoc", "CodeVariableLrg"], ",", 
      StyleBox["keys", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "take elements with particular keys", "VocabularyText",ExpressionUUID->
     "592f744d-b0c3-415b-85ed-22fa2b9adca6"]},
   {
    RowBox[{
     ButtonBox["#",
      BaseStyle->"Link",
      ButtonData->"Slot"], 
     StyleBox["key", "CodeVariableLrg"]}], " ", Cell[TextData[{
     "function slot for an element with key \[OpenCurlyDoubleQuote]",
     Cell[BoxData[
      StyleBox["key", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "2003b2aa-7052-4fd6-8fcd-16e9d4c893ef"],
     "\[CloseCurlyDoubleQuote]"
    }], "VocabularyText",ExpressionUUID->
     "b6d8f00b-e40a-4b17-8e76-b6a61654b4c3"]},
   {
    RowBox[{
     ButtonBox["Counts",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "an association with counts of distinct elements", "VocabularyText",
     ExpressionUUID->"bf6d8ada-0216-434b-8769-0a9c8ea810dd"]},
   {
    RowBox[{
     ButtonBox["LetterCounts",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["string", "CodeVariableLrg"], "]"}], " ", Cell[
    "an association with counts of distinct letters", "VocabularyText",
     ExpressionUUID->"7039721d-83e5-4249-ab04-067ab9467ae7"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, 
   "Rows" -> {False, {True, True, True, True, True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True}, 
     False}}},ExpressionUUID->"6063e6dd-1da3-48b2-b9c5-cfca5ad0a38f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"a0f21a59-ba47-4312-ae20-9d613fdfe5ef"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"6 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-34-associations-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a0281970-4972-44e6-812b-78af406f1b04"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list, in order, of the number of times each of the digits 0 through \
9 occurs in 3^100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"26c73c57-d08f-4f02-b63a-ba069b3419a1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "7", ",", "9", ",", "9", ",", "5", ",", "1", ",", "5", ",", "4", ",", 
         "7", ",", "1"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "9dd4f533-ffd9-4ca2-94e0-a5ef0332a06c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"7", ",", "9", ",", "9", ",", "5", ",", "1", ",", "5", ",",
              "4", ",", "7", ",", "1"}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3adc702a-3f21-4d6a-9c48-bb40c6eb50bb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a labeled bar chart of the number of times each of the digits 0 \
through 9 occurs in 2",
 ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"Power"],
 "1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b5f6c115-d91c-4e5d-8fd2-7ac7c64937d8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.3429357798165137, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63], 
           Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5412844036697247, 0.}, {1.4587155963302751`, 
                  28.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{17.986988913212343`, 
                 38.08453245258489}, {-47.262648160592434`, 
                 58.807647468726316`}}],
               StatusArea[#, 28]& ,
               TagBoxNote->"28"],
              StyleBox["28", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[28, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275, 
                  34.}, "RoundingRadius" -> 0]},
                ImageSizeCache->{{39.34831137112841, 
                 59.445854910500955`}, {-69.88485436687503, 
                 58.807647468726316`}}],
               StatusArea[#, 34]& ,
               TagBoxNote->"34"],
              StyleBox["34", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[34, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`, 
                  23.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{60.709633829044485`, 
                 80.80717736841704}, {-28.410809655356942`, 
                 58.807647468726316`}}],
               StatusArea[#, 23]& ,
               TagBoxNote->"23"],
              StyleBox["23", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[23, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276, 
                  25.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{82.07095628696058, 
                 102.16849982633312`}, {-35.95154505745114, 
                 58.807647468726316`}}],
               StatusArea[#, 25]& ,
               TagBoxNote->"25"],
              StyleBox["25", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[25, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                  35.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{103.43227874487664`, 
                 123.52982228424918`}, {-73.65522206792213, 
                 58.807647468726316`}}],
               StatusArea[#, 35]& ,
               TagBoxNote->"35"],
              StyleBox["35", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[35, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                  35.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{124.79360120279271`, 
                 144.89114474216524`}, {-73.65522206792213, 
                 58.807647468726316`}}],
               StatusArea[#, 35]& ,
               TagBoxNote->"35"],
              StyleBox["35", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[35, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                  34.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{146.15492366070876`, 
                 166.2524672000813}, {-69.88485436687503, 
                 58.807647468726316`}}],
               StatusArea[#, 34]& ,
               TagBoxNote->"34"],
              StyleBox["34", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[34, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                  35.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{167.51624611862485`, 
                 187.6137896579974}, {-73.65522206792213, 
                 58.807647468726316`}}],
               StatusArea[#, 35]& ,
               TagBoxNote->"35"],
              StyleBox["35", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[35, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                  30.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{188.8775685765409, 
                 208.97511211591345`}, {-54.80338356268663, 
                 58.807647468726316`}}],
               StatusArea[#, 30]& ,
               TagBoxNote->"30"],
              StyleBox["30", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[30, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.63],
             Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`, 
                  23.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{210.23889103445697`, 
                 230.33643457382954`}, {-28.410809655356942`, 
                 58.807647468726316`}}],
               StatusArea[#, 23]& ,
               TagBoxNote->"23"],
              StyleBox["23", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[23, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5412844036697247, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                 0.}]}], 
              LineBox[{{10.458715596330276`, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                LineBox[{{1.4587155963302751`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.4587155963302751`,
                    0.}]}], 
                LineBox[{{1.5412844036697249`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.5412844036697249`,
                    0.}]}], 
                LineBox[{{2.458715596330275, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.458715596330275, 
                   0.}]}], 
                LineBox[{{2.541284403669725, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.541284403669725, 
                   0.}]}], 
                LineBox[{{3.4587155963302756`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.4587155963302756`,
                    0.}]}], 
                LineBox[{{3.5412844036697253`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.5412844036697253`,
                    0.}]}], 
                LineBox[{{4.458715596330276, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.458715596330276, 
                   0.}]}], 
                LineBox[{{4.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.541284403669724, 
                   0.}]}], 
                LineBox[{{5.458715596330275, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.458715596330275, 
                   0.}]}], 
                LineBox[{{5.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.541284403669724, 
                   0.}]}], 
                LineBox[{{6.458715596330275, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.458715596330275, 
                   0.}]}], 
                LineBox[{{6.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.541284403669724, 
                   0.}]}], 
                LineBox[{{7.458715596330275, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.458715596330275, 
                   0.}]}], 
                LineBox[{{7.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.541284403669724, 
                   0.}]}], 
                LineBox[{{8.458715596330276, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.458715596330276, 
                   0.}]}], 
                LineBox[{{8.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.541284403669724, 
                   0.}]}], 
                LineBox[{{9.458715596330276, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.458715596330276, 
                   0.}]}], 
                LineBox[{{9.541284403669724, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.541284403669724, 
                   0.}]}]}, {}}}, 
             StyleBox[
              {Thickness[Tiny], 
               InsetBox["0", Offset[{0., -2.}, {1., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["1", Offset[{0., -2.}, {2., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["2", Offset[{0., -2.}, {3.0000000000000004, 0.}], {0, 1},
                 Automatic, {1, 0}], 
               InsetBox["3", Offset[{0., -2.}, {4., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["4", Offset[{0., -2.}, {5., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["5", Offset[{0., -2.}, {6., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["6", Offset[{0., -2.}, {7., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["7", Offset[{0., -2.}, {8., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["8", Offset[{0., -2.}, {9., 0.}], {0, 1}, Automatic, {
                1, 0}], 
               InsetBox["9", Offset[{0., -2.}, {10., 0.}], {0, 1}, 
                Automatic, {1, 0}]}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.3429357798165137, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
             FormBox["0", TraditionalForm], 0}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox["1", TraditionalForm], 0}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox["2", TraditionalForm], 0}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox["3", TraditionalForm], 0}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox["4", TraditionalForm], 0}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox["5", TraditionalForm], 0}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox["6", TraditionalForm], 0}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox["7", TraditionalForm], 0}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox["8", TraditionalForm], 0}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox["9", TraditionalForm], 0}}, {{1., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "52dddd2a-c40c-40a5-9b6c-e69254f82460"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.3429357798165137, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.63], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5412844036697247, 0.}, {
                    1.4587155963302751`, 28.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{18.968157851375842`, 
                   38.97860119724006}, {-47.41148083543424, 
                   58.18961347997644}}], StatusArea[#, 28]& , TagBoxNote -> 
                 "28"], 
                StyleBox["28", {}, StripOnInput -> False]], Annotation[#, 
                Style[28, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5412844036697246`, 0.}, {2.458715596330275,
                     34.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{40.23454109836784, 
                   60.24498444423206}, {-69.93314390302226, 
                   58.18961347997643}}], StatusArea[#, 34]& , TagBoxNote -> 
                 "34"], 
                StyleBox["34", {}, StripOnInput -> False]], Annotation[#, 
                Style[34, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.541284403669725, 0.}, {3.4587155963302756`,
                     23.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{61.50092434535984, 
                   81.51136769122405}, {-28.643428279110914`, 
                   58.18961347997644}}], StatusArea[#, 23]& , TagBoxNote -> 
                 "23"], 
                StyleBox["23", {}, StripOnInput -> False]], Annotation[#, 
                Style[23, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   RectangleBox[{3.5412844036697253`, 0.}, {4.458715596330276,
                     25.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{82.76730759235184, 
                   102.77775093821604`}, {-36.150649301640236`, 
                   58.18961347997644}}], StatusArea[#, 25]& , TagBoxNote -> 
                 "25"], 
                StyleBox["25", {}, StripOnInput -> False]], Annotation[#, 
                Style[25, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.541284403669725, 0.}, {5.458715596330276, 
                    35.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{104.03369083934383`, 
                   124.04413418520805`}, {-73.68675441428692, 
                   58.18961347997643}}], StatusArea[#, 35]& , TagBoxNote -> 
                 "35"], 
                StyleBox["35", {}, StripOnInput -> False]], Annotation[#, 
                Style[35, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.541284403669725, 0.}, {6.458715596330276, 
                    35.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{125.30007408633583`, 
                   145.31051743220004`}, {-73.68675441428692, 
                   58.18961347997643}}], StatusArea[#, 35]& , TagBoxNote -> 
                 "35"], 
                StyleBox["35", {}, StripOnInput -> False]], Annotation[#, 
                Style[35, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.541284403669725, 0.}, {7.458715596330276, 
                    34.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{146.56645733332783`, 
                   166.57690067919205`}, {-69.93314390302226, 
                   58.18961347997643}}], StatusArea[#, 34]& , TagBoxNote -> 
                 "34"], 
                StyleBox["34", {}, StripOnInput -> False]], Annotation[#, 
                Style[34, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.541284403669725, 0.}, {8.458715596330276, 
                    35.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{167.83284058031984`, 
                   187.84328392618406`}, {-73.68675441428692, 
                   58.18961347997643}}], StatusArea[#, 35]& , TagBoxNote -> 
                 "35"], 
                StyleBox["35", {}, StripOnInput -> False]], Annotation[#, 
                Style[35, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.541284403669724, 0.}, {9.458715596330276, 
                    30.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{189.09922382731182`, 
                   209.10966717317604`}, {-54.918701857963576`, 
                   58.18961347997644}}], StatusArea[#, 30]& , TagBoxNote -> 
                 "30"], 
                StyleBox["30", {}, StripOnInput -> False]], Annotation[#, 
                Style[30, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.63], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.541284403669724, 0.}, {10.458715596330276`,
                     23.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{210.36560707430382`, 
                   230.37605042016804`}, {-28.643428279110914`, 
                   58.18961347997644}}], StatusArea[#, 23]& , TagBoxNote -> 
                 "23"], 
                StyleBox["23", {}, StripOnInput -> False]], Annotation[#, 
                Style[23, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              LineBox[{{0.3429357798165137, 0.}, {10.66103119266055, 0.}}], 
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5412844036697247, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5412844036697247, 
                   0.}]}], 
                LineBox[{{10.458715596330276`, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {10.458715596330276`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                  LineBox[{{1.4587155963302751`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.4587155963302751`, 0.}]}], 
                  LineBox[{{1.5412844036697249`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.5412844036697249`, 0.}]}], 
                  LineBox[{{2.458715596330275, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {2.458715596330275,
                     0.}]}], 
                  LineBox[{{2.541284403669725, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {2.541284403669725,
                     0.}]}], 
                  LineBox[{{3.4587155963302756`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.4587155963302756`, 0.}]}], 
                  LineBox[{{3.5412844036697253`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.5412844036697253`, 0.}]}], 
                  LineBox[{{4.458715596330276, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.458715596330276,
                     0.}]}], 
                  LineBox[{{4.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.541284403669724,
                     0.}]}], 
                  LineBox[{{5.458715596330275, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.458715596330275,
                     0.}]}], 
                  LineBox[{{5.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.541284403669724,
                     0.}]}], 
                  LineBox[{{6.458715596330275, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.458715596330275,
                     0.}]}], 
                  LineBox[{{6.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.541284403669724,
                     0.}]}], 
                  LineBox[{{7.458715596330275, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.458715596330275,
                     0.}]}], 
                  LineBox[{{7.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.541284403669724,
                     0.}]}], 
                  LineBox[{{8.458715596330276, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.458715596330276,
                     0.}]}], 
                  LineBox[{{8.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.541284403669724,
                     0.}]}], 
                  LineBox[{{9.458715596330276, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.458715596330276,
                     0.}]}], 
                  LineBox[{{9.541284403669724, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.541284403669724,
                     0.}]}]}, {}}}, 
               StyleBox[{
                 Thickness[Tiny], 
                 InsetBox["0", 
                  Offset[{0., -2.}, {1., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["1", 
                  Offset[{0., -2.}, {2., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["2", 
                  Offset[{0., -2.}, {3.0000000000000004`, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["3", 
                  Offset[{0., -2.}, {4., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["4", 
                  Offset[{0., -2.}, {5., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["5", 
                  Offset[{0., -2.}, {6., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["6", 
                  Offset[{0., -2.}, {7., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["7", 
                  Offset[{0., -2.}, {8., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["8", 
                  Offset[{0., -2.}, {9., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["9", 
                  Offset[{0., -2.}, {10., 0.}], {0, 1}, Automatic, {1, 0}]}, 
                "GraphicsLabel", StripOnInput -> False]}, "GraphicsTicks", 
              StripOnInput -> False]}, "GraphicsAxes", StripOnInput -> False, 
            Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.3429357798165137, 0.}, 
          CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {1., 
               FormBox["0", TraditionalForm], 0}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox["1", TraditionalForm], 0}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox["2", TraditionalForm], 0}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox["3", TraditionalForm], 0}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox["4", TraditionalForm], 0}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox["5", TraditionalForm], 0}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox["6", TraditionalForm], 0}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox["7", TraditionalForm], 0}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox["8", TraditionalForm], 0}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox["9", TraditionalForm], 0}}, {{1., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {2., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {4., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], PlotRange -> {{All, All}, {All, All}}, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f33eda06-41eb-4996-b4ed-d07ef6b9de5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a labeled bar chart of the number of times each possible first letter \
occurs in words from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "b778696c-d59f-4aeb-bcb0-f0323326145d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"18f4d6ac-f01f-402e-a7ee-70f06051bc82"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {Opacity[0], PointBox[{0.01582867783985098, 0.}]}, {{}, 
          {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[0.518],
            Thickness[Small]}], 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{0.5344506517690875, 0.}, {1.4655493482309123`, 
                  2443.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{30.67178047689664, 
                 41.80334327204321}, {-10.463160269697056`, 
                 87.10237589969347}}],
               StatusArea[#, 2443]& ,
               TagBoxNote->"2443"],
              StyleBox["2443", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2443, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{1.5344506517690872`, 0.}, {2.4655493482309123`,
                   2223.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{42.09007891888406, 
                 53.22164171403063}, {-1.722096840607449, 87.10237589969347}}],
               StatusArea[#, 2223]& ,
               TagBoxNote->"2223"],
              StyleBox["2223", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2223, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{2.5344506517690872`, 0.}, {3.4655493482309123`,
                   3776.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{53.50837736087148, 
                 64.63994015601804}, {-63.426058228680915`, 
                 87.10237589969347}}],
               StatusArea[#, 3776]& ,
               TagBoxNote->"3776"],
              StyleBox["3776", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3776, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{3.5344506517690872`, 0.}, {4.465549348230912, 
                  2504.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{64.9266758028589, 
                 76.05823859800546}, {-12.886818765944625`, 
                 87.10237589969347}}],
               StatusArea[#, 2504]& ,
               TagBoxNote->"2504"],
              StyleBox["2504", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2504, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{4.534450651769087, 0.}, {5.465549348230912, 
                  1674.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{76.34497424484631, 87.47653703999288}, {
                 20.090829625620714`, 87.10237589969347}}],
               StatusArea[#, 1674]& ,
               TagBoxNote->"1674"],
              StyleBox["1674", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1674, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{5.534450651769087, 0.}, {6.465549348230912, 
                  1716.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{87.76327268683373, 98.8948354819803}, {
                 18.42208115279452, 87.10237589969347}}],
               StatusArea[#, 1716]& ,
               TagBoxNote->"1716"],
              StyleBox["1716", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1716, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{6.534450651769087, 0.}, {7.465549348230912, 
                  1223.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{99.18157112882116, 110.31313392396771`}, {
                 38.010009655254414`, 87.10237589969347}}],
               StatusArea[#, 1223]& ,
               TagBoxNote->"1223"],
              StyleBox["1223", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1223, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{7.534450651769087, 0.}, {8.465549348230912, 
                  1446.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{110.59986957080858`, 121.73143236595513`}, {
                 29.149749906677215`, 87.10237589969347}}],
               StatusArea[#, 1446]& ,
               TagBoxNote->"1446"],
              StyleBox["1446", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1446, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{8.534450651769086, 0.}, {9.465549348230912, 
                  1913.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{122.01816801279597`, 133.14973080794255`}, {
                 10.594856173109733`, 87.10237589969347}}],
               StatusArea[#, 1913]& ,
               TagBoxNote->"1913"],
              StyleBox["1913", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1913, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{9.534450651769086, 0.}, {10.465549348230912`, 
                  319.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{133.4364664547834, 144.56802924993}, {
                 73.92783392751353, 87.10237589969347}}],
               StatusArea[#, 319]& ,
               TagBoxNote->"319"],
              StyleBox["319", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[319, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{10.534450651769086`, 0.}, {11.465549348230912`,
                   233.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{144.85476489677083`, 155.98632769191738`}, {
                 77.34479508615766, 87.10237589969347}}],
               StatusArea[#, 233]& ,
               TagBoxNote->"233"],
              StyleBox["233", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[233, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{11.534450651769086`, 0.}, {12.465549348230912`,
                   1207.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{156.27306333875822`, 167.4046261339048}, {
                 38.6457233591882, 87.10237589969347}}],
               StatusArea[#, 1207]& ,
               TagBoxNote->"1207"],
              StyleBox["1207", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1207, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{12.534450651769086`, 0.}, {13.465549348230912`,
                   2049.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{167.69136178074564`, 178.82292457589222`}, {
                 5.191289689672516, 87.10237589969347}}],
               StatusArea[#, 2049]& ,
               TagBoxNote->"2049"],
              StyleBox["2049", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2049, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{13.534450651769086`, 0.}, {14.465549348230912`,
                   853.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{179.10966022273308`, 190.24122301787966`}, {
                 52.7108890587233, 87.10237589969347}}],
               StatusArea[#, 853]& ,
               TagBoxNote->"853"],
              StyleBox["853", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[853, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{14.534450651769086`, 0.}, {15.465549348230912`,
                   995.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{190.5279586647205, 201.65952145986708`}, {
                 47.068929936310916`, 87.10237589969347}}],
               StatusArea[#, 995]& ,
               TagBoxNote->"995"],
              StyleBox["995", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[995, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{15.534450651769086`, 0.}, {16.465549348230912`,
                   3267.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{201.94625710670792`, 
                 213.0778199018545}, {-43.202416022287224`, 
                 87.10237589969347}}],
               StatusArea[#, 3267]& ,
               TagBoxNote->"3267"],
              StyleBox["3267", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[3267, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{16.534450651769088`, 0.}, {17.465549348230912`,
                   197.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{213.36455554869534`, 224.4961183438419}, {
                 78.77515092000868, 87.10237589969347}}],
               StatusArea[#, 197]& ,
               TagBoxNote->"197"],
              StyleBox["197", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[197, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{17.534450651769088`, 0.}, {18.465549348230912`,
                   2092.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{224.78285399068275`, 235.91441678582933`}, {
                 3.482809110350459, 87.10237589969347}}],
               StatusArea[#, 2092]& ,
               TagBoxNote->"2092"],
              StyleBox["2092", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2092, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{18.534450651769088`, 0.}, {19.465549348230912`,
                   4642.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{236.2011524326702, 
                 247.33271522781675`}, {-97.83406245409728, 
                 87.10237589969347}}],
               StatusArea[#, 4642]& ,
               TagBoxNote->"4642"],
              StyleBox["4642", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[4642, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{19.534450651769088`, 0.}, {20.465549348230912`,
                   2038.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{247.61945087465762`, 258.7510136698042}, {
                 5.6283428611269954`, 87.10237589969347}}],
               StatusArea[#, 2038]& ,
               TagBoxNote->"2038"],
              StyleBox["2038", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[2038, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{20.534450651769088`, 0.}, {21.465549348230912`,
                   1556.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{259.03774931664503`, 270.1693121117916}, {
                 24.77921819213241, 87.10237589969347}}],
               StatusArea[#, 1556]& ,
               TagBoxNote->"1556"],
              StyleBox["1556", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1556, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{21.534450651769088`, 0.}, {22.465549348230912`,
                   646.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{270.45604775863245`, 281.58761055377903`}, {
                 60.93543510336671, 87.10237589969347}}],
               StatusArea[#, 646]& ,
               TagBoxNote->"646"],
              StyleBox["646", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[646, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{22.534450651769088`, 0.}, {23.465549348230912`,
                   1007.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{281.87434620061987`, 293.00590899576645`}, {
                 46.592144658360574`, 87.10237589969347}}],
               StatusArea[#, 1007]& ,
               TagBoxNote->"1007"],
              StyleBox["1007", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[1007, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{23.534450651769088`, 0.}, {24.465549348230912`,
                   11.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{293.2926446426073, 304.42420743775386`}, {
                 86.16532272823899, 87.10237589969347}}],
               StatusArea[#, 11]& ,
               TagBoxNote->"11"],
              StyleBox["11", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[11, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{24.534450651769088`, 0.}, {25.465549348230912`,
                   109.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{304.7109430845947, 315.8425058797413}, {
                 82.27157629164452, 87.10237589969347}}],
               StatusArea[#, 109]& ,
               TagBoxNote->"109"],
              StyleBox["109", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[109, {}], "Tooltip"]& ]}, 
           {RGBColor[0.982864, 0.7431472, 0.3262672], EdgeForm[{Opacity[
            0.518], Thickness[Small]}], 
            TagBox[
             TooltipBox[
              TagBox[
               DynamicBox[{
                 FEPrivate`If[
                  CurrentValue["MouseOver"], 
                  EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                 
                 RectangleBox[{25.534450651769088`, 0.}, {26.465549348230912`,
                   58.}, "RoundingRadius" -> 0]},
                
                ImageSizeCache->{{316.1292415265821, 327.2608043217287}, {
                 84.29791372293349, 87.10237589969347}}],
               StatusArea[#, 58]& ,
               TagBoxNote->"58"],
              StyleBox["58", {}, StripOnInput -> False]],
             Annotation[#, 
              Style[58, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
         StyleBox[{
           {Thickness[Tiny], 
            LineBox[{{0.01582867783985098, 0.}, {26.994543761638734`, 0.}}], 
            StyleBox[{}, "GraphicsLabel",
             StripOnInput->False]}, 
           StyleBox[{
             {Thickness[Tiny], 
              LineBox[{{0.5344506517690875, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {0.5344506517690875, 
                 0.}]}], 
              LineBox[{{26.465549348230912`, 0.}, 
                Offset[{-1.102182119232618*^-15, -6.}, {26.465549348230912`, 
                 0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                LineBox[{{1.4655493482309123`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.4655493482309123`,
                    0.}]}], 
                LineBox[{{1.5344506517690872`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {1.5344506517690872`,
                    0.}]}], 
                LineBox[{{2.4655493482309128`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.4655493482309128`,
                    0.}]}], 
                LineBox[{{2.5344506517690872`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {2.5344506517690872`,
                    0.}]}], 
                LineBox[{{3.4655493482309128`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.4655493482309128`,
                    0.}]}], 
                LineBox[{{3.5344506517690872`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {3.5344506517690872`,
                    0.}]}], 
                LineBox[{{4.465549348230912, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.465549348230912, 
                   0.}]}], 
                LineBox[{{4.534450651769087, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {4.534450651769087, 
                   0.}]}], 
                LineBox[{{5.465549348230911, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.465549348230911, 
                   0.}]}], 
                LineBox[{{5.534450651769086, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {5.534450651769086, 
                   0.}]}], 
                LineBox[{{6.465549348230911, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.465549348230911, 
                   0.}]}], 
                LineBox[{{6.534450651769086, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {6.534450651769086, 
                   0.}]}], 
                LineBox[{{7.465549348230911, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.465549348230911, 
                   0.}]}], 
                LineBox[{{7.534450651769086, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {7.534450651769086, 
                   0.}]}], 
                LineBox[{{8.465549348230912, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.465549348230912, 
                   0.}]}], 
                LineBox[{{8.534450651769086, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {8.534450651769086, 
                   0.}]}], 
                LineBox[{{9.465549348230912, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.465549348230912, 
                   0.}]}], 
                LineBox[{{9.534450651769086, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {9.534450651769086, 
                   0.}]}], 
                LineBox[{{10.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {10.465549348230912`,
                    0.}]}], 
                LineBox[{{10.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {10.534450651769086`,
                    0.}]}], 
                LineBox[{{11.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {11.465549348230912`,
                    0.}]}], 
                LineBox[{{11.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {11.534450651769086`,
                    0.}]}], 
                LineBox[{{12.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {12.465549348230912`,
                    0.}]}], 
                LineBox[{{12.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {12.534450651769086`,
                    0.}]}], 
                LineBox[{{13.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {13.465549348230912`,
                    0.}]}], 
                LineBox[{{13.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {13.534450651769086`,
                    0.}]}], 
                LineBox[{{14.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {14.465549348230912`,
                    0.}]}], 
                LineBox[{{14.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {14.534450651769086`,
                    0.}]}], 
                LineBox[{{15.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {15.465549348230912`,
                    0.}]}], 
                LineBox[{{15.534450651769086`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {15.534450651769086`,
                    0.}]}], 
                LineBox[{{16.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {16.465549348230912`,
                    0.}]}], 
                LineBox[{{16.534450651769085`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {16.534450651769085`,
                    0.}]}], 
                LineBox[{{17.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {17.465549348230912`,
                    0.}]}], 
                LineBox[{{17.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {17.534450651769088`,
                    0.}]}], 
                LineBox[{{18.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {18.465549348230912`,
                    0.}]}], 
                LineBox[{{18.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {18.534450651769088`,
                    0.}]}], 
                LineBox[{{19.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {19.465549348230912`,
                    0.}]}], 
                LineBox[{{19.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {19.534450651769088`,
                    0.}]}], 
                LineBox[{{20.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {20.465549348230912`,
                    0.}]}], 
                LineBox[{{20.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {20.534450651769088`,
                    0.}]}], 
                LineBox[{{21.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {21.465549348230912`,
                    0.}]}], 
                LineBox[{{21.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {21.534450651769088`,
                    0.}]}], 
                LineBox[{{22.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {22.465549348230912`,
                    0.}]}], 
                LineBox[{{22.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {22.534450651769088`,
                    0.}]}], 
                LineBox[{{23.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {23.465549348230912`,
                    0.}]}], 
                LineBox[{{23.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {23.534450651769088`,
                    0.}]}], 
                LineBox[{{24.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {24.465549348230912`,
                    0.}]}], 
                LineBox[{{24.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {24.534450651769088`,
                    0.}]}], 
                LineBox[{{25.465549348230912`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {25.465549348230912`,
                    0.}]}], 
                LineBox[{{25.534450651769088`, 0.}, 
                  Offset[{-7.347880794884119*^-16, -4.}, {25.534450651769088`,
                    0.}]}]}, {}}}, 
             StyleBox[
              {Thickness[Tiny], 
               InsetBox["\<\"a\"\>", 
                Offset[{0., -2.}, {0.9999999999999999, 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"b\"\>", Offset[{0., -2.}, {2., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"c\"\>", Offset[{0., -2.}, {3., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"d\"\>", Offset[{0., -2.}, {4., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"e\"\>", 
                Offset[{0., -2.}, {4.999999999999999, 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"f\"\>", 
                Offset[{0., -2.}, {5.999999999999999, 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"g\"\>", 
                Offset[{0., -2.}, {6.999999999999999, 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"h\"\>", 
                Offset[{0., -2.}, {7.999999999999999, 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"i\"\>", Offset[{0., -2.}, {9., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"j\"\>", Offset[{0., -2.}, {10., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"k\"\>", Offset[{0., -2.}, {11., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"l\"\>", Offset[{0., -2.}, {12., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"m\"\>", Offset[{0., -2.}, {13., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"n\"\>", Offset[{0., -2.}, {14., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"o\"\>", Offset[{0., -2.}, {15., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"p\"\>", Offset[{0., -2.}, {16., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"q\"\>", Offset[{0., -2.}, {17., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"r\"\>", Offset[{0., -2.}, {18., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"s\"\>", Offset[{0., -2.}, {19., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"t\"\>", Offset[{0., -2.}, {20., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"u\"\>", Offset[{0., -2.}, {21., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"v\"\>", Offset[{0., -2.}, {22., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"w\"\>", Offset[{0., -2.}, {23., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"x\"\>", Offset[{0., -2.}, {24., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"y\"\>", Offset[{0., -2.}, {25., 0.}], {0, 1}, 
                Automatic, {1, 0}], 
               InsetBox["\<\"z\"\>", Offset[{0., -2.}, {26., 0.}], {0, 1}, 
                Automatic, {1, 0}]}, "GraphicsLabel",
              StripOnInput->False]}, "GraphicsTicks",
            StripOnInput->False]}, "GraphicsAxes",
          StripOnInput->False,
          Antialiasing->False]},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, True},
        AxesLabel->{None, None},
        AxesOrigin->{0.01582867783985098, 0.},
        CoordinatesToolOptions:>{"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {0.9999999999999999, 
             FormBox["\"a\"", TraditionalForm], 0}, {1.9999999999999998`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            1.9999999999999998`, 
             FormBox["\"b\"", TraditionalForm], 0}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox["\"c\"", TraditionalForm], 0}, {3.9999999999999996`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            3.9999999999999996`, 
             FormBox["\"d\"", TraditionalForm], 0}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox["\"e\"", TraditionalForm], 0}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox["\"f\"", TraditionalForm], 0}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox["\"g\"", TraditionalForm], 0}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox["\"h\"", TraditionalForm], 0}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox["\"i\"", TraditionalForm], 0}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox["\"j\"", TraditionalForm], 0}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox["\"k\"", TraditionalForm], 0}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox["\"l\"", TraditionalForm], 0}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox["\"m\"", TraditionalForm], 0}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox["\"n\"", TraditionalForm], 0}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox["\"o\"", TraditionalForm], 0}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox["\"p\"", TraditionalForm], 0}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox["\"q\"", TraditionalForm], 0}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox["\"r\"", TraditionalForm], 0}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox["\"s\"", TraditionalForm], 0}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox["\"t\"", TraditionalForm], 0}, {21., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
             FormBox["\"u\"", TraditionalForm], 0}, {22., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
             FormBox["\"v\"", TraditionalForm], 0}, {23., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
             FormBox["\"w\"", TraditionalForm], 0}, {24., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
             FormBox["\"x\"", TraditionalForm], 0}, {25., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
             FormBox["\"y\"", TraditionalForm], 0}, {26., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
             FormBox["\"z\"", TraditionalForm], 0}}, {{0.9999999999999999, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            1.9999999999999998`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {
            3.9999999999999996`, 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
             FormBox[
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                 Baseline], "CacheGraphics" -> False], 
               Spacer[0]], TraditionalForm], {0.004, 0}}}}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{340.46875, Automatic},
        PlotRange->{{All, All}, {All, All}},
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{None, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "5205323f-784d-42f0-ad98-a10afcaa2eb3"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{
            Opacity[0], 
            PointBox[{0.01582867783985098, 0.}]}, {{}, {
             RGBColor[0.982864, 0.7431472, 0.3262672], 
             EdgeForm[{
               Opacity[0.518], 
               Thickness[Small]}], {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5344506517690875, 0.}, {
                    1.4655493482309123`, 2443.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{32.63411835322364, 
                   43.6980651274133}, {-11.08189799629345, 
                   85.86630792219366}}], StatusArea[#, 2443]& , TagBoxNote -> 
                 "2443"], 
                StyleBox["2443", {}, StripOnInput -> False]], Annotation[#, 
                Style[2443, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5344506517690872`, 0.}, {
                    2.4655493482309123`, 2223.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{43.97979718870334, 
                   55.043743962893004`}, {-2.396427139941764, 
                   85.86630792219366}}], StatusArea[#, 2223]& , TagBoxNote -> 
                 "2223"], 
                StyleBox["2223", {}, StripOnInput -> False]], Annotation[#, 
                Style[2223, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.5344506517690872`, 0.}, {
                    3.4655493482309123`, 3776.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{55.32547602418303, 
                   66.38942279837269}, {-63.70795550318796, 
                   85.86630792219366}}], StatusArea[#, 3776]& , TagBoxNote -> 
                 "3776"], 
                StyleBox["3776", {}, StripOnInput -> False]], Annotation[#, 
                Style[3776, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5344506517690872`, 0.}, {4.465549348230912,
                     2504.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{66.67115485966272, 
                   77.7351016338524}, {-13.490142188281865`, 
                   85.86630792219366}}], StatusArea[#, 2504]& , TagBoxNote -> 
                 "2504"], 
                StyleBox["2504", {}, StripOnInput -> False]], Annotation[#, 
                Style[2504, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.534450651769087, 0.}, {5.465549348230912, 
                    1674.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{78.01683369514242, 89.08078046933208}, {
                   19.277770587954024`, 85.86630792219366}}], 
                 StatusArea[#, 1674]& , TagBoxNote -> "1674"], 
                StyleBox["1674", {}, StripOnInput -> False]], Annotation[#, 
                Style[1674, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.534450651769087, 0.}, {6.465549348230912, 
                    1716.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{89.36251253062213, 
                   100.42645930481179`}, {17.61963524265053, 
                   85.86630792219366}}], StatusArea[#, 1716]& , TagBoxNote -> 
                 "1716"], 
                StyleBox["1716", {}, StripOnInput -> False]], Annotation[#, 
                Style[1716, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.534450651769087, 0.}, {7.465549348230912, 
                    1223.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{100.70819136610183`, 
                   111.77213814029147`}, {37.08298584347498, 
                   85.86630792219366}}], StatusArea[#, 1223]& , TagBoxNote -> 
                 "1223"], 
                StyleBox["1223", {}, StripOnInput -> False]], Annotation[#, 
                Style[1223, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.534450651769087, 0.}, {8.465549348230912, 
                    1446.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{112.05387020158152`, 
                   123.11781697577118`}, {28.279076748173047`, 
                   85.86630792219366}}], StatusArea[#, 1446]& , TagBoxNote -> 
                 "1446"], 
                StyleBox["1446", {}, StripOnInput -> False]], Annotation[#, 
                Style[1446, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.534450651769086, 0.}, {9.465549348230912, 
                    1913.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{123.3995490370612, 
                   134.46349581125088`}, {9.842190884917429, 
                   85.86630792219366}}], StatusArea[#, 1913]& , TagBoxNote -> 
                 "1913"], 
                StyleBox["1913", {}, StripOnInput -> False]], Annotation[#, 
                Style[1913, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{9.534450651769086, 0.}, {10.465549348230912`,
                     319.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{134.7452278725409, 
                   145.80917464673058`}, {72.77237518048372, 
                   85.86630792219366}}], StatusArea[#, 319]& , TagBoxNote -> 
                 "319"], 
                StyleBox["319", {}, StripOnInput -> False]], Annotation[#, 
                Style[319, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{10.534450651769086`, 0.}, {
                    11.465549348230912`, 233.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{146.0909067080206, 
                   157.15485348221026`}, {76.16760469705756, 
                   85.86630792219366}}], StatusArea[#, 233]& , TagBoxNote -> 
                 "233"], 
                StyleBox["233", {}, StripOnInput -> False]], Annotation[#, 
                Style[233, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{11.534450651769086`, 0.}, {
                    12.465549348230912`, 1207.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{157.43658554350029`, 
                   168.50053231768996`}, {37.71465645120965, 
                   85.86630792219366}}], StatusArea[#, 1207]& , TagBoxNote -> 
                 "1207"], 
                StyleBox["1207", {}, StripOnInput -> False]], Annotation[#, 
                Style[1207, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{12.534450651769086`, 0.}, {
                    13.465549348230912`, 2049.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{168.78226437898, 179.84621115316966`}, {
                   4.472990719172756, 85.86630792219366}}], 
                 StatusArea[#, 2049]& , TagBoxNote -> "2049"], 
                StyleBox["2049", {}, StripOnInput -> False]], Annotation[#, 
                Style[2049, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{13.534450651769086`, 0.}, {
                    14.465549348230912`, 853.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{180.1279432144597, 
                   191.19188998864936`}, {51.69036864733918, 
                   85.86630792219366}}], StatusArea[#, 853]& , TagBoxNote -> 
                 "853"], 
                StyleBox["853", {}, StripOnInput -> False]], Annotation[#, 
                Style[853, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{14.534450651769086`, 0.}, {
                    15.465549348230912`, 995.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{191.4736220499394, 
                   202.53756882412907`}, {46.084292003693996`, 
                   85.86630792219366}}], StatusArea[#, 995]& , TagBoxNote -> 
                 "995"], 
                StyleBox["995", {}, StripOnInput -> False]], Annotation[#, 
                Style[995, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{15.534450651769086`, 0.}, {
                    16.465549348230912`, 3267.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{202.8193008854191, 
                   213.88324765960877`}, {-43.61293429462883, 
                   85.86630792219366}}], StatusArea[#, 3267]& , TagBoxNote -> 
                 "3267"], 
                StyleBox["3267", {}, StripOnInput -> False]], Annotation[#, 
                Style[3267, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{16.534450651769088`, 0.}, {
                    17.465549348230912`, 197.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{214.1649797208988, 
                   225.22892649508844`}, {77.58886356446055, 
                   85.86630792219366}}], StatusArea[#, 197]& , TagBoxNote -> 
                 "197"], 
                StyleBox["197", {}, StripOnInput -> False]], Annotation[#, 
                Style[197, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{17.534450651769088`, 0.}, {
                    18.465549348230912`, 2092.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{225.5106585563785, 
                   236.57460533056815`}, {2.7753759608858246`, 
                   85.86630792219366}}], StatusArea[#, 2092]& , TagBoxNote -> 
                 "2092"], 
                StyleBox["2092", {}, StripOnInput -> False]], Annotation[#, 
                Style[2092, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{18.534450651769088`, 0.}, {
                    19.465549348230912`, 4642.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{236.8563373918582, 
                   247.92028416604785`}, {-97.89712714682686, 
                   85.86630792219366}}], StatusArea[#, 4642]& , TagBoxNote -> 
                 "4642"], 
                StyleBox["4642", {}, StripOnInput -> False]], Annotation[#, 
                Style[4642, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{19.534450651769088`, 0.}, {
                    20.465549348230912`, 2038.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{248.2020162273379, 
                   259.26596300152755`}, {4.907264261990335, 
                   85.86630792219366}}], StatusArea[#, 2038]& , TagBoxNote -> 
                 "2038"], 
                StyleBox["2038", {}, StripOnInput -> False]], Annotation[#, 
                Style[2038, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{20.534450651769088`, 0.}, {
                    21.465549348230912`, 1556.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{259.54769506281764`, 
                   270.61164183700726`}, {23.936341319997204`, 
                   85.86630792219366}}], StatusArea[#, 1556]& , TagBoxNote -> 
                 "1556"], 
                StyleBox["1556", {}, StripOnInput -> False]], Annotation[#, 
                Style[1556, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{21.534450651769088`, 0.}, {
                    22.465549348230912`, 646.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{270.8933738982973, 
                   281.95732067248696`}, {59.86260713490644, 
                   85.86630792219366}}], StatusArea[#, 646]& , TagBoxNote -> 
                 "646"], 
                StyleBox["646", {}, StripOnInput -> False]], Annotation[#, 
                Style[646, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{22.534450651769088`, 0.}, {
                    23.465549348230912`, 1007.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{282.239052733777, 
                   293.30299950796666`}, {45.610539047893, 
                   85.86630792219366}}], StatusArea[#, 1007]& , TagBoxNote -> 
                 "1007"], 
                StyleBox["1007", {}, StripOnInput -> False]], Annotation[#, 
                Style[1007, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{23.534450651769088`, 0.}, {
                    24.465549348230912`, 11.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{293.58473156925663`, 
                   304.64867834344636`}, {84.93203437937608, 
                   85.86630792219366}}], StatusArea[#, 11]& , TagBoxNote -> 
                 "11"], 
                StyleBox["11", {}, StripOnInput -> False]], Annotation[#, 
                Style[11, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{24.534450651769088`, 0.}, {
                    25.465549348230912`, 109.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{304.93041040473634`, 
                   315.99435717892607`}, {81.06305190700122, 
                   85.86630792219366}}], StatusArea[#, 109]& , TagBoxNote -> 
                 "109"], 
                StyleBox["109", {}, StripOnInput -> False]], Annotation[#, 
                Style[109, {}], "Tooltip"]& ]}, {
              RGBColor[0.982864, 0.7431472, 0.3262672], 
              EdgeForm[{
                Opacity[0.518], 
                Thickness[Small]}], 
              TagBox[
               TooltipBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{25.534450651769088`, 0.}, {
                    26.465549348230912`, 58.}, "RoundingRadius" -> 0]}, 
                  ImageSizeCache -> {{316.27608924021604`, 
                   327.34003601440577`}, {83.07650196915549, 
                   85.86630792219366}}], StatusArea[#, 58]& , TagBoxNote -> 
                 "58"], 
                StyleBox["58", {}, StripOnInput -> False]], Annotation[#, 
                Style[58, {}], "Tooltip"]& ]}}, {}, {}}, {}, {}, 
           StyleBox[{{
              Thickness[Tiny], 
              LineBox[{{0.01582867783985098, 0.}, {26.994543761638734`, 0.}}], 
              StyleBox[{}, "GraphicsLabel", StripOnInput -> False]}, 
             StyleBox[{{
                Thickness[Tiny], 
                LineBox[{{0.5344506517690875, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {0.5344506517690875, 
                   0.}]}], 
                LineBox[{{26.465549348230912`, 0.}, 
                  
                  Offset[{-1.102182119232618*^-15, -6.}, {26.465549348230912`,
                    0.}]}], {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {
                  LineBox[{{1.4655493482309123`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.4655493482309123`, 0.}]}], 
                  LineBox[{{1.5344506517690872`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    1.5344506517690872`, 0.}]}], 
                  LineBox[{{2.4655493482309128`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    2.4655493482309128`, 0.}]}], 
                  LineBox[{{2.5344506517690872`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    2.5344506517690872`, 0.}]}], 
                  LineBox[{{3.4655493482309128`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.4655493482309128`, 0.}]}], 
                  LineBox[{{3.5344506517690872`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    3.5344506517690872`, 0.}]}], 
                  LineBox[{{4.465549348230912, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.465549348230912,
                     0.}]}], 
                  LineBox[{{4.534450651769087, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {4.534450651769087,
                     0.}]}], 
                  LineBox[{{5.465549348230911, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.465549348230911,
                     0.}]}], 
                  LineBox[{{5.534450651769086, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {5.534450651769086,
                     0.}]}], 
                  LineBox[{{6.465549348230911, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.465549348230911,
                     0.}]}], 
                  LineBox[{{6.534450651769086, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {6.534450651769086,
                     0.}]}], 
                  LineBox[{{7.465549348230911, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.465549348230911,
                     0.}]}], 
                  LineBox[{{7.534450651769086, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {7.534450651769086,
                     0.}]}], 
                  LineBox[{{8.465549348230912, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.465549348230912,
                     0.}]}], 
                  LineBox[{{8.534450651769086, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {8.534450651769086,
                     0.}]}], 
                  LineBox[{{9.465549348230912, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.465549348230912,
                     0.}]}], 
                  LineBox[{{9.534450651769086, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {9.534450651769086,
                     0.}]}], 
                  LineBox[{{10.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    10.465549348230912`, 0.}]}], 
                  LineBox[{{10.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    10.534450651769086`, 0.}]}], 
                  LineBox[{{11.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    11.465549348230912`, 0.}]}], 
                  LineBox[{{11.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    11.534450651769086`, 0.}]}], 
                  LineBox[{{12.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    12.465549348230912`, 0.}]}], 
                  LineBox[{{12.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    12.534450651769086`, 0.}]}], 
                  LineBox[{{13.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    13.465549348230912`, 0.}]}], 
                  LineBox[{{13.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    13.534450651769086`, 0.}]}], 
                  LineBox[{{14.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    14.465549348230912`, 0.}]}], 
                  LineBox[{{14.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    14.534450651769086`, 0.}]}], 
                  LineBox[{{15.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    15.465549348230912`, 0.}]}], 
                  LineBox[{{15.534450651769086`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    15.534450651769086`, 0.}]}], 
                  LineBox[{{16.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    16.465549348230912`, 0.}]}], 
                  LineBox[{{16.534450651769085`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    16.534450651769085`, 0.}]}], 
                  LineBox[{{17.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    17.465549348230912`, 0.}]}], 
                  LineBox[{{17.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    17.534450651769088`, 0.}]}], 
                  LineBox[{{18.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    18.465549348230912`, 0.}]}], 
                  LineBox[{{18.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    18.534450651769088`, 0.}]}], 
                  LineBox[{{19.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    19.465549348230912`, 0.}]}], 
                  LineBox[{{19.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    19.534450651769088`, 0.}]}], 
                  LineBox[{{20.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    20.465549348230912`, 0.}]}], 
                  LineBox[{{20.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    20.534450651769088`, 0.}]}], 
                  LineBox[{{21.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    21.465549348230912`, 0.}]}], 
                  LineBox[{{21.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    21.534450651769088`, 0.}]}], 
                  LineBox[{{22.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    22.465549348230912`, 0.}]}], 
                  LineBox[{{22.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    22.534450651769088`, 0.}]}], 
                  LineBox[{{23.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    23.465549348230912`, 0.}]}], 
                  LineBox[{{23.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    23.534450651769088`, 0.}]}], 
                  LineBox[{{24.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    24.465549348230912`, 0.}]}], 
                  LineBox[{{24.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    24.534450651769088`, 0.}]}], 
                  LineBox[{{25.465549348230912`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    25.465549348230912`, 0.}]}], 
                  LineBox[{{25.534450651769088`, 0.}, 
                    
                    Offset[{-7.347880794884119*^-16, -4.}, {
                    25.534450651769088`, 0.}]}]}, {}}}, 
               StyleBox[{
                 Thickness[Tiny], 
                 InsetBox["\"a\"", 
                  Offset[{0., -2.}, {0.9999999999999999, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["\"b\"", 
                  Offset[{0., -2.}, {2., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"c\"", 
                  Offset[{0., -2.}, {3., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"d\"", 
                  Offset[{0., -2.}, {4., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"e\"", 
                  Offset[{0., -2.}, {4.999999999999999, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["\"f\"", 
                  Offset[{0., -2.}, {5.999999999999999, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["\"g\"", 
                  Offset[{0., -2.}, {6.999999999999999, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["\"h\"", 
                  Offset[{0., -2.}, {7.999999999999999, 0.}], {0, 1}, 
                  Automatic, {1, 0}], 
                 InsetBox["\"i\"", 
                  Offset[{0., -2.}, {9., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"j\"", 
                  Offset[{0., -2.}, {10., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"k\"", 
                  Offset[{0., -2.}, {11., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"l\"", 
                  Offset[{0., -2.}, {12., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"m\"", 
                  Offset[{0., -2.}, {13., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"n\"", 
                  Offset[{0., -2.}, {14., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"o\"", 
                  Offset[{0., -2.}, {15., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"p\"", 
                  Offset[{0., -2.}, {16., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"q\"", 
                  Offset[{0., -2.}, {17., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"r\"", 
                  Offset[{0., -2.}, {18., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"s\"", 
                  Offset[{0., -2.}, {19., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"t\"", 
                  Offset[{0., -2.}, {20., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"u\"", 
                  Offset[{0., -2.}, {21., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"v\"", 
                  Offset[{0., -2.}, {22., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"w\"", 
                  Offset[{0., -2.}, {23., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"x\"", 
                  Offset[{0., -2.}, {24., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"y\"", 
                  Offset[{0., -2.}, {25., 0.}], {0, 1}, Automatic, {1, 0}], 
                 InsetBox["\"z\"", 
                  Offset[{0., -2.}, {26., 0.}], {0, 1}, Automatic, {1, 0}]}, 
                "GraphicsLabel", StripOnInput -> False]}, "GraphicsTicks", 
              StripOnInput -> False]}, "GraphicsAxes", StripOnInput -> False, 
            Antialiasing -> False]}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, True},
           AxesLabel -> {None, None}, AxesOrigin -> {0.01582867783985098, 0.},
           CoordinatesToolOptions :> {"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )}, FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {{{0.9999999999999999, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              0.9999999999999999, 
               FormBox["\"a\"", TraditionalForm], 0}, {1.9999999999999998`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              1.9999999999999998`, 
               FormBox["\"b\"", TraditionalForm], 0}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox["\"c\"", TraditionalForm], 0}, {3.9999999999999996`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              3.9999999999999996`, 
               FormBox["\"d\"", TraditionalForm], 0}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox["\"e\"", TraditionalForm], 0}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox["\"f\"", TraditionalForm], 0}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox["\"g\"", TraditionalForm], 0}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox["\"h\"", TraditionalForm], 0}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox["\"i\"", TraditionalForm], 0}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox["\"j\"", TraditionalForm], 0}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox["\"k\"", TraditionalForm], 0}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox["\"l\"", TraditionalForm], 0}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox["\"m\"", TraditionalForm], 0}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox["\"n\"", TraditionalForm], 0}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox["\"o\"", TraditionalForm], 0}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox["\"p\"", TraditionalForm], 0}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox["\"q\"", TraditionalForm], 0}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox["\"r\"", TraditionalForm], 0}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox["\"s\"", TraditionalForm], 0}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox["\"t\"", TraditionalForm], 0}, {21., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
               FormBox["\"u\"", TraditionalForm], 0}, {22., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
               FormBox["\"v\"", TraditionalForm], 0}, {23., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
               FormBox["\"w\"", TraditionalForm], 0}, {24., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
               FormBox["\"x\"", TraditionalForm], 0}, {25., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
               FormBox["\"y\"", TraditionalForm], 0}, {26., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
               FormBox["\"z\"", TraditionalForm], 0}}, {{0.9999999999999999, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              1.9999999999999998`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {3., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {
              3.9999999999999996`, 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {5., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {6., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {7., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {8., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {9., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {10., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {11., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {12., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {13., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {14., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {15., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {16., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {17., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {18., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {19., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {20., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {21., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {22., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {23., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {24., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {25., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}, {26., 
               FormBox[
                InterpretationBox[
                 StyleBox[
                  
                  GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                   Baseline], "CacheGraphics" -> False], 
                 Spacer[0]], TraditionalForm], {0.004, 0}}}}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {340.46875, Automatic}, 
          PlotRange -> {{All, All}, {All, All}}, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {None, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bc8ff7b6-51c2-4550-b0e1-2dc372cd8f06"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make an association giving the 5 most common first letters of words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordList",
    BaseStyle->"CodeLink"], "[", " ", "]"}]], "InlineCode",ExpressionUUID->
  "a3cb638d-831d-4158-881d-f3f381438be9"],
 " and their counts.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9159e224-d44c-4d95-acc0-5758f18c04ab"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"\[LeftAssociation]", 
        RowBox[{
         RowBox[{"\<\"s\"\>", "\[Rule]", "4642"}], ",", 
         RowBox[{"\<\"c\"\>", "\[Rule]", "3776"}], ",", 
         RowBox[{"\<\"p\"\>", "\[Rule]", "3267"}], ",", 
         RowBox[{"\<\"d\"\>", "\[Rule]", "2504"}], ",", 
         RowBox[{"\<\"a\"\>", "\[Rule]", "2443"}]}], "\[RightAssociation]"}]],
        "ExerciseOutput",ExpressionUUID->
       "462933c6-4019-4c7a-9cbd-e77c5a4c6025"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"\[LeftAssociation]", 
           RowBox[{
             RowBox[{"\"s\"", "\[Rule]", "4642"}], ",", 
             RowBox[{"\"c\"", "\[Rule]", "3776"}], ",", 
             RowBox[{"\"p\"", "\[Rule]", "3267"}], ",", 
             RowBox[{"\"d\"", "\[Rule]", "2504"}], ",", 
             RowBox[{"\"a\"", "\[Rule]", "2443"}]}], "\[RightAssociation]"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"69b53966-2fe3-4f6d-8384-91d77a3c5c97"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the numerical ratio of the number of occurrences of \
\[OpenCurlyDoubleQuote]q\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]u\
\[CloseCurlyDoubleQuote] in the Wikipedia entry for computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"9f54aaaf-4c61-4e28-91d3-073514b303d1"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "0.042678440029433405`"], "ExerciseOutput",ExpressionUUID->
       "7828e892-1d0e-4b2a-b7ff-40233baabad7"],
      Apply[TextCell, 
       Cell[
        BoxData["0.042678440029433405`"], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2fc4956a-a091-4f4c-9ec4-f382937fbc25"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the 10 most common words in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExampleData",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{"\<\"Text\"\>", ",", "\<\"AliceInWonderland\"\>"}], "}"}], "]"}]],
   "InlineCode",ExpressionUUID->"1c58ee24-4253-4213-a303-cdd847bf4b5d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "34.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"352b312b-bf6e-410f-996f-3204df05d47b"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"the\"\>", ",", "\<\"and\"\>", ",", "\<\"a\"\>", 
         ",", "\<\"to\"\>", ",", "\<\"she\"\>", ",", "\<\"of\"\>", 
         ",", "\<\"was\"\>", ",", "\<\"Alice\"\>", ",", "\<\"in\"\>", 
         ",", "\<\"it\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "adc25129-8f38-413a-a561-b29b55179e30"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"the\"", ",", "\"and\"", ",", "\"a\"", ",", "\"to\"", 
             ",", "\"she\"", ",", "\"of\"", ",", "\"was\"", ",", "\"Alice\"", 
             ",", "\"in\"", ",", "\"it\""}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f6bc33c1-d6ae-406f-b268-c7fbe15c11c2"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3604a72c-78b7-44ec-8eaf-74dfbf480dbe"],

Cell["Why are associations called \[OpenCurlyDoubleQuote]associations\
\[CloseCurlyDoubleQuote]?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"c5334af2-0050-494f-bb56-fb2513c4dbe7"],

Cell[TextData[{
 "Because they ",
 StyleBox["associate",
  FontSlant->"Italic"],
 " values with keys. Other names used for the same concept are associative \
arrays, dictionaries, hashmaps, structs, key-value maps and symbolically \
indexed lists."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"369b1f99-7cde-4f71-a4e2-4045d4acd7c8"],

Cell["How does one type in an association?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"86940aa4-9112-47e6-926b-432dae50601e"],

Cell[TextData[{
 "Start with ",
 Cell[BoxData[
  ButtonBox["<|",
   BaseStyle->"Link",
   ButtonData->"Association"]], "InlineCode",ExpressionUUID->
  "a08b02d5-96fe-42ac-b948-89f62b8115bb"],
 " (",
 Cell[BoxData[
 "<"], "InlineCode",ExpressionUUID->"8a48c8ac-54cd-4937-ba17-746ad6b9baea"],
 " followed by ",
 Cell[BoxData[
 "|"], "InlineCode",ExpressionUUID->"59921954-60f8-4cd1-8b51-384e87474ff1"],
 "), then use ",
 Cell[BoxData["->"], "InlineCode",ExpressionUUID->
  "46edbce4-b8d6-4c2a-8006-3676d2077dc5"],
 " for each ",
 Cell[BoxData[
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"Rule"]], "InlineCode",ExpressionUUID->
  "e13376b7-2e39-4437-9ecc-5d7ef142fb74"],
 ".  Alternatively use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Association",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{"a", "->", "1"}], ",", 
    RowBox[{"b", "->", "2"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "b792e387-622b-45e1-8817-6a9365e57f89"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2255b594-975c-40a7-8f89-1f1188c6de05"],

Cell["Can an association have several elements with the same key?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"70e65018-a2a7-4e81-a626-1a29331712d1"],

Cell["No. Keys in an association are always unique. ", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3019ebc6-365b-46da-b98f-526d4a2067d2"],

Cell["\<\
What happens if I ask for a key that\[CloseCurlyQuote]s not in an association?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"f956b3ed-ab2a-4679-bf2f-d2fd01c42eb1"],

Cell[TextData[{
 "Normally you get ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "]"}]], "InlineCode",ExpressionUUID->
  "3a65ed40-2c9d-4056-809e-a0bc0471ee06"],
 ". But if you use ",
 ButtonBox["Lookup",
  BaseStyle->"Link"],
 " to look up the key, you can specify what to return if the key is absent."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"76865aa5-fd06-460f-9c48-fc036465cc68"],

Cell["How can I do operations on the keys of an association?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:209", "i:15"},ExpressionUUID->"9b0d0f75-a0b0-480d-abe4-850ab46c30a8"],

Cell[TextData[{
 "Use ",
 ButtonBox["KeyMap",
  BaseStyle->"Link"],
 ", or use functions like ",
 ButtonBox["KeySelect",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["KeyDrop",
  BaseStyle->"Link"],
 ". ",
 ButtonBox["AssociationMap",
  BaseStyle->"Link"],
 " creates an association by mapping a function over keys. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d27b115f-c41d-4af4-bbed-3554c8c73d65"],

Cell["How can I combine several associations into one?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"6cdfac3c-2559-44ec-8f41-038a72a86b99"],

Cell[TextData[{
 "Use ",
 ButtonBox["Merge",
  BaseStyle->"Link"],
 ". You have to give a function to say what to do if the same key occurs in \
multiple associations."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9009569f-d051-4bd7-8715-9ea2b16e0938"],

Cell[TextData[{
 "Can one use ",
 ButtonBox["[[",
  BaseStyle->"Link",
  ButtonData->"Part"],
 Cell[BoxData[
  ButtonBox[
   StyleBox["...",
    FontColor->GrayLevel[0.6]],
   BaseStyle->"Link",
   ButtonData->"Part"]], "InlineCode",ExpressionUUID->
  "b2adb78d-9de5-4324-a327-f9487adc0f4e"],
 ButtonBox["]]",
  BaseStyle->"Link",
  ButtonData->"Part"],
 " to extract part of an association, like one extracts part of a list?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"d53c6930-9558-4c26-b5ea-0d815a05c987"],

Cell[TextData[{
 "Yes, if you explicitly say ",
 Cell[BoxData[
  RowBox[{
   StyleBox["assoc", "CodeVariable"], "[", 
   RowBox[{"[", 
    RowBox[{
     ButtonBox["Key",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["key", "CodeVariable"], "]"}], "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"8bc21b7f-2dfc-4654-a454-923058b4922d"],
 ". For example,  ",
 Cell[BoxData[
  RowBox[{
   StyleBox["assoc", "CodeVariable"], "[", 
   RowBox[{"[", "2", "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "ab24c582-47e2-4926-b71c-225552965017"],
 " will extract the second element of ",
 Cell[BoxData[
  StyleBox["assoc", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "79ea1aad-d226-4bca-b0a2-45e4b7f5f4cb"],
 ", whatever key it has. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["assoc", "CodeVariable"], "[", 
   RowBox[{"[", 
    StyleBox["key", "CodeVariable"], "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"d9627acf-242c-4ea1-baa2-a625288eb6d5"],
 " is a special case that works the same as ",
 Cell[BoxData[
  RowBox[{"assoc", "[", 
   StyleBox["key", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "9cc0aa79-2d50-4e14-a2e6-5c958559a87d"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e174a1f-9887-40f1-aef3-640f583e68c1"],

Cell["\<\
What happens in pure functions if the keys in an association aren\
\[CloseCurlyQuote]t strings?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1d9d95ba-65aa-47b7-ad39-bc5879bcdbe0"],

Cell[TextData[{
 "You can\[CloseCurlyQuote]t use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], 
   StyleBox["key", "CodeVariable"]}]], "InlineCode",ExpressionUUID->
  "2fe94d8b-9771-4dd5-9167-13fca338fe56"],
 " anymore; you have to explicitly use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], "[", 
   StyleBox["key", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "12424730-e758-4666-bdc6-aed51d0fa4ef"],
 ". "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b9649809-f593-4827-86f4-9126481ac5b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"41f029d3-e130-40bd-b738-d5213878f592"],

Cell["\<\
Most functions effectively operate on associations as if they were operating \
on lists of their values. Functions that thread themselves over lists \
typically do the same over associations.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"fdd37ebb-de25-4189-a52d-36115e0329da"],

Cell[TextData[{
 "Associations are like tables in a relational database. ",
 ButtonBox["JoinAcross",
  BaseStyle->"Link"],
 " does the analog of a database join."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"f4d1f8e5-03a9-4589-89fe-1d250cdf1c0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"35453e14-91b2-4e22-9774-942e341eaff5"],

Cell[TextData[ButtonBox["Guide to Associations in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Associations"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"a420db84-42ce-4a59-ba40-ad586d0535d9"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Associations: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-33-expressions-and-their-structure.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-33-expressions-and-their-structure.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Expressions and Their Structure\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Expressions and Their Structure", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-35-natural-language-understanding.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-35-natural-language-understanding.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Natural Language Understanding\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Natural Language Understanding", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->288,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Associations \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"65cbc541-76ac-4761-9730-6cc4727569fc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:205"->{
  Cell[655, 23, 439, 11, 93, "SectionDoubleDigit",ExpressionUUID->"ebd2af30-4c40-40cb-b8c0-f11695d882a8",
   CounterAssignments->{{"Section", 33}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:205"]},
 "i:1"->{
  Cell[1097, 36, 415, 12, 65, "Text",ExpressionUUID->"5126f3ff-24a8-4637-8379-e77a22558cd9",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[2503, 85, 451, 17, 40, "Text",ExpressionUUID->"4264a836-51c6-4430-9184-7ce921d41383",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[6204, 215, 246, 8, 37, "CodeCaption",ExpressionUUID->"b6774023-9ed7-4754-90b7-439e5bbb3017",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[7008, 245, 238, 8, 37, "CodeCaption",ExpressionUUID->"3e19b49c-3b1d-404f-8144-8871846e71d0",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[7982, 280, 239, 8, 70, "CodeCaption",ExpressionUUID->"99c8058b-c183-4994-b0ae-3ba341803303",
   CellTags->"i:5"]},
 "LastCellOfAPage"->{
  Cell[8593, 303, 382, 10, 70, "Output",ExpressionUUID->"bc547cc6-1553-4631-a397-c220bbc86815",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[17630, 579, 1577, 34, 70, "Output",ExpressionUUID->"c9d4f4ee-bbf4-4c8b-9182-7b471a163dc5",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[70736, 1937, 222, 5, 70, "Output",ExpressionUUID->"d09a580e-ffe8-429b-a71d-00bfbbaa404e",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[252808, 6240, 559, 18, 70, "Answer",ExpressionUUID->"76865aa5-fd06-460f-9c48-fc036465cc68",
   CellTags->"LastCellOfAPage"],
  Cell[258406, 6439, 339, 8, 70, "MoreExplore",ExpressionUUID->"a420db84-42ce-4a59-ba40-ad586d0535d9",
   CellTags->"LastCellOfAPage"]},
 "p:206"->{
  Cell[8990, 316, 341, 13, 70, "Text",ExpressionUUID->"45b34fed-c371-4202-a328-53cfe84b3af2",
   CellTags->{"p:206", "i:6"}]},
 "i:6"->{
  Cell[8990, 316, 341, 13, 70, "Text",ExpressionUUID->"45b34fed-c371-4202-a328-53cfe84b3af2",
   CellTags->{"p:206", "i:6"}]},
 "i:7"->{
  Cell[10926, 387, 366, 13, 70, "Text",ExpressionUUID->"2ee1d113-3e02-4268-92c8-a4bd9f1d20b9",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[12702, 451, 275, 10, 70, "Text",ExpressionUUID->"a21a2918-cc31-4a8f-b79c-89fc8ff3635c",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[12980, 463, 244, 6, 70, "CodeCaption",ExpressionUUID->"75f1239b-1f26-4cbc-87ff-b9ad5dee4347",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[16636, 547, 395, 10, 70, "Text",ExpressionUUID->"f61458c2-3de5-4b3d-bf1d-5513f6ea3f40",
   CellTags->"i:10"]},
 "p:207"->{
  Cell[19222, 616, 603, 20, 70, "Text",ExpressionUUID->"5f624438-6b55-47ac-992f-ee85a68f0c65",
   CellTags->{"p:207", "i:11"}]},
 "i:11"->{
  Cell[19222, 616, 603, 20, 70, "Text",ExpressionUUID->"5f624438-6b55-47ac-992f-ee85a68f0c65",
   CellTags->{"p:207", "i:11"}]},
 "i:12"->{
  Cell[70018, 1913, 333, 8, 70, "CodeCaption",ExpressionUUID->"f5dc8673-c4f5-4221-b69a-6be49350d866",
   CellTags->"i:12"]},
 "p:208"->{
  Cell[71007, 1948, 176, 4, 70, "VocabularySection",ExpressionUUID->"3c25de26-148d-4090-9c8a-071bbfb94850",
   CellTags->"p:208"]},
 "i:13"->{
  Cell[250260, 6156, 246, 5, 70, "Question",ExpressionUUID->"c5334af2-0050-494f-bb56-fb2513c4dbe7",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[252563, 6232, 242, 6, 70, "Question",ExpressionUUID->"f956b3ed-ab2a-4679-bf2f-d2fd01c42eb1",
   CellTags->"i:14"]},
 "p:209"->{
  Cell[253370, 6260, 224, 5, 70, "Question",ExpressionUUID->"9b0d0f75-a0b0-480d-abe4-850ab46c30a8",
   CellTags->{"p:209", "i:15"}]},
 "i:15"->{
  Cell[253370, 6260, 224, 5, 70, "Question",ExpressionUUID->"9b0d0f75-a0b0-480d-abe4-850ab46c30a8",
   CellTags->{"p:209", "i:15"}]},
 "i:16"->{
  Cell[254049, 6287, 204, 4, 70, "Question",ExpressionUUID->"6cdfac3c-2559-44ec-8f41-038a72a86b99",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[254561, 6305, 578, 20, 70, "Question",ExpressionUUID->"d53c6930-9558-4c26-b5ea-0d815a05c987",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[257529, 6409, 355, 8, 70, "TechNote",ExpressionUUID->"fdd37ebb-de25-4189-a52d-36115e0329da",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[257887, 6419, 314, 9, 70, "TechNote",ExpressionUUID->"f4d1f8e5-03a9-4589-89fe-1d250cdf1c0f",
   CellTags->"i:19"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:205", 349564, 8286},
 {"i:1", 349804, 8290},
 {"i:2", 349929, 8293},
 {"i:3", 350054, 8296},
 {"i:4", 350186, 8299},
 {"i:5", 350318, 8302},
 {"LastCellOfAPage", 350462, 8305},
 {"p:206", 351202, 8319},
 {"i:6", 351339, 8322},
 {"i:7", 351476, 8325},
 {"i:8", 351603, 8328},
 {"i:9", 351730, 8331},
 {"i:10", 351864, 8334},
 {"p:207", 351994, 8337},
 {"i:11", 352134, 8340},
 {"i:12", 352274, 8343},
 {"p:208", 352411, 8346},
 {"i:13", 352554, 8349},
 {"i:14", 352688, 8352},
 {"p:209", 352823, 8355},
 {"i:15", 352968, 8358},
 {"i:16", 353113, 8361},
 {"i:17", 353247, 8364},
 {"i:18", 353382, 8367},
 {"i:19", 353516, 8370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[655, 23, 439, 11, 93, "SectionDoubleDigit",ExpressionUUID->"ebd2af30-4c40-40cb-b8c0-f11695d882a8",
 CounterAssignments->{{"Section", 33}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:205"],
Cell[1097, 36, 415, 12, 65, "Text",ExpressionUUID->"5126f3ff-24a8-4637-8379-e77a22558cd9",
 CellTags->"i:1"],
Cell[1515, 50, 291, 10, 37, "CodeCaption",ExpressionUUID->"cb922183-6283-457b-8479-21866c52a084"],
Cell[CellGroupData[{
Cell[1831, 64, 302, 7, 29, "Input",ExpressionUUID->"ef082667-9b3d-4e03-8391-92196d450fb4"],
Cell[2136, 73, 352, 9, 40, "Output",ExpressionUUID->"d4269e8b-abd5-4634-bc37-02543d30d201",
 Evaluatable->False]
}, Open  ]],
Cell[2503, 85, 451, 17, 40, "Text",ExpressionUUID->"4264a836-51c6-4430-9184-7ce921d41383",
 CellTags->"i:2"],
Cell[2957, 104, 306, 9, 37, "CodeCaption",ExpressionUUID->"e89d3152-c0f4-4811-9802-5a62a21c902c"],
Cell[CellGroupData[{
Cell[3288, 117, 339, 9, 29, "Input",ExpressionUUID->"c558e78a-ac19-4aa3-904d-eeadd56db00a"],
Cell[3630, 128, 172, 4, 40, "Output",ExpressionUUID->"7e945870-dd8b-48a1-9405-16f3e0e21a22",
 Evaluatable->False]
}, Open  ]],
Cell[3817, 135, 277, 7, 65, "Text",ExpressionUUID->"4dd2530f-5cfb-4b4f-9019-b7c8d8c8a600"],
Cell[4097, 144, 190, 4, 37, "CodeCaption",ExpressionUUID->"3f13a923-5a38-4585-b02d-06ec2b265f46"],
Cell[CellGroupData[{
Cell[4312, 152, 336, 9, 29, "Input",ExpressionUUID->"ba01eaef-dc3b-41db-b7da-df87a218d8e2"],
Cell[4651, 163, 358, 9, 40, "Output",ExpressionUUID->"461f16e0-93f3-4bf6-81e3-29c9c0d5526c",
 Evaluatable->False]
}, Open  ]],
Cell[5024, 175, 363, 11, 39, "CodeCaption",ExpressionUUID->"f265de92-409a-4fee-8c6c-c95d665f8aef"],
Cell[CellGroupData[{
Cell[5412, 190, 332, 8, 29, "Input",ExpressionUUID->"02e5c815-788f-41ce-bf38-9168e0cdfef7"],
Cell[5747, 200, 442, 12, 40, "Output",ExpressionUUID->"ec9246fd-822c-4eb4-a371-d195c181e196",
 Evaluatable->False]
}, Open  ]],
Cell[6204, 215, 246, 8, 37, "CodeCaption",ExpressionUUID->"b6774023-9ed7-4754-90b7-439e5bbb3017",
 CellTags->"i:3"],
Cell[CellGroupData[{
Cell[6475, 227, 342, 9, 29, "Input",ExpressionUUID->"bcc8d05b-3fa8-4541-9eca-4b18a355e0e2"],
Cell[6820, 238, 173, 4, 40, "Output",ExpressionUUID->"36914fe6-f2fb-4e93-8393-5ab1ca15a1c7",
 Evaluatable->False]
}, Open  ]],
Cell[7008, 245, 238, 8, 37, "CodeCaption",ExpressionUUID->"3e19b49c-3b1d-404f-8144-8871846e71d0",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[7271, 257, 341, 9, 70, "Input",ExpressionUUID->"48b995be-88b1-4c31-a3a9-44f6e70322a6"],
Cell[7615, 268, 352, 9, 70, "Output",ExpressionUUID->"326b17b4-9fdd-4428-a74b-25507bad98b8",
 Evaluatable->False]
}, Open  ]],
Cell[7982, 280, 239, 8, 70, "CodeCaption",ExpressionUUID->"99c8058b-c183-4994-b0ae-3ba341803303",
 CellTags->"i:5"],
Cell[CellGroupData[{
Cell[8246, 292, 344, 9, 70, "Input",ExpressionUUID->"d30726ff-4b2f-40b8-a60a-2302c56ce3e8"],
Cell[8593, 303, 382, 10, 70, "Output",ExpressionUUID->"bc547cc6-1553-4631-a397-c220bbc86815",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[8990, 316, 341, 13, 70, "Text",ExpressionUUID->"45b34fed-c371-4202-a328-53cfe84b3af2",
 CellTags->{"p:206", "i:6"}],
Cell[9334, 331, 183, 4, 70, "CodeCaption",ExpressionUUID->"79ec10e7-038d-4918-8214-85c35730eda6"],
Cell[CellGroupData[{
Cell[9542, 339, 341, 9, 70, "Input",ExpressionUUID->"263d88bb-0053-441d-8afd-c657fe85c225"],
Cell[9886, 350, 227, 6, 70, "Output",ExpressionUUID->"6ab535d3-eb38-4d8d-9592-e94095901ede",
 Evaluatable->False]
}, Open  ]],
Cell[10128, 359, 185, 4, 70, "CodeCaption",ExpressionUUID->"5bf15244-702d-4010-9124-73757592edc8"],
Cell[CellGroupData[{
Cell[10338, 367, 343, 9, 70, "Input",ExpressionUUID->"20978510-0568-41e0-85c6-f20af3a890b9"],
Cell[10684, 378, 227, 6, 70, "Output",ExpressionUUID->"e4f67de0-2e0c-4959-a4e9-da04f297422c",
 Evaluatable->False]
}, Open  ]],
Cell[10926, 387, 366, 13, 70, "Text",ExpressionUUID->"2ee1d113-3e02-4268-92c8-a4bd9f1d20b9",
 CellTags->"i:7"],
Cell[CellGroupData[{
Cell[11317, 404, 344, 9, 70, "Input",ExpressionUUID->"bf7198ec-d0a1-445a-8179-1894f64b6bc8"],
Cell[11664, 415, 318, 9, 70, "Output",ExpressionUUID->"2f496ae8-f1a7-47a0-b7a3-e9a14cc4f3ea",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[12019, 429, 312, 8, 70, "Input",ExpressionUUID->"3c879028-8079-487d-82ef-97ace1d5ba4b"],
Cell[12334, 439, 353, 9, 70, "Output",ExpressionUUID->"4acebfbf-a124-4b1d-ab18-6e3c5c27ee1c",
 Evaluatable->False]
}, Open  ]],
Cell[12702, 451, 275, 10, 70, "Text",ExpressionUUID->"a21a2918-cc31-4a8f-b79c-89fc8ff3635c",
 CellTags->"i:8"],
Cell[12980, 463, 244, 6, 70, "CodeCaption",ExpressionUUID->"75f1239b-1f26-4cbc-87ff-b9ad5dee4347",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[13249, 473, 219, 4, 70, "Input",ExpressionUUID->"fa25ddff-9cc0-42ae-ad33-1c27aa8b0393"],
Cell[13471, 479, 3150, 65, 70, "Output",ExpressionUUID->"13d4d4cb-b8ab-4c19-9695-5a23af775b59",
 Evaluatable->False]
}, Open  ]],
Cell[16636, 547, 395, 10, 70, "Text",ExpressionUUID->"f61458c2-3de5-4b3d-bf1d-5513f6ea3f40",
 CellTags->"i:10"],
Cell[17034, 559, 242, 7, 70, "CodeCaption",ExpressionUUID->"3b8edd03-215e-48e7-97f8-5dcff2cf1e8e"],
Cell[CellGroupData[{
Cell[17301, 570, 326, 7, 70, "Input",ExpressionUUID->"a6f183f7-4a0b-4314-90d7-9923a12d13fd"],
Cell[17630, 579, 1577, 34, 70, "Output",ExpressionUUID->"c9d4f4ee-bbf4-4c8b-9182-7b471a163dc5",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[19222, 616, 603, 20, 70, "Text",ExpressionUUID->"5f624438-6b55-47ac-992f-ee85a68f0c65",
 CellTags->{"p:207", "i:11"}],
Cell[19828, 638, 277, 7, 70, "CodeCaption",ExpressionUUID->"ffe90cb0-4752-4b8e-a157-b519ccfa7c77"],
Cell[CellGroupData[{
Cell[20130, 649, 441, 10, 70, "Input",ExpressionUUID->"f64c5e61-be0b-465f-b376-a718ebfbb41c"],
Cell[20574, 661, 46210, 1142, 70, "Output",ExpressionUUID->"3f581bed-271a-46c7-94f5-27904932fe32",
 Evaluatable->False]
}, Open  ]],
Cell[66799, 1806, 226, 7, 70, "Text",ExpressionUUID->"3158f0ab-2ecb-4da4-9649-ece81fe16e47"],
Cell[67028, 1815, 183, 4, 70, "CodeCaption",ExpressionUUID->"dd700958-418b-4506-a9e1-0a966b3d8375"],
Cell[CellGroupData[{
Cell[67236, 1823, 542, 14, 70, "Input",ExpressionUUID->"327cccf6-f83a-4b72-8fee-c49570ad2fb5"],
Cell[67781, 1839, 225, 6, 70, "Output",ExpressionUUID->"84061279-6410-44c7-a063-3a78f1f61123",
 Evaluatable->False]
}, Open  ]],
Cell[68021, 1848, 594, 16, 70, "Text",ExpressionUUID->"4af9a8c4-d5a2-4fbc-8566-5bcb0c330835"],
Cell[68618, 1866, 224, 6, 70, "CodeCaption",ExpressionUUID->"0c5fcbe0-e506-4fb9-aaba-3de7a78e343e"],
Cell[CellGroupData[{
Cell[68867, 1876, 493, 13, 70, "Input",ExpressionUUID->"9e5ff446-6601-4800-80bd-4632d75bbfc0"],
Cell[69363, 1891, 225, 6, 70, "Output",ExpressionUUID->"e03b9297-beec-440b-b833-11e3da3955cf",
 Evaluatable->False]
}, Open  ]],
Cell[69603, 1900, 412, 11, 70, "Text",ExpressionUUID->"8cc5bc8e-478f-405d-821e-b3c1e757645b"],
Cell[70018, 1913, 333, 8, 70, "CodeCaption",ExpressionUUID->"f5dc8673-c4f5-4221-b69a-6be49350d866",
 CellTags->"i:12"],
Cell[CellGroupData[{
Cell[70376, 1925, 357, 10, 70, "Input",ExpressionUUID->"fb25b7b6-3aed-4ad1-bc79-3397f6111d17"],
Cell[70736, 1937, 222, 5, 70, "Output",ExpressionUUID->"d09a580e-ffe8-429b-a71d-00bfbbaa404e",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71007, 1948, 176, 4, 70, "VocabularySection",ExpressionUUID->"3c25de26-148d-4090-9c8a-071bbfb94850",
 CellTags->"p:208"],
Cell[71186, 1954, 4103, 111, 70, "VocabularyTable",ExpressionUUID->"6063e6dd-1da3-48b2-b9c5-cfca5ad0a38f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75326, 2070, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"a0f21a59-ba47-4312-ae20-9d613fdfe5ef"],
Cell[CellGroupData[{
Cell[77131, 2120, 1243, 38, 70, "ExerciseSummaryCell",ExpressionUUID->"a0281970-4972-44e6-812b-78af406f1b04"],
Cell[CellGroupData[{
Cell[78399, 2162, 760, 21, 70, "Exercise",ExpressionUUID->"26c73c57-d08f-4f02-b63a-ba069b3419a1"],
Cell[79162, 2185, 1371, 39, 70, "ExerciseOutput",ExpressionUUID->"3adc702a-3f21-4d6a-9c48-bb40c6eb50bb"]
}, Closed]],
Cell[CellGroupData[{
Cell[80570, 2229, 828, 25, 70, "Exercise",ExpressionUUID->"b5f6c115-d91c-4e5d-8fd2-7ac7c64937d8"],
Cell[81401, 2256, 45981, 1058, 70, "ExerciseOutput",ExpressionUUID->"f33eda06-41eb-4996-b4ed-d07ef6b9de5c"]
}, Closed]],
Cell[CellGroupData[{
Cell[127419, 3319, 939, 27, 70, "Exercise",ExpressionUUID->"18f4d6ac-f01f-402e-a7ee-70f06051bc82"],
Cell[128361, 3348, 114325, 2579, 70, "ExerciseOutput",ExpressionUUID->"bc8ff7b6-51c2-4550-b0e1-2dc372cd8f06"]
}, Closed]],
Cell[CellGroupData[{
Cell[242723, 5932, 929, 26, 70, "Exercise",ExpressionUUID->"9159e224-d44c-4d95-acc0-5758f18c04ab"],
Cell[243655, 5960, 1794, 46, 70, "ExerciseOutput",ExpressionUUID->"69b53966-2fe3-4f6d-8384-91d77a3c5c97"]
}, Closed]],
Cell[CellGroupData[{
Cell[245486, 6011, 865, 22, 70, "Exercise",ExpressionUUID->"9f54aaaf-4c61-4e28-91d3-073514b303d1"],
Cell[246354, 6035, 1129, 32, 70, "ExerciseOutput",ExpressionUUID->"2fc4956a-a091-4f4c-9ec4-f382937fbc25"]
}, Closed]],
Cell[CellGroupData[{
Cell[247520, 6072, 961, 28, 70, "Exercise",ExpressionUUID->"352b312b-bf6e-410f-996f-3204df05d47b"],
Cell[248484, 6102, 1568, 41, 70, "ExerciseOutput",ExpressionUUID->"f6bc33c1-d6ae-406f-b268-c7fbe15c11c2"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[250113, 6150, 144, 4, 70, "QASection",ExpressionUUID->"3604a72c-78b7-44ec-8eaf-74dfbf480dbe"],
Cell[250260, 6156, 246, 5, 70, "Question",ExpressionUUID->"c5334af2-0050-494f-bb56-fb2513c4dbe7",
 CellTags->"i:13"],
Cell[250509, 6163, 382, 11, 70, "Answer",ExpressionUUID->"369b1f99-7cde-4f71-a4e2-4045d4acd7c8"],
Cell[250894, 6176, 176, 4, 70, "Question",ExpressionUUID->"86940aa4-9112-47e6-926b-432dae50601e"],
Cell[251073, 6182, 1098, 36, 70, "Answer",ExpressionUUID->"2255b594-975c-40a7-8f89-1f1188c6de05"],
Cell[252174, 6220, 199, 4, 70, "Question",ExpressionUUID->"70e65018-a2a7-4e81-a626-1a29331712d1"],
Cell[252376, 6226, 184, 4, 70, "Answer",ExpressionUUID->"3019ebc6-365b-46da-b98f-526d4a2067d2"],
Cell[252563, 6232, 242, 6, 70, "Question",ExpressionUUID->"f956b3ed-ab2a-4679-bf2f-d2fd01c42eb1",
 CellTags->"i:14"],
Cell[252808, 6240, 559, 18, 70, "Answer",ExpressionUUID->"76865aa5-fd06-460f-9c48-fc036465cc68",
 CellTags->"LastCellOfAPage"],
Cell[253370, 6260, 224, 5, 70, "Question",ExpressionUUID->"9b0d0f75-a0b0-480d-abe4-850ab46c30a8",
 CellTags->{"p:209", "i:15"}],
Cell[253597, 6267, 449, 18, 70, "Answer",ExpressionUUID->"d27b115f-c41d-4af4-bbed-3554c8c73d65"],
Cell[254049, 6287, 204, 4, 70, "Question",ExpressionUUID->"6cdfac3c-2559-44ec-8f41-038a72a86b99",
 CellTags->"i:16"],
Cell[254256, 6293, 302, 10, 70, "Answer",ExpressionUUID->"9009569f-d051-4bd7-8715-9ea2b16e0938"],
Cell[254561, 6305, 578, 20, 70, "Question",ExpressionUUID->"d53c6930-9558-4c26-b5ea-0d815a05c987",
 CellTags->"i:17"],
Cell[255142, 6327, 1288, 38, 70, "Answer",ExpressionUUID->"5e174a1f-9887-40f1-aef3-640f583e68c1"],
Cell[256433, 6367, 243, 7, 70, "Question",ExpressionUUID->"1d9d95ba-65aa-47b7-ad39-bc5879bcdbe0"],
Cell[256679, 6376, 653, 22, 70, "Answer",ExpressionUUID->"b9649809-f593-4827-86f4-9126481ac5b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257369, 6403, 157, 4, 70, "TechNoteSection",ExpressionUUID->"41f029d3-e130-40bd-b738-d5213878f592"],
Cell[257529, 6409, 355, 8, 70, "TechNote",ExpressionUUID->"fdd37ebb-de25-4189-a52d-36115e0329da",
 CellTags->"i:18"],
Cell[257887, 6419, 314, 9, 70, "TechNote",ExpressionUUID->"f4d1f8e5-03a9-4589-89fe-1d250cdf1c0f",
 CellTags->"i:19"]
}, Open  ]],
Cell[CellGroupData[{
Cell[258238, 6433, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"35453e14-91b2-4e22-9774-942e341eaff5"],
Cell[258406, 6439, 339, 8, 70, "MoreExplore",ExpressionUUID->"a420db84-42ce-4a59-ba40-ad586d0535d9",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature 2Izvi34xIzW5RL#08pxa07RI *)
