(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    205779,       4406]
NotebookOptionsPosition[    140034,       3035]
NotebookOutlinePosition[    198857,       4243]
CellTagsIndexPosition[    198778,       4238]
WindowTitle->Patterns: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Find lists of length 3 or more beginning with 1 and ending with 9 in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["IntegerDigits",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Range",
     FontFamily->"Source Sans Pro"], "[", "1000", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"75e4bede-b5c4-4297-913c-90b88608ba0d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"29204658-10e6-4530-be90-84154e5c5e11"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"52ef4425-f51f-40a9-8d1d-24110194a9ef"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm6+P5DYUx9OWFFbqX9B/ILg0sCjSVWVD7tTLqeQa3VWqQsMCw8KCgoKC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            "], {{0, 19}, {472, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{472, 19},
          PlotRange->{{0, 472}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{476, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "dccef852-0cec-447d-9924-1c30b0e914be"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztm6+P5DYUx9OWFFbqX9B/ILg0sCjSVWVD7tTLqeQa3VWqQsMCw8KCgoKC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              "], {{0, 19}, {472, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {472, 19}, 
            PlotRange -> {{0, 472}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"016731ca-8a41-4568-979b-bc6609c3b11b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"621658a8-c972-45ad-85d5-9fbbcd21143d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8f0ad694-64c8-4df3-865d-6777b0cb8279"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"02200b0c-b1a6-44ac-bc03-b7e821c60eab"],

Cell[TextData[{
 "Find lists of three identical elements in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["IntegerDigits",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Range",
     FontFamily->"Source Sans Pro"], "[", "1000", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"be286fba-e2a9-4a08-a958-69eb514c0296"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"a1b8ba3f-e4a2-4bd5-8391-c5ae6aed604e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7e66ec4d-1a50-4d43-a8aa-118207008eef"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz2vpDYUJUmTMlJ+Qf4AdVrKVEgbpZtmV1lWaTZoEymipaOK6OioKKKp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            "], {{0, 19}, {425, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{425, 19},
          PlotRange->{{0, 425}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{429, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cc1ff504-40a3-4152-82b2-142d73995e6a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz2vpDYUJUmTMlJ+Qf4AdVrKVEgbpZtmV1lWaTZoEymipaOK6OioKKKp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              "], {{0, 19}, {425, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {425, 19}, 
            PlotRange -> {{0, 425}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0c76e483-3dd5-4ca1-9f1d-022f9949bfa1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a36071fd-b800-41fe-87d8-2c4a2a021577"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ddb37967-e9ff-46dc-886c-17951ccc0d40"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"60e3046c-7f74-41ff-9f43-1d0fe17f51dd"],

Cell["\<\
In the digit lists for the first 1000 squares, find those that begin with 9 \
and end with 0 or 1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"31f4f2dc-49b9-4468-9a08-c555013592f3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ae0085b5-ef49-4f1c-9190-69c3f2e09414"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT2v8sgZhknSpMxfyB+gTkuZCmmjdDQbZYkiRRu0GymipaOko6OioqIi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            "], {{0, 108}, {440, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{440, 108},
          PlotRange->{{0, 440}, {0, 108}}]], "ExerciseOutput",
         ImageSize->{444, 108},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "29148839-ff48-4b22-84ad-87b0f763b9b7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT2v8sgZhknSpMxfyB+gTkuZCmmjdDQbZYkiRRu0GymipaOko6OioqIi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              "], {{0, 108}, {440, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {440, 108}, 
            PlotRange -> {{0, 440}, {0, 108}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"03f1d632-562f-4062-bf32-4d361ab144c3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"8ab28bb2-d38f-4f41-b6e4-990d5de9eea4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"31173913-862d-41c2-aedb-4694e96ecf31"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f3364eae-c7db-4599-9a1b-87a4804efbc0"],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   StyleBox["IntegerDigits",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    StyleBox["Range",
     FontFamily->"Source Sans Pro"], "[", "100", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"276b4fef-8a43-4058-9a59-d2323c40c272"],
 " replace all 0\[CloseCurlyQuote]s by ",
 StyleBox["Gray",
  FontFamily->"Source Sans Pro"],
 " and all 9\[CloseCurlyQuote]s by ",
 StyleBox["Orange",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"c2452ce9-fb6b-4f23-89bf-4e7e55edd56e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cdeafef2-71e6-422e-90cc-eb4dc6a34e5e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnT9vO+l1Rpm4SZmvkC+g2i3LVAIcbKfGRlZGmo2wDhCoM9SxMtixU6Um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            "], {{0, 174}, {467, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{467, 174},
          PlotRange->{{0, 467}, {0, 174}}]], "ExerciseOutput",
         ImageSize->{471, 174},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3cfbdd74-1403-43c4-8683-de4139125ecd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnT9vO+l1Rpm4SZmvkC+g2i3LVAIcbKfGRlZGmo2wDhCoM9SxMtixU6Um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              "], {{0, 174}, {
              467, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {467, 174}, 
            PlotRange -> {{0, 467}, {0, 174}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"92d25c34-5343-4315-8f12-c44ac0c937dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6771ca97-3cf1-4b9a-8324-21f005422fc0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"96fd9a87-80ed-42cc-bcbe-64c56d72bc5b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9fa80023-e2c8-4157-99c9-1023adae7336"],

Cell[TextData[{
 "Make a list of the digits of 2^1000, replacing all zeros by ",
 StyleBox["Red",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"25c3a287-d533-4d2a-bf3f-ab47bc250764"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f27ff285-2ae6-49f0-b9cc-d0f782b45b37"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS1zK1t6RpWEBOYv5A8YhxoGuWpSYSYzlfFUyMQ1SVXKVMzQTMzIZIyM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            "], {{0, 196}, {483, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{483, 196},
          PlotRange->{{0, 483}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{487, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9fb2a29b-b53c-44d8-a6bc-a4574c20775d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS1zK1t6RpWEBOYv5A8YhxoGuWpSYSYzlfFUyMQ1SVXKVMzQTMzIZIyM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              "], {{0, 196}, {483, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {483, 196}, 
            PlotRange -> {{0, 483}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ce510ce8-5bee-4236-8ea6-0d7476b2b6ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"418cf9a7-f1f1-4bb4-9346-b8d2e73e6075"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"85304421-510a-4435-905b-03a8e7396a1b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a58478e0-9177-4298-a67b-e0aa111e8da6"],

Cell["\<\
Remove the vowels a, e, i, o and u from the list of characters in \
\[OpenCurlyDoubleQuote]The Wolfram Language\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"1c12ed6f-8336-4bab-b5af-eeb19fe7d0be"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c0551c86-0cc7-4690-8fcb-5fc64fb9054f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK+v5DYQjlpSWKl/Qf8B41LDokhXlYXcqS+nktfoXaUqqFJYYFQSZhRV
lUsWRaoUEhQSEtCQgJCQgAAXGBi8GzvZ22w3Tryb091V3dHbp/3xeTyez/5m
nK9f/fTC/cyyrDdfwL8XL3/BT08v/e++hA/fP7758fXjww/fPv788Prh6ZtX
n8OXX8Hrd3jJ9893u9vd7na3u52MN2XZDuLTm5dXGSUJzZvhwwX1n7QhDV2E
Hv/4k0SxNCJNvomiuOyXMswKZFlBsSux5SEmaX10WJMwLo5zdUUS0/KGeWvi
WMrcpNZhPqDxIolo0X3sMMBY4mLsBO8yzKpYZimk5FcH246Nx7RZtuNgbNOG
L/jgpW1ZUbmL9MyHSaLRRZ+H8ME7tKN3AjF42fXzMgI/e+meqN6rsQj2aFh8
7DDARJ3K84COwbAygkSeqBUVZM6OqzUfvARaokoO4ozdpvJdCqzbpZq4iNRW
81PpSrSepK7VzqslXe4WvB65NMH5esiCs1M+5u+vNBZDPNGSZGnMLJkQv0lI
/4bVcCTQdMp4JUlnp0jladoIVZ04P6HBKAvIW64C6zG1FIbSBgYO0SQvvmR6
yOF8JBqFWSG9TrxJpJBXXY4WTYBxmCSukjEtgFIPKR8uabpyWiAOKnaB3zYz
0tW80eFgksyhPkwFDGHbRsghi3EtwiqIBsUjvkmcdxtAGjciffTp07wqkm38
8mJrcBLkA5Q+ZCGaU0h22oPSxMukPG+QzppUKpgXZ3m50OupzSyLCDnkRb2Q
1iMgpEVBA2sCZ2Uuqw2Or1+gIenHef1kK5lcijAO025oqQ/ZQrTsFhaigdWK
aCB9aDJPAmZ1x4x0wARZrz4ICrl26fUiyEY1ZlJq/F50IPd+3rfg7rghL+fd
lvdII+8qZjvSV9hxUfm4KFmOjxVQukU37GpD0o2TOXZf2bj6hgBL5RJOBxON
lNbwUIdKArJ5Fs1IV8mfmKli+0wrjK0EWXdIBsNd2X1Ba4cCkDmEAg01G6Sv
JnnqQ/QyfbaouaurS7NRPMvzriZTNHBCkZ80bRVLqQ2WLwZaGI9V5RJDHchb
0KxVvoL04Rgn1p7NVRsK2HQIyQ5OxtVnIKoYy3A015wN4gxIX7lxnAHeH+mb
jeUVyRxgR0CZBhFyvLjSLmUZxms49RZRV8hGCspsa102cqKGyoCDlM8wF3Eq
D5fIFSfPkuaxacrG1kW1cGDpWKkuh/BKih8pxbLDGTtbMW8BNKRft0A50HLj
siqLAv6KqmW7kqkeU4RpPQx93w/DwDQLWYJNzVvMp0Sed++8gv7WIbP9qVI9
9gDzb2Zx2pat2shL5IoTaa3UGRz208detfHe1GYtDOFUdZA5W/xV3tMndrZi
3gKM/cZEerLidm2B6rnBzKSTXcnsQnzmEHmUG8LONUTd08N1cW5WmitjpLmT
1SEctq4wcLg53Q3xrI8ydHhzMlU1dCom5IMGwUviygcdzBRWq2Izwkapx27c
am6HXSrvv4m+hJggzZ0YDtnz623xrI8ydLgnmeobnNa9EGIYnyHg+G8j2G9/
Ed86q9q8SELXDWrNpUuwrumMLmQrSHMnhkP2/HpbPOujDB3uSqboiHcSbuSE
1SDMYP+koecFpLnlEdPdPgETnDG28SDZHHa3/4e9BXrm0u8=
            "], {{0, 19}, {
            167, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{167, 19},
          PlotRange->{{0, 167}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{171, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "004d5f63-7c2b-47d4-b083-266f8f202685"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK+v5DYQjlpSWKl/Qf8B41LDokhXlYXcqS+nktfoXaUqqFJYYFQSZhRV
lUsWRaoUEhQSEtCQgJCQgAAXGBi8GzvZ22w3Tryb091V3dHbp/3xeTyez/5m
nK9f/fTC/cyyrDdfwL8XL3/BT08v/e++hA/fP7758fXjww/fPv788Prh6ZtX
n8OXX8Hrd3jJ9893u9vd7na3u52MN2XZDuLTm5dXGSUJzZvhwwX1n7QhDV2E
Hv/4k0SxNCJNvomiuOyXMswKZFlBsSux5SEmaX10WJMwLo5zdUUS0/KGeWvi
WMrcpNZhPqDxIolo0X3sMMBY4mLsBO8yzKpYZimk5FcH246Nx7RZtuNgbNOG
L/jgpW1ZUbmL9MyHSaLRRZ+H8ME7tKN3AjF42fXzMgI/e+meqN6rsQj2aFh8
7DDARJ3K84COwbAygkSeqBUVZM6OqzUfvARaokoO4ozdpvJdCqzbpZq4iNRW
81PpSrSepK7VzqslXe4WvB65NMH5esiCs1M+5u+vNBZDPNGSZGnMLJkQv0lI
/4bVcCTQdMp4JUlnp0jladoIVZ04P6HBKAvIW64C6zG1FIbSBgYO0SQvvmR6
yOF8JBqFWSG9TrxJpJBXXY4WTYBxmCSukjEtgFIPKR8uabpyWiAOKnaB3zYz
0tW80eFgksyhPkwFDGHbRsghi3EtwiqIBsUjvkmcdxtAGjciffTp07wqkm38
8mJrcBLkA5Q+ZCGaU0h22oPSxMukPG+QzppUKpgXZ3m50OupzSyLCDnkRb2Q
1iMgpEVBA2sCZ2Uuqw2Or1+gIenHef1kK5lcijAO025oqQ/ZQrTsFhaigdWK
aCB9aDJPAmZ1x4x0wARZrz4ICrl26fUiyEY1ZlJq/F50IPd+3rfg7rghL+fd
lvdII+8qZjvSV9hxUfm4KFmOjxVQukU37GpD0o2TOXZf2bj6hgBL5RJOBxON
lNbwUIdKArJ5Fs1IV8mfmKli+0wrjK0EWXdIBsNd2X1Ba4cCkDmEAg01G6Sv
JnnqQ/QyfbaouaurS7NRPMvzriZTNHBCkZ80bRVLqQ2WLwZaGI9V5RJDHchb
0KxVvoL04Rgn1p7NVRsK2HQIyQ5OxtVnIKoYy3A015wN4gxIX7lxnAHeH+mb
jeUVyRxgR0CZBhFyvLjSLmUZxms49RZRV8hGCspsa102cqKGyoCDlM8wF3Eq
D5fIFSfPkuaxacrG1kW1cGDpWKkuh/BKih8pxbLDGTtbMW8BNKRft0A50HLj
siqLAv6KqmW7kqkeU4RpPQx93w/DwDQLWYJNzVvMp0Sed++8gv7WIbP9qVI9
9gDzb2Zx2pat2shL5IoTaa3UGRz208detfHe1GYtDOFUdZA5W/xV3tMndrZi
3gKM/cZEerLidm2B6rnBzKSTXcnsQnzmEHmUG8LONUTd08N1cW5WmitjpLmT
1SEctq4wcLg53Q3xrI8ydHhzMlU1dCom5IMGwUviygcdzBRWq2Izwkapx27c
am6HXSrvv4m+hJggzZ0YDtnz623xrI8ydLgnmeobnNa9EGIYnyHg+G8j2G9/
Ed86q9q8SELXDWrNpUuwrumMLmQrSHMnhkP2/HpbPOujDB3uSqboiHcSbuSE
1SDMYP+koecFpLnlEdPdPgETnDG28SDZHHa3/4e9BXrm0u8=
              "], {{0, 19}, {
              167, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {167, 19}, 
            PlotRange -> {{0, 167}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"91ebe019-8dcc-4d79-a70c-ded29fc26ffd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0dade4fe-78f9-409a-9131-be997c17a47c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"10dd0223-90e1-4b6b-87ee-e34f67514840"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5bc8248e-6b69-4693-83ef-29a19ef58a98"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Select",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["IntegerDigits",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{"2", 
      StyleBox["^",
       FontFamily->"Source Sans Pro"], "1000"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], 
      StyleBox["\[Equal]",
       FontFamily->"Source Sans Pro"], "0"}], "||", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], 
      StyleBox["\[Equal]",
       FontFamily->"Source Sans Pro"], "1", 
      StyleBox["&",
       FontFamily->"Source Sans Pro"]}]}]}], "]"}]], "InlineCode",
  ExpressionUUID->"5187428a-a4b2-436c-a77b-b0ce12a05cc5"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"fc94d630-e237-4f0a-9e78-9838c879f9e3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"935f9a87-c835-4d22-a347-47952154b223"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztna1v21AUxd82Mrh/YXTAeNRwqFKnsZBWq6uRLuomTaVhhmFmRkFBRUEh
RSEmJiYGISEFASYGBt17TqOkH4nd9iX3xD6/qlHinNx3P/rcFzvx/Xz6+9h7
r5T681HfHJ/8cy8vT66+f9IPflz8+XV+cfbz28Xfs/Ozy6+nH/TGL/p3+E4p
c/+OEEIIIYQQQgghhBDSfOYj33OcbpwvHmZpHE+zYvtrptF4OBiOo2mVcZvW
kAdFltVMCHLpRUJALpZI3oRkuyWLA6WU51/Pirt0eKVK/Ml8y0uioGNEjrnp
hNEmmV1ryIMiy2omBLn0IiEgF0skbyKyPZBFfaX6i9XfdDzodY+0V0G02ats
4ip1FJi0T/rm7nLp+Bib1pAHRZbVTAhy6UVCQC6WSN6EZHsgj80OMFttSLRb
/c1e5eWKcXxbPpiNlBFnm8S2rCEPiixbUpGQmjKRKoiEgFwskbyJynZLOugo
p79yIo/crV6lQ0+vWxfpvytSb3v+LVlDHhRZdk9VQmrKRKogEgJysUTyJinb
JfN03FXK9SerTVVeRXrV7QTLjOehq9wg3jiAJWvIgyLLls/b+YMUqUJNa3YH
RS6WSN4kZbvEL4+ljtddqPMPaLVinOr9p78lBEvWkAdFlt1jcfm09yrUtGZ3
UORiieRNUrZLinnSc5Tqjdc2xeaNebxxUZ0ngd5n3iy8vh2bw5ibxbasIQ+K
LLunKiE1ZSJVEAkBuVgieZOU7Zh02NFelOnM0ziOb0Kd0qvBTRLHs1w7mVw5
yu2NVieaysMOyhtMb6ehudc1H0V6KrNrDXlQZFnNhCCXXiQE5GKJ5E1Gtg9W
Z4Hz6Eg9wBxczWPzkSNn/TTxXZYM3XuJe51mCyuPZXatIQ+KLKuZEOTSi4SA
XCyRvInI9kL5OUB/y6Bmibg66LqkyOb6p6iS2bWGPCiy7An7yJuINbuDIhdL
JG8YMrvkiVmIul4wfe4rKbNRVz87iCsOVFJGGWWU7UG2A/LJwPe8XvLce+8i
m6Wz6jfllFFGGWV7kBFCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgipDXLf
qINvGdYA35BlyJG2p1gAcyEbeK7b6U1uX9aKDrlvVANahjXAN2QZcqTtKRbG
XCiSUag3OevXwK8Bct+og28Z1gDfkGXIkbanWEhzIQmPHnRBqgty36gDbhnW
AN+QZciRtqdYUHMhDtzXXHQLuWvAIbcMa4BvyDLkSNtTLKi5kJR9MLkDfEoD
eoEhN5UTkSFH2p5iQc2FIh2aY4zXyctOhEAm1q6sAb3AkJvKiciQI21PscDm
Qh6Up0VuXrQKRO4bdcgtwxrgG7IMOdL2FAtqLiyugR9OZhVBrVkC7ht1+C3D
GuAbsgw50vYUC2cu6JWhOQYYvODa08h9oxrQMqwBviHLkCNtT7Fw5sKrzwI/
Ablv1OG1DGuAb8gy5EjbUyyMuZAE5nTIG3eAyH2jKKOMMsqeI5+E5psmbn/j
l0dqgtw3ijLKKKPsOfKR3+32wvSN6z9CCCGEEEIIIeTQ+A9nfSXM
            "], {{0, 
            42}, {427, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{427, 42},
          PlotRange->{{0, 427}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{431, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "df3f3978-d24c-409f-a91b-59b5ccc46cd4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztna1v21AUxd82Mrh/YXTAeNRwqFKnsZBWq6uRLuomTaVhhmFmRkFBRUEh
RSEmJiYGISEFASYGBt17TqOkH4nd9iX3xD6/qlHinNx3P/rcFzvx/Xz6+9h7
r5T681HfHJ/8cy8vT66+f9IPflz8+XV+cfbz28Xfs/Ozy6+nH/TGL/p3+E4p
c/+OEEIIIYQQQgghhBDSfOYj33OcbpwvHmZpHE+zYvtrptF4OBiOo2mVcZvW
kAdFltVMCHLpRUJALpZI3oRkuyWLA6WU51/Pirt0eKVK/Ml8y0uioGNEjrnp
hNEmmV1ryIMiy2omBLn0IiEgF0skbyKyPZBFfaX6i9XfdDzodY+0V0G02ats
4ip1FJi0T/rm7nLp+Bib1pAHRZbVTAhy6UVCQC6WSN6EZHsgj80OMFttSLRb
/c1e5eWKcXxbPpiNlBFnm8S2rCEPiixbUpGQmjKRKoiEgFwskbyJynZLOugo
p79yIo/crV6lQ0+vWxfpvytSb3v+LVlDHhRZdk9VQmrKRKogEgJysUTyJinb
JfN03FXK9SerTVVeRXrV7QTLjOehq9wg3jiAJWvIgyLLls/b+YMUqUJNa3YH
RS6WSN4kZbvEL4+ljtddqPMPaLVinOr9p78lBEvWkAdFlt1jcfm09yrUtGZ3
UORiieRNUrZLinnSc5Tqjdc2xeaNebxxUZ0ngd5n3iy8vh2bw5ibxbasIQ+K
LLunKiE1ZSJVEAkBuVgieZOU7Zh02NFelOnM0ziOb0Kd0qvBTRLHs1w7mVw5
yu2NVieaysMOyhtMb6ehudc1H0V6KrNrDXlQZFnNhCCXXiQE5GKJ5E1Gtg9W
Z4Hz6Eg9wBxczWPzkSNn/TTxXZYM3XuJe51mCyuPZXatIQ+KLKuZEOTSi4SA
XCyRvInI9kL5OUB/y6Bmibg66LqkyOb6p6iS2bWGPCiy7An7yJuINbuDIhdL
JG8YMrvkiVmIul4wfe4rKbNRVz87iCsOVFJGGWWU7UG2A/LJwPe8XvLce+8i
m6Wz6jfllFFGGWV7kBFCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgipDXLf
qINvGdYA35BlyJG2p1gAcyEbeK7b6U1uX9aKDrlvVANahjXAN2QZcqTtKRbG
XCiSUag3OevXwK8Bct+og28Z1gDfkGXIkbanWEhzIQmPHnRBqgty36gDbhnW
AN+QZciRtqdYUHMhDtzXXHQLuWvAIbcMa4BvyDLkSNtTLKi5kJR9MLkDfEoD
eoEhN5UTkSFH2p5iQc2FIh2aY4zXyctOhEAm1q6sAb3AkJvKiciQI21PscDm
Qh6Up0VuXrQKRO4bdcgtwxrgG7IMOdL2FAtqLiyugR9OZhVBrVkC7ht1+C3D
GuAbsgw50vYUC2cu6JWhOQYYvODa08h9oxrQMqwBviHLkCNtT7Fw5sKrzwI/
Ablv1OG1DGuAb8gy5EjbUyyMuZAE5nTIG3eAyH2jKKOMMsqeI5+E5psmbn/j
l0dqgtw3ijLKKKPsOfKR3+32wvSN6z9CCCGEEEIIIeTQ+A9nfSXM
              "], {{0, 
              42}, {427, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {427, 42}, 
            PlotRange -> {{0, 427}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"694d7e30-e3ec-44fc-a2c0-bbc4dc4db3e8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cfdca433-d803-4e64-aa84-9c4b9d419cf1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c206b4f0-c5d1-4d16-a817-1da0b00965d8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1211e3fe-ef32-4013-a220-718b13104750"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Select",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["IntegerDigits",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      StyleBox["Range",
       FontFamily->"Source Sans Pro"], "[", 
      RowBox[{"100", ",", "999"}], "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      StyleBox["First",
       FontFamily->"Source Sans Pro"], "[", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"], "]"}], 
     StyleBox["\[Equal]",
      FontFamily->"Source Sans Pro"], 
     RowBox[{
      StyleBox["Last",
       FontFamily->"Source Sans Pro"], "[", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"], "]"}], 
     StyleBox["&",
      FontFamily->"Source Sans Pro"]}]}], "]"}]], "InlineCode",
  ExpressionUUID->"90402482-fcb0-45f4-894b-330d5bf4711e"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"df34d7a9-9b8f-43ee-912f-b22ee3bda63d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"14b4eb2f-343a-4a61-890e-4f109c8c921c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb9vMlt+h9mk2TL/Qv4B12kpt7K0UTo3u8r1Ks2NdTdS5JaOKnJH58qV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            "], {{0, 196}, {481, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{481, 196},
          PlotRange->{{0, 481}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{485, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d02e4df5-2bdc-44ef-ac61-4cb925e2d136"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb9vMlt+h9mk2TL/Qv4B12kpt7K0UTo3u8r1Ks2NdTdS5JaOKnJH58qV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              "], {{0, 196}, {481, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {481, 196}, 
            PlotRange -> {{0, 481}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"de4e9587-0665-4609-8ae2-0cccf533726d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["32.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ddf36cf3-8ccb-4181-8e6a-1b694467c05b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e99abe0d-2e00-4d52-a787-7c79f9ec1ad2"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d4324bf8-98df-416c-a4a2-bbd65e0c984d"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Patterns: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 32  Patterns", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
32-patterns.html"], None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "32.1", "32.2", "32.3", "32.4", "32.5", "32.6", "32.7", "32.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "32.1", "32.2", "32.3", "32.4", "32.5", "32.6", "32.7", "32.8"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[10117, 242, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8f0ad694-64c8-4df3-865d-6777b0cb8279",
   CellTags->"FirstInputCell"],
  Cell[20983, 509, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ddb37967-e9ff-46dc-886c-17951ccc0d40",
   CellTags->"FirstInputCell"],
  Cell[38572, 883, 813, 26, 
  70, "Input", "ExpressionUUID" -> "31173913-862d-41c2-aedb-4694e96ecf31",
   CellTags->"FirstInputCell"],
  Cell[63914, 1392, 813, 26, 
  70, "Input", "ExpressionUUID" -> "96fd9a87-80ed-42cc-bcbe-64c56d72bc5b",
   CellTags->"FirstInputCell"],
  Cell[92867, 1954, 813, 26, 
  70, "Input", "ExpressionUUID" -> "85304421-510a-4435-905b-03a8e7396a1b",
   CellTags->"FirstInputCell"],
  Cell[102016, 2189, 813, 26, 
  70, "Input", "ExpressionUUID" -> "10dd0223-90e1-4b6b-87ee-e34f67514840",
   CellTags->"FirstInputCell"],
  Cell[111580, 2445, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c206b4f0-c5d1-4d16-a817-1da0b00965d8",
   CellTags->"FirstInputCell"],
  Cell[138906, 2994, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e99abe0d-2e00-4d52-a787-7c79f9ec1ad2",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 197658, 4210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[629, 21, 744, 20, 70, "Exercise", "ExpressionUUID" -> \
"29204658-10e6-4530-be90-84154e5c5e11",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1398, 45, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"52ef4425-f51f-40a9-8d1d-24110194a9ef"],
Cell[2037, 66, 7473, 151, 70, "ExerciseOutput", "ExpressionUUID" -> \
"016731ca-8a41-4568-979b-bc6609c3b11b"]
}, Closed]],
Cell[CellGroupData[{
Cell[9547, 222, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"621658a8-c972-45ad-85d5-9fbbcd21143d"],
Cell[10117, 242, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8f0ad694-64c8-4df3-865d-6777b0cb8279",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10967, 273, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"02200b0c-b1a6-44ac-bc03-b7e821c60eab"],
Cell[11254, 284, 717, 20, 70, "Exercise", "ExpressionUUID" -> \
"a1b8ba3f-e4a2-4bd5-8391-c5ae6aed604e",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[11996, 308, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7e66ec4d-1a50-4d43-a8aa-118207008eef"],
Cell[12635, 329, 7741, 155, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0c76e483-3dd5-4ca1-9f1d-022f9949bfa1"]
}, Closed]],
Cell[CellGroupData[{
Cell[20413, 489, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"a36071fd-b800-41fe-87d8-2c4a2a021577"],
Cell[20983, 509, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ddb37967-e9ff-46dc-886c-17951ccc0d40",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21845, 541, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"60e3046c-7f74-41ff-9f43-1d0fe17f51dd"],
Cell[22132, 552, 491, 12, 70, "Exercise", "ExpressionUUID" -> \
"31f4f2dc-49b9-4468-9a08-c555013592f3",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[22648, 568, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ae0085b5-ef49-4f1c-9190-69c3f2e09414"],
Cell[23287, 589, 14678, 269, 70, "ExerciseOutput", "ExpressionUUID" -> \
"03f1d632-562f-4062-bf32-4d361ab144c3"]
}, Closed]],
Cell[CellGroupData[{
Cell[38002, 863, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"8ab28bb2-d38f-4f41-b6e4-990d5de9eea4"],
Cell[38572, 883, 813, 26, 70, "Input", "ExpressionUUID" -> \
"31173913-862d-41c2-aedb-4694e96ecf31",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39434, 915, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f3364eae-c7db-4599-9a1b-87a4804efbc0"],
Cell[39721, 926, 863, 26, 70, "Exercise", "ExpressionUUID" -> \
"c2452ce9-fb6b-4f23-89bf-4e7e55edd56e",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[40609, 956, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"cdeafef2-71e6-422e-90cc-eb4dc6a34e5e"],
Cell[41248, 977, 22059, 390, 70, "ExerciseOutput", "ExpressionUUID" -> \
"92d25c34-5343-4315-8f12-c44ac0c937dd"]
}, Closed]],
Cell[CellGroupData[{
Cell[63344, 1372, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6771ca97-3cf1-4b9a-8324-21f005422fc0"],
Cell[63914, 1392, 813, 26, 70, "Input", "ExpressionUUID" -> \
"96fd9a87-80ed-42cc-bcbe-64c56d72bc5b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64776, 1424, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9fa80023-e2c8-4157-99c9-1023adae7336"],
Cell[65063, 1435, 517, 14, 70, "Exercise", "ExpressionUUID" -> \
"25c3a287-d533-4d2a-bf3f-ab47bc250764",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[65605, 1453, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f27ff285-2ae6-49f0-b9cc-d0f782b45b37"],
Cell[66244, 1474, 26016, 455, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ce510ce8-5bee-4236-8ea6-0d7476b2b6ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[92297, 1934, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"418cf9a7-f1f1-4bb4-9346-b8d2e73e6075"],
Cell[92867, 1954, 813, 26, 70, "Input", "ExpressionUUID" -> \
"85304421-510a-4435-905b-03a8e7396a1b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93729, 1986, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a58478e0-9177-4298-a67b-e0aa111e8da6"],
Cell[94016, 1997, 529, 12, 70, "Exercise", "ExpressionUUID" -> \
"1c12ed6f-8336-4bab-b5af-eeb19fe7d0be",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[94570, 2013, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c0551c86-0cc7-4690-8fcb-5fc64fb9054f"],
Cell[95209, 2034, 6200, 130, 70, "ExerciseOutput", "ExpressionUUID" -> \
"91ebe019-8dcc-4d79-a70c-ded29fc26ffd"]
}, Closed]],
Cell[CellGroupData[{
Cell[101446, 2169, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0dade4fe-78f9-409a-9131-be997c17a47c"],
Cell[102016, 2189, 813, 26, 70, "Input", "ExpressionUUID" -> \
"10dd0223-90e1-4b6b-87ee-e34f67514840",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102878, 2221, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"5bc8248e-6b69-4693-83ef-29a19ef58a98"],
Cell[103165, 2232, 1180, 37, 70, "Exercise", "ExpressionUUID" -> \
"fc94d630-e237-4f0a-9e78-9838c879f9e3",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[104370, 2273, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"935f9a87-c835-4d22-a347-47952154b223"],
Cell[105009, 2294, 5964, 126, 70, "ExerciseOutput", "ExpressionUUID" -> \
"694d7e30-e3ec-44fc-a2c0-bbc4dc4db3e8"]
}, Closed]],
Cell[CellGroupData[{
Cell[111010, 2425, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"cfdca433-d803-4e64-aa84-9c4b9d419cf1"],
Cell[111580, 2445, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c206b4f0-c5d1-4d16-a817-1da0b00965d8",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112442, 2477, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1211e3fe-ef32-4013-a220-718b13104750"],
Cell[112729, 2488, 1277, 40, 70, "Exercise", "ExpressionUUID" -> \
"df34d7a9-9b8f-43ee-912f-b22ee3bda63d",
 CounterAssignments->{{"SectionNumber", 32}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[114031, 2532, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"14b4eb2f-343a-4a61-890e-4f109c8c921c"],
Cell[114670, 2553, 23629, 416, 70, "ExerciseOutput", "ExpressionUUID" -> \
"de4e9587-0665-4609-8ae2-0cccf533726d"]
}, Closed]],
Cell[CellGroupData[{
Cell[138336, 2974, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"ddf36cf3-8ccb-4181-8e6a-1b694467c05b"],
Cell[138906, 2994, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e99abe0d-2e00-4d52-a787-7c79f9ec1ad2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[139746, 3024, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d4324bf8-98df-416c-a4a2-bbd65e0c984d"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature dRcYcINbcwbkXiYerfgEDCfs *)
