(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1029838,      20329]
NotebookOptionsPosition[    936468,      18324]
NotebookOutlinePosition[    999499,      19620]
CellTagsIndexPosition[    999419,      19615]
WindowTitle->Rearranging Lists: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Thread",
  FontFamily->"Source Sans Pro"],
 " to make a list of rules with each letter of the alphabet going to its \
position in the alphabet."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"068a6085-146d-4d10-8dac-f33c28c8bbd3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eb179cb3-8f53-45f5-b915-1e0569ea5f0c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXT2vtEpynrWTDf0X/AeIHZrQEdJazkh25ctqk2t015JFSkZIZDIiIiIi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            "], {{0, 64}, {407, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{407, 64},
          PlotRange->{{0, 407}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{411, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "acda2289-18c5-455d-ae21-ebeaa5e46e4e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXT2vtEpynrWTDf0X/AeIHZrQEdJazkh25ctqk2t015JFSkZIZDIiIiIi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              "], {{0, 64}, {407, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {407, 64}, 
            PlotRange -> {{0, 407}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d3266303-119c-4dbb-95b7-b52b27191930"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6dbecfdd-0e42-4ef7-9355-b55168575317"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"08c8f038-e718-4164-9007-ec7690b13ce0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ed15eac0-b2d6-4d2a-8b86-d9026cff8514"],

Cell["Make a 4\[Times]6 grid of the first 24 letters of the alphabet.", \
"Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"a258d10f-4c9d-4c7d-8080-5f77a23f3b00"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8b919e1e-ae9c-4b91-b9ff-99ab7c1eb1ca"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXK+znTgUZnbNyv0X9h+IXhtZxUx31mHa2dJZ02W6O7ODxSFxOBQKhUJh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            "], {{0, 73}, {102, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{102, 73},
          PlotRange->{{0, 102}, {0, 73}}]], "ExerciseOutput",
         ImageSize->{106, 73},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6d9072b3-8014-426e-a116-8523ae90d6c6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXK+znTgUZnbNyv0X9h+IXhtZxUx31mHa2dJZ02W6O7ODxSFxOBQKhUJh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              "], {{0, 73}, {102, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {102, 73}, 
            PlotRange -> {{0, 102}, {0, 73}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e4b0aafd-4ff3-401e-92f1-a21cd4170220"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a211d9c7-d017-49b5-8b80-861642336b70"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"831b6da1-e89a-4efd-9d79-e0092cb979a5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8db5fdf2-a156-450e-aadd-c0937ade41ed"],

Cell["\<\
Make a grid of the digits in 2^1000, with 50 digits per row, and put frames \
around everything.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"196c739e-0149-477c-961e-af3999b70bd6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26758944-bcad-4ff8-badf-2e35858665e5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfaGP886WZbRDBs6/sP+A8VLDQZFmNSxkRvsyGvI2erPSKGCIwUiGZmZB
RkZBRiZGJiYmJgYmJgYGJgYG2apykk63y+mqY6fS/ele6f3Ur7+cvveee+pW
lV2x/+e//t9/2v+PzWbzH3/P/vNP//Kf9t/+9i/H//0P7P/881//49//7a9/
+T//+Nf/95d/+8vf/te//h375X+x//03+4H/fCEjIyMjIyMjIyN7q23IyMjI
yMjIyMjI3m3wUpZQhCIUoQhFKEIRilCEWo6iFSmhCEUoQhGKUIQiFKHei6IV
KaEIRShCEYpQhCIUod6LegrsyjyvukHLY5XFYRDGWaWI6psq/2xV0yv60o9w
qIsHT0X11dN6eY1W5+k5DKO0mDp6ghraKonO4TkqJlSsGKFZ5rmZY6OrUwYJ
z2nRaEWo6wvnsG/SmDtKi1ojQjQvSL1dFvNyZVWr5UtYW2QMp6FeTBuIL4RD
031DmC6HYL2wCM30KPMok53NzAy7RL1YlbG8hGn3DYPjy2iVdVFLZnNTilJC
zQVZhsfxX91Uo79l/o5jLP6f3SlTQeWevflslvcVKPUFRdh51qMrO+telRfT
SOzy1OytSPBwVuwDXRE8hhhM5P87mTfHRpuHY5HH/x7CQi1CxBfG4VDH24cI
t24y7Tsr5oWod6hEuTaWQB0jSbOS+hot9Xh+lpuqoUBtAL5QDk32DSQvuF5Y
hMZ6lGGUyc5mbIaF1YtVGctrNM2+YXB8ma0ygIJnc4OKUkLNlayKA+fAS+Zn
ykx2KSNl6/OkUs7PNp+UTeZuGPqBGfspPzGPW8XxgkR46Xx7sz3l3OnV58vy
Eign5lfA2tRjJU+V8mqFso4ld9GGrj/dj/1K5g2yUQZsiLniymMX7Pmwnl4L
W415iMOhjmzLKYX8RKOzVdgA84K0Uce8JYY8xOF8ZH3kMF3izLWOvgzHxjI6
VYxQXxuIL1QbBvsGlBdYLzBCgz3KJMpoZzM5w0LqBfshNi9zw/qGmfFltMog
CprNjSpKCTVXMmEFS8xT5qTPffbLeGzxdbTh2K+kPHM3FGy22AWqV36ACC+X
xmVVLuRXwudQYF5dxgp8TERsQ26raXioz3yanH70FRF+eH098wbZYM7a282O
NnUV13uorzse4FBEmDiKEWJ5YdrIWHeyvGt1BepUKCqqdtmCyN7trI092aTL
UZA2QF8Qh0b7hvi0bl5YvbAITfYok6ibmehsmC80L0S9y/qh7rx8ATRvcnyZ
rPIylN5MZFJRiqhnqfW8CuqclOH+45rDUO4110UVh+9L1fU2EiHTlbhSvzvs
944XFI3E2Xp5NSemDGsfF1V6YqBjNfE2RXUZ239tk6KITqdTEBXtSyO8mgnm
DbLxaHym3jjTk5qr+wI47Jo6T0J+y2QfTPv+Wnlh2hB/371Wt02ktZZGmPMy
b6KqDraS20YzKEQbqK8PU+fQbN9A8sLqhUVoskeZRF3NSGfDfIF5Qepd1A+1
OUQ0b3J8mazyIpTmTGRSUYqoFVekYp/u3/LpT/bG9vPv47xaddyMV3SVfGER
Ms4d29q7pygK9vxIw3Z6TGPFvKrzYXOzbVCqRNiJPQtfpBydHY/Qjie3FX8l
8wbZuNtQncVyT2m3uMwXwCG/hTGalMa18sK00ZeBaB6O7zvj2R9f5eqZCOwY
8VWecKR6xRjQBuzrEa7Iocm+geWF1QuL0GSPMom6fdxEZ8N8gXlB6l3UDzXz
wjRvcnxdDFZ5EUpzJjKpKEXUk6aN7ODud44uFaufq3ZdhZu4YhyU0i+xrb+P
4NYmluzk8Fp59cWJZ5Q3Q1cGR745OE+2VXN9ILzucMqDTF2/kXmTbFytTflO
eCe5/Li+L4xDNkb7JvJ2imxcTTMvWBttmXjO8ej4SXq2lVDdSXxf6+B6nueI
H7d+XH3rC9IG6OuWmx6Hn7Ev7Rt4Xvr1ArVhskeZRF3NSGfDfC3KazRl9S7q
h3p5gZo3Ob5MVnkRSnMmMqkoRdQz4JDzkwy5/CSJrGpMw9Z41OLSxOwD/gQ7
566K2NJ+Nz1V+xylGyE/Unv/UZzpVVtbInkVXPrO7XMtP7Km8N03ca7j5uvS
+ZbSN+Z+PvMm2eDWpPxrK7Ynf77Pur4QDvuPz/JTScojGshrgTauf4Hfv9uc
6287cJ8Evuf7Hjd3K3bBp+T7bg9pA/TFTZ9Dg31jQV73P6FaL1AbJnuUSdTV
jHQ2zBeaF6TeBf1QMy9Q8ybHl8kqL0HpzkQmFaWImkmtL/M8T/i+4BgkRZ7X
Kt/AEucQNvugaip+1ELn+7mfrx6roJAI+XV320nLuqkycWnKihT6NpZXHTvs
l+457/q+TPh+002/zoGyvGoO2/lF02TiERBK3yj58cybZKOvY/E8i40fZ3mW
pWlaTg5Brca8MF0OI6ZD6xgXddtUZ3cr3dWulhekjaFJDjsnKaoyC3l8h7PK
86ke/4D0BpAUhWoD8YVxaLJvYHmB9QIjNNijTKKMdjZzMyyoXrAfQnk9ZKiu
eZPjy2iVF3CoPZsbVJQiSp5an43PS7yb4pnhrghvh+PscykhZo7J3N8ycWgw
CUXYVcnxA2afJqJaNa8h8fd3Z3tf6ZmTF/Gwyt0NdQzUnxD4o5k3yQbP6LMp
XoHEmL/oc9jX2Xg2S5jlRUqnkuC8AG0MTbq/BWjt/ekx/jlfd5+3B32ooEBt
AL4wDs32DSQvuF5YhCZ7lDmUyc5mcIaF1YtUGc3rHqxO3zA3voxWeQGH2rO5
QUUpop6W7JnNAoeu/XjCijIK8wWhhp7FNxfg2nlxZ22ne0+cO2Mozbc8/Hjm
jbLx1H6Cr5EMbR1CvjBtsPhmq/VTtAH5glBG+8ZTW7leYIQGe5RJ1FP7EeqF
8gLVa7T3Qqg/tcomUQYV9S1q/RUpoQhFKEIRilCEIhShCKWDohUpoQhFKEIR
ilCEIhSh3ouiFSmhCEUoQhGKUIQiFKHei6IVKaEIRShCEYpQhCIUod6LohUp
oQhFKEIRilCEIhSh3ouiFSmhCEUoQhGKUIQiFKHeiyIjIyMjIyMjIyN7uwFL
2SVrYEIRilCEIhShCEUoQhHqEUUrUkIRilCEIhShCEUoQr0XNQvsmzQ+h+co
LWoNjxjqchnaKok4sGgkb0SYQ1VZHAZhnFWKvvqmyj9bNXH3lMm2yLKq1YgQ
QelziOY11MUDpqimIa7F/Bglpo06T89hyGDSd2WsiTLHPDdTHOJVvly6kmU0
84aN9fIyHSGC6uqUNajwnBaSl9899XXR7xtdFnPxMoyGL7O91xyHfy7zkHqh
CH9DPzTX57npMo/3KGh8AVXGI9Tn8IW+pMChjscXkI6vSt66Sm9xxVAX/mbV
YPNgwSRYKSrzd3dnu5PaG889e/PZLO8r8El/Sz2en+WmKr4wFMYhmlfnWY8g
e/L63NWYR7XRxy5Pzd6KBA9nNeUjKLPMm+QQrHIZHkfA9M3v6+ZlOEIA1eah
9cD8ISwUfY2m1zeGSoh3Ywlnx0iysF9PG2DvNcbhH8w8ol4owt/QD831+QvY
N8AehYwvsMpYhBiHL/QlpXGoI9tySiFB8UfsVMEjhmJdR6j4WPL42tD1p6tn
CapLGWjrc7WnHL/NVVCXYegHZuyn/MQG3FZRV8z6MhzpGp2+CIVyiOXV+fZm
e8o5/IpWQEHMg3kJX07Md+ht6rEx+jqUUeZNcohV+XKp4sA58EnJz5T7Njgq
DUYIocqALbNdcZ2oC/Z8KpterVurA9Qxny5DXubhfGR9/zCdkN7cew1y+Ocy
j3CIRfhb+qGZPn8B+wbWo5DxBVZ5wWyuz+ELfc0N57u1iaM+ygDUUJ95o5l+
9Cmqz332y3hsT3XEfvYm0n8W4VCwTrcL1HfctcukYe921saebPrWRl0NYV4v
r8Zlo7KQ37mYQy1lXiuvLmMaPiaibwy5rdqpIBQW4d10mDfKIVTlmxVbHptq
30bzMhchiura2w2+NnV1tKHdATI2h1neNTLB4al4lTaw3nszMxz+mczfTI9D
MMIf3w/f0ed11Yv0KGx8oTqEuijI4Qt9PRFV19R5EvKbcPtgyukcUBfVZWy1
vE2KIjqdTkFUtJI0JXvncP+xXx7KveacXnH4vlS+GpOfeEJRVQdbyW2IdVEX
lPmLbl5dJu5p7Q77veMFRfNy5vXzajiF1j4uqvTEXB2rSYzrobAIr6bFvFEO
oSpfrec9RL1vg3kZjHARShifLzbO9FzdWh1A/H33GlmbSON8b++9mikOMdQP
Z/5qmhyiEf70fmi+z2urF+pR2PgCqwx2UYjDV/qaFxW/MDuatHAzQG1UJ66r
cMkfnR0/nGDHkxszM/sI/zZG+pO9sf1cLUJm1XEzXnOWmGSnU/GdzjHivVA4
Utr3YShhGPMX3bzYmsGxrb17iqJgz5nfTo/VrMo8kld1Pmxutg3Kl6KMMW+U
Q6jKt9D0Z0wgL4MRLkLdBvVe7coP1gH6MhDN3vF9Zzyr5avuVgz13lugJjjE
UD+f+ZtLPQ7hCH94P4QjRPPSVy/Uo7DxBVYZ7aIIh6/09aQJcM99E3l8h3Se
LGefdQ8d1Fi18LqbKg8yJU9R/GrM/cr2pWIoV3k/O14JD0rpl72mqO4kTngf
XM/zHPHj1o+r16A+DGFeL6/P1iaW7KT3ysxr5tUXJ55R3gxdGRy3L0VhEV5N
k3mTHH4y5SpfDbhGuiAvAxEuQrUpJ30nuVgkQ+EdoC0TzzkeHT9Jz/YrtYH1
3quZ4BBD/QLmr6bPIRDhz++Hb+jzC67wq/coeHwt0aFWhAu18QpfM+76DzHx
O/6KcwSCEmfPrOT6wc63lL6d1xcPqCZmH/Bz1fueVcQ2cLvpdy5mUH0S+J7v
e9zcrdgRnJJv+xuGuqDMA3lxBx+CEKeO1fobxjySV8GnFuf211t+jExBGxjK
JPMmOcSqfPfCT1tNYptDoXmZixBHNSn/Yo3tyZ9AtGYHePgT/K7f5lyrzBHm
eu/dy+s5xFC/gPn75xH1akb48/uh2T4vTJt5aK5cMr7Gv6ChQyRClMMX+pIS
ErHVvHWMi7ptqrO7le53pkAMxTZUDt//+kXTZOKxDErneMUptc0+qJqKH0lQ
/T4at8/3FlVRo1fpjcgVUSiH3HTz4lfQbSct66bKxCbYilSUDzGP5VXHXBru
Oe/6vkz4ftNNv85La6FMMm+SQ7DKl77M8zzhu9pjkBR5Xqt8CxvKy2iEEKqv
Y/FMq40fZ3mWpWlaTo6ErdUBhiY57JykqMos5DU+nFWeumO09xrk8M9lHuEQ
i/Dn90OTfR5jHu1RyPjCqoxFiHH4Ul9SUfV1Np57EGZ5kdLpAgx1EY8+291g
x0D1G0BdEd4OudjnUiL/ufGS+1vWpKAV6f2hB69CwRxe9PPqquS4vbna2KeJ
POZ8AcyjeQ2Jv7+HuPcVn/WHoEwyfzHIIVjlPvsACVP87hWQl9EIIRSv72fT
uA4mUlTvAEOT7m9Ftvb+9PC/FGW09xrk8I9lHuIQi/A39ENzfR5jHp4rgfGF
VRmNEOHwpb7mRMXxfde2M281mFcjhmI4Dus1373CQN2ssyepPbGfgEI5RH11
+r4g5sG8RpjGaQQcZZJ5kxyCVX5q6+dlLMIfj2I1ntXuD+m9T+33oswy/8zW
jfA39ENzff65rd2jkPGF6xCZzVFtvMAXVrJnHglFKEIRilCEIhShCEUoHRSt
SAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShCEYpQhCIU
oQj1XhStSAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UGRkZGRkZ
GRkZ2dsNWMouWQMTilCEIhShCEUoQhGKUI8oWpESilCEIhShCEUoQhHqvain
wK7M82rmqfxyYFen0TkMz2khebGUFNU3Vf7Zqkbl/blDXTxgimr6EoCZ1Los
ZhFGWfX1bXRPUaO1RcZwkvcNzKGGtkoYIeeomCQlRaFsIMyPMJQNPW2YrTKq
jb5JY16stKgV87qZ/ki52ssVNVqdp7zMaSF9V8Z6ioJH5QXjUDcvfHyhEQrT
qjLKIdgBAG3gVYbUC/UojI3f0AGqLA6DMM6ql/tC2DA9LyOd7WovH5VYtzE5
Vy7rh5dXzF9zwDI8jv86fY/wnMc2D8fXsY7/PYSFCir3bu/BvpnlfX39qyzI
zrMeQfbk5bQy1FC5wpslsMdIMqif8J96/GWulpsqoroieAwxmAyatdjAmIfZ
ALRhtMoQaqjj7QOHW1fx3coIG3czoCjWdWJRZnsrSnA4q3QqUFFgvTAOkbxQ
HZqsMsIhWi+EQ7jKiHqhHoWx8Ss6QObv7iHuTkrvScd8oWyYnJcx9V7NwKjE
uo3JuRLuh6O9Yv6ac1fFgXPg7vxMdZSVARssrthNdcGeD9Dp7lTmbhj6gRn7
KT8xj1vFVYdvb7annMOv6O9RdcxbR1iyTw/nI6vfYSr9OUL6Mhzp2vqKfaAV
1T6WnPU2dP3pLm4tNjDmYTYAbZisMoYa6si2nFJ8WDQ6O1WbZyE2uBlSVJcy
kBNzdbSpx/qHSl7oWMbqBXEI5YXq0GSVEQ7BeoEcYlVG1Iv1KIyNX9ABRL3G
D6eczW2uNKcgvlA2DM7LoHq5mRmVaLcxOVeC/fDysvnryQL4cilYiJ7GKOva
222LNnXVR/TVhoL1kV2guLtvmAO/kN8lmUNljBHLu+ZTR+wDp+JriDMR1i4b
KPZuZ23sySZCihrqM2+FUwq+9zXitdhAmF/AxkVfGzd7fZVR1Ie1iaOpXoAN
U4rqMtYGjomIbcht5VUHNJaXMK/JIZjXzfR0CEXITbvKKIdQvUAOkQgx9aI9
atlM9FM7QJ/77JfxuLwWbHiTBcR6OvwwHTYMzst4BzA2Km+GdBszcyUc4avm
r2dB9rziyKpj1NjGmZ4+eYKqQrab3ZeKa/suE9eLd4f93vGCopHA5MrfuNd8
2kSanTTC/MTvlURVHWwll7WlqC5ju7ZtUhTR6XQKoqJVivBuemw8mDrzMBvc
UG0YqDKIGqFNnSchL/Y+mI6cFdkwqKiGu7L2cVGlJ0b+sZrgVhvLC5jX53BR
Xsj4MlLlRRwK0+m9EIdQhJh6F/Woj7+gMRP95A5QctHervcO5V55RYroUJg2
G0bnZbADmB+V2GxuYq5EI3zd/PWKFelQnYWEtXYE1XEzXnNW8zWUjm3t3VMU
BXt+fGI7PcIj2WOWgSia4/vOeObCVxjRYzrHiHe1k72xfaW8OrGf5TwcnR13
ZseTW0ersfE5VEXmMTZuYEwbJqoMorjxGx+jSVNbiw3DiqrOh83NtkGpkZfu
WMaZRxS1IC9ofBmp8iIO9XsvwiEUIabeRT0KmYl+dAcQ1xL9W/69AH7V8Go6
5KbPhsF5+QKp9x2jEpvNjcyVkK+Xzl9PhjO46mhTvnreSbZUz1DiWn1QSr8w
980umO2qLNmpcimqLRPPOR4dP0nPfGP2/V6sO4kT3gfX8zxH/Lj14+pbXyP/
4XXXUR5kFV+ZDX3m9dm4GaYNU1Veghr6JvI4kefJlnslNowqqi9OnPO8Gboy
OG718sLG8hWrybymohblhenQSJU/mS6HmvVaxKFmhHA/xHsUqt4f2wH4NdL7
3e1LdXjl/HU3hI3RXjsvY+p9x6jEuo3JuVLP12vnr2epDTk/G5PL7/vLgU3K
D5LbnvyJG/OcVBFbpO+m57TnUQ9Hd8UJZ41OJazn15A35/pbDfdJ4Hu+73Fz
t2L3cUq+51+c+bGSa1Cdb2l8i02fDZz5a7SqbNwM0Ia5KmOo/iMufipJZ0Tr
sWFUUQVvH84tspYfqlPUIaKoBaNSU1F4Xtj40o4QrDLOoX69UA6RCJf0w+tf
0OpRiHp/fAcoHjhsYvYBf+JxPR1ibBiblzH1Gh+VaLcxuSLS9PXa+WsmyL7M
8zzhe5BjkBR5Xit8p6+vY/Fkio0fZ3mWpWlaTo4KzHHy+X7E97741XrbScu6
qTKxgbMiBQ0PTXLYOUlRlVnI1/aHs+LzPe5/QHqjZAZVO3yH7hdNk4nHg6h/
b0iXDYx5lA1EG1heWJUxVMRQ1jEu6rapzu5Wumdclw1hL1dUHXOQe867vi8T
vkt106+z9FqKwpjHOMTyGk1XhyarjHGI1QvjEK0yol6sR2Fs/IIOIM6ObvZB
1VT84KTOs2J0fWFsmJyXl3SA0e2rR+Vo+t0GQZmPUNj685fcXZ+NzyK7m8oJ
6tz/AtLYY3KsrcFJVyXHD2/2aSJFKWpgG+fbM7usvT89CP0kwtHt7QELSqjh
1hhFs9I4T67LBsY8yAakDSwvrMoYqq+z8XTLyIcXqZ2pW8DGGOzrFTUk/v4e
3t5Xeq4gpiiMeZRDJK+P7HR0aLLKGIdo70U4BKsMqRfrURgbv6IDdEV4O9pp
n0uJhNfyhbFhdl7GO8AY7KtH5Wja3QZCmY9wdLv6/PXU3TPDgOuihr5ru5n3
ZMyjurZtu5kr1OvnNXTcG/AuD8AXgjLLBoLCqoyjWm3Uc/sRihoT071P/dTW
ZR7zZTIvk6ifzyEaIaJekz3qF3QARmE3G+JPYMPovPyndjYI9fMj/LYD/OoV
KaEIRShCEYpQhCIUof4AFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShCEYpQhCIU
oQj1XhStSAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShC
EYpQhCIUoQj1XhQZGRkZGRkZGRnZ2w1Yyi5ZAxOKUIQiFKEIRShCEYpQjyha
kRKKUIQiFKEIRShCEeq9qHlgl8XnMIyy6uv71557rPOUw9JC+hYFGWqoi/zD
imoKnKL6pso/W9WovIP4bm2RscwkMa6XF7cqi8MgjLNK+q9yVN+kjPkzc1Vr
oLB6gb5G0+IQqfIV2VZJxIMsJiWWojBtmEQ9mBEddnXKCAzPaSF5tdzKEWK+
UB0i4+tnd7YHM8K8QJZMtzNvelmLefMjRbdvjKavKLzKkHqhvEyNymVVRnSI
oi6AojBfun3D+EwE9MMXdjY5cKhc8fZcS7xt9hhJhowM2McCZm8F+HBWi7Pz
7q/P5WZPXgssQeWevflslvf1NalPOEk9/gpYy01fmdcl88VLXEV2u5Pae5zr
eHw57UjJ1lV7Vy9UL9DXzTQ5RKrMYUXwCAsmw3otbZhE3c2ADts8tB6qfAgL
NV9IhJgvWIfA+Pr5ne1uBphnVobHMbjpm9+foADmzY4UpG9gecFVhnwheZkc
lXCVMR1iqNF0FQX5QvqG0ZkI7Icv7GxSYB1z8sOSaXA4H5nvwzRQCbBLWXJO
zPdTbeoxn6lSnJ1vb7annPkSJklBhhqG/vrp/MQS3Kpz0pfhmPjWV+sDWF4C
NbpIuVq2+USOsj4Q2ZZTChKEmG0VX1i9MF+jaXMIVrkV4+xYcura0PWn+8z1
tGESxc2MDsuATXyuuMbRBXveUKdXSdaKEPMF6hAaX7+hs3EzwzyzKg6cA58g
/Ex5noWYNzpSsL4B5gVVGfSF5GV0VKJVRnSIoi6IovCRot83zM1EYD98ZWeT
AjOme8u78l5H7DOn4mt6Mv4zxv8xEbght1X5b1xW5UJ+JXwedbOhYONtF6hf
+aldRry921kbe7KJkKOgvPrcZ7+Mx8EvOPQmEnmWF9Nw4ij2AbBekK/RhzaH
UJWH+swb6DSs7yMc8braMIkypEMGa2+3mdrUfXGVYV9XU9chNr5+SWczzHyx
5eypzrNLO9vrRwrWN9C8kCpjvtB+aG5UPsQKdFE9HS5AAeML8gX2jZu9fiZC
Vw4v7GyzK9KNe42zTWxZFaRxnhgX1j4uqvTENmPHahKytGriGu7usN87XlA0
kjSf8F+FzNG+VF6l5zzETVTVwVZyWXsGheRV8sBuu9Gh3Ov07a6p8yTkge6D
afeR6wqpF+LrgnEIVbnL2L5ymxRFdDqdgqhoX6sNkyhjOnw0oRNneiZsvQhB
Xxd9HWLj61d0NsPMX/pMysMcaklnuxgZKVjfAPOCqoz5WtgPL68flXdDuqim
DmEUPr60fS3q2AZmIrAfvrKzSYF9GQiHju8743kBX63nVOfD5mbboFSKcygd
29q7pygK9tzZdnpMY57/6rgZrx5LTLLHrPge8xjxEXmyN7avuvsA8hK7D//G
Wi/cfY1zJi9+SXw0qfglO260XoAvkEOoyp24ksDb4dHZcZQdT244raUNkyiT
OvzidK+2d4YjBHwJ09YhNr5+fmczzrz2PLugs13MjBSsb4B5QVXGfC3rhyZG
5c2gLmpkRbpofOlHuKBjm5iJwH74ys42l1pbJp5zPDp+kp75Mlph5dwXJ/bL
IG+GrgyOfBF9nmwJnowX4TWxZCeHZ1HiOnNQSr/ENkV1J3FW++B6nueIH7d+
XH3rC8uL74Lv18Mv1UGNw7sNfRN5O3UOgXpBvkAOP8eqWuWxA4fX/V55kI21
lbRhEmVUh1drU17gneRCx4oRQr4+TEvz8Pj62Z3tHcwD10jhzmZkpGB9Y2HH
5qbc2TBfi/qhkVF5NayLmliRLhtfmhEu6hum5q8lKweBX7mzfeOOF8HjTNbf
M1lwl85N8C0/sKL0PbuHg7HiJLA6J1XENgS76ZnwGVSfBL7n+x43dyvW9qfk
ezViefUF6x7WeITk0sTsA36ucjWm/8iGnzzRWZ+PeOV6Qb5ADrEqi9NWNw7Z
ht3S+H6upjZMoozqkFuT8i802J78yS9rVhnwdcE0j46vh7/wEzubYebHMHN+
Om7C3hxqCfNmRgrWN9C8oM4G+cL7oalRORrWRXV1CKEWjC/9CPGObXb+Gk1n
5fDCziYNcmiSw85JiqrMQr6aPZxVnvxQxw77pXvOu74vE76bc9OvI2CK4le1
bSct66bKxFbMipQ44fb53sf3ET7YIL1RIkVheY2ngzb7oGoqfoRE7VtsEWPD
OsZF3TbV2d1K9ztTFFYvzNejW3UO0SrXnPqdXzRNJh6+of6NLUwbJlHCXq7D
vo7FU2Y2fpzlWZamaTk5frZWhJgvUIfQ+PotnW0M9tXM87t2eZ4n/ErOMUiK
PK9VvvENMT+amZEC9g0oL7DKIIdIXkZHpTD9KkM6BFF301IU4gtcOQgzMxNh
/fClnW1mRZrub8+bsvb+9DjujMch8febm+19pSeYdVVy3N5B9mlSshlf3HJ/
yxKD+tv98QUqKCQv7qMIb8dw7HMpCVPWPbLxhNDIvRcpnTzB6oX5esxPnUO4
ysOtnYpWoHEKHdOGSZSwl+uQx/bZNK+6a0SI+YJ1CIyv39LZxj/wauYvffYF
pvgdJYD5jzhNjBSwbwB5wVXGOATyMjwqL0CVMR2i6r2ZjqJAX+DK4WJqJsL6
4Us72xNg17ZtN3P999mV7b6bx82hOKibeRfCd1eb52xlFJTXZWB5tXOJPWNj
FjSLwuqF+Xpua1d5EMwDb+WYtV+MwnSI+TKIAnUIjS/qbCugIOZBXyAK6htw
xwaqDHJorh+anB3+WNSP79j4yuEFnQ0DLvFIKEIRilCEIhShCEUoQj2iaEVK
KEIRilCEIhShCEWo96JoRUooQhGKUIQiFKEIRaj3omhFSihCEYpQhCIUoQhF
qPeiaEVKKEIRilCEIhShCEWo96JoRUooQhGKUIQiFKEIRaj3osjIyMjIyMjI
yMjebsBSdskamFCEIhShCEUoQhGKUIR6RNGKlFCEIhShCEUoQhGKUO9FPQV2
ZZ5XM0/lnwPWeXoOwygtpO8AkKO6Oo0Y6JwWktdRPfGlH+FQF/mHFdU0SLmv
vknjc3hmadVaEVZZHAZhnFVaKGFtkWVVK2FxDjW0VRLxIItGA6Xrq2+q/LNV
E3er5tVlMRcUw0j/3Jo6RKqMKgqLkBswKkEOhWnrEIkQ7QC6msfVC3YAQ+pd
MipNcYiNFHh8wZpHZj393muYjdE0x7JZzSMRorOe7ryMaX7JqMRWDggbYO99
1fiaA5bhcfzX6Ttw5z32sctf1WtvxQt7D2eV8dLm4fhi1fG/h7BQ84VF2Hn3
V/Vysycvp5WghjrePkS4dVXfTpv5uztsd9J4Jzuz1OM+LTdVRHVF8JhYMJnK
1vKVe/bms1ne19RWy2uohKA2luDwGEmG51o6RKuMKAqL8IJpHuTwaro6BCKE
OwCgeUy9oDYMqhcelcY4REcKhEI1D80pWO81yMbNtMayWc0jEV7QWQ+YlzHN
w6MSWzkAbIC995Xja04eVRw4By4PP1Mem13KwnRivp9qU4/FmyqMlzJg5Lti
D9YFex7sdKUuDRKJ8NL59mZ7yhmnwpRQQx3ZllOKD4vJwlbJa2Rj63M5pVyZ
23wytcyR35fhWJoRroBqhfaPJXfRhq4/vbaynq9h6K/c5SfG/1a9K+r6qmMu
4JBTP5yPTP2HqfTX0iFYZUhRWIQXSPMgh8L0tYFEiHYATPOIejFtmFQvOirN
cQiOFAgFax6aUzAOzbExmu5YNqp5KEKQeXBexjQPocAIETaw3vvS8TUnD2EF
A3saK9KMUXJMxOeH3FbtpV17u4Tbpq7ySgCK8NIwB34hv2L8nS8RYeIoRtjn
PvtlPBa4jjY8zq+wGV+1y4ps73bWxp5sqaSooT6LfcckrBf4evBaMDXvAtUr
WoCvjI0xy7tWV3B4KhQ4BHX4YepVBhW1KEI9zYMcik+j2tAdlUgHWKD5Ea+r
3qupa+M96tXJyyyHWO9FUAs0f9FVL8qhOTaELejzBjQPRYgxv2BeHr1CfUMH
hUWI6hDpvS8dX89o7Hlv1FrvnRjv1j4uqvTEFtzHajJ0niufZ7pxpmdWZlG6
EXaZuCuwO+z3jhcUjWRoz/nqmjpPQn4xfR9Mqy7ZfYT7jx3HUO6VlZ9zEjdR
VQdbyUV+KarLPLaTSooiOp1OQVS0qnkBvu5W8QT3pfI+HfAl9OBeq9sm0lqv
q0PdKqOKWjBSNDWPcrhAG9p940u0Sh0A1vxouuq96GvDvHovmnkZ5RAbKRAK
1jw3TfWCHBpk47JgLJvSvLlZD56XRwP6hi4Ki3DhWL7o9N6Xjq9VV6SX6nzY
3GwblIqo0YbqLISvs/vQjXAoHdvau6coCvb8CMR2epxhxhe/XTKa1N3MPsK/
Kak/2Rvbz79FjSQcI64LAVFioxO7Ks7e0dnxvOx4cvF9LV83q46b8f6RxNby
1ZeBaMCO7zvjQRdfrXugOtSuMqwofKRoah7jcJE20BWpVgfANH8zPfWODnW1
YVy9F928jHKIjRQIBTMvwJorUoxDg2wsGMuGNG9y1sPm5ZsBfUMbhUW4bCzr
9d6Xjq8nQWrPfcWJ/TLIm6ErgyPfzJ0n2/tZd23K90g7yUbsGWrB1Ri2trdk
J2yfVa1vIm+nmBff6dyvbF8qNse43+8jupM4TX5wPc9zxI9bP66+9TWqMbzu
wcqDTP9r+bqauFYflNKvAq/pqy0TzzkeHT9Jz7YSh8t0qFnlz7GqKmpRhPqa
1+dwmTawUanZASDN30xPvR+mqw3T6tXM6y0cctPvvboogPmrQStSkMNrrC9l
Y9lYNqF5k7MeNi/fDNO8JgqLcJEO9Vdfrxtfz2Q/5PyOfy4/mTAFFlxYzu3T
LT+UoPgt7Cblh2ptT/70gSfZaUbITxrffxTnh9WY7D/ExE92Ka46mEKs8TjY
pYn5PmIS5wTVJ4Hv+b7Hzd2KXfAp+X5sipMnN19sY2upfKcP9DVaFbFt3256
4voVvq5/gt+V2Jzr77siqkOkypii8JFyATT/YcocLqsXEKF+B4A0fzVN9V5Q
bTzgX65ebrp5meUQ670Y6sPUmb851FMvyqExNuCxbEzzJmc9bF6+mr7mERQW
IT6W4dXX6Hft8TUD7Ms8zxO+Wz8GSZHntcL3turYYb90z3nX92XCV+xu+jVL
CZN1LJ50sPHjLM+yNE3LyREI6XgBIuR3w2wnLeumysS2z4oUmIwYyjrGRd02
1dndSvc7kgjFCZDNPqiaih8H0/nW4YiXXq6fQdWc+p1fNE0mHrCgc9JY1xe3
z3cWVFG6voYmOeycpKjKLOS8H84qTyDBdIhVGVMUFiGmeYzDxz+gow0kQrQD
4JrXVS+mDZPqxfIyySE2UjAUqnlEvRiHJtl4MI2xbFLzWISgehfMy9isp40C
I0TYwHrvS8eXnMY+G59Fdje1079D4u/vkL2v9ASz3P/iSm0vBkXYVcnxA2af
Jq1eiurrbDyZIczyItWTXV0R3o7h2OdSIsmnY/P+oA8l1HCTlii37rcp9Xxd
xqrZ2IpUw9fAtm834q29P/2Kx4wvRIdYlTFFYRFimkc5/EhRQxtQhGAHWKB5
XfVi2jCp3tGAUWmMQ2ykYCiQeXDWQzg0ycbjH1Afy2Y1j0R4QdULz8vYrAeg
sAgBNrDe+9Lx9VQez2wWOPRd23aaV7ZBXxCKB9jNvDPgOarVRl0G5msWtjYb
g2Be720jqC9zKJbUrJ7W1iFWZUxRJkcKyCHkyyzKnOYxbZhU73P7KRxivVcf
ZVbzCIcm2XhuP0LzT21l9RqdlyEUGKG5sfyiKq+/IiUUoQhFKEIRilCEIhSh
dFC0IiUUoQhFKEIRilCEItR7UbQiJRShCEUoQhGKUIQi1HtRtCIlFKEIRShC
EYpQhCLUe1G0IiUUoQhFKEIRilCEItR7UbQiJRShCEUoQhGKUIQi1HtRZGRk
ZGRkZGRkZG83YCm7ZA1MKEIRilCEIhShCEUoQj2iaEVKKEIRilCEIhShCEWo
96K+A7ZFllWt5Mn8MuBQF/mHFdUUNkX1TZV/tqpReGv81bqSfX7mxQaroros
PodhxLjQ8jW0VRKdw3NUTJJ6GuFFi3mMwyXMY3nVecpJTAvpmx7W84Xo8MG0
NM+kUacsvPCcFpKX+j31hahXlw3zVcZQVRaHQRhnlfRff0C9wA6AaL5v0pgT
mBa1li8zisLHFzpSEEXho/KirSi0Xqb6IepLPy+826D10u8b+Oxgsh9i2sC6
KBQh1A8VFPV8RZp6/E2klpuqeey8+4twudmT15ZKULlnbz6b5X19Jas0yDI8
jp+fvol1ZdRQuSJGS2R3jCTllvrqiuAxr2AirifkazGPcQgzD+XVx4JEeyuc
Hs6KfQDyhejwblrMt3k4uhr/ewgLFdQFVS/Ahtkqg6jM391J3J003q5+MVMv
sAMgmh/qePsQ4dZVfa+9MUVh4wseKUCEsK/RtBSF1stkPzSnQ6zbwPWC+gY4
Oxjsh6A2sC6KRAj1Q0VFSYMcrS/D8QNbX7XWvr3ZnnLmXJjkb8pQw9BfP52f
WMhbRYVUceAceIp+ptGBAVQd81YflizC4XxkdB6mBZD5asXoPJa8wm3o+tPd
zhz5+sxjHGIoKK8uZSAn5jujNvWYKtPX+QJ1yE2X+TJgTcAV+70u2LN/d6c7
/PXUi7FhsMoLtDESnnL8Nn/ZSMHqBXYASPNDHdmWUwrRionJVhspJhWFjC90
pCARwqPyoq8osF4m+6FRHSLdBqwX2Dew2cF0P9TWBsgGEiHWDxUVNb8irV3m
yt7trI092ebMZNe4rB8W8ntG86h7xAXT5S7Q2s8WTPSezooUQGWsZpZ3/XQd
sQ+ciq9Uyvg/86E1Jf37CAHm714BDvVQYF5dxiR4TASLQ26rdkWMQ1iHAPNd
e7tJ2qau+vpBmJ4OFyhqxL+8yhiqz332y3ichMT48ibT2HvrhXUATPOP1ibO
j1QUNr4Q5tEI4VG5oPdq1ctkP3yDDnVnIqReaN9A1GuyH2L1wtjAIgT74YM9
UdQcMD/xK8BRVQdbyYV3uccuE3c7dof93vGCopEU/UmcVch2R/tS54rWpee1
016RaqI4/xv3+uk2kWKnqC5ju5ttUhTR6XQKoqJVZQNh/mYIh5ooNK+Gp2Xt
46JKT8zdsZrgVvOF6nAJ85erTpzp+Zi1dAgrajQDVcZQJQ/sdlVkKPfKK1Jj
9cI6AKb50bqmzpOQp7cPprPFmxW1rM9fdJhfqHktX5cFitKvl8F+aF6H6Ex0
0akX2Dcg9Zrsh1i9MDawCNF+KDx+pygpcKj4yvkYcV2c7I3tK562Kh3b2run
KAr2/KzAdnqgaV6N1XEzXkuX2HtXpH0ZCAk7vu+MRyB8lVqLPQsn/ujsOMyO
J7ciJHsWjPmrQRxqorC8uJvzYXOzbVC+0Bekw2XMX+F7ravTuusHlHlhJqqM
ocSO27+NqF6Q/zXO99YL6wAXSPPC+I3F0aTyeLOiFvV5PeaXaV7P1wJFIfUy
1w/N6xCcifTqhfUNTL0m++EFqhfGBhYh3A9VFCUDdidxAvXgep7niB+3flyp
ebxZm1iyM/azKHHtNyilXyx784qUWVsmnnM8On6Snvn2QOUaqah1eN0llgfZ
CJ2gljGPcaiJgvK69MWJe8mboSuDI8/sPNn4reXrk6nqcBnzbco3fTvJpu8Z
Clo/gGwYqTKG4rv7+z2gS3VQGl+m6wV0AEzzdxv6JvJ2eiiTihpNt89rMr8o
Qj1fS2c9rXqZ7Idv0CE2E2lqA+obXzyqqtdkP8TqhbEBjy+gH97tuaJkwD4J
fM/3PW7uVuwjTonK2Hw4JizO2arHWUVsU7WbnsV9jroMOT83lctPQayMEtbz
q9ybc63Qc3itreRKQOdbKt86hJnnhnGoi4LyuhS83Ts3xlt+VEgBhfmCdLiA
+Sblh/FtT/7UkvV0iLLBzUyVQVTxgGpi9gF/wsmPqNfoWLkDYJpnHj6qxE+R
6az3DCkK7fP6zOOa1/YFKwqpl8l+aF6HyEwEaAPpGxdMvSb7IagNiI0lc8r1
Lyj3Q0VFfbOJuAzSy79Sj/xKs+2kZd1UmVgCW5FSnNw+X3P+3he/cpznecJ3
E8cgKfK8VvpmGYIamuSwc5KiKrOQ71gOZ7Xne9QO3/H5RdNk4sEsmqd/NZgf
TZ9DDIXkVccc5J7zru/LhO/L3PRr71nL1xIdCtNgvq9j8cSNjR9neZalaVpO
juKsp15cUWaqDKLEqafNPqiaih+bUn2WxQf+1fXCOgCm+Yip1zrGRd021dnl
3qbXmt6rKGx8oSMFiRD1dTcNRWH1MtkPzeqQm263AesF9Q10djDXD0FtgF0U
iRDrh4qK+m5Fen9Uwvceuyo5jg+c4mafJjRKUaPl/pa1AI0Zs88+XAlTOtUM
oQa2fbs9wcza+9NjxnN5DbeBJqYJ3W9eaDA/mjaHKArKa0j8/Z32va/6lEXA
1xIdjn9AnXnO3mdTupKAqXeBokxVGUR1RXg7XmSfS0mY760X2gEQzfd1Np7o
Gr15kdqpP4OKwsYXOFKgCGFf9xTVFQXWy2A/NKpDYbrdBq4X0Dfg2cFgPwS1
gXVRIEKsHyoq6unAfGZzwKHv2m7mrSHfXQHW9WUS1bVt283ch3jma+g4Tvet
Us/sZ6CgvLg4Zllc19efqkOzisJ8Ydpg9WrnCvYTmAc7AKT5EWRKvT9/fP30
LgrWy2A//A06hFBQ30DVa7IfQtoAuygSIdYPv1XU6itSQhGKUIQiFKEIRShC
EUoLRStSQhGKUIQiFKEIRShCvRdFK1JCEYpQhCIUoQhFKEK9F0UrUkIRilCE
IhShCEUoQr0XRStSQhGKUIQiFKEIRShCvRdFK1JCEYpQhCIUoQhFKEK9F0VG
RkZGRkZGRkb2XgPWsWRkZGRkZGRkZGRkZGRkZGRkZGRkf4z9f5mS69A=
            "], {{0, 
            125}, {902, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{902, 125},
          PlotRange->{{0, 902}, {0, 125}}]], "ExerciseOutput",
         ImageSize->{906, 125},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cda40feb-b1b7-4051-8c8d-1e1b1c59f825"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfaGP886WZbRDBs6/sP+A8VLDQZFmNSxkRvsyGvI2erPSKGCIwUiGZmZB
RkZBRiZGJiYmJgYmJgYGJgYG2apykk63y+mqY6fS/ele6f3Ur7+cvveee+pW
lV2x/+e//t9/2v+PzWbzH3/P/vNP//Kf9t/+9i/H//0P7P/881//49//7a9/
+T//+Nf/95d/+8vf/te//h375X+x//03+4H/fCEjIyMjIyMjIyN7q23IyMjI
yMjIyMjI3m3wUpZQhCIUoQhFKEIRilCEWo6iFSmhCEUoQhGKUIQiFKHei6IV
KaEIRShCEYpQhCIUod6LegrsyjyvukHLY5XFYRDGWaWI6psq/2xV0yv60o9w
qIsHT0X11dN6eY1W5+k5DKO0mDp6ghraKonO4TkqJlSsGKFZ5rmZY6OrUwYJ
z2nRaEWo6wvnsG/SmDtKi1ojQjQvSL1dFvNyZVWr5UtYW2QMp6FeTBuIL4RD
031DmC6HYL2wCM30KPMok53NzAy7RL1YlbG8hGn3DYPjy2iVdVFLZnNTilJC
zQVZhsfxX91Uo79l/o5jLP6f3SlTQeWevflslvcVKPUFRdh51qMrO+telRfT
SOzy1OytSPBwVuwDXRE8hhhM5P87mTfHRpuHY5HH/x7CQi1CxBfG4VDH24cI
t24y7Tsr5oWod6hEuTaWQB0jSbOS+hot9Xh+lpuqoUBtAL5QDk32DSQvuF5Y
hMZ6lGGUyc5mbIaF1YtVGctrNM2+YXB8ma0ygIJnc4OKUkLNlayKA+fAS+Zn
ykx2KSNl6/OkUs7PNp+UTeZuGPqBGfspPzGPW8XxgkR46Xx7sz3l3OnV58vy
Eign5lfA2tRjJU+V8mqFso4ld9GGrj/dj/1K5g2yUQZsiLniymMX7Pmwnl4L
W415iMOhjmzLKYX8RKOzVdgA84K0Uce8JYY8xOF8ZH3kMF3izLWOvgzHxjI6
VYxQXxuIL1QbBvsGlBdYLzBCgz3KJMpoZzM5w0LqBfshNi9zw/qGmfFltMog
CprNjSpKCTVXMmEFS8xT5qTPffbLeGzxdbTh2K+kPHM3FGy22AWqV36ACC+X
xmVVLuRXwudQYF5dxgp8TERsQ26raXioz3yanH70FRF+eH098wbZYM7a282O
NnUV13uorzse4FBEmDiKEWJ5YdrIWHeyvGt1BepUKCqqdtmCyN7trI092aTL
UZA2QF8Qh0b7hvi0bl5YvbAITfYok6ibmehsmC80L0S9y/qh7rx8ATRvcnyZ
rPIylN5MZFJRiqhnqfW8CuqclOH+45rDUO4110UVh+9L1fU2EiHTlbhSvzvs
944XFI3E2Xp5NSemDGsfF1V6YqBjNfE2RXUZ239tk6KITqdTEBXtSyO8mgnm
DbLxaHym3jjTk5qr+wI47Jo6T0J+y2QfTPv+Wnlh2hB/371Wt02ktZZGmPMy
b6KqDraS20YzKEQbqK8PU+fQbN9A8sLqhUVoskeZRF3NSGfDfIF5Qepd1A+1
OUQ0b3J8mazyIpTmTGRSUYqoFVekYp/u3/LpT/bG9vPv47xaddyMV3SVfGER
Ms4d29q7pygK9vxIw3Z6TGPFvKrzYXOzbVCqRNiJPQtfpBydHY/Qjie3FX8l
8wbZuNtQncVyT2m3uMwXwCG/hTGalMa18sK00ZeBaB6O7zvj2R9f5eqZCOwY
8VWecKR6xRjQBuzrEa7Iocm+geWF1QuL0GSPMom6fdxEZ8N8gXlB6l3UDzXz
wjRvcnxdDFZ5EUpzJjKpKEXUk6aN7ODud44uFaufq3ZdhZu4YhyU0i+xrb+P
4NYmluzk8Fp59cWJZ5Q3Q1cGR745OE+2VXN9ILzucMqDTF2/kXmTbFytTflO
eCe5/Li+L4xDNkb7JvJ2imxcTTMvWBttmXjO8ej4SXq2lVDdSXxf6+B6nueI
H7d+XH3rC9IG6OuWmx6Hn7Ev7Rt4Xvr1ArVhskeZRF3NSGfDfC3KazRl9S7q
h3p5gZo3Ob5MVnkRSnMmMqkoRdQz4JDzkwy5/CSJrGpMw9Z41OLSxOwD/gQ7
566K2NJ+Nz1V+xylGyE/Unv/UZzpVVtbInkVXPrO7XMtP7Km8N03ca7j5uvS
+ZbSN+Z+PvMm2eDWpPxrK7Ynf77Pur4QDvuPz/JTScojGshrgTauf4Hfv9uc
6287cJ8Evuf7Hjd3K3bBp+T7bg9pA/TFTZ9Dg31jQV73P6FaL1AbJnuUSdTV
jHQ2zBeaF6TeBf1QMy9Q8ybHl8kqL0HpzkQmFaWImkmtL/M8T/i+4BgkRZ7X
Kt/AEucQNvugaip+1ELn+7mfrx6roJAI+XV320nLuqkycWnKihT6NpZXHTvs
l+457/q+TPh+002/zoGyvGoO2/lF02TiERBK3yj58cybZKOvY/E8i40fZ3mW
pWlaTg5Brca8MF0OI6ZD6xgXddtUZ3cr3dWulhekjaFJDjsnKaoyC3l8h7PK
86ke/4D0BpAUhWoD8YVxaLJvYHmB9QIjNNijTKKMdjZzMyyoXrAfQnk9ZKiu
eZPjy2iVF3CoPZsbVJQiSp5an43PS7yb4pnhrghvh+PscykhZo7J3N8ycWgw
CUXYVcnxA2afJqJaNa8h8fd3Z3tf6ZmTF/Gwyt0NdQzUnxD4o5k3yQbP6LMp
XoHEmL/oc9jX2Xg2S5jlRUqnkuC8AG0MTbq/BWjt/ekx/jlfd5+3B32ooEBt
AL4wDs32DSQvuF5YhCZ7lDmUyc5mcIaF1YtUGc3rHqxO3zA3voxWeQGH2rO5
QUUpop6W7JnNAoeu/XjCijIK8wWhhp7FNxfg2nlxZ22ne0+cO2Mozbc8/Hjm
jbLx1H6Cr5EMbR1CvjBtsPhmq/VTtAH5glBG+8ZTW7leYIQGe5RJ1FP7EeqF
8gLVa7T3Qqg/tcomUQYV9S1q/RUpoQhFKEIRilCEIhShCKWDohUpoQhFKEIR
ilCEIhSh3ouiFSmhCEUoQhGKUIQiFKHei6IVKaEIRShCEYpQhCIUod6LohUp
oQhFKEIRilCEIhSh3ouiFSmhCEUoQhGKUIQiFKHeiyIjIyMjIyMjIyN7uwFL
2SVrYEIRilCEIhShCEUoQhHqEUUrUkIRilCEIhShCEUoQr0XNQvsmzQ+h+co
LWoNjxjqchnaKok4sGgkb0SYQ1VZHAZhnFWKvvqmyj9bNXH3lMm2yLKq1YgQ
QelziOY11MUDpqimIa7F/Bglpo06T89hyGDSd2WsiTLHPDdTHOJVvly6kmU0
84aN9fIyHSGC6uqUNajwnBaSl9899XXR7xtdFnPxMoyGL7O91xyHfy7zkHqh
CH9DPzTX57npMo/3KGh8AVXGI9Tn8IW+pMChjscXkI6vSt66Sm9xxVAX/mbV
YPNgwSRYKSrzd3dnu5PaG889e/PZLO8r8El/Sz2en+WmKr4wFMYhmlfnWY8g
e/L63NWYR7XRxy5Pzd6KBA9nNeUjKLPMm+QQrHIZHkfA9M3v6+ZlOEIA1eah
9cD8ISwUfY2m1zeGSoh3Ywlnx0iysF9PG2DvNcbhH8w8ol4owt/QD831+QvY
N8AehYwvsMpYhBiHL/QlpXGoI9tySiFB8UfsVMEjhmJdR6j4WPL42tD1p6tn
CapLGWjrc7WnHL/NVVCXYegHZuyn/MQG3FZRV8z6MhzpGp2+CIVyiOXV+fZm
e8o5/IpWQEHMg3kJX07Md+ht6rEx+jqUUeZNcohV+XKp4sA58EnJz5T7Njgq
DUYIocqALbNdcZ2oC/Z8KpterVurA9Qxny5DXubhfGR9/zCdkN7cew1y+Ocy
j3CIRfhb+qGZPn8B+wbWo5DxBVZ5wWyuz+ELfc0N57u1iaM+ygDUUJ95o5l+
9Cmqz332y3hsT3XEfvYm0n8W4VCwTrcL1HfctcukYe921saebPrWRl0NYV4v
r8Zlo7KQ37mYQy1lXiuvLmMaPiaibwy5rdqpIBQW4d10mDfKIVTlmxVbHptq
30bzMhchiura2w2+NnV1tKHdATI2h1neNTLB4al4lTaw3nszMxz+mczfTI9D
MMIf3w/f0ed11Yv0KGx8oTqEuijI4Qt9PRFV19R5EvKbcPtgyukcUBfVZWy1
vE2KIjqdTkFUtJI0JXvncP+xXx7KveacXnH4vlS+GpOfeEJRVQdbyW2IdVEX
lPmLbl5dJu5p7Q77veMFRfNy5vXzajiF1j4uqvTEXB2rSYzrobAIr6bFvFEO
oSpfrec9RL1vg3kZjHARShifLzbO9FzdWh1A/H33GlmbSON8b++9mikOMdQP
Z/5qmhyiEf70fmi+z2urF+pR2PgCqwx2UYjDV/qaFxW/MDuatHAzQG1UJ66r
cMkfnR0/nGDHkxszM/sI/zZG+pO9sf1cLUJm1XEzXnOWmGSnU/GdzjHivVA4
Utr3YShhGPMX3bzYmsGxrb17iqJgz5nfTo/VrMo8kld1Pmxutg3Kl6KMMW+U
Q6jKt9D0Z0wgL4MRLkLdBvVe7coP1gH6MhDN3vF9Zzyr5avuVgz13lugJjjE
UD+f+ZtLPQ7hCH94P4QjRPPSVy/Uo7DxBVYZ7aIIh6/09aQJcM99E3l8h3Se
LGefdQ8d1Fi18LqbKg8yJU9R/GrM/cr2pWIoV3k/O14JD0rpl72mqO4kTngf
XM/zHPHj1o+r16A+DGFeL6/P1iaW7KT3ysxr5tUXJ55R3gxdGRy3L0VhEV5N
k3mTHH4y5SpfDbhGuiAvAxEuQrUpJ30nuVgkQ+EdoC0TzzkeHT9Jz/YrtYH1
3quZ4BBD/QLmr6bPIRDhz++Hb+jzC67wq/coeHwt0aFWhAu18QpfM+76DzHx
O/6KcwSCEmfPrOT6wc63lL6d1xcPqCZmH/Bz1fueVcQ2cLvpdy5mUH0S+J7v
e9zcrdgRnJJv+xuGuqDMA3lxBx+CEKeO1fobxjySV8GnFuf211t+jExBGxjK
JPMmOcSqfPfCT1tNYptDoXmZixBHNSn/Yo3tyZ9AtGYHePgT/K7f5lyrzBHm
eu/dy+s5xFC/gPn75xH1akb48/uh2T4vTJt5aK5cMr7Gv6ChQyRClMMX+pIS
ErHVvHWMi7ptqrO7le53pkAMxTZUDt//+kXTZOKxDErneMUptc0+qJqKH0lQ
/T4at8/3FlVRo1fpjcgVUSiH3HTz4lfQbSct66bKxCbYilSUDzGP5VXHXBru
Oe/6vkz4ftNNv85La6FMMm+SQ7DKl77M8zzhu9pjkBR5Xqt8CxvKy2iEEKqv
Y/FMq40fZ3mWpWlaTo6ErdUBhiY57JykqMos5DU+nFWeumO09xrk8M9lHuEQ
i/Dn90OTfR5jHu1RyPjCqoxFiHH4Ul9SUfV1Np57EGZ5kdLpAgx1EY8+291g
x0D1G0BdEd4OudjnUiL/ufGS+1vWpKAV6f2hB69CwRxe9PPqquS4vbna2KeJ
POZ8AcyjeQ2Jv7+HuPcVn/WHoEwyfzHIIVjlPvsACVP87hWQl9EIIRSv72fT
uA4mUlTvAEOT7m9Ftvb+9PC/FGW09xrk8I9lHuIQi/A39ENzfR5jHp4rgfGF
VRmNEOHwpb7mRMXxfde2M281mFcjhmI4Dus1373CQN2ssyepPbGfgEI5RH11
+r4g5sG8RpjGaQQcZZJ5kxyCVX5q6+dlLMIfj2I1ntXuD+m9T+33oswy/8zW
jfA39ENzff65rd2jkPGF6xCZzVFtvMAXVrJnHglFKEIRilCEIhShCEUoHRSt
SAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShCEYpQhCIU
oQj1XhStSAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UGRkZGRkZ
GRkZ2dsNWMouWQMTilCEIhShCEUoQhGKUI8oWpESilCEIhShCEUoQhHqvain
wK7M82rmqfxyYFen0TkMz2khebGUFNU3Vf7Zqkbl/blDXTxgimr6EoCZ1Los
ZhFGWfX1bXRPUaO1RcZwkvcNzKGGtkoYIeeomCQlRaFsIMyPMJQNPW2YrTKq
jb5JY16stKgV87qZ/ki52ssVNVqdp7zMaSF9V8Z6ioJH5QXjUDcvfHyhEQrT
qjLKIdgBAG3gVYbUC/UojI3f0AGqLA6DMM6ql/tC2DA9LyOd7WovH5VYtzE5
Vy7rh5dXzF9zwDI8jv86fY/wnMc2D8fXsY7/PYSFCir3bu/BvpnlfX39qyzI
zrMeQfbk5bQy1FC5wpslsMdIMqif8J96/GWulpsqoroieAwxmAyatdjAmIfZ
ALRhtMoQaqjj7QOHW1fx3coIG3czoCjWdWJRZnsrSnA4q3QqUFFgvTAOkbxQ
HZqsMsIhWi+EQ7jKiHqhHoWx8Ss6QObv7iHuTkrvScd8oWyYnJcx9V7NwKjE
uo3JuRLuh6O9Yv6ac1fFgXPg7vxMdZSVARssrthNdcGeD9Dp7lTmbhj6gRn7
KT8xj1vFVYdvb7annMOv6O9RdcxbR1iyTw/nI6vfYSr9OUL6Mhzp2vqKfaAV
1T6WnPU2dP3pLm4tNjDmYTYAbZisMoYa6si2nFJ8WDQ6O1WbZyE2uBlSVJcy
kBNzdbSpx/qHSl7oWMbqBXEI5YXq0GSVEQ7BeoEcYlVG1Iv1KIyNX9ABRL3G
D6eczW2uNKcgvlA2DM7LoHq5mRmVaLcxOVeC/fDysvnryQL4cilYiJ7GKOva
222LNnXVR/TVhoL1kV2guLtvmAO/kN8lmUNljBHLu+ZTR+wDp+JriDMR1i4b
KPZuZ23sySZCihrqM2+FUwq+9zXitdhAmF/AxkVfGzd7fZVR1Ie1iaOpXoAN
U4rqMtYGjomIbcht5VUHNJaXMK/JIZjXzfR0CEXITbvKKIdQvUAOkQgx9aI9
atlM9FM7QJ/77JfxuLwWbHiTBcR6OvwwHTYMzst4BzA2Km+GdBszcyUc4avm
r2dB9rziyKpj1NjGmZ4+eYKqQrab3ZeKa/suE9eLd4f93vGCopHA5MrfuNd8
2kSanTTC/MTvlURVHWwll7WlqC5ju7ZtUhTR6XQKoqJVivBuemw8mDrzMBvc
UG0YqDKIGqFNnSchL/Y+mI6cFdkwqKiGu7L2cVGlJ0b+sZrgVhvLC5jX53BR
Xsj4MlLlRRwK0+m9EIdQhJh6F/Woj7+gMRP95A5QctHervcO5V55RYroUJg2
G0bnZbADmB+V2GxuYq5EI3zd/PWKFelQnYWEtXYE1XEzXnNW8zWUjm3t3VMU
BXt+fGI7PcIj2WOWgSia4/vOeObCVxjRYzrHiHe1k72xfaW8OrGf5TwcnR13
ZseTW0ersfE5VEXmMTZuYEwbJqoMorjxGx+jSVNbiw3DiqrOh83NtkGpkZfu
WMaZRxS1IC9ofBmp8iIO9XsvwiEUIabeRT0KmYl+dAcQ1xL9W/69AH7V8Go6
5KbPhsF5+QKp9x2jEpvNjcyVkK+Xzl9PhjO46mhTvnreSbZUz1DiWn1QSr8w
980umO2qLNmpcimqLRPPOR4dP0nPfGP2/V6sO4kT3gfX8zxH/Lj14+pbXyP/
4XXXUR5kFV+ZDX3m9dm4GaYNU1Veghr6JvI4kefJlnslNowqqi9OnPO8Gboy
OG718sLG8hWrybymohblhenQSJU/mS6HmvVaxKFmhHA/xHsUqt4f2wH4NdL7
3e1LdXjl/HU3hI3RXjsvY+p9x6jEuo3JuVLP12vnr2epDTk/G5PL7/vLgU3K
D5LbnvyJG/OcVBFbpO+m57TnUQ9Hd8UJZ41OJazn15A35/pbDfdJ4Hu+73Fz
t2L3cUq+51+c+bGSa1Cdb2l8i02fDZz5a7SqbNwM0Ia5KmOo/iMufipJZ0Tr
sWFUUQVvH84tspYfqlPUIaKoBaNSU1F4Xtj40o4QrDLOoX69UA6RCJf0w+tf
0OpRiHp/fAcoHjhsYvYBf+JxPR1ibBiblzH1Gh+VaLcxuSLS9PXa+WsmyL7M
8zzhe5BjkBR5Xit8p6+vY/Fkio0fZ3mWpWlaTo4KzHHy+X7E97741XrbScu6
qTKxgbMiBQ0PTXLYOUlRlVnI1/aHs+LzPe5/QHqjZAZVO3yH7hdNk4nHg6h/
b0iXDYx5lA1EG1heWJUxVMRQ1jEu6rapzu5Wumdclw1hL1dUHXOQe867vi8T
vkt106+z9FqKwpjHOMTyGk1XhyarjHGI1QvjEK0yol6sR2Fs/IIOIM6ObvZB
1VT84KTOs2J0fWFsmJyXl3SA0e2rR+Vo+t0GQZmPUNj685fcXZ+NzyK7m8oJ
6tz/AtLYY3KsrcFJVyXHD2/2aSJFKWpgG+fbM7usvT89CP0kwtHt7QELSqjh
1hhFs9I4T67LBsY8yAakDSwvrMoYqq+z8XTLyIcXqZ2pW8DGGOzrFTUk/v4e
3t5Xeq4gpiiMeZRDJK+P7HR0aLLKGIdo70U4BKsMqRfrURgbv6IDdEV4O9pp
n0uJhNfyhbFhdl7GO8AY7KtH5Wja3QZCmY9wdLv6/PXU3TPDgOuihr5ru5n3
ZMyjurZtu5kr1OvnNXTcG/AuD8AXgjLLBoLCqoyjWm3Uc/sRihoT071P/dTW
ZR7zZTIvk6ifzyEaIaJekz3qF3QARmE3G+JPYMPovPyndjYI9fMj/LYD/OoV
KaEIRShCEYpQhCIUof4AFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShCEYpQhCIU
oQj1XhStSAlFKEIRilCEIhShCPVeFK1ICUUoQhGKUIQiFKEI9V4UrUgJRShC
EYpQhCIUoQj1XhQZGRkZGRkZGRnZ2w1Yyi5ZAxOKUIQiFKEIRShCEYpQjyha
kRKKUIQiFKEIRShCEeq9qHlgl8XnMIyy6uv71557rPOUw9JC+hYFGWqoi/zD
imoKnKL6pso/W9WovIP4bm2RscwkMa6XF7cqi8MgjLNK+q9yVN+kjPkzc1Vr
oLB6gb5G0+IQqfIV2VZJxIMsJiWWojBtmEQ9mBEddnXKCAzPaSF5tdzKEWK+
UB0i4+tnd7YHM8K8QJZMtzNvelmLefMjRbdvjKavKLzKkHqhvEyNymVVRnSI
oi6AojBfun3D+EwE9MMXdjY5cKhc8fZcS7xt9hhJhowM2McCZm8F+HBWi7Pz
7q/P5WZPXgssQeWevflslvf1NalPOEk9/gpYy01fmdcl88VLXEV2u5Pae5zr
eHw57UjJ1lV7Vy9UL9DXzTQ5RKrMYUXwCAsmw3otbZhE3c2ADts8tB6qfAgL
NV9IhJgvWIfA+Pr5ne1uBphnVobHMbjpm9+foADmzY4UpG9gecFVhnwheZkc
lXCVMR1iqNF0FQX5QvqG0ZkI7Icv7GxSYB1z8sOSaXA4H5nvwzRQCbBLWXJO
zPdTbeoxn6lSnJ1vb7annPkSJklBhhqG/vrp/MQS3Kpz0pfhmPjWV+sDWF4C
NbpIuVq2+USOsj4Q2ZZTChKEmG0VX1i9MF+jaXMIVrkV4+xYcura0PWn+8z1
tGESxc2MDsuATXyuuMbRBXveUKdXSdaKEPMF6hAaX7+hs3EzwzyzKg6cA58g
/Ex5noWYNzpSsL4B5gVVGfSF5GV0VKJVRnSIoi6IovCRot83zM1EYD98ZWeT
AjOme8u78l5H7DOn4mt6Mv4zxv8xEbght1X5b1xW5UJ+JXwedbOhYONtF6hf
+aldRry921kbe7KJkKOgvPrcZ7+Mx8EvOPQmEnmWF9Nw4ij2AbBekK/RhzaH
UJWH+swb6DSs7yMc8braMIkypEMGa2+3mdrUfXGVYV9XU9chNr5+SWczzHyx
5eypzrNLO9vrRwrWN9C8kCpjvtB+aG5UPsQKdFE9HS5AAeML8gX2jZu9fiZC
Vw4v7GyzK9KNe42zTWxZFaRxnhgX1j4uqvTENmPHahKytGriGu7usN87XlA0
kjSf8F+FzNG+VF6l5zzETVTVwVZyWXsGheRV8sBuu9Gh3Ov07a6p8yTkge6D
afeR6wqpF+LrgnEIVbnL2L5ymxRFdDqdgqhoX6sNkyhjOnw0oRNneiZsvQhB
Xxd9HWLj61d0NsPMX/pMysMcaklnuxgZKVjfAPOCqoz5WtgPL68flXdDuqim
DmEUPr60fS3q2AZmIrAfvrKzSYF9GQiHju8743kBX63nVOfD5mbboFSKcygd
29q7pygK9tzZdnpMY57/6rgZrx5LTLLHrPge8xjxEXmyN7avuvsA8hK7D//G
Wi/cfY1zJi9+SXw0qfglO260XoAvkEOoyp24ksDb4dHZcZQdT244raUNkyiT
OvzidK+2d4YjBHwJ09YhNr5+fmczzrz2PLugs13MjBSsb4B5QVXGfC3rhyZG
5c2gLmpkRbpofOlHuKBjm5iJwH74ys42l1pbJp5zPDp+kp75Mlph5dwXJ/bL
IG+GrgyOfBF9nmwJnowX4TWxZCeHZ1HiOnNQSr/ENkV1J3FW++B6nueIH7d+
XH3rC8uL74Lv18Mv1UGNw7sNfRN5O3UOgXpBvkAOP8eqWuWxA4fX/V55kI21
lbRhEmVUh1drU17gneRCx4oRQr4+TEvz8Pj62Z3tHcwD10jhzmZkpGB9Y2HH
5qbc2TBfi/qhkVF5NayLmliRLhtfmhEu6hum5q8lKweBX7mzfeOOF8HjTNbf
M1lwl85N8C0/sKL0PbuHg7HiJLA6J1XENgS76ZnwGVSfBL7n+x43dyvW9qfk
ezViefUF6x7WeITk0sTsA36ucjWm/8iGnzzRWZ+PeOV6Qb5ADrEqi9NWNw7Z
ht3S+H6upjZMoozqkFuT8i802J78yS9rVhnwdcE0j46vh7/wEzubYebHMHN+
Om7C3hxqCfNmRgrWN9C8oM4G+cL7oalRORrWRXV1CKEWjC/9CPGObXb+Gk1n
5fDCziYNcmiSw85JiqrMQr6aPZxVnvxQxw77pXvOu74vE76bc9OvI2CK4le1
bSct66bKxFbMipQ44fb53sf3ET7YIL1RIkVheY2ngzb7oGoqfoRE7VtsEWPD
OsZF3TbV2d1K9ztTFFYvzNejW3UO0SrXnPqdXzRNJh6+of6NLUwbJlHCXq7D
vo7FU2Y2fpzlWZamaTk5frZWhJgvUIfQ+PotnW0M9tXM87t2eZ4n/ErOMUiK
PK9VvvENMT+amZEC9g0oL7DKIIdIXkZHpTD9KkM6BFF301IU4gtcOQgzMxNh
/fClnW1mRZrub8+bsvb+9DjujMch8febm+19pSeYdVVy3N5B9mlSshlf3HJ/
yxKD+tv98QUqKCQv7qMIb8dw7HMpCVPWPbLxhNDIvRcpnTzB6oX5esxPnUO4
ysOtnYpWoHEKHdOGSZSwl+uQx/bZNK+6a0SI+YJ1CIyv39LZxj/wauYvffYF
pvgdJYD5jzhNjBSwbwB5wVXGOATyMjwqL0CVMR2i6r2ZjqJAX+DK4WJqJsL6
4Us72xNg17ZtN3P999mV7b6bx82hOKibeRfCd1eb52xlFJTXZWB5tXOJPWNj
FjSLwuqF+Xpua1d5EMwDb+WYtV+MwnSI+TKIAnUIjS/qbCugIOZBXyAK6htw
xwaqDHJorh+anB3+WNSP79j4yuEFnQ0DLvFIKEIRilCEIhShCEUoQj2iaEVK
KEIRilCEIhShCEWo96JoRUooQhGKUIQiFKEIRaj3omhFSihCEYpQhCIUoQhF
qPeiaEVKKEIRilCEIhShCEWo96JoRUooQhGKUIQiFKEIRaj3osjIyMjIyMjI
yMjebsBSdskamFCEIhShCEUoQhGKUIR6RNGKlFCEIhShCEUoQhGKUO9FPQV2
ZZ5XM0/lnwPWeXoOwygtpO8AkKO6Oo0Y6JwWktdRPfGlH+FQF/mHFdU0SLmv
vknjc3hmadVaEVZZHAZhnFVaKGFtkWVVK2FxDjW0VRLxIItGA6Xrq2+q/LNV
E3er5tVlMRcUw0j/3Jo6RKqMKgqLkBswKkEOhWnrEIkQ7QC6msfVC3YAQ+pd
MipNcYiNFHh8wZpHZj393muYjdE0x7JZzSMRorOe7ryMaX7JqMRWDggbYO99
1fiaA5bhcfzX6Ttw5z32sctf1WtvxQt7D2eV8dLm4fhi1fG/h7BQ84VF2Hn3
V/Vysycvp5WghjrePkS4dVXfTpv5uztsd9J4Jzuz1OM+LTdVRHVF8JhYMJnK
1vKVe/bms1ne19RWy2uohKA2luDwGEmG51o6RKuMKAqL8IJpHuTwaro6BCKE
OwCgeUy9oDYMqhcelcY4REcKhEI1D80pWO81yMbNtMayWc0jEV7QWQ+YlzHN
w6MSWzkAbIC995Xja04eVRw4By4PP1Mem13KwnRivp9qU4/FmyqMlzJg5Lti
D9YFex7sdKUuDRKJ8NL59mZ7yhmnwpRQQx3ZllOKD4vJwlbJa2Rj63M5pVyZ
23wytcyR35fhWJoRroBqhfaPJXfRhq4/vbaynq9h6K/c5SfG/1a9K+r6qmMu
4JBTP5yPTP2HqfTX0iFYZUhRWIQXSPMgh8L0tYFEiHYATPOIejFtmFQvOirN
cQiOFAgFax6aUzAOzbExmu5YNqp5KEKQeXBexjQPocAIETaw3vvS8TUnD2EF
A3saK9KMUXJMxOeH3FbtpV17u4Tbpq7ySgCK8NIwB34hv2L8nS8RYeIoRtjn
PvtlPBa4jjY8zq+wGV+1y4ps73bWxp5sqaSooT6LfcckrBf4evBaMDXvAtUr
WoCvjI0xy7tWV3B4KhQ4BHX4YepVBhW1KEI9zYMcik+j2tAdlUgHWKD5Ea+r
3qupa+M96tXJyyyHWO9FUAs0f9FVL8qhOTaELejzBjQPRYgxv2BeHr1CfUMH
hUWI6hDpvS8dX89o7Hlv1FrvnRjv1j4uqvTEFtzHajJ0niufZ7pxpmdWZlG6
EXaZuCuwO+z3jhcUjWRoz/nqmjpPQn4xfR9Mqy7ZfYT7jx3HUO6VlZ9zEjdR
VQdbyUV+KarLPLaTSooiOp1OQVS0qnkBvu5W8QT3pfI+HfAl9OBeq9sm0lqv
q0PdKqOKWjBSNDWPcrhAG9p940u0Sh0A1vxouuq96GvDvHovmnkZ5RAbKRAK
1jw3TfWCHBpk47JgLJvSvLlZD56XRwP6hi4Ki3DhWL7o9N6Xjq9VV6SX6nzY
3GwblIqo0YbqLISvs/vQjXAoHdvau6coCvb8CMR2epxhxhe/XTKa1N3MPsK/
Kak/2Rvbz79FjSQcI64LAVFioxO7Ks7e0dnxvOx4cvF9LV83q46b8f6RxNby
1ZeBaMCO7zvjQRdfrXugOtSuMqwofKRoah7jcJE20BWpVgfANH8zPfWODnW1
YVy9F928jHKIjRQIBTMvwJorUoxDg2wsGMuGNG9y1sPm5ZsBfUMbhUW4bCzr
9d6Xjq8nQWrPfcWJ/TLIm6ErgyPfzJ0n2/tZd23K90g7yUbsGWrB1Ri2trdk
J2yfVa1vIm+nmBff6dyvbF8qNse43+8jupM4TX5wPc9zxI9bP66+9TWqMbzu
wcqDTP9r+bqauFYflNKvAq/pqy0TzzkeHT9Jz7YSh8t0qFnlz7GqKmpRhPqa
1+dwmTawUanZASDN30xPvR+mqw3T6tXM6y0cctPvvboogPmrQStSkMNrrC9l
Y9lYNqF5k7MeNi/fDNO8JgqLcJEO9Vdfrxtfz2Q/5PyOfy4/mTAFFlxYzu3T
LT+UoPgt7Cblh2ptT/70gSfZaUbITxrffxTnh9WY7D/ExE92Ka46mEKs8TjY
pYn5PmIS5wTVJ4Hv+b7Hzd2KXfAp+X5sipMnN19sY2upfKcP9DVaFbFt3256
4voVvq5/gt+V2Jzr77siqkOkypii8JFyATT/YcocLqsXEKF+B4A0fzVN9V5Q
bTzgX65ebrp5meUQ670Y6sPUmb851FMvyqExNuCxbEzzJmc9bF6+mr7mERQW
IT6W4dXX6Hft8TUD7Ms8zxO+Wz8GSZHntcL3turYYb90z3nX92XCV+xu+jVL
CZN1LJ50sPHjLM+yNE3LyREI6XgBIuR3w2wnLeumysS2z4oUmIwYyjrGRd02
1dndSvc7kgjFCZDNPqiaih8H0/nW4YiXXq6fQdWc+p1fNE0mHrCgc9JY1xe3
z3cWVFG6voYmOeycpKjKLOS8H84qTyDBdIhVGVMUFiGmeYzDxz+gow0kQrQD
4JrXVS+mDZPqxfIyySE2UjAUqnlEvRiHJtl4MI2xbFLzWISgehfMy9isp40C
I0TYwHrvS8eXnMY+G59Fdje1079D4u/vkL2v9ASz3P/iSm0vBkXYVcnxA2af
Jq1eiurrbDyZIczyItWTXV0R3o7h2OdSIsmnY/P+oA8l1HCTlii37rcp9Xxd
xqrZ2IpUw9fAtm834q29P/2Kx4wvRIdYlTFFYRFimkc5/EhRQxtQhGAHWKB5
XfVi2jCp3tGAUWmMQ2ykYCiQeXDWQzg0ycbjH1Afy2Y1j0R4QdULz8vYrAeg
sAgBNrDe+9Lx9VQez2wWOPRd23aaV7ZBXxCKB9jNvDPgOarVRl0G5msWtjYb
g2Be720jqC9zKJbUrJ7W1iFWZUxRJkcKyCHkyyzKnOYxbZhU73P7KRxivVcf
ZVbzCIcm2XhuP0LzT21l9RqdlyEUGKG5sfyiKq+/IiUUoQhFKEIRilCEIhSh
dFC0IiUUoQhFKEIRilCEItR7UbQiJRShCEUoQhGKUIQi1HtRtCIlFKEIRShC
EYpQhCLUe1G0IiUUoQhFKEIRilCEItR7UbQiJRShCEUoQhGKUIQi1HtRZGRk
ZGRkZGRkZG83YCm7ZA1MKEIRilCEIhShCEUoQj2iaEVKKEIRilCEIhShCEWo
96K+A7ZFllWt5Mn8MuBQF/mHFdUUNkX1TZV/tqpReGv81bqSfX7mxQaroros
PodhxLjQ8jW0VRKdw3NUTJJ6GuFFi3mMwyXMY3nVecpJTAvpmx7W84Xo8MG0
NM+kUacsvPCcFpKX+j31hahXlw3zVcZQVRaHQRhnlfRff0C9wA6AaL5v0pgT
mBa1li8zisLHFzpSEEXho/KirSi0Xqb6IepLPy+826D10u8b+Oxgsh9i2sC6
KBQh1A8VFPV8RZp6/E2klpuqeey8+4twudmT15ZKULlnbz6b5X19Jas0yDI8
jp+fvol1ZdRQuSJGS2R3jCTllvrqiuAxr2AirifkazGPcQgzD+XVx4JEeyuc
Hs6KfQDyhejwblrMt3k4uhr/ewgLFdQFVS/Ahtkqg6jM391J3J003q5+MVMv
sAMgmh/qePsQ4dZVfa+9MUVh4wseKUCEsK/RtBSF1stkPzSnQ6zbwPWC+gY4
Oxjsh6A2sC6KRAj1Q0VFSYMcrS/D8QNbX7XWvr3ZnnLmXJjkb8pQw9BfP52f
WMhbRYVUceAceIp+ptGBAVQd81YflizC4XxkdB6mBZD5asXoPJa8wm3o+tPd
zhz5+sxjHGIoKK8uZSAn5jujNvWYKtPX+QJ1yE2X+TJgTcAV+70u2LN/d6c7
/PXUi7FhsMoLtDESnnL8Nn/ZSMHqBXYASPNDHdmWUwrRionJVhspJhWFjC90
pCARwqPyoq8osF4m+6FRHSLdBqwX2Dew2cF0P9TWBsgGEiHWDxUVNb8irV3m
yt7trI092ebMZNe4rB8W8ntG86h7xAXT5S7Q2s8WTPSezooUQGWsZpZ3/XQd
sQ+ciq9Uyvg/86E1Jf37CAHm714BDvVQYF5dxiR4TASLQ26rdkWMQ1iHAPNd
e7tJ2qau+vpBmJ4OFyhqxL+8yhiqz332y3ichMT48ibT2HvrhXUATPOP1ibO
j1QUNr4Q5tEI4VG5oPdq1ctkP3yDDnVnIqReaN9A1GuyH2L1wtjAIgT74YM9
UdQcMD/xK8BRVQdbyYV3uccuE3c7dof93vGCopEU/UmcVch2R/tS54rWpee1
016RaqI4/xv3+uk2kWKnqC5ju5ttUhTR6XQKoqJVZQNh/mYIh5ooNK+Gp2Xt
46JKT8zdsZrgVvOF6nAJ85erTpzp+Zi1dAgrajQDVcZQJQ/sdlVkKPfKK1Jj
9cI6AKb50bqmzpOQp7cPprPFmxW1rM9fdJhfqHktX5cFitKvl8F+aF6H6Ex0
0akX2Dcg9Zrsh1i9MDawCNF+KDx+pygpcKj4yvkYcV2c7I3tK562Kh3b2run
KAr2/KzAdnqgaV6N1XEzXkuX2HtXpH0ZCAk7vu+MRyB8lVqLPQsn/ujsOMyO
J7ciJHsWjPmrQRxqorC8uJvzYXOzbVC+0Bekw2XMX+F7ravTuusHlHlhJqqM
ocSO27+NqF6Q/zXO99YL6wAXSPPC+I3F0aTyeLOiFvV5PeaXaV7P1wJFIfUy
1w/N6xCcifTqhfUNTL0m++EFqhfGBhYh3A9VFCUDdidxAvXgep7niB+3flyp
ebxZm1iyM/azKHHtNyilXyx784qUWVsmnnM8On6Snvn2QOUaqah1eN0llgfZ
CJ2gljGPcaiJgvK69MWJe8mboSuDI8/sPNn4reXrk6nqcBnzbco3fTvJpu8Z
Clo/gGwYqTKG4rv7+z2gS3VQGl+m6wV0AEzzdxv6JvJ2eiiTihpNt89rMr8o
Qj1fS2c9rXqZ7Idv0CE2E2lqA+obXzyqqtdkP8TqhbEBjy+gH97tuaJkwD4J
fM/3PW7uVuwjTonK2Hw4JizO2arHWUVsU7WbnsV9jroMOT83lctPQayMEtbz
q9ybc63Qc3itreRKQOdbKt86hJnnhnGoi4LyuhS83Ts3xlt+VEgBhfmCdLiA
+Sblh/FtT/7UkvV0iLLBzUyVQVTxgGpi9gF/wsmPqNfoWLkDYJpnHj6qxE+R
6az3DCkK7fP6zOOa1/YFKwqpl8l+aF6HyEwEaAPpGxdMvSb7IagNiI0lc8r1
Lyj3Q0VFfbOJuAzSy79Sj/xKs+2kZd1UmVgCW5FSnNw+X3P+3he/cpznecJ3
E8cgKfK8VvpmGYIamuSwc5KiKrOQ71gOZ7Xne9QO3/H5RdNk4sEsmqd/NZgf
TZ9DDIXkVccc5J7zru/LhO/L3PRr71nL1xIdCtNgvq9j8cSNjR9neZalaVpO
juKsp15cUWaqDKLEqafNPqiaih+bUn2WxQf+1fXCOgCm+Yip1zrGRd021dnl
3qbXmt6rKGx8oSMFiRD1dTcNRWH1MtkPzeqQm263AesF9Q10djDXD0FtgF0U
iRDrh4qK+m5Fen9Uwvceuyo5jg+c4mafJjRKUaPl/pa1AI0Zs88+XAlTOtUM
oQa2fbs9wcza+9NjxnN5DbeBJqYJ3W9eaDA/mjaHKArKa0j8/Z32va/6lEXA
1xIdjn9AnXnO3mdTupKAqXeBokxVGUR1RXg7XmSfS0mY760X2gEQzfd1Np7o
Gr15kdqpP4OKwsYXOFKgCGFf9xTVFQXWy2A/NKpDYbrdBq4X0Dfg2cFgPwS1
gXVRIEKsHyoq6unAfGZzwKHv2m7mrSHfXQHW9WUS1bVt283ch3jma+g4Tvet
Us/sZ6CgvLg4Zllc19efqkOzisJ8Ydpg9WrnCvYTmAc7AKT5EWRKvT9/fP30
LgrWy2A//A06hFBQ30DVa7IfQtoAuygSIdYPv1XU6itSQhGKUIQiFKEIRShC
EUoLRStSQhGKUIQiFKEIRShCvRdFK1JCEYpQhCIUoQhFKEK9F0UrUkIRilCE
IhShCEUoQr0XRStSQhGKUIQiFKEIRShCvRdFK1JCEYpQhCIUoQhFKEK9F0VG
RkZGRkZGRkb2XgPWsWRkZGRkZGRkZGRkZGRkZGRkZGRkf4z9f5mS69A=
              "], {{
              0, 125}, {902, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {902, 125}, 
            PlotRange -> {{0, 902}, {0, 125}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"346f023d-ae5d-441b-8c12-b9ee0120f412"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"56f948f9-469f-454d-b130-76fe266f5e9b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"32cd0381-a520-46fc-ad25-e9b87146b4be"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"03135b8b-07ea-4f05-bea9-631ff98ef364"],

Cell["\<\
Make a grid of the first 400 characters in the Wikipedia article for \
\[OpenCurlyDoubleQuote]computers\[CloseCurlyDoubleQuote], with 20 characters \
per row, and frames around everything.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"20e04aa7-41f6-4823-9aad-0d8a37ef6dc2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9873480f-420d-4ced-b593-c928c4c854c9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnSGv886z39OWFPYt9A0YlxoWRbpVWcitelOV3Fr3VqpCwwIDKoUZGRlU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            "], {{0, 405}, {431, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{431, 405},
          PlotRange->{{0, 431}, {0, 405}}]], "ExerciseOutput",
         ImageSize->{435, 405},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c2636dcb-368a-44c8-8b13-e6772900fc31"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnSGv886z39OWFPYt9A0YlxoWRbpVWcitelOV3Fr3VqpCwwIDKoUZGRlU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              "], {{0, 405}, {431, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {431, 405}, 
            PlotRange -> {{0, 431}, {0, 405}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b90a5444-5c05-4720-9d79-19dceb9eb06d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"88551281-ccc9-48d4-8285-8376cbbe4e00"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"cfab2356-f2f5-42ba-8111-3cf3bdba4e25"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"79c8f9e4-8fd3-433e-a881-0fd289fcbea7"],

Cell[TextData[{
 "Make a line plot of the flattened list of the digits from the numbers from \
0 to 200 (",
 StyleBox["Champernowne sequence",
  FontSlant->"Italic"],
 ")."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"49ba5eaa-c3ad-4349-85c1-0d5c37749119"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d8403496-5175-4450-a235-15d53523ad45"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvVm7FUXa/vl290kf9lfos/4IfdqHfdp99WlSryIOb4H/0iqtcqgSBBUH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            "], {{0, 296}, {465, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{465, 296},
          PlotRange->{{0, 465}, {0, 296}}]], "ExerciseOutput",
         ImageSize->{469, 296},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9b895f6a-3749-4d49-9c62-ae353b32f3db"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvVm7FUXa/vl290kf9lfos/4IfdqHfdp99WlSryIOb4H/0iqtcqgSBBUH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              "], {{0, 296}, {465, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {465, 296}, 
            PlotRange -> {{0, 465}, {0, 296}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5cdd6da5-df8c-4a19-be09-d023b3b30d54"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"742fa1a2-2e34-4bbf-90ef-1231b5368f79"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"449852f9-a6ab-4de4-8fcc-9bfb6487d4d5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8a3a4f27-d96d-4860-a453-45e9a2df9d26"],

Cell[TextData[{
 "Make 4 steps in the ",
 StyleBox["\[OpenCurlyDoubleQuote]Menger sponge\[CloseCurlyDoubleQuote]",
  FontSlant->"Italic"],
 " analog of the fractal Sierpinski pattern from the text, but with a \
\[OpenCurlyDoubleQuote]kernel\[CloseCurlyDoubleQuote] of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", "0", ",", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"]}], "}"}]}], "}"}]], "InlineCode",
  ExpressionUUID->"c3a80841-4b70-4afc-ab6f-f77e06dabeef"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"e342de27-434b-46e5-9b8c-b3a53a060bd3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b6b4329-3a4f-4a12-b220-0515e91662db"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3SFzHll2BuAvCQnMX8gfEA41DJqqTYWZ7FbWWyGbqd1UpYaaGZqZDTIa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            "], {{0, 614}, {386, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 614},
          PlotRange->{{0, 386}, {0, 614}}]], "ExerciseOutput",
         ImageSize->{390, 614},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "25c86336-b342-448e-99db-385787d6fa08"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3SFzHll2BuAvCQnMX8gfEA41DJqqTYWZ7FbWWyGbqd1UpYaaGZqZDTIa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              "], {{0, 614}, {386, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 614}, 
            PlotRange -> {{0, 386}, {0, 614}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"87e1524b-4619-40e5-a0cc-262c94bd2422"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0e8edbb9-db2d-458f-b614-0e8ef4227f02"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f994bc2c-5401-42f4-94d2-8f1093fe0b6e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fb746490-f05f-4b51-a843-f6237e2986f2"],

Cell[TextData[{
 "Find ",
 StyleBox["Pythagorean triples",
  FontSlant->"Italic"],
 " involving only integers by selecting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", 
    RowBox[{
     StyleBox["Sqrt",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{"x", 
      StyleBox["^",
       FontFamily->"Source Sans Pro"], "2", 
      StyleBox["+",
       FontFamily->"Source Sans Pro"], "y", 
      StyleBox["^",
       FontFamily->"Source Sans Pro"], "2"}], "]"}]}], "}"}]], "InlineCode",
  ExpressionUUID->"086185fa-417a-4061-b82c-ccf8e5f2c126"],
 " with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"f967bd72-e496-4ba3-89d7-9dad29e792dd"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"40d6e11d-13d0-48da-ba34-b6688d3de6c9"],
 " up to 20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"8fd15dfd-58d8-4a82-b363-5d6524f0950b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"946758e4-6a9b-4447-bb74-6c70629e97c6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXT3Po9oRJkmTMn8hbQrXaSlTWbpROjf3KstVmo11b6SIlo6Sjs4VFRUV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            "], {{0, 42}, {466, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{466, 42},
          PlotRange->{{0, 466}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{470, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "0f8fd56f-9e38-482f-9cce-a2097e155638"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXT3Po9oRJkmTMn8hbQrXaSlTWbpROjf3KstVmo11b6SIlo6Sjs4VFRUV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              "], {{0, 42}, {466, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {466, 42}, 
            PlotRange -> {{0, 466}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dd34d97f-5d1e-40c0-9bc8-eca2ba2c7cd8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9d6ace8e-9af5-4527-bb6b-3806acb8ba33"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"84b36d6c-3abe-4a0e-8b0c-20f8d81b2cda"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fd77583e-e98a-4be7-8b5e-33402ea56c50"],

Cell[TextData[{
 "Find the lengths of the longest sequences of identical digits in ",
 Cell[BoxData[
  RowBox[{"2", 
   StyleBox["^",
    FontFamily->"Source Sans Pro"], "n"}]], "InlineCode",ExpressionUUID->
  "a9237f21-e3bb-4018-b2bb-120bcdc0b2b0"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"033df353-df94-47b8-b678-8fd30a4cedee"],
 " up to 100."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"44489647-e13a-47cf-b026-e272327084af"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"38bc7043-b6c1-4c00-8f38-fbad1d723c6c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnS+T20YYh9WWFPYr9AsIF1awyDPplJkk03OmJPUknekcNRMUEzMyMjIy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            "], {{0, 64}, {452, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{452, 64},
          PlotRange->{{0, 452}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{456, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "97429505-70c4-497b-841d-8b39cb4a1007"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnS+T20YYh9WWFPYr9AsIF1awyDPplJkk03OmJPUknekcNRMUEzMyMjIy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              "], {{0, 64}, {452, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {452, 64}, 
            PlotRange -> {{0, 452}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c6334178-cf6c-4072-867d-68ae79b70b40"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0c10af8e-b818-4c8e-97b9-cfb71b41a61f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d6f4b09b-f5c9-4744-88dc-b9e2bb5deb32"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"055cca27-d37b-4266-af9a-01e8c2f42746"],

Cell["\<\
Take the names of integers up to 100 and gather them into sublists according \
to their first letters.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"61a7cfc6-bd4d-4eb4-92f0-250ad48c8c80"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d0a97c58-31d7-4230-a151-7f6f7348ddcf"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvT3L9My25yfbiUN/BX8BBY6cdmgcNIyZrGGYwUeDAx835xhMZ4OyDk7Q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            "], {{0, 306}, {498, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{498, 306},
          PlotRange->{{0, 498}, {0, 306}}]], "ExerciseOutput",
         ImageSize->{502, 306},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e0f438fe-192e-47d2-9026-0c2356761bfc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvT3L9My25yfbiUN/BX8BBY6cdmgcNIyZrGGYwUeDAx835xhMZ4OyDk7Q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              "], {{0, 306}, {498, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {498, 306}, 
            PlotRange -> {{0, 498}, {0, 306}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f4112fe4-745c-4bc8-a9c4-1bb02f37cc08"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"98082128-d255-4a42-9ded-553112044f2d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"64589cce-e452-4942-9701-1eb2286169b5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"09644e32-27b7-4a18-be71-94e1bf364754"],

Cell[TextData[{
 "Sort the first 50 words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"f15024ad-fa94-4e32-9749-8426ff70e63b"],
 " by their last letters."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"e2f16cb8-495c-4bd6-8515-e68d5c2a2fc8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6d5f5831-6041-460d-9bea-d883df672588"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb3PvMx630nSpPS/kH+AOi1lKiRb7mhs5XAUSz5Gx5YiWrotUtDRWBQR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            "], {{0, 130}, {496, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{496, 130},
          PlotRange->{{0, 496}, {0, 130}}]], "ExerciseOutput",
         ImageSize->{500, 130},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b1dfc7a4-fc0c-412d-b901-de6833fed5a3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb3PvMx630nSpPS/kH+AOi1lKiRb7mhs5XAUSz5Gx5YiWrotUtDRWBQR
FUpBEVHRUNjIR8gShWmQhS1xCopVxFNQUGyYF95ndnkZ2N37ma90jp7lHmau
65prhmHgx+e//OXf/Kn6HwVB+Nv/3P7fn/7F/5R+//u/0P/sT9off/67v/0f
v/3db/77f/vd3/3mt7/5/X/9y//UHjTa//2//yAI4L8fXFxcXFxcXFxcXFxc
XFxcXFwfqjqL4/zeMKwwZVzh7pqPuVYVcZRU289uqjyO0mrDGRQ79xpANayu
GfYKMzdXnLg9oza1xXwIfGyj7236ojy/si2mY+ru31RR1JL6QB1VJAqCEd2Z
GQUrvDGscHfNx1yr4psgCNGWCWvniRQ7dxtAVh3LgiCZMbVAU1dbcpOVmytP
3JZRm9piPgQ+ttFdTbdTFptJ65o8v7ItpmOqSqzWNvXmFUeCDU0yY3Z5xbzC
3TUfswSGV4p3zOdbT6TYudsAsprc0lTTz2l/r2JzU3Os3DzlxE2nnJexn9bo
rqbjm9jOjOe1yzjPr2yL6ZiChc3x2rxedzWYFKtjSRAsuMRvDy8tplVZV8u7
lgZU0KTzSNIvUsRKiGaQa15WeNC1ZliKoK5PGnT24vSGtGipQbkms1924ho7
oQEyMIDYFmquP0wrQ1czTZcmhaleLwqd7ObQ0oF+39HW4BUsPK2faAwsuzZj
mVrYHVv0xRVNt/O5aCbntfsqz69s631jqm05AfM5HE91GjhKe4MBdfMzSmuk
YvBCppqWho5LelTCturCt3RcVFSDHNrUZIYkmZ5nSOi4FpfYsDy08TEJVGTh
0VEFlobqkFQLb7bSKykiR8altbCon9bM2rVHHVpq17iVVajrRcsxu7O9buoa
nJINt7Om8k18ugJ8kCkT3QY70f2XYRq4WsO74yocWbUCFx6/RUt7UkcTZLPo
moxMRdK8usl0UbKTCgYgNjUJO6s7bWup2wUEhMSpLnTzWL+z6PrpfD4YIypu
XIJDGzOWvYWL5Lyq6crFeSK2ZTU3PaNdWp5f2dZbxxRW5iiCaMKD5U0SNMtP
s9Q1ZPqqiVSsjhVYv+lFaeyB/xZvJbiT8ERBdsIkSwMQE9kG0axiFF69/QMM
Ndo7qhIb2mxFSezeQB1odIQ34KDhtoVdWLNR0CupU1CJYvpZntrAaVCYVjNz
11BH21HbeGCoetsIOtJa5MUJ6gULdhx0SrSCNE98tTMeeao7QRL7OvhP2kS3
wU5sgKgFSRo6IDdkO+lzsv3lBEGUlkt72uTsrW2XCG2Fqpu1Ye9nrcxRBeUW
pVnsm8Bsv6iK1IM+3twgjLPmQjeP9TuLrB7N56hdSbfjJLJUMBe4Wb0pY69J
zsuaLmABUbOCMIjz6ox2aXl+ZVtvHFNI9yxoi0q38b5WU+ZZ6N6GdsmaFoMX
sv5h0z1sr1DS8BihvudZYre9K1ngGCxsBCWqx4Ve1Y/GA1breBepSfDdMSys
2PhOrYYjpT++qKR2Ww9FcAVsmvZi57U/oopS8wmuoQ7Vnah/JI72W8I7wSnV
SaGZj8SSwSUVHpRN3Bf4JuvZRsQqO/FeX7cq8TUBXb6RqU6K15YEe9oMB0+D
QlBbdMNeL3YVqrJIY5RXUWc2vBWlVXuKm0z6fW1IsRZZ3UUGGjPMG7kOTIu3
ZOwpFi6S87qm29/tbZKE91tOaZeS51e29b4x1Z14g5eZAP9uIhst4yVVlemL
GVKxqUnomggDkplwfSLK8FZGsuBNBSqMw9qZVIElix7gRvoKUUh7S0ZTIrkS
dEEdpMQVpeYzXHs0sWugmzNZd7tLeTdfjZyamynbFfYUe/T0mcsGO2f1pHYb
KGAq2gPEOUm0p10tgMGgtvMhyC3VbabRuycuWnDKCjhbxjdZE3+vcvOPx/qd
RdcPhSsQYzhmoe7g9lu2qg0Ze46F8+S8sunKkvqV5CntUvL8yrbeN6Z6H+4p
6GAj6K29hWhZQX14RC6GTOpeeSx8HVx6qjZp28Myur7lndezKIEyMPI2uMux
cBX9vA1vRsBdCTqcuwKa3smV1KD70P3vIErNZ7jWxTULHQm0mZDnc+iU5k2f
aCNPu4M1feG6yc7RA1lwqqOO1xJd/UR7HmBF0maH6YM7TbxKGcJegsWAhh8H
tN6K49yr6dWe4uahft8a0mdZDW5poTHirWupNMCvaEvGnmMhVp+cf7iwaTif
W3h9fka7lDy/sq33jamRMnDjB4xBeztmmN/LBF1hQRNNqrf3TIbfB4RcDO0N
ykaY5lnkSN1VIzbB2I2Lex7D6w66WFfLxAYG5Oj22InKModbWPjuFR4W7TAt
slAHDWpZTa0E3sUIqhUU97ZR33KihlbzCa4ljibrTlZWVRG1YVWcjDyfY6ck
J8zu9yJyLbdb14Gd9iQvsadwY/mYnfh9VNPL8jyAKxDNyx7zhTHRnlaNhx+g
aVkzpFOfe6LulVUZwmrxWgK8LiU4cdta2Vzo5oZ+fxxti5zVdQJ2UOy4AcaA
ICimnxeZB9u1kvumjL0mOS9ruttjMZIiz4rqjHZpeX5lW28bU507j8n7LYXZ
LeUVHYwzePeUwKcA5uj6Ti4GukvGT2YFSU/QlSfz+kOGoYwzf5TYcnfLUKHk
Bw2q+lCmydFDJfSH7nUCWiWPxMXPnWGrqMtINZ/gWh7act+2YuZNdwuG5/OR
zU1hq1Jf9hbAC24ZaZ2j2q01AJ54zE5kgNaXv+EcnhhGs6ebmvrt7rELMb4/
BXfvN1XEd9N1ht/fEJS0uc7NDf3+ONoWOavbKQvWEMIfsTO8lmB46eaMvSQ5
L2sa5puD+lyET+uYt0vL8yvbetuY6tx54Mn/1ptQ3e/36buxYAE/uV8jF8Me
1O1fZmXrtuz6FzBrWDXt+NpqGtDo7N3bZc3nuNaAcutedgVF2xqmx5aWH7bz
WflX9rwsv2wLuDB+OfY6N9f1O4u2iF1fT86Hbq/N/IXl1yXnRU2jnhjHh3m7
9PJXtjU795Ixhdx5dBtHkmrlJLsK8OxWcPo10A/St7j2LXYe1JVufn5I32jh
u5rmCbBbU3fqyLmpqpGSLiFNVWTUN/C/W9/i2rfYeVBXuvn5IX2jhe9qmifA
bv0wd7i4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4
uLi4uD5Ya+jeE6I6Uyz8Jr2RgX5cV9LMrxe1a4jZ0lR5HKXPPl99hd5i8+bh
tlfNmcN0f+iay6ePKk/itLy2zfdpDd17RFTP3AHNs15sOvGNDPTjupJmfr0o
3tGy5SO8fovNG4fbJo1GGfy6bP/dP+baHTr4zfwxiOcCAYC1cPvOWWO71tC9
R2XusaMoelhsSZQm18Yki916IwP9uK6kmV8vine0bPkIr99i88bhtkGTUVaH
lqYukJTMtDt0Td7aZfrUj36foe4D9T9Wm+jeL4nqSzz1jGr9aJLxx+Sppx02
dSX4e27e+HzC59wIEPWVdxurCePoi/rt4YX9RJuwEQ3lJyUODaX+eeEzGPGT
00BCZfZsbqT0SVsbYS9qHez+EptfNsl6uE1KT+jzpFE2Lb1MgPU3zmxDN7eL
1J2braIcRPN5vWHgfou2YdaJRPU6cyVRw1lzT62OYa1Z4HPRS6p122b/iWzw
eXyIwXhCtd5n6gz83RSBLEhut9kJv9isgq8gL82DqO52xeB1H002A0xQWnq3
zvJtxsP5XLQcszvsdVk/tCWpVrf5CMjyN8eB39GXk1+mP2sCAL3OHFkxw8AS
FvWHNv6yt6iYqH7m/PRJtjwq38QAAAXSBWAykGqDbpqehz8WLWpx19Fl7HaF
ZRd/ho5xOq2wGeDEbrg60fQzcptMhlvqiKKOv7BXJ5ooASD1Y5Gci1HWZrWo
ufWTBKgHGIGsyKIgOeSHA0xD12S6KNlwQ4Y27u6phw+JkiyLomKTzCJZRT4I
P1AvKOZtMcC/XpvI12SiegWoGQDVBLoG5oITxpFvKqpdkqjWj+YeeWCyUkwv
DEG3P6Fa7zOVBP4uDNg8qisAnDBAsyWYh7u7nTPsOI1u4D8N8OyE5N06y7fG
GQ00xYsTNC+h7UfYlmC4YRJBuoIIqcQdWV6zvTBKm+nPX0gAdFr9Eaxfs/0k
DnRFDcrmHH56ly2dR7oTJLGvS/3cSKqt80t3WvedfscVoWfaeQTmpGrA23bm
6fTaZpQbkhFleeSC/3Rz4rWPyXCzemMGKtYyORejrKcmURIAYYb0uChTOBYU
OyzJF3CmoRuhncjjrgYwQenmF/fcBTAK0Y2Je7skq8gHH4kNjVWnDf0crSFf
U4nq/VYYZieRPs47o1qj09Hd2XOq9S5TyeBvSCjD+DN1yumbmYcyv0MF4oQk
eLfN8pXG43iG92mcYWHFTnDLcLD3x0c8lPFPchzQ+p9Y/1AP/XQm3sXVzFQE
Oh/fgBNqMwI07BpwPVPbpSa0sM/JPZ3CxmaUG147h4M2AVlMsp484GMz3JCz
aDIkD73xKBttGpMT4FFZ7YrcgrilR65iXuoTMeruejyfk8YdvPpgrj3apXm2
7zK1inKQ2NCP0BbMOoWo3ndZ7unoHn8sItV60sRTqvVOU4ngb0hu0vwScYpR
DxLNGz8ueebdWss3GV8RByweL/0O6mgelsZDb/KTDECn1Q/2PycTwsn8dOxR
vwPWW/WkNly4m6UhrtQIJ7awT6fXNue+PmtTIc/nLIcbOo7SgDj0KJRqSgI8
ah+sftUgzSIHGIm3cc7u7vl8Ph937a2HBu4bnCxPLNC1tJtEklXkg5SGvl9b
yNdUonofEMTO8ybhJlOtJ9POK6r1dlOp4O/oJgryzW7zVvUaunnE7iZ4t87y
jcZThhtsS3XxRl+TuwKa3qfjaPqTHIcn9StOOrb6PH56f6OtdtGruwXbs9rm
UxO84sD7+pF7zNPptc13sMbrVrxsGn0+3LqpG74l2B4nDb3Zxf3lfI5WLGCr
XpRVN6LMmqxD93o+f9zBNgy0S9EsGneIaBXZ1J88n28gX9OI6uMug/tmepgW
eeJrqpk3ZKo1vim2w6LI780zqjVDIjxQ4aNnIya+MSSbN7kde+YdBfPNgDBO
WD7BtkS7bT4LwUpK0MACakqWn/0kxoFWP9y7EEw/KYvU1lUnuZ/GT0etwylL
ULwkL7FHMpzPybUt5nOwi1KGN9iIm5VF7N40cDvPPp1e2tyWgHd3tzgvyyJx
LCerjwbq6XATDC9u0wA9fESVLJJzNsqGrKYkQNX+XZCt/H4vy3KAhJ4eOsp+
yzDu4Lv3ftrZVa23imwqraFFnV+oTZh1MlF9TL6uUrfnjEuaU9Ko1o8m7J9i
t2fSqdbVTlOJRPhHN2sN/6qCaB64nZfsUXdTvSNjvlkQxrvhNgLHN8PrB20H
BOiJ25QsP/9JigO1/joz+/oFtR1A5DAy9K6M+ncwtFt7IjpOrk2ZzOdyt4vS
31ADGS58vsA6nVbY/Kgyf9jnEVXwxvXRHCYPt3ElqmGI3Z4wITmno6zPaloC
xOYQNGQjWPWcHbqRAZRxV9ymdoG3dFZaRT5IaYhQ51dqE/maSFSfnTerkEK1
fiAs97TYnGo9O+0wEf5utrdtt2hS6rVHy+LN4tAE882EME5UvYY7vmhgEYct
9Z/DT+//TrRtm5ewA+b/5IF5Or2yeZkIxxulDLfWgHLucG/AtPLZKKMK7W+3
1yHwAnrTXp5G/wD8gtBRBW8SlaRCdtWxraLpd71V63OJWCfXcZ0A6W6S0LfA
a1Kiv+mfsm7XDyOMz/SN3r3F5i8LVBW3E7jmxu1kW1eFD9e1Xl6/3QtogOSn
ZdM09yIG/wBBsv7lBKve7ukPFnuqNXpBV5Sd+PRXTX82kvsbvXuLzd8WqGa8
twZeZYePRN/vRVPY2rDhIiq35N6cYdX7PeXi4uJiKfC5B8JXIN4uZNeP+rf5
XFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXD9Ga4Dj
dF2Opz9O6z5Qw7FYnd40Ey48GdH+8qTtkTkaTKZibgybvnhSP9lg1uNxI8m9
OfOl8c1D4DBe7lR3ztEa4PiTsy8HtR+nde+v4VisTm96Lxd+LBqinYF5x085
T8yNYdEXL+tfGsx4PMLPvNA5XDP2J/zk8ujzd4y1cQjsy+TR9etkd07SPph4
p+u/J3yc1r2/hmOxOr3pw+Y96Ih2BuYdP+U8MTfmbO8o9TMej01uAcgn9fPy
CPfTNVeHbelnXN1j2jgE9mRyk2sDR+Zkd9hpE3D8OUv9BZ7+ZetPD85MQv+d
2vLLKbGhVgcM3zSpHo3VlCp+XtMULnxDwa83y8A+EdGxpXkvp6+twVxnyLzw
S3f2GUOcF+pqubdB6QtqHcRKdhqM+RcNHWY/PrwdeD8bWRgkR403Lf2eBGMi
FkNgYvz8s5yziaJJxpwOotXUP7xhGb8FOF4XvtVxtfrvb4Nrltp9ddnKOjwl
CU+/rnUKkhuyvz0Hfge/vVw2ZYw/Di0qKvzk2r3wZUHqIVlVYouCCj7MXMRm
9z0fSXewK6kjq1aAPkB0i0aTammrkgjYlGfEagFhn8znjJqmcOFbFZCkjILm
ou+SNZkhSTfXRZWIqp2hT9iBCg10YzpGtFMI7GTzns7n2zwaLJe0EH00iRjh
Fe4cNYberul5uC1Ri1/0RYVAzKBi1UqRYfRKjhiM+Rcm/taWYnh4rTkdAmOT
ZLgEbftakM0eUxSZiqR5dZPpomTDUC5HVuoO3D1RdSpYCfhcOS39qBl1NGGI
YR9n8nIkEiaKOu0/2N620950sHPnJG1AdTe5JwKAeJKlAXATkshQtthRlqeB
oerxnYqPX9s6DckN2d9t5wVhlN8zmHmKG8YIYi7I7ZSYA1wWpkk28CubVtuL
maMKyi1KsxhSy3UfZGhnpOwEQZSWaFJtOxAiFKWAfEd2NFYECHs3nzNsms6F
t2Gi2nESIS4GuPYhrEw7QNwo6j6vp9lBDIcDghqPEe1kAjvFvKfz+QaPEDVM
Mf02ySC8AhAkyRFe4c4pPdu1q7d/gMMc7TDT+gKR7g23LezCmiETk1LJ4XyA
qS5qQZKGDkhAGVLFZ0MAmiRaQZonCIweI7gPHrxNqiDc4QgntBxZVZF6cMjf
3CCMs2ZEkiKnHzWjThoCXSaTRiJhomjuaHpRTC8MwbWCnTunahWqG6u+51li
ayKaLVFW6E7UP2Qm4+nXt045CAOFceewXwaaedotcVNbwU8ratCuNtrlq8oi
jVGiRp2RQw2Qd2P6LzC4h2NFgrCzbprGhUdgpp6lC6997XQBKzFClHTVCPZR
2x1NdbwB+xSMPjdvxX7LGo+g5SJYKDZNu4jy2h9Do9MIr3HnmDFP2w1Qu40L
5776QekLWFiBkyo4Fc4M/fFFJUcNxt3XVQTWOXhGGg0BtNAF9NimGXDbJXhW
DxdIECoB3V9062xkwf0WuL0D1d1+UtLvRUbtc5k2BIZMJo5EojvodCvpJwq2
7jDXBlR3zyMTZXjfI6FdgiZ2DXRTIutuOR3+rwb1TiQ3okYGPVqu/1MZCHCz
qwLphylX9wRzuGQFMh6HOUrukzyxe1aY6FNBuEdjRYSws26axoUH9Mbu5gVE
BSxe25saXAAnYBvIbk04/PdiPl+CdF+bd8ijAeSGpMC1GSkbV7hzRs9O2+3n
w4rcF5h030VmNM+TKjlq8Ox5aP+waTIEuoXuIIjzy8C0pbYTI5jgVLeZZNST
kTU015O7yem3Ac18fAgM9RNHItEdGoj8sDunaBOqO4G8WHQxzOePIJssdOAt
bbJ+Pt+P5J5e+EZ/qh0QZxds42k+/CMgPgsa3sN3SGtOWAO8KfMjMLmKJvEW
6XisiBB21k3TuPDwVSuxfzGyNAS4dp100M75/Kl55Gze4hG0HG1rTOJGysYV
7hwzZk27k1FP6AtEunfxzmqTuwKa3smVHDV49H4CONVRx+vzbghAkzRv8dbK
PRRBcoKtDLwMHox8OrL6lVK3oCWn3+oJkMUQGOonjUSyO7M0ZuXOSdqE6oa4
WDUu7nkML2RwZZI4mqw7WVlVRdS6qDgZdT5nh+Ru1+HgD4qZlmXim2iZhGKL
lu7CsHUDuknUvbIqQ3h9f7KKAIYVvoDuhY9hzYmxIkLYmTdN48KjHFZMPy8y
BBq2kvt4O3T1fD4Ho5PNg3Rd1Y6b1V1P8wje7AuqFRT3Np6+5UQNPcKv5/Nz
enYxFYM5k9IXNTws2m0eYNK9BnbaKJUcNBjtq6iml+V5AIeA5mWLIYBMkpww
u9+LyLVcbEbj4Zcdupeuq8l8ThhZaCsjblsrm1HCkNOPklEnDYGhfsJIJLuD
d6LssCjAv0li5c5p2oDqrjOvP2QYCt5DCO2eKt66105QdHw8MyR3qzwwu1Zl
cPsld39qUjhWjH6pEff8d1m/qaI03m8Z5vOeF/9IAHBWCv/9ENacGKsHCcLO
vGk6F/4RO8PrB4aXzjuoXU9K/UNDsFewjBWNwE7qsho+6hPgqwMHPXqMUWho
XJAjvMKdg8asaHfcp5S+aHL0EA39Ab8kQ6vkmMGom7S+/A3PKrMhALBu6oB1
uwV4AKGJSzY7hPrISOLIagOE388RlLSZJAwh/WgZdTRhyGEfu7wciWR3Hk3Y
v6wSV+zcOVFbUN31EqSOqOLVild8GSO5EdX9Zasd9XxFwYkOY82JserNeebd
aVz4LmgnvBlLMq/uDzFgxDf1Ag1Pi/ALndazZNH6ol4NnmcQvXVjCmbHqjE1
Kr9sqwGVkP9ZwNr0O3EIzKwZVUibKFDm0SrY7c5X67vw2W+09rsCtUYf5dFH
GbNGX2fwcf0wl3+YO0jfhc9+o7XfFag1+iiPPsqYNfo6g4/rh7n8w9zh4uLi
4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uL6oboO
HH+CLjP+7eByhnqPL58NWz+9C5qj/n/jOL04sVeKYlVVxFGy6osMn6yrwPGn
6EzjryN9n0+6f7sv6CN4nwtb39gFgEQ5xmi+nKvhh/von2RnZCGDVGeq7VEd
x/QsJCfFqioGH/a8Fkhxgq4Cx5+i84y/kvR9dng/wJd74n40bH1jF8Q3sZ0R
8I+JnRQ1uQVQk4tPjrO1kEGqM9Ume6ZmIOrBKZ8Tp1h1/QfMWemt4HjKieAw
eyz7S+T31IQx+vxc0vdh0v3jMYOVj35eTC3f4sukdsKqsG2yP+uDzJ5X2c7n
opk8s3OFES/i895Up9r/Yi2/P7GnZkCS3UDKeGEVKZW2WjVCgZDmor0BOVPv
BMc/SNz2OnNkxQwDq/uksUe/PLJAfqeOKOoYJFgnmihhiOcM/30i6fso6X4G
ap//vJRavsGXCWx9AZdHB0Nb72wx0/IjzH7UhW91H77Gny6vXBxhsS2rOf93
ZufYO0m1UpTQTaaLkg1HArTTcyDZgrIqfmeq0+wHA9xxIO9izm7bYfM8sadm
/J//PXxsXFSd6kG2apb8ByMJ53PRcszucD8X7QvIBXonOJ7Ibe+w44oXJyho
9C1WJsZbA7qupykt8d8nkr6Pku5noPbZz2up5Zt6ZIAGLuHy7cEIHGxzxk/i
QFfU4I/lJ5jd5J4IEiPJ0gAMfwjCK2ABUbOCMIizf5/ZCb0TDDdMIoj4ECFH
eEQjQna2E0oQRjk52d+Z6jT7ZTyovTBKSevRY4k9NeNf/y314Gxwc4MwBs9M
iFbNkv9wJMlz0d6AXKa3gOPJ3HZ0TQzvs1ZOMp5Mrybjv88lfe8n3U9A7Y/5
T3zwUmr5Fu581a2OZnB5eHDA4nxKF3Rl63ueJXY7oWPQIchqabTfMtgJ6wEY
QXQenGxnLGM4n+srdtLfkep0+wkdtNNmcmLPuhvut8gYhEqxipj8e63CEZvP
RUcDcqreCI6viNz29ThpFsbPm0NdRsR/n0b6Pkq6n4DaH/Of11LLd3HniXB5
tKU5G5gfYPajzhC/UpQVBK5F9/4T3vT4XDRX9Dk8mhZG8zkV/bzdQtap/tz+
Z68nHU3sWeGl/UurZsl/zKqKPBftD8jpeis4nsxtXz+fs0N+d/kMX1tqj5Pw
349Zf70DXL4iYvOfl1LLd3DnEZyXAJeHBxUn/bAugHUKMlrK5eBCMprPrW59
PrYTOqK6eOu+yV0BzQZb5vN3pvoK+w/bTE7sWXfjHsT2k616+UbKzhR9jOai
vQG5QO8FxxO57dT5/ETkt2B4cZGF6GkIqmSB/+62BViTvo+T7l/O55dRy7dz
55GdRLg82kURTD8pi9TWVYDr+gCzYxOM5rho4w9vfPD6HO0YGEmRZ0U1tRN5
J9ptMmUhfOapgd39ajafj2DBn5Xqr+0/bjMxsWfdjbeG4izPy+ZBtmo+nzNL
0fFctDMgl+id4PgHids+wY6PKzkH+T2uRDWMjk1PwH8/ziJ9HyXdz0Dts5/X
Usu3cue7wUKEy3c7G6hz/PT+CWbXmdcfMgylm8/b+h1kK7w1mNgJXjXvHcGv
xExye2znB6b6S/tZ2ExI7LkZdYZfkBMU8LiRZNUs+VmkKGku2hmQi/RmcDyB
207Wacjv5n4vSabP8d+ghnNI34dJ9890MbV8pS91OnrdYmh2DpevF9V9QBfU
5IZgyWZcaPIvLygNnGIh+1R/af9JiT01owGRHxW4wiqK9jXNhfQzGNk/wwuk
A740eZrA18KfP7o6RZ/fBZ9v4VKfafMbrfrMgHyOfgYj+2d4gbTflyZV0V2/
feDrJXv1+V3w+RYu9Zk2v9GqzwwIFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcX
FxcXFxcXFxcXFxcXFxcXFxcXFxcXF12fxuD+KPr21uDUSeDajhtm+/6lGPO+
+DTg+yZ9Wmay0jG/PhpD/1O77Ht0Plx+mz6Kvr0xOKmNv/6jOukMAX9Gcysr
3AF8Z649kMVPy0ySru/lywbCBV22J3rH9EbY50U6Gy6/VR9F394WHPgxas1H
PyYI+FOae0eF+7SPIP8hxj/V9b180UC4pMv2RO+I9jn18TpCNu+OrrvOrSu3
mr4N+VPkOpe096Z6fWSnMeNGR6ZADFmHOZgg4E9pblRJtbz/pgDf6dx5UiUo
2qMiy3MpXTypjUiQJ9pwMBoEY5aJ0ZccGbvar1mrF/XyyJgXGHp4fkM4b2oM
0cjLu4wUPcb9tc+pL9FBsjnUjA/+qD1dUju+Xu7pHY+7Di21+8yylZGXE1vp
24Jh4s8mK4bXT1JzVvjjUcaO1FnugS9pE44wD07qdN8eF//qf/31CAHvpmc0
hwjjpufhz0SLWvwU+P4EU76spM4cWTEDCJVupbtJHtnIKOXm9x9f7yuUDfdO
q41AkD8jMwn5tkyMnX7BzlVN3+s/0B20Flaudn4vL/yiYeihhZ6LQ6/4aR5g
a0U76ohE9+SGrRFNZMzbuowQPWb9td+p79JRsjmBD/6oLLHjmiGeC/yoO5p+
7SjL08BQdcotznb6tqgFSRpCnIEMLyIkVjj4oJ9sBkWRuTfNDIvH8sgJwaky
v8O+x//yTyMEPBnifrgvOsK43v4BDgREr6AB359jyheVINa56sexi3EJshPF
PpwiPEC1QRWKVpDmCWJPx+TaFgT5U4K/yDdCYuz2C0Oc2w614zS6gf80WkuK
+PReXvpFw9AjCyXdiWMfz5SKGSUhmNMQZwENXsloK4tc8J9uO6++r8tm0WPZ
X/ud+kbtJ5uT+OATNm7PRkQdoTvRimfdWwDxXcvge8OieX+QWOEloCi2Qy8t
u9L14sgJwXlMsO9TBPwZzcHCRlCiesAcrbr1gwJ8f4opX1TSsc7hFNVkENqF
FjTwjvXWnagC4mcbeDiZtN1BqW2Gbj8jGot8I0Pkd/o1g9mBUYDYHKf38nIc
kTH0UwtT8CDnhroB8jHBl+fR4PXaORx4BtCEACL2vi6bjReW/XXUqW/RUbI5
iQ8+YeOOWLdNe0FF9zey7paH7Zk9BkoxnLcissLvqY8JUZIWwIXT8gjz4NDA
qSf1RVe46iKPZp6KDHx/wZ2fVTJjKQ6TxrjCeeBlu6LUtgKeezz4s3wjJ8ZO
v6iw6fN7eTGOaMjdsYXj/64TTIbKfX3mmQLn8/d12WS8sOyv/U59k46TzUl8
cPhSh+qh5cOCXd5kIdi4HmDoe+0ZPQYCpzoqXp+TWeHIsiIebjYpRxgGhzCf
k7xm1tw0ObvIU4Dv6zDl09srEqd7yj3XvHzqFbm2Gbr9lGhg9fn2B2Ji7PTr
+Xx+ai/P/Uq2zud9+TtYn4vhbDJ7Z5eNo0ceyBfn4XeJAdmcxAeHJRU/LdIA
bnbBkomjybqTlVVVRO0pipOxoG8LqulleR7AhYHmgdlpyQqvi0CRtNaeui5d
tC2zOFKdgn0fz+dTBPwZzVXLpAWLEArwfRWmvK/k9TjCFUpOmN3vReRabje4
lrXN0O1nRGOZb0SI/E6/ZvstQyWn9/LSr6fzuUmbzyM4hMDglW9xXpZF4ljO
kwS4oMtm0WPZX3ud+jaxIJsv+OBV5nVHZNNU8c5MaPfFBAVM+0zo21pf/jb0
wpwVPjzEByZ5afVYHjkF+w7Wxv3d9wQBf0ZzU8I4uKmUETWeAnxfgSnvK5my
zmO5e+jW3fOinYDCVju72qVakNNNmqHb2UeDkG8kiPxOv5Avkj2aIXElZ/fy
0i8ahn5sYTpa3uMXfWFvo0f2fQ6ERfPGLptHj2F/7Xfq+8SAbL7kgzdVWc5Z
7ajY+JVvJvRtcvkFK3yJMJ8dOQv7PikyIOCvaG7WMil6m7jzawSjuux6kkkj
dPs50ZjnGzp5CZFfo/V+nd/LJL/2a4tnp3fZJHrozLP766VTXGv0UQjsi435
KN/frp8ajZ/q1+OHuvYjnbpMH4XAvtiYj/L97fqp0fipfj1+qGs/0ikuLi4u
Li4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi6udaIg
ua/AiK+hgV9GqP8iNPkFpr4xK1iJGqVLmMDvDeBr36s8idNydvBKA/ZpbDYX
QRQk91aM+Fmg872E+s0g73fR5OlAT6q2U9RZgdovg8vPxS5K6PuT1saPprJK
p4sCSGk9cwffAYtZuN2nB/fEeYsBx4Pfm01s1VElSTF+EnxosyhI7q0Y8bNA
5/tg6DtA3m+iySPYzTaa4SZTmYLaL4LLL8QwSvfEVRQdfFpwvdil00UBpPke
O73v/Td1xwf3xHmTAYeDvyAsTIqmvq10X2v89WgNkht/ZrOhgbPnGO4zQOdk
Qj1FEzPXgby3osmJVUxiM/rZ1JSlTjPBsjfphKPH3lSmoPYXcHnq6m62vB3/
pPLcT47S1BwSL374pCG7dNo6rNZrq+/EiXFlnJkY0DW5LfhP53Mg+K1g89fx
ja0NSG7EjzBM/EVixfD6EA0YblFx45I96JxCqK9TRxR1DC+tE02U3Az+uKcW
NkDQrLB6DfLeZgwBO546smoF6HPNt2j+s4jNzh5JdzDhHJLKQ4T86LDsqTsg
wETVIWXpMVNZg9ppcPkxY11SrRQdhZj1m+NAPr2c/DL9WVN57qdGqc5cSdS6
6WGBhocHQ1vvEtxMS5bptGpYwWikjibItx4FFlmKpLnEJcU+3/uJsT84jfPf
/70qAiAdUpMbkmiGxI3rS4Pfc7gcinkvJ/wfpA1IbkzWFrUgSUMHRFiGNGGE
j5d0O04ixEdoJ1W2oHMaoX4grTxGgBJELQf08DjyTUW1y9cg7w3GPMWOy04Q
RGk5+5m1M5Zyi9Is9gGeT/eLx3DKBMteFakH//vmBmGckZa2x0xlDWqnweUh
Y10w3DCJXFjYgD5jzLpme2GUNtOfvzwL7IlRqpKe5kxCw7czJ/RFs/0kDnRF
Df5YMkwn2rBa9t2/QSZgxyLJVAT5Yuf7iC2ID87i/M8WmJJT6G8VA7N98j7J
pcHvzU4o5qWO8u2Iio1aheTGG33dgsDXMK8TIKLg0IPKdXC47QiGoHMKoZ4C
n0LUciedUQzWgLzXGPMEOz40OvuJD5ZFGqNEjboy4hLLDu9w5YQ80zIwlS2o
nQyXh4UVG/d+DS/H/XHZ7DYzJz+fBPbUKI2yiI6GH2x+DJawSKenw2oeDUTm
dRu8rb1Afx7xncKKncT5HoJnmgFY9AY6ldJ7cfCH5TfFvCaDbFwv/RU8E92A
5J49uOkIViDHRCPsKryD+0YZHGcHOv8jmVC/mM/RYM89vcdpDXoB8t5iDBU7
LvejcvbznmAkn6xAYCMMC42E+OoB2VFT2YLayV6gwds3MZrnJ/jdyc81PPcz
olSNpxQaGt6aLQ+YpRN1WBGjAZGaYlQ3oQ5W55TpdGfrxPl8al4DLjey0zxy
tbvNfHvwR9spNPNqC27RhD99jb4JyT168gVOdVS8kHDg8+Mus0sDP01mCDqn
EOqnJET0QlR7/B6B9bk3y7WnIO8txqzAjs9/lmCNouGNZUdC9y+vZirKWD1u
KltQO9kLiN9VXbwb0MCNgttiUE9/buO5s4vSqAkiGh4eVJzpMyBm6fR0WBEW
wOD+V7VAKYO8d72/+57N5/W4csl2jPFy5b3BH2+PE81D9tgR7erzc7QJyY32
EFTTy/I8gNdfzQMDFs2fiunnRYa4wxYANrEEnVMI9d2zJC8ushA9JUGVwN05
PUyLPPE1FbGnRyDv+pAxr7HjpPlc1L2yKkMYtxfrc7RfFLdhLptjcSOayhbU
TvECMdZFu+2DLARsYEFbsuNnPzfx3BlGadQECQ2PdxQF00/KIrV1FfDI2KUT
fViR+g7sBkNrBBUvWtl1H9x/NjrAdDefj+MMe8lED/Z1H7f33uA3g9kPonmP
Rwb2zy3KxeeHaQOSGy2Gtb78bejB2BmegxsevpgyBJ1TCfWjSlTDELuHcVXq
9gx0SXPgOmYE8v6HfzxmzCvs+OJnjG8/22P6TRWlYT4nYNkfdWbgNpX0l4Nx
I5jKFtRO9aLJ0cNx1GdBXs8LLH++5rmfEqXJJWOJhodtmb0vguqnd4bp9GRY
kfoO7BKDp4ZGv/3IrPvQPyNS3Gwa81Gc4ZxZBsAqq09uBgYcCH5c9Wajtufm
/brebwHaguSml4c47fl7oyxB5zRCfXO/lyRMeLOsvAd5HzdmK3a8IRtPLQ6C
CSs/yVSmoHaqalotT7QhsGyiVKejt6RQARIafukLy3SiDqtFNMCzUcFOhxoY
dl9FjvwQ5wd6XUTQxtsi7w3+zOyleSnc+f31zOcX6KPA2R9lzHNdYOoXRYOm
Ay40eZp4YLFH3Q0+s/WNqvPAc8BaVbKGd9Qv7L4yCV0H7gK5w3uS7w3+K/Pq
CL67/vTFDK7N+ihw9kcZ81wXmPpF0aBpvwtNijej7f3j/bIAoud6knJLJ6vZ
67ovAf90XtCsYNzee4P/yrzav2maYWd8dc7FxcXFxcXFxcXFxcXFxcXFNdX/
B1621jE=
              "], {{0, 130}, {496, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {496, 130}, 
            PlotRange -> {{0, 496}, {0, 130}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"870dcf8e-bd74-4f3f-a06b-b16e7a1dde10"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e1b4ad77-8339-41f7-a1ef-7ef0e595bd1c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"57be410c-9514-406b-b6cd-a44da2ff7e78"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0b14060a-f97d-434b-b01f-521fc722453b"],

Cell["\<\
Make a list of the first 20 squares, sorted by their first digits.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"03ac0425-6306-42d7-84fd-4c514f1442e9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e7696f71-3b39-4b5c-b4b0-a9b6cf7b8366"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL+rrcoVNkmTMpC/IH9ArNNaponwQrrdvEeujzQ38l4g2AophDSmsrOy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            "], {{0, 19}, {458, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{458, 19},
          PlotRange->{{0, 458}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{462, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "38f7a829-449c-489d-b10f-a41835c535e2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL+rrcoVNkmTMpC/IH9ArNNaponwQrrdvEeujzQ38l4g2AophDSmsrOy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              "], {{0, 19}, {458, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {458, 19}, 
            PlotRange -> {{0, 458}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"61414920-df0a-4d1d-a245-c09d7462378c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4f3ec13f-569e-478b-97aa-e235ae08acd0"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f1ae4a10-235e-459a-acae-9dffab4c0e67"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1b3f0bf8-4c4f-4a8e-94ca-49db0a70d1f0"],

Cell["\<\
Sort integers up to 20 by the length of their names in English.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"fec9e8b7-dd11-425f-939b-65e2b1c52aec"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"517bdddc-b760-4d20-a2b4-8c181fc2a770"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztGy2vpUiW2TUrN9lfsH8AvRY5imQm467pyTSTMb2kZ5MNFofE4VAoFAqF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            "], {{0, 19}, {339, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{339, 19},
          PlotRange->{{0, 339}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{343, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "12632ddd-c487-4e98-a98e-d4c76e24f7a0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztGy2vpUiW2TUrN9lfsH8AvRY5imQm467pyTSTMb2kZ5MNFofE4VAoFAqF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              "], {{0, 19}, {339, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {339, 19}, 
            PlotRange -> {{0, 339}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"348391b5-2d85-49c7-9037-bef8fbf31c9f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6ed2664d-57cc-4ea2-8b5d-72cf917e0297"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"97051b76-91c6-49fa-8f55-e8674feb5eb3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f082df20-1001-461c-b732-264db51ccc04"],

Cell[TextData[{
 "Get a random sample of 20 words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"ceae431a-ab18-43f7-a3c6-be21302f10a0"],
 ", and gather them into sublists by length."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"418b6541-1401-44f4-a209-f9c3ba4bb921"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"65d0450e-3e73-46c0-8b6e-c23293925369"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb/Ltcp2x3eSJmX+hfwD1mktUwkJSRFs7iXXy21O5N5AkHRCil1KUkgg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            "], {{0, 86}, {346, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{346, 86},
          PlotRange->{{0, 346}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{350, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "aa3a9a57-6f63-4938-a64a-fd25abe4674d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb/Ltcp2x3eSJmX+hfwD1mktUwkJSRFs7iXXy21O5N5AkHRCil1KUkgg
WFlZ7WpXNlbCRQhCkIAECZjCgAc8hYXFzswaf8zoGn/svd/ned4Tv3AO+/XR
mTVr1ixnZm8//ukv/+4vjD+8XC6/+2Pyv7/4xT+ov/3tL6y//BPyj7/64Xe/
+fUPv/rbP//h73/161/99s9++Ufk4F+T//7mDy4X+vlx6tSpU6dOnTp16tSp
Uz9bdW33wtVNmcRZ80oBRZpk1QsFrKlrX2rcbrVZkhT1rqq6pjjosdc66CMK
PMVU36+GophpO/v8klZjuPENVdXtuFrp0f2WtL5+uVzMXFLY5mhqkiu5Pn4h
HSRX5XK51s8XIFebaJeL6iRr53Rt8/rYaGLahnhXIw56bKODjtu/VeCHi8TY
B+XsDe0ZWavXpy7xrHG9lZ3w+SV1hUlCK5GFVpfdPdKfyjXeY9WW2sg1DTvA
K9uwZKxLTV7IBqmrXhT3ldmFVF1BGufci5VTmsR50X4qSDvOqqOmGo95bLWD
nrF/o8CPF70d2NJg/kBtj6x1QV847eLzWD5J3MtKl9m85Q91qUoKSucl8fkz
87SL4qxGyJolmFVYRZglnWDremyjzWeHp+PvzQbbt0qx9i4D+0UzW4mD2qZZ
lN3RU7tsng067H7X0oq73Hsx/wjBgtkvdQJ+E5Z0Eyq0XQclRhDNBoqT7jJJ
rBxrJT+ZRQppF9fMjqyPrHW1KR13zexzl9uqanueSaaPRKoVs5t0W95d68Kk
GGEBpjbZVe+P2X7ctFl/FZUBMdOErsn+rQ0pfX0EzSy5BgErUzG8vExslVll
p3B95puKGYAp5K5hsIpU082ruSVtmTim2p9g+Ww+xbIBm/dmAWmdHsEfytjX
hrKikhbf5r6mO1HoDiXcGq4tdRlqFzUY1tNN6isXI122kPpH9fvT2sBUDT9j
rSCTgJvTu9IJ8wc031JUD0pBaweDxw7x6Xl1etVZsxXn3hdCfOjcbr3fFDMZ
ZpJF5PXHVHqJ22cDpL/IwbvT+1anftGwbEBmqoruDusaWq/iRBXXQY8qCXrr
LlqQ1qv2Xywvanuf+ZrhhoFNj15jvsCpmxQ9SNjuTXuzVMPrh2dxs/qSZ+GB
BV9oa6p9B+90IbHD8PtwJQ0zAhJBWegP1l2u1L1N0EeUQg6bQYZHjmj/0g99
nPs+2KeR29eykPlAQ4+8dm/KyRpsyCTT5yZhllxvcZbcaIXKtaLz1pty0fwo
zbOQDjTNI1ZGtIlWUpYJCRf71nR1fHPIH3XnFkV0BRNdibsUN8yK9G4Mq+AM
6pLZjFgSxDFzJvG5FyYQxioEHjSfnszWF16cF1loG1ZSzS3JibN1Ekw5MZUa
fS8fQzZIu0cd0eWwdcuh+zwa9mQ4FZlHR4ZdDuWTw7ckZePFhXE6+L8ET9yH
uKKNRlJ0k6jTXbgB21krNBipXpLFV/rRrsST0dqbMrvB52sQRknekexB48cm
PohhoAUkYw8+tEjPQYyxLmhSD8agG6dJAFHFKkL7Cw6SEsI0uVuqLBs8Yof8
zWQLmzqmTr5X3dhBZFBQOwwHajTse4HbfzFucRr69KPmJlzbNT8M46ziepw2
QbW8JI1dg46uIG+pV5Xeq0SJo7JIm4cHdvukYXkxso6mMhiYakRPq52+wIq4
wXTvWZ4FtsYmSCUMEMV0wyhMimY1cnr7l34Y+8j0blGc/YQVMh9o2JHNkbWi
Og9JVSokK/4zW0WOe0o1rVWddo3aushTOm9QSbR3d4uFaDHNVrpUo7HajkXB
7a/rWMxDP3Z5ANkmW07alpbYEcv5De2Ufk3UetM46pMh87nlx3WHWTKoqcos
YXFOi4Kr9DAOFGonu6G0gUFvrSUY3ZY38g/SfDhTieqpZDZ8RgOKm9kPky4j
BZg3bL3fzrOBOrWi70S2lKYOb2fZAKkdZtpa2o0XXm4kA1BnV1eWMJkPQ+bD
LqDxTm6sHTX2YhUPsUC0v+Cg5vSr0X5ujwUcuV8MSRLK1/x28g94daxxvGRh
fzCEUmTTPsnavmf9rO9HsUA6UkCFdWEhMXl1Izwk9ns5uXN4dMZEzg+JT+gW
qzvN87qqyKPgOrSUhqLqbEbOaD/mB8HDaCHLgYYNvdWRta4rzHBCyH7c51nE
9jdK2vA2dyADKxpMc1SYkLSFZ7LEphAb5pe3yTCXGaR5bNrmwkwpmgcVakk/
Srheno0jNjXqksBm8y/NCqpFQ+o0YIZqOjVKc/j7DmTmIGeF+3Oj9aQRdxi4
kicD2pRcZ95J8neF/MlrLRv0E7yponk2QGrnjxd3a243ZAPOh2NCbugswQrn
VqH9xe4OQwmrOy21S4dQRO5RYwoamtZ4kNlnFyztD8fFyZAV4Rxt3FvgC1Sm
AmsbJhMN86qbiidj4YGITvB0P6OrbzuMia/MsKTfoegwurrYY2so1TBoKEEX
CGEpj5zRfswPzP99wsELwQba4ggclYysDXV1Rr1jh7PPg2299SXtI9op1LEX
jU0ZCtoT3PKkre50zavQ/uebBnPd5V2SZRgvLh8LIZYsxo5sHLEC8siHdUQq
OpneK4kp7B/+MLVg2UC1giigHX2jiRa+w4J1EK/tbECmyleylrp6lkJmu3hy
boR+J7Od92QDsLWmw2eYP0y+FlKiMDZVt2/jODdA+wsOGsPBVj43eNBoMWlG
vNFRxW6GY42+3i85Ea9O9l/uQ1DEdHmip+08/4xzA1bg0NzK7rfToWmD/9fC
AxOtVLNM9WKT+zFtqX4lvakH3RC014jZN+678slnR+SgfhD6CC9kOJMbaNiR
lZG1qZxOHId9g/Ez3Asumh1lRR776nBDp0uwi5GUdZHATZbODSpX1663pG7b
nCaNPhvQ3vCisizqroUZqepHeV2XceAG0GTYGYBQ7DLibNW+t6hVi1W2JBvQ
OXbqm5rl5xVZTcc6zfC5aAnNBop1q5oqggzPzQ3Yfbym7VOciq55aeYw3LCs
SWPvrh93a9mA5vp+ulbe2d3HYUkTaR390pPcs/OquNnaaIawUhgrmu8bYNkA
RpCf5EVRdU0Kk55rUlRVmfquD8voZTagvi3YUsGPq6qAVTA7B+0vGF9kUpoW
VR5ZtIX9gmjZd6Q6dmdTh9vf2LQKdmY0O8irkiyYTbZS4+2HyRXse5Rp6MA9
L5q3nSuQbU2Q9XVR5syZbkqbCYGq37MyY5uuMIlFwgOzv0nYXBFCokvZtqMF
X/Ky9b4TFXWVskky8xhM7O20LPKy2Y4c1A9iH2GFLAcaNvS2Rta68O8UWDZQ
++13cuNM2aw/v42HbFsHJ9fjVjO98XoJ24+Nxr1x4oKu9Ax1POcaFo/F7Hq2
78FZQv86ZgO6QHOHKZk2ZgPyiSarIvK0aW7lwPAULEn6aR6dKV4NRZ2yQb8n
Btuk/XohHTYtobXUpfyZvGE5TCr0fpXBVoXDb2Ow1k1mGI5nqbNWCCZxtchq
J73Sf1kAs9kmv0/TTMWIyk70IVTUL9YaNoLgRGs6B+uvRxWPX9CY9GY5mbfY
s+pCMIhb5o9NG2faVHaQYvbfRvtV069mDpkX+Ej8aXFkD7NlUsgQCZpD4hOy
ARIeqP0tZACN7QCT3iTNVocbcTlE00W3rHEzAb4/AjfCptZG5KB+EPsIK2Q5
0NChtzGy1gWZ+drMPsOtxyW92TV1PSusret6/i1phxykh7hvS2lJ5JzhnxnM
rljRdCYgfifCW3VQYLH4LS1vCZixu+COXbq9H9NMp9XcVifVsnXUpENm7DCU
+pb7nlp09ppklmBFdEtvoK3bMrZZRAtm//KXEQcKpAeraumCeXg8YT9uG/Uj
d3RP5KBmCycsClkOtMWR9ZG1LrbKUA2XpMrp84/CvOXdamMPvgeDeyIsMy9+
KtTFW/X9qEuju0u/flPuw28o0db9bPS9t+57t3+h7ZG1XYJ/NQwbpnXD559y
66J4yE9n3mPz/Wqatsd+/tE1ZV4u72K8Vd+J2HfliuYn0/6QpHU/E33vrfve
7V9oz8g6derUqVOnTp06derUqVOnTp06derUqVOnTp06derUqVOnTp36f6U2
DQPPD6Jc8pMqSjxOV37E2k143XeCdl9AGbf5bjox37r3kJlfBkR/rvbjmg+6
60injNd8CTLqbm2NlN16G0v5qDKvf0qE4cKW2uD3tumA+nkraHcdZbxONgQ6
sX2cTvwWMvPrgOjP1X77j7nrSKcwsUfVXOnvdd8LBn+DBte9k6v8sYIHac37
2hnr/F7GHKZP4b0VtLuKMt6AAD9LJ34Li/V1QPTnar/9x9x1pFOY6sTXdSuS
Don3gsHfoMF17+QqD5KylA+XLmHYQlHAmJJQKXrbXglvET48miOB8q49bMY/
FodCgCex50PhfrDJo97KBnuJ1v3xtjvurjnCFy95XzAseb9477+Ga2b1ZjMa
D2b1VEu7fEzvcDB3i+Y9AwZfBSbPzV49uMIGfw9XWcZSxtC1TeYrF5PNpOrE
UyiLGIwsbqqcpQzo4JsPQI3f/dNv+oe3yWzqRxw1vDU3yO2BOTyCdmXo40db
MNImtUfXlAurbjJSNdy+fg5lXCV+/3S+YtwyDAI89yYAWBx38mEl5VHj2eAQ
0VqE8ca/xwHRiN94hO+P0pI3gmGF9yshMz+LawaLqqQHNii6AXgjCch6AU8W
s8HcftrSi+HCzbQrrhrlZ7Z5oA6TfJTF/dian8zB4KvAZFKdRjzi24Nzbise
W2GDvz7P3GQpo+jarrxfBg+HMLoZXwuwtFYpYfMydDAZLWEU/8e/3wcabVL/
OIcgcRwzeTZoZryyCa28QB8zgo2VlFUGRGXdi6q2ZwXbQZTGAbQXmJxjsUBD
1ZywLHPKsInKOQQYCYIeDeTs4FHjPXiEaD2D8f6IAaJRv/FXtaslz8xAocEI
71dKZn4S10zGFIwKPYgSxsoGRiICsv7vJTyZywao/cWtB1DnACmLa9I1zphX
URb34zgYfAWY3AetYt6TLGI0aUDEox5bYYP3c4N3cJUlLGUZura6Uu4H+VBa
DKSkB6TPfIaIlLCUIRuMOFmORisBJG5kA4xeKIEPU+y26rK9ysJg6EIwUh/I
/C0kPYYSHZii9HLF9LJqtlLoIcCoSYgPx0mbwKOWZIMDROsZjBcFREuNHK9a
KRkPhk3er5zM/DSuGYbnBFzK5CBrBJ48xQkOPR6QVjTH2IvB1RsgsrgfB8Hg
q8Bk4a0fRBRdIPOYxB7e4Ge5yntYyv8jQdcylL1bUCq1maYBpWHXlM5EQ0jC
UhbnMBwI8c3ZYAkYbO90AmOEWR77Jpve9AE/Lic5zPhYbJ3d++WFaoZFc8gk
zoc4j1qWDY4QrXkoKwqIlhs5bpivlLwIhl28XwmZ+RVcM4MNjrzlVZD1Cltb
wiseGkiySLWwBGVxM68cAIOvApNnDe93RSSDSM4GH0t4A1dZwlKWoWuZA1Xb
IgutO7vhWo7VJ2oJS1maDSSo4fdlAzYbpC8dUjQjYMhZxgoeRk1XQEYVs0Fv
KHsD1PQWj41dxJ086rVssJNoLZqKAaI3/NZXLSsZDYZN3u9/ScnMT+Oap5dQ
jDZvgKxRtrbM/oqCV4EUupgb4Czux+M5MPgadXmYcLY+zB9qfBCtsMFVPrO9
ylWWsJRl6NphKdevXHrYv+6zrReUpcyjg0VIMo4ahhhQ7vR9Ihghdp4NHHk2
aCDk3aKuq6oaWHPMSMWLsrJnBZs8hbgrQ10171nZtlVgDtmAhwAvrWr286i5
1vFk5gNE6zkwGQVEI64Tr8JLlgbDHt4v2vuv4ZqrUIEozKoqvTtsDjNsCwog
a4ytTecPBoBGUegxbHbR1V/qaMO+gZANlizux5Ng8BVe98VwbiSqQqjFpHs+
qMckbHAult7DVZawlB8SdC28DkYdkbNVCElrnKDiLOUJh8siYfyRD4oaJoVC
EU6D829FzjmULIMPQ8wLMzQaO930RcO0nT5exb00kJR5Y3vXPAT4p4VVgORV
tD08aq51PJn5ANH6MYPx4oDopevEqyQlS4NhB+9XQmZ+DddcAHSd9QV9+Yk2
BpIAssbY2i3sEfcz57n9daSOcct4d+TOy3kSZXE/ngSDow4UlnjU6uswfjGP
4fZwsfQervIaS3kHAxbTAbzvAwf8UmosfDOLEGK5N5RtFQ3r06js6Fe+XZPT
u8m4RdauMnwxwu8EAZZxa7t2F496bN1jJDMfJVrv0A647qLkjWDYwfuV9P5L
uGYWhHNr5iBrjK3dHoYez6ud2/ISGFw0gCWftHf24qcFC4+h9oyx9B6u8rdl
Kb+kJSG2LrIYflRw3fOL0yaBG2VC/N82JSxv4YWG77bqDWre3AtPGvluMw5p
t80IyPpD9GYw+Ow7hW9q2HYJH8FSfklLQmzKZv6ak+8a0x0/PaPvE31qj2XT
qjeoe3MvPGnku804VvlOmzGQ9YfozWDwNoPfTb0hlE6u8n6RiUGz/LnyqVOn
Tp06derUqVOnTp06derUqVOnTp06derUqVOnTp06deqD9DZG6349Q759PANA
frKiUz9XSUKozX6GcfIM3PXteN7tMXucfEu1DkDeqOjLoXG/D02ExS/hQIoV
fAWHLgshiBPJD+NfZRd/lp6Du74Zz9vRJ5qv67+KP06+ZSWvAJC3KvpyaNzv
QhxW+ks4kOLW7ScZwlSyEFoLyFfZxZ+lQ8xklPc7/h3FvcqeFGsb/pmylGdr
4Ncuybd44V279dvj5WUCgFas6Cgat0VhuBjAGX4oPX/C7yDLV5hSIdRiiTdw
I8XaD3CzxdbNsNJHHYjE0QbUGjOHO51kA8VZcOE25gvdomvEv1LEczbPBqLp
r7CLP0vbzOQt3u8mIJfHEZMqnNutRwQoZkKmUm02PuF+WfCWp2tFWhpyAgWX
3Xp4lKJqmqLoXsMBkB+UgRwMxAItoM92tVnojwyD6z1fVLQbjUurH3kIigNF
SQHOjybyepcqusPsX4KpKe/CUo2B3FjcrB7UPMfwYq1AvYEZ2ZcWBKwXFMPL
GeuJWmyPzy1hpF+kdUus9BEHZu5AAzZdRiNAOpo+46NY/dNAbWoqagCPrgGR
+35z+kY7IWldE/QFKvAQa0au1Qw3ZI+w/eO/YMjlOSj7IYZQEXl9iSr1l7sI
yHEIvOUdGR+sTWbyJu93hYW7xBGzKixSHEQXPbmrGQVXd25RRFda+LXcIJWc
AK9eut7LuggoRkcJkrLjnswlkQD5xonTJLgaNp37VaQk071neRZQ5hK0aDY3
2InGZc/TqXacF3HQM3glAOdHDPab3j1NQks3wqpDwdQM7jqitwBE6TScGxmG
t8NbgXkDM3Lq9yCOhyc9TS9MIOxVN3k8cNQw2rolVvqYA2mkJfHd0Q2vknS0
8PzvjHgDVNski6/0o01KKCGSAc0dJkUz2Kz5YRhn6RK5XC9A2fzD3aybFMOF
EKIWcQE5HwJPs4s/SzuYycOpMt6vnIWL4ogp8IvBkh4d7WAjAGQTDV2359dv
oozxE1hH92hK9p6OVgClAiHHwnYQuqrIo+Daj1YxG+xE4zJCGmUmUDdQXBUZ
RzjAGUEWy8DUPCxuzlWeQ4/FVqDeQI3sOyXq+aAcOYRCrcGMFdLvEk89x0of
cqDPPwC81tEI+pLn7HEcRQ7NPWSwsZYlchkBZU9VdIAmG0JI7NAl3PhZdvFn
aQ8zeYv3u8bCleGI+xQzQaH5qjdRxrITgNOoWH5epK4+DC4OjegxurugLu65
UqpB6VpzZjLzxB40bnG3Zm7Q+2ywiNsRKzSpkYCpIRsMr6NakFRHg7BWYN5A
jRQ7hc8/4+cdpN+Wv4HO9pT2OZBibDVh60jS0bN6NSEb9DNz7hwho/aIs7EW
BLm8AGXzyGX6BoBwNG/sUBRuLG/4F9UOZvIW73eFhbuFI8bDe/1aco7shEdN
p4rARdbNnuQ6p2fD2mcUy3jXiN2TMyHtDGNtJxq3BkxlJO4Z4eMF7NeFF9HK
wNSQwQYU8Dplfd4KzBuokTJ8Pfd5jfQrzQbjrXWnAwHGe+PPknT0yA2Dc+jX
fNvZwOXnBsLutwS5zIGyZzcU1R2ghcNtSEIIf4Vd/FnaZCZv8X5XALlSHDGr
enxBUj/X8qKyLOpOcu1EvpUVDt//3rOBizzlFlYjY/JrdpBXZULXhDHbSXCi
oq5SNv9hL1UZEbuPA2hcIFJq16SoqjL1XZ+YJHu5A6wLLs49rcrMsww/rWVg
anC+fs/KjG3WYahkvBW4NxAjxdLQbLBC+sWyAY+VPsIWhp0Bi/QqWX2bhlNI
IoHN9u1bQg6ynU9kpTDZxpY5dloWedkg34WJyGUElM35p2BLBT+uqgK2aPoO
RQnhr7CLP0ubzORN3q8EkLuKIwbRlUI/p+qicSuYdBV6LU++xU8oryIXmb6Z
UahxnFFT2QG5X5RDtRfdouHWv6aNR+zuROOSCMzv04xRMaKykwGcx8UXyCBD
9iEBUzf5bSAAa45joKhkSSswb2BGiqU18KrcPhv4HNRaQvrFWzdhpbsjDsyC
EXesmn4liyKuvYZtD+0ViNy8bfBlARRwjQWbBxN45DICyhb9c7OHb34MazqO
E8KfZxd/lvYxkzd4vw8JIHcdRzwTw8iuXiuQb2cnwP1LTxvGRW4Tz8Bf6reA
P2M2ThUdROMeoEQjDUTB1F1Dbu6bJc4KW/XGIZQ1b8l+1PCElX7GgaJXsEgg
5VcH+NEtBiPutUQuo6DsuT3L4zO3vsIu/ix9F8zkPQJCrHrPqq7rarboG1/A
8aTejMb9SH0DbzyhL+7Ab4dcfp1d/Fn6DpjJu0Rma+Y0W1P0a/rqEyVvRuN+
qN7vjSf0tR34DZHLJ7v4a4hxkb/YnfrTdHrj1KlTp06dOnXq1KlTp06dOnXq
1KlTp06dOnXq1KlTp059EYm05DqLfM+7RVn36KTfa+8FLD9LRW6KJM5WfzUl
t+09OjHLMw0Ofy9bmyutKdIk++AXtSNa56k9RWflY+lbx+1Sx6C1PC2Z8Rzg
8Y5//jede/RDfslq0U9RkbfLhwdyJbatlHqA9/u/T1r+LXSQGP8tsMaTw9/L
1uZLo+zTy7X+VCxzHkw8q6N/lWoaBULcrpKfeSe8hGs+Cq3lnwnlCTORaxoT
FFF6yZqeoyJvl79mm1xHeL8/PWn5+7WHPi1e8A2wxpPD38vW5ksbnhD8TCxz
nfi6bkWSctf/KtU0CoS4XSU/8054Cdc8h9ZKkLXT+VyPdBmHuJy1iePWsksA
jYWhg6drJtyKQFSWGkarofBaRvpqhFOltUxtmp+zvKvu5f2yxz97yzdw04Lx
nXCOzNJu+rz0gXghSp+WFD4ePIo1Rq1E71yvZwMe74xlA6rj9m/SoeX2LCNT
KHcDxbwdHks2OAgnP3PinfA0rpl7wJzkImN4utxlD1wsSbljj1B07fBMDJkO
Zb7JnqB/NNl1ePzc9uMBlKS4vjPAmG94dEBWtPxAICpT4Uzmu9NbqwOlJekx
VggoeLRNCjFup+foNV1TLqqfsUfm9/F+Ga3FcSfcdCXFTQvYXkjgGC2ZEYBv
gy/0e1aE/VP9yojTmfcOQp9GepCV7AM95LqgBsmbSaagiu4OLxmhpGXFoTRF
pHdGh69kg9DWVPvOZsHhVVcMv0cNk2qMgF6xwDvLssHebtqmQ69BquesbxpO
gTouQBbA5+mvR2jkfDYY3CiQn3/4Vw9FPe93yIpGaC2bUHlxXmShbVgUAiQl
5dIe6er8RsejcQujrOpGkFEEINqkLBMyXO3bkA0uS3Twott6vpwVcETlVSaz
5YdpcrfUIRugoGAOsiSxhOFxiM1VdgcGkRcxRuZe3u9gubMXN30ZsL2VhJbc
E4BVy0+Sex8LuhOnUY/nemC9s6BPoz3ISibJK4ziojnQzJiCmEwG/GKwpnvV
ob0jOhzPBrTSi0ERol0OaV0FRBvQBihJW8agxuYGO7tpmw69AakWWN+0dcNK
GQM+T389QiNfcl/rOfn5PxHUs+iE53DNArQWotTy42FrfIWUK6wUWGoc13FA
4iTDbXpgnV2yhOvOhRKV5UzmERrcv86jt22BTeYiR4L5pTGgugw3VBgcFHEn
7xfHTU+Y1SVuesT2ymjJAteLTvwuPdEReJVa0uK9I9CnJT0I2UBgR+9sJone
IX8CPVjz8d6ZOxzPBqw0L++gpxSV8kfJHShmLCM5gxrJBoe6aZUOvQapXrK+
R3sQ4LNIEt5PI19kA9ZGgfyMoJ5FJzyFaxaZyY8uCWw2l9GsoNpBym04jBXn
usIzWS5UrkD0kgH05kKJymtM5nGyNJSPYpNlwcmBCu90ImGEWR775nh3Zift
4f0ex02P2F4ZLVk68Wv7twngvTNDnqLnYNPIfc181JSYa0WMxUpHhwQXvCcb
kMRmAy2W5jo7jEl3m2FJvzWg/LRNBrXYikPd1MPSUDr0GqR6wfoe7UGAz2I2
2B8ekmwgpCkU9Sw64Rlcs8BMHo7lkQ8Tp99vknLxbNCbVt3pOlchIXMwG4hE
5RUm83CwzcbyMWzydjZgvQmXaUbAQW538n6fxE3DlRJasjQbDJfjHGMR+Iyf
s8wGe5vZY3zM+42O42wgrC5xwfuyAbxlRrPIOsiOG5jg6VeSlvWg28GgFjLk
oW5a48HuglQvW4cAn5fZYF948D04zwZDmnpgqGfeCU/jmkdobeqbGrmrVk1T
xjpN2jlOyp1oyctsQD5Xrq5db0ndtjlttTwbLEGyOFEZBdJCr5H1SFpUPU0X
Jk4oKJibdUuyQQPd4hbDZeMO737e7wHctDhAZLRkfqWwzAZxg3OMRfo0fg5f
8rFmPgayMV3Qs/kMjgueHD5GC1Zyk7AtFLb0TtmmsMXef4oyqLnYg/WOzZaj
+7tpkw69B1KN7IogwOf5SmFnePDIbq6nBPIzPSCingUniJ8PadxxLSJvJNaS
6GR+XpJyeVoyzQZTxDJibT1u9V/oFk0yoLYXcN0lSFZGVEaZzFU87p+b9I7C
ysdBwSNNV4b5hX4RpqXMx3t5vy2NZEXbhZteYntRWjJPAM7GG8dwObvPIL0z
o09j5/AlD3XtxRrT/X/YWJ/WyDgueKhijBaUGwx+I3mYeSug02Y1HH5giOCd
udhjv+3R4W0L+7tpkw69B1I9RqZAZl4An6e/HqKRc8hukQI9kZ8fvbsu/G/q
3vKdggitBVzy7CvRBSl3RktG1CGM5aUOgWQxzm83M2wvNnkmtgtBog0uI0Go
DHs+B3m/9JvjPbhpWfOe+RkqxjGe0ac3WcdHmykxH6cwj9HyFDd4XjAfe83Q
qNftn9W5B1IttXb5e4SDNPKHyAbnDvPk5znqmXcC//mQPgta+y1Ask+CgpsE
XuBL1uJkNJew3XG5FT9+bd7vu/RBWONvxg3+4lhmUCPfK3tGS9Qz7wTBIcf1
OdDabwKSfRIU3PHTafrNGd1++dq837fpg5r5zbjB30M3dW+lkSOoZ94JgkNO
PQsKZpd9xwP71KlTp06dOnXq1Kk9+j/klZXi
              "], {{0, 86}, {346, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {346, 86}, 
            PlotRange -> {{0, 346}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f4fcf2a8-48b2-4024-ba54-b1b980156909"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ca17341d-c3f1-4e02-b79b-a17f3aeb7e63"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a1b2ee23-14e1-4e1c-8c63-aa17d3a55b8b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"5995355a-82c4-4138-a3fb-474062c7987c"],

Cell["Find letters that appear in Ukrainian but not Russian.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"ab5740de-7acf-4579-ade6-4f82287dbdb7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"967462b8-f058-460e-9898-74739ae113c7"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVaGO3DAQtVpSWKlf0B+wCksNiyJdVWZyp65PJdtor1IVambWkMqkMgoK
CgpasiigS0JCDJaEFASEGBikY2c3F90muvZyJdWN4sjxjMfPz8+T11efL9gz
hNDNC3hdXH4lm81l9P4lfHxY33y6Xq8+vlt/WV2vNm+vnsPgK2hvoLl+92T/
v7UJRShQ7bnH6IiQRNvukBIcluZh+ZtcMPwX09uEIUQn8ZSAVJbGagWI9xMR
Z3mCbz8YIZQXv+xxtJQgbCay2g6R1hhrZ7I8nhkVIES+/8wV7AKL4ohnHyMU
n7hp8jhEJ2NJNZkniwISpjO7v8/LaRDAA424NYhsuq4CZDhu+ojS4fHTTcpc
COVqu9umUsS5nsrZSnLM8xAvcIIwZSFjLIQXz2DpEuZg2W9Bgzo9NqtTCA3i
/XSmUU7Ps5xh4E+86o5UK48BpjR6C8dD/Nm1eyckhANKKSgs1XP6Xo7nLns9
FSKrhEew9e5e2JhGcSw4j4t6TtGPgOfMayR2UGxTcejwrRuqlDsvWc7A+Id4
+qVVUUNfp3Dbem37YISiZHeo63KXpbtDZ6sII8Lz0eF5TfY5l3hH5jUs+7DR
/XIFVjIy3HfHlS9xvdhu9zjU5yXekY3vl68/Yhxg2gasNUf9OALxHP+LvINV
gOdEWn92hMnDlH7r3JXHpJwuJ0u8JzOFihyA2zpjikRAYaqm7rdta13P/tiW
eIfVcxGGXOl7SXyyrvsNB2g+wg==
            "], {{0, 19}, {48, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{48, 19},
          PlotRange->{{0, 48}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{52, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bd7d152c-e546-4f64-9c3d-aa422ddfa3ea"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVaGO3DAQtVpSWKlf0B+wCksNiyJdVWZyp65PJdtor1IVambWkMqkMgoK
CgpasiigS0JCDJaEFASEGBikY2c3F90muvZyJdWN4sjxjMfPz8+T11efL9gz
hNDNC3hdXH4lm81l9P4lfHxY33y6Xq8+vlt/WV2vNm+vnsPgK2hvoLl+92T/
v7UJRShQ7bnH6IiQRNvukBIcluZh+ZtcMPwX09uEIUQn8ZSAVJbGagWI9xMR
Z3mCbz8YIZQXv+xxtJQgbCay2g6R1hhrZ7I8nhkVIES+/8wV7AKL4ohnHyMU
n7hp8jhEJ2NJNZkniwISpjO7v8/LaRDAA424NYhsuq4CZDhu+ojS4fHTTcpc
COVqu9umUsS5nsrZSnLM8xAvcIIwZSFjLIQXz2DpEuZg2W9Bgzo9NqtTCA3i
/XSmUU7Ps5xh4E+86o5UK48BpjR6C8dD/Nm1eyckhANKKSgs1XP6Xo7nLns9
FSKrhEew9e5e2JhGcSw4j4t6TtGPgOfMayR2UGxTcejwrRuqlDsvWc7A+Id4
+qVVUUNfp3Dbem37YISiZHeo63KXpbtDZ6sII8Lz0eF5TfY5l3hH5jUs+7DR
/XIFVjIy3HfHlS9xvdhu9zjU5yXekY3vl68/Yhxg2gasNUf9OALxHP+LvINV
gOdEWn92hMnDlH7r3JXHpJwuJ0u8JzOFihyA2zpjikRAYaqm7rdta13P/tiW
eIfVcxGGXOl7SXyyrvsNB2g+wg==
              "], {{0, 19}, {48, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {48, 19}, 
            PlotRange -> {{0, 48}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c80e3c79-d3a2-4428-b193-47824046cee3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"85718a5f-c48b-4e7e-9d1e-02e41f282119"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b19989af-147e-436b-98a6-9567e8f9ace5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3faf3349-89a3-46ad-907c-ad66c2cbf4be"],

Cell[TextData[{
 "Use ",
 StyleBox["Intersection",
  FontFamily->"Source Sans Pro"],
 " to find numbers that appear both among the first 100 squares and cubes."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}},ExpressionUUID->"f9f77ef3-1524-41ea-b608-426678032339"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"309d56a3-8b87-4529-8eb6-3c0a9358f829"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVq+P5DYUjlpSWKl/Qf+ABpcGljTSVWUBvVM3p5JttHdSFRqpwFKJi8yC
goKCgkKCQkwsVSYGISEBASEGBtv37Ewms5vMrnrSlcyTZibx+P36/L3n9+27
39/EX3ie9+Er+Hrz9o/g4eFt+tPX8PLz/Yff3t/f/frD/ce793cP37/7Eha/
gc8v8MHnx5vc5CY3+T9lqkns+4nQ7nVWQvSzua5jpr6tq7Kq5agv1kfFuTzS
1mMvLqW36lMv6rIsq6afzppmUg166Ib5VVlIzvvpFIwZ27osykoM5/CODI6S
1+icW+dzEQdBlHXjEsksGDTqmFSDeVRl6lkh3XQllFkW3kYKucbQZ7jgdwcZ
CRp4l+JTzvPYPvl2IWgGDEzL0r67xbAdXzivjoa4m3QuDHL241dKXzHYsWgT
TqqMkXUenU09zpx6HnUZ9k2RJeiI8Sv4TDbL1LqdSsJWePjiK+SHJ26MNiCI
VR7anToPvJBxa7gD/YDCsy5CDHHA+ATA52ftFXC0Kl16zs7Q4CmXCrz0+BRX
5sjgUKMWaWGrGVrCWoeahNh86iDQAvHZJCTBEj3GxwyVJdhTCIwNMkxTSPeI
P5vdEqCIComP81oVM13wmVmA1FoCwvPMhkNbAwFSBFHkO11TJfDKXAiyAN1Y
6n2DqgSoIvmMmwJ3LxYUWDhhhaJ5cBUfy7ewlUDDPC9quXSMEYP06TiL0Ate
xKfHwGL1NLAh81wWE/PP6QwNLB/aFJisV/dDETqVmS1A2Wywe4DurkFTJ0Ck
ppdNzlhZn1kvLSbwCh0LwT7V2qvwsf0KaZtmkW87xuiCdLQRgReIF7oF0j7M
xV6mfm37D2dY5glhNHM1G+3WrOmRzGmN5II6DZh03FvxsdEGoLtncLZrlvVZ
Yn9zl7arBVJJYltWswXjdfiUy9krsPvjX387L5RRYh3FKWl6fWTBVX2hLjYM
DcaSVmqNQ9RFlqYkrzn+FfIde3NuE0wIpTQLXQdq/tnjz65BRNKLFkzm807c
zGwjN5PM4CFrNkcisP+IwwqxHv12wQ/J/N2fBaOUMfiilCz4tMf49DXQJxKb
/3sLTvyMUU6w3Qb5njndgmfnl5LQtwxoVZ2c96sCC/lJh1kNcoqccztNX674
aJmDrbxDWqoS+Ob6j4bJR7T4V1q0UtjZwcgUjiOrN+Fhl/AiJseR23kglxsw
DdYXd/Hs6KJgVKfuhwFUdijwklYIzruuE9DSZJnByKGGvi3QBWnHKwadM1tf
iLBjeFaJUTXR6araNagVDipJ0U2TslNG4srC9uQFt/P9pXl4OZxQqFstIjum
bPlkhmYdGtKCXx4plOeJpXu6j3g7hOv9gq346UyE6rIi3nMXBwatYLGsPW2Z
qWzR9zblfYO4np2Ww+p00Nv7y95H5MqFgwTbHPcK0jxNs36hER/ovk6MnsDF
pYfXG9TzM+09g3Ydt245KbHFL15crQUx6/dyHbCYvUJcG6eP5FN0P4/BPdFd
jgW4dnhcKUgcZ3K3qudBDcc30VX5FN3PY3BPdE2SJMvVfyT9TW5yln8BNlXw
kg==
            "], {{0, 19}, {96, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{96, 19},
          PlotRange->{{0, 96}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{100, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3c93d4e3-155c-45ad-aad9-200124d7ecdf"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVq+P5DYUjlpSWKl/Qf+ABpcGljTSVWUBvVM3p5JttHdSFRqpwFKJi8yC
goKCgkKCQkwsVSYGISEBASEGBtv37Ewms5vMrnrSlcyTZibx+P36/L3n9+27
39/EX3ie9+Er+Hrz9o/g4eFt+tPX8PLz/Yff3t/f/frD/ce793cP37/7Eha/
gc8v8MHnx5vc5CY3+T9lqkns+4nQ7nVWQvSzua5jpr6tq7Kq5agv1kfFuTzS
1mMvLqW36lMv6rIsq6afzppmUg166Ib5VVlIzvvpFIwZ27osykoM5/CODI6S
1+icW+dzEQdBlHXjEsksGDTqmFSDeVRl6lkh3XQllFkW3kYKucbQZ7jgdwcZ
CRp4l+JTzvPYPvl2IWgGDEzL0r67xbAdXzivjoa4m3QuDHL241dKXzHYsWgT
TqqMkXUenU09zpx6HnUZ9k2RJeiI8Sv4TDbL1LqdSsJWePjiK+SHJ26MNiCI
VR7anToPvJBxa7gD/YDCsy5CDHHA+ATA52ftFXC0Kl16zs7Q4CmXCrz0+BRX
5sjgUKMWaWGrGVrCWoeahNh86iDQAvHZJCTBEj3GxwyVJdhTCIwNMkxTSPeI
P5vdEqCIComP81oVM13wmVmA1FoCwvPMhkNbAwFSBFHkO11TJfDKXAiyAN1Y
6n2DqgSoIvmMmwJ3LxYUWDhhhaJ5cBUfy7ewlUDDPC9quXSMEYP06TiL0Ate
xKfHwGL1NLAh81wWE/PP6QwNLB/aFJisV/dDETqVmS1A2Wywe4DurkFTJ0Ck
ppdNzlhZn1kvLSbwCh0LwT7V2qvwsf0KaZtmkW87xuiCdLQRgReIF7oF0j7M
xV6mfm37D2dY5glhNHM1G+3WrOmRzGmN5II6DZh03FvxsdEGoLtncLZrlvVZ
Yn9zl7arBVJJYltWswXjdfiUy9krsPvjX387L5RRYh3FKWl6fWTBVX2hLjYM
DcaSVmqNQ9RFlqYkrzn+FfIde3NuE0wIpTQLXQdq/tnjz65BRNKLFkzm807c
zGwjN5PM4CFrNkcisP+IwwqxHv12wQ/J/N2fBaOUMfiilCz4tMf49DXQJxKb
/3sLTvyMUU6w3Qb5njndgmfnl5LQtwxoVZ2c96sCC/lJh1kNcoqccztNX674
aJmDrbxDWqoS+Ob6j4bJR7T4V1q0UtjZwcgUjiOrN+Fhl/AiJseR23kglxsw
DdYXd/Hs6KJgVKfuhwFUdijwklYIzruuE9DSZJnByKGGvi3QBWnHKwadM1tf
iLBjeFaJUTXR6araNagVDipJ0U2TslNG4srC9uQFt/P9pXl4OZxQqFstIjum
bPlkhmYdGtKCXx4plOeJpXu6j3g7hOv9gq346UyE6rIi3nMXBwatYLGsPW2Z
qWzR9zblfYO4np2Ww+p00Nv7y95H5MqFgwTbHPcK0jxNs36hER/ovk6MnsDF
pYfXG9TzM+09g3Ydt245KbHFL15crQUx6/dyHbCYvUJcG6eP5FN0P4/BPdFd
jgW4dnhcKUgcZ3K3qudBDcc30VX5FN3PY3BPdE2SJMvVfyT9TW5yln8BNlXw
kg==
              "], {{0, 19}, {96, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {96, 19}, 
            PlotRange -> {{0, 96}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a6251ba8-1994-4f07-a457-658ef8bc380d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.15"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"69dd4ed2-234b-4f7b-81a8-e5ab13c6e9b4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0e9c7b50-1898-4d3b-a668-8ea3c0ad4d7a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3b6c1b62-b782-4dc7-83f3-0bb9daab7e17"],

Cell["Find the list of countries that are in both NATO and the G8.", \
"Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.16", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 16}, {
   "WebOnly", 0}},ExpressionUUID->"457fe3e3-f62f-460e-8585-93910a595679"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7de03d26-8002-4048-9929-86384542297d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd9PKtkdZ7cvfbTtY5s2/QP0zW2fTHzgoeFhE5qSPqwxu6ms+8AW75Z0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            "], {{0, 27}, {
            500, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 27},
          PlotRange->{{0, 500}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{504, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2210b8ee-807c-4e00-98e3-37d5958d8c67"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd9PKtkdZ7cvfbTtY5s2/QP0zW2fTHzgoeFhE5qSPqwxu6ms+8AW75Z0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              "], {{0, 27}, {
              500, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 27}, 
            PlotRange -> {{0, 500}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ad5f8367-3072-45ba-87f3-67b58ee28b57"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.16"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fc6fbe7a-bdf1-47a3-a221-e900199faf8e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"794751c8-7fae-4133-80c6-3d9494c72a17"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a446bcf6-8f38-4772-a520-543a72bb8cc2"],

Cell["\<\
Make a grid in which all possible permutations of the numbers 1 through 4 \
appear as successive columns.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.17", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 17}, {
   "WebOnly", 0}},ExpressionUUID->"5ca9d112-9508-4072-807c-feb5e7e847ed"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cbe093a7-10c0-4d25-a366-c4e24a2af0ea"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnC2P41YUht2WFPYv9A8ELzVcFGmrspBd7cyqZDqarVQNDQupZBYWFBQU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            "], {{0, 73}, {398, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{398, 73},
          PlotRange->{{0, 398}, {0, 73}}]], "ExerciseOutput",
         ImageSize->{402, 73},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a66393fc-dbf1-44f8-b045-dcdeaf6b7b40"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnC2P41YUht2WFPYv9A8ELzVcFGmrspBd7cyqZDqarVQNDQupZBYWFBQU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              "], {{0, 73}, {398, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {398, 73}, 
            PlotRange -> {{0, 398}, {0, 73}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d735a645-def7-471a-9664-b275dbc57db6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.17"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6e2c2e82-5904-4443-84f5-f275f6b57a71"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"dc1e734d-b3bb-4aef-813e-577a740498de"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"86c521e9-7290-4fc6-907e-42d663ad9e81"],

Cell["\<\
Make a list of all the different strings that can be obtained by permuting \
the characters in \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.18", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 18}, {
   "WebOnly", 0}},ExpressionUUID->"44649a7b-c35d-4114-b433-394f18eaa1f2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9cd3ba6a-d540-49b7-9d68-4d102e3a8eec"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb1vMtkVxknSpMy/kH+AOi1lKksbpaPZVV5WkaKNtRspcktH6Y6OiorK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            "], {{0, 108}, {465, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{465, 108},
          PlotRange->{{0, 465}, {0, 108}}]], "ExerciseOutput",
         ImageSize->{469, 108},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "eb2ef210-9497-4537-b7e2-d2b9a9a9b39f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb1vMtkVxknSpMy/kH+AOi1lKksbpaPZVV5WkaKNtRspcktH6Y6OiorK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              "], {{0, 108}, {465, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {465, 108}, 
            PlotRange -> {{0, 465}, {0, 108}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5b28b84d-98b1-4220-ba60-103a75351a28"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.18"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ad409b71-4c83-4804-a1b7-425bfb631e3e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"53a2c70d-405e-4925-8d96-1d87723b806d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a8d032ff-a520-4c3c-bf3d-fbb501ac39cc"],

Cell["\<\
Make an array plot of the sequence of possible 5-tuples of 0 and 1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.19", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 19}, {
   "WebOnly", 0}},ExpressionUUID->"7ec215b3-3119-4fb0-b945-e7b805d4b7e5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26bf3f9e-49d3-4f24-9eb1-053429be3461"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt1zFuU0EUhtEHNJRsgV2kpYM2iAUkwolojOQgIRbG+owjpKdU9s8w49xx
zlc4tqXcuWcqv/e336/vXi/L8vD28HJ98/PDbnfz6/O7w4cv24dv99vN10/b
H5v7ze7q9s3hy9+vluXj4e/j+7tLbL/f/329pLjmimuuuOaKa6645oprrrgq
tMRxVYiLq0JcXBXi4qoQF1eFbfOZXOPiymdyjYsrn8k1Lq58Jte4uPKZc7ny
uLi4uLi4uLi4uLjOs/CIo7ka4uoeV0Nc3eNqiKt7XA1xdW8uVzhwme33PBcX
FxcXFxcXF9e8rrz8aC4uLi4uLi4uLq55XXlcXFxcXFxcXFxcXP+57Yi7CuNa
4xq29em41riGbX06rjWuYVufjmuNa9jWp+Nae0ZXfjQXFxcXFxcXFxdXNdeI
i+Li4uLi4uLi4uLiqubK4+Li4uLi4uLi4jqbKyw/Oo+Li4uLi4uLi4uLq5or
n8nFxcXFxcXFxcVVzZWXL8nFxcXFxcXFxcXFVc2Vx8VVIS6uCnFxVYiLq0JP
XeG/5DfwjHFxVYiLq0JcXBXi4qoQVwVXuOEy23MKFxcXFxcXFxfXS3Dl2+Yz
ubi4uLi4uLi4uLiqufK4uLi4uLi4uLi4zubqPjCPi4uLi4uLi4uLi6uaKxy4
zPacwsXFxcXFxcXF9RJcefnRXFxcXFxcXFxcXFzVXHlca1xDNz8e1xrX0M2P
x7XGNXTz43GtcQ3d/HgNrrz8BrrHxcXFxcXFxcXFxVXNlR/NxcXFxcXFxcXF
Vc3VfeC+xu95Li4uLi4uLi4uLq62uBri6h5XQ1zd42qIq3tcDXF1b6grLOT/
U1xcXFxcXFxcXFxc1Vz5TK5xceUzucbFlc/kGhdXPpNrXFz5zAquvPwGuCrE
xVUhLq4KcXFViItrrrjmimuuuOaKa6645oprri7edXnlDzXT9QdYuLUH
            "], {{0, 
            437}, {72, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{72, 437},
          PlotRange->{{0, 72}, {0, 437}}]], "ExerciseOutput",
         ImageSize->{76, 437},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "90ef44ff-471d-4025-ba2f-a025db9bd7fb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt1zFuU0EUhtEHNJRsgV2kpYM2iAUkwolojOQgIRbG+owjpKdU9s8w49xx
zlc4tqXcuWcqv/e336/vXi/L8vD28HJ98/PDbnfz6/O7w4cv24dv99vN10/b
H5v7ze7q9s3hy9+vluXj4e/j+7tLbL/f/329pLjmimuuuOaKa6645oprrrgq
tMRxVYiLq0JcXBXi4qoQF1eFbfOZXOPiymdyjYsrn8k1Lq58Jte4uPKZc7ny
uLi4uLi4uLi4uLjOs/CIo7ka4uoeV0Nc3eNqiKt7XA1xdW8uVzhwme33PBcX
FxcXFxcXF9e8rrz8aC4uLi4uLi4uLq55XXlcXFxcXFxcXFxcXP+57Yi7CuNa
4xq29em41riGbX06rjWuYVufjmuNa9jWp+Nae0ZXfjQXFxcXFxcXFxdXNdeI
i+Li4uLi4uLi4uLiqubK4+Li4uLi4uLi4jqbKyw/Oo+Li4uLi4uLi4uLq5or
n8nFxcXFxcXFxcVVzZWXL8nFxcXFxcXFxcXFVc2Vx8VVIS6uCnFxVYiLq0JP
XeG/5DfwjHFxVYiLq0JcXBXi4qoQVwVXuOEy23MKFxcXFxcXFxfXS3Dl2+Yz
ubi4uLi4uLi4uLiqufK4uLi4uLi4uLi4zubqPjCPi4uLi4uLi4uLi6uaKxy4
zPacwsXFxcXFxcXF9RJcefnRXFxcXFxcXFxcXFzVXHlca1xDNz8e1xrX0M2P
x7XGNXTz43GtcQ3d/HgNrrz8BrrHxcXFxcXFxcXFxVXNlR/NxcXFxcXFxcXF
Vc3VfeC+xu95Li4uLi4uLi4uLq62uBri6h5XQ1zd42qIq3tcDXF1b6grLOT/
U1xcXFxcXFxcXFxc1Vz5TK5xceUzucbFlc/kGhdXPpNrXFz5zAquvPwGuCrE
xVUhLq4KcXFViItrrrjmimuuuOaKa6645oprri7edXnlDzXT9QdYuLUH
              "], {{
              0, 437}, {72, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {72, 437}, 
            PlotRange -> {{0, 72}, {0, 437}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eeb4d4a9-f71e-469b-8b0d-7ad5f4977111"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.19"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a6f81971-e9a1-407e-b9a2-a98c3971dade"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a2044e30-6366-47ed-a3a5-9bab3de02aba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"74422fa5-7d5c-47e8-bb22-84b85191189d"],

Cell["Generate a list of 10 random sequences of 5 letters.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.20", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 20}, {
   "WebOnly", 0}},ExpressionUUID->"31853ebf-0a4b-453b-b39e-7f4b334d7967"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"637f5621-f524-48ba-af71-3a3b514a3450"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL3LtdgRN0mTMpC/IP+AdVrLVMKGdDa77OuyKTayb2CxW4RATBOsYmcR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            "], {{0, 19}, {384, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{384, 19},
          PlotRange->{{0, 384}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{388, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5b358f84-caf5-4b12-8326-1a5facc8f1d5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL3LtdgRN0mTMpC/IP+AdVrLVMKGdDa77OuyKTayb2CxW4RATBOsYmcR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              "], {{0, 19}, {384, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {384, 19}, 
            PlotRange -> {{0, 384}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0d41c5d5-b0d3-47e1-945b-e481e2122290"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.20"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c7d41975-991a-4840-9531-ebb581bfcc7a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"40c94210-8541-4a67-ae08-a283c696d3e5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a3fe0025-419a-4a18-b234-f28a09f37201"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Flatten",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Table",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "2"}], "}"}]}], "]"}], ",", "2"}], "]"}]], 
  "InlineCode",ExpressionUUID->"9b8a6fe4-4a00-48f1-a176-0d658aef82b4"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "30.21", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 21}, {
   "WebOnly", 0}},ExpressionUUID->"8be4bee2-c21f-4edf-93f4-e6c99b61b808"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d3885036-c7f6-4f3f-834b-ec0b2acd4c48"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmq1v20AYxm8bGZy0v2D/gPGo4VClTmMhrVZXI13UTpoyaGZoZhZkZBQU
FFJkYk06MBODEJMAAxMDg+3OTTp/++r72qr3kRq9iZ/z+7unJys+593l13Pr
JULo7jV5Ob/4bt7eXqw+viFvPt3cfbm+ufr84ebb1fXV7fvLV+TDt+TvxwuE
aP0bBAKBQCAQCAQCgUAgEAj07yrbOpZhLHHRqonyBON9Xk6dYYYt9y3TXNjh
YWSUNJg8DbebINiE8UEiTLsLI7NWGM5kZk6Z0aYVRk0yataMWJixZNpgOfYQ
QpazSctGnQQrVMkJs5FWc21lvF0vEDKccHAScmAyHBiV5+F1GcQyYPq6MDJr
g+FM5tfP2VNmtGmDUZOMmjUjFmYqmTZYHrkIuUWn3u98e3lGzuBFY0uCxxav
z5DhDg2TBJP4ZPZOWnXwLfofO0iAGerCyKwFhjMZzikz2rTAqElGzZoRC8OS
TL0uMMXIO/WDkUzJHV0SPDbsmcjw8gG3NJg8O31nzkIHITPMZcD0d2Fk1gTD
mQzXlBltmmDUJKNmzYiFmU6mXtOr0+nKU68rxMhkWRJzbXHVbigfuTCVIpd4
7VQeTKcLI7NOmI7taTCMXdSsGbEwnbNJgZnLrBOmY6vDPNZZsluS61F1V1Wv
h2bUr7m2Mgnod69N3N3bkg5Duu839E7WjyXCdLowMuuE4Uxm7pQZbTph1CSj
Zs2IhRlN5rF2qg2eHUXOavXgjPo131Z41e7SffuKLB8mC8kNJ1r4tc4SYHq6
MDLrg+FMZv6UGW36YNQko2bNiIWZSOZYl1lsk8LekY/q9VElpveGeKLVbFsR
rwnDOuz5jiYX5hDSDS3TrW98iYfp68LIrA2GMxmOKTPatMGoSUbNmhELM5VM
vU4Cclk67dv8rYsEY3xPbSv/PsY4LejjrJWBTHtb1M4633a8l/Ro2TNEFkyR
7hbV0zpvF+EoCsMwyUrhMP1dNCXDCMOZDNeURScjFkZNMmrWjFiY6WSadf8z
qSI6Qw25UU4O0zPXd6J4bPXN6u4QaTDYa7mOP1oQC9PfRVMyjDCcyXBNWXQy
YmHUJKNmzYiFmU6mWVcP4p1u3St6hRx+yvZUW0wwzNOjsc4QgAEYgHkGMPX6
4a7KtLx92ai7SrdLctTHE5tpbLYiXNPfQ5puNDQEYAAGYP5zmAbY8ajvWJYd
F626rTJPk7TvwBxbsXWWS3ud5CNDAAZgAOa/hmmAgUAgEAgEAj0n/QHVdMvD

            "], {{0, 19}, {378, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{378, 19},
          PlotRange->{{0, 378}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{382, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cbe3927e-60d5-4971-8d12-de67faa84277"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmq1v20AYxm8bGZy0v2D/gPGo4VClTmMhrVZXI13UTpoyaGZoZhZkZBQU
FFJkYk06MBODEJMAAxMDg+3OTTp/++r72qr3kRq9iZ/z+7unJys+593l13Pr
JULo7jV5Ob/4bt7eXqw+viFvPt3cfbm+ufr84ebb1fXV7fvLV+TDt+TvxwuE
aP0bBAKBQCAQCAQCgUAgEAj07yrbOpZhLHHRqonyBON9Xk6dYYYt9y3TXNjh
YWSUNJg8DbebINiE8UEiTLsLI7NWGM5kZk6Z0aYVRk0yataMWJixZNpgOfYQ
QpazSctGnQQrVMkJs5FWc21lvF0vEDKccHAScmAyHBiV5+F1GcQyYPq6MDJr
g+FM5tfP2VNmtGmDUZOMmjUjFmYqmTZYHrkIuUWn3u98e3lGzuBFY0uCxxav
z5DhDg2TBJP4ZPZOWnXwLfofO0iAGerCyKwFhjMZzikz2rTAqElGzZoRC8OS
TL0uMMXIO/WDkUzJHV0SPDbsmcjw8gG3NJg8O31nzkIHITPMZcD0d2Fk1gTD
mQzXlBltmmDUJKNmzYiFmU6mXtOr0+nKU68rxMhkWRJzbXHVbigfuTCVIpd4
7VQeTKcLI7NOmI7taTCMXdSsGbEwnbNJgZnLrBOmY6vDPNZZsluS61F1V1Wv
h2bUr7m2Mgnod69N3N3bkg5Duu839E7WjyXCdLowMuuE4Uxm7pQZbTph1CSj
Zs2IhRlN5rF2qg2eHUXOavXgjPo131Z41e7SffuKLB8mC8kNJ1r4tc4SYHq6
MDLrg+FMZv6UGW36YNQko2bNiIWZSOZYl1lsk8LekY/q9VElpveGeKLVbFsR
rwnDOuz5jiYX5hDSDS3TrW98iYfp68LIrA2GMxmOKTPatMGoSUbNmhELM5VM
vU4Cclk67dv8rYsEY3xPbSv/PsY4LejjrJWBTHtb1M4633a8l/Ro2TNEFkyR
7hbV0zpvF+EoCsMwyUrhMP1dNCXDCMOZDNeURScjFkZNMmrWjFiY6WSadf8z
qSI6Qw25UU4O0zPXd6J4bPXN6u4QaTDYa7mOP1oQC9PfRVMyjDCcyXBNWXQy
YmHUJKNmzYiFmU6mWVcP4p1u3St6hRx+yvZUW0wwzNOjsc4QgAEYgHkGMPX6
4a7KtLx92ai7SrdLctTHE5tpbLYiXNPfQ5puNDQEYAAGYP5zmAbY8ajvWJYd
F626rTJPk7TvwBxbsXWWS3ud5CNDAAZgAOa/hmmAgUAgEAgEAj0n/QHVdMvD

              "], {{0, 19}, {378, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {378, 19}, 
            PlotRange -> {{0, 378}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"061b7aaf-0075-40d9-80be-cd9f1985e941"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["30.21"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6ca10a09-275c-4a44-b59a-59f2edaf1fec"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6e6b1e98-8824-42a4-9f29-4d53b66a6eb5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0f5d4874-2f82-4c8b-88ba-1b9c27f7b04b"],

Cell["\<\
Make an array plot from the numbers of the letters in the first 1000 \
characters in the Wikipedia article on \[OpenCurlyDoubleQuote]computers\
\[CloseCurlyDoubleQuote], with 30 letters per row.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"18ca3d8c-0f0e-446a-9562-71f357d4ad5e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7a0dd00f-b315-43f6-93ca-a427f7b03559"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3TGvpVUVBuBRG+lMrCmsqOlMqEy0sJkCY0LLRECTCSZgNFZTW/sjqKlp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            "], {{0, 325}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 325},
          PlotRange->{{0, 360}, {0, 325}}]], "ExerciseOutput",
         ImageSize->{364, 325},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9f5a41fd-278e-4565-9652-527e1cb6b684"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3TGvpVUVBuBRG+lMrCmsqOlMqEy0sJkCY0LLRECTCSZgNFZTW/sjqKlp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              "], {{0, 325}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 325}, 
            PlotRange -> {{0, 360}, {0, 325}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6d8f94a3-5d21-4523-9c11-7ba47a9e241d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"354dd8bb-0682-45d2-b83b-a338939f0775"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d7e79401-3894-4c00-a2be-b09b71f9dbdc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"33f0ffb9-614a-4548-a212-75a47876322d"],

Cell["\<\
Gather integers up to 30 into lists based on their values modulo 3.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"f7610d46-ce9b-4526-b427-c5c518f6ddd6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"97bf68f8-6fae-4413-83cd-79f985a0301a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXTHPrLgVnSRNyvyFtCmo01KmGmmjdNPsKssqzWa0GymiDB0lHR0VFRUV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            "], {{0, 
            42}, {385, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{385, 42},
          PlotRange->{{0, 385}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{389, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bf1101ad-0e6b-4c3a-97e4-c9bc861131fe"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXTHPrLgVnSRNyvyFtCmo01KmGmmjdNPsKssqzWa0GymiDB0lHR0VFRUV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              "], {{
              0, 42}, {385, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {385, 42}, 
            PlotRange -> {{0, 385}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7d818113-210c-4325-bfb4-054d2aca8fc0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c9bd1794-10fa-410b-8724-78086fd09a6e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"dbf4e550-cc6e-425d-9025-a99eeb8a70c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f676ea92-2330-40e0-94f9-b41c001aa523"],

Cell["\<\
Gather the first 50 powers of 2 according to their last digits.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"a2914b91-f1b4-4b1e-9736-ec4a059653a2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"15227f52-26cc-4093-a836-9fd7c17662f2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnU2rM1t230+SSYb5CvkA1jjDaJiJD9hkdiY2aZlMOqJtCGcqMBeBJ/LA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            "], {{0, 174}, {478, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{478, 174},
          PlotRange->{{0, 478}, {0, 174}}]], "ExerciseOutput",
         ImageSize->{482, 174},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b97ed4bf-886a-4379-8549-846898843472"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnU2rM1t230+SSYb5CvkA1jjDaJiJD9hkdiY2aZlMOqJtCGcqMBeBJ/LA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              "], {{0, 174}, {
              478, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {478, 174}, 
            PlotRange -> {{0, 478}, {0, 174}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a5ade2c8-ada9-4b23-8a3d-71dbe8613e22"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"071fd5b7-6bdb-47f8-a9e3-08c65ccfd9d3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ae481545-da57-4e5d-a4d8-e20fb937c5b8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"449db549-3e88-472d-a36d-b50d6100c549"],

Cell["\<\
Make a line plot of the result of sorting the numbers from \[Minus]10 to +10 \
by their absolute values.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"806aeb60-de54-4fc4-a1c4-7fdd9a5d432b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fe41fffd-d15d-4f41-821c-4e5494739f23"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVtbFMnW5/fM3LyX8xXmW8ztXM7tO8/cam/FUne32G23uLsVW2kOKqIi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            "], {{0, 215}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 215},
          PlotRange->{{0, 360}, {0, 215}}]], "ExerciseOutput",
         ImageSize->{364, 215},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7c3d8479-6ddc-41e8-aa71-0a0ab5cec947"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVtbFMnW5/fM3LyX8xXmW8ztXM7tO8/cam/FUne32G23uLsVW2kOKqIi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              "], {{0, 215}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 215}, 
            PlotRange -> {{0, 360}, {0, 215}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7482daca-4779-4372-8751-a9cdc8c50e5d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7abf31cd-b5f3-44ef-b070-97023f4752c4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"31102b21-a2cb-445c-b4d7-a7c7655e4d31"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"289c9e7e-07a7-40ea-a45a-22e7bf6d6ad1"],

Cell["\<\
Make a line plot of the list of the first 200 squares, sorted by their first \
digits.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"435923fa-17be-460f-abd8-b682093ee7fd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9c56f082-e522-4ff8-81e0-b9939fe9843f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVtbE0nb75+11sl7uL7C+hbrdB2u03dd61TcTY/OjHEeZ4wzo5lHEUTB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            "], {{0, 
            204}, {338, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{338, 204},
          PlotRange->{{0, 338}, {0, 204}}]], "ExerciseOutput",
         ImageSize->{342, 204},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2147e548-ddcc-4e11-976a-28d3d36de26d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVtbE0nb75+11sl7uL7C+hbrdB2u03dd61TcTY/OjHEeZ4wzo5lHEUTB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              "], {{
              0, 204}, {338, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {338, 204}, 
            PlotRange -> {{0, 338}, {0, 204}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8cda44fc-d26e-4dc8-add8-afc6bec4d7fa"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dbd00ce1-e65d-4505-b294-3b69b3265dce"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6c4a2343-7875-4437-b544-a135706be588"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f328103a-6827-42b9-a210-9e517676ed84"],

Cell["\<\
Make a line plot of integers up to 200 sorted by the lengths of their names \
in English.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"869f53a0-4a46-46d9-a87c-6db411d5fdd3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"50150f0e-4b31-4cae-82e8-78d4ffc9add1"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndlfE+n3578zczOX8y/MfzG3czm3v3nNLbZbWto2dttt/PrT2IogCqIi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            "], {{0, 226}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 226},
          PlotRange->{{0, 360}, {0, 226}}]], "ExerciseOutput",
         ImageSize->{364, 226},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8bf5256c-d97f-47f6-94d3-db86f55e629f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndlfE+n3578zczOX8y/MfzG3czm3v3nNLbZbWto2dttt/PrT2IogCqIi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              "], {{0, 226}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 226}, 
            PlotRange -> {{0, 360}, {0, 226}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"96f75f25-c857-4563-8875-670f3ae1d1b9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5cc956f3-99ee-4436-8ffd-15e25378125b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2a8cccfe-6678-4827-88a2-af8d4f7f72f5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dc10e67f-e3f4-49a3-b857-f3bf04367994"],

Cell[TextData[{
 "Get a random sample of 25 words from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", "]"}]], "InlineCode",ExpressionUUID->
  "12040a25-0a20-478b-99e7-ae1e2d046ff7"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"6c000b61-eda5-41a3-b203-5ab93d004744"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e25f9d05-840a-4177-856f-0cefee0c2d8e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfT2Prcqa3rInmdB/wX+AeEITOkIaazKSGfkycnK9dMeSRbqyFa4MOTBO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            "], {{0, 64}, {
            501, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{501, 64},
          PlotRange->{{0, 501}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{505, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4f896aa2-1828-4d68-85d6-ad2301c01ed1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfT2Prcqa3rInmdB/wX+AeEITOkIaazKSGfkycnK9dMeSRbqyFa4MOTBO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              "], {{0, 64}, {
              501, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {501, 64}, 
            PlotRange -> {{0, 501}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"85d74907-9aba-4ff8-b54f-0af7036acd63"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.7"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a360e948-e72d-4417-93cd-745970d80c86"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"eb75a7e4-4837-4961-a875-0a9fe10c2f2e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ecf0ba99-f07f-423f-b420-0d917edd5ca6"],

Cell["Riffle periods into the string \[OpenCurlyDoubleQuote]UNCLE\
\[CloseCurlyDoubleQuote] to make \[OpenCurlyDoubleQuote]U.N.C.L.E.\
\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 8}, {
   "WebOnly", 1}},ExpressionUUID->"9bf6759d-13ca-4126-8add-b8125a41939b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0480acda-1fd2-4dc9-ba0c-5953b61985a6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUy2v2zAUjTYyOGm/YH8gdKOBQ5HeNGbynlY/jXRV36QpNCzQzCwoKCgo
KMTIxMQkpCAkpCDAxCCgu/lo851lGthAj5rKvvf43OOr6/dP3x/wK8MwXt7A
38PjT+t4fHQ+v4XNl/3Lt+f97uun/Y/d8+748ek1BN/B9wG+an25447/DpoH
JBTnbp8z6jM95lAayVVOjeIUUQ9jhA9uJPKZQjyfHmqzoU9vICRgWS+riGkY
Hu/2woN9MVBQ1IJHZkRZucy5lFlcswzsuAe7WhChVgoN0ZQwbYRsgGUdAjnK
WkR0e0lAXg0VfLspH+pFjg4QMKy4vUjJfD8dMMaFpiYtIlezvzEJHOwewASt
mzPDOSfQJ5suVdlmcvH4VpOIxhR6ZXowvnrCUQIiJhtNwB+aNDBlnDPGEiaK
cu3s1MD1mmmZh9BMJzmXKR2blBCxxcxb2mqynSgTUA2W1JOzvT5nITbMOZO1
PnNBwuGcjjhNJ5PzZRlbZnK9z+Gtu4kD1cj0dbcKWqL6xnCxwUUKBjKmm3SR
UumpyPrULY/0KaxeBCZRekoTv1ojP238wAYHaaNgXq+Zx25nsuNcpF/ZR14o
syzlETLqokMRmDohBefw4zJTK1lIlz1xIMRe2x6A7UZtGxWHc3UDK4Xeyy18
dDXZcare8cC56ZiIpKrsi7RTd0UVXM5W4zQQr6FVURRKDx4VxIaBGYw5pS5q
oY0if5O9445/hV9CKKrS
            "], {{0, 19}, {55, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{55, 19},
          PlotRange->{{0, 55}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{59, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "693b94f3-838d-4187-bb7b-d54c86fd48d4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUy2v2zAUjTYyOGm/YH8gdKOBQ5HeNGbynlY/jXRV36QpNCzQzCwoKCgo
KMTIxMQkpCAkpCDAxCCgu/lo851lGthAj5rKvvf43OOr6/dP3x/wK8MwXt7A
38PjT+t4fHQ+v4XNl/3Lt+f97uun/Y/d8+748ek1BN/B9wG+an25447/DpoH
JBTnbp8z6jM95lAayVVOjeIUUQ9jhA9uJPKZQjyfHmqzoU9vICRgWS+riGkY
Hu/2woN9MVBQ1IJHZkRZucy5lFlcswzsuAe7WhChVgoN0ZQwbYRsgGUdAjnK
WkR0e0lAXg0VfLspH+pFjg4QMKy4vUjJfD8dMMaFpiYtIlezvzEJHOwewASt
mzPDOSfQJ5suVdlmcvH4VpOIxhR6ZXowvnrCUQIiJhtNwB+aNDBlnDPGEiaK
cu3s1MD1mmmZh9BMJzmXKR2blBCxxcxb2mqynSgTUA2W1JOzvT5nITbMOZO1
PnNBwuGcjjhNJ5PzZRlbZnK9z+Gtu4kD1cj0dbcKWqL6xnCxwUUKBjKmm3SR
UumpyPrULY/0KaxeBCZRekoTv1ojP238wAYHaaNgXq+Zx25nsuNcpF/ZR14o
syzlETLqokMRmDohBefw4zJTK1lIlz1xIMRe2x6A7UZtGxWHc3UDK4Xeyy18
dDXZcare8cC56ZiIpKrsi7RTd0UVXM5W4zQQr6FVURRKDx4VxIaBGYw5pS5q
oY0if5O9445/hV9CKKrS
              "], {{0, 19}, {55, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {55, 19}, 
            PlotRange -> {{0, 55}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e94bd3c2-3574-4dad-95c0-160369092e00"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.8"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"96fa4ce8-020d-4bae-bdd9-10039a8c1b8f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d5814176-188f-4f8b-b26c-7f44553f8b46"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c896910a-f1c8-40a1-b044-1aff0ddc5e36"],

Cell["\<\
Find letters that appear in Swedish or Polish but not English.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 9}, {
   "WebOnly", 1}},ExpressionUUID->"00e33754-6c44-4ab5-8cb8-9605107912a5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bad534e3-e625-424f-b5a2-5710a91df8ea"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmC+P5DYUwKOWFFbqJ+gXCC41LIp0VVnInXo5lWyju0pVaFhgWFQSZBQ0
KCgkyMTExCQgJCQgwMQgYPpsZ3ayN46T245OVTVPmtXs5Dfv+f21PT++++NN
9I3neZ++gz9v3v6FPn58m/zyPfzz69On3z88vf/t56c/3394//Gnd9/Chz/A
6294qffnhzzkIQ95yP9Cetq2bDiCET66mZGThnSzC5mldD4HYuI4z3DDd7gv
EAnrot1ktdYzyke5p2GiTXMA25WpziLfj9m/12QT2WHYoJO638F4CVjaOJM+
NsCEJXMgrECeF1CnLzRDYV6Gnt+KTWbuT2AL86EKwSR2x2aoEw1b1YkcnmXE
qeDMysDz/GZ01dc81L7nlXw4ReBiqY0JHCEUpuTyRcEKsBZlp+F+lboSAcsM
CrqLQRLcaQJvwAs/adzL7Js8jIveCbEc1gRJQmQ7m9AraRS3w0TKJCmJM8oc
opu1W1NFuYZyZwQEQZvFsMZYFsXNMFGcJkUrje0aytLzL9UiKNROvq49KcXe
rLpg+5Qh9/XNR6B7yTyciqJqd8bF+cjU3sd0Ngvu1nAs5Ab9nOTQMH5uprxk
Kpu6LCRvcAjNrCWru02FE8sWzs+3sLlLEcpPpxQZMKabY0S2RWSMorjobBUq
OQZ7vu+jIAgQim1dfGXQJvPSRz+rt4J8PBS8iI2HXlxYJ7fEgXqaVBu2rsH0
krJ1NcgGqTYXvzCmOxxeMjtmCJZU845XKawAUWvrz53aJFBKup5WKbytetsS
BA2MXdwyohzamjZm1JegjjdplFDbUWKeuqZuWkKKUOnMiWWsHWGO+vhFofAC
3FJS52FU3pocaaXj4JfW9SwaohNhDVZvN3elbZLrDMICIQAxrPXFHj2PfddW
GfAFs/igJ7N3ggzOs/Iavm5dgFTZTBvjwqzOElFlLTyTzQSTaXfWTERXhfNE
cYTZ8/EgZkKBuaOfpkI3blDYjwRGQ3XZ5tsUWi+y6nOQc1epAXLimS6bZmmH
mZSxGXhRpAoqt/VJr89vawk3somUhiUIrLjO9huZocfNBAmSavuKMuZqkmbO
O8wuc8jHo6E4QSiCvbuAKGEQbswlE8xL/E3K7GczJykLHT64eak4ps35ckfI
WnNH4MGGC5PS47cbibnKks2FW8/2DZm7FiPV6fYyJrnqObfdXeagj0dDQfSY
2rlJu860OphefdFAYL57obU8HKRZbUnUs04NQdU1cIpQRdj208jyyF8KcuaJ
D5tkfbUgmNqXgoz24zSwqsCdPNuw22zq3rwhGY6DBHejEAPRd7vulplooc8Z
VddxxhjvLQs7whz08XAoqAqFn7R86FkdR3kvbxidTc9crG41SB1MdQgZWJPr
k1l7/iJyOfkUcqGez7RDHi7DMwjR4oJR4ufrthJdfQGVgRpuqreY/mSVzWC5
8N6QfVsG16mdq53hhqH5FdE2C/EqZu1jmEDA9Ib4euwsePVsFcV4tDCy0gd2
teXZg3kK1xrWuTtCvpx7egJnz98S0yTlhCM/wsvEU81rG5ITK9cjdwu7FRs5
g12xur8e0fZqBmxNYr4XZhb/TNoYCc/NLfGIhuO2jHB9oTWkmbooWv1+Ioiq
xobwQQy1OgxgZtk1BIUzVFy3dJRnB/aZHCG/JnNfzM3cN0paJCn1ffG6L0uC
syhKVwdj2WSqp7O6n8XQDRuHtokmAaQ9bIbZhb2UI+TXZO6LuZn7RkmLrLM4
TkvrTy4PechD/iPyD30jxBQ=
            "], {{0, 19}, {154, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{154, 19},
          PlotRange->{{0, 154}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{158, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e67a851f-7ac3-4c08-8962-59eb1b782fd1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmC+P5DYUwKOWFFbqJ+gXCC41LIp0VVnInXo5lWyju0pVaFhgWFQSZBQ0
KCgkyMTExCQgJCQgwMQgYPpsZ3ayN46T245OVTVPmtXs5Dfv+f21PT++++NN
9I3neZ++gz9v3v6FPn58m/zyPfzz69On3z88vf/t56c/3394//Gnd9/Chz/A
6294qffnhzzkIQ95yP9Cetq2bDiCET66mZGThnSzC5mldD4HYuI4z3DDd7gv
EAnrot1ktdYzyke5p2GiTXMA25WpziLfj9m/12QT2WHYoJO638F4CVjaOJM+
NsCEJXMgrECeF1CnLzRDYV6Gnt+KTWbuT2AL86EKwSR2x2aoEw1b1YkcnmXE
qeDMysDz/GZ01dc81L7nlXw4ReBiqY0JHCEUpuTyRcEKsBZlp+F+lboSAcsM
CrqLQRLcaQJvwAs/adzL7Js8jIveCbEc1gRJQmQ7m9AraRS3w0TKJCmJM8oc
opu1W1NFuYZyZwQEQZvFsMZYFsXNMFGcJkUrje0aytLzL9UiKNROvq49KcXe
rLpg+5Qh9/XNR6B7yTyciqJqd8bF+cjU3sd0Ngvu1nAs5Ab9nOTQMH5uprxk
Kpu6LCRvcAjNrCWru02FE8sWzs+3sLlLEcpPpxQZMKabY0S2RWSMorjobBUq
OQZ7vu+jIAgQim1dfGXQJvPSRz+rt4J8PBS8iI2HXlxYJ7fEgXqaVBu2rsH0
krJ1NcgGqTYXvzCmOxxeMjtmCJZU845XKawAUWvrz53aJFBKup5WKbytetsS
BA2MXdwyohzamjZm1JegjjdplFDbUWKeuqZuWkKKUOnMiWWsHWGO+vhFofAC
3FJS52FU3pocaaXj4JfW9SwaohNhDVZvN3elbZLrDMICIQAxrPXFHj2PfddW
GfAFs/igJ7N3ggzOs/Iavm5dgFTZTBvjwqzOElFlLTyTzQSTaXfWTERXhfNE
cYTZ8/EgZkKBuaOfpkI3blDYjwRGQ3XZ5tsUWi+y6nOQc1epAXLimS6bZmmH
mZSxGXhRpAoqt/VJr89vawk3somUhiUIrLjO9huZocfNBAmSavuKMuZqkmbO
O8wuc8jHo6E4QSiCvbuAKGEQbswlE8xL/E3K7GczJykLHT64eak4ps35ckfI
WnNH4MGGC5PS47cbibnKks2FW8/2DZm7FiPV6fYyJrnqObfdXeagj0dDQfSY
2rlJu860OphefdFAYL57obU8HKRZbUnUs04NQdU1cIpQRdj208jyyF8KcuaJ
D5tkfbUgmNqXgoz24zSwqsCdPNuw22zq3rwhGY6DBHejEAPRd7vulplooc8Z
VddxxhjvLQs7whz08XAoqAqFn7R86FkdR3kvbxidTc9crG41SB1MdQgZWJPr
k1l7/iJyOfkUcqGez7RDHi7DMwjR4oJR4ufrthJdfQGVgRpuqreY/mSVzWC5
8N6QfVsG16mdq53hhqH5FdE2C/EqZu1jmEDA9Ib4euwsePVsFcV4tDCy0gd2
teXZg3kK1xrWuTtCvpx7egJnz98S0yTlhCM/wsvEU81rG5ITK9cjdwu7FRs5
g12xur8e0fZqBmxNYr4XZhb/TNoYCc/NLfGIhuO2jHB9oTWkmbooWv1+Ioiq
xobwQQy1OgxgZtk1BIUzVFy3dJRnB/aZHCG/JnNfzM3cN0paJCn1ffG6L0uC
syhKVwdj2WSqp7O6n8XQDRuHtokmAaQ9bIbZhb2UI+TXZO6LuZn7RkmLrLM4
TkvrTy4PechD/iPyD30jxBQ=
              "], {{0, 19}, {154, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {154, 19}, 
            PlotRange -> {{0, 154}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"59f5a4f2-5263-43ce-b0df-8b0d3bf1233c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.9"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"158b273b-183a-44bd-99e4-1ab55dcca39c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9f3818e9-dc7b-460b-a80e-7b9f470823b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4c2b20cf-33c1-4d1a-a8a4-b2b58d9782f9"],

Cell["\<\
Find countries that are in the World Health Organization but not the United \
Nations.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 10}, {
   "WebOnly", 1}},ExpressionUUID->"400b3760-b13c-4443-b4ad-20ea81109c7d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1c362184-40c5-4602-aa4e-d1ea94aa3a7f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWt9rKtkdt7svfUy7j1ta+gckb273KZAHH0oeFiyVPmyQXVY3++Ctubeh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            "], {{0, 27}, {162, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{162, 27},
          PlotRange->{{0, 162}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{166, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "61ac3ac1-ee51-4764-b7aa-9a84f10dc04f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWt9rKtkdt7svfUy7j1ta+gckb273KZAHH0oeFiyVPmyQXVY3++Ctubeh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              "], {{0, 27}, {162, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {162, 27}, 
            PlotRange -> {{0, 162}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"458fd5a4-93d5-4826-ba6e-ae2d4793de0a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.10"], StandardForm],
   ImageSizeCache->{151., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e5b6659b-2888-4cf5-9d73-0138a34264a7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"327a1252-2ec4-4b10-ab39-10c03692dc05"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"973379d0-a9ed-4891-9bd5-fde8f441465b"],

Cell["Make a list of all pair-wise blends of red, green and blue.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 11}, {
   "WebOnly", 1}},ExpressionUUID->"d5476273-6deb-4e5f-a3e2-952bf35eaa2a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b8be8e99-c4a2-449e-988e-068c4cd6aa2a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWCFvg2AQvWxmcsl+wf4AehY5taRLXU2blWamI+2Spa7BIXE4zGpaVYWq
x9RgMFjMBAKDQHQHtBOjwJV+SWlyLx/tR8Pr691Lj+MeBx8d5QYApnf40ul/
yZNJf/Z6jyfd8fR9NB6+PY8/h6Ph5Glwix8+4PGNR7rfMRgMBoPBuA6Etq5I
kurGl/4hDMGIFoos9zTnJ9mfuyY2aYq+XgJUr6Nf1+1C9TrOqiF1BWrVRLUs
YdWJCYyrmVadXcvdLvFsqwcg6U5OibYGgIH/6dTN8lXh9Xxeuiq8LifNK7xu
oAV1gZXmv1JMYFzNtKAusPwyz3oByQizfeymXkfstYj8t9Br15RBMqNs7y96
ue/s9fn5b6HXXuYveh36GxVAzuo5e31+/lvodeKvsB/T156ObyBtsmrOXp+f
/xZ6jXdpU0ptTkJPw4222bHXIvLfQq9jz0KjLSfAvb/Crpx8v068mQSyZv89
i5PyX2RRciJIi+R1kUXJv6C4mmkRvc76MTNnndaHx24vrfpGdFL+iyxKTgRp
kbwusij5FxRXM60GfXj2fK3Tn7nSOnDgUvNfZNFqnRAtYg3/z6LVVSFxNdOi
9uHotbxn5fVcVkzK3CywsW2HhRseBEmzrCMswnxJlBZlbnaERZhliYqrmRZh
bhY71iw119geSLGz0BVF8wjz8CQK/ODkuTmzLsSKbV1VNcuP6i9lMBjXiF+O
jIvf
            "], {{0, 19}, {164, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{164, 19},
          PlotRange->{{0, 164}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{168, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a5f094d4-2569-4249-8e91-724a96f060ee"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWCFvg2AQvWxmcsl+wf4AehY5taRLXU2blWamI+2Spa7BIXE4zGpaVYWq
x9RgMFjMBAKDQHQHtBOjwJV+SWlyLx/tR8Pr691Lj+MeBx8d5QYApnf40ul/
yZNJf/Z6jyfd8fR9NB6+PY8/h6Ph5Glwix8+4PGNR7rfMRgMBoPBuA6Etq5I
kurGl/4hDMGIFoos9zTnJ9mfuyY2aYq+XgJUr6Nf1+1C9TrOqiF1BWrVRLUs
YdWJCYyrmVadXcvdLvFsqwcg6U5OibYGgIH/6dTN8lXh9Xxeuiq8LifNK7xu
oAV1gZXmv1JMYFzNtKAusPwyz3oByQizfeymXkfstYj8t9Br15RBMqNs7y96
ue/s9fn5b6HXXuYveh36GxVAzuo5e31+/lvodeKvsB/T156ObyBtsmrOXp+f
/xZ6jXdpU0ptTkJPw4222bHXIvLfQq9jz0KjLSfAvb/Crpx8v068mQSyZv89
i5PyX2RRciJIi+R1kUXJv6C4mmkRvc76MTNnndaHx24vrfpGdFL+iyxKTgRp
kbwusij5FxRXM60GfXj2fK3Tn7nSOnDgUvNfZNFqnRAtYg3/z6LVVSFxNdOi
9uHotbxn5fVcVkzK3CywsW2HhRseBEmzrCMswnxJlBZlbnaERZhliYqrmRZh
bhY71iw119geSLGz0BVF8wjz8CQK/ODkuTmzLsSKbV1VNcuP6i9lMBjXiF+O
jIvf
              "], {{0, 19}, {164, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {164, 19}, 
            PlotRange -> {{0, 164}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3f5dae26-e2db-4ab9-b8e2-a501e332a23e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.11"], StandardForm],
   ImageSizeCache->{151., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"86d43d65-6edd-4431-acdb-207aeada7a1f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2c6f4ea7-e276-4d9a-8f05-83079f78b4c1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"60b5bb7c-b5d4-46a7-b471-7d397f54635c"],

Cell["\<\
Make a list of array plots, each 50 rows high and with image size 50, of \
successive possible 8-tuples of 0 and 1.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 12}, {
   "WebOnly", 1}},ExpressionUUID->"d3fadc75-43b4-4b49-8868-ca7b37744cee"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0b496a24-8fcc-4d29-b1a5-429606d41b90"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnKFz3dcRhV9bUtg/oSWFwqWCRZ5pp8wkmcaZktSTdKZjaiYoZmZkFGRk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            "], {{0, 294}, {
            288, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{288, 294},
          PlotRange->{{0, 288}, {0, 294}}]], "ExerciseOutput",
         ImageSize->{292, 294},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "55bc12a3-ce3a-43b1-9590-2c3b70dab55f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnKFz3dcRhV9bUtg/oSWFwqWCRZ5pp8wkmcaZktSTdKZjaiYoZmZkFGRk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              "], {{0, 
              294}, {288, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {288, 294}, 
            PlotRange -> {{0, 288}, {0, 294}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c67b4ba0-1f77-4713-8c21-e12d2f935581"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.12"], StandardForm],
   ImageSizeCache->{151., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7783b0c2-63ea-4d21-9f98-5b543cabe9f7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2a29fd7b-a10e-46b3-ac27-13c36eb842f5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1acce375-68cc-4f0e-865c-64833a844ed0"],

Cell[TextData[{
 "Generate 1000 random sequences of 4 letters, and make a list of ones that \
appear in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"edbe4fb6-cc4f-4777-b798-ddd3ea4384e6"],
 ". "
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+30.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 13}, {
   "WebOnly", 1}},ExpressionUUID->"3ca1c8d2-2c51-4b28-aa20-f4318a663750"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6a121aab-a369-4e1f-8eef-8aace1baa300"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWK+vpUYUJq2pbNK/oP8AuhZZRbJNHWY3XTY1W7LbpMHikDgcilSgUCgM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            "], {{0, 19}, {167, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{167, 19},
          PlotRange->{{0, 167}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{171, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "766c9b92-1309-499c-a6ae-77f0b8b1c090"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWK+vpUYUJq2pbNK/oP8AuhZZRbJNHWY3XTY1W7LbpMHikDgcilSgUCgM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              "], {{0, 19}, {167, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {167, 19}, 
            PlotRange -> {{0, 167}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"77f23501-57c0-40cd-912e-9eb4f377801b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x30.13"], StandardForm],
   ImageSizeCache->{151., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a198e4e2-9e8d-4d2e-9374-03f4be60f04d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e6984518-0a6f-407f-a1a0-136e7ddbe6bc"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6f3a7f68-ecf1-48f4-bfce-5071b6ee0fce"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Rearranging Lists: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 30  Rearranging Lists", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
30-rearranging-lists.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+30.1", "30.1", "+30.10", "30.10", "+30.11", "30.11", "+30.12", 
         "30.12", "+30.13", "30.13", "30.14", "30.15", "30.16", "30.17", 
         "30.18", "30.19", "+30.2", "30.2", "30.20", "30.21", "+30.3", "30.3",
          "+30.4", "30.4", "+30.5", "30.5", "+30.6", "30.6", "+30.7", "30.7", 
         "+30.8", "30.8", "+30.9", "30.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+30.1", "30.1", "+30.10", "30.10", "+30.11", "30.11", "+30.12", "30.12",
       "+30.13", "30.13", "30.14", "30.15", "30.16", "30.17", "30.18", 
      "30.19", "+30.2", "30.2", "30.20", "30.21", "+30.3", "30.3", "+30.4", 
      "30.4", "+30.5", "30.5", "+30.6", "30.6", "+30.7", "30.7", "+30.8", 
      "30.8", "+30.9", "30.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[20191, 405, 813, 26, 
  70, "Input", "ExpressionUUID" -> "08c8f038-e718-4164-9007-ec7690b13ce0",
   CellTags->"FirstInputCell"],
  Cell[31352, 672, 813, 26, 
  70, "Input", "ExpressionUUID" -> "831b6da1-e89a-4efd-9d79-e0092cb979a5",
   CellTags->"FirstInputCell"],
  Cell[72936, 1439, 813, 26, 
  70, "Input", "ExpressionUUID" -> "32cd0381-a520-46fc-ad25-e9b87146b4be",
   CellTags->"FirstInputCell"],
  Cell[140093, 2626, 813, 26, 
  70, "Input", "ExpressionUUID" -> "cfab2356-f2f5-42ba-8111-3cf3bdba4e25",
   CellTags->"FirstInputCell"],
  Cell[327804, 5791, 813, 26, 
  70, "Input", "ExpressionUUID" -> "449852f9-a6ab-4de4-8fcc-9bfb6487d4d5",
   CellTags->"FirstInputCell"],
  Cell[352233, 6292, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f994bc2c-5401-42f4-94d2-8f1093fe0b6e",
   CellTags->"FirstInputCell"],
  Cell[367324, 6637, 813, 26, 
  70, "Input", "ExpressionUUID" -> "84b36d6c-3abe-4a0e-8b0c-20f8d81b2cda",
   CellTags->"FirstInputCell"],
  Cell[377843, 6899, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d6f4b09b-f5c9-4744-88dc-b9e2bb5deb32",
   CellTags->"FirstInputCell"],
  Cell[443472, 8061, 813, 26, 
  70, "Input", "ExpressionUUID" -> "64589cce-e452-4942-9701-1eb2286169b5",
   CellTags->"FirstInputCell"],
  Cell[480769, 8762, 813, 26, 
  70, "Input", "ExpressionUUID" -> "57be410c-9514-406b-b6cd-a44da2ff7e78",
   CellTags->"FirstInputCell"],
  Cell[493365, 9054, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f1ae4a10-235e-459a-acae-9dffab4c0e67",
   CellTags->"FirstInputCell"],
  Cell[505539, 9339, 813, 26, 
  70, "Input", "ExpressionUUID" -> "97051b76-91c6-49fa-8f55-e8674feb5eb3",
   CellTags->"FirstInputCell"],
  Cell[534875, 9909, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a1b2ee23-14e1-4e1c-8c63-aa17d3a55b8b",
   CellTags->"FirstInputCell"],
  Cell[542047, 10110, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b19989af-147e-436b-98a6-9567e8f9ace5",
   CellTags->"FirstInputCell"],
  Cell[550982, 10344, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0e9c7b50-1898-4d3b-a668-8ea3c0ad4d7a",
   CellTags->"FirstInputCell"],
  Cell[568348, 10713, 813, 26, 
  70, "Input", "ExpressionUUID" -> "794751c8-7fae-4133-80c6-3d9494c72a17",
   CellTags->"FirstInputCell"],
  Cell[578604, 10967, 813, 26, 
  70, "Input", "ExpressionUUID" -> "dc1e734d-b3bb-4aef-813e-577a740498de",
   CellTags->"FirstInputCell"],
  Cell[599255, 11391, 813, 26, 
  70, "Input", "ExpressionUUID" -> "53a2c70d-405e-4925-8d96-1d87723b806d",
   CellTags->"FirstInputCell"],
  Cell[606890, 11601, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a2044e30-6366-47ed-a3a5-9bab3de02aba",
   CellTags->"FirstInputCell"],
  Cell[622155, 11936, 813, 26, 
  70, "Input", "ExpressionUUID" -> "40c94210-8541-4a67-ae08-a283c696d3e5",
   CellTags->"FirstInputCell"],
  Cell[630915, 12175, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6e6b1e98-8824-42a4-9f29-4d53b66a6eb5",
   CellTags->"FirstInputCell"],
  Cell[647686, 12536, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d7e79401-3894-4c00-a2be-b09b71f9dbdc",
   CellTags->"FirstInputCell"],
  Cell[662518, 12864, 813, 26, 
  70, "Input", "ExpressionUUID" -> "dbf4e550-cc6e-425d-9025-a99eeb8a70c7",
   CellTags->"FirstInputCell"],
  Cell[705511, 13654, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ae481545-da57-4e5d-a4d8-e20fb937c5b8",
   CellTags->"FirstInputCell"],
  Cell[749419, 14460, 813, 26, 
  70, "Input", "ExpressionUUID" -> "31102b21-a2cb-445c-b4d7-a7c7655e4d31",
   CellTags->"FirstInputCell"],
  Cell[789165, 15197, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6c4a2343-7875-4437-b544-a135706be588",
   CellTags->"FirstInputCell"],
  Cell[836239, 16055, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2a8cccfe-6678-4827-88a2-af8d4f7f72f5",
   CellTags->"FirstInputCell"],
  Cell[867870, 16663, 813, 26, 
  70, "Input", "ExpressionUUID" -> "eb75a7e4-4837-4961-a875-0a9fe10c2f2e",
   CellTags->"FirstInputCell"],
  Cell[875125, 16866, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d5814176-188f-4f8b-b26c-7f44553f8b46",
   CellTags->"FirstInputCell"],
  Cell[884385, 17103, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9f3818e9-dc7b-460b-a80e-7b9f470823b4",
   CellTags->"FirstInputCell"],
  Cell[896340, 17385, 813, 26, 
  70, "Input", "ExpressionUUID" -> "327a1252-2ec4-4b10-ab39-10c03692dc05",
   CellTags->"FirstInputCell"],
  Cell[903478, 17586, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2c6f4ea7-e276-4d9a-8f05-83079f78b4c1",
   CellTags->"FirstInputCell"],
  Cell[925062, 18025, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2a29fd7b-a10e-46b3-ac27-13c36eb842f5",
   CellTags->"FirstInputCell"],
  Cell[935340, 18283, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e6984518-0a6f-407f-a1a0-136e7ddbe6bc",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 994687, 19509}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[638, 21, 561, 15, 70, "Exercise", "ExpressionUUID" -> \
"068a6085-146d-4d10-8dac-f33c28c8bbd3",
 CounterAssignments->{{"SectionNumber", 30}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1224, 40, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"eb179cb3-8f53-45f5-b915-1e0569ea5f0c"],
Cell[1863, 61, 17721, 319, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d3266303-119c-4dbb-95b7-b52b27191930"]
}, Closed]],
Cell[CellGroupData[{
Cell[19621, 385,