(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    819309,      15241]
NotebookOptionsPosition[    744978,      13675]
NotebookOutlinePosition[    805151,      14910]
CellTagsIndexPosition[    805071,      14905]
WindowTitle->Applying Functions Repeatedly: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Make a list of the results of nesting ",
 StyleBox["Blur",
  FontFamily->"Source Sans Pro"],
 " up to 10 times, starting with a rasterized size-30 \
\[OpenCurlyDoubleQuote]X\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"ad737e6f-3555-46b0-9cb1-6a79d60e8233"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"745c1e48-756d-4368-9e20-893d89a75b45"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfHdUW1maZ53df7Zn+4/ds3tmd2c7TFen6W6XK3R113RX1cy4uqpcwS6H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            "], {{0, 40}, {239, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{239, 40},
          PlotRange->{{0, 239}, {0, 40}}]], "ExerciseOutput",
         ImageSize->{243, 40},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fea925cd-9871-4b7a-9eb0-6ed424149a6a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfHdUW1maZ53df7Zn+4/ds3tmd2c7TFen6W6XK3R113RX1cy4uqpcwS6H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              "], {{0, 40}, {239,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {239, 40}, 
            PlotRange -> {{0, 239}, {0, 40}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"038bd1f0-ef92-4fe4-94d3-bff0b70b6800"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"92406dbd-1799-4a2d-bd1d-5482741074fb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e5ca1503-de4c-4f85-b2e4-1351d32f049b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ec2fc926-343c-439c-8dd6-2ea929bc4915"],

Cell[TextData[{
 "Start with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"bde9a9f8-ce2f-4afd-b30e-c78196d60ce4"],
 ", then make a list by nestedly applying ",
 Cell[BoxData[
  StyleBox["Framed",
   FontFamily->"Source Sans Pro"]], "InlineCode",ExpressionUUID->
  "171ff9ad-2bc4-4700-998d-175dfd13b161"],
 " up to 10 times, using a random background color each time."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"9819306c-e0d2-4d01-8eb3-7aeae512a18d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ce9ac5d7-2500-4093-870b-a4291532616e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb9rHGcax1/lmuOq+wdcHO63MYQjIUeUwiSGZCHHFQZhiHFkLgRbKAbj
FCmEi6hIsQfG6pQEFg6cxhBQ5cCJBNSouC2iRuTUqFGxF/Y4ttjCN7KOZP3O
O7PzzvvreWc/H94ESdbOPO933+fjmde70h9u3n1//RWl1Ce/Lf73/gf3Vzc3
P3jw598Xn/zlzid/vX3nw1vv3Ln34e0PN/948zfFF/9V/Pe3FaXOP34OAAAA
YVCdIHWKABCPouUfvXIt64G1AJYKrAUAeYG1ACAvsBbAcqJW0u1EN2fF0N3q
ZWvlMhGsBeBI0TjfPv9Z+DB2t1K6AZLX2WQiWAvAkVya3Vg51gJYQnJpdmPl
WAtgCcml2Y2VYy2AQETb612IsTatrYTgaK3E1c+BtSBHisX55uzd5MPYI+W2
Sl7nRanu1ko+C+NEsBZkgZwOMtaWRbMbK8daAIGQ00HG2rJodmPlWAsgEHI6
yFhbFs1urBxrQYfxvcNah/Hs2kqOhqO1Epbq11pyJoK1oCHF8nj7h58ijKr+
0lZytGLcrZWqVO/WEjIRrAUNwVpYS8hEsBY0BGthLSETwVrQEKyFtYRMBGt1
Bsv9zgUYj68tLY84WitoMX6tFbPUoNZKOBGs1RmKp++9ez96GVUrXFtaHk/n
bq1wxXi3VrRSQ1sr1USwVmfAWlgLa0FeYC2shbXAkdlkfHZ6ejaZxTkd1sJa
WAscmDzd6l9sM6qtgyYPUJYYj6CtBCscreV4Or/W8ltMUGsFLTWmtWJOBGuF
YHq0W4TZf7B7MDo6GU+bPKT4/s3h9w1H1QrUVoLVAd2t5XI679byWExoa4Ur
NbK1ok0Ea4XgeLhWXGOd2TwEa2EtrIW1EjLaWVW9nYnNQ7AW1sJaWCshWAtr
SSgVa0FzsBbWklAq1oLmYC2sJaFUrAXNwVpYS0KpWAuag7WwloRSsRY0Z7TT
x1pYK3mpWAsaM3u6rnrbv74k/mBnTfW3T2YXH6+r/uC09BishbWwFtZKxni/
p9TgcO5S62x/VanVndHsbK8I+cHeSflBWAtrYS2slYTxycFWYai1oXZ7eLq3
pS5Yf2J8h4/2pF+/eVVd+ejW1xcf99WVu+tu1lp4QL/Wsj1dUGs5FhPTWn5L
TWitoBPBWn7ZPhdT79m4/CdHL95N3XtquM46R/+r6vGjS0pduvnVxuMvij96
9f43rtdaiw7o+VrL8nRhr7Xciol6reW11JTXWiEngrX8Mh0f76wVd4MD7U2I
o931Qlmrja+1irF+/9b/L8/eenindIFtPEL9FXv9Ab3fIVqdLvQdoksxke8Q
PZaa9g4x3ESwln+mh8Vl1fbBr9dbs5OnRbZb++PnJ0/Uxb7W7OhBT61u7f1i
sPKTvjkcXj5/yi/3B9rXX1jLdIRF+wx1B9StZTq+5baGxel0a5nO7rbH0r4Y
3Vqm2rxuB3krVbeWqfKQ+1qhJqJbqzQvsGe2tzH/Y7Wm5z8Bor97sdN1MCiU
tjb696j4muoNftn+Kj/pN24X33n5UtW11tRwhPpVVH9A3Vqm41stWqvT6dYy
nd2lg1yK0a1lqs1js3ssVbeWqfJw1go3Ed1apXlBC168Xmtg2Nya4/jJ2vxr
urQnfWPwefGV1z7b2xw8VBX7WuUj1KyihQcs3yGWj9980dqernyHWD576w5y
LKZ8h1iuzVez+y21fIdYrjyQtYJOpHyHqM0LWrDwtfGn51djajj6VWwvP+nf
XXtdqSuffvzi0+s33lDq6o0vX3rSjUeoXkWLD6g91nj8xovW+nTakY1nb9tB
rsVo5zXW5qnZPZeqVWWsPIy1wk5Eq7k8L2jBQmvNJqfHpy/dhZcvsGtG8c3G
IyzaZ6g7oPZY4/EttzUsTqcd2Xh2tz2W9sVo5zXWlsXLnIyVd+D1WuV5QQt4
H6LjojWeXUgHGWvLotmNlXfAWjZ9BpVgLawloVSsBc3BWlhLQqlYC5pzOFhV
q1gLa8lqdmPlWAsuOH6yrtRGxXt3zGAtrIW1sFZCZsfDIsze+vbes/3RSaNr
LqyFtbAW1krK7HD4oKde0Ph3T2MtrIW1sFZqZtPJZDqdNflWZYnxCNpKsMLd
Wi6n824tj8WEtla4UiNbK9pEsFZn0FaCy6ha4TWL1vF0fq3lt5ig1gpaakxr
xZwI1uoMWAtrYS3IC6yFtbAW5AXWwlpYC/JCecV4fG1pecTdWuGK8W6taKWG
tlaqiWAtaIi2tMKNqv6q6aCgxfi1VsxSg1or4USwFjQEa2EtIRPBWtAQrIW1
hEwEa0FDsBbWEjIRrAUNsdtddcN4dm0lR8PdWqlK9W4tIRPBWpAF2kpONap6
v6bZE5bq11pyJoK1IAvkdJCxtiya3Vg51gIIhJwOMtaWRbMbK8daAIGQ00HG
2rJodmPlWAsgEJ53ex0w1qa1lRDcrSUErAXgF62tZA5jd5cNkLzOJhPBWgCO
5NLsxsqxFsASkkuzGyvHWgBLSC7NbqwcawEsIWol1q60CysNrJXJRLAWwNKi
XrZWjgNrASwVWAsA8gJrAUBeYC0AyItkO+peSZ0iAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADA
kpL611znTepnD2AZKVrv7//8HaPFwFoAScBaWAsgL7AW1gLIC6yFtSAt6fZl
88CYmNaJUAPWAu8UC+mD/3zDMA5jl5U7MXmdYgfWghDQdPVNZ0wMazUPEGuB
d2i6+qYzJoa1mgeItcA7NF190xkTw1rNA8RajkTbgRSLMRNtmS05jtZKXL0A
sJZfitBuvzNd2mFcM+VllrzOtBG5Wyv5LEQFiLUcYUUZM6Hp5iPCWn4DxFqO
sKKMmdB08xFhLb8BYi1HWFHGTGi6+Yiwlt8APVrL9w6cRBZaK3WBMdDma2ut
xNVHIai1ks4sEjGt9Y///qnDw5hPOeHkdYYOwd1ayWcROSLv1ko+x7QBYi2r
MLEW1moREdbyGyDWsgoTa2GtFhFhLb8BYi2rMLEW1moREdbyG2A4a9ntvklF
m5GttRJX74n6FeVoraQz80ZCayWctUfkWOvRK9eyHuUZtbBW8ll4D8G7tZLP
MXREoa2VPIHIAWItqzCxFtZqERHW8hsg1rIKE2thrRYRYS2/AWItqzCxFtZq
ERHW8htgNGupFZUBK6o+TEdrdSOEoNbqZEQxrbUMAcazllLfPv9Z+CjX7Nla
nQghrLW6GFFUay1BgFjLKkyshbVaRIS1/AaItazCxFpYq0VEWMtvgFjLKkys
hbVaRIS1/AaYylpKDFZh+rVWwllriLVWskRKZGqtRGkZ6Ia13py9m3zYhund
WskTaBFCZGslz8c9orTWSp6e9wCxFtbCWqEjwlpYK2GYWAtrYa3kAWItrIW1
QkeEtTppLRURlzCDWiuXEBJaK9OI5FirGwHKsdbbP/wUYTiGGdpaWYSQ1lo5
RiTKWh0IEGthLawVuemwFtaKGSbWwlpYK3mAWAtrYa3ITYe1Omkt5ZVMrSU2
BDnWyiUisdbKNECx1nrv3o9eht8wI1tLZgiirJVFRJKtlWOAWAtrYS2slVeA
WAtrYS2slVeAWAtrYS2slVeAWlaz6fjs7Gw8mYqylrKkk9aSE4JYa4mNKBdr
5RKgltXhdu+int7G8EyStTaH3zccQcNMay0hIUi2lsyIMrJWFgFqWU3Hp0dH
o6eD9eLj7YMx1sJaWAtrSQuwYl9rMuip3uAQa2EtrIW1pAVYYa3psI+1sBbW
wloSA6y61tpdVatYC2thLawlL8Aqa+1gLayFtbCWyACxFtbCWlgrrwCxFtbC
WlgrrwArrdXDWlgLa2EtiQFWvaPnYLvX2z7AWlgLa2EtaQFWWWu0e/7ShwnW
wlpYC2sJC7DKWrOTJ8WnT09mAq11/eZVdeWjW19ffNxXV+6uL5+1EoaQi7Xk
RJSptcQGWP0zH2Z7D3pKbTw7bvp+xHh/BTx+dEmpSze/2nj8RfFHr97/Zhmv
tdKFkIu15ESUqbXEBlj3k2qmh+qc7YZvR4wX5vD79fu31AVvPbyzrHeIqULI
xlpiIsrVWlIDrLbWZLim1Or26KzpT62JGebmcHj5PMrL/UHU2+3ns6PiCnR1
a286N+t0ew5pQtCtZcpESNMJiUi3likxmdaSGWCVtaZHu8Wnz2x+Wk3MMG/c
7hdJXor+V8Dz6ahw+fy/UyRcUalC0K1lykRI0wmJSLeWKTGZ1pIZYOW/IZ6/
zHRH5r8hbgw+L77y2md7m4OHKvq+1vGTNdXbSW6thCGU7xDLmUhoOjkRle8Q
y4kJtJbYAKustb/V623LfJXpd9deV+rKpx+/+PT6jTeUunrjy0hhnu5tFP8f
jsbzs06xolKGoM3XmImAphMUkZaGMTF51pIbIK+NtwpzNjk9Pp1qs06355Am
BG2+xkwENJ2giLQ0jInJs5bcAHkfou0dYnnWS76ijJnQdPV3iOXEsBbWwlpY
S05EWAtrYS1RKwprYS2sJTlMrIW1sFbyALEW1sJaWCuvACusNeZ39GAtrIW1
ZAaoZTU5Pdp/9mx3q198PDjk9yFiLayFtcQFqGX1y++e3tjZb/r+wyjWsqKr
1hISgmRryYwoI2tlEaCW1Ww2nUwmFj9UK4q1XIbfMBNaS04IYq0lNqJcrJVL
gHU/qQZrYS2shbXkBYi1sBbWwlp5BYi1sBbWwlp5BSjWWh7J11oyQxBlrSwi
kmytHAOUaa1wwzHMmNYSG4Ica+USkVhrZRog1sJaWCty02EtrBUzTKyFtbBW
8gCxFtbCWpGbDmt1xlrRkGytLEJIa60cIxJlrQ4EKMRaqYZtmEGtlUsICa2V
aURyrNWNALEW1sJaoSPCWlgrYZhYC2threQBYi2shbVCR4S1OmMtIaS1lhAk
W0sI+VpLCB2wlsyxMEy/1pI5bFdUUGvJHI5NF9NaMgfWihkm1sJaLSLCWn4D
xFpWYWItrNUiIqzlN0CsZRUm1sJaLSLCWn4DjGetFZUBK4Gt1YkQwlqrixFF
tdYSBBjNWjmO8owcrZXjWLii/Forx2HbdEGtlePAWkHDxFpYq0VEWMtvgFjL
KkyshbVaRIS1/AaItazCxFpYq0VEWMtvgEGt1QHcrdUBQlurA6S1VgcQYq3u
DWM+5YST1xk6BL/W6t5Y2HR+rdW9gbX8hom1sFaLiLCW3wCxllWYWAtrtYgI
a/kNEGtZhYm1sFaLiLCW3wD9WqvzNLFW53G3VucJba3OE81ay4mW8LIN45op
L7PkdaaNyK+1lm1gLe+wooyZ0HTzEWEtvwFiLUdYUcZMaLr5iLCW3wCxliOs
KGMmNN18RFjLb4BYyxHPu5AZYsxEW2ZLjru1lhysBaHRlhnD0VoMLUCsBd6h
6eqbzpgY1moeINYC79B09U1nTAxrNQ8Qa4F3aLr6pjMmhrWaB4i1wDux9mhz
xZiY1olQA9YCSI7WiYzmA2sBJAFrYS2AvMBaWAsgL7AW1gLIi2T72p0g9bMH
AOCH/wEzOa7v
            "], {{0, 223}, {402, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{402, 223},
          PlotRange->{{0, 402}, {0, 223}}]], "ExerciseOutput",
         ImageSize->{406, 223},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2fb40c4a-b67a-4480-980f-cc644924edec"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb9rHGcax1/lmuOq+wdcHO63MYQjIUeUwiSGZCHHFQZhiHFkLgRbKAbj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              "], {{0, 223}, {402, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {402, 223}, 
            PlotRange -> {{0, 402}, {0, 223}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"882341d0-d7e3-4007-b1b1-f78d150f4ed5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"94c26d62-ec57-44f9-867c-b7dc75e02aa7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"39542267-28e8-483a-adcf-ed3892ab7e6b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"65f173c3-804f-45a2-9062-0a3a39be4b12"],

Cell["\<\
Start with a size-50 \[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote], then \
make a list of nestedly applying a frame and a random rotation 5 times.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"2538dd78-088c-4faa-addb-b5cb6ac256ea"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"898fdbed-24ed-4089-aefd-abfcb5fd506a"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsnQlcTdv7//3+v3t/d1IKjZo0KSWUElEylIgQmeIaI0SZQyRTGS4Zcw2Z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            "], {{0, 443}, {460, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{460, 443},
          PlotRange->{{0, 460}, {0, 443}}]], "ExerciseOutput",
         ImageSize->{464, 443},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "dcbaaa0c-073a-4f3e-a421-cce3c76d23ae"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsnQlcTdv7//3+v3t/d1IKjZo0KSWUElEylIgQmeIaI0SZQyRTGS4Zcw2Z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              "], {{0, 443}, {460, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {460, 443}, 
            PlotRange -> {{0, 460}, {0, 443}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5ca5d859-5c62-44dc-939e-d5305b89ebc5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd26e851-fef4-4902-b701-006f4dc51f2f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"65034218-4252-4aec-9f44-ae1a30110326"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"90d7736c-9cd1-413a-a9e2-31f4774d2c35"],

Cell[TextData[{
 "Make a line plot of 100 iterations of the ",
 StyleBox["logistic map iteration",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"4", " ", 
   StyleBox["#",
    FontFamily->"Source Sans Pro"], 
   RowBox[{"(", 
    RowBox[{"1", 
     StyleBox["-",
      FontFamily->"Source Sans Pro"], 
     StyleBox["#",
      FontFamily->"Source Sans Pro"]}], ")"}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "dde68693-332f-4862-bf1d-94abe9b053cd"],
 ", starting from 0.2."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"2543d8c1-91b0-4171-a0d7-2f56b47ed120"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d11fac1f-3e91-43d0-a13a-a7b94d5f3e12"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvd1/HdWxNnhm5ua9nH9h/ou5ncu5fec3t+0cMDshJ4gcciJOAk6A2DjY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            "], {{0, 229}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 229},
          PlotRange->{{0, 360}, {0, 229}}]], "ExerciseOutput",
         ImageSize->{364, 229},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cc6272df-e0dc-4ee6-95ed-6903abd75b15"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvd1/HdWxNnhm5ua9nH9h/ou5ncu5fec3t+0cMDshJ4gcciJOAk6A2DjY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              "], {{0, 229}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 229}, 
            PlotRange -> {{0, 360}, {0, 229}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2fb3030c-bf55-4830-a584-3c282dc4cf20"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7a068b90-6d66-4d58-a2e5-6a7d8f031fb1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"89e378e9-2999-4570-8109-1275d4cc8270"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3e40534b-59b4-4bf5-83d2-cb710d2246f2"],

Cell[TextData[{
 "Find the numerical value of the result from 30 iterations of ",
 Cell[BoxData[
  RowBox[{"1", 
   StyleBox["+",
    FontFamily->"Source Sans Pro"], 
   RowBox[{"1", "/", 
    StyleBox["#",
     FontFamily->"Source Sans Pro"]}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "c11e23b5-56d6-479e-a4b6-75601a568cd4"],
 " starting from 1."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"d9fccc5c-0e2c-4859-b945-8f4a30826f9b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d6c3ba77-4694-4a1c-b64c-8af8c64332a6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVC+PnEAUJ62pbNJP0A9QdC2yiuSaOsxdulxqtuSuSYPFIXE4FGoUCjUG
hcE8M2bEGCoQiDEjENf3BhbY3m76BfYluzv7e/9+8/7Mx4efd+Ebx3Ge3+HX
3f1v7+npPv76Hv98Oz7/eDwevn85/jo8Hp4+P7xF8AN+PuGHzi83ucl/REsA
padrWtFyxqoG1B4dlAA57BEzSF4xVje92UDVcVYy3qm9XYt2Vd2KfsUkix0r
aTteoDCpxHNW8QugMLJaMDdbfTQUFvFd+gk6TWCXBxa0UNFRvJ77zoo5ftrM
l1e8TCLS5N0FGrIMUVUAqWSVldZmGtosScnJy/WJRYF/g5LKMMmIjuJFt8jW
zyl7m9ERDNKoPTeRNjdPEfRavWYTGCO7QGMk76i+UCX0wcTuRiP3sDbdXPTC
ng3keAU+962vHUqh9xHGJjmjYTrvIg1NeNoIqMs8Lzn0eyVQ4pUG1oqam1Sd
AoYFL6WRDCuZLtMzyXBHQw89NIwaFpYbs2s0DARzH4M4DmkcIiav0XgZGn83
Q4h32d6ASuTlsJZulrOk16uBkaNqSd2k7n4mz2konAc/awz6VKljR4KqsdmT
QbpLMZmhzuiWlTpt6AQ0G3DWOIsLtAsrtcu70RCWxrKaY4MBG7NTOdkfgbPh
NrPDwGkLKIXZtnkCb9lQgy8GNLRrcYlDALjyPcfruEySeWcnvIJ+EDXVPOZI
XfcCBLAYVSEHEL2e2+dGpRqN7tsYhyNgxs4Ddl8NqqBThPepsShuzEU/DqpK
KSROEbZja+jSLD0vab4UZyij0yMR5nP9LLdN3JQWZIRyQ4PUXgIfPnYCvUpS
QNN3SeCurlm9DdsrmfR41iCjx3F81bJLjmSpzTmGwcZ/XujZ7tqrfZObrPIX
aXhWlg==
            "], {{0, 19}, {45, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{45, 19},
          PlotRange->{{0, 45}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{49, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1075d7d5-dc49-44b3-a938-bbfd88817811"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVC+PnEAUJ62pbNJP0A9QdC2yiuSaOsxdulxqtuSuSYPFIXE4FGoUCjUG
hcE8M2bEGCoQiDEjENf3BhbY3m76BfYluzv7e/9+8/7Mx4efd+Ebx3Ge3+HX
3f1v7+npPv76Hv98Oz7/eDwevn85/jo8Hp4+P7xF8AN+PuGHzi83ucl/REsA
padrWtFyxqoG1B4dlAA57BEzSF4xVje92UDVcVYy3qm9XYt2Vd2KfsUkix0r
aTteoDCpxHNW8QugMLJaMDdbfTQUFvFd+gk6TWCXBxa0UNFRvJ77zoo5ftrM
l1e8TCLS5N0FGrIMUVUAqWSVldZmGtosScnJy/WJRYF/g5LKMMmIjuJFt8jW
zyl7m9ERDNKoPTeRNjdPEfRavWYTGCO7QGMk76i+UCX0wcTuRiP3sDbdXPTC
ng3keAU+962vHUqh9xHGJjmjYTrvIg1NeNoIqMs8Lzn0eyVQ4pUG1oqam1Sd
AoYFL6WRDCuZLtMzyXBHQw89NIwaFpYbs2s0DARzH4M4DmkcIiav0XgZGn83
Q4h32d6ASuTlsJZulrOk16uBkaNqSd2k7n4mz2konAc/awz6VKljR4KqsdmT
QbpLMZmhzuiWlTpt6AQ0G3DWOIsLtAsrtcu70RCWxrKaY4MBG7NTOdkfgbPh
NrPDwGkLKIXZtnkCb9lQgy8GNLRrcYlDALjyPcfruEySeWcnvIJ+EDXVPOZI
XfcCBLAYVSEHEL2e2+dGpRqN7tsYhyNgxs4Ddl8NqqBThPepsShuzEU/DqpK
KSROEbZja+jSLD0vab4UZyij0yMR5nP9LLdN3JQWZIRyQ4PUXgIfPnYCvUpS
QNN3SeCurlm9DdsrmfR41iCjx3F81bJLjmSpzTmGwcZ/XujZ7tqrfZObrPIX
aXhWlg==
              "], {{0, 19}, {45, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {45, 19}, 
            PlotRange -> {{0, 45}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1f8dff70-3175-4b16-99fd-70bf1c2d5345"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"22759a9a-248a-43a9-989e-13aef9e081d6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6b812f8e-8c94-4882-8520-c438a943b5d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e07cc2d6-9489-428d-b5c8-41ef62086e29"],

Cell["\<\
Create a list of the first 10 powers of 3 (starting at 0) by nested \
multiplication.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"cd52a69a-3b40-460e-9267-5085fa76a0e4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"90053c27-57e1-4f9c-b978-f7e983565e71"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWr2vtbYZJ+2SsVL/gKr/AHNWxk5IqbqdJVFfoi5v0ZtKEStLxchSsTHR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            "], {{0, 19}, {287, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{287, 19},
          PlotRange->{{0, 287}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{291, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a16027a2-2f7b-44ca-9f90-aa1814ff938e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWr2vtbYZJ+2SsVL/gKr/AHNWxk5IqbqdJVFfoi5v0ZtKEStLxchSsTHR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              "], {{0, 19}, {287, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {287, 19}, 
            PlotRange -> {{0, 287}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"0bf2c7ea-3ed9-48df-8d76-36256e1931df"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"780d96ff-9a81-41b3-8459-75867182a670"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"dfc62a23-7ea4-4792-8bc8-3d1fda85833f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"24d9ca9e-6123-4670-930f-8b76d0e2d54b"],

Cell[TextData[{
 "Make a list of the result of nesting the (",
 StyleBox["Newton\[CloseCurlyQuote]s method",
  FontSlant->"Italic"],
 ") function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], 
      StyleBox["+",
       FontFamily->"Source Sans Pro"], 
      RowBox[{"2", "/", 
       StyleBox["#",
        FontFamily->"Source Sans Pro"]}]}], ")"}], "/", "2"}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "2860ceec-b985-4f25-80cd-ae858f252c1e"],
 " up to 5 times starting from 1.0, and then subtract ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]],ExpressionUUID->
  "bc58e537-a077-437a-b57c-29fb2264b225"],
 "from all the results."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"7c227643-a805-4b24-bf7e-89d801c32534"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4522f863-76df-4652-bf6b-773ece6209f4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXC3TpMoVJomJjMkPyB9AxyKjqLqpOMy9leVWzGbq3lSlsDjiqIrAoVAo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            "], {{0, 21}, {
            475, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{475, 21},
          PlotRange->{{0, 475}, {0, 21}}]], "ExerciseOutput",
         ImageSize->{479, 21},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fdf5b6e0-df9f-4d55-8139-ef06fb5695fc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXC3TpMoVJomJjMkPyB9AxyKjqLqpOMy9leVWzGbq3lSlsDjiqIrAoVAo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              "], {{0, 21}, {
              475, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {475, 21}, 
            PlotRange -> {{0, 475}, {0, 21}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5def1c6f-ad03-43e5-84df-dd603681e860"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"37fc1bd6-2722-474c-866c-1b18d67a98f7"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c4e143a1-847e-40d8-9c50-431659fbdf95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b1c29251-c52d-434b-aaf3-e538bc17f5be"],

Cell[TextData[{
 "Make graphics of a 1000-step 2D random walk which starts at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "0b7466c8-bc10-4020-bc9f-8489aecd9ec9"],
 ", and in which at each step a pair of random numbers between \[Minus]1 and \
+1 are added to the coordinates."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"01ad67c9-8f59-4f0c-ac6e-11bbb401e7b1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"39a5cde7-56e6-4f6d-84f3-0949b894c9b3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsnQV0FEn39oNrkAQICSFoSHAL7u5uAYK7S3B3l+DuBLdgi9vi7iwOu8Au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            "], {{0, 403}, {
            360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 403},
          PlotRange->{{0, 360}, {0, 403}}]], "ExerciseOutput",
         ImageSize->{364, 403},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "529a6e27-c15d-48b6-ba3f-3adb77999391"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsnQV0FEn39oNrkAQICSFoSHAL7u5uAYK7S3B3l+DuBLdgi9vi7iwOu8Au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              "], {{0, 
              403}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 403}, 
            PlotRange -> {{0, 360}, {0, 403}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"46c046d9-6399-4b30-a20b-2cd7da391d66"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3c38b813-006e-448b-b622-a5ff456ebaa4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7d5655d3-f8fa-4506-856f-e7f5f0b109fd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4060a584-fc0b-4e03-a784-289ad869c35e"],

Cell[TextData[{
 "Make an array plot of 50 steps of Pascal\[CloseCurlyQuote]s triangle modulo \
2 by starting from ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineCode",ExpressionUUID->
  "5a5e3b8d-4287-449f-8766-e1edc4b18941"],
 " and nestedly joining ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineCode",ExpressionUUID->
  "1f4dd723-afcc-4530-b575-f486fdbdcc06"],
 " at the beginning and at the end, and adding these results together modulo \
2."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"9170917c-d442-4629-937a-bf53ae3495c7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"28315b4b-4048-4a5c-af41-efd351a768da"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3L3OJUcVhtEBEkJugbsgJSQ14gJsYRsSI9lIiKs3YyGR+OBT9dXe1W9X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            "], {{0, 359}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3bffccc8-2e88-4713-8d0d-19a3466a5901"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3L3OJUcVhtEBEkJugbsgJSQ14gJsYRsSI9lIiKs3YyGR+OBT9dXe1W9X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              "], {{0, 359}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b0038e7c-7faf-48be-a95a-df2a1aed2ace"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"282cf1a8-20cf-4e14-a622-88bc000467fb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"54a951a8-d397-4c45-ab07-abc6e7323d46"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e1537465-623d-4839-82ae-561607a81a40"],

Cell[TextData[{
 "Generate a graph by starting from 0, then nestedly 10 times connecting each \
node with value ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"c2daff86-6a92-412a-b31d-59fc71b07952"],
 " to ones with values ",
 Cell[BoxData[
  RowBox[{"n", "+", "1"}]], "InlineCode",ExpressionUUID->
  "08524c2d-9106-4df9-8ee2-edceb70547d4"],
 " and ",
 Cell[BoxData[
  RowBox[{"2", "n"}]], "InlineCode",ExpressionUUID->
  "46410c6c-2835-42d7-a432-4eee809c0e02"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"6687eadb-a8c7-4fa6-baa8-76c21c8515c2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"84618952-9812-40b8-af36-1e354f94e188"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvWdXW2m277vvuW/uy/sV7hj3A5ze3Xt3nTu665wdep9dHat7V+rq6uqq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            "], {{0, 453}, {514, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{514, 453},
          PlotRange->{{0, 514}, {0, 453}}]], "ExerciseOutput",
         ImageSize->{518, 453},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "186fc2b4-ec64-40dc-9d67-7a9f0fb3dcfb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvWdXW2m277vvuW/uy/sV7hj3A5ze3Xt3nTu665wdep9dHat7V+rq6uqq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              "], {{0, 453}, {514, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {514, 453}, 
            PlotRange -> {{0, 514}, {0, 453}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e1340a62-f464-4c69-953a-cd1743ea9ced"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6be4a464-7e6b-432a-9003-1b249d075984"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4ba73bad-7a09-4bce-92b2-bf2a7ac2d1a2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a3b0eeca-0116-42b1-a5d2-601e695e14fa"],

Cell["\<\
Generate a graph obtained by nestedly finding bordering countries starting \
from the United States, and going 4 iterations.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "27.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"ffc9ba4a-6069-4f48-96ac-3304a265ded2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd4e6cea-a765-4537-ac47-2b3742a17a43"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnWlQW1mW51/MfJmP82k+TMdMz/TEzMREdSiiJ6Y7prorO1Nd2V1TXZ2l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            "], {{0, 130}, {575, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{575, 130},
          PlotRange->{{0, 575}, {0, 130}}]], "ExerciseOutput",
         ImageSize->{579, 130},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "eb20e3d1-6518-4985-a1a7-a031b1e4e8fe"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnWlQW1mW51/MfJmP82k+TMdMz/TEzMREdSiiJ6Y7prorO1Nd2V1TXZ2l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              "], {{0, 130}, {575, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {575, 130}, 
            PlotRange -> {{0, 575}, {0, 130}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1f723682-2326-4282-bb80-d125964ec3ff"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["27.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ef390ead-2ada-4a54-8e8f-0726f4016c1e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0f2f9e2c-4a31-4f05-9621-ccc2f172fc8a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"348b9f23-99e4-4a1b-97cb-84f607915692"],

Cell[TextData[{
 "Make a line plot of 100 iterations of ",
 StyleBox["linear congruential function",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["Mod",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{
     RowBox[{"59", 
      StyleBox["#",
       FontFamily->"Source Sans Pro"]}], ",", "101"}], "]"}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "27d74344-b4e9-49f7-be32-053df3c23f88"],
 ", starting from 1."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"c0ad0497-c65d-4e3f-b8f4-e6b00bd3971a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5c0ca6e1-3566-49f9-abf1-01fdd3828154"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvVt7HOXVNvjOzMl3OH9h/sWczuGcfnPNaTkB00DeIN7AG5EExMaRMbbD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            "], {{0, 227}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 227},
          PlotRange->{{0, 360}, {0, 227}}]], "ExerciseOutput",
         ImageSize->{364, 227},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "31d82a28-3266-4826-8491-9e240074055c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvVt7HOXVNvjOzMl3OH9h/sWczuGcfnPNaTkB00DeIN7AG5EExMaRMbbD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              "], {{0, 227}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 227}, 
            PlotRange -> {{0, 360}, {0, 227}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dd5bcf54-a94d-47c0-ab80-26d6ee8b749d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x27.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ea55d4f2-855f-4ab6-939d-ea1a522a4173"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"666de1ae-b0b5-4901-82e9-61ed1a6d88cf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"776355ed-a8ff-4c41-b860-b68018ebda38"],

Cell[TextData[{
 "Create a list of 5 ",
 StyleBox["power towers",
  FontSlant->"Italic"],
 " of 2, i.e. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", 
     RowBox[{"2", "^", "2"}]}], "..."}], "^", "2"}]], "InlineCode",
  ExpressionUUID->"746e9652-57e1-433a-b080-f7033b5f1f79"],
 " ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "6d375ded-03b8-435c-a2ba-dd73b19bcd03"],
 " times, with ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "153f7711-ffb3-4b04-af43-6a0f3c928cda"],
 " from 0 to 4."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"b416600e-dc4e-4d40-8f36-308ef9e4f0b6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"705938dd-a10b-4def-9250-1b8aff1a1f9e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVyGP5DYUjlpSWKm/oH8guNSwKNJVZSF36mZVso32Kp1CwwLDzIyCgiJV
igpCggwaklYyMUhBSECAiYHB1M+emSS7cW6lG1TNJ81oJn72e/783vec7z/8
9i76yvO8j9/or3fvP6Hn5/fJT9/qPz8/ffz18enhlx+ffn94fHj+4cPX+uF3
+vOoP/D7dMcdd9zxf8NcZ5Hvx720fwXv+0GooxlipHVVlhVl01vWZ103zPLQ
ZsfpxLpa+2i6+TAWNQ+tDqaq2SSvS13BRrG2Hdl6bDhPGHuzQMunTZCrAEQR
IRSmdDqHInqsO0KUVaM68TLxDDI6OynoS9/Y2O+4ZIdsnGgegHFGXQa7TikO
vQUJd/AmWLEy8womT7JD60cbvyL312OoE6oj8Wo3HunnvQA+/fkHCVe7EF3u
ebmleGiKNIY94s5JGi/07Gw0U4sIwjrINslL6zXAnctmx+lYw5SsVZAcbYZb
B2dzjgylEP1cZlhzpsZKs9HqlFAWG44x8gLSn07LECNRkBsqFIfDSxpXAIwE
np/bEGUPpK2SmOkN5G7StOv5UkczzXSEVLgsx0wfIApD30O5k7TXTnmpDyNk
h1UJuwR+dCpt3JscCPr9uZMOFzvXFXrUCwvpCKDXjPvYOoPMuRAIMOl9SNqC
Dk46HR2jPWS0Vw9jAUd0SNrGqapjz0+bgTUE47LuXGdi+WkZqwkhRc2M9lm1
8cM4jhNcviQ0sGNRlOYFuwjUSYlp4A0xiVZxVwDMEKV/z7zRJY3Whf9m0tQA
Bx0V+5pmR5MaGCXIQ/hQ+jZOBQ7ONZ2kRnACshuN5QdiSNIQNAk1EwiCLsG8
rCpDgheVi7grniI/ykhdFxHYB1ZEDfkWMZPOAJSRmqximdHAZh3TG0mbaWiS
2ZEGghi/cZbneRpYVWuGt5Km/4Rnogwz+wpgSSvPTYLHntWrBUMVO9Vjbv1N
61Fi7FIQE12ArgAkNu1CzQws02ZZTfUgL71TpwAThQ6AcncLkG2Bc4xzQBaY
YyWtm7StU6h6hG2GqKF0bVzCdvz2vG+hd6RFQMlFiaYm3c5dtQVBNTGZvk3I
JROnOrH2uwFIRqC9UqgdXuqUsZom4YbTwlBStPpGM+ppiiVaxtP6urQcG9uM
cdP1XUcp5VpMXpmtGTHlaXJgx2zHqeRwkYgLOs+cwPHEkE07c8cUsh2zaerM
vYX885eOLczrYZo4LZA5qytnJu9Sysdp6HLYg1//+3cIXbLk0zzyNkFwq5hO
+wEY8T8zuXRP2QXeBrmWQNmb5Zf22uMXVibJX5mtcG30px2zXadadav08iCo
mNifCw20uV6nkqIDZhu83NOCdF0xYmiTxRkiFAplaMlij+J2PJ/J6wDW3dPI
YHZQjZCKF+MD3NYMoMQ8b14kHHPBTki1eSJePFmNST328oUH7MWrKtkGwDAy
igewpYoiPOw5GWtoH0X/mb5wW7Obz/1iSGp68eq2KWmR6ZsL29UjMfLx+LXx
9mY3n/vFkHUWxynhb6qQO+64Df4DuPlzag==
            "], {{0, 19}, {103, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{103, 19},
          PlotRange->{{0, 103}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{107, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "dc3fdc3f-932f-4a72-a550-9a956b5eafcc"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVyGP5DYUjlpSWKm/oH8guNSwKNJVZSF36mZVso32Kp1CwwLDzIyCgiJV
igpCggwaklYyMUhBSECAiYHB1M+emSS7cW6lG1TNJ81oJn72e/783vec7z/8
9i76yvO8j9/or3fvP6Hn5/fJT9/qPz8/ffz18enhlx+ffn94fHj+4cPX+uF3
+vOoP/D7dMcdd9zxf8NcZ5Hvx720fwXv+0GooxlipHVVlhVl01vWZ103zPLQ
ZsfpxLpa+2i6+TAWNQ+tDqaq2SSvS13BRrG2Hdl6bDhPGHuzQMunTZCrAEQR
IRSmdDqHInqsO0KUVaM68TLxDDI6OynoS9/Y2O+4ZIdsnGgegHFGXQa7TikO
vQUJd/AmWLEy8womT7JD60cbvyL312OoE6oj8Wo3HunnvQA+/fkHCVe7EF3u
ebmleGiKNIY94s5JGi/07Gw0U4sIwjrINslL6zXAnctmx+lYw5SsVZAcbYZb
B2dzjgylEP1cZlhzpsZKs9HqlFAWG44x8gLSn07LECNRkBsqFIfDSxpXAIwE
np/bEGUPpK2SmOkN5G7StOv5UkczzXSEVLgsx0wfIApD30O5k7TXTnmpDyNk
h1UJuwR+dCpt3JscCPr9uZMOFzvXFXrUCwvpCKDXjPvYOoPMuRAIMOl9SNqC
Dk46HR2jPWS0Vw9jAUd0SNrGqapjz0+bgTUE47LuXGdi+WkZqwkhRc2M9lm1
8cM4jhNcviQ0sGNRlOYFuwjUSYlp4A0xiVZxVwDMEKV/z7zRJY3Whf9m0tQA
Bx0V+5pmR5MaGCXIQ/hQ+jZOBQ7ONZ2kRnACshuN5QdiSNIQNAk1EwiCLsG8
rCpDgheVi7grniI/ykhdFxHYB1ZEDfkWMZPOAJSRmqximdHAZh3TG0mbaWiS
2ZEGghi/cZbneRpYVWuGt5Km/4Rnogwz+wpgSSvPTYLHntWrBUMVO9Vjbv1N
61Fi7FIQE12ArgAkNu1CzQws02ZZTfUgL71TpwAThQ6AcncLkG2Bc4xzQBaY
YyWtm7StU6h6hG2GqKF0bVzCdvz2vG+hd6RFQMlFiaYm3c5dtQVBNTGZvk3I
JROnOrH2uwFIRqC9UqgdXuqUsZom4YbTwlBStPpGM+ppiiVaxtP6urQcG9uM
cdP1XUcp5VpMXpmtGTHlaXJgx2zHqeRwkYgLOs+cwPHEkE07c8cUsh2zaerM
vYX885eOLczrYZo4LZA5qytnJu9Sysdp6HLYg1//+3cIXbLk0zzyNkFwq5hO
+wEY8T8zuXRP2QXeBrmWQNmb5Zf22uMXVibJX5mtcG30px2zXadadav08iCo
mNifCw20uV6nkqIDZhu83NOCdF0xYmiTxRkiFAplaMlij+J2PJ/J6wDW3dPI
YHZQjZCKF+MD3NYMoMQ8b14kHHPBTki1eSJePFmNST328oUH7MWrKtkGwDAy
igewpYoiPOw5GWtoH0X/mb5wW7Obz/1iSGp68eq2KWmR6ZsL29UjMfLx+LXx
9mY3n/vFkHUWxynhb6qQO+64Df4DuPlzag==
              "], {{0, 19}, {103, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {103, 19}, 
            PlotRange -> {{0, 103}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"774e45c2-2038-4216-8bf1-173c18dd3c69"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x27.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bb6e1848-4f4e-46c5-8c9d-fe49d71b8090"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c6a8111e-245c-4374-a7f5-7db22f203f4e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9d36a374-16a0-4f53-b41c-7136c6481818"],

Cell[TextData[{
 "Create a list of 20 ",
 StyleBox["power towers",
  FontSlant->"Italic"],
 " of 1.2, i.e. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"1.2", "^", 
     RowBox[{"1.2", "^"}]}], "..."}], "^", "1.2"}]], "InlineCode",
  ExpressionUUID->"9be81bab-629d-46aa-8725-816a065534ff"],
 " ",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "4577671d-8c00-41f0-ba02-6d88633fb078"],
 " times, with ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "9ead7923-4505-4df2-a063-782963032555"],
 " from 0 to 19."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"4e983ee7-4e30-4498-be88-4fcea6b2805d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e4e10509-878c-4871-915f-0bc6fec00de6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnaGvrModx2lrKvsv1Faga5FVm7ymDvNeenmpud3c16TB4pA4HKJBoVah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            "], {{0, 42}, {489, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{489, 42},
          PlotRange->{{0, 489}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{493, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f8b9010a-0714-4aaf-a8ee-727e13dfc780"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnaGvrModx2lrKvsv1Faga5FVm7ymDvNeenmpud3c16TB4pA4HKJBoVah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              "], {{0, 42}, {489, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {489, 42}, 
            PlotRange -> {{0, 489}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ff613ef2-407c-46c2-8f41-7a6143f29080"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x27.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"de9382f1-2d8d-459f-a604-6be7bbcb2036"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"36f8bbab-7917-4ef8-9e55-4d056d2df4dc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a27ee218-ea7d-4d23-868d-cb2e2d2bfe00"],

Cell[TextData[{
 "Generate a list of the numerical values obtained by up to 10 nestings of \
the function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["Sqrt",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{"1", 
     StyleBox["+",
      FontFamily->"Source Sans Pro"], 
     StyleBox["#",
      FontFamily->"Source Sans Pro"]}], "]"}], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "3fa72e0d-8237-4d3f-89ce-a3cfd5c143e1"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"40f69dd7-db57-4778-a16a-6322d25482f9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9cae12d3-baab-4499-bd78-e2147edbaba6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXS2vtNoVpq2p7F+orUDXVCCrSG5TN+be9OWm5i15b5MGi0PicKNQKBQK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            "], {{0, 42}, {317, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{317, 42},
          PlotRange->{{0, 317}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{321, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7e9d08e6-be09-420d-b2f9-c7dfc8a10ca9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXS2vtNoVpq2p7F+orUDXVCCrSG5TN+be9OWm5i15b5MGi0PicKNQKBQK
g8JgdtKQJggMFQgEZgvEdK+1h+FjNgycGabn3uwnOSdn1iwWz+yvtfbmnOf8
/od/fGf8WlGUn37Lvn33/b+0b9++t/7yO/bir19/+vuPX7/87c9f//nlxy/f
/vjDb5jxD+zrT79SFPj5IiEhISEhISEhISEhISHxS0ATOYaqmoTyl21BSNl2
my9/7F/lhBT12FKX+cwi8GyrNAqDIEzzmedGhstutCID8pouGy9dkcVhEMYp
aTASrUsyRVlTofFlxFhz5QlriDgtxkFpXTBmQZRUI2uZxYEfxFnZGzpo0iFk
uULrUcO2eRqz7khIObYKu/LeWJEUyKZ5T2AXMYk5WuIpimI4YdVdisBSEE7a
bLl2iz/NffBQXe5Bi1Dj1/QWoWdDApV74XczyLff8aFbfj4pI3AfkbHyTiMS
qsXGHHE1ZQrVzYTGVxHLOAkVSRh+i54tOaNRR+spQ2vviaYzJ9C66jikxj33
Ert0pT36iPqZXBa6UmSksQM2Tcd3zJDuISYhRJu5iuLyta6MfdvUWSN62aZp
u8G/crRrT/Nu6erUtR24SPPaZc/CZyPQqZCgb8BoqvcwXHcjnsYGFQvYIZaN
taupZwI0m+zcD+muo1cHcma30HG8CY2vIEYJhMNFoE5cuBD4tHCTkw+91hUm
/Jhf2pS1n+6BZwrLiI7lU8tC4iwbf9bdxArsgzOBt4rQ9dFH2JUCIxKzY+jM
JmUfQU3bHcQkhKAEpu1olOWsyd1t0/ahP1//NXU+SXM27NSJ5c6zbfpqrUkd
Zk0H740MF90gOZ7CLcYBHWFjzxlH6/ITny8TN5HxCWK0YBWIGl/rzYZlKM0j
fMz3CZ2e8WeKVdPVs4oUuAVrspq1nZdvnBVLxBpYBsxIfM1dV86NbcauthIM
C83Ip+0uYhJzQF4b16sUGnnHtF3278oQqjWfELjFpGcxrYyW6GVPhgwGjV3t
ZbjshjWtbpmGaTlRVq0YgVvLNmqpa7AFRY+rYZiVAUtARjEdd0LjM8S6Clom
KHlETLJWfIGUBzWtHWYl7ib8ghZw62tNwlKwwadtm0EGVU+mYdiun9erzJaI
4bxzkpxEvuf5ManGb866UmSsofZXjTgv0zPjZcGn2UVMYoqmiFmJpTnpYHrZ
tK1hDBo+648C195xx8y6dcWTz2hjnL+enbZd7JzUkxVEoWtCXY71m9AIyPp9
q2rHoyCl1W/xHhmfJFbZuHNwzx7WsP12o0700Vaz5TyHJoUUDHm5K2xNNZxz
FPmw8Cj62pHAEjFKrlv8k2UZQMwMitubG6btpQzNgayP1+4iJjGFg70Rj1vs
RdOW74aUk+15Dna1Zjl+2U/IcbeueTbpCdPwZFQ8nW1HgGpTMQK6amQb1yI5
I5F+uGIV6hfT64TG54nRMvQcy7T8JAtMXhuXJszkhLKkFUIfsi0tZNuhagIH
Z3aLJlHXj/KWs60OJ0nXz5446rg8ezhtaQ5N55O6awvfgsUmLKe59SExiSm6
JrdVWNZHJjgDccnmc70F/yoNXNfzXPaNpw7NcoNbd+XYrXTds05hPmvu/OnC
RobLbqMDEJwdeLYjNFJ6s3Y+o9yXJWXE8uqJTCeo0Pg8sREK2DizTNckrGGS
/j1oTMX9b872tirfQV7quD+8GodM59vzjcRww26E1+c+/NzsFmXclReREfa5
it0HbeCcAlaePcQk7lAErE94L9CCEIJpha3sOSEVvVQxa2Y1YBmkyy1V0exo
1EGr/iPwAwpuaquc5CSwIJfEhORVK/SkVcwLMy/OSJalaVrAc1PBHfcSw6Mb
9ZzkdV3FnolPJEqxESaC4kakbmoSeViNXmv1aUV6ERtfQQw2hqbhsf1kSTxY
xXBZwKpVNf2yoW2VsruwyUxxP8u2E2Vdwg5SMdnFUJxqdlpUdZm50KBqxLbn
+7sSdwp6SKo6jyBfWnG30JX3xiqGMt8JSUtZ0eLhgXy9mZiEGMNJMs2G7RLC
zVpewcK6zTc46ujMed1/BHgm0p8kZ9NHnKqTCT2JN4uNRZTojruJdXXoDI9H
DTfGxyhCYxO5xs2o28Et7wO9+QOsO+NLiF1q37q1mB7m12AN8Yd2PDl8mWzz
oDdqYYGTqEys4ZbaOa0/QozTMPs9vuHxqknYlSJjl3hDMxpe0m0nJrEAfG7r
LDdU1zbXNyEv36WYFf+34SPEOto0DZ2dXy4b2w8lgFcRYx5Nc//bSx1t75hB
sLkr+LUT28e6kiKNBxctBhOR/SAxieuJgdYvoUuoIijbfPLpNiCS2F5IYr8I
0NR3DMPOVxNK11ZF9Rn3HJLYXkhiEhISEhISEhISEhISEhISEhISEhISEhIS
EhISEhISEhISEgt4layf0PMu+KJs4xHEIMIgIkhmOpNNnmVlM/vtHaHxfcSe
E0I8jliboZoka5rxtXdsjyMG2KZp+eYxtocYrVOQC2UNxrUaWt/QtJOd7tQA
eZWsn9DzPviSbONRxNp0IiKI8W7hUhfVU8YCIAvGdxF7SgjxQGJdyUX8uMak
FfFxKGR7GLHNmpbvHmObiXVVrI+I6U4Cf9AYoa7P8ngT4lWyfkLP++BLso3H
EeuuYA0eKCNFGv5S6RURV4zvI/acEOJxxKoYhncAQlpdCH8DDH/wu8D2OGJb
NS3fPsa2EuuqSFNtLkeGK95V/BD/FH2uUbwBz8v6rXjOgq/INh5BbAAIVGhe
H6tyQEnydFK5IMOK8Y3EXiCEeAgxVAnoxxXq85zzdoHtccS2a1q+eYxtJzaK
ntg3YkLxn8d4XtZvxXNZXmku23gEsRtQy+UWiqDYeFRWvj7IlQuN7yX2tBDi
McSwp/rNRZP0txCxPZLYVk3LEd4zxnYRa+uKJKA7cxO0z1Fh9WXTdrus34rn
QnCBbOMRxHpkIMp0bUZ+ayuCjkAVxHzJ+GZil+eFEI8hhpLO7Frb82y+L/Nw
EArYHkpso6Zlj/eNsR3EUEkMcbtph5sRJ9wpLf28rN+KpzC4ULbxCGL9/dyh
7sWdCLvccV3X1vlGNv63yDg5PDye2CuEEI8hBq+LxLUty/aSNOSqbo/ZvpjY
Tk3L942x3WKbHa0jlNnqW4x6uBomuzLu87J+K573wZdkG48gxoFd0492mvge
l5N0XQfP/vRz8h+RcXnaHkLsFUKIxxCbvgP/9ySsugW2hxHboWn53jG2gxgd
Gpn/LwxsYb4AntO1Wn6Kl8n6iTwFwcWyjUfqDQ7Nkt+vZd2srJob30vsOSHE
A4l1dWKe7CQviyyAa82wW2B7ILHNmpbvHmObiYEwj2rFedXUZehASK68jf89
ZC5su4bXyfoJPEXBF2QbD9Qb7Aehngna5fZsZcH4bmJPCCEeSaxjyat/mqsO
0mQCtocS26hp+f4xtpEYrTL7dHsqrrrRtQL/4EnyHB+X9fuwAOD/QW9wG37m
QoivJNYKZS7v2B5MbKum5T0+CTHuN7ZBXX2n8fv58Wll/SSxvZDEdoKmZ3h4
9Oj3BD4jPq2snyS2F5LYTtDIMU37XPzscq2EhISEhISEhITEu/A/ccsdgw==

              "], {{0, 42}, {317, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {317, 42}, 
            PlotRange -> {{0, 317}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"921f1b69-9cc6-42a6-96dc-43335871513c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x27.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"669abaf7-32f9-4b72-9cf4-5cb18d3261a8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e802e7fe-c7c1-4b55-82d4-91225044cd93"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"29cafec0-cf3d-44c2-988d-071e8178e78b"],

Cell[TextData[{
 "Make graphics of a 1000-step 3D random walk which starts at ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "InlineCode",ExpressionUUID->
  "6c99385a-3cc6-4415-b48f-6fb5f8b0c822"],
 ", and in which at each step a triple of random numbers between \[Minus]1 \
and +1 are added to the coordinates."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+27.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"ccbf82f7-e3ac-4c80-9c2f-a12a6696e5b9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f1b48cdd-ea58-441b-8c34-2e74dff4293e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb2OJMl1hUuSI2cAWQLWKzljjbfOmi1ANASMNYKMsdgUtEMIS1DAUIBW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            "], {{0, 278}, {324, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{324, 278},
          PlotRange->{{0, 324}, {0, 278}}]], "ExerciseOutput",
         ImageSize->{328, 278},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9c53b877-fd24-48b3-ac35-904fbe021a4f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb2OJMl1hUuSI2cAWQLWKzljjbfOmi1ANASMNYKMsdgUtEMIS1DAUIBW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              "], {{0, 278}, {324, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {324, 278}, 
            PlotRange -> {{0, 324}, {0, 278}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f39d9cb3-a853-45df-8f55-0232c02a8485"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x27.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3b3467e7-3c2b-4d38-a1fc-6064a1a64523"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f76d6009-bdfa-4bca-953c-306cfd03af2e"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0dadcc07-3a2d-4d82-a1c1-f80fc1af3958"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Applying Functions Repeatedly: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR
EWwgQQEDRkORWBHFQkCw14AEASUGo9hQyax8PokvL++9vPz+uJ/vnHvOnXvP
OXc+o5GQEZIIAwCyCOgQws5xFQrZeaEy6EO4IIufJOBxfQUiXhJPyEqAUKMP
BR0AxcefL8iAUa90gUgY4u3GjIqOYeL7AQyIAAcsAGBzsjIDQr3CJN6+nu7M
LNQJ/Ite3wKSBcF1E58gJhP8f5LlZApFAEBBKFtxeVkclAtRTssRZUrs0yjT
E1IlDGMkLEQ3iLKihJPm2fizzzy7SJibLuCiLNlzJjedK+EelDdni3koI/4o
F2XzeTko30BZO02czkf5rSQ2ncfOAgAjyY62iMdJRtlckihhWIg7ygsBIFCS
vuCEL1jEyxVJDuWekZkn5Ccli5j6HAOmhb09i+nDy0njiUQmQWxOKlvIZbpn
pGeyBXkAzJ/5s+QkuWWiSba1sLe1NbE0tfgiUf918m9KUtt5ehn8uWYQo+8P
21/5ZdQBwJpBc7PtD1vCbgA6NgKgeO8Pm/YBAKTRurUPfHEehqRfkkWiTAcz
s5ycHFM+j2MqSejv+p8Of0NfvM9Ustzv6WF68BLZ4jQRU5I3TkZahljIzMpk
c3hMkz838T8O/Ot9GIfwEnlCngCNiEC7jC9IQsst4PJF/AwBky/4T0X8h2F/
0nxfo6LVfwL0OFMgM0AHyM99AEMjAyR2HzoD/V43f2IEkNy8SPXx+b7/LOjf
V4XLJAP6Gfkc5x4SxuSIhdnzc5JrCbCABKQBHSgBNaAF9IEJsAR2wBG4AE+w
GASCMBANlgMOSAbpQAhyQD5YD4pACdgGdoJqsB/Ug0bQAo6BDnASnAMXwVVw
DdwE98EwGAPPwDR4DWYhCMJDVIgGKUHqkA5kBFlCLGgR5An5QyFQNBQPJUEC
SAzlQxugEqgcqoZqoUboW+gEdA66DA1Cd6ERaBL6FXoPIzAFpsOqsC5sBrNg
V9gPDoOXwUnwCnglXAhvhavgOvgI3A6fg6/CN+Fh+Bk8gwCEjDAQDcQEYSHu
SCASgyQiQmQNUoxUInVIC9KF9CLXkWFkCnmHwWFoGCbGBOOI8cGEYziYFZg1
mFJMNeYwph3Tg7mOGcFMYz5hqVgVrBHWAeuLjcImYXOwRdhKbAO2DXsBexM7
hn2Nw+EYOD2cHc4HF41Lwa3CleL24lpxZ3GDuFHcDB6PV8Ib4Z3wgXg2XoQv
wu/GH8GfwQ/hx/BvCWSCOsGS4EWIIQgIBYRKQhPhNGGIME6YJcoQdYgOxEAi
l5hHLCPWE7uIA8Qx4ixJlqRHciKFkVJI60lVpBbSBdID0ksymaxJticHk/nk
deQq8lHyJfII+R1FjmJIcafEUsSUrZRDlLOUu5SXVCpVl+pCjaGKqFupjdTz
1EfUt1I0KVMpXymu1FqpGql2qSGp59JEaR1pV+nl0iulK6WPSw9IT8kQZXRl
3GXYMmtkamROyNyWmZGlyVrIBsqmy5bKNslelp2Qw8vpynnKceUK5Q7KnZcb
pSE0LZo7jUPbQKunXaCN0XF0PbovPYVeQv+G3k+flpeTt5aPkM+Vr5E/JT/M
QBi6DF9GGqOMcYxxi/FeQVXBVYGnsEWhRWFI4Y3iAkUXRZ5isWKr4k3F90pM
JU+lVKXtSh1KD5UxyobKwco5yvuULyhPLaAvcFzAWVC84NiCeyqwiqFKiMoq
lYMqfSozqmqq3qqZqrtVz6tOqTHUXNRS1CrUTqtNqtPUF6nz1SvUz6g/Zcoz
XZlpzCpmD3NaQ0XDR0OsUavRrzGrqacZrlmg2ar5UIukxdJK1KrQ6taa1lbX
DtDO127WvqdD1GHpJOvs0unVeaOrpxupu0m3Q3dCT1HPV2+lXrPeA32qvrP+
Cv06/RsGOAOWQarBXoNrhrChjWGyYY3hgBFsZGvEN9prNGiMNbY3FhjXGd82
oZi4mmSbNJuMmDJM/U0LTDtMn5tpm8WYbTfrNftkbmOeZl5vft9CzmKxRYFF
l8WvloaWHMsayxtWVCsvq7VWnVYvrI2sedb7rO/Y0GwCbDbZdNt8tLWzFdq2
2E7aadvF2+2xu82is4JYpaxL9lh7N/u19ift3znYOogcjjn84mjimOrY5Dix
UG8hb2H9wlEnTSe2U63T8CLmovhFBxYNO2s4s53rnB+7aLlwXRpcxl0NXFNc
j7g+dzN3E7q1ub1xd3Bf7X7WA/Hw9ij26PeU8wz3rPZ85KXpleTV7DXtbeO9
yvusD9bHz2e7z21fVV+Ob6Pv9GK7xasX9/hR/EL9qv0e+xv6C/27AuCAxQE7
Ah4s0VkiWNIRCAJ9A3cEPgzSC1oR9H0wLjgouCb4SYhFSH5IbygtNC60KfR1
mFtYWdj9cP1wcXh3hHREbERjxJtIj8jyyOEos6jVUVejlaP50Z0x+JiImIaY
maWeS3cuHYu1iS2KvbVMb1nussvLlZenLT8VJx3Hjjsej42PjG+K/8AOZNex
ZxJ8E/YkTHPcObs4z7gu3AruJM+JV84bT3RKLE+cSHJK2pE0meycXJk8xXfn
V/NfpPik7E95kxqYeih1Li0yrTWdkB6ffkIgJ0gV9GSoZeRmDGYaZRZlDq9w
WLFzxbTQT9iQBWUty+oU0dGfqT6xvnijeCR7UXZN9tuciJzjubK5gty+PMO8
LXnjK71Wfr0Ks4qzqjtfI399/shq19W1a6A1CWu612qtLVw7ts573eH1pPWp
638oMC8oL3i1IXJDV6Fq4brC0Y3eG5uLpIqERbc3OW7avxmzmb+5f4vVlt1b
PhVzi6+UmJdUlnwo5ZRe+criq6qv5rYmbu0vsy3btw23TbDt1nbn7YfLZctX
lo/uCNjRXsGsKK54tTNu5+VK68r9u0i7xLuGq/yrOndr7962+0N1cvXNGrea
1j0qe7bsebOXu3don8u+lv2q+0v2vz/AP3Cn1ru2vU63rvIg7mD2wSf1EfW9
X7O+bmxQbihp+HhIcGj4cMjhnka7xsYmlaayZrhZ3Dx5JPbItW88vulsMWmp
bWW0lhwFR8VHn34b/+2tY37Huo+zjrd8p/PdnjZaW3E71J7XPt2R3DHcGd05
eGLxie4ux662702/P3RS42TNKflTZadJpwtPz51ZeWbmbObZqXNJ50a747rv
n486f6MnuKf/gt+FSxe9Lp7vde09c8np0snLDpdPXGFd6bhqe7W9z6av7Qeb
H9r6bfvbB+wGOq/ZX+saXDh4esh56Nx1j+sXb/jeuHpzyc3BW+G37tyOvT18
h3tn4m7a3Rf3su/N3l/3APug+KHMw8pHKo/qfjT4sXXYdvjUiMdI3+PQx/dH
OaPPfsr66cNY4RPqk8px9fHGCcuJk5Nek9eeLn069izz2exU0c+yP+95rv/8
u19cfumbjpoeeyF8Mfdr6Uull4deWb/qngmaefQ6/fXsm+K3Sm8Pv2O9630f
+X58NucD/kPVR4OPXZ/8Pj2YS5+b+w0AsgC3
                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 27  Applying Functions Repeatedly", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
27-applying-functions-repeatedly.html"], None}], Evaluator -> Automatic, 
                Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+27.1", "27.1", "27.10", "27.11", "+27.2", "27.2", "+27.3", "27.3", 
         "+27.4", "27.4", "+27.5", "27.5", "27.6", "27.7", "27.8", "27.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+27.1", "27.1", "27.10", "27.11", "+27.2", "27.2", "+27.3", "27.3", 
      "+27.4", "27.4", "+27.5", "27.5", "27.6", "27.7", "27.8", "27.9"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[39457, 721, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e5ca1503-de4c-4f85-b2e4-1351d32f049b",
   CellTags->"FirstInputCell"],
  Cell[56742, 1093, 813, 26, 
  70, "Input", "ExpressionUUID" -> "39542267-28e8-483a-adcf-ed3892ab7e6b",
   CellTags->"FirstInputCell"],
  Cell[181200, 3219, 813, 26, 
  70, "Input", "ExpressionUUID" -> "65034218-4252-4aec-9f44-ae1a30110326",
   CellTags->"FirstInputCell"],
  Cell[273028, 4819, 813, 26, 
  70, "Input", "ExpressionUUID" -> "89e378e9-2999-4570-8109-1275d4cc8270",
   CellTags->"FirstInputCell"],
  Cell[280861, 5039, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6b812f8e-8c94-4882-8520-c438a943b5d4",
   CellTags->"FirstInputCell"],
  Cell[292993, 5324, 813, 26, 
  70, "Input", "ExpressionUUID" -> "dfc62a23-7ea4-4792-8bc8-3d1fda85833f",
   CellTags->"FirstInputCell"],
  Cell[308142, 5670, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c4e143a1-847e-40d8-9c50-431659fbdf95",
   CellTags->"FirstInputCell"],
  Cell[433329, 7810, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7d5655d3-f8fa-4506-856f-e7f5f0b109fd",
   CellTags->"FirstInputCell"],
  Cell[447575, 8133, 813, 26, 
  70, "Input", "ExpressionUUID" -> "54a951a8-d397-4c45-ab07-abc6e7323d46",
   CellTags->"FirstInputCell"],
  Cell[552476, 9944, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4ba73bad-7a09-4bce-92b2-bf2a7ac2d1a2",
   CellTags->"FirstInputCell"],
  Cell[594218, 10714, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0f2f9e2c-4a31-4f05-9621-ccc2f172fc8a",
   CellTags->"FirstInputCell"],
  Cell[674043, 12117, 813, 26, 
  70, "Input", "ExpressionUUID" -> "666de1ae-b0b5-4901-82e9-61ed1a6d88cf",
   CellTags->"FirstInputCell"],
  Cell[683357, 12365, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c6a8111e-245c-4374-a7f5-7db22f203f4e",
   CellTags->"FirstInputCell"],
  Cell[695590, 12662, 813, 26, 
  70, "Input", "ExpressionUUID" -> "36f8bbab-7917-4ef8-9e55-4d056d2df4dc",
   CellTags->"FirstInputCell"],
  Cell[708982, 12975, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e802e7fe-c7c1-4b55-82d4-91225044cd93",
   CellTags->"FirstInputCell"],
  Cell[743850, 13634, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f76d6009-bdfa-4bca-953c-306cfd03af2e",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 802836, 14853}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[652, 22, 598, 15, 70, "Exercise", "ExpressionUUID" -> \
"ad737e6f-3555-46b0-9cb1-6a79d60e8233",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1275, 41, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"745c1e48-756d-4368-9e20-893d89a75b45"],
Cell[1914, 62, 36936, 634, 70, "ExerciseOutput", "ExpressionUUID" -> \
"038bd1f0-ef92-4fe4-94d3-bff0b70b6800"]
}, Closed]],
Cell[CellGroupData[{
Cell[38887, 701, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"92406dbd-1799-4a2d-bd1d-5482741074fb"],
Cell[39457, 721, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e5ca1503-de4c-4f85-b2e4-1351d32f049b",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40307, 752, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ec2fc926-343c-439c-8dd6-2ea929bc4915"],
Cell[40594, 763, 805, 20, 70, "Exercise", "ExpressionUUID" -> \
"9819306c-e0d2-4d01-8eb3-7aeae512a18d",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[41424, 787, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ce9ac5d7-2500-4093-870b-a4291532616e"],
Cell[42083, 809, 14052, 259, 70, "ExerciseOutput", "ExpressionUUID" -> \
"882341d0-d7e3-4007-b1b1-f78d150f4ed5"]
}, Closed]],
Cell[CellGroupData[{
Cell[56172, 1073, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"94c26d62-ec57-44f9-867c-b7dc75e02aa7"],
Cell[56742, 1093, 813, 26, 70, "Input", "ExpressionUUID" -> \
"39542267-28e8-483a-adcf-ed3892ab7e6b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57604, 1125, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"65f173c3-804f-45a2-9062-0a3a39be4b12"],
Cell[57891, 1136, 590, 13, 70, "Exercise", "ExpressionUUID" -> \
"2538dd78-088c-4faa-addb-b5cb6ac256ea",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[58506, 1153, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"898fdbed-24ed-4089-aefd-abfcb5fd506a"],
Cell[59165, 1175, 121428, 2019, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5ca5d859-5c62-44dc-939e-d5305b89ebc5"]
}, Closed]],
Cell[CellGroupData[{
Cell[180630, 3199, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"dd26e851-fef4-4902-b701-006f4dc51f2f"],
Cell[181200, 3219, 813, 26, 70, "Input", "ExpressionUUID" -> \
"65034218-4252-4aec-9f44-ae1a30110326",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182062, 3251, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"90d7736c-9cd1-413a-a9e2-31f4774d2c35"],
Cell[182349, 3262, 912, 28, 70, "Exercise", "ExpressionUUID" -> \
"2543d8c1-91b0-4171-a0d7-2f56b47ed120",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[183286, 3294, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d11fac1f-3e91-43d0-a13a-a7b94d5f3e12"],
Cell[183925, 3315, 88496, 1479, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2fb3030c-bf55-4830-a584-3c282dc4cf20"]
}, Closed]],
Cell[CellGroupData[{
Cell[272458, 4799, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"7a068b90-6d66-4d58-a2e5-6a7d8f031fb1"],
Cell[273028, 4819, 813, 26, 70, "Input", "ExpressionUUID" -> \
"89e378e9-2999-4570-8109-1275d4cc8270",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[273890, 4851, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3e40534b-59b4-4bf5-83d2-cb710d2246f2"],
Cell[274177, 4862, 777, 22, 70, "Exercise", "ExpressionUUID" -> \
"d9fccc5c-0e2c-4859-b945-8f4a30826f9b",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[274979, 4888, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d6c3ba77-4694-4a1c-b64c-8af8c64332a6"],
Cell[275618, 4909, 4636, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1f8dff70-3175-4b16-99fd-70bf1c2d5345"]
}, Closed]],
Cell[CellGroupData[{
Cell[280291, 5019, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"22759a9a-248a-43a9-989e-13aef9e081d6"],
Cell[280861, 5039, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6b812f8e-8c94-4882-8520-c438a943b5d4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[281723, 5071, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e07cc2d6-9489-428d-b5c8-41ef62086e29"],
Cell[282010, 5082, 478, 12, 70, "Exercise", "ExpressionUUID" -> \
"cd52a69a-3b40-460e-9267-5085fa76a0e4",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[282513, 5098, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"90053c27-57e1-4f9c-b978-f7e983565e71"],
Cell[283152, 5119, 9234, 180, 70, "ExerciseOutput", "ExpressionUUID" -> \
"0bf2c7ea-3ed9-48df-8d76-36256e1931df"]
}, Closed]],
Cell[CellGroupData[{
Cell[292423, 5304, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"780d96ff-9a81-41b3-8459-75867182a670"],
Cell[292993, 5324, 813, 26, 70, "Input", "ExpressionUUID" -> \
"dfc62a23-7ea4-4792-8bc8-3d1fda85833f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[293855, 5356, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"24d9ca9e-6123-4670-930f-8b76d0e2d54b"],
Cell[294142, 5367, 1161, 35, 70, "Exercise", "ExpressionUUID" -> \
"7c227643-a805-4b24-bf7e-89d801c32534",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[295328, 5406, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4522f863-76df-4652-bf6b-773ece6209f4"],
Cell[295967, 5427, 11568, 218, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5def1c6f-ad03-43e5-84df-dd603681e860"]
}, Closed]],
Cell[CellGroupData[{
Cell[307572, 5650, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"37fc1bd6-2722-474c-866c-1b18d67a98f7"],
Cell[308142, 5670, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c4e143a1-847e-40d8-9c50-431659fbdf95",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[309004, 5702, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b1c29251-c52d-434b-aaf3-e538bc17f5be"],
Cell[309291, 5713, 762, 18, 70, "Exercise", "ExpressionUUID" -> \
"01ad67c9-8f59-4f0c-ac6e-11bbb401e7b1",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[310078, 5735, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"39a5cde7-56e6-4f6d-84f3-0949b894c9b3"],
Cell[310737, 5757, 121985, 2028, 70, "ExerciseOutput", "ExpressionUUID" -> \
"46c046d9-6399-4b30-a20b-2cd7da391d66"]
}, Closed]],
Cell[CellGroupData[{
Cell[432759, 7790, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3c38b813-006e-448b-b622-a5ff456ebaa4"],
Cell[433329, 7810, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7d5655d3-f8fa-4506-856f-e7f5f0b109fd",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[434191, 7842, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4060a584-fc0b-4e03-a784-289ad869c35e"],
Cell[434478, 7853, 840, 21, 70, "Exercise", "ExpressionUUID" -> \
"9170917c-d442-4629-937a-bf53ae3495c7",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[435343, 7878, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"28315b4b-4048-4a5c-af41-efd351a768da"],
Cell[435982, 7899, 10986, 209, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b0038e7c-7faf-48be-a95a-df2a1aed2ace"]
}, Closed]],
Cell[CellGroupData[{
Cell[447005, 8113, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"282cf1a8-20cf-4e14-a622-88bc000467fb"],
Cell[447575, 8133, 813, 26, 70, "Input", "ExpressionUUID" -> \
"54a951a8-d397-4c45-ab07-abc6e7323d46",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[448437, 8165, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e1537465-623d-4839-82ae-561607a81a40"],
Cell[448724, 8176, 857, 23, 70, "Exercise", "ExpressionUUID" -> \
"6687eadb-a8c7-4fa6-baa8-76c21c8515c2",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[449606, 8203, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"84618952-9812-40b8-af36-1e354f94e188"],
Cell[450245, 8224, 101623, 1695, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e1340a62-f464-4c69-953a-cd1743ea9ced"]
}, Closed]],
Cell[CellGroupData[{
Cell[551905, 9924, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"6be4a464-7e6b-432a-9003-1b249d075984"],
Cell[552476, 9944, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4ba73bad-7a09-4bce-92b2-bf2a7ac2d1a2",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[553338, 9976, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a3b0eeca-0116-42b1-a5d2-601e695e14fa"],
Cell[553625, 9987, 519, 12, 70, "Exercise", "ExpressionUUID" -> \
"ffc9ba4a-6069-4f48-96ac-3304a265ded2",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[554169, 10003, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "dd4e6cea-a765-4537-ac47-2b3742a17a43"],
Cell[554808, 10024, 38802, 665, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1f723682-2326-4282-bb80-d125964ec3ff"]
}, Closed]],
Cell[CellGroupData[{
Cell[593647, 10694, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ef390ead-2ada-4a54-8e8f-0726f4016c1e"],
Cell[594218, 10714, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0f2f9e2c-4a31-4f05-9621-ccc2f172fc8a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[595080, 10746, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "348b9f23-99e4-4a1b-97cb-84f607915692"],
Cell[595367, 10757, 880, 27, 70, "Exercise", "ExpressionUUID" -> \
"c0ad0497-c65d-4e3f-b8f4-e6b00bd3971a",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[596272, 10788, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "5c0ca6e1-3566-49f9-abf1-01fdd3828154"],
Cell[596911, 10809, 76524, 1283, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dd5bcf54-a94d-47c0-ab80-26d6ee8b749d"]
}, Closed]],
Cell[CellGroupData[{
Cell[673472, 12097, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ea55d4f2-855f-4ab6-939d-ea1a522a4173"],
Cell[674043, 12117, 813, 26, 70, "Input", "ExpressionUUID" -> \
"666de1ae-b0b5-4901-82e9-61ed1a6d88cf",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[674905, 12149, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "776355ed-a8ff-4c41-b860-b68018ebda38"],
Cell[675192, 12160, 961, 29, 70, "Exercise", "ExpressionUUID" -> \
"b416600e-dc4e-4d40-8f36-308ef9e4f0b6",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[676178, 12193, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "705938dd-a10b-4def-9250-1b8aff1a1f9e"],
Cell[676817, 12214, 5932, 126, 70, "ExerciseOutput", "ExpressionUUID" -> \
"774e45c2-2038-4216-8bf1-173c18dd3c69"]
}, Closed]],
Cell[CellGroupData[{
Cell[682786, 12345, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"bb6e1848-4f4e-46c5-8c9d-fe49d71b8090"],
Cell[683357, 12365, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c6a8111e-245c-4374-a7f5-7db22f203f4e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[684219, 12397, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "9d36a374-16a0-4f53-b41c-7136c6481818"],
Cell[684506, 12408, 1005, 31, 70, "Exercise", "ExpressionUUID" -> \
"4e983ee7-4e30-4498-be88-4fcea6b2805d",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[685536, 12443, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "e4e10509-878c-4871-915f-0bc6fec00de6"],
Cell[686175, 12464, 8807, 173, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ff613ef2-407c-46c2-8f41-7a6143f29080"]
}, Closed]],
Cell[CellGroupData[{
Cell[695019, 12642, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"de9382f1-2d8d-459f-a604-6be7bbcb2036"],
Cell[695590, 12662, 813, 26, 70, "Input", "ExpressionUUID" -> \
"36f8bbab-7917-4ef8-9e55-4d056d2df4dc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[696452, 12694, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "a27ee218-ea7d-4d23-868d-cb2e2d2bfe00"],
Cell[696739, 12705, 869, 26, 70, "Exercise", "ExpressionUUID" -> \
"40f69dd7-db57-4778-a16a-6322d25482f9",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[697633, 12735, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "9cae12d3-baab-4499-bd78-e2147edbaba6"],
Cell[698272, 12756, 10102, 194, 70, "ExerciseOutput", "ExpressionUUID" -> \
"921f1b69-9cc6-42a6-96dc-43335871513c"]
}, Closed]],
Cell[CellGroupData[{
Cell[708411, 12955, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"669abaf7-32f9-4b72-9cf4-5cb18d3261a8"],
Cell[708982, 12975, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e802e7fe-c7c1-4b55-82d4-91225044cd93",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[709844, 13007, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "29cafec0-cf3d-44c2-988d-071e8178e78b"],
Cell[710131, 13018, 775, 18, 70, "Exercise", "ExpressionUUID" -> \
"ccbf82f7-e3ac-4c80-9c2f-a12a6696e5b9",
 CounterAssignments->{{"SectionNumber", 27}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[710931, 13040, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "f1b48cdd-ea58-441b-8c34-2e74dff4293e"],
Cell[711590, 13062, 31652, 547, 70, "ExerciseOutput", "ExpressionUUID" -> \
"f39d9cb3-a853-45df-8f55-0232c02a8485"]
}, Closed]],
Cell[CellGroupData[{
Cell[743279, 13614, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"3b3467e7-3c2b-4d38-a1fc-6064a1a64523"],
Cell[743850, 13634, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f76d6009-bdfa-4bca-953c-306cfd03af2e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[744690, 13664, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "0dadcc07-3a2d-4d82-a1c1-f80fc1af3958"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature GRc2GNw@ZTOoGjI59bSYu0Lw *)
