(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    802839,      15117]
NotebookOptionsPosition[    726424,      13502]
NotebookOutlinePosition[    786887,      14744]
CellTagsIndexPosition[    786807,      14739]
WindowTitle->More about Numbers: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]],ExpressionUUID->
  "a108851f-f607-487e-a01d-4e3c355d27b3"],
 " to 500-digit precision."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"7bf8e880-a636-4171-a32f-a7de3551033e"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f4edd52f-b6a1-4fd1-a655-d29569e35596"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvT3r7My65te2E4f+Cv4A7nhCd+jEDWMm62SGOT04OW7OGEynggkEk8iR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            "], {{0, 174}, {501, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{501, 174},
          PlotRange->{{0, 501}, {0, 174}}]], "ExerciseOutput",
         ImageSize->{505, 174},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "927fa0ba-138d-430e-986c-c09dbf1902ca"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvT3r7My65te2E4f+Cv4A7nhCd+jEDWMm62SGOT04OW7OGEynggkEk8iR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              "], {{0, 174}, {501, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {501, 174}, 
            PlotRange -> {{0, 501}, {0, 174}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e2c3e808-b909-46b5-9c0e-a29f2c66d1f9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9b150c66-34b4-4fe7-b5ec-327cde8e2a51"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"12d1d587-db26-4eaa-80aa-f4168fba2cc8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e84d5398-c877-4564-accd-c681d514eb11"],

Cell["Generate 10 random real numbers between 0 and 1.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"fe4f04e7-d83d-47ad-9f79-2920f1b5f360"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bb6f23d9-3bb1-4046-b303-9a69fd3d246c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa+vvcgVv21NZf+F2gr0WmQVyTZ11+ymy6ZmS7ZNGiwOicNdhUKRNEFh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            "], {{0, 
            42}, {312, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{312, 42},
          PlotRange->{{0, 312}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{316, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "78eee2d2-c7b4-4788-ba86-fa077424118f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa+vvcgVv21NZf+F2gr0WmQVyTZ11+ymy6ZmS7ZNGiwOicNdhUKRNEFh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              "], {{0, 
              42}, {312, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {312, 42}, 
            PlotRange -> {{0, 312}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"814e050d-75c8-4bc8-83b9-8a0c6477799c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d4053647-0720-4e5c-882b-7c70eb7358d4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6b6777d0-3e5c-4e64-a6f7-3722282f10ae"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"bc4e5dfa-d494-496a-854b-0a9988511938"],

Cell[TextData[{
 "Make a plot of 200 points with random real ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " coordinates between 0 and 1."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"6c716997-31c7-40e5-8bd6-b367a6394642"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cddc2de8-ffb4-4d14-9114-f076dd8c6530"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb+P47gVxzdJkzL/Qv6LtCnTXhAgVbB3yfGQRgEugYIUWiALd65cGVio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            "], {{0, 218}, {344, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{344, 218},
          PlotRange->{{0, 344}, {0, 218}}]], "ExerciseOutput",
         ImageSize->{348, 218},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e018ae63-ac88-4dc6-9d61-9c38eab547a7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb+P47gVxzdJkzL/Qv6LtCnTXhAgVbB3yfGQRgEugYIUWiALd65cGVio
UhFXbgycg2CaAVaNCxdqVKhw4cKACxUCVLAQ4FDWjKyxx79kiXwkvx/MzXn9
Y+aRfO/DJ9q39+vv/vYN+/mHDx/+/kvx7Ztv//nbH3/89l+//5X4wx+cv//1
B+f7v/zO+cf3P3z/42+++4W4MxH//PFnHz6Ut3f3wxhr8SoAgEnAAwAAeAAA
AA8AAOABAIwkT2bMmWRv71yHPtvjh+vm/fAAAOaxWU7KanenefPebOkyJ9xw
vgkd5kaNx+ABAEyDx0N3NJsMRD/Q9EAeB4xV9/Cpw4Lo0CzAAwAYSbGavFb9
C8ID7nhZ3Y58z3/rgRq5YQIAeiRPTjwQBc54Ud1ejl0f/QAAppPHBw/wPM3y
Yrd9ZmyQ8LJXGDA2X/P6yaZ64D//i/88+K/4rjoQW8CEU4Mn0/p8oDwYCMql
iWfDqvkfTN+slKkeEDn5p3//JL6rDsQWMOG6UPA858XRnaZ6ANuTZDDhWmOq
BxTy6ctXsTOK76oDAeBW4IHOERKovqo/YqME9IEHOueoH8CFM6APPNA36AcA
fYQHJGRpt7WgV2W9G61eQwDGU3+YsNec7LY31qvTfjdavYYAjEcYoDrU6jUn
7ewHqjg/ffmKfgAQp+oEkJN9gE3fYAyrGprnhA9OMpE1IhIG6APDJN+5BzpJ
/gcnucM1ujwcVLq1nC691snQuQc6qUE6/cDl4Ri2KYBH0DoZpPUDmtoS/QC4
Ea2ToSsPXJ0ErW0JgNl05YGrZa61LbVGuytZ4uEZibR+AKjiVNHEezPi4RkJ
/nJCjWgnW/QD4CqdGAALJ4cLGyWWQAvILlMnHkAjJ4cLWSRnCcimsS6QrRT0
AxfQaFxyQiWbxrpANqNwMnABw9L+8SQkm8bgQeCBC0hLe+zmQC1HHoDwlYCr
e6CWIw9gy1ACKhSoBf0AAACfIwIWgv3uCBgAWAiuf4+AB4CF3N4PWNI5wAMA
VLxb8pZ0DvAAABXvljz6AQCkQaHcKMTQ5IF4eOh7++N/73mdNx9InsbV+wKj
edz8f5/DAzt6CWAhlrTft1BnY+s5yaKAMX/Dd5vQZ84kqx/gscvY84YX25Ax
N2oYAh7YIQkJABXX1NnYek7iwHGC/asKUfjOod5LDziLbbHLli48cAKSsDWY
us55fErjwBsv0v3NLHC85aHe81l5ueA44ps7zRovgQfAI5xrpWT6AS46Igrc
Vw+kPnNrD+SxuF6oLhOyqcv86GAC1kB6vB2AHFDLufmXeamFy7ojtuGIuTMu
rgPWc8YGq2LH8zTLizyZMObvBZHPTjygLNwuQA7QBP2AUrLZ0Kk292lc1n3Z
CJQnBtnT2K3ud0bztPEC3T2AHADgXXie8+Kd+wvxQH78gO4eAAA8DjwAWlM1
Y5++fEVLpjvwAGhNdThTfd14RIPrOJrAA6A1opw/fp4LCYjvN5Y2znVpAg/c
BbazI+6ta0zgXUibLnjgLrCdHYG67hVp+QYP3AXSHshEZj+g74cJAQCdAAMA
0ALDOkN4AJxiWJL3gWEnRfAAOMWwJO8Dw1QJD4BTDEtyUtCcW3gAAJnQ7LVM
9QBN6wIDeDC1aGamqR6gaV2Z0Mw3AzAyte7ygEappVGoPWFkulLAyNQ6+hzR
hTGKO+/6L8uAWoxMV9ATR/3AhU2k/o9MiaeW8flv/ACBfI48cLkf0CL9jO+H
jR+gYTxeOBJKz7xzQl181RrjB2gYj3tbgvnN84C1wA80QT8ALtPt+hK5XoCO
dAQeUEi3lUukAB8cFJFR2AY8oBAjc/7BQRHpamwDHgCkMNKN9IEHAAD4e8kA
ADAAAAAeAADAAwAAeAAA+VB7WwQeAFehlrQG0PPHJHjoe/vjf+95nTcfSKOZ
Uz0QhLxxP0EPIOuogc/2dE6vSZ5FAWP+hu82oc+cSVY/wBOXsVmSixtCE7P1
wQQEPYCs2xGTIalgwFXiwHGC/WIVscuc6LUjyOOADZ+229UyilfrbV4cXkLQ
A8i6HWSoPwrTOA688SLd38wCx1vWHkimot7dUTAZi3ZgEB0ahcPniAgKwWaa
WQQx6ohCk0eB++qB1GfuwQPxRFwvVH8Kh8xviODG8kcqKgS9gY4oLJltOGLu
TFz88/Vc7PurYsfzNMuLYlP+MSlPBbKAsSC+2wNIRYVAwuBOstmweluATeOy
MYj3ZS9uJPNRdb87fm6+kYB+4EYwAwTBolyA5zkvbn0AxwI30lVHhNTtELSp
XdGHB4xM9VsGdctzkLodokWmaRFkHx6wNtVvGbgWWQE6RItyQD/QIdYOHFxA
i6zA+QAA2tG5W+ABALSj82sNfJgQAO1APwAA6ByZHtDiwEQt9kyRPSPVApke
UPUGikYpp8V7TJ1gz0i1wIZ+QKOU00hZD2LPSLXAhvMBpJxJYDX7oD8P9Lde
lmeC5cPXqLvTiP480N96aZEJ/VWrFsPvD8s12BPoB3qiv2rVYvjgXtQuqw3n
A0o4WlYUL7iM2jYPnyeUg5JVhnxU0WLm0Q/YgJJVruQjvqACyWh3hgMPGIwo
/8oDGiWkGWjXicEDZqNdQgIl2OkBVIfxfPryVTRC4rvqQPTATg/IuXyDbRRS
XRCJL9WB6IGdHpBTododFpkE+oG7sNMDckA/AHQBHgAA4HNEAIBuDaBLJ6xL
nADIoVsP6HIyVsX58fMcNgBgZ1Y/cPtvr5758fN9n7VDFwFM5YIH6KT9jZHc
243cO0Bduh1ABDoVdJULHqCT9jdG0ve0a7SsNTrGbAzqKoiHvrc//vee1/nJ
o/nMY0GcNe/SpR8Q1/KijacQjF7QkbmFqKqgLAoY8zd8twl95kyyt4+u5gNR
9ZP4jR90eccQ+dwOOjJXgp3DjwPHCfZDLmKXOVGj4vl6xtjAH7pBdGs/QAo7
FxQ8iJ3bRxx440W6v5kFjresPVCshow9p7v1dBDEvPkSXTwAQAvs3D6iwH31
QOozt/ZAMnFEMzB/no89xx1Nou1BBayBgoilYGcygHrdbUuAbThi7oyXVwFz
UfirYsfzNMuLbB0vl4vFcjEZOoPgaZ0V9UsMLv8aO5tDO2mWfL3u9iVANhs6
1eY+jcvGIA4YCw4aTCZeoOc54SNKV7gd2LYTKadZ8tb2AxU8z3lx/WkVcjzw
+EJoqnTiYZtXIOaNSA5yPPB4OWi6vp2H3e0PJK4pIA1d+gFQ0W3lYl1AhS7n
A6ACldsVF2bSwkmGB4CdXOisLLxcggd6gtqeQi0e5aAfaGL8h4hUQW1PoRYP
IAUM0BPU9hRq8VgOteWABwCQD7X2DB4AoB2afsb1XeABcC/UclgVrfd0ghMI
D4B7odbTdsW95dm6nAlOIDwA7oXgdtYJ0sqT4ARK8ADBUQNwis2JKsEDBLsg
AEAT9AMAgPrzhKhWYAlI9VPqfgDdO7AEpPoptQcgSUCcrlIUqX7K1fMBTBog
Avbx/rjqAUw+uIy0naLDX9RHzFrvmOgHVGHMxOq4U/QRs47zUIPPE6pC67Rp
oqPQ0A8cYZ4HdFkOXeIENmCeB3TfZ+EHIB/zPKB7HenuMaAj+PsJSSH09fHz
/OPnn/T12AWI/19dbOZBA2AhusXsZqDz0Zk9XTK53QPNkq9vYyG6hZpXW8fz
7gvN7gdIBXMvt3ugWfL1ba3HDq7S2vMWbhBaD/nBfqDP0BSgalxyfm+L39Jt
P2A2Wg9Z6xPCzmdeldLl/F6tNyxwDzz0vf3xv/e8zpv3L6fD6n2BQRA2H9Da
A50nNvoBYABZFDDmb/huE/rMmWSv9xebOWNulBa7LB4wNlvx+iU0PXBjxiKx
+wNzqy9x4DjBfuGK2GVO9LrxF2n8FCZFeTP3hSni2hBEPWBeB6tdWZm3BLrw
eKrEgTdepPubWeB4y/zo8WI5EVcN/rZxF2vQ+vd2jnZVcxXtysq8JTiF5hgf
T5UocF89kPrMfeOBYlM6wJ1sijcvIVX+BkMz5SyHppwfT5VtOGLuTFz88/Wc
scGq2PE8zXLxr/VIOCBYlGIoiqYJ4AHQB1p4T4sgW5HNhk7V5E/jsjGIA8aC
eD0fNvv/CfnzAaA7NLdaq+B5zovrT6sg6wFzXW0FWD69IOsBbCgASIOsB/CJ
ViAfIskjPwyyHmgNGgnQmnPJI7kw5eeweR4gonSgI+eSR3Jhoh8AgCDGby4E
P0zYFcavXd9gAu3BSANU4KDgQTCB9mCwB7CdVeCdF3AVgz0AKtRu65BJBXEb
d+4ByutOObb+UDvq1hYybLGuzoPatyqEB7qdcMoXlZRjM5XW2WXGYtXDvzoP
aj+6IDzQ7YRT1jjl2MARZizW7cWldryd9wMAgBpdigvnhLpAM6NoRqUdyqcR
HtAFmtfLNKN6F+W1dgHl02jw5wkNg2Ya04zqXdrVmiV/pTwM0B/KFxc0abcc
yndqOcAD/WFJCpmNJTKHB/pDixTSIkjQN/CA5aBpATt4QAWktmBSwdyCdgFr
ATwgH2zBj4DZ6wNpHoDGa/qeCrOn2uzRqUKaB6Dxy3SY3phqCRimI2mfIzJs
3jqnw+LFVEvAMNnifIAIKF69MGy94AEAgEwPGKZQAIxBpge0vqSyVmLWDtwq
TOoH+vv54mcKg+krsUfQ2t7ngNyO0Pp84Cj4/jK2+sniq9vM0WLyL5SMFvG/
S7Wg+sZf0WH8d/2o259cJc+9cT74/KuSb/3zb9w+JI8Xz2/9fCX5qfz5Xf2o
25/czrd4Pp5v5POJ7CNd/Sj41sjn11l6719aSyT+zp9/bhJa//yPn+diWxTf
28XT1fPrVwEADKaFFh5RCjCJ5vaHg/RdD5NAf1bhAQAAPAAAgAcAAAAAoBN8
Hbj7U1HXX/PG/cVmOnSq89IgXCsL7xp8HXr7ID0/5CeP5smUOZNMQVy3sg79
apL940lOZy/zPwg3pyOjwrn4s+TpJa1G81RVcLeRJ7PTJDm/LmYSBa4zFhXE
Q99xgsPR6+bJE5OTFmJBZyIVV4XCGC+QTRw2Djc7vhHLFsRvF5MngzIRp7mi
4K6TLV3miDLnm9BhbtQINJm6zJuJO5KZy9w51ek/F38+ddjoeSPyaFyuC90V
2Cwn7DRJzq+LoeST12Xiibh5sGKahGGyFzlfMuYQnYo8EssU73fLZOKyIGo8
xucD0SSMXY9uP5DHgZjz/dRyUThBVEcq/ObMk80qiuJktU1pzv6F+HOhsfFi
K/JIiPrYz3Tg8dAdzSYDseU1p/j8uEwlm7juohplvnTfaaG3orwcf0F0P8oj
z/GrtjOLfNc/eGD9NGTDcLdbDdwJ2a5a5Js7Xla3I9/z39aRuNYJpiJHmTeJ
zv0EtZyPX7Qx5eWaW17ZeGQ1UFGsJq9V/8KFcRlKFjivHsgWrhM0B8w3izIJ
A6oS2JUecNmrB5bjgwd4LBJwEMyfpmNHlNFTTFMFeRQ440V1ex/+wQMiNcdV
E5Y+i5aNZiKejX/fp1V/SqYe84l6rCJPTjxwdl1MpQiH4jJ0JW6tyjZ6Luol
T9O82PH1U3lCuCgPSYqCrAk2I8ZmK15eBXgifDEQnqZZUWTxcrkQPIu2dPAU
rYkOYCtqfJDwck8Syp2XB7X7+HfFk1iNWbIr+5zgKEsJcRo/z9NMfI9FF7nY
C1p4wCHugfjggTJ8kf3vrIvpZPHw5WPUw7328qA8MUifXu+tDuOJng+U4c9e
YhzMyrwrd6LGaUYRey7VItoTz14mejDdH9LW8Wfx6OXtGvd5RXcER/HXV9bJ
0/hlXZxRnBHVcAXfv6lUTXG8z/7d6bpYQZHnOemlukzB81xjY+/Df3/6tViX
s/GXD9A12FUurAsAAAAAAADATv4P9BghUw==
              "], {{0, 218}, {344, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {344, 218}, 
            PlotRange -> {{0, 344}, {0, 218}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"53fe4fdc-2f23-4e72-bf78-a377865316f9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"354ceec6-0f3a-48df-b637-3b83592bcc6b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f5bf58d5-6f62-4b51-b5ff-6a37c8c452be"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fa13738a-d3f6-40fa-8c37-aa866d6bdcff"],

Cell[TextData[{
 "Create a random walk using ",
 StyleBox["AnglePath",
  FontFamily->"Source Sans Pro"],
 " and 1000 random real numbers between 0 and 2\[Pi]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"85ca8bc6-a8c8-4861-8b02-9c57089caf01"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"439f2940-8cf9-4ced-b792-95d9cf242541"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvQdYVMcX94/B2AuW2DsKKCKoqNiwVxB7xw7YUey919hr7L2gsRB7i2is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            "], {{0, 326}, {337, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{337, 326},
          PlotRange->{{0, 337}, {0, 326}}]], "ExerciseOutput",
         ImageSize->{341, 326},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fd6930d0-b6e4-4309-a13c-500f96dbbd16"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvQdYVMcX94/B2AuW2DsKKCKoqNiwVxB7xw7YUey919hr7L2gsRB7i2is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              "], {{0, 326}, {337, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {337, 326}, 
            PlotRange -> {{0, 337}, {0, 326}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2daa627b-ebe5-45d6-9ad6-aedf86fbd362"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dd9cf8c2-8f0e-4c1c-8a7d-03d80ebd7e05"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"919ff578-a976-41f5-9f4b-f6d8c5a98a4a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c0d1df91-63ae-4961-8c2a-7cb8d9352aa8"],

Cell[TextData[{
 "Make a table of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Mod",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", "10"}], "]"}]], "InlineCode",
  ExpressionUUID->"15b0f936-5325-4c44-901e-4fd87b4b3b4b"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"6e544245-3e19-431c-ab84-e4f5634ffbeb"],
 " from 0 to 30."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"86e75ce7-3499-4933-bee7-2fa6ef1bbf15"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f509fe8e-3a16-4ab2-9a91-c8b64bfebe83"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW6+P60YQ3raksFL/gv4DxqWGRZFe9ZjJe+r5qeRq3atUmZoZGlRaZmRk
ZGRkYmRiYrLEwMTEwMDEYEG6s5tcfBf/2Pja6hTNd7poE09mv9kvmszsOj99
/uOD/S0h5Ov34uHDp7/Mp6dP7q8/iCcfH7/+/uXx4bdfHv98+PLw9PPn78SL
P4r/v78hBMZHBAKBQCAQCAQCgUAgEAgE4p7Rp75tGE41wpOmzOIozspm611D
XVXNwHX8s7Js+nHFVZklcZwKo3VHvG/yNImTlHVL3njLqgtYszKrhrcbuEls
RnrUXDdUYR83CVThZHKPKgyRbZqWV3Sndw0VJYTYftLyY0ktMSYGPFhhueSw
jl0i4RfbgRTBAVz6xfxl3vimnFNO6qaLH5WBRWSCiM2uzBAYUyuzHN7gTZub
VqTa64Yq7OOmFSmqsM/be1GBszS0Jp6HMiAkAMZDIQgeaClnh2G1kDubLPIc
oEfLDcnGOlYkldtrtBlEEdcil/LEFSydhXXpgRFxa6DUxz6dV+w4UJMcwkp4
k1jipeVNm5tWpEfNdUMVdnLTivSIKuzy9q5UYOGBGIF621hB+hpgAGVY1im6
qRgHS/la+jiAwbpkrS8CNS3LIGYwH0gpWJ2ZqElDNjMpbxOZqFf4KHS+WBC2
UY5qetPkpi5vRnrGxrqhCvu4qcuowgR3q0Il8rJB1fR1ZClidWyLOLpTVLW9
LtlYmluSVVDlkbRpI0iWy5IR/+Slz5d8yhLxkDNROYZhlLJ+QZShlDWr5di2
F0SsmzfT9KbJTTPSE7bWDVXYx00z0hNQhRu9vSsVmExZYtTXmSMypWwkZYKl
Z5HG0CQmrXZPzZtE9sitGEtXbN5NHck19ij1VKdO5z4naoNOwHY9C+zMU05+
PWvtmYbth2ka2WB2mG2sNb1pctOM9Ox0Y91QhX3cUIWrWe9WBS6bUz9hPhAx
MukAct1zfXhsRFrzV75QNqYeQkj9xPGDIPAOqg/O5tvlvs4Dz3U9mheJuTCp
WmTZegNTwU029avoc2NhY1Dfmwa3GyIF6HzjoAo3c0MVVnFvKoxU5lDeM0im
XgYvMRGIkavrXQYJtloumHkFfeuiwZhHNKA0APgHmfzDfOO0YoQ6lsAJ6PWl
asLtOAjyC3XpZIdS7vvNfgC0velwuzHSjXVDFfZxQxVmaN2rCiMLYfOtgBqv
jkWvKlOc7C6JHTVdE8JIHi5w5hrE9NLJccRYV1WVgwc3yllVteOs2YXlpfa+
MuNd7lhezpq6jCFdOwmfn7T1xFWLsq4r5ZEr7BxemSXQCXtF3XZNGUALbqRi
kfd60+amFanuuqEKqAKqsKLCabueKrPnk8cj3AESm6oTJmZSD+qyDD24pMhR
bglOAPtp12YXPB/gznjjXWGf704xbNrw4/ykcESSWecZ3aicNRua3L2QM8Oi
e4s3fW46keqvG6qAKqAKiyq8PHmURw/+5S186MXfpDCE8uyygbaIt5gNfd8P
46aZJCcM+boZH0UAL+7lfYs3bW6v8SYzVGEnt9dAFe5PBUahsFNmqpE0nzPq
S7SpqEFJVG3ckodmaIZmaPbfm41FCB3u5I6ysYh82/bmfyswtHW7/sMlNEMz
NEOz/8dsTH3H8cJ6s5JDIBAIBAKBQPzb+AfgjqT3
            "], {{0, 19}, {405, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{405, 19},
          PlotRange->{{0, 405}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{409, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "23308079-6973-4a2e-8a18-0c3be22b0c8c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW6+P60YQ3raksFL/gv4DxqWGRZFe9ZjJe+r5qeRq3atUmZoZGlRaZmRk
ZGRkYmRiYrLEwMTEwMDEYEG6s5tcfBf/2Pja6hTNd7poE09mv9kvmszsOj99
/uOD/S0h5Ov34uHDp7/Mp6dP7q8/iCcfH7/+/uXx4bdfHv98+PLw9PPn78SL
P4r/v78hBMZHBAKBQCAQCAQCgUAgEAgE4p7Rp75tGE41wpOmzOIozspm611D
XVXNwHX8s7Js+nHFVZklcZwKo3VHvG/yNImTlHVL3njLqgtYszKrhrcbuEls
RnrUXDdUYR83CVThZHKPKgyRbZqWV3Sndw0VJYTYftLyY0ktMSYGPFhhueSw
jl0i4RfbgRTBAVz6xfxl3vimnFNO6qaLH5WBRWSCiM2uzBAYUyuzHN7gTZub
VqTa64Yq7OOmFSmqsM/be1GBszS0Jp6HMiAkAMZDIQgeaClnh2G1kDubLPIc
oEfLDcnGOlYkldtrtBlEEdcil/LEFSydhXXpgRFxa6DUxz6dV+w4UJMcwkp4
k1jipeVNm5tWpEfNdUMVdnLTivSIKuzy9q5UYOGBGIF621hB+hpgAGVY1im6
qRgHS/la+jiAwbpkrS8CNS3LIGYwH0gpWJ2ZqElDNjMpbxOZqFf4KHS+WBC2
UY5qetPkpi5vRnrGxrqhCvu4qcuowgR3q0Il8rJB1fR1ZClidWyLOLpTVLW9
LtlYmluSVVDlkbRpI0iWy5IR/+Slz5d8yhLxkDNROYZhlLJ+QZShlDWr5di2
F0SsmzfT9KbJTTPSE7bWDVXYx00z0hNQhRu9vSsVmExZYtTXmSMypWwkZYKl
Z5HG0CQmrXZPzZtE9sitGEtXbN5NHck19ij1VKdO5z4naoNOwHY9C+zMU05+
PWvtmYbth2ka2WB2mG2sNb1pctOM9Ox0Y91QhX3cUIWrWe9WBS6bUz9hPhAx
MukAct1zfXhsRFrzV75QNqYeQkj9xPGDIPAOqg/O5tvlvs4Dz3U9mheJuTCp
WmTZegNTwU029avoc2NhY1Dfmwa3GyIF6HzjoAo3c0MVVnFvKoxU5lDeM0im
XgYvMRGIkavrXQYJtloumHkFfeuiwZhHNKA0APgHmfzDfOO0YoQ6lsAJ6PWl
asLtOAjyC3XpZIdS7vvNfgC0velwuzHSjXVDFfZxQxVmaN2rCiMLYfOtgBqv
jkWvKlOc7C6JHTVdE8JIHi5w5hrE9NLJccRYV1WVgwc3yllVteOs2YXlpfa+
MuNd7lhezpq6jCFdOwmfn7T1xFWLsq4r5ZEr7BxemSXQCXtF3XZNGUALbqRi
kfd60+amFanuuqEKqAKqsKLCabueKrPnk8cj3AESm6oTJmZSD+qyDD24pMhR
bglOAPtp12YXPB/gznjjXWGf704xbNrw4/ykcESSWecZ3aicNRua3L2QM8Oi
e4s3fW46keqvG6qAKqAKiyq8PHmURw/+5S186MXfpDCE8uyygbaIt5gNfd8P
46aZJCcM+boZH0UAL+7lfYs3bW6v8SYzVGEnt9dAFe5PBUahsFNmqpE0nzPq
S7SpqEFJVG3ckodmaIZmaPbfm41FCB3u5I6ysYh82/bmfyswtHW7/sMlNEMz
NEOz/8dsTH3H8cJ6s5JDIBAIBAKBQPzb+AfgjqT3
              "], {{0, 19}, {405, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {405, 19}, 
            PlotRange -> {{0, 405}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2e588593-a5ab-4027-9fcc-6afe215bb239"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2e35b04b-b03c-4a23-8859-798a0f6d6321"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2b2184d2-ef0b-4a3b-ace1-fe3648077df6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"45db9c88-5ca9-4919-9dc0-fbd6503eb2dd"],

Cell[TextData[{
 "Make a line plot of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Mod",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"n", "^", "n"}], ",", "10"}], "]"}]], "InlineCode",
  ExpressionUUID->"c7a68a86-e5ce-4b24-9489-7c1a61013a88"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"404ac87a-c646-4c42-93a1-c942c559fdaf"],
 " from 1 to 100."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"fcbdd8bf-9c06-471c-9488-c6fccecd6da4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aabeb0ea-a165-4816-9d79-a588f9a0ae77"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvVubHdWxJepz+uU8nr9w/kW/9mO/dn/ndbGxcdl0m7LN3rvc3kZ7GxAY
EAZkLgIjb9gCLG4SWGBdkAABkqAEBRSXwhQgQIBAwkIIFVCCguhYOVaGIudt
zZmZUbT4VnzYnyi0aq6cmTPGmDFGxvz/fvjz/zb1f//gBz/4x/+H/++/nfur
/3Lhhef++r//v/wv///0P57/k+kfn/dfp//pxz/58YX/+Yf/iX94lP/30//r
Bz8Y/pniMVVH4u9MYhKTmISOScaYxCQmURqTvDGJSUyiNCZ5YxKTmERpTPLG
JCYxidKY5I1JTGISpTHJG5OYxCRKY5I3JjGJSZTGJG9MYhKTKI1J3pjEJCZR
GpO8MYlJTKI0Jj7zSUxiEqVhlzEen3v3hvvmlr9aMfr9iBcXj95w3/MfHV8y
HeWdI59ef+/c6+8eNx3l5NIyz9jsq0dMR+HgUXY+c8h6lD/vWrhn92vWozy8
782bt75gPcqBlz/gx+zUF6dNR3nlrY+vv2/uvaOfmY5y5ONTfC08VpdfYpc3
bnngxcHFfz31ue1U/3X/WzzKG4c/MR3l4KtHeJSnXnzPdBS+oTzKvXv+ZjrK
1yvf8Ch/uHfOdBSOf77+8V/f9IT1KFfeMXvupdutR7lr1wJP2scnvjAd5ZHZ
t3mUl948ZjrKwtt/51F4rC6/xC5vrL/nOf56n55aNvr9iL88+QaP8rd3bJnA
ky+8x6MwgzId5d0PT/Iomx9ZMB2FMzmPcu3dz5qOwvGLax/91Q17rUe5+E/7
z7n4r9aj3P7Xl3nSrGktHmam0KajzL9xjEfZ+XQnwmmXNxgI+OsdP/ml0e9H
3P/Y33iUVw/93XQUAMGjz75jOsqb75/gUe7a+arpKMdOfM6jXH3XQdNROP7n
ut3/9IfHrUdhSjOwzxu3/mWeR/ng41OmozDV5FHm/vaR6SjPvfYhj8JEvcsv
scsbDASrQO0YnVeB2gEIOlK7sfHaO8d5lE3bXzEd5fBHQ1Zz1R2zpqNwTP1u
14XXPWY9yi+ve5QvhzdfpqNs2PICj2JdeeBbz6McNC5wPf3yBzzKtqfe6PJL
7PIGgMCa2mGqrakdgKAjtRsbnP14lNseftl0lMXDn/Aov/uPZ0xH4Tj30u0/
v2aP9SjnX/kIX451+f0P987xKO98eNJ0FJQEn3nlA9NRnnpxuOl+8InFLr/E
Lm8ACKyp3Z+2vbQK1A7ZqSO1GxvP/+0jHoWvyHQUZKfLbjtgOsq3337Lo/zs
6t2mo1CVnXigL5a/Mh3l938+yKO89f4J01FQEtz/0vumozz63Ls8ypbHX+/y
S+zyBoDAmtrdvHVIIJ9d+NB0FABBR2o3NmYr1eaPD75oOgq0Id5Fmo5y+usV
HuX8qx4xHeWrapShbGeskF6x6ZlVkO1QErSW7XY+c6i7bGeXNwAE1tTuhvvm
VoHaAQg6UruxsW/+fR6Ft9Kmo0Ab+rdb95mOsvTlVzzKT67YZToKtKFVkO0u
/fcDqyDbXbxx/yrIdg/ve7O7bGeUNwQIrKndtZufXQVqByDoSO3GBj8wPMoN
9z1vOgq0oYtuecp0lBOnlnmU8y7bYToKtKFVkO3+9Y/7VkG2Q0nQWrZ7YO9i
d9nOKG8IEFhTu6tWhdoBCKwdWVjR1o4saEP/suFJ01E+PvEFj2LtyII2tAqy
HU/XKsh2KAlay3Yo8neU7YzeTxEgsKZ2l902JJB7nz9sOgqAwNqRBe+rtSPr
nj2v8SjWjix4X60dWdCGVkG2++frH18F2Q4lQWvZDt7XjrKdEd8QILCmdr/d
uG8VqB2AwNqRBSZg7ciCNmTtyIL31dqR9VJlfVwF2e4X1z66CrIdSoLWsh28
rx1lO6O8IUBgTe1+c/OTq0DtAATWjix4X60dWdCGrB1Z8L5aO7KgDa2CbPc/
1+22lu2kJGgt28H72lG2M8obAgTW1G7mhr2rQO0ABNaOLHhfrR1Z0IZ+fs2j
pqPA+2rtyII2tAqy3dTvdlnLdlIStJbt4H3t+BKxUd4QILCmdoyb1tROgMDa
kYUdhLUjC9qQtSML7jJrRxYqyfzPoQ9sZTsAh6lsJyVBa9kO3teOsp1R3hAg
sHZkXXD1bmtqJ0Bg7ciC99XakQVtyNqRBe+rtSMLFSFr2Q7eV2vZTkqC1rId
vK8dZTujvCFAYO3I+ukVu6ypnQCBdX8YeF+tHVnQhqwdWbM14TR1ZEEbspbt
TteE01S2k5KgtWwH72tH2c4obwgQWDuyfnTZDmtqJ0Bg7ci6vvK+WjuyoA2d
d/lO01HgfbV2ZGFnZy3bwftqLdtJSdBatoP3lVlHxt89uXvDTGXTmNm+0MjM
RnlDgMDakXVONcp9jxpSOwECa0cWvK/WjixoQ9aOLHhfrR1Z0Ib4n5ctZTt4
X61lOykJWst28L7myHZLi5unptYfWaGj+zZMTW3WFhmjvCFAYErt0PLOmtoJ
EFg7suB9tXZkocRn7ciSjaqpIwvakLVsB++rtWwnJUFr2Q4b1RzZrsobG3lm
j89vmppejbwhQGBK7b5Y/noVqJ0AQR61ax/wvpo6skQbGhjnDXhfB8aOLGhD
1rIdvK/Wsp1kWmvZDt7XLNluaXEtJ4jp4VZlZksDmqea0dd3EyAwpXYnl5ZX
gdoJEFg7suB9NXVkiTY0MHZkPfjEqMBl6siCNmQt24n31VS2k5KgtWwH7+sl
GbLdwqbp6U3zwz8tLayZmp5ThMOIbwgQmFK7v386IpC3W1I7AQJrRxa8r6aO
LNGGBsaOLHhfB8aOLFDuSrYz7K0n3ldT2U5KgtayHbyvObLd4uaZqY1VTW95
kfPGvH3eYCD40dod1tTuw78vrQK1AxDw5Vg7suB9NXVkQRvCrTF1ZMH7OjB2
ZP3yukdxLaaynXhfTWW7//jrsCT4w7U7rGU7eF+zZLuTiyM5ZWpq/fYFDTNG
eYOB4ILf77GmdsyBV4HaAQj4cnKoXZeA99XUkQVtCLfG1JElhXFTR9b5Vz6C
azGV7cT7airb3fLAi+deup2vyFq2Q2E8X7ZbXlpa8jw4RnmDgeB/3fiENbVj
LFsFagcg4MuxdmTB+2rqyII2hFtz0n8a+gt4XwfGjixeArgWU9lOvK+mst36
e55jyOBNhKlsJ97XX93YSbYzyhucNmEvMaV2r787IpA33m9I7QAE//rHfdaO
LHhfTR1ZsHHi1pg6suB9HVg6sqAN4Voefc6wt554X01luyvvmGXC+fNr9pjK
duJ97SjbGeUNXmi///Oz1tTulbc+Htg7sgAEF2/cb+3IgvfV1JEFbQi3xtSR
Be/rwNKR9VmlDeFaTGU78b6aynZ4wJiom8p24n3tKNtZ5A0AARDHlNq98PrR
gb0jC0Cw9rYDHand2ID31dSRBW0It8bUkQXv68DSkQVtCNdiKtuJ99VUtvv1
TU9c/Kf9TANMZTvxvnaU7SzyBoDgjh2vWFO71XFkAQh+9x9PmzqyxPs6sMwb
0IZwa45YOrKusndkQRvCtXwPHFlgGjM37DWV7cT7ekE32c4ibwAItj7+ujW1
O/DSiEBedachtWMguORP+8E67EYR7+vA0pEFbQi3xtSRBe/rwNKRBW0I1/LQ
U28ajULK+2oq20FJwcNmN4p4XzvKdhZ5A0CA411Mqd0Tzx8e2DuyAARX33XQ
1JEl3teBpSML2hBujakjC97XgaUjC9oQrsVUthPvq6lsd+6l2zkvXXTzk6ay
nXhfO8p2Fv3MAQQ4htKU2u05+A4mwZTaAQh4w96R2qVDvK8DS0cWtCFs2E0d
WfC+DiwdWZA58JiZynbifbWT7VASZHJuLduJ97WjbGfBNwAETFCRQnv//RI7
nh5izT9cst2U2uEqoKrYjQLvK1/LwNKRhauAqvLGe4aOLN6n41rsHFlPvDBk
mzBXmMp28L7y5djJdigJ8lVYy3bwvvK1/HBtpyOxLPIGgODlN4/96LIdptRu
21NDAvnTK3b91ozaCRDccN+cqSML3ldYOOwcWajSQFg0dWTxKLgWO0cWypXw
8Ny9+zWjUaj2vvLl2Ml2KAny82wt28H7ytfSUbazyBsjODv8ydTvdpk6srZU
NbGfX/OoHbUTILhpywumjix4X/laBpaOLMDZ0y9/MDDukcV7OlyLnSML2tD7
xz6zlu3gfZ3+vaEjCyVBzoTWst1cRc9wa7r8Hou8ASBgALU229+ze6gOMCW2
o3YCBLc88GJHapcO4CZebbNzZKFcf7AmhEajUOV9xbXYObKgDZ347Etr2Y45
84/W7hiWx81kOykJWst22Avg1nSR7SzyBoCAH35rs/2dO17lgf71j0/ZUTsB
go1/mTd1ZMH7ytcysHRkQRuae20IOqY9snih4VrsHFnQhk5/tWIt211/3xyn
QVNHlpQErWU7bFFxa053kO0s8gaA4NQXp02pHcdtDw0J5GW3P/3P1z9uNIQA
AcYyGoVq7ytfi6kjCwwQY5n2yJJrsXNkQRvCWKayHaQ0U0eWlAStZTtIabg1
XWQ7i7wBIGAWZErtOP744PDJMaV2AgRyUUYDYe+Asy3sHFnQhuSijEaB9xXX
YufIEoXLWrZjhsZPsqkjC9rQG4c/sZbtUEPAreki21nkDQECa7P9jfc/P/W7
nabUToDgzp2vdqR26YD39Yb7nrdzZIk29Oqhj00dWQxkci12jizBC2vZjmkG
k42Lbn7STraTkqC1bAfvK25NF9nOIm9IzrQ2219393PDEooltRMggIhv58iC
93VjdeavkSNLtCGI+AfMHFnwvuJa7BxZYnWwlu1+u3Hfb25+0tSRJSVBa9kO
3lfcmk8+ay/bWeQNAQJrs/26O2d/ce2jnKb+hxm1EyCQoo3RQPC+otJr5Mg6
9slIG5KijcUoVHtfcS12jix5us6/8pHrLWW731RMw9SRJU+XtWwH7ytuTRfZ
ziJvyAybUjsOiN2m1E6AABNu58iC95VXmZ0jS7QhmI3tHFnwvuJa7BxZDBlo
VWEt24E2X/rvho4sqZ5Zy3agzbg1XWS7xPspK998w/v6FjU6AYJ+qR2v2RcX
j+rzRi/+034eK5PaHfrg01fe+rh0UAGCB/YudqR2TvC16LmF9/Whp97McWQx
oPPHv1j+umhEoRlvH/m0X0cWb6xePXRmbuF9xbWMdWQtf7Xy0pvHONWUDvrT
K3fBHdSvbMdzO//GsaUvz2xIIV4zSOXIdjzJr79bnPalJNivbMeJ6IXXP9Jz
C+8rbk0X2S7BN9Dig9G89HcOgaCSUfqldpCeH58787RzUuLUlEnt+G+ed9mO
b7/9tmhQAQIhHsXfOxSfV22Xrt18BiXhfcW2aKwjC0msNA2KjALisfvg2y2+
eTAYizVKwvuKaxnryEISY+ZcOqjIKP3Kdg/vG66pF14/Y2654Ord12x+NlO2
4yT2j+uL1T0pCfYr231wbPjWPOci+Qm8r7ueebujbJfIG2CbvLkr/Z1iE+2X
2mGnsEP5iP7XjU/wEENqd8n4FA2PHKNJ0aCSlPA49eXIwk6BIUx+Au8rLPpj
HVlgm3sKz8ITbQiPU4+OLBzJsXx6xH/gfcW1jHVkoUh79V1lhEG0Iapkuys2
9Sbb3VrVDJ9++QP5yU+v2HX9fXOZst3U73by01i68CUp9SvbPffah/zbmJDL
T+B95Seno2yXyBsAghYYLUCQSe0yAy0rGWrlJ5zY+YHJpHbTVcP8UowWINhx
4K0eHVm1be9M8QelKiztsY4sXHIpRo+0ofc+ASL05ciSlpUn6i0kvK/PvHIk
x5EFE1opRos2RH3Ldmh0rGktLzRebtfkyXZo9siZuWhQYeb9ynYAO01r4X3t
3kghkTfkuJkijNZA0K8jCy0ddMNSbGwzqR0DwRCjD5ZhtFyCCCstvrkf4E4z
6ghppAJmGoMMRxYjSAuMlkvASzd9ObKkpYPso8WPmuPIwkt2pRgNbQiX0K9s
B+6kaS2yX45sx4wLU8FAXzSoXEK/sh24k6a1MC10b6SQyBvS9bcIozUQ9OjI
Ys5zXtXuW2/WmAnwhiiT2gEISjFagKA7tdMB7sR5T36Cypggdfrj11Rdf0sx
Wko0x08OddIHn+jnSCxp9/3OkU/xE3hfX8prpCBdf98/VpCTRRuiXmU74U5C
a+F9zWykIF1/GeiLxpWSYL+yHbiTprXwvuKWtajfSiTyBoCgFKM1EGRSu5yQ
dlh6s3be5Tv5X2tqlxIXBAhKMVqAoN8eWeBOTIHkJ/C+ZjqyGEFaYLRgGR7v
vhxZ0g7rtVo+hveV/5WvaKwjCxvAUozWFhReF2t6ku2EOwmthfeV/zVHtpOD
Rxnoi8aVkmC/sh24k6a18L52b6SQyBsCBEUYrYGgR0eWHJVyjdqs/cMl2/kG
5VA7AYJSjBYgkOJAu++vQ7iT1iDgfc10ZPFKaYHRsqHTnLB7yFEpokHA+/rm
eydyHFlYKaUYrV+x6VG2E+4ktBbeV86NObIdSoKD6jSoonFlQ9ejbCfcSdNa
JmaMWbOdGykk8oYAQRFG6ye/R0eWtBKVzdo33wxPrLv9ry/nUDsBglKMFpNA
d2onoVuJigYB72umIwvaUClGy5OPJ6ovR5a0EhUNAjfr3Q9P5jiy5ATqIozW
T36Psp1wJ6G1uFm8p8uR7V57++/4OF94/qC6JNijbMd5G19G01p4X6GzdGmk
kMgbAIJ/+sPjRRitgaBHsz3kBv4yslnD1uOuna/mUDsAAX+8FKMFCHrskQXu
hC8jGgS0p0xHFiMIPl6E0aINjaZuVw9HYoE74cuIBiHaU44jCwVhfsaKMFrT
vx5lO+ZOP758588qwwZ+ItpTjmyHkiBmQzvH0qHpX4+yHZCOv4ymtdCe8D2f
79BIIZE3AAQ33Pd8EUZrIOjRbM9wfMHVu7E7w09OVbN9756/gdqlRR/UDfAa
YD5GayDoTu0kAMf4MqJBwPua6chiBOEkgG1a/riiDenr6hiAY1wLP/P4Ibyv
x058Lru8RABcfv/nZ4swWjuXhtdVbrUKBsPxmlueqt7jHtFaeF95350j2wFc
MBsM95mD6pJgj7IduBO+jNBaeF+7N1JI+MyRYEGc8jFaA0GmIysnGI8uu/1p
Bi/ZrH1SNYhjspFD7ZBg8RLxQ9kYrYGgO7WTAHfC13671iDgfc10ZJ1TKYMM
skUYLXWA0Ravjx5Z4E6YWNEg4H1lKpXjyELxnMlPEUbrOkBfsh240433P497
gR/C+8pUCnctLduhJIjZYLjPHPddVRLsUbYDd7r/sdc1rYX3NVO2S0SCbwAI
0Gc+H6M1EPRltuckz/mHVwonT9msHUWW3vdmDrUDELz05rEijNZA0J3aSYA7
7a9FB/wQ3tccR5Zs0EoxWvscBj31yAJ3QkMP0SDurryvnARyHFl4OZG3ZkUY
rYvhfcl24E5bH39d01p4XzkJ5Mh2eBQxGwz3mePqkmCPsh24E5KY0Fp4X7s3
UkjkDdwOHAyXj9EaCPoy26Nn9fYDb/GjLps1/HDnM4dyqJ3cjiKM1kDQY48s
cCd0lhYNAt5XnaliISpqKUbrXcO5l26/9cEyrTAYQGEUWkWDEGjOcWTh5ceF
qqKYj9H60epLtgMK82rStBY/5F1qjmyHUtvxk18y0F+f/WKXfrT6ku3AnW66
/3kkZKG18L52b6SQyBsAAr41RRitpzeH2uUE9giM9XdVFi9s1qSECGr3bpLa
CScpwmg9vd2pHUK406uHhitFNAiUEHMcWcJJHivEaNGGqL8eWUPuVC0xeGnw
Q/BMfnR/k+HIAifBrjMfo3Xp7IbKO932Cs4EuNOhDz6FlwY/FO9rjmwnLnEG
+vwXu3TprC/ZTriTQ2vBM7s3UkjkDXkLvgijNRDkULuceKgqBXz491OyceYf
vlEt6idfeC+H2gkQFGG0BgJIbN17ZAl3ko0zfg7va44jSxJmKUZr13eOIysn
wJ2o3jjjh/JWeI4jSzSXIozWfTj7ku0Ac/y4alor3tetGbIdEuY3337LQJ//
YpfmGH3JdsKdNK0V72v3RgqJvCGb0yKM1kDQl9me2Q5zHr5qvVkTvM6hdgIE
RRitgaCvHlnCnbABFA0CeJ3jyMLmlHEEGJ1p33I0lF56ZAl3olEv2ZEGUeH1
kADkOLIkgxVhtH71qS/ZTriTprWC1zmynWSwrRXAZb7YpUuCfcl2wp00rRXv
a/dGCom8IUBQhNF6s9mX2Z7ZDgR6vVnDK2C8DHOonQBBEUbrjNRXjyzhTkx+
BkqD4AXI6THHkaVPMcjHaCcjMRBcd/dz3S7lDHeiWg/Cz+F9pTxH1jl1hbYI
o3VG6ku2E+6kaa14X3NkO6nQwmmf+WKXLgn2JdsJd9K0VryvI9numfaNFBJ5
Q4CgCKM1EORQu5zgh5A5D6nkT/UMz79xDNSOE0LiNwgQFGG0BoK+emQJd5Lk
T8r7muPI0lQ2H6OdimsvPbKEO1H94gN+Du8r/+HycUfbiDZEhRitK669yHbM
xzj5/HtV2tW0VryvObIdXy9OaWSgH2S/2KVpeV+ynXAnTWvF+5rdSGFlftt6
+DQ27WsgZiJvCBAUYbQGghxqNzYAwVhKerMmyyeH2mmpLh+jNRC821OPrIo7
DdcXk59BrUHI8slxZOl6Tj5GO98/x5E1NoQ70XAze0aDEAPnWEeWrucUYbT+
/r3Idpo7aVor6SKnR5aUBBnoB9kvdunv35dsJ9xJ01pJFzmyHcfS4papqbWL
y7R8iP+w5pDSN2J5QwPBiRKM1kDQi9keNvvHKqDXmzU5vTqH2gkQEDA67zUo
DQTdqR1CuBMpDUK8rzmOLA18+Rjt1Gd66ZEF7rTyzfCB1xoEvK+U4cjSwFeE
0T+9cpfUZ3qR7XipCtBrWive1xzZTvtVGO7X5WVmXZ/pRbYbcqeLR9xJ01rx
vmY2UljYNLNu++KRQwvzC4uHj57U8xvLG05hnx+JTIzWQNCL2R7lC2xD9GYN
oPDOkU9zqJ3ukJyP0RoIeumRtfTFGe5ESoPQoDAY58jaWmtD/OcDFenKwWgH
yIZP+O1Ppz8yNoQ7UdW4UjQIqXWMdWTp3R8w+o4dWe53rQ31Ittp7qRprdQ6
cmQ7vfvj6c18sUuXBHuR7TR30rRWlg9W99ZxjRQWt8xwfli/afOGNUw3tugC
YixvOMskH6M1EHRvf8qBnu0nqiKJ3qwx9A8qA3wOtdNAkI/RGggyqV06NHei
CvQvrxaveF8pw5GlW8nlY7Szm+ulR5bmTlqDgPeVMhxZWCb762WSidHObg60
kHNyl2vR3EnTWvG+5sh2Wt1muOdEyl917NC6JNiLbKe5EylaK97XzEYKC5un
pzbgUTy6fmpmTu0bppohP3fKgIzRP/IwmoHPf5NiaBKrH3upKflfiZMJf22H
ivBTzQ+DPumAg7OQEGDg8tYKlwEQvOJyqJ0GgiBGH3z1CD/5Tl9H/dhLTcn/
5fyw8bXMvdYgPEwF79z5qjMKPw9DAlyXcAWXxftKGY4s0YYogtEMmjyNTh0b
uoA89glHFm8AfXswz/mO5r0Gd/pzzZ20BgHvK9XdLBPX8sLrQ2SXfqqM0X49
hO/LE00ZC7qAPPYJ2Y6vl/+aU5nne81M0lnRnEWFO2lay3M73AR9vTJWtvu2
Qnbhitsrsu2AJl/In72i9/A8uBqUE7IdTzhfiz5vgqrtM2/T3nq/ca9xzAG4
E4e83ive18xGCod3r51as22YLU7OTU9NzzfzRvAjDl8CN9YYzbPET7huJcRx
ugICeYwT1A5FML4E/UMgqVPh/JcNT4rApzdr8vp8DrXTQICU6FQ4OTv5pRh+
+OUxTlA7LF5nscNl4VQ4R9ypToyiQegsPdaR5dicOCU6FU5kJ2eZCz3DvyYc
Wfyt/MU+9btdzormJTlQvjWtQUiWHuvIcmxOt3kYjeykO2RSk55RUrbDt3IW
+4aqO6uzohkgxLemaa14X8fKdrokSHVKdGgwZ6eBejsVIfSMkrIdvtU9zcWO
b+XQYN7BCXciRWtFwc9upHBy+/ppMIoNexuPUyxvaJOAfD29oj8+McTfn1+z
R3/KAYIEtQP8OTiCe6RXNLKTGJj1Zu3ePcM1eOrz02OpHf+ScxQQYJk7K5qz
00B1yERoIEhQO1y1Y4fABDorWnMnUhrEG+oS9EYvGE7R4HIPo5GddON3qg8G
lcx/8cb9sY0nXzU/dc4Pz6m6k+kV7XAnrUFI17uxjiwHWXZ4GI3spDtkcjCD
1buzhGyH/zT/RgOJrq26s+oVjewk7+VpWive17GynVMSxE7fWdGcnTRwIH5x
7aOyO0vIdrjq2//aqJljAp2NLWcnDehCa8X7+lUT39OxvLS07G22YnnDAQIf
o3kCB8NWQg1gcoAgQe2whXHkCbTp1isa2WmrWgKyWZMNNajdE3FHlgME5GE0
stNA2fgRGggS1A5bGEeewAQ67dw1dyKlQegN9VhHlmOK8DEa3Ek3fqf6fBYp
AiQcWejfdVr9QunOqle0w51GGkSVRuQe3TrOkeVUzpFs9YpGdnJoLfbpghQP
1ztW//djC+PQWnRn1Sva4U6a1or3daxs55QEGe6ddu7ITj6txTuq+HNCtsNz
7tBaHA/qlKo0dyJFa0Un6t5IIZY3HCD48rSL0ZxDBs0OmeQBQYLa4XqdcgGA
QK9oZCd9CI5oEJx4+T/xDIx1ZPkvfQwxWq1oZKdB85QuagLBl3Fqx48B/yeG
af1DTKBe0Q53olqD4J+L95UyHFnO6Zk+RoM76cbvVE+XmBwSjiw0IdTlAunO
qle0w520BgHvK2U4spwtho/RyE4OrZ1vVsITsh12vg6moDurXtEOd9K0Vryv
2HckZDv/OeSZ1Csa2cmntbokmJDtsPN1MAW7dV18drgTKVor3lfq3Eghljf8
e+FgNA6aHDQ3aw4QJKgdZHFnswYg0Csa2eltNc+yWRMsG+vI8u+Fg9HITk6C
oiYQJKgdZHEmJ/qHSIx6RfvcSSiTeF8pw5HlNLVwMFq404YtDWDCQV3yrwlH
Fs+/A9/SnVWvaIc7CWVinBU6PdaR5Rwz5GM0uJNDa/FcSc05IdvhKXXgG4lR
r2iHO5GiTOJ9HSvb+XU2Bji9opGdHFrrlAQTst1L1VPq0FrpzipM0uFOpGit
1ik6NlKI5Q2/1uRgND/bg+YpXeQBQYLaofzubNYABHpF475/qVKTbNak5jbW
keUDgYPRyE7ObFMTCBLUDuV3PF0S0qZbZsPnTqJB6F2hiBGxcAiJg9HCnfQp
XaRwE3H1XQedLyzBjG7QVMHeqdt0y4r2uZNoEHpXONaRpbUhhIPR4E4OrdW4
SXWPrKBsh+NQHVqLk/v0ina4EylaK97XsbKdUxKkelHLikZ2cmitUxJMyHbo
oOXQWkzgQFURR9xJpSahtZoMdGykEMsb/nlzDkYDlQaqlRB5QJCgdthuO99c
2nTLiubspLu4k9qsyZvUWDjbD0QdWT4QOBgt3ElrEKc9ghGjdmBZjgYhQCAr
Gv2FNHcSDUK8r5ThyHIEFwejhTs5GoTWhijpyOILGTSrUnJyn6xoZCddehUN
Qryv/MM/7xrjyPIFF43Rwp0cWutoQ/WeukH+EfyA+bSW2Qt+p7yp7XAnqnpH
gNaK93WsbOe/Ao8vJiv6D/fO+bTWKQkmZDssLofWoiQ4UCTf505Ca0Hy8d5E
x0YKsbzhA4HG6NOVkZUf10Fzs+YAQYLaAYmczRqnCPxO+QhnJ+f5l82a/GGs
I8sxCZCH0ZydMK5eCA4QUJN+6AASORoEJlCvaJ87iQYh3lca58hyTAIIjdHI
TjyusxC0NkRJRxaWqtYgkGb5d0rLC587iQahva9jHVl++kK+xYpGdsKt0QvB
0YYSsh3OdnForTy6+IjPnUjRWvmDswf3w3cdINXIRzg7YVxNa52SYEK2g8rg
sERmlfid8pE/DLlTA8KE1mqPzVjZLh2xvOEDgcZo7OjX3PKUw4gcIEhQOywr
h5Dz9eJ3YkXDZu/U92Szxp+FjzdB7RA+EDgYzdkJ4+pqkgMEFKd2ciCm1iCG
E1j5W2RF+9zpQK1B6HlL98jytSGqVp+saGQnftodDUJrQ5TskYUDMbUGgQnE
FGFF+9xJNAjMGw5oGNtIwS/PaoxGdsK4mtY62lBCtkOlXd81TCB+J1a0z51I
0dpf3bgX8zZWtvNLgiAPWNHIThhX01onHSVkO8yMc9fQlI9XhHRy87mT0Frx
vlLnRgqxvOEDgcZoGFmxedSbNQcIEtSO1+zA26ydU+2gZUUjO+1obkBks8Z3
E5xtrNk+aD+TFY3shGvROcoBAopTO8jizgLhJxY+PVnRPncSDeIhpST+6x+f
SvTICjYE0xiN7HT1XQedHKW1IarS2o9Djiy0hHIWCCYQU4QV7XMn0SC093Vs
IwW+2IuaF4s9EdYRshPG1bQW2pD4mhKy3VV3zDq0FhOI34kV7XMnUmxWyk1j
ZbvgxTIUYkUjO2FcnaOckmBCtsNsOLQW4hr/P15CD3InobWjclOFblWVbMyR
WImInYPgA4HGaBhZ8X30hDtAkKB2vAAHzc2aIKmsaGQnRxuVzZo4Hsea7YM6
nazoUXZ6+tB5zQkXM7/8JEbtQBsGTQ0CQCArOsidRIPQR0clHFkU0ek0RiM7
VY3fG8CktSGKO7Jgihs068zQhnC7cTd97kS1BqHX19hGCn7Dc43RyE6PVmVP
TWsdbcipqungX+7QWplAWdFYj442KrRWqtBjZbu6mNPYlMmKRnbCHGpa63z5
hGwH2uDQWkwgTzteAwlyJ6G14n2lzo0UYnzDBwJSGA1WAJej3qw5QJCgdgwB
g+ZmTZBUVjTKOJqgktqs/fqmJy6uvsxYs30QCGRFS3ZieqA1iHmvOBOjdqjq
DJolfQCBrGjJTvqDokGI95XG9cgKop5g9Ok6O+m3UxFOc+mYIwtVnUFz34e0
hnfosKJ97kS1BqG9rwlHFiJoVpEVzWyB/4LT+J08bSgh2zGhdWgttCHORbKi
fe5EitaK91XzqGD4JUGqeB1WNLIT7riGD6ckmJDtQOYdWgtuiRvESSPInWQC
xftKGbJdOmJ5I3jyxbX1ioaR9QOU0NVacIAgQe34YgfNzZoAgaxoZCfJQgjZ
rElDywS1QwSBQFa0ZCfdIZNCKBajdnJ2rd5iYwJlRQe5k2gQ+mXSdI+s4NZP
MFqyk/6FFNKGYo4sObtWaxAirmFFnw5xJ6o1CO19HdtIIbj1kxWN7OQ0fidV
2kIkZDt4XzWtle6ssqKRnZwPygSKkWOsbBd8GUdWtGQnh9Y6JUGKy3Zydq3O
w3xHmFvKayBB7iQTKN5X6txIIZY3gkAgK5qzB+cQp0MmeUCQoHaweOnNmgDB
aEUf/sSx2SNks8ZcBQdejzXbB4FAVrRkJ90hkzwgoDi1E4uX1iAwgbKig9wJ
TQuZDjG+DCrvK3mCqRO+NoTAipbspCvnFNKG4MhycjLV3tdBU4OQCcSKDnIn
qqUH7X1NN1Jw3huSwIo+/dUoO731fqPxO3naUEK2g7Kvaa24LGRFB7mTTKB4
X8fKdkFpW1a0ZCeH1jolQYrLdqLsa1qLCcTa4aQR5E5Ca/XyZLpedNifE7G8
EQQCrGjMPF+FtvEjHCBIULuLqxcDB2qzJkAgKxrZyfmgbNZk1yDNOWPXGAQC
WdGSnXSHTAoBQYzaIScMmhoEgIDqFR3kTphApkN615BwZFG8Tz5WtGQn55Qu
XxuKObKQEwZNDUImcLii1+4AE3O4E9UTqL2viUYKJERxp9tMDysajxlnJ5/W
OtqQvB7uDwGXkaa1MoH4A7OUIHfCBMJSiEdrrGwXJIqyoiU7ObT27t2uVB2T
7cRlJLRWSoLyGkiQOwmtFe8rjZPtxkYwb8SAACsa6MM5RNv4EfxNNBAkqB0E
qYHarAkQYEVjFOflLDqzWftIZ7YYtUPEPE5Y0ZKdHA3CB4J/vj5M7YBNg2Yl
RyYQKzrInWQCdWZL98iKtSbAisYGlrMTaonCV31tKObIAjYNmhoEtCGqVzRu
jcOdqNYgdGZLOLIoog1RvbQxCj8VPq11tKGEbAfvq6a1MoFY0RjF506gtXjg
sQVGt8yEbBcsCWJFo1qCleLQWqckSHHZDlqMprV6AoevgVT9f3zuJLRWZ7a0
bDc2gnkjVjHA9/z5NXsGdX3b2aw5QJCgdvw3B83Nmn7eeEVjFMf4TWqzpg0Y
MWqHiFUM+PZhFGQnR4PwgSBG7aAiaWalXRZY0edfGeBOVGsQ+hShdI+sWMUA
K5ovx3nzEf/V14bu8a5O/81BU4OANkT1PeJRfO5EtQahva/pHlmxd7iwonFr
eN/k01pHG0rIdvC+alqLCWQOg4cco/jcCbQW+z54X8fKdkNYCR2GyysaoyA7
ObTWKQlSXLaD91UzKz2BfI8u+P2eIHcSWiveV/L2eqURzBuJU8PEo4u9s7NZ
c4AgQe2Y8w+amzWNpHhRZeC92E41IAIOZIrSZvtYat1Qe3SRnRwNwgeCGLUD
59dXqidQXlTxuRPVGgQjtbzyme6RFXNEYEUP6tdSHA0CNQddAYg5ssD5B00N
Qt7AlRdVfO5E9QTuUVQn3SMrVjb/sn5tH9nJp7WONpSQ7cSmLlf6gOrOiuU8
CLXOxgTiMQPVGSvbxV5kRilPbodDa52SIMVlO3hf9ZW+XZcESb2o4nMnmUBN
dcT+1C6CeSPxMi9WtOCys1lzgCBB7fBukX6oBAhIrWinwwnVmzUYA6TPPMPc
TXGzfexUdFnRyE6OBuEDQSz/yC0TDUJPoKxonztRrUHoulDMkYWI7S9kRSM7
ORqErw3F8o94X/VDJRMoKzrInTCBuDWoCx1I9shK7C+woiU76cNnT3/llsGx
fB4LyXbwvmpaq1+8wooOcidMIK4F3texsl1sfyGPB7KTQ2udkiDFZTt4XzWt
lZIgqeK8z52onkDxvlLG0TbpCOaNhH6K92gkazmbNQcIEtSOaTn/5YGS3TUQ
4M+OcwmBzRogXtZp2mwfAwJZ0chOjgbhA0GM2qEt20DVZjUQyIr2uRONJvAp
nfzTPbL+PaQNkVrRyE6OBuFrQzFHFryvfDm6NqsnEAk/yJ0wgbg1WKcJRxYl
9VOsaMlOmtb62lBMtoP3FbdGaK0W1/DnIHcCrcW1YJ36WraO4HtDCKxoyU4O
rXVKghSX7a66YxbXIrRWv4ErCT947AhorS7sp2W7sRHMGwkgwIqW3g56s+YD
QYLacQL8WVWzks2aBgKsaMdmj8BmDYREdlJps30MCLCiJTs5GoQPBDFqx7/8
J1fsYnIieyUNBLKife5E9QTqbp/pHlmJjp267uRoEL42FHNkYV/Pt0bvlXgC
oQ1RvaKD3AkTiFsDJpPukZU4Q9mpimta62tDMdkOjwoeM6G1egKxooPcCbQW
1wIATct2CTaCFS3LxKG1TkmQ4rIdPyq4FllQegIhoAe5E9W0Vuf/tGw3NoI+
8wQQ4KtKcVuf0uUDQWIyeWn8+qZhaVQ2axoIsKKdzjMIbNbw3sG2p0aJN2G2
j2lD8vUkOzkahA8EMWoHZqJzl9OKgVd0kDtRPYHifaWaUQT/MiXVFqxodIN3
NAhfG8KuUFpeS4CZ8PfRGoSeQNymIHdCNQC3Bt7XdI+sRNtqrGjJTprW+tpQ
TLbDA4nHTHLXNbU2RPVtCnIn0Fpci1RcY4yCkiVBrGjJTg6tdUqCFJftmO7i
WiR36QnEayC/CnEnquRLprXifcU8XOAptvkR5BsH4kDA94L/q3CharM2yt4+
EMSoHVI3L0MNExoI+IM8yjsR3Z//mvNeoT/5EultKbMdWQKOBuEDQYzaQRa/
UMGEg6QvvXEsuOukWoPQeBpzZCES29I3Dn8iBQ1Hg/C1oZgjC44L3Bq4O5w3
cPkjfGscZxECXAW3Bnjqe/V1JNyknOJ4FCm/aFrra0PHvAdPfolci9Ba0Yao
aqnHowS/ACYQ1yKzmpDtEiVBftp5FDmqwKG1TkmQQg8e4jc3P3nxxv2a1uqS
IFXszjklQQITyAtHsHjs0TbpCOaNnKOpEHqz5gNBjNrhUUR9WDZrGgjSwYDL
61SPlTDbJ4DACUeD8HORts3oqFpC7WVyImpL6QQyIYH3lcb1yMqU3R0NwteG
Yo4sAD1uDTSI/AlEQyrcGnhfE44sKjl2XNNaXxuKyXZYy7gWobVOd9ZYYAJx
LfC+cug160T+seOgtdKCwCkJUly2gzNc01pdEkwHJlC8r5RxtE06gnkj/3xG
vVnzgYAi1A4toWCuls2aBoJ0MOBCX5OHIUbtqOR8RkeD8IEgRu14i8FJQ1c/
HCBIBCaQL0cehnSPrJhJwA+tQfja0GPPhR1ZcJzi1qD6UTqBfC2yx0n3yBrb
DUxC09pnXnFrrTHZDt5XXIvQ2pi45gdPoNPCKCHb5Z/PqGmtXxKkODT88rph
vVRDpN+ULxY3VuemaRDnC0nIdmMjmDfygUBv1nwgoAi1w+bx/scaLUYzgYCU
11RuU8Jsnw8E+pQuCgFBjNrx1/63W/dpNpIPBOI1lcptzJGFGNvtXEJO6aKQ
NgRHlnOmm3wf/D/YiNaG0iFeU9lvpntkxbQhPzSt9bWhmGyH74NrETaSP4Hw
mur9ZkK2G9vtXELTWr8kSHHZjr/PtXc/q2lt8MWrYIjXVDbstzzw4o+SR9uk
I5g38oFAb9aColuQ2qESwp/V/zUfCNBUQeeoIbXbGDbb5wPBB+qULgCB+EMQ
MWrHNGPtbQf0f80HAmmqIN7XdI+s/LaQumbia0MxRxayFl6rxH/V2lA6oEHw
P+J9xXm4sR5ZY09zk9C01teGINvd48l2yFq4FqG1WhtKB9NaXA68r5SU7RIl
QSc0rfVLghSX7fjpuuG+Of1fCyZw1+idOHhfKeNom3QE80Y+EOjNmg8EFKF2
EM52PfO2vhH5QMB/bdC0uCR2/flAoDWIIBDEqB0vySvvmMXBxPhJPhBAg9C1
iATZS5gE/NAaxFAburkBYTFHFqorqOtCg/DbdMcCNHKgjjtJOLIo47R6CU1r
fW0oVvpGdQVXKrQ2Jq75IbRWJLYL4rJdfkVL01q/JEjx0jfeP9K0Nr8kKLRW
JLa0bDc2gnkjP4/pzZoPBBShdu/Uj5PerOUDAXqFaW6TMNvnA4HWIIJAEKN2
UIFHBxBX9cz8CZReYcJtEj2yxloWdWgNwi/RxxxZyHho/4J6ZsJl4YT0ChNu
k+6RlW9Z1LRWN8lExGQ7ZDwGDqG1we6ssRBaK490QrbLLwlqWhssCcZkO/6b
vNg1rc0vCQqtfbh+pNOy3dgI5o18INCbNR8IKELtpCWU3qzlA4Fs1oRmJ8z2
+UCgNYggEMSoHdNyzo3oP4/9Rf4EQoPQNPuheI8sFABzpA1qahD+A6/fdtfB
26Ufrt2h9xelEzhQHvV0j6z8VzI1rfW1oZhsd7A+9ksewnxtiBStlXuRkO3y
S4Ka1upeJRJB2Q7eV86NmtbmlwSF1sq90L1GW0Qwb+QDgd6s+UBAEWqHTz3z
ygey3ouAQDZr8jBXXzjseMkHAlIaRBAIYtSOP8Vwptd7PhBgKvTDHHNkUYm0
QU0NwteGYts3eF/1ei+dwEFle6i/8BBbYz2y8rUhTWt9bYhqLHZ+CC73t3eO
y3ovmkChtZINErJdfklQ01pfG6KIbCef0rQ2vyQotFYEgvwvHIxg3sgHAr1Z
g+DlMJ8gtYMdaO61jyS1FgGBbNbEtpQw2+cDASkNIggEPtIhmIRs/Mu8dkTk
A4FoEOJ9TfTIyteGqKlB+NpQzJHFuMyToB0R+doQ1RqEeF9jjixEfkVL01pf
G6KIbIeC21vvnxBHROkEDprHM8UcWVRSEtS0NlgSDMp2KLjd/9jrmtbmT6DQ
WtG20rLd2AjmjURedUJv1oJAEKR2IMkvvXFMNmtFQCCbNbGtxhxZVJhXRYMI
AkGQ2oEk825RKxT5QCAahHhfEz2y8rUhUhpEUBuKObIwk/rFonxtiGoNQnSc
dI+sfG1I01pfG6KIbDeayY9OCq3N14ZI0Vp5lyQh2+VXtEjR2mBJMCjbYSb/
8uQbmtaWTuBA2ZPGHm2TjuD7Kfl5TG/WgkAQTEFy4IVs1oqAQDZrUktJmO3z
gYCUBhEEgmAKwg6L/5N+hyt/AkWD2FMbJGKOLCrRhkhpEEFtaJSCmo2vqfa+
6rOh87UhqjUI8b4mGikUaUOa1vraEEVkO3hfea8ksJKvDZGitfC+UpKH51e0
SNHaYEkwKNvJOzgCK4kXr/wQWisUGjz8RB4P9yPIN/LzmN6sBYEgSO1GLaHe
+0Q81XiMM4FANmuSLZna+SkLUQQEokEEgSBI7U7VpiON4CUTONIgxOQQc2TR
uHYWTogGEdSGYo4seF9JIXjpBA5Uj8FgykIUaUNHFK3VTSQkhrLdfa5sB+8r
r0pB8HxtiOoJ1O/3JWS7onYWQmuDJcGgbAfv6+6DbwutLSoJCq2VSvjYo23S
4eeNIiDQm7UgEASp3eg41A9PymatCAhksybQnzDbFwGBaBBBINBbSwkQhgef
WBQNoggIRIOQ3UeiR1a+tEGq8XtQG4o5suB9JSWElU7gQHlfY44symjXqUPT
2mDFLCjbgTB8empZaG2LCdQ5MyHbFbXrFFobLAkGZTsQhr3PHxZaW1QSFFor
OTMh2+WEnzeKgIDUZi0IBMH5BJp/8PEp+fJFQCCbta9XRhOeMNsXAYGc0hUE
giC1E++raBBFQEC1BiElygSpKJI2RIMIakMxRxa8r6QKUzyBmdoQ1RqEeF8T
z1JRRUvTWl8boohsh5v4+ZdfCa0tmkDQ2vNViTIh2+WXBEnR2mBJMCjbyU2U
M5cLJ3BEa8X7mpDtcsLPG0VAQHUrIYoAQZDaIV0c++Rz2awVAYFs1uQnCbN9
ERDIKV1BIAhSO/G+Sg2wCAio1iDE+5rokVWkDYkGEdSG4MhySAjV3ldSb2Xm
a0NUaxDifU30yCqqaGla62tDFHn2kC6++npFiOLWEm0ItFa8r5SU7fIrWqRo
bbAkGJTtZBcsRLHFBA6U9xWynbMTzw8/bxTlMao2a5dXmTYIBEFq90AN3MLJ
i4AAm7UfXXYmUWgzjBNFQCAaRBAIgtROvK+iQZROIDQISRQxRxYVakOiQQS1
oZgjSzogyXGT+doQ1RqEaDe6vupEkTZENa0NakMUke3kOFS5cUXa0EL1DXXJ
LiHb5Ve0SNHaYEkwKNuJ91VuXFFJkGpa+8Gx0RJLH20zNvy8UZTHSG3W9Nv9
EkFqh+NQl774SjZrRUCAzZouaCTM9kVAIBpEEAi2h6ideF9Ha+Thl0snEBqE
FDQSokmRNiQaRFAbijmy4H0ltUaKJnBrNYFS0ECtzHdkUaE2RDWtjRVag+gg
nVpljRRpQ5hAjXqcUYOyXVFJkBStDZYEg+gg3lehtUUlQappraBeQrZzY3lh
zdSa+WbXUj9vlAIBNmsxIAhSuxGsf7Uim7UiIMBmTRfrYo4sKgQC0SCCQBCk
drX3dSijQIMoBYLLqoZUskdL9MgqkjZEgwhqQzFHFryvpErNLSZQb3JjPbKK
tCGqaW1QG6KIbAfvK6lSc4sJ1JvcmGxXWhIUWhssCQZlO/G+Cq0tKglSTWtl
k5uQ7ZqxvH0tJ4mZhXF5oxQIsFmLAUGQ2mGZf/PNt7JZKwICbNYuvO7Muo6Z
7UuBQDSIIBAEqR2qB3OvDacLVf1SIIAGIQbRRI+sImkDGgQTuaA2JD4i51O8
zDdWpBFV/SJtiOoJFO8rxXtk1XiXVdGimtYGtSGKyHbwvpJqj1w0gaC14n2l
uGxXWhIUWhssywRlO/G+Cq0tKglSTWvF+5o+2kbiEGeNNRvWzawdyzdKgQCb
tRgQBKkdP5PnXjosR8hmrQgIqIJF3YIV1M5velkKBPvrw2eDQBCkduJ9pXqX
XQoE0CDE+xpzZFGhNiQaRFAbCj7q4n2lOhUDDvK1IcCiPvrnx5eHe2QVVbSo
prVBbYiq6jf/4/xQMEtobZE2BFqrjweKyXbY9OVXtITWBkuCQdlOvK9Up+Li
CaxorXhfc5b58uHtU1Prj9LKtpk1801jqZ83SoEAm7V3IkAQpHZytJBs1oqA
gKrNmuYDMbN9KRCIBhEEgmChAFnitWr+oUGUAgE0COEDiR5ZRdqQaBBBbSjI
D8X7SjXqQXbJ14agQexRzcGCjiwq1IaoprVBbYgish28r6TMKkXaECZQvK8U
kU2pvCQotDZYEgzKdlo2Ba0tKglSTWvF+5o+2gaxmbPD2k27d29ZMzW9fvPu
oyp1TDWD6upffh7DZg27ch8IgtRO3tyRzVoREHAw2dB8IEjtqBwIRIMIAkGQ
2on3lWoNohQIeJ0y+/rs8xGBTPTIKtKGqNYggk8759iB58g6pRruQYPAbc2f
QMYv3unopBfrkVX6PiZobVAboohsJ95XobVF2hDHT65odI+JyXalJUHQWsyt
XxIMynbifaWa1haVBAnnFCsJEkffBmU7icMLc7Ozs3Oze9dNT2/aPX9SlQF8
voGSeL5xHZs1YLEPBEFqVx2HOiSQslkrAgI/YmZ73lMMIocEBUM0iCAQBKmd
eF+pJsalSBr8zsEeWReolqE5gb8f1Ia+VNRCQryvVBNj3NZ8JA18h0iPLLCs
b/MqWlTTWnA5v5oXlO3E+yq0tkgb8iMm2z3f7IQ/NkBrMbf3P+aWBIOyHVYZ
kBG0tqgk6AfKmPz/GX93ecvM2rH7lLsitYJYYLMGcuUDQRDsOFsKu8BmrRQI
nIiZ7SHBPx2qFQQjePisRJDaifeVanJVCgROxBxZhFpB6CyqWECDCGpDQUeW
eF+pJleYinwk9SPWI0s8DJnhHz6rI/ZuFLyvQmuLtCE/YrLdgebJO2NDHz7r
lwSDsp14X6mmtaUlQSfSR9uMDT9vlAIBABdT6gNBkNrxhf/6phGrBI/tCAQx
s30pEECDwLX4QBCkduJ9pVqDKHJZ+BFzZH3rHcs+NqBBBLWhoCMLQz8y+zbV
9V5MRb425EesRxaTkOmS88IAuPg+PkAEZTvxvuJib3v45SJtyI9RzxxPthtx
ziMZXogqQGtxLT5ABGU78b5SfbGlJUEn0kfbjA0/b9xYeLACNmu89oNAEKR2
/DBL9RvPVUcgCFI7KgcCaBDr73kuCARBaveA2iLh5vLHuwBBzJGF8n7wUMJY
QIMIakNBR5Z+aQXPFaYiXxvyI1aT4R8GD3SOBWgtvo+jDVFEttOnfzKtxWfz
tSE/YrJd/fgFDnQOBmgtloxfEgzKduJ9pZrWdjxQPiHb5YSfN2KmuFhgs/bb
jfuCQBCkdkw2LqllcYZC3oR2BIKY2b4UCFBCx7X4QBCkduJ9pboXCn+8CxDE
FG0UH6QfdU5Ag/j5NeGdgv+ih3hfqS7PYirytSE/Yj2y1qh26zmBW4nv4+8U
grKdeF+porX4bL425EdMttvaPPJ1bIDW4vv4JcGgbCfeV6ppLSNvl5JgTNHO
DD9vXBZ/6S8Y2KzhRDwfCILUruo/MOKu/FDhs12AQKvbOkqBgCoNAt/Hn9Ig
tRPvK9V7Fv54FyCIObKONI+YzwnUEILaEIUcWdr7ij0LpiJfG/Jj2Ho61COL
p0hbI8YGqCN/n6ASOoTgK13ZTryvVNFaXEu+NuRHTLZDSXA5uyQIWovv45cE
g7KdeF+pprX88S4lwfTRNmPDzxs4ujr/N2Czdu6l24NAEKR2fMkiizMU4rNd
gCBmti8FAqo0CHwfHwgWQtRu5H2tCCTSF3+8CxDEPCfOcXI5AQ0iqA1RyJGl
va9IX5iK1toQRRxZhNPHSrQh0Fr+PkGnd1C2Q99X/JlpLa6lizYUkxrlfZPM
3wNai+/jlwSDsp14X6lOX/zxLiXBhGyXE37eYCC4vMQkIK2EgkAQpHZ865lY
4s849rcjEASpHZUDAalTunwgCFI78b5SjRT8TxcgiDn2S7UhqrnQIKQNUciR
pb2v0CAGo/5ILbUhivfIKtWGpOmKr5tQSLZDLRTeV6po7aDZH6lFxGS7iteV
ndGMt1ODm+ugbKcLv6C1A9UfqUUkZLuc8PNGqUlAWgkFgSBI7XQ3SF53g2aH
9hYRM9uXakNUaRD4Pn4WClI78b5Sve74ny5AEHRkUbk2RKpDpq8NUTN7I7T3
FesO/7TWhijiyGqhDUnTFV8bopBst9w0qPC6w8e7aEMx2a5UGyJ1+KyfhYKy
nXhfqaa1g24lQekb0+7jft6IvVAQC2zWYkAQpHYM0PKOJDZrHYHggHrgdbQA
Av+ULokgtfvDvXPStR4FkI5AEHRkUbk2RKrxe/AkAt+Rpb2vVBVABs1GeS0i
WC5roQ0JrQ1WWX3Z7lTzsGmhtV20oZhsV6oNkaK1fkkwKNuJ95UUre1SEkwf
bTM2nH7miYYJsZBWQkEg8Kkdhrj94ZFzABpERyCIme1bAIGc0uUDQfBlTPG+
Uk1IOgJBrEdWqTZEqvF7kI76jiztfaWKkAya/QpaRNCR1UIbElob1IZ82Q6a
BbyvpGhtF20o2JGAyrUhUrTWLwkGZTvxvpKitV1KgjHZLjMcvgEg8MEuHdis
BYHAp3ajTh11qpTNWhcgiJntWwCBnNLlA0GQ2mnvK/5CRyCI9chqoQ1J4/eg
3OY7srT3FX+B/7WLNkQRR1YLbUhobVAb8mU77X0lRWu7aEMx2a5UG6Ka1gZL
gkHZTryvpGhtl5JgTLbLDCdvIKtvLQECqjdrQSDwqd2ox/We0f5dNmtdgCBm
tm8BBHJKlw8EQWqnva+4Fx2BIEb5WmhDc3Xjd18bosqR5RTAtfeVKg2C/7WL
NkQRO1Dpe0OkaG1QG/JlO+19JUVru2hDMdmuVBuimtYGS4JB2U68r6RobZeS
4IlWK13CyRv6oIr8wGYtCAQ+tUPbXvnCslnrAgSgdv7qaAEE0CD0m4MSQWqn
va+iQXQBAoq03m2hDYkGEXxd2ndkPdB8PRAaRBdtiCKtd1toQ1TT2qA2dI/X
Y8Rp2C60tos2FJPtzivUhqimtcGSYFC2095XobVdSoKJo21ywskbqFqXqrrY
rAWBwKd2x05Uq++p0eqTzVoXIIiZ7VsAATSIIBAEqR2TDVl9okF0AQKK9Mhq
oQ2JBvHm+wEu5zuytPeVag2iizZEEUdWC22Ialob1IZ82U57X0nR2i7aEP+2
gSfbtdCGqL6bwZJgULY7/8oz3lehtV1KgjHZLjOcvBHkSGMDm7UgEPjUDpRm
Z723lc1aFyCIfe0WQAANIggEQWqnva9UaxBdgIAiklYLbUg0iGC7e9+Rpb2v
VGsQXbQhijiyWmhDVNPah0OlPF+2095XqmltR20oKNu10IaonupgSTAo22nv
q9DaLiXBmGyXGU7eqIGgLI9hsxYEAp/aQZV4tG4JJZu1LkAQpHbtgACaQhAI
gtROe1+p1iDyu7MGI+gMl0M38kM0iOBxfkNHVvMytfeVag2iizZEkUYKLbQh
qmltUBvyZTvtfaWa1nbUhoKyXQttiGpaq58ciaBsd84lZ26E0NouJUHIdkGs
zwknbxyoG2wW/RJs1oJA4FO7EQ17YUTDsFnrCATO70S0AwLMQBAIgtTOcU9B
g+gCBP7vRLTQhkSD8LUhCjmytPeVag0ivztrMG59MNBIQRpsFv0q0NqgNuRU
dKnpfaWa1nbUhoKyXQttiOoZCJYEfdnO8b5STWu7lAQTR9vkhJM3pPNh0S/B
Zi0IBD61Y3aq9xTYrHUEgiC1awcE0CCCQBAUqZ2T0KFBdAECivTIaqENiQYR
PCHCd2Txnk730oEG0UUbokgjhRbaENW0NqgN+bLd080H7833h8iS3501GEE2
3uK9IaoXWrAk6Mt2y96eArS2S0mwhVNLh5M3aiAoy2PYrAWBwKd2L73ZsLVg
s9YRCILUrh0QYF8cBIIgtdPeV6o1iC5AQJEeWS20Iar2xUFtiEKOLOn7ini4
AvGO2lCwkUILbYhqWhvUhnzZzvG+AsQ7akNB2a6dNgRaG9wm+LKd432lmtbm
d2cNRlC2ywwnb5Q2F0VgsxYEAp/aAdB5+4l/BV/qCARBR1Y7IMCngvPpUzvH
+8rBRKUjEHBcGOqR1UIbwqeC2hCFHFna+0q1BtFRGwo2UmihDcmngtqQL9s5
3lfQ2o7aUFC2a6cNYRUES4K+bOd4X6mmtV1KglRtdm554MV2n3XyRmlzUQRY
ShAIfGqHltSvHjrzlxkQOwIBqJ1jO2kHBGApQSDwqZ3jfaVag+gIBL4jiyrm
sKFQG6p+1eNBbYhCjiztfaVag+ioDQWfqBbakPyqoDb0mLe/dryvoLUdtaGg
bNdOGwKtDZYEfdnO8b5SRWs7lgSp/E00Hc77Ke2AgMkD4+wHIXLuUzs8jYuH
P5Gf8N3MP+IkGEFHVjsg+Ozz03wtweNLyDsD1/G+cux8+hB/vCMQ+I6sb1pp
Qxybtr+i62k6fEeW9r5y8D3iaxGq3y58RxaNiE2ZNkTVk8Pfx2+bQyHZzqmU
fvPNt/zZ1q9/IoKyXTttiJGOv09QuPRlO8f7SsPS0+ulBgM/Yg2dcsLhG6Vd
pseGT+3Qyr609JqOoCOrHRCkw6F2jve1r/AdWe20oXT4jiztfe0rgo0UWmhD
6fBlu9jRGF0iKNuBbMtxe93Dl+0c72tfEZTtMsPJGy1MAunwqR2nzYE6DrWX
CDqy2gFBOhxq53hf+wq/5Vo7bSgdN3kYob2vfUWwYtZCG0qHL9s53tdeIijb
tdOGEuHLdo73ta/gXWpRpx0dTt4obS46Nnxq13t+ppraOVUmi4Ecaud4X/sK
35HVThtKh+/IcryvvUTwVOt22lAifNkOGt/pr9wzC7pEULZrpw0lwpftHO9r
XxE72iYnnLxR2lx0bPjUDg9S/rmWORF0ZPUOBBz/46pHNLVzvK99he/IaqcN
pcN3ZDne117Cd2RRW20oEb5sh1NxOxaanGCS7Mt2pc1Fx4Yv2zne174iKNtl
hpM3SpuLjg2f2mHDK8eh9hJBR1bvQEAetUNWfPKFngmkz/raaUPp8B1ZXTa8
sQj2yGqnDSXCl+0c72svEZTt2mlDifBlO8f72lcEZbvMcPJGaXPRseFTOxyD
WCr1piPoyOodCMijdh0Pr4mF78hqpw2lY/Q2yjdn5sfxvvYSviOr3XtD6fBl
O8f72ksEZbt22lA6HNnu6UgbzI4RO9omJ5y80eIF0nT41G7T9qERKOh8bh2+
gZ8MgIA8aud4X/sK35FloQ35jizH+9pL7D74tuPIstCGfNnO8b72EkHZDofi
9TuQI9s53te+Ina0TU7ovNHRsh4Mn9qBBvQ4BEW+uQUQOPs4x/vaV/iOLAtt
yHFk+d7XXsJ3ZFloQ75s53hfe4lgN7zetSHyZLtHnx26Yd/50O1P2DG6FDN1
3mjXXDQdPrW7eesL50XemOgS/ulCFkDgUDvf+9pL+I4sC23IcWT53tdewndk
WWhDvmzneF97iaBs17s2RJ5s53hf+wpftssPnTfaNRdNh0/teELOv7JnAkkh
s70FEDjUzve+9hLX3+s6srYYaENOgdr3vvYSviPLQhvyZTvH+9pLBGW73rUh
8mS7kSZ1wj23pWN0mSLtM2/XXDQdfi66ZnPZudWZ4Z//ZQEEDrWz8L5SyJFl
oQ05jiwj76vf0QVuhH61Ib/RsYX3NUjIe9eGyJPtLLyv1M2spfmGBRD41O6q
O2YvjLxp1SV8s70FEPz21ga1s/C+UsiRZaENOY6skfe17YEasfAdWRbakC/b
WXhfR1s5JduN3hvquyjkyHYW3leKHG2TGTpvAAj6VRV9anfZbQd+dWPPZQfy
qB3ZAIFD7SzKDhRyZFloQ44j6wMb76vvyLLQhnzZzsL76st2FtoQebKdhfeV
IkfbZIbOG+2ai6bDp3YM2Re1rcYkwqF2RkDgUDsL7yvVbyXrn1hoQ85BTkbe
V/+hstCGfNnOwvvqy3YW2hB5sp2F95VanWYoofNGu+ai6fCp3W82PHnxxv09
DoFwnhMjIHConYX3lUKOrCFJ61sbchxZRt5XeKS1I8uCpEG20+0sLLyv5Ml2
FtoQebKdhfeVIkfbZIbOG+2ai6bDp3YzN7R3tybCoXZGQHBVk9pZeF8p5Miy
0IYcR5aR99V3ZEEb+rRXbciX7Sy8rxw/bMp2FiVB8mQ7C+8rhWS7/NB5o12X
6XT41O6X17V/Cy8RDrUzAgKH2ll4XynUI8tCG3IcWUbeV9+RZaEN+bKdhfeV
PNmuflO152TryHYW3lcKyXb5ofOGhUmAPGr3s6t3X3t3zzIHedTOCAgcamfh
feW42+uRZaENjRxZdbtOI++r78iy0IYc2c7I+0qebGehDZEn21l4XwmyXdqB
uXJky7pp+DQ27Wt0K9J5o11z0bHhUDue+Rvu659AOmUTIyBwqJ2R99Uvm1ho
Q44jy8j7+sZ7nziOLAttaCTb1aY1VNXu6tv7Sp5sZ6ENkSfbWXhfKXK0jY4j
u9dMTW8+vkInF7dNTa09pPQcnTfaNRcdGw6169JFOREOtTMCAqePopH31XFk
GWlDThncyPvqO7IstCFHtnPSSI/hvDBuoQ2RJ9tZeF8pJNs5cXxx377FKiUu
z01NTc+rAobOG703F0U41G7Q96tzCIfaGQGBQ+34Eeq3rSLCcWQZaUOOI8vI
++o7siy0IUe2M/K+kifbGRl4HNnOwvtKIdkuEkc3z0xNb5zV9pGpZlisAk3t
vl4Zyit37Ah32O4STk42AgKH2l1p43196KmGI8tIG4IjS7rBGHlffUeWhTbk
yHZG3lfyZDsLbYg82c7C+0q1bPfV1yk72fKR2bVTU2s2zTp/SfMNixdIqUnt
cGLp3bv7J5BOi2wjIHConZH31XFkGWlDjiPLaMb8l54stCGnF5CR95U82Q5O
zn61IfJkOwvvK2XUM5cP7x5WRGeHtamVlUbm0Hnjor6biyI0tavr3p1OSwmG
Q+2MgGDk3Kup3dD72u2kuWA4jiwjbchxZBl5X31HloU2RE3Zzsj7ysEwoaHf
SFBzZLufX9O/95VCsp0Tu9fpvciaWH2j9+aiCE3tgh2TegmH2hkBgUPtjLyv
jiPLSBtyHFlG3lf/jltoQ9SU7Yy8r+TdcQttiDzZzsj72uWO67zRe3NRhE5H
zL0Hfb+qj3ConREQONTOyPvqGHfnbLQhp9exkffVcWQZaUPUlO2MvK/kyXYW
2hB5CsXQ+2qQabs0/Nd5o/fmoghN7Q5/NCSQjKe9j+JQOyMgcKidkffVcWQZ
aUOOI8vI++o4slDg6l0bopEvaCTbGXlfyZPtLLQh8mQ7I+9r8GibzJC80foE
0rGhqR226nufP5z+SItwqJ0REDjUzsj76jiyjLQhx5FlxNAcK4WRNkRN2c7I
+8pxyZ/2a9nuolue+rdbe9aGqCnb2XlfHdmuKCRvAAj6bS6K0NQOGLe/2xHn
wXConREQONTOyPvqOLKMlA7HkWXkfXUcWUbaEDV32UbeV/JkOwttiJqynZ33
1ZHtikLyhkVzUYSmdv7bkX2FQ+2MgMChdkbeVzz24sgy0oZGjqxadDDyvjqO
LCNtiJqynZH3lTzZzkgb0rKdnfd11O74WJt2x5I3LJqLIjS1e+H1/lsDIZja
6R4FRkDgUDsj76vjyBppQ323e3IcWUbeVzj9xJFlpA1RJdtdeceo1mTkfSVP
tjPShrRsZ+d99Y+2yQ/JG3ZAoKndQa/bZF/hOLKMgEC3GrDzvjqOLKPKg4MU
Rt5Xx5FlV3nQsp2R95WquplkVzttSMt2dt7XLv12JG9YdJlGaGq3v9q56674
fYXjyDICAk3t7LyvjiPLSBtyHFlG3ldqOrKMtCFqynZGFSFqynZ22pCW7ey8
r45sVxTiBjMyCVCT2u2tvupbrb5qOjS1swMCTe3svK8vVzKiVIGMtCHHkWXk
faWmI8tIG6KmbGfkfaWmbGenDWnZzs77CtmuXRVI+IZFc1GEpnZ7Dg5PrDvc
akuVDt1Fyg4INLWz8746jiwjbciphBt5X6npC7JjAvp1Oay7U317X6kp29lp
Q1q2s/O+dlnykjcsmosiNLXb0UH6SYemdnZAsFdROzvvq+PIMtKGHEeWkfeV
mo4sI22ImrLdn206UFFTtrMrCWrZzs776sh2RSF5w6K5KEJTO0bn1ha1dGhq
ZwcEmtrB+6o7S/QVjiPLSBtyBD4j7ys1HVlG2hA1ZTsj7ys1ZTs7bUjLdnbe
V0e2KwrJG0bNRalJ7TAKI13vo2hqZwcEmtq99b6V99X5/kbakNMOyMj7Sk1H
lpE2RE3ZbjjKJSajaNnOThvSIG43SpeeeJI3jF4gpSa1w27ii+WeT6yjM6Ww
IZOxAwJN7ey8r44jy0gbchxZRt5Xar4GbqQNUbMJp5H3lZqy3X4zbUjLdnbe
V/9om/yQvGHRZRqhqV1Oi6F2oamdXYrW1A7e14MG3lftyLLThhxHlpH3lZqO
LCNtiJqynZH3leodEB5gO21Iy3ZdVI90OLJdUUjeMGouSk1qd9tDY1qhtg5N
7eyAQFM7O++rdmTZaUOOI2tg432lpiPLSBuipmxn5H2lpmxnpw1pkcLO++rI
dkUheUNPe7+hqR0jmnPSel+hqZ0dEGhqZ+d95UdRHFnHT1ppQ1Q5sjZWjiw7
7ys1HVlG2hA1ZTsj7ys1ZTs7bUjLdvC+SvO3HsM/2iY/JG8YNRelJrXjHfRP
rjDZ3oLawRliBwSa2tl5X7UzxE4bIuXIsvO+cvyLcoZUrTJN1N7r7z2zN7Hz
vmrZzk4b0nsTu4fZP9omPyRvXGTQZRqhqR2Dws+ubnmUbTo0tbMDAu3Gt/O+
akeWnTZEypEFLwfPm8Uo2pFlpA1Rc6Nt533VsqOdNqRlOzvva5dHS3zmDARG
th9N7dbdOfvL6/o/sY6a1M4OCDS1s/O+akeWnTZEypFl532lpiPLSBuipmxn
533Vsp2dNqRlOzvvqyPbFYXwDQYFiyaB1KR2PIoREGhqxzfUSIbT1A6OEQsg
OPXFaXFkAXosZDhSjiz08LF4CYKUIwuOkTsNWtBw/PHBF0W2Y1Zj0QCcmrLd
Zbc/bXH8IjVlO3hRvl7p38MG2e6R2bdbfFb3FzUKTe2YSd6gzm7rMfSLlsPs
pJpA9hia2iE7WSjX2pFVZ6f+HbakHFmm2UlKZ8hO7QBubIhsZ5qdtGxnl520
bGeXnbq03FmFvCHUDtt2ixdIqUntfnz5TiML0zuK2tllJ+3IsstOpBxZptlJ
HFmm2UlkO1PutPPpkWxnmp20bGeXnbRsVxqrkDeE2kEvbqf7jA2hdqbZSVO7
ijuZZCftyLLLTqQcWabZSRxZptlJZDvT7CSyHZinUXYS2c40O3Upaq1C3hBq
B8nDQoAgRe1Ms5NQO9PspB1ZdtyJ1BtzptlJrEGm2UlkO9PsJLKdaXYS2c40
O3V5bXwV8oZQO9zZz+PnynUJULu51z4yzU5C7XBnjbIT1Y4s0+xEypFlmp2u
vftZOLJMsxNkO366htnp8p1G2Ulkuy2W2UlkO9Ps5DRSKIpVyBtC7Rh3jMwb
pKidaXb6+MSI2plmJ6odWdbZCY4s6+wkjizT7CSynWl2EtnONDuJbGeanbRs
VxqrkDeE2jErXnvbgfEfaBVC7Uyzk1A7WESMshPVjizr7ARHFqbO4sVeBBxZ
1tlpJNt99qVpdhLZ7iLL7CSynWl2chopFMUq5A1QO6Ze/3DJ9j9tM3lzihS1
M81OQu1MsxPHTypHlnV2Gvoqb37SOjvBkWWdnSDboaueXXYS2c40O4lsZ5qd
RrJdq6LrKuQNUDs0T/7r/v676iFA7R577l3T7CTU7p/+YJidqHZkWWcnOLKs
sxMcWdbZCbIdHjO77ATZDqPYZSdppGCanZxGCkUhPvPev5UEqB3KDnOv9f/W
OQLUDqPYZSe8/3XHjldMsxPVjizr7ARHlnV2giPLOjtBtsMDYJed0NoFo9hl
J8h2GMUuO33b4UjoVeAboHbr7pwdqioftzlULidA7TCKXXYCtcModtmJKkfW
FZuesc5OcGRZZyc4snjSTLMTZDvcGrvsBNkOo9hlJ8h2GMUuO5FqpFAaq5A3
QO1+ce2jRjZ7BKgdj2KanUDtMIpdduK48LrHMIppdrrqztkLfr/HOjvBkcWX
Y5qdINvxKKbZCbIdbo1ddoJsh1HsshM1j7YpilXIG6B2/I+RzR4Basf/mGYn
UDv8Y5edqOpTgVF49uxG4R0KRjHNTtih8D+m2Qn1E/7HNDuhusv/mGYnNGvC
P3bZiZpH2xTFKuQNUDv+x8hmjwC1s85OHOfYZyeqHFmrkJ2uvfvZVchOcGRZ
ZyfIdtbZ6W/vHF+F7ATZzjo7US3btfjgKuQNUDtUxuxGAbWzzk5UUbtVyE7/
suHJVchO1987twrZCY4s6+wE2c46O0G2s85OkO2ssxM1j7YpilXIG0LtjGz2
CNiKrLMTVdRuFbLTRbc8tQrZ6cb7n1+F7ARHlnV2gmxnnZ0g21lnJ8h21tmJ
OrRfW4W8IdTOyGaPEGpnmp2oonarkJ1+e+u+VchON299YRWy04NPLK5CdoJs
Z52dINtZZyfIdtbZiZpH2xTFKuQNoXYWrbEkmNrxtVTZqf+jsXWcf9Ujq5Cd
cC3W2emPD764CtkJ12KdnSDbWWen945+hssxzU6Q7ayzE1W3Ro62Kf2g9UeY
2vFHmN6bjsLUDje0KDu1u/zS7NR6lKLs1HqUouzUepSi7NRiFF5iaJNb9KnS
gY58fIo/UpqdSkf59ttvW2SndremXXv5VcgbTO34I6VtRUtHYWq3CtmJ6lUw
yU6lo1hnpxcXj/KnSrlT6UAfHV9aheyEj1hnJ3ykXel1FfIGqF2pzb50FJ7h
VchO+MgkO7UYxTo7vfzmMf5U6c6udKCPT3yxCtkJH1md7JRu/D41iUlMYhJ5
YZGjJjGJSXw/Yuvexa3/p/YJnMQkJvE9i0nemMQkJlEak7wxiUlMYhKTmMQk
JpGIlaNz66ZRAF677/Dw6L3D+zbi3zfuO/xdf7tWsbywZmrN/FL1x8P71lTX
smbjvuXv+nuVxvH5bbgzazZVX3758KaZ6t9nNh4+2y7m5OLu0Xdfv/149ZOz
9DFbWtw2Nb0Z56B7T9fyvo2jH+ytltL3N1Z2r+FpmF8hWty2dmpm+/LJuZmp
6X1HlpeP7Juempk/+65+efva4eO5MPzmJzdPT23Yd4SWj/Azummh/1PvDWN5
kRfatsUl/gM/i9sOL89vmpnewM8nP5zT05vaNND+7mJpy/TU+r1HiI5sGN6I
JTo7H7Mjc5ur3Lel+r7u03VyfhNnwSPLdIRTYp1bvqexsrhv78JxThu0ND+8
pccW+No3A6v5Xm+aP8uu/hBnjTUb1s2sHT6KS/P8TC5USLC4eYYv5rv+dgWx
xDdi3e6jRw/NzS8cOnx0aWVpM1bcMKPwH8+ux3Jpy8zUhtmjzKF4rfESWzob
H7PlhXUz67dtXss5YfjNvadrYVOdz1cWOCueLcmwS6wcn2NQ2zh7lG/ozIZR
E5L5jWs2nhU3tI7lw9unptYfpZVtM2vml4d3ds30RrDik/MbZzaeVXljcUvF
6jdt3sB3Zu38yZObZ2ZmcTeW5mbONjhb3DYk8DPDfdca5n1n72O2cmjzKON5
T9fCpjUbZkc/2DS9Zu77njfAvjbNMo3kydg0vWH0ct/chpmz6Ibydx9extpN
u3dv4b3X+s27j34yPzNV39nqYr7jL1gSSwt8NRvx6O1bN7Vx/v1N03XeODk7
M73pLLoxgGY8Sot8czbOn72P2dLimbzhPF28kazzxvGNUzPf77xxeO96xoHZ
I8OLXFlZoaN7ee0tLg8T69qpqe1nUwFu5fDC3Ozs7Nzs3nVMGHfPn1w5wte2
7dDysOixZmrN9kPf9TcsiJUj20c3gsFruEP5hLPHmm3DS6j2YtvPohvDDJ95
O5YU541pTuBn7WNW5XPssNyn6+i+9VMz25ZHvHftoZXv+rvaxcqhddpSP7OF
8/7CttHP1m45u4pvEstbZtbOV0/iyYVto0tbu+34d/21SmNx+/rRbdmwt6ry
LtQ3a93Zg8+jWNy9YfTdp9cvnByuqLP0MVvm/SPqG4Gn6+S2WpvcsnDWPW49
xMry0tLy9yVdVhfzXX+JtuHeiJWlpaWz9cYMb8SS+4Oz/THznq7vwTVNYhKT
mMQkJjGJSUxiEpP4fsf/Bg5S6A8=
            "], {{0, 233}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 233},
          PlotRange->{{0, 360}, {0, 233}}]], "ExerciseOutput",
         ImageSize->{240, 157},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ddfd41a6-2fa4-4a21-ad59-dd9a6397c677"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvVubHdWxJepz+uU8nr9w/kW/9mO/dn/ndbGxcdl0m7LN3rvc3kZ7GxAY
EAZkLgIjb9gCLG4SWGBdkAABkqAEBRSXwhQgQIBAwkIIFVCCguhYOVaGIudt
zZmZUbT4VnzYnyi0aq6cmTPGmDFGxvz/fvjz/zb1f//gBz/4x/+H/++/nfur
/3Lhhef++r//v/wv///0P57/k+kfn/dfp//pxz/58YX/+Yf/iX94lP/30//r
Bz8Y/pniMVVH4u9MYhKTmISOScaYxCQmURqTvDGJSUyiNCZ5YxKTmERpTPLG
JCYxidKY5I1JTGISpTHJG5OYxCRKY5I3JjGJSZTGJG9MYhKTKI1J3pjEJCZR
GpO8MYlJTKI0Jj7zSUxiEqVhlzEen3v3hvvmlr9aMfr9iBcXj95w3/MfHV8y
HeWdI59ef+/c6+8eNx3l5NIyz9jsq0dMR+HgUXY+c8h6lD/vWrhn92vWozy8
782bt75gPcqBlz/gx+zUF6dNR3nlrY+vv2/uvaOfmY5y5ONTfC08VpdfYpc3
bnngxcHFfz31ue1U/3X/WzzKG4c/MR3l4KtHeJSnXnzPdBS+oTzKvXv+ZjrK
1yvf8Ch/uHfOdBSOf77+8V/f9IT1KFfeMXvupdutR7lr1wJP2scnvjAd5ZHZ
t3mUl948ZjrKwtt/51F4rC6/xC5vrL/nOf56n55aNvr9iL88+QaP8rd3bJnA
ky+8x6MwgzId5d0PT/Iomx9ZMB2FMzmPcu3dz5qOwvGLax/91Q17rUe5+E/7
z7n4r9aj3P7Xl3nSrGktHmam0KajzL9xjEfZ+XQnwmmXNxgI+OsdP/ml0e9H
3P/Y33iUVw/93XQUAMGjz75jOsqb75/gUe7a+arpKMdOfM6jXH3XQdNROP7n
ut3/9IfHrUdhSjOwzxu3/mWeR/ng41OmozDV5FHm/vaR6SjPvfYhj8JEvcsv
scsbDASrQO0YnVeB2gEIOlK7sfHaO8d5lE3bXzEd5fBHQ1Zz1R2zpqNwTP1u
14XXPWY9yi+ve5QvhzdfpqNs2PICj2JdeeBbz6McNC5wPf3yBzzKtqfe6PJL
7PIGgMCa2mGqrakdgKAjtRsbnP14lNseftl0lMXDn/Aov/uPZ0xH4Tj30u0/
v2aP9SjnX/kIX451+f0P987xKO98eNJ0FJQEn3nlA9NRnnpxuOl+8InFLr/E
Lm8ACKyp3Z+2vbQK1A7ZqSO1GxvP/+0jHoWvyHQUZKfLbjtgOsq3337Lo/zs
6t2mo1CVnXigL5a/Mh3l938+yKO89f4J01FQEtz/0vumozz63Ls8ypbHX+/y
S+zyBoDAmtrdvHVIIJ9d+NB0FABBR2o3NmYr1eaPD75oOgq0Id5Fmo5y+usV
HuX8qx4xHeWrapShbGeskF6x6ZlVkO1QErSW7XY+c6i7bGeXNwAE1tTuhvvm
VoHaAQg6UruxsW/+fR6Ft9Kmo0Ab+rdb95mOsvTlVzzKT67YZToKtKFVkO0u
/fcDqyDbXbxx/yrIdg/ve7O7bGeUNwQIrKndtZufXQVqByDoSO3GBj8wPMoN
9z1vOgq0oYtuecp0lBOnlnmU8y7bYToKtKFVkO3+9Y/7VkG2Q0nQWrZ7YO9i
d9nOKG8IEFhTu6tWhdoBCKwdWVjR1o4saEP/suFJ01E+PvEFj2LtyII2tAqy
HU/XKsh2KAlay3Yo8neU7YzeTxEgsKZ2l902JJB7nz9sOgqAwNqRBe+rtSPr
nj2v8SjWjix4X60dWdCGVkG2++frH18F2Q4lQWvZDt7XjrKdEd8QILCmdr/d
uG8VqB2AwNqRBSZg7ciCNmTtyIL31dqR9VJlfVwF2e4X1z66CrIdSoLWsh28
rx1lO6O8IUBgTe1+c/OTq0DtAATWjix4X60dWdCGrB1Z8L5aO7KgDa2CbPc/
1+22lu2kJGgt28H72lG2M8obAgTW1G7mhr2rQO0ABNaOLHhfrR1Z0IZ+fs2j
pqPA+2rtyII2tAqy3dTvdlnLdlIStJbt4H3t+BKxUd4QILCmdoyb1tROgMDa
kYUdhLUjC9qQtSML7jJrRxYqyfzPoQ9sZTsAh6lsJyVBa9kO3teOsp1R3hAg
sHZkXXD1bmtqJ0Bg7ciC99XakQVtyNqRBe+rtSMLFSFr2Q7eV2vZTkqC1rId
vK8dZTujvCFAYO3I+ukVu6ypnQCBdX8YeF+tHVnQhqwdWbM14TR1ZEEbspbt
TteE01S2k5KgtWwH72tH2c4obwgQWDuyfnTZDmtqJ0Bg7ci6vvK+WjuyoA2d
d/lO01HgfbV2ZGFnZy3bwftqLdtJSdBatoP3lVlHxt89uXvDTGXTmNm+0MjM
RnlDgMDakXVONcp9jxpSOwECa0cWvK/WjixoQ9aOLHhfrR1Z0Ib4n5ctZTt4
X61lOykJWst28L7myHZLi5unptYfWaGj+zZMTW3WFhmjvCFAYErt0PLOmtoJ
EFg7suB9tXZkocRn7ciSjaqpIwvakLVsB++rtWwnJUFr2Q4b1RzZrsobG3lm
j89vmppejbwhQGBK7b5Y/noVqJ0AQR61ax/wvpo6skQbGhjnDXhfB8aOLGhD
1rIdvK/Wsp1kWmvZDt7XLNluaXEtJ4jp4VZlZksDmqea0dd3EyAwpXYnl5ZX
gdoJEFg7suB9NXVkiTY0MHZkPfjEqMBl6siCNmQt24n31VS2k5KgtWwH7+sl
GbLdwqbp6U3zwz8tLayZmp5ThMOIbwgQmFK7v386IpC3W1I7AQJrRxa8r6aO
LNGGBsaOLHhfB8aOLFDuSrYz7K0n3ldT2U5KgtayHbyvObLd4uaZqY1VTW95
kfPGvH3eYCD40dod1tTuw78vrQK1AxDw5Vg7suB9NXVkQRvCrTF1ZMH7OjB2
ZP3yukdxLaaynXhfTWW7//jrsCT4w7U7rGU7eF+zZLuTiyM5ZWpq/fYFDTNG
eYOB4ILf77GmdsyBV4HaAQj4cnKoXZeA99XUkQVtCLfG1JElhXFTR9b5Vz6C
azGV7cT7airb3fLAi+deup2vyFq2Q2E8X7ZbXlpa8jw4RnmDgeB/3fiENbVj
LFsFagcg4MuxdmTB+2rqyII2hFtz0n8a+gt4XwfGjixeArgWU9lOvK+mst36
e55jyOBNhKlsJ97XX93YSbYzyhucNmEvMaV2r787IpA33m9I7QAE//rHfdaO
LHhfTR1ZsHHi1pg6suB9HVg6sqAN4Voefc6wt554X01luyvvmGXC+fNr9pjK
duJ97SjbGeUNXmi///Oz1tTulbc+Htg7sgAEF2/cb+3IgvfV1JEFbQi3xtSR
Be/rwNKR9VmlDeFaTGU78b6aynZ4wJiom8p24n3tKNtZ5A0AARDHlNq98PrR
gb0jC0Cw9rYDHand2ID31dSRBW0It8bUkQXv68DSkQVtCNdiKtuJ99VUtvv1
TU9c/Kf9TANMZTvxvnaU7SzyBoDgjh2vWFO71XFkAQh+9x9PmzqyxPs6sMwb
0IZwa45YOrKusndkQRvCtXwPHFlgGjM37DWV7cT7ekE32c4ibwAItj7+ujW1
O/DSiEBedachtWMguORP+8E67EYR7+vA0pEFbQi3xtSRBe/rwNKRBW0I1/LQ
U28ajULK+2oq20FJwcNmN4p4XzvKdhZ5A0CA411Mqd0Tzx8e2DuyAARX33XQ
1JEl3teBpSML2hBujakjC97XgaUjC9oQrsVUthPvq6lsd+6l2zkvXXTzk6ay
nXhfO8p2Fv3MAQQ4htKU2u05+A4mwZTaAQh4w96R2qVDvK8DS0cWtCFs2E0d
WfC+DiwdWZA58JiZynbifbWT7VASZHJuLduJ97WjbGfBNwAETFCRQnv//RI7
nh5izT9cst2U2uEqoKrYjQLvK1/LwNKRhauAqvLGe4aOLN6n41rsHFlPvDBk
mzBXmMp28L7y5djJdigJ8lVYy3bwvvK1/HBtpyOxLPIGgODlN4/96LIdptRu
21NDAvnTK3b91ozaCRDccN+cqSML3ldYOOwcWajSQFg0dWTxKLgWO0cWypXw
8Ny9+zWjUaj2vvLl2Ml2KAny82wt28H7ytfSUbazyBsjODv8ydTvdpk6srZU
NbGfX/OoHbUTILhpywumjix4X/laBpaOLMDZ0y9/MDDukcV7OlyLnSML2tD7
xz6zlu3gfZ3+vaEjCyVBzoTWst1cRc9wa7r8Hou8ASBgALU229+ze6gOMCW2
o3YCBLc88GJHapcO4CZebbNzZKFcf7AmhEajUOV9xbXYObKgDZ347Etr2Y45
84/W7hiWx81kOykJWst22Avg1nSR7SzyBoCAH35rs/2dO17lgf71j0/ZUTsB
go1/mTd1ZMH7ytcysHRkQRuae20IOqY9snih4VrsHFnQhk5/tWIt211/3xyn
QVNHlpQErWU7bFFxa053kO0s8gaA4NQXp02pHcdtDw0J5GW3P/3P1z9uNIQA
AcYyGoVq7ytfi6kjCwwQY5n2yJJrsXNkQRvCWKayHaQ0U0eWlAStZTtIabg1
XWQ7i7wBIGAWZErtOP744PDJMaV2AgRyUUYDYe+Asy3sHFnQhuSijEaB9xXX
YufIEoXLWrZjhsZPsqkjC9rQG4c/sZbtUEPAreki21nkDQECa7P9jfc/P/W7
nabUToDgzp2vdqR26YD39Yb7nrdzZIk29Oqhj00dWQxkci12jizBC2vZjmkG
k42Lbn7STraTkqC1bAfvK25NF9nOIm9IzrQ2219393PDEooltRMggIhv58iC
93VjdeavkSNLtCGI+AfMHFnwvuJa7BxZYnWwlu1+u3Hfb25+0tSRJSVBa9kO
3lfcmk8+ay/bWeQNAQJrs/26O2d/ce2jnKb+hxm1EyCQoo3RQPC+otJr5Mg6
9slIG5KijcUoVHtfcS12jix5us6/8pHrLWW731RMw9SRJU+XtWwH7ytuTRfZ
ziJvyAybUjsOiN2m1E6AABNu58iC95VXmZ0jS7QhmI3tHFnwvuJa7BxZDBlo
VWEt24E2X/rvho4sqZ5Zy3agzbg1XWS7xPspK998w/v6FjU6AYJ+qR2v2RcX
j+rzRi/+034eK5PaHfrg01fe+rh0UAGCB/YudqR2TvC16LmF9/Whp97McWQx
oPPHv1j+umhEoRlvH/m0X0cWb6xePXRmbuF9xbWMdWQtf7Xy0pvHONWUDvrT
K3fBHdSvbMdzO//GsaUvz2xIIV4zSOXIdjzJr79bnPalJNivbMeJ6IXXP9Jz
C+8rbk0X2S7BN9Dig9G89HcOgaCSUfqldpCeH58787RzUuLUlEnt+G+ed9mO
b7/9tmhQAQIhHsXfOxSfV22Xrt18BiXhfcW2aKwjC0msNA2KjALisfvg2y2+
eTAYizVKwvuKaxnryEISY+ZcOqjIKP3Kdg/vG66pF14/Y2654Ord12x+NlO2
4yT2j+uL1T0pCfYr231wbPjWPOci+Qm8r7ueebujbJfIG2CbvLkr/Z1iE+2X
2mGnsEP5iP7XjU/wEENqd8n4FA2PHKNJ0aCSlPA49eXIwk6BIUx+Au8rLPpj
HVlgm3sKz8ITbQiPU4+OLBzJsXx6xH/gfcW1jHVkoUh79V1lhEG0Iapkuys2
9Sbb3VrVDJ9++QP5yU+v2HX9fXOZst3U73by01i68CUp9SvbPffah/zbmJDL
T+B95Seno2yXyBsAghYYLUCQSe0yAy0rGWrlJ5zY+YHJpHbTVcP8UowWINhx
4K0eHVm1be9M8QelKiztsY4sXHIpRo+0ofc+ASL05ciSlpUn6i0kvK/PvHIk
x5EFE1opRos2RH3Ldmh0rGktLzRebtfkyXZo9siZuWhQYeb9ynYAO01r4X3t
3kghkTfkuJkijNZA0K8jCy0ddMNSbGwzqR0DwRCjD5ZhtFyCCCstvrkf4E4z
6ghppAJmGoMMRxYjSAuMlkvASzd9ObKkpYPso8WPmuPIwkt2pRgNbQiX0K9s
B+6kaS2yX45sx4wLU8FAXzSoXEK/sh24k6a1MC10b6SQyBvS9bcIozUQ9OjI
Ys5zXtXuW2/WmAnwhiiT2gEISjFagKA7tdMB7sR5T36Cypggdfrj11Rdf0sx
Wko0x08OddIHn+jnSCxp9/3OkU/xE3hfX8prpCBdf98/VpCTRRuiXmU74U5C
a+F9zWykIF1/GeiLxpWSYL+yHbiTprXwvuKWtajfSiTyBoCgFKM1EGRSu5yQ
dlh6s3be5Tv5X2tqlxIXBAhKMVqAoN8eWeBOTIHkJ/C+ZjqyGEFaYLRgGR7v
vhxZ0g7rtVo+hveV/5WvaKwjCxvAUozWFhReF2t6ku2EOwmthfeV/zVHtpOD
Rxnoi8aVkmC/sh24k6a18L52b6SQyBsCBEUYrYGgR0eWHJVyjdqs/cMl2/kG
5VA7AYJSjBYgkOJAu++vQ7iT1iDgfc10ZPFKaYHRsqHTnLB7yFEpokHA+/rm
eydyHFlYKaUYrV+x6VG2E+4ktBbeV86NObIdSoKD6jSoonFlQ9ejbCfcSdNa
JmaMWbOdGykk8oYAQRFG6ye/R0eWtBKVzdo33wxPrLv9ry/nUDsBglKMFpNA
d2onoVuJigYB72umIwvaUClGy5OPJ6ovR5a0EhUNAjfr3Q9P5jiy5ATqIozW
T36Psp1wJ6G1uFm8p8uR7V57++/4OF94/qC6JNijbMd5G19G01p4X6GzdGmk
kMgbAIJ/+sPjRRitgaBHsz3kBv4yslnD1uOuna/mUDsAAX+8FKMFCHrskQXu
hC8jGgS0p0xHFiMIPl6E0aINjaZuVw9HYoE74cuIBiHaU44jCwVhfsaKMFrT
vx5lO+ZOP758588qwwZ+ItpTjmyHkiBmQzvH0qHpX4+yHZCOv4ymtdCe8D2f
79BIIZE3AAQ33Pd8EUZrIOjRbM9wfMHVu7E7w09OVbN9756/gdqlRR/UDfAa
YD5GayDoTu0kAMf4MqJBwPua6chiBOEkgG1a/riiDenr6hiAY1wLP/P4Ibyv
x058Lru8RABcfv/nZ4swWjuXhtdVbrUKBsPxmlueqt7jHtFaeF95350j2wFc
MBsM95mD6pJgj7IduBO+jNBaeF+7N1JI+MyRYEGc8jFaA0GmIysnGI8uu/1p
Bi/ZrH1SNYhjspFD7ZBg8RLxQ9kYrYGgO7WTAHfC13671iDgfc10ZJ1TKYMM
skUYLXWA0Ravjx5Z4E6YWNEg4H1lKpXjyELxnMlPEUbrOkBfsh240433P497
gR/C+8pUCnctLduhJIjZYLjPHPddVRLsUbYDd7r/sdc1rYX3NVO2S0SCbwAI
0Gc+H6M1EPRltuckz/mHVwonT9msHUWW3vdmDrUDELz05rEijNZA0J3aSYA7
7a9FB/wQ3tccR5Zs0EoxWvscBj31yAJ3QkMP0SDurryvnARyHFl4OZG3ZkUY
rYvhfcl24E5bH39d01p4XzkJ5Mh2eBQxGwz3mePqkmCPsh24E5KY0Fp4X7s3
UkjkDdwOHAyXj9EaCPoy26Nn9fYDb/GjLps1/HDnM4dyqJ3cjiKM1kDQY48s
cCd0lhYNAt5XnaliISpqKUbrXcO5l26/9cEyrTAYQGEUWkWDEGjOcWTh5ceF
qqKYj9H60epLtgMK82rStBY/5F1qjmyHUtvxk18y0F+f/WKXfrT6ku3AnW66
/3kkZKG18L52b6SQyBsAAr41RRitpzeH2uUE9giM9XdVFi9s1qSECGr3bpLa
CScpwmg9vd2pHUK406uHhitFNAiUEHMcWcJJHivEaNGGqL8eWUPuVC0xeGnw
Q/BMfnR/k+HIAifBrjMfo3Xp7IbKO932Cs4EuNOhDz6FlwY/FO9rjmwnLnEG
+vwXu3TprC/ZTriTQ2vBM7s3UkjkDXkLvgijNRDkULuceKgqBXz491OyceYf
vlEt6idfeC+H2gkQFGG0BgJIbN17ZAl3ko0zfg7va44jSxJmKUZr13eOIysn
wJ2o3jjjh/JWeI4jSzSXIozWfTj7ku0Ac/y4alor3tetGbIdEuY3337LQJ//
YpfmGH3JdsKdNK0V72v3RgqJvCGb0yKM1kDQl9me2Q5zHr5qvVkTvM6hdgIE
RRitgaCvHlnCnbABFA0CeJ3jyMLmlHEEGJ1p33I0lF56ZAl3olEv2ZEGUeH1
kADkOLIkgxVhtH71qS/ZTriTprWC1zmynWSwrRXAZb7YpUuCfcl2wp00rRXv
a/dGCom8IUBQhNF6s9mX2Z7ZDgR6vVnDK2C8DHOonQBBEUbrjNRXjyzhTkx+
BkqD4AXI6THHkaVPMcjHaCcjMRBcd/dz3S7lDHeiWg/Cz+F9pTxH1jl1hbYI
o3VG6ku2E+6kaa14X3NkO6nQwmmf+WKXLgn2JdsJd9K0VryvI9numfaNFBJ5
Q4CgCKM1EORQu5zgh5A5D6nkT/UMz79xDNSOE0LiNwgQFGG0BoK+emQJd5Lk
T8r7muPI0lQ2H6OdimsvPbKEO1H94gN+Du8r/+HycUfbiDZEhRitK669yHbM
xzj5/HtV2tW0VryvObIdXy9OaWSgH2S/2KVpeV+ynXAnTWvF+5rdSGFlftt6
+DQ27WsgZiJvCBAUYbQGghxqNzYAwVhKerMmyyeH2mmpLh+jNRC821OPrIo7
DdcXk59BrUHI8slxZOl6Tj5GO98/x5E1NoQ70XAze0aDEAPnWEeWrucUYbT+
/r3Idpo7aVor6SKnR5aUBBnoB9kvdunv35dsJ9xJ01pJFzmyHcfS4papqbWL
y7R8iP+w5pDSN2J5QwPBiRKM1kDQi9keNvvHKqDXmzU5vTqH2gkQEDA67zUo
DQTdqR1CuBMpDUK8rzmOLA18+Rjt1Gd66ZEF7rTyzfCB1xoEvK+U4cjSwFeE
0T+9cpfUZ3qR7XipCtBrWive1xzZTvtVGO7X5WVmXZ/pRbYbcqeLR9xJ01rx
vmY2UljYNLNu++KRQwvzC4uHj57U8xvLG05hnx+JTIzWQNCL2R7lC2xD9GYN
oPDOkU9zqJ3ukJyP0RoIeumRtfTFGe5ESoPQoDAY58jaWmtD/OcDFenKwWgH
yIZP+O1Ppz8yNoQ7UdW4UjQIqXWMdWTp3R8w+o4dWe53rQ31Ittp7qRprdQ6
cmQ7vfvj6c18sUuXBHuR7TR30rRWlg9W99ZxjRQWt8xwfli/afOGNUw3tugC
YixvOMskH6M1EHRvf8qBnu0nqiKJ3qwx9A8qA3wOtdNAkI/RGggyqV06NHei
CvQvrxaveF8pw5GlW8nlY7Szm+ulR5bmTlqDgPeVMhxZWCb762WSidHObg60
kHNyl2vR3EnTWvG+5sh2Wt1muOdEyl917NC6JNiLbKe5EylaK97XzEYKC5un
pzbgUTy6fmpmTu0bppohP3fKgIzRP/IwmoHPf5NiaBKrH3upKflfiZMJf22H
ivBTzQ+DPumAg7OQEGDg8tYKlwEQvOJyqJ0GgiBGH3z1CD/5Tl9H/dhLTcn/
5fyw8bXMvdYgPEwF79z5qjMKPw9DAlyXcAWXxftKGY4s0YYogtEMmjyNTh0b
uoA89glHFm8AfXswz/mO5r0Gd/pzzZ20BgHvK9XdLBPX8sLrQ2SXfqqM0X49
hO/LE00ZC7qAPPYJ2Y6vl/+aU5nne81M0lnRnEWFO2lay3M73AR9vTJWtvu2
Qnbhitsrsu2AJl/In72i9/A8uBqUE7IdTzhfiz5vgqrtM2/T3nq/ca9xzAG4
E4e83ive18xGCod3r51as22YLU7OTU9NzzfzRvAjDl8CN9YYzbPET7huJcRx
ugICeYwT1A5FML4E/UMgqVPh/JcNT4rApzdr8vp8DrXTQICU6FQ4OTv5pRh+
+OUxTlA7LF5nscNl4VQ4R9ypToyiQegsPdaR5dicOCU6FU5kJ2eZCz3DvyYc
Wfyt/MU+9btdzormJTlQvjWtQUiWHuvIcmxOt3kYjeykO2RSk55RUrbDt3IW
+4aqO6uzohkgxLemaa14X8fKdrokSHVKdGgwZ6eBejsVIfSMkrIdvtU9zcWO
b+XQYN7BCXciRWtFwc9upHBy+/ppMIoNexuPUyxvaJOAfD29oj8+McTfn1+z
R3/KAYIEtQP8OTiCe6RXNLKTGJj1Zu3ePcM1eOrz02OpHf+ScxQQYJk7K5qz
00B1yERoIEhQO1y1Y4fABDorWnMnUhrEG+oS9EYvGE7R4HIPo5GddON3qg8G
lcx/8cb9sY0nXzU/dc4Pz6m6k+kV7XAnrUFI17uxjiwHWXZ4GI3spDtkcjCD
1buzhGyH/zT/RgOJrq26s+oVjewk7+VpWive17GynVMSxE7fWdGcnTRwIH5x
7aOyO0vIdrjq2//aqJljAp2NLWcnDehCa8X7+lUT39OxvLS07G22YnnDAQIf
o3kCB8NWQg1gcoAgQe2whXHkCbTp1isa2WmrWgKyWZMNNajdE3FHlgME5GE0
stNA2fgRGggS1A5bGEeewAQ67dw1dyKlQegN9VhHlmOK8DEa3Ek3fqf6fBYp
AiQcWejfdVr9QunOqle0w51GGkSVRuQe3TrOkeVUzpFs9YpGdnJoLfbpghQP
1ztW//djC+PQWnRn1Sva4U6a1or3daxs55QEGe6ddu7ITj6txTuq+HNCtsNz
7tBaHA/qlKo0dyJFa0Un6t5IIZY3HCD48rSL0ZxDBs0OmeQBQYLa4XqdcgGA
QK9oZCd9CI5oEJx4+T/xDIx1ZPkvfQwxWq1oZKdB85QuagLBl3Fqx48B/yeG
af1DTKBe0Q53olqD4J+L95UyHFnO6Zk+RoM76cbvVE+XmBwSjiw0IdTlAunO
qle0w520BgHvK2U4spwtho/RyE4OrZ1vVsITsh12vg6moDurXtEOd9K0Vryv
2HckZDv/OeSZ1Csa2cmntbokmJDtsPN1MAW7dV18drgTKVor3lfq3Eghljf8
e+FgNA6aHDQ3aw4QJKgdZHFnswYg0Csa2eltNc+yWRMsG+vI8u+Fg9HITk6C
oiYQJKgdZHEmJ/qHSIx6RfvcSSiTeF8pw5HlNLVwMFq404YtDWDCQV3yrwlH
Fs+/A9/SnVWvaIc7CWVinBU6PdaR5Rwz5GM0uJNDa/FcSc05IdvhKXXgG4lR
r2iHO5GiTOJ9HSvb+XU2Bji9opGdHFrrlAQTst1L1VPq0FrpzipM0uFOpGit
1ik6NlKI5Q2/1uRgND/bg+YpXeQBQYLaofzubNYABHpF475/qVKTbNak5jbW
keUDgYPRyE7ObFMTCBLUDuV3PF0S0qZbZsPnTqJB6F2hiBGxcAiJg9HCnfQp
XaRwE3H1XQedLyzBjG7QVMHeqdt0y4r2uZNoEHpXONaRpbUhhIPR4E4OrdW4
SXWPrKBsh+NQHVqLk/v0ina4EylaK97XsbKdUxKkelHLikZ2cmitUxJMyHbo
oOXQWkzgQFURR9xJpSahtZoMdGykEMsb/nlzDkYDlQaqlRB5QJCgdthuO99c
2nTLiubspLu4k9qsyZvUWDjbD0QdWT4QOBgt3ElrEKc9ghGjdmBZjgYhQCAr
Gv2FNHcSDUK8r5ThyHIEFwejhTs5GoTWhijpyOILGTSrUnJyn6xoZCddehUN
Qryv/MM/7xrjyPIFF43Rwp0cWutoQ/WeukH+EfyA+bSW2Qt+p7yp7XAnqnpH
gNaK93WsbOe/Ao8vJiv6D/fO+bTWKQkmZDssLofWoiQ4UCTf505Ca0Hy8d5E
x0YKsbzhA4HG6NOVkZUf10Fzs+YAQYLaAYmczRqnCPxO+QhnJ+f5l82a/GGs
I8sxCZCH0ZydMK5eCA4QUJN+6AASORoEJlCvaJ87iQYh3lca58hyTAIIjdHI
TjyusxC0NkRJRxaWqtYgkGb5d0rLC587iQahva9jHVl++kK+xYpGdsKt0QvB
0YYSsh3OdnForTy6+IjPnUjRWvmDswf3w3cdINXIRzg7YVxNa52SYEK2g8rg
sERmlfid8pE/DLlTA8KE1mqPzVjZLh2xvOEDgcZo7OjX3PKUw4gcIEhQOywr
h5Dz9eJ3YkXDZu/U92Szxp+FjzdB7RA+EDgYzdkJ4+pqkgMEFKd2ciCm1iCG
E1j5W2RF+9zpQK1B6HlL98jytSGqVp+saGQnftodDUJrQ5TskYUDMbUGgQnE
FGFF+9xJNAjMGw5oGNtIwS/PaoxGdsK4mtY62lBCtkOlXd81TCB+J1a0z51I
0dpf3bgX8zZWtvNLgiAPWNHIThhX01onHSVkO8yMc9fQlI9XhHRy87mT0Frx
vlLnRgqxvOEDgcZoGFmxedSbNQcIEtSO1+zA26ydU+2gZUUjO+1obkBks8Z3
E5xtrNk+aD+TFY3shGvROcoBAopTO8jizgLhJxY+PVnRPncSDeIhpST+6x+f
SvTICjYE0xiN7HT1XQedHKW1IarS2o9Djiy0hHIWCCYQU4QV7XMn0SC093Vs
IwW+2IuaF4s9EdYRshPG1bQW2pD4mhKy3VV3zDq0FhOI34kV7XMnUmxWyk1j
ZbvgxTIUYkUjO2FcnaOckmBCtsNsOLQW4hr/P15CD3InobWjclOFblWVbMyR
WImInYPgA4HGaBhZ8X30hDtAkKB2vAAHzc2aIKmsaGQnRxuVzZo4Hsea7YM6
nazoUXZ6+tB5zQkXM7/8JEbtQBsGTQ0CQCArOsidRIPQR0clHFkU0ek0RiM7
VY3fG8CktSGKO7Jgihs068zQhnC7cTd97kS1BqHX19hGCn7Dc43RyE6PVmVP
TWsdbcipqungX+7QWplAWdFYj442KrRWqtBjZbu6mNPYlMmKRnbCHGpa63z5
hGwH2uDQWkwgTzteAwlyJ6G14n2lzo0UYnzDBwJSGA1WAJej3qw5QJCgdgwB
g+ZmTZBUVjTKOJqgktqs/fqmJy6uvsxYs30QCGRFS3ZieqA1iHmvOBOjdqjq
DJolfQCBrGjJTvqDokGI95XG9cgKop5g9Ok6O+m3UxFOc+mYIwtVnUFz34e0
hnfosKJ97kS1BqG9rwlHFiJoVpEVzWyB/4LT+J08bSgh2zGhdWgttCHORbKi
fe5EitaK91XzqGD4JUGqeB1WNLIT7riGD6ckmJDtQOYdWgtuiRvESSPInWQC
xftKGbJdOmJ5I3jyxbX1ioaR9QOU0NVacIAgQe34YgfNzZoAgaxoZCfJQgjZ
rElDywS1QwSBQFa0ZCfdIZNCKBajdnJ2rd5iYwJlRQe5k2gQ+mXSdI+s4NZP
MFqyk/6FFNKGYo4sObtWaxAirmFFnw5xJ6o1CO19HdtIIbj1kxWN7OQ0fidV
2kIkZDt4XzWtle6ssqKRnZwPygSKkWOsbBd8GUdWtGQnh9Y6JUGKy3Zydq3O
w3xHmFvKayBB7iQTKN5X6txIIZY3gkAgK5qzB+cQp0MmeUCQoHaweOnNmgDB
aEUf/sSx2SNks8ZcBQdejzXbB4FAVrRkJ90hkzwgoDi1E4uX1iAwgbKig9wJ
TQuZDjG+DCrvK3mCqRO+NoTAipbspCvnFNKG4MhycjLV3tdBU4OQCcSKDnIn
qqUH7X1NN1Jw3huSwIo+/dUoO731fqPxO3naUEK2g7Kvaa24LGRFB7mTTKB4
X8fKdkFpW1a0ZCeH1jolQYrLdqLsa1qLCcTa4aQR5E5Ca/XyZLpedNifE7G8
EQQCrGjMPF+FtvEjHCBIULuLqxcDB2qzJkAgKxrZyfmgbNZk1yDNOWPXGAQC
WdGSnXSHTAoBQYzaIScMmhoEgIDqFR3kTphApkN615BwZFG8Tz5WtGQn55Qu
XxuKObKQEwZNDUImcLii1+4AE3O4E9UTqL2viUYKJERxp9tMDysajxlnJ5/W
OtqQvB7uDwGXkaa1MoH4A7OUIHfCBMJSiEdrrGwXJIqyoiU7ObT27t2uVB2T
7cRlJLRWSoLyGkiQOwmtFe8rjZPtxkYwb8SAACsa6MM5RNv4EfxNNBAkqB0E
qYHarAkQYEVjFOflLDqzWftIZ7YYtUPEPE5Y0ZKdHA3CB4J/vj5M7YBNg2Yl
RyYQKzrInWQCdWZL98iKtSbAisYGlrMTaonCV31tKObIAjYNmhoEtCGqVzRu
jcOdqNYgdGZLOLIoog1RvbQxCj8VPq11tKGEbAfvq6a1MoFY0RjF506gtXjg
sQVGt8yEbBcsCWJFo1qCleLQWqckSHHZDlqMprV6AoevgVT9f3zuJLRWZ7a0
bDc2gnkjVjHA9/z5NXsGdX3b2aw5QJCgdvw3B83Nmn7eeEVjFMf4TWqzpg0Y
MWqHiFUM+PZhFGQnR4PwgSBG7aAiaWalXRZY0edfGeBOVGsQ+hShdI+sWMUA
K5ovx3nzEf/V14bu8a5O/81BU4OANkT1PeJRfO5EtQahva/pHlmxd7iwonFr
eN/k01pHG0rIdvC+alqLCWQOg4cco/jcCbQW+z54X8fKdkNYCR2GyysaoyA7
ObTWKQlSXLaD91UzKz2BfI8u+P2eIHcSWiveV/L2eqURzBuJU8PEo4u9s7NZ
c4AgQe2Y8w+amzWNpHhRZeC92E41IAIOZIrSZvtYat1Qe3SRnRwNwgeCGLUD
59dXqidQXlTxuRPVGgQjtbzyme6RFXNEYEUP6tdSHA0CNQddAYg5ssD5B00N
Qt7AlRdVfO5E9QTuUVQn3SMrVjb/sn5tH9nJp7WONpSQ7cSmLlf6gOrOiuU8
CLXOxgTiMQPVGSvbxV5kRilPbodDa52SIMVlO3hf9ZW+XZcESb2o4nMnmUBN
dcT+1C6CeSPxMi9WtOCys1lzgCBB7fBukX6oBAhIrWinwwnVmzUYA6TPPMPc
TXGzfexUdFnRyE6OBuEDQSz/yC0TDUJPoKxonztRrUHoulDMkYWI7S9kRSM7
ORqErw3F8o94X/VDJRMoKzrInTCBuDWoCx1I9shK7C+woiU76cNnT3/llsGx
fB4LyXbwvmpaq1+8wooOcidMIK4F3texsl1sfyGPB7KTQ2udkiDFZTt4XzWt
lZIgqeK8z52onkDxvlLG0TbpCOaNhH6K92gkazmbNQcIEtSOaTn/5YGS3TUQ
4M+OcwmBzRogXtZp2mwfAwJZ0chOjgbhA0GM2qEt20DVZjUQyIr2uRONJvAp
nfzTPbL+PaQNkVrRyE6OBuFrQzFHFryvfDm6NqsnEAk/yJ0wgbg1WKcJRxYl
9VOsaMlOmtb62lBMtoP3FbdGaK0W1/DnIHcCrcW1YJ36WraO4HtDCKxoyU4O
rXVKghSX7a66YxbXIrRWv4ErCT947AhorS7sp2W7sRHMGwkgwIqW3g56s+YD
QYLacQL8WVWzks2aBgKsaMdmj8BmDYREdlJps30MCLCiJTs5GoQPBDFqx7/8
J1fsYnIieyUNBLKife5E9QTqbp/pHlmJjp267uRoEL42FHNkYV/Pt0bvlXgC
oQ1RvaKD3AkTiFsDJpPukZU4Q9mpimta62tDMdkOjwoeM6G1egKxooPcCbQW
1wIATct2CTaCFS3LxKG1TkmQ4rIdPyq4FllQegIhoAe5E9W0Vuf/tGw3NoI+
8wQQ4KtKcVuf0uUDQWIyeWn8+qZhaVQ2axoIsKKdzjMIbNbw3sG2p0aJN2G2
j2lD8vUkOzkahA8EMWoHZqJzl9OKgVd0kDtRPYHifaWaUQT/MiXVFqxodIN3
NAhfG8KuUFpeS4CZ8PfRGoSeQNymIHdCNQC3Bt7XdI+sRNtqrGjJTprW+tpQ
TLbDA4nHTHLXNbU2RPVtCnIn0Fpci1RcY4yCkiVBrGjJTg6tdUqCFJftmO7i
WiR36QnEayC/CnEnquRLprXifcU8XOAptvkR5BsH4kDA94L/q3CharM2yt4+
EMSoHVI3L0MNExoI+IM8yjsR3Z//mvNeoT/5EultKbMdWQKOBuEDQYzaQRa/
UMGEg6QvvXEsuOukWoPQeBpzZCES29I3Dn8iBQ1Hg/C1oZgjC44L3Bq4O5w3
cPkjfGscZxECXAW3Bnjqe/V1JNyknOJ4FCm/aFrra0PHvAdPfolci9Ba0Yao
aqnHowS/ACYQ1yKzmpDtEiVBftp5FDmqwKG1TkmQQg8e4jc3P3nxxv2a1uqS
IFXszjklQQITyAtHsHjs0TbpCOaNnKOpEHqz5gNBjNrhUUR9WDZrGgjSwYDL
61SPlTDbJ4DACUeD8HORts3oqFpC7WVyImpL6QQyIYH3lcb1yMqU3R0NwteG
Yo4sAD1uDTSI/AlEQyrcGnhfE44sKjl2XNNaXxuKyXZYy7gWobVOd9ZYYAJx
LfC+cug160T+seOgtdKCwCkJUly2gzNc01pdEkwHJlC8r5RxtE06gnkj/3xG
vVnzgYAi1A4toWCuls2aBoJ0MOBCX5OHIUbtqOR8RkeD8IEgRu14i8FJQ1c/
HCBIBCaQL0cehnSPrJhJwA+tQfja0GPPhR1ZcJzi1qD6UTqBfC2yx0n3yBrb
DUxC09pnXnFrrTHZDt5XXIvQ2pi45gdPoNPCKCHb5Z/PqGmtXxKkODT88rph
vVRDpN+ULxY3VuemaRDnC0nIdmMjmDfygUBv1nwgoAi1w+bx/scaLUYzgYCU
11RuU8Jsnw8E+pQuCgFBjNrx1/63W/dpNpIPBOI1lcptzJGFGNvtXEJO6aKQ
NgRHlnOmm3wf/D/YiNaG0iFeU9lvpntkxbQhPzSt9bWhmGyH74NrETaSP4Hw
mur9ZkK2G9vtXELTWr8kSHHZjr/PtXc/q2lt8MWrYIjXVDbstzzw4o+SR9uk
I5g38oFAb9aColuQ2qESwp/V/zUfCNBUQeeoIbXbGDbb5wPBB+qULgCB+EMQ
MWrHNGPtbQf0f80HAmmqIN7XdI+s/LaQumbia0MxRxayFl6rxH/V2lA6oEHw
P+J9xXm4sR5ZY09zk9C01teGINvd48l2yFq4FqG1WhtKB9NaXA68r5SU7RIl
QSc0rfVLghSX7fjpuuG+Of1fCyZw1+idOHhfKeNom3QE80Y+EOjNmg8EFKF2
EM52PfO2vhH5QMB/bdC0uCR2/flAoDWIIBDEqB0vySvvmMXBxPhJPhBAg9C1
iATZS5gE/NAaxFAburkBYTFHFqorqOtCg/DbdMcCNHKgjjtJOLIo47R6CU1r
fW0oVvpGdQVXKrQ2Jq75IbRWJLYL4rJdfkVL01q/JEjx0jfeP9K0Nr8kKLRW
JLa0bDc2gnkjP4/pzZoPBBShdu/Uj5PerOUDAXqFaW6TMNvnA4HWIIJAEKN2
UIFHBxBX9cz8CZReYcJtEj2yxloWdWgNwi/RxxxZyHho/4J6ZsJl4YT0ChNu
k+6RlW9Z1LRWN8lExGQ7ZDwGDqG1we6ssRBaK490QrbLLwlqWhssCcZkO/6b
vNg1rc0vCQqtfbh+pNOy3dgI5o18INCbNR8IKELtpCWU3qzlA4Fs1oRmJ8z2
+UCgNYggEMSoHdNyzo3oP4/9Rf4EQoPQNPuheI8sFABzpA1qahD+A6/fdtfB
26Ufrt2h9xelEzhQHvV0j6z8VzI1rfW1oZhsd7A+9ksewnxtiBStlXuRkO3y
S4Ka1upeJRJB2Q7eV86NmtbmlwSF1sq90L1GW0Qwb+QDgd6s+UBAEWqHTz3z
ygey3ouAQDZr8jBXXzjseMkHAlIaRBAIYtSOP8Vwptd7PhBgKvTDHHNkUYm0
QU0NwteGYts3eF/1ei+dwEFle6i/8BBbYz2y8rUhTWt9bYhqLHZ+CC73t3eO
y3ovmkChtZINErJdfklQ01pfG6KIbCef0rQ2vyQotFYEgvwvHIxg3sgHAr1Z
g+DlMJ8gtYMdaO61jyS1FgGBbNbEtpQw2+cDASkNIggEPtIhmIRs/Mu8dkTk
A4FoEOJ9TfTIyteGqKlB+NpQzJHFuMyToB0R+doQ1RqEeF9jjixEfkVL01pf
G6KIbIeC21vvnxBHROkEDprHM8UcWVRSEtS0NlgSDMp2KLjd/9jrmtbmT6DQ
WtG20rLd2AjmjURedUJv1oJAEKR2IMkvvXFMNmtFQCCbNbGtxhxZVJhXRYMI
AkGQ2oEk825RKxT5QCAahHhfEz2y8rUhUhpEUBuKObIwk/rFonxtiGoNQnSc
dI+sfG1I01pfG6KIbDeayY9OCq3N14ZI0Vp5lyQh2+VXtEjR2mBJMCjbYSb/
8uQbmtaWTuBA2ZPGHm2TjuD7Kfl5TG/WgkAQTEFy4IVs1oqAQDZrUktJmO3z
gYCUBhEEgmAKwg6L/5N+hyt/AkWD2FMbJGKOLCrRhkhpEEFtaJSCmo2vqfa+
6rOh87UhqjUI8b4mGikUaUOa1vraEEVkO3hfea8ksJKvDZGitfC+UpKH51e0
SNHaYEkwKNvJOzgCK4kXr/wQWisUGjz8RB4P9yPIN/LzmN6sBYEgSO1GLaHe
+0Q81XiMM4FANmuSLZna+SkLUQQEokEEgSBI7U7VpiON4CUTONIgxOQQc2TR
uHYWTogGEdSGYo4seF9JIXjpBA5Uj8FgykIUaUNHFK3VTSQkhrLdfa5sB+8r
r0pB8HxtiOoJ1O/3JWS7onYWQmuDJcGgbAfv6+6DbwutLSoJCq2VSvjYo23S
4eeNIiDQm7UgEASp3eg41A9PymatCAhksybQnzDbFwGBaBBBINBbSwkQhgef
WBQNoggIRIOQ3UeiR1a+tEGq8XtQG4o5suB9JSWElU7gQHlfY44symjXqUPT
2mDFLCjbgTB8empZaG2LCdQ5MyHbFbXrFFobLAkGZTsQhr3PHxZaW1QSFFor
OTMh2+WEnzeKgIDUZi0IBMH5BJp/8PEp+fJFQCCbta9XRhOeMNsXAYGc0hUE
giC1E++raBBFQEC1BiElygSpKJI2RIMIakMxRxa8r6QKUzyBmdoQ1RqEeF8T
z1JRRUvTWl8boohsh5v4+ZdfCa0tmkDQ2vNViTIh2+WXBEnR2mBJMCjbyU2U
M5cLJ3BEa8X7mpDtcsLPG0VAQHUrIYoAQZDaIV0c++Rz2awVAYFs1uQnCbN9
ERDIKV1BIAhSO/G+Sg2wCAio1iDE+5rokVWkDYkGEdSG4MhySAjV3ldSb2Xm
a0NUaxDifU30yCqqaGla62tDFHn2kC6++npFiOLWEm0ItFa8r5SU7fIrWqRo
bbAkGJTtZBcsRLHFBA6U9xWynbMTzw8/bxTlMao2a5dXmTYIBEFq90AN3MLJ
i4AAm7UfXXYmUWgzjBNFQCAaRBAIgtROvK+iQZROIDQISRQxRxYVakOiQQS1
oZgjSzogyXGT+doQ1RqEaDe6vupEkTZENa0NakMUke3kOFS5cUXa0EL1DXXJ
LiHb5Ve0SNHaYEkwKNuJ91VuXFFJkGpa+8Gx0RJLH20zNvy8UZTHSG3W9Nv9
EkFqh+NQl774SjZrRUCAzZouaCTM9kVAIBpEEAi2h6ideF9Ha+Thl0snEBqE
FDQSokmRNiQaRFAbijmy4H0ltUaKJnBrNYFS0ECtzHdkUaE2RDWtjRVag+gg
nVpljRRpQ5hAjXqcUYOyXVFJkBStDZYEg+gg3lehtUUlQappraBeQrZzY3lh
zdSa+WbXUj9vlAIBNmsxIAhSuxGsf7Uim7UiIMBmTRfrYo4sKgQC0SCCQBCk
drX3dSijQIMoBYLLqoZUskdL9MgqkjZEgwhqQzFHFryvpErNLSZQb3JjPbKK
tCGqaW1QG6KIbAfvK6lSc4sJ1JvcmGxXWhIUWhssCQZlO/G+Cq0tKglSTWtl
k5uQ7ZqxvH0tJ4mZhXF5oxQIsFmLAUGQ2mGZf/PNt7JZKwICbNYuvO7Muo6Z
7UuBQDSIIBAEqR2qB3OvDacLVf1SIIAGIQbRRI+sImkDGgQTuaA2JD4i51O8
zDdWpBFV/SJtiOoJFO8rxXtk1XiXVdGimtYGtSGKyHbwvpJqj1w0gaC14n2l
uGxXWhIUWhssywRlO/G+Cq0tKglSTWvF+5o+2kbiEGeNNRvWzawdyzdKgQCb
tRgQBKkdP5PnXjosR8hmrQgIqIJF3YIV1M5velkKBPvrw2eDQBCkduJ9pXqX
XQoE0CDE+xpzZFGhNiQaRFAbCj7q4n2lOhUDDvK1IcCiPvrnx5eHe2QVVbSo
prVBbYiq6jf/4/xQMEtobZE2BFqrjweKyXbY9OVXtITWBkuCQdlOvK9Up+Li
CaxorXhfc5b58uHtU1Prj9LKtpk1801jqZ83SoEAm7V3IkAQpHZytJBs1oqA
gKrNmuYDMbN9KRCIBhEEgmChAFnitWr+oUGUAgE0COEDiR5ZRdqQaBBBbSjI
D8X7SjXqQXbJ14agQexRzcGCjiwq1IaoprVBbYgish28r6TMKkXaECZQvK8U
kU2pvCQotDZYEgzKdlo2Ba0tKglSTWvF+5o+2gaxmbPD2k27d29ZMzW9fvPu
oyp1TDWD6upffh7DZg27ch8IgtRO3tyRzVoREHAw2dB8IEjtqBwIRIMIAkGQ
2on3lWoNohQIeJ0y+/rs8xGBTPTIKtKGqNYggk8759iB58g6pRruQYPAbc2f
QMYv3unopBfrkVX6PiZobVAboohsJ95XobVF2hDHT65odI+JyXalJUHQWsyt
XxIMynbifaWa1haVBAnnFCsJEkffBmU7icMLc7Ozs3Oze9dNT2/aPX9SlQF8
voGSeL5xHZs1YLEPBEFqVx2HOiSQslkrAgI/YmZ73lMMIocEBUM0iCAQBKmd
eF+pJsalSBr8zsEeWReolqE5gb8f1Ia+VNRCQryvVBNj3NZ8JA18h0iPLLCs
b/MqWlTTWnA5v5oXlO3E+yq0tkgb8iMm2z3f7IQ/NkBrMbf3P+aWBIOyHVYZ
kBG0tqgk6AfKmPz/GX93ecvM2rH7lLsitYJYYLMGcuUDQRDsOFsKu8BmrRQI
nIiZ7SHBPx2qFQQjePisRJDaifeVanJVCgROxBxZhFpB6CyqWECDCGpDQUeW
eF+pJleYinwk9SPWI0s8DJnhHz6rI/ZuFLyvQmuLtCE/YrLdgebJO2NDHz7r
lwSDsp14X6mmtaUlQSfSR9uMDT9vlAIBABdT6gNBkNrxhf/6phGrBI/tCAQx
s30pEECDwLX4QBCkduJ9pVqDKHJZ+BFzZH3rHcs+NqBBBLWhoCMLQz8y+zbV
9V5MRb425EesRxaTkOmS88IAuPg+PkAEZTvxvuJib3v45SJtyI9RzxxPthtx
ziMZXogqQGtxLT5ABGU78b5SfbGlJUEn0kfbjA0/b9xYeLACNmu89oNAEKR2
/DBL9RvPVUcgCFI7KgcCaBDr73kuCARBaveA2iLh5vLHuwBBzJGF8n7wUMJY
QIMIakNBR5Z+aQXPFaYiXxvyI1aT4R8GD3SOBWgtvo+jDVFEttOnfzKtxWfz
tSE/YrJd/fgFDnQOBmgtloxfEgzKduJ9pZrWdjxQPiHb5YSfN2KmuFhgs/bb
jfuCQBCkdkw2LqllcYZC3oR2BIKY2b4UCFBCx7X4QBCkduJ9pboXCn+8CxDE
FG0UH6QfdU5Ag/j5NeGdgv+ih3hfqS7PYirytSE/Yj2y1qh26zmBW4nv4+8U
grKdeF+porX4bL425EdMttvaPPJ1bIDW4vv4JcGgbCfeV6ppLSNvl5JgTNHO
DD9vXBZ/6S8Y2KzhRDwfCILUruo/MOKu/FDhs12AQKvbOkqBgCoNAt/Hn9Ig
tRPvK9V7Fv54FyCIObKONI+YzwnUEILaEIUcWdr7ij0LpiJfG/Jj2Ho61COL
p0hbI8YGqCN/n6ASOoTgK13ZTryvVNFaXEu+NuRHTLZDSXA5uyQIWovv45cE
g7KdeF+pprX88S4lwfTRNmPDzxs4ujr/N2Czdu6l24NAEKR2fMkiizMU4rNd
gCBmti8FAqo0CHwfHwgWQtRu5H2tCCTSF3+8CxDEPCfOcXI5AQ0iqA1RyJGl
va9IX5iK1toQRRxZhNPHSrQh0Fr+PkGnd1C2Q99X/JlpLa6lizYUkxrlfZPM
3wNai+/jlwSDsp14X6lOX/zxLiXBhGyXE37eYCC4vMQkIK2EgkAQpHZ865lY
4s849rcjEASpHZUDAalTunwgCFI78b5SjRT8TxcgiDn2S7UhqrnQIKQNUciR
pb2v0CAGo/5ILbUhivfIKtWGpOmKr5tQSLZDLRTeV6po7aDZH6lFxGS7iteV
ndGMt1ODm+ugbKcLv6C1A9UfqUUkZLuc8PNGqUlAWgkFgSBI7XQ3SF53g2aH
9hYRM9uXakNUaRD4Pn4WClI78b5Sve74ny5AEHRkUbk2RKpDpq8NUTN7I7T3
FesO/7TWhijiyGqhDUnTFV8bopBst9w0qPC6w8e7aEMx2a5UGyJ1+KyfhYKy
nXhfqaa1g24lQekb0+7jft6IvVAQC2zWYkAQpHYM0PKOJDZrHYHggHrgdbQA
Av+ULokgtfvDvXPStR4FkI5AEHRkUbk2RKrxe/AkAt+Rpb2vVBVABs1GeS0i
WC5roQ0JrQ1WWX3Z7lTzsGmhtV20oZhsV6oNkaK1fkkwKNuJ95UUre1SEkwf
bTM2nH7miYYJsZBWQkEg8Kkdhrj94ZFzABpERyCIme1bAIGc0uUDQfBlTPG+
Uk1IOgJBrEdWqTZEqvF7kI76jiztfaWKkAya/QpaRNCR1UIbElob1IZ82Q6a
BbyvpGhtF20o2JGAyrUhUrTWLwkGZTvxvpKitV1KgjHZLjMcvgEg8MEuHdis
BYHAp3ajTh11qpTNWhcgiJntWwCBnNLlA0GQ2mnvK/5CRyCI9chqoQ1J4/eg
3OY7srT3FX+B/7WLNkQRR1YLbUhobVAb8mU77X0lRWu7aEMx2a5UG6Ka1gZL
gkHZTryvpGhtl5JgTLbLDCdvIKtvLQECqjdrQSDwqd2ox/We0f5dNmtdgCBm
tm8BBHJKlw8EQWqnva+4Fx2BIEb5WmhDc3Xjd18bosqR5RTAtfeVKg2C/7WL
NkQRO1Dpe0OkaG1QG/JlO+19JUVru2hDMdmuVBuimtYGS4JB2U68r6RobZeS
4IlWK13CyRv6oIr8wGYtCAQ+tUPbXvnCslnrAgSgdv7qaAEE0CD0m4MSQWqn
va+iQXQBAoq03m2hDYkGEXxd2ndkPdB8PRAaRBdtiCKtd1toQ1TT2qA2dI/X
Y8Rp2C60tos2FJPtzivUhqimtcGSYFC2095XobVdSoKJo21ywskbqFqXqrrY
rAWBwKd2x05Uq++p0eqTzVoXIIiZ7VsAATSIIBAEqR2TDVl9okF0AQKK9Mhq
oQ2JBvHm+wEu5zuytPeVag2iizZEEUdWC22Ialob1IZ82U57X0nR2i7aEP+2
gSfbtdCGqL6bwZJgULY7/8oz3lehtV1KgjHZLjOcvBHkSGMDm7UgEPjUDpRm
Z723lc1aFyCIfe0WQAANIggEQWqnva9UaxBdgIAiklYLbUg0iGC7e9+Rpb2v
VGsQXbQhijiyWmhDVNPah0OlPF+2095XqmltR20oKNu10IaonupgSTAo22nv
q9DaLiXBmGyXGU7eqIGgLI9hsxYEAp/aQZV4tG4JJZu1LkAQpHbtgACaQhAI
gtROe1+p1iDyu7MGI+gMl0M38kM0iOBxfkNHVvMytfeVag2iizZEkUYKLbQh
qmltUBvyZTvtfaWa1nbUhoKyXQttiGpaq58ciaBsd84lZ26E0NouJUHIdkGs
zwknbxyoG2wW/RJs1oJA4FO7EQ17YUTDsFnrCATO70S0AwLMQBAIgtTOcU9B
g+gCBP7vRLTQhkSD8LUhCjmytPeVag0ivztrMG59MNBIQRpsFv0q0NqgNuRU
dKnpfaWa1nbUhoKyXQttiOoZCJYEfdnO8b5STWu7lAQTR9vkhJM3pPNh0S/B
Zi0IBD61Y3aq9xTYrHUEgiC1awcE0CCCQBAUqZ2T0KFBdAECivTIaqENiQYR
PCHCd2Txnk730oEG0UUbokgjhRbaENW0NqgN+bLd080H7833h8iS3501GEE2
3uK9IaoXWrAk6Mt2y96eArS2S0mwhVNLh5M3aiAoy2PYrAWBwKd2L73ZsLVg
s9YRCILUrh0QYF8cBIIgtdPeV6o1iC5AQJEeWS20Iar2xUFtiEKOLOn7ini4
AvGO2lCwkUILbYhqWhvUhnzZzvG+AsQ7akNB2a6dNgRaG9wm+LKd432lmtbm
d2cNRlC2ywwnb5Q2F0VgsxYEAp/aAdB5+4l/BV/qCARBR1Y7IMCngvPpUzvH
+8rBRKUjEHBcGOqR1UIbwqeC2hCFHFna+0q1BtFRGwo2UmihDcmngtqQL9s5
3lfQ2o7aUFC2a6cNYRUES4K+bOd4X6mmtV1KglRtdm554MV2n3XyRmlzUQRY
ShAIfGqHltSvHjrzlxkQOwIBqJ1jO2kHBGApQSDwqZ3jfaVag+gIBL4jiyrm
sKFQG6p+1eNBbYhCjiztfaVag+ioDQWfqBbakPyqoDb0mLe/dryvoLUdtaGg
bNdOGwKtDZYEfdnO8b5SRWs7lgSp/E00Hc77Ke2AgMkD4+wHIXLuUzs8jYuH
P5Gf8N3MP+IkGEFHVjsg+Ozz03wtweNLyDsD1/G+cux8+hB/vCMQ+I6sb1pp
Qxybtr+i62k6fEeW9r5y8D3iaxGq3y58RxaNiE2ZNkTVk8Pfx2+bQyHZzqmU
fvPNt/zZ1q9/IoKyXTttiJGOv09QuPRlO8f7SsPS0+ulBgM/Yg2dcsLhG6Vd
pseGT+3Qyr609JqOoCOrHRCkw6F2jve1r/AdWe20oXT4jiztfe0rgo0UWmhD
6fBlu9jRGF0iKNuBbMtxe93Dl+0c72tfEZTtMsPJGy1MAunwqR2nzYE6DrWX
CDqy2gFBOhxq53hf+wq/5Vo7bSgdN3kYob2vfUWwYtZCG0qHL9s53tdeIijb
tdOGEuHLdo73ta/gXWpRpx0dTt4obS46Nnxq13t+ppraOVUmi4Ecaud4X/sK
35HVThtKh+/IcryvvUTwVOt22lAifNkOGt/pr9wzC7pEULZrpw0lwpftHO9r
XxE72iYnnLxR2lx0bPjUDg9S/rmWORF0ZPUOBBz/46pHNLVzvK99he/IaqcN
pcN3ZDne117Cd2RRW20oEb5sh1NxOxaanGCS7Mt2pc1Fx4Yv2zne174iKNtl
hpM3SpuLjg2f2mHDK8eh9hJBR1bvQEAetUNWfPKFngmkz/raaUPp8B1ZXTa8
sQj2yGqnDSXCl+0c72svEZTt2mlDifBlO8f72lcEZbvMcPJGaXPRseFTOxyD
WCr1piPoyOodCMijdh0Pr4mF78hqpw2lY/Q2yjdn5sfxvvYSviOr3XtD6fBl
O8f72ksEZbt22lA6HNnu6UgbzI4RO9omJ5y80eIF0nT41G7T9qERKOh8bh2+
gZ8MgIA8aud4X/sK35FloQ35jizH+9pL7D74tuPIstCGfNnO8b72EkHZDofi
9TuQI9s53te+Ina0TU7ovNHRsh4Mn9qBBvQ4BEW+uQUQOPs4x/vaV/iOLAtt
yHFk+d7XXsJ3ZFloQ75s53hfe4lgN7zetSHyZLtHnx26Yd/50O1P2DG6FDN1
3mjXXDQdPrW7eesL50XemOgS/ulCFkDgUDvf+9pL+I4sC23IcWT53tdewndk
WWhDvmzneF97iaBs17s2RJ5s53hf+wpftssPnTfaNRdNh0/teELOv7JnAkkh
s70FEDjUzve+9hLX3+s6srYYaENOgdr3vvYSviPLQhvyZTvH+9pLBGW73rUh
8mS7kSZ1wj23pWN0mSLtM2/XXDQdfi66ZnPZudWZ4Z//ZQEEDrWz8L5SyJFl
oQ05jiwj76vf0QVuhH61Ib/RsYX3NUjIe9eGyJPtLLyv1M2spfmGBRD41O6q
O2YvjLxp1SV8s70FEPz21ga1s/C+UsiRZaENOY6skfe17YEasfAdWRbakC/b
WXhfR1s5JduN3hvquyjkyHYW3leKHG2TGTpvAAj6VRV9anfZbQd+dWPPZQfy
qB3ZAIFD7SzKDhRyZFloQ44j6wMb76vvyLLQhnzZzsL76st2FtoQebKdhfeV
IkfbZIbOG+2ai6bDp3YM2Re1rcYkwqF2RkDgUDsL7yvVbyXrn1hoQ85BTkbe
V/+hstCGfNnOwvvqy3YW2hB5sp2F95VanWYoofNGu+ai6fCp3W82PHnxxv09
DoFwnhMjIHConYX3lUKOrCFJ61sbchxZRt5XeKS1I8uCpEG20+0sLLyv5Ml2
FtoQebKdhfeVIkfbZIbOG+2ai6bDp3YzN7R3tybCoXZGQHBVk9pZeF8p5Miy
0IYcR5aR99V3ZEEb+rRXbciX7Sy8rxw/bMp2FiVB8mQ7C+8rhWS7/NB5o12X
6XT41O6X17V/Cy8RDrUzAgKH2ll4XynUI8tCG3IcWUbeV9+RZaEN+bKdhfeV
PNmuflO152TryHYW3lcKyXb5ofOGhUmAPGr3s6t3X3t3zzIHedTOCAgcamfh
feW42+uRZaENjRxZdbtOI++r78iy0IYc2c7I+0qebGehDZEn21l4XwmyXdqB
uXJky7pp+DQ27Wt0K9J5o11z0bHhUDue+Rvu659AOmUTIyBwqJ2R99Uvm1ho
Q44jy8j7+sZ7nziOLAttaCTb1aY1VNXu6tv7Sp5sZ6ENkSfbWXhfKXK0jY4j
u9dMTW8+vkInF7dNTa09pPQcnTfaNRcdGw6169JFOREOtTMCAqePopH31XFk
GWlDThncyPvqO7IstCFHtnPSSI/hvDBuoQ2RJ9tZeF8pJNs5cXxx377FKiUu
z01NTc+rAobOG703F0U41G7Q96tzCIfaGQGBQ+34Eeq3rSLCcWQZaUOOI8vI
++o7siy0IUe2M/K+kifbGRl4HNnOwvtKIdkuEkc3z0xNb5zV9pGpZlisAk3t
vl4Zyit37Ah32O4STk42AgKH2l1p43196KmGI8tIG4IjS7rBGHlffUeWhTbk
yHZG3lfyZDsLbYg82c7C+0q1bPfV1yk72fKR2bVTU2s2zTp/SfMNixdIqUnt
cGLp3bv7J5BOi2wjIHConZH31XFkGWlDjiPLaMb8l54stCGnF5CR95U82Q5O
zn61IfJkOwvvK2XUM5cP7x5WRGeHtamVlUbm0Hnjor6biyI0tavr3p1OSwmG
Q+2MgGDk3Kup3dD72u2kuWA4jiwjbchxZBl5X31HloU2RE3Zzsj7ysEwoaHf
SFBzZLufX9O/95VCsp0Tu9fpvciaWH2j9+aiCE3tgh2TegmH2hkBgUPtjLyv
jiPLSBtyHFlG3lf/jltoQ9SU7Yy8r+TdcQttiDzZzsj72uWO67zRe3NRhE5H
zL0Hfb+qj3ConREQONTOyPvqGHfnbLQhp9exkffVcWQZaUPUlO2MvK/kyXYW
2hB5CsXQ+2qQabs0/Nd5o/fmoghN7Q5/NCSQjKe9j+JQOyMgcKidkffVcWQZ
aUOOI8vI++o4slDg6l0bopEvaCTbGXlfyZPtLLQh8mQ7I+9r8GibzJC80foE
0rGhqR226nufP5z+SItwqJ0REDjUzsj76jiyjLQhx5FlxNAcK4WRNkRN2c7I
+8pxyZ/2a9nuolue+rdbe9aGqCnb2XlfHdmuKCRvAAj6bS6K0NQOGLe/2xHn
wXConREQONTOyPvqOLKMlA7HkWXkfXUcWUbaEDV32UbeV/JkOwttiJqynZ33
1ZHtikLyhkVzUYSmdv7bkX2FQ+2MgMChdkbeVzz24sgy0oZGjqxadDDyvjqO
LCNtiJqynZH3lTzZzkgb0rKdnfd11O74WJt2x5I3LJqLIjS1e+H1/lsDIZja
6R4FRkDgUDsj76vjyBppQ323e3IcWUbeVzj9xJFlpA1RJdtdeceo1mTkfSVP
tjPShrRsZ+d99Y+2yQ/JG3ZAoKndQa/bZF/hOLKMgEC3GrDzvjqOLKPKg4MU
Rt5Xx5FlV3nQsp2R95WquplkVzttSMt2dt7XLv12JG9YdJlGaGq3v9q56674
fYXjyDICAk3t7LyvjiPLSBtyHFlG3ldqOrKMtCFqynZGFSFqynZ22pCW7ey8
r45sVxTiBjMyCVCT2u2tvupbrb5qOjS1swMCTe3svK8vVzKiVIGMtCHHkWXk
faWmI8tIG6KmbGfkfaWmbGenDWnZzs77CtmuXRVI+IZFc1GEpnZ7Dg5PrDvc
akuVDt1Fyg4INLWz8746jiwjbciphBt5X6npC7JjAvp1Oay7U317X6kp29lp
Q1q2s/O+dlnykjcsmosiNLXb0UH6SYemdnZAsFdROzvvq+PIMtKGHEeWkfeV
mo4sI22ImrLdn206UFFTtrMrCWrZzs776sh2RSF5w6K5KEJTO0bn1ha1dGhq
ZwcEmtrB+6o7S/QVjiPLSBtyBD4j7ys1HVlG2hA1ZTsj7ys1ZTs7bUjLdnbe
V0e2KwrJG0bNRalJ7TAKI13vo2hqZwcEmtq99b6V99X5/kbakNMOyMj7Sk1H
lpE2RE3ZbjjKJSajaNnOThvSIG43SpeeeJI3jF4gpSa1w27ii+WeT6yjM6Ww
IZOxAwJN7ey8r44jy0gbchxZRt5Xar4GbqQNUbMJp5H3lZqy3X4zbUjLdnbe
V/9om/yQvGHRZRqhqV1Oi6F2oamdXYrW1A7e14MG3lftyLLThhxHlpH3lZqO
LCNtiJqynZH3leodEB5gO21Iy3ZdVI90OLJdUUjeMGouSk1qd9tDY1qhtg5N
7eyAQFM7O++rdmTZaUOOI2tg432lpiPLSBuipmxn5H2lpmxnpw1pkcLO++rI
dkUheUNPe7+hqR0jmnPSel+hqZ0dEGhqZ+d95UdRHFnHT1ppQ1Q5sjZWjiw7
7ys1HVlG2hA1ZTsj7ys1ZTs7bUjLdvC+SvO3HsM/2iY/JG8YNRelJrXjHfRP
rjDZ3oLawRliBwSa2tl5X7UzxE4bIuXIsvO+cvyLcoZUrTJN1N7r7z2zN7Hz
vmrZzk4b0nsTu4fZP9omPyRvXGTQZRqhqR2Dws+ubnmUbTo0tbMDAu3Gt/O+
akeWnTZEypEFLwfPm8Uo2pFlpA1Rc6Nt533VsqOdNqRlOzvva5dHS3zmDARG
th9N7dbdOfvL6/o/sY6a1M4OCDS1s/O+akeWnTZEypFl532lpiPLSBuipmxn
533Vsp2dNqRlOzvvqyPbFYXwDQYFiyaB1KR2PIoREGhqxzfUSIbT1A6OEQsg
OPXFaXFkAXosZDhSjiz08LF4CYKUIwuOkTsNWtBw/PHBF0W2Y1Zj0QCcmrLd
Zbc/bXH8IjVlO3hRvl7p38MG2e6R2bdbfFb3FzUKTe2YSd6gzm7rMfSLlsPs
pJpA9hia2iE7WSjX2pFVZ6f+HbakHFmm2UlKZ8hO7QBubIhsZ5qdtGxnl520
bGeXnbq03FmFvCHUDtt2ixdIqUntfnz5TiML0zuK2tllJ+3IsstOpBxZptlJ
HFmm2UlkO1PutPPpkWxnmp20bGeXnbRsVxqrkDeE2kEvbqf7jA2hdqbZSVO7
ijuZZCftyLLLTqQcWabZSRxZptlJZDvT7CSyHZinUXYS2c40O3Upaq1C3hBq
B8nDQoAgRe1Ms5NQO9PspB1ZdtyJ1BtzptlJrEGm2UlkO9PsJLKdaXYS2c40
O3V5bXwV8oZQO9zZz+PnynUJULu51z4yzU5C7XBnjbIT1Y4s0+xEypFlmp2u
vftZOLJMsxNkO366htnp8p1G2Ulkuy2W2UlkO9Ps5DRSKIpVyBtC7Rh3jMwb
pKidaXb6+MSI2plmJ6odWdbZCY4s6+wkjizT7CSynWl2EtnONDuJbGeanbRs
VxqrkDeE2jErXnvbgfEfaBVC7Uyzk1A7WESMshPVjizr7ARHFqbO4sVeBBxZ
1tlpJNt99qVpdhLZ7iLL7CSynWl2chopFMUq5A1QO6Ze/3DJ9j9tM3lzihS1
M81OQu1MsxPHTypHlnV2Gvoqb37SOjvBkWWdnSDboaueXXYS2c40O4lsZ5qd
RrJdq6LrKuQNUDs0T/7r/v676iFA7R577l3T7CTU7p/+YJidqHZkWWcnOLKs
sxMcWdbZCbIdHjO77ATZDqPYZSdppGCanZxGCkUhPvPev5UEqB3KDnOv9f/W
OQLUDqPYZSe8/3XHjldMsxPVjizr7ARHlnV2giPLOjtBtsMDYJed0NoFo9hl
J8h2GMUuO33b4UjoVeAboHbr7pwdqioftzlULidA7TCKXXYCtcModtmJKkfW
FZuesc5OcGRZZyc4snjSTLMTZDvcGrvsBNkOo9hlJ8h2GMUuO5FqpFAaq5A3
QO1+ce2jRjZ7BKgdj2KanUDtMIpdduK48LrHMIppdrrqztkLfr/HOjvBkcWX
Y5qdINvxKKbZCbIdbo1ddoJsh1HsshM1j7YpilXIG6B2/I+RzR4Basf/mGYn
UDv8Y5edqOpTgVF49uxG4R0KRjHNTtih8D+m2Qn1E/7HNDuhusv/mGYnNGvC
P3bZiZpH2xTFKuQNUDv+x8hmjwC1s85OHOfYZyeqHFmrkJ2uvfvZVchOcGRZ
ZyfIdtbZ6W/vHF+F7ATZzjo7US3btfjgKuQNUDtUxuxGAbWzzk5UUbtVyE7/
suHJVchO1987twrZCY4s6+wE2c46O0G2s85OkO2ssxM1j7YpilXIG0LtjGz2
CNiKrLMTVdRuFbLTRbc8tQrZ6cb7n1+F7ARHlnV2gmxnnZ0g21lnJ8h21tmJ
OrRfW4W8IdTOyGaPEGpnmp2oonarkJ1+e+u+VchON299YRWy04NPLK5CdoJs
Z52dINtZZyfIdtbZiZpH2xTFKuQNoXYWrbEkmNrxtVTZqf+jsXWcf9Ujq5Cd
cC3W2emPD764CtkJ12KdnSDbWWen945+hssxzU6Q7ayzE1W3Ro62Kf2g9UeY
2vFHmN6bjsLUDje0KDu1u/zS7NR6lKLs1HqUouzUepSi7NRiFF5iaJNb9KnS
gY58fIo/UpqdSkf59ttvW2SndremXXv5VcgbTO34I6VtRUtHYWq3CtmJ6lUw
yU6lo1hnpxcXj/KnSrlT6UAfHV9aheyEj1hnJ3ykXel1FfIGqF2pzb50FJ7h
VchO+MgkO7UYxTo7vfzmMf5U6c6udKCPT3yxCtkJH1md7JRu/D41iUlMYhJ5
YZGjJjGJSXw/Yuvexa3/p/YJnMQkJvE9i0nemMQkJlEak7wxiUlMYhKTmMQk
JpGIlaNz66ZRAF677/Dw6L3D+zbi3zfuO/xdf7tWsbywZmrN/FL1x8P71lTX
smbjvuXv+nuVxvH5bbgzazZVX3758KaZ6t9nNh4+2y7m5OLu0Xdfv/149ZOz
9DFbWtw2Nb0Z56B7T9fyvo2jH+ytltL3N1Z2r+FpmF8hWty2dmpm+/LJuZmp
6X1HlpeP7Juempk/+65+efva4eO5MPzmJzdPT23Yd4SWj/Azummh/1PvDWN5
kRfatsUl/gM/i9sOL89vmpnewM8nP5zT05vaNND+7mJpy/TU+r1HiI5sGN6I
JTo7H7Mjc5ur3Lel+r7u03VyfhNnwSPLdIRTYp1bvqexsrhv78JxThu0ND+8
pccW+No3A6v5Xm+aP8uu/hBnjTUb1s2sHT6KS/P8TC5USLC4eYYv5rv+dgWx
xDdi3e6jRw/NzS8cOnx0aWVpM1bcMKPwH8+ux3Jpy8zUhtmjzKF4rfESWzob
H7PlhXUz67dtXss5YfjNvadrYVOdz1cWOCueLcmwS6wcn2NQ2zh7lG/ozIZR
E5L5jWs2nhU3tI7lw9unptYfpZVtM2vml4d3ds30RrDik/MbZzaeVXljcUvF
6jdt3sB3Zu38yZObZ2ZmcTeW5mbONjhb3DYk8DPDfdca5n1n72O2cmjzKON5
T9fCpjUbZkc/2DS9Zu77njfAvjbNMo3kydg0vWH0ct/chpmz6Ibydx9extpN
u3dv4b3X+s27j34yPzNV39nqYr7jL1gSSwt8NRvx6O1bN7Vx/v1N03XeODk7
M73pLLoxgGY8Sot8czbOn72P2dLimbzhPF28kazzxvGNUzPf77xxeO96xoHZ
I8OLXFlZoaN7ee0tLg8T69qpqe1nUwFu5fDC3Ozs7Nzs3nVMGHfPn1w5wte2
7dDysOixZmrN9kPf9TcsiJUj20c3gsFruEP5hLPHmm3DS6j2YtvPohvDDJ95
O5YU541pTuBn7WNW5XPssNyn6+i+9VMz25ZHvHftoZXv+rvaxcqhddpSP7OF
8/7CttHP1m45u4pvEstbZtbOV0/iyYVto0tbu+34d/21SmNx+/rRbdmwt6ry
LtQ3a93Zg8+jWNy9YfTdp9cvnByuqLP0MVvm/SPqG4Gn6+S2WpvcsnDWPW49
xMry0tLy9yVdVhfzXX+JtuHeiJWlpaWz9cYMb8SS+4Oz/THznq7vwTVNYhKT
mMQkJjGJSUxiEpP4fsf/Bg5S6A8=
              "], {{0, 233}, {360, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 233}, 
            PlotRange -> {{0, 360}, {0, 233}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5c3b77f5-e90a-4173-8e32-77ab7920c346"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"efcfe610-6409-4f6c-94f7-a3cc09805e8b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"670363e6-bb59-4abc-a6cc-e14586c77ede"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ab6d202c-5cde-4874-a132-611bf2cc2ba1"],

Cell["\<\
Make a table of the first 10 powers of \[Pi], rounded to integers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"a359a1ab-9c7f-49ad-bd3a-c1455d6142a4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a7d6eaf5-5aff-495b-b316-f73b6797c6e3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWrHLrUYWN9kmZSBVyv0D1npbyzS5kLDdbRL2GdK8yEsg2AohCNu4lZ2V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            "], {{0, 19}, {281, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{281, 19},
          PlotRange->{{0, 281}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{285, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5f77bc4c-4dc5-4da1-81ca-1ae7fd2a066a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWrHLrUYWN9kmZSBVyv0D1npbyzS5kLDdbRL2GdK8yEsg2AohCNu4lZ2V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              "], {{0, 19}, {281, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {281, 19}, 
            PlotRange -> {{0, 281}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aba300bc-900d-437a-9e35-74463d0680e0"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"95f832b3-6fa6-4139-875d-b82130f7f33e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ae3a07ee-f21a-47f3-8f63-1b07fcdef09d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dc3fafb3-dcb1-4542-b11a-261fced41de3"],

Cell[TextData[{
 "Make a graph by connecting ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"2812fa23-467d-46c9-bced-7e1fd07a393b"],
 " with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Mod",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", "100"}], "]"}]], "InlineCode",
  ExpressionUUID->"8ea5175b-21e0-4456-af46-46dda97ac17f"],
 " for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"bf3dcefc-ac3f-4056-a164-8d47867cc4d0"],
 " from 0 to 99."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"b8e2b4ca-174d-42b1-976c-4651ca7cf35a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8d84dddd-cf7d-4145-96c6-3e836b69f940"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvfd3W9fZ55u595f5cf6F+8O9a927ZiaZN7Hj16oUJTlZMzfvJJnkdWI7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            "], {{0, 365}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 365},
          PlotRange->{{0, 360}, {0, 365}}]], "ExerciseOutput",
         ImageSize->{364, 365},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "71b42de0-b182-4cf5-bb67-4d11baab353e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvfd3W9fZ55u595f5cf6F+8O9a927ZiaZN7Hj16oUJTlZMzfvJJnkdWI7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              "], {{0, 365}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 365}, 
            PlotRange -> {{0, 360}, {0, 365}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e767c108-e53b-4e0b-b26a-b291bfd445ed"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0e268abc-e6e6-4818-9e06-4e14585f0e3e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6e616ebc-00fa-4b5c-a455-d03076a83fcd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"de60bf05-0e5f-4f5c-997c-824fd564a615"],

Cell["\<\
Generate graphics of 50 circles with random real coordinates 0 to 10, random \
real radii from 0 to 2, and random colors.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"51582849-574b-4270-aa70-15e50f57ad7d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"23999dec-e1d8-4a3f-82c8-1b6632f0a573"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvXd8W0eWJjrv7f523r5/dmem501vv+7t7ZmddnfPtN2v29M5uNvu4HaS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            "], {{0, 369}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 369},
          PlotRange->{{0, 360}, {0, 369}}]], "ExerciseOutput",
         ImageSize->{240, 246},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fbf68633-6a52-46ef-80e6-c7a53eacb8eb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvXd8W0eWJjrv7f523r5/dmem501vv+7t7ZmddnfPtN2v29M5uNvu4HaS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              "], {{0, 369}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 369}, 
            PlotRange -> {{0, 360}, {0, 369}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"70b1cfc7-b38f-4363-bb32-67ba25b7ef4d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fc085a18-6fae-45ae-9974-e8781450652c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2aefeb57-0b71-47c8-9c72-d3044b95098d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0daebb29-9564-4f0e-8714-cb6e1fed53c6"],

Cell[TextData[{
 " Make a plot of the ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"d67ada5a-c9aa-400b-8a37-f80dcebe841f"],
 "th prime divided by ",
 Cell[BoxData[
  RowBox[{"n", "*", "log", 
   RowBox[{"(", "n", ")"}]}]], "InlineCode",ExpressionUUID->
  "bdf22eae-adf1-482d-aa5d-5387547ea7d8"],
 ", for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"ee38ca49-4c88-49dc-9968-edf6538c652b"],
 " from 2 to 1000."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"ebadb4fb-db6a-4b05-a1de-3ee4ebbbc914"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9e476ef0-42f3-4c8f-b967-30249218c7df"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnSuv88gdxt+2pLBfod+itLB0q9JKXXWnKnGl3cpVgUEls6CgkKAQoxBL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            "], {{0, 195}, {312, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{312, 195},
          PlotRange->{{0, 312}, {0, 195}}]], "ExerciseOutput",
         ImageSize->{316, 195},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "fd23e9c6-9572-4565-9161-fc30975fed60"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnSuv88gdxt+2pLBfod+itLB0q9JKXXWnKnGl3cpVgUEls6CgkKAQoxBL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              "], {{0, 195}, {312, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {312, 195}, 
            PlotRange -> {{0, 312}, {0, 195}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6a1a7e17-1406-4aee-a107-e8acbb113279"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9cef1c6f-9e85-4dcc-808b-291905ffcb72"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a182aa6a-47a7-4ca1-a711-141d57a057e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6779772a-828d-421c-9b24-60ff44c93b85"],

Cell["\<\
Make a line plot of the differences between successive primes up to 100.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"55d2e452-8d33-4737-bc76-0be3b351a7d2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8a284f5f-310e-47c7-9972-5e990c63bd07"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztfd17FNX25pmZm7mcf2H+g9/l3M7l3P7mmdviHMBWPBrPwWM8ivEcMBH5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            "], {{0, 195}, {304, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{304, 195},
          PlotRange->{{0, 304}, {0, 195}}]], "ExerciseOutput",
         ImageSize->{304, 195},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7274f31d-b7a9-40d7-8cc1-094ac843388d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztfd17FNX25pmZm7mcf2H+g9/l3M7l3P7mmdviHMBWPBrPwWM8ivEcMBH5
FOQjCFE0AkEhiEESIAECxGCAgOEjwQARAoTPADEBGw3UrKq392L13lXV1d3V
SUPv94k+SVNdXV2119rr411r/c+Zb/xn6r/+6U9/evO/0//+8y9v/++5c//y
zv/9H/TH/6t6c87LVS/N/j9V/3jp5Zfm/q+Z/41ePEL//cd/+dOfvN/d2Egp
xH+LhYVFiWAl0cKifGDl0cKifGDl0cKifGDl0cKifGDl0cKifGDl0cKifGDl
0cKifGDl0cKifGD5ABYW5QMriRYWBWNT27mN359J8IRWHi0sCsY/1xyau+JA
gie08mhhUTDeWtVZtawjwRNaebSwKBhzVx54dfG+BE9o5dHComC8sXx/auGe
BE9o5dHComC8trR9Zm1bgie08mhhUTDmLN43Y/7uBE9o5dHComCkFu515u/+
Y/JJYie08mhhUShm1bWRPKYf/5HUCS0/x8KiYPx5QSvJ4/ijx0md0EqihUXB
IOeR5PH+eDqpE1p5tLAoDJNPnji+PN598Cipc1p5tLAoDI9/n4Q83rg7kdQ5
rTxaWBSGR+nfIY9Xb/2a1DmtPFpYFIbxR48hj5dHHiR1TiuPFhaF4cF4GvJ4
4eq9pM5p5dHCojCMjj2CPA5cHk3qnFYeLSwKw+17DyGPZy7eTuqclg9gYVEY
btydgDye+vlWUue0kmhhURiu3f4V8ni8/0ZS57TyaGFRGK7cGIM8Hj1zPalz
Wnm0sCgMQ9fvQx6P/HQ1qXNaebSwKAwXrt6DPB7svZLUOa08WlgUhvOXRyGP
7cd+iXP8xGBLqqppTP1epUKpzf1jfIyVRwuLwnBu6A7kse3oUM6DR3qbPNmr
bgbVtb+purqxZ3R0dGRkZHRikg+z8mhhURhOX7gNedx15GKOQ9P9S6pXtjTV
0v7oy2O6pSZV29zZ09XVP5LFRbfyaGFRGE79fAvy+G3nYJzjJ4doi/TlcXKk
PpWqWtnU3tpEVuvKrhE+JiVQquu2sHgRcWLgBuRx2/7zcY6fGFTySBKZztio
Y70NqZpWrme2YmhhURh6zo1AHpv29cc5fqJfyWO6vzqV6vFJr70NVamGPj7G
yqOFRWHoPn0N8vhV29k4x6cHm5X/6A62k8Wa8kKsNY3DotuHlUcLi8Jw5Ker
kMcCR1xNpicm9MY7Vh4tLApD58lhyOOGnX25j44HK48WFoVh//HLkMf65lNJ
ndPKo4VFYdjX8wvkcdU3vUmd08qjhUVhaDs6BHn8uOl4Uue08mhhURi+77oI
eVyyqSepc1p5tLAoDN8dvkDC+JcPWhd+eTSpc1YsOWdsIr3/xJXrt8en+0LK
AheG73Ucu/woHToX5u6DR3S7bo4m1vj3BcCOgz+TPL7y0d4PPu9O6pwVKInA
z1e8Yhlyyaf7QsoCja1n/T7bodoJ3LCuvmtTeVVljm37z9M9eWP5/n9t6Erq
nBUrjyiW2f3Dpem+kLLA2uZTdDeu3BwLO+DHs9fpANoip/Kqyhxb2wfonlSv
7pxXfzipc1asPP406JHzdx6Kxcx/4bF4Uw/djUvX7ocdAC5KnEK/ysHmPefo
ntR8euTt1Z1JnbNi5fF4/434zPwXHu+vP0J343x4X1/aGemA7w5fmMqrKnPA
yK/d2D135YGkzlmx8ggy8Ja9sZj5LzzmrjhAd+PspTthB+z5cciqLw0bvz9D
92TRVz1vLO9I6pwVK4+HTnnkwy93x2Lmv/BILdzj9/W9GXYAcm2brfoSaPiu
b8b83Su2nvjrkvakzlmx8tjhkw8/azk93Rcy/fhjMjNXtOfcSNgx33YOFl7I
8ILi029/mlnbtnrbydTCvUmds2LlEWSndTsSYwI/v7iv5jT9cDo0nfFNhxfb
pxU4lRdW5li7/eRLH+6hJTSrti2pc1YsH2DXkYvJMoGfX1y9lel733lyOOwY
slS927XN3q5noLvxyqK9ZGLNWLA7qXNWoCQCIFcsT44J/Pxi4Je7OfuIfrHb
i10s22Jv1zPAc8SdmXzyJJFzVqw8fu0ncxd9lRgT+PkFUj9eerE7lB2x4bs+
OmDhlz9O5YWVOZZtOVa1rGOTn4VM/z6Z+w0xULHyiNtYuzEx5uHzi4O9VyCP
EenFep/AM7/hh6m8sDLH4q96/r5iPxT7xKPfEzlnxcojkkf/To55+PwCrjT9
NB/8OeyYT77ppQPmrUuMGPYCgKyFf3xycPsBz/F5MK53wikMFSuP63f+5C2w
5JiHzy+2+LEa+tnaPhB2DNlmdMBbqw5O4XWVO8i4ent1585DXtXV3QePEjln
xcrj2u0n/QWWGPPw+QVUU3Tfwo8af0Qtw1ReWJmDrPd36w/v/uES3ZmkKtEq
Vh5Xfn2CbiPZ/9N9IdOP5U3H5yze56X7d4WyIz74vJsOmLNo31ReWJnj/fVH
aj49Aibhtdu/JnLOipXHpZs9A+y1pYkxnZ5fLPjsh3+uOTRjQVS6//31XXS7
ZtUllvh+AUDe9L8butBl7vKN0FK1vFCxfICFXx6l2/jyR4kxnQrD8M2xrzsG
+CepNFZeqF7dWbexe3adR/0KO+adtYdg0z59+nQqr62cQUqMzIZDfhfWi1dD
S9XyQgVKIjD/sx/oNs5MjulUGLr6Mj3n8TP+6PHUXwMZq2S9ky26YuuJsGP+
8clBXGFSibZpB2lCMgx+PHs9/lt6B27Wbuy+eitjmr616uCHXxzFE4woVcsL
FSuPZPljgU3vZaDH9dlLd9D8YXQsmTBdfNB+N8Pn1Vct64jok/a3j/dnNMbD
adAYpQDdc/o6O8JTPCbaur3QzbmhTFXa3BUHFn3Vg6k6EaVqeaFi5ZGMDSyw
3/+YToXffuwXNMrAs47oYFMi0I5Mn/t1+8CbKw9E9En765J23K6kAvvTjpPn
b9LXaWzNo+Buh1/k8tPgLfz5xvL9Szcfo01TvlgkKlYe2QB7+FsyzIrC0KrE
EGGBKwmFBeLjxt0J9BF6e00n2fBhh6UW7sXtmnqNUSL8eNbb19ZuD3WZTSBR
e7z/Bv58bWn7x03H0fjlxMCNRK6qYuXxjeUdWGBjxoyhqQR6eNKmgwY1F4bv
TfEFXLh6jz730Knh9z49Qj9hh/3lg1bcrqQCidOOw6e8G744HwLz57tO01u6
z2RcTvK4P/mmF43R8vJDI1Cx8oiM27QbYMy2StYNiQ8M3e49f3O+n/UIPIZ8
TC/ZUds2LRqjROg45hkk768PVUEm0IWPBBl/phbuWbP9JBqHJtUJs2Ll8aUP
95SDAda0rx82M+QiomNGiYB9mRbVh18cfTOkL9PjPybpmNeXdUyLxigR4Cnk
RQhZ3nSc3kKeBf6cVde2bsepS9fuR5eO5oWKlcc/L8gYYMPhTUenAF+1nUVM
SZk9oR0zSgTEka7fGV+yqadqWXBfponffqdjkIKceo1RIuw85AVnSC3Hfwup
LHrLHtX0kpbQhp195PLTi7TbJnJVlSmPT3wDDD5RRNPRKQBcEjII4cfRbjXF
F4A8CznRK7aeIBs+8Bg09ABlbuo1RomADiT088dkXA4GumLuOnIRf9Lv9Piu
3x6XQlokKpOfk/7dM8AQw08qk1sY0BOJfsmo2ePJqNn42OgrhCdPnq7ednJ2
yGZx5/4jx++lIL2n5x2b2s5BHu//+lvMt7y1qtNLWXZ6PbTRBOzL3Wdv3Xvo
CWnXxUSuqtIkEUDS7a1VB6fdISIpAGcPeYeICv0SYdU3XhMY19cMZIAFHjNy
x9sC6IBp0RglAiwT+mG+TU5U+R701x1eVdpjX6Vv2nNudMxTVkk1uq9Mebz3
629+bK1r2h2ij7ceR/dO9VinugE4+UT/+OSgqzbKQHoq9m50VGidco1RIqzb
cQry2P/L3ZhvQZdaug/0+6O051M37esnU59+2X4gmU7RlSmPt30bAzV9EU1H
pwCLN/X87WMvxIcte+obgL9b7xUpuCqylH4cMHLuoh9CRAvWqdcYJQIK7ujn
WLwFAGIhHf+F34R2/KH3vMgJffhbRjATuarKlEf44OhBEdF0dApA2xNqotn+
meILIBts6eZjrprWFEhoH7icmc2HFTjFV1gioOCOfg7EG9r12+M/cPyGnX2u
inE1H/w58+Dacj+4icGWVFUTovnp4a4aP25T09Al+SiVKY+XRx54N9bvmZZU
5qgwoMbcVTn3z8MrgkuEmbVtaArd7DfAvBcU3Dh98TZS3tOiMUqEui+OIsDe
ciTWjn/f93GYYsf+xZMnT3nTjMBIb5MnftXNfh+BsaaqVH3XiJseaUilGvuf
ZdwqUx6RXECP34imo1OA99Yd5mmes+vaprhfetrX+Zt9EaNlSb/fuvfQPAzU
a3K0p0VjlAj/3tD19xVe0UrMmUoIuNEPGbqucnmQ+5ixwNPtUW9O9y+pXtnS
VEv7oyePE31Vqep+f18cbKpONT57b2XKY7/fARgO0fQGKN5e3ck9J+cs9viQ
U/npdx94Sh5tHjPEgKAB7uDynRu6M2vKNUbp8M7aQySStEXGHILwi29T0Q/M
+xt3x3nxxLwtk0O0RWbksaaqAWm2sb6G6oZKl8e+C54Bhs4n0zvTcO7KAx81
ZpoM/+3j/XjWUwasMRDAwOckS948DJbqz1dGwaCeyissHf7xiVdN/PrS9phN
17mLO5pCY8jC3h9/od9f+WhvnEkKE4PP5LE6peSxt16TxwqkBJwYuAEyjB+p
Dq1IJR+hyD63E7/9TieJ6HHx+rIOXg9vreqkFRL/5GMT6SLJ8Gd8xxARZlRG
kyVvHoaGyUPXH6DiDy8+GE+Xunr6ydOntOxliOm3x3/Qh8Zn1ETgdT+QRbtk
RJWZBMx18JToz8uCv/HXJe0fb80t1BP9Sh7dkZWpVMsQGazp1ppUTeszbk9F
iSHjx7PXHb9mLSJS/btPos6rPs4Eks4RNfWvLNrLM33eW5dJPcQELYwiG76h
BhCMiB/8AbWByThEVkk00KECL9K2Xur2VjdHJzSPFa2bE6E4vvzRXtrr6zZ2
x+z52X3mOuQRJSFD170cEGkqVxUm5zxDerA54z+SLu1vyeyCtS2SH1aZ8oid
EV5kWNNRkKjj6L0IIOkcsYvJGA4p6nfz6c9c8+mRGfN3PymiwRRqAFFCdcx3
EsmSNw/jFqNeRzUVfXrP//SCPzoOUOorXTMEgQeSoDiS50hn9hoHhbB2NRzw
J7bPrG2jLZX+pJvG7EEyfQuZbDKZnjBqbytTHvf79xbeU1jAEByevOpVTSDp
HFHSRUu6QYXmaMcBVSYm3l7dGb355kSHaEqQKYQcCGAroQU3GYqcnXFVR53H
pWxvBQcf8UwA5WmBSiMvILu0cddpb1pcPJ2GeNcbyzvwjJCTRfL67TWdMGKL
R2XKI7nhiCWSugsLr8FYKvI+I+kcVlPPnGT8ubzpeFjFUyAQri+mfrNVNO1B
f6fAOvftB7xSiF8fPsbECrw42y8gLWlDvC/8GSvSFMRwN+6YUTCQ3N+059zX
HQMxdRqa55BPgSbtsj7uPWE2FInKlMfvuzw35Pa9h+REhDUdHb455uRZP26i
zq+YC6upx6rg/Nfqbb2v5NMPFvUpg0UU7KMGEGEZ1LkHFnxhV6KrXbYlozHg
XDslbogHQmOdiHFt2NmXCKUKpNNt+8/DFI+j09A8hy7pVd++Pe2H6KEZSBiT
mjRUmfKIzCNZpBGRMZA2yRQp5oPoSTnhJSS/PszirK7f+VNe/WDR4uDk+cL5
8KgBxO6AAEUgeayx1aO20m6+SmmMe4qsUtLuCrQTOdkzyEh5chSlGKCCjOzw
Q6eGIxSmBEJzdAEoYUa4FTefjKgi1wmjMuURRbhka5ETtDik6SiiPXNXBLew
iAnU1IeJjFaqA/MsfgNwtDgopiARNYDwAWEPIKGmAU6W69dk/eUDrybrin+w
U8qGeKhRdfy+BPzix34NZuBF5gUQmMkl7FXUo5xvWbv9ZGrhHtKZuAMYYgtP
ljbNsFYn+aIy5RFMOXriESk/BPdQDFUw0FUyrKYeLiqZTPgTFlFghYUJ+J5O
cfwi6HxEM7jxo3nYuh2nZvupDQzNpOPPDWWS46Vrb4UEH/3IGBcsWK7QLxhM
hBgcjtuWgbz715d18B2Q/cfIw01q8lcFkgFcFRZ48uTpu/WHw2b+Iv6fV38V
E+gBFbaFSY6Hq8ImMftPIh3jFFdwQYLGOURw5wLraj0z1a9Zhh4jRxKr0RHN
uhMHcqOzatteFzEu9AyJmBsbE+wso9Q6jk5DJQ5PJ+/207UDfrqWi1iLR6VJ
ItDwXR9q4f+1oeu9EE8cJDEYJwXj5Y+8NsJhNfVD1x9Ilw2M7piUGy43IGOy
4Mv75JteZhRwiMM87GN/a3BFsx0kjGJaeoUBsab313fJmUfv+VMeii82PK2I
Sb+qMsacb3l//RH64enkSGEjmLZ6W29Sg5kqUx7rm09h4/NG3IZ44gfUkiuG
nYWKnjD1qxlLe4566bbrd2JFSGDraum5fCENLRS8BxY7LP6qZ67vH6F78537
j/CLU8pqbtq7UQsmVSJSrpwhKhho8n/q51uolopTtALXZodPSCBlCA4hmELS
zCgSlSmP3r7gR63JH5kb4olDOpwiBgog6eyE19Rrra0PKJZCnJMPq4hKXT6U
Vw1cDe0ayVCJOn8wtys0xuY9mWZQpWuI9+8NXe+sPaTFuEBCQEVwMQD5DcY2
meJxSPJkIZALCcLe7XsP5dhHMrdmLEiGqlSZ8rhsy/E3lnfgl9dDUvCwHp18
+o9p4IryMHMIISOmxHAZRZyTIx2jhR/zhZY4cwRZKOuwhoxVz7wm9LaKMMWL
B1mAtPWzx4oXX/W7yq8pjlRMOCTI85KUG4HUwj1rt59kjcScXlcFxmmrLfKq
3EqVR2amcXc1E4iuOCElunEAj8wJr6lHzPy0Yn8hgnTmYiwyWL8q/wnTJ3Gg
VTfMqg2u4yOZRdSLNcayLZlmFyVqiIdb93XHgBbjAimI/Nkizw9puuK3wqav
llOncfeGDrUtgj434jsXMm1UJCpTHj/4vBuPgBzJ2SGWP7IPTj79ADUg6Rzh
nsBq4pKKzHYZL7+Pg2kTKSbipBGhvTq+IMvNG6Ds7yA9SmPQGkaoqkTtrc77
7NDDp66yx4rXySx0fJJMkedXtByv2IJ0S06dxkyqDH/g6r1dPsULuhqthyaS
GJRWmfL4/vquGn+Wk2f5hxQpwAhxiqjuQdLZya5QkOCHiz+x5R09E2tSEjZT
8A0epWOlLE3I6kvvz6Xty4O2nr+vyLAm2MAmGw8fXaKGeCjGHBy+l7EP/a4F
TNIrnrwNMuromOeJMMkhAohm07ugQgd+ucuDydw8E1XRqEx5fLf+8ALfTvty
99mwCCq7SAOx+3Nq4A4PYeGCDhETcJVLSEIa5+QwHZds6vHCC/cLtKi1wnaS
u0VB9Swkp2AVggZAGmPOon346BK1twJjdvzhYxnjmniUSblGzMWLia9FMz3E
pn6LpGGgOwfZqOxicKDVzaYBF4nKlEdS77DTtHCBxOptvXj6BY++RdLZya5Q
kNASHAiZxuyvhYX6WYtHsBm6Hiska0LrHlMtmvlIvKJY9xevZopwUSbm+CVL
hX10NEj8kRiVMS4mzSLYWwzAyH3sj8bWTOJAcKaYLQSkYn/1qb8oT7g5OlHk
VbkvCj+HbixpvPjMau5UI++qBjLk8PQLru5B0pl+wsJ3HDzHnxp9LhqQZRDj
T8cLAWnAUCHZqHBefXDd0CxVlQbaKraGbzrOh8V/ALoqUnf3x3NbcWcv3aEH
Ie09L9DkR5BgluMLcsoVHaSjMXB5lM4Z2L7S9f0UR/kpCBpLnUZytz87bgxX
goxVVZU2woMCXdarQa3A8sXzLokAiGfxw+B/XdKONHqEpQGqpFPEqE0knZ3s
CgUJafO4ykn5tjPWJAikY+CBdsdzOTUgRrFZEAC89EdQgwIOSUEisJhbuy/R
FhYY/wHQ3jaOdQEarUz08AOSKSEmscchp6HdelhlzVoRx5PMcGDuigMaHxXV
HPR/JtptVsQ5N7usu0i8GPKIWxo/7JZauBeNcSIsjfmf/YCnX3B1D3dcCevC
gWJYbpkFSipt9HFOjhgC1PW+nl8KuDxz8ERgMxnwBNDVhHsmYE2+sbwjom8M
uKZxBrGhSpQDy0+fPv3zglbwAHljcpW1TD9hc7gk4N6GMflXbD3xqmrTgcZx
sqYytXCPxrfhMA4brlyD5qro08Ukuvq8GPKIzSK+m09+0/qdngGGRgGBGY33
1h1GtmvPjwWO9kPSmU4S1oVjk9CxbvbKzwmkY0CH3lEQvxrpGNnukgTNnBfM
g2NcFVF5e00nNovoTDrKpXM27nYV654DWVIvQQYP+T3kEU2i+xmHDPPmygNO
OF2Bx6a4BqufC2dkPpHDSnzwRlEakxeRIxovhjyScMV0K1zuneKvkwOG78Cg
nQLsrIKre5B0ppOEpbe4eIdfmRGbH450DGxO0tUFXJ45SHR50/HXluqmoNpG
PZFHxgF10BeG782rD22Ix+UnORs9PUpnWEzsOEs/GjEuGACwXfFQfv8jKvlO
/zojkqlYu7G7WgWF4CZwzQgGc2hejGpsMsHXtkFw5GSbviLxYsgjbMs4Zozr
B38cFaiXLH0N5EGgmiCiQWs0kHSmk4R14diws0/LfNFSr2+O1QCcC2PpWxfW
lDJTAygaAqwKahgie5i7vi/pqM4Asr2VBrYtcxYGwgKUhnom7+PviVI2wUbA
Q4nui3vt9q84Z9iYm/fXH2FrSiPuYgd0srseIV9Jkssl5J9++9Ms1cwBjUML
jsNLvBjyOMenNeZUm4A0h9CINbCIj86JkE7M+Q4m8BDpJGHpZpIjrb6S4xg5
wTU+XrK+oCZ4CE3IaJVXp2A0DEGdMpeowIZ3/OTgwi+PhpniMOHAGUhHEsnY
y2bDQMZw7qlEPJ8TDyUscAognuCEMzH+uebQAkEUJIeR2yhxH3K5321ReTFu
sSKfncZDLgYvgDxicuKMjI2Rm/v9wDdI4HMhBBqo2cijR7eWL3bn9oACARoV
ThLYUZBE79Xs5p8kXEtC+odoYCZ8zadHagrKj8vm5ACymdph2C84KwpGN3ok
LttyLKwhHhJJCFiFtdcDEGSeIQrHpDsG5bnVV55ITOB+Rif7QGabEZ75nbvi
gIz+yT9ZlmUs6HM1rBbWNYmnZD5zEiTikmLiBZBHdKadt+6woxjC0UAcA16h
7BKmAa4cR34KAEJwoAAFUg7MPg9vr+6sC8rIm+CeLYuCgjBxYOoiGTNkoM8V
T+WD+4ZqNe4bYIL+ibYP3N7ohUobDam+t1Yd5C8uaRLwWOEg43Xcz+HIB02O
wJ8XtNImGJZpIjdZktKl+YrCRi0WhOY5rjBuZU8AsG0LzotJvAB8APiAiG+c
G8rNbUNMss2PY8hwugQP2UwtDG0ImRPI03FNvXmAbGcK0E73/vpYnTzJZQYl
fo1h9MbE0Ww2u6tYao/SWa6ZZtaiIhhpEfKhwhrizas/TIv89v2HTkgPEAYd
Ns+nL3KRhUYHdVQVGIg0aFFO/mnEOT/43EvcmLeXIQ1U1w8sczAQJA0tFsSN
Ll3VwppsA5TsudkOb5F4riURQNNCGDlxytWRVob2wyBIkzIKG5jMrTCKdRx4
SecP90TQseQiBLjwJCd4cGQEBTcaSMfIhR3Ii4YxxjcW4RRUaW0MaYhHr8yu
a6M9hWzamZEcHtcXDdpMZWgXqnXySeYbeQErP8YFzYYUVeCcEQYZ1SRBq8Lb
aJDZI4ua8aTwO5SSFguShdsY8SBzQ3K2TpF4AeTxk296aRczo4VhkLTtsDvJ
YTQ5Dy5frNh6gkyaiC4c/m6Y5fotUp0xcoKWB2qgmrNJPvGBdIw0/DAXQGvg
gzkC3CcHWX5UhWQ4KoYpjpAsPHRSL/8K792NXAMJGoeLXSPMS/eQ7qSryMaY
+xMRzESSlFy8jSFlwmYnBBjqCAbSlZCtq1EB0TwHv2MEkoxlIZxbcJ5a4gWQ
RzxxM7sdBkxegI1q5uAADirSyRfEm0dmAknn/eFdOMyTk1fyupEBDASdGZEf
U6xigqfkaK+gKpChVUkjvAk6a5gpji0Vd3jl1yciej3BXyDbBgFMmMqanck9
ciFfCGZGGEJItRw4cSWsDEoyHABZfoWdWqMeyb6gKFKTPZCRlPm+q9gulO7z
L49kEZEqq28+JUdvRwM0b8Rw5NRpiSvYN49d9hrQFVrdU+u3nYkgb5hzkdZ4
cYNYncrmLN6HgGR3+Jy4aOxQTdr5FdmDgoH96LwaKYWOxMgByRpACYx2BcsC
IdYHIaxy8DFIgiS1fl723D0eIY1CRTNNowHxhIFf7obRvJHxl00jZbsA0pD/
XHNIo9ajeQ5+JwOGzJj5DT8w11e1ykygNPt5l0dEDMDBjjl7+uT5Z3HFTJ2p
wTfjaWJ1gsiRL1D13BPehcPkf274TmcIhIEH1SGGeSz/Pm/cupBfUXNXs0Il
cDO5KBvphpYj/ojzEFMcXG5USWOk3fmQCXEwQeka5Edr4xQ5xgU7Nqdjgl2b
nmyYJjSVsGpv5ek0FJ1pe/RLyod1lX4g85XTTMigFcwbkXje5RGbHVq0VXmG
RO6xmBAQcAA4bqMdw53flgiiY74gNUtWTUSy+FW1xzEQnOFQRgSYWRcxdyMa
0mkCAhcwNju2hzHRBh+X6bFmmOJ005giiJ6WnSGxRzL8kDWQRRaz6rJ8N7qH
dCddFeQMczEYq7x4ghecCbvzGmHVzU7F4qFIH5ab5+BPRNIkV1AmSYvE8y6P
sDSwJCKajUvIVYchEWaRO09LMVP28TF3hWfYcE29ecBLBtUtMONggtMxrrIQ
sGHlBTP7L3vgM9q6syZAobU7tmNYhuYGRBYde1vjPqElrIPxW6sOovkGF1mY
T8SLcflTVLBn5QwUINXiqsCdqQouXXs22hjgPZdEb8YCT9HJWJA2hgyWqpz5
GLaKCsDzLo9Q8gjx+UHpgznfokwjT4SfCG65BK/MiIZXOYGks6xQ0PDnBa1a
K1GQVcK8LYbc1pkxku/lySA/oIbLZIUuta7p0BhwVwPlF1xu2cJrzqJ9gUPE
/ph84t0BP7fIe5ZGl3V9jxWpENBlzTIxCRKoWX6qxQ0Ps8hRqgDLeObGtg/I
UNV9wdlz/eqwt1Z1+i0mMjoHTZUL5nFJTCMfYHTsN/oK/BPNEA7D4q96OC37
SXjzRgktamEKhSt45jzayfWZz3y1WuCIRIP/ifcLsprWbD95JaQLh1me7yqi
1+1cHSa1wVjkcpJFJ28m/eRsH4F0jHwFxr/miiKfwlFK/Im7lxmpnN2WAZIl
W7KTHNEH4arkroSmNLt8eeEiC2SgZHn+GsWNwbR0s4xaIpNq8WUnzIzsM0hZ
v6lgIA8VahOxIG6eg4MRNofxw2eYEdK6Nl8kJYmkYegipVqjZf/3Ffsj4vDQ
xvwjqW51G7sDGyuR20LnlA3f6EM5RCmnNUVAi/Oz0UiiQebQY1HxTWsDoQk0
WoEnxT88VPexmoyGH1bIkPSwLhxpNaJXvohk97XbAfWYpM9pDcDtxQrhc76+
tF1eAH5ODDxbb7TLmz1nJCkFgNHYnT3tFCxcbtJOD5o2RNwleNmaKY78iJzr
wZ3BnOz5tlgAuE7OCWr0A1eR31zVuJica2nS0NPnfcpVKgWXBOPTFBOzIYCr
goGI45ExI01x0OG4Ezvt16RetFhcdOuS+EhKHnEf5CXBkgycfw1ALkidIqIu
iyxIH5KVaBI/sDb4zkAQeIuJaIYjgSg9V7dxUIWWCr/O3W5lEBLNPWjzQpSe
R62hRo/eAlMKCpkX2L1sa4cRGEoKjHCa353TMfgnspdolfKPGUIhf4de0VrZ
1KopAIxA0xrNfgMLZwLZTchcyCQmaUhcGJgb/DoWAOcjwGEzK26YgMRxVxlI
J4toZm0bK2EZT3AFl0AC620gO+TrZxWPZXb8gZsyFnRINZ/Ekais0Sb5FjPk
RSIpecR9kBqD3BMnkrvomYILvPusFRpwgbaZ2AIjlNvvwxTkUJtsGR0BpIlZ
bPkp03pwVBcUZqp8KzLFWJnkvHO3XpwBOwI9QU8hK7uFk86gi5hdOO4HyWl3
drJPgp4+W01hND/A9JtImZsr8P31emr1ShBbCYXwgR8UaIqDaRMYIuZMBP7k
BYA/UWQBI0T2ouEYF/mh6JzJbSqf+DdcWvjYBZi9TwrHbNYaqPQQDORtEaoJ
Og2akM0hsHajewcVjKTkEfdBplAX+w1MIqpryShFioeHY+J1LtA2C65J1zmi
nWmPEgT8GVFcLKGeb+aRISnP49ugmXmrlZQVTFxyVb6J1QI2XBjArJA56Swr
FCQCqQjaBAEJdMlA/2FtEI8G+E0ypDmrrs0xGgEhHSNfkUx7RgRpPHCE64LP
fgjL2HKmHn/yAgBQZGF2GMsQAsfTnAfhNs6oRpR3jIzwqux5keb8ssAmLWQJ
08VApV+/My51Gj1QnsrnKreI3Jzix4iYSEoe0eMo+/Z20SsR3MXXlrZjY9Ii
2FygzfYYA+RJZlxLQXBVkiJnv32tqgikNR6HgeIg7mxDyt9Rvq1fHpV51pj2
gt/BG0FsnBXyLYib/0ADu3AE5tGQ3JeuH0Anx+g6xC3l8HoT8Js2KL+JB39r
SQeTmhuYOqFVF0Z4I7PBMRrizVm8L4yBj22d1cLragEA8GczDrsoYd6leo7x
12deExSII5KJtMlKdzJwUqrWZhNAMJDDqrBq4HqQRMs8GtbPjPBi5xgYa1lS
lQmk1jTLuFtS8vj3FV5ZnKQBz/UbCoU9SphziGZoVDcu0DabLWCPIN8ZrqUU
BDeXFceQIVNXUYV52iOsNe5WJFv6y3aI//KnoeF3eljsiLFClknn2YLdwTAD
iS5za0/rZDBuPQrbIDDRICG9G4Qc6UcTE60G0FV7usZWot3BbKoDZExx4QLD
KQ7LNuJfkZqRCwBA/sVMMGE7Q9IQx/MYIO44DXL4Yz/VIls0b1CDdyWag5JK
2PWQk6UVxbEgaELJ++ICkA0FB1TT/dWpmp7hW6O3RkZGRqVnnog8PlbtgxxB
pyfPHa8EZtPAKmFXhb4yaxsu0DaLu9GyzFHlS54gCGsk0HwyoU3PRNHTZjU9
ByxE7lxxVDCpJN2Uls0sFUaQ+TUE39zspLPJw3FDtAdui9lhEuEFR7VWzmmZ
S78Jgk8/mhlJD0izuAIbTkYwlNCJSDbEQ3wyokPmq2r31BaAq/Yd+oLax8Hd
Q5ICPgKPyeMQPTZ66EBpb8uuxdqLGukCVXt1XxzlPQWuBzShTBxsP/AzPrTg
3uzpoZZUqrazp6urp19LPyQijwgwIh6CRBViMnglMDqhxVTJ5mfpw/2n975p
VB6RrsM50bCaDAwZ4wojv2nQqtrB+iB/BGeGBuZuDDJF/rKYdpGJtd5/+Gs2
/4SD8zLpzBUKEoGl0KjcMfupghpNV4j+UWFENYb0m5BBoPdqYRatBtDNpv0w
ZOmfCSfbFM94iCFsVVdVCrvGAnAVv51WgjZBHkfi/9CWdeqSYL3QV4MIQ5NL
PsOuoP66gaREdJAjz5R9Lug0aEKZk+XZ0AWPaR7prE+lqpta25tWktVaL9O9
icgjAoyoxEH4GpYPXgnUlrAZ2G1/V7ABYd7Te2XwzVXaG+ekFQtBkNleRNty
9kukLUw2YIRXSM+Xbj4Xz7KryLFfcDA47YWwPLl7WnKBFbJMOgd24TCz0i4H
eQxKCUp0yTNCsCJnJFn6TbhU3DdOQwROQ34axFYiyzCwaTlAtqUM2WGXiZgR
gJZ6JAvaAnBViN4x+lpDyvb86Gkk0Ay4zwmibfhqpExAJZLSB92udSo22/q5
SpPQD69D6DRoQplGh+Q6xRDkJieVjTrWkEq1DD+7XSmBAk+uNAb2caRQYTng
lUBvYvW2kzLDiOgWfkcpHN4rM+OwHJCtINsGvoPGTpwTZBlqWJxd84sCPRC3
OMnL1DvuD4/cIo9XgxFIS0irX2CFLJPO7wV14QhspfUgyINz/U2ctgAOdYYV
OjHgN+H2IoOA+8l7h1kDCJj9gujiI4JymimuZRhNqOzkuLYAXNFoTmuQAsWF
64d9642b9wOeKObCP125OWamWgI7MQYWtSFE5ggvCa4HNOFjkX5FiC9sYcfB
YFN1qt63l0Z7q1JVfWL3TmR/RFwFCwwp1AHV4cfzrYKibfSUpVkiu3WhQFuS
N4CLyiMjqSGZgq2ikZmrY/SDqsvOg6/dfhK3l0SJq95ISWJTuKyYxgiHsm+S
Vo2IsSSYTsYKWSaduUJBIrDVZJiY0Haw6KsenoyWk/mAbRoTQmFaw+5i0pdZ
AwjwJAUG7RGBQ68ALosG3vW43FH9f5RJeVNbAK4yRRyDCIq1BB47cr4cAUBo
Dkl8smHmG6mWwE5TnoFkRKjg+ToiagrXg2wSrV0YpgM4xcy+HBusV+HVxq6s
DSUReUSAMROg8Dcs3h3oFgVOB5v94Z7VYvJgJp7px4JQoI1QtrTcsKLozLhF
YM5o1d9mRxoTJGtyJaCAiM+MbZpLRa6rlJxZBgsZ0erf8cXpUmXSmQwqswtH
YEwGZDAtWQnZJ9uSW/Fszh40YEL6TaAxkHMtY49hhdhmA9g3Vx4I5C4CUgFy
bXjYwa5gt2oLwBXjMrVCQkR+UHeJbBR3X6RLJYsIqSW6OfS7pvwDO2kEPg5Q
EKUVCp1GCkprb4v6oEBtlhfSExNp4wEmIo8IMEqiJlbjpWv3tZQEgLyVvO2S
To8CbUn+B3AfSFuSg4PWmmYz7eVBqk/DvHVZZVkb1RxkenbeNu2f0w+lepFM
LjcwLR+yIUktaP1h2DCQSeePg/rwHwjp46F9a1fYxgjj0Fs25mLqygkvHCue
u+JZGZRZAwjwJD5GlSiNN8FttVyVR46ez4Xqj2Vbjplyx+PdNfHBpcJJBC0W
GoYcRgwAQkoC59RMi8BK4cCmYQgGOiKUCp1mqkckm5zSzGovXh65wE0Sw+Am
kOIyXWxX0UvkXsO8CFdMBeXiOAAePUkNuPe0xszumrItUhg8lS6mwCD1P8On
aPI2zaXN7DZ2Gt3YIMgyU+OqxUOXKpPOpNtNhyVslI+ZhsB4iNMXbnOrgcBG
4hJSe5A9iejH4k3PuCtmDSDAk2oZ0cQwaZBILncEaG+iizfNSBRZmK9jK0df
O6RcETWihceJSDKqcU7tG8He0IpoAj1ipt5xRpgbsWrhbvY0zbBb8SheHjnA
KNmbHGY8lk1pA6DnZZmGpNNziICLxwFEckjjcTLOJEiotkhRs6dpm5DZBziA
yK3wNo0eYq7gKpiT6RB5c7I5uqyQmeXlhgT0wkbd8XBwBudWUNrcfeb6qlyV
ZdJv+pfK1klup1kDCJgttsiwjCCicFtm1+ByhwGT4LQFAICDpFVewNVFH2Zw
+MEuHh17RPcKxDkQKZ2gVMvL3nDnLH0S1nQaUyeYR815cG3cLfu5bd05Mt0F
oHh5lAFGEiWwN+ELk4SaKVpX9QmUWVqupOMCbZebq6jDEOkiO5bJKqbBEEiF
0qAteKS9EJTgqreZaiIwFyxvNbrNsFqQ/beRR6BLlUnnwISXImrqfRrnGv4a
eLN0JVfUsCfJ3AtExm/ybzvJC7Y8BAZhIQdmW1zV80e+wo8jENJB0LjcYQAj
zjHS9K4aPKfJKWJcmBuC0QNq2tQ4R4PxdJwg8smbBi1Qi0ExyPR1RIQNKgua
UB52Xr1uWvvFo3h5lA3E2NRkjylDYco2GGg5af4Ux4K4QNsVzcdwDGk5WH1M
5jQb0UfUKzFeyVaYEGEkwTmd7Yhrhmw2+PPFZHye1YI2n8Jvad4r2xQHEkLC
YqS0Q2k0b+bmwe8mBRIxyAZQ27QXAGQawxlhTwbWALqGbwV7LyLxLU1xWRse
AaiFQA7eu35d2K1sdcr1Po5qG4LqVDwmsO9QEhWYavE6BGYHcsOGFmFKGpeW
YCuZJYq5AJj6TkINkDUUL48ywIhQjJsd4dcovq4fLdFC6Ex1k5w3bs6JY2RY
DF3rzQnREfURjFl1bZKOCLMT3HVs0yh6Yj6tZ7tu6zWr6VktaA2BwdMmC4Hn
A0rblbFZjUzSLs/coZi7/liVinA6Jgy8TUsHStbOB9YAuv5NlpKefpyjGYh0
2M0HHQjwhQJzKB/6g5LNfZPupCNK8GCS4TGB/Y7od2Ce1OT7zQ4Z6kemryMo
CtBpZuSHx6YXPDg7AtFkAHqsJBRSX9HeTa/I9KgMMHLXd94oXUNt0jnNqm3e
FmXS5J5qXo1j5olQHq1PWgZmwN+cPX39zrjsTar1CnP9PZH0KqwUfDp2TP5c
xHY8toaRuKHvbs6y8eoK1x2WG4e0oukKQXJAQs2sE9Q6TGJVMAnQ68PffOrd
8EGoDPhNcqOUvWU4AK69SxtZxePVwj4F34JUU6AhFAiSKfJlPg8if5KeNMsx
XFWa6qgiRKRuEf9Epzty+emcgX6uxzQWdOWn4SQuMgPIheS1TQs1cHoLZ0a4
Lj5BRO+PyIZLliOcOM6aaQMaOHDBjqRruBVIrGusb6a6aS1ZvOEOKrgXZvZL
mANcUIbJe9O97GG4GmCCwtTkuDdyH7KfWDSgkGWOg0OpD33KH6K7ngEcVOdL
8iKJKwPZzSJAheV0TATgNkpH0vUbBWDzDYvukphImiKnWsI+hQNow9m14cni
NdWQBBoYHXTxmHI2ns0UQasFAJu/mNQh18uY0bDiES2PqG6QATekgbg0HrFo
jqswLUTugDKM4CqemFmlCKqb1kIQw4/w+6y6HLlm19APrir74hrYTIgy5E4i
ZYMW3ByDAjfAq2CKN1gHClla1+zVgmIE9mxY5zrEl5gLh/dybxCfeneE7I2c
nWYRVtUIKqu2ZXqTYnO5ZQS+ECphmmKGphvUzBkAV4124Z6gQHpSwEN01Owe
WLx4TAO5GrNrRdDItRUjSg9UvXwiAx81RMsjulXIBqRvLN8vzae+7AF/MMxA
qGCm95nstBTi/CYXGkwPmYh0/Zq4Wf5mYZb2hEHazzxHnk19TNMIC/jAmKnx
U12chyLLkEQysA1dIBA/pJOwB83OGlM7aENZpUiYGkDj5NpGqDhuFuGJ+YoD
nI6JANKOGo2BO2YEurSuSq4xTRFB4MDhXEDGFL//UKsNTxZ0J+nkbHYixYbH
ZG7xGrQiaOTaoiN+0YCR44SMDS0S0fKIHjiOivNzpTmHp2D2cFwFyhyONluk
Mozgwk5bEDAfDbEgbUQLbxbocBjN/QBkfIlbDTBtA6mWiIbDpHxQZckm4odf
HMUrMfnDUGL0FmZycpQJKVR/PTzgAccaQBvj3gi0C8wR+tB3S/dwOiYC2KYl
UcdVHCdyqMMaL8M54t47sswzEEzSCCRiJQX0mmD1BSsaDyXnYC+tRHpTrgWQ
E2jA4mT30EsK0fKI++CoAnmubOWgE9x5jqtg4UH3cpuyTBhBmZrkhQXG6hEL
kkRWV20WtMOi1ZLZxdSEzL9wSpcZX2TmRRPqqv3IrSPywks3H3Py4WMw/58j
WpzsI3MR/0QqK5BF6ar+xlyESNczX/gLuOFOjGJYkMrwLHjb4tlPYVMjJ59k
0RTJ0ng3MpDLprhWG54s6E7Sp/AsaY6oBH4FE6+KFiL0NGNOEAsDQoJOULao
eETLY2rhXrlZgLhFr7DOpEUlg8kIPqzxKybk3IR3VQt318/+BPo+iJxrPY2x
WdAKj+7gJCH5CbCm6BM5YkmqILoAZIGfhHJEaRJdkpNPfBs+F/0wC4j7mpJD
h/u54+DPga2WANo3EblCSkUWQEG+nBiTvGBq4lkwpwIO8ua9/Vw3bQKloPid
LI1PIg1jbLh0t8OakCcCBOW4+TxHVGIOhpYttnIugDiY6XPzIvqlFIwIeQRP
CeUPiHjjEeMVkBZIGCX5AfYhDHtZCbVKlcXB9g5cS4jU0Xvl7onNorH1LFRB
nDsgC4Sx6tbtOIWyOKRaoguWESVwxOhzente/gKiDfTDEWYmi86ua0PdH4mJ
madmkIUMEhqysbLBFBwEJ0axD8oe6X5qNAZfHx7npt8mmKaIwEX0B8ECgYNc
cD1gToAON0/drnHVVg5zPXKCi6DjLIA4IDXlRLZBKBgR8git7qfnMkkHELdg
Q5I3lGlHLKrVIMIv+dQmOXePwwgIMAYOC8NeRu/VMmtVyzpIPXbk6lDBkANc
SDGStucOvSieim6ww+VXMNFdVd0T//5fVnVDbKJDTcFlo52R1hWJScT0H046
IPsj9QBWvhNj8iy2abqfWkbP75hxMLDkBNiiaIpaqiUQIA3iq4UNsSoeiGPw
7eI4hjZdOgzPFkBQrq0AIP9yIVdn0QIQwQfIRNqv3iMvEk4EiFuck8q0IxbV
MZLaJCsTOeYM84a3HvPjHKONFW0W5GcFjtIOA9tOcBy4BhaplrA2iQB3D+P5
BYgAOCFt/E2wNcV6GAV6SBWR1UpeJIkJut8HnoGTDuDTyhAiXFHHoASb4G1a
s4rROsC7qyGbC9MUeQFEfAqUNr5a2JDH4oG2b1x4wh7c4vDCTIm8FkAcgNxu
simKR8T+mIm0P3qMpAM5jCBucXlsYMqJqRQy1MYxZwQY7wXFxDj2orEsNu46
DeKHEzSqPhAoguY58hlOe/cltFuJbmAOXeqIVjPY3J0YY6eAtKob4ro5mA2v
+uUDQ9fv4yaQpRFGb+CkA767ZEMxeXJ/LvIkB980GgMyj3QxZssCgGmKvAAi
PgUGD76aORk8KYBSglIOANVVa+N1JOYFEJZryxdgnl826JrFI0Iel6tIOwL4
uPPIPKI0HiknLaeM1K1WKcyNN1f7W0Pgxz1ru5rtXSIj+d6nR8K6ZJuQg61J
Cfyu2nI2+FtDdESOt2muvMDW7MQL5QHw97lxImesHD/SzlnIsAAID35a+KW+
i4GAkdOMdMU2rX0KMpK+sRfMuLuvaIpaqiUQnFEKa7SbCNALYpWoAiATyAnq
+h4IHoEXZwHEAeah5Ex9FoAIeaxe3QlmDlg60Opg5qA0HnESLeWEFImZ0YDp
SK6TNjOCwU9W84ywWZA/Fad2AFD9tc47ipiBCaG1Xjm5fmEaeJvmfQEKIbpN
kwbMy+CUK5vxiLQj6eAYjZsYnHTwfOdskwzFR072BKhAsJOldRsAg84JYXQD
XsRgWy8vgAjcUvrBrA1PEEhDy5QreClm468wYAHAdy7+eshxc8SM2gQRJo+0
JDjSjqTDe+s8nQDmKlispCVMmwehafPp4FYgtBj4iTy2Q7PEEGPEx8X8UiiC
xgWDgoLS+LBUiwRXvbGViFBSYK4wDNCfMm6ACgUwVyfUdhmR0yeLaJ5//eYW
gKISbWpqIGDUaWFPb7NYkJWOMfH++iPvrD1k9pozwXNPEpm2FgY4GpKsTmvJ
iSTWaoi/AOIA+VCTbVg8wuQRUoB+R9xIwVH1elwabw7zQijMbC3OccswKi9v
Iprmh2Zw/O6jMb/UsKqI4ZA+HBAnfI4ng7dpfgXBqIiehyboUrXVAreaIzzI
QgbWOACo/QlccgjuaY3pAoFt2qQxvOn7FOazYzzruWc0vNLApngpmskw0HlA
Pjsoq+5cvUEY8RdAHCzyp9XEjC7mhTB51CLtVX7hNhOWuDTeHKOGL25qS46T
hHG5XbVozZUGzkz88V48v4Dj4cyZCUy1SGCblkxvhK1ylpZIrPIpBHKQIoSI
pwZjMFAEHXeLml9wxuByg8wZHfYEsGjNNAQ6ZpgjRRg7FOsgZ8qVtWgpyNUM
lBvLTOj8Bo+2EUF01xB/AcQBtGVE2+eCESaPcJrYY4XC5wQQl8YfMp41gj9m
62b2yyKovHNXeHrbrDJe7ufo49TWMTDfh5cc9zzpz1UOgAUmKfRwYHOWlkiA
9Sc7O+GrcaR9gz/I0hylzeD5PiaXu843lsy7ZILcfCdoWhaodBHztbk1cZyQ
BazfUgQbGYhgyMACvtrQ9dz5aCD+AogD6NvxXJN/C0CYPCLSzlNxscDY3+HS
eK0dsasUkWm9sB0YQeVVE4r1bAgC73m1n8X8O46ocLAxMNWiIbVwryQBgqoX
p7SEgRSJZAxiU+NIOwLvWh9CCSQdZgUNiV75tUdWkQOIwwC6rJkWBHUnIjhJ
69xRPfdyfgroHxHNYIsH8oYy5YrujlpnmwjktQByApQts49B8dDk8cbdcbJF
6afm0yMygoHEtFRQGP1mppygyszWIog5R1N5IUSPjTWAHETODLgEzGbeocBp
j0l3pC8uK/TRuTpOaQkDt0uamqRqZKQdSYcIjg3iJIFcbiTHTa1lAklbk8YA
qkDE7gyaYkw2GvnCzPQuEbC7SVMTqiZn7yxGXgsgJzCnuxQqSOPnwFF1sunQ
rt8jmnSCJAjt/uFSIA+Qnj7JQqAhQVtM9Ko+dGo4cEYJ7a30WXnRk0il0AXL
cjxafjzROBr01VpFKz9a+Zv3nMtZ9ypBzh29Rcbf9vw4JNc/WaFkckTbTht2
9gWqIJJlOnkcakTv+Zv0LEw1/mA8/fmu09HlCV98f0YbzBoGcjZzhn2KBN1J
spGkp9N9+lq+42ziL4CcoEfwdftAKYrL5P5IWpGsUNqk6OPoJw5Z1MLCIkFI
eUTaLmd/aQsLixJByuOn33qDpSZK4KVaWFjEAcvjk6dPyTGPn3O3sLBIHCyP
KOPNK4ZpYWGRLFge0XamRP3BLCws4oDl8Z21hwIHp1pYWEwZII+oqitd/xML
C4s4YD5AILHKwsJiKoH9sXfg5oqtJ0rUzNbCwiImip83Z2FhkRSsPFpYlA+s
PFpYlA+sPFpYlA+eF3m015ks7HUmi6SuM/557JH2SHtk8UdO/SfaI+2R9siY
77KwsJgaFCahBbzLwsKiFLDyaGFRPrDyaGFRPrDyaGFhYWFh8RzhVm9zFaJU
tU3DXtPldFdDjf93Tedw2TUxGGyuqW5E9WiZXufkaN9K3NCaRv9+usNdDbjB
DV2lmjNeCMYG66v9y6qu7x/1Gg6X4XUOttRWN2amLeiXlx5uzFx/w3Cp5tNO
PYZrU6mmvlF6PC01qZqWobG+RvrGI2l3hL5+VVMJZ0Xkj/RQq3f7mzx5LNfr
nGiupts4SL+0VKeqW4bdsd7qVFXXSDo90lWVqu4rG80x2FSdWtk56U721Keq
SMWV3XVO9DbVelqt2Ve/xuX1NVZX1XelPbVcVdX4ohT4T452tfegOrqvPpVq
7OtvVN9usp/uQBk8F4XJIXo89Q21Nb7CLNPrnOijVT54a6S/t29waHh0YnKi
n/RGk391aTJEGvvKRXMMNtN67qF90VvYjf3ldp0TZAktaSKJhPo1Lu9GE63W
fu+F9CD9Wj4KORnc6qUvVdVza7K/saY+I6BjjVU1vWWyzt10+5LUks5b7nAz
7NUyvc50v2dDVa9saiLt5hketJCq6zPz+/oaahqme50zJgZb6Aqrqj3burl/
rDyvc6i5GlrXuLxrTdXVPbjGid7qMjKQikfaNwxqSBhdX1uqdT7akKouk3U+
4enAVGNre3N9Da329r5b5XmdtG5ofeNiRrtWVjX0TfQ10jaEf+ytry6TdU4X
6u0vnp/i7UT0642yvM7+JiWP+uVda6xS8jjWQweVxeUmgHTnStLniDxMTk66
t7pWktuT9txlctZqh0o43CwPTI4N9/b09vT0djYtqapt7BseK8/rdCeHl6RS
LUOeQPbBor7VSZc3mM7Y263lEnqYaKpK1fd6o9ghj2NleZ0sj8ZtfNi1xAt3
0L8MtdamalrL4nKLhr+Yn6HGs9XHWpZkAq7N/WXXd4uchZqM816m1zk22Jq5
rOoGXy7d/pYlmQB2cxmFHcYG26szj7261b+BZXid5ERyrEa/vLH+zN+pJeWx
mZcQ6YmJdJnsOJEo1+v0rkv+PVmmFzo5kX2h5XqdGRiX511/+V6uhYWFhYWF
hYWFhYWFRbni/wOZp485
              "], {{0, 195}, {304, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {304, 195}, 
            PlotRange -> {{0, 304}, {0, 195}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"09432bfb-5b99-4f1b-ab7d-fcc51ac0da80"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9dc6bb52-99de-4602-a220-dce329938c00"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"38b912f3-f6bf-48fd-822e-dcd8940df042"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b5eb1d13-b28a-4581-9b80-20eb47e59d2d"],

Cell["\<\
Generate a sequence of 20 middle C notes with random durations between 0 and \
0.5 seconds.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"f98eb757-a865-4569-8989-b8ae4313fa63"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8e215f0d-d6aa-4d38-8327-a56264af3c7c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3N1vU2UcwHHUGy+N8R/QK/8DuTIxRkDjjSgxeiXoRBKZOhDExEjOTRFG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            "], {{0, 115}, {250, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{250, 115},
          PlotRange->{{0, 250}, {0, 115}}]], "ExerciseOutput",
         ImageSize->{254, 115},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a4fc1824-ec60-4110-9ca0-d478d61e5a53"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3N1vU2UcwHHUGy+N8R/QK/8DuTIxRkDjjSgxeiXoRBKZOhDExEjOTRFG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              "], {{0, 115}, {250, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {250, 115}, 
            PlotRange -> {{0, 250}, {0, 115}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5c32d941-5293-447b-aea5-17c529b579a9"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"dace8a24-4588-43ed-9d16-fe70330c920f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ac96ac81-a015-4fa4-882c-14eb00312fff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f678bce5-bf7a-4bac-bb10-7f1c8e0692cb"],

Cell[TextData[{
 "Make an array plot of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Mod",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{"i", ",", "j"}], "]"}]], "InlineCode",ExpressionUUID->
  "3da31b4f-f0d1-443a-b5cd-924768116993"],
 " for ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"a896f405-cbad-4544-94bf-46145d353a21"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"e9896d88-28af-4403-8c19-92ef74e15c87"],
 " up to 50."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"936b035b-2dc1-4347-bc63-7b45ce46fda4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e9216e72-9cbf-4cd9-bdb7-38ab4dd38c18"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3S+sbtlZwOELhIRgikBhCAkGhakAQ0JQNYg2JCiStkynCIZkSgIITE1V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            "], {{0, 359}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{240, 240},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "476b3b62-de1d-4b88-9995-66a865beb3a7"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3S+sbtlZwOELhIRgikBhCAkGhakAQ0JQNYg2JCiStkynCIZkSgIITE1V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              "], {{0, 359}, {
              360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"37765dc7-3cab-4369-8aaa-b758ffb716fe"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1404603b-46e1-4531-9b53-c4d2ba48f6ad"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f299c553-3a31-4ee8-a91a-b93757a53f85"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"af955f9a-69ea-4f2a-a931-9d7f704032ac"],

Cell[TextData[{
 "Make a list for ",
 Cell[BoxData[
 "n"], "InlineCode",ExpressionUUID->"8f3d41b2-06d8-4642-80f5-338c7d3f3cf5"],
 " from 2 to 10 of array plots for ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"537ba331-481e-4e73-94a9-db00026464e8"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"aa412e1c-f07e-47de-8feb-acaaa3ef6690"],
 " up to 50 of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "y"}], " ", "mod", " ", "n"}]], "InlineCode",
  ExpressionUUID->"7195d161-9119-4af3-b202-99d89ecac501"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "23.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"93319301-4ac6-4827-aea4-1197f07339d7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1999bead-92f7-4fec-8142-dd09489b381e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3T+MJOeZHvD2n8ChI0cGDAOOGEzC5DJhQ0UCzmBGQLiDtQcHlimdAYOJ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            "], {{0, 1046}, {382, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{382, 1046},
          PlotRange->{{0, 382}, {0, 1046}}]], "ExerciseOutput",
         ImageSize->{386, 1046},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9372ee51-77cb-4fb7-a2d8-809c9ccd0692"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3T+MJOeZHvD2n8ChI0cGDAOOGEzC5DJhQ0UCzmBGQLiDtQcHlimdAYOJ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              "], {{0, 1046}, {382, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {382, 1046}, 
            PlotRange -> {{0, 382}, {0, 1046}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b19deaf1-0f6f-425e-a091-9af28774c63f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["23.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"408749ad-434c-425c-91b4-89331b77af89"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f4e1cd59-7625-41d2-8110-2ac62ba83395"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"83408ed9-374e-4e02-854a-fa26580a5b4a"],

Cell[TextData[{
 "Use ",
 StyleBox["Round",
  FontFamily->"Source Sans Pro"],
 " to compute the fractional part of \[Pi] to 50 digits."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"2770d444-092e-451d-83d0-8c22d43d5bd8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c8030c48-31ee-48d7-9708-dc601fcb69db"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWr3LtdgRN0mTMpC/IP+AdcpYphI2pLvNLnld0ryR3cBiK6SwtLOzshIS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            "], {{0, 19}, {358, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{358, 19},
          PlotRange->{{0, 358}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{362, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "405db82a-5180-4a0a-8e80-cd3f3a25d0a5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWr3LtdgRN0mTMpC/IP+AdcpYphI2pLvNLnld0ryR3cBiK6SwtLOzshIS
rKxshA02QjiQ2EgwhY2FCzYWFjczc/x2zvPch6RIwIH34b5z53zN7zdz5pxz
f/HVH76wfqxp2rc/hT9ffPmd8c03Xzq/+Rn857efv/39158//e7Xn//46etP
3/zyq5+A8ufwz/qRpuHn5y233HLLLbfccsstt9xyyy233HLL/5U0ZRZHcVY2
KoOuqUTdXfVtJU76o+WEBqtUzTjrhzJL4jgtm35rObRFCsqkqA4dTn2Tgz5J
q258q8+xKzI0K6r2vdGfrShw+KIat1Fq2bodloXU4ijVMPGWNHdBc8zrbu3y
2TcijWFBWdNPb1tCp2UOtsnBIfKbri7LeWjZQVVkYJmLFayxRk2c5mI4NL1a
Lss/oDbVCEaSFWI3TVYJPq4Jt7wd37S8QDl2zcmbzbz8KxOUqDEsVXDmiq9K
+WQ8jJQDB+2d+To92OZoX5UIcFb2k7LPp4IeXZXDzLOiHg8dXpVXLIb9NNGv
Evex3av3TGQj/aQsg4cGouOfR1iejMc6MTQS3T+xeayivZ6zHHxd24lRgnOm
xiM7nb5yUiRAL2JpKP/acTW3l0MsEiHaTJ9Tm5m75qaXT6rRn2NGwxsmTcJO
RlyIHH1unXfTpS1+mw+s5VSG9m5wLRS4+jK0tkVqRtYqLaFTh5RyRm62D/DG
pa8KSaqpcY1tQmYowOmeuRvHDGbPXy151FoJ/jwj3aFwYpXPQYRympIp5EzG
koVS+LvZyG/9kmWCAjWGpQrOMPgqlJyHn2Niy6mumg/Qg20OUsxukuLU00eI
NC+clFY0HGJ2r+RQG4rzNDUPOq3Cx0FV9KpIZ5RDYSDREIICYTXFMQVPXeG7
ng20NIJj2mwl3EDHQWk5BIak60RCzTKMj7hGFyUOLMgGotQRLMGj4mCIMNQ8
ymg9Ec2hNNrHXkDUZfqc2tTQ3Zo+EzcMwouxlOt1MxyqL3xCdoxgzjqNPggY
XHdz6nRamrUeTNOKxydvWYWW6RfUpMa1ORl4OjRmr8IwsDbDLxWWsMv6OGHC
A32zw2smhmbKqKnJNZJIdeJHsF+1CTkT/dIk2GVAhcbVUoFa5xt6SE36MlzI
wyqHENb+iEaavI0fK9ZSAeU0jTMGAjvCFbFMeAO1E0v5gRh8FUrOw5hbQs+x
9L3mZXqwzeH7VFt2sanNvQA+vEykUaCziDxd7s/4skoetW2aYx1rixMEuFj3
u4OL+Ui/KkcRQD9Zty3NL4+JgaQClPVDxpCuNvRzJjladh4sp9oVfNDQN7ag
oBHDCkHtl6quLzwZ8jIcvOI0H6bPvfS5u2QMznIogTxOTuNPwkDyDOS/cpk/
rMtt9x1iRGspofu2JRjAiDKspqFfj2D+kjFYS8oYrkSgwyCanTMRxKbjQADR
cih/2ulpveC4+dOERPIxOfCWTzVqizc0r+wVyv3aMR/qpxXtLK9Q7syqx5xt
VExgUFOwlBuIwVehZDy8zjFca5t3Qd/Rg23+rGNICY/jgl4l0g81FIT6vHCA
VQfcxMgpFVhskjoIulRhyfdInpxcI/2kpOV48+BTbSkyBiWlXeZpElqQEJDn
j/0fLIcSS2b9YVuW60cVll7EEyqNaLm5MZN8EzJAB1IomXlVpWEYRmklz2Zc
n/NoXSvy+LHWabxlh/joVlY1BR4cnGbqA32Dr83cI8kRXFkMwHSVltPQNXUW
0s6Q1Efnta62i6+LJRZI0JEd1a2AAsDwcjlP3LlgIxggD2yx4OWVSKMgiDJx
pBiCEs/bjcJShRrOqCp82hnp9MQra6ph3KRs6DgQLQdotvkJylUa5Jslq0Ge
CRxq77J0N9AVX6Xy7OEVckxQa8i/Tg+2+ZTaUEJkTZWFQRCnUv0qkeYaspkr
LazOnIxVvoNFl2m7QKNDounYlu14aXkg0inSr0rK86sB7h3nfMX00+GAVgQT
qin5TCrLqXYN3fLCNI1wEZDJ+ydlSGCEGwSuPGQFO/Qlqy3ag8jzdFBz3Aea
GphXuT437Ehmzygsm8ReT3BmhDFbBkhS2wt8V9aoj3VGchta0FFaUnKTYp9u
1gSRNV3g4yyHcDvlz3sHtZIbH+wXhphwo53PqQ/HsbCBHe9TE9XGchPhLZWo
lcslAxD7+Yayy83NceHwZvMTlIs0zu5ShWcCh9rbLD0NdMWXVTIeXuQY8h+g
B9d8CGavmY5rS9f1HyBSS9csph8Gtrl6nlW+hUWJsbGk3OeUeQ/gRpwmPt26
yKOKlHczBmbv7eDc2Ne69NqEDo0aAu0RHw3Hi1afsSOi9Lm+nK36Ovddx3GD
vEgO5RMd+WEXHDbPy3MuDmsfb/BOfc6+GLvUxz6SI4ir5YgVoxaJbhrqyDEX
yxG2Y5gR8LTMPDyELlF/qRiVlpjg29I9Fvwt2lyrjoNlDp90rx6nrkpt3PXc
f1EIICUC3yOaWY6X/f2vJl7azV3lnr6/YY7RyswlJ2ibPlmWb6I2TWOdh+T7
bapHJXLD9PMRek9wUfMtjar5EcrFHXigiHa3+0omHFF7i6XHgVh8r8o/f/8X
xsPLs8wpY3yEHtfmtJE9wn73FaWpl4k0NkngObYT5SWgPFcmrFIJJZ1czufi
3fTmSxiUdzPGWAV4zSvXQ6VLIJhwr6iJ7LYtYt8PAh/+yBRlOP6WZfeWOP1t
asWVEiNl1ETuv12BnDb89RWHTq/L3GBpcyHH9jnu/E2HOEwjjCWeyDR3WWHv
XW4Y8CLBCNcrCCr5UvbSZLWcdoN3dFyUFWZD6cLaZTnOEtFct8JJ4J3H9/8s
A3Qx+tj3Zj7n9d+AnVYyv6TIyyvyzRDDQVzTk3qN/+pq+Q8FauO4Lm6KwNDD
mzdG2efQJl8jBXnm96zlk4FSSoNLfpyu1qXsmMCgpmTpZSAW36vyV3+KGA+v
D/UVhTw3z1focWqO+74xRwSdHI3Tzdy7RFqkxiug+LT7bEoeC3KucdpYdy6m
hBatAx/jl1PSqRBKuqZr6D0Q76tpZ9TlDfzQVqISxEkrE6JqD2uQVyLzy/rF
EitBwy3qtmtK2vmxOJ+63H64edXUZUyVWYJ7fJvJ4izISlGWRVHUeGtB1dcj
qLqujPFkF1Z8n3BU1HQnq9q+axJ6boSNjLWkM6PmJWIYIRVjDeMVXRW7lpfU
bZNHOIqXrwREf+5TCmNJ4Wl6cd31bZ1T7GL5VyeurC1zIRckgPec5RgTAFnd
jVAg4eSPMYUJ0Ci3g7+ZiBaqEVwkHGmfXYR1CfSUwDgwTEk/R+EsGdSI25qf
iq7vRBpQeVuxSnnS0e2o6cehLfBl4xH/wDbnoVzmv78/4ZjAosaylB2IxZdV
sh6G3R2Ym0fIpzAvgcQTC7qCHmxzefiyo6Lvazl5SO0vE6kLbSvIRNuIANtK
bjBKHjWZMKjEoltl+i9txGEOUdVmgU2Ob1SRziureDlGG0m9vc3JNF4eX9J1
77Aj40uZsbsSOVoOTe5sR18jJJgm2BeWR2LdCmRxIgJTO8r8NrSwAlkf4dBs
nyNUcY/15Vn301plCV3m5GUpFj51PSsqs/ejLILn7kPG4CybfHcPYdj086Y+
ODhDk/sFZ/lcf1NBYsbiWJnjBrHuNZAfloMquW5crnp2fpdwnC151KY+9Tdv
mG7cqZT4+4dom/zDw/2Es1RBOaN8fLm7MkGBGsNSxUAMvgol4+HdNYKcFtZR
r9ODbU60cVcnJRS5LxOpixzj1JZXKlB7zhljd+qZusTbfo9h+Zn8ho10ZfhP
Q789Vc3/f/6XZBqhs+FUuQ193w9c2cd1MKDtoQO2T1T2nPJiOZsetvKxvzbm
p8NbDjjOSytiLdnJszKS714Z6FVLuaLzTyE5JeM4leWrwjJBgdqJpWrhpskr
X5TX6aHsARd6GPxlIlHTC7E55QewIMvxP1nRLbfccsstt9xyyy233HLLLbfc
csv/tvwb61knAA==
              "], {{0, 19}, {358, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {358, 19}, 
            PlotRange -> {{0, 358}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aa006fa0-48c7-4c32-a53f-dca9317a4235"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x23.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"352bcbec-2f78-447f-8bc1-cba1a5e29270"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"36306669-b85c-4781-8513-f2d74ae7d637"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"edcdc600-126d-436c-8954-7b494228fcbd"],

Cell["Find the sum of the first 1000 prime numbers.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"52358df3-fc70-47c6-bccd-23332fad1673"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"33c4c1a8-7a07-4f23-905b-e922fc4dca1f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVKGO3DAUjFpSWKlf0B8IKigNLIp0VVnInXo5lVyju0pVaFhgWJhRUFBQ
UFTJKMTExMQgJMTAIMTAYPuevclm99TqQFV0T8ruOh7PG49n/f7m+1X6KgiC
xzfwcXX9M3p4uM4/v4XBl/vHb3f3t18/3f+4vbt9+HjzGl6+g+cDPPj78FIv
9Z/LqHHo2q4fxfx00uqJ9jgrlNleMdq3bccmvcH0xOFV2w2TtucECwPytt+D
PS3nctnjZu76ULk2svMQB1ih+4xLuqdeRBPsqhHmYETu4HGEX8UwAYyR1L3z
HNEwrxx2KqPTTN5P3osui3zP8SjOMpLtVASEa6etj8JCOrIBiaLxtBldIUcu
cR+6LWuQtrAKMc6DAVSGlT4YEgVxzdyKMYHpivn1MyKCFtltl0PfzIkzAynz
FIYxW3sJksbV6GRKXJMPF8enabHXZucOUOW4N95rK5T7rbA1aDvYRa/nvVQ7
bQz2huK90B4NEatTggCQnXEfGUrAJY3ZxmrmtIUtB2mzwZ2MmArRE0KaXrgg
oc9AmjVy5mBzVNJz5rlAL3faglKvO4dBxY6jhdeX2uyiJjkQZ1snNxV1dEzU
tnZdjpXmRRK6IKFfC1nBoGJQZ8o4gf2F/Zo3IzGuYVLUdeGTVK9qnmpzVvjK
hDmjtUb1FTrXTXavrfVZPEgIa0w4hSZhKY1Vos+gX1hs/+15KM+37NyStCry
vKjp2KGJf/HNezcz3EZUuxlz0mg5Lh+Pyw0uD+lKVoOo6lcVBnEjV3i15XNy
wlLCD38o42zpNkuF07ZdSzsVqs89bQ92hPkgZq2mrsTrpJEbDMMTJLVQirW5
S7Jq8bZIB7iDwGfEJ9wcZFf4s6CcMzaOI/eXnFU0SwoqJslapM4666zhXNAG
GxPKuJitFQleX61UepY0B4PCEsJiwMMk3PJT9WcnArdfss7ljUu4kWW85S1u
8SLS9SmBvo5mWjWmK3eY1j4su1wdewLFRHcpjjI67w7TLFovFxf6KQMwZ84m
/4q/LIDC+mchF708D/lSL/XP6zdfbpCP
            "], {{0, 19}, {52, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{52, 19},
          PlotRange->{{0, 52}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{56, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5c9f2f1a-1e16-4995-badc-d014103b124d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVKGO3DAUjFpSWKlf0B8IKigNLIp0VVnInXo5lVyju0pVaFhgWJhRUFBQ
UFTJKMTExMQgJMTAIMTAYPuevclm99TqQFV0T8ruOh7PG49n/f7m+1X6KgiC
xzfwcXX9M3p4uM4/v4XBl/vHb3f3t18/3f+4vbt9+HjzGl6+g+cDPPj78FIv
9Z/LqHHo2q4fxfx00uqJ9jgrlNleMdq3bccmvcH0xOFV2w2TtucECwPytt+D
PS3nctnjZu76ULk2svMQB1ih+4xLuqdeRBPsqhHmYETu4HGEX8UwAYyR1L3z
HNEwrxx2KqPTTN5P3osui3zP8SjOMpLtVASEa6etj8JCOrIBiaLxtBldIUcu
cR+6LWuQtrAKMc6DAVSGlT4YEgVxzdyKMYHpivn1MyKCFtltl0PfzIkzAynz
FIYxW3sJksbV6GRKXJMPF8enabHXZucOUOW4N95rK5T7rbA1aDvYRa/nvVQ7
bQz2huK90B4NEatTggCQnXEfGUrAJY3ZxmrmtIUtB2mzwZ2MmArRE0KaXrgg
oc9AmjVy5mBzVNJz5rlAL3faglKvO4dBxY6jhdeX2uyiJjkQZ1snNxV1dEzU
tnZdjpXmRRK6IKFfC1nBoGJQZ8o4gf2F/Zo3IzGuYVLUdeGTVK9qnmpzVvjK
hDmjtUb1FTrXTXavrfVZPEgIa0w4hSZhKY1Vos+gX1hs/+15KM+37NyStCry
vKjp2KGJf/HNezcz3EZUuxlz0mg5Lh+Pyw0uD+lKVoOo6lcVBnEjV3i15XNy
wlLCD38o42zpNkuF07ZdSzsVqs89bQ92hPkgZq2mrsTrpJEbDMMTJLVQirW5
S7Jq8bZIB7iDwGfEJ9wcZFf4s6CcMzaOI/eXnFU0SwoqJslapM4666zhXNAG
GxPKuJitFQleX61UepY0B4PCEsJiwMMk3PJT9WcnArdfss7ljUu4kWW85S1u
8SLS9SmBvo5mWjWmK3eY1j4su1wdewLFRHcpjjI67w7TLFovFxf6KQMwZ84m
/4q/LIDC+mchF708D/lSL/XP6zdfbpCP
              "], {{0, 19}, {52, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {52, 19}, 
            PlotRange -> {{0, 52}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aeef4361-39c1-4fab-802d-c58fe9860777"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x23.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"43adae54-d2af-4983-b6da-39170e831740"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7d372ea4-0956-4d13-b0c2-4af0e6fe12da"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0554379f-3709-46ff-b06a-ec5de6219707"],

Cell["Make a list of the first 100 primes modulo 4.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"7093a364-fadb-4120-b8e5-5b26a12acf96"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2c730efe-b93f-4316-bce1-0db815de7ab6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnaFv42YYxr2NDO5f2D9gPDjDoUo3jYXcac1ppIt6k6bQMEOzsKCgoKCg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            "], {{0, 
            64}, {452, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{452, 64},
          PlotRange->{{0, 452}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{456, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5a75d224-5cc1-4277-9004-05acffd979e5"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnaFv42YYxr2NDO5f2D9gPDjDoUo3jYXcac1ppIt6k6bQMEOzsKCgoKCg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              "], {{0, 
              64}, {452, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {452, 64}, 
            PlotRange -> {{0, 452}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"46a38eaf-6d8d-44d0-86d2-987227048ab2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x23.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5aa88f68-a5cb-411d-904d-1f022394cfc9"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0df8b315-e04d-4df9-b5e8-3893b7b55319"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c1fc5b4d-16f8-4f93-96b9-aab7a56a0447"],

Cell["\<\
Make a list of the first 10000 primes modulo 4, multiply them by 90\[Degree] \
and create an angle path from them.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+23.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"72c38126-5727-4087-8b29-4fd45257e38c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"55c8f726-4608-4f66-95f1-496720c32796"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsnXe4FEXTxRsEEURARVGJAiogSbJkySiSQbJkQck5B8kgUSQHCRINgCCK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            "], {{0, 432}, {139, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{139, 432},
          PlotRange->{{0, 139}, {0, 432}}]], "ExerciseOutput",
         ImageSize->{143, 432},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8750cb27-a194-4c8d-b5d8-a7d289e73884"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsnXe4FEXTxRsEEURARVGJAiogSbJkySiSQbJkQck5B8kgUSQHCRINgCCK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              "], {{0, 432}, {139, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {139, 432}, 
            PlotRange -> {{0, 139}, {0, 432}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1a3f25dc-3903-44bf-9c32-b68c5c12953b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x23.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1add21d4-1df0-46ed-be32-20e4d25bb5b1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"60e64b41-5c58-449e-837b-768b59e3b8fb"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"09c2e241-ceb0-41e3-b2c6-bb621e4d2bcf"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"More about Numbers: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 23  More about Numbers", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
23-more-about-numbers.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+23.1", "23.1", "23.10", "23.11", "23.12", "23.13", "23.14", "+23.2",
          "23.2", "+23.3", "23.3", "+23.4", "23.4", "23.5", "23.6", "23.7", 
         "23.8", "23.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+23.1", "23.1", "23.10", "23.11", "23.12", "23.13", "23.14", "+23.2", 
      "23.2", "+23.3", "23.3", "+23.4", "23.4", "23.5", "23.6", "23.7", 
      "23.8", "23.9"}, "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[62330, 1098, 813, 26, 
  70, "Input", "ExpressionUUID" -> "12d1d587-db26-4eaa-80aa-f4168fba2cc8",
   CellTags->"FirstInputCell"],
  Cell[77303, 1427, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6b6777d0-3e5c-4e64-a6f7-3722282f10ae",
   CellTags->"FirstInputCell"],
  Cell[95079, 1809, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f5bf58d5-6f62-4b51-b5ff-6a37c8c452be",
   CellTags->"FirstInputCell"],
  Cell[187343, 3409, 813, 26, 
  70, "Input", "ExpressionUUID" -> "919ff578-a976-41f5-9f4b-f6d8c5a98a4a",
   CellTags->"FirstInputCell"],
  Cell[196706, 3654, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2b2184d2-ef0b-4a3b-ace1-fe3648077df6",
   CellTags->"FirstInputCell"],
  Cell[268020, 4914, 813, 26, 
  70, "Input", "ExpressionUUID" -> "670363e6-bb59-4abc-a6cc-e14586c77ede",
   CellTags->"FirstInputCell"],
  Cell[279454, 5187, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ae3a07ee-f21a-47f3-8f63-1b07fcdef09d",
   CellTags->"FirstInputCell"],
  Cell[336718, 6218, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6e616ebc-00fa-4b5c-a455-d03076a83fcd",
   CellTags->"FirstInputCell"],
  Cell[481766, 8682, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2aefeb57-0b71-47c8-9c72-d3044b95098d",
   CellTags->"FirstInputCell"],
  Cell[500993, 9088, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a182aa6a-47a7-4ca1-a711-141d57a057e9",
   CellTags->"FirstInputCell"],
  Cell[551255, 9997, 813, 26, 
  70, "Input", "ExpressionUUID" -> "38b912f3-f6bf-48fd-822e-dcd8940df042",
   CellTags->"FirstInputCell"],
  Cell[561259, 10248, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ac96ac81-a015-4fa4-882c-14eb00312fff",
   CellTags->"FirstInputCell"],
  Cell[577672, 10609, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f299c553-3a31-4ee8-a91a-b93757a53f85",
   CellTags->"FirstInputCell"],
  Cell[614256, 11300, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f4e1cd59-7625-41d2-8110-2ac62ba83395",
   CellTags->"FirstInputCell"],
  Cell[628075, 11614, 813, 26, 
  70, "Input", "ExpressionUUID" -> "36306669-b85c-4781-8513-f2d74ae7d637",
   CellTags->"FirstInputCell"],
  Cell[635868, 11826, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7d372ea4-0956-4d13-b0c2-4af0e6fe12da",
   CellTags->"FirstInputCell"],
  Cell[645660, 12070, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0df8b315-e04d-4df9-b5e8-3893b7b55319",
   CellTags->"FirstInputCell"],
  Cell[725296, 13461, 813, 26, 
  70, "Input", "ExpressionUUID" -> "60e64b41-5c58-449e-837b-768b59e3b8fb",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 784295, 14681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[641, 22, 555, 16, 70, "Exercise", "ExpressionUUID" -> \
"7bf8e880-a636-4171-a32f-a7de3551033e",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1221, 42, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f4edd52f-b6a1-4fd1-a655-d29569e35596"],
Cell[1860, 63, 59863, 1010, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e2c3e808-b909-46b5-9c0e-a29f2c66d1f9"]
}, Closed]],
Cell[CellGroupData[{
Cell[61760, 1078, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"9b150c66-34b4-4fe7-b5ec-327cde8e2a51"],
Cell[62330, 1098, 813, 26, 70, "Input", "ExpressionUUID" -> \
"12d1d587-db26-4eaa-80aa-f4168fba2cc8",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63180, 1129, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e84d5398-c877-4564-accd-c681d514eb11"],
Cell[63467, 1140, 481, 10, 70, "Exercise", "ExpressionUUID" -> \
"fe4f04e7-d83d-47ad-9f79-2920f1b5f360",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[63973, 1154, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"bb6f23d9-3bb1-4046-b303-9a69fd3d246c"],
Cell[64632, 1176, 12064, 226, 70, "ExerciseOutput", "ExpressionUUID" -> \
"814e050d-75c8-4bc8-83b9-8a0c6477799c"]
}, Closed]],
Cell[CellGroupData[{
Cell[76733, 1407, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d4053647-0720-4e5c-882b-7c70eb7358d4"],
Cell[77303, 1427, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6b6777d0-3e5c-4e64-a6f7-3722282f10ae",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78165, 1459, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"bc4e5dfa-d494-496a-854b-0a9988511938"],
Cell[78452, 1470, 613, 18, 70, "Exercise", "ExpressionUUID" -> \
"6c716997-31c7-40e5-8bd6-b367a6394642",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[79090, 1492, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"cddc2de8-ffb4-4d14-9114-f076dd8c6530"],
Cell[79749, 1514, 14723, 270, 70, "ExerciseOutput", "ExpressionUUID" -> \
"53fe4fdc-2f23-4e72-bf78-a377865316f9"]
}, Closed]],
Cell[CellGroupData[{
Cell[94509, 1789, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"354ceec6-0f3a-48df-b637-3b83592bcc6b"],
Cell[95079, 1809, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f5bf58d5-6f62-4b51-b5ff-6a37c8c452be",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95941, 1841, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fa13738a-d3f6-40fa-8c37-aa866d6bdcff"],
Cell[96228, 1852, 588, 15, 70, "Exercise", "ExpressionUUID" -> \
"85ca8bc6-a8c8-4861-8b02-9c57089caf01",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[96841, 1871, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"439f2940-8cf9-4ced-b792-95d9cf242541"],
Cell[97500, 1893, 89236, 1491, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2daa627b-ebe5-45d6-9ad6-aedf86fbd362"]
}, Closed]],
Cell[CellGroupData[{
Cell[186773, 3389, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"dd9cf8c2-8f0e-4c1c-8a7d-03d80ebd7e05"],
Cell[187343, 3409, 813, 26, 70, "Input", "ExpressionUUID" -> \
"919ff578-a976-41f5-9f4b-f6d8c5a98a4a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[188205, 3441, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c0d1df91-63ae-4961-8c2a-7cb8d9352aa8"],
Cell[188492, 3452, 759, 22, 70, "Exercise", "ExpressionUUID" -> \
"86e75ce7-3499-4933-bee7-2fa6ef1bbf15",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[189276, 3478, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f509fe8e-3a16-4ab2-9a91-c8b64bfebe83"],
Cell[189915, 3499, 6184, 130, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2e588593-a5ab-4027-9fcc-6afe215bb239"]
}, Closed]],
Cell[CellGroupData[{
Cell[196136, 3634, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2e35b04b-b03c-4a23-8859-798a0f6d6321"],
Cell[196706, 3654, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2b2184d2-ef0b-4a3b-ace1-fe3648077df6",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[197568, 3686, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"45db9c88-5ca9-4919-9dc0-fbd6503eb2dd"],
Cell[197855, 3697, 764, 22, 70, "Exercise", "ExpressionUUID" -> \
"fcbdd8bf-9c06-471c-9488-c6fccecd6da4",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[198644, 3723, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"aabeb0ea-a165-4816-9d79-a588f9a0ae77"],
Cell[199283, 3744, 68130, 1145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5c3b77f5-e90a-4173-8e32-77ab7920c346"]
}, Closed]],
Cell[CellGroupData[{
Cell[267450, 4894, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"efcfe610-6409-4f6c-94f7-a3cc09805e8b"],
Cell[268020, 4914, 813, 26, 70, "Input", "ExpressionUUID" -> \
"670363e6-bb59-4abc-a6cc-e14586c77ede",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[268882, 4946, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ab6d202c-5cde-4874-a132-611bf2cc2ba1"],
Cell[269169, 4957, 459, 11, 70, "Exercise", "ExpressionUUID" -> \
"a359a1ab-9c7f-49ad-bd3a-c1455d6142a4",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[269653, 4972, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a7d6eaf5-5aff-495b-b316-f73b6797c6e3"],
Cell[270292, 4993, 8555, 169, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aba300bc-900d-437a-9e35-74463d0680e0"]
}, Closed]],
Cell[CellGroupData[{
Cell[278884, 5167, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"95f832b3-6fa6-4139-875d-b82130f7f33e"],
Cell[279454, 5187, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ae3a07ee-f21a-47f3-8f63-1b07fcdef09d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[280316, 5219, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"dc3fafb3-dcb1-4542-b11a-261fced41de3"],
Cell[280603, 5230, 874, 25, 70, "Exercise", "ExpressionUUID" -> \
"b8e2b4ca-174d-42b1-976c-4651ca7cf35a",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[281502, 5259, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8d84dddd-cf7d-4145-96c6-3e836b69f940"],
Cell[282141, 5280, 53970, 913, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e767c108-e53b-4e0b-b26a-b291bfd445ed"]
}, Closed]],
Cell[CellGroupData[{
Cell[336148, 6198, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0e268abc-e6e6-4818-9e06-4e14585f0e3e"],
Cell[336718, 6218, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6e616ebc-00fa-4b5c-a455-d03076a83fcd",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[337580, 6250, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"de60bf05-0e5f-4f5c-997c-824fd564a615"],
Cell[337867, 6261, 562, 13, 70, "Exercise", "ExpressionUUID" -> \
"51582849-574b-4270-aa70-15e50f57ad7d",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[338454, 6278, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"23999dec-e1d8-4a3f-82c8-1b6632f0a573"],
Cell[339113, 6300, 142046, 2357, 70, "ExerciseOutput", "ExpressionUUID" -> \
"70b1cfc7-b38f-4363-bb32-67ba25b7ef4d"]
}, Closed]],
Cell[CellGroupData[{
Cell[481196, 8662, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"fc085a18-6fae-45ae-9974-e8781450652c"],
Cell[481766, 8682, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2aefeb57-0b71-47c8-9c72-d3044b95098d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[482628, 8714, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0daebb29-9564-4f0e-8714-cb6e1fed53c6"],
Cell[482915, 8725, 810, 22, 70, "Exercise", "ExpressionUUID" -> \
"ebadb4fb-db6a-4b05-a1de-3ee4ebbbc914",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[483750, 8751, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9e476ef0-42f3-4c8f-b967-30249218c7df"],
Cell[484389, 8772, 15996, 291, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6a1a7e17-1406-4aee-a107-e8acbb113279"]
}, Closed]],
Cell[CellGroupData[{
Cell[500422, 9068, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"9cef1c6f-9e85-4dcc-808b-291905ffcb72"],
Cell[500993, 9088, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a182aa6a-47a7-4ca1-a711-141d57a057e9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[501855, 9120, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6779772a-828d-421c-9b24-60ff44c93b85"],
Cell[502142, 9131, 467, 11, 70, "Exercise", "ExpressionUUID" -> \
"55d2e452-8d33-4737-bc76-0be3b351a7d2",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[502634, 9146, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8a284f5f-310e-47c7-9972-5e990c63bd07"],
Cell[503273, 9167, 47374, 805, 70, "ExerciseOutput", "ExpressionUUID" -> \
"09432bfb-5b99-4f1b-ab7d-fcc51ac0da80"]
}, Closed]],
Cell[CellGroupData[{
Cell[550684, 9977, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"9dc6bb52-99de-4602-a220-dce329938c00"],
Cell[551255, 9997, 813, 26, 70, "Input", "ExpressionUUID" -> \
"38b912f3-f6bf-48fd-822e-dcd8940df042",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[552117, 10029, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "b5eb1d13-b28a-4581-9b80-20eb47e59d2d"],
Cell[552404, 10040, 534, 13, 70, "Exercise", "ExpressionUUID" -> \
"f98eb757-a865-4569-8989-b8ae4313fa63",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[552963, 10057, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "8e215f0d-d6aa-4d38-8327-a56264af3c7c"],
Cell[553622, 10079, 7029, 144, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5c32d941-5293-447b-aea5-17c529b579a9"]
}, Closed]],
Cell[CellGroupData[{
Cell[560688, 10228, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"dace8a24-4588-43ed-9d16-fe70330c920f"],
Cell[561259, 10248, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ac96ac81-a015-4fa4-882c-14eb00312fff",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[562121, 10280, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "f678bce5-bf7a-4bac-bb10-7f1c8e0692cb"],
Cell[562408, 10291, 839, 24, 70, "Exercise", "ExpressionUUID" -> \
"936b035b-2dc1-4347-bc63-7b45ce46fda4",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[563272, 10319, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "e9216e72-9cbf-4cd9-bdb7-38ab4dd38c18"],
Cell[563911, 10340, 13153, 244, 70, "ExerciseOutput", "ExpressionUUID" -> \
"37765dc7-3cab-4369-8aaa-b758ffb716fe"]
}, Closed]],
Cell[CellGroupData[{
Cell[577101, 10589, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"1404603b-46e1-4531-9b53-c4d2ba48f6ad"],
Cell[577672, 10609, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f299c553-3a31-4ee8-a91a-b93757a53f85",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[578534, 10641, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "af955f9a-69ea-4f2a-a931-9d7f704032ac"],
Cell[578821, 10652, 918, 25, 70, "Exercise", "ExpressionUUID" -> \
"93319301-4ac6-4827-aea4-1197f07339d7",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[579764, 10681, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "1999bead-92f7-4fec-8142-dd09489b381e"],
Cell[580403, 10702, 33245, 573, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b19deaf1-0f6f-425e-a091-9af28774c63f"]
}, Closed]],
Cell[CellGroupData[{
Cell[613685, 11280, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"408749ad-434c-425c-91b4-89331b77af89"],
Cell[614256, 11300, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f4e1cd59-7625-41d2-8110-2ac62ba83395",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[615118, 11332, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "83408ed9-374e-4e02-854a-fa26580a5b4a"],
Cell[615405, 11343, 517, 14, 70, "Exercise", "ExpressionUUID" -> \
"2770d444-092e-451d-83d0-8c22d43d5bd8",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[615947, 11361, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "c8030c48-31ee-48d7-9708-dc601fcb69db"],
Cell[616586, 11382, 10881, 207, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aa006fa0-48c7-4c32-a53f-dca9317a4235"]
}, Closed]],
Cell[CellGroupData[{
Cell[627504, 11594, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"352bcbec-2f78-447f-8bc1-cba1a5e29270"],
Cell[628075, 11614, 813, 26, 70, "Input", "ExpressionUUID" -> \
"36306669-b85c-4781-8513-f2d74ae7d637",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[628937, 11646, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "edcdc600-126d-436c-8954-7b494228fcbd"],
Cell[629224, 11657, 431, 9, 70, "Exercise", "ExpressionUUID" -> \
"52358df3-fc70-47c6-bccd-23332fad1673",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[629680, 11670, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "33c4c1a8-7a07-4f23-905b-e922fc4dca1f"],
Cell[630319, 11691, 4941, 110, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aeef4361-39c1-4fab-802d-c58fe9860777"]
}, Closed]],
Cell[CellGroupData[{
Cell[635297, 11806, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"43adae54-d2af-4983-b6da-39170e831740"],
Cell[635868, 11826, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7d372ea4-0956-4d13-b0c2-4af0e6fe12da",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[636730, 11858, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "0554379f-3709-46ff-b06a-ec5de6219707"],
Cell[637017, 11869, 431, 9, 70, "Exercise", "ExpressionUUID" -> \
"7093a364-fadb-4120-b8e5-5b26a12acf96",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[637473, 11882, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "2c730efe-b93f-4316-bce1-0db815de7ab6"],
Cell[638112, 11903, 6940, 142, 70, "ExerciseOutput", "ExpressionUUID" -> \
"46a38eaf-6d8d-44d0-86d2-987227048ab2"]
}, Closed]],
Cell[CellGroupData[{
Cell[645089, 12050, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"5aa88f68-a5cb-411d-904d-1f022394cfc9"],
Cell[645660, 12070, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0df8b315-e04d-4df9-b5e8-3893b7b55319",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[646522, 12102, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "c1fc5b4d-16f8-4f93-96b9-aab7a56a0447"],
Cell[646809, 12113, 508, 12, 70, "Exercise", "ExpressionUUID" -> \
"72c38126-5727-4087-8b29-4fd45257e38c",
 CounterAssignments->{{"SectionNumber", 23}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[647342, 12129, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "55c8f726-4608-4f66-95f1-496720c32796"],
Cell[647981, 12150, 76707, 1286, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1a3f25dc-3903-44bf-9c32-b68c5c12953b"]
}, Closed]],
Cell[CellGroupData[{
Cell[724725, 13441, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"1add21d4-1df0-46ed-be32-20e4d25bb5b1"],
Cell[725296, 13461, 813, 26, 70, "Input", "ExpressionUUID" -> \
"60e64b41-5c58-449e-837b-768b59e3b8fb",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[726136, 13491, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "09c2e241-ceb0-41e3-b2c6-bb621e4d2bcf"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 2Sc3@a5afggcFkIjmx@WDE80 *)
