(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    459142,       9633]
NotebookOptionsPosition[    380754,       7969]
NotebookOutlinePosition[    441504,       9218]
CellTagsIndexPosition[    441425,       9213]
WindowTitle->Dates and Times: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Compute how many days have elapsed since January 1, 1900.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"faa79338-0a1e-4df9-a7a8-b5e8f1a9ab73"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"948dd963-3acf-41c6-817e-e974d5d32344"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVs2L6lYUH9pNl1113/+i265Kt6/pVniPTt+UwBQnhaIbdSEuBHEhA5LF
ZOG4CIMyBFQIg4qooBDLBAyEIaioBMkwUYxEDKT33Hz4NbSlnc2jHjTcnJx7
7vmdc34n+frDr+9+/uzs7Iz6Al3evf/926ur96EfvkQ3P15Sv3y8PP/p+8vf
zj+eX33z4XOk/Ar9v0N/WNsnOclJPFlNJVnR3tSlPuyL6tx0bhZTqftQatSb
6nxzbKrJQvuh1H18WvsqSxNbpeoDr8zMrW4+6NVL7ZagGf8oAjkXiJD04j+h
2BOJDUZIIp4TwDkXResIFYAredGb7eIye7kLpE/G4BrJ8BjXuBAmsDH6Bdoj
wLVWSnF8i5VB8fmV5ByIUryIUPnVGyFaj0pOSOmiiMLmw87CtufCNYqfFbem
hpAkCbajouXikUExS4atdVJob2OEwh7fIj8p3rLNagylhYZmMiQapeum81cB
GJCHIRfcB7VBeuvvw9+sDPNIqRYoIhIOXVNu/Jahe3215A5BiQjUraDD2pKS
AGrTzqDtbjDDSihCRofmshwm4t7GIYeUmVfZYj2LbAyXmArRYc+PqXaLKbf0
VLQ3Na1ZM01eNJSls2sl38fJqGLYL/37pGfWVnTfrQInEt2pinIb340f42XJ
A6XGJ/BByliCLk2p1rJMbYGv5TzqWMnQkdLfqHUyWHkMacBASKGGIEp1Bto1
BqCsKR8ng1VBmihNBiU8drfGkUSyNWdf7wbFkF9YT6gH0mxTmw0auQQnqK7X
KY8Q3bbgFnVdsvi0eybGG+juccpW6wmPPkS6MkDVREXxQa0wKNmw5SKQlMnl
uZsQNg7JR6BWMmpgoqq4zTM84JSpqyOJzwRQ+RbuuUFwgrEw9bFtSmmU88zd
8Hm3/ZY8Lj2TYzg2k8aMLnfGXnppwFsf7IaxVu4gDFmzjEE1C2G3p/prlYKY
lNY9m00VuJoMroLyUeO/CHBEb+7l0AdlDrgUTJh4LATlc3tSQgRnWtpa8Y+w
F0qNpnCGw4ne1GlOU6zkuWKeYxEoOg1Pg7wAoFSMiOakgzCAy2TGS6ZeAMb9
0QVO3Tk0nFSiwKl9eveyW4O9SvWZ3bb0QcGCDEoYrLozPSQ082M0nw3gWbTj
ZyayiI8UczQ5N7j9AMWknsENkxBlSe4L0qO08FxgdhCFurQyzYmQh/WjhluO
YOvSy6h57Q264UOGzvGT2VisAOULgma71Q80Rl7NnptQiAQzfNaUFuMUBXWa
zCJQUXmmq/1SmtxOIXtWw68JgnuEmYCmx3U40VXUtak1Mq+CAmqkoTR6efvS
cX67HN+Ixaj/iC52HLjuqw2YzqhYNazTvtltxW1OXEeiLC99d2qH8cyCdAxm
wgpeMXzSO5pFlPRB2WYjBdmeOKfOpUIi4G9vK1u3/0YsczXXV/scWRv6Yr60
9s0WyGxPtVnNj462lsjsqDlh7/rwLaVzlPuFsN19fO4nIxtFqJWzF8fT+BMW
awDfKlSw2n/bL96TnOQk/0f5Ezszkj0=
            "], {{0, 22}, {71, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{71, 22},
          PlotRange->{{0, 71}, {0, 22}}]], "ExerciseOutput",
         ImageSize->{75, 22},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ee31e59e-6cc6-43cf-9293-f530dc59c75c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVs2L6lYUH9pNl1113/+i265Kt6/pVniPTt+UwBQnhaIbdSEuBHEhA5LF
ZOG4CIMyBFQIg4qooBDLBAyEIaioBMkwUYxEDKT33Hz4NbSlnc2jHjTcnJx7
7vmdc34n+frDr+9+/uzs7Iz6Al3evf/926ur96EfvkQ3P15Sv3y8PP/p+8vf
zj+eX33z4XOk/Ar9v0N/WNsnOclJPFlNJVnR3tSlPuyL6tx0bhZTqftQatSb
6nxzbKrJQvuh1H18WvsqSxNbpeoDr8zMrW4+6NVL7ZagGf8oAjkXiJD04j+h
2BOJDUZIIp4TwDkXResIFYAredGb7eIye7kLpE/G4BrJ8BjXuBAmsDH6Bdoj
wLVWSnF8i5VB8fmV5ByIUryIUPnVGyFaj0pOSOmiiMLmw87CtufCNYqfFbem
hpAkCbajouXikUExS4atdVJob2OEwh7fIj8p3rLNagylhYZmMiQapeum81cB
GJCHIRfcB7VBeuvvw9+sDPNIqRYoIhIOXVNu/Jahe3215A5BiQjUraDD2pKS
AGrTzqDtbjDDSihCRofmshwm4t7GIYeUmVfZYj2LbAyXmArRYc+PqXaLKbf0
VLQ3Na1ZM01eNJSls2sl38fJqGLYL/37pGfWVnTfrQInEt2pinIb340f42XJ
A6XGJ/BByliCLk2p1rJMbYGv5TzqWMnQkdLfqHUyWHkMacBASKGGIEp1Bto1
BqCsKR8ng1VBmihNBiU8drfGkUSyNWdf7wbFkF9YT6gH0mxTmw0auQQnqK7X
KY8Q3bbgFnVdsvi0eybGG+juccpW6wmPPkS6MkDVREXxQa0wKNmw5SKQlMnl
uZsQNg7JR6BWMmpgoqq4zTM84JSpqyOJzwRQ+RbuuUFwgrEw9bFtSmmU88zd
8Hm3/ZY8Lj2TYzg2k8aMLnfGXnppwFsf7IaxVu4gDFmzjEE1C2G3p/prlYKY
lNY9m00VuJoMroLyUeO/CHBEb+7l0AdlDrgUTJh4LATlc3tSQgRnWtpa8Y+w
F0qNpnCGw4ne1GlOU6zkuWKeYxEoOg1Pg7wAoFSMiOakgzCAy2TGS6ZeAMb9
0QVO3Tk0nFSiwKl9eveyW4O9SvWZ3bb0QcGCDEoYrLozPSQ082M0nw3gWbTj
ZyayiI8UczQ5N7j9AMWknsENkxBlSe4L0qO08FxgdhCFurQyzYmQh/WjhluO
YOvSy6h57Q264UOGzvGT2VisAOULgma71Q80Rl7NnptQiAQzfNaUFuMUBXWa
zCJQUXmmq/1SmtxOIXtWw68JgnuEmYCmx3U40VXUtak1Mq+CAmqkoTR6efvS
cX67HN+Ixaj/iC52HLjuqw2YzqhYNazTvtltxW1OXEeiLC99d2qH8cyCdAxm
wgpeMXzSO5pFlPRB2WYjBdmeOKfOpUIi4G9vK1u3/0YsczXXV/scWRv6Yr60
9s0WyGxPtVnNj462lsjsqDlh7/rwLaVzlPuFsN19fO4nIxtFqJWzF8fT+BMW
awDfKlSw2n/bL96TnOQk/0f5Ezszkj0=
              "], {{0, 22}, {71, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {71, 22}, 
            PlotRange -> {{0, 71}, {0, 22}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ace78a9a-9c02-4ede-98b1-9da83d965a32"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"07898586-2279-4ad3-a975-0626160ec555"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e10e57bc-28ca-4153-a0fc-d52692c72907"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"eb5bfcda-88bc-4405-96d1-c58387cf72a8"],

Cell["Compute what day of the week January 1, 2000 was.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"153a388d-e5d0-4c4e-8b1c-811726afdf9a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3905c5ab-927a-43b6-abb9-eafb92d7c16b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVSFv3TAQtjYyOGm/YH/AbNKo4ZClTmUhrVZXI13UTppMHwsMCwsyCgoK
CgkKMQkxCQgJCQgwCTDIzk7yXpr32umpmzTQkxLZzvm7z3efLx+vf1ywNwih
h3fwurj6Re7vr/jX9zC5vHv4fnt38+3L3c+b25v7z9dvYfEDPJ/gsePx1V7t
79igpGx6c+4umUY+8xjjcSb1M45m0MO54CvTJUYoKPuzuGUcNiHqc84oDBBL
hqfgZYgQefYAz4eSECCU59DTJQFGQk2zrhBCdvuPZniULqMiS+8p9lsyw3qr
Huz+Db0N/il6Euj5ab3FbmXoE+SMcNGZUSUcLYaZ0OOQcsLiavJvUu4WQV6C
sihPdtYvKO2nIp6AMLFlihy9Y3zT5hSRRM210ZXAiIFj4jsfPyxUu6dXC4a8
oFS1zKCgiGetbhUo1MZM8kLWZtQRRjiUk78MCUy0hY1cTCryvFSdrmJ3nKis
ZBJ4aMneMf44tjs3mgBzmOBoYlqIYD4J9vPmUDzdtUpmDMiH5VJcWs3V0BGB
9ZleBRMc7ekJNYGY1B6IN3Mtq01xN/iN9aZW20YxW9NmXc+6FPZu4ADE11cJ
nbLg2SNTR8OF3l8NRy+qTtGjiz61ReT5EsEKaaJ3En8cKpj4WTc4kZfaqaA9
XMXW8idF3wXIsp8+CDIXcaa3hI4hAEvNCXqHI1gfEg3b7J3GBysDjGgQQzNx
yE3CrGOUqqYBHfh4yp7djnna6a6I/UP2bGNBQtZNA1p2ekNeplqVO72RY3pT
vRAXZdc1yY6iFb1jfJegDLushnN77HMneLTcotJGHmW8LFIeMDxrbKh3s0Y9
BXejTuniFIZsRY+ueqNOd3S579xbinsa38WYElav+40ZejD9qKMZbZfGrRlY
PXQ0o7uu/2MjHE5BPYHfh9AQXEf6z8xURRZxKA/O2hf8Ov+Rmdr2fUzXv61X
e4n9Bpo+2vs=
            "], {{0, 19}, {53, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{53, 19},
          PlotRange->{{0, 53}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{57, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d8e5a464-9a8d-4ef5-ac30-3f533ba27a0c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVSFv3TAQtjYyOGm/YH/AbNKo4ZClTmUhrVZXI13UTppMHwsMCwsyCgoK
CgkKMQkxCQgJCQgwCTDIzk7yXpr32umpmzTQkxLZzvm7z3efLx+vf1ywNwih
h3fwurj6Re7vr/jX9zC5vHv4fnt38+3L3c+b25v7z9dvYfEDPJ/gsePx1V7t
79igpGx6c+4umUY+8xjjcSb1M45m0MO54CvTJUYoKPuzuGUcNiHqc84oDBBL
hqfgZYgQefYAz4eSECCU59DTJQFGQk2zrhBCdvuPZniULqMiS+8p9lsyw3qr
Huz+Db0N/il6Euj5ab3FbmXoE+SMcNGZUSUcLYaZ0OOQcsLiavJvUu4WQV6C
sihPdtYvKO2nIp6AMLFlihy9Y3zT5hSRRM210ZXAiIFj4jsfPyxUu6dXC4a8
oFS1zKCgiGetbhUo1MZM8kLWZtQRRjiUk78MCUy0hY1cTCryvFSdrmJ3nKis
ZBJ4aMneMf44tjs3mgBzmOBoYlqIYD4J9vPmUDzdtUpmDMiH5VJcWs3V0BGB
9ZleBRMc7ekJNYGY1B6IN3Mtq01xN/iN9aZW20YxW9NmXc+6FPZu4ADE11cJ
nbLg2SNTR8OF3l8NRy+qTtGjiz61ReT5EsEKaaJ3En8cKpj4WTc4kZfaqaA9
XMXW8idF3wXIsp8+CDIXcaa3hI4hAEvNCXqHI1gfEg3b7J3GBysDjGgQQzNx
yE3CrGOUqqYBHfh4yp7djnna6a6I/UP2bGNBQtZNA1p2ekNeplqVO72RY3pT
vRAXZdc1yY6iFb1jfJegDLushnN77HMneLTcotJGHmW8LFIeMDxrbKh3s0Y9
BXejTuniFIZsRY+ueqNOd3S579xbinsa38WYElav+40ZejD9qKMZbZfGrRlY
PXQ0o7uu/2MjHE5BPYHfh9AQXEf6z8xURRZxKA/O2hf8Ov+Rmdr2fUzXv61X
e4n9Bpo+2vs=
              "], {{0, 19}, {53, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {53, 19}, 
            PlotRange -> {{0, 53}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"eed66d4c-ae2f-4af2-a1a8-6ecb39b02315"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9beefff5-5b44-4c05-9d98-4aa6760ddfb2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7d7877dc-44a4-49d8-8ac9-efa5c84a6a27"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c9589821-04b3-4fad-9429-eabb676690f2"],

Cell["Find the date a hundred thousand days ago.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"b0a8aa41-defe-41e2-ae36-d1809288f350"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9e359aa7-889b-4341-9cc2-212890026827"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm+9PG8kZx6P2TV/2dd/1v+jb8q4XqbSpTsKvKoemJyOUCl/Ug5YKq8hI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            "], {{0, 26}, {204, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{204, 26},
          PlotRange->{{0, 204}, {0, 26}}]], "ExerciseOutput",
         ImageSize->{208, 26},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a48db86a-0ef3-4b75-97fa-8bb14683caca"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztm+9PG8kZx6P2TV/2dd/1v+jb8q4XqbSpTsKvKoemJyOUCl/Ug5YKq8hI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              "], {{0, 26}, {204, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {204, 26}, 
            PlotRange -> {{0, 204}, {0, 26}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8fa3147e-62ba-4eb2-bb82-701d6d576b0c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c5450494-a4f7-4a2e-ba9f-19daa19860e2"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f80bc7a6-b73b-4c23-9ca8-c58fc7178778"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"19b58f5a-2d62-49d3-a6db-9f7a23aacaf1"],

Cell["Find the local time in Delhi.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"5689c1b2-936f-45e1-b8ed-dc4836de8013"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a39ef746-4c3f-4da4-b75d-d06708e015ee"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm99vGtkVx6P2pY997lv/i32t37qR6jbVSuGpIjRdgVAqs1YXt1RGtcZS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            "], {{0, 26}, {208, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{208, 26},
          PlotRange->{{0, 208}, {0, 26}}]], "ExerciseOutput",
         ImageSize->{212, 26},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "575dea0a-2fb3-41e5-853d-d165dc94ad9f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztm99vGtkVx6P2pY997lv/i32t37qR6jbVSuGpIjRdgVAqs1YXt1RGtcZS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              "], {{0, 26}, {208, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {208, 26}, 
            PlotRange -> {{0, 208}, {0, 26}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac547782-c295-45ec-b5aa-2a805125c211"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bff72663-f68c-4867-a89f-852c4a00fdf6"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"65eb570a-0d63-45ab-b7cb-16dd5377ba91"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6414024f-4db3-487e-996a-75f663e46940"],

Cell["\<\
Find the length of daylight today by subtracting today\[CloseCurlyQuote]s \
sunrise from today\[CloseCurlyQuote]s sunset.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"964e1d0e-6085-4d7d-b44a-fe3c0056ca43"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6832eca6-5be6-4e63-93e9-bb5e77f2b5ee"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVEGL2kAYlfbSY6G/oP+iPfbY6za9CrvUriVgUQvFXLIeJAdB9iBC8VAP
dQ9BlBKwgohblm1hCxYaMBBkcGUtQZS6YkJCAtsvE6MzNgfdvfTgYyIz37zM
vLx54+ODt3uv74VCoeQD+Nnbf/8skdhPvXgIg5ex5JvDWOTV89i7yGEk8eTg
PhQfwfMUHrd/s8MO/wVsy7nT+9bkCqkK2bSJ6U051zDVN3zmn4FCM3vGFlub
bYHhWWF4B7VIjPIsQ7aMKMPK3/NePazoHnEuJRmaGZb1LaTKNaH4sT67vVKA
7Zi249iubCnOs3HVFWD+lIrlXNgfYjguDTO1KsjO1a2g1SzdXA7IfiAsfX4b
m51egWUKjd6qgCo8G1X/sW7WLYGrP0bku32Ri1Zb9RJ2PpOrDEeyyGHzuTzC
K1w2hEwefx0mS1+bC0JSUCf2Vkq11hHPHpFZMtSTIKnzL7DFh3OqpsvHOBXV
Vkdp5b2ElKRztVPJsky2Bom6QbUonyzNCHK5cYF+fYZ+1o2cD3M8RP3hgGwa
fXxXZZY5lhSyFCjVGdRhl7PftA+mu7vYGXvfAqnOfOp4E03OC78n9cRYki88
sn0mUFkyusW1u0PcF4zRKRTbAypagVIvpRTP5sdrTpsyuCd150vbfaNWfVIq
QYZ6fOH2wgtzdj2lGh147VuOZ1OIvgQWwlKp4ryZhtM/Xb8Li92n20id+lL9
+mZQRYrv6Br8bcoNAcxvdmSENF8bKYOAvqHUkrFOJjK8GdxT4FZSDXzHV221
lBvpAKmmUiCkQj69qwT9dnopFbaoGOtkXE9XNnd1hx122Ap/Ado8wQw=
            "], {{0, 
            19}, {57, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{57, 19},
          PlotRange->{{0, 57}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{61, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "52e75930-070a-45d7-8b8c-2590379b05c2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVEGL2kAYlfbSY6G/oP+iPfbY6za9CrvUriVgUQvFXLIeJAdB9iBC8VAP
dQ9BlBKwgohblm1hCxYaMBBkcGUtQZS6YkJCAtsvE6MzNgfdvfTgYyIz37zM
vLx54+ODt3uv74VCoeQD+Nnbf/8skdhPvXgIg5ex5JvDWOTV89i7yGEk8eTg
PhQfwfMUHrd/s8MO/wVsy7nT+9bkCqkK2bSJ6U051zDVN3zmn4FCM3vGFlub
bYHhWWF4B7VIjPIsQ7aMKMPK3/NePazoHnEuJRmaGZb1LaTKNaH4sT67vVKA
7Zi249iubCnOs3HVFWD+lIrlXNgfYjguDTO1KsjO1a2g1SzdXA7IfiAsfX4b
m51egWUKjd6qgCo8G1X/sW7WLYGrP0bku32Ri1Zb9RJ2PpOrDEeyyGHzuTzC
K1w2hEwefx0mS1+bC0JSUCf2Vkq11hHPHpFZMtSTIKnzL7DFh3OqpsvHOBXV
Vkdp5b2ElKRztVPJsky2Bom6QbUonyzNCHK5cYF+fYZ+1o2cD3M8RP3hgGwa
fXxXZZY5lhSyFCjVGdRhl7PftA+mu7vYGXvfAqnOfOp4E03OC78n9cRYki88
sn0mUFkyusW1u0PcF4zRKRTbAypagVIvpRTP5sdrTpsyuCd150vbfaNWfVIq
QYZ6fOH2wgtzdj2lGh147VuOZ1OIvgQWwlKp4ryZhtM/Xb8Li92n20id+lL9
+mZQRYrv6Br8bcoNAcxvdmSENF8bKYOAvqHUkrFOJjK8GdxT4FZSDXzHV221
lBvpAKmmUiCkQj69qwT9dnopFbaoGOtkXE9XNnd1hx122Ap/Ado8wQw=
              "], {{
              0, 19}, {57, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {57, 19}, 
            PlotRange -> {{0, 57}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"455c5ef1-c7f7-492d-804c-6cbcfc794722"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1b047468-a599-459a-b255-67968956c2c3"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d4821280-15af-4723-97ca-676080f9b118"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4273b3a7-6506-42d2-b254-8b13a2c617ce"],

Cell["Generate an icon for the current phase of the moon.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"a9eaa49d-b2b5-46ec-aa00-edc73b7c4cb4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f2975a44-838b-4c40-be0f-536a233c0972"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndlOI0cUhlFyk8u8Qt4it7nM7UR5gBkNGeWGSEykKI9iQjA7NvECxoBt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            "], {{0, 100}, {100, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 100},
          PlotRange->{{0, 100}, {0, 100}}]], "ExerciseOutput",
         ImageSize->{104, 100},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "331a0ce1-7e89-41d6-b3dc-f915fc05b92f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndlOI0cUhlFyk8u8Qt4it7nM7UR5gBkNGeWGSEykKI9iQjA7NvECxoBt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              "], {{0, 100}, {100, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 100}, 
            PlotRange -> {{0, 100}, {0, 100}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"613f53a9-3b44-4386-afd3-ec68ab99b010"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2fae19c0-b60e-4e04-a849-f7e47952bf08"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"98fb77e8-94b1-4751-998e-f265fd80ea8c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e43a2d90-27e4-4b34-8e90-543d5a897d58"],

Cell["\<\
Make a list of the numerical phase of the moon for each of the next 10 days.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"da8af85b-251b-4bef-9d92-988766bf62f5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1b69a55d-e4b0-49c3-86bf-b8d76fba352e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz3PpMgRxnbi0JJ/gf8AsVNCR0hnOSO5k5eTkzW6s2SRkhGSEViaiIiI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            "], {{0, 
            19}, {470, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{470, 19},
          PlotRange->{{0, 470}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{474, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3258c3b0-a349-43d3-961c-d24e175ccd29"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz3PpMgRxnbi0JJ/gf8AsVNCR0hnOSO5k5eTkzW6s2SRkhGSEViaiIiI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              "], {{0, 
              19}, {470, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {470, 19}, 
            PlotRange -> {{0, 470}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6f8b8686-f83f-44ac-8dc5-a1cdfbc30b84"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6c782bed-de7f-4412-88a5-d862b64de0aa"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6b4344ad-e164-4a76-876e-addddc69a21d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3529f094-ef97-4395-b56f-8f5f93c5e02e"],

Cell["\<\
Generate a list of icons for the moon phases from today until 10 days from \
now.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"884fe5d0-e941-46e6-9026-53b343358673"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"849591e1-81f4-4430-af94-4b85dbbac0c8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnclTHEm+55mZyxznX5h/QOe56jinMntjc6vDvGfT/WwuPWX9xmysrnXT
sW6lEkuubJksIskkQbkAIkkEYpcKUVKDVCqgoEoSopDYEvr9lNHKpjOTWHyP
yO/HrDAKxeL+iZ9HuHt4uP/Xf/m///TH/9jW1vZv/5l+/NM////bf/7zP3/9
P/4L/c///NO//Z9//dMf/vd//9P/+8O//uHP/+1f/hP98X/9h7a2Efrv0+9/
BQAAAAAAAAAAgDiOj4+3trZWVlbK5XKpVFpYWHjy5MmzQLO+vk7ZpMxSlinj
lH2SAHsugT0eBNoDMqhUKnSZiqAKqSAhsMcG7PHg1R6QBF2FpaUl3eFgFiTE
ZXDCXiOwx4N7e0Aem5ubugPBREgL7DEDezy4tAck8eHDB90hYC4kB/aYgT0e
HO0BeWxtbem+/uayvb0Ne8zAHg+O9oA8VldXdV9/cyE5sMcM7PHgaA/IY25u
Tvf1NxeSA3vMwB4PjvaAPMrlsu7rby4kB/aYgT0eHO0BeWBchA0kB/aYgT0e
HO0BeWAArQ0kB/aYgT0eHO0BefzlL3/ReOkfPHiQTqeHh4cHBgYSVfr7+/v6
+ugX+gv9nf6VttGVPJLjL3t9VWDPDY32ent7fWQPyENxZBYKhbGxMYq67u7u
jioUhPl8fnZ2dnFxcW1tbWNjY2VlZXJykrbp6ekJh8P3qkSjUfoL7UtHUJZa
08q1G3tTU1PJZJIeLrBXh6M92mBwcNAv9oA81EQmhVMmk6Fgo1CkeJuent7e
3j45ObFJ2Pn5Od0erd1zuVwqlaLneFdXF0UpPdPpaApC1JBy7dVezZsF7Lm0
t7y83Li7sfaAPGRHJj2Lh4aG6LEbj8fpiexpVpCmH8lSo4ae5p1V6Mh0fHmJ
116u2ey9e/fupgPCng0LCwv2BzTKHpCHvMikmKH2CMXP6Ojo/v4+W/LOzs5K
pVLT41OLJhaLtbe3U+tGUnxqLNec9hwHvcBeI+7HT5pgD8hDUmSOjIxQi2N8
fPzNmzecKfz1119tTpTNZq1uIjqj8FzoKtf89l68eOHmRLB3nZuevzeh1x6Q
h/DInJiY6K6yu7srKpF1HWWNpNNpKgjRaJTOLjAv6su1KHtv3751f1LYs3j4
8CHDSXXZA/IQG5mpVIqaLcvLy5eXlwITeXR05HjqQqFAzRlq1FAaRGVHcbkW
aI+OMDk56f7UsEdMTU2xnVqLPSAPUZFJgdHf309PTOYuRHscq4sWY2Nj1KKh
EBXyllBZuZZhb3Fx0WsyWtweZzIU2wPyEBKZ+Xw+Ho9nMpnT01NJ6Xzz5o3L
xORyOUoMlRH+bnA15VqSvefPnzMkpmXtUQ2TPzEq7QF58EcmPRkpDOin1HRe
XV3Nzs66T1VPT08oFKIo5cmagnItz97u7i5zqlrQXqVS4UxMDTX2gDw4I5Mu
/d27dykyFSTV6ySlfX19lDaep7bsci3VnpvOWBtazd75+TlPYupQYA/Igycy
6aJTTM7MzKhJ6u+//+41hR0dHeFwmDk4pZZr2fb4Kz8tZe/s7Iw5MU2RbQ/I
gzkyqdkSj8dlN5zrYJiRj5ozViOLIY/yyrUae576HJrSOvZOT0/ZEmODVHtA
HsyRmUgkJicnFaf2xx9/ZEhqLBYbGBhg2FFeuVZjr+mHvV5pEXsfP35kS4w9
8uwBebBFZiqVikQi9tM7yMD+O5ebyOVy1JxhGEsmqVwrs7exscGQvDpaxJ6k
BQfl2QPyYIjMiYmJzs7Ovb099am9uLjwmlqLTCbT3t7u9esDGeVapb3t7W2v
yWtKK9g7Pj72mhiXSLIH5MEQmT09PQsLC7oS7DixyU0kk8l4PO5pFxnlWqU9
nsE5dQTeHsO7PPfIsAfk4TUyR0dHY7FYpVLRleDNzU1PCa6Rz+etSVTc7yK8
XCu2537ouyOBt8c5kMkeGfaAPDxFJl3cUCj0+vVrjQnmqf9QWHZ0dLgfLCG2
XKu3J7b+E2x779+/Z7LiFuH2gDw8RebQ0FA6ndabYM6STpUNyoXLjcWWa/X2
hI/BC7A92XfFomh7QB7uI7NQKHR1dUma/ME9nIOTM5kMPbJdDiETWK612Lu6
uuJQ1YQA2zs8POQQ4wqx9oBALo7eHuzsHBxdWP/rPjKHq+hNvIX7OZObEolE
KCNuthRYrnXZm5mZ4VDVhKDas1nWQSAC7QFBHN3/5os2i2/mrD+5j8xoNLqz
s6M3AxZra2scgflpmtBQKORmS4HlWpc9zidII0G1p+auKNAeEMLJRhfdDr/4
umtubePl278NgnUZmdlsNhwOU4tMbxYs2L5wqUFNGGrIUI74I9N8e48fP+Zx
1UhQ7XmavZwZgfaAEF7Ev6Q64sE//tFlZCYSiXK5rCfdDbx+/ZozOPur8Eem
+fZcztbriUDaU3NXLIqzB4Sw9t3ttlvfHf3jH91EptXXfXh4qCfdDbB993ed
8fFxN/3eQsq1XntPnjzhdNVIIO0JHNtpjyh7QAjMd0W6jpFIRE+imyFkEAVF
JuWLMzLNtyfkU+hGgmdP2V2xKMgeEALzXXFoaCiXy+lJdDOETG/S09PjOHhM
SLnWa4+zD/Ymgmfvt99+E+TGGSH2gBCY74q9vb2bm5t6Et0MIZPJ379/3/HT
VCHlWq89UStG1RE8eyrvikLsASEw3xVDoRA1WvUk+gaYF6msMTExQQ0Zzsg0
356oaXPqCJ49lXdFIfaAENjuivl8/vvvvzdkTE4N/sHJhULBcWUN/nKt3d7L
ly85RTUlePZU3hWF2ANCWPvuC4a7Yjab7e7u1pPimxEyOLmrq8t+5Bh/udZu
76effuIX1ZSA2eMf2OAJfntABBf3/9h2685c3V8dI3NkZCSTyWhJsQ3Msyxe
Jx6PU+54ItN8ez///DO/qKYEzJ7iuyK/PSCAt9O32tq+XayrKjpHpvWyTEeK
7VhcXOSPzN7eXvtXgfzlWru9nZ0dflFNCZg9xXdFfnuAk7cv57653db2Zbz+
nugiMgcGBkqlkoZE27K0tMQfmf39/fYrDfGXa+325N0VA2ZP8V2R3x7g5M6n
+SBu5d82+SfHyEwkEhrXI7gJIavXJZNJyh1PZJpvT+AiBXUEzJ7iuyK/PcDJ
ydsX333Z1nb724OGf3KMTHqora6uaki0LUI+7x0cHOzr6+OJTPPtybsrBsye
4rsivz0ggJPFL9ra7szV1xeNel67R3Vd8WLj61ttt78Zq1tu03x7RtQV/WDP
3LriDfaACC7Gvvr7tIo1jOrbcY/qfsWTtS8/dUJ863Vck3Z7RvQr+sGeuf2K
N9gDQqiOV/y2rrJo1HtA96h/B/0i8SXDaE/t9gx5B22+PZPfQTe1B4TA9m2L
9hF3TVE8XnHnUz27Lb7muf9Buz0Txiv6wp6x4xVvsgeEwHZX1P51RlMUf9ty
cbTzYqdJv4759kz4tsUX9oz9tuUme0AI+A76OsH7krcp+A7aJfgOujXBnDnX
Cd6sL03BnDkuwZw5rQnmV7xO8GYIbMqLFy/4XTUSPHuYX7E1Wfz2dtttzMX9
N4I3m3RTMBe3SzAXd2vyIvHHtravXv7jH41aO8MlWLfFPVi3xSVYt6U1uXgR
/zQa9I93xvLTay//Vmd0E5lY4+8mzLeHNf5cgjX+WpWLxfjXt9qqfP7IxeW6
HlgPuinm28N60C7BetCtzcXJ0dHJyYX1Py4jM5vNhsNhQ8bncPaV0WOaHtb2
o8VcRqb59h4/fszjqpGg2lNzVxRoD8jDZWQS0Wh0Z2dHd3o/sba2xhOZ6XQ6
FAq52VJUuS7qsydkuPt1gmrv3bt3HFbcItAekIf7yByuoju9n+As6ZFIhDLi
ZkuB5VqXPf7h7nUE1Z6au6JAe0Ae7iPT6vfe39/Xm2DOwYqZTMZNX7eFwHKt
xR61OjlUNSHA9g4PDznEuEKsPSAP95FZrA4eoyaA3gT//vvvrFH5iVgs5jhU
rIbAcl3UYe/s7IxJ0o0E2J6Q4V72iLUH5OEpMvP5fCgUev36tcYE80yjOjo6
2tnZaf/96XXElmv19jifIHUE297R0RGTFbcItwfk4SkyrYtLjzxqxupK8Obm
pveQ/AQFJIUlpd/9LmLLdVG5PYFj8AJvT+pdUYY9IA+vkVmsfq+kcdZ95pkV
k8mk48endQgv10W19gQuTxB4e2Lr1XXIsAfkwRCZExMT9ODb29tTn9qLiwuv
qbXIZDLt7e2Uck97ySjXKu2JmjCnFewdHx97TYxLJNkD8mCITCKVSkUikZMT
1ZNhsn3rl8vlOjo6KM1ed5RRrosK7Qn5CLpF7H348IEhMY7IswfkwRaZxep3
WOrfR7N91RKLxexXmbwJSeW6qMqekJUQW8SekImYGpFnD8iDOTILhUI8Hqef
KlNbLpe9prOnpycajbocJFaHvHKtxt7s7Cxb8mq0jr3T01O2xNgg1R6QB3Nk
Fqtv1uii09NQTVIZ+sPpMR0Oh90Ph6hDXrkuyrfHPzdvS9kTPrZTtj0gD57I
LFaD8+7duzMzMwqSurW15SltHR0dlLZcLsecO6nluijZHudQk1azd35+zpOY
OhTYA/LgjMxitT+ZntpFyev2Xl1deWoP9vb2hkIhtsZLDdnluijTHs+wnBa0
J2TZCws19oA8+COzWH1qx+PxTCZzenoqKZ3uByRTSaHGCxUW5sZLDQXluijN
3vPnzxkS07L2Li8v+ROj0h6Qh5DILFY7wPv7+ykeJH3C73L21LGxMWq80MOa
80ltoaZcF+XYW1xc9JqMFrfHmQzF9oA8REWmRSqV6uzsXF5epievwES66SKj
UBwYGGhvb2cYG3YTysq1hUB7dITJyUn3p4a9v3Isp6vFHpCH2MgsVr8+6K6y
u7srKpGOFcV0Ot3V1UW1Ba9fENijuFwXxdnzNLM07Fk8fPiQ4aS67AF5CI9M
i5GREQqV8fHxN2/ecKbQ/nuWbDZLpYBaLnRG4blQX64t+O25XAYa9q5TKpU8
nUivPSAPSZFZrHaDDw4OWlOFMHf4nJ2d3RSrY2NjsViMmi3UeOHv3G6KrnJd
5LbnONwd9hpxP8e7CfaAPORFpgXFzNDQUDgcjsfjjx8/Pj4+dp+2SqWytLRU
d8AHDx4kk8nOKnRkSTFpobFcW7DZs5lsH/ZscJyOySh7QB6yI9OiUChkMpn+
/n5qblCjY3p6ent72/4D//Pz81p3Yi6XS6VSfX191DK6d+9eb28vHU3Imz57
tJdrC6/26rphYc+lvaafjRtrD8hDTWTWoHCi1ge1O6wOGSKRSNAzd3Z2dnFx
cW1tbWNjgwr15OQkbdPT00MP+ntVotEo/YX2VRCQNQwp1zXc2JuamqL6DN0E
YK8OR3u0AbW7/WIPyOPZs2fKLnQj1CShJ+/w8DBFXaIKBSQ9l+kX+gv9nf6V
ttGVPJLjL3t9VWDPDY32qB7oI3tAHgxjfVuHpaUl2GMG9nhwtAfkwTA3V+tA
cmCPGdjjwdEekAfnivPBhuTAHjOwx4OjPSCP1dVV3dffXEgO7DEDezw42gPy
ELXgUSAhObDHDOzx4GgPyEPSIj7BgOTAHjOwx4OjPSAV5nXngw1pgT1mYI8H
l/aAPJp+WNfikBDSAntswB4P7u0BqdBV0Duk1ihIhaewhL3rwB4PXu0B2Rwf
H29tba2srJTL5VKptLCwsL6+/izQUAYpm5RZyjJlnLLvaf4K2IM9ZgTaAwAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAE
gOPj462trZWVlbm5uVKptLCw8OTJk2eBZn19nbJJmS2Xy5Rxyj5JgD2XwB4P
sMeDQHs3UalU6ERFUIVUkBDYYwP2eIA9Hrzasxe7tLSkO0NmQUJc6oW9RmCP
B9jjwb09ezY3N3VnxURIC+wxA3s8wB4PLu3Z8OHDB92ZMBeSA3vMwB4PsMeD
oz17tra2dOfAXLa3t2GPGdjjAfZ4cLRnz+rqqu4cmAvJgT1mYI8H2OPB0Z49
jx490p0DcymXy7DHDOzxAHs8ONqDW2ZKpRLsMQN7PMAeD4727EE93Ib5+XnY
Ywb2eIA9Hhzt2YM+WxvW1tZgjxnY4wH2eHC0Z8/PP/+sMfEPHjxIp9PDw8MD
AwOJKr29vX19ffQL/YX+Tv9K2+hK3g8//OAje/39/bDnHtjjwe/2jHJbKBTG
xsbIW3d3d0cV0pjP52dnZx89epTJZMjn4OBgMpkkzz09PeFw+F6VaDRKe9G+
dARlqTUtMm+yR1AQkjfYs6HRHllKpVIjIyODVWDPhkZ7pMjyRsZ8Z88EtySE
7niky5I5PT29vb19cnJSS8bV1ZXNt0u5XI6il55EXV1d5JmeSnQ0BZINiUwb
e+fn59RYsN8d9hrtvX//fnNzc2pqynF32Ltuj4wtLCyUy2WXuxtrT69bqsYM
DQ3RgyMejy8uLt40r8Xu7q7LA1K1nJ5HnVXoyHR8eYnXHpn29s7Ozubn5z0d
EPaIvb29hw8fMhywle3Rc+TVq1czMzPMBzTKni63lGuqUZOB0dHR/f19mzRQ
RXFubs7r8alOHovF2tvbqX4uybDGyHS0V6lUHj9+zHz81rR3eXkp5NvhVrN3
eHjIUEJvwgR7WtyOjIxQnXl8fPzNmzeOafjtt9+YT5TNZq2ODjqjwPRb6IpM
N/aEzB/VUvbolih2NEsr2KMay1/+8hcZJ9JrT7HbiYmJ7irUKHaZhqdPn3Ke
NJ1O06WMRqN0diG5sFAfmS7tUcQKPGkr2KPSvb6+LvZ0FgG2d3Fx4dhrzYku
eyrdplIpqngvLy/Tc9llAmjL6elp/lMXCgWqkFO1nNLAfzQLxZHp0h79q/vu
bpcE3p7USbcCae/8/HxhYUHgKW5Ciz01bilr/f39dM+370Js5O3bt0ISYDE2
NkZ1cpIs5D2Xssj0ZO/169dCTtpIUO398ssvQk5kT5DsUS2Rp9eaAcX2FLjN
5/PxeDyTyZyennpNgPBei1wuR4mhq8zfkasmMj3Zo0c5z3tAR4Jn7+PHj25G
4AghGPYoxrRM8a3Snmy3dG+njNBPtgRI8t/T0xMKhcgzz0EURKZXe+6HMPEQ
JHsrKyucZ/GK3+3pXQhGjT2pbinxd+/eJbdsZ6enkrzneF9fH6WN57kjOzIZ
7HkdoMhMMOypaTs34l97Ozs7PIcVggJ78txSsskqNeiYz350dMR8djd0dHSE
w2FmvVIjk8GebF11+N2ejNdS7vGjPZW9DfbItifJLVW84/E4c8PZQkF7kCrk
VjOBYV95kclm7/nz52ynY8bX9vTOn1D0m72rq6vl5WW2Y8pAqj1JbhOJxOTk
JM+piR9//JHt7J6IxWIDAwMMO8qLTAZ7FLSlUontdDz41B5VFLXoqsNH9tR0
WXtCnj0ZblOpVCQSuT69AxtqesJzuRxVyBlGQ0mKTDZ7ipvPNXxqT1ePYh1+
sVepVEx4iNQhz55wtxMTE52dnXt7ezzntZidnfV6djYymUx7e7vX8fMyIpPZ
nsZZRv1ob3Fx0evBJeELey9fvvR6NDVIsifcLbX3FxYWeE5qQY8nr6fmIZlM
xuNxT7vIiExme3qLub/s/f77716PLBXD7VFJZJtESA0y7Il1Ozo6So190shz
Uovj42NPp+Ykn89b04C430V4ZDLbo10mJyc95lgk/rInaUIDZgy3J+9rKSHI
sCfQLSUvFAqRQ54z1uCZKocNEtvR0eH+db/YyOSxJ/a7SDZ8ZE/jgJybMNbe
1dWVgbrqEG5PoNuhoaF0Os1zOuZTi4Iel5QLlxuLjUwee4Z0+/jCnq7XUo6Y
aU/s/EvyEGtPlNtCodDV1eV18gcbtDRzMpkMPXRcDoISGJmc9iTNguUVX9h7
9eoVRxYlYqY9OhFHntQh1p4ot8NVeM5Vx8bGBockdiKRCGXEzZYCI5PTnjlt
HPPtGTUUuQ7T7FUqFSHz+KlBoD1RbqPR6M7ODs+56tC1zDc1JUKhkJstBUYm
j72LiwuO7ArGcHuXl5d6X0vZY5q9g4MDjtyoRqA9IW6z2Ww4HL66uuI5Vx2K
J3CrQZVwqopTjhy3FBWZnPaM6igz3N779++5sygR0+xJnYxXOALtCXGbSCSo
EcdzokY0tgr7qzhuJioyOe3t7+9z51gkJtszfJBJ0TB7AteoUoMoe/xurd7a
w8NDnhM1orFDY3x83E3PrZDI5LdnyAvoGibbM//dgTn2Tk5OBOVJHaLs8bul
lEQiEZ6zNEJVekGeGCG3lC/7bYREJr89vbOANsVYe7q6ZTxhiD1/dSrWEGKP
3+3Q0FAul+M5SyPa3yD09PQ4Dn8SEpn89mSvs8aAsfZ88UbVEHsav6znQYg9
fre9vb2bm5s8Z2lEe+39/v37jh9XColMfntqllrzhJn2zs7OBOVPLobYM/Bp
6wYh9vjdhkKh9+/f85ylEcUfQTcyMTFBVXH7bYREJr89ZTMLucdMe4a/gK5h
iD3fvWqxEGKP020+n//+++/Fjsn5qwGjTQqFguPaEPyRKcSega1CM+39+uuv
QnMpC0PsGbIYgVeE2ON0m81mu7u7eU7RlMPDQ6GqWOjq6rIf+8Qfmfz2tL+W
ugkD7ZmwEpNLtNvzS29DU/jtcbodGRnJZDI8p2iKCZPAxONxyp3NBvyRyW/v
/PxcaKaFYaA904Yw2aDdnvbGGg/89jjdWq97eE7RFBNm6ujt7bV/mcUfmfz2
Tk9PReZZHAbaM21aRRu023v37p3I/KiF3x6n24GBgVKpxHOKpqifXLGR/v5+
+7Vy+COT3572l/U3YaA99WsgMqPdngkFkBl+e5xuE4mEkPUI6jChYzyZTFLu
bDbgj0x+ex8+fBCaaWEYaM9HX/Vqt+fTIdwW/PY43dJteXV1lecUTTHhrjg4
ONjX12ezAX9k8tvTPoTpJgy0Z+BHQDeh3Z4hayCywW+P0y3qip+42Pj6Vtvt
b8bqFoxEXdFmA/X2gllXlGOvVeqKN9izB/2KNhv83e3J2pdtbW23vj1Sbi8I
/Yqq7AWzX1GOPRMKIDP89uzBO2ibDa7Xw18kvmy79Z3XyMQ7aJX2gvoOWoa9
1nkH3dSePRivaLNBze3O2Ff0wImvvVVvLwDjFZXZC+R4RUn2WmS84k327MG3
LTYb1NxeHO282GnSM4FvW2w2UG8vkN+2SLLXIt+23GTPHnwHbbMNvoO+CTPt
mfAKzw2G2MN30Mxui5gzR7c9zJnjUhTmzKkDc+awgfkVbcD8ijdhpj2/tAoN
sYf5FXncYi5uvfYMjF5j7RnY29CIIfYwFzePW6zboteegZ9sGGsP67ZcB+u2
sIE1/mzAGn9NMdke1vi7Dtb4YwPrQduA9aCbYrI9rAddB9aDZsCl22w2Gw6H
xY7P0dXYoQcNPW7sxztZiIpMTnvaRzFdx3B7hr+GNs2ej74cLwq1J8QtEY1G
d3Z2eM5Vx+rqKp8kRtLpdCgUcrOlqMgs8tnT/mbqOobbu7y8nJyc5MifXEyz
55cRnhYC7YlyO1yF51x1bGxscBhiJxKJUEbcbCkwMjntaextqMN8e8vLyxz5
k4tp9iqVii/e2lsItCfKrdVzu7+/z3O662gZGJDJZNz01loIjExOe+vr6xyZ
FoYv7L169YojixIx057576csxNoT5bZYHf5ElVie0zGfWhSxWMxxsFMNgZFZ
5LNnyGtoX9gzqhv2OmbaM2H2KjeItSfQbT6fp3b969evec5YQ/0Mb6Ojo52d
nfZfUF5HbGTy2DNhiiEf2TOnw6GGsfaurq4M1FWHcHsC3VrJo5t2pVLhOamF
4k+hSSmJpfS730VsZBY57NEuel8i+MueaRMtGm7P8OFMMuyJdVusfnEjZM0C
ukBeT81DMpl0/HyyDuGRWeSwt7i46PVcAvGXvd9//93rkaViuD0qiQ8fPvR6
NGXIsCfc7cTEBN269/b2eM5roWw2mEwm097eTin3tJeMyGS2t7297fVcovCj
Pb0Pkev4wp4hHdeNSLIn3C2RSqUikcjJiefpHOtYWVlhOLtXcrlcR0cHpdnr
jjIis8hqT9dLBJ/aM2QNO7/Yo+piqVRiOKBU5NmT4bZY/ZKI/330jz/+yHZ2
T8RiMft1Em9CUmQWmexdXV1piVuf2ru8vDShmPvI3u7uLtsB5SHPniS3hUKB
Gvv0k+fsCi5ET09PNBp1OcypDnmRyWZP/Rp2vranZejXdfxljx67Rg2Al2pP
XuTk83lKNt3Pmc8uu1VID5pwOOz+hX4d8iKzyGRPcSPa7/aouqhxzIkf7X38
+NGQZQtk25PntljVe/fu3ZmZGbazU9zKuwodHR2Utlwux3wEqZFZZLI3Pz/P
c0b3BMOert5F/9ozYUUwBfakui1We0TpuVNkXfV4aWmJMwFN6e3tDYVCbNXv
GrIjs+jdnprOnyDZU/NG7zp+t6d3lmM19mS7LVafO/F4PJPJnJ6eek2A8AG3
dK2p+k2Xm7n6XUNBZBY92qPaNT3f+U96E8Gzp7JVGAx7FGOS6ir2qLSnwG2x
2oXb399POfI6AYLYb9nGxsao+k2PG85njYWayCx6tCfvS4Sg2lPTjg6SvYuL
C8XTnyq2p8atRSqV6uzsXF5epseNywTQlkLmMiKZAwMD7e3tDKObbkJZZFq4
tCfjJULg7UmdXjWQ9s7Pz9UsLqnFnkq3xer4+e4qu7u7LtPw9OlTzpOm0+mu
ri563nkdA2+P4sgsurYndp6TVrB3dXUlaTa2ANujGqPs9SV12VPs1mJkZIQy
Oz4+TuXXMQ08k+dks1m6jlT3pjMKTL+F+si0cGNPSJd4S9mjWpDY6d9bwR49
TSRNtaHXnha3xWpH7uDgoDXZhX13GZlnWFVnbGwsFotRxZuq3/zds03RFZlF
F/YqlQpPz09r2qMbo5CmdKvZOzw8FLjulQn2dLm1oFwPDQ2Fw+F4PE6l+Pj4
uGky3A84efDgQTKZ7KxCR5Zk1UJjZFrY2zs7O/M6fBH2iL29PbYpYlrZ3vv3
71+9esUz/sEoe3rdWhQKhUwm09/fTxVmqjZPT09vb29f/0Sdqos2gwFyuVwq
lerr66O6/b1793p7e+loQt5V2aM9Mi1s7J2fnzv2/MBeoz0q41RpdDNiB/au
2yNjCwsL7l/2GWvPBLc1SAjVn6nmbHUpEIlEgp4as7Ozjx49ImPDw8NUe6dn
Cl2Inp4eelTdqxKNRmkv2leB0hqGRGaNm+wR6XSavMGeDY32yBKV2ZGRkcEq
sGdDoz36xfJGxnxnzx4tS0rVoEq1dSckb4kq9DShJwv9Qn+hv9O/0ja6kkfV
MB/Zo2iEPffAHg9+t2ePrkWZfcH8/DzsMQN7PMAeD4727KF2q+4cmEupVII9
ZmCPB9jjwdEe3DJTLpdhjxnY4wH2eHC0Zw/q4TaQHNhjBvZ4gD0eHO3Zo3GN
JPMhObDHDOzxAHs8ONqz58OHD7pzYC4kB/aYgT0eYI8HR3uOSJ1OxL+QFthj
BvZ4gD0eXNqzp1KpaJlk0mRICGmBPTZgjwfY48G9PTd69U5LbhSkwpNY2LsO
7PEAezx4teeG4+Pjra2tlZWVubm5Uqm0sLCwvr7+LNBQBimblNlyuUwZp+zf
NH8F7DUCezzAHg8C7QEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAACgi+Pj462trZWVlbm5uVKptLCw8OTJk2eBZn19nbJJ
mS2Xy5Rxyj5JgD2XwB4PAu0BGVQqFbpMRVCFVJAQ2GMD9njwag9Igq7C0tKS
7nAwCxLiMjhhrxHY48G9PSCPzc1N3YFgIqQF9piBPR5c2gOS+PDhg+4QMBeS
A3vMwB4PjvaAPLa2tnRff3PZ3t6GPWZgjwdHe0Aeq6uruq+/uZAc2GMG9nhw
tAfk8ejRI93X31zK5TLsMQN7PDjaA/JAZNpQKpVgjxnY48HRHpAHWjE2zM/P
wx4zsMeDoz0gD/R427C2tgZ7zMAeD472gDx+/vlnjZf+wYMH6XR6eHh4YGAg
kUj09/f39vb29fXR7/QX+jv9K22jK3k//PAD7DEDezw42gPyUByZhUJhbGyM
oq67u7ujo6O9vT0ejyc/Mzg4SNFIP+l3itKenp5wOHyvSjQapb1oXzqCstSa
Vq6v22uvEovFSBQVZNhzpGaPQi4A9oA81EQmhVMmk6FgozshxWQqlcpms7lc
zuXutCXtQs/xrq4uilJ6ptPRFISoIeX6ur1IJEIllGzAnksse5R9ug3SjY40
BsMekIfsyMzn80NDQxSN9Fyempoql8ucB6RGDT3NO6vQken4QtLZFO3l2rIX
CoXoZjgyMsLfoGtNewQ9SgJmD8hDXmRSzFB7hOJndHT0+fPn8/PzYo9PLRq6
01IFgAJeUnxqLNc1e1QMx8fHhR8/8PYoX1S1poYw5VT48U2wB+QhKTKpYkMt
DirOe3t7a2trMk5hQS1xq4uSzij84LrKtWXv/v37ExMTMo5fI6j26GlCbV7K
nYzj19BrD8hDeGRSQe6usru7e3BwMDMzI/b4TUmn03QbiUajYm8j6su1ZS8e
j4s9rD1BskfqwuEw5UjskW3QZQ/IQ2xkplIpekwvLy9XKhVqNQs8siOFQoGa
M9SooTSIOqbicm3ZE3hA9wTDHlXbBgcHVb4pttBiD8hDVGRSYPT399MTc39/
n26J6+vrQg7rlbGxMSoaFKJCioaycm3Zi0Qi/G+jePC1PaqwyehCdI9ie0Ae
QiIzn89TyyWTyZyenmqfXTmXy1Fi6P7M3w2uplxb9kZHR2dnZ/mPxolP7fX0
9LgfbCMPlfaAPPgjk56MFAb0k452eXm5srLCeUAhUDEJhUKcJUVBubbsPXjw
YG5ujvNQAvGRPapgU0WR8zhiUWMPyIMzMunS3717l8o1Herq6kpXw7kpfX19
lDaep7bscm3Zo3JtQi2xDr/Yo0Yrz0EkocAekAdPZNJFp/vhzMyMdSgDP/an
IhMOh5mDU2q5tuxNT08bO6GW+faSySTzEWQj2x6QB3NkUuMlHo9bDWfi119/
ZTuObKg5YzXwGfaVV64te1RklpeX2Y6gBpPtmdZwbkSqPSAP5shMJBKTk5PW
QU5PTx8+fMh2HAXEYrGBgQGGHeWVa8ueL1a4M9Ae3Q/ZkqQeefaAPNgiM5VK
RSKRk5MT6yBGdSc2ksvlqDnDMJZMUrm27O3s7DDsqx4D7XV1dZnwxtkN8uwB
eTBE5sTERGdn597ennWEg4MDr0dQTyaTaW9v9/r1gYxybdn76aef1Hz1IwSj
7NFNhtLjdUeNSLIH5MEQmT09PQsLC9bul5eXBr4/bUoymfT6JZ2Mcm3Ze/Lk
idcd9WKOvaGhIa97aUeGPSAPr5E5Ojoai8UqlYq1++vXrz3trpF8Pm9N4ON+
F+Hl2rL322+/eUy7fgyxFwqFpM7fJQkZ9oA8PEUmXVwKS7oTWvvSvdFHzcBi
tVhR+8t9sRJbri171HYWPqmaGrTb6+rq8nRjMQrh9oA8PEUmNV7S6XRtXx9V
FGtQVc19E0xsubbs/fLLL0wJNwK99vr6+phSbQpi7QF5uI/MQqFAD+v9/f3a
vkZ9pOaSTCZDj2yXQ8gEluuavYWFBY7ka0avPX+9ZGlErD0gD/eROVyltuPb
t285AkQnkUiEMuJmS4Hl2rLnX2k1dNnr7u7mSLUpMNi7OHl7cHDw9uiEs6QD
97iPzGg0urOzU9vx6dOnHNGhE2rGhkIhN1sKLNeWPanTkqtBiz26maicSFYe
DPYW79xqq3Lrq/gBZ2kH7nAZmdlsNhwOX11dWXtdXl5OT0/zBYg2qAlDDRk3
09eLKteWvbOzs8nJSe7ka0aLPWo+q59LVgYM9k7e7mxsrN3/9o90Y7wz95a/
yANHXEZmIpEol8u1vfw4tuQ6/VUcNxNVri17fvmYxRH19gYHB7lTbQqs9o6+
vdV269tFxnIOvOAmMq2+7sPDw9pez549ExEg2hgfH3fT7y2kXNfsGTLzJD/q
7clY5VAXrPZO4l/grqgIN5FJ1zESiVzfy9jJr9xDkelY1oSUa8ve5eXl1NSU
oLTrR6U9uiuKSbQxMNk76rrddht3RSW4icyhoaFcLlfb5eLiQlB06MTNt2NC
yrVl7927d4ISbgQq7Zk8iSIbTPaOvsNdURVuIrO3t3dzc7O2y5s3bwRFh07u
37/v+GmqkHJt2dve3haTbjNQaY/OJSjVpsBkD3dFdbiJzFAo9P79+9our169
EhQdOrFmX7HfRki5tuwFYEzOdZTZo+az2HWWTYDJHu6K6nCMzHw+//3339fG
5PzV/69aLAqFguPKGvzlumYvAD2x11FpLxhjcq7DZO/ou1u4KyrCMTKz2Wx3
d/f1XQLzLpXqIfYjx/jLtWWP7ooBGKlYhxp7kUhEaKpNgcHe3J1bt+7MMZRx
4BXHyBwZGclkMtd38ePnz02Jx+OUO5sN+Mu1Ze/jx49CE24EauyZvzgLGwz2
1ro+Dc05YijkwCOOkWm9LLu+i8lLtHiit7fX/lUgf7m2jv/+/XuR6TYDNfb8
sj6LVxjsXbxMtLW13X954b2UA284RiaFZalUur5LYMbdOS6KxF+uLXsBmBSi
ETX2/DjzthuY7F2MfX2rre2r/At8Dy0Xx8hMJBK19QiIq6srodGhk2QySbmz
2YC/XFv2jF0Wlgc19lzOMOM7GO2dLFYniriDz6Gl4hiZ9FBbXV2tbV+pVIRG
h04GBwftJzLlL9eWvf39faEJNwI19oI3WNGCyd5R/Mu2ttt31g4wq5hcUFe0
2eDvkXmxQW2X29+MnTDZa/W6Ioc91BVrnGx0UTUxj9azfNCvaLPB3yPzZO3L
TzPc1b8BRL+izQZC7KFfscbap2Hc3+EdtALwDtpmg+uR+SLxZdut+ph0ae/o
6Ehkus1AjT28g64x/c2tW3cwilsFGK9os0EtMnfGvqLKTnytvpMb4xVtNhBi
D+MVP4NvW9SBb1tsNvj72hlHOy92mnRx49sWmw2E2MO3LZ/Bd9DqwHfQNtvg
O+ibwHfQPDB+B427oiowZ44NmDPnJjBnDg+YM8dwML+iDZhf8SYwvyIPmF/R
cDAXtw2Yi/smMBc3D5iL23CwbosNWLflJrBuCw9M9t5ijT9lsK3xR01CQQGi
B6zxxwPW+OPBq72jnY3pfL7rmy/a2tq+XcQH0CrAetA2YD3opmA9aB682lu8
c6s6I0TbV99N4/tnNbiMzGw2Gw6Ha+NzqD04PT3NHSB6oMc0PaztR4tZiCrX
lr2zs7MAjFrUYo+qi8EYn8Ng7+Li5OjoCJMqqsRlZBLRaJRqO7Udnz59yhcg
2kin06FQyM2Wosp18bO9AIzP0WIvEonQeTlSbQoC7QF5uI/M4Sq1Hf074wEV
MZczsQgs15Y9/0qrocted3c3R6pNQaA9IA/3kWn1e+/v79f29eMH0ZlMxk1f
t4XAcl2zt7CwwJF8zei1R2fnSLt+xNoD8nAfmcXq4DFqAtT2ff36NWuAaCMW
i7mfnEpguS5+tvfLL78wJdwI9Nqzn6bVfMTaA/LwFJn5fD4UCtHN0Nq3UqnM
zMwwBYgeRkdHOzs77b8/vY7Ycm3Z++mnn+bn55mSrxnt9qi6SGlgSrt+hNsD
8vAUmdbFpUce3Q+t3X1UXaSApLD0VKzEluviZ3t+HNdkiD16rLi/sZiDDHtA
Hl4js1j9Xqm2ZsHl5eXs7KzXI2ghmUw6fnxah/ByXfxs78mTJ1531Is59vw4
O7cMe0AeDJE5MTFBD769vT3rCAcHB16PoJ5MJtPe3u519hUZ5dqyR+1oH3U+
GGWvo6PDX69dJNkD8mCITCKVSkUikZOTv421X19fZziIMnK5HBUlSrPXHWWU
6+Jne3751MVAe11dXZQqhn3VI88ekAdbZBar32HV3kefnp6avJhLLBZje30p
qVwXP9vzxefkBtrr7++npjTbvoqRZw/IgzkyC4VCPB6nn9ZxjF3ck4pPNBpl
+15MXrm27OXz+eXlZbYjqMFke+Yv6SLVHpAHc2QWq2/W6KLT09A61NbWFvOh
JEGP6XA4zPzWUl65Ll6zZ+y0bObb6+zsZD6CbGTbA/LgicxiNTjv3r07MzND
h7q6ujKqg7Gjo4PSxtMBJbVcFz/bm5qaMvA9vl/s2a81rwsF9oA8OCOzWO1P
pqd2sbpm9OXlpSGzCPb29oZCIc6JVmSX6+Jne/TTqM8nfWQvEomY1pRWYw/I
gz8yi9Wndjwez2Qyp6enlUplaWmJ/5jMUEmhxgvdaviH+yoo18XP9kZHR02o
MfrUHt2ITHgrrdIekIeQyCxWO8DpkU3xsL+/TzdGXU3psbExarxQGREyHZ+a
cl38bI+qPeVyWcgB2fC1va6uLkq/kAOyodgekIeoyLRIpVKdnZ3Ly8t0Y3z+
/LnAIztCoTgwMNDe3s4wNuwmlJVrC8uewAO6Jxj26KY0ODiofn5aLfaAPMRG
ZrH69UF3ld3d3YODAzVfcKTTaaoqUE1V7NrBist18bM9r1+HcRIke6QuHA6r
nKJWlz0gD+GRaTEyMmItQrS3tyd1AupsNku3Eaok0BmFH1x9ubaw7N2/f1/2
AvFBtUdV7r6+PjcLAfCg1x6Qh6TILFa7wak5Y00VQq1p4dNnjY2NxWIxarZQ
40XSPCq6ynXxmr1kMiljhbvA26N80f2qp6dHRmejCfaAPORFpgXFzNDQEDVq
KIqmpqb43yY8ePCAbhSdVejIUueV0liuLSx7oVAoEolQ1ZHyznnA1rRH0O0r
YPaAPGRHpkWhUMhkMv39/fT4jsfjqVSKnrbuh1LQlrQLtYmoXXnv3r3e3l46
moJOde3l2uK6Pbo9UgEnG7Dnkpo9qtrR05l+CYY9IA81kVmDwonuh1Suu7u7
26vQTTL5GWozDg8P00/63ZoBgML4XpVoNEp70b4q3zAaUq5rNNqjGjiJSiQS
sOdIoz3S4l97QB56P16mJgk9eSkaKeooOCka6VlMz2X6nf5Cf6d/5W/4MLO2
tgZ7zMAeD472gDxWV1d1XXfzmZ+fhz1mYI8HR3tAHsZO2GICpVIJ9piBPR4c
7QF5IDJtKJfLsMcM7PHgaA/IA60YG0gO7DEDezw42gPy2N7e1n39zYXkwB4z
sMeDoz0gjw8fPui+/uZCcmCPGdjjwdEekIov1lRSD2mBPWZgjweX9oA8tM8T
ayAkhLTAHhuwx4N7e0AqdBWePXumOxxMgVR4CkvYuw7s8eDVHpDN8fHx1tbW
ysrK3NxcqVRaWFhYX19/Fmgog5RNymy5XKaMU/ZJAuy5BPZ4EGgPAAAAAAAA
AAAAQBT/DjPGhBU=
            "], {{0, 352}, {434, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{434, 352},
          PlotRange->{{0, 434}, {0, 352}}]], "ExerciseOutput",
         ImageSize->{438, 352},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "dd082170-394e-4217-a498-9d73da181c8e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnclTHEm+55mZyxznX5h/QOe56jinMntjc6vDvGfT/WwuPWX9xmysrnXT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              "], {{0, 352}, {434, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {434, 352}, 
            PlotRange -> {{0, 434}, {0, 352}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1554882d-4b5b-499f-8a7a-d8d1ee0e0af1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2902536c-71c6-4b34-a29d-2735a9b8f652"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d999d317-97ba-40e9-acd9-a302b582461b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"742857c6-cbc8-4a8a-816b-9970020b18e7"],

Cell["\<\
Compute the time today between sunrise in New York City and in London.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"ce8df59c-d091-407d-a7bb-8f50aa538f8a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6b580c06-0468-4b7c-be39-c698bcab44d8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVMFr2lAYL9tlxx32D+w/2HHXHXft3HXQsq6OgCPNoOgleJAchNBDKEgO
5mA9BDGUgAaCdFLqwEMEA2aEEnTUMopSFSOKge5775mY2m5t7/5IHi/f+733
/d7v+8jr7W+bX55tbGwwL2DY3Np/t7e3Ff/wEj4+xpivu7Gdz+9j33d2d/be
bj+H4Ct438CL5jdrrPFPzGfe44juH6umn1Z0y+kFMW/YblRLP2tGz12le/22
3TqfPPLwBaYnXISluO5Du0Z2KUUBM0JGqXIOwZlDgp9YNNJmfx7acSHjJeuO
zv/rMRVOzJZGD/G6WpylROzL+ISHROI13CUZYRkcdC0RpGbrAd9W4kSkfb+e
+cydBh/h+b2YueM7ho1H7uL6o6bIUlHLHZcTkZRskmBHBQECKaT3uwRiDjJ8
mqJv+eO15US0WClJDLaaL3SvTDmB5mxCcDCzo3EpoTTzyWpVXxAYzr7l/xK2
HMWpB2VmqadXF7BINC1COka6dq2DRcSHax7gchcrhlURWFJ69cw2CmkqklbQ
UY4Shb2jEPlIqzvNY5in/VxheJc6cEQN9Y+t0OjAXF7NkurEoToOMorYYqWp
qBM2eopSyAZxcazCdXIGWdB9q7Ge/CQg1wl5fgp9zmPfwhgah5CXO574CZza
sZzhi+oPuw5FpH+1ddI2qiIVsxxSnhEbl357TE3wQW2NiR4ot3/l5TysJ0SG
OL3wLUDfEFGhpev7itjIwFJh0jfLslRW8qosqbmFHnNVz+Apega+Hj+OMbs6
O8TVLNdNp2VaTaM7nHcqgpjTu1cXpsajrjB6N2F4qF52uF7uI/VIk1VyqK8C
u7Ce4Ck2B52qGHweaXeaDV3wdj9PrcOQHugZ0sPoH5IM9NDI51UyjicLk5uH
4E1Hw8ETf8JrrLHGEn8BGbU1yg==
            "], {{0, 20}, {48, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{48, 20},
          PlotRange->{{0, 48}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{52, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "595de8ba-b72b-4f1a-98d1-fffdc7c370fb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVMFr2lAYL9tlxx32D+w/2HHXHXft3HXQsq6OgCPNoOgleJAchNBDKEgO
5mA9BDGUgAaCdFLqwEMEA2aEEnTUMopSFSOKge5775mY2m5t7/5IHi/f+733
/d7v+8jr7W+bX55tbGwwL2DY3Np/t7e3Ff/wEj4+xpivu7Gdz+9j33d2d/be
bj+H4Ct438CL5jdrrPFPzGfe44juH6umn1Z0y+kFMW/YblRLP2tGz12le/22
3TqfPPLwBaYnXISluO5Du0Z2KUUBM0JGqXIOwZlDgp9YNNJmfx7acSHjJeuO
zv/rMRVOzJZGD/G6WpylROzL+ISHROI13CUZYRkcdC0RpGbrAd9W4kSkfb+e
+cydBh/h+b2YueM7ho1H7uL6o6bIUlHLHZcTkZRskmBHBQECKaT3uwRiDjJ8
mqJv+eO15US0WClJDLaaL3SvTDmB5mxCcDCzo3EpoTTzyWpVXxAYzr7l/xK2
HMWpB2VmqadXF7BINC1COka6dq2DRcSHax7gchcrhlURWFJ69cw2CmkqklbQ
UY4Shb2jEPlIqzvNY5in/VxheJc6cEQN9Y+t0OjAXF7NkurEoToOMorYYqWp
qBM2eopSyAZxcazCdXIGWdB9q7Ge/CQg1wl5fgp9zmPfwhgah5CXO574CZza
sZzhi+oPuw5FpH+1ddI2qiIVsxxSnhEbl357TE3wQW2NiR4ot3/l5TysJ0SG
OL3wLUDfEFGhpev7itjIwFJh0jfLslRW8qosqbmFHnNVz+Apega+Hj+OMbs6
O8TVLNdNp2VaTaM7nHcqgpjTu1cXpsajrjB6N2F4qF52uF7uI/VIk1VyqK8C
u7Ce4Ck2B52qGHweaXeaDV3wdj9PrcOQHugZ0sPoH5IM9NDI51UyjicLk5uH
4E1Hw8ETf8JrrLHGEn8BGbU1yg==
              "], {{0, 20}, {48, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {48, 20}, 
            PlotRange -> {{0, 48}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7ab30471-2356-48af-bb3b-30fc66a3261f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b26526ea-75ae-41f6-bf8a-21eaf78c2d64"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3bdfe26d-1296-4351-88b6-b1badc4e7f16"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"aa82534d-944e-418d-b489-7048948df576"],

Cell["\<\
Find the air temperature at the Eiffel Tower at noon yesterday.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"95b410d6-79aa-4893-97c5-db65adb7bdfe"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"03a35670-8e80-4dae-bb65-b19105d0a32e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztlMFr2nAUx8t22XGH/QP7C3bddcddu+wqtKyrI9CRZjD0knooHoTMQxAk
h6WgOYRikIAKIjqkFSxYaKCBUH6oqMhIUIsNCQru90uaGKMbY9f5SIJ5v5ff
7/Pe+z5f7n/e/fhkZ2eHfAYfu3tf3xwf70XePYcv74/IT4dHBx/eHn05ODw4
fr3/FDpfwPsVvNHvxda29q82n/Tky3L9R62jmyt+va3e3hnzDZ+MQLNRKVzf
tK21JQ0ooKv5Pf1LPhkNZ8Wmgd5MpXJeFPnHS+CqrZ4XaYA8hWPeVQUeT09A
npDyEDxOFSMomAyhJ503fEuWsxvJ3XsuvUbhxJXagrvlbsaLxbQYRdsm45Fk
jICQXElxQ8cSWqL7CGFcz/Adc/VEnFADMKaSxLGkIKP6tDgYU1Sn7towF7WT
ip17hBbgKZyFbI04xjU1ByYhKIs1m/8sUwh4GvR3C9CfTNMJnAhUxurC3EPX
upsLiSVExc+fIDEqyvvKNW0wdg2jjJ2pAyOvwxi3MDVCBndX0nm5VOtMZrZb
y5Go1KMHWIRwAMbhrw+cyGk5hlHpC+QfIH+qpIBShCL9MPZXptd9u03p2mii
jfShpo89SRoq70iFTTMpCICHYcpAggk6BVESeBgEBTy0tURIEs/FvKZoqN10
Hsb2JQLCbFL9Ysm/VOlSkw5Mveuk2eZw7Fv2zJGKJHK573Gbk70erEzZwuw1
RDbL0NWWXGewU0Hul07QV3GmKLIskk04m8kPNwOhypxmmvPFzDJNy5x5CxaC
CckTN4zETs/ycNzg0EkCJ2UeYeQAzNLaKdiaSlu7KUgCmlOYAufACIU/wGzU
zGPN43xH19QKDY8uA5+Y56hNqr2n1mQhdr0LqbQyc1JsKtpAKdLw3AhYJe3Y
bVr///kLGCjIi5TbwWxpNcaUE66AnUbYU6xV02G340QDBCcRQJhoUMBBGHEz
jG0zYzI2fO37Tczy3PnD+H4y/b1Kt7a1/8t+AVKUASg=
            "], {{0, 20}, {47, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{47, 20},
          PlotRange->{{0, 47}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{51, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f9e38657-4645-4553-ab29-ae2ed0257416"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztlMFr2nAUx8t22XGH/QP7C3bddcddu+wqtKyrI9CRZjD0knooHoTMQxAk
h6WgOYRikIAKIjqkFSxYaKCBUH6oqMhIUIsNCQru90uaGKMbY9f5SIJ5v5ff
7/Pe+z5f7n/e/fhkZ2eHfAYfu3tf3xwf70XePYcv74/IT4dHBx/eHn05ODw4
fr3/FDpfwPsVvNHvxda29q82n/Tky3L9R62jmyt+va3e3hnzDZ+MQLNRKVzf
tK21JQ0ooKv5Pf1LPhkNZ8Wmgd5MpXJeFPnHS+CqrZ4XaYA8hWPeVQUeT09A
npDyEDxOFSMomAyhJ503fEuWsxvJ3XsuvUbhxJXagrvlbsaLxbQYRdsm45Fk
jICQXElxQ8cSWqL7CGFcz/Adc/VEnFADMKaSxLGkIKP6tDgYU1Sn7towF7WT
ip17hBbgKZyFbI04xjU1ByYhKIs1m/8sUwh4GvR3C9CfTNMJnAhUxurC3EPX
upsLiSVExc+fIDEqyvvKNW0wdg2jjJ2pAyOvwxi3MDVCBndX0nm5VOtMZrZb
y5Go1KMHWIRwAMbhrw+cyGk5hlHpC+QfIH+qpIBShCL9MPZXptd9u03p2mii
jfShpo89SRoq70iFTTMpCICHYcpAggk6BVESeBgEBTy0tURIEs/FvKZoqN10
Hsb2JQLCbFL9Ysm/VOlSkw5Mveuk2eZw7Fv2zJGKJHK573Gbk70erEzZwuw1
RDbL0NWWXGewU0Hul07QV3GmKLIskk04m8kPNwOhypxmmvPFzDJNy5x5CxaC
CckTN4zETs/ycNzg0EkCJ2UeYeQAzNLaKdiaSlu7KUgCmlOYAufACIU/wGzU
zGPN43xH19QKDY8uA5+Y56hNqr2n1mQhdr0LqbQyc1JsKtpAKdLw3AhYJe3Y
bVr///kLGCjIi5TbwWxpNcaUE66AnUbYU6xV02G340QDBCcRQJhoUMBBGHEz
jG0zYzI2fO37Tczy3PnD+H4y/b1Kt7a1/8t+AVKUASg=
              "], {{0, 20}, {47, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {47, 20}, 
            PlotRange -> {{0, 47}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7ab0dc9a-01b5-4ade-b8e9-2a223cadb7bb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fbd025a0-9d0d-4493-89ec-507620c5389d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e78b1ee8-e474-4f31-bf5c-296fd88e72fb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f916d7ca-0f93-4a03-b0c2-7f9c2658f623"],

Cell["Plot the temperature at the Eiffel Tower over the past week.", \
"Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"15a623f0-805a-4900-bc70-b9f3a3ab7370"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"611495fb-1bc3-404a-9251-625613782348"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnVt7E8fW5/fM3LyX8xXmW8ztXM7tO8/cmiRAB3aCsjfZiJ2DEjCyjTEn
B4M5iJM4GAJOiIhlGxljgzA2IEAcBAgwYEBgJ8IRCCMb2XpX95KEkLpb1d1V
1W1Rv0ebHUzbKre6V1fVWuv//1+fffWf0n//29/+9vV/wB//+enK/7N8+aff
/L//CX/5/66vl37uWrzo/7r+tfjzxcv/92f/A774J/xvyX/729/k/84JBAKB
QCAQMCbe6ZUQl0uSWmLpXGYs7FG+4PGFM3YPTyAQOJBMMjE2NpYYTwy0Q+jw
J3OpDpfUHk7kMgmfJPljKbsHKBAInEo6ArON8Hg2l466JHdMmWfEO9ySP2r3
yAQCgTPJDrRI7s64/J/pqMflSypfTUV9bt/7uCEJBAKBJOUjQioiFeYYEDfc
UiFuRNp14obpIGXle1ngqPGIwejgqPF8VINRvffHB1ql1nDhkESrJAVGIYhk
gh7JExylPjZHnfCcw8YjBqODo8bz0Q6m+F6xDrerI1b8eioWyIcVbyDJYGyO
OuE5h41HDEYHR43nox2M3ntlM+l0eQ7WUSdKIBDYgtE4IOKGQCAQcUMgEBjF
RNywmEkRCATzF3MRQEQMgUAg4oZAIDCKiBsCgQPpv/z4XXbW7lFoIuKGQOAo
ZmfnpmeyX7SEzl17YvdYNBFxQyBwDpmZbP3u823HInWru75tPwtfSU/NvHoz
bfe4yhH5FIHAIczNza0/dBEiRvE1ciuxZs/Q8M1ndg/tPSKfIhA4isnXGYgV
GzsuwSLl5747S9edwuhxoPum3UMrR8QNgcAhPHg6CVHi9OXHDxN/TWVm7j15
uaihe0F914+7wtW/mS8ibggEDuFS7DnEjWvx8eJXHr9I7fj12qdrgtMzWRsH
VomIGwKBQ+gdfghxY+zFB7KcZyKP4Yt3HiW1vssWRNwQCBxCx6kYhIj025nS
Lz4ZfwVf7Dr/wK5RqSLyKQKBQ2g7dmVxY0/ZF99lZz+pD/p+c4rGr8inCASO
on73+ZVbByq/vmLLGe/eIf7j0UHEDYHAIfxj0+nmAyOVX99w+OIXLSH+49FB
xA2BwAngemSX2nrkUM+tutVdbz7c97AXETcEAidw7toTCA5nr6r0pJy+LKdU
Hjyd5D8qLUTcEAicwLftZ5etD6n2wN4a/RPiRjj6lP+otBD5FIHAdlJpucL8
cG9M9V/HX76Bfz0Zvs95VKqIfIpA4BDuKxXm/Zcfq/7r6zfT8K/HTt/hPCod
RNwQCGxn+OYziAw37k+o/issXuBf/UEHdbcV4kA2GmjF6Yc/PAZ/T8cDrsKE
pLPEj17EDYGAOifP3YfI8CKZ1jrgM2/3jl+v8RySPhgH0vFOSfLGM7nMKPyH
ZzQr27e5/SPJZDKRSCTT2bLjBQIBRfaevL5gdZeOMODf151qPXqZ55D0wTgQ
87tbgvHEaCwai4+Np7K5TMAjeTsHRsLhWCJdebxAIKDIugMjX208rXPA1639
a/3D3MZTFYwD8U43/Eerv6PdA9ONzmQ20S5JrtaOULADViut4UTp8aXYN3CB
oHaoWkn+3fazq+xW4ai892MQHtqxUG28VXJH0rlsJr82SUV8kieYKfleO4Ys
ENQssDz5dE1Qf/sCoopq64pdYBwYC3klT0BekKQiLskVTcZg/jGidPxHfC7J
Fy07XiAQ0OLmgz9Q5kvnmPWHLn61sY/bkKpSiAOpYGs+f9I+MAp/j4dgpSLJ
X/L4xzKVxwsEAjoc7JbbT5KptzrHbD1+RWoqb7G3kdI4kEmnM6VqZFn5CzrH
C7SAmWeq4tQJBKp83dr//Y5z+sfsDlyH2DI3N8dnSFURdV8sgKcDfMp//jVl
90AETmf6XZakputwrywFNpV5x2dUVRH9KSxYs2cIPuULNxxkeyFwJuh90Hnm
rv5hvwzE4bCXr/TWMnwQ/Sns+Ofm0860vRA4jWcTr+FS6b4wqn8YHACHPfvj
NZ9RVUXEDerMzs19Uh+ET/mHnY6zvRA4jXtjL7VkN0pBVXPnSHCIuEEdmEyi
zdana4JOthQXOIFr8XG4VC7ffq5/2PDNBBx288EffEZVFRE3qHP/idwTvWLL
GUdNLAXOZOj6U7hObj/8U/8wDC+XYlXCCzdE3KDOyC350bD39xvwZ+TOC7uH
I3A0fRcfwXXy+HlK/7C7j5Nw2LlrVZYz3BBxgzq4hYXRY/2hiycG47OOSbsL
nMZvZ++RpOwfv0jBYadGHnIZVHVEHpY6+7tuwkf86s30gvou3OiIj720e1AC
h4IebVOZKlrlEFjgMHgG8RmVDiIPy4LMTHZp8ylsXfzXT2cwbhztu233uAQO
xfdbFJ4vVQtBM9Pv4EI62HOLz6iqUntxAz6CF8l0MmVPrWbfJXm5OnxTVh6A
RQr8N4SRf28dtGUwAufz088RuEJIjqzaM8uT2osbOKNr2n/BlnffHZCFm2Zn
5cfH5Ku3D55O/nLmLsmGueDjpGn/MMxLSY78cn1ow+FLjIdDSu3FDexK/qQ+
mLbD36r16OWyx0cqnfnM272xwymfuMBReHac+2FnlaY2ZOXWgTV7nOISW3tx
I3TxIe4q2NIe0rjvQuXjo+1YBEKHc5oZBc5hObEAIAQN50j31F4+5UD3TYwb
+7tsaA/5rl1Fz+3Y6TswHtFZL6hkSXPvlp8jJEfClBWWKqzHU5VazaesOzji
2tC3bEPf+kMX+b/7PzadbjlYbil+WtksHX32F//xCJzMu+zsAqVEkOTgHb9e
+3RNkPWQCKm9uAETP1gs1O8+v7LNhkndosaebcevlH3x6l2iHgTBxwY2w3ad
f0By8EHFlT4z7QgJjhqLG5mZrBzAT15v77y6sIH3lgL6alWuj5xW7CdwCJHb
L+DCuELWjHBiMO4cMagaixu3H8rO3QNXxo73y1sKk6+5bimgBsvx/nINlvTU
DHy945S6a7Dgo+X3sGzTliBrfsQNf3gGsR4VCTUWNwLn5Gr/pxOvBq+MwX/c
41vgjdPOHjUNFtX1i+Ajx/db9JN6UrEF7JyNOaMQqMbyKRsOX1rS3AvLk1uj
8sQDTjXPd9dpWnS3OSj5LnAIcEms2EK6Cxe9N+GEVvqazKcsXXcK0ygTk2/g
JP929h7Pd4eFqtZyda1/+J+b9Yz8BLYzlXmXTE1hrS8fvmgxUAJ6/+kkrsGZ
DomQQhwo96PPjIU9yl89vnBG5XgnghXmKPE6o8hEc1b4hJkGvCnMOir/Sa4/
r9czDhbYDramPhl/xeftYFYMb7fn5HXC4yde2vAo1EJS96NPycaP4UQuk/BB
JImlyo53Jlfvyo/7i7fybrawctz1W1T/W+jSg+KxEyrbXMGhB7jxwnM8AkPs
+PUaTy0+mN7A2x3uJd0tx0ehLdWMlUiqfvTpqEtyx5R5RrzDLfnnh88jSqA8
/zONf5Ur8Y4RVeLR4nj/Xa0kDi5hRAmHk1l3cISnphbq0P4yYEBSY2nzqdaj
l9kNiRxJ1Y8+HfW4fDjbTkV97nniD9t2LLKosacorqVauskUf1AucYfnQuU/
Jf6QUy2/h+/zHI/AEN9vPwuf0clznD4jvCS6h4iKvpBvtg2u9p1nNyRy1P3o
J6JuqRA3Iu1lcaMUO4asycq2gVW+970hcJI5pzB0KoHfZWf5r5sEhli2oY/n
ntjoM3mf80xEz066jOYDI/A0ZDckfSrv/XI/+nSiVZICozDfzgQ9kic4Wvq9
dg1bn+l32QX1XbsD73eZIIZ8136W5xhgDvn3dZoaLCu2nBGpWGTniWtVnQ05
M1dwvSHsMrNOTKlRHDLStY0PJic0VhfiQLkffSoWyIcVbyCpcrzjGH32V1kt
91r/8Net/TzHAO+4XPsd1x+6uMwB/Yz20nX+AfZZLGrodpRc86s309hGXb+b
00IAt7yu3jWgeH+07zZK17IbFSGlcWD++tFDBMYC0duP3gc5ePp/0cL1Pl21
K/zdds0ZDjxkndPPaBfogImv4g62E3gy/gpHpRP56ULonFIKPBYdUmpeG3Vf
B7tv4Z5kqcYXTOoWert5DmOlblFovp9xRmXX9ONBauotxo1ixtwJoEwcXDDc
rpnTl2XrxocJA+oKaK5x/d4Eu1ERUhtxY3Fjz4L6rrIto31dsvNRdpZfqdVX
G/VEP9BSPJmy31LcLmaVSqfiq6oJO0/w6f/DzjD8OcblgQ5LNqOTrrhiJjt4
1f6S0RroT5lW6mHgVVayezQkLwbTU/xURqWmnq3azWu9ww95liOWAfHq8u3n
9i6NX0/l9xC+bu1fsrbXCSq7ydTU8M1nfZceLWmWJ0Lh6NNFjT3wAJpWS6bT
pVMRrJ58ZeA58iKZljPFtmbza6Y/BcvLFzZ0Hzt9p/TrhE5YtMCy4dKEThk6
VegcQDcoQ9UC1BlXKqWP9999O/2u7Vjk0zVBu+wqihxSFo8LVnd9vra35eDI
m7czGN45fEz41m+N6PBMZWYMlZiyowbiBqwQUTTp0YdLRbwAuJV2Vy0bNrF/
TguYdC1q6IZ3tzf7iTkvWNfnCl1atmuSrPUP4xSoWLc5pogscajQg0cMvJHR
pOpn3m4nuKjUQNy4rvQXV26yYYbl/pNJPsOoWjZ851ESZ8J8xlPK9fsThaWc
DZqrRXDvEU2pclinV6HhzJkvWkKwulzo7S6qRs/OzUlNvZuPMC/nhiUtvLXR
79LfQ+NGDcQNuBPLMrAIbj5za1N6hmXDaqI9CGb6bFELHFBCKDyqvtlmp3Pc
RUwH3M+nA+SClg19No4H9dlgzlPWZNp8YIRDBh9iuMv4r//99rM/7LQ52OZq
Im50a3ShctY5wYm3TtkwrOXhgF+N9DHRAj3j1uwZgtUK/3cvAidHngE+zc8A
956Uve1s1BbAmWplxSaKTLLee2nYa0C0pwjENCcIudRAPuXnvjuqRXQ66lss
KJuEV4LWwIfssAZG8+IjSoLJRhuXsszjiUF54/qPSdu2RnE8lTtgmJNlPVMl
d2orZVvnVXuDf83kU/KWrBX7S4+fyxtcfRcf8RkGTGzg7aK6NTlya9sJG1rb
1in9UPnHPa8Nn0rK/KfsTTAB23+5Cmu3ygof7Djru8T2ylmx5UzjPsMuxge7
HVE9WANxY/MR9W4yzPpxS3aT3AUwTg4bbqU8GX+17fiVJc299bvP3xqVZ0Rn
r3KagFVSVomH47HFjhP5rv3s9ztUnviY7oQ7lOm7L1sfMuEajNUFNk7SkBqI
G1q+mfBcgzNcVtTBDuwd0C81NPeIsQJKCcGr7dgVeEgt9Ha38dUyKgUi2KLG
9xkEWLDUEbsOUedddvbTNUGtnCbc1KzTFrDcgEWH0e/qV6rTYUbEYkjk1EDc
WLFloGGvSlcIPNfqiE30rIMWDBOTb3SO+XFX+Nt2rhkN1KIpFpbAvfD52l64
ZYZvPuNfOwrv/tXG93t60zNZG0tKsE5DqxAOrqhKf3CKoOifid8dl8PX4uMs
RqWKqlBzDcQNuBF+0tBMgH/iJhWIqravp/Ruxi/Xh3i2xGIGB1tQMf+LTrUw
A4dhwDKB20iQ1b7z336oiLJ03alNR+ypNh+8Oqaz+claRzpf7WO8Q4fzbn9O
2QWCR3NZfdp8z6fAQk9nMfJ1a3/T/mE+I1m9+/xXG6uk4+EYni0zQzeewdtF
7rwodlu8fjO9vLUfZyCq/lBMgcnGugMfKDfCqq10BsIT+CyWNPdq2a2yblIY
M2v9iatvnlm5sl2g2sin4K2hNW2TBTG4SH7Bp4m+tPqHYYKP2yQzry3wYZh6
/mcaZuD8Mzt57/UPTxHm0Pl3qdxTGkuP9t3WOqCs1IQ6JsS+isDHV6qHyRSt
XaD5Hjfw1tBaHSgLah4ViZhMuXq3SkBAN6jj/Zy2an/YeU51xxguhm+2DZoo
HrAC7oKWpbfQukKn6IURWpUbRXQstKgw8mHprCFQLZBDx25OexdovscNrVsD
gaUZHxmWfb/fIMyqL9vQt9bPY+kEg4FJhU9DCXlbp3xmeHqTYY9MWYhAdb6D
3GvhDnTf1P+8qlb/WuR0Pi1iQLSn7Hv51L2c1yiBm9dxAy57nVRajmORTMvB
EcJeg01HZAdb1uMB7j2Rp+L9l9Wv/JOKE7qqRRQj8Gp/UDHz/7q136uWDmNK
69HLS5s1FaRzhX0zduZouH+in33T4pHSAN47/JD2oFTQqjGe13EDZUwC5zQ/
XKxk5iDBQW4bfZRXsTcunbTkK7F5Z/gmv5or/MUrk7+wlvySo1wz/OIQpqSm
Hh0l2Bz7HPGhXjn7NpUxIL5RJDPDz7ht3cER1U9nXudTrt4d1+9c61PSjo+e
s5V9m5ubgzk/rIlIDsb0H4dJJhZ1q5rH5Qp5QG5FcTnFFWtxo0rbOMrXvHnL
KcfUrRhukkgKSE297GrkdKx2SPjHptN8VruwrC5LgdVAPgU7YXWU92A1zaFB
Ce/B4/1EuXjMvw+ydxXf8nMErnydA5auO8VTqe+bbYOqj3gsKalcvzAC1flI
CgJXbDnTwKy4F868FQ0BCBocDJhw90lVW2lexw1sxNbZWC70qLKdjRtSi8X8
O0zamQ4J+La9ilBD0/4L3My/UMtRterg1qickTx/nZOcEW55kexdyP0LbYb7
3AlZ7TtvRQsF9+GnGW/cYQORqtJU0Xcp0JL3XZI8nWnZoT5Q+LvU6VQ/erjy
l2/Wc7t4xKUlFvecY8RGGEuamctJyUunau0PeAeluSwQcMEIIaLyn5IpA7M1
66DpvNbtUMpPP0fY7WBbnMz0DMsz7VEjHgpm3kWZzz9WW+bn40Am5pY8I2Pj
yfFEIpHMyo6xbrd/JJlMyn9PZ8uPdwbL1ofW6TpH42PuxCBbqRyjOhKrfGGd
3LFFYPYVufMClbX0NYIqnaoY0XxA9nlfsrZXy5NiUWNP2zFNHXi6bDpyCQaz
tPlU1S0mfKarNtpbByKSFWf535V02KFetvlreO58uiaoWmyPcSAzGpAk78BI
ODyCc4tMwCN5O+UvxBLpyuOdAMru6d8a8CvDMfsYt7ahoRL5pHHXb9FP6oOq
tvXWwUIduNqrbuzgkRzaUWFCDhFep6zd3TbALRXbuO8CPOtJjrx8+/mqXbKd
ysRLM9lSfeAC2HnCvLww7pLtDjCs+IUF9UJvt9YOGMaBxEC7JLk7gqEO2SW2
PZFNwN9drR2hYAf8vTWcKD2+FHbDrgr2nz6qNlVbyl7yYtcJOQ6QH4+TTEZZ
HlQ/hpfU1KvflsVNgPeLlpB+8xrTnYQyvpdVtkiLtLEvgHoD4OysbJmxr8v8
46xq5ZJ1flVswkpX3yr3fjZbePilfJIUGMtkC06xqYhP8gQzJd/LbqiGIOkj
yynbg6xFs2EhvFTbhr4S3Alk1NKIldvwImkEhhUE69oJuMIXrO7ao9u5I1dh
GTmBVvi6tZ88g4ltLAO0k1+oC2TRAwKWuky7VPRt0DEOxDvcUruyUZCMuCRX
NBlzS9KIsv6L+FySL1p2vO3MzcnxlqRkYt3BEdZZA30b+kpeK+mtQ2zcc3CT
9sTgvcQf1WtBUa94nME8vAhqhutve+5R8mJ8it6XNp/SUl2opDB4ylUufxGc
k6rARJFp4TGsLnXiUj4OpOLthfSJPyxH13gIViqS/DWPfyxTcbzd4CY8icEo
usAbdbcxhL4NvSouZl0qoYsGLMuvxeXCuRGW/s6Y0oJR6RxTpjvKFLkRWKNn
pxJMS7UbV+XSZwIVLM9ZUrDUqr+lhaxdox1gS+NAJp3OlO7VZeUv6ByPwHOt
6/wDPt15RXBfiEQqk8M1CWtzVcExHWASyMihw5D+JBbqs+vCyBW8BvRDE274
cHDOzUvKG5npwYdbv/s83WE8nZC39OG3tvJDMB3GqPAYzQd1VD6s133x7M4r
kvdaIiiZQNlP1Rw0LZZt6DNaeIkPi780isCtgI1IhGXbHLbXsE3mjm62d8hg
AYxpcJpqyMKGhTkU6qVbbLa9zdL+DyObjpuw9f4Ubn6apeBmL0nDGgc9xkWN
PUYFZvFOuWFKfkGfPSdl19FKVwgtVm4dWO2j/DwtpeCZorfZcuN+9TkJFUw8
6LGKg65gIN7yFktk8Xdh0RV7tO82ytKqfiK0+lNK03lMtxFKwV0LkrsD28mp
b4kXyefUDJaIYPFJkIE7fNuxK7AyJT9+05FL+h3lFjmsNH7qz3+wMbzv0iPW
1w92BBjKZGE/i1Z7oDmu03ASrOpHbA6IkHA7Y0oO7h2tw6j0pxT9NPd13WBU
zlRGw74LhHLTKKTATp04PTVjot8kOztLmA8yitH8Ea5rkqkpRjtUJNJJqJ/c
3nmVRSAtBfeBL982cMPi3gtdoRISi66qYKc/dckjbOnCFyzrtA6jEjcwJm89
foVRcV0lhvqIsSWBkXYTSv/paIBo8d32syy0T2HRYejHouU0vqoW0ZkAPqaq
fqZoCgCvbcfZVpujGq2hjRQWpnK4SrVe4c9ib2qvsi77tv3sVxtP62TGqcQN
uHeWrQ/hRw9TQcNjNY6h7Bhclgvqu3YHqogGm+Pxi+p5RlVQaf+thp62aVZu
NVaznfjj9cHuW/7gTRgM9YQjjockHyE19dQpztfUB1AKtnXob7aUgXV0dIVG
UfTYunRA1UJco8DkeVFjD8kTmVYf/aPnKZgD8NndMuFZA4sao6lSQjAjbGJb
GwV8qNcwm0juIG3HIp/UB2HVTHc8i+WeteqLRPiAljaf0u9utg4+TA0tpU1s
iVQFc3zW885u4wUA+mBcJVlAUdT7wicvB9nDSeOeNezE6FBzLGL8eQQPeha1
E4saSJXHysAWWrqJp/RbefPnMEG9BLwv+V63adYdHDGqb/9sQv6Y6HrNoLir
9TLdVT7KNh9VtZ5yDPS+sHxax5OCFpiMMJRNw5bVqQx9rQkTS2Zkbm5u6bpT
dE1Isf/XnPLkA0XB+7SGjrE5DH1SaGU7SXvCU8qKLaQysEWo1ISX8QulHA31
HgpyNSG6el+si4iQO8YrXlCMjoUbL/7kh6Z2FNcRq6ATgsJu5lRDWfRiYP6C
MOHYXygghKt3PwNBYAjUnxHLwBaxEoq1QEtQ60+xrcevSE0qkq2mgclYi66g
TRG6ceOfm3nIpUYUT5yqJkeloOIZCzE6XBK+SKarH1oBunhQ3BrFpaK5AmZs
FaQb9vs1vA9UwSCDlcBVUzAmIO9pKsNEXZ8+EIWo1JLhdg2tfsDsrGyoR5g+
oBs3LKomEnL2qpwau2ckccPODgMN48zJcWMPmrm5iipaLjmELG/tX9zYs7Jt
gFZSDGYv5BNyXNS0d16tU/S4qAygFPKepjJgLUD4FCYEhZus/xx0yXxNqbXN
kDge3bjRepRtby+CUvbPCPrEi7w13tBEyI+7wrBqNve9WGNjziRUFZwAm27i
a9g7VEem2UsIqv0TVoG+UTZRl647hWOg7oyAGqcmKjG+205ZwkVZX1C4TazM
dSsxFFfp+qfgw5d1b6y5FldDDdSETM9k4b4wLfiGEZ5iqfC6gyNWmrC2Kc/6
OgJvEUK+az9LWNaLLFnbWyxCC5y7Rzd0wC9VVQNNFXJpQUI2HblEJbvXnzeL
pLNrN3zzGclklYV/CjZxs7YJNtdq9Pd1p6wowaqCDUqmK1FJVMcNUVWoWR/s
0sWHvvVWEbRcN5Qux+fOl4UaQrhhabUtZGayC73d5toNqMuRNR8YMST0pAWa
U9OyB8IORBK5pxztdQrMAeD5Ah8QU70Lc9vIMLCm/ZRtdPBUWynggSfy9zvo
+MLruOQQMnT9KTxY4SwZLapUpe1YxOiVAFPuz7zdW49HFhSklSGSnBi8Z/3W
KG66mvherOylKEe2Zs/Qv7dS2AbEPmJacv3k3ug5Br5LhrbQzbHugJm09Y+7
wrTu0CJYFpKxkBBBTWMqBjq0zGLwFrM+aTS3SY51X99vPxsfewmfF9ywMJgy
q0ETVLX20wFn0RTVFD1GtJF1gHt8lS+8wGCOQAt4sH5PLFtHPW5gPX/kNs16
/jLgnJP/gkXkySHtMubtv1z9rFqzpz7YqkDFxMREs6cqmK+0bh270oK7ASqr
/FLwZNQRyCUEV0CED9MyRmhX0poQiNPiPqVqPSyLJS9vox43HipaCqcvMbRI
U1YchqtEYG27xIgwBQnrD100WrdcBiYfLUpNIhiC7j+hMNOjYh0LN/vGDks/
ZPTZX8VtUosrX/h1TAszWqmKUeWfm09b2YYqBVU4TBSllIErbvJlAvW4MWnE
ZNkcS03tcKJoNl1lGOsNAjAeiGabrN1fCKxz68g00KrSuI+CdayJ4swy4OTA
agV/L4tbHPrq3Pqg0oUVu5MyIILR2qJHmwnrvd7bOq8ubOgmvzvo5mFz+IvU
d/loZzxLMZf6RIEaunaoVPZaYe5EpctgLz1FO7SOtZIGnVZ6lg90UyjPxse9
jtYlCYsaurdaEPcwpPeiD3xAn9QHKao6wLzOet589e7zhN6jLPKwiGtDH912
rVJMNNEjsBaAb5yYpCkrtERXK54QWt7iMGmhpZGOWtn6YsL6TFKaP+eUG81i
ATyscWAwP/eZ37GBoEGrgwz7oCnaa3p2nLO+4Q/Bx9A9W4gD5X70mbGwB//m
C2dUjtfjh53nTOxbEoLXgIldO2xAoyhphcqie3WdyEhAJTpCxxMdfjRu46IF
Cm6bECMqQrf93GK2+v4Tq/rh2EmUnqIwWcXuKoqJgw2HL5XuG1+Lj/976+DV
uwZ+Pi7EDPXuSep+9KkOl9QeTuQyCZ8k+WOp8uN12dhBpxxOlXH0rDEun47l
cLdGqYntm45gZdAyP/pqI7VpHlxIsNjUN2fUB+VuTDSDqLL9l6swnhVbBozq
uCJYG0DimqEFqiVQSangDqShLgl95PKS1V3Z2fz6FEWBSDRPimCQNyTuKqn6
0aejLskdU+YZsgWk35jPI+5AFn8RuuSrFIzna6iISJfyTJlwdlt+pGIktNgS
Mjs3R7eQ3t1myR8BgyGtpyrea3JCdkMffIKl6dR7Yy+rXmnwIJOaeqzs/GBf
JBWRAawio2isgNnqooYwbiMTekVhMZshuQNEUvWjT0c9Lh8ublNRn9ugP+wv
irmJjhiyFUzbzeBkdZCeIQL2AVlXkKNifvQXbfWMLcciixp7TKefsDPXyiO+
FIz5xdeGwxchVly48QwWDjDFGn2mvvaEexNuIpg7LWroJveE1WIZJWvOhr1D
hnp2qlLWpXJIqUX8zNtNEpoGr47Bugn7sg0t4dX96O9edkuFuBFpL4sbpaj+
zD7aOwmlmNble/6n7GkIZxWe7FTq6+BhWmdQBkQLWJB6rG1tofsVzFGtDwY5
MXjPSq9l3qaWkk3e5OvMyq0DzQdG4GcubpQVjOEWRiMJLK2HRxUs9GDNCNfe
we5b+Ceac8GRVMJ769HLiy0E0iLLaGcNrigbJsVq850nrmF0JSnG+LnvzsKG
7lW7wiSpxsp7v9yPPp1ohegxCguVTNAjeYKjpd9bdTBYX3edgRlZzoIuH27L
L22W27StrNyLYNJBx5uGHEypWLF9RGGiC/Ra8lFu1HRUxNpsKsUkpcD0G0IZ
GlsUX3Dlw59LmuVe2gXKV0r/hNfq3eetp6vyWiKWZQwXWi5rKQN+tTV7hoqX
4uYjl/G3Hr5Z/WJA75I64z4skoYffSoWyP/dG0hWHq/LbaURkoW4Vu79rMzM
ZOa79rP5C4mGs2HBwZCC+gEuMK2soQiboMnBQlbTuzdo00Zd0BV3NmCRArfe
kUL3rs7rm22DME94PUVB2QYfExYVjWDkdEvIENyFxuuncd+FT+qDhKneVb7w
Fy2h3YHrRudRpXHAnB99JXkXTqoS0EWs3K04rYWXlZV7EWxqo6LyN/MuC0Oy
UkOYt8+2nMwtMv0uC8/rvQb9K4v4fosuqKdcnVsGTCCXrQ/BDKQsVmAbPv5J
Udvk1iiFp6E5d7+q4LYtLC1zisoQRMs6sqK7L83WjLGo+6KVoFTFil9ncVve
ysq9yE8/02x4IXeuVCV/WqiKgS/f3G+6GlbWrGBpO4vAPO3ybdkzEZ+w8KiF
yJlMTRX/pDjhQWM+i2kvVGqirleJ4sk4jZGbXw6MwMmv+hjKzJgsocyxiRu0
auZVybeum1qu4rY8nFgqCdlVu8Lf0nOvyLuHmBV5YGGbDpef6a69pv3DdLMG
WsDqHtb1uA1L/TleCiwxIDpZbKDIT8XptcgVWbruFHq7f762t+1YBGYdP1bT
NsTBmCvgp96fgvy98FtQByfA5r43M/0uem8CJ5yGdKhUobsxjpv/pjcSt1Cd
/CD53nNTCzFZ64C22okOMK+AT5b6NmwZy1v7TTRil0K9GKAIPMLgQTY7N4fb
/rD6qCo+gKlJow9Qdv0pOcUVlJHXJ5V2eIjJFhsS4cm+gEaReRHU/zdd8NBA
WwMzV6jMN5ezhsHAkOiOx3Zg1WZR3w+VqFl4oaKYVXH/hKTJEffEHpnKlTOK
Gw17h0yrfOtDxaMKYprFWTSudnEnigqmVfqRb7YNriYrESTnsVKaa6j8uMiX
60NUxAEcBdyMMNe1kp2Bh3sdmQGrUXCd+yIpFymdPHcf8+ATuhplu5Sp+1TG
zHySUdyQ9wzZGCLU76Zg0bKv64bFVAitYtEipl2BENmanPZ9Ojs7t7ixx1yl
5UKzNrVOBvdgraRU4IKpM+XFUBX0UtkduF6nyH9dUMqcdCw25ubmILabFmRj
FDdwmsSiRYXKg/W0UgRipWQLy88ousmbcyFEYFXLSPNkrX/YhLECC29EJ5CZ
frfQ2912zLyOR9/FRxTLaEvBRUex4iszk1267pTq1uhUZgYGgMWZptv5GcUN
TAtSbPorAosU6xprWCdjpbEaLW+oFH0VcbcNmEvQoJK5FX0JLdCqJpkytt/4
mtl4bGf9oYtL1vbOmq1LoeVEXwnW92I5NJZq42dXWtJza/RPf/AmPF+KEcb0
Hcoon4IaTeZSw/pQKdPFG81K2g4VsawomVeCwdbE1ig2p/QOP6Q4GGRIaU8z
Kj6Q1zqgIZrqNLAEaMxsfZ05yzASYPLctP9C+u0MLOTvK50pBRvl951cuIqB
l2tDH8x8zD03meZTcop++KLGHrp3Fkyx6gxqC2gBK/c2Uy48yJZjESpWfaXA
5SR7AxnfT8C6FBa79KUFzOSY1jpwPriv1W9WPxz1f1gYGkLEwCK311PTrxTH
WMz5DpR8dg37LmDcsF7ozi5u9FhwrNACe1qpaKzBiqBqYYwOa/YMrWyjnzAy
92PRaJuWGXQpBZVpYysO1Dpg1KBkL3DLWxE9QLscukPSorLAdVnBCM96Qodd
3MAFF92UE8UsxqaOS3+3YN73dav5Gmwdth6/ApM0o99FknQzh+xEaXxhiJ3d
V4xrHcwLVllwEmdhxqHF9Idl5FMZ2Vrd91sUrhPr3nPs4gY6wljZe6wEY9F1
GrEINyhMp2IXNnS30/N1LYKG8kZ1LJnaecP8x2gJX160h4aZlAOxoiPdQqP6
iByp6f1iHDVjaS0e2cUNFkYqmMYyV+FWhpVlFKwl66w5sWphrq219ehlRtUy
OSWD4DKYis0LNzHINjoBKzrStJxhCfnXT++rdnGLm5bSAqN8Sk4pKjBndKID
xa5PVOsyN5fONwQxEArAyiKjajnmnFgJyT9ejUxm8pYTDNZNTsCKjvR37WdN
2z+ZoHS7DOVKzDWSl8I6n5JTWnppudUge05ep1VOhjYW5rrbsMuARE/JKDiZ
NOqSCee52bLzsha9ww+Ndqlg7eLrNxTUchyIFR3p5a39dO8IfUrLtiGGwHVC
6yczjRswVLpdKpuPXLaymVkGfIg/7DTTs4k9aFZsibRAeWHv3iFydda5OQqy
xjpgDsuQmgqW8dNt6ncOVnSkzVmUmqb4QcBrobd7mwXHujKYxg0Y56KG7ruP
k1RShHArfdt+luKEHJPpL42vegqaY/SrYTEI1CkO7NfvTSQIyvmwOPNoH0Pp
CQj+hgpZt/8im42yG4/trNxqxiRCbgdgpkujCoozwIWESQqKstVM4wZmB/Bl
XU/vXz+dgZ9jUQChFCyXMmGpwEJcqwjMgpY2n/rMK2vtkmi4oWkOi82WIiit
Ty6bXOYgVnvAvNdEOpVDhC8D+7Dghcq6D+lZDDCNG08nXsFdierTpktzi3y5
PuTZcY6WJUeusMVhok8c4yF10V1k/aGL9568vP9kUllGVd9DM20oQ86ZiLE2
wPrd53lmDfhzvF9+cBiVCYIJKq2qRUImJt/AhQFXUR1VrZgcy3xKkbwhpuUq
oEWNPduolkygDqoJryJMMVgvntEaFf4HodIIO0mHIkbr2N1tAw1mG7TnBSOm
TCLuYdH+VfpiX/rAFXWw5xaty5VDPgXBriuLmooogEY3ZmK7t4nmO5hBwTqC
4ki03uXTNdVrkk9bMIYgxGje+e98d//4gzOHwDljKZWrd+k8QJ0Ah7jxdlou
cD3YbczYpQzsaKNeamWu7POnnyMcxLrztaPVXLTQWI2ptCaWKB8is+aZ4777
xx94ii1q6N5qMD2Boj0s2oj480EcyMQ8kieqSEqk44GCEZPUadCPvhJ4AFlU
o0I5rF/p2WEgrg19Jvwj+FQLB4eIjMvzLZaW/cj0+XxtL2Gj7uspqxoF84If
d4WN7uHgB0qSI3M+JXEgE/TC39wxJW7EOtxu/0gymUwkEsl0Vu14A/xo2TIg
b/5uSutSB/joCZ27S/HuZdIMWwahUvE2U61wRvlm2yBhoSPFnmUng7r6b97O
kEdsLId7VRPlcMU4MApRw9Pe4vYq841MwCN5OwdGwuFYIq16vCHaZLUKS9c2
FlLS7ZLLme0X8Ow4Z65gzBA37k8oValVdiPX+oeXb7Yksk0CTLEIvVTuPbFn
948zWEa7uLGH0Pk9V6h2ZrSdzhmMA5mxoCS1jueyAbcnmsnlsol2SXK1doSC
HbBaaQ0nSo8vhfBdflEKHqzM0ND0hKJvMiLbTBjXz+STL3hMZjFP4rBjnd2B
6wvIKvzRlaM2dv90QBNkfBFmqNmJdfOh8t7vgP/z+kOhTo8SLcYzuWzBKTYV
8UmeYKbke028I0oPWZm7FkTPTNqja2GusvGrjacpOi5pgTXnVQu8XVTtn7TA
EtkYQfEMO8luR4HbOPgiXD43MvC4sQuMA2OxyMjISGRkoMXl8oeiqTcxtySN
KJ98xOeSfNGy442CoutWntGMJB1QucJoJwU8NUyo+RkFy5IhJlyLjz+d0Oz3
Z9qcUgQ1DDccrr653U22nVsDwOMDflP4jAgvBlmK33h1ujP5MA5kOt3eqDK3
iIdgpSLJKRWPfyyjdbwBdp64tqDe/LY/eodRLJRFjvfLW1XwuRuS3uVzq+YU
VxR8ommVQ7xhpgRSCaraVg0I7KR3ncaJwfjW41ca9l0gTK4tM5W8cyZ6cSCb
SVd8+qbjhhW1k9z7VjKavgO5wsNRLk4g1jqGNX4dDWVXEm4++OPy7ecr2wa0
uvkY+ZurgimtqoUZe2to94+EvIsuwQOR2+OGAxzqvhAraie5YiuZZdWRMgav
jGHcIFdF4PmIR9o7r8IaQdWz48n4K7p9jvrAOgVGoq9RP993/4xC6LKar52j
IcXvBDj0pyBW1E5yhZZMuq4KuUJzB7xgRUD4LS8V/cNfaFeg6QDzYVk+a1JF
Pou63aQ+3Yq4os5mS46x+JgDweadqunySnXxeQq3/hTEitpJrpAHnDPrk6XF
7UdJ+LGLGrrJ+8T51zUN35Q9JdGEqwycxcFahs9IRgh0ob/a2Ndi2VBvHkHo
MD767K86xbmVz6hYwy1u5MyqnSBtx65Q9zlCYP6PqcMbajdmJfxNhfAdVRcj
GFIo2tTqgzVdA9o2TNnZ2QX1Nd6cUsYsmbHvdaWK7yIDbyxb4Bk3ZLUTsyvf
DYcNq2qTg7sEhEIcnJcGOcXOWKtvtz/fDDvJZyTYJaQjyor7tLCw4jMehyAX
4VcrvUMjcpICmHkBz7iBaieq6/SqNOwdcjNrCXmXnSVfQ9ny4Pi6tV+1j4ZR
mkkLWGx+Uh/cpW18j0G15ovMy9h6/MrChirV5rh9al29yiHwjBu4GB8yVSv+
vdwSwrCa+rvtZ+FFciQHnZxK2juvFvsgSqMEhmJyBT/r/GOTnnY6rptomXTM
F7BX5cFTvVkftlqYELN1JtzyKUB6asacTk5OeeAyFZCH9SlMOUj6L9iJmeuA
hlPYB/Gvn84U7aLY+RRrAdMenV5gnP/URqs4Odh0CdHjyp0XWl57WOYxw/GT
YgTnfAqycusAXHUm9v8/X9trxT6+KqiNAB/98M2EvoQy6mtRr1zV51HiL1Tc
wqqzrzaeRqGenSeINMEo0nbsymLttn2MYyRFULWE7DLQ0A1nBoKDlgjYtuN6
523ewTluwNJYLumv71KtYtICBf32/c6wRBN3LfBVqvF74/7E5iOXS6egnLcU
kNnZvMDUpNLsBq+9ytloPXp5KT1DGRKOKrZfe09eh9ukcp4jF33x8k12FA17
h2AF98POc8s29KludMDijqLtke1wjht/TE7BUt1o/wJ2hpoQECYHHpGwKoco
AbdnaTMI3ial2flDvShmTrkCrSrf7zj3/fazmPqBF86+YO0GKziew0CvOnxV
ihPC3cFBDMSB4HWyQDktqrk2z45z8OI/MEZwjhu5QqOKIUNn1MXtYWkRUgSC
BoSOYv8dTDbqlKbU4gFbuehrVQLPd3jfW6P52xY3J3/cFf6ebDuXFvAwlZp6
cQyVYsirfFaF3eYpqPOAL9XMF8xG1jHz4uQP/7hhYsv9DnuLkCK47Vncgfn3
1kH465Lm3mKpKsxIbVFRwA6dYiMeavWs2GKD4wBETlhpqiaV4HSt2VPLDgha
oKcGvP7105lKK1IWHuv2wjOfgsQUoaSh6waCALq0X4tTFu1RJT01g7UcsHiH
4Ia+aaX94xA0bDEHQQUSmA5hHIPrE764bH1oozXBZ3NoRXI+ikbOBC6MJWt7
0ZK1bOdnUulpOt5vxsTcadiST8mZ8iVEv7D7uvlxisASAG7M6/cnMGjAtLO0
0AsWC0YF8KnwQLH4/HK9rMixalcYH2rmfBysoyUTzTrt5WRmZ+eys7Mnw/fh
zLxIfrBtjvas1NVxbYR/3Mi7ZBrRyVf9LNjRp2gErfadx5lG4Ny9Yicj2rjY
0g2N/fv4gljxSX0wn2biogRShqrV6cfgnFKVIWVaWCYDdVHpB+QzYeYD/7gx
V7LWS7+dIal1JHQgogXOKuG1tPnUQm/3w8RfxSp0tJS1S+T/H5tkYTp4pmNO
B7vMIKjyH4msYVjf5fuw4BwNtgjtmWoVXMH9OhBPpqZS6cxrxfXARC7A4fCP
Gzml1RpXwd9tP7uAICe767coPF6pN9HrsFpZm0BwuxR7Pj2TXdmW7+RFWXVD
mzMUaTt2BXfeUJEDi8ypa64S8kVLqMxLC+OtTtfbx8CEojMjNfX4gzcXN/bA
uhKu28NKnH/D68HHAVviBuaysXeSpA1q05FL5Lo6VIAZxYKSfT8YABo74izU
rq5G7IOACIZNUj/sPAcTIdZObVrIKrsfJhxxMkbYVlyr4OKx9HX/6aR1/yCn
wT+fAsBkY+m6U6hzW6ctultkzZ6hlVuZ+6PpgAul8ZdvYIIEM58/JhmaseqA
W6MbOy5hslgJHcydU7Ro3HcBczpFGHljzTuWrQ+Vxo0txyIrtgyYsPdyJnbl
U3KK0zqe0iVre5sPjFStlIZlgr1VASjsA0FDnh1pq9awBp5lh3pjsHRCZ3N4
Heg20yRIBbgdPv+wpBxr0qh7Y807fg/fhxXuii1nVu0KQ2jFT6qWir5yNq1T
4HkNkzd4PZ14tfd3Od+t34gq19rZKj33dvodhDgYp0OKmlDmok6WtbTtJsVC
hdJejMjtFzWWNbDC6UuPTgzee5FM46XOLRvIhw/iQIkffWYs7FFmIx5fOKN1
PA1wc09fqBwmJFXXMqw52ic3IMCz3t5hIMUulcoOEW7ATQEDKF2y4eqp5p3a
CJmeydZYrCilJA6U+tGnOlxSeziRyyR8kuSPpdSOpwOJDtLChur6jax5+eot
LFENtfGyAzXVCY2eGYEWEqXWqCgS8riaI4CgBijGgQ/86NNRFwQQNG7rcEt+
qz6POly4UUVZd25urk5p3Kb7viYYf2lG4ZAF8CyDtZu9sRTV20onYCfPyeV5
E445SwJ2SKp+9Omox+XD6WYq6nN/6A9b5kltEezL1lmnZ0Q1kSN5XKGyjg6P
r5RKJ0HtUXnvl/vRv4y6pULciLS7LftK6/D4habIP4KdhlVt2QWcqfxczJl0
C+YjkqoffTbRKkmB0Yy86eGRPMHRsuMpgkWGndpFhuhroyW/JrCLuYre8B2/
8hYtFNjFh3HgvR99KhbIT0e8gaTm8RSoqgGYF+0Z5iHaIzBEWX782/azOpLF
glpCLw5Q9aPXYcna3i0/R7REuR/UXA9yzbBqV17dayoz88ek3DVwuFZ8kwX6
2FL3VcaKLWe+2qiZHbhtXOdHwIfNR2RV5McvUk37L2A+/Xat+JEJ9HFC3EBh
HKmpR3VLDfN9kdsvqL+vwCLYzv/52t4F9V1N+4fhP2ZnHVHfImCNLX1tZWzq
uITVj6rOzuiBTmj6LODJ2+l3P+w8V2zg+qhs6D9abOxrK2Nf1w1sHFO1csN/
io+9rPwnge2k0hk0lEGxGruHI+CEE+IGWuPBk2vFFpXdeFTteySql53K3Nzc
0uZTdR+fLezHjBPiBuJTRL0qG2PRgfH5nx+X5ej8ou3YlS9aQvy9qAR24Zy4
8dvZe6rdDTD7ha8nUzVi5C0Q1ADOiRuqQtC5goOels23QCDgjxPyKUh87KWq
mpboehAInINz8ilIwdOqvH9t12/RBfVdjN5UIBCYwDlxY25ubqH3A/exzPS7
mw/+aNp/QWrq1flGgUDAGefEjZyiP7y8tf/E4L0rd16M3ErsDlzfc1LWPF+2
nqsJgkAg0MdRcWP9oYtYQQQLk0/XBCFcuDb0wV+/bu1n96YCgcAojoobr6em
k6mppxOvYNZR6kCBTZcCgcAhOCefUsrzP9PDN59h0FizZwg9nQUCge04LZ9S
yVr/cNP+C9zeTiAQEOLkuCEQCJyJiBsCgcAoIm4IBAKjiLghEAiM4sx8ikAg
cCbOz6cIBAJnYlfccFr8cdR4xGB0cNR4PtrBiLiBOGo8YjA6OGo8H+1gRNxA
HDUeMRgdHDWej3YwpvdFBQLBxwyjiCQQCAQCgUAgEAgEAoFAIBAIBAK+pAMe
SXL5xgt/Hw+3S5Inljb2E/xRxV8ym+hsceE2sj9c7tQw/8jE4Ny4fUUb6Kx8
btydBs5NJu6V3NGSb0jHOyVXRw2Yccq/iCT5RooXTkI+Nx0xIz8hUDwV2WS0
FS8cj38sQ32wAuqkA2754wrmPy0ljJDHjfRYp3y81Kl8QyLkgSshmc2l4JKQ
vKNZdsPmQiau/HKFX0QJI+RxI50Y8Uofnkw5jBiMPE5FvuvlXy6Yv26UMEIe
NxKRDun9qUh3uiVPII5Xozsw/584tU8ab3y3PyL/LRl2u7xetxcekenRAa9L
Bi6O0GgKrvkWnEm0DBQfCPHOlpaOAHy9IyY/N5LxcDielP8hE4FJTHS+3x4Y
KGDuFJF/KZiJubwtHk8n/KqjA36XhOfGF0/nMqPB/LkJFa/5dMDr9Qf80vv5
RibohcPb3Z7amW/AbxdRfpkR+LVaPF45bqTCfrgi8NwMyOcqmL9wQsWZRCbW
4m4NdHjhKSOfm3TULbXGxxOxSDQ+OpZMz/fnzcdAutMl+QeCbqklkcvB7KEl
GOn0eiPpTNjfGlCiQTzodfmi8FnDxCQ0Op4u/1gz8k+Ild4K4x1uWPqMzPuP
X/6VvaFQO/wBU+mA2x2MjrS4O1LZMX9Lu/IbpyEU+KKpdByenq3xZCpdNsfO
xt2FuDEWapFawnAbed0dNTATT8c6YHoR8rm9IbhwRj1SayTS4fFFM4lwa2tQ
OTfyGi2SzsXhamgJJdMV52YUTpoSN5RLS3K3dnTAWkfqiCbt+IUEhkh3uKTO
+DisMDpjo34XXOSpTrcHPu5kPNTidrncHg/MIeE5ko568Omg9hOKcSOjTM49
/vkfNHJ4PXtiSbj+vdGxETcsxmEGIi/Js/GQv3BuYK6VTsf8bgit6j9BiRuZ
GDx/vf5gqLPdBaczFJvvoUMOla7A+FgQ1hWjEZ/bF0uPdignIRnyt8BUzOOB
yZoHfveY3+NXm3oqwRbnG/LJiSiHJMOtLtUzKXAWyl0fz6SjflyDwCXeIceN
hLL6kD/L0YDX1R5R4oZfbYL9Pm5kxkLyrH5Enqtns/M/cih3fSybi/rcyhok
kcvG5JMwPgBPR+XcZIIeyRdJVo8b2VQsEhkBBuBseUPRsfl+dvCuz+RSfmU/
MzQO50Y+CeMDLZJL2bVQ9oRHknLc8EVVLhx5xoJxIzsGF1tgVP7PqN/l8hvY
XBXYhLxO6Yhn5PmzhGmRtBI3shG/nGhxu+Gh6oIZaQrihlt1YS5vailxIxNq
KS3M99TA/oY838jAdR3Mb1Nk8CSMd+TPjVs+N/A0Ve4N1Z/g+TCfIkcet+q0
bZ6hzDc64boZC3oxLYInITs+UnJu5CtKmW+oXDgZJbWEpyIVD+bzcG7faA2c
nY+bLKxJ5/tzkRmZio0eQYFsxWYGCRlT3yUQCAQCgUAgEAgEAoFAIGDOfwGH
QzZI
            "], {{0, 236}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 236},
          PlotRange->{{0, 360}, {0, 236}}]], "ExerciseOutput",
         ImageSize->{364, 236},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "10df6fb2-8120-41b3-82ec-8731c239a0b8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnVt7E8fW5/fM3LyX8xXmW8ztXM7tO8/cmiRAB3aCsjfZiJ2DEjCyjTEn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              "], {{0, 236}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 236}, 
            PlotRange -> {{0, 360}, {0, 236}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4d53ffe9-5caf-478e-ae6a-8f49146ec619"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5bec3482-b584-418f-b466-41f873400b21"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f579fb50-4dff-454b-be98-02dae0d6a2ee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c3d78893-fdfa-4edb-b092-febd5f0de7b3"],

Cell["\<\
Find the difference in air temperatures between Los Angeles and New York City \
now.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"cb6f2587-4e72-4f92-8d90-99efb0fa2f59"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9eae1959-a3d5-4228-a8e7-168cf610ed48"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVM9r2nAUL9tlxx32D+wv2HXXHXftsmuhZV07Ah02g6EX14N4KJQcQqHk
0ByqhyBKEFQQaUVQyCDCAguEEmpRkBKpSpRvMJC97zcxGmt22HH4+Cp537wf
n/fe5+X13tftz8+2traYF/C3vfv93fHxbvzDS1A+HjFfDo72P70/+rZ/sH/8
du85XL6C3xv44Wd3Ixv5d7F6utafzALdGd2166VWUzEn6x3sB61VkxpNZews
XQ6wV6Mpmyhk3Gtm2cRhpiBPsYa0Wq5cyPpHFK6V7sKydpakKTj5X0M/plFK
4Zsdch9TBzM3LPZ9yXPBJyGY5HKq57DKxIhvXA+qGNxAkJ+6IvoprHICB2fT
cfYkBiCFihZE7suSyMUgTvm3BwZdn0BMHqeYaDxNpS7lMBbUSEM0DgwcQwJH
UYZHqwpeacnGbb0TaOq8cjsvLZuk+bHrttKUQCwBzKmouZFyy9JU0QeDjVOi
6r3oFONe3iUs2jlN8bU7ogyLjId22QtVlyLAqxZHmpzgOsidg1HdKEHq6QLM
sMwsQpkyl6QPtWXmTDxjy9N08TDJCFB4r47HLdbVvo6nfH0f4o2DApWM6eLm
cWQ+DvrmYOi4YQmBcfUCnppwlS1expMrBJgbVw0fjFEAMFnMzIHMBkQ6yU0j
KycDDSzpHW1lR8JgQDeaknhxli/e6DIP9NOXq1zpTMHrTBd4woqy7Vp6HVwo
thA1CDLQK9lxZzZCNlrdDtfRMGd066ln+wJmnbNDxrfAGaHu7aPlc2YkAwB1
jrkDCGk8uygwEZxB8IUxFLyVmYrc0TX4RHRqHH9V7T101QqmQV7B/DVxi3Ya
hAntSyBkvH3fN+ocXkOogrA6xUn9EZo+KBkGNqtkr8v3NzBIXQyaHOh/h/TZ
O5mK79Wr/PDz4uZ08/O580XfYKxLp0GcNN9Da7ItwEQOcZ04aDwaTkNEn01H
VlgdjicrKWf25OnlRjby/8sfQooBag==
            "], {{0, 20}, {47, 0}}, {0, 255},
            
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{47, 20},
          PlotRange->{{0, 47}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{51, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bc2f6a2b-22ca-42b6-b6f2-a19f5f6d88a9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVM9r2nAUL9tlxx32D+wv2HXXHXftsmuhZV07Ah02g6EX14N4KJQcQqHk
0ByqhyBKEFQQaUVQyCDCAguEEmpRkBKpSpRvMJC97zcxGmt22HH4+Cp537wf
n/fe5+X13tftz8+2traYF/C3vfv93fHxbvzDS1A+HjFfDo72P70/+rZ/sH/8
du85XL6C3xv44Wd3Ixv5d7F6utafzALdGd2166VWUzEn6x3sB61VkxpNZews
XQ6wV6Mpmyhk3Gtm2cRhpiBPsYa0Wq5cyPpHFK6V7sKydpakKTj5X0M/plFK
4Zsdch9TBzM3LPZ9yXPBJyGY5HKq57DKxIhvXA+qGNxAkJ+6IvoprHICB2fT
cfYkBiCFihZE7suSyMUgTvm3BwZdn0BMHqeYaDxNpS7lMBbUSEM0DgwcQwJH
UYZHqwpeacnGbb0TaOq8cjsvLZuk+bHrttKUQCwBzKmouZFyy9JU0QeDjVOi
6r3oFONe3iUs2jlN8bU7ogyLjId22QtVlyLAqxZHmpzgOsidg1HdKEHq6QLM
sMwsQpkyl6QPtWXmTDxjy9N08TDJCFB4r47HLdbVvo6nfH0f4o2DApWM6eLm
cWQ+DvrmYOi4YQmBcfUCnppwlS1expMrBJgbVw0fjFEAMFnMzIHMBkQ6yU0j
KycDDSzpHW1lR8JgQDeaknhxli/e6DIP9NOXq1zpTMHrTBd4woqy7Vp6HVwo
thA1CDLQK9lxZzZCNlrdDtfRMGd066ln+wJmnbNDxrfAGaHu7aPlc2YkAwB1
jrkDCGk8uygwEZxB8IUxFLyVmYrc0TX4RHRqHH9V7T101QqmQV7B/DVxi3Ya
hAntSyBkvH3fN+ocXkOogrA6xUn9EZo+KBkGNqtkr8v3NzBIXQyaHOh/h/TZ
O5mK79Wr/PDz4uZ08/O580XfYKxLp0GcNN9Da7ItwEQOcZ04aDwaTkNEn01H
VlgdjicrKWf25OnlRjby/8sfQooBag==
              "], {{0, 20}, {47, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {47, 20}, 
            PlotRange -> {{0, 47}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"942cd2ab-1d79-477d-8387-6c98823d9d99"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4345913b-e5d4-42b0-86c0-6b66d13e495e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9d4a079d-f157-47e5-9620-ebf119db8ec0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a6b202d1-d162-48cc-93e1-1fb1b99f4df8"],

Cell["Plot the historical frequency of the word \[OpenCurlyDoubleQuote]groovy\
\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"a6e9522a-3b8f-4ac1-93e9-3fcebae4cc71"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"56e5d851-a21c-4fc3-be8b-38039ccec69d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndlfE2m37/vsc7Mvz7+w/4t9uy/P7T6fc/vStnZau9vYr93Gtwe6GwwO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            "], {{0, 214}, {360, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 214},
          PlotRange->{{0, 360}, {0, 214}}]], "ExerciseOutput",
         ImageSize->{364, 214},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "66aee26b-a2c4-4026-ab52-5e7a0aecad99"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndlfE2m37/vsc7Mvz7+w/4t9uy/P7T6fc/vStnZau9vYr93Gtwe6GwwO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              "], {{0, 214}, {
              360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 214}, 
            PlotRange -> {{0, 360}, {0, 214}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1b3a1f7a-c35f-4773-a21c-8d1959b97993"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["19.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"930f63a2-caa1-49fd-8bd7-113bd5bbd946"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"33db8ec3-7497-446d-ab4d-ed92d2c3f739"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"2ac8fac8-f73a-43f3-bad2-1a23ce8ba22c"],

Cell["Compute how many weeks have elapsed since January 1, 1900.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"f98b4d22-19f2-49bd-8e40-a8e47a9450cd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a11e26ea-3b71-42bb-8482-955b70aabdf8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVc9r2nAUL9tlxx32D+y/2HW77bplV2Fj3RyBDutg6CX1IB6E0IMIw0M9
qAcpHRKoQpBZpC1YUDBgIJQvRlSCKNUSQySB7H2/ac0PtdvO8/FVkvdN3vd9
3vt8Xp5/+Prm06OdnZ3wE/h78/77y/3995G3T+Hm3V74y+e93Y+v977tft7d
f/HhMTifwe8V/PC1tbWt/demDzqCMjM2bZuzvnDB189q8kR3O5HU1Vae9DrV
gSSi+yWPVO/jxhg5uwj1F5a1mPSR6xVYiuvQh2zejNNUsT1du6mhEkNTy/UL
QUz9MhUktwFx7pRijVMXkq53mVzTG1vlwq5dOijNLVQMuo+DFS8Kf4VCFw5p
iuusRTHlohCKHeB6TOu5gowv9BaXybMBhg5JLhSrTnPEQ27CxLBMw8TLF1wt
R6lDToSmuHYNU8e3cIW4kPeIP6BIbkBB0qBO2uqaLXRsV+8Bp9bJQhrIn/zS
xic0VUYbmGxep2kqXbleOlpHoeRRjQQzWrlInC3dEj+qHMTZU82FwhzW4N18
tetOQ0DXV9wxX6nJLu1oUmEVhc9Jbql4IpFNseVq0ycia445wIQjWfagWCzJ
Ew8cpXrA0AcDVwXkSgQ8MnjMboYwUJhZmC1hwjobhaRbuggQmMTxrScrTM7M
j1QaczjYmvwDikXvNEmHuCp/ybE4Dnu68FS7W4wGMrnjq4tSBgcPibPlXj9P
22RzPT7ExOB7htWDjgcg53xjaulY1GVJtVGU20I5RjHR7NifFVXv2VXqZl2R
/waFp7ZnCdgSN5F81ohj6t6zelTDk6Tnm05KkXBMBr0cnYs/Q0zqfNzJMHQE
N0gX0suZEHMagYuJswoIdyVSy2FnYiwQSdh7js8JOl1u3TRSKygMhy/zJlTy
5F6bygX0LoJWRqyYCzIxNhuFiaqa+KzIyY8AkzjFce5QJFptHkKlPX3E8JlE
QZ6MpSpmBY9Uc64g6VqoQG0DfFNASMFUXXXa8izWlMl40C4lSYlAGuMGVC9Q
78FkhtanxJ5yMxS4BB7RV6M71BLM23DBryOsU5vhpBqmSNRB5S/6pA5YZXY3
5QpoirocOjU0R+fLTuUrgnUneddID2dv1zsNuVFwvhexFCKNGJAjgMnasJGP
OR8Lvu1wGQFbomtQgHJx5rECIYxex4P9XqpE1FzHHqdj/IGIlTwytAxtNtX0
jR/3B83Q5r53IZozuk1dvZ2rG4fx1ra2ta1tsN/5EQtK
            "], {{0, 20}, {66, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{66, 20},
          PlotRange->{{0, 66}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{70, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "931ccdf9-be32-43b3-9912-618abb7d7142"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVc9r2nAUL9tlxx32D+y/2HW77bplV2Fj3RyBDutg6CX1IB6E0IMIw0M9
qAcpHRKoQpBZpC1YUDBgIJQvRlSCKNUSQySB7H2/ac0PtdvO8/FVkvdN3vd9
3vt8Xp5/+Prm06OdnZ3wE/h78/77y/3995G3T+Hm3V74y+e93Y+v977tft7d
f/HhMTifwe8V/PC1tbWt/demDzqCMjM2bZuzvnDB189q8kR3O5HU1Vae9DrV
gSSi+yWPVO/jxhg5uwj1F5a1mPSR6xVYiuvQh2zejNNUsT1du6mhEkNTy/UL
QUz9MhUktwFx7pRijVMXkq53mVzTG1vlwq5dOijNLVQMuo+DFS8Kf4VCFw5p
iuusRTHlohCKHeB6TOu5gowv9BaXybMBhg5JLhSrTnPEQ27CxLBMw8TLF1wt
R6lDToSmuHYNU8e3cIW4kPeIP6BIbkBB0qBO2uqaLXRsV+8Bp9bJQhrIn/zS
xic0VUYbmGxep2kqXbleOlpHoeRRjQQzWrlInC3dEj+qHMTZU82FwhzW4N18
tetOQ0DXV9wxX6nJLu1oUmEVhc9Jbql4IpFNseVq0ycia445wIQjWfagWCzJ
Ew8cpXrA0AcDVwXkSgQ8MnjMboYwUJhZmC1hwjobhaRbuggQmMTxrScrTM7M
j1QaczjYmvwDikXvNEmHuCp/ybE4Dnu68FS7W4wGMrnjq4tSBgcPibPlXj9P
22RzPT7ExOB7htWDjgcg53xjaulY1GVJtVGU20I5RjHR7NifFVXv2VXqZl2R
/waFp7ZnCdgSN5F81ohj6t6zelTDk6Tnm05KkXBMBr0cnYs/Q0zqfNzJMHQE
N0gX0suZEHMagYuJswoIdyVSy2FnYiwQSdh7js8JOl1u3TRSKygMhy/zJlTy
5F6bygX0LoJWRqyYCzIxNhuFiaqa+KzIyY8AkzjFce5QJFptHkKlPX3E8JlE
QZ6MpSpmBY9Uc64g6VqoQG0DfFNASMFUXXXa8izWlMl40C4lSYlAGuMGVC9Q
78FkhtanxJ5yMxS4BB7RV6M71BLM23DBryOsU5vhpBqmSNRB5S/6pA5YZXY3
5QpoirocOjU0R+fLTuUrgnUneddID2dv1zsNuVFwvhexFCKNGJAjgMnasJGP
OR8Lvu1wGQFbomtQgHJx5rECIYxex4P9XqpE1FzHHqdj/IGIlTwytAxtNtX0
jR/3B83Q5r53IZozuk1dvZ2rG4fx1ra2ta1tsN/5EQtK
              "], {{0, 20}, {66, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {66, 20}, 
            PlotRange -> {{0, 66}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5dcc897d-4b47-461e-b050-a6ab68724f26"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e6b85e7d-413a-4405-a344-7c8cbd6f6e47"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3177aa39-0587-4cd1-b16c-9db4dbf38411"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6503c93c-1dc1-4afb-81b3-d869d807017c"],

Cell["Compute the time between 3 pm today and sunset today.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"dcf51b16-3962-4540-88fd-e4d72a1067ad"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"05f19357-e6c6-47b2-9cac-ef74073daf1c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiMWAGMT+P7LAj6fXLr/4+JuQsg8PQcp+YJH5eq41O2TVpQ/49V9fVVif
HdK65Bw2J1yekB2y+Ro+E34+2gbUDkQT1l/GakI30IRbIOf9/PrlDxYVL9YV
h9RXVU4rDulehd0EoBuW7ti2qgpkS31x+623KGFyb3MlUPz0sxf7G0NacZgw
DezCpXtP3bu0EWgaskV/nu0GSR17AWTvrgrpXn8HlxtWnXoD5vw+3B5S37ft
J1Tuy+5GkOELlizYvGrKBJBFhdtPPcEeDte+QN28vrC+eMEnuNyOZZvXL9u8
CmjC7AnFIBN2n8NlwgeYCRn1xcu+YXHrb7AvrgNZb07Nrs+OO/wIlja+YpoA
dwMy+LK9KmTCZpAJT3c0AL22/dYXmBuuT0MxobC+cQ02N6C459vHLwSUjAKq
AgB2aspA
            "], {{0, 20}, {22, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{22, 20},
          PlotRange->{{0, 22}, {0, 20}}]], "ExerciseOutput",
         ImageSize->{26, 20},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "106b19dc-1d26-493c-8f3f-bf366a3f26c9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiMWAGMT+P7LAj6fXLr/4+JuQsg8PQcp+YJH5eq41O2TVpQ/49V9fVVif
HdK65Bw2J1yekB2y+Ro+E34+2gbUDkQT1l/GakI30IRbIOf9/PrlDxYVL9YV
h9RXVU4rDulehd0EoBuW7ti2qgpkS31x+623KGFyb3MlUPz0sxf7G0NacZgw
DezCpXtP3bu0EWgaskV/nu0GSR17AWTvrgrpXn8HlxtWnXoD5vw+3B5S37ft
J1Tuy+5GkOELlizYvGrKBJBFhdtPPcEeDte+QN28vrC+eMEnuNyOZZvXL9u8
CmjC7AnFIBN2n8NlwgeYCRn1xcu+YXHrb7AvrgNZb07Nrs+OO/wIlja+YpoA
dwMy+LK9KmTCZpAJT3c0AL22/dYXmBuuT0MxobC+cQ02N6C459vHLwSUjAKq
AgB2aspA
              "], {{0, 20}, {22, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {22, 20}, 
            PlotRange -> {{0, 22}, {0, 20}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d51192e1-3e09-4b33-8839-2d24d3c9bdcd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d76893b2-396a-47a7-a199-493cfe192f8e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ecbb0e4f-f5c2-4c45-8554-73f0449b1247"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f45425af-4aa5-4b7d-bba3-d277d588a29c"],

Cell["\<\
Generate an icon of the phase of the moon on August 29, 1959.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"265bfa68-aaaa-4295-827a-141221a1c044"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5be5d86e-4777-4f03-9621-a0921e4a8e12"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnclOI0cYx1FyyTGvkLfINcdcJ8oDzGjIKBciMZGiPAqEYHYM2GbfFxuE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            "], {{0, 100}, {100, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{100, 100},
          PlotRange->{{0, 100}, {0, 100}}]], "ExerciseOutput",
         ImageSize->{104, 100},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "78a8df4c-8d77-469f-a8c2-22a5c0310564"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnclOI0cYx1FyyTGvkLfINcdcJ8oDzGjIKBciMZGiPAqEYHYM2GbfFxuE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              "], {{0, 100}, {100, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {100, 100}, 
            PlotRange -> {{0, 100}, {0, 100}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c63476dd-5093-421c-a5f6-e33aacd09c47"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0d4140a6-f56f-4700-9d01-51400373fc4e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"957adc21-ff25-4f61-b359-62aba5dfa5f4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ef708e27-45a9-4791-aded-bb62633bd627"],

Cell["\<\
Make a line plot of the numerical phase of the moon for each of the next 30 \
days.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"20dbc985-2bc9-438b-819e-3813c7e95a77"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fe4e3d55-cf5c-4643-b36e-03b05e2c9757"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3dtfE3efB/Du7s1e7r+w/8Xe7uXe7r729kFFR6017WPbuH1s2gJBOapR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            "], {{0, 229}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 229},
          PlotRange->{{0, 360}, {0, 229}}]], "ExerciseOutput",
         ImageSize->{364, 229},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cd5091de-e3c7-42ae-a263-3aaa6b79817d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3dtfE3efB/Du7s1e7r+w/8Xe7uXe7r729kFFR6017WPbuH1s2gJBOapR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              "], {{0, 229}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 229}, 
            PlotRange -> {{0, 360}, {0, 229}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"34b63dce-67d0-4877-9a1c-9d372dbad81e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c548198d-6cae-48a9-8207-ff0ec736faad"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"13a8302f-ea25-4c15-bc6c-db839d99b89b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a2e0c6cf-5873-4996-855c-b6e143b14859"],

Cell[TextData[{
 "Make a ",
 StyleBox["Manipulate",
  FontFamily->"Source Sans Pro"],
 " of the icon for the moon phase over the next 15 days."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"0c0d6ba5-3cc0-40b8-9cea-bebbaf65af1a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"106845bb-be13-4e18-8b0d-e2ef78054dc4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnd1PW+cdx9F2s8v9C7vrPzApt73YpN122h/Qqlk1TerUdFLV6970YpO6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            "], {{0, 196}, {247, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
            Association[{
              "Exif" -> Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com"}], 
               "Comments" -> 
               Association[{
                 "Software" -> 
                  "Created with the Wolfram Language : www.wolfram.com", 
                  "Creation Time" -> 
                  DateObject[{2017, 7, 10, 15, 22, 53.}, "Instant", 
                    "Gregorian", -5.]}]}]],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{247, 196},
          PlotRange->{{0, 247}, {0, 196}}]], "ExerciseOutput",ExpressionUUID->
         "9bfb22ae-3815-479b-a723-f3007cec1121"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnd1PW+cdx9F2s8v9C7vrPzApt73YpN122h/Qqlk1TerUdFLV6970YpO6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              "], {{0, 196}, {247, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True, 
              MetaInformation -> 
              Association[{
                "Exif" -> Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com"}], 
                 "Comments" -> 
                 Association[{
                   "Software" -> 
                    "Created with the Wolfram Language : www.wolfram.com", 
                    "Creation Time" -> 
                    DateObject[{2017, 7, 10, 15, 22, 53.}, "Instant", 
                    "Gregorian", -5.]}]}]], Selectable -> False], ImageSize -> 
            Magnification[1], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {247, 196}, PlotRange -> {{0, 247}, {0, 196}}]], 
          "ExerciseOutput", Magnification -> 1, CellFrameColor -> 
          GrayLevel[0], Selectable -> False, Copyable -> False, Editable -> 
          False, ShowCellBracket -> False, CellLabel -> "Out[]=", CellFrame -> 
          False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cd93273f-1718-4c38-a64d-61eb6f41a538"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"68c217e5-429e-4bd8-a0f1-e4e3eb963a40"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d8d80a99-7635-463b-a356-6bb3f27c54d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fef9ae52-08fe-4506-b46c-5a6019a31781"],

Cell["\<\
Show in a column the times of sunrise for 10 days, starting today.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"d4d0522f-7301-4978-8ac2-82652b100fd1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"215602e3-84af-4770-9b90-51e94ece2e38"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztndtPY9t9x0/blz72X+hj/4O+dt6aVLWUqNK4bw5NKyyUyA5qoLKKVWSq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            "], {{0, 297}, {
            237, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{237, 297},
          PlotRange->{{0, 237}, {0, 297}}]], "ExerciseOutput",
         ImageSize->{241, 297},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b66c985a-73a1-4c02-b573-018f15ef0f2e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztndtPY9t9x0/blz72X+hj/4O+dt6aVLWUqNK4bw5NKyyUyA5qoLKKVWSq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              "], {{0, 
              297}, {237, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {237, 297}, 
            PlotRange -> {{0, 237}, {0, 297}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b9cdd0c2-f71d-4585-88cc-983c7d2ed464"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3b745659-8a2c-4c2c-b39d-48a0ba9a098b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"293211dc-761f-4476-85ee-cf017b1dc82c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"02cd8f4a-3c94-4dfc-bfe5-af3b82b372c8"],

Cell["\<\
Plot together the historical frequencies of the words \
\[OpenCurlyDoubleQuote]science\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]technology\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"d8a70f77-1260-4e45-8e1b-ba3ac657260b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b2ec9fd7-3e9a-42e4-8915-9f2d976b19ca"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvftfU1maL+z7vr+8P77/wvv51HRP1zvHuZyZ7jmn+8wc+8y8czkz48x0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            "], {{0, 
            220}, {475, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{475, 220},
          PlotRange->{{0, 475}, {0, 220}}]], "ExerciseOutput",
         ImageSize->{479, 220},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "de9dc839-3162-4607-a59b-b7226fc55162"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvftfU1maL+z7vr+8P77/wvv51HRP1zvHuZyZ7jmn+8wc+8y8czkz48x0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              "], {{0, 
              220}, {475, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {475, 220}, 
            PlotRange -> {{0, 475}, {0, 220}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aeb12140-f983-4b2d-a624-f49d35722711"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x19.7"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"afe49f8f-9421-404d-8106-5aa5a708d187"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9688680e-8c44-44f6-8ac9-c756ea8a7e6b"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3c6b0887-5f7e-4fd6-a8f3-6ed4b48cd013"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Dates and Times: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[" 19  Dates and Times", "DockedCellSectionTitle"]},
                  "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
19-dates-and-times.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+19.1", "19.1", "19.10", "19.11", "19.12", "19.13", "+19.2", "19.2", 
         "+19.3", "19.3", "+19.4", "19.4", "+19.5", "19.5", "+19.6", "19.6", 
         "+19.7", "19.7", "19.8", "19.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+19.1", "19.1", "19.10", "19.11", "19.12", "19.13", "+19.2", "19.2", 
      "+19.3", "19.3", "+19.4", "19.4", "+19.5", "19.5", "+19.6", "19.6", 
      "+19.7", "19.7", "19.8", "19.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[8334, 208, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e10e57bc-28ca-4153-a0fc-d52692c72907",
   CellTags->"FirstInputCell"],
  Cell[16010, 418, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7d7877dc-44a4-49d8-8ac9-efa5c84a6a27",
   CellTags->"FirstInputCell"],
  Cell[27716, 695, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f80bc7a6-b73b-4c23-9ca8-c58fc7178778",
   CellTags->"FirstInputCell"],
  Cell[39555, 974, 813, 26, 
  70, "Input", "ExpressionUUID" -> "65eb570a-0d63-45ab-b7cb-16dd5377ba91",
   CellTags->"FirstInputCell"],
  Cell[47058, 1183, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d4821280-15af-4723-97ca-676080f9b118",
   CellTags->"FirstInputCell"],
  Cell[57088, 1432, 813, 26, 
  70, "Input", "ExpressionUUID" -> "98fb77e8-94b1-4751-998e-f265fd80ea8c",
   CellTags->"FirstInputCell"],
  Cell[70767, 1742, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6b4344ad-e164-4a76-876e-addddc69a21d",
   CellTags->"FirstInputCell"],
  Cell[111945, 2504, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d999d317-97ba-40e9-acd9-a302b582461b",
   CellTags->"FirstInputCell"],
  Cell[119572, 2715, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3bdfe26d-1296-4351-88b6-b1badc4e7f16",
   CellTags->"FirstInputCell"],
  Cell[127362, 2929, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e78b1ee8-e474-4f31-bf5c-296fd88e72fb",
   CellTags->"FirstInputCell"],
  Cell[175080, 3797, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f579fb50-4dff-454b-be98-02dae0d6a2ee",
   CellTags->"FirstInputCell"],
  Cell[182867, 4012, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9d4a079d-f157-47e5-9620-ebf119db8ec0",
   CellTags->"FirstInputCell"],
  Cell[216250, 4643, 813, 26, 
  70, "Input", "ExpressionUUID" -> "33db8ec3-7497-446d-ab4d-ed92d2c3f739",
   CellTags->"FirstInputCell"],
  Cell[224514, 4863, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3177aa39-0587-4cd1-b16c-9db4dbf38411",
   CellTags->"FirstInputCell"],
  Cell[231224, 5058, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ecbb0e4f-f5c2-4c45-8554-73f0449b1247",
   CellTags->"FirstInputCell"],
  Cell[241420, 5311, 813, 26, 
  70, "Input", "ExpressionUUID" -> "957adc21-ff25-4f61-b359-62aba5dfa5f4",
   CellTags->"FirstInputCell"],
  Cell[268190, 5837, 813, 26, 
  70, "Input", "ExpressionUUID" -> "13a8302f-ea25-4c15-bc6c-db839d99b89b",
   CellTags->"FirstInputCell"],
  Cell[283673, 6184, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d8d80a99-7635-463b-a356-6bb3f27c54d4",
   CellTags->"FirstInputCell"],
  Cell[311861, 6732, 813, 26, 
  70, "Input", "ExpressionUUID" -> "293211dc-761f-4476-85ee-cf017b1dc82c",
   CellTags->"FirstInputCell"],
  Cell[379626, 7928, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9688680e-8c44-44f6-8ac9-c756ea8a7e6b",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 438653, 9149}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[636, 21, 490, 10, 70, "Exercise", "ExpressionUUID" -> \
"faa79338-0a1e-4df9-a7a8-b5e8f1a9ab73",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1151, 35, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"948dd963-3acf-41c6-817e-e974d5d32344"],
Cell[1810, 57, 5917, 126, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ace78a9a-9c02-4ede-98b1-9da83d965a32"]
}, Closed]],
Cell[CellGroupData[{
Cell[7764, 188, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"07898586-2279-4ad3-a975-0626160ec555"],
Cell[8334, 208, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e10e57bc-28ca-4153-a0fc-d52692c72907",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9184, 239, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"eb5bfcda-88bc-4405-96d1-c58387cf72a8"],
Cell[9471, 250, 482, 10, 70, "Exercise", "ExpressionUUID" -> \
"153a388d-e5d0-4c4e-8b1c-811726afdf9a",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[9978, 264, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3905c5ab-927a-43b6-abb9-eafb92d7c16b"],
Cell[10637, 286, 4766, 107, 70, "ExerciseOutput", "ExpressionUUID" -> \
"eed66d4c-ae2f-4af2-a1a8-6ecb39b02315"]
}, Closed]],
Cell[CellGroupData[{
Cell[15440, 398, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"9beefff5-5b44-4c05-9d98-4aa6760ddfb2"],
Cell[16010, 418, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7d7877dc-44a4-49d8-8ac9-efa5c84a6a27",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16872, 450, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c9589821-04b3-4fad-9429-eabb676690f2"],
Cell[17159, 461, 475, 10, 70, "Exercise", "ExpressionUUID" -> \
"b0a8aa41-defe-41e2-ae36-d1809288f350",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17659, 475, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9e359aa7-889b-4341-9cc2-212890026827"],
Cell[18318, 497, 8791, 173, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8fa3147e-62ba-4eb2-bb82-701d6d576b0c"]
}, Closed]],
Cell[CellGroupData[{
Cell[27146, 675, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"c5450494-a4f7-4a2e-ba9f-19daa19860e2"],
Cell[27716, 695, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f80bc7a6-b73b-4c23-9ca8-c58fc7178778",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28578, 727, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"19b58f5a-2d62-49d3-a6db-9f7a23aacaf1"],
Cell[28865, 738, 462, 10, 70, "Exercise", "ExpressionUUID" -> \
"5689c1b2-936f-45e1-b8ed-dc4836de8013",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[29352, 752, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a39ef746-4c3f-4da4-b75d-d06708e015ee"],
Cell[30011, 774, 8937, 175, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ac547782-c295-45ec-b5aa-2a805125c211"]
}, Closed]],
Cell[CellGroupData[{
Cell[38985, 954, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bff72663-f68c-4867-a89f-852c4a00fdf6"],
Cell[39555, 974, 813, 26, 70, "Input", "ExpressionUUID" -> \
"65eb570a-0d63-45ab-b7cb-16dd5377ba91",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40417, 1006, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6414024f-4db3-487e-996a-75f663e46940"],
Cell[40704, 1017, 562, 13, 70, "Exercise", "ExpressionUUID" -> \
"964e1d0e-6085-4d7d-b44a-fe3c0056ca43",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[41291, 1034, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6832eca6-5be6-4e63-93e9-bb5e77f2b5ee"],
Cell[41950, 1056, 4501, 102, 70, "ExerciseOutput", "ExpressionUUID" -> \
"455c5ef1-c7f7-492d-804c-6cbcfc794722"]
}, Closed]],
Cell[CellGroupData[{
Cell[46488, 1163, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"1b047468-a599-459a-b255-67968956c2c3"],
Cell[47058, 1183, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d4821280-15af-4723-97ca-676080f9b118",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47920, 1215, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4273b3a7-6506-42d2-b254-8b13a2c617ce"],
Cell[48207, 1226, 484, 10, 70, "Exercise", "ExpressionUUID" -> \
"a9eaa49d-b2b5-46ec-aa00-edc73b7c4cb4",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[48716, 1240, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f2975a44-838b-4c40-be0f-536a233c0972"],
Cell[49375, 1262, 7106, 145, 70, "ExerciseOutput", "ExpressionUUID" -> \
"613f53a9-3b44-4386-afd3-ec68ab99b010"]
}, Closed]],
Cell[CellGroupData[{
Cell[56518, 1412, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2fae19c0-b60e-4e04-a849-f7e47952bf08"],
Cell[57088, 1432, 813, 26, 70, "Input", "ExpressionUUID" -> \
"98fb77e8-94b1-4751-998e-f265fd80ea8c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57950, 1464, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e43a2d90-27e4-4b34-8e90-543d5a897d58"],
Cell[58237, 1475, 517, 12, 70, "Exercise", "ExpressionUUID" -> \
"da8af85b-251b-4bef-9d92-988766bf62f5",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[58779, 1491, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1b69a55d-e4b0-49c3-86bf-b8d76fba352e"],
Cell[59438, 1513, 10722, 204, 70, "ExerciseOutput", "ExpressionUUID" -> \
"6f8b8686-f83f-44ac-8dc5-a1cdfbc30b84"]
}, Closed]],
Cell[CellGroupData[{
Cell[70197, 1722, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6c782bed-de7f-4412-88a5-d862b64de0aa"],
Cell[70767, 1742, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6b4344ad-e164-4a76-876e-addddc69a21d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71629, 1774, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3529f094-ef97-4395-b56f-8f5f93c5e02e"],
Cell[71916, 1785, 522, 13, 70, "Exercise", "ExpressionUUID" -> \
"884fe5d0-e941-46e6-9026-53b343358673",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[72463, 1802, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"849591e1-81f4-4430-af94-4b85dbbac0c8"],
Cell[73122, 1824, 38216, 655, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1554882d-4b5b-499f-8a7a-d8d1ee0e0af1"]
}, Closed]],
Cell[CellGroupData[{
Cell[111375, 2484, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"2902536c-71c6-4b34-a29d-2735a9b8f652"],
Cell[111945, 2504, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d999d317-97ba-40e9-acd9-a302b582461b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112807, 2536, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"742857c6-cbc8-4a8a-816b-9970020b18e7"],
Cell[113094, 2547, 511, 12, 70, "Exercise", "ExpressionUUID" -> \
"ce8df59c-d091-407d-a7bb-8f50aa538f8a",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[113630, 2563, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6b580c06-0468-4b7c-be39-c698bcab44d8"],
Cell[114289, 2585, 4676, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7ab30471-2356-48af-bb3b-30fc66a3261f"]
}, Closed]],
Cell[CellGroupData[{
Cell[119002, 2695, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b26526ea-75ae-41f6-bf8a-21eaf78c2d64"],
Cell[119572, 2715, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3bdfe26d-1296-4351-88b6-b1badc4e7f16",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120434, 2747, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"aa82534d-944e-418d-b489-7048948df576"],
Cell[120721, 2758, 506, 12, 70, "Exercise", "ExpressionUUID" -> \
"95b410d6-79aa-4893-97c5-db65adb7bdfe",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[121252, 2774, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"03a35670-8e80-4dae-bb65-b19105d0a32e"],
Cell[121911, 2796, 4843, 108, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7ab0dc9a-01b5-4ade-b8e9-2a223cadb7bb"]
}, Closed]],
Cell[CellGroupData[{
Cell[126791, 2909, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"fbd025a0-9d0d-4493-89ec-507620c5389d"],
Cell[127362, 2929, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e78b1ee8-e474-4f31-bf5c-296fd88e72fb",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128224, 2961, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f916d7ca-0f93-4a03-b0c2-7f9c2658f623"],
Cell[128511, 2972, 497, 11, 70, "Exercise", "ExpressionUUID" -> \
"15a623f0-805a-4900-bc70-b9f3a3ab7370",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[129033, 2987, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"611495fb-1bc3-404a-9251-625613782348"],
Cell[129692, 3009, 44780, 763, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4d53ffe9-5caf-478e-ae6a-8f49146ec619"]
}, Closed]],
Cell[CellGroupData[{
Cell[174509, 3777, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"5bec3482-b584-418f-b466-41f873400b21"],
Cell[175080, 3797, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f579fb50-4dff-454b-be98-02dae0d6a2ee",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175942, 3829, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c3d78893-fdfa-4edb-b092-febd5f0de7b3"],
Cell[176229, 3840, 527, 13, 70, "Exercise", "ExpressionUUID" -> \
"cb6f2587-4e72-4f92-8d90-99efb0fa2f59",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[176781, 3857, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"9eae1959-a3d5-4228-a8e7-168cf610ed48"],
Cell[177440, 3879, 4819, 108, 70, "ExerciseOutput", "ExpressionUUID" -> \
"942cd2ab-1d79-477d-8387-6c98823d9d99"]
}, Closed]],
Cell[CellGroupData[{
Cell[182296, 3992, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"4345913b-e5d4-42b0-86c0-6b66d13e495e"],
Cell[182867, 4012, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9d4a079d-f157-47e5-9620-ebf119db8ec0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[183729, 4044, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a6b202d1-d162-48cc-93e1-1fb1b99f4df8"],
Cell[184016, 4055, 485, 10, 70, "Exercise", "ExpressionUUID" -> \
"a6e9522a-3b8f-4ac1-93e9-3fcebae4cc71",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[184526, 4069, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"56e5d851-a21c-4fc3-be8b-38039ccec69d"],
Cell[185165, 4090, 30477, 528, 70, "ExerciseOutput", "ExpressionUUID" -> \
"1b3a1f7a-c35f-4773-a21c-8d1959b97993"]
}, Closed]],
Cell[CellGroupData[{
Cell[215679, 4623, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"930f63a2-caa1-49fd-8bd7-113bd5bbd946"],
Cell[216250, 4643, 813, 26, 70, "Input", "ExpressionUUID" -> \
"33db8ec3-7497-446d-ab4d-ed92d2c3f739",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[217112, 4675, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"2ac8fac8-f73a-43f3-bad2-1a23ce8ba22c"],
Cell[217399, 4686, 492, 10, 70, "Exercise", "ExpressionUUID" -> \
"f98b4d22-19f2-49bd-8e40-a8e47a9450cd",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[217916, 4700, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a11e26ea-3b71-42bb-8482-955b70aabdf8"],
Cell[218575, 4722, 5331, 116, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5dcc897d-4b47-461e-b050-a6ab68724f26"]
}, Closed]],
Cell[CellGroupData[{
Cell[223943, 4843, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"e6b85e7d-413a-4405-a344-7c8cbd6f6e47"],
Cell[224514, 4863, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3177aa39-0587-4cd1-b16c-9db4dbf38411",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[225376, 4895, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6503c93c-1dc1-4afb-81b3-d869d807017c"],
Cell[225663, 4906, 487, 10, 70, "Exercise", "ExpressionUUID" -> \
"dcf51b16-3962-4540-88fd-e4d72a1067ad",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[226175, 4920, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"05f19357-e6c6-47b2-9cac-ef74073daf1c"],
Cell[226834, 4942, 3782, 91, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d51192e1-3e09-4b33-8839-2d24d3c9bdcd"]
}, Closed]],
Cell[CellGroupData[{
Cell[230653, 5038, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"d76893b2-396a-47a7-a199-493cfe192f8e"],
Cell[231224, 5058, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ecbb0e4f-f5c2-4c45-8554-73f0449b1247",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[232086, 5090, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f45425af-4aa5-4b7d-bba3-d277d588a29c"],
Cell[232373, 5101, 503, 12, 70, "Exercise", "ExpressionUUID" -> \
"265bfa68-aaaa-4295-827a-141221a1c044",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[232901, 5117, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5be5d86e-4777-4f03-9621-a0921e4a8e12"],
Cell[233560, 5139, 7252, 147, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c63476dd-5093-421c-a5f6-e33aacd09c47"]
}, Closed]],
Cell[CellGroupData[{
Cell[240849, 5291, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"0d4140a6-f56f-4700-9d01-51400373fc4e"],
Cell[241420, 5311, 813, 26, 70, "Input", "ExpressionUUID" -> \
"957adc21-ff25-4f61-b359-62aba5dfa5f4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[242282, 5343, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ef708e27-45a9-4791-aded-bb62633bd627"],
Cell[242569, 5354, 525, 13, 70, "Exercise", "ExpressionUUID" -> \
"20dbc985-2bc9-438b-819e-3813c7e95a77",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[243119, 5371, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"fe4e3d55-cf5c-4643-b36e-03b05e2c9757"],
Cell[243778, 5393, 23804, 419, 70, "ExerciseOutput", "ExpressionUUID" -> \
"34b63dce-67d0-4877-9a1c-9d372dbad81e"]
}, Closed]],
Cell[CellGroupData[{
Cell[267619, 5817, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"c548198d-6cae-48a9-8207-ff0ec736faad"],
Cell[268190, 5837, 813, 26, 70, "Input", "ExpressionUUID" -> \
"13a8302f-ea25-4c15-bc6c-db839d99b89b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[269052, 5869, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a2e0c6cf-5873-4996-855c-b6e143b14859"],
Cell[269339, 5880, 573, 15, 70, "Exercise", "ExpressionUUID" -> \
"0c0d6ba5-3cc0-40b8-9cea-bebbaf65af1a",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[269937, 5899, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"106845bb-be13-4e18-8b0d-e2ef78054dc4"],
Cell[270596, 5921, 12469, 238, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cd93273f-1718-4c38-a64d-61eb6f41a538"]
}, Closed]],
Cell[CellGroupData[{
Cell[283102, 6164, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"68c217e5-429e-4bd8-a0f1-e4e3eb963a40"],
Cell[283673, 6184, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d8d80a99-7635-463b-a356-6bb3f27c54d4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[284535, 6216, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fef9ae52-08fe-4506-b46c-5a6019a31781"],
Cell[284822, 6227, 508, 12, 70, "Exercise", "ExpressionUUID" -> \
"d4d0522f-7301-4978-8ac2-82652b100fd1",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[285355, 6243, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"215602e3-84af-4770-9b90-51e94ece2e38"],
Cell[286014, 6265, 25239, 442, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b9cdd0c2-f71d-4585-88cc-983c7d2ed464"]
}, Closed]],
Cell[CellGroupData[{
Cell[311290, 6712, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"3b745659-8a2c-4c2c-b39d-48a0ba9a098b"],
Cell[311861, 6732, 813, 26, 70, "Input", "ExpressionUUID" -> \
"293211dc-761f-4476-85ee-cf017b1dc82c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[312723, 6764, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"02cd8f4a-3c94-4dfc-bfe5-af3b82b372c8"],
Cell[313010, 6775, 569, 13, 70, "Exercise", "ExpressionUUID" -> \
"d8a70f77-1260-4e45-8e1b-ba3ac657260b",
 CounterAssignments->{{"SectionNumber", 19}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[313604, 6792, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b2ec9fd7-3e9a-42e4-8915-9f2d976b19ca"],
Cell[314243, 6813, 64775, 1090, 70, "ExerciseOutput", "ExpressionUUID" -> \
"aeb12140-f983-4b2d-a624-f49d35722711"]
}, Closed]],
Cell[CellGroupData[{
Cell[379055, 7908, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"afe49f8f-9421-404d-8106-5aa5a708d187"],
Cell[379626, 7928, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9688680e-8c44-44f6-8ac9-c756ea8a7e6b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[380466, 7958, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3c6b0887-5f7e-4fd6-a8f3-6ed4b48cd013"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ATGH@6MSSGRbTjYb0vmcWTdM *)
